<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class MdController extends Controller
{
    //门店列表
    public function list()
    {
        $md = DB::table('md') -> get();
        return view('Admin.md',['md'=>$md]);
    }
    //添加门店
    public function create(Request $req) 
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $md['md_name'] = $req -> md_name;
        $md['md_address'] = $req -> md_address;
        $md['md_map'] = $req -> md_map;
        $md['md_phone'] = $req -> md_phone;
        $md['up_price'] = $req -> up_price;
        $md['peisong_price'] = $req -> peisong_price;
        $md['peisong_fanwei'] = $req -> peisong_fanwei;
        $md['peisong_service'] = $req -> peisong_service;
        $md['online_time'] = $req -> online_time ;
        $is = DB::table('md') -> insert($md);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //编辑信息拿取
    public function edit(Request $req)
    {
        if(!$req -> id) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $md = DB::table('md') -> where('id',$req -> id) -> first();
        return $md ? ['code' => '1000','msg' => 'OK','result' => $md] : ['code' => '1001','msg' => 'err','result' => []];
    }
    //更新门店
    public function update(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'请填写完整信息'];
        }
        $id = $req -> id;
        $md['md_name'] = $req -> md_name;
        $md['md_address'] = $req -> md_address;
        $md['md_map'] = $req -> md_map;
        $md['md_phone'] = $req -> md_phone;
        $md['up_price'] = $req -> up_price;
        $md['peisong_price'] = $req -> peisong_price;
        $md['peisong_fanwei'] = $req -> peisong_fanwei;
        $md['peisong_service'] = $req -> peisong_service;
        $md['online_time'] = $req -> online_time ;
        $is = DB::table('md') -> where('id',$id) -> update($md);
        return $is ? ['code'=> '1000','msg'=>'修改成功'] : ['code'=> '1002','msg'=>'内容无改变'];
    }
    //门店状态
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('md') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('md') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('md') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
}
