<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class OrderController extends Controller
{
    //  订单列表
    public function list() {
        $order = DB::table('order') -> orderBy('order_time','desc') -> get();
        $all_goods = [];
        if($order) {
            $goods_id = [];
            foreach($order as $key => $val) {
                $goods_id = DB::table('order_goods') -> where('order_id',$val -> order_id) -> pluck('goods_id');
                $goods_name = [];
                if($goods_id) {
                    $goods = DB::table('goods') -> whereIn('id',$goods_id) -> get();
                    if($goods) {
                        foreach($goods as $k => $v) {
                            $goods_name[$key] = $v -> goods_name;
                        }
                    }
                }
                $all_goods[$key]['order_id'] = $val -> order_id;
                $all_goods[$key]['goods_name'] = implode(',',$goods_name);
                $all_goods[$key]['price'] = $val -> price / 100;
                $all_goods[$key]['date'] = date('Y.m.d H:i:s',$val -> order_time);
                $all_goods[$key]['status'] = $val -> status;
                $all_goods[$key]['id'] = $val -> id;
                $all_goods[$key]['goods_date'] = $val -> goods_date;
                $all_goods[$key]['order_type'] = $val -> order_type;
                $user = DB::table('user') -> where('id',$val -> user_id) -> first();
                $all_goods[$key]['nickname'] = $user -> nickname;
                $all_goods[$key]['header'] = $user -> header;
                $all_goods[$key]['phone'] = $user -> phone;
            }
            
        }
        return view('Admin.order-list',['order' => $all_goods]);
    }
    //订单状态操作
    public function status(Request $req)
    {
        if(!in_array('',$req -> all())) {
            $id = $req -> id;
            $status = $req -> status;
            //查询订单信息
            $order = DB::table('order') -> where('id',$id) -> first();
            if(!$order) {
                return ['code' => '1001','msg'=>'err','result' => '订单查询失败'];
            }
            $is = 0;
            if($order -> status == 1) {
                //更改为2
                $is = DB::table('order') -> where('id',$id) -> update(['status' => 2]);
            }elseif($order -> status == 2 && $order -> order_type == 'peisong'){
                //自取订单，去了直接完成
                $is = DB::table('order') -> where('id',$id) -> update(['status' => 4]);
            }elseif($order -> status == 2 && $order -> order_type == 'peisong-active'){
                //配送订单，直接发货状态
                $is = DB::table('order') -> where('id',$id) -> update(['status' => 3]);
            }elseif($order -> status == 3){   //肯定为配送订单
                //配送订单，待送达状态
                $is = DB::table('order') -> where('id',$id) -> update(['status' => 4]);
            }
            return $is ? ['code' => '1000','msg'=>'OK','result' => '更新成功'] : ['code' => '1001','msg'=>'err','result' => '订单状态更新失败'];
        }
    }
    //充值订单
    public function pay(Request $req)
    {
        $orders = DB::table('record') -> where('tag','+') -> orderBy('time','desc') -> get();      
        return view('Admin.accessPay',['order' => $orders]);
    }
}
