<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class RuleController extends Controller
{
    //角色管理
    public function list()
    {
        $rule = DB::table('rule') -> get();
        $node = DB::table('node') -> get();
        if($node) {
            $new_node = [];
            foreach($node as $key => $val) {
                $new_node[$val -> tag][] = ['id' => $val -> id,'node_name' => $val -> node_name];
            }
        }
        return view('Admin.rule',['rule' => $rule,'node' => $new_node]);
    }
    //角色状态修改
    public function rule_status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('rule') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('rule') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('rule') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //角色删除
    public function rule_delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        //查询该角色下是否还有账号
        $num = DB::table('adminuser') -> where('rule',$req -> id) -> count();
        if($num){
            return ['code'=>'10001','msg'=>'该角色下存在账号，不允许删除!'];
        }
        $is = DB::table('rule') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //添加角色
    public function rule_create(Request $req)
    {
        if(!$req -> rule_name || !$req -> arrs){
            return ['code'=>'10001','msg'=>'请填写完整信息'];
        }
        $rule = explode(',',$req -> arrs);
        $rule_name = $req -> rule_name;
        //首先查询是否有重复的
        $if = DB::table('rule') -> where('rule_name',$rule_name) -> count();
        DB::beginTransaction();
        $id = DB::table('rule') -> insertGetId(['rule_name' => $rule_name]);   //插入成功
        if($id){
            //循环插入角色权限关联表
            $last_num = 0;
            for($i=0;$i<count($rule);$i++) {
                $rule_node['rule_id'] = $id;
                $rule_node['node_id'] = $rule[$i];
                $last_num += DB::table('rule_node') -> insert($rule_node);
            }
            if(count($rule) == $last_num) {
                DB::commit();
                return ['code'=> '1000','msg'=>'添加成功'];
            }
            DB::rollBack();
        }
        return ['code'=> '1002','msg'=>'添加失败'];
        
    }
    //编辑页面信息查询
    public function rule_edit(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $rule_info = DB::table('rule') -> where('id',$req -> id) -> first();
        $node_info = DB::table('rule_node') -> where('rule_id',$req -> id) -> get();
        $new_node = [];
        foreach($node_info as $key => $val) {
            array_push($new_node,$val -> node_id);
        }
        $node['rule_node'] = $new_node;
        $node['rule_name'] = $rule_info -> rule_name;
        $node['rule_id'] = $rule_info -> id;
        return $node;
    }
    //处理角色编辑
    public function rule_update(Request $req)
    {
        if(!$req -> rule_name || !$req -> arrs){
            return ['code'=>'10001','msg'=>'请填写完整信息'];
        }
        $rule = explode(',',$req -> arrs);
        $rule_name = $req -> rule_name;
        DB::beginTransaction();
        DB::table('rule') -> where('id',$req -> rule_id) -> update(['rule_name' => $rule_name]);   //插入成功
        //干掉所有的权限节点
        DB::table('rule_node') -> where('rule_id',$req -> rule_id) -> delete();
            //循环插入角色权限关联表
            $last_num = 0;
            for($i=0;$i<count($rule);$i++) {
                $rule_node['rule_id'] = $req -> rule_id;
                $rule_node['node_id'] = $rule[$i];
                $last_num += DB::table('rule_node') -> insert($rule_node);
            }
            if(count($rule) == $last_num) {
                DB::commit();
                return ['code'=> '1000','msg'=>'更新成功'];
            }
            DB::rollBack();
        return ['code'=> '1002','msg'=>'更新失败'];
    }
}
