<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class ShalongController extends Controller
{
    //沙龙列表
    public function list(Request $req)
    {
        //查询是否有过期的沙龙
        $all_shalong = DB::table('shalong') -> get();
        foreach($all_shalong as $val) {
            $time = time();
             //是否已完成
            if($val -> person_num_ok >= $val -> person_num){
                DB::table('shalong') -> where('id',$val -> id) -> update(['level'=>'已完成']);
            }
            if($val -> end_date <= $time) {   //过了过期时间 但是还没有完成
                if($val -> level == '报名中'){
                    DB::table('shalong') -> where('id',$val -> id) -> update(['level'=>'已结束']);
                }
            }
        }
        $md = DB::table('md') -> where('status',1) -> get();
        if($req -> md){
            $shalong = DB::table('shalong') -> where('md_id',$req -> md) -> get();
            $md_id = $req -> md;
        }else{
            $shalong = DB::table('shalong') -> where('md_id',$md[0]->id) -> get();  //默认第一个门店
            $md_id = $md[0] -> id;
        }
        //查询报名人数
        $sl = [];
        if($shalong) {
            foreach($shalong as $key => $val) {
                $sl[$key]['id'] = $val -> id;
                $sl[$key]['title'] = $val -> title;
                $sl[$key]['level'] = $val -> level;
                $sl[$key]['person_num'] = DB::table('shalong_person') -> where('shalong_id',$val -> id) -> count() .'/'. $val -> person_num;
                $sl[$key]['status'] = $val -> status;
                $sl[$key]['orders'] = $val -> orders;
            }
        }
        return view('Admin.shalong-list',['shalong'=>$sl,'md' => $md,'md_id' => $md_id]);
    }
    //添加沙龙页面
    public function add()
    {
        $md = DB::table('md') -> where('status',1) -> get();
        return view('Admin.shalong-add',['md' => $md]);
    }
    //处理添加沙龙
    public function doadd(Request $req)
    {
        if(!$req -> title || !$req -> end_date) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
            file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        //此出默认图片
        if($imageSrc) {
            $sl['imgURL'] = $imageSrc;
        }else{
            $sl['imgURL'] = 'uploads/wz_default.jpg';   //使用默认图片
        }
        $sl['title'] = $req -> title;   //沙龙标题
        $sl['content'] = $req -> content;   //沙龙内容
        $sl['person_num'] = $req -> person_num;   //沙龙人数
        $sl['end_date'] = strtotime($req -> end_date);   //截止时间
        $sl['price_status'] = $req -> price_type;   //报名方式
        $sl['price'] = $req -> price;   //金额
        $sl['md_id'] = $req -> md_id;   //门店id
        $sl['level'] = '报名中';
        $sl['sendtime'] = time();
        $is = DB::table('shalong') -> insert($sl);
        return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'修改失败'];
    }
    //上下架状态
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('shalong') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('shalong') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('shalong') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //沙龙置顶
    public function top(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = DB::table('shalong') -> where('id',$req -> id) -> value('orders');
        if($orders >= 0){
            $is = DB::table('shalong') -> where('id',$req -> id) -> update(['orders'=>-1]);
        }else{
            $is = DB::table('shalong') -> where('id',$req -> id) -> update(['orders'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //删除沙龙
    public function delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('shalong') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //编辑沙龙页面
    public function edit($id)
    {
        $md = DB::table('md') -> where('status',1) -> get();
        $one_shalong = DB::table('shalong') -> where('id',$id) -> first();
        return view('Admin.shalong-edit',['edit' => $one_shalong,'md' => $md]);
    }
    //处理编辑沙龙
    public function update(Request $req)
    {
        if(!$req -> title || !$req -> end_date || !$req -> id) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
            file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        //此出默认图片
        if($imageSrc) {
            $sl['imgURL'] = $imageSrc;
        }
        $sl['title'] = $req -> title;   //沙龙标题
        $sl['content'] = $req -> content;   //沙龙内容
        $sl['person_num'] = $req -> person_num;   //沙龙人数
        $sl['end_date'] = strtotime($req -> end_date);   //截止时间
        $sl['price_status'] = $req -> price_type;   //报名方式
        $sl['price'] = $req -> price;   //金额
        $sl['md_id'] = $req -> md_id;   //门店id
        $is = DB::table('shalong') -> where('id',$req -> id) -> update($sl);
        return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'修改失败'];
    }
    //查看沙龙报名详情
    public function lookPerson($id)
    {
        if(!$id) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $person = DB::table('shalong_person') -> where('shalong_id',$id) -> orderBy('time','asc') -> get();
        $shalong = DB::table('shalong') -> where('id',$id) -> first();
        return view('Admin.shalong_person',['person' => $person,'shalong' => $shalong]);
    }
}
