<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
class UserController extends Controller
{
    //用户列表
    public function list(Request $req)
    {
        $user = DB::table('user') -> paginate(8);
        return view('Admin.user-list',['user'=>$user,'a'=>$req]);
    }
    //冻结用户账号
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('user') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('user') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('user') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //给用户发放优惠券
    public function quan(Request $req)
    {
        //传入用户id   判断该用户是否存在
        if(!$req -> id){
            return ['code'=> '1001','msg'=>'缺少用户参数'];
        }
        //查找优惠券
        $youhui = DB::table('admin_you') -> where('vip',0) -> get();
        return view('Admin.user-quan',['youhui' => $youhui,'id'=> $req -> id]);
    }
    //处理用户发放优惠券
    public function yh(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=> '1001','msg'=>'缺少重要参数'];
        }
        //判断选择的优惠券是否失效
        $admin_you = DB::table('admin_you') -> whereIn('id',$req -> select_id) -> get();
        $is = 0;
        $err = 0;
        if($admin_you){
            DB::beginTransaction();
            foreach($admin_you as $key => $val) {
                    //时间没有超过  发放优惠券
                    $user['youhui_id'] = $val -> id;  //优惠券id
                    $user['name'] = $val -> name;   //优惠券名称
                    $user['type'] = $val -> type;   //优惠券  1直减  2折扣
                    $user['price'] =  $val -> price;   //优惠券额度
                    $user['use_height'] = $val -> use_height;    //满多少钱可用   无门槛为0
                    $user['end_date'] = $val -> end_date;   //优惠券过期时间
                    $user['md'] = $val -> md;    //使用门店限制   0为全部门店  其他为门店id 
                    $user['use_type'] = $val -> use_type;   //商品使用范围  1全部 2以下可用  3以下不可用
                    $user['use_size'] = $val -> use_size;    //指定商品id   指定商品不可用id   全部不需要id
                    $user['tips'] = $val -> tips;              //优惠券说明
                    $user['addtime'] = time();                  //领取时间
                    $user['status'] = 0;                    //0未使用  1已使用
                    $user['user_id'] = $req -> id;   //用户id
                if($val -> send_type == 1){
                    if(time() < $val -> end_date) {
                        $is += DB::table('user_you') -> insert($user);
                        //自增
                        DB::table('admin_you') -> where('id',$val -> id) -> increment('use_num');
                    }else{
                        $err ++;
                    }
                }else{
                    //数量有限制   检查数量是否超出
                    if($val -> send_num > $val -> use_num) {
                        //还可以发
                        $is += DB::table('user_you') -> insert($user);
                        DB::table('admin_you') -> where('id',$val -> id) -> increment('use_num');
                    }else{
                        //数量超出了限制
                        $err ++;
                    }
                }
            }
            if(count($req -> select_id) - $err == $is) {
                DB::commit();
                return ['code'=> '1000','msg'=>'OK','result' => '发放成功!','err' => $err,'is' => $is];
            }else{
                DB::rollBack();   //失败后回滚
                return ['code'=> '1001','msg'=>'ERR','发放失败!'];
            }
        }
    }
}
