<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
class VipController extends Controller
{
    //会员列表
    public function list(Request $req)
    {
        //level 不为0 的用户
        $level = DB::table('vip_level') -> orderBy('level_price','asc') -> get();
        $vip_user = DB::table('user') -> where('level','!=',0) -> paginate(8);
        return view('Admin.vip-list',['vip'=>$vip_user,'a'=>$req,'level'=>$level]);
    }
    //会员等级设置页面
    public function level()
    {
        $level = DB::table('vip_level') -> orderBy('level_price','asc') -> get();
        return view('Admin.vip-level',['level'=>$level]);
    }
    //会员状态
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('user') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('user') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('user') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //会员等级状态
    public function level_status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('vip_level') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('vip_level') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('vip_level') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //调整会员你等级
    public function update(Request $req)
    {
        if(!$req -> id || !$req -> level){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $level['level'] = $req -> level;
        $is = DB::table('user') -> where('id',$req -> id) -> update($level);
        return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'没有发生改变'];
    }
    //会员等级添加
    public function level_create(Request $req)
    {
        if(!$req -> level_name || !$req -> level_price){
            return ['code'=>'10001','msg'=>'信息不全'];
        }
        $level['level_name'] = $req -> level_name;
        $level['level_price'] = $req -> level_price;
        $level['send'] = $req -> send;
        $is = DB::table('vip_level') -> insert($level);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //会员等级编辑
    public function level_update(Request $req)
    {
        if(!$req -> id || !$req -> level_name || !$req -> level_price){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $level['level_name'] = $req -> level_name;
        $level['send'] = $req -> send;
        $level['level_price'] = $req -> level_price;
        $is = DB::table('vip_level') -> where('id',$req -> id) -> update($level);
        return $is ? ['code'=> '1000','msg'=>'调整完成'] : ['code'=> '1002','msg'=>'调整前后无改变'];
    }
}
