<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class WenzhangController extends Controller
{
    //文章列表
    public function index()
    {
        $wz_list = DB::table('wz') -> orderBy('sendtime','desc') -> get();
        return view('Admin.wz-list',['wz_list' => $wz_list]);
    }
    //文章类别管理
    public function cate()
    {
        //获取所有门店
        $md = DB::table('md') -> where('status',1) -> get();
        //文章类别
        $wz_cate = DB::table('wz_cate') -> where('status',1) -> get();
        return view('Admin.wz-cate',['wzcate'=>$wz_cate,'md' => $md]);
    }
    //文章类别状态管理
    public function cate_status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('wz_cate') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('wz_cate') -> where('id',$req -> id) -> update(['status'=>0]);
            //此处应该禁用给下面所有文章  。。。
        }else{
            $is = DB::table('wz_cate') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //商品分类增加
    public function cate_create(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $goodsCate = [];
        $goodsCate['cate_name'] = $req -> cate_Name;
        $goodsCate['status'] = 1;
        $is = DB::table('wz_cate') -> insert($goodsCate);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //文章分类修改
    public function cate_update(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $id = $req -> id;
        $update['cate_name'] = $req -> name;
        $is = DB::table('wz_cate') -> where('id',$id) -> update($update);
        return $is ? ['code'=> '1000','msg'=>'修改成功'] : ['code'=> '1002','msg'=>'修改失败'];
    }
    //文章分类删除
    public function cate_delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('wz_cate') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }


    //文章操作  删除文章
    public function delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('wz') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //文章上下架
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('wz') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('wz') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('wz') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //文章进行置顶
    public function top(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = DB::table('wz') -> where('id',$req -> id) -> value('orders');
        if($orders >= 0){
            $is = DB::table('wz') -> where('id',$req -> id) -> update(['orders'=>-1]);
        }else{
            $is = DB::table('wz') -> where('id',$req -> id) -> update(['orders'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //文章添加页面
    public function add()
    {
        //获取所有的文章分类
        $cate = DB::table('wz_cate') -> where('status',1) -> get();
        return view('Admin.wz-add-page',['cate'=>$cate]);
    }
    //文章处理添加
    public function doadd(Request $req)
    {
        if(!$req -> wztitle || !$req -> wzcate) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
                $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        $wz['pid'] = $req -> wzcate;
        if($imageSrc) {
            $wz['wz_img'] = $imageSrc;
        }else{
            $wz['wz_img'] = 'uploads/wz_default.jpg';   //使用默认图片
        }
        $wz['wz_name'] = $req -> wztitle;
        $wz['wz_content'] = $req -> content;
        $wz['sendtime'] = time();
        $wz['status'] = 1;
        $is = DB::table('wz') -> insert($wz);
        return $is ? ['code'=> '1000','msg'=>'发布完成'] : ['code'=> '1002','msg'=>'发布失败'];
    }
    //文章编辑页面
    public function edit($id)
    {
        if(!$id){
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $cate = DB::table('wz_cate') -> where('status',1) -> get();
        $edit = DB::table('wz') -> where('id',$id) -> first();
        return view('Admin.wz-edit-page',['cate'=>$cate,'edit'=>$edit]);
    }
    //文章处理编辑
    public function updata(Request $req)
    {
        if(!$req -> wztitle || !$req -> wzcate || !$req -> wz_id) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
                $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        //此出默认图片
        $wz['pid'] = $req -> wzcate;
        if($imageSrc) {
            $wz['wz_img'] = $imageSrc;
        }else{
            $wz['wz_img'] = 'uploads/wz_default.jpg';   //使用默认图片
        }
        $wz['wz_name'] = $req -> wztitle;
        $wz['wz_content'] = $req -> content;
        $is = DB::table('wz') -> where('id',$req -> wz_id) -> update($wz);
        return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'修改失败'];
    }
    //关于简诺
    public function about()
    {
        $about = DB::table('about') -> first();
        return view('Admin.wz-about',['about'=>$about]);
    }
    //保存修改
    public function about_edit(Request $req)
    {
        if(!$req -> id || !$req -> content) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $about['content'] = $req -> content;
        $is = DB::table('about') -> where('id',$req -> id) -> update($about);
        return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'修改失败'];
    }

}
