<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class JanRosyController extends Controller
{
    protected $Url = 'https://janrosy.1vgy.com';

    public function getJanRosyCate(Request $req)
    {
        $shalong = [];
        $wz = [];
        if(!$req -> cate_id) {
            //刚加载页面   全部数据
            $wz = DB::table('wz') -> where('status',1) -> orderBy('orders','asc') -> get();
            $shalong = DB::table('shalong') -> where('status',1) -> where('md_id',$req -> md_id) -> get();
        }
        if($req -> cate_id) {
            //选择了对应的分类  非沙龙
            $wz = DB::table('wz') -> where('pid',$req -> cate_id) -> where('status',1) -> orderBy('orders','asc') -> get();
        }
        if($req -> cate_id == 999) {
            //所有沙龙
            $shalong = DB::table('shalong') -> where('status',1) -> where('md_id',$req -> md_id) -> get();
        }
        $new_wz = [];
        if(count($wz)) {
            foreach($wz as $key => $val) {
                $new_wz[$key]['id'] = $val -> id;
                $new_wz[$key]['pid'] = DB::table('wz_cate') -> where('id',$val -> pid) -> value('cate_name');
                $new_wz[$key]['wz_name'] = $val -> wz_name;
                $new_wz[$key]['wz_img'] = $this -> Url . '/' . $val -> wz_img;
                $new_wz[$key]['orders'] = $val -> orders;
                $new_wz[$key]['sendtime'] = date('Y年m月d日',$val -> sendtime);
                $new_wz[$key]['type'] = 1;  //文章
            }
        }
        $sl = [];
        if(count($shalong)) {
            foreach($shalong as $k => $v) {
                $sl[$k]['id'] = $v -> id;
                $sl[$k]['pid'] = '花艺沙龙';
                $sl[$k]['wz_name'] = $v -> title;
                $sl[$k]['wz_img'] = $this -> Url . '/' . $v -> imgURL;
                $sl[$k]['orders'] = $v -> orders;
                $sl[$k]['sendtime'] = date('Y年m月d日',$v -> sendtime);
                $sl[$k]['type'] = 2;   //沙龙
                //判断沙龙是否过期
                if($v -> end_date < time()) {
                    //过期了
                    DB::table('shalong') -> where('id',$v -> id) -> update(['level' => '已结束']);
                }
            }
        }
        $all_news = array_merge($new_wz,$sl);
        $last_names = array_column($all_news,'orders');
        array_multisort($last_names,$all_news);
        //查询文章页ad图
        $ad = DB::table('index_ad') -> where('map',2) -> first();
        $index_ad = [];
        $index_ad['imgUrl'] = $this -> Url . '/' .$ad -> imgUrl;
        $index_ad['link'] = $ad -> link;
        
        $wz_cate = DB::table('wz_cate') -> where('status',1) -> get();
        return ['code' => '1000','msg' => 'OK','wz' => $all_news,'wz_cate' => $wz_cate,'index_ad' => $index_ad]; 
    }
    //获取文章详情
    public function getWzDetail(Request $req)
    {
        DB::table('wz') -> where('id',$req -> id) -> increment('look');
        $baoming = 0;
        if($req -> type == 1){
            $wz = DB::table('wz') -> where('id',$req -> id) -> first();
            $janInfo = [];
            if($wz) {
                $janInfo['id'] = $wz -> id;
                $janInfo['wz_name'] = $wz -> wz_name;
                $janInfo['wz_img'] = $this -> Url . '/' .$wz -> wz_img;
                $janInfo['wz_content'] = $wz -> wz_content;
                $janInfo['type'] = 1;
                $janInfo['sendtime'] = date('Y年m月d日 H时i分',$wz -> sendtime);
            }
        }else{
            $wz = DB::table('shalong') -> where('id',$req -> id) -> first();
            $janInfo = [];
            if($wz) {
                $janInfo['id'] = $wz -> id;
                $janInfo['wz_name'] = $wz -> title;
                $janInfo['wz_img'] = $this -> Url . '/' .$wz -> imgURL;
                $janInfo['wz_content'] = $wz -> content;
                $janInfo['type'] = 2;
                $janInfo['sendtime'] = date('Y年m月d日 H时i分',$wz -> sendtime);

                $janInfo['price_status'] = $wz -> price_status;   //报名使用钱还是积分 
                $janInfo['price'] = $wz -> price;   //、积分或者 钱
                $janInfo['end_date'] = date('Y年m月d日 H时i分',$wz -> end_date);   //报名截止时间
                $janInfo['level'] = $wz -> level;   //报名状态
                $janInfo['person_num'] = $wz -> person_num;   //需要人数
                $janInfo['person_num_ok'] = $wz -> person_num_ok;   //已报名人数
                //查询当前用户是否已经报名
                $user = DB::table('user') -> where('token',$req -> token) -> first();
                $baoming = DB::table('shalong_person') -> where('openid',$user -> id) -> where('shalong_id',$req -> id) -> count();
            }
        }
        
        return ['code' => '1000','msg' => 'OK','janInfo' => $janInfo,'baoming' => $baoming]; 
    }
    //简诺文章页面搜索
    public function search(Request $req)
    {
        if($req -> keywords) {
            $new_wz = [];
            $result = DB::table('wz') -> where('wz_name','like','%'.$req -> keywords.'%') -> where('status',1) -> get();
            if(count($result)) {
                foreach($result as $key => $val) {
                    $new_wz[$key]['id'] = $val -> id;
                    $new_wz[$key]['pid'] = DB::table('wz_cate') -> where('id',$val -> pid) -> value('cate_name');
                    $new_wz[$key]['wz_name'] = $val -> wz_name;
                    $new_wz[$key]['wz_img'] = $this -> Url . '/' . $val -> wz_img;
                    $new_wz[$key]['orders'] = $val -> orders;
                    $new_wz[$key]['sendtime'] = date('Y年m月d日',$val -> sendtime);
                    $new_wz[$key]['type'] = 1;  //文章
                }
            }
            return ['code' => '1000','msg' => 'OK','result' => $new_wz];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '搜索结果为空'];
        }
    }
}
