<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class MeController extends Controller
{
    protected $Url = 'https://http://sale.1vgy.com';
    //关于简诺
    public function getAbout()
    {
        $about = DB::table('about') -> first();
        return ['code' => '1000','msg' => 'OK','about' => $about]; 
    }
    //定单的各种状态
    public function getOrder(Request $req) 
    {
        $id = DB::table('user') -> where('token',$req -> token) -> value('id');
        if(!$id) {
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
        if($req -> status == 666) {  //全部订单
            $order = DB::table('order') -> where('user_id',$id) -> get();
        }else{
            $order = DB::table('order') -> where('user_id',$id) -> where('status',$req -> status) -> get();
        }
        
        //通过订单id查询商品
        if($order) {
            $goods = [];
            foreach($order as $key => $val) {
                $now_goods = DB::table('order_goods') -> where('order_id',$val -> order_id) -> get();
                //拿到多件商品查询商品名称
                $goods[$key]['goods_name'] = DB::table('goods') -> where('id',$now_goods[0] -> goods_id) -> value('goods_name');   //商品名
                $goods[$key]['goods_num'] = count($now_goods);   //数量
                $goods[$key]['goods_price'] = $val -> price;  //价格
                $goods[$key]['md'] = DB::table('md') -> where('id',$val -> md_id) -> value('md_name');  //门店
                if($val -> status == 0) {
                    $goods[$key]['status'] = '订单未支付';
                }elseif($val -> status == 1) {
                    $goods[$key]['status'] = '订单已付款';
                }elseif($val -> status == 2){
                    $goods[$key]['status'] = '订单待发货';
                }elseif($val -> status == 3){
                    $goods[$key]['status'] = '订单待收货';
                }elseif($val -> status == 4) {
                    $goods[$key]['status'] = '订单已完成';
                }
                $goods[$key]['order_id'] = $val -> order_id;
                $goods[$key]['order_time'] = date('Y年m月d日 H:i',$val -> order_time);
            }
        }
        return ['code' => '1000','msg' => 'OK','result' => $goods];
    }
    //我的账户
    public function getAccessPrice(Request $req)
    {
        if($id = DB::table('user') -> where('token',$req -> token) -> value('id')) {
            $price = DB::table('access') -> where('user_id',$id) -> value('price');
            if($price === null) {
                //未开通钱包
                return ['code' => '1000','msg' => 'OK','result' => '','is_janrosy' => 0];
            }
            return ['code' => '1000','msg' => 'OK','result' => $price,'is_janrosy' => 1];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
    }
    //设置账户初始密码
    public function setAccessPWD(Request $req)
    {  
        if($id = DB::table('user') -> where('token',$req -> token) -> value('id')) {
            if(strlen($req -> pass1) == strlen($req -> pass2) && $req -> pass1 && $req -> pass2 && $req -> pass1 == $req -> pass2) {
                //查询是否开通
                if(!DB::table('access') -> where('user_id',$id) -> count()) {
                    $access = [];
                    $access['user_id'] = $id;
                    $access['price'] = 0;
                    $access['kt_time'] = time();
                    $ac = DB::table('access') -> insert($access);
                    $is = 0;
                    if($ac) {
                        $is = DB::table('user') -> where('id',$id) -> update(['pay_password' => (int)$req -> pass1]);
                    }
                    if($is) {
                        return ['code' => '1000','msg' => 'OK','price' => $access['price']];
                    }else{
                        return ['code' => '1001','msg' => 'err1','price' => ''];
                    }
                }else{
                    return ['code' => '1001','msg' => 'err2','result' => '']; 
                }
            }else{
                return ['code' => '1001','msg' => 'err3','result' => '']; 
            }
        }
    }
    //交易记录
    public function record(Request $req)
    {
        if($id = DB::table('user') -> where('token',$req -> token) -> value('id')) {
            $record = DB::table('record') -> where('user_id',$id) -> orderBy('id','desc') -> get();
            $info = [];
            if($record) {
                foreach($record as $key => $val) {
                    $info[$key]['date'] = date('Y年m月d日',$val -> time);
                    $info[$key]['goods'] = $val -> goods;
                    $info[$key]['price'] = $val -> price;
                    $info[$key]['order_id'] = $val -> order_id;
                    $info[$key]['tag'] = $val -> tag;
                }
            }
            return ['code' => '1000','msg' => 'OK','result' => $info];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
    }
    //查询积分记录和积分
    public function getJifen(Request $req) 
    {
        if($id = DB::table('user') -> where('token',$req -> token) -> value('id')) {
            //查询积分
            $jifen = DB::table('user') -> where('id',$id) -> orderBy('id','desc') -> value('jifen');
            //查询积分记录
            $jifen_record = DB::table('jifen_record') -> where('user_id',$id) -> get();
            $info = [];
            if($jifen_record) {
                foreach($jifen_record as $key => $val) {
                    $info[$key]['date'] = date('Y年m月d日',$val -> time);
                    $info[$key]['goods'] = $val -> goods;
                    $info[$key]['jifen'] = $val -> jifen;
                    $info[$key]['tag'] = $val -> tag;
                }
            }
            return ['code' => '1000','msg' => 'OK','result' => $info,'jifen' => $jifen];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
    }
    //获取订单详情
    public function getOrderDetail(Request $req)
    {
        if(!$req -> order_id) {
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
        $now_order = DB::table('order') -> where('order_id',$req -> order_id) -> first();
        $order_goods = DB::table('order_goods') -> where('order_id',$req -> order_id) -> get();
        $order = [];
        $goods = [];
        if($now_order) {
            foreach($order_goods as $key => $val) {
                $one_goods = DB::table('goods') -> where('id',$val -> goods_id) -> first();
                $goods[$key]['img'] = $this -> Url . '/' . $one_goods -> goods_images;
                $goods[$key]['goods_name'] = $one_goods -> goods_name;
                $goods[$key]['goods_price'] = $val -> price;
                $goods[$key]['goods_num'] = $val -> goods_num;
                if($val -> guige_id){
                    $goods[$key]['goods_guige'] = DB::table('goods_guige') -> where('id',$val -> guige_id) -> value('guige_name');
                }else{
                    $goods[$key]['goods_guige'] = '默认';
                }
                
            } 
            $order['md_name'] = DB::table('md') -> where('id',$now_order -> md_id) -> value('md_name');
            $order['all_price'] = $now_order -> price / 100;
            $order['order_id'] = $now_order -> order_id;
            $order['order_time'] = date('Y年m月d日 H:i:s',$now_order -> order_time);
            $order['order_type'] = $now_order -> order_type;
            $order['status'] = $now_order -> status;
            $order['goods'] = $goods;
        }
        return ['code' => '1000','msg' => 'OK','result' => $order]; 
    }

    //沙龙报名
    public function getShaLong(Request $req)
    {
        if($user = DB::table('user') -> where('token',$req -> token) -> first()) {
            $shalong = DB::table('shalong_person') -> where('openid',$user -> id) -> get();
            //组装沙龙信息
            $sl = [];
            if($shalong) {
                foreach($shalong as $key => $val) {
                    $shalongInfo = DB::table('shalong') -> where('id',$val -> shalong_id) -> first();
                    $sl[$key]['id'] = $shalongInfo -> id;
                    $sl[$key]['imgUrl'] = $this -> Url.'/'.$shalongInfo -> imgURL;
                    $sl[$key]['md_name'] = DB::table('md') -> where('id',$shalongInfo -> md_id) -> value('md_name');
                    $sl[$key]['date'] = date('Y年m月d日 H:i',$val -> time);
                    $sl[$key]['title'] = $shalongInfo -> title;
                    $sl[$key]['price'] = $val -> price;
                    $sl[$key]['price_status'] = $shalongInfo -> price_status;
                }
            }
            return ['code' => '1000','msg' => 'OK','result' => $sl]; 
        }else{
            return ['code' => '1001','msg' => 'err','result' => '']; 
        }
    }
    //充值套餐列表
    public function getVip()
    {
        $vip_level = DB::table('vip_level') -> where('status',1) -> get();
        return ['code' => '1000','msg' => 'OK','result' => $vip_level];
    }
    //会员体系获取会员等级
    public function getVipLevel(Request $req)
    {
        if($user = DB::table('user') -> where('token',$req -> token) -> first()) {
            return ['code' => '1000','msg' => 'OK','level' => $user -> level];
        }
        return ['code' => '1001','msg' => 'err','level' => '']; 
    }
    //处理优惠券的分享
    public function share(Request $req)
    {
        if($req -> share_id && $req -> you_token && $req -> token) {
            $you_id = DB::table('user') -> where('token',$req -> you_token) -> value('id');
            //查询现在用户信息拿到id
            $user_id = DB::table('user') -> where('token',$req -> token) -> value('id');
            if(!$you_id || !$user_id) {
                return ['code' => '1001','msg' => 'err','result' => '分享信息已过期'];
            } 
            if($you_id == $user_id) {
                return ['code' => '1001','msg' => 'err','result' => '不能自己领取分享的优惠券'];
            }
            //首先查询是否存在优惠券
            $share_youhui = DB::table('user_you') -> where('id',$req -> share_id) -> first();
            if($share_youhui) {
                //查询优惠券对否过期
                if($share_youhui -> end_date > time()) {
                    //没过期
                    if(!$share_youhui -> vip){
                        //查询用户token
                            if($user_id) {
                                $is = DB::table('user_you') -> where('id',$req -> share_id) -> update(['user_id' => $user_id]);
                                return $is ? ['code' => '1000','msg' => 'OK','result' => '领取成功!'] : ['code' => '1001','msg' => 'err','result' => '领取失败']; 
                            }
                    }else{
                        return ['code' => '1001','msg' => 'err','result' => '该类型优惠券不可分享'];
                    }
                }else{
                    return ['code' => '1001','msg' => 'err','result' => '优惠券已过期'];
                }
            }else{
                return ['code' => '1001','msg' => 'err','result' => '优惠券不存在'];
            }
        }else{
            return ['code' => '1001','msg' => 'err','result' => '分享参数错误'];
        }
    }
}
