<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;

class VerifyCsrfToken extends Middleware
{
    /**
     * Indicates whether the XSRF-TOKEN cookie should be set on the response.
     *
     * @var bool
     */
    protected $addHttpCookie = true;

    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array
     */
    protected $except = [
        '/admin/wenzhang/doadd',  //文章处理添加
        '/admin/wenzhang/updata',  //文化处理编辑
        '/admin/wenzhang/about_edit',   //关于简诺
        "/admin/shalong/doadd",  //处理添加沙龙
        '/admin/shalong/update',  //处理编辑沙龙
        '/admin/goodscate/goodsDoadd',  //商品处理添加
        '/admin/goodscate/goodsUpdate', //处理编辑商品
        '/admin/jifen/goods_doadd',  //处理积分商城商品添加
        '/admin/jifen/goods_update', //处理积分商品编辑
        '/admin/you/doadd',   //处理优惠券添加
        '/admin/you/vipDoadd',   //处理优惠券添加
        '/admin/ad/ad',   //保存编辑首页广告图
        '/admin/ad/jan_ad',   //编辑保存文章页广告图
        //前台
        'getOrderPrev',   //订单确认页面
        'pay',   //支付处理
        'janPay',  //验证密码后扣款
        'wechat',   //微信支付
        'setAccessPWD',    //设置账户初始密码
        'wechatPay',   //支付成功回调处理订单
        'getPhone',   //购物车自动获取手机号
        'accessPay',  //沙龙账户支付
        'sl_wechatPay',   //沙龙微信支付
        'accessPayMoney',  //充值订单生成
        'accessPayMoneyDo',  //支付成功进行充值
    ];  
}
