@extends('Public.index')
@section('admin')
<div class="content-wrapper" style="min-height: 810px;">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>商品列表</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/admin/index">首页</a></li>
              <li class="breadcrumb-item active">商品管理</li>
              <li class="breadcrumb-item active">商品列表</li>
            </ol>
          </div>
        </div>
      </div>
    </section>
    <div class="col-xs-3">
        <button class="btn btn-primary add" style="margin-left:17px;margin-bottom:15px">添加商品 +</button>
    </div>

    <div class="form-group col-md-12">
            <label for="name" class="col-sm-2 control-label"> 选择门店</label>
                <div class="col-sm-3">
                    <select class="form-control" id="md">
                        @foreach($md as $key => $val)
                        <option value="{{ $val -> id }}" @if($md_id == $val -> id) selected @endif> {{ $val -> md_name }}</option>
                        @endforeach
                    </select>
                </div>
        </div>

        <div class="form-group col-md-12">
            <label for="name" class="col-sm-2 control-label"> 分类显示</label>
                <div class="col-sm-3">
                    <select class="form-control" onchange="pid(this)" id="cate">
                        <option value="0" @if($cate_id == '0') selected @endif> 全部</option>
                        @foreach($goods_cate as $key => $val)
                        <option value="{{ $val -> id }}" @if($cate_id == $val -> id) selected @endif> {{ $val -> cate_name }}</option>
                        @endforeach
                    </select>
                </div>
        </div>


    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">

            <div class="card">
              <div class="card-body p-0">
                <table class="table table-condensed">
                  <tbody>

                  <tr style="text-align:center">
                    <th>序号</th>
                    <th>封面图</th>
                    <th>商品名称</th>
                    <th>排序</th>
                    <th>状态</th>
                    <th style="width: 100px">操作</th>
                  </tr>
                @foreach($goods as $key => $val)
                  <tr style="text-align:center">
                    <td>{{ $val -> xuhao }}</td>
                    <td><img style="height:100px;width:100px" src="/{{ $val -> goods_images }}" alt="{{ $val -> goods_name }}"></td>
                    <td>{{ $val -> goods_name }}</td>
                    <td onclick="orders({{ $val -> id }},{{ $val -> orders }})">{{ $val -> orders }}</td>
                      <td>
                          @if($val -> is_recomd == 1)
                              <a href="javascript:void(0)" onclick="is_recomd({{ $val -> id }})"><span class="badge bg-success">推荐中</span></a>
                          @else
                              <a href="javascript:void(0)" onclick="is_recomd({{ $val -> id }})"><span class="badge bg-danger">不推荐</span></a>
                          @endif
                      </td>
                    <td>
                        @if($val -> status == 1)
                        <a href="javascript:void(0)" onclick="status({{ $val -> id }})"><span class="badge bg-success">上架中</span></a>
                        @else
                        <a href="javascript:void(0)" onclick="status({{ $val -> id }})"><span class="badge bg-danger">下架中</span></a>
                        @endif
                    </td>
                    <td>
                        <a href="javascript:void(0)" onclick="edit({{ $val -> id }})"><i class="fa fa-edit" style="font-size: 16px;" title="编辑"></i></a>
                        <a href="javascript:void(0)" onclick="del({{ $val -> id }})"><i class="fa fa-trash" style="font-size: 16px;" title="删除"></i></a>
                    </td>
                  </tr>

                @endforeach

                </tbody>
                </table>

              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
<script src="/admin/plugins/jquery/jquery.min.js"></script>
<script src="/admin/layer-v3.1.1/layer/layer.js"></script>
<script>

    function GetUrlPara()
　　{
　　　　var url = document.location.toString();
　　　　var arrUrl = url.split("?");

　　　　var para = arrUrl[1];
　　　　return para;
　　}
    if(!GetUrlPara()){
      window.location.href="/admin/goodscate/goods?md="+{{ $md_id }};
    }
    $('#md').change(function(){
        var id = $('#md option:selected').val();
          window.location.href="/admin/goodscate/goods?md="+id;
    })
    $('#cate').change(function(){
        var id = $('#cate option:selected').val();
        window.location.href= window.location.href+'&cate='+id;
    })
    function status(id)
    {
        if(!id){
            layer.msg('参数错误');
            return false;
        }
        layer.confirm('确认操作吗？', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/goodscate/goodsStatus',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });
    }
    function is_recomd(id)
    {
        if(!id){
            layer.msg('参数错误');
            return false;
        }
        layer.confirm('确认操作吗？', {
            btn: ['确认','取消'] //按钮
        }, function(){
            $.get('/admin/goodscate/goodsisrecomd',{id:id},function(res){
                if(res.code == '1000'){
                    layer.msg(res.msg);
                    window.location.reload();
                }else{
                    layer.msg(res.msg);
                }
            })
        });
    }
    function orders(id,orders)
    {
        layer.prompt({ value:orders,title:'输入排序序号', formType: 3}, function(text, index){
            if(!id){
                layer.msg('参数错误');
                return false;
            }
            $.get('/admin/goodscate/goodsOrders',{id:id,text:text},function(res){
                if(res.code == '1000'){
                    layer.msg(res.msg);
                    window.location.reload();
                }else{
                    layer.msg(res.msg);
                }
            })
            layer.close(index);
        });
    }
    $('.add').click(function(){
        window.location.href="/admin/goodscate/goodsAdd";
    })
    function del(id)
    {
        if(!id) {
            layer.msg('参数不全');
            return false;
        }
        layer.confirm('确认删除改商品吗？删除后不可恢复', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/goodscate/goodsDelete',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });
    }
    function edit(id)
    {
        if(!id){
            layer.msg('参数不全');
            return false;
        }
        window.location.href="/admin/goodscate/goodsEdit/"+id;
    }
</script>
@endsection
@section('title','商品分类')
@section('goods','menu-open')
@section('goods2','active')
@section('goodslist','active')
