@extends('Public.index')
@section('admin')
<!-- 新增 -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
                <form class="form-horizontal">
                        <div class="form-group">
                            <label for="inputEmail3" class="col-sm-3 control-label"><span style="color:red">*</span> 门店名称</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control md_name" id="inputEmail3" autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 门店地址</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control md_address" id="inputPassword3">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-12 control-label"><span style="color:red">*</span> 门店坐标 <span style="font-size:14px"> （请复制门店地址，再<a href="https://lbs.qq.com/tool/getpoint/" target="_blank">点我查询坐标</a>）</span></label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control md_map" id="inputPassword3">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 联系电话</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="md_phone">
                            </div>
                        </div>
                        <!-- 新增  3-31 -->
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 起送价格</label>
                            <div class="col-sm-12">
                            <input type="number" class="form-control" id="up_price">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-12 control-label"><span style="color:red">*</span> 基础配送费(<a href="">距离费用设置</a>)</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="peisong_price">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-4 control-label"><span style="color:red">*</span> 配送范围（km）</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="peisong_fanwei">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-4 control-label"><span style="color:red">*</span> 配送服务提供</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="peisong_service">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 营业时间</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="online_time">
                            </div>
                        </div>

                </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
        <button type="button" class="btn btn-primary" onclick="create()">添加</button>
      </div>
    </div>
  </div>
</div>
<!-- 修改 -->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModal2Label">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
                <form class="form-horizontal">
                        <div class="form-group">
                        <input type="hidden" id="id">
                            <label for="inputEmail3" class="col-sm-3 control-label"><span style="color:red">*</span> 门店名称</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control md_name2" id="inputEmail3" autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 门店地址</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control md_address2" id="inputPassword3">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-12 control-label"><span style="color:red">*</span> 门店坐标 <span style="font-size:14px"> （请复制门店地址，再<a href="https://lbs.qq.com/tool/getpoint/" target="_blank">点我查询坐标</a>）</span></label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control md_map2" id="inputPassword3">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 联系电话</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="md_phone2">
                            </div>
                        </div>
                        <!-- 新增  3-31 -->
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 起送价格</label>
                            <div class="col-sm-12">
                            <input type="number" class="form-control" id="up_price2">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-12 control-label"><span style="color:red">*</span> 基础配送费(<a href="">距离费用设置</a>)</label>
                            <div class="col-sm-12">
                            <input type="number" class="form-control" id="peisong_price2">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-4 control-label"><span style="color:red">*</span> 配送范围（km）</label>
                            <div class="col-sm-12">
                            <input type="number" class="form-control" id="peisong_fanwei2">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-4 control-label"><span style="color:red">*</span> 配送服务提供</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="peisong_service2">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="col-sm-3 control-label"><span style="color:red">*</span> 营业时间</label>
                            <div class="col-sm-12">
                            <input type="text" class="form-control" id="online_time2">
                            </div>
                        </div>

                </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">关闭</button>
        <button type="button" class="btn btn-primary" onclick="update()">修改</button>
      </div>
    </div>
  </div>
</div>
<!-- 莫泰结束 -->

<div class="content-wrapper" style="min-height: 810px;">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>门店列表</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/admin/index">首页</a></li>
              <li class="breadcrumb-item active">门店管理</li>
              <li class="breadcrumb-item active">门店列表</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <div class="col-xs-3">
        <button class="btn btn-primary" data-toggle="modal" data-target="#myModal" style="margin-left:17px;margin-bottom:15px">添加门店</button>
    </div>
    <span class="m-4" style="font-size:12px;color:red">*添加门店后请至少添加一个商品分类后再上线运行</span>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">

            <div class="card">
              <!-- /.card-header -->
              <div class="card-body p-0">
                <table class="table table-condensed">
                  <tbody>

                  <tr style="text-align:center">
                    <th>门店名称</th>
                    <th>门店地址</th>
                    <th>联系电话</th>
                    <th>状态</th>
                    <th style="width: 100px">操作</th>
                  </tr>
                @foreach($md as $key => $val)
                  <tr style="text-align:center">
                    <input type="hidden" value="{{ $val -> id }}">
                    <td>{{ $val -> md_name }}</td>
                    <td>{{ $val -> md_address }}</td>
                    <td>{{ $val -> md_phone }}</td>
                    <input type="hidden" value="{{ $val -> md_map }}">
                    <td>
                        @if($val -> status == 1)
                        <a href="javascript:void(0)" onclick="status({{ $val -> id }})"><span class="badge bg-success">运营中</span></a>
                        @else
                        <a href="javascript:void(0)" onclick="status({{ $val -> id }})"><span class="badge bg-danger">未运营</span></a>
                        @endif
                    </td>
                    <td>
                        <a href="javascript:void(0)" onclick="edit({{ $val -> id }})"><i class="fa fa-edit" style="font-size: 16px;" title="编辑"></i></a>
                        <!-- <a href="javascript:void(0)" onclick="del({{ $val -> id }})"><i class="fa fa-trash" style="font-size: 16px;" title="删除"></i></a> -->
                    </td>
                  </tr>
                @endforeach
                </tbody></table>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
<script src="/admin/plugins/jquery/jquery.min.js"></script>
<script src="/admin/layer-v3.1.1/layer/layer.js"></script>
<script src="/layDate-v5.0.9/laydate/laydate.js"></script>
<script>
    //时间范围
    laydate.render({
      elem: '#online_time'
      ,type: 'time'
      ,range: true
    });
    //时间范围
    laydate.render({
      elem: '#online_time2'
      ,type: 'time'
      ,range: true
    });
    function status(id)
    {
        if(!id){
            layer.msg('参数错误');
            return false;
        }
        layer.confirm('确认操作吗？', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/md/status',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });   
    }
    function create()
    {
        var md_name = $('.md_name').val();
        var md_address = $('.md_address').val();
        var md_map = $('.md_map').val();
        var md_phone = $('#md_phone').val();
        var up_price = $('#up_price').val();
        var peisong_price = $('#peisong_price').val();
        var peisong_fanwei = $('#peisong_fanwei').val();
        var peisong_service = $('#peisong_service').val();
        var online_time = $('#online_time').val();
        if(!md_name || !md_address || !md_map || !md_phone || !peisong_price || !up_price || !peisong_fanwei || !peisong_service || !online_time) {
            layer.alert('请填写完整信息');
            return false;
        }
        var arr = md_map.split(',');
        var new_map = arr[1]+','+arr[0];
        $.get('/admin/md/create',{md_name:md_name,md_address:md_address,md_map:new_map,md_phone:md_phone,up_price:up_price,peisong_fanwei:peisong_fanwei,peisong_price:peisong_price,peisong_service:peisong_service,online_time:online_time},function(res){
            if(res.code == '1000'){
                layer.msg(res.msg);
                window.location.reload();
            }else{
                layer.msg(res.msg);
            }
        })
    }
    function edit(id)
    { 
        if(!id) {
          layer.alert('参数错误');
            return false;
        }
        $.get('/admin/md/edit',{id:id},function(res){
          console.log(res);
          if(res.code == '1000') {
              $('#id').val(res.result.id);
              $('.md_name2').val(res.result.md_name);
              $('.md_address2').val(res.result.md_address);
              $('.md_map2').val(res.result.md_map);
              $('#md_phone2').val(res.result.md_phone);
              $('#peisong_price2').val(res.result.peisong_price);
              $('#peisong_fanwei2').val(res.result.peisong_fanwei);
              $('#peisong_service2').val(res.result.peisong_service);
              $('#online_time2').val(res.result.online_time);
              $('#up_price2').val(res.result.up_price);
              $('#myModal2').modal();
          }
        })
    }
    function update()
    {
        var md_name =  $('.md_name2').val();
        var md_address = $('.md_address2').val();
        var md_map = $('.md_map2').val();
        var md_phone = $('#md_phone2').val();
        var id = $('#id').val();
        var up_price = $('#up_price2').val();
        var peisong_price = $('#peisong_price2').val();
        var peisong_fanwei = $('#peisong_fanwei2').val();
        var peisong_service = $('#peisong_service2').val();
        var online_time = $('#online_time2').val();

        if(!md_name || !md_address || !md_map || !md_phone || !peisong_price || !up_price || !peisong_fanwei || !peisong_service || !online_time) {
            layer.alert('请填写完整信息');
            return false;
        }
        var arr = md_map.split(',');
        var new_map = arr[1]+','+arr[0];
        $.get('/admin/md/update',{id:id,md_name:md_name,md_address:md_address,md_map:new_map,md_phone:md_phone,up_price:up_price,peisong_fanwei:peisong_fanwei,peisong_price:peisong_price,peisong_service:peisong_service,online_time:online_time},function(res){
            console.log(res);
            if(res.code == '1000'){
                layer.msg(res.msg);
                window.location.reload();
            }else{
                layer.alert(res.msg);
            }
        }) 
    }
</script>
@endsection
@section('title','门店列表')
@section('md','menu-open')
@section('md2','active')
@section('md-list','active')