@extends('Public.index')
@section('admin')

<div class="content-wrapper" style="min-height: 810px;">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>文章列表</h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/admin/index">首页</a></li>
              <li class="breadcrumb-item active">文章管理</li>
              <li class="breadcrumb-item active">文章列表</li>
            </ol>
          </div>
        </div>
      </div>
    </section>
    <div class="col-xs-3">
        <button class="btn btn-primary add" style="margin-left:17px;margin-bottom:15px">添加文章 +</button>
    </div>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">

            <div class="card">
              <div class="card-body p-0">
                <table class="table table-condensed">
                  <tbody>
               
                  <tr style="text-align:center">
                    <th>文章名</th>
                    <th>文章类型</th>
                    <th>状态</th> 
                    <th>置顶</th>
                    <th style="width: 100px">操作</th>
                  </tr>
                  @foreach($wz_list as $key => $val)
                  <tr style="text-align:center">
                    <td>{{ $val -> wz_name }}</td>
                    <td>{{ DB::table('wz_cate') -> where('id',$val -> pid) -> value('cate_name') }}</td>
                    <td>
                        @if($val -> status == 1)
                        <a href="javascript:void(0)" onclick="status({{$val -> id}})"><span class="badge bg-success">上架中</span></a>
                        @else
                        <a href="javascript:void(0)" onclick="status({{$val -> id}})"><span class="badge bg-danger">下架中</span></a>
                        @endif
                    </td>
                    <td>
                        @if($val -> orders < 0)
                        <a href="javascript:void(0)" onclick="tops({{$val -> id}})"><span class="badge bg-success">已置顶</span></a>
                        @else
                        <a href="javascript:void(0)" onclick="tops({{$val -> id}})"><span class="badge bg-danger">未置顶</span></a>
                        @endif
                    </td>
                    <td>
                        <a href="javascript:void(0)" onclick="edit({{$val -> id}})"><i class="fa fa-edit" style="font-size: 16px;" title="编辑"></i></a>
                        <a href="javascript:void(0)" onclick="del({{$val -> id}})"><i class="fa fa-trash" style="font-size: 16px;" title="删除"></i></a>
                    </td>
                  </tr>
                  @endforeach
                </tbody></table>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
<script src="/admin/plugins/jquery/jquery.min.js"></script>
<script src="/admin/layer-v3.1.1/layer/layer.js"></script>
<script>
   
   function del(id)
    {
        if(!id) {
            layer.msg('参数不全');
            return false;
        }
        layer.confirm('确认删除该文章吗？', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/wenzhang/delete',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });
    }
    function status(id)
    {
        if(!id){
            layer.alert('参数错误');
            return false;
        }
        layer.confirm('确认操作吗？', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/wenzhang/status',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });  
    }
    // 人工置顶
    function tops(id)
    {
        if(!id){
            layer.alert('参数错误');
            return false;
        }
        layer.confirm('确认操作吗？', {
            btn: ['确认','取消'] //按钮
            }, function(){
                $.get('/admin/wenzhang/top',{id:id},function(res){
                    if(res.code == '1000'){
                        layer.msg(res.msg);
                        window.location.reload();
                    }else{
                        layer.msg(res.msg);
                    }
                })
        });  
    }
    function edit(id)
    {
      if(!id){
        layer.alert('参数错误');
        return false;
      }
      window.location.href="/admin/wenzhang/edit/"+ id;
    }
    //添加文章页面
    $('.add').click(function(){
      window.location.href="/admin/wenzhang/add";
    })
</script>
@endsection
@section('title','文章列表')
@section('wz','menu-open')
@section('wz2','active')
@section('wzlist','active')