<?php

use Illuminate\Http\Request;
//登录
Route::post('/login','Api\LoginController@index');
Route::get('/userInfo','Api\LoginController@userInfo');
//首页里面的门店大全
Route::get('/getMd','Api\MdController@getMd');
Route::get('/getFirstMd','Api\MdController@getFirstMd');   //获取商城门店和商品信息
Route::get('/hotgoods','Api\MdController@hotgoods');   //获取首页门店和商品信息
Route::get('/getGoodsCateOne','Api\MdController@getGoodsCateOne');   //手动拿取商品分类下的商品
Route::get('/getGoodsDetail','Api\MdController@getGoodsDetail');   //显示商品详情
Route::get('/numPrice','Api\MdController@numPrice');   //首页计算购物车总额和单价 商品名称
Route::get('/goodsGuiGe','Api\MdController@goodsGuiGe');   //首页计算购物车总额和单价 商品名称  4-2增加规格  单独计算

//简诺文章
Route::get('/getJanRosyCate','Api\JanRosyController@getJanRosyCate');   //获取简诺文章分类和全部文章

//关于简诺
Route::get('/getAbout','Api\MeController@getAbout');   //获取关于简诺介绍

//确认订单页面计算优惠后的价格
Route::get('/getPrice','Api\MdController@getPrice');
//点击配送后判断地址是否超出配送范围
Route::get('/is_juli','Api\MdController@is_juli');
//文章页面搜索
Route::get('/search','Api\JanRosyController@search');
Route::post('/searchgoods','Api\ShopingController@searchgoods');  //商品搜索页面搜索功能
Route::post('/messtel','Api\ShopingController@messtel');  //发送手机号验证码
//令牌中间件
Route::group(['middleware'=>'token'],function(){
    Route::get('/getWzDetail','Api\JanRosyController@getWzDetail');   //获取简诺文章详情

    Route::post('/getOrderPrev','Api\MdController@getOrderPrev');   //订单确认页面
    Route::post('/cancelOrder','Api\MdController@cancelOrder');   //待支付取消订单页面
    Route::get('/getAddress','Api\MdController@getAddress');   //查询地编辑地址页面
    Route::get('/saveAddress','Api\MdController@saveAddress');   //保存地址
    Route::get('/getUserAddress','Api\MdController@getUserAddress');   //重新查询用户地址
    Route::get('/getYouhui','Api\MdController@getYouhui');   //重新查询用户地址
    Route::post('/getPhone','Api\MdController@getPhone');  //购物车自动获取手机号码


    //购物车
    Route::post('/shoping','Api\ShopingController@shoping');   //购物车订单生成
    Route::post('/shopnumPrice','Api\ShopingController@shopnumPrice');   //购物车订单生成方式1
    Route::post('/shopnumPrice2','Api\ShopingController@shopnumPrice2');   //购物车订单生成方式2
    Route::post('/shopnumPrice3','Api\ShopingController@shopnumPrice3');   //购物车订单做减法
    Route::post('/shopnumPrice4','Api\ShopingController@shopnumPrice4');   //购物车订单做减法
    Route::post('/shopordersel','Api\ShopingController@shopordersel');   //购物车查询显示小程序
    Route::post('/shopnewsel','Api\ShopingController@shopnewsel');   //购物车查询显示小程序


    //支付
    Route::post('/pay','Api\PayController@pay');   //支付
    Route::post('/janPay','Api\PayController@janPay');   //钱包支付  验证密码扣款
    Route::any('/wechat','Api\PayController@wechat');  //微信支付
    Route::post('/wechatPay','Api\PayController@wechatPay');  //微信支付
    //个人中心  订单
    Route::get('/getOrder','Api\MeController@getOrder');  //订单
    Route::get('/getOrderDetail','Api\MeController@getOrderDetail');  //订单详情
    Route::get('/getAccessPrice','Api\MeController@getAccessPrice');  //我的账户
    Route::post('/setAccessPWD','Api\MeController@setAccessPWD');  //设置账户初始密码
    Route::get('/record','Api\MeController@record');  //交易记录
    Route::get('/getJifen','Api\MeController@getJifen');  //积分和积分记录 
    Route::get('/sl_jifenPay','Api\PayController@sl_jifenPay');  //沙龙积分支付
    Route::post('/accessPay','Api\PayController@accessPay');  //沙龙账户支付
    Route::post('/sl_wechatPay','Api\PayController@sl_wechatPay');  //沙龙微信支付
    
    //沙龙报名
    Route::get('/getShaLong','Api\MeController@getShaLong');   //查找我的沙龙报名

    //充值
    Route::get('/getVip','Api\MeController@getVip');
    //进行订单生成
    Route::post('/accessPayMoney','Api\PayController@accessPayMoney');
    //支付成功进行充值
    Route::post('/accessPayMoneyDo','Api\PayController@accessPayMoneyDo');
    //会员体系获取会员等级
    Route::get('/getVipLevel','Api\MeController@getVipLevel');

    //优惠券分享
    Route::get('/share','Api\MeController@share');
    
    
});
Route::get('/sendTemplateMsg','Api\PayController@sendTemplateMsg');   //模板消息
Route::get('/sendSocketMsg','Api\PayController@sendSocketMsg');   //订单提醒



