/*
SQLyog  v12.2.6 (64 bit)
MySQL - 5.5.53 : Database - sale
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`sale` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `sale`;

/*Table structure for table `about` */

DROP TABLE IF EXISTS `about`;

CREATE TABLE `about` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `about` */

insert  into `about`(`id`,`content`) values 

(1,'<p style=\"text-align: left; line-height: 1.75em;\"><strong>凉山州物产</strong></p><p style=\"text-align: left; line-height: 1.75em;\"><strong><br/></strong>凉山彝族自治州是四川省下辖自治州，位于四川省西南部，是发展绿色农业最适宜区、国家农业综合开发重点地区，也是我国同纬度地区日照时数和总辐射量最多的地区之一。<br/>&nbsp;<br/>近年来，凉山州大力发展无污染、无公害、绿色有机健康产品，确保安全、营养、美味的回归，解决工业化带给人类对食品安全问题的困惑，孕育出多项享誉全国的特色农牧产品。<br/>&nbsp;<br/>目前凉山已创建中国名牌1个、中国驰名商标7个、国家“三品一标”218个。建成全国最大的苦荞麦生产基地，四川最大的草食畜生产基地，被授予“中国苦荞之都”、“中国茧丝之都”等称号。<br/><strong>&nbsp;<br/>千里凉山，农业大洲</strong><br/>&nbsp;<br/>凉山气候属于亚热带季风气候区，凉山的大山、大水、大资源，光、温、水、气构成的“黄金组合”，铸就了“大凉山”特色农产品优质、错季、绿色、生态的独特品质，被誉为“大自然的恩赐、人世间的珍品”。<br/>&nbsp;<br/>凉山雷波脐橙、盐源苹果、会理石榴、越西贡椒、德昌草莓等特色农产品，在大凉山得天独厚的自然地理条件下孕育而生。<br/>&nbsp;<br/>但是，因大凉山地处偏远的少数民族地区，存在农业文明整体水平偏低、农业产业化发展起步晚、市场信息相对闭塞的问题，有货物没销路，导致大山里的好东西“走不出去”。<br/><strong>&nbsp;<br/>凉山州扶贫展销平台</strong><br/>&nbsp;<br/>平台直接连接到大凉山，搭建农产品电子交易信息平台，利用互联网促进农产品信息传递，打通凉山和外界，让优质食品特产不再固守深山，推向全国各地。<br/>&nbsp;<br/>凉山州扶贫展销平台搭建推介到成交之间的桥梁，切实为凉山贫困人群解决销售的困难，带动农户增产收入，直接帮扶到县到村到人，实现贫困群众脱贫致富。<br/></p>');

/*Table structure for table `access` */

DROP TABLE IF EXISTS `access`;

CREATE TABLE `access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(255) unsigned NOT NULL COMMENT '用户id',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `kt_time` varchar(255) NOT NULL COMMENT '开通时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

/*Data for the table `access` */

insert  into `access`(`id`,`user_id`,`price`,`kt_time`) values 

(19,105,0.00,'1557028566'),

(20,104,0.00,'1557212162');

/*Table structure for table `admin_you` */

DROP TABLE IF EXISTS `admin_you`;

CREATE TABLE `admin_you` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '优惠券名字',
  `type` int(1) unsigned NOT NULL COMMENT '1直减  2折扣',
  `price` varchar(10) NOT NULL COMMENT '直减或者折扣力度',
  `use_height_type` int(1) unsigned NOT NULL COMMENT '优惠券使用门槛  1无门槛  2满？可用  关联use_height',
  `use_height` int(10) unsigned DEFAULT NULL COMMENT '满多少钱可用   use_height_type 为2时使用',
  `send_type` int(1) DEFAULT NULL COMMENT '发放类型  1无限制  2限制数量',
  `send_num` int(10) unsigned DEFAULT NULL COMMENT '发放数量    send_type 为2时可使用',
  `use_num` int(255) unsigned DEFAULT '0' COMMENT '已领取数量',
  `end_date` varchar(255) NOT NULL COMMENT '有效期截止时间',
  `md` int(255) unsigned NOT NULL COMMENT '门店限制   能使用的门店id  0为全部门店可用  其他为门店的id',
  `use_type` int(1) unsigned NOT NULL COMMENT '商品使用范围  1全部 2以下可用  3以下不可用',
  `use_size` varchar(255) DEFAULT NULL COMMENT '指定商品id   指定商品不可用id   全部不需要id',
  `addtime` varchar(255) NOT NULL COMMENT '添加时间',
  `tips` text COMMENT '优惠券说明',
  `send_user_type` int(1) unsigned NOT NULL COMMENT '发放的用户类型 0会员充值券 1所有人  2指定类型  3指定用户',
  `send_user` varchar(255) DEFAULT NULL COMMENT '发放给谁  send_user_type为1时为空  为2时为会员 非会员 新用户的类型id  为3时时指定用户的id',
  `status` int(1) unsigned DEFAULT '1' COMMENT '1正常   0关闭',
  `newUser` int(10) unsigned DEFAULT '0' COMMENT '1为注册用户也要发',
  `vip` int(1) unsigned DEFAULT '0' COMMENT '0为普通  1-5为vip充值相应等级专享券',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8;

/*Data for the table `admin_you` */

insert  into `admin_you`(`id`,`name`,`type`,`price`,`use_height_type`,`use_height`,`send_type`,`send_num`,`use_num`,`end_date`,`md`,`use_type`,`use_size`,`addtime`,`tips`,`send_user_type`,`send_user`,`status`,`newUser`,`vip`) values 

(92,'新用户专享满减券',1,'3',2,3,1,NULL,4,'1559232000',0,1,'','1557039654','新用户专享满减券，下单直接抵扣使用',1,NULL,1,0,0),

(93,'满减券',1,'1',1,0,1,NULL,6,'1559232000',0,1,'','1557991903','无',1,NULL,1,0,0),

(94,'满减1',1,'0.1',1,0,1,NULL,6,'1559232000',0,1,'','1557991942','无',1,NULL,1,0,0);

/*Table structure for table `adminuser` */

DROP TABLE IF EXISTS `adminuser`;

CREATE TABLE `adminuser` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(255) NOT NULL COMMENT '密码  Hash',
  `rule` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '权限角色',
  `status` int(1) unsigned NOT NULL DEFAULT '1' COMMENT ' 状态  1正常  0冻结',
  `md_id` int(255) unsigned DEFAULT NULL COMMENT '如果rule为2，则判断是哪个门店的管理员',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `adminuser` */

insert  into `adminuser`(`id`,`username`,`password`,`rule`,`status`,`md_id`) values 

(1,'admin','$2y$10$CkTkHPL1CtQBy4s9.F9F8.r2AeKZUdQlV9nweyg1tE/3L1E8uffE6',1,1,NULL),

(2,'chenxu','$2y$10$/.e0WPSjargYmY5yUUfLjuCRqp5LIl0qRLyzDn.triXq.VWHkzD/G',2,1,1),

(3,'chenxu2','$2y$10$/aISsV5VwFE42pYr/Dheg.xCJQjXTq6MesgEZeCqb3gOpa4j23syG',2,1,2);

/*Table structure for table `goods` */

DROP TABLE IF EXISTS `goods`;

CREATE TABLE `goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_id` int(255) unsigned DEFAULT NULL COMMENT '门店id',
  `pid` int(255) unsigned DEFAULT NULL COMMENT '分类id',
  `orders` int(255) unsigned DEFAULT '1' COMMENT '排序',
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `goods_images` varchar(255) DEFAULT NULL COMMENT '商品图',
  `goods_keywords` varchar(255) DEFAULT NULL COMMENT '产品简介',
  `goods_description` text COMMENT '商品简介  类似淘宝介绍图文',
  `goods_xiaoliang` int(255) unsigned DEFAULT '0' COMMENT '商品销量',
  `goods_look` int(255) unsigned DEFAULT '0' COMMENT '商品浏览量',
  `price` decimal(8,2) DEFAULT '0.00' COMMENT '价格',
  `addtime` varchar(255) DEFAULT NULL COMMENT '时间戳',
  `status` int(1) unsigned DEFAULT '1' COMMENT '上下架状态 0下 1上 2热销',
  `peisong_type` int(1) unsigned DEFAULT '1' COMMENT '支持的是配送还是自取  1全部 2配送 3自取',
  `xuhao` int(11) unsigned DEFAULT NULL COMMENT '商品序号，后台自己看的',
  `beizhu` varchar(1000) NOT NULL,
  `is_recomd` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=385 DEFAULT CHARSET=utf8;

/*Data for the table `goods` */

insert  into `goods`(`id`,`md_id`,`pid`,`orders`,`goods_name`,`goods_images`,`goods_keywords`,`goods_description`,`goods_xiaoliang`,`goods_look`,`price`,`addtime`,`status`,`peisong_type`,`xuhao`,`beizhu`,`is_recomd`) values 

(11,4,8,385,'大凉山滋摩油菜花蜂蜜','uploads/25220_112702_1150.png','养蜂扶贫，生态蜜源，淡淡的油菜花香，恰到好处的香甜','<p style=\"text-align:center\"><img src=\"/ueditor/php/upload/image/20190506/1557124677523771.jpg\" title=\"1557124677523771.jpg\" alt=\"1557124677523771.jpg\" width=\"640\" height=\"360\"/></p><p style=\"margin-top: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山油菜花蜂蜜，产自四川凉山彝族自治州，这里自然环境原始纯净，冬无严寒，夏无酷暑，四季如春，具有产出优质蜂蜜的良好环境。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山油菜花蜂蜜，采集高山生长的油菜花酿成，性温润，具有清热润燥的功效，适宜脾胃虚弱者食用</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><img src=\"/ueditor/php/upload/image/20190506/1557125281120545.jpg\" title=\"1557125281120545.jpg\" alt=\"1557125281120545.jpg\" width=\"450\" height=\"338\"/></p>',0,0,54.00,'1556596591',1,1,385,'大凉山滋摩油菜花蜂蜜',1),

(12,4,8,2,'大凉山滋摩洋槐花蜂蜜','uploads/25220_143426_6581.png','蜜中极品，清热润燥','<p><img src=\"/ueditor/php/upload/image/20190506/1557137186286365.jpg\" title=\"1557137186286365.jpg\" alt=\"386-1.jpg\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">大凉山洋槐花蜂蜜，产自四川凉山彝族自治州，这里自然环境原始纯净，冬无严寒，夏无酷暑，四季如春，具有产出优质蜂蜜的良好环境。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山洋槐花蜂蜜，具有槐花芳香，富含果糖，蜜色透彻不易结晶，清润爽口，具有养心醒目等功效</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><img src=\"/ueditor/php/upload/image/20190506/1557137425919123.jpg\" title=\"1557137425919123.jpg\" alt=\"386-2.jpg\"/></p>',0,0,80.00,'1556597296',1,1,386,'大凉山滋摩洋槐花蜂蜜',1),

(15,4,8,3,'大凉山滋摩索玛花蜂蜜','uploads/25220_143656_1397.png','入口芬香浓郁，属上等早春蜜','<p style=\"white-space: normal; margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557822382249778.jpg\" title=\"1557822382249778.jpg\" alt=\"387-1.jpg\"/></span></p><p style=\"white-space: normal; margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山油菜花蜂蜜，产自世界自然基金会保护地——四川大凉山，这里自然环境原始纯净，冬无严寒，夏无酷暑，四季如春，具有产出优质蜂蜜的良好环境。</span></p><p style=\"white-space: normal; margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山索玛花蜂蜜，采集高山生长的索玛花酿成，自然醇香，具有降三高、提高免疫力、美容养颜的功效，适宜饮食不规律者、易疲劳者、经常应酬和加班人群、中老年人群食用</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"white-space: normal; margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557822604984957.jpg\" title=\"1557822604984957.jpg\" alt=\"387-2.jpg\"/></span></p>',0,0,93.00,'1556606113',1,1,387,'大凉山滋摩索玛花蜂蜜',1),

(16,4,8,4,'特级初榨橄榄油（黑盒）','uploads/25220_171139_6344.png','挑选新鲜果实，健康吃好油','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557824664965878.jpg\" title=\"1557824664965878.jpg\" alt=\"260-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">凉山州地处中国长江中上游地带，其金沙江干热河谷和安宁河流域土壤、气温、光照和降水都十分适合油橄榄的升值，是我国发展油橄榄仅有的两个一类适宜区之一。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山产区年日照2400小时以上，采果后4-12小时内纯物理第一道冷榨，保证油的新鲜度，采用18-22℃避光保存，国内生产直销，营养价值不容易随着时间变低</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><img src=\"/ueditor/php/upload/image/20190514/1557824851274101.jpg\" title=\"1557824851274101.jpg\" alt=\"260-2.jpg\"/></p>',0,0,208.00,'1556606836',1,1,260,'特级初榨橄榄油（黑盒）',0),

(17,4,8,5,'大凉山鸡枞油（特级）','uploads/25220_144144_3732.png','野生鲜鸡枞，菜籽油炒制，菌香浓郁，脆嫩爽口','<p><img src=\"/ueditor/php/upload/image/20190514/1557825606800463.jpg\" title=\"1557825606800463.jpg\"/></p><p><img src=\"/ueditor/php/upload/image/20190514/1557825611113402.jpg\" title=\"1557825611113402.jpg\"/></p>',0,0,425.00,'1556607241',1,1,312,'鸡枞油（特级）1000g',0),

(18,4,8,340,'会东松露粉','uploads/25220_182526_7692.png','天地厚爱，孕育珍贵野生黑松露，世界公认的极品美食','<p style=\"margin-bottom: 15px; margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557826313672711.jpg\" title=\"1557826313672711.jpg\" alt=\"340-1.jpg\"/></span></p><p style=\"margin-bottom: 15px; margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">四川大凉山会理县，海拔1600-3200米，北纬30°附近，位于无污染的自然保护区，天地厚爱，孕育珍贵野生黑松露，价值十分昂贵，在欧洲被称为可以吃的黑钻石</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-bottom: 15px; margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">松露营养价值丰富，含有丰富的蛋白质和18种氨基酸（包括人体不能合成的8种必须氨基酸），常食松露，大大有益于身体健康</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-bottom: 15px; line-height: normal; margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557826324643400.jpg\" title=\"1557826324643400.jpg\" alt=\"340-2.jpg\"/></span></p><p><br/></p>',0,0,81.00,'1556607735',1,1,340,'会东松露粉',0),

(19,4,8,7,'大凉山山里鲜汤料','uploads/25220_144802_7671.png','菌香浓郁，均衡配比，让煲汤成为一件浪漫的事','<p><img src=\"/ueditor/php/upload/image/20190514/1557828137288663.jpg\" title=\"1557828137288663.jpg\" alt=\"234-1.jpg\"/></p>',0,0,23.00,'1556608286',1,1,234,'',0),

(20,4,10,121,'大凉山黑苦荞全株茶','uploads/25220_142614_3854.png','茶色清凉，荞香四溢，珍稀苦荞，口味地道','<p><img src=\"/ueditor/php/upload/image/20190506/1557126152871119.jpg\" title=\"1557126152871119.jpg\" alt=\"1557126152871119.jpg\" width=\"450\" height=\"350\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">产自四川大凉山高寒山区，富含生物黄酮、维生素、纤维素、矿物质等营养物质。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">大凉山黑苦荞全株茶，麦香浓郁，汤色黄绿，口感纯正。内含38小袋独立包装，防潮、便携。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557126216888493.jpg\" title=\"1557126216888493.jpg\" alt=\"121-2.jpg\"/></span></p>',0,0,116.00,'1556608566',1,1,121,'三匠黑苦荞全株茶',0),

(21,4,10,2,'大凉山黑苦荞全胚茶盒装（天泽）','uploads/25220_143500_2706.png','高寒之地的“黑珍珠”，经得起比较的苦荞茶','<p><img src=\"/ueditor/php/upload/image/20190506/1557137952401078.jpg\" title=\"1557137952401078.jpg\" alt=\"138-1.jpg\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山全胚芽黑苦荞茶，乃是可饮也可食的五谷，黑苦荞原料精选自海拔2600米以上的四川高寒山区——大凉山，采用低温烘焙再破碎，营养不丢失。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">被称为“高寒之地的黑珍珠”，喝一杯苦荞茶，给健康加分。在长时间工作、驾驶之后，用一杯苦荞茶释放压力......让生活节奏慢一些。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557138228252983.jpg\" title=\"1557138228252983.jpg\" alt=\"138-2.jpg\"/></span></p>',0,0,633.00,'1556609334',1,1,138,'',0),

(22,4,10,3,'大凉山黑苦荞全皮茶盒装 （境界淡泊）','uploads/25220_143722_8124.png','3000米高寒黑苦荞，感悟淡泊境界','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557909406275478.jpg\" title=\"1557909406275478.jpg\" alt=\"144-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山黑苦荞茶精选四川凉山海拔3000米以上高寒山区所产的优质黑苦荞麦为原料，该特殊品种生长周期极长，成熟期甚至超过了130天，超长的生长周期决定了其能吸收更多的阳光雨露，聚集更多的天然营养，品质比普通黑苦荞高出许多。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">本产品采用彝族古法获取苦荞营养价值更高的麦皮层，以纯麦皮层制作出更营养的全皮茶，皮层经粉碎后以细颗粒存在，在相同冲泡条件下，能更好的将营养成分在茶水中释出。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557909413662324.jpg\" title=\"1557909413662324.jpg\" alt=\"144-2.jpg\"/></span></p>',0,0,308.00,'1556609747',1,1,144,'',0),

(23,4,10,4,'大凉山苦荞冬瓜荷叶茶','uploads/25220_144000_9011.png','甄选天然原材料，黄金配比，口感醇清凉','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557911149981015.jpg\" title=\"1557911149981015.jpg\" alt=\"180-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">苦荞+冬瓜荷叶茶，冬瓜荷叶和苦荞的完美结合，香气四溢，久久回味，汤色清甜宜人，入口清香。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">选用大凉山高寒山区黑苦荞，含有生物类黄酮和矿物元素硒</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。天然花草配方，随心冲泡。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557911156295886.jpg\" title=\"1557911156295886.jpg\" alt=\"180-2.jpg\"/></span></p>',0,0,52.00,'1556610672',1,1,180,'',0),

(24,4,10,5,'大凉山苦荞茶盒装（荞园礼记）','uploads/25220_144215_2951.png','橙黄色超微颗粒，汤色黄绿清亮、荞香浓郁','<p style=\"margin-top: 20px; white-space: normal; text-align: center;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557912771377480.jpg\" title=\"1557912771377480.jpg\" alt=\"101-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">精选大凉山高寒山区的优质苦荞为原料，精制而成，苦荞含有生物类黄酮、矿物元素硒、蛋白质等营养元素。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">本产品可赏汤映色，又可赏气挂香，口感清爽舌尖甘而回味甜。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557912779872529.jpg\" title=\"1557912779872529.jpg\" alt=\"101-2.jpg\"/></span></p><p><br/></p>',0,0,127.00,'1556612411',1,1,101,'',0),

(25,4,13,1,'大凉山苦荞口口香糕','uploads/25220_143018_8800.png','无蔗糖的休闲糕点，荞麦香浓郁，绵软可口','<p><img src=\"/ueditor/php/upload/image/20190506/1557126990228202.jpg\" title=\"1557126990228202.jpg\" alt=\"71-1.jpg\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">来自大凉山的传统清凉糕点，唇齿留香，是大鱼大肉过后的理想休闲食品。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">口口香糕经过万千吃货的口碑认证，可以作为早餐、下午茶和任何时候的休闲零嘴，口口香糕，口口美味。</span></p><p><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557127020272313.jpg\" title=\"1557127020272313.jpg\" alt=\"71-2.jpg\"/></span></p>',0,0,14.00,'1556612796',1,1,71,'',0),

(26,4,13,2,'大凉山走婚桥苹果片','uploads/25220_143527_6063.png','自然色泽，果真美味，香脆清甜，一品难忘','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557977805353242.jpg\" title=\"1557977805353242.jpg\" alt=\"81-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">泸沽湖特产，采用海拔2300米种植的高原金帅苹果加工而成，保留了金帅苹果特有的酸、甜。采用独特热风干技术，乐享苹果原滋味。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557977816650330.jpg\" title=\"1557977816650330.jpg\" alt=\"81-2.jpg\"/></span></p>',0,0,33.00,'1556613021',1,1,81,'',0),

(27,4,13,3,'大凉山有机松仁','uploads/25220_143750_3264.png','松香味浓，干净饱满，无添加更自然','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557978625311305.jpg\" title=\"1557978625311305.jpg\" alt=\"88-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">好松籽来自好产地，产品采集于中国华山松第一县——会东县，富含钙、磷、铁等多种微量营养成分和维他命。颗颗精选，剔除瑕疵。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">松香味浓，干净饱满，无添加更自然</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557978633863381.jpg\" title=\"1557978633863381.jpg\" alt=\"88-2.jpg\"/></span></p>',0,0,68.00,'1556613328',1,1,88,'',0),

(28,4,13,4,'大凉山芒果干','uploads/25220_144031_9595.png','酸酸甜甜，吃出大鲜芒的味道！','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557988144307787.jpg\" title=\"1557988144307787.jpg\" alt=\"35-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山芒果干，超过1500小时日照，得天独厚的优越地理环境，造就酸甜适口的味道，约1:25的黄金酸甜比，鲜甜中带着微酸的才是好芒果干。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">约16%含水量，软硬适中，吃出阳光和自然的味道</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。每一片芒果干都果香四溢，陶醉于心。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557988154783204.jpg\" title=\"1557988154783204.jpg\" alt=\"35-2.jpg\"/></span></p><p><br/></p>',0,0,18.00,'1556613511',1,1,35,'',1),

(29,4,13,5,'大凉山苦荞木糖醇芝麻酥','uploads/25220_170701_3836.png','休闲时光，下午茶点','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557988499226638.jpg\" title=\"1557988499226638.jpg\" alt=\"24-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">来自大凉山·苦荞与小麦的结合，上等的下午茶点，酥脆美味。塑像可口的酥饼，配上一杯浓郁的苦荞茶，带来不一样的奇妙体验。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557988506702983.jpg\" title=\"1557988506702983.jpg\" alt=\"24-2.jpg\"/></span></p><p><br/></p>',0,0,20.00,'1556613775',1,1,24,'环太苦荞木糖醇芝麻酥（17版）',0),

(30,4,9,1,'大凉山青杠菌','uploads/25220_143135_2041.png','远离任何污染，生长在蓝天白云松林，自然孕育，高原特产','<p><img src=\"/ueditor/php/upload/image/20190506/1557127702358587.jpg\" title=\"1557127702358587.jpg\" alt=\"214-1.jpg\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">青钢菌又叫鸡丝菌、老鹰菌，目前无法人工种植，只跟随着青杠树生长在海拔2800-3500米左右的原始森林里，十分珍贵。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">青杠菌晒干后表面有一层白色的霜，并非发霉，泡发的时候轻轻揉洗一下就没有了。青杠菌用冷水加盐泡发即可，一般只需泡发2-3小时，再将根部切掉便能烹饪。<br/></span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557128179656591.jpg\" title=\"1557128179656591.jpg\" alt=\"214-2.jpg\"/></span></p>',0,0,123.00,'1556614327',1,1,214,'',1),

(31,4,9,2,'大凉山松露','uploads/25220_143555_8131.png','雨露为伴，品质臻选，精灵般的珍贵食材，至今无法人工培育','<p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><br/></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557828740208223.jpg\" title=\"1557828740208223.jpg\" alt=\"340-1.jpg\"/></span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">四川大凉山会理县，海拔1600-3200米，北纬30°附近，位于无污染的自然保护区，天地厚爱，孕育珍贵野生黑松露，价值十分昂贵，在欧洲被称为可以吃的黑钻石</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">松露营养价值丰富，含有丰富的蛋白质和18种氨基酸（包括人体不能合成的8种必须氨基酸），常食松露，大大有益于身体健康</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557828750108374.jpg\" title=\"1557828750108374.jpg\" alt=\"340-2.jpg\"/></span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal; line-height: normal;\"><br/></p>',0,0,579.00,'1556614536',1,1,250,'灿林松露（瓶装） 237  会东松露250',0),

(32,4,9,3,'大凉山见水青','uploads/25220_143824_9492.png','名贵少有的野生食用菌，乃“四大菌王”之一','<p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557829127278370.jpg\" title=\"1557829127278370.jpg\" alt=\"249-1.jpg\"/></span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">见水青隶属于牛肝菌科，含有较高的蛋白质、氨基酸、矿物质和谷氨酸</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。牛肝菌因肉质肥厚，形似牛肝而得名，是名贵少有的野生食用菌，也是“四大菌王”之一。</span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557829136669847.jpg\" title=\"1557829136669847.jpg\" alt=\"249-2.jpg\"/></span></p><p style=\"margin-top: 15px; margin-bottom: 15px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><br/></span></p>',0,0,78.00,'1556614712',1,1,249,'',0),

(33,4,9,4,'大凉山野生美味香菇（盒装）','uploads/25220_144054_4275.png','深山采集，手工剪根，特有野生菌浓郁香味','<p style=\"margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557829556711717.jpg\" title=\"1557829556711717.jpg\" alt=\"220-1.jpg\"/></span></p><p style=\"margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">源自大凉山自然保护区的天然野生香菇，高海拔热带季风性湿润气候，深山采集，手工剪根，自然晾晒，无工业添加剂，营养不流失</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。菇面平滑，底部呈淡黄色，特有野生菌浓郁香味。</span></p><p style=\"margin-top: 15px;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190514/1557829564974117.jpg\" title=\"1557829564974117.jpg\" alt=\"220-2.jpg\"/></span></p>',0,0,63.00,'1556614889',1,1,220,'',0),

(34,4,9,5,'大凉山单片黑木耳','uploads/25220_144527_6656.png','肉厚无根，形状小巧，弹性爽白，食之珍品','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557908490277678.jpg\" title=\"1557908490277678.jpg\" alt=\"231-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山单片黑木耳，肉厚无根，形状小巧，弹性爽白，口感脆滑，适合凉拌炒菜，胶质含量高，营养丰富。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">采摘晾晒后的木耳直达消费者，无放尘</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。每一朵木耳都是经过层层筛选，脉络清晰可见，胶质隐藏在脉络中，劣质木耳很难见到脉络。泡发后耳片有光泽，肉质肥厚。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557908497374411.jpg\" title=\"1557908497374411.jpg\" alt=\"231-2.jpg\"/></span></p>',0,0,45.00,'1556615028',1,1,231,'',0),

(35,4,11,1,'大凉山阳光苦荞粉','uploads/25220_143217_6690.png','纯苦荞，好原料，无污染，粉质细腻，劲道爽滑','<p style=\"margin-bottom: 20px; margin-top: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557129230387779.jpg\" title=\"1557129230387779.jpg\" alt=\"354-2.jpg\"/></span></p><p style=\"margin-bottom: 20px; margin-top: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">甄选大凉山2200米高寒苦荞，日照超1800小时，远离污染，原生原态。</span></p><p style=\"margin-bottom: 20px; margin-top: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">劲道爽滑，健康营养，可以烘烤成荞麦饼、薄饼、苦荞面包等美食。</span></p><p style=\"margin-bottom: 20px; margin-top: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557129466838339.jpg\" title=\"1557129466838339.jpg\" alt=\"354-1.jpg\"/></span></p>',0,0,12.00,'1556615210',1,1,354,'',1),

(36,4,11,2,'大凉山绿稻米','uploads/25220_143624_4128.png','闻到它，才知道稻米的醇香','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190515/1557915368715613.jpg\" title=\"1557915368715613.jpg\" alt=\"297-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">真空包装，锁住新鲜，确保每一粒大米的新鲜营养。地处北纬44°黄金水稻种植地带，无霜期140天，日照长达2629个小时。降水量充足，年均气温2~4℃，年均降水量500-800毫米，含丰富的营养成分。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><img src=\"/ueditor/php/upload/image/20190515/1557915395743673.jpg\" title=\"1557915395743673.jpg\" alt=\"297-2.jpg\"/></p>',0,0,33.00,'1556615378',1,1,297,'',0),

(37,4,11,3,'大凉山紫稻米','uploads/25220_143853_4341.png','色泽光亮，颗粒圆润，米香浓郁，软糯可口','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557974639449699.jpg\" title=\"1557974639449699.jpg\" alt=\"298-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山紫稻米，产自四川凉山彝族自治州，这里年降雨量高达1013毫米，全年日照时长2423小时，昼夜温差大，米香浓郁，软糯可口。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">遵循自然法则，一年只产一季，量少质优，坚持传统方法，真空包装</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557974647524461.jpg\" title=\"1557974647524461.jpg\" alt=\"298-2.jpg\"/></span></p><p><br/></p>',0,0,33.00,'1556615547',1,1,298,'',0),

(38,4,11,4,'大凉山红稻米','uploads/25220_144117_8395.png','富含微量元素，提高机体抗氧化，防治慢性病','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557973878552282.jpg\" title=\"1557973878552282.jpg\" alt=\"296-2.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">大凉山红稻米，产自四川凉山彝族自治州普格县，这里年降雨量高达1013毫米，全年日照时长2423小时，昼夜温差大，并且紧邻国家4A级螺髻山景区，远离污染，使用优质山泉水灌溉。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">遵循自然法则，一年只产一季，量少质优，坚持传统方法，真空包装</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557974124687031.jpg\" title=\"1557974124687031.jpg\" alt=\"296-1.jpg\"/></span></p><p><br/></p>',0,0,33.00,'1556615814',1,1,296,'',1),

(39,4,11,5,'大凉山苦荞米','uploads/25220_144556_6164.png','以黑苦荞麦为原料，色味清香，柔软可口，集七大营养素于一身','<p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557975203153026.jpg\" title=\"1557975203153026.jpg\" alt=\"383-1.jpg\"/></span></p><p style=\"margin-top: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">经过严格筛选、过滤等工序加工而成，采用黑苦荞麦为原料加工制成。是唯一集七大营养素于一身的谷物。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">食用方法不拘一格，只要做成熟食即可。可单独做米饭和粥，也能掺入到大米和其他杂粮中食用</span><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\">。气味清香，色泽黄绿，柔软可口。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px; white-space: normal;\"><span style=\"font-family: 黑体, SimHei; color: rgb(89, 89, 89); font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190516/1557975215374097.jpg\" title=\"1557975215374097.jpg\" alt=\"383-2.jpg\"/></span></p><p><br/></p>',0,0,16.00,'1556616026',1,1,383,'',0),

(40,4,12,1,'大凉山手撕牛肉','uploads/25220_143305_4225.png','鲜、香、辣，丝丝入味！','<p><br/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557130715445803.jpg\" title=\"1557130715445803.jpg\" alt=\"41-2.jpg\"/></span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">仅采用后腿肉，更有嚼劲，给您真手撕！四川凉山彝族自治州生产，传统风味，添加经典川味辣椒，香辣爽口。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><img src=\"/ueditor/php/upload/image/20190506/1557130724943077.jpg\" title=\"1557130724943077.jpg\" alt=\"41-1.jpg\"/></p>',0,0,90.00,'1556616414',1,1,41,'',1),

(41,4,12,1,'大凉山手撕板鸭干','uploads/25220_143353_1220.png','肉质细腻，有嚼劲！有麻辣、五香、泡椒和青椒四种口味','<p><img src=\"/ueditor/php/upload/image/20190506/1557133219437780.jpg\" title=\"1557133219437780.jpg\" alt=\"51-1.jpg\"/></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\">大凉山手撕板鸭干有麻辣、五香、泡椒和青椒四种口味，产品开袋即食，味香肉鲜，色泽红润，肉质绵软，极具嚼劲。是您馈赠亲友、居家旅行和休闲娱乐的最好食品。</span></p><p style=\"margin-top: 20px; margin-bottom: 20px;\"><span style=\"color: rgb(89, 89, 89); font-family: 黑体, SimHei; font-size: 12px;\"><img src=\"/ueditor/php/upload/image/20190506/1557136626490455.jpg\" title=\"1557136626490455.jpg\" alt=\"51-2.jpg\"/></span></p>',0,0,36.00,'1556617435',1,1,51,'',1),

(42,4,14,1,'凉山缘 · 锦绣','uploads/25220_151238_9738.png','源自纯天然无污染产区的上等之选，品类丰富的大凉山地道美味','<p><strong><span style=\"font-size:13px\">套餐内容：</span></strong></p><p><span style=\"font-size:13px\">大凉山红稻米</span></p><p><span style=\"font-size:13px\">大凉山紫稻米</span></p><p><span style=\"font-size:13px\">大凉山绿稻米</span></p><p><span style=\"font-size:13px\">螺髻山黑苦荞茶胚芽</span></p><p><span style=\"font-size:13px\">大凉山蘑菇</span></p><p><span style=\"font-size:13px\">大凉山苦荞米 </span></p><p><span style=\"font-size:13px\">大凉山黑苦荞粉</span></p><p><span style=\"font-size:13px\">大凉山生燕麦 </span></p><p><br/></p>',0,0,298.00,'1557040358',1,1,1,'',1),

(43,4,14,2,'凉山缘 · 天汇','uploads/25220_103035_2887.png','汇聚大凉山天赐珍宝，探寻自然之秘','<p><span style=\"font-size:13px\"><strong style=\"white-space: normal;\"><span style=\"font-size: 13px;\">套餐内容：</span></strong></span></p><p><span style=\"font-size:13px\">大凉山红稻米</span></p><p><span style=\"font-size:13px\">大凉山紫稻米</span></p><p><span style=\"font-size:13px\">大凉山绿稻米</span></p><p><span style=\"font-size:13px\">大凉山黄牛肝菌</span></p><p><span style=\"font-size:13px\">大凉山黑苦荞粉</span></p><p><span style=\"font-size:13px\">大凉山辣木籽</span></p><p><span style=\"font-size:13px\">大凉山珍品毛峰</span></p><p><br/></p>',0,0,398.00,'1557109835',1,1,2,'',0),

(44,4,14,3,'凉山缘 · 天藏','uploads/25220_103231_2237.png','云深之处的天藏之宝，一段与大凉山的美妙邂逅','<p><span style=\"font-size:13px\"><strong style=\"white-space: normal;\"><span style=\"font-size: 13px;\">套餐内容：</span></strong></span></p><p><span style=\"font-size:13px\"></span></p><p><span style=\"font-size:13px\">大凉山红稻米</span></p><p><span style=\"font-size:13px\">大凉山紫稻米</span></p><p><span style=\"font-size:13px\">大凉山绿稻米</span></p><p><span style=\"font-size:13px\">大凉山见水青</span></p><p><span style=\"font-size:13px\">大凉山野生美味牛肝菌</span></p><p><span style=\"font-size:13px\">大凉山高寒黑苦荞茶（全胚态）</span></p><p><span style=\"font-size:13px\">大凉山黑苦荞米</span></p><p><br/></p>',0,0,498.00,'1557109951',1,1,3,'',0),

(45,4,14,4,'凉山缘 · 原觅','uploads/25220_103717_8496.png','美味，源自严格的臻选。为您寻觅大凉山最原生的口感，感受原生纯净味道','<p><span style=\"font-size:13px\"><strong style=\"white-space: normal;\"><span style=\"font-size: 13px;\">套餐内容：</span></strong></span></p><p><span style=\"font-size:13px\">大凉山红稻米</span></p><p><span style=\"font-size:13px\">大凉山紫稻米</span></p><p><span style=\"font-size:13px\">大凉山绿稻米</span></p><p><span style=\"font-size:13px\">大凉山特级高寒苦荞茶</span></p><p><span style=\"font-size:13px\">大凉山野生香菇</span></p><p><span style=\"font-size:13px\">大凉山滋摩洋槐花蜂蜜</span></p><p><span style=\"font-size:13px\">大凉山五谷黑苦荞粉</span></p><p><br/></p>',0,0,598.00,'1557110237',1,1,4,'',0),

(46,4,14,5,'凉山缘 · 原臻','uploads/25220_103837_1945.png','精灵般的食材，至今无法人工培育。来自大凉山的自然馈赠，延续舌尖盛宴','<p style=\"white-space: normal;\"><strong><span style=\"font-size: 13px;\">套餐内容：</span></strong></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山红稻米</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山紫稻米</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山绿稻米</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">螺髻山黑苦荞茶胚芽</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山蘑菇</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山苦荞米</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山黑苦荞粉</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 13px;\">大凉山生燕麦</span></p><p><span style=\"font-size: 13px;\"><br/></span></p><p><br/></p>',0,0,698.00,'1557110317',1,1,5,'',0),

(47,4,10,1,'环太苦荞记忆',NULL,NULL,NULL,0,0,49.58,'1558406813',1,1,27,'环太苦荞记忆',0),

(48,4,10,1,'环太螺髻山黑苦荞茶超微',NULL,NULL,NULL,0,0,36.20,'1558406813',1,1,89,'环太螺髻山黑苦荞茶超微',0),

(49,4,10,1,'环太螺髻山黑苦荞茶胚芽（高铁罐装）',NULL,NULL,NULL,0,0,36.20,'1558406813',1,1,90,'环太螺髻山黑苦荞茶胚芽（高铁罐装）',0),

(50,4,10,1,'大凉山礼',NULL,NULL,NULL,0,0,199.09,'1558406813',1,1,91,'大凉山礼',0),

(51,4,10,1,'环太高寒黑苦荞茶（全胚态）盒装',NULL,NULL,NULL,0,0,86.88,'1558406813',1,1,92,'环太高寒黑苦荞茶（全胚态）盒装',0),

(52,4,10,1,'环太醇香黑苦荞茶（超微态）长铁盒装',NULL,NULL,NULL,0,0,123.44,'1558406813',1,1,93,'环太醇香黑苦荞茶（超微态）长铁盒装',0),

(53,4,10,1,'180g醇香黑苦荞（超微态） 熊猫黑',NULL,NULL,NULL,0,0,88.68,'1558406813',1,1,94,'180g醇香黑苦荞（超微态） 熊猫黑',0),

(54,4,10,1,'环太高寒黑苦荞茶（全胚态）长铁盒装',NULL,NULL,NULL,0,0,123.44,'1558406813',1,1,95,'环太高寒黑苦荞茶（全胚态）长铁盒装',0),

(55,4,10,1,'环太高寒黑苦荞茶（全胚态）长方盒装',NULL,NULL,NULL,0,0,68.78,'1558406813',1,1,96,'环太高寒黑苦荞茶（全胚态）长方盒装',0),

(56,4,10,1,'180g高寒黑苦荞（全胚态） 熊猫白',NULL,NULL,NULL,0,0,124.88,'1558406813',1,1,97,'180g高寒黑苦荞（全胚态） 熊猫白',0),

(57,4,10,1,'环太黄金黑苦荞茶（全株态）长铁盒装',NULL,NULL,NULL,0,0,153.85,'1558406813',1,1,98,'环太黄金黑苦荞茶（全株态）长铁盒装',0),

(58,4,10,1,'环太黄金黑苦荞茶（全株态）长方盒装',NULL,NULL,NULL,0,0,59.73,'1558406813',1,1,99,'环太黄金黑苦荞茶（全株态）长方盒装',0),

(59,4,10,1,'环太黄金黑苦荞茶（全株态）盒装',NULL,NULL,NULL,0,0,53.39,'1558406813',1,1,100,'环太黄金黑苦荞茶（全株态）盒装',0),

(60,4,10,1,'168g 苦荞茶（超微）',NULL,NULL,NULL,0,0,23.53,'1558406813',1,1,102,'168g 苦荞茶（超微）',0),

(61,4,10,1,'环太高寒黑苦荞茶（全胚态）长盒装',NULL,NULL,NULL,0,0,152.04,'1558406813',1,1,103,'环太高寒黑苦荞茶（全胚态）长盒装',0),

(62,4,10,1,'168g高寒黑苦荞茶（全胚态）',NULL,NULL,NULL,0,0,50.68,'1558406813',1,1,104,'168g高寒黑苦荞茶（全胚态）',0),

(63,4,10,1,'环太螺髻山散装黑苦荞茶（新版）',NULL,NULL,NULL,0,0,32.58,'1558406813',1,1,105,'环太螺髻山散装黑苦荞茶（新版）',0),

(64,4,10,1,'环太螺髻山散装苦荞茶（新版）',NULL,NULL,NULL,0,0,23.16,'1558406813',1,1,106,'环太螺髻山散装苦荞茶（新版）',0),

(65,4,10,1,'环太苦荞茶（新）',NULL,NULL,NULL,0,0,28.96,'1558406813',1,1,107,'环太苦荞茶（新）',0),

(66,4,10,1,'228g高寒黑苦荞茶（全胚态）（新）',NULL,NULL,NULL,0,0,124.88,'1558406813',1,1,108,'228g高寒黑苦荞茶（全胚态）（新）',0),

(67,4,10,1,'环太高寒黑苦荞茶（全胚态）',NULL,NULL,NULL,0,0,68.78,'1558406813',1,1,109,'环太高寒黑苦荞茶（全胚态）',0),

(68,4,10,1,'228g高寒黑苦荞全胚芽茶（脸谱铁盒）',NULL,NULL,NULL,0,0,153.85,'1558406813',1,1,110,'228g高寒黑苦荞全胚芽茶（脸谱铁盒）',0),

(69,4,10,1,'恒然黑苦荞茶（4.5）',NULL,NULL,NULL,0,0,226.25,'1558406813',1,1,111,'恒然黑苦荞茶（4.5）',0),

(70,4,10,1,'大凉山老鹰绿茶',NULL,NULL,NULL,0,0,123.08,'1558406813',1,1,112,'大凉山老鹰绿茶',0),

(71,4,10,1,'大凉山老鹰绿茶500g',NULL,NULL,NULL,0,0,181.00,'1558406813',1,1,113,'大凉山老鹰绿茶500g',0),

(72,4,10,1,'大凉山老鹰茶（红茶）盒装',NULL,NULL,NULL,0,0,434.39,'1558406813',1,1,115,'大凉山老鹰茶（红茶）盒装',0),

(73,4,10,1,'大凉山老鹰茶（绿茶）盒装',NULL,NULL,NULL,0,0,434.39,'1558406813',1,1,116,'大凉山老鹰茶（绿茶）盒装',0),

(74,4,10,1,'茶黄金（茗悦）盒装装特一级原叶油橄榄',NULL,NULL,NULL,0,0,1158.38,'1558406813',1,1,117,'茶黄金（茗悦）盒装装特一级原叶油橄榄',0),

(75,4,10,1,'茶黄金（一鹭莲升）盒装装特一级油橄榄',NULL,NULL,NULL,0,0,886.88,'1558406813',1,1,118,'茶黄金（一鹭莲升）盒装装特一级油橄榄',0),

(76,4,10,1,'茶黄金（香远益清）盒装装特一级油橄榄',NULL,NULL,NULL,0,0,722.18,'1558406813',1,1,119,'茶黄金（香远益清）盒装装特一级油橄榄',0),

(77,4,10,1,'三匠黑苦荞全胚芽茶',NULL,NULL,NULL,0,0,122.18,'1558406813',1,1,120,'三匠黑苦荞全胚芽茶',0),

(78,4,10,1,'160g芦丁博士',NULL,NULL,NULL,0,0,57.92,'1558406813',1,1,122,'160g芦丁博士',0),

(79,4,10,1,'70g芦丁博士',NULL,NULL,NULL,0,0,21.72,'1558406813',1,1,123,'70g芦丁博士',0),

(80,4,10,1,'72g荞粒粒',NULL,NULL,NULL,0,0,18.09,'1558406813',1,1,124,'72g荞粒粒',0),

(81,4,10,1,'192g荞粒粒',NULL,NULL,NULL,0,0,50.68,'1558406813',1,1,125,'192g荞粒粒',0),

(82,4,10,1,'黄琅毛峰',NULL,NULL,NULL,0,0,38.01,'1558406813',1,1,126,'黄琅毛峰',0),

(83,4,10,1,'明前眉尖（绿茶）',NULL,NULL,NULL,0,0,47.96,'1558406813',1,1,127,'明前眉尖（绿茶）',0),

(84,4,10,1,'水韵君山（绿茶）',NULL,NULL,NULL,0,0,36.20,'1558406813',1,1,128,'水韵君山（绿茶）',0),

(85,4,10,1,'黄琅雪芽（条形盒装）',NULL,NULL,NULL,0,0,316.74,'1558406813',1,1,129,'黄琅雪芽（条形盒装）',0),

(86,4,10,1,'极品毛峰',NULL,NULL,NULL,0,0,26.25,'1558406813',1,1,130,'极品毛峰',0),

(87,4,10,1,'珍品毛峰',NULL,NULL,NULL,0,0,20.81,'1558406813',1,1,131,'珍品毛峰',0),

(88,4,10,1,'特级香茗（茉莉花茶）',NULL,NULL,NULL,0,0,23.53,'1558406813',1,1,132,'特级香茗（茉莉花茶）',0),

(89,4,10,1,'明前毛峰',NULL,NULL,NULL,0,0,97.74,'1558406813',1,1,133,'明前毛峰',0),

(90,4,10,1,'黄琅雪芽（绿茶）',NULL,NULL,NULL,0,0,488.68,'1558406813',1,1,134,'黄琅雪芽（绿茶）',0),

(91,4,10,1,'彝乡人高寒黑苦荞全胚（盒装）',NULL,NULL,NULL,0,0,235.29,'1558406813',1,1,135,'彝乡人高寒黑苦荞全胚（盒装）',0),

(92,4,10,1,'彝乡人黑苦荞全胚茶（大长盒装）',NULL,NULL,NULL,0,0,181.00,'1558406813',1,1,136,'彝乡人黑苦荞全胚茶（大长盒装）',0),

(93,4,10,1,'彝乡人黑苦荞全皮茶（大长盒装）',NULL,NULL,NULL,0,0,171.94,'1558406813',1,1,137,'彝乡人黑苦荞全皮茶（大长盒装）',0),

(94,4,10,1,'150g彝乡人黑苦荞茶三全装',NULL,NULL,NULL,0,0,81.45,'1558406813',1,1,139,'150g彝乡人黑苦荞茶三全装',0),

(95,4,10,1,'彝乡人黑苦荞全皮茶天泽-尊',NULL,NULL,NULL,0,0,633.48,'1558406813',1,1,140,'彝乡人黑苦荞全皮茶天泽-尊',0),

(96,4,10,1,'彝乡人高寒苦荞茶（盒装装）',NULL,NULL,NULL,0,0,217.20,'1558406813',1,1,141,'彝乡人高寒苦荞茶（盒装装）',0),

(97,4,10,1,'彝乡人黑苦荞全皮茶（袋装）',NULL,NULL,NULL,0,0,68.78,'1558406813',1,1,142,'彝乡人黑苦荞全皮茶（袋装）',0),

(98,4,10,1,'彝乡人黑苦荞全皮茶（听装）',NULL,NULL,NULL,0,0,72.40,'1558406813',1,1,143,'彝乡人黑苦荞全皮茶（听装）',0),

(99,4,10,1,'彝乡人黑苦荞全胚茶（袋装）',NULL,NULL,NULL,0,0,10.86,'1558406813',1,1,145,'彝乡人黑苦荞全胚茶（袋装）',0),

(100,4,10,1,'彝乡人黑苦荞全胚茶（条形盒装）',NULL,NULL,NULL,0,0,361.99,'1558406813',1,1,146,'彝乡人黑苦荞全胚茶（条形盒装）',0),

(101,4,10,1,'530g彝乡人黑苦荞全胚茶',NULL,NULL,NULL,0,0,108.60,'1558406813',1,1,147,'530g彝乡人黑苦荞全胚茶',0),

(102,4,10,1,'正中苦荞香茶',NULL,NULL,NULL,0,0,24.44,'1558406813',1,1,148,'正中苦荞香茶',0),

(103,4,10,1,'大凉山老鹰红茶',NULL,NULL,NULL,0,0,181.00,'1558406813',1,1,149,'大凉山老鹰红茶',0),

(104,4,10,1,'大凉山老鹰红茶250g',NULL,NULL,NULL,0,0,123.08,'1558406813',1,1,150,'大凉山老鹰红茶250g',0),

(105,4,10,1,'正中黑苦荞香茶（纸盒装）',NULL,NULL,NULL,0,0,59.73,'1558406813',1,1,151,'正中黑苦荞香茶（纸盒装）',0),

(106,4,10,1,'正中黑苦荞香茶（袋装）',NULL,NULL,NULL,0,0,77.82,'1558406813',1,1,152,'正中黑苦荞香茶（袋装）',0),

(107,4,10,1,'正中黑苦荞香茶（盒装）',NULL,NULL,NULL,0,0,21.72,'1558406813',1,1,153,'正中黑苦荞香茶（盒装）',0),

(108,4,10,1,'正中黑苦荞香茶（长铁盒装）',NULL,NULL,NULL,0,0,142.99,'1558406813',1,1,154,'正中黑苦荞香茶（长铁盒装）',0),

(109,4,10,1,'正中西部村寨苦荞茶（黑苦荞香茶）',NULL,NULL,NULL,0,0,244.34,'1558406813',1,1,155,'正中西部村寨苦荞茶（黑苦荞香茶）',0),

(110,4,10,1,'正中高山春荞茶（方形铁盒装）',NULL,NULL,NULL,0,0,42.53,'1558406813',1,1,156,'正中高山春荞茶（方形铁盒装）',0),

(111,4,10,1,'正中高山春荞茶（盒装）',NULL,NULL,NULL,0,0,253.39,'1558406813',1,1,157,'正中高山春荞茶（盒装）',0),

(112,4,10,1,'正中高山春荞茶（铁盒）',NULL,NULL,NULL,0,0,313.12,'1558406813',1,1,158,'正中高山春荞茶（铁盒）',0),

(113,4,10,1,'正中苦荞香茶（瓶装）',NULL,NULL,NULL,0,0,34.39,'1558406813',1,1,159,'正中苦荞香茶（瓶装）',0),

(114,4,10,1,'三匠全株宽窄巷子',NULL,NULL,NULL,0,0,80.54,'1558406813',1,1,160,'三匠全株宽窄巷子',0),

(115,4,10,1,'三匠全胚武侯祠',NULL,NULL,NULL,0,0,85.98,'1558406813',1,1,161,'三匠全胚武侯祠',0),

(116,4,10,1,'三匠黑苦荞全株茶（2018版）',NULL,NULL,NULL,0,0,47.06,'1558406813',1,1,162,'三匠黑苦荞全株茶（2018版）',0),

(117,4,10,1,'三匠黑苦荞全胚芽茶（2018版）',NULL,NULL,NULL,0,0,49.78,'1558406813',1,1,163,'三匠黑苦荞全胚芽茶（2018版）',0),

(118,4,10,1,'三匠200g普通苦荞茶（2018版）',NULL,NULL,NULL,0,0,27.15,'1558406813',1,1,164,'三匠200g普通苦荞茶（2018版）',0),

(119,4,10,1,'三匠黑苦荞全株茶（铁盒）',NULL,NULL,NULL,0,0,97.74,'1558406813',1,1,165,'三匠黑苦荞全株茶（铁盒）',0),

(120,4,10,1,'三匠黑苦荞全胚芽茶（铁盒）',NULL,NULL,NULL,0,0,104.07,'1558406813',1,1,166,'三匠黑苦荞全胚芽茶（铁盒）',0),

(121,4,10,1,'三匠黑苦荞全株茶（脸谱）',NULL,NULL,NULL,0,0,134.85,'1558406813',1,1,167,'三匠黑苦荞全株茶（脸谱）',0),

(122,4,10,1,'三匠黑苦荞全株茶（袋装）',NULL,NULL,NULL,0,0,114.02,'1558406813',1,1,168,'三匠黑苦荞全株茶（袋装）',0),

(123,4,10,1,'三匠黑苦荞全胚芽茶（袋装）',NULL,NULL,NULL,0,0,114.02,'1558406813',1,1,169,'三匠黑苦荞全胚芽茶（袋装）',0),

(124,4,10,1,'三匠蜀锦熊猫全株精品铁盒',NULL,NULL,NULL,0,0,260.64,'1558406813',1,1,170,'三匠蜀锦熊猫全株精品铁盒',0),

(125,4,10,1,'三匠蜀锦熊猫全胚精品铁盒',NULL,NULL,NULL,0,0,295.02,'1558406813',1,1,171,'三匠蜀锦熊猫全胚精品铁盒',0),

(126,4,10,1,'惠乔全麦（胚）型苦荞茶',NULL,NULL,NULL,0,0,26.25,'1558406813',1,1,172,'惠乔全麦（胚）型苦荞茶',0),

(127,4,10,1,'惠乔黑苦荞茶（造粒成型）',NULL,NULL,NULL,0,0,58.82,'1558406813',1,1,173,'惠乔黑苦荞茶（造粒成型）',0),

(128,4,10,1,'惠乔全麦胚苦荞茶',NULL,NULL,NULL,0,0,62.45,'1558406813',1,1,174,'惠乔全麦胚苦荞茶',0),

(129,4,10,1,'惠乔造粒成型苦荞茶（罐装）',NULL,NULL,NULL,0,0,21.72,'1558406813',1,1,175,'惠乔造粒成型苦荞茶（罐装）',0),

(130,4,10,1,'惠乔全麦胚苦荞茶（罐装）',NULL,NULL,NULL,0,0,21.72,'1558406813',1,1,176,'惠乔全麦胚苦荞茶（罐装）',0),

(131,4,10,1,'惠乔苦荞玫瑰茶',NULL,NULL,NULL,0,0,52.49,'1558406813',1,1,177,'惠乔苦荞玫瑰茶',0),

(132,4,10,1,'惠乔苦荞茉莉花茶',NULL,NULL,NULL,0,0,52.49,'1558406813',1,1,178,'惠乔苦荞茉莉花茶',0),

(133,4,10,1,'惠乔苦荞菊花苦荞茶',NULL,NULL,NULL,0,0,52.49,'1558406813',1,1,179,'惠乔苦荞菊花苦荞茶',0),

(134,4,10,1,'惠乔苦荞薄荷茶',NULL,NULL,NULL,0,0,52.49,'1558406813',1,1,181,'惠乔苦荞薄荷茶',0),

(135,4,10,1,'惠乔苦荞柠檬红茶',NULL,NULL,NULL,0,0,52.49,'1558406813',1,1,182,'惠乔苦荞柠檬红茶',0),

(136,4,10,1,'灿林刺梨（瓶装）80g',NULL,NULL,NULL,0,0,25.34,'1558406813',1,1,183,'灿林刺梨（瓶装）80g',0),

(137,4,10,1,'辣木叶荷叶茶',NULL,NULL,NULL,0,0,72.40,'1558406813',1,1,184,'辣木叶荷叶茶',0),

(138,4,10,1,'黑糖玫瑰茶150g',NULL,NULL,NULL,0,0,25.34,'1558406813',1,1,185,'黑糖玫瑰茶150g',0),

(139,4,10,1,'黑糖玫瑰茶300g',NULL,NULL,NULL,0,0,50.68,'1558406813',1,1,186,'黑糖玫瑰茶300g',0),

(140,4,10,1,'恒然黑苦荞胚芽茶',NULL,NULL,NULL,0,0,48.87,'1558406813',1,1,187,'恒然黑苦荞胚芽茶',0),

(141,4,10,1,'珍珠米黑苦荞茶',NULL,NULL,NULL,0,0,36.20,'1558406813',1,1,188,'珍珠米黑苦荞茶',0),

(142,4,10,1,'全胚芽黑苦荞茶',NULL,NULL,NULL,0,0,36.20,'1558406813',1,1,189,'全胚芽黑苦荞茶',0),

(143,4,10,1,'全株黑苦荞茶',NULL,NULL,NULL,0,0,32.58,'1558406813',1,1,190,'全株黑苦荞茶',0),

(144,4,13,1,'会东松仁 （散装）',NULL,NULL,NULL,0,0,142.99,'1558407476',1,1,9,'会东松仁 （散装）',0),

(145,4,13,1,'破壳松（ 散装）',NULL,NULL,NULL,0,0,162.89,'1558407476',1,1,10,'破壳松（ 散装）',0),

(146,4,13,1,'开心果',NULL,NULL,NULL,0,0,188.24,'1558407476',1,1,15,'开心果',0),

(147,4,13,1,'会东破壳松（袋装）',NULL,NULL,NULL,0,0,35.84,'1558407476',1,1,18,'会东破壳松（袋装）',0),

(148,4,13,1,'环太黑苦荞蛋酥萨琪玛',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,19,'环太黑苦荞蛋酥萨琪玛',0),

(149,4,13,1,'环太黑苦荞萨琪玛（黑糖）',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,20,'环太黑苦荞萨琪玛（黑糖）',0),

(150,4,13,1,'环太苦荞花生酥（原味）',NULL,NULL,NULL,0,0,38.62,'1558407476',1,1,21,'环太苦荞花生酥（原味）',0),

(151,4,13,1,'环太苦荞花生酥（椒盐味）',NULL,NULL,NULL,0,0,38.62,'1558407476',1,1,22,'环太苦荞花生酥（椒盐味）',0),

(152,4,13,1,'环太苦荞花生酥',NULL,NULL,NULL,0,0,38.62,'1558407476',1,1,23,'环太苦荞花生酥',0),

(153,4,13,1,'环太苦荞木糖醇果仁酥（17版）',NULL,NULL,NULL,0,0,19.55,'1558407476',1,1,25,'环太苦荞木糖醇果仁酥（17版）',0),

(154,4,13,1,'环太苦荞木糖醇花生酥（17版）',NULL,NULL,NULL,0,0,19.55,'1558407476',1,1,26,'环太苦荞木糖醇花生酥（17版）',0),

(155,4,13,1,'桑葚干（瓶装）',NULL,NULL,NULL,0,0,39.82,'1558407476',1,1,36,'桑葚干（瓶装）',0),

(156,4,13,1,'桑葚干（袋装）',NULL,NULL,NULL,0,0,117.65,'1558407476',1,1,37,'桑葚干（袋装）',0),

(157,4,13,1,'桑葚干（袋装）80g',NULL,NULL,NULL,0,0,22.62,'1558407476',1,1,38,'桑葚干（袋装）80g',0),

(158,4,13,1,'优质腰果仁',NULL,NULL,NULL,0,0,72.40,'1558407476',1,1,39,'优质腰果仁',0),

(159,4,13,1,'正中五格能量苦荞蛋芙条（麦芽糖',NULL,NULL,NULL,0,0,4.98,'1558407476',1,1,55,'正中五格能量苦荞蛋芙条（麦芽糖',0),

(160,4,13,1,'苦荞核桃酥',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,56,'苦荞核桃酥',0),

(161,4,13,1,'苦荞桑葚酥',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,57,'苦荞桑葚酥',0),

(162,4,13,1,'正中五格能量苦荞蛋芙条（肉松）',NULL,NULL,NULL,0,0,5.07,'1558407476',1,1,58,'正中五格能量苦荞蛋芙条（肉松）',0),

(163,4,13,1,'苦荞黑芝麻酥',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,59,'苦荞黑芝麻酥',0),

(164,4,13,1,'麦芽糖醇苦荞花生酥',NULL,NULL,NULL,0,0,19.91,'1558407476',1,1,60,'麦芽糖醇苦荞花生酥',0),

(165,4,13,1,'苦荞蛋芙条(红糖味）',NULL,NULL,NULL,0,0,17.92,'1558407476',1,1,61,'苦荞蛋芙条(红糖味）',0),

(166,4,13,1,'苦荞蛋芙条（肉松）',NULL,NULL,NULL,0,0,19.91,'1558407476',1,1,62,'苦荞蛋芙条（肉松）',0),

(167,4,13,1,'正中麦芽糖醇蛋芙条',NULL,NULL,NULL,0,0,21.35,'1558407476',1,1,63,'正中麦芽糖醇蛋芙条',0),

(168,4,13,1,'苦荞蛋芙条(麦芽糖醇)',NULL,NULL,NULL,0,0,29.51,'1558407476',1,1,64,'苦荞蛋芙条(麦芽糖醇)',0),

(169,4,13,1,'正中苦荞麦芽糖醇沙琪玛708g',NULL,NULL,NULL,0,0,27.15,'1558407476',1,1,65,'正中苦荞麦芽糖醇沙琪玛708g',0),

(170,4,13,1,'正中苦荞原味沙琪玛',NULL,NULL,NULL,0,0,27.15,'1558407476',1,1,66,'正中苦荞原味沙琪玛',0),

(171,4,13,1,'正中苦荞麦芽糖醇沙琪玛',NULL,NULL,NULL,0,0,9.95,'1558407476',1,1,67,'正中苦荞麦芽糖醇沙琪玛',0),

(172,4,13,1,'正中苦荞粒粒酥（有糖）',NULL,NULL,NULL,0,0,12.31,'1558407476',1,1,68,'正中苦荞粒粒酥（有糖）',0),

(173,4,13,1,'正中苦荞粒粒酥（无糖）',NULL,NULL,NULL,0,0,12.31,'1558407476',1,1,69,'正中苦荞粒粒酥（无糖）',0),

(174,4,13,1,'正中夹心苦荞糕',NULL,NULL,NULL,0,0,12.67,'1558407476',1,1,70,'正中夹心苦荞糕',0),

(175,4,13,1,'桑葚干',NULL,NULL,NULL,0,0,25.34,'1558407476',1,1,72,'桑葚干',0),

(176,4,13,1,'破壳松（ 288g/塑料袋）',NULL,NULL,NULL,0,0,61.54,'1558407476',1,1,84,'破壳松（ 288g/塑料袋）',0),

(177,4,13,1,'破壳松（108g/纸袋）',NULL,NULL,NULL,0,0,26.79,'1558407476',1,1,85,'破壳松（108g/纸袋）',0),

(178,4,13,1,'破壳松（ 208g/纸袋）',NULL,NULL,NULL,0,0,50.68,'1558407476',1,1,86,'破壳松（ 208g/纸袋）',0),

(179,4,13,1,'破壳松（248g/罐装）',NULL,NULL,NULL,0,0,65.15,'1558407476',1,1,87,'破壳松（248g/罐装）',0),

(180,4,13,1,'辣木籽',NULL,NULL,NULL,0,0,45.25,'1558407476',1,1,114,'辣木籽',0),

(181,4,13,1,'苦荞蛋芙条麦芽糖醇',NULL,NULL,NULL,0,0,19.91,'1558407476',1,1,203,'苦荞蛋芙条麦芽糖醇',0),

(182,4,11,1,'正中西部村寨苦荞米',NULL,NULL,NULL,0,0,18.09,'1558409036',1,1,251,'正中西部村寨苦荞米',0),

(183,4,11,1,'恒然苦荞米',NULL,NULL,NULL,0,0,18.09,'1558409036',1,1,252,'恒然苦荞米',0),

(184,4,11,1,'绿豆',NULL,NULL,NULL,0,0,19.73,'1558409036',1,1,253,'绿豆',0),

(185,4,11,1,'黑香米',NULL,NULL,NULL,0,0,19.73,'1558409036',1,1,254,'黑香米',0),

(186,4,11,1,'小米',NULL,NULL,NULL,0,0,19.73,'1558409036',1,1,255,'小米',0),

(187,4,11,1,'惠乔黑苦荞生粉',NULL,NULL,NULL,0,0,21.72,'1558409036',1,1,264,'惠乔黑苦荞生粉',0),

(188,4,11,1,'恒然高山红米1000g',NULL,NULL,NULL,0,0,21.72,'1558409036',1,1,265,'恒然高山红米1000g',0),

(189,4,11,1,'恒然苦荞全麦片',NULL,NULL,NULL,0,0,21.72,'1558409036',1,1,266,'恒然苦荞全麦片',0),

(190,4,11,1,'恒然富钙米',NULL,NULL,NULL,0,0,21.72,'1558409036',1,1,267,'恒然富钙米',0),

(191,4,11,1,'恒然苦荞早餐粉',NULL,NULL,NULL,0,0,21.72,'1558409036',1,1,268,'恒然苦荞早餐粉',0),

(192,4,11,1,'五常大米',NULL,NULL,NULL,0,0,262.45,'1558409036',1,1,274,'五常大米',0),

(193,4,11,1,'苦荞粉（散装）',NULL,NULL,NULL,0,0,27.15,'1558409036',1,1,275,'苦荞粉（散装）',0),

(194,4,11,1,'惠乔黑苦荞粉（袋装）',NULL,NULL,NULL,0,0,27.15,'1558409036',1,1,278,'惠乔黑苦荞粉（袋装）',0),

(195,4,11,1,'恒然苦荞核桃粉',NULL,NULL,NULL,0,0,27.15,'1558409036',1,1,279,'恒然苦荞核桃粉',0),

(196,4,11,1,'环太黑苦荞粉',NULL,NULL,NULL,0,0,28.06,'1558409036',1,1,281,'环太黑苦荞粉',0),

(197,4,11,1,'恒然高钙配方米',NULL,NULL,NULL,0,0,28.96,'1558409036',1,1,287,'恒然高钙配方米',0),

(198,4,11,1,'富硒香米',NULL,NULL,NULL,0,0,32.58,'1558409036',1,1,294,'富硒香米',0),

(199,4,11,1,'大雪豆',NULL,NULL,NULL,0,0,32.58,'1558409036',1,1,295,'大雪豆',0),

(200,4,11,1,'恒然苦荞米928g',NULL,NULL,NULL,0,0,32.58,'1558409036',1,1,299,'恒然苦荞米928g',0),

(201,4,11,1,'惠乔五谷黑苦荞粉（袋装）',NULL,NULL,NULL,0,0,34.39,'1558409036',1,1,301,'惠乔五谷黑苦荞粉（袋装）',0),

(202,4,11,1,'惠乔燕麦黑苦荞粉（袋装）',NULL,NULL,NULL,0,0,34.39,'1558409036',1,1,302,'惠乔燕麦黑苦荞粉（袋装）',0),

(203,4,11,1,'苦荞粉（熟）',NULL,NULL,NULL,0,0,36.20,'1558409036',1,1,307,'苦荞粉（熟）',0),

(204,4,11,1,'喜德之光有机大米（袋装）',NULL,NULL,NULL,0,0,53.58,'1558409036',1,1,318,'喜德之光有机大米（袋装）',0),

(205,4,11,1,'金阳白魔芋粉丝',NULL,NULL,NULL,0,0,5.44,'1558409036',1,1,319,'金阳白魔芋粉丝',0),

(206,4,11,1,'香米饵片',NULL,NULL,NULL,0,0,6.33,'1558409036',1,1,320,'香米饵片',0),

(207,4,11,1,'香米饵丝',NULL,NULL,NULL,0,0,6.33,'1558409036',1,1,321,'香米饵丝',0),

(208,4,11,1,'玉米饵丝',NULL,NULL,NULL,0,0,6.33,'1558409036',1,1,322,'玉米饵丝',0),

(209,4,11,1,'正中苦荞挂面380g',NULL,NULL,NULL,0,0,6.88,'1558409036',1,1,323,'正中苦荞挂面380g',0),

(210,4,11,1,'德昌农家大米（5kg）',NULL,NULL,NULL,0,0,54.29,'1558409036',1,1,324,'德昌农家大米（5kg）',0),

(211,4,11,1,'恒然山泉米',NULL,NULL,NULL,0,0,65.15,'1558409036',1,1,327,'恒然山泉米',0),

(212,4,11,1,'糍粑',NULL,NULL,NULL,0,0,7.24,'1558409036',1,1,328,'糍粑',0),

(213,4,11,1,'恒然苦荞挂面0.2',NULL,NULL,NULL,0,0,7.60,'1558409036',1,1,330,'恒然苦荞挂面0.2',0),

(214,4,11,1,'德昌农家大米（散装）',NULL,NULL,NULL,0,0,8.68,'1558409036',1,1,331,'德昌农家大米（散装）',0),

(215,4,11,1,'冕宁粳米',NULL,NULL,NULL,0,0,8.68,'1558409036',1,1,332,'冕宁粳米',0),

(216,4,11,1,'500g高寒黑苦荞挂面',NULL,NULL,NULL,0,0,8.87,'1558409036',1,1,333,'500g高寒黑苦荞挂面',0),

(217,4,11,1,'正中苦荞挂面500g',NULL,NULL,NULL,0,0,8.87,'1558409036',1,1,334,'正中苦荞挂面500g',0),

(218,4,11,1,'富硒香米2.5kg',NULL,NULL,NULL,0,0,72.40,'1558409036',1,1,335,'富硒香米2.5kg',0),

(219,4,11,1,'花生粉',NULL,NULL,NULL,0,0,72.40,'1558409036',1,1,337,'花生粉',0),

(220,4,11,1,'恒然有机玉米芝麻糊',NULL,NULL,NULL,0,0,77.82,'1558409036',1,1,338,'恒然有机玉米芝麻糊',0),

(221,4,11,1,'珍珠米10kg',NULL,NULL,NULL,0,0,86.88,'1558409036',1,1,342,'珍珠米10kg',0),

(222,4,11,1,'珍珠米（散装）',NULL,NULL,NULL,0,0,9.78,'1558409036',1,1,344,'珍珠米（散装）',0),

(223,4,11,1,'会东辣木叶面',NULL,NULL,NULL,0,0,90.49,'1558409036',1,1,345,'会东辣木叶面',0),

(224,4,11,1,'恒然高山红米（盒装）',NULL,NULL,NULL,0,0,99.55,'1558409036',1,1,348,'恒然高山红米（盒装）',0),

(225,4,11,1,'恒然有机燕麦苦荞葛根粉',NULL,NULL,NULL,0,0,103.16,'1558409036',1,1,349,'恒然有机燕麦苦荞葛根粉',0),

(226,4,11,1,'恒然有机核桃芝麻糊',NULL,NULL,NULL,0,0,103.16,'1558409036',1,1,350,'恒然有机核桃芝麻糊',0),

(227,4,11,1,'恒然有机阿胶魔芋红豆薏仁',NULL,NULL,NULL,0,0,104.98,'1558409036',1,1,351,'恒然有机阿胶魔芋红豆薏仁',0),

(228,4,11,1,'恒然苦荞挂面（0.4）',NULL,NULL,NULL,0,0,10.86,'1558409036',1,1,352,'恒然苦荞挂面（0.4）',0),

(229,4,11,1,'德昌农家大米（1kg）',NULL,NULL,NULL,0,0,10.93,'1558409036',1,1,353,'德昌农家大米（1kg）',0),

(230,4,11,1,'喜德之光有机大米（盒装）',NULL,NULL,NULL,0,0,117.28,'1558409036',1,1,359,'喜德之光有机大米（盒装）',0),

(231,4,11,1,'恒然优品米',NULL,NULL,NULL,0,0,123.08,'1558409036',1,1,360,'恒然优品米',0),

(232,4,11,1,'粉丝',NULL,NULL,NULL,0,0,12.67,'1558409036',1,1,364,'粉丝',0),

(233,4,11,1,'黑米',NULL,NULL,NULL,0,0,12.67,'1558409036',1,1,366,'黑米',0),

(234,4,11,1,'正中苦荞挂面800g',NULL,NULL,NULL,0,0,13.58,'1558409036',1,1,367,'正中苦荞挂面800g',0),

(235,4,11,1,'恒然苦荞粉',NULL,NULL,NULL,0,0,14.48,'1558409036',1,1,372,'恒然苦荞粉',0),

(236,4,11,1,'恒然高山红米500g',NULL,NULL,NULL,0,0,14.48,'1558409036',1,1,373,'恒然高山红米500g',0),

(237,4,11,1,'恒然高山红米480g',NULL,NULL,NULL,0,0,14.48,'1558409036',1,1,374,'恒然高山红米480g',0),

(238,4,11,1,'恒然苦荞早餐片',NULL,NULL,NULL,0,0,14.48,'1558409036',1,1,375,'恒然苦荞早餐片',0),

(239,4,11,1,'恒然高钙配方米（盒装）',NULL,NULL,NULL,0,0,144.80,'1558409036',1,1,376,'恒然高钙配方米（盒装）',0),

(240,4,11,1,'恒然高原特色米组合装',NULL,NULL,NULL,0,0,144.80,'1558409036',1,1,377,'恒然高原特色米组合装',0),

(241,4,11,1,'恒然天赐好苦荞组合',NULL,NULL,NULL,0,0,144.80,'1558409036',1,1,378,'恒然天赐好苦荞组合',0),

(242,4,11,1,'正中苦荞面（麦香+鸡蛋+劲爽）',NULL,NULL,NULL,0,0,17.20,'1558409036',1,1,384,'正中苦荞面（麦香+鸡蛋+劲爽）',0),

(243,4,9,1,'野生山珍礼包',NULL,NULL,NULL,0,0,289.59,'1558409662',1,1,193,'野生山珍礼包',0),

(244,4,9,1,'松露（盒装）',NULL,NULL,NULL,0,0,358.38,'1558409662',1,1,194,'松露（盒装）',0),

(245,4,9,1,'羊肚菌 ( 鲜）',NULL,NULL,NULL,0,0,434.39,'1558409662',1,1,195,'羊肚菌 ( 鲜）',0),

(246,4,9,1,'木耳',NULL,NULL,NULL,0,0,126.69,'1558409662',1,1,196,'木耳',0),

(247,4,9,1,'环太茶树菇',NULL,NULL,NULL,0,0,31.49,'1558409662',1,1,197,'环太茶树菇',0),

(248,4,9,1,'环太猴头菇',NULL,NULL,NULL,0,0,42.35,'1558409662',1,1,198,'环太猴头菇',0),

(249,4,9,1,'环太野生美味牛肝菌',NULL,NULL,NULL,0,0,93.39,'1558409662',1,1,199,'环太野生美味牛肝菌',0),

(250,4,9,1,'环太野生香菇',NULL,NULL,NULL,0,0,30.76,'1558409662',1,1,200,'环太野生香菇',0),

(251,4,9,1,'松露150g',NULL,NULL,NULL,0,0,814.48,'1558409662',1,1,201,'松露150g',0),

(252,4,9,1,'松露300g',NULL,NULL,NULL,0,0,1628.96,'1558409662',1,1,202,'松露300g',0),

(253,4,9,1,'灿林大凉山松茸菌',NULL,NULL,NULL,0,0,660.64,'1558409662',1,1,204,'灿林大凉山松茸菌',0),

(254,4,9,1,'灿林黑牛肝菌',NULL,NULL,NULL,0,0,99.55,'1558409662',1,1,205,'灿林黑牛肝菌',0),

(255,4,9,1,'灿林青杠黑木耳230g',NULL,NULL,NULL,0,0,90.49,'1558409662',1,1,206,'灿林青杠黑木耳230g',0),

(256,4,9,207,'大凉山野生鸡枞菌','uploads/25220_153332_6160.png','纯天然优质新鲜鸡枞，肉质细嫩，爽脆有嚼劲','<p>1</p>',0,0,315.00,'1558409662',1,1,207,'灿林鸡枞菌',0),

(257,4,9,208,'大凉山美味牛肝菌','uploads/25220_154813_6494.png','菌香浓郁，煲汤好料','<p>1</p>',0,0,248.00,'1558409662',1,1,208,'灿林美味牛肝菌208+223',0),

(258,4,9,209,'大凉山野生羊肚菌','uploads/25220_181832_5986.png','珍贵的食用菌和药用菌','<p>1</p>',0,0,481.00,'1558409662',1,1,209,'灿林羊肚菌',0),

(259,4,9,210,'彝家六珍菌（组合装）','uploads/25220_160407_3942.png','特色农产品，来自大凉山的宝贝','<p>1</p>',0,0,179.00,'1558409662',1,1,210,'灿林彝家六珍',0),

(260,4,9,211,'特级彝族酸菜','uploads/25220_161117_6255.png','彝族传统工艺，佐餐佳品','<p>1</p>',0,0,27.00,'1558409662',1,1,211,'灿林彝族酸菜（袋）特级',0),

(261,4,9,212,'高山蕨菜','uploads/25220_165417_2234.png','源自大凉山深处，手工采摘，更自然更健康','<p>1</p>',0,0,27.00,'1558409662',1,1,212,'灿林高山蕨菜',0),

(262,4,9,213,'大凉山黄牛肝菌','uploads/25220_165355_7425.png','至今无法人工培育的特有野生菌','<p>1</p>',0,0,136.00,'1558409662',1,1,213,'灿林黄牛肝菌',0),

(263,4,9,215,'灿林野生香菇（袋）','uploads/25220_165315_1700.png','有机品质，味道鲜美','<p>1</p>',0,0,145.00,'1558409662',1,1,215,'灿林野生香菇',1),

(264,4,9,216,'灿林青杠菌（盒装）','uploads/25220_171925_4376.png',NULL,'<p>1</p>',0,0,54.00,'1558409662',1,1,216,'灿林青杠菌100g 216+227',0),

(265,4,9,217,'灿林黑牛肝菌（盒装）','uploads/25220_174015_1295.png',NULL,'<p>1</p>',0,0,45.00,'1558409662',1,1,217,'灿林黑牛肝菌100g',0),

(266,4,9,218,'灿林鸡枞菌（盒装）','uploads/25220_175848_4446.png',NULL,'<p>1</p>',0,0,136.00,'1558409662',1,1,218,'灿林鸡枞菌（礼盒）',0),

(267,4,9,219,'灿林松茸菌（盒装）','uploads/25220_181541_5909.png',NULL,'<p>1</p>',0,0,297.00,'1558409662',1,1,219,'灿林松茸菌（优级）',0),

(268,4,9,221,'大凉山青杠黑木耳','uploads/25220_171631_9102.png',NULL,'<p>1</p>',0,0,36.00,'1558409662',1,1,221,'青杠黑木耳221+238',0),

(269,4,9,222,'大凉山特级红花椒','uploads/25220_172016_5042.png',NULL,'<p>1</p>',0,0,80.00,'1558409662',1,1,222,'灿林正宗红花椒（特级）',0),

(270,4,9,223,'大凉山黄牛肝菌（盒装）','uploads/25220_173637_7927.png',NULL,'<p>1</p>',0,0,63.00,'1558409662',1,1,223,'灿林黄牛肝菌（盒装）',0),

(271,4,9,1,'灿林黑木耳（盒装）',NULL,NULL,NULL,0,0,177.38,'1558409662',0,1,224,'灿林黑木耳（盒装）',0),

(272,4,9,1,'灿林美味牛肝菌100g',NULL,NULL,NULL,0,0,112.21,'1558409662',0,1,225,'灿林美味牛肝菌100g',0),

(273,4,9,226,'灿林猴头菇','uploads/25220_175050_3428.png',NULL,'<p>1</p>',0,0,96.00,'1558409662',1,1,226,'灿林猴头菇盒装226  灿林猴头菇 袋装229',0),

(274,4,9,1,'灿林青杠菌盒装',NULL,NULL,NULL,0,0,173.75,'1558409662',0,1,227,'灿林青杠菌盒装',0),

(275,4,9,228,'大凉山茶树菇','uploads/25220_172449_3532.png',NULL,'<p>1</p>',0,0,90.00,'1558409662',1,1,228,'灿林茶树菇（袋装）特级',0),

(276,4,9,1,'灿林猴头菇',NULL,NULL,NULL,0,0,68.78,'1558409662',0,1,229,'灿林猴头菇',0),

(277,4,9,232,'大凉山虎掌菌','uploads/25220_173744_3975.png',NULL,'<p>1</p>',0,0,235.00,'1558409662',1,1,232,'灿林虎掌菌',1),

(278,4,9,233,'大凉山刺梨','uploads/25220_174204_6787.png',NULL,'<p>1</p>',0,0,47.00,'1558409662',1,1,233,'灿林刺梨（瓶装）',1),

(279,4,9,1,'灿林松露（瓶装）',NULL,NULL,NULL,0,0,499.55,'1558409662',0,1,237,'灿林松露（瓶装）',0),

(280,4,9,1,'灿林青杠黑木耳',NULL,NULL,NULL,0,0,36.20,'1558409662',0,1,238,'灿林青杠黑木耳',0),

(281,4,9,1,'灿林姬松茸','uploads/25220_112845_1683.png',NULL,'<p>1</p>',0,0,57.92,'1558409662',1,1,239,'灿林姬松茸',0),

(282,4,9,1,'灿林香菇片',NULL,NULL,NULL,0,0,30.76,'1558409662',1,1,240,'灿林香菇片',0),

(283,4,9,1,'灿林小香菇',NULL,NULL,NULL,0,0,30.76,'1558409662',1,1,241,'灿林小香菇',0),

(284,4,9,1,'灿林竹荪',NULL,NULL,NULL,0,0,27.15,'1558409662',1,1,242,'灿林竹荪',0),

(285,4,9,1,'灿林茶树菇优级（袋装）',NULL,NULL,NULL,0,0,27.15,'1558409662',1,1,243,'灿林茶树菇优级（袋装）',0),

(286,4,9,1,'灿林榆黄菇',NULL,NULL,NULL,0,0,27.15,'1558409662',1,1,244,'灿林榆黄菇',0),

(287,4,9,1,'阿表哥美味牛肝菌',NULL,NULL,NULL,0,0,90.49,'1558409662',1,1,246,'阿表哥美味牛肝菌',0),

(288,4,9,1,'阿表哥野生黑木耳',NULL,NULL,NULL,0,0,36.20,'1558409662',1,1,247,'阿表哥野生黑木耳',0),

(289,4,9,1,'阿表哥蘑菇',NULL,NULL,NULL,0,0,36.20,'1558409662',1,1,248,'阿表哥蘑菇',0),

(290,4,9,1,'花生米',NULL,NULL,NULL,0,0,19.91,'1558409662',1,1,259,'花生米',0),

(291,4,9,1,'美姑黄豆',NULL,NULL,NULL,0,0,21.72,'1558409662',1,1,262,'美姑黄豆',0),

(292,4,9,1,'木里芸豆',NULL,NULL,NULL,0,0,23.53,'1558409662',1,1,270,'木里芸豆',0),

(293,4,9,1,'美姑花豆',NULL,NULL,NULL,0,0,30.76,'1558409662',1,1,291,'美姑花豆',0),

(294,4,9,1,'黄豆',NULL,NULL,NULL,0,0,36.20,'1558409662',1,1,306,'黄豆',0),

(295,4,9,1,'干竹笋',NULL,NULL,NULL,0,0,72.40,'1558409662',1,1,336,'干竹笋',0),

(296,4,9,1,'大凉山银耳',NULL,NULL,NULL,0,0,108.60,'1558409662',1,1,355,'大凉山银耳',0),

(297,4,12,1,'华祥手撕牛肉独立条麻辣（散装）',NULL,NULL,NULL,0,0,289.59,'1558410124',1,1,1,'华祥手撕牛肉独立条麻辣（散装）',0),

(298,4,12,1,'童耳朵板鸭',NULL,NULL,NULL,0,0,135.74,'1558410124',1,1,2,'童耳朵板鸭',0),

(299,4,12,1,'元农手撕牛肉五香味单只（彩袋）',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,3,'元农手撕牛肉五香味单只（彩袋）',0),

(300,4,12,1,'元农手撕牛肉香辣味单只（彩袋）',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,4,'元农手撕牛肉香辣味单只（彩袋）',0),

(301,4,12,1,'风干肉五香',NULL,NULL,NULL,0,0,209.95,'1558410124',1,1,5,'风干肉五香',0),

(302,4,12,1,'风干肉麻辣',NULL,NULL,NULL,0,0,209.95,'1558410124',1,1,6,'风干肉麻辣',0),

(303,4,12,1,'风干肉五香散装',NULL,NULL,NULL,0,0,1049.78,'1558410124',1,1,7,'风干肉五香散装',0),

(304,4,12,1,'风干肉麻辣散装',NULL,NULL,NULL,0,0,1049.78,'1558410124',1,1,8,'风干肉麻辣散装',0),

(305,4,12,1,'408g手撕牛肉（麻辣）',NULL,NULL,NULL,0,0,220.81,'1558410124',1,1,11,'408g手撕牛肉（麻辣）',0),

(306,4,12,1,'独立风干肉（麻辣）',NULL,NULL,NULL,0,0,615.39,'1558410124',1,1,12,'独立风干肉（麻辣）',0),

(307,4,12,1,'独立风干肉（五香）',NULL,NULL,NULL,0,0,615.39,'1558410124',1,1,13,'独立风干肉（五香）',0),

(308,4,12,1,'思奇香手撕干肉400G盒装',NULL,NULL,NULL,0,0,279.64,'1558410124',1,1,14,'思奇香手撕干肉400G盒装',0),

(309,4,12,1,'手撕牛肉干（麻辣）',NULL,NULL,NULL,0,0,289.59,'1558410124',1,1,16,'手撕牛肉干（麻辣）',0),

(310,4,12,1,'手撕牛肉干（五香）',NULL,NULL,NULL,0,0,289.59,'1558410124',1,1,17,'手撕牛肉干（五香）',0),

(311,4,12,1,'116g手撕牛肉（麻辣味）',NULL,NULL,NULL,0,0,66.96,'1558410124',1,1,28,'116g手撕牛肉（麻辣味）',0),

(312,4,12,1,'206g手撕牛肉（麻辣味）',NULL,NULL,NULL,0,0,130.32,'1558410124',1,1,29,'206g手撕牛肉（麻辣味）',0),

(313,4,12,1,'128g大凉山风干牛肉（五香味）',NULL,NULL,NULL,0,0,85.07,'1558410124',1,1,30,'128g大凉山风干牛肉（五香味）',0),

(314,4,12,1,'128g大凉山风干干肉（麻辣味）',NULL,NULL,NULL,0,0,85.07,'1558410124',1,1,31,'128g大凉山风干干肉（麻辣味）',0),

(315,4,12,1,'248g大凉山风干干肉（五香味）',NULL,NULL,NULL,0,0,154.75,'1558410124',1,1,32,'248g大凉山风干干肉（五香味）',0),

(316,4,12,1,'248g大凉山风干干肉（麻辣味）',NULL,NULL,NULL,0,0,154.75,'1558410124',1,1,33,'248g大凉山风干干肉（麻辣味）',0),

(317,4,12,1,'82g手撕牛肉（麻辣）',NULL,NULL,NULL,0,0,50.68,'1558410124',1,1,34,'82g手撕牛肉（麻辣）',0),

(318,4,12,1,'元农手撕牛肉五香味128g',NULL,NULL,NULL,0,0,66.06,'1558410124',1,1,40,'元农手撕牛肉五香味128g',0),

(319,4,12,1,'元农手撕牛肉香辣味128g',NULL,NULL,NULL,0,0,66.06,'1558410124',1,1,42,'元农手撕牛肉香辣味128g',0),

(320,4,12,1,'元农手撕牛肉香辣味88g',NULL,NULL,NULL,0,0,38.38,'1558410124',1,1,43,'元农手撕牛肉香辣味88g',0),

(321,4,12,1,'元农手撕牛肉五香味88g',NULL,NULL,NULL,0,0,38.38,'1558410124',1,1,44,'元农手撕牛肉五香味88g',0),

(322,4,12,1,'元农手撕牛肉五香味300g（彩袋）',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,45,'元农手撕牛肉五香味300g（彩袋）',0),

(323,4,12,1,'元农手撕牛肉香辣味300g（彩袋）',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,46,'元农手撕牛肉香辣味300g（彩袋）',0),

(324,4,12,1,'元农手撕牛肉五香味408g',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,48,'元农手撕牛肉五香味408g',0),

(325,4,12,1,'元农手撕牛肉香辣味408g',NULL,NULL,NULL,0,0,181.00,'1558410124',1,1,49,'元农手撕牛肉香辣味408g',0),

(326,4,12,1,'元农大礼包228g',NULL,NULL,NULL,0,0,57.92,'1558410124',1,1,50,'元农大礼包228g',0),

(327,4,12,1,'华祥手撕牛肉干（五香味）252g',NULL,NULL,NULL,0,0,86.88,'1558410124',1,1,73,'华祥手撕牛肉干（五香味）252g',0),

(328,4,12,1,'华祥手撕牛肉干（五香味）500g',NULL,NULL,NULL,0,0,170.14,'1558410124',1,1,74,'华祥手撕牛肉干（五香味）500g',0),

(329,4,12,1,'华祥手撕牛肉干（麻辣味）500g',NULL,NULL,NULL,0,0,170.14,'1558410124',1,1,75,'华祥手撕牛肉干（麻辣味）500g',0),

(330,4,12,1,'华祥手撕牛肉干（麻辣味）252g',NULL,NULL,NULL,0,0,86.88,'1558410124',1,1,76,'华祥手撕牛肉干（麻辣味）252g',0),

(331,4,12,1,'华祥手撕牛肉干（麻辣味）80g',NULL,NULL,NULL,0,0,32.58,'1558410124',1,1,77,'华祥手撕牛肉干（麻辣味）80g',0),

(332,4,12,1,'华祥手撕牛肉干（五香味）80g',NULL,NULL,NULL,0,0,32.58,'1558410124',1,1,78,'华祥手撕牛肉干（五香味）80g',0),

(333,4,12,1,'华祥手撕牛肉干（五香味）180g',NULL,NULL,NULL,0,0,62.62,'1558410124',1,1,79,'华祥手撕牛肉干（五香味）180g',0),

(334,4,12,1,'华祥手撕牛肉干（麻辣味）180g',NULL,NULL,NULL,0,0,62.62,'1558410124',1,1,80,'华祥手撕牛肉干（麻辣味）180g',0),

(335,4,8,1,'彝族酸菜（散装）',NULL,NULL,NULL,0,0,226.25,'1558410468',1,1,191,'彝族酸菜（散装）',0),

(336,4,8,1,'灿林彝族酸菜',NULL,NULL,NULL,0,0,90.49,'1558410468',1,1,192,'灿林彝族酸菜',0),

(337,4,8,1,'灿林鸡枞油（特级）',NULL,NULL,NULL,0,0,121.27,'1558410468',1,1,230,'灿林鸡枞油（特级）',0),

(338,4,8,1,'灿林山里鲜上汤炖料（绿）',NULL,NULL,NULL,0,0,22.62,'1558410468',1,1,234,'灿林山里鲜上汤炖料（绿）',0),

(339,4,8,1,'灿林山里鲜上汤炒料（桔黄）',NULL,NULL,NULL,0,0,22.62,'1558410468',1,1,235,'灿林山里鲜上汤炒料（桔黄）',0),

(340,4,8,1,'灿林山里鲜上汤炖料（红）',NULL,NULL,NULL,0,0,22.62,'1558410468',1,1,236,'灿林山里鲜上汤炖料（红）',0),

(341,4,8,1,'灿林 红花椒（听装）',NULL,NULL,NULL,0,0,54.29,'1558410468',1,1,245,'灿林 红花椒（听装）',0),

(342,4,8,1,'青花椒 （散装）',NULL,NULL,NULL,0,0,181.00,'1558410468',1,1,256,'青花椒 （散装）',0),

(343,4,8,1,'花椒面（散）',NULL,NULL,NULL,0,0,181.00,'1558410468',1,1,257,'花椒面（散）',0),

(344,4,8,1,'会东松露粉126g',NULL,NULL,NULL,0,0,195.47,'1558410468',1,1,258,'会东松露粉126g',0),

(345,4,8,1,'郫县豆瓣酱（袋装）',NULL,NULL,NULL,0,0,21.72,'1558410468',1,1,263,'郫县豆瓣酱（袋装）',0),

(346,4,8,1,'环太红花椒',NULL,NULL,NULL,0,0,22.80,'1558410468',1,1,269,'环太红花椒',0),

(347,4,8,1,'灿林鸡枞油（特级）500g',NULL,NULL,NULL,0,0,246.15,'1558410468',1,1,271,'灿林鸡枞油（特级）500g',0),

(348,4,8,1,'鸡精（袋装）',NULL,NULL,NULL,0,0,25.34,'1558410468',1,1,272,'鸡精（袋装）',0),

(349,4,8,1,'环太纸盒青花椒（新版）',NULL,NULL,NULL,0,0,26.06,'1558410468',1,1,273,'环太纸盒青花椒（新版）',0),

(350,4,8,1,'金阳青花椒油',NULL,NULL,NULL,0,0,27.15,'1558410468',1,1,276,'金阳青花椒油',0),

(351,4,8,1,'金阳青花椒油280ml',NULL,NULL,NULL,0,0,27.15,'1558410468',1,1,277,'金阳青花椒油280ml',0),

(352,4,8,1,'橄享中盒装B款（橄榄油500',NULL,NULL,NULL,0,0,280.54,'1558410468',1,1,282,'橄享中盒装B款（橄榄油500',0),

(353,4,8,1,'盐源红花椒（散装）',NULL,NULL,NULL,0,0,282.35,'1558410468',1,1,283,'盐源红花椒（散装）',0),

(354,4,8,1,'灿林鸡枞油（特级）盒装装',NULL,NULL,NULL,0,0,282.35,'1558410468',1,1,284,'灿林鸡枞油（特级）盒装装',0),

(355,4,8,1,'美姑生燕麦',NULL,NULL,NULL,0,0,28.96,'1558410468',1,1,285,'美姑生燕麦',0),

(356,4,8,1,'会东 姜州菜籽油',NULL,NULL,NULL,0,0,294.12,'1558410468',1,1,289,'会东 姜州菜籽油',0),

(357,4,8,1,'橄享中盒装A款（橄榄油500',NULL,NULL,NULL,0,0,298.65,'1558410468',1,1,290,'橄享中盒装A款（橄榄油500',0),

(358,4,8,1,'盐源红花椒',NULL,NULL,NULL,0,0,307.69,'1558410468',1,1,292,'盐源红花椒',0),

(359,4,8,1,'燕麦粉（熟）',NULL,NULL,NULL,0,0,32.58,'1558410468',1,1,293,'燕麦粉（熟）',0),

(360,4,8,1,'金龙鱼大豆油',NULL,NULL,NULL,0,0,338.46,'1558410468',1,1,300,'金龙鱼大豆油',0),

(361,4,8,1,'大凉山越西萝卜干',NULL,NULL,NULL,0,0,4.16,'1558410468',1,1,305,'大凉山越西萝卜干',0),

(362,4,8,1,'会东红糖 （散装）',NULL,NULL,NULL,0,0,36.20,'1558410468',1,1,308,'会东红糖 （散装）',0),

(363,4,8,1,'大凉山菜籽油',NULL,NULL,NULL,0,0,38.01,'1558410468',1,1,309,'大凉山菜籽油',0),

(364,4,8,1,'灿林鸡枞油（特级）盒装装',NULL,NULL,NULL,0,0,2737.00,'1558410468',1,1,310,'灿林鸡枞油（特级）盒装装',0),

(365,4,8,1,'金阳青花椒油258ml',NULL,NULL,NULL,0,0,39.82,'1558410468',1,1,311,'金阳青花椒油258ml',0),

(366,4,8,1,'橄享大盒装（橄榄油500ml*',NULL,NULL,NULL,0,0,447.06,'1558410468',1,1,314,'橄享大盒装（橄榄油500ml*',0),

(367,4,8,1,'豆豉',NULL,NULL,NULL,0,0,45.25,'1558410468',1,1,315,'豆豉',0),

(368,4,8,1,'环太黑苦荞三黑粉（新品）',NULL,NULL,NULL,0,0,45.88,'1558410468',1,1,316,'环太黑苦荞三黑粉（新品）',0),

(369,4,8,1,'金龙鱼调和油',NULL,NULL,NULL,0,0,461.54,'1558410468',1,1,317,'金龙鱼调和油',0),

(370,4,8,1,'灿林青花椒（听装）',NULL,NULL,NULL,0,0,54.29,'1558410468',1,1,325,'灿林青花椒（听装）',0),

(371,4,8,1,'金阳青花椒听筒装125g',NULL,NULL,NULL,0,0,54.29,'1558410468',1,1,326,'金阳青花椒听筒装125g',0),

(372,4,8,1,'酸菜',NULL,NULL,NULL,0,0,7.24,'1558410468',1,1,329,'酸菜',0),

(373,4,8,1,'灿林金阳青花椒（特级）',NULL,NULL,NULL,0,0,79.64,'1558410468',1,1,339,'灿林金阳青花椒（特级）',0),

(374,4,8,1,'会东源滋味红糖',NULL,NULL,NULL,0,0,86.88,'1558410468',1,1,341,'会东源滋味红糖',0),

(375,4,8,1,'金阳青花椒油简装盒装',NULL,NULL,NULL,0,0,90.49,'1558410468',1,1,346,'金阳青花椒油简装盒装',0),

(376,4,8,1,'大凉山小坝纯正特产菜籽油',NULL,NULL,NULL,0,0,99.55,'1558410468',1,1,347,'大凉山小坝纯正特产菜籽油',0),

(377,4,8,1,'破壁黑松露粉',NULL,NULL,NULL,0,0,108.60,'1558410468',1,1,356,'破壁黑松露粉',0),

(378,4,8,1,'郫县豆瓣酱',NULL,NULL,NULL,0,0,112.21,'1558410468',1,1,357,'郫县豆瓣酱',0),

(379,4,8,1,'蒸肉粉',NULL,NULL,NULL,0,0,114.02,'1558410468',1,1,358,'蒸肉粉',0),

(380,4,8,1,'灿林青花椒',NULL,NULL,NULL,0,0,132.13,'1558410468',1,1,369,'灿林青花椒',0),

(381,4,8,1,'金阳青花椒油小组合',NULL,NULL,NULL,0,0,144.80,'1558410468',1,1,379,'金阳青花椒油小组合',0),

(382,4,8,1,'会东姜州菜籽油',NULL,NULL,NULL,0,0,149.32,'1558410468',1,1,380,'会东姜州菜籽油',0),

(383,4,8,1,'金阳青花椒（散装）',NULL,NULL,NULL,0,0,152.04,'1558410468',1,1,381,'金阳青花椒（散装）',0),

(384,4,8,1,'金阳青花椒盒装装250g',NULL,NULL,NULL,0,0,153.85,'1558410468',1,1,382,'金阳青花椒盒装装250g',0);

/*Table structure for table `goods_cate` */

DROP TABLE IF EXISTS `goods_cate`;

CREATE TABLE `goods_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_id` int(1) unsigned NOT NULL COMMENT '门店id  新增',
  `cate_name` varchar(255) NOT NULL COMMENT '分类名称',
  `orders` int(255) unsigned DEFAULT '1' COMMENT '排序',
  `status` int(1) unsigned DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

/*Data for the table `goods_cate` */

insert  into `goods_cate`(`id`,`md_id`,`cate_name`,`orders`,`status`) values 

(8,4,'佐餐调味',1,1),

(9,4,'山珍特产',2,1),

(10,4,'茶叶酒水',3,1),

(11,4,'米面杂粮',4,1),

(12,4,'腌腊制品',5,1),

(13,4,'干果小食',6,1),

(14,4,'扶贫套餐',7,1);

/*Table structure for table `goods_guige` */

DROP TABLE IF EXISTS `goods_guige`;

CREATE TABLE `goods_guige` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(255) unsigned NOT NULL COMMENT '商品id',
  `guige_name` varchar(255) NOT NULL COMMENT '规格名称',
  `guige_price` decimal(10,2) unsigned NOT NULL COMMENT '规格价格',
  PRIMARY KEY (`id`,`guige_price`)
) ENGINE=InnoDB AUTO_INCREMENT=2051 DEFAULT CHARSET=utf8;

/*Data for the table `goods_guige` */

insert  into `goods_guige`(`id`,`goods_id`,`guige_name`,`guige_price`) values 

(11,13,'1KG',3990.00),

(12,14,'a',222.00),

(13,14,'b',111.00),

(152,25,'268g',14.00),

(156,30,'230g',123.00),

(159,35,'500g',12.00),

(204,32,'150g',78.00),

(206,43,'套餐',398.00),

(207,44,'套餐',498.00),

(210,45,'套餐',598.00),

(211,46,'套餐',698.00),

(212,33,'100g',63.00),

(213,34,'100g',45.00),

(214,22,'210g',308.00),

(215,21,'378g',633.00),

(217,23,'60g',52.00),

(218,24,'516g',127.00),

(219,42,'套餐',298.00),

(220,36,'900g',33.00),

(221,38,'900g',33.00),

(222,37,'900g',33.00),

(223,39,'500g',16.00),

(224,26,'50g',9.00),

(225,26,'100g',19.00),

(226,26,'200g',33.00),

(228,28,'106g',18.00),

(230,47,'套餐',0.01),

(246,27,'108g',68.00),

(247,19,'绿 40g',23.00),

(248,19,'桔黄 40g',23.00),

(249,19,'红 40g',23.00),

(251,41,'麻辣 108g',36.00),

(252,41,'五香 108g',36.00),

(253,41,'泡椒 108g',36.00),

(254,41,'青椒 108g',36.00),

(255,40,'五香 218g',90.00),

(256,40,'麻辣 218g',90.00),

(260,47,'480g',49.58),

(261,48,'200g',36.20),

(262,49,'300g',36.20),

(263,50,'450g',199.09),

(264,51,'204g',86.88),

(265,52,'216g',123.44),

(266,53,'180g',88.68),

(267,54,'216g',123.44),

(268,55,'138g',68.78),

(269,56,'180g',124.88),

(270,57,'216g',153.85),

(271,58,'138g',59.73),

(272,59,'204g',53.39),

(273,60,'168g',23.53),

(274,61,'360g',152.04),

(275,62,'168g',50.68),

(276,63,'500g',32.58),

(277,64,'500g',23.16),

(278,65,'138g',28.96),

(279,66,'228g',124.88),

(280,67,'138g',68.78),

(281,68,'228g',153.85),

(282,69,'480g',226.25),

(283,70,'250g',123.08),

(284,71,'500g',181.00),

(285,72,'240g',434.39),

(286,73,'240g',434.39),

(287,74,'150g',1158.38),

(288,75,'110g',886.88),

(289,76,'100g',722.18),

(290,77,'240g',122.18),

(291,78,'160g',57.92),

(292,79,'70g',21.72),

(293,80,'72g',18.09),

(294,81,'192g',50.68),

(295,82,'150g',38.01),

(296,83,'250g',47.96),

(297,84,'250g',36.20),

(298,85,'160g',316.74),

(299,86,'100g',26.25),

(300,87,'100g',20.81),

(301,88,'250g',23.53),

(302,89,'200g',97.74),

(303,90,'200g（4g*50袋）',488.68),

(304,91,'400g',235.29),

(305,92,'180g',181.00),

(306,93,'180g',171.94),

(307,94,'150g',81.45),

(308,95,'360g',633.48),

(309,96,'400g',217.20),

(310,97,'300g',68.78),

(311,98,'150g',72.40),

(312,99,'60g',10.86),

(313,100,'450g',361.99),

(314,101,'530g',108.60),

(315,102,'128g',24.44),

(316,103,'500g',181.00),

(317,104,'250g',123.08),

(318,105,'252g',59.73),

(319,106,'500g',77.82),

(320,107,'96g+赠24g',21.72),

(321,108,'450g',142.99),

(322,109,'360g',244.34),

(323,110,'102g',42.53),

(324,111,'258g',253.39),

(325,112,'318g',313.12),

(326,113,'500g',34.39),

(327,114,'252g',80.54),

(328,115,'252g',85.98),

(329,116,'200g',47.06),

(330,117,'200g',49.78),

(331,118,'200g',27.15),

(332,119,'180g',97.74),

(333,120,'180g',104.07),

(334,121,'228g',134.85),

(335,122,'500g',114.02),

(336,123,'500g',114.02),

(337,124,'265g',260.64),

(338,125,'300g',295.02),

(339,126,'160g',26.25),

(340,127,'320g',58.82),

(341,128,'320g',62.45),

(342,129,'428g',21.72),

(343,130,'500g',21.72),

(344,131,'60g（3g*20袋）',52.49),

(345,132,'60g（3g*20袋）',52.49),

(346,133,'60g（3g*20袋）',52.49),

(347,134,'60g（3g*20袋）',52.49),

(348,135,'60g（3g*20袋）',52.49),

(349,136,'80g',25.34),

(350,137,'120g',72.40),

(351,138,'150g',25.34),

(352,139,'300g',50.68),

(353,140,'228g',48.87),

(354,141,'500g',36.20),

(355,142,'500g',36.20),

(356,143,'400g',32.58),

(357,144,'500g',142.99),

(358,145,'1kg（称重）',162.89),

(359,146,'1kg（称重）',188.24),

(360,147,'250g',35.84),

(361,148,'466g',17.92),

(362,149,'466g',17.92),

(363,150,'420g',38.62),

(364,151,'420g',38.62),

(365,152,'420g',38.62),

(366,153,'150g',19.55),

(367,154,'150g',19.55),

(368,155,'150g',39.82),

(369,156,'500g',117.65),

(370,157,'80g',22.62),

(371,158,'500g',72.40),

(372,159,'80g',4.98),

(373,160,'90g',17.92),

(374,161,'80g',17.92),

(375,162,'80g',5.07),

(376,163,'190g',17.92),

(377,164,'200g',19.91),

(378,165,'200g',17.92),

(379,166,'200g',19.91),

(380,167,'280g',21.35),

(381,168,'400g',29.51),

(382,169,'708g',27.15),

(383,170,'708g',27.15),

(384,171,'248g',9.95),

(385,172,'150g',12.31),

(386,173,'150g',12.31),

(387,174,'260g',12.67),

(388,175,'40g',25.34),

(389,176,'288g',61.54),

(390,177,'108g',26.79),

(391,178,'208g',50.68),

(392,179,'248g',65.15),

(393,180,'120g',45.25),

(394,181,'200g',19.91),

(1257,182,'500g',18.09),

(1258,183,'480g',18.09),

(1259,184,'1kg（称重）',19.73),

(1260,185,'500g',19.73),

(1261,186,'500g',19.73),

(1262,187,'1kg',21.72),

(1263,188,'1kg',21.72),

(1264,189,'450g',21.72),

(1265,190,'480g',21.72),

(1266,191,'500g',21.72),

(1267,192,'25kg',262.45),

(1268,193,'500g',27.15),

(1269,194,'680g',27.15),

(1270,195,'500g',27.15),

(1271,196,'480g',28.06),

(1272,197,'750g',28.96),

(1273,198,'1kg',32.58),

(1274,199,'1kg（称重）',32.58),

(1275,200,'928g',32.58),

(1276,201,'625g',34.39),

(1277,202,'625g',34.39),

(1278,203,'1kg（称重）',36.20),

(1279,204,'2kg',53.58),

(1280,205,'330g',5.44),

(1281,206,'1kg（称重）',6.33),

(1282,207,'500g',6.33),

(1283,208,'500g',6.33),

(1284,209,'380g',6.88),

(1285,210,'5kg',54.29),

(1286,211,'5kg',65.15),

(1287,212,'1kg（称重）',7.24),

(1288,213,'500g',7.60),

(1289,214,'1kg（称重）',8.68),

(1290,215,'1kg（称重）',8.68),

(1291,216,'500g',8.87),

(1292,217,'500g',8.87),

(1293,218,'2.5kg',72.40),

(1294,219,'4kg',72.40),

(1295,220,'260g',77.82),

(1296,221,'10kg',86.88),

(1297,222,'1kg（称重）',9.78),

(1298,223,'2400g（200g*12）',90.49),

(1299,224,'4000g',99.55),

(1300,225,'360g',103.16),

(1301,226,'360g',103.16),

(1302,227,'360g',104.98),

(1303,228,'500g',10.86),

(1304,229,'1kg',10.93),

(1305,230,'4kg',117.28),

(1306,231,'10kg',123.08),

(1307,232,'260g',12.67),

(1308,233,'袋',12.67),

(1309,234,'800g',13.58),

(1310,235,'500g',14.48),

(1311,236,'500g',14.48),

(1312,237,'480g',14.48),

(1313,238,'80g',14.48),

(1314,239,'4000g',144.80),

(1315,240,'4000g',144.80),

(1316,241,'60g*360',144.80),

(1317,242,'300g*3',17.20),

(1857,243,'盒',289.59),

(1858,244,'25g*2瓶',358.38),

(1859,245,'1kg（称重）',434.39),

(1860,246,'1kg（称重）',126.69),

(1861,247,'100g',31.49),

(1862,248,'100g',42.35),

(1863,249,'80g',93.39),

(1864,250,'100g',30.76),

(1865,251,'150g',814.48),

(1866,252,'300g',1628.96),

(1867,253,'46g*5',660.64),

(1868,254,'46g*5',99.55),

(1869,255,'46g*5',90.49),

(1885,271,'450g',177.38),

(1886,272,'100g',112.21),

(1888,274,'300g',173.75),

(1890,276,'46g*5',68.78),

(1893,279,'128g',499.55),

(1894,280,'100g',36.20),

(1896,282,'100g',30.76),

(1897,283,'100g',30.76),

(1898,284,'20g',27.15),

(1899,285,'100g',27.15),

(1900,286,'100g',27.15),

(1901,287,'150g',90.49),

(1902,288,'150g',36.20),

(1903,289,'150g',36.20),

(1904,290,'1kg（称重）',19.91),

(1905,291,'1kg（称重）',21.72),

(1906,292,'1kg（称重）',23.53),

(1907,293,'1kg（称重）',30.76),

(1908,294,'1kg（称重）',36.20),

(1909,295,'1kg（称重）',72.40),

(1910,296,'1kg（称重）',108.60),

(1911,297,'1kg（称重）',289.59),

(1912,298,'1kg（称重）',135.74),

(1913,299,'1kg',181.00),

(1914,300,'1kg',181.00),

(1915,301,'1kg（称重）',209.95),

(1916,302,'1kg（称重）',209.95),

(1917,303,'5kg',1049.78),

(1918,304,'5kg',1049.78),

(1919,305,'408g',220.81),

(1920,306,'5kg',615.39),

(1921,307,'5kg',615.39),

(1922,308,'400g',279.64),

(1923,309,'1kg（称重）',289.59),

(1924,310,'1kg（称重）',289.59),

(1925,311,'116g',66.96),

(1926,312,'206g',130.32),

(1927,313,'128g',85.07),

(1928,314,'128g',85.07),

(1929,315,'248g',154.75),

(1930,316,'248g',154.75),

(1931,317,'82g',50.68),

(1932,318,'128g',66.06),

(1933,319,'128g',66.06),

(1934,320,'98g',38.38),

(1935,321,'88g',38.38),

(1936,322,'300g',181.00),

(1937,323,'300g',181.00),

(1938,324,'408g',181.00),

(1939,325,'408g',181.00),

(1940,326,'228g',57.92),

(1941,327,'252g',86.88),

(1942,328,'500g',170.14),

(1943,329,'500g',170.14),

(1944,330,'252g',86.88),

(1945,331,'80g',32.58),

(1946,332,'80g',32.58),

(1947,333,'180g',62.62),

(1948,334,'180g',62.62),

(1949,335,'2.5kg',226.25),

(1950,336,'1kg（称重）',90.49),

(1951,337,'280g',121.27),

(1952,338,'40g',22.62),

(1953,339,'40g',22.62),

(1954,340,'40g',22.62),

(1955,341,'150g',54.29),

(1956,342,'1kg（称重）',181.00),

(1957,343,'1kg（称重）',181.00),

(1958,344,'126g',195.47),

(1959,345,'1kg',21.72),

(1960,346,'80g',22.80),

(1961,347,'500g',246.15),

(1962,348,'454g',25.34),

(1963,349,'80g',26.06),

(1964,350,'258ml',27.15),

(1965,351,'280ml',27.15),

(1966,352,'500ml+3g*20包',280.54),

(1967,353,'1kg（称重）',282.35),

(1968,354,'280g*2瓶',282.35),

(1969,355,'1kg（称重）',28.96),

(1970,356,'10L',294.12),

(1971,357,'500ml+250ml',298.65),

(1972,358,'1kg（称重）',307.69),

(1973,359,'1kg（称重）',32.58),

(1974,360,'10L*2',338.46),

(1975,361,'100g',4.16),

(1976,362,'1kg（称重）',36.20),

(1977,363,'1kg（称重）',38.01),

(1978,364,'280g*3瓶',2737.00),

(1979,365,'258ml',39.82),

(1980,366,'500ml*2+3g*20包',447.06),

(1981,367,'5kg',45.25),

(1982,368,'480g',45.88),

(1983,369,'4*5L',461.54),

(1984,370,'150g',54.29),

(1985,371,'125g',54.29),

(1986,372,'1kg（称重）',7.24),

(1987,373,'218g',79.64),

(1988,374,'840g',86.88),

(1989,375,'258ml花椒油2瓶',90.49),

(1990,376,'2.5kg',99.55),

(1991,377,'50g',108.60),

(1992,378,'15kg',112.21),

(1993,379,'件',114.02),

(1994,380,'256g',132.13),

(1995,381,'25G青花椒+258ml花椒油',144.80),

(1996,382,'5L',149.32),

(1997,383,'1kg（称重）',152.04),

(1998,384,'250g',153.85),

(1999,11,'500g',54.00),

(2000,11,'1kg',109.00),

(2001,12,'500g',80.00),

(2002,12,'1kg',148.00),

(2003,15,'500g',93.00),

(2004,15,'1kg',187.00),

(2006,17,'1kg',425.00),

(2007,256,'46g*5',315.00),

(2010,259,'180g',179.00),

(2011,260,'230g',27.00),

(2015,262,'46g*5',136.00),

(2016,261,'250g',27.00),

(2019,263,'46g*5',145.00),

(2020,265,'100g',45.00),

(2021,266,'100g',136.00),

(2022,267,'100g',297.00),

(2023,258,'100g',481.00),

(2024,18,'40g',81.00),

(2025,29,'150g',20.00),

(2026,16,'500ml',208.00),

(2028,269,'218g',80.00),

(2029,270,'100g',63.00),

(2030,257,'46g*5袋',248.00),

(2031,257,'100g盒装',63.00),

(2033,264,'100g',54.00),

(2034,264,'300g（精选）',174.00),

(2036,275,'250g（袋）',90.00),

(2038,20,'228g',116.00),

(2041,277,'100g（盒）',235.00),

(2042,278,'160g（瓶）',47.00),

(2043,31,'250g（盒）',579.00),

(2044,31,'128g（瓶）',500.00),

(2045,268,'100g（盒）',36.00),

(2046,268,'100g（袋）',36.00),

(2047,273,'350g（盒）',96.00),

(2048,273,'46g*5（袋）',69.00),

(2050,281,'100g',57.92);

/*Table structure for table `goods_notes` */

DROP TABLE IF EXISTS `goods_notes`;

CREATE TABLE `goods_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_id` int(255) unsigned DEFAULT NULL COMMENT '门店id',
  `content` text COMMENT '须知内容',
  `status` int(1) unsigned DEFAULT NULL COMMENT '是否显示须知',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `goods_notes` */

insert  into `goods_notes`(`id`,`md_id`,`content`,`status`) values 

(3,4,'所有产品都是来自凉山州的地方特产，专项扶贫项目，纯正农产品，且具有纯天然无污染、富含营养成分等优势。',1);

/*Table structure for table `index_ad` */

DROP TABLE IF EXISTS `index_ad`;

CREATE TABLE `index_ad` (
  `imgUrl` varchar(255) NOT NULL COMMENT '图片',
  `link` varchar(255) DEFAULT NULL COMMENT '链接的页面',
  `map` int(1) unsigned NOT NULL COMMENT '位置  1是首页  2是文章页面'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `index_ad` */

insert  into `index_ad`(`imgUrl`,`link`,`map`) values 

('uploads/25220_101645_4383.png','/pages/goodsDetail/goodsDetail?id=42',1),

('uploads/25220_174023_3691.png','/pages/goodsDetail/goodsDetail?id=8',2);

/*Table structure for table `jifen_cate` */

DROP TABLE IF EXISTS `jifen_cate`;

CREATE TABLE `jifen_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cate_name` varchar(255) DEFAULT NULL COMMENT '积分商城分类名',
  `orders` int(255) unsigned DEFAULT '1' COMMENT '积分商城分类排序',
  `status` int(1) unsigned DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `jifen_cate` */

insert  into `jifen_cate`(`id`,`cate_name`,`orders`,`status`) values 

(1,'优惠券',1,0),

(2,'花札礼品',2,0);

/*Table structure for table `jifen_goods` */

DROP TABLE IF EXISTS `jifen_goods`;

CREATE TABLE `jifen_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(255) unsigned NOT NULL COMMENT '所属分类',
  `goods_name` varchar(255) NOT NULL COMMENT '积分兑换商拼名称',
  `goods_images` varchar(255) DEFAULT NULL COMMENT '商品封面图',
  `goods_description` text COMMENT '商品介绍',
  `price` int(255) unsigned NOT NULL DEFAULT '9999' COMMENT '需要多少积分兑换',
  `addtime` varchar(255) DEFAULT NULL COMMENT '商品上架时间',
  `orders` int(255) unsigned NOT NULL DEFAULT '1' COMMENT '商品排序',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '商品状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `jifen_goods` */

insert  into `jifen_goods`(`id`,`pid`,`goods_name`,`goods_images`,`goods_description`,`price`,`addtime`,`orders`,`status`) values 

(2,1,'优惠券无门槛直减100元!','uploads/25220_171804_2793.png','<p style=\"text-align: center;\">当当当当</p><p style=\"text-align: center;\">这是一张神奇的优惠券，无门槛直减100块，但是没用完的不退哦!</p><p style=\"text-align: center;\"><img src=\"/ueditor/php/upload/image/20190312/1552382280980762.png\" title=\"1552382280980762.png\" alt=\"jr-logo.png\"/></p>',12999,'1552382284',1,0);

/*Table structure for table `jifen_record` */

DROP TABLE IF EXISTS `jifen_record`;

CREATE TABLE `jifen_record` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(255) unsigned DEFAULT NULL COMMENT '用户id',
  `time` varchar(255) DEFAULT NULL,
  `goods` varchar(255) DEFAULT NULL COMMENT '兑换商店的商品',
  `jifen` int(255) DEFAULT NULL COMMENT '积分',
  `tag` varchar(255) DEFAULT NULL COMMENT '增加还是减少积分  + -',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `jifen_record` */

/*Table structure for table `jifen_rule` */

DROP TABLE IF EXISTS `jifen_rule`;

CREATE TABLE `jifen_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jifen` int(255) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `jifen_rule` */

insert  into `jifen_rule`(`id`,`jifen`) values 

(1,1);

/*Table structure for table `md` */

DROP TABLE IF EXISTS `md`;

CREATE TABLE `md` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_name` varchar(255) NOT NULL COMMENT '门店名称',
  `md_address` varchar(255) NOT NULL COMMENT '门店详细地址',
  `md_map` varchar(255) DEFAULT NULL COMMENT '门店坐标',
  `md_phone` varchar(20) NOT NULL COMMENT '门店电话',
  `online_time` varchar(255) DEFAULT NULL COMMENT '营业时间段',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '门店状态',
  `up_price` int(10) DEFAULT NULL COMMENT '满多少元配送',
  `peisong_price` int(10) DEFAULT NULL COMMENT '配送费',
  `peisong_fanwei` int(10) DEFAULT NULL COMMENT '配送范围  单位千米',
  `peisong_service` varchar(255) DEFAULT NULL COMMENT '配送说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*Data for the table `md` */

insert  into `md`(`id`,`md_name`,`md_address`,`md_map`,`md_phone`,`online_time`,`status`,`up_price`,`peisong_price`,`peisong_fanwei`,`peisong_service`) values 

(4,'成都店','四川省成都市天府新区永兴街道土主庙街44号附7号','30.354080,104.146660','18010581818','00:00:00 - 00:00:00',1,1,1,60,'1');

/*Table structure for table `message` */

DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `m_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '身份绑定ID',
  `m_name` varchar(50) NOT NULL COMMENT '人名',
  `m_phone` varchar(20) NOT NULL COMMENT '手机号',
  `m_yzm` varchar(10) NOT NULL COMMENT '手机号验证码',
  `user_token` varchar(100) NOT NULL COMMENT '用户token',
  `m_danwei` varchar(100) NOT NULL COMMENT '单位名称',
  `m_city` varchar(200) NOT NULL COMMENT '单位地区',
  PRIMARY KEY (`m_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='身份信息绑定表';

/*Data for the table `message` */

insert  into `message`(`m_id`,`m_name`,`m_phone`,`m_yzm`,`user_token`,`m_danwei`,`m_city`) values 

(2,'张晓玉','18381686207','8051','$2y$10$tF4YVExW9/WpclXmCh0n8uPoN7qG/IA4j2vMk44j4hnLR6gSLpfRC','蓝色星空','四川省成都市武侯区锦城大道666号'),

(3,'张三','18783241200','1034','$2y$10$F83D6SkcKLrkm/hTF7LsIewvOlajqFcR9Vx37.QPpGjOqK8n8hz1.','你好','奥克斯中心C座(武侯区锦城大道710号)');

/*Table structure for table `node` */

DROP TABLE IF EXISTS `node`;

CREATE TABLE `node` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_name` varchar(255) NOT NULL,
  `controller_name` varchar(255) NOT NULL,
  `function_name` varchar(255) NOT NULL,
  `tag` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

/*Data for the table `node` */

insert  into `node`(`id`,`node_name`,`controller_name`,`function_name`,`tag`) values 

(1,'查看商品分类','GoodsCateController','index','商品类'),

(2,'操作商品分类','GoodsCateController','create','商品类'),

(3,'商品购买须知','GoodsCateController','notes','商品类'),

(4,'查看商品列表','GoodsCateController','goods','商品类'),

(5,'操作商品列表','GoodsCateController','goodsAdd','商品类'),

(6,'查看热销商品','GoodsCateController','goodshot','商品类'),

(7,'操作热销商品','GoodsCateController','goodshotAdd','商品类'),

(8,'查看文章类别','WenzhangController','cate','文章类'),

(9,'操作文章类别','WenzhangController','cate_create','文章类'),

(10,'查看文章列表','WenzhangController','index','文章类'),

(11,'操作文章列表','WenzhangController','add','文章类'),

(12,'关于简诺','WenzhangController','about','文章类'),

(13,'查看沙龙列表','ShalongController','list','沙龙类'),

(14,'操作沙龙列表','ShalongController','add','沙龙类'),

(15,'查看沙龙详情','ShalongController','lookPerson','沙龙类'),

(16,'查看优惠券列表','YouController','list','优惠券类'),

(17,'操作优惠券列表','YouController','add','优惠券类'),

(18,'查看用户列表','UserController','list','用户类'),

(19,'操作用户状态','UserController','status','用户类'),

(20,'查看会员列表','VipController','list','会员类'),

(21,'操作会员状态','VipController','status','会员类'),

(22,'查看会员等级列表','VipController','level','会员类'),

(23,'操作会员等级列表','VipController','level_create','会员类'),

(24,'查看积分商城分类列表','JifenController','list','积分类'),

(25,'操作积分商城分类列表','JifenController','cate_create','积分类'),

(26,'查看积分商品列表','JifenController','goods_list','积分类'),

(27,'操作积分商品列表','JifenController','goods_add','积分类'),

(28,'积分规则','JifenController','guize','积分类'),

(29,'查看门店列表','MdController','list','门店类'),

(30,'操作门店列表','MdController','create','门店类'),

(31,'查看管理员列表','AdminUserController','list','管理员类'),

(32,'操作管理员列表','AdminUserController','create','管理员类');

/*Table structure for table `order` */

DROP TABLE IF EXISTS `order`;

CREATE TABLE `order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(255) unsigned NOT NULL COMMENT '订单号',
  `user_id` int(255) NOT NULL COMMENT '用户id',
  `md_id` int(255) NOT NULL COMMENT '门店id',
  `is_sl` int(255) unsigned DEFAULT NULL COMMENT '沙龙订单   商品id通过名单号自动关联order_goods表',
  `is_yh` int(255) unsigned DEFAULT '0' COMMENT '是否使用优惠  0位否  其他为优惠券id',
  `is_jifen` int(255) unsigned DEFAULT '0' COMMENT '是否使用积分  0为未使用  其他为使用的积分',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `order_time` varchar(255) NOT NULL COMMENT '下单时间',
  `pay_type` varchar(255) NOT NULL COMMENT '支付方式',
  `order_type` varchar(255) NOT NULL COMMENT 'ziqu 为自取  其他为配送',
  `name` varchar(255) DEFAULT NULL COMMENT '收货人姓名',
  `phone` varchar(255) NOT NULL COMMENT '收货人手机',
  `address` varchar(255) DEFAULT NULL COMMENT '收货地址',
  `peisong_price` int(255) unsigned DEFAULT NULL COMMENT '配送费',
  `notes` varchar(255) DEFAULT NULL COMMENT '订单备注',
  `pay_time` varchar(255) DEFAULT NULL COMMENT '付款时间',
  `goods_date` varchar(255) DEFAULT NULL COMMENT '商品自取时间或者预约的配送时间',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0待支付   1已支付待确认（后台管理员确认）   2已确认待发货 （后台管理员确认） 3 已发货待收货（后台管理员确认，给客户端客户看的）  4已收货已完成（后台管理员确认）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `order` */

/*Table structure for table `order_goods` */

DROP TABLE IF EXISTS `order_goods`;

CREATE TABLE `order_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(255) unsigned NOT NULL COMMENT '订单号',
  `goods_id` int(255) unsigned NOT NULL COMMENT '商品id',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `goods_num` int(255) unsigned NOT NULL DEFAULT '1' COMMENT '商品数量',
  `guige_id` int(255) unsigned DEFAULT NULL COMMENT '规格id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `order_goods` */

/*Table structure for table `peisong` */

DROP TABLE IF EXISTS `peisong`;

CREATE TABLE `peisong` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_id` int(255) unsigned NOT NULL COMMENT '门店id',
  `init_start_price` int(255) NOT NULL COMMENT '免运费价格',
  `init_juli` int(255) unsigned NOT NULL COMMENT '免运费初始距离（内（含））',
  `init_price` int(255) NOT NULL COMMENT '免运费初始价格（以上（含））',
  `level_juli` int(255) unsigned NOT NULL COMMENT '每一档距离（km）补足进一补足',
  `level_price` int(255) unsigned NOT NULL COMMENT '每一档距离的价格（元）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*Data for the table `peisong` */

insert  into `peisong`(`id`,`md_id`,`init_start_price`,`init_juli`,`init_price`,`level_juli`,`level_price`) values 

(1,1,300,3,15,3,6);

/*Table structure for table `record` */

DROP TABLE IF EXISTS `record`;

CREATE TABLE `record` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(255) unsigned NOT NULL COMMENT '用户id',
  `order_id` varchar(255) DEFAULT NULL COMMENT '订单号',
  `goods` varchar(255) DEFAULT NULL COMMENT '商品',
  `time` varchar(255) NOT NULL COMMENT '交易时间',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '金额',
  `tag` varchar(255) DEFAULT NULL COMMENT '充值或者消费  +  -',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `record` */

/*Table structure for table `rule` */

DROP TABLE IF EXISTS `rule`;

CREATE TABLE `rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rule_name` varchar(255) NOT NULL,
  `status` int(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `rule_name` (`rule_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `rule` */

insert  into `rule`(`id`,`rule_name`,`status`) values 

(1,'超级管理员',1),

(2,'门店管理员',1);

/*Table structure for table `rule_node` */

DROP TABLE IF EXISTS `rule_node`;

CREATE TABLE `rule_node` (
  `rule_id` int(255) unsigned NOT NULL,
  `node_id` int(255) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `rule_node` */

insert  into `rule_node`(`rule_id`,`node_id`) values 

(4,1),

(4,2),

(4,3),

(4,4),

(4,5),

(4,6),

(1,1),

(1,2),

(1,3),

(1,4),

(1,5),

(1,6),

(1,7),

(1,8),

(1,9),

(1,10),

(1,11),

(1,12),

(1,13),

(1,14),

(1,15),

(1,16),

(1,17),

(1,18),

(1,19),

(1,20),

(1,21),

(1,22),

(1,23),

(1,24),

(1,25),

(1,26),

(1,27),

(1,28),

(1,29),

(1,30),

(1,31),

(1,32);

/*Table structure for table `shalong` */

DROP TABLE IF EXISTS `shalong`;

CREATE TABLE `shalong` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `md_id` int(255) unsigned NOT NULL COMMENT '门店id',
  `title` varchar(255) DEFAULT NULL COMMENT '沙龙标题',
  `content` text COMMENT '沙龙详情',
  `imgURL` varchar(255) DEFAULT NULL COMMENT '沙龙封面图',
  `person_num` int(255) unsigned DEFAULT NULL COMMENT '报名上限人数',
  `person_num_ok` int(255) unsigned DEFAULT '0' COMMENT '已报名人数',
  `price_status` int(1) DEFAULT NULL COMMENT '报名使用积分还是现金  1现金 2积分',
  `price` int(255) DEFAULT NULL COMMENT '积分数量或者现金',
  `end_date` varchar(255) DEFAULT NULL COMMENT '报名截止时间',
  `level` varchar(255) DEFAULT NULL COMMENT '沙龙状态   报名中..已完成..',
  `sendtime` varchar(255) DEFAULT NULL COMMENT '发布时间',
  `orders` int(2) DEFAULT '1' COMMENT '是否置顶  默认1正常  -1置顶',
  `status` int(1) unsigned DEFAULT '1' COMMENT '沙龙上下架状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `shalong` */

/*Table structure for table `shalong_person` */

DROP TABLE IF EXISTS `shalong_person`;

CREATE TABLE `shalong_person` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(255) DEFAULT NULL COMMENT '用户标识',
  `shalong_id` int(255) unsigned DEFAULT NULL COMMENT '沙龙id',
  `time` varchar(255) DEFAULT NULL COMMENT '报名时间',
  `price` varchar(255) DEFAULT NULL COMMENT '金额',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `shalong_person` */

/*Table structure for table `shoporder` */

DROP TABLE IF EXISTS `shoporder`;

CREATE TABLE `shoporder` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(255) unsigned NOT NULL COMMENT '订单号',
  `user_id` int(255) NOT NULL COMMENT '用户id',
  `md_id` int(255) NOT NULL COMMENT '门店id',
  `is_sl` int(255) unsigned DEFAULT NULL COMMENT '沙龙订单   商品id通过名单号自动关联order_goods表',
  `is_yh` int(255) unsigned DEFAULT '0' COMMENT '是否使用优惠  0位否  其他为优惠券id',
  `is_jifen` int(255) unsigned DEFAULT '0' COMMENT '是否使用积分  0为未使用  其他为使用的积分',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `order_time` varchar(255) NOT NULL COMMENT '下单时间',
  `pay_type` varchar(255) NOT NULL COMMENT '支付方式',
  `order_type` varchar(255) NOT NULL COMMENT 'ziqu 为自取  其他为配送',
  `name` varchar(255) DEFAULT NULL COMMENT '收货人姓名',
  `phone` varchar(255) NOT NULL COMMENT '收货人手机',
  `address` varchar(255) DEFAULT NULL COMMENT '收货地址',
  `peisong_price` int(255) unsigned DEFAULT NULL COMMENT '配送费',
  `notes` varchar(255) DEFAULT NULL COMMENT '订单备注',
  `pay_time` varchar(255) DEFAULT NULL COMMENT '付款时间',
  `goods_date` varchar(255) DEFAULT NULL COMMENT '商品自取时间或者预约的配送时间',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0待支付   1已支付待确认（后台管理员确认）   2已确认待发货 （后台管理员确认） 3 已发货待收货（后台管理员确认，给客户端客户看的）  4已收货已完成（后台管理员确认）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8;

/*Data for the table `shoporder` */

insert  into `shoporder`(`id`,`order_id`,`user_id`,`md_id`,`is_sl`,`is_yh`,`is_jifen`,`price`,`order_time`,`pay_type`,`order_type`,`name`,`phone`,`address`,`peisong_price`,`notes`,`pay_time`,`goods_date`,`status`) values 

(290,11628673,108,4,NULL,0,0,13600.00,'1558433316','60分钟后','peisong',NULL,'0',NULL,0,'无',NULL,NULL,0),

(291,14172356,108,4,NULL,0,0,17400.00,'1558534530','60分钟后','peisong',NULL,'0',NULL,0,'无',NULL,NULL,0);

/*Table structure for table `shoporder_goods` */

DROP TABLE IF EXISTS `shoporder_goods`;

CREATE TABLE `shoporder_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(255) unsigned NOT NULL COMMENT '订单号',
  `goods_id` int(255) unsigned NOT NULL COMMENT '商品id',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '价格',
  `goods_num` int(255) unsigned NOT NULL DEFAULT '1' COMMENT '商品数量',
  `guige_id` int(255) unsigned DEFAULT NULL COMMENT '规格id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=utf8;

/*Data for the table `shoporder_goods` */

insert  into `shoporder_goods`(`id`,`order_id`,`goods_id`,`price`,`goods_num`,`guige_id`) values 

(282,11628673,266,136.00,1,2021),

(283,14172356,264,174.00,1,2034);

/*Table structure for table `user` */

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `nickname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `openid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '姓名',
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户配送地址',
  `menpai` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '门牌号（详细地址）',
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '电话',
  `level` int(1) unsigned DEFAULT '0' COMMENT '会员等级  0普通 1标准 2高级',
  `chongzhi_price` decimal(65,0) unsigned DEFAULT '0' COMMENT '总充值额',
  `jifen` int(255) unsigned DEFAULT '0' COMMENT '用户积分',
  `addtime` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '注册时间',
  `pay_password` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '钱包支付密码',
  `pay_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '完成支付后的模板消息发送id  单个可用三次',
  `status` int(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `user` */

insert  into `user`(`id`,`nickname`,`header`,`token`,`openid`,`name`,`address`,`menpai`,`phone`,`level`,`chongzhi_price`,`jifen`,`addtime`,`pay_password`,`pay_id`,`status`) values 

(103,'_','https://wx.qlogo.cn/mmopen/vi_32/d8vpC6nE8p6htyO793LINRscvcCMrC70pUrGXxnYgwozUM11tKYm8xoYM17jMKOkhMtRkxHOnJnEHfoVcwQy8w/132','$2y$10$84Qq0O5btzf8rYSlr.Dr2.7meyrsxBEbI/4GZ1HDIape2ygX3pcfK','o1hfU5GLRbESCyZjaFW7GE-D_Ma4',NULL,NULL,NULL,NULL,0,0,0,'1556593352',NULL,NULL,1),

(104,'天亮了','https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTJLYl4RGExAHqhibz8OwM0HurO1jhUcKn2oNLAuZXF0fLiblRH7mva7Ur7f58TvzicWPEPKWCwjse29Q/132','$2y$10$F83D6SkcKLrkm/hTF7LsIewvOlajqFcR9Vx37.QPpGjOqK8n8hz1.','o1hfU5J1NLI7ftUUE1dcECV7RP9I','张三','四川省成都市武侯区武侯祠大街264号','双击打开','18783241200',0,0,0,'1557023775','411377','wx211628249260982875db90a83204685015',1),

(105,'夸什么张','https://wx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTJ8iads7Wapp04b4hQWkKfPW35GURib9EP9G71x3r730apgft0TySoPRdvib5M68TAazHMP0GWsb0caw/132','$2y$10$tF4YVExW9/WpclXmCh0n8uPoN7qG/IA4j2vMk44j4hnLR6gSLpfRC','o1hfU5JitLswf12hd3WzlVHInIzg','张晓玉','四川省成都市武侯区锦城大道710号','715-716','18381686207',0,0,0,'1557024362','821286','wx2010290042212235abfe82452747175395',1),

(106,NULL,NULL,'$2y$10$8lOAnryEee6dXAba0ChEG.Ca08f8/r1uT44CtkzjQm.F3VhYGexMK','o1hfU5F8rjmm95Q6msFz5AmiXC_Q',NULL,NULL,NULL,NULL,0,0,0,'1557036672',NULL,NULL,1),

(107,'别让情两难','https://wx.qlogo.cn/mmopen/vi_32/JQmleeDm3g1qDJN3swfLG303Of8sQAK4YOVMJZUsxHtanpfnsXMCruF53QHDEKwzyP2WKdtmicXN3e0kPX9Uu1Q/132','$2y$10$SPVe4McgHGim1CJrLd0k.OZpa7BPNRdAscDNKUp8s8rGr6OKK80/i','o1hfU5PUVOuveOsvDEYGJpfn4-l4',NULL,NULL,NULL,NULL,0,0,0,'1557052988',NULL,NULL,1),

(108,'铭彩','https://wx.qlogo.cn/mmopen/vi_32/3KCiamyqTHJtEIJmkDUGHkZrAYG1yfHsQh4xk9PUlCzMqlZMHIsvEXia9Qf6VgoOEkcba3VlXwz4xlQI2Mf0gl7A/132','$2y$10$mP13AjIKPEnTVH28QFyvJuQrc.NtQZ88WaYpH2PBiIsrd3lyZaYm2','o1hfU5NOecCQo3YUltJpVsAMs8zY',NULL,NULL,NULL,NULL,0,0,0,'1557109494',NULL,NULL,1);

/*Table structure for table `user_you` */

DROP TABLE IF EXISTS `user_you`;

CREATE TABLE `user_you` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `youhui_id` int(255) unsigned NOT NULL COMMENT '优惠券id',
  `user_id` int(255) NOT NULL COMMENT '用户id',
  `name` varchar(255) NOT NULL COMMENT '优惠券名字',
  `type` int(1) unsigned NOT NULL COMMENT '1直减  2折扣',
  `price` varchar(10) NOT NULL COMMENT '直减或者折扣力度',
  `use_height` int(10) unsigned NOT NULL COMMENT '满多少钱可用   无门槛为0',
  `end_date` varchar(255) NOT NULL COMMENT '失效时间',
  `md` int(255) unsigned NOT NULL COMMENT '使用门店限制   0为全部门店  其他为门店id',
  `use_type` int(1) unsigned NOT NULL COMMENT '商品使用范围  1全部 2以下可用  3以下不可用',
  `use_size` varchar(255) DEFAULT NULL COMMENT '指定商品id   指定商品不可用id   全部不需要id',
  `tips` varchar(255) DEFAULT NULL COMMENT '优惠券说明',
  `addtime` varchar(255) NOT NULL COMMENT '领取时间',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未使用  1已使用',
  `vip` int(255) unsigned DEFAULT '0' COMMENT '是否vip券',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8;

/*Data for the table `user_you` */

insert  into `user_you`(`id`,`youhui_id`,`user_id`,`name`,`type`,`price`,`use_height`,`end_date`,`md`,`use_type`,`use_size`,`tips`,`addtime`,`status`,`vip`) values 

(165,92,103,'新用户专享满减券',1,'3',3,'1559232000',0,1,'','新用户专享满减券，下单直接抵扣使用','1557039654',0,0),

(166,92,104,'新用户专享满减券',1,'3',3,'1559232000',0,1,'','新用户专享满减券，下单直接抵扣使用','1557039654',0,0),

(167,92,105,'新用户专享满减券',1,'3',3,'1559232000',0,1,'','新用户专享满减券，下单直接抵扣使用','1557039654',0,0),

(168,92,106,'新用户专享满减券',1,'3',3,'1559232000',0,1,'','新用户专享满减券，下单直接抵扣使用','1557039654',0,0),

(169,93,103,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(170,93,104,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(171,93,105,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(172,93,106,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(173,93,107,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(174,93,108,'满减券',1,'1',0,'1559232000',0,1,'','无','1557991903',0,0),

(175,94,103,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0),

(176,94,104,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0),

(177,94,105,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0),

(178,94,106,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0),

(179,94,107,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0),

(180,94,108,'满减1',1,'0.1',0,'1559232000',0,1,'','无','1557991942',0,0);

/*Table structure for table `vip_level` */

DROP TABLE IF EXISTS `vip_level`;

CREATE TABLE `vip_level` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `level_name` varchar(255) NOT NULL COMMENT '会员等级名称',
  `level_price` int(8) unsigned NOT NULL COMMENT '需要冲的钱',
  `send` int(255) unsigned DEFAULT '0' COMMENT '赠送费用',
  `status` int(1) unsigned DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `vip_level` */

insert  into `vip_level`(`id`,`level_name`,`level_price`,`send`,`status`) values 

(1,'铜牌会员',1000,100,1),

(2,'银牌会员',2000,200,1),

(3,'金牌会员',3000,500,1),

(4,'铂金会员',5000,1250,1),

(5,'钻石会员',10000,3300,1);

/*Table structure for table `wz` */

DROP TABLE IF EXISTS `wz`;

CREATE TABLE `wz` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(255) unsigned DEFAULT NULL COMMENT '分类id',
  `wz_name` varchar(255) NOT NULL COMMENT '文章名',
  `wz_img` varchar(255) DEFAULT NULL COMMENT '封面图',
  `wz_content` text COMMENT '富文本信息',
  `look` int(255) unsigned DEFAULT '0' COMMENT '浏览量',
  `orders` int(2) DEFAULT '1' COMMENT '排序负数的话就是置顶，其余按照时间倒序排列',
  `sendtime` varchar(255) DEFAULT NULL COMMENT '时间戳',
  `status` int(1) unsigned DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `wz` */

/*Table structure for table `wz_cate` */

DROP TABLE IF EXISTS `wz_cate`;

CREATE TABLE `wz_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cate_name` varchar(255) DEFAULT NULL,
  `status` int(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `wz_cate` */

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
