<?php

if(! defined('OT_ROOT')) {
	exit('Access Denied');
}


class StrCN{

	// 会员积分记录 类别
	public static function ScoreType($str){
		$typeArr = self::ScoreTypeArr();

		if (isset($typeArr[$str])){
			return $typeArr[$str];
		}else{
			return '['. $str .']';
		}
	}

	// 会员积分记录 类别
	public static function ScoreTypeArr(){
		return array(
			'reg'		=> '注册',
			'login'		=> '登录',
			'qiandao'	=> '签到',
			'recom'		=> '邀请',
			'addInfo'	=> '投稿',
			'read'		=> '阅读文章',
			'delInfo'	=> '删除文章',
			'newsGain'	=> '文章积分分成',
			'audit1'	=> '文章审核',
			'audit0'	=> '文章拒审',
			'gift'		=> '积分兑换',
			'suff'		=> '用户充值',
			'orders'	=> '订单录入',
			'time'		=> '时长卡密',
			'workCenter'	=> '任务',
			'work'			=> '领工资',
			'groupKaitong'	=> '会员组开通',
			'groupXufei'	=> '会员组续费',
			'userState1'	=> '会员转正',
			'moneyGive'		=> '充值满送',
			'userScoreMul'	=> '金额兑换积分',
			'taokeOrder'	=> '淘宝订单结算',
			'admin'			=> '后台',
			'other'			=> '其他'
			);
	}

	// 积分商城 用户兑换记录 状态
	public static function GiftUsersState($num){
		switch ($num){
			case -1:	return '<span style="color:red;">作废</span>';
			case 0:		return '<span style="color:#000;">待审核</span>';
			case 1:		return '<span style="color:green;">待发货</span>';
			case 2:		return '<span style="color:blue;font-weight:bold;">已发货</span>';
			case 3:		return '<span style="color:blue;font-weight:bold;">自动发货</span>';
			default:	return '[未知'. $num .']';
		}
	}

	// 会员订单录入 状态
	public static function BuyOrdersState($num){
		switch ($num){
			case -1:	return '<span style="color:red;">作废</span>';
			case 0:		return '<span style="color:#000;">待审核</span>';
			case 1:		return '<span style="color:green;">待结算</span>';
			case 2:		return '<span style="color:blue;">已结算</span>';
			default :	return '[未知'. $num .']';
		}
	}

	// 邀请好友 状态
	public static function RecomState($num){
		switch ($num){
			case 1:		return '<span style="color:green;">有效</span>';		
			case 0:		return '<span style="color:red;">无效</span>';		
			default :	return '[未知'. $num .']';
		}
	}

	// 推广提现 提现状态
	public static function GainMoneyState($num){
		switch ($num){
			case 9:		return '<span style="color:red;">已拒绝</span>';		
			case 6:		return '<span style="color:red;">处理失败</span>';		
			case 1:		return '<span style="color:green;">已处理</span>';		
			case 0:		return '<span style="color:#000;">待处理</span>';		
			default :	return '[未知'. $num .']';
		}
	}

	// 推广提现 佣金记录状态
	public static function GainItemState($num, $mode=''){
		switch ($num){
			case 9:		return $mode=='cn' ? '已退款' : '<span style="color:red;">已退款</span>';		
			case 6:		return $mode=='cn' ? '处理失败' : '<span style="color:red;">处理失败</span>';		
			case 1:		return $mode=='cn' ? '已结算' : '<span style="color:green;">已结算</span>';		
			case 0:		return $mode=='cn' ? '待结算' : '<span style="color:#000;">待结算</span>';		
			default :	return '[未知'. $num .']';
		}
	}

	// 推广提现 产品类型
	public static function GainItemType($str){
		switch ($str){
			case 'taoke':	return '淘客';
			case 'domain':	return '域名';
			case 'host':	return '虚拟主机';
			case 'vpsPro':	return '云主机';
			case 'vpsApi':	return '云服务器';
			case 'dialing':	return '拨号VPS';
			case 'pptp':	return 'PPTP';
			case 'serv':	return '服务器租用';
			case 'ssl':		return 'SSL证书';
			case 'other':	return '其他';
			default :		return '['. $str .']';
		}
	}

	// 未付/已付
	public static function IsPay($num, $mode=''){
		switch ($num){
			case 2:		return $mode=='cn' ? '已付(GET网址反馈)' : '<span style="color:green;" title="GET网址反馈">已付2</span>';	// 客户端反馈
			case 1:		return $mode=='cn' ? '已付(服务端反馈)' : '<span style="color:green;" title="服务端反馈">已付</span>';		// 服务端反馈
			case 0:		return $mode=='cn' ? '未付' : '<span style="color:red;">未付</span>';
			default:	return $num;
		}
	}


	// 打赏类型
	public static function DashangIcoCN($str,$mode=''){
		switch ($str){
			case 'weixin':
				if ($mode=='color'){
					return '#4cbe0d';
				}elseif ($mode=='theme'){
					return '微信扫一扫，打赏作者吧～';
				}else{
					return '微信';
				}
				break;
		
			case 'alipay':
				if ($mode=='color'){
					return '#089fd2';
				}elseif ($mode=='theme'){
					return '支付宝扫一扫，打赏作者吧～';
				}else{
					return '支付宝';
				}
				break;
		
			case 'qq':
				if ($mode=='color'){
					return '#0bb2ff';
				}elseif ($mode=='theme'){
					return 'QQ扫一扫，打赏作者吧～';
				}else{
					return 'QQ钱包';
				}
				break;
		
			case 'baifubao':
				if ($mode=='color'){
					return '#d70100';
				}elseif ($mode=='theme'){
					return '百度钱包扫一扫，打赏作者吧～';
				}else{
					return '百度钱包';
				}
				break;
		
			default :			return $str;
				break;
		}
	}

	// 登录状态保存时间
	public static function LoginExp($num){
		switch ($num){
			case 1:		return '30天';
			case 2:		return '15天';
			case 3:		return '7天';
			case 4:		return '3天';
			case 5:		return '1天';
			case 21:	return '12小时';
			case 22:	return '6小时';
			case 23:	return '3小时';
			case 24:	return '2小时';
			case 25:	return '1小时';
			case 31:	return '30分钟';
			case 32:	return '15分钟';
			default:	return $num;
		}
	}

	// 网址跳转 来源类型
	public static function GoUrlTypeCN($str){
		switch ($str){
			case 'alipay':		return '支付宝';
			case 'weixin':		return '微信';
			case 'QQ':			return 'QQ';
			case 'IE':			return 'IE浏览器';
			case 'opera':		return 'opera浏览器';
			case 'chrome':		return '谷歌浏览器';
			case 'safari':		return '苹果浏览器';
			case 'firefox':		return '火狐浏览器';
			case 'android':		return '安卓手机';
			case 'iphone':		return '苹果手机';
			case 'other':		return '其他';
			default:			return $str;
		}
	}

	// 检查收录情况 状态
	public static function ResCN($str, $num, $mode=''){
		switch ($num){
			case 0:		return $mode=='cn' ? '未检测' : '<span style="color:#c9c9c9;" title="'. $str .'未检测">['. $str .'-]</span>';		
			case 1:		return $mode=='cn' ? '已收录' : '<span style="color:green;" title="'. $str .'已收录">['. $str .'√]</span>';		
			case 2:		return $mode=='cn' ? '已收录API' : '<span style="color:green;" title="'. $str .'已收录（API）">['. $str .'★]</span>';		
			case 11:	return $mode=='cn' ? '未收录' : '<span style="color:red;" title="'. $str .'未收录">['. $str .'×]</span>';		
			case 12:	return $mode=='cn' ? '未收录API' : '<span style="color:red;" title="'. $str .'未收录（API）">['. $str .'✖]</span>';		
			default :	return '[未知'. $num .']';
		}
	}

	// 举报类型
	public static function ReportTypeCN($str){
		switch ($str){
			case 'info':	return '文章';
			case 'reply':	return '评论';
			case 'message':	return '留言';
			default :		return '['. $str .']';
		}
	}

	// 阅读状态
	public static function ReadState($num){
		switch ($num){
			case 0:		return '<span style="color:red;">未读</span>';
			case 1:		return '<span>已读</span>';
			default :	return '['. $num .']';
		}
	}

}

?>