<?php
function isMobile(){
    // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
    if (isset ($_SERVER['HTTP_X_WAP_PROFILE']))
        return true;
 
    //此条摘自TPM智能切换模板引擎，适合TPM开发
    if(isset ($_SERVER['HTTP_CLIENT']) &&'PhoneClient'==$_SERVER['HTTP_CLIENT'])
        return true;
    //如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
    if (isset ($_SERVER['HTTP_VIA']))
        //找不到为flase,否则为true
        return stristr($_SERVER['HTTP_VIA'], 'wap') ? true : false;
    //判断手机发送的客户端标志,兼容性有待提高
    if (isset ($_SERVER['HTTP_USER_AGENT'])) {
        $clientkeywords = array(
            'nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile'
        );
        //从HTTP_USER_AGENT中查找手机浏览器的关键字
        if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))) {
            return true;
        }
    }
    //协议法，因为有可能不准确，放到最后判断
    if (isset ($_SERVER['HTTP_ACCEPT'])) {
        // 如果只支持wml并且不支持html那一定是移动设备
        // 如果支持wml和html但是wml在html之前则是移动设备
        if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
            return true;
        }
    }
    return false;
}

/**
 * [getpage 基础分页的相同代码封装，使前台的代码更少]
 * @method   getpage
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-21T13:55:51+0800
 * @param    [type]                   &$m       [模型，引用传递]
 * @param    [type]                   $where    [查询条件]
 * @param    integer                  $pagesize [每页查询条数]
 * @return   [type]                             [\Think\Page]
 */
function getpage(&$m, $where, $pagesize = 10) {
    $m1 = clone $m; //浅复制一个模型
    $count = $m->where($where)->count(); //连惯操作后会对join等操作进行重置
    $m = $m1; //为保持在为定的连惯操作，浅复制一个模型
    $p = new Think\Page($count, $pagesize);
    $p->lastSuffix = false;
    $p->setConfig('header', '<span>共<b>%TOTAL_ROW%</b>条记录   第<b>%NOW_PAGE%</b>页/共<b>%TOTAL_PAGE%</b>页</span>');
    $p->setConfig('prev', '上一页');
    $p->setConfig('next', '下一页');
    $p->setConfig('last', '末页');
    $p->setConfig('first', '首页');
    // $p->setConfig('theme', '%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%');
    $p->setConfig('theme','%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%');
    $p->parameter = I('get.');
    $m->limit($p->firstRow, $p->listRows);
    return $p;
}

/**
 * [p 格式化打印数组]
 * @method   p
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-21T13:57:55+0800
 * @param    [type]                   $array [需要打印的数组]
 * @param    [type]                   $s     [description]
 * @return   [type]                          [格式化后的数组]
 */
function p($array, $s = null) {
    dump($array, 1, '<pre>', $s);
}



/**
 * [get_ip 获得用户的IP地址]
 * @method   get_ip
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-21T14:08:51+0800
 * @return   [type]                   [description]
 */
function get_ip(){
    return get_client_ip();
}



/**
 * [nickname 验证用户昵称]
 * @method   nickname
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-21T14:17:36+0800
 * @param    [type]                   $nickname [description]
 * @return   [type]                             [description]
 */
function nickname($nickname){
    header('Content-type:text/html; charset=utf-8');
    // 正则匹配是否全是中文
    if(preg_match('/^[\x{4e00}-\x{9fa5}]+$/u', $nickname)<=0)
        return false;
    // 拆分中文，判断长度
    $count = 0;        
    for($i = 0; $i < strlen($nickname); $i++){        
       $value = ord($nickname[$i]);        
       if($value > 127) {        
           $count++;        
           if($value >= 192 && $value <= 223) $i++;        
           elseif($value >= 224 && $value <= 239) $i = $i + 2;        
           elseif($value >= 240 && $value <= 247) $i = $i + 3;        
           else return false;       
       }        
       $count++;        
   }
   if($count>8||$count<4)     
    return false;

    //是否被占用
if(M('Admin')->where(array('nickname'=>$nickname))->field('nickname')->find())
    return false;
    // 敏感词监测
$word=C('NICK_NAME');
foreach($word as $item){
    if(strpos($nickname, $item)!==false){
        return false;
    }
}
return true;
}

/**
 * [truename 验证真实姓名]
 * @method   truename
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-22T09:32:20+0800
 * @param    [type]                   $truename [description]
 * @return   [type]                             [description]
 */
function truename($truename){
    header('Content-type:text/html; charset=utf-8');
    // 正则匹配是否全是中文
    if(preg_match('/^[\x{4e00}-\x{9fa5}]+$/u', $truename)<=0)
        return false;
    // 拆分中文，判断长度
    $count = 0;        
    for($i = 0; $i < strlen($truename); $i++){ 
        $value = ord($truename[$i]);
        if($value > 127) {
            $count++;
            if($value >= 192 && $value <= 223){
                $i++;
            }elseif($value >= 224 && $value <= 239){
                $i = $i + 2;
            }elseif($value >= 240 && $value <= 247){
                $i = $i + 3;
            }else{
                return false; 
            }
        }
        $count++; 
    }
    if($count>10||$count<4)
        return false;
    return true;
}

/**
 * [xuanchuan 验证宣传人是否存在]
 * @method   xuanchuan
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-22T08:51:49+0800
 * @param    [type]                   $xuanchuan [description]
 * @return   [type]                              [description]
 */
function xuanchuan($xuanchuan){
    if(M('admin')->where(array('nickname'=>$xuanchuan,'job'=>array('in','1,3,6,7')))->field('nickname')->find()){
        return true;
    }else{
        return false;
    }
}

/**
 * [makecard 生成唯一code]
 * @method   makecard
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-21T15:43:10+0800
 * @return   [type]                   [description]
 */
function makecard($count){
    for ($i=0; $i <$count ; $i++) { 
        $card=sprintf('%04X%04X%04X%04X%04X%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
        $arr[]=array('card'=>$card);
    }
    // 写入数据库
    if(!M('card')->addAll($arr))
        die('生成唯一code失败，请咨询QQ：233713821');
    return $arr;
}

function makecard_new($count,$type=''){
    if($type&&$type!=NULL){
        $table='card_jp';
        $txtname='jp_';
    }else{
        $table='card_pt';
        $txtname='pt_';
    }
    $txt='';
    $arr=array();
    for ($i=0; $i <$count ; $i++) { 
        $card=sprintf('%04X%04X%04X%04X%04X%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
        $txt.=$card."\r\n";
        $arr[]=array('card'=>$card);
    }
    $k=M($table)->max('id');
    $k=$k+1;
    $w=$k+$count-1;
    // 写入数据库
    if(!M($table)->addAll($arr))
        die('生成唯一code失败，请咨询QQ：233713821');
    $path='./Public/card/';
    // return $path;
    $fname=$txtname.date("YmdHi").'_'.$k.'-'.$w.'_'.$count.'.txt';
    if(save($txt,$path,$fname)){
        return $fname;
    }
}

// 保存文件函数
function save($content,$path,$fname){
        // 监测目录是否存在，不存在就创建
    if (!is_dir($path)){  
        if(!mkdir($path,0755,true)){
            exit('<p class="err">创建目录失败!</p>');
        }
    }

    $fp2=fopen($path.$fname,"w+");
    if(false===$fp2) exit('<p class="err">打开文件失败!</p>');
    if(false===fwrite($fp2,$content)) exit('<p class="err">写入文件失败!</p>');
    if(false===fclose($fp2)) exit('<p class="err">关闭文件失败!</p>');
    return true;
}

/**
 * [record 记录每日填表、审核、升初级、升高级数量]
 * @method   record
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-23T15:50:16+0800
 * @param    [type]                   $type [description]
 * @return   [type]                         [description]
 */
function record($type){
    M('count')->add(array('type'=>$type,'time'=>time()));
}

/** 
* @param string $string 原文或者密文 
* @param string $operation 操作(ENCODE | DECODE), 默认为 DECODE 
* @param string $key 密钥 
* @param int $expiry 密文有效期, 加密时候有效， 单位 秒，0 为永久有效 
* @return string 处理后的 原文或者 经过 base64_encode 处理后的密文 
* 
* @example 
* 
* $a = authcode('abc', 'ENCODE', 'key'); 
* $b = authcode($a, 'DECODE', 'key'); // $b(abc) 
* 
* $a = authcode('abc', 'ENCODE', 'key', 3600); 
* $b = authcode('abc', 'DECODE', 'key'); // 在一个小时内，$b(abc)，否则 $b 为空 
*/ 
function makerec($string, $operation = 'DECODE', $key = '', $expiry = 7200) { 
    $ckey_length = 4;
// 随机密钥长度 取值 0-32; 
// 加入随机密钥，可以令密文无任何规律，即便是原文和密钥完全相同，加密结果也会每次不同，增大破解难度。 
// 取值越大，密文变动规律越大，密文变化 = 16 的 $ckey_length 次方 
// 当此值为 0 时，则不产生随机密钥 
    $key = md5($key ? $key : EABAX::getAppInf('KEY')); 
    $keya = md5(substr($key, 0, 16)); 
    $keyb = md5(substr($key, 16, 16)); 
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : ''; 
    $cryptkey = $keya.md5($keya.$keyc); 
    $key_length = strlen($cryptkey); 
    $string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string; 
    $string_length = strlen($string); 
    $result = ''; 
    $box = range(0, 255); 
    $rndkey = array(); 
    for($i = 0; $i <= 255; $i++) { 
        $rndkey[$i] = ord($cryptkey[$i % $key_length]); 
    } 
    for($j = $i = 0; $i < 256; $i++) { 
        $j = ($j + $box[$i] + $rndkey[$i]) % 256; 
        $tmp = $box[$i]; 
        $box[$i] = $box[$j]; 
        $box[$j] = $tmp; 
    } 
    for($a = $j = $i = 0; $i < $string_length; $i++) { 
        $a = ($a + 1) % 256; 
        $j = ($j + $box[$a]) % 256; 
        $tmp = $box[$a]; 
        $box[$a] = $box[$j]; 
        $box[$j] = $tmp; 
       // $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
 $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 4]));	   
    }
	
    if($operation == 'DECODE') { 
        if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) { 
            return substr($result, 26); 
        } else { 
            return ''; 
        } 
    } else {
        return $keyc.str_replace('=', '', base64_encode($result)); 
    } 
} 

/**
 * [makekey 设置过期页面]
 * @method   makekey
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-23T17:27:30+0800
 * @param    [type]                   $rec [推荐人]
 * @param    [type]                   $opt [是否解密]
 * @return   [type]                        [description]
 */
function makekey($rec,$opt=''){
    if($opt){
        if($rec=="amen") return '内部业务员';
        return makerec($rec,$operation = 'DECODE', $key = C('KEY'));
    }else{
        $code=makerec($rec,$operation = 'ENCODE', $key = C('KEY'), C('KEY_TIME'));
        $code=str_replace ('+','%2B',$code);
        $code=str_replace ('/','%2F',$code);
        $code=str_replace ('?','%3F',$code);
        $code=str_replace ('%','%25',$code);
        $code=str_replace ('#','%23',$code);
        $code=str_replace ('&','%26',$code);
        $code=str_replace ('=','%3D',$code);
        return "?key=".$code;
    }
}

/**
 * [checked 选中判断]
 * @method   checked
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-23T20:43:54+0800
 * @param    [type]                   $v [description]
 * @param    [type]                   $n [description]
 * @return   [type]                      [description]
 */
function checked($v,$n){
    if($v==$n)
        return 'selected = "selected"';
}

/**
 * [check_verify description]
 * @method   check_verify
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-24T10:12:54+0800
 * @param    [type]                   $code [description]
 * @param    string                   $id   [description]
 * @return   [type]                         [description]
 */
function check_verify($code, $id = ""){  
    $verify = new \Think\Verify();  
    return $verify->check($code, $id);  
}  

/**
 * [wlog 生成日志]
 * @method   wlog
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-24T11:20:05+0800
 * @param    [type]                   $node [description]
 * @param    string                   $uid  [description]
 * @param    string                   $name [description]
 * @return   [type]                         [description]
 */
function wlog($note,$uid='',$name=''){
    $uid=empty($uid) ? session('admin.id'): $uid ;
    $name=empty($name) ? session('admin.nickname') : $name;
    $add=array(
        'uid'=>$uid,
        'name'=>$name,
        'note'=>$note,
        'ip'=>get_ip(),
        'time'=>time()
        );
    M('admin_logs')->add($add);
}

/**
 * [gold 金币换算]
 * @method   gold
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-24T15:19:43+0800
 * @param    [type]                   $gold [description]
 * @param    string                   $opt  [description]
 * @return   [type]                         [description]
 */
function gold($gold,$opt=''){
	if(!$gold)
		return 0;
    if($opt)
        return intval(mb_substr($gold, 0, mb_strlen($gold) - 2));
    return mb_substr($gold, 0, mb_strlen($gold) - 2)."<s>".substr($gold,-2)."</s>";
}

function howgold($gold,$opt=''){
    if($gold<10000){
        if($opt){
            return '';
        }else{return 'disabled="disabled"';}
        
    }else{
        if($opt){
            return '提现金额：';
        }else{
            return '';
        }
    }
    
}

function cash($gold){
    $g=M('admin')->where(array('id'=>session('user.id')))->field('gold')->find();
    if($g['gold']>=$gold){
        return true;
    }else{
        return false;
    }
}
/**
 * [usertype description]
 * @method   usertype
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-27T10:49:52+0800
 * @param    [type]                   $type [description]
 * @param    string                   $opt  [description]
 * @return   [type]                         [description]
 */
function usertype($type,$opt=''){
    if(is_numeric($type) === false) {    
        return '宕机或超时，没有返回值';   
    }
    switch ($type) {
        // case '-1':
        // $r="未通过";
        // break;
        case '0':
        $r="未认证";
        break;
        case '1':
        $r="初级会员";
        break;
        case '2':
        $r="vip";
        break;
        default:
        $r='宕机或超时，类型错误';
        break;
    }
    return $r;
}


function btzd($s){
    $r=M('admin_group')->where(array('id'=>$s))->find();
    if($r){
        return $r['gname'];
    }else{
        return '-';
    }
    
}

function job($s){
    $r=M('auth_group')->where(array('id'=>$s))->field('title')->find();
    if($r){
        return $r['title'];
    }else{
        return '-';
    }
    
}


function by($uid,$nickname){
    if(in_array($uid,C('SUPER_ADMIN'))){
        return 'Admin';
    }else{
        return $nickname;
    }
}

function select($a,$b){
    if($a==$b){
        return 'selected="selected"';
    }
}
/**
 * [gzbz 工资标准]
 * @method   gzbz
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-28T15:43:41+0800
 * @param    [type]                   $type [description]
 * @param    [type]                   $job  [description]
 * @return   [type]                         [description]
 */
function gzbz($type,$job){
    if(is_numeric($type) === false) {    
        exit('发生错误,请稍后再试');   
    }
    switch ($type) {
        case "0":
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,xwage')->find();
        return $wage['xwage'];
        case '1'://普通
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,cwage')->find();
        return $wage['cwage'];
        break;
        case '2'://高级
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,pwage')->find();
        return $wage['pwage'];
        break;
        default:
        exit('发生错误！未找到默认的会员级别');
        break;
    }
}

function wxgzbz($type,$js){
    $job=7;
    if(is_numeric($type) === false) {    
        exit('发生错误,请稍后再试');   
    }
    switch ($type) {
        case '0':
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,xwage')->find();
        $bz=$wage['xwage'];
        case '1'://普通
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,cwage')->find();
        $bz=$wage['cwage'];
        break;
        case '2'://高级
        $wage=M('auth_group')->where(array('id'=>$job))->field('id,pwage')->find();
        $bz=$wage['pwage'];
        break;
        default:
        return 0;
        break;
    }
    if($js>5&&$js<=15){
        return $bz+500;
    }elseif($js>15){
        return $bz+1000;
    }else{
        return $bz;
    }
}

/**
 * [waixuanjs description]
 * @method   waixuanjs
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-07-13T12:09:54+0800
 * @param    [type]                   $uid [description]
 * @param    string                   $get [description]
 * @return   [type]                        [description]
 */
function tuijianjs($uid,$get=''){
    $time=time();
    $ytime=strtotime(date('Y-m-d', $time));
    if($get){
        $f=M('tuijianjs')->where(array('uid'=>$uid))->find();
        if(!$f){
            M('tuijianjs')->add(array('uid'=>$uid,'js'=>0,'time'=>$time)); 
            return 0;
        }
        if($f['time']<=$ytime){
            M('tuijianjs')->where(array('uid'=>$uid))->save(array('js'=>0,'time'=>time()));
            return 0;
        }
        return $f['js'];
    }else{
        $f=M('tuijianjs')->where(array('uid'=>$uid))->find();
        if(!$f){
            $f=M('tuijianjs')->add(array('uid'=>$uid,'js'=>1,'time'=>$time));
        }else{
            if($f['time']<=$ytime){
                M('tuijianjs')->where(array('uid'=>$uid))->save(array('js'=>1,'time'=>$time));
            }else{
                M('tuijianjs')->where(array('uid'=>$uid))->save(array('js'=>$f['js']+1,'time'=>$time));
            }
        }
    }
}

/**
 * [amen_day_js description]
 * @method   amen_day_js
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-07-13T12:24:27+0800
 * @param    [type]                   $uid   [用户ID]
 * @param    [type]                   $table [表名:waixuanjs,jiedaijs,peixunjs]
 * @param    string                   $get   [获取还是更新]
 * @return   [type]                          [description]
 */
function amen_day_js($uid,$table,$get=''){
    $time=time();
    $ytime=strtotime(date('Y-m-d', $time));
    if($get){
        $f=M($table)->where(array('uid'=>$uid))->find();
        if(!$f){
            M($table)->add(array('uid'=>$uid,'js'=>0,'time'=>$time)); 
            return 0;
        }
        if($f['time']<=$ytime){
            M($table)->where(array('uid'=>$uid))->save(array('js'=>0,'time'=>time()));
            return 0;
        }
        return $f['js'];
    }else{
        $f=M($table)->where(array('uid'=>$uid))->find();
        if(!$f){
            $f=M($table)->add(array('uid'=>$uid,'js'=>1,'time'=>$time));
        }else{
            if($f['time']<=$ytime){
                M($table)->where(array('uid'=>$uid))->save(array('js'=>1,'time'=>$time));
            }else{
                M($table)->where(array('uid'=>$uid))->save(array('js'=>$f['js']+1,'time'=>$time));
            }
        }
    }
}

/**
 * [savewage 保存工资]
 * @method   savewage
 * @Author   Amen[233713821@qq.com]
 * @DateTime 2016-05-28T16:36:35+0800
 * @param    [type]                   $id   [description]
 * @param    [type]                   $wage [description]
 * @return   [type]                         [description]
 */
function savewage($id,$wage,$note='',$save=''){
    // 更新数据库
    if($wage<1){
        exit('请稍等！工资还为设置');
    }
    M('admin')->where(array('id'=>$id))->setInc('gold',$wage);
    if($note){
        // 更新日志
        M('admin_goldlogs')->add(array('uid'=>$id,'type'=>1,'note'=>$note,'time'=>time()));
    }
    if($save){
        // 更新推荐接待培训
        M('admin')->where(array('id'=>$id))->setInc($save,1);
    }
}



function state($state){
    $r='-';
    switch ($state) {
        case 0:
        $r='<span stype="color:red">封禁</span>';
        break;
        case 1:
        $r="正常";
        break;
        default:
        break;
    }
    return $r;
}

function geshihua($s){
    if($s){
        return $s;
    }else{
        return "-";
    }
}


function mytime($time,$t=''){
    if($time){
        if($t){
            return date("Y-m-d",$time);
        }else{
            return date("Y-m-d H:i:s",$time);
        }
    }else{
        return "-";
    }
}

function mytime2($time){
    if($time){
        return date("Y-m-d H:i",$time);
    }else{
        return "-";
    }
}

function sex($sex){
    if($sex){
        return "男";
    }else{
        return "女";
    }
}

function edu($edu){
    if(is_numeric($edu) === false) {    
        return '宕机或超时，没有返回值';   
    }
    switch ($edu) {
        case '0':
        $r="初中";
        break;
        case '1':
        $r="高中/中专";
        break;
        case '2':
        $r="大专";
        break;
        case '3':
        $r="本科及以上";
        break;
        default:
        $r='宕机或超时，类型错误';
        break;
    }
    return $r;
}


function getauth($session=array(),$edit=''){
    $job['bumen']=M('admin_group')->where(array('id'=>$session['bumen']))->select();
    $job['tuandui']=M('admin_group')->where(array('id'=>$session['tuandui']))->select();
	
	
        // 根据职位获得小组小队
    switch ($session['job']) {
            case '1'://前厅团长
            $job['xiaozu']=M('admin_group')->where(array('id'=>array('in',$job['tuandui']['0']['auth'])))->select();
            $a=array();
            foreach ($job['xiaozu'] as $k => $v) {
                if($v['auth']){
                    $a.=$v['auth'];
                }
            }
            if(!$a) die(C('MSG'));
            $job['xiaodui']=M('admin_group')->where(array('id'=>array('in',$a)))->select();
            if($edit){
                $job['job']=M('auth_group')->where(array('id'=>array('in',"3,4,6,7,8")))->select();
            }else{$job['job']=M('auth_group')->where(array('id'=>array('in',"7,8")))->select();}
            break;
            case '2'://后勤团长
            $job['xiaozu']=M('admin_group')->where(array('id'=>array('in',$job['tuandui']['0']['auth'])))->select();
            
            $job['xiaodui']='';
            if($edit){
                $job['job']=M('auth_group')->where(array('id'=>array('in',"5,9")))->select();
            }else{$job['job']=M('auth_group')->where(array('id'=>9))->select();}
            break;
            case '3'://业务员主管
            $job['xiaozu']=M('admin_group')->where(array('id'=>$session['xiaozu']))->select();
            $job['xiaodui']=M('admin_group')->where(array('id'=>array('in',$job['xiaozu']['0']['auth'])))->select();
            if($edit){
                $job['job']=M('auth_group')->where(array('id'=>array('in',"6,7")))->select();
            }else{$job['job']=M('auth_group')->where(array('id'=>7))->select();}
            break;
            case '4'://接待主管
            case '8'://接待
            $job['xiaozu']=M('admin_group')->where(array('id'=>$session['xiaozu']))->select();
            $job['xiaodui']='';
            $job['job']=M('auth_group')->where(array('id'=>array('in',"8")))->select();
            case '5'://培训主管
            case '9'://培训
            $job['xiaozu']=M('admin_group')->where(array('id'=>$session['xiaozu']))->select();
            $job['xiaodui']='';
            $job['job']=M('auth_group')->where(array('id'=>array('in',"9")))->select();
            break;
            case '6'://业务员队长
            case '7'://业务员
            $job['xiaozu']=M('admin_group')->where(array('id'=>$session['xiaozu']))->select();
            $job['xiaodui']=M('admin_group')->where(array('id'=>$session['xiaodui']))->select();
            $job['job']=M('auth_group')->where(array('id'=>array('in',"7")))->select();
            break;
            case '10':
            $job['xiaozu']=M('admin_group')->where(array('id'=>array('in',$job['tuandui']['0']['auth'])))->select();
            $job['xiaodui']='';
            $job['job']=M('auth_group')->where(array('id'=>array('in','11,12')))->select();
            break;
            case '11':
            case '12':
            $job['xiaozu']=M('admin_group')->where(array('id'=>$session['xiaozu']))->select();
            $job['xiaodui']='';
            $job['job']=M('auth_group')->where(array('id'=>array('in',"12")))->select();
            break;
            default:
            break;
        }
        return $job;
    }

    function cashshenhe($shenhe){
        if($shenhe){
            return '已审核';
        }else{
            return '未审核';
        }
    }

    function cashchuli($shenhe){
        if($shenhe){
            return '已支付';
        }else{
            return '未支付';
        }
    }
    function shenhe($shenhe,$id){
        if($shenhe!=NULL){
            return "<span style='color:green'>已通过</span>";
        }else{
            $url=U('index/rhsh',array('id'=>$id));
            $href="javascript:confirmurl('".$url."','确认吗?通过后,该用户在未认证的情况下可以入组,初级会员和vip不受影响')";
            return '<a title="点击给予审核通过" href="'.$href.'">默认</a>';

        }
    }
    function year($year){
        return intval(date("Y")-$year);
    }
    function shiming($shiming){
        if($shiming==1){
            return '<span style="color:red">待审核</span>';
        }elseif($shiming==2){
           return '<span style="color:green">已通过</span>'; 
       }else{
        return '未提交';
    }
}

function createTree($array,$parentid=0){
    $result = array();
    foreach($array as $key => $val){
        if($val['pid'] == $parentid) {
            $tmp = $array[$key];unset($array[$key]);
            count(createTree($array,$val['id'])) > 0 && $tmp['children'] = createTree($array,$val['id']);
            $result[$key] = $tmp;
        }
    }
    return $result;
}
function amen_get_zs($id,$tzd,$map){
    $nick=M('admin')->where(array($tzd=>$id))->field('nickname')->select();
    $nickname=i_array_column($nick, 'nickname');
    $where[$map]=array('in',$nickname);
    $ztj=M('admin')->where($where)->count();
    return $ztj;
}
function amen_get_grzs($id,$map){
    $nick=M('admin')->where(array('id'=>$id))->field('nickname')->find();
    $where[$map]=$nick['nickname'];
    $ztj=M('admin')->where($where)->count();
    return $ztj;
}
function amen_get_grtzs($id,$map){
    $nick=M('admin')->where(array('id'=>$id))->field('nickname')->find();
    $where[$map]=$nick['nickname'];
    switch ($map) {
        case 'tuijian':
        $where['zctime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        case 'jiedai':
        $where['jhtime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        case 'peixun':
        $where['sjtime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        default:
        break;
    }
    $ztj=M('admin')->where($where)->count();
    return $ztj;
}
function amen_get_tzs($id,$tzd,$map,$level){
    $nick=M('admin')->where(array($tzd=>$id))->field('nickname')->select();
    $nickname=i_array_column($nick, 'nickname');
    $where[$map]=array('in',$nickname);
    switch ($map) {
        case 'tuijian':
        $where['zctime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        case 'jiedai':
        $where['jhtime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        case 'peixun':
        $where['sjtime']=array('EGT',strtotime(date('Y-m-d', time())));
        break;
        default:
        break;
    }
    if ($level)
    {
        $where['type']=array('EQ',$level);
    }
    $ztj=M('admin')->where($where)->count();
    return $ztj;
}
function tztj($id){
    $q=M('admin')->where(array('tuandui'=>$id,'job'=>1))->find();
    $h=M('admin')->where(array('tuandui'=>$id,'job'=>2))->find();
    $j=M('admin')->where(array('tuandui'=>$id,'job'=>10))->find();
    if($q){
        return '<span style="color:green">团长：'.$q['nickname'].'</span> <span style="color:red">总业绩 推广：'.amen_get_zs($id,'tuandui','tuijian').' | 今日业绩 推广：'.amen_get_tzs($id,'tuandui','tuijian').'</span>';
    }elseif($h){
        return '<span style="color:green">团长：'.$h['nickname'].'</span> <span style="color:red">总业绩 普通：'.amen_get_zs($id,'tuandui','jiedai').' | 今日业绩 普通：'.amen_get_tzs($id,'tuandui','jiedai').'</span>';
    }elseif($j){
        return '<span style="color:green">团长：'.$j['nickname'].'</span> <span style="color:red"> 总业绩 高级：'.amen_get_zs($id,'tuandui','peixun').' | 今日业绩 高级：'.amen_get_tzs($id,'tuandui','peixun').'</span>';
    }else{
        return '<span style="color:red">未设置团长</span>';
    }
}

function xztj($id){
    $waixuan=M('admin')->where(array('xiaozu'=>$id,'job'=>3))->find();
    $jiedai=M('admin')->where(array('xiaozu'=>$id,'job'=>4))->find();
    $peixun=M('admin')->where(array('xiaozu'=>$id,'job'=>5))->find();
    if($waixuan){
        return '<span style="color:green">主管：'.$waixuan['nickname'].'</span> <span style="color:red">总业绩 推广：'.amen_get_zs($id,'xiaozu','tuijian').' | 今日业绩 推广:'.amen_get_tzs($id,'xiaozu','tuijian').'</span>';
    }elseif($jiedai){
        return '<span style="color:green">主管：'.$jiedai['nickname'].'</span>  <span style="color:red">总业绩 普通：'.amen_get_zs($id,'xiaozu','jiedai').' | 今日业绩 普通:'.amen_get_tzs($id,'xiaozu','jiedai').'</span>';
    }elseif($peixun){
        return '<span style="color:green">主管：'.$peixun['nickname'].'</span>  <span style="color:red">总业绩 高级：'.amen_get_zs($id,'xiaozu','peixun').' | 今日业绩 高级:'.amen_get_tzs($id,'xiaozu','peixun').'</span>';
    }else{
        return '<span style="color:red">未设置主管</span>';
    }
}

function xdtj($id){
    $s=M('admin')->where(array('xiaodui'=>$id,'job'=>6))->find();
    if($s){
        return '<span style="color:green">队长：'.$s['nickname'].'</span>  <span style="color:red">总业绩 推广：'.amen_get_zs($id,'xiaodui','tuijian').'| 今日业绩 推广:'.amen_get_tzs($id,'xiaodui','tuijian')."</span>";
    }else{
        return '<span style="color:red">未设置队长</span>';
    }
}
function tzlist($id,$s=''){
    if($s==NULL){
        $s='index';
    }
    $q=M('admin')->where(array('tuandui'=>$id,'job'=>1))->find();
    $h=M('admin')->where(array('tuandui'=>$id,'job'=>2))->find();
    $j=M('admin')->where(array('tuandui'=>$id,'job'=>10))->find();
    if($q){
        $tsee=U($s.'/seetuijian',array('id'=>$q['id'],'type'=>'all'));
        $tseet=U($s.'/seetuijian',array('id'=>$q['id'],'type'=>'today'));
        $tseeg=U($s.'/seetuijian',array('id'=>$q['id'],'type'=>'todayg'));
        $jsee=U($s.'/seejiedai',array('id'=>$q['id'],'type'=>'all'));
        $jseet=U($s.'/seejiedai',array('id'=>$q['id'],'type'=>'today'));
        return '<span style="color:red">总业绩 推广:<a href="'.$tsee.'">'.amen_get_zs($id,'tuandui','tuijian').'</a> | 今日业绩 推广: <a href="'.$tseet.'">'.amen_get_tzs($id,'tuandui','tuijian').'</a> | 今日高级: <a href="'.$tseeg.'">'.amen_get_tzs($id,'tuandui','tuijian').'</a></span>';
    }elseif($h){
        $psee=U($s.'/seepeixun',array('id'=>$h['id'],'type'=>'all'));
        $pseet=U($s.'/seepeixun',array('id'=>$h['id'],'type'=>'today'));
        return '<span style="color:red">总业绩 普通: <a href="'.$psee.'">'.amen_get_zs($id,'tuandui','jiedai').'</a> | 今日业绩 普通: <a href="'.$pseet.'">'.amen_get_tzs($id,'tuandui','jiedai').'</a></span>';
    }elseif($j){
        $jsee=U($s.'/seejipin',array('id'=>$j['id'],'type'=>'all'));
        $jseet=U($s.'/seejipin',array('id'=>$j['id'],'type'=>'today'));
        return '<span style="color:red"> 总业绩 高级: <a href="'.$jsee.'">'.amen_get_zs($id,'tuandui','peixun').'</a> | 今日业绩 高级: <a href="'.$jseet.'">'.amen_get_tzs($id,'tuandui','peixun').'</a></span>';
    }else{
        return '<span style="color:red">未设置团长</span>';
    }
}
function xzlist($id,$s=''){
    if($s==NULL){
        $s='index';
    }
    $waixuan=M('admin')->where(array('xiaozu'=>$id,'job'=>3))->find();
    $jiedai=M('admin')->where(array('xiaozu'=>$id,'job'=>4))->find();
    $peixun=M('admin')->where(array('xiaozu'=>$id,'job'=>5))->find();
    if($waixuan){
        $see=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'all'));
        $seet=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'today'));
        $seeg=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'todayg'));
        return '<span style="color:red">总业绩 推广: <a href="'.$see.'">'.amen_get_zs($id,'xiaozu','tuijian').'</a> | 今日业绩 推广: <a href="'.$seet.'">'.amen_get_tzs($id,'xiaozu','tuijian').'</a> | 今日高级: <a href="'.$seeg.'">'.amen_get_tzs($id,'xiaozu','tuijian','2').'</a></span>';
    }elseif($jiedai){
        $see=U($s.'/seejiedai',array('id'=>$jiedai['id'],'type'=>'all'));
        $seet=U($s.'/seejiedai',array('id'=>$jiedai['id'],'type'=>'today'));
        return '<span style="color:red">总业绩 普通：<a href="'.$see.'">'.amen_get_zs($id,'xiaozu','jiedai').'</a> | 今日业绩 普通: <a href="'.$seet.'">'.amen_get_tzs($id,'xiaozu','jiedai').'</a></span>';
    }elseif($peixun){
        $see=U($s.'/seepeixun',array('id'=>$peixun['id'],'type'=>'all'));
        $seet=U($s.'/seepeixun',array('id'=>$peixun['id'],'type'=>'today'));
        return '<span style="color:red">总业绩 高级:<a href="'.$see.'">'.amen_get_zs($id,'xiaozu','peixun').'</a> | 今日业绩 高级:<a href="'.$see.'">'.amen_get_tzs($id,'xiaozu','peixun').'</a></span>';
    }else{
        return '<span style="color:red">未能正确统计</span>';
    }
}

function xdlist($id,$s=''){
    if($s==NULL){
        $s='index';
    }
    $waixuan=M('admin')->where(array('xiaodui'=>$id,'job'=>6))->find();
    if($waixuan){
        $see=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'all'));
        $seet=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'today'));
        $seeg=U($s.'/seetuijian',array('id'=>$waixuan['id'],'type'=>'todayg'));
        return '<span style="color:red">总业绩 推广: <a href="'.$see.'">'.amen_get_zs($id,'xiaodui','tuijian').'</a> | 今日业绩 推广: <a href="'.$seet.'">'.amen_get_tzs($id,'xiaodui','tuijian').'</a> | 今日高级: <a href="'.$seeg.'">'.amen_get_tzs($id,'xiaodui','tuijian','2').'</a></span>';
    }else{
        return '<span style="color:red">未能正确统计</span>';
    }
}

function grtuijian($uid,$s=''){
    if($s==NULL){
        $s='index';
    }
    $f=M('admin')->where(array('id'=>$uid))->find();
    if($f){
        switch ($f['job']) {
            case '7':
            $see=U($s.'/seetuijian',array('id'=>$uid,'type'=>'all'));
            $seet=U($s.'/seetuijian',array('id'=>$uid,'type'=>'today'));
            $zs=amen_get_grzs($uid,'tuijian');
            $tzs=amen_get_grtzs($uid,'tuijian');
            $n="推广:";
            break;
            case '8':
            $see=U($s.'/seejiedai',array('id'=>$uid,'type'=>'all'));
            $seet=U($s.'/seejiedai',array('id'=>$uid,'type'=>'today'));
            $zs=amen_get_grzs($uid,'jiedai');
            $tzs=amen_get_grtzs($uid,'jiedai');
            $n="普通指导:";
            break;
            case '9':
            $see=U($s.'/seepeixun',array('id'=>$uid,'type'=>'all'));
            $seet=U($s.'/seepeixun',array('id'=>$uid,'type'=>'today'));
            $zs=amen_get_grzs($uid,'peixun');
            $tzs=amen_get_grtzs($uid,'peixun');
            $n="高级指导:";
            break;
            default:
            exit('统计时发生错误');
            break;
        }
        return '<span style="color:red">总业绩 '.$n.' <a href="'.$see.'">'.$zs.'</a> | 今日业绩 '.$n.' <a href="'.$seet.'">'.$tzs.'</a></span>';
    }else{
        return '<span style="color:red">未找到此人</span>';
    }
}



function i_array_column($input, $columnKey, $indexKey=null){
    if(!function_exists('array_column')){ 
        $columnKeyIsNumber  = (is_numeric($columnKey))?true:false; 
        $indexKeyIsNull            = (is_null($indexKey))?true :false; 
        $indexKeyIsNumber     = (is_numeric($indexKey))?true:false; 
        $result                         = array(); 
        foreach((array)$input as $key=>$row){ 
            if($columnKeyIsNumber){ 
                $tmp= array_slice($row, $columnKey, 1); 
                $tmp= (is_array($tmp) && !empty($tmp))?current($tmp):null; 
            }else{ 
                $tmp= isset($row[$columnKey])?$row[$columnKey]:null; 
            } 
            if(!$indexKeyIsNull){ 
                if($indexKeyIsNumber){ 
                  $key = array_slice($row, $indexKey, 1); 
                  $key = (is_array($key) && !empty($key))?current($key):null; 
                  $key = is_null($key)?0:$key; 
              }else{ 
                  $key = isset($row[$indexKey])?$row[$indexKey]:0; 
              } 
          } 
          $result[$key] = $tmp; 
      } 
      return $result; 
  }else{
    return array_column($input, $columnKey, $indexKey);
}
}


function zengjiaxiaodui($gname){
    if(strstr($gname,'推广')){
        return 1;
    }else{
        return 0;
    }
}

function yuji($cash,$opt=''){
    $job=session('user.job');
    $cash=$cash/100;
    if(!$job)
        return '计算失败(无职务)';
    $d=date('d');
    if($job==7){
        $b=$cash;
        $j= '职务业务员无手续费无管理费(预计到账:'.$b."元)";
    }elseif($d==15||$d==28){
        $b=$cash*0.9;
        $j= '提现日 扣除管理费(预计到账:'.$b."元)";
    }else{
        $b=$cash*0.8;
        $j= '非提现日 扣除管理费 手续费(预计到账:'.$b.'元)';
    }
    if($opt){
        return $b;
    }else{
        return $j;
    }
}
function shouxu($cash){
    $job=session('user.job');
    if(!$job) exit('发生错误，未找到职务');
    $d=date('d');
    if($job==7||$d==15||$d==28){
        return 0;
    }else{
        return $cash*0.1;
    }
}

function isok($data=array()){
    if($data['job']){
        switch ($data['job']) {
            case '1'://前厅团长
            if($data['bumen']!=1)
                return '推广团长必须隶属于推广';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'推广'))
                return '你选择的团队似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改团队名称';
            if($tuandui['pid']!=$data['bumen'])
                return '团队和部门不匹配';
            if(M('admin')->where(array('tuandui'=>$data['tuandui'],'job'=>1))->field('id')->find())
                return '此团队已经有团长了，请先撤销原团长职务';
            if($data['xiaozu']!=0||$data['xiaodui']!=0)
                return '团长职务不需要指定小组或小队';
            break;
            case '2':
            if($data['bumen']!=2)
                return '普通指导团长必须隶属于普通指导';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'普通指导'))
                return '你选择的团队似乎是错误的(没有包含“普通指导”)，如果确认无误，请联系管理员修改团队名称';
            if($tuandui['pid']!=$data['bumen'])
                return '团队和部门不匹配';
            if(M('admin')->where(array('tuandui'=>$data['tuandui'],'job'=>2))->field('id')->find())
                return '此团队已经有团长了，请先撤销原团长职务';
            if($data['xiaozu']!=0||$data['xiaodui']!=0)
                return '团长职务不需要指定小组或小队';
            break;
            case '3':
            if($data['bumen']!=1)
                return '推广主管必须隶属于推广';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'推广'))
                return '你选择的团队似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改团队名称';
            if($tuandui['pid']!=$data['bumen'])
                return '团队和部门不匹配';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'推广'))
                return '你选择的小组似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if(M('admin')->where(array('xiaozu'=>$data['xiaozu'],'job'=>3))->field('id')->find())
                return '此小组已经有推广主管了，请先撤销原主管职务';
            if($data['xiaodui']!=0)
                return '推广主管职务不需要指定小队';
            break;
            case '4':
            if($data['bumen']!=2)
                return '普通指导主管必须隶属于普通指导';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'普通指导'))
                return '你选择的团队似乎是错误的(没有包含“普通指导”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'普通指导'))
                return '你选择的小组似乎是错误的(没有包含“普通指导”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if(M('admin')->where(array('xiaozu'=>$data['xiaozu'],'job'=>4))->field('id')->find())
                return '此小组已经有普通指导主管了，请先撤销原主管职务';
            if($data['xiaodui']!=0)
                return '普通指导主管职务不需要指定小队';
            break;
            case '5':
            if($data['bumen']!=11)
                return '高级指导主管必须隶属于高级指导';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'高级指导'))
                return '你选择的团队似乎是错误的(没有包含“高级指导”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'高级指导'))
                return '你选择的小组似乎是错误的(没有包含“高级指导”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if(M('admin')->where(array('xiaozu'=>$data['xiaozu'],'job'=>5))->field('id')->find())
                return '此小组已经有高级指导主管了，请先撤销原主管职务';
            if($data['xiaodui']!=0)
                return '高级指导主管职务不需要指定小队';
            break;
            case '6':
            if($data['bumen']!=1)
                return '推广队长必须隶属于推广';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();

            if(!strstr($tuandui['gname'],'推广'))
                return '你选择的团队似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'推广'))
               return '你选择的小组似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改小组名称';

            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if($data['xiaodui']==0)
                return '没有指定小队';
            $xiaodui=M('admin_group')->where(array('id'=>$data['xiaodui']))->find();

            if($xiaodui['pid']!=$data['xiaozu'])
                return '小队和小组不匹配';
            if(M('admin')->where(array('xiaodui'=>$data['xiaodui'],'job'=>6))->field('id')->find())
                return '此小队已经有队长了，请先撤销原队长职务';
            break;
            case '7':
            if($data['bumen']!=1)
                return '推广必须隶属于推广部门';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'推广'))
                return '你选择的团队似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'推广'))
                return '你选择的小组似乎是错误的(没有包含“推广”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if($data['xiaodui']==0)
                return '没有指定小队';
            $xiaodui=M('admin_group')->where(array('id'=>$data['xiaodui']))->find();
            if($xiaodui['pid']!=$data['xiaozu'])
                return '小队和小组不匹配';
            break;
            case '8':
            if($data['bumen']!=2)
                return '普通指导必须隶属于普通指导部门';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'普通指导'))
                return '你选择的团队似乎是错误的(没有包含“普通指导”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'普通指导'))
                return '你选择的小组似乎是错误的(没有包含“普通指导”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if($data['xiaodui']!=0)
                return '普通指导职务不需要指定小队';
            break;
            case '9':
            if($data['bumen']!=11)
                return '高级指导必须隶属于高级指导组';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'高级指导'))
                return '你选择的团队似乎是错误的(没有包含“高级指导”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'高级指导'))
                return '你选择的小组似乎是错误的(没有包含“高级指导”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if($data['xiaodui']!=0)
                return '高级指导职务不需要指定小队';
            break;
            case '10'://高级指导团长
            if($data['bumen']!=11)
                return '急聘团长必须隶属于急聘';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'高级指导'))
                return '你选择的团队似乎是错误的(没有包含“高级指导”)，如果确认无误，请联系管理员修改团队名称';
            if($tuandui['pid']!=$data['bumen'])
                return '团队和部门不匹配';
            if(M('admin')->where(array('tuandui'=>$data['tuandui'],'job'=>10))->field('id')->find())
                return '此团队已经有团长了，请先撤销原团长职务';
            if($data['xiaozu']!=0||$data['xiaodui']!=0)
                return '团长职务不需要指定小组或小队';
            break;
            case '11'://急聘主管
            if($data['bumen']!=45)
                return '急聘主管必须隶属于急聘';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'急聘'))
                return '你选择的团队似乎是错误的(没有包含“急聘”)，如果确认无误，请联系管理员修改团队名称';
            if($tuandui['pid']!=$data['bumen'])
                return '团队和部门不匹配';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'急聘'))
                return '你选择的小组似乎是错误的(没有包含“急聘”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if(M('admin')->where(array('xiaozu'=>$data['xiaozu'],'job'=>11))->field('id')->find())
                return '此小组已经有急聘主管了，请先撤销原主管职务';
            if($data['xiaodui']!=0)
                return '急聘主管职务不需要指定小队';
            break;
            case '12'://急聘
            if($data['bumen']!=45)
                return '急聘必须隶属于急聘';
            if($data['tuandui']==0)
                return '没有指定团队';
            $tuandui=M('admin_group')->where(array('id'=>$data['tuandui']))->find();
            if(!strstr($tuandui['gname'],'急聘'))
                return '你选择的团队似乎是错误的(没有包含“急聘”)，如果确认无误，请联系管理员修改团队名称';
            if($data['xiaozu']==0)
                return '没有指定小组';
            $xiaozu=M('admin_group')->where(array('id'=>$data['xiaozu']))->find();
            if(!strstr($xiaozu['gname'],'急聘'))
                return '你选择的小组似乎是错误的(没有包含“急聘”)，如果确认无误，请联系管理员修改小组名称';
            if($xiaozu['pid']!=$data['tuandui'])
                return '小组和团队不匹配';
            if($data['xiaodui']!=0)
                return '急聘不需要指定小队';
            break;
            case '13':
            if($data['bumen']!=11)
                return '商家隶属于前厅';
            break;

            default:
            return '未找到该职务';
            break;
        }
        return true;
    }else{
        return '未找到该职务';
    }
}

function cn50r($url){
    $url = urlencode($url);
    //$api = 'http://50r.cn/urls/add.json?ak=5781e0243284b5c5144a4798&url='.$url;
	$api = 'http://api.t.sina.com.cn/short_url/shorten.json?source=3213676317&url_long=http://'.$url;
	
    $result = file_get_contents($api); //可以使用curl等代替
	//p($result);
    if($result){
        $result = json_decode($result);
        //if($result->error){//出错了
		if(! $result[0]->url_short){
            return ('地址有误');
        }else{
            return $result[0]->url_short;
        }
    }
}



function rwsy($task_id){
    $total = M('task')->field('total')->where(array('id'=>$task_id))->find();
    $yjd = M('admin_task')->where(array('task_id'=>$task_id))->count();
    $sy = $total['total']-$yjd;
    return $sy;
}

function task_sh($type){
    if(is_numeric($type) === false) {    
        return '宕机或超时，没有返回值';   
    }
    switch ($type) {
        case '0':
        $r="未审核";
        break;
        case '1':
        $r="已通过审核";
        break;
        case '2':
        $r="超时";
        break;
        case '3':
        $r="未通过审核";
        break;
        case '4':
        $r="待审核";
        break;
        default:
        $r='宕机或超时，类型错误';
        break;
    }
    return $r;
}


function editor() {
       // import('App.UploadFile');
       // $upload = new \UploadFile(); // \Think\
	   import('ORG.App.UploadFile');
		$upload = new Upload();// 实例化上传类
        $upload->maxSize = 3145728; // 设置附件上传大小
        $upload->allowExts = array('jpg', 'gif', 'png', 'jpeg'); // 设置附件上传类型
        $name = date('Y/m/d', NOW_TIME);
        $dir = BASE_PATH . '/attachs/editor/' . $name . '/';
        if (!is_dir($dir)) {
            mkdir($dir, 0755, true);
        }
        $upload->savePath = $dir; // 设置附件上传目录
        
        if (isset($this->_CONFIG['attachs']['editor']['thumb'])) {      
            $upload->thumb = true;
            $upload->thumbPrefix = 'thumb_';
            $upload->thumbType = 0; //不自动裁剪
            list($w, $h) = explode('X', $this->_CONFIG['attachs']['editor']['thumb']);
            $upload->thumbMaxWidth = $w;
            $upload->thumbMaxHeight = $h;
        }
        if (!$upload->upload()) {// 上传错误提示错误信息
            echo json_encode('上传有误');
            //var_dump($upload->getErrorMsg());
        } else {// 上传成功 获取上传文件信息
            $info = $upload->getUploadFileInfo();
           
             if(!empty($this->_CONFIG['attachs']['editor']['water'])){
                import('ORG.Util.Image');
                $Image = new Image();
              
                 $Image->water(BASE_PATH . '/attachs/editor/'. $name . '/thumb_' . $info[0]['savename'],BASE_PATH . '/attachs/'.$this->_CONFIG['attachs']['water']);
            }
            $return = array(
                'url' => $name . '/thumb_' . $info[0]['savename'],
                'originalName' => $name . '/thumb_' . $info[0]['savename'],
                'name' => $name . '/thumb_' . $info[0]['savename'],
                'state' => 'SUCCESS',
                'size' => $info['size'],
                'type' => $info['extension'],
            );
            echo json_encode($return);
        }
    }
	
	function getnickname($id){
        $admin_m = M('admin');
        $info =  $admin_m->where("id=$id")->find();
        if(! $info)
            return '此人不存在';
        else
            return $info['nickname'];
    }

    function rank(){
         $randstring = session('scode');

        if (empty($randstring)) {
            $randstring = rand_string(6, 1);
            session('scode', $randstring);
        }
        return $randstring;
    }

    function rand_string($len = 6, $type = '', $addChars = '') {
    $str = '';
    $chars = str_repeat('0123456789', 3);
    

    $chars = str_shuffle($chars);

    $str = substr($chars, 0, $len);
    return $str;
}
?>