<?php
/**
 * 易优CMS
 * ============================================================================
 * 版权所有 2016-2028 海南赞赞网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.eyoucms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 * Author: 小虎哥 <1105415366@qq.com>
 * Date: 2018-4-3
 */

namespace think\template\taglib\eyou;

use think\Db;

/**
 * 在内容页模板追加显示浏览量
 */
class TagNotice extends Base
{
    public $users    = [];

    //初始化
    protected function _initialize()
    {
        parent::_initialize();
        $this->users    = session('users');
    }

    /**
     * 在内容页模板追加显示浏览量
     * @author wengxianhu by 2018-4-20
     */
    public function getNotice()
    {
        $users =  $this->users;
        if (!empty($users)){
            $username = $users['username'];
            $count = Db::name('users_notice')
                ->where('find_in_set("'.$username.'",users_id)')
                ->whereOr(['users_id' => ''])
                ->count();
            $read = Db::name('users_notice_read')
                ->where('users_id',$username)
                ->count();

            $unread = ($count - $read)>0 ? $count - $read : 0;

            $result['url'] = url('user/UsersNotice/index');;
            $result['count'] = $unread;
            $result['hidden'] = '';
            return $result;
        }
    }
}