/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50717
Source Host           : localhost:3306
Source Database       : platform-shop

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2017-10-25 17:08:25
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `nideshop_ad`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_ad`;
CREATE TABLE `nideshop_ad` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `ad_position_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `media_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(60) DEFAULT '',
  `link` varchar(255) DEFAULT '',
  `image_url` text,
  `content` varchar(255) DEFAULT '',
  `end_time` datetime DEFAULT NULL,
  `enabled` tinyint(3) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `position_id` (`ad_position_id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_ad
-- ----------------------------
INSERT INTO `nideshop_ad` VALUES ('1', '1', '1', '合作 谁是你的菜', '', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/65091eebc48899298171c2eb6696fe27.jpg', '合作 谁是你的菜', '2017-09-07 21:48:34', '0');
INSERT INTO `nideshop_ad` VALUES ('2', '1', '1', '活动 美食节', '/pages/activity/activity?referrer=1&sourceKey=abcdefg', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/bff2e49136fcef1fd829f5036e07f116.jpg', '活动 美食节', '2017-09-07 21:48:34', '1');
INSERT INTO `nideshop_ad` VALUES ('3', '1', '1', '新用户注册', '/pages/auth/newuser/newuser', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/xinhuiyuan.jpg', '新用户注册', '2017-09-07 21:48:34', '1');

-- ----------------------------
-- Table structure for `nideshop_address`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_address`;
CREATE TABLE `nideshop_address` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned DEFAULT '0' COMMENT '会员ID',
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '收货人姓名',
  `tel_number` varchar(60) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '手机',
  `postal_Code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '邮编',
  `national_Code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '收货地址国家码',
  `province_Name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '省',
  `city_Name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '市',
  `county_Name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '区',
  `detail_Info` varchar(120) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '详细收货地址信息',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of nideshop_address
-- ----------------------------
INSERT INTO `nideshop_address` VALUES ('1', '23', '李鹏军', '15209831990', '230000', '340104', '安徽省', '合肥市', '蜀山区', '汽修小区29栋');

-- ----------------------------
-- Table structure for `nideshop_ad_position`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_ad_position`;
CREATE TABLE `nideshop_ad_position` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '''',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `desc` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_ad_position
-- ----------------------------
INSERT INTO `nideshop_ad_position` VALUES ('1', '移动端首页轮播广告', '750', '200', '');

-- ----------------------------
-- Table structure for `nideshop_attribute`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_attribute`;
CREATE TABLE `nideshop_attribute` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `attribute_category_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品类型',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `input_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '当添加商品时,该属性的添加类别; 0为手功输入;1为选择输入;2为多行文本输入',
  `value` text NOT NULL COMMENT '即选择输入,则attr_name对应的值的取值就是该这字段值 ',
  `sort_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat_id` (`attribute_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_attribute
-- ----------------------------
INSERT INTO `nideshop_attribute` VALUES ('1', '1008009', '材质', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('2', '1008009', '适用床尺寸', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('3', '1008009', '件数', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('4', '1008009', '工艺', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('5', '1008009', '执行标准', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('6', '1008009', '产地', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('7', '1008009', '温馨提示', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('8', '1008008', '填充物重量', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('9', '1008008', '尺寸', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('10', '1008008', '面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('11', '1008008', '填充物', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('12', '1008008', '填充成分', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('13', '1008008', '面料成分', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('14', '1008008', '含绒量', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('15', '1008008', '重量', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('16', '1008002', '规格', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('17', '1008002', '外套材质', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('18', '1008002', '内胆材质', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('19', '1008002', '*温馨提示', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('20', '1036000', '安全技术', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('21', '1036000', '产品等级', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('22', '1008002', '面料成份', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('23', '1008002', '内芯面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('24', '1008008', '颜色', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('25', '1008008', '适用人数', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('26', '1008009', '安全类别', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('27', '1008009', '根数', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('28', '1036000', '安全技术类别', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('29', '1036000', '克重', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('30', '1008008', '外层面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('31', '1008008', '里层面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('32', '1008008', '内芯', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('33', '1008008', '外用面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('34', '1008008', '商品重量', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('35', '1008002', '坐垫外层面料', '1', '', '0');
INSERT INTO `nideshop_attribute` VALUES ('36', '1008002', '坐垫内芯材料', '1', '', '0');

-- ----------------------------
-- Table structure for `nideshop_attribute_category`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_attribute_category`;
CREATE TABLE `nideshop_attribute_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(60) NOT NULL DEFAULT '',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1开启; 0关闭;',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1036002 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_attribute_category
-- ----------------------------
INSERT INTO `nideshop_attribute_category` VALUES ('1008002', '布艺软装', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1008008', '被枕', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1008009', '床品件套', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1008016', '灯具', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1011004', '家饰', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1015000', '家具', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1017000', '宠物', '1');
INSERT INTO `nideshop_attribute_category` VALUES ('1036000', '夏凉', '1');

-- ----------------------------
-- Table structure for `nideshop_brand`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_brand`;
CREATE TABLE `nideshop_brand` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `list_pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `simple_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `sort_order` tinyint(3) unsigned DEFAULT '50' COMMENT '排序',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '显示',
  `floor_price` decimal(10,2) DEFAULT '0.00',
  `app_list_pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT 'app显示图片',
  `is_new` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '新品牌',
  `new_pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `new_sort_order` tinyint(2) unsigned NOT NULL DEFAULT '10' COMMENT '排序',
  PRIMARY KEY (`id`),
  KEY `is_show` (`is_show`)
) ENGINE=InnoDB AUTO_INCREMENT=1046011 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_brand
-- ----------------------------
INSERT INTO `nideshop_brand` VALUES ('1001000', 'MUJI制造商', 'http://yanxuan.nosdn.127.net/1541445967645114dd75f6b0edc4762d.png', '严选精选了MUJI制造商和生产原料，\n用几乎零利润的价格，剔除品牌溢价，\n让用户享受原品牌的品质生活。', 'http://yanxuan.nosdn.127.net/4ea3f1e60dd77c45c218e503d721a1ed.jpg', '2', '1', '12.90', 'http://yanxuan.nosdn.127.net/1541445967645114dd75f6b0edc4762d.png', '1', 'http://yanxuan.nosdn.127.net/4ea3f1e60dd77c45c218e503d721a1ed.jpg', '2');
INSERT INTO `nideshop_brand` VALUES ('1001002', '内野制造商', 'http://yanxuan.nosdn.127.net/8ca3ce091504f8aa1fba3fdbb7a6e351.png', '严选从世界各地挑选毛巾，最终选择了为日本内野代工的工厂，追求毛巾的柔软度与功能性。品质比肩商场几百元的毛巾。', 'http://yanxuan.nosdn.127.net/e50654982984206b54e9226e5ab7f90c.jpg', '10', '1', '29.00', 'http://yanxuan.nosdn.127.net/8ca3ce091504f8aa1fba3fdbb7a6e351.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001003', 'Adidas制造商', 'http://yanxuan.nosdn.127.net/335334d0deaff6dc3376334822ab3a2f.png', '严选找到为Adidas等品牌制造商，\n选取优质原材料，与厂方一起设计，\n为你提供好的理想的运动装备。', 'http://yanxuan.nosdn.127.net/6f954ea8cee30e161dda048ffbfd950f.png', '30', '1', '49.00', 'http://yanxuan.nosdn.127.net/335334d0deaff6dc3376334822ab3a2f.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001007', '优衣库制造商', 'http://yanxuan.nosdn.127.net/0d72832e37e7e3ea391b519abbbc95a3.png', '严选找到日本知名服装UNIQLO的制造商，\n选取优质长绒棉和精梳工艺，\n与厂方一起设计，为你提供理想的棉袜。', 'http://yanxuan.nosdn.127.net/f3d196c03f8aac5625faba00d670ee03.jpg', '12', '1', '29.00', 'http://yanxuan.nosdn.127.net/0d72832e37e7e3ea391b519abbbc95a3.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001008', '膳魔师制造商', 'http://yanxuan.nosdn.127.net/5fd51e29b9459dae7df8040c8219f241.png', '严选深入保温行业内部，\n找到德国膳魔师制造商的代工厂。\n同样的品质，却有更优的价格。', 'http://yanxuan.nosdn.127.net/c4ab88f475e375c5748fa13d8bf2858d.png', '40', '1', '45.00', 'http://yanxuan.nosdn.127.net/5fd51e29b9459dae7df8040c8219f241.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001010', '星巴克制造商', 'http://yanxuan.nosdn.127.net/5668bc50f2f2e551891044525710dc84.png', '严选寻访全国保温杯制造企业，\n最终找到高端咖啡品牌星巴克的制造商，\n专注保温杯生产20年，品质与颜值兼备。', 'http://yanxuan.nosdn.127.net/2433b04ea9d7adda1d2e834786872237.jpg', '34', '1', '39.00', 'http://yanxuan.nosdn.127.net/5668bc50f2f2e551891044525710dc84.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001012', 'Wedgwood制造商', 'http://yanxuan.nosdn.127.net/68940e8e23f96dbeb3548d943d83d5e4.png', '严选寻访英国皇室御用陶瓷Wedgwood制造商，\n制模到成品，历经25道工序、7次检验、3次烧制，\n你看不见的地方，我们也在坚持。', 'http://yanxuan.nosdn.127.net/6d6124123311f85903a8bc864d37464c.jpg', '21', '1', '39.00', 'http://yanxuan.nosdn.127.net/68940e8e23f96dbeb3548d943d83d5e4.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001013', 'Royal Doulton制造商', 'http://yanxuan.nosdn.127.net/0de643a02043fd9680b11e21c452adaa.png', '严选深入英国最大骨瓷品牌Royal Doulton制造商， \n顶级英国瓷器的代名词，广受世界皇室喜爱。\n每件瓷器，都有自己的故事。', 'http://yanxuan.nosdn.127.net/0e8311d2246e5643c622743d9684f235.jpg', '47', '1', '24.90', 'http://yanxuan.nosdn.127.net/0de643a02043fd9680b11e21c452adaa.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001015', '日本KEYUCA制造商', 'http://yanxuan.nosdn.127.net/9b85b45f23da558be101dbcc273b1d6d.png', 'KEYUCA是日本餐具及料理用具品牌，\n遵循极简原木风，高端餐具体验。\n严选的餐具正是来自这一品牌制造商。', 'http://yanxuan.nosdn.127.net/d91db0c68c50cd109c16f0ad1427ed0b.jpg', '49', '1', '14.90', 'http://yanxuan.nosdn.127.net/9b85b45f23da558be101dbcc273b1d6d.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001016', '爱慕制造商', 'http://yanxuan.nosdn.127.net/5104f84110eac111968c63c18ebd62c0.png', '150家样品比对筛选，20家工厂深入走访，\n严选最终选定高端内衣爱慕制造商，\n20年品质保证，为你打造天然舒适的衣物。', 'http://yanxuan.nosdn.127.net/833104a2ac047faccd90cc6b98ccf4be.jpg', '9', '1', '35.00', 'http://yanxuan.nosdn.127.net/5104f84110eac111968c63c18ebd62c0.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001020', 'Ralph Lauren制造商', 'http://yanxuan.nosdn.127.net/9df78eb751eae2546bd3ee7e61c9b854.png', '我们与Ralph Lauren Home的制造商成功接洽，掌握先进的生产设备，传承品牌工艺和工序。追求生活品质的你，值得拥有。', 'http://yanxuan.nosdn.127.net/089e4066f0c2bc6b062d17c6292735dc.png', '20', '1', '29.00', 'http://yanxuan.nosdn.127.net/9df78eb751eae2546bd3ee7e61c9b854.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001037', '新秀丽制造商', 'http://yanxuan.nosdn.127.net/80dce660938931956ee9a3a2b111bd37.jpg', '严选为制作品质与颜值兼具的箱包，\n选定新秀丽、CK、Ricardo等品牌合作的制造商，\n拥有国内先进流水线20余条，实力保障品质。', 'http://yanxuan.nosdn.127.net/af5719e20bdbd214a9ce7d961e9031c5.png', '5', '1', '59.00', 'http://yanxuan.nosdn.127.net/80dce660938931956ee9a3a2b111bd37.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001038', 'Coach制造商', 'http://yanxuan.nosdn.127.net/1b1cc16135fd8467d40983f75f644127.png', '严选为制作高品质高颜值皮具配件，\n由Coach、MK等品牌制造商生产，\n由严选360度全程监制，给你带来优质皮具。', 'http://yanxuan.nosdn.127.net/c933a662bb79b2a47280363e35ab994b.png', '3', '1', '49.00', 'http://yanxuan.nosdn.127.net/1b1cc16135fd8467d40983f75f644127.png', '1', 'http://yanxuan.nosdn.127.net/b5cd73d3b310bad02539412f064d4ea1.jpg', '10');
INSERT INTO `nideshop_brand` VALUES ('1001039', 'MK制造商', 'http://yanxuan.nosdn.127.net/fc9cd1309374f7707855de80522fb310.jpg', '严选为制造高品质的皮具，\n选择Michael Kors品牌合作的制造工厂，\n18年专业皮具生产经验，手工至美，品质保证。', 'http://yanxuan.nosdn.127.net/c302c82dafcb53ba233aa1e277063a1c.png', '17', '1', '79.00', 'http://yanxuan.nosdn.127.net/fc9cd1309374f7707855de80522fb310.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1001045', '罗莱制造商', 'http://yanxuan.nosdn.127.net/14122a41a4985d23e1a172302ee818e9.png', '严选团队为打造吸湿透气柔软的蚕丝被，\n从蚕茧原材到温感性能，多次甄选测试\n选择罗莱制造商工厂，手工处理，优质舒适。', 'http://yanxuan.nosdn.127.net/a88d8eae6d492492da07eca7616dce42.jpg', '45', '1', '699.00', 'http://yanxuan.nosdn.127.net/14122a41a4985d23e1a172302ee818e9.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1003000', 'Carters制造商', 'http://yanxuan.nosdn.127.net/efe9131599ced0297213e6ec67eb2174.png', '来自Carters大牌代工厂生产，\n严选纯天然材料，无荧光不添加，\nITS安心标志权威检测，安全护航。', 'http://yanxuan.nosdn.127.net/a3fd78f8cf429a34e1e2ea761466d428.jpg', '41', '1', '19.90', 'http://yanxuan.nosdn.127.net/efe9131599ced0297213e6ec67eb2174.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1005001', 'Goody制造商', 'http://yanxuan.nosdn.127.net/7c918f37de108f3687d69b39daab34eb.png', '严选深入美国百年发饰品牌Goody制造商，\n确保每把梳子做工精湛，养护头皮。\n戴安娜王妃的最爱，你也能拥有。', 'http://yanxuan.nosdn.127.net/431cd1e6bfca9964f96f1964a8b08ebb.jpg', '48', '1', '39.00', 'http://yanxuan.nosdn.127.net/7c918f37de108f3687d69b39daab34eb.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1006000', '范思哲制造商', 'http://yanxuan.nosdn.127.net/c80ae035387495a61a4515906205efff.png', '严选找寻意大利奢侈品牌范思哲Versace的制造商，\n致力于为用户带来精致、优雅、时尚的皮包，\n传承独特美感，体验品质生活。', 'http://yanxuan.nosdn.127.net/4e5e9e8cf9ce08f256494321ba4d3c2a.jpg', '18', '1', '99.00', 'http://yanxuan.nosdn.127.net/c80ae035387495a61a4515906205efff.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1008000', 'WPC制造商', 'http://yanxuan.nosdn.127.net/c4e97cc87186ce17f9316f3ba39e220c.png', '严选寻找日本雨伞品牌W.P.C制造商，\n采用严谨工艺以及环保材料，\n沉淀15年行业经验，打造精致雨具。', 'http://yanxuan.nosdn.127.net/83889aa01e7cf8e0ff605c317a01e55d.jpg', '22', '1', '59.00', 'http://yanxuan.nosdn.127.net/c4e97cc87186ce17f9316f3ba39e220c.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1010001', '竹宝堂制造商', 'http://yanxuan.nosdn.127.net/61b0b7ae4f0163422009defbceaa41ad.jpg', '严选走访河北、安徽等制刷基地，\n选定竹宝堂、丝芙兰等品牌的制造商，\n严格把关生产与质检，与您一同追求美的生活。', 'http://yanxuan.nosdn.127.net/279cf74ac294e67f7f99cf2d47a1365c.jpg', '39', '1', '29.00', 'http://yanxuan.nosdn.127.net/61b0b7ae4f0163422009defbceaa41ad.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1010002', '资生堂制造商', 'http://yanxuan.nosdn.127.net/5449236b80d1e678dedee2f626cd67c4.png', '发现美，成为美，是女性一生的追求。\n严选找寻资生堂代工厂，打造天然美妆产品，\n致力于带来更多美的体验和享受。', 'http://yanxuan.nosdn.127.net/af464d5281dfbd286dab569a03264a33.jpg', '19', '1', '29.00', 'http://yanxuan.nosdn.127.net/5449236b80d1e678dedee2f626cd67c4.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1015000', 'NITORI制造商', 'http://yanxuan.nosdn.127.net/6f3d310601b18610553c675e0e14d107.png', '宠物是人类最温情的陪伴，\n严选找寻日本最大家居品牌NITORI制造商，\n每一个脚印，都是为了更好地关怀你的TA', 'http://yanxuan.nosdn.127.net/0657854429c6717e8ace7dcff6a2468b.jpg', '43', '1', '69.00', 'http://yanxuan.nosdn.127.net/6f3d310601b18610553c675e0e14d107.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1016002', 'HUGO BOSS制造商', 'http://yanxuan.nosdn.127.net/70ada9877b2efa82227437af3231fe50.png', '严选深入德国知名奢侈品HUGO BOSS的制造商，\n开发睡衣、睡袍、休闲裤等轻奢品质家居服，\n希望你在家的每一天都优雅精致。', 'http://yanxuan.nosdn.127.net/888289da7fe200949806eefa069af019.jpg', '11', '1', '45.00', 'http://yanxuan.nosdn.127.net/70ada9877b2efa82227437af3231fe50.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1018000', 'Sperry制造商', 'http://yanxuan.nosdn.127.net/2eb12d84037346441088267432da31c4.png', '严选团队对比多家硫化鞋制造商产品质量，\n走访多个制鞋工厂，最终选定Sperry品牌制造商，\n为你提供一双舒适有型的高品质帆布鞋。', 'http://yanxuan.nosdn.127.net/952b9f38a729533a058ee88572a370fa.jpg', '32', '1', '199.00', 'http://yanxuan.nosdn.127.net/2eb12d84037346441088267432da31c4.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1021000', 'Marc Jacobs制造商', 'http://yanxuan.nosdn.127.net/c8dac4eb1a458d778420ba520edab3d0.png', '严选寻访独立设计品牌Marc Jacobs的制造商，\n严格选材，细究纺织与生产的细节，多次打磨，\n初心不忘，为你带来优雅高档的服饰配件。', 'http://yanxuan.nosdn.127.net/ce5762f1fd4bde61b57864e765c605e3.jpg', '24', '1', '69.00', 'http://yanxuan.nosdn.127.net/c8dac4eb1a458d778420ba520edab3d0.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1022000', 'UGG制造商', 'http://yanxuan.nosdn.127.net/4d2a3dea7e0172ae48e8161f04cfa045.jpg', '为寻找优质的皮毛一体雪地靴，\n严选走访多家雪地靴制造商，对比工艺，\n甄选UGG认可的代工厂，只为足下的优雅舒适。', 'http://yanxuan.nosdn.127.net/efbc6a6044dd07697d2f26bf5033c335.jpg', '29', '1', '59.00', 'http://yanxuan.nosdn.127.net/4d2a3dea7e0172ae48e8161f04cfa045.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1022001', 'Palladium制造商', 'http://yanxuan.nosdn.127.net/3480f2a4026c60eb4921f0aa3facbde8.png', '严选探访多个制鞋大厂，选定Palladium制造商，\n对比工艺选材，找到传承多年的制鞋配方，\n只为制作一款高品质休闲鞋。', 'http://yanxuan.nosdn.127.net/119717ea4459a8fb3185cec4eb80a284.jpg', '31', '1', '249.00', 'http://yanxuan.nosdn.127.net/3480f2a4026c60eb4921f0aa3facbde8.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1023000', 'PetitBateau小帆船制造商', 'http://yanxuan.nosdn.127.net/1a11438598f1bb52b1741e123b523cb5.jpg', '为打造适合宝宝的婴童服装，\n严选团队寻找PetitBateau小帆船的品牌制造商，\n无荧光剂，国家A类标准，让宝宝穿的放心。', 'http://yanxuan.nosdn.127.net/faad5a05a119b789956e4ce2e26e94ef.jpg', '25', '1', '36.00', 'http://yanxuan.nosdn.127.net/1a11438598f1bb52b1741e123b523cb5.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1024000', 'WMF制造商', 'http://yanxuan.nosdn.127.net/2018e9ac91ec37d9aaf437a1fd5d7070.png', '严选找寻德国百年高端厨具WMF的制造商，\n选择拥有14年经验的不锈钢生产工厂，\n为你甄选事半功倍的优质厨具。', 'http://yanxuan.nosdn.127.net/2a2ae0d49043e525db8d0d8d84460ac8.png', '8', '1', '9.90', 'http://yanxuan.nosdn.127.net/2018e9ac91ec37d9aaf437a1fd5d7070.png', '1', 'http://yanxuan.nosdn.127.net/abcfa79205679db51198adc19c184dd1.jpg', '3');
INSERT INTO `nideshop_brand` VALUES ('1024001', 'OBH制造商', 'http://yanxuan.nosdn.127.net/bf3499ac17a11ffb9bb7caa47ebef2dd.png', '严选寻找OBH品牌的制造商，打造精致厨具，\n韩国独资工厂制造，严格质检，品质雕琢\n力求为消费者带来全新的烹饪体验。', 'http://yanxuan.nosdn.127.net/44e14d6ec4db2e6c66b0fde521603f85.jpg', '42', '1', '39.00', 'http://yanxuan.nosdn.127.net/bf3499ac17a11ffb9bb7caa47ebef2dd.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1024003', 'Stoneline制造商', 'http://yanxuan.nosdn.127.net/3a44ae7db86f3f9b6e542720c54cc349.png', '严选找寻德国经典品牌Stoneline的制造商，\n追踪工艺，考量细节，亲自试用，\n为你甄选出最合心意的锅具和陶瓷刀，下厨如神。', 'http://yanxuan.nosdn.127.net/6dc7eecce99cb8f5ab6d86c76415cbec.png', '28', '1', '9.90', 'http://yanxuan.nosdn.127.net/3a44ae7db86f3f9b6e542720c54cc349.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1024006', 'KitchenAid制造商', 'http://yanxuan.nosdn.127.net/e11385bf29d1b3949435b80fcd000948.png', '严选寻访KitchenAid品牌的制造商，\n采用德国LFGB认证食品级专用不锈钢，\n欧式简约设计，可靠安心，尽享下厨乐趣。', 'http://yanxuan.nosdn.127.net/2f79a254cd4020966ea1272e2d27b510.jpg', '46', '1', '98.00', 'http://yanxuan.nosdn.127.net/e11385bf29d1b3949435b80fcd000948.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1025000', 'Timberland制造商', 'http://yanxuan.nosdn.127.net/6dcadb0791b33aa9fd00380b44fa6645.png', '为制作优质时尚的工装鞋靴，\n严选团队深入探访国内外制靴大厂，选择Timberland制造商，\n工厂拥有15年制鞋历史，专业品质有保证。', 'http://yanxuan.nosdn.127.net/5b35f510110d0c031eb6bf63854597b8.png', '37', '1', '359.00', 'http://yanxuan.nosdn.127.net/6dcadb0791b33aa9fd00380b44fa6645.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1025001', 'Kenneth Cole制造商', 'http://yanxuan.nosdn.127.net/236322546c6860e1662ab147d6b0ba2f.jpg', '为出品优质格调的商务鞋靴，\n严选团队选择Kenneth Cole品牌合作的制造商，\n一切努力，只为打造高品质鞋靴。', 'http://yanxuan.nosdn.127.net/63a1df6f5d26faadffa33bac2d51ddc4.jpg', '7', '1', '349.00', 'http://yanxuan.nosdn.127.net/236322546c6860e1662ab147d6b0ba2f.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1026000', 'CK制造商', 'http://yanxuan.nosdn.127.net/658f09b7ec522d31742b47b914d64338.png', '严选寻访Calvin Klein品牌的制造商，\n深入世界领带第一生产地，设计与品质并重，\n致力于给消费者带来优质典雅的服饰用品。', 'http://yanxuan.nosdn.127.net/fb139c9f11a10deb41beeb42aaad488e.png', '1', '1', '39.00', 'http://yanxuan.nosdn.127.net/658f09b7ec522d31742b47b914d64338.png', '1', 'http://yanxuan.nosdn.127.net/76638fb8e6990aadf837ce761c3b7399.jpg', '1');
INSERT INTO `nideshop_brand` VALUES ('1026001', 'Under Armour制造商', 'http://yanxuan.nosdn.127.net/4e93ea29b1d06fabfd24ba68a9b20a34.jpg', '严选为甄选优质好袜，走访东北、新疆等产袜基地，\n最终选定Under Armour品牌的合作制造商，\n从原料、工艺、品质多维度筛选监制，保证好品质。', 'http://yanxuan.nosdn.127.net/b00570a5edc8da2f4a629fbdddb0b03c.jpg', '35', '1', '39.00', 'http://yanxuan.nosdn.127.net/4e93ea29b1d06fabfd24ba68a9b20a34.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1028000', 'Gucci制造商', 'http://yanxuan.nosdn.127.net/278869cad9bf5411ffc18982686b88fb.jpg', '严选为设计一款优雅时尚的品质礼帽，\n找寻拥有10来年经验的大型毛毡帽厂商合作，\n坚持打造好设计、好工艺、好材质的潮流礼帽。', 'http://yanxuan.nosdn.127.net/7749ff4939c0a62689c5d1de7fba2860.png', '23', '1', '59.00', 'http://yanxuan.nosdn.127.net/278869cad9bf5411ffc18982686b88fb.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1028003', 'Burberry制造商', 'http://yanxuan.nosdn.127.net/07af01e281c7e0b912d162d611e22c32.jpg', '为打造时尚舒适的童装系列，\n严选选择Burberry制造商，优化版型配色\n英伦风情融入经典格纹，百搭优雅气质款。', 'http://yanxuan.nosdn.127.net/1a874a6b8cf8c17ef7420b2449179eae.jpg', '4', '1', '99.00', 'http://yanxuan.nosdn.127.net/07af01e281c7e0b912d162d611e22c32.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1033003', 'Armani制造商', 'http://yanxuan.nosdn.127.net/981e06f0f46f5f1f041d7de3dd3202e6.jpg', '严选团队携手国际标准化专业生产厂家，\n厂家长期为Armani、Alexander wang等知名品牌代工，\n专业进口设备，精密质量把控，精于品质居家体验。', 'http://yanxuan.nosdn.127.net/cc2513963d45c8a0787bc9650e95b3bc.jpg', '26', '1', '199.00', 'http://yanxuan.nosdn.127.net/981e06f0f46f5f1f041d7de3dd3202e6.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1033004', '爱马仕集团制造商', 'http://yanxuan.nosdn.127.net/d98470dd728fb5a91f7aceade07572b5.png', '严选采用欧洲一线品牌爱马仕的御用香料供应商，\n经过反复配比改良、试香调香、选品定样，\n为你带来独特馥郁的散香体验。', 'http://yanxuan.nosdn.127.net/dd4b9a6cb73e3e1c61c79cbd4bb0bca0.jpg', '33', '1', '19.00', 'http://yanxuan.nosdn.127.net/d98470dd728fb5a91f7aceade07572b5.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1034001', 'Alexander McQueen制造商', 'http://yanxuan.nosdn.127.net/db7ee9667d84cbce573688297586699c.jpg', '为制造精致实用的高品质包包，\n严选团队选择Alexander McQueen制造商，\n严格筛选，带来轻奢优雅体验。', 'http://yanxuan.nosdn.127.net/48d8b0a9cd41cd7028b055d6d2b4b57e.jpg', '16', '1', '69.00', 'http://yanxuan.nosdn.127.net/db7ee9667d84cbce573688297586699c.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1037000', '厚木ATSUGI制造商', 'http://yanxuan.nosdn.127.net/7df55c408dbac6085ed6c30836c828ac.jpg', '严选考究袜子品质，层层把关原料生产，\n携手12年行业生产资质的厚木品牌制造商，\n带来轻盈优雅，舒适显瘦的袜子系列。', 'http://yanxuan.nosdn.127.net/51f1a2b3e663989e8880066af929ce50.jpg', '27', '1', '29.00', 'http://yanxuan.nosdn.127.net/7df55c408dbac6085ed6c30836c828ac.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1038000', 'Birkenstock集团制造商', 'http://yanxuan.nosdn.127.net/05a2ecffb60b77e4c165bd8492e5c22a.jpg', '为打造一双舒适的软木拖鞋，\n严选团队寻找BIRKENSTOCK集团旗下产品制造商，\n360度全程监制，舒适随脚，百搭文艺。', 'http://yanxuan.nosdn.127.net/0996a492f86f01cb83cd3737ad325e23.jpg', '14', '1', '59.90', 'http://yanxuan.nosdn.127.net/05a2ecffb60b77e4c165bd8492e5c22a.jpg', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1038001', 'Nine West制造商', 'http://yanxuan.nosdn.127.net/ad4df7848ce450f00483c2d5e9f2bfa7.png', '为打造一双优雅舒适的高跟鞋，\n严选选择美国Nine West玖熙品牌的制造商，\n让美丽绽放在足尖。', 'http://yanxuan.nosdn.127.net/38d494067453afa08d2b26d8227558fc.jpg', '13', '1', '219.00', 'http://yanxuan.nosdn.127.net/ad4df7848ce450f00483c2d5e9f2bfa7.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1039000', 'TEFAL制造商', 'http://yanxuan.nosdn.127.net/2b7a07e25a3f3be886a7fb90ba975bb7.png', '严选对标国际品质，致力于高品质生活好物，\n执着寻求优质厨房电器供应商，\n携手WMF、Tefal制造商，打造高品质厨具。', 'http://yanxuan.nosdn.127.net/713daad73395a4f3d06f5dd07ed927d4.jpg', '44', '1', '259.00', 'http://yanxuan.nosdn.127.net/2b7a07e25a3f3be886a7fb90ba975bb7.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1039001', '京瓷制造商', 'http://yanxuan.nosdn.127.net/3dda530605e3ab1c82d5ed30f2489473.png', '严选想为你的厨房生活，带来新鲜感和活力，\n深入全国各地，选择日本京瓷等品牌代工厂，\n打造钻石系列厨具，颜值与品质兼具。', 'http://yanxuan.nosdn.127.net/de8c967f47c47e48aaaf461a5e24bc4c.jpg', '38', '1', '89.00', 'http://yanxuan.nosdn.127.net/3dda530605e3ab1c82d5ed30f2489473.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1040000', 'Tescom制造商', 'http://yanxuan.nosdn.127.net/c17cd65971189fdc28f5bd6b78f657a7.png', '严选为打造时尚健康的个护电器，\n选择Tescom品牌制造商，全球最大个护电器工厂之一，\n拥有20年经验，出口180多个国家，品质有保障。', 'http://yanxuan.nosdn.127.net/21ff3c560b263cf45dd2b8c92091768b.jpg', '15', '1', '59.00', 'http://yanxuan.nosdn.127.net/c17cd65971189fdc28f5bd6b78f657a7.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1041000', 'BCBG制造商', 'http://yanxuan.nosdn.127.net/b9072023afd3621714fd5c49f140fca8.png', '严选从产品源头开始，每道工序质量把关，\n选择美国知名品牌BCBG的制造商合作，\n严谨匠心，致力于优质柔滑的睡衣穿搭产品。', 'http://yanxuan.nosdn.127.net/3f2a66543f4c6e2abd5de2d280ff7960.png', '36', '1', '99.00', 'http://yanxuan.nosdn.127.net/b9072023afd3621714fd5c49f140fca8.png', '0', '', '10');
INSERT INTO `nideshop_brand` VALUES ('1046000', 'Police制造商', 'http://yanxuan.nosdn.127.net/66e2cb956a9dd1efc7732bea278e901e.png', '严选团队选定Police品牌制造商合作，\n有11年眼镜生产资质，兼顾品质与品味，\n为你带来专业时尚的墨镜。', 'http://yanxuan.nosdn.127.net/d48930cbb91f0e3adafe5341ce270a4e.png', '6', '1', '109.00', 'http://yanxuan.nosdn.127.net/66e2cb956a9dd1efc7732bea278e901e.png', '0', '', '10');

-- ----------------------------
-- Table structure for `nideshop_cart`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_cart`;
CREATE TABLE `nideshop_cart` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '会员Id',
  `session_id` char(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'sessionId',
  `goods_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '商品Id',
  `goods_sn` varchar(60) NOT NULL DEFAULT '' COMMENT '商品序列号',
  `product_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品Id',
  `goods_name` varchar(120) NOT NULL DEFAULT '' COMMENT '产品名称',
  `market_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `retail_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '零售价格',
  `number` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `goods_specifition_name_value` text COMMENT '规格属性组成的字符串，用来显示用',
  `goods_specifition_ids` varchar(60) DEFAULT '' COMMENT 'product表对应的goods_specifition_ids',
  `checked` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `list_pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT '商品图片',
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_cart
-- ----------------------------
INSERT INTO `nideshop_cart` VALUES ('126', '15', '1', '1152008', '1152008', '232', '魔兽世界 部落 护腕 一只', '0.00', '29.00', '2', null, '', '1', 'http://yanxuan.nosdn.127.net/203cb83d93606865e3ddde57b69b9e9a.png');

-- ----------------------------
-- Table structure for `nideshop_category`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_category`;
CREATE TABLE `nideshop_category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `keywords` varchar(255) DEFAULT '',
  `front_desc` varchar(255) DEFAULT '',
  `parent_id` int(11) unsigned DEFAULT '0',
  `sort_order` tinyint(1) unsigned DEFAULT '50',
  `show_index` tinyint(1) DEFAULT '0',
  `is_show` tinyint(1) unsigned DEFAULT '1',
  `banner_url` varchar(255) DEFAULT '',
  `icon_url` varchar(255) DEFAULT NULL,
  `img_url` varchar(255) DEFAULT NULL,
  `wap_banner_url` varchar(255) DEFAULT NULL,
  `level` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT '0',
  `front_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1036007 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_category
-- ----------------------------
INSERT INTO `nideshop_category` VALUES ('1005000', '居家', '', '回家，放松身心', '0', '2', '1', '1', 'http://yanxuan.nosdn.127.net/92357337378cce650797444bc107b0f7.jpg', 'http://yanxuan.nosdn.127.net/a45c2c262a476fea0b9fc684fed91ef5.png', '//nos.netease.com/yanxuan/f0d0e1a542e2095861b42bf789d948ce.jpg', 'http://yanxuan.nosdn.127.net/e8bf0cf08cf7eda21606ab191762e35c.png', 'L1', '0', '回家，放松身心');
INSERT INTO `nideshop_category` VALUES ('1005001', '餐厨', '', '厨房', '0', '3', '2', '1', 'http://yanxuan.nosdn.127.net/f4ff8b3d5b0767d4e578575c1fd6b921.jpg', 'http://yanxuan.nosdn.127.net/ad8b00d084cb7d0958998edb5fee9c0a.png', '//nos.netease.com/yanxuan/88855173a0cfcfd889ee6394a3259c4f.jpg', 'http://yanxuan.nosdn.127.net/3708dbcb35ad5abf9e001500f73db615.png', 'L1', '0', '爱，囿于厨房');
INSERT INTO `nideshop_category` VALUES ('1005002', '饮食', '', '好吃，高颜值美食', '0', '9', '8', '1', 'http://yanxuan.nosdn.127.net/dd6cc8a7e996936768db5634f12447ed.jpg', 'http://yanxuan.nosdn.127.net/c9280327a3fd2374c000f6bf52dff6eb.png', '//nos.netease.com/yanxuan/9a29ef4f41c305a12e1459f12abd290f.jpg', 'http://yanxuan.nosdn.127.net/fb670ff3511182833e5b035275e4ac09.png', 'L1', '0', '好吃，高颜值美食');
INSERT INTO `nideshop_category` VALUES ('1005007', '锅具', '', '中华铸铁、精选不锈钢、进口珐琅', '1005001', '1', '1', '1', 'http://yanxuan.nosdn.127.net/4aab4598017b5749e3b63309d25e9f6b.png', '', '', 'http://yanxuan.nosdn.127.net/d2db0d1d0622c621a8aa5a7c06b0fc6d.png', 'L2', '0', '一口好锅，炖煮生活一日三餐');
INSERT INTO `nideshop_category` VALUES ('1005008', '餐具', '', '皇家道尔顿、日本KEYUCA制造商出品', '1005001', '4', '4', '1', 'http://yanxuan.nosdn.127.net/f109afbb7e7a00c243c1da29991a5aa3.png', '', '', 'http://yanxuan.nosdn.127.net/695ed861a63d8c0fc51a51f42a5a993b.png', 'L2', '0', '餐桌上的舞蹈');
INSERT INTO `nideshop_category` VALUES ('1005009', '清洁', '', '特殊材质，做家务更简单', '1005001', '9', '9', '1', 'http://yanxuan.nosdn.127.net/e8b67fe8b8db2ecc2e126a0aa631def0.png', '', '', 'http://yanxuan.nosdn.127.net/3a40faaef0a52627357d98ceed7a3c45.png', 'L2', '0', '环保便利，聪明之选');
INSERT INTO `nideshop_category` VALUES ('1005010', '炒货', '', '精选原产地，美味加营养', '1005002', '5', '5', '1', 'http://yanxuan.nosdn.127.net/6c43063003207168c1d8e83a923e8515.png', '', '', 'http://yanxuan.nosdn.127.net/3972963a4b6f9588262d2a667f4c1c73.png', 'L2', '0', '精选原产地，美味加营养');
INSERT INTO `nideshop_category` VALUES ('1005011', '小食', '', '原香鲜材，以小食之味，带来味蕾惊喜', '1005002', '2', '2', '1', 'http://yanxuan.nosdn.127.net/663f568475c994358bf31bcb67d122fe.png', '', '', 'http://yanxuan.nosdn.127.net/418f86049f957108a31ad55cec42c349.png', 'L2', '0', '原香鲜材，以小食之味，带来味蕾惊喜');
INSERT INTO `nideshop_category` VALUES ('1005012', '食材', '', '天时、地利、人和，寻找这个时节这个地点的味道', '1005002', '10', '10', '1', 'http://yanxuan.nosdn.127.net/e050980992725b7932bb3645fe5aec08.png', '', '', 'http://yanxuan.nosdn.127.net/80db363e0687b1a65edc6e75c1b99726.png', 'L2', '0', '天时地利人和，寻找这个时节这个地点的味道');
INSERT INTO `nideshop_category` VALUES ('1005013', '冲饮', '', '以用料天然之美，尽享闲雅之意', '1005002', '6', '6', '1', 'http://yanxuan.nosdn.127.net/2919b0d6eec79182cca31dc827f4d00a.png', '', '', 'http://yanxuan.nosdn.127.net/1e3d8f65c7c7811baccdfda6711cbfd5.png', 'L2', '0', '以用料天然之美，尽享闲雅之意');
INSERT INTO `nideshop_category` VALUES ('1007000', '杯壶', '', '10Q品质控制系统', '1005001', '2', '2', '1', 'http://yanxuan.nosdn.127.net/0b244d3575b737c8f0ed7e84c5c4abd2.png', '', '', 'http://yanxuan.nosdn.127.net/ec53828a3814171079178a59fb2593da.png', 'L2', '0', '精工生产制作，匠人手艺');
INSERT INTO `nideshop_category` VALUES ('1008000', '配件', '', '配角，亦是主角', '0', '4', '3', '1', 'http://yanxuan.nosdn.127.net/cad5aba2bc52d3b8adfd0232c9814de2.jpg', 'http://yanxuan.nosdn.127.net/11abb11c4cfdee59abfb6d16caca4c6a.png', '//nos.netease.com/yanxuan/935f1ab7dcfeb4bbd4a5da9935161aaf.jpg', 'http://yanxuan.nosdn.127.net/02f9a44d05c05c0dd439a5eb674570a2.png', 'L1', '0', '配角，亦是主角');
INSERT INTO `nideshop_category` VALUES ('1008001', '毛巾', '', '精选长绒棉，出口日本品质标准', '1013001', '1', '1', '1', 'http://yanxuan.nosdn.127.net/44ad9a739380aa6b7cf956fb2a06e7a7.png', '', '', 'http://yanxuan.nosdn.127.net/c53d2dd5ba6b1cfb55bd42ea0783f051.png', 'L2', '0', '日本皇室专供，内野制造商出品');
INSERT INTO `nideshop_category` VALUES ('1008002', '布艺软装', '', '换个软装，换个家', '1005000', '6', '4', '1', 'http://yanxuan.nosdn.127.net/8bbcd7de60a678846664af998f57e71c.png', '', '', 'http://yanxuan.nosdn.127.net/2e2fb4f2856a021bbcd1b4c8400f2b06.png', 'L2', '0', '各种风格软装装点你的家');
INSERT INTO `nideshop_category` VALUES ('1008003', '鞋', '', '百搭造型，舒适脚感，久穿不累', '1008000', '4', '4', '1', 'http://yanxuan.nosdn.127.net/4316c2d05745bc90d1f333e363e571bd.png', '', '', 'http://yanxuan.nosdn.127.net/85566d138ea55e6aaeda2cda02df66f8.png', 'L2', '0', '一双好鞋，才能带你到远方');
INSERT INTO `nideshop_category` VALUES ('1008004', '袜子', '', '优选面料，精细做工，越是细节之物，越显品质之处', '1010000', '4', '4', '1', 'http://yanxuan.nosdn.127.net/f123c74f54d9acff0bd1546c60034814.png', '', '', 'http://yanxuan.nosdn.127.net/13f256bac02bb27d74e035ad25cbd375.png', 'L2', '0', '新百伦、阿迪达斯等制造商出品');
INSERT INTO `nideshop_category` VALUES ('1008005', '户外', '', '踏青出游，便携不误好心情', '1012000', '7', '8', '1', 'http://yanxuan.nosdn.127.net/83d22ca3d1c8f94ee23ca96de489864c.png', '', '', 'http://yanxuan.nosdn.127.net/833476fc3ecc30a7446279b787328775.png', 'L2', '0', 'MUJI、Nike等制造商出品');
INSERT INTO `nideshop_category` VALUES ('1008006', '口罩', '', '权威数据认证效果，防霾有底气', '1012000', '6', '6', '1', 'http://yanxuan.nosdn.127.net/9b93e661ff59cbda6094e8b30a63724e.png', '', '', 'http://yanxuan.nosdn.127.net/11d9700da759f2c962c2f6d9412ac2a1.png', 'L2', '0', '为你遮挡雾霾');
INSERT INTO `nideshop_category` VALUES ('1008007', '围巾件套', '', '严选好材料，亲肤柔软，防风抗寒，温暖不失风度', '1008000', '7', '6', '1', 'http://yanxuan.nosdn.127.net/3a8c7ae5b9dc5c1c4b7f2b656abb0279.png', '', '', 'http://yanxuan.nosdn.127.net/6beb3fd67106e42dc0f026b173373d16.png', 'L2', '0', '围上它，你的造型才完整');
INSERT INTO `nideshop_category` VALUES ('1008008', '被枕', '', '选用优质材料，确保好芯', '1005000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/927bc33f7ae2895dd6c11cf91f5e3228.png', '', '', 'http://yanxuan.nosdn.127.net/b43ef7cececebe6292d2f7f590522e05.png', 'L2', '0', '守护你的睡眠时光');
INSERT INTO `nideshop_category` VALUES ('1008009', '床品件套', '', '严格用料，亲肤舒适', '1005000', '4', '3', '1', 'http://yanxuan.nosdn.127.net/243e5bf327a87217ad1f54592f0176ec.png', '', '', 'http://yanxuan.nosdn.127.net/81f671bd36bce05d5f57827e5c88dd1b.png', 'L2', '0', 'MUJI等品牌制造商出品');
INSERT INTO `nideshop_category` VALUES ('1008010', '拖鞋', '', '人体工学设计，放松双脚', '1008000', '6', '5', '1', 'http://yanxuan.nosdn.127.net/1121696544ed9b0c2a70e82f1088fa0e.png', '', '', 'http://yanxuan.nosdn.127.net/984ddb9671aab41651784ba55b2cbdcf.png', 'L2', '0', '穿上拖鞋，回到自我');
INSERT INTO `nideshop_category` VALUES ('1008011', '清洁保鲜', '', '让厨房整洁又新鲜，防尘防潮', '1005001', '6', '6', '1', 'http://yanxuan.nosdn.127.net/dc4d6c35b9f4abb42d2eeaf345710589.png', '', '', 'http://yanxuan.nosdn.127.net/04cd632e1589adcc4345e40e8ad75d2b.png', 'L2', '0', '真空保鲜，美味不限时');
INSERT INTO `nideshop_category` VALUES ('1008012', '功能厨具', '', '日日使用的物件，制作精良才能更耐用', '1005001', '3', '3', '1', 'http://yanxuan.nosdn.127.net/22db4ccbf52dc62c723ac83aa587812a.png', '', '', 'http://yanxuan.nosdn.127.net/5b94463017437467a93ae4af17c2ba4f.png', 'L2', '0', '下厨省力小帮手');
INSERT INTO `nideshop_category` VALUES ('1008013', '茶具咖啡具', '', '好茶配好器', '1005001', '5', '5', '1', 'http://yanxuan.nosdn.127.net/9ea192cd2719c8348f42ec17842ba763.png', '', '', 'http://yanxuan.nosdn.127.net/be3ba4056e274e311d1c23bd2931018d.png', 'L2', '0', '先进工艺制造，功夫体验');
INSERT INTO `nideshop_category` VALUES ('1008014', '糖巧', '', '优选健康原料，甜食也吃得放心', '1005002', '3', '3', '1', 'http://yanxuan.nosdn.127.net/db48a1db4daab74233656caaea4a06f3.png', '', '', 'http://yanxuan.nosdn.127.net/c12cf29b574c7e9d1fcff6a57a12eea2.png', 'L2', '0', '糖心蜜意，甜而不腻');
INSERT INTO `nideshop_category` VALUES ('1008015', '糕点', '', '无人工添加香精、防腐剂', '1005002', '1', '1', '1', 'http://yanxuan.nosdn.127.net/93168242df456b5f7bf3c89653b3db76.png', '', '', 'http://yanxuan.nosdn.127.net/66ea1d6ad602a8e441af7cada93bdc7a.png', 'L2', '0', '四季糕点，用心烘焙');
INSERT INTO `nideshop_category` VALUES ('1008016', '灯具', '', '极简主义，贴近生活的设计', '1005000', '8', '6', '1', 'http://yanxuan.nosdn.127.net/c48e0d9dcfac01499a437774a915842b.png', '', '', 'http://yanxuan.nosdn.127.net/f702dc399d14d4e1509d5ed6e57acd19.png', 'L2', '0', '一盏灯，温暖一个家');
INSERT INTO `nideshop_category` VALUES ('1008017', '收纳', '', '智慧收纳，抗菌防霉，便利拆卸，小空间的大智慧', '1012000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/fdc048e1bf4f04d1c20b32eda5d1dc6e.png', '', '', 'http://yanxuan.nosdn.127.net/2a62f6c53f4ff089fa6a210c7a0c2e63.png', 'L2', '0', '选自古驰竹柄原料供应商');
INSERT INTO `nideshop_category` VALUES ('1008018', '单肩包', '', '匠心制版，立体有型', '1008000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/2f71c7710f0bf857e787e1adb449c8a2.png', '', '', 'http://yanxuan.nosdn.127.net/55f34f23ed31f31e1313ff33602f90cc.png', 'L2', '0', '单肩装上惬意心情');
INSERT INTO `nideshop_category` VALUES ('1009000', '日用清洁', '', '天然材料，温和去除污垢', '1013001', '6', '6', '1', 'http://yanxuan.nosdn.127.net/e071686c212e93aa2fcafd0062a9c613.png', '', '', 'http://yanxuan.nosdn.127.net/729638bb13997f9c4c435b41ce6ed910.png', 'L2', '0', '洁净才能带来清爽心情');
INSERT INTO `nideshop_category` VALUES ('1010000', '服装', '', '贴身的，要亲肤', '0', '5', '4', '1', 'http://yanxuan.nosdn.127.net/003e1d1289f4f290506ac2aedbd09d35.jpg', 'http://yanxuan.nosdn.127.net/28a685c96f91584e7e4876f1397767db.png', '//nos.netease.com/yanxuan/135113d6a43536b717063413fa24d69a.jpg', 'http://yanxuan.nosdn.127.net/622c8d79292154017b0cbda97588a0d7.png', 'L1', '0', '贴身的，要亲肤');
INSERT INTO `nideshop_category` VALUES ('1010001', '内衣', '', '自然染料，亲肤舒适', '1010000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/20279e1753e4eedc6e347857acda9681.png', '', '', 'http://yanxuan.nosdn.127.net/02fede55aba1bc6c9d7f7c01682f9e2d.png', 'L2', '0', '给你贴身的关怀');
INSERT INTO `nideshop_category` VALUES ('1010002', '内裤', '', '透气洁净，环保染制', '1010000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/364269344ed69adafe1b70ab7998fc50.png', '', '', 'http://yanxuan.nosdn.127.net/0a7fe0a08c195ca2cf55d12cd3c30f09.png', 'L2', '0', '来自李维斯、爱慕等制造商');
INSERT INTO `nideshop_category` VALUES ('1010003', '地垫', '', '手工编织，时尚环保', '1005000', '5', '4', '1', 'http://yanxuan.nosdn.127.net/83d4c87f28c993af1aa8d3e4d30a2fa2.png', '', '', 'http://yanxuan.nosdn.127.net/1611ef6458e244d1909218becfe87c4d.png', 'L2', '0', '家里的第“五”面墙');
INSERT INTO `nideshop_category` VALUES ('1010004', '双肩包', '', '精巧设计，严选全程监制', '1008000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/5197c44b610d786796f955334b55c7a5.png', '', '', 'http://yanxuan.nosdn.127.net/506d19510c967ba137283035a93738a1.png', 'L2', '0', '背上的时髦');
INSERT INTO `nideshop_category` VALUES ('1011000', '婴童', '', '爱，从心开始', '0', '7', '6', '1', 'http://yanxuan.nosdn.127.net/7dc78383e44df530f543659a977740de.jpg', 'http://yanxuan.nosdn.127.net/1ba9967b8de1ac50fad21774a4494f5d.png', '//nos.netease.com/yanxuan/8ab3c73fe90951a942e8b06d848f8743.jpg', 'http://yanxuan.nosdn.127.net/9cc0b3e0d5a4f4a22134c170f10b70f2.png', 'L1', '0', '爱，从心开始');
INSERT INTO `nideshop_category` VALUES ('1011001', '妈咪', '', '孕育生命的你更值得被爱', '1011000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/720aebaa529df9391b95a078dfb2fd5c.png', '', '', 'http://yanxuan.nosdn.127.net/844e2f4dce94f71283840c141d4ca71b.png', 'L2', '0', '犬印、Harvest Hills制造商');
INSERT INTO `nideshop_category` VALUES ('1011002', '海外', '', '海外供应商直供，零关税、零风险、即时达', '1012000', '5', '5', '1', 'http://yanxuan.nosdn.127.net/da884ff3b9e9d5276986c99e85722461.png', '', '', 'http://yanxuan.nosdn.127.net/fd1de05d274222f1e56d057d2f2c20c6.png', 'L2', '0', '来自海外制造商的好物');
INSERT INTO `nideshop_category` VALUES ('1011003', '床垫', '', '助你拥有舒眠好梦', '1005000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/316afeb3948b295dfe073e4c51f77a42.png', '', '', 'http://yanxuan.nosdn.127.net/d6e0e84961032fc70fd52a8d4d0fb514.png', 'L2', '0', '承托你的好时光');
INSERT INTO `nideshop_category` VALUES ('1011004', '家饰', '', '点缀美好生活，品质在于细节', '1005000', '9', '7', '1', 'http://yanxuan.nosdn.127.net/ab0df9445d985bf6719ac415313a8e88.png', '', '', 'http://yanxuan.nosdn.127.net/79275db76b5865e6167b0fbd141f2d7e.png', 'L2', '0', '装饰你的家');
INSERT INTO `nideshop_category` VALUES ('1012000', '杂货', '', '解忧，每个烦恼', '0', '8', '7', '1', 'http://yanxuan.nosdn.127.net/d233a1a9060a22e8eb0e2b326252eece.jpg', 'http://yanxuan.nosdn.127.net/c2a3d6349e72c35931fe3b5bcd0966be.png', '//nos.netease.com/yanxuan/a0c91ae573079830743dec6ee08f5841.jpg', 'http://yanxuan.nosdn.127.net/547853361d29a37282f377b9a755dd37.png', 'L1', '0', '解忧，每个烦恼');
INSERT INTO `nideshop_category` VALUES ('1012001', '功能箱包', '', '箱子里装着你的生活', '1008000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/3050a2b3052d766c4b460d4b766353a3.png', '', '', 'http://yanxuan.nosdn.127.net/0645dcda6172118f9295630c2a6f234f.png', 'L2', '0', '范思哲、Coach等品牌制造商出品');
INSERT INTO `nideshop_category` VALUES ('1012002', '雨具', '', '玻璃纤维伞骨，稳定抗风', '1012000', '4', '4', '1', 'http://yanxuan.nosdn.127.net/4e929a21baebdb1200361d8097e35e45.png', '', '', 'http://yanxuan.nosdn.127.net/589da0f02917b8393197a43175764381.png', 'L2', '0', 'WPC制作商出品');
INSERT INTO `nideshop_category` VALUES ('1012003', '文具', '', '极简设计，环保材质', '1012000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/e1743239e41ca9af76875aedc73be7f0.png', '', '', 'http://yanxuan.nosdn.127.net/e074795f61a83292d0f20eb7d124e2ac.png', 'L2', '0', '找回书写的力量');
INSERT INTO `nideshop_category` VALUES ('1013000', '靴', '', 'UGG制造商出品', '1008000', '5', '5', '1', 'http://yanxuan.nosdn.127.net/868c2a976719cd508e9ddf807167a446.png', '', '', 'http://yanxuan.nosdn.127.net/59485f1aa100e4210e16175f3412fa41.png', 'L2', '0', '经典的温暖');
INSERT INTO `nideshop_category` VALUES ('1013001', '洗护', '', '亲肤之物，严选天然', '0', '6', '5', '1', 'http://yanxuan.nosdn.127.net/ef8c49f8c92d1f86eb76dec0b5bc7cef.jpg', 'http://yanxuan.nosdn.127.net/9fe068776b6b1fca13053d68e9c0a83f.png', '//nos.netease.com/yanxuan/14bb4a29498a0f93a1ea001f26fea1dd.jpg', 'http://yanxuan.nosdn.127.net/1526ab0f5982722adbc8726f9f2a338c.png', 'L1', '0', '亲肤之物，严选天然');
INSERT INTO `nideshop_category` VALUES ('1013002', '美妆', '', '竹宝堂、资生堂等制造商出品', '1013001', '3', '3', '1', 'http://yanxuan.nosdn.127.net/aa49c088f74a1c318f1765cc2703495a.png', '', '', 'http://yanxuan.nosdn.127.net/d6a7b9a2eb6af92d709429798a4ca3ea.png', 'L2', '0', '为你的面容添色');
INSERT INTO `nideshop_category` VALUES ('1013003', '护发', '', '护发超有效小秘诀', '1013001', '5', '5', '1', 'http://yanxuan.nosdn.127.net/672ddbed88d9762d2be789080880b16a.png', '', '', 'http://yanxuan.nosdn.127.net/398375d0e39574c6e87273d328316186.png', 'L2', '0', '呵护秀发，柔顺不同发质');
INSERT INTO `nideshop_category` VALUES ('1013004', '香薰', '', '提炼纯净，清雅不腻', '1013001', '2', '2', '1', 'http://yanxuan.nosdn.127.net/d43e7af0a6a9385d88be2ca1df679158.png', '', '', 'http://yanxuan.nosdn.127.net/fc7764ff8e12d18f6c5881a32318ed16.png', 'L2', '0', '爱马仕集团制造商出品');
INSERT INTO `nideshop_category` VALUES ('1013005', '刀剪砧板', '', '厨房实用利器', '1005001', '7', '7', '1', 'http://yanxuan.nosdn.127.net/9d481ea4c2e9e6eda35aa720d407332e.png', '', '', 'http://yanxuan.nosdn.127.net/555afbfe05dab48c1a3b90dcaf89b4f2.png', 'L2', '0', '传统工艺 源自中国刀城');
INSERT INTO `nideshop_category` VALUES ('1013006', '家居服', '', '居家休闲必备', '1010000', '6', '6', '1', 'http://yanxuan.nosdn.127.net/71f391af17fce739a6a57a1eeadbcbf0.png', '', '', 'http://yanxuan.nosdn.127.net/5da102ea4c64081ce3a05a91c855fbc9.png', 'L2', '0', '舒适亲肤');
INSERT INTO `nideshop_category` VALUES ('1015000', '家具', '', '一级原木，严苛工艺', '1005000', '7', '5', '1', 'http://yanxuan.nosdn.127.net/4f00675caefd0d4177892ad18bfc2df6.png', '', '', 'http://yanxuan.nosdn.127.net/d5d41841136182bf49c1f99f5c452dd6.png', 'L2', '0', '大师级工艺');
INSERT INTO `nideshop_category` VALUES ('1015001', 'T恤', '', '立体裁剪，专为国人打造', '1010000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/24a7a33cfeac0bb87a737480db79e053.png', '', '', 'http://yanxuan.nosdn.127.net/505c9a5a794b79e85fef4654722b3447.png', 'L2', '0', '自在而潇洒的穿着感');
INSERT INTO `nideshop_category` VALUES ('1017000', '宠物', '', '出口品质，严选贴合萌宠生活习惯用品。', '1005000', '10', '8', '1', 'http://yanxuan.nosdn.127.net/a0352c57c60ce4f68370ecdab6a30857.png', '', '', 'http://yanxuan.nosdn.127.net/dae4d6e89ab8a0cd3e8da026e4660137.png', 'L2', '0', '抑菌除味，打造宠物舒适空间');
INSERT INTO `nideshop_category` VALUES ('1018000', '夏日甜心', '', '湖南卫视《夏日甜心》授权，独家发售大猫熊同款周边', '1019000', '10', '10', '1', 'http://yanxuan.nosdn.127.net/b5e9f174404ef81b8603d6ecc304c62e.png', '', '', 'http://yanxuan.nosdn.127.net/2b8497fe583d3c9759128b2d76f89dfd.png', 'L2', '0', '湖南卫视《夏日甜心》周边');
INSERT INTO `nideshop_category` VALUES ('1019000', '志趣', '', '爱好，点缀生活', '0', '10', '9', '1', 'http://yanxuan.nosdn.127.net/99107fbd76eb66cd537213e478189ae1.png', 'http://yanxuan.nosdn.127.net/7093cfecb9dde1dd3eaf459623df4071.png', '//nos.netease.com/yanxuan/72de912b6350b33ecf88a27498840e62.jpg', 'http://yanxuan.nosdn.127.net/1706e24a5e605870ba3b37ff5f49aa18.png', 'L1', '0', '周边精品，共享热爱');
INSERT INTO `nideshop_category` VALUES ('1020000', '出行用品', '', '便携设计，轻便旅途', '1012000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/b29a11afa76b9f4a57131555f1a54c77.png', '', '', 'http://yanxuan.nosdn.127.net/81e18c6970a7809ee0d86f0545428aa4.png', 'L2', '0', '出行小物，贴心相伴');
INSERT INTO `nideshop_category` VALUES ('1020001', '面部护理', '', '天然成分，无化学添加', '1013001', '4', '4', '1', 'http://yanxuan.nosdn.127.net/f73df75f334126cf1f3823696ea0663c.png', '', '', 'http://yanxuan.nosdn.127.net/babf6573f8acd53f21205a7577ec03e1.png', 'L2', '0', '温和无刺激的呵护');
INSERT INTO `nideshop_category` VALUES ('1020002', '用具', '', '环保材料，耐用不发霉', '1013001', '7', '7', '1', 'http://yanxuan.nosdn.127.net/1a851b2b3c9e16bdfd020a5fc03e9140.png', '', '', 'http://yanxuan.nosdn.127.net/4e3aebbd7ffef5bb250d19f13cb85620.png', 'L2', '0', '小工具成就美好浴室');
INSERT INTO `nideshop_category` VALUES ('1020003', '服饰', '', '100%纯棉，无荧光剂，严格质检', '1011000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/4e50f3c4e4d0a64cd0ad14cfc0b6bd17.png', '', '', 'http://yanxuan.nosdn.127.net/004f5f96df4aeb0645abbd70c0637239.png', 'L2', '0', '萌宝穿搭，柔软舒适触感');
INSERT INTO `nideshop_category` VALUES ('1020004', '婴童洗护', '', '给孩子更美好的童年体验', '1011000', '5', '5', '1', 'http://yanxuan.nosdn.127.net/c55338691ebd46bee9ebf225f80363ce.png', '', '', 'http://yanxuan.nosdn.127.net/f2e301b189befff1d99adf917ba8ce20.png', 'L2', '0', '天然，呵护宝宝肌肤');
INSERT INTO `nideshop_category` VALUES ('1020005', '寝居', '', '始于初心，为爱初色', '1011000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/0f3c5ad63139096fd0760219e12149af.png', '', '', 'http://yanxuan.nosdn.127.net/476995896abea91d3f2e9ec20d56bd8d.png', 'L2', '0', '无荧光剂，婴幼儿A类标准');
INSERT INTO `nideshop_category` VALUES ('1020006', '玩具', '', '严选材质，安全无害保证', '1011000', '4', '4', '1', 'http://yanxuan.nosdn.127.net/7aac7c5819f71345a52a4b9df23d6239.png', '', '', 'http://yanxuan.nosdn.127.net/34b3267efcddad09cd652f181d87aab0.png', 'L2', '0', '萌宝童趣必备');
INSERT INTO `nideshop_category` VALUES ('1020007', '喂养', '', '安全健康，我们执着于每个细节', '1011000', '6', '6', '1', 'http://yanxuan.nosdn.127.net/5db40a5bf84c177515610471d4d08687.png', '', '', 'http://yanxuan.nosdn.127.net/6b6f1672fe041594245fe56a5dd80871.png', 'L2', '0', '宝宝吃得香，妈妈才放心');
INSERT INTO `nideshop_category` VALUES ('1020008', '配饰', '', '优选设计，让细节显示好品味', '1008000', '8', '7', '1', 'http://yanxuan.nosdn.127.net/d835a76e56a88905194f543b67089b4b.png', '', '', 'http://yanxuan.nosdn.127.net/57ce29ca06f592d65aabfa5f0f87ad43.png', 'L2', '0', '与众不同的点睛之笔');
INSERT INTO `nideshop_category` VALUES ('1020009', '外衣', '', '外衣，是你面对这个世界的铠甲', '1010000', '10', '10', '1', 'http://yanxuan.nosdn.127.net/883d89e54a9287569a201eca388a7cda.png', '', '', 'http://yanxuan.nosdn.127.net/647f7c39eb7c353958274a59fd821d03.png', 'L2', '0', '穿出时尚感');
INSERT INTO `nideshop_category` VALUES ('1020010', '衬衫', '', '挺拔而不束缚', '1010000', '7', '7', '1', 'http://yanxuan.nosdn.127.net/94aa4a4814e2a7a97639438f1d52dcee.png', '', '', 'http://yanxuan.nosdn.127.net/7927f8422c341f7353041a30d01045a2.png', 'L2', '0', '细节讲究，合身剪裁');
INSERT INTO `nideshop_category` VALUES ('1021000', '节日礼盒', '', '遇见节日的美好', '1012000', '8', '9', '1', 'http://yanxuan.nosdn.127.net/e7b37b1ed5c18d63dc3e6c3f1aa85d8a.png', '', '', 'http://yanxuan.nosdn.127.net/bbb6f0ab4f6321121250c12583b0ff9a.png', 'L2', '0', '限量礼盒限时发售');
INSERT INTO `nideshop_category` VALUES ('1022000', '数码', '', '享受安全智能的科技生活', '1008000', '9', '9', '1', 'http://yanxuan.nosdn.127.net/3ec003761d346bc866de2ec249d7ff19.png', '', '', 'http://yanxuan.nosdn.127.net/c33b13875a86da535c935e3d454a6fd2.png', 'L2', '0', '智能硬件，匠心出品');
INSERT INTO `nideshop_category` VALUES ('1023000', '厨房小电', '', '省心省力，厨房高效能手', '1005001', '8', '8', '1', 'http://yanxuan.nosdn.127.net/521bd0c02d283b80ba49e73ca84df250.png', '', '', 'http://yanxuan.nosdn.127.net/c09d784ba592e4fadabbaef6b2e95a95.png', 'L2', '0', '厨房里的省心小电器');
INSERT INTO `nideshop_category` VALUES ('1025000', '礼品卡', '', '传递高品质生活美学', '1019000', '11', '11', '1', 'http://yanxuan.nosdn.127.net/bb9232716b2fc96d9bdbac4955360dfa.png', '', '', 'http://yanxuan.nosdn.127.net/1266f0767a3f67298a40574df0d177fb.png', 'L2', '0', '送礼、福利首选');
INSERT INTO `nideshop_category` VALUES ('1027000', '茗茶', '', '一品茶香，品茗即是观心，饮茶涤净尘虑', '1005002', '7', '7', '1', 'http://yanxuan.nosdn.127.net/0c5af0575176c4a3023783bef7a87a0f.png', '', '', 'http://yanxuan.nosdn.127.net/cfeb623929f3936cc882ffc6a9a2e927.png', 'L2', '0', '一品茶香，品茗即是观心，饮茶涤净尘虑');
INSERT INTO `nideshop_category` VALUES ('1027001', '果干', '', '品尝与收获到的是自然的味道', '1005002', '4', '4', '1', 'http://yanxuan.nosdn.127.net/60f4ae2beef4754347fa36208f84efab.png', '', '', 'http://yanxuan.nosdn.127.net/4cdbf6ae196671cca154fe16e152d8d4.png', 'L2', '0', '品尝与收获到的是自然的味道');
INSERT INTO `nideshop_category` VALUES ('1028001', '唱片', '', '瑞鸣音乐大师匠心打造', '1019000', '8', '8', '1', 'http://yanxuan.nosdn.127.net/71feb3efd3eaee01a74e8aa78430de9d.png', '', '', 'http://yanxuan.nosdn.127.net/3b69079ea27f90b4f539e8c3b76680f5.png', 'L2', '0', '经典音乐，用心典藏，瑞鸣音乐大师匠心打造');
INSERT INTO `nideshop_category` VALUES ('1032000', '魔兽世界', '', '魔兽世界周边', '1019000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/336f0186a9920eb0f93a3912f3662ffe.png', '', '', 'http://yanxuan.nosdn.127.net/becfba90e8a5c95d403b8a6b9bb77825.png', 'L2', '0', '艾泽拉斯的冒险，才刚刚开始');
INSERT INTO `nideshop_category` VALUES ('1032001', '炉石传说', '', '炉石传说周边', '1019000', '2', '2', '1', 'http://yanxuan.nosdn.127.net/97937fcf2defb864d9e53d98a337d78a.png', '', '', 'http://yanxuan.nosdn.127.net/b5af3f6bfcbeb459d6c448ba87f8cc35.png', 'L2', '0', '快进来坐下吧，看看酒馆的新玩意');
INSERT INTO `nideshop_category` VALUES ('1032002', '守望先锋', '', '守望先锋周边', '1019000', '3', '3', '1', 'http://yanxuan.nosdn.127.net/8cab7bf1225dc9893bd9de06fc51921d.png', '', '', 'http://yanxuan.nosdn.127.net/a562f05bf38f5ee478fefb81856aad3d.png', 'L2', '0', '物美价廉的补给箱');
INSERT INTO `nideshop_category` VALUES ('1032003', '暗黑破坏神III', '', '暗黑破坏神III周边', '1019000', '4', '4', '1', 'http://yanxuan.nosdn.127.net/8fe4eb999f748236228a73e09878e277.png', '', '', 'http://yanxuan.nosdn.127.net/1e19e948de63a1d0895a8620250c441f.png', 'L2', '0', '奈非天们，停下脚步整理下行囊');
INSERT INTO `nideshop_category` VALUES ('1032004', '星际争霸II', '', '星际争霸II周边', '1019000', '5', '5', '1', 'http://yanxuan.nosdn.127.net/433ff879a3686625535ca0304be22ab2.png', '', '', 'http://yanxuan.nosdn.127.net/7394ce778791ae8242013d6c974f47e0.png', 'L2', '0', '记录科普卢星区的战斗时光');
INSERT INTO `nideshop_category` VALUES ('1032005', '风暴英雄', '', '风暴英雄周边', '1019000', '6', '6', '1', 'http://yanxuan.nosdn.127.net/e091aae0c8cafc5ab48dfabcc52c79b6.png', '', '', 'http://yanxuan.nosdn.127.net/ff1e28fb7151008f8dc46bbf8b357f63.png', 'L2', '0', '时空枢纽，是个充满惊喜的地方');
INSERT INTO `nideshop_category` VALUES ('1033000', '梦幻西游', '', '梦幻西游精品周边', '1019000', '7', '7', '1', 'http://yanxuan.nosdn.127.net/f0698297aaac41b778c1ea65eefb8b34.png', '', '', 'http://yanxuan.nosdn.127.net/36711325781ca50fdfe234489fca973e.png', 'L2', '0', '梦幻西游精品周边');
INSERT INTO `nideshop_category` VALUES ('1034000', '丝袜', '', '厚木制造商，专利冰丝', '1010000', '5', '5', '1', 'http://yanxuan.nosdn.127.net/d82d0bacfd7243c2ad09dbf2513cfcf9.png', '', '', 'http://yanxuan.nosdn.127.net/4f8f86dfd1d4b46a9cf783b4980db47f.png', 'L2', '0', '厚木制造商，专利冰丝');
INSERT INTO `nideshop_category` VALUES ('1034001', '童车童椅', '', '安全舒适，给宝宝一个快乐童年', '1011000', '7', '7', '1', 'http://yanxuan.nosdn.127.net/06bbfb293b6194b27ebdb3350203a1f7.png', '', '', 'http://yanxuan.nosdn.127.net/4d16871eb80dac59d1796c7d806a5cea.png', 'L2', '0', '安全舒适，给宝宝一个快乐童年');
INSERT INTO `nideshop_category` VALUES ('1035000', '卫衣', '', '舒适百搭，时尚选择', '1010000', '9', '9', '1', 'http://yanxuan.nosdn.127.net/97bb55280b8ffa40390f2ee36486314a.png', '', '', 'http://yanxuan.nosdn.127.net/0282a81bbcae6c39918808fe7c4e1b93.png', 'L2', '0', '舒适百搭，时尚选择');
INSERT INTO `nideshop_category` VALUES ('1035001', '毛衣', '', '温暖柔软，品质之选', '1010000', '8', '8', '1', 'http://yanxuan.nosdn.127.net/cc886f16c8b9893305f1b3b6ad4eb0b1.png', '', '', 'http://yanxuan.nosdn.127.net/b610b058cfd73a9211dc890b7b0cbc66.png', 'L2', '0', '温暖柔软，品质之选');
INSERT INTO `nideshop_category` VALUES ('1035002', '裤装', '', '高质感面料', '1010000', '11', '11', '1', 'http://yanxuan.nosdn.127.net/a3906045b1367d70f658ce9de03e8193.png', '', '', 'http://yanxuan.nosdn.127.net/1728b4eeaa7a3928f5416884f0e75b1c.png', 'L2', '0', '高质感面料，休闲商务两相宜');
INSERT INTO `nideshop_category` VALUES ('1035003', '肉制品', '', '真嗜肉者，都爱这一味，或麻辣鲜香、或五味俱全，都是佳肴美馔真滋味', '1005002', '8', '8', '1', 'http://yanxuan.nosdn.127.net/db3e11b8a6974a253818ae0d6fb2d24e.png', '', '', 'http://yanxuan.nosdn.127.net/94480324b376a51af47cf92df70d1ade.png', 'L2', '0', '真嗜肉者，都爱这一味，佳肴美馔真滋味');
INSERT INTO `nideshop_category` VALUES ('1036000', '夏凉', '', '夏凉床品，舒适一夏', '1005000', '1', '1', '1', 'http://yanxuan.nosdn.127.net/13ff4decdf38fe1a5bde34f0e0cc635a.png', '', '', 'http://yanxuan.nosdn.127.net/bd17c985bacb9b9ab1ab6e9d66ee343c.png', 'L2', '0', '夏凉床品，舒适一夏');
INSERT INTO `nideshop_category` VALUES ('1036001', '眼镜', '', '实用加时尚，造型百搭单品', '1012000', '9', '10', '1', 'http://yanxuan.nosdn.127.net/97f5f75ea1209dfbb85e91932d26c3ed.png', '', '', 'http://yanxuan.nosdn.127.net/c25fb420ccb6f692a2d16f1740b60d21.png', 'L2', '0', '实用加时尚，造型百搭单品');
INSERT INTO `nideshop_category` VALUES ('1036002', '汽车用品', '', '给你的爱车添装备', '1012000', '10', '10', '1', 'http://yanxuan.nosdn.127.net/382cda1ef9cca77d99bcef05070d7db0.png', '', '', 'http://yanxuan.nosdn.127.net/552e943e585a999169fdbc57b59524d6.png', 'L2', '0', '给你的爱车添装备');
INSERT INTO `nideshop_category` VALUES ('1036003', '调味', '', '烹饪必备，美食调味', '1005002', '9', '9', '1', 'http://yanxuan.nosdn.127.net/2ae44a3944f2bc737416e1cff3d4bcef.png', '', '', 'http://yanxuan.nosdn.127.net/13d58949a8c72ec914b5ef63ac726a43.png', 'L2', '0', '烹饪必备，美食调味');
INSERT INTO `nideshop_category` VALUES ('1036004', '大话西游', '', '大话西游正版周边', '1019000', '9', '8', '1', 'http://yanxuan.nosdn.127.net/b60618db213322bdc2c5b1208655bd7e.png', '', '', 'http://yanxuan.nosdn.127.net/470a017f508e9a18f3068be7b315e14b.png', 'L2', '0', '大话西游正版周边');

-- ----------------------------
-- Table structure for `nideshop_channel`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_channel`;
CREATE TABLE `nideshop_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `icon_url` varchar(255) NOT NULL DEFAULT '',
  `sort_order` int(4) unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_channel
-- ----------------------------
INSERT INTO `nideshop_channel` VALUES (1, '居家', '/pages/category/category?id=1005000', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/1508205806587c.png', 1);
INSERT INTO `nideshop_channel` VALUES (2, '餐厨', '/pages/category/category?id=1005001', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/1509505811a78d.png', 2);
INSERT INTO `nideshop_channel` VALUES (3, '配件', '/pages/category/category?id=1008000', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/1512165188bbba.png', 3);
INSERT INTO `nideshop_channel` VALUES (4, '服装', '/pages/category/category?id=1005002', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/151537891573ed.png', 4);
INSERT INTO `nideshop_channel` VALUES (5, '志趣', '/pages/category/category?id=1019000', 'https://platform-wxmall.oss-cn-beijing.aliyuncs.com/upload/20180727/151514826f7581.png', 5);

-- ----------------------------
-- Table structure for `nideshop_collect`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_collect`;
CREATE TABLE `nideshop_collect` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '用户Id',
  `value_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品Id',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `is_attention` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否提醒',
  `type_id` int(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `goods_id` (`value_id`),
  KEY `is_attention` (`is_attention`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `nideshop_comment`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_comment`;
CREATE TABLE `nideshop_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `type_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  `value_id` int(11) DEFAULT '0',
  `content` varchar(6550) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '储存为base64编码',
  `add_time` bigint(12) unsigned DEFAULT '0' COMMENT '记录时间',
  `status` tinyint(3) unsigned DEFAULT '0' COMMENT '状态',
  `user_id` int(11) DEFAULT '0' COMMENT '会员Id',
  PRIMARY KEY (`id`),
  KEY `id_value` (`value_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of nideshop_comment
-- ----------------------------
INSERT INTO `nideshop_comment` VALUES ('1', '0', '1152101', 'MTE=', '1504933578', '0', '15');

-- ----------------------------
-- Table structure for `nideshop_comment_picture`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_comment_picture`;
CREATE TABLE `nideshop_comment_picture` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `comment_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '评价Id',
  `pic_url` varchar(255) NOT NULL DEFAULT '' COMMENT '评价图片',
  `sort_order` tinyint(1) unsigned NOT NULL DEFAULT '5' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_comment_picture
-- ----------------------------

-- ----------------------------
-- Table structure for `nideshop_coupon`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_coupon`;
CREATE TABLE `nideshop_coupon` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT '',
  `type_money` decimal(10,2) DEFAULT '0.00',
  `send_type` tinyint(3) unsigned DEFAULT '0',
  `min_amount` decimal(10,2) unsigned DEFAULT '0.00',
  `max_amount` decimal(10,2) unsigned DEFAULT '0.00',
  `send_start_date` datetime DEFAULT NULL,
  `send_end_date` datetime DEFAULT NULL,
  `use_start_date` datetime DEFAULT NULL,
  `use_end_date` datetime DEFAULT NULL,
  `min_goods_amount` decimal(10,2) unsigned DEFAULT '0.00',
  `min_transmit_num` int(4) DEFAULT NULL COMMENT '转发次数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_coupon
-- ----------------------------
INSERT INTO `nideshop_coupon` VALUES ('1', '满100减10元', '10.00', '0', '100.00', '0.00', '2017-08-28 11:51:49', '2020-09-29 11:51:53', '2017-05-01 16:50:40', '2019-11-27 16:50:48', '500.00', null);
INSERT INTO `nideshop_coupon` VALUES ('2', '用户红包', '10.00', '1', '50.00', '0.00', '2017-08-28 11:50:51', '2020-12-02 11:50:56', '2017-06-14 11:50:56', '2020-12-02 11:50:56', '500.00', null);
INSERT INTO `nideshop_coupon` VALUES ('4', '新用户注册5元', '5.00', '4', '10.00', '0.00', '2017-08-28 11:50:51', '2020-12-02 11:50:56', '2017-06-14 11:50:56', '2020-12-02 11:50:56', '360.00', null);
INSERT INTO `nideshop_coupon` VALUES ('7', '满88元包邮', '0.00', '7', '88.00', '0.00', '2017-08-28 11:50:51', '2020-12-02 11:50:56', '2017-05-01 16:50:40', '2019-11-27 16:50:48', '0.00', null);
INSERT INTO `nideshop_coupon` VALUES ('8', '满1000减20元', '20.00', '0', '1000.00', '0.00', '2017-08-28 11:51:49', '2020-09-29 11:51:53', '2017-05-01 16:50:40', '2019-11-27 16:50:48', '500.00', null);
INSERT INTO `nideshop_coupon` VALUES ('9', '满20元减1元', '1.00', '6', '20.00', '0.00', '2017-08-28 11:51:49', '2020-09-29 11:51:53', '2017-05-01 16:50:40', '2019-11-27 16:50:48', '20.00', '10');

-- ----------------------------
-- Table structure for `nideshop_coupon_goods`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_coupon_goods`;
CREATE TABLE `nideshop_coupon_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `coupon_id` int(11) NOT NULL COMMENT '优惠券Id',
  `goods_id` int(11) NOT NULL COMMENT '商品id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='优惠券关联商品';

-- ----------------------------
-- Table structure for `nideshop_feedback`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_feedback`;
CREATE TABLE `nideshop_feedback` (
  `msg_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '会员Id',
  `user_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '会员会员名称',
  `mobile` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '手机',
  `feed_Type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '反馈类型',
  `content` text COLLATE utf8_unicode_ci NOT NULL COMMENT '详细内容',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `add_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '反馈时间',
  PRIMARY KEY (`msg_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of nideshop_feedback
-- ----------------------------
INSERT INTO `nideshop_feedback` VALUES ('1', '19', 'A0_不甘平凡的你', '11111111111', '2', '12', '1', '2017-10-05 23:16:21');
INSERT INTO `nideshop_feedback` VALUES ('2', '19', 'A0_不甘平凡的你', '15209831990', '2', '反馈的内容', '1', '2017-10-05 23:28:56');

-- ----------------------------
-- Table structure for `nideshop_footprint`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_footprint`;
CREATE TABLE `nideshop_footprint` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '会员Id',
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '记录时间',
  `referrer` int(11) DEFAULT NULL COMMENT '转发人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_footprint
-- ----------------------------

-- ----------------------------
-- Table structure for `nideshop_goods`
-- ----------------------------
DROP TABLE IF EXISTS `nideshop_goods`;
CREATE TABLE `nideshop_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned DEFAULT '0',
  `goods_sn` varchar(60) DEFAULT '',
  `name` varchar(120) NOT NULL DEFAULT '',
  `brand_id` int(11) unsigned DEFAULT '0',
  `goods_number` mediumint(8) unsigned DEFAULT '0',
  `keywords` varchar(255) DEFAULT '',
  `goods_brief` varchar(255) DEFAULT '',
  `goods_desc` text,
  `is_on_sale` tinyint(1) unsigned DEFAULT '1',
  `add_time` datetime DEFAULT NULL,
  `sort_order` smallint(4) unsigned DEFAULT '100',
  `is_delete` tinyint(1) unsigned DEFAULT '0',
  `attribute_category` int(11) unsigned DEFAULT '0',
  `counter_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '专柜价格',
  `extra_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '附加价格',
  `is_new` tinyint(1) unsigned DEFAULT '0',
  `goods_unit` varchar(45) DEFAULT NULL COMMENT '商品单位',
  `primary_pic_url` varchar(255) DEFAULT NULL COMMENT '商品主图',
  `list_pic_url` varchar(255) DEFAULT NULL COMMENT '商品列表图',
  `retail_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '零售价格',
  `sell_volume` int(11) unsigned DEFAULT '0' COMMENT '销售量',
  `primary_product_id` int(11) unsigned DEFAULT '0' COMMENT '主sku　product_id',
  `unit_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '单位价格，单价',
  `promotion_desc` varchar(255) DEFAULT NULL,
  `promotion_tag` varchar(45) DEFAULT NULL,
  `app_exclusive_price` decimal(10,2) unsigned DEFAULT NULL COMMENT 'APP专享价',
  `is_app_exclusive` tinyint(1) unsigned DEFAULT NULL COMMENT '是否是APP专属',
  `is_limited` tinyint(1) unsigned DEFAULT NULL,
  `is_hot` tinyint(1) unsigned DEFAULT '0',
  `market_price` decimal(10,2) DEFAULT '0.00',
  `create_user_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `update_user_id` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_user_dept_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `goods_sn` (`goods_sn`),
  KEY `cat_id` (`category_id`),
  KEY `brand_id` (`brand_id`),
  KEY `goods_number` (`goods_number`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB AUTO_INCREMENT=1181001 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nideshop_goods
-- ----------------------------
INSERT INTO `nideshop_goods` VALUES ('1006002', '1008009', '1006002', '轻奢纯棉刺绣水洗四件套', '0', '100', '', '设计师原款，精致绣花', '<p><img src=\"http://yanxuan.nosdn.127.net/2597f9e2e41093f50761837eb4c2e6be.jpg\" _src=\"http://yanxuan.nosdn.127.net/2597f9e2e41093f50761837eb4c2e6be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4377adc892bf9d16f9d0fd78f88a6986.jpg\" _src=\"http://yanxuan.nosdn.127.net/4377adc892bf9d16f9d0fd78f88a6986.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/986bd3a7517a356265049443cbb747d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/986bd3a7517a356265049443cbb747d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cdf3958b3a8d9982b879e3fea1fd616.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cdf3958b3a8d9982b879e3fea1fd616.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47e5be34ef476258f44f307982c705d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/47e5be34ef476258f44f307982c705d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2220e4cbb5ebc49e9cecb64176983d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2220e4cbb5ebc49e9cecb64176983d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dee62e466465b370c349e37fccd3b596.jpg\" _src=\"http://yanxuan.nosdn.127.net/dee62e466465b370c349e37fccd3b596.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c021b91f965ac022182eb03b2780e5de.jpg\" _src=\"http://yanxuan.nosdn.127.net/c021b91f965ac022182eb03b2780e5de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9f7afd9441928d7f670fd7879ba869d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9f7afd9441928d7f670fd7879ba869d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a73b69a2fefbd154a2a6ad45102b565.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a73b69a2fefbd154a2a6ad45102b565.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5836d918faa9b11eb8d9f97f9787cda9.jpg\" _src=\"http://yanxuan.nosdn.127.net/5836d918faa9b11eb8d9f97f9787cda9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8216a8addae2f02a5a570ef45d5ecffc.jpg\" _src=\"http://yanxuan.nosdn.127.net/8216a8addae2f02a5a570ef45d5ecffc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da382973dcb0e524a36519baab880204.jpg\" _src=\"http://yanxuan.nosdn.127.net/da382973dcb0e524a36519baab880204.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c6e84d49f74e228bc57934ec7b7500.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c6e84d49f74e228bc57934ec7b7500.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f1d0a20e54d3e2e59a44ffe44ebe405.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f1d0a20e54d3e2e59a44ffe44ebe405.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a39f2c7580ce5cadc62e8b39d58aca71.jpg\" _src=\"http://yanxuan.nosdn.127.net/a39f2c7580ce5cadc62e8b39d58aca71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c71dc416f04615b634d2b6cd0c4215ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/c71dc416f04615b634d2b6cd0c4215ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06ac26ed7d870c5c6f0ce3e07c629471.jpg\" _src=\"http://yanxuan.nosdn.127.net/06ac26ed7d870c5c6f0ce3e07c629471.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99b180d02726e0213e54dddf4b9b32fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/99b180d02726e0213e54dddf4b9b32fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97de8d2687052976e51fff40d04af2ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/97de8d2687052976e51fff40d04af2ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f527003599be237095995c98039ef87.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f527003599be237095995c98039ef87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec30289dc1b2beb4b84a08c02a97ef6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec30289dc1b2beb4b84a08c02a97ef6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/685da1eaddcd26e8e2a1ff4d5d83f29f.jpg\" _src=\"http://yanxuan.nosdn.127.net/685da1eaddcd26e8e2a1ff4d5d83f29f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2610f487a733a88973d101dcd1766ee1.jpg\" _src=\"http://yanxuan.nosdn.127.net/2610f487a733a88973d101dcd1766ee1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eab3633e648ab2e8412c6801feb6231e.jpg\" _src=\"http://yanxuan.nosdn.127.net/eab3633e648ab2e8412c6801feb6231e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b6c4f220592ea7d5af0072a816fe946.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b6c4f220592ea7d5af0072a816fe946.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/310a777685204ece08592a6e2716c6c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/310a777685204ece08592a6e2716c6c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/198239985c74597717e639089ffae25f.jpg\" _src=\"http://yanxuan.nosdn.127.net/198239985c74597717e639089ffae25f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dec6b498c899351fe94d99a6dde0ee79.jpg\" _src=\"http://yanxuan.nosdn.127.net/dec6b498c899351fe94d99a6dde0ee79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/516a17ca73846bc871902b298ce38a97.jpg\" _src=\"http://yanxuan.nosdn.127.net/516a17ca73846bc871902b298ce38a97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8231b81b5ba0e1c244074598c19f003.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8231b81b5ba0e1c244074598c19f003.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92c704dcf169e9a177a3c762a6a54a46.jpg\" _src=\"http://yanxuan.nosdn.127.net/92c704dcf169e9a177a3c762a6a54a46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b9294ad5f78d890453d4a225feed518.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b9294ad5f78d890453d4a225feed518.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9bb1b8fdfaa7f895bdd7d5c65c42a59b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9bb1b8fdfaa7f895bdd7d5c65c42a59b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f342e6d6b75dc1f80972feb415fd4e75.jpg\" _src=\"http://yanxuan.nosdn.127.net/f342e6d6b75dc1f80972feb415fd4e75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c9597cf206066861b3244f634c98e32.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c9597cf206066861b3244f634c98e32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/970d4dad7d958293fd41ec1f444684f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/970d4dad7d958293fd41ec1f444684f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f93819b03de07abef8b2d94f1d5c84b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f93819b03de07abef8b2d94f1d5c84b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58c8c56aac61da4ee9fcf34930b76e4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/58c8c56aac61da4ee9fcf34930b76e4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb6435ec714189d6ad5053bf12d41db7.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb6435ec714189d6ad5053bf12d41db7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19cc85ae097247d5d868df993de64e7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/19cc85ae097247d5d868df993de64e7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ab8e27757cabd39fccdb5fd8ef7b013.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ab8e27757cabd39fccdb5fd8ef7b013.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03e6f02f8f77b71a82a05dd1a9705057.jpg\" _src=\"http://yanxuan.nosdn.127.net/03e6f02f8f77b71a82a05dd1a9705057.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '23', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/599ee624350ecb9e70c32375c0cd4807.jpg', 'http://yanxuan.nosdn.127.net/8ab2d3287af0cefa2cc539e40600621d.png', '899.00', '168', '1006003', '0.00', '限时购', '', '0.00', '0', '0', '0', '988.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1006007', '1008008', '1006007', '秋冬保暖加厚澳洲羊毛被', '0', '100', '', '臻品级澳洲进口羊毛', '<p><img src=\"http://yanxuan.nosdn.127.net/c78ec6e16d8477525c0a59e3c9d847b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c78ec6e16d8477525c0a59e3c9d847b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/294185760b75f364f6ed42784877e59c.jpg\" _src=\"http://yanxuan.nosdn.127.net/294185760b75f364f6ed42784877e59c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2468d1851e29930cc3802f125da5d6e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2468d1851e29930cc3802f125da5d6e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0794791277945c1577776724778124f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/0794791277945c1577776724778124f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6973ca1e6f264620d5d25e581a0d623d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6973ca1e6f264620d5d25e581a0d623d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26f01273c833c2ae75177a5c8d9310ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/26f01273c833c2ae75177a5c8d9310ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf0207da5160588acf58d0f02ea9d360.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf0207da5160588acf58d0f02ea9d360.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbd5d5171a309344d05663952930441f.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbd5d5171a309344d05663952930441f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7a65ac0824fc1584c2f1943ed1eaed0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7a65ac0824fc1584c2f1943ed1eaed0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88871ed9eccf7fbdfccf7912bb8f9d21.jpg\" _src=\"http://yanxuan.nosdn.127.net/88871ed9eccf7fbdfccf7912bb8f9d21.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7aa0e4c0abeb157e231b17e91cfa8f02.jpg\" _src=\"http://yanxuan.nosdn.127.net/7aa0e4c0abeb157e231b17e91cfa8f02.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a38f897200e305e7b23d62431b9c4d18.jpg\" _src=\"http://yanxuan.nosdn.127.net/a38f897200e305e7b23d62431b9c4d18.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb147c0e96cdac2d77ab4eef1785e99d.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb147c0e96cdac2d77ab4eef1785e99d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6a270f7aed68cfe74e66d720c776fca.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6a270f7aed68cfe74e66d720c776fca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2c0b548be17f620db8afbe039a99452.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2c0b548be17f620db8afbe039a99452.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/155fe0023e17bac4af486a6c1c098537.jpg\" _src=\"http://yanxuan.nosdn.127.net/155fe0023e17bac4af486a6c1c098537.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f1f120ca7e362595fd986ea6de8814f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f1f120ca7e362595fd986ea6de8814f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6971f0333e0eeef7d9951edad068d4ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/6971f0333e0eeef7d9951edad068d4ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c307630edf971e408938f1007169fa53.jpg\" _src=\"http://yanxuan.nosdn.127.net/c307630edf971e408938f1007169fa53.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ea2ba74fb518a298ef825c43ed634f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ea2ba74fb518a298ef825c43ed634f4.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '17', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/33c1b1b20972990e0ae81f260b00f036.jpg', 'http://yanxuan.nosdn.127.net/66425d1ed50b3968fed27c822fdd32e0.png', '459.00', '1730', '1006022', '0.00', '限时购', '', '0.00', '0', '0', '0', '504.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1006010', '1008008', '1006010', '秋冬保暖加厚细羊毛被', '0', '100', '', '细腻绵羊毛，保暖性增加一倍', '<p><img src=\"http://yanxuan.nosdn.127.net/01c77e998005297e0fad16b25433409f.jpg\" _src=\"http://yanxuan.nosdn.127.net/01c77e998005297e0fad16b25433409f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36bffed3bd139e0135f35e1c30dfab01.jpg\" _src=\"http://yanxuan.nosdn.127.net/36bffed3bd139e0135f35e1c30dfab01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/400b9395fb6947977a27da56baf07fcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/400b9395fb6947977a27da56baf07fcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d6aef8e60f6bf2a438774ae114a9206.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d6aef8e60f6bf2a438774ae114a9206.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13521752a26971ad793d5e3e7061305b.jpg\" _src=\"http://yanxuan.nosdn.127.net/13521752a26971ad793d5e3e7061305b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e4beb6669d9a83e19540727c01ced37.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e4beb6669d9a83e19540727c01ced37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c2e31cb55507bcb4653181f64a069a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c2e31cb55507bcb4653181f64a069a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a65159336d1e2991ef93ed2aab15b7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a65159336d1e2991ef93ed2aab15b7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bade2a9a72c78749f2a0126a43f5943.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bade2a9a72c78749f2a0126a43f5943.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15cf85dc65d2d857bfd1e45516775944.jpg\" _src=\"http://yanxuan.nosdn.127.net/15cf85dc65d2d857bfd1e45516775944.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dffc49e67aa11308b8e408d7539ddf84.jpg\" _src=\"http://yanxuan.nosdn.127.net/dffc49e67aa11308b8e408d7539ddf84.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0826118b3dbd1a123419d1f7f46784de.jpg\" _src=\"http://yanxuan.nosdn.127.net/0826118b3dbd1a123419d1f7f46784de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2cc7573ddb418a0f9fc0483367fce877.jpg\" _src=\"http://yanxuan.nosdn.127.net/2cc7573ddb418a0f9fc0483367fce877.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62b67fcc05f65b26be987e2576ac1b97.jpg\" _src=\"http://yanxuan.nosdn.127.net/62b67fcc05f65b26be987e2576ac1b97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61a604a7f4ec39a7383265d4fb4ba1fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/61a604a7f4ec39a7383265d4fb4ba1fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b04ba442e1d859cce4a945b5fee0ec2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b04ba442e1d859cce4a945b5fee0ec2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0aae1850fdc689eb42103b43709a3de9.jpg\" _src=\"http://yanxuan.nosdn.127.net/0aae1850fdc689eb42103b43709a3de9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a82fdc70b5da5c802dca76410c80dac.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a82fdc70b5da5c802dca76410c80dac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41fff402bc16cd45614bdfa7b612849f.jpg\" _src=\"http://yanxuan.nosdn.127.net/41fff402bc16cd45614bdfa7b612849f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d357f7ec1ced66c8865ed1029cbcc562.jpg\" _src=\"http://yanxuan.nosdn.127.net/d357f7ec1ced66c8865ed1029cbcc562.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad18d0bdad9a571bbf03ebe013a422d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad18d0bdad9a571bbf03ebe013a422d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e0e6c2c77f1627b79037b76ba37adf9.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e0e6c2c77f1627b79037b76ba37adf9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b71de5aaafd05a730cfe421f9e16053d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b71de5aaafd05a730cfe421f9e16053d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aeca9234db5622edfe465c3f7732d203.jpg\" _src=\"http://yanxuan.nosdn.127.net/aeca9234db5622edfe465c3f7732d203.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/678124d2002655e05588a9484f8e5c14.jpg\" _src=\"http://yanxuan.nosdn.127.net/678124d2002655e05588a9484f8e5c14.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3909a0aa66fbdc59c99d0666aef34286.jpg\" _src=\"http://yanxuan.nosdn.127.net/3909a0aa66fbdc59c99d0666aef34286.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ec01a83f6f6cd2d282ec0be98daeb3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ec01a83f6f6cd2d282ec0be98daeb3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8716853b4b08223e886ee8d882e2d58.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8716853b4b08223e886ee8d882e2d58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b8188de7819424845707f3f79a1f80d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b8188de7819424845707f3f79a1f80d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30298def5edcdd62d0c4a20cfdfef66c.jpg\" _src=\"http://yanxuan.nosdn.127.net/30298def5edcdd62d0c4a20cfdfef66c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3437687b19a26469212a1e2c485c557d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3437687b19a26469212a1e2c485c557d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2450afdd3b9f3cc7fc27bbde33ae0e86.jpg\" _src=\"http://yanxuan.nosdn.127.net/2450afdd3b9f3cc7fc27bbde33ae0e86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/434d004c435b62a9505c5ffdf6d362d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/434d004c435b62a9505c5ffdf6d362d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41b6db4ce14bc2d3ff6526d43f52fb46.jpg\" _src=\"http://yanxuan.nosdn.127.net/41b6db4ce14bc2d3ff6526d43f52fb46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cec4d2d62eccc86b409465e1344f1d24.jpg\" _src=\"http://yanxuan.nosdn.127.net/cec4d2d62eccc86b409465e1344f1d24.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09b9868d054ffcdbba3166882fbc8f38.jpg\" _src=\"http://yanxuan.nosdn.127.net/09b9868d054ffcdbba3166882fbc8f38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d8027527ac4af59cc2172a7c3dce64e.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d8027527ac4af59cc2172a7c3dce64e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59deea242718d6610f445776833f9afa.jpg\" _src=\"http://yanxuan.nosdn.127.net/59deea242718d6610f445776833f9afa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13f4b4c5dc11e4f5d2767254d2a5c777.jpg\" _src=\"http://yanxuan.nosdn.127.net/13f4b4c5dc11e4f5d2767254d2a5c777.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0d22f9c380873ddca23e6f187d6b6aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0d22f9c380873ddca23e6f187d6b6aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1821334ad83bfaa64ac4d212be9dd953.jpg\" _src=\"http://yanxuan.nosdn.127.net/1821334ad83bfaa64ac4d212be9dd953.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72e6119d0329faa952d036173cf2f7fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/72e6119d0329faa952d036173cf2f7fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f69081555848f7d3af16cefb9f661c64.jpg\" _src=\"http://yanxuan.nosdn.127.net/f69081555848f7d3af16cefb9f661c64.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbb30819e21854491e0a5c8cf933b59a.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbb30819e21854491e0a5c8cf933b59a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16f564772fc2f1d0030629b42be12211.jpg\" _src=\"http://yanxuan.nosdn.127.net/16f564772fc2f1d0030629b42be12211.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a74dc5e969fc0896537be54155e11cd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/a74dc5e969fc0896537be54155e11cd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c9702f8ffa6e3ebfcb5e1c14161a493.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c9702f8ffa6e3ebfcb5e1c14161a493.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4e3b23eacbc419baa748525bc71ac3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4e3b23eacbc419baa748525bc71ac3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb9520c1bc8e63e480bd61cfbcb6d18c.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb9520c1bc8e63e480bd61cfbcb6d18c.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '16', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0e5e4cc4f12a72f37a0019707d333f49.jpg', 'http://yanxuan.nosdn.127.net/8fe022126a2789d970f82853be13a5e6.png', '659.00', '3919', '1006041', '0.00', '限时购', '', '0.00', '0', '0', '0', '724.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1006013', '1036000', '1006013', '双宫茧桑蚕丝被 空调被', '1001045', '100', '', '一级桑蚕丝，吸湿透气柔软', '<p><img src=\"http://yanxuan.nosdn.127.net/72d71d3ef34d9c63521e6ede2fd468e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/72d71d3ef34d9c63521e6ede2fd468e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/454d60ad184bea35d73258716dd8eff2.jpg\" _src=\"http://yanxuan.nosdn.127.net/454d60ad184bea35d73258716dd8eff2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6af1ec459a8ed93abccb436c2424277f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6af1ec459a8ed93abccb436c2424277f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91b0e9d5f4bc57ec07702b9152ed9b46.jpg\" _src=\"http://yanxuan.nosdn.127.net/91b0e9d5f4bc57ec07702b9152ed9b46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da9743a2abce3752e186928fd8028167.jpg\" _src=\"http://yanxuan.nosdn.127.net/da9743a2abce3752e186928fd8028167.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e48f4b067e0890f15c9f3fae5a94ae73.jpg\" _src=\"http://yanxuan.nosdn.127.net/e48f4b067e0890f15c9f3fae5a94ae73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51009cc464b77780fda27d0f0d7aff62.jpg\" _src=\"http://yanxuan.nosdn.127.net/51009cc464b77780fda27d0f0d7aff62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/557905b15620c59926fc3e655e676e1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/557905b15620c59926fc3e655e676e1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb249f4ccaa07940b40215883902af7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb249f4ccaa07940b40215883902af7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c763f877079e495ef67dc8db49369044.jpg\" _src=\"http://yanxuan.nosdn.127.net/c763f877079e495ef67dc8db49369044.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fffbf8c9990f40d4d63f84a2ecd8e84d.jpg\" _src=\"http://yanxuan.nosdn.127.net/fffbf8c9990f40d4d63f84a2ecd8e84d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62dd5aa7c9f64936dcd86f1592eb38b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/62dd5aa7c9f64936dcd86f1592eb38b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1f1914c7be28f6800372d878aaf5de1.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1f1914c7be28f6800372d878aaf5de1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb23c66040b18fb5b5ba6dfeeb9a4b1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb23c66040b18fb5b5ba6dfeeb9a4b1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d49ac2656061fff48a6244dfdde01c41.jpg\" _src=\"http://yanxuan.nosdn.127.net/d49ac2656061fff48a6244dfdde01c41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/947ca15f1e253634456e1bcb93c8172f.jpg\" _src=\"http://yanxuan.nosdn.127.net/947ca15f1e253634456e1bcb93c8172f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80ea5528f9a679f24d1240c9e519d693.jpg\" _src=\"http://yanxuan.nosdn.127.net/80ea5528f9a679f24d1240c9e519d693.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/150a3223e5bfdde9442c0bcab62ca711.jpg\" _src=\"http://yanxuan.nosdn.127.net/150a3223e5bfdde9442c0bcab62ca711.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/769f510f743022e38ded0e4a2f2023c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/769f510f743022e38ded0e4a2f2023c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91cc7ea8833b03cc9fd7b567a4e2569f.jpg\" _src=\"http://yanxuan.nosdn.127.net/91cc7ea8833b03cc9fd7b567a4e2569f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0982d37e3442540723b17a66493bf849.jpg\" _src=\"http://yanxuan.nosdn.127.net/0982d37e3442540723b17a66493bf849.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/449a379cf9a8664a52cc0ef9582fe063.jpg\" _src=\"http://yanxuan.nosdn.127.net/449a379cf9a8664a52cc0ef9582fe063.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80d2959fe04d9a283ee1e9b180fd30be.jpg\" _src=\"http://yanxuan.nosdn.127.net/80d2959fe04d9a283ee1e9b180fd30be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc878d8a7b7386f5503b327fd444a12d.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc878d8a7b7386f5503b327fd444a12d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6137ff63496de30117774c7be09d8f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6137ff63496de30117774c7be09d8f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ddfbc82ef6ede49231463b8d09465dbb.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddfbc82ef6ede49231463b8d09465dbb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07a0a19039d8e98ffad6895b438545ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/07a0a19039d8e98ffad6895b438545ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f4c47f5d8c1c390fd6efd5b757924c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f4c47f5d8c1c390fd6efd5b757924c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dee8166ae7bed6d509af9925a350b405.jpg\" _src=\"http://yanxuan.nosdn.127.net/dee8166ae7bed6d509af9925a350b405.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f07dc7e541fd4c0c71d21679a3afbd06.jpg\" _src=\"http://yanxuan.nosdn.127.net/f07dc7e541fd4c0c71d21679a3afbd06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9deb210e7cdbb18bb42e37b0640fbba9.jpg\" _src=\"http://yanxuan.nosdn.127.net/9deb210e7cdbb18bb42e37b0640fbba9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/286eed28f2cb51d76fafdb1a112aaa91.jpg\" _src=\"http://yanxuan.nosdn.127.net/286eed28f2cb51d76fafdb1a112aaa91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7d0251276ab00b200a153515d69dec7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7d0251276ab00b200a153515d69dec7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a908235021c994fb2d5a029f27bf520.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a908235021c994fb2d5a029f27bf520.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98b1fdb1029b1a585871574f7f8bf104.jpg\" _src=\"http://yanxuan.nosdn.127.net/98b1fdb1029b1a585871574f7f8bf104.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b67aa253cacf03bd0d5a3be8743d15b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/b67aa253cacf03bd0d5a3be8743d15b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9689e05a06746a6f00be0b6f1dd80ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9689e05a06746a6f00be0b6f1dd80ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a494d87239c3a84819f54d5e1e430ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a494d87239c3a84819f54d5e1e430ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0187f5be624e13ed5eac7f00c13bde0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0187f5be624e13ed5eac7f00c13bde0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dec5144859fb414c2181e0bf15185cf2.jpg\" _src=\"http://yanxuan.nosdn.127.net/dec5144859fb414c2181e0bf15185cf2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f06282b15ffbed67f115b436ca6975ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/f06282b15ffbed67f115b436ca6975ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c159080beb18d634929c6543392d655.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c159080beb18d634929c6543392d655.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94bea38417d6f74a823b0407e3871709.jpg\" _src=\"http://yanxuan.nosdn.127.net/94bea38417d6f74a823b0407e3871709.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f204613bd50eb71265ca0dc28bc91df0.jpg\" _src=\"http://yanxuan.nosdn.127.net/f204613bd50eb71265ca0dc28bc91df0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36e9a86f175472e70708511a51276e33.jpg\" _src=\"http://yanxuan.nosdn.127.net/36e9a86f175472e70708511a51276e33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/293a0997d7f9dd51211225ceb8073a04.jpg\" _src=\"http://yanxuan.nosdn.127.net/293a0997d7f9dd51211225ceb8073a04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3c451b65fd6e8215f4609696f9699d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3c451b65fd6e8215f4609696f9699d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54ad136164b7066bda8c3f5b418eb6c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/54ad136164b7066bda8c3f5b418eb6c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e17a55eea9daa90ad3e5490a8ade2060.jpg\" _src=\"http://yanxuan.nosdn.127.net/e17a55eea9daa90ad3e5490a8ade2060.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c898af2ddd8754fa42ae09d341c255ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/c898af2ddd8754fa42ae09d341c255ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad2b42dfa9ed7a3b0b7d832482592aea.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad2b42dfa9ed7a3b0b7d832482592aea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/314cb766b281d9d69ca7d0e177326e3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/314cb766b281d9d69ca7d0e177326e3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42bcc536dc84355531fa657a450b5daa.jpg\" _src=\"http://yanxuan.nosdn.127.net/42bcc536dc84355531fa657a450b5daa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7f140d9e49eb84d504719b7a04541e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7f140d9e49eb84d504719b7a04541e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/693aa30f123d122d58507ec0df194f96.jpg\" _src=\"http://yanxuan.nosdn.127.net/693aa30f123d122d58507ec0df194f96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7193b8192cb6345f6f2503febd2b86ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/7193b8192cb6345f6f2503febd2b86ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f997dbe72e525fcc68663fe50b5c825.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f997dbe72e525fcc68663fe50b5c825.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6771f59b904f91d296c115de01f0b7f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/6771f59b904f91d296c115de01f0b7f3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/7b95e6b91133f8d8fd56505c47d2fa29.jpg', 'http://yanxuan.nosdn.127.net/583812520c68ca7995b6fac4c67ae2c7.png', '699.00', '841', '1006045', '0.00', '限时购', '', '0.00', '0', '0', '1', '768.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1006014', '1008008', '1006014', '双宫茧桑蚕丝被 子母被', '1001045', '100', '', '双层子母被，四季皆可使用', '<p><img src=\"http://yanxuan.nosdn.127.net/3b5ee089edb2b5d3361bf60e208ec474.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b5ee089edb2b5d3361bf60e208ec474.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/737260dd5cfae7ef72c713af861e8774.jpg\" _src=\"http://yanxuan.nosdn.127.net/737260dd5cfae7ef72c713af861e8774.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62a70427f9d6bf81bc19203e6f401e2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/62a70427f9d6bf81bc19203e6f401e2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/051aa6ea1ef13b32240a34e0d2d5ca97.jpg\" _src=\"http://yanxuan.nosdn.127.net/051aa6ea1ef13b32240a34e0d2d5ca97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41b19060447843186366c221130ee4de.jpg\" _src=\"http://yanxuan.nosdn.127.net/41b19060447843186366c221130ee4de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae757922d72e6c4357d10f1d78bd7a8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae757922d72e6c4357d10f1d78bd7a8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58bcf7d0ce99f4f2b5cf11b9511319e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/58bcf7d0ce99f4f2b5cf11b9511319e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54496c73ebda2680aa2b9d8c375a82e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/54496c73ebda2680aa2b9d8c375a82e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6caae81b0956de612ce57b1419382813.jpg\" _src=\"http://yanxuan.nosdn.127.net/6caae81b0956de612ce57b1419382813.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fbf34bb5b36ba708dfc3facc6551d1b.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fbf34bb5b36ba708dfc3facc6551d1b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/741663a8fb8f5a17442951d7ed670952.jpg\" _src=\"http://yanxuan.nosdn.127.net/741663a8fb8f5a17442951d7ed670952.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7055264e97783cc669a003e3e857de8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7055264e97783cc669a003e3e857de8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59983cf72d63181eff723b7d6ec2a57d.jpg\" _src=\"http://yanxuan.nosdn.127.net/59983cf72d63181eff723b7d6ec2a57d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6046cb49c22b635a84d490e8f0ab9f8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6046cb49c22b635a84d490e8f0ab9f8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01d18fcb6e8019798a630c9abb01580a.jpg\" _src=\"http://yanxuan.nosdn.127.net/01d18fcb6e8019798a630c9abb01580a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4093967aedc279e3c4ee3e672fbebbff.jpg\" _src=\"http://yanxuan.nosdn.127.net/4093967aedc279e3c4ee3e672fbebbff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/994d3bcf0b40fc9c31f51a9accd0b88c.jpg\" _src=\"http://yanxuan.nosdn.127.net/994d3bcf0b40fc9c31f51a9accd0b88c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72fd621d3b567cb6d963a9b554c58ee5.jpg\" _src=\"http://yanxuan.nosdn.127.net/72fd621d3b567cb6d963a9b554c58ee5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1704b2d57d8ce5a30b371f702b80e23.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1704b2d57d8ce5a30b371f702b80e23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0cd8614de4c7bc709158dcf9b7e9ada.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0cd8614de4c7bc709158dcf9b7e9ada.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/290ecc11a85a18b87825fe57caa81bd3.jpg\" _src=\"http://yanxuan.nosdn.127.net/290ecc11a85a18b87825fe57caa81bd3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3467f0eb4f5a3feb30df257b1dd1a80a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3467f0eb4f5a3feb30df257b1dd1a80a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/406defa7a54f5626e050d9eee2a3a7f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/406defa7a54f5626e050d9eee2a3a7f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14f1fa09e672955a8afad3e35eae3798.jpg\" _src=\"http://yanxuan.nosdn.127.net/14f1fa09e672955a8afad3e35eae3798.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df344f04a06d62cb15c48a220fb18e34.jpg\" _src=\"http://yanxuan.nosdn.127.net/df344f04a06d62cb15c48a220fb18e34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b468781d6f234e0107b7ed7c44492da5.jpg\" _src=\"http://yanxuan.nosdn.127.net/b468781d6f234e0107b7ed7c44492da5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d91c856cbb29826afbc4d3e2bbf63e27.jpg\" _src=\"http://yanxuan.nosdn.127.net/d91c856cbb29826afbc4d3e2bbf63e27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f08409269a24bc60c51c97e56b279ddc.jpg\" _src=\"http://yanxuan.nosdn.127.net/f08409269a24bc60c51c97e56b279ddc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3809897fdc8a9db7bd447d7ec1116a17.jpg\" _src=\"http://yanxuan.nosdn.127.net/3809897fdc8a9db7bd447d7ec1116a17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd024467887854c0f9540d9cfef2e6dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd024467887854c0f9540d9cfef2e6dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da5afa55ec02ac1e430ecb985c7aef83.jpg\" _src=\"http://yanxuan.nosdn.127.net/da5afa55ec02ac1e430ecb985c7aef83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f522e5f98ccab9311de8b15a2c6951ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/f522e5f98ccab9311de8b15a2c6951ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4d5ef81a10211b7a8d3b7134b3adccb.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4d5ef81a10211b7a8d3b7134b3adccb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c241ff5f9c267fbd27c2e0bf346dc00.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c241ff5f9c267fbd27c2e0bf346dc00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9db75fb0766730ee2f2afcf8b8b33659.jpg\" _src=\"http://yanxuan.nosdn.127.net/9db75fb0766730ee2f2afcf8b8b33659.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f4f42fad5ace718567c9aa68ada22a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f4f42fad5ace718567c9aa68ada22a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc0152f7a1a5a31603a59bdfdc4e987f.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc0152f7a1a5a31603a59bdfdc4e987f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2929041a7abc890965d4b399f3b6278.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2929041a7abc890965d4b399f3b6278.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e12a5accd62e0b29ace162ca64fe5ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e12a5accd62e0b29ace162ca64fe5ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/924c7f4ce0af0fdefd04164508648885.jpg\" _src=\"http://yanxuan.nosdn.127.net/924c7f4ce0af0fdefd04164508648885.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55f049536b6471804546d55b8f4fb88c.jpg\" _src=\"http://yanxuan.nosdn.127.net/55f049536b6471804546d55b8f4fb88c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd99f9a6f3d60a1d07ac3428b974f65d.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd99f9a6f3d60a1d07ac3428b974f65d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0444882d13667f002b4eeeaa02bf0498.jpg\" _src=\"http://yanxuan.nosdn.127.net/0444882d13667f002b4eeeaa02bf0498.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9491237b070c4eff99dff34d528b4b65.jpg\" _src=\"http://yanxuan.nosdn.127.net/9491237b070c4eff99dff34d528b4b65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18bbcf7de0dfe9df10fdccffa328a54d.jpg\" _src=\"http://yanxuan.nosdn.127.net/18bbcf7de0dfe9df10fdccffa328a54d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b396a6ce48ebd3297384d8deea6f06e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/b396a6ce48ebd3297384d8deea6f06e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2234040e3bcd7d6b7954b34afc9592a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/2234040e3bcd7d6b7954b34afc9592a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b2015e0c984e01a2ec6e971f3b3c855.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b2015e0c984e01a2ec6e971f3b3c855.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cfd381db37cea6b62856d0bcceaa4e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cfd381db37cea6b62856d0bcceaa4e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61c867e69ce18b47ba5e8b4dc35d45a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/61c867e69ce18b47ba5e8b4dc35d45a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/efbb973c5e5b9bf58e764957f64402b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/efbb973c5e5b9bf58e764957f64402b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66eb58f7818e87a8cc67923a2effaeee.jpg\" _src=\"http://yanxuan.nosdn.127.net/66eb58f7818e87a8cc67923a2effaeee.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '15', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/fdea6bee474e586fd4da18682e07a432.jpg', 'http://yanxuan.nosdn.127.net/2b537159f0f789034bf8c4b339c43750.png', '1399.00', '1949', '1006046', '0.00', '限时购', '', '0.00', '0', '0', '0', '1538.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1006051', '1008001', '1006051', '皇室御用超柔毛巾', '0', '100', '', '至柔至软，热销50万条', '', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '条', 'http://yanxuan.nosdn.127.net/de30c41b94ce203985a228dc787fdcfa.jpg', 'http://yanxuan.nosdn.127.net/ad5a317216f9da495b144070ecf1f957.png', '59.00', '33401', '1006120', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1009009', '1008008', '1009009', '白鹅绒秋冬加厚羽绒被', '1001000', '100', '', '热销5万条，一条被子过冬', '<p><img src=\"http://yanxuan.nosdn.127.net/79ae82326ba86985035215ca9bebd137.jpg\" _src=\"http://yanxuan.nosdn.127.net/79ae82326ba86985035215ca9bebd137.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7aadf2c5fd0942dc9bceb5a0738d969.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7aadf2c5fd0942dc9bceb5a0738d969.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ccf2486677aafef68048894317b6e96.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ccf2486677aafef68048894317b6e96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3ce70df9905a810c60220d9d24ebb2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3ce70df9905a810c60220d9d24ebb2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d51b1e4f61cb563b09dae46ee282e220.jpg\" _src=\"http://yanxuan.nosdn.127.net/d51b1e4f61cb563b09dae46ee282e220.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e2791ef7173866f12be3341ca7202336.jpg\" _src=\"http://yanxuan.nosdn.127.net/e2791ef7173866f12be3341ca7202336.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6cda9c3d9f044310f49afc5bbdb3533d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6cda9c3d9f044310f49afc5bbdb3533d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68e9be17108a9c6a0e6b786176a4b4c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/68e9be17108a9c6a0e6b786176a4b4c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3974579c71cdf946088d339e9e5c865d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3974579c71cdf946088d339e9e5c865d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d95a8520e3e3dfec063fc484e1d57207.jpg\" _src=\"http://yanxuan.nosdn.127.net/d95a8520e3e3dfec063fc484e1d57207.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce8b29a61396dced0f89ea3bfdf1f45d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce8b29a61396dced0f89ea3bfdf1f45d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/129cba9ef941b367e56dad47aeb7fd96.jpg\" _src=\"http://yanxuan.nosdn.127.net/129cba9ef941b367e56dad47aeb7fd96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f566abb0c978093647aa1742725129ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/f566abb0c978093647aa1742725129ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7c7c153400895b5d690f1eba9b3c315.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7c7c153400895b5d690f1eba9b3c315.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be750a41eef4db163a29e2326a65660f.jpg\" _src=\"http://yanxuan.nosdn.127.net/be750a41eef4db163a29e2326a65660f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ea11ee2e846b3536acb599b93b7d2e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ea11ee2e846b3536acb599b93b7d2e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5814d4e02b3fd0b94d04ca262b201385.jpg\" _src=\"http://yanxuan.nosdn.127.net/5814d4e02b3fd0b94d04ca262b201385.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7959e1d91576bf0d21e7bd042e2210bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/7959e1d91576bf0d21e7bd042e2210bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4268cc5be26539ed427927e4e6d8e18e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4268cc5be26539ed427927e4e6d8e18e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5667dee42adfce79988974d96ddd8b09.jpg\" _src=\"http://yanxuan.nosdn.127.net/5667dee42adfce79988974d96ddd8b09.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6c9f0a1a51cd0166844d3694cc92a1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6c9f0a1a51cd0166844d3694cc92a1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce43457f50492c355ff1f7577685c004.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce43457f50492c355ff1f7577685c004.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c2ff68fede235b1b9f249cd5dabce0d.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c2ff68fede235b1b9f249cd5dabce0d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/785952cd32deedc2bfd90826e89ddc2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/785952cd32deedc2bfd90826e89ddc2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b544624dcc990b966e6c6d20ee608b7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b544624dcc990b966e6c6d20ee608b7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/761a606123be84d0c6eaa2e5eb9f4f81.jpg\" _src=\"http://yanxuan.nosdn.127.net/761a606123be84d0c6eaa2e5eb9f4f81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0cce548176f68f7e00de503d4d146629.jpg\" _src=\"http://yanxuan.nosdn.127.net/0cce548176f68f7e00de503d4d146629.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30cb73b7917af99d4ccbdbca9042d566.jpg\" _src=\"http://yanxuan.nosdn.127.net/30cb73b7917af99d4ccbdbca9042d566.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a27c57bb90e145df10d633dcfdbe26b.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a27c57bb90e145df10d633dcfdbe26b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8df76b01f83dd4d4a7f58014d8977067.jpg\" _src=\"http://yanxuan.nosdn.127.net/8df76b01f83dd4d4a7f58014d8977067.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea47ed85b1334e2da9672ee3e9ad66a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea47ed85b1334e2da9672ee3e9ad66a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/750caeba2fa63dec64d598e8299f2122.jpg\" _src=\"http://yanxuan.nosdn.127.net/750caeba2fa63dec64d598e8299f2122.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14bd429f1d48be5d9a8240c1fb4c494b.jpg\" _src=\"http://yanxuan.nosdn.127.net/14bd429f1d48be5d9a8240c1fb4c494b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02ee506d1f4ba045d7408a0b1e719c8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/02ee506d1f4ba045d7408a0b1e719c8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82443ff0a437048729b35fbdb85b0c3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/82443ff0a437048729b35fbdb85b0c3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3f39a87baa66fe50f3b141d148645b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3f39a87baa66fe50f3b141d148645b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/814e549460f206dccb8889165ef69ea2.jpg\" _src=\"http://yanxuan.nosdn.127.net/814e549460f206dccb8889165ef69ea2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43c21522533725d57ff893f9d080f6cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/43c21522533725d57ff893f9d080f6cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dfc0d18fa3b2ba721fd7614af7962cbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/dfc0d18fa3b2ba721fd7614af7962cbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b58ac36c4781edd6d09dfeb2fbb6112.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b58ac36c4781edd6d09dfeb2fbb6112.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aadb34b1fe47217989e46eefb2fcef2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/aadb34b1fe47217989e46eefb2fcef2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/558aa961eb6b51692e50c5801d74adeb.jpg\" _src=\"http://yanxuan.nosdn.127.net/558aa961eb6b51692e50c5801d74adeb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/af3a0c3d829d015c0850befa9aa7f05c.jpg\" _src=\"http://yanxuan.nosdn.127.net/af3a0c3d829d015c0850befa9aa7f05c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23c02d5a325df4c87eb339e694489339.jpg\" _src=\"http://yanxuan.nosdn.127.net/23c02d5a325df4c87eb339e694489339.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c51160264c2344feb8a2580d0c47a655.jpg\" _src=\"http://yanxuan.nosdn.127.net/c51160264c2344feb8a2580d0c47a655.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea8ecd877fdd3c0b30f7d7b961fdf8ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea8ecd877fdd3c0b30f7d7b961fdf8ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5976f583518689c566c94ce65ac8fcb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5976f583518689c566c94ce65ac8fcb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/494dc60b71027177448188093c5eb072.jpg\" _src=\"http://yanxuan.nosdn.127.net/494dc60b71027177448188093c5eb072.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c0fc3b0727795fe696579e6b3a1f817.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c0fc3b0727795fe696579e6b3a1f817.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ab7aa0de0e90b5a8768d25155e6c475.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ab7aa0de0e90b5a8768d25155e6c475.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/839ffe5bf65befd4ec353fbed7730b2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/839ffe5bf65befd4ec353fbed7730b2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/313df862cf6181ef199b782969be4607.jpg\" _src=\"http://yanxuan.nosdn.127.net/313df862cf6181ef199b782969be4607.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e39bfc4343d8968879ec66cc67db8987.jpg\" _src=\"http://yanxuan.nosdn.127.net/e39bfc4343d8968879ec66cc67db8987.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0c74814f38aba0c40a405ece465d554.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0c74814f38aba0c40a405ece465d554.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '19', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/47bb01a1c0d4940494d31e7a61e6466e.jpg', 'http://yanxuan.nosdn.127.net/9791006f25e26b2d7c81f41f87ce8619.png', '1999.00', '154', '1008012', '0.00', '限时购', '', '0.00', '0', '0', '0', '2198.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1009012', '1008008', '1009012', '可水洗舒柔丝羽绒枕', '0', '100', '', '超细纤维，蓬松轻盈回弹', '<p><img src=\"http://yanxuan.nosdn.127.net/1a5e9ace280a27c810e67bf3aab66a75.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a5e9ace280a27c810e67bf3aab66a75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40c88e440f866d761e72fff850edafc1.jpg\" _src=\"http://yanxuan.nosdn.127.net/40c88e440f866d761e72fff850edafc1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e26e6ab169ea6cd025558eecd8c9cd5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e26e6ab169ea6cd025558eecd8c9cd5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a44f6c9ce44db0c10453632a295849b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a44f6c9ce44db0c10453632a295849b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df9d87e60d06169417fa9460f81537d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/df9d87e60d06169417fa9460f81537d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2cf5687c311b0dda7931a15532be0fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2cf5687c311b0dda7931a15532be0fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8acf04b68de689304e5cb69ff6bb07d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/8acf04b68de689304e5cb69ff6bb07d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65d20babc642c3dcf86e543344e9ed52.jpg\" _src=\"http://yanxuan.nosdn.127.net/65d20babc642c3dcf86e543344e9ed52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92efc7c36a8be774dffa2c6e64d80501.jpg\" _src=\"http://yanxuan.nosdn.127.net/92efc7c36a8be774dffa2c6e64d80501.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70be97c7a2fb95b45260c3debf6c2688.jpg\" _src=\"http://yanxuan.nosdn.127.net/70be97c7a2fb95b45260c3debf6c2688.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01f3285234fb3e7a005511985b21f79f.jpg\" _src=\"http://yanxuan.nosdn.127.net/01f3285234fb3e7a005511985b21f79f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4b7e5b867f5b248d28a16116eac5633.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4b7e5b867f5b248d28a16116eac5633.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c7402aa957e5a25db3fbfefdfb0af96.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c7402aa957e5a25db3fbfefdfb0af96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39d0f3ba2eb421945a81fa52414dbca5.jpg\" _src=\"http://yanxuan.nosdn.127.net/39d0f3ba2eb421945a81fa52414dbca5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/000eb7d7bf5587215df305676533e5c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/000eb7d7bf5587215df305676533e5c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/557a98e73aa9d1d15721b7e4e26e487f.jpg\" _src=\"http://yanxuan.nosdn.127.net/557a98e73aa9d1d15721b7e4e26e487f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70b33a53ab55bdc711021ae5c9494f03.jpg\" _src=\"http://yanxuan.nosdn.127.net/70b33a53ab55bdc711021ae5c9494f03.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f3d135a3e7c8f550a46cbdcc973d7ad7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f3d135a3e7c8f550a46cbdcc973d7ad7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87eedde73e8c0b357ca1295a201ffbe0.jpg\" _src=\"http://yanxuan.nosdn.127.net/87eedde73e8c0b357ca1295a201ffbe0.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/3f2cc7a7e4472aa40c997e70efe6aeed.jpg', 'http://yanxuan.nosdn.127.net/a196b367f23ccfd8205b6da647c62b84.png', '59.00', '4862', '1008022', '0.00', '限时购', '', '0.00', '0', '0', '1', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1009013', '1008008', '1009013', '可水洗抗菌防螨丝羽绒枕', '0', '100', '', '进口防螨布，热销50万件', '<p><img src=\"http://yanxuan.nosdn.127.net/b2576e9567e5de643a02f3a5fc26ee17.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2576e9567e5de643a02f3a5fc26ee17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/029b577be403335de4c2a37b9d83a31d.jpg\" _src=\"http://yanxuan.nosdn.127.net/029b577be403335de4c2a37b9d83a31d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/779f04eac136c934fe9a17d2d26137ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/779f04eac136c934fe9a17d2d26137ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d641ff16c4b2502442616f3e194d575.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d641ff16c4b2502442616f3e194d575.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec14832d8c947f4dbe716eabfaa7029a.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec14832d8c947f4dbe716eabfaa7029a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/645db2317426b5a852d331231e258c02.jpg\" _src=\"http://yanxuan.nosdn.127.net/645db2317426b5a852d331231e258c02.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac6055481565438d5fee342c3ccec155.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac6055481565438d5fee342c3ccec155.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8382f534cf2acac06551df87e136c4f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/8382f534cf2acac06551df87e136c4f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce4cf3fdb7230634c72fbf6c97bd3c16.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce4cf3fdb7230634c72fbf6c97bd3c16.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d78a9f815043b0ed880d0ba90b08dbc.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d78a9f815043b0ed880d0ba90b08dbc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3aa34184510cbdd8df6ba4440af6e37e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3aa34184510cbdd8df6ba4440af6e37e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbb48af3056fd3dcffa9968a076753f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbb48af3056fd3dcffa9968a076753f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc72b5750827b7d222d972888fb9831b.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc72b5750827b7d222d972888fb9831b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b24b9b12b891be546263e2cd3f0b704c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b24b9b12b891be546263e2cd3f0b704c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/631996fac12032dbdc17ffd721fb7087.jpg\" _src=\"http://yanxuan.nosdn.127.net/631996fac12032dbdc17ffd721fb7087.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ecc5a8793e18aad9bf3d5f0a89bff12f.jpg\" _src=\"http://yanxuan.nosdn.127.net/ecc5a8793e18aad9bf3d5f0a89bff12f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/943a4bc41ad6e80051c5cfacd102cfde.jpg\" _src=\"http://yanxuan.nosdn.127.net/943a4bc41ad6e80051c5cfacd102cfde.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0a13678fdef5e56d53de783e8e01350.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0a13678fdef5e56d53de783e8e01350.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/220ef8d778bdfc198fcb53f0f01289a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/220ef8d778bdfc198fcb53f0f01289a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/573acbc397778453b21aba05e5a397f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/573acbc397778453b21aba05e5a397f6.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/7ffe405a024fd78314cbf72c806b5a4b.jpg', 'http://yanxuan.nosdn.127.net/da56fda947d0f430d5f4cf4aba14e679.png', '99.00', '2837', '1008023', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1009024', '1008002', '1009024', '日式和风懒人沙发', '0', '100', '', '优质莱卡纯棉，和风家居新体验', '<p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/34a6a0daa3f7a397a38aad14cb9e90fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/34a6a0daa3f7a397a38aad14cb9e90fa.jpg\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/76637af0eec246b318cb129b768de637.jpg\" _src=\"http://yanxuan.nosdn.127.net/76637af0eec246b318cb129b768de637.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18fee22626e61fc1d1a01916914016ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/18fee22626e61fc1d1a01916914016ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91f57a9bb142e1c1e2ff0bbea6f9af96.jpg\" _src=\"http://yanxuan.nosdn.127.net/91f57a9bb142e1c1e2ff0bbea6f9af96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/252d80fd75eb1254d746d0b57c267650.jpg\" _src=\"http://yanxuan.nosdn.127.net/252d80fd75eb1254d746d0b57c267650.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b07697992a2b14de6fd0a5811936d71.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b07697992a2b14de6fd0a5811936d71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c499439d6081bb4e836955b7514c1b96.jpg\" _src=\"http://yanxuan.nosdn.127.net/c499439d6081bb4e836955b7514c1b96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bed437fdc091d020a8f805bcc8830bd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/bed437fdc091d020a8f805bcc8830bd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fc5febdb817abd7a1040bab03f048b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fc5febdb817abd7a1040bab03f048b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0417b3986c9dc082124fcc360390021.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0417b3986c9dc082124fcc360390021.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5c9d24c652d4dee7946ef925105f3f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5c9d24c652d4dee7946ef925105f3f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b10272c58f95dd6737ce1cd41452a21d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b10272c58f95dd6737ce1cd41452a21d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/510c6ef36760238b38ed59cd6e47a21f.png\" _src=\"http://yanxuan.nosdn.127.net/510c6ef36760238b38ed59cd6e47a21f.png\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6371348b917c021c55dc393fc59d4d28.png\" _src=\"http://yanxuan.nosdn.127.net/6371348b917c021c55dc393fc59d4d28.png\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de4079b128e57c5c0fa8a8177e9bc6e7.png\" _src=\"http://yanxuan.nosdn.127.net/de4079b128e57c5c0fa8a8177e9bc6e7.png\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/160966fbc772787f824dc1dbd5afb16d.png\" _src=\"http://yanxuan.nosdn.127.net/160966fbc772787f824dc1dbd5afb16d.png\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb3c8d3f10f2aca0908871c8e598aa0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb3c8d3f10f2aca0908871c8e598aa0e.jpg\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/bcaf7ee314af7dbfb04612087e563249.jpg', 'http://yanxuan.nosdn.127.net/149dfa87a7324e184c5526ead81de9ad.png', '599.00', '2918', '1008052', '0.00', '限时购', '', '0.00', '0', '0', '0', '658.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1009027', '1008001', '1009027', '皇室御用超柔毛巾80s', '0', '100', '', '轻柔舒适不掉毛', '', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '条', 'http://yanxuan.nosdn.127.net/35ad21679dbd30a23a8308287ffd4673.jpg', 'http://yanxuan.nosdn.127.net/71cfd849335c498dee3c54d1eb823c17.png', '79.00', '10699', '1008061', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1010000', '1008009', '1010000', '澳洲纯羊毛盖毯 加厚款', '0', '100', '', '温暖加厚设计', '<p><img src=\"http://yanxuan.nosdn.127.net/ff86010e7277e9fe194e393fb1ad2ba9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff86010e7277e9fe194e393fb1ad2ba9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/217045fdde1eef8a8f37cd162bed12dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/217045fdde1eef8a8f37cd162bed12dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/128cd8aebeb3ace9e00ab1f06ef52d69.jpg\" _src=\"http://yanxuan.nosdn.127.net/128cd8aebeb3ace9e00ab1f06ef52d69.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/648886df63abe5211271ab1187f9c763.jpg\" _src=\"http://yanxuan.nosdn.127.net/648886df63abe5211271ab1187f9c763.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/820a1f82b97a9f28b449bcdb2f72a631.jpg\" _src=\"http://yanxuan.nosdn.127.net/820a1f82b97a9f28b449bcdb2f72a631.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4f0e12ff92d2d3056290c94aa512f43.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4f0e12ff92d2d3056290c94aa512f43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4b8bb95cba61f7c6ec36af3312a3a68.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4b8bb95cba61f7c6ec36af3312a3a68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e15a76573c7ba9d0a077eec5b914321b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e15a76573c7ba9d0a077eec5b914321b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8833d04e7f87b7a8d324c315df763726.jpg\" _src=\"http://yanxuan.nosdn.127.net/8833d04e7f87b7a8d324c315df763726.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa8ad5312cb4a8d129528e37a6ac64bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa8ad5312cb4a8d129528e37a6ac64bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5d26e28d938e9a33a2c729283f2cc82.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5d26e28d938e9a33a2c729283f2cc82.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d27a1a92b24adfdf0e6578ddbcd1b572.jpg\" _src=\"http://yanxuan.nosdn.127.net/d27a1a92b24adfdf0e6578ddbcd1b572.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38eb737cc02e5b383911867ed48a004b.jpg\" _src=\"http://yanxuan.nosdn.127.net/38eb737cc02e5b383911867ed48a004b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82d5a1d5e587b9e8e781f485fb9f73bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/82d5a1d5e587b9e8e781f485fb9f73bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/728d11809778d6de50f7274a384952e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/728d11809778d6de50f7274a384952e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/046d49ddc7c9e7031a354129a05e72e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/046d49ddc7c9e7031a354129a05e72e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8144e45974188424d576bc16fdfc5842.jpg\" _src=\"http://yanxuan.nosdn.127.net/8144e45974188424d576bc16fdfc5842.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8bd138f32ee0930250aec8578d740a12.jpg\" _src=\"http://yanxuan.nosdn.127.net/8bd138f32ee0930250aec8578d740a12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71b7da3908ca5d8bb96c690d0c069a5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/71b7da3908ca5d8bb96c690d0c069a5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3a9174f7ca98df4489fa0f1cacc289f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3a9174f7ca98df4489fa0f1cacc289f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b4adaa15075af3218bb54b556db6a70.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b4adaa15075af3218bb54b556db6a70.jpg\" style=\"\"/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7e346ce58ad1400c14a11a515c37ab0.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7e346ce58ad1400c14a11a515c37ab0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f3df0b2855589a41c66d35945dbf792.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f3df0b2855589a41c66d35945dbf792.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d5b71b357fc979d0e65968c6697a0df.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d5b71b357fc979d0e65968c6697a0df.jpg\"/></p>', '1', '2017-08-30 11:40:11', '36', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/129d47ee8e76e045d835e29556048ece.jpg', 'http://yanxuan.nosdn.127.net/3bec70b85337c3eec182e54380ef7370.png', '399.00', '610', '1009000', '0.00', '限时购', '', '0.00', '0', '0', '0', '438.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1010001', '1008009', '1010001', '澳洲纯羊毛盖毯 舒适款', '0', '100', '', '100%澳洲美利奴羊毛', '<p><img src=\"http://yanxuan.nosdn.127.net/b23db0608cd8bfde4be5d90124483b36.jpg\" _src=\"http://yanxuan.nosdn.127.net/b23db0608cd8bfde4be5d90124483b36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f77c27a2e5d5f9d61eeaffc364d6415d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f77c27a2e5d5f9d61eeaffc364d6415d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5841dfb7a94c4b849abbe42b2a00434e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5841dfb7a94c4b849abbe42b2a00434e.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/656ebc04bee2462793db2b8bf1813aa9.jpg\" _src=\"http://yanxuan.nosdn.127.net/656ebc04bee2462793db2b8bf1813aa9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c55350f193eaf1204a25932fa469586f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c55350f193eaf1204a25932fa469586f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca5c07a9abb58032f2d12e257ccbf367.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca5c07a9abb58032f2d12e257ccbf367.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/549b0e32a35f85fc0c1f34d03c336bcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/549b0e32a35f85fc0c1f34d03c336bcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb29db817a6ae1cd6619260023099369.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb29db817a6ae1cd6619260023099369.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68ec1234fec67d7ba4737ea6129601fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/68ec1234fec67d7ba4737ea6129601fd.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7eaba1187a93d93031e52662d7e9012.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7eaba1187a93d93031e52662d7e9012.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9fb5698bdfde2ae6fa8c49b743e113b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9fb5698bdfde2ae6fa8c49b743e113b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8c4352aed20fc8e381e61b75a0df423.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8c4352aed20fc8e381e61b75a0df423.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bda69e3e6128f1ae2aef1d6b6c2a32a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/bda69e3e6128f1ae2aef1d6b6c2a32a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/607a6bd73635d670d3c0efd5db4494a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/607a6bd73635d670d3c0efd5db4494a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfe7e30663d3d8a2deba97eeb6a9dd33.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfe7e30663d3d8a2deba97eeb6a9dd33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79991d473d14b4c64054ac43c62acedc.jpg\" _src=\"http://yanxuan.nosdn.127.net/79991d473d14b4c64054ac43c62acedc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1f4016c887fb7ec699fb8ac5336625d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1f4016c887fb7ec699fb8ac5336625d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ed3f9a90c5b8b3a20190068aaeaa069.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ed3f9a90c5b8b3a20190068aaeaa069.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccafa9bae7e5aad763ef6ac20830d1a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccafa9bae7e5aad763ef6ac20830d1a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9bcb97f02f51d545eff2d186e6480728.jpg\" _src=\"http://yanxuan.nosdn.127.net/9bcb97f02f51d545eff2d186e6480728.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e7cdbc72ac2358f7243baf320f8db9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e7cdbc72ac2358f7243baf320f8db9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4c6ba6d38e2beae0ad248d799021a23.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4c6ba6d38e2beae0ad248d799021a23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10afa0d6db391623eecaf87fa004dc6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/10afa0d6db391623eecaf87fa004dc6d.jpg\" style=\"\"/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/427865bf514f70b9d3eeca7929a9b754.jpg\" _src=\"http://yanxuan.nosdn.127.net/427865bf514f70b9d3eeca7929a9b754.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6841486484cd3163b8d84856b6090f50.jpg\" _src=\"http://yanxuan.nosdn.127.net/6841486484cd3163b8d84856b6090f50.jpg\"/></p>', '1', '2017-08-30 11:40:11', '33', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0a1b41d34a90d72be9f3c4ca1c2afc9a.jpg', 'http://yanxuan.nosdn.127.net/a8b0a5def7d64e411dd98bdfb1fc989b.png', '299.00', '21', '1009001', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1011004', '1036000', '1011004', '色织精梳AB纱格纹空调被', '1001000', '100', '', '加大加厚，双色精彩', '<p><img src=\"http://yanxuan.nosdn.127.net/28680639193b939b5d93cd77b3272a1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/28680639193b939b5d93cd77b3272a1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/990c9a7781a8ae2b2a08c65c9af7afc7.jpg\" _src=\"http://yanxuan.nosdn.127.net/990c9a7781a8ae2b2a08c65c9af7afc7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7ccc07b50f491e94b6187bf49b48820.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7ccc07b50f491e94b6187bf49b48820.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69eb85fd08c9ebce511d13d899d96659.jpg\" _src=\"http://yanxuan.nosdn.127.net/69eb85fd08c9ebce511d13d899d96659.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a96f2f48217b913dc012671ed511d223.jpg\" _src=\"http://yanxuan.nosdn.127.net/a96f2f48217b913dc012671ed511d223.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c94a22b8644fafec3ff27f87dd12771b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c94a22b8644fafec3ff27f87dd12771b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/721b4749caada515bb5e616f41a410d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/721b4749caada515bb5e616f41a410d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1215d6badb5a922efaeadd36911a4a3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1215d6badb5a922efaeadd36911a4a3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/749a3c6e9228d304806a06e478644ca1.jpg\" _src=\"http://yanxuan.nosdn.127.net/749a3c6e9228d304806a06e478644ca1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2cc7fd2eadbef5ab061fdf3550962d4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/2cc7fd2eadbef5ab061fdf3550962d4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/710b9318f02863fe79209e7e6c822a5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/710b9318f02863fe79209e7e6c822a5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aaf8500212ec5bf783cb2bc63afbf7f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/aaf8500212ec5bf783cb2bc63afbf7f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f9e03dfb8cacda0f8fbbcf0ef20f8a62.jpg\" _src=\"http://yanxuan.nosdn.127.net/f9e03dfb8cacda0f8fbbcf0ef20f8a62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fa109d21bda840ac7040b196c13a871.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fa109d21bda840ac7040b196c13a871.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76bfa90446c129fa3eb9f05104e9e778.jpg\" _src=\"http://yanxuan.nosdn.127.net/76bfa90446c129fa3eb9f05104e9e778.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3b94053478ceb6912a28597c51a3bcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3b94053478ceb6912a28597c51a3bcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a25bca01f9ad835cd79b1c11ffdb400e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a25bca01f9ad835cd79b1c11ffdb400e.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4de19773ac86263bc5f474c1351c6df4.png', 'http://yanxuan.nosdn.127.net/0984c9388a2c3fd2335779da904be393.png', '199.00', '1007', '1010014', '0.00', '限时购', '', '0.00', '0', '0', '1', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1015007', '1008002', '1015007', '典雅美式全棉刺绣抱枕', '0', '100', '', '典雅毛线绣，精致工艺', '<p><img src=\"http://yanxuan.nosdn.127.net/66640f55aeb668ac9df6e26b6b30adb5.jpg\" _src=\"http://yanxuan.nosdn.127.net/66640f55aeb668ac9df6e26b6b30adb5.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42852faba5623c6dc5be451d80e5df03.jpg\" _src=\"http://yanxuan.nosdn.127.net/42852faba5623c6dc5be451d80e5df03.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48ce93c6f6a731778c505442f163b09e.jpg\" _src=\"http://yanxuan.nosdn.127.net/48ce93c6f6a731778c505442f163b09e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02a3abee9bb3e22f27781ced8774d1ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/02a3abee9bb3e22f27781ced8774d1ab.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c62a27145e1045879e3f2b97b9f86b4d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c62a27145e1045879e3f2b97b9f86b4d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48baaafe4ea4c32242c57e58ce8e139f.jpg\" _src=\"http://yanxuan.nosdn.127.net/48baaafe4ea4c32242c57e58ce8e139f.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99549f0375b108240866a09a0a2527d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/99549f0375b108240866a09a0a2527d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/341529ba80d91c5304680be8f524a626.jpg\" _src=\"http://yanxuan.nosdn.127.net/341529ba80d91c5304680be8f524a626.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b15e35e9d8c04288dfb7546b1f743c17.jpg\" _src=\"http://yanxuan.nosdn.127.net/b15e35e9d8c04288dfb7546b1f743c17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c0ebf7949133cb382b6bf18c8a5a1c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c0ebf7949133cb382b6bf18c8a5a1c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfd25d0fa6dc13a335877360e3dab8d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfd25d0fa6dc13a335877360e3dab8d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbcc420cef18e4a43589198ebfcc4fd1.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbcc420cef18e4a43589198ebfcc4fd1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15aa3e3ed45714d29ca062499db930ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/15aa3e3ed45714d29ca062499db930ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab6963b4e529810577f3e428c9d10af6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab6963b4e529810577f3e428c9d10af6.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/d16d6fb25f3d6d8c356fcd8e178bdd26.jpg', 'http://yanxuan.nosdn.127.net/a2045004de8a6225289376ad54317fc8.png', '59.00', '133', '1013024', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1019000', '1008008', '1019000', '升级款护颈波浪记忆枕', '0', '100', '', '享受自在侧睡', '<p><img src=\"http://yanxuan.nosdn.127.net/c1e5ff831fd66e404c8b2ac90b91c4e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1e5ff831fd66e404c8b2ac90b91c4e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0118ea9e0c1aa9596f9b57a8d862581.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0118ea9e0c1aa9596f9b57a8d862581.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/948f4095c7efbd2a1a7bfd624321b2e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/948f4095c7efbd2a1a7bfd624321b2e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b415b3b9e48688d3c81c96edbe5a26a.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b415b3b9e48688d3c81c96edbe5a26a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a841d953c5d0ec3dbce02152bb44c2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a841d953c5d0ec3dbce02152bb44c2f.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2ce236ff050b8743bc2139c25db084d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2ce236ff050b8743bc2139c25db084d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8dac2a76d5886429b8417cdd48bcbb7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8dac2a76d5886429b8417cdd48bcbb7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b79a8aac5584b137a3b010897415510e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b79a8aac5584b137a3b010897415510e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/100e058ca7bf727ac206147961e2638d.jpg\" _src=\"http://yanxuan.nosdn.127.net/100e058ca7bf727ac206147961e2638d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/746152d0f88b32455c1a85691a18ee0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/746152d0f88b32455c1a85691a18ee0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56d32b1bef15fd6f4b5780466b04c69d.jpg\" _src=\"http://yanxuan.nosdn.127.net/56d32b1bef15fd6f4b5780466b04c69d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e949e68bdec54d89a8c55579da4eedd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/e949e68bdec54d89a8c55579da4eedd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cee6a2ffbde4cfcc6f4e6bcaa824a28c.jpg\" _src=\"http://yanxuan.nosdn.127.net/cee6a2ffbde4cfcc6f4e6bcaa824a28c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ac36b88f968048e02a9d074a0d28478.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ac36b88f968048e02a9d074a0d28478.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ed41d77cb4db472e73d996ca8566305.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ed41d77cb4db472e73d996ca8566305.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccc002f264cd53415811961486ae49bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccc002f264cd53415811961486ae49bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21b631c1147dee010fc3a7060feb8497.jpg\" _src=\"http://yanxuan.nosdn.127.net/21b631c1147dee010fc3a7060feb8497.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/124748dc5e030621db17ff341024cf9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/124748dc5e030621db17ff341024cf9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/800ff0bc68c16062cd128a4850bb0800.jpg\" _src=\"http://yanxuan.nosdn.127.net/800ff0bc68c16062cd128a4850bb0800.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7add37eaba2dcfc34441f8a6d605ddc7.jpg\" _src=\"http://yanxuan.nosdn.127.net/7add37eaba2dcfc34441f8a6d605ddc7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c078aab2f23798ff88e1623e01694ff2.jpg\" _src=\"http://yanxuan.nosdn.127.net/c078aab2f23798ff88e1623e01694ff2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9fb2a267c184178d454c48a519338bfb.jpg\" _src=\"http://yanxuan.nosdn.127.net/9fb2a267c184178d454c48a519338bfb.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/81b2529f4d516bcd6f9225ae825ed1b6.jpg', 'http://yanxuan.nosdn.127.net/77c09feb378814be712741b273d16656.png', '99.00', '2805', '1017000', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1019001', '1008008', '1019001', '升级款护颈加翼记忆枕', '0', '100', '', '仰睡优质装备', '<p><img src=\"http://yanxuan.nosdn.127.net/c6eb7df0cb54b1efd167d8c9fb499d4d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6eb7df0cb54b1efd167d8c9fb499d4d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6df32e9289c2e47966c3b117268698a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6df32e9289c2e47966c3b117268698a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92adf10bf5bb25403f449ec1e8612223.jpg\" _src=\"http://yanxuan.nosdn.127.net/92adf10bf5bb25403f449ec1e8612223.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f4b631f23c4d86aa3c6882258f1ed61.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f4b631f23c4d86aa3c6882258f1ed61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/484044307538426c6c79d88891a44573.jpg\" _src=\"http://yanxuan.nosdn.127.net/484044307538426c6c79d88891a44573.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3340218a14eb10f023410cb7b14ff5c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/3340218a14eb10f023410cb7b14ff5c7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12f8e836b270f459bb9a7d0fd043f840.jpg\" _src=\"http://yanxuan.nosdn.127.net/12f8e836b270f459bb9a7d0fd043f840.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/234a40d515b4ef5283a4b307aa694880.jpg\" _src=\"http://yanxuan.nosdn.127.net/234a40d515b4ef5283a4b307aa694880.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b999f414bab88eb61dc8c7c19e43784b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b999f414bab88eb61dc8c7c19e43784b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/729907923ec1d1c987b4fc9a3aab75da.jpg\" _src=\"http://yanxuan.nosdn.127.net/729907923ec1d1c987b4fc9a3aab75da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86c4cfbca9b18f1931fd6424d504f58c.jpg\" _src=\"http://yanxuan.nosdn.127.net/86c4cfbca9b18f1931fd6424d504f58c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11cd2b57e9430b77019c1148ffc98e00.jpg\" _src=\"http://yanxuan.nosdn.127.net/11cd2b57e9430b77019c1148ffc98e00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9025355615221491eeb0028f52c1190.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9025355615221491eeb0028f52c1190.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6541688751bf78732def7b1e7b80acde.jpg\" _src=\"http://yanxuan.nosdn.127.net/6541688751bf78732def7b1e7b80acde.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a307a08fe871cda58d345c3d27aec637.jpg\" _src=\"http://yanxuan.nosdn.127.net/a307a08fe871cda58d345c3d27aec637.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d0c08ea2cce7fa09cd20463687fde2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d0c08ea2cce7fa09cd20463687fde2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a141d9a027680a921b70adabb9e822f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/a141d9a027680a921b70adabb9e822f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8eb750a2ce2373be40b852aaf0494edf.jpg\" _src=\"http://yanxuan.nosdn.127.net/8eb750a2ce2373be40b852aaf0494edf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2275f3636c0719ab83d7391993da903a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2275f3636c0719ab83d7391993da903a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d05c90aa86f19886e94e402305dada1.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d05c90aa86f19886e94e402305dada1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0acbac29252596be257c86a590eb567a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0acbac29252596be257c86a590eb567a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c99b1fd6b0b812a289b5887233453646.jpg\" _src=\"http://yanxuan.nosdn.127.net/c99b1fd6b0b812a289b5887233453646.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e45ab89e057c3f73c0b06464115ea357.jpg\" _src=\"http://yanxuan.nosdn.127.net/e45ab89e057c3f73c0b06464115ea357.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08f026762e2459f85f66766e4ea3e195.jpg\" _src=\"http://yanxuan.nosdn.127.net/08f026762e2459f85f66766e4ea3e195.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3365604b1b01c7a99d31a5307991bbb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3365604b1b01c7a99d31a5307991bbb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2406859dfe2befe93927346fe1317c22.jpg\" _src=\"http://yanxuan.nosdn.127.net/2406859dfe2befe93927346fe1317c22.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0121587794b92e2a5bba41460984f091.jpg\" _src=\"http://yanxuan.nosdn.127.net/0121587794b92e2a5bba41460984f091.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5187cfe2da36ce4c3946aa6d6ce23461.jpg\" _src=\"http://yanxuan.nosdn.127.net/5187cfe2da36ce4c3946aa6d6ce23461.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07447d11bdb3db402bd06a991f765052.jpg\" _src=\"http://yanxuan.nosdn.127.net/07447d11bdb3db402bd06a991f765052.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5219f74a5884e3bd4dc2a44c40ac521.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5219f74a5884e3bd4dc2a44c40ac521.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca006cc5c87ccde67019c28e7627d0fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca006cc5c87ccde67019c28e7627d0fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3260e27582b77978faee526a2a3c9d68.jpg\" _src=\"http://yanxuan.nosdn.127.net/3260e27582b77978faee526a2a3c9d68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95093aa9450eb598e110bfa7903dce7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/95093aa9450eb598e110bfa7903dce7f.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/71650a4e0e793500e8ac08a328b76812.jpg', 'http://yanxuan.nosdn.127.net/7644803ab19b3e398456aa5a54229363.png', '109.00', '2961', '1017001', '0.00', '限时购', '', '0.00', '0', '0', '0', '119.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1019002', '1008008', '1019002', '升级款护颈双人记忆枕', '0', '100', '', '共享亲密2人时光', '<p><img src=\"http://yanxuan.nosdn.127.net/c186a059de5eefc906216f4b30592330.jpg\" _src=\"http://yanxuan.nosdn.127.net/c186a059de5eefc906216f4b30592330.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6de82771ca1dd4cece4b16dcc306f83.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6de82771ca1dd4cece4b16dcc306f83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df2daa178d711c8ea0ba9dbc52ce2686.jpg\" _src=\"http://yanxuan.nosdn.127.net/df2daa178d711c8ea0ba9dbc52ce2686.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14c3e64ba6565efe976952e2b6ae615d.jpg\" _src=\"http://yanxuan.nosdn.127.net/14c3e64ba6565efe976952e2b6ae615d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e2cf982e78628f3a0acb911fc274b9b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/e2cf982e78628f3a0acb911fc274b9b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e81eaa79cf531ef8ab46a30dff994f33.jpg\" _src=\"http://yanxuan.nosdn.127.net/e81eaa79cf531ef8ab46a30dff994f33.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b5b19aaddb243ce516b5db29c1ef90d.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b5b19aaddb243ce516b5db29c1ef90d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58cea18ebf8b094dcd62bd879fc040e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/58cea18ebf8b094dcd62bd879fc040e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72b901a3f652c51fffa1a1de204aba31.jpg\" _src=\"http://yanxuan.nosdn.127.net/72b901a3f652c51fffa1a1de204aba31.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0e9d94f5c2ee8533b68e2db7746b534.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0e9d94f5c2ee8533b68e2db7746b534.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b705431d490adf12a9e5ec7b43e7607f.jpg\" _src=\"http://yanxuan.nosdn.127.net/b705431d490adf12a9e5ec7b43e7607f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2bb4b705eabd3e5992dfab146bc2b3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2bb4b705eabd3e5992dfab146bc2b3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bdf08a6dfd6d2ef299121bd9dd39c0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bdf08a6dfd6d2ef299121bd9dd39c0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67c113a1c29d4db5bdb55f3ae06f7471.jpg\" _src=\"http://yanxuan.nosdn.127.net/67c113a1c29d4db5bdb55f3ae06f7471.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7733f0d7f4b0a66c247e60e3b49b1807.jpg\" _src=\"http://yanxuan.nosdn.127.net/7733f0d7f4b0a66c247e60e3b49b1807.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95eab4e49e0f3b0c3ffd2b08797d284b.jpg\" _src=\"http://yanxuan.nosdn.127.net/95eab4e49e0f3b0c3ffd2b08797d284b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c468ae0e82c662ae0abb227abc6d594.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c468ae0e82c662ae0abb227abc6d594.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d53e9751dd2634990d89fb44a55ee566.jpg\" _src=\"http://yanxuan.nosdn.127.net/d53e9751dd2634990d89fb44a55ee566.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c73eff0b7f7cd8040aad206313d0abe.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c73eff0b7f7cd8040aad206313d0abe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e74edf9fe31e71f1833773a312b4326.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e74edf9fe31e71f1833773a312b4326.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ea7a4055b77399ee1d20e2cbf7812d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ea7a4055b77399ee1d20e2cbf7812d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1e514096c4fdf3d54904fb29dc6a37c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1e514096c4fdf3d54904fb29dc6a37c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f305812a19b9147f8fa770beb4414459.jpg\" _src=\"http://yanxuan.nosdn.127.net/f305812a19b9147f8fa770beb4414459.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3acf6bc12a45cce9e5976ad27b09a60d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3acf6bc12a45cce9e5976ad27b09a60d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/985e651c504cd41e4d39b7f41f34c677.jpg\" _src=\"http://yanxuan.nosdn.127.net/985e651c504cd41e4d39b7f41f34c677.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76fdc45c20487b3cface59a5ee70ddb9.jpg\" _src=\"http://yanxuan.nosdn.127.net/76fdc45c20487b3cface59a5ee70ddb9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcac72497ef8f724c6761757eef857b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcac72497ef8f724c6761757eef857b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ada89064fd6a44ce87714431540e792.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ada89064fd6a44ce87714431540e792.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0d6b2c71c9572a68c58e0695e7e8e3c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0d6b2c71c9572a68c58e0695e7e8e3c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52cb1f494073a399179b2b49b8ea25ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/52cb1f494073a399179b2b49b8ea25ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9778eca1ecc98ce85c0952a3ef7f0c4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9778eca1ecc98ce85c0952a3ef7f0c4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0feec16f0b84c7693a0ee5ba81cd28d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0feec16f0b84c7693a0ee5ba81cd28d.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '10', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/8117b7048e8be50570d1410565eb352e.jpg', 'http://yanxuan.nosdn.127.net/0118039f7cda342651595d994ed09567.png', '199.00', '37', '1017002', '0.00', '限时购', '', '0.00', '0', '0', '1', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1019006', '1008008', '1019006', '植物填充护颈夜交藤枕', '0', '100', '', '健康保护枕', '<p><img src=\"http://yanxuan.nosdn.127.net/dbb1e80da69953f64383dd71fd0213f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbb1e80da69953f64383dd71fd0213f5.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6acc4669a29c55f5c222414ad01bf89b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6acc4669a29c55f5c222414ad01bf89b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/514bd211189416cfd66867b7894e64ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/514bd211189416cfd66867b7894e64ec.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6291db12d9239a17cc4a746db803a307.jpg\" _src=\"http://yanxuan.nosdn.127.net/6291db12d9239a17cc4a746db803a307.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c12eb42828a8b7aa9b428e34b7a6af5.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c12eb42828a8b7aa9b428e34b7a6af5.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/592207ddff96c716e5a8d3e02ba80151.jpg\" _src=\"http://yanxuan.nosdn.127.net/592207ddff96c716e5a8d3e02ba80151.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b58dac5f4495fa73d8df137d4aa611d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b58dac5f4495fa73d8df137d4aa611d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89e5a35e2763cd977f5ecb30f20651ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/89e5a35e2763cd977f5ecb30f20651ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9b35ce1283c07e4f757e48016258e2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9b35ce1283c07e4f757e48016258e2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29d555239824f9d3f92526120b75550c.jpg\" _src=\"http://yanxuan.nosdn.127.net/29d555239824f9d3f92526120b75550c.jpg\"/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/8d6f1d95b4e15bfda45410be6a9d83c2.jpg', 'http://yanxuan.nosdn.127.net/60c3707837c97a21715ecc3986a744ce.png', '99.00', '10', '1017014', '0.00', '限时购', '', '0.00', '0', '0', '1', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1020000', '1008002', '1020000', '升级款记忆绵护椎腰靠', '1001000', '100', '', '人体工学设计，缓解腰背疼痛', '<p><img src=\"http://yanxuan.nosdn.127.net/8176934e414ec6c85078cb64322fe336.jpg\" _src=\"http://yanxuan.nosdn.127.net/8176934e414ec6c85078cb64322fe336.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33ff256b2f69de517f567ebb993dd08e.jpg\" _src=\"http://yanxuan.nosdn.127.net/33ff256b2f69de517f567ebb993dd08e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5204e4f7c7fa00866e270a93ec85a596.jpg\" _src=\"http://yanxuan.nosdn.127.net/5204e4f7c7fa00866e270a93ec85a596.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f3aed0164b92344f17ffbc0b8fc7ade.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f3aed0164b92344f17ffbc0b8fc7ade.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d2d94d8f0f10f17183954b69d09e2bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d2d94d8f0f10f17183954b69d09e2bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3921600dd00e2c49a7414035111b767d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3921600dd00e2c49a7414035111b767d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aef3c726fec0be6ce17089e06e753d4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/aef3c726fec0be6ce17089e06e753d4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/446fbad756b6327898cee40e7b67a0b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/446fbad756b6327898cee40e7b67a0b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0950b4fa1cac49eece29af35c6e69e4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0950b4fa1cac49eece29af35c6e69e4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf7e88b2b57641ab81bbf36351db5ff8.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf7e88b2b57641ab81bbf36351db5ff8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53d66b4714682aaff4ab082980a44b46.jpg\" _src=\"http://yanxuan.nosdn.127.net/53d66b4714682aaff4ab082980a44b46.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7f2d82d7a5622dd9f6b0d44faed9fda.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7f2d82d7a5622dd9f6b0d44faed9fda.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7fdc566d101b7cf73cee32f55b0f945.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7fdc566d101b7cf73cee32f55b0f945.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e04202364d1a0a1dc1a2a1ea871e45e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e04202364d1a0a1dc1a2a1ea871e45e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b3135ad6c01a2675fc7e96f6643ff7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b3135ad6c01a2675fc7e96f6643ff7f.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '15', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/84563d90b0c10c4d4a8229fd34cb4063.jpg', 'http://yanxuan.nosdn.127.net/819fdf1f635a694166bcfdd426416e8c.png', '79.00', '8586', '1018000', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1021000', '1008001', '1021000', '埃及进口长绒棉毛巾', '0', '100', '', '厚实舒适', '', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '条', 'http://yanxuan.nosdn.127.net/96c20e15c503ff5e358a150148f2f352.jpg', 'http://yanxuan.nosdn.127.net/7191f2599c7fe44ed4cff7a76e853154.png', '39.00', '34530', '1122018', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1021001', '1008001', '1021001', '全棉进口埃及长绒棉浴巾', '0', '100', '', '加大加厚埃及棉', '', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/c41c58a7c72e8340211041cd493b1517.jpg', 'http://yanxuan.nosdn.127.net/fd5a8622ee1a7dfd4b57b938ebf25b24.png', '99.00', '35029', '1122028', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1021004', '1008009', '1021004', '澳洲羊羔毛AB面盖毯', '1001020', '100', '', '冬暖夏凉，吸湿排汗。', '<p><img src=\"http://yanxuan.nosdn.127.net/7a82ce63285fa75e7c45958db6e1ea72.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a82ce63285fa75e7c45958db6e1ea72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6251683549d0cefad6d75d48371ee5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6251683549d0cefad6d75d48371ee5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/332da1ccf902e60d638ee7a10b376949.jpg\" _src=\"http://yanxuan.nosdn.127.net/332da1ccf902e60d638ee7a10b376949.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46b7c34a5c80742a1c2e64c984aadf45.jpg\" _src=\"http://yanxuan.nosdn.127.net/46b7c34a5c80742a1c2e64c984aadf45.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0309bc61af948669fe361b33271c79cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/0309bc61af948669fe361b33271c79cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6d61c696d3194672cbfc760e2dfab04.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6d61c696d3194672cbfc760e2dfab04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ece10fc88b908d9166e3f0fb5654b34.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ece10fc88b908d9166e3f0fb5654b34.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01da8df479e8eade44e5b97d98d2ecdc.jpg\" _src=\"http://yanxuan.nosdn.127.net/01da8df479e8eade44e5b97d98d2ecdc.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e94e41f4b0fc8a91b48d111cf559963.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e94e41f4b0fc8a91b48d111cf559963.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39cc39f48b07dcd55280d6d41446a855.jpg\" _src=\"http://yanxuan.nosdn.127.net/39cc39f48b07dcd55280d6d41446a855.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbb6f955287c419cb2560b9a92507fbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbb6f955287c419cb2560b9a92507fbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2e23c277654ce9cda3f0222c0cdfd9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2e23c277654ce9cda3f0222c0cdfd9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5c537f3406d0b0cb7f432654d73456c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5c537f3406d0b0cb7f432654d73456c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fa0b1d1392d2755d8c76e5166717271.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fa0b1d1392d2755d8c76e5166717271.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/533ac276228fb4f4708407dbc9557074.jpg\" _src=\"http://yanxuan.nosdn.127.net/533ac276228fb4f4708407dbc9557074.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b8abe94b174667084cfaa909a1a6ae8.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b8abe94b174667084cfaa909a1a6ae8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90651cf71db15227b9d691e55f0a75da.jpg\" _src=\"http://yanxuan.nosdn.127.net/90651cf71db15227b9d691e55f0a75da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24c44cd0e9cc09849bbcd48235b81dac.jpg\" _src=\"http://yanxuan.nosdn.127.net/24c44cd0e9cc09849bbcd48235b81dac.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '32', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ee906abd9b2aa273ad28ea544fdac479.png', 'http://yanxuan.nosdn.127.net/654b02045fde802b51d5bbf09a8b75f2.png', '299.00', '1323', '1019010', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1021010', '1008009', '1021010', '色织水洗棉纯色四件套', '0', '100', '', '做旧褶皱感，亲肤舒适', '<p><img src=\"http://yanxuan.nosdn.127.net/16227b81865dce643b91b00ea6c39012.jpg\" _src=\"http://yanxuan.nosdn.127.net/16227b81865dce643b91b00ea6c39012.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/427ef03b20aa52014ab9d91c3f9fdb5e.jpg\" _src=\"http://yanxuan.nosdn.127.net/427ef03b20aa52014ab9d91c3f9fdb5e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc2466433e832c592e537f0f54bc1702.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc2466433e832c592e537f0f54bc1702.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2bcd099ad5167317a73354291f2c007.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2bcd099ad5167317a73354291f2c007.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da75827b70675306c6ca7d63bef5ffb1.jpg\" _src=\"http://yanxuan.nosdn.127.net/da75827b70675306c6ca7d63bef5ffb1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ffc1fcd1d8afcbfa43b727eb40842ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ffc1fcd1d8afcbfa43b727eb40842ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8ae03d8ff640eaffb14ba37a83b137f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8ae03d8ff640eaffb14ba37a83b137f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52c5f880b8e1a7cb7900616bd13a4b62.jpg\" _src=\"http://yanxuan.nosdn.127.net/52c5f880b8e1a7cb7900616bd13a4b62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b77db532462faf31bed3c4629a1ecbf.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b77db532462faf31bed3c4629a1ecbf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07efa2bf79478f24799ff0a4cbfa0e54.jpg\" _src=\"http://yanxuan.nosdn.127.net/07efa2bf79478f24799ff0a4cbfa0e54.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68070ec063cb05000ed7aef2b3ef1632.jpg\" _src=\"http://yanxuan.nosdn.127.net/68070ec063cb05000ed7aef2b3ef1632.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd54998d1cc11890f2650c74e7bfd340.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd54998d1cc11890f2650c74e7bfd340.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '15', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/d98b95d0b04d88ac68bbd4586cf9e5b4.jpg', 'http://yanxuan.nosdn.127.net/25d734cc0b2eae8f63f9deb1e4ad5f64.png', '299.00', '756', '1019028', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1022000', '1008009', '1022000', '意式毛线绣球四件套', '1001020', '100', '', '浪漫毛线绣球，简约而不简单', '<p><img src=\"http://yanxuan.nosdn.127.net/3f63478dd19081036c7c8061a88438b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f63478dd19081036c7c8061a88438b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a437697cad2ac00a76b8a2a9f9f7819b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a437697cad2ac00a76b8a2a9f9f7819b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30607b946fa5245ab1376d28ab8d68c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/30607b946fa5245ab1376d28ab8d68c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d18e17059acf20d507fdb8f7054968a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/d18e17059acf20d507fdb8f7054968a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61a0539ce8ca1f38cce7c5647c94aaf7.jpg\" _src=\"http://yanxuan.nosdn.127.net/61a0539ce8ca1f38cce7c5647c94aaf7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec45424eef32b60e477bf6860f6c3ac2.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec45424eef32b60e477bf6860f6c3ac2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2fb058299e851d21128af4c29bbf40f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2fb058299e851d21128af4c29bbf40f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88fcf4d3d09cc26809eaabf0df4ddc84.jpg\" _src=\"http://yanxuan.nosdn.127.net/88fcf4d3d09cc26809eaabf0df4ddc84.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/505360bfb9ae52b707d194195b547d1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/505360bfb9ae52b707d194195b547d1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d359fdfda280d2c7681adee5a533a65d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d359fdfda280d2c7681adee5a533a65d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6276ab49a773dedadd75da6529fc41b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6276ab49a773dedadd75da6529fc41b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6057375f8fdafdc1e8e7a894bb2f39a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6057375f8fdafdc1e8e7a894bb2f39a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2059408e8aee017c85e47c7267af21bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/2059408e8aee017c85e47c7267af21bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a7e4c7b19fd7822f89ccd63ca94b234.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a7e4c7b19fd7822f89ccd63ca94b234.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/937329152fc61bff06d29d4b316b7259.jpg\" _src=\"http://yanxuan.nosdn.127.net/937329152fc61bff06d29d4b316b7259.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7bc2c66157bd5e2cdc978460214d33c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7bc2c66157bd5e2cdc978460214d33c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55d327d74e2c768006fcce7f83cf0051.jpg\" _src=\"http://yanxuan.nosdn.127.net/55d327d74e2c768006fcce7f83cf0051.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d06b9bef3bae34d66d38e30fad204d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d06b9bef3bae34d66d38e30fad204d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1f4f2ee0a473c251c055ffeb25426d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1f4f2ee0a473c251c055ffeb25426d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b7efe85839b1f1ea17c829563fc9206.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b7efe85839b1f1ea17c829563fc9206.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca4091e28e5b8cfd76c1ad3de8fda999.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca4091e28e5b8cfd76c1ad3de8fda999.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ebd7266b6b01bddadf4903e8ca66a82a.jpg\" _src=\"http://yanxuan.nosdn.127.net/ebd7266b6b01bddadf4903e8ca66a82a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db777171b81a10c51bae065de7fbef7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/db777171b81a10c51bae065de7fbef7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/416626d4074c929f080eff87586a49e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/416626d4074c929f080eff87586a49e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c23701559de65d814e9062847e87c6db.jpg\" _src=\"http://yanxuan.nosdn.127.net/c23701559de65d814e9062847e87c6db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/200d89ca470fa10ac02971f26cf8f7fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/200d89ca470fa10ac02971f26cf8f7fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6c39f0cf32656244e699eb21089f434.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6c39f0cf32656244e699eb21089f434.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/287fa73c7e8b56eb8bd0ecee08c865da.jpg\" _src=\"http://yanxuan.nosdn.127.net/287fa73c7e8b56eb8bd0ecee08c865da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0807995485258c26c712169290aac892.jpg\" _src=\"http://yanxuan.nosdn.127.net/0807995485258c26c712169290aac892.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c29f153a2fada82300a904b2ca46eeeb.jpg\" _src=\"http://yanxuan.nosdn.127.net/c29f153a2fada82300a904b2ca46eeeb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcd0c03d117c27a5c8856aabe577535e.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcd0c03d117c27a5c8856aabe577535e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f9d6c1f265a891458ec9646801a9f790.jpg\" _src=\"http://yanxuan.nosdn.127.net/f9d6c1f265a891458ec9646801a9f790.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bce3852bdd99bc428e5339dcec1749b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bce3852bdd99bc428e5339dcec1749b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0076b7513361cb10daa6cdae51b0238f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0076b7513361cb10daa6cdae51b0238f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b289f3fdd57ba7c2f9bfed5cc235ad5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b289f3fdd57ba7c2f9bfed5cc235ad5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea27ef8fcca46882e225ab03f29cc4c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea27ef8fcca46882e225ab03f29cc4c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0bbddfd513a56bb4b4e60b0d7485261.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0bbddfd513a56bb4b4e60b0d7485261.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b6904ddbb813688f8e1c36874437b8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b6904ddbb813688f8e1c36874437b8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87439f2dc3805340736a508bfb4fc044.jpg\" _src=\"http://yanxuan.nosdn.127.net/87439f2dc3805340736a508bfb4fc044.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29ca62c0aee1df52a9435ed2bf915b06.jpg\" _src=\"http://yanxuan.nosdn.127.net/29ca62c0aee1df52a9435ed2bf915b06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/993cfb5a549e93a86ac5a5485221ded3.jpg\" _src=\"http://yanxuan.nosdn.127.net/993cfb5a549e93a86ac5a5485221ded3.jpg\" style=\"\"/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '18', '0', '0', '399.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/fc4e15c98813310e8bd10091e5e1d3ca.jpg', 'http://yanxuan.nosdn.127.net/5350e35e6f22165f38928f3c2c52ac57.png', '299.00', '690', '1020000', '0.00', '限时购', '限时购', '0.00', '0', '203', '1', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1022001', '1008009', '1022001', '法式浪漫绣球四件套', '1001020', '100', '', '浪漫绣球，法式般的呵护', '<p><img src=\"http://yanxuan.nosdn.127.net/3caeae4eca0f08bc143f5c57412d6bcd.jpg\" _src=\"http://yanxuan.nosdn.127.net/3caeae4eca0f08bc143f5c57412d6bcd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01f377d37098d65602e2447788b93dfc.jpg\" _src=\"http://yanxuan.nosdn.127.net/01f377d37098d65602e2447788b93dfc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b47996d9b47ddb13789a4ace965328ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/b47996d9b47ddb13789a4ace965328ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5daff2af7d1940210efba1d94057b073.jpg\" _src=\"http://yanxuan.nosdn.127.net/5daff2af7d1940210efba1d94057b073.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a1d01003115794950d3e4f110403fdfd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a1d01003115794950d3e4f110403fdfd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62c33967eb50d98eb09246092a054f74.jpg\" _src=\"http://yanxuan.nosdn.127.net/62c33967eb50d98eb09246092a054f74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29792456f207afd95a62d60214a01851.jpg\" _src=\"http://yanxuan.nosdn.127.net/29792456f207afd95a62d60214a01851.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cda3817dcffa4e1be4e479724e7f035.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cda3817dcffa4e1be4e479724e7f035.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cf34c4567ec6dbe839339698a3adf30.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cf34c4567ec6dbe839339698a3adf30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e64a01d30c65cea7c4ddf8f2229870d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e64a01d30c65cea7c4ddf8f2229870d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/413863b3cabcbc94e322e9d2910f66ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/413863b3cabcbc94e322e9d2910f66ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99ce4e6124b75df99e4d4b8de6878c5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/99ce4e6124b75df99e4d4b8de6878c5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/403a8d6fa2422a0587cd2063f28cbbe1.jpg\" _src=\"http://yanxuan.nosdn.127.net/403a8d6fa2422a0587cd2063f28cbbe1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/099a401a319dae53cc5a7705f7b657fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/099a401a319dae53cc5a7705f7b657fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85dd8f3d5a6e885604d5fda96c39f281.jpg\" _src=\"http://yanxuan.nosdn.127.net/85dd8f3d5a6e885604d5fda96c39f281.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22ea153a4825aa13770743eb6a1d766f.jpg\" _src=\"http://yanxuan.nosdn.127.net/22ea153a4825aa13770743eb6a1d766f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/578698b1a104997b3632db1f9dc74c6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/578698b1a104997b3632db1f9dc74c6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b0b8b276985770b2e1c904e676de897.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b0b8b276985770b2e1c904e676de897.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44f167771765a070a19c9ff6c130747e.jpg\" _src=\"http://yanxuan.nosdn.127.net/44f167771765a070a19c9ff6c130747e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/342e7982df39b39f5bde5066c2421c24.jpg\" _src=\"http://yanxuan.nosdn.127.net/342e7982df39b39f5bde5066c2421c24.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3db52e63ab4b82aa5544bb68bf494da5.jpg\" _src=\"http://yanxuan.nosdn.127.net/3db52e63ab4b82aa5544bb68bf494da5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4449875c22659a531bbd6eb104f45e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4449875c22659a531bbd6eb104f45e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/177cf74899157b8edec80f14bdff2666.jpg\" _src=\"http://yanxuan.nosdn.127.net/177cf74899157b8edec80f14bdff2666.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5a4bf58ec86ccceaeeae46a800be248.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5a4bf58ec86ccceaeeae46a800be248.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aedd86730887d4ce9ab4ce11367e70e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/aedd86730887d4ce9ab4ce11367e70e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80a075b3084c766d313005abf44b59a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/80a075b3084c766d313005abf44b59a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e2fbec13573dbd9fcc14b32fb9ca95e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e2fbec13573dbd9fcc14b32fb9ca95e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48a2191cf1e56304bb2a8dc84c18dc55.jpg\" _src=\"http://yanxuan.nosdn.127.net/48a2191cf1e56304bb2a8dc84c18dc55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7daef2160a7c2838b144cb4426e9232d.jpg\" _src=\"http://yanxuan.nosdn.127.net/7daef2160a7c2838b144cb4426e9232d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be2ba2e98e8f6c3a3e0a22bba52cde64.jpg\" _src=\"http://yanxuan.nosdn.127.net/be2ba2e98e8f6c3a3e0a22bba52cde64.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/706f8518e4f9f0868efd6c06a92374b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/706f8518e4f9f0868efd6c06a92374b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7377480490be9c4989733bfb20960553.jpg\" _src=\"http://yanxuan.nosdn.127.net/7377480490be9c4989733bfb20960553.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02f382fffc5e413d2c2c20f3ed1f7cbc.jpg\" _src=\"http://yanxuan.nosdn.127.net/02f382fffc5e413d2c2c20f3ed1f7cbc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dba4773485150b157bdb304a4b7c64c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/dba4773485150b157bdb304a4b7c64c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a0662a11f315dfaad974a20f9195eef.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a0662a11f315dfaad974a20f9195eef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08dc21856b99613f59d501f99c54a577.jpg\" _src=\"http://yanxuan.nosdn.127.net/08dc21856b99613f59d501f99c54a577.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6723f2a290b14dea262b0abddc3464f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6723f2a290b14dea262b0abddc3464f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2dd2e85a09efff621454acd0a96c3497.jpg\" _src=\"http://yanxuan.nosdn.127.net/2dd2e85a09efff621454acd0a96c3497.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a317a6b832d9321a69c8966409f68ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a317a6b832d9321a69c8966409f68ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4031ea25471029f59ce36da8e0ce38e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4031ea25471029f59ce36da8e0ce38e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8beeebd28e23d906d7916ab4575f3800.jpg\" _src=\"http://yanxuan.nosdn.127.net/8beeebd28e23d906d7916ab4575f3800.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c65e967c692d7150baf9fee28f262935.jpg\" _src=\"http://yanxuan.nosdn.127.net/c65e967c692d7150baf9fee28f262935.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fc96c7688f33de5876b358fdf31ebf2.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fc96c7688f33de5876b358fdf31ebf2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94adba0162052a5758ec9d8426123198.jpg\" _src=\"http://yanxuan.nosdn.127.net/94adba0162052a5758ec9d8426123198.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/152038e70480f6ba580a4830dc36b2de.jpg\" _src=\"http://yanxuan.nosdn.127.net/152038e70480f6ba580a4830dc36b2de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6053a2051a69b207a1c23236588c8ae8.jpg\" _src=\"http://yanxuan.nosdn.127.net/6053a2051a69b207a1c23236588c8ae8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72ff4dab74569803e60b9ef2e9f43d34.jpg\" _src=\"http://yanxuan.nosdn.127.net/72ff4dab74569803e60b9ef2e9f43d34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef52fed7935192b6127031d91f6f4c21.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef52fed7935192b6127031d91f6f4c21.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '16', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/afddb0b5a7e135769d7520f24bfea3d3.jpg', 'http://yanxuan.nosdn.127.net/bf8faee3b27b480f63b70056597b626d.png', '349.00', '873', '1020001', '0.00', '限时购', '', '0.00', '0', '0', '0', '383.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1023003', '1005007', '1023003', '100年传世珐琅锅 全家系列', '0', '100', '', '特质铸铁，大容量全家共享', '', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/9c9f47d3c321b96ad9c8d658ff4249e1.jpg', 'http://yanxuan.nosdn.127.net/c39d54c06a71b4b61b6092a0d31f2335.png', '398.00', '413', '1022007', '0.00', '限时购', '', '0.00', '0', '0', '0', '437.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1023012', '1036000', '1023012', '色织华夫格夏凉被', '1001000', '100', '', '凹凸华夫格织法，舒适轻柔', '<p><img src=\"http://yanxuan.nosdn.127.net/70e21fc5c723dc6adcb1b531553597d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/70e21fc5c723dc6adcb1b531553597d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fcdf78276ab0bcd8ed80a3dda8c29b6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/fcdf78276ab0bcd8ed80a3dda8c29b6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1eb088a53d00f094bbac4b1f7a662457.jpg\" _src=\"http://yanxuan.nosdn.127.net/1eb088a53d00f094bbac4b1f7a662457.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86be51c377922edd23e48b9d0c51d5dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/86be51c377922edd23e48b9d0c51d5dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e9cadf6589933fab072aef8c0644bb91.jpg\" _src=\"http://yanxuan.nosdn.127.net/e9cadf6589933fab072aef8c0644bb91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/adbb912f1131f821f4d01bb29ed31450.jpg\" _src=\"http://yanxuan.nosdn.127.net/adbb912f1131f821f4d01bb29ed31450.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8309ca74e9ecea295882b68cc0080652.jpg\" _src=\"http://yanxuan.nosdn.127.net/8309ca74e9ecea295882b68cc0080652.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cce90d2ad13258af815b828dd3fa34f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cce90d2ad13258af815b828dd3fa34f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ad6cf5c7f4ed107d39997ce1acfffd2.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ad6cf5c7f4ed107d39997ce1acfffd2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b867cc1a9f3c0046b40118e009a2cbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b867cc1a9f3c0046b40118e009a2cbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b14b08ce203d77633340b1677f6196b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b14b08ce203d77633340b1677f6196b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b697d210e3137bc9fa8f5b74a9916ce6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b697d210e3137bc9fa8f5b74a9916ce6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8b23b600cb5848d00eb1a176554f5de.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8b23b600cb5848d00eb1a176554f5de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b76964151af30178e74e28d0d590fd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b76964151af30178e74e28d0d590fd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3eda6586081f50314690ab9f141d1758.jpg\" _src=\"http://yanxuan.nosdn.127.net/3eda6586081f50314690ab9f141d1758.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/939f9ac497e48529e0c44ef5af32f329.jpg\" _src=\"http://yanxuan.nosdn.127.net/939f9ac497e48529e0c44ef5af32f329.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/8211ea549896095377d555b5066dbf82.jpg', 'http://yanxuan.nosdn.127.net/07376e78bf4fb8a5aa8e6a0b1437c3ad.png', '299.00', '7180', '1022030', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1023032', '1008009', '1023032', '纯棉色织缎纹四件套', '1001020', '100', '', '色织缎纹工艺，亲肤舒适', '<p><img src=\"http://yanxuan.nosdn.127.net/e05936cc765b06296b623de8c8ad08df.jpg\" _src=\"http://yanxuan.nosdn.127.net/e05936cc765b06296b623de8c8ad08df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4eff9d27f32ff39c19f8f6e4fb1f222e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4eff9d27f32ff39c19f8f6e4fb1f222e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7241fac29763a031c9ce1089a1e4b4be.jpg\" _src=\"http://yanxuan.nosdn.127.net/7241fac29763a031c9ce1089a1e4b4be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0dc6d93ac0498c5dfab30508b9412bc7.jpg\" _src=\"http://yanxuan.nosdn.127.net/0dc6d93ac0498c5dfab30508b9412bc7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88d77c126de94ba83b264c413433d1ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/88d77c126de94ba83b264c413433d1ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3379adc4f8cb904a509830c339474986.jpg\" _src=\"http://yanxuan.nosdn.127.net/3379adc4f8cb904a509830c339474986.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4b36d6bba85f96e1fe35c721f1bef4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4b36d6bba85f96e1fe35c721f1bef4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0340dc32d4eb348e015b6ad02e613ae5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0340dc32d4eb348e015b6ad02e613ae5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e478f4d41d9cb43e5ca6d3f4ec31e5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e478f4d41d9cb43e5ca6d3f4ec31e5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/656e723cec3cfc0e84d1c72eb286c3d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/656e723cec3cfc0e84d1c72eb286c3d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0730b88458593c7f8cc3fb389682378.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0730b88458593c7f8cc3fb389682378.jpg\"/><img src=\"http://yanxuan.nosdn.127.net/51bf3bc396723d289a1f9ec099dd7c74.jpg\" _src=\"http://yanxuan.nosdn.127.net/51bf3bc396723d289a1f9ec099dd7c74.jpg\" style=\"line-height: 1.42857;\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/301f70f9f1926ade3e7a7ef4c01d9084.jpg\" _src=\"http://yanxuan.nosdn.127.net/301f70f9f1926ade3e7a7ef4c01d9084.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b1596630f22d05ca935ab9d9793001e.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b1596630f22d05ca935ab9d9793001e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87c1ea8b6868f46cdba056cd714108e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/87c1ea8b6868f46cdba056cd714108e8.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '20', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ae44a93beaee69f045128b7612d21fbb.jpg', 'http://yanxuan.nosdn.127.net/e0b928ada728c140f6965bb41f47407b.png', '449.00', '574', '1022076', '0.00', '限时购', '', '0.00', '0', '0', '0', '493.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1023034', '1036000', '1023034', '泡泡纱可水洗夏凉被', '1001000', '100', '', '全棉泡泡纱，柔软亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/85eeb993c3b4f37680c1980ad142e076.jpg\" _src=\"http://yanxuan.nosdn.127.net/85eeb993c3b4f37680c1980ad142e076.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81f6fb8e6d4917a25fd8b4817ea7d4f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/81f6fb8e6d4917a25fd8b4817ea7d4f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/accecd0efbee671b1592560c3e08df40.jpg\" _src=\"http://yanxuan.nosdn.127.net/accecd0efbee671b1592560c3e08df40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1ed91aae1e7a9b3762edafcb31949b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1ed91aae1e7a9b3762edafcb31949b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c08c0809a1ddfdc7f739666599920999.jpg\" _src=\"http://yanxuan.nosdn.127.net/c08c0809a1ddfdc7f739666599920999.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/233157394df91dc93fe61ab8d1103e79.jpg\" _src=\"http://yanxuan.nosdn.127.net/233157394df91dc93fe61ab8d1103e79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10f3d5dcab0458117539f5cf0929c268.jpg\" _src=\"http://yanxuan.nosdn.127.net/10f3d5dcab0458117539f5cf0929c268.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ce6ff785959f440508e3bc7a9348618.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ce6ff785959f440508e3bc7a9348618.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b8c08729cfce7d9b35fd6ea00d4ba65.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b8c08729cfce7d9b35fd6ea00d4ba65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d8284f1c706360ea32f8f05f94b367c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d8284f1c706360ea32f8f05f94b367c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e21927788dafa40a5f2f409114dca3c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/e21927788dafa40a5f2f409114dca3c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b3c8d2cc37f9fc533616a18cd7a655e.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b3c8d2cc37f9fc533616a18cd7a655e.jpg\" style=\"\"/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/55129640e1e09ff05e427c73d52a18c5.jpg', 'http://yanxuan.nosdn.127.net/715899c65c023bb4973fb0466a5b79d6.png', '299.00', '1068', '1031020', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1025005', '1005007', '1025005', '100年传世珐琅锅', '0', '100', '', '特质铸铁，锁热节能', '', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/4559299068a6fff007d668c3c36a3d68.jpg', 'http://yanxuan.nosdn.127.net/49e26f00ca4d0ce00f9960d22c936738.png', '268.00', '10659', '1024021', '0.00', '限时购', '', '0.00', '0', '0', '0', '294.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1027004', '1036000', '1027004', '色织六层纱布夏凉被', '1001000', '100', '', '柔软纱布，婴童可用', '<p><img src=\"http://yanxuan.nosdn.127.net/67f90229027c9f7ce81be64b88a3a89d.jpg\" _src=\"http://yanxuan.nosdn.127.net/67f90229027c9f7ce81be64b88a3a89d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/938dcbd014d6651024b94ac9c61deeac.jpg\" _src=\"http://yanxuan.nosdn.127.net/938dcbd014d6651024b94ac9c61deeac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2afaf85ccfc966329c91873b9bcfd895.jpg\" _src=\"http://yanxuan.nosdn.127.net/2afaf85ccfc966329c91873b9bcfd895.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7e46721c706d3a6abca8349384b7d29.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7e46721c706d3a6abca8349384b7d29.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16064cd765c185be8a4621ef66e3839e.jpg\" _src=\"http://yanxuan.nosdn.127.net/16064cd765c185be8a4621ef66e3839e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3861e21da16b8e8907136f167d011971.jpg\" _src=\"http://yanxuan.nosdn.127.net/3861e21da16b8e8907136f167d011971.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62035b349641dff662334c1f749930e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/62035b349641dff662334c1f749930e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d814f23d85fa7ba0d3871fbd2ca743c.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d814f23d85fa7ba0d3871fbd2ca743c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa41611ffce03535348c76548d7be717.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa41611ffce03535348c76548d7be717.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a88cf7d8a483148d5261ca6ea8888e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a88cf7d8a483148d5261ca6ea8888e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2ae01b731a6b50c78151f3fb270c2ee3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2ae01b731a6b50c78151f3fb270c2ee3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/643974e12eea8a60e9b5c8039e2dfb46.jpg\" _src=\"http://yanxuan.nosdn.127.net/643974e12eea8a60e9b5c8039e2dfb46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8866316ff84ac68d1fe347eb6db8b07.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8866316ff84ac68d1fe347eb6db8b07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8d875bd5949fa3d2f6bb1dbbcc12121.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8d875bd5949fa3d2f6bb1dbbcc12121.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3cc4a687ed3be8727ee90e371defb4d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/3cc4a687ed3be8727ee90e371defb4d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c519db001d883d017a133efc7080d41a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c519db001d883d017a133efc7080d41a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbf012451cddac91a939c2b5171acc96.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbf012451cddac91a939c2b5171acc96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e63320cbbeecd593457e3ded8b5e9b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e63320cbbeecd593457e3ded8b5e9b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0acb487f97e14a5b9fc8c5fa5d8b1a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0acb487f97e14a5b9fc8c5fa5d8b1a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4a709c0c8140be33d226e0963912499.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4a709c0c8140be33d226e0963912499.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb3eaec97d07430ed6aea55e0a40b56e.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb3eaec97d07430ed6aea55e0a40b56e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/149f85abb95d094a7cb5ae7565a4ecd5.jpg\" _src=\"http://yanxuan.nosdn.127.net/149f85abb95d094a7cb5ae7565a4ecd5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/af0c2642435d3437c9f710cc442615f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/af0c2642435d3437c9f710cc442615f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/592fd3838f55f48a3f4ba5b2e796eff2.jpg\" _src=\"http://yanxuan.nosdn.127.net/592fd3838f55f48a3f4ba5b2e796eff2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3433c1bb5f6e0e3f3a10481ec53a28f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3433c1bb5f6e0e3f3a10481ec53a28f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/973cc6e90902c300a4648b5391246a19.jpg\" _src=\"http://yanxuan.nosdn.127.net/973cc6e90902c300a4648b5391246a19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb348e33f7387db2ddeaac68ca1abde1.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb348e33f7387db2ddeaac68ca1abde1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7234ad4c588c7423cf121ffee298480.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7234ad4c588c7423cf121ffee298480.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17f16b61bc645d686fdbed7be626bf4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/17f16b61bc645d686fdbed7be626bf4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6c3dc3c5436f3985a2fafce5e41d1e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6c3dc3c5436f3985a2fafce5e41d1e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5adb3c164a8e9edb187ea20aaca8b41.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5adb3c164a8e9edb187ea20aaca8b41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79e4f7477ee14c37ba3e8b34e51f70ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/79e4f7477ee14c37ba3e8b34e51f70ad.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a8dacc2f580c48bb535da34cf81c2497.jpg', 'http://yanxuan.nosdn.127.net/6252f53aaf36c072b6678f3d8c635132.png', '249.00', '1255', '1026004', '0.00', '限时购', '', '0.00', '0', '0', '1', '273.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1029005', '1008009', '1029005', '淡墨天丝麻渐变四件套', '0', '100', '', '亲肤透气，告别干燥秋季', '<p><img src=\"http://yanxuan.nosdn.127.net/2f948674e3ef78aa24c10b19729f4fb4.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f948674e3ef78aa24c10b19729f4fb4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6f7b253a3a9c1f02e986f9a64cff535.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6f7b253a3a9c1f02e986f9a64cff535.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3865d7978f3b48a9b14cd4da8f0f6098.jpg\" _src=\"http://yanxuan.nosdn.127.net/3865d7978f3b48a9b14cd4da8f0f6098.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04cb61cad86bd2168bca2ec84e8b4e3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/04cb61cad86bd2168bca2ec84e8b4e3d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce4572adf231a3973b2d5a0f8314f968.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce4572adf231a3973b2d5a0f8314f968.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae020323ce54942f0144a6e502b63477.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae020323ce54942f0144a6e502b63477.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbe53d568c242bcc315b1dfe0dd31ecc.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbe53d568c242bcc315b1dfe0dd31ecc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4981bb62099cd889c2060d59091a30c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4981bb62099cd889c2060d59091a30c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e44d15505bb091dea46ff43c7109050.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e44d15505bb091dea46ff43c7109050.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2843d3e369881bc1cf99e4013ab4aae2.jpg\" _src=\"http://yanxuan.nosdn.127.net/2843d3e369881bc1cf99e4013ab4aae2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99d3e400707eebe6b541008d8d2fa304.jpg\" _src=\"http://yanxuan.nosdn.127.net/99d3e400707eebe6b541008d8d2fa304.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cf8ae7b0bef82d7180bde3d32939a67.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cf8ae7b0bef82d7180bde3d32939a67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cf89b5f0fdd2beac19eabbb5c1b4dfb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cf89b5f0fdd2beac19eabbb5c1b4dfb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08021a1c737562f1a9acc37d878ff7d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/08021a1c737562f1a9acc37d878ff7d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b1439470e09d8cbd9320a0c97a0ccaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b1439470e09d8cbd9320a0c97a0ccaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0759dd1870f1e0539cac751ebea4f1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0759dd1870f1e0539cac751ebea4f1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3343c096023771e737f13b6473f6c505.jpg\" _src=\"http://yanxuan.nosdn.127.net/3343c096023771e737f13b6473f6c505.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80c5a9c55e6b95c4a858dd4c6d8c6de8.jpg\" _src=\"http://yanxuan.nosdn.127.net/80c5a9c55e6b95c4a858dd4c6d8c6de8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e8910c022ab86841cda2396c4465a54.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e8910c022ab86841cda2396c4465a54.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7348beaa667f2a6661280b16edd2b8f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7348beaa667f2a6661280b16edd2b8f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a1c836402908ce4c26a62c2ab5d7b83.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a1c836402908ce4c26a62c2ab5d7b83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26dc9814e66b7252cba3fcefabb80d20.jpg\" _src=\"http://yanxuan.nosdn.127.net/26dc9814e66b7252cba3fcefabb80d20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80f8cfcfb47dab3107824b81bf195410.jpg\" _src=\"http://yanxuan.nosdn.127.net/80f8cfcfb47dab3107824b81bf195410.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6f0f8ad06565d09338aab8c546dbf6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6f0f8ad06565d09338aab8c546dbf6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b24933453ed7672902fe34f4521806de.jpg\" _src=\"http://yanxuan.nosdn.127.net/b24933453ed7672902fe34f4521806de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c270fcfcf8072e9adbc4042702c542e.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c270fcfcf8072e9adbc4042702c542e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30524cd20f9dde720eb3405e0e5cf672.jpg\" _src=\"http://yanxuan.nosdn.127.net/30524cd20f9dde720eb3405e0e5cf672.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/583146da365d34a21a95c8ff096887a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/583146da365d34a21a95c8ff096887a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77d0c9777c92e11a81abf49eac319782.jpg\" _src=\"http://yanxuan.nosdn.127.net/77d0c9777c92e11a81abf49eac319782.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a202e74dbace549f54730e9f9840d3a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/a202e74dbace549f54730e9f9840d3a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ffb8f977278d24a5d4ef68ddef7ec8f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/ffb8f977278d24a5d4ef68ddef7ec8f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d02e0db8572baa48c2c5479aa16e7a51.jpg\" _src=\"http://yanxuan.nosdn.127.net/d02e0db8572baa48c2c5479aa16e7a51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c1d4a177cccd0038d64455c0b14f21b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c1d4a177cccd0038d64455c0b14f21b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15b18532a1eba7e8c68aa4ec7abf43ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/15b18532a1eba7e8c68aa4ec7abf43ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16e9a9c21cf9283b9c086be62234e1e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/16e9a9c21cf9283b9c086be62234e1e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7708ab7dde37876a1983cfa279dedeef.jpg\" _src=\"http://yanxuan.nosdn.127.net/7708ab7dde37876a1983cfa279dedeef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5aef158d01cffc44ec3e1ec8477652d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/5aef158d01cffc44ec3e1ec8477652d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57064140310058975c8d4021de045977.jpg\" _src=\"http://yanxuan.nosdn.127.net/57064140310058975c8d4021de045977.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/487efa0eb926a93b9f5979f4b6ad8f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/487efa0eb926a93b9f5979f4b6ad8f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee1358f10dd840512d44e6d3dcee2074.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee1358f10dd840512d44e6d3dcee2074.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/267b321aa7bac423ef296f9ea862fda2.jpg\" _src=\"http://yanxuan.nosdn.127.net/267b321aa7bac423ef296f9ea862fda2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c9a99527c2a7320435407be94eba294.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c9a99527c2a7320435407be94eba294.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d477452ba64594b379e20b1777dd12f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/d477452ba64594b379e20b1777dd12f1.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '24', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/b459acfea49574659b32289df41e9484.jpg', 'http://yanxuan.nosdn.127.net/25fe52f44853eb45f610846991bc4d9d.png', '959.00', '305', '1028007', '0.00', '限时购', '', '0.00', '0', '0', '0', '1054.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030001', '1008002', '1030001', '160*230羊毛手工地毯', '0', '100', '', '印度进口，手工编织，简约百搭', '<p><img src=\"http://yanxuan.nosdn.127.net/fbe953060dd4282539ee78e22f9c326c.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbe953060dd4282539ee78e22f9c326c.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb6320b1b19fe349fca98dcb509ccb41.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb6320b1b19fe349fca98dcb509ccb41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e3517025dc8da160277d7c80c55a83f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e3517025dc8da160277d7c80c55a83f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6d902b098a5009871e7dd2fc47d4aae.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6d902b098a5009871e7dd2fc47d4aae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15b721ac1796a6a93c2925c45fbafa91.jpg\" _src=\"http://yanxuan.nosdn.127.net/15b721ac1796a6a93c2925c45fbafa91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1e30ecc74b5b25869f892f51d4472b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1e30ecc74b5b25869f892f51d4472b0.jpg\" style=\"\"/></p><p><br/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7ddc57f40d4ec7d7e1069fc24438e93.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7ddc57f40d4ec7d7e1069fc24438e93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68e501bd5f6f2018ee275af62edcebce.jpg\" _src=\"http://yanxuan.nosdn.127.net/68e501bd5f6f2018ee275af62edcebce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6cd10a4cc89e2067421632172382410c.jpg\" _src=\"http://yanxuan.nosdn.127.net/6cd10a4cc89e2067421632172382410c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81d9b02cc74f846bb29bfc57b4d8dab1.jpg\" _src=\"http://yanxuan.nosdn.127.net/81d9b02cc74f846bb29bfc57b4d8dab1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30a9e77d7e0cab9b389bc4a7f4a0be13.jpg\" _src=\"http://yanxuan.nosdn.127.net/30a9e77d7e0cab9b389bc4a7f4a0be13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50513c57074971334c4b715d8b3cdfa1.jpg\" _src=\"http://yanxuan.nosdn.127.net/50513c57074971334c4b715d8b3cdfa1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5497b96a17e01db88d3b8999d78e111d.jpg\" _src=\"http://yanxuan.nosdn.127.net/5497b96a17e01db88d3b8999d78e111d.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3311094b3f6ac170477dbf31fdc36a43.jpg\" _src=\"http://yanxuan.nosdn.127.net/3311094b3f6ac170477dbf31fdc36a43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb7a1c7b6c6989af9c42a4e66de098e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb7a1c7b6c6989af9c42a4e66de098e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac42cbdfaa06c00a1bbd22fd63308546.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac42cbdfaa06c00a1bbd22fd63308546.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d2bf9139a0ca351f0ae4cabece86277.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d2bf9139a0ca351f0ae4cabece86277.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da1c0eef412d5ff9761a8659fa64d91b.jpg\" _src=\"http://yanxuan.nosdn.127.net/da1c0eef412d5ff9761a8659fa64d91b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba7017652cf73419da57393bb02ca6de.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba7017652cf73419da57393bb02ca6de.jpg\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '25', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ca0d9199db70d7b7f2b9b2ea673c74a4.jpg', 'http://yanxuan.nosdn.127.net/88dc5d80c6f84102f003ecd69c86e1cf.png', '969.00', '657', '1029001', '0.00', '限时购', '', '0.00', '0', '0', '0', '1065.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030002', '1008002', '1030002', '160*230羊毛圈绒枪刺地毯', '0', '100', '', '印度进口，手工枪刺，简约百搭', '<p><video id=\"tmpVedio0\" class=\"edui-upload-video video-js vjs-default-skin video-js\" controls=\"\" preload=\"auto\" width=\"100%\" height=\"\" data-setup=\"{}\"><source src=\"http://yanxuan.nosdn.127.net/4ca24b2fa0043eb7435d1ca24312b689.mp4\" type=\"video/mp4\"/></video>‍</p><p><img src=\"http://yanxuan.nosdn.127.net/4c409ac170dafe286e2cbd918b30a388.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c409ac170dafe286e2cbd918b30a388.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c4147de069c1c7d819711e683fae373.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c4147de069c1c7d819711e683fae373.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d4be2d9edd8481dfa51cc7b86a90b36.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d4be2d9edd8481dfa51cc7b86a90b36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61be18dbb282646133551c2bc297fb36.jpg\" _src=\"http://yanxuan.nosdn.127.net/61be18dbb282646133551c2bc297fb36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7160604c5bd97a0f1aef7f3a2a32b72b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7160604c5bd97a0f1aef7f3a2a32b72b.jpg\" style=\"\"/></p><p><br/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/32c5969b18a85bc62d4a855c40ab6142.jpg\" _src=\"http://yanxuan.nosdn.127.net/32c5969b18a85bc62d4a855c40ab6142.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62189479f43fd283340ce0fad3706b00.jpg\" _src=\"http://yanxuan.nosdn.127.net/62189479f43fd283340ce0fad3706b00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f39cb441e6778d5d39510099f8befd3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f39cb441e6778d5d39510099f8befd3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bbb06c48c23cdf11fd93f711512eed7.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bbb06c48c23cdf11fd93f711512eed7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0701aef423ba84cb1aabe8d6a1ab8d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0701aef423ba84cb1aabe8d6a1ab8d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4dec1e3bf4d5812d7d9fbddf50657e73.jpg\" _src=\"http://yanxuan.nosdn.127.net/4dec1e3bf4d5812d7d9fbddf50657e73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44497f9ad25cb6d208cc564016c8fd54.jpg\" _src=\"http://yanxuan.nosdn.127.net/44497f9ad25cb6d208cc564016c8fd54.jpg\"/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/37de0870b61ed6e880936d22000c2e85.jpg\" _src=\"http://yanxuan.nosdn.127.net/37de0870b61ed6e880936d22000c2e85.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97906141bd8846ea9e7888fa8a6b4ae0.jpg\" _src=\"http://yanxuan.nosdn.127.net/97906141bd8846ea9e7888fa8a6b4ae0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db23e00419f012686aaf4b3eeecae09b.jpg\" _src=\"http://yanxuan.nosdn.127.net/db23e00419f012686aaf4b3eeecae09b.jpg\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '24', '0', '0', '1269.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0d0a7e7d40a16ae6850d19f5e8704d8e.jpg', 'http://yanxuan.nosdn.127.net/8b9328496990357033d4259fda250679.png', '899.00', '205', '1029006', '0.00', '限时购', '限时购', '0.00', '0', '203', '0', '988.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030003', '1008002', '1030003', '160*230羊毛手工几何地毯', '0', '100', '', '几何图案，打造立体的时尚感', '<p><video id=\"tmpVedio0\" class=\"edui-upload-video video-js vjs-default-skin video-js\" controls=\"\" preload=\"auto\" width=\"100%\" height=\"\" data-setup=\"{}\"><source src=\"http://yanxuan.nosdn.127.net/e07746a58f5814648229ab750f7e59b0.mp4\" type=\"video/mp4\"/></video>‍</p><p><img src=\"http://yanxuan.nosdn.127.net/a03425edf97e1b0299d3095172991847.jpg\" _src=\"http://yanxuan.nosdn.127.net/a03425edf97e1b0299d3095172991847.jpg\" style=\"line-height: 1.42857;\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3fc35db4f3956b210032f0a876c2f2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3fc35db4f3956b210032f0a876c2f2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf278ec3726e12e0a07ef4384f80d7c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf278ec3726e12e0a07ef4384f80d7c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04cdc7e09537f67a140f5bd363751d23.jpg\" _src=\"http://yanxuan.nosdn.127.net/04cdc7e09537f67a140f5bd363751d23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4978e0569025d98c7a0cc685a3227d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4978e0569025d98c7a0cc685a3227d5.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/667999a8913e0dfc5118695f690f9ac4.jpg\" _src=\"http://yanxuan.nosdn.127.net/667999a8913e0dfc5118695f690f9ac4.jpg\" style=\"\"/></p><p><br/></p><p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0fe6f158bf93e05ae12fbc86ad7df61.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0fe6f158bf93e05ae12fbc86ad7df61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39b84d98bfcbc4f0443ec04e39328d04.jpg\" _src=\"http://yanxuan.nosdn.127.net/39b84d98bfcbc4f0443ec04e39328d04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16218f2ea0f8f4ddfd1fcbeac17d3b54.jpg\" _src=\"http://yanxuan.nosdn.127.net/16218f2ea0f8f4ddfd1fcbeac17d3b54.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e512605b0a5ee1dea333c42f826050b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e512605b0a5ee1dea333c42f826050b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/001d8961d92c3ebcf860e1745d0c63b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/001d8961d92c3ebcf860e1745d0c63b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25dda9b93dd3dd9aa622779c27481ef4.jpg\" _src=\"http://yanxuan.nosdn.127.net/25dda9b93dd3dd9aa622779c27481ef4.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/037abff9d64cdc761092d47619df82d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/037abff9d64cdc761092d47619df82d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f755e4142e8baf68fab301b3e6438d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f755e4142e8baf68fab301b3e6438d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa9ac1211dca7edc8fd93efd9cdd66e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa9ac1211dca7edc8fd93efd9cdd66e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ada62ef76b083d844d0762d2a6d33824.jpg\" _src=\"http://yanxuan.nosdn.127.net/ada62ef76b083d844d0762d2a6d33824.jpg\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '23', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/d74913e762fa11a4e27b0a20b8dad02d.jpg', 'http://yanxuan.nosdn.127.net/1d1ab099dc0e254c15e57302e78e200b.png', '1469.00', '464', '1029008', '0.00', '限时购', '', '0.00', '0', '0', '0', '1615.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030004', '1008009', '1030004', '日式穿线绣四件套', '1001020', '100', '', '源自日本的刺子绣工艺', '<p><img src=\"http://yanxuan.nosdn.127.net/c4f000d07201318aa97e28ca44265b38.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4f000d07201318aa97e28ca44265b38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba9c0e8463001b51e62e4a6d1d3cebe3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba9c0e8463001b51e62e4a6d1d3cebe3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/639358f7a538a6aad6b51ab71cf312f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/639358f7a538a6aad6b51ab71cf312f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7716eea4d973041f42f37dda65569d67.jpg\" _src=\"http://yanxuan.nosdn.127.net/7716eea4d973041f42f37dda65569d67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b11376974f63cb3ba512ee6c7a3246c.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b11376974f63cb3ba512ee6c7a3246c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e4dab90e7e762a28d3e44a93bd73dbf.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e4dab90e7e762a28d3e44a93bd73dbf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14d6248e60ac4a5fa8a73ebe20d8e299.jpg\" _src=\"http://yanxuan.nosdn.127.net/14d6248e60ac4a5fa8a73ebe20d8e299.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82037e630fb9aabe1caa647f1aad7b8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/82037e630fb9aabe1caa647f1aad7b8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f1442e6e6a628cdd0298e11b72c3df1.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f1442e6e6a628cdd0298e11b72c3df1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47bd87ff29265ec6bd20e3d139bde9f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/47bd87ff29265ec6bd20e3d139bde9f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c26da60fee77b361d5dfd54db2e248ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/c26da60fee77b361d5dfd54db2e248ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/360546bc4a24bcd01771ebf3fc14e78e.jpg\" _src=\"http://yanxuan.nosdn.127.net/360546bc4a24bcd01771ebf3fc14e78e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2526231998502ab75fff85578f5b5805.jpg\" _src=\"http://yanxuan.nosdn.127.net/2526231998502ab75fff85578f5b5805.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b40d643b8801d4ff3c166757a4e22f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b40d643b8801d4ff3c166757a4e22f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/156e1560ba231e2c4d7441b556083b1a.jpg\" _src=\"http://yanxuan.nosdn.127.net/156e1560ba231e2c4d7441b556083b1a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abaaa1e37b4650641500d6ffc63ad003.jpg\" _src=\"http://yanxuan.nosdn.127.net/abaaa1e37b4650641500d6ffc63ad003.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ead543a4b8b31b3160eb626d0ac99a86.jpg\" _src=\"http://yanxuan.nosdn.127.net/ead543a4b8b31b3160eb626d0ac99a86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9b21b1eeb2672cfb0b0d4d2eb05c1b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9b21b1eeb2672cfb0b0d4d2eb05c1b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95d189148e850ba0058c461d9295d5a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/95d189148e850ba0058c461d9295d5a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b46ca72735ebc86f3903f19d6eeadc0a.jpg\" _src=\"http://yanxuan.nosdn.127.net/b46ca72735ebc86f3903f19d6eeadc0a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc1c5c04748096c1e7e247589e5ac36d.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc1c5c04748096c1e7e247589e5ac36d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e3f5a4543ad7b8023098e6dc73d79ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e3f5a4543ad7b8023098e6dc73d79ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ce626b3616f9c924d9e0b9b16971928.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ce626b3616f9c924d9e0b9b16971928.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10451a1bd8ca994db14240f9da449aff.jpg\" _src=\"http://yanxuan.nosdn.127.net/10451a1bd8ca994db14240f9da449aff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/726c9de98163127c5934133d3c8c83fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/726c9de98163127c5934133d3c8c83fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26cd209f7ab8571c8d9bca7835448ee6.jpg\" _src=\"http://yanxuan.nosdn.127.net/26cd209f7ab8571c8d9bca7835448ee6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/985f6986962a913af1e1fa2382677813.jpg\" _src=\"http://yanxuan.nosdn.127.net/985f6986962a913af1e1fa2382677813.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81020d5f2f40527915dde40de5fe61fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/81020d5f2f40527915dde40de5fe61fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d09ba6c6d055b483029675fd054f13a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d09ba6c6d055b483029675fd054f13a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec24ea55fb62e16b8465c0bc55ebc4fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec24ea55fb62e16b8465c0bc55ebc4fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58c6aa370c08c703e656846c33e6da1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/58c6aa370c08c703e656846c33e6da1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1b2a2dfb5df53e11a54dfe8e0c87ec8.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1b2a2dfb5df53e11a54dfe8e0c87ec8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03c572a157408b95dd174b382552af2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/03c572a157408b95dd174b382552af2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a1e28353558a5d1edc9e550f2f208afd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a1e28353558a5d1edc9e550f2f208afd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3bf45801fbaf481f1657ab129bd91e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3bf45801fbaf481f1657ab129bd91e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab30b1b28a6b0931a0d0c17495b17d38.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab30b1b28a6b0931a0d0c17495b17d38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5065ff865628eba210732ee1fb814087.jpg\" _src=\"http://yanxuan.nosdn.127.net/5065ff865628eba210732ee1fb814087.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e85c4d9e815278bf505e9284be159911.jpg\" _src=\"http://yanxuan.nosdn.127.net/e85c4d9e815278bf505e9284be159911.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/982ba14437d259e070895027001fa014.jpg\" _src=\"http://yanxuan.nosdn.127.net/982ba14437d259e070895027001fa014.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aef71397c166f205ee5da5a2400b9f5b.jpg\" _src=\"http://yanxuan.nosdn.127.net/aef71397c166f205ee5da5a2400b9f5b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9615297dc1dfefab07be48c6ded3fa48.jpg\" _src=\"http://yanxuan.nosdn.127.net/9615297dc1dfefab07be48c6ded3fa48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d666d2aa297864ffff3a89656fe32065.jpg\" _src=\"http://yanxuan.nosdn.127.net/d666d2aa297864ffff3a89656fe32065.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db3aab03b1fd811e0acb60fa72abf255.jpg\" _src=\"http://yanxuan.nosdn.127.net/db3aab03b1fd811e0acb60fa72abf255.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f8a35c0788697bb69e57dc46b9bd835.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f8a35c0788697bb69e57dc46b9bd835.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe6f71e8260eabaceb2928f7b15273e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe6f71e8260eabaceb2928f7b15273e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f27b1c0a4d03da94dfe15a5b44df6f2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f27b1c0a4d03da94dfe15a5b44df6f2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd22744a56ddbad35ac3ac0dfdd68321.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd22744a56ddbad35ac3ac0dfdd68321.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/099db3d23cf16e8315311a278b6dc067.jpg\" _src=\"http://yanxuan.nosdn.127.net/099db3d23cf16e8315311a278b6dc067.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4dca16739bae1f1e1309acabd35f694.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4dca16739bae1f1e1309acabd35f694.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/389ea34f63fc565c4393ba3ec28c6bb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/389ea34f63fc565c4393ba3ec28c6bb3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/625bf5612aee58c83047656079a1fe18.jpg\" _src=\"http://yanxuan.nosdn.127.net/625bf5612aee58c83047656079a1fe18.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0404ed59fbdd994fe870c33714e42e7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0404ed59fbdd994fe870c33714e42e7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e00f36c0d57f5e15b1a2a4986d301f94.jpg\" _src=\"http://yanxuan.nosdn.127.net/e00f36c0d57f5e15b1a2a4986d301f94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1125e14271c128a2b39ddf40176ddff.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1125e14271c128a2b39ddf40176ddff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd8afd4c1a2c0a8f82f2c3fde62d12b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd8afd4c1a2c0a8f82f2c3fde62d12b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8355d2dbfa75957a5e7271929687b9af.jpg\" _src=\"http://yanxuan.nosdn.127.net/8355d2dbfa75957a5e7271929687b9af.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '19', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/badbf3d488baf890e5281ece5be64ea3.jpg', 'http://yanxuan.nosdn.127.net/e84f2e3b3d39cfdc8af5c3954a877aae.png', '399.00', '203', '1029010', '0.00', '限时购', '', '0.00', '0', '0', '0', '438.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030005', '1008009', '1030005', '撞色全亚麻四件套', '1001020', '100', '', '纯亚麻面料，透气亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/a8fedb97484d141058bc355232bc7844.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8fedb97484d141058bc355232bc7844.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa5e272a84cf083c296a03faeef32ed6.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa5e272a84cf083c296a03faeef32ed6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fd2fb566df26754c654534797dfa1bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fd2fb566df26754c654534797dfa1bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32cf31205dc1b6b42bbd6ca9a2aabaea.jpg\" _src=\"http://yanxuan.nosdn.127.net/32cf31205dc1b6b42bbd6ca9a2aabaea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7e0f71348f56dd6a40c8a2478586791.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7e0f71348f56dd6a40c8a2478586791.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/774b470824b4ff4a29f60331e3b20144.jpg\" _src=\"http://yanxuan.nosdn.127.net/774b470824b4ff4a29f60331e3b20144.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc9898e5d4ac3a6b76e42db121aae0b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc9898e5d4ac3a6b76e42db121aae0b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d692546b25c6928e68a153b82a67a43b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d692546b25c6928e68a153b82a67a43b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07a3c5a409189b8ee2ab79ca5421ee99.jpg\" _src=\"http://yanxuan.nosdn.127.net/07a3c5a409189b8ee2ab79ca5421ee99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bd1645b9e8f3aa94ea6a2041c352397.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bd1645b9e8f3aa94ea6a2041c352397.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48b88069ce49024e5a7f3ee6165960ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/48b88069ce49024e5a7f3ee6165960ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37a1645307f9d3f5731bb72147859b25.jpg\" _src=\"http://yanxuan.nosdn.127.net/37a1645307f9d3f5731bb72147859b25.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9ff48188d699f20ddea72558f3ec71e.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9ff48188d699f20ddea72558f3ec71e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15d1df0e289d03ababe2936c621ace26.jpg\" _src=\"http://yanxuan.nosdn.127.net/15d1df0e289d03ababe2936c621ace26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bcb25939826af34300c9b657c025334.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bcb25939826af34300c9b657c025334.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c22a223c9f4efafa68a8f42d3b71d528.jpg\" _src=\"http://yanxuan.nosdn.127.net/c22a223c9f4efafa68a8f42d3b71d528.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84cf2b201b3e1a5a24b219babb9d9255.jpg\" _src=\"http://yanxuan.nosdn.127.net/84cf2b201b3e1a5a24b219babb9d9255.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/009e66cce8a7a43bd0e97e4f02a16414.jpg\" _src=\"http://yanxuan.nosdn.127.net/009e66cce8a7a43bd0e97e4f02a16414.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3aa5570b4e01e7e7e01d2d8b4dc4b37.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3aa5570b4e01e7e7e01d2d8b4dc4b37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4247a2bc0d95f5a664895b7e5553e3ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/4247a2bc0d95f5a664895b7e5553e3ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8e7c456990a99e0d821bc7a4019b46d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8e7c456990a99e0d821bc7a4019b46d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/af6665f7902523e9b19dc8d05219a94b.jpg\" _src=\"http://yanxuan.nosdn.127.net/af6665f7902523e9b19dc8d05219a94b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50dae15620254859ce950e83a9de8e19.jpg\" _src=\"http://yanxuan.nosdn.127.net/50dae15620254859ce950e83a9de8e19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0d183809d6dd2578e22012fb5f29cb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0d183809d6dd2578e22012fb5f29cb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/534d89cbedac890a4845c09c02e3b97f.jpg\" _src=\"http://yanxuan.nosdn.127.net/534d89cbedac890a4845c09c02e3b97f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13f685794d72dfa136d4a4ba7f924492.jpg\" _src=\"http://yanxuan.nosdn.127.net/13f685794d72dfa136d4a4ba7f924492.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13febece3486646420d7de552cc89144.jpg\" _src=\"http://yanxuan.nosdn.127.net/13febece3486646420d7de552cc89144.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3768643d8aee9f44218c85ab78af9caf.jpg\" _src=\"http://yanxuan.nosdn.127.net/3768643d8aee9f44218c85ab78af9caf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8be7249357104bc94a008641b3105f1f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8be7249357104bc94a008641b3105f1f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31cd85a05cdeddef127b4c785fe8da16.jpg\" _src=\"http://yanxuan.nosdn.127.net/31cd85a05cdeddef127b4c785fe8da16.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fadf2462c0f06978829530510ba95a6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/fadf2462c0f06978829530510ba95a6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da61ca6ac63f21d27a85bc7b31a92b20.jpg\" _src=\"http://yanxuan.nosdn.127.net/da61ca6ac63f21d27a85bc7b31a92b20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2d768f65baec4b75130dcc7c70daad88.jpg\" _src=\"http://yanxuan.nosdn.127.net/2d768f65baec4b75130dcc7c70daad88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50d644bc2cf83575ddd6a71a82fb4d05.jpg\" _src=\"http://yanxuan.nosdn.127.net/50d644bc2cf83575ddd6a71a82fb4d05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/881e101c4072be27dbb21ecd935fc6b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/881e101c4072be27dbb21ecd935fc6b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24472778c90fc48428d84350f31fd1a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/24472778c90fc48428d84350f31fd1a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8d1dbd24abc6184905bffeb9859b18d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8d1dbd24abc6184905bffeb9859b18d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2895c067f4d44a0fc14ee1add035e2dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/2895c067f4d44a0fc14ee1add035e2dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/96479876bb249cbe1b65b76bd08e03f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/96479876bb249cbe1b65b76bd08e03f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1b15b5c27ad4cdff32ba9eac1d38b2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1b15b5c27ad4cdff32ba9eac1d38b2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f068dfac9c93c994bd4d7efacec8b70.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f068dfac9c93c994bd4d7efacec8b70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13dafff25c676995e6b893a4193d0d9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/13dafff25c676995e6b893a4193d0d9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4098b4ec10505fc8410dfa81e97a36d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4098b4ec10505fc8410dfa81e97a36d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/05a682bc8ceff7e28655691dad62a169.jpg\" _src=\"http://yanxuan.nosdn.127.net/05a682bc8ceff7e28655691dad62a169.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b19a674dfa17eb6580113bf6e354158.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b19a674dfa17eb6580113bf6e354158.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95ed5187ef97940225fc2875da7ec342.jpg\" _src=\"http://yanxuan.nosdn.127.net/95ed5187ef97940225fc2875da7ec342.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbc6fb5b61197b3c5bbb4cfd2406f423.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbc6fb5b61197b3c5bbb4cfd2406f423.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/311c416209f055bd5fcb85b9fa02802d.jpg\" _src=\"http://yanxuan.nosdn.127.net/311c416209f055bd5fcb85b9fa02802d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc5f4d85baf345a43a13d5c005756d0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc5f4d85baf345a43a13d5c005756d0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88c814c6da3ce42657fe36cd4639050b.jpg\" _src=\"http://yanxuan.nosdn.127.net/88c814c6da3ce42657fe36cd4639050b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f73bb5665bce9b76606919424e94ace.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f73bb5665bce9b76606919424e94ace.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/267bf3ac28457f2640c2adf47e927f65.jpg\" _src=\"http://yanxuan.nosdn.127.net/267bf3ac28457f2640c2adf47e927f65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95f30aedac3780793a77217cec971d36.jpg\" _src=\"http://yanxuan.nosdn.127.net/95f30aedac3780793a77217cec971d36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c8330b3a20ca3fd799c685fcd2610e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c8330b3a20ca3fd799c685fcd2610e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/156ea9b9174741fccf12d1f84729bea0.jpg\" _src=\"http://yanxuan.nosdn.127.net/156ea9b9174741fccf12d1f84729bea0.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '22', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ce4b27ecf71705158fd4b78f73cc1cf5.jpg', 'http://yanxuan.nosdn.127.net/86f57132793d3e3c924a7ba529849288.png', '899.00', '1732', '1029015', '0.00', '限时购', '', '0.00', '0', '0', '0', '988.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1030006', '1008009', '1030006', '日式纯棉色织AB格四件套', '0', '100', '', '凹凸立体格纹，细节体现质感', '<p><img src=\"http://yanxuan.nosdn.127.net/7b05c0b013ec5ddced70db8f1836a524.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b05c0b013ec5ddced70db8f1836a524.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19f647d9669222fb0959a678d4e4b7b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/19f647d9669222fb0959a678d4e4b7b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84a6fa64c9fe43e6a09ae808a525df8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/84a6fa64c9fe43e6a09ae808a525df8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1c6b48a806df620cb939dd442bf9b24.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1c6b48a806df620cb939dd442bf9b24.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f3e08586b1a2381e76ef343b41fb8bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f3e08586b1a2381e76ef343b41fb8bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77b5016f3b1784ecc759ce4b5c5ec878.jpg\" _src=\"http://yanxuan.nosdn.127.net/77b5016f3b1784ecc759ce4b5c5ec878.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75ab91bbe6ef31861d9266c1d5796bd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/75ab91bbe6ef31861d9266c1d5796bd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/af0385d4be03564be9b958be9b7c4191.jpg\" _src=\"http://yanxuan.nosdn.127.net/af0385d4be03564be9b958be9b7c4191.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aac39aa60bdcfad36640dbd0e18ae452.jpg\" _src=\"http://yanxuan.nosdn.127.net/aac39aa60bdcfad36640dbd0e18ae452.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/159807ac6f2397189edbd794423994aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/159807ac6f2397189edbd794423994aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eedc9788b065368d513928bea9650c40.jpg\" _src=\"http://yanxuan.nosdn.127.net/eedc9788b065368d513928bea9650c40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa9e8fe3f75f2698d355fbab3128ed01.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa9e8fe3f75f2698d355fbab3128ed01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2582bc8b922a06800fcfdc274d42411c.jpg\" _src=\"http://yanxuan.nosdn.127.net/2582bc8b922a06800fcfdc274d42411c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fcfa6647d7273f487a3cff61aa948c95.jpg\" _src=\"http://yanxuan.nosdn.127.net/fcfa6647d7273f487a3cff61aa948c95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5841455f07b63fcd05fba393543f7e87.jpg\" _src=\"http://yanxuan.nosdn.127.net/5841455f07b63fcd05fba393543f7e87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ed5271f8cdcb33a25b18db8f0372470e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ed5271f8cdcb33a25b18db8f0372470e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20be5bfe0c05f8bbedaec60167fa0e7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/20be5bfe0c05f8bbedaec60167fa0e7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e39f1ffa3a475a9ed61b762b8c25e2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e39f1ffa3a475a9ed61b762b8c25e2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8046850716f5ebb7fcf596dc31914e80.jpg\" _src=\"http://yanxuan.nosdn.127.net/8046850716f5ebb7fcf596dc31914e80.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d2eafad0609aea932892b5c59decd27.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d2eafad0609aea932892b5c59decd27.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ffe985a36f22902a4145a331e734dd84.jpg\" _src=\"http://yanxuan.nosdn.127.net/ffe985a36f22902a4145a331e734dd84.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/227fbf150c1bbd920c0458b5f2dc3c33.jpg\" _src=\"http://yanxuan.nosdn.127.net/227fbf150c1bbd920c0458b5f2dc3c33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0398d5e84e61bf044b6694a103ba690d.jpg\" _src=\"http://yanxuan.nosdn.127.net/0398d5e84e61bf044b6694a103ba690d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/615dad0bf78318544a5408339082828a.jpg\" _src=\"http://yanxuan.nosdn.127.net/615dad0bf78318544a5408339082828a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a05a6367cc1dd5e9dcc372755ec65ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a05a6367cc1dd5e9dcc372755ec65ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92682369d59dc519fb4d58fbbb9a23f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/92682369d59dc519fb4d58fbbb9a23f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d35c10f55941d55870f809ed212a5811.jpg\" _src=\"http://yanxuan.nosdn.127.net/d35c10f55941d55870f809ed212a5811.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f716b0db1b01cd73e0484a7e38fd873d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f716b0db1b01cd73e0484a7e38fd873d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f01467b000ea837c21cd37c6e05049ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/f01467b000ea837c21cd37c6e05049ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b48e5f59ea7027e83bd16eebd3991b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b48e5f59ea7027e83bd16eebd3991b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/291de1e5da8832fc2da48a775c70ad70.jpg\" _src=\"http://yanxuan.nosdn.127.net/291de1e5da8832fc2da48a775c70ad70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9e2b594100374d8d3e6e4ed7b5d6b3c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9e2b594100374d8d3e6e4ed7b5d6b3c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b284b20ce0e3c2e6d3bb7468af21d7e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b284b20ce0e3c2e6d3bb7468af21d7e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70c1ed140868cca37832650061d99e2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/70c1ed140868cca37832650061d99e2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e2a42fd68a4c0d9b6608e17e312ff50.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e2a42fd68a4c0d9b6608e17e312ff50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98d794a141c1cd21173ee1e920ee2f59.jpg\" _src=\"http://yanxuan.nosdn.127.net/98d794a141c1cd21173ee1e920ee2f59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7e8a0d4c32c59d5bb58bfd043d7b0f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7e8a0d4c32c59d5bb58bfd043d7b0f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c96effe484ec0fe3a24b6f50eb4c653f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c96effe484ec0fe3a24b6f50eb4c653f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46402f7f7b982caa07de61b47c7a39a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/46402f7f7b982caa07de61b47c7a39a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d561dde54a84b1f652bf75dea175299.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d561dde54a84b1f652bf75dea175299.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '21', '0', '0', '459.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a98bd0e18e7fc76bfeb2f8791a8868d4.jpg', 'http://yanxuan.nosdn.127.net/578ffec952eb25ff072d8ea1b676bfd2.png', '329.00', '7', '1029021', '0.00', '限时购', '限时购', '0.00', '0', '203', '0', '361.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1033000', '1020003', '1033000', '新生彩棉初衣礼盒（婴童）', '0', '100', '', '来自天然彩棉的礼物', '', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/d820f03d67e68071d30c922ea87eb023.png', 'http://yanxuan.nosdn.127.net/9aab9a0bf4fef8fe3dc8c732bc22d4b7.png', '199.00', '13731', '1032000', '0.00', '限时购', '', '0.00', '0', '0', '0', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1035006', '1008002', '1035006', '全棉单面割绒浴室地垫', '0', '100', '', '手工制作，纯棉材质，柔软舒适', '<p><img src=\"http://yanxuan.nosdn.127.net/39cba017dbf04371863ec3af894cb79c.jpg\" _src=\"http://yanxuan.nosdn.127.net/39cba017dbf04371863ec3af894cb79c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/727bdb71768265b3c283b2d71ad63d8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/727bdb71768265b3c283b2d71ad63d8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b7eb8df6b30b61ff8326a5882bbf411.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b7eb8df6b30b61ff8326a5882bbf411.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5143f756b613c2523954affbdf514a05.jpg\" _src=\"http://yanxuan.nosdn.127.net/5143f756b613c2523954affbdf514a05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a6879162b60e2442036c6c5d88275e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a6879162b60e2442036c6c5d88275e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d65d49dfd73f6b44d8e1b971df58ec1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d65d49dfd73f6b44d8e1b971df58ec1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/630c9a177eb89c044d4c968745fce915.jpg\" _src=\"http://yanxuan.nosdn.127.net/630c9a177eb89c044d4c968745fce915.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1597a314b6ae69f361f4f1fbc2ed876c.jpg\" _src=\"http://yanxuan.nosdn.127.net/1597a314b6ae69f361f4f1fbc2ed876c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cfcfff37b305dcc44d9a907377761f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cfcfff37b305dcc44d9a907377761f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/27dd23d01d9d110ebb11c92fa087e208.jpg\" _src=\"http://yanxuan.nosdn.127.net/27dd23d01d9d110ebb11c92fa087e208.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/366f5281836ad5b3a06afe4ace14d2bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/366f5281836ad5b3a06afe4ace14d2bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cdd2229692184db4793f68ca2d1c307.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cdd2229692184db4793f68ca2d1c307.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/999c7854dff1496c2702c510b8c6586d.jpg\" _src=\"http://yanxuan.nosdn.127.net/999c7854dff1496c2702c510b8c6586d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7097f2a9c69c4f337ab9ff961276cf0a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7097f2a9c69c4f337ab9ff961276cf0a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d6ad8caac9c24f024b9525e492dde1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d6ad8caac9c24f024b9525e492dde1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1005834f8ac736dc7bc5c59cfab0ce01.jpg\" _src=\"http://yanxuan.nosdn.127.net/1005834f8ac736dc7bc5c59cfab0ce01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/342365052bc031f64050c0d117786de1.jpg\" _src=\"http://yanxuan.nosdn.127.net/342365052bc031f64050c0d117786de1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bdb057b4b109ad39368d337b26fcef0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bdb057b4b109ad39368d337b26fcef0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c764541e44c1bfe9308c4be9ba70eb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c764541e44c1bfe9308c4be9ba70eb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e4dafc25a731ccf56b1296e9889530d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e4dafc25a731ccf56b1296e9889530d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0aae3c93d54fd9a25fc0d297e0cf856e.jpg\" _src=\"http://yanxuan.nosdn.127.net/0aae3c93d54fd9a25fc0d297e0cf856e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d3f4adea81508c83148517b12b3963f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d3f4adea81508c83148517b12b3963f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7f792a547c9f534fd4bd00c88fe734c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7f792a547c9f534fd4bd00c88fe734c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41541dc15fbb715ed5311d4343516a6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/41541dc15fbb715ed5311d4343516a6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/267175ffcb24b51250f642b31cadd977.jpg\" _src=\"http://yanxuan.nosdn.127.net/267175ffcb24b51250f642b31cadd977.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '32', '0', '0', '69.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/96b3f9af4a260902e7b8b3100af1da07.jpg', 'http://yanxuan.nosdn.127.net/ee92704f3b8323905b51fc647823e6e5.png', '56.00', '14584', '1034011', '0.00', '限时购', '限时购', '0.00', '0', '203', '0', '61.60', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1036002', '1008008', '1036002', '高山苦荞麦枕', '0', '100', '', '原生苦荞，健康护颈', '<p><img src=\"http://yanxuan.nosdn.127.net/698e2a2252d9d4227f17f9d88a6e87ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/698e2a2252d9d4227f17f9d88a6e87ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38d70ef29b5e883125a27d6607a9ce62.jpg\" _src=\"http://yanxuan.nosdn.127.net/38d70ef29b5e883125a27d6607a9ce62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0f7666b8f215007d322b7f7e7267d7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0f7666b8f215007d322b7f7e7267d7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d7661b99de023bed2ebf360a8f0cb7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d7661b99de023bed2ebf360a8f0cb7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a1860e8b8cac1f3e5a42bc7de5a8e04.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a1860e8b8cac1f3e5a42bc7de5a8e04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb4e72d283bd58f1b23125dbeef11ef6.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb4e72d283bd58f1b23125dbeef11ef6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9846b6c36e9dc27fc4b18ec3e0177aff.jpg\" _src=\"http://yanxuan.nosdn.127.net/9846b6c36e9dc27fc4b18ec3e0177aff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b4e21c0d2fa575dc1636baf71666b1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b4e21c0d2fa575dc1636baf71666b1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9588e23919c7c54998bb5a07b0907eeb.jpg\" _src=\"http://yanxuan.nosdn.127.net/9588e23919c7c54998bb5a07b0907eeb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c807c41d48efb876244bd41d1dd97ef5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c807c41d48efb876244bd41d1dd97ef5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b213fc5b21cbf79c39412e6d9b21e7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b213fc5b21cbf79c39412e6d9b21e7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fba066200fc8ce47a0c7e99b47f97e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fba066200fc8ce47a0c7e99b47f97e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/208af7a63670fc2a438364f2336f2806.jpg\" _src=\"http://yanxuan.nosdn.127.net/208af7a63670fc2a438364f2336f2806.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab0c3198ec5c1193da9cd5a491bb459d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab0c3198ec5c1193da9cd5a491bb459d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c24e52caa847dd17210cc57d243d08c.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c24e52caa847dd17210cc57d243d08c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0371cfdea30a90ef6955e3bcf3f9b6c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/0371cfdea30a90ef6955e3bcf3f9b6c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8916eff34678bfda4980a231a3b8d09a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8916eff34678bfda4980a231a3b8d09a.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0bbe5e8f7a719265ed89ad7fb4b9473c.jpg', 'http://yanxuan.nosdn.127.net/ffd7efe9d5225dff9f36d5110b027caa.png', '99.00', '2723', '1035005', '0.00', '限时购', '', '0.00', '0', '0', '1', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1036013', '1008009', '1036013', '全棉针织素色床笠', '0', '100', '', '百隆色纺纱，亲肤舒适，裸睡神器', '<p><img src=\"http://yanxuan.nosdn.127.net/2ea947dc5f93d996b2d9651f07cf4e5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2ea947dc5f93d996b2d9651f07cf4e5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/584f94e084559eb5a4e8ba4b0c0d94b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/584f94e084559eb5a4e8ba4b0c0d94b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd00b278f6e9ede88a9523f12da21a8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd00b278f6e9ede88a9523f12da21a8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89a1458cc189b185d42b0fce5ec47786.jpg\" _src=\"http://yanxuan.nosdn.127.net/89a1458cc189b185d42b0fce5ec47786.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8ca61b4ac2285c6399cf13e0e706122.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8ca61b4ac2285c6399cf13e0e706122.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a0ef1725c91b35d28fa2aade62474fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a0ef1725c91b35d28fa2aade62474fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/456dcb6d70990b9175d70ba596f3c407.jpg\" _src=\"http://yanxuan.nosdn.127.net/456dcb6d70990b9175d70ba596f3c407.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e947956bcb3f7a281d75d900e14c1467.jpg\" _src=\"http://yanxuan.nosdn.127.net/e947956bcb3f7a281d75d900e14c1467.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/903adc0d93d873213cb63e2e8131b279.jpg\" _src=\"http://yanxuan.nosdn.127.net/903adc0d93d873213cb63e2e8131b279.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/554f7b2d804375a1d6234dd530afba62.jpg\" _src=\"http://yanxuan.nosdn.127.net/554f7b2d804375a1d6234dd530afba62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0736125b93c2530567a3da47e51207f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/0736125b93c2530567a3da47e51207f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d05886366aa27bfdbcab94f1cec3fdf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/d05886366aa27bfdbcab94f1cec3fdf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a28af88609476e96c154e0724fbe1f5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a28af88609476e96c154e0724fbe1f5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8369453fa28fd4ceb4ad8d07797b8f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8369453fa28fd4ceb4ad8d07797b8f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b876f252a587a0e96116b346b7f3261.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b876f252a587a0e96116b346b7f3261.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa33c3d86cb635ae43cb467eceac29ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa33c3d86cb635ae43cb467eceac29ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ece8b099041cb048b9fef0084e913b3c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ece8b099041cb048b9fef0084e913b3c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d506d32e1fe346b94bea4a4358ffa62.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d506d32e1fe346b94bea4a4358ffa62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d45055d253ecac606f8f7a20cc740436.jpg\" _src=\"http://yanxuan.nosdn.127.net/d45055d253ecac606f8f7a20cc740436.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b409d218695083e52089ab595ec169e.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b409d218695083e52089ab595ec169e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c2713ccb4655853d0f34e97481742a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c2713ccb4655853d0f34e97481742a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/099b05e20345682d8ccffed299de4036.jpg\" _src=\"http://yanxuan.nosdn.127.net/099b05e20345682d8ccffed299de4036.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/681e72addfa6a5c99c225b6cac80338b.jpg\" _src=\"http://yanxuan.nosdn.127.net/681e72addfa6a5c99c225b6cac80338b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/311a4c606bdebcf4e07bb4069d47d22d.jpg\" _src=\"http://yanxuan.nosdn.127.net/311a4c606bdebcf4e07bb4069d47d22d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7d70ea6a2a2480717e8d495a78c9f1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7d70ea6a2a2480717e8d495a78c9f1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e746e02d8cf7f32f4f0c3aa42fd3951f.jpg\" _src=\"http://yanxuan.nosdn.127.net/e746e02d8cf7f32f4f0c3aa42fd3951f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aaa74552f611e799d7912761a76718e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/aaa74552f611e799d7912761a76718e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/083c5a0f704b115660f5d6f1fe23d617.jpg\" _src=\"http://yanxuan.nosdn.127.net/083c5a0f704b115660f5d6f1fe23d617.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e4ac92008c116a73048c4607f12eeca.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e4ac92008c116a73048c4607f12eeca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e833539bb3899ad048186fa2aff42241.jpg\" _src=\"http://yanxuan.nosdn.127.net/e833539bb3899ad048186fa2aff42241.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2289c3881b2d32a9132d684cdd9b4fca.jpg\" _src=\"http://yanxuan.nosdn.127.net/2289c3881b2d32a9132d684cdd9b4fca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1f8a657fd8363fcf4a62fa9ab838d61.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1f8a657fd8363fcf4a62fa9ab838d61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fbef986dac776654ec8cd23e3cd8bf8.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fbef986dac776654ec8cd23e3cd8bf8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca3ff84fc05e386fdf3ee789d6fc70e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca3ff84fc05e386fdf3ee789d6fc70e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80a1a3202fc0104e54bd1fb5b111b448.jpg\" _src=\"http://yanxuan.nosdn.127.net/80a1a3202fc0104e54bd1fb5b111b448.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/071a8ca1a90782d6813f7c125fe04ca9.jpg\" _src=\"http://yanxuan.nosdn.127.net/071a8ca1a90782d6813f7c125fe04ca9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/840a076f6ac26b74b3786cfc3b66e785.jpg\" _src=\"http://yanxuan.nosdn.127.net/840a076f6ac26b74b3786cfc3b66e785.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/923f018943db353459a940a2d3b57b5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/923f018943db353459a940a2d3b57b5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/360d3db07247ab7e824086d134ca8e83.jpg\" _src=\"http://yanxuan.nosdn.127.net/360d3db07247ab7e824086d134ca8e83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d28b9978bbf757f926a8f1fec1af4355.jpg\" _src=\"http://yanxuan.nosdn.127.net/d28b9978bbf757f926a8f1fec1af4355.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a8d4554060bdbcb99c6b910bca6de73.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a8d4554060bdbcb99c6b910bca6de73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbc5931307c3dabab82f4b6314064097.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbc5931307c3dabab82f4b6314064097.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ed409573b7775e6a4aa0d11ae2bbe02.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ed409573b7775e6a4aa0d11ae2bbe02.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e4653f2d0dcf16a6e9fba2364074df0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e4653f2d0dcf16a6e9fba2364074df0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b27de84243cc25f752b3b7e955b0177d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b27de84243cc25f752b3b7e955b0177d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ddc46378605add71e99e51fdaf83db5.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ddc46378605add71e99e51fdaf83db5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e402495d57f4934e7224948ac3d956cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/e402495d57f4934e7224948ac3d956cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6cdded8ed37708bf2a817f05efccbec0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6cdded8ed37708bf2a817f05efccbec0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56ad5ff1c7f6c686739961df64abef75.jpg\" _src=\"http://yanxuan.nosdn.127.net/56ad5ff1c7f6c686739961df64abef75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7508fe30e5bd5d46c7dcd95b059616cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/7508fe30e5bd5d46c7dcd95b059616cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/760c798a64bd06d50a769935ba7cc59a.jpg\" _src=\"http://yanxuan.nosdn.127.net/760c798a64bd06d50a769935ba7cc59a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/621d6bf8f4938f18b585d8418f592b6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/621d6bf8f4938f18b585d8418f592b6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8147afb283cb461062a47c98ec6e663b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8147afb283cb461062a47c98ec6e663b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49a679fc021af27dc631702b58893bd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/49a679fc021af27dc631702b58893bd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc9c61af723770deb3796bdc4d1c7fd0.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc9c61af723770deb3796bdc4d1c7fd0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09e9e3ee2729bd7b1525db50ef15d978.jpg\" _src=\"http://yanxuan.nosdn.127.net/09e9e3ee2729bd7b1525db50ef15d978.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f77aaed5876f0b974834aaf0e0da96fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/f77aaed5876f0b974834aaf0e0da96fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b323f96fabccf05c8f3ddd3537790cb5.jpg\" _src=\"http://yanxuan.nosdn.127.net/b323f96fabccf05c8f3ddd3537790cb5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a23566fd52f0c4cfe83af728aa66a014.jpg\" _src=\"http://yanxuan.nosdn.127.net/a23566fd52f0c4cfe83af728aa66a014.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c4bbac4f263a5dc10fd3c66f701985c.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c4bbac4f263a5dc10fd3c66f701985c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f40140d230db392fe51306614945713f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f40140d230db392fe51306614945713f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b9c12121bda764443a1933e533a4445.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b9c12121bda764443a1933e533a4445.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/632a48034a7c29e15a1e6c70014e3964.jpg\" _src=\"http://yanxuan.nosdn.127.net/632a48034a7c29e15a1e6c70014e3964.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '27', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/21b899b9a57fcf11e5ee29041601b9aa.jpg', 'http://yanxuan.nosdn.127.net/da1bc2c10f7b2e53f2466bd23953b982.png', '109.00', '1420', '1035028', '0.00', '限时购', '', '0.00', '0', '0', '0', '119.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1036016', '1008009', '1036016', '日式色织水洗棉床笠', '0', '100', '', '色织水洗工艺，亲肤柔软', '<p><img src=\"http://yanxuan.nosdn.127.net/27aa5bc8460115ccb194f7f6878e68bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/27aa5bc8460115ccb194f7f6878e68bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/765f188e5a348b9309fb6925c7b21aea.jpg\" _src=\"http://yanxuan.nosdn.127.net/765f188e5a348b9309fb6925c7b21aea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43945809af824c2be9ee6fa77ffa7789.jpg\" _src=\"http://yanxuan.nosdn.127.net/43945809af824c2be9ee6fa77ffa7789.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a95d653097cb9349a4a4c994dbec535.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a95d653097cb9349a4a4c994dbec535.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38e7c1373521ff55c3c976b2c7bfe149.jpg\" _src=\"http://yanxuan.nosdn.127.net/38e7c1373521ff55c3c976b2c7bfe149.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4407d34700a2c1fe874280344ba538ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/4407d34700a2c1fe874280344ba538ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/461cdf2416cea7981df8043dc5ef0f0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/461cdf2416cea7981df8043dc5ef0f0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb17feeda18a8852a0a9e52631ae8194.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb17feeda18a8852a0a9e52631ae8194.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f4e1a21b84a69bf745b11d331cdfa0d.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f4e1a21b84a69bf745b11d331cdfa0d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a12d561d7d8901f714a6e7748e1c5615.jpg\" _src=\"http://yanxuan.nosdn.127.net/a12d561d7d8901f714a6e7748e1c5615.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99bf6cdd7bb5518e60dcd6f5e7621f6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/99bf6cdd7bb5518e60dcd6f5e7621f6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66acc9ba0870f0bbfac7daf0f247ca8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/66acc9ba0870f0bbfac7daf0f247ca8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7de61864c4f3e580efe49bea1677b2f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/7de61864c4f3e580efe49bea1677b2f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0e3cb8406e04b802324deb5994f7bb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0e3cb8406e04b802324deb5994f7bb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cfcbc803bcd22c52179af79458e6ab74.jpg\" _src=\"http://yanxuan.nosdn.127.net/cfcbc803bcd22c52179af79458e6ab74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6378dfc799bf4348bdf591878b8874b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6378dfc799bf4348bdf591878b8874b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79dfe0e605da000837104ca59bcacd70.jpg\" _src=\"http://yanxuan.nosdn.127.net/79dfe0e605da000837104ca59bcacd70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5cddd147a17cd8e0ca3f1c344799150.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5cddd147a17cd8e0ca3f1c344799150.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75c4dd15612240676e8745947ba919b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/75c4dd15612240676e8745947ba919b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7da0b604d50d515c9cca36882ac14f1a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7da0b604d50d515c9cca36882ac14f1a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf904edee30b5146bdaa9702e10220fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf904edee30b5146bdaa9702e10220fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01aefba507ae7eec7227c4198a66403b.jpg\" _src=\"http://yanxuan.nosdn.127.net/01aefba507ae7eec7227c4198a66403b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df6e40b4b102add68cf411c5813662ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/df6e40b4b102add68cf411c5813662ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d62ed698a238fc51141e4814e4aa36f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d62ed698a238fc51141e4814e4aa36f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c76b521fd6adde54dbb435245f6870d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c76b521fd6adde54dbb435245f6870d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca3f82155bca6258a3e8ce11f6057b78.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca3f82155bca6258a3e8ce11f6057b78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/436c43a0feedb51240f9c88bc0816733.jpg\" _src=\"http://yanxuan.nosdn.127.net/436c43a0feedb51240f9c88bc0816733.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41481ad182555bdf6b9c2091278414f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/41481ad182555bdf6b9c2091278414f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7546a5f6ef3158ff9b339252ff78696.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7546a5f6ef3158ff9b339252ff78696.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ecb09d1c8ced8b066dce901e51ee8cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ecb09d1c8ced8b066dce901e51ee8cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e403b8fb0f2bb6064412a1980c723d3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e403b8fb0f2bb6064412a1980c723d3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54953bd9dd44742c5ad576b17582a703.jpg\" _src=\"http://yanxuan.nosdn.127.net/54953bd9dd44742c5ad576b17582a703.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cccb1ab3d945b7e24aed1dfbf42b9676.jpg\" _src=\"http://yanxuan.nosdn.127.net/cccb1ab3d945b7e24aed1dfbf42b9676.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe819702b2250071f0a0071687c7389a.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe819702b2250071f0a0071687c7389a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eae0f463b127c7309bfdc13a45e48ff2.jpg\" _src=\"http://yanxuan.nosdn.127.net/eae0f463b127c7309bfdc13a45e48ff2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82e69da4363fc4404bf76b4f409343e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/82e69da4363fc4404bf76b4f409343e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22d0e5472c227bdc30f0ad0d9b35e8af.jpg\" _src=\"http://yanxuan.nosdn.127.net/22d0e5472c227bdc30f0ad0d9b35e8af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99957f03aa9251a8e59a7ae667dc479c.jpg\" _src=\"http://yanxuan.nosdn.127.net/99957f03aa9251a8e59a7ae667dc479c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0433876cad19a06ea91bbc7608d47fee.jpg\" _src=\"http://yanxuan.nosdn.127.net/0433876cad19a06ea91bbc7608d47fee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a965570bf77472bfcec5f14680edd55d.jpg\" _src=\"http://yanxuan.nosdn.127.net/a965570bf77472bfcec5f14680edd55d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99d89cbd0b23b522e5070039889e7a28.jpg\" _src=\"http://yanxuan.nosdn.127.net/99d89cbd0b23b522e5070039889e7a28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb81ad0b1fc1cec89cc2c28bfde6d46d.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb81ad0b1fc1cec89cc2c28bfde6d46d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd2acab71c610d144464defb9e009af8.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd2acab71c610d144464defb9e009af8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/669cda2c9c42fdb0a72c74ea2da71d0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/669cda2c9c42fdb0a72c74ea2da71d0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18090d25c37e360ac4b1410daf14fb2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/18090d25c37e360ac4b1410daf14fb2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6eee9afdba088f358eb96e8901ef6ad3.jpg\" _src=\"http://yanxuan.nosdn.127.net/6eee9afdba088f358eb96e8901ef6ad3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ace611f1dcb46256611b3485f820cf51.jpg\" _src=\"http://yanxuan.nosdn.127.net/ace611f1dcb46256611b3485f820cf51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eacee782799659dcab997fedfb9ef286.jpg\" _src=\"http://yanxuan.nosdn.127.net/eacee782799659dcab997fedfb9ef286.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f26fa1d434ecc7eef863e9708828b79.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f26fa1d434ecc7eef863e9708828b79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f5772eb4931b6d74b3147716f008dd0.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f5772eb4931b6d74b3147716f008dd0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6d176dad0dccbe141aad82a7014eb0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6d176dad0dccbe141aad82a7014eb0e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/edb8b0859327503c7df8b24a544bc2b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/edb8b0859327503c7df8b24a544bc2b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3efc7698b3ebc19aabb61ab061a1e80e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3efc7698b3ebc19aabb61ab061a1e80e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52735272d754f74beb3965970cc76b32.jpg\" _src=\"http://yanxuan.nosdn.127.net/52735272d754f74beb3965970cc76b32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8904e0e64dea985fbd99cbeff1a83db3.jpg\" _src=\"http://yanxuan.nosdn.127.net/8904e0e64dea985fbd99cbeff1a83db3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29b1a16a684be99b30e3f99a5985f681.jpg\" _src=\"http://yanxuan.nosdn.127.net/29b1a16a684be99b30e3f99a5985f681.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef9f6230b76bef57703fac85f69efa0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef9f6230b76bef57703fac85f69efa0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f5bdb37e1abaabb8c2234a631b04aed.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f5bdb37e1abaabb8c2234a631b04aed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31a47d47d24d219a24bdac55eda9b466.jpg\" _src=\"http://yanxuan.nosdn.127.net/31a47d47d24d219a24bdac55eda9b466.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/057140b9ba1541ee97775cfdf5f418db.jpg\" _src=\"http://yanxuan.nosdn.127.net/057140b9ba1541ee97775cfdf5f418db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8329134fe549244755fe13aba2571712.jpg\" _src=\"http://yanxuan.nosdn.127.net/8329134fe549244755fe13aba2571712.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '28', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/6fa3863e4482668ed76afa9839e1032e.jpg', 'http://yanxuan.nosdn.127.net/513d08057c69fdb7d19cc810e976118d.png', '109.00', '983', '1035048', '0.00', '限时购', '', '0.00', '0', '0', '0', '119.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1037011', '1008008', '1037011', '安睡慢回弹记忆绵床垫', '0', '100', '', '5cm记忆绵的亲密包裹', '<p><img src=\"http://yanxuan.nosdn.127.net/0de1b826d70069e199b1a7bb0a9dcf20.jpg\" _src=\"http://yanxuan.nosdn.127.net/0de1b826d70069e199b1a7bb0a9dcf20.jpg\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc1f1a0ad96a8ace2bcdf52e660e59a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc1f1a0ad96a8ace2bcdf52e660e59a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39beecbe6b2f7565cc42f50ab9e9bd06.jpg\" _src=\"http://yanxuan.nosdn.127.net/39beecbe6b2f7565cc42f50ab9e9bd06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa64cb95f94066a4de15083fe741bae4.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa64cb95f94066a4de15083fe741bae4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fc7bbf24ca3aa7c7991dcdc27f64f26.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fc7bbf24ca3aa7c7991dcdc27f64f26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1f254d67dff28081aa22e9c386c7022.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1f254d67dff28081aa22e9c386c7022.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f1827ad687130c3d1b345b3e8c3e8e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f1827ad687130c3d1b345b3e8c3e8e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b76807d7bc32a4b71e68a71094a9a934.jpg\" _src=\"http://yanxuan.nosdn.127.net/b76807d7bc32a4b71e68a71094a9a934.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec78cb8ba4a08e58093b81d85cac54f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec78cb8ba4a08e58093b81d85cac54f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b2ed3ac4084c4608ea951311dfa14e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b2ed3ac4084c4608ea951311dfa14e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9bf6fd8849795c9f3c5912898aa6493.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9bf6fd8849795c9f3c5912898aa6493.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ed0c57dfb615842011fc5b175dfe1059.jpg\" _src=\"http://yanxuan.nosdn.127.net/ed0c57dfb615842011fc5b175dfe1059.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae2662ce9e409ef7f3adda13e5516d77.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae2662ce9e409ef7f3adda13e5516d77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ede81499ac87a2692e25f1942bdc9580.jpg\" _src=\"http://yanxuan.nosdn.127.net/ede81499ac87a2692e25f1942bdc9580.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d471b9a35f873531627c1dd165de3709.jpg\" _src=\"http://yanxuan.nosdn.127.net/d471b9a35f873531627c1dd165de3709.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b19d147f0edf0bcfd270c0aca6f138db.jpg\" _src=\"http://yanxuan.nosdn.127.net/b19d147f0edf0bcfd270c0aca6f138db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24dcb664f1f38694a5432378255aa36a.jpg\" _src=\"http://yanxuan.nosdn.127.net/24dcb664f1f38694a5432378255aa36a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42502a8806348e62676f5d5778cfe063.jpg\" _src=\"http://yanxuan.nosdn.127.net/42502a8806348e62676f5d5778cfe063.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fe544ba36341e6a4f4d233ce7e713eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fe544ba36341e6a4f4d233ce7e713eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61ff53f6e9f3d9e93524caaf90bfcb85.jpg\" _src=\"http://yanxuan.nosdn.127.net/61ff53f6e9f3d9e93524caaf90bfcb85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d8bb21d91874cd56829ccf205923897.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d8bb21d91874cd56829ccf205923897.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/daffb6e380594223f793e944c3f4b077.jpg\" _src=\"http://yanxuan.nosdn.127.net/daffb6e380594223f793e944c3f4b077.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99b0f7110b67307ab02f18673a460cd4.jpg\" _src=\"http://yanxuan.nosdn.127.net/99b0f7110b67307ab02f18673a460cd4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/643a55a8bb471698f6b69ce253501fc8.jpg\" _src=\"http://yanxuan.nosdn.127.net/643a55a8bb471698f6b69ce253501fc8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6041d02391c93451d84601d82ed4dbe3.jpg\" _src=\"http://yanxuan.nosdn.127.net/6041d02391c93451d84601d82ed4dbe3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0b528dbea6de5f0169dda6564f7055b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0b528dbea6de5f0169dda6564f7055b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ecbd17e370b03446b93dc9c61a32fab.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ecbd17e370b03446b93dc9c61a32fab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17150b49d688da488535d894f5182ab3.jpg\" _src=\"http://yanxuan.nosdn.127.net/17150b49d688da488535d894f5182ab3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22b05dc005df61f5c9363b54b1b7edea.jpg\" _src=\"http://yanxuan.nosdn.127.net/22b05dc005df61f5c9363b54b1b7edea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/896a68ff3ae8ae686421e09a58e815e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/896a68ff3ae8ae686421e09a58e815e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8560c3a42081a5c125ab49038665a29a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8560c3a42081a5c125ab49038665a29a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08a377dba39be4540864fb049a580ea3.jpg\" _src=\"http://yanxuan.nosdn.127.net/08a377dba39be4540864fb049a580ea3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb70fc1822b9e08875bd11c183395589.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb70fc1822b9e08875bd11c183395589.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88d0f503ea6c5e17bb71448846aa258b.jpg\" _src=\"http://yanxuan.nosdn.127.net/88d0f503ea6c5e17bb71448846aa258b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/221dad708312cb8ff54306df88e6d976.jpg\" _src=\"http://yanxuan.nosdn.127.net/221dad708312cb8ff54306df88e6d976.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/535b321ee2a870683fc37f5ff3a5893f.jpg\" _src=\"http://yanxuan.nosdn.127.net/535b321ee2a870683fc37f5ff3a5893f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/090125c757d1290c257ab28f285d3e41.jpg\" _src=\"http://yanxuan.nosdn.127.net/090125c757d1290c257ab28f285d3e41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db6e6c73b22e27c06b685de83f8ce4d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/db6e6c73b22e27c06b685de83f8ce4d1.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '22', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/05645050f7c8df7b4a87994c3fd72475.jpg', 'http://yanxuan.nosdn.127.net/a03ea6f4509439acdafcb7ceba1debe0.png', '599.00', '1179', '1059046', '0.00', '限时购', '', '0.00', '0', '0', '1', '658.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1037012', '1008008', '1037012', '圆形护颈苦荞麦枕', '0', '100', '', '高山苦荞填充，放松颈椎', '<p><img src=\"http://yanxuan.nosdn.127.net/92e065fd564833df8d30ee998a6309cb.jpg\" _src=\"http://yanxuan.nosdn.127.net/92e065fd564833df8d30ee998a6309cb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f94db52407c73ef4c3c2ed4ab8c87e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f94db52407c73ef4c3c2ed4ab8c87e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4dddb8eedae26269e0ae1cc114eeee50.jpg\" _src=\"http://yanxuan.nosdn.127.net/4dddb8eedae26269e0ae1cc114eeee50.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d67592cccde77ce175b196fb51534880.jpg\" _src=\"http://yanxuan.nosdn.127.net/d67592cccde77ce175b196fb51534880.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/812a929e1e7db26c1902a5fefa25a7b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/812a929e1e7db26c1902a5fefa25a7b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c1e00a872c146ebcffd1aa42d758496.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c1e00a872c146ebcffd1aa42d758496.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5441c3860c5ff8b3766ba2b0e014213f.jpg\" _src=\"http://yanxuan.nosdn.127.net/5441c3860c5ff8b3766ba2b0e014213f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0a02aee1dc5f8a280eee678ab2d7a45.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0a02aee1dc5f8a280eee678ab2d7a45.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e2a21d3a75d4ec50431ddddd3298ae0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e2a21d3a75d4ec50431ddddd3298ae0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5404f9d679b0d2ca0fd7aafffec1d3c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/5404f9d679b0d2ca0fd7aafffec1d3c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b471c9b0bfcfa0c451eab494ff0278c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b471c9b0bfcfa0c451eab494ff0278c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33c95fe74862820264e02ff290a78272.jpg\" _src=\"http://yanxuan.nosdn.127.net/33c95fe74862820264e02ff290a78272.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f31eb1f1b684de70bc70e8a86a4bc11.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f31eb1f1b684de70bc70e8a86a4bc11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75c423d78d9c56af60958833afeb4452.jpg\" _src=\"http://yanxuan.nosdn.127.net/75c423d78d9c56af60958833afeb4452.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b402caf41e160e62b61237c0a10abe8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b402caf41e160e62b61237c0a10abe8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c83d40738f5a03623bd0f8a24949bb4.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c83d40738f5a03623bd0f8a24949bb4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbdff4265463c930fb06b28767261926.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbdff4265463c930fb06b28767261926.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43355138eb32b8cb6b950d51ba38db5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/43355138eb32b8cb6b950d51ba38db5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1fe3c46e76126d6dc9872c9f0d561e9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/1fe3c46e76126d6dc9872c9f0d561e9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fea1a7969b68ce647e655398e2beef09.jpg\" _src=\"http://yanxuan.nosdn.127.net/fea1a7969b68ce647e655398e2beef09.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e48409e525be320f98fc14aa40ed3a9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e48409e525be320f98fc14aa40ed3a9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8512ad8f5d680271651dbc69d7d8a16a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8512ad8f5d680271651dbc69d7d8a16a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b3e54a7360dd849f3c098fc2cc5ae12.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b3e54a7360dd849f3c098fc2cc5ae12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b7c8648d1cf1c68bfb75293af7fd0c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b7c8648d1cf1c68bfb75293af7fd0c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2db0d7c0f0151662e5a06078efec21c1.jpg\" _src=\"http://yanxuan.nosdn.127.net/2db0d7c0f0151662e5a06078efec21c1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fd50666a97d4cd2cf9c6f32a053b8ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fd50666a97d4cd2cf9c6f32a053b8ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/806a975d21c93917a1e406cd3de8e7f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/806a975d21c93917a1e406cd3de8e7f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32ec426227e7208f93d47c844684e69d.jpg\" _src=\"http://yanxuan.nosdn.127.net/32ec426227e7208f93d47c844684e69d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c472f321af2b527593aa96259944780.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c472f321af2b527593aa96259944780.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86f9773e41872a4398f4118fe0869a3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/86f9773e41872a4398f4118fe0869a3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c629d3761a71fdfca80dfe125b4783cb.jpg\" _src=\"http://yanxuan.nosdn.127.net/c629d3761a71fdfca80dfe125b4783cb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69c8d2d299468bf485e1b62c3121be6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/69c8d2d299468bf485e1b62c3121be6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/038b59945443c481b96936c7a3ca3f81.jpg\" _src=\"http://yanxuan.nosdn.127.net/038b59945443c481b96936c7a3ca3f81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2802906b8b2c3ff849b1b9ed1469d37e.jpg\" _src=\"http://yanxuan.nosdn.127.net/2802906b8b2c3ff849b1b9ed1469d37e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de2b9357eed35a554f3fe3de1fe2d3dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/de2b9357eed35a554f3fe3de1fe2d3dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc35132c0b41f1ee8c9ec5277ef55024.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc35132c0b41f1ee8c9ec5277ef55024.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56869d9a1d818d4836bc8e41a03359d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/56869d9a1d818d4836bc8e41a03359d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89fc80f8e57ec8c7eb89657eb7febcdb.jpg\" _src=\"http://yanxuan.nosdn.127.net/89fc80f8e57ec8c7eb89657eb7febcdb.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/72a0c599c112ee262c2be735ba0eb756.jpg', 'http://yanxuan.nosdn.127.net/ffd2c91c7cf9c6e0f630595f7679b95d.png', '69.00', '3942', '1036028', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1038004', '1005007', '1038004', '100年传世珐琅锅 马卡龙系列', '0', '100', '', '均匀导热，释放美味', '', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/293018c87f7a9e8cfe2b3e62ff7f4216.jpg', 'http://yanxuan.nosdn.127.net/4d3d3eaeb872860539d7faa59f9f84e9.png', '359.00', '3852', '1037022', '0.00', '限时购', '', '0.00', '0', '0', '0', '394.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1039051', '1008002', '1039051', '多功能午睡枕', '1001000', '100', '', '放松自在的午后时光', '<p><img src=\"http://yanxuan.nosdn.127.net/aba5fac220a511eb859ad4834fd7c0e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/aba5fac220a511eb859ad4834fd7c0e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37c7411fe03ac22b8b924190a5c6f483.jpg\" _src=\"http://yanxuan.nosdn.127.net/37c7411fe03ac22b8b924190a5c6f483.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88e313d81b848936d673edebc823f617.jpg\" _src=\"http://yanxuan.nosdn.127.net/88e313d81b848936d673edebc823f617.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/efddbb9e7105a72fb40f168813764297.jpg\" _src=\"http://yanxuan.nosdn.127.net/efddbb9e7105a72fb40f168813764297.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4830e1927e472f45940a92acf3e04331.jpg\" _src=\"http://yanxuan.nosdn.127.net/4830e1927e472f45940a92acf3e04331.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10b2f2989c7239bcea42be91d1826fc7.jpg\" _src=\"http://yanxuan.nosdn.127.net/10b2f2989c7239bcea42be91d1826fc7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3d19a5320eb179b3752458f15f1a068.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3d19a5320eb179b3752458f15f1a068.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97a9d81d01cbc6c8bf57e8b308de1537.jpg\" _src=\"http://yanxuan.nosdn.127.net/97a9d81d01cbc6c8bf57e8b308de1537.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/500497dcf877fbf29548ef7eae7766fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/500497dcf877fbf29548ef7eae7766fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92f6105f284bdd94aa4b6495a7d43994.jpg\" _src=\"http://yanxuan.nosdn.127.net/92f6105f284bdd94aa4b6495a7d43994.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60161ebc38b0b8c8ca9de8a0165843bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/60161ebc38b0b8c8ca9de8a0165843bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ce9817e2d4415c5789028c57c593450.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ce9817e2d4415c5789028c57c593450.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e3dc4f7c9dcd228a94cc4ffa6cea1be.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e3dc4f7c9dcd228a94cc4ffa6cea1be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89360198abf4bbb4c108bfe1068d83b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/89360198abf4bbb4c108bfe1068d83b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f40b5ba3618e61e80ad8f175b3da866.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f40b5ba3618e61e80ad8f175b3da866.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad590b8d9cb20c046d0d8e68ea3b0dc4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad590b8d9cb20c046d0d8e68ea3b0dc4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c606522a6032f1a2268a0ee0d8d01dff.jpg\" _src=\"http://yanxuan.nosdn.127.net/c606522a6032f1a2268a0ee0d8d01dff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f226b9e158f2cf451e925a606d1b5ecd.jpg\" _src=\"http://yanxuan.nosdn.127.net/f226b9e158f2cf451e925a606d1b5ecd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b169357e50d02d557c468588939c7f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b169357e50d02d557c468588939c7f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5e676b79ffc838a2c496134c8c3f55f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5e676b79ffc838a2c496134c8c3f55f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e934b380901ffa4b035825b82246634e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e934b380901ffa4b035825b82246634e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8decfed210a7ada28bd71496a8ef51a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8decfed210a7ada28bd71496a8ef51a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fcc94c2ee6ea13ef7cd7d21f1c63b79.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fcc94c2ee6ea13ef7cd7d21f1c63b79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8bae5453415f2fd519b5cf836e9baddc.jpg\" _src=\"http://yanxuan.nosdn.127.net/8bae5453415f2fd519b5cf836e9baddc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5833f7b80c040d8bdf23e514d430e045.jpg\" _src=\"http://yanxuan.nosdn.127.net/5833f7b80c040d8bdf23e514d430e045.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15df0095ff692e8d67185c93c44680c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/15df0095ff692e8d67185c93c44680c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32fdd19de26dee3281e76dc33059b1f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/32fdd19de26dee3281e76dc33059b1f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/290d679b2fe2154ef36b777525d988bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/290d679b2fe2154ef36b777525d988bc.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99233a211060d951818a729d43bb6533.jpg\" _src=\"http://yanxuan.nosdn.127.net/99233a211060d951818a729d43bb6533.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76fcb532c1aa2f631c0e439f5986654f.jpg\" _src=\"http://yanxuan.nosdn.127.net/76fcb532c1aa2f631c0e439f5986654f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2e90d2089e907d605e1eee0e6fcb1d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2e90d2089e907d605e1eee0e6fcb1d1.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '14', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/20e7e05935a347b36adac369efc490c3.jpg', 'http://yanxuan.nosdn.127.net/c8ca0600fa7ba11ca8be6a3173dd38c9.png', '79.00', '8202', '1038068', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1039056', '1012003', '1039056', '金属亚光钢笔', '0', '100', '', '铱金暗尖，超顺书写', '', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/9a98c755c0a5d2a13557eaeddf64930d.png', 'http://yanxuan.nosdn.127.net/3e14e82a44c3a250af63df4c29c572d0.png', '79.00', '27565', '1038077', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1043005', '1008002', '1043005', '日式记忆绵坐垫', '1001000', '100', '', '活性炭记忆绵，缓解压力', '<p><img src=\"http://yanxuan.nosdn.127.net/7239e35762ea2937549f53f4482124fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/7239e35762ea2937549f53f4482124fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c23c022ad6737aa351140d7ce97a4a43.jpg\" _src=\"http://yanxuan.nosdn.127.net/c23c022ad6737aa351140d7ce97a4a43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6fe3f499101077e6ee595a9145172c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6fe3f499101077e6ee595a9145172c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fdc843045b99838abd8ce3fcbec2890.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fdc843045b99838abd8ce3fcbec2890.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14d3e1c384f5bc66e85b4dfff61f49ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/14d3e1c384f5bc66e85b4dfff61f49ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14eed3d4524fe441a54b604f37cfd299.jpg\" _src=\"http://yanxuan.nosdn.127.net/14eed3d4524fe441a54b604f37cfd299.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1b3a30c34e6fecf8105bf430e6d547f.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1b3a30c34e6fecf8105bf430e6d547f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb5411b150ce5a69c0f88ef3af918061.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb5411b150ce5a69c0f88ef3af918061.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aebe8243acfa28a42d300d985c6e7036.jpg\" _src=\"http://yanxuan.nosdn.127.net/aebe8243acfa28a42d300d985c6e7036.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1371f124f86fc38c195f49e4bf26ddc5.jpg\" _src=\"http://yanxuan.nosdn.127.net/1371f124f86fc38c195f49e4bf26ddc5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd05471ebf5529464c85eace3e7c5c7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd05471ebf5529464c85eace3e7c5c7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c607e963758e4ad3f3bc749098fdcec.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c607e963758e4ad3f3bc749098fdcec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd472e779f1748937d269b87464722b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd472e779f1748937d269b87464722b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d19ec3e68922cdae4da8c0ab174bf5eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/d19ec3e68922cdae4da8c0ab174bf5eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44003fe38ab817003cb441ed5e518c41.jpg\" _src=\"http://yanxuan.nosdn.127.net/44003fe38ab817003cb441ed5e518c41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f3a7c45c70930950e60ddac979953d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f3a7c45c70930950e60ddac979953d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77fc74a83c328dddf610a045277f094e.jpg\" _src=\"http://yanxuan.nosdn.127.net/77fc74a83c328dddf610a045277f094e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14056056c8e8cf3f77a479de696d18ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/14056056c8e8cf3f77a479de696d18ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ec2764b8b29c67af332cc1fde825b70.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ec2764b8b29c67af332cc1fde825b70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/494504fdb2d59d924de16cf79629dee9.jpg\" _src=\"http://yanxuan.nosdn.127.net/494504fdb2d59d924de16cf79629dee9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ddf59afdada25b6b7aad72aaf8f0af20.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddf59afdada25b6b7aad72aaf8f0af20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b8ad80c319aac920f3409bcd4376e17.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b8ad80c319aac920f3409bcd4376e17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8571525a4f280d09926a1b388d06fe8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/8571525a4f280d09926a1b388d06fe8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23c8bb2834f9ec05adb69e4df8354224.jpg\" _src=\"http://yanxuan.nosdn.127.net/23c8bb2834f9ec05adb69e4df8354224.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9c44aea67b0392547fdb3ba7f24c5fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9c44aea67b0392547fdb3ba7f24c5fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5045464902396b85ea12724ed962d7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5045464902396b85ea12724ed962d7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f484b21d07738839d1e199d8ba1031f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/f484b21d07738839d1e199d8ba1031f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21718c637256576c66876aa30653e29d.jpg\" _src=\"http://yanxuan.nosdn.127.net/21718c637256576c66876aa30653e29d.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/aedfe3b7d76361d104a425ff551ade77.jpg', 'http://yanxuan.nosdn.127.net/2a95b16f5b147cab4845641bee738a2e.png', '59.00', '7482', '1041015', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1044012', '1008009', '1044012', '澳洲羊羔毛华夫格盖毯', '0', '100', '', '美利奴全新羊羔毛的细腻触感', '<p><img src=\"http://yanxuan.nosdn.127.net/3f743d4b4f30ddffdfee6339d83701c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f743d4b4f30ddffdfee6339d83701c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf2c4b3d138da32aae6b3ffcdaedeb73.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf2c4b3d138da32aae6b3ffcdaedeb73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3536d6deabba614dd9a8730875a37d36.jpg\" _src=\"http://yanxuan.nosdn.127.net/3536d6deabba614dd9a8730875a37d36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b8d889753ccee9174a5449041aba57db.jpg\" _src=\"http://yanxuan.nosdn.127.net/b8d889753ccee9174a5449041aba57db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0785a14712f2d585fea3776a8775f1e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/0785a14712f2d585fea3776a8775f1e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0c3756c5f4e96c0f37167dce9628a8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0c3756c5f4e96c0f37167dce9628a8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a196080fd7b76bf9e4b2c97afc1028d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a196080fd7b76bf9e4b2c97afc1028d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0d6859834701a093327e3710b52b5b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0d6859834701a093327e3710b52b5b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db0116b70973635ca8ff7be78bf5f541.jpg\" _src=\"http://yanxuan.nosdn.127.net/db0116b70973635ca8ff7be78bf5f541.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f066780f86264b0bc037b945b81b1406.jpg\" _src=\"http://yanxuan.nosdn.127.net/f066780f86264b0bc037b945b81b1406.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0d87991c9a1874693cfecc52c6e1197.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0d87991c9a1874693cfecc52c6e1197.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a450d55776a981ac9aa87af0a7c418f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a450d55776a981ac9aa87af0a7c418f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b450e5950181bf464baff2b7e79188d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b450e5950181bf464baff2b7e79188d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bebe0b8259c7fdd88509947ef0a8037a.jpg\" _src=\"http://yanxuan.nosdn.127.net/bebe0b8259c7fdd88509947ef0a8037a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10be9b68827caaa1b67077c7c5bdf05b.jpg\" _src=\"http://yanxuan.nosdn.127.net/10be9b68827caaa1b67077c7c5bdf05b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56c0dd020ab4aceeb696520df5c8780c.jpg\" _src=\"http://yanxuan.nosdn.127.net/56c0dd020ab4aceeb696520df5c8780c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2176b1f79b255d89206f044e42c3812.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2176b1f79b255d89206f044e42c3812.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/389af26a26c1ac3ebae82afeca4850f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/389af26a26c1ac3ebae82afeca4850f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0897b52523d43efaa5b66449d97a2e5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/0897b52523d43efaa5b66449d97a2e5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fbbb2da0b5019ddacc6761ebc691902.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fbbb2da0b5019ddacc6761ebc691902.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d8576b1472852a8ab96a30d4d8536c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d8576b1472852a8ab96a30d4d8536c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4df95e96ca354efec574e01297fd9e2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4df95e96ca354efec574e01297fd9e2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d98a831ff4adeccd093c3fd8ddbc026b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d98a831ff4adeccd093c3fd8ddbc026b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6050089684ca291a045ab0eea483aab.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6050089684ca291a045ab0eea483aab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/96b0c33ae3b402863bde7b830b817866.jpg\" _src=\"http://yanxuan.nosdn.127.net/96b0c33ae3b402863bde7b830b817866.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d7d595ae0df9e126dca6926b17c3afe.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d7d595ae0df9e126dca6926b17c3afe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4230ca0e414599c38b22c677eac8a2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4230ca0e414599c38b22c677eac8a2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aad253305dcdb44bdbfb519a503823da.jpg\" _src=\"http://yanxuan.nosdn.127.net/aad253305dcdb44bdbfb519a503823da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b512ead08406712b5d98abf20ebe7691.jpg\" _src=\"http://yanxuan.nosdn.127.net/b512ead08406712b5d98abf20ebe7691.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '35', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/80b71f53947bc918cd2a9f0f75168128.jpg', 'http://yanxuan.nosdn.127.net/a803c68ea88e3116023b45ac9ea99510.png', '349.00', '316', '1042084', '0.00', '限时购', '', '0.00', '0', '0', '0', '383.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1045000', '1008015', '1045000', '绿茶蛋黄酥 200克/4枚入', '0', '100', '', '香甜茶食，果腹优选', '', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/c3f1f4ac04ace757bdd4985d933d54c5.jpg', 'http://yanxuan.nosdn.127.net/b2adc3fd9b84a289a1be03e8ee400e61.png', '28.00', '3271', '1077026', '0.00', '限时购', '', '0.00', '0', '0', '0', '30.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1046001', '1012003', '1046001', '按动式三角中油笔', '0', '100', '', '进口笔尖，无毒油墨', '', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '支', 'http://yanxuan.nosdn.127.net/d43304129d1d77039689b9c116dd2218.png', 'http://yanxuan.nosdn.127.net/74583e585825ecacb11f7c53d2021e00.png', '8.90', '2982', '1044001', '0.00', '限时购', '', '0.00', '0', '0', '0', '9.79', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1046002', '1012003', '1046002', '直杆三角中性笔', '0', '100', '', '合金笔尖，高强度笔身', '', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '支', 'http://yanxuan.nosdn.127.net/c63cfb6cfda3959cb09e3dcfc1eef399.png', 'http://yanxuan.nosdn.127.net/eb486cfe807c4fe5696aa59cbcf1f96a.png', '9.90', '38061', '1044002', '0.00', '限时购', '', '0.00', '0', '0', '0', '10.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1046044', '1008009', '1046044', '美利奴羊毛盖毯设计师款', '1001020', '100', '', '欧洲知名品牌设计师联合打造', '<p><img src=\"http://yanxuan.nosdn.127.net/1e6a7d46666cf41f62ae68b5fce159ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e6a7d46666cf41f62ae68b5fce159ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da60db9b1d6fdbd138ffd639ea5a7d96.jpg\" _src=\"http://yanxuan.nosdn.127.net/da60db9b1d6fdbd138ffd639ea5a7d96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e10d5826f500d3921accdbcde3654ed4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e10d5826f500d3921accdbcde3654ed4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a0384e8fbb30e4f28a4eb63db3b570f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a0384e8fbb30e4f28a4eb63db3b570f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c105726991117504fafe0bfbd45b281e.jpg\" _src=\"http://yanxuan.nosdn.127.net/c105726991117504fafe0bfbd45b281e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03e2b1bc1e51731ec5fc4077f3930c90.jpg\" _src=\"http://yanxuan.nosdn.127.net/03e2b1bc1e51731ec5fc4077f3930c90.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf095cc9dcd2e502cf189d8de3f19608.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf095cc9dcd2e502cf189d8de3f19608.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/884911b2fc49d0d40b05479f06513f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/884911b2fc49d0d40b05479f06513f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a1f27e9690b91ab8b1a9eb14173d1258.jpg\" _src=\"http://yanxuan.nosdn.127.net/a1f27e9690b91ab8b1a9eb14173d1258.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b8e25163aec2f41954112dc8a25c236.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b8e25163aec2f41954112dc8a25c236.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d1efb833b2c8d60d1f78d28f43bdbc6.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d1efb833b2c8d60d1f78d28f43bdbc6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97d487110e5ba4f06c5200f92afb5d2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/97d487110e5ba4f06c5200f92afb5d2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f791e35b8d26af8843b3ec85ee5b1ea2.jpg\" _src=\"http://yanxuan.nosdn.127.net/f791e35b8d26af8843b3ec85ee5b1ea2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a3877e74b20978c91a78422710eda61.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a3877e74b20978c91a78422710eda61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c47c9ccf32a82847317332654cffefbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/c47c9ccf32a82847317332654cffefbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/660735bf422574c20d5e1de9a8412b68.jpg\" _src=\"http://yanxuan.nosdn.127.net/660735bf422574c20d5e1de9a8412b68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa0073b73e133fddd218cd873eb4704c.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa0073b73e133fddd218cd873eb4704c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e08a269b051e91d3fcf3f5e1a819587.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e08a269b051e91d3fcf3f5e1a819587.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e6bef09f54ebcf9dfc739bed06ee884.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e6bef09f54ebcf9dfc739bed06ee884.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e91b06b37290a422433531a3c448fc9.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e91b06b37290a422433531a3c448fc9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a860ec70f982f50981bec2e00e2c195.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a860ec70f982f50981bec2e00e2c195.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c9123297e0e183ee00a592430756e4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c9123297e0e183ee00a592430756e4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/745d0978c9fa4a5a4ceb0244f55f2456.jpg\" _src=\"http://yanxuan.nosdn.127.net/745d0978c9fa4a5a4ceb0244f55f2456.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b56578bc472ea3fd1e5ac46fca6189b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b56578bc472ea3fd1e5ac46fca6189b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c606fa0c3704aacb37d6ddc10017337.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c606fa0c3704aacb37d6ddc10017337.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c9f3b7d40f4277a078a774bfb9d8e07.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c9f3b7d40f4277a078a774bfb9d8e07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/628544b6dc30cd67c41dc9506df845a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/628544b6dc30cd67c41dc9506df845a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fef518af8f1e7b38a0eb1b28f4bb51a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/fef518af8f1e7b38a0eb1b28f4bb51a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cda4010f9df50cf85c1f6b2c66739a1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/cda4010f9df50cf85c1f6b2c66739a1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3081818ab418d732c80598a6528ed53b.jpg\" _src=\"http://yanxuan.nosdn.127.net/3081818ab418d732c80598a6528ed53b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f47a15c1b0d754e3fb2e45db373ccc08.jpg\" _src=\"http://yanxuan.nosdn.127.net/f47a15c1b0d754e3fb2e45db373ccc08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc890fd700609bcb80d4162573cc2b5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc890fd700609bcb80d4162573cc2b5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cfa435b515b0ab8cd99b6eb63ca5092f.jpg\" _src=\"http://yanxuan.nosdn.127.net/cfa435b515b0ab8cd99b6eb63ca5092f.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '34', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/66255722e60ae8bb0f61295d642847b6.jpg', 'http://yanxuan.nosdn.127.net/2bfecfe58ea3ee0d554f2ed58e9ba30a.png', '349.00', '1372', '1044116', '0.00', '限时购', '', '0.00', '0', '0', '0', '383.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1048005', '1008002', '1048005', '日式色织水洗条纹抱枕', '1001000', '100', '', '色织面料，水洗工艺，柔软亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/39afc6f165cf752e16c199b65ab61ee8.jpg\" _src=\"http://yanxuan.nosdn.127.net/39afc6f165cf752e16c199b65ab61ee8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2635f2eb08e98687a132a97642d87de.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2635f2eb08e98687a132a97642d87de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08b6bca750a85d833740e1f12e5a6216.jpg\" _src=\"http://yanxuan.nosdn.127.net/08b6bca750a85d833740e1f12e5a6216.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f61f9587dc8aec8330335da87dbb60ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/f61f9587dc8aec8330335da87dbb60ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f22282ebbbeb664ba706e4f088c9db2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f22282ebbbeb664ba706e4f088c9db2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad7819c5597db9fce742cbc61aa53c72.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad7819c5597db9fce742cbc61aa53c72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee4a43824784e660f44e16274c4717ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee4a43824784e660f44e16274c4717ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0eb752fd857fa1af74602afadabb0fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0eb752fd857fa1af74602afadabb0fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46290c0b824babab46ce73feb23a554d.jpg\" _src=\"http://yanxuan.nosdn.127.net/46290c0b824babab46ce73feb23a554d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c34134e19df505b4b1b2277880bba2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c34134e19df505b4b1b2277880bba2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0bce553f09f5146ba9209264c46e38ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/0bce553f09f5146ba9209264c46e38ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/732ed69a0539f4d972213ed64e5bcff0.jpg\" _src=\"http://yanxuan.nosdn.127.net/732ed69a0539f4d972213ed64e5bcff0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/147fcd503618a36a76ed792c6a2254b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/147fcd503618a36a76ed792c6a2254b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f68cea7d1e7dd23349f7c36e366cb6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f68cea7d1e7dd23349f7c36e366cb6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/852711207b87360d29289be16a76e5ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/852711207b87360d29289be16a76e5ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f46c1d0edb91be4fa7c2747b423c494.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f46c1d0edb91be4fa7c2747b423c494.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f2bc29d55899694b917c9991d0b1333.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f2bc29d55899694b917c9991d0b1333.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63d4fa2caa8bbd1d7e205e90fe176633.jpg\" _src=\"http://yanxuan.nosdn.127.net/63d4fa2caa8bbd1d7e205e90fe176633.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f885db84f7911c3c4abc9695f55f19f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/f885db84f7911c3c4abc9695f55f19f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd0c5be6c986a60a577ab7fd4fa9796e.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd0c5be6c986a60a577ab7fd4fa9796e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb0f814679347c4876f2ca30acd57f88.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb0f814679347c4876f2ca30acd57f88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64b5936ea7e076885a7c1611d492aa57.jpg\" _src=\"http://yanxuan.nosdn.127.net/64b5936ea7e076885a7c1611d492aa57.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b503dd5b259a049dc3fffcabe6264c10.jpg\" _src=\"http://yanxuan.nosdn.127.net/b503dd5b259a049dc3fffcabe6264c10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fb47a70640f6c252518a80a803bd362.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fb47a70640f6c252518a80a803bd362.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1837c9a132b1ca0ed52f76f935563b7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1837c9a132b1ca0ed52f76f935563b7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09e9cc037e909c934aba0b87c48914ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/09e9cc037e909c934aba0b87c48914ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5c3a85ee4217386a8161016aa7727b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5c3a85ee4217386a8161016aa7727b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e666622ecebc8fc733a49c5ad7d16c3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e666622ecebc8fc733a49c5ad7d16c3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48f87049ad7e2492ae75da78b97cd6fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/48f87049ad7e2492ae75da78b97cd6fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21cc4790d10496f2e73531c420fbb394.jpg\" _src=\"http://yanxuan.nosdn.127.net/21cc4790d10496f2e73531c420fbb394.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9510a74920b5589cba7af910774f8c0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9510a74920b5589cba7af910774f8c0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c69b713c98187890316668d10aa55c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c69b713c98187890316668d10aa55c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcafde6d38fd075c4ba6d0cc1e816314.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcafde6d38fd075c4ba6d0cc1e816314.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccdf51824645c27ab06e78faa85db7d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccdf51824645c27ab06e78faa85db7d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8096a502cac9f926d288cbbe8b8534fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/8096a502cac9f926d288cbbe8b8534fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b2b9a1f8a1422e3975cbee85685672c.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b2b9a1f8a1422e3975cbee85685672c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd6779619cc7ed6f2a4057526f0c579d.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd6779619cc7ed6f2a4057526f0c579d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdef4d1620407043511daf2e97746f07.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdef4d1620407043511daf2e97746f07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f30d798c772ea1599723c427c1d643b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f30d798c772ea1599723c427c1d643b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0cfc9aae9304010e24d92b29220dc0b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0cfc9aae9304010e24d92b29220dc0b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e20e47f1eaf643bc569ccb148781529.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e20e47f1eaf643bc569ccb148781529.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9beb4226eb47be1c16e872dd9281634.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9beb4226eb47be1c16e872dd9281634.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70d2d737fbf7fc5980604ea294942b41.jpg\" _src=\"http://yanxuan.nosdn.127.net/70d2d737fbf7fc5980604ea294942b41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/496224b05a3054625b065de6aa769959.jpg\" _src=\"http://yanxuan.nosdn.127.net/496224b05a3054625b065de6aa769959.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0671941e0dfb696d5392f174a949a13.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0671941e0dfb696d5392f174a949a13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2df72e131e86e433d939776783a44db7.jpg\" _src=\"http://yanxuan.nosdn.127.net/2df72e131e86e433d939776783a44db7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bea99ca3040befe69d4811e0ef9b226.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bea99ca3040befe69d4811e0ef9b226.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbc003f18889ab46a5a3a7e8698df351.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbc003f18889ab46a5a3a7e8698df351.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee0df8d583844e734273d73eb582a4a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee0df8d583844e734273d73eb582a4a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ea9467e6f4ef5c8f0812c1595704840.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ea9467e6f4ef5c8f0812c1595704840.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2167445c1b3df028d660bb992f321396.jpg', 'http://yanxuan.nosdn.127.net/ce980c16810a471dffff6aa8d7bac754.png', '59.00', '5846', '1047014', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1051000', '1005007', '1051000', 'Carat钻石炒锅30cm', '0', '100', '', '安全涂层，轻便无烟', '', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/fd939503a33960aea571c9f29d76053b.png', 'http://yanxuan.nosdn.127.net/e564410546a11ddceb5a82bfce8da43d.png', '180.00', '1553', '1052001', '0.00', '限时购', '', '0.00', '0', '0', '0', '198.00', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1051001', '1005007', '1051001', 'Carat钻石煎锅28cm', '0', '100', '', '耐磨涂层，导热迅速', '', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/f0c000ef41a6c5d6bffa7cc8cbaf6e95.png', 'http://yanxuan.nosdn.127.net/f53ed57d9e23fda7e24dfd0e0a50c5d1.png', '159.00', '901', '1052004', '0.00', '限时购', '', '0.00', '0', '0', '0', '174.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1051002', '1005007', '1051002', 'Carat钻石汤锅24cm', '0', '100', '', '安全涂层，锁热保温', '', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/39ca3e8d764d73e63a3c6592574bec79.png', 'http://yanxuan.nosdn.127.net/56f4b4753392d27c0c2ccceeb579ed6f.png', '228.00', '1501', '1052006', '0.00', '限时购', '', '0.00', '0', '0', '0', '250.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1051003', '1005007', '1051003', 'Carat钻石奶锅18cm', '0', '100', '', '轻便节能，易于清洗', '', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '只', 'http://yanxuan.nosdn.127.net/1ae5526c8ef9c1be5decb41986827d60.png', 'http://yanxuan.nosdn.127.net/6a54ccc389afb2459b163245bbb2c978.png', '148.00', '4474', '1052008', '0.00', '限时购', '', '0.00', '0', '0', '0', '162.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1055012', '1008002', '1055012', '300根全棉羽丝绒抱枕芯', '0', '100', '', '仪征3D填充，充实的满足感', '<p><img src=\"http://yanxuan.nosdn.127.net/07f2717762df73a6a697bb5399da6376.jpg\" _src=\"http://yanxuan.nosdn.127.net/07f2717762df73a6a697bb5399da6376.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e202bdb4be8f36bda118cf7265d00f65.jpg\" _src=\"http://yanxuan.nosdn.127.net/e202bdb4be8f36bda118cf7265d00f65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b5766cf268d327a3518ee5429c4c4e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b5766cf268d327a3518ee5429c4c4e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f4e4356d070dbca22cf19a60a2447ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f4e4356d070dbca22cf19a60a2447ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da3a3e22d355ccf82235603507f3a083.jpg\" _src=\"http://yanxuan.nosdn.127.net/da3a3e22d355ccf82235603507f3a083.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be789777e5e1381bb7b62d26fcfb619e.jpg\" _src=\"http://yanxuan.nosdn.127.net/be789777e5e1381bb7b62d26fcfb619e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c48e78aa87b8e81eab6a60de74d1c19c.jpg\" _src=\"http://yanxuan.nosdn.127.net/c48e78aa87b8e81eab6a60de74d1c19c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f772f4990d8ae0acac660acf25be2d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f772f4990d8ae0acac660acf25be2d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f1bd930fcb57e79a4ce2a1c4a0f2f4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f1bd930fcb57e79a4ce2a1c4a0f2f4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f481e1e9b8c4e728f4f7225af52a335e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f481e1e9b8c4e728f4f7225af52a335e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fca69439b053b510724cf6834856a2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fca69439b053b510724cf6834856a2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a285ec5ac9c84a6616feca7301f515c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/a285ec5ac9c84a6616feca7301f515c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52435458ac1c48fb45f4a9888052b5b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/52435458ac1c48fb45f4a9888052b5b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01301675d00e13d21588d0bbb72e1745.jpg\" _src=\"http://yanxuan.nosdn.127.net/01301675d00e13d21588d0bbb72e1745.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63627106753f764733cf47047e887d1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/63627106753f764733cf47047e887d1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15ecf40c8045513fe6a1303fe7d4383f.jpg\" _src=\"http://yanxuan.nosdn.127.net/15ecf40c8045513fe6a1303fe7d4383f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8ef113464ff066662e639868e6eda28.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8ef113464ff066662e639868e6eda28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0de1977400dfda99d0601e1c12fdbf1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/0de1977400dfda99d0601e1c12fdbf1e.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '10', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/06930cbd3bcd7c98d7740c18a7986137.jpg', 'http://yanxuan.nosdn.127.net/3d437c8d68e2ec3f3dd61001bf98f16e.png', '39.00', '6669', '1056022', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1055016', '1008002', '1055016', '日式纯棉针织条纹抱枕', '1001000', '100', '', '亲肤舒适，宛如妈妈的怀抱', '<p><img src=\"http://yanxuan.nosdn.127.net/4060bcde249c2501e5d95cfa0888a6c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4060bcde249c2501e5d95cfa0888a6c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afebd965217cfdbc238de9252c7d6e37.jpg\" _src=\"http://yanxuan.nosdn.127.net/afebd965217cfdbc238de9252c7d6e37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b017649229c04dad59c312b3fe0cf7be.jpg\" _src=\"http://yanxuan.nosdn.127.net/b017649229c04dad59c312b3fe0cf7be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e02d923a92d5bef4b264381cffd5d813.jpg\" _src=\"http://yanxuan.nosdn.127.net/e02d923a92d5bef4b264381cffd5d813.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0447366651e06dde345c907e12315c73.jpg\" _src=\"http://yanxuan.nosdn.127.net/0447366651e06dde345c907e12315c73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b5fdb8a54a2bc2285d1136bf9a2a674f.jpg\" _src=\"http://yanxuan.nosdn.127.net/b5fdb8a54a2bc2285d1136bf9a2a674f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1836dd3b75444a3ce42dc49fa5ee513.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1836dd3b75444a3ce42dc49fa5ee513.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f4740ae47c3ca8465e1ea6ec0a43563.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f4740ae47c3ca8465e1ea6ec0a43563.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f9f33a85933788209e6195468044387.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f9f33a85933788209e6195468044387.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6ceab4330e0dd218db3c16582465be1.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6ceab4330e0dd218db3c16582465be1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1dea7df197ba1e5ce5e9646aea43f798.jpg\" _src=\"http://yanxuan.nosdn.127.net/1dea7df197ba1e5ce5e9646aea43f798.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/022e305413c9aa8e8db30a46a2a65286.jpg\" _src=\"http://yanxuan.nosdn.127.net/022e305413c9aa8e8db30a46a2a65286.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cce2571a59a0bc39784d61c4134f9458.jpg\" _src=\"http://yanxuan.nosdn.127.net/cce2571a59a0bc39784d61c4134f9458.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1f287dab80d1b11450051de6c119611.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1f287dab80d1b11450051de6c119611.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7b6318cb7623349542ba971cf1887da.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7b6318cb7623349542ba971cf1887da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf56a8ae91e07c91d70cf7b88cb59676.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf56a8ae91e07c91d70cf7b88cb59676.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76aebdbc4a150837b2dcaa2293c85cc4.jpg\" _src=\"http://yanxuan.nosdn.127.net/76aebdbc4a150837b2dcaa2293c85cc4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/902fb302066a65488ed1f6da3a16ed66.jpg\" _src=\"http://yanxuan.nosdn.127.net/902fb302066a65488ed1f6da3a16ed66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd9df2852e760940b0ab9e599320ed35.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd9df2852e760940b0ab9e599320ed35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ad1c6c9e619df09685cf9596339d714.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ad1c6c9e619df09685cf9596339d714.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83e54a3b9d13dc3c67e880c02e63167c.jpg\" _src=\"http://yanxuan.nosdn.127.net/83e54a3b9d13dc3c67e880c02e63167c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f6b75fe4ff9ae0b976c8c85bbf0a719.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f6b75fe4ff9ae0b976c8c85bbf0a719.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82f850ea52ca3e7048283b3f8a65c616.jpg\" _src=\"http://yanxuan.nosdn.127.net/82f850ea52ca3e7048283b3f8a65c616.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5bd4faa4898d9ea3c56fba9c5749cc62.jpg\" _src=\"http://yanxuan.nosdn.127.net/5bd4faa4898d9ea3c56fba9c5749cc62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6488dedf51c6e5a90fc5f156a4e8416b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6488dedf51c6e5a90fc5f156a4e8416b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc667ddb5116ceaf329f55982da36bb1.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc667ddb5116ceaf329f55982da36bb1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dfbfde943773a0258fa81b84d710d36e.jpg\" _src=\"http://yanxuan.nosdn.127.net/dfbfde943773a0258fa81b84d710d36e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60d64bb0ac51346dc39d266beacdb846.jpg\" _src=\"http://yanxuan.nosdn.127.net/60d64bb0ac51346dc39d266beacdb846.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c50c0fd364d6b9a8646d0da75ce48f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c50c0fd364d6b9a8646d0da75ce48f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b24da9df819efdf9e110bb2228eadf0d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b24da9df819efdf9e110bb2228eadf0d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3cbbd9ec8dd41be2b35bf49842b67d86.jpg\" _src=\"http://yanxuan.nosdn.127.net/3cbbd9ec8dd41be2b35bf49842b67d86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d5bb53b92ed48f3f81980e41b51c0fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d5bb53b92ed48f3f81980e41b51c0fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d75a8fd77357f9a74a36fd7bfa7cebed.jpg\" _src=\"http://yanxuan.nosdn.127.net/d75a8fd77357f9a74a36fd7bfa7cebed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2dd8069e6739d732a53c25c74c0b2a89.jpg\" _src=\"http://yanxuan.nosdn.127.net/2dd8069e6739d732a53c25c74c0b2a89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7b4e172f8fd168e28854c3d8d04c56f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7b4e172f8fd168e28854c3d8d04c56f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8b981b58ffb3e0a75916def11e45493.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8b981b58ffb3e0a75916def11e45493.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fb12dd3d12c8828a5cf2e16f17a8f27.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fb12dd3d12c8828a5cf2e16f17a8f27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8df57201eb9f5e7b576a6ccc31286e8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8df57201eb9f5e7b576a6ccc31286e8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f86f20ab83206abfdd682418e3cd3ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f86f20ab83206abfdd682418e3cd3ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c64ea783c9bd6dd2cb51b9978769edb.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c64ea783c9bd6dd2cb51b9978769edb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/104dca8bdfb6413fed5379a5b04eec10.jpg\" _src=\"http://yanxuan.nosdn.127.net/104dca8bdfb6413fed5379a5b04eec10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2cfb7760b81f0a82bdbae5079bfcd5ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/2cfb7760b81f0a82bdbae5079bfcd5ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c6e09984c0599b5205f4d099cd5cfcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c6e09984c0599b5205f4d099cd5cfcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e32f3a0bbc7ba3ec49b69fa89ba7da39.jpg\" _src=\"http://yanxuan.nosdn.127.net/e32f3a0bbc7ba3ec49b69fa89ba7da39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/408bf6b2815efea1020278ff57204667.jpg\" _src=\"http://yanxuan.nosdn.127.net/408bf6b2815efea1020278ff57204667.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6707b10b7a14f7d2e7487f30a687cfb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/6707b10b7a14f7d2e7487f30a687cfb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c4977d2ce8691f85575698990c13c3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c4977d2ce8691f85575698990c13c3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22213164e3ce12c23260519cc5f2dd7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/22213164e3ce12c23260519cc5f2dd7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9c8f7fda81f79cec8e75404386677c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9c8f7fda81f79cec8e75404386677c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1e5093b54f817ed1906fc58e7494790.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1e5093b54f817ed1906fc58e7494790.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/162452d2cb5ad3348862d5b1da7348c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/162452d2cb5ad3348862d5b1da7348c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8f6de9bc947bed7d5cebfe1f49a786d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8f6de9bc947bed7d5cebfe1f49a786d.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/8132003a8940c7056960c3c5fce59903.jpg', 'http://yanxuan.nosdn.127.net/23e0203f1512f33e605f61c28fa03d2d.png', '59.00', '948', '1056032', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1055022', '1012003', '1055022', '磨砂杆直杆中性笔', '0', '100', '', '高韧笔杆，书写不疲惫', '', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/57c9250bdc9876a1c4878f9256632d48.png', 'http://yanxuan.nosdn.127.net/c7c74a96eacb29455dbf557b840eaaf5.png', '4.90', '19759', '1056048', '0.00', '限时购', '', '0.00', '0', '0', '0', '5.39', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1056002', '1010002', '1056002', '男式玩色内裤', '0', '100', '', '德国工艺，多色随搭', '', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '条', 'http://yanxuan.nosdn.127.net/fee5c31b4010b91ecc88e971b31f85e0.png', 'http://yanxuan.nosdn.127.net/922fdbe007033f7a88f7ebc57c3d1e75.png', '59.00', '14859', '1057029', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1057036', '1008002', '1057036', '日式纯色水洗亚麻抱枕', '1001000', '100', '', '水洗亚麻，透气亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/6b69f7597ccffd27d77467d9d04eb294.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b69f7597ccffd27d77467d9d04eb294.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a89ca371ef07355c1feb293db961bd30.jpg\" _src=\"http://yanxuan.nosdn.127.net/a89ca371ef07355c1feb293db961bd30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2076e89c5f8fde4f44f918bd02d18eb7.jpg\" _src=\"http://yanxuan.nosdn.127.net/2076e89c5f8fde4f44f918bd02d18eb7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c9111e4dcc13cb41db98f68086cc620.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c9111e4dcc13cb41db98f68086cc620.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f0645abcf883e7a863f32ce95f3c26b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f0645abcf883e7a863f32ce95f3c26b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76a2b12f2d0f48f268d18b0ca0d1d6bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/76a2b12f2d0f48f268d18b0ca0d1d6bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a91f75159867f33a91f4e9992e00afa1.jpg\" _src=\"http://yanxuan.nosdn.127.net/a91f75159867f33a91f4e9992e00afa1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/93de61256a8ff3a8aa4bb90847ff454e.jpg\" _src=\"http://yanxuan.nosdn.127.net/93de61256a8ff3a8aa4bb90847ff454e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f611f99bea2920881e1421c110970234.jpg\" _src=\"http://yanxuan.nosdn.127.net/f611f99bea2920881e1421c110970234.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a292339423f141ad5d7a4011ea316956.jpg\" _src=\"http://yanxuan.nosdn.127.net/a292339423f141ad5d7a4011ea316956.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2045ae4f861d9eae6af351b9d82c9239.jpg\" _src=\"http://yanxuan.nosdn.127.net/2045ae4f861d9eae6af351b9d82c9239.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/398718a6d579c4af5f255909283e44a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/398718a6d579c4af5f255909283e44a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5be95e2db627908d23605fe042af2937.jpg\" _src=\"http://yanxuan.nosdn.127.net/5be95e2db627908d23605fe042af2937.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50a4fa0f67aa85dfaad36695225fe2f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/50a4fa0f67aa85dfaad36695225fe2f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c825e297cfbaaae632146a55c61dc3c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c825e297cfbaaae632146a55c61dc3c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/261c7819e7e9ac165e64cae88a59f70c.jpg\" _src=\"http://yanxuan.nosdn.127.net/261c7819e7e9ac165e64cae88a59f70c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec83f40d91fcc79f59a2479dffeb4565.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec83f40d91fcc79f59a2479dffeb4565.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26f3e85402086b7d261a650e244dc676.jpg\" _src=\"http://yanxuan.nosdn.127.net/26f3e85402086b7d261a650e244dc676.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dccb68f0d97112d245ab1924744b94b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/dccb68f0d97112d245ab1924744b94b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aaba69949efd7ed85e72071f4ade4945.jpg\" _src=\"http://yanxuan.nosdn.127.net/aaba69949efd7ed85e72071f4ade4945.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f23300061e5cf871e86a51f0012e885.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f23300061e5cf871e86a51f0012e885.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a55eedca057e0c973549ac8f13b47800.jpg\" _src=\"http://yanxuan.nosdn.127.net/a55eedca057e0c973549ac8f13b47800.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abf16e831285e3d97dbb60a3162e7968.jpg\" _src=\"http://yanxuan.nosdn.127.net/abf16e831285e3d97dbb60a3162e7968.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9390c8dab9fc7d8c27ac9410eb0340c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9390c8dab9fc7d8c27ac9410eb0340c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8feb2be5afec5abe439cf1b42683373f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8feb2be5afec5abe439cf1b42683373f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/beb7620d0f685ab9c3af7ed18284b29e.jpg\" _src=\"http://yanxuan.nosdn.127.net/beb7620d0f685ab9c3af7ed18284b29e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f70ceed2078d44d747a9ce369feee9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f70ceed2078d44d747a9ce369feee9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5469e219bd5347568337746b257f094e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5469e219bd5347568337746b257f094e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a177a6b6e58580809330895ebdbaff6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a177a6b6e58580809330895ebdbaff6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9db0090d56ab757babb2ba661726cbe3.jpg\" _src=\"http://yanxuan.nosdn.127.net/9db0090d56ab757babb2ba661726cbe3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6363637e0dd2fc670745c217b2a5cbfc.jpg\" _src=\"http://yanxuan.nosdn.127.net/6363637e0dd2fc670745c217b2a5cbfc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1af1bde98f1497f591f62bff99ccca54.jpg\" _src=\"http://yanxuan.nosdn.127.net/1af1bde98f1497f591f62bff99ccca54.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69d034b353ae2e6e30afb6c21483690f.jpg\" _src=\"http://yanxuan.nosdn.127.net/69d034b353ae2e6e30afb6c21483690f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e29d6ac5ed040d63847ca456a179d43.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e29d6ac5ed040d63847ca456a179d43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29e460fba57f67cd83121f6cb917cfbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/29e460fba57f67cd83121f6cb917cfbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16090c02f4d4b76c6be82d98e489586e.jpg\" _src=\"http://yanxuan.nosdn.127.net/16090c02f4d4b76c6be82d98e489586e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c840eb66cf002227c52a13fbe55f657b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c840eb66cf002227c52a13fbe55f657b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16f65265b0942a60f3241704dc29be13.jpg\" _src=\"http://yanxuan.nosdn.127.net/16f65265b0942a60f3241704dc29be13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54a63da54b4e80867d8cd92d1ea9576e.jpg\" _src=\"http://yanxuan.nosdn.127.net/54a63da54b4e80867d8cd92d1ea9576e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ebd0b906076850983e5a2aae9f667ce7.jpg\" _src=\"http://yanxuan.nosdn.127.net/ebd0b906076850983e5a2aae9f667ce7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbf32cdc82643a85c12ff05ea88088ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbf32cdc82643a85c12ff05ea88088ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca6e3ccc3725c3f58338b62a5a0655d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca6e3ccc3725c3f58338b62a5a0655d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ef02962e6155f811566aad168dabbec.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ef02962e6155f811566aad168dabbec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/832735166071f05288ffd347dff58ee6.jpg\" _src=\"http://yanxuan.nosdn.127.net/832735166071f05288ffd347dff58ee6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fc490c4e9a0a0fa0affd317b8526f4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fc490c4e9a0a0fa0affd317b8526f4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b05f975f16c09f106c81533c1a249b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b05f975f16c09f106c81533c1a249b0.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f40fffd36cc85d5e0cf69417f4192ac1.jpg', 'http://yanxuan.nosdn.127.net/8a9ee5ba08929cc9e40b973607d2f633.png', '79.00', '1727', '1058097', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064000', '1017000', '1064000', '清新条纹开放式宠物窝', '1015000', '100', '', '清凉触感，耐抓耐磨', '<p><img src=\"http://yanxuan.nosdn.127.net/8c548cb27c126404efe2450f2d27b499.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c548cb27c126404efe2450f2d27b499.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67c38eb5939bfe33d13b4b336633df66.jpg\" _src=\"http://yanxuan.nosdn.127.net/67c38eb5939bfe33d13b4b336633df66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1593939bfdc309df4faeda6cc13795ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/1593939bfdc309df4faeda6cc13795ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19adc7cd503aa53cadbcb5719cfee8e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/19adc7cd503aa53cadbcb5719cfee8e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb5ca4e6f1cd024a10b9bc37b2db396b.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb5ca4e6f1cd024a10b9bc37b2db396b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5329ce259b9749db939845280eb2443.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5329ce259b9749db939845280eb2443.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcbd4101079f3e86ace47f581c52d12d.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcbd4101079f3e86ace47f581c52d12d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cd95e21492d1197182ceeacdb3a9973.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cd95e21492d1197182ceeacdb3a9973.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/681b12dba20b3ec4cc8220907453411b.jpg\" _src=\"http://yanxuan.nosdn.127.net/681b12dba20b3ec4cc8220907453411b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2d4d84fd984e16caf44b2a0418f8427.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2d4d84fd984e16caf44b2a0418f8427.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/db1c3f9146192d3ef43b26dd6381deba.jpg', 'http://yanxuan.nosdn.127.net/ebe118f94ddafe82c4a8cd51da6ff183.png', '79.00', '392', '1066000', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064002', '1017000', '1064002', '秋冬加厚条纹宠物窝', '1015000', '100', '', '时尚牛仔，加厚温暖', '<p><img src=\"http://yanxuan.nosdn.127.net/86c5f5a3459ef9c80005b8aa166978d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/86c5f5a3459ef9c80005b8aa166978d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75523f35d5f7241e050e947327dcf505.jpg\" _src=\"http://yanxuan.nosdn.127.net/75523f35d5f7241e050e947327dcf505.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8806274559067d9068029a13170201b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8806274559067d9068029a13170201b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3e9ab7fd7b25f737fb36eabf5e12a7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3e9ab7fd7b25f737fb36eabf5e12a7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36f48ab394369b521d10d4a88234673c.jpg\" _src=\"http://yanxuan.nosdn.127.net/36f48ab394369b521d10d4a88234673c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5166fb4e87f789e975216805a7b7adaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/5166fb4e87f789e975216805a7b7adaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/052e9fc4b166d8721274d28d61d4e126.jpg\" _src=\"http://yanxuan.nosdn.127.net/052e9fc4b166d8721274d28d61d4e126.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/173830764375470fc8f29d97fbe3da72.jpg\" _src=\"http://yanxuan.nosdn.127.net/173830764375470fc8f29d97fbe3da72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ec75067b43329566a21963dc53e448d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ec75067b43329566a21963dc53e448d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e497b21b1e274a3bff78099cbb934eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e497b21b1e274a3bff78099cbb934eb.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7bda641422377741f5384f006fd52a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7bda641422377741f5384f006fd52a4.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/5e80c410c68ac2663cb886c0434a278d.jpg', 'http://yanxuan.nosdn.127.net/48dbfe207b2203ef45055dcc9cedbe60.png', '69.00', '3385', '1066002', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064003', '1017000', '1064003', '六边形南瓜式宠物窝', '1015000', '100', '', '给萌宠柔软包裹的归家感', '<p><img src=\"http://yanxuan.nosdn.127.net/44f4fe5b43365884131b07c25b3c54ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/44f4fe5b43365884131b07c25b3c54ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/beabfe6fd0717daa3544ac7c2d82b430.jpg\" _src=\"http://yanxuan.nosdn.127.net/beabfe6fd0717daa3544ac7c2d82b430.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25467804bf2eed0d07f171c10f798d2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/25467804bf2eed0d07f171c10f798d2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fced8c058df228bed15bc8822fa871c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fced8c058df228bed15bc8822fa871c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3eea3bd19f75f01a7ed424be3aa9d42.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3eea3bd19f75f01a7ed424be3aa9d42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e30076799805a678af405dce6ccf6d62.jpg\" _src=\"http://yanxuan.nosdn.127.net/e30076799805a678af405dce6ccf6d62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac4cdbb579512a23287b4a43639b5e34.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac4cdbb579512a23287b4a43639b5e34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2cf8b27e7c89f0a46cbd330bb81ab1a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/2cf8b27e7c89f0a46cbd330bb81ab1a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3021babd417d3b3791db8b9684c9a07e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3021babd417d3b3791db8b9684c9a07e.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a72b172bf0e8ad6d0d6735750e1d375c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a72b172bf0e8ad6d0d6735750e1d375c.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/16acbbf7885d63e56c71a7eb7ef75a02.jpg', 'http://yanxuan.nosdn.127.net/58ed94b63b39339e7814f1339013793c.png', '89.00', '1037', '1066004', '0.00', '限时购', '', '0.00', '0', '0', '0', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064004', '1017000', '1064004', '方形封闭式宠物窝', '1015000', '100', '', '封闭式设计猫咪独享', '<p><img src=\"http://yanxuan.nosdn.127.net/09f022af55341d80d5d3ad620ce6d779.jpg\" _src=\"http://yanxuan.nosdn.127.net/09f022af55341d80d5d3ad620ce6d779.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d75ea4c580effd435ed00f652c01a778.jpg\" _src=\"http://yanxuan.nosdn.127.net/d75ea4c580effd435ed00f652c01a778.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fad82d53a0494c625608786f5931950.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fad82d53a0494c625608786f5931950.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a1d8a1cb8a57ae7921f34a9d761f3aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a1d8a1cb8a57ae7921f34a9d761f3aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/261670eea6a48c7e307393ce295e2ce5.jpg\" _src=\"http://yanxuan.nosdn.127.net/261670eea6a48c7e307393ce295e2ce5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11bfc68005a0ce9b80e01f614a259af7.jpg\" _src=\"http://yanxuan.nosdn.127.net/11bfc68005a0ce9b80e01f614a259af7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/688f822cf34c656367cccfb0d9f72151.jpg\" _src=\"http://yanxuan.nosdn.127.net/688f822cf34c656367cccfb0d9f72151.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f3721906d7c6c0c30193d4778eff9e4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f3721906d7c6c0c30193d4778eff9e4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/090e9c28dc2736a1246ef914e35634c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/090e9c28dc2736a1246ef914e35634c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f31d497ae028ff2c2e933d712ccc055d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f31d497ae028ff2c2e933d712ccc055d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a424b9e51b854c4abf61b8c1c1cdf1aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/a424b9e51b854c4abf61b8c1c1cdf1aa.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7660d03152dea988256eac3be92541b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/7660d03152dea988256eac3be92541b3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/09bcb1482b8b51920bda67638e7249e8.jpg', 'http://yanxuan.nosdn.127.net/337da7094c1df295ca0f0b8baa55b2d5.png', '99.00', '618', '1066005', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064006', '1008008', '1064006', '3D纯棉护颈加翼记忆枕', '0', '100', '', '深色面料，安睡护颈', '<p><img src=\"http://yanxuan.nosdn.127.net/5ea4edcd9cbd70f9d347a0191f5ac1e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ea4edcd9cbd70f9d347a0191f5ac1e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ffee41deb5a0b0017d5ac3f7feda520.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ffee41deb5a0b0017d5ac3f7feda520.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fa38f7a466b792826d03a7fc094b205.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fa38f7a466b792826d03a7fc094b205.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4dc78b172a7818190aee72bf7c5a55c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4dc78b172a7818190aee72bf7c5a55c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/086e2994f14897353fa9413f886e88f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/086e2994f14897353fa9413f886e88f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e46cdebba21e08125e9317c32679ff9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/e46cdebba21e08125e9317c32679ff9f.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86ebedb440da6e2af676554c39bfd653.jpg\" _src=\"http://yanxuan.nosdn.127.net/86ebedb440da6e2af676554c39bfd653.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b6728641afdc97f2fbb50c2b886c355.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b6728641afdc97f2fbb50c2b886c355.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a20cb1abd9e46768d63c0a03e780b921.jpg\" _src=\"http://yanxuan.nosdn.127.net/a20cb1abd9e46768d63c0a03e780b921.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/974d424a27d3502b203e66ad5b708e62.jpg\" _src=\"http://yanxuan.nosdn.127.net/974d424a27d3502b203e66ad5b708e62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c2df5c9e231ed917745ab770afe668d.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c2df5c9e231ed917745ab770afe668d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc6ac3894803fe0030141852bd639558.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc6ac3894803fe0030141852bd639558.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aaedff798dfbe28754bad944434ef654.jpg\" _src=\"http://yanxuan.nosdn.127.net/aaedff798dfbe28754bad944434ef654.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d68bb36c8d47486b64e1551540887da7.jpg\" _src=\"http://yanxuan.nosdn.127.net/d68bb36c8d47486b64e1551540887da7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/35a5871cbc972b340191c6f558f4eb5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/35a5871cbc972b340191c6f558f4eb5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7256ce7e7549fa545d8088e88cb9a200.jpg\" _src=\"http://yanxuan.nosdn.127.net/7256ce7e7549fa545d8088e88cb9a200.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/843e2e7ffd5d80ee3a714df546e5d76b.jpg\" _src=\"http://yanxuan.nosdn.127.net/843e2e7ffd5d80ee3a714df546e5d76b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc7115f361220617b7d66be8a76346cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc7115f361220617b7d66be8a76346cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/876075252dfc043c15a86e6d2415b4c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/876075252dfc043c15a86e6d2415b4c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0cf1cdc2efd85cb5934515ad68975300.jpg\" _src=\"http://yanxuan.nosdn.127.net/0cf1cdc2efd85cb5934515ad68975300.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df538abb58fb3ff667f919f9688e68c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/df538abb58fb3ff667f919f9688e68c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e85c449ea1794d6925af9187e1dde6d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e85c449ea1794d6925af9187e1dde6d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c628d454aba737cd8fbd5bb52bb41a0.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c628d454aba737cd8fbd5bb52bb41a0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e3b34066432dd830d7dea59f5172622.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e3b34066432dd830d7dea59f5172622.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8edc3903956456e4fbbd6844d1843079.jpg\" _src=\"http://yanxuan.nosdn.127.net/8edc3903956456e4fbbd6844d1843079.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ae7b238aa8be68f915b27c064fc1234.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ae7b238aa8be68f915b27c064fc1234.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7d59a45d54cbeb7fd3d4e3a9f6f20de.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7d59a45d54cbeb7fd3d4e3a9f6f20de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/060287eacf5855100691a931615753a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/060287eacf5855100691a931615753a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/154e9d3945f092141030f9e0ffe00d75.jpg\" _src=\"http://yanxuan.nosdn.127.net/154e9d3945f092141030f9e0ffe00d75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/538caa5366b10fce92532c4094be7b41.jpg\" _src=\"http://yanxuan.nosdn.127.net/538caa5366b10fce92532c4094be7b41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e08d88f1f11877e188f63d9abe319e50.jpg\" _src=\"http://yanxuan.nosdn.127.net/e08d88f1f11877e188f63d9abe319e50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8b31045cb0c2627f7f31bd6b0900482.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8b31045cb0c2627f7f31bd6b0900482.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33e654f6e06a9b39982f73ce9fbffecd.jpg\" _src=\"http://yanxuan.nosdn.127.net/33e654f6e06a9b39982f73ce9fbffecd.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/fc7ac414d4c0931b52013f70d8f8cc66.jpg', 'http://yanxuan.nosdn.127.net/35306b8e65932dd28a5628d0bb44a044.png', '129.00', '230', '1066007', '0.00', '限时购', '', '0.00', '0', '0', '0', '141.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064007', '1008008', '1064007', '3D纯棉护颈双人记忆枕', '0', '100', '', '纯棉呵护，属于你我的记忆', '<p><img src=\"http://yanxuan.nosdn.127.net/412aea28b2b2a73c2c72d6727cf393a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/412aea28b2b2a73c2c72d6727cf393a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4a0702b3c4f283600ba6d0cf789f7de.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4a0702b3c4f283600ba6d0cf789f7de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/730b0efa8afa256d23501ec96a5e2ddd.jpg\" _src=\"http://yanxuan.nosdn.127.net/730b0efa8afa256d23501ec96a5e2ddd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81642b7941c7b8bdbdc4dc77ffcc5578.jpg\" _src=\"http://yanxuan.nosdn.127.net/81642b7941c7b8bdbdc4dc77ffcc5578.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/593d154ce6d6f420331932e6794e991b.jpg\" _src=\"http://yanxuan.nosdn.127.net/593d154ce6d6f420331932e6794e991b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c2516ab2aef32792a69942c292e813.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c2516ab2aef32792a69942c292e813.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3c8f152cc56156cd8f4a5a98acf43b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3c8f152cc56156cd8f4a5a98acf43b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9665043bbe3711d5d3ea3cab77eddd2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9665043bbe3711d5d3ea3cab77eddd2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9096c64c682e547fbdaf1b289196ed5.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9096c64c682e547fbdaf1b289196ed5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4beee3ba8d300d83e2c6480773c5a972.jpg\" _src=\"http://yanxuan.nosdn.127.net/4beee3ba8d300d83e2c6480773c5a972.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cbff77e1a0e2db87e173257cd99e8e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cbff77e1a0e2db87e173257cd99e8e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b35b8cbd427cf60ebba8dcce0c28b539.jpg\" _src=\"http://yanxuan.nosdn.127.net/b35b8cbd427cf60ebba8dcce0c28b539.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4c24df5c03097c024198509c61d13c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4c24df5c03097c024198509c61d13c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46d41a03a6e247db80941864feb08d10.jpg\" _src=\"http://yanxuan.nosdn.127.net/46d41a03a6e247db80941864feb08d10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0949c665b92f97cd784c1f987be48f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0949c665b92f97cd784c1f987be48f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd0857dbfa145f284871ea82b0ce5bdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd0857dbfa145f284871ea82b0ce5bdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce93e3abde3c15477d40295b53608327.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce93e3abde3c15477d40295b53608327.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/330c817b824269d069e49545ab001861.jpg\" _src=\"http://yanxuan.nosdn.127.net/330c817b824269d069e49545ab001861.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6cc67bcfe20910e921b5125282f8f781.jpg\" _src=\"http://yanxuan.nosdn.127.net/6cc67bcfe20910e921b5125282f8f781.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06167a2aa51379b28bd2a3b74f7c6e3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/06167a2aa51379b28bd2a3b74f7c6e3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50f9908d4e3cbbafd98608dda4546f4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/50f9908d4e3cbbafd98608dda4546f4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d11343ac19faac774685171bbe16968.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d11343ac19faac774685171bbe16968.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/068b8d329e8199f4e8b1a9690c3bc14c.jpg\" _src=\"http://yanxuan.nosdn.127.net/068b8d329e8199f4e8b1a9690c3bc14c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e21f0029ccbbd476c03fd1a019b422a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e21f0029ccbbd476c03fd1a019b422a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20ca6208612904cbc2991878940a116d.jpg\" _src=\"http://yanxuan.nosdn.127.net/20ca6208612904cbc2991878940a116d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/593d99720e59b5833d5a7b0628cdf808.jpg\" _src=\"http://yanxuan.nosdn.127.net/593d99720e59b5833d5a7b0628cdf808.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/444772cbd5f5d7345161d7ec0f2dd15a.jpg\" _src=\"http://yanxuan.nosdn.127.net/444772cbd5f5d7345161d7ec0f2dd15a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5028a4c384c1f978b2823511711ac74.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5028a4c384c1f978b2823511711ac74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70b25a0d4f606bea16d24faabac5dc58.jpg\" _src=\"http://yanxuan.nosdn.127.net/70b25a0d4f606bea16d24faabac5dc58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d8acaaea02d7bd40b3b61db2481356f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d8acaaea02d7bd40b3b61db2481356f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ddbc782913dc6fb3cc1b08899995edc8.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddbc782913dc6fb3cc1b08899995edc8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81a914fb23780ee53e722d570352d4e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/81a914fb23780ee53e722d570352d4e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c45103aa5110765ad12a8e6343f161f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/c45103aa5110765ad12a8e6343f161f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71f0b88b4ed59f6d3bb6093270b2047e.jpg\" _src=\"http://yanxuan.nosdn.127.net/71f0b88b4ed59f6d3bb6093270b2047e.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '12', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e1b306965757f9ebf849b2ab80e688ef.jpg', 'http://yanxuan.nosdn.127.net/d7bd87f8cc1965b25be33a8aad53812b.png', '249.00', '29', '1066008', '0.00', '限时购', '', '0.00', '0', '0', '0', '273.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064021', '1008016', '1064021', '清欢日式可调节台灯', '0', '100', '', '木铁结合，全体可调节', '<p><img src=\"http://yanxuan.nosdn.127.net/15e1d839714a67bff57259d61d7ca2e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/15e1d839714a67bff57259d61d7ca2e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43ba9bbc931f954e0aaeb90631a179ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/43ba9bbc931f954e0aaeb90631a179ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac5ca160c90c1a700160d5d024ad611b.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac5ca160c90c1a700160d5d024ad611b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f2d157d83955d5c616dc3d647da6f66.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f2d157d83955d5c616dc3d647da6f66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2ee5af100a5432f0614e9717196787e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2ee5af100a5432f0614e9717196787e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91fb28c19d495e47797ef250940ab618.jpg\" _src=\"http://yanxuan.nosdn.127.net/91fb28c19d495e47797ef250940ab618.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f37742eed13ea12d8c341e1e3b988e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f37742eed13ea12d8c341e1e3b988e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ff15b419a0248b7b53bd60286067766.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ff15b419a0248b7b53bd60286067766.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21c4dacdc844da911e43eaac0975908a.jpg\" _src=\"http://yanxuan.nosdn.127.net/21c4dacdc844da911e43eaac0975908a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f8741dd387c51378f78bdbf65856a41.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f8741dd387c51378f78bdbf65856a41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbe9726936999c62ac8bce3b620cd045.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbe9726936999c62ac8bce3b620cd045.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d12ad2de3cb646e76380c064ccfe038f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d12ad2de3cb646e76380c064ccfe038f.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0804833605816d03e57705a77f1b8aed.jpg', 'http://yanxuan.nosdn.127.net/c83a3881704094ddd3970099ca77d115.png', '199.00', '0', '1066050', '0.00', '限时购', '', '0.00', '0', '0', '0', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1064022', '1008016', '1064022', '清欢日式可调节落地灯', '0', '100', '', '便易调节，风格百搭', '<p><img src=\"http://yanxuan.nosdn.127.net/4fa5176b8bbfd702b44357c95f8a044b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fa5176b8bbfd702b44357c95f8a044b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd236663c583e2e1ae6cb94d12a8af00.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd236663c583e2e1ae6cb94d12a8af00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/494586609ad676174c98218cc96e061b.jpg\" _src=\"http://yanxuan.nosdn.127.net/494586609ad676174c98218cc96e061b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e57043896c48d2b71796d375a2b30b08.jpg\" _src=\"http://yanxuan.nosdn.127.net/e57043896c48d2b71796d375a2b30b08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f041fa43b81139eaa3034cc67e782980.jpg\" _src=\"http://yanxuan.nosdn.127.net/f041fa43b81139eaa3034cc67e782980.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/791780fa3b258fb5a9a708fb9e372ab7.jpg\" _src=\"http://yanxuan.nosdn.127.net/791780fa3b258fb5a9a708fb9e372ab7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c17e21c47b053843da3dd5a9c7c8d23.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c17e21c47b053843da3dd5a9c7c8d23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fc69c1432555238f08d0501fe0f0326.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fc69c1432555238f08d0501fe0f0326.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3c503643ce94cf565405714d7ebf1dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3c503643ce94cf565405714d7ebf1dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a4c5f3c5dcfccd2891d70c005adceb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a4c5f3c5dcfccd2891d70c005adceb3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23a01690993a30f54ce5f0e28335dfaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/23a01690993a30f54ce5f0e28335dfaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44fc7b7c874bca097c9b29c362de9195.jpg\" _src=\"http://yanxuan.nosdn.127.net/44fc7b7c874bca097c9b29c362de9195.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/036b10c6d08a1d58708e5cd0bb2adb30.jpg\" _src=\"http://yanxuan.nosdn.127.net/036b10c6d08a1d58708e5cd0bb2adb30.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4c892b7febf7cc94e335b749d3520fae.jpg', 'http://yanxuan.nosdn.127.net/a9c155e26d09e3c92b623f0472ed674a.png', '299.00', '24', '1066051', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1065004', '1011004', '1065004', '悦己日式木质落地镜', '0', '100', '', '流畅线条，日式简约', '<p><img src=\"http://yanxuan.nosdn.127.net/071505a555d7af3302888633ecf1a333.jpg\" _src=\"http://yanxuan.nosdn.127.net/071505a555d7af3302888633ecf1a333.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63af8dab1db0b12a52eb57c7cdd13907.jpg\" _src=\"http://yanxuan.nosdn.127.net/63af8dab1db0b12a52eb57c7cdd13907.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e12daa804d477c788dc3fde7cbbbcf9c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e12daa804d477c788dc3fde7cbbbcf9c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1774e70b84d5649c3f59160366a8be2.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1774e70b84d5649c3f59160366a8be2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bc88b8ff219bbbb9c314a60a539ab76.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bc88b8ff219bbbb9c314a60a539ab76.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/528a4a9baf15d763365769999e787564.jpg\" _src=\"http://yanxuan.nosdn.127.net/528a4a9baf15d763365769999e787564.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afdc632bcb0604fb9a2dc692c6834c4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/afdc632bcb0604fb9a2dc692c6834c4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38c34f66c7ec5ca66addf09ae943a613.jpg\" _src=\"http://yanxuan.nosdn.127.net/38c34f66c7ec5ca66addf09ae943a613.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/982421fefa534064491077cfb8386113.jpg\" _src=\"http://yanxuan.nosdn.127.net/982421fefa534064491077cfb8386113.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de1abde1a9677876e9c376d931ec588a.jpg\" _src=\"http://yanxuan.nosdn.127.net/de1abde1a9677876e9c376d931ec588a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/272fc358498057cdd10f8f9dd99a86bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/272fc358498057cdd10f8f9dd99a86bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e997339dee9e99bf077d51dc1a3bec44.jpg\" _src=\"http://yanxuan.nosdn.127.net/e997339dee9e99bf077d51dc1a3bec44.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a58d59b86dfcaaa50c9a09d8395ed4a0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a58d59b86dfcaaa50c9a09d8395ed4a0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2f4cb3d00ebf750197e66eee3526c11.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2f4cb3d00ebf750197e66eee3526c11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20618b212b6346536b1ee5bf41cf5dad.jpg\" _src=\"http://yanxuan.nosdn.127.net/20618b212b6346536b1ee5bf41cf5dad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7d06fa872740ca7da95fc4776dce3ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7d06fa872740ca7da95fc4776dce3ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a5f32728136b480c2c111ff1044ce83.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a5f32728136b480c2c111ff1044ce83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c13b162992646bdfa930f2700512d958.jpg\" _src=\"http://yanxuan.nosdn.127.net/c13b162992646bdfa930f2700512d958.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ed01c9ed90b3f7e612431513f0b9c208.jpg\" _src=\"http://yanxuan.nosdn.127.net/ed01c9ed90b3f7e612431513f0b9c208.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06c384ef3116265888d3603b0174f5d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/06c384ef3116265888d3603b0174f5d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c830d6d5d40ddf9781a864b4c3bec83c.jpg\" _src=\"http://yanxuan.nosdn.127.net/c830d6d5d40ddf9781a864b4c3bec83c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/05a0002f0886f4376790d00c03112ed6.jpg\" _src=\"http://yanxuan.nosdn.127.net/05a0002f0886f4376790d00c03112ed6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb2e6937b3cd8c8680f775801f7b26ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb2e6937b3cd8c8680f775801f7b26ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56debcbe3a03f1417952e4ac7c89c808.jpg\" _src=\"http://yanxuan.nosdn.127.net/56debcbe3a03f1417952e4ac7c89c808.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b356769c6bb5ddebd99edd7792c76aff.jpg\" _src=\"http://yanxuan.nosdn.127.net/b356769c6bb5ddebd99edd7792c76aff.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b539c78b905f02ef2be70518d3ac0a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b539c78b905f02ef2be70518d3ac0a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20d39e45843e2ee11507debc6ba7cd23.jpg\" _src=\"http://yanxuan.nosdn.127.net/20d39e45843e2ee11507debc6ba7cd23.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/78ca7abb8bfef0b770f012b713f2d8fc.png', 'http://yanxuan.nosdn.127.net/05977cf923857db0c44b405bd87b096b.png', '199.00', '118', '1068062', '0.00', '限时购', '', '0.00', '0', '0', '0', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1065005', '1011004', '1065005', '古风圆角木质落地镜', '0', '100', '', '简约设计，日式和风', '<p><img src=\"http://yanxuan.nosdn.127.net/ad4d677ba4fdc24389cf860f8743d9c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad4d677ba4fdc24389cf860f8743d9c0.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55efe9c6c03836106384240169988ced.jpg\" _src=\"http://yanxuan.nosdn.127.net/55efe9c6c03836106384240169988ced.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ea288c48bee26165ec87685d750021f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ea288c48bee26165ec87685d750021f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c37cd04324fd588756c967c86dd7411.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c37cd04324fd588756c967c86dd7411.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef1a1759bece97e234e6a77bae769da9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef1a1759bece97e234e6a77bae769da9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f4872bc1e867dfd402a2294c020b1ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f4872bc1e867dfd402a2294c020b1ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e079f0074555ce7277dcad6a979761b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/e079f0074555ce7277dcad6a979761b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84e158a79a9866f94a571f05db594432.jpg\" _src=\"http://yanxuan.nosdn.127.net/84e158a79a9866f94a571f05db594432.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44f454dd9f5381290758cb8206114625.jpg\" _src=\"http://yanxuan.nosdn.127.net/44f454dd9f5381290758cb8206114625.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ddaba7e0ddfc98f3c5b6a618eaa39561.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddaba7e0ddfc98f3c5b6a618eaa39561.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e38fef39f59f8c2e9fef58803927686.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e38fef39f59f8c2e9fef58803927686.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04cbc58190e01cd802d966aa784e5ba2.jpg\" _src=\"http://yanxuan.nosdn.127.net/04cbc58190e01cd802d966aa784e5ba2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0680a0d1bc619337cc71e74674bb474.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0680a0d1bc619337cc71e74674bb474.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cbaa63130f7f1f1316824ef91aec45f.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cbaa63130f7f1f1316824ef91aec45f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9f63dae4b1138ee5eedeb591055fcdc.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9f63dae4b1138ee5eedeb591055fcdc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4e03dcf4a426395943a7e426e1537cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4e03dcf4a426395943a7e426e1537cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/535b1678f1193020ebdf857cc0714605.jpg\" _src=\"http://yanxuan.nosdn.127.net/535b1678f1193020ebdf857cc0714605.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b086b038327b4f4749f01f20edc51759.jpg\" _src=\"http://yanxuan.nosdn.127.net/b086b038327b4f4749f01f20edc51759.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/600cd143741752e1ddec0726203158ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/600cd143741752e1ddec0726203158ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f92e38e1e47d83dbd687cb3a99d42cf6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f92e38e1e47d83dbd687cb3a99d42cf6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/808e61b5efb9caf9619d1ea104cd0c8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/808e61b5efb9caf9619d1ea104cd0c8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76b6a500d227dfe044e7e89d2b1fc90b.jpg\" _src=\"http://yanxuan.nosdn.127.net/76b6a500d227dfe044e7e89d2b1fc90b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b504d58141383196993a05cac20b5c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b504d58141383196993a05cac20b5c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86a53c9649767b375e7b7954b1ef8dda.jpg\" _src=\"http://yanxuan.nosdn.127.net/86a53c9649767b375e7b7954b1ef8dda.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/094601496343ee6c7bd27f889d0c671a.jpg\" _src=\"http://yanxuan.nosdn.127.net/094601496343ee6c7bd27f889d0c671a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cdfbaab3dc8a228ec830cf66c1455e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cdfbaab3dc8a228ec830cf66c1455e2.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a081b94d90c5c79f9e6c4729cf77b63.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a081b94d90c5c79f9e6c4729cf77b63.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39db72c177156f3fed68510b28d5c8dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/39db72c177156f3fed68510b28d5c8dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee0a390f0b6619aecb84518b31e4d467.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee0a390f0b6619aecb84518b31e4d467.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e54479c150ddec7a13aca5bfd0c2ae1c.jpg', 'http://yanxuan.nosdn.127.net/18b7be03bba9d01e4285fc443ea65bb1.png', '249.00', '366', '1068063', '0.00', '限时购', '', '0.00', '0', '0', '0', '273.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1068010', '1008008', '1068010', '全棉澳毛床褥床垫 床笠款', '0', '100', '', '精选优质澳毛，柔软保暖', '<p><img src=\"http://yanxuan.nosdn.127.net/95a63d6da753734c1ef2943e33a8bb3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/95a63d6da753734c1ef2943e33a8bb3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9d333d9669d0524e57d0c3df85c32c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9d333d9669d0524e57d0c3df85c32c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d07d8f04991d6277ffbe8f2e9c1f269e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d07d8f04991d6277ffbe8f2e9c1f269e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4514788afc9687cff4382d6b10b65484.jpg\" _src=\"http://yanxuan.nosdn.127.net/4514788afc9687cff4382d6b10b65484.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85004c0d8c353a371e74b12c7043b7c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/85004c0d8c353a371e74b12c7043b7c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c2f84e148ab9dc37fca2ba9b14b1d91.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c2f84e148ab9dc37fca2ba9b14b1d91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7891ebca110196561a0b89f594dcb901.jpg\" _src=\"http://yanxuan.nosdn.127.net/7891ebca110196561a0b89f594dcb901.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aab95836c91dd19b558ef7af6be87932.jpg\" _src=\"http://yanxuan.nosdn.127.net/aab95836c91dd19b558ef7af6be87932.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f95c06896c52e1818b068c6caccbd3b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/f95c06896c52e1818b068c6caccbd3b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92f0ddd32ef8721a57398dc850c69db8.jpg\" _src=\"http://yanxuan.nosdn.127.net/92f0ddd32ef8721a57398dc850c69db8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13fbf8e8abc527424bec76f5cb5d9362.jpg\" _src=\"http://yanxuan.nosdn.127.net/13fbf8e8abc527424bec76f5cb5d9362.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a96f28cfdfc2902126b6543f8a41f713.jpg\" _src=\"http://yanxuan.nosdn.127.net/a96f28cfdfc2902126b6543f8a41f713.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '21', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2669a0d813a0285158bb85444ba255fa.jpg', 'http://yanxuan.nosdn.127.net/9ed4ff9642ea9cb776a20560647cd72b.png', '329.00', '907', '1071014', '0.00', '限时购', '', '0.00', '0', '0', '0', '361.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1068011', '1008008', '1068011', '全棉丝光骆驼绒秋冬被', '0', '100', '', '精细驼绒填充，加厚温暖', '<p><img src=\"http://yanxuan.nosdn.127.net/513bb53138abc91136a185451db84124.jpg\" _src=\"http://yanxuan.nosdn.127.net/513bb53138abc91136a185451db84124.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/892c546f668cda7061312c927d6b8706.jpg\" _src=\"http://yanxuan.nosdn.127.net/892c546f668cda7061312c927d6b8706.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a47d06b195c64a165b82e797ac6d0f74.jpg\" _src=\"http://yanxuan.nosdn.127.net/a47d06b195c64a165b82e797ac6d0f74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2518d05fed8e33f2b61fd06a2711f7bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/2518d05fed8e33f2b61fd06a2711f7bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/104bfe84e2f4625c4cdf66c3e511b9cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/104bfe84e2f4625c4cdf66c3e511b9cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c69525ee67d15f619a4c33d5570e732.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c69525ee67d15f619a4c33d5570e732.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79b82500961b6385b852633961ce5c6c.jpg\" _src=\"http://yanxuan.nosdn.127.net/79b82500961b6385b852633961ce5c6c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea190f56ac369eaef45159412675bb49.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea190f56ac369eaef45159412675bb49.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae33c22489785820a608a6508dda713b.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae33c22489785820a608a6508dda713b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcd357ecf585630bf3e11364e7beef51.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcd357ecf585630bf3e11364e7beef51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c77e5ed4dbd4ca1834cc1d65fb6fb978.jpg\" _src=\"http://yanxuan.nosdn.127.net/c77e5ed4dbd4ca1834cc1d65fb6fb978.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '18', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0c512323f69705f49147bf9bc4409386.jpg', 'http://yanxuan.nosdn.127.net/0e4ba6ed44fef8803c243e585b621ab7.png', '399.00', '941', '1071016', '0.00', '限时购', '', '0.00', '0', '0', '0', '438.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1068012', '1036000', '1068012', '全棉色织绗缝夏凉件套', '1001020', '100', '', '夏季凉被，冬季暖套，四季可用', '<p><img src=\"http://yanxuan.nosdn.127.net/f2c8da50d92baec4dd3cf9efd031c609.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2c8da50d92baec4dd3cf9efd031c609.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c942345abc7f4ccb968922399bf7f9d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/c942345abc7f4ccb968922399bf7f9d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9356de74f5f05ffa1f2193eea6c5bdc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/9356de74f5f05ffa1f2193eea6c5bdc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a665cfb96c9941e5b8dff8d90853bc5.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a665cfb96c9941e5b8dff8d90853bc5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a046b731093bec9b8959e2474cfa4a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a046b731093bec9b8959e2474cfa4a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/559719ac8d4e3f71905299b9177a4ce0.jpg\" _src=\"http://yanxuan.nosdn.127.net/559719ac8d4e3f71905299b9177a4ce0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df69b9248e172d145a2a19344e42cc95.jpg\" _src=\"http://yanxuan.nosdn.127.net/df69b9248e172d145a2a19344e42cc95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa820a8ae627c519739d3ce12c2c6518.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa820a8ae627c519739d3ce12c2c6518.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd486a7f6146271c0541539be673f58c.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd486a7f6146271c0541539be673f58c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee9211f783669f8b81b268e1a63752cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee9211f783669f8b81b268e1a63752cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/35e57db1fd86be37d669d355061fd6b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/35e57db1fd86be37d669d355061fd6b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/921d514a1b6e33f4a2f5799f2dbc9a0f.jpg\" _src=\"http://yanxuan.nosdn.127.net/921d514a1b6e33f4a2f5799f2dbc9a0f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9dd1dae09dbade1b4128648cc34b1bc4.jpg\" _src=\"http://yanxuan.nosdn.127.net/9dd1dae09dbade1b4128648cc34b1bc4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fdb3e737194ddf41c6d807f072a3da9.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fdb3e737194ddf41c6d807f072a3da9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e69d648b43e8a251ece334534302e368.jpg\" _src=\"http://yanxuan.nosdn.127.net/e69d648b43e8a251ece334534302e368.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c105ac189899e85677e746af9cf14b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c105ac189899e85677e746af9cf14b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3dfe534d6109aeb1d6efec2c69064654.jpg\" _src=\"http://yanxuan.nosdn.127.net/3dfe534d6109aeb1d6efec2c69064654.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e38db6341ce3864d00b67ed920deee3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e38db6341ce3864d00b67ed920deee3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d6fd87dd1e350771e0414eef4a00f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d6fd87dd1e350771e0414eef4a00f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18d8a013e03ad654f2e4f8817801168c.jpg\" _src=\"http://yanxuan.nosdn.127.net/18d8a013e03ad654f2e4f8817801168c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4891ddcdde1628465490e970fb0cdd4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4891ddcdde1628465490e970fb0cdd4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5fa31df63a81e665df490c9d7f42a98.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5fa31df63a81e665df490c9d7f42a98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd10bc9fdd09b964ef38e6e6ab481805.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd10bc9fdd09b964ef38e6e6ab481805.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/598ada2dd1db82e54bcbda20d493f471.jpg\" _src=\"http://yanxuan.nosdn.127.net/598ada2dd1db82e54bcbda20d493f471.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbb8921d833c3dcb89962f8d3f77d254.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbb8921d833c3dcb89962f8d3f77d254.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1bd69c32e8228bfcc72ea580e530b66.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1bd69c32e8228bfcc72ea580e530b66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6259e545bc7631c00391156e2f66f690.jpg\" _src=\"http://yanxuan.nosdn.127.net/6259e545bc7631c00391156e2f66f690.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d8b5c26dd3141e4c2939cade0eb3f25.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d8b5c26dd3141e4c2939cade0eb3f25.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8892a18d128d00d19daf3a0c5f7601c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8892a18d128d00d19daf3a0c5f7601c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c513d36bd6f8be0b44ffd321d821419.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c513d36bd6f8be0b44ffd321d821419.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/547fa7c92b2a1beb018c6326630f0d52.jpg\" _src=\"http://yanxuan.nosdn.127.net/547fa7c92b2a1beb018c6326630f0d52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d755722133aea49aa0ff53a345977b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d755722133aea49aa0ff53a345977b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7ce2a9b6b8a5ade671bb0f1c0c14b6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7ce2a9b6b8a5ade671bb0f1c0c14b6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd6d960441bd4bd208cca0e0d85e98b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd6d960441bd4bd208cca0e0d85e98b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98eea2b147f2a6db9c409aa004ef6d1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/98eea2b147f2a6db9c409aa004ef6d1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d95786dc2a8ea1bf0f2974c536c96ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d95786dc2a8ea1bf0f2974c536c96ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db9ebe54b716d0e728e76d9cfe578638.jpg\" _src=\"http://yanxuan.nosdn.127.net/db9ebe54b716d0e728e76d9cfe578638.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4884a54269e320eb5eaeb281ce44972a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4884a54269e320eb5eaeb281ce44972a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f7039e7cc12f77edbc0c05a4b5cabe0.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f7039e7cc12f77edbc0c05a4b5cabe0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78218e4c3089b11eaf51dcb128f9458a.jpg\" _src=\"http://yanxuan.nosdn.127.net/78218e4c3089b11eaf51dcb128f9458a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25ac7c99eb8032df971d5c59c5b7c5d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/25ac7c99eb8032df971d5c59c5b7c5d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2322fcab99f29c5e3041fb03608c5af9.jpg\" _src=\"http://yanxuan.nosdn.127.net/2322fcab99f29c5e3041fb03608c5af9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49fbd5127b6c785cab0a7b0511d010fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/49fbd5127b6c785cab0a7b0511d010fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/337ac8db46d718d2e76217aeab913757.jpg\" _src=\"http://yanxuan.nosdn.127.net/337ac8db46d718d2e76217aeab913757.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9fa6cd8ddc515ed4bbf2428b326df941.jpg\" _src=\"http://yanxuan.nosdn.127.net/9fa6cd8ddc515ed4bbf2428b326df941.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/bd08afcc8efb69545a10028a132658c5.jpg', 'http://yanxuan.nosdn.127.net/69145abddddd31ae8878ea7ca7297b4b.png', '599.00', '4274', '1071018', '0.00', '限时购', '', '0.00', '0', '0', '1', '658.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1070000', '1008015', '1070000', '星云酥 180克/3颗', '0', '100', '', '酥饼界的小仙女', '', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/fec3fedc5dc8eb4c0f9ad8035061cebe.jpg', 'http://yanxuan.nosdn.127.net/8392725765cdd57fdae3f173877f4bda.png', '26.00', '867', '1124049', '0.00', '限时购', '', '0.00', '0', '0', '0', '28.60', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1071004', '1017000', '1071004', '日式圆形宠物盆猫砂盆', '0', '100', '', '日式配色，圆滑细腻', '<p><img src=\"http://yanxuan.nosdn.127.net/8fcac09d7577060c0a512ea6739c97ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fcac09d7577060c0a512ea6739c97ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b69b19b139cd26bf6dab5d5a648937b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b69b19b139cd26bf6dab5d5a648937b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/272be92e722c0336aa8ea5dfea9c8160.jpg\" _src=\"http://yanxuan.nosdn.127.net/272be92e722c0336aa8ea5dfea9c8160.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0585ea90000fff3a6cd8ef3d0f311e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0585ea90000fff3a6cd8ef3d0f311e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0e6f8bff79c8fb501ad2e27e578e62d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0e6f8bff79c8fb501ad2e27e578e62d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2447c2a4d60144b25e9f103175531ac7.jpg\" _src=\"http://yanxuan.nosdn.127.net/2447c2a4d60144b25e9f103175531ac7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8557a4772478e932fcc516df28ff8b26.jpg\" _src=\"http://yanxuan.nosdn.127.net/8557a4772478e932fcc516df28ff8b26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5bcebc60f77b9dc0ec98beef7685710e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5bcebc60f77b9dc0ec98beef7685710e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a125c5c2835777fb86e806b4f91c95a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a125c5c2835777fb86e806b4f91c95a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71cd7a9c5ff13033878477c72bd8bcf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/71cd7a9c5ff13033878477c72bd8bcf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cd3a745cafb0ade80fef30282f33c39.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cd3a745cafb0ade80fef30282f33c39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d604b2a4e400c5de3ae6d8fac2b0a89.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d604b2a4e400c5de3ae6d8fac2b0a89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2a0a3a2c8e45bba29aa51b7b5f08308.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2a0a3a2c8e45bba29aa51b7b5f08308.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a65be28f7c1b9e4a1043cac8a415089.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a65be28f7c1b9e4a1043cac8a415089.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7bde1458f209cd046378455838c6c89c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7bde1458f209cd046378455838c6c89c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7a561a6b7461d45ffc6ed90e7f48c9a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7a561a6b7461d45ffc6ed90e7f48c9a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6c2b53acdb9e4a8bc95609bf97f4513.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6c2b53acdb9e4a8bc95609bf97f4513.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ececb765899660140651e29ab4526eca.jpg\" _src=\"http://yanxuan.nosdn.127.net/ececb765899660140651e29ab4526eca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83ad2165ee9891683052f26c928068b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/83ad2165ee9891683052f26c928068b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/786bdedae9e0d2d7ab4de3697d3642b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/786bdedae9e0d2d7ab4de3697d3642b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33eeab8794cadfb86498a366b56d8b57.jpg\" _src=\"http://yanxuan.nosdn.127.net/33eeab8794cadfb86498a366b56d8b57.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b4b835a0268eed92c845b851be3be71.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b4b835a0268eed92c845b851be3be71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dde1d2f1d7d8a19f162fcd7f0535a7dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/dde1d2f1d7d8a19f162fcd7f0535a7dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/885792079ae57ba6de8507fab565c586.jpg\" _src=\"http://yanxuan.nosdn.127.net/885792079ae57ba6de8507fab565c586.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9110f49c6a9f29f0b03855582af0d88.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9110f49c6a9f29f0b03855582af0d88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7fee119279d42ba0fb697cf9e8f53d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7fee119279d42ba0fb697cf9e8f53d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b44824d6ab6387b9cc37f9d6aecb9d43.jpg\" _src=\"http://yanxuan.nosdn.127.net/b44824d6ab6387b9cc37f9d6aecb9d43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34620b3bf872306803dfe9560acdcff4.jpg\" _src=\"http://yanxuan.nosdn.127.net/34620b3bf872306803dfe9560acdcff4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2c60c4177b50725cd3d2a11eb54714b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2c60c4177b50725cd3d2a11eb54714b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f74507842ac9dd42103de38cc878a34.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f74507842ac9dd42103de38cc878a34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63c1f83a1a5d1ba546ac7d875dabfeed.jpg\" _src=\"http://yanxuan.nosdn.127.net/63c1f83a1a5d1ba546ac7d875dabfeed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/acc33719f9810f8a69be93903a0b64f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/acc33719f9810f8a69be93903a0b64f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/108405824c2b2590655f75638dd41c06.jpg\" _src=\"http://yanxuan.nosdn.127.net/108405824c2b2590655f75638dd41c06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd1a84cf1e70f02541dfd546bdb0d563.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd1a84cf1e70f02541dfd546bdb0d563.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/901ab7dcd0a1e5c4339dbadf93889233.jpg\" _src=\"http://yanxuan.nosdn.127.net/901ab7dcd0a1e5c4339dbadf93889233.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb98fc4e92fb69f27eb95a13c267e165.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb98fc4e92fb69f27eb95a13c267e165.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50e017498ac9caf6a0679dd26bbec392.jpg\" _src=\"http://yanxuan.nosdn.127.net/50e017498ac9caf6a0679dd26bbec392.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79469391cecf19b30111fa4385e89d6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/79469391cecf19b30111fa4385e89d6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef40b078efaa06acd1487f07b7dfb213.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef40b078efaa06acd1487f07b7dfb213.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f42673dcf2d61d5c695ffb7705c53f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f42673dcf2d61d5c695ffb7705c53f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0aecfd282d652b7451143ae42aa0f3bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/0aecfd282d652b7451143ae42aa0f3bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c80632b60bb7191671adb473e04111c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c80632b60bb7191671adb473e04111c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2414ed9c34593c5a12f57d73099795b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2414ed9c34593c5a12f57d73099795b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1e849da7d5e442717c2ceb64e8de762.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1e849da7d5e442717c2ceb64e8de762.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32ab9b54417e5f571aad635625a1fd97.jpg\" _src=\"http://yanxuan.nosdn.127.net/32ab9b54417e5f571aad635625a1fd97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f06afbd180cd2eb34e181df8bbba5098.jpg\" _src=\"http://yanxuan.nosdn.127.net/f06afbd180cd2eb34e181df8bbba5098.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ffce5e44238942d4cfcb2300376cbda.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ffce5e44238942d4cfcb2300376cbda.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6014bf19a6d49285681a1c05250709f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/6014bf19a6d49285681a1c05250709f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3a51faae51f1a03cc44f36b1850037c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3a51faae51f1a03cc44f36b1850037c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/846b1d0320958c8b5451f3b217e7e8f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/846b1d0320958c8b5451f3b217e7e8f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99789d189daa1e63f292ca9d8d950c03.jpg\" _src=\"http://yanxuan.nosdn.127.net/99789d189daa1e63f292ca9d8d950c03.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29a06ebfaaded39141e85496b5e3af84.jpg\" _src=\"http://yanxuan.nosdn.127.net/29a06ebfaaded39141e85496b5e3af84.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15c8def8966137bc5708a4591ec1eff8.jpg\" _src=\"http://yanxuan.nosdn.127.net/15c8def8966137bc5708a4591ec1eff8.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '20', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/05737b5ef321e0780399925caf602403.jpg', 'http://yanxuan.nosdn.127.net/f0abf2bf11c8d303212e4a0c1106bb73.png', '89.00', '248', '1075042', '0.00', '限时购', '', '0.00', '0', '0', '0', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1071005', '1017000', '1071005', '便携多功能宠物拾便器', '0', '100', '', '方便携带，环保卫生', '<p><img src=\"http://yanxuan.nosdn.127.net/0439a458150f17b3c54e1898b4ddf71f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0439a458150f17b3c54e1898b4ddf71f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/759a3d2dc0fea138932feb0b03def7ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/759a3d2dc0fea138932feb0b03def7ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fbc1e3aaaec589986fe8c460006b408.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fbc1e3aaaec589986fe8c460006b408.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29ff62dcfcc7df4e69bdbfb6830d3729.jpg\" _src=\"http://yanxuan.nosdn.127.net/29ff62dcfcc7df4e69bdbfb6830d3729.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8413e338d3d16087645d817aac894bc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/8413e338d3d16087645d817aac894bc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8746c36ec37fe13c0124c13162a903cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/8746c36ec37fe13c0124c13162a903cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ba42ac14b311acbcc1b1ab3f9c0c239.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ba42ac14b311acbcc1b1ab3f9c0c239.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/381576780a6acb18d4b9720caff81d51.jpg\" _src=\"http://yanxuan.nosdn.127.net/381576780a6acb18d4b9720caff81d51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec97befffd24b79f095b698d5da500bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec97befffd24b79f095b698d5da500bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a95dcc67a1ddd5c653aa38d085ca289.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a95dcc67a1ddd5c653aa38d085ca289.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/148b5c0861ce138fed9ce344be4f3735.jpg\" _src=\"http://yanxuan.nosdn.127.net/148b5c0861ce138fed9ce344be4f3735.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/853b3e416ac990886f252b492a18d765.jpg\" _src=\"http://yanxuan.nosdn.127.net/853b3e416ac990886f252b492a18d765.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc62219c8eded9aa632bf130fd816844.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc62219c8eded9aa632bf130fd816844.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad28c490b2c43b7ca1d9da3fc3631465.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad28c490b2c43b7ca1d9da3fc3631465.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d371fd88d9312493cfd3be36a322d92b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d371fd88d9312493cfd3be36a322d92b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f40e9c97a58c8c93335e5374b6e6d70c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f40e9c97a58c8c93335e5374b6e6d70c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74092ef98970e14ad640949e923a40e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/74092ef98970e14ad640949e923a40e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea98fada7b079deb466e5a787d241dae.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea98fada7b079deb466e5a787d241dae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f69dd49e4d45cc27ccc9e5a6e765fbfd.jpg\" _src=\"http://yanxuan.nosdn.127.net/f69dd49e4d45cc27ccc9e5a6e765fbfd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77137b44be1a680cae7b1c25e37e386d.jpg\" _src=\"http://yanxuan.nosdn.127.net/77137b44be1a680cae7b1c25e37e386d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce607d0b53a481683a78520c8ab6ccae.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce607d0b53a481683a78520c8ab6ccae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/011c0ff03dc6d9c4abbfb717d1757bf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/011c0ff03dc6d9c4abbfb717d1757bf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2290de54b4dfca00cb57fc879b5bbbab.jpg\" _src=\"http://yanxuan.nosdn.127.net/2290de54b4dfca00cb57fc879b5bbbab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c08cc448c81b6256db91211579dfb738.jpg\" _src=\"http://yanxuan.nosdn.127.net/c08cc448c81b6256db91211579dfb738.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ede1bd346840f490cadbb4e2091e236.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ede1bd346840f490cadbb4e2091e236.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0243642fd350cb2b7873817f052c37e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/0243642fd350cb2b7873817f052c37e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a4acab695c5596de04e3642ac2bd711.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a4acab695c5596de04e3642ac2bd711.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd5e8c7e865dcf50b662c6f2224deb05.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd5e8c7e865dcf50b662c6f2224deb05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b132996c99b3a02443692ececf52f5fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/b132996c99b3a02443692ececf52f5fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/175b24fab11d1f543e10ccc2f2ac4eb6.jpg\" _src=\"http://yanxuan.nosdn.127.net/175b24fab11d1f543e10ccc2f2ac4eb6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0a51eb838b01dac5bec6057e1e59428.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0a51eb838b01dac5bec6057e1e59428.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cda60b57d1f0e78cd3921bc4e3d8ccf2.jpg\" _src=\"http://yanxuan.nosdn.127.net/cda60b57d1f0e78cd3921bc4e3d8ccf2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1437057917d6deb2e453e711bcbf40ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/1437057917d6deb2e453e711bcbf40ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/121b6dc31268b1a82c632fcb634f9a64.jpg\" _src=\"http://yanxuan.nosdn.127.net/121b6dc31268b1a82c632fcb634f9a64.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0923c11aec66cec291f8a142b8391e01.jpg\" _src=\"http://yanxuan.nosdn.127.net/0923c11aec66cec291f8a142b8391e01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/736a20d6584ffaacc39bd62c700b68ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/736a20d6584ffaacc39bd62c700b68ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7643379507709dba5947571eb18fc7b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/7643379507709dba5947571eb18fc7b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0217adfd4f3a62963f18f841fa945e5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0217adfd4f3a62963f18f841fa945e5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4055e755e250b2c84a0548e031de7f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4055e755e250b2c84a0548e031de7f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f3c65c42ffac403bf55ff33454849f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f3c65c42ffac403bf55ff33454849f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/349b23e34055e38d2311b82cc42b9402.jpg\" _src=\"http://yanxuan.nosdn.127.net/349b23e34055e38d2311b82cc42b9402.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f9a830bb03074182f19931ec6aaf1c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f9a830bb03074182f19931ec6aaf1c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32bc1a4cb7aa944ac67856fcb6e5c73f.jpg\" _src=\"http://yanxuan.nosdn.127.net/32bc1a4cb7aa944ac67856fcb6e5c73f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/381b80fabf330062ab9ffcde4ea025be.jpg\" _src=\"http://yanxuan.nosdn.127.net/381b80fabf330062ab9ffcde4ea025be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f987d33585b22286115fbb684edbbf7.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f987d33585b22286115fbb684edbbf7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89e8c521f234dfb1c0217e553826b4f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/89e8c521f234dfb1c0217e553826b4f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de5822513f7a21e52a23e65709311072.jpg\" _src=\"http://yanxuan.nosdn.127.net/de5822513f7a21e52a23e65709311072.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4437746b0494178f77250f55937d7080.jpg\" _src=\"http://yanxuan.nosdn.127.net/4437746b0494178f77250f55937d7080.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b46621bf43e028b86ae69fb68019318b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b46621bf43e028b86ae69fb68019318b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/208bf739edd3b19c8fba3f2cb47792f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/208bf739edd3b19c8fba3f2cb47792f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e63ee61d221db9cbe9978da2394ee2b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/e63ee61d221db9cbe9978da2394ee2b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3719e6b0d3e8cd37b9c9e3f7c84fbc2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/3719e6b0d3e8cd37b9c9e3f7c84fbc2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e5613aef6325482b310cb2bbe4a23e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e5613aef6325482b310cb2bbe4a23e8.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '17', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/688d686641616760abcfeca0841b81af.jpg', 'http://yanxuan.nosdn.127.net/07a47d73e2eb53b1a7939219a4e63618.png', '39.00', '468', '1075044', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1071006', '1017000', '1071006', '清新宠物水食钵食盆', '0', '100', '', '含银离子的洁净除菌食盆', '<p><img src=\"http://yanxuan.nosdn.127.net/f6211683724401e87e2458378137f31b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6211683724401e87e2458378137f31b.jpg\"/></p>', '1', '2017-08-30 11:40:11', '16', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ada10ec7003741d17e3ea43dff2c073d.jpg', 'http://yanxuan.nosdn.127.net/d206e0d15955b4d76431a752f2c94f9f.png', '9.90', '7021', '1075047', '0.00', '限时购', '', '0.00', '0', '0', '0', '10.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1072000', '1008002', '1072000', '手工针织绞花抱枕套', '1001020', '100', '', '纯手工针织，带给你复古的暖', '<p><img src=\"http://yanxuan.nosdn.127.net/74ead5d764e22f8d50dc44a7a61da41a.jpg\" _src=\"http://yanxuan.nosdn.127.net/74ead5d764e22f8d50dc44a7a61da41a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be7f775d658e40e6ca76e657006053a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/be7f775d658e40e6ca76e657006053a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fe9345385034a4d25580072444b349b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fe9345385034a4d25580072444b349b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bffafbafcf3010c3e5ab454af09cde4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/bffafbafcf3010c3e5ab454af09cde4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/123a0dcb707c2a178e5f9da395b5b24e.jpg\" _src=\"http://yanxuan.nosdn.127.net/123a0dcb707c2a178e5f9da395b5b24e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfeba71e7e71a63dee06b079b4c4c4f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfeba71e7e71a63dee06b079b4c4c4f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdc034602358c7752073a9b4bd6b499f.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdc034602358c7752073a9b4bd6b499f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3050a816fd41ec2b8880d11aafc26177.jpg\" _src=\"http://yanxuan.nosdn.127.net/3050a816fd41ec2b8880d11aafc26177.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/027e8c218edbbf1779cf4b380b2133c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/027e8c218edbbf1779cf4b380b2133c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbd1f6dd39bd517c99c7ae07d9b32b0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbd1f6dd39bd517c99c7ae07d9b32b0e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db5baa7586787b7e0f27a5b7a09946a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/db5baa7586787b7e0f27a5b7a09946a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66a0ff102559b2d840240d6fa8c37001.jpg\" _src=\"http://yanxuan.nosdn.127.net/66a0ff102559b2d840240d6fa8c37001.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b17b0772d947612819e4489d9e5a865.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b17b0772d947612819e4489d9e5a865.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53cc65ea58a7757fca2585b25056cf21.jpg\" _src=\"http://yanxuan.nosdn.127.net/53cc65ea58a7757fca2585b25056cf21.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86506725ae85f9864c8b70b64b2e37d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/86506725ae85f9864c8b70b64b2e37d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/671d390a50d363d6ae6ab0c52f06a284.jpg\" _src=\"http://yanxuan.nosdn.127.net/671d390a50d363d6ae6ab0c52f06a284.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14e864b84a51faebab51912bbfea7b75.jpg\" _src=\"http://yanxuan.nosdn.127.net/14e864b84a51faebab51912bbfea7b75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e31d1086f08b77298977c2b459be4833.jpg\" _src=\"http://yanxuan.nosdn.127.net/e31d1086f08b77298977c2b459be4833.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02338b650755a458ca8561f484e618d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/02338b650755a458ca8561f484e618d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ffbeafbda15fcfcf98c3b7a62c77e05.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ffbeafbda15fcfcf98c3b7a62c77e05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f61f5e704ccf72bfb570842a366f104.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f61f5e704ccf72bfb570842a366f104.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e119daabcfd640441083e17445834954.jpg\" _src=\"http://yanxuan.nosdn.127.net/e119daabcfd640441083e17445834954.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/010ba3b486af23613c04046c5829a7c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/010ba3b486af23613c04046c5829a7c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25f470d4479fbb74f9b6e105f8dedfbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/25f470d4479fbb74f9b6e105f8dedfbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e7c300089dba380e9f48d49ec964ff9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e7c300089dba380e9f48d49ec964ff9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a7ab3c980cf291404489bd137efde6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a7ab3c980cf291404489bd137efde6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fb08e93fa462fca26680a56737b9f91.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fb08e93fa462fca26680a56737b9f91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0ad6f5f75871fa02408723457a8a8ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0ad6f5f75871fa02408723457a8a8ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3cecb48c44520393993ce5bc85da7ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3cecb48c44520393993ce5bc85da7ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd68c353ca83624fa367f90592649b36.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd68c353ca83624fa367f90592649b36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9327cc921602b9d5b05147e4266910cb.jpg\" _src=\"http://yanxuan.nosdn.127.net/9327cc921602b9d5b05147e4266910cb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37cf3aa662187aa1126a5c41cb41d796.jpg\" _src=\"http://yanxuan.nosdn.127.net/37cf3aa662187aa1126a5c41cb41d796.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bef5ea165cda6dbbb109ea895b3f2fc5.jpg\" _src=\"http://yanxuan.nosdn.127.net/bef5ea165cda6dbbb109ea895b3f2fc5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78c0d06130500a1247cb2a602264c61c.jpg\" _src=\"http://yanxuan.nosdn.127.net/78c0d06130500a1247cb2a602264c61c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79fd1cbd0c0d02ac58c2f449dcb6c97f.jpg\" _src=\"http://yanxuan.nosdn.127.net/79fd1cbd0c0d02ac58c2f449dcb6c97f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61acb2d95e1833aad988c183c94eebe2.jpg\" _src=\"http://yanxuan.nosdn.127.net/61acb2d95e1833aad988c183c94eebe2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7828935cd158c7bb6643186eb25be8bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/7828935cd158c7bb6643186eb25be8bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0409cef7649088f345fc64a348b49468.jpg\" _src=\"http://yanxuan.nosdn.127.net/0409cef7649088f345fc64a348b49468.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54e1beab4c0616b3147270201f978f2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/54e1beab4c0616b3147270201f978f2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a75d34f45de74f2476f34ce329d57ff6.jpg\" _src=\"http://yanxuan.nosdn.127.net/a75d34f45de74f2476f34ce329d57ff6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81607103dfd183acf7a364dd58e3cf93.jpg\" _src=\"http://yanxuan.nosdn.127.net/81607103dfd183acf7a364dd58e3cf93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03cf20624d36fc793143ba7ba8b5c17f.jpg\" _src=\"http://yanxuan.nosdn.127.net/03cf20624d36fc793143ba7ba8b5c17f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da92a3b8729effd6f79e9c86b522f6ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/da92a3b8729effd6f79e9c86b522f6ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71aa5c2a762f4bced311f40323980552.jpg\" _src=\"http://yanxuan.nosdn.127.net/71aa5c2a762f4bced311f40323980552.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b81f52020b75b35b2254d327625713d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/b81f52020b75b35b2254d327625713d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f4d245eea01d80ce6769f308ccd7152.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f4d245eea01d80ce6769f308ccd7152.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c74f125472bf12a5b0ece0aaf15ef85.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c74f125472bf12a5b0ece0aaf15ef85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6139fdd3fb21d66c527520a747a17fe3.jpg\" _src=\"http://yanxuan.nosdn.127.net/6139fdd3fb21d66c527520a747a17fe3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/09883bdbd9eec88ed615b99a275c0d54.jpg', 'http://yanxuan.nosdn.127.net/87cf3a17ad40bfdcdc3314ea4591a5e8.png', '89.00', '305', '1076004', '0.00', '限时购', '', '0.00', '0', '0', '0', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1072001', '1008002', '1072001', '色织水洗棉绣花抱枕套', '1001020', '100', '', '清素色织，搭配水洗棉旧色的温柔', '<p><img src=\"http://yanxuan.nosdn.127.net/f8a74bd8e87987849bf2505c08ac69e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8a74bd8e87987849bf2505c08ac69e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be7ae107fc4b5085241507ed711254f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/be7ae107fc4b5085241507ed711254f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/143c402e82c2d99c3bc7cc51d064a62b.jpg\" _src=\"http://yanxuan.nosdn.127.net/143c402e82c2d99c3bc7cc51d064a62b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52f5b211f5da083da2bc9b5237c40b3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/52f5b211f5da083da2bc9b5237c40b3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5af00c6f7dc0d798dffe2cdc2da0f870.jpg\" _src=\"http://yanxuan.nosdn.127.net/5af00c6f7dc0d798dffe2cdc2da0f870.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/750bbc1c2207159b58a6de350060f5c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/750bbc1c2207159b58a6de350060f5c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d55dd54de50ff03b199261f3e021f388.jpg\" _src=\"http://yanxuan.nosdn.127.net/d55dd54de50ff03b199261f3e021f388.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b659703ddf8e35bb89ee5ff36e84b4f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/b659703ddf8e35bb89ee5ff36e84b4f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/573f30d45c3eea65f29a6497ac2b9a98.jpg\" _src=\"http://yanxuan.nosdn.127.net/573f30d45c3eea65f29a6497ac2b9a98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7d58eb147f2d8bedfc88ba08b544d7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7d58eb147f2d8bedfc88ba08b544d7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec89200168dd4a703f7b89ec2be0b8a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec89200168dd4a703f7b89ec2be0b8a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d123c7d7b79ef8cd2703976e8bf1dbc.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d123c7d7b79ef8cd2703976e8bf1dbc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2797ba305c10b0e5fd6eafb384101402.jpg\" _src=\"http://yanxuan.nosdn.127.net/2797ba305c10b0e5fd6eafb384101402.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abcfbdafabe855e77598860b426fa5e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/abcfbdafabe855e77598860b426fa5e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d6ff672dae187d85d199ee1b1b62f9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d6ff672dae187d85d199ee1b1b62f9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e4424539e51dca9d000c6b67bea1f8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e4424539e51dca9d000c6b67bea1f8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/942da4a7c05d2a25be7a26decc40f53a.jpg\" _src=\"http://yanxuan.nosdn.127.net/942da4a7c05d2a25be7a26decc40f53a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c872c106b7da7d7b1167a9554c92aa1.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c872c106b7da7d7b1167a9554c92aa1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82607c78aedacd534a2e0f1b38e2e3e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/82607c78aedacd534a2e0f1b38e2e3e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07e4e5ac1501706c8666eff4a703b5fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/07e4e5ac1501706c8666eff4a703b5fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a56805f63dfe98583e6b58eaa9dd595a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a56805f63dfe98583e6b58eaa9dd595a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ecdd28de374db2de0c0c2f0f50d0cd26.jpg\" _src=\"http://yanxuan.nosdn.127.net/ecdd28de374db2de0c0c2f0f50d0cd26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69fcb2566dea15f16a182b7e4e05893f.jpg\" _src=\"http://yanxuan.nosdn.127.net/69fcb2566dea15f16a182b7e4e05893f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc3c5b3a6a14c8307e57842bf737601b.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc3c5b3a6a14c8307e57842bf737601b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53d9c980cc924790bd7983bd80b0221a.jpg\" _src=\"http://yanxuan.nosdn.127.net/53d9c980cc924790bd7983bd80b0221a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/787bdee826a5112c3e2bd4b9c15717e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/787bdee826a5112c3e2bd4b9c15717e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44dc985f99b3a95f255624a4d97857ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/44dc985f99b3a95f255624a4d97857ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf117d9aef1ef7ab10d2ef040d9444c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf117d9aef1ef7ab10d2ef040d9444c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07044f1a6c11d8d15e410a01482fb39a.jpg\" _src=\"http://yanxuan.nosdn.127.net/07044f1a6c11d8d15e410a01482fb39a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ca8ea48405cb43c901181a684c623dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ca8ea48405cb43c901181a684c623dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b4111628661d4216c8d0fc057e6d81e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b4111628661d4216c8d0fc057e6d81e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4adb10168dbfcee6f49460b2478de249.jpg\" _src=\"http://yanxuan.nosdn.127.net/4adb10168dbfcee6f49460b2478de249.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e798dd4abe3a833a4d0066453955ec1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e798dd4abe3a833a4d0066453955ec1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/528abeae19cf1b5af2f49be4e142a2da.jpg\" _src=\"http://yanxuan.nosdn.127.net/528abeae19cf1b5af2f49be4e142a2da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2d3d5ae118bcacdfda08eb182a03c15a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2d3d5ae118bcacdfda08eb182a03c15a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3323a393743f839e12586418a0711123.jpg\" _src=\"http://yanxuan.nosdn.127.net/3323a393743f839e12586418a0711123.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ac29c5a1569d9fb37420f2eae835b91.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ac29c5a1569d9fb37420f2eae835b91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89ef4f7ec1c86f13d328c23c0429892a.jpg\" _src=\"http://yanxuan.nosdn.127.net/89ef4f7ec1c86f13d328c23c0429892a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b005b97dbffa333e49ff484abbcff04.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b005b97dbffa333e49ff484abbcff04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afa56b9370cdc27f27f8f951108cea4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/afa56b9370cdc27f27f8f951108cea4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5daae71eb699e7417e695472e1142678.jpg\" _src=\"http://yanxuan.nosdn.127.net/5daae71eb699e7417e695472e1142678.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3dbb71ba9fff82849a959deb8f5b7946.jpg\" _src=\"http://yanxuan.nosdn.127.net/3dbb71ba9fff82849a959deb8f5b7946.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e024ba974bad906db9e2a28d42293a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e024ba974bad906db9e2a28d42293a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87e2d46daab9e1dd3e112c15692c66ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/87e2d46daab9e1dd3e112c15692c66ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/342bc9bb1cbf81d1bc7b33f77fa915ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/342bc9bb1cbf81d1bc7b33f77fa915ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f54d685cb3c111beff7ef58bb16252d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f54d685cb3c111beff7ef58bb16252d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7c4c896daa0ac2ff5f89d5b738fc007.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7c4c896daa0ac2ff5f89d5b738fc007.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/839da4fb5874271d54f94c60ad4d7387.jpg\" _src=\"http://yanxuan.nosdn.127.net/839da4fb5874271d54f94c60ad4d7387.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7147d5acd91c330479762e51cf4257f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7147d5acd91c330479762e51cf4257f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a9ca13fd9189e60df2f4a21783a3795.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a9ca13fd9189e60df2f4a21783a3795.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09fa8e6e95cc716138549e6b244a7924.jpg\" _src=\"http://yanxuan.nosdn.127.net/09fa8e6e95cc716138549e6b244a7924.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/772e18352ad2c156ee190f068726cd8c.jpg\" _src=\"http://yanxuan.nosdn.127.net/772e18352ad2c156ee190f068726cd8c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92c0a1e57d429d19fb7f4e678fa7fae1.jpg\" _src=\"http://yanxuan.nosdn.127.net/92c0a1e57d429d19fb7f4e678fa7fae1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88ddae38e8b363acdf79bfbe0547cc50.jpg\" _src=\"http://yanxuan.nosdn.127.net/88ddae38e8b363acdf79bfbe0547cc50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c4c683112a57543d4e028754be53e0d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c4c683112a57543d4e028754be53e0d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f476dbaf8a8cae1e8a311edb77d4ea78.jpg\" _src=\"http://yanxuan.nosdn.127.net/f476dbaf8a8cae1e8a311edb77d4ea78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7493e6d2980dc116654bdb3b24c1a3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7493e6d2980dc116654bdb3b24c1a3d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57e84b0e4b979782b0c3a4bce908d797.jpg\" _src=\"http://yanxuan.nosdn.127.net/57e84b0e4b979782b0c3a4bce908d797.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8eb47f38c324fd320c74bf0aa3ebdf1.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8eb47f38c324fd320c74bf0aa3ebdf1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/622949bf7e667ea54eaf0861ac31c842.jpg\" _src=\"http://yanxuan.nosdn.127.net/622949bf7e667ea54eaf0861ac31c842.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a45cf27cc07e678cfe21257cb764711a.jpg', 'http://yanxuan.nosdn.127.net/0e9d5954d7dc2477d9c46b730e05ab42.png', '49.00', '121', '1076007', '0.00', '限时购', '', '0.00', '0', '0', '0', '53.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1073008', '1005007', '1073008', '铸铁珐琅牛排煎锅', '0', '100', '', '沥油隔水，煎出外焦里嫩', '', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/61a56890eada2439eb4ff0a613cf8347.jpg', 'http://yanxuan.nosdn.127.net/619e46411ccd62e5c0f16692ee1a85a0.png', '149.00', '2191', '1077044', '0.00', '限时购', '', '0.00', '0', '0', '0', '163.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1074001', '1010002', '1074001', '男式莫代尔无痕内裤', '0', '100', '', 'Bemis技术，极简无痕', '', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f8529d85ca41fa84abbad9affb5a071d.png', 'http://yanxuan.nosdn.127.net/73567265b04a9998f64419186ddd8531.png', '59.00', '26520', '1078001', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1075022', '1012003', '1075022', '暗格简约钢笔', '0', '100', '', '铱金暗尖，300超长书写', '', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/6359ef53b700620c2b391555a3b75439.png', 'http://yanxuan.nosdn.127.net/97ad483a94ed88216a989df83e39cbf0.png', '39.00', '10187', '1079054', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1075023', '1008008', '1075023', '舒适安睡复合羽绒枕', '0', '100', '', '一等白鸭绒，蓬松承托', '<p><img src=\"http://yanxuan.nosdn.127.net/0ff8b333d789044e2020d09ce66abe40.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ff8b333d789044e2020d09ce66abe40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70caba30b405042d08d15f5f6424d3f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/70caba30b405042d08d15f5f6424d3f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c01c5af096b8264909dcbdca7c4f831.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c01c5af096b8264909dcbdca7c4f831.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2df03eb9a43051e5369940952231796.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2df03eb9a43051e5369940952231796.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ed1f8ba403cf7dc5079b43fa9205b38c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ed1f8ba403cf7dc5079b43fa9205b38c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b812ece2ed52e7e169c2ffa34efc6d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b812ece2ed52e7e169c2ffa34efc6d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ceb3a596bd54c41a0c942ee3ffcdc2ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/ceb3a596bd54c41a0c942ee3ffcdc2ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2331d3d090594d46840297fc14aa681e.jpg\" _src=\"http://yanxuan.nosdn.127.net/2331d3d090594d46840297fc14aa681e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4852822f42865ce533a23618070577bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/4852822f42865ce533a23618070577bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e821d78a3df70df85e85e801cb946f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e821d78a3df70df85e85e801cb946f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d97f8202cb7529796d729cdbe9af1f4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d97f8202cb7529796d729cdbe9af1f4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b6470ce962c35c3f897656d4a7d1701.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b6470ce962c35c3f897656d4a7d1701.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b0f31bf36f4faef0dd9cef22a2dff98.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b0f31bf36f4faef0dd9cef22a2dff98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a0fe9cb6f96b5bf93b297068899ddbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a0fe9cb6f96b5bf93b297068899ddbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e516515fc49c649ef3b2d36de21033e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/e516515fc49c649ef3b2d36de21033e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/010efd52fa7f0f11ff9639a4a108bf27.jpg\" _src=\"http://yanxuan.nosdn.127.net/010efd52fa7f0f11ff9639a4a108bf27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8101b530c6eb05bd4c894ecb3f99c86.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8101b530c6eb05bd4c894ecb3f99c86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f135aacff4028aea9a557b64dea3779.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f135aacff4028aea9a557b64dea3779.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/718ac56251b9d22cc0d335bf1e7ab2ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/718ac56251b9d22cc0d335bf1e7ab2ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4e56c008935f06153909d59fb744161.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4e56c008935f06153909d59fb744161.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ab34a4c97fe8e316e8078dd01dee9e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ab34a4c97fe8e316e8078dd01dee9e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9bb11146c349d8b1ca33efb91701b136.jpg\" _src=\"http://yanxuan.nosdn.127.net/9bb11146c349d8b1ca33efb91701b136.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db2e3cdad17d198777ed0ffd26a14fc5.jpg\" _src=\"http://yanxuan.nosdn.127.net/db2e3cdad17d198777ed0ffd26a14fc5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e745a57db19fb1385ef95a83a3322dd2.jpg\" _src=\"http://yanxuan.nosdn.127.net/e745a57db19fb1385ef95a83a3322dd2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/93388abeeeb46c7f9f04746e790f0e42.jpg\" _src=\"http://yanxuan.nosdn.127.net/93388abeeeb46c7f9f04746e790f0e42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c6f2ef50e700773a99a8e78ade1f5c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c6f2ef50e700773a99a8e78ade1f5c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b428e3c4b9cafb1aadea1b3bff9f787.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b428e3c4b9cafb1aadea1b3bff9f787.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28ebf258d2507a68b6f340c3c568fead.jpg\" _src=\"http://yanxuan.nosdn.127.net/28ebf258d2507a68b6f340c3c568fead.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a2d314d6ec97d56d17ea66878d6c995.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a2d314d6ec97d56d17ea66878d6c995.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b89f8a5e287db625cbcbbf3f6df86ed7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b89f8a5e287db625cbcbbf3f6df86ed7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30df1b2dbf80de0a904a8bb51b611946.jpg\" _src=\"http://yanxuan.nosdn.127.net/30df1b2dbf80de0a904a8bb51b611946.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/513627f00d497ff83910fc06c6628430.jpg\" _src=\"http://yanxuan.nosdn.127.net/513627f00d497ff83910fc06c6628430.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a48e9f3bad79676d1e9e717a3f9a9ed1.jpg\" _src=\"http://yanxuan.nosdn.127.net/a48e9f3bad79676d1e9e717a3f9a9ed1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae2607d313993a5701079a0c9bcb00ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae2607d313993a5701079a0c9bcb00ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5108b4d56d178d806483a2675e1ef41e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5108b4d56d178d806483a2675e1ef41e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58bf7e5b113db4031b094b6e0fe1a54a.jpg\" _src=\"http://yanxuan.nosdn.127.net/58bf7e5b113db4031b094b6e0fe1a54a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b617faa161158a4858579262b34b04d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b617faa161158a4858579262b34b04d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/309bbce1758293039c6fefc28c864b1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/309bbce1758293039c6fefc28c864b1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba8569688c174365735ecff01bd9e03f.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba8569688c174365735ecff01bd9e03f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69db8b8b99fc661446b20859dc99e153.jpg\" _src=\"http://yanxuan.nosdn.127.net/69db8b8b99fc661446b20859dc99e153.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f16738356218d0abd570e4249b3afe9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f16738356218d0abd570e4249b3afe9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01593a4ae7ee3c4a26ba398db50b592a.jpg\" _src=\"http://yanxuan.nosdn.127.net/01593a4ae7ee3c4a26ba398db50b592a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49749fe8f76654ee74a8d0978d4ad990.jpg\" _src=\"http://yanxuan.nosdn.127.net/49749fe8f76654ee74a8d0978d4ad990.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0033c96ba23090517da1ca3fb7ec17a1.jpg', 'http://yanxuan.nosdn.127.net/29bc800b9f1fa551bc3cd47b10e2a799.png', '199.00', '1219', '1079055', '0.00', '限时购', '', '0.00', '0', '0', '0', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1075024', '1008008', '1075024', '升级款纯棉静音白鹅羽绒被', '1001000', '100', '', '静音面料，加厚熟睡', '<p><img src=\"http://yanxuan.nosdn.127.net/56261ca3bfb33b4400911bd01ac27ae5.jpg\" _src=\"http://yanxuan.nosdn.127.net/56261ca3bfb33b4400911bd01ac27ae5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/214f8c19371d71dac57ec63e398e87bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/214f8c19371d71dac57ec63e398e87bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12732b11ddc970e10ebf37d71088bab3.jpg\" _src=\"http://yanxuan.nosdn.127.net/12732b11ddc970e10ebf37d71088bab3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be6a7afdc814c8f56d08e3f4285cd456.jpg\" _src=\"http://yanxuan.nosdn.127.net/be6a7afdc814c8f56d08e3f4285cd456.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67cca9bceb817b16690e291a67f41e28.jpg\" _src=\"http://yanxuan.nosdn.127.net/67cca9bceb817b16690e291a67f41e28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67313c9944f3e4277c3e640ab60bbde3.jpg\" _src=\"http://yanxuan.nosdn.127.net/67313c9944f3e4277c3e640ab60bbde3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47235be353e7eec56b7e425be4ddedba.jpg\" _src=\"http://yanxuan.nosdn.127.net/47235be353e7eec56b7e425be4ddedba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3e3d7887ec3ea8ddabd581c4e36e2f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3e3d7887ec3ea8ddabd581c4e36e2f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33f1565e2a14c3fb4456b694771e6fad.jpg\" _src=\"http://yanxuan.nosdn.127.net/33f1565e2a14c3fb4456b694771e6fad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a41d8674cd63d15c5549a6c5745a658.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a41d8674cd63d15c5549a6c5745a658.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7522e4b7add69ae6ba223a38fbd34f4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7522e4b7add69ae6ba223a38fbd34f4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b5c9bd7dae7c24125104e80384c602ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/b5c9bd7dae7c24125104e80384c602ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97a225e49a0a8c764ca394cccb3b10f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/97a225e49a0a8c764ca394cccb3b10f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16f06738c9fb6355352a4eb21a25744b.jpg\" _src=\"http://yanxuan.nosdn.127.net/16f06738c9fb6355352a4eb21a25744b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3ad7de130695e388afa4946c63b4214.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3ad7de130695e388afa4946c63b4214.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0dd0e528b444841f7326dc933b501938.jpg\" _src=\"http://yanxuan.nosdn.127.net/0dd0e528b444841f7326dc933b501938.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ae9599dba84e72c970eecafd9de6294.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ae9599dba84e72c970eecafd9de6294.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b93b7087d8c64647b725418211fd2c4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b93b7087d8c64647b725418211fd2c4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ff7f4cae6011903f209305cd57598c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ff7f4cae6011903f209305cd57598c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/123723b1a400f6088af024190f154d01.jpg\" _src=\"http://yanxuan.nosdn.127.net/123723b1a400f6088af024190f154d01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3a6127948261397e2cce816afe7ff10.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3a6127948261397e2cce816afe7ff10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2bc185f49542115c38aca6508951f83.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2bc185f49542115c38aca6508951f83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf2a0932d6fd65702b0d30dee3f1c658.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf2a0932d6fd65702b0d30dee3f1c658.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f02e979aff1ce7a335cd314491886b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f02e979aff1ce7a335cd314491886b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c64f22b8da97967e854b6e2240ba8ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c64f22b8da97967e854b6e2240ba8ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/857365c29c631ca06d9218213e54f3d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/857365c29c631ca06d9218213e54f3d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be2f36d6255a9f8baf5573c8cb80b4c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/be2f36d6255a9f8baf5573c8cb80b4c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1f71db51b1e322046737356482f115e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1f71db51b1e322046737356482f115e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0697d1c2cd446297ad0494fc97f75ebb.jpg\" _src=\"http://yanxuan.nosdn.127.net/0697d1c2cd446297ad0494fc97f75ebb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e663a704ca44c6d448d37a9fbfb34b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e663a704ca44c6d448d37a9fbfb34b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b5cc03a916aa7a1a7160aab17749c7b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/b5cc03a916aa7a1a7160aab17749c7b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4be42b28ba4bdb04ec250ac5a1d23335.jpg\" _src=\"http://yanxuan.nosdn.127.net/4be42b28ba4bdb04ec250ac5a1d23335.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f1f5bf21475bc50979dce49894bd03c.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f1f5bf21475bc50979dce49894bd03c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dca09a7be97a3bbebeea80f6266e1cbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/dca09a7be97a3bbebeea80f6266e1cbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82cfe49a34dd57e9879ab264b2c4a0f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/82cfe49a34dd57e9879ab264b2c4a0f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/609766611ba2b7f471f4b5ec3cfb1570.jpg\" _src=\"http://yanxuan.nosdn.127.net/609766611ba2b7f471f4b5ec3cfb1570.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b4bfa751387777262f0dd3cbfeda6cf3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b4bfa751387777262f0dd3cbfeda6cf3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cce5ecbcc8d6cbaf2da11a0efa137467.jpg\" _src=\"http://yanxuan.nosdn.127.net/cce5ecbcc8d6cbaf2da11a0efa137467.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d698dd6bad6abd7b5ad731ca8954ab9.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d698dd6bad6abd7b5ad731ca8954ab9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34b463871aee608c1c3ccc9a6ae4e7fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/34b463871aee608c1c3ccc9a6ae4e7fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d7d047d324a9878de7cc1ccd2b24fab.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d7d047d324a9878de7cc1ccd2b24fab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf43f53d3770ff5d34eaade48c42ddf0.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf43f53d3770ff5d34eaade48c42ddf0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e4d8478f1cbe72b6991e59cdbf2c1c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e4d8478f1cbe72b6991e59cdbf2c1c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec91680fb9913afc597afc4295c9810e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec91680fb9913afc597afc4295c9810e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf5f83c67d2b6303fc10d7698211c451.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf5f83c67d2b6303fc10d7698211c451.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4e736beeba84fa508b5001c14326817.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4e736beeba84fa508b5001c14326817.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b39bb20bc10eb80a4a73af1ef72e1f14.jpg\" _src=\"http://yanxuan.nosdn.127.net/b39bb20bc10eb80a4a73af1ef72e1f14.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ee97cc8179dc8f63df9545ed4cf1289.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ee97cc8179dc8f63df9545ed4cf1289.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6f5d89595f271bf1ece37ef1a59b7fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6f5d89595f271bf1ece37ef1a59b7fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cfc8924f6085deaf154deb6da8ac794.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cfc8924f6085deaf154deb6da8ac794.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69dc1813268f768aa90f696807c0614c.jpg\" _src=\"http://yanxuan.nosdn.127.net/69dc1813268f768aa90f696807c0614c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a781da27715d6bbb246e7a9997e1ef4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a781da27715d6bbb246e7a9997e1ef4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e3177e5434d5ef56ea7a782358da8ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e3177e5434d5ef56ea7a782358da8ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64468f6698d122f7c554299af3ea9f13.jpg\" _src=\"http://yanxuan.nosdn.127.net/64468f6698d122f7c554299af3ea9f13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/024b2a81d2860e631165a80a7142cf67.jpg\" _src=\"http://yanxuan.nosdn.127.net/024b2a81d2860e631165a80a7142cf67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85b12419b868dc311361781e50d46877.jpg\" _src=\"http://yanxuan.nosdn.127.net/85b12419b868dc311361781e50d46877.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6fcff064127cdf5b5a73d358db4efa21.jpg\" _src=\"http://yanxuan.nosdn.127.net/6fcff064127cdf5b5a73d358db4efa21.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f28c8dd3c027fbfd64952d2c55b87fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f28c8dd3c027fbfd64952d2c55b87fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/144ee76547f7b21bacb763426af25f07.jpg\" _src=\"http://yanxuan.nosdn.127.net/144ee76547f7b21bacb763426af25f07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/191c12adb5895f7fb71c9d5b8bee424d.jpg\" _src=\"http://yanxuan.nosdn.127.net/191c12adb5895f7fb71c9d5b8bee424d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7158e3fa0c0c034b91dbd06d2eccef3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7158e3fa0c0c034b91dbd06d2eccef3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01da4634f8486926944213e12b15e114.jpg\" _src=\"http://yanxuan.nosdn.127.net/01da4634f8486926944213e12b15e114.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/957eaa7ec5510cfc24d41e82f0882406.jpg\" _src=\"http://yanxuan.nosdn.127.net/957eaa7ec5510cfc24d41e82f0882406.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '20', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a8435686775f39284c0976d9cd8490ef.jpg', 'http://yanxuan.nosdn.127.net/ce4a1eb18ea518bf584620632509935f.png', '2399.00', '607', '1079056', '0.00', '限时购', '', '0.00', '0', '0', '0', '2638.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1081000', '1008002', '1081000', '北欧风珊瑚绒多功能暖手枕', '0', '100', '', '手枕坐垫两用', '<p><img src=\"http://yanxuan.nosdn.127.net/19ce01a5361a70388e7d40e94ccd3495.jpg\" _src=\"http://yanxuan.nosdn.127.net/19ce01a5361a70388e7d40e94ccd3495.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a037a815a9c11449de1c5c94d6a6d987.jpg\" _src=\"http://yanxuan.nosdn.127.net/a037a815a9c11449de1c5c94d6a6d987.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7ccc425d60247f8468ede401cb74683.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7ccc425d60247f8468ede401cb74683.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/039951ed06296e8065f7b219a4a111de.jpg\" _src=\"http://yanxuan.nosdn.127.net/039951ed06296e8065f7b219a4a111de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37576f4179798648632a694da355996f.jpg\" _src=\"http://yanxuan.nosdn.127.net/37576f4179798648632a694da355996f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d45db0fcfff3fb9ced3f6bc5e5d6a23.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d45db0fcfff3fb9ced3f6bc5e5d6a23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e46450a60e9bc60bca3f483ad14337b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/e46450a60e9bc60bca3f483ad14337b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/071c557f2845aa18a7f4d80f556b1178.jpg\" _src=\"http://yanxuan.nosdn.127.net/071c557f2845aa18a7f4d80f556b1178.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5935e928d9b1b6781db188cf41f93424.jpg\" _src=\"http://yanxuan.nosdn.127.net/5935e928d9b1b6781db188cf41f93424.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83f8bac183a90e5d8f32c698813ef046.jpg\" _src=\"http://yanxuan.nosdn.127.net/83f8bac183a90e5d8f32c698813ef046.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7ae7816d84e084b9df010ae92f7c0bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7ae7816d84e084b9df010ae92f7c0bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c89f0917bceb94f0e300df77d08c75e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c89f0917bceb94f0e300df77d08c75e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62c52e788f028eab5b4927671f4aa109.jpg\" _src=\"http://yanxuan.nosdn.127.net/62c52e788f028eab5b4927671f4aa109.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/93b9efc4c1b39c065c0dde2974a9dc52.jpg\" _src=\"http://yanxuan.nosdn.127.net/93b9efc4c1b39c065c0dde2974a9dc52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40da45628d48712880dc64843aba8e6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/40da45628d48712880dc64843aba8e6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec12badecafb5dd8f67b52efa6cf4b15.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec12badecafb5dd8f67b52efa6cf4b15.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bde2888497b52e724ca72d42a86578d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/bde2888497b52e724ca72d42a86578d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f1b163294dff20ac85a5f6dc8016500.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f1b163294dff20ac85a5f6dc8016500.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f970069e7d381421dec8c407fcd2a7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f970069e7d381421dec8c407fcd2a7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b852d0821395488c729a4d09941b2ea7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b852d0821395488c729a4d09941b2ea7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/660168255d39ded4c1d2038cff5d253f.jpg\" _src=\"http://yanxuan.nosdn.127.net/660168255d39ded4c1d2038cff5d253f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fe09efd35ef54dfa0a92c8059971995.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fe09efd35ef54dfa0a92c8059971995.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f13328e747638a9681502f97d0fc032a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f13328e747638a9681502f97d0fc032a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/05c538811b7d8d37b15e9b168b45ed19.jpg\" _src=\"http://yanxuan.nosdn.127.net/05c538811b7d8d37b15e9b168b45ed19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e597815f2bbf76f2c078326d3cd255e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e597815f2bbf76f2c078326d3cd255e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73d7bd31e90a2bdc79263dde20e2496c.jpg\" _src=\"http://yanxuan.nosdn.127.net/73d7bd31e90a2bdc79263dde20e2496c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e10091f21b56c616ac4ab51decab76a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e10091f21b56c616ac4ab51decab76a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5023b92342a2f936996c2eaf2e79f1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5023b92342a2f936996c2eaf2e79f1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a090e4b9269a901e660cc35a1c38975a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a090e4b9269a901e660cc35a1c38975a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85c707ebaae017ab65bf5e2266ec7c6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/85c707ebaae017ab65bf5e2266ec7c6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30a57bf64ad98af99955d90e45ae9f3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/30a57bf64ad98af99955d90e45ae9f3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ec59f055c27c776ee5ec635e1e64b79.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ec59f055c27c776ee5ec635e1e64b79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f39b93929486b2ba679ed22fac5021b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f39b93929486b2ba679ed22fac5021b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ea9e76b9b0988c823796752cd3bc4e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ea9e76b9b0988c823796752cd3bc4e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b952cc40eab4b590943ad91fb35c4ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b952cc40eab4b590943ad91fb35c4ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f5e5f1d2adbb2aaaf10e1e38913206b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f5e5f1d2adbb2aaaf10e1e38913206b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50c14625bb7a2d0331fee4181ae22455.jpg\" _src=\"http://yanxuan.nosdn.127.net/50c14625bb7a2d0331fee4181ae22455.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7af5402277f0cfd4e9ac2bf9c0c0cd8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/7af5402277f0cfd4e9ac2bf9c0c0cd8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b413e4e18e70b2b1bddb54358fbf507e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b413e4e18e70b2b1bddb54358fbf507e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2006d2a3ff91300d1265ce875433484a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2006d2a3ff91300d1265ce875433484a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/35c5c281c7b8bfe5a67704abfbd0f550.jpg\" _src=\"http://yanxuan.nosdn.127.net/35c5c281c7b8bfe5a67704abfbd0f550.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f30d0dd64c48d72f543cf7f48f66f48.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f30d0dd64c48d72f543cf7f48f66f48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13632b105431e683733b69d8a065d458.jpg\" _src=\"http://yanxuan.nosdn.127.net/13632b105431e683733b69d8a065d458.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3a10c77b61704c1efa426d566ead340.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3a10c77b61704c1efa426d566ead340.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '22', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/eb9fd89dcabcbcf7ed7b86a3cb47c96e.jpg', 'http://yanxuan.nosdn.127.net/cc45baafad00405699552c187c64c512.png', '49.00', '997', '1085010', '0.00', '限时购', '', '0.00', '0', '0', '0', '53.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1081002', '1008002', '1081002', '北欧风珊瑚绒多功能抱枕', '0', '100', '', '靠枕暖手毛毯多用', '<p><img src=\"http://yanxuan.nosdn.127.net/d3afdc4dc4f7e8700abd3befd8786f9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3afdc4dc4f7e8700abd3befd8786f9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/690e4238d3c6fe734e5a5a8e5d567cf2.jpg\" _src=\"http://yanxuan.nosdn.127.net/690e4238d3c6fe734e5a5a8e5d567cf2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bb465550fcf6bafcde2b11b4a96d799.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bb465550fcf6bafcde2b11b4a96d799.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b4ba8661f77ff02edc7a172ea1489a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b4ba8661f77ff02edc7a172ea1489a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ededcff020a14eecad669b5beeba3f30.jpg\" _src=\"http://yanxuan.nosdn.127.net/ededcff020a14eecad669b5beeba3f30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/394992289ec493441e7e91dd8a6e856b.jpg\" _src=\"http://yanxuan.nosdn.127.net/394992289ec493441e7e91dd8a6e856b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f06eb02e8ed368a868dfd8137d1c7f3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f06eb02e8ed368a868dfd8137d1c7f3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cec7fcfda67bf3ed1ee66e887614d633.jpg\" _src=\"http://yanxuan.nosdn.127.net/cec7fcfda67bf3ed1ee66e887614d633.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19ffcfd2a998820e92656611ba6ccd99.jpg\" _src=\"http://yanxuan.nosdn.127.net/19ffcfd2a998820e92656611ba6ccd99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c698e643a9ababb498f36b2dd948f59.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c698e643a9ababb498f36b2dd948f59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9746e6314f6aec06be56e6b1f54972c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9746e6314f6aec06be56e6b1f54972c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/769eee41f1452888fa632c07551ca400.jpg\" _src=\"http://yanxuan.nosdn.127.net/769eee41f1452888fa632c07551ca400.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65c740031e1cd5792aecc6333710fe06.jpg\" _src=\"http://yanxuan.nosdn.127.net/65c740031e1cd5792aecc6333710fe06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42361e27db7a3b76705568c0f57bfd43.jpg\" _src=\"http://yanxuan.nosdn.127.net/42361e27db7a3b76705568c0f57bfd43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a3048b4a8ea13487faa1ff51c394ad3.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a3048b4a8ea13487faa1ff51c394ad3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/032041aaae3d703194d7fab7599c4495.jpg\" _src=\"http://yanxuan.nosdn.127.net/032041aaae3d703194d7fab7599c4495.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2478a21152ad10d517af58aaaed64214.jpg\" _src=\"http://yanxuan.nosdn.127.net/2478a21152ad10d517af58aaaed64214.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92691014c72fd7f34f6fada58162011f.jpg\" _src=\"http://yanxuan.nosdn.127.net/92691014c72fd7f34f6fada58162011f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9dc547b23d58f4a835008b55f797f4bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/9dc547b23d58f4a835008b55f797f4bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf6a80f009ba96e51851dce228e542b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf6a80f009ba96e51851dce228e542b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52674285cdb5d2ea19967d3188d1ff8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/52674285cdb5d2ea19967d3188d1ff8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eeb3c5128f915416f4b60a968230d320.jpg\" _src=\"http://yanxuan.nosdn.127.net/eeb3c5128f915416f4b60a968230d320.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/998cc7acd5ce1797aa4b32f8ef775148.jpg\" _src=\"http://yanxuan.nosdn.127.net/998cc7acd5ce1797aa4b32f8ef775148.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7d12038de9483c3974c3ad8f20927a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7d12038de9483c3974c3ad8f20927a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f3c6b9f3fdf0c48156251636e513720e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f3c6b9f3fdf0c48156251636e513720e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/367b80cefe0803348720f82f1c30cfe7.jpg\" _src=\"http://yanxuan.nosdn.127.net/367b80cefe0803348720f82f1c30cfe7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c360e0a65e58cc1c04e01eed6f04b54b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c360e0a65e58cc1c04e01eed6f04b54b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e60d12aff676400bad21d0c93b67803.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e60d12aff676400bad21d0c93b67803.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8be1fb462d145316ec2264d5025b8a48.jpg\" _src=\"http://yanxuan.nosdn.127.net/8be1fb462d145316ec2264d5025b8a48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80725f3251d122a8bc66b20814648310.jpg\" _src=\"http://yanxuan.nosdn.127.net/80725f3251d122a8bc66b20814648310.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a6a82ed8c28b0c60b45bb38e4e7ce04.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a6a82ed8c28b0c60b45bb38e4e7ce04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae881c80e00c34e59c7fd77f829b9931.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae881c80e00c34e59c7fd77f829b9931.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10d7b57b8772053d38fca8e7f6856bac.jpg\" _src=\"http://yanxuan.nosdn.127.net/10d7b57b8772053d38fca8e7f6856bac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d43e30b2aaac4a81dec473fc2842984.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d43e30b2aaac4a81dec473fc2842984.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdd8426becc5a730730838e264c8c998.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdd8426becc5a730730838e264c8c998.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2aaf853063048b8485c1219b8ba55ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2aaf853063048b8485c1219b8ba55ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70604ff736ccc200037d247a274ac128.jpg\" _src=\"http://yanxuan.nosdn.127.net/70604ff736ccc200037d247a274ac128.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3778c8814cba4fa56d697d6e7c84e5dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/3778c8814cba4fa56d697d6e7c84e5dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa66cda001dd6ba7281f9808da9a344b.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa66cda001dd6ba7281f9808da9a344b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65955a09afe2dfa08a92e3b70bda0f5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/65955a09afe2dfa08a92e3b70bda0f5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46bd1859ec91d296d8367e2e6a97ec11.jpg\" _src=\"http://yanxuan.nosdn.127.net/46bd1859ec91d296d8367e2e6a97ec11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33259dcc01613bbf0bb8313f9129e7bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/33259dcc01613bbf0bb8313f9129e7bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5fa03cc2c17cc38da8dc84d0c0e42fa2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5fa03cc2c17cc38da8dc84d0c0e42fa2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5baa2bc5c725dd3d8522b7766830bcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5baa2bc5c725dd3d8522b7766830bcb.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '21', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/b87b4b80910fa03b92923997fd4aabd9.jpg', 'http://yanxuan.nosdn.127.net/380cfcd5d8bc22360de089f0b4eb11da.png', '89.00', '132', '1085012', '0.00', '限时购', '', '0.00', '0', '0', '1', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1083009', '1011004', '1083009', '海洋之心永生花', '0', '100', '', '厄瓜多尔玫瑰，精致美感', '<p><img src=\"http://yanxuan.nosdn.127.net/1b746ed72f6bf99405c749cb6c9da6eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b746ed72f6bf99405c749cb6c9da6eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06b441ba473cabbc5189da42a2c0eb77.jpg\" _src=\"http://yanxuan.nosdn.127.net/06b441ba473cabbc5189da42a2c0eb77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3f24e6e91b100c8132feb082f1a34e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3f24e6e91b100c8132feb082f1a34e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/696cba61d6b37131c2322b66d0495b93.jpg\" _src=\"http://yanxuan.nosdn.127.net/696cba61d6b37131c2322b66d0495b93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1b458886ef3de6961975f86425fafb0.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1b458886ef3de6961975f86425fafb0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63635766ac69f5009483eaca4d696da2.jpg\" _src=\"http://yanxuan.nosdn.127.net/63635766ac69f5009483eaca4d696da2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b0d9fdd0909325b8a067e2e7d70c157.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b0d9fdd0909325b8a067e2e7d70c157.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82da955cf9e36e3d08dadc59f5f300c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/82da955cf9e36e3d08dadc59f5f300c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20d2cc7cdf5e6efe02bfe466e66cd9f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/20d2cc7cdf5e6efe02bfe466e66cd9f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a337c585ca3a1bbeee9785e0f6a191c.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a337c585ca3a1bbeee9785e0f6a191c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65277e00b7fc1a3319881a3692777268.jpg\" _src=\"http://yanxuan.nosdn.127.net/65277e00b7fc1a3319881a3692777268.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31e4584649abe39c7f197ba8924fb74c.jpg\" _src=\"http://yanxuan.nosdn.127.net/31e4584649abe39c7f197ba8924fb74c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbc59ffa03f9901cdccfba627b60e1ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbc59ffa03f9901cdccfba627b60e1ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4b72e337df5ed195cfbc661a3777845.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4b72e337df5ed195cfbc661a3777845.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/080ce5c403e912ac791b31eb0c289511.jpg\" _src=\"http://yanxuan.nosdn.127.net/080ce5c403e912ac791b31eb0c289511.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78b066ce0b49497a9501948063322263.jpg\" _src=\"http://yanxuan.nosdn.127.net/78b066ce0b49497a9501948063322263.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fb74a8a28be5f5c6dacfd16f978afe2.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fb74a8a28be5f5c6dacfd16f978afe2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36b820addabfb7caf910529969a3f1bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/36b820addabfb7caf910529969a3f1bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/219fdb339a336e4f72f40c8849069b15.jpg\" _src=\"http://yanxuan.nosdn.127.net/219fdb339a336e4f72f40c8849069b15.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfb962ce656900f82c46c2e2d3a5df1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfb962ce656900f82c46c2e2d3a5df1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01946020d4e1500d250d28c7e7e0dae5.jpg\" _src=\"http://yanxuan.nosdn.127.net/01946020d4e1500d250d28c7e7e0dae5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20b66f85a1606fda8fc700a85c17d8d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/20b66f85a1606fda8fc700a85c17d8d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31a70dab0b81c7eac9696b2116a6df99.jpg\" _src=\"http://yanxuan.nosdn.127.net/31a70dab0b81c7eac9696b2116a6df99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/611db5a79922174f7fc267267c01fb6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/611db5a79922174f7fc267267c01fb6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ceeea13917bc6ba5d8b358007feacc4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/ceeea13917bc6ba5d8b358007feacc4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95cb22dfb9901f209719996cb40c1d41.jpg\" _src=\"http://yanxuan.nosdn.127.net/95cb22dfb9901f209719996cb40c1d41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e98ac4660f3907189a73040d91c74609.jpg\" _src=\"http://yanxuan.nosdn.127.net/e98ac4660f3907189a73040d91c74609.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8593ac139f076079f1600d5c9dc8018d.jpg\" _src=\"http://yanxuan.nosdn.127.net/8593ac139f076079f1600d5c9dc8018d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0045d4dd0585566f1b93eaf844e3073a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0045d4dd0585566f1b93eaf844e3073a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f9d407b3292b173daec7044c3db1fd6c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f9d407b3292b173daec7044c3db1fd6c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f5e7818316caa798f48fae4f3cdb938.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f5e7818316caa798f48fae4f3cdb938.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be171d645ed6e4f2651df9d3f6f4231e.jpg\" _src=\"http://yanxuan.nosdn.127.net/be171d645ed6e4f2651df9d3f6f4231e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea8bf6c7ebc5641209fb1c846f3bef5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea8bf6c7ebc5641209fb1c846f3bef5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95b1e32659f10a90e0ea01255d318df2.jpg\" _src=\"http://yanxuan.nosdn.127.net/95b1e32659f10a90e0ea01255d318df2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c60047bd75a8b0cc943925f2ecd6e63.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c60047bd75a8b0cc943925f2ecd6e63.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d5fdfb237a0ff76f276662437a49bdd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d5fdfb237a0ff76f276662437a49bdd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/476a35de0402c6ffb483d890ab0ddbef.jpg\" _src=\"http://yanxuan.nosdn.127.net/476a35de0402c6ffb483d890ab0ddbef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02a627d54428aced361f96e3e6eca226.jpg\" _src=\"http://yanxuan.nosdn.127.net/02a627d54428aced361f96e3e6eca226.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6b5d161c87cae4b6d713fd79e135045.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6b5d161c87cae4b6d713fd79e135045.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d893f5518e755af8686cf13e4490a129.jpg\" _src=\"http://yanxuan.nosdn.127.net/d893f5518e755af8686cf13e4490a129.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54fa3793ff82c378ab52a9eaf6fa4f7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/54fa3793ff82c378ab52a9eaf6fa4f7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/053b11e1be5bbf24773853025125dec0.jpg\" _src=\"http://yanxuan.nosdn.127.net/053b11e1be5bbf24773853025125dec0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57798ce86240acd240f4b56c9aa04f01.jpg\" _src=\"http://yanxuan.nosdn.127.net/57798ce86240acd240f4b56c9aa04f01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a379abfeada13c4696c48379a035373.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a379abfeada13c4696c48379a035373.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a2d49a4c05ee87b057e9f0bd1c22a66.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a2d49a4c05ee87b057e9f0bd1c22a66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91bdd265ca73b68ecc940bda58c67d5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/91bdd265ca73b68ecc940bda58c67d5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46328006b2280246628dbbf890cb7b72.jpg\" _src=\"http://yanxuan.nosdn.127.net/46328006b2280246628dbbf890cb7b72.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4b862041e2c90ac3fcbbd78994884272.jpg', 'http://yanxuan.nosdn.127.net/76e5c820f6bb71a26517ffa01f499871.png', '299.00', '1331', '1087100', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1083010', '1011004', '1083010', '绿野仙踪永生花', '0', '100', '', '花朵与多元素的碰撞', '<p><img src=\"http://yanxuan.nosdn.127.net/872f68ec2c4c81593d7a264b533b8b38.jpg\" _src=\"http://yanxuan.nosdn.127.net/872f68ec2c4c81593d7a264b533b8b38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87e5fe50a1d16ba939666f6d6004de73.jpg\" _src=\"http://yanxuan.nosdn.127.net/87e5fe50a1d16ba939666f6d6004de73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06aaec921b232c61fd12c09ea5a43500.jpg\" _src=\"http://yanxuan.nosdn.127.net/06aaec921b232c61fd12c09ea5a43500.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1004dd3c5389c77f983637d72bc0ec59.jpg\" _src=\"http://yanxuan.nosdn.127.net/1004dd3c5389c77f983637d72bc0ec59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8636d85945b34f4f46c40d8bb23da1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8636d85945b34f4f46c40d8bb23da1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cba38f6d80de232aa7cb41a5ea762ccc.jpg\" _src=\"http://yanxuan.nosdn.127.net/cba38f6d80de232aa7cb41a5ea762ccc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbce5a3eb52ba113817529c0f6e19ce6.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbce5a3eb52ba113817529c0f6e19ce6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fcb43dc45be45570a9b8a2940d508f3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/fcb43dc45be45570a9b8a2940d508f3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f65584ca37db0d4bba7b3ff8d0dd7c85.jpg\" _src=\"http://yanxuan.nosdn.127.net/f65584ca37db0d4bba7b3ff8d0dd7c85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce1d98231b92a08a851bd1df647383bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce1d98231b92a08a851bd1df647383bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6614fd0aa3434d15305c99893f6275ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/6614fd0aa3434d15305c99893f6275ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73bfbb663434efdbfaa16b300af283a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/73bfbb663434efdbfaa16b300af283a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91a5e9f66c342ab7620b6110f12cb4e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/91a5e9f66c342ab7620b6110f12cb4e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a697e0d6cd426ad0fd108279d4592a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a697e0d6cd426ad0fd108279d4592a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86d524e4372219fe3cf192cf8ced2fce.jpg\" _src=\"http://yanxuan.nosdn.127.net/86d524e4372219fe3cf192cf8ced2fce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/631bd72f94c63871b4c635109f67e1c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/631bd72f94c63871b4c635109f67e1c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/220dfd6fe696ad1c4cc7552d01af7414.jpg\" _src=\"http://yanxuan.nosdn.127.net/220dfd6fe696ad1c4cc7552d01af7414.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1886adf40c6e0fb9bf9262c54b3d12c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1886adf40c6e0fb9bf9262c54b3d12c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f60e5c3002cd00f5b2190ef0eea7c05a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f60e5c3002cd00f5b2190ef0eea7c05a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1d91663eded7ff87a33c251f6b71168.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1d91663eded7ff87a33c251f6b71168.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5de732d905584125eeaaebc0b7bf2d96.jpg\" _src=\"http://yanxuan.nosdn.127.net/5de732d905584125eeaaebc0b7bf2d96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de2b14e10b3450453b406c238953d9ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/de2b14e10b3450453b406c238953d9ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9d37955cdadb0800eba149475bd96e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9d37955cdadb0800eba149475bd96e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1f75e9d6b70c75670319231f1571dd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1f75e9d6b70c75670319231f1571dd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b890510ea48b7d159a22890406e5b3ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/b890510ea48b7d159a22890406e5b3ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf306751ff360b80219eb56e0236ef66.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf306751ff360b80219eb56e0236ef66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54aa26a7c8785299f54719304b75eade.jpg\" _src=\"http://yanxuan.nosdn.127.net/54aa26a7c8785299f54719304b75eade.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7a151c2e24d097b6128415a7d7c17ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7a151c2e24d097b6128415a7d7c17ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24de9d76834c16d6811d0db2743e11bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/24de9d76834c16d6811d0db2743e11bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7bafc75fe6a498f2710542f28e129e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7bafc75fe6a498f2710542f28e129e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc61bdbac2ee9ba29004e4455fb02ead.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc61bdbac2ee9ba29004e4455fb02ead.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/077f02722953587161b03664a95e04dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/077f02722953587161b03664a95e04dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/240b04e96eb8555f673d5d83987b0085.jpg\" _src=\"http://yanxuan.nosdn.127.net/240b04e96eb8555f673d5d83987b0085.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0ea680311627b79e004a1023b8ba667.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0ea680311627b79e004a1023b8ba667.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e013efd9b24d7776ef14139d09385c22.jpg\" _src=\"http://yanxuan.nosdn.127.net/e013efd9b24d7776ef14139d09385c22.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/771212784bf1dc6f15616d760f84ee3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/771212784bf1dc6f15616d760f84ee3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d158de0ad3d9199f69b23dbdc4158145.jpg\" _src=\"http://yanxuan.nosdn.127.net/d158de0ad3d9199f69b23dbdc4158145.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/907d34328d50e3046569a7dbb3ffc6fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/907d34328d50e3046569a7dbb3ffc6fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a727890123a453f2d985fbf4e8685673.jpg\" _src=\"http://yanxuan.nosdn.127.net/a727890123a453f2d985fbf4e8685673.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a91a0c6ae0b550ac31a2595bd576248.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a91a0c6ae0b550ac31a2595bd576248.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/faae995ebf3c914e15c6fd722e56f723.jpg\" _src=\"http://yanxuan.nosdn.127.net/faae995ebf3c914e15c6fd722e56f723.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42c03d3bb396ff92f41508523528084f.jpg\" _src=\"http://yanxuan.nosdn.127.net/42c03d3bb396ff92f41508523528084f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34cd72d26957d2d21b77e13f72b2c152.jpg\" _src=\"http://yanxuan.nosdn.127.net/34cd72d26957d2d21b77e13f72b2c152.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d90740ea6c616414b4d560cfa704924f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d90740ea6c616414b4d560cfa704924f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/160debe27efa104fba6de6514449619c.jpg\" _src=\"http://yanxuan.nosdn.127.net/160debe27efa104fba6de6514449619c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/180a58f57add7ac4cd4b73a19407713b.jpg\" _src=\"http://yanxuan.nosdn.127.net/180a58f57add7ac4cd4b73a19407713b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f0881dbadf691f92257d073c1e5a780.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f0881dbadf691f92257d073c1e5a780.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f191394211da2a5b0f63d3e102067b28.jpg\" _src=\"http://yanxuan.nosdn.127.net/f191394211da2a5b0f63d3e102067b28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fc6603485665bdc886bf13664d1a493.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fc6603485665bdc886bf13664d1a493.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/693af2b7a263853ef898401b3221e5ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/693af2b7a263853ef898401b3221e5ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a54b9bff291b8e0c98260d0aceea61e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a54b9bff291b8e0c98260d0aceea61e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/356950f4b46e0b039797de034a197a86.jpg\" _src=\"http://yanxuan.nosdn.127.net/356950f4b46e0b039797de034a197a86.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/6813b82a85356dbb119761382a1ba74f.jpg', 'http://yanxuan.nosdn.127.net/b9a12d07f8f2d04d662d9340e68e6687.png', '469.00', '619', '1087101', '0.00', '限时购', '', '0.00', '0', '0', '0', '515.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1084001', '1008009', '1084001', '纯棉简欧条纹针织盖毯', '1001020', '100', '', '纯棉针织，柔软亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/d60df75bd3b7037cfbdb0bcb5fe29078.jpg\" _src=\"http://yanxuan.nosdn.127.net/d60df75bd3b7037cfbdb0bcb5fe29078.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a3b8f3a2fa9862a758916be8a99f237.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a3b8f3a2fa9862a758916be8a99f237.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16ae1db56d952fca040462fedf80fe6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/16ae1db56d952fca040462fedf80fe6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13833e191509f7ef0e0f2b2431b167e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/13833e191509f7ef0e0f2b2431b167e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/989982f7920b6cf6bf6942fb7e6f28e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/989982f7920b6cf6bf6942fb7e6f28e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec920f8b651cff338e5c6d3f9200ccbf.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec920f8b651cff338e5c6d3f9200ccbf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b997c8381faacba67423c4901e75cbd6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b997c8381faacba67423c4901e75cbd6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fd1cb3ed252f2bd7f3ef09006f4183f.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fd1cb3ed252f2bd7f3ef09006f4183f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c29a7dce14c954710ffbf3b2e6e1f5b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c29a7dce14c954710ffbf3b2e6e1f5b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad7deda640da27bed0957567b8c720fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad7deda640da27bed0957567b8c720fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3192b3299cc9debf87e017ed6e0e707.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3192b3299cc9debf87e017ed6e0e707.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdb27df5a064f09d0a6b2fa0cadeafc9.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdb27df5a064f09d0a6b2fa0cadeafc9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22dd3a0791adc1cb60c0e7f4e5f50ea8.jpg\" _src=\"http://yanxuan.nosdn.127.net/22dd3a0791adc1cb60c0e7f4e5f50ea8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/955d02dad34f4a570d5f6799e29f0484.jpg\" _src=\"http://yanxuan.nosdn.127.net/955d02dad34f4a570d5f6799e29f0484.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/567c8474434e1c64f31bdbff5833dec7.jpg\" _src=\"http://yanxuan.nosdn.127.net/567c8474434e1c64f31bdbff5833dec7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f31f3d51648100fcb7c512f48fcaf8eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/f31f3d51648100fcb7c512f48fcaf8eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/777f29a46d14baab3e676c317ce17d26.jpg\" _src=\"http://yanxuan.nosdn.127.net/777f29a46d14baab3e676c317ce17d26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa41d6a9b78bb94e51face2264976044.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa41d6a9b78bb94e51face2264976044.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f98cc5909c7b2960989dadf2ff3aca7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f98cc5909c7b2960989dadf2ff3aca7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c3b809c819b448d8b5cae7aa5ccaaae.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c3b809c819b448d8b5cae7aa5ccaaae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e73953b0e4226ff8ce7760f1ef521ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e73953b0e4226ff8ce7760f1ef521ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a3c3af2199907393e91a24f8d2aa05d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a3c3af2199907393e91a24f8d2aa05d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf286dc4fbad8ac953a2cf580b24059d.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf286dc4fbad8ac953a2cf580b24059d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ff7fcba4fc90420e266fe23a2b522b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ff7fcba4fc90420e266fe23a2b522b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2da1324a8fef80f429d29d8c9905e221.jpg\" _src=\"http://yanxuan.nosdn.127.net/2da1324a8fef80f429d29d8c9905e221.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b28b3a2839f599ba0be34d103dc03d43.jpg\" _src=\"http://yanxuan.nosdn.127.net/b28b3a2839f599ba0be34d103dc03d43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d382ee5c40eeb88b27cdea1cdb102c77.jpg\" _src=\"http://yanxuan.nosdn.127.net/d382ee5c40eeb88b27cdea1cdb102c77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02e82cbd31c4103d825b8bf3e65d282e.jpg\" _src=\"http://yanxuan.nosdn.127.net/02e82cbd31c4103d825b8bf3e65d282e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69aec67dd8281a9a563136cbd285957b.jpg\" _src=\"http://yanxuan.nosdn.127.net/69aec67dd8281a9a563136cbd285957b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ce752d3bc231a483501ea7253479974.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ce752d3bc231a483501ea7253479974.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75e8fe26c602ef7751ed8b433a0b078d.jpg\" _src=\"http://yanxuan.nosdn.127.net/75e8fe26c602ef7751ed8b433a0b078d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46aaf931f8ccf7ba1c47f6602fb0c4e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/46aaf931f8ccf7ba1c47f6602fb0c4e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/853e0615dea16f01e63abb76f0b08357.jpg\" _src=\"http://yanxuan.nosdn.127.net/853e0615dea16f01e63abb76f0b08357.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e31a21eb067f790b9cc410bc06c8d14.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e31a21eb067f790b9cc410bc06c8d14.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6df9b852ae02044d32db41ec0316a88f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6df9b852ae02044d32db41ec0316a88f.jpg\" style=\"\"/><img src=\"http://yanxuan.nosdn.127.net/bbdf123515558da5e4cffb62dfbc4c50.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbdf123515558da5e4cffb62dfbc4c50.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69ba446f41e17ac41e4872af2c03aa3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/69ba446f41e17ac41e4872af2c03aa3d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f15085ed43a2c43240b0599ebc5cd58e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f15085ed43a2c43240b0599ebc5cd58e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60471cae3855ce31a0a55c9c90dad5bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/60471cae3855ce31a0a55c9c90dad5bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e345b6a5fb55570ae85fdddcd08d200.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e345b6a5fb55570ae85fdddcd08d200.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f85be76a1e0018a00ed1e64d7a18723c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f85be76a1e0018a00ed1e64d7a18723c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a1214d35881c724baf6281feabf49b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a1214d35881c724baf6281feabf49b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65cb9bdfb5b8a8450834c38caf928eb9.jpg\" _src=\"http://yanxuan.nosdn.127.net/65cb9bdfb5b8a8450834c38caf928eb9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32f8045537d03e634e79db1c0b8d3414.jpg\" _src=\"http://yanxuan.nosdn.127.net/32f8045537d03e634e79db1c0b8d3414.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71021e6ad1d1fbe3ac40e3a42f1bc725.jpg\" _src=\"http://yanxuan.nosdn.127.net/71021e6ad1d1fbe3ac40e3a42f1bc725.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14919c06e49737b473eeeff20bdc8144.jpg\" _src=\"http://yanxuan.nosdn.127.net/14919c06e49737b473eeeff20bdc8144.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/083a822300f398d51eb801d89072cd2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/083a822300f398d51eb801d89072cd2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdfdf2ccf213c7e1a4144afefda96417.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdfdf2ccf213c7e1a4144afefda96417.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5ae066cbddfa5a4705674ae13cdc829.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5ae066cbddfa5a4705674ae13cdc829.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e876d3126cb7464c68a4150ff4edcf8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/e876d3126cb7464c68a4150ff4edcf8a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59bc3b22edabd57ec2a5e0cf1b5a4fe0.jpg\" _src=\"http://yanxuan.nosdn.127.net/59bc3b22edabd57ec2a5e0cf1b5a4fe0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5fe0fc9f7bf969311b647de6a2f1c25c.jpg\" _src=\"http://yanxuan.nosdn.127.net/5fe0fc9f7bf969311b647de6a2f1c25c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e78cb02f8704bd36802e25c73486adb.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e78cb02f8704bd36802e25c73486adb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b2e7f38703e96f95898a141a832c767.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b2e7f38703e96f95898a141a832c767.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92763e94e4bde2bfdf140f53cb30fe39.jpg\" _src=\"http://yanxuan.nosdn.127.net/92763e94e4bde2bfdf140f53cb30fe39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9c9a15013a260182333504e09e313b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9c9a15013a260182333504e09e313b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/706f9fec46c3fbf9834d408c9b69c0fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/706f9fec46c3fbf9834d408c9b69c0fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77bcc6f7b25f0a3a671c25af18935ba3.jpg\" _src=\"http://yanxuan.nosdn.127.net/77bcc6f7b25f0a3a671c25af18935ba3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9048a396cf6474d8aa8c773a3c197b71.jpg\" _src=\"http://yanxuan.nosdn.127.net/9048a396cf6474d8aa8c773a3c197b71.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '37', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/8c8516b08eee47c0b7476d4f78062fc1.png', 'http://yanxuan.nosdn.127.net/07f682d405c1d2ed343c210ac8f8862a.png', '249.00', '1638', '1089014', '0.00', '限时购', '', '0.00', '0', '0', '0', '273.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1084003', '1008009', '1084003', '纯棉美式绞花针织盖毯', '1001020', '100', '', '美式提花，温暖舒适', '<p><img src=\"http://yanxuan.nosdn.127.net/489c8f0dcad41cbcfb190170b6059266.jpg\" _src=\"http://yanxuan.nosdn.127.net/489c8f0dcad41cbcfb190170b6059266.jpg\"/></p>', '1', '2017-08-30 11:40:11', '31', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e27258c0f82c96459326abd61c38c69b.jpg', 'http://yanxuan.nosdn.127.net/cf40c167e7054fe184d49f19121f63c7.png', '199.00', '36', '1089017', '0.00', '限时购', '', '0.00', '0', '0', '1', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1085019', '1012001', '1085019', '20寸 纯PC“铝框”（非全铝）登机箱', '0', '100', '', '铝质包角，牢固抗摔', '', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f819d7ddd1287106efea3736817cf25f.png', 'http://yanxuan.nosdn.127.net/65c955a7a98e84d44ca30bb88a591eac.png', '349.00', '21816', '1090081', '0.00', '限时购', '', '0.00', '0', '0', '0', '383.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086015', '1008016', '1086015', '北欧极简直杆台灯', '0', '100', '', '北欧色彩，极简线条', '<p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/1438c1c7d5fac9ee8a957f0e498efbab.jpg\" _src=\"http://yanxuan.nosdn.127.net/1438c1c7d5fac9ee8a957f0e498efbab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80d0037836d80ec0aa25ff641c261735.jpg\" _src=\"http://yanxuan.nosdn.127.net/80d0037836d80ec0aa25ff641c261735.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d527b3bb238e9399d00c94e59f067ab6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d527b3bb238e9399d00c94e59f067ab6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b4004fb355802f2bf0ade96e53777f7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b4004fb355802f2bf0ade96e53777f7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e2156d0593a949ef23458950a1c3b45.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e2156d0593a949ef23458950a1c3b45.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1670a25eb39faab38247fbbd302e1aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1670a25eb39faab38247fbbd302e1aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/488551c7d433c52a5d6511ca5dca96ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/488551c7d433c52a5d6511ca5dca96ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b3997a05bce53a3e65cc22357d09034.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b3997a05bce53a3e65cc22357d09034.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f97f5fc70124c70b56598086acf3e4f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/f97f5fc70124c70b56598086acf3e4f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c48c53b8727b1d0209a1db7d03f1f50.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c48c53b8727b1d0209a1db7d03f1f50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc22d8146d53d256d7972478a7858a42.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc22d8146d53d256d7972478a7858a42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8592232780fdca35d29c9e9cef0e25f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/8592232780fdca35d29c9e9cef0e25f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56e16e7ae04456d801533b969de58127.jpg\" _src=\"http://yanxuan.nosdn.127.net/56e16e7ae04456d801533b969de58127.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe7ad603619f4614c11a3afacf98e9f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe7ad603619f4614c11a3afacf98e9f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c04470af48bf83539efe1ea0380cda20.jpg\" _src=\"http://yanxuan.nosdn.127.net/c04470af48bf83539efe1ea0380cda20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14d70de1f7ea5309e97f145a895bdd6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/14d70de1f7ea5309e97f145a895bdd6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cd3c3a60d92575400098cd31cf994bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cd3c3a60d92575400098cd31cf994bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c46be17c0c367292dd3a612d277898f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/c46be17c0c367292dd3a612d277898f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68e909b6bbfd4760f6d94170bb9f1e32.jpg\" _src=\"http://yanxuan.nosdn.127.net/68e909b6bbfd4760f6d94170bb9f1e32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e2fa55c8e1f12d592d85582c8be22f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e2fa55c8e1f12d592d85582c8be22f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ccbf36677da68035d9cca9deaf53bb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ccbf36677da68035d9cca9deaf53bb3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae50a463802c44ff72b340374c93cbe3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae50a463802c44ff72b340374c93cbe3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7afafb4d6813b46bf0ad3e750ee150d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/7afafb4d6813b46bf0ad3e750ee150d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbcb8970bf6c845ce6c47ce5b15e8c74.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbcb8970bf6c845ce6c47ce5b15e8c74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0a696a54810118531e752d2f12bdfa4.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0a696a54810118531e752d2f12bdfa4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28ccd9c35226d3e5c7c2911b37ed4a4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/28ccd9c35226d3e5c7c2911b37ed4a4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/288c91f8d06c08ca0f7c84a7c24e73be.jpg\" _src=\"http://yanxuan.nosdn.127.net/288c91f8d06c08ca0f7c84a7c24e73be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a132263063ce01eb7b1aeb772343841.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a132263063ce01eb7b1aeb772343841.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e71801586b48c9c9e0fff8a839eb9cf0.jpg\" _src=\"http://yanxuan.nosdn.127.net/e71801586b48c9c9e0fff8a839eb9cf0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87df9ec07b264d5f504a29d89ee2b383.jpg\" _src=\"http://yanxuan.nosdn.127.net/87df9ec07b264d5f504a29d89ee2b383.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b170f3f949467f5eb92406a6a348ae8.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b170f3f949467f5eb92406a6a348ae8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d02894b6d9134f0f0246b5cf51b116e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d02894b6d9134f0f0246b5cf51b116e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b00efd8962c004cfa2ed7b1c785f090.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b00efd8962c004cfa2ed7b1c785f090.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80ecf013fd3b56477fe2473f76d46131.jpg\" _src=\"http://yanxuan.nosdn.127.net/80ecf013fd3b56477fe2473f76d46131.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f469a6d04a48d833f91e7c84bee11f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f469a6d04a48d833f91e7c84bee11f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c87cf3b2e6ae0f67edc0a45f71a427b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c87cf3b2e6ae0f67edc0a45f71a427b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/390276a05dabfa7578e6f7d316692732.jpg\" _src=\"http://yanxuan.nosdn.127.net/390276a05dabfa7578e6f7d316692732.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8a5f9c29d293488c2b35453e137691a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8a5f9c29d293488c2b35453e137691a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c13b7d09ed64a8cb73970cd7b66093a0.jpg\" _src=\"http://yanxuan.nosdn.127.net/c13b7d09ed64a8cb73970cd7b66093a0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6a10c6dbf2116b893cf487c2a959c82.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6a10c6dbf2116b893cf487c2a959c82.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d7d50e5fcd430b9ccde72cbd84addea.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d7d50e5fcd430b9ccde72cbd84addea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a733fc402f2ed628c003c9f08c59f993.jpg\" _src=\"http://yanxuan.nosdn.127.net/a733fc402f2ed628c003c9f08c59f993.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25d64e1901953a651bc7de7e3edde87c.jpg\" _src=\"http://yanxuan.nosdn.127.net/25d64e1901953a651bc7de7e3edde87c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c1526ed336c04ad9703d3a203d42d88.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c1526ed336c04ad9703d3a203d42d88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6768f1bac041434d73bb3c30bbbed21b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6768f1bac041434d73bb3c30bbbed21b.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0e9c8555164427bafa704aa73cbe707f.jpg', 'http://yanxuan.nosdn.127.net/d5c2ecfe0fb00cdd8b829975bab21a31.png', '249.00', '2711', '1091069', '0.00', '限时购', '', '0.00', '0', '0', '0', '273.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086023', '1017000', '1086023', '彩色波点缓冲宠物牵引绳', '0', '100', '', '精致合金，萌趣波点', '<p><img src=\"http://yanxuan.nosdn.127.net/04e5d14f49ea8efd77f8f3904ec9a8e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/04e5d14f49ea8efd77f8f3904ec9a8e2.jpg\"/></p>', '1', '2017-08-30 11:40:11', '25', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/6e663b18dcb13ca3055bbd8b127791ce.jpg', 'http://yanxuan.nosdn.127.net/121a99e896b3e332c102eb5f6f9b3406.png', '19.90', '627', '1091109', '0.00', '限时购', '', '0.00', '0', '0', '0', '21.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086024', '1017000', '1086024', '夜间反光防走失宠物牵引绳', '0', '100', '', '编织反光，夜间防走失', '<p><img src=\"http://yanxuan.nosdn.127.net/ad4e26dd3bac3f6ee12727e416b55cca.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad4e26dd3bac3f6ee12727e416b55cca.jpg\"/></p>', '1', '2017-08-30 11:40:11', '24', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/57f9abd63e360ea072694455da05c3c4.jpg', 'http://yanxuan.nosdn.127.net/af899cfaa13f515ecb9cf9a33f41370a.png', '9.90', '785', '1091111', '0.00', '限时购', '', '0.00', '0', '0', '0', '10.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086025', '1017000', '1086025', '美式精编麻花圆绳宠物牵引绳', '0', '100', '', '编织纹理，牢固精致', '<p><img src=\"http://yanxuan.nosdn.127.net/e56dbbad4b60ab1d67e5cce71bc395b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e56dbbad4b60ab1d67e5cce71bc395b1.jpg\"/></p>', '1', '2017-08-30 11:40:11', '27', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/18536578f339aa99230dcdadbfefc753.jpg', 'http://yanxuan.nosdn.127.net/78eff56b293c8354bc9ac496fc2c5179.png', '49.00', '141', '1091114', '0.00', '限时购', '', '0.00', '0', '0', '0', '53.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086026', '1017000', '1086026', '复古实心交织宠物牵引绳', '0', '100', '', '实心黑色编织仿皮质宠物牵引绳', '<p><img src=\"http://yanxuan.nosdn.127.net/43a5439bce36fe1b03a48b346daa6d46.jpg\" _src=\"http://yanxuan.nosdn.127.net/43a5439bce36fe1b03a48b346daa6d46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d122b00dc8bca99ac1e885b0e69f9990.jpg\" _src=\"http://yanxuan.nosdn.127.net/d122b00dc8bca99ac1e885b0e69f9990.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2281e036a2d40424628634a203e7080b.jpg\" _src=\"http://yanxuan.nosdn.127.net/2281e036a2d40424628634a203e7080b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/088f48a2753122f97fc06b5aca633b77.jpg\" _src=\"http://yanxuan.nosdn.127.net/088f48a2753122f97fc06b5aca633b77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21ddf0de7aa4f0d5250df66a31306957.jpg\" _src=\"http://yanxuan.nosdn.127.net/21ddf0de7aa4f0d5250df66a31306957.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92c4c0129712f496dfa7462f32a4109f.jpg\" _src=\"http://yanxuan.nosdn.127.net/92c4c0129712f496dfa7462f32a4109f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b0c6da8e2effd5f3a129143a6236831.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b0c6da8e2effd5f3a129143a6236831.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/599f555304437146f0bac97410108790.jpg\" _src=\"http://yanxuan.nosdn.127.net/599f555304437146f0bac97410108790.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92e7c71c88037b724d12f75c7f1e1541.jpg\" _src=\"http://yanxuan.nosdn.127.net/92e7c71c88037b724d12f75c7f1e1541.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69949db3ddb860133664f2eab13df82d.jpg\" _src=\"http://yanxuan.nosdn.127.net/69949db3ddb860133664f2eab13df82d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/355daafda57ab5e8693cfda66ee85381.jpg\" _src=\"http://yanxuan.nosdn.127.net/355daafda57ab5e8693cfda66ee85381.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b766bb2a9319b148ea3cf200d504ecc.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b766bb2a9319b148ea3cf200d504ecc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f10e5ffa73b9a0ab6618a42a84ed58c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f10e5ffa73b9a0ab6618a42a84ed58c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3e393b802ff16898e38d6ec8d1100b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3e393b802ff16898e38d6ec8d1100b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f9e8a4a8d3246ccaebc76799a4c99005.jpg\" _src=\"http://yanxuan.nosdn.127.net/f9e8a4a8d3246ccaebc76799a4c99005.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90010ef3083b3df38f0b4c19b0d37ead.jpg\" _src=\"http://yanxuan.nosdn.127.net/90010ef3083b3df38f0b4c19b0d37ead.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49b6c3b4c6fe67cd6ab2fe7d38264d97.jpg\" _src=\"http://yanxuan.nosdn.127.net/49b6c3b4c6fe67cd6ab2fe7d38264d97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55b308be1d87d9c3520a0e9ee95e1073.jpg\" _src=\"http://yanxuan.nosdn.127.net/55b308be1d87d9c3520a0e9ee95e1073.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cee97664d128933c5944873e7a6e0f5e.jpg\" _src=\"http://yanxuan.nosdn.127.net/cee97664d128933c5944873e7a6e0f5e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42cc29cb0038cafd04a7b33e9dbd7368.jpg\" _src=\"http://yanxuan.nosdn.127.net/42cc29cb0038cafd04a7b33e9dbd7368.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b281fb8d8c60488452034933269c229b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b281fb8d8c60488452034933269c229b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89ab246237a3d28170437349a4b9d1f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/89ab246237a3d28170437349a4b9d1f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/edf6bae4ca3c2785a659735649dcb346.jpg\" _src=\"http://yanxuan.nosdn.127.net/edf6bae4ca3c2785a659735649dcb346.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d804d35c23b29bd08ab6690382f211a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/d804d35c23b29bd08ab6690382f211a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17ccfe0adc84dd862c63ca68e2f09e98.jpg\" _src=\"http://yanxuan.nosdn.127.net/17ccfe0adc84dd862c63ca68e2f09e98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e41e5c299917a6b8991756de5bd35dd2.jpg\" _src=\"http://yanxuan.nosdn.127.net/e41e5c299917a6b8991756de5bd35dd2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb72a032f4881fa0745c45e6009288c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb72a032f4881fa0745c45e6009288c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1aafd30947a677128e9a8043ab291dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1aafd30947a677128e9a8043ab291dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a17a446018c56777cd3147db02f465d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a17a446018c56777cd3147db02f465d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7bc5638ba378685c69f7ea74397312c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/7bc5638ba378685c69f7ea74397312c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c63617a28674ed000eaf070798e7b4db.jpg\" _src=\"http://yanxuan.nosdn.127.net/c63617a28674ed000eaf070798e7b4db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97f5139f4eda2be7de5809edac674de2.jpg\" _src=\"http://yanxuan.nosdn.127.net/97f5139f4eda2be7de5809edac674de2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59ad9a7dc48201bea7de3f56d23bc732.jpg\" _src=\"http://yanxuan.nosdn.127.net/59ad9a7dc48201bea7de3f56d23bc732.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/440465f6da539b72353160fdf413349d.jpg\" _src=\"http://yanxuan.nosdn.127.net/440465f6da539b72353160fdf413349d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca984508f60231479a55e9e72d41ecf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca984508f60231479a55e9e72d41ecf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/488d4b906bf632db2e69c8c638c795ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/488d4b906bf632db2e69c8c638c795ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a239f282d18839b926f88edc6c5afeaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/a239f282d18839b926f88edc6c5afeaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf95c929fae93e9b563cae1cc577d2eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf95c929fae93e9b563cae1cc577d2eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d40e69553829e08d79621bdb6788d8eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/d40e69553829e08d79621bdb6788d8eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/213807781dab6c53dbd8d01e096c912d.jpg\" _src=\"http://yanxuan.nosdn.127.net/213807781dab6c53dbd8d01e096c912d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c647de1a7fa8068452aeaa4c9adae6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c647de1a7fa8068452aeaa4c9adae6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfcddb4ca2a82345b311f407e90fb430.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfcddb4ca2a82345b311f407e90fb430.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00c3766107beb8501979746c59d00711.jpg\" _src=\"http://yanxuan.nosdn.127.net/00c3766107beb8501979746c59d00711.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b92d3c1c47512ff8c11f792f98e59a19.jpg\" _src=\"http://yanxuan.nosdn.127.net/b92d3c1c47512ff8c11f792f98e59a19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/135039e530c313757144253b6843e7d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/135039e530c313757144253b6843e7d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/846dcb901853f0af9ff9b83fa98ae9ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/846dcb901853f0af9ff9b83fa98ae9ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/320d78412d985eaf6eff7fa708576618.jpg\" _src=\"http://yanxuan.nosdn.127.net/320d78412d985eaf6eff7fa708576618.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1574547a1b699826966c52f5589a2ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1574547a1b699826966c52f5589a2ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fcaea26f40b145becc146f79e32a94ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/fcaea26f40b145becc146f79e32a94ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce6346c66b227b3b59ed5f7668b44878.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce6346c66b227b3b59ed5f7668b44878.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '26', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/568cc9e61f86968a3471507616473648.jpg', 'http://yanxuan.nosdn.127.net/caecdaa37d9cbcff980cee0968911e34.png', '29.00', '104', '1091115', '0.00', '限时购', '', '0.00', '0', '0', '0', '31.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1086052', '1012001', '1086052', '20寸 铝镁合金登机箱', '0', '100', '', '时尚金属箱，奢品质感', '', '1', '2017-08-30 11:40:11', '4', '0', '0', '1499.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/879dde68b149091ed832980a5388304a.png', 'http://yanxuan.nosdn.127.net/93171a281c4ed272c007a050816e6f6c.png', '859.00', '599', '1091180', '0.00', '三石福利价', '三石福利价', '0.00', '0', '203', '0', '944.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1090004', '1008009', '1090004', '日式法兰绒格子四件套', '1001000', '100', '', '气质英伦格纹，法兰绒的丰满细腻', '<p><img src=\"http://yanxuan.nosdn.127.net/c5d674aa299a695c5c4c0db81025e754.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5d674aa299a695c5c4c0db81025e754.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f26e78d93e29aab32b4629dc0ac46a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f26e78d93e29aab32b4629dc0ac46a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f56ec00fd8014106cf25a661d3ec797b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f56ec00fd8014106cf25a661d3ec797b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74ee09e3d121c21c128fda3dbb48ff93.jpg\" _src=\"http://yanxuan.nosdn.127.net/74ee09e3d121c21c128fda3dbb48ff93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b6a5cb5e75cc5159ef19e68a68c571f.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b6a5cb5e75cc5159ef19e68a68c571f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d046159b8b5940565e52d432af47fdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d046159b8b5940565e52d432af47fdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ea5cebdcf5c5b6c7b63c537c391fac0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ea5cebdcf5c5b6c7b63c537c391fac0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbe2aa2c6f479f1a2fa7c3d1168eb2da.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbe2aa2c6f479f1a2fa7c3d1168eb2da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c83ea824cd0baea85933c1a7ab7a6391.jpg\" _src=\"http://yanxuan.nosdn.127.net/c83ea824cd0baea85933c1a7ab7a6391.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1fcea29ea7aee7b8547dab203a2f0a2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1fcea29ea7aee7b8547dab203a2f0a2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/303e723e88c7a97637b03e8b6c909228.jpg\" _src=\"http://yanxuan.nosdn.127.net/303e723e88c7a97637b03e8b6c909228.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45f6d6f44148d26fda2d433b8996a023.jpg\" _src=\"http://yanxuan.nosdn.127.net/45f6d6f44148d26fda2d433b8996a023.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b02c994370c16d506b2816323963a05.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b02c994370c16d506b2816323963a05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13b1c59a181c003ef49c089697162f11.jpg\" _src=\"http://yanxuan.nosdn.127.net/13b1c59a181c003ef49c089697162f11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9066da74fa3268749af74d48583a3915.jpg\" _src=\"http://yanxuan.nosdn.127.net/9066da74fa3268749af74d48583a3915.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22d1cbe72022eeefabdebb881be7be53.jpg\" _src=\"http://yanxuan.nosdn.127.net/22d1cbe72022eeefabdebb881be7be53.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdc0bb9e30e01729ef23564b07cffe45.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdc0bb9e30e01729ef23564b07cffe45.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6249c39ca733c75bc8c0bb90daeeb12a.jpg\" _src=\"http://yanxuan.nosdn.127.net/6249c39ca733c75bc8c0bb90daeeb12a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f70749f36b60bd1962ce28ed180a93e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/f70749f36b60bd1962ce28ed180a93e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c55fa3317e09fe3d3e2971f768e00947.jpg\" _src=\"http://yanxuan.nosdn.127.net/c55fa3317e09fe3d3e2971f768e00947.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3477d90873d80315571165816991a2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3477d90873d80315571165816991a2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c24363b2cd4728d0c0ef19478bda3f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c24363b2cd4728d0c0ef19478bda3f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b92e6be5e80ff4cf55d06b284ab784ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/b92e6be5e80ff4cf55d06b284ab784ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7137ebf6468571550adaa70a3c770eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7137ebf6468571550adaa70a3c770eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88b466104d4d8502c28029bd8a5852ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/88b466104d4d8502c28029bd8a5852ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccf54b36177613093209b78d992f50af.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccf54b36177613093209b78d992f50af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb37be13750edf70aec43d9be731eb10.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb37be13750edf70aec43d9be731eb10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cdb3ef4a50634629885d163e8b91d71.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cdb3ef4a50634629885d163e8b91d71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24e991af9b9704ff1b2963fd2e999763.jpg\" _src=\"http://yanxuan.nosdn.127.net/24e991af9b9704ff1b2963fd2e999763.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77250c6dbf13b1b2955bf2f9ae44b454.jpg\" _src=\"http://yanxuan.nosdn.127.net/77250c6dbf13b1b2955bf2f9ae44b454.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7dedee5ad49f66f01f88c8cd94786c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7dedee5ad49f66f01f88c8cd94786c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c302e07c426c207a88ab703fda7f244.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c302e07c426c207a88ab703fda7f244.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5285d43ecccf0d28afcacccdc3054461.jpg\" _src=\"http://yanxuan.nosdn.127.net/5285d43ecccf0d28afcacccdc3054461.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24cc9d53907a67ee5564611f9649121f.jpg\" _src=\"http://yanxuan.nosdn.127.net/24cc9d53907a67ee5564611f9649121f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad70628c1f27db2afa22874e9fad72e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad70628c1f27db2afa22874e9fad72e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89277ed3ec4b8c34ae027c33d61cac53.jpg\" _src=\"http://yanxuan.nosdn.127.net/89277ed3ec4b8c34ae027c33d61cac53.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff64316933f4fa3b0991f2ddeff84f91.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff64316933f4fa3b0991f2ddeff84f91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/201299d3c5ec454b605b1ea23259a999.jpg\" _src=\"http://yanxuan.nosdn.127.net/201299d3c5ec454b605b1ea23259a999.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/471c49adb955692d6bf571ec78a45bed.jpg\" _src=\"http://yanxuan.nosdn.127.net/471c49adb955692d6bf571ec78a45bed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53b525a3b77c6a51a0f2629e1d4cec79.jpg\" _src=\"http://yanxuan.nosdn.127.net/53b525a3b77c6a51a0f2629e1d4cec79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10ed5f6502699bd5dbf451cf503f91a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/10ed5f6502699bd5dbf451cf503f91a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84b29a0e3877ce6a0c536e7de9451987.jpg\" _src=\"http://yanxuan.nosdn.127.net/84b29a0e3877ce6a0c536e7de9451987.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9518254ccd271857e43d5ebf8fa16cc9.jpg\" _src=\"http://yanxuan.nosdn.127.net/9518254ccd271857e43d5ebf8fa16cc9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8eda4c6e16f647c122c8e1fb72a5c296.jpg\" _src=\"http://yanxuan.nosdn.127.net/8eda4c6e16f647c122c8e1fb72a5c296.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9fa5cfdb4911b91bbb1ed617809dfd74.jpg\" _src=\"http://yanxuan.nosdn.127.net/9fa5cfdb4911b91bbb1ed617809dfd74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d5849257871c8cdd4cb35e8e012b4da.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d5849257871c8cdd4cb35e8e012b4da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29ad636afec8d03bda3074611b8b4a2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/29ad636afec8d03bda3074611b8b4a2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/163404e599ff0fd71396efaabb32f660.jpg\" _src=\"http://yanxuan.nosdn.127.net/163404e599ff0fd71396efaabb32f660.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7189a89979d51090a2c2492b716634f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7189a89979d51090a2c2492b716634f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d28aaf8c345118e16742dde54f2a70e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/d28aaf8c345118e16742dde54f2a70e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e31e9df5a49f85cc18676f4ce97d118.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e31e9df5a49f85cc18676f4ce97d118.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7aaed516f1280e923796c46b364fbc20.jpg\" _src=\"http://yanxuan.nosdn.127.net/7aaed516f1280e923796c46b364fbc20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bbb2299807545f2c96717276feb200a.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bbb2299807545f2c96717276feb200a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b6b989f53d9c5d9d5046226000c2f8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b6b989f53d9c5d9d5046226000c2f8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a04c82669e08d0f884db98a63d2d268.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a04c82669e08d0f884db98a63d2d268.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19e6c5e17ed0490eb761c4e9cc207d13.jpg\" _src=\"http://yanxuan.nosdn.127.net/19e6c5e17ed0490eb761c4e9cc207d13.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '17', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/32ba9417c9d31c6ea686ec842df3ca61.jpg', 'http://yanxuan.nosdn.127.net/a3a92057f10e5e6e804c19ef495e3dee.png', '399.00', '2156', '1095010', '0.00', '限时购', '', '0.00', '0', '0', '0', '438.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092001', '1012003', '1092001', '星空原色水晶笔', '0', '100', '', '140颗原色水晶，璀璨如星', '', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '支', 'http://yanxuan.nosdn.127.net/9e6857c9205ddd5129c47c6e23a1b67c.png', 'http://yanxuan.nosdn.127.net/8e35b003ce7895c39eeb073b1f61b1d7.png', '29.00', '15295', '1097001', '0.00', '限时购', '', '0.00', '0', '0', '0', '31.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092005', '1012003', '1092005', '木韵檀香黄铜笔', '0', '100', '', '缅甸黑檀与黄铜的结合，彰显贵气', '', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ab1992495e0370f09386d418ad45220d.png', 'http://yanxuan.nosdn.127.net/ab1992495e0370f09386d418ad45220d.png', '39.00', '3106', '1097008', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092024', '1008008', '1092024', '双宫茧纱布亲肤手工蚕丝被', '0', '100', '', '手工匠心织造', '<p><video id=\"tmpVedio0\" class=\"edui-upload-video video-js vjs-default-skin video-js\" controls=\"\" preload=\"auto\" width=\"100%\" height=\"\" data-setup=\"{}\"><source src=\"http://yanxuan.nosdn.127.net/4bc94a640a469e2a701f4530cbf2868d.mp4\" type=\"video/mp4\"/></video>‍</p><p><img src=\"http://yanxuan.nosdn.127.net/12cc61a27bc734434a218b8cc07b214d.jpg\" _src=\"http://yanxuan.nosdn.127.net/12cc61a27bc734434a218b8cc07b214d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/857fc6fa8911c6427797145b9bb6ae6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/857fc6fa8911c6427797145b9bb6ae6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a113e8c2e1623ed7bb40e9090cbe155f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a113e8c2e1623ed7bb40e9090cbe155f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0e4903bb5271b173cc4bb08c86f7e5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0e4903bb5271b173cc4bb08c86f7e5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d673570bf16e17d50154db6b374ac8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d673570bf16e17d50154db6b374ac8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6536dc0e19f54d7f71b3bb2ab400e81.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6536dc0e19f54d7f71b3bb2ab400e81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65bfe17e25d4f99f343cd9a98872f9b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/65bfe17e25d4f99f343cd9a98872f9b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b48eae0d7ea1fd323939ce05af73cbc1.jpg\" _src=\"http://yanxuan.nosdn.127.net/b48eae0d7ea1fd323939ce05af73cbc1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7a6edefc081c303c9ace62b2caa7ea6.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7a6edefc081c303c9ace62b2caa7ea6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e94d4d6abf57837c97c7bddfc19f2745.jpg\" _src=\"http://yanxuan.nosdn.127.net/e94d4d6abf57837c97c7bddfc19f2745.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42c9406a28fc6ccfa7e42a15ca01af02.jpg\" _src=\"http://yanxuan.nosdn.127.net/42c9406a28fc6ccfa7e42a15ca01af02.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f02cc82b2b34ecad3d9bdd8f2a8398c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f02cc82b2b34ecad3d9bdd8f2a8398c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c33ae57de042c04645ed74523ddfc00.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c33ae57de042c04645ed74523ddfc00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6b1c85d6f7eb06e90b2ec99ebb5ce6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6b1c85d6f7eb06e90b2ec99ebb5ce6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7d4be39f58a15e3af9c57c39934b020.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7d4be39f58a15e3af9c57c39934b020.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f6c12a01a43030328db2a6fea92a1a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f6c12a01a43030328db2a6fea92a1a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6922fe294f7968453fd50f7c9418d6c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6922fe294f7968453fd50f7c9418d6c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c54d9e1d0185acf9945f05773b45e336.jpg\" _src=\"http://yanxuan.nosdn.127.net/c54d9e1d0185acf9945f05773b45e336.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c84e42086bda07a42ab7957e86c3e8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c84e42086bda07a42ab7957e86c3e8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97905cbf70e960208ad59529e9c9d96a.jpg\" _src=\"http://yanxuan.nosdn.127.net/97905cbf70e960208ad59529e9c9d96a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d20ea3cf22532281f5220d68fd56644.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d20ea3cf22532281f5220d68fd56644.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4f6aa61c6cbd9d8307bbe3df248ac86.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4f6aa61c6cbd9d8307bbe3df248ac86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79af898960aeeeb5db1f93bad8b4f0c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/79af898960aeeeb5db1f93bad8b4f0c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7307f590b71f3c70e9190c23015f19f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7307f590b71f3c70e9190c23015f19f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70bab066f55050f2b2fa4e8f00bca265.jpg\" _src=\"http://yanxuan.nosdn.127.net/70bab066f55050f2b2fa4e8f00bca265.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/987835d0e28209afc539162b98a04cd9.jpg\" _src=\"http://yanxuan.nosdn.127.net/987835d0e28209afc539162b98a04cd9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f3b06b5934aeac4efe1755d3a987c30.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f3b06b5934aeac4efe1755d3a987c30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e27f4183d153a8cbf1a16acdfd171fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e27f4183d153a8cbf1a16acdfd171fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3faa2a006894691dc2dd0a47718645f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3faa2a006894691dc2dd0a47718645f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/230c7610de70ed83974dd4a57d0c700d.jpg\" _src=\"http://yanxuan.nosdn.127.net/230c7610de70ed83974dd4a57d0c700d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ecd9596f63b87c230ddab5b55a60f813.jpg\" _src=\"http://yanxuan.nosdn.127.net/ecd9596f63b87c230ddab5b55a60f813.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/96690003d2be2183f78e6ca88816ec8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/96690003d2be2183f78e6ca88816ec8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f94a58279084fa70e89124c135aaf48c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f94a58279084fa70e89124c135aaf48c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ac85b85d16ff2953fe0183a2c3fab2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ac85b85d16ff2953fe0183a2c3fab2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b43e793f03e20d8201dac6dd01d73215.jpg\" _src=\"http://yanxuan.nosdn.127.net/b43e793f03e20d8201dac6dd01d73215.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/725eaaa2edfaa0fd6688bb0a16acf7fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/725eaaa2edfaa0fd6688bb0a16acf7fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a142ec7e60d0f510b8b7dffd66f8e8c.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a142ec7e60d0f510b8b7dffd66f8e8c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a79e2c1314034c20fd77372c8f83a924.jpg\" _src=\"http://yanxuan.nosdn.127.net/a79e2c1314034c20fd77372c8f83a924.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ce918f1fd0486e1e3dab4ce2edbece9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ce918f1fd0486e1e3dab4ce2edbece9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/464019e51c20c47849f92a319c1c6b6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/464019e51c20c47849f92a319c1c6b6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd1ca477443ea80dd310cc0c8c903b82.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd1ca477443ea80dd310cc0c8c903b82.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5ed5e4827c7623fa0d4f360a10ee109.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5ed5e4827c7623fa0d4f360a10ee109.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eccc71760c31e25893235d11ff1310cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/eccc71760c31e25893235d11ff1310cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/059ca713a16298bb62d8b11fd91e5b2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/059ca713a16298bb62d8b11fd91e5b2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36ae5438953dcbdb77b237d4ec6cfea1.jpg\" _src=\"http://yanxuan.nosdn.127.net/36ae5438953dcbdb77b237d4ec6cfea1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5a1253ad74f94865c4f87ddc69ac721.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5a1253ad74f94865c4f87ddc69ac721.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/765a73c655c2636eb4c6cb30e54a076b.jpg\" _src=\"http://yanxuan.nosdn.127.net/765a73c655c2636eb4c6cb30e54a076b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f11a95cd2c22e3397bff05606658a2c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f11a95cd2c22e3397bff05606658a2c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b14601b0465dbfb498c8d090c6a0795.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b14601b0465dbfb498c8d090c6a0795.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b9e0ebcd78cc2b783c5a7a4ad96466a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b9e0ebcd78cc2b783c5a7a4ad96466a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/083e4d0fe87c59d1c34b9929417acfa4.jpg\" _src=\"http://yanxuan.nosdn.127.net/083e4d0fe87c59d1c34b9929417acfa4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0dd4f4f8efc6846f7cc874e36c96a5f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0dd4f4f8efc6846f7cc874e36c96a5f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24821c54966d1405a7a289475d68b78a.jpg\" _src=\"http://yanxuan.nosdn.127.net/24821c54966d1405a7a289475d68b78a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d3e5ce1382e33bd6b323e58613dc389.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d3e5ce1382e33bd6b323e58613dc389.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '14', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e76350101d1047dd463693ac84059b7c.png', 'http://yanxuan.nosdn.127.net/f245a86dcb9f455217241e437b203926.png', '1599.00', '254', '1097151', '0.00', '限时购', '', '0.00', '0', '0', '0', '1758.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092025', '1010002', '1092025', 'Let it go男式纯棉免洗内裤', '0', '100', '', '伽玛射线安心杀菌', '', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/3006cf6f854372683143571d3595dafc.jpg', 'http://yanxuan.nosdn.127.net/56a46e9a4832587471c0f9ad7c1b7d85.png', '19.90', '5656', '1097153', '0.00', '限时购', '', '0.00', '0', '0', '0', '21.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092026', '1010002', '1092026', 'Let it go女式纯棉免洗内裤', '0', '100', '', '100%纯棉，出行必备', '', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/203781d76d1b4dedf50fd769be857426.jpg', 'http://yanxuan.nosdn.127.net/83433f5a7ef69abda2544a53332a0fad.png', '19.90', '4144', '1097157', '0.00', '限时购', '', '0.00', '0', '0', '0', '21.89', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092038', '1017000', '1092038', '日式天然桐木材质猫抓板', '0', '100', '', '天然桐木，耐磨耐抓', '<p><img src=\"http://yanxuan.nosdn.127.net/8e51b9b1ead5c197d62182de7f62dab8.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e51b9b1ead5c197d62182de7f62dab8.jpg\"/></p>', '1', '2017-08-30 11:40:11', '19', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/dd05b05070823563f646e6b0f5695f4a.jpg', 'http://yanxuan.nosdn.127.net/1aba9ed9c9160b9ca8e7de58ce4e46b1.png', '39.00', '136', '1097179', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1092039', '1017000', '1092039', '圆钵碗状高密材质猫抓板', '0', '100', '', '可抓可睡，一物两用', '<p><img src=\"http://yanxuan.nosdn.127.net/7f5a8783df659ea49722ea12304a5f63.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f5a8783df659ea49722ea12304a5f63.jpg\"/></p>', '1', '2017-08-30 11:40:11', '18', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0c961fa406197165cd8c418d8a2f44e0.jpg', 'http://yanxuan.nosdn.127.net/d8c18953bcb05f0b07d6b48e2d159ace.png', '59.00', '583', '1097180', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1093000', '1011004', '1093000', '月光曲·小木棉', '0', '100', '', '仿真PU，定格典雅', '<p><img src=\"http://yanxuan.nosdn.127.net/5b4f7b1c7645b54fb9135631775c44d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b4f7b1c7645b54fb9135631775c44d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/215030eb837b8d81ffa35de802dfb201.jpg\" _src=\"http://yanxuan.nosdn.127.net/215030eb837b8d81ffa35de802dfb201.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9746b52778ec414fe557a7e9e6bb61c.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9746b52778ec414fe557a7e9e6bb61c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd8f269e2deb6d90ddb7e8f8ea2d96f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd8f269e2deb6d90ddb7e8f8ea2d96f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30e8a8c6694f40c9bef39b32e0bb7721.jpg\" _src=\"http://yanxuan.nosdn.127.net/30e8a8c6694f40c9bef39b32e0bb7721.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21bf19b684b80bb2d8ef8661d65d15df.jpg\" _src=\"http://yanxuan.nosdn.127.net/21bf19b684b80bb2d8ef8661d65d15df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1fc84555c266ad2b42ea7d14809292e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/1fc84555c266ad2b42ea7d14809292e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8b2d5eba9a2812870446dce43ea9111.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8b2d5eba9a2812870446dce43ea9111.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/519eb590f329bd330622a4443d52e21c.jpg\" _src=\"http://yanxuan.nosdn.127.net/519eb590f329bd330622a4443d52e21c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8bfe63c2eae43aab178e4eb08ae2294.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8bfe63c2eae43aab178e4eb08ae2294.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f837236ac348079f3910389c3bdadd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f837236ac348079f3910389c3bdadd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2de72436183e808a6da615cdb4743c87.jpg\" _src=\"http://yanxuan.nosdn.127.net/2de72436183e808a6da615cdb4743c87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3138859c5896d0726e3b7186ac73f34d.jpg\" _src=\"http://yanxuan.nosdn.127.net/3138859c5896d0726e3b7186ac73f34d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/048abf054bd0373015abe44c8455b707.jpg\" _src=\"http://yanxuan.nosdn.127.net/048abf054bd0373015abe44c8455b707.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d96ec29f78f8043ec48713a11deb52d.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d96ec29f78f8043ec48713a11deb52d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2493c9d7c48ee6ee53d12e946e8e4a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2493c9d7c48ee6ee53d12e946e8e4a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b937b14bf953bd64c5362353b8f5e055.jpg\" _src=\"http://yanxuan.nosdn.127.net/b937b14bf953bd64c5362353b8f5e055.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd6ff3a660a801918df6c01bf72ed27c.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd6ff3a660a801918df6c01bf72ed27c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c215983e1f557db16b5db9f7e51ff14b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c215983e1f557db16b5db9f7e51ff14b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37730a86094625aae577ad68ebfb8253.jpg\" _src=\"http://yanxuan.nosdn.127.net/37730a86094625aae577ad68ebfb8253.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bde8a403526d11c307223a0253267a5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/bde8a403526d11c307223a0253267a5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0cd087a4443af8330dc7654648e88fec.jpg\" _src=\"http://yanxuan.nosdn.127.net/0cd087a4443af8330dc7654648e88fec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58f62a0d9ddcc8c0dd8d505005f3107c.jpg\" _src=\"http://yanxuan.nosdn.127.net/58f62a0d9ddcc8c0dd8d505005f3107c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33d0518f396b352c061c7b695194bc0a.jpg\" _src=\"http://yanxuan.nosdn.127.net/33d0518f396b352c061c7b695194bc0a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/330d0261403d9d0ad11405d19d6bc15f.jpg\" _src=\"http://yanxuan.nosdn.127.net/330d0261403d9d0ad11405d19d6bc15f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6974e3ab2f18401859d4391958b344a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/6974e3ab2f18401859d4391958b344a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac3159d7d6cc48f952bad1c4586c04d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac3159d7d6cc48f952bad1c4586c04d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28c2321f53984accfcdc0cdf2761fbc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/28c2321f53984accfcdc0cdf2761fbc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae31796c18b3ed25687e6fd12cb50c9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae31796c18b3ed25687e6fd12cb50c9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a2b3a9b6aa7117d4bc67a516365b0c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a2b3a9b6aa7117d4bc67a516365b0c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fba9ea69f30ed059eea01934157e7016.jpg\" _src=\"http://yanxuan.nosdn.127.net/fba9ea69f30ed059eea01934157e7016.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03b99b6c2ce16be772f09ee09356916d.jpg\" _src=\"http://yanxuan.nosdn.127.net/03b99b6c2ce16be772f09ee09356916d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84b115d9acbaab972286dda97c1661e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/84b115d9acbaab972286dda97c1661e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5602f58cda58b4e7bad9cb248732e97f.jpg\" _src=\"http://yanxuan.nosdn.127.net/5602f58cda58b4e7bad9cb248732e97f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18ed6a3403fb96e1bd208d393b1dcc5b.jpg\" _src=\"http://yanxuan.nosdn.127.net/18ed6a3403fb96e1bd208d393b1dcc5b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37369ac790686de9cf0ddea2af1d045e.jpg\" _src=\"http://yanxuan.nosdn.127.net/37369ac790686de9cf0ddea2af1d045e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f57fa2a4c5fe4ca90480b619c0d188de.jpg\" _src=\"http://yanxuan.nosdn.127.net/f57fa2a4c5fe4ca90480b619c0d188de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d21c94dc65efb8c92eeafb3ee1f75b79.jpg\" _src=\"http://yanxuan.nosdn.127.net/d21c94dc65efb8c92eeafb3ee1f75b79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae0d16dfa896f2b5a4681de0621870ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae0d16dfa896f2b5a4681de0621870ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ea54974c6f8eec823382abb383057f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ea54974c6f8eec823382abb383057f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/294e9a51f1692b456dfac753b46fa4c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/294e9a51f1692b456dfac753b46fa4c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8043ad0af70f60c9df2d2969de73c409.jpg\" _src=\"http://yanxuan.nosdn.127.net/8043ad0af70f60c9df2d2969de73c409.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16f8a25987a31126420e3dee1c850cb1.jpg\" _src=\"http://yanxuan.nosdn.127.net/16f8a25987a31126420e3dee1c850cb1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81ada0d29e8f96a844e3adce2b850c4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/81ada0d29e8f96a844e3adce2b850c4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f40c62bd5e57b10992486fd76c8c3a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f40c62bd5e57b10992486fd76c8c3a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2310c4f5f74a4fc252e8850cab0753b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2310c4f5f74a4fc252e8850cab0753b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/440ce6f17e9f55a2cb4ab75c67a11b72.jpg\" _src=\"http://yanxuan.nosdn.127.net/440ce6f17e9f55a2cb4ab75c67a11b72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eae892cfc10fa235e10a2146e4c62f18.jpg\" _src=\"http://yanxuan.nosdn.127.net/eae892cfc10fa235e10a2146e4c62f18.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0ef2820f6d6283cc05b968d1835cfe9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0ef2820f6d6283cc05b968d1835cfe9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ecc99d34f2974f50abcb75006eb1dee.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ecc99d34f2974f50abcb75006eb1dee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/710b02daf30326f75d0029da0651c953.jpg\" _src=\"http://yanxuan.nosdn.127.net/710b02daf30326f75d0029da0651c953.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07c00e8f2b7ae873c5478b80c65f247e.jpg\" _src=\"http://yanxuan.nosdn.127.net/07c00e8f2b7ae873c5478b80c65f247e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae6cf1147c23c8b0911346923a5602cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae6cf1147c23c8b0911346923a5602cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d2a31a9030beea78d1780a607647090.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d2a31a9030beea78d1780a607647090.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee86a9cc0d7dddc47ddef5ca69a166ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee86a9cc0d7dddc47ddef5ca69a166ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9b13a8de3031bbf68600acf1060a862.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9b13a8de3031bbf68600acf1060a862.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e7e5d9292e77c82fdc20b7e2d2abfc1.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e7e5d9292e77c82fdc20b7e2d2abfc1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52aff3d2d7f6737fed6c06e475b1a6d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/52aff3d2d7f6737fed6c06e475b1a6d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bea2212caf8f2760084d06bf2f15910.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bea2212caf8f2760084d06bf2f15910.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/edef2d2f9f2b032429dc141089a85664.jpg\" _src=\"http://yanxuan.nosdn.127.net/edef2d2f9f2b032429dc141089a85664.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/175f2c644c3238f1af8c23cf91c34d23.jpg\" _src=\"http://yanxuan.nosdn.127.net/175f2c644c3238f1af8c23cf91c34d23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79bd08c21f83de81caa65bf38f14c750.jpg\" _src=\"http://yanxuan.nosdn.127.net/79bd08c21f83de81caa65bf38f14c750.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/655320ee6dc49430442fbba81e44c41a.jpg\" _src=\"http://yanxuan.nosdn.127.net/655320ee6dc49430442fbba81e44c41a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28a8c402c42e9671591167ab49ba6857.jpg\" _src=\"http://yanxuan.nosdn.127.net/28a8c402c42e9671591167ab49ba6857.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0eb1cb510d5f338af2b595d30da49b7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0eb1cb510d5f338af2b595d30da49b7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68a6ec175d2c46f0162f8de63add1189.jpg\" _src=\"http://yanxuan.nosdn.127.net/68a6ec175d2c46f0162f8de63add1189.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0c72d3e82a13c65ef52d5a09f178d2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0c72d3e82a13c65ef52d5a09f178d2e.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2bbce4c2af1a9933d3e9a5132ff42a01.jpg', 'http://yanxuan.nosdn.127.net/1a22cc488390b616e75afbbd94db6584.png', '39.00', '8067', '1098000', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1093001', '1011004', '1093001', '月光曲·马蹄莲', '0', '100', '', '仿真PU，定格典雅', '<p>*温馨提示：若马蹄莲有些褶皱，可将白色花朵部分放入60-70℃的水中热10秒立刻拿出，可恢复原状。</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; （注意：只针对马蹄莲白色花朵部分）</p><p><img src=\"http://yanxuan.nosdn.127.net/14c4de5b68fb2020a0264babd024c603.jpg\" _src=\"http://yanxuan.nosdn.127.net/14c4de5b68fb2020a0264babd024c603.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7d4c10f37efe62df82a9d9ddcf5391d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7d4c10f37efe62df82a9d9ddcf5391d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88704a0306ac60f7ed5465f1a52f7a97.jpg\" _src=\"http://yanxuan.nosdn.127.net/88704a0306ac60f7ed5465f1a52f7a97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e6f63dc6bd213450ee31307d521fc50.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e6f63dc6bd213450ee31307d521fc50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/843c898a55f5ba807ccfcde8171f6ab5.jpg\" _src=\"http://yanxuan.nosdn.127.net/843c898a55f5ba807ccfcde8171f6ab5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe488f44863e3b1b55a94a8fb7d66468.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe488f44863e3b1b55a94a8fb7d66468.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86ea4ad80d5d9eb678f5845c5bd1f3df.jpg\" _src=\"http://yanxuan.nosdn.127.net/86ea4ad80d5d9eb678f5845c5bd1f3df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/507427743783c8ad1e1e7acefe7ab16e.jpg\" _src=\"http://yanxuan.nosdn.127.net/507427743783c8ad1e1e7acefe7ab16e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/087ac3cee9d8bd4656969f40ff05bde1.jpg\" _src=\"http://yanxuan.nosdn.127.net/087ac3cee9d8bd4656969f40ff05bde1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5756bce5084f0da0d65ee9ba2ac40a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5756bce5084f0da0d65ee9ba2ac40a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3823255dce16fc44337599b63351b02b.jpg\" _src=\"http://yanxuan.nosdn.127.net/3823255dce16fc44337599b63351b02b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b152b2d010f933f515059e3ed9758b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b152b2d010f933f515059e3ed9758b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fa95525f3e21af9ce526d27581cec4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fa95525f3e21af9ce526d27581cec4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e997646bc2f741071b5f06fedc2a409f.jpg\" _src=\"http://yanxuan.nosdn.127.net/e997646bc2f741071b5f06fedc2a409f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/360ca78e2b931542a920ac7219e93ad3.jpg\" _src=\"http://yanxuan.nosdn.127.net/360ca78e2b931542a920ac7219e93ad3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e17fba13878001812d33e60c53a5bb0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e17fba13878001812d33e60c53a5bb0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b603073a532c7d16df0b09ff196d9516.jpg\" _src=\"http://yanxuan.nosdn.127.net/b603073a532c7d16df0b09ff196d9516.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d14ee677f0cbad8146478f9bdf80b39.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d14ee677f0cbad8146478f9bdf80b39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbb4839d17e5a4b49b16c2cb2a7a0bac.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbb4839d17e5a4b49b16c2cb2a7a0bac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6e04bfeaa2be740610fb9ce274dcfed.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6e04bfeaa2be740610fb9ce274dcfed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/456c0767ef28a4ffd52bfdf2339998e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/456c0767ef28a4ffd52bfdf2339998e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7fa3373676f27f95c5dff94f7bf5b42.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7fa3373676f27f95c5dff94f7bf5b42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45b2e9c89455735fba95f9c75e0c99a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/45b2e9c89455735fba95f9c75e0c99a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e7c23c1da969d6a92ecbad43a0f10e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e7c23c1da969d6a92ecbad43a0f10e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbad0ce217bb20c7d93292ee789492f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbad0ce217bb20c7d93292ee789492f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78b3c74a0fdf05bfcf62730c535ef2fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/78b3c74a0fdf05bfcf62730c535ef2fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b76a95e96b3f862486bee6dfbaccdaab.jpg\" _src=\"http://yanxuan.nosdn.127.net/b76a95e96b3f862486bee6dfbaccdaab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ca838cfde190a22fa2ad0f8d55971b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ca838cfde190a22fa2ad0f8d55971b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15f3d4996d1cba52763c30f26a78a04f.jpg\" _src=\"http://yanxuan.nosdn.127.net/15f3d4996d1cba52763c30f26a78a04f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a2172c4f6744c1024079b48554907ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a2172c4f6744c1024079b48554907ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/303125108bdfd52bcab6dfb1b0bd7029.jpg\" _src=\"http://yanxuan.nosdn.127.net/303125108bdfd52bcab6dfb1b0bd7029.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83d7090ea963d133103a3bfcac61484d.jpg\" _src=\"http://yanxuan.nosdn.127.net/83d7090ea963d133103a3bfcac61484d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eea591cfebdbb6cba0ae856e9a02894e.jpg\" _src=\"http://yanxuan.nosdn.127.net/eea591cfebdbb6cba0ae856e9a02894e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab2cca8081ab4028778789e84b4a8c07.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab2cca8081ab4028778789e84b4a8c07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12b1054eef2e784a993b4ccd01f240e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/12b1054eef2e784a993b4ccd01f240e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cde59e5ca29d69227359e0e326d6ff8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/cde59e5ca29d69227359e0e326d6ff8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/143ab0a0996071b335a20543ce9b7859.jpg\" _src=\"http://yanxuan.nosdn.127.net/143ab0a0996071b335a20543ce9b7859.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2bba82dcc5d4e446999fd2f53feea873.jpg\" _src=\"http://yanxuan.nosdn.127.net/2bba82dcc5d4e446999fd2f53feea873.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ed53aff4e1511efbbb44276b86c04f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ed53aff4e1511efbbb44276b86c04f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7873136c7901142199933d698f8857c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/7873136c7901142199933d698f8857c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/35c9d0b967485ff7f6197c2767578271.jpg\" _src=\"http://yanxuan.nosdn.127.net/35c9d0b967485ff7f6197c2767578271.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c7751f977b560b203978f53dd784f77.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c7751f977b560b203978f53dd784f77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/251f3e1aa29dfeef37a2c44f315a87d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/251f3e1aa29dfeef37a2c44f315a87d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66d17ca9055cd144fea50657ea55d89a.jpg\" _src=\"http://yanxuan.nosdn.127.net/66d17ca9055cd144fea50657ea55d89a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3351f1a84e9700554add7719325ee7d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/3351f1a84e9700554add7719325ee7d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e647f67fd2581fdde7b77a6f4ba76f8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e647f67fd2581fdde7b77a6f4ba76f8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/409de727c8353a60b27545ee1f4c9f62.jpg\" _src=\"http://yanxuan.nosdn.127.net/409de727c8353a60b27545ee1f4c9f62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd1705c641c3d1dc20d21ca02a45d57c.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd1705c641c3d1dc20d21ca02a45d57c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1baac00858cd4e174301490c05aa2547.jpg\" _src=\"http://yanxuan.nosdn.127.net/1baac00858cd4e174301490c05aa2547.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9233b3612f978c00ca77b2bbb6258a17.jpg\" _src=\"http://yanxuan.nosdn.127.net/9233b3612f978c00ca77b2bbb6258a17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66925098d2c2bf8e6371395a74e5fd75.jpg\" _src=\"http://yanxuan.nosdn.127.net/66925098d2c2bf8e6371395a74e5fd75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5d209471e5d4c7f3cd44abcd969f017.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5d209471e5d4c7f3cd44abcd969f017.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54f7aa76e034ea98467e172e5247b52a.jpg\" _src=\"http://yanxuan.nosdn.127.net/54f7aa76e034ea98467e172e5247b52a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8871ba3e623365c2f0a5bfcbcfcc7df2.jpg\" _src=\"http://yanxuan.nosdn.127.net/8871ba3e623365c2f0a5bfcbcfcc7df2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73353926afed90979ceb13f8db3cd789.jpg\" _src=\"http://yanxuan.nosdn.127.net/73353926afed90979ceb13f8db3cd789.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/14b420eb5422c73774020c2656ba9713.jpg', 'http://yanxuan.nosdn.127.net/71fede861c3641d570a89a65ccf4525f.png', '29.00', '7936', '1098001', '0.00', '限时购', '', '0.00', '0', '0', '0', '31.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1093002', '1011004', '1093002', '月光曲·清水木棉', '0', '100', '', '仿真之美裹于精致玻璃', '<p><img src=\"http://yanxuan.nosdn.127.net/f7344fa03430c9e7608924f2396e9a3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7344fa03430c9e7608924f2396e9a3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae8b2c0ab30afa202bb6569bc64fb05c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae8b2c0ab30afa202bb6569bc64fb05c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/260a1043d33c23222d0a643bcb78efa5.jpg\" _src=\"http://yanxuan.nosdn.127.net/260a1043d33c23222d0a643bcb78efa5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2ac6fa26b02ccac9e77f469f2f81627.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2ac6fa26b02ccac9e77f469f2f81627.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f7db39e5c98c07104cfb1838b3a4606.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f7db39e5c98c07104cfb1838b3a4606.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03cd25c518409a45a6c6d22a6bb36f6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/03cd25c518409a45a6c6d22a6bb36f6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/baa155140eaf7efbdd7dcdba00bb1c59.jpg\" _src=\"http://yanxuan.nosdn.127.net/baa155140eaf7efbdd7dcdba00bb1c59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c9c6b4b7af2cf108b50d17015247429.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c9c6b4b7af2cf108b50d17015247429.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0fcd1ec7c1d0f5bf74a6ecdc288e9ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0fcd1ec7c1d0f5bf74a6ecdc288e9ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8692aa87d719cb0b6e8e850b415d33ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/8692aa87d719cb0b6e8e850b415d33ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53ee60e2f229f6186f4b14ff2b28359d.jpg\" _src=\"http://yanxuan.nosdn.127.net/53ee60e2f229f6186f4b14ff2b28359d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e348fd6476d54cedb1acbef6510e4d59.jpg\" _src=\"http://yanxuan.nosdn.127.net/e348fd6476d54cedb1acbef6510e4d59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b70cf32a96e3ba24d7d73d0d0b573d68.jpg\" _src=\"http://yanxuan.nosdn.127.net/b70cf32a96e3ba24d7d73d0d0b573d68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f16474f1734554a39faad2c49d3e3367.jpg\" _src=\"http://yanxuan.nosdn.127.net/f16474f1734554a39faad2c49d3e3367.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5b24698379ac242008ccd444c34ca37.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5b24698379ac242008ccd444c34ca37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/932dea95459ae481bad1adca3f649ab4.jpg\" _src=\"http://yanxuan.nosdn.127.net/932dea95459ae481bad1adca3f649ab4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1961bd3fbd169f3a9da38a33a52bdb95.jpg\" _src=\"http://yanxuan.nosdn.127.net/1961bd3fbd169f3a9da38a33a52bdb95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/27122c54b2745f10b655a018ef167c94.jpg\" _src=\"http://yanxuan.nosdn.127.net/27122c54b2745f10b655a018ef167c94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/958e02ebbde0e4e79805b0ab6cff54e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/958e02ebbde0e4e79805b0ab6cff54e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a08733dc5f74f2be9e554f8a9721623.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a08733dc5f74f2be9e554f8a9721623.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1a9b63938e248d83c6ef21db2ab5464.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1a9b63938e248d83c6ef21db2ab5464.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/acf2bc7c117b0619bcc0d4a2f77688a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/acf2bc7c117b0619bcc0d4a2f77688a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/af956b451c2f5c710e5802ca264ace3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/af956b451c2f5c710e5802ca264ace3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a57eebbc20487a9627ed72efbaf77e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a57eebbc20487a9627ed72efbaf77e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/811d0feee6b594580828d1c0afa87004.jpg\" _src=\"http://yanxuan.nosdn.127.net/811d0feee6b594580828d1c0afa87004.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6094507a642ad35bcc6ff6094f786d46.jpg\" _src=\"http://yanxuan.nosdn.127.net/6094507a642ad35bcc6ff6094f786d46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc959993726c6f756923ab3a7e79f8ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc959993726c6f756923ab3a7e79f8ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/847af1884da2988cb7dc72f4205bcbf7.jpg\" _src=\"http://yanxuan.nosdn.127.net/847af1884da2988cb7dc72f4205bcbf7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3cb47e4ab1d7afd5a61b548007a302d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3cb47e4ab1d7afd5a61b548007a302d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/947c55e2df37a5806f1a2ea87cf4a8d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/947c55e2df37a5806f1a2ea87cf4a8d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9dea6bc310ebe6872a7655c550d825fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/9dea6bc310ebe6872a7655c550d825fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6890ba6f04ed5574c92cb2b24aaeb5f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/6890ba6f04ed5574c92cb2b24aaeb5f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fc24ce0bb5969bd6774a8528cebfde5.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fc24ce0bb5969bd6774a8528cebfde5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d2c69d95f89632b0dcf342ddfe41def.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d2c69d95f89632b0dcf342ddfe41def.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/147cb97075af63e6001701f73be05869.jpg\" _src=\"http://yanxuan.nosdn.127.net/147cb97075af63e6001701f73be05869.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6006af9450c3e705aa8492102c33313.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6006af9450c3e705aa8492102c33313.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1f8b607eeca99a57915539207225fb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1f8b607eeca99a57915539207225fb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c11c60ac99591a6c38c285adc14c62.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c11c60ac99591a6c38c285adc14c62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/072092ff06a84465883a9c0666bb7c41.jpg\" _src=\"http://yanxuan.nosdn.127.net/072092ff06a84465883a9c0666bb7c41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6075177496003cb2a873425f315c0ac0.jpg\" _src=\"http://yanxuan.nosdn.127.net/6075177496003cb2a873425f315c0ac0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad8b5858463e737515b52fd566ce3443.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad8b5858463e737515b52fd566ce3443.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fa88a238b9d4ff1ed3c527bcb54cdbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fa88a238b9d4ff1ed3c527bcb54cdbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e73c0d99a3934634ab3f05d03c7b4bb6.jpg\" _src=\"http://yanxuan.nosdn.127.net/e73c0d99a3934634ab3f05d03c7b4bb6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fe3d07b6291ad7c72fdf11df14642bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fe3d07b6291ad7c72fdf11df14642bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da37af40f71b3b5d1ace9badecc6f452.jpg\" _src=\"http://yanxuan.nosdn.127.net/da37af40f71b3b5d1ace9badecc6f452.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43c18f4ddf398f8191f32453207fd7c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/43c18f4ddf398f8191f32453207fd7c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/795cb1b99501a45b51cb948132d4478e.jpg\" _src=\"http://yanxuan.nosdn.127.net/795cb1b99501a45b51cb948132d4478e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b83c807d156eafcd75f2302cff0c335.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b83c807d156eafcd75f2302cff0c335.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3af7559bee8204a678915ff745cb0db9.jpg\" _src=\"http://yanxuan.nosdn.127.net/3af7559bee8204a678915ff745cb0db9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea4fb92585ea1b42f52974aeb6533359.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea4fb92585ea1b42f52974aeb6533359.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5801bc264a549ccc28c8a6cbbc586070.jpg\" _src=\"http://yanxuan.nosdn.127.net/5801bc264a549ccc28c8a6cbbc586070.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dab91f751ac4a3142ed4ebb5239b73b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/dab91f751ac4a3142ed4ebb5239b73b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b4f2fd647fd9816dc5ce9fa7520ee24b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b4f2fd647fd9816dc5ce9fa7520ee24b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f693ee866e239666f5c7257f5380149.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f693ee866e239666f5c7257f5380149.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2b0154f00a81c2a4d5f2c4bdfcc2e4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2b0154f00a81c2a4d5f2c4bdfcc2e4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/078b0baa26bfe33f8517425717904217.jpg\" _src=\"http://yanxuan.nosdn.127.net/078b0baa26bfe33f8517425717904217.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8722ea6b8b94a084327f43652bd36725.jpg\" _src=\"http://yanxuan.nosdn.127.net/8722ea6b8b94a084327f43652bd36725.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12afaa904d2bf4d1b99c952b48b41877.jpg\" _src=\"http://yanxuan.nosdn.127.net/12afaa904d2bf4d1b99c952b48b41877.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dba1cc41d9cba2118ef0c6acfb3bf7e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/dba1cc41d9cba2118ef0c6acfb3bf7e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5cbff5bda3610d137839e60d19b70a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5cbff5bda3610d137839e60d19b70a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85db07bb2753c51424187d62baff36e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/85db07bb2753c51424187d62baff36e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e85b5b64edc6e9254fa9291b58a94aa5.jpg\" _src=\"http://yanxuan.nosdn.127.net/e85b5b64edc6e9254fa9291b58a94aa5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b64f9e066aa66161b05d2e055739599e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b64f9e066aa66161b05d2e055739599e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9ba60f428dbb09d44a0480073a96e04.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9ba60f428dbb09d44a0480073a96e04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dade0ed72bae5bfa019ba89db5c91bb5.jpg\" _src=\"http://yanxuan.nosdn.127.net/dade0ed72bae5bfa019ba89db5c91bb5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ebc93b3376de58dd6cead7568c97a1d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ebc93b3376de58dd6cead7568c97a1d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/763f44ffec9e182324b46f1c4aeb0ae0.jpg\" _src=\"http://yanxuan.nosdn.127.net/763f44ffec9e182324b46f1c4aeb0ae0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da4fce648e13fc32865f9eb812de0ca7.jpg\" _src=\"http://yanxuan.nosdn.127.net/da4fce648e13fc32865f9eb812de0ca7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f435576c31011da4bfdd5eb8812f01d.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f435576c31011da4bfdd5eb8812f01d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34591cf9ab39eea855ff37b4998a432e.jpg\" _src=\"http://yanxuan.nosdn.127.net/34591cf9ab39eea855ff37b4998a432e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f84d00a688840605788645d41397849.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f84d00a688840605788645d41397849.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f8d4e0cc9f80cb99c5c2073fd31f75f.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f8d4e0cc9f80cb99c5c2073fd31f75f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b099f7cc6fd06976edd575cafad2c49.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b099f7cc6fd06976edd575cafad2c49.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e7cb7b9ac22d6593f71672b121190c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e7cb7b9ac22d6593f71672b121190c3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/45dfa4d8dd08ea63b3d9e285321cd42e.jpg', 'http://yanxuan.nosdn.127.net/48d95e820628610fcdcda30570d4379c.png', '49.00', '7868', '1098002', '0.00', '限时购', '', '0.00', '0', '0', '0', '53.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097004', '1015000', '1097004', '原素系列实木餐桌', '0', '100', '', '素雅大气，结实不易蛀', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/6c2a6e4ab8410fc01ee9772c6f90db11.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c2a6e4ab8410fc01ee9772c6f90db11.jpg\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c336a3e114806ba1518ccf3c6ff896d.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c336a3e114806ba1518ccf3c6ff896d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/423aad8253c881d42cd6cfde720828da.jpg\" _src=\"http://yanxuan.nosdn.127.net/423aad8253c881d42cd6cfde720828da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c915ce02ff7f9783ae08569f06bbb445.jpg\" _src=\"http://yanxuan.nosdn.127.net/c915ce02ff7f9783ae08569f06bbb445.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64bc73e530ef711c2fba02419adb0b20.jpg\" _src=\"http://yanxuan.nosdn.127.net/64bc73e530ef711c2fba02419adb0b20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18345b24e0209b903e31220ba57db7b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/18345b24e0209b903e31220ba57db7b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f82c372b1b5c9bd66d4f3369fc6e1e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f82c372b1b5c9bd66d4f3369fc6e1e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb98016f6c38442d901fa2b2b59aa763.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb98016f6c38442d901fa2b2b59aa763.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a498b82e14c46990fb162769922a3eb4.jpg\" _src=\"http://yanxuan.nosdn.127.net/a498b82e14c46990fb162769922a3eb4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d6e780e10d1e056b4d3999e41818b93.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d6e780e10d1e056b4d3999e41818b93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49387dc0b6355987a1d0beb2e44a1da4.jpg\" _src=\"http://yanxuan.nosdn.127.net/49387dc0b6355987a1d0beb2e44a1da4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f18bb9ce939d41b9e4bc16cfe5bc149.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f18bb9ce939d41b9e4bc16cfe5bc149.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e29f895f252d524000649fb12d8e6b15.jpg\" _src=\"http://yanxuan.nosdn.127.net/e29f895f252d524000649fb12d8e6b15.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2aaec92e2c3eb4b5b5a4af569b0112c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/2aaec92e2c3eb4b5b5a4af569b0112c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d24e2d4396e738ffce8ded6edbd6300.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d24e2d4396e738ffce8ded6edbd6300.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fba99f330ddecc723486dbdc78ad618.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fba99f330ddecc723486dbdc78ad618.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f34b5ddf302a3f19d04658183911b4e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/f34b5ddf302a3f19d04658183911b4e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3db899639cb936346e9df8fe1d2a431e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3db899639cb936346e9df8fe1d2a431e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3b73b7d54b288e4c88267d13c0cbe7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3b73b7d54b288e4c88267d13c0cbe7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf008f5a39595bb04c2843a161ef3987.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf008f5a39595bb04c2843a161ef3987.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a723cce55e61ee5181fa4e9a0b9ede76.jpg\" _src=\"http://yanxuan.nosdn.127.net/a723cce55e61ee5181fa4e9a0b9ede76.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/569c07bcc8b94c489b09fedb61c7c079.jpg\" _src=\"http://yanxuan.nosdn.127.net/569c07bcc8b94c489b09fedb61c7c079.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eabc085eb1720439aeea147ab30c86aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/eabc085eb1720439aeea147ab30c86aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6128be9204c1ef1e3ad44a85869a5b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6128be9204c1ef1e3ad44a85869a5b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/159659f7d3bd9f9bdc6225412f3f674c.jpg\" _src=\"http://yanxuan.nosdn.127.net/159659f7d3bd9f9bdc6225412f3f674c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81ca9c36f02b6592a4b4a1f6cc21c0bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/81ca9c36f02b6592a4b4a1f6cc21c0bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2ee52e0fd46a1b9e810b6cff80080f11.jpg\" _src=\"http://yanxuan.nosdn.127.net/2ee52e0fd46a1b9e810b6cff80080f11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df2b5a4a9170a63464ffb44b1879bc96.jpg\" _src=\"http://yanxuan.nosdn.127.net/df2b5a4a9170a63464ffb44b1879bc96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d83fff8bfa124e2ae060fe197adfaf72.jpg\" _src=\"http://yanxuan.nosdn.127.net/d83fff8bfa124e2ae060fe197adfaf72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08badb8966fc6aa02ce4d32446e333b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/08badb8966fc6aa02ce4d32446e333b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ce6669b1554d8620688be52f8fb810d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ce6669b1554d8620688be52f8fb810d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4608ddce61f123e5253dbb12a99f6b0a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4608ddce61f123e5253dbb12a99f6b0a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74bd89bc99b6bfaa4c214ad276a88430.jpg\" _src=\"http://yanxuan.nosdn.127.net/74bd89bc99b6bfaa4c214ad276a88430.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9e28bd1e7ac14e9b5647bb64c6b4a26.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9e28bd1e7ac14e9b5647bb64c6b4a26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74e00c9d6aa2fc2399abefb88bdaf8a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/74e00c9d6aa2fc2399abefb88bdaf8a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ecb58ee8447ed2de29771847371fa3b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/ecb58ee8447ed2de29771847371fa3b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ff83658f2776cee2b286bd368194afc.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ff83658f2776cee2b286bd368194afc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b3114ead8fe1dc825b5d62f44cda82e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b3114ead8fe1dc825b5d62f44cda82e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3a052106cf6fc407c6a8580a4e80d67.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3a052106cf6fc407c6a8580a4e80d67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3db7f13c06918c55072528de4aece440.jpg\" _src=\"http://yanxuan.nosdn.127.net/3db7f13c06918c55072528de4aece440.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ded96e007d2170bf91c4bd4ea79bf2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ded96e007d2170bf91c4bd4ea79bf2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/951cd3cfc096254b6bf8317ab47d0fe5.jpg\" _src=\"http://yanxuan.nosdn.127.net/951cd3cfc096254b6bf8317ab47d0fe5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/184200ceb7b8dbdc9bae631e3a0581b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/184200ceb7b8dbdc9bae631e3a0581b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29f3f6efa3231a5e99e9a44e5a24bb4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/29f3f6efa3231a5e99e9a44e5a24bb4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b35c5748efcfee1a5dc81c0810c7bd67.jpg\" _src=\"http://yanxuan.nosdn.127.net/b35c5748efcfee1a5dc81c0810c7bd67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88f2d0356bb555fde2fb6c25ae847c05.jpg\" _src=\"http://yanxuan.nosdn.127.net/88f2d0356bb555fde2fb6c25ae847c05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d6352f6108efbcb25254a67930145be.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d6352f6108efbcb25254a67930145be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afe7d1831bb5b4531635147e2cd0e2d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/afe7d1831bb5b4531635147e2cd0e2d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8855e7dfae3a75e0f93d5fab95e946e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/8855e7dfae3a75e0f93d5fab95e946e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f22fc5142275af46a2acf2fe9ad74a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f22fc5142275af46a2acf2fe9ad74a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f69939e5b9d256411a0d3e511b295e7d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f69939e5b9d256411a0d3e511b295e7d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ea6ba739ec736547003f5bdac653093.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ea6ba739ec736547003f5bdac653093.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7360942dfe7203d20dce34fd1dc7a0ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/7360942dfe7203d20dce34fd1dc7a0ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/294d34eb5d9abb585da5aab16472461d.jpg\" _src=\"http://yanxuan.nosdn.127.net/294d34eb5d9abb585da5aab16472461d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0a9cdb30a20d61e53a00af1832a9926.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0a9cdb30a20d61e53a00af1832a9926.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cde197a4dd2b0d082e71abfb31c0425c.jpg\" _src=\"http://yanxuan.nosdn.127.net/cde197a4dd2b0d082e71abfb31c0425c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac3e7e8daac18b4e0b15e2eecde2f9bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac3e7e8daac18b4e0b15e2eecde2f9bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c6bfb287f89863151eae73cd8394099.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c6bfb287f89863151eae73cd8394099.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8a2ec3e30323ceca1ac405cbfd2170e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8a2ec3e30323ceca1ac405cbfd2170e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c58006153a790a6fec2eb5439ce2db58.jpg\" _src=\"http://yanxuan.nosdn.127.net/c58006153a790a6fec2eb5439ce2db58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/117f9d0cd7e4977b74a27b909093ece7.jpg\" _src=\"http://yanxuan.nosdn.127.net/117f9d0cd7e4977b74a27b909093ece7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/770ccf0c391afca7adeac427f50c2ca8.jpg\" _src=\"http://yanxuan.nosdn.127.net/770ccf0c391afca7adeac427f50c2ca8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d5876d20a5f24068bc3b2bb8c4d4a63.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d5876d20a5f24068bc3b2bb8c4d4a63.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69cd01bdf30848dfd26a15d37bee082e.jpg\" _src=\"http://yanxuan.nosdn.127.net/69cd01bdf30848dfd26a15d37bee082e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37b518e86767eddf31b9c82ce996d4b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/37b518e86767eddf31b9c82ce996d4b7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/423772dd88fabc3fe61da2e8d8e56b40.jpg\" _src=\"http://yanxuan.nosdn.127.net/423772dd88fabc3fe61da2e8d8e56b40.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f25fc3baabefe2eedb9d442d792458c9.jpg', 'http://yanxuan.nosdn.127.net/54f822e9c542d20566c7f70f90d52ae6.png', '1699.00', '241', '1101009', '0.00', '限时购', '', '0.00', '0', '0', '0', '1868.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097005', '1015000', '1097005', '原素系列实木餐椅（两把）', '0', '100', '', '经典造型，贴合人体曲线', '<p><span style=\"color: rgb(255, 0, 0);\"><strong><span style=\"font-family: 微软雅黑, sans-serif;\"></span></strong></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/58bf6aac499c5d9d9accf761762ec7fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/58bf6aac499c5d9d9accf761762ec7fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7bb654d6c2771063498221154f811b12.jpg\" _src=\"http://yanxuan.nosdn.127.net/7bb654d6c2771063498221154f811b12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0bf43b6e826c8d16608430f5ceb787b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0bf43b6e826c8d16608430f5ceb787b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59b3b4911827999beecf5a8dc0eacfa8.jpg\" _src=\"http://yanxuan.nosdn.127.net/59b3b4911827999beecf5a8dc0eacfa8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3300cd54cdbe61a3528f22279fd63daa.jpg\" _src=\"http://yanxuan.nosdn.127.net/3300cd54cdbe61a3528f22279fd63daa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b36f76274e623bb591b593ebe1f99738.jpg\" _src=\"http://yanxuan.nosdn.127.net/b36f76274e623bb591b593ebe1f99738.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51abb9433dc0b752382d33dc21386fd1.jpg\" _src=\"http://yanxuan.nosdn.127.net/51abb9433dc0b752382d33dc21386fd1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec11039995a933d728b311ff8409c203.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec11039995a933d728b311ff8409c203.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6dd084f6b918fc521ad155e4b47813bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/6dd084f6b918fc521ad155e4b47813bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b8f15ccb74aa20559a45b114e6b4470a.jpg\" _src=\"http://yanxuan.nosdn.127.net/b8f15ccb74aa20559a45b114e6b4470a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9898c60e890b8349c3fff64c1befea3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9898c60e890b8349c3fff64c1befea3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/645bfd1c5b1b4407f5036f38b557b32d.jpg\" _src=\"http://yanxuan.nosdn.127.net/645bfd1c5b1b4407f5036f38b557b32d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90ce9ce1e836641a9b011eb3ecdf0364.jpg\" _src=\"http://yanxuan.nosdn.127.net/90ce9ce1e836641a9b011eb3ecdf0364.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/536c516a5a169f70873eb81a5053a306.jpg\" _src=\"http://yanxuan.nosdn.127.net/536c516a5a169f70873eb81a5053a306.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4015e9847e26323c38cb505c2fba729d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4015e9847e26323c38cb505c2fba729d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/068ea22c6a20cfbd31d35b5125661712.jpg\" _src=\"http://yanxuan.nosdn.127.net/068ea22c6a20cfbd31d35b5125661712.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a81a479da7c9f8fd344c91603bb07ada.jpg\" _src=\"http://yanxuan.nosdn.127.net/a81a479da7c9f8fd344c91603bb07ada.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b3aa284f5b152ed6bf0edec0bc08eb7.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b3aa284f5b152ed6bf0edec0bc08eb7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb1c5ba4c89d0e169cb9af89571d2fcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb1c5ba4c89d0e169cb9af89571d2fcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f479985068f12a4905d57ea70edfe6d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/f479985068f12a4905d57ea70edfe6d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a381d64ce3f5f9ebca2bd40dc510e76f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a381d64ce3f5f9ebca2bd40dc510e76f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7c31b81df1919f5eccd92de190c67da.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7c31b81df1919f5eccd92de190c67da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/244ebfea06e5473851891e30d7055e4d.jpg\" _src=\"http://yanxuan.nosdn.127.net/244ebfea06e5473851891e30d7055e4d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2785c4e714c30c29814550bd942415c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2785c4e714c30c29814550bd942415c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65ed10397f720580749a1c500c59240f.jpg\" _src=\"http://yanxuan.nosdn.127.net/65ed10397f720580749a1c500c59240f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3fbbe8fd89981becd6abf7193b8f49a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3fbbe8fd89981becd6abf7193b8f49a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1297f27f945f0681481b20269994059c.jpg\" _src=\"http://yanxuan.nosdn.127.net/1297f27f945f0681481b20269994059c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e9c6d112a727b4c9707e71b9b893af2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/e9c6d112a727b4c9707e71b9b893af2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61b3613dd5c7c515053ebe1273e4645c.jpg\" _src=\"http://yanxuan.nosdn.127.net/61b3613dd5c7c515053ebe1273e4645c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3153459bade75cd0b4a99170294a3ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3153459bade75cd0b4a99170294a3ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/891961cb605de819fe61dfe7b6448c93.jpg\" _src=\"http://yanxuan.nosdn.127.net/891961cb605de819fe61dfe7b6448c93.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8d9715282d599b7fa332757703d5cee.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8d9715282d599b7fa332757703d5cee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06752acfd4d6fad664d4559f253f02c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/06752acfd4d6fad664d4559f253f02c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47be359052af1c5cad58031260692f6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/47be359052af1c5cad58031260692f6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0203f2d63a50b7a7c710edaea4e6721.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0203f2d63a50b7a7c710edaea4e6721.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70c426b0c294bec93b0cd9c1e74ffeaf.jpg\" _src=\"http://yanxuan.nosdn.127.net/70c426b0c294bec93b0cd9c1e74ffeaf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/063fdee70371da221e4816c757e42b48.jpg\" _src=\"http://yanxuan.nosdn.127.net/063fdee70371da221e4816c757e42b48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8778225dd221a88993c424681d123a72.jpg\" _src=\"http://yanxuan.nosdn.127.net/8778225dd221a88993c424681d123a72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ff4dcabe22e555a980e4d904d757cd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ff4dcabe22e555a980e4d904d757cd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7cf7d88745db43becc47cd604d191d3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/7cf7d88745db43becc47cd604d191d3d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/378de7f6768ceb7364593943627cd5d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/378de7f6768ceb7364593943627cd5d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39d96f8c4f9674c8e41dfd1495bea6ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/39d96f8c4f9674c8e41dfd1495bea6ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdf8093c4892eef9a28f5e117bb260f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdf8093c4892eef9a28f5e117bb260f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c87def69ebacf3ce9c8ece630c69c78.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c87def69ebacf3ce9c8ece630c69c78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c53fe1ff2f377b4c9374cd28899928db.jpg\" _src=\"http://yanxuan.nosdn.127.net/c53fe1ff2f377b4c9374cd28899928db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e27fb00d265e1bb0baa3f780201a69a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e27fb00d265e1bb0baa3f780201a69a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a92cef1e4963271a9a42254efd9d8899.jpg\" _src=\"http://yanxuan.nosdn.127.net/a92cef1e4963271a9a42254efd9d8899.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a88c5151d5a957a276596c2cab36d9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a88c5151d5a957a276596c2cab36d9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/936e13a87b280258d6be6bc2ef11e423.jpg\" _src=\"http://yanxuan.nosdn.127.net/936e13a87b280258d6be6bc2ef11e423.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f31082e220dbb4bd6749d8624f27b7d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f31082e220dbb4bd6749d8624f27b7d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98c0d16db110a6e7dc6475c01d25d437.jpg\" _src=\"http://yanxuan.nosdn.127.net/98c0d16db110a6e7dc6475c01d25d437.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc588c1440f3ba306a3f6f3c82c2a5ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc588c1440f3ba306a3f6f3c82c2a5ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6bd50414f175e6f4db4c3ee6ee98255.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6bd50414f175e6f4db4c3ee6ee98255.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7043c897bd2076baada21f858eb8ce2.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7043c897bd2076baada21f858eb8ce2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e69bde9952f85724cd28a04851d92d7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e69bde9952f85724cd28a04851d92d7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5825f1cab216275436125c5f689b6281.jpg\" _src=\"http://yanxuan.nosdn.127.net/5825f1cab216275436125c5f689b6281.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d85b3c1495ec3cbf540e6f9a644cdb26.jpg\" _src=\"http://yanxuan.nosdn.127.net/d85b3c1495ec3cbf540e6f9a644cdb26.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d7e3e7273c336886cbdd11512cc1892.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d7e3e7273c336886cbdd11512cc1892.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e9b78fb753069669bd0eb86a586842ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/e9b78fb753069669bd0eb86a586842ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/21d84381b85cc5a11c341814aa4e1bb7.jpg\" _src=\"http://yanxuan.nosdn.127.net/21d84381b85cc5a11c341814aa4e1bb7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4270b5360a2213b3a23408c6e1158f37.jpg\" _src=\"http://yanxuan.nosdn.127.net/4270b5360a2213b3a23408c6e1158f37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8d9432187145bf941cd0f16475b9190.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8d9432187145bf941cd0f16475b9190.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6a96e9977b61695995548d5a445b13a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6a96e9977b61695995548d5a445b13a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/564847bca40c56d50e3bb5c58fe924f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/564847bca40c56d50e3bb5c58fe924f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/050aedf6afb6e64e147f38a3948a849f.jpg\" _src=\"http://yanxuan.nosdn.127.net/050aedf6afb6e64e147f38a3948a849f.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/78d2d4e121ada074a94e61bc02f077d3.jpg', 'http://yanxuan.nosdn.127.net/e5fd0724a05387615738173fb8f1570d.png', '1199.00', '497', '1101011', '0.00', '限时购', '', '0.00', '0', '0', '0', '1318.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097006', '1015000', '1097006', '原素系列折角实木圆桌', '0', '100', '', '经典桌角，美观稳固', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/d921d9fbd52e4db78d812a14850bc788.jpg\" _src=\"http://yanxuan.nosdn.127.net/d921d9fbd52e4db78d812a14850bc788.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d0fec31eef9b4b2abe6e66140d45750.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d0fec31eef9b4b2abe6e66140d45750.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84032eeb2d5853254041d2b09f3dfb1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/84032eeb2d5853254041d2b09f3dfb1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/181e31d6232eadffe61e84e8dd661e5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/181e31d6232eadffe61e84e8dd661e5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10c32e52c88cf226837c68ea46202b12.jpg\" _src=\"http://yanxuan.nosdn.127.net/10c32e52c88cf226837c68ea46202b12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e0bb20406c5bf1c2b4d412f7423aa77.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e0bb20406c5bf1c2b4d412f7423aa77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd51593d7836e22c3379045a74728cb0.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd51593d7836e22c3379045a74728cb0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f04213fb9494e13616aacd62ed9e233d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f04213fb9494e13616aacd62ed9e233d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b84faaea14fd448631b3c1d3a37e1fb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b84faaea14fd448631b3c1d3a37e1fb3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e5e76933d2f479c7fa129ec6de6ba6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e5e76933d2f479c7fa129ec6de6ba6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39dbbeb2e7064d453266d0d5e8ed4b56.jpg\" _src=\"http://yanxuan.nosdn.127.net/39dbbeb2e7064d453266d0d5e8ed4b56.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/058dff0add92b3ace4cdddec160c6dad.jpg\" _src=\"http://yanxuan.nosdn.127.net/058dff0add92b3ace4cdddec160c6dad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3a64eadda21dba3a5e7d5ad95c8bafe.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3a64eadda21dba3a5e7d5ad95c8bafe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cff9ed658d697e65b4b986c544eb52c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/cff9ed658d697e65b4b986c544eb52c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee42f75f692c1b9f106e8d4a50061cdb.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee42f75f692c1b9f106e8d4a50061cdb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9c49cafe6ddd219aefce7dcf0240b1b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9c49cafe6ddd219aefce7dcf0240b1b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4267ba52b1e0fe247e7c70eb0104bef2.jpg\" _src=\"http://yanxuan.nosdn.127.net/4267ba52b1e0fe247e7c70eb0104bef2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c76a5d6ef41fd022d2d642e04f2c729.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c76a5d6ef41fd022d2d642e04f2c729.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74b522306cb49e5d028b84eb06578d88.jpg\" _src=\"http://yanxuan.nosdn.127.net/74b522306cb49e5d028b84eb06578d88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22fa66c09768c52f1d6529ee5dcbb7c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/22fa66c09768c52f1d6529ee5dcbb7c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5025bd8a554a48a74c4ea39f242318e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5025bd8a554a48a74c4ea39f242318e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9a035cf11a43c9a92564615e1aa6634.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9a035cf11a43c9a92564615e1aa6634.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e26964ef91a6b3fe11c35f7c7ef1b02.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e26964ef91a6b3fe11c35f7c7ef1b02.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95a6dd8da01e559079b644eeaf60cfec.jpg\" _src=\"http://yanxuan.nosdn.127.net/95a6dd8da01e559079b644eeaf60cfec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/695bd45a00710700d516daa3dd2a9045.jpg\" _src=\"http://yanxuan.nosdn.127.net/695bd45a00710700d516daa3dd2a9045.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcdbe2ea52bc998a723713d31d28f0e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcdbe2ea52bc998a723713d31d28f0e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/829b9b9da00da641fab56afbf494a608.jpg\" _src=\"http://yanxuan.nosdn.127.net/829b9b9da00da641fab56afbf494a608.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/306463fdf94b0b7ddc0543271e9eec1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/306463fdf94b0b7ddc0543271e9eec1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0a664d56450ea41699b469e11b3191b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0a664d56450ea41699b469e11b3191b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bfe6a883b89e254361bc0f63106f129c.jpg\" _src=\"http://yanxuan.nosdn.127.net/bfe6a883b89e254361bc0f63106f129c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/640f28756128cd9ac1caa69a65e1d037.jpg\" _src=\"http://yanxuan.nosdn.127.net/640f28756128cd9ac1caa69a65e1d037.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab0f1b1dfd0bf03f0980789a3b5b231d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab0f1b1dfd0bf03f0980789a3b5b231d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32bfb8a814466bb73730bfc29e91686a.jpg\" _src=\"http://yanxuan.nosdn.127.net/32bfb8a814466bb73730bfc29e91686a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdb84db96ff9309924436e31c45f4c2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdb84db96ff9309924436e31c45f4c2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c01dc4a48b90fa14ed0389507f7f6f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c01dc4a48b90fa14ed0389507f7f6f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd3d400330befffaf4292590567832ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd3d400330befffaf4292590567832ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d24311e7c08d3150db1289209b006f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/d24311e7c08d3150db1289209b006f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c4ac5d679937b78eb06123b1306e0cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c4ac5d679937b78eb06123b1306e0cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33c38f8f6376da9e925df8ee9453a0fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/33c38f8f6376da9e925df8ee9453a0fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eed96d78a12e02e1a8166b5bea129e0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/eed96d78a12e02e1a8166b5bea129e0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ee3e1d8f819a767040bcaaad018918e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ee3e1d8f819a767040bcaaad018918e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a091b92872aaa1f648d2f20dc8bc1e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a091b92872aaa1f648d2f20dc8bc1e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ed0e281deb3eb7eb8b7a852a881ca82.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ed0e281deb3eb7eb8b7a852a881ca82.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/185bec777e4ec73015b903c2f543c1a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/185bec777e4ec73015b903c2f543c1a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6fc9b90f09ac6fd5b6a58cd4ff43fc55.jpg\" _src=\"http://yanxuan.nosdn.127.net/6fc9b90f09ac6fd5b6a58cd4ff43fc55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5fb02e7b3525962671e7737059c74adb.jpg\" _src=\"http://yanxuan.nosdn.127.net/5fb02e7b3525962671e7737059c74adb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2203f84b325605f1a4d110d4f902b27.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2203f84b325605f1a4d110d4f902b27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e301503abf99370cd578ce676e76c58.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e301503abf99370cd578ce676e76c58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e27b3e29f096cfdbe7399a54feb45de5.jpg\" _src=\"http://yanxuan.nosdn.127.net/e27b3e29f096cfdbe7399a54feb45de5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8025864e41ebf9ec17412dbc442b28cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/8025864e41ebf9ec17412dbc442b28cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef5642f3926481d9896a995aebb22db0.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef5642f3926481d9896a995aebb22db0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbbb88c09f63f2bbb536825a8b5b0d59.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbbb88c09f63f2bbb536825a8b5b0d59.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63a3e0da3faa2201b066ea643b978b0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/63a3e0da3faa2201b066ea643b978b0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4c939e0c60f49c0e68404de82c8715da.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c939e0c60f49c0e68404de82c8715da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19b292b838a542e513a945aad4e570d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/19b292b838a542e513a945aad4e570d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/685f110f22edb7f76de957dd15bde938.jpg\" _src=\"http://yanxuan.nosdn.127.net/685f110f22edb7f76de957dd15bde938.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d561a175b38e6aa9edc6c28852e194f.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d561a175b38e6aa9edc6c28852e194f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab5e9feb91653a8a4a42f360a46d5480.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab5e9feb91653a8a4a42f360a46d5480.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bee201c8e1874fc2e1f3ea623bce333.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bee201c8e1874fc2e1f3ea623bce333.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '13', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/bcf2a72face2c4221dfdc9b3c97d4062.png', 'http://yanxuan.nosdn.127.net/bcf2a72face2c4221dfdc9b3c97d4062.png', '999.00', '2', '1101012', '0.00', '限时购', '', '0.00', '0', '0', '0', '1098.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097007', '1015000', '1097007', '原素系列立式实木圆桌', '0', '100', '', '优雅木纹，结实不易蛀', '<p><span style=\"font-size: 18px; color: rgb(0, 0, 0);\"></span></p><p><strong><span style=\";font-family:&#39;微软雅黑&#39;,sans-serif\"></span></strong></p><p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/367118c1d5564aa47528fb65a0c29dd0.jpg\" _src=\"http://yanxuan.nosdn.127.net/367118c1d5564aa47528fb65a0c29dd0.jpg\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc166ec8dde64dfc7ab728e281f95273.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc166ec8dde64dfc7ab728e281f95273.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65fcfb06d85562eff6846847b98ac002.jpg\" _src=\"http://yanxuan.nosdn.127.net/65fcfb06d85562eff6846847b98ac002.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d59f3db5fa6ee01611e673e116b2c6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d59f3db5fa6ee01611e673e116b2c6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a74f444dac37f86dacfa992a9a5316fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/a74f444dac37f86dacfa992a9a5316fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5225491814eadd7596d12352adfab7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5225491814eadd7596d12352adfab7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b7ed296551aa2b6a67687d89bd1ced0.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b7ed296551aa2b6a67687d89bd1ced0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdb9f42e6ac02e2f35fac16b5c59ea10.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdb9f42e6ac02e2f35fac16b5c59ea10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0890c40221e0db832dfee56d31fd85f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0890c40221e0db832dfee56d31fd85f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da314ee4f81aa83f38ae3420f375e607.jpg\" _src=\"http://yanxuan.nosdn.127.net/da314ee4f81aa83f38ae3420f375e607.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9f91ab9db7875a2ce7d040f4dffd98e.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9f91ab9db7875a2ce7d040f4dffd98e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37965f4fce6ca5de5fcc8580c16bc2b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/37965f4fce6ca5de5fcc8580c16bc2b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65fc17e1d15ac6067a94677b77e134e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/65fc17e1d15ac6067a94677b77e134e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40084e9ec2045dc43fed5acb8c5b89f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/40084e9ec2045dc43fed5acb8c5b89f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e0df0d3fc2318263cfd3d817473a3d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e0df0d3fc2318263cfd3d817473a3d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ba21bd75e4546637ff12ec750227634.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ba21bd75e4546637ff12ec750227634.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b31e479876493cbc3da04c145ecbbbf7.jpg\" _src=\"http://yanxuan.nosdn.127.net/b31e479876493cbc3da04c145ecbbbf7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a32b5093ce20aa9300fa5ccac95f281.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a32b5093ce20aa9300fa5ccac95f281.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b42c8542e5d04ddfcbc120a9ffe7b51c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b42c8542e5d04ddfcbc120a9ffe7b51c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a959e58b12d559a2fec30c945d941e27.jpg\" _src=\"http://yanxuan.nosdn.127.net/a959e58b12d559a2fec30c945d941e27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02ce8bad5bfde1ce4df36c75113b6deb.jpg\" _src=\"http://yanxuan.nosdn.127.net/02ce8bad5bfde1ce4df36c75113b6deb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85411c07a0d067b14325294ff9772810.jpg\" _src=\"http://yanxuan.nosdn.127.net/85411c07a0d067b14325294ff9772810.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04da2f032b0763db53b7a1680b37c046.jpg\" _src=\"http://yanxuan.nosdn.127.net/04da2f032b0763db53b7a1680b37c046.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2190737c115276814c72a3cb0158a919.jpg\" _src=\"http://yanxuan.nosdn.127.net/2190737c115276814c72a3cb0158a919.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/814fbb7a0893d108c7dff32c64743ab3.jpg\" _src=\"http://yanxuan.nosdn.127.net/814fbb7a0893d108c7dff32c64743ab3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f86402674a01e595253095a8e9907646.jpg\" _src=\"http://yanxuan.nosdn.127.net/f86402674a01e595253095a8e9907646.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a280df005fe14b11505c6fedacb8e44e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a280df005fe14b11505c6fedacb8e44e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51a94eee1f55de52b54c7d590c055f3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/51a94eee1f55de52b54c7d590c055f3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc91b63444988fe6a948d7b08af164e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc91b63444988fe6a948d7b08af164e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8509bd077c6965429602dd39367a4d97.jpg\" _src=\"http://yanxuan.nosdn.127.net/8509bd077c6965429602dd39367a4d97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a1f18c47c25c3a1e8014a048133cb5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a1f18c47c25c3a1e8014a048133cb5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ab093dc8ade370d55c6521a0823810c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ab093dc8ade370d55c6521a0823810c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b6e028886b3216ff76aceccd93e4125.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b6e028886b3216ff76aceccd93e4125.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4bf8df40407833ac0558c2f77f13d5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4bf8df40407833ac0558c2f77f13d5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18e4c34c66cdfa5939fc77cbfca3ed19.jpg\" _src=\"http://yanxuan.nosdn.127.net/18e4c34c66cdfa5939fc77cbfca3ed19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a5bf1b22caa0fb02df77f23c48c0a5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a5bf1b22caa0fb02df77f23c48c0a5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28f05e88413bf95e4cbaeb049ac9aab5.jpg\" _src=\"http://yanxuan.nosdn.127.net/28f05e88413bf95e4cbaeb049ac9aab5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4074f5c0c813f5a8134a6e3cc8b54758.jpg\" _src=\"http://yanxuan.nosdn.127.net/4074f5c0c813f5a8134a6e3cc8b54758.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fbddf5ea8c146eeb624203c324fcec2.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fbddf5ea8c146eeb624203c324fcec2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0cc22af1d34c33ed1cdca4150e1fc645.jpg\" _src=\"http://yanxuan.nosdn.127.net/0cc22af1d34c33ed1cdca4150e1fc645.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/534d778c9455c42c57bd00ac0c259e41.jpg\" _src=\"http://yanxuan.nosdn.127.net/534d778c9455c42c57bd00ac0c259e41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29909b90ee2fe86c4ad37f325183fcf3.jpg\" _src=\"http://yanxuan.nosdn.127.net/29909b90ee2fe86c4ad37f325183fcf3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e417eb47ead00163e6410edc0d59c2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e417eb47ead00163e6410edc0d59c2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/056962c567f22c2f3f9172e109923410.jpg\" _src=\"http://yanxuan.nosdn.127.net/056962c567f22c2f3f9172e109923410.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41e35152ba347077604080f19c8de53e.jpg\" _src=\"http://yanxuan.nosdn.127.net/41e35152ba347077604080f19c8de53e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5d944f6433f98554ddb145ae354605d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5d944f6433f98554ddb145ae354605d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7cee90d97a3565b9e8ea197aeeea0091.jpg\" _src=\"http://yanxuan.nosdn.127.net/7cee90d97a3565b9e8ea197aeeea0091.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/051901b3ba8cbb08a8382b693cd6e901.jpg\" _src=\"http://yanxuan.nosdn.127.net/051901b3ba8cbb08a8382b693cd6e901.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4767dc0d2d18d2af1bb93a9096cea9e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/4767dc0d2d18d2af1bb93a9096cea9e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/468e614a59bca5147c608cd45f21d488.jpg\" _src=\"http://yanxuan.nosdn.127.net/468e614a59bca5147c608cd45f21d488.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07041ca071e6a8b68c3026c3d0c92d4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/07041ca071e6a8b68c3026c3d0c92d4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24df4f2a5b09e0a4d627c87d198d5900.jpg\" _src=\"http://yanxuan.nosdn.127.net/24df4f2a5b09e0a4d627c87d198d5900.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/120860ece798ec9da64cc7cf4eb638e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/120860ece798ec9da64cc7cf4eb638e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5c17351e0082a9ea3b2aa4139706d33.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5c17351e0082a9ea3b2aa4139706d33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66567f0373ba8ae7ac6ac710e3103732.jpg\" _src=\"http://yanxuan.nosdn.127.net/66567f0373ba8ae7ac6ac710e3103732.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1561e14de9f5557517da732c0e5b822.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1561e14de9f5557517da732c0e5b822.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86dd804d27210acdf6e9aa6ab9ad9a80.jpg\" _src=\"http://yanxuan.nosdn.127.net/86dd804d27210acdf6e9aa6ab9ad9a80.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/914ec349deb99f80f2b651b0a626dad3.jpg\" _src=\"http://yanxuan.nosdn.127.net/914ec349deb99f80f2b651b0a626dad3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3652b8995b5a389a052b917063667c5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3652b8995b5a389a052b917063667c5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b8c2a25368fe117e0388c3b56bfb2f73.jpg\" _src=\"http://yanxuan.nosdn.127.net/b8c2a25368fe117e0388c3b56bfb2f73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/caa35f0dbf239856e9abefe3516f0699.jpg\" _src=\"http://yanxuan.nosdn.127.net/caa35f0dbf239856e9abefe3516f0699.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4833cc47ffaa8618c1c624e75d394ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4833cc47ffaa8618c1c624e75d394ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/87e94a52553c2b720fcd8d498fb132e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/87e94a52553c2b720fcd8d498fb132e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3fddb7d49565ba8f5b0fcd818678fcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3fddb7d49565ba8f5b0fcd818678fcb.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '12', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f542b847b5cca146c34b2dff0c0a1d7e.jpg', 'http://yanxuan.nosdn.127.net/b6e132180679b0673486145decc89aa3.png', '759.00', '10', '1101013', '0.00', '限时购', '', '0.00', '0', '0', '0', '834.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097009', '1015000', '1097009', '原素系列实木书桌', '0', '100', '', '无胶龙凤口工艺，经久耐用', '<p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/88132c09bb46fd56c3736a78bde5c062.jpg\" _src=\"http://yanxuan.nosdn.127.net/88132c09bb46fd56c3736a78bde5c062.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43171af9decffd112b6fbfdf47ea7c9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/43171af9decffd112b6fbfdf47ea7c9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1299da36c3cd3b8f337e9d8c1bb7dfd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/1299da36c3cd3b8f337e9d8c1bb7dfd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/725661defd33ad42cd094f27310028d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/725661defd33ad42cd094f27310028d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6c0d23a9ae2d5d51f29653645217527.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6c0d23a9ae2d5d51f29653645217527.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e8d9fb319da6309189f840a42483a6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e8d9fb319da6309189f840a42483a6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b5d5d008caee37dd093e4a97def928c.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b5d5d008caee37dd093e4a97def928c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19262e7e1f5a25d58cbbc3074d9f5f46.jpg\" _src=\"http://yanxuan.nosdn.127.net/19262e7e1f5a25d58cbbc3074d9f5f46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/156398c313dc43c534f902a9fc44282f.jpg\" _src=\"http://yanxuan.nosdn.127.net/156398c313dc43c534f902a9fc44282f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc0a7c483729329ce4ff40b4102600ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc0a7c483729329ce4ff40b4102600ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c24ae4580b31a8018301773b4100feef.jpg\" _src=\"http://yanxuan.nosdn.127.net/c24ae4580b31a8018301773b4100feef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3da0e8e4fb5889646c7f7426524ae8be.jpg\" _src=\"http://yanxuan.nosdn.127.net/3da0e8e4fb5889646c7f7426524ae8be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9eaac645f1b9a72b5c608f2097d8ae6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/9eaac645f1b9a72b5c608f2097d8ae6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4953079263239d6a5d5db13bdc84ba3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4953079263239d6a5d5db13bdc84ba3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7b5f7d040dbe2b81b8afd2f750494c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7b5f7d040dbe2b81b8afd2f750494c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95840331fdbec4ddcfe23e107c3a689d.jpg\" _src=\"http://yanxuan.nosdn.127.net/95840331fdbec4ddcfe23e107c3a689d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d32b40b09aee96c287e52e1648f54e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d32b40b09aee96c287e52e1648f54e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb4b7b9c03df2956efb1de4cef85ede0.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb4b7b9c03df2956efb1de4cef85ede0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/370c4b37af7f0b172415d7a41f956ecf.jpg\" _src=\"http://yanxuan.nosdn.127.net/370c4b37af7f0b172415d7a41f956ecf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a8d988f501085612d40aa5a861dc600.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a8d988f501085612d40aa5a861dc600.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d32cc594b9c7f9ddb999841e47a658f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/d32cc594b9c7f9ddb999841e47a658f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43d1130a30ec3b2f71198e43803ff563.jpg\" _src=\"http://yanxuan.nosdn.127.net/43d1130a30ec3b2f71198e43803ff563.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1f72a1b595bf4b215a2da88989daaf9.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1f72a1b595bf4b215a2da88989daaf9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6476a6ec20137b3d2e7b5d1834d133cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/6476a6ec20137b3d2e7b5d1834d133cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83a6d0c9c10d826e0216030290024224.jpg\" _src=\"http://yanxuan.nosdn.127.net/83a6d0c9c10d826e0216030290024224.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/831989c6e8aa9af783cc0955be193cc0.jpg\" _src=\"http://yanxuan.nosdn.127.net/831989c6e8aa9af783cc0955be193cc0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d9f7d0bc8fd7b9b03000d060cf95465.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d9f7d0bc8fd7b9b03000d060cf95465.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/721b53bc8fd1a0c236d45168c3f5366b.jpg\" _src=\"http://yanxuan.nosdn.127.net/721b53bc8fd1a0c236d45168c3f5366b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca98b9829f5a74d09e8c7cda717bc9b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca98b9829f5a74d09e8c7cda717bc9b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe3a4daa2f5b18e566387b980b57c1e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe3a4daa2f5b18e566387b980b57c1e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5dabf0028ba770f1bdefddc4f4f1a226.jpg\" _src=\"http://yanxuan.nosdn.127.net/5dabf0028ba770f1bdefddc4f4f1a226.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16338e9c712c3ec1f9103593f8be4eb4.jpg\" _src=\"http://yanxuan.nosdn.127.net/16338e9c712c3ec1f9103593f8be4eb4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/791d8c24267ea09bd41aa2b91c06dbc6.jpg\" _src=\"http://yanxuan.nosdn.127.net/791d8c24267ea09bd41aa2b91c06dbc6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d7288a80b9d75a6aeb6c41dd1245788.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d7288a80b9d75a6aeb6c41dd1245788.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd59b7c730c9ca13891822ec4a47a649.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd59b7c730c9ca13891822ec4a47a649.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a0c045e21d154b18ecac752e36dac0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a0c045e21d154b18ecac752e36dac0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ea95b32db696ba29ec2f2b036693495.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ea95b32db696ba29ec2f2b036693495.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92515ffca2aaf56d7da8b083a8f2dcde.jpg\" _src=\"http://yanxuan.nosdn.127.net/92515ffca2aaf56d7da8b083a8f2dcde.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41397343f3bd8e21ec0c8f36f770419c.jpg\" _src=\"http://yanxuan.nosdn.127.net/41397343f3bd8e21ec0c8f36f770419c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2d60e173e42f532c17b756312b4dd0f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/2d60e173e42f532c17b756312b4dd0f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15770106961833c500769780ac0f05de.jpg\" _src=\"http://yanxuan.nosdn.127.net/15770106961833c500769780ac0f05de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fd4eae67f57be5f6e8eb8d87d9ce44f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fd4eae67f57be5f6e8eb8d87d9ce44f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/685272414d85ad4ecc27d4e48feeadcf.jpg\" _src=\"http://yanxuan.nosdn.127.net/685272414d85ad4ecc27d4e48feeadcf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8e6b764dbc2ebd7dcd1d1371674484d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8e6b764dbc2ebd7dcd1d1371674484d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3cb43de2db26ee4261aaa74a5b1e2c73.jpg\" _src=\"http://yanxuan.nosdn.127.net/3cb43de2db26ee4261aaa74a5b1e2c73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0241c52950f344d3ba47819fe64a809.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0241c52950f344d3ba47819fe64a809.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/695620b47efabdc9b1123a30e49e4d05.jpg\" _src=\"http://yanxuan.nosdn.127.net/695620b47efabdc9b1123a30e49e4d05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6dcf7e61c2d24a0cc1cc719ca95e89ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/6dcf7e61c2d24a0cc1cc719ca95e89ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57de5837078cd91ffe8d8553b323637e.jpg\" _src=\"http://yanxuan.nosdn.127.net/57de5837078cd91ffe8d8553b323637e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0925305320f94a71f1f645cc0e7691a.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0925305320f94a71f1f645cc0e7691a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ccb44bb49e396c3175676ef81eca063.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ccb44bb49e396c3175676ef81eca063.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/666c01818dbbe5aeda82338fd0f7c697.jpg\" _src=\"http://yanxuan.nosdn.127.net/666c01818dbbe5aeda82338fd0f7c697.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73b7998aaf4fbcc2ec2954e06ac31c6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/73b7998aaf4fbcc2ec2954e06ac31c6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5383e7be82613881d7177a64804323be.jpg\" _src=\"http://yanxuan.nosdn.127.net/5383e7be82613881d7177a64804323be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d9c0ed671c167b633e7c657524422f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d9c0ed671c167b633e7c657524422f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b944b0ab2f7f9f5ccbd09f445f2d3a41.jpg\" _src=\"http://yanxuan.nosdn.127.net/b944b0ab2f7f9f5ccbd09f445f2d3a41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b84a7b8388d8a9e4441534339b42f412.jpg\" _src=\"http://yanxuan.nosdn.127.net/b84a7b8388d8a9e4441534339b42f412.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c1223dcdb4e71f09a518801cf3e1832.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c1223dcdb4e71f09a518801cf3e1832.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/197ce8b7030968369f86b0a0e066f423.jpg\" _src=\"http://yanxuan.nosdn.127.net/197ce8b7030968369f86b0a0e066f423.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45f326c8baddfaddd5af24addd675063.jpg\" _src=\"http://yanxuan.nosdn.127.net/45f326c8baddfaddd5af24addd675063.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7ad2b6157dc6662f523e91e2ed30d06.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7ad2b6157dc6662f523e91e2ed30d06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25228437f15a686d5087f0287d3adedd.jpg\" _src=\"http://yanxuan.nosdn.127.net/25228437f15a686d5087f0287d3adedd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e2b784f461b4a1b31b201310ff2582b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/e2b784f461b4a1b31b201310ff2582b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2c5a90c31ee82a862abf51b8a6ac73c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2c5a90c31ee82a862abf51b8a6ac73c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f9796cd6f11c1f26dc96406f2a17cd9c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f9796cd6f11c1f26dc96406f2a17cd9c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db9cfbd40e7d9eb20dfaeaf6f5d7faf3.jpg\" _src=\"http://yanxuan.nosdn.127.net/db9cfbd40e7d9eb20dfaeaf6f5d7faf3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '7', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/5cf97d669f7632068b04c23c168fdab9.jpg', 'http://yanxuan.nosdn.127.net/e7b68189ef2f77a28110c3fc7ca5a697.png', '1599.00', '402', '1101016', '0.00', '限时购', '', '0.00', '0', '0', '0', '1758.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097011', '1015000', '1097011', '原素系列1.8米实木床', '0', '100', '', '优选实木，环保喷漆', '<p><strong><span style=\"font-family:&#39;微软雅黑&#39;,sans-serif\"></span></strong></p><p><strong><span style=\"font-size:19px;font-family:&#39;微软雅黑&#39;,sans-serif\"></span></strong></p><p><strong><span style=\";font-family:&#39;微软雅黑&#39;,sans-serif\"></span></strong></p><p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/25b48074ebc6b7819a694e825b4a1675.jpg\" _src=\"http://yanxuan.nosdn.127.net/25b48074ebc6b7819a694e825b4a1675.jpg\"/><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/443f573c96e998c45a148ae928044d68.jpg\" _src=\"http://yanxuan.nosdn.127.net/443f573c96e998c45a148ae928044d68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e35ee3265475cd294ccb239298aa601.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e35ee3265475cd294ccb239298aa601.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84637fca3838f302f994bb01fcf373e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/84637fca3838f302f994bb01fcf373e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6561b8db485f04e17f1e983315e1b3ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/6561b8db485f04e17f1e983315e1b3ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/caeeea9996d4394a8c0f5f6e6de13220.jpg\" _src=\"http://yanxuan.nosdn.127.net/caeeea9996d4394a8c0f5f6e6de13220.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69fb823bc30d13933fdfb4419992ca2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/69fb823bc30d13933fdfb4419992ca2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95ef650961f9650d22aa44a47a61f2d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/95ef650961f9650d22aa44a47a61f2d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa0c6b0e9b41c37b00ef04491fd51f62.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa0c6b0e9b41c37b00ef04491fd51f62.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6118bb435efa9623650801d6d248e03.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6118bb435efa9623650801d6d248e03.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/25c6c5e2044dc6012f23782546243dbf.jpg\" _src=\"http://yanxuan.nosdn.127.net/25c6c5e2044dc6012f23782546243dbf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6ca845173f260a9304ae2c36f7fb286.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6ca845173f260a9304ae2c36f7fb286.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/375a682e134f438139f1c79a9879c035.jpg\" _src=\"http://yanxuan.nosdn.127.net/375a682e134f438139f1c79a9879c035.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e58c21fc0fd54cd6dcad4b2a34aa9b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e58c21fc0fd54cd6dcad4b2a34aa9b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb2c3f51c58101ced4e0114c20228187.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb2c3f51c58101ced4e0114c20228187.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54b4350b0a3e2d4f32aac2297a95f960.jpg\" _src=\"http://yanxuan.nosdn.127.net/54b4350b0a3e2d4f32aac2297a95f960.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2d6829e37e9a99d7d40814375efabbc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2d6829e37e9a99d7d40814375efabbc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ee4cb66e726b8af96bb8fcb95f2e097.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ee4cb66e726b8af96bb8fcb95f2e097.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1583759ecedb69d3e145f5aa30e83322.jpg\" _src=\"http://yanxuan.nosdn.127.net/1583759ecedb69d3e145f5aa30e83322.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7742363de23c364a479a059497d20621.jpg\" _src=\"http://yanxuan.nosdn.127.net/7742363de23c364a479a059497d20621.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e2b07a00c072d7eda424389eb4b2c98.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e2b07a00c072d7eda424389eb4b2c98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97e1dd6398f8d929dc22fa77b3af3048.jpg\" _src=\"http://yanxuan.nosdn.127.net/97e1dd6398f8d929dc22fa77b3af3048.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/165f05d010a1ca0fd107bb49761c7871.jpg\" _src=\"http://yanxuan.nosdn.127.net/165f05d010a1ca0fd107bb49761c7871.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a62b372ebe917afe660b86baf1bc4ed7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a62b372ebe917afe660b86baf1bc4ed7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee262ad88b9947ed502a999b16ce0fae.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee262ad88b9947ed502a999b16ce0fae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9087dcde6bd8018568fac07513fc5736.jpg\" _src=\"http://yanxuan.nosdn.127.net/9087dcde6bd8018568fac07513fc5736.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d6e0f85847cf8d32a1ada5166ac5b4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d6e0f85847cf8d32a1ada5166ac5b4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb5c0235162c2ea23ab2d41a5728d738.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb5c0235162c2ea23ab2d41a5728d738.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/171c6873ffc09e4749587202d5b90283.jpg\" _src=\"http://yanxuan.nosdn.127.net/171c6873ffc09e4749587202d5b90283.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/65ae6c826d0a2881986e0d6c79ce88c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/65ae6c826d0a2881986e0d6c79ce88c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/239c0532fc74277e37eb48d30a1ffdcf.jpg\" _src=\"http://yanxuan.nosdn.127.net/239c0532fc74277e37eb48d30a1ffdcf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5dc0992efc50819e5bcd8ded67f72b21.jpg\" _src=\"http://yanxuan.nosdn.127.net/5dc0992efc50819e5bcd8ded67f72b21.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79f835dee51dfebff826322e02702536.jpg\" _src=\"http://yanxuan.nosdn.127.net/79f835dee51dfebff826322e02702536.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12faaa008eb01af33a7290013cef9432.jpg\" _src=\"http://yanxuan.nosdn.127.net/12faaa008eb01af33a7290013cef9432.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e4273ea5f8db5f22aa7e528869809f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e4273ea5f8db5f22aa7e528869809f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef16497eb1ff1c3d6d5b5e9b2846b5c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef16497eb1ff1c3d6d5b5e9b2846b5c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37ba0ca96d08ddd6539f641f6ae104cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/37ba0ca96d08ddd6539f641f6ae104cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b1525ac453dca22948124139a965adf.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b1525ac453dca22948124139a965adf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/734f333508e556b9dbbbd13dcbd55165.jpg\" _src=\"http://yanxuan.nosdn.127.net/734f333508e556b9dbbbd13dcbd55165.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a3b49adb1e143e1d85f20c4bd08c771.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a3b49adb1e143e1d85f20c4bd08c771.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/122848144b1a5ab8f0549b9e2b58797c.jpg\" _src=\"http://yanxuan.nosdn.127.net/122848144b1a5ab8f0549b9e2b58797c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4eefa34083fdc0095e079484a079ec9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4eefa34083fdc0095e079484a079ec9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c5c2ed91c345083c36c04edac3017d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c5c2ed91c345083c36c04edac3017d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8efcd5370561d2a9aa7e38036dc9f26a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8efcd5370561d2a9aa7e38036dc9f26a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/485de6226b63772f9da8c74d66e1a785.jpg\" _src=\"http://yanxuan.nosdn.127.net/485de6226b63772f9da8c74d66e1a785.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32c8b4bf19bae3aef7064aa0d9043c3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/32c8b4bf19bae3aef7064aa0d9043c3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3af4220eed1c8b875bee478f4f12b5f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/3af4220eed1c8b875bee478f4f12b5f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9a31eb8c7221442e29fdd7bedff777d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9a31eb8c7221442e29fdd7bedff777d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dfa80c2bb4b41ad1f4f2d9b3379c23e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/dfa80c2bb4b41ad1f4f2d9b3379c23e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1dd8138a57410e080139be38c9151549.jpg\" _src=\"http://yanxuan.nosdn.127.net/1dd8138a57410e080139be38c9151549.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef479caa6cade6fad11b472e7d88b32d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef479caa6cade6fad11b472e7d88b32d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca1274dba63b3724363013f0889d27d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca1274dba63b3724363013f0889d27d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef8630d2570b39482323005f17856f2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef8630d2570b39482323005f17856f2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4310dae760926e986ad306497b75d502.jpg\" _src=\"http://yanxuan.nosdn.127.net/4310dae760926e986ad306497b75d502.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8fc3b621830f3250b178c0280338d3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8fc3b621830f3250b178c0280338d3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7dd45ccd5d58ad39cf689c8c0fc3421.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7dd45ccd5d58ad39cf689c8c0fc3421.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd84fa8e26379ed62b898d37f38b2966.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd84fa8e26379ed62b898d37f38b2966.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b6c3fc3cdb1a8094a6b996ea7e1b2f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b6c3fc3cdb1a8094a6b996ea7e1b2f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3563863f4c84f7bb03ee7149040703a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3563863f4c84f7bb03ee7149040703a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86a88e931b695c0debba11096c6c147c.jpg\" _src=\"http://yanxuan.nosdn.127.net/86a88e931b695c0debba11096c6c147c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/378a2655e2eb74b1acb53bec21990328.jpg\" _src=\"http://yanxuan.nosdn.127.net/378a2655e2eb74b1acb53bec21990328.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c211cf4c59a1e130ab95ddaf349a2d9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c211cf4c59a1e130ab95ddaf349a2d9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fe46e709449593e186603f018b9d523.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fe46e709449593e186603f018b9d523.jpg\" style=\"\"/></p><p><span style=\";font-family:&#39;微软雅黑&#39;,sans-serif\"></span><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/ddbe8ccfd223207921aaae7ebfac711a.jpg', 'http://yanxuan.nosdn.127.net/fea36ef2514c904f4f45f1975f37f289.png', '3899.00', '171', '1101020', '0.00', '限时购', '', '0.00', '0', '0', '0', '4288.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097012', '1015000', '1097012', '原素系列实木床头柜', '0', '100', '', '优选实木环保喷漆', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/238979c72b45c63ef0c26cc3f208c24a.jpg\" _src=\"http://yanxuan.nosdn.127.net/238979c72b45c63ef0c26cc3f208c24a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6a6406660c4bb14aa5aa32ced2475d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6a6406660c4bb14aa5aa32ced2475d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c6f4a141b15b9d5fb09081e2ee007c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c6f4a141b15b9d5fb09081e2ee007c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/899dbf43caa50235a4c718a801b4f64d.jpg\" _src=\"http://yanxuan.nosdn.127.net/899dbf43caa50235a4c718a801b4f64d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9591f4fa45d1cef7ecff6d3247b53a78.jpg\" _src=\"http://yanxuan.nosdn.127.net/9591f4fa45d1cef7ecff6d3247b53a78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/509fa0f4c705a906b456c16681418cb1.jpg\" _src=\"http://yanxuan.nosdn.127.net/509fa0f4c705a906b456c16681418cb1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9f46c0f718844a88102e9bfe1b3d501.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9f46c0f718844a88102e9bfe1b3d501.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5f8bbffd2090ecdbe92d53d9ce61953.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5f8bbffd2090ecdbe92d53d9ce61953.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0650a0798bdddede6022860db1e6f4a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/0650a0798bdddede6022860db1e6f4a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51d71823797efe66fb69f6de3ceca2bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/51d71823797efe66fb69f6de3ceca2bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9cb565e337069f9e51f39404aeaf1b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9cb565e337069f9e51f39404aeaf1b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9009e63d05b4d89efd0965b8b5e23b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9009e63d05b4d89efd0965b8b5e23b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f75e1707d99f9422534e58a959fee95.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f75e1707d99f9422534e58a959fee95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fd8d9b751a18c54324d585419ab1bd9.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fd8d9b751a18c54324d585419ab1bd9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19ee4851b74de9c57ad61f735f375d92.jpg\" _src=\"http://yanxuan.nosdn.127.net/19ee4851b74de9c57ad61f735f375d92.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/654f10d84c0497f3ae5e041eb97f4c05.jpg\" _src=\"http://yanxuan.nosdn.127.net/654f10d84c0497f3ae5e041eb97f4c05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/915c6a22fdf515046fa91af4691defe4.jpg\" _src=\"http://yanxuan.nosdn.127.net/915c6a22fdf515046fa91af4691defe4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df0c8dcdfabd8a95fa29a867e3255c29.jpg\" _src=\"http://yanxuan.nosdn.127.net/df0c8dcdfabd8a95fa29a867e3255c29.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/582c0162501a42e0e0a7328d5feb3106.jpg\" _src=\"http://yanxuan.nosdn.127.net/582c0162501a42e0e0a7328d5feb3106.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c42982318f69d3346ec2a82a14540e29.jpg\" _src=\"http://yanxuan.nosdn.127.net/c42982318f69d3346ec2a82a14540e29.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e3ac2d640de7f07d154fbfdc1cc9f7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e3ac2d640de7f07d154fbfdc1cc9f7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff4a616ec16e16636438daa4c5a0aedd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff4a616ec16e16636438daa4c5a0aedd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09afec9d5a321dc66e6353ed4f1f0a88.jpg\" _src=\"http://yanxuan.nosdn.127.net/09afec9d5a321dc66e6353ed4f1f0a88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06ac3ec8f269aafd50280d69d0ace542.jpg\" _src=\"http://yanxuan.nosdn.127.net/06ac3ec8f269aafd50280d69d0ace542.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13390514772fa5c0511cf877384c5967.jpg\" _src=\"http://yanxuan.nosdn.127.net/13390514772fa5c0511cf877384c5967.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5def98ab674d3e7ba552f7953b4d0ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5def98ab674d3e7ba552f7953b4d0ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c0a68da2c5bc6dfe2edb083c4e6857.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c0a68da2c5bc6dfe2edb083c4e6857.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/984dc2d147c24a010d834faab8c1b490.jpg\" _src=\"http://yanxuan.nosdn.127.net/984dc2d147c24a010d834faab8c1b490.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc9af77bb88eed9a275f62d54d253565.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc9af77bb88eed9a275f62d54d253565.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf45035c5ad6ab556a323e9394a5a343.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf45035c5ad6ab556a323e9394a5a343.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/092b9c36d92c0b934f0f735f6a002870.jpg\" _src=\"http://yanxuan.nosdn.127.net/092b9c36d92c0b934f0f735f6a002870.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a254dc606f602a0b6b2c6d44bdc469d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a254dc606f602a0b6b2c6d44bdc469d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/105f9d8225bb1419ad74f1d086bd6e5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/105f9d8225bb1419ad74f1d086bd6e5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a44ec7f133fe4287b13826b57c5abffd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a44ec7f133fe4287b13826b57c5abffd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/030796ac206bcd42b67978845b447b12.jpg\" _src=\"http://yanxuan.nosdn.127.net/030796ac206bcd42b67978845b447b12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a94af3b8d46322ac6462a5f82956b40.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a94af3b8d46322ac6462a5f82956b40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6265c235aea2e46abb491893f03f140e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6265c235aea2e46abb491893f03f140e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8ae1848d01a8838e45a6e617eef1688.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8ae1848d01a8838e45a6e617eef1688.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e15ff8e4623cd04d7b00f8ef4d8e483.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e15ff8e4623cd04d7b00f8ef4d8e483.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0a3d1531a63dd4759e0d9f7ac95867c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0a3d1531a63dd4759e0d9f7ac95867c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f79dd58a774e67c00130d627fa27432f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f79dd58a774e67c00130d627fa27432f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d21aed141eec8a35473421c944bc11f.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d21aed141eec8a35473421c944bc11f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84a05603d247ac7844e34303c331cda7.jpg\" _src=\"http://yanxuan.nosdn.127.net/84a05603d247ac7844e34303c331cda7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04e9e06a31fefbf7367ea1b2f6568f13.jpg\" _src=\"http://yanxuan.nosdn.127.net/04e9e06a31fefbf7367ea1b2f6568f13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b7296733795bfaec5e8e6e4912e9a86.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b7296733795bfaec5e8e6e4912e9a86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f52d17c64c1811724d6da9da99681f35.jpg\" _src=\"http://yanxuan.nosdn.127.net/f52d17c64c1811724d6da9da99681f35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57d5404f47a37bf0b493ad221673eaf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/57d5404f47a37bf0b493ad221673eaf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51aa72f915854b188685815911cb7142.jpg\" _src=\"http://yanxuan.nosdn.127.net/51aa72f915854b188685815911cb7142.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2c870921c25b954f0002f7ecd87f65a.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2c870921c25b954f0002f7ecd87f65a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46652beff7453ea7d7a8cb328e970096.jpg\" _src=\"http://yanxuan.nosdn.127.net/46652beff7453ea7d7a8cb328e970096.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dca90945bcb58dbe42aae95fb2f13d05.jpg\" _src=\"http://yanxuan.nosdn.127.net/dca90945bcb58dbe42aae95fb2f13d05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcdc8097c0601d33d0d38ddee071eac5.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcdc8097c0601d33d0d38ddee071eac5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3de10373c9564e19227b36bb87b4c54c.jpg\" _src=\"http://yanxuan.nosdn.127.net/3de10373c9564e19227b36bb87b4c54c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aed6b405c05dfb6ba99d962eb0e5595a.jpg\" _src=\"http://yanxuan.nosdn.127.net/aed6b405c05dfb6ba99d962eb0e5595a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ee8db965663cb56bf72db129f31538e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ee8db965663cb56bf72db129f31538e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9772abcdc399359fd3c7a3d085d118f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/9772abcdc399359fd3c7a3d085d118f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a02d075328c85343150f8f7bfdf7574.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a02d075328c85343150f8f7bfdf7574.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5ea9f0e6abaf5cf57507b41c87de88f.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5ea9f0e6abaf5cf57507b41c87de88f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1baa7efe96e3fc9e07525e91441ea046.jpg\" _src=\"http://yanxuan.nosdn.127.net/1baa7efe96e3fc9e07525e91441ea046.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7375e9cb1bcf2467aba09fbecaf116f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7375e9cb1bcf2467aba09fbecaf116f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/184eb6d8a1008b7f1e5d748de8a84cff.jpg\" _src=\"http://yanxuan.nosdn.127.net/184eb6d8a1008b7f1e5d748de8a84cff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/730b15a3d8cce55ea086ea43554894ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/730b15a3d8cce55ea086ea43554894ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8094d38182cc2b81e18c1917bf239978.jpg\" _src=\"http://yanxuan.nosdn.127.net/8094d38182cc2b81e18c1917bf239978.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7942e6a1899d7a5d2948f86abdfbaba.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7942e6a1899d7a5d2948f86abdfbaba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5420bc44ee4354b3e5871bc17e525cb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/5420bc44ee4354b3e5871bc17e525cb8.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2d2011f2901fd6ab732fb866dd115c6f.jpg', 'http://yanxuan.nosdn.127.net/d659d5ce0efaa9baa43abb6e34a1d9fe.png', '999.00', '499', '1101021', '0.00', '限时购', '', '0.00', '0', '0', '0', '1098.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097013', '1015000', '1097013', '原素系列实木五斗柜', '0', '100', '', '造型经典，收纳的得力助手', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/dc2db7dbdf8fc64ec212c7787d797584.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc2db7dbdf8fc64ec212c7787d797584.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d41eb0097f889c8a12f4017f773d4abd.jpg\" _src=\"http://yanxuan.nosdn.127.net/d41eb0097f889c8a12f4017f773d4abd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70f7c00b74aa8b36d910a4da85235b3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/70f7c00b74aa8b36d910a4da85235b3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7761512bfdfb4a193cb95341aa1ae4a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/7761512bfdfb4a193cb95341aa1ae4a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b797463f12bb5eb2cbb579edf8bb944a.jpg\" _src=\"http://yanxuan.nosdn.127.net/b797463f12bb5eb2cbb579edf8bb944a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bdb99e123342fff3ad6d81cfb1e1745.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bdb99e123342fff3ad6d81cfb1e1745.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9e1ffd4df8a56a4f9faf3f581d947dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9e1ffd4df8a56a4f9faf3f581d947dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c6d3bd8ce53ab8a4c1353859b1dde18.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c6d3bd8ce53ab8a4c1353859b1dde18.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/631c3fe003418edb9eb5cec8d28a2561.jpg\" _src=\"http://yanxuan.nosdn.127.net/631c3fe003418edb9eb5cec8d28a2561.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8bf5f009be9301d14944a2b51822e76f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8bf5f009be9301d14944a2b51822e76f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b616b92608df8dd75db3735e1a22b4de.jpg\" _src=\"http://yanxuan.nosdn.127.net/b616b92608df8dd75db3735e1a22b4de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/727a3c97d8017ab0b2060538568a4966.jpg\" _src=\"http://yanxuan.nosdn.127.net/727a3c97d8017ab0b2060538568a4966.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/798be4a5f6f44c5f5ce7c1971606e906.jpg\" _src=\"http://yanxuan.nosdn.127.net/798be4a5f6f44c5f5ce7c1971606e906.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c46f4165a866c879ca876b78863da6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c46f4165a866c879ca876b78863da6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67194ec73a2f07887d884ea9db3479ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/67194ec73a2f07887d884ea9db3479ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6c6db271981d780292897db54dacee7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6c6db271981d780292897db54dacee7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fee182b0b2baffb54bf98962c998ce72.jpg\" _src=\"http://yanxuan.nosdn.127.net/fee182b0b2baffb54bf98962c998ce72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dfdf78844362f1be4c6e1db6b25b3695.jpg\" _src=\"http://yanxuan.nosdn.127.net/dfdf78844362f1be4c6e1db6b25b3695.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92b7ac1f8a02d49e029563f511461b76.jpg\" _src=\"http://yanxuan.nosdn.127.net/92b7ac1f8a02d49e029563f511461b76.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6da54ea8b7832d761e8cb658953d9f2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6da54ea8b7832d761e8cb658953d9f2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24fb5114468000b0c2612edd1bef33e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/24fb5114468000b0c2612edd1bef33e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ec58b360c13e517d7c8c53adcac8775.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ec58b360c13e517d7c8c53adcac8775.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d4de4815851edf7c6e4e19cc9d41ce5.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d4de4815851edf7c6e4e19cc9d41ce5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ee1042a9f3b1f9ed45f75159b0c29ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ee1042a9f3b1f9ed45f75159b0c29ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afb4fe1697eaf9546f8b767443edf93e.jpg\" _src=\"http://yanxuan.nosdn.127.net/afb4fe1697eaf9546f8b767443edf93e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72957c944e643192531839bd4e231b2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/72957c944e643192531839bd4e231b2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4083055f1894143c045bfecc48b29296.jpg\" _src=\"http://yanxuan.nosdn.127.net/4083055f1894143c045bfecc48b29296.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/011638f8b7a1aa127867883b6388ae74.jpg\" _src=\"http://yanxuan.nosdn.127.net/011638f8b7a1aa127867883b6388ae74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c77c193d57081d4a8e4525439cb4a71.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c77c193d57081d4a8e4525439cb4a71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1915621fa0354b5a9420c6359109a27.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1915621fa0354b5a9420c6359109a27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3b3308400d5e211a81e687670810d77.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3b3308400d5e211a81e687670810d77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c46c1d1402b9a77b91974c359be56f5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c46c1d1402b9a77b91974c359be56f5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e535a12daed7c39c4aa5570fb2625d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e535a12daed7c39c4aa5570fb2625d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/801eca75c0eb42306fd7406b2ae618a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/801eca75c0eb42306fd7406b2ae618a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0f886e08c4462409b89bd8fd396330a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0f886e08c4462409b89bd8fd396330a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c624ad00f8e30b16f849682b106efe4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c624ad00f8e30b16f849682b106efe4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6c97dd61baee5163990bba13da47bfb.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6c97dd61baee5163990bba13da47bfb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/175b48dd90fdf48ad11fb3adb14eefb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/175b48dd90fdf48ad11fb3adb14eefb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f7b484f6f73e2219e3795ea1c703372.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f7b484f6f73e2219e3795ea1c703372.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1298aa4a32821fed86a187772f91e501.jpg\" _src=\"http://yanxuan.nosdn.127.net/1298aa4a32821fed86a187772f91e501.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b2ad158eaa25dfd41e5b06adbf1b407.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b2ad158eaa25dfd41e5b06adbf1b407.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d89dd00f1caf4d526249adc4181a2e99.jpg\" _src=\"http://yanxuan.nosdn.127.net/d89dd00f1caf4d526249adc4181a2e99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3298f143fb2b26c3b7bb523a31cb1757.jpg\" _src=\"http://yanxuan.nosdn.127.net/3298f143fb2b26c3b7bb523a31cb1757.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fd8ecae65b6f2505b264ca213a82440.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fd8ecae65b6f2505b264ca213a82440.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9837402a142180692b46b889223cca5.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9837402a142180692b46b889223cca5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a34341d9cfc27a5604a510338922f475.jpg\" _src=\"http://yanxuan.nosdn.127.net/a34341d9cfc27a5604a510338922f475.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0a2b385526d3f2327a3a5b16febec6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0a2b385526d3f2327a3a5b16febec6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff499476410f1b33271430961c863f8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff499476410f1b33271430961c863f8a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e399836357b7e389da29ba89c1881f35.jpg\" _src=\"http://yanxuan.nosdn.127.net/e399836357b7e389da29ba89c1881f35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76fe162e6babc3312560093add8fe80a.jpg\" _src=\"http://yanxuan.nosdn.127.net/76fe162e6babc3312560093add8fe80a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7036e822a0e9ad3c58307b688116b0e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/7036e822a0e9ad3c58307b688116b0e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b6a7c6e1534b312b73122ae278c3011.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b6a7c6e1534b312b73122ae278c3011.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a89a02a091760d926cb76fdb23e5f4c.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a89a02a091760d926cb76fdb23e5f4c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fb7c5bad6e1e4d15db7a8f0d2b85968.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fb7c5bad6e1e4d15db7a8f0d2b85968.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5b686aafaa6c919b5e73e9ab7f1c3e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5b686aafaa6c919b5e73e9ab7f1c3e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23e4f3e92053652b14cc838c51cc6aa6.jpg\" _src=\"http://yanxuan.nosdn.127.net/23e4f3e92053652b14cc838c51cc6aa6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5114b8851071720dfa1cad81bd1f4e30.jpg\" _src=\"http://yanxuan.nosdn.127.net/5114b8851071720dfa1cad81bd1f4e30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5dd7d1a57fd99b7b13afb02ae12f21ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/5dd7d1a57fd99b7b13afb02ae12f21ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eea52eb6087118139f01a612346a7afa.jpg\" _src=\"http://yanxuan.nosdn.127.net/eea52eb6087118139f01a612346a7afa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b61875f598deca70970aa7f95b3f682e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b61875f598deca70970aa7f95b3f682e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d9c6c13c1e4203b1bd00879f65b9117.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d9c6c13c1e4203b1bd00879f65b9117.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef19f548f29f1025b4c99ed1bda93bb6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef19f548f29f1025b4c99ed1bda93bb6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62b153529c6690d937964f49f89c7efb.jpg\" _src=\"http://yanxuan.nosdn.127.net/62b153529c6690d937964f49f89c7efb.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '10', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/b5a76d361f0c2fd353a49c25ba2c5497.jpg', 'http://yanxuan.nosdn.127.net/2fa8cb066a356f47a3f0814e99fee7f2.png', '2699.00', '454', '1101022', '0.00', '限时购', '', '0.00', '0', '0', '0', '2968.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097014', '1015000', '1097014', '原素系列实木多抽柜', '0', '100', '', '造型简约，拥有极高实用性', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/ef99349c5eb83e54b478eec3fa65a310.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef99349c5eb83e54b478eec3fa65a310.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/762eb77e92abe416a06faad8ddb35583.jpg\" _src=\"http://yanxuan.nosdn.127.net/762eb77e92abe416a06faad8ddb35583.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a3073565d50e6782bf0d7599156cc8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a3073565d50e6782bf0d7599156cc8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8222d9dc821459c8ad41aa7de68d558f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8222d9dc821459c8ad41aa7de68d558f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1259063900c9b116aecfccd874ddcfeb.jpg\" _src=\"http://yanxuan.nosdn.127.net/1259063900c9b116aecfccd874ddcfeb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8529d9e746ac3a436d70e85f9161324f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8529d9e746ac3a436d70e85f9161324f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3527b3c73c93a31387391c854852abcf.jpg\" _src=\"http://yanxuan.nosdn.127.net/3527b3c73c93a31387391c854852abcf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/660afcd62a4cff3f3718d5787ffcab87.jpg\" _src=\"http://yanxuan.nosdn.127.net/660afcd62a4cff3f3718d5787ffcab87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8afbad6710682c1cf65942d7277357d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8afbad6710682c1cf65942d7277357d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/633e43127b97ff9013e878c7e6ff582a.jpg\" _src=\"http://yanxuan.nosdn.127.net/633e43127b97ff9013e878c7e6ff582a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e69b288ad072eafa78d3b79ddadb50d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e69b288ad072eafa78d3b79ddadb50d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6bd1b14140f2d45de97af450b2d538e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6bd1b14140f2d45de97af450b2d538e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f248ed3aa76314be7e6ad9fd2e5ff05.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f248ed3aa76314be7e6ad9fd2e5ff05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f56e66a67f2a67383519a5a5c3d15aca.jpg\" _src=\"http://yanxuan.nosdn.127.net/f56e66a67f2a67383519a5a5c3d15aca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e26670843fc8c1ecb68772b1c174f776.jpg\" _src=\"http://yanxuan.nosdn.127.net/e26670843fc8c1ecb68772b1c174f776.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d985448edf5e42b8f2fbf398e7db73a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d985448edf5e42b8f2fbf398e7db73a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b4a4e6074cec4b33e277cd8c25e2a5e.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b4a4e6074cec4b33e277cd8c25e2a5e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d509990b252361e8130edbf9159c2174.jpg\" _src=\"http://yanxuan.nosdn.127.net/d509990b252361e8130edbf9159c2174.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f92e1d8429907261fedee84659b8950.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f92e1d8429907261fedee84659b8950.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d56545b368cc333ec7c321a6143d7e6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/d56545b368cc333ec7c321a6143d7e6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce66819b53a451883045d322742652c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce66819b53a451883045d322742652c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/963c3642c771fc61999ec18fb7d7eabc.jpg\" _src=\"http://yanxuan.nosdn.127.net/963c3642c771fc61999ec18fb7d7eabc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf2e680711049910648b4530d96e0a03.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf2e680711049910648b4530d96e0a03.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f3ff55ea5e7beb3b0314d1e1836dc0ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/f3ff55ea5e7beb3b0314d1e1836dc0ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5138e0a83de877a28cd208f30ff9977e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5138e0a83de877a28cd208f30ff9977e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5465e86f2fd8887d2fdc8a780f42411.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5465e86f2fd8887d2fdc8a780f42411.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7de1f14338addd00eb6741ce73ea155a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7de1f14338addd00eb6741ce73ea155a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/920417b3dd55449942d561391f53a1bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/920417b3dd55449942d561391f53a1bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48775e406649e90fa88da650d2840d13.jpg\" _src=\"http://yanxuan.nosdn.127.net/48775e406649e90fa88da650d2840d13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/860f0ec1334472f3afb6a2ceffb96f3a.jpg\" _src=\"http://yanxuan.nosdn.127.net/860f0ec1334472f3afb6a2ceffb96f3a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6c0733584a6a6785124c6e11331f0d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6c0733584a6a6785124c6e11331f0d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdec357b9997a5d4fdf46e2168927198.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdec357b9997a5d4fdf46e2168927198.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3181ed09c8c96a7c06f3c008b4f39185.jpg\" _src=\"http://yanxuan.nosdn.127.net/3181ed09c8c96a7c06f3c008b4f39185.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b87b67b653e03dc4eeaead46fa6ee94.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b87b67b653e03dc4eeaead46fa6ee94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4313e76ac21af69e217f0c01da9236ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/4313e76ac21af69e217f0c01da9236ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40668f39aecde7d82fed6b1aa0aae167.jpg\" _src=\"http://yanxuan.nosdn.127.net/40668f39aecde7d82fed6b1aa0aae167.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/859901f9e06ca2fe1f3452d3d0bdfb05.jpg\" _src=\"http://yanxuan.nosdn.127.net/859901f9e06ca2fe1f3452d3d0bdfb05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/705f06f1574da8e0d3426f7ddfe0c94f.jpg\" _src=\"http://yanxuan.nosdn.127.net/705f06f1574da8e0d3426f7ddfe0c94f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac96aaabf1ef2eabb93c0b2e37ac82bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac96aaabf1ef2eabb93c0b2e37ac82bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4343c28a9dda3e5909817ef7ec10b772.jpg\" _src=\"http://yanxuan.nosdn.127.net/4343c28a9dda3e5909817ef7ec10b772.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2013629b638725ec1f267bac2435c20b.jpg\" _src=\"http://yanxuan.nosdn.127.net/2013629b638725ec1f267bac2435c20b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c55424ee7156a077a475baaa3fa65b96.jpg\" _src=\"http://yanxuan.nosdn.127.net/c55424ee7156a077a475baaa3fa65b96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcece03933901f9ac6c4f9d9e3447ec0.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcece03933901f9ac6c4f9d9e3447ec0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/417d92b9326be44d14f1b8993079ebdb.jpg\" _src=\"http://yanxuan.nosdn.127.net/417d92b9326be44d14f1b8993079ebdb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fb0108eae01559802740c0d01cae5bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fb0108eae01559802740c0d01cae5bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c929794b0d347bf5403d234b37db5ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c929794b0d347bf5403d234b37db5ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4aeb21ac1546937ae3945e4e11442ee8.jpg\" _src=\"http://yanxuan.nosdn.127.net/4aeb21ac1546937ae3945e4e11442ee8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19b637e0dfc1a91aa2c399d3f38022c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/19b637e0dfc1a91aa2c399d3f38022c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ece55d9b9f686a7ccfa819047929bc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ece55d9b9f686a7ccfa819047929bc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/261884870cb1b96467a44274d3e14cd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/261884870cb1b96467a44274d3e14cd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab839173c1e5ddc477f09fe141bcad05.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab839173c1e5ddc477f09fe141bcad05.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1686ba353fc15365a8c9ae8851e59ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1686ba353fc15365a8c9ae8851e59ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbb7b58343d252f6e390e6c691fb01b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbb7b58343d252f6e390e6c691fb01b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3687f04750278c839cbda303dc66665.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3687f04750278c839cbda303dc66665.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55e96d7f34c87fcb91ca8e6bd9d29f0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/55e96d7f34c87fcb91ca8e6bd9d29f0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a184b659e8eb6044a3abb0dc268d6c75.jpg\" _src=\"http://yanxuan.nosdn.127.net/a184b659e8eb6044a3abb0dc268d6c75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db96bea8d127274ea0b644b356189065.jpg\" _src=\"http://yanxuan.nosdn.127.net/db96bea8d127274ea0b644b356189065.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f1a64b6e6e7cd4402da98eaa7df1078.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f1a64b6e6e7cd4402da98eaa7df1078.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f110f01c2296fb8a5afb6683d4fa709.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f110f01c2296fb8a5afb6683d4fa709.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80d37527aa5ca88128b83d1a001c4acb.jpg\" _src=\"http://yanxuan.nosdn.127.net/80d37527aa5ca88128b83d1a001c4acb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/040d932689fa4d9d50f605861e577c66.jpg\" _src=\"http://yanxuan.nosdn.127.net/040d932689fa4d9d50f605861e577c66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fc0b276bc30d9b97c6a3247ea387ffe.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fc0b276bc30d9b97c6a3247ea387ffe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/045810b852d55f7329116c401a31b189.jpg\" _src=\"http://yanxuan.nosdn.127.net/045810b852d55f7329116c401a31b189.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72be8acaecda6612ddcd72bc8c6105a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/72be8acaecda6612ddcd72bc8c6105a3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/39930be3b58671c3f5e0d6c1c1ac9b1f.jpg', 'http://yanxuan.nosdn.127.net/308184b7b1965470d58b5c92e9bcc4b0.png', '4199.00', '150', '1101023', '0.00', '限时购', '', '0.00', '0', '0', '0', '4618.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097016', '1015000', '1097016', '原素系列1.8米实木电视柜', '0', '100', '', '经典木纹，结实不易蛀', '<p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/44b6e7dc5b6c81d2ab52965d4277069f.jpg\" _src=\"http://yanxuan.nosdn.127.net/44b6e7dc5b6c81d2ab52965d4277069f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcca6fe2d34bf2f9deb0648f71520f30.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcca6fe2d34bf2f9deb0648f71520f30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aabddf6f4c7a53e3eba126e4b276fff4.jpg\" _src=\"http://yanxuan.nosdn.127.net/aabddf6f4c7a53e3eba126e4b276fff4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a3cc2cb018b860f64f4751455df03db.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a3cc2cb018b860f64f4751455df03db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6c930edc71fb258e502960a17a49d60.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6c930edc71fb258e502960a17a49d60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26937caee8633848c0e43ecf64159e1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/26937caee8633848c0e43ecf64159e1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ce3eefbfae7df5c2ece6f9d5b1d5ddc.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ce3eefbfae7df5c2ece6f9d5b1d5ddc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d97ae87e7f5677530ce0e23445fb6c47.jpg\" _src=\"http://yanxuan.nosdn.127.net/d97ae87e7f5677530ce0e23445fb6c47.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a688f1c4296e3df7b3125043e6b287b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a688f1c4296e3df7b3125043e6b287b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a22a64c9fd560a37c7368cb940cdf39.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a22a64c9fd560a37c7368cb940cdf39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a37794473dc3d10bb87b1511cfb157e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a37794473dc3d10bb87b1511cfb157e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f8c08a400891e0d727cce3e02f2a9cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f8c08a400891e0d727cce3e02f2a9cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a9b95b81dc87ade2dae8455dfa70f71.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a9b95b81dc87ade2dae8455dfa70f71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a318f83f7e741a57d2c371add04bdcb7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a318f83f7e741a57d2c371add04bdcb7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0bf6a1072b4211ebe786d02f79bf9f9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0bf6a1072b4211ebe786d02f79bf9f9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6366e7ee9e1d6f870d9ec224be204393.jpg\" _src=\"http://yanxuan.nosdn.127.net/6366e7ee9e1d6f870d9ec224be204393.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92a8acf9892bb8be48d05b00f2b06287.jpg\" _src=\"http://yanxuan.nosdn.127.net/92a8acf9892bb8be48d05b00f2b06287.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ac784566dbca7db0397d65511a415bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ac784566dbca7db0397d65511a415bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a63f8fc1b71bf2f2fc058be514f9bb0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a63f8fc1b71bf2f2fc058be514f9bb0b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b304440c45568fdf2a884bbd7c1d862f.jpg\" _src=\"http://yanxuan.nosdn.127.net/b304440c45568fdf2a884bbd7c1d862f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00225ba12a7b1875a3552124638b3fb5.jpg\" _src=\"http://yanxuan.nosdn.127.net/00225ba12a7b1875a3552124638b3fb5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e3d391896a17264363649dbd2d230ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e3d391896a17264363649dbd2d230ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e85fff39a870f0065dcaedd7090295d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e85fff39a870f0065dcaedd7090295d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76c2eb79d09058f144770a3e3ed454da.jpg\" _src=\"http://yanxuan.nosdn.127.net/76c2eb79d09058f144770a3e3ed454da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6984afaebcdea88c71859c6ab5c81a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6984afaebcdea88c71859c6ab5c81a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da21ae14501b6623d526c1833bf3dc1f.jpg\" _src=\"http://yanxuan.nosdn.127.net/da21ae14501b6623d526c1833bf3dc1f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b5c29fdc5661e7eebe1ac488606bb8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b5c29fdc5661e7eebe1ac488606bb8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17be6bb120caaa67e01f4ff2f4c7bc78.jpg\" _src=\"http://yanxuan.nosdn.127.net/17be6bb120caaa67e01f4ff2f4c7bc78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/538e87bdf30f230b75903a730f94e620.jpg\" _src=\"http://yanxuan.nosdn.127.net/538e87bdf30f230b75903a730f94e620.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/126ec76486adf5fc1dc0230034726e48.jpg\" _src=\"http://yanxuan.nosdn.127.net/126ec76486adf5fc1dc0230034726e48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95da7cddda7a7ebf4f36fc08b06832f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/95da7cddda7a7ebf4f36fc08b06832f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9fb8f3ce1ab9cd3b2e4fcd53e696a944.jpg\" _src=\"http://yanxuan.nosdn.127.net/9fb8f3ce1ab9cd3b2e4fcd53e696a944.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22b0e01eacf86ab7823feea43bd4d0be.jpg\" _src=\"http://yanxuan.nosdn.127.net/22b0e01eacf86ab7823feea43bd4d0be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13972e19bcf8b0f41a68d4c274647e53.jpg\" _src=\"http://yanxuan.nosdn.127.net/13972e19bcf8b0f41a68d4c274647e53.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5e8268da72bb8ff8015a7b01bda6a8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5e8268da72bb8ff8015a7b01bda6a8a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7a1aa60d75a80af1e68a744bd3e123e.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7a1aa60d75a80af1e68a744bd3e123e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56a09cc322e51db98f651ea83a7ae8aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/56a09cc322e51db98f651ea83a7ae8aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2c7ac5c5bd979b1954f7d333f2c1ee1.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2c7ac5c5bd979b1954f7d333f2c1ee1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45bf007e71b1e95b6b3c6c6d28c0b8be.jpg\" _src=\"http://yanxuan.nosdn.127.net/45bf007e71b1e95b6b3c6c6d28c0b8be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/313454239e6634684a0d0cc0fe3d1e32.jpg\" _src=\"http://yanxuan.nosdn.127.net/313454239e6634684a0d0cc0fe3d1e32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a00dcf4350a1fd53bbad22201fb18c86.jpg\" _src=\"http://yanxuan.nosdn.127.net/a00dcf4350a1fd53bbad22201fb18c86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f3cef060508ea355880f0e20499ce2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f3cef060508ea355880f0e20499ce2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36d01093773b7f39bf5101fdc35b2213.jpg\" _src=\"http://yanxuan.nosdn.127.net/36d01093773b7f39bf5101fdc35b2213.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c199ec2930f47473a99b15f4391c18a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c199ec2930f47473a99b15f4391c18a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63c1381ec4738b5d4dc1acac15422e92.jpg\" _src=\"http://yanxuan.nosdn.127.net/63c1381ec4738b5d4dc1acac15422e92.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23c89550b230dee4a20921f4f0483952.jpg\" _src=\"http://yanxuan.nosdn.127.net/23c89550b230dee4a20921f4f0483952.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4de06540256e87372f470b3687dafdf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/4de06540256e87372f470b3687dafdf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d54b68e9dafd399cee92e7ca05549380.jpg\" _src=\"http://yanxuan.nosdn.127.net/d54b68e9dafd399cee92e7ca05549380.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dcfc93486d1c038857da4fd4520071e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/dcfc93486d1c038857da4fd4520071e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbb98e1c909d9dee01113698b0443c44.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbb98e1c909d9dee01113698b0443c44.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cf5e7dad6e7f852e2e62ff9ace0cd11.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cf5e7dad6e7f852e2e62ff9ace0cd11.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51d6247fe63d021e1c7d14eb4a88fb68.jpg\" _src=\"http://yanxuan.nosdn.127.net/51d6247fe63d021e1c7d14eb4a88fb68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7813e01f85c84e337b0f4166684f4bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7813e01f85c84e337b0f4166684f4bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b74ef03be759d25e51db6fd0f7af132.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b74ef03be759d25e51db6fd0f7af132.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0d827799c22c17972e0efbf789ae006.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0d827799c22c17972e0efbf789ae006.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6966951b50edc83e6921fcdb6555568.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6966951b50edc83e6921fcdb6555568.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58be70e959a829f8ba297dcfc123ddc2.jpg\" _src=\"http://yanxuan.nosdn.127.net/58be70e959a829f8ba297dcfc123ddc2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/300f3edcb171aa84c859812b5753ffdd.jpg\" _src=\"http://yanxuan.nosdn.127.net/300f3edcb171aa84c859812b5753ffdd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/905332c0591fc457b45fbb20359d5438.jpg\" _src=\"http://yanxuan.nosdn.127.net/905332c0591fc457b45fbb20359d5438.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6060be7ea7012cbfbaf10d052d086c7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6060be7ea7012cbfbaf10d052d086c7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/051e2c5ee2245183e3e860c406de857f.jpg\" _src=\"http://yanxuan.nosdn.127.net/051e2c5ee2245183e3e860c406de857f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36c381f0d73d2e1ee47ce1e631bf25ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/36c381f0d73d2e1ee47ce1e631bf25ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5993aa4449716cca44eb3b985fe7c083.jpg\" _src=\"http://yanxuan.nosdn.127.net/5993aa4449716cca44eb3b985fe7c083.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e3ac2f6017945ac341a3df5b63fde1f7.jpg', 'http://yanxuan.nosdn.127.net/a7e6df722b82ad1b0158adcbdcf30df9.png', '2799.00', '452', '1101026', '0.00', '限时购', '', '0.00', '0', '0', '0', '3078.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1097017', '1015000', '1097017', '原素系列柜式实木茶几', '0', '100', '', '山形木纹，经典优雅', '<p><strong><span style=\";font-family:&#39;微软雅黑&#39;,sans-serif\"></span></strong></p><p style=\"white-space: normal;\"><span style=\"color: rgb(255, 0, 0);\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></span></p><p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></span></p><p style=\"white-space: normal;\"><span style=\"font-weight: 700;\"><span style=\"font-family: 微软雅黑, sans-serif;\">温馨提示：</span></span><br/></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1，由于<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>，要求所有木制品办理《植物检疫证书》，因此暂停向<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽黄山市</span></span>和<span style=\"font-weight: 700;\"><span style=\"color: red;\">安徽宣城绩溪县</span></span>运输家具，以上两地客户请注意不要购买，<span style=\"font-weight: 700;\"><span style=\"color: red;\">物流无法派送</span></span>，对此给您带来的不便，我们深表歉意！</span></p><p style=\"white-space: normal;\"><span style=\"font-family: 微软雅黑, sans-serif;\"></span></p><p style=\"white-space: normal;\">2，家具送货上门时请拆开包装，待组装完成后，仔细检查家具是否有磕碰，少件等问题，如有不满请拒收或进行异常签收，我们会保障您的权益。</p><p style=\"white-space: normal;\">3，因个人原因首次送货上门暂不安装，要求二次上门安装的，会额外收取费用，请您与安装服务公司进行协商。</p><p><img src=\"http://yanxuan.nosdn.127.net/841d0245c3c293c098a145782488282f.jpg\" _src=\"http://yanxuan.nosdn.127.net/841d0245c3c293c098a145782488282f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/002898cb089ad88e1abc63ddcf643b23.jpg\" _src=\"http://yanxuan.nosdn.127.net/002898cb089ad88e1abc63ddcf643b23.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad23b01cae88f09dd983516207ce3861.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad23b01cae88f09dd983516207ce3861.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0d8e8dd42109e803133242b877fb32b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0d8e8dd42109e803133242b877fb32b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa23960ab3667c12f4e4ea859d2367cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa23960ab3667c12f4e4ea859d2367cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17e0d578f0ebe4382b82f7b611963f8c.jpg\" _src=\"http://yanxuan.nosdn.127.net/17e0d578f0ebe4382b82f7b611963f8c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4444dc7a8c6a0ef8ea34a24036ebf80a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4444dc7a8c6a0ef8ea34a24036ebf80a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bad5cb0f13c145ba19a0b9bd6ce01b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bad5cb0f13c145ba19a0b9bd6ce01b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e0be64c0c6a38b8bd18eeaf791a0ebd4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e0be64c0c6a38b8bd18eeaf791a0ebd4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c77bd07085abe7f2091ba7beefd680e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/c77bd07085abe7f2091ba7beefd680e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54259cd72a15918cddf08bda2a947f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/54259cd72a15918cddf08bda2a947f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a55cba8c61795a33962c3c09944583c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a55cba8c61795a33962c3c09944583c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b44ef9f2febea836a4304a8c1668732.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b44ef9f2febea836a4304a8c1668732.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c9438b10357f0104cc34fcf34e94385.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c9438b10357f0104cc34fcf34e94385.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3cb8c4054046e9d3b29b4137d3ac12b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3cb8c4054046e9d3b29b4137d3ac12b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a2fcaba246296ecbe02efd78ce96f2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a2fcaba246296ecbe02efd78ce96f2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/806394a28ca3ae2c2764915d7782474f.jpg\" _src=\"http://yanxuan.nosdn.127.net/806394a28ca3ae2c2764915d7782474f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62afa297c045f34be45f70ca38cd9fa8.jpg\" _src=\"http://yanxuan.nosdn.127.net/62afa297c045f34be45f70ca38cd9fa8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36d8d1e21236aaab71a6577885211094.jpg\" _src=\"http://yanxuan.nosdn.127.net/36d8d1e21236aaab71a6577885211094.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b07d3aa8633e3868ce21758511a29a2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b07d3aa8633e3868ce21758511a29a2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34d2c9575927e78edc22c5743c95e3af.jpg\" _src=\"http://yanxuan.nosdn.127.net/34d2c9575927e78edc22c5743c95e3af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07ae428baefa5af751d9b8bd2d69b2ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/07ae428baefa5af751d9b8bd2d69b2ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/628e973a1596886f63c7d615be90b235.jpg\" _src=\"http://yanxuan.nosdn.127.net/628e973a1596886f63c7d615be90b235.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d6b0f8948523c65945bb61d36b90ed0.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d6b0f8948523c65945bb61d36b90ed0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2734227815c9afaa127e962ef7383688.jpg\" _src=\"http://yanxuan.nosdn.127.net/2734227815c9afaa127e962ef7383688.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4120d4a10d0af37a6c21a93a90b313a.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4120d4a10d0af37a6c21a93a90b313a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e4493cf8485e9f57d843db48f972ffc.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e4493cf8485e9f57d843db48f972ffc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef76a92c0cf8546f509815e030eab5d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef76a92c0cf8546f509815e030eab5d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab2fe9eb2bdf1a14228b30bbc48b51cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab2fe9eb2bdf1a14228b30bbc48b51cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e592f842000465d9ee258796213463d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e592f842000465d9ee258796213463d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b44f0c61c5064c73159283fa083bfd4.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b44f0c61c5064c73159283fa083bfd4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cd92b89f49e036f29fcb760ec43620d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cd92b89f49e036f29fcb760ec43620d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/344d391a8f49df91334bbd9b92ffdb74.jpg\" _src=\"http://yanxuan.nosdn.127.net/344d391a8f49df91334bbd9b92ffdb74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb2c7b3e0bc070c6fafa3124c0d0e1a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb2c7b3e0bc070c6fafa3124c0d0e1a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8f33436750f6979e7bc8d3b063d6b4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8f33436750f6979e7bc8d3b063d6b4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/734abf2642b4b6d1758b090da76e6bd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/734abf2642b4b6d1758b090da76e6bd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b65e79b70b7ba95b952d41fe4d6049a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b65e79b70b7ba95b952d41fe4d6049a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef22b52ba666ac6027511874cf6d2a5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef22b52ba666ac6027511874cf6d2a5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09d642d719505973c084194da921bfc3.jpg\" _src=\"http://yanxuan.nosdn.127.net/09d642d719505973c084194da921bfc3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67143c94cd2d5ce3b2d98c7b44e5d82a.jpg\" _src=\"http://yanxuan.nosdn.127.net/67143c94cd2d5ce3b2d98c7b44e5d82a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82bc7d5e4efa2cc0cf8a2f688a4cf2f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/82bc7d5e4efa2cc0cf8a2f688a4cf2f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcc87da6b0b8188753898379480fef5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcc87da6b0b8188753898379480fef5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e92cf0c3678425bb5637ee506ff9e146.jpg\" _src=\"http://yanxuan.nosdn.127.net/e92cf0c3678425bb5637ee506ff9e146.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2052c09588cca803a6d9f741f0202e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2052c09588cca803a6d9f741f0202e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a684f5a95c259965494f989af45a2499.jpg\" _src=\"http://yanxuan.nosdn.127.net/a684f5a95c259965494f989af45a2499.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81cfd3f623164f158203c2d2622ad3bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/81cfd3f623164f158203c2d2622ad3bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fed14ad7c4fea2f7c4da28a0b597c988.jpg\" _src=\"http://yanxuan.nosdn.127.net/fed14ad7c4fea2f7c4da28a0b597c988.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bda3ced5296582c66353f100ab801e7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/bda3ced5296582c66353f100ab801e7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d38146b1fb1c23806d4737a3d2770cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d38146b1fb1c23806d4737a3d2770cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/837bba6263b0228b5d764fa224ac7f68.jpg\" _src=\"http://yanxuan.nosdn.127.net/837bba6263b0228b5d764fa224ac7f68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ade8dbc66d4c00f0bfc4c18f15d800a.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ade8dbc66d4c00f0bfc4c18f15d800a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a257a7e42071267775ce1028a51641c.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a257a7e42071267775ce1028a51641c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb0638aff2af73a5baed49270510e962.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb0638aff2af73a5baed49270510e962.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/005b5e2ea26484f4bf83a6a07cb45259.jpg\" _src=\"http://yanxuan.nosdn.127.net/005b5e2ea26484f4bf83a6a07cb45259.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55331e0b451080d567d84540e8919279.jpg\" _src=\"http://yanxuan.nosdn.127.net/55331e0b451080d567d84540e8919279.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcc86d2b7f9eaed847f3af168a357796.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcc86d2b7f9eaed847f3af168a357796.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0ffd18f60560e7b3058b2741db7daee.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0ffd18f60560e7b3058b2741db7daee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a07622cf90c90f3c95975f7715e877fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/a07622cf90c90f3c95975f7715e877fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36e3cade2a47fef47d5499b8e6d08835.jpg\" _src=\"http://yanxuan.nosdn.127.net/36e3cade2a47fef47d5499b8e6d08835.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/483c0af4d43b1227d2d410153bf1a6d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/483c0af4d43b1227d2d410153bf1a6d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d8db3ba36a01a32a133e7c5f3afc228.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d8db3ba36a01a32a133e7c5f3afc228.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c326fd7fe0e301b231239ba0b3fb7b41.jpg\" _src=\"http://yanxuan.nosdn.127.net/c326fd7fe0e301b231239ba0b3fb7b41.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/51c00df46743a33758dece025641a7b8.jpg', 'http://yanxuan.nosdn.127.net/e16ff61bef76db81090db191b9d5ec15.png', '2199.00', '216', '1101027', '0.00', '限时购', '', '0.00', '0', '0', '0', '2418.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1100000', '1008009', '1100000', '300根水洗棉缎纹纯色枕套*2', '0', '100', '', '水洗棉的呵护，透气亲肤', '<p><img src=\"http://yanxuan.nosdn.127.net/2164615ef532024ac711e6296ad3d705.jpg\" _src=\"http://yanxuan.nosdn.127.net/2164615ef532024ac711e6296ad3d705.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61e79183390cf672ad9be0d3442041e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/61e79183390cf672ad9be0d3442041e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc024462d81766a7224ab3545fb6d98f.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc024462d81766a7224ab3545fb6d98f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2cf4a3a51c4b68e55d2e7f2d13ca543.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2cf4a3a51c4b68e55d2e7f2d13ca543.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f5c0f96d6c54ec2a23ef365036456f6c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f5c0f96d6c54ec2a23ef365036456f6c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e63577594a28504eec2e0197f7ddadf8.jpg\" _src=\"http://yanxuan.nosdn.127.net/e63577594a28504eec2e0197f7ddadf8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cde5c10b5076f1b92e96e1c02ca7ff48.jpg\" _src=\"http://yanxuan.nosdn.127.net/cde5c10b5076f1b92e96e1c02ca7ff48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b035b6b8208aa9c2ad954f30fef99775.jpg\" _src=\"http://yanxuan.nosdn.127.net/b035b6b8208aa9c2ad954f30fef99775.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/27cf1dd613ee7b01e4f90bce31a34a89.jpg\" _src=\"http://yanxuan.nosdn.127.net/27cf1dd613ee7b01e4f90bce31a34a89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e6edf415e99e2ba2beeae4e6a38da856.jpg\" _src=\"http://yanxuan.nosdn.127.net/e6edf415e99e2ba2beeae4e6a38da856.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be546650b508f5576267423da697ccef.jpg\" _src=\"http://yanxuan.nosdn.127.net/be546650b508f5576267423da697ccef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f387f9fbb09cb79e125efa85a3af051.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f387f9fbb09cb79e125efa85a3af051.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb0702de3a208768da04e2bcfb8dfb7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb0702de3a208768da04e2bcfb8dfb7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/520d7e3a895b1171ceba26f5a0f390e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/520d7e3a895b1171ceba26f5a0f390e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1bc14f1cf49d21c3b86e033029cb927a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1bc14f1cf49d21c3b86e033029cb927a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d6cda639968622812a712d4230cefcc8.jpg\" _src=\"http://yanxuan.nosdn.127.net/d6cda639968622812a712d4230cefcc8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07ef76fe3850a0ef4c708fbf6698c506.jpg\" _src=\"http://yanxuan.nosdn.127.net/07ef76fe3850a0ef4c708fbf6698c506.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5336250c74718eb078b218820220a4c1.jpg\" _src=\"http://yanxuan.nosdn.127.net/5336250c74718eb078b218820220a4c1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09fdc6f77e536aab39bc7b89a35c6959.jpg\" _src=\"http://yanxuan.nosdn.127.net/09fdc6f77e536aab39bc7b89a35c6959.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2500886b52d9d4fdd143fa7c2b3e5446.jpg\" _src=\"http://yanxuan.nosdn.127.net/2500886b52d9d4fdd143fa7c2b3e5446.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b2a4e13d9bb597131df9e1bcfe5a9b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b2a4e13d9bb597131df9e1bcfe5a9b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7fe46cf57f0d9cc349acfe7e657bcd3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7fe46cf57f0d9cc349acfe7e657bcd3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/deac82fd0b4571e3c13d52e50e62b302.jpg\" _src=\"http://yanxuan.nosdn.127.net/deac82fd0b4571e3c13d52e50e62b302.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b36159471e198538107b92489180a4b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b36159471e198538107b92489180a4b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ac810650922fb01cdb193b31484d79d.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ac810650922fb01cdb193b31484d79d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f02de2f5574a50022a9e8ffd518298b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f02de2f5574a50022a9e8ffd518298b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ae5b6a1c345825c13de51b0727cc855.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ae5b6a1c345825c13de51b0727cc855.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/41149b83c142ba653b93223f9ed56301.jpg\" _src=\"http://yanxuan.nosdn.127.net/41149b83c142ba653b93223f9ed56301.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4f64c2bb342bd18e9d76d145b63c89a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4f64c2bb342bd18e9d76d145b63c89a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e84264a53c8a4cb00f0e5e1577b2fb01.jpg\" _src=\"http://yanxuan.nosdn.127.net/e84264a53c8a4cb00f0e5e1577b2fb01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/055385e03a51dfef123a2d0163d75a42.jpg\" _src=\"http://yanxuan.nosdn.127.net/055385e03a51dfef123a2d0163d75a42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9373db501542f25f812c3fecb45b4ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9373db501542f25f812c3fecb45b4ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/51e7c319c838513a20b510d989ed0080.jpg\" _src=\"http://yanxuan.nosdn.127.net/51e7c319c838513a20b510d989ed0080.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a4310313b7d5cb6a970b3136438aed4.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a4310313b7d5cb6a970b3136438aed4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5c25568e6495ad3352388dd2c9f0719.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5c25568e6495ad3352388dd2c9f0719.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79698caf7fc4cb8f99daed2b2cdeb0ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/79698caf7fc4cb8f99daed2b2cdeb0ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6d3d314ed9a188abd8cf244fce029d9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6d3d314ed9a188abd8cf244fce029d9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/adc3da2545131a5535d2d948dbd35ff7.jpg\" _src=\"http://yanxuan.nosdn.127.net/adc3da2545131a5535d2d948dbd35ff7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76314625178eab034fe81ccc6f8efc2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/76314625178eab034fe81ccc6f8efc2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73dddf214a50cde45620c4b629b72693.jpg\" _src=\"http://yanxuan.nosdn.127.net/73dddf214a50cde45620c4b629b72693.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8457cc3e51cb1061e02f69c6bc16e97c.jpg\" _src=\"http://yanxuan.nosdn.127.net/8457cc3e51cb1061e02f69c6bc16e97c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7cec5452f51eb8ca4930941da82d329.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7cec5452f51eb8ca4930941da82d329.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80c359e06e6d28c2dd2582401746dc4e.jpg\" _src=\"http://yanxuan.nosdn.127.net/80c359e06e6d28c2dd2582401746dc4e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3c56725175efa21648f094d644ec879.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3c56725175efa21648f094d644ec879.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15474760d9e688b80758b23c88a7ffb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/15474760d9e688b80758b23c88a7ffb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e2acf365def8ed93f62f05b3ccb2d33.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e2acf365def8ed93f62f05b3ccb2d33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd4fcf9d4b37cb6146dfd32c7c2da790.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd4fcf9d4b37cb6146dfd32c7c2da790.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/070861a329f22e78579bc114dee3d51c.jpg\" _src=\"http://yanxuan.nosdn.127.net/070861a329f22e78579bc114dee3d51c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8ea41b6c4d1fae0986f6ec2c9f16933.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8ea41b6c4d1fae0986f6ec2c9f16933.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '25', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/0006d55e3f95f50e2a02d409ab6ab8a2.jpg', 'http://yanxuan.nosdn.127.net/15e40cfb6a78f557616814a815685fd4.png', '79.00', '548', '1103000', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1100001', '1008009', '1100001', '300根水洗棉缎纹纯色床单', '0', '100', '', '水洗棉的柔软舒适，百分百的亲肤呵护', '<p><img src=\"http://yanxuan.nosdn.127.net/52a02aab5a4659f282fc638b350d7f95.jpg\" _src=\"http://yanxuan.nosdn.127.net/52a02aab5a4659f282fc638b350d7f95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fe116f74bd0d14270c0990d1daf06b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fe116f74bd0d14270c0990d1daf06b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90882a17a426788993a81da84b4c7fbd.jpg\" _src=\"http://yanxuan.nosdn.127.net/90882a17a426788993a81da84b4c7fbd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54d8848ead619164ebbfa7b67d448a47.jpg\" _src=\"http://yanxuan.nosdn.127.net/54d8848ead619164ebbfa7b67d448a47.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/766865b5d8124fe105cc5039521ce22f.jpg\" _src=\"http://yanxuan.nosdn.127.net/766865b5d8124fe105cc5039521ce22f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a91ebe3b5a7173d1540ed41114427a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a91ebe3b5a7173d1540ed41114427a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43502a858916eb140f3bfc95f90f61f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/43502a858916eb140f3bfc95f90f61f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b98b6b62828b7cf8ffeba592261d6d75.jpg\" _src=\"http://yanxuan.nosdn.127.net/b98b6b62828b7cf8ffeba592261d6d75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e40587f3bf72c40ff72fa3e1b9639e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e40587f3bf72c40ff72fa3e1b9639e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81ade842bf7a9a87313fa55e1d4a7ff5.jpg\" _src=\"http://yanxuan.nosdn.127.net/81ade842bf7a9a87313fa55e1d4a7ff5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1369e140bea5d9d1d807ac6a2184540.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1369e140bea5d9d1d807ac6a2184540.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9dfa33237be0666a2eafcb4144c6507f.jpg\" _src=\"http://yanxuan.nosdn.127.net/9dfa33237be0666a2eafcb4144c6507f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aebe79ce72d63dca6044d90ae42306b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/aebe79ce72d63dca6044d90ae42306b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd202b7b2c6939abfd9ec86ec4fcd04c.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd202b7b2c6939abfd9ec86ec4fcd04c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c90927890e763a70b7c022ae52bb3933.jpg\" _src=\"http://yanxuan.nosdn.127.net/c90927890e763a70b7c022ae52bb3933.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be7692bb8797f05e9ca5ecc53980bcfb.jpg\" _src=\"http://yanxuan.nosdn.127.net/be7692bb8797f05e9ca5ecc53980bcfb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d719888db5c6a6d02de04fafeee52d34.jpg\" _src=\"http://yanxuan.nosdn.127.net/d719888db5c6a6d02de04fafeee52d34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9932f0c40aa4f0683d49dd279ac8cb37.jpg\" _src=\"http://yanxuan.nosdn.127.net/9932f0c40aa4f0683d49dd279ac8cb37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b45044e18872c3fee33abf7c9a4756a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b45044e18872c3fee33abf7c9a4756a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b1448b186b8958ec8451079b43a3fa6.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b1448b186b8958ec8451079b43a3fa6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04e7d6d26a3a7793c1fcfa85ce88930a.jpg\" _src=\"http://yanxuan.nosdn.127.net/04e7d6d26a3a7793c1fcfa85ce88930a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f8133c402129a909bcbfb1a510957b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f8133c402129a909bcbfb1a510957b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/997486762d960d57f9a60a5e927adcb0.jpg\" _src=\"http://yanxuan.nosdn.127.net/997486762d960d57f9a60a5e927adcb0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7c7488aa89d34886e1b7b94dc78aaf4.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7c7488aa89d34886e1b7b94dc78aaf4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d426c800a38b6fd9b0e89f905d5861e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d426c800a38b6fd9b0e89f905d5861e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92bc77c3893766d512d699420043250e.jpg\" _src=\"http://yanxuan.nosdn.127.net/92bc77c3893766d512d699420043250e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2cab9c7a67ba1a816be3c3cbb6db6719.jpg\" _src=\"http://yanxuan.nosdn.127.net/2cab9c7a67ba1a816be3c3cbb6db6719.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7809202f7f45fd5082a0899c0faa8a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7809202f7f45fd5082a0899c0faa8a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11f16921d77e740616262bb89cae747c.jpg\" _src=\"http://yanxuan.nosdn.127.net/11f16921d77e740616262bb89cae747c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ad1a0b186d1d3653788849eee22b0701.jpg\" _src=\"http://yanxuan.nosdn.127.net/ad1a0b186d1d3653788849eee22b0701.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/15e219fb1ff21dcdf1149b4728f29c38.jpg\" _src=\"http://yanxuan.nosdn.127.net/15e219fb1ff21dcdf1149b4728f29c38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c6c27566ad4ef4db783464203ec0b17.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c6c27566ad4ef4db783464203ec0b17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbaed905816e210992ff56c11515baee.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbaed905816e210992ff56c11515baee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab11d74c2e950bc4926df20d2f3289c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab11d74c2e950bc4926df20d2f3289c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6caf7b9fa56455f4efaff939a0894c89.jpg\" _src=\"http://yanxuan.nosdn.127.net/6caf7b9fa56455f4efaff939a0894c89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11e1c56f129c68f2e668f35af5647a8c.jpg\" _src=\"http://yanxuan.nosdn.127.net/11e1c56f129c68f2e668f35af5647a8c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e922764d150632e8acae2280b3c61570.jpg\" _src=\"http://yanxuan.nosdn.127.net/e922764d150632e8acae2280b3c61570.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/450b0a0b0c624d559c27beabe6f9aeb9.jpg\" _src=\"http://yanxuan.nosdn.127.net/450b0a0b0c624d559c27beabe6f9aeb9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2bde52261504acd71ee7fd7394cc5f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2bde52261504acd71ee7fd7394cc5f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4010b0e19f9ccc01152e0004e90040ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/4010b0e19f9ccc01152e0004e90040ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b848a59522b381140e6ea54381fe60f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b848a59522b381140e6ea54381fe60f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6a55c1b12fe7478e6cb502fb3a89ab2.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6a55c1b12fe7478e6cb502fb3a89ab2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d04e5c6151fcd296c03e3636cc400ddf.jpg\" _src=\"http://yanxuan.nosdn.127.net/d04e5c6151fcd296c03e3636cc400ddf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f490ab8e9bbd286e47c0a8f3bd4adeee.jpg\" _src=\"http://yanxuan.nosdn.127.net/f490ab8e9bbd286e47c0a8f3bd4adeee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2710161ba5f0e64807a6282255bb686.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2710161ba5f0e64807a6282255bb686.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb7229e9c581b844289fe81bc0b88cb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb7229e9c581b844289fe81bc0b88cb3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ff64ea78659fd39b7934247a148e04b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ff64ea78659fd39b7934247a148e04b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c18fbe31057289c95fe5afd601ae00ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/c18fbe31057289c95fe5afd601ae00ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1358116cd85df0f6bb586e5714b15578.jpg\" _src=\"http://yanxuan.nosdn.127.net/1358116cd85df0f6bb586e5714b15578.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '30', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/697f5dc50b04d28a54bd2eac2d99df61.jpg', 'http://yanxuan.nosdn.127.net/a95285853138cbaf56e4ba729f2b8749.png', '199.00', '7591', '1103002', '0.00', '限时购', '', '0.00', '0', '0', '0', '218.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1100002', '1008009', '1100002', '300根水洗棉缎纹纯色床笠', '0', '100', '', '柔软水洗棉，百分百的呵护', '<p><img src=\"http://yanxuan.nosdn.127.net/b113c05377e190d731c8276e5799387c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b113c05377e190d731c8276e5799387c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1599d7e6b6912cc1d385d1eb4da29f32.jpg\" _src=\"http://yanxuan.nosdn.127.net/1599d7e6b6912cc1d385d1eb4da29f32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33d3d8ff4e26960705bda55bd7dab175.jpg\" _src=\"http://yanxuan.nosdn.127.net/33d3d8ff4e26960705bda55bd7dab175.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbefed7e260fc9e54098ae9b7cfad1af.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbefed7e260fc9e54098ae9b7cfad1af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c822575867fa4918096666cf661feae.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c822575867fa4918096666cf661feae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6eff8d3a5ae780b159c0d9e95b63c9c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6eff8d3a5ae780b159c0d9e95b63c9c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f02dc5450a320e0658a029e5190b9784.jpg\" _src=\"http://yanxuan.nosdn.127.net/f02dc5450a320e0658a029e5190b9784.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d93ca19fd2008710ee23112e22667072.jpg\" _src=\"http://yanxuan.nosdn.127.net/d93ca19fd2008710ee23112e22667072.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e6e1cce60f15101d79f4ba3ed162ff7.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e6e1cce60f15101d79f4ba3ed162ff7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0102e764033c3954289920cb6e10826a.jpg\" _src=\"http://yanxuan.nosdn.127.net/0102e764033c3954289920cb6e10826a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5274a83fe9644269f81a39d157b0885.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5274a83fe9644269f81a39d157b0885.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db217c5ee31c601dabaf53c5231d638f.jpg\" _src=\"http://yanxuan.nosdn.127.net/db217c5ee31c601dabaf53c5231d638f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f3cd27ea1974a41d88352c5359ef218b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f3cd27ea1974a41d88352c5359ef218b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/449851f2dc340c54b373c28e0e28e43a.jpg\" _src=\"http://yanxuan.nosdn.127.net/449851f2dc340c54b373c28e0e28e43a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f758ecf146bd7ce77316d1ccb4d85136.jpg\" _src=\"http://yanxuan.nosdn.127.net/f758ecf146bd7ce77316d1ccb4d85136.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7d3a08f3d596f44bd144f1874f01d2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7d3a08f3d596f44bd144f1874f01d2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/701d32168cc8568cb9282fa7bac3e97f.jpg\" _src=\"http://yanxuan.nosdn.127.net/701d32168cc8568cb9282fa7bac3e97f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32df87bc772fbb87bbd704e6f3f9152f.jpg\" _src=\"http://yanxuan.nosdn.127.net/32df87bc772fbb87bbd704e6f3f9152f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbccd6766fd90ef1c4b7926a6da42914.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbccd6766fd90ef1c4b7926a6da42914.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9248b70482bf6c0c08bfd7dc1825ff2.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9248b70482bf6c0c08bfd7dc1825ff2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd52704b957a03bd7652a8abfc79169f.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd52704b957a03bd7652a8abfc79169f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95fed81f2051ac18aed79ac65506bcc7.jpg\" _src=\"http://yanxuan.nosdn.127.net/95fed81f2051ac18aed79ac65506bcc7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8ff2d10eb455e26fbd49ca8577a748e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8ff2d10eb455e26fbd49ca8577a748e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e72b42e17384d7375eae6188db4a0b3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/e72b42e17384d7375eae6188db4a0b3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a19cc090a4e878096c2e9bd1aa57255c.jpg\" _src=\"http://yanxuan.nosdn.127.net/a19cc090a4e878096c2e9bd1aa57255c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8b63b926799b86237f9da0c09d9b9b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8b63b926799b86237f9da0c09d9b9b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c42156238f6747c56169e48ed2332fbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/c42156238f6747c56169e48ed2332fbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3727a66cd1faf92f17b6e42d1ac9ce5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3727a66cd1faf92f17b6e42d1ac9ce5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20706d16caf832cbbc9336e777298b2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/20706d16caf832cbbc9336e777298b2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b199e8aad7dc32d9da9e2acae4a9f7f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/b199e8aad7dc32d9da9e2acae4a9f7f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6171ea81148f8349f2a3e7795f9a797.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6171ea81148f8349f2a3e7795f9a797.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53c24120423d4ab3e0682b34d165cce0.jpg\" _src=\"http://yanxuan.nosdn.127.net/53c24120423d4ab3e0682b34d165cce0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2998210b6516bb72ca4ecc552fe1c452.jpg\" _src=\"http://yanxuan.nosdn.127.net/2998210b6516bb72ca4ecc552fe1c452.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40a3b58c8994da5f68c9a70603cfc69f.jpg\" _src=\"http://yanxuan.nosdn.127.net/40a3b58c8994da5f68c9a70603cfc69f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/676acaa002d43fe87c7f08891ce1e375.jpg\" _src=\"http://yanxuan.nosdn.127.net/676acaa002d43fe87c7f08891ce1e375.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/061f47e80f9ba0b14d0f6ff1d97832b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/061f47e80f9ba0b14d0f6ff1d97832b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d68d15ac856a5f394be758f5b14472d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/d68d15ac856a5f394be758f5b14472d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e17041f2ab2fd90d4d645c2b81e117ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/e17041f2ab2fd90d4d645c2b81e117ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91ce73361dca495fc01ea078c63be200.jpg\" _src=\"http://yanxuan.nosdn.127.net/91ce73361dca495fc01ea078c63be200.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b301b6dd7ccd1476e20eb87ac93fd21.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b301b6dd7ccd1476e20eb87ac93fd21.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f28caeb1ae005bbbf13e445cd81d70f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f28caeb1ae005bbbf13e445cd81d70f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f96513f4cf52f2cd0caf5a49f0cf47a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f96513f4cf52f2cd0caf5a49f0cf47a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b50b75e2af4c9c60f8bbc92df33557c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/b50b75e2af4c9c60f8bbc92df33557c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8dd9c0862e37cfddf42257403759c56.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8dd9c0862e37cfddf42257403759c56.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c8b1b6c2dbe8c26a13b4e4ac9a5f523.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c8b1b6c2dbe8c26a13b4e4ac9a5f523.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d14380f50a2484cfbfe6d4b55e254ee3.jpg\" _src=\"http://yanxuan.nosdn.127.net/d14380f50a2484cfbfe6d4b55e254ee3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b2c0b030495b0c1970026e643eb74d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b2c0b030495b0c1970026e643eb74d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8edef8d8fa2c866a6d37088cc4888f51.jpg\" _src=\"http://yanxuan.nosdn.127.net/8edef8d8fa2c866a6d37088cc4888f51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2759420c8d3cb17f8df32845feb3e8c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2759420c8d3cb17f8df32845feb3e8c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/076653218d9bb6fbd2009edd2a7b55d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/076653218d9bb6fbd2009edd2a7b55d7.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '29', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/59f33deb148b9e384aa8cbdf481badb0.jpg', 'http://yanxuan.nosdn.127.net/edf1945ef594c00920bdc727f4c5c7fd.png', '189.00', '7881', '1103008', '0.00', '限时购', '', '0.00', '0', '0', '0', '207.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1108029', '1017000', '1108029', '宠物多功能喂水喂食器', '0', '100', '', '喂水喂食一体机', '<p><img src=\"http://yanxuan.nosdn.127.net/3bf8e67e0463e2571d37012a325db488.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bf8e67e0463e2571d37012a325db488.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4e77fa5bca0ae2f7a8958c9e140df1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4e77fa5bca0ae2f7a8958c9e140df1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36191cbd08985b5243cd772f3e9aaac5.jpg\" _src=\"http://yanxuan.nosdn.127.net/36191cbd08985b5243cd772f3e9aaac5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29e2ae41fdc593c30ec5ec0aa626cb2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/29e2ae41fdc593c30ec5ec0aa626cb2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43dca05a07c303b53fab3abc8c24859b.jpg\" _src=\"http://yanxuan.nosdn.127.net/43dca05a07c303b53fab3abc8c24859b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62a3bfcdcfe31d37b94c19b54f3f6a9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/62a3bfcdcfe31d37b94c19b54f3f6a9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7533bfcc453038ce04c41528fe21b8da.jpg\" _src=\"http://yanxuan.nosdn.127.net/7533bfcc453038ce04c41528fe21b8da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bda204fa9f136c9cb96648b010f6a10c.jpg\" _src=\"http://yanxuan.nosdn.127.net/bda204fa9f136c9cb96648b010f6a10c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5388fcb07fdb920e3395107edc539a40.jpg\" _src=\"http://yanxuan.nosdn.127.net/5388fcb07fdb920e3395107edc539a40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22c61bb098f35b258c56cb125c151188.jpg\" _src=\"http://yanxuan.nosdn.127.net/22c61bb098f35b258c56cb125c151188.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0009cc0c641be4894ca7ad2eb783fd4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0009cc0c641be4894ca7ad2eb783fd4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7db29c859575edeb95c9441765ace2fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/7db29c859575edeb95c9441765ace2fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb3b43977f90bd58c8d43ec9bc21dd39.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb3b43977f90bd58c8d43ec9bc21dd39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f52aa926637aa95ab37d68a56f858b76.jpg\" _src=\"http://yanxuan.nosdn.127.net/f52aa926637aa95ab37d68a56f858b76.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/96197f28360be46a045dd84f7c9c3d92.jpg\" _src=\"http://yanxuan.nosdn.127.net/96197f28360be46a045dd84f7c9c3d92.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d782399abb5589ad73cf07e334500fe8.jpg\" _src=\"http://yanxuan.nosdn.127.net/d782399abb5589ad73cf07e334500fe8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84ca5f52f317691f9916c11f9376b730.jpg\" _src=\"http://yanxuan.nosdn.127.net/84ca5f52f317691f9916c11f9376b730.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de7ae0e78a5ce6912a7ef425fadf0eca.jpg\" _src=\"http://yanxuan.nosdn.127.net/de7ae0e78a5ce6912a7ef425fadf0eca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/145e3897ee245669d592ee2565679d6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/145e3897ee245669d592ee2565679d6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03ed7555a00651cf887bbae7642166bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/03ed7555a00651cf887bbae7642166bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ffc5597f1d9c3c1fa4c69d35a214b035.jpg\" _src=\"http://yanxuan.nosdn.127.net/ffc5597f1d9c3c1fa4c69d35a214b035.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/256469fef7985abc5996136246ca8b00.jpg\" _src=\"http://yanxuan.nosdn.127.net/256469fef7985abc5996136246ca8b00.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2020ded743ca398a6842c33cb40e2877.jpg\" _src=\"http://yanxuan.nosdn.127.net/2020ded743ca398a6842c33cb40e2877.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39d806810ce52681e6ba7d2fbbf251c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/39d806810ce52681e6ba7d2fbbf251c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a68e8f40bb91921ae319ec2f0f5f6c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a68e8f40bb91921ae319ec2f0f5f6c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b874965467b55c34b0f28bad35b03bf9.jpg\" _src=\"http://yanxuan.nosdn.127.net/b874965467b55c34b0f28bad35b03bf9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29bd66954c53e023364968cc908f87fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/29bd66954c53e023364968cc908f87fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69eaa19be01f0f5b9435ddda59015b33.jpg\" _src=\"http://yanxuan.nosdn.127.net/69eaa19be01f0f5b9435ddda59015b33.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ba111a384ac2eb2cb481d767f6645c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ba111a384ac2eb2cb481d767f6645c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cff9b886b5633c4f65218bd582999a7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/cff9b886b5633c4f65218bd582999a7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccbae3f496c5330fdd213477289938e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccbae3f496c5330fdd213477289938e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c5e34fdc3c8fe76f12691b347e29664.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c5e34fdc3c8fe76f12691b347e29664.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e0483aaf7c4af0175640ecf76298c14.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e0483aaf7c4af0175640ecf76298c14.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1db819b96049f466652fdc6000c20d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1db819b96049f466652fdc6000c20d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/edd00950d840dc7200a3fe93387ace4d.jpg\" _src=\"http://yanxuan.nosdn.127.net/edd00950d840dc7200a3fe93387ace4d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f9bf5f71b81d65f3f436ecf99736a61.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f9bf5f71b81d65f3f436ecf99736a61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/353d3c382ba4d106b179efacaa5b3556.jpg\" _src=\"http://yanxuan.nosdn.127.net/353d3c382ba4d106b179efacaa5b3556.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6ff4ab6bbfcee7c86d3bedc55c0b46e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6ff4ab6bbfcee7c86d3bedc55c0b46e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a734c8741a07eded056745572d420366.jpg\" _src=\"http://yanxuan.nosdn.127.net/a734c8741a07eded056745572d420366.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a581fb66bf5b225518d68895370d0d30.jpg\" _src=\"http://yanxuan.nosdn.127.net/a581fb66bf5b225518d68895370d0d30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89462fa746af04888e42977446b109f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/89462fa746af04888e42977446b109f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa0565c8fe8106078005ef3eec6043a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa0565c8fe8106078005ef3eec6043a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4377fc275d75cbd22fd51349adf5683c.jpg\" _src=\"http://yanxuan.nosdn.127.net/4377fc275d75cbd22fd51349adf5683c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f8ad9a23c7712936bf683ad1b426a61.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f8ad9a23c7712936bf683ad1b426a61.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5a7331657407c0bcd2b441f367a0b5e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5a7331657407c0bcd2b441f367a0b5e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/723be903fc95458184906b016023f472.jpg\" _src=\"http://yanxuan.nosdn.127.net/723be903fc95458184906b016023f472.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aca7894a56492d14a66cf4489cb0101e.jpg\" _src=\"http://yanxuan.nosdn.127.net/aca7894a56492d14a66cf4489cb0101e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64444603ae2928179b5cfd8ae92751fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/64444603ae2928179b5cfd8ae92751fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d7b5fe28ee279bf0255add5693ad479.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d7b5fe28ee279bf0255add5693ad479.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a04ac95008f4ba1ca6398c724df714db.jpg\" _src=\"http://yanxuan.nosdn.127.net/a04ac95008f4ba1ca6398c724df714db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4456c996bb369b15d1d9f47eea0ac1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4456c996bb369b15d1d9f47eea0ac1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f857dd5a5e64a02c8ae2749cd1b4d28.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f857dd5a5e64a02c8ae2749cd1b4d28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/91c11fb52abf61d69c19b7b1671e333b.jpg\" _src=\"http://yanxuan.nosdn.127.net/91c11fb52abf61d69c19b7b1671e333b.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/84780d4edfd091860f2cc608752e4ca3.jpg', 'http://yanxuan.nosdn.127.net/fe52cd141b4b330db5627114b0e0e550.png', '89.00', '1001', '1109106', '0.00', '限时购', '', '0.00', '0', '0', '0', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1108030', '1017000', '1108030', '宠物便携出行圆球饮水器', '0', '100', '', '外出饮水必备', '<p><img src=\"http://yanxuan.nosdn.127.net/65458dc2797b7b9697c8fa90b082c820.jpg\" _src=\"http://yanxuan.nosdn.127.net/65458dc2797b7b9697c8fa90b082c820.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99fd8ac254bae2b9aba09ebdc864902b.jpg\" _src=\"http://yanxuan.nosdn.127.net/99fd8ac254bae2b9aba09ebdc864902b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28daf4d14b315c1dd59ab246beb09c70.jpg\" _src=\"http://yanxuan.nosdn.127.net/28daf4d14b315c1dd59ab246beb09c70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba256e0b5247705a57b1473aee17bfcc.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba256e0b5247705a57b1473aee17bfcc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/db8b0bc40c842c7850566f3505ff318c.jpg\" _src=\"http://yanxuan.nosdn.127.net/db8b0bc40c842c7850566f3505ff318c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3289160c3ef48abdf88210125f3602e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3289160c3ef48abdf88210125f3602e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39e4961981c7bef5cea9195f53dde52f.jpg\" _src=\"http://yanxuan.nosdn.127.net/39e4961981c7bef5cea9195f53dde52f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd15f95156653349523af86732a46492.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd15f95156653349523af86732a46492.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/891265e3eeeaa98cffd9f347a6d19746.jpg\" _src=\"http://yanxuan.nosdn.127.net/891265e3eeeaa98cffd9f347a6d19746.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6dfda7fdadfc0f2982e8a8597d985ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6dfda7fdadfc0f2982e8a8597d985ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef537acfb89fe4d7ba4ce414c2265783.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef537acfb89fe4d7ba4ce414c2265783.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0592ee31552e6546d8ef09516841761f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0592ee31552e6546d8ef09516841761f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f553056794ae5f695075ef2df287a8d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f553056794ae5f695075ef2df287a8d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df10a5ab1e5db7f8a591d2303d58ff43.jpg\" _src=\"http://yanxuan.nosdn.127.net/df10a5ab1e5db7f8a591d2303d58ff43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/006314c83e0089a6677c792cbf03738d.jpg\" _src=\"http://yanxuan.nosdn.127.net/006314c83e0089a6677c792cbf03738d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df80940267b26eb2c4045ab54a532a4a.jpg\" _src=\"http://yanxuan.nosdn.127.net/df80940267b26eb2c4045ab54a532a4a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/820795a6b0338fec5eb7b8e2a1faaa7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/820795a6b0338fec5eb7b8e2a1faaa7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/225046907f2abd2bb25e455bdcee1033.jpg\" _src=\"http://yanxuan.nosdn.127.net/225046907f2abd2bb25e455bdcee1033.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d98af93b7b493a396b9197853ac3bffd.jpg\" _src=\"http://yanxuan.nosdn.127.net/d98af93b7b493a396b9197853ac3bffd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c02c9759630701a781e17b55e52d348.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c02c9759630701a781e17b55e52d348.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b07ff9f11625098837642eab16a24b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b07ff9f11625098837642eab16a24b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62ba125cd3c6dbff548b4aea7052dfa2.jpg\" _src=\"http://yanxuan.nosdn.127.net/62ba125cd3c6dbff548b4aea7052dfa2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63433f85d33a5ef7680a74836a57a8a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/63433f85d33a5ef7680a74836a57a8a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b96e12210978aa545d16753583c9311.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b96e12210978aa545d16753583c9311.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/199cf634a730a1d2c85ba8564d5e1f30.jpg\" _src=\"http://yanxuan.nosdn.127.net/199cf634a730a1d2c85ba8564d5e1f30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/04b3401c50ee63e48e0acaa25188072c.jpg\" _src=\"http://yanxuan.nosdn.127.net/04b3401c50ee63e48e0acaa25188072c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab1f3b9d0b41453fa2ab69bfd8ebd609.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab1f3b9d0b41453fa2ab69bfd8ebd609.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39d2282c7716b703cb8075d97ee0b1ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/39d2282c7716b703cb8075d97ee0b1ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18a1b4b99f3e4585b5417b4494637935.jpg\" _src=\"http://yanxuan.nosdn.127.net/18a1b4b99f3e4585b5417b4494637935.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49278c041256ff111e9b0d6b19f6849a.jpg\" _src=\"http://yanxuan.nosdn.127.net/49278c041256ff111e9b0d6b19f6849a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6788d12309384b5d337976dbad1d6c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6788d12309384b5d337976dbad1d6c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c6caf545f43b018f49ee5487fc03d01.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c6caf545f43b018f49ee5487fc03d01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/27a36412d6ecec32db98dfa0b6e3af72.jpg\" _src=\"http://yanxuan.nosdn.127.net/27a36412d6ecec32db98dfa0b6e3af72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7de1b5e08e34b6063c232b51b8d6ce75.jpg\" _src=\"http://yanxuan.nosdn.127.net/7de1b5e08e34b6063c232b51b8d6ce75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c838ab94bfa6d33cfc1a04153d735ba8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c838ab94bfa6d33cfc1a04153d735ba8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc75dbcbf77c448d5387d9603b475933.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc75dbcbf77c448d5387d9603b475933.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ef8849851d3d4dcbe218462703984e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ef8849851d3d4dcbe218462703984e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ff37d4e4da2ef4de40c658a1b8f9d79.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ff37d4e4da2ef4de40c658a1b8f9d79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f55a85e695408074cc0a81750edea4f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/f55a85e695408074cc0a81750edea4f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83c6329af24cf5e90c9d5375526b36fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/83c6329af24cf5e90c9d5375526b36fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cba8e943c2625979de604dffb0f9a845.jpg\" _src=\"http://yanxuan.nosdn.127.net/cba8e943c2625979de604dffb0f9a845.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f78a2b104dbf826d95acdee5067946ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/f78a2b104dbf826d95acdee5067946ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3982351a58dca84398140880a9ff9af7.jpg\" _src=\"http://yanxuan.nosdn.127.net/3982351a58dca84398140880a9ff9af7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae786e8fbcb22eb93d28af5c258ef0e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae786e8fbcb22eb93d28af5c258ef0e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f1e30c1953432fa8e917be3a60eb8d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f1e30c1953432fa8e917be3a60eb8d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8081aaebcb364348cc135507f91a6ee2.jpg\" _src=\"http://yanxuan.nosdn.127.net/8081aaebcb364348cc135507f91a6ee2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2c7658cc55e22c82e47853cc2fe90af.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2c7658cc55e22c82e47853cc2fe90af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f7eb6a53ed6638c306c552f5254e4852.jpg\" _src=\"http://yanxuan.nosdn.127.net/f7eb6a53ed6638c306c552f5254e4852.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9fb49dcb6363fae12e5c870481af5a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9fb49dcb6363fae12e5c870481af5a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb48d2684fbeefe6943cedc53c91d871.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb48d2684fbeefe6943cedc53c91d871.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/201bae3b7e499e793d2c30cf6da70d2d.jpg\" _src=\"http://yanxuan.nosdn.127.net/201bae3b7e499e793d2c30cf6da70d2d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5baec5411baf96cd0ec794b85fd1a380.jpg\" _src=\"http://yanxuan.nosdn.127.net/5baec5411baf96cd0ec794b85fd1a380.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8408db93439d3aea4dfbe526912de53c.jpg\" _src=\"http://yanxuan.nosdn.127.net/8408db93439d3aea4dfbe526912de53c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f44ba45b1e8db330f9cd9861838369f.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f44ba45b1e8db330f9cd9861838369f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d55f64c5d91dada75147a3e64cb75cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d55f64c5d91dada75147a3e64cb75cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/971c28886097abee11d46e73dcdef3ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/971c28886097abee11d46e73dcdef3ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a75e9cd2ab8220d5f458abd29342208f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a75e9cd2ab8220d5f458abd29342208f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72eebb97ba757e5fadc1f295899c10e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/72eebb97ba757e5fadc1f295899c10e3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e2d6c0d3f04a454c4b4241549ec81fed.jpg', 'http://yanxuan.nosdn.127.net/4891e60ff08ceed36d40a754e45e8742.png', '39.00', '748', '1109109', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1108031', '1017000', '1108031', '宠物不锈钢圆形倾斜餐碗', '0', '100', '', '15°倾斜设计，保护萌宠颈椎', '<p><img src=\"http://yanxuan.nosdn.127.net/fe442c6b8b05d23d83c190640065b302.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe442c6b8b05d23d83c190640065b302.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba20be368cb41c574702e6744a0c2ce8.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba20be368cb41c574702e6744a0c2ce8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7092d305d9b11aa72f95038e90154fdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/7092d305d9b11aa72f95038e90154fdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5347b835761722810025b9f3c6b6242.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5347b835761722810025b9f3c6b6242.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3044ad714ba17abfe7bff91852dbbb7a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3044ad714ba17abfe7bff91852dbbb7a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f2e55960d44c44fe16be14ca42b79b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f2e55960d44c44fe16be14ca42b79b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ab5ffee3b444a77f27ac16a823b26e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ab5ffee3b444a77f27ac16a823b26e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/35f2901cbb277423113591ff6888679e.jpg\" _src=\"http://yanxuan.nosdn.127.net/35f2901cbb277423113591ff6888679e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f6f5b1d8a683b1250bd5ebc27b833d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f6f5b1d8a683b1250bd5ebc27b833d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d12811178bd5bcbf4a8084b96d983510.jpg\" _src=\"http://yanxuan.nosdn.127.net/d12811178bd5bcbf4a8084b96d983510.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3a91d9ab01721022697a0317d806acf1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3a91d9ab01721022697a0317d806acf1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fda53f2d82de49415036a1b7f3682897.jpg\" _src=\"http://yanxuan.nosdn.127.net/fda53f2d82de49415036a1b7f3682897.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06ad2786bb0ed2e15db6e0ca4a7f6e9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/06ad2786bb0ed2e15db6e0ca4a7f6e9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6364ac31e8f2c6dca96a15272b4bdf74.jpg\" _src=\"http://yanxuan.nosdn.127.net/6364ac31e8f2c6dca96a15272b4bdf74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63676d91181fe828d311152cf64e7c96.jpg\" _src=\"http://yanxuan.nosdn.127.net/63676d91181fe828d311152cf64e7c96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e3720a6ebaa9e055e13a59b949846a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e3720a6ebaa9e055e13a59b949846a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e7b6a3053033461ac16f131a144d712.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e7b6a3053033461ac16f131a144d712.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71a84329dd57b8ea6ea475dfc7d7ea45.jpg\" _src=\"http://yanxuan.nosdn.127.net/71a84329dd57b8ea6ea475dfc7d7ea45.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9aa4a346e8aaa99e5f0a8a8ddbbae52.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9aa4a346e8aaa99e5f0a8a8ddbbae52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/871bf338274c5a2c12fbcf47253dee9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/871bf338274c5a2c12fbcf47253dee9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e64906f44387ba5aa1fe0a46e0e868e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/e64906f44387ba5aa1fe0a46e0e868e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5aaf91ae7b9a724adbd328212717f133.jpg\" _src=\"http://yanxuan.nosdn.127.net/5aaf91ae7b9a724adbd328212717f133.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9bac8b99202edba9e578577c8b400c27.jpg\" _src=\"http://yanxuan.nosdn.127.net/9bac8b99202edba9e578577c8b400c27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/905476e8794cb20932c79fe979d4d6e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/905476e8794cb20932c79fe979d4d6e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a390619762e9aded0830c8ef7a9019cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/a390619762e9aded0830c8ef7a9019cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e6feb711c65e1df4ea4b6e219e46e5b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e6feb711c65e1df4ea4b6e219e46e5b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/384cf19dbc0d907658129066fbb677cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/384cf19dbc0d907658129066fbb677cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/559f367e0268c32cd9b1981fca44a194.jpg\" _src=\"http://yanxuan.nosdn.127.net/559f367e0268c32cd9b1981fca44a194.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b756d95d2d65bb3f88d6d0da32000c9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b756d95d2d65bb3f88d6d0da32000c9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3b9047a5c3c574137b560899d1ee719.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3b9047a5c3c574137b560899d1ee719.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19a3db18a8023be0926479cda7bccccf.jpg\" _src=\"http://yanxuan.nosdn.127.net/19a3db18a8023be0926479cda7bccccf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/75e1ddf4c49513673cff06fb12f2fe71.jpg\" _src=\"http://yanxuan.nosdn.127.net/75e1ddf4c49513673cff06fb12f2fe71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14115b6c7119e2f1941080b3c1d21aad.jpg\" _src=\"http://yanxuan.nosdn.127.net/14115b6c7119e2f1941080b3c1d21aad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57fdadf97765f41fd7137ba8f1b9d67d.jpg\" _src=\"http://yanxuan.nosdn.127.net/57fdadf97765f41fd7137ba8f1b9d67d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f240883b30ce338fcbeddcd428301ecc.jpg\" _src=\"http://yanxuan.nosdn.127.net/f240883b30ce338fcbeddcd428301ecc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/722689c017134b67bffe74ca5449cc13.jpg\" _src=\"http://yanxuan.nosdn.127.net/722689c017134b67bffe74ca5449cc13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cbafb1ac8a140f33d1e1f6d187e0f14.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cbafb1ac8a140f33d1e1f6d187e0f14.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ee61f4cbdcf2da8e794367d22951299.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ee61f4cbdcf2da8e794367d22951299.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cebd5973ee2c12a2db2e1480b6bb247e.jpg\" _src=\"http://yanxuan.nosdn.127.net/cebd5973ee2c12a2db2e1480b6bb247e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab3fa0823a7397d78d4ed76130d6e07a.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab3fa0823a7397d78d4ed76130d6e07a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a9e54a13c48800a2540eecfea8b46e2.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a9e54a13c48800a2540eecfea8b46e2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf08302aa55a026f7276c9ce7d7caf70.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf08302aa55a026f7276c9ce7d7caf70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5074c7dd82423817b5efd1440dfe0f3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5074c7dd82423817b5efd1440dfe0f3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16ada32c3b2ba7bd3781b6cbb5fc4a71.jpg\" _src=\"http://yanxuan.nosdn.127.net/16ada32c3b2ba7bd3781b6cbb5fc4a71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52a58f1c5fc81211f04bc23055421d3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/52a58f1c5fc81211f04bc23055421d3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c73e3beb3afaf28e6293e9dd4f88f1ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/c73e3beb3afaf28e6293e9dd4f88f1ba.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '10', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/240f691994caed34c6bad02130b6f3a7.jpg', 'http://yanxuan.nosdn.127.net/e13e9697e01339c6cf7479eb81b3fbe2.png', '39.00', '6243', '1109111', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1108032', '1017000', '1108032', '宠物外出便携硅胶折叠碗', '0', '100', '', '环保材质，安全出行', '<p><img src=\"http://yanxuan.nosdn.127.net/d8ff5ecd0e885adbfe48274ebd5d39c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8ff5ecd0e885adbfe48274ebd5d39c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/386b5ab03d27baa531c954db71361794.jpg\" _src=\"http://yanxuan.nosdn.127.net/386b5ab03d27baa531c954db71361794.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/854e336ce00c378a3742caf63cd646ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/854e336ce00c378a3742caf63cd646ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b50b6dcb391ad81f246ece99016d707.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b50b6dcb391ad81f246ece99016d707.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5b5c13a48aaaa82e22b79fed8995cb8d.jpg\" _src=\"http://yanxuan.nosdn.127.net/5b5c13a48aaaa82e22b79fed8995cb8d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d61a222e292b6cccd2ed7cc6a6ffcd72.jpg\" _src=\"http://yanxuan.nosdn.127.net/d61a222e292b6cccd2ed7cc6a6ffcd72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13a0a06993b8c3c5741161802704bab8.jpg\" _src=\"http://yanxuan.nosdn.127.net/13a0a06993b8c3c5741161802704bab8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a92ed8e9574aeb25974200c084e6dc0.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a92ed8e9574aeb25974200c084e6dc0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9144dd50cfd1e61b61134a369ebabd84.jpg\" _src=\"http://yanxuan.nosdn.127.net/9144dd50cfd1e61b61134a369ebabd84.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d61dd945035ad1d5be48237789b428e.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d61dd945035ad1d5be48237789b428e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9058bda517165fe7e3ea430352c92928.jpg\" _src=\"http://yanxuan.nosdn.127.net/9058bda517165fe7e3ea430352c92928.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20ff4399b56ea9702e2ffe383f4c3186.jpg\" _src=\"http://yanxuan.nosdn.127.net/20ff4399b56ea9702e2ffe383f4c3186.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/230633f83cc8f67eb8b60bba9f7344dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/230633f83cc8f67eb8b60bba9f7344dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/50917a24116c0ec917300e59980dfa70.jpg\" _src=\"http://yanxuan.nosdn.127.net/50917a24116c0ec917300e59980dfa70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f6f265dc2a7b9e92cf5e337240315f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f6f265dc2a7b9e92cf5e337240315f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec63508dc5002ea7297ceb8667c83a57.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec63508dc5002ea7297ceb8667c83a57.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8991ae264090f405222b022cf6ae171e.jpg\" _src=\"http://yanxuan.nosdn.127.net/8991ae264090f405222b022cf6ae171e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bdf14e7a0438d2c0f1773fa6f40814d.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bdf14e7a0438d2c0f1773fa6f40814d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/758fd7288c33ff3eb927d6cad168e7c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/758fd7288c33ff3eb927d6cad168e7c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56c6c022d74853fdf34229bd793a5eb5.jpg\" _src=\"http://yanxuan.nosdn.127.net/56c6c022d74853fdf34229bd793a5eb5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/886d8bbd06fb31459300b80b5b03f20d.jpg\" _src=\"http://yanxuan.nosdn.127.net/886d8bbd06fb31459300b80b5b03f20d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce994fa8073259d4862ce4bda755de96.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce994fa8073259d4862ce4bda755de96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1ea7ee36b77699babffe0f5d17f94af.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1ea7ee36b77699babffe0f5d17f94af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e7cedeedaa49ffcbd78ba47ec0bf7a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e7cedeedaa49ffcbd78ba47ec0bf7a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1d812b4e3c4ac28a63d6f1fdd1e79b89.jpg\" _src=\"http://yanxuan.nosdn.127.net/1d812b4e3c4ac28a63d6f1fdd1e79b89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99a4acbd0cf0fee6e11587311b2b8ee4.jpg\" _src=\"http://yanxuan.nosdn.127.net/99a4acbd0cf0fee6e11587311b2b8ee4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/277a754269060561028944ead40c83c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/277a754269060561028944ead40c83c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c0c08dda4d972a5d3689654e95e05af.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c0c08dda4d972a5d3689654e95e05af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5be19568b2e13c20be03aeb620ce9775.jpg\" _src=\"http://yanxuan.nosdn.127.net/5be19568b2e13c20be03aeb620ce9775.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a3e4c54c1a94d4e073f48cdf6d153888.jpg\" _src=\"http://yanxuan.nosdn.127.net/a3e4c54c1a94d4e073f48cdf6d153888.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2d98d50abb5f8d85f1c879bf0cc0889.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2d98d50abb5f8d85f1c879bf0cc0889.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba75182e971ad76f3ebc8bbf5378d8c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba75182e971ad76f3ebc8bbf5378d8c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b668c88d1068ece520560f482cf4742d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b668c88d1068ece520560f482cf4742d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4af4ee5f7669d7224e1cbba0b2c91b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4af4ee5f7669d7224e1cbba0b2c91b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/696c2a252e2ce5c82385a3b688a6189f.jpg\" _src=\"http://yanxuan.nosdn.127.net/696c2a252e2ce5c82385a3b688a6189f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/867ae15f3ad0b32c9696d67c1b0f81b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/867ae15f3ad0b32c9696d67c1b0f81b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4653f7f883e4d4415a63c049057e485.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4653f7f883e4d4415a63c049057e485.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f0ed58e5833a79f8cbb23f17197bd0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f0ed58e5833a79f8cbb23f17197bd0e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e0c022efbe3356e228af952250f1f6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e0c022efbe3356e228af952250f1f6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92c02896ef38cebb1aed42e2b9b7b8eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/92c02896ef38cebb1aed42e2b9b7b8eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0f28abcfec2fc43a58bbfac47038c6cd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0f28abcfec2fc43a58bbfac47038c6cd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f3aa08189ffd19d97d3f155b8c6394b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f3aa08189ffd19d97d3f155b8c6394b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ad916ac6db5838d6c9b0861cbfa1ec3.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ad916ac6db5838d6c9b0861cbfa1ec3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/785e8d1367c02cae12c2d6e93e61acd6.jpg\" _src=\"http://yanxuan.nosdn.127.net/785e8d1367c02cae12c2d6e93e61acd6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5138c94fecd3f99579a87b7e86089bb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/5138c94fecd3f99579a87b7e86089bb2.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '8', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/842ab8e684d5c35adc070c12efe7b927.jpg', 'http://yanxuan.nosdn.127.net/b1f9e1f700469f71fe3c4187ef53c99f.png', '29.00', '5231', '1109117', '0.00', '限时购', '', '0.00', '0', '0', '0', '31.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1109004', '1011004', '1109004', '简日挂钟', '0', '100', '', '极简风格，精确读数', '<p><img src=\"http://yanxuan.nosdn.127.net/ed6209acc582861a4532565144bef700.jpg\" _src=\"http://yanxuan.nosdn.127.net/ed6209acc582861a4532565144bef700.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d93a219ccd2cf7fbd0a6123794d78134.jpg\" _src=\"http://yanxuan.nosdn.127.net/d93a219ccd2cf7fbd0a6123794d78134.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3e1e4b0e1c00934ac0c07c4ae45a950.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3e1e4b0e1c00934ac0c07c4ae45a950.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c9c486cff57a78914ad8e4e67da3593.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c9c486cff57a78914ad8e4e67da3593.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bf1894242c6f85ccc1e344bc74a7d3fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/bf1894242c6f85ccc1e344bc74a7d3fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/131e4470d228bab143b5430da6ec0321.jpg\" _src=\"http://yanxuan.nosdn.127.net/131e4470d228bab143b5430da6ec0321.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11b92847ff14aab16ba8358dcece8abb.jpg\" _src=\"http://yanxuan.nosdn.127.net/11b92847ff14aab16ba8358dcece8abb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57477bb84bc01af24cdf48056a2caad7.jpg\" _src=\"http://yanxuan.nosdn.127.net/57477bb84bc01af24cdf48056a2caad7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61b9cb485b704ddb9f83a60fd09e91c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/61b9cb485b704ddb9f83a60fd09e91c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa87555d481801395547dd76f5a8cfd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa87555d481801395547dd76f5a8cfd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9078b58525c6f68d0e49d1bf9b634486.jpg\" _src=\"http://yanxuan.nosdn.127.net/9078b58525c6f68d0e49d1bf9b634486.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99288d5715265c7db5f95374749e5210.jpg\" _src=\"http://yanxuan.nosdn.127.net/99288d5715265c7db5f95374749e5210.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7db2e77fc52923ac4b520755390e107.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7db2e77fc52923ac4b520755390e107.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e294cb72f4597d3483a58672036fc79.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e294cb72f4597d3483a58672036fc79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dedf9275a5cb14e0e40d9a0a44e2ab7d.jpg\" _src=\"http://yanxuan.nosdn.127.net/dedf9275a5cb14e0e40d9a0a44e2ab7d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fb4872d2688aef5fbff9874f67df039.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fb4872d2688aef5fbff9874f67df039.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f42e6c5d2fa6cc6769836e58ce6b204d.jpg\" _src=\"http://yanxuan.nosdn.127.net/f42e6c5d2fa6cc6769836e58ce6b204d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29ee925e530280f8ef9d2d17e2d3f6c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/29ee925e530280f8ef9d2d17e2d3f6c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c958c89c52482f66a2b7fe2f2ca7f86d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c958c89c52482f66a2b7fe2f2ca7f86d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5489eb22d3d00557e3e6f90af54a32d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/5489eb22d3d00557e3e6f90af54a32d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b55e4bbca8dbc6ec36280243540fce36.jpg\" _src=\"http://yanxuan.nosdn.127.net/b55e4bbca8dbc6ec36280243540fce36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e69bd0a9b72ea444a2a9597d8573d808.jpg\" _src=\"http://yanxuan.nosdn.127.net/e69bd0a9b72ea444a2a9597d8573d808.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b1ead82c1d20e969d93714c91575891a.jpg\" _src=\"http://yanxuan.nosdn.127.net/b1ead82c1d20e969d93714c91575891a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ae0db50efe7feb7236788568143c9e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ae0db50efe7feb7236788568143c9e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3161bbead17d75b34763be4552ab06ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/3161bbead17d75b34763be4552ab06ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/88715f3acaec8cd8124acf8e765725c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/88715f3acaec8cd8124acf8e765725c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe0a81f50cd82722f2fee0d3f2bcdccf.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe0a81f50cd82722f2fee0d3f2bcdccf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a3d279a06c30bc982926000a7bcf149.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a3d279a06c30bc982926000a7bcf149.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0f481e69077703f35f542509d799426.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0f481e69077703f35f542509d799426.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86df378f128f248a591c6c972843272a.jpg\" _src=\"http://yanxuan.nosdn.127.net/86df378f128f248a591c6c972843272a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8427432a97e187089144bacd891467dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/8427432a97e187089144bacd891467dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d86f92f33c4e022fcc805aa26364b68f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d86f92f33c4e022fcc805aa26364b68f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ec0158a6100b3b28fd28026617a9979.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ec0158a6100b3b28fd28026617a9979.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/7313946ceb4eba713bf2331baa7e450f.jpg', 'http://yanxuan.nosdn.127.net/d25b5990f16c6d1ac168a34b7aeca681.png', '89.00', '2562', '1110004', '0.00', '限时购', '', '0.00', '0', '0', '0', '97.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1109005', '1011004', '1109005', '方圆木钟', '0', '100', '', '坚硬榉木，实木雕刻', '<p><img src=\"http://yanxuan.nosdn.127.net/7bb40b67df074039b7fe97dbcf448c43.jpg\" _src=\"http://yanxuan.nosdn.127.net/7bb40b67df074039b7fe97dbcf448c43.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a405e659b4249519b6d891dbf2b58c01.jpg\" _src=\"http://yanxuan.nosdn.127.net/a405e659b4249519b6d891dbf2b58c01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11720fe8cd48a2658942b481276a3de4.jpg\" _src=\"http://yanxuan.nosdn.127.net/11720fe8cd48a2658942b481276a3de4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fedf3620e560e8210a63493200d08c51.jpg\" _src=\"http://yanxuan.nosdn.127.net/fedf3620e560e8210a63493200d08c51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9934ca6f2065c0383e44a0ae4b524030.jpg\" _src=\"http://yanxuan.nosdn.127.net/9934ca6f2065c0383e44a0ae4b524030.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7336ac68c0d262fa31fdb16040d0f8af.jpg\" _src=\"http://yanxuan.nosdn.127.net/7336ac68c0d262fa31fdb16040d0f8af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10b7cb83b00cda576314313705fa7868.jpg\" _src=\"http://yanxuan.nosdn.127.net/10b7cb83b00cda576314313705fa7868.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3e73216286e1495c90e5b9c9705f19e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3e73216286e1495c90e5b9c9705f19e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/919cf6a418c3f0898d101af1640c12c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/919cf6a418c3f0898d101af1640c12c7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26d59296f4e67c55e9aead03b498d4fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/26d59296f4e67c55e9aead03b498d4fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b218ff0f6fc058e0306e610a160d16fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/b218ff0f6fc058e0306e610a160d16fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1143d61bfe38a4fc60774aa8af009d7e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1143d61bfe38a4fc60774aa8af009d7e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/730c574abd298983b3ed2763f821c0fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/730c574abd298983b3ed2763f821c0fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2af0aa58c62dde1dd4875fe87a4c5a99.jpg\" _src=\"http://yanxuan.nosdn.127.net/2af0aa58c62dde1dd4875fe87a4c5a99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec7e7448a8e296021ab462cd092a2501.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec7e7448a8e296021ab462cd092a2501.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5539a0ddef738d82cbae457f09065840.jpg\" _src=\"http://yanxuan.nosdn.127.net/5539a0ddef738d82cbae457f09065840.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9565467e098db81db007bade84b364a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/9565467e098db81db007bade84b364a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/adfbd2319e2dc365deebf0eea18a4a0d.jpg\" _src=\"http://yanxuan.nosdn.127.net/adfbd2319e2dc365deebf0eea18a4a0d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/adece1b89239b86275b593c6d9ef7437.jpg\" _src=\"http://yanxuan.nosdn.127.net/adece1b89239b86275b593c6d9ef7437.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66c4bd6f0fd889eabb4497644bfffee5.jpg\" _src=\"http://yanxuan.nosdn.127.net/66c4bd6f0fd889eabb4497644bfffee5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b68b8e696a281e00e7515ee5004219bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/b68b8e696a281e00e7515ee5004219bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b2e59292e893aebfdf7f428569eb7e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b2e59292e893aebfdf7f428569eb7e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec90203d32e0171312f69fb4c2fa5ca3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec90203d32e0171312f69fb4c2fa5ca3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/804a3622271a95a3dd0a19524e9ebc46.jpg\" _src=\"http://yanxuan.nosdn.127.net/804a3622271a95a3dd0a19524e9ebc46.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b14c06512fab1bca0a5a63cfc88dc8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b14c06512fab1bca0a5a63cfc88dc8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/574c9c2ed1b416362db5df5a75bd47f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/574c9c2ed1b416362db5df5a75bd47f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3495a30d87a9448899a72b0d7e81643e.jpg\" _src=\"http://yanxuan.nosdn.127.net/3495a30d87a9448899a72b0d7e81643e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07dbd43bc04098ffc1d4264be2a236ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/07dbd43bc04098ffc1d4264be2a236ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c1dd028e3f58ddbd7d4c93c93cf044fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/c1dd028e3f58ddbd7d4c93c93cf044fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee1c77ca898e5bc28c6fc32dee421af9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee1c77ca898e5bc28c6fc32dee421af9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58d2095e21406135172ee9f7f8b15cae.jpg\" _src=\"http://yanxuan.nosdn.127.net/58d2095e21406135172ee9f7f8b15cae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e6693f623dc6ba917a160149072550f.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e6693f623dc6ba917a160149072550f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/420025a688a7e5c28b974df7573535a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/420025a688a7e5c28b974df7573535a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a31bdac2e2f75c85a3b4cc02877eee6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a31bdac2e2f75c85a3b4cc02877eee6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b995c56514fc2c293c3a39c0fad703d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b995c56514fc2c293c3a39c0fad703d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78ac837deb7634e37e053b6ba4ce1074.jpg\" _src=\"http://yanxuan.nosdn.127.net/78ac837deb7634e37e053b6ba4ce1074.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d39bb938c8ad37f588dcce36ed603dca.jpg\" _src=\"http://yanxuan.nosdn.127.net/d39bb938c8ad37f588dcce36ed603dca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc32f60d12caec82201282fe3bf7c505.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc32f60d12caec82201282fe3bf7c505.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9fd482c1d56c50722e34f3f86932ffd9.jpg\" _src=\"http://yanxuan.nosdn.127.net/9fd482c1d56c50722e34f3f86932ffd9.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '12', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/1bdd7132783b2857886eeebb425ee07e.jpg', 'http://yanxuan.nosdn.127.net/7f508253f65733c7b2af52dd3943ee28.png', '79.00', '1717', '1110006', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1109008', '1015000', '1109008', '云端沙发组合', '1001000', '100', '', 'MUJI供应商携手打造', '<p><img src=\"http://yanxuan.nosdn.127.net/fc48d623ad2effc32f47f70e6cba03ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc48d623ad2effc32f47f70e6cba03ee.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb4a737f74e7779d19c998a0ba63cd3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb4a737f74e7779d19c998a0ba63cd3d.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/937038be185fc64572c38de8d69c01cb.jpg\" _src=\"http://yanxuan.nosdn.127.net/937038be185fc64572c38de8d69c01cb.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40108d88fbfe752bfb7a6fc4ae8edd79.jpg\" _src=\"http://yanxuan.nosdn.127.net/40108d88fbfe752bfb7a6fc4ae8edd79.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a28a0420050289d3e19b88d28b76bab6.jpg\" _src=\"http://yanxuan.nosdn.127.net/a28a0420050289d3e19b88d28b76bab6.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/917acd26520c10b3c82d2beed37fddd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/917acd26520c10b3c82d2beed37fddd7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbf4e7008c33239f7cf79aa93f68ee15.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbf4e7008c33239f7cf79aa93f68ee15.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54065646ecdae5f010980bfa24c4fbbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/54065646ecdae5f010980bfa24c4fbbe.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff510e36a124d4c1ccce47a1e06cba30.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff510e36a124d4c1ccce47a1e06cba30.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b33aa96ae830fec44aac042f1f28ddd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/b33aa96ae830fec44aac042f1f28ddd8.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff74ec438ab3d7805ea2aed2c6552746.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff74ec438ab3d7805ea2aed2c6552746.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6eaff5f5a38874a6e2a9b56feeede7d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/6eaff5f5a38874a6e2a9b56feeede7d7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/200c9aae4e02a75bd71a5dea29f726c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/200c9aae4e02a75bd71a5dea29f726c4.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd48b3606d7bb30243eebded22617d2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd48b3606d7bb30243eebded22617d2e.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bcc453ac7a81cfc517a192ff00013745.jpg\" _src=\"http://yanxuan.nosdn.127.net/bcc453ac7a81cfc517a192ff00013745.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a4e50f5936b3c0ec5b163c8ccc99e8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a4e50f5936b3c0ec5b163c8ccc99e8a.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a79d51d47fadefe7b7db72052d98337f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a79d51d47fadefe7b7db72052d98337f.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ed0d597c81b9ec49b969f8357eac8bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ed0d597c81b9ec49b969f8357eac8bd.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/177f0b2f78bcccf6926c47eb7ef2b047.jpg\" _src=\"http://yanxuan.nosdn.127.net/177f0b2f78bcccf6926c47eb7ef2b047.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/808241e6912a1015f94da67d80a296cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/808241e6912a1015f94da67d80a296cf.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a123c112a75dee43559674c680c941ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/a123c112a75dee43559674c680c941ae.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/832eefe1435ceeaeb421ce7ec0a4fa51.jpg\" _src=\"http://yanxuan.nosdn.127.net/832eefe1435ceeaeb421ce7ec0a4fa51.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6b6f1a00452bc026eba362e4a1d58e04.jpg\" _src=\"http://yanxuan.nosdn.127.net/6b6f1a00452bc026eba362e4a1d58e04.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/761f4fadf4c797affe42c125b29c8ec9.jpg\" _src=\"http://yanxuan.nosdn.127.net/761f4fadf4c797affe42c125b29c8ec9.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d927eded8a39bbb888f9994cd236cb56.jpg\" _src=\"http://yanxuan.nosdn.127.net/d927eded8a39bbb888f9994cd236cb56.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70c47dd65c21bd3fe52f179480268b54.jpg\" _src=\"http://yanxuan.nosdn.127.net/70c47dd65c21bd3fe52f179480268b54.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02a226a867d397c20aafae1f5449225c.jpg\" _src=\"http://yanxuan.nosdn.127.net/02a226a867d397c20aafae1f5449225c.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76c8f1702e4c8f1072eb1cba6776f7c7.jpg\" _src=\"http://yanxuan.nosdn.127.net/76c8f1702e4c8f1072eb1cba6776f7c7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/36225b551bb1e85691f29aa040ab9497.jpg\" _src=\"http://yanxuan.nosdn.127.net/36225b551bb1e85691f29aa040ab9497.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d9ba3ce28d578267765c4d2bc62b887.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d9ba3ce28d578267765c4d2bc62b887.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/099296fb5f8e88ab1c5eaffbd37b8c70.jpg\" _src=\"http://yanxuan.nosdn.127.net/099296fb5f8e88ab1c5eaffbd37b8c70.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bce3a4f414e16497dd0a1301fe945732.jpg\" _src=\"http://yanxuan.nosdn.127.net/bce3a4f414e16497dd0a1301fe945732.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e75874726dd5a742599bc96f4401b51a.jpg\" _src=\"http://yanxuan.nosdn.127.net/e75874726dd5a742599bc96f4401b51a.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cf202434f6e7d84388eb3f00aef3cf7.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cf202434f6e7d84388eb3f00aef3cf7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2788c15d1fb4b12ea989b4626bf4dd42.jpg\" _src=\"http://yanxuan.nosdn.127.net/2788c15d1fb4b12ea989b4626bf4dd42.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/988c7843cd5e3c3d41ded3f964e83f28.jpg\" _src=\"http://yanxuan.nosdn.127.net/988c7843cd5e3c3d41ded3f964e83f28.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8680210644f9ddacc776c086acf087c.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8680210644f9ddacc776c086acf087c.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06a5234e14a9a5a13cab234e338ee047.jpg\" _src=\"http://yanxuan.nosdn.127.net/06a5234e14a9a5a13cab234e338ee047.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6913fa996a08d015baa5dbb81c6751b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6913fa996a08d015baa5dbb81c6751b4.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5559938dfbba2abfe6dc2905892048d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/5559938dfbba2abfe6dc2905892048d6.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3bd6c290baf02cd9d6e8f2036ad96055.jpg\" _src=\"http://yanxuan.nosdn.127.net/3bd6c290baf02cd9d6e8f2036ad96055.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c13f0abbe2e7c8bb6d78986dcaca45a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c13f0abbe2e7c8bb6d78986dcaca45a8.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38d1037057ffb3642d518415c3c21400.jpg\" _src=\"http://yanxuan.nosdn.127.net/38d1037057ffb3642d518415c3c21400.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8f56ea468a1a9fc4dbb462be94b0167.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8f56ea468a1a9fc4dbb462be94b0167.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f47f956787047fc4c05107beef0fd15b.jpg\" _src=\"http://yanxuan.nosdn.127.net/f47f956787047fc4c05107beef0fd15b.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59ae5ce70d03639554b3e0d222416de1.jpg\" _src=\"http://yanxuan.nosdn.127.net/59ae5ce70d03639554b3e0d222416de1.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7e54c9882590f3dc3524229c190098b7.jpg\" _src=\"http://yanxuan.nosdn.127.net/7e54c9882590f3dc3524229c190098b7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb714d5f8e9c3a0cbb063f492c94a9a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb714d5f8e9c3a0cbb063f492c94a9a7.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/afdf2db3aeababc5e2eacbe3e03ab505.jpg\" _src=\"http://yanxuan.nosdn.127.net/afdf2db3aeababc5e2eacbe3e03ab505.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e4b140b65d6da223b2e43082640715e.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e4b140b65d6da223b2e43082640715e.jpg\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0a4feb902cbd98370508538d252985c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/0a4feb902cbd98370508538d252985c2.jpg\"/></p><p style=\"text-align: center;\"><br/></p>', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2230e0d14986e273fb310269a0eb075c.jpg', 'http://yanxuan.nosdn.127.net/c5be2604c0e4186a4e7079feeb742cee.png', '3999.00', '274', '1110009', '0.00', '限时购', '', '0.00', '0', '0', '0', '4398.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1109034', '1011004', '1109034', 'LCD电子钟 升级版', '0', '100', '', 'MUJI风格，清晰简明', '<p><img src=\"http://yanxuan.nosdn.127.net/916068b542d339d851afa9ed21cbb615.jpg\" _src=\"http://yanxuan.nosdn.127.net/916068b542d339d851afa9ed21cbb615.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1772c676b8a0151a3277415147e91aea.jpg\" _src=\"http://yanxuan.nosdn.127.net/1772c676b8a0151a3277415147e91aea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2654631d02db94d1b16f35c3386e295.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2654631d02db94d1b16f35c3386e295.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fe4364bc9c185394f155ef30a9fe7a20.jpg\" _src=\"http://yanxuan.nosdn.127.net/fe4364bc9c185394f155ef30a9fe7a20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c75be07a87009da083944b52a283bf3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c75be07a87009da083944b52a283bf3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f19e7292288a347d0fa0590e22069946.jpg\" _src=\"http://yanxuan.nosdn.127.net/f19e7292288a347d0fa0590e22069946.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39f509f66ae98d0aca642af803abdf04.jpg\" _src=\"http://yanxuan.nosdn.127.net/39f509f66ae98d0aca642af803abdf04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d540abac2bef015ac85083e377bbcd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d540abac2bef015ac85083e377bbcd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7468d589f382664c61275bebfaf9177.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7468d589f382664c61275bebfaf9177.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/885bb0148c6104578cd7ee31813dab44.jpg\" _src=\"http://yanxuan.nosdn.127.net/885bb0148c6104578cd7ee31813dab44.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4ec0f7b8cabadbaca834957b65fd5ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4ec0f7b8cabadbaca834957b65fd5ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb2cf783f23f6945e961979a5cb2af27.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb2cf783f23f6945e961979a5cb2af27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62c6c3025ce0a80b9cb0a214595a5a99.jpg\" _src=\"http://yanxuan.nosdn.127.net/62c6c3025ce0a80b9cb0a214595a5a99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7be5447b74b0afd0cd3943adbf559cb9.jpg\" _src=\"http://yanxuan.nosdn.127.net/7be5447b74b0afd0cd3943adbf559cb9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/840c818a1206e5ae2a01a1e8800e4b4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/840c818a1206e5ae2a01a1e8800e4b4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb8b9a45109a23285415fade5a798e27.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb8b9a45109a23285415fade5a798e27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c00c0a1b4af1503a90ef691999fdf4d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c00c0a1b4af1503a90ef691999fdf4d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be93945860e951158237bbf4a1c86b96.jpg\" _src=\"http://yanxuan.nosdn.127.net/be93945860e951158237bbf4a1c86b96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc0d8c9697cbf9303954b77761ff4a0f.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc0d8c9697cbf9303954b77761ff4a0f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8abfd0b6ea2dd3106ea8678793279d6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8abfd0b6ea2dd3106ea8678793279d6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abd55ff4c1325917cca7123dfaaccf2c.jpg\" _src=\"http://yanxuan.nosdn.127.net/abd55ff4c1325917cca7123dfaaccf2c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec2c42f5a7c6c2efefb16db80cf761b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec2c42f5a7c6c2efefb16db80cf761b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f394d926f4acfbd70b6ad3d733cc3e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f394d926f4acfbd70b6ad3d733cc3e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/01a4b743fe1395c9797c5922dd1f3a8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/01a4b743fe1395c9797c5922dd1f3a8a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22115c51b22dcf614054887e6662ddd3.jpg\" _src=\"http://yanxuan.nosdn.127.net/22115c51b22dcf614054887e6662ddd3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fc720dc92ab05aaef2b055e5e3d27c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fc720dc92ab05aaef2b055e5e3d27c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/adb14137997b1a886a39e98a043ec511.jpg\" _src=\"http://yanxuan.nosdn.127.net/adb14137997b1a886a39e98a043ec511.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e53b80ee6104b5cea8edbff8bbe5547c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e53b80ee6104b5cea8edbff8bbe5547c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92e56e6bc6f548fae669831b38bfbc6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/92e56e6bc6f548fae669831b38bfbc6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20b74a363cdb9b31e0141869fd285dbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/20b74a363cdb9b31e0141869fd285dbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/031d65d8ebee352f28f614cc07935606.jpg\" _src=\"http://yanxuan.nosdn.127.net/031d65d8ebee352f28f614cc07935606.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a31a92d72ea93692a5cfbcaa7a02ced4.jpg\" _src=\"http://yanxuan.nosdn.127.net/a31a92d72ea93692a5cfbcaa7a02ced4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b897a81ca59bc7dd3aae8fe314254538.jpg\" _src=\"http://yanxuan.nosdn.127.net/b897a81ca59bc7dd3aae8fe314254538.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77d0fbc4678a56713ae675a9884e4158.jpg\" _src=\"http://yanxuan.nosdn.127.net/77d0fbc4678a56713ae675a9884e4158.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da8a7b7237f083a6561c9ffc8a97b466.jpg\" _src=\"http://yanxuan.nosdn.127.net/da8a7b7237f083a6561c9ffc8a97b466.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2724952293dfb4ab737640fab4b229d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/2724952293dfb4ab737640fab4b229d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e10bbb914bf44916e86b446e4c563d85.jpg\" _src=\"http://yanxuan.nosdn.127.net/e10bbb914bf44916e86b446e4c563d85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c64c103d15388c0eda01086b8b977fe5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c64c103d15388c0eda01086b8b977fe5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d21b85379acabe83c692c5ebf625578.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d21b85379acabe83c692c5ebf625578.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f5c0d32e5ef81288dc44d08d183770b.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f5c0d32e5ef81288dc44d08d183770b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24dedb497122ca1a4b5bcdf10f4b9a85.jpg\" _src=\"http://yanxuan.nosdn.127.net/24dedb497122ca1a4b5bcdf10f4b9a85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02ece671c8dbca5f5436ff9f2eaf1b81.jpg\" _src=\"http://yanxuan.nosdn.127.net/02ece671c8dbca5f5436ff9f2eaf1b81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/348adaa1d5bfe5b12296bb28e55e7017.jpg\" _src=\"http://yanxuan.nosdn.127.net/348adaa1d5bfe5b12296bb28e55e7017.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d22886559be279a0adbe787b5aae9dd0.jpg\" _src=\"http://yanxuan.nosdn.127.net/d22886559be279a0adbe787b5aae9dd0.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '10', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2a48aa6b6e65d2741990710a3fde78b6.jpg', 'http://yanxuan.nosdn.127.net/c2c96acc680cbadb1787385598e1e593.png', '129.00', '277', '1110157', '0.00', '限时购', '', '0.00', '0', '0', '0', '141.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110002', '1011004', '1110002', '大头风扇', '0', '100', '', '静音劲风，小巧灵动', '<p><br/></p><p><img src=\"http://yanxuan.nosdn.127.net/203ede95fa7111d6877779d3316837b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/203ede95fa7111d6877779d3316837b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/118783171188896e5a75e078dc64330b.jpg\" _src=\"http://yanxuan.nosdn.127.net/118783171188896e5a75e078dc64330b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2482102c677689ad80f641040e7f12ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/2482102c677689ad80f641040e7f12ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2d89b04c486f855444214d037c0df165.jpg\" _src=\"http://yanxuan.nosdn.127.net/2d89b04c486f855444214d037c0df165.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f38c7e6a66526484d34fbb8a17b4a9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f38c7e6a66526484d34fbb8a17b4a9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9920394dea895df464180e43d5f11946.jpg\" _src=\"http://yanxuan.nosdn.127.net/9920394dea895df464180e43d5f11946.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/933a7012100a94c8c3a664ed2adaa7e0.jpg\" _src=\"http://yanxuan.nosdn.127.net/933a7012100a94c8c3a664ed2adaa7e0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/021a4220607d345c2469f015a672bb42.jpg\" _src=\"http://yanxuan.nosdn.127.net/021a4220607d345c2469f015a672bb42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e91be65f64f5522cadc47c4a7037d6e.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e91be65f64f5522cadc47c4a7037d6e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/785485e7129c77deff6a0d9c20a4ba51.jpg\" _src=\"http://yanxuan.nosdn.127.net/785485e7129c77deff6a0d9c20a4ba51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45706b81032aae5519417752679cc411.jpg\" _src=\"http://yanxuan.nosdn.127.net/45706b81032aae5519417752679cc411.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9db4ce4a3af0ecb731c5b0616b6611a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/9db4ce4a3af0ecb731c5b0616b6611a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4fdfa4b3536119fba27651d3b71bdb28.jpg\" _src=\"http://yanxuan.nosdn.127.net/4fdfa4b3536119fba27651d3b71bdb28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f0368808f4454e7e423ecac84f72b4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f0368808f4454e7e423ecac84f72b4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4927392968e0cd9b8ab64a9596c7781.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4927392968e0cd9b8ab64a9596c7781.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abd90c3be9111efdaf56702abc1a7d32.jpg\" _src=\"http://yanxuan.nosdn.127.net/abd90c3be9111efdaf56702abc1a7d32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0bc613574aa2fd1f7021f132b18a570.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0bc613574aa2fd1f7021f132b18a570.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a3e0ccf6e716c970e1bca331cad4163.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a3e0ccf6e716c970e1bca331cad4163.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fc74c4dfcb1231f4bcb5d6b4eca5053.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fc74c4dfcb1231f4bcb5d6b4eca5053.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08cfeda8dcd77031c751c53f48091ad4.jpg\" _src=\"http://yanxuan.nosdn.127.net/08cfeda8dcd77031c751c53f48091ad4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28208b3f32a58d5ea772b3cff5342167.jpg\" _src=\"http://yanxuan.nosdn.127.net/28208b3f32a58d5ea772b3cff5342167.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9955d49842ea9ae1fed75e558cc5177d.jpg\" _src=\"http://yanxuan.nosdn.127.net/9955d49842ea9ae1fed75e558cc5177d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c494e88a27201839de03178c95c2449.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c494e88a27201839de03178c95c2449.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e2647aa98774327c4285faa067dab8be.jpg\" _src=\"http://yanxuan.nosdn.127.net/e2647aa98774327c4285faa067dab8be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b8e5df31c4a80d40cb6a03528240118.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b8e5df31c4a80d40cb6a03528240118.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e19d037145db07c5250f43051ad6fc1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e19d037145db07c5250f43051ad6fc1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98c0f39559e242a9cbf06a336e2beb7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/98c0f39559e242a9cbf06a336e2beb7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b792c614faebf92e585023513972078c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b792c614faebf92e585023513972078c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2c6ed14e2f541b92f94d9d368599bd34.jpg\" _src=\"http://yanxuan.nosdn.127.net/2c6ed14e2f541b92f94d9d368599bd34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f72b85409adfe0757b147f674a61dc8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f72b85409adfe0757b147f674a61dc8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3509cd7bd045dcb8e283ce5b66744901.jpg\" _src=\"http://yanxuan.nosdn.127.net/3509cd7bd045dcb8e283ce5b66744901.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/444d6182b18f36a6db6bd9243b0cd91e.jpg\" _src=\"http://yanxuan.nosdn.127.net/444d6182b18f36a6db6bd9243b0cd91e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60a8f97142d9bafc49d266987a4ded55.jpg\" _src=\"http://yanxuan.nosdn.127.net/60a8f97142d9bafc49d266987a4ded55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/618eb2c0098cb033c85e4c9cc4c99536.jpg\" _src=\"http://yanxuan.nosdn.127.net/618eb2c0098cb033c85e4c9cc4c99536.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81f299cbe5157dfdac89b46d56cc8db1.jpg\" _src=\"http://yanxuan.nosdn.127.net/81f299cbe5157dfdac89b46d56cc8db1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8ef5aebb0ec5dc06e9031b798afff6f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8ef5aebb0ec5dc06e9031b798afff6f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/776fbe725382c6ca162ef97f535bc0d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/776fbe725382c6ca162ef97f535bc0d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3fd7e45e34bee0bce296881d9db41dc8.jpg\" _src=\"http://yanxuan.nosdn.127.net/3fd7e45e34bee0bce296881d9db41dc8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6913605e36b412143cc474312a268272.jpg\" _src=\"http://yanxuan.nosdn.127.net/6913605e36b412143cc474312a268272.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec7e39a80418d88bffa4dcaf57844027.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec7e39a80418d88bffa4dcaf57844027.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13dd81aea5b40630749591aca76dd653.jpg\" _src=\"http://yanxuan.nosdn.127.net/13dd81aea5b40630749591aca76dd653.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/318b620975457327ce187b61f637598e.jpg\" _src=\"http://yanxuan.nosdn.127.net/318b620975457327ce187b61f637598e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1f2f5a6d2156afb267cb23bbbd4e22db.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f2f5a6d2156afb267cb23bbbd4e22db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e1ab20bad5adbf92217fb3e1409eb68.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e1ab20bad5adbf92217fb3e1409eb68.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19e0d90436d03fa3ebf1dd93aa966d96.jpg\" _src=\"http://yanxuan.nosdn.127.net/19e0d90436d03fa3ebf1dd93aa966d96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/08f235aacaa4597efed2f2a22a50ef40.jpg\" _src=\"http://yanxuan.nosdn.127.net/08f235aacaa4597efed2f2a22a50ef40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0106676c68744e9f330428689a437e63.jpg\" _src=\"http://yanxuan.nosdn.127.net/0106676c68744e9f330428689a437e63.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c7dce7efe74d1054c867358a5da97d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c7dce7efe74d1054c867358a5da97d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ce1f545e4f790b8199899ade0f8d21b.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ce1f545e4f790b8199899ade0f8d21b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e4b4fb01786940d4b15f7990716a67e.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e4b4fb01786940d4b15f7990716a67e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/22f335bf15b1f6b2222d39673ce31bdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/22f335bf15b1f6b2222d39673ce31bdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ab9a0a8406256e5414c5f66643f83b9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ab9a0a8406256e5414c5f66643f83b9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d0c9aeeac1b5699883283d1c491851b.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d0c9aeeac1b5699883283d1c491851b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c71b76d5d6332160f7cab0c8967d163.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c71b76d5d6332160f7cab0c8967d163.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c327c072a52eff26349c23274e3eba.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c327c072a52eff26349c23274e3eba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d3df2f3f37bc3912f016193915d2eaf8.jpg\" _src=\"http://yanxuan.nosdn.127.net/d3df2f3f37bc3912f016193915d2eaf8.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '13', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e08658b7f52f097de81d912eda9dcd74.jpg', 'http://yanxuan.nosdn.127.net/a7a524512c34d24a4b9762766dd9d0f0.png', '119.00', '11433', '1111007', '0.00', '限时购', '', '0.00', '0', '0', '0', '130.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110003', '1008009', '1110003', '全棉针织条纹四件套 新款', '1001000', '100', '', '裸睡享受，柔软透气有弹性', '<p><img src=\"http://yanxuan.nosdn.127.net/51409b5b30124fcef4b15ae9bd3d1047.jpg\" _src=\"http://yanxuan.nosdn.127.net/51409b5b30124fcef4b15ae9bd3d1047.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ed3bbf85dc26140e5b054ea5ff8aa28.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ed3bbf85dc26140e5b054ea5ff8aa28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1486e921307df5cbaf21f27d2ffb4404.jpg\" _src=\"http://yanxuan.nosdn.127.net/1486e921307df5cbaf21f27d2ffb4404.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8692330cd1abc6317f090ccd5d28bf9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8692330cd1abc6317f090ccd5d28bf9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e046657e9f8b523c0cd93d2fbbe566c.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e046657e9f8b523c0cd93d2fbbe566c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2ca5a528cfd0c24bb97aed0c1a2fe35.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2ca5a528cfd0c24bb97aed0c1a2fe35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0087be757bbb5070a9495cf32d2d7a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0087be757bbb5070a9495cf32d2d7a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bce9b677188a36b86fa40e13011a43a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/bce9b677188a36b86fa40e13011a43a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a0a90deb515f06d8d1c275c2057e368.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a0a90deb515f06d8d1c275c2057e368.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/39d50a3a61d13163bf83774edd2db5bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/39d50a3a61d13163bf83774edd2db5bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/408ae6a44271a7fec18dcaaa66a66d2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/408ae6a44271a7fec18dcaaa66a66d2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/033fd7aed18e0fcd50ea695239fdf5d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/033fd7aed18e0fcd50ea695239fdf5d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/519ddc7d3c063973fbd221a8bf9fb62c.jpg\" _src=\"http://yanxuan.nosdn.127.net/519ddc7d3c063973fbd221a8bf9fb62c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4855bf5174f5a9c59ff92b134a9c6702.jpg\" _src=\"http://yanxuan.nosdn.127.net/4855bf5174f5a9c59ff92b134a9c6702.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2a6d73ee470dfc663b1ef7f45d25f0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2a6d73ee470dfc663b1ef7f45d25f0e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a59172ea5938721b3a5a66b049bc31a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a59172ea5938721b3a5a66b049bc31a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c29ecaa289359d6a9ee0f553e512902.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c29ecaa289359d6a9ee0f553e512902.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/717bff823050ff266da8e0ae04eae1cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/717bff823050ff266da8e0ae04eae1cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1de5768520db342444d3cb620a9fdd4f.jpg\" _src=\"http://yanxuan.nosdn.127.net/1de5768520db342444d3cb620a9fdd4f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/453b37dfd7b3ae539f7afb7e3d3fda73.jpg\" _src=\"http://yanxuan.nosdn.127.net/453b37dfd7b3ae539f7afb7e3d3fda73.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29a9b2ac9aa56666fafd4c90b1a7fed1.jpg\" _src=\"http://yanxuan.nosdn.127.net/29a9b2ac9aa56666fafd4c90b1a7fed1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8a15810a575de26a33a5ac9983c68939.jpg\" _src=\"http://yanxuan.nosdn.127.net/8a15810a575de26a33a5ac9983c68939.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbe607ff748b140e02946bb28578a179.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbe607ff748b140e02946bb28578a179.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02e0e40e7423fbf85ad31ccb483b519b.jpg\" _src=\"http://yanxuan.nosdn.127.net/02e0e40e7423fbf85ad31ccb483b519b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a352d098862cc87a3de60a42147896f.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a352d098862cc87a3de60a42147896f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b783bbe92f495b5d1095afe96d2a3685.jpg\" _src=\"http://yanxuan.nosdn.127.net/b783bbe92f495b5d1095afe96d2a3685.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a55100ca3526614393371f7f3a466dda.jpg\" _src=\"http://yanxuan.nosdn.127.net/a55100ca3526614393371f7f3a466dda.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e40fb00aec446ed6695e25d458b4a1bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/e40fb00aec446ed6695e25d458b4a1bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23481a0858e9d4a62a5b707c6b3f8f4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/23481a0858e9d4a62a5b707c6b3f8f4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a25526218ef089322f56b69dc12e14af.jpg\" _src=\"http://yanxuan.nosdn.127.net/a25526218ef089322f56b69dc12e14af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7c752cfaedadc0687c5774e00a760dc.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7c752cfaedadc0687c5774e00a760dc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/234a67ee6018ceb8660695e662fabb99.jpg\" _src=\"http://yanxuan.nosdn.127.net/234a67ee6018ceb8660695e662fabb99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/174b1bb41003bcddd8dc9c9ef17ce224.jpg\" _src=\"http://yanxuan.nosdn.127.net/174b1bb41003bcddd8dc9c9ef17ce224.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abd9fea1d638e7a5aecc6a7adc76c711.jpg\" _src=\"http://yanxuan.nosdn.127.net/abd9fea1d638e7a5aecc6a7adc76c711.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e08f5def5de99f8bebe3ec6a1ae1c83.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e08f5def5de99f8bebe3ec6a1ae1c83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2995438e191249bd7d084a5d6f2373c8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2995438e191249bd7d084a5d6f2373c8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb07fd94e9566b69757833b2633b28df.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb07fd94e9566b69757833b2633b28df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f8fca21912470098294ec527ea245821.jpg\" _src=\"http://yanxuan.nosdn.127.net/f8fca21912470098294ec527ea245821.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32f2e9e3f2b68c131e3219df1d2abda0.jpg\" _src=\"http://yanxuan.nosdn.127.net/32f2e9e3f2b68c131e3219df1d2abda0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/808917d73d100f81297b133b14976a2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/808917d73d100f81297b133b14976a2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9af0fe13111566c77485e3be2151059.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9af0fe13111566c77485e3be2151059.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/122464e4981f97f4ddb18a56e4eaae52.jpg\" _src=\"http://yanxuan.nosdn.127.net/122464e4981f97f4ddb18a56e4eaae52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/abc8125353e8c485f68eecde6e49dddb.jpg\" _src=\"http://yanxuan.nosdn.127.net/abc8125353e8c485f68eecde6e49dddb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8ba0e58c2ff94139b3d808c33f907a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8ba0e58c2ff94139b3d808c33f907a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6134c0363c2861e9dc0b1244eaf8cf85.jpg\" _src=\"http://yanxuan.nosdn.127.net/6134c0363c2861e9dc0b1244eaf8cf85.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0fe8ed929bbf2f23b09b8359c846fbdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/0fe8ed929bbf2f23b09b8359c846fbdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94cf259d560b3f0d53603d261ad47d69.jpg\" _src=\"http://yanxuan.nosdn.127.net/94cf259d560b3f0d53603d261ad47d69.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d14cd06d113b7053bbc416fce83e6ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d14cd06d113b7053bbc416fce83e6ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a57ce45eccdc407c6d87d515d64c9d0f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a57ce45eccdc407c6d87d515d64c9d0f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d339a7656c240792d234e3edbb1bdd6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d339a7656c240792d234e3edbb1bdd6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f18f868fdf16912d4e89f3421fffec65.jpg\" _src=\"http://yanxuan.nosdn.127.net/f18f868fdf16912d4e89f3421fffec65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f2bae908dc57231874edb377b95e6d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f2bae908dc57231874edb377b95e6d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/efeb13be9fb6664625f37e639ec9cf67.jpg\" _src=\"http://yanxuan.nosdn.127.net/efeb13be9fb6664625f37e639ec9cf67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c82da9f8e4b68ef552878a0ef8160e12.jpg\" _src=\"http://yanxuan.nosdn.127.net/c82da9f8e4b68ef552878a0ef8160e12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77db454604d83b15ed289604ac0c6282.jpg\" _src=\"http://yanxuan.nosdn.127.net/77db454604d83b15ed289604ac0c6282.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a5def4bad25b8f0105621f6151b20f29.jpg\" _src=\"http://yanxuan.nosdn.127.net/a5def4bad25b8f0105621f6151b20f29.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1204e404c87dad014daebe47946c642a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1204e404c87dad014daebe47946c642a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85165ab6336f96477b5ed4f40c1f4506.jpg\" _src=\"http://yanxuan.nosdn.127.net/85165ab6336f96477b5ed4f40c1f4506.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76d0a15612658df2da7f90141c27575b.jpg\" _src=\"http://yanxuan.nosdn.127.net/76d0a15612658df2da7f90141c27575b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/18d88fcaa7184e70a3fe2af7a410ea92.jpg\" _src=\"http://yanxuan.nosdn.127.net/18d88fcaa7184e70a3fe2af7a410ea92.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '2', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/eeba45c72fa097c6e128d529b7a0c513.jpg', 'http://yanxuan.nosdn.127.net/72dfb4bfc1cd1b834c064a9d1d40627d.png', '299.00', '19852', '1111023', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110004', '1008009', '1110004', '全棉针织纯色四件套', '1001000', '100', '', '日系纯色，面料轻柔舒透', '<p><img src=\"http://yanxuan.nosdn.127.net/e15427b1300012152bf9d92a2bc67c99.jpg\" _src=\"http://yanxuan.nosdn.127.net/e15427b1300012152bf9d92a2bc67c99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7428b57cf1524e25e868046a52c8c74.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7428b57cf1524e25e868046a52c8c74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ba73e0fac1ddac61dac545147360f30.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ba73e0fac1ddac61dac545147360f30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2132694338933fdce383149a883680ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/2132694338933fdce383149a883680ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06f8db4f9ec0c46aa369e3a47334fdf6.jpg\" _src=\"http://yanxuan.nosdn.127.net/06f8db4f9ec0c46aa369e3a47334fdf6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/98ea40eb0129d0e9d8152d5db6f826a1.jpg\" _src=\"http://yanxuan.nosdn.127.net/98ea40eb0129d0e9d8152d5db6f826a1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/450133053e1e892623b0c66522e4cd13.jpg\" _src=\"http://yanxuan.nosdn.127.net/450133053e1e892623b0c66522e4cd13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/266fe2d8d8284830ce353b717b134006.jpg\" _src=\"http://yanxuan.nosdn.127.net/266fe2d8d8284830ce353b717b134006.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e79e83d77a24109e4e571e8bb327489.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e79e83d77a24109e4e571e8bb327489.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e7c40f873354dd00827a8e9a116ae9b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e7c40f873354dd00827a8e9a116ae9b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd63c2c2c421d9ae62e42378531eb9bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd63c2c2c421d9ae62e42378531eb9bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5d5fb2641ad2011b304a839dccfaceb.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5d5fb2641ad2011b304a839dccfaceb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e44ecb22b4288445c73348aee7848e74.jpg\" _src=\"http://yanxuan.nosdn.127.net/e44ecb22b4288445c73348aee7848e74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff2b9e9b6d07861e53c535de160c89b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff2b9e9b6d07861e53c535de160c89b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbd8db78cccec3b459cefc8403977565.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbd8db78cccec3b459cefc8403977565.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d33fa09d06e55946ed3ca575e1ac8ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d33fa09d06e55946ed3ca575e1ac8ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/710e44a757e0af28923c6d8451729f9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/710e44a757e0af28923c6d8451729f9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/83fd15d26c23b24cdb85b56552ec1f60.jpg\" _src=\"http://yanxuan.nosdn.127.net/83fd15d26c23b24cdb85b56552ec1f60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a6aa91581b046928b799a84f0871d6b.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a6aa91581b046928b799a84f0871d6b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/92c89ac95e0681e11f04772e5f1fb55c.jpg\" _src=\"http://yanxuan.nosdn.127.net/92c89ac95e0681e11f04772e5f1fb55c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80b35361b1896d38260c3d1982c462ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/80b35361b1896d38260c3d1982c462ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eee8f49786481c7ea533e8315c743f96.jpg\" _src=\"http://yanxuan.nosdn.127.net/eee8f49786481c7ea533e8315c743f96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84eebca8658c8ed824c1b04ea5ce0262.jpg\" _src=\"http://yanxuan.nosdn.127.net/84eebca8658c8ed824c1b04ea5ce0262.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a17beea5ce5e36f1de3e28121b3bf90.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a17beea5ce5e36f1de3e28121b3bf90.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6587bb904df455610f3e2893b403ff6.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6587bb904df455610f3e2893b403ff6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62d1faf12c878f8f8d0f6f90816f82eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/62d1faf12c878f8f8d0f6f90816f82eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64b1010703632d102692f1cfdc329c07.jpg\" _src=\"http://yanxuan.nosdn.127.net/64b1010703632d102692f1cfdc329c07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee9a6bd5a6d345274dfc5bd3df8f6673.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee9a6bd5a6d345274dfc5bd3df8f6673.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/924b2879cd336d3fcc5c2dd064fa563d.jpg\" _src=\"http://yanxuan.nosdn.127.net/924b2879cd336d3fcc5c2dd064fa563d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5627b5789c5faeb6f2f0eb319d4eb758.jpg\" _src=\"http://yanxuan.nosdn.127.net/5627b5789c5faeb6f2f0eb319d4eb758.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6125e2c756374638db2cff6e1f1834d.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6125e2c756374638db2cff6e1f1834d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7c65c61453f6503723ca73b502b3d89.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7c65c61453f6503723ca73b502b3d89.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d7b28b69a8c75f0a30a9753126d03c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d7b28b69a8c75f0a30a9753126d03c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54841f38fc0883cd9ab86ac7b8345801.jpg\" _src=\"http://yanxuan.nosdn.127.net/54841f38fc0883cd9ab86ac7b8345801.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8703301aa06b22d2d6699745f9b15770.jpg\" _src=\"http://yanxuan.nosdn.127.net/8703301aa06b22d2d6699745f9b15770.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c824bc7de6471d1b07797d3c6f77a33d.jpg\" _src=\"http://yanxuan.nosdn.127.net/c824bc7de6471d1b07797d3c6f77a33d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7ce29e7160e862b4c55acb51734bbf30.jpg\" _src=\"http://yanxuan.nosdn.127.net/7ce29e7160e862b4c55acb51734bbf30.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/220774e0cdc07e4448af3cb650c398eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/220774e0cdc07e4448af3cb650c398eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d660bb8f822d9f5fa9eeb2cad568ae0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d660bb8f822d9f5fa9eeb2cad568ae0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1dfe8564614a61d7b040c02565211c77.jpg\" _src=\"http://yanxuan.nosdn.127.net/1dfe8564614a61d7b040c02565211c77.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8b6f2ad58a4f4d159580362e4dc7625.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8b6f2ad58a4f4d159580362e4dc7625.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f42bd22e79764026659e48e40c131353.jpg\" _src=\"http://yanxuan.nosdn.127.net/f42bd22e79764026659e48e40c131353.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/298706644d4d54146d693bb69d0972bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/298706644d4d54146d693bb69d0972bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d77bdd18e48fd17010ebbb825bb52dcf.jpg\" _src=\"http://yanxuan.nosdn.127.net/d77bdd18e48fd17010ebbb825bb52dcf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a11788ef69114eddb1dcdf4d9f8320e7.jpg\" _src=\"http://yanxuan.nosdn.127.net/a11788ef69114eddb1dcdf4d9f8320e7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c36bce03ee7386ff09f913bbf0eff163.jpg\" _src=\"http://yanxuan.nosdn.127.net/c36bce03ee7386ff09f913bbf0eff163.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/481edda8c381a26f138e2785714de72b.jpg\" _src=\"http://yanxuan.nosdn.127.net/481edda8c381a26f138e2785714de72b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d8999ba08cb6002401523e55214a8fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d8999ba08cb6002401523e55214a8fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4ae747c627f5a530dd1defad463fda5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4ae747c627f5a530dd1defad463fda5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5bb1d2df0e1e9a9713aaa4fd534f9613.jpg\" _src=\"http://yanxuan.nosdn.127.net/5bb1d2df0e1e9a9713aaa4fd534f9613.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89bfd74e9a71117724edef87fd9d3729.jpg\" _src=\"http://yanxuan.nosdn.127.net/89bfd74e9a71117724edef87fd9d3729.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d9eb35c8b7fb88bf15352b9586b93f2.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d9eb35c8b7fb88bf15352b9586b93f2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/400146bec77d8d243332c1e53a903839.jpg\" _src=\"http://yanxuan.nosdn.127.net/400146bec77d8d243332c1e53a903839.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d1c6b1cf18f2bf441aa90768aff1833a.jpg\" _src=\"http://yanxuan.nosdn.127.net/d1c6b1cf18f2bf441aa90768aff1833a.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '3', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/65d94c770e03dacd4e1b8b45ad481e55.jpg', 'http://yanxuan.nosdn.127.net/1ffd5831e63027715445f74a28f8c4ed.png', '299.00', '11983', '1111037', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110007', '1008009', '1110007', '日式色织水洗棉格纹四件套 新款', '1001000', '100', '', '做旧微褶感，轻柔呵护棉', '<p><img src=\"http://yanxuan.nosdn.127.net/280d74c31b9322eb956e7481bd22e9a5.jpg\" _src=\"http://yanxuan.nosdn.127.net/280d74c31b9322eb956e7481bd22e9a5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b9270ec5d66c917f2514f8d69679f6c.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b9270ec5d66c917f2514f8d69679f6c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5126fea2c070ab454df529b7cd42171a.jpg\" _src=\"http://yanxuan.nosdn.127.net/5126fea2c070ab454df529b7cd42171a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7020173bf8664bae6a51ec81a5045350.jpg\" _src=\"http://yanxuan.nosdn.127.net/7020173bf8664bae6a51ec81a5045350.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f68d38ae6dfe3b56c3e0ddf4446105e.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f68d38ae6dfe3b56c3e0ddf4446105e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e401c41d6e3cc2ad655383fb83f582e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/e401c41d6e3cc2ad655383fb83f582e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e0801c89d5119c02f4aad1fa2e3f79d.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e0801c89d5119c02f4aad1fa2e3f79d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb11f89e6f0c41053087f0b4bbed36c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb11f89e6f0c41053087f0b4bbed36c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/80bf0c6ef68f4373b3db521e7c09f0fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/80bf0c6ef68f4373b3db521e7c09f0fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ec681b58c2b2281ceac667bb9416e79.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ec681b58c2b2281ceac667bb9416e79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab6e782785293c93cddbbe59d41fbe58.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab6e782785293c93cddbbe59d41fbe58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2974fb17474f1e75a3746cbdb9d38d08.jpg\" _src=\"http://yanxuan.nosdn.127.net/2974fb17474f1e75a3746cbdb9d38d08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2aacbef9ae23bbda05115240a09711d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/2aacbef9ae23bbda05115240a09711d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b09d8a77f61eb9c0e2598f090a9903d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/b09d8a77f61eb9c0e2598f090a9903d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79277de533411ec1556af43c2214cd2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/79277de533411ec1556af43c2214cd2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5223bbdf9b7f3206ae48fc41d0f8870f.jpg\" _src=\"http://yanxuan.nosdn.127.net/5223bbdf9b7f3206ae48fc41d0f8870f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1bdede2a5332a7cf7cb988d216219c8a.jpg\" _src=\"http://yanxuan.nosdn.127.net/1bdede2a5332a7cf7cb988d216219c8a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9bc8c2543a42a80d980d90bb49f761f.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9bc8c2543a42a80d980d90bb49f761f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6ac4fcd6367432ea61eb2c9b972c85b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6ac4fcd6367432ea61eb2c9b972c85b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8cf923bfea6642309dd45f23cc0db014.jpg\" _src=\"http://yanxuan.nosdn.127.net/8cf923bfea6642309dd45f23cc0db014.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/038854293eb327038bff7f9b12ecc959.jpg\" _src=\"http://yanxuan.nosdn.127.net/038854293eb327038bff7f9b12ecc959.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb39a24c1e3af6e98b04dadbd33a3fe9.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb39a24c1e3af6e98b04dadbd33a3fe9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/362b2f3046711bc23186648dae74ad6d.jpg\" _src=\"http://yanxuan.nosdn.127.net/362b2f3046711bc23186648dae74ad6d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49f7de4e37e5ecd2f7164ede19d9f733.jpg\" _src=\"http://yanxuan.nosdn.127.net/49f7de4e37e5ecd2f7164ede19d9f733.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/569e9d6b44ca2f27a1c12509e8915e66.jpg\" _src=\"http://yanxuan.nosdn.127.net/569e9d6b44ca2f27a1c12509e8915e66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5dc22bfcd8a766721a4627e543ed910.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5dc22bfcd8a766721a4627e543ed910.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/713237ccefdecfdc349a112cdf19dad4.jpg\" _src=\"http://yanxuan.nosdn.127.net/713237ccefdecfdc349a112cdf19dad4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90fbeb1d0446c8478ff02401def15c2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/90fbeb1d0446c8478ff02401def15c2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5044c7429edbfbb7b839e557fd8f818d.jpg\" _src=\"http://yanxuan.nosdn.127.net/5044c7429edbfbb7b839e557fd8f818d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5aec8b5df3e773ee8b14113a2cdcb32.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5aec8b5df3e773ee8b14113a2cdcb32.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dfd9bccd47e871bc7f67779bc784db51.jpg\" _src=\"http://yanxuan.nosdn.127.net/dfd9bccd47e871bc7f67779bc784db51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ffa489f82e9d2aa77393cd7f65ebee86.jpg\" _src=\"http://yanxuan.nosdn.127.net/ffa489f82e9d2aa77393cd7f65ebee86.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd56dc555af6f50272e7cd31e29644c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd56dc555af6f50272e7cd31e29644c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d261318f912c3b09ae24c7efdb55647.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d261318f912c3b09ae24c7efdb55647.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1cf1335f9646f9e3b82ad4b21540f0b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/1cf1335f9646f9e3b82ad4b21540f0b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9881c742b4178a4096b2faf8630fdf48.jpg\" _src=\"http://yanxuan.nosdn.127.net/9881c742b4178a4096b2faf8630fdf48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e1fb2de40eb0243aa204ea419534d9c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e1fb2de40eb0243aa204ea419534d9c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c4699bbb0bb64091ea65c2fcb48571f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c4699bbb0bb64091ea65c2fcb48571f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31bbf71652f62fa75caaa1c17619046e.jpg\" _src=\"http://yanxuan.nosdn.127.net/31bbf71652f62fa75caaa1c17619046e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2784a49f991209e108573e1576c737db.jpg\" _src=\"http://yanxuan.nosdn.127.net/2784a49f991209e108573e1576c737db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/032f984b95d0557c42b381c5dac63bba.jpg\" _src=\"http://yanxuan.nosdn.127.net/032f984b95d0557c42b381c5dac63bba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/649c19a764f92a7f7caa2901e91fced7.jpg\" _src=\"http://yanxuan.nosdn.127.net/649c19a764f92a7f7caa2901e91fced7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ce2a4df0ccb346bc78507d033ed41ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ce2a4df0ccb346bc78507d033ed41ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c304880b8d2184655ad0f2fa9cb80663.jpg\" _src=\"http://yanxuan.nosdn.127.net/c304880b8d2184655ad0f2fa9cb80663.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c6e5ff7cdff06f1489816156c75c6dd6.jpg\" _src=\"http://yanxuan.nosdn.127.net/c6e5ff7cdff06f1489816156c75c6dd6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/542c796e0f10192cc950bddb418b6953.jpg\" _src=\"http://yanxuan.nosdn.127.net/542c796e0f10192cc950bddb418b6953.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/675bd2b57d02e966da0981017acc9ffc.jpg\" _src=\"http://yanxuan.nosdn.127.net/675bd2b57d02e966da0981017acc9ffc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ec3a06d23be8c6ea4bad1ab55394af2.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ec3a06d23be8c6ea4bad1ab55394af2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59434b29c18dff0207a6560970335a0b.jpg\" _src=\"http://yanxuan.nosdn.127.net/59434b29c18dff0207a6560970335a0b.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/19e7760c63ae6dc154a078460d183542.jpg', 'http://yanxuan.nosdn.127.net/deeb55bb45f94cb236a47d1264e883b8.png', '299.00', '5402', '1111049', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110008', '1008009', '1110008', '全棉贡缎纯色床单', '0', '100', '', '丝滑缎纹 舒适百搭', '<p><img src=\"http://yanxuan.nosdn.127.net/ebaa153e0bc07348c7ef2b4f2f9827b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/ebaa153e0bc07348c7ef2b4f2f9827b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2482eac6674a83a855d7730dce63c660.jpg\" _src=\"http://yanxuan.nosdn.127.net/2482eac6674a83a855d7730dce63c660.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a72593f1fa2a6e309cdb04b48ffe85bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a72593f1fa2a6e309cdb04b48ffe85bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f110fbe3e1316592b5f5d9aeee606962.jpg\" _src=\"http://yanxuan.nosdn.127.net/f110fbe3e1316592b5f5d9aeee606962.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5b0f7b138ca35cb17a11b16475a24bb.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5b0f7b138ca35cb17a11b16475a24bb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac9476e69430bf04273fc293c25e9656.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac9476e69430bf04273fc293c25e9656.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6ab15ef2449663d23c156410fc438caf.jpg\" _src=\"http://yanxuan.nosdn.127.net/6ab15ef2449663d23c156410fc438caf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/24c02f33d0012286cf1705a499993ea5.jpg\" _src=\"http://yanxuan.nosdn.127.net/24c02f33d0012286cf1705a499993ea5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/699e6953da537bdc0df1f995a54c97cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/699e6953da537bdc0df1f995a54c97cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ccb00ff92e1560084cf0aadbe78ca706.jpg\" _src=\"http://yanxuan.nosdn.127.net/ccb00ff92e1560084cf0aadbe78ca706.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fcfc9690c34ba894119b2b6f4f7542c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/fcfc9690c34ba894119b2b6f4f7542c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d066dd6674efd1bb8107ebf056de1ea.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d066dd6674efd1bb8107ebf056de1ea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5af6869a6398f6d95a85b4cbac0148ed.jpg\" _src=\"http://yanxuan.nosdn.127.net/5af6869a6398f6d95a85b4cbac0148ed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60ddcb218b694c29208612c7a64f80b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/60ddcb218b694c29208612c7a64f80b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fd7be46a7fd75bc0ad4e9ab61c3e2c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fd7be46a7fd75bc0ad4e9ab61c3e2c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b6bcbf89419738e2b91556b618cac2fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/b6bcbf89419738e2b91556b618cac2fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f0512ff7b481928c196e479796c461f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f0512ff7b481928c196e479796c461f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f9ff350d6d35cd4515b9c3a5ea46820.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f9ff350d6d35cd4515b9c3a5ea46820.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8419284a2c2c9f3ffb775ef697b33a34.jpg\" _src=\"http://yanxuan.nosdn.127.net/8419284a2c2c9f3ffb775ef697b33a34.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5adf5661416fcf6abaab177743ebfe17.jpg\" _src=\"http://yanxuan.nosdn.127.net/5adf5661416fcf6abaab177743ebfe17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37ae6bef484400f584cced0cf672ec08.jpg\" _src=\"http://yanxuan.nosdn.127.net/37ae6bef484400f584cced0cf672ec08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73b8074583dc432bb68669de4532bb36.jpg\" _src=\"http://yanxuan.nosdn.127.net/73b8074583dc432bb68669de4532bb36.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02c7022da23d3444f41f6845bdd3d837.jpg\" _src=\"http://yanxuan.nosdn.127.net/02c7022da23d3444f41f6845bdd3d837.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5f3da708372b5107ad0eb0e65613929b.jpg\" _src=\"http://yanxuan.nosdn.127.net/5f3da708372b5107ad0eb0e65613929b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2fde409216ba1b4ae3a1087daf40c90.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2fde409216ba1b4ae3a1087daf40c90.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13ebbd1cfd212b2df22cbd317061086e.jpg\" _src=\"http://yanxuan.nosdn.127.net/13ebbd1cfd212b2df22cbd317061086e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/059a495310c1d6da4d586acb84f9bbed.jpg\" _src=\"http://yanxuan.nosdn.127.net/059a495310c1d6da4d586acb84f9bbed.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b114ef2f9ff05d0a56a920d92ab32623.jpg\" _src=\"http://yanxuan.nosdn.127.net/b114ef2f9ff05d0a56a920d92ab32623.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c54eb0cb4bba2074c4c28acd193e0cb0.jpg\" _src=\"http://yanxuan.nosdn.127.net/c54eb0cb4bba2074c4c28acd193e0cb0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d701c6b5902a9b78c34817eff7a3bd60.jpg\" _src=\"http://yanxuan.nosdn.127.net/d701c6b5902a9b78c34817eff7a3bd60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c30bdf9866848a30b26bc54fd5b34de.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c30bdf9866848a30b26bc54fd5b34de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/361a51703b77da12f0a94313aa8b26a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/361a51703b77da12f0a94313aa8b26a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/386c6c4fe63058f8d05b3befa070e752.jpg\" _src=\"http://yanxuan.nosdn.127.net/386c6c4fe63058f8d05b3befa070e752.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e3caeb5786494d326babf301d7eea1d.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e3caeb5786494d326babf301d7eea1d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8c0fd896618d26cac6a6a6c784af23e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8c0fd896618d26cac6a6a6c784af23e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ca1467358f3c9724fe26e1fc39d5b24e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ca1467358f3c9724fe26e1fc39d5b24e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a091d160764dbeb25d426f0e23089687.jpg\" _src=\"http://yanxuan.nosdn.127.net/a091d160764dbeb25d426f0e23089687.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7aa64a705ba6ee2d0cfee1a13ce168c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7aa64a705ba6ee2d0cfee1a13ce168c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/09b1628b63d9c3efaa63ba321f174525.jpg\" _src=\"http://yanxuan.nosdn.127.net/09b1628b63d9c3efaa63ba321f174525.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0033560795459993074a19578a23977e.jpg\" _src=\"http://yanxuan.nosdn.127.net/0033560795459993074a19578a23977e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a43c91fd16654007be3fd0fdbf59115.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a43c91fd16654007be3fd0fdbf59115.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e069a5efd07a739efaf27de6e436082.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e069a5efd07a739efaf27de6e436082.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b4ab4383f7ae6a91ae2fb5b7b69d2c9c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b4ab4383f7ae6a91ae2fb5b7b69d2c9c.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '26', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/607cc789c0dc4b33d1147a46dc20b327.jpg', 'http://yanxuan.nosdn.127.net/255a4888161f9b4fe530cf319f14551d.png', '99.00', '7611', '1111057', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110013', '1017000', '1110013', '悦动纯色自动伸缩牵引器', '0', '100', '', '最大承重50KG， 乐享自由', '<p><img src=\"http://yanxuan.nosdn.127.net/9a9167323cfc952e1d274215d0af65d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a9167323cfc952e1d274215d0af65d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/49b48b3fb6270003adbca5e77a170eb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/49b48b3fb6270003adbca5e77a170eb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57f48b72bc6e352eb894714a1f8a8b91.jpg\" _src=\"http://yanxuan.nosdn.127.net/57f48b72bc6e352eb894714a1f8a8b91.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc2894eb0345138575ab504d333594e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc2894eb0345138575ab504d333594e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9f80519f4057fe2b770518353c1e54ba.jpg\" _src=\"http://yanxuan.nosdn.127.net/9f80519f4057fe2b770518353c1e54ba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac693fcd5c8215931679e79165d5e296.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac693fcd5c8215931679e79165d5e296.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6393eba575ce70cea073d029634ebbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6393eba575ce70cea073d029634ebbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5d61a3a391dd9cdbf925a22c64b9e5e.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5d61a3a391dd9cdbf925a22c64b9e5e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c20e1cd9cb20290e790c5940f527a87.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c20e1cd9cb20290e790c5940f527a87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce02f5f0ff3745732e3a12148c3a5d5d.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce02f5f0ff3745732e3a12148c3a5d5d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/54dc6d01688e7d83d893141fc2e6b22b.jpg\" _src=\"http://yanxuan.nosdn.127.net/54dc6d01688e7d83d893141fc2e6b22b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d5fca316ce1e6e1af7f102325b841c2.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d5fca316ce1e6e1af7f102325b841c2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb5b1c04f30e91c65e65c32b0771983e.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb5b1c04f30e91c65e65c32b0771983e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81e341e9a18ef59cfa7b9327209acbad.jpg\" _src=\"http://yanxuan.nosdn.127.net/81e341e9a18ef59cfa7b9327209acbad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c7820d2fe56934457ef0d280bb8ccaf.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c7820d2fe56934457ef0d280bb8ccaf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bada6cd54c0255fea7b71ed31c1501aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/bada6cd54c0255fea7b71ed31c1501aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32ce5d7d1f5f8af8f9ca46704b54887c.jpg\" _src=\"http://yanxuan.nosdn.127.net/32ce5d7d1f5f8af8f9ca46704b54887c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1022f8cd66dab75a19b796ba3c0a33c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/1022f8cd66dab75a19b796ba3c0a33c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2e0fd5471a38c2a1fcc3a98b37901df.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2e0fd5471a38c2a1fcc3a98b37901df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c000ee5caa53c3c3fc3fcf4ca70d15c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/c000ee5caa53c3c3fc3fcf4ca70d15c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c615fbe583f71ec737a5370e3ec62704.jpg\" _src=\"http://yanxuan.nosdn.127.net/c615fbe583f71ec737a5370e3ec62704.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c75a501b0dd26128711eaaf1473a702.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c75a501b0dd26128711eaaf1473a702.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64ec846024ab5dfb31af8f31adc318d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/64ec846024ab5dfb31af8f31adc318d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4187be4baa967deb4ace52357d57d0e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/4187be4baa967deb4ace52357d57d0e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64ff91bfba9b6d654cd4e8778ca7a377.jpg\" _src=\"http://yanxuan.nosdn.127.net/64ff91bfba9b6d654cd4e8778ca7a377.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/203171c691368d07fce079b57951ad55.jpg\" _src=\"http://yanxuan.nosdn.127.net/203171c691368d07fce079b57951ad55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f277f7bed9e144f306b039762524f1a7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f277f7bed9e144f306b039762524f1a7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/112ddf960d5664082067149ab5711259.jpg\" _src=\"http://yanxuan.nosdn.127.net/112ddf960d5664082067149ab5711259.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/525d4fc773bd6466c0a80922b50a31e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/525d4fc773bd6466c0a80922b50a31e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/16be6e7f96c5f7d04b3279624d799744.jpg\" _src=\"http://yanxuan.nosdn.127.net/16be6e7f96c5f7d04b3279624d799744.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/43566985315fa49b9bed3848d7e9e642.jpg\" _src=\"http://yanxuan.nosdn.127.net/43566985315fa49b9bed3848d7e9e642.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5c7d39f993cb84e30e440686d1f1a1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5c7d39f993cb84e30e440686d1f1a1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d602e6c0dcebd8a3213a1303d7d1fbf9.jpg\" _src=\"http://yanxuan.nosdn.127.net/d602e6c0dcebd8a3213a1303d7d1fbf9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4033d4dab273a494e40f1d9348430e3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/4033d4dab273a494e40f1d9348430e3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3b50222a722da3cd1762ad5d2391e6aa.jpg\" _src=\"http://yanxuan.nosdn.127.net/3b50222a722da3cd1762ad5d2391e6aa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8bc9fe72c796662a9d927a020826301.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8bc9fe72c796662a9d927a020826301.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2168c4a161398d34db58ad4557a64f56.jpg\" _src=\"http://yanxuan.nosdn.127.net/2168c4a161398d34db58ad4557a64f56.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1490dd0048e08f5bd5853a0fecd5e79d.jpg\" _src=\"http://yanxuan.nosdn.127.net/1490dd0048e08f5bd5853a0fecd5e79d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d42861b593a6714dfad7aa2e7c3a8b6c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d42861b593a6714dfad7aa2e7c3a8b6c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32c3f6773aba55547d81129b08a5b791.jpg\" _src=\"http://yanxuan.nosdn.127.net/32c3f6773aba55547d81129b08a5b791.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74a562662ac5a7ec66d02a4155fc1929.jpg\" _src=\"http://yanxuan.nosdn.127.net/74a562662ac5a7ec66d02a4155fc1929.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6e9ff03ebcca5fdc0fc0bf8b1f2dd4cc.jpg\" _src=\"http://yanxuan.nosdn.127.net/6e9ff03ebcca5fdc0fc0bf8b1f2dd4cc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2bb640bbfb144b053b38c4b7ab743c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2bb640bbfb144b053b38c4b7ab743c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95f16488ee14a8034bb50157b89ad954.jpg\" _src=\"http://yanxuan.nosdn.127.net/95f16488ee14a8034bb50157b89ad954.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79646ad2e9c4895c073f3416f39feddc.jpg\" _src=\"http://yanxuan.nosdn.127.net/79646ad2e9c4895c073f3416f39feddc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ee65bd5c278cc78aaf6310fc93997a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ee65bd5c278cc78aaf6310fc93997a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1495a1fcfd02a89a99dec80a3e877204.jpg\" _src=\"http://yanxuan.nosdn.127.net/1495a1fcfd02a89a99dec80a3e877204.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17203fa91613acfc92871b66bcc6b4e8.jpg\" _src=\"http://yanxuan.nosdn.127.net/17203fa91613acfc92871b66bcc6b4e8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b3c039d856971f842bae005aa7875654.jpg\" _src=\"http://yanxuan.nosdn.127.net/b3c039d856971f842bae005aa7875654.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9b4e6f29901675d93f21d8ad927719b.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9b4e6f29901675d93f21d8ad927719b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d31ae42d445e94231c351b5b8eb2f7f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d31ae42d445e94231c351b5b8eb2f7f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8afcf9745702cdae2bf2ab3b3044c5a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8afcf9745702cdae2bf2ab3b3044c5a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61891461006ee565d46ca289a24ca314.jpg\" _src=\"http://yanxuan.nosdn.127.net/61891461006ee565d46ca289a24ca314.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '21', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4a7d55aa95b6d903530663bc0483a40b.jpg', 'http://yanxuan.nosdn.127.net/6eb8d1c37142a5951b6242791c78146b.png', '59.00', '51', '1111078', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110014', '1017000', '1110014', '日式气质木纹自动伸缩牵引器', '0', '100', '', '高强耐拉，乐享自由', '<p><img src=\"http://yanxuan.nosdn.127.net/deefd1e1e47f5f5173de67f44388c59b.jpg\" _src=\"http://yanxuan.nosdn.127.net/deefd1e1e47f5f5173de67f44388c59b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/794f0bb940d8d950d1b3e0ee69d899de.jpg\" _src=\"http://yanxuan.nosdn.127.net/794f0bb940d8d950d1b3e0ee69d899de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dea8ebd578148db7041a1e4dafc97c27.jpg\" _src=\"http://yanxuan.nosdn.127.net/dea8ebd578148db7041a1e4dafc97c27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4cbc622172384759c19f44e2aa206bc9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4cbc622172384759c19f44e2aa206bc9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a4802702df0df04b9213245dd06dee0.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a4802702df0df04b9213245dd06dee0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ebf1a8d7cda41905526be8673e14f341.jpg\" _src=\"http://yanxuan.nosdn.127.net/ebf1a8d7cda41905526be8673e14f341.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0706a184a0c0160dde897b8e00d8a32e.jpg\" _src=\"http://yanxuan.nosdn.127.net/0706a184a0c0160dde897b8e00d8a32e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/555396fbc4c6d8926c952fa05a75ac58.jpg\" _src=\"http://yanxuan.nosdn.127.net/555396fbc4c6d8926c952fa05a75ac58.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd7dd0e3db90c2da6bc940c5b7e536d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd7dd0e3db90c2da6bc940c5b7e536d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8784690c2c3f83b64834c1178741f98.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8784690c2c3f83b64834c1178741f98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d89656b94a10f9e5e67781d3ca600b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d89656b94a10f9e5e67781d3ca600b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7308e055a79a2c83dfc6d6cf2c0a3dd1.jpg\" _src=\"http://yanxuan.nosdn.127.net/7308e055a79a2c83dfc6d6cf2c0a3dd1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c84a144a5e1159c1cff296ac193b203b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c84a144a5e1159c1cff296ac193b203b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/799e3dda5d38de73aa84ba0355505755.jpg\" _src=\"http://yanxuan.nosdn.127.net/799e3dda5d38de73aa84ba0355505755.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e75a5d307e7e0d21e3a4b3e8372e09b.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e75a5d307e7e0d21e3a4b3e8372e09b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/267760e491d92e8b7e1c259933bfc400.jpg\" _src=\"http://yanxuan.nosdn.127.net/267760e491d92e8b7e1c259933bfc400.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b99e02d2eae0df02712f348463c27274.jpg\" _src=\"http://yanxuan.nosdn.127.net/b99e02d2eae0df02712f348463c27274.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff808a3d431c1b0717a54ac20a5a922c.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff808a3d431c1b0717a54ac20a5a922c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7071fc30d982a7e4aa92299f652bddcd.jpg\" _src=\"http://yanxuan.nosdn.127.net/7071fc30d982a7e4aa92299f652bddcd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ca6aa2604ca0a8937e4576d2bce61b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ca6aa2604ca0a8937e4576d2bce61b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5f1915e0b9bd2c21a734de45207ddcb.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5f1915e0b9bd2c21a734de45207ddcb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b4a6d76267f9eafb45cb9765a44ae7e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b4a6d76267f9eafb45cb9765a44ae7e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8258477ab7b59b9820b8940f10518cfb.jpg\" _src=\"http://yanxuan.nosdn.127.net/8258477ab7b59b9820b8940f10518cfb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2020b32805ac08c2ddbad061af4f84e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2020b32805ac08c2ddbad061af4f84e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f937890dd7b40d042f5fcb2242b4317f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f937890dd7b40d042f5fcb2242b4317f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e290d03307d69686f597a1a0601bbb8.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e290d03307d69686f597a1a0601bbb8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6cba60c91dd25960bb65efbc9f83c251.jpg\" _src=\"http://yanxuan.nosdn.127.net/6cba60c91dd25960bb65efbc9f83c251.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5009c0ca55ab97e4e5122075b6e1b30c.jpg\" _src=\"http://yanxuan.nosdn.127.net/5009c0ca55ab97e4e5122075b6e1b30c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac90c373104c8abf3d825efac4cc729e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac90c373104c8abf3d825efac4cc729e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c7a167fddbaf4d713ee99a429640ba99.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7a167fddbaf4d713ee99a429640ba99.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06e16e9d3ccba84fc7df990653e37785.jpg\" _src=\"http://yanxuan.nosdn.127.net/06e16e9d3ccba84fc7df990653e37785.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/19be4fe0fd855545ed4e51587646ae35.jpg\" _src=\"http://yanxuan.nosdn.127.net/19be4fe0fd855545ed4e51587646ae35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/efc8c66e46107c1c8eb2392d0d8a1ba1.jpg\" _src=\"http://yanxuan.nosdn.127.net/efc8c66e46107c1c8eb2392d0d8a1ba1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33b11b17fc15336d3fa231d7684985f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/33b11b17fc15336d3fa231d7684985f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a613f8fb5b16bc1a973898a34088869.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a613f8fb5b16bc1a973898a34088869.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f25203077ed714d566121044b79a6c1.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f25203077ed714d566121044b79a6c1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/52f085a9923e513bf1b2d23d3484d845.jpg\" _src=\"http://yanxuan.nosdn.127.net/52f085a9923e513bf1b2d23d3484d845.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ace9393853eca8a75e09185a20bbbd82.jpg\" _src=\"http://yanxuan.nosdn.127.net/ace9393853eca8a75e09185a20bbbd82.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c58723d159ab4f9ac95a17cbbe53e9b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/c58723d159ab4f9ac95a17cbbe53e9b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d356893914da91bd41fe34b6625fa429.jpg\" _src=\"http://yanxuan.nosdn.127.net/d356893914da91bd41fe34b6625fa429.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f87ca94f03bb95f4dff3083dd50480b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/f87ca94f03bb95f4dff3083dd50480b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26033b57b7d4cd29be6d710d90faa1c5.jpg\" _src=\"http://yanxuan.nosdn.127.net/26033b57b7d4cd29be6d710d90faa1c5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/302250c5116534d843b10c94e352bb98.jpg\" _src=\"http://yanxuan.nosdn.127.net/302250c5116534d843b10c94e352bb98.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2aa6cd1857b3bdae08a60f41223fa6ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/2aa6cd1857b3bdae08a60f41223fa6ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d4967bc254bd4074b7323fa334b1247.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d4967bc254bd4074b7323fa334b1247.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7fc77c93e58b8f449a86d4584452671c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7fc77c93e58b8f449a86d4584452671c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/709028e78b59cb1e2a78961099d25931.jpg\" _src=\"http://yanxuan.nosdn.127.net/709028e78b59cb1e2a78961099d25931.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/338f45391ca7fc9209a305574020461f.jpg\" _src=\"http://yanxuan.nosdn.127.net/338f45391ca7fc9209a305574020461f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/055da3a4861cc7ea9002b98a9f86ef10.jpg\" _src=\"http://yanxuan.nosdn.127.net/055da3a4861cc7ea9002b98a9f86ef10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4145c6411a6eaafb5dfe8ee7c6946351.jpg\" _src=\"http://yanxuan.nosdn.127.net/4145c6411a6eaafb5dfe8ee7c6946351.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d8d188eaaae7651e39a8d2d8c89c616.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d8d188eaaae7651e39a8d2d8c89c616.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d4bbc908d7ee92b20692e4a15562eeb6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d4bbc908d7ee92b20692e4a15562eeb6.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '22', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/65e368a6a45311923af035322e336c8f.jpg', 'http://yanxuan.nosdn.127.net/cb4f78bd887059416c3df485e3f31366.png', '69.00', '308', '1111081', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110015', '1017000', '1110015', '迷彩宠物自动伸缩牵引器', '0', '100', '', '硬汉行军梦，乐享自由', '<p><img src=\"http://yanxuan.nosdn.127.net/79105794a2c452ae2c6329c6bf8c9273.jpg\" _src=\"http://yanxuan.nosdn.127.net/79105794a2c452ae2c6329c6bf8c9273.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57eae60064c316610543e701cfe93e96.jpg\" _src=\"http://yanxuan.nosdn.127.net/57eae60064c316610543e701cfe93e96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ce34503fef68caf6d0771ce489b664b3.jpg\" _src=\"http://yanxuan.nosdn.127.net/ce34503fef68caf6d0771ce489b664b3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f605d5a21c2962e417dabbffd3ac9a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f605d5a21c2962e417dabbffd3ac9a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/848b78dc0beba526d542876ef1923551.jpg\" _src=\"http://yanxuan.nosdn.127.net/848b78dc0beba526d542876ef1923551.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6a414b9f678c7422793e3a73d13c67c6.jpg\" _src=\"http://yanxuan.nosdn.127.net/6a414b9f678c7422793e3a73d13c67c6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13af8092bc30b9129f6ad0733b95162d.jpg\" _src=\"http://yanxuan.nosdn.127.net/13af8092bc30b9129f6ad0733b95162d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d82faa9ce96ac739baa7a833bce560ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/d82faa9ce96ac739baa7a833bce560ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f48181394509db903573b274d814bdba.jpg\" _src=\"http://yanxuan.nosdn.127.net/f48181394509db903573b274d814bdba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/caa9e0c970f726b671845a46723a3723.jpg\" _src=\"http://yanxuan.nosdn.127.net/caa9e0c970f726b671845a46723a3723.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95a65b931702b9bc9b8313b7e7c3f518.jpg\" _src=\"http://yanxuan.nosdn.127.net/95a65b931702b9bc9b8313b7e7c3f518.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6c9b138462597caaf5c0660aee20bae8.jpg\" _src=\"http://yanxuan.nosdn.127.net/6c9b138462597caaf5c0660aee20bae8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7eed385b97a777f7ac412697c666247.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7eed385b97a777f7ac412697c666247.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1482587331802312edf1895e857e552d.jpg\" _src=\"http://yanxuan.nosdn.127.net/1482587331802312edf1895e857e552d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b044d9f12bde1561c94ca8cee7f7f979.jpg\" _src=\"http://yanxuan.nosdn.127.net/b044d9f12bde1561c94ca8cee7f7f979.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d205e25749fb9b0d4af3dbc466d95b5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d205e25749fb9b0d4af3dbc466d95b5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e53bd1ea12008cbbb240a825c9f92bee.jpg\" _src=\"http://yanxuan.nosdn.127.net/e53bd1ea12008cbbb240a825c9f92bee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e9bd5657cb7861dba534546117d9c726.jpg\" _src=\"http://yanxuan.nosdn.127.net/e9bd5657cb7861dba534546117d9c726.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e074eaf6455bb6a53aca5ce6943a9b3d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e074eaf6455bb6a53aca5ce6943a9b3d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a1aaabf261cccf3af9b343731f20926d.jpg\" _src=\"http://yanxuan.nosdn.127.net/a1aaabf261cccf3af9b343731f20926d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/232ceaf8e2b7da00038a54350232e8a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/232ceaf8e2b7da00038a54350232e8a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f1907020daf59fac9c3181b02d51a55.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f1907020daf59fac9c3181b02d51a55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/220eb6332bc45b1b9fa47e2dbb374256.jpg\" _src=\"http://yanxuan.nosdn.127.net/220eb6332bc45b1b9fa47e2dbb374256.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/62e17702cae34798f2dbe07bcaadb287.jpg\" _src=\"http://yanxuan.nosdn.127.net/62e17702cae34798f2dbe07bcaadb287.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5c5d6c56dbde2c1653ebe5735b6190c3.jpg\" _src=\"http://yanxuan.nosdn.127.net/5c5d6c56dbde2c1653ebe5735b6190c3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34ca3cd8ce6a40f59b22116afdab1075.jpg\" _src=\"http://yanxuan.nosdn.127.net/34ca3cd8ce6a40f59b22116afdab1075.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/396af7781da470447075907394db2cca.jpg\" _src=\"http://yanxuan.nosdn.127.net/396af7781da470447075907394db2cca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdc20c381878009488d32a1d2912ee6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdc20c381878009488d32a1d2912ee6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42345a87ea60c34a0f8faa7e3edac8fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/42345a87ea60c34a0f8faa7e3edac8fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/146ba6a499a0c499ee3f85d3855bea01.jpg\" _src=\"http://yanxuan.nosdn.127.net/146ba6a499a0c499ee3f85d3855bea01.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8c0db9c2353395945a623541f8a13271.jpg\" _src=\"http://yanxuan.nosdn.127.net/8c0db9c2353395945a623541f8a13271.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85764c294ae6e5971ae40c007db161e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/85764c294ae6e5971ae40c007db161e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/244d6da57df6c16cbf68ac7e87356631.jpg\" _src=\"http://yanxuan.nosdn.127.net/244d6da57df6c16cbf68ac7e87356631.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f226e3bac8021f48e8f44dff22275431.jpg\" _src=\"http://yanxuan.nosdn.127.net/f226e3bac8021f48e8f44dff22275431.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d7388734a1b04994700d7fa5f9983e4b.jpg\" _src=\"http://yanxuan.nosdn.127.net/d7388734a1b04994700d7fa5f9983e4b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/503498e8a0be9d83abc5316a5ea2db37.jpg\" _src=\"http://yanxuan.nosdn.127.net/503498e8a0be9d83abc5316a5ea2db37.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a6ad162098547b6ce56b87c8d40f9bfd.jpg\" _src=\"http://yanxuan.nosdn.127.net/a6ad162098547b6ce56b87c8d40f9bfd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c3b5b5e1cfa50e3c41a8846a13d1eff.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c3b5b5e1cfa50e3c41a8846a13d1eff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0e93b8fe15b7b16650505ae84dbd2565.jpg\" _src=\"http://yanxuan.nosdn.127.net/0e93b8fe15b7b16650505ae84dbd2565.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02bab1f1168d381ca9b2a346a327d7a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/02bab1f1168d381ca9b2a346a327d7a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/849f45341a365d7ec921d356cb5585e3.jpg\" _src=\"http://yanxuan.nosdn.127.net/849f45341a365d7ec921d356cb5585e3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34f38ebef5ab886068f0c445aa6cefc4.jpg\" _src=\"http://yanxuan.nosdn.127.net/34f38ebef5ab886068f0c445aa6cefc4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ef4a7a270d0cd1b3912dfe357eec8e96.jpg\" _src=\"http://yanxuan.nosdn.127.net/ef4a7a270d0cd1b3912dfe357eec8e96.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/314fab8eb661d70a074a98c6dcdca436.jpg\" _src=\"http://yanxuan.nosdn.127.net/314fab8eb661d70a074a98c6dcdca436.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/63bac6f8d49471ca9e48720cc42972e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/63bac6f8d49471ca9e48720cc42972e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eea9c92505b3f9f6c4eab429ad252220.jpg\" _src=\"http://yanxuan.nosdn.127.net/eea9c92505b3f9f6c4eab429ad252220.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c7253dcf8a0510904b33b82554548fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c7253dcf8a0510904b33b82554548fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4908c7746e5b22d1652fbbab9cf86a70.jpg\" _src=\"http://yanxuan.nosdn.127.net/4908c7746e5b22d1652fbbab9cf86a70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ddcfbe295ca6306b4f7b84c764c839bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddcfbe295ca6306b4f7b84c764c839bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc3c403bd9d0d72e762f32f8ff5e29d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc3c403bd9d0d72e762f32f8ff5e29d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d2da48f8b0f54a78c1091f9ce5d7e92f.jpg\" _src=\"http://yanxuan.nosdn.127.net/d2da48f8b0f54a78c1091f9ce5d7e92f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/45b29883e4d35bbe65fb9e6d23a67301.jpg\" _src=\"http://yanxuan.nosdn.127.net/45b29883e4d35bbe65fb9e6d23a67301.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '23', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e8a4409996ba8849b20a7fbb11f1d08c.jpg', 'http://yanxuan.nosdn.127.net/56da5270172244be56c00fdc8eb24fae.png', '69.00', '190', '1111083', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110016', '1017000', '1110016', '天然硅胶宠物除毛按摩刷', '0', '100', '', '顺滑平面，猫狗通用，去除死毛', '<p><img src=\"http://yanxuan.nosdn.127.net/349c1ba56a59c2b0bcb76dd43d84a7e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/349c1ba56a59c2b0bcb76dd43d84a7e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61b69b45c5ed2d2c1f19bdea0659379c.jpg\" _src=\"http://yanxuan.nosdn.127.net/61b69b45c5ed2d2c1f19bdea0659379c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/34f2c4fcb409862b2710d50498bca45e.jpg\" _src=\"http://yanxuan.nosdn.127.net/34f2c4fcb409862b2710d50498bca45e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c304d4de0e654628050b6ce00e607a9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c304d4de0e654628050b6ce00e607a9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2d0a4421fba483d87423bd4fac9faec.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2d0a4421fba483d87423bd4fac9faec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8bd8af34c260e80bab8b8e57f6ea2183.jpg\" _src=\"http://yanxuan.nosdn.127.net/8bd8af34c260e80bab8b8e57f6ea2183.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5cda4f2efffff76d65610f614b49a202.jpg\" _src=\"http://yanxuan.nosdn.127.net/5cda4f2efffff76d65610f614b49a202.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cc124fbd43eddbe4e1463b1b6a8dd471.jpg\" _src=\"http://yanxuan.nosdn.127.net/cc124fbd43eddbe4e1463b1b6a8dd471.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e5b29d8235c1cbfba488ecfc3c3f27ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/e5b29d8235c1cbfba488ecfc3c3f27ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31b6327450d28304ea07381fe78dc973.jpg\" _src=\"http://yanxuan.nosdn.127.net/31b6327450d28304ea07381fe78dc973.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77693ac3498f70c0bb79b8c69396693f.jpg\" _src=\"http://yanxuan.nosdn.127.net/77693ac3498f70c0bb79b8c69396693f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae07efe150fb2eaa356d30c1ca7fe2f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae07efe150fb2eaa356d30c1ca7fe2f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d8dd8cf0bea6fce81b70e6e4415f1091.jpg\" _src=\"http://yanxuan.nosdn.127.net/d8dd8cf0bea6fce81b70e6e4415f1091.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae3333e73593e858f65333d34bd7cd72.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae3333e73593e858f65333d34bd7cd72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07deeb564de5b2b043f73157367602ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/07deeb564de5b2b043f73157367602ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d684f6eef48bb1d0e8d7bf863e1d0cae.jpg\" _src=\"http://yanxuan.nosdn.127.net/d684f6eef48bb1d0e8d7bf863e1d0cae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d793d650c04960a471f5458b2bb4afaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/d793d650c04960a471f5458b2bb4afaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e46ab5cb161edb04128eb94ded48568.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e46ab5cb161edb04128eb94ded48568.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d9df69a2f4200ba68031318c84b705e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d9df69a2f4200ba68031318c84b705e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99243319ea97ec69dbcb9d724b51a58b.jpg\" _src=\"http://yanxuan.nosdn.127.net/99243319ea97ec69dbcb9d724b51a58b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3adf64f8719faf94df0d5ae0411fc2ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/3adf64f8719faf94df0d5ae0411fc2ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/181c2ce6ae97ab5d462bddf98ed59079.jpg\" _src=\"http://yanxuan.nosdn.127.net/181c2ce6ae97ab5d462bddf98ed59079.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f33019d4412be955b9c390ce702658ec.jpg\" _src=\"http://yanxuan.nosdn.127.net/f33019d4412be955b9c390ce702658ec.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c42cdadbe4ebc7ab2b418ff8efb3025.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c42cdadbe4ebc7ab2b418ff8efb3025.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6129c768b0ffade7598ebfa5d2a4b8d5.jpg\" _src=\"http://yanxuan.nosdn.127.net/6129c768b0ffade7598ebfa5d2a4b8d5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2f12e9b2a3f0a6b7b38a54fcf0993f8.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2f12e9b2a3f0a6b7b38a54fcf0993f8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/79f0d28d84fd46a221d758ac0e0d99ad.jpg\" _src=\"http://yanxuan.nosdn.127.net/79f0d28d84fd46a221d758ac0e0d99ad.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3e30101be1840a0514734d6b2031d654.jpg\" _src=\"http://yanxuan.nosdn.127.net/3e30101be1840a0514734d6b2031d654.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5ee5b7cc6cfa28ad6b428233f99ac8f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5ee5b7cc6cfa28ad6b428233f99ac8f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73d06bb7dda41f028f5655b0ab74e009.jpg\" _src=\"http://yanxuan.nosdn.127.net/73d06bb7dda41f028f5655b0ab74e009.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/03a906a6316bbbf9795d84daae12ad15.jpg\" _src=\"http://yanxuan.nosdn.127.net/03a906a6316bbbf9795d84daae12ad15.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5eedbf4fbe9c27174490e6c75883996.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5eedbf4fbe9c27174490e6c75883996.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17d16de92da4306b5f8223d6ffbc20f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/17d16de92da4306b5f8223d6ffbc20f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58999595a9df116b75047c762c5b9353.jpg\" _src=\"http://yanxuan.nosdn.127.net/58999595a9df116b75047c762c5b9353.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fb309858224aaad9f715e931e17941f.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fb309858224aaad9f715e931e17941f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58338ee2fcc1475ff85a5228b0d6d2ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/58338ee2fcc1475ff85a5228b0d6d2ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46578b36864ff3c0d65e57d54e6afafd.jpg\" _src=\"http://yanxuan.nosdn.127.net/46578b36864ff3c0d65e57d54e6afafd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f4f4b26d6f5539843f5c849fce3aab4.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f4f4b26d6f5539843f5c849fce3aab4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7a7a8f6c77d6777c469509ddb682b3b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/7a7a8f6c77d6777c469509ddb682b3b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9c655f6a4696f1f8af5ae74dce48136.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9c655f6a4696f1f8af5ae74dce48136.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/567cb6067f482a0904676b42f9485525.jpg\" _src=\"http://yanxuan.nosdn.127.net/567cb6067f482a0904676b42f9485525.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3674e1135b78465fd9cc89ae2cc29513.jpg\" _src=\"http://yanxuan.nosdn.127.net/3674e1135b78465fd9cc89ae2cc29513.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c831a877d84f3416df1944253b8b5b17.jpg\" _src=\"http://yanxuan.nosdn.127.net/c831a877d84f3416df1944253b8b5b17.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '12', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/85dcca64b215bccf2fb9890abe7da93e.jpg', 'http://yanxuan.nosdn.127.net/3bd73b7279a83d1cbb50c0e45778e6d6.png', '39.00', '27', '1111086', '0.00', '限时购', '', '0.00', '0', '0', '0', '42.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110017', '1017000', '1110017', '耐用材料猫咪护理清洁套装', '0', '100', '', '精致钢材，美容清洁', '<p><img src=\"http://yanxuan.nosdn.127.net/b83b83d029769ba43eb604d0822cf3fe.jpg\" _src=\"http://yanxuan.nosdn.127.net/b83b83d029769ba43eb604d0822cf3fe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/117eaaa0bbcb04f976f03eeb05472db0.jpg\" _src=\"http://yanxuan.nosdn.127.net/117eaaa0bbcb04f976f03eeb05472db0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e939bfcf69341567ec7d9aaa21fb8c50.jpg\" _src=\"http://yanxuan.nosdn.127.net/e939bfcf69341567ec7d9aaa21fb8c50.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2db912941720c76c078cab943c065ac7.jpg\" _src=\"http://yanxuan.nosdn.127.net/2db912941720c76c078cab943c065ac7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c6f1289733e6310e36f0c8c1c38c2ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c6f1289733e6310e36f0c8c1c38c2ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2e2d5be411026b73d248462680bb17a.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2e2d5be411026b73d248462680bb17a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47c36e0d9a1b6dbc9c43423b11ae1f78.jpg\" _src=\"http://yanxuan.nosdn.127.net/47c36e0d9a1b6dbc9c43423b11ae1f78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b91df47b5111fbba6021c5393523827e.jpg\" _src=\"http://yanxuan.nosdn.127.net/b91df47b5111fbba6021c5393523827e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/284322e6bf6f9f58dc1ea6b6d78f4934.jpg\" _src=\"http://yanxuan.nosdn.127.net/284322e6bf6f9f58dc1ea6b6d78f4934.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c083051cd5caba0853d6b9c53df7efc.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c083051cd5caba0853d6b9c53df7efc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3d8bbc6f7f0ff2a083d1e071787d693.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3d8bbc6f7f0ff2a083d1e071787d693.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a5ebb8710abd6a9bc722c47e52fc316.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a5ebb8710abd6a9bc722c47e52fc316.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e00b00f4d2e7273dc10eb6ed72fcb81f.jpg\" _src=\"http://yanxuan.nosdn.127.net/e00b00f4d2e7273dc10eb6ed72fcb81f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/179a14fafea43cacfc20359365205bbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/179a14fafea43cacfc20359365205bbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd40961ca226fab994e32b69f50ec9a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd40961ca226fab994e32b69f50ec9a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57d6b84e80212d250f3dd6075245626d.jpg\" _src=\"http://yanxuan.nosdn.127.net/57d6b84e80212d250f3dd6075245626d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e15d760de63f08f07bed93f23ec05f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e15d760de63f08f07bed93f23ec05f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eb194af37a6171d2a01bf62b9f050e8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/eb194af37a6171d2a01bf62b9f050e8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/884320d6edcc611d24ad21b1141c25b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/884320d6edcc611d24ad21b1141c25b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba72d5d988de555c409567c169a84dde.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba72d5d988de555c409567c169a84dde.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2a07e2087bbf898d06fdd81dfca2df8.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2a07e2087bbf898d06fdd81dfca2df8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c56478dc47d57ad8e9975bc3f56d8a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c56478dc47d57ad8e9975bc3f56d8a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/646b5e65aa8e103ad53520a651708b42.jpg\" _src=\"http://yanxuan.nosdn.127.net/646b5e65aa8e103ad53520a651708b42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14553a06674418536634641341ba2279.jpg\" _src=\"http://yanxuan.nosdn.127.net/14553a06674418536634641341ba2279.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0b01dbd307c437639b37bbf595fa221f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0b01dbd307c437639b37bbf595fa221f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/597ebc5225250483d119412011236fbe.jpg\" _src=\"http://yanxuan.nosdn.127.net/597ebc5225250483d119412011236fbe.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/def4b6a46e8cfc94d1406364217674b2.jpg\" _src=\"http://yanxuan.nosdn.127.net/def4b6a46e8cfc94d1406364217674b2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/861e9e9daac7cfe608c8b97a714bcc18.jpg\" _src=\"http://yanxuan.nosdn.127.net/861e9e9daac7cfe608c8b97a714bcc18.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0f60034e88744709f095c96709b17af.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0f60034e88744709f095c96709b17af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d107a65c0c7099ba6cf5d1b961d7463.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d107a65c0c7099ba6cf5d1b961d7463.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2863cd9018abe484803b09cf9445c35.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2863cd9018abe484803b09cf9445c35.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a898b97d00a5d1c0d02893dbce8e3b0f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a898b97d00a5d1c0d02893dbce8e3b0f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4af6b2c9a95ec988fd818a7f3ef182ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/4af6b2c9a95ec988fd818a7f3ef182ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23c5eb669a232ec8beb8f5f16c90546f.jpg\" _src=\"http://yanxuan.nosdn.127.net/23c5eb669a232ec8beb8f5f16c90546f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/070e38033dc3a05012e7eb509f88aadb.jpg\" _src=\"http://yanxuan.nosdn.127.net/070e38033dc3a05012e7eb509f88aadb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e8036939f9edbcbdeb5927c911802ac2.jpg\" _src=\"http://yanxuan.nosdn.127.net/e8036939f9edbcbdeb5927c911802ac2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c35fd3d43a7dbe1d2517867ff622339.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c35fd3d43a7dbe1d2517867ff622339.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d4c5c234ccc8b158270174b8d2d875b.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d4c5c234ccc8b158270174b8d2d875b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb3868ecac5f9eb338a199fca0470ed1.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb3868ecac5f9eb338a199fca0470ed1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/26878b0d7aa87ea6ca14e9ad5a1e7e28.jpg\" _src=\"http://yanxuan.nosdn.127.net/26878b0d7aa87ea6ca14e9ad5a1e7e28.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b2d42e7df82105f2fa0725a5d1f9e967.jpg\" _src=\"http://yanxuan.nosdn.127.net/b2d42e7df82105f2fa0725a5d1f9e967.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4dd59366d29dd79d94bdf1a015d13340.jpg\" _src=\"http://yanxuan.nosdn.127.net/4dd59366d29dd79d94bdf1a015d13340.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69ae431632b8f6cd7fd6169b248c755a.jpg\" _src=\"http://yanxuan.nosdn.127.net/69ae431632b8f6cd7fd6169b248c755a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7cc2339764709b17ba30ab09c088ba2.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7cc2339764709b17ba30ab09c088ba2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/baaf875d2f9113049ecdfe4368ae997e.jpg\" _src=\"http://yanxuan.nosdn.127.net/baaf875d2f9113049ecdfe4368ae997e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8899a3367f43543e7990fe00d27ef6a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/8899a3367f43543e7990fe00d27ef6a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d640655f288850e49e385ca62553b423.jpg\" _src=\"http://yanxuan.nosdn.127.net/d640655f288850e49e385ca62553b423.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5be64320b03f6c68cfb89481b3127529.jpg\" _src=\"http://yanxuan.nosdn.127.net/5be64320b03f6c68cfb89481b3127529.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ba6c788e03d06929b105209c07646106.jpg\" _src=\"http://yanxuan.nosdn.127.net/ba6c788e03d06929b105209c07646106.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/37a3cab46afb1afb717fc5536cb5bd81.jpg\" _src=\"http://yanxuan.nosdn.127.net/37a3cab46afb1afb717fc5536cb5bd81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/807c872ecb54480af96f46ca1dd5b8d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/807c872ecb54480af96f46ca1dd5b8d2.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '14', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/f77d0da8a08d35cbedd3d1b5117064d7.jpg', 'http://yanxuan.nosdn.127.net/534231583f82572398ec84bad425cdaf.png', '79.00', '154', '1111087', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110018', '1017000', '1110018', '耐用狗狗清洁美容护理套装', '0', '100', '', '精致钢材，耐咬美容', '<p><img src=\"http://yanxuan.nosdn.127.net/3854994be7c4da17e5a2f316b8e0a115.jpg\" _src=\"http://yanxuan.nosdn.127.net/3854994be7c4da17e5a2f316b8e0a115.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/875e35f196d220324fa1d1448c635852.jpg\" _src=\"http://yanxuan.nosdn.127.net/875e35f196d220324fa1d1448c635852.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60ed2b973f7be99c217d2a7cebbd4296.jpg\" _src=\"http://yanxuan.nosdn.127.net/60ed2b973f7be99c217d2a7cebbd4296.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff5e0e33fd75703190ae409c6d21e366.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff5e0e33fd75703190ae409c6d21e366.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be57569f669c85a9b0187a66e1572178.jpg\" _src=\"http://yanxuan.nosdn.127.net/be57569f669c85a9b0187a66e1572178.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/191dc75b06fa04bef578f0e848d17d07.jpg\" _src=\"http://yanxuan.nosdn.127.net/191dc75b06fa04bef578f0e848d17d07.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbf0148a77e3441b68939abb092496e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbf0148a77e3441b68939abb092496e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac2fa1219b362841a6d1dc241a51d2c9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac2fa1219b362841a6d1dc241a51d2c9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c27a79ce5a90f227ff4e50f3fb619e1b.jpg\" _src=\"http://yanxuan.nosdn.127.net/c27a79ce5a90f227ff4e50f3fb619e1b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ce899dc8db6d3353d9c34b50a24a111.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ce899dc8db6d3353d9c34b50a24a111.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2c7d9ad1e857941277f82f9874c2081.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2c7d9ad1e857941277f82f9874c2081.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/28edef9e1654a433a400ca200d7c7c55.jpg\" _src=\"http://yanxuan.nosdn.127.net/28edef9e1654a433a400ca200d7c7c55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2ba3171699b0d6c2f695e6cdcf8e598e.jpg\" _src=\"http://yanxuan.nosdn.127.net/2ba3171699b0d6c2f695e6cdcf8e598e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0d29d0225d53e8922260018b0c86642.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0d29d0225d53e8922260018b0c86642.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70a629edf4e3d395ba12c96a1e6d7180.jpg\" _src=\"http://yanxuan.nosdn.127.net/70a629edf4e3d395ba12c96a1e6d7180.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6c160891c4df84eda72a641f86cadd6.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6c160891c4df84eda72a641f86cadd6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e96a60883b2bd0145f8af51168c547a8.jpg\" _src=\"http://yanxuan.nosdn.127.net/e96a60883b2bd0145f8af51168c547a8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a45dd7da46705aee759e95d0d8587f06.jpg\" _src=\"http://yanxuan.nosdn.127.net/a45dd7da46705aee759e95d0d8587f06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7f20607c2e7a2780e2b37cae44b52af.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7f20607c2e7a2780e2b37cae44b52af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8efd5ead32d88db8fcd944dd1f72f9d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/8efd5ead32d88db8fcd944dd1f72f9d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1032f7228911b42dbfae13d3a7093b9e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1032f7228911b42dbfae13d3a7093b9e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b96b094cedf2ddceb42c273477cc3717.jpg\" _src=\"http://yanxuan.nosdn.127.net/b96b094cedf2ddceb42c273477cc3717.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3c7bc21e4bc28e894d58cbd7c66706eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/3c7bc21e4bc28e894d58cbd7c66706eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/491b83a15dda113d32f03807ca005684.jpg\" _src=\"http://yanxuan.nosdn.127.net/491b83a15dda113d32f03807ca005684.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/625930a2fa643787da5d7f2f8b7403a2.jpg\" _src=\"http://yanxuan.nosdn.127.net/625930a2fa643787da5d7f2f8b7403a2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd061b996d5bfa2b0ff4cb0252fc193a.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd061b996d5bfa2b0ff4cb0252fc193a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/433c5a8317a3806cc81e14c3f8cb84a9.jpg\" _src=\"http://yanxuan.nosdn.127.net/433c5a8317a3806cc81e14c3f8cb84a9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2bace2645a1676f402168453afe0abc6.jpg\" _src=\"http://yanxuan.nosdn.127.net/2bace2645a1676f402168453afe0abc6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f71c354f48548663f30b982b56dffd2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f71c354f48548663f30b982b56dffd2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47d6aeeefdeb2c16fc0fb5e3dfadf5d3.jpg\" _src=\"http://yanxuan.nosdn.127.net/47d6aeeefdeb2c16fc0fb5e3dfadf5d3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9950b6e3db69079542793ff1a5767e7b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9950b6e3db69079542793ff1a5767e7b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/30b8844248a0063ac6242f0c71be15ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/30b8844248a0063ac6242f0c71be15ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66c73c753f1071a23b0d9a1b2557726a.jpg\" _src=\"http://yanxuan.nosdn.127.net/66c73c753f1071a23b0d9a1b2557726a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/448f60c3e39778df00dc650374005029.jpg\" _src=\"http://yanxuan.nosdn.127.net/448f60c3e39778df00dc650374005029.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d02115e001d27a057cfe22c7d5aebf2e.jpg\" _src=\"http://yanxuan.nosdn.127.net/d02115e001d27a057cfe22c7d5aebf2e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38af331901526fa722a8287481fb926c.jpg\" _src=\"http://yanxuan.nosdn.127.net/38af331901526fa722a8287481fb926c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ab8fdd7ef8d01c0130b53095d6497a94.jpg\" _src=\"http://yanxuan.nosdn.127.net/ab8fdd7ef8d01c0130b53095d6497a94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ecabbfba3838ec15af9f0599943f47a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ecabbfba3838ec15af9f0599943f47a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d502d68633f2c4ea2b4c5d0ab80c5a5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d502d68633f2c4ea2b4c5d0ab80c5a5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4a45df861c4167e26960694ddc076401.jpg\" _src=\"http://yanxuan.nosdn.127.net/4a45df861c4167e26960694ddc076401.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0d1aabd78848eea2965f9668e5335d5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/0d1aabd78848eea2965f9668e5335d5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbb869169b8b23830e324f96779424c1.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbb869169b8b23830e324f96779424c1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd9ce065fe1563d5520de468a1179b65.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd9ce065fe1563d5520de468a1179b65.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b89dfd9f8acd2b5cd2782d1a648c5e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b89dfd9f8acd2b5cd2782d1a648c5e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/70876851a29e0e910842ac894f96eba8.jpg\" _src=\"http://yanxuan.nosdn.127.net/70876851a29e0e910842ac894f96eba8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ace99aa398960caeb7ca6c5b766be6e4.jpg\" _src=\"http://yanxuan.nosdn.127.net/ace99aa398960caeb7ca6c5b766be6e4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a7f4307003805e93698588edee29c130.jpg\" _src=\"http://yanxuan.nosdn.127.net/a7f4307003805e93698588edee29c130.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fecdb7d78e8301c026397575a661d02e.jpg\" _src=\"http://yanxuan.nosdn.127.net/fecdb7d78e8301c026397575a661d02e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6f3a1391596df218f87ee68336bb3074.jpg\" _src=\"http://yanxuan.nosdn.127.net/6f3a1391596df218f87ee68336bb3074.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '15', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4f00698bc45451f04738ddb4d9ae2228.jpg', 'http://yanxuan.nosdn.127.net/d93aa5d6e7a296101cf4cb72613aeda6.png', '79.00', '362', '1111088', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1110019', '1017000', '1110019', '宠物合金钢安全除菌指甲护理组合', '0', '100', '', '猫狗皆可用，保护家具', '<p><img src=\"http://yanxuan.nosdn.127.net/ddc3b83c0849e81d292991b65df5aa60.jpg\" _src=\"http://yanxuan.nosdn.127.net/ddc3b83c0849e81d292991b65df5aa60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1015c576df64e0676520bf6e150aa491.jpg\" _src=\"http://yanxuan.nosdn.127.net/1015c576df64e0676520bf6e150aa491.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b31db06b2dfa8da6ae97c5c49e0efc9.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b31db06b2dfa8da6ae97c5c49e0efc9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b3515f46bb6f9159faf77c8c0cbb2f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b3515f46bb6f9159faf77c8c0cbb2f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3457351f5689883379142f404f51e400.jpg\" _src=\"http://yanxuan.nosdn.127.net/3457351f5689883379142f404f51e400.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1b1e7315c2486cd112de7f9fc479012.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1b1e7315c2486cd112de7f9fc479012.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9afdd4bf281e983d5519feb39326a670.jpg\" _src=\"http://yanxuan.nosdn.127.net/9afdd4bf281e983d5519feb39326a670.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c178d019321a1573e54cd15e192177a.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c178d019321a1573e54cd15e192177a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/07073287b255e8a425369cdc893f5f20.jpg\" _src=\"http://yanxuan.nosdn.127.net/07073287b255e8a425369cdc893f5f20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/293d2a36e7185e7f66b896e25c2c8305.jpg\" _src=\"http://yanxuan.nosdn.127.net/293d2a36e7185e7f66b896e25c2c8305.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d80991ea2ce193d597e2eee242bc9a80.jpg\" _src=\"http://yanxuan.nosdn.127.net/d80991ea2ce193d597e2eee242bc9a80.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1e5e9936313a9c60240056405ee2ba04.jpg\" _src=\"http://yanxuan.nosdn.127.net/1e5e9936313a9c60240056405ee2ba04.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/72f3065c41af1565f7a532382fc79ef4.jpg\" _src=\"http://yanxuan.nosdn.127.net/72f3065c41af1565f7a532382fc79ef4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea7ed70f911913fcb0f9c82c0f7144d7.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea7ed70f911913fcb0f9c82c0f7144d7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d3c4a51893f1cab2790ef8bb415b874.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d3c4a51893f1cab2790ef8bb415b874.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9a102958c5c967148d2ddc829928e128.jpg\" _src=\"http://yanxuan.nosdn.127.net/9a102958c5c967148d2ddc829928e128.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eba4e71d802b4a643aa8d1b6f1ef538d.jpg\" _src=\"http://yanxuan.nosdn.127.net/eba4e71d802b4a643aa8d1b6f1ef538d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2bc8520fe40de2d7476fe1798080f28a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2bc8520fe40de2d7476fe1798080f28a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74cd885cd96572e9a130b128f9f67f06.jpg\" _src=\"http://yanxuan.nosdn.127.net/74cd885cd96572e9a130b128f9f67f06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/368eab0ae5725751b99059da17d1fe40.jpg\" _src=\"http://yanxuan.nosdn.127.net/368eab0ae5725751b99059da17d1fe40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0b19f0579e1e6a83137aac04731b897.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0b19f0579e1e6a83137aac04731b897.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0ae42c7dc053d8fe3ec9f3c55dfbd775.jpg\" _src=\"http://yanxuan.nosdn.127.net/0ae42c7dc053d8fe3ec9f3c55dfbd775.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1e422c2778e752789c04187cd021f41.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1e422c2778e752789c04187cd021f41.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ea2a040b902d957500aa9b34a46c9ab6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ea2a040b902d957500aa9b34a46c9ab6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5761b8ff0a8585edef490a4d4ac301ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/5761b8ff0a8585edef490a4d4ac301ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/839c1f5686172cf0412e5d3eaba8a82c.jpg\" _src=\"http://yanxuan.nosdn.127.net/839c1f5686172cf0412e5d3eaba8a82c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3985040baac585a6f0934e2b05e2e6ff.jpg\" _src=\"http://yanxuan.nosdn.127.net/3985040baac585a6f0934e2b05e2e6ff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/014628292ae6101a20bbb92866b63f25.jpg\" _src=\"http://yanxuan.nosdn.127.net/014628292ae6101a20bbb92866b63f25.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8347e039b379c389b74789fe0f50b7d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/8347e039b379c389b74789fe0f50b7d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a11a6cc14c6c289b329e186b92009e25.jpg\" _src=\"http://yanxuan.nosdn.127.net/a11a6cc14c6c289b329e186b92009e25.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3f2434dfe4be243056e58123eee6a7d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3f2434dfe4be243056e58123eee6a7d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/774f19c00df4da1e0c7909add91a1370.jpg\" _src=\"http://yanxuan.nosdn.127.net/774f19c00df4da1e0c7909add91a1370.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e69dfd820c7abf9825fb94ebce881244.jpg\" _src=\"http://yanxuan.nosdn.127.net/e69dfd820c7abf9825fb94ebce881244.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7ec56aeda2b7ab12758e7d1c7806cc4.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7ec56aeda2b7ab12758e7d1c7806cc4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5a537ccc12aed9a406c392a7d862cb1e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5a537ccc12aed9a406c392a7d862cb1e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b14cfaad56ea13375db5996e8fd755f4.jpg\" _src=\"http://yanxuan.nosdn.127.net/b14cfaad56ea13375db5996e8fd755f4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1498337acf06675f75910ce5aa5aed94.jpg\" _src=\"http://yanxuan.nosdn.127.net/1498337acf06675f75910ce5aa5aed94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/874ffbe6adf9a5441434ff9f6a6f18f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/874ffbe6adf9a5441434ff9f6a6f18f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00750da19e23f4503a15186b49426093.jpg\" _src=\"http://yanxuan.nosdn.127.net/00750da19e23f4503a15186b49426093.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a9d2b56d241ce7bed1995e1eff43c376.jpg\" _src=\"http://yanxuan.nosdn.127.net/a9d2b56d241ce7bed1995e1eff43c376.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f36cf5f4dd5285d52d5e3d00356dc67.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f36cf5f4dd5285d52d5e3d00356dc67.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b90d5200ab88c58ffedd0674202163e.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b90d5200ab88c58ffedd0674202163e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0654bc2c783d15611855a7785b119650.jpg\" _src=\"http://yanxuan.nosdn.127.net/0654bc2c783d15611855a7785b119650.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8858b07274e515c941876822ed90ed24.jpg\" _src=\"http://yanxuan.nosdn.127.net/8858b07274e515c941876822ed90ed24.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/819a3d7d46c9de4def544dc901cda509.jpg\" _src=\"http://yanxuan.nosdn.127.net/819a3d7d46c9de4def544dc901cda509.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a48c7640b69a38257223bb54e9222bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a48c7640b69a38257223bb54e9222bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bd5f7266799709dc96e3d9336b565171.jpg\" _src=\"http://yanxuan.nosdn.127.net/bd5f7266799709dc96e3d9336b565171.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '13', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/66823c76c19696e1c6418d833dfd274f.jpg', 'http://yanxuan.nosdn.127.net/1e7e392b6fc9da99dc112197b7444eec.png', '69.00', '107', '1111089', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1111007', '1008015', '1111007', '妙曲奇遇记曲奇礼盒 520克', '0', '100', '', '六种口味，酥香脆爽', '', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/b5b25363daed8cc56f8b455564538fd5.png', 'http://yanxuan.nosdn.127.net/8d228f767b136a67aaf2cbbf6deb46fa.png', '78.00', '2073', '1112010', '0.00', '限时购', '', '0.00', '0', '0', '0', '85.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1111010', '1008001', '1111010', '静谧森林简欧色织提花面巾', '0', '100', '', '静谧神秘，亲肤耐用', '', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4eeea55e7c6a0cf15c8a9574dcfa5e1d.jpg', 'http://yanxuan.nosdn.127.net/ef7efe55839e66993fb604dc3c2d9410.png', '69.00', '5514', '1112013', '0.00', '限时购', '', '0.00', '0', '0', '0', '75.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1113010', '1010002', '1113010', '男式丝滑莫代尔平角内裤', '0', '100', '', 'Jockey供应商，亲肤贴合', '', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/e1fa80ecf411c0740927cebbe6546920.png', 'http://yanxuan.nosdn.127.net/2d0920b51331bb1636330ad8e07d1b97.png', '59.00', '52589', '1114017', '0.00', '限时购', '', '0.00', '0', '0', '0', '64.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1113011', '1010002', '1113011', '女式丝滑莫代尔三角内裤', '0', '100', '', 'Jockey工厂，顺滑爽肤', '', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/4788f548071f24219faf943b1fb28a79.png', 'http://yanxuan.nosdn.127.net/7a683f68fc988df299b5cfe6273d6fb7.png', '49.00', '23282', '1114040', '0.00', '限时购', '', '0.00', '0', '0', '0', '53.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1113019', '1012001', '1113019', '20寸 PC膜拉链登机箱', '0', '100', '', '热卖9万只，网易人手1只', '', '1', '2017-08-30 11:40:11', '1', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/2687b2a39cd77cf184cf387dc4cbb6af.png', 'http://yanxuan.nosdn.127.net/ad504bb389039ff35c4cd6ae912be87e.png', '208.00', '63669', '1114089', '0.00', '限时购', '', '0.00', '0', '0', '0', '228.80', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1114011', '1012001', '1114011', '104升 纯PC拉链斜纹拉杆箱', '0', '100', '', '104升的体积，90升的价格', '', '1', '2017-08-30 11:40:11', '5', '0', '0', '369.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/7e622b47c4d28dc5e7f97be57ba17b84.png', 'http://yanxuan.nosdn.127.net/196b5ce11930b4eadaec563cb0406634.png', '299.00', '4719', '1115089', '0.00', '三石福利价', '三石福利价', '0.00', '0', '203', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1115023', '1008008', '1115023', '新年礼盒 双宫茧纱布美肤手工蚕丝被', '0', '100', '', '手工匠心织造', '<p><img src=\"http://yanxuan.nosdn.127.net/4c43f2c47b3c9add17fae31e7fe26a13.jpg\" _src=\"http://yanxuan.nosdn.127.net/4c43f2c47b3c9add17fae31e7fe26a13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dde334e64507ecb2020bece8632256ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/dde334e64507ecb2020bece8632256ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d0ac4805b5cbba2c99494aaa095b96c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d0ac4805b5cbba2c99494aaa095b96c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a4b7fade54796fac479d3512632f53c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a4b7fade54796fac479d3512632f53c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c1b9410c37aa278b27b1c1c9d688332.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c1b9410c37aa278b27b1c1c9d688332.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/69027eeafd9ce6f9c28f8e9eacccac1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/69027eeafd9ce6f9c28f8e9eacccac1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/17945f8075ec3d09cc9b3b45c1b23954.jpg\" _src=\"http://yanxuan.nosdn.127.net/17945f8075ec3d09cc9b3b45c1b23954.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdcc84a9987078f47428bc9802f52a71.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdcc84a9987078f47428bc9802f52a71.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/454b63ab7133ec9fea35b8b09e823922.jpg\" _src=\"http://yanxuan.nosdn.127.net/454b63ab7133ec9fea35b8b09e823922.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/217f38b044ca468b5078114b18bffdf1.jpg\" _src=\"http://yanxuan.nosdn.127.net/217f38b044ca468b5078114b18bffdf1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eaa60f902992461dacdd7e941afd6ce1.jpg\" _src=\"http://yanxuan.nosdn.127.net/eaa60f902992461dacdd7e941afd6ce1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ed15f21fffb449f371059235876e382.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ed15f21fffb449f371059235876e382.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/686e234a86c089de50d3e25aa9ad9bdf.jpg\" _src=\"http://yanxuan.nosdn.127.net/686e234a86c089de50d3e25aa9ad9bdf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1c5876107596920d047902bc20512f87.jpg\" _src=\"http://yanxuan.nosdn.127.net/1c5876107596920d047902bc20512f87.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/13f310f8a94423864b3c927dbae63dd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/13f310f8a94423864b3c927dbae63dd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2ddc5e7c65eb108c0963399a577d027.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2ddc5e7c65eb108c0963399a577d027.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c805b24ed55349a58d0fb9cf5d6c261f.jpg\" _src=\"http://yanxuan.nosdn.127.net/c805b24ed55349a58d0fb9cf5d6c261f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a230022fb66841c03150cf3fe89c818e.jpg\" _src=\"http://yanxuan.nosdn.127.net/a230022fb66841c03150cf3fe89c818e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40f1ce851c58791fcae3caae74c8f0d0.jpg\" _src=\"http://yanxuan.nosdn.127.net/40f1ce851c58791fcae3caae74c8f0d0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df61ff302af83280e8e2c36c4e80a393.jpg\" _src=\"http://yanxuan.nosdn.127.net/df61ff302af83280e8e2c36c4e80a393.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1672e49a265eac0d2fb319e7f5088ff0.jpg\" _src=\"http://yanxuan.nosdn.127.net/1672e49a265eac0d2fb319e7f5088ff0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b444408fbe681615abfb77bbe6e516df.jpg\" _src=\"http://yanxuan.nosdn.127.net/b444408fbe681615abfb77bbe6e516df.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a0debfd075ce1c7894c4a992fa4b00eb.jpg\" _src=\"http://yanxuan.nosdn.127.net/a0debfd075ce1c7894c4a992fa4b00eb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00b4174990e426b43dcddc69716833e9.jpg\" _src=\"http://yanxuan.nosdn.127.net/00b4174990e426b43dcddc69716833e9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ec68bbed4061fb2b49ff26f5e3a204f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ec68bbed4061fb2b49ff26f5e3a204f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f65623230b18f1040bc42ab410cebea.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f65623230b18f1040bc42ab410cebea.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/12c57280d771639226579355e3508225.jpg\" _src=\"http://yanxuan.nosdn.127.net/12c57280d771639226579355e3508225.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94f0d4b78a6e055a3bc933b38cde4676.jpg\" _src=\"http://yanxuan.nosdn.127.net/94f0d4b78a6e055a3bc933b38cde4676.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/377023664a1ecc7ae02de53a4c393493.jpg\" _src=\"http://yanxuan.nosdn.127.net/377023664a1ecc7ae02de53a4c393493.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94bbae92dc9bc96cc262201c28443354.jpg\" _src=\"http://yanxuan.nosdn.127.net/94bbae92dc9bc96cc262201c28443354.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/59fbd18f4669bc5dd44a6dcce78a592d.jpg\" _src=\"http://yanxuan.nosdn.127.net/59fbd18f4669bc5dd44a6dcce78a592d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99794ca0ea180fa5b61c6e8e9652234a.jpg\" _src=\"http://yanxuan.nosdn.127.net/99794ca0ea180fa5b61c6e8e9652234a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c263493b621abf732f0f471b0f863f94.jpg\" _src=\"http://yanxuan.nosdn.127.net/c263493b621abf732f0f471b0f863f94.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9e765a0f7f98ed029e50d82e5031c525.jpg\" _src=\"http://yanxuan.nosdn.127.net/9e765a0f7f98ed029e50d82e5031c525.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02224d48e5035a0927979e91003514d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/02224d48e5035a0927979e91003514d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6dd2913a65cdf895816c4d131b1fcc1b.jpg\" _src=\"http://yanxuan.nosdn.127.net/6dd2913a65cdf895816c4d131b1fcc1b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46d2edf60200fee3c56bcc1b2e67d5d9.jpg\" _src=\"http://yanxuan.nosdn.127.net/46d2edf60200fee3c56bcc1b2e67d5d9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/42fb7948dd89a4563c365fb75c35fc5c.jpg\" _src=\"http://yanxuan.nosdn.127.net/42fb7948dd89a4563c365fb75c35fc5c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44ecec55301bac953355e425b833c4b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/44ecec55301bac953355e425b833c4b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdc9c3ef74e64d5992f382e9e10f5147.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdc9c3ef74e64d5992f382e9e10f5147.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57145f6ce36ba8be808db121b29508e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/57145f6ce36ba8be808db121b29508e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/995ed62fb2f43ba14026b33f592dfbd8.jpg\" _src=\"http://yanxuan.nosdn.127.net/995ed62fb2f43ba14026b33f592dfbd8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b4c9fa91ce933a10e0961c462e991d8.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b4c9fa91ce933a10e0961c462e991d8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f597f53ff837012a84c70f607478bb4.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f597f53ff837012a84c70f607478bb4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/82987ce707f21ec0e3855d365e2ffc38.jpg\" _src=\"http://yanxuan.nosdn.127.net/82987ce707f21ec0e3855d365e2ffc38.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e1ca5c866a9f1035c1f220a2df9ef989.jpg\" _src=\"http://yanxuan.nosdn.127.net/e1ca5c866a9f1035c1f220a2df9ef989.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/028a65df8b5cd56e2f02a13d210652b5.jpg\" _src=\"http://yanxuan.nosdn.127.net/028a65df8b5cd56e2f02a13d210652b5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/683072f00fa3a3a8fb656d239a941da2.jpg\" _src=\"http://yanxuan.nosdn.127.net/683072f00fa3a3a8fb656d239a941da2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b087f76096d58c93035cb9a5252e242d.jpg\" _src=\"http://yanxuan.nosdn.127.net/b087f76096d58c93035cb9a5252e242d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5dc6c83e63cda0b42ccdd796f101703e.jpg\" _src=\"http://yanxuan.nosdn.127.net/5dc6c83e63cda0b42ccdd796f101703e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5166cd7c4f2083b5c7ef9c0e2fe39bff.jpg\" _src=\"http://yanxuan.nosdn.127.net/5166cd7c4f2083b5c7ef9c0e2fe39bff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c37c9000c45935834f7102ddd438ba60.jpg\" _src=\"http://yanxuan.nosdn.127.net/c37c9000c45935834f7102ddd438ba60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e6639ec9703eba5814155ee2adb3358.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e6639ec9703eba5814155ee2adb3358.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bb6879fa88e498a12b7ebdc3109b5c3b.jpg\" _src=\"http://yanxuan.nosdn.127.net/bb6879fa88e498a12b7ebdc3109b5c3b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d91b86efaabd244e1cfecf75033511f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/d91b86efaabd244e1cfecf75033511f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/217cbc83a7fab144b45a191e08dffdc1.jpg\" _src=\"http://yanxuan.nosdn.127.net/217cbc83a7fab144b45a191e08dffdc1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e65816dcd382d520dcd54fd7a17b242d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e65816dcd382d520dcd54fd7a17b242d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dc47abd7279a420920aceda815321575.jpg\" _src=\"http://yanxuan.nosdn.127.net/dc47abd7279a420920aceda815321575.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/66c4dd6abb1a48d315c621a1c0d921bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/66c4dd6abb1a48d315c621a1c0d921bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b7300878dca46c3bcdb6149af3ad348.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b7300878dca46c3bcdb6149af3ad348.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c5c40a9f499e5ade62e2e29daade5d08.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5c40a9f499e5ade62e2e29daade5d08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fb9f8961bcda56e9820c4145b52c14f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/fb9f8961bcda56e9820c4145b52c14f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0b2e8fc816ab6f9436e2f2aa31b479c.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0b2e8fc816ab6f9436e2f2aa31b479c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3261f979d8f60c3dc3b2fbf445a9b2ce.jpg\" _src=\"http://yanxuan.nosdn.127.net/3261f979d8f60c3dc3b2fbf445a9b2ce.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/44bbc9ca537c22ecbb2a70e4f33ce951.jpg\" _src=\"http://yanxuan.nosdn.127.net/44bbc9ca537c22ecbb2a70e4f33ce951.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/31231ed6c10173f61fa7557a62dadb0c.jpg\" _src=\"http://yanxuan.nosdn.127.net/31231ed6c10173f61fa7557a62dadb0c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd654bed4757dca27da1e22795004a81.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd654bed4757dca27da1e22795004a81.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6441397fb853ce2f84bb14a057b757c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/6441397fb853ce2f84bb14a057b757c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4781f226a98fd5cd7b9495f1fc7b360.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4781f226a98fd5cd7b9495f1fc7b360.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ae422e9f55e752cff9482178ea066280.jpg\" _src=\"http://yanxuan.nosdn.127.net/ae422e9f55e752cff9482178ea066280.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '13', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a1492979beb737bd745dab27cadfb677.jpg', 'http://yanxuan.nosdn.127.net/f3d1f0217ed250a37ea807f456351a51.png', '1599.00', '133', '1116045', '0.00', '限时购', '', '0.00', '0', '0', '0', '1758.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1115028', '1008009', '1115028', '日式色织水洗棉条纹四件套', '1001000', '100', '', '纯棉水洗感，柔软吸汗', '<p><img src=\"http://yanxuan.nosdn.127.net/c7a4904d00fec84dcb8d024acf9c9124.jpg\" _src=\"http://yanxuan.nosdn.127.net/c7a4904d00fec84dcb8d024acf9c9124.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1ca8260a0e668703f99b76d2b5febe39.jpg\" _src=\"http://yanxuan.nosdn.127.net/1ca8260a0e668703f99b76d2b5febe39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1a8001ac179af2b6a9710754ab3be0a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/1a8001ac179af2b6a9710754ab3be0a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4565564e3359df7c1bfa3ad75d482fff.jpg\" _src=\"http://yanxuan.nosdn.127.net/4565564e3359df7c1bfa3ad75d482fff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dd7ace2c6a2c4324ef5e1f9355e89268.jpg\" _src=\"http://yanxuan.nosdn.127.net/dd7ace2c6a2c4324ef5e1f9355e89268.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cb9241fa90a48c6f9820785c728d2bff.jpg\" _src=\"http://yanxuan.nosdn.127.net/cb9241fa90a48c6f9820785c728d2bff.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8fae72fff469beacc683209a4514a41f.jpg\" _src=\"http://yanxuan.nosdn.127.net/8fae72fff469beacc683209a4514a41f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/395d99acde8e480bde8dc765ac1eb580.jpg\" _src=\"http://yanxuan.nosdn.127.net/395d99acde8e480bde8dc765ac1eb580.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3f5a5bc28c4db2fffc72228668a09534.jpg\" _src=\"http://yanxuan.nosdn.127.net/3f5a5bc28c4db2fffc72228668a09534.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/849c44ecb9149dbe4186fd2a7176c2b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/849c44ecb9149dbe4186fd2a7176c2b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85c02b7f73716798a07078ca99a84dcc.jpg\" _src=\"http://yanxuan.nosdn.127.net/85c02b7f73716798a07078ca99a84dcc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/02e8ed22c5110a71db1bbe3ea911246d.jpg\" _src=\"http://yanxuan.nosdn.127.net/02e8ed22c5110a71db1bbe3ea911246d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3d668a817a0c0fbf2c550fb2732e3278.jpg\" _src=\"http://yanxuan.nosdn.127.net/3d668a817a0c0fbf2c550fb2732e3278.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7504ed0982387d5837de6f146aeae2a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/7504ed0982387d5837de6f146aeae2a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5825013e93079cd9389a1a85db9ea986.jpg\" _src=\"http://yanxuan.nosdn.127.net/5825013e93079cd9389a1a85db9ea986.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c9895d59d2ce2c2f05b7d7d342edf8b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/c9895d59d2ce2c2f05b7d7d342edf8b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/85c29c4c8fb2db231665bcbf2322671d.jpg\" _src=\"http://yanxuan.nosdn.127.net/85c29c4c8fb2db231665bcbf2322671d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/57615e82ddcb6f5b4eb1239d3948d8fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/57615e82ddcb6f5b4eb1239d3948d8fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/518b4a422d10e1075a76bb79232391e6.jpg\" _src=\"http://yanxuan.nosdn.127.net/518b4a422d10e1075a76bb79232391e6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d5928965b398160fdfef1a1a826bac75.jpg\" _src=\"http://yanxuan.nosdn.127.net/d5928965b398160fdfef1a1a826bac75.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6271c3f5120f19b42bb913e6945cbf95.jpg\" _src=\"http://yanxuan.nosdn.127.net/6271c3f5120f19b42bb913e6945cbf95.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/674aee6d3a58fb51551f6766689bc7ab.jpg\" _src=\"http://yanxuan.nosdn.127.net/674aee6d3a58fb51551f6766689bc7ab.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/29f78e78e62742cff9b760a9b97e4347.jpg\" _src=\"http://yanxuan.nosdn.127.net/29f78e78e62742cff9b760a9b97e4347.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/755ac0784730b54dc44fc2a3fc97d941.jpg\" _src=\"http://yanxuan.nosdn.127.net/755ac0784730b54dc44fc2a3fc97d941.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b0cd4cc9a627be11362be64fa4bcbf06.jpg\" _src=\"http://yanxuan.nosdn.127.net/b0cd4cc9a627be11362be64fa4bcbf06.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3205cd14570da7022b1943da198763f0.jpg\" _src=\"http://yanxuan.nosdn.127.net/3205cd14570da7022b1943da198763f0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f263b42fc5808f4de777410befd094cb.jpg\" _src=\"http://yanxuan.nosdn.127.net/f263b42fc5808f4de777410befd094cb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/93d0a8bea9bd2f52941628dff09ef381.jpg\" _src=\"http://yanxuan.nosdn.127.net/93d0a8bea9bd2f52941628dff09ef381.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97e43d6548d7215956380ffd0c5a1810.jpg\" _src=\"http://yanxuan.nosdn.127.net/97e43d6548d7215956380ffd0c5a1810.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e3e8b023e2dbf472c8889456c00cf9be.jpg\" _src=\"http://yanxuan.nosdn.127.net/e3e8b023e2dbf472c8889456c00cf9be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/158be4bab49629d527bd8e27e55c77d1.jpg\" _src=\"http://yanxuan.nosdn.127.net/158be4bab49629d527bd8e27e55c77d1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d345c8615953a60a424e5a47c0cd16a.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d345c8615953a60a424e5a47c0cd16a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff89423e056191c2d4a12196b900d7f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff89423e056191c2d4a12196b900d7f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e953286fce6c89f74ce7150f2f478d64.jpg\" _src=\"http://yanxuan.nosdn.127.net/e953286fce6c89f74ce7150f2f478d64.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ff0d95c718fe73cd66dff1de8a43d7a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/ff0d95c718fe73cd66dff1de8a43d7a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c2009a46185b6bd5463528971ef2c2af.jpg\" _src=\"http://yanxuan.nosdn.127.net/c2009a46185b6bd5463528971ef2c2af.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f08bae55ef68af811f57ff105ec5ec3f.jpg\" _src=\"http://yanxuan.nosdn.127.net/f08bae55ef68af811f57ff105ec5ec3f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/84ac737dabdb85482f2ce39df119c753.jpg\" _src=\"http://yanxuan.nosdn.127.net/84ac737dabdb85482f2ce39df119c753.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc95259418359a519d7f604af79d6f19.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc95259418359a519d7f604af79d6f19.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9b673c4829dceec9488b5bddacc3ae7c.jpg\" _src=\"http://yanxuan.nosdn.127.net/9b673c4829dceec9488b5bddacc3ae7c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/da72e531c1bc3bba73d61456396dcaba.jpg\" _src=\"http://yanxuan.nosdn.127.net/da72e531c1bc3bba73d61456396dcaba.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10e489150f5b12c3fed27560df0cb391.jpg\" _src=\"http://yanxuan.nosdn.127.net/10e489150f5b12c3fed27560df0cb391.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc42020bc2b630c1be212b734bf70e53.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc42020bc2b630c1be212b734bf70e53.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f27be3e26b925f26d81e5f90b12cd1cf.jpg\" _src=\"http://yanxuan.nosdn.127.net/f27be3e26b925f26d81e5f90b12cd1cf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/33e9cfb394b44658be3ab3fbae977638.jpg\" _src=\"http://yanxuan.nosdn.127.net/33e9cfb394b44658be3ab3fbae977638.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/008e03c492bf5b1cf9a3b94c525e3920.jpg\" _src=\"http://yanxuan.nosdn.127.net/008e03c492bf5b1cf9a3b94c525e3920.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e4bc8cbbb6b937bb0b122649a4560e1c.jpg\" _src=\"http://yanxuan.nosdn.127.net/e4bc8cbbb6b937bb0b122649a4560e1c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbee4d90772a3e0c40811de3fd2cfdea.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbee4d90772a3e0c40811de3fd2cfdea.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/34ce3734403b04de2a027206237aad6f.jpg', 'http://yanxuan.nosdn.127.net/3d0045e8f43439c7004fae052b2162ed.png', '299.00', '4440', '1116061', '0.00', '限时购', '', '0.00', '0', '0', '0', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1115052', '1008002', '1115052', '日式和风蔺草蒲团坐垫', '0', '100', '', '龙眉蔺草编织 日式茶禅风', '<p><img src=\"http://yanxuan.nosdn.127.net/c5c39ed4982045a32efde6f8e4b3d327.jpg\" _src=\"http://yanxuan.nosdn.127.net/c5c39ed4982045a32efde6f8e4b3d327.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/385b1a317b993c403f5b1532bf714592.jpg\" _src=\"http://yanxuan.nosdn.127.net/385b1a317b993c403f5b1532bf714592.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/97c44d5c2411a2b8bb39ee34957783bc.jpg\" _src=\"http://yanxuan.nosdn.127.net/97c44d5c2411a2b8bb39ee34957783bc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/489a326e13a5bb3ce44a40fc71ccbc40.jpg\" _src=\"http://yanxuan.nosdn.127.net/489a326e13a5bb3ce44a40fc71ccbc40.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2d6eb8e6ba1de0db4bdc1d4ef8d124d.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2d6eb8e6ba1de0db4bdc1d4ef8d124d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5e723ef50260b98666955796f6dab4c4.jpg\" _src=\"http://yanxuan.nosdn.127.net/5e723ef50260b98666955796f6dab4c4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3cd9585a68c6b746f509408c2c16783a.jpg\" _src=\"http://yanxuan.nosdn.127.net/3cd9585a68c6b746f509408c2c16783a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/582bdb6e01ad3b8f2d76d0124dfdcf8e.jpg\" _src=\"http://yanxuan.nosdn.127.net/582bdb6e01ad3b8f2d76d0124dfdcf8e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8dd281a87afd1ae88dc05e1db35142a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/8dd281a87afd1ae88dc05e1db35142a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73a608d337ac09b75b4bd14d8170b6d6.jpg\" _src=\"http://yanxuan.nosdn.127.net/73a608d337ac09b75b4bd14d8170b6d6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fdc10bae153b0dda81dd53b57c2b9e10.jpg\" _src=\"http://yanxuan.nosdn.127.net/fdc10bae153b0dda81dd53b57c2b9e10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cccdb8b1831f0b70306a4b4eed8859db.jpg\" _src=\"http://yanxuan.nosdn.127.net/cccdb8b1831f0b70306a4b4eed8859db.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5baf78b4175b0fdb0132b5d83bb7e279.jpg\" _src=\"http://yanxuan.nosdn.127.net/5baf78b4175b0fdb0132b5d83bb7e279.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e613832e2b3e0cfcad1c42e6cf3d6d3e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e613832e2b3e0cfcad1c42e6cf3d6d3e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de9c7cedfd555ceb5adfed1c0c96b9b4.jpg\" _src=\"http://yanxuan.nosdn.127.net/de9c7cedfd555ceb5adfed1c0c96b9b4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/61a0ecae290671c15ac857e0f5b8fb5f.jpg\" _src=\"http://yanxuan.nosdn.127.net/61a0ecae290671c15ac857e0f5b8fb5f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8f15359576d133d55457f69c05aeab8.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8f15359576d133d55457f69c05aeab8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aae2ff89028e265b06656aa63a94c58e.jpg\" _src=\"http://yanxuan.nosdn.127.net/aae2ff89028e265b06656aa63a94c58e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dbecb94e2a020007505cad42c4e8553a.jpg\" _src=\"http://yanxuan.nosdn.127.net/dbecb94e2a020007505cad42c4e8553a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4adb8529010d4348b90cdc445f37d241.jpg\" _src=\"http://yanxuan.nosdn.127.net/4adb8529010d4348b90cdc445f37d241.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/953207acdb90210c681deb18b59fdadb.jpg\" _src=\"http://yanxuan.nosdn.127.net/953207acdb90210c681deb18b59fdadb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fa5b73dea7f39614c01de4ee8acdc216.jpg\" _src=\"http://yanxuan.nosdn.127.net/fa5b73dea7f39614c01de4ee8acdc216.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2b7ccd3a548618f2fadb20aee9ab9531.jpg\" _src=\"http://yanxuan.nosdn.127.net/2b7ccd3a548618f2fadb20aee9ab9531.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ecde950588789c70df2222f1ded0f579.jpg\" _src=\"http://yanxuan.nosdn.127.net/ecde950588789c70df2222f1ded0f579.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/597505ee5976bf7f68646ef2321c5b39.jpg\" _src=\"http://yanxuan.nosdn.127.net/597505ee5976bf7f68646ef2321c5b39.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f317d788383403a224a191452183b9f.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f317d788383403a224a191452183b9f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9ca568894e24f4aa5d6eaf4174667ffa.jpg\" _src=\"http://yanxuan.nosdn.127.net/9ca568894e24f4aa5d6eaf4174667ffa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bdbf86365486d602bc2c2b1aa4bd8781.jpg\" _src=\"http://yanxuan.nosdn.127.net/bdbf86365486d602bc2c2b1aa4bd8781.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aa9db3d211c93fa9d2914754464e679c.jpg\" _src=\"http://yanxuan.nosdn.127.net/aa9db3d211c93fa9d2914754464e679c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58e5cd852682d404200f57471e883485.jpg\" _src=\"http://yanxuan.nosdn.127.net/58e5cd852682d404200f57471e883485.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14cc6189a160dcf8f0d2f0d0bd0b7f27.jpg\" _src=\"http://yanxuan.nosdn.127.net/14cc6189a160dcf8f0d2f0d0bd0b7f27.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c49b33afea38804de07fc9a6bb80dda9.jpg\" _src=\"http://yanxuan.nosdn.127.net/c49b33afea38804de07fc9a6bb80dda9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8cf4bc3c1b476cba2ec6290b02c698be.jpg\" _src=\"http://yanxuan.nosdn.127.net/8cf4bc3c1b476cba2ec6290b02c698be.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c3d5eb1291c79204e2e23dede15b8cac.jpg\" _src=\"http://yanxuan.nosdn.127.net/c3d5eb1291c79204e2e23dede15b8cac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/38791f147ef4ee52bfee5e240f2a5f52.jpg\" _src=\"http://yanxuan.nosdn.127.net/38791f147ef4ee52bfee5e240f2a5f52.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9756648996576857cabe3740da2edaa6.jpg\" _src=\"http://yanxuan.nosdn.127.net/9756648996576857cabe3740da2edaa6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f4247a5ccb0f39be52a8c99cb15f92f7.jpg\" _src=\"http://yanxuan.nosdn.127.net/f4247a5ccb0f39be52a8c99cb15f92f7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40d0ceae7b2300246501b72540727505.jpg\" _src=\"http://yanxuan.nosdn.127.net/40d0ceae7b2300246501b72540727505.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14603e5d6e54d7e1abaae04ea713de08.jpg\" _src=\"http://yanxuan.nosdn.127.net/14603e5d6e54d7e1abaae04ea713de08.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/06d66618b49e447645e3650dc6cb11ca.jpg\" _src=\"http://yanxuan.nosdn.127.net/06d66618b49e447645e3650dc6cb11ca.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5ef12ad1adb0d16743a0054489846a13.jpg\" _src=\"http://yanxuan.nosdn.127.net/5ef12ad1adb0d16743a0054489846a13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/99d648a6665d2a25f790a469c464d34b.jpg\" _src=\"http://yanxuan.nosdn.127.net/99d648a6665d2a25f790a469c464d34b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/76e121103fb90fdf267eb204af59c0d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/76e121103fb90fdf267eb204af59c0d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9d92a1874c26534262643772dbdef1d2.jpg\" _src=\"http://yanxuan.nosdn.127.net/9d92a1874c26534262643772dbdef1d2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cb04ad36ddc0b45066f8233ab9cf888.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cb04ad36ddc0b45066f8233ab9cf888.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cdb4947e9c035fea2bb271c9f0b43d2f.jpg\" _src=\"http://yanxuan.nosdn.127.net/cdb4947e9c035fea2bb271c9f0b43d2f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/55c1446b40d52e2da86f92fccc47ea2b.jpg\" _src=\"http://yanxuan.nosdn.127.net/55c1446b40d52e2da86f92fccc47ea2b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/339c0d5acef5c3029fd3c0d500883ce5.jpg\" _src=\"http://yanxuan.nosdn.127.net/339c0d5acef5c3029fd3c0d500883ce5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/11dc59302185026721eaa23509c333ee.jpg\" _src=\"http://yanxuan.nosdn.127.net/11dc59302185026721eaa23509c333ee.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81ed48a7099d3bfa9860fcdd4e546b60.jpg\" _src=\"http://yanxuan.nosdn.127.net/81ed48a7099d3bfa9860fcdd4e546b60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c615061f6c675ba67897e03e1f9cee17.jpg\" _src=\"http://yanxuan.nosdn.127.net/c615061f6c675ba67897e03e1f9cee17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e30a5c3df143363971c97e75f254818d.jpg\" _src=\"http://yanxuan.nosdn.127.net/e30a5c3df143363971c97e75f254818d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4b33a8b54250cf02206d1d9fa5674725.jpg\" _src=\"http://yanxuan.nosdn.127.net/4b33a8b54250cf02206d1d9fa5674725.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cf292ce53420b314368494c36b189ce1.jpg\" _src=\"http://yanxuan.nosdn.127.net/cf292ce53420b314368494c36b189ce1.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '18', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/66d736aa8e3e33e3c76a014e1379c9a9.jpg', 'http://yanxuan.nosdn.127.net/39dea35a3ea2361e4b054ee2f421af53.png', '86.00', '5586', '1116105', '0.00', '限时购', '', '0.00', '0', '0', '0', '94.60', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1115053', '1036000', '1115053', '日式天然蔺草席三件套', '0', '100', '', '龙眉蔺草密经编织 爽滑沁凉', '<p><img src=\"http://yanxuan.nosdn.127.net/1101093b92cac924e69bcefcf40c76e5.jpg\" _src=\"http://yanxuan.nosdn.127.net/1101093b92cac924e69bcefcf40c76e5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6776cd9b430fe30d4aabcd411c89c0dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/6776cd9b430fe30d4aabcd411c89c0dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bc7b58c7dfa8794786643b8287de29bf.jpg\" _src=\"http://yanxuan.nosdn.127.net/bc7b58c7dfa8794786643b8287de29bf.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c8c5738275ab840d6808329d00ceb350.jpg\" _src=\"http://yanxuan.nosdn.127.net/c8c5738275ab840d6808329d00ceb350.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4f5bc2cfc6ce9c430b1802f709ebf76c.jpg\" _src=\"http://yanxuan.nosdn.127.net/4f5bc2cfc6ce9c430b1802f709ebf76c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bca29c9e21a53dd795321efffb0812dd.jpg\" _src=\"http://yanxuan.nosdn.127.net/bca29c9e21a53dd795321efffb0812dd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48b5847777cc06af17803e296765fe8b.jpg\" _src=\"http://yanxuan.nosdn.127.net/48b5847777cc06af17803e296765fe8b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ac8105831478e9cef9ca6621fafc926.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ac8105831478e9cef9ca6621fafc926.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/74b08e41ac62e2b2ac4d4f5460e0df0e.jpg\" _src=\"http://yanxuan.nosdn.127.net/74b08e41ac62e2b2ac4d4f5460e0df0e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fd64fe69b33ae2aafe4f819a664685b.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fd64fe69b33ae2aafe4f819a664685b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/46fe74304568a5ce8e32d1273002aca8.jpg\" _src=\"http://yanxuan.nosdn.127.net/46fe74304568a5ce8e32d1273002aca8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7140b1208675fe3f4cdf88ea53433070.jpg\" _src=\"http://yanxuan.nosdn.127.net/7140b1208675fe3f4cdf88ea53433070.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/94689138ad6f93014e8590af7e247803.jpg\" _src=\"http://yanxuan.nosdn.127.net/94689138ad6f93014e8590af7e247803.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c86acaba2c5c058fffbbdc5e002fe95a.jpg\" _src=\"http://yanxuan.nosdn.127.net/c86acaba2c5c058fffbbdc5e002fe95a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd42872bf6525ad08c534a5badaf4b66.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd42872bf6525ad08c534a5badaf4b66.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/756c2e86e4f0ce987d376374614a8913.jpg\" _src=\"http://yanxuan.nosdn.127.net/756c2e86e4f0ce987d376374614a8913.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/81686652f491aa2bf8e3e6350a6da81a.jpg\" _src=\"http://yanxuan.nosdn.127.net/81686652f491aa2bf8e3e6350a6da81a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee7c88390c08dd2bfe4cba481ab9a41e.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee7c88390c08dd2bfe4cba481ab9a41e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b8339919fcd6f1287c0403390fc5c6b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/b8339919fcd6f1287c0403390fc5c6b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7d0f30eaf2b59c891275f0227c090db4.jpg\" _src=\"http://yanxuan.nosdn.127.net/7d0f30eaf2b59c891275f0227c090db4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3468d31e225a394811dc5dc7dbfe0982.jpg\" _src=\"http://yanxuan.nosdn.127.net/3468d31e225a394811dc5dc7dbfe0982.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00b9c24ff917bd437d1f4d1ece0d6629.jpg\" _src=\"http://yanxuan.nosdn.127.net/00b9c24ff917bd437d1f4d1ece0d6629.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2a81e7940224cdb166250e719584f72.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2a81e7940224cdb166250e719584f72.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac0b69a3422113c220e8e3cbc442a1f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac0b69a3422113c220e8e3cbc442a1f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c95c80f7e6d87f29902c08f1c60ac738.jpg\" _src=\"http://yanxuan.nosdn.127.net/c95c80f7e6d87f29902c08f1c60ac738.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/631ee88cd7236f84b0b98c73d50796fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/631ee88cd7236f84b0b98c73d50796fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cede72de2ecc4b359eb8854fc6508517.jpg\" _src=\"http://yanxuan.nosdn.127.net/cede72de2ecc4b359eb8854fc6508517.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6611f225c11ec3bea660dcc578465651.jpg\" _src=\"http://yanxuan.nosdn.127.net/6611f225c11ec3bea660dcc578465651.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2e5c23264a8f4a50300b0dd5d8fd94f.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2e5c23264a8f4a50300b0dd5d8fd94f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ee98563912792d365ab59650dfaea696.jpg\" _src=\"http://yanxuan.nosdn.127.net/ee98563912792d365ab59650dfaea696.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a50d584c6047756a5af6b62846842741.jpg\" _src=\"http://yanxuan.nosdn.127.net/a50d584c6047756a5af6b62846842741.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a175dd64f5674e734daa9a6bc9735955.jpg\" _src=\"http://yanxuan.nosdn.127.net/a175dd64f5674e734daa9a6bc9735955.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7aace408f3eeb3243d6afe6c6a7b296c.jpg\" _src=\"http://yanxuan.nosdn.127.net/7aace408f3eeb3243d6afe6c6a7b296c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/90ac2e08bc3f730bb95539f53b2bb20e.jpg\" _src=\"http://yanxuan.nosdn.127.net/90ac2e08bc3f730bb95539f53b2bb20e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8e390e497fd481f621ab539f209c0ae0.jpg\" _src=\"http://yanxuan.nosdn.127.net/8e390e497fd481f621ab539f209c0ae0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7b48987038ed6af0b8953549bd751990.jpg\" _src=\"http://yanxuan.nosdn.127.net/7b48987038ed6af0b8953549bd751990.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0eb6cb3a72b990b98e31440b663c2111.jpg\" _src=\"http://yanxuan.nosdn.127.net/0eb6cb3a72b990b98e31440b663c2111.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1df4c2d1c331ef6e100bb53b501e6d9d.jpg\" _src=\"http://yanxuan.nosdn.127.net/1df4c2d1c331ef6e100bb53b501e6d9d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1b690644dbb7167aebdb353d7d5a0928.jpg\" _src=\"http://yanxuan.nosdn.127.net/1b690644dbb7167aebdb353d7d5a0928.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/ac5acdb025c3a82113037c3357101827.jpg\" _src=\"http://yanxuan.nosdn.127.net/ac5acdb025c3a82113037c3357101827.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/890eb4575249e74dd8a06767a05b248d.jpg\" _src=\"http://yanxuan.nosdn.127.net/890eb4575249e74dd8a06767a05b248d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e479eff62a3907fa2aed7330a6640432.jpg\" _src=\"http://yanxuan.nosdn.127.net/e479eff62a3907fa2aed7330a6640432.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/129476d180036152278d9bf3001ec869.jpg\" _src=\"http://yanxuan.nosdn.127.net/129476d180036152278d9bf3001ec869.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a403b6ae33aa215095f9d7400f56f9c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/a403b6ae33aa215095f9d7400f56f9c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1985869d88e77119e45fcf09c18781ac.jpg\" _src=\"http://yanxuan.nosdn.127.net/1985869d88e77119e45fcf09c18781ac.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/40a54361f841fa9da9691949866e3eaa.jpg\" _src=\"http://yanxuan.nosdn.127.net/40a54361f841fa9da9691949866e3eaa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/53fe39319189dbf28392a965b836e896.jpg\" _src=\"http://yanxuan.nosdn.127.net/53fe39319189dbf28392a965b836e896.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/77d8c21cb8be3e393559e450efe8b65d.jpg\" _src=\"http://yanxuan.nosdn.127.net/77d8c21cb8be3e393559e450efe8b65d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/10f4168ff6c6557ad962db0a0464a16c.jpg\" _src=\"http://yanxuan.nosdn.127.net/10f4168ff6c6557ad962db0a0464a16c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/48d368fdee1649b11a650fcc8e6b386d.jpg\" _src=\"http://yanxuan.nosdn.127.net/48d368fdee1649b11a650fcc8e6b386d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4bb06f567d4c4c7491353a3d9ddae20c.jpg\" _src=\"http://yanxuan.nosdn.127.net/4bb06f567d4c4c7491353a3d9ddae20c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2e99a9027b337c789bc23aeb8b351c70.jpg\" _src=\"http://yanxuan.nosdn.127.net/2e99a9027b337c789bc23aeb8b351c70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4eb55207d6bf571fa254992984d2cd20.jpg\" _src=\"http://yanxuan.nosdn.127.net/4eb55207d6bf571fa254992984d2cd20.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbc0ffd84c8e782ef6f10a3231d00b60.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbc0ffd84c8e782ef6f10a3231d00b60.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c202d3f7a4b2342f0e5df9db4fc09cb3.jpg\" _src=\"http://yanxuan.nosdn.127.net/c202d3f7a4b2342f0e5df9db4fc09cb3.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '11', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/79190d038c3e40a015a086752450e890.jpg', 'http://yanxuan.nosdn.127.net/fabf9ac36751a2e1322135c56f1dc338.png', '299.00', '34', '1116107', '0.00', '限时购', '', '0.00', '0', '0', '1', '328.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116004', '1020003', '1116004', '条纹长袖海魂衫（男婴童）', '0', '100', '', 'A类一等品，无荧光承诺', '', '1', '2017-08-30 11:40:11', '6', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/69e2463f7fb6b606f29af9f2b85c9562.jpg', 'http://yanxuan.nosdn.127.net/14d3a47ccf52815baf6df308be6db5a6.png', '79.00', '4518', '1118018', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116005', '1020003', '1116005', '条纹长袖海魂衫（女婴童）', '0', '100', '', '纯棉亲肤娃娃衫', '', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/24db6b40ecc02d111f136918a3ee0e29.jpg', 'http://yanxuan.nosdn.127.net/71937456c3cd654f936f619201a79c09.png', '79.00', '998', '1118030', '0.00', '限时购', '', '0.00', '0', '0', '0', '86.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116008', '1020003', '1116008', '棉双层纱波点娃娃裙（婴童）', '0', '100', '', '波点娃娃裙搭配面包裤', '', '1', '2017-08-30 11:40:11', '9', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/1fafe089c873ba699797fe6a41f566bd.jpg', 'http://yanxuan.nosdn.127.net/149a09a391ea5a888debf50b9dc4ed7b.png', '99.00', '1565', '1118055', '0.00', '限时购', '', '0.00', '0', '0', '0', '108.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116011', '1008015', '1116011', '蔓越莓曲奇 200克', '0', '100', '', '酥脆奶香，甜酸回味', '', '1', '2017-08-30 11:40:11', '5', '0', '0', '0.00', '0.00', '1', '件', 'http://yanxuan.nosdn.127.net/1900349493220bfebcc67b2b6466e9f5.jpg', 'http://yanxuan.nosdn.127.net/767b370d07f3973500db54900bcbd2a7.png', '36.00', '664', '1118071', '0.00', '限时购', '', '0.00', '0', '0', '1', '39.60', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116030', '1011004', '1116030', '罗马假日 永生花', '0', '100', '', '黑粉的性感结合', '<p><img src=\"http://yanxuan.nosdn.127.net/52119891a3013b0bc5bb7acb96f27b09.jpg\" _src=\"http://yanxuan.nosdn.127.net/52119891a3013b0bc5bb7acb96f27b09.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7aad301c49e4b4ac31b6a5c2ff961084.jpg\" _src=\"http://yanxuan.nosdn.127.net/7aad301c49e4b4ac31b6a5c2ff961084.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/acda526adc6f8c69fe78629508a9ff83.jpg\" _src=\"http://yanxuan.nosdn.127.net/acda526adc6f8c69fe78629508a9ff83.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0ba77f8820b98d3d14b6288457e4ba6.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0ba77f8820b98d3d14b6288457e4ba6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/763516409d3720a57aef6130e6162bd7.jpg\" _src=\"http://yanxuan.nosdn.127.net/763516409d3720a57aef6130e6162bd7.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/1135909130ce5e577b3bfba553b765da.jpg\" _src=\"http://yanxuan.nosdn.127.net/1135909130ce5e577b3bfba553b765da.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/71b1a285d4b205679cff83d5a845e496.jpg\" _src=\"http://yanxuan.nosdn.127.net/71b1a285d4b205679cff83d5a845e496.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/262488c9a83012a73cb4cf2033ddcbd3.jpg\" _src=\"http://yanxuan.nosdn.127.net/262488c9a83012a73cb4cf2033ddcbd3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f28f2144fffc730d0fa1649f62d90e55.jpg\" _src=\"http://yanxuan.nosdn.127.net/f28f2144fffc730d0fa1649f62d90e55.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4617c511270ad4a83b4c43dea2a91ee6.jpg\" _src=\"http://yanxuan.nosdn.127.net/4617c511270ad4a83b4c43dea2a91ee6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d17cd0be9cfc4624fb058662fd898515.jpg\" _src=\"http://yanxuan.nosdn.127.net/d17cd0be9cfc4624fb058662fd898515.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/58a038c6be056de449bc79a8c102286f.jpg\" _src=\"http://yanxuan.nosdn.127.net/58a038c6be056de449bc79a8c102286f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78f6119baa644d598d6b5a35df27a0d4.jpg\" _src=\"http://yanxuan.nosdn.127.net/78f6119baa644d598d6b5a35df27a0d4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/47fa5da3b3f490f321fe86331ab10d6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/47fa5da3b3f490f321fe86331ab10d6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8ddaca5bbbbbf0b606764233b2282b25.jpg\" _src=\"http://yanxuan.nosdn.127.net/8ddaca5bbbbbf0b606764233b2282b25.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/eabab9779be18dae3ac805293d4216fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/eabab9779be18dae3ac805293d4216fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1890ad60a18c4f692aa192536a36c48.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1890ad60a18c4f692aa192536a36c48.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/00df2f6498b721ff0e7e2107787e37e1.jpg\" _src=\"http://yanxuan.nosdn.127.net/00df2f6498b721ff0e7e2107787e37e1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/6124ba09896786076cbdd12fb07c652c.jpg\" _src=\"http://yanxuan.nosdn.127.net/6124ba09896786076cbdd12fb07c652c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/89614d0d2194aa2539a984056b8bf639.jpg\" _src=\"http://yanxuan.nosdn.127.net/89614d0d2194aa2539a984056b8bf639.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/050ac06f91828d346a4711c0773e7d51.jpg\" _src=\"http://yanxuan.nosdn.127.net/050ac06f91828d346a4711c0773e7d51.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3caa9b2882b9d9b73faefad3e41891fc.jpg\" _src=\"http://yanxuan.nosdn.127.net/3caa9b2882b9d9b73faefad3e41891fc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/aba134af8719641e3fd14692fdb49f88.jpg\" _src=\"http://yanxuan.nosdn.127.net/aba134af8719641e3fd14692fdb49f88.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fd15551913bace0793c191e86e63412f.jpg\" _src=\"http://yanxuan.nosdn.127.net/fd15551913bace0793c191e86e63412f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/be891d204e489ba2547f1dd375414b42.jpg\" _src=\"http://yanxuan.nosdn.127.net/be891d204e489ba2547f1dd375414b42.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d716679f74749a7a096680bd8a532166.jpg\" _src=\"http://yanxuan.nosdn.127.net/d716679f74749a7a096680bd8a532166.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4d7fe2b7729237d8aa281f4c7128e469.jpg\" _src=\"http://yanxuan.nosdn.127.net/4d7fe2b7729237d8aa281f4c7128e469.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/920006e3a4fdace47bad39791e2be18d.jpg\" _src=\"http://yanxuan.nosdn.127.net/920006e3a4fdace47bad39791e2be18d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d9f436666176242cd083deac7a1f974d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d9f436666176242cd083deac7a1f974d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2fe7fb69bde12c318347e13892ee8835.jpg\" _src=\"http://yanxuan.nosdn.127.net/2fe7fb69bde12c318347e13892ee8835.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d0232b217577ebd39c402599a6a2831d.jpg\" _src=\"http://yanxuan.nosdn.127.net/d0232b217577ebd39c402599a6a2831d.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/de8a88d4be8764dcf28bb82e5add05bd.jpg\" _src=\"http://yanxuan.nosdn.127.net/de8a88d4be8764dcf28bb82e5add05bd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/20588fcd422660d6ed5cfd66b20614b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/20588fcd422660d6ed5cfd66b20614b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a30b5785696d64c18d462d02a98ef220.jpg\" _src=\"http://yanxuan.nosdn.127.net/a30b5785696d64c18d462d02a98ef220.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c93666cbdc49307a29c115fdfbf2b0fd.jpg\" _src=\"http://yanxuan.nosdn.127.net/c93666cbdc49307a29c115fdfbf2b0fd.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0432fb444a253ae95bbc944223d241b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/0432fb444a253ae95bbc944223d241b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/174cef303a1ccb3c3c7b3abcc6d69a79.jpg\" _src=\"http://yanxuan.nosdn.127.net/174cef303a1ccb3c3c7b3abcc6d69a79.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df1933e20477d0b12194865c8a395acc.jpg\" _src=\"http://yanxuan.nosdn.127.net/df1933e20477d0b12194865c8a395acc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/68efb1f9ff10ccb5355121a2e7a103b8.jpg\" _src=\"http://yanxuan.nosdn.127.net/68efb1f9ff10ccb5355121a2e7a103b8.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/941b363c45519392d1f08af67fc0aeb6.jpg\" _src=\"http://yanxuan.nosdn.127.net/941b363c45519392d1f08af67fc0aeb6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8d542ea99bca443dd8823592a0f6ca6a.jpg\" _src=\"http://yanxuan.nosdn.127.net/8d542ea99bca443dd8823592a0f6ca6a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1c2a753686766d97002d30658611327.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1c2a753686766d97002d30658611327.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fc6a7179190ce7963006dba0547531c0.jpg\" _src=\"http://yanxuan.nosdn.127.net/fc6a7179190ce7963006dba0547531c0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/df8cd196d673f7616aa55e12aca45fb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/df8cd196d673f7616aa55e12aca45fb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/67017cf2f13209590998f84128df1011.jpg\" _src=\"http://yanxuan.nosdn.127.net/67017cf2f13209590998f84128df1011.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b39df196ae3603ba6ec6647e9f326837.jpg\" _src=\"http://yanxuan.nosdn.127.net/b39df196ae3603ba6ec6647e9f326837.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cd2eed622687250febea37bb62b64b16.jpg\" _src=\"http://yanxuan.nosdn.127.net/cd2eed622687250febea37bb62b64b16.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7c2230bc26cdc64f4277d61d4c1374f3.jpg\" _src=\"http://yanxuan.nosdn.127.net/7c2230bc26cdc64f4277d61d4c1374f3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/dea4422a864f4e10b9095433117cb1f9.jpg\" _src=\"http://yanxuan.nosdn.127.net/dea4422a864f4e10b9095433117cb1f9.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/56d863eb01d39f9185fdd88659eb0684.jpg\" _src=\"http://yanxuan.nosdn.127.net/56d863eb01d39f9185fdd88659eb0684.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/95faa6f6cb97f2c55b7050328494de12.jpg\" _src=\"http://yanxuan.nosdn.127.net/95faa6f6cb97f2c55b7050328494de12.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/0c04cd28fc106614baca4abe505a7629.jpg\" _src=\"http://yanxuan.nosdn.127.net/0c04cd28fc106614baca4abe505a7629.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9c711766e6969a41f9560cd76f49d90b.jpg\" _src=\"http://yanxuan.nosdn.127.net/9c711766e6969a41f9560cd76f49d90b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/341dff60f8cb4d6b60ac4bbd48260b10.jpg\" _src=\"http://yanxuan.nosdn.127.net/341dff60f8cb4d6b60ac4bbd48260b10.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0973bbfd9d85273e21e74a30ba1d1b6.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0973bbfd9d85273e21e74a30ba1d1b6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/73d8985fddd28371b0387076e6d39e70.jpg\" _src=\"http://yanxuan.nosdn.127.net/73d8985fddd28371b0387076e6d39e70.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/262f2a347ce86ca2dc16c0bdb94a1446.jpg\" _src=\"http://yanxuan.nosdn.127.net/262f2a347ce86ca2dc16c0bdb94a1446.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b9366d8851805dd04a022e7ccc4cb794.jpg\" _src=\"http://yanxuan.nosdn.127.net/b9366d8851805dd04a022e7ccc4cb794.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2f2fb72b90019f51b45389e9f1111583.jpg\" _src=\"http://yanxuan.nosdn.127.net/2f2fb72b90019f51b45389e9f1111583.jpg\" style=\"\"/></p><p><br/></p>', '1', '2017-08-30 11:40:11', '4', '0', '0', '0.00', '0.00', '0', '件', 'http://yanxuan.nosdn.127.net/a5ece0953a14a9e397d3a58acf66f834.jpg', 'http://yanxuan.nosdn.127.net/9d59a22b5aff348b5aba5fc7e451ea4d.png', '439.00', '366', '1118102', '0.00', '限时购', '', '0.00', '0', '0', '0', '482.90', null, null, null, null);
INSERT INTO `nideshop_goods` VALUES ('1116031', '1011004', '1116031', '怦然心动 永生花', '0', '100', '', '音乐与花的浪漫碰撞', '<p><img src=\"http://yanxuan.nosdn.127.net/1f8fde879eca2c5da12d42065a6a7c92.jpg\" _src=\"http://yanxuan.nosdn.127.net/1f8fde879eca2c5da12d42065a6a7c92.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e83253d44444e00c22dc2854b25382a6.jpg\" _src=\"http://yanxuan.nosdn.127.net/e83253d44444e00c22dc2854b25382a6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/231af05c4c520e6c09969cb93618b275.jpg\" _src=\"http://yanxuan.nosdn.127.net/231af05c4c520e6c09969cb93618b275.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f6a0f0b81b8ccd226be51a5db145bb13.jpg\" _src=\"http://yanxuan.nosdn.127.net/f6a0f0b81b8ccd226be51a5db145bb13.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/64eb0d46084c93410fb4bff14e1fe8a4.jpg\" _src=\"http://yanxuan.nosdn.127.net/64eb0d46084c93410fb4bff14e1fe8a4.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8b1d5203bb18d0c4e3534bf41c610002.jpg\" _src=\"http://yanxuan.nosdn.127.net/8b1d5203bb18d0c4e3534bf41c610002.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3668e49363f10b8442476d0c62e4c1b1.jpg\" _src=\"http://yanxuan.nosdn.127.net/3668e49363f10b8442476d0c62e4c1b1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a93897c61b4a7b8ce77dbb5e80fe1d74.jpg\" _src=\"http://yanxuan.nosdn.127.net/a93897c61b4a7b8ce77dbb5e80fe1d74.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/32598f5b1b77543b85fbfdb1a1f7a2ef.jpg\" _src=\"http://yanxuan.nosdn.127.net/32598f5b1b77543b85fbfdb1a1f7a2ef.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/cbd6c51e27f944c73ba85e1a6701b762.jpg\" _src=\"http://yanxuan.nosdn.127.net/cbd6c51e27f944c73ba85e1a6701b762.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/14b873f6a9efff885a4b799e0b7c48f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/14b873f6a9efff885a4b799e0b7c48f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7de96c6f0e6884656bb655a7d16fab17.jpg\" _src=\"http://yanxuan.nosdn.127.net/7de96c6f0e6884656bb655a7d16fab17.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/23642bec39f7a3d43c1c41fa75096671.jpg\" _src=\"http://yanxuan.nosdn.127.net/23642bec39f7a3d43c1c41fa75096671.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4da6db8ecc03fd2eb08dd73d3db2c1a3.jpg\" _src=\"http://yanxuan.nosdn.127.net/4da6db8ecc03fd2eb08dd73d3db2c1a3.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a8b31f9da5e8b70e344d43c647a7dfb2.jpg\" _src=\"http://yanxuan.nosdn.127.net/a8b31f9da5e8b70e344d43c647a7dfb2.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e36833de623d2280db9372dce636564e.jpg\" _src=\"http://yanxuan.nosdn.127.net/e36833de623d2280db9372dce636564e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/035ad8e4e650aa656698badd2742300e.jpg\" _src=\"http://yanxuan.nosdn.127.net/035ad8e4e650aa656698badd2742300e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/27713a06a7c720c057231dabaa257f2a.jpg\" _src=\"http://yanxuan.nosdn.127.net/27713a06a7c720c057231dabaa257f2a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e9a60403dbb41d9f3d390c261b37514.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e9a60403dbb41d9f3d390c261b37514.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ab0ad63ae7cf999de2a90b970ce88de.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ab0ad63ae7cf999de2a90b970ce88de.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0ab6efedce6b0f7840421f9e9576845.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0ab6efedce6b0f7840421f9e9576845.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7f2c6964649681cff624261ce2651298.jpg\" _src=\"http://yanxuan.nosdn.127.net/7f2c6964649681cff624261ce2651298.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4e6ddfbccd07eb8062eee005ecdfe132.jpg\" _src=\"http://yanxuan.nosdn.127.net/4e6ddfbccd07eb8062eee005ecdfe132.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/7be5e5bad19b16ea8df4ed3779c0c71a.jpg\" _src=\"http://yanxuan.nosdn.127.net/7be5e5bad19b16ea8df4ed3779c0c71a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/964980d2361fdb0cdbc81d6a9f96088e.jpg\" _src=\"http://yanxuan.nosdn.127.net/964980d2361fdb0cdbc81d6a9f96088e.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/616db1683eb6635e8c32c768d721f436.jpg\" _src=\"http://yanxuan.nosdn.127.net/616db1683eb6635e8c32c768d721f436.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b7b14c2ba90064f3f6232faee6b0725c.jpg\" _src=\"http://yanxuan.nosdn.127.net/b7b14c2ba90064f3f6232faee6b0725c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/86f0a8a9691c4611dd0fe1e9a5c84bd5.jpg\" _src=\"http://yanxuan.nosdn.127.net/86f0a8a9691c4611dd0fe1e9a5c84bd5.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/4875d80c0b2b7aafa04e00539f39637f.jpg\" _src=\"http://yanxuan.nosdn.127.net/4875d80c0b2b7aafa04e00539f39637f.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/e7ec652544724ba8bbb714e552bd4f97.jpg\" _src=\"http://yanxuan.nosdn.127.net/e7ec652544724ba8bbb714e552bd4f97.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/edb9b4e1b864bb8c81d56b013566a88c.jpg\" _src=\"http://yanxuan.nosdn.127.net/edb9b4e1b864bb8c81d56b013566a88c.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/2a89ecd98fa4ab7ab63c0fd10d9ef31a.jpg\" _src=\"http://yanxuan.nosdn.127.net/2a89ecd98fa4ab7ab63c0fd10d9ef31a.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/bbf4fd1d2b73b4bce7b7ba4e99562ad1.jpg\" _src=\"http://yanxuan.nosdn.127.net/bbf4fd1d2b73b4bce7b7ba4e99562ad1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/fbb46b9ce6174088b879950f2a3ec851.jpg\" _src=\"http://yanxuan.nosdn.127.net/fbb46b9ce6174088b879950f2a3ec851.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c0ba5de59fa74bd35cabf5d57c9be1fb.jpg\" _src=\"http://yanxuan.nosdn.127.net/c0ba5de59fa74bd35cabf5d57c9be1fb.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/c12862d30dae922563d886e2a740e281.jpg\" _src=\"http://yanxuan.nosdn.127.net/c12862d30dae922563d886e2a740e281.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/78f584abdf567cfc8a65012e111bd173.jpg\" _src=\"http://yanxuan.nosdn.127.net/78f584abdf567cfc8a65012e111bd173.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/d07018e220531306755d9aff3e88b5fa.jpg\" _src=\"http://yanxuan.nosdn.127.net/d07018e220531306755d9aff3e88b5fa.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/9cfa16826c4d55bcfb23643a6e07b5b0.jpg\" _src=\"http://yanxuan.nosdn.127.net/9cfa16826c4d55bcfb23643a6e07b5b0.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/3ec9c0c398115a803b6f1cdf6ddd25f6.jpg\" _src=\"http://yanxuan.nosdn.127.net/3ec9c0c398115a803b6f1cdf6ddd25f6.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/093d3941f2ac24bd5fef654d4ddc72ae.jpg\" _src=\"http://yanxuan.nosdn.127.net/093d3941f2ac24bd5fef654d4ddc72ae.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/a2f72361252cd006faa0220683a45dbc.jpg\" _src=\"http://yanxuan.nosdn.127.net/a2f72361252cd006faa0220683a45dbc.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/60118d449ed00ae28fcd0a7a970d185b.jpg\" _src=\"http://yanxuan.nosdn.127.net/60118d449ed00ae28fcd0a7a970d185b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f2f39559f1d635dad8a8e238178f6704.jpg\" _src=\"http://yanxuan.nosdn.127.net/f2f39559f1d635dad8a8e238178f6704.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/f1123c946875caa552ec8d26103828f1.jpg\" _src=\"http://yanxuan.nosdn.127.net/f1123c946875caa552ec8d26103828f1.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/b83441ec460295662adfad5bb375967b.jpg\" _src=\"http://yanxuan.nosdn.127.net/b83441ec460295662adfad5bb375967b.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/172db1c1d303f0cfb2f74bf95422da78.jpg\" _src=\"http://yanxuan.nosdn.127.net/172db1c1d303f0cfb2f74bf95422da78.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/8f9816aec40f2de91ebc5925ef8d7330.jpg\" _src=\"http://yanxuan.nosdn.127.net/8f9816aec40f2de91ebc5925ef8d7330.jpg\" style=\"\"/></p><p><img src=\"http://yanxuan.nosdn.127.net/5d0cb944c7bd57a65f9a50678771cc02.jpg\" _src=\"http://yanxuan.nosdn.127.net/5d0cb944c7bd57a65f9a50678771cc02.jpg\" style=\"\"/></p><p><img src=\"http://ya