﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.OleDb;
using System.Data;
using CreatePinYinMa.Model;

namespace CreatePinYinMa.DAL
{
    public class AccessHelper
    {
        /// <summary>
        /// 获得表的名称
        /// </summary>
        /// <returns></returns>
        public DataTable GetTableNameList()
        {
            OleDbConnection conn = new OleDbConnection(PublicMethod.ConnStr);
            try
            {
                if (conn.State == ConnectionState.Closed)
                {
                    conn.Open();
                }
                DataTable dt = new DataTable();
                dt = conn.GetSchema("Tables");
                return dt;
            }
            catch (Exception e)
            { 
                throw e; 
            }
            finally 
            {
                if (conn.State == ConnectionState.Open)
                {
                    conn.Close();
                    conn.Dispose();
                }
            }
        }

        //查询数据库，但只返回一个值[ExecuteScalar()]
        public object SqlQueryOneValue(string sql)
        //public static object OraQueryOneValue()
        {
            //string sql = "select Count(*) From A_JuMinSYZL_LS";
            using (OleDbConnection conn = new OleDbConnection(PublicMethod.ConnStr)) //用using资源管理
            {
                conn.Open();
                using (OleDbCommand cmd = conn.CreateCommand())
                {
                    cmd.CommandText = sql; //设置命令
                    //cmd.Parameters.AddRange(p); //加参数
                    return cmd.ExecuteScalar(); //执行并返回
                }
            }
        }

        /// <summary>
        /// 获得字段名
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public DataTable GetColumnNameList(string tableName)
        {
            using (OleDbConnection conn = new OleDbConnection(PublicMethod.ConnStr))
            {
                if (conn.State == ConnectionState.Closed)
                {
                    conn.Open();
                }
                using (OleDbCommand cmd = conn.CreateCommand())
                {
                    DataTable dt = new DataTable();
                    dt = conn.GetOleDbSchemaTable(OleDbSchemaGuid.Columns, new object[] { null, null, tableName, null });
                    return dt;
                }
            }
        }

        /// <summary>
        /// 检索表中的所有数据
        /// </summary>
        /// <param name="tableName">传入的表名称</param>
        /// <param name="columnName">传入的字段名称</param>
        public static void SqlDataReader(ModelZhuanPinYinCS m)
        {
            string tab = m.TableName;
            string hanZi = m.ZiDuan_HaiZi;
            string pinYin = m.ZiDuan_PinYinMa;
            string wuBi = m.ZiDuan_WuBiMa;
            string zhuJian = m.ZiDuan_ZhuJian;
            string sql = string.Format("Select {0},{1} From {2}", hanZi, zhuJian, tab);
            string PYM, WBM, HZ, zhuJianZ;

            using (OleDbConnection conn = new OleDbConnection(PublicMethod.ConnStr))
            {
                conn.Open();
                PublicMethod PY = new PublicMethod();
                GetWuBiMa wb = new GetWuBiMa();
                using (OleDbCommand cmd = new OleDbCommand(sql, conn))
                {
                    OleDbDataReader dr = cmd.ExecuteReader();
                    if (dr.HasRows)
                    {
                        while (dr.Read())
                        {
                            HZ = (dr[0].ToString().Replace(" ", "")).Replace("　", "");  //汉字
                            zhuJianZ = (dr[1].ToString().Replace(" ", "")).Replace("　", ""); //主键
                            PYM = PY.PinYinMa(HZ);
                            WBM = wb.WuBiMa(HZ);

                            StringBuilder sb = new StringBuilder();
                            sb.Append("update ").Append(tab).Append(" set ");
                            if (!string.IsNullOrWhiteSpace(pinYin))
                            {
                                sb.Append(pinYin).Append("=").Append(PYM);
                            }
                            if (!string.IsNullOrWhiteSpace(wuBi))
                            {
                                if (!string.IsNullOrWhiteSpace(pinYin)) sb.Append(",");
                                sb.Append(wuBi).Append("=").Append(WBM);
                            }
                            sb.Append(" where ").Append(zhuJian).Append("=").Append(zhuJianZ);
                            //MessageBox.Show(sql);
                            //MessageBox.Show(sql2+"||"+HZ);
                            SqlQueryNon(sb.ToString());
                        }
                    }
                }
            }
        }

        public static void SqlQueryNon(string sql)
        {
            using (OleDbConnection conn = new OleDbConnection(PublicMethod.ConnStr))
            //conn.ConnectionString = connStr;
            {
                conn.Open();
                using (OleDbCommand cmd = new OleDbCommand(sql, conn))
                {
                    //cmd.CommandTimeout = 180; //单位：秒
                    cmd.ExecuteNonQuery();
                }
            }
        }
    }
}
