﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CreatePinYinMa.Model;
using System.Data.SqlClient;
using System.Data;
using System.Data.OracleClient;
using System.Data.OleDb;

namespace CreatePinYinMa.DAL
{
    #region 获得表的字段
    class DALColumnName
    {
        public IEnumerable<ModelColumnName> SqlSelectMore(string[] pars)
        {
            string sql;
            string dataBaseType = pars[0]; //数据库类型
            string tableName = pars[1]; //表名
            string dataBaseUserName = pars[2]; //数据库用户名

            DataTable dt = new DataTable();
            if (dataBaseType.Contains("SQLSERVER")) //MS Sql Server数据库
            {
                sql = "Select Column_Name From INFORMATION_SCHEMA.COLUMNS where Table_Name=@tableName";
                SqlParameter[] sp = { new SqlParameter("tableName", SqlDbType.VarChar) };
                sp[0].Value = tableName;
                SqlHelper sh = new SqlHelper();
                dt = sh.SqlQueryDataTable(sql, sp);
            }
            else if (dataBaseType.Contains("ORACLE")) //Oracle数据库
            {
                sql = "Select Column_Name From All_Tab_Columns where Table_Name = :tableName And Owner= :oracleUserName";
                OracleParameter[] op = { new OracleParameter("tableName", SqlDbType.VarChar),
                                       new OracleParameter("oracleUserName", SqlDbType.VarChar)
                                       };
                op[0].Value = tableName;
                op[1].Value = dataBaseUserName;
                OracleHelper oh = new OracleHelper();
                dt = oh.OraQueryDataTable(sql, op);
            }
            else //Access数据库
            {
                AccessHelper ah = new AccessHelper();
                dt = ah.GetColumnNameList(tableName);
            }
            List<ModelColumnName> lColumnName = new List<ModelColumnName>();
            foreach (DataRow colunmName in dt.Rows)
            {
                ModelColumnName mColunmName = new ModelColumnName();
                mColunmName.ColumnName = colunmName["Column_Name"].ToString();
                lColumnName.Add(mColunmName);
            }
            return lColumnName;
        }
    } 
    #endregion
}
