﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CreatePinYinMa.Model;
using System.Windows.Forms;
using System.IO;

namespace CreatePinYinMa.DAL
{
    public class MyIO
    {
        public string ConnectString()
        {
            string iniRoot = Application.StartupPath; //获得当前程序的路径
            string iniName = "conn.ini"; //配置文件名
            iniRoot = Path.Combine(iniRoot, iniName); //拼接路径和文件名，获得完整的配置文件路径
            return iniRoot; //返回完整的路径
            //return str[0].ToString();//返回第一行
        }
    }
    class DALReadConfig
    {
            /// <summary>
            /// 读取conn.ini配置文件的方法
            /// </summary>
            /// <returns>返回模型层ModelConnectString类型的值</returns>
            public IEnumerable<ModelConnStr> ReadConnectString() //返回值的类型，接收类型原则上应该一致
            {
                MyIO root = new MyIO(); //实例化MyIO对象（类似于声明一个类型为MyIO的K变量
                string iniRoot = root.ConnectString(); //获得ConnectString()方法的返回值，即配置文件的完整路径
                string[] str = File.ReadAllLines(iniRoot, Encoding.Default); //读取配置文件的全部内容，str数组中
                List<ModelConnStr> lConnStr = new List<ModelConnStr>(); //new一个泛型集合

                foreach (string i in str) //遍历数组
                {
                    ModelConnStr mConnStr = new ModelConnStr(); //new一个模型层的对象
                    mConnStr.ConnStr = i;
                    lConnStr.Add(mConnStr); //把值添加到List<T>中
                }
                return lConnStr; //返回
            }
        }
}
