﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CreatePinYinMa.Model;
using System.Data;
using System.Data.OracleClient;
using System.Data.OleDb;

namespace CreatePinYinMa.DAL
{
    public class DALTableName
    {
        public IEnumerable<ModelTableName> SqlSelectMore(ModelConnStr m)
        {
            string sql;
            DataTable dt = new DataTable();
            if (m.DataBaseType == "SQLSERVER") //MS Sql Server数据库
            {
                sql = "Select Table_Name From INFORMATION_SCHEMA.TABLES Order by Table_Name";
                SqlHelper sh = new SqlHelper();
                dt = sh.SqlQueryDataTable(sql);
            }
            else if (m.DataBaseType == "ORACLE") //oracle数据库
            {
                sql = "Select Table_Name From ALL_Tables where Owner= :oracleUserName Order by Table_Name";
                OracleParameter[] SP = { new OracleParameter("oracleUserName", SqlDbType.VarChar) };
                SP[0].Value = m.DataBaseUserName;
                OracleHelper oh=new OracleHelper();
                dt = oh.OraQueryDataTable(sql, SP);
            }
            else //Access数据库
            {
                AccessHelper ah = new AccessHelper();
                dt = ah.GetTableNameList();
            }
            List<ModelTableName> lTableName = new List<ModelTableName>();
            foreach (DataRow tab in dt.Rows)
            {
                string tableName = tab["Table_Name"].ToString();
                ModelTableName mTableName = new ModelTableName();
                if (m.DataBaseType.Contains("ACCESS")) //Access数据库
                {
                    if (tab["Table_Type"].ToString() == "TABLE")
                    {
                        mTableName.TableName = tableName;
                        lTableName.Add(mTableName); //Access有空值，所以不能放在if的外面
                    }
                }
                else
                {
                    mTableName.TableName = tableName;
                    lTableName.Add(mTableName); //Access有空值，添加时不同的数据库分别执行
                }
            }
            return lTableName;
        }
    }
}
