﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using CreatePinYinMa.Model;

namespace CreatePinYinMa.DAL
{
    public class SqlHelper
    {
        //查询数据库，返回数据表
        public DataTable SqlQueryDataTable(string sql, params SqlParameter[] p)
        //数据库的参数以@开头，用SqlParameter[] 如：Select * From Table where ID = @ID 
        {
            using (SqlConnection conn = new SqlConnection(PublicMethod.ConnStr)) //用using资源管理
            {
                conn.Open();
                using (SqlCommand cmd = conn.CreateCommand()) //这个using可以省略，因为上面的using可以顺便关闭这里的Command
                //但是加一个using更好，可以实现更快的资源回收
                {
                    cmd.CommandTimeout = 15000;
                    cmd.CommandText = sql; //设置命令
                    if (p != null && p.Length > 0) //如果参数数组的长度大于0就把全部参数一起加入SqlCommand.Parameters对象里
                    {
                        cmd.Parameters.AddRange(p); //为命令对象添加参数数组（多个参数一起加进去@ID,@Name）
                    }
                    DataTable DT = new DataTable(); //new一个数据表对象
                    SqlDataAdapter DA = new SqlDataAdapter(cmd);
                    DA.Fill(DT);
                    return DT;
                }
            }
        }

        //查询数据库，但只返回一个值[ExecuteScalar()]
        public object SqlQueryOneValue(string sql)
        //public static object OraQueryOneValue()
        {
            //string sql = "select Count(*) From A_JuMinSYZL_LS";
            using (SqlConnection conn = new SqlConnection(PublicMethod.ConnStr)) //用using资源管理
            {
                conn.Open();
                using (SqlCommand cmd = conn.CreateCommand())
                {
                    cmd.CommandText = sql; //设置命令
                    //cmd.Parameters.AddRange(p); //加参数
                    return cmd.ExecuteScalar(); //执行并返回
                }
            }
        }

        /// <summary>
        /// 检索表中的所有数据
        /// </summary>
        /// <param name="tableName">传入的表名称</param>
        /// <param name="columnName">传入的字段名称</param>
        public static void SqlDataReader(ModelZhuanPinYinCS m)
        {
            string tab = m.TableName;
            string hanZi = m.ZiDuan_HaiZi;
            string pinYin = m.ZiDuan_PinYinMa;
            string wuBi = m.ZiDuan_WuBiMa;
            string zhuJian = m.ZiDuan_ZhuJian;
            string sql = string.Format("Select {0},{1} From {2}", hanZi, zhuJian, tab);
            string PYM, WBM, HZ, zhuJianZ;
            
            using (SqlConnection conn = new SqlConnection(PublicMethod.ConnStr))
            {
                conn.Open();
                PublicMethod PY = new PublicMethod();
                GetWuBiMa wb = new GetWuBiMa();
                using (SqlCommand cmd = new SqlCommand(sql, conn))
                {
                    SqlDataReader dr = cmd.ExecuteReader();
                    if (dr.HasRows)
                    {
                        while (dr.Read())
                        {
                            HZ = (dr[0].ToString().Replace(" ", "")).Replace("　", "");  //汉字
                            zhuJianZ = (dr[1].ToString().Replace(" ", "")).Replace("　", ""); //主键
                            PYM = PY.PinYinMa(HZ);
                            WBM = wb.WuBiMa(HZ);

                            StringBuilder sb = new StringBuilder();
                            sb.Append("update ").Append(tab).Append(" set ");
                            if (!string.IsNullOrWhiteSpace(pinYin))
                            {
                                sb.Append(pinYin).Append("='").Append(PYM).Append("'");
                            }
                            if (!string.IsNullOrWhiteSpace(wuBi))
                            {
                                if (!string.IsNullOrWhiteSpace(pinYin)) sb.Append(",");
                                sb.Append(wuBi).Append("='").Append(WBM).Append("'");
                            }
                            sb.Append(" where ").Append(zhuJian).Append("=").Append(zhuJianZ);
                            //MessageBox.Show(sql);
                            //MessageBox.Show(sql2+"||"+HZ);
                            SqlQueryNon(sb.ToString());
                        }
                    }
                }
            }
        }

        public static void SqlQueryNon(string sql)
        {
            using (SqlConnection conn = new SqlConnection(PublicMethod.ConnStr))
            //conn.ConnectionString = connStr;
            {
                conn.Open();
                using (SqlCommand cmd = new SqlCommand(sql, conn))
                {
                    cmd.CommandTimeout = 180; //单位：秒
                    cmd.ExecuteNonQuery();
                }
            }
        }
    }
}
