﻿using CreatePinYinMa.BLL;
using CreatePinYinMa.DAL;
using CreatePinYinMa.Model;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;
using System.Windows.Forms;

namespace CreatePinYinMa
{
    public partial class Form1 : Form
    {
        ModelZhuanPinYinCS m = new ModelZhuanPinYinCS();
        public Form1()
        {
            InitializeComponent();
            dgGetTextValue = new DelegateGetTextValue(this.GetTextValue); //4、在窗体中实例化委托对象，并执行委托的方法
            dgConfigButtonEnable = new DelegateConfigButtonEnable(this.ButtonEnable);
        }

        ModelConnStr mConnStr = new ModelConnStr();
        /// <summary>
        /// 窗口加载
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_Load(object sender, EventArgs e)
        {
            ReadConnStr(); //把连接字符串加载到下拉框中
        }

        /// <summary>
        /// 打开数据库连接配置文件conn.ini
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnOpenIni_Click(object sender, EventArgs e)
        {
            MyIO root = new MyIO();
            string connStr = root.ConnectString();
            Process.Start("notepad.exe", connStr); //用notepad.exe打开配置文件
        }

        /// <summary>
        /// 连接数据库
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnConnDataBase_Click(object sender, EventArgs e)
        {
            string readConnStr = cboConnectString.Text; //把读到的连接字符串转成大写
            //connStr_DataBaseType[0]：数据库类型；connStr_DataBaseType[1]：数据库连接字符串
            if (!readConnStr.Contains("||"))
            {
                MessageBox.Show("连接字符串有误，必须包含||，前为数据库类型，后为连接字符串，格式如下：\n SqlServer||连接字符串\n Oracle||连接字符串", "提示", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            if (readConnStr.ToUpper().Contains("ACCESS")) //如果是Access，就把读到的文件路径加上
            {
                readConnStr += txtAccess.Text;
                if (string.IsNullOrEmpty(txtAccess.Text))
                {
                    MessageBox.Show("请选择Access数据库文件");
                    return;
                }
            }
            string[] connStr_DataBaseType = readConnStr.Split(new string[] { "||" }, StringSplitOptions.RemoveEmptyEntries);
            PublicMethod.ConnStr = connStr_DataBaseType[1]; //赋给数据库连接字符串，这个字符串是用来连接数据库的，有密码，不能转大小写
            mConnStr.ConnStr = connStr_DataBaseType[1].ToUpper(); //赋给数据库连接字符串
            mConnStr.DataBaseType = connStr_DataBaseType[0].ToUpper(); //赋给数据库类型

            string cboConnStr = mConnStr.ConnStr;
            //USER取得oracle用户名，oracle需要根据用户名检索，不然会出现其它不相关的表
            //UID取得SqlServer用户名[取SqlServer的用户名仅仅是为了防止无下标出错]

            string dataBaseUserName = (cboConnStr.Split(new String[] { "USER", "UID", "OLEDB" }, StringSplitOptions.RemoveEmptyEntries)[1]).Split(new Char[] { ';' }, StringSplitOptions.RemoveEmptyEntries)[0];
            dataBaseUserName = dataBaseUserName.Replace("=", ""); //去除用户名中的等号
            dataBaseUserName = dataBaseUserName.Replace(" ", ""); //去除用户名中的半角空格
            dataBaseUserName = dataBaseUserName.Replace("　", ""); //去除用户名中的全角空格
            mConnStr.DataBaseUserName = dataBaseUserName; //赋给数据库用户名
            TableNameList(mConnStr); //调用读取数据库表名称的方法，传入一个数据库类型
            lblZhuangTai.Text = "数据库连接成功";
            pnlZhuangTai.Visible = true; //数据库连接成功后，把显示操作状态的lbl设置为可见
            btnCreate.Enabled = true; //开始生成按钮设为启用
            timerLBLZhuangTai.Enabled = true; //设置计时器为可用
            timerLBLZhuangTai.Interval = 2000; //设置计时器每隔两秒执行
        }

        /// <summary>
        /// 列出所有数据表名称的下拉框
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cboTableName_SelectedIndexChanged(object sender, EventArgs e)
        {
            cboHanZi.Items.Clear(); //先清除下拉框中的值
            cboBaoCunPYM.Items.Clear();
            cboZhuJian.Items.Clear();
            
            string[] pars = { mConnStr.DataBaseType, cboTableName.Text, mConnStr.DataBaseUserName }; //0数据库类型,1表名称,2数据库用户名
            ColumnNameList(pars);
            //MessageBox.Show(cboTableName.Text);
        }

        /// <summary>
        /// 生成拼音码按钮
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCreate_Click(object sender, EventArgs e)
        {
            pic.Visible = true; //开始生成拼音码时，把滚动的图片设为显示
            btnConnDataBase.Enabled = false; //开始生成拼音后，连接数据库按钮设为不可操作
            btnCreate.Enabled = false; //点击生成拼音码后按钮设为禁用，防止再开新线程
            cboTableName.Enabled = false;
            cboZhuJian.Enabled = false;
            cboHanZi.Enabled = false;
            cboBaoCunPYM.Enabled = false;
            picDiZhiRH.Visible = true; //抵制日货图片
            Thread t = new Thread(CreatePinYinMa); //创建一个新线程
            t.IsBackground = true; //指定为后台线程，默认为前台线程，前台线程用户中断时会进程还会在内存中继续运行
            t.Start(); //准备执行新线程
        }

        /// <summary>
        /// 选择数据库连接字符串事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void cboConnectString_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cboConnectString.Text.ToUpper().Contains("ACCESS"))
            {
                lblAccess.Visible = true;
                txtAccess.Visible = true;
                btnAccess.Visible = true;
            }
            else
            {
                lblAccess.Visible = false;
                txtAccess.Visible = false;
                btnAccess.Visible = false;
            }
        }

        /// <summary>
        /// 加载conn.ini文件中连接数据库字符串
        /// </summary>
        private void ReadConnStr()
        {
            BLLConnStr bConnStr = new BLLConnStr();
            IEnumerable<ModelConnStr> mConnStr = bConnStr.ReadConnectString();

            foreach (ModelConnStr connStr in mConnStr)
            {
                cboConnectString.Items.Add(connStr.ConnStr); //把IEnumerable<ModelConnectString>.ConnectString加到cboConnStr.Items
            }
            cboConnectString.SelectedIndex = 0; //默认选中第1行
        }

        /// <summary>
        /// 把数据表名加载到下拉框中
        /// </summary>
        /// <param name="dataBaseType">数据库类型</param>
        private void TableNameList(ModelConnStr m)
        {
            BLLTableName bTableName = new BLLTableName();
            IEnumerable<ModelTableName> lTableName = bTableName.SqlSelectMore(m);

            foreach (ModelTableName tableName in lTableName)
            {
                cboTableName.Items.Add(tableName.TableName);
                //MessageBox.Show(tableName.TableName.Length.ToString() + "@@" + tableName.TableName);
            }
            cboTableName.SelectedIndex = 0; //默认选中第1行
            //clstTableName.CheckedItems：得到列表框中选中的名称
        }

        /// <summary>
        /// 把所选表的字段名称加载到下拉框中
        /// </summary>
        /// <param name="pars">参数数组</param>
        private void ColumnNameList(string[] pars)
        {
            BLLColumnName bColumnName = new BLLColumnName();
            IEnumerable<ModelColumnName> lColumnName = bColumnName.SqlSelectMore(pars);

            foreach (ModelColumnName columnName in lColumnName)
            {
                cboHanZi.Items.Add(columnName.ColumnName);
                cboBaoCunPYM.Items.Add(columnName.ColumnName);
                cboZhuJian.Items.Add(columnName.ColumnName);
                cboBaoCunWBM.Items.Add(columnName.ColumnName);
            }
            cboHanZi.SelectedIndex = 0;
            //cboBaoCunPYM.SelectedIndex = 0;
            cboZhuJian.SelectedIndex = 0;
            //cboBaoCunWBM.SelectedIndex = 0;
        }

        /// <summary>
        /// 浏览Access文件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAccess_Click(object sender, EventArgs e)
        {
            if (odlgAccessFilePath.ShowDialog() == DialogResult.OK)
            {
                txtAccess.Text = odlgAccessFilePath.FileName;
                //cboConnectString.Items.Add("Data Source=" + odlgAccessFilePath.FileName + ";");
            }
        }

        /// <summary>
        /// 窗口关闭事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Settings1.Default.Save(); //当窗口关闭时，保存界面上用户最后一次输入的值
        }

        private void timerLBLZhuangTai_Tick(object sender, EventArgs e)
        {
            pnlZhuangTai.Visible = false;
            timerLBLZhuangTai.Enabled = false; //计时器设为不可用
        }

        private void CreatePinYinMa()
        {
            //ModelZhuanPinYinCS m = new ModelZhuanPinYinCS();
            //m.TableName = cboTableName.Text;
            //m.ZiDuan_HaiZi = cboHanZi.Text;
            //m.ZiDuan_PinYinMa = cboBaoCunPYM.Text;
            //m.ZiDuan_ZhuJian = cboZhuJian.Text;
            this.Invoke(dgGetTextValue); //指定获得控件值的委托

            if (mConnStr.DataBaseType.Contains("SQLSERVER")) //Sql Server数据库
            {
                SqlHelper.SqlDataReader(m);
            }
            else if (mConnStr.DataBaseType.Contains("ORACLE")) //Oracle数据库
            {
                OracleHelper.OraDataReader(m);
            }
            else //Access数据库
            {
                AccessHelper.SqlDataReader(m);
            }

            this.Invoke(dgConfigButtonEnable); //指定改变控件状态的委托
            MessageBox.Show("生成拼音码成功");
        }

        private void ConfigButtonEnable()
        {
            pic.Invoke(dgConfigButtonEnable);
        }

        /// <summary>
        /// 1、根据委托类型，定义方法（调用相关类，创建拼音码）
        /// </summary>
        /// 
        private void GetTextValue()
        {
            m.TableName = cboTableName.Text;
            m.ZiDuan_HaiZi = cboHanZi.Text;
            m.ZiDuan_PinYinMa = cboBaoCunPYM.Text;
            m.ZiDuan_WuBiMa = cboBaoCunWBM.Text;
            m.ZiDuan_ZhuJian = cboZhuJian.Text;
            pnlZhuangTai.Visible = true;
            string[] pars = { mConnStr.DataBaseType, cboTableName.Text }; //0数据库类型,1表名称
            lblZhuangTai.Text = "正在处理" + new BLLRowCount().RowCount(pars) + "条记录……";
        }

        private void ButtonEnable()
        {
            pic.Visible = false; //拼音码生成成功后，把滚动的图片设为隐藏
            btnConnDataBase.Enabled = true; //拼音码生成成功后，连接数据库按钮设为可操作
            pnlZhuangTai.Visible = false; //拼音码生成成功后，显示进度的panel控件设为隐藏
            btnCreate.Enabled = true; //拼音码生成成功后，开始生成按钮设为可操作
            cboTableName.Enabled = true;
            cboZhuJian.Enabled = true;
            cboHanZi.Enabled = true;
            cboBaoCunPYM.Enabled = true;
            picDiZhiRH.Visible = false;//抵制日货图片
        }

        //3、定义一个委托对象
        DelegateGetTextValue dgGetTextValue = null;
        DelegateConfigButtonEnable dgConfigButtonEnable = null;
    }
    //2、定义一个委托
    delegate void DelegateGetTextValue();
    delegate void DelegateConfigButtonEnable();
}
