﻿using System.Collections.Generic;

namespace CreatePinYinMa
{
    public class GetWuBiMa
    {
        /// <summary>
        /// 生成汉字五笔码
        /// </summary>
        /// <param name="ziFuChuan">传入的字符串</param>
        /// <returns>返回这个字符串的五笔码字符串</returns>
        public string WuBiMa(string ziFuChuan)
        {
            if (string.IsNullOrWhiteSpace(ziFuChuan)) return string.Empty;
            string wbm = string.Empty;
            foreach (char HZ in ziFuChuan) //遍历传入的字符串
            {
                wbm += GetWuBiMaMethod(HZ.ToString())[0];
            }
            return wbm.ToUpper();
        }

        private string GetWuBiMaMethod(string hz)
        {
            Dictionary<string, string> dic = new Dictionary<string, string>();
            #region 五笔码字典
            dic.Add("工", "a");
            dic.Add("戈", "a");
            dic.Add("式", "aa");
            dic.Add("戒", "aa");
            dic.Add("菚", "aaar");
            dic.Add("葚", "aad");
            dic.Add("匞", "aad");
            dic.Add("蘛", "aade");
            dic.Add("藄", "aadi");
            dic.Add("匿", "aadk");
            dic.Add("慝", "aadn");
            dic.Add("茙", "aadr");
            dic.Add("萁", "aadw");
            dic.Add("苷", "aaf");
            dic.Add("甙", "aafd");
            dic.Add("蘜", "aafo");
            dic.Add("芽", "aah");
            dic.Add("菣", "aahc");
            dic.Add("茝", "aahh");
            dic.Add("茞", "aahh");
            dic.Add("藍", "aahl");
            dic.Add("藖", "aahm");
            dic.Add("虦", "aahm");
            dic.Add("蕥", "aahy");
            dic.Add("剗", "aajh");
            dic.Add("蓳", "aakg");
            dic.Add("蓲", "aakk");
            dic.Add("盞", "aalf");
            dic.Add("蘳", "aamf");
            dic.Add("蘣", "aamg");
            dic.Add("蒆", "aamv");
            dic.Add("茿", "aamy");
            dic.Add("苣", "aan");
            dic.Add("葉", "aans");
            dic.Add("苉", "aaqb");
            dic.Add("蔕", "aaqh");
            dic.Add("戔", "aar");
            dic.Add("荛", "aat");
            dic.Add("蘙", "aatn");
            dic.Add("芅", "aau");
            dic.Add("苆", "aavb");
            dic.Add("匶", "aawv");
            dic.Add("莁", "aaww");
            dic.Add("节", "ab");
            dic.Add("蒸", "ab");
            dic.Add("藂", "abci");
            dic.Add("菆", "abcu");
            dic.Add("荫", "abe");
            dic.Add("蘟", "aben");
            dic.Add("茸", "abf");
            dic.Add("芓", "abf");
            dic.Add("蔯", "abgi");
            dic.Add("邛", "abh");
            dic.Add("卭", "abh");
            dic.Add("匩", "abhg");
            dic.Add("菡", "abib");
            dic.Add("荪", "abiu");
            dic.Add("藬", "abkm");
            dic.Add("茁", "abm");
            dic.Add("芤", "abn");
            dic.Add("菰", "abr");
            dic.Add("蕯", "abtg");
            dic.Add("蓀", "abti");
            dic.Add("萨", "abu");
            dic.Add("薩", "abug");
            dic.Add("蘵", "abuj");
            dic.Add("匜", "abv");
            dic.Add("蔭", "abwc");
            dic.Add("蒢", "abwt");
            dic.Add("芭", "ac");
            dic.Add("茅", "ac");
            dic.Add("茎", "aca");
            dic.Add("匥", "acak");
            dic.Add("芧", "acbj");
            dic.Add("蓩", "acbl");
            dic.Add("蓣", "acbm");
            dic.Add("蕷", "acbm");
            dic.Add("鶜", "acbo");
            dic.Add("葇", "acbs");
            dic.Add("蔘", "acce");
            dic.Add("蓪", "acep");
            dic.Add("苔", "ack");
            dic.Add("葈", "acks");
            dic.Add("荾", "acwt");
            dic.Add("芆", "acyu");
            dic.Add("基", "ad");
            dic.Add("莽", "ada");
            dic.Add("蔵", "adat");
            dic.Add("蕻", "adaw");
            dic.Add("苊", "adb");
            dic.Add("茇", "adc");
            dic.Add("苃", "adcu");
            dic.Add("弎", "add");
            dic.Add("藞", "addd");
            dic.Add("戎", "ade");
            dic.Add("葫", "adef");
            dic.Add("萇", "adeu");
            dic.Add("苦", "adf");
            dic.Add("莾", "adfa");
            dic.Add("莀", "adfe");
            dic.Add("蓐", "adff");
            dic.Add("萘", "adfi");
            dic.Add("荂", "adfn");
            dic.Add("葳", "adg");
            dic.Add("葴", "adgt");
            dic.Add("荐", "adh");
            dic.Add("葜", "adhd");
            dic.Add("茬", "adhf");
            dic.Add("蒧", "adht");
            dic.Add("蘴", "adhu");
            dic.Add("蔧", "adhv");
            dic.Add("藉", "adi");
            dic.Add("藕", "adiy");
            dic.Add("菲", "adj");
            dic.Add("匪", "adjd");
            dic.Add("韮", "adjg");
            dic.Add("菴", "adjn");
            dic.Add("蕜", "adjn");
            dic.Add("若", "adk");
            dic.Add("鄀", "adkb");
            dic.Add("蠚", "adkj");
            dic.Add("匲", "adkk");
            dic.Add("惹", "adkn");
            dic.Add("逽", "adkp");
            dic.Add("苈", "adl");
            dic.Add("项", "adm");
            dic.Add("荋", "admj");
            dic.Add("蒇", "admt");
            dic.Add("蕆", "admt");
            dic.Add("項", "admy");
            dic.Add("茂", "adn");
            dic.Add("藏", "adnt");
            dic.Add("荿", "adnt");
            dic.Add("荙", "adpu");
            dic.Add("蒝", "adri");
            dic.Add("藶", "adth");
            dic.Add("蕨", "adu");
            dic.Add("芖", "adu");
            dic.Add("蕼", "advh");
            dic.Add("其", "adw");
            dic.Add("斟", "adw");
            dic.Add("戡", "adwa");
            dic.Add("碁", "adwd");
            dic.Add("期", "adwe");
            dic.Add("朞", "adwe");
            dic.Add("卙", "adwf");
            dic.Add("菶", "adwh");
            dic.Add("綦", "adwi");
            dic.Add("剘", "adwj");
            dic.Add("萶", "adwj");
            dic.Add("蜝", "adwj");
            dic.Add("蟴", "adwj");
            dic.Add("勘", "adwl");
            dic.Add("甚", "adwn");
            dic.Add("惎", "adwn");
            dic.Add("夦", "adwq");
            dic.Add("斯", "adwr");
            dic.Add("棊", "adws");
            dic.Add("蓁", "adwt");
            dic.Add("尠", "adwt");
            dic.Add("欺", "adww");
            dic.Add("匧", "adww");
            dic.Add("歁", "adww");
            dic.Add("莢", "adww");
            dic.Add("諅", "adwy");
            dic.Add("茏", "adx");
            dic.Add("葢", "adyl");
            dic.Add("荗", "adyt");
            dic.Add("菜", "ae");
            dic.Add("艿", "aeb");
            dic.Add("菔", "aebc");
            dic.Add("莩", "aebf");
            dic.Add("萉", "aecb");
            dic.Add("萾", "aecl");
            dic.Add("薍", "aecn");
            dic.Add("蕦", "aedm");
            dic.Add("藐", "aee");
            dic.Add("萠", "aeef");
            dic.Add("薶", "aeef");
            dic.Add("蒯", "aeej");
            dic.Add("萲", "aefc");
            dic.Add("藸", "aefj");
            dic.Add("苴", "aeg");
            dic.Add("莇", "aegl");
            dic.Add("苚", "aej");
            dic.Add("﨟", "aejn");
            dic.Add("莻", "aekx");
            dic.Add("荕", "aelb");
            dic.Add("蕣", "aeph");
            dic.Add("薆", "aept");
            dic.Add("蓫", "aepu");
            dic.Add("葋", "aeqk");
            dic.Add("蘨", "aeri");
            dic.Add("散", "aet");
            dic.Add("葄", "aetf");
            dic.Add("蕤", "aetg");
            dic.Add("蔿", "aeto");
            dic.Add("藤", "aeu");
            dic.Add("虅", "aeuc");
            dic.Add("蕂", "aeul");
            dic.Add("荽", "aev");
            dic.Add("蓞", "aevf");
            dic.Add("蒵", "aexd");
            dic.Add("芨", "aey");
            dic.Add("革", "af");
            dic.Add("鞯", "afa");
            dic.Add("韄", "afac");
            dic.Add("鞴", "afae");
            dic.Add("鞾", "afaf");
            dic.Add("韊", "afai");
            dic.Add("鞳", "afak");
            dic.Add("蕡", "afam");
            dic.Add("靾", "afan");
            dic.Add("韉", "afao");
            dic.Add("鞢", "afas");
            dic.Add("韈", "afat");
            dic.Add("邯", "afb");
            dic.Add("靶", "afc");
            dic.Add("芰", "afc");
            dic.Add("蓋", "afcl");
            dic.Add("鞣", "afcs");
            dic.Add("芸", "afcu");
            dic.Add("靫", "afcy");
            dic.Add("甘", "afd");
            dic.Add("弍", "afd");
            dic.Add("薷", "afdj");
            dic.Add("鞑", "afdp");
            dic.Add("蘎", "afec");
            dic.Add("鞵", "afed");
            dic.Add("靻", "afeg");
            dic.Add("鞖", "afev");
            dic.Add("鞱", "afev");
            dic.Add("靸", "afey");
            dic.Add("芏", "aff");
            dic.Add("鞲", "aff");
            dic.Add("葑", "aff");
            dic.Add("蕓", "affc");
            dic.Add("鞋", "afff");
            dic.Add("茥", "afff");
            dic.Add("靯", "affg");
            dic.Add("靬", "affh");
            dic.Add("鞊", "affk");
            dic.Add("韇", "affm");
            dic.Add("韃", "affp");
            dic.Add("蕘", "affq");
            dic.Add("韁", "afgg");
            dic.Add("靰", "afgq");
            dic.Add("鞕", "afgq");
            dic.Add("靺", "afgs");
            dic.Add("鞆", "afgw");
            dic.Add("鞁", "afhc");
            dic.Add("鞐", "afhh");
            dic.Add("蒖", "afhw");
            dic.Add("蒜", "afi");
            dic.Add("鞘", "afie");
            dic.Add("鞺", "afif");
            dic.Add("鞜", "afij");
            dic.Add("鞩", "afij");
            dic.Add("鞝", "afik");
            dic.Add("鞉", "afiq");
            dic.Add("苿", "afiu");
            dic.Add("莍", "afiy");
            dic.Add("芉", "afj");
            dic.Add("鞸", "afjf");
            dic.Add("靼", "afjg");
            dic.Add("鞮", "afjh");
            dic.Add("鞰", "afjl");
            dic.Add("鞨", "afjn");
            dic.Add("韅", "afjo");
            dic.Add("薣", "afkc");
            dic.Add("鞙", "afke");
            dic.Add("薹", "afkf");
            dic.Add("鞓", "afkg");
            dic.Add("蘦", "afkk");
            dic.Add("虂", "afkk");
            dic.Add("鞼", "afkm");
            dic.Add("薳", "afkp");
            dic.Add("鞻", "afkv");
            dic.Add("勒", "afl");
            dic.Add("鞇", "afld");
            dic.Add("蕾", "aflf");
            dic.Add("匵", "aflm");
            dic.Add("藚", "aflm");
            dic.Add("贰", "afm");
            dic.Add("鞅", "afmd");
            dic.Add("萳", "afmf");
            dic.Add("貳", "afmi");
            dic.Add("靹", "afmw");
            dic.Add("苇", "afn");
            dic.Add("芌", "afnb");
            dic.Add("薵", "afnf");
            dic.Add("靵", "afnf");
            dic.Add("鞍", "afp");
            dic.Add("鞚", "afpa");
            dic.Add("荸", "afpb");
            dic.Add("葧", "afpl");
            dic.Add("鞠", "afq");
            dic.Add("芫", "afq");
            dic.Add("芜", "afqb");
            dic.Add("鞄", "afqn");
            dic.Add("鞔", "afqq");
            dic.Add("荺", "afqu");
            dic.Add("莰", "afqw");
            dic.Add("鞫", "afqy");
            dic.Add("靮", "afqy");
            dic.Add("韂", "afqy");
            dic.Add("靳", "afr");
            dic.Add("鞞", "afrf");
            dic.Add("鞡", "afru");
            dic.Add("某", "afs");
            dic.Add("靪", "afsh");
            dic.Add("韆", "afsp");
            dic.Add("著", "aft");
            dic.Add("蓍", "aft");
            dic.Add("鞒", "aft");
            dic.Add("甛", "aftd");
            dic.Add("鞽", "aftk");
            dic.Add("鞦", "afto");
            dic.Add("荖", "aftx");
            dic.Add("鞂", "afty");
            dic.Add("蔷", "afu");
            dic.Add("蕔", "afuc");
            dic.Add("靽", "afuf");
            dic.Add("鞧", "afug");
            dic.Add("鞛", "afuk");
            dic.Add("薘", "afup");
            dic.Add("蓻", "afuy");
            dic.Add("鞎", "afve");
            dic.Add("鞀", "afvk");
            dic.Add("鞬", "afvp");
            dic.Add("靭", "afvy");
            dic.Add("靱", "afvy");
            dic.Add("鞭", "afw");
            dic.Add("鞥", "afwa");
            dic.Add("蕶", "afwc");
            dic.Add("藝", "afwc");
            dic.Add("薔", "afwk");
            dic.Add("鞈", "afwk");
            dic.Add("靲", "afwn");
            dic.Add("爇", "afwo");
            dic.Add("菱", "afwt");
            dic.Add("芙", "afwu");
            dic.Add("靴", "afwx");
            dic.Add("藿", "afwy");
            dic.Add("蓺", "afwy");
            dic.Add("鞃", "afxc");
            dic.Add("靷", "afxh");
            dic.Add("靿", "afxl");
            dic.Add("鞿", "afxt");
            dic.Add("鞟", "afyb");
            dic.Add("鞹", "afyb");
            dic.Add("蘾", "afye");
            dic.Add("韀", "afyo");
            dic.Add("七", "ag");
            dic.Add("荆", "aga");
            dic.Add("華", "agaf");
            dic.Add("茾", "agaj");
            dic.Add("荊", "agaj");
            dic.Add("鷨", "agao");
            dic.Add("邼", "agbh");
            dic.Add("萅", "agbj");
            dic.Add("芚", "agbn");
            dic.Add("荎", "agcf");
            dic.Add("菿", "agcj");
            dic.Add("匡", "agd");
            dic.Add("弌", "agd");
            dic.Add("菾", "agdn");
            dic.Add("莆", "age");
            dic.Add("菁", "agef");
            dic.Add("蒪", "agef");
            dic.Add("芋", "agf");
            dic.Add("廿", "agh");
            dic.Add("", "aghg");
            dic.Add("艹", "aghh");
            dic.Add("卄", "aghh");
            dic.Add("蔫", "agho");
            dic.Add("芐", "aghu");
            dic.Add("苤", "agi");
            dic.Add("芣", "agiu");
            dic.Add("蕙", "agj");
            dic.Add("蓴", "agjf");
            dic.Add("荁", "agjg");
            dic.Add("菄", "agji");
            dic.Add("莄", "agjq");
            dic.Add("蔌", "agk");
            dic.Add("菫", "agkg");
            dic.Add("蒚", "agkh");
            dic.Add("蘁", "agkk");
            dic.Add("葍", "agkl");
            dic.Add("藾", "agkm");
            dic.Add("虉", "agko");
            dic.Add("藗", "agkp");
            dic.Add("荳", "agku");
            dic.Add("薑", "aglg");
            dic.Add("萰", "agli");
            dic.Add("劻", "agln");
            dic.Add("芾", "agm");
            dic.Add("茦", "agmi");
            dic.Add("蕀", "agmi");
            dic.Add("莿", "agmj");
            dic.Add("蓸", "agmj");
            dic.Add("颟", "agmm");
            dic.Add("蓛", "agmt");
            dic.Add("蔶", "agmu");
            dic.Add("苪", "agmw");
            dic.Add("黃", "agmw");
            dic.Add("匚", "agn");
            dic.Add("匸", "agn");
            dic.Add("巧", "agnn");
            dic.Add("瓨", "agnn");
            dic.Add("弋", "agny");
            dic.Add("莱", "ago");
            dic.Add("葬", "agq");
            dic.Add("薞", "agqe");
            dic.Add("塟", "agqf");
            dic.Add("薤", "agqg");
            dic.Add("茢", "agqj");
            dic.Add("薚", "agqr");
            dic.Add("蔜", "agqt");
            dic.Add("茉", "ags");
            dic.Add("廾", "agt");
            dic.Add("苹", "agu");
            dic.Add("荚", "aguw");
            dic.Add("萋", "agv");
            dic.Add("莖", "agva");
            dic.Add("萐", "agvh");
            dic.Add("葘", "agvl");
            dic.Add("葝", "agvl");
            dic.Add("蕐", "agwh");
            dic.Add("薾", "agwq");
            dic.Add("荑", "agx");
            dic.Add("匤", "agyi");
            dic.Add("牙", "ah");
            dic.Add("蘧", "aha");
            dic.Add("蔖", "ahag");
            dic.Add("萛", "ahaj");
            dic.Add("蘆", "ahal");
            dic.Add("萀", "aham");
            dic.Add("藘", "ahan");
            dic.Add("繤", "ahdi");
            dic.Add("薉", "ahdt");
            dic.Add("芷", "ahf");
            dic.Add("苜", "ahf");
            dic.Add("蕋", "ahhh");
            dic.Add("煕", "ahho");
            dic.Add("蘃", "ahhs");
            dic.Add("匷", "ahhy");
            dic.Add("菽", "ahi");
            dic.Add("蘋", "ahim");
            dic.Add("荹", "ahir");
            dic.Add("茮", "ahiu");
            dic.Add("苫", "ahk");
            dic.Add("赜", "ahk");
            dic.Add("颐", "ahkm");
            dic.Add("賾", "ahkm");
            dic.Add("頤", "ahkm");
            dic.Add("巸", "ahkn");
            dic.Add("熙", "ahko");
            dic.Add("媐", "ahkv");
            dic.Add("蓾", "ahlo");
            dic.Add("臣", "ahn");
            dic.Add("孯", "ahnb");
            dic.Add("臤", "ahnc");
            dic.Add("硻", "ahnd");
            dic.Add("腎", "ahne");
            dic.Add("堅", "ahnf");
            dic.Add("朢", "ahng");
            dic.Add("卧", "ahnh");
            dic.Add("緊", "ahni");
            dic.Add("蜸", "ahnj");
            dic.Add("臨", "ahnk");
            dic.Add("監", "ahnl");
            dic.Add("盬", "ahnl");
            dic.Add("鹽", "ahnl");
            dic.Add("賢", "ahnm");
            dic.Add("贒", "ahnm");
            dic.Add("頣", "ahnm");
            dic.Add("薡", "ahnn");
            dic.Add("覧", "ahnq");
            dic.Add("覽", "ahnq");
            dic.Add("鋻", "ahnq");
            dic.Add("鍳", "ahnq");
            dic.Add("鑒", "ahnq");
            dic.Add("掔", "ahnr");
            dic.Add("擥", "ahnr");
            dic.Add("竪", "ahnu");
            dic.Add("豎", "ahnu");
            dic.Add("婜", "ahnv");
            dic.Add("臥", "ahnw");
            dic.Add("譼", "ahny");
            dic.Add("蔝", "ahou");
            dic.Add("莧", "ahqb");
            dic.Add("薒", "ahqo");
            dic.Add("萈", "ahqy");
            dic.Add("邪", "ahtb");
            dic.Add("鸦", "ahtg");
            dic.Add("鴉", "ahto");
            dic.Add("迓", "ahtp");
            dic.Add("雅", "ahty");
            dic.Add("藈", "ahwd");
            dic.Add("茈", "ahx");
            dic.Add("东", "ai");
            dic.Add("茳", "aia");
            dic.Add("蘫", "aial");
            dic.Add("菃", "aian");
            dic.Add("蕖", "aias");
            dic.Add("葓", "aiaw");
            dic.Add("范", "aib");
            dic.Add("菭", "aick");
            dic.Add("菹", "aie");
            dic.Add("莦", "aief");
            dic.Add("萷", "aiej");
            dic.Add("蔆", "aift");
            dic.Add("薄", "aig");
            dic.Add("蔳", "aige");
            dic.Add("萍", "aigh");
            dic.Add("蒲", "aigy");
            dic.Add("菠", "aih");
            dic.Add("蔋", "aihc");
            dic.Add("蔢", "aihv");
            dic.Add("莎", "aiit");
            dic.Add("蕰", "aijl");
            dic.Add("蘯", "aijl");
            dic.Add("蕩", "aijr");
            dic.Add("蕅", "aijy");
            dic.Add("藻", "aik");
            dic.Add("薀", "aill");
            dic.Add("莈", "aimc");
            dic.Add("荡", "ain");
            dic.Add("莐", "aipq");
            dic.Add("鸫", "aiq");
            dic.Add("茪", "aiqb");
            dic.Add("萢", "aiqn");
            dic.Add("蒎", "air");
            dic.Add("萡", "airf");
            dic.Add("菏", "ais");
            dic.Add("薸", "aisi");
            dic.Add("藫", "aisj");
            dic.Add("莯", "aisu");
            dic.Add("落", "ait");
            dic.Add("萿", "aitd");
            dic.Add("藩", "aitl");
            dic.Add("汞", "aiu");
            dic.Add("蓱", "aiua");
            dic.Add("蓡", "aivc");
            dic.Add("薓", "aivc");
            dic.Add("葏", "aivh");
            dic.Add("菬", "aivk");
            dic.Add("蒅", "aivs");
            dic.Add("薻", "aivs");
            dic.Add("虃", "aiwg");
            dic.Add("蕍", "aiwj");
            dic.Add("蒤", "aiwt");
            dic.Add("蒞", "aiwu");
            dic.Add("匯", "aiwy");
            dic.Add("茫", "aiy");
            dic.Add("蒗", "aiye");
            dic.Add("薃", "aiyk");
            dic.Add("蓅", "aiyq");
            dic.Add("划", "aj");
            dic.Add("蓽", "ajaf");
            dic.Add("蕞", "ajb");
            dic.Add("莫", "ajd");
            dic.Add("鄚", "ajdb");
            dic.Add("蓦", "ajdc");
            dic.Add("驀", "ajdc");
            dic.Add("墓", "ajdf");
            dic.Add("幕", "ajdh");
            dic.Add("暮", "ajdj");
            dic.Add("蟇", "ajdj");
            dic.Add("募", "ajdl");
            dic.Add("慕", "ajdn");
            dic.Add("摹", "ajdr");
            dic.Add("謩", "ajdy");
            dic.Add("萌", "aje");
            dic.Add("昔", "ajf");
            dic.Add("荲", "ajff");
            dic.Add("蒔", "ajff");
            dic.Add("莳", "ajfu");
            dic.Add("皵", "ajhc");
            dic.Add("萺", "ajhf");
            dic.Add("草", "ajj");
            dic.Add("菖", "ajjf");
            dic.Add("剒", "ajjh");
            dic.Add("蕌", "ajjj");
            dic.Add("蔓", "ajl");
            dic.Add("蒀", "ajlf");
            dic.Add("躉", "ajmh");
            dic.Add("蠆", "ajmj");
            dic.Add("勱", "ajml");
            dic.Add("邁", "ajmp");
            dic.Add("萬", "ajmy");
            dic.Add("逪", "ajpd");
            dic.Add("葛", "ajq");
            dic.Add("鹊", "ajqg");
            dic.Add("茰", "ajqu");
            dic.Add("斮", "ajrh");
            dic.Add("菒", "ajsu");
            dic.Add("菓", "ajsu");
            dic.Add("蓝", "ajt");
            dic.Add("葃", "ajtf");
            dic.Add("虄", "ajtg");
            dic.Add("茧", "aju");
            dic.Add("郾", "ajv");
            dic.Add("匽", "ajvd");
            dic.Add("鶠", "ajvo");
            dic.Add("鵲", "ajwo");
            dic.Add("菎", "ajxx");
            dic.Add("或", "ak");
            dic.Add("惑", "ak");
            dic.Add("葺", "akb");
            dic.Add("蕺", "akbt");
            dic.Add("叵", "akd");
            dic.Add("戓", "akd");
            dic.Add("艱", "akfe");
            dic.Add("菋", "akfi");
            dic.Add("囏", "akfk");
            dic.Add("戁", "akfn");
            dic.Add("歎", "akfw");
            dic.Add("臡", "akfw");
            dic.Add("尀", "akfy");
            dic.Add("難", "akfy");
            dic.Add("鄞", "akgb");
            dic.Add("戜", "akgd");
            dic.Add("茣", "akgd");
            dic.Add("彧", "akge");
            dic.Add("堇", "akgf");
            dic.Add("勤", "akgl");
            dic.Add("懃", "akgn");
            dic.Add("觐", "akgq");
            dic.Add("覲", "akgq");
            dic.Add("斳", "akgr");
            dic.Add("藪", "akgt");
            dic.Add("蔞", "akgv");
            dic.Add("歏", "akgw");
            dic.Add("匮", "akh");
            dic.Add("蕗", "akhk");
            dic.Add("蒉", "akhm");
            dic.Add("匱", "akhm");
            dic.Add("蕢", "akhm");
            dic.Add("莡", "akhu");
            dic.Add("颧", "akk");
            dic.Add("鄿", "akkb");
            dic.Add("酄", "akkb");
            dic.Add("敺", "akkc");
            dic.Add("毆", "akkc");
            dic.Add("莒", "akkf");
            dic.Add("匰", "akkf");
            dic.Add("蕇", "akkf");
            dic.Add("鹳", "akkg");
            dic.Add("剾", "akkj");
            dic.Add("飌", "akkj");
            dic.Add("區", "akkk");
            dic.Add("虈", "akkk");
            dic.Add("勸", "akkl");
            dic.Add("顴", "akkm");
            dic.Add("萼", "akkn");
            dic.Add("甌", "akkn");
            dic.Add("蕚", "akkn");
            dic.Add("鷗", "akko");
            dic.Add("鸛", "akko");
            dic.Add("觀", "akkq");
            dic.Add("蘄", "akkr");
            dic.Add("歐", "akkw");
            dic.Add("歡", "akkw");
            dic.Add("雚", "akky");
            dic.Add("莂", "aklj");
            dic.Add("莴", "akm");
            dic.Add("蒷", "akmu");
            dic.Add("荶", "akwn");
            dic.Add("蓶", "akwy");
            dic.Add("功", "al");
            dic.Add("蔮", "alag");
            dic.Add("艻", "alb");
            dic.Add("蘻", "albi");
            dic.Add("藣", "alcx");
            dic.Add("茵", "ald");
            dic.Add("蘮", "aldj");
            dic.Add("蒽", "aldn");
            dic.Add("蔑", "aldt");
            dic.Add("苗", "alf");
            dic.Add("薗", "alfe");
            dic.Add("薯", "alfj");
            dic.Add("蓒", "alfj");
            dic.Add("巭", "alfw");
            dic.Add("葨", "alge");
            dic.Add("莗", "alj");
            dic.Add("匣", "alk");
            dic.Add("茴", "alk");
            dic.Add("茄", "alkf");
            dic.Add("荔", "all");
            dic.Add("莮", "allb");
            dic.Add("蘲", "allf");
            dic.Add("虆", "alli");
            dic.Add("藟", "alll");
            dic.Add("蘽", "alls");
            dic.Add("蕒", "almu");
            dic.Add("葸", "alnu");
            dic.Add("莲", "alp");
            dic.Add("薎", "alpa");
            dic.Add("鄸", "alpb");
            dic.Add("蘉", "alpc");
            dic.Add("瞢", "alph");
            dic.Add("顭", "alpm");
            dic.Add("甍", "alpn");
            dic.Add("夢", "alpq");
            dic.Add("蓮", "alpu");
            dic.Add("薨", "alpx");
            dic.Add("萝", "alq");
            dic.Add("鹋", "alqg");
            dic.Add("薥", "alqj");
            dic.Add("蔪", "alrj");
            dic.Add("菌", "alt");
            dic.Add("蔨", "alub");
            dic.Add("匦", "alv");
            dic.Add("匭", "alvv");
            dic.Add("苏", "alw");
            dic.Add("蒕", "alwl");
            dic.Add("莔", "alwm");
            dic.Add("鶓", "alwo");
            dic.Add("苬", "alwu");
            dic.Add("蔂", "alxi");
            dic.Add("蘿", "alxy");
            dic.Add("藅", "alyj");
            dic.Add("贡", "am");
            dic.Add("蕽", "amae");
            dic.Add("芁", "amb");
            dic.Add("芟", "amc");
            dic.Add("英", "amd");
            dic.Add("鶧", "amdo");
            dic.Add("蓇", "amef");
            dic.Add("苒", "amf");
            dic.Add("苖", "amf");
            dic.Add("巬", "amfw");
            dic.Add("茼", "amg");
            dic.Add("匝", "amh");
            dic.Add("萜", "amh");
            dic.Add("繭", "amhj");
            dic.Add("芇", "amhj");
            dic.Add("顢", "amhm");
            dic.Add("荝", "amjj");
            dic.Add("萴", "amjj");
            dic.Add("苘", "amk");
            dic.Add("蘡", "ammv");
            dic.Add("萵", "amnk");
            dic.Add("薖", "amnp");
            dic.Add("慐", "amnu");
            dic.Add("苋", "amq");
            dic.Add("葻", "amtj");
            dic.Add("貢", "amu");
            dic.Add("貣", "amu");
            dic.Add("菵", "amun");
            dic.Add("黄", "amw");
            dic.Add("芮", "amw");
            dic.Add("斢", "amwf");
            dic.Add("黊", "amwf");
            dic.Add("黈", "amwg");
            dic.Add("黇", "amwk");
            dic.Add("黅", "amwn");
            dic.Add("鷬", "amwo");
            dic.Add("黆", "amwq");
            dic.Add("萞", "amwx");
            dic.Add("巩", "amy");
            dic.Add("聓", "amyb");
            dic.Add("鞏", "amyf");
            dic.Add("跫", "amyh");
            dic.Add("蛩", "amyj");
            dic.Add("恐", "amyn");
            dic.Add("銎", "amyq");
            dic.Add("芃", "amyu");
            dic.Add("世", "an");
            dic.Add("苠", "ana");
            dic.Add("艺", "anb");
            dic.Add("芑", "anb");
            dic.Add("巨", "and");
            dic.Add("蔚", "anf");
            dic.Add("藯", "anfn");
            dic.Add("戼", "angn");
            dic.Add("蔬", "anh");
            dic.Add("葭", "anhc");
            dic.Add("匨", "anhf");
            dic.Add("莊", "anhf");
            dic.Add("葿", "anhf");
            dic.Add("蔣", "anhf");
            dic.Add("葦", "anhh");
            dic.Add("蘠", "anhk");
            dic.Add("苢", "anhn");
            dic.Add("蕸", "anhp");
            dic.Add("荍", "anht");
            dic.Add("忒", "ani");
            dic.Add("螶", "anjj");
            dic.Add("斲", "anjr");
            dic.Add("薜", "ank");
            dic.Add("蘗", "anks");
            dic.Add("贳", "anm");
            dic.Add("勚", "anml");
            dic.Add("勩", "anml");
            dic.Add("貰", "anmu");
            dic.Add("蕊", "ann");
            dic.Add("乬", "annb");
            dic.Add("巪", "annb");
            dic.Add("蘂", "anns");
            dic.Add("迣", "anpv");
            dic.Add("枼", "ansu");
            dic.Add("荱", "antn");
            dic.Add("苾", "antr");
            dic.Add("戉", "anty");
            dic.Add("芯", "anu");
            dic.Add("荬", "anud");
            dic.Add("蓼", "anw");
            dic.Add("芵", "anwu");
            dic.Add("藋", "anwy");
            dic.Add("苨", "anxb");
            dic.Add("苡", "any");
            dic.Add("蘹", "anye");
            dic.Add("荩", "anyu");
            dic.Add("蒌", "ao");
            dic.Add("薮", "ao");
            dic.Add("薠", "aodm");
            dic.Add("蘱", "aodm");
            dic.Add("蕿", "aoec");
            dic.Add("薱", "aogf");
            dic.Add("蔊", "aojf");
            dic.Add("藀", "aooo");
            dic.Add("菼", "aoou");
            dic.Add("蒾", "aopu");
            dic.Add("炗", "aou");
            dic.Add("苂", "aou");
            dic.Add("芝", "ap");
            dic.Add("营", "ap");
            dic.Add("茡", "apbf");
            dic.Add("菪", "apd");
            dic.Add("藔", "apdi");
            dic.Add("萓", "apeg");
            dic.Add("茔", "apff");
            dic.Add("蒄", "apff");
            dic.Add("鹲", "apfg");
            dic.Add("萗", "apfi");
            dic.Add("蔻", "apfl");
            dic.Add("氋", "apfn");
            dic.Add("鸏", "apfo");
            dic.Add("莞", "apfq");
            dic.Add("藆", "apfr");
            dic.Add("蔲", "apft");
            dic.Add("蒙", "apg");
            dic.Add("苎", "apgf");
            dic.Add("荢", "apgf");
            dic.Add("萱", "apgg");
            dic.Add("萣", "apgh");
            dic.Add("薲", "apgm");
            dic.Add("藼", "apgn");
            dic.Add("蔩", "apgw");
            dic.Add("莹", "apgy");
            dic.Add("荥", "api");
            dic.Add("萤", "apj");
            dic.Add("蓂", "apju");
            dic.Add("劳", "apl");
            dic.Add("荤", "aplj");
            dic.Add("葷", "aplj");
            dic.Add("茕", "apn");
            dic.Add("藌", "apnj");
            dic.Add("蔤", "apnm");
            dic.Add("菅", "apnn");
            dic.Add("薴", "apns");
            dic.Add("荧", "apo");
            dic.Add("莺", "apq");
            dic.Add("菀", "apqb");
            dic.Add("蓥", "apqf");
            dic.Add("蒬", "apqy");
            dic.Add("荦", "apr");
            dic.Add("荣", "aps");
            dic.Add("蒏", "apsg");
            dic.Add("苧", "apsj");
            dic.Add("荌", "apvf");
            dic.Add("藛", "apvo");
            dic.Add("蓉", "apw");
            dic.Add("葖", "apwd");
            dic.Add("蓿", "apwj");
            dic.Add("", "apwl");
            dic.Add("茓", "apwu");
            dic.Add("藭", "apwx");
            dic.Add("蒮", "apwy");
            dic.Add("萦", "apx");
            dic.Add("区", "aq");
            dic.Add("获", "aq");
            dic.Add("芪", "aqa");
            dic.Add("荈", "aqah");
            dic.Add("鬵", "aqah");
            dic.Add("朁", "aqaj");
            dic.Add("蠶", "aqaj");
            dic.Add("兓", "aqaq");
            dic.Add("茋", "aqay");
            dic.Add("苑", "aqb");
            dic.Add("茒", "aqbj");
            dic.Add("葾", "aqbn");
            dic.Add("葼", "aqbt");
            dic.Add("蒭", "aqbt");
            dic.Add("芶", "aqcu");
            dic.Add("莃", "aqdh");
            dic.Add("薝", "aqdy");
            dic.Add("蔛", "aqef");
            dic.Add("薢", "aqeh");
            dic.Add("葪", "aqej");
            dic.Add("菳", "aqf");
            dic.Add("葡", "aqg");
            dic.Add("茚", "aqgb");
            dic.Add("藓", "aqgd");
            dic.Add("蓟", "aqgj");
            dic.Add("蔔", "aqgl");
            dic.Add("瓯", "aqgn");
            dic.Add("荀", "aqj");
            dic.Add("苅", "aqjj");
            dic.Add("敬", "aqk");
            dic.Add("茗", "aqk");
            dic.Add("菟", "aqk");
            dic.Add("驚", "aqkc");
            dic.Add("苟", "aqkf");
            dic.Add("蟼", "aqkj");
            dic.Add("葂", "aqkl");
            dic.Add("憼", "aqkn");
            dic.Add("莬", "aqkq");
            dic.Add("擎", "aqkr");
            dic.Add("檠", "aqks");
            dic.Add("警", "aqky");
            dic.Add("殴", "aqm");
            dic.Add("藑", "aqmt");
            dic.Add("萯", "aqmu");
            dic.Add("苞", "aqn");
            dic.Add("菊", "aqo");
            dic.Add("蘚", "aqod");
            dic.Add("薊", "aqoj");
            dic.Add("蘇", "aqot");
            dic.Add("炁", "aqou");
            dic.Add("帶", "aqph");
            dic.Add("慸", "aqpn");
            dic.Add("遰", "aqpp");
            dic.Add("欧", "aqq");
            dic.Add("鸥", "aqqg");
            dic.Add("茤", "aqqu");
            dic.Add("萄", "aqr");
            dic.Add("匢", "aqre");
            dic.Add("匫", "aqrj");
            dic.Add("葱", "aqrn");
            dic.Add("蔸", "aqrq");
            dic.Add("芴", "aqrr");
            dic.Add("茐", "aqry");
            dic.Add("蔱", "aqsc");
            dic.Add("茆", "aqtb");
            dic.Add("莥", "aqtf");
            dic.Add("蕕", "aqtg");
            dic.Add("蕏", "aqtj");
            dic.Add("莸", "aqtn");
            dic.Add("荻", "aqto");
            dic.Add("艾", "aqu");
            dic.Add("芕", "aqu");
            dic.Add("匹", "aqv");
            dic.Add("兂", "aqv");
            dic.Add("旡", "aqv");
            dic.Add("萏", "aqvf");
            dic.Add("芡", "aqw");
            dic.Add("蕵", "aqwe");
            dic.Add("鴄", "aqwo");
            dic.Add("鴎", "aqwo");
            dic.Add("鴱", "aqwo");
            dic.Add("芍", "aqy");
            dic.Add("茑", "aqy");
            dic.Add("鸢", "aqyg");
            dic.Add("匛", "aqyi");
            dic.Add("藰", "aqyj");
            dic.Add("蒥", "aqyl");
            dic.Add("匠", "ar");
            dic.Add("芹", "ar");
            dic.Add("葩", "arc");
            dic.Add("萚", "arch");
            dic.Add("苽", "arcy");
            dic.Add("蓏", "arcy");
            dic.Add("菝", "ard");
            dic.Add("蘤", "areo");
            dic.Add("苩", "arf");
            dic.Add("荴", "arfw");
            dic.Add("茊", "argf");
            dic.Add("葟", "argf");
            dic.Add("蓵", "argh");
            dic.Add("茩", "argk");
            dic.Add("蒱", "argy");
            dic.Add("茱", "ari");
            dic.Add("薬", "aris");
            dic.Add("莏", "arit");
            dic.Add("葲", "ariu");
            dic.Add("蘀", "arlf");
            dic.Add("蕪", "arlo");
            dic.Add("菗", "armf");
            dic.Add("蒛", "armw");
            dic.Add("芞", "arnb");
            dic.Add("菦", "arpu");
            dic.Add("蒐", "arqc");
            dic.Add("菢", "arqn");
            dic.Add("菂", "arqy");
            dic.Add("藠", "arrr");
            dic.Add("萆", "art");
            dic.Add("葀", "artd");
            dic.Add("菈", "aruf");
            dic.Add("蒑", "arvc");
            dic.Add("萔", "arvk");
            dic.Add("苵", "arwu");
            dic.Add("蓷", "arwy");
            dic.Add("薂", "aryt");
            dic.Add("苛", "as");
            dic.Add("蘸", "as");
            dic.Add("藲", "asak");
            dic.Add("茜", "asf");
            dic.Add("荰", "asff");
            dic.Add("蓕", "asff");
            dic.Add("蔈", "asfi");
            dic.Add("薽", "asfn");
            dic.Add("苯", "asg");
            dic.Add("莤", "asgf");
            dic.Add("蓜", "asgn");
            dic.Add("葙", "ash");
            dic.Add("蕈", "asj");
            dic.Add("艼", "asj");
            dic.Add("莕", "askf");
            dic.Add("萙", "aspq");
            dic.Add("菥", "asr");
            dic.Add("菻", "assu");
            dic.Add("葽", "asvf");
            dic.Add("菘", "asw");
            dic.Add("藮", "aswo");
            dic.Add("萊", "asww");
            dic.Add("蒁", "asyp");
            dic.Add("攻", "at");
            dic.Add("医", "at");
            dic.Add("苌", "ata");
            dic.Add("殹", "atdc");
            dic.Add("醫", "atdg");
            dic.Add("鹥", "atdg");
            dic.Add("瞖", "atdh");
            dic.Add("莑", "atdh");
            dic.Add("繄", "atdi");
            dic.Add("荞", "atdj");
            dic.Add("蕎", "atdk");
            dic.Add("贀", "atdm");
            dic.Add("翳", "atdn");
            dic.Add("悘", "atdn");
            dic.Add("鷖", "atdo");
            dic.Add("黳", "atdo");
            dic.Add("蓬", "atdp");
            dic.Add("芺", "atdu");
            dic.Add("嫛", "atdv");
            dic.Add("毉", "atdw");
            dic.Add("瑿", "atdy");
            dic.Add("薙", "atdy");
            dic.Add("莠", "ate");
            dic.Add("蒰", "atec");
            dic.Add("蒩", "ateg");
            dic.Add("芊", "atf");
            dic.Add("荇", "atfh");
            dic.Add("蓗", "atfh");
            dic.Add("芼", "atfn");
            dic.Add("莛", "atfp");
            dic.Add("薐", "atft");
            dic.Add("董", "atg");
            dic.Add("苼", "atgf");
            dic.Add("菙", "atgf");
            dic.Add("蘍", "atgl");
            dic.Add("翘", "atgn");
            dic.Add("薰", "atgo");
            dic.Add("薫", "atgo");
            dic.Add("尧", "atgq");
            dic.Add("蓰", "ath");
            dic.Add("匴", "atha");
            dic.Add("苲", "athf");
            dic.Add("蒠", "athn");
            dic.Add("莚", "athp");
            dic.Add("蕱", "atie");
            dic.Add("葕", "atih");
            dic.Add("莉", "atj");
            dic.Add("萫", "atjf");
            dic.Add("藒", "atjn");
            dic.Add("茖", "atkf");
            dic.Add("萂", "atkf");
            dic.Add("莵", "atky");
            dic.Add("萭", "atky");
            dic.Add("蓖", "atl");
            dic.Add("蔥", "atln");
            dic.Add("薇", "atm");
            dic.Add("薁", "atmd");
            dic.Add("蘈", "atmm");
            dic.Add("藢", "atmt");
            dic.Add("蕃", "ato");
            dic.Add("萩", "atou");
            dic.Add("藜", "atq");
            dic.Add("蘅", "atqh");
            dic.Add("蘒", "atqn");
            dic.Add("蘓", "atqo");
            dic.Add("蔾", "atqs");
            dic.Add("菞", "atqt");
            dic.Add("莪", "atr");
            dic.Add("蓹", "atrb");
            dic.Add("薭", "atrf");
            dic.Add("蘌", "atri");
            dic.Add("蘒", "attg");
            dic.Add("蕧", "attt");
            dic.Add("萪", "atuf");
            dic.Add("苸", "atuh");
            dic.Add("蕛", "atut");
            dic.Add("苳", "atuu");
            dic.Add("萎", "atv");
            dic.Add("蘶", "atvc");
            dic.Add("葎", "atvh");
            dic.Add("萟", "atvy");
            dic.Add("蓯", "atwh");
            dic.Add("蒣", "atwt");
            dic.Add("莓", "atx");
            dic.Add("蘩", "atxi");
            dic.Add("藊", "atya");
            dic.Add("燕", "au");
            dic.Add("蒋", "au");
            dic.Add("荓", "auaj");
            dic.Add("蒴", "aub");
            dic.Add("蓘", "auce");
            dic.Add("萒", "aucq");
            dic.Add("蒫", "auda");
            dic.Add("菤", "audb");
            dic.Add("藙", "auec");
            dic.Add("蘢", "aued");
            dic.Add("蕑", "auef");
            dic.Add("葥", "auej");
            dic.Add("苙", "auf");
            dic.Add("菛", "auf");
            dic.Add("荘", "auff");
            dic.Add("蓤", "auft");
            dic.Add("蘭", "augi");
            dic.Add("蓔", "augo");
            dic.Add("葁", "augv");
            dic.Add("虁", "auht");
            dic.Add("莘", "auj");
            dic.Add("萻", "aujf");
            dic.Add("蕫", "aujf");
            dic.Add("蕳", "aujf");
            dic.Add("蔁", "aujj");
            dic.Add("薏", "aujn");
            dic.Add("蕲", "aujr");
            dic.Add("菩", "auk");
            dic.Add("蔀", "aukb");
            dic.Add("酀", "aukb");
            dic.Add("蔉", "auke");
            dic.Add("蔄", "aukf");
            dic.Add("鷰", "auko");
            dic.Add("莌", "aukq");
            dic.Add("嬊", "aukv");
            dic.Add("蔽", "aum");
            dic.Add("蔐", "aumd");
            dic.Add("蔏", "aumk");
            dic.Add("藡", "aump");
            dic.Add("虌", "aumv");
            dic.Add("蕄", "aunu");
            dic.Add("蒂", "aup");
            dic.Add("蒡", "aupy");
            dic.Add("蒟", "auqk");
            dic.Add("薋", "auqm");
            dic.Add("茭", "auqu");
            dic.Add("茨", "auqw");
            dic.Add("藱", "aurc");
            dic.Add("薪", "aus");
            dic.Add("藽", "ausq");
            dic.Add("蒺", "aut");
            dic.Add("蒹", "auv");
            dic.Add("菨", "auvf");
            dic.Add("蔅", "auvf");
            dic.Add("蔺", "auw");
            dic.Add("藺", "auwy");
            dic.Add("苝", "auxb");
            dic.Add("切", "av");
            dic.Add("萧", "av");
            dic.Add("蕁", "avaf");
            dic.Add("艽", "avb");
            dic.Add("芀", "avb");
            dic.Add("莭", "avcb");
            dic.Add("蔇", "avcq");
            dic.Add("菇", "avd");
            dic.Add("薅", "avd");
            dic.Add("茛", "ave");
            dic.Add("荨", "avf");
            dic.Add("茟", "avfh");
            dic.Add("蕭", "avfj");
            dic.Add("藇", "avgw");
            dic.Add("蓃", "avhc");
            dic.Add("藎", "avhl");
            dic.Add("菉", "aviu");
            dic.Add("茹", "avk");
            dic.Add("苕", "avk");
            dic.Add("蕠", "avki");
            dic.Add("蒘", "avkr");
            dic.Add("菑", "avlf");
            dic.Add("虋", "avmv");
            dic.Add("菷", "avph");
            dic.Add("萖", "avqb");
            dic.Add("蕮", "avqo");
            dic.Add("莙", "avtk");
            dic.Add("蔒", "avto");
            dic.Add("芛", "avtr");
            dic.Add("茘", "avvv");
            dic.Add("葌", "avvv");
            dic.Add("萸", "avw");
            dic.Add("芄", "avy");
            dic.Add("袃", "avye");
            dic.Add("荵", "avyn");
            dic.Add("共", "aw");
            dic.Add("花", "aw");
            dic.Add("茷", "awar");
            dic.Add("苍", "awb");
            dic.Add("蓊", "awc");
            dic.Add("葰", "awct");
            dic.Add("茯", "awd");
            dic.Add("葮", "awdc");
            dic.Add("芿", "aweb");
            dic.Add("蔡", "awf");
            dic.Add("荟", "awfc");
            dic.Add("茌", "awff");
            dic.Add("芢", "awff");
            dic.Add("苻", "awfu");
            dic.Add("葵", "awg");
            dic.Add("菕", "awga");
            dic.Add("葊", "awga");
            dic.Add("蘥", "awga");
            dic.Add("蒨", "awge");
            dic.Add("荃", "awgf");
            dic.Add("莶", "awgi");
            dic.Add("剳", "awgj");
            dic.Add("匬", "awgj");
            dic.Add("萮", "awgj");
            dic.Add("薈", "awgj");
            dic.Add("匼", "awgk");
            dic.Add("荅", "awgk");
            dic.Add("蔹", "awgt");
            dic.Add("蘞", "awgt");
            dic.Add("匳", "awgw");
            dic.Add("薟", "awgw");
            dic.Add("蘝", "awgw");
            dic.Add("莜", "awh");
            dic.Add("蓚", "awhe");
            dic.Add("蓨", "awhe");
            dic.Add("蓧", "awhs");
            dic.Add("苶", "awiu");
            dic.Add("芥", "awj");
            dic.Add("蛬", "awju");
            dic.Add("葆", "awk");
            dic.Add("藵", "awke");
            dic.Add("茽", "awkh");
            dic.Add("輂", "awlj");
            dic.Add("苮", "awmj");
            dic.Add("巷", "awn");
            dic.Add("恭", "awn");
            dic.Add("孽", "awnb");
            dic.Add("葔", "awnd");
            dic.Add("蒒", "awnh");
            dic.Add("蘬", "awnh");
            dic.Add("躠", "awnh");
            dic.Add("糵", "awno");
            dic.Add("蘖", "awns");
            dic.Add("薛", "awnu");
            dic.Add("拲", "awrj");
            dic.Add("茶", "aws");
            dic.Add("荷", "awsk");
            dic.Add("茠", "awsu");
            dic.Add("荼", "awt");
            dic.Add("荏", "awtf");
            dic.Add("莋", "awtf");
            dic.Add("鷋", "awto");
            dic.Add("莅", "awuf");
            dic.Add("蓓", "awuk");
            dic.Add("芬", "awv");
            dic.Add("葠", "awvc");
            dic.Add("葐", "awvl");
            dic.Add("蔦", "awvo");
            dic.Add("鳶", "awvo");
            dic.Add("棻", "awvs");
            dic.Add("巫", "aww");
            dic.Add("莝", "awwf");
            dic.Add("葅", "awwg");
            dic.Add("鹀", "awwg");
            dic.Add("鵐", "awwo");
            dic.Add("遳", "awwp");
            dic.Add("觋", "awwq");
            dic.Add("覡", "awwq");
            dic.Add("蓌", "awwt");
            dic.Add("苁", "awwu");
            dic.Add("芲", "awxb");
            dic.Add("蕟", "awxc");
            dic.Add("蒊", "awxx");
            dic.Add("蕉", "awy");
            dic.Add("苓", "awyc");
            dic.Add("蒦", "awyc");
            dic.Add("萑", "awyf");
            dic.Add("隿", "awyg");
            dic.Add("劐", "awyj");
            dic.Add("莟", "awyk");
            dic.Add("蒼", "awyk");
            dic.Add("芩", "awyn");
            dic.Add("菍", "awyn");
            dic.Add("舊", "awyv");
            dic.Add("药", "ax");
            dic.Add("蕴", "ax");
            dic.Add("荭", "axa");
            dic.Add("葒", "axaf");
            dic.Add("虇", "axay");
            dic.Add("芎", "axb");
            dic.Add("葞", "axbf");
            dic.Add("苰", "axcu");
            dic.Add("藧", "axec");
            dic.Add("蒃", "axeu");
            dic.Add("荮", "axf");
            dic.Add("蘏", "axfm");
            dic.Add("葤", "axfu");
            dic.Add("莼", "axg");
            dic.Add("蒓", "axgn");
            dic.Add("苺", "axgu");
            dic.Add("苐", "axht");
            dic.Add("蘰", "axjc");
            dic.Add("茀", "axjj");
            dic.Add("藴", "axjl");
            dic.Add("蔃", "axkj");
            dic.Add("苭", "axlb");
            dic.Add("蘊", "axll");
            dic.Add("蒳", "axmw");
            dic.Add("蕝", "axqc");
            dic.Add("葯", "axqy");
            dic.Add("藥", "axrs");
            dic.Add("芗", "axt");
            dic.Add("薌", "axtb");
            dic.Add("薿", "axth");
            dic.Add("蘔", "axtm");
            dic.Add("蘕", "axtp");
            dic.Add("蔠", "axtu");
            dic.Add("蒻", "axuu");
            dic.Add("蒶", "axwv");
            dic.Add("芘", "axx");
            dic.Add("荜", "axxf");
            dic.Add("蕬", "axxi");
            dic.Add("蒈", "axxr");
            dic.Add("茲", "axxu");
            dic.Add("虊", "axys");
            dic.Add("芳", "ay");
            dic.Add("荒", "ay");
            dic.Add("蔗", "aya");
            dic.Add("蓆", "ayah");
            dic.Add("蓠", "aybc");
            dic.Add("蘺", "ayby");
            dic.Add("茺", "ayc");
            dic.Add("虀", "aydg");
            dic.Add("蓭", "aydn");
            dic.Add("蘐", "ayec");
            dic.Add("藷", "ayfj");
            dic.Add("苄", "ayh");
            dic.Add("蔼", "ayj");
            dic.Add("薺", "ayjf");
            dic.Add("萕", "ayjf");
            dic.Add("荠", "ayjj");
            dic.Add("藹", "ayjn");
            dic.Add("蓑", "ayk");
            dic.Add("蘘", "ayke");
            dic.Add("蒿", "aym");
            dic.Add("苀", "aymb");
            dic.Add("蔎", "aymc");
            dic.Add("藁", "ayms");
            dic.Add("藳", "aymt");
            dic.Add("匟", "aymv");
            dic.Add("藃", "aymw");
            dic.Add("芒", "ayn");
            dic.Add("匾", "ayna");
            dic.Add("萹", "ayna");
            dic.Add("蔰", "aync");
            dic.Add("菺", "ayne");
            dic.Add("薼", "aynf");
            dic.Add("莣", "aynn");
            dic.Add("薦", "ayno");
            dic.Add("藨", "ayno");
            dic.Add("蘪", "ayno");
            dic.Add("芦", "aynr");
            dic.Add("荄", "aynw");
            dic.Add("蔍", "aynx");
            dic.Add("葶", "ayp");
            dic.Add("薧", "aypx");
            dic.Add("菧", "ayqy");
            dic.Add("蘑", "ays");
            dic.Add("蘼", "ays");
            dic.Add("藦", "aysr");
            dic.Add("蔴", "ayss");
            dic.Add("蔟", "ayt");
            dic.Add("葹", "aytb");
            dic.Add("蔙", "ayth");
            dic.Add("蒍", "ayto");
            dic.Add("芠", "ayu");
            dic.Add("薕", "ayuo");
            dic.Add("莨", "ayv");
            dic.Add("蓈", "ayvb");
            dic.Add("蓢", "ayve");
            dic.Add("蓎", "ayvk");
            dic.Add("菮", "ayvw");
            dic.Add("萃", "ayw");
            dic.Add("蓙", "aywf");
            dic.Add("菸", "aywu");
            dic.Add("蓄", "ayx");
            dic.Add("蕹", "ayxy");
            dic.Add("了", "b");
            dic.Add("子", "b");
            dic.Add("陈", "ba");
            dic.Add("陿", "badw");
            dic.Add("隁", "bajv");
            dic.Add("聝", "bakg");
            dic.Add("聀", "bat");
            dic.Add("孨", "bbbf");
            dic.Add("聶", "bbbf");
            dic.Add("孴", "bbbj");
            dic.Add("顳", "bbbm");
            dic.Add("陬", "bbc");
            dic.Add("孖", "bbg");
            dic.Add("聑", "bbg");
            dic.Add("耶", "bbh");
            dic.Add("聉", "bbmh");
            dic.Add("阤", "bbn");
            dic.Add("取", "bc");
            dic.Add("陉", "bca");
            dic.Add("郰", "bcbh");
            dic.Add("聂", "bcc");
            dic.Add("颞", "bccm");
            dic.Add("埾", "bcff");
            dic.Add("孡", "bckg");
            dic.Add("焣", "bcou");
            dic.Add("阭", "bcqn");
            dic.Add("棸", "bcsu");
            dic.Add("聚", "bct");
            dic.Add("鄹", "bctb");
            dic.Add("娶", "bcv");
            dic.Add("陖", "bcwt");
            dic.Add("承", "bd");
            dic.Add("隋", "bda");
            dic.Add("隓", "bdaa");
            dic.Add("墮", "bdaf");
            dic.Add("嶞", "bdam");
            dic.Add("隳", "bdan");
            dic.Add("隨", "bdap");
            dic.Add("阨", "bdbn");
            dic.Add("耾", "bdcy");
            dic.Add("随", "bde");
            dic.Add("堕", "bdef");
            dic.Add("陏", "bdeg");
            dic.Add("陙", "bdfe");
            dic.Add("陓", "bdfn");
            dic.Add("隇", "bdgt");
            dic.Add("陌", "bdj");
            dic.Add("陫", "bdjd");
            dic.Add("陾", "bdmd");
            dic.Add("聏", "bdmj");
            dic.Add("陑", "bdmj");
            dic.Add("陭", "bdsk");
            dic.Add("陦", "bdtf");
            dic.Add("陝", "bdty");
            dic.Add("聗", "bdww");
            dic.Add("陜", "bdww");
            dic.Add("陇", "bdx");
            dic.Add("阴", "be");
            dic.Add("隱", "bean");
            dic.Add("檃", "beas");
            dic.Add("櫽", "beas");
            dic.Add("阻", "begg");
            dic.Add("隠", "bevn");
            dic.Add("际", "bf");
            dic.Add("隫", "bfam");
            dic.Add("耺", "bfcy");
            dic.Add("阹", "bfcy");
            dic.Add("孺", "bfd");
            dic.Add("隭", "bfdj");
            dic.Add("隢", "bffq");
            dic.Add("陡", "bfh");
            dic.Add("阱", "bfj");
            dic.Add("聐", "bfkg");
            dic.Add("聴", "bfln");
            dic.Add("陆", "bfm");
            dic.Add("隯", "bfnf");
            dic.Add("阮", "bfq");
            dic.Add("陼", "bftj");
            dic.Add("陵", "bfw");
            dic.Add("陸", "bfwf");
            dic.Add("卫", "bg");
            dic.Add("陚", "bgah");
            dic.Add("孒", "bgd");
            dic.Add("聙", "bgeg");
            dic.Add("陠", "bgey");
            dic.Add("孲", "bgfg");
            dic.Add("聽", "bgfn");
            dic.Add("耳", "bgh");
            dic.Add("聇", "bghg");
            dic.Add("阷", "bghg");
            dic.Add("阫", "bgiy");
            dic.Add("陳", "bgji");
            dic.Add("螴", "bgjj");
            dic.Add("敶", "bgjt");
            dic.Add("隔", "bgk");
            dic.Add("陋", "bgm");
            dic.Add("陃", "bgmw");
            dic.Add("阢", "bgq");
            dic.Add("隞", "bgqt");
            dic.Add("陕", "bgu");
            dic.Add("陘", "bgva");
            dic.Add("隬", "bgwq");
            dic.Add("耻", "bh");
            dic.Add("隵", "bhaa");
            dic.Add("芔", "bhbh");
            dic.Add("陂", "bhc");
            dic.Add("阯", "bhg");
            dic.Add("蚩", "bhgj");
            dic.Add("旹", "bhgj");
            dic.Add("妛", "bhgv");
            dic.Add("陟", "bhi");
            dic.Add("骘", "bhic");
            dic.Add("騭", "bhic");
            dic.Add("屮", "bhk");
            dic.Add("阽", "bhkg");
            dic.Add("孙", "bi");
            dic.Add("函", "bib");
            dic.Add("顄", "bibm");
            dic.Add("陗", "bieg");
            dic.Add("丞", "big");
            dic.Add("卺", "bigb");
            dic.Add("脀", "bige");
            dic.Add("巹", "bign");
            dic.Add("烝", "bigo");
            dic.Add("氶", "bii");
            dic.Add("隙", "bij");
            dic.Add("逊", "bip");
            dic.Add("隚", "bipf");
            dic.Add("聎", "biqn");
            dic.Add("隲", "bitc");
            dic.Add("阥", "biy");
            dic.Add("阳", "bj");
            dic.Add("陧", "bjf");
            dic.Add("隄", "bjgh");
            dic.Add("陽", "bjgr");
            dic.Add("刵", "bjh");
            dic.Add("隅", "bjm");
            dic.Add("隰", "bjx");
            dic.Add("职", "bk");
            dic.Add("亟", "bkc");
            dic.Add("凾", "bkcb");
            dic.Add("焏", "bkco");
            dic.Add("叾", "bkf");
            dic.Add("聖", "bkgf");
            dic.Add("聩", "bkh");
            dic.Add("聵", "bkhm");
            dic.Add("隤", "bkhm");
            dic.Add("陨", "bkm");
            dic.Add("隕", "bkmy");
            dic.Add("阵", "bl");
            dic.Add("孟", "blf");
            dic.Add("塦", "blff");
            dic.Add("隈", "blge");
            dic.Add("陣", "blh");
            dic.Add("勐", "bll");
            dic.Add("阞", "bln");
            dic.Add("出", "bm");
            dic.Add("祟", "bmf");
            dic.Add("聃", "bmfg");
            dic.Add("耼", "bmfg");
            dic.Add("聘", "bmg");
            dic.Add("隑", "bmgu");
            dic.Add("孾", "bmmv");
            dic.Add("粜", "bmo");
            dic.Add("糶", "bmoy");
            dic.Add("欪", "bmqw");
            dic.Add("孭", "bmy");
            dic.Add("也", "bn");
            dic.Add("阠", "bnfh");
            dic.Add("卩", "bnh");
            dic.Add("阝", "bnh");
            dic.Add("凵", "bnh");
            dic.Add("孑", "bnhg");
            dic.Add("隦", "bnku");
            dic.Add("孔", "bnn");
            dic.Add("巜", "bnn");
            dic.Add("耴", "bnn");
            dic.Add("", "bnn");
            dic.Add("孞", "bnu");
            dic.Add("恥", "bny");
            dic.Add("耿", "bo");
            dic.Add("隣", "boqh");
            dic.Add("隣", "boqh");
            dic.Add("阦", "boy");
            dic.Add("褧", "boye");
            dic.Add("辽", "bp");
            dic.Add("院", "bp");
            dic.Add("孮", "bpfi");
            dic.Add("聢", "bpgh");
            dic.Add("聹", "bpns");
            dic.Add("耽", "bpq");
            dic.Add("聍", "bps");
            dic.Add("迆", "bpv");
            dic.Add("聜", "bpwa");
            dic.Add("聺", "bpwi");
            dic.Add("陀", "bpx");
            dic.Add("隐", "bq");
            dic.Add("聊", "bq");
            dic.Add("阺", "bqay");
            dic.Add("陒", "bqdb");
            dic.Add("聸", "bqdy");
            dic.Add("陥", "bqhj");
            dic.Add("孢", "bqn");
            dic.Add("陱", "bqoy");
            dic.Add("陊", "bqqy");
            dic.Add("陶", "bqr");
            dic.Add("聦", "bqrn");
            dic.Add("陷", "bqv");
            dic.Add("孤", "br");
            dic.Add("阪", "br");
            dic.Add("隍", "brg");
            dic.Add("陎", "briy");
            dic.Add("隗", "brq");
            dic.Add("聭", "brqc");
            dic.Add("陴", "brt");
            dic.Add("聛", "brtf");
            dic.Add("阿", "bs");
            dic.Add("耵", "bs");
            dic.Add("陻", "bsfg");
            dic.Add("娿", "bskv");
            dic.Add("降", "bt");
            dic.Add("隆", "bt");
            dic.Add("陞", "btaf");
            dic.Add("阩", "btah");
            dic.Add("陹", "btaj");
            dic.Add("艸", "btbh");
            dic.Add("茻", "btbh");
            dic.Add("陁", "btbn");
            dic.Add("聒", "btd");
            dic.Add("聅", "btdy");
            dic.Add("阡", "btf");
            dic.Add("聕", "btfk");
            dic.Add("毦", "btfn");
            dic.Add("陲", "btgf");
            dic.Add("隀", "btgf");
            dic.Add("阼", "bth");
            dic.Add("聥", "btky");
            dic.Add("聰", "btln");
            dic.Add("隩", "btmd");
            dic.Add("阣", "btnn");
            dic.Add("孼", "btwb");
            dic.Add("蠥", "btwj");
            dic.Add("雟", "btwk");
            dic.Add("糱", "btwo");
            dic.Add("櫱", "btws");
            dic.Add("辥", "btwu");
            dic.Add("孫", "btxi");
            dic.Add("愻", "btxn");
            dic.Add("遜", "btxp");
            dic.Add("孜", "bty");
            dic.Add("联", "bu");
            dic.Add("陪", "bu");
            dic.Add("聠", "buah");
            dic.Add("職", "buaj");
            dic.Add("隧", "bue");
            dic.Add("隴", "bued");
            dic.Add("墜", "buef");
            dic.Add("鐆", "bueq");
            dic.Add("隊", "buey");
            dic.Add("阧", "bufh");
            dic.Add("障", "buj");
            dic.Add("隌", "bujg");
            dic.Add("聪", "bukn");
            dic.Add("隡", "butg");
            dic.Add("隒", "buvo");
            dic.Add("隘", "buw");
            dic.Add("限", "bv");
            dic.Add("隉", "bvag");
            dic.Add("孻", "bvhl");
            dic.Add("隟", "bvjs");
            dic.Add("聣", "bvqn");
            dic.Add("队", "bw");
            dic.Add("除", "bw");
            dic.Add("聡", "bwcn");
            dic.Add("聬", "bwcn");
            dic.Add("隂", "bwdy");
            dic.Add("聄", "bwet");
            dic.Add("附", "bwf");
            dic.Add("坠", "bwff");
            dic.Add("際", "bwfi");
            dic.Add("险", "bwg");
            dic.Add("陯", "bwga");
            dic.Add("聧", "bwgd");
            dic.Add("隃", "bwgj");
            dic.Add("隥", "bwgu");
            dic.Add("険", "bwgw");
            dic.Add("險", "bwgw");
            dic.Add("阶", "bwj");
            dic.Add("隖", "bwno");
            dic.Add("﨩", "bwvm");
            dic.Add("聁", "bwvn");
            dic.Add("隝", "bwvo");
            dic.Add("鵈", "bwvo");
            dic.Add("聆", "bwyc");
            dic.Add("阾", "bwyc");
            dic.Add("陰", "bwyc");
            dic.Add("陮", "bwyg");
            dic.Add("耹", "bwyn");
            dic.Add("陛", "bx");
            dic.Add("墬", "bxef");
            dic.Add("乸", "bxgu");
            dic.Add("聈", "bxln");
            dic.Add("聨", "bxxa");
            dic.Add("聫", "bxxd");
            dic.Add("聯", "bxxg");
            dic.Add("阰", "bxxn");
            dic.Add("聮", "bxxo");
            dic.Add("階", "bxxr");
            dic.Add("防", "by");
            dic.Add("孩", "by");
            dic.Add("埅", "byff");
            dic.Add("孓", "byi");
            dic.Add("卪", "byi");
            dic.Add("隮", "byjg");
            dic.Add("阬", "bymn");
            dic.Add("陔", "byn");
            dic.Add("阸", "bynn");
            dic.Add("聤", "byps");
            dic.Add("以", "c");
            dic.Add("又", "c");
            dic.Add("戏", "ca");
            dic.Add("駴", "caah");
            dic.Add("颈", "cad");
            dic.Add("駥", "cadt");
            dic.Add("骐", "cadw");
            dic.Add("騏", "cadw");
            dic.Add("驧", "cafo");
            dic.Add("驊", "cagf");
            dic.Add("弁", "caj");
            dic.Add("馵", "caj");
            dic.Add("刭", "cajh");
            dic.Add("騲", "cajh");
            dic.Add("騹", "cakg");
            dic.Add("驅", "cakk");
            dic.Add("驩", "caky");
            dic.Add("劲", "cal");
            dic.Add("駏", "cang");
            dic.Add("迳", "cap");
            dic.Add("驱", "caq");
            dic.Add("駆", "caqy");
            dic.Add("骁", "catq");
            dic.Add("驠", "cauo");
            dic.Add("鴘", "cawo");
            dic.Add("巯", "cay");
            dic.Add("邓", "cb");
            dic.Add("骤", "cbc");
            dic.Add("驟", "cbci");
            dic.Add("预", "cbd");
            dic.Add("預", "cbdm");
            dic.Add("駬", "cbg");
            dic.Add("予", "cbj");
            dic.Add("驰", "cbn");
            dic.Add("馳", "cbn");
            dic.Add("豫", "cbq");
            dic.Add("矛", "cbt");
            dic.Add("鹜", "cbt");
            dic.Add("蟊", "cbt");
            dic.Add("骛", "cbtc");
            dic.Add("矝", "cbtc");
            dic.Add("矡", "cbtc");
            dic.Add("騖", "cbtc");
            dic.Add("奦", "cbtd");
            dic.Add("矟", "cbte");
            dic.Add("堥", "cbtf");
            dic.Add("鞪", "cbtf");
            dic.Add("鹬", "cbtg");
            dic.Add("瞀", "cbth");
            dic.Add("蝥", "cbtj");
            dic.Add("劀", "cbtj");
            dic.Add("暓", "cbtj");
            dic.Add("矠", "cbtj");
            dic.Add("矞", "cbtk");
            dic.Add("務", "cbtl");
            dic.Add("嵍", "cbtm");
            dic.Add("矜", "cbtn");
            dic.Add("愗", "cbtn");
            dic.Add("氄", "cbtn");
            dic.Add("熃", "cbto");
            dic.Add("鶔", "cbto");
            dic.Add("鶩", "cbto");
            dic.Add("鷸", "cbto");
            dic.Add("遹", "cbtp");
            dic.Add("鍪", "cbtq");
            dic.Add("柔", "cbts");
            dic.Add("楘", "cbts");
            dic.Add("敄", "cbtt");
            dic.Add("婺", "cbtv");
            dic.Add("双", "cc");
            dic.Add("驈", "ccbk");
            dic.Add("騥", "ccbs");
            dic.Add("叕", "cccc");
            dic.Add("敠", "cccc");
            dic.Add("叄", "cccd");
            dic.Add("參", "ccce");
            dic.Add("驂", "ccce");
            dic.Add("垒", "cccf");
            dic.Add("亝", "cccf");
            dic.Add("骉", "cccf");
            dic.Add("叠", "cccg");
            dic.Add("絫", "ccci");
            dic.Add("剟", "cccj");
            dic.Add("剼", "cccj");
            dic.Add("颡", "cccm");
            dic.Add("顙", "cccm");
            dic.Add("叅", "cccn");
            dic.Add("毲", "cccn");
            dic.Add("毿", "cccn");
            dic.Add("鵽", "ccco");
            dic.Add("逫", "cccp");
            dic.Add("遪", "cccp");
            dic.Add("桑", "cccs");
            dic.Add("敪", "ccct");
            dic.Add("厽", "cccu");
            dic.Add("叒", "cccu");
            dic.Add("驫", "cccu");
            dic.Add("欼", "cccw");
            dic.Add("歠", "cccw");
            dic.Add("骖", "ccd");
            dic.Add("驿", "ccf");
            dic.Add("騒", "ccjy");
            dic.Add("骀", "cck");
            dic.Add("駘", "cckg");
            dic.Add("斚", "ccpf");
            dic.Add("馻", "ccqn");
            dic.Add("騃", "cctd");
            dic.Add("骏", "ccw");
            dic.Add("駿", "ccwt");
            dic.Add("驭", "ccy");
            dic.Add("厸", "ccy");
            dic.Add("馭", "ccy");
            dic.Add("騳", "ccy");
            dic.Add("骚", "ccyj");
            dic.Add("騷", "ccyj");
            dic.Add("参", "cd");
            dic.Add("叁", "cdd");
            dic.Add("毵", "cden");
            dic.Add("騞", "cdhd");
            dic.Add("騑", "cdjd");
            dic.Add("奙", "cdjn");
            dic.Add("畚", "cdl");
            dic.Add("軬", "cdlj");
            dic.Add("貵", "cdmu");
            dic.Add("駹", "cdne");
            dic.Add("駀", "cdnn");
            dic.Add("騻", "cdqq");
            dic.Add("騵", "cdri");
            dic.Add("骑", "cds");
            dic.Add("騎", "cdsk");
            dic.Add("驮", "cdy");
            dic.Add("馱", "cdy");
            dic.Add("駄", "cdyy");
            dic.Add("能", "ce");
            dic.Add("驵", "ceg");
            dic.Add("駔", "cegg");
            dic.Add("甬", "cej");
            dic.Add("勇", "cel");
            dic.Add("勈", "celn");
            dic.Add("恿", "cen");
            dic.Add("通", "cep");
            dic.Add("騱", "cexd");
            dic.Add("螚", "cexj");
            dic.Add("態", "cexn");
            dic.Add("熊", "cexo");
            dic.Add("熋", "cexo");
            dic.Add("馺", "ceyy");
            dic.Add("对", "cf");
            dic.Add("驖", "cfag");
            dic.Add("馶", "cfcy");
            dic.Add("頚", "cfdm");
            dic.Add("圣", "cff");
            dic.Add("驍", "cffq");
            dic.Add("馯", "cfh");
            dic.Add("怼", "cfn");
            dic.Add("驝", "cfps");
            dic.Add("驦", "cfsh");
            dic.Add("骦", "cfsh");
            dic.Add("骊", "cg");
            dic.Add("驑", "cgal");
            dic.Add("駵", "cgan");
            dic.Add("駤", "cgcf");
            dic.Add("馬", "cggy");
            dic.Add("駓", "cgig");
            dic.Add("駷", "cgki");
            dic.Add("馷", "cgmh");
            dic.Add("驪", "cgmx");
            dic.Add("駍", "cguh");
            dic.Add("驉", "chag");
            dic.Add("驢", "chal");
            dic.Add("駊", "chcy");
            dic.Add("覌", "chqn");
            dic.Add("騨", "cijf");
            dic.Add("駣", "ciqn");
            dic.Add("駫", "ciqn");
            dic.Add("厼", "ciu");
            dic.Add("骒", "cj");
            dic.Add("驆", "cjaf");
            dic.Add("駻", "cjfh");
            dic.Add("馹", "cjg");
            dic.Add("驲", "cjg");
            dic.Add("騠", "cjgh");
            dic.Add("騴", "cjpv");
            dic.Add("騔", "cjqn");
            dic.Add("騍", "cjsy");
            dic.Add("騉", "cjxx");
            dic.Add("台", "ck");
            dic.Add("邰", "ckb");
            dic.Add("駽", "ckeg");
            dic.Add("瓵", "ckgn");
            dic.Add("驯", "ckh");
            dic.Add("馴", "ckh");
            dic.Add("馽", "ckhj");
            dic.Add("刣", "ckjh");
            dic.Add("驒", "ckkf");
            dic.Add("怠", "ckn");
            dic.Add("乨", "cknn");
            dic.Add("炱", "cko");
            dic.Add("迨", "ckp");
            dic.Add("驶", "ckq");
            dic.Add("駛", "ckqy");
            dic.Add("枲", "cksu");
            dic.Add("辝", "ckuh");
            dic.Add("巼", "ckxb");
            dic.Add("劝", "cl");
            dic.Add("駰", "cldy");
            dic.Add("骃", "cldy");
            dic.Add("驛", "clff");
            dic.Add("驷", "clg");
            dic.Add("駟", "clg");
            dic.Add("騦", "clny");
            dic.Add("圅", "cluf");
            dic.Add("骡", "clx");
            dic.Add("騾", "clxi");
            dic.Add("观", "cm");
            dic.Add("駚", "cmdy");
            dic.Add("騆", "cmfk");
            dic.Add("骋", "cmg");
            dic.Add("駎", "cmg");
            dic.Add("駧", "cmgk");
            dic.Add("騁", "cmgn");
            dic.Add("岊", "cmj");
            dic.Add("駉", "cmkg");
            dic.Add("騧", "cmnk");
            dic.Add("颿", "cmtj");
            dic.Add("貟", "cmu");
            dic.Add("贠", "cmu");
            dic.Add("驨", "cmwk");
            dic.Add("马", "cn");
            dic.Add("骣", "cnb");
            dic.Add("驏", "cnbb");
            dic.Add("巴", "cnh");
            dic.Add("騢", "cnhc");
            dic.Add("駶", "cnnk");
            dic.Add("騽", "cnrg");
            dic.Add("駜", "cntt");
            dic.Add("騛", "cnuh");
            dic.Add("駃", "cnwy");
            dic.Add("厶", "cny");
            dic.Add("", "cny");
            dic.Add("駅", "cnyy");
            dic.Add("驜", "cogw");
            dic.Add("驎", "coqh");
            dic.Add("驼", "cp");
            dic.Add("騌", "cpfi");
            dic.Add("骔", "cpfi");
            dic.Add("驞", "cpgm");
            dic.Add("遤", "cpi");
            dic.Add("馾", "cpqn");
            dic.Add("駝", "cpxn");
            dic.Add("允", "cq");
            dic.Add("騣", "cqbt");
            dic.Add("騶", "cqbt");
            dic.Add("駨", "cqjg");
            dic.Add("驹", "cqk");
            dic.Add("駒", "cqkg");
            dic.Add("驳", "cqq");
            dic.Add("駁", "cqqy");
            dic.Add("騊", "cqrm");
            dic.Add("騘", "cqrn");
            dic.Add("駠", "cqtb");
            dic.Add("驺", "cqv");
            dic.Add("欢", "cqw");
            dic.Add("鸡", "cqy");
            dic.Add("骝", "cqyl");
            dic.Add("騮", "cqyl");
            dic.Add("馰", "cqyy");
            dic.Add("牟", "cr");
            dic.Add("駈", "crgg");
            dic.Add("騜", "crgg");
            dic.Add("馸", "crh");
            dic.Add("劺", "crhl");
            dic.Add("鴾", "crho");
            dic.Add("駯", "criy");
            dic.Add("騡", "criy");
            dic.Add("騩", "crqc");
            dic.Add("骠", "cs");
            dic.Add("驃", "csfi");
            dic.Add("驔", "csjh");
            dic.Add("騕", "csvg");
            dic.Add("騋", "csww");
            dic.Add("矣", "ct");
            dic.Add("馲", "ctan");
            dic.Add("駞", "ctbn");
            dic.Add("骄", "ctdj");
            dic.Add("驕", "ctdk");
            dic.Add("逘", "ctdp");
            dic.Add("欸", "ctdw");
            dic.Add("騈", "ctff");
            dic.Add("駪", "ctfq");
            dic.Add("駳", "cthp");
            dic.Add("骆", "ctk");
            dic.Add("駱", "ctkg");
            dic.Add("骢", "ctl");
            dic.Add("驄", "ctln");
            dic.Add("騀", "ctrt");
            dic.Add("騬", "ctux");
            dic.Add("駇", "cty");
            dic.Add("骈", "cu");
            dic.Add("駢", "cuah");
            dic.Add("驣", "cudc");
            dic.Add("騚", "cuej");
            dic.Add("騂", "cuh");
            dic.Add("骍", "cuh");
            dic.Add("騿", "cujh");
            dic.Add("駾", "cukq");
            dic.Add("驓", "culj");
            dic.Add("騯", "cupy");
            dic.Add("駮", "cuqy");
            dic.Add("骥", "cux");
            dic.Add("驥", "cuxw");
            dic.Add("艰", "cv");
            dic.Add("驌", "cvfj");
            dic.Add("騝", "cvfp");
            dic.Add("騪", "cvhc");
            dic.Add("骕", "cvij");
            dic.Add("騄", "cviy");
            dic.Add("駋", "cvkg");
            dic.Add("駸", "cvpc");
            dic.Add("骎", "cvpc");
            dic.Add("难", "cw");
            dic.Add("駗", "cwet");
            dic.Add("驸", "cwf");
            dic.Add("騇", "cwfk");
            dic.Add("駙", "cwfy");
            dic.Add("验", "cwg");
            dic.Add("騤", "cwgd");
            dic.Add("骙", "cwgd");
            dic.Add("駩", "cwgg");
            dic.Add("騟", "cwgj");
            dic.Add("験", "cwgw");
            dic.Add("驗", "cwgw");
            dic.Add("逡", "cwt");
            dic.Add("皴", "cwtc");
            dic.Add("鵕", "cwto");
            dic.Add("夋", "cwtu");
            dic.Add("駼", "cwty");
            dic.Add("鳮", "cwvo");
            dic.Add("骅", "cwx");
            dic.Add("驋", "cwxc");
            dic.Add("骓", "cwy");
            dic.Add("駖", "cwyc");
            dic.Add("騅", "cwyg");
            dic.Add("騐", "cwyn");
            dic.Add("驻", "cy");
            dic.Add("驐", "cybt");
            dic.Add("駐", "cygg");
            dic.Add("叉", "cyi");
            dic.Add("蚤", "cyj");
            dic.Add("骧", "cyk");
            dic.Add("驤", "cyke");
            dic.Add("驙", "cylg");
            dic.Add("驴", "cyn");
            dic.Add("骗", "cyna");
            dic.Add("騙", "cyna");
            dic.Add("骟", "cynn");
            dic.Add("騸", "cynn");
            dic.Add("馿", "cynt");
            dic.Add("骇", "cynw");
            dic.Add("駭", "cynw");
            dic.Add("騼", "cynx");
            dic.Add("駲", "cyth");
            dic.Add("駺", "cyve");
            dic.Add("馼", "cyy");
            dic.Add("在", "d");
            dic.Add("石", "d");
            dic.Add("左", "da");
            dic.Add("礷", "daal");
            dic.Add("碊", "daat");
            dic.Add("磡", "dadl");
            dic.Add("碪", "dadn");
            dic.Add("厮", "dadr");
            dic.Add("毻", "daen");
            dic.Add("遀", "daep");
            dic.Add("礚", "dafl");
            dic.Add("矼", "dag");
            dic.Add("礡", "dagf");
            dic.Add("砑", "dah");
            dic.Add("礛", "dahl");
            dic.Add("礥", "dahm");
            dic.Add("厊", "daht");
            dic.Add("礴", "dai");
            dic.Add("厝", "daj");
            dic.Add("碏", "dajg");
            dic.Add("勵", "dajl");
            dic.Add("礍", "dajn");
            dic.Add("厲", "dajy");
            dic.Add("厪", "dakg");
            dic.Add("奩", "dakk");
            dic.Add("礶", "daky");
            dic.Add("礣", "dalt");
            dic.Add("磺", "dam");
            dic.Add("碤", "damd");
            dic.Add("砸", "damh");
            dic.Add("碽", "damy");
            dic.Add("碟", "dan");
            dic.Add("奆", "danf");
            dic.Add("礞", "dap");
            dic.Add("奁", "daq");
            dic.Add("砹", "daqy");
            dic.Add("硗", "dat");
            dic.Add("砌", "dav");
            dic.Add("礤", "daw");
            dic.Add("硴", "dawx");
            dic.Add("硔", "dawy");
            dic.Add("硭", "day");
            dic.Add("顾", "db");
            dic.Add("頋", "dbdm");
            dic.Add("耷", "dbf");
            dic.Add("矷", "dbg");
            dic.Add("础", "dbm");
            dic.Add("厄", "dbv");
            dic.Add("友", "dc");
            dic.Add("硁", "dcag");
            dic.Add("夿", "dcb");
            dic.Add("磉", "dcc");
            dic.Add("磣", "dcce");
            dic.Add("碜", "dcd");
            dic.Add("硧", "dceh");
            dic.Add("码", "dcg");
            dic.Add("唘", "dckf");
            dic.Add("盋", "dclf");
            dic.Add("翃", "dcng");
            dic.Add("礟", "dcqq");
            dic.Add("厷", "dcu");
            dic.Add("厺", "dcu");
            dic.Add("犮", "dcu");
            dic.Add("礮", "dcuq");
            dic.Add("雄", "dcw");
            dic.Add("碼", "dcy");
            dic.Add("大", "dd");
            dic.Add("礪", "dday");
            dic.Add("砈", "ddbn");
            dic.Add("磊", "ddd");
            dic.Add("飆", "dddj");
            dic.Add("靥", "dddl");
            dic.Add("砺", "dddn");
            dic.Add("飙", "dddq");
            dic.Add("猋", "dddu");
            dic.Add("磭", "ddfe");
            dic.Add("碱", "ddg");
            dic.Add("砳", "ddg");
            dic.Add("厦", "ddh");
            dic.Add("碶", "ddhd");
            dic.Add("磩", "ddht");
            dic.Add("厌", "ddi");
            dic.Add("厞", "ddjd");
            dic.Add("奭", "ddjj");
            dic.Add("硽", "ddjn");
            dic.Add("厣", "ddl");
            dic.Add("黡", "ddlo");
            dic.Add("硕", "ddm");
            dic.Add("奤", "ddmd");
            dic.Add("碝", "ddmd");
            dic.Add("碩", "ddmy");
            dic.Add("厉", "ddn");
            dic.Add("厖", "ddne");
            dic.Add("硥", "ddne");
            dic.Add("励", "ddnl");
            dic.Add("磢", "ddqq");
            dic.Add("魇", "ddr");
            dic.Add("碕", "ddsk");
            dic.Add("礰", "ddth");
            dic.Add("套", "ddu");
            dic.Add("镽", "ddui");
            dic.Add("餍", "ddw");
            dic.Add("硤", "ddww");
            dic.Add("厐", "ddxv");
            dic.Add("夶", "ddy");
            dic.Add("胡", "de");
            dic.Add("鬕", "dead");
            dic.Add("戫", "deag");
            dic.Add("髰", "dean");
            dic.Add("髸", "deaw");
            dic.Add("鬗", "deay");
            dic.Add("郁", "deb");
            dic.Add("髢", "debb");
            dic.Add("髶", "debf");
            dic.Add("鬖", "dece");
            dic.Add("髳", "dect");
            dic.Add("髪", "dedc");
            dic.Add("髮", "dedc");
            dic.Add("鬌", "dede");
            dic.Add("鬍", "dede");
            dic.Add("髵", "dedj");
            dic.Add("鬊", "dedj");
            dic.Add("硼", "dee");
            dic.Add("鬅", "deee");
            dic.Add("奟", "deef");
            dic.Add("鬚", "deem");
            dic.Add("有", "def");
            dic.Add("鬐", "defj");
            dic.Add("髻", "defk");
            dic.Add("髨", "defq");
            dic.Add("鬒", "defw");
            dic.Add("砠", "degg");
            dic.Add("髬", "degg");
            dic.Add("鬎", "degj");
            dic.Add("髩", "degn");
            dic.Add("髡", "degq");
            dic.Add("髭", "deh");
            dic.Add("砽", "deh");
            dic.Add("髲", "dehc");
            dic.Add("髾", "deie");
            dic.Add("髿", "deit");
            dic.Add("鬘", "dejc");
            dic.Add("鬄", "dejr");
            dic.Add("鬟", "del");
            dic.Add("鬛", "deln");
            dic.Add("髯", "dem");
            dic.Add("髷", "dema");
            dic.Add("髠", "demb");
            dic.Add("鬞", "deme");
            dic.Add("髥", "demf");
            dic.Add("鬃", "dep");
            dic.Add("戞", "depa");
            dic.Add("鄾", "depb");
            dic.Add("迶", "depd");
            dic.Add("鬢", "depm");
            dic.Add("髧", "depq");
            dic.Add("鬡", "deps");
            dic.Add("憂", "dept");
            dic.Add("鬓", "depw");
            dic.Add("鹕", "deq");
            dic.Add("鬇", "deqh");
            dic.Add("髱", "deqn");
            dic.Add("鬉", "deqt");
            dic.Add("磘", "derm");
            dic.Add("鬂", "derw");
            dic.Add("鬆", "desc");
            dic.Add("髤", "desu");
            dic.Add("髟", "det");
            dic.Add("髺", "detd");
            dic.Add("髼", "deth");
            dic.Add("鬁", "detj");
            dic.Add("髦", "detn");
            dic.Add("鬏", "deto");
            dic.Add("鬔", "detp");
            dic.Add("鬈", "deu");
            dic.Add("長", "deu");
            dic.Add("龓", "deud");
            dic.Add("鬜", "deue");
            dic.Add("鬋", "deuj");
            dic.Add("鬙", "deuj");
            dic.Add("鬝", "deuj");
            dic.Add("鬑", "deuo");
            dic.Add("鬀", "deut");
            dic.Add("髫", "devk");
            dic.Add("鬣", "devn");
            dic.Add("髹", "dew");
            dic.Add("髽", "dewf");
            dic.Add("鬠", "dewj");
            dic.Add("鶘", "dewo");
            dic.Add("鶦", "dewo");
            dic.Add("磎", "dexd");
            dic.Add("髴", "dexj");
            dic.Add("髣", "deyb");
            dic.Add("鬤", "deye");
            dic.Add("砐", "deyy");
            dic.Add("硺", "deyy");
            dic.Add("夺", "df");
            dic.Add("奔", "dfa");
            dic.Add("逩", "dfap");
            dic.Add("磕", "dfc");
            dic.Add("夽", "dfcu");
            dic.Add("砝", "dfcy");
            dic.Add("圧", "dfd");
            dic.Add("礝", "dfdj");
            dic.Add("辰", "dfe");
            dic.Add("鄏", "dfeb");
            dic.Add("脣", "dfee");
            dic.Add("辱", "dfef");
            dic.Add("蜃", "dfej");
            dic.Add("唇", "dfek");
            dic.Add("敐", "dfet");
            dic.Add("硅", "dff");
            dic.Add("圶", "dff");
            dic.Add("夳", "dff");
            dic.Add("厓", "dffd");
            dic.Add("奎", "dfff");
            dic.Add("磽", "dffq");
            dic.Add("矸", "dfh");
            dic.Add("厧", "dfhw");
            dic.Add("磌", "dfhw");
            dic.Add("奈", "dfi");
            dic.Add("夲", "dfj");
            dic.Add("厈", "dfk");
            dic.Add("硈", "dfkg");
            dic.Add("礂", "dfkk");
            dic.Add("礌", "dflg");
            dic.Add("夸", "dfn");
            dic.Add("瓠", "dfn");
            dic.Add("郀", "dfnb");
            dic.Add("綔", "dfni");
            dic.Add("刳", "dfnj");
            dic.Add("匏", "dfnn");
            dic.Add("鴮", "dfno");
            dic.Add("砖", "dfny");
            dic.Add("硳", "dfoy");
            dic.Add("礵", "dfsh");
            dic.Add("奢", "dft");
            dic.Add("硣", "dftb");
            dic.Add("奲", "dftf");
            dic.Add("硏", "dftf");
            dic.Add("硓", "dftx");
            dic.Add("碐", "dfwt");
            dic.Add("砆", "dfwy");
            dic.Add("礭", "dfwy");
            dic.Add("压", "dfy");
            dic.Add("三", "dg");
            dic.Add("研", "dga");
            dic.Add("硦", "dgah");
            dic.Add("碔", "dgah");
            dic.Add("硎", "dgaj");
            dic.Add("揅", "dgar");
            dic.Add("砘", "dgb");
            dic.Add("厔", "dgcf");
            dic.Add("磗", "dgef");
            dic.Add("碃", "dgeg");
            dic.Add("古", "dgh");
            dic.Add("镸", "dghy");
            dic.Add("硬", "dgj");
            dic.Add("磚", "dgjf");
            dic.Add("咸", "dgk");
            dic.Add("觱", "dgke");
            dic.Add("厨", "dgkf");
            dic.Add("顑", "dgkm");
            dic.Add("感", "dgkn");
            dic.Add("礓", "dgl");
            dic.Add("碛", "dgm");
            dic.Add("磧", "dgmy");
            dic.Add("戌", "dgn");
            dic.Add("瓳", "dgnn");
            dic.Add("瓺", "dgnn");
            dic.Add("砙", "dgnn");
            dic.Add("烕", "dgot");
            dic.Add("矹", "dgqn");
            dic.Add("厫", "dgqt");
            dic.Add("磝", "dgqt");
            dic.Add("砞", "dgsy");
            dic.Add("厂", "dgt");
            dic.Add("丆", "dgt");
            dic.Add("", "dgt");
            dic.Add("犬", "dgty");
            dic.Add("砰", "dgu");
            dic.Add("硖", "dguw");
            dic.Add("威", "dgv");
            dic.Add("硜", "dgva");
            dic.Add("镾", "dgwq");
            dic.Add("碡", "dgx");
            dic.Add("砡", "dgyy");
            dic.Add("丰", "dh");
            dic.Add("戛", "dha");
            dic.Add("存", "dhb");
            dic.Add("破", "dhc");
            dic.Add("慧", "dhd");
            dic.Add("酆", "dhdb");
            dic.Add("艷", "dhdc");
            dic.Add("砉", "dhdf");
            dic.Add("剨", "dhdj");
            dic.Add("奡", "dhdj");
            dic.Add("豓", "dhdl");
            dic.Add("豔", "dhdl");
            dic.Add("熭", "dhdo");
            dic.Add("奯", "dhdt");
            dic.Add("豒", "dhdt");
            dic.Add("豐", "dhdu");
            dic.Add("彗", "dhdv");
            dic.Add("砋", "dhg");
            dic.Add("夒", "dhht");
            dic.Add("戚", "dhi");
            dic.Add("蹙", "dhih");
            dic.Add("顣", "dhim");
            dic.Add("慼", "dhin");
            dic.Add("砧", "dhkg");
            dic.Add("磠", "dhlo");
            dic.Add("硵", "dhlq");
            dic.Add("碵", "dhmy");
            dic.Add("艳", "dhq");
            dic.Add("硯", "dhqn");
            dic.Add("兏", "dhqv");
            dic.Add("夏", "dht");
            dic.Add("契", "dhv");
            dic.Add("齧", "dhvb");
            dic.Add("觢", "dhve");
            dic.Add("洯", "dhvi");
            dic.Add("絜", "dhvi");
            dic.Add("蛪", "dhvj");
            dic.Add("恝", "dhvn");
            dic.Add("挈", "dhvr");
            dic.Add("栔", "dhvs");
            dic.Add("砂", "di");
            dic.Add("耯", "diac");
            dic.Add("耤", "diaj");
            dic.Add("耢", "dial");
            dic.Add("耟", "dian");
            dic.Add("磲", "dias");
            dic.Add("耔", "dib");
            dic.Add("耙", "dic");
            dic.Add("耛", "dick");
            dic.Add("耨", "did");
            dic.Add("頛", "didm");
            dic.Add("耰", "didt");
            dic.Add("硝", "die");
            dic.Add("耝", "dieg");
            dic.Add("耡", "diel");
            dic.Add("耕", "dif");
            dic.Add("耘", "difc");
            dic.Add("耩", "diff");
            dic.Add("耫", "digm");
            dic.Add("耚", "dihc");
            dic.Add("耒", "dii");
            dic.Add("耥", "diik");
            dic.Add("耖", "diit");
            dic.Add("耦", "dij");
            dic.Add("奫", "dijg");
            dic.Add("耬", "dikv");
            dic.Add("", "dilc");
            dic.Add("耞", "dilk");
            dic.Add("", "dilx");
            dic.Add("厰", "dimt");
            dic.Add("耜", "din");
            dic.Add("耧", "dio");
            dic.Add("耮", "diol");
            dic.Add("礑", "dipl");
            dic.Add("礃", "dipr");
            dic.Add("硄", "diqn");
            dic.Add("耓", "dish");
            dic.Add("耗", "ditn");
            dic.Add("泵", "diu");
            dic.Add("夵", "diu");
            dic.Add("耪", "diuy");
            dic.Add("耠", "diw");
            dic.Add("耣", "diwa");
            dic.Add("耭", "dixt");
            dic.Add("耱", "diy");
            dic.Add("砅", "diy");
            dic.Add("耲", "diye");
            dic.Add("百", "dj");
            dic.Add("厚", "djb");
            dic.Add("非", "djd");
            dic.Add("翡", "djd");
            dic.Add("奜", "djdd");
            dic.Add("猆", "djdd");
            dic.Add("裴", "djde");
            dic.Add("餥", "djde");
            dic.Add("韭", "djdg");
            dic.Add("蜚", "djdj");
            dic.Add("剕", "djdj");
            dic.Add("皕", "djdj");
            dic.Add("辈", "djdl");
            dic.Add("輩", "djdl");
            dic.Add("悲", "djdn");
            dic.Add("靟", "djdn");
            dic.Add("棐", "djds");
            dic.Add("婓", "djdv");
            dic.Add("斐", "djdy");
            dic.Add("魘", "djec");
            dic.Add("厭", "djed");
            dic.Add("靨", "djed");
            dic.Add("饜", "djee");
            dic.Add("壓", "djef");
            dic.Add("奛", "djef");
            dic.Add("厴", "djel");
            dic.Add("懕", "djen");
            dic.Add("黶", "djeo");
            dic.Add("擪", "djer");
            dic.Add("檿", "djes");
            dic.Add("嬮", "djev");
            dic.Add("厘", "djfd");
            dic.Add("碍", "djg");
            dic.Add("碮", "djgh");
            dic.Add("碭", "djgr");
            dic.Add("砷", "djh");
            dic.Add("矵", "djh");
            dic.Add("夰", "djj");
            dic.Add("奄", "djn");
            dic.Add("鹌", "djng");
            dic.Add("剦", "djnj");
            dic.Add("鵪", "djno");
            dic.Add("碣", "djq");
            dic.Add("厬", "djtk");
            dic.Add("礘", "djxo");
            dic.Add("右", "dk");
            dic.Add("夻", "dkf");
            dic.Add("夼", "dkj");
            dic.Add("磾", "dkkf");
            dic.Add("礹", "dkkt");
            dic.Add("磒", "dkmy");
            dic.Add("厛", "dkrk");
            dic.Add("厑", "dkxv");
            dic.Add("历", "dl");
            dic.Add("夯", "dlb");
            dic.Add("奋", "dlf");
            dic.Add("礋", "dlff");
            dic.Add("碨", "dlge");
            dic.Add("砗", "dlh");
            dic.Add("硨", "dlh");
            dic.Add("厍", "dlk");
            dic.Add("厙", "dlk");
            dic.Add("靣", "dlkf");
            dic.Add("硘", "dlkg");
            dic.Add("礧", "dlll");
            dic.Add("劯", "dln");
            dic.Add("硱", "dlsy");
            dic.Add("碅", "dlty");
            dic.Add("磥", "dlxi");
            dic.Add("面", "dm");
            dic.Add("碘", "dma");
            dic.Add("冇", "dmb");
            dic.Add("砓", "dmcy");
            dic.Add("碳", "dmd");
            dic.Add("硸", "dmdf");
            dic.Add("顨", "dmdj");
            dic.Add("磞", "dmee");
            dic.Add("磆", "dmeg");
            dic.Add("碉", "dmf");
            dic.Add("奝", "dmfk");
            dic.Add("硐", "dmg");
            dic.Add("磑", "dmgu");
            dic.Add("布", "dmh");
            dic.Add("而", "dmj");
            dic.Add("耎", "dmjd");
            dic.Add("耏", "dmje");
            dic.Add("耐", "dmjf");
            dic.Add("鸸", "dmjg");
            dic.Add("蠠", "dmjj");
            dic.Add("厕", "dmjk");
            dic.Add("厠", "dmjk");
            dic.Add("勔", "dmjl");
            dic.Add("靧", "dmjm");
            dic.Add("恧", "dmjn");
            dic.Add("靤", "dmjn");
            dic.Add("鴯", "dmjo");
            dic.Add("靦", "dmjq");
            dic.Add("耍", "dmjv");
            dic.Add("矶", "dmn");
            dic.Add("碢", "dmnk");
            dic.Add("硙", "dmnn");
            dic.Add("砚", "dmq");
            dic.Add("砜", "dmqy");
            dic.Add("碋", "dmsk");
            dic.Add("碸", "dmtj");
            dic.Add("页", "dmu");
            dic.Add("頁", "dmu");
            dic.Add("碙", "dmum");
            dic.Add("磮", "dmwa");
            dic.Add("硶", "dmwn");
            dic.Add("磪", "dmwy");
            dic.Add("矾", "dmy");
            dic.Add("砃", "dmyg");
            dic.Add("成", "dn");
            dic.Add("碾", "dna");
            dic.Add("尷", "dnal");
            dic.Add("乭", "dnb");
            dic.Add("镼", "dnbm");
            dic.Add("臧", "dnd");
            dic.Add("尨", "dnee");
            dic.Add("尮", "dnes");
            dic.Add("尪", "dngd");
            dic.Add("嘏", "dnh");
            dic.Add("碬", "dnhc");
            dic.Add("碿", "dnie");
            dic.Add("尴", "dnjl");
            dic.Add("虿", "dnju");
            dic.Add("趸", "dnk");
            dic.Add("尵", "dnkm");
            dic.Add("礔", "dnku");
            dic.Add("劢", "dnl");
            dic.Add("尳", "dnme");
            dic.Add("郕", "dnnb");
            dic.Add("盛", "dnnl");
            dic.Add("迈", "dnp");
            dic.Add("尥", "dnq");
            dic.Add("尯", "dnqb");
            dic.Add("砀", "dnr");
            dic.Add("磖", "dnrg");
            dic.Add("尰", "dntf");
            dic.Add("怘", "dnu");
            dic.Add("尲", "dnuo");
            dic.Add("万", "dnv");
            dic.Add("尤", "dnv");
            dic.Add("尢", "dnv");
            dic.Add("尬", "dnw");
            dic.Add("磟", "dnwe");
            dic.Add("砄", "dnwy");
            dic.Add("戊", "dny");
            dic.Add("灰", "do");
            dic.Add("礏", "dogw");
            dic.Add("盔", "dol");
            dic.Add("礯", "dooi");
            dic.Add("磱", "dool");
            dic.Add("磷", "doq");
            dic.Add("达", "dp");
            dic.Add("硡", "dpdc");
            dic.Add("磍", "dpdk");
            dic.Add("碂", "dpfi");
            dic.Add("碹", "dpgg");
            dic.Add("碇", "dpgh");
            dic.Add("礗", "dpgm");
            dic.Add("迖", "dpi");
            dic.Add("碗", "dpq");
            dic.Add("牵", "dpr");
            dic.Add("碦", "dptk");
            dic.Add("硿", "dpwa");
            dic.Add("確", "dpwy");
            dic.Add("砣", "dpx");
            dic.Add("克", "dq");
            dic.Add("碈", "dqaj");
            dic.Add("磔", "dqas");
            dic.Add("砥", "dqay");
            dic.Add("厎", "dqay");
            dic.Add("奃", "dqay");
            dic.Add("兢", "dqd");
            dic.Add("硊", "dqdb");
            dic.Add("兣", "dqdf");
            dic.Add("兡", "dqdj");
            dic.Add("确", "dqe");
            dic.Add("尅", "dqfi");
            dic.Add("兙", "dqfk");
            dic.Add("碒", "dqg");
            dic.Add("砾", "dqi");
            dic.Add("剋", "dqjk");
            dic.Add("勀", "dqln");
            dic.Add("勊", "dqlv");
            dic.Add("砲", "dqnn");
            dic.Add("爽", "dqq");
            dic.Add("鷞", "dqqo");
            dic.Add("奓", "dqqu");
            dic.Add("奅", "dqtb");
            dic.Add("兛", "dqtf");
            dic.Add("兞", "dqtn");
            dic.Add("碀", "dqvh");
            dic.Add("砍", "dqw");
            dic.Add("兝", "dqwv");
            dic.Add("矽", "dqy");
            dic.Add("鸪", "dqyg");
            dic.Add("磂", "dqyl");
            dic.Add("镹", "dqyy");
            dic.Add("原", "dr");
            dic.Add("碷", "drfh");
            dic.Add("砶", "drg");
            dic.Add("斫", "drh");
            dic.Add("磃", "drhm");
            dic.Add("厡", "drii");
            dic.Add("厵", "drii");
            dic.Add("願", "drim");
            dic.Add("愿", "drin");
            dic.Add("硃", "driy");
            dic.Add("厒", "drmk");
            dic.Add("磈", "drqc");
            dic.Add("礩", "drrm");
            dic.Add("碑", "drt");
            dic.Add("磤", "drvc");
            dic.Add("镻", "drwy");
            dic.Add("礉", "dryt");
            dic.Add("厅", "ds");
            dic.Add("磦", "dsfi");
            dic.Add("硒", "dsg");
            dic.Add("砵", "dsgg");
            dic.Add("厢", "dsh");
            dic.Add("矴", "dsh");
            dic.Add("碴", "dsj");
            dic.Add("磹", "dsjh");
            dic.Add("攲", "dskc");
            dic.Add("敧", "dskc");
            dic.Add("奇", "dskf");
            dic.Add("砢", "dskg");
            dic.Add("剞", "dskj");
            dic.Add("鵸", "dsko");
            dic.Add("欹", "dskw");
            dic.Add("歴", "dssh");
            dic.Add("礎", "dssh");
            dic.Add("暦", "dssj");
            dic.Add("厯", "dssn");
            dic.Add("碄", "dssy");
            dic.Add("硹", "dswc");
            dic.Add("帮", "dt");
            dic.Add("矺", "dtan");
            dic.Add("厇", "dtav");
            dic.Add("邦", "dtb");
            dic.Add("幚", "dtbh");
            dic.Add("砤", "dtbn");
            dic.Add("硚", "dtdj");
            dic.Add("礄", "dtdk");
            dic.Add("镺", "dtdy");
            dic.Add("寿", "dtf");
            dic.Add("硞", "dtfk");
            dic.Add("礸", "dtfm");
            dic.Add("焘", "dtfo");
            dic.Add("厜", "dtgf");
            dic.Add("硾", "dtgf");
            dic.Add("砟", "dth");
            dic.Add("厏", "dthf");
            dic.Add("硟", "dthp");
            dic.Add("硌", "dtk");
            dic.Add("邫", "dtkc");
            dic.Add("硇", "dtl");
            dic.Add("磇", "dtlx");
            dic.Add("礇", "dtmd");
            dic.Add("矻", "dtnn");
            dic.Add("磻", "dtol");
            dic.Add("砭", "dtp");
            dic.Add("硪", "dtr");
            dic.Add("磿", "dttd");
            dic.Add("歷", "dtth");
            dic.Add("厤", "dtti");
            dic.Add("曆", "dttj");
            dic.Add("磫", "dtwh");
            dic.Add("故", "dty");
            dic.Add("磁", "du");
            dic.Add("硑", "duah");
            dic.Add("蹷", "dubh");
            dic.Add("劂", "dubj");
            dic.Add("蟨", "dubj");
            dic.Add("憠", "dubn");
            dic.Add("鷢", "dubo");
            dic.Add("磀", "dubp");
            dic.Add("橜", "dubs");
            dic.Add("厥", "dubw");
            dic.Add("磙", "duc");
            dic.Add("磋", "dud");
            dic.Add("礢", "dude");
            dic.Add("羍", "dudj");
            dic.Add("磰", "dudk");
            dic.Add("礲", "dued");
            dic.Add("龎", "dued");
            dic.Add("礀", "dueg");
            dic.Add("礈", "duep");
            dic.Add("砬", "dug");
            dic.Add("礒", "dugt");
            dic.Add("眘", "duhf");
            dic.Add("辜", "duj");
            dic.Add("昚", "dujf");
            dic.Add("鹩", "dujg");
            dic.Add("磵", "dujg");
            dic.Add("尞", "duji");
            dic.Add("鷯", "dujo");
            dic.Add("遼", "dujp");
            dic.Add("碚", "duk");
            dic.Add("厗", "duk");
            dic.Add("磳", "dulj");
            dic.Add("碰", "duo");
            dic.Add("磅", "dup");
            dic.Add("碲", "duph");
            dic.Add("磸", "dusd");
            dic.Add("冭", "duu");
            dic.Add("磏", "duvo");
            dic.Add("礠", "duxn");
            dic.Add("肆", "dv");
            dic.Add("厩", "dvc");
            dic.Add("硍", "dvey");
            dic.Add("砕", "dvfh");
            dic.Add("硉", "dvfh");
            dic.Add("礖", "dvgw");
            dic.Add("碌", "dvi");
            dic.Add("磶", "dvqo");
            dic.Add("碯", "dvtq");
            dic.Add("春", "dw");
            dic.Add("砼", "dwa");
            dic.Add("碫", "dwdc");
            dic.Add("奉", "dwf");
            dic.Add("磜", "dwfi");
            dic.Add("奏", "dwg");
            dic.Add("碖", "dwga");
            dic.Add("硂", "dwgg");
            dic.Add("硷", "dwgi");
            dic.Add("硆", "dwgk");
            dic.Add("磴", "dwgu");
            dic.Add("厱", "dwgw");
            dic.Add("礆", "dwgw");
            dic.Add("仄", "dwi");
            dic.Add("", "dwi");
            dic.Add("泰", "dwiu");
            dic.Add("砎", "dwjh");
            dic.Add("蠢", "dwjj");
            dic.Add("惷", "dwjn");
            dic.Add("磓", "dwnp");
            dic.Add("秦", "dwt");
            dic.Add("硢", "dwty");
            dic.Add("舂", "dwv");
            dic.Add("憃", "dwvn");
            dic.Add("砏", "dwvn");
            dic.Add("鳫", "dwvo");
            dic.Add("鴣", "dwvo");
            dic.Add("雁", "dww");
            dic.Add("郟", "dwwb");
            dic.Add("夾", "dwwi");
            dic.Add("硲", "dwwk");
            dic.Add("赝", "dwwm");
            dic.Add("贋", "dwwm");
            dic.Add("贗", "dwwm");
            dic.Add("頰", "dwwm");
            dic.Add("鴈", "dwwo");
            dic.Add("鵊", "dwwo");
            dic.Add("礁", "dwy");
            dic.Add("砱", "dwyc");
            dic.Add("奞", "dwyf");
            dic.Add("奪", "dwyf");
            dic.Add("碓", "dwyg");
            dic.Add("奮", "dwyl");
            dic.Add("砛", "dwyn");
            dic.Add("磼", "dwys");
            dic.Add("龙", "dx");
            dic.Add("龚", "dxa");
            dic.Add("聋", "dxb");
            dic.Add("砻", "dxd");
            dic.Add("垄", "dxf");
            dic.Add("", "dxgd");
            dic.Add("砪", "dxgu");
            dic.Add("砩", "dxj");
            dic.Add("礫", "dxrs");
            dic.Add("礙", "dxth");
            dic.Add("砒", "dxx");
            dic.Add("磯", "dxxt");
            dic.Add("袭", "dxy");
            dic.Add("詟", "dxyf");
            dic.Add("太", "dy");
            dic.Add("礦", "dyaw");
            dic.Add("礅", "dyb");
            dic.Add("硫", "dyc");
            dic.Add("砿", "dycy");
            dic.Add("砫", "dygg");
            dic.Add("丈", "dyi");
            dic.Add("砯", "dyiy");
            dic.Add("盇", "dylf");
            dic.Add("碻", "dymk");
            dic.Add("砊", "dymn");
            dic.Add("态", "dyn");
            dic.Add("碥", "dyna");
            dic.Add("砨", "dynn");
            dic.Add("戍", "dynt");
            dic.Add("奒", "dynw");
            dic.Add("硋", "dynw");
            dic.Add("硛", "dyoy");
            dic.Add("迏", "dypi");
            dic.Add("碠", "dyps");
            dic.Add("礳", "dysd");
            dic.Add("矿", "dyt");
            dic.Add("硠", "dyve");
            dic.Add("磄", "dyvk");
            dic.Add("碎", "dyw");
            dic.Add("砇", "dyy");
            dic.Add("月", "e");
            dic.Add("肛", "ea");
            dic.Add("臓", "eadt");
            dic.Add("臟", "eadt");
            dic.Add("腻", "eaf");
            dic.Add("膩", "eafm");
            dic.Add("腜", "eafs");
            dic.Add("臔", "eahm");
            dic.Add("胨", "eai");
            dic.Add("腊", "eaj");
            dic.Add("膜", "eajd");
            dic.Add("臈", "eajn");
            dic.Add("膒", "eakk");
            dic.Add("朠", "eamd");
            dic.Add("朑", "eann");
            dic.Add("脦", "eany");
            dic.Add("朦", "eap");
            dic.Add("臙", "eauo");
            dic.Add("臒", "eawc");
            dic.Add("膵", "eayf");
            dic.Add("服", "eb");
            dic.Add("乳", "eb");
            dic.Add("郛", "ebb");
            dic.Add("鵩", "ebco");
            dic.Add("孕", "ebf");
            dic.Add("孚", "ebf");
            dic.Add("朏", "ebmh");
            dic.Add("胐", "ebmh");
            dic.Add("肔", "ebn");
            dic.Add("嗠", "ebtk");
            dic.Add("肥", "ec");
            dic.Add("胎", "ec");
            dic.Add("胫", "eca");
            dic.Add("腬", "ecbs");
            dic.Add("腏", "eccc");
            dic.Add("夃", "eci");
            dic.Add("蜰", "ecju");
            dic.Add("盈", "ecl");
            dic.Add("戤", "ecla");
            dic.Add("亂", "ecmn");
            dic.Add("覶", "ecmq");
            dic.Add("辭", "ecmu");
            dic.Add("豝", "ecn");
            dic.Add("朘", "ecwt");
            dic.Add("脧", "ecwt");
            dic.Add("肞", "ecyy");
            dic.Add("须", "ed");
            dic.Add("腌", "ed");
            dic.Add("膸", "edap");
            dic.Add("肱", "edc");
            dic.Add("胈", "edcy");
            dic.Add("脹", "edey");
            dic.Add("胯", "edf");
            dic.Add("呄", "edf");
            dic.Add("脤", "edfe");
            dic.Add("脜", "edhg");
            dic.Add("肨", "edhh");
            dic.Add("腓", "edjd");
            dic.Add("腼", "edmd");
            dic.Add("腝", "edmd");
            dic.Add("澃", "edmi");
            dic.Add("胹", "edmj");
            dic.Add("盨", "edml");
            dic.Add("媭", "edmv");
            dic.Add("嬃", "edmv");
            dic.Add("頾", "edmx");
            dic.Add("須", "edmy");
            dic.Add("肬", "ednn");
            dic.Add("脄", "edoy");
            dic.Add("豲", "edri");
            dic.Add("膫", "edui");
            dic.Add("腠", "edw");
            dic.Add("脥", "edww");
            dic.Add("胧", "edx");
            dic.Add("肽", "edy");
            dic.Add("肰", "edy");
            dic.Add("朋", "ee");
            dic.Add("貌", "ee");
            dic.Add("貘", "eea");
            dic.Add("貙", "eeak");
            dic.Add("貓", "eeal");
            dic.Add("貛", "eeay");
            dic.Add("脬", "eeb");
            dic.Add("貀", "eebm");
            dic.Add("貊", "eed");
            dic.Add("貕", "eeed");
            dic.Add("朤", "eeee");
            dic.Add("豺", "eef");
            dic.Add("豻", "eefh");
            dic.Add("脟", "eefy");
            dic.Add("豠", "eegg");
            dic.Add("豾", "eegg");
            dic.Add("貆", "eegg");
            dic.Add("貜", "eehc");
            dic.Add("貋", "eejf");
            dic.Add("貍", "eejf");
            dic.Add("蠫", "eejj");
            dic.Add("貚", "eekf");
            dic.Add("貗", "eekv");
            dic.Add("豳", "eem");
            dic.Add("貒", "eemj");
            dic.Add("豽", "eemw");
            dic.Add("貑", "eenc");
            dic.Add("燹", "eeo");
            dic.Add("遯", "eepi");
            dic.Add("貁", "eepw");
            dic.Add("鹏", "eeq");
            dic.Add("豿", "eeqk");
            dic.Add("豹", "eeqy");
            dic.Add("豸", "eer");
            dic.Add("貏", "eerf");
            dic.Add("貃", "eerg");
            dic.Add("邈", "eerp");
            dic.Add("肜", "eet");
            dic.Add("貈", "eete");
            dic.Add("貉", "eetk");
            dic.Add("貔", "eetx");
            dic.Add("貖", "eeul");
            dic.Add("貂", "eev");
            dic.Add("貇", "eeve");
            dic.Add("墾", "eevf");
            dic.Add("脮", "eevg");
            dic.Add("貄", "eevh");
            dic.Add("懇", "eevn");
            dic.Add("貎", "eevq");
            dic.Add("貅", "eew");
            dic.Add("貐", "eewj");
            dic.Add("鵬", "eewo");
            dic.Add("膎", "eexd");
            dic.Add("豯", "eexd");
            dic.Add("豼", "eexx");
            dic.Add("豚", "eey");
            dic.Add("豩", "eey");
            dic.Add("肝", "ef");
            dic.Add("膹", "efam");
            dic.Add("豮", "efam");
            dic.Add("豶", "efam");
            dic.Add("肢", "efc");
            dic.Add("脚", "efcb");
            dic.Add("胠", "efcy");
            dic.Add("臑", "efdj");
            dic.Add("頱", "efdm");
            dic.Add("胿", "effg");
            dic.Add("膮", "effq");
            dic.Add("肚", "efg");
            dic.Add("虢", "efhm");
            dic.Add("脙", "efiy");
            dic.Add("肼", "efj");
            dic.Add("膨", "efk");
            dic.Add("臌", "efkc");
            dic.Add("腩", "efm");
            dic.Add("肟", "efn");
            dic.Add("", "efny");
            dic.Add("脖", "efp");
            dic.Add("豷", "efpu");
            dic.Add("朊", "efq");
            dic.Add("爰", "eft");
            dic.Add("豣", "eftf");
            dic.Add("豬", "eftj");
            dic.Add("鶢", "efto");
            dic.Add("櫫", "efts");
            dic.Add("寽", "efu");
            dic.Add("膤", "efvg");
            dic.Add("肤", "efw");
            dic.Add("鶏", "efwo");
            dic.Add("臛", "efwy");
            dic.Add("肘", "efy");
            dic.Add("且", "eg");
            dic.Add("豜", "egah");
            dic.Add("肫", "egb");
            dic.Add("豘", "egbn");
            dic.Add("县", "egc");
            dic.Add("胵", "egcf");
            dic.Add("悬", "egcn");
            dic.Add("脯", "ege");
            dic.Add("膊", "egef");
            dic.Add("腈", "egeg");
            dic.Add("脿", "egey");
            dic.Add("豧", "egey");
            dic.Add("胚", "egi");
            dic.Add("脴", "egik");
            dic.Add("肧", "egiy");
            dic.Add("膞", "egjf");
            dic.Add("刞", "egjh");
            dic.Add("腖", "egji");
            dic.Add("膈", "egk");
            dic.Add("脨", "egki");
            dic.Add("腷", "egkl");
            dic.Add("脰", "egku");
            dic.Add("助", "egl");
            dic.Add("肺", "egm");
            dic.Add("脼", "egmy");
            dic.Add("豕", "egt");
            dic.Add("胓", "eguh");
            dic.Add("脛", "egva");
            dic.Add("脻", "egvh");
            dic.Add("雎", "egw");
            dic.Add("鴡", "egwo");
            dic.Add("胰", "egx");
            dic.Add("膆", "egxi");
            dic.Add("胩", "eh");
            dic.Add("臄", "ehae");
            dic.Add("臚", "ehal");
            dic.Add("臞", "ehhy");
            dic.Add("丯", "ehk");
            dic.Add("胋", "ehkg");
            dic.Add("鼐", "ehn");
            dic.Add("胪", "ehnt");
            dic.Add("覓", "ehqb");
            dic.Add("辵", "ehu");
            dic.Add("頿", "ehxm");
            dic.Add("膛", "ei");
            dic.Add("胱", "eiq");
            dic.Add("脳", "eiqb");
            dic.Add("朓", "eiqn");
            dic.Add("脁", "eiqn");
            dic.Add("尕", "eiu");
            dic.Add("膌", "eiwe");
            dic.Add("胆", "ej");
            dic.Add("腸", "ejgr");
            dic.Add("刖", "ejh");
            dic.Add("胂", "ejhh");
            dic.Add("蟸", "ejju");
            dic.Add("腽", "ejl");
            dic.Add("豱", "ejlg");
            dic.Add("腢", "ejmy");
            dic.Add("腂", "ejsy");
            dic.Add("腥", "ejt");
            dic.Add("肿", "ek");
            dic.Add("脵", "ekgd");
            dic.Add("脭", "ekgg");
            dic.Add("膢", "ekgv");
            dic.Add("膭", "ekhm");
            dic.Add("腭", "ekk");
            dic.Add("臊", "ekks");
            dic.Add("脶", "ekm");
            dic.Add("胑", "ekwy");
            dic.Add("肋", "el");
            dic.Add("膕", "elag");
            dic.Add("胭", "eld");
            dic.Add("盁", "elf");
            dic.Add("腲", "elge");
            dic.Add("腘", "elgy");
            dic.Add("胛", "elh");
            dic.Add("脇", "elll");
            dic.Add("腮", "elny");
            dic.Add("臅", "elqj");
            dic.Add("爵", "elv");
            dic.Add("胁", "elw");
            dic.Add("膃", "elwl");
            dic.Add("肌", "em");
            dic.Add("腆", "ema");
            dic.Add("膿", "emae");
            dic.Add("股", "emc");
            dic.Add("豛", "emcy");
            dic.Add("腨", "emdj");
            dic.Add("胦", "emdy");
            dic.Add("爯", "emff");
            dic.Add("胴", "emg");
            dic.Add("腗", "emgj");
            dic.Add("腡", "emnk");
            dic.Add("膼", "emnp");
            dic.Add("觅", "emq");
            dic.Add("肭", "emw");
            dic.Add("朒", "emww");
            dic.Add("膗", "emwy");
            dic.Add("甩", "en");
            dic.Add("腒", "endg");
            dic.Add("腛", "engf");
            dic.Add("腵", "enhc");
            dic.Add("豭", "enhc");
            dic.Add("脲", "eni");
            dic.Add("肊", "enn");
            dic.Add("肠", "enr");
            dic.Add("膠", "enwe");
            dic.Add("胒", "enxn");
            dic.Add("臎", "enyf");
            dic.Add("膦", "eo");
            dic.Add("朥", "eool");
            dic.Add("腅", "eooy");
            dic.Add("脒", "eoy");
            dic.Add("爱", "ep");
            dic.Add("臗", "epay");
            dic.Add("受", "epc");
            dic.Add("辤", "epcu");
            dic.Add("迌", "epd");
            dic.Add("脓", "epe");
            dic.Add("脘", "epf");
            dic.Add("腙", "epfi");
            dic.Add("腚", "epg");
            dic.Add("腟", "epgf");
            dic.Add("臏", "epgm");
            dic.Add("逐", "epi");
            dic.Add("腪", "eplh");
            dic.Add("愛", "epnt");
            dic.Add("腕", "epq");
            dic.Add("舜", "epqh");
            dic.Add("膑", "epr");
            dic.Add("胺", "epv");
            dic.Add("辸", "epv");
            dic.Add("腔", "epw");
            dic.Add("膣", "epwf");
            dic.Add("胸", "eq");
            dic.Add("胝", "eqa");
            dic.Add("朡", "eqbt");
            dic.Add("脃", "eqcn");
            dic.Add("脆", "eqd");
            dic.Add("脪", "eqdh");
            dic.Add("豨", "eqdh");
            dic.Add("膽", "eqdy");
            dic.Add("朐", "eqk");
            dic.Add("胊", "eqkg");
            dic.Add("豞", "eqkg");
            dic.Add("脕", "eqkq");
            dic.Add("胞", "eqn");
            dic.Add("褜", "eqne");
            dic.Add("脗", "eqrk");
            dic.Add("肳", "eqrt");
            dic.Add("脎", "eqs");
            dic.Add("肷", "eqw");
            dic.Add("肑", "eqyy");
            dic.Add("遥", "er");
            dic.Add("胍", "erc");
            dic.Add("脈", "erey");
            dic.Add("腯", "erfh");
            dic.Add("胉", "erg");
            dic.Add("肵", "erh");
            dic.Add("脌", "erhf");
            dic.Add("腺", "eri");
            dic.Add("膴", "erlo");
            dic.Add("鹞", "ermg");
            dic.Add("繇", "ermi");
            dic.Add("颻", "ermj");
            dic.Add("鷂", "ermo");
            dic.Add("飖", "ermq");
            dic.Add("脾", "ert");
            dic.Add("胅", "erwy");
            dic.Add("采", "es");
            dic.Add("彩", "ese");
            dic.Add("膘", "esf");
            dic.Add("刴", "esjh");
            dic.Add("胢", "eskg");
            dic.Add("朶", "esu");
            dic.Add("腰", "esv");
            dic.Add("膝", "esw");
            dic.Add("用", "et");
            dic.Add("胀", "eta");
            dic.Add("胮", "etah");
            dic.Add("胣", "etbn");
            dic.Add("膖", "etdp");
            dic.Add("腁", "etff");
            dic.Add("胻", "etfh");
            dic.Add("臜", "etfm");
            dic.Add("臢", "etfm");
            dic.Add("膬", "etfn");
            dic.Add("脡", "etfp");
            dic.Add("胜", "etg");
            dic.Add("甤", "etgd");
            dic.Add("腄", "etgf");
            dic.Add("腫", "etgf");
            dic.Add("臐", "etgo");
            dic.Add("胙", "eth");
            dic.Add("脠", "ethp");
            dic.Add("腹", "etj");
            dic.Add("脷", "etjh");
            dic.Add("膓", "etjr");
            dic.Add("胳", "etk");
            dic.Add("膍", "etlx");
            dic.Add("乃", "etn");
            dic.Add("爳", "etnb");
            dic.Add("鄬", "etnb");
            dic.Add("噕", "etnk");
            dic.Add("肐", "etnn");
            dic.Add("爲", "etno");
            dic.Add("胏", "etnt");
            dic.Add("膰", "etol");
            dic.Add("彡", "ett");
            dic.Add("腇", "etvg");
            dic.Add("豵", "etwh");
            dic.Add("脢", "etxu");
            dic.Add("爫", "etyt");
            dic.Add("胶", "eu");
            dic.Add("胼", "eua");
            dic.Add("膱", "euaj");
            dic.Add("腾", "eud");
            dic.Add("腃", "eudb");
            dic.Add("騰", "eudc");
            dic.Add("塍", "eudf");
            dic.Add("", "eudg");
            dic.Add("幐", "eudh");
            dic.Add("羘", "eudh");
            dic.Add("膡", "eudh");
            dic.Add("滕", "eudi");
            dic.Add("縢", "eudi");
            dic.Add("螣", "eudj");
            dic.Add("膳", "eudk");
            dic.Add("勝", "eudl");
            dic.Add("賸", "eudm");
            dic.Add("鰧", "eudo");
            dic.Add("黱", "eudo");
            dic.Add("榺", "euds");
            dic.Add("媵", "eudv");
            dic.Add("朕", "eudy");
            dic.Add("謄", "eudy");
            dic.Add("朧", "eued");
            dic.Add("胖", "euf");
            dic.Add("膶", "eugg");
            dic.Add("臆", "euj");
            dic.Add("朣", "eujf");
            dic.Add("膧", "eujf");
            dic.Add("腤", "eujg");
            dic.Add("脱", "euk");
            dic.Add("豴", "eumd");
            dic.Add("膀", "eup");
            dic.Add("腣", "euph");
            dic.Add("膪", "eupk");
            dic.Add("膁", "euvo");
            dic.Add("膉", "euwl");
            dic.Add("妥", "ev");
            dic.Add("腿", "eve");
            dic.Add("豤", "evey");
            dic.Add("舀", "evf");
            dic.Add("腱", "evfp");
            dic.Add("肗", "evg");
            dic.Add("膄", "evhc");
            dic.Add("爭", "evhj");
            dic.Add("臘", "evln");
            dic.Add("肍", "evn");
            dic.Add("腉", "evqn");
            dic.Add("腦", "evtq");
            dic.Add("腴", "evw");
            dic.Add("鵎", "evwo");
            dic.Add("肒", "evyy");
            dic.Add("肕", "evyy");
            dic.Add("脸", "ew");
            dic.Add("腶", "ewdc");
            dic.Add("胗", "ewe");
            dic.Add("脍", "ewf");
            dic.Add("肸", "ewfh");
            dic.Add("胕", "ewfy");
            dic.Add("腀", "ewga");
            dic.Add("腧", "ewgj");
            dic.Add("膾", "ewgj");
            dic.Add("肹", "ewgn");
            dic.Add("膯", "ewgu");
            dic.Add("臉", "ewgw");
            dic.Add("脫", "ewkq");
            dic.Add("膇", "ewnp");
            dic.Add("朌", "ewvn");
            dic.Add("肦", "ewvn");
            dic.Add("脞", "eww");
            dic.Add("腳", "ewwb");
            dic.Add("朎", "ewyc");
            dic.Add("脽", "ewyg");
            dic.Add("臇", "ewym");
            dic.Add("肣", "ewyn");
            dic.Add("腍", "ewyn");
            dic.Add("膲", "ewyo");
            dic.Add("脂", "ex");
            dic.Add("奚", "exd");
            dic.Add("谿", "exdk");
            dic.Add("鷄", "exdo");
            dic.Add("雞", "exdy");
            dic.Add("腞", "exey");
            dic.Add("胟", "exgu");
            dic.Add("乿", "exin");
            dic.Add("胇", "exjh");
            dic.Add("膙", "exkj");
            dic.Add("膷", "extb");
            dic.Add("肶", "exxn");
            dic.Add("及", "ey");
            dic.Add("脑", "eyb");
            dic.Add("朜", "eybg");
            dic.Add("脝", "eybh");
            dic.Add("脏", "eyf");
            dic.Add("豖", "eyi");
            dic.Add("脐", "eyj");
            dic.Add("臍", "eyjg");
            dic.Add("剢", "eyjh");
            dic.Add("膻", "eyl");
            dic.Add("肮", "eym");
            dic.Add("肪", "eyn");
            dic.Add("脉", "eyni");
            dic.Add("豟", "eynn");
            dic.Add("臕", "eyno");
            dic.Add("胲", "eynw");
            dic.Add("豥", "eynw");
            dic.Add("膔", "eynx");
            dic.Add("臁", "eyu");
            dic.Add("朖", "eyve");
            dic.Add("膅", "eyvk");
            dic.Add("腑", "eyw");
            dic.Add("脺", "eywf");
            dic.Add("腋", "eywy");
            dic.Add("臃", "eyx");
            dic.Add("膟", "eyxf");
            dic.Add("胘", "eyxy");
            dic.Add("﨤", "eyyp");
            dic.Add("地", "f");
            dic.Add("土", "f");
            dic.Add("载", "fa");
            dic.Add("堪", "fad");
            dic.Add("韯", "fadg");
            dic.Add("墈", "fadl");
            dic.Add("霰", "fae");
            dic.Add("", "fae");
            dic.Add("霸", "faf");
            dic.Add("卋", "faf");
            dic.Add("鼖", "fafc");
            dic.Add("雸", "faff");
            dic.Add("坩", "fafg");
            dic.Add("墸", "fafj");
            dic.Add("壒", "fafl");
            dic.Add("墷", "fagf");
            dic.Add("臷", "fagf");
            dic.Add("壏", "fahl");
            dic.Add("卉", "faj");
            dic.Add("塻", "fajd");
            dic.Add("蛓", "faji");
            dic.Add("堰", "fajv");
            dic.Add("哉", "fak");
            dic.Add("域", "fakg");
            dic.Add("墐", "fakg");
            dic.Add("塸", "fakk");
            dic.Add("壦", "faky");
            dic.Add("載", "falk");
            dic.Add("戴", "falw");
            dic.Add("贲", "fam");
            dic.Add("霙", "famd");
            dic.Add("翸", "famn");
            dic.Add("賁", "famu");
            dic.Add("墴", "famw");
            dic.Add("歕", "famw");
            dic.Add("胾", "famw");
            dic.Add("堞", "fan");
            dic.Add("烖", "faoi");
            dic.Add("靀", "fape");
            dic.Add("尭", "faqb");
            dic.Add("墆", "faqh");
            dic.Add("栽", "fas");
            dic.Add("酨", "fasg");
            dic.Add("枽", "fasu");
            dic.Add("桒", "fasu");
            dic.Add("截", "faw");
            dic.Add("塔", "fawk");
            dic.Add("塂", "fawn");
            dic.Add("塨", "fawn");
            dic.Add("埖", "fawx");
            dic.Add("垬", "fawy");
            dic.Add("裁", "fay");
            dic.Add("塃", "fayq");
            dic.Add("邗", "fbh");
            dic.Add("壭", "fbj");
            dic.Add("凷", "fbk");
            dic.Add("逇", "fbpv");
            dic.Add("霳", "fbtg");
            dic.Add("壣", "fbxg");
            dic.Add("支", "fc");
            dic.Add("弆", "fcaj");
            dic.Add("却", "fcb");
            dic.Add("叝", "fcbc");
            dic.Add("霿", "fcbh");
            dic.Add("霱", "fcbk");
            dic.Add("霧", "fcbl");
            dic.Add("雺", "fcbt");
            dic.Add("霚", "fcbt");
            dic.Add("墋", "fcce");
            dic.Add("頍", "fcdm");
            dic.Add("叆", "fcec");
            dic.Add("埇", "fceh");
            dic.Add("刦", "fcjh");
            dic.Add("朅", "fcjn");
            dic.Add("坮", "fckg");
            dic.Add("唟", "fckx");
            dic.Add("动", "fcl");
            dic.Add("盍", "fclf");
            dic.Add("劫", "fcln");
            dic.Add("攰", "fclv");
            dic.Add("鼁", "fcmv");
            dic.Add("翅", "fcn");
            dic.Add("运", "fcp");
            dic.Add("迲", "fcpi");
            dic.Add("魂", "fcr");
            dic.Add("埃", "fct");
            dic.Add("去", "fcu");
            dic.Add("云", "fcu");
            dic.Add("攳", "fcvf");
            dic.Add("刧", "fcvn");
            dic.Add("叇", "fcvp");
            dic.Add("刼", "fcvy");
            dic.Add("鳷", "fcwo");
            dic.Add("埈", "fcwt");
            dic.Add("城", "fd");
            dic.Add("堶", "fdae");
            dic.Add("坺", "fdcy");
            dic.Add("震", "fdf");
            dic.Add("雼", "fdf");
            dic.Add("堐", "fdff");
            dic.Add("垮", "fdfn");
            dic.Add("坧", "fdg");
            dic.Add("堿", "fdgt");
            dic.Add("墄", "fdht");
            dic.Add("靊", "fdhu");
            dic.Add("埯", "fdj");
            dic.Add("霏", "fdjd");
            dic.Add("坜", "fdl");
            dic.Add("雳", "fdlb");
            dic.Add("壥", "fdlf");
            dic.Add("需", "fdm");
            dic.Add("堧", "fdmd");
            dic.Add("颥", "fdmm");
            dic.Add("顬", "fdmm");
            dic.Add("顸", "fdmy");
            dic.Add("頇", "fdmy");
            dic.Add("墭", "fdnl");
            dic.Add("垯", "fdpy");
            dic.Add("塽", "fdqq");
            dic.Add("塬", "fdr");
            dic.Add("埼", "fdsk");
            dic.Add("垹", "fdtb");
            dic.Add("壢", "fdth");
            dic.Add("靂", "fdth");
            dic.Add("埲", "fdwh");
            dic.Add("堾", "fdwj");
            dic.Add("埉", "fdww");
            dic.Add("垅", "fdx");
            dic.Add("圾", "fe");
            dic.Add("垺", "febg");
            dic.Add("堋", "fee");
            dic.Add("霾", "feef");
            dic.Add("埒", "fef");
            dic.Add("埓", "fefy");
            dic.Add("坥", "fegg");
            dic.Add("霢", "fere");
            dic.Add("垜", "fesy");
            dic.Add("埰", "fesy");
            dic.Add("塪", "fevg");
            dic.Add("霡", "feyi");
            dic.Add("雭", "feyu");
            dic.Add("寺", "ff");
            dic.Add("壩", "ffae");
            dic.Add("墳", "ffam");
            dic.Add("邽", "ffbh");
            dic.Add("邿", "ffbh");
            dic.Add("坛", "ffc");
            dic.Add("霴", "ffci");
            dic.Add("靅", "ffcm");
            dic.Add("霒", "ffcn");
            dic.Add("霕", "ffcn");
            dic.Add("霼", "ffco");
            dic.Add("靆", "ffcp");
            dic.Add("靉", "ffct");
            dic.Add("雲", "ffcu");
            dic.Add("壖", "ffdj");
            dic.Add("圭", "fff");
            dic.Add("亖", "fff");
            dic.Add("墵", "fffc");
            dic.Add("垚", "ffff");
            dic.Add("堼", "ffff");
            dic.Add("壵", "ffff");
            dic.Add("鞤", "ffff");
            dic.Add("幇", "fffh");
            dic.Add("幫", "fffh");
            dic.Add("犎", "fffh");
            dic.Add("顤", "fffm");
            dic.Add("翹", "fffn");
            dic.Add("遶", "fffp");
            dic.Add("堯", "fffq");
            dic.Add("墝", "fffq");
            dic.Add("封", "fffy");
            dic.Add("奊", "ffgy");
            dic.Add("填", "ffh");
            dic.Add("埴", "ffhg");
            dic.Add("卦", "ffhy");
            dic.Add("款", "ffi");
            dic.Add("隷", "ffii");
            dic.Add("刲", "ffjh");
            dic.Add("墘", "ffjn");
            dic.Add("郌", "ffkc");
            dic.Add("壊", "ffle");
            dic.Add("劸", "ffln");
            dic.Add("鼃", "ffmv");
            dic.Add("圬", "ffn");
            dic.Add("雩", "ffnb");
            dic.Add("鄠", "ffnb");
            dic.Add("壔", "ffnf");
            dic.Add("恚", "ffnu");
            dic.Add("霊", "ffog");
            dic.Add("坃", "ffqn");
            dic.Add("堵", "fft");
            dic.Add("墙", "ffuk");
            dic.Add("墶", "ffup");
            dic.Add("墻", "ffwk");
            dic.Add("堎", "ffwt");
            dic.Add("麉", "ffyx");
            dic.Add("二", "fg");
            dic.Add("坉", "fgbn");
            dic.Add("垤", "fgc");
            dic.Add("博", "fge");
            dic.Add("埥", "fgeg");
            dic.Add("埔", "fgey");
            dic.Add("圩", "fgf");
            dic.Add("埡", "fgfg");
            dic.Add("干", "fggh");
            dic.Add("十", "fgh");
            dic.Add("寸", "fgh");
            dic.Add("士", "fghg");
            dic.Add("墕", "fgho");
            dic.Add("雫", "fghu");
            dic.Add("雨", "fghy");
            dic.Add("圷", "fghy");
            dic.Add("坏", "fgi");
            dic.Add("坯", "fgig");
            dic.Add("埂", "fgj");
            dic.Add("塼", "fgjf");
            dic.Add("垣", "fgjg");
            dic.Add("埬", "fgji");
            dic.Add("塥", "fgk");
            dic.Add("堛", "fgkl");
            dic.Add("壃", "fglg");
            dic.Add("堜", "fgli");
            dic.Add("垭", "fgo");
            dic.Add("坪", "fgu");
            dic.Add("霋", "fgvv");
            dic.Add("坘", "fgxg");
            dic.Add("塐", "fgxi");
            dic.Add("直", "fh");
            dic.Add("越", "fha");
            dic.Add("壉", "fhae");
            dic.Add("墟", "fhag");
            dic.Add("趞", "fhaj");
            dic.Add("壚", "fhal");
            dic.Add("趪", "fhaw");
            dic.Add("趣", "fhb");
            dic.Add("趉", "fhbm");
            dic.Add("坡", "fhc");
            dic.Add("趄", "fhe");
            dic.Add("矗", "fhfh");
            dic.Add("赶", "fhfk");
            dic.Add("趌", "fhfk");
            dic.Add("趬", "fhfq");
            dic.Add("址", "fhg");
            dic.Add("圵", "fhg");
            dic.Add("垰", "fhgh");
            dic.Add("趚", "fhgi");
            dic.Add("趔", "fhgj");
            dic.Add("趰", "fhgq");
            dic.Add("赴", "fhh");
            dic.Add("趠", "fhhj");
            dic.Add("趈", "fhhk");
            dic.Add("趟", "fhi");
            dic.Add("埱", "fhic");
            dic.Add("趙", "fhie");
            dic.Add("趒", "fhiq");
            dic.Add("埗", "fhit");
            dic.Add("赻", "fhit");
            dic.Add("趕", "fhjf");
            dic.Add("趧", "fhjh");
            dic.Add("亍", "fhk");
            dic.Add("坫", "fhkg");
            dic.Add("趗", "fhkh");
            dic.Add("趮", "fhks");
            dic.Add("嗭", "fhkx");
            dic.Add("盐", "fhl");
            dic.Add("塷", "fhlo");
            dic.Add("赲", "fhlv");
            dic.Add("趩", "fhlw");
            dic.Add("赸", "fhmk");
            dic.Add("趓", "fhms");
            dic.Add("起", "fhn");
            dic.Add("趐", "fhnd");
            dic.Add("赳", "fhnh");
            dic.Add("悳", "fhnn");
            dic.Add("趘", "fhnn");
            dic.Add("垆", "fhnt");
            dic.Add("惪", "fhnu");
            dic.Add("赽", "fhnw");
            dic.Add("趯", "fhny");
            dic.Add("趤", "fhpd");
            dic.Add("赵", "fhq");
            dic.Add("赿", "fhqa");
            dic.Add("趛", "fhqd");
            dic.Add("趂", "fhqi");
            dic.Add("垷", "fhqn");
            dic.Add("趜", "fhqo");
            dic.Add("趍", "fhqq");
            dic.Add("趨", "fhqt");
            dic.Add("赹", "fhqu");
            dic.Add("趋", "fhqv");
            dic.Add("赼", "fhqw");
            dic.Add("趆", "fhqy");
            dic.Add("趎", "fhri");
            dic.Add("赾", "fhrk");
            dic.Add("趃", "fhrw");
            dic.Add("趱", "fht");
            dic.Add("趏", "fhtd");
            dic.Add("趫", "fhtk");
            dic.Add("趲", "fhtm");
            dic.Add("趀", "fhtt");
            dic.Add("走", "fhu");
            dic.Add("趇", "fhud");
            dic.Add("﨣", "fhuf");
            dic.Add("趥", "fhug");
            dic.Add("趦", "fhuk");
            dic.Add("趑", "fhuw");
            dic.Add("超", "fhv");
            dic.Add("趢", "fhvi");
            dic.Add("真", "fhw");
            dic.Add("趁", "fhwe");
            dic.Add("趖", "fhwf");
            dic.Add("颠", "fhwm");
            dic.Add("顛", "fhwm");
            dic.Add("赺", "fhwn");
            dic.Add("趝", "fhwn");
            dic.Add("趭", "fhwo");
            dic.Add("鷏", "fhwo");
            dic.Add("埧", "fhwy");
            dic.Add("趡", "fhwy");
            dic.Add("圤", "fhy");
            dic.Add("示", "fi");
            dic.Add("霮", "fian");
            dic.Add("霟", "fiaw");
            dic.Add("靋", "fidh");
            dic.Add("霄", "fie");
            dic.Add("霪", "fie");
            dic.Add("祘", "fifi");
            dic.Add("霈", "fig");
            dic.Add("霑", "fihk");
            dic.Add("未", "fii");
            dic.Add("埫", "fimk");
            dic.Add("霘", "fimk");
            dic.Add("礼", "finn");
            dic.Add("壋", "fipl");
            dic.Add("霃", "fipq");
            dic.Add("雿", "fiqb");
            dic.Add("垗", "fiqn");
            dic.Add("垙", "fiqn");
            dic.Add("霂", "fisu");
            dic.Add("嫠", "fit");
            dic.Add("孷", "fitb");
            dic.Add("釐", "fitf");
            dic.Add("犛", "fith");
            dic.Add("漦", "fiti");
            dic.Add("氂", "fitn");
            dic.Add("剺", "fitv");
            dic.Add("斄", "fitw");
            dic.Add("霶", "fiuy");
            dic.Add("墚", "fiv");
            dic.Add("垱", "fivg");
            dic.Add("霗", "fiwc");
            dic.Add("塉", "fiwe");
            dic.Add("霐", "fixc");
            dic.Add("求", "fiy");
            dic.Add("皳", "fiyc");
            dic.Add("裘", "fiye");
            dic.Add("霔", "fiyg");
            dic.Add("盚", "fiyl");
            dic.Add("慦", "fiyn");
            dic.Add("逑", "fiyp");
            dic.Add("救", "fiyt");
            dic.Add("进", "fj");
            dic.Add("戟", "fja");
            dic.Add("朝", "fje");
            dic.Add("埋", "fjf");
            dic.Add("壜", "fjfc");
            dic.Add("坓", "fjff");
            dic.Add("塒", "fjff");
            dic.Add("韩", "fjfh");
            dic.Add("卌", "fjfh");
            dic.Add("垾", "fjfh");
            dic.Add("亁", "fjfn");
            dic.Add("埘", "fjfy");
            dic.Add("坦", "fjg");
            dic.Add("冓", "fjgf");
            dic.Add("斠", "fjgf");
            dic.Add("堤", "fjgh");
            dic.Add("顜", "fjgm");
            dic.Add("遘", "fjgp");
            dic.Add("觏", "fjgq");
            dic.Add("覯", "fjgq");
            dic.Add("場", "fjgr");
            dic.Add("刊", "fjh");
            dic.Add("刌", "fjh");
            dic.Add("坤", "fjhh");
            dic.Add("汬", "fjiu");
            dic.Add("亓", "fjj");
            dic.Add("", "fjj");
            dic.Add("霷", "fjjr");
            dic.Add("井", "fjk");
            dic.Add("墁", "fjl");
            dic.Add("塭", "fjlg");
            dic.Add("堣", "fjmy");
            dic.Add("塌", "fjn");
            dic.Add("電", "fjnb");
            dic.Add("韓", "fjnh");
            dic.Add("乹", "fjnn");
            dic.Add("埸", "fjq");
            dic.Add("堨", "fjqn");
            dic.Add("堁", "fjsy");
            dic.Add("乾", "fjt");
            dic.Add("刱", "fjvw");
            dic.Add("翰", "fjw");
            dic.Add("斡", "fjwf");
            dic.Add("幹", "fjwf");
            dic.Add("螒", "fjwj");
            dic.Add("鶾", "fjwo");
            dic.Add("榦", "fjws");
            dic.Add("倝", "fjwy");
            dic.Add("雗", "fjwy");
            dic.Add("堒", "fjxx");
            dic.Add("丼", "fjyi");
            dic.Add("吉", "fk");
            dic.Add("郆", "fkbh");
            dic.Add("霵", "fkbt");
            dic.Add("颉", "fkd");
            dic.Add("頡", "fkdm");
            dic.Add("袁", "fke");
            dic.Add("埍", "fkeg");
            dic.Add("遠", "fkep");
            dic.Add("喆", "fkfk");
            dic.Add("嚞", "fkfk");
            dic.Add("埕", "fkg");
            dic.Add("塿", "fkgv");
            dic.Add("圳", "fkh");
            dic.Add("露", "fkhk");
            dic.Add("墤", "fkhm");
            dic.Add("壝", "fkhp");
            dic.Add("酃", "fkk");
            dic.Add("龗", "fkkd");
            dic.Add("喪", "fkke");
            dic.Add("墠", "fkkf");
            dic.Add("霝", "fkkk");
            dic.Add("賷", "fkkm");
            dic.Add("堮", "fkkn");
            dic.Add("壧", "fkkt");
            dic.Add("孁", "fkkv");
            dic.Add("靈", "fkkw");
            dic.Add("劼", "fkln");
            dic.Add("埚", "fkm");
            dic.Add("霣", "fkmu");
            dic.Add("埙", "fkmy");
            dic.Add("塤", "fkmy");
            dic.Add("翓", "fkng");
            dic.Add("迼", "fkpd");
            dic.Add("臺", "fkpf");
            dic.Add("欯", "fkqw");
            dic.Add("喜", "fku");
            dic.Add("嘉", "fku");
            dic.Add("鼓", "fkuc");
            dic.Add("敼", "fkuc");
            dic.Add("皷", "fkuc");
            dic.Add("鼔", "fkuc");
            dic.Add("彭", "fkue");
            dic.Add("鼚", "fkue");
            dic.Add("鼙", "fkuf");
            dic.Add("壴", "fkuf");
            dic.Add("尌", "fkuf");
            dic.Add("鼞", "fkuf");
            dic.Add("鼘", "fkug");
            dic.Add("噽", "fkug");
            dic.Add("瞽", "fkuh");
            dic.Add("蟚", "fkuj");
            dic.Add("鼜", "fkuj");
            dic.Add("嚭", "fkuk");
            dic.Add("囍", "fkuk");
            dic.Add("鼛", "fkuk");
            dic.Add("甏", "fkun");
            dic.Add("壾", "fkun");
            dic.Add("憙", "fkun");
            dic.Add("熹", "fkuo");
            dic.Add("鼕", "fkuu");
            dic.Add("鼟", "fkuu");
            dic.Add("歖", "fkuw");
            dic.Add("鴶", "fkwo");
            dic.Add("协", "fl");
            dic.Add("霬", "flaw");
            dic.Add("堌", "fldg");
            dic.Add("雷", "flf");
            dic.Add("墿", "flff");
            dic.Add("靐", "flfl");
            dic.Add("堽", "flgh");
            dic.Add("夁", "flld");
            dic.Add("協", "flll");
            dic.Add("靁", "flll");
            dic.Add("皾", "flmc");
            dic.Add("覿", "flmq");
            dic.Add("賣", "flmu");
            dic.Add("畞", "flqy");
            dic.Add("堺", "flwj");
            dic.Add("塄", "fly");
            dic.Add("南", "fm");
            dic.Add("霻", "fmau");
            dic.Add("坄", "fmcy");
            dic.Add("堓", "fmdf");
            dic.Add("雵", "fmdu");
            dic.Add("坱", "fmdy");
            dic.Add("塴", "fmee");
            dic.Add("霌", "fmfk");
            dic.Add("垌", "fmg");
            dic.Add("塏", "fmgu");
            dic.Add("圸", "fmh");
            dic.Add("击", "fmk");
            dic.Add("坰", "fmkg");
            dic.Add("垇", "fmmg");
            dic.Add("垲", "fmn");
            dic.Add("堝", "fmnk");
            dic.Add("垛", "fms");
            dic.Add("堸", "fmtj");
            dic.Add("献", "fmud");
            dic.Add("堈", "fmum");
            dic.Add("遖", "fmup");
            dic.Add("埛", "fmwk");
            dic.Add("埁", "fmwn");
            dic.Add("墔", "fmwy");
            dic.Add("坝", "fmy");
            dic.Add("垻", "fmy");
            dic.Add("坍", "fmyg");
            dic.Add("志", "fn");
            dic.Add("魗", "fnac");
            dic.Add("壽", "fnaf");
            dic.Add("垊", "fnan");
            dic.Add("翿", "fnan");
            dic.Add("燾", "fnao");
            dic.Add("堀", "fnbm");
            dic.Add("逺", "fnep");
            dic.Add("墛", "fnff");
            dic.Add("霨", "fnff");
            dic.Add("堩", "fngg");
            dic.Add("韦", "fnh");
            dic.Add("霞", "fnhc");
            dic.Add("韨", "fnhc");
            dic.Add("壻", "fnhe");
            dic.Add("堳", "fnhg");
            dic.Add("韫", "fnhl");
            dic.Add("违", "fnhp");
            dic.Add("覟", "fnhq");
            dic.Add("韬", "fnhv");
            dic.Add("韧", "fnhy");
            dic.Add("墀", "fni");
            dic.Add("霹", "fnk");
            dic.Add("夀", "fnkf");
            dic.Add("壀", "fnku");
            dic.Add("馨", "fnm");
            dic.Add("聲", "fnmb");
            dic.Add("殸", "fnmc");
            dic.Add("磬", "fnmd");
            dic.Add("漀", "fnmi");
            dic.Add("韾", "fnmj");
            dic.Add("毊", "fnmk");
            dic.Add("罄", "fnmm");
            dic.Add("鏧", "fnmq");
            dic.Add("撀", "fnmr");
            dic.Add("謦", "fnmy");
            dic.Add("圯", "fnn");
            dic.Add("圮", "fnn");
            dic.Add("圠", "fnn");
            dic.Add("迃", "fnpv");
            dic.Add("声", "fnr");
            dic.Add("霫", "fnrf");
            dic.Add("场", "fnrt");
            dic.Add("忈", "fnu");
            dic.Add("塀", "fnua");
            dic.Add("卖", "fnud");
            dic.Add("觌", "fnuq");
            dic.Add("亏", "fnv");
            dic.Add("亐", "fnv");
            dic.Add("块", "fnw");
            dic.Add("坭", "fnx");
            dic.Add("专", "fny");
            dic.Add("赤", "fo");
            dic.Add("郝", "fob");
            dic.Add("赧", "fobc");
            dic.Add("頳", "fodm");
            dic.Add("赫", "fof");
            dic.Add("赭", "fofj");
            dic.Add("墣", "fogy");
            dic.Add("赪", "fohm");
            dic.Add("赬", "fohm");
            dic.Add("覝", "fohq");
            dic.Add("赨", "fojy");
            dic.Add("赮", "fonc");
            dic.Add("埮", "fooy");
            dic.Add("赩", "foqc");
            dic.Add("赥", "foqw");
            dic.Add("赦", "fot");
            dic.Add("螫", "fotj");
            dic.Add("灻", "fou");
            dic.Add("赯", "foyk");
            dic.Add("过", "fp");
            dic.Add("勃", "fpb");
            dic.Add("郣", "fpbb");
            dic.Add("孛", "fpbf");
            dic.Add("鹁", "fpbg");
            dic.Add("愂", "fpbn");
            dic.Add("鵓", "fpbo");
            dic.Add("鷇", "fpdc");
            dic.Add("蠧", "fpdj");
            dic.Add("槖", "fpds");
            dic.Add("塚", "fpey");
            dic.Add("垸", "fpf");
            dic.Add("塜", "fpfe");
            dic.Add("霥", "fpfe");
            dic.Add("壺", "fpfg");
            dic.Add("垨", "fpfy");
            dic.Add("壹", "fpg");
            dic.Add("觳", "fpg");
            dic.Add("彀", "fpgc");
            dic.Add("嗀", "fpgc");
            dic.Add("殼", "fpgc");
            dic.Add("瑴", "fpgc");
            dic.Add("皼", "fpgc");
            dic.Add("瞉", "fpgc");
            dic.Add("穀", "fpgc");
            dic.Add("糓", "fpgc");
            dic.Add("縠", "fpgc");
            dic.Add("豰", "fpgc");
            dic.Add("轂", "fpgc");
            dic.Add("嗀", "fpgc");
            dic.Add("塇", "fpgg");
            dic.Add("壸", "fpgg");
            dic.Add("壼", "fpgg");
            dic.Add("埞", "fpgh");
            dic.Add("螜", "fpgj");
            dic.Add("靌", "fpgm");
            dic.Add("懿", "fpgn");
            dic.Add("亄", "fpgn");
            dic.Add("愨", "fpgn");
            dic.Add("鷧", "fpgo");
            dic.Add("塓", "fpju");
            dic.Add("辻", "fpk");
            dic.Add("迀", "fpk");
            dic.Add("壷", "fpkg");
            dic.Add("毂", "fpl");
            dic.Add("堚", "fplh");
            dic.Add("疐", "fplh");
            dic.Add("壳", "fpm");
            dic.Add("殻", "fpmc");
            dic.Add("悫", "fpmn");
            dic.Add("坈", "fpmn");
            dic.Add("慤", "fpmn");
            dic.Add("壶", "fpo");
            dic.Add("埦", "fpqb");
            dic.Add("売", "fpqb");
            dic.Add("坾", "fpsh");
            dic.Add("垞", "fpta");
            dic.Add("榖", "fptc");
            dic.Add("垵", "fpvg");
            dic.Add("埪", "fpwa");
            dic.Add("堗", "fpwd");
            dic.Add("塎", "fpwk");
            dic.Add("靏", "fpwo");
            dic.Add("堔", "fpws");
            dic.Add("坹", "fpwy");
            dic.Add("索", "fpx");
            dic.Add("壱", "fpxb");
            dic.Add("坨", "fpxn");
            dic.Add("无", "fq");
            dic.Add("坻", "fqa");
            dic.Add("坁", "fqan");
            dic.Add("元", "fqb");
            dic.Add("圥", "fqb");
            dic.Add("邧", "fqbh");
            dic.Add("堫", "fqbt");
            dic.Add("兘", "fqck");
            dic.Add("顽", "fqd");
            dic.Add("垝", "fqdb");
            dic.Add("頑", "fqdm");
            dic.Add("埆", "fqeh");
            dic.Add("坖", "fqff");
            dic.Add("刓", "fqjh");
            dic.Add("堍", "fqk");
            dic.Add("坸", "fqkg");
            dic.Add("鼋", "fqkn");
            dic.Add("黿", "fqmv");
            dic.Add("雹", "fqn");
            dic.Add("坞", "fqng");
            dic.Add("垉", "fqnn");
            dic.Add("远", "fqp");
            dic.Add("垑", "fqqy");
            dic.Add("圽", "fqrt");
            dic.Add("均", "fqu");
            dic.Add("鋆", "fquq");
            dic.Add("埳", "fqvg");
            dic.Add("埩", "fqvh");
            dic.Add("坎", "fqw");
            dic.Add("靎", "fqwo");
            dic.Add("朮", "fqyi");
            dic.Add("塯", "fqyl");
            dic.Add("霤", "fqyl");
            dic.Add("怷", "fqyn");
            dic.Add("圴", "fqyy");
            dic.Add("垢", "fr");
            dic.Add("坂", "frc");
            dic.Add("坬", "frcy");
            dic.Add("坵", "frgg");
            dic.Add("堭", "frgg");
            dic.Add("圻", "frh");
            dic.Add("墲", "frlo");
            dic.Add("塊", "frqc");
            dic.Add("埤", "frt");
            dic.Add("坼", "fry");
            dic.Add("墽", "fryt");
            dic.Add("霜", "fs");
            dic.Add("堙", "fsf");
            dic.Add("墂", "fsfi");
            dic.Add("圢", "fsh");
            dic.Add("鹴", "fshg");
            dic.Add("鸘", "fsho");
            dic.Add("墰", "fsjh");
            dic.Add("坷", "fsk");
            dic.Add("霖", "fss");
            dic.Add("霦", "fsse");
            dic.Add("塛", "fssy");
            dic.Add("雬", "fsu");
            dic.Add("才", "ft");
            dic.Add("圫", "ftan");
            dic.Add("孝", "ftb");
            dic.Add("教", "ftbt");
            dic.Add("埄", "ftdh");
            dic.Add("墧", "ftdk");
            dic.Add("塳", "ftdp");
            dic.Add("垁", "ftdy");
            dic.Add("耂", "fte");
            dic.Add("霆", "ftf");
            dic.Add("郉", "ftfb");
            dic.Add("圲", "ftfh");
            dic.Add("垳", "ftfh");
            dic.Add("幵", "ftfh");
            dic.Add("雮", "ftfn");
            dic.Add("考", "ftg");
            dic.Add("埵", "ftgf");
            dic.Add("堹", "ftgf");
            dic.Add("耊", "ftgf");
            dic.Add("壎", "ftgo");
            dic.Add("埏", "fth");
            dic.Add("垍", "fthg");
            dic.Add("鼒", "fthn");
            dic.Add("者", "ftj");
            dic.Add("都", "ftjb");
            dic.Add("殾", "ftjc");
            dic.Add("翥", "ftjn");
            dic.Add("乽", "ftjn");
            dic.Add("煮", "ftjo");
            dic.Add("煑", "ftjo");
            dic.Add("覩", "ftjq");
            dic.Add("塲", "ftjr");
            dic.Add("斱", "ftjr");
            dic.Add("垎", "ftkg");
            dic.Add("塩", "ftkl");
            dic.Add("雾", "ftl");
            dic.Add("垧", "ftm");
            dic.Add("墺", "ftmd");
            dic.Add("塮", "ftmf");
            dic.Add("霺", "ftmt");
            dic.Add("圪", "ftn");
            dic.Add("墦", "ftol");
            dic.Add("耇", "ftqk");
            dic.Add("耉", "fttk");
            dic.Add("垀", "ftuh");
            dic.Add("雽", "ftuh");
            dic.Add("塖", "ftux");
            dic.Add("老", "ftx");
            dic.Add("耋", "ftxf");
            dic.Add("耆", "ftxj");
            dic.Add("耈", "ftxk");
            dic.Add("耄", "ftxn");
            dic.Add("霉", "ftxu");
            dic.Add("坆", "fty");
            dic.Add("攼", "fty");
            dic.Add("圦", "ftyy");
            dic.Add("增", "fu");
            dic.Add("垪", "fuah");
            dic.Add("埢", "fudb");
            dic.Add("堘", "fudf");
            dic.Add("垟", "fudh");
            dic.Add("墡", "fudk");
            dic.Add("達", "fudp");
            dic.Add("丧", "fue");
            dic.Add("壠", "fued");
            dic.Add("靇", "fued");
            dic.Add("幸", "fuf");
            dic.Add("雴", "fuf");
            dic.Add("報", "fufc");
            dic.Add("騺", "fufc");
            dic.Add("壌", "fufe");
            dic.Add("褺", "fufe");
            dic.Add("墊", "fuff");
            dic.Add("坢", "fufh");
            dic.Add("漐", "fufi");
            dic.Add("縶", "fufi");
            dic.Add("蟄", "fufj");
            dic.Add("盩", "fufl");
            dic.Add("贄", "fufm");
            dic.Add("慹", "fufn");
            dic.Add("鷙", "fufo");
            dic.Add("逹", "fufp");
            dic.Add("摯", "fufr");
            dic.Add("執", "fufy");
            dic.Add("瓡", "fufy");
            dic.Add("謺", "fufy");
            dic.Add("垃", "fug");
            dic.Add("垶", "fuh");
            dic.Add("境", "fuj");
            dic.Add("墥", "fujf");
            dic.Add("堷", "fujg");
            dic.Add("墹", "fujg");
            dic.Add("墇", "fujh");
            dic.Add("培", "fuk");
            dic.Add("増", "fulj");
            dic.Add("啬", "fulk");
            dic.Add("墒", "fum");
            dic.Add("墑", "fumd");
            dic.Add("塝", "fupy");
            dic.Add("壛", "fuqv");
            dic.Add("墫", "fusf");
            dic.Add("壿", "fusf");
            dic.Add("霎", "fuv");
            dic.Add("塧", "fuwl");
            dic.Add("霠", "fuwn");
            dic.Add("赱", "fuyu");
            dic.Add("雪", "fv");
            dic.Add("垠", "fve");
            dic.Add("垏", "fvfh");
            dic.Add("壗", "fvhl");
            dic.Add("埭", "fvi");
            dic.Add("埽", "fvp");
            dic.Add("埐", "fvpc");
            dic.Add("霓", "fvq");
            dic.Add("堄", "fvqn");
            dic.Add("堖", "fvtq");
            dic.Add("夫", "fw");
            dic.Add("邞", "fwbh");
            dic.Add("塕", "fwcn");
            dic.Add("塅", "fwdc");
            dic.Add("垘", "fwdy");
            dic.Add("替", "fwf");
            dic.Add("鄻", "fwfb");
            dic.Add("鄼", "fwfb");
            dic.Add("驇", "fwfc");
            dic.Add("坴", "fwff");
            dic.Add("暬", "fwfj");
            dic.Add("辇", "fwfl");
            dic.Add("勎", "fwfl");
            dic.Add("勢", "fwfl");
            dic.Add("輦", "fwfl");
            dic.Add("賛", "fwfm");
            dic.Add("熱", "fwfo");
            dic.Add("燅", "fwfo");
            dic.Add("鵱", "fwfo");
            dic.Add("逵", "fwfp");
            dic.Add("摰", "fwfr");
            dic.Add("槷", "fwfs");
            dic.Add("坿", "fwfy");
            dic.Add("埶", "fwfy");
            dic.Add("埨", "fwga");
            dic.Add("堬", "fwgj");
            dic.Add("垥", "fwgk");
            dic.Add("墖", "fwgl");
            dic.Add("墱", "fwgu");
            dic.Add("霯", "fwgu");
            dic.Add("鬹", "fwhh");
            dic.Add("規", "fwhq");
            dic.Add("槼", "fwhs");
            dic.Add("嫢", "fwhv");
            dic.Add("圿", "fwjh");
            dic.Add("堢", "fwks");
            dic.Add("规", "fwm");
            dic.Add("鬶", "fwmh");
            dic.Add("椝", "fwms");
            dic.Add("鼀", "fwmv");
            dic.Add("埠", "fwn");
            dic.Add("堠", "fwnd");
            dic.Add("垖", "fwnn");
            dic.Add("塢", "fwno");
            dic.Add("塠", "fwnp");
            dic.Add("夌", "fwtu");
            dic.Add("雰", "fwvb");
            dic.Add("坋", "fwvn");
            dic.Add("鳱", "fwvo");
            dic.Add("赍", "fww");
            dic.Add("嗇", "fwwk");
            dic.Add("﨏", "fwwk");
            dic.Add("賫", "fwwm");
            dic.Add("麴", "fwwo");
            dic.Add("鳺", "fwwo");
            dic.Add("墢", "fwxc");
            dic.Add("堆", "fwy");
            dic.Add("零", "fwyc");
            dic.Add("坽", "fwyc");
            dic.Add("霍", "fwyf");
            dic.Add("埝", "fwyn");
            dic.Add("坅", "fwyn");
            dic.Add("靍", "fwyo");
            dic.Add("鸖", "fwyo");
            dic.Add("靃", "fwyy");
            dic.Add("坳", "fx");
            dic.Add("毐", "fxdr");
            dic.Add("堟", "fxey");
            dic.Add("坶", "fxg");
            dic.Add("塡", "fxhw");
            dic.Add("坲", "fxjh");
            dic.Add("堦", "fxxr");
            dic.Add("霛", "fxxx");
            dic.Add("壪", "fxyx");
            dic.Add("坟", "fy");
            dic.Add("墌", "fyao");
            dic.Add("壙", "fyaw");
            dic.Add("墩", "fyb");
            dic.Add("雱", "fyb");
            dic.Add("墎", "fybb");
            dic.Add("霩", "fybb");
            dic.Add("埻", "fybg");
            dic.Add("垴", "fybh");
            dic.Add("垿", "fycb");
            dic.Add("堉", "fyce");
            dic.Add("霅", "fyf");
            dic.Add("圡", "fyi");
            dic.Add("霁", "fyj");
            dic.Add("霽", "fyjf");
            dic.Add("霭", "fyjn");
            dic.Add("靄", "fyjn");
            dic.Add("壤", "fyk");
            dic.Add("壞", "fyle");
            dic.Add("壇", "fylg");
            dic.Add("壈", "fylt");
            dic.Add("坑", "fym");
            dic.Add("塙", "fymk");
            dic.Add("坊", "fyn");
            dic.Add("垓", "fynw");
            dic.Add("塶", "fynx");
            dic.Add("塆", "fyox");
            dic.Add("壕", "fyp");
            dic.Add("圹", "fyt");
            dic.Add("雯", "fyu");
            dic.Add("塘", "fyv");
            dic.Add("埌", "fyve");
            dic.Add("墉", "fyvh");
            dic.Add("埣", "fywf");
            dic.Add("一", "g");
            dic.Add("王", "g");
            dic.Add("开", "ga");
            dic.Add("琖", "gaat");
            dic.Add("邢", "gab");
            dic.Add("琪", "gad");
            dic.Add("璂", "gadf");
            dic.Add("形", "gae");
            dic.Add("弐", "gafd");
            dic.Add("玵", "gafg");
            dic.Add("瓂", "gafl");
            dic.Add("玒", "gag");
            dic.Add("璍", "gagf");
            dic.Add("武", "gah");
            dic.Add("琊", "gahb");
            dic.Add("鹉", "gahg");
            dic.Add("璼", "gahl");
            dic.Add("虣", "gahm");
            dic.Add("鵡", "gaho");
            dic.Add("玡", "gaht");
            dic.Add("弄", "gaj");
            dic.Add("型", "gajf");
            dic.Add("刑", "gajh");
            dic.Add("畱", "gajl");
            dic.Add("丣", "gajn");
            dic.Add("瑾", "gakg");
            dic.Add("琙", "gakg");
            dic.Add("瓘", "gaky");
            dic.Add("瑛", "gam");
            dic.Add("貮", "gami");
            dic.Add("璜", "gamw");
            dic.Add("璊", "gamy");
            dic.Add("玴", "gann");
            dic.Add("烎", "gaou");
            dic.Add("璥", "gaqt");
            dic.Add("璓", "gate");
            dic.Add("珙", "gaw");
            dic.Add("瓁", "gawc");
            dic.Add("鳽", "gawo");
            dic.Add("瑹", "gawt");
            dic.Add("雃", "gawy");
            dic.Add("屯", "gb");
            dic.Add("瑘", "gbbh");
            dic.Add("瓍", "gbdp");
            dic.Add("珥", "gbg");
            dic.Add("邨", "gbnb");
            dic.Add("旾", "gbnj");
            dic.Add("顿", "gbnm");
            dic.Add("頓", "gbnm");
            dic.Add("迍", "gbnp");
            dic.Add("到", "gc");
            dic.Add("璚", "gcbk");
            dic.Add("瑈", "gcbs");
            dic.Add("戩", "gcca");
            dic.Add("晉", "gccj");
            dic.Add("至", "gcf");
            dic.Add("臻", "gcf");
            dic.Add("郅", "gcfb");
            dic.Add("臶", "gcfb");
            dic.Add("臸", "gcff");
            dic.Add("臵", "gcfk");
            dic.Add("鵄", "gcfo");
            dic.Add("致", "gcft");
            dic.Add("臹", "gcft");
            dic.Add("玛", "gcg");
            dic.Add("珆", "gckg");
            dic.Add("玧", "gcqn");
            dic.Add("丟", "gcu");
            dic.Add("瑪", "gcy");
            dic.Add("瑵", "gcyj");
            dic.Add("天", "gd");
            dic.Add("瑚", "gde");
            dic.Add("珛", "gdeg");
            dic.Add("瓇", "gdet");
            dic.Add("栞", "gdfs");
            dic.Add("蝅", "gdgj");
            dic.Add("蠺", "gdgj");
            dic.Add("珬", "gdgt");
            dic.Add("瑊", "gdgt");
            dic.Add("珔", "gdhb");
            dic.Add("玤", "gdhh");
            dic.Add("沗", "gdiu");
            dic.Add("蚕", "gdj");
            dic.Add("琲", "gdjd");
            dic.Add("奣", "gdje");
            dic.Add("吞", "gdk");
            dic.Add("顼", "gdm");
            dic.Add("瑌", "gdmd");
            dic.Add("頊", "gdmy");
            dic.Add("忝", "gdn");
            dic.Add("珹", "gdnt");
            dic.Add("迗", "gdpi");
            dic.Add("琦", "gds");
            dic.Add("瓑", "gdth");
            dic.Add("璙", "gdui");
            dic.Add("琫", "gdwh");
            dic.Add("瑃", "gdwj");
            dic.Add("鴌", "gdwo");
            dic.Add("瑧", "gdwt");
            dic.Add("珑", "gdx");
            dic.Add("表", "ge");
            dic.Add("琈", "gebg");
            dic.Add("郬", "gebh");
            dic.Add("靜", "geeh");
            dic.Add("青", "gef");
            dic.Add("瑗", "gefc");
            dic.Add("玥", "geg");
            dic.Add("珇", "gegg");
            dic.Add("甫", "geh");
            dic.Add("郙", "gehb");
            dic.Add("尃", "gehf");
            dic.Add("盙", "gehl");
            dic.Add("乶", "gehn");
            dic.Add("懯", "gehn");
            dic.Add("鵏", "geho");
            dic.Add("逋", "gehp");
            dic.Add("靚", "gehq");
            dic.Add("敷", "geht");
            dic.Add("喸", "gehx");
            dic.Add("旉", "gehy");
            dic.Add("靗", "geiq");
            dic.Add("靓", "gem");
            dic.Add("靛", "gep");
            dic.Add("瑷", "gepc");
            dic.Add("璦", "gept");
            dic.Add("静", "geq");
            dic.Add("靘", "geqc");
            dic.Add("", "geqg");
            dic.Add("瑶", "ger");
            dic.Add("靔", "gern");
            dic.Add("靝", "gero");
            dic.Add("瑫", "gevg");
            dic.Add("鶄", "gewo");
            dic.Add("琢", "gey");
            dic.Add("于", "gf");
            dic.Add("邘", "gfbh");
            dic.Add("珐", "gfc");
            dic.Add("瓀", "gfdj");
            dic.Add("珪", "gffg");
            dic.Add("亞", "gfgd");
            dic.Add("堊", "gfgf");
            dic.Add("蝁", "gfgj");
            dic.Add("惡", "gfgn");
            dic.Add("鵶", "gfgo");
            dic.Add("琧", "gfgy");
            dic.Add("玕", "gfh");
            dic.Add("瑱", "gfhw");
            dic.Add("球", "gfi");
            dic.Add("琎", "gfjp");
            dic.Add("盂", "gfl");
            dic.Add("瓄", "gflm");
            dic.Add("玮", "gfn");
            dic.Add("璹", "gfnf");
            dic.Add("瓙", "gfno");
            dic.Add("迂", "gfp");
            dic.Add("玩", "gfq");
            dic.Add("琽", "gftj");
            dic.Add("珯", "gftx");
            dic.Add("瓉", "gfwm");
            dic.Add("玞", "gfwy");
            dic.Add("五", "gg");
            dic.Add("珷", "ggah");
            dic.Add("璢", "ggal");
            dic.Add("琶", "ggc");
            dic.Add("璷", "gget");
            dic.Add("玗", "ggfh");
            dic.Add("玨", "ggg");
            dic.Add("", "gggg");
            dic.Add("戋", "gggt");
            dic.Add("璱", "gggt");
            dic.Add("环", "ggi");
            dic.Add("瑼", "ggjf");
            dic.Add("璤", "ggjn");
            dic.Add("珸", "ggkg");
            dic.Add("瓎", "ggkm");
            dic.Add("瑓", "ggli");
            dic.Add("瑟", "ggn");
            dic.Add("玙", "ggng");
            dic.Add("珁", "ggnn");
            dic.Add("瑨", "ggoj");
            dic.Add("璈", "ggqt");
            dic.Add("琹", "ggsu");
            dic.Add("玶", "gguh");
            dic.Add("琴", "ggw");
            dic.Add("珡", "ggwu");
            dic.Add("琵", "ggx");
            dic.Add("瑇", "ggxu");
            dic.Add("珏", "ggy");
            dic.Add("下", "gh");
            dic.Add("琥", "gha");
            dic.Add("瓛", "ghad");
            dic.Add("璩", "ghae");
            dic.Add("瓐", "ghal");
            dic.Add("玻", "ghc");
            dic.Add("正", "ghd");
            dic.Add("頙", "ghdm");
            dic.Add("焉", "ghg");
            dic.Add("鄢", "ghgb");
            dic.Add("靕", "ghge");
            dic.Add("卐", "ghgn");
            dic.Add("琡", "ghic");
            dic.Add("琸", "ghjh");
            dic.Add("玷", "ghk");
            dic.Add("丅", "ghk");
            dic.Add("颪", "ghmj");
            dic.Add("丐", "ghn");
            dic.Add("乤", "ghnb");
            dic.Add("亙", "ghng");
            dic.Add("丏", "ghnn");
            dic.Add("忑", "ghnu");
            dic.Add("璿", "ghph");
            dic.Add("璨", "ghq");
            dic.Add("現", "ghqn");
            dic.Add("政", "ght");
            dic.Add("鴊", "ghwo");
            dic.Add("玼", "ghxn");
            dic.Add("不", "gi");
            dic.Add("璖", "gias");
            dic.Add("奀", "gidu");
            dic.Add("甭", "gie");
            dic.Add("琑", "gieg");
            dic.Add("琺", "gifc");
            dic.Add("歪", "gig");
            dic.Add("邳", "gigb");
            dic.Add("丕", "gigf");
            dic.Add("覔", "gihq");
            dic.Add("否", "gik");
            dic.Add("盃", "gilf");
            dic.Add("琐", "gim");
            dic.Add("瑣", "gimy");
            dic.Add("还", "gip");
            dic.Add("瑺", "giph");
            dic.Add("璫", "gipl");
            dic.Add("珧", "giq");
            dic.Add("珖", "giqn");
            dic.Add("嫑", "gisv");
            dic.Add("孬", "giv");
            dic.Add("珰", "givg");
            dic.Add("珱", "givg");
            dic.Add("鴀", "giwo");
            dic.Add("理", "gj");
            dic.Add("墼", "gjff");
            dic.Add("軎", "gjfk");
            dic.Add("亘", "gjg");
            dic.Add("卝", "gjgd");
            dic.Add("芈", "gjgh");
            dic.Add("瑅", "gjgh");
            dic.Add("刯", "gjgj");
            dic.Add("茍", "gjgk");
            dic.Add("瑒", "gjgr");
            dic.Add("蘷", "gjgt");
            dic.Add("羐", "gjgy");
            dic.Add("雈", "gjgy");
            dic.Add("惠", "gjh");
            dic.Add("刬", "gjh");
            dic.Add("鄟", "gjhb");
            dic.Add("叀", "gjhc");
            dic.Add("專", "gjhf");
            dic.Add("瑁", "gjhg");
            dic.Add("珅", "gjhh");
            dic.Add("曺", "gjhj");
            dic.Add("剸", "gjhj");
            dic.Add("甎", "gjhn");
            dic.Add("鷒", "gjho");
            dic.Add("東", "gjii");
            dic.Add("鶇", "gjio");
            dic.Add("琩", "gjjg");
            dic.Add("丌", "gjk");
            dic.Add("瑥", "gjlg");
            dic.Add("更", "gjq");
            dic.Add("郠", "gjqb");
            dic.Add("甦", "gjqg");
            dic.Add("瑆", "gjtg");
            dic.Add("琨", "gjx");
            dic.Add("璟", "gjyi");
            dic.Add("琝", "gjyy");
            dic.Add("事", "gk");
            dic.Add("郚", "gkbh");
            dic.Add("琄", "gkeg");
            dic.Add("吾", "gkf");
            dic.Add("丗", "gkgd");
            dic.Add("珵", "gkgg");
            dic.Add("帯", "gkgh");
            dic.Add("羋", "gkgh");
            dic.Add("囊", "gkh");
            dic.Add("玔", "gkh");
            dic.Add("叓", "gkhc");
            dic.Add("嚢", "gkhe");
            dic.Add("蠹", "gkhj");
            dic.Add("蟗", "gkhj");
            dic.Add("璐", "gkhk");
            dic.Add("璝", "gkhm");
            dic.Add("橐", "gkhs");
            dic.Add("櫜", "gkhs");
            dic.Add("栆", "gkhu");
            dic.Add("珿", "gkhy");
            dic.Add("束", "gki");
            dic.Add("整", "gkih");
            dic.Add("剌", "gkij");
            dic.Add("勅", "gkil");
            dic.Add("赖", "gkim");
            dic.Add("賴", "gkim");
            dic.Add("頼", "gkim");
            dic.Add("慗", "gkin");
            dic.Add("鵣", "gkio");
            dic.Add("鶒", "gkio");
            dic.Add("鷘", "gkio");
            dic.Add("速", "gkip");
            dic.Add("遫", "gkip");
            dic.Add("遬", "gkip");
            dic.Add("揧", "gkir");
            dic.Add("敕", "gkit");
            dic.Add("辢", "gkiu");
            dic.Add("欶", "gkiw");
            dic.Add("亜", "gkjg");
            dic.Add("悪", "gkjn");
            dic.Add("卅", "gkk");
            dic.Add("噩", "gkkk");
            dic.Add("璪", "gkks");
            dic.Add("副", "gkl");
            dic.Add("畐", "gklf");
            dic.Add("疈", "gkll");
            dic.Add("鶝", "gklo");
            dic.Add("逼", "gklp");
            dic.Add("融", "gkm");
            dic.Add("鞷", "gkmf");
            dic.Add("鹝", "gkmg");
            dic.Add("鬲", "gkmh");
            dic.Add("鬸", "gkml");
            dic.Add("翮", "gkmn");
            dic.Add("鷊", "gkmo");
            dic.Add("鬺", "gkmr");
            dic.Add("鬷", "gkmt");
            dic.Add("鬴", "gkmy");
            dic.Add("带", "gkp");
            dic.Add("逜", "gkpd");
            dic.Add("吏", "gkq");
            dic.Add("敔", "gkty");
            dic.Add("豆", "gku");
            dic.Add("豇", "gkua");
            dic.Add("豌", "gkub");
            dic.Add("郖", "gkub");
            dic.Add("豉", "gkuc");
            dic.Add("豍", "gkuf");
            dic.Add("剅", "gkuj");
            dic.Add("頭", "gkum");
            dic.Add("毭", "gkun");
            dic.Add("豏", "gkuo");
            dic.Add("逗", "gkup");
            dic.Add("剚", "gkvj");
            dic.Add("画", "gl");
            dic.Add("珚", "gldy");
            dic.Add("盏", "glf");
            dic.Add("環", "glge");
            dic.Add("畺", "glgg");
            dic.Add("玾", "glh");
            dic.Add("柬", "gli");
            dic.Add("鶫", "glio");
            dic.Add("珈", "glk");
            dic.Add("珕", "glll");
            dic.Add("瓃", "glll");
            dic.Add("玏", "gln");
            dic.Add("琏", "glp");
            dic.Add("璉", "glpy");
            dic.Add("琾", "glwj");
            dic.Add("现", "gm");
            dic.Add("曹", "gma");
            dic.Add("遭", "gmap");
            dic.Add("琠", "gmaw");
            dic.Add("瑞", "gmd");
            dic.Add("再", "gmf");
            dic.Add("珃", "gmfg");
            dic.Add("琱", "gmfk");
            dic.Add("専", "gmfu");
            dic.Add("珮", "gmgh");
            dic.Add("珟", "gmgq");
            dic.Add("靑", "gmhg");
            dic.Add("", "gmhg");
            dic.Add("巿", "gmhk");
            dic.Add("帀", "gmhk");
            dic.Add("鳾", "gmho");
            dic.Add("迊", "gmhp");
            dic.Add("兩", "gmhy");
            dic.Add("刺", "gmi");
            dic.Add("棘", "gmii");
            dic.Add("朿", "gmii");
            dic.Add("棗", "gmii");
            dic.Add("敇", "gmit");
            dic.Add("枣", "gmiu");
            dic.Add("僰", "gmiw");
            dic.Add("襾", "gmjg");
            dic.Add("勣", "gmln");
            dic.Add("珊", "gmm");
            dic.Add("両", "gmmk");
            dic.Add("璎", "gmmv");
            dic.Add("瓔", "gmmv");
            dic.Add("玑", "gmn");
            dic.Add("恵", "gmnu");
            dic.Add("责", "gmu");
            dic.Add("責", "gmu");
            dic.Add("丙", "gmw");
            dic.Add("邴", "gmwb");
            dic.Add("瓗", "gmwk");
            dic.Add("琌", "gmwn");
            dic.Add("两", "gmww");
            dic.Add("璀", "gmwy");
            dic.Add("丽", "gmy");
            dic.Add("珼", "gmy");
            dic.Add("郦", "gmyb");
            dic.Add("酈", "gmyb");
            dic.Add("彨", "gmye");
            dic.Add("彲", "gmye");
            dic.Add("鹂", "gmyg");
            dic.Add("玬", "gmyg");
            dic.Add("鸝", "gmyo");
            dic.Add("逦", "gmyp");
            dic.Add("邐", "gmyp");
            dic.Add("婯", "gmyv");
            dic.Add("麗", "gmyx");
            dic.Add("与", "gn");
            dic.Add("珉", "gna");
            dic.Add("瑉", "gnaj");
            dic.Add("琚", "gnd");
            dic.Add("珝", "gng");
            dic.Add("欤", "gngw");
            dic.Add("瑕", "gnh");
            dic.Add("瑂", "gnhg");
            dic.Add("瑋", "gnhh");
            dic.Add("玌", "gnn");
            dic.Add("玘", "gnn");
            dic.Add("戸", "gnr");
            dic.Add("玚", "gnrt");
            dic.Add("珌", "gntt");
            dic.Add("攷", "gnty");
            dic.Add("忢", "gnu");
            dic.Add("丂", "gnv");
            dic.Add("璆", "gnwe");
            dic.Add("玦", "gnwy");
            dic.Add("瓦", "gny");
            dic.Add("邷", "gnyb");
            dic.Add("瓪", "gnyc");
            dic.Add("璻", "gnyf");
            dic.Add("瓧", "gnyf");
            dic.Add("瓩", "gnyf");
            dic.Add("瓼", "gnyf");
            dic.Add("甅", "gnyf");
            dic.Add("夨", "gnyi");
            dic.Add("瓸", "gnyj");
            dic.Add("瓱", "gnyn");
            dic.Add("瓲", "gnyn");
            dic.Add("瓰", "gnyv");
            dic.Add("来", "go");
            dic.Add("严", "god");
            dic.Add("慭", "godn");
            dic.Add("亚", "gog");
            dic.Add("戬", "goga");
            dic.Add("鄑", "gogb");
            dic.Add("垩", "gogf");
            dic.Add("晋", "gogj");
            dic.Add("恶", "gogn");
            dic.Add("璞", "gogy");
            dic.Add("灭", "goi");
            dic.Add("赉", "gom");
            dic.Add("琰", "goo");
            dic.Add("璘", "goqh");
            dic.Add("琮", "gp");
            dic.Add("辷", "gpd");
            dic.Add("迋", "gpd");
            dic.Add("琓", "gpfq");
            dic.Add("瑄", "gpgg");
            dic.Add("琔", "gpgh");
            dic.Add("璸", "gpgm");
            dic.Add("璌", "gpgw");
            dic.Add("珲", "gpl");
            dic.Add("琿", "gplh");
            dic.Add("璭", "gplp");
            dic.Add("琯", "gpnn");
            dic.Add("琬", "gpq");
            dic.Add("瑸", "gprw");
            dic.Add("琛", "gpw");
            dic.Add("瑢", "gpwk");
            dic.Add("瑏", "gpwt");
            dic.Add("列", "gq");
            dic.Add("殘", "gqaa");
            dic.Add("殣", "gqag");
            dic.Add("殢", "gqah");
            dic.Add("琘", "gqaj");
            dic.Add("尶", "gqal");
            dic.Add("殜", "gqas");
            dic.Add("殛", "gqb");
            dic.Add("殆", "gqc");
            dic.Add("琋", "gqdh");
            dic.Add("殗", "gqdn");
            dic.Add("殑", "gqdq");
            dic.Add("殝", "gqdt");
            dic.Add("殎", "gqdw");
            dic.Add("殂", "gqe");
            dic.Add("殍", "gqeb");
            dic.Add("豗", "gqei");
            dic.Add("殖", "gqf");
            dic.Add("殱", "gqfg");
            dic.Add("殰", "gqfm");
            dic.Add("殪", "gqfu");
            dic.Add("麸", "gqfw");
            dic.Add("殏", "gqfy");
            dic.Add("残", "gqg");
            dic.Add("琻", "gqg");
            dic.Add("殌", "gqga");
            dic.Add("尫", "gqgd");
            dic.Add("殭", "gqgg");
            dic.Add("殐", "gqgi");
            dic.Add("殩", "gqho");
            dic.Add("歹", "gqi");
            dic.Add("珎", "gqiy");
            dic.Add("裂", "gqje");
            dic.Add("珣", "gqjg");
            dic.Add("", "gqjg");
            dic.Add("虺", "gqji");
            dic.Add("劽", "gqjl");
            dic.Add("殟", "gqjl");
            dic.Add("烈", "gqjo");
            dic.Add("烮", "gqjo");
            dic.Add("鮤", "gqjo");
            dic.Add("鴷", "gqjo");
            dic.Add("迾", "gqjp");
            dic.Add("銐", "gqjq");
            dic.Add("姴", "gqjv");
            dic.Add("殒", "gqk");
            dic.Add("殫", "gqkf");
            dic.Add("玽", "gqkg");
            dic.Add("殞", "gqkm");
            dic.Add("殨", "gqkm");
            dic.Add("", "gqkm");
            dic.Add("殬", "gqlf");
            dic.Add("殃", "gqm");
            dic.Add("殁", "gqmc");
            dic.Add("瑍", "gqmd");
            dic.Add("瓊", "gqmt");
            dic.Add("玸", "gqnn");
            dic.Add("殡", "gqp");
            dic.Add("殯", "gqpm");
            dic.Add("殥", "gqpw");
            dic.Add("殉", "gqq");
            dic.Add("卼", "gqqb");
            dic.Add("歿", "gqqc");
            dic.Add("殙", "gqqj");
            dic.Add("歾", "gqqr");
            dic.Add("殊", "gqr");
            dic.Add("歽", "gqrh");
            dic.Add("瑤", "gqrm");
            dic.Add("歼", "gqt");
            dic.Add("聱", "gqtb");
            dic.Add("珋", "gqtb");
            dic.Add("骜", "gqtc");
            dic.Add("驁", "gqtc");
            dic.Add("獒", "gqtd");
            dic.Add("殀", "gqtd");
            dic.Add("殠", "gqtd");
            dic.Add("鳌", "gqtg");
            dic.Add("殅", "gqtg");
            dic.Add("螯", "gqtj");
            dic.Add("嗸", "gqtk");
            dic.Add("殈", "gqtl");
            dic.Add("赘", "gqtm");
            dic.Add("嶅", "gqtm");
            dic.Add("贅", "gqtm");
            dic.Add("熬", "gqto");
            dic.Add("鰲", "gqto");
            dic.Add("鷔", "gqto");
            dic.Add("遨", "gqtp");
            dic.Add("鏊", "gqtq");
            dic.Add("殇", "gqtr");
            dic.Add("摮", "gqtr");
            dic.Add("殤", "gqtr");
            dic.Add("嫯", "gqtv");
            dic.Add("鼇", "gqtv");
            dic.Add("敖", "gqty");
            dic.Add("謷", "gqty");
            dic.Add("殚", "gqu");
            dic.Add("殕", "gquk");
            dic.Add("兀", "gqv");
            dic.Add("兀", "gqv");
            dic.Add("琤", "gqvh");
            dic.Add("肂", "gqvh");
            dic.Add("殔", "gqvi");
            dic.Add("殓", "gqw");
            dic.Add("餮", "gqw");
            dic.Add("殄", "gqwe");
            dic.Add("飱", "gqwe");
            dic.Add("殲", "gqwg");
            dic.Add("殦", "gqwo");
            dic.Add("殮", "gqww");
            dic.Add("死", "gqx");
            dic.Add("玖", "gqy");
            dic.Add("瑠", "gqyl");
            dic.Add("殧", "gqyn");
            dic.Add("玓", "gqyy");
            dic.Add("珠", "gr");
            dic.Add("碧", "grd");
            dic.Add("珀", "grg");
            dic.Add("瑝", "grgg");
            dic.Add("璳", "grim");
            dic.Add("瑔", "griy");
            dic.Add("璑", "grlo");
            dic.Add("珤", "grmh");
            dic.Add("瑰", "grq");
            dic.Add("瓆", "grrm");
            dic.Add("琕", "grtf");
            dic.Add("璬", "gryt");
            dic.Add("末", "gs");
            dic.Add("膥", "gsdw");
            dic.Add("玎", "gsh");
            dic.Add("珂", "gsk");
            dic.Add("唜", "gskx");
            dic.Add("琳", "gss");
            dic.Add("璴", "gssh");
            dic.Add("瑮", "gssy");
            dic.Add("琜", "gsww");
            dic.Add("玫", "gt");
            dic.Add("麺", "gtdd");
            dic.Add("琒", "gtdh");
            dic.Add("琇", "gten");
            dic.Add("珘", "gtey");
            dic.Add("珩", "gtf");
            dic.Add("玝", "gtfh");
            dic.Add("瓒", "gtfm");
            dic.Add("瓚", "gtfm");
            dic.Add("珽", "gtfp");
            dic.Add("珗", "gtfq");
            dic.Add("珄", "gtgg");
            dic.Add("琍", "gtjh");
            dic.Add("珞", "gtk");
            dic.Add("瑀", "gtky");
            dic.Add("璁", "gtl");
            dic.Add("珦", "gtmk");
            dic.Add("琁", "gtnh");
            dic.Add("璠", "gtol");
            dic.Add("瓈", "gtqi");
            dic.Add("麹", "gtqo");
            dic.Add("珴", "gtrt");
            dic.Add("麦", "gtu");
            dic.Add("瑽", "gtwh");
            dic.Add("珻", "gtxu");
            dic.Add("平", "gu");
            dic.Add("瑳", "guda");
            dic.Add("珜", "gudh");
            dic.Add("琷", "gudn");
            dic.Add("瓏", "gued");
            dic.Add("瑐", "guej");
            dic.Add("璲", "guep");
            dic.Add("瓓", "gugi");
            dic.Add("璋", "guj");
            dic.Add("璄", "gujq");
            dic.Add("琣", "gukg");
            dic.Add("璔", "gulj");
            dic.Add("瓋", "gump");
            dic.Add("珓", "guqy");
            dic.Add("亊", "guvh");
            dic.Add("夹", "guw");
            dic.Add("郏", "guwb");
            dic.Add("刾", "guwj");
            dic.Add("颊", "guwm");
            dic.Add("頬", "guwm");
            dic.Add("珶", "guxt");
            dic.Add("妻", "gv");
            dic.Add("巠", "gvaf");
            dic.Add("璕", "gvaf");
            dic.Add("剄", "gvaj");
            dic.Add("勁", "gval");
            dic.Add("頸", "gvam");
            dic.Add("鵛", "gvao");
            dic.Add("逕", "gvap");
            dic.Add("巰", "gvaq");
            dic.Add("珢", "gvey");
            dic.Add("坙", "gvff");
            dic.Add("珒", "gvfh");
            dic.Add("璛", "gvfj");
            dic.Add("璵", "gvgw");
            dic.Add("郪", "gvhb");
            dic.Add("疌", "gvhi");
            dic.Add("璶", "gvhl");
            dic.Add("鶈", "gvho");
            dic.Add("琭", "gviy");
            dic.Add("璅", "gvjs");
            dic.Add("玿", "gvkg");
            dic.Add("瑙", "gvt");
            dic.Add("珺", "gvtk");
            dic.Add("珍", "gw");
            dic.Add("玳", "gwa");
            dic.Add("玱", "gwbn");
            dic.Add("玜", "gwcy");
            dic.Add("瑖", "gwdc");
            dic.Add("瑜", "gwg");
            dic.Add("璯", "gwgj");
            dic.Add("珨", "gwgk");
            dic.Add("璒", "gwgu");
            dic.Add("玠", "gwjh");
            dic.Add("壐", "gwmf");
            dic.Add("蠒", "gwmj");
            dic.Add("鸍", "gwmo");
            dic.Add("邇", "gwmp");
            dic.Add("爾", "gwmq");
            dic.Add("覼", "gwmq");
            dic.Add("璽", "gwmy");
            dic.Add("瑡", "gwnh");
            dic.Add("瑦", "gwno");
            dic.Add("兲", "gwu");
            dic.Add("玢", "gwv");
            dic.Add("鳿", "gwvo");
            dic.Add("玲", "gwy");
            dic.Add("玐", "gwy");
            dic.Add("琟", "gwyg");
            dic.Add("琀", "gwyk");
            dic.Add("瑲", "gwyk");
            dic.Add("玪", "gwyn");
            dic.Add("璡", "gwyp");
            dic.Add("互", "gx");
            dic.Add("瑑", "gxey");
            dic.Add("纛", "gxf");
            dic.Add("瑻", "gxfm");
            dic.Add("毒", "gxgu");
            dic.Add("璏", "gxgx");
            dic.Add("素", "gxi");
            dic.Add("繛", "gxij");
            dic.Add("瓅", "gxrs");
            dic.Add("夷", "gxw");
            dic.Add("鴺", "gxwo");
            dic.Add("玭", "gxxn");
            dic.Add("瑎", "gxxr");
            dic.Add("璣", "gxxt");
            dic.Add("玉", "gy");
            dic.Add("璃", "gyb");
            dic.Add("琉", "gyc");
            dic.Add("珫", "gycq");
            dic.Add("珳", "gyet");
            dic.Add("斑", "gyg");
            dic.Add("琂", "gyg");
            dic.Add("玣", "gyhy");
            dic.Add("玊", "gyi");
            dic.Add("琼", "gyiy");
            dic.Add("璾", "gyjg");
            dic.Add("瓖", "gyke");
            dic.Add("瓌", "gyle");
            dic.Add("璮", "gylg");
            dic.Add("班", "gyt");
            dic.Add("璇", "gyth");
            dic.Add("琅", "gyv");
            dic.Add("瑯", "gyvb");
            dic.Add("瑭", "gyvk");
            dic.Add("琗", "gywf");
            dic.Add("玹", "gyxy");
            dic.Add("玟", "gyy");
            dic.Add("上", "h");
            dic.Add("目", "h");
            dic.Add("虎", "ha");
            dic.Add("虐", "haa");
            dic.Add("瞸", "haas");
            dic.Add("睰", "hadk");
            dic.Add("遽", "hae");
            dic.Add("皻", "haec");
            dic.Add("虘", "haeg");
            dic.Add("豦", "haei");
            dic.Add("劇", "haej");
            dic.Add("勮", "hael");
            dic.Add("覰", "haeq");
            dic.Add("眶", "hag");
            dic.Add("戲", "haga");
            dic.Add("齾", "hagb");
            dic.Add("獻", "hagd");
            dic.Add("瞱", "hagf");
            dic.Add("鬳", "hagh");
            dic.Add("甗", "hagn");
            dic.Add("覻", "hagq");
            dic.Add("瞒", "hagw");
            dic.Add("頥", "hahm");
            dic.Add("瞙", "hajd");
            dic.Add("虞", "hak");
            dic.Add("瞘", "hakk");
            dic.Add("鸆", "hako");
            dic.Add("矔", "haky");
            dic.Add("瞄", "hal");
            dic.Add("膚", "hale");
            dic.Add("矒", "halh");
            dic.Add("勴", "hall");
            dic.Add("盧", "hall");
            dic.Add("虜", "hall");
            dic.Add("顱", "halm");
            dic.Add("慮", "haln");
            dic.Add("鸕", "halo");
            dic.Add("虏", "halv");
            dic.Add("虥", "hama");
            dic.Add("彪", "hame");
            dic.Add("甝", "hamf");
            dic.Add("虤", "hamm");
            dic.Add("贙", "hamm");
            dic.Add("虪", "hamo");
            dic.Add("覤", "hamq");
            dic.Add("虝", "hamr");
            dic.Add("瞞", "hamy");
            dic.Add("虑", "han");
            dic.Add("戱", "hana");
            dic.Add("歫", "hang");
            dic.Add("虛", "hang");
            dic.Add("眓", "hant");
            dic.Add("虙", "hant");
            dic.Add("虚", "hao");
            dic.Add("戯", "haoa");
            dic.Add("觑", "haoq");
            dic.Add("覷", "haoq");
            dic.Add("歔", "haow");
            dic.Add("虡", "haow");
            dic.Add("矇", "hape");
            dic.Add("眍", "haq");
            dic.Add("", "haqt");
            dic.Add("", "haqt");
            dic.Add("虗", "harg");
            dic.Add("虨", "hase");
            dic.Add("虖", "hath");
            dic.Add("處", "hatm");
            dic.Add("歑", "hatw");
            dic.Add("虍", "hav");
            dic.Add("矆", "hawc");
            dic.Add("虧", "hawn");
            dic.Add("雐", "hawy");
            dic.Add("虔", "hay");
            dic.Add("齰", "hbaj");
            dic.Add("齛", "hban");
            dic.Add("齖", "hbat");
            dic.Add("齱", "hbbc");
            dic.Add("齝", "hbck");
            dic.Add("齮", "hbdk");
            dic.Add("齟", "hbeg");
            dic.Add("齻", "hbfw");
            dic.Add("眲", "hbg");
            dic.Add("齬", "hbgk");
            dic.Add("齜", "hbhx");
            dic.Add("齒", "hbj");
            dic.Add("齥", "hbjx");
            dic.Add("齵", "hbjy");
            dic.Add("齪", "hbkh");
            dic.Add("齶", "hbkn");
            dic.Add("齞", "hbkw");
            dic.Add("齫", "hbls");
            dic.Add("齷", "hbnf");
            dic.Add("齓", "hbnn");
            dic.Add("齳", "hbpl");
            dic.Add("齣", "hbqk");
            dic.Add("齙", "hbqn");
            dic.Add("齺", "hbqt");
            dic.Add("齗", "hbrh");
            dic.Add("齭", "hbrr");
            dic.Add("齼", "hbsh");
            dic.Add("齽", "hbsi");
            dic.Add("齚", "hbtf");
            dic.Add("齕", "hbtn");
            dic.Add("齲", "hbty");
            dic.Add("齴", "hbue");
            dic.Add("齸", "hbul");
            dic.Add("齩", "hbuq");
            dic.Add("齦", "hbve");
            dic.Add("齨", "hbvg");
            dic.Add("齠", "hbvk");
            dic.Add("齯", "hbvq");
            dic.Add("齡", "hbwc");
            dic.Add("齘", "hbwj");
            dic.Add("齔", "hbxn");
            dic.Add("皮", "hc");
            dic.Add("瞲", "hcbk");
            dic.Add("颇", "hcd");
            dic.Add("頗", "hcdm");
            dic.Add("皯", "hcfh");
            dic.Add("眙", "hck");
            dic.Add("皹", "hcpl");
            dic.Add("皰", "hcqn");
            dic.Add("眸", "hcr");
            dic.Add("攴", "hcu");
            dic.Add("睃", "hcw");
            dic.Add("睚", "hd");
            dic.Add("矋", "hday");
            dic.Add("郹", "hdbh");
            dic.Add("睳", "hdff");
            dic.Add("劌", "hdgj");
            dic.Add("顪", "hdgm");
            dic.Add("翽", "hdgn");
            dic.Add("歲", "hdgt");
            dic.Add("歳", "hdgt");
            dic.Add("盽", "hdhh");
            dic.Add("頉", "hdmy");
            dic.Add("", "hdqg");
            dic.Add("狊", "hdu");
            dic.Add("瞭", "hdui");
            dic.Add("睶", "hdwj");
            dic.Add("鶪", "hdwo");
            dic.Add("眬", "hdxn");
            dic.Add("肯", "he");
            dic.Add("眀", "heg");
            dic.Add("瞬", "hep");
            dic.Add("瞹", "hept");
            dic.Add("睬", "hes");
            dic.Add("睜", "hevh");
            dic.Add("睦", "hf");
            dic.Add("睵", "hfak");
            dic.Add("歧", "hfc");
            dic.Add("瞌", "hfcl");
            dic.Add("眃", "hfcy");
            dic.Add("眭", "hff");
            dic.Add("歭", "hffy");
            dic.Add("盰", "hfh");
            dic.Add("瞋", "hfhw");
            dic.Add("眎", "hfiy");
            dic.Add("眛", "hfiy");
            dic.Add("瞦", "hfkk");
            dic.Add("盶", "hfqn");
            dic.Add("睹", "hft");
            dic.Add("瞡", "hfwq");
            dic.Add("睖", "hfwt");
            dic.Add("矐", "hfwy");
            dic.Add("睛", "hg");
            dic.Add("盹", "hgb");
            dic.Add("眰", "hgcf");
            dic.Add("丄", "hgd");
            dic.Add("盱", "hgf");
            dic.Add("鬦", "hggf");
            dic.Add("鬪", "hggf");
            dic.Add("鬮", "hggg");
            dic.Add("鬥", "hggh");
            dic.Add("鬧", "hggh");
            dic.Add("鬩", "hggq");
            dic.Add("鬬", "hggr");
            dic.Add("鬭", "hggr");
            dic.Add("鬫", "hggt");
            dic.Add("鬨", "hggw");
            dic.Add("眄", "hgh");
            dic.Add("眐", "hghg");
            dic.Add("卍", "hghn");
            dic.Add("凸", "hgm");
            dic.Add("眪", "hgmw");
            dic.Add("矖", "hgmx");
            dic.Add("歵", "hgmy");
            dic.Add("瞔", "hgmy");
            dic.Add("睐", "hgo");
            dic.Add("眜", "hgsy");
            dic.Add("睫", "hgv");
            dic.Add("眱", "hgxw");
            dic.Add("止", "hh");
            dic.Add("矑", "hhal");
            dic.Add("瞁", "hhdy");
            dic.Add("歮", "hhhf");
            dic.Add("瞐", "hhhf");
            dic.Add("丨", "hhl");
            dic.Add("亅", "hhll");
            dic.Add("鼑", "hhnn");
            dic.Add("愳", "hhnu");
            dic.Add("煛", "hhou");
            dic.Add("瞾", "hhpa");
            dic.Add("鷪", "hhpo");
            dic.Add("睍", "hhqn");
            dic.Add("卡", "hhu");
            dic.Add("歨", "hhu");
            dic.Add("矍", "hhw");
            dic.Add("戵", "hhwa");
            dic.Add("氍", "hhwn");
            dic.Add("鸜", "hhwo");
            dic.Add("瞿", "hhwy");
            dic.Add("眦", "hhx");
            dic.Add("卜", "hhy");
            dic.Add("步", "hi");
            dic.Add("叔", "hic");
            dic.Add("裻", "hice");
            dic.Add("督", "hich");
            dic.Add("惄", "hicn");
            dic.Add("錖", "hicq");
            dic.Add("频", "hid");
            dic.Add("颦", "hidf");
            dic.Add("顰", "hidf");
            dic.Add("頻", "hidm");
            dic.Add("睄", "hieg");
            dic.Add("敊", "hihc");
            dic.Add("瞠", "hip");
            dic.Add("矘", "hipo");
            dic.Add("眺", "hiq");
            dic.Add("眇", "hit");
            dic.Add("縣", "hiti");
            dic.Add("懸", "hitn");
            dic.Add("歩", "hitr");
            dic.Add("尗", "hiu");
            dic.Add("旧", "hj");
            dic.Add("睅", "hjfh");
            dic.Add("睼", "hjgh");
            dic.Add("眒", "hjhh");
            dic.Add("卓", "hjj");
            dic.Add("逴", "hjpk");
            dic.Add("児", "hjqb");
            dic.Add("睗", "hjqr");
            dic.Add("桌", "hjs");
            dic.Add("睲", "hjtg");
            dic.Add("鵫", "hjwo");
            dic.Add("占", "hk");
            dic.Add("战", "hka");
            dic.Add("梷", "hkcs");
            dic.Add("頕", "hkdm");
            dic.Add("奌", "hkdu");
            dic.Add("睊", "hkeg");
            dic.Add("睈", "hkgg");
            dic.Add("瞜", "hkgv");
            dic.Add("敁", "hkhc");
            dic.Add("瞆", "hkhm");
            dic.Add("瞶", "hkhm");
            dic.Add("覘", "hkhq");
            dic.Add("瞣", "hkkn");
            dic.Add("矂", "hkks");
            dic.Add("觇", "hkm");
            dic.Add("乩", "hkn");
            dic.Add("点", "hko");
            dic.Add("迠", "hkpd");
            dic.Add("眖", "hkqn");
            dic.Add("卤", "hl");
            dic.Add("盀", "hlf");
            dic.Add("睤", "hlgj");
            dic.Add("卣", "hln");
            dic.Add("逌", "hlnp");
            dic.Add("鹺", "hloa");
            dic.Add("鹷", "hloc");
            dic.Add("鹶", "hlon");
            dic.Add("鹻", "hloo");
            dic.Add("鹵", "hlou");
            dic.Add("鹸", "hlow");
            dic.Add("鹼", "hlow");
            dic.Add("鹹", "hloy");
            dic.Add("鹾", "hlqa");
            dic.Add("禼", "hlqc");
            dic.Add("卥", "hlry");
            dic.Add("睏", "hlsy");
            dic.Add("贞", "hm");
            dic.Add("欳", "hmaw");
            dic.Add("睓", "hmaw");
            dic.Add("眏", "hmdy");
            dic.Add("睭", "hmfk");
            dic.Add("眮", "hmgk");
            dic.Add("卨", "hmnk");
            dic.Add("遉", "hmpi");
            dic.Add("貞", "hmu");
            dic.Add("凣", "hmv");
            dic.Add("卢", "hn");
            dic.Add("眠", "hna");
            dic.Add("瞰", "hnb");
            dic.Add("鼎", "hnd");
            dic.Add("颅", "hndm");
            dic.Add("睱", "hnhc");
            dic.Add("睸", "hnhg");
            dic.Add("矚", "hnij");
            dic.Add("県", "hniu");
            dic.Add("鸬", "hnq");
            dic.Add("瞩", "hnt");
            dic.Add("忐", "hnu");
            dic.Add("郻", "hnvb");
            dic.Add("矅", "hnwy");
            dic.Add("眤", "hnxn");
            dic.Add("眯", "ho");
            dic.Add("齢", "hobc");
            dic.Add("歯", "hobj");
            dic.Add("瞨", "hogy");
            dic.Add("睒", "hooy");
            dic.Add("瞇", "hopy");
            dic.Add("瞵", "hoq");
            dic.Add("", "hovg");
            dic.Add("瞎", "hp");
            dic.Add("肻", "hpef");
            dic.Add("睆", "hpfq");
            dic.Add("壑", "hpg");
            dic.Add("叡", "hpgc");
            dic.Add("壡", "hpgf");
            dic.Add("睻", "hpgg");
            dic.Add("睿", "hpgh");
            dic.Add("矉", "hpgm");
            dic.Add("瞚", "hpgw");
            dic.Add("瞑", "hpj");
            dic.Add("睴", "hplh");
            dic.Add("矃", "hpns");
            dic.Add("眈", "hpq");
            dic.Add("睕", "hpqb");
            dic.Add("眝", "hpsh");
            dic.Add("敹", "hptt");
            dic.Add("餐", "hq");
            dic.Add("睧", "hqaj");
            dic.Add("眂", "hqan");
            dic.Add("眡", "hqay");
            dic.Add("見", "hqb");
            dic.Add("覎", "hqbd");
            dic.Add("韰", "hqcg");
            dic.Add("粲", "hqco");
            dic.Add("瞻", "hqd");
            dic.Add("睎", "hqdh");
            dic.Add("覞", "hqhq");
            dic.Add("眴", "hqjg");
            dic.Add("眗", "hqkg");
            dic.Add("眳", "hqkg");
            dic.Add("睌", "hqkq");
            dic.Add("矎", "hqmt");
            dic.Add("眵", "hqq");
            dic.Add("覐", "hqqq");
            dic.Add("覹", "hqtt");
            dic.Add("歺", "hqu");
            dic.Add("盷", "hqug");
            dic.Add("睁", "hqv");
            dic.Add("睥", "hr");
            dic.Add("眅", "hrcy");
            dic.Add("眽", "hrey");
            dic.Add("瞃", "hrfh");
            dic.Add("盺", "hrh");
            dic.Add("瞴", "hrlo");
            dic.Add("矈", "hrpy");
            dic.Add("眣", "hrwy");
            dic.Add("盯", "hs");
            dic.Add("瞟", "hsf");
            dic.Add("瞫", "hsjh");
            dic.Add("睞", "hsww");
            dic.Add("睡", "ht");
            dic.Add("歬", "hteu");
            dic.Add("眊", "htfn");
            dic.Add("歱", "htgf");
            dic.Add("矄", "htgo");
            dic.Add("矏", "hthy");
            dic.Add("矀", "htmt");
            dic.Add("盵", "htnn");
            dic.Add("瞅", "hto");
            dic.Add("矁", "hton");
            dic.Add("眨", "htp");
            dic.Add("睋", "htrt");
            dic.Add("瞗", "htvo");
            dic.Add("瞛", "htwh");
            dic.Add("瞳", "hu");
            dic.Add("睠", "hudb");
            dic.Add("眻", "hudh");
            dic.Add("眹", "hudy");
            dic.Add("矓", "hued");
            dic.Add("瞯", "hueg");
            dic.Add("眫", "hufh");
            dic.Add("瞤", "hugg");
            dic.Add("瞷", "hujg");
            dic.Add("瞕", "hujh");
            dic.Add("矙", "hunt");
            dic.Add("睇", "huxt");
            dic.Add("眼", "hv");
            dic.Add("睷", "hvfp");
            dic.Add("瞍", "hvh");
            dic.Add("睩", "hviy");
            dic.Add("眧", "hvkg");
            dic.Add("睨", "hvq");
            dic.Add("具", "hw");
            dic.Add("齿", "hwb");
            dic.Add("龉", "hwb");
            dic.Add("龀", "hwb");
            dic.Add("龄", "hwbc");
            dic.Add("龈", "hwbe");
            dic.Add("龌", "hwbf");
            dic.Add("龃", "hwbg");
            dic.Add("龊", "hwbh");
            dic.Add("龆", "hwbk");
            dic.Add("龅", "hwbn");
            dic.Add("龁", "hwbn");
            dic.Add("龂", "hwbr");
            dic.Add("龇", "hwbx");
            dic.Add("龋", "hwby");
            dic.Add("瞈", "hwcn");
            dic.Add("眕", "hwet");
            dic.Add("瞪", "hwg");
            dic.Add("睔", "hwga");
            dic.Add("睽", "hwgd");
            dic.Add("睑", "hwgi");
            dic.Add("睮", "hwgj");
            dic.Add("瞺", "hwgj");
            dic.Add("盻", "hwgn");
            dic.Add("瞼", "hwgw");
            dic.Add("睺", "hwnd");
            dic.Add("辪", "hwnu");
            dic.Add("仧", "hwu");
            dic.Add("盼", "hwv");
            dic.Add("鳪", "hwvo");
            dic.Add("睉", "hwwf");
            dic.Add("瞧", "hwy");
            dic.Add("睢", "hwyg");
            dic.Add("此", "hx");
            dic.Add("砦", "hxd");
            dic.Add("些", "hxf");
            dic.Add("祡", "hxfi");
            dic.Add("眥", "hxhf");
            dic.Add("歶", "hxjy");
            dic.Add("呰", "hxkf");
            dic.Add("啙", "hxkk");
            dic.Add("眑", "hxln");
            dic.Add("赀", "hxm");
            dic.Add("貲", "hxmu");
            dic.Add("胔", "hxmw");
            dic.Add("觜", "hxq");
            dic.Add("鈭", "hxqf");
            dic.Add("鮆", "hxqo");
            dic.Add("矊", "hxrh");
            dic.Add("柴", "hxs");
            dic.Add("姕", "hxvf");
            dic.Add("雌", "hxw");
            dic.Add("飺", "hxwe");
            dic.Add("鴜", "hxwo");
            dic.Add("紫", "hxx");
            dic.Add("訾", "hxy");
            dic.Add("眩", "hy");
            dic.Add("矌", "hyaw");
            dic.Add("瞝", "hybc");
            dic.Add("瞮", "hyct");
            dic.Add("瞓", "hykh");
            dic.Add("眆", "hyn");
            dic.Add("睙", "hynd");
            dic.Add("眿", "hyni");
            dic.Add("盳", "hynn");
            dic.Add("瞊", "hyvk");
            dic.Add("睟", "hywf");
            dic.Add("盿", "hyy");
            dic.Add("水", "i");
            dic.Add("江", "ia");
            dic.Add("灆", "iaal");
            dic.Add("淺", "iaat");
            dic.Add("湛", "iad");
            dic.Add("漭", "iada");
            dic.Add("濝", "iadi");
            dic.Add("渃", "iadk");
            dic.Add("澒", "iadm");
            dic.Add("頮", "iadm");
            dic.Add("颒", "iadm");
            dic.Add("澌", "iadr");
            dic.Add("淇", "iadw");
            dic.Add("浳", "iaeg");
            dic.Add("潵", "iaet");
            dic.Add("泔", "iaf");
            dic.Add("濭", "iafl");
            dic.Add("湈", "iafs");
            dic.Add("澕", "iagf");
            dic.Add("洭", "iagg");
            dic.Add("懑", "iagn");
            dic.Add("满", "iagw");
            dic.Add("淽", "iahg");
            dic.Add("洍", "iahh");
            dic.Add("瀶", "iahk");
            dic.Add("濫", "iahl");
            dic.Add("灠", "iahq");
            dic.Add("漠", "iaj");
            dic.Add("濗", "iajh");
            dic.Add("澫", "iajy");
            dic.Add("灌", "iak");
            dic.Add("淢", "iakg");
            dic.Add("漌", "iakg");
            dic.Add("漚", "iakk");
            dic.Add("漢", "iakw");
            dic.Add("灘", "iaky");
            dic.Add("渵", "ialg");
            dic.Add("瀎", "ialt");
            dic.Add("潢", "iam");
            dic.Add("渶", "iamd");
            dic.Add("満", "iamm");
            dic.Add("懣", "iamn");
            dic.Add("滿", "iamy");
            dic.Add("汇", "ian");
            dic.Add("渫", "ian");
            dic.Add("洰", "iang");
            dic.Add("泄", "iann");
            dic.Add("渠", "ians");
            dic.Add("泧", "iant");
            dic.Add("涝", "iap");
            dic.Add("濛", "iape");
            dic.Add("潆", "iapi");
            dic.Add("溁", "iaps");
            dic.Add("滢", "iapy");
            dic.Add("沤", "iaq");
            dic.Add("鸿", "iaqg");
            dic.Add("滯", "iaqh");
            dic.Add("灊", "iaqh");
            dic.Add("潛", "iaqj");
            dic.Add("懘", "iaqn");
            dic.Add("濍", "iaqn");
            dic.Add("柒", "ias");
            dic.Add("渮", "iask");
            dic.Add("浇", "iat");
            dic.Add("灡", "iaui");
            dic.Add("沏", "iav");
            dic.Add("瀟", "iavh");
            dic.Add("潇", "iavj");
            dic.Add("洪", "iaw");
            dic.Add("濩", "iawc");
            dic.Add("溚", "iawk");
            dic.Add("濸", "iawk");
            dic.Add("港", "iawn");
            dic.Add("鴻", "iawo");
            dic.Add("鍙", "iawq");
            dic.Add("滙", "iawy");
            dic.Add("淓", "iayn");
            dic.Add("瀳", "iayo");
            dic.Add("池", "ib");
            dic.Add("灄", "ibbb");
            dic.Add("滠", "ibc");
            dic.Add("瀡", "ibdp");
            dic.Add("洱", "ibg");
            dic.Add("汓", "ibg");
            dic.Add("滍", "ibhj");
            dic.Add("涵", "ibi");
            dic.Add("洆", "ibig");
            dic.Add("凼", "ibk");
            dic.Add("濻", "ibkm");
            dic.Add("泐", "ibl");
            dic.Add("泏", "ibmh");
            dic.Add("氾", "ibn");
            dic.Add("漋", "ibtg");
            dic.Add("滁", "ibw");
            dic.Add("汉", "ic");
            dic.Add("泾", "ica");
            dic.Add("汿", "icbh");
            dic.Add("沀", "icbh");
            dic.Add("潏", "icbk");
            dic.Add("滪", "icbm");
            dic.Add("澦", "icbm");
            dic.Add("渘", "icbs");
            dic.Add("涰", "iccc");
            dic.Add("滲", "icce");
            dic.Add("渗", "icd");
            dic.Add("涌", "ice");
            dic.Add("湧", "icel");
            dic.Add("慂", "icen");
            dic.Add("泽", "icf");
            dic.Add("治", "ick");
            dic.Add("沇", "icqn");
            dic.Add("洠", "icrh");
            dic.Add("涘", "ictd");
            dic.Add("滩", "icw");
            dic.Add("浚", "icwt");
            dic.Add("溤", "icy");
            dic.Add("溞", "icyj");
            dic.Add("汊", "icyy");
            dic.Add("尖", "id");
            dic.Add("濿", "iday");
            dic.Add("汯", "idcy");
            dic.Add("沷", "idcy");
            dic.Add("湖", "ide");
            dic.Add("洧", "ide");
            dic.Add("瀀", "idet");
            dic.Add("涱", "idey");
            dic.Add("涯", "idf");
            dic.Add("溽", "idf");
            dic.Add("沯", "idf");
            dic.Add("渀", "idfa");
            dic.Add("浱", "idfe");
            dic.Add("漘", "idfe");
            dic.Add("滣", "idfk");
            dic.Add("洿", "idfn");
            dic.Add("沽", "idg");
            dic.Add("沰", "idg");
            dic.Add("澸", "idgn");
            dic.Add("減", "idgt");
            dic.Add("滅", "idgt");
            dic.Add("沣", "idh");
            dic.Add("洊", "idhb");
            dic.Add("滟", "idhc");
            dic.Add("灧", "idhc");
            dic.Add("湱", "idhd");
            dic.Add("潔", "idhi");
            dic.Add("灩", "idhl");
            dic.Add("灃", "idhu");
            dic.Add("尜", "idi");
            dic.Add("洡", "idiy");
            dic.Add("淹", "idj");
            dic.Add("渄", "idjd");
            dic.Add("湹", "idjf");
            dic.Add("洦", "idjg");
            dic.Add("沥", "idl");
            dic.Add("湎", "idm");
            dic.Add("渜", "idmd");
            dic.Add("洏", "idmj");
            dic.Add("湏", "idmy");
            dic.Add("浝", "idne");
            dic.Add("沋", "idnn");
            dic.Add("厳", "idnt");
            dic.Add("洃", "idoy");
            dic.Add("", "idpy");
            dic.Add("漺", "idqq");
            dic.Add("源", "idr");
            dic.Add("渏", "idsk");
            dic.Add("涛", "idt");
            dic.Add("瀝", "idth");
            dic.Add("潦", "idui");
            dic.Add("溱", "idw");
            dic.Add("湊", "idwd");
            dic.Add("淎", "idwh");
            dic.Add("溙", "idwi");
            dic.Add("湷", "idwj");
            dic.Add("浹", "idww");
            dic.Add("泷", "idx");
            dic.Add("汰", "idy");
            dic.Add("汏", "idy");
            dic.Add("汱", "idy");
            dic.Add("肖", "ie");
            dic.Add("濦", "iean");
            dic.Add("浮", "ieb");
            dic.Add("淝", "iec");
            dic.Add("溋", "iecl");
            dic.Add("淜", "ieeg");
            dic.Add("湲", "iefc");
            dic.Add("瀦", "iefj");
            dic.Add("渓", "iefw");
            dic.Add("浖", "iefy");
            dic.Add("沮", "ieg");
            dic.Add("漞", "iehq");
            dic.Add("削", "iej");
            dic.Add("揱", "iejr");
            dic.Add("灂", "ielf");
            dic.Add("逍", "iep");
            dic.Add("涭", "iepc");
            dic.Add("滛", "ierm");
            dic.Add("淫", "iet");
            dic.Add("潙", "ieto");
            dic.Add("滔", "iev");
            dic.Add("浽", "ievg");
            dic.Add("淨", "ievh");
            dic.Add("溪", "iex");
            dic.Add("鸂", "iexo");
            dic.Add("汲", "iey");
            dic.Add("涿", "iey");
            dic.Add("法", "if");
            dic.Add("灞", "ifa");
            dic.Add("瀐", "ifag");
            dic.Add("泋", "ifah");
            dic.Add("渽", "ifak");
            dic.Add("濆", "ifam");
            dic.Add("溨", "ifas");
            dic.Add("瀻", "ifaw");
            dic.Add("溘", "ifcl");
            dic.Add("汥", "ifcy");
            dic.Add("沄", "ifcy");
            dic.Add("濡", "ifd");
            dic.Add("尘", "iff");
            dic.Add("坔", "iff");
            dic.Add("澐", "iffc");
            dic.Add("湗", "ifff");
            dic.Add("洼", "iffg");
            dic.Add("澆", "iffq");
            dic.Add("洔", "iffy");
            dic.Add("汢", "ifg");
            dic.Add("汗", "ifh");
            dic.Add("汁", "ifh");
            dic.Add("淔", "ifhg");
            dic.Add("滇", "ifhw");
            dic.Add("沬", "ifiy");
            dic.Add("沶", "ifiy");
            dic.Add("浗", "ifiy");
            dic.Add("潮", "ifj");
            dic.Add("溝", "ifjf");
            dic.Add("澣", "ifjf");
            dic.Add("濣", "ifjf");
            dic.Add("汫", "ifjh");
            dic.Add("瀚", "ifjn");
            dic.Add("漧", "ifjn");
            dic.Add("洁", "ifk");
            dic.Add("澎", "ifke");
            dic.Add("溒", "ifke");
            dic.Add("澍", "ifkf");
            dic.Add("瀆", "iflm");
            dic.Add("湳", "ifmf");
            dic.Add("污", "ifn");
            dic.Add("渎", "ifnd");
            dic.Add("濤", "ifnf");
            dic.Add("汚", "ifnn");
            dic.Add("浾", "ifoy");
            dic.Add("渤", "ifp");
            dic.Add("浡", "ifpb");
            dic.Add("濲", "ifpc");
            dic.Add("瀔", "ifpc");
            dic.Add("瀫", "ifpc");
            dic.Add("溹", "ifpi");
            dic.Add("涜", "ifpq");
            dic.Add("潱", "ifpu");
            dic.Add("沅", "ifq");
            dic.Add("灀", "ifsh");
            dic.Add("瀮", "ifss");
            dic.Add("渚", "ift");
            dic.Add("涍", "iftb");
            dic.Add("洘", "iftn");
            dic.Add("漖", "iftt");
            dic.Add("涬", "ifuf");
            dic.Add("澾", "ifup");
            dic.Add("潜", "ifw");
            dic.Add("澪", "ifwc");
            dic.Add("淕", "ifwf");
            dic.Add("濇", "ifwk");
            dic.Add("濽", "ifwm");
            dic.Add("淩", "ifwt");
            dic.Add("瀖", "ifwy");
            dic.Add("汪", "ig");
            dic.Add("汧", "igah");
            dic.Add("澑", "igal");
            dic.Add("沌", "igb");
            dic.Add("洷", "igcf");
            dic.Add("添", "igd");
            dic.Add("清", "ige");
            dic.Add("濪", "igec");
            dic.Add("溥", "igef");
            dic.Add("瀞", "igeh");
            dic.Add("浦", "igey");
            dic.Add("汙", "igfh");
            dic.Add("盓", "igfl");
            dic.Add("潖", "iggc");
            dic.Add("濏", "iggt");
            dic.Add("沔", "igh");
            dic.Add("泟", "ighg");
            dic.Add("漹", "igho");
            dic.Add("洹", "igj");
            dic.Add("漙", "igjf");
            dic.Add("涷", "igji");
            dic.Add("潓", "igjn");
            dic.Add("浭", "igjq");
            dic.Add("滞", "igk");
            dic.Add("灢", "igke");
            dic.Add("浯", "igkg");
            dic.Add("滆", "igkh");
            dic.Add("涑", "igki");
            dic.Add("溂", "igkj");
            dic.Add("瀜", "igkj");
            dic.Add("湢", "igkl");
            dic.Add("濑", "igkm");
            dic.Add("瀨", "igkm");
            dic.Add("瀬", "igkm");
            dic.Add("潄", "igkt");
            dic.Add("浢", "igku");
            dic.Add("漱", "igkw");
            dic.Add("湅", "igli");
            dic.Add("渍", "igm");
            dic.Add("洅", "igmf");
            dic.Add("淸", "igmg");
            dic.Add("沛", "igmh");
            dic.Add("沞", "igmh");
            dic.Add("洓", "igmi");
            dic.Add("漕", "igmj");
            dic.Add("灑", "igmx");
            dic.Add("漬", "igmy");
            dic.Add("汅", "ignn");
            dic.Add("涞", "igo");
            dic.Add("溍", "igoj");
            dic.Add("洌", "igq");
            dic.Add("滶", "igqt");
            dic.Add("沫", "igs");
            dic.Add("浅", "igt");
            dic.Add("浃", "igu");
            dic.Add("泙", "iguh");
            dic.Add("涇", "igva");
            dic.Add("湽", "igvl");
            dic.Add("淒", "igvv");
            dic.Add("濔", "igwq");
            dic.Add("溼", "igxf");
            dic.Add("沍", "igxg");
            dic.Add("溸", "igxi");
            dic.Add("洟", "igxw");
            dic.Add("小", "ih");
            dic.Add("滤", "iha");
            dic.Add("澞", "ihad");
            dic.Add("滮", "ihae");
            dic.Add("澽", "ihae");
            dic.Add("滹", "ihah");
            dic.Add("瀘", "ihal");
            dic.Add("淲", "iham");
            dic.Add("濾", "ihan");
            dic.Add("波", "ihc");
            dic.Add("碆", "ihcd");
            dic.Add("錃", "ihcq");
            dic.Add("婆", "ihcv");
            dic.Add("濊", "ihdt");
            dic.Add("湨", "ihdy");
            dic.Add("泪", "ihg");
            dic.Add("沚", "ihg");
            dic.Add("澁", "ihhh");
            dic.Add("灈", "ihhy");
            dic.Add("涉", "ihi");
            dic.Add("渺", "ihi");
            dic.Add("淑", "ihic");
            dic.Add("濒", "ihim");
            dic.Add("瀕", "ihim");
            dic.Add("渉", "ihit");
            dic.Add("渋", "ihiy");
            dic.Add("淖", "ihj");
            dic.Add("沾", "ihk");
            dic.Add("惉", "ihkn");
            dic.Add("滷", "ihlo");
            dic.Add("浈", "ihm");
            dic.Add("湞", "ihmy");
            dic.Add("泸", "ihn");
            dic.Add("濎", "ihnn");
            dic.Add("濬", "ihph");
            dic.Add("瀣", "ihq");
            dic.Add("覍", "ihqb");
            dic.Add("涀", "ihqn");
            dic.Add("澯", "ihqo");
            dic.Add("濉", "ihw");
            dic.Add("泚", "ihxn");
            dic.Add("", "ihyt");
            dic.Add("氺", "ihyy");
            dic.Add("濷", "iiay");
            dic.Add("消", "iie");
            dic.Add("淼", "iiiu");
            dic.Add("尛", "iiiu");
            dic.Add("渁", "iiiy");
            dic.Add("涾", "iijg");
            dic.Add("淌", "iim");
            dic.Add("溑", "iimy");
            dic.Add("漟", "iipf");
            dic.Add("澢", "iipl");
            dic.Add("灙", "iipo");
            dic.Add("洮", "iiq");
            dic.Add("洸", "iiqn");
            dic.Add("沙", "iit");
            dic.Add("硰", "iitd");
            dic.Add("裟", "iite");
            dic.Add("鲨", "iitg");
            dic.Add("渻", "iith");
            dic.Add("乷", "iitn");
            dic.Add("鯊", "iito");
            dic.Add("逤", "iitp");
            dic.Add("挲", "iitr");
            dic.Add("桬", "iits");
            dic.Add("娑", "iitv");
            dic.Add("沝", "iiy");
            dic.Add("浊", "ij");
            dic.Add("瀑", "ija");
            dic.Add("滭", "ijaf");
            dic.Add("渱", "ijag");
            dic.Add("沓", "ijf");
            dic.Add("戦", "ijfa");
            dic.Add("溡", "ijff");
            dic.Add("濹", "ijff");
            dic.Add("涅", "ijfg");
            dic.Add("浬", "ijfg");
            dic.Add("涆", "ijfh");
            dic.Add("単", "ijfj");
            dic.Add("濐", "ijfj");
            dic.Add("汩", "ijg");
            dic.Add("汨", "ijg");
            dic.Add("鼝", "ijgc");
            dic.Add("淏", "ijgd");
            dic.Add("淂", "ijgf");
            dic.Add("淵", "ijgg");
            dic.Add("泹", "ijgg");
            dic.Add("浉", "ijgh");
            dic.Add("湜", "ijgh");
            dic.Add("盪", "ijgl");
            dic.Add("燙", "ijgo");
            dic.Add("湯", "ijgr");
            dic.Add("璗", "ijgy");
            dic.Add("虩", "ijim");
            dic.Add("滉", "ijiq");
            dic.Add("淐", "ijjg");
            dic.Add("温", "ijl");
            dic.Add("漫", "ijlc");
            dic.Add("澷", "ijly");
            dic.Add("湡", "ijmy");
            dic.Add("溻", "ijn");
            dic.Add("湿", "ijo");
            dic.Add("渴", "ijq");
            dic.Add("渇", "ijqx");
            dic.Add("巣", "ijsu");
            dic.Add("淉", "ijsy");
            dic.Add("滥", "ijt");
            dic.Add("湦", "ijtg");
            dic.Add("混", "ijx");
            dic.Add("灦", "ijxm");
            dic.Add("濕", "ijxo");
            dic.Add("洩", "ijxt");
            dic.Add("灗", "ijyg");
            dic.Add("澋", "ijyi");
            dic.Add("灏", "ijym");
            dic.Add("灝", "ijym");
            dic.Add("渂", "ijyy");
            dic.Add("澡", "ik");
            dic.Add("湒", "ikbg");
            dic.Add("濈", "ikbt");
            dic.Add("浥", "ikcn");
            dic.Add("涓", "ike");
            dic.Add("呇", "ikf");
            dic.Add("洖", "ikgd");
            dic.Add("塣", "ikgf");
            dic.Add("浧", "ikgg");
            dic.Add("漊", "ikgv");
            dic.Add("溃", "ikh");
            dic.Add("汌", "ikh");
            dic.Add("沖", "ikhh");
            dic.Add("潞", "ikhk");
            dic.Add("潰", "ikhm");
            dic.Add("瀢", "ikhp");
            dic.Add("浞", "ikhy");
            dic.Add("渑", "ikj");
            dic.Add("潬", "ikkf");
            dic.Add("澏", "ikkm");
            dic.Add("漶", "ikkn");
            dic.Add("湂", "ikkn");
            dic.Add("涡", "ikm");
            dic.Add("涢", "ikmy");
            dic.Add("溳", "ikmy");
            dic.Add("況", "ikqn");
            dic.Add("渐", "il");
            dic.Add("漍", "ilag");
            dic.Add("潩", "ilaw");
            dic.Add("涸", "ild");
            dic.Add("瀱", "ildj");
            dic.Add("洇", "ildy");
            dic.Add("渭", "ile");
            dic.Add("溷", "iley");
            dic.Add("涠", "ilf");
            dic.Add("泴", "ilf");
            dic.Add("畄", "ilf");
            dic.Add("畓", "ilf");
            dic.Add("澤", "ilff");
            dic.Add("濖", "ilfj");
            dic.Add("潶", "ilfo");
            dic.Add("泗", "ilg");
            dic.Add("沺", "ilg");
            dic.Add("獣", "ilgd");
            dic.Add("渨", "ilge");
            dic.Add("澴", "ilge");
            dic.Add("淠", "ilgj");
            dic.Add("洄", "ilk");
            dic.Add("泇", "ilkg");
            dic.Add("灅", "illf");
            dic.Add("氻", "iln");
            dic.Add("潿", "ilnh");
            dic.Add("涟", "ilp");
            dic.Add("漣", "ilpy");
            dic.Add("濁", "ilqj");
            dic.Add("聻", "ilrb");
            dic.Add("魙", "ilrc");
            dic.Add("壍", "ilrf");
            dic.Add("漸", "ilrh");
            dic.Add("嬱", "ilrv");
            dic.Add("涃", "ilsy");
            dic.Add("溿", "iluf");
            dic.Add("泅", "ilw");
            dic.Add("瀭", "ilwj");
            dic.Add("溫", "ilwl");
            dic.Add("溭", "ilwt");
            dic.Add("潀", "ilwu");
            dic.Add("漯", "ilx");
            dic.Add("没", "im");
            dic.Add("澧", "ima");
            dic.Add("濺", "imaa");
            dic.Add("灔", "imac");
            dic.Add("濃", "imae");
            dic.Add("浀", "imag");
            dic.Add("灎", "imal");
            dic.Add("淟", "imaw");
            dic.Add("湍", "imd");
            dic.Add("漄", "imdf");
            dic.Add("湠", "imdo");
            dic.Add("泱", "imdy");
            dic.Add("滑", "ime");
            dic.Add("漰", "imee");
            dic.Add("鼡", "imfh");
            dic.Add("淍", "imfk");
            dic.Add("油", "img");
            dic.Add("洞", "imgk");
            dic.Add("涄", "imgn");
            dic.Add("洬", "imgq");
            dic.Add("溅", "imgt");
            dic.Add("溦", "imgt");
            dic.Add("澂", "imgt");
            dic.Add("溰", "imgu");
            dic.Add("澠", "imgv");
            dic.Add("汕", "imh");
            dic.Add("测", "imj");
            dic.Add("測", "imjh");
            dic.Add("瀃", "imjr");
            dic.Add("潉", "imjx");
            dic.Add("沿", "imk");
            dic.Add("尚", "imkf");
            dic.Add("尙", "imkf");
            dic.Add("泂", "imkg");
            dic.Add("幤", "imkh");
            dic.Add("氅", "imkn");
            dic.Add("敞", "imkt");
            dic.Add("瀴", "immv");
            dic.Add("渦", "imnk");
            dic.Add("濄", "imnp");
            dic.Add("漴", "impi");
            dic.Add("沨", "imqy");
            dic.Add("溄", "imth");
            dic.Add("渢", "imtj");
            dic.Add("潂", "imug");
            dic.Add("涔", "imw");
            dic.Add("浻", "imwk");
            dic.Add("汭", "imwy");
            dic.Add("漼", "imwy");
            dic.Add("浿", "imy");
            dic.Add("浵", "imye");
            dic.Add("盕", "imyl");
            dic.Add("汎", "imyy");
            dic.Add("沁", "in");
            dic.Add("泯", "ina");
            dic.Add("澱", "inac");
            dic.Add("湣", "inaj");
            dic.Add("澉", "inb");
            dic.Add("潺", "inbb");
            dic.Add("淈", "inbm");
            dic.Add("涺", "indg");
            dic.Add("汛", "inf");
            dic.Add("沑", "infg");
            dic.Add("潳", "infj");
            dic.Add("漏", "infy");
            dic.Add("渥", "ing");
            dic.Add("汈", "ingg");
            dic.Add("泀", "ingk");
            dic.Add("湄", "inh");
            dic.Add("溊", "inhc");
            dic.Add("湑", "inhe");
            dic.Add("湋", "inhh");
            dic.Add("漽", "inih");
            dic.Add("灟", "inij");
            dic.Add("浺", "inkh");
            dic.Add("澼", "inku");
            dic.Add("瀷", "inlw");
            dic.Add("涮", "inm");
            dic.Add("汜", "inn");
            dic.Add("潠", "innw");
            dic.Add("瀈", "inpl");
            dic.Add("汤", "inr");
            dic.Add("漝", "inrg");
            dic.Add("烫", "inro");
            dic.Add("泌", "int");
            dic.Add("湉", "intd");
            dic.Add("浘", "intn");
            dic.Add("泼", "inty");
            dic.Add("泦", "invn");
            dic.Add("濯", "inw");
            dic.Add("漻", "inwe");
            dic.Add("決", "inwy");
            dic.Add("泥", "inx");
            dic.Add("埿", "inxf");
            dic.Add("濢", "inyf");
            dic.Add("瀥", "inyk");
            dic.Add("浕", "inyu");
            dic.Add("泤", "inyw");
            dic.Add("沢", "inyy");
            dic.Add("淡", "io");
            dic.Add("灇", "iogc");
            dic.Add("濧", "iogf");
            dic.Add("澲", "iogw");
            dic.Add("瀵", "iol");
            dic.Add("濴", "iooi");
            dic.Add("瀠", "iooi");
            dic.Add("瀯", "iook");
            dic.Add("澇", "iool");
            dic.Add("濙", "iooo");
            dic.Add("灐", "iooq");
            dic.Add("濚", "ioos");
            dic.Add("瀅", "iooy");
            dic.Add("潾", "ioqh");
            dic.Add("溇", "iovg");
            dic.Add("洣", "ioy");
            dic.Add("学", "ip");
            dic.Add("黉", "ipa");
            dic.Add("", "ipb");
            dic.Add("敩", "ipbt");
            dic.Add("浤", "ipdc");
            dic.Add("瀗", "ipdn");
            dic.Add("涋", "ipdy");
            dic.Add("浓", "ipe");
            dic.Add("尝", "ipf");
            dic.Add("滱", "ipfc");
            dic.Add("坣", "ipff");
            dic.Add("瀽", "ipfh");
            dic.Add("淙", "ipfi");
            dic.Add("浣", "ipfq");
            dic.Add("演", "ipg");
            dic.Add("渲", "ipg");
            dic.Add("溕", "ipge");
            dic.Add("泻", "ipgg");
            dic.Add("淀", "ipgh");
            dic.Add("濱", "ipgm");
            dic.Add("漃", "iphc");
            dic.Add("覚", "iphq");
            dic.Add("泶", "ipi");
            dic.Add("渖", "ipj");
            dic.Add("溟", "ipju");
            dic.Add("蛍", "ipju");
            dic.Add("党", "ipk");
            dic.Add("裳", "ipke");
            dic.Add("堂", "ipkf");
            dic.Add("甞", "ipkf");
            dic.Add("常", "ipkh");
            dic.Add("劏", "ipkj");
            dic.Add("嘗", "ipkj");
            dic.Add("営", "ipkk");
            dic.Add("當", "ipkl");
            dic.Add("赏", "ipkm");
            dic.Add("賞", "ipkm");
            dic.Add("瓽", "ipkn");
            dic.Add("黨", "ipko");
            dic.Add("掌", "ipkr");
            dic.Add("棠", "ipks");
            dic.Add("牚", "ipkt");
            dic.Add("浑", "ipl");
            dic.Add("労", "iplb");
            dic.Add("渾", "iplh");
            dic.Add("沉", "ipm");
            dic.Add("峃", "ipmj");
            dic.Add("觉", "ipmq");
            dic.Add("涫", "ipn");
            dic.Add("澝", "ipne");
            dic.Add("滵", "ipnm");
            dic.Add("濵", "ipnm");
            dic.Add("濘", "ipns");
            dic.Add("淧", "ipnt");
            dic.Add("沈", "ipq");
            dic.Add("涴", "ipqb");
            dic.Add("鲎", "ipqg");
            dic.Add("鸴", "ipqg");
            dic.Add("滨", "ipr");
            dic.Add("浶", "iprh");
            dic.Add("泞", "ips");
            dic.Add("栄", "ipsu");
            dic.Add("浨", "ipsy");
            dic.Add("喾", "ipt");
            dic.Add("瀋", "iptl");
            dic.Add("滓", "ipu");
            dic.Add("濅", "ipvc");
            dic.Add("洝", "ipvg");
            dic.Add("瀉", "ipvo");
            dic.Add("深", "ipw");
            dic.Add("涳", "ipwa");
            dic.Add("湥", "ipwd");
            dic.Add("浫", "ipwf");
            dic.Add("漥", "ipwf");
            dic.Add("潌", "ipwf");
            dic.Add("溶", "ipwk");
            dic.Add("滘", "ipwk");
            dic.Add("鴬", "ipwo");
            dic.Add("泬", "ipwy");
            dic.Add("溛", "ipwy");
            dic.Add("沱", "ipx");
            dic.Add("光", "iq");
            dic.Add("涽", "iqaj");
            dic.Add("汦", "iqan");
            dic.Add("滐", "iqas");
            dic.Add("黋", "iqaw");
            dic.Add("泜", "iqay");
            dic.Add("汹", "iqbh");
            dic.Add("沟", "iqc");
            dic.Add("沒", "iqcy");
            dic.Add("淆", "iqd");
            dic.Add("洈", "iqdb");
            dic.Add("浠", "iqdh");
            dic.Add("頫", "iqdm");
            dic.Add("澹", "iqdy");
            dic.Add("澥", "iqeh");
            dic.Add("鼗", "iqf");
            dic.Add("淦", "iqg");
            dic.Add("渔", "iqgg");
            dic.Add("澛", "iqgj");
            dic.Add("覜", "iqhq");
            dic.Add("泺", "iqi");
            dic.Add("沵", "iqiy");
            dic.Add("洵", "iqj");
            dic.Add("潒", "iqje");
            dic.Add("尡", "iqjx");
            dic.Add("浼", "iqk");
            dic.Add("泃", "iqkg");
            dic.Add("洺", "iqkg");
            dic.Add("瀺", "iqky");
            dic.Add("涣", "iqm");
            dic.Add("渙", "iqmd");
            dic.Add("泡", "iqn");
            dic.Add("韑", "iqnh");
            dic.Add("耀", "iqny");
            dic.Add("瀂", "iqoj");
            dic.Add("淗", "iqoy");
            dic.Add("漁", "iqoy");
            dic.Add("逃", "iqp");
            dic.Add("辉", "iqpl");
            dic.Add("輝", "iqpl");
            dic.Add("濥", "iqpw");
            dic.Add("洶", "iqqb");
            dic.Add("淘", "iqr");
            dic.Add("淴", "iqrn");
            dic.Add("沕", "iqrt");
            dic.Add("泖", "iqt");
            dic.Add("潴", "iqtj");
            dic.Add("漪", "iqtk");
            dic.Add("汮", "iqug");
            dic.Add("兆", "iqv");
            dic.Add("淊", "iqvg");
            dic.Add("浄", "iqvh");
            dic.Add("盜", "iqwl");
            dic.Add("鴵", "iqwo");
            dic.Add("汐", "iqy");
            dic.Add("渹", "iqyg");
            dic.Add("瀏", "iqyj");
            dic.Add("溜", "iqyl");
            dic.Add("兤", "iqyw");
            dic.Add("汋", "iqyy");
            dic.Add("汣", "iqyy");
            dic.Add("泊", "ir");
            dic.Add("汳", "ircy");
            dic.Add("泒", "ircy");
            dic.Add("湃", "ird");
            dic.Add("滜", "irdf");
            dic.Add("派", "ire");
            dic.Add("垽", "irff");
            dic.Add("湟", "irgg");
            dic.Add("洉", "irgk");
            dic.Add("浜", "irgw");
            dic.Add("沂", "irh");
            dic.Add("汼", "irhh");
            dic.Add("沠", "irhy");
            dic.Add("洙", "iri");
            dic.Add("湶", "iriy");
            dic.Add("潕", "irlo");
            dic.Add("淿", "irmh");
            dic.Add("峾", "irmj");
            dic.Add("淛", "irmj");
            dic.Add("汽", "irn");
            dic.Add("滊", "irno");
            dic.Add("溾", "irqc");
            dic.Add("浙", "irr");
            dic.Add("渒", "irtf");
            dic.Add("澔", "irtk");
            dic.Add("溵", "irvc");
            dic.Add("湁", "irwk");
            dic.Add("泆", "irwy");
            dic.Add("潅", "irwy");
            dic.Add("漑", "irxq");
            dic.Add("激", "iry");
            dic.Add("泝", "iryy");
            dic.Add("洒", "is");
            dic.Add("涁", "iset");
            dic.Add("漂", "isf");
            dic.Add("溎", "isff");
            dic.Add("湮", "isfg");
            dic.Add("渿", "isfi");
            dic.Add("酒", "isgg");
            dic.Add("泍", "isgg");
            dic.Add("汀", "ish");
            dic.Add("湘", "ishg");
            dic.Add("潭", "isj");
            dic.Add("渣", "isjg");
            dic.Add("河", "isk");
            dic.Add("滒", "iskk");
            dic.Add("潥", "isoy");
            dic.Add("淅", "isr");
            dic.Add("灪", "isre");
            dic.Add("湐", "isrg");
            dic.Add("淋", "iss");
            dic.Add("溧", "iss");
            dic.Add("潸", "isse");
            dic.Add("漜", "issf");
            dic.Add("濋", "issh");
            dic.Add("澿", "issi");
            dic.Add("澘", "issj");
            dic.Add("潹", "isss");
            dic.Add("漤", "issv");
            dic.Add("滼", "issy");
            dic.Add("漆", "isw");
            dic.Add("淞", "iswc");
            dic.Add("瀒", "iswk");
            dic.Add("淶", "isww");
            dic.Add("沐", "isy");
            dic.Add("沭", "isyy");
            dic.Add("少", "it");
            dic.Add("洚", "ita");
            dic.Add("汑", "itan");
            dic.Add("澨", "itaw");
            dic.Add("沲", "itb");
            dic.Add("活", "itd");
            dic.Add("浲", "itdh");
            dic.Add("潪", "itdj");
            dic.Add("漨", "itdp");
            dic.Add("鋈", "itdq");
            dic.Add("沃", "itdy");
            dic.Add("瀊", "itel");
            dic.Add("洀", "itey");
            dic.Add("洗", "itf");
            dic.Add("汘", "itfh");
            dic.Add("汻", "itfh");
            dic.Add("洐", "itfh");
            dic.Add("濳", "itfj");
            dic.Add("浩", "itfk");
            dic.Add("灒", "itfm");
            dic.Add("涏", "itfp");
            dic.Add("鍌", "itfq");
            dic.Add("涶", "itgf");
            dic.Add("湩", "itgf");
            dic.Add("泩", "itgg");
            dic.Add("湰", "itgg");
            dic.Add("省", "ith");
            dic.Add("溴", "ithd");
            dic.Add("泎", "ithf");
            dic.Add("洎", "ithg");
            dic.Add("漇", "ithh");
            dic.Add("濞", "ithj");
            dic.Add("沜", "ithn");
            dic.Add("涎", "ithp");
            dic.Add("潲", "iti");
            dic.Add("浰", "itjh");
            dic.Add("漡", "itjr");
            dic.Add("洛", "itk");
            dic.Add("渪", "itky");
            dic.Add("劣", "itl");
            dic.Add("潈", "itle");
            dic.Add("洫", "itlg");
            dic.Add("潨", "itli");
            dic.Add("漗", "itln");
            dic.Add("澳", "itm");
            dic.Add("瀩", "itmm");
            dic.Add("澚", "itmn");
            dic.Add("瀓", "itmt");
            dic.Add("汔", "itn");
            dic.Add("泲", "itnt");
            dic.Add("渊", "ito");
            dic.Add("潘", "itol");
            dic.Add("湫", "itoy");
            dic.Add("泛", "itp");
            dic.Add("涐", "itrt");
            dic.Add("涤", "its");
            dic.Add("滗", "itt");
            dic.Add("潃", "itte");
            dic.Add("毟", "ittn");
            dic.Add("澓", "ittt");
            dic.Add("泘", "ituh");
            dic.Add("溗", "itux");
            dic.Add("泈", "ituy");
            dic.Add("瀄", "itvb");
            dic.Add("涹", "itvg");
            dic.Add("潷", "itvh");
            dic.Add("漎", "itwh");
            dic.Add("潻", "itwi");
            dic.Add("海", "itx");
            dic.Add("塰", "itxf");
            dic.Add("瀿", "itxi");
            dic.Add("湚", "itxn");
            dic.Add("汷", "ity");
            dic.Add("洋", "iu");
            dic.Add("洴", "iuah");
            dic.Add("渆", "iuaj");
            dic.Add("溯", "iub");
            dic.Add("滚", "iuc");
            dic.Add("溠", "iuda");
            dic.Add("淃", "iudb");
            dic.Add("溬", "iudc");
            dic.Add("瀁", "iude");
            dic.Add("漛", "iudi");
            dic.Add("潫", "iudi");
            dic.Add("渕", "iudj");
            dic.Add("浂", "iudy");
            dic.Add("湔", "iue");
            dic.Add("瀧", "iued");
            dic.Add("湇", "iueg");
            dic.Add("澻", "iuep");
            dic.Add("泮", "iuf");
            dic.Add("泣", "iug");
            dic.Add("漾", "iug");
            dic.Add("渼", "iugd");
            dic.Add("润", "iugg");
            dic.Add("潤", "iugg");
            dic.Add("澜", "iugi");
            dic.Add("瀾", "iugi");
            dic.Add("溔", "iugo");
            dic.Add("湵", "iugy");
            dic.Add("漳", "iuj");
            dic.Add("潼", "iujf");
            dic.Add("涧", "iujg");
            dic.Add("湆", "iujg");
            dic.Add("澗", "iujg");
            dic.Add("灨", "iujm");
            dic.Add("滝", "iujn");
            dic.Add("澺", "iujn");
            dic.Add("滰", "iujq");
            dic.Add("涪", "iuk");
            dic.Add("滾", "iuke");
            dic.Add("灛", "iukf");
            dic.Add("涚", "iukq");
            dic.Add("渷", "iukq");
            dic.Add("潧", "iulj");
            dic.Add("滴", "ium");
            dic.Add("滳", "iumk");
            dic.Add("潎", "iumt");
            dic.Add("湴", "iuog");
            dic.Add("潽", "iuoj");
            dic.Add("滂", "iup");
            dic.Add("渧", "iuph");
            dic.Add("澬", "iuqm");
            dic.Add("滧", "iuqt");
            dic.Add("洨", "iuqy");
            dic.Add("灁", "iuri");
            dic.Add("澊", "iusf");
            dic.Add("湭", "iusg");
            dic.Add("瀙", "iusq");
            dic.Add("澵", "iusr");
            dic.Add("澖", "iusy");
            dic.Add("濶", "iutd");
            dic.Add("滻", "iutg");
            dic.Add("渞", "iuth");
            dic.Add("濓", "iuto");
            dic.Add("浐", "iutt");
            dic.Add("灍", "iuuw");
            dic.Add("淁", "iuvg");
            dic.Add("溓", "iuvo");
            dic.Add("溢", "iuw");
            dic.Add("滋", "iux");
            dic.Add("濨", "iuxn");
            dic.Add("涕", "iuxt");
            dic.Add("潣", "iuyy");
            dic.Add("当", "iv");
            dic.Add("潯", "ivaf");
            dic.Add("湼", "ivag");
            dic.Add("溉", "ivc");
            dic.Add("泿", "ivey");
            dic.Add("堻", "ivff");
            dic.Add("澅", "ivfg");
            dic.Add("津", "ivfh");
            dic.Add("潚", "ivfj");
            dic.Add("湕", "ivfp");
            dic.Add("浔", "ivfy");
            dic.Add("汝", "ivg");
            dic.Add("澙", "ivgo");
            dic.Add("溲", "ivh");
            dic.Add("濜", "ivhl");
            dic.Add("渌", "ivi");
            dic.Add("漅", "ivjs");
            dic.Add("沼", "ivk");
            dic.Add("洳", "ivk");
            dic.Add("灉", "ivky");
            dic.Add("淄", "ivl");
            dic.Add("氿", "ivn");
            dic.Add("浸", "ivp");
            dic.Add("淣", "ivqn");
            dic.Add("潟", "ivqo");
            dic.Add("灚", "ivqq");
            dic.Add("染", "ivs");
            dic.Add("涒", "ivtk");
            dic.Add("梁", "ivw");
            dic.Add("粱", "ivwo");
            dic.Add("涩", "ivy");
            dic.Add("澀", "ivyh");
            dic.Add("涊", "ivyn");
            dic.Add("汍", "ivyy");
            dic.Add("兴", "iw");
            dic.Add("浌", "iwat");
            dic.Add("沧", "iwb");
            dic.Add("滃", "iwcn");
            dic.Add("洑", "iwdy");
            dic.Add("脊", "iwe");
            dic.Add("洕", "iweg");
            dic.Add("鹡", "iweg");
            dic.Add("鶺", "iweo");
            dic.Add("沴", "iwet");
            dic.Add("举", "iwf");
            dic.Add("浍", "iwfc");
            dic.Add("漈", "iwfi");
            dic.Add("涻", "iwfk");
            dic.Add("溌", "iwfq");
            dic.Add("泭", "iwfy");
            dic.Add("洽", "iwg");
            dic.Add("瀹", "iwga");
            dic.Add("淪", "iwga");
            dic.Add("渰", "iwga");
            dic.Add("湀", "iwgd");
            dic.Add("洤", "iwgg");
            dic.Add("渝", "iwgj");
            dic.Add("澮", "iwgj");
            dic.Add("潝", "iwgn");
            dic.Add("潋", "iwgt");
            dic.Add("瀲", "iwgt");
            dic.Add("澄", "iwgu");
            dic.Add("澰", "iwgw");
            dic.Add("滫", "iwhe");
            dic.Add("滺", "iwhn");
            dic.Add("滌", "iwhs");
            dic.Add("浟", "iwht");
            dic.Add("涗", "iwkq");
            dic.Add("湺", "iwks");
            dic.Add("溮", "iwnh");
            dic.Add("溩", "iwno");
            dic.Add("濮", "iwo");
            dic.Add("滏", "iwq");
            dic.Add("挙", "iwrj");
            dic.Add("涂", "iwt");
            dic.Add("溆", "iwtc");
            dic.Add("潊", "iwtc");
            dic.Add("塗", "iwtf");
            dic.Add("漵", "iwtt");
            dic.Add("氼", "iwu");
            dic.Add("涖", "iwug");
            dic.Add("汾", "iwv");
            dic.Add("湓", "iwvl");
            dic.Add("洢", "iwvt");
            dic.Add("浴", "iww");
            dic.Add("溣", "iwwa");
            dic.Add("瀸", "iwwg");
            dic.Add("沦", "iwx");
            dic.Add("潑", "iwxc");
            dic.Add("沎", "iwxn");
            dic.Add("淮", "iwy");
            dic.Add("雀", "iwy");
            dic.Add("汃", "iwy");
            dic.Add("汄", "iwy");
            dic.Add("泠", "iwyc");
            dic.Add("湌", "iwye");
            dic.Add("誉", "iwyf");
            dic.Add("準", "iwyf");
            dic.Add("蠽", "iwyj");
            dic.Add("浛", "iwyk");
            dic.Add("滄", "iwyk");
            dic.Add("汵", "iwyn");
            dic.Add("淰", "iwyn");
            dic.Add("潐", "iwyo");
            dic.Add("潗", "iwys");
            dic.Add("涨", "ix");
            dic.Add("渳", "ixbg");
            dic.Add("泓", "ixc");
            dic.Add("漲", "ixde");
            dic.Add("湪", "ixey");
            dic.Add("淥", "ixgi");
            dic.Add("瀰", "ixgq");
            dic.Add("沸", "ixj");
            dic.Add("漒", "ixkj");
            dic.Add("泑", "ixln");
            dic.Add("濼", "ixrs");
            dic.Add("溺", "ixu");
            dic.Add("潍", "ixw");
            dic.Add("濰", "ixwy");
            dic.Add("沘", "ixxn");
            dic.Add("湝", "ixxr");
            dic.Add("灤", "ixys");
            dic.Add("灣", "ixyx");
            dic.Add("注", "iy");
            dic.Add("渡", "iya");
            dic.Add("瀇", "iyaw");
            dic.Add("淳", "iyb");
            dic.Add("漷", "iybb");
            dic.Add("漓", "iybc");
            dic.Add("涥", "iybh");
            dic.Add("潡", "iybt");
            dic.Add("灕", "iyby");
            dic.Add("流", "iyc");
            dic.Add("鎏", "iyc");
            dic.Add("淯", "iyce");
            dic.Add("澈", "iyct");
            dic.Add("瑬", "iycy");
            dic.Add("乼", "iygn");
            dic.Add("汴", "iyh");
            dic.Add("涼", "iyiy");
            dic.Add("济", "iyj");
            dic.Add("浏", "iyj");
            dic.Add("済", "iyjf");
            dic.Add("瀍", "iyjf");
            dic.Add("濟", "iyjg");
            dic.Add("湻", "iyjg");
            dic.Add("滖", "iyke");
            dic.Add("瀼", "iyke");
            dic.Add("沩", "iyl");
            dic.Add("瀤", "iyle");
            dic.Add("澶", "iylg");
            dic.Add("澟", "iylt");
            dic.Add("沆", "iym");
            dic.Add("滈", "iymk");
            dic.Add("沪", "iyn");
            dic.Add("汸", "iyn");
            dic.Add("滬", "iync");
            dic.Add("灋", "iync");
            dic.Add("涙", "iynd");
            dic.Add("淚", "iynd");
            dic.Add("泳", "iyni");
            dic.Add("汒", "iynn");
            dic.Add("瀌", "iyno");
            dic.Add("淭", "iyns");
            dic.Add("漉", "iynx");
            dic.Add("瀛", "iyny");
            dic.Add("灜", "iyny");
            dic.Add("湾", "iyo");
            dic.Add("湙", "iyod");
            dic.Add("滦", "iyos");
            dic.Add("洂", "iyoy");
            dic.Add("濠", "iyp");
            dic.Add("湸", "iypm");
            dic.Add("渟", "iyps");
            dic.Add("灖", "iysd");
            dic.Add("洲", "iyt");
            dic.Add("漩", "iyt");
            dic.Add("游", "iytb");
            dic.Add("湤", "iytb");
            dic.Add("浒", "iytf");
            dic.Add("滸", "iytf");
            dic.Add("溈", "iyto");
            dic.Add("濂", "iyu");
            dic.Add("尐", "iyu");
            dic.Add("浪", "iyv");
            dic.Add("滽", "iyvh");
            dic.Add("漮", "iyvi");
            dic.Add("溏", "iyvk");
            dic.Add("液", "iyw");
            dic.Add("淬", "iywf");
            dic.Add("淤", "iywu");
            dic.Add("泫", "iyx");
            dic.Add("滀", "iyxl");
            dic.Add("澭", "iyxy");
            dic.Add("汶", "iyy");
            dic.Add("氵", "iyyg");
            dic.Add("是", "j");
            dic.Add("日", "j");
            dic.Add("虹", "ja");
            dic.Add("暱", "jaak");
            dic.Add("蠂", "jaas");
            dic.Add("昻", "jabj");
            dic.Add("蜞", "jad");
            dic.Add("蟒", "jada");
            dic.Add("蠎", "jada");
            dic.Add("蟖", "jadr");
            dic.Add("蚶", "jaf");
            dic.Add("畢", "jafk");
            dic.Add("鷝", "jafo");
            dic.Add("曄", "jagf");
            dic.Add("曅", "jagf");
            dic.Add("螨", "jagw");
            dic.Add("蚜", "jah");
            dic.Add("蜡", "jaj");
            dic.Add("蟆", "jajd");
            dic.Add("暯", "jajd");
            dic.Add("蝘", "jajv");
            dic.Add("蠇", "jajy");
            dic.Add("蜮", "jak");
            dic.Add("螼", "jakg");
            dic.Add("暵", "jakw");
            dic.Add("蠸", "jaky");
            dic.Add("蠛", "jal");
            dic.Add("昮", "jalb");
            dic.Add("蠴", "jalj");
            dic.Add("蟥", "jam");
            dic.Add("暎", "jamd");
            dic.Add("蝧", "jamd");
            dic.Add("曂", "jamw");
            dic.Add("蜹", "jamw");
            dic.Add("暪", "jamy");
            dic.Add("蟎", "jamy");
            dic.Add("蝶", "jan");
            dic.Add("昛", "jang");
            dic.Add("蚷", "jang");
            dic.Add("煚", "jano");
            dic.Add("蠓", "jap");
            dic.Add("曚", "jape");
            dic.Add("蝾", "japs");
            dic.Add("螮", "jaqh");
            dic.Add("曔", "jaqt");
            dic.Add("晓", "jat");
            dic.Add("蛲", "jat");
            dic.Add("蠮", "jatn");
            dic.Add("曣", "jauo");
            dic.Add("蠨", "javh");
            dic.Add("蟏", "javj");
            dic.Add("暴", "jaw");
            dic.Add("蠖", "jawc");
            dic.Add("晎", "jawy");
            dic.Add("謈", "jawy");
            dic.Add("最", "jb");
            dic.Add("虸", "jbg");
            dic.Add("蜬", "jbib");
            dic.Add("蟶", "jbkg");
            dic.Add("蜢", "jbl");
            dic.Add("朂", "jblb");
            dic.Add("曓", "jbmf");
            dic.Add("昢", "jbmh");
            dic.Add("虵", "jbn");
            dic.Add("紧", "jc");
            dic.Add("昪", "jcaj");
            dic.Add("蝚", "jcbs");
            dic.Add("蝃", "jccc");
            dic.Add("肾", "jce");
            dic.Add("蛹", "jceh");
            dic.Add("坚", "jcf");
            dic.Add("蛏", "jcfg");
            dic.Add("蚂", "jcg");
            dic.Add("贤", "jcm");
            dic.Add("蚆", "jcn");
            dic.Add("蛑", "jcr");
            dic.Add("竖", "jcu");
            dic.Add("晙", "jcwt");
            dic.Add("螞", "jcy");
            dic.Add("晨", "jd");
            dic.Add("曞", "jday");
            dic.Add("蠣", "jday");
            dic.Add("蚅", "jdbn");
            dic.Add("蛂", "jdcy");
            dic.Add("蛎", "jdd");
            dic.Add("蝴", "jde");
            dic.Add("蛕", "jdeg");
            dic.Add("蜄", "jdfe");
            dic.Add("蝰", "jdff");
            dic.Add("晇", "jdfn");
            dic.Add("鷐", "jdfo");
            dic.Add("蛄", "jdg");
            dic.Add("蟵", "jdgf");
            dic.Add("蝛", "jdgt");
            dic.Add("蚌", "jdh");
            dic.Add("暳", "jdhv");
            dic.Add("暃", "jdjd");
            dic.Add("蛨", "jdjg");
            dic.Add("昦", "jdjj");
            dic.Add("晻", "jdjn");
            dic.Add("蝒", "jdmd");
            dic.Add("蝡", "jdmd");
            dic.Add("暊", "jdmy");
            dic.Add("蝢", "jdmy");
            dic.Add("晟", "jdn");
            dic.Add("蛖", "jdne");
            dic.Add("蚘", "jdnn");
            dic.Add("晠", "jdnt");
            dic.Add("螈", "jdr");
            dic.Add("旲", "jdu");
            dic.Add("暸", "jdui");
            dic.Add("蟟", "jdui");
            dic.Add("蟩", "jduw");
            dic.Add("昃", "jdw");
            dic.Add("蜯", "jdwh");
            dic.Add("蝽", "jdwj");
            dic.Add("暙", "jdwj");
            dic.Add("螓", "jdwt");
            dic.Add("蛺", "jdww");
            dic.Add("昽", "jdxn");
            dic.Add("明", "je");
            dic.Add("蜉", "jeb");
            dic.Add("猒", "jedy");
            dic.Add("暖", "jef");
            dic.Add("冐", "jef");
            dic.Add("蝯", "jefc");
            dic.Add("蛶", "jefy");
            dic.Add("蚏", "jeg");
            dic.Add("蛆", "jegg");
            dic.Add("勗", "jegl");
            dic.Add("琞", "jegy");
            dic.Add("盟", "jel");
            dic.Add("焽", "jeou");
            dic.Add("暧", "jep");
            dic.Add("曌", "jepa");
            dic.Add("曖", "jept");
            dic.Add("暚", "jerm");
            dic.Add("蟡", "jeto");
            dic.Add("螇", "jexd");
            dic.Add("昅", "jeyy");
            dic.Add("时", "jf");
            dic.Add("蟦", "jfam");
            dic.Add("暁", "jfaq");
            dic.Add("蠘", "jfay");
            dic.Add("野", "jfc");
            dic.Add("墅", "jfcf");
            dic.Add("蜐", "jfcl");
            dic.Add("昙", "jfcu");
            dic.Add("蚑", "jfcy");
            dic.Add("里", "jfd");
            dic.Add("蠕", "jfdj");
            dic.Add("曘", "jfdj");
            dic.Add("黙", "jfdo");
            dic.Add("蛙", "jff");
            dic.Add("圼", "jff");
            dic.Add("曇", "jffc");
            dic.Add("晆", "jffg");
            dic.Add("曉", "jffq");
            dic.Add("蟯", "jffq");
            dic.Add("時", "jffy");
            dic.Add("旰", "jfh");
            dic.Add("旪", "jfh");
            dic.Add("虷", "jfh");
            dic.Add("昧", "jfi");
            dic.Add("蛷", "jfiy");
            dic.Add("旱", "jfj");
            dic.Add("蟛", "jfke");
            dic.Add("蛣", "jfkg");
            dic.Add("暿", "jfkk");
            dic.Add("蟢", "jfkk");
            dic.Add("蝻", "jfm");
            dic.Add("暔", "jfmf");
            dic.Add("黒", "jfou");
            dic.Add("曀", "jfpu");
            dic.Add("蚖", "jfqn");
            dic.Add("暑", "jft");
            dic.Add("暏", "jftj");
            dic.Add("蝫", "jftj");
            dic.Add("螧", "jftj");
            dic.Add("蛯", "jftx");
            dic.Add("蟽", "jfup");
            dic.Add("蚨", "jfw");
            dic.Add("曤", "jfwy");
            dic.Add("量", "jg");
            dic.Add("蚈", "jgah");
            dic.Add("旽", "jgbn");
            dic.Add("蛭", "jgc");
            dic.Add("晊", "jgcf");
            dic.Add("昊", "jgd");
            dic.Add("晴", "jge");
            dic.Add("蜻", "jge");
            dic.Add("晡", "jgey");
            dic.Add("蜅", "jgey");
            dic.Add("旦", "jgf");
            dic.Add("旴", "jgfh");
            dic.Add("虶", "jgfh");
            dic.Add("旺", "jgg");
            dic.Add("蚟", "jgg");
            dic.Add("昰", "jghf");
            dic.Add("韪", "jghh");
            dic.Add("韙", "jghh");
            dic.Add("题", "jghm");
            dic.Add("題", "jghm");
            dic.Add("鶗", "jgho");
            dic.Add("遈", "jghp");
            dic.Add("尟", "jght");
            dic.Add("晸", "jght");
            dic.Add("匙", "jghx");
            dic.Add("虾", "jghy");
            dic.Add("蚽", "jgig");
            dic.Add("暷", "jgjf");
            dic.Add("晅", "jgjg");
            dic.Add("蝀", "jgji");
            dic.Add("蟪", "jgjn");
            dic.Add("晤", "jgk");
            dic.Add("蝆", "jgkf");
            dic.Add("螎", "jgkh");
            dic.Add("曧", "jgkj");
            dic.Add("蝲", "jgkj");
            dic.Add("蝠", "jgkl");
            dic.Add("鼌", "jgkn");
            dic.Add("暕", "jgli");
            dic.Add("师", "jgm");
            dic.Add("昁", "jgmh");
            dic.Add("螬", "jgmj");
            dic.Add("鼂", "jgmv");
            dic.Add("昞", "jgmw");
            dic.Add("昺", "jgmw");
            dic.Add("蛃", "jgmw");
            dic.Add("曬", "jgmx");
            dic.Add("蜽", "jgmy");
            dic.Add("蛚", "jgqj");
            dic.Add("逿", "jgqp");
            dic.Add("昜", "jgqr");
            dic.Add("敭", "jgqt");
            dic.Add("昩", "jgsy");
            dic.Add("蛱", "jgu");
            dic.Add("蚲", "jguh");
            dic.Add("蛵", "jgva");
            dic.Add("蜨", "jgvh");
            dic.Add("鴠", "jgwo");
            dic.Add("螦", "jgxi");
            dic.Add("蝳", "jgxu");
            dic.Add("蛦", "jgxw");
            dic.Add("早", "jh");
            dic.Add("曥", "jhal");
            dic.Add("蠦", "jhal");
            dic.Add("蚾", "jhcy");
            dic.Add("冒", "jhf");
            dic.Add("朄", "jhgi");
            dic.Add("刂", "jhh");
            dic.Add("蠼", "jhhc");
            dic.Add("蠷", "jhhy");
            dic.Add("晫", "jhjh");
            dic.Add("暢", "jhjr");
            dic.Add("申", "jhk");
            dic.Add("曱", "jhk");
            dic.Add("甴", "jhk");
            dic.Add("蛅", "jhkg");
            dic.Add("勖", "jhl");
            dic.Add("曰", "jhng");
            dic.Add("畅", "jhnr");
            dic.Add("虫", "jhny");
            dic.Add("迧", "jhpk");
            dic.Add("晛", "jhqn");
            dic.Add("蜆", "jhqn");
            dic.Add("畃", "jhqy");
            dic.Add("毷", "jhtn");
            dic.Add("蟕", "jhxe");
            dic.Add("虲", "jhy");
            dic.Add("晃", "ji");
            dic.Add("蟝", "jias");
            dic.Add("蛸", "jie");
            dic.Add("蝋", "jimh");
            dic.Add("螳", "jip");
            dic.Add("蟐", "jiph");
            dic.Add("蟷", "jipl");
            dic.Add("曭", "jipo");
            dic.Add("晁", "jiq");
            dic.Add("晀", "jiqn");
            dic.Add("晄", "jiqn");
            dic.Add("昌", "jj");
            dic.Add("曝", "jja");
            dic.Add("晘", "jjfh");
            dic.Add("蛳", "jjg");
            dic.Add("昍", "jjg");
            dic.Add("蚎", "jjg");
            dic.Add("蜵", "jjgg");
            dic.Add("蝭", "jjgh");
            dic.Add("暘", "jjgr");
            dic.Add("蝪", "jjgr");
            dic.Add("蝐", "jjhg");
            dic.Add("晶", "jjj");
            dic.Add("曑", "jjje");
            dic.Add("曟", "jjje");
            dic.Add("晿", "jjjg");
            dic.Add("曐", "jjjg");
            dic.Add("曡", "jjjg");
            dic.Add("蠱", "jjjl");
            dic.Add("蝿", "jjjn");
            dic.Add("蟲", "jjju");
            dic.Add("蟃", "jjlc");
            dic.Add("蝹", "jjlg");
            dic.Add("焸", "jjou");
            dic.Add("暥", "jjpv");
            dic.Add("蝎", "jjq");
            dic.Add("暍", "jjqn");
            dic.Add("蜴", "jjqr");
            dic.Add("晹", "jjqr");
            dic.Add("蠍", "jjqw");
            dic.Add("蜾", "jjs");
            dic.Add("暒", "jjtg");
            dic.Add("蜫", "jjxx");
            dic.Add("暻", "jjyi");
            dic.Add("蝇", "jk");
            dic.Add("蜎", "jkeg");
            dic.Add("蜈", "jkg");
            dic.Add("冔", "jkgf");
            dic.Add("螻", "jkgv");
            dic.Add("蚛", "jkhh");
            dic.Add("暺", "jkkf");
            dic.Add("蟬", "jkkf");
            dic.Add("曮", "jkkt");
            dic.Add("蜗", "jkm");
            dic.Add("曙", "jl");
            dic.Add("蟈", "jlag");
            dic.Add("曼", "jlc");
            dic.Add("鄤", "jlcb");
            dic.Add("蝟", "jleg");
            dic.Add("蛊", "jlf");
            dic.Add("昷", "jlf");
            dic.Add("曎", "jlff");
            dic.Add("蠌", "jlff");
            dic.Add("蟔", "jlfo");
            dic.Add("蝈", "jlg");
            dic.Add("蠉", "jlge");
            dic.Add("蛼", "jlh");
            dic.Add("蛔", "jlk");
            dic.Add("蛠", "jlll");
            dic.Add("蠝", "jlll");
            dic.Add("蠋", "jlqj");
            dic.Add("螹", "jlrh");
            dic.Add("蜠", "jlty");
            dic.Add("螺", "jlx");
            dic.Add("曪", "jlxy");
            dic.Add("遇", "jm");
            dic.Add("蛐", "jma");
            dic.Add("晪", "jmaw");
            dic.Add("映", "jmd");
            dic.Add("螖", "jmeg");
            dic.Add("蚺", "jmf");
            dic.Add("蚦", "jmfg");
            dic.Add("蜩", "jmfk");
            dic.Add("晭", "jmfk");
            dic.Add("蚰", "jmg");
            dic.Add("晍", "jmgk");
            dic.Add("暟", "jmgu");
            dic.Add("螘", "jmgu");
            dic.Add("蠅", "jmgv");
            dic.Add("帅", "jmh");
            dic.Add("顒", "jmhm");
            dic.Add("颙", "jmhm");
            dic.Add("愚", "jmhn");
            dic.Add("禺", "jmhy");
            dic.Add("旵", "jmj");
            dic.Add("蜖", "jmjd");
            dic.Add("蠳", "jmmv");
            dic.Add("虮", "jmn");
            dic.Add("蝸", "jmnk");
            dic.Add("蚬", "jmq");
            dic.Add("蛧", "jmqq");
            dic.Add("蝄", "jmun");
            dic.Add("蚋", "jmw");
            dic.Add("蠵", "jmwk");
            dic.Add("蛽", "jmy");
            dic.Add("蚒", "jmyg");
            dic.Add("电", "jn");
            dic.Add("蜛", "jndg");
            dic.Add("蛡", "jng");
            dic.Add("暅", "jngg");
            dic.Add("暇", "jnh");
            dic.Add("蝦", "jnhc");
            dic.Add("蝑", "jnhe");
            dic.Add("蝞", "jnhg");
            dic.Add("暐", "jnhh");
            dic.Add("虯", "jnhh");
            dic.Add("曯", "jnij");
            dic.Add("蠾", "jnij");
            dic.Add("虬", "jnn");
            dic.Add("蟤", "jnnw");
            dic.Add("遢", "jnp");
            dic.Add("旸", "jnrt");
            dic.Add("毾", "jntn");
            dic.Add("曜", "jnw");
            dic.Add("蟉", "jnwe");
            dic.Add("蚗", "jnwy");
            dic.Add("蠗", "jnwy");
            dic.Add("昵", "jnx");
            dic.Add("蚭", "jnxn");
            dic.Add("蚇", "jnyy");
            dic.Add("显", "jo");
            dic.Add("顕", "jogm");
            dic.Add("曗", "jogw");
            dic.Add("蟧", "jool");
            dic.Add("蠑", "joos");
            dic.Add("晱", "jooy");
            dic.Add("暽", "joqh");
            dic.Add("炅", "jou");
            dic.Add("蝼", "jov");
            dic.Add("炚", "joy");
            dic.Add("晕", "jp");
            dic.Add("曢", "jpdi");
            dic.Add("螛", "jpdk");
            dic.Add("晥", "jpfq");
            dic.Add("暄", "jpg");
            dic.Add("蝖", "jpgg");
            dic.Add("蝊", "jpgh");
            dic.Add("蠙", "jpgm");
            dic.Add("螾", "jpgw");
            dic.Add("螟", "jpj");
            dic.Add("暝", "jpj");
            dic.Add("晖", "jplh");
            dic.Add("暉", "jplh");
            dic.Add("暈", "jplj");
            dic.Add("蜿", "jpq");
            dic.Add("晼", "jpqb");
            dic.Add("晏", "jpv");
            dic.Add("鷃", "jpvo");
            dic.Add("螲", "jpwf");
            dic.Add("蛇", "jpx");
            dic.Add("晚", "jq");
            dic.Add("曻", "jqah");
            dic.Add("蚔", "jqan");
            dic.Add("蚳", "jqay");
            dic.Add("昂", "jqb");
            dic.Add("蝬", "jqbt");
            dic.Add("蟾", "jqd");
            dic.Add("蛫", "jqdb");
            dic.Add("晞", "jqdh");
            dic.Add("曕", "jqdy");
            dic.Add("蠏", "jqeh");
            dic.Add("蟓", "jqj");
            dic.Add("晩", "jqjq");
            dic.Add("冕", "jqk");
            dic.Add("昫", "jqkg");
            dic.Add("蚼", "jqkg");
            dic.Add("煦", "jqko");
            dic.Add("蜔", "jqlg");
            dic.Add("蝜", "jqmy");
            dic.Add("蚫", "jqnn");
            dic.Add("蛥", "jqqy");
            dic.Add("易", "jqr");
            dic.Add("敡", "jqrc");
            dic.Add("剔", "jqrj");
            dic.Add("蜪", "jqrm");
            dic.Add("惖", "jqrn");
            dic.Add("鶍", "jqro");
            dic.Add("逷", "jqrp");
            dic.Add("昒", "jqrt");
            dic.Add("昴", "jqt");
            dic.Add("昀", "jqu");
            dic.Add("蚐", "jqug");
            dic.Add("蜭", "jqvg");
            dic.Add("歇", "jqw");
            dic.Add("鹖", "jqwg");
            dic.Add("曷", "jqwn");
            dic.Add("毼", "jqwn");
            dic.Add("鶡", "jqwo");
            dic.Add("遏", "jqwp");
            dic.Add("欥", "jqwy");
            dic.Add("旳", "jqyy");
            dic.Add("虳", "jqyy");
            dic.Add("蝗", "jr");
            dic.Add("昄", "jrcy");
            dic.Add("蛌", "jrcy");
            dic.Add("暤", "jrdf");
            dic.Add("蚯", "jrgg");
            dic.Add("昕", "jrh");
            dic.Add("蚚", "jrh");
            dic.Add("螔", "jrhm");
            dic.Add("蛛", "jri");
            dic.Add("暭", "jrif");
            dic.Add("蟱", "jrlo");
            dic.Add("暣", "jrno");
            dic.Add("螝", "jrqc");
            dic.Add("晣", "jrrh");
            dic.Add("蜱", "jrt");
            dic.Add("昳", "jrwy");
            dic.Add("蛈", "jrwy");
            dic.Add("曒", "jryt");
            dic.Add("蚸", "jryy");
            dic.Add("果", "js");
            dic.Add("颗", "jsd");
            dic.Add("顆", "jsdm");
            dic.Add("褁", "jseu");
            dic.Add("螵", "jsf");
            dic.Add("晒", "jsg");
            dic.Add("虰", "jsh");
            dic.Add("敤", "jshc");
            dic.Add("曋", "jsjh");
            dic.Add("蟫", "jsjh");
            dic.Add("蚵", "jsk");
            dic.Add("夥", "jsq");
            dic.Add("晰", "jsr");
            dic.Add("蜥", "jsr");
            dic.Add("晽", "jssy");
            dic.Add("杲", "jsu");
            dic.Add("蜙", "jswc");
            dic.Add("蚞", "jsy");
            dic.Add("昨", "jt");
            dic.Add("昇", "jtaj");
            dic.Add("虴", "jtan");
            dic.Add("蜂", "jtd");
            dic.Add("蛞", "jtdg");
            dic.Add("蜘", "jtdk");
            dic.Add("蟜", "jtdk");
            dic.Add("蜏", "jten");
            dic.Add("蚝", "jtf");
            dic.Add("旿", "jtfh");
            dic.Add("晧", "jtfk");
            dic.Add("蜓", "jtfp");
            dic.Add("星", "jtg");
            dic.Add("戥", "jtga");
            dic.Add("蝩", "jtgf");
            dic.Add("甠", "jtgg");
            dic.Add("﨡", "jtgg");
            dic.Add("曛", "jtgo");
            dic.Add("蚱", "jth");
            dic.Add("蝂", "jthc");
            dic.Add("螑", "jthd");
            dic.Add("曍", "jthf");
            dic.Add("晷", "jthk");
            dic.Add("螅", "jthn");
            dic.Add("蜒", "jthp");
            dic.Add("暞", "jths");
            dic.Add("蜊", "jtj");
            dic.Add("蟍", "jtjs");
            dic.Add("蝮", "jtjt");
            dic.Add("蛒", "jtkg");
            dic.Add("蝺", "jtky");
            dic.Add("蟌", "jtln");
            dic.Add("螕", "jtlx");
            dic.Add("晌", "jtm");
            dic.Add("晑", "jtmk");
            dic.Add("虼", "jtn");
            dic.Add("蜁", "jtnh");
            dic.Add("蟋", "jto");
            dic.Add("蟠", "jtol");
            dic.Add("蛾", "jtr");
            dic.Add("蝌", "jtu");
            dic.Add("昸", "jtuy");
            dic.Add("蜲", "jtvg");
            dic.Add("暰", "jtwh");
            dic.Add("晦", "jtx");
            dic.Add("临", "jty");
            dic.Add("览", "jty");
            dic.Add("暀", "jtyg");
            dic.Add("监", "jtyl");
            dic.Add("鉴", "jtyq");
            dic.Add("暗", "ju");
            dic.Add("蛢", "juah");
            dic.Add("蟙", "juaj");
            dic.Add("蛘", "jud");
            dic.Add("暛", "juda");
            dic.Add("蜷", "judb");
            dic.Add("蟮", "judk");
            dic.Add("蜣", "judn");
            dic.Add("曨", "jued");
            dic.Add("蠬", "jued");
            dic.Add("昱", "juf");
            dic.Add("蚪", "jufh");
            dic.Add("曦", "jug");
            dic.Add("蟻", "jugt");
            dic.Add("蝉", "jujf");
            dic.Add("曈", "jujf");
            dic.Add("蟑", "jujh");
            dic.Add("暲", "jujh");
            dic.Add("蜕", "juk");
            dic.Add("螪", "jumk");
            dic.Add("螃", "jup");
            dic.Add("蛟", "juq");
            dic.Add("蠀", "juqm");
            dic.Add("晈", "juqy");
            dic.Add("蝤", "jus");
            dic.Add("螏", "jutd");
            dic.Add("昗", "juu");
            dic.Add("螊", "juvo");
            dic.Add("螠", "juwl");
            dic.Add("晜", "juxt");
            dic.Add("螆", "juxx");
            dic.Add("归", "jv");
            dic.Add("蟳", "jvaf");
            dic.Add("旯", "jvb");
            dic.Add("蝍", "jvcb");
            dic.Add("螁", "jvep");
            dic.Add("蛝", "jvey");
            dic.Add("妟", "jvf");
            dic.Add("蟰", "jvfj");
            dic.Add("螋", "jvh");
            dic.Add("曃", "jvip");
            dic.Add("昭", "jvk");
            dic.Add("蛁", "jvkg");
            dic.Add("照", "jvko");
            dic.Add("蠟", "jvln");
            dic.Add("旫", "jvn");
            dic.Add("虭", "jvn");
            dic.Add("晲", "jvqn");
            dic.Add("蜺", "jvqn");
            dic.Add("蛤", "jw");
            dic.Add("蟘", "jwam");
            dic.Add("蚮", "jway");
            dic.Add("蚣", "jwc");
            dic.Add("暡", "jwcn");
            dic.Add("螉", "jwcn");
            dic.Add("昖", "jwcy");
            dic.Add("昣", "jwet");
            dic.Add("暩", "jwfi");
            dic.Add("蚹", "jwfy");
            dic.Add("蜦", "jwga");
            dic.Add("暌", "jwgd");
            dic.Add("蝓", "jwgj");
            dic.Add("螩", "jwhs");
            dic.Add("蚧", "jwj");
            dic.Add("蛻", "jwkq");
            dic.Add("螄", "jwnh");
            dic.Add("螐", "jwno");
            dic.Add("蚥", "jwqy");
            dic.Add("蜍", "jwt");
            dic.Add("昐", "jwvn");
            dic.Add("蚡", "jwvn");
            dic.Add("蟂", "jwvs");
            dic.Add("蛜", "jwvt");
            dic.Add("晔", "jwx");
            dic.Add("暹", "jwy");
            dic.Add("蛉", "jwyc");
            dic.Add("昤", "jwyc");
            dic.Add("蠄", "jwyc");
            dic.Add("蜼", "jwyg");
            dic.Add("晗", "jwyk");
            dic.Add("蛿", "jwyk");
            dic.Add("螥", "jwyk");
            dic.Add("昑", "jwyn");
            dic.Add("蚙", "jwyn");
            dic.Add("蟭", "jwyo");
            dic.Add("昆", "jx");
            dic.Add("曳", "jxe");
            dic.Add("蝝", "jxey");
            dic.Add("蚓", "jxh");
            dic.Add("昲", "jxjh");
            dic.Add("曊", "jxjm");
            dic.Add("蚴", "jxl");
            dic.Add("曏", "jxtb");
            dic.Add("蜌", "jxxf");
            dic.Add("鹍", "jxxg");
            dic.Add("顯", "jxxm");
            dic.Add("蚍", "jxxn");
            dic.Add("鵾", "jxxo");
            dic.Add("蝔", "jxxr");
            dic.Add("蟣", "jxxt");
            dic.Add("歞", "jxxw");
            dic.Add("曵", "jxyi");
            dic.Add("景", "jy");
            dic.Add("蟅", "jyao");
            dic.Add("曠", "jyaw");
            dic.Add("暾", "jyb");
            dic.Add("昘", "jyb");
            dic.Add("螭", "jybc");
            dic.Add("蜳", "jybg");
            dic.Add("蜟", "jyce");
            dic.Add("昿", "jycy");
            dic.Add("蠩", "jyfj");
            dic.Add("蛀", "jyg");
            dic.Add("影", "jyie");
            dic.Add("颢", "jyim");
            dic.Add("顥", "jyim");
            dic.Add("晾", "jyiy");
            dic.Add("蛴", "jyj");
            dic.Add("蠐", "jyjg");
            dic.Add("曩", "jyk");
            dic.Add("蠰", "jyke");
            dic.Add("蟺", "jylg");
            dic.Add("暠", "jymk");
            dic.Add("蚢", "jymn");
            dic.Add("虻", "jyn");
            dic.Add("昉", "jyn");
            dic.Add("蚄", "jyn");
            dic.Add("蝙", "jyna");
            dic.Add("蜧", "jynd");
            dic.Add("昹", "jyni");
            dic.Add("昈", "jynt");
            dic.Add("晐", "jynw");
            dic.Add("螰", "jynx");
            dic.Add("蠔", "jype");
            dic.Add("蝏", "jyps");
            dic.Add("蚁", "jyq");
            dic.Add("旷", "jyt");
            dic.Add("蝣", "jytb");
            dic.Add("暆", "jytb");
            dic.Add("暶", "jyth");
            dic.Add("蠊", "jyu");
            dic.Add("旻", "jyu");
            dic.Add("蝷", "jyut");
            dic.Add("螂", "jyv");
            dic.Add("蜋", "jyve");
            dic.Add("螗", "jyvk");
            dic.Add("晬", "jywf");
            dic.Add("蜶", "jywf");
            dic.Add("蟀", "jyx");
            dic.Add("昡", "jyxy");
            dic.Add("蚿", "jyxy");
            dic.Add("蚊", "jyy");
            dic.Add("旼", "jyy");
            dic.Add("中", "k");
            dic.Add("口", "k");
            dic.Add("呀", "ka");
            dic.Add("嘶", "kad");
            dic.Add("喏", "kadk");
            dic.Add("啿", "kadn");
            dic.Add("唭", "kadw");
            dic.Add("嘞", "kaf");
            dic.Add("囈", "kafc");
            dic.Add("嚡", "kaff");
            dic.Add("咁", "kafg");
            dic.Add("哐", "kag");
            dic.Add("叿", "kag");
            dic.Add("嘩", "kagf");
            dic.Add("嚂", "kahl");
            dic.Add("囕", "kahq");
            dic.Add("噶", "kaj");
            dic.Add("嗼", "kajd");
            dic.Add("唶", "kajg");
            dic.Add("囆", "kajj");
            dic.Add("噧", "kajy");
            dic.Add("嘔", "kakk");
            dic.Add("嘆", "kakw");
            dic.Add("嚾", "kaky");
            dic.Add("喵", "kal");
            dic.Add("咂", "kam");
            dic.Add("唝", "kamy");
            dic.Add("嗊", "kamy");
            dic.Add("呓", "kan");
            dic.Add("呭", "kann");
            dic.Add("喋", "kans");
            dic.Add("唠", "kap");
            dic.Add("哎", "kaq");
            dic.Add("噆", "kaqj");
            dic.Add("囌", "kaqt");
            dic.Add("呕", "kaqy");
            dic.Add("哓", "kat");
            dic.Add("囒", "kaui");
            dic.Add("嚥", "kauo");
            dic.Add("哄", "kaw");
            dic.Add("嗬", "kaw");
            dic.Add("嚄", "kawc");
            dic.Add("嗒", "kawk");
            dic.Add("嗏", "kaws");
            dic.Add("嚿", "kawv");
            dic.Add("嚆", "kay");
            dic.Add("啊", "kb");
            dic.Add("囁", "kbbb");
            dic.Add("嗫", "kbc");
            dic.Add("唨", "kbeg");
            dic.Add("咠", "kbf");
            dic.Add("吇", "kbg");
            dic.Add("咡", "kbg");
            dic.Add("叩", "kbh");
            dic.Add("嗤", "kbhj");
            dic.Add("咄", "kbm");
            dic.Add("吼", "kbn");
            dic.Add("吔", "kbn");
            dic.Add("戢", "kbnt");
            dic.Add("吧", "kc");
            dic.Add("邑", "kcb");
            dic.Add("噊", "kcbk");
            dic.Add("嗓", "kcc");
            dic.Add("啜", "kccc");
            dic.Add("嘇", "kcce");
            dic.Add("嗵", "kce");
            dic.Add("吗", "kcg");
            dic.Add("咍", "kckg");
            dic.Add("吮", "kcq");
            dic.Add("哞", "kcr");
            dic.Add("唉", "kct");
            dic.Add("唆", "kcw");
            dic.Add("叹", "kcy");
            dic.Add("嗎", "kcy");
            dic.Add("顺", "kd");
            dic.Add("咗", "kdag");
            dic.Add("呃", "kdb");
            dic.Add("吰", "kdcy");
            dic.Add("嘠", "kdea");
            dic.Add("喐", "kdeb");
            dic.Add("哊", "kdeg");
            dic.Add("嚘", "kdet");
            dic.Add("喹", "kdf");
            dic.Add("喯", "kdfa");
            dic.Add("啀", "kdff");
            dic.Add("嗕", "kdff");
            dic.Add("咵", "kdfn");
            dic.Add("咕", "kdg");
            dic.Add("喊", "kdgt");
            dic.Add("喴", "kdgt");
            dic.Add("嘎", "kdh");
            dic.Add("嘁", "kdh");
            dic.Add("囓", "kdhb");
            dic.Add("喫", "kdhd");
            dic.Add("噄", "kdhi");
            dic.Add("嚖", "kdhn");
            dic.Add("嗄", "kdht");
            dic.Add("嘒", "kdhv");
            dic.Add("啡", "kdj");
            dic.Add("嚈", "kdjd");
            dic.Add("喱", "kdjf");
            dic.Add("咟", "kdjg");
            dic.Add("唵", "kdjn");
            dic.Add("呖", "kdl");
            dic.Add("喕", "kdmd");
            dic.Add("咘", "kdmh");
            dic.Add("順", "kdmy");
            dic.Add("哤", "kdne");
            dic.Add("咴", "kdo");
            dic.Add("哒", "kdp");
            dic.Add("嚦", "kdth");
            dic.Add("噘", "kdu");
            dic.Add("嘹", "kdui");
            dic.Add("唪", "kdw");
            dic.Add("嗪", "kdwt");
            dic.Add("唊", "kdww");
            dic.Add("咙", "kdx");
            dic.Add("吠", "kdy");
            dic.Add("呔", "kdyy");
            dic.Add("吸", "ke");
            dic.Add("哹", "kebg");
            dic.Add("啂", "kebn");
            dic.Add("肙", "kef");
            dic.Add("喛", "kefc");
            dic.Add("哷", "kefy");
            dic.Add("咀", "keg");
            dic.Add("瓹", "kegn");
            dic.Add("剈", "kejh");
            dic.Add("嚼", "kel");
            dic.Add("嗳", "kep");
            dic.Add("噯", "kept");
            dic.Add("鹃", "keq");
            dic.Add("嗂", "kerm");
            dic.Add("啋", "kesy");
            dic.Add("噅", "keto");
            dic.Add("哸", "kevg");
            dic.Add("鵑", "kewo");
            dic.Add("嗘", "kexd");
            dic.Add("啄", "keyy");
            dic.Add("叶", "kf");
            dic.Add("喷", "kfa");
            dic.Add("噴", "kfam");
            dic.Add("哋", "kfbn");
            dic.Add("吱", "kfc");
            dic.Add("嗑", "kfcl");
            dic.Add("呍", "kfcy");
            dic.Add("呿", "kfcy");
            dic.Add("嚅", "kfd");
            dic.Add("哇", "kff");
            dic.Add("啩", "kffh");
            dic.Add("嘵", "kffq");
            dic.Add("吐", "kfg");
            dic.Add("嗔", "kfhw");
            dic.Add("唗", "kfhy");
            dic.Add("味", "kfi");
            dic.Add("呩", "kfiy");
            dic.Add("嘲", "kfj");
            dic.Add("嘻", "kfk");
            dic.Add("嘭", "kfke");
            dic.Add("咭", "kfkg");
            dic.Add("鄙", "kfl");
            dic.Add("啚", "kflk");
            dic.Add("喃", "kfm");
            dic.Add("嚋", "kfnf");
            dic.Add("哧", "kfo");
            dic.Add("嚇", "kfoo");
            dic.Add("噎", "kfp");
            dic.Add("哱", "kfpb");
            dic.Add("嚏", "kfph");
            dic.Add("嚔", "kfph");
            dic.Add("嗦", "kfpi");
            dic.Add("呒", "kfq");
            dic.Add("哮", "kft");
            dic.Add("嘟", "kftb");
            dic.Add("嗜", "kftj");
            dic.Add("啫", "kftj");
            dic.Add("嘋", "kftt");
            dic.Add("咾", "kftx");
            dic.Add("啈", "kfuf");
            dic.Add("噠", "kfup");
            dic.Add("呋", "kfw");
            dic.Add("嚯", "kfwy");
            dic.Add("吋", "kfy");
            dic.Add("呈", "kg");
            dic.Add("咞", "kgah");
            dic.Add("哢", "kgah");
            dic.Add("吨", "kgb");
            dic.Add("郢", "kgbh");
            dic.Add("噸", "kgbm");
            dic.Add("咥", "kgcf");
            dic.Add("吴", "kgd");
            dic.Add("哺", "kge");
            dic.Add("啨", "kgeg");
            dic.Add("啞", "kgfg");
            dic.Add("吁", "kgfh");
            dic.Add("噁", "kgfn");
            dic.Add("噖", "kggn");
            dic.Add("吓", "kgh");
            dic.Add("嘕", "kgho");
            dic.Add("呸", "kgi");
            dic.Add("吥", "kgiy");
            dic.Add("哽", "kgj");
            dic.Add("哶", "kgjf");
            dic.Add("咺", "kgjg");
            dic.Add("喇", "kgk");
            dic.Add("囔", "kgke");
            dic.Add("唔", "kgkg");
            dic.Add("唖", "kgkg");
            dic.Add("嗝", "kgkh");
            dic.Add("氀", "kgkn");
            dic.Add("甊", "kgkn");
            dic.Add("鷜", "kgko");
            dic.Add("遱", "kgkp");
            dic.Add("數", "kgkt");
            dic.Add("哣", "kgku");
            dic.Add("婁", "kgkv");
            dic.Add("嗽", "kgkw");
            dic.Add("啧", "kgm");
            dic.Add("嘈", "kgmj");
            dic.Add("唡", "kgmw");
            dic.Add("囇", "kgmx");
            dic.Add("啢", "kgmy");
            dic.Add("嘖", "kgmy");
            dic.Add("号", "kgn");
            dic.Add("饕", "kgne");
            dic.Add("飸", "kgne");
            dic.Add("鸮", "kgng");
            dic.Add("號", "kgnm");
            dic.Add("咓", "kgnn");
            dic.Add("鴞", "kgno");
            dic.Add("哑", "kgo");
            dic.Add("逞", "kgp");
            dic.Add("咧", "kgq");
            dic.Add("嚽", "kgqm");
            dic.Add("嗷", "kgqt");
            dic.Add("唛", "kgt");
            dic.Add("呯", "kguh");
            dic.Add("啑", "kgvh");
            dic.Add("啛", "kgvv");
            dic.Add("咦", "kgx");
            dic.Add("嗉", "kgxi");
            dic.Add("距", "kha");
            dic.Add("嚱", "khaa");
            dic.Add("踐", "khaa");
            dic.Add("噳", "khad");
            dic.Add("囐", "khad");
            dic.Add("噱", "khae");
            dic.Add("嘘", "khag");
            dic.Add("噓", "khag");
            dic.Add("嘑", "khah");
            dic.Add("蹛", "khah");
            dic.Add("躇", "khaj");
            dic.Add("踖", "khaj");
            dic.Add("躤", "khaj");
            dic.Add("蹃", "khak");
            dic.Add("嚧", "khal");
            dic.Add("唬", "kham");
            dic.Add("跇", "khan");
            dic.Add("踸", "khan");
            dic.Add("跷", "khaq");
            dic.Add("蹀", "khas");
            dic.Add("蹒", "khaw");
            dic.Add("踑", "khaw");
            dic.Add("躏", "khay");
            dic.Add("蹣", "khay");
            dic.Add("躪", "khay");
            dic.Add("蹑", "khb");
            dic.Add("躡", "khbb");
            dic.Add("踙", "khbc");
            dic.Add("嚙", "khbh");
            dic.Add("踂", "khbn");
            dic.Add("踊", "khc");
            dic.Add("跆", "khck");
            dic.Add("蹫", "khck");
            dic.Add("踴", "khcl");
            dic.Add("跁", "khcn");
            dic.Add("蹂", "khcs");
            dic.Add("踆", "khct");
            dic.Add("跨", "khd");
            dic.Add("蹰", "khd");
            dic.Add("跋", "khdc");
            dic.Add("踌", "khdf");
            dic.Add("跖", "khdg");
            dic.Add("跍", "khdg");
            dic.Add("蹽", "khdi");
            dic.Add("踳", "khdj");
            dic.Add("踦", "khdk");
            dic.Add("跶", "khdp");
            dic.Add("噦", "khdt");
            dic.Add("蹖", "khdv");
            dic.Add("蹶", "khdw");
            dic.Add("啃", "khe");
            dic.Add("蹊", "khed");
            dic.Add("跀", "kheg");
            dic.Add("跙", "kheg");
            dic.Add("踩", "khes");
            dic.Add("跥", "khes");
            dic.Add("蹈", "khev");
            dic.Add("趿", "khey");
            dic.Add("趺", "khf");
            dic.Add("", "khf");
            dic.Add("踋", "khfb");
            dic.Add("踍", "khfb");
            dic.Add("跂", "khfc");
            dic.Add("跬", "khff");
            dic.Add("跱", "khff");
            dic.Add("踛", "khff");
            dic.Add("躊", "khff");
            dic.Add("跿", "khfh");
            dic.Add("跊", "khfi");
            dic.Add("踷", "khfj");
            dic.Add("躂", "khfp");
            dic.Add("蹺", "khfq");
            dic.Add("踜", "khft");
            dic.Add("蹎", "khfw");
            dic.Add("践", "khg");
            dic.Add("遣", "khg");
            dic.Add("趼", "khga");
            dic.Add("踁", "khga");
            dic.Add("趶", "khgf");
            dic.Add("跮", "khgf");
            dic.Add("踕", "khgh");
            dic.Add("踈", "khgi");
            dic.Add("蹧", "khgj");
            dic.Add("踎", "khgk");
            dic.Add("踾", "khgl");
            dic.Add("贵", "khgm");
            dic.Add("貴", "khgm");
            dic.Add("蹟", "khgm");
            dic.Add("遗", "khgp");
            dic.Add("遺", "khgp");
            dic.Add("躎", "khgq");
            dic.Add("跠", "khgw");
            dic.Add("躧", "khgx");
            dic.Add("趾", "khh");
            dic.Add("跛", "khhc");
            dic.Add("踧", "khhc");
            dic.Add("躩", "khhc");
            dic.Add("躆", "khhe");
            dic.Add("踄", "khhi");
            dic.Add("踔", "khhj");
            dic.Add("跕", "khhk");
            dic.Add("跐", "khhx");
            dic.Add("咔", "khhy");
            dic.Add("躣", "khhy");
            dic.Add("跳", "khi");
            dic.Add("踃", "khie");
            dic.Add("蹐", "khie");
            dic.Add("蹚", "khif");
            dic.Add("踏", "khij");
            dic.Add("嚬", "khim");
            dic.Add("踢", "khj");
            dic.Add("蹕", "khjf");
            dic.Add("啅", "khjh");
            dic.Add("踶", "khjh");
            dic.Add("蹋", "khjn");
            dic.Add("踼", "khjr");
            dic.Add("踝", "khjs");
            dic.Add("跩", "khjx");
            dic.Add("呫", "khkg");
            dic.Add("踀", "khkh");
            dic.Add("蹪", "khkm");
            dic.Add("躁", "khks");
            dic.Add("盅", "khl");
            dic.Add("躅", "khlj");
            dic.Add("跏", "khlk");
            dic.Add("蹥", "khlp");
            dic.Add("跺", "khm");
            dic.Add("蹦", "khme");
            dic.Add("跚", "khmg");
            dic.Add("踹", "khmj");
            dic.Add("踻", "khmk");
            dic.Add("忠", "khn");
            dic.Add("踞", "khnd");
            dic.Add("蹍", "khne");
            dic.Add("蹘", "khne");
            dic.Add("蹡", "khnf");
            dic.Add("跼", "khnk");
            dic.Add("跽", "khnn");
            dic.Add("躃", "khnu");
            dic.Add("趹", "khnw");
            dic.Add("跜", "khnx");
            dic.Add("躍", "khny");
            dic.Add("蹼", "kho");
            dic.Add("噛", "khob");
            dic.Add("躞", "khoc");
            dic.Add("蹸", "khoh");
            dic.Add("踪", "khp");
            dic.Add("踠", "khpb");
            dic.Add("蹿", "khph");
            dic.Add("蹜", "khpj");
            dic.Add("迚", "khpk");
            dic.Add("躥", "khpn");
            dic.Add("跎", "khpx");
            dic.Add("跑", "khq");
            dic.Add("跪", "khqb");
            dic.Add("踭", "khqh");
            dic.Add("跞", "khqi");
            dic.Add("跔", "khqk");
            dic.Add("蹓", "khql");
            dic.Add("哯", "khqn");
            dic.Add("踘", "khqo");
            dic.Add("蹨", "khqo");
            dic.Add("跢", "khqq");
            dic.Add("趵", "khqy");
            dic.Add("跌", "khr");
            dic.Add("踲", "khrh");
            dic.Add("躌", "khrh");
            dic.Add("跦", "khri");
            dic.Add("踬", "khrm");
            dic.Add("蹏", "khrm");
            dic.Add("躓", "khrm");
            dic.Add("躈", "khrt");
            dic.Add("跅", "khry");
            dic.Add("跴", "khsg");
            dic.Add("蹅", "khsg");
            dic.Add("跒", "khsk");
            dic.Add("蹮", "khsn");
            dic.Add("躚", "khsp");
            dic.Add("路", "kht");
            dic.Add("踟", "kht");
            dic.Add("跃", "khtd");
            dic.Add("踵", "khtf");
            dic.Add("鹭", "khtg");
            dic.Add("跭", "khth");
            dic.Add("蹝", "khth");
            dic.Add("蹤", "khth");
            dic.Add("蹻", "khtk");
            dic.Add("蹯", "khtl");
            dic.Add("躜", "khtm");
            dic.Add("躦", "khtm");
            dic.Add("趷", "khtn");
            dic.Add("踿", "khto");
            dic.Add("鷺", "khto");
            dic.Add("跹", "khtp");
            dic.Add("跣", "khtq");
            dic.Add("踇", "khtu");
            dic.Add("踒", "khtv");
            dic.Add("踽", "khty");
            dic.Add("足", "khu");
            dic.Add("蹉", "khua");
            dic.Add("跰", "khua");
            dic.Add("踯", "khub");
            dic.Add("踡", "khub");
            dic.Add("躑", "khub");
            dic.Add("蹢", "khud");
            dic.Add("躘", "khud");
            dic.Add("蹲", "khuf");
            dic.Add("跘", "khuf");
            dic.Add("蹱", "khuf");
            dic.Add("踫", "khug");
            dic.Add("蹄", "khuh");
            dic.Add("躝", "khui");
            dic.Add("蹭", "khuj");
            dic.Add("踣", "khuk");
            dic.Add("躢", "khun");
            dic.Add("跤", "khuq");
            dic.Add("躨", "khut");
            dic.Add("踥", "khuv");
            dic.Add("躙", "khuy");
            dic.Add("跟", "khv");
            dic.Add("躐", "khvn");
            dic.Add("踺", "khvp");
            dic.Add("蹆", "khvp");
            dic.Add("趴", "khw");
            dic.Add("跄", "khw");
            dic.Add("踚", "khwa");
            dic.Add("啮", "khwb");
            dic.Add("跉", "khwc");
            dic.Add("蹳", "khwc");
            dic.Add("跈", "khwe");
            dic.Add("跗", "khwf");
            dic.Add("跧", "khwg");
            dic.Add("踨", "khwh");
            dic.Add("踰", "khwj");
            dic.Add("跲", "khwk");
            dic.Add("蹌", "khwk");
            dic.Add("趻", "khwn");
            dic.Add("踗", "khwn");
            dic.Add("蹹", "khwn");
            dic.Add("蹬", "khwu");
            dic.Add("踓", "khwy");
            dic.Add("嘴", "khx");
            dic.Add("跸", "khxf");
            dic.Add("躖", "khxg");
            dic.Add("蹞", "khxm");
            dic.Add("躀", "khxm");
            dic.Add("呲", "khxn");
            dic.Add("喍", "khxs");
            dic.Add("躒", "khxs");
            dic.Add("卟", "khy");
            dic.Add("蹁", "khya");
            dic.Add("踱", "khyc");
            dic.Add("踉", "khye");
            dic.Add("躟", "khye");
            dic.Add("躔", "khyf");
            dic.Add("踤", "khyf");
            dic.Add("躋", "khyf");
            dic.Add("躕", "khyf");
            dic.Add("跓", "khyg");
            dic.Add("跻", "khyj");
            dic.Add("踮", "khyk");
            dic.Add("蹴", "khyn");
            dic.Add("趽", "khyn");
            dic.Add("跡", "khyo");
            dic.Add("蹠", "khyo");
            dic.Add("蹾", "khyt");
            dic.Add("蹗", "khyx");
            dic.Add("吵", "ki");
            dic.Add("哨", "kie");
            dic.Add("啵", "kih");
            dic.Add("嘙", "kihv");
            dic.Add("唦", "kiit");
            dic.Add("唢", "kim");
            dic.Add("嗩", "kimy");
            dic.Add("嘡", "kipf");
            dic.Add("嚐", "kipj");
            dic.Add("噹", "kipl");
            dic.Add("咣", "kiq");
            dic.Add("咷", "kiqn");
            dic.Add("嗨", "kitu");
            dic.Add("虽", "kj");
            dic.Add("嗶", "kjaf");
            dic.Add("嚗", "kjai");
            dic.Add("嘬", "kjb");
            dic.Add("哩", "kjf");
            dic.Add("嘢", "kjfb");
            dic.Add("哻", "kjfh");
            dic.Add("呾", "kjgg");
            dic.Add("啺", "kjgr");
            dic.Add("呻", "kjh");
            dic.Add("唱", "kjj");
            dic.Add("嗢", "kjlg");
            dic.Add("喁", "kjm");
            dic.Add("黾", "kjn");
            dic.Add("喝", "kjq");
            dic.Add("嗮", "kjsg");
            dic.Add("喅", "kjug");
            dic.Add("雖", "kjwy");
            dic.Add("吕", "kk");
            dic.Add("噐", "kkak");
            dic.Add("嚚", "kkak");
            dic.Add("郘", "kkbh");
            dic.Add("骂", "kkc");
            dic.Add("唈", "kkcn");
            dic.Add("駡", "kkcu");
            dic.Add("器", "kkd");
            dic.Add("嚣", "kkd");
            dic.Add("嚻", "kkdk");
            dic.Add("囂", "kkdk");
            dic.Add("嚴", "kkdt");
            dic.Add("哭", "kkdu");
            dic.Add("鄂", "kkfb");
            dic.Add("卾", "kkfb");
            dic.Add("鹗", "kkfg");
            dic.Add("颚", "kkfm");
            dic.Add("顎", "kkfm");
            dic.Add("咢", "kkfn");
            dic.Add("鶚", "kkfo");
            dic.Add("遌", "kkfp");
            dic.Add("覨", "kkfq");
            dic.Add("吅", "kkg");
            dic.Add("呺", "kkgn");
            dic.Add("嘍", "kkgv");
            dic.Add("串", "kkh");
            dic.Add("嘳", "kkhm");
            dic.Add("患", "kkhn");
            dic.Add("哫", "kkhy");
            dic.Add("戰", "kkja");
            dic.Add("鄲", "kkjb");
            dic.Add("囅", "kkje");
            dic.Add("辴", "kkje");
            dic.Add("單", "kkjf");
            dic.Add("丳", "kkjk");
            dic.Add("鷤", "kkjo");
            dic.Add("品", "kkk");
            dic.Add("鄵", "kkkb");
            dic.Add("碞", "kkkd");
            dic.Add("嘽", "kkkf");
            dic.Add("劋", "kkkj");
            dic.Add("喦", "kkkm");
            dic.Add("嵒", "kkkm");
            dic.Add("氉", "kkkn");
            dic.Add("噪", "kkks");
            dic.Add("喿", "kkks");
            dic.Add("鼍", "kkl");
            dic.Add("獸", "kkld");
            dic.Add("哵", "kklj");
            dic.Add("嘼", "kklk");
            dic.Add("鼉", "kklv");
            dic.Add("咒", "kkm");
            dic.Add("", "kkmw");
            dic.Add("嘂", "kknk");
            dic.Add("斝", "kkpf");
            dic.Add("呪", "kkqn");
            dic.Add("遻", "kkup");
            dic.Add("呮", "kkwy");
            dic.Add("喌", "kkyh");
            dic.Add("另", "kl");
            dic.Add("嘓", "klag");
            dic.Add("咽", "kld");
            dic.Add("嗯", "kldn");
            dic.Add("喟", "kle");
            dic.Add("嘿", "klf");
            dic.Add("嚜", "klff");
            dic.Add("嚸", "klfk");
            dic.Add("啭", "klfy");
            dic.Add("喂", "klg");
            dic.Add("呬", "klg");
            dic.Add("噮", "klge");
            dic.Add("囀", "klgf");
            dic.Add("啯", "klgy");
            dic.Add("呷", "klh");
            dic.Add("唓", "klh");
            dic.Add("嚃", "klip");
            dic.Add("别", "klj");
            dic.Add("咖", "klk");
            dic.Add("嗋", "klle");
            dic.Add("嘪", "klmy");
            dic.Add("叻", "kln");
            dic.Add("嗹", "klpy");
            dic.Add("噣", "klqj");
            dic.Add("啰", "klqy");
            dic.Add("嚺", "klup");
            dic.Add("囉", "klxy");
            dic.Add("员", "km");
            dic.Add("嗣", "kma");
            dic.Add("噥", "kmae");
            dic.Add("翤", "kman");
            dic.Add("唺", "kmaw");
            dic.Add("郧", "kmb");
            dic.Add("鄖", "kmbh");
            dic.Add("吺", "kmcy");
            dic.Add("喘", "kmd");
            dic.Add("嘊", "kmdf");
            dic.Add("啱", "kmdg");
            dic.Add("咉", "kmdy");
            dic.Add("嘣", "kme");
            dic.Add("嗗", "kmeg");
            dic.Add("啁", "kmf");
            dic.Add("呥", "kmfg");
            dic.Add("哃", "kmgk");
            dic.Add("吊", "kmh");
            dic.Add("勋", "kml");
            dic.Add("勛", "kmln");
            dic.Add("嘤", "kmm");
            dic.Add("嚶", "kmmv");
            dic.Add("叽", "kmn");
            dic.Add("喎", "kmnk");
            dic.Add("哕", "kmq");
            dic.Add("哚", "kms");
            dic.Add("吶", "kmty");
            dic.Add("員", "kmu");
            dic.Add("囎", "kmuj");
            dic.Add("呐", "kmw");
            dic.Add("剐", "kmwj");
            dic.Add("鶰", "kmwo");
            dic.Add("呙", "kmwu");
            dic.Add("嗺", "kmwy");
            dic.Add("呗", "kmy");
            dic.Add("唄", "kmy");
            dic.Add("叫", "kn");
            dic.Add("呡", "knan");
            dic.Add("啒", "knbm");
            dic.Add("噉", "knbt");
            dic.Add("啹", "kndg");
            dic.Add("吳", "kndu");
            dic.Add("吜", "knfg");
            dic.Add("叼", "kng");
            dic.Add("喔", "kngf");
            dic.Add("呞", "kngk");
            dic.Add("呉", "kngw");
            dic.Add("喡", "knhh");
            dic.Add("囑", "knij");
            dic.Add("噼", "knk");
            dic.Add("唰", "knm");
            dic.Add("噀", "knnw");
            dic.Add("嘱", "knt");
            dic.Add("咇", "kntt");
            dic.Add("嘐", "knwe");
            dic.Add("吷", "knwy");
            dic.Add("嚁", "knwy");
            dic.Add("呢", "knx");
            dic.Add("吣", "kny");
            dic.Add("噿", "knyf");
            dic.Add("呎", "knyy");
            dic.Add("噗", "ko");
            dic.Add("嚉", "kogf");
            dic.Add("啖", "koo");
            dic.Add("嘮", "kool");
            dic.Add("噒", "koqh");
            dic.Add("喽", "kov");
            dic.Add("咪", "koy");
            dic.Add("吙", "koy");
            dic.Add("喧", "kp");
            dic.Add("嗐", "kpdk");
            dic.Add("哝", "kpe");
            dic.Add("噻", "kpf");
            dic.Add("唍", "kpfq");
            dic.Add("啶", "kpgh");
            dic.Add("喗", "kplh");
            dic.Add("嘧", "kpn");
            dic.Add("嚀", "kpns");
            dic.Add("啘", "kpqb");
            dic.Add("哰", "kprh");
            dic.Add("咛", "kps");
            dic.Add("喀", "kpt");
            dic.Add("咤", "kpta");
            dic.Add("咹", "kpvg");
            dic.Add("嚓", "kpw");
            dic.Add("啌", "kpwa");
            dic.Add("噾", "kpwj");
            dic.Add("咜", "kpxn");
            dic.Add("史", "kq");
            dic.Add("呧", "kqay");
            dic.Add("兄", "kqb");
            dic.Add("唏", "kqd");
            dic.Add("嘫", "kqdo");
            dic.Add("噡", "kqdy");
            dic.Add("嘝", "kqef");
            dic.Add("唃", "kqeh");
            dic.Add("噜", "kqg");
            dic.Add("唫", "kqg");
            dic.Add("咰", "kqjg");
            dic.Add("別", "kqjh");
            dic.Add("呴", "kqkg");
            dic.Add("喣", "kqko");
            dic.Add("嚵", "kqky");
            dic.Add("唤", "kqm");
            dic.Add("喚", "kqmd");
            dic.Add("咆", "kqn");
            dic.Add("呜", "kqng");
            dic.Add("嚕", "kqoj");
            dic.Add("哆", "kqq");
            dic.Add("哅", "kqqb");
            dic.Add("吻", "kqr");
            dic.Add("啕", "kqrm");
            dic.Add("唿", "kqrn");
            dic.Add("唙", "kqto");
            dic.Add("呁", "kqug");
            dic.Add("啗", "kqvg");
            dic.Add("喼", "kqvn");
            dic.Add("吹", "kqw");
            dic.Add("焁", "kqwo");
            dic.Add("鸣", "kqy");
            dic.Add("嚠", "kqyj");
            dic.Add("听", "kr");
            dic.Add("唣", "kra");
            dic.Add("呱", "krc");
            dic.Add("嗥", "krd");
            dic.Add("哌", "kre");
            dic.Add("唕", "krfh");
            dic.Add("喤", "krgg");
            dic.Add("啣", "krhb");
            dic.Add("哖", "krhf");
            dic.Add("吽", "krhh");
            dic.Add("嗁", "krhm");
            dic.Add("噑", "krif");
            dic.Add("咮", "kriy");
            dic.Add("嘸", "krlo");
            dic.Add("嚹", "krmh");
            dic.Add("啲", "krqy");
            dic.Add("啪", "krr");
            dic.Add("哳", "krrh");
            dic.Add("咑", "krsh");
            dic.Add("啤", "krt");
            dic.Add("啦", "kru");
            dic.Add("唞", "kruf");
            dic.Add("呹", "krwy");
            dic.Add("喞", "krxb");
            dic.Add("噭", "kryt");
            dic.Add("呆", "ks");
            dic.Add("喖", "ksdg");
            dic.Add("嘌", "ksf");
            dic.Add("哂", "ksg");
            dic.Add("呠", "ksgg");
            dic.Add("唒", "ksgg");
            dic.Add("叮", "ksh");
            dic.Add("喳", "ksj");
            dic.Add("嘾", "ksjh");
            dic.Add("呵", "ksk");
            dic.Add("槑", "ksks");
            dic.Add("唽", "ksrh");
            dic.Add("啉", "kss");
            dic.Add("噤", "kssi");
            dic.Add("喓", "ksvg");
            dic.Add("嘜", "kswt");
            dic.Add("唻", "ksww");
            dic.Add("呼", "kt");
            dic.Add("噬", "kta");
            dic.Add("呏", "ktah");
            dic.Add("吒", "ktan");
            dic.Add("咶", "ktdg");
            dic.Add("嘺", "ktdk");
            dic.Add("唀", "kten");
            dic.Add("吀", "ktfh");
            dic.Add("吘", "ktfh");
            dic.Add("哘", "ktfh");
            dic.Add("哠", "ktfk");
            dic.Add("囋", "ktfm");
            dic.Add("喢", "ktfv");
            dic.Add("唾", "ktg");
            dic.Add("喠", "ktgf");
            dic.Add("嚑", "ktgo");
            dic.Add("咱", "kth");
            dic.Add("嗅", "kthd");
            dic.Add("咋", "kthf");
            dic.Add("嘷", "kthf");
            dic.Add("川", "kthh");
            dic.Add("嘥", "kthh");
            dic.Add("喒", "kthj");
            dic.Add("嚊", "kthj");
            dic.Add("唌", "kthp");
            dic.Add("嘚", "ktjf");
            dic.Add("唎", "ktjh");
            dic.Add("咯", "ktk");
            dic.Add("呂", "ktkf");
            dic.Add("啝", "ktkg");
            dic.Add("囖", "ktly");
            dic.Add("响", "ktm");
            dic.Add("噢", "ktmd");
            dic.Add("吃", "ktn");
            dic.Add("啾", "kto");
            dic.Add("噃", "ktol");
            dic.Add("嚟", "ktqi");
            dic.Add("哦", "ktr");
            dic.Add("咚", "ktuy");
            dic.Add("唩", "ktvg");
            dic.Add("呚", "kty");
            dic.Add("咊", "kty");
            dic.Add("叺", "ktyy");
            dic.Add("啼", "ku");
            dic.Add("嗍", "kub");
            dic.Add("咩", "kud");
            dic.Add("嗟", "kuda");
            dic.Add("啳", "kudb");
            dic.Add("嗴", "kudc");
            dic.Add("唴", "kudn");
            dic.Add("咲", "kudy");
            dic.Add("嚨", "kued");
            dic.Add("呌", "kufh");
            dic.Add("吖", "kuh");
            dic.Add("喑", "kuj");
            dic.Add("啴", "kujf");
            dic.Add("噇", "kujf");
            dic.Add("噫", "kujn");
            dic.Add("噷", "kujw");
            dic.Add("哾", "kukq");
            dic.Add("噌", "kul");
            dic.Add("嘀", "kum");
            dic.Add("", "kunt");
            dic.Add("", "kunt");
            dic.Add("嗙", "kupy");
            dic.Add("咬", "kuq");
            dic.Add("嚪", "kuqv");
            dic.Add("噂", "kusf");
            dic.Add("嚫", "kusq");
            dic.Add("噺", "kusr");
            dic.Add("喭", "kute");
            dic.Add("唼", "kuv");
            dic.Add("嗛", "kuvo");
            dic.Add("嗌", "kuw");
            dic.Add("唥", "kuwc");
            dic.Add("嗞", "kuxx");
            dic.Add("哪", "kv");
            dic.Add("噚", "kvaf");
            dic.Add("叧", "kvb");
            dic.Add("呶", "kvc");
            dic.Add("唧", "kvcb");
            dic.Add("嘅", "kvcq");
            dic.Add("哏", "kve");
            dic.Add("嘯", "kvfj");
            dic.Add("嗖", "kvh");
            dic.Add("嚍", "kvhl");
            dic.Add("啸", "kvi");
            dic.Add("嗈", "kvkc");
            dic.Add("叨", "kvn");
            dic.Add("嘨", "kvoj");
            dic.Add("唚", "kvpc");
            dic.Add("唲", "kvqn");
            dic.Add("吚", "kvtt");
            dic.Add("只", "kw");
            dic.Add("呛", "kwb");
            dic.Add("咃", "kwbn");
            dic.Add("嗡", "kwc");
            dic.Add("咐", "kwf");
            dic.Add("哙", "kwfc");
            dic.Add("啥", "kwfk");
            dic.Add("哈", "kwg");
            dic.Add("啽", "kwga");
            dic.Add("喩", "kwgb");
            dic.Add("喻", "kwgj");
            dic.Add("噲", "kwgj");
            dic.Add("噏", "kwgn");
            dic.Add("嗱", "kwgr");
            dic.Add("噔", "kwgu");
            dic.Add("噞", "kwgw");
            dic.Add("吤", "kwjh");
            dic.Add("嗰", "kwld");
            dic.Add("喉", "kwn");
            dic.Add("嗚", "kwno");
            dic.Add("嗲", "kwq");
            dic.Add("咻", "kws");
            dic.Add("哬", "kwsk");
            dic.Add("嘦", "kwsv");
            dic.Add("喺", "kwti");
            dic.Add("唋", "kwty");
            dic.Add("吩", "kwv");
            dic.Add("鳴", "kwvo");
            dic.Add("嘄", "kwvs");
            dic.Add("咿", "kwvt");
            dic.Add("唑", "kww");
            dic.Add("唂", "kwwk");
            dic.Add("哗", "kwx");
            dic.Add("吪", "kwxn");
            dic.Add("叭", "kwy");
            dic.Add("呤", "kwy");
            dic.Add("噙", "kwyc");
            dic.Add("喰", "kwye");
            dic.Add("唯", "kwyg");
            dic.Add("唅", "kwyk");
            dic.Add("嗆", "kwyk");
            dic.Add("嗿", "kwym");
            dic.Add("吟", "kwyn");
            dic.Add("唸", "kwyn");
            dic.Add("噍", "kwyo");
            dic.Add("鷕", "kwyo");
            dic.Add("哟", "kx");
            dic.Add("喙", "kxe");
            dic.Add("嚩", "kxgf");
            dic.Add("呣", "kxgu");
            dic.Add("吲", "kxh");
            dic.Add("咈", "kxjh");
            dic.Add("呦", "kxl");
            dic.Add("叱", "kxn");
            dic.Add("喲", "kxqy");
            dic.Add("嚛", "kxrs");
            dic.Add("哛", "kxwv");
            dic.Add("吡", "kxx");
            dic.Add("哔", "kxxf");
            dic.Add("咝", "kxxg");
            dic.Add("噝", "kxxi");
            dic.Add("喈", "kxxr");
            dic.Add("嘰", "kxxt");
            dic.Add("吆", "kxy");
            dic.Add("嘛", "ky");
            dic.Add("喥", "kyac");
            dic.Add("嗻", "kyao");
            dic.Add("嚝", "kyaw");
            dic.Add("哼", "kyb");
            dic.Add("啍", "kybg");
            dic.Add("噋", "kybt");
            dic.Add("囄", "kyby");
            dic.Add("唷", "kyc");
            dic.Add("唁", "kyg");
            dic.Add("噈", "kyin");
            dic.Add("哜", "kyj");
            dic.Add("嚌", "kyjg");
            dic.Add("嚷", "kyk");
            dic.Add("吭", "kym");
            dic.Add("嗃", "kymk");
            dic.Add("咏", "kyn");
            dic.Add("唳", "kynd");
            dic.Add("呝", "kynn");
            dic.Add("咳", "kynw");
            dic.Add("嚎", "kyp");
            dic.Add("喨", "kypm");
            dic.Add("嚰", "kysd");
            dic.Add("嚤", "kysr");
            dic.Add("嚒", "kysx");
            dic.Add("嗾", "kyt");
            dic.Add("啷", "kyv");
            dic.Add("哴", "kyve");
            dic.Add("嘃", "kyvh");
            dic.Add("啐", "kyw");
            dic.Add("唹", "kywu");
            dic.Add("囃", "kywy");
            dic.Add("呟", "kyxy");
            dic.Add("噰", "kyxy");
            dic.Add("呅", "kyy");
            dic.Add("国", "l");
            dic.Add("田", "l");
            dic.Add("轼", "la");
            dic.Add("軾", "laag");
            dic.Add("輚", "laat");
            dic.Add("羁", "laf");
            dic.Add("羈", "lafc");
            dic.Add("羇", "lafk");
            dic.Add("軭", "lagg");
            dic.Add("轞", "lahl");
            dic.Add("羃", "lajh");
            dic.Add("轕", "lajn");
            dic.Add("國", "lakg");
            dic.Add("罭", "lakg");
            dic.Add("爴", "laky");
            dic.Add("轥", "lauy");
            dic.Add("異", "lawu");
            dic.Add("輁", "lawy");
            dic.Add("囝", "lb");
            dic.Add("輙", "lbcy");
            dic.Add("礊", "lbmd");
            dic.Add("繫", "lbmi");
            dic.Add("蟿", "lbmj");
            dic.Add("轚", "lbml");
            dic.Add("罊", "lbmm");
            dic.Add("擊", "lbmr");
            dic.Add("檕", "lbms");
            dic.Add("辄", "lbn");
            dic.Add("輒", "lbnn");
            dic.Add("轻", "lc");
            dic.Add("輮", "lcbs");
            dic.Add("罞", "lcbt");
            dic.Add("轰", "lcc");
            dic.Add("辍", "lccc");
            dic.Add("畷", "lccc");
            dic.Add("罬", "lccc");
            dic.Add("輟", "lccc");
            dic.Add("輽", "lcdl");
            dic.Add("羆", "lceo");
            dic.Add("罷", "lcex");
            dic.Add("圗", "lcfd");
            dic.Add("軽", "lcfg");
            dic.Add("囜", "lci");
            dic.Add("囼", "lckd");
            dic.Add("軩", "lckg");
            dic.Add("圎", "lcmi");
            dic.Add("罵", "lcu");
            dic.Add("畯", "lcwt");
            dic.Add("因", "ld");
            dic.Add("轭", "ldb");
            dic.Add("軛", "ldbn");
            dic.Add("軷", "ldcy");
            dic.Add("固", "ldd");
            dic.Add("囿", "lde");
            dic.Add("罟", "ldf");
            dic.Add("轱", "ldg");
            dic.Add("軲", "ldg");
            dic.Add("轗", "ldgn");
            dic.Add("輱", "ldgt");
            dic.Add("轊", "ldhv");
            dic.Add("罪", "ldj");
            dic.Add("輫", "ldjd");
            dic.Add("罨", "ldjn");
            dic.Add("盢", "ldlf");
            dic.Add("輭", "ldmd");
            dic.Add("輀", "ldmj");
            dic.Add("恩", "ldn");
            dic.Add("罽", "ldoj");
            dic.Add("欭", "ldqw");
            dic.Add("畸", "lds");
            dic.Add("輢", "ldsk");
            dic.Add("畴", "ldt");
            dic.Add("轣", "ldth");
            dic.Add("轑", "ldui");
            dic.Add("辏", "ldw");
            dic.Add("輳", "ldwd");
            dic.Add("轃", "ldwt");
            dic.Add("畎", "ldy");
            dic.Add("軑", "ldy");
            dic.Add("轪", "ldy");
            dic.Add("軚", "ldyy");
            dic.Add("胃", "le");
            dic.Add("罦", "lebf");
            dic.Add("輣", "leeg");
            dic.Add("罝", "legf");
            dic.Add("圂", "lei");
            dic.Add("慁", "lenu");
            dic.Add("轁", "levg");
            dic.Add("轩", "lf");
            dic.Add("轒", "lfam");
            dic.Add("罢", "lfc");
            dic.Add("囩", "lfci");
            dic.Add("圔", "lfcl");
            dic.Add("罴", "lfco");
            dic.Add("転", "lfcy");
            dic.Add("轜", "lfdj");
            dic.Add("畦", "lff");
            dic.Add("罣", "lfff");
            dic.Add("罫", "lffh");
            dic.Add("畤", "lffy");
            dic.Add("軒", "lfh");
            dic.Add("置", "lfhf");
            dic.Add("団", "lfi");
            dic.Add("畊", "lfjh");
            dic.Add("囲", "lfjk");
            dic.Add("辕", "lfk");
            dic.Add("園", "lfke");
            dic.Add("轅", "lfke");
            dic.Add("瞏", "lfke");
            dic.Add("罱", "lfm");
            dic.Add("转", "lfn");
            dic.Add("疇", "lfnf");
            dic.Add("围", "lfnh");
            dic.Add("黑", "lfo");
            dic.Add("黩", "lfo");
            dic.Add("黓", "lfoa");
            dic.Add("黭", "lfoa");
            dic.Add("黦", "lfob");
            dic.Add("默", "lfod");
            dic.Add("黪", "lfoe");
            dic.Add("黲", "lfoe");
            dic.Add("墨", "lfof");
            dic.Add("黚", "lfof");
            dic.Add("黫", "lfof");
            dic.Add("黥", "lfoi");
            dic.Add("黯", "lfoj");
            dic.Add("黠", "lfok");
            dic.Add("點", "lfok");
            dic.Add("黝", "lfol");
            dic.Add("黸", "lfol");
            dic.Add("黜", "lfom");
            dic.Add("黷", "lfom");
            dic.Add("黔", "lfon");
            dic.Add("黗", "lfon");
            dic.Add("黤", "lfon");
            dic.Add("黮", "lfon");
            dic.Add("黟", "lfoq");
            dic.Add("黕", "lfoq");
            dic.Add("黖", "lfoq");
            dic.Add("黢", "lfot");
            dic.Add("黬", "lfot");
            dic.Add("黣", "lfou");
            dic.Add("黰", "lfow");
            dic.Add("黵", "lfoy");
            dic.Add("园", "lfq");
            dic.Add("团", "lft");
            dic.Add("署", "lftj");
            dic.Add("圉", "lfu");
            dic.Add("睪", "lfuf");
            dic.Add("鸅", "lfuo");
            dic.Add("斁", "lfut");
            dic.Add("歝", "lfuw");
            dic.Add("轌", "lfvg");
            dic.Add("轖", "lfwk");
            dic.Add("輘", "lfwt");
            dic.Add("畉", "lfwy");
            dic.Add("车", "lg");
            dic.Add("囤", "lgb");
            dic.Add("軘", "lgbn");
            dic.Add("轾", "lgc");
            dic.Add("輊", "lgcf");
            dic.Add("囯", "lgd");
            dic.Add("畏", "lge");
            dic.Add("圃", "lge");
            dic.Add("圊", "lged");
            dic.Add("圑", "lgef");
            dic.Add("輤", "lgeg");
            dic.Add("辅", "lgey");
            dic.Add("輔", "lgey");
            dic.Add("軖", "lgg");
            dic.Add("罡", "lgh");
            dic.Add("囸", "lghd");
            dic.Add("車", "lghh");
            dic.Add("罘", "lgi");
            dic.Add("囨", "lgii");
            dic.Add("畀", "lgj");
            dic.Add("團", "lgjf");
            dic.Add("轉", "lgjf");
            dic.Add("辐", "lgk");
            dic.Add("圄", "lgkd");
            dic.Add("睘", "lgke");
            dic.Add("鹮", "lgkg");
            dic.Add("輻", "lgkl");
            dic.Add("翾", "lgkn");
            dic.Add("還", "lgkp");
            dic.Add("疅", "lglg");
            dic.Add("辆", "lgm");
            dic.Add("輌", "lgmm");
            dic.Add("輛", "lgmy");
            dic.Add("軏", "lgqn");
            dic.Add("軯", "lguh");
            dic.Add("輕", "lgva");
            dic.Add("輺", "lgvl");
            dic.Add("鑋", "lgvq");
            dic.Add("四", "lh");
            dic.Add("轤", "lhal");
            dic.Add("軙", "lhcy");
            dic.Add("罩", "lhj");
            dic.Add("皿", "lhn");
            dic.Add("囗", "lhn");
            dic.Add("罒", "lhng");
            dic.Add("甲", "lhnh");
            dic.Add("轳", "lhnt");
            dic.Add("輎", "lieg");
            dic.Add("塁", "liff");
            dic.Add("囦", "lii");
            dic.Add("疂", "lipg");
            dic.Add("遝", "lipi");
            dic.Add("輄", "liqn");
            dic.Add("眔", "liu");
            dic.Add("軣", "liu");
            dic.Add("辊", "lj");
            dic.Add("罼", "ljaf");
            dic.Add("囬", "ljfd");
            dic.Add("畼", "ljgr");
            dic.Add("輰", "ljgr");
            dic.Add("輼", "ljlg");
            dic.Add("辒", "ljlg");
            dic.Add("輵", "ljqn");
            dic.Add("輠", "ljsy");
            dic.Add("輥", "ljxx");
            dic.Add("加", "lk");
            dic.Add("辑", "lkb");
            dic.Add("輯", "lkbg");
            dic.Add("驾", "lkc");
            dic.Add("駕", "lkcu");
            dic.Add("回", "lkd");
            dic.Add("罥", "lkef");
            dic.Add("圖", "lkfk");
            dic.Add("甽", "lkh");
            dic.Add("圚", "lkhm");
            dic.Add("贺", "lkm");
            dic.Add("毄", "lkmc");
            dic.Add("圆", "lkmi");
            dic.Add("圓", "lkmi");
            dic.Add("賀", "lkmu");
            dic.Add("乫", "lknb");
            dic.Add("迦", "lkp");
            dic.Add("廻", "lkpd");
            dic.Add("迴", "lkpd");
            dic.Add("軦", "lkqn");
            dic.Add("架", "lks");
            dic.Add("哿", "lksk");
            dic.Add("毠", "lktn");
            dic.Add("妿", "lkvf");
            dic.Add("轵", "lkw");
            dic.Add("嗧", "lkwa");
            dic.Add("鴐", "lkwo");
            dic.Add("軹", "lkwy");
            dic.Add("袈", "lky");
            dic.Add("男", "ll");
            dic.Add("畕", "llf");
            dic.Add("圛", "llff");
            dic.Add("圜", "llg");
            dic.Add("轘", "llge");
            dic.Add("劦", "lllb");
            dic.Add("奰", "llld");
            dic.Add("礨", "llld");
            dic.Add("脅", "llle");
            dic.Add("壘", "lllf");
            dic.Add("壨", "lllf");
            dic.Add("畾", "lllf");
            dic.Add("疉", "lllg");
            dic.Add("疊", "lllg");
            dic.Add("纍", "llli");
            dic.Add("轟", "lllj");
            dic.Add("〇", "llll");
            dic.Add("轠", "llll");
            dic.Add("罍", "lllm");
            dic.Add("勰", "llln");
            dic.Add("氎", "llln");
            dic.Add("鸓", "lllo");
            dic.Add("櫐", "llls");
            dic.Add("姭", "lllv");
            dic.Add("罳", "llnu");
            dic.Add("轋", "llpy");
            dic.Add("嬲", "llv");
            dic.Add("轀", "llwl");
            dic.Add("圐", "llyv");
            dic.Add("轴", "lm");
            dic.Add("辋", "lm");
            dic.Add("繋", "lmci");
            dic.Add("撃", "lmcr");
            dic.Add("軗", "lmcy");
            dic.Add("圌", "lmdj");
            dic.Add("輲", "lmdj");
            dic.Add("軮", "lmdy");
            dic.Add("畘", "lmfg");
            dic.Add("輖", "lmfk");
            dic.Add("軸", "lmg");
            dic.Add("軕", "lmh");
            dic.Add("買", "lmu");
            dic.Add("輞", "lmun");
            dic.Add("鷶", "lmwo");
            dic.Add("軜", "lmwy");
            dic.Add("軓", "lmyy");
            dic.Add("思", "ln");
            dic.Add("轧", "ln");
            dic.Add("辗", "lna");
            dic.Add("罠", "lnab");
            dic.Add("輾", "lnae");
            dic.Add("囻", "lnav");
            dic.Add("轏", "lnbb");
            dic.Add("囙", "lnd");
            dic.Add("顋", "lndm");
            dic.Add("罻", "lnff");
            dic.Add("軐", "lnfh");
            dic.Add("翈", "lng");
            dic.Add("圍", "lnhh");
            dic.Add("劜", "lnn");
            dic.Add("軋", "lnn");
            dic.Add("罹", "lnw");
            dic.Add("疁", "lnwe");
            dic.Add("轇", "lnwe");
            dic.Add("辚", "lo");
            dic.Add("轛", "logf");
            dic.Add("轐", "logy");
            dic.Add("疄", "loqh");
            dic.Add("轔", "loqh");
            dic.Add("边", "lp");
            dic.Add("连", "lp");
            dic.Add("辖", "lpdk");
            dic.Add("轄", "lpdk");
            dic.Add("畳", "lpeg");
            dic.Add("輐", "lpfq");
            dic.Add("連", "lpk");
            dic.Add("輨", "lpnn");
            dic.Add("畹", "lpq");
            dic.Add("罗", "lq");
            dic.Add("软", "lq");
            dic.Add("軝", "lqan");
            dic.Add("軧", "lqay");
            dic.Add("轹", "lqi");
            dic.Add("蜀", "lqj");
            dic.Add("斀", "lqjc");
            dic.Add("斣", "lqjf");
            dic.Add("劅", "lqjj");
            dic.Add("鸀", "lqjo");
            dic.Add("歜", "lqjw");
            dic.Add("軥", "lqkg");
            dic.Add("輓", "lqkq");
            dic.Add("軳", "lqnn");
            dic.Add("逻", "lqp");
            dic.Add("囫", "lqr");
            dic.Add("畇", "lqug");
            dic.Add("輡", "lqvg");
            dic.Add("軟", "lqwy");
            dic.Add("鸭", "lqy");
            dic.Add("輷", "lqyg");
            dic.Add("罶", "lqyl");
            dic.Add("畂", "lqyy");
            dic.Add("斩", "lr");
            dic.Add("暂", "lr");
            dic.Add("畈", "lrc");
            dic.Add("畖", "lrcy");
            dic.Add("罛", "lrcy");
            dic.Add("軱", "lrcy");
            dic.Add("磛", "lrdf");
            dic.Add("堑", "lrf");
            dic.Add("塹", "lrff");
            dic.Add("輴", "lrfh");
            dic.Add("斬", "lrh");
            dic.Add("覱", "lrhq");
            dic.Add("暫", "lrjf");
            dic.Add("蹔", "lrkh");
            dic.Add("慙", "lrnu");
            dic.Add("錾", "lrq");
            dic.Add("鏨", "lrqf");
            dic.Add("椠", "lrs");
            dic.Add("槧", "lrsu");
            dic.Add("轶", "lrw");
            dic.Add("軼", "lrwy");
            dic.Add("困", "ls");
            dic.Add("町", "ls");
            dic.Add("輏", "lsgg");
            dic.Add("甼", "lsj");
            dic.Add("轲", "lsk");
            dic.Add("軻", "lskg");
            dic.Add("罧", "lssu");
            dic.Add("力", "lt");
            dic.Add("图", "lt");
            dic.Add("轿", "ltd");
            dic.Add("轎", "ltdk");
            dic.Add("輈", "ltey");
            dic.Add("辀", "ltey");
            dic.Add("輧", "ltff");
            dic.Add("軠", "ltfg");
            dic.Add("軞", "ltfn");
            dic.Add("畽", "ltgf");
            dic.Add("囷", "lti");
            dic.Add("輹", "ltjt");
            dic.Add("略", "ltk");
            dic.Add("辂", "ltk");
            dic.Add("畧", "ltkf");
            dic.Add("輅", "ltkg");
            dic.Add("轓", "ltol");
            dic.Add("轷", "ltuh");
            dic.Add("軤", "ltuh");
            dic.Add("畮", "ltxu");
            dic.Add("畋", "lty");
            dic.Add("较", "lu");
            dic.Add("圈", "lu");
            dic.Add("軿", "luah");
            dic.Add("畻", "ludf");
            dic.Add("圏", "ludn");
            dic.Add("畔", "luf");
            dic.Add("轙", "lugt");
            dic.Add("疃", "luj");
            dic.Add("罯", "lujf");
            dic.Add("罿", "lujf");
            dic.Add("罾", "lul");
            dic.Add("図", "luqi");
            dic.Add("較", "luqy");
            dic.Add("輶", "lusg");
            dic.Add("罤", "luxt");
            dic.Add("轨", "lv");
            dic.Add("囡", "lvd");
            dic.Add("圕", "lvfj");
            dic.Add("罺", "lvjs");
            dic.Add("轈", "lvjs");
            dic.Add("轺", "lvk");
            dic.Add("軺", "lvkg");
            dic.Add("辎", "lvl");
            dic.Add("輜", "lvlg");
            dic.Add("軌", "lvn");
            dic.Add("輗", "lvqn");
            dic.Add("輑", "lvtk");
            dic.Add("轫", "lvy");
            dic.Add("軔", "lvyy");
            dic.Add("办", "lw");
            dic.Add("圙", "lwdd");
            dic.Add("轸", "lwe");
            dic.Add("畛", "lwe");
            dic.Add("軫", "lwet");
            dic.Add("囶", "lwfd");
            dic.Add("軵", "lwfy");
            dic.Add("输", "lwg");
            dic.Add("圇", "lwga");
            dic.Add("輪", "lwga");
            dic.Add("辁", "lwgg");
            dic.Add("輇", "lwgg");
            dic.Add("輸", "lwgj");
            dic.Add("囚", "lwi");
            dic.Add("界", "lwj");
            dic.Add("畍", "lwjh");
            dic.Add("朙", "lwme");
            dic.Add("囧", "lwmv");
            dic.Add("畟", "lwtu");
            dic.Add("畭", "lwty");
            dic.Add("鴨", "lwvo");
            dic.Add("鴫", "lwvo");
            dic.Add("輍", "lwwk");
            dic.Add("眾", "lwwu");
            dic.Add("轮", "lwx");
            dic.Add("囵", "lwxv");
            dic.Add("囮", "lwxv");
            dic.Add("囹", "lwy");
            dic.Add("軨", "lwyc");
            dic.Add("軡", "lwyn");
            dic.Add("罖", "lwyu");
            dic.Add("圀", "lwyv");
            dic.Add("累", "lx");
            dic.Add("羄", "lxhj");
            dic.Add("羂", "lxke");
            dic.Add("軪", "lxln");
            dic.Add("轢", "lxrs");
            dic.Add("邏", "lxwp");
            dic.Add("羅", "lxwy");
            dic.Add("毗", "lxx");
            dic.Add("毘", "lxxb");
            dic.Add("羉", "lxyi");
            dic.Add("圞", "lxys");
            dic.Add("圝", "lxyx");
            dic.Add("罚", "ly");
            dic.Add("辙", "lyc");
            dic.Add("轍", "lyct");
            dic.Add("圁", "lyd");
            dic.Add("畩", "lyey");
            dic.Add("詈", "lyf");
            dic.Add("罸", "lyfu");
            dic.Add("罜", "lygf");
            dic.Add("軴", "lygg");
            dic.Add("輬", "lyiy");
            dic.Add("辌", "lyiy");
            dic.Add("罰", "lyjj");
            dic.Add("囥", "lymv");
            dic.Add("辘", "lyn");
            dic.Add("甿", "lynn");
            dic.Add("軶", "lynn");
            dic.Add("畡", "lynw");
            dic.Add("輆", "lynw");
            dic.Add("轆", "lynx");
            dic.Add("同", "m");
            dic.Add("山", "m");
            dic.Add("曲", "ma");
            dic.Add("賤", "maat");
            dic.Add("農", "made");
            dic.Add("蠈", "madj");
            dic.Add("嵁", "madn");
            dic.Add("贼", "madt");
            dic.Add("賊", "madt");
            dic.Add("贜", "madt");
            dic.Add("嵌", "maf");
            dic.Add("巈", "mafo");
            dic.Add("屸", "mag");
            dic.Add("鄷", "magb");
            dic.Add("艶", "magc");
            dic.Add("豑", "magt");
            dic.Add("豊", "magu");
            dic.Add("岈", "mah");
            dic.Add("峫", "mahb");
            dic.Add("岽", "mai");
            dic.Add("刪", "majh");
            dic.Add("嶱", "majn");
            dic.Add("贎", "majy");
            dic.Add("冊", "mak");
            dic.Add("嶇", "makk");
            dic.Add("巏", "maky");
            dic.Add("岠", "mang");
            dic.Add("崂", "map");
            dic.Add("嵘", "maps");
            dic.Add("岖", "maq");
            dic.Add("嵽", "maqh");
            dic.Add("嶜", "maqj");
            dic.Add("戝", "mat");
            dic.Add("峣", "matq");
            dic.Add("典", "maw");
            dic.Add("覥", "mawq");
            dic.Add("觍", "mawq");
            dic.Add("敟", "mawt");
            dic.Add("邮", "mb");
            dic.Add("邖", "mbh");
            dic.Add("郥", "mbh");
            dic.Add("崡", "mbib");
            dic.Add("貤", "mbn");
            dic.Add("嶐", "mbtg");
            dic.Add("凤", "mc");
            dic.Add("峅", "mcah");
            dic.Add("岜", "mcb");
            dic.Add("嵾", "mcce");
            dic.Add("贂", "mcce");
            dic.Add("峄", "mcf");
            dic.Add("禸", "mci");
            dic.Add("贻", "mck");
            dic.Add("貽", "mckg");
            dic.Add("殳", "mcu");
            dic.Add("峻", "mcw");
            dic.Add("賐", "mcwt");
            dic.Add("央", "md");
            dic.Add("岸", "md");
            dic.Add("巁", "mday");
            dic.Add("贆", "mddd");
            dic.Add("贿", "mde");
            dic.Add("峟", "mdef");
            dic.Add("賄", "mdeg");
            dic.Add("賬", "mdey");
            dic.Add("岩", "mdf");
            dic.Add("赈", "mdfe");
            dic.Add("賑", "mdfe");
            dic.Add("崖", "mdff");
            dic.Add("峚", "mdff");
            dic.Add("崕", "mdff");
            dic.Add("岵", "mdg");
            dic.Add("崴", "mdgt");
            dic.Add("嵅", "mdgt");
            dic.Add("嵗", "mdgt");
            dic.Add("鳳", "mdho");
            dic.Add("巎", "mdht");
            dic.Add("崦", "mdj");
            dic.Add("凮", "mdjd");
            dic.Add("盎", "mdl");
            dic.Add("輋", "mdlj");
            dic.Add("遄", "mdm");
            dic.Add("剬", "mdmj");
            dic.Add("峏", "mdmj");
            dic.Add("耑", "mdmj");
            dic.Add("颛", "mdmm");
            dic.Add("顓", "mdmm");
            dic.Add("歂", "mdmw");
            dic.Add("崸", "mdmy");
            dic.Add("頔", "mdmy");
            dic.Add("峸", "mdnt");
            dic.Add("贓", "mdnt");
            dic.Add("炭", "mdo");
            dic.Add("鸯", "mdq");
            dic.Add("屵", "mdr");
            dic.Add("崎", "mds");
            dic.Add("嶏", "mdsn");
            dic.Add("嶚", "mdui");
            dic.Add("嶛", "mdui");
            dic.Add("嶡", "mduw");
            dic.Add("嶥", "mduw");
            dic.Add("賰", "mdwj");
            dic.Add("鴦", "mdwo");
            dic.Add("峽", "mdww");
            dic.Add("嵟", "mdwy");
            dic.Add("賎", "mdxy");
            dic.Add("骨", "me");
            dic.Add("髒", "meaa");
            dic.Add("嶾", "mean");
            dic.Add("骮", "meay");
            dic.Add("髓", "med");
            dic.Add("骷", "medg");
            dic.Add("顝", "medm");
            dic.Add("骻", "medn");
            dic.Add("髄", "medp");
            dic.Add("崩", "mee");
            dic.Add("剻", "meej");
            dic.Add("骽", "meev");
            dic.Add("胄", "mef");
            dic.Add("冑", "mef");
            dic.Add("嵈", "mefc");
            dic.Add("嶳", "meff");
            dic.Add("骭", "mefh");
            dic.Add("髐", "mefq");
            dic.Add("岄", "meg");
            dic.Add("骬", "megf");
            dic.Add("髆", "megf");
            dic.Add("岨", "megg");
            dic.Add("骾", "megq");
            dic.Add("骳", "mehc");
            dic.Add("髗", "mehl");
            dic.Add("骴", "mehx");
            dic.Add("髁", "mej");
            dic.Add("髃", "mejy");
            dic.Add("髏", "mekv");
            dic.Add("髑", "mel");
            dic.Add("骰", "mem");
            dic.Add("體", "memu");
            dic.Add("骪", "memy");
            dic.Add("屷", "men");
            dic.Add("髎", "mene");
            dic.Add("髅", "meo");
            dic.Add("髂", "mep");
            dic.Add("髕", "mepm");
            dic.Add("髋", "mepq");
            dic.Add("髌", "mepw");
            dic.Add("髉", "mepy");
            dic.Add("髖", "mepy");
            dic.Add("鹘", "meq");
            dic.Add("骲", "meqn");
            dic.Add("骶", "meqy");
            dic.Add("骺", "mer");
            dic.Add("髀", "merf");
            dic.Add("骵", "mesg");
            dic.Add("骼", "met");
            dic.Add("骿", "meua");
            dic.Add("髊", "meua");
            dic.Add("骹", "meuq");
            dic.Add("髈", "meuy");
            dic.Add("崢", "mevh");
            dic.Add("骩", "mevn");
            dic.Add("骫", "mevy");
            dic.Add("骱", "mew");
            dic.Add("鶻", "mewo");
            dic.Add("嵠", "mexd");
            dic.Add("骸", "mey");
            dic.Add("髇", "meyk");
            dic.Add("骯", "meym");
            dic.Add("髍", "meys");
            dic.Add("岌", "meyu");
            dic.Add("岋", "meyy");
            dic.Add("财", "mf");
            dic.Add("賳", "mfak");
            dic.Add("嶻", "mfay");
            dic.Add("岐", "mfc");
            dic.Add("凨", "mfci");
            dic.Add("冉", "mfd");
            dic.Add("冃", "mfd");
            dic.Add("冄", "mfd");
            dic.Add("嶿", "mfdj");
            dic.Add("峙", "mff");
            dic.Add("亗", "mff");
            dic.Add("崶", "mfff");
            dic.Add("嶀", "mffn");
            dic.Add("嶢", "mffq");
            dic.Add("嶤", "mffq");
            dic.Add("巅", "mfh");
            dic.Add("屽", "mfh");
            dic.Add("巔", "mfhm");
            dic.Add("嵮", "mfhw");
            dic.Add("赇", "mfi");
            dic.Add("賕", "mfiy");
            dic.Add("購", "mfjf");
            dic.Add("周", "mfk");
            dic.Add("郮", "mfkb");
            dic.Add("彫", "mfke");
            dic.Add("翢", "mfkn");
            dic.Add("鵰", "mfko");
            dic.Add("週", "mfkp");
            dic.Add("雕", "mfky");
            dic.Add("贖", "mflm");
            dic.Add("赎", "mfn");
            dic.Add("嶹", "mfnf");
            dic.Add("岏", "mfqn");
            dic.Add("貦", "mfqn");
            dic.Add("崁", "mfqw");
            dic.Add("赌", "mftj");
            dic.Add("賭", "mftj");
            dic.Add("財", "mftt");
            dic.Add("峔", "mftx");
            dic.Add("崚", "mfwt");
            dic.Add("贱", "mg");
            dic.Add("赋", "mga");
            dic.Add("岍", "mga");
            dic.Add("崋", "mgaf");
            dic.Add("賦", "mgah");
            dic.Add("峌", "mgcf");
            dic.Add("赙", "mge");
            dic.Add("賻", "mgef");
            dic.Add("崝", "mgeg");
            dic.Add("", "mgeg");
            dic.Add("", "mgeg");
            dic.Add("峬", "mgey");
            dic.Add("鄳", "mggb");
            dic.Add("黽", "mggv");
            dic.Add("岯", "mgig");
            dic.Add("凬", "mgjd");
            dic.Add("峘", "mgjg");
            dic.Add("崠", "mgji");
            dic.Add("崬", "mgji");
            dic.Add("畁", "mgjj");
            dic.Add("峺", "mgjq");
            dic.Add("戙", "mgka");
            dic.Add("敱", "mgkc");
            dic.Add("獃", "mgkd");
            dic.Add("峿", "mgkg");
            dic.Add("剴", "mgkj");
            dic.Add("颽", "mgkj");
            dic.Add("凱", "mgkm");
            dic.Add("顗", "mgkm");
            dic.Add("迵", "mgkp");
            dic.Add("覬", "mgkq");
            dic.Add("敳", "mgkt");
            dic.Add("豈", "mgku");
            dic.Add("嶆", "mgmj");
            dic.Add("屿", "mgn");
            dic.Add("甹", "mgnb");
            dic.Add("崃", "mgo");
            dic.Add("夙", "mgq");
            dic.Add("峛", "mgqj");
            dic.Add("峢", "mgqj");
            dic.Add("屼", "mgqn");
            dic.Add("峡", "mgu");
            dic.Add("岼", "mguh");
            dic.Add("崨", "mgvh");
            dic.Add("峓", "mgxw");
            dic.Add("由", "mh");
            dic.Add("贝", "mh");
            dic.Add("巇", "mhaa");
            dic.Add("帴", "mhaa");
            dic.Add("巘", "mhad");
            dic.Add("巚", "mhad");
            dic.Add("幙", "mhad");
            dic.Add("幪", "mhae");
            dic.Add("幊", "mham");
            dic.Add("幉", "mhas");
            dic.Add("幭", "mhat");
            dic.Add("帺", "mhaw");
            dic.Add("幓", "mhce");
            dic.Add("帊", "mhcn");
            dic.Add("岥", "mhcy");
            dic.Add("貱", "mhcy");
            dic.Add("帱", "mhd");
            dic.Add("凪", "mhd");
            dic.Add("帗", "mhdc");
            dic.Add("帪", "mhde");
            dic.Add("帳", "mhde");
            dic.Add("帞", "mhdj");
            dic.Add("幁", "mhdm");
            dic.Add("幍", "mhev");
            dic.Add("帏", "mhf");
            dic.Add("幬", "mhff");
            dic.Add("帾", "mhfj");
            dic.Add("幩", "mhfm");
            dic.Add("幅", "mhg");
            dic.Add("円", "mhgd");
            dic.Add("峠", "mhgh");
            dic.Add("帻", "mhgm");
            dic.Add("幘", "mhgm");
            dic.Add("帓", "mhgs");
            dic.Add("帖", "mhh");
            dic.Add("帔", "mhhc");
            dic.Add("帧", "mhhm");
            dic.Add("幀", "mhhm");
            dic.Add("帩", "mhie");
            dic.Add("幥", "mhir");
            dic.Add("帽", "mhj");
            dic.Add("幔", "mhjc");
            dic.Add("幜", "mhji");
            dic.Add("幆", "mhjn");
            dic.Add("幌", "mhjq");
            dic.Add("巾", "mhk");
            dic.Add("幝", "mhkf");
            dic.Add("贴", "mhkg");
            dic.Add("岾", "mhkg");
            dic.Add("貼", "mhkg");
            dic.Add("幧", "mhks");
            dic.Add("帜", "mhkw");
            dic.Add("帼", "mhl");
            dic.Add("幗", "mhlg");
            dic.Add("帆", "mhm");
            dic.Add("冂", "mhn");
            dic.Add("幈", "mhna");
            dic.Add("幄", "mhnf");
            dic.Add("幃", "mhnh");
            dic.Add("貝", "mhny");
            dic.Add("幞", "mho");
            dic.Add("帵", "mhpb");
            dic.Add("幏", "mhpe");
            dic.Add("幰", "mhpn");
            dic.Add("帎", "mhpq");
            dic.Add("幎", "mhpu");
            dic.Add("峴", "mhqn");
            dic.Add("幨", "mhqy");
            dic.Add("帕", "mhr");
            dic.Add("幠", "mhro");
            dic.Add("帙", "mhrw");
            dic.Add("帄", "mhsh");
            dic.Add("幖", "mhsi");
            dic.Add("帐", "mht");
            dic.Add("幯", "mhtb");
            dic.Add("帲", "mhtf");
            dic.Add("幡", "mhtl");
            dic.Add("幒", "mhtn");
            dic.Add("幢", "mhu");
            dic.Add("帡", "mhua");
            dic.Add("幱", "mhui");
            dic.Add("幛", "mhuj");
            dic.Add("幟", "mhuj");
            dic.Add("帨", "mhuq");
            dic.Add("帹", "mhuv");
            dic.Add("帷", "mhw");
            dic.Add("帿", "mhwd");
            dic.Add("帢", "mhwk");
            dic.Add("帉", "mhwv");
            dic.Add("幮", "mhyf");
            dic.Add("峭", "mi");
            dic.Add("巌", "midt");
            dic.Add("埊", "miff");
            dic.Add("崉", "mijg");
            dic.Add("贘", "mipm");
            dic.Add("汖", "miu");
            dic.Add("嵴", "miw");
            dic.Add("巀", "miwa");
            dic.Add("则", "mj");
            dic.Add("廽", "mjdp");
            dic.Add("逥", "mjdp");
            dic.Add("嵵", "mjff");
            dic.Add("崼", "mjgh");
            dic.Add("崵", "mjgr");
            dic.Add("則", "mjh");
            dic.Add("賵", "mjhg");
            dic.Add("赗", "mjhg");
            dic.Add("嵎", "mjmy");
            dic.Add("赐", "mjq");
            dic.Add("嵑", "mjqn");
            dic.Add("賜", "mjqr");
            dic.Add("岿", "mjv");
            dic.Add("崐", "mjxx");
            dic.Add("崑", "mjxx");
            dic.Add("迥", "mk");
            dic.Add("嶯", "mkbt");
            dic.Add("冋", "mkd");
            dic.Add("嶁", "mkgv");
            dic.Add("賗", "mkkh");
            dic.Add("嵓", "mkkk");
            dic.Add("崿", "mkkn");
            dic.Add("贃", "mkkn");
            dic.Add("巖", "mkkt");
            dic.Add("巗", "mkkt");
            dic.Add("贶", "mkq");
            dic.Add("岲", "mkqn");
            dic.Add("貺", "mkqn");
            dic.Add("嶉", "mkwy");
            dic.Add("崭", "ml");
            dic.Add("屴", "mlb");
            dic.Add("崮", "mld");
            dic.Add("嶵", "mldd");
            dic.Add("崓", "mldg");
            dic.Add("嶧", "mlff");
            dic.Add("嵔", "mlge");
            dic.Add("岬", "mlh");
            dic.Add("崽", "mln");
            dic.Add("嶃", "mlrh");
            dic.Add("嶄", "mlrj");
            dic.Add("册", "mm");
            dic.Add("凹", "mm");
            dic.Add("嶩", "mmae");
            dic.Add("賟", "mmaw");
            dic.Add("岟", "mmdy");
            dic.Add("峀", "mmf");
            dic.Add("賙", "mmfk");
            dic.Add("赒", "mmfk");
            dic.Add("岫", "mmg");
            dic.Add("删", "mmgj");
            dic.Add("峒", "mmgk");
            dic.Add("峝", "mmgk");
            dic.Add("甖", "mmgn");
            dic.Add("兕", "mmgq");
            dic.Add("嵦", "mmgu");
            dic.Add("屾", "mmh");
            dic.Add("凧", "mmhk");
            dic.Add("岀", "mmj");
            dic.Add("崱", "mmjj");
            dic.Add("贔", "mmmu");
            dic.Add("赑", "mmmu");
            dic.Add("巊", "mmmv");
            dic.Add("岗", "mmq");
            dic.Add("鑍", "mmqf");
            dic.Add("岘", "mmqn");
            dic.Add("岚", "mmqu");
            dic.Add("罂", "mmr");
            dic.Add("罌", "mmrm");
            dic.Add("嵐", "mmtj");
            dic.Add("贁", "mmty");
            dic.Add("崗", "mmum");
            dic.Add("婴", "mmv");
            dic.Add("嬰", "mmvf");
            dic.Add("鹦", "mmvg");
            dic.Add("鸚", "mmvo");
            dic.Add("鸎", "mmwo");
            dic.Add("賏", "mmy");
            dic.Add("譻", "mmyf");
            dic.Add("岂", "mn");
            dic.Add("岷", "mna");
            dic.Add("崛", "mnbm");
            dic.Add("崫", "mnbm");
            dic.Add("崌", "mndg");
            dic.Add("嶎", "mnff");
            dic.Add("嵋", "mnh");
            dic.Add("嶈", "mnhf");
            dic.Add("剀", "mnj");
            dic.Add("凯", "mnm");
            dic.Add("冎", "mnmb");
            dic.Add("剮", "mnmj");
            dic.Add("咼", "mnmk");
            dic.Add("過", "mnmp");
            dic.Add("觊", "mnmq");
            dic.Add("旤", "mnmq");
            dic.Add("歄", "mnmw");
            dic.Add("屺", "mnn");
            dic.Add("乢", "mnn");
            dic.Add("嶍", "mnrg");
            dic.Add("囘", "mnv");
            dic.Add("嵺", "mnwe");
            dic.Add("賿", "mnwe");
            dic.Add("赆", "mny");
            dic.Add("赕", "mo");
            dic.Add("嶪", "mogw");
            dic.Add("嶫", "mogw");
            dic.Add("贌", "mogy");
            dic.Add("巆", "mook");
            dic.Add("嶗", "mool");
            dic.Add("嶸", "moos");
            dic.Add("賧", "mooy");
            dic.Add("嶙", "moq");
            dic.Add("嵝", "mov");
            dic.Add("迪", "mp");
            dic.Add("廸", "mpd");
            dic.Add("峵", "mpdc");
            dic.Add("崇", "mpf");
            dic.Add("賩", "mpfi");
            dic.Add("贮", "mpg");
            dic.Add("辿", "mpk");
            dic.Add("賱", "mplh");
            dic.Add("貯", "mpsh");
            dic.Add("峖", "mpvg");
            dic.Add("崆", "mpw");
            dic.Add("嵱", "mpwk");
            dic.Add("賝", "mpws");
            dic.Add("岤", "mpwy");
            dic.Add("岮", "mpxn");
            dic.Add("风", "mq");
            dic.Add("崏", "mqaj");
            dic.Add("嵥", "mqas");
            dic.Add("岻", "mqay");
            dic.Add("貾", "mqay");
            dic.Add("见", "mqb");
            dic.Add("觃", "mqbd");
            dic.Add("岇", "mqbj");
            dic.Add("嵏", "mqbt");
            dic.Add("嵕", "mqbt");
            dic.Add("购", "mqc");
            dic.Add("赡", "mqd");
            dic.Add("峗", "mqdb");
            dic.Add("峞", "mqdb");
            dic.Add("崤", "mqde");
            dic.Add("嶦", "mqdy");
            dic.Add("贍", "mqdy");
            dic.Add("崅", "mqeh");
            dic.Add("嶰", "mqeh");
            dic.Add("崟", "mqf");
            dic.Add("崯", "mqg");
            dic.Add("飓", "mqh");
            dic.Add("飐", "mqhk");
            dic.Add("冈", "mqi");
            dic.Add("罓", "mqi");
            dic.Add("刚", "mqj");
            dic.Add("刿", "mqj");
            dic.Add("賯", "mqjb");
            dic.Add("嶑", "mqje");
            dic.Add("峋", "mqjg");
            dic.Add("岣", "mqk");
            dic.Add("巉", "mqky");
            dic.Add("飔", "mqln");
            dic.Add("翙", "mqng");
            dic.Add("飏", "mqnr");
            dic.Add("飚", "mqo");
            dic.Add("网", "mqq");
            dic.Add("羀", "mqql");
            dic.Add("飗", "mqql");
            dic.Add("飑", "mqqn");
            dic.Add("嵚", "mqqw");
            dic.Add("嶔", "mqqw");
            dic.Add("岉", "mqrt");
            dic.Add("峁", "mqt");
            dic.Add("嶽", "mqtd");
            dic.Add("岁", "mqu");
            dic.Add("峥", "mqv");
            dic.Add("飕", "mqvc");
            dic.Add("嵧", "mqyl");
            dic.Add("贩", "mr");
            dic.Add("岅", "mrcy");
            dic.Add("販", "mrcy");
            dic.Add("凰", "mrg");
            dic.Add("岶", "mrg");
            dic.Add("岴", "mrgg");
            dic.Add("崲", "mrgg");
            dic.Add("岓", "mrh");
            dic.Add("嵬", "mrq");
            dic.Add("崥", "mrtf");
            dic.Add("嶊", "mrwy");
            dic.Add("朵", "ms");
            dic.Add("嶘", "msaa");
            dic.Add("嵿", "msdm");
            dic.Add("凩", "msi");
            dic.Add("剁", "msj");
            dic.Add("嵖", "msjg");
            dic.Add("贉", "msjh");
            dic.Add("岢", "msk");
            dic.Add("崊", "mssy");
            dic.Add("崾", "msv");
            dic.Add("崧", "msw");
            dic.Add("崍", "msww");
            dic.Add("嵀", "msyg");
            dic.Add("几", "mt");
            dic.Add("账", "mta");
            dic.Add("峰", "mtd");
            dic.Add("峯", "mtdh");
            dic.Add("峤", "mtdj");
            dic.Add("嶠", "mtdk");
            dic.Add("岆", "mtdy");
            dic.Add("崻", "mtff");
            dic.Add("峼", "mtfk");
            dic.Add("巑", "mtfm");
            dic.Add("崜", "mtgf");
            dic.Add("貹", "mtgg");
            dic.Add("岝", "mthf");
            dic.Add("岞", "mthf");
            dic.Add("嵲", "mths");
            dic.Add("颰", "mtjc");
            dic.Add("颼", "mtjc");
            dic.Add("颳", "mtjd");
            dic.Add("飇", "mtjd");
            dic.Add("颩", "mtje");
            dic.Add("颵", "mtje");
            dic.Add("飂", "mtje");
            dic.Add("颴", "mtjh");
            dic.Add("颹", "mtjh");
            dic.Add("風", "mtji");
            dic.Add("飃", "mtji");
            dic.Add("飉", "mtji");
            dic.Add("峲", "mtjj");
            dic.Add("颲", "mtjj");
            dic.Add("颾", "mtjj");
            dic.Add("飍", "mtjj");
            dic.Add("颭", "mtjk");
            dic.Add("颱", "mtjk");
            dic.Add("飀", "mtjl");
            dic.Add("飅", "mtjl");
            dic.Add("颮", "mtjn");
            dic.Add("颸", "mtjn");
            dic.Add("颷", "mtjo");
            dic.Add("飈", "mtjo");
            dic.Add("颺", "mtjr");
            dic.Add("颬", "mtjt");
            dic.Add("飋", "mtjt");
            dic.Add("颫", "mtjw");
            dic.Add("颶", "mtjw");
            dic.Add("赂", "mtk");
            dic.Add("峉", "mtkf");
            dic.Add("峈", "mtkg");
            dic.Add("賂", "mtkg");
            dic.Add("賉", "mtlg");
            dic.Add("嶶", "mtmt");
            dic.Add("屹", "mtnn");
            dic.Add("嶓", "mtol");
            dic.Add("贬", "mtp");
            dic.Add("貶", "mtpy");
            dic.Add("峨", "mtr");
            dic.Add("峩", "mtrt");
            dic.Add("嵊", "mtu");
            dic.Add("嵙", "mtuf");
            dic.Add("峂", "mtuy");
            dic.Add("巍", "mtv");
            dic.Add("崣", "mtvf");
            dic.Add("嵂", "mtvh");
            dic.Add("嵷", "mtwh");
            dic.Add("嵸", "mtwh");
            dic.Add("败", "mty");
            dic.Add("敗", "mty");
            dic.Add("內", "mtyi");
            dic.Add("赠", "mu");
            dic.Add("賆", "muah");
            dic.Add("嵯", "mud");
            dic.Add("嵳", "muda");
            dic.Add("巃", "mued");
            dic.Add("巄", "mued");
            dic.Add("贚", "mued");
            dic.Add("岦", "muf");
            dic.Add("嵄", "mugd");
            dic.Add("嶬", "mugt");
            dic.Add("巙", "muht");
            dic.Add("嶂", "muj");
            dic.Add("峷", "muj");
            dic.Add("赔", "muk");
            dic.Add("賠", "mukg");
            dic.Add("嵜", "mukh");
            dic.Add("﨑", "mukh");
            dic.Add("嶒", "mulj");
            dic.Add("贈", "mulj");
            dic.Add("剛", "mumj");
            dic.Add("岡", "mumk");
            dic.Add("崹", "muph");
            dic.Add("嵭", "mupy");
            dic.Add("峧", "muqy");
            dic.Add("賋", "muqy");
            dic.Add("嶟", "musf");
            dic.Add("崷", "musg");
            dic.Add("嵃", "mute");
            dic.Add("嵼", "mutg");
            dic.Add("赚", "muv");
            dic.Add("凲", "muvo");
            dic.Add("嵰", "muvo");
            dic.Add("賺", "muvo");
            dic.Add("賹", "muwl");
            dic.Add("巕", "muwv");
            dic.Add("嵫", "mux");
            dic.Add("罔", "muy");
            dic.Add("屶", "mvb");
            dic.Add("峎", "mveu");
            dic.Add("峍", "mvfh");
            dic.Add("嶼", "mvgw");
            dic.Add("贐", "mvhl");
            dic.Add("岧", "mvkf");
            dic.Add("岹", "mvkg");
            dic.Add("崰", "mvlg");
            dic.Add("峮", "mvtk");
            dic.Add("岃", "mvyu");
            dic.Add("屻", "mvyy");
            dic.Add("内", "mw");
            dic.Add("嵡", "mwcn");
            dic.Add("赊", "mwf");
            dic.Add("賒", "mwfi");
            dic.Add("嵛", "mwg");
            dic.Add("崘", "mwga");
            dic.Add("崙", "mwga");
            dic.Add("峑", "mwgf");
            dic.Add("崄", "mwgi");
            dic.Add("崳", "mwgj");
            dic.Add("峆", "mwgk");
            dic.Add("峇", "mwgk");
            dic.Add("嶖", "mwgn");
            dic.Add("嶝", "mwgu");
            dic.Add("嶮", "mwgw");
            dic.Add("峜", "mwhf");
            dic.Add("峳", "mwht");
            dic.Add("岕", "mwjj");
            dic.Add("冏", "mwkd");
            dic.Add("巋", "mwnh");
            dic.Add("嵨", "mwno");
            dic.Add("嶭", "mwnu");
            dic.Add("賖", "mwty");
            dic.Add("岎", "mwvn");
            dic.Add("嶋", "mwvo");
            dic.Add("嶌", "mwvo");
            dic.Add("鳯", "mwvo");
            dic.Add("鵙", "mwvo");
            dic.Add("肉", "mww");
            dic.Add("峪", "mwwk");
            dic.Add("崔", "mwy");
            dic.Add("酅", "mwyb");
            dic.Add("岭", "mwyc");
            dic.Add("岺", "mwyc");
            dic.Add("嵢", "mwyk");
            dic.Add("巂", "mwyk");
            dic.Add("賶", "mwyk");
            dic.Add("嶲", "mwym");
            dic.Add("嶺", "mwym");
            dic.Add("岑", "mwyn");
            dic.Add("岒", "mwyn");
            dic.Add("嶕", "mwyo");
            dic.Add("嶣", "mwyo");
            dic.Add("嶷", "mx");
            dic.Add("巓", "mxhm");
            dic.Add("岪", "mxjj");
            dic.Add("嵹", "mxkj");
            dic.Add("岰", "mxln");
            dic.Add("嵶", "mxuu");
            dic.Add("凡", "my");
            dic.Add("雘", "myac");
            dic.Add("崞", "myb");
            dic.Add("丹", "myd");
            dic.Add("彤", "mye");
            dic.Add("赃", "myf");
            dic.Add("訔", "myf");
            dic.Add("賍", "myfg");
            dic.Add("賘", "myfy");
            dic.Add("峕", "myjf");
            dic.Add("刐", "myjh");
            dic.Add("嵩", "mym");
            dic.Add("巐", "myma");
            dic.Add("嵪", "mymk");
            dic.Add("貥", "mymn");
            dic.Add("赅", "myn");
            dic.Add("峐", "mynw");
            dic.Add("賅", "mynw");
            dic.Add("嵉", "myps");
            dic.Add("崺", "mytb");
            dic.Add("崀", "myve");
            dic.Add("嵻", "myvi");
            dic.Add("嵣", "myvk");
            dic.Add("崒", "mywf");
            dic.Add("崪", "mywf");
            dic.Add("賥", "mywf");
            dic.Add("鴅", "mywo");
            dic.Add("民", "n");
            dic.Add("已", "n");
            dic.Add("恜", "naag");
            dic.Add("悈", "naah");
            dic.Add("愖", "nadn");
            dic.Add("愜", "nadw");
            dic.Add("展", "nae");
            dic.Add("愅", "nafh");
            dic.Add("惬", "nag");
            dic.Add("羾", "nag");
            dic.Add("恇", "nagg");
            dic.Add("慳", "nahf");
            dic.Add("懢", "nahl");
            dic.Add("异", "naj");
            dic.Add("羿", "naj");
            dic.Add("敯", "najc");
            dic.Add("慔", "najd");
            dic.Add("昬", "najf");
            dic.Add("惜", "najg");
            dic.Add("刡", "najh");
            dic.Add("愺", "najh");
            dic.Add("蟁", "najj");
            dic.Add("愝", "najv");
            dic.Add("惐", "nakg");
            dic.Add("慬", "nakg");
            dic.Add("慪", "nakk");
            dic.Add("懄", "nakl");
            dic.Add("懽", "naky");
            dic.Add("懵", "nal");
            dic.Add("懜", "nalq");
            dic.Add("懱", "nalt");
            dic.Add("愥", "namd");
            dic.Add("愩", "namy");
            dic.Add("慲", "namy");
            dic.Add("屉", "nan");
            dic.Add("怇", "nang");
            dic.Add("怈", "nann");
            dic.Add("屟", "nans");
            dic.Add("惵", "nans");
            dic.Add("怴", "nant");
            dic.Add("懞", "nape");
            dic.Add("怄", "naq");
            dic.Add("憯", "naqj");
            dic.Add("憽", "naqn");
            dic.Add("懂", "nat");
            dic.Add("睯", "nath");
            dic.Add("暋", "natj");
            dic.Add("愍", "natn");
            dic.Add("敃", "naty");
            dic.Add("殿", "naw");
            dic.Add("臀", "nawe");
            dic.Add("壂", "nawf");
            dic.Add("鴖", "nawo");
            dic.Add("臋", "naww");
            dic.Add("慌", "nay");
            dic.Add("恾", "nayn");
            dic.Add("敢", "nb");
            dic.Add("孱", "nbb");
            dic.Add("懾", "nbbb");
            dic.Add("慑", "nbc");
            dic.Add("憜", "nbde");
            dic.Add("聼", "nbfn");
            dic.Add("邔", "nbh");
            dic.Add("屈", "nbm");
            dic.Add("鶌", "nbmo");
            dic.Add("忚", "nbn");
            dic.Add("屙", "nbs");
            dic.Add("饏", "nbte");
            dic.Add("憨", "nbtn");
            dic.Add("怪", "nc");
            dic.Add("忬", "ncbh");
            dic.Add("憰", "ncbk");
            dic.Add("惙", "nccc");
            dic.Add("慘", "ncce");
            dic.Add("惨", "ncd");
            dic.Add("悀", "nceh");
            dic.Add("愑", "ncel");
            dic.Add("怿", "ncfh");
            dic.Add("怡", "nck");
            dic.Add("恈", "ncrh");
            dic.Add("悛", "ncw");
            dic.Add("慅", "ncyj");
            dic.Add("居", "nd");
            dic.Add("惰", "nda");
            dic.Add("墯", "ndaf");
            dic.Add("翇", "ndcu");
            dic.Add("恹", "nddy");
            dic.Add("懮", "ndet");
            dic.Add("悵", "ndey");
            dic.Add("屒", "ndfe");
            dic.Add("恗", "ndfn");
            dic.Add("怙", "ndg");
            dic.Add("憾", "ndgn");
            dic.Add("恠", "ndhf");
            dic.Add("懳", "ndhn");
            dic.Add("慽", "ndht");
            dic.Add("剧", "ndj");
            dic.Add("悱", "ndjd");
            dic.Add("屝", "ndjd");
            dic.Add("懨", "ndjd");
            dic.Add("怖", "ndm");
            dic.Add("愐", "ndmd");
            dic.Add("愞", "ndmd");
            dic.Add("頨", "ndmy");
            dic.Add("忧", "ndn");
            dic.Add("恢", "ndo");
            dic.Add("慡", "ndqq");
            dic.Add("憭", "ndui");
            dic.Add("鶋", "ndwo");
            dic.Add("悏", "ndww");
            dic.Add("翜", "ndww");
            dic.Add("忕", "ndy");
            dic.Add("忲", "ndyy");
            dic.Add("懚", "nean");
            dic.Add("愋", "nefc");
            dic.Add("怚", "negg");
            dic.Add("懓", "nept");
            dic.Add("愮", "nerm");
            dic.Add("慆", "nevg");
            dic.Add("慀", "nexd");
            dic.Add("忣", "neyy");
            dic.Add("导", "nf");
            dic.Add("愤", "nfa");
            dic.Add("懴", "nfag");
            dic.Add("憤", "nfam");
            dic.Add("屆", "nfbk");
            dic.Add("层", "nfc");
            dic.Add("忮", "nfc");
            dic.Add("厾", "nfci");
            dic.Add("恸", "nfcl");
            dic.Add("怯", "nfcy");
            dic.Add("忶", "nfcy");
            dic.Add("翄", "nfcy");
            dic.Add("丑", "nfd");
            dic.Add("懦", "nfdj");
            dic.Add("恃", "nff");
            dic.Add("憢", "nffq");
            dic.Add("慎", "nfh");
            dic.Add("忓", "nfh");
            dic.Add("丮", "nfhk");
            dic.Add("慰", "nfi");
            dic.Add("屚", "nfi");
            dic.Add("叞", "nfic");
            dic.Add("褽", "nfie");
            dic.Add("尉", "nfif");
            dic.Add("犚", "nfih");
            dic.Add("螱", "nfij");
            dic.Add("熨", "nfio");
            dic.Add("怽", "nfiy");
            dic.Add("蝨", "nfjj");
            dic.Add("卂", "nfk");
            dic.Add("憉", "nfke");
            dic.Add("懛", "nfkf");
            dic.Add("恄", "nfkg");
            dic.Add("憘", "nfkk");
            dic.Add("懤", "nfnf");
            dic.Add("懗", "nfoo");
            dic.Add("迅", "nfp");
            dic.Add("悖", "nfpb");
            dic.Add("懥", "nfph");
            dic.Add("怃", "nfq");
            dic.Add("忨", "nfqn");
            dic.Add("屠", "nft");
            dic.Add("愭", "nftj");
            dic.Add("鷵", "nfto");
            dic.Add("恅", "nftx");
            dic.Add("悻", "nfuf");
            dic.Add("懎", "nfwk");
            dic.Add("鳵", "nfwo");
            dic.Add("忖", "nfy");
            dic.Add("怀", "ng");
            dic.Add("忳", "ngbn");
            dic.Add("屋", "ngc");
            dic.Add("恎", "ngcf");
            dic.Add("剭", "ngcj");
            dic.Add("刁", "ngd");
            dic.Add("悿", "ngdn");
            dic.Add("情", "nge");
            dic.Add("愽", "ngef");
            dic.Add("悑", "ngey");
            dic.Add("忹", "ngg");
            dic.Add("怔", "ngh");
            dic.Add("恆", "nghg");
            dic.Add("怌", "ngig");
            dic.Add("恒", "ngj");
            dic.Add("慱", "ngjf");
            dic.Add("憓", "ngjn");
            dic.Add("司", "ngk");
            dic.Add("孠", "ngkb");
            dic.Add("悟", "ngkg");
            dic.Add("悚", "ngki");
            dic.Add("愊", "ngkl");
            dic.Add("懒", "ngkm");
            dic.Add("懶", "ngkm");
            dic.Add("覗", "ngkq");
            dic.Add("慒", "ngmj");
            dic.Add("怲", "ngmw");
            dic.Add("慠", "ngqt");
            dic.Add("屍", "ngqx");
            dic.Add("怦", "ngu");
            dic.Add("悽", "ngvv");
            dic.Add("愫", "ngx");
            dic.Add("恞", "ngxw");
            dic.Add("收", "nh");
            dic.Add("懅", "nhae");
            dic.Add("憈", "nhag");
            dic.Add("臦", "nhah");
            dic.Add("臩", "nhaj");
            dic.Add("燛", "nhao");
            dic.Add("郿", "nhbh");
            dic.Add("叏", "nhcu");
            dic.Add("収", "nhcy");
            dic.Add("怶", "nhcy");
            dic.Add("翍", "nhcy");
            dic.Add("眉", "nhd");
            dic.Add("", "nhd");
            dic.Add("戕", "nhda");
            dic.Add("弉", "nhda");
            dic.Add("奘", "nhdd");
            dic.Add("奬", "nhdd");
            dic.Add("牂", "nhdd");
            dic.Add("狀", "nhdd");
            dic.Add("獎", "nhdd");
            dic.Add("爿", "nhde");
            dic.Add("裝", "nhde");
            dic.Add("墏", "nhdf");
            dic.Add("壯", "nhdf");
            dic.Add("將", "nhdf");
            dic.Add("醬", "nhdg");
            dic.Add("牅", "nhdh");
            dic.Add("漿", "nhdi");
            dic.Add("螿", "nhdj");
            dic.Add("牁", "nhdk");
            dic.Add("牄", "nhdk");
            dic.Add("牆", "nhdk");
            dic.Add("焋", "nhdo");
            dic.Add("銺", "nhdq");
            dic.Add("斨", "nhdr");
            dic.Add("槳", "nhds");
            dic.Add("牀", "nhds");
            dic.Add("牃", "nhds");
            dic.Add("妝", "nhdv");
            dic.Add("娤", "nhdv");
            dic.Add("胥", "nhe");
            dic.Add("遐", "nhf");
            dic.Add("叚", "nhfc");
            dic.Add("疎", "nhgi");
            dic.Add("戄", "nhhc");
            dic.Add("懼", "nhhy");
            dic.Add("疋", "nhi");
            dic.Add("蛋", "nhj");
            dic.Add("疍", "nhjg");
            dic.Add("悼", "nhjh");
            dic.Add("丩", "nhk");
            dic.Add("郼", "nhkb");
            dic.Add("韕", "nhkb");
            dic.Add("韍", "nhkc");
            dic.Add("韒", "nhke");
            dic.Add("韔", "nhke");
            dic.Add("韛", "nhke");
            dic.Add("韚", "nhkf");
            dic.Add("韝", "nhkf");
            dic.Add("韟", "nhkf");
            dic.Add("韠", "nhkf");
            dic.Add("韡", "nhkf");
            dic.Add("怗", "nhkg");
            dic.Add("韋", "nhkh");
            dic.Add("韣", "nhkj");
            dic.Add("韐", "nhkk");
            dic.Add("韗", "nhkl");
            dic.Add("韞", "nhkl");
            dic.Add("韥", "nhkm");
            dic.Add("韢", "nhkn");
            dic.Add("違", "nhkp");
            dic.Add("韎", "nhks");
            dic.Add("韖", "nhks");
            dic.Add("韘", "nhks");
            dic.Add("韤", "nhkt");
            dic.Add("韜", "nhkv");
            dic.Add("韌", "nhky");
            dic.Add("鹛", "nhq");
            dic.Add("悓", "nhqn");
            dic.Add("", "nhty");
            dic.Add("舝", "nhvh");
            dic.Add("惧", "nhw");
            dic.Add("鶥", "nhwo");
            dic.Add("疏", "nhy");
            dic.Add("悄", "ni");
            dic.Add("屑", "nied");
            dic.Add("尿", "nii");
            dic.Add("氹", "nii");
            dic.Add("劚", "nilj");
            dic.Add("屬", "nilj");
            dic.Add("斸", "nilr");
            dic.Add("惝", "nim");
            dic.Add("憆", "nipf");
            dic.Add("戃", "nipo");
            dic.Add("恍", "niq");
            dic.Add("悩", "niqb");
            dic.Add("恌", "niqn");
            dic.Add("犀", "nir");
            dic.Add("遲", "nirp");
            dic.Add("慢", "nj");
            dic.Add("懪", "njai");
            dic.Add("悭", "njc");
            dic.Add("悍", "njf");
            dic.Add("悝", "njfg");
            dic.Add("怛", "njg");
            dic.Add("惿", "njgh");
            dic.Add("翨", "njgh");
            dic.Add("愓", "njgr");
            dic.Add("丱", "njhg");
            dic.Add("愰", "njiq");
            dic.Add("愠", "njlg");
            dic.Add("惕", "njq");
            dic.Add("愒", "njqn");
            dic.Add("惈", "njsy");
            dic.Add("惺", "njt");
            dic.Add("惃", "njxx");
            dic.Add("憬", "njy");
            dic.Add("避", "nk");
            dic.Add("悒", "nkc");
            dic.Add("悁", "nkeg");
            dic.Add("吢", "nkf");
            dic.Add("悮", "nkgd");
            dic.Add("悜", "nkgg");
            dic.Add("慺", "nkgv");
            dic.Add("屢", "nkgv");
            dic.Add("忡", "nkh");
            dic.Add("翀", "nkhh");
            dic.Add("愦", "nkhm");
            dic.Add("憒", "nkhm");
            dic.Add("愕", "nkk");
            dic.Add("憚", "nkkf");
            dic.Add("懆", "nkks");
            dic.Add("屌", "nkmh");
            dic.Add("愪", "nkmy");
            dic.Add("悞", "nknd");
            dic.Add("怳", "nkqn");
            dic.Add("辟", "nku");
            dic.Add("譬", "nku");
            dic.Add("嬖", "nku");
            dic.Add("孹", "nkub");
            dic.Add("礕", "nkud");
            dic.Add("臂", "nkue");
            dic.Add("襞", "nkue");
            dic.Add("壁", "nkuf");
            dic.Add("", "nkug");
            dic.Add("幦", "nkuh");
            dic.Add("躄", "nkuh");
            dic.Add("繴", "nkui");
            dic.Add("甓", "nkun");
            dic.Add("憵", "nkun");
            dic.Add("糪", "nkuo");
            dic.Add("鷿", "nkuo");
            dic.Add("鸊", "nkuo");
            dic.Add("鐾", "nkuq");
            dic.Add("擘", "nkur");
            dic.Add("檗", "nkus");
            dic.Add("劈", "nkuv");
            dic.Add("鼊", "nkuv");
            dic.Add("璧", "nkuy");
            dic.Add("怾", "nkwy");
            dic.Add("惭", "nl");
            dic.Add("翼", "nla");
            dic.Add("慖", "nlag");
            dic.Add("乪", "nld");
            dic.Add("屇", "nld");
            dic.Add("懌", "nlff");
            dic.Add("怬", "nlg");
            dic.Add("愄", "nlge");
            dic.Add("懁", "nlge");
            dic.Add("恛", "nlkg");
            dic.Add("愶", "nlle");
            dic.Add("恊", "nlll");
            dic.Add("忇", "nln");
            dic.Add("愢", "nlny");
            dic.Add("慩", "nlpy");
            dic.Add("翴", "nlpy");
            dic.Add("慚", "nlrh");
            dic.Add("悃", "nls");
            dic.Add("慍", "nlwl");
            dic.Add("愣", "nly");
            dic.Add("届", "nm");
            dic.Add("憹", "nmae");
            dic.Add("惴", "nmdj");
            dic.Add("怏", "nmdy");
            dic.Add("愲", "nmeg");
            dic.Add("惆", "nmf");
            dic.Add("恫", "nmg");
            dic.Add("怞", "nmg");
            dic.Add("愷", "nmgu");
            dic.Add("憴", "nmgv");
            dic.Add("刷", "nmh");
            dic.Add("屃", "nmi");
            dic.Add("屓", "nmi");
            dic.Add("恻", "nmj");
            dic.Add("惻", "nmjh");
            dic.Add("屭", "nmmm");
            dic.Add("恺", "nmn");
            dic.Add("惘", "nmu");
            dic.Add("凥", "nmv");
            dic.Add("慛", "nmwy");
            dic.Add("忛", "nmyy");
            dic.Add("忆", "nn");
            dic.Add("巽", "nna");
            dic.Add("惽", "nnaj");
            dic.Add("怋", "nnan");
            dic.Add("選", "nnap");
            dic.Add("忸", "nnf");
            dic.Add("己", "nng");
            dic.Add("巳", "nng");
            dic.Add("尸", "nngt");
            dic.Add("巺", "nngw");
            dic.Add("书", "nnh");
            dic.Add("愇", "nnhh");
            dic.Add("屫", "nnhk");
            dic.Add("局", "nnk");
            dic.Add("乙", "nnl");
            dic.Add("乚", "nnll");
            dic.Add("乛", "nnll");
            dic.Add("", "nnll");
            dic.Add("", "nnll");
            dic.Add("忋", "nnn");
            dic.Add("繠", "nnni");
            dic.Add("橤", "nnns");
            dic.Add("惢", "nnnu");
            dic.Add("慴", "nnrg");
            dic.Add("怭", "nntt");
            dic.Add("忌", "nnu");
            dic.Add("乜", "nnv");
            dic.Add("快", "nnw");
            dic.Add("憀", "nnwe");
            dic.Add("鵋", "nnwo");
            dic.Add("怩", "nnx");
            dic.Add("羽", "nny");
            dic.Add("屡", "no");
            dic.Add("屎", "noi");
            dic.Add("憦", "nool");
            dic.Add("惔", "nooy");
            dic.Add("憐", "noqh");
            dic.Add("忱", "np");
            dic.Add("屪", "npdi");
            dic.Add("迉", "npe");
            dic.Add("悰", "npfi");
            dic.Add("愃", "npgg");
            dic.Add("慏", "npju");
            dic.Add("恽", "npl");
            dic.Add("惲", "nplh");
            dic.Add("翚", "nplj");
            dic.Add("翬", "nplj");
            dic.Add("悺", "npnn");
            dic.Add("懧", "npns");
            dic.Add("惋", "npqb");
            dic.Add("愘", "nptk");
            dic.Add("悾", "npwa");
            dic.Add("屄", "npwi");
            dic.Add("愹", "npwk");
            dic.Add("懈", "nq");
            dic.Add("惛", "nqaj");
            dic.Add("忯", "nqan");
            dic.Add("怟", "nqay");
            dic.Add("忷", "nqbh");
            dic.Add("惾", "nqbt");
            dic.Add("翪", "nqbt");
            dic.Add("", "nqbt");
            dic.Add("恑", "nqdb");
            dic.Add("恡", "nqdc");
            dic.Add("悕", "nqdh");
            dic.Add("憺", "nqdy");
            dic.Add("惍", "nqg");
            dic.Add("恂", "nqj");
            dic.Add("惸", "nqjb");
            dic.Add("怐", "nqkg");
            dic.Add("翑", "nqkg");
            dic.Add("悗", "nqkq");
            dic.Add("愌", "nqmd");
            dic.Add("怉", "nqnn");
            dic.Add("恟", "nqqb");
            dic.Add("恀", "nqqy");
            dic.Add("惚", "nqr");
            dic.Add("愡", "nqrn");
            dic.Add("惂", "nqvg");
            dic.Add("", "nqvg");
            dic.Add("忺", "nqwy");
            dic.Add("鸤", "nqyg");
            dic.Add("懰", "nqyj");
            dic.Add("怕", "nr");
            dic.Add("習", "nrf");
            dic.Add("翫", "nrfq");
            dic.Add("惶", "nrgg");
            dic.Add("忻", "nrh");
            dic.Add("憮", "nrlo");
            dic.Add("飁", "nrmj");
            dic.Add("忾", "nrn");
            dic.Add("愾", "nrno");
            dic.Add("愧", "nrq");
            dic.Add("惞", "nrqw");
            dic.Add("懫", "nrrm");
            dic.Add("怢", "nrwy");
            dic.Add("翐", "nrwy");
            dic.Add("憿", "nryt");
            dic.Add("怵", "ns");
            dic.Add("慓", "nsfi");
            dic.Add("恓", "nsg");
            dic.Add("忊", "nsh");
            dic.Add("杘", "nsi");
            dic.Add("憛", "nsjh");
            dic.Add("憟", "nsoy");
            dic.Add("憷", "nss");
            dic.Add("惏", "nssy");
            dic.Add("慄", "nssy");
            dic.Add("必", "nt");
            dic.Add("怅", "nta");
            dic.Add("屜", "ntan");
            dic.Add("屧", "ntas");
            dic.Add("悸", "ntb");
            dic.Add("邲", "ntbh");
            dic.Add("发", "ntc");
            dic.Add("恬", "ntd");
            dic.Add("憍", "ntdk");
            dic.Add("尾", "ntf");
            dic.Add("忤", "ntf");
            dic.Add("屘", "ntfb");
            dic.Add("屐", "ntfc");
            dic.Add("屗", "ntff");
            dic.Add("屛", "ntff");
            dic.Add("忏", "ntfh");
            dic.Add("悎", "ntfk");
            dic.Add("毣", "ntfn");
            dic.Add("慥", "ntfp");
            dic.Add("性", "ntg");
            dic.Add("憡", "ntgi");
            dic.Add("慟", "ntgl");
            dic.Add("怍", "nth");
            dic.Add("屣", "nthh");
            dic.Add("覕", "nthq");
            dic.Add("虱", "ntj");
            dic.Add("悧", "ntjh");
            dic.Add("慯", "ntjr");
            dic.Add("愎", "ntjt");
            dic.Add("属", "ntk");
            dic.Add("恪", "ntkg");
            dic.Add("屨", "ntkv");
            dic.Add("恤", "ntl");
            dic.Add("憁", "ntln");
            dic.Add("懊", "ntm");
            dic.Add("恦", "ntmk");
            dic.Add("忔", "ntnn");
            dic.Add("愀", "nto");
            dic.Add("憣", "ntol");
            dic.Add("屦", "ntov");
            dic.Add("履", "ntt");
            dic.Add("屩", "nttk");
            dic.Add("鴓", "ntwo");
            dic.Add("悔", "ntx");
            dic.Add("改", "nty");
            dic.Add("攺", "nty");
            dic.Add("习", "nu");
            dic.Add("屏", "nua");
            dic.Add("恲", "nuah");
            dic.Add("惓", "nudb");
            dic.Add("羼", "nudd");
            dic.Add("懩", "nude");
            dic.Add("慻", "nudh");
            dic.Add("遅", "nudp");
            dic.Add("买", "nudu");
            dic.Add("憪", "nueg");
            dic.Add("翌", "nuf");
            dic.Add("怑", "nufh");
            dic.Add("翋", "nug");
            dic.Add("飞", "nui");
            dic.Add("惮", "nuj");
            dic.Add("憧", "nuj");
            dic.Add("愔", "nujg");
            dic.Add("慞", "nujh");
            dic.Add("憶", "nujn");
            dic.Add("悦", "nuk");
            dic.Add("屖", "nuk");
            dic.Add("憎", "nul");
            dic.Add("層", "nulj");
            dic.Add("遟", "nupk");
            dic.Add("恔", "nuqy");
            dic.Add("愱", "nutd");
            dic.Add("飛", "nuth");
            dic.Add("飝", "nuth");
            dic.Add("慊", "nuv");
            dic.Add("翣", "nuvf");
            dic.Add("悌", "nux");
            dic.Add("懻", "nuxw");
            dic.Add("悯", "nuy");
            dic.Add("憫", "nuyy");
            dic.Add("恨", "nv");
            dic.Add("憳", "nvaf");
            dic.Add("慨", "nvc");
            dic.Add("怓", "nvcy");
            dic.Add("忰", "nvfh");
            dic.Add("翆", "nvfj");
            dic.Add("妀", "nvg");
            dic.Add("懙", "nvgw");
            dic.Add("怊", "nvk");
            dic.Add("忉", "nvn");
            dic.Add("惱", "nvtq");
            dic.Add("尻", "nvv");
            dic.Add("愉", "nw");
            dic.Add("怆", "nwb");
            dic.Add("忪", "nwc");
            dic.Add("慃", "nwcn");
            dic.Add("恱", "nwcq");
            dic.Add("戮", "nwe");
            dic.Add("鄝", "nweb");
            dic.Add("鹨", "nweg");
            dic.Add("剹", "nwej");
            dic.Add("勠", "nwel");
            dic.Add("顟", "nwem");
            dic.Add("鷚", "nweo");
            dic.Add("翏", "nwer");
            dic.Add("雡", "nwey");
            dic.Add("憏", "nwfi");
            dic.Add("惀", "nwga");
            dic.Add("恮", "nwgg");
            dic.Add("懀", "nwgj");
            dic.Add("恰", "nwgk");
            dic.Add("憕", "nwgu");
            dic.Add("憸", "nwgw");
            dic.Add("乆", "nwi");
            dic.Add("夬", "nwi");
            dic.Add("刔", "nwjh");
            dic.Add("忦", "nwjh");
            dic.Add("悅", "nwkq");
            dic.Add("翭", "nwnd");
            dic.Add("恘", "nwsy");
            dic.Add("悇", "nwty");
            dic.Add("翂", "nwvn");
            dic.Add("翵", "nwvo");
            dic.Add("鳲", "nwvo");
            dic.Add("懺", "nwwg");
            dic.Add("鴂", "nwwo");
            dic.Add("惟", "nwy");
            dic.Add("戳", "nwya");
            dic.Add("怜", "nwyc");
            dic.Add("愯", "nwyc");
            dic.Add("翟", "nwyf");
            dic.Add("愴", "nwyk");
            dic.Add("懏", "nwym");
            dic.Add("忴", "nwyn");
            dic.Add("惗", "nwyn");
            dic.Add("憔", "nwyo");
            dic.Add("鸐", "nwyo");
            dic.Add("尼", "nx");
            dic.Add("惯", "nxf");
            dic.Add("慣", "nxfm");
            dic.Add("愼", "nxhw");
            dic.Add("怫", "nxj");
            dic.Add("恉", "nxjg");
            dic.Add("怮", "nxln");
            dic.Add("迡", "nxpv");
            dic.Add("懝", "nxth");
            dic.Add("愵", "nxuu");
            dic.Add("屁", "nxx");
            dic.Add("悂", "nxxf");
            dic.Add("惤", "nxyx");
            dic.Add("心", "ny");
            dic.Add("懭", "nyaw");
            dic.Add("恼", "nyb");
            dic.Add("惇", "nybg");
            dic.Add("悙", "nybh");
            dic.Add("憞", "nybt");
            dic.Add("惦", "nyh");
            dic.Add("忭", "nyh");
            dic.Add("忄", "nyhy");
            dic.Add("尺", "nyi");
            dic.Add("乄", "nyi");
            dic.Add("憱", "nyin");
            dic.Add("惊", "nyiy");
            dic.Add("翞", "nyiy");
            dic.Add("昼", "nyj");
            dic.Add("懠", "nyjg");
            dic.Add("咫", "nyk");
            dic.Add("懹", "nyke");
            dic.Add("悋", "nykg");
            dic.Add("懔", "nyl");
            dic.Add("懐", "nyle");
            dic.Add("懷", "nyle");
            dic.Add("憻", "nylg");
            dic.Add("懍", "nylt");
            dic.Add("翯", "nymk");
            dic.Add("忼", "nymn");
            dic.Add("惼", "nyna");
            dic.Add("悷", "nynd");
            dic.Add("怺", "nyni");
            dic.Add("忙", "nynn");
            dic.Add("迟", "nyp");
            dic.Add("懡", "nysc");
            dic.Add("戂", "nysd");
            dic.Add("尽", "nyu");
            dic.Add("慷", "nyv");
            dic.Add("悢", "nyve");
            dic.Add("慵", "nyvh");
            dic.Add("悴", "nyw");
            dic.Add("翠", "nywf");
            dic.Add("慉", "nyxl");
            dic.Add("怰", "nyxy");
            dic.Add("忟", "nyy");
            dic.Add("为", "o");
            dic.Add("火", "o");
            dic.Add("煤", "oa");
            dic.Add("烒", "oaag");
            dic.Add("煁", "oadn");
            dic.Add("糂", "oadn");
            dic.Add("燍", "oadr");
            dic.Add("粸", "oadw");
            dic.Add("糤", "oaet");
            dic.Add("粓", "oafg");
            dic.Add("煂", "oafh");
            dic.Add("灴", "oag");
            dic.Add("燁", "oagf");
            dic.Add("熞", "oahf");
            dic.Add("烥", "oahh");
            dic.Add("爁", "oahl");
            dic.Add("糮", "oahl");
            dic.Add("爦", "oahq");
            dic.Add("灷", "oaj");
            dic.Add("糢", "oajd");
            dic.Add("焟", "oajg");
            dic.Add("爡", "oajj");
            dic.Add("燤", "oajy");
            dic.Add("熰", "oakk");
            dic.Add("熯", "oakw");
            dic.Add("爟", "oaky");
            dic.Add("煐", "oamd");
            dic.Add("焫", "oamw");
            dic.Add("熿", "oamw");
            dic.Add("熕", "oamy");
            dic.Add("炬", "oan");
            dic.Add("糚", "oanf");
            dic.Add("粔", "oang");
            dic.Add("煠", "oans");
            dic.Add("炼", "oanw");
            dic.Add("熸", "oaqj");
            dic.Add("糣", "oaqj");
            dic.Add("燪", "oaqn");
            dic.Add("烵", "oaqy");
            dic.Add("烧", "oat");
            dic.Add("糒", "oate");
            dic.Add("爤", "oaui");
            dic.Add("糷", "oaui");
            dic.Add("烘", "oaw");
            dic.Add("爑", "oawo");
            dic.Add("粪", "oawu");
            dic.Add("烡", "oawu");
            dic.Add("糀", "oawx");
            dic.Add("粠", "oawy");
            dic.Add("籽", "ob");
            dic.Add("邩", "obh");
            dic.Add("炪", "obmh");
            dic.Add("灺", "obn");
            dic.Add("烃", "oc");
            dic.Add("糅", "ocb");
            dic.Add("燏", "ocbk");
            dic.Add("煣", "ocbs");
            dic.Add("糝", "occe");
            dic.Add("糁", "ocd");
            dic.Add("熥", "ocep");
            dic.Add("炲", "ockg");
            dic.Add("粑", "ocn");
            dic.Add("焌", "ocwt");
            dic.Add("糔", "ocyj");
            dic.Add("类", "od");
            dic.Add("爄", "oday");
            dic.Add("糲", "oday");
            dic.Add("炦", "odcy");
            dic.Add("粝", "odd");
            dic.Add("類", "oddm");
            dic.Add("糊", "ode");
            dic.Add("煳", "ode");
            dic.Add("烠", "odeg");
            dic.Add("粻", "odey");
            dic.Add("煃", "odff");
            dic.Add("炻", "odg");
            dic.Add("煘", "odgt");
            dic.Add("炐", "odhh");
            dic.Add("糎", "odjf");
            dic.Add("粨", "odjg");
            dic.Add("烦", "odm");
            dic.Add("煗", "odmd");
            dic.Add("糆", "odmd");
            dic.Add("粫", "odmj");
            dic.Add("糥", "odmj");
            dic.Add("煩", "odmy");
            dic.Add("頪", "odmy");
            dic.Add("烣", "odoy");
            dic.Add("爏", "odth");
            dic.Add("燎", "odui");
            dic.Add("粀", "odyy");
            dic.Add("粏", "odyy");
            dic.Add("粗", "oe");
            dic.Add("烰", "oebg");
            dic.Add("粰", "oebg");
            dic.Add("焩", "oeeg");
            dic.Add("煖", "oefc");
            dic.Add("爝", "oel");
            dic.Add("燰", "oept");
            dic.Add("熎", "oerm");
            dic.Add("熖", "oevg");
            dic.Add("烼", "oey");
            dic.Add("灶", "of");
            dic.Add("燌", "ofam");
            dic.Add("焼", "ofaq");
            dic.Add("熆", "ofcl");
            dic.Add("糯", "ofd");
            dic.Add("燸", "ofdj");
            dic.Add("烓", "offg");
            dic.Add("燒", "offq");
            dic.Add("籵", "ofh");
            dic.Add("煹", "ofjf");
            dic.Add("熺", "ofkk");
            dic.Add("糦", "ofkk");
            dic.Add("爧", "ofkw");
            dic.Add("煵", "ofmf");
            dic.Add("炜", "ofn");
            dic.Add("燽", "ofnf");
            dic.Add("爀", "ofoo");
            dic.Add("焃", "ofoy");
            dic.Add("烤", "oft");
            dic.Add("粩", "oftx");
            dic.Add("燵", "ofup");
            dic.Add("燯", "ofwc");
            dic.Add("籿", "ofy");
            dic.Add("业", "og");
            dic.Add("邺", "ogb");
            dic.Add("炖", "ogbn");
            dic.Add("精", "oge");
            dic.Add("煿", "ogef");
            dic.Add("糐", "ogef");
            dic.Add("烳", "ogey");
            dic.Add("炡", "oghg");
            dic.Add("炋", "ogiy");
            dic.Add("粳", "ogj");
            dic.Add("烜", "ogjg");
            dic.Add("焐", "ogk");
            dic.Add("煏", "ogkl");
            dic.Add("煉", "ogli");
            dic.Add("炳", "ogm");
            dic.Add("糟", "ogmj");
            dic.Add("粖", "ogsy");
            dic.Add("凿", "ogu");
            dic.Add("鄴", "ogub");
            dic.Add("黻", "oguc");
            dic.Add("叢", "oguc");
            dic.Add("丵", "oguf");
            dic.Add("對", "oguf");
            dic.Add("黹", "ogui");
            dic.Add("懟", "ogun");
            dic.Add("糳", "oguo");
            dic.Add("鸈", "oguo");
            dic.Add("鑿", "oguq");
            dic.Add("黺", "oguv");
            dic.Add("業", "oguw");
            dic.Add("黼", "oguy");
            dic.Add("菐", "oguy");
            dic.Add("烴", "ogva");
            dic.Add("彂", "ogxd");
            dic.Add("粘", "oh");
            dic.Add("爐", "ohal");
            dic.Add("爈", "ohan");
            dic.Add("爠", "ohhy");
            dic.Add("焯", "ohj");
            dic.Add("炶", "ohkg");
            dic.Add("爘", "ohqe");
            dic.Add("粯", "ohqn");
            dic.Add("燦", "ohqo");
            dic.Add("炒", "oi");
            dic.Add("焇", "oieg");
            dic.Add("糛", "oipf");
            dic.Add("爣", "oipo");
            dic.Add("烑", "oiqn");
            dic.Add("粆", "oitt");
            dic.Add("熦", "oiwy");
            dic.Add("烛", "oj");
            dic.Add("爆", "oja");
            dic.Add("熚", "ojaf");
            dic.Add("爗", "ojaf");
            dic.Add("熶", "ojbc");
            dic.Add("焨", "ojeg");
            dic.Add("焊", "ojf");
            dic.Add("粴", "ojfg");
            dic.Add("糧", "ojgf");
            dic.Add("炟", "ojgg");
            dic.Add("煶", "ojgh");
            dic.Add("煬", "ojgr");
            dic.Add("糃", "ojgr");
            dic.Add("灲", "ojh");
            dic.Add("熀", "ojiq");
            dic.Add("焻", "ojjg");
            dic.Add("爞", "ojjj");
            dic.Add("熳", "ojl");
            dic.Add("煴", "ojlg");
            dic.Add("焬", "ojqr");
            dic.Add("粿", "ojsy");
            dic.Add("焺", "ojta");
            dic.Add("煋", "ojtg");
            dic.Add("煜", "oju");
            dic.Add("燳", "ojvo");
            dic.Add("焜", "ojxx");
            dic.Add("燝", "ojyi");
            dic.Add("炽", "ok");
            dic.Add("焆", "okeg");
            dic.Add("熡", "okgv");
            dic.Add("燥", "okk");
            dic.Add("燀", "okkf");
            dic.Add("焒", "okkg");
            dic.Add("煰", "okkk");
            dic.Add("熉", "okmy");
            dic.Add("炾", "okqn");
            dic.Add("烟", "ol");
            dic.Add("熼", "olaw");
            dic.Add("糞", "olaw");
            dic.Add("煾", "oldn");
            dic.Add("煟", "oleg");
            dic.Add("畨", "olf");
            dic.Add("燡", "olff");
            dic.Add("爅", "olff");
            dic.Add("糬", "olfj");
            dic.Add("煨", "olg");
            dic.Add("畑", "olg");
            dic.Add("糫", "olge");
            dic.Add("糰", "olgf");
            dic.Add("炠", "olh");
            dic.Add("熁", "olle");
            dic.Add("燲", "ollm");
            dic.Add("燭", "olqj");
            dic.Add("焑", "olsy");
            dic.Add("熅", "olwl");
            dic.Add("灿", "om");
            dic.Add("燶", "omae");
            dic.Add("粬", "omag");
            dic.Add("炈", "omcy");
            dic.Add("煓", "omdj");
            dic.Add("炴", "omdy");
            dic.Add("粙", "omg");
            dic.Add("烔", "omgk");
            dic.Add("粡", "omgk");
            dic.Add("籼", "omh");
            dic.Add("熴", "omjx");
            dic.Add("炯", "omk");
            dic.Add("粣", "ommg");
            dic.Add("籶", "omn");
            dic.Add("煱", "omnk");
            dic.Add("煈", "omtj");
            dic.Add("焵", "omum");
            dic.Add("焹", "omun");
            dic.Add("烱", "omwk");
            dic.Add("熣", "omwy");
            dic.Add("烿", "omye");
            dic.Add("断", "on");
            dic.Add("煀", "onbm");
            dic.Add("炄", "onfg");
            dic.Add("粈", "onfg");
            dic.Add("籸", "onfh");
            dic.Add("糈", "onh");
            dic.Add("煆", "onhc");
            dic.Add("煝", "onhg");
            dic.Add("煒", "onhh");
            dic.Add("糏", "onie");
            dic.Add("爥", "onij");
            dic.Add("焗", "onnk");
            dic.Add("熠", "onrg");
            dic.Add("炀", "onrt");
            dic.Add("熤", "onug");
            dic.Add("炔", "onw");
            dic.Add("熮", "onwe");
            dic.Add("燿", "onwy");
            dic.Add("烬", "ony");
            dic.Add("粎", "onyy");
            dic.Add("炎", "oo");
            dic.Add("郯", "oob");
            dic.Add("糭", "oobt");
            dic.Add("顃", "oodm");
            dic.Add("烾", "ooff");
            dic.Add("爜", "oogc");
            dic.Add("敥", "oohc");
            dic.Add("煔", "oohk");
            dic.Add("覢", "oohq");
            dic.Add("剡", "ooj");
            dic.Add("飊", "oooj");
            dic.Add("燚", "oooo");
            dic.Add("燊", "ooos");
            dic.Add("爃", "ooos");
            dic.Add("焱", "ooou");
            dic.Add("歘", "ooow");
            dic.Add("", "oopb");
            dic.Add("膋", "oope");
            dic.Add("褮", "oope");
            dic.Add("塋", "oopf");
            dic.Add("煢", "oopf");
            dic.Add("醟", "oopg");
            dic.Add("犖", "ooph");
            dic.Add("滎", "oopi");
            dic.Add("禜", "oopi");
            dic.Add("縈", "oopi");
            dic.Add("螢", "oopj");
            dic.Add("營", "oopk");
            dic.Add("勞", "oopl");
            dic.Add("嵤", "oopm");
            dic.Add("焭", "oopm");
            dic.Add("罃", "oopm");
            dic.Add("憥", "oopn");
            dic.Add("甇", "oopn");
            dic.Add("熒", "oopo");
            dic.Add("鶯", "oopo");
            dic.Add("覮", "oopq");
            dic.Add("鎣", "oopq");
            dic.Add("榮", "oops");
            dic.Add("檾", "oops");
            dic.Add("嫈", "oopv");
            dic.Add("瑩", "oopy");
            dic.Add("謍", "oopy");
            dic.Add("燐", "ooqh");
            dic.Add("欻", "ooqw");
            dic.Add("鶑", "oowo");
            dic.Add("炏", "ooy");
            dic.Add("顲", "ooym");
            dic.Add("迷", "op");
            dic.Add("爎", "opdi");
            dic.Add("糘", "opey");
            dic.Add("烷", "opf");
            dic.Add("粽", "opfi");
            dic.Add("煊", "opg");
            dic.Add("熐", "opju");
            dic.Add("熍", "opkk");
            dic.Add("煇", "oplh");
            dic.Add("焥", "opqb");
            dic.Add("烢", "opta");
            dic.Add("熔", "opw");
            dic.Add("焢", "opwa");
            dic.Add("焪", "opwx");
            dic.Add("炨", "opxn");
            dic.Add("炮", "oq");
            dic.Add("遴", "oqa");
            dic.Add("粼", "oqab");
            dic.Add("鄰", "oqab");
            dic.Add("粦", "oqah");
            dic.Add("焝", "oqaj");
            dic.Add("亃", "oqan");
            dic.Add("甐", "oqan");
            dic.Add("翷", "oqan");
            dic.Add("斴", "oqar");
            dic.Add("灮", "oqb");
            dic.Add("煼", "oqbt");
            dic.Add("糉", "oqbt");
            dic.Add("烯", "oqd");
            dic.Add("燃", "oqdo");
            dic.Add("焔", "oqhj");
            dic.Add("烁", "oqi");
            dic.Add("焕", "oqm");
            dic.Add("煥", "oqmd");
            dic.Add("粷", "oqoy");
            dic.Add("粅", "oqrt");
            dic.Add("焰", "oqv");
            dic.Add("炊", "oqw");
            dic.Add("灼", "oqy");
            dic.Add("熘", "oqyl");
            dic.Add("煌", "or");
            dic.Add("炍", "orcy");
            dic.Add("粄", "orcy");
            dic.Add("粕", "org");
            dic.Add("炘", "orh");
            dic.Add("熂", "orno");
            dic.Add("焮", "orqw");
            dic.Add("焷", "ortf");
            dic.Add("粺", "ortf");
            dic.Add("燩", "oryt");
            dic.Add("灯", "os");
            dic.Add("煙", "osfg");
            dic.Add("熛", "osfi");
            dic.Add("粞", "osg");
            dic.Add("烞", "oshy");
            dic.Add("燂", "osjh");
            dic.Add("炣", "oskg");
            dic.Add("爩", "osre");
            dic.Add("炑", "osy");
            dic.Add("炢", "osyy");
            dic.Add("烽", "ot");
            dic.Add("灹", "otan");
            dic.Add("籷", "otan");
            dic.Add("炧", "otbn");
            dic.Add("粚", "otbn");
            dic.Add("燆", "otdk");
            dic.Add("熢", "otdp");
            dic.Add("烐", "otey");
            dic.Add("糙", "otf");
            dic.Add("烆", "otfh");
            dic.Add("粁", "otfh");
            dic.Add("焅", "otfk");
            dic.Add("粍", "otfn");
            dic.Add("烶", "otfp");
            dic.Add("烍", "otfq");
            dic.Add("煄", "otgf");
            dic.Add("燻", "otgo");
            dic.Add("爋", "otgo");
            dic.Add("炸", "oth");
            dic.Add("糗", "othd");
            dic.Add("糌", "othj");
            dic.Add("熄", "othn");
            dic.Add("烻", "othp");
            dic.Add("烙", "otk");
            dic.Add("烅", "otlg");
            dic.Add("熜", "otln");
            dic.Add("燠", "otm");
            dic.Add("炿", "otmy");
            dic.Add("籺", "otnn");
            dic.Add("燔", "oto");
            dic.Add("煍", "otoy");
            dic.Add("熪", "otqq");
            dic.Add("烀", "otu");
            dic.Add("炵", "otuy");
            dic.Add("烸", "otxu");
            dic.Add("敉", "oty");
            dic.Add("炇", "oty");
            dic.Add("秌", "oty");
            dic.Add("料", "ou");
            dic.Add("熾", "ouaj");
            dic.Add("烊", "oud");
            dic.Add("烪", "oudy");
            dic.Add("燧", "oue");
            dic.Add("爖", "oued");
            dic.Add("燗", "oueg");
            dic.Add("糋", "ouej");
            dic.Add("煫", "ouey");
            dic.Add("烂", "oufg");
            dic.Add("炓", "oufh");
            dic.Add("粒", "oug");
            dic.Add("爛", "ougi");
            dic.Add("糕", "ougo");
            dic.Add("燨", "ougt");
            dic.Add("爔", "ougt");
            dic.Add("燑", "oujf");
            dic.Add("燱", "oujn");
            dic.Add("糡", "oujq");
            dic.Add("焙", "ouk");
            dic.Add("熷", "oulj");
            dic.Add("熵", "oum");
            dic.Add("焖", "oun");
            dic.Add("燜", "ouny");
            dic.Add("爓", "ouqv");
            dic.Add("烄", "ouqy");
            dic.Add("燇", "ousf");
            dic.Add("煪", "ousg");
            dic.Add("熑", "ouvo");
            dic.Add("熌", "ouwy");
            dic.Add("糍", "oux");
            dic.Add("焍", "ouxt");
            dic.Add("燘", "ouyy");
            dic.Add("娄", "ov");
            dic.Add("燬", "ovac");
            dic.Add("燖", "ovaf");
            dic.Add("煺", "ove");
            dic.Add("粋", "ovfh");
            dic.Add("熽", "ovfj");
            dic.Add("煡", "ovfp");
            dic.Add("籹", "ovg");
            dic.Add("燼", "ovhl");
            dic.Add("粶", "oviy");
            dic.Add("炤", "ovkg");
            dic.Add("爉", "ovln");
            dic.Add("灱", "ovn");
            dic.Add("数", "ovt");
            dic.Add("籾", "ovyy");
            dic.Add("粉", "ow");
            dic.Add("炝", "owb");
            dic.Add("焧", "owcn");
            dic.Add("炂", "owcy");
            dic.Add("煅", "owd");
            dic.Add("烩", "owf");
            dic.Add("爚", "owga");
            dic.Add("烇", "owgg");
            dic.Add("燴", "owgj");
            dic.Add("糩", "owgj");
            dic.Add("烚", "owgk");
            dic.Add("粭", "owgk");
            dic.Add("熻", "owgn");
            dic.Add("燈", "owgu");
            dic.Add("炌", "owjh");
            dic.Add("糇", "own");
            dic.Add("熓", "owno");
            dic.Add("烌", "owsy");
            dic.Add("焀", "owwk");
            dic.Add("烨", "owx");
            dic.Add("炛", "owxb");
            dic.Add("焓", "owy");
            dic.Add("炩", "owyc");
            dic.Add("焳", "owyg");
            dic.Add("熗", "owyk");
            dic.Add("焾", "owyn");
            dic.Add("燋", "owyo");
            dic.Add("糨", "ox");
            dic.Add("粌", "oxhh");
            dic.Add("纇", "oxim");
            dic.Add("颣", "oxim");
            dic.Add("炥", "oxjh");
            dic.Add("爍", "oxrs");
            dic.Add("糑", "oxuu");
            dic.Add("粃", "oxxn");
            dic.Add("煯", "oxxr");
            dic.Add("米", "oy");
            dic.Add("熫", "oyao");
            dic.Add("爌", "oyaw");
            dic.Add("焞", "oybg");
            dic.Add("燉", "oybt");
            dic.Add("焴", "oyce");
            dic.Add("粧", "oyfg");
            dic.Add("炷", "oyg");
            dic.Add("炞", "oyhy");
            dic.Add("爙", "oyke");
            dic.Add("燷", "oyli");
            dic.Add("燣", "oylt");
            dic.Add("炕", "oym");
            dic.Add("熇", "oymk");
            dic.Add("粇", "oymn");
            dic.Add("燺", "oyms");
            dic.Add("炉", "oyn");
            dic.Add("煸", "oyna");
            dic.Add("糄", "oyna");
            dic.Add("熩", "oync");
            dic.Add("煽", "oynn");
            dic.Add("爊", "oyno");
            dic.Add("粐", "oynt");
            dic.Add("烗", "oynw");
            dic.Add("熝", "oynx");
            dic.Add("麊", "oynx");
            dic.Add("燮", "oyo");
            dic.Add("爕", "oyoo");
            dic.Add("夑", "oyot");
            dic.Add("煷", "oypm");
            dic.Add("燫", "oyuo");
            dic.Add("粮", "oyv");
            dic.Add("烺", "oyve");
            dic.Add("糠", "oyvi");
            dic.Add("糖", "oyvk");
            dic.Add("煻", "oyvk");
            dic.Add("焿", "oyvw");
            dic.Add("粹", "oyw");
            dic.Add("焠", "oywf");
            dic.Add("焲", "oywy");
            dic.Add("炫", "oyx");
            dic.Add("灬", "oyy");
            dic.Add("炆", "oyy");
            dic.Add("这", "p");
            dic.Add("之", "p");
            dic.Add("宽", "pa");
            dic.Add("宦", "pah");
            dic.Add("宧", "pahh");
            dic.Add("寛", "pahq");
            dic.Add("寬", "pahy");
            dic.Add("寞", "paj");
            dic.Add("冪", "pajh");
            dic.Add("字", "pb");
            dic.Add("冣", "pbcu");
            dic.Add("宻", "pcum");
            dic.Add("害", "pd");
            dic.Add("宏", "pdc");
            dic.Add("翝", "pdcn");
            dic.Add("寡", "pde");
            dic.Add("宥", "pdef");
            dic.Add("宕", "pdf");
            dic.Add("宸", "pdfe");
            dic.Add("割", "pdhj");
            dic.Add("豁", "pdhk");
            dic.Add("鶷", "pdho");
            dic.Add("寷", "pdhu");
            dic.Add("寕", "pdls");
            dic.Add("宬", "pdnt");
            dic.Add("寄", "pds");
            dic.Add("寮", "pdu");
            dic.Add("宊", "pdu");
            dic.Add("実", "pdwu");
            dic.Add("宠", "pdx");
            dic.Add("家", "pe");
            dic.Add("肎", "pef");
            dic.Add("宜", "peg");
            dic.Add("冝", "pegf");
            dic.Add("农", "pei");
            dic.Add("寀", "pesu");
            dic.Add("寪", "peto");
            dic.Add("冢", "pey");
            dic.Add("守", "pf");
            dic.Add("冡", "pfeu");
            dic.Add("寘", "pfhw");
            dic.Add("宗", "pfi");
            dic.Add("崈", "pfim");
            dic.Add("賨", "pfim");
            dic.Add("鶎", "pfio");
            dic.Add("寒", "pfj");
            dic.Add("寋", "pfjb");
            dic.Add("骞", "pfjc");
            dic.Add("騫", "pfjc");
            dic.Add("褰", "pfje");
            dic.Add("塞", "pfjf");
            dic.Add("蹇", "pfjh");
            dic.Add("宑", "pfjj");
            dic.Add("赛", "pfjm");
            dic.Add("賽", "pfjm");
            dic.Add("鶱", "pfjo");
            dic.Add("搴", "pfjr");
            dic.Add("寨", "pfjs");
            dic.Add("弿", "pfjx");
            dic.Add("謇", "pfjy");
            dic.Add("完", "pfq");
            dic.Add("寇", "pfqc");
            dic.Add("冦", "pfqc");
            dic.Add("冠", "pfqf");
            dic.Add("鵍", "pfqo");
            dic.Add("宼", "pfqv");
            dic.Add("宯", "pftb");
            dic.Add("定", "pg");
            dic.Add("室", "pgc");
            dic.Add("寈", "pgef");
            dic.Add("宇", "pgf");
            dic.Add("顁", "pghm");
            dic.Add("賓", "pgim");
            dic.Add("顮", "pgim");
            dic.Add("宣", "pgj");
            dic.Add("寭", "pgjn");
            dic.Add("翧", "pgjn");
            dic.Add("富", "pgk");
            dic.Add("冨", "pgkl");
            dic.Add("憲", "pgln");
            dic.Add("寅", "pgm");
            dic.Add("戭", "pgma");
            dic.Add("写", "pgn");
            dic.Add("寳", "pgqm");
            dic.Add("寚", "pgrm");
            dic.Add("寶", "pgrm");
            dic.Add("寁", "pgvh");
            dic.Add("宝", "pgy");
            dic.Add("寂", "ph");
            dic.Add("寊", "phmu");
            dic.Add("宐", "phng");
            dic.Add("鼏", "phnn");
            dic.Add("宵", "pi");
            dic.Add("宨", "piqb");
            dic.Add("寖", "pivc");
            dic.Add("审", "pj");
            dic.Add("幂", "pjd");
            dic.Add("寔", "pjgh");
            dic.Add("寓", "pjm");
            dic.Add("冥", "pju");
            dic.Add("鄍", "pjub");
            dic.Add("覭", "pjuq");
            dic.Add("鼆", "pjuv");
            dic.Add("宴", "pjv");
            dic.Add("宫", "pk");
            dic.Add("宺", "pkgq");
            dic.Add("寠", "pkgv");
            dic.Add("宲", "pksu");
            dic.Add("宮", "pktk");
            dic.Add("军", "pl");
            dic.Add("郓", "plb");
            dic.Add("鄆", "plbh");
            dic.Add("顐", "pldm");
            dic.Add("寰", "plg");
            dic.Add("皲", "plh");
            dic.Add("皸", "plhc");
            dic.Add("軍", "plj");
            dic.Add("運", "plpk");
            dic.Add("鶤", "plwo");
            dic.Add("宙", "pm");
            dic.Add("冗", "pmb");
            dic.Add("宂", "pmb");
            dic.Add("冚", "pmj");
            dic.Add("鴧", "pmwo");
            dic.Add("官", "pn");
            dic.Add("甯", "pne");
            dic.Add("寢", "pnhc");
            dic.Add("寐", "pnhi");
            dic.Add("寤", "pnhk");
            dic.Add("悹", "pnhn");
            dic.Add("逭", "pnhp");
            dic.Add("寱", "pnhs");
            dic.Add("寎", "pnhw");
            dic.Add("寣", "pnhy");
            dic.Add("寍", "pnlf");
            dic.Add("寜", "pnlh");
            dic.Add("鸋", "pnlo");
            dic.Add("寧", "pnls");
            dic.Add("賔", "pnmu");
            dic.Add("密", "pnt");
            dic.Add("寗", "pntf");
            dic.Add("蜜", "pntj");
            dic.Add("宓", "pntr");
            dic.Add("寥", "pnw");
            dic.Add("廴", "pny");
            dic.Add("灾", "po");
            dic.Add("叜", "pocu");
            dic.Add("冞", "pou");
            dic.Add("宩", "pou");
            dic.Add("宛", "pq");
            dic.Add("", "pqb");
            dic.Add("鹓", "pqbg");
            dic.Add("邥", "pqbh");
            dic.Add("剜", "pqbj");
            dic.Add("惌", "pqbn");
            dic.Add("鵷", "pqbo");
            dic.Add("瓭", "pqgn");
            dic.Add("沊", "pqii");
            dic.Add("冤", "pqk");
            dic.Add("寃", "pqky");
            dic.Add("寏", "pqmd");
            dic.Add("鸩", "pqq");
            dic.Add("冘", "pqv");
            dic.Add("鴆", "pqwo");
            dic.Add("宾", "pr");
            dic.Add("寙", "prcy");
            dic.Add("牢", "prh");
            dic.Add("冟", "prxb");
            dic.Add("宁", "ps");
            dic.Add("冧", "pssu");
            dic.Add("宋", "psu");
            dic.Add("客", "pt");
            dic.Add("宅", "pta");
            dic.Add("宎", "ptdu");
            dic.Add("宪", "ptf");
            dic.Add("宒", "ptfn");
            dic.Add("额", "ptkm");
            dic.Add("額", "ptkm");
            dic.Add("愙", "ptkn");
            dic.Add("審", "ptol");
            dic.Add("覾", "ptoq");
            dic.Add("宷", "ptou");
            dic.Add("实", "pu");
            dic.Add("褡", "pua");
            dic.Add("裓", "puaa");
            dic.Add("襼", "puac");
            dic.Add("襽", "puai");
            dic.Add("襺", "puaj");
            dic.Add("襤", "pual");
            dic.Add("袣", "puan");
            dic.Add("褋", "puas");
            dic.Add("襪", "puat");
            dic.Add("褗", "puav");
            dic.Add("褀", "puaw");
            dic.Add("襔", "puay");
            dic.Add("襵", "pubb");
            dic.Add("袦", "pubm");
            dic.Add("衪", "pubn");
            dic.Add("衩", "puc");
            dic.Add("裰", "pucc");
            dic.Add("襂", "puce");
            dic.Add("褬", "pucs");
            dic.Add("褦", "pucx");
            dic.Add("袏", "puda");
            dic.Add("袸", "pudb");
            dic.Add("袚", "pudc");
            dic.Add("裶", "pudd");
            dic.Add("褉", "pudd");
            dic.Add("裖", "pude");
            dic.Add("褥", "pudf");
            dic.Add("袥", "pudg");
            dic.Add("袹", "pudj");
            dic.Add("袻", "pudj");
            dic.Add("襫", "pudj");
            dic.Add("裿", "pudk");
            dic.Add("袴", "pudn");
            dic.Add("裺", "pudn");
            dic.Add("裌", "pudw");
            dic.Add("衫", "pue");
            dic.Add("褑", "puec");
            dic.Add("寵", "pued");
            dic.Add("袓", "pueg");
            dic.Add("衱", "puey");
            dic.Add("衬", "puf");
            dic.Add("襦", "puf");
            dic.Add("衼", "pufc");
            dic.Add("袪", "pufc");
            dic.Add("褤", "pufe");
            dic.Add("袿", "puff");
            dic.Add("褠", "puff");
            dic.Add("褂", "pufh");
            dic.Add("衦", "pufh");
            dic.Add("袆", "pufh");
            dic.Add("褚", "pufj");
            dic.Add("袺", "pufk");
            dic.Add("襩", "pufm");
            dic.Add("襭", "pufm");
            dic.Add("襓", "pufq");
            dic.Add("裬", "puft");
            dic.Add("衭", "pufw");
            dic.Add("襶", "pufw");
            dic.Add("褹", "pufy");
            dic.Add("袜", "pug");
            dic.Add("裱", "puge");
            dic.Add("衧", "pugf");
            dic.Add("襋", "pugi");
            dic.Add("褿", "pugj");
            dic.Add("褔", "pugl");
            dic.Add("襀", "pugm");
            dic.Add("襰", "pugm");
            dic.Add("襧", "pugq");
            dic.Add("裋", "pugu");
            dic.Add("褄", "pugv");
            dic.Add("襹", "pugx");
            dic.Add("補", "pugy");
            dic.Add("裲", "pugy");
            dic.Add("补", "puh");
            dic.Add("被", "puhc");
            dic.Add("褃", "puhe");
            dic.Add("裃", "puhh");
            dic.Add("袩", "puhk");
            dic.Add("裭", "puhm");
            dic.Add("衤", "pui");
            dic.Add("褝", "puif");
            dic.Add("襠", "puil");
            dic.Add("裆", "puiv");
            dic.Add("宰", "puj");
            dic.Add("襊", "pujc");
            dic.Add("裡", "pujf");
            dic.Add("襅", "pujf");
            dic.Add("袒", "pujg");
            dic.Add("裫", "pujg");
            dic.Add("衵", "pujg");
            dic.Add("褆", "pujh");
            dic.Add("襮", "puji");
            dic.Add("裮", "pujj");
            dic.Add("褴", "pujl");
            dic.Add("褞", "pujl");
            dic.Add("褐", "pujn");
            dic.Add("褟", "pujn");
            dic.Add("裼", "pujr");
            dic.Add("裸", "pujs");
            dic.Add("裩", "pujx");
            dic.Add("裎", "puk");
            dic.Add("裐", "puke");
            dic.Add("襌", "pukf");
            dic.Add("衶", "pukh");
            dic.Add("", "pukm");
            dic.Add("", "pukm");
            dic.Add("襙", "puks");
            dic.Add("褸", "pukv");
            dic.Add("裢", "pul");
            dic.Add("裀", "puld");
            dic.Add("襗", "pulf");
            dic.Add("襡", "pulj");
            dic.Add("褳", "pulp");
            dic.Add("裍", "puls");
            dic.Add("襬", "pulx");
            dic.Add("袖", "pum");
            dic.Add("襛", "pume");
            dic.Add("衻", "pumf");
            dic.Add("袡", "pumf");
            dic.Add("褍", "pumj");
            dic.Add("裯", "pumk");
            dic.Add("衲", "pumw");
            dic.Add("袇", "pumy");
            dic.Add("袂", "pun");
            dic.Add("裾", "pund");
            dic.Add("褘", "punh");
            dic.Add("褶", "punr");
            dic.Add("袐", "punt");
            dic.Add("襈", "punw");
            dic.Add("袯", "puny");
            dic.Add("褛", "puo");
            dic.Add("襨", "puof");
            dic.Add("裧", "puoo");
            dic.Add("襆", "puoy");
            dic.Add("褣", "pupk");
            dic.Add("裈", "pupl");
            dic.Add("褌", "pupl");
            dic.Add("衴", "pupq");
            dic.Add("袕", "pupw");
            dic.Add("袉", "pupx");
            dic.Add("袍", "puq");
            dic.Add("衹", "puqa");
            dic.Add("襐", "puqe");
            dic.Add("袧", "puqk");
            dic.Add("裪", "puqm");
            dic.Add("袳", "puqq");
            dic.Add("袀", "puqu");
            dic.Add("袛", "puqy");
            dic.Add("襜", "puqy");
            dic.Add("裨", "pur");
            dic.Add("袙", "purg");
            dic.Add("袾", "puri");
            dic.Add("褫", "purm");
            dic.Add("袟", "purw");
            dic.Add("襟", "pus");
            dic.Add("褾", "pusi");
            dic.Add("袔", "pusk");
            dic.Add("褼", "pusn");
            dic.Add("寴", "pusq");
            dic.Add("襻", "pusr");
            dic.Add("袄", "put");
            dic.Add("袘", "putb");
            dic.Add("襖", "putd");
            dic.Add("衽", "putf");
            dic.Add("褈", "putf");
            dic.Add("袶", "puth");
            dic.Add("裄", "puth");
            dic.Add("褷", "puth");
            dic.Add("袮", "puti");
            dic.Add("襣", "putj");
            dic.Add("袼", "putk");
            dic.Add("裇", "putl");
            dic.Add("襎", "putl");
            dic.Add("襸", "putm");
            dic.Add("裑", "putt");
            dic.Add("複", "putt");
            dic.Add("袢", "puu");
            dic.Add("宍", "puu");
            dic.Add("褨", "puua");
            dic.Add("裷", "puub");
            dic.Add("襱", "puud");
            dic.Add("褙", "puue");
            dic.Add("襉", "puue");
            dic.Add("褅", "puuh");
            dic.Add("襕", "puui");
            dic.Add("襴", "puui");
            dic.Add("裥", "puuj");
            dic.Add("襇", "puuj");
            dic.Add("襚", "puup");
            dic.Add("裞", "puuq");
            dic.Add("襯", "puuq");
            dic.Add("襒", "puut");
            dic.Add("初", "puv");
            dic.Add("寝", "puvc");
            dic.Add("裉", "puve");
            dic.Add("襑", "puvf");
            dic.Add("裙", "puvk");
            dic.Add("袑", "puvk");
            dic.Add("袽", "puvk");
            dic.Add("褪", "puvp");
            dic.Add("襷", "puvr");
            dic.Add("裕", "puw");
            dic.Add("袷", "puw");
            dic.Add("衳", "puwc");
            dic.Add("袊", "puwc");
            dic.Add("襏", "puwc");
            dic.Add("袱", "puwd");
            dic.Add("袗", "puwe");
            dic.Add("袝", "puwf");
            dic.Add("袵", "puwf");
            dic.Add("襳", "puwg");
            dic.Add("裣", "puwi");
            dic.Add("衸", "puwj");
            dic.Add("褕", "puwj");
            dic.Add("襘", "puwj");
            dic.Add("衿", "puwn");
            dic.Add("褓", "puws");
            dic.Add("襍", "puws");
            dic.Add("衯", "puwv");
            dic.Add("襝", "puww");
            dic.Add("襥", "puwy");
            dic.Add("襁", "pux");
            dic.Add("褖", "puxe");
            dic.Add("袎", "puxl");
            dic.Add("裤", "puy");
            dic.Add("褊", "puya");
            dic.Add("褵", "puyc");
            dic.Add("襢", "puyg");
            dic.Add("褯", "puyh");
            dic.Add("褲", "puyl");
            dic.Add("裗", "puyq");
            dic.Add("袨", "puyx");
            dic.Add("安", "pv");
            dic.Add("鞌", "pvaf");
            dic.Add("宄", "pvb");
            dic.Add("頞", "pvdm");
            dic.Add("冩", "pvqo");
            dic.Add("寫", "pvqo");
            dic.Add("案", "pvs");
            dic.Add("宭", "pvtk");
            dic.Add("鴳", "pvwo");
            dic.Add("空", "pw");
            dic.Add("窢", "pwag");
            dic.Add("窍", "pwan");
            dic.Add("鵼", "pwao");
            dic.Add("穿", "pwat");
            dic.Add("窃", "pwav");
            dic.Add("窿", "pwb");
            dic.Add("窷", "pwbb");
            dic.Add("窋", "pwbm");
            dic.Add("窡", "pwcc");
            dic.Add("窓", "pwcn");
            dic.Add("梥", "pwcs");
            dic.Add("突", "pwd");
            dic.Add("窫", "pwdd");
            dic.Add("竂", "pwdi");
            dic.Add("宿", "pwdj");
            dic.Add("鶟", "pwdo");
            dic.Add("窚", "pwdt");
            dic.Add("窰", "pwem");
            dic.Add("罕", "pwf");
            dic.Add("窙", "pwfb");
            dic.Add("窦", "pwfd");
            dic.Add("窐", "pwff");
            dic.Add("察", "pwfi");
            dic.Add("穽", "pwfj");
            dic.Add("竇", "pwfm");
            dic.Add("竃", "pwfn");
            dic.Add("窥", "pwfq");
            dic.Add("窺", "pwfq");
            dic.Add("窛", "pwfv");
            dic.Add("竈", "pwfv");
            dic.Add("窴", "pwfw");
            dic.Add("窾", "pwfw");
            dic.Add("窒", "pwg");
            dic.Add("穻", "pwgf");
            dic.Add("窀", "pwgn");
            dic.Add("竀", "pwgq");
            dic.Add("窉", "pwgw");
            dic.Add("窅", "pwhf");
            dic.Add("窧", "pwhj");
            dic.Add("窕", "pwi");
            dic.Add("窏", "pwif");
            dic.Add("窪", "pwif");
            dic.Add("窠", "pwj");
            dic.Add("窤", "pwjx");
            dic.Add("窜", "pwk");
            dic.Add("窶", "pwkv");
            dic.Add("窝", "pwkw");
            dic.Add("穷", "pwl");
            dic.Add("帘", "pwm");
            dic.Add("窩", "pwmk");
            dic.Add("窟", "pwn");
            dic.Add("穵", "pwnb");
            dic.Add("窹", "pwnk");
            dic.Add("窭", "pwo");
            dic.Add("窲", "pwof");
            dic.Add("穸", "pwq");
            dic.Add("窌", "pwqb");
            dic.Add("窎", "pwqg");
            dic.Add("窇", "pwqn");
            dic.Add("窞", "pwqv");
            dic.Add("窑", "pwr");
            dic.Add("窂", "pwrh");
            dic.Add("竅", "pwrt");
            dic.Add("窳", "pwry");
            dic.Add("窊", "pwry");
            dic.Add("穼", "pwsu");
            dic.Add("罙", "pwsu");
            dic.Add("窗", "pwt");
            dic.Add("竊", "pwtc");
            dic.Add("穾", "pwtd");
            dic.Add("窄", "pwtf");
            dic.Add("宱", "pwtf");
            dic.Add("窖", "pwtk");
            dic.Add("竆", "pwtk");
            dic.Add("窸", "pwtn");
            dic.Add("窻", "pwtn");
            dic.Add("竁", "pwtn");
            dic.Add("窆", "pwtp");
            dic.Add("窮", "pwtx");
            dic.Add("穴", "pwu");
            dic.Add("竉", "pwud");
            dic.Add("窨", "pwuj");
            dic.Add("窯", "pwuo");
            dic.Add("邃", "pwup");
            dic.Add("窔", "pwuq");
            dic.Add("究", "pwv");
            dic.Add("寑", "pwvc");
            dic.Add("窘", "pwvk");
            dic.Add("竄", "pwvn");
            dic.Add("窼", "pwvs");
            dic.Add("容", "pww");
            dic.Add("彮", "pwwe");
            dic.Add("窬", "pwwj");
            dic.Add("窵", "pwwo");
            dic.Add("鴪", "pwwo");
            dic.Add("窱", "pwws");
            dic.Add("穹", "pwx");
            dic.Add("窈", "pwxl");
            dic.Add("窽", "pwxw");
            dic.Add("鹤", "pwy");
            dic.Add("隺", "pwyd");
            dic.Add("寉", "pwyf");
            dic.Add("窣", "pwyf");
            dic.Add("寯", "pwym");
            dic.Add("鶴", "pwyo");
            dic.Add("它", "px");
            dic.Add("宆", "pxb");
            dic.Add("宖", "pxcu");
            dic.Add("實", "pxfm");
            dic.Add("迱", "pxpv");
            dic.Add("寲", "pxth");
            dic.Add("社", "py");
            dic.Add("祺", "pya");
            dic.Add("祴", "pyaa");
            dic.Add("禥", "pyaf");
            dic.Add("禖", "pyas");
            dic.Add("祁", "pyb");
            dic.Add("祂", "pybn");
            dic.Add("祃", "pycg");
            dic.Add("禡", "pycy");
            dic.Add("祷", "pyd");
            dic.Add("祓", "pydc");
            dic.Add("禊", "pydd");
            dic.Add("祳", "pyde");
            dic.Add("祜", "pydg");
            dic.Add("祏", "pydg");
            dic.Add("祐", "pydk");
            dic.Add("禲", "pydy");
            dic.Add("祖", "pye");
            dic.Add("禐", "pyec");
            dic.Add("礽", "pyen");
            dic.Add("祛", "pyfc");
            dic.Add("禱", "pyff");
            dic.Add("祎", "pyfh");
            dic.Add("禃", "pyfh");
            dic.Add("祙", "pyfi");
            dic.Add("禇", "pyfj");
            dic.Add("禧", "pyfk");
            dic.Add("祮", "pyfk");
            dic.Add("祾", "pyft");
            dic.Add("禛", "pyfw");
            dic.Add("福", "pyg");
            dic.Add("祆", "pygd");
            dic.Add("宔", "pygf");
            dic.Add("祬", "pygf");
            dic.Add("禣", "pygf");
            dic.Add("禰", "pygq");
            dic.Add("祉", "pyh");
            dic.Add("祯", "pyhm");
            dic.Add("禎", "pyhm");
            dic.Add("視", "pyhq");
            dic.Add("礻", "pyi");
            dic.Add("祧", "pyiq");
            dic.Add("神", "pyj");
            dic.Add("禔", "pyjh");
            dic.Add("禵", "pyjm");
            dic.Add("禢", "pyjn");
            dic.Add("禓", "pyjr");
            dic.Add("祼", "pyjs");
            dic.Add("禑", "pyjy");
            dic.Add("祝", "pyk");
            dic.Add("祦", "pykd");
            dic.Add("禪", "pykf");
            dic.Add("祌", "pykh");
            dic.Add("祸", "pykw");
            dic.Add("祻", "pyld");
            dic.Add("禗", "pyln");
            dic.Add("禤", "pyln");
            dic.Add("祵", "pyls");
            dic.Add("禝", "pylt");
            dic.Add("禩", "pylw");
            dic.Add("视", "pym");
            dic.Add("祋", "pymc");
            dic.Add("禯", "pyme");
            dic.Add("禂", "pymk");
            dic.Add("禍", "pymk");
            dic.Add("禮", "pymu");
            dic.Add("冖", "pyn");
            dic.Add("祀", "pyn");
            dic.Add("祤", "pyng");
            dic.Add("禕", "pynh");
            dic.Add("祠", "pynk");
            dic.Add("礼", "pynn");
            dic.Add("祕", "pynt");
            dic.Add("辶", "pyny");
            dic.Add("禷", "pyom");
            dic.Add("禈", "pypl");
            dic.Add("祢", "pyq");
            dic.Add("祇", "pyqa");
            dic.Add("祪", "pyqb");
            dic.Add("祹", "pyqm");
            dic.Add("祗", "pyqy");
            dic.Add("礿", "pyqy");
            dic.Add("祈", "pyr");
            dic.Add("禆", "pyrf");
            dic.Add("祩", "pyri");
            dic.Add("禠", "pyrm");
            dic.Add("祑", "pyrw");
            dic.Add("禋", "pysf");
            dic.Add("禫", "pysj");
            dic.Add("祚", "pyt");
            dic.Add("祅", "pytd");
            dic.Add("祣", "pyte");
            dic.Add("祍", "pytf");
            dic.Add("祰", "pytk");
            dic.Add("禶", "pytm");
            dic.Add("祥", "pyu");
            dic.Add("禙", "pyue");
            dic.Add("禅", "pyuf");
            dic.Add("禉", "pyug");
            dic.Add("禘", "pyuh");
            dic.Add("禚", "pyuo");
            dic.Add("禭", "pyup");
            dic.Add("祱", "pyuq");
            dic.Add("祶", "pyut");
            dic.Add("禌", "pyux");
            dic.Add("禄", "pyv");
            dic.Add("祲", "pyvc");
            dic.Add("祒", "pyvk");
            dic.Add("禴", "pywa");
            dic.Add("祔", "pywf");
            dic.Add("祄", "pywj");
            dic.Add("禬", "pywj");
            dic.Add("祫", "pywk");
            dic.Add("禒", "pyxe");
            dic.Add("祿", "pyxi");
            dic.Add("禨", "pyxt");
            dic.Add("宀", "pyy");
            dic.Add("禳", "pyye");
            dic.Add("祽", "pyyf");
            dic.Add("禞", "pyyk");
            dic.Add("禟", "pyyk");
            dic.Add("祊", "pyyn");
            dic.Add("我", "q");
            dic.Add("金", "q");
            dic.Add("氏", "qa");
            dic.Add("鉽", "qaag");
            dic.Add("鐷", "qaas");
            dic.Add("錢", "qaat");
            dic.Add("锘", "qad");
            dic.Add("鍩", "qadk");
            dic.Add("頯", "qadm");
            dic.Add("鍖", "qadn");
            dic.Add("鐁", "qadr");
            dic.Add("鑶", "qadt");
            dic.Add("錤", "qadw");
            dic.Add("鏾", "qaet");
            dic.Add("钳", "qaf");
            dic.Add("鉗", "qafg");
            dic.Add("氒", "qafj");
            dic.Add("鐯", "qafj");
            dic.Add("", "qafj");
            dic.Add("鑉", "qafl");
            dic.Add("釭", "qag");
            dic.Add("鏵", "qagf");
            dic.Add("舛", "qah");
            dic.Add("铘", "qahb");
            dic.Add("鋣", "qahb");
            dic.Add("鏗", "qahf");
            dic.Add("鑑", "qahl");
            dic.Add("鑦", "qahm");
            dic.Add("鑬", "qahq");
            dic.Add("桀", "qahs");
            dic.Add("釾", "qaht");
            dic.Add("", "qaht");
            dic.Add("鑮", "qaif");
            dic.Add("銾", "qaiy");
            dic.Add("错", "qaj");
            dic.Add("镆", "qajd");
            dic.Add("鏌", "qajd");
            dic.Add("昏", "qajf");
            dic.Add("錯", "qajg");
            dic.Add("钷", "qak");
            dic.Add("鉕", "qakg");
            dic.Add("鏂", "qakk");
            dic.Add("鑎", "qakm");
            dic.Add("鑵", "qaky");
            dic.Add("锚", "qal");
            dic.Add("錨", "qalg");
            dic.Add("鑖", "qalt");
            dic.Add("鍈", "qamd");
            dic.Add("锳", "qamd");
            dic.Add("帋", "qamh");
            dic.Add("鉔", "qamh");
            dic.Add("鐄", "qamw");
            dic.Add("鏋", "qamy");
            dic.Add("钜", "qan");
            dic.Add("鉅", "qang");
            dic.Add("鉪", "qann");
            dic.Add("鍱", "qans");
            dic.Add("钺", "qant");
            dic.Add("鉞", "qant");
            dic.Add("铽", "qany");
            dic.Add("鋱", "qany");
            dic.Add("铹", "qap");
            dic.Add("鐕", "qaqj");
            dic.Add("銰", "qaqy");
            dic.Add("铙", "qat");
            dic.Add("鈛", "qat");
            dic.Add("鑝", "qatp");
            dic.Add("钄", "qaui");
            dic.Add("鍣", "qavk");
            dic.Add("镬", "qawc");
            dic.Add("鑊", "qawc");
            dic.Add("匒", "qawk");
            dic.Add("鎝", "qawk");
            dic.Add("錵", "qawx");
            dic.Add("鉷", "qawy");
            dic.Add("氐", "qay");
            dic.Add("釴", "qay");
            dic.Add("邸", "qayb");
            dic.Add("鸱", "qayg");
            dic.Add("鋩", "qayn");
            dic.Add("錺", "qayn");
            dic.Add("铓", "qayn");
            dic.Add("鴟", "qayo");
            dic.Add("凶", "qb");
            dic.Add("鑷", "qbbb");
            dic.Add("鎁", "qbbh");
            dic.Add("镊", "qbc");
            dic.Add("駌", "qbcu");
            dic.Add("鋷", "qbcy");
            dic.Add("铒", "qbg");
            dic.Add("釨", "qbg");
            dic.Add("鉺", "qbg");
            dic.Add("钌", "qbh");
            dic.Add("卬", "qbh");
            dic.Add("夘", "qbh");
            dic.Add("邜", "qbh");
            dic.Add("釕", "qbh");
            dic.Add("眢", "qbhf");
            dic.Add("鐊", "qbjr");
            dic.Add("锰", "qbl");
            dic.Add("盌", "qblf");
            dic.Add("錳", "qblg");
            dic.Add("鈯", "qbmh");
            dic.Add("怨", "qbn");
            dic.Add("夗", "qbn");
            dic.Add("釶", "qbn");
            dic.Add("銸", "qbnn");
            dic.Add("迎", "qbp");
            dic.Add("鸳", "qbq");
            dic.Add("兇", "qbqb");
            dic.Add("锕", "qbs");
            dic.Add("錒", "qbsk");
            dic.Add("鄒", "qbtb");
            dic.Add("皺", "qbtc");
            dic.Add("鶵", "qbto");
            dic.Add("芻", "qbtt");
            dic.Add("雛", "qbty");
            dic.Add("妴", "qbvf");
            dic.Add("鴛", "qbwo");
            dic.Add("色", "qc");
            dic.Add("鐍", "qcbk");
            dic.Add("鍒", "qcbs");
            dic.Add("錣", "qccc");
            dic.Add("鏒", "qcce");
            dic.Add("鎟", "qccs");
            dic.Add("銿", "qceh");
            dic.Add("铎", "qcf");
            dic.Add("勾", "qci");
            dic.Add("鈶", "qckg");
            dic.Add("钯", "qcn");
            dic.Add("鈀", "qcn");
            dic.Add("鈗", "qcqn");
            dic.Add("鉾", "qcrh");
            dic.Add("鋑", "qcwt");
            dic.Add("钗", "qcy");
            dic.Add("鎷", "qcy");
            dic.Add("釵", "qcyy");
            dic.Add("然", "qd");
            dic.Add("危", "qdb");
            dic.Add("頠", "qdbm");
            dic.Add("鈪", "qdbn");
            dic.Add("敎", "qdbt");
            dic.Add("郄", "qdc");
            dic.Add("钹", "qdcy");
            dic.Add("鈜", "qdcy");
            dic.Add("鈸", "qdcy");
            dic.Add("肴", "qde");
            dic.Add("郩", "qdeb");
            dic.Add("殽", "qdec");
            dic.Add("铕", "qdeg");
            dic.Add("銪", "qdeg");
            dic.Add("鍸", "qdeg");
            dic.Add("鋹", "qdey");
            dic.Add("锛", "qdf");
            dic.Add("錛", "qdfa");
            dic.Add("鋠", "qdfe");
            dic.Add("鍷", "qdff");
            dic.Add("鎒", "qdff");
            dic.Add("錼", "qdfi");
            dic.Add("銙", "qdfn");
            dic.Add("钴", "qdg");
            dic.Add("鈷", "qdg");
            dic.Add("鉐", "qdg");
            dic.Add("銊", "qdgt");
            dic.Add("鍼", "qdgt");
            dic.Add("锲", "qdh");
            dic.Add("銌", "qdhb");
            dic.Add("鍥", "qdhd");
            dic.Add("鏚", "qdht");
            dic.Add("鏏", "qdhv");
            dic.Add("銇", "qdiy");
            dic.Add("銆", "qdjg");
            dic.Add("匎", "qdjn");
            dic.Add("希", "qdm");
            dic.Add("钸", "qdm");
            dic.Add("郗", "qdmb");
            dic.Add("鈽", "qdmh");
            dic.Add("瓻", "qdmn");
            dic.Add("鵗", "qdmo");
            dic.Add("欷", "qdmw");
            dic.Add("顉", "qdmy");
            dic.Add("铖", "qdn");
            dic.Add("鋮", "qdnt");
            dic.Add("鋴", "qdqn");
            dic.Add("鏯", "qdqq");
            dic.Add("厃", "qdr");
            dic.Add("錡", "qdsk");
            dic.Add("锜", "qdsk");
            dic.Add("铸", "qdt");
            dic.Add("矦", "qdtd");
            dic.Add("鋳", "qdtf");
            dic.Add("镣", "qdu");
            dic.Add("鐐", "qdui");
            dic.Add("镢", "qduw");
            dic.Add("鐝", "qduw");
            dic.Add("詹", "qdw");
            dic.Add("甔", "qdwn");
            dic.Add("鋏", "qdww");
            dic.Add("銭", "qdxy");
            dic.Add("钛", "qdy");
            dic.Add("釱", "qdy");
            dic.Add("鈦", "qdyy");
            dic.Add("角", "qe");
            dic.Add("觨", "qeai");
            dic.Add("觾", "qeao");
            dic.Add("觵", "qeaw");
            dic.Add("鋢", "qebg");
            dic.Add("觭", "qedk");
            dic.Add("錋", "qeeg");
            dic.Add("觙", "qeey");
            dic.Add("锊", "qef");
            dic.Add("锾", "qefc");
            dic.Add("鍰", "qefc");
            dic.Add("觟", "qeff");
            dic.Add("觩", "qefy");
            dic.Add("鋝", "qefy");
            dic.Add("钥", "qeg");
            dic.Add("鈅", "qeg");
            dic.Add("鉏", "qegg");
            dic.Add("觫", "qegi");
            dic.Add("锄", "qegl");
            dic.Add("鋤", "qegl");
            dic.Add("觥", "qei");
            dic.Add("觘", "qeit");
            dic.Add("觛", "qejg");
            dic.Add("触", "qejy");
            dic.Add("觶", "qekf");
            dic.Add("觸", "qelj");
            dic.Add("觔", "qeln");
            dic.Add("觿", "qemk");
            dic.Add("觽", "qemm");
            dic.Add("觖", "qen");
            dic.Add("釢", "qen");
            dic.Add("觓", "qenh");
            dic.Add("鑀", "qept");
            dic.Add("觗", "qeqa");
            dic.Add("觤", "qeqb");
            dic.Add("觼", "qeqt");
            dic.Add("觝", "qeqy");
            dic.Add("觚", "qer");
            dic.Add("鎐", "qerm");
            dic.Add("钐", "qet");
            dic.Add("釤", "qet");
            dic.Add("觡", "qetk");
            dic.Add("觞", "qetr");
            dic.Add("斛", "qeu");
            dic.Add("觯", "qeu");
            dic.Add("觧", "qeud");
            dic.Add("觪", "qeuh");
            dic.Add("觲", "qeuh");
            dic.Add("解", "qev");
            dic.Add("鋖", "qevg");
            dic.Add("觮", "qevi");
            dic.Add("蟹", "qevj");
            dic.Add("邂", "qevp");
            dic.Add("觬", "qevq");
            dic.Add("觹", "qewm");
            dic.Add("鵤", "qewo");
            dic.Add("觻", "qexs");
            dic.Add("鈒", "qeyy");
            dic.Add("钑", "qeyy");
            dic.Add("针", "qf");
            dic.Add("鐵", "qfag");
            dic.Add("鐼", "qfam");
            dic.Add("鐡", "qfau");
            dic.Add("鎑", "qfcl");
            dic.Add("鈘", "qfcy");
            dic.Add("鉣", "qfcy");
            dic.Add("勻", "qfd");
            dic.Add("鑐", "qfdj");
            dic.Add("銈", "qffg");
            dic.Add("鐃", "qffq");
            dic.Add("钍", "qfg");
            dic.Add("釷", "qfg");
            dic.Add("針", "qfh");
            dic.Add("釬", "qfh");
            dic.Add("镇", "qfhw");
            dic.Add("鎮", "qfhw");
            dic.Add("銢", "qfiy");
            dic.Add("銶", "qfiy");
            dic.Add("鎱", "qfke");
            dic.Add("銡", "qfkg");
            dic.Add("镭", "qfl");
            dic.Add("鐳", "qflg");
            dic.Add("鑟", "qflm");
            dic.Add("鑄", "qfnf");
            dic.Add("釫", "qfnn");
            dic.Add("鋕", "qfny");
            dic.Add("鋍", "qfpb");
            dic.Add("鎍", "qfpi");
            dic.Add("鈨", "qfqn");
            dic.Add("锗", "qft");
            dic.Add("﨧", "qftb");
            dic.Add("銒", "qftf");
            dic.Add("鍺", "qftj");
            dic.Add("铐", "qftn");
            dic.Add("銬", "qftn");
            dic.Add("釮", "qftt");
            dic.Add("铑", "qftx");
            dic.Add("銠", "qftx");
            dic.Add("﨨", "qfuf");
            dic.Add("鐽", "qfup");
            dic.Add("錴", "qfwf");
            dic.Add("鐟", "qfwj");
            dic.Add("鑚", "qfwm");
            dic.Add("錂", "qfwt");
            dic.Add("鈇", "qfwy");
            dic.Add("钱", "qg");
            dic.Add("鲽", "qga");
            dic.Add("鳠", "qgac");
            dic.Add("鈃", "qgah");
            dic.Add("錻", "qgah");
            dic.Add("钘", "qgah");
            dic.Add("鉶", "qgaj");
            dic.Add("铏", "qgaj");
            dic.Add("鳓", "qgal");
            dic.Add("鐂", "qgal");
            dic.Add("鲯", "qgaw");
            dic.Add("印", "qgb");
            dic.Add("鲰", "qgbc");
            dic.Add("钝", "qgbn");
            dic.Add("鈍", "qgbn");
            dic.Add("鲐", "qgc");
            dic.Add("鲬", "qgce");
            dic.Add("鲹", "qgce");
            dic.Add("銍", "qgcf");
            dic.Add("铚", "qgcf");
            dic.Add("鳋", "qgcj");
            dic.Add("鲃", "qgcn");
            dic.Add("鱿", "qgd");
            dic.Add("鲅", "qgdc");
            dic.Add("鲱", "qgdd");
            dic.Add("鲔", "qgde");
            dic.Add("鲕", "qgdj");
            dic.Add("", "qgdj");
            dic.Add("鳡", "qgdn");
            dic.Add("鳜", "qgdw");
            dic.Add("铺", "qge");
            dic.Add("匍", "qge");
            dic.Add("鎛", "qgef");
            dic.Add("镈", "qgef");
            dic.Add("锖", "qgeg");
            dic.Add("錆", "qgeg");
            dic.Add("鳐", "qgem");
            dic.Add("鋪", "qgey");
            dic.Add("錶", "qgey");
            dic.Add("鱼", "qgf");
            dic.Add("鲑", "qgff");
            dic.Add("錏", "qgfg");
            dic.Add("釪", "qgfh");
            dic.Add("鳍", "qgfj");
            dic.Add("鲒", "qgfk");
            dic.Add("鲼", "qgfm");
            dic.Add("鐚", "qgfn");
            dic.Add("鲓", "qgfn");
            dic.Add("鲮", "qgft");
            dic.Add("鳕", "qgfv");
            dic.Add("鲆", "qgg");
            dic.Add("鲭", "qgge");
            dic.Add("錱", "qggf");
            dic.Add("鲾", "qggl");
            dic.Add("鲀", "qggn");
            dic.Add("鲠", "qggq");
            dic.Add("鲡", "qggy");
            dic.Add("钙", "qgh");
            dic.Add("鲈", "qgh");
            dic.Add("鲏", "qghc");
            dic.Add("钲", "qghg");
            dic.Add("鉦", "qghg");
            dic.Add("鲇", "qghk");
            dic.Add("鈣", "qghn");
            dic.Add("盥", "qgi");
            dic.Add("鲿", "qgic");
            dic.Add("銔", "qgif");
            dic.Add("鉟", "qgig");
            dic.Add("钚", "qgiy");
            dic.Add("鈈", "qgiy");
            dic.Add("鲁", "qgj");
            dic.Add("鲤", "qgj");
            dic.Add("鲥", "qgj");
            dic.Add("鳗", "qgjc");
            dic.Add("鲣", "qgjf");
            dic.Add("鏄", "qgjf");
            dic.Add("鳀", "qgjh");
            dic.Add("錬", "qgji");
            dic.Add("鲳", "qgjj");
            dic.Add("鳁", "qgjl");
            dic.Add("鳎", "qgjn");
            dic.Add("鏸", "qgjn");
            dic.Add("鲲", "qgjx");
            dic.Add("匐", "qgk");
            dic.Add("鋙", "qgkg");
            dic.Add("铻", "qgkg");
            dic.Add("镉", "qgkh");
            dic.Add("鎘", "qgkh");
            dic.Add("鋉", "qgki");
            dic.Add("鑩", "qgkk");
            dic.Add("鍢", "qgkl");
            dic.Add("鳄", "qgkn");
            dic.Add("鋀", "qgku");
            dic.Add("鏉", "qgkw");
            dic.Add("鳃", "qgl");
            dic.Add("鲴", "qgld");
            dic.Add("鳂", "qgle");
            dic.Add("鳏", "qgli");
            dic.Add("鍊", "qgli");
            dic.Add("鲢", "qglp");
            dic.Add("鲷", "qgm");
            dic.Add("鲉", "qgmg");
            dic.Add("鏪", "qgmj");
            dic.Add("鲗", "qgmj");
            dic.Add("鲖", "qgmk");
            dic.Add("鳢", "qgmu");
            dic.Add("鈵", "qgmw");
            dic.Add("鲺", "qgn");
            dic.Add("鳚", "qgnf");
            dic.Add("鱾", "qgnn");
            dic.Add("鳛", "qgnr");
            dic.Add("鳞", "qgo");
            dic.Add("鋄", "qgoc");
            dic.Add("铔", "qgog");
            dic.Add("錽", "qgot");
            dic.Add("铼", "qgoy");
            dic.Add("鲩", "qgp");
            dic.Add("鲍", "qgq");
            dic.Add("", "qgqb");
            dic.Add("鳇", "qgr");
            dic.Add("鲌", "qgrg");
            dic.Add("鳈", "qgri");
            dic.Add("鲘", "qgrk");
            dic.Add("鳔", "qgs");
            dic.Add("鲄", "qgsk");
            dic.Add("鲊", "qgtf");
            dic.Add("鲧", "qgti");
            dic.Add("鳤", "qgtn");
            dic.Add("鳅", "qgto");
            dic.Add("鲦", "qgts");
            dic.Add("鳆", "qgtt");
            dic.Add("稣", "qgty");
            dic.Add("鲜", "qgu");
            dic.Add("鳟", "qguf");
            dic.Add("鳉", "qguf");
            dic.Add("", "qgug");
            dic.Add("匉", "qguh");
            dic.Add("鳝", "qguk");
            dic.Add("鳒", "qguo");
            dic.Add("鲛", "qguq");
            dic.Add("铗", "qguw");
            dic.Add("鳑", "qguy");
            dic.Add("鲟", "qgv");
            dic.Add("鋞", "qgva");
            dic.Add("鲫", "qgvb");
            dic.Add("鲪", "qgvk");
            dic.Add("鲻", "qgvl");
            dic.Add("鍿", "qgvl");
            dic.Add("鱽", "qgvn");
            dic.Add("鲵", "qgvq");
            dic.Add("鲋", "qgw");
            dic.Add("鲙", "qgwc");
            dic.Add("鲶", "qgwn");
            dic.Add("鑈", "qgwq");
            dic.Add("銕", "qgxw");
            dic.Add("鲸", "qgy");
            dic.Add("鳊", "qgya");
            dic.Add("鳣", "qgyg");
            dic.Add("鳙", "qgyh");
            dic.Add("鲚", "qgyj");
            dic.Add("鲂", "qgyn");
            dic.Add("钰", "qgyy");
            dic.Add("鈺", "qgyy");
            dic.Add("外", "qh");
            dic.Add("钀", "qhad");
            dic.Add("鐻", "qhae");
            dic.Add("鏬", "qhah");
            dic.Add("鐪", "qhal");
            dic.Add("鑪", "qhal");
            dic.Add("錿", "qham");
            dic.Add("鑢", "qhan");
            dic.Add("鎼", "qhar");
            dic.Add("鑡", "qhbh");
            dic.Add("铍", "qhc");
            dic.Add("鈙", "qhcy");
            dic.Add("鈹", "qhcy");
            dic.Add("鐬", "qhdt");
            dic.Add("錹", "qheg");
            dic.Add("钼", "qhg");
            dic.Add("鉬", "qhg");
            dic.Add("钁", "qhhc");
            dic.Add("", "qhhc");
            dic.Add("鉲", "qhhy");
            dic.Add("鑺", "qhhy");
            dic.Add("亇", "qhj");
            dic.Add("鋽", "qhjh");
            dic.Add("钻", "qhk");
            dic.Add("鉆", "qhkg");
            dic.Add("夞", "qhkx");
            dic.Add("鏀", "qhlo");
            dic.Add("鍞", "qhmy");
            dic.Add("鐤", "qhnn");
            dic.Add("迯", "qhpi");
            dic.Add("鋧", "qhqn");
            dic.Add("钋", "qhy");
            dic.Add("釙", "qhy");
            dic.Add("乐", "qi");
            dic.Add("销", "qie");
            dic.Add("銷", "qieg");
            dic.Add("鍅", "qifc");
            dic.Add("玺", "qig");
            dic.Add("覙", "qihq");
            dic.Add("錔", "qijg");
            dic.Add("鐋", "qijr");
            dic.Add("锁", "qim");
            dic.Add("鋿", "qimk");
            dic.Add("鎖", "qimy");
            dic.Add("铴", "qin");
            dic.Add("迩", "qip");
            dic.Add("镗", "qipf");
            dic.Add("鏜", "qipf");
            dic.Add("鏛", "qiph");
            dic.Add("鐺", "qipl");
            dic.Add("鑜", "qipm");
            dic.Add("钂", "qipo");
            dic.Add("鎲", "qipq");
            dic.Add("镋", "qipq");
            dic.Add("鐣", "qipr");
            dic.Add("鏿", "qips");
            dic.Add("铫", "qiq");
            dic.Add("銚", "qiqn");
            dic.Add("銧", "qiqn");
            dic.Add("鎃", "qire");
            dic.Add("钞", "qit");
            dic.Add("鈔", "qitt");
            dic.Add("尔", "qiu");
            dic.Add("淾", "qiu");
            dic.Add("铛", "qiv");
            dic.Add("釥", "qiy");
            dic.Add("旬", "qj");
            dic.Add("鏎", "qjaf");
            dic.Add("鑤", "qjai");
            dic.Add("郇", "qjb");
            dic.Add("铿", "qjc");
            dic.Add("象", "qje");
            dic.Add("勨", "qjel");
            dic.Add("锂", "qjf");
            dic.Add("鋰", "qjfg");
            dic.Add("銲", "qjfh");
            dic.Add("钽", "qjg");
            dic.Add("鈤", "qjg");
            dic.Add("锝", "qjgf");
            dic.Add("鍀", "qjgf");
            dic.Add("鉭", "qjgg");
            dic.Add("鍉", "qjgh");
            dic.Add("鍚", "qjgr");
            dic.Add("钊", "qjh");
            dic.Add("刈", "qjh");
            dic.Add("釗", "qjh");
            dic.Add("鉮", "qjhh");
            dic.Add("鎤", "qjiq");
            dic.Add("錩", "qjjg");
            dic.Add("锠", "qjjg");
            dic.Add("亀", "qjjn");
            dic.Add("镘", "qjl");
            dic.Add("鏝", "qjlc");
            dic.Add("鎾", "qjlg");
            dic.Add("鍝", "qjmy");
            dic.Add("龟", "qjn");
            dic.Add("鎉", "qjng");
            dic.Add("迿", "qjpd");
            dic.Add("锡", "qjq");
            dic.Add("銞", "qjqf");
            dic.Add("鍻", "qjqn");
            dic.Add("錫", "qjqr");
            dic.Add("锞", "qjs");
            dic.Add("錁", "qjsy");
            dic.Add("鍟", "qjtg");
            dic.Add("锟", "qjx");
            dic.Add("錕", "qjxx");
            dic.Add("鉵", "qjy");
            dic.Add("鐛", "qjyi");
            dic.Add("名", "qk");
            dic.Add("鍓", "qkbg");
            dic.Add("邭", "qkbh");
            dic.Add("句", "qkd");
            dic.Add("鋗", "qkeg");
            dic.Add("锃", "qkg");
            dic.Add("釦", "qkg");
            dic.Add("鋘", "qkgd");
            dic.Add("鋥", "qkgg");
            dic.Add("鏤", "qkgv");
            dic.Add("钏", "qkh");
            dic.Add("釧", "qkh");
            dic.Add("钟", "qkhh");
            dic.Add("鈡", "qkhh");
            dic.Add("鏴", "qkhk");
            dic.Add("鐀", "qkhm");
            dic.Add("鑓", "qkhp");
            dic.Add("鋜", "qkhy");
            dic.Add("铝", "qkk");
            dic.Add("鋁", "qkkg");
            dic.Add("鋛", "qkkh");
            dic.Add("锷", "qkkn");
            dic.Add("鍔", "qkkn");
            dic.Add("鐰", "qkks");
            dic.Add("劬", "qkl");
            dic.Add("锅", "qkm");
            dic.Add("铞", "qkmh");
            dic.Add("銱", "qkmh");
            dic.Add("免", "qkq");
            dic.Add("鸲", "qkqg");
            dic.Add("勉", "qkql");
            dic.Add("鵵", "qkqo");
            dic.Add("逸", "qkqp");
            dic.Add("够", "qkqq");
            dic.Add("欨", "qkqw");
            dic.Add("兔", "qkqy");
            dic.Add("鉂", "qkqy");
            dic.Add("斪", "qkrh");
            dic.Add("敂", "qkty");
            dic.Add("鴝", "qkwo");
            dic.Add("鉙", "qkwy");
            dic.Add("雊", "qkwy");
            dic.Add("酁", "qkxb");
            dic.Add("劖", "qkxj");
            dic.Add("毚", "qkxy");
            dic.Add("甸", "ql");
            dic.Add("锢", "qldg");
            dic.Add("錮", "qldg");
            dic.Add("铟", "qldy");
            dic.Add("銦", "qldy");
            dic.Add("鐸", "qlff");
            dic.Add("钿", "qlg");
            dic.Add("鈿", "qlg");
            dic.Add("鍡", "qlge");
            dic.Add("鐶", "qlge");
            dic.Add("镮", "qlge");
            dic.Add("鎠", "qlgh");
            dic.Add("钾", "qlh");
            dic.Add("鉀", "qlh");
            dic.Add("鉫", "qlkg");
            dic.Add("鑸", "qllf");
            dic.Add("鑘", "qlll");
            dic.Add("锶", "qln");
            dic.Add("釛", "qln");
            dic.Add("錷", "qlnn");
            dic.Add("鍶", "qlny");
            dic.Add("链", "qlp");
            dic.Add("鏈", "qlpy");
            dic.Add("锣", "qlq");
            dic.Add("镯", "qlqj");
            dic.Add("鐲", "qlqj");
            dic.Add("鏩", "qlrh");
            dic.Add("鎅", "qlwj");
            dic.Add("镙", "qlx");
            dic.Add("鏍", "qlxi");
            dic.Add("鑼", "qlxy");
            dic.Add("负", "qm");
            dic.Add("錪", "qmaw");
            dic.Add("鈠", "qmcy");
            dic.Add("奂", "qmd");
            dic.Add("錌", "qmdf");
            dic.Add("鍴", "qmdj");
            dic.Add("鉠", "qmdy");
            dic.Add("鏰", "qmee");
            dic.Add("镚", "qmee");
            dic.Add("觰", "qmfj");
            dic.Add("錭", "qmfk");
            dic.Add("觴", "qmfr");
            dic.Add("铀", "qmg");
            dic.Add("鈾", "qmg");
            dic.Add("铜", "qmgk");
            dic.Add("銅", "qmgk");
            dic.Add("鎧", "qmgu");
            dic.Add("铡", "qmj");
            dic.Add("鍘", "qmjh");
            dic.Add("铅", "qmk");
            dic.Add("鉛", "qmkg");
            dic.Add("銏", "qmmg");
            dic.Add("銟", "qmmh");
            dic.Add("铠", "qmn");
            dic.Add("釠", "qmn");
            dic.Add("鍋", "qmnk");
            dic.Add("鐹", "qmnp");
            dic.Add("钢", "qmq");
            dic.Add("鎽", "qmth");
            dic.Add("負", "qmu");
            dic.Add("鋼", "qmum");
            dic.Add("钠", "qmw");
            dic.Add("奐", "qmwd");
            dic.Add("鑴", "qmwk");
            dic.Add("烉", "qmwo");
            dic.Add("夐", "qmwt");
            dic.Add("敻", "qmwt");
            dic.Add("鈉", "qmwy");
            dic.Add("鏙", "qmwy");
            dic.Add("钡", "qmy");
            dic.Add("鋇", "qmy");
            dic.Add("钒", "qmyy");
            dic.Add("釩", "qmyy");
            dic.Add("包", "qn");
            dic.Add("饶", "qna");
            dic.Add("馍", "qnad");
            dic.Add("馑", "qnag");
            dic.Add("鍲", "qnaj");
            dic.Add("鈱", "qnan");
            dic.Add("馓", "qnat");
            dic.Add("饣", "qnb");
            dic.Add("饵", "qnbg");
            dic.Add("饳", "qnbm");
            dic.Add("饴", "qnc");
            dic.Add("馂", "qnct");
            dic.Add("锯", "qnd");
            dic.Add("鋸", "qndg");
            dic.Add("馁", "qne");
            dic.Add("钮", "qnf");
            dic.Add("饽", "qnfb");
            dic.Add("鈕", "qnfg");
            dic.Add("馌", "qnfl");
            dic.Add("乌", "qng");
            dic.Add("邬", "qngb");
            dic.Add("馕", "qnge");
            dic.Add("馎", "qngf");
            dic.Add("鉰", "qngk");
            dic.Add("饨", "qngn");
            dic.Add("饯", "qngt");
            dic.Add("饾", "qngu");
            dic.Add("镅", "qnh");
            dic.Add("鍜", "qnhc");
            dic.Add("鏘", "qnhf");
            dic.Add("鎇", "qnhg");
            dic.Add("鍏", "qnhh");
            dic.Add("鈻", "qnhn");
            dic.Add("钃", "qnij");
            dic.Add("蚀", "qnj");
            dic.Add("馒", "qnjc");
            dic.Add("刨", "qnjh");
            dic.Add("馃", "qnjs");
            dic.Add("馄", "qnjx");
            dic.Add("馈", "qnk");
            dic.Add("鐴", "qnku");
            dic.Add("饥", "qnm");
            dic.Add("馉", "qnme");
            dic.Add("钇", "qnn");
            dic.Add("钆", "qnn");
            dic.Add("锔", "qnn");
            dic.Add("釓", "qnn");
            dic.Add("釔", "qnn");
            dic.Add("釲", "qnn");
            dic.Add("饲", "qnnk");
            dic.Add("鋦", "qnnk");
            dic.Add("饧", "qnnr");
            dic.Add("馔", "qnnw");
            dic.Add("鐉", "qnnw");
            dic.Add("炰", "qnou");
            dic.Add("馆", "qnp");
            dic.Add("饮", "qnq");
            dic.Add("馏", "qnql");
            dic.Add("饱", "qnqn");
            dic.Add("馋", "qnqu");
            dic.Add("馅", "qnqv");
            dic.Add("饭", "qnr");
            dic.Add("饩", "qnrn");
            dic.Add("钖", "qnrt");
            dic.Add("馇", "qns");
            dic.Add("饤", "qnsh");
            dic.Add("饿", "qnt");
            dic.Add("铋", "qnt");
            dic.Add("饦", "qnta");
            dic.Add("饫", "qntd");
            dic.Add("饪", "qntf");
            dic.Add("饰", "qnth");
            dic.Add("饷", "qntk");
            dic.Add("饹", "qntk");
            dic.Add("饬", "qntl");
            dic.Add("鉍", "qntt");
            dic.Add("", "qnty");
            dic.Add("饼", "qnu");
            dic.Add("馐", "qnuf");
            dic.Add("饺", "qnuq");
            dic.Add("馊", "qnvc");
            dic.Add("馀", "qnw");
            dic.Add("鏐", "qnwe");
            dic.Add("镠", "qnwe");
            dic.Add("饸", "qnwk");
            dic.Add("鈌", "qnwy");
            dic.Add("鑃", "qnwy");
            dic.Add("铌", "qnx");
            dic.Add("鈮", "qnxn");
            dic.Add("鈊", "qny");
            dic.Add("饻", "qnye");
            dic.Add("鉯", "qnyw");
            dic.Add("鈬", "qnyy");
            dic.Add("炙", "qo");
            dic.Add("鱯", "qoac");
            dic.Add("魽", "qoaf");
            dic.Add("鰹", "qoaf");
            dic.Add("魟", "qoag");
            dic.Add("鰙", "qoak");
            dic.Add("鰸", "qoak");
            dic.Add("鰳", "qoal");
            dic.Add("鮔", "qoan");
            dic.Add("鰈", "qoas");
            dic.Add("鱴", "qoat");
            dic.Add("鰋", "qoav");
            dic.Add("鯕", "qoaw");
            dic.Add("鱑", "qoaw");
            dic.Add("鱹", "qoay");
            dic.Add("鬯", "qob");
            dic.Add("鯫", "qobc");
            dic.Add("鯭", "qobl");
            dic.Add("鮿", "qobn");
            dic.Add("鑁", "qobt");
            dic.Add("魣", "qocb");
            dic.Add("鯒", "qoce");
            dic.Add("鯵", "qoce");
            dic.Add("鰺", "qoce");
            dic.Add("鰠", "qocj");
            dic.Add("鮐", "qock");
            dic.Add("鱊", "qock");
            dic.Add("鰇", "qocs");
            dic.Add("鮻", "qoct");
            dic.Add("鰢", "qocy");
            dic.Add("鮁", "qodc");
            dic.Add("鯡", "qodd");
            dic.Add("鮪", "qode");
            dic.Add("鰖", "qode");
            dic.Add("鰗", "qode");
            dic.Add("鮕", "qodg");
            dic.Add("鮖", "qodg");
            dic.Add("爒", "qodi");
            dic.Add("鮞", "qodj");
            dic.Add("鰆", "qodj");
            dic.Add("魷", "qodn");
            dic.Add("鮬", "qodn");
            dic.Add("鱤", "qodn");
            dic.Add("鯎", "qodt");
            dic.Add("鰄", "qodt");
            dic.Add("鰔", "qodt");
            dic.Add("鱖", "qodw");
            dic.Add("鱱", "qody");
            dic.Add("鰀", "qoec");
            dic.Add("鰩", "qoem");
            dic.Add("鱁", "qoep");
            dic.Add("鱫", "qoet");
            dic.Add("鮾", "qoev");
            dic.Add("魥", "qoey");
            dic.Add("魼", "qofc");
            dic.Add("鮭", "qoff");
            dic.Add("鯥", "qoff");
            dic.Add("鯐", "qofh");
            dic.Add("鮇", "qofi");
            dic.Add("鯺", "qofj");
            dic.Add("鰭", "qofj");
            dic.Add("鱬", "qofj");
            dic.Add("鮚", "qofk");
            dic.Add("鱚", "qofk");
            dic.Add("鰪", "qofl");
            dic.Add("鱩", "qofl");
            dic.Add("鱝", "qofm");
            dic.Add("鮳", "qofn");
            dic.Add("魭", "qofq");
            dic.Add("鱙", "qofq");
            dic.Add("鯪", "qoft");
            dic.Add("鱈", "qofv");
            dic.Add("鮱", "qofx");
            dic.Add("鯄", "qofy");
            dic.Add("镤", "qog");
            dic.Add("鯖", "qoge");
            dic.Add("鑆", "qogf");
            dic.Add("鱄", "qogf");
            dic.Add("魱", "qogg");
            dic.Add("魾", "qogg");
            dic.Add("魳", "qogh");
            dic.Add("鮃", "qogh");
            dic.Add("鯟", "qogi");
            dic.Add("鰊", "qogi");
            dic.Add("鯻", "qogj");
            dic.Add("鰽", "qogj");
            dic.Add("鯃", "qogk");
            dic.Add("鱷", "qogk");
            dic.Add("鰏", "qogl");
            dic.Add("鰿", "qogm");
            dic.Add("魨", "qogn");
            dic.Add("鯁", "qogq");
            dic.Add("鮧", "qogw");
            dic.Add("鱺", "qogx");
            dic.Add("鏷", "qogy");
            dic.Add("鯆", "qogy");
            dic.Add("鮍", "qohc");
            dic.Add("鱋", "qohg");
            dic.Add("鮛", "qohi");
            dic.Add("鮎", "qohk");
            dic.Add("鱸", "qohl");
            dic.Add("鯱", "qohm");
            dic.Add("鱥", "qoht");
            dic.Add("鰬", "qohy");
            dic.Add("匊", "qoi");
            dic.Add("灳", "qoi");
            dic.Add("鮹", "qoie");
            dic.Add("鱨", "qoij");
            dic.Add("鮡", "qoiq");
            dic.Add("魦", "qoit");
            dic.Add("鯋", "qoit");
            dic.Add("鰻", "qojc");
            dic.Add("魯", "qojf");
            dic.Add("鯉", "qojf");
            dic.Add("鰣", "qojf");
            dic.Add("鯹", "qojg");
            dic.Add("魝", "qojh");
            dic.Add("鯷", "qojh");
            dic.Add("鯧", "qojj");
            dic.Add("鱪", "qojj");
            dic.Add("鰛", "qojl");
            dic.Add("鰨", "qojn");
            dic.Add("鯣", "qojr");
            dic.Add("鰑", "qojr");
            dic.Add("鯤", "qojx");
            dic.Add("鰅", "qojy");
            dic.Add("鱓", "qokf");
            dic.Add("鰐", "qokn");
            dic.Add("鱢", "qoks");
            dic.Add("鯝", "qold");
            dic.Add("鰃", "qole");
            dic.Add("鱞", "qole");
            dic.Add("魻", "qolh");
            dic.Add("鰥", "qoli");
            dic.Add("鱰", "qolj");
            dic.Add("鮰", "qolk");
            dic.Add("鰮", "qoll");
            dic.Add("鰓", "qoln");
            dic.Add("鰱", "qolp");
            dic.Add("鮂", "qolw");
            dic.Add("鱡", "qomd");
            dic.Add("鮋", "qomg");
            dic.Add("鰂", "qomj");
            dic.Add("鮦", "qomk");
            dic.Add("鯛", "qomk");
            dic.Add("鰴", "qomt");
            dic.Add("鱧", "qomu");
            dic.Add("鱦", "qomv");
            dic.Add("魶", "qomw");
            dic.Add("鰕", "qonc");
            dic.Add("鱂", "qonf");
            dic.Add("鮙", "qong");
            dic.Add("鯴", "qonj");
            dic.Add("魢", "qonn");
            dic.Add("鰼", "qonr");
            dic.Add("鮅", "qont");
            dic.Add("锬", "qoo");
            dic.Add("鱗", "qooh");
            dic.Add("鐒", "qool");
            dic.Add("鑅", "qoos");
            dic.Add("錟", "qooy");
            dic.Add("鰘", "qopf");
            dic.Add("鰚", "qopg");
            dic.Add("鰰", "qoph");
            dic.Add("鯮", "qopi");
            dic.Add("鰫", "qopk");
            dic.Add("鯶", "qopl");
            dic.Add("魫", "qopq");
            dic.Add("鯇", "qopq");
            dic.Add("鮟", "qopv");
            dic.Add("鮀", "qopx");
            dic.Add("鮠", "qoqb");
            dic.Add("鮣", "qoqb");
            dic.Add("鱌", "qoqe");
            dic.Add("鏻", "qoqh");
            dic.Add("鯑", "qoqh");
            dic.Add("鮈", "qoqk");
            dic.Add("鰡", "qoql");
            dic.Add("鮑", "qoqn");
            dic.Add("鱻", "qoqo");
            dic.Add("鮸", "qoqq");
            dic.Add("魩", "qoqr");
            dic.Add("鯼", "qoqt");
            dic.Add("魡", "qoqy");
            dic.Add("魬", "qorc");
            dic.Add("鮊", "qorg");
            dic.Add("鰉", "qorg");
            dic.Add("鮢", "qori");
            dic.Add("鰁", "qori");
            dic.Add("鯯", "qorj");
            dic.Add("鮜", "qork");
            dic.Add("鯂", "qosg");
            dic.Add("鰾", "qosi");
            dic.Add("鱏", "qosj");
            dic.Add("魺", "qosk");
            dic.Add("鯠", "qosw");
            dic.Add("魠", "qota");
            dic.Add("鯚", "qotb");
            dic.Add("鮓", "qotf");
            dic.Add("鮏", "qotg");
            dic.Add("鯀", "qoti");
            dic.Add("鯏", "qotj");
            dic.Add("鮥", "qotk");
            dic.Add("鯌", "qotk");
            dic.Add("鯦", "qotk");
            dic.Add("鱎", "qotk");
            dic.Add("鱕", "qotl");
            dic.Add("魸", "qotn");
            dic.Add("魹", "qotn");
            dic.Add("鰍", "qoto");
            dic.Add("鯅", "qotp");
            dic.Add("鯓", "qott");
            dic.Add("鰒", "qott");
            dic.Add("鱵", "qott");
            dic.Add("鮗", "qotu");
            dic.Add("鯘", "qotv");
            dic.Add("穌", "qoty");
            dic.Add("魞", "qoty");
            dic.Add("魚", "qou");
            dic.Add("鮩", "qoua");
            dic.Add("鮮", "qoud");
            dic.Add("鱶", "qoue");
            dic.Add("鱃", "qouf");
            dic.Add("鱒", "qouf");
            dic.Add("鰌", "qoug");
            dic.Add("鱆", "qouj");
            dic.Add("鱛", "qouj");
            dic.Add("鱔", "qouk");
            dic.Add("鰜", "qouo");
            dic.Add("鮫", "qouq");
            dic.Add("鮵", "qouq");
            dic.Add("鮷", "qout");
            dic.Add("鯜", "qouv");
            dic.Add("鰦", "qoux");
            dic.Add("鰟", "qouy");
            dic.Add("镂", "qov");
            dic.Add("鯽", "qovb");
            dic.Add("鮼", "qovc");
            dic.Add("鱘", "qovf");
            dic.Add("鯞", "qovh");
            dic.Add("鱐", "qovh");
            dic.Add("鮉", "qovk");
            dic.Add("鮶", "qovk");
            dic.Add("鯔", "qovl");
            dic.Add("魛", "qovn");
            dic.Add("鱲", "qovn");
            dic.Add("鰎", "qovp");
            dic.Add("鯢", "qovq");
            dic.Add("鱮", "qovw");
            dic.Add("鮘", "qowa");
            dic.Add("鯩", "qowa");
            dic.Add("魿", "qowc");
            dic.Add("鱍", "qowc");
            dic.Add("鮲", "qowd");
            dic.Add("鯸", "qowd");
            dic.Add("鮒", "qowf");
            dic.Add("鰤", "qowh");
            dic.Add("鰶", "qowi");
            dic.Add("魪", "qowj");
            dic.Add("鱠", "qowj");
            dic.Add("鮯", "qowk");
            dic.Add("鯰", "qown");
            dic.Add("鰞", "qowo");
            dic.Add("鵴", "qowo");
            dic.Add("鷠", "qowo");
            dic.Add("鯾", "qowq");
            dic.Add("鮴", "qows");
            dic.Add("鰷", "qows");
            dic.Add("鮽", "qowt");
            dic.Add("魵", "qowv");
            dic.Add("魤", "qowx");
            dic.Add("魜", "qowy");
            dic.Add("鱜", "qoxb");
            dic.Add("鮄", "qoxj");
            dic.Add("鮨", "qoxj");
            dic.Add("鱳", "qoxs");
            dic.Add("鰯", "qoxu");
            dic.Add("魮", "qoxx");
            dic.Add("钬", "qoy");
            dic.Add("鈥", "qoy");
            dic.Add("銤", "qoy");
            dic.Add("鯿", "qoya");
            dic.Add("鯙", "qoyb");
            dic.Add("鱭", "qoyf");
            dic.Add("鱣", "qoyg");
            dic.Add("鱅", "qoyh");
            dic.Add("鯨", "qoyi");
            dic.Add("鱇", "qoyi");
            dic.Add("鰝", "qoyk");
            dic.Add("魧", "qoym");
            dic.Add("魲", "qoyn");
            dic.Add("魴", "qoyn");
            dic.Add("鯍", "qoyq");
            dic.Add("鯲", "qoyu");
            dic.Add("鮌", "qoyx");
            dic.Add("魰", "qoyy");
            dic.Add("鯳", "qoyy");
            dic.Add("锭", "qp");
            dic.Add("鑧", "qpay");
            dic.Add("鋐", "qpdc");
            dic.Add("鎋", "qpdk");
            dic.Add("镓", "qpe");
            dic.Add("鎵", "qpey");
            dic.Add("鑳", "qpfh");
            dic.Add("錝", "qpfi");
            dic.Add("鋎", "qpfq");
            dic.Add("鍹", "qpgg");
            dic.Add("錠", "qpgh");
            dic.Add("鑌", "qpgm");
            dic.Add("夤", "qpgw");
            dic.Add("鏔", "qpgw");
            dic.Add("鍕", "qplh");
            dic.Add("錧", "qpnn");
            dic.Add("鑏", "qpns");
            dic.Add("鋺", "qpqb");
            dic.Add("鈂", "qpqn");
            dic.Add("镔", "qpr");
            dic.Add("铵", "qpv");
            dic.Add("銨", "qpvg");
            dic.Add("镩", "qpw");
            dic.Add("镲", "qpwi");
            dic.Add("鑔", "qpwi");
            dic.Add("鏥", "qpwj");
            dic.Add("镕", "qpwk");
            dic.Add("鎔", "qpwk");
            dic.Add("鑹", "qpwn");
            dic.Add("铊", "qpx");
            dic.Add("鉈", "qpxn");
            dic.Add("鎺", "qpyg");
            dic.Add("多", "qq");
            dic.Add("錉", "qqaj");
            dic.Add("銽", "qqak");
            dic.Add("匈", "qqb");
            dic.Add("胷", "qqbe");
            dic.Add("卶", "qqbh");
            dic.Add("鍐", "qqbt");
            dic.Add("钩", "qqc");
            dic.Add("铯", "qqcn");
            dic.Add("銫", "qqcn");
            dic.Add("鈎", "qqcy");
            dic.Add("爼", "qqeg");
            dic.Add("夡", "qqfk");
            dic.Add("镥", "qqg");
            dic.Add("鍂", "qqg");
            dic.Add("铄", "qqi");
            dic.Add("匁", "qqi");
            dic.Add("匇", "qqi");
            dic.Add("鉨", "qqiy");
            dic.Add("鐌", "qqje");
            dic.Add("銁", "qqjg");
            dic.Add("铭", "qqk");
            dic.Add("鉤", "qqkg");
            dic.Add("銘", "qqkg");
            dic.Add("鋔", "qqkq");
            dic.Add("鑱", "qqky");
            dic.Add("镵", "qqky");
            dic.Add("钨", "qqn");
            dic.Add("翗", "qqng");
            dic.Add("鉋", "qqnn");
            dic.Add("铇", "qqnn");
            dic.Add("鑥", "qqoj");
            dic.Add("迻", "qqpi");
            dic.Add("鑫", "qqq");
            dic.Add("夠", "qqqk");
            dic.Add("鉹", "qqqy");
            dic.Add("锪", "qqr");
            dic.Add("鋾", "qqrm");
            dic.Add("鍃", "qqrn");
            dic.Add("鍯", "qqrn");
            dic.Add("铩", "qqs");
            dic.Add("鎩", "qqsc");
            dic.Add("铆", "qqt");
            dic.Add("鉚", "qqtb");
            dic.Add("爻", "qqu");
            dic.Add("钧", "qqug");
            dic.Add("鈞", "qqug");
            dic.Add("憌", "qqun");
            dic.Add("铮", "qqv");
            dic.Add("郺", "qqvc");
            dic.Add("錎", "qqvg");
            dic.Add("錚", "qqvh");
            dic.Add("钦", "qqw");
            dic.Add("欽", "qqwy");
            dic.Add("钓", "qqy");
            dic.Add("釸", "qqy");
            dic.Add("鍧", "qqyg");
            dic.Add("镏", "qqyl");
            dic.Add("鎦", "qqyl");
            dic.Add("釣", "qqyy");
            dic.Add("铁", "qr");
            dic.Add("钣", "qrc");
            dic.Add("鈑", "qrcy");
            dic.Add("鈲", "qrcy");
            dic.Add("勿", "qre");
            dic.Add("甮", "qrej");
            dic.Add("鍎", "qrfh");
            dic.Add("锧", "qrfm");
            dic.Add("铂", "qrg");
            dic.Add("鉑", "qrg");
            dic.Add("鍠", "qrgg");
            dic.Add("锽", "qrgg");
            dic.Add("銗", "qrgk");
            dic.Add("鋲", "qrgw");
            dic.Add("釿", "qrh");
            dic.Add("鈝", "qrhh");
            dic.Add("釽", "qrhy");
            dic.Add("铢", "qri");
            dic.Add("銖", "qriy");
            dic.Add("刎", "qrj");
            dic.Add("曶", "qrjf");
            dic.Add("锦", "qrm");
            dic.Add("錦", "qrmh");
            dic.Add("匋", "qrmk");
            dic.Add("遙", "qrmp");
            dic.Add("忽", "qrn");
            dic.Add("鎎", "qrno");
            dic.Add("兜", "qrnq");
            dic.Add("锨", "qrq");
            dic.Add("鍁", "qrqw");
            dic.Add("鑕", "qrrm");
            dic.Add("錍", "qrtf");
            dic.Add("鉄", "qrwy");
            dic.Add("匆", "qry");
            dic.Add("怱", "qryn");
            dic.Add("钉", "qs");
            dic.Add("弑", "qsa");
            dic.Add("镖", "qsf");
            dic.Add("鏢", "qsfi");
            dic.Add("钵", "qsg");
            dic.Add("鉢", "qsgg");
            dic.Add("釘", "qsh");
            dic.Add("刹", "qsj");
            dic.Add("镡", "qsj");
            dic.Add("鐔", "qsjh");
            dic.Add("钶", "qsk");
            dic.Add("鈳", "qskg");
            dic.Add("鎶", "qskk");
            dic.Add("殺", "qsmc");
            dic.Add("錰", "qsoy");
            dic.Add("鑻", "qsqr");
            dic.Add("杀", "qsu");
            dic.Add("閷", "qsuw");
            dic.Add("錸", "qsww");
            dic.Add("鈢", "qsy");
            dic.Add("弒", "qsya");
            dic.Add("剎", "qsyj");
            dic.Add("鉥", "qsyy");
            dic.Add("儿", "qt");
            dic.Add("猎", "qta");
            dic.Add("獲", "qtac");
            dic.Add("狨", "qtad");
            dic.Add("獏", "qtad");
            dic.Add("獴", "qtae");
            dic.Add("猫", "qtal");
            dic.Add("獦", "qtan");
            dic.Add("玂", "qtar");
            dic.Add("犽", "qtat");
            dic.Add("狘", "qtat");
            dic.Add("猉", "qtaw");
            dic.Add("獚", "qtaw");
            dic.Add("獾", "qtay");
            dic.Add("犯", "qtb");
            dic.Add("卯", "qtbh");
            dic.Add("狲", "qtbi");
            dic.Add("猻", "qtbi");
            dic.Add("猛", "qtbl");
            dic.Add("乮", "qtbn");
            dic.Add("犼", "qtbn");
            dic.Add("鉇", "qtbn");
            dic.Add("狁", "qtc");
            dic.Add("犸", "qtcg");
            dic.Add("獝", "qtck");
            dic.Add("猱", "qtcs");
            dic.Add("狻", "qtct");
            dic.Add("獁", "qtcy");
            dic.Add("锋", "qtd");
            dic.Add("猅", "qtdd");
            dic.Add("猰", "qtdd");
            dic.Add("猢", "qtde");
            dic.Add("狵", "qtde");
            dic.Add("狜", "qtdg");
            dic.Add("銛", "qtdg");
            dic.Add("铦", "qtdg");
            dic.Add("鋒", "qtdh");
            dic.Add("獠", "qtdi");
            dic.Add("獂", "qtdi");
            dic.Add("鑙", "qtdj");
            dic.Add("猗", "qtdk");
            dic.Add("鐈", "qtdk");
            dic.Add("犹", "qtdn");
            dic.Add("懖", "qtdn");
            dic.Add("鏠", "qtdp");
            dic.Add("獉", "qtdt");
            dic.Add("獶", "qtdt");
            dic.Add("獿", "qtdt");
            dic.Add("獗", "qtdw");
            dic.Add("狹", "qtdw");
            dic.Add("犾", "qtdy");
            dic.Add("鉃", "qtdy");
            dic.Add("犭", "qte");
            dic.Add("猨", "qtec");
            dic.Add("狙", "qteg");
            dic.Add("猙", "qteh");
            dic.Add("猺", "qtem");
            dic.Add("锈", "qten");
            dic.Add("銹", "qten");
            dic.Add("钎", "qtf");
            dic.Add("铥", "qtfc");
            dic.Add("銩", "qtfc");
            dic.Add("猿", "qtfe");
            dic.Add("鈓", "qtfg");
            dic.Add("犴", "qtfh");
            dic.Add("釺", "qtfh");
            dic.Add("狋", "qtfi");
            dic.Add("猪", "qtfj");
            dic.Add("獳", "qtfj");
            dic.Add("锆", "qtfk");
            dic.Add("狤", "qtfk");
            dic.Add("鋯", "qtfk");
            dic.Add("獖", "qtfm");
            dic.Add("鑽", "qtfm");
            dic.Add("铤", "qtfp");
            dic.Add("鋌", "qtfp");
            dic.Add("铣", "qtfq");
            dic.Add("獟", "qtfq");
            dic.Add("銑", "qtfq");
            dic.Add("橥", "qtfs");
            dic.Add("犲", "qtft");
            dic.Add("锸", "qtfv");
            dic.Add("鍤", "qtfv");
            dic.Add("狫", "qtfx");
            dic.Add("狂", "qtg");
            dic.Add("锺", "qtg");
            dic.Add("猜", "qtge");
            dic.Add("锤", "qtgf");
            dic.Add("猼", "qtgf");
            dic.Add("錘", "qtgf");
            dic.Add("鍾", "qtgf");
            dic.Add("夝", "qtgg");
            dic.Add("狉", "qtgg");
            dic.Add("狟", "qtgg");
            dic.Add("鉎", "qtgg");
            dic.Add("犻", "qtgh");
            dic.Add("鏼", "qtgi");
            dic.Add("獭", "qtgm");
            dic.Add("獺", "qtgm");
            dic.Add("钅", "qtgn");
            dic.Add("鑂", "qtgo");
            dic.Add("鵟", "qtgo");
            dic.Add("逛", "qtgp");
            dic.Add("獮", "qtgq");
            dic.Add("獓", "qtgt");
            dic.Add("狭", "qtgw");
            dic.Add("镍", "qth");
            dic.Add("狓", "qthc");
            dic.Add("玃", "qthc");
            dic.Add("鈼", "qthf");
            dic.Add("獹", "qthl");
            dic.Add("猇", "qthm");
            dic.Add("鎴", "qthn");
            dic.Add("鋋", "qthp");
            dic.Add("鎳", "qths");
            dic.Add("獩", "qtht");
            dic.Add("猟", "qtih");
            dic.Add("狣", "qtiq");
            dic.Add("猀", "qtit");
            dic.Add("独", "qtj");
            dic.Add("獌", "qtjc");
            dic.Add("狸", "qtjf");
            dic.Add("猂", "qtjf");
            dic.Add("猩", "qtjg");
            dic.Add("狚", "qtjg");
            dic.Add("狮", "qtjh");
            dic.Add("鋓", "qtjh");
            dic.Add("猖", "qtjj");
            dic.Add("猲", "qtjn");
            dic.Add("猓", "qtjs");
            dic.Add("鏫", "qtjs");
            dic.Add("鍑", "qtjt");
            dic.Add("猑", "qtjx");
            dic.Add("铬", "qtk");
            dic.Add("狷", "qtke");
            dic.Add("鉻", "qtkg");
            dic.Add("狆", "qtkh");
            dic.Add("玁", "qtkt");
            dic.Add("狎", "qtl");
            dic.Add("猥", "qtl");
            dic.Add("猬", "qtle");
            dic.Add("獧", "qtle");
            dic.Add("獨", "qtlj");
            dic.Add("鏓", "qtln");
            dic.Add("猡", "qtlq");
            dic.Add("獑", "qtlr");
            dic.Add("鎞", "qtlx");
            dic.Add("玀", "qtly");
            dic.Add("猾", "qtm");
            dic.Add("鐭", "qtmd");
            dic.Add("鉓", "qtmh");
            dic.Add("狦", "qtmj");
            dic.Add("猦", "qtmj");
            dic.Add("猯", "qtmj");
            dic.Add("匔", "qtmk");
            dic.Add("狪", "qtmk");
            dic.Add("猧", "qtmk");
            dic.Add("銄", "qtmk");
            dic.Add("鋵", "qtmn");
            dic.Add("銵", "qtmt");
            dic.Add("鎫", "qtmt");
            dic.Add("猠", "qtmw");
            dic.Add("匑", "qtmx");
            dic.Add("狈", "qtmy");
            dic.Add("狽", "qtmy");
            dic.Add("獕", "qtmy");
            dic.Add("勹", "qtn");
            dic.Add("", "qtn");
            dic.Add("猳", "qtnc");
            dic.Add("狃", "qtnf");
            dic.Add("猸", "qtnh");
            dic.Add("峱", "qtnm");
            dic.Add("釳", "qtnn");
            dic.Add("狔", "qtnx");
            dic.Add("夕", "qtny");
            dic.Add("锹", "qto");
            dic.Add("獜", "qtoh");
            dic.Add("鐇", "qtol");
            dic.Add("悐", "qton");
            dic.Add("鏭", "qton");
            dic.Add("逖", "qtop");
            dic.Add("狄", "qtoy");
            dic.Add("獛", "qtoy");
            dic.Add("鍬", "qtoy");
            dic.Add("狞", "qtp");
            dic.Add("狩", "qtpf");
            dic.Add("猔", "qtpi");
            dic.Add("獱", "qtpm");
            dic.Add("獰", "qtps");
            dic.Add("猽", "qtpu");
            dic.Add("狖", "qtpw");
            dic.Add("狗", "qtq");
            dic.Add("獬", "qtq");
            dic.Add("狰", "qtqh");
            dic.Add("狶", "qtqh");
            dic.Add("狝", "qtqi");
            dic.Add("鑗", "qtqi");
            dic.Add("狥", "qtqj");
            dic.Add("狍", "qtqn");
            dic.Add("猣", "qtqt");
            dic.Add("犳", "qtqy");
            dic.Add("狐", "qtr");
            dic.Add("猈", "qtrf");
            dic.Add("獆", "qtrf");
            dic.Add("獔", "qtrf");
            dic.Add("狛", "qtrg");
            dic.Add("猘", "qtrj");
            dic.Add("狾", "qtrr");
            dic.Add("锇", "qtrt");
            dic.Add("獥", "qtrt");
            dic.Add("鋨", "qtrt");
            dic.Add("猹", "qts");
            dic.Add("猍", "qtsw");
            dic.Add("狇", "qtsy");
            dic.Add("猁", "qtt");
            dic.Add("狏", "qttb");
            dic.Add("狧", "qttd");
            dic.Add("狅", "qttf");
            dic.Add("獋", "qttf");
            dic.Add("狌", "qttg");
            dic.Add("狢", "qttk");
            dic.Add("獢", "qttk");
            dic.Add("犵", "qttn");
            dic.Add("獯", "qtto");
            dic.Add("狿", "qttp");
            dic.Add("狡", "qtu");
            dic.Add("獍", "qtu");
            dic.Add("獇", "qtuc");
            dic.Add("獞", "qtuf");
            dic.Add("猶", "qtug");
            dic.Add("獐", "qtuj");
            dic.Add("獈", "qtul");
            dic.Add("猐", "qtun");
            dic.Add("獙", "qtut");
            dic.Add("鉖", "qtuy");
            dic.Add("狠", "qtv");
            dic.Add("卿", "qtvb");
            dic.Add("獀", "qtvc");
            dic.Add("錗", "qtvg");
            dic.Add("犰", "qtvn");
            dic.Add("獵", "qtvn");
            dic.Add("獡", "qtvo");
            dic.Add("猊", "qtvq");
            dic.Add("犱", "qtvy");
            dic.Add("猴", "qtw");
            dic.Add("狯", "qtwc");
            dic.Add("狑", "qtwc");
            dic.Add("猤", "qtwd");
            dic.Add("獅", "qtwh");
            dic.Add("鏦", "qtwh");
            dic.Add("猃", "qtwi");
            dic.Add("獪", "qtwj");
            dic.Add("猞", "qtwk");
            dic.Add("獊", "qtwk");
            dic.Add("狳", "qtwt");
            dic.Add("獫", "qtww");
            dic.Add("猚", "qtwy");
            dic.Add("狒", "qtx");
            dic.Add("猭", "qtxe");
            dic.Add("狴", "qtxf");
            dic.Add("猕", "qtxi");
            dic.Add("狕", "qtxl");
            dic.Add("獼", "qtxq");
            dic.Add("鋂", "qtxu");
            dic.Add("狼", "qty");
            dic.Add("乂", "qty");
            dic.Add("鉌", "qty");
            dic.Add("猵", "qtya");
            dic.Add("狱", "qtyd");
            dic.Add("獄", "qtyd");
            dic.Add("猏", "qtye");
            dic.Add("獽", "qtye");
            dic.Add("猝", "qtyf");
            dic.Add("狺", "qtyg");
            dic.Add("釒", "qtyg");
            dic.Add("犿", "qtyh");
            dic.Add("猄", "qtyi");
            dic.Add("犺", "qtym");
            dic.Add("鸑", "qtyo");
            dic.Add("犷", "qtyt");
            dic.Add("獤", "qtyt");
            dic.Add("獷", "qtyw");
            dic.Add("釞", "qtyy");
            dic.Add("匀", "qu");
            dic.Add("鉼", "quah");
            dic.Add("鎙", "qube");
            dic.Add("鎈", "quda");
            dic.Add("锩", "qudb");
            dic.Add("錈", "qudb");
            dic.Add("鐥", "qudk");
            dic.Add("", "qudk");
            dic.Add("錓", "qudn");
            dic.Add("鎹", "qudp");
            dic.Add("鑨", "qued");
            dic.Add("鐗", "queg");
            dic.Add("鎆", "quej");
            dic.Add("鐩", "quep");
            dic.Add("钭", "quf");
            dic.Add("斘", "qufh");
            dic.Add("鈄", "qufh");
            dic.Add("鉡", "qufh");
            dic.Add("镁", "qug");
            dic.Add("鉝", "qug");
            dic.Add("鍆", "qug");
            dic.Add("锎", "quga");
            dic.Add("鐦", "quga");
            dic.Add("鎂", "qugd");
            dic.Add("镧", "qugi");
            dic.Add("鑭", "qugi");
            dic.Add("锌", "quh");
            dic.Add("鋅", "quh");
            dic.Add("镜", "quj");
            dic.Add("鐘", "qujf");
            dic.Add("锏", "qujg");
            dic.Add("鐧", "qujg");
            dic.Add("鏱", "qujh");
            dic.Add("镱", "qujn");
            dic.Add("鐿", "qujn");
            dic.Add("鏡", "qujq");
            dic.Add("锐", "quk");
            dic.Add("锫", "qukg");
            dic.Add("錇", "qukg");
            dic.Add("鋭", "qukq");
            dic.Add("鏳", "qulj");
            dic.Add("镝", "qum");
            dic.Add("鏑", "qumd");
            dic.Add("钔", "qun");
            dic.Add("镨", "quo");
            dic.Add("鐠", "quoj");
            dic.Add("镑", "qup");
            dic.Add("鍗", "quph");
            dic.Add("鎊", "qupy");
            dic.Add("铰", "quq");
            dic.Add("锵", "quqf");
            dic.Add("鉸", "quqy");
            dic.Add("鐏", "qusf");
            dic.Add("铲", "qut");
            dic.Add("鏟", "qutg");
            dic.Add("鎌", "quvo");
            dic.Add("镒", "quw");
            dic.Add("鎰", "quwl");
            dic.Add("锑", "qux");
            dic.Add("鉳", "quxn");
            dic.Add("銻", "quxt");
            dic.Add("鎡", "quxx");
            dic.Add("镃", "quxx");
            dic.Add("争", "qv");
            dic.Add("鐞", "qvaf");
            dic.Add("邹", "qvb");
            dic.Add("匓", "qvcc");
            dic.Add("银", "qve");
            dic.Add("銀", "qvey");
            dic.Add("刍", "qvf");
            dic.Add("臽", "qvf");
            dic.Add("銉", "qvfh");
            dic.Add("鏽", "qvfj");
            dic.Add("键", "qvfp");
            dic.Add("鍵", "qvfp");
            dic.Add("钕", "qvg");
            dic.Add("釹", "qvg");
            dic.Add("锼", "qvh");
            dic.Add("皱", "qvhc");
            dic.Add("鎪", "qvhc");
            dic.Add("録", "qviy");
            dic.Add("鏁", "qvjs");
            dic.Add("铷", "qvk");
            dic.Add("鉊", "qvkg");
            dic.Add("銣", "qvkg");
            dic.Add("锱", "qvl");
            dic.Add("錙", "qvlg");
            dic.Add("鑞", "qvln");
            dic.Add("镴", "qvln");
            dic.Add("鎻", "qvmy");
            dic.Add("急", "qvn");
            dic.Add("釖", "qvn");
            dic.Add("釚", "qvn");
            dic.Add("燄", "qvoo");
            dic.Add("锓", "qvp");
            dic.Add("鋟", "qvpc");
            dic.Add("鹐", "qvqg");
            dic.Add("欿", "qvqw");
            dic.Add("煞", "qvt");
            dic.Add("勼", "qvv");
            dic.Add("雏", "qvw");
            dic.Add("鵮", "qvwo");
            dic.Add("釰", "qvyy");
            dic.Add("釻", "qvyy");
            dic.Add("釼", "qvyy");
            dic.Add("欠", "qw");
            dic.Add("鎓", "qwcn");
            dic.Add("鈆", "qwcy");
            dic.Add("锻", "qwd");
            dic.Add("鍛", "qwdc");
            dic.Add("鉁", "qwet");
            dic.Add("鉜", "qwfy");
            dic.Add("铨", "qwg");
            dic.Add("錀", "qwga");
            dic.Add("鑰", "qwga");
            dic.Add("鍨", "qwgd");
            dic.Add("銓", "qwgg");
            dic.Add("鍮", "qwgj");
            dic.Add("铪", "qwgk");
            dic.Add("匌", "qwgk");
            dic.Add("鉿", "qwgk");
            dic.Add("镎", "qwgr");
            dic.Add("鎿", "qwgr");
            dic.Add("镫", "qwgu");
            dic.Add("鐙", "qwgu");
            dic.Add("鐱", "qwgw");
            dic.Add("鎀", "qwhe");
            dic.Add("鏅", "qwhe");
            dic.Add("勽", "qwi");
            dic.Add("鉩", "qwiy");
            dic.Add("銳", "qwkq");
            dic.Add("鍭", "qwnd");
            dic.Add("鎢", "qwno");
            dic.Add("鎚", "qwnp");
            dic.Add("匃", "qwnv");
            dic.Add("銝", "qwsy");
            dic.Add("銋", "qwtf");
            dic.Add("鈖", "qwvn");
            dic.Add("鵭", "qwvo");
            dic.Add("锉", "qww");
            dic.Add("銼", "qwwf");
            dic.Add("鑯", "qwwg");
            dic.Add("鋊", "qwwk");
            dic.Add("铧", "qwx");
            dic.Add("鏺", "qwxc");
            dic.Add("鈋", "qwxn");
            dic.Add("锥", "qwy");
            dic.Add("镌", "qwy");
            dic.Add("釟", "qwy");
            dic.Add("铃", "qwyc");
            dic.Add("鈴", "qwyc");
            dic.Add("飧", "qwye");
            dic.Add("鎸", "qwye");
            dic.Add("鎨", "qwyf");
            dic.Add("錐", "qwyg");
            dic.Add("鋡", "qwyk");
            dic.Add("鎗", "qwyk");
            dic.Add("鐫", "qwym");
            dic.Add("钤", "qwyn");
            dic.Add("鈐", "qwyn");
            dic.Add("錜", "qwyn");
            dic.Add("鐎", "qwyo");
            dic.Add("鏶", "qwys");
            dic.Add("镄", "qx");
            dic.Add("鐑", "qxfk");
            dic.Add("鏆", "qxfm");
            dic.Add("錄", "qxgi");
            dic.Add("鉧", "qxgu");
            dic.Add("鈏", "qxhh");
            dic.Add("鈟", "qxhh");
            dic.Add("鎭", "qxhw");
            dic.Add("銯", "qxiy");
            dic.Add("鉘", "qxjh");
            dic.Add("鐨", "qxjm");
            dic.Add("镪", "qxk");
            dic.Add("鏹", "qxkj");
            dic.Add("鑠", "qxrs");
            dic.Add("匂", "qxv");
            dic.Add("锴", "qxx");
            dic.Add("鈚", "qxxn");
            dic.Add("鍇", "qxxr");
            dic.Add("鐖", "qxxt");
            dic.Add("久", "qy");
            dic.Add("镀", "qya");
            dic.Add("鍍", "qyac");
            dic.Add("鏣", "qyao");
            dic.Add("鑛", "qyaw");
            dic.Add("镦", "qyb");
            dic.Add("錞", "qybg");
            dic.Add("鐓", "qybt");
            dic.Add("铳", "qyc");
            dic.Add("錥", "qyce");
            dic.Add("锍", "qycq");
            dic.Add("銃", "qycq");
            dic.Add("鋶", "qycq");
            dic.Add("鉱", "qycy");
            dic.Add("訇", "qyd");
            dic.Add("铱", "qye");
            dic.Add("锿", "qye");
            dic.Add("銥", "qyey");
            dic.Add("鎄", "qyey");
            dic.Add("鉒", "qygg");
            dic.Add("勺", "qyi");
            dic.Add("夊", "qyi");
            dic.Add("鍄", "qyiy");
            dic.Add("鑇", "qyjg");
            dic.Add("镶", "qyk");
            dic.Add("鑲", "qyke");
            dic.Add("镐", "qym");
            dic.Add("铈", "qymh");
            dic.Add("鈰", "qymh");
            dic.Add("鎬", "qymk");
            dic.Add("钪", "qymn");
            dic.Add("鈧", "qymn");
            dic.Add("钫", "qyn");
            dic.Add("凫", "qyn");
            dic.Add("鈁", "qyn");
            dic.Add("鍽", "qyna");
            dic.Add("鹱", "qync");
            dic.Add("錑", "qynd");
            dic.Add("袅", "qyne");
            dic.Add("鸟", "qyng");
            dic.Add("岛", "qynm");
            dic.Add("釯", "qynn");
            dic.Add("", "qynn");
            dic.Add("", "qynn");
            dic.Add("镳", "qyno");
            dic.Add("鑣", "qyno");
            dic.Add("枭", "qyns");
            dic.Add("鈩", "qynt");
            dic.Add("匄", "qynv");
            dic.Add("鸵", "qynx");
            dic.Add("鏕", "qynx");
            dic.Add("麁", "qynx");
            dic.Add("灸", "qyo");
            dic.Add("粂", "qyou");
            dic.Add("卵", "qyt");
            dic.Add("孵", "qytb");
            dic.Add("鍦", "qytb");
            dic.Add("毈", "qytc");
            dic.Add("镞", "qytd");
            dic.Add("鏃", "qytd");
            dic.Add("镟", "qyth");
            dic.Add("銂", "qyth");
            dic.Add("鏇", "qyth");
            dic.Add("贕", "qytm");
            dic.Add("邎", "qytp");
            dic.Add("镰", "qyu");
            dic.Add("鐮", "qyuo");
            dic.Add("贸", "qyv");
            dic.Add("鄮", "qyvb");
            dic.Add("鎯", "qyvb");
            dic.Add("锒", "qyve");
            dic.Add("鋃", "qyve");
            dic.Add("鹠", "qyvg");
            dic.Add("镛", "qyvh");
            dic.Add("鏞", "qyvh");
            dic.Add("鏮", "qyvi");
            dic.Add("劉", "qyvj");
            dic.Add("鎕", "qyvk");
            dic.Add("留", "qyvl");
            dic.Add("貿", "qyvm");
            dic.Add("鶹", "qyvo");
            dic.Add("遛", "qyvp");
            dic.Add("斵", "qyvr");
            dic.Add("錊", "qywf");
            dic.Add("铉", "qyx");
            dic.Add("鏲", "qyxh");
            dic.Add("鉉", "qyxy");
            dic.Add("鈫", "qyy");
            dic.Add("的", "r");
            dic.Add("白", "r");
            dic.Add("找", "ra");
            dic.Add("拭", "raa");
            dic.Add("擛", "raas");
            dic.Add("皂", "rab");
            dic.Add("搑", "rabg");
            dic.Add("撕", "rad");
            dic.Add("掿", "radk");
            dic.Add("揕", "radn");
            dic.Add("掑", "radw");
            dic.Add("撒", "rae");
            dic.Add("拑", "rafg");
            dic.Add("擆", "rafj");
            dic.Add("扛", "rag");
            dic.Add("撶", "ragf");
            dic.Add("皣", "ragf");
            dic.Add("捓", "rahb");
            dic.Add("摼", "rahf");
            dic.Add("挋", "rahh");
            dic.Add("攬", "rahq");
            dic.Add("擓", "raiy");
            dic.Add("措", "raj");
            dic.Add("摸", "rajd");
            dic.Add("擖", "rajn");
            dic.Add("揠", "rajv");
            dic.Add("掝", "rakg");
            dic.Add("摳", "rakk");
            dic.Add("擹", "rakw");
            dic.Add("攤", "raky");
            dic.Add("描", "ral");
            dic.Add("撗", "ramw");
            dic.Add("摃", "ramy");
            dic.Add("拒", "ran");
            dic.Add("抴", "rann");
            dic.Add("揲", "rans");
            dic.Add("拣", "ranw");
            dic.Add("捞", "rap");
            dic.Add("抠", "raq");
            dic.Add("摕", "raqh");
            dic.Add("撍", "raqj");
            dic.Add("擏", "raqt");
            dic.Add("挠", "ratq");
            dic.Add("拱", "raw");
            dic.Add("擭", "rawc");
            dic.Add("攃", "rawi");
            dic.Add("搭", "rawk");
            dic.Add("搽", "raws");
            dic.Add("报", "rb");
            dic.Add("揶", "rbb");
            dic.Add("攝", "rbbb");
            dic.Add("摄", "rbcc");
            dic.Add("掫", "rbcy");
            dic.Add("撱", "rbde");
            dic.Add("挕", "rbg");
            dic.Add("邤", "rbh");
            dic.Add("拯", "rbi");
            dic.Add("摂", "rbiy");
            dic.Add("掹", "rblg");
            dic.Add("拙", "rbm");
            dic.Add("扡", "rbn");
            dic.Add("搎", "rbti");
            dic.Add("反", "rc");
            dic.Add("拚", "rca");
            dic.Add("抒", "rcb");
            dic.Add("揉", "rcbs");
            dic.Add("掇", "rcc");
            dic.Add("摻", "rcce");
            dic.Add("撡", "rccn");
            dic.Add("搡", "rccs");
            dic.Add("", "rccy");
            dic.Add("掺", "rcd");
            dic.Add("撪", "rcdl");
            dic.Add("捅", "rce");
            dic.Add("择", "rcf");
            dic.Add("掻", "rcjy");
            dic.Add("抬", "rck");
            dic.Add("把", "rcn");
            dic.Add("皅", "rcn");
            dic.Add("返", "rcp");
            dic.Add("抁", "rcqn");
            dic.Add("挨", "rct");
            dic.Add("摊", "rcw");
            dic.Add("捘", "rcwt");
            dic.Add("瓜", "rcy");
            dic.Add("払", "rcy");
            dic.Add("搔", "rcyj");
            dic.Add("瓥", "rcyj");
            dic.Add("瓟", "rcyn");
            dic.Add("瓞", "rcyw");
            dic.Add("扠", "rcyy");
            dic.Add("瓝", "rcyy");
            dic.Add("拓", "rd");
            dic.Add("扼", "rdb");
            dic.Add("拔", "rdc");
            dic.Add("抜", "rdcy");
            dic.Add("擾", "rdet");
            dic.Add("掁", "rdey");
            dic.Add("振", "rdf");
            dic.Add("翱", "rdf");
            dic.Add("捹", "rdfa");
            dic.Add("捱", "rdff");
            dic.Add("搙", "rdff");
            dic.Add("拜", "rdfh");
            dic.Add("拝", "rdfh");
            dic.Add("捺", "rdfi");
            dic.Add("皋", "rdfj");
            dic.Add("撦", "rdfj");
            dic.Add("挎", "rdfn");
            dic.Add("鷎", "rdfo");
            dic.Add("摦", "rdfy");
            dic.Add("撼", "rdgn");
            dic.Add("揻", "rdgt");
            dic.Add("搣", "rdgt");
            dic.Add("拵", "rdhb");
            dic.Add("揳", "rdhd");
            dic.Add("摵", "rdht");
            dic.Add("揼", "rdiy");
            dic.Add("排", "rdj");
            dic.Add("擫", "rdjd");
            dic.Add("掩", "rdjn");
            dic.Add("颀", "rdm");
            dic.Add("抪", "rdmh");
            dic.Add("頎", "rdmy");
            dic.Add("扰", "rdn");
            dic.Add("拋", "rdnl");
            dic.Add("拻", "rdoy");
            dic.Add("挞", "rdp");
            dic.Add("摤", "rdqq");
            dic.Add("掎", "rds");
            dic.Add("挷", "rdtb");
            dic.Add("攊", "rdth");
            dic.Add("撩", "rdu");
            dic.Add("撅", "rduw");
            dic.Add("捧", "rdw");
            dic.Add("揍", "rdwd");
            dic.Add("搸", "rdwt");
            dic.Add("摏", "rdwv");
            dic.Add("挾", "rdww");
            dic.Add("拢", "rdx");
            dic.Add("扙", "rdyy");
            dic.Add("扔", "re");
            dic.Add("捊", "rebg");
            dic.Add("掤", "reeg");
            dic.Add("援", "ref");
            dic.Add("揺", "refb");
            dic.Add("捋", "refy");
            dic.Add("抈", "reg");
            dic.Add("抯", "regg");
            dic.Add("拥", "reh");
            dic.Add("覛", "rehq");
            dic.Add("皭", "relf");
            dic.Add("授", "rep");
            dic.Add("皧", "rept");
            dic.Add("摇", "rer");
            dic.Add("挅", "resy");
            dic.Add("採", "resy");
            dic.Add("撝", "reto");
            dic.Add("挼", "revg");
            dic.Add("搯", "revg");
            dic.Add("掙", "revh");
            dic.Add("扱", "reyy");
            dic.Add("持", "rf");
            dic.Add("擮", "rfay");
            dic.Add("技", "rfc");
            dic.Add("搕", "rfcl");
            dic.Add("抎", "rfcy");
            dic.Add("抾", "rfcy");
            dic.Add("擩", "rfdj");
            dic.Add("挂", "rffg");
            dic.Add("掛", "rffh");
            dic.Add("摴", "rffn");
            dic.Add("撓", "rffq");
            dic.Add("皢", "rffq");
            dic.Add("扗", "rfg");
            dic.Add("盾", "rfh");
            dic.Add("扞", "rfh");
            dic.Add("瞂", "rfhc");
            dic.Add("攧", "rfhm");
            dic.Add("鶞", "rfho");
            dic.Add("遁", "rfhp");
            dic.Add("搷", "rfhw");
            dic.Add("抺", "rfiy");
            dic.Add("捄", "rfiy");
            dic.Add("擀", "rfj");
            dic.Add("皁", "rfj");
            dic.Add("撠", "rfja");
            dic.Add("搆", "rfjf");
            dic.Add("拮", "rfk");
            dic.Add("擡", "rfkf");
            dic.Add("撷", "rfkm");
            dic.Add("擷", "rfkm");
            dic.Add("擂", "rfl");
            dic.Add("质", "rfm");
            dic.Add("擜", "rfmd");
            dic.Add("揇", "rfmf");
            dic.Add("乕", "rfmh");
            dic.Add("貭", "rfmi");
            dic.Add("逓", "rfmp");
            dic.Add("抟", "rfn");
            dic.Add("擣", "rfnf");
            dic.Add("扝", "rfnn");
            dic.Add("捇", "rfoy");
            dic.Add("挝", "rfp");
            dic.Add("挬", "rfpb");
            dic.Add("撎", "rfpu");
            dic.Add("抚", "rfq");
            dic.Add("抏", "rfqn");
            dic.Add("拷", "rft");
            dic.Add("搘", "rftj");
            dic.Add("撻", "rfup");
            dic.Add("扶", "rfw");
            dic.Add("攉", "rfw");
            dic.Add("撵", "rfwl");
            dic.Add("攆", "rfwl");
            dic.Add("攅", "rfwm");
            dic.Add("摫", "rfwq");
            dic.Add("掕", "rfwt");
            dic.Add("皬", "rfwy");
            dic.Add("后", "rg");
            dic.Add("挵", "rgah");
            dic.Add("邱", "rgb");
            dic.Add("扽", "rgbn");
            dic.Add("卮", "rgbv");
            dic.Add("挃", "rgcf");
            dic.Add("捯", "rgcj");
            dic.Add("巵", "rgcv");
            dic.Add("丘", "rgd");
            dic.Add("掭", "rgdn");
            dic.Add("捕", "rge");
            dic.Add("搏", "rgef");
            dic.Add("掅", "rgeg");
            dic.Add("皘", "rgeg");
            dic.Add("皇", "rgf");
            dic.Add("掗", "rgfg");
            dic.Add("扜", "rgfh");
            dic.Add("抂", "rgg");
            dic.Add("扌", "rgh");
            dic.Add("抷", "rgig");
            dic.Add("皝", "rgiq");
            dic.Add("抔", "rgiy");
            dic.Add("摶", "rgjf");
            dic.Add("挭", "rgjq");
            dic.Add("皩", "rgjq");
            dic.Add("郈", "rgkb");
            dic.Add("攮", "rgke");
            dic.Add("垕", "rgkf");
            dic.Add("捂", "rgkg");
            dic.Add("搹", "rgkh");
            dic.Add("捒", "rgki");
            dic.Add("揦", "rgkj");
            dic.Add("劶", "rgkl");
            dic.Add("揊", "rgkl");
            dic.Add("攋", "rgkm");
            dic.Add("逅", "rgkp");
            dic.Add("摗", "rgkw");
            dic.Add("揀", "rgli");
            dic.Add("岳", "rgm");
            dic.Add("拺", "rgmi");
            dic.Add("抦", "rgmw");
            dic.Add("攦", "rgmx");
            dic.Add("掚", "rgmy");
            dic.Add("皟", "rgmy");
            dic.Add("屔", "rgnx");
            dic.Add("挜", "rgog");
            dic.Add("搢", "rgoj");
            dic.Add("遑", "rgp");
            dic.Add("挒", "rgqj");
            dic.Add("扤", "rgqn");
            dic.Add("抹", "rgs");
            dic.Add("皌", "rgsy");
            dic.Add("乒", "rgt");
            dic.Add("挟", "rgu");
            dic.Add("抨", "rguh");
            dic.Add("捷", "rgv");
            dic.Add("挳", "rgva");
            dic.Add("捿", "rgvv");
            dic.Add("兵", "rgw");
            dic.Add("擟", "rgwq");
            dic.Add("挗", "rgxw");
            dic.Add("乓", "rgy");
            dic.Add("年", "rh");
            dic.Add("掳", "rha");
            dic.Add("據", "rhae");
            dic.Add("摣", "rhag");
            dic.Add("", "rhag");
            dic.Add("摢", "rhah");
            dic.Add("擄", "rhal");
            dic.Add("攎", "rhal");
            dic.Add("虒", "rham");
            dic.Add("摅", "rhan");
            dic.Add("攄", "rhan");
            dic.Add("鷉", "rhao");
            dic.Add("遞", "rhap");
            dic.Add("歋", "rhaw");
            dic.Add("卸", "rhb");
            dic.Add("披", "rhc");
            dic.Add("掯", "rheg");
            dic.Add("看", "rhf");
            dic.Add("鵇", "rhfo");
            dic.Add("扯", "rhg");
            dic.Add("挊", "rhgh");
            dic.Add("攫", "rhh");
            dic.Add("拤", "rhhy");
            dic.Add("掓", "rhic");
            dic.Add("捗", "rhit");
            dic.Add("掉", "rhj");
            dic.Add("牛", "rhk");
            dic.Add("吿", "rhkf");
            dic.Add("拈", "rhkg");
            dic.Add("揁", "rhmy");
            dic.Add("挸", "rhqn");
            dic.Add("欫", "rhqw");
            dic.Add("犇", "rhth");
            dic.Add("皉", "rhxn");
            dic.Add("扑", "rhy");
            dic.Add("爬", "rhyc");
            dic.Add("坕", "rhyf");
            dic.Add("爪", "rhyi");
            dic.Add("爮", "rhyn");
            dic.Add("朱", "ri");
            dic.Add("", "rian");
            dic.Add("邾", "rib");
            dic.Add("捎", "rie");
            dic.Add("皐", "rifj");
            dic.Add("翶", "rifn");
            dic.Add("挱", "riit");
            dic.Add("鼄", "rimv");
            dic.Add("撑", "rip");
            dic.Add("摚", "ripf");
            dic.Add("擋", "ripl");
            dic.Add("攩", "ripo");
            dic.Add("搅", "ripq");
            dic.Add("撹", "ripq");
            dic.Add("撐", "ript");
            dic.Add("挑", "riq");
            dic.Add("挄", "riqn");
            dic.Add("灥", "riri");
            dic.Add("楽", "risu");
            dic.Add("抄", "rit");
            dic.Add("挘", "ritl");
            dic.Add("毮", "ritn");
            dic.Add("泉", "riu");
            dic.Add("挡", "riv");
            dic.Add("鴸", "riwo");
            dic.Add("提", "rj");
            dic.Add("撮", "rjb");
            dic.Add("擝", "rjel");
            dic.Add("捍", "rjf");
            dic.Add("捏", "rjfg");
            dic.Add("捚", "rjfg");
            dic.Add("皔", "rjfh");
            dic.Add("担", "rjg");
            dic.Add("抇", "rjg");
            dic.Add("揚", "rjgr");
            dic.Add("捑", "rjgy");
            dic.Add("抻", "rjh");
            dic.Add("捜", "rjhc");
            dic.Add("摱", "rjlc");
            dic.Add("揾", "rjlg");
            dic.Add("搨", "rjng");
            dic.Add("揭", "rjq");
            dic.Add("掦", "rjqr");
            dic.Add("掲", "rjqx");
            dic.Add("捰", "rjsy");
            dic.Add("揽", "rjt");
            dic.Add("拽", "rjx");
            dic.Add("掍", "rjxx");
            dic.Add("撔", "rjyi");
            dic.Add("扣", "rk");
            dic.Add("揖", "rkb");
            dic.Add("擑", "rkbt");
            dic.Add("挹", "rkc");
            dic.Add("捐", "rke");
            dic.Add("挰", "rkgg");
            dic.Add("擻", "rkgt");
            dic.Add("摟", "rkgv");
            dic.Add("捉", "rkh");
            dic.Add("撌", "rkhm");
            dic.Add("操", "rkk");
            dic.Add("撣", "rkkf");
            dic.Add("捛", "rkkg");
            dic.Add("拐", "rkl");
            dic.Add("捌", "rklj");
            dic.Add("损", "rkm");
            dic.Add("損", "rkmy");
            dic.Add("拀", "rkqn");
            dic.Add("抧", "rkwy");
            dic.Add("押", "rl");
            dic.Add("摑", "rlag");
            dic.Add("擺", "rlcx");
            dic.Add("摁", "rld");
            dic.Add("摆", "rlf");
            dic.Add("畠", "rlf");
            dic.Add("擇", "rlff");
            dic.Add("搟", "rlfh");
            dic.Add("舞", "rlg");
            dic.Add("鄦", "rlgb");
            dic.Add("擐", "rlge");
            dic.Add("揋", "rlge");
            dic.Add("甒", "rlgn");
            dic.Add("無", "rlgo");
            dic.Add("鷡", "rlgo");
            dic.Add("橆", "rlgs");
            dic.Add("掴", "rlgy");
            dic.Add("捙", "rlh");
            dic.Add("拁", "rlkg");
            dic.Add("搚", "rlle");
            dic.Add("攌", "rlle");
            dic.Add("拹", "rlll");
            dic.Add("攂", "rlll");
            dic.Add("劤", "rln");
            dic.Add("劧", "rln");
            dic.Add("劰", "rln");
            dic.Add("扐", "rln");
            dic.Add("揌", "rlny");
            dic.Add("摙", "rlpy");
            dic.Add("擉", "rlqj");
            dic.Add("斶", "rlqj");
            dic.Add("摲", "rlrh");
            dic.Add("捆", "rls");
            dic.Add("撂", "rlt");
            dic.Add("搵", "rlwl");
            dic.Add("摞", "rlx");
            dic.Add("攞", "rlxy");
            dic.Add("抽", "rm");
            dic.Add("缸", "rma");
            dic.Add("擃", "rmae");
            dic.Add("捵", "rmaw");
            dic.Add("罐", "rmay");
            dic.Add("缷", "rmbh");
            dic.Add("投", "rmc");
            dic.Add("揣", "rmd");
            dic.Add("抰", "rmdy");
            dic.Add("搰", "rmeg");
            dic.Add("抩", "rmfg");
            dic.Add("皗", "rmfk");
            dic.Add("挏", "rmgk");
            dic.Add("缻", "rmgn");
            dic.Add("皚", "rmgu");
            dic.Add("帛", "rmh");
            dic.Add("製", "rmhe");
            dic.Add("罅", "rmhh");
            dic.Add("緜", "rmhi");
            dic.Add("制", "rmhj");
            dic.Add("罏", "rmhl");
            dic.Add("掣", "rmhr");
            dic.Add("罀", "rmiq");
            dic.Add("罉", "rmir");
            dic.Add("罎", "rmjc");
            dic.Add("缶", "rmk");
            dic.Add("撄", "rmm");
            dic.Add("罁", "rmmm");
            dic.Add("攖", "rmmv");
            dic.Add("缺", "rmn");
            dic.Add("皑", "rmnn");
            dic.Add("撾", "rmnp");
            dic.Add("缹", "rmou");
            dic.Add("缼", "rmqw");
            dic.Add("", "rmqy");
            dic.Add("缿", "rmrk");
            dic.Add("缽", "rmsg");
            dic.Add("罈", "rmsj");
            dic.Add("挆", "rmsy");
            dic.Add("缾", "rmua");
            dic.Add("罇", "rmuf");
            dic.Add("掆", "rmum");
            dic.Add("摧", "rmw");
            dic.Add("攜", "rmwk");
            dic.Add("抐", "rmwy");
            dic.Add("皠", "rmwy");
            dic.Add("罆", "rmxm");
            dic.Add("所", "rn");
            dic.Add("抿", "rna");
            dic.Add("搌", "rnae");
            dic.Add("气", "rnb");
            dic.Add("掘", "rnbm");
            dic.Add("撖", "rnbt");
            dic.Add("氢", "rnc");
            dic.Add("据", "rnd");
            dic.Add("戶", "rnd");
            dic.Add("氪", "rndq");
            dic.Add("氖", "rne");
            dic.Add("扭", "rnf");
            dic.Add("扟", "rnfh");
            dic.Add("握", "rng");
            dic.Add("挧", "rng");
            dic.Add("氫", "rnga");
            dic.Add("氰", "rnge");
            dic.Add("氩", "rngg");
            dic.Add("揯", "rngg");
            dic.Add("搄", "rngg");
            dic.Add("氬", "rngg");
            dic.Add("氭", "rngi");
            dic.Add("氞", "rngw");
            dic.Add("揟", "rnhe");
            dic.Add("摪", "rnhf");
            dic.Add("摨", "rnih");
            dic.Add("氘", "rnj");
            dic.Add("氜", "rnjf");
            dic.Add("刏", "rnjh");
            dic.Add("氠", "rnjh");
            dic.Add("氲", "rnjl");
            dic.Add("氱", "rnjr");
            dic.Add("擗", "rnk");
            dic.Add("氚", "rnkj");
            dic.Add("氤", "rnl");
            dic.Add("氳", "rnll");
            dic.Add("氙", "rnm");
            dic.Add("氝", "rnmw");
            dic.Add("扎", "rnn");
            dic.Add("癿", "rnn");
            dic.Add("挶", "rnnk");
            dic.Add("忥", "rnnu");
            dic.Add("撰", "rnnw");
            dic.Add("氮", "rno");
            dic.Add("氣", "rnou");
            dic.Add("氨", "rnp");
            dic.Add("気", "rnqu");
            dic.Add("扬", "rnr");
            dic.Add("摺", "rnrg");
            dic.Add("乺", "rnrn");
            dic.Add("氥", "rnsf");
            dic.Add("拨", "rnt");
            dic.Add("捤", "rntn");
            dic.Add("氕", "rntr");
            dic.Add("氡", "rntu");
            dic.Add("氧", "rnu");
            dic.Add("摒", "rnua");
            dic.Add("搱", "rnuh");
            dic.Add("氯", "rnv");
            dic.Add("氛", "rnw");
            dic.Add("擢", "rnw");
            dic.Add("摎", "rnwe");
            dic.Add("抉", "rnwy");
            dic.Add("氟", "rnx");
            dic.Add("紥", "rnxi");
            dic.Add("抳", "rnxn");
            dic.Add("拟", "rny");
            dic.Add("氦", "rny");
            dic.Add("抋", "rny");
            dic.Add("択", "rnyy");
            dic.Add("搂", "ro");
            dic.Add("擈", "rogw");
            dic.Add("撲", "rogy");
            dic.Add("攚", "rook");
            dic.Add("撈", "rool");
            dic.Add("掞", "rooy");
            dic.Add("撛", "roqh");
            dic.Add("擞", "rovt");
            dic.Add("近", "rp");
            dic.Add("迫", "rpd");
            dic.Add("廹", "rpd");
            dic.Add("搳", "rpdk");
            dic.Add("攇", "rpdn");
            dic.Add("皖", "rpf");
            dic.Add("攐", "rpfe");
            dic.Add("攓", "rpfh");
            dic.Add("捖", "rpfq");
            dic.Add("揎", "rpg");
            dic.Add("掟", "rpgh");
            dic.Add("擯", "rpgm");
            dic.Add("挥", "rpl");
            dic.Add("揮", "rplh");
            dic.Add("抭", "rpmn");
            dic.Add("捾", "rpnn");
            dic.Add("擰", "rpns");
            dic.Add("捥", "rpqb");
            dic.Add("抌", "rpqn");
            dic.Add("摈", "rpr");
            dic.Add("拧", "rps");
            dic.Add("挓", "rpta");
            dic.Add("揢", "rptk");
            dic.Add("按", "rpv");
            dic.Add("控", "rpw");
            dic.Add("揬", "rpwd");
            dic.Add("搾", "rpwf");
            dic.Add("撺", "rpwh");
            dic.Add("擦", "rpwi");
            dic.Add("摍", "rpwj");
            dic.Add("搈", "rpwk");
            dic.Add("挖", "rpwn");
            dic.Add("攛", "rpwn");
            dic.Add("摉", "rpwq");
            dic.Add("探", "rpws");
            dic.Add("搉", "rpwy");
            dic.Add("搲", "rpwy");
            dic.Add("攨", "rpwy");
            dic.Add("拕", "rpxn");
            dic.Add("换", "rq");
            dic.Add("抵", "rqa");
            dic.Add("捪", "rqaj");
            dic.Add("扺", "rqan");
            dic.Add("搩", "rqas");
            dic.Add("抑", "rqb");
            dic.Add("皃", "rqb");
            dic.Add("搊", "rqbt");
            dic.Add("鬼", "rqc");
            dic.Add("魑", "rqc");
            dic.Add("魃", "rqcc");
            dic.Add("鬾", "rqcc");
            dic.Add("魈", "rqce");
            dic.Add("鬽", "rqce");
            dic.Add("魁", "rqcf");
            dic.Add("魓", "rqcf");
            dic.Add("魊", "rqcg");
            dic.Add("魖", "rqcg");
            dic.Add("魅", "rqci");
            dic.Add("魒", "rqci");
            dic.Add("魀", "rqcj");
            dic.Add("魍", "rqcn");
            dic.Add("魐", "rqco");
            dic.Add("鬿", "rqcr");
            dic.Add("魆", "rqct");
            dic.Add("魕", "rqct");
            dic.Add("魉", "rqcw");
            dic.Add("魌", "rqcw");
            dic.Add("抅", "rqcy");
            dic.Add("魋", "rqcy");
            dic.Add("魎", "rqcy");
            dic.Add("撚", "rqdo");
            dic.Add("擔", "rqdy");
            dic.Add("捔", "rqeh");
            dic.Add("撸", "rqg");
            dic.Add("捦", "rqg");
            dic.Add("拘", "rqk");
            dic.Add("挽", "rqkq");
            dic.Add("搀", "rqku");
            dic.Add("攙", "rqky");
            dic.Add("換", "rqmd");
            dic.Add("抱", "rqn");
            dic.Add("掬", "rqo");
            dic.Add("擼", "rqoj");
            dic.Add("揿", "rqq");
            dic.Add("撳", "rqqw");
            dic.Add("拸", "rqqy");
            dic.Add("掏", "rqr");
            dic.Add("搖", "rqrm");
            dic.Add("揔", "rqrn");
            dic.Add("摋", "rqsc");
            dic.Add("抣", "rqug");
            dic.Add("掐", "rqv");
            dic.Add("挣", "rqvh");
            dic.Add("欣", "rqw");
            dic.Add("扻", "rqwy");
            dic.Add("揈", "rqyg");
            dic.Add("捣", "rqym");
            dic.Add("扚", "rqyy");
            dic.Add("折", "rr");
            dic.Add("扳", "rrc");
            dic.Add("皈", "rrc");
            dic.Add("鋬", "rrcq");
            dic.Add("皞", "rrdf");
            dic.Add("硩", "rrdf");
            dic.Add("挀", "rrey");
            dic.Add("埑", "rrff");
            dic.Add("揗", "rrfh");
            dic.Add("拍", "rrg");
            dic.Add("拞", "rrgg");
            dic.Add("揘", "rrgg");
            dic.Add("捳", "rrgm");
            dic.Add("捠", "rrgw");
            dic.Add("抙", "rrh");
            dic.Add("斦", "rrh");
            dic.Add("搋", "rrhm");
            dic.Add("擨", "rrhw");
            dic.Add("抓", "rrhy");
            dic.Add("皡", "rrif");
            dic.Add("蜇", "rrj");
            dic.Add("晢", "rrjf");
            dic.Add("哲", "rrk");
            dic.Add("啠", "rrkf");
            dic.Add("踅", "rrkh");
            dic.Add("撫", "rrlo");
            dic.Add("劕", "rrmj");
            dic.Add("質", "rrmu");
            dic.Add("乴", "rrnb");
            dic.Add("悊", "rrnu");
            dic.Add("烲", "rrou");
            dic.Add("焎", "rrou");
            dic.Add("逝", "rrp");
            dic.Add("掀", "rrq");
            dic.Add("魄", "rrqc");
            dic.Add("銴", "rrqf");
            dic.Add("皛", "rrrf");
            dic.Add("皨", "rrrf");
            dic.Add("掱", "rrrj");
            dic.Add("梊", "rrsu");
            dic.Add("捭", "rrt");
            dic.Add("娎", "rrvf");
            dic.Add("抶", "rrwy");
            dic.Add("拆", "rry");
            dic.Add("裚", "rrye");
            dic.Add("誓", "rryf");
            dic.Add("撽", "rryt");
            dic.Add("皦", "rryt");
            dic.Add("打", "rs");
            dic.Add("摽", "rsfi");
            dic.Add("拪", "rsg");
            dic.Add("揸", "rsj");
            dic.Add("撢", "rsjh");
            dic.Add("抲", "rskg");
            dic.Add("搮", "rssy");
            dic.Add("手", "rt");
            dic.Add("托", "rta");
            dic.Add("抍", "rtah");
            dic.Add("扥", "rtan");
            dic.Add("拖", "rtb");
            dic.Add("逰", "rtbp");
            dic.Add("括", "rtd");
            dic.Add("捀", "rtdh");
            dic.Add("挢", "rtdj");
            dic.Add("撟", "rtdk");
            dic.Add("摓", "rtdp");
            dic.Add("擌", "rtdw");
            dic.Add("扷", "rtdy");
            dic.Add("搬", "rte");
            dic.Add("插", "rtf");
            dic.Add("郫", "rtfb");
            dic.Add("鹎", "rtfg");
            dic.Add("扦", "rtfh");
            dic.Add("卑", "rtfj");
            dic.Add("挿", "rtfj");
            dic.Add("皓", "rtfk");
            dic.Add("捁", "rtfk");
            dic.Add("攒", "rtfm");
            dic.Add("攢", "rtfm");
            dic.Add("撬", "rtfn");
            dic.Add("鵯", "rtfo");
            dic.Add("挺", "rtfp");
            dic.Add("揷", "rtfv");
            dic.Add("捶", "rtgf");
            dic.Add("揰", "rtgf");
            dic.Add("", "rtgt");
            dic.Add("擤", "rth");
            dic.Add("搝", "rthd");
            dic.Add("拃", "rthf");
            dic.Add("皥", "rthf");
            dic.Add("攥", "rthi");
            dic.Add("揝", "rthj");
            dic.Add("扸", "rthn");
            dic.Add("挻", "rthp");
            dic.Add("摥", "rtjr");
            dic.Add("挌", "rtkg");
            dic.Add("摠", "rtln");
            dic.Add("擙", "rtmd");
            dic.Add("拠", "rtmn");
            dic.Add("扢", "rtnn");
            dic.Add("揪", "rto");
            dic.Add("皤", "rto");
            dic.Add("播", "rtol");
            dic.Add("抸", "rtpy");
            dic.Add("皒", "rtrt");
            dic.Add("斤", "rtt");
            dic.Add("", "rtt");
            dic.Add("擶", "rtuj");
            dic.Add("擳", "rtvb");
            dic.Add("捼", "rtvg");
            dic.Add("摐", "rtwh");
            dic.Add("撘", "rtwk");
            dic.Add("挴", "rtxu");
            dic.Add("敀", "rty");
            dic.Add("扖", "rtyy");
            dic.Add("拉", "ru");
            dic.Add("拼", "rua");
            dic.Add("皏", "ruah");
            dic.Add("搠", "rub");
            dic.Add("搓", "rud");
            dic.Add("掷", "rudb");
            dic.Add("捲", "rudb");
            dic.Add("攁", "rude");
            dic.Add("撯", "rudh");
            dic.Add("搼", "rudr");
            dic.Add("攏", "rued");
            dic.Add("撊", "rueg");
            dic.Add("揃", "ruej");
            dic.Add("拦", "ruf");
            dic.Add("抖", "ruf");
            dic.Add("拌", "rufh");
            dic.Add("捫", "rug");
            dic.Add("撋", "rugg");
            dic.Add("攔", "rugi");
            dic.Add("撞", "ruj");
            dic.Add("掸", "rujf");
            dic.Add("揞", "rujg");
            dic.Add("摬", "rujq");
            dic.Add("掊", "ruk");
            dic.Add("搃", "rukn");
            dic.Add("捝", "rukq");
            dic.Add("摘", "rum");
            dic.Add("擿", "rump");
            dic.Add("撇", "rumt");
            dic.Add("扪", "run");
            dic.Add("掽", "ruog");
            dic.Add("揥", "ruph");
            dic.Add("搒", "rupy");
            dic.Add("皎", "ruq");
            dic.Add("挍", "ruqy");
            dic.Add("撙", "rus");
            dic.Add("擲", "rusb");
            dic.Add("揂", "rusg");
            dic.Add("搁", "rut");
            dic.Add("摌", "rutg");
            dic.Add("擱", "rutk");
            dic.Add("接", "ruv");
            dic.Add("搛", "ruvo");
            dic.Add("搤", "ruwl");
            dic.Add("揹", "ruxe");
            dic.Add("挮", "ruxt");
            dic.Add("扫", "rv");
            dic.Add("撏", "rvaf");
            dic.Add("揑", "rvag");
            dic.Add("揤", "rvcb");
            dic.Add("摡", "rvcq");
            dic.Add("拫", "rvey");
            dic.Add("挪", "rvf");
            dic.Add("揵", "rvfp");
            dic.Add("挦", "rvfy");
            dic.Add("攑", "rvgh");
            dic.Add("搜", "rvh");
            dic.Add("捸", "rviy");
            dic.Add("摷", "rvjs");
            dic.Add("招", "rvk");
            dic.Add("抛", "rvl");
            dic.Add("擸", "rvln");
            dic.Add("殷", "rvn");
            dic.Add("扏", "rvn");
            dic.Add("慇", "rvnn");
            dic.Add("掃", "rvph");
            dic.Add("拶", "rvq");
            dic.Add("掜", "rvqn");
            dic.Add("攪", "rvqq");
            dic.Add("捃", "rvt");
            dic.Add("执", "rvy");
            dic.Add("垫", "rvyf");
            dic.Add("鸷", "rvyg");
            dic.Add("絷", "rvyi");
            dic.Add("蛰", "rvyj");
            dic.Add("势", "rvyl");
            dic.Add("贽", "rvym");
            dic.Add("热", "rvyo");
            dic.Add("挚", "rvyr");
            dic.Add("扨", "rvyy");
            dic.Add("失", "rw");
            dic.Add("抢", "rwb");
            dic.Add("捴", "rwcn");
            dic.Add("抮", "rwet");
            dic.Add("拊", "rwf");
            dic.Add("摖", "rwfi");
            dic.Add("捨", "rwfk");
            dic.Add("拴", "rwg");
            dic.Add("掄", "rwga");
            dic.Add("揜", "rwga");
            dic.Add("掵", "rwgb");
            dic.Add("揆", "rwgd");
            dic.Add("捡", "rwgi");
            dic.Add("揄", "rwgj");
            dic.Add("拾", "rwgk");
            dic.Add("搿", "rwgr");
            dic.Add("撜", "rwgu");
            dic.Add("撿", "rwgw");
            dic.Add("扴", "rwjh");
            dic.Add("挩", "rwkq");
            dic.Add("劮", "rwln");
            dic.Add("摀", "rwno");
            dic.Add("搥", "rwnp");
            dic.Add("怣", "rwnu");
            dic.Add("迭", "rwp");
            dic.Add("拰", "rwtf");
            dic.Add("捈", "rwty");
            dic.Add("摿", "rwuj");
            dic.Add("扵", "rwuy");
            dic.Add("扮", "rwv");
            dic.Add("搗", "rwvm");
            dic.Add("掰", "rwvr");
            dic.Add("挫", "rww");
            dic.Add("攕", "rwwg");
            dic.Add("鴩", "rwwo");
            dic.Add("抡", "rwx");
            dic.Add("撥", "rwxc");
            dic.Add("扒", "rwy");
            dic.Add("拎", "rwy");
            dic.Add("擒", "rwyc");
            dic.Add("皊", "rwyc");
            dic.Add("", "rwyc");
            dic.Add("携", "rwye");
            dic.Add("搇", "rwye");
            dic.Add("推", "rwyg");
            dic.Add("搶", "rwyk");
            dic.Add("勧", "rwyl");
            dic.Add("擕", "rwym");
            dic.Add("捻", "rwyn");
            dic.Add("扲", "rwyn");
            dic.Add("撨", "rwyo");
            dic.Add("観", "rwyq");
            dic.Add("歓", "rwyw");
            dic.Add("批", "rx");
            dic.Add("墍", "rxaf");
            dic.Add("曁", "rxag");
            dic.Add("旣", "rxaq");
            dic.Add("槩", "rxas");
            dic.Add("皀", "rxb");
            dic.Add("卽", "rxbh");
            dic.Add("皍", "rxbj");
            dic.Add("掾", "rxe");
            dic.Add("攭", "rxej");
            dic.Add("掼", "rxf");
            dic.Add("摜", "rxfm");
            dic.Add("拇", "rxg");
            dic.Add("指", "rxj");
            dic.Add("拂", "rxjh");
            dic.Add("摾", "rxkj");
            dic.Add("拗", "rxl");
            dic.Add("抝", "rxnn");
            dic.Add("撧", "rxqc");
            dic.Add("擽", "rxrs");
            dic.Add("皪", "rxrs");
            dic.Add("擬", "rxth");
            dic.Add("搦", "rxu");
            dic.Add("揩", "rxxr");
            dic.Add("扩", "ry");
            dic.Add("摭", "rya");
            dic.Add("擴", "ryaw");
            dic.Add("摛", "rybc");
            dic.Add("撴", "rybt");
            dic.Add("攡", "ryby");
            dic.Add("撤", "ryc");
            dic.Add("拡", "rycy");
            dic.Add("挔", "ryey");
            dic.Add("拄", "ryg");
            dic.Add("掂", "ryh");
            dic.Add("抃", "ryhy");
            dic.Add("斥", "ryi");
            dic.Add("掠", "ryiy");
            dic.Add("挤", "ryj");
            dic.Add("擠", "ryjg");
            dic.Add("攘", "ryk");
            dic.Add("擅", "ryl");
            dic.Add("搞", "rym");
            dic.Add("皜", "rymk");
            dic.Add("抗", "rymn");
            dic.Add("护", "ryn");
            dic.Add("揙", "ryna");
            dic.Add("捩", "rynd");
            dic.Add("掮", "ryne");
            dic.Add("搧", "rynn");
            dic.Add("攗", "ryno");
            dic.Add("皫", "ryno");
            dic.Add("攈", "rynt");
            dic.Add("攟", "rynt");
            dic.Add("摝", "rynx");
            dic.Add("攍", "ryny");
            dic.Add("揨", "ryps");
            dic.Add("掋", "ryqy");
            dic.Add("攠", "rysd");
            dic.Add("擵", "rysr");
            dic.Add("揓", "rytb");
            dic.Add("鸄", "ryto");
            dic.Add("邀", "rytp");
            dic.Add("敫", "ryty");
            dic.Add("譥", "ryty");
            dic.Add("搪", "ryv");
            dic.Add("掶", "ryvw");
            dic.Add("掖", "ryw");
            dic.Add("捬", "rywf");
            dic.Add("捽", "rywf");
            dic.Add("摔", "ryx");
            dic.Add("撁", "ryxh");
            dic.Add("搐", "ryxl");
            dic.Add("擁", "ryxy");
            dic.Add("抆", "ryy");
            dic.Add("要", "s");
            dic.Add("木", "s");
            dic.Add("械", "sa");
            dic.Add("栻", "saag");
            dic.Add("櫙", "saak");
            dic.Add("棧", "saat");
            dic.Add("栉", "sab");
            dic.Add("榵", "sabg");
            dic.Add("桏", "sabh");
            dic.Add("棋", "sad");
            dic.Add("榧", "sadd");
            dic.Add("樭", "sadf");
            dic.Add("楛", "sadg");
            dic.Add("櫀", "sadi");
            dic.Add("楉", "sadk");
            dic.Add("椹", "sadn");
            dic.Add("欌", "sadt");
            dic.Add("橵", "saet");
            dic.Add("柑", "saf");
            dic.Add("杢", "saf");
            dic.Add("覊", "safc");
            dic.Add("覇", "safe");
            dic.Add("覉", "safk");
            dic.Add("樲", "safm");
            dic.Add("楳", "safs");
            dic.Add("杠", "sag");
            dic.Add("樺", "sagf");
            dic.Add("框", "sagg");
            dic.Add("橫", "sagw");
            dic.Add("樫", "sahf");
            dic.Add("栕", "sahh");
            dic.Add("檻", "sahl");
            dic.Add("欖", "sahq");
            dic.Add("枒", "saht");
            dic.Add("栋", "sai");
            dic.Add("欂", "saif");
            dic.Add("模", "saj");
            dic.Add("橗", "saje");
            dic.Add("棤", "sajg");
            dic.Add("椻", "sajv");
            dic.Add("槿", "sak");
            dic.Add("棫", "sakg");
            dic.Add("樞", "sakk");
            dic.Add("櫃", "sakm");
            dic.Add("欟", "sakq");
            dic.Add("權", "saky");
            dic.Add("櫣", "salp");
            dic.Add("櫗", "salt");
            dic.Add("横", "sam");
            dic.Add("楧", "samd");
            dic.Add("槓", "samy");
            dic.Add("樠", "samy");
            dic.Add("柜", "san");
            dic.Add("枻", "sann");
            dic.Add("楪", "sans");
            dic.Add("檬", "sap");
            dic.Add("枢", "saq");
            dic.Add("槆", "saqj");
            dic.Add("橬", "saqj");
            dic.Add("檧", "saqn");
            dic.Add("柩", "saqy");
            dic.Add("桡", "sat");
            dic.Add("樥", "sath");
            dic.Add("欗", "saui");
            dic.Add("櫹", "savh");
            dic.Add("檴", "sawc");
            dic.Add("﨓", "sawf");
            dic.Add("櫒", "sawi");
            dic.Add("榙", "sawk");
            dic.Add("檋", "sawl");
            dic.Add("櫵", "sawo");
            dic.Add("欍", "sawv");
            dic.Add("椛", "sawx");
            dic.Add("栱", "sawy");
            dic.Add("杙", "say");
            dic.Add("李", "sb");
            dic.Add("椰", "sbb");
            dic.Add("欇", "sbbb");
            dic.Add("棷", "sbcy");
            dic.Add("椭", "sbd");
            dic.Add("橢", "sbde");
            dic.Add("杍", "sbg");
            dic.Add("栮", "sbg");
            dic.Add("樄", "sbgi");
            dic.Add("邒", "sbh");
            dic.Add("極", "sbkg");
            dic.Add("檉", "sbkg");
            dic.Add("柮", "sbmh");
            dic.Add("杝", "sbn");
            dic.Add("槂", "sbti");
            dic.Add("权", "sc");
            dic.Add("杼", "scb");
            dic.Add("櫲", "scbe");
            dic.Add("壄", "scbf");
            dic.Add("橘", "scbk");
            dic.Add("懋", "scbn");
            dic.Add("楙", "scbs");
            dic.Add("楺", "scbs");
            dic.Add("柕", "scbt");
            dic.Add("棳", "sccc");
            dic.Add("槮", "scce");
            dic.Add("槡", "sccs");
            dic.Add("椮", "scde");
            dic.Add("桳", "scdf");
            dic.Add("桶", "sce");
            dic.Add("樋", "scep");
            dic.Add("树", "scf");
            dic.Add("柽", "scfg");
            dic.Add("杩", "scg");
            dic.Add("枱", "sckg");
            dic.Add("杷", "scn");
            dic.Add("桙", "scrh");
            dic.Add("梭", "scw");
            dic.Add("榪", "scy");
            dic.Add("杈", "scyy");
            dic.Add("枯", "sd");
            dic.Add("楕", "sdae");
            dic.Add("檶", "sdak");
            dic.Add("櫔", "sday");
            dic.Add("枙", "sdbn");
            dic.Add("柭", "sdcy");
            dic.Add("栯", "sdeg");
            dic.Add("楜", "sdeg");
            dic.Add("櫌", "sdet");
            dic.Add("棖", "sdey");
            dic.Add("桭", "sdfe");
            dic.Add("楏", "sdff");
            dic.Add("槈", "sdff");
            dic.Add("櫉", "sdff");
            dic.Add("桍", "sdfn");
            dic.Add("槬", "sdfy");
            dic.Add("柘", "sdg");
            dic.Add("橱", "sdgf");
            dic.Add("椷", "sdgt");
            dic.Add("楲", "sdgt");
            dic.Add("楔", "sdh");
            dic.Add("栫", "sdhb");
            dic.Add("櫘", "sdhn");
            dic.Add("槭", "sdht");
            dic.Add("榎", "sdht");
            dic.Add("槥", "sdhv");
            dic.Add("棑", "sdjd");
            dic.Add("栢", "sdjg");
            dic.Add("槗", "sdkk");
            dic.Add("枥", "sdl");
            dic.Add("顶", "sdm");
            dic.Add("柨", "sdmh");
            dic.Add("栭", "sdmj");
            dic.Add("頂", "sdmy");
            dic.Add("杤", "sdnn");
            dic.Add("遷", "sdnp");
            dic.Add("桟", "sdny");
            dic.Add("樉", "sdqq");
            dic.Add("榞", "sdri");
            dic.Add("椅", "sds");
            dic.Add("梆", "sdt");
            dic.Add("梼", "sdtf");
            dic.Add("櫪", "sdth");
            dic.Add("橛", "sdu");
            dic.Add("橭", "sduh");
            dic.Add("橑", "sdui");
            dic.Add("棒", "sdw");
            dic.Add("楱", "sdwd");
            dic.Add("椿", "sdwj");
            dic.Add("榛", "sdwt");
            dic.Add("樁", "sdwv");
            dic.Add("梜", "sdww");
            dic.Add("栊", "sdx");
            dic.Add("杖", "sdy");
            dic.Add("杕", "sdy");
            dic.Add("枤", "sdy");
            dic.Add("极", "se");
            dic.Add("檼", "sean");
            dic.Add("桴", "seb");
            dic.Add("棴", "sebc");
            dic.Add("楹", "sec");
            dic.Add("棚", "see");
            dic.Add("楥", "sefc");
            dic.Add("枂", "seg");
            dic.Add("査", "segf");
            dic.Add("柤", "segg");
            dic.Add("橓", "seph");
            dic.Add("櫾", "seri");
            dic.Add("榣", "serm");
            dic.Add("桗", "sesy");
            dic.Add("棌", "sesy");
            dic.Add("杉", "set");
            dic.Add("橳", "seul");
            dic.Add("桵", "sevg");
            dic.Add("槄", "sevg");
            dic.Add("榽", "sexd");
            dic.Add("椓", "seyy");
            dic.Add("村", "sf");
            dic.Add("欛", "sfae");
            dic.Add("枿", "sfah");
            dic.Add("橨", "sfam");
            dic.Add("鄄", "sfb");
            dic.Add("枝", "sfc");
            dic.Add("榼", "sfcl");
            dic.Add("枟", "sfcy");
            dic.Add("檽", "sfdj");
            dic.Add("桂", "sff");
            dic.Add("垔", "sff");
            dic.Add("橒", "sffc");
            dic.Add("樗", "sffn");
            dic.Add("橈", "sffq");
            dic.Add("杜", "sfg");
            dic.Add("甄", "sfgn");
            dic.Add("杆", "sfh");
            dic.Add("植", "sfhg");
            dic.Add("樾", "sfht");
            dic.Add("槙", "sfhw");
            dic.Add("标", "sfi");
            dic.Add("柰", "sfi");
            dic.Add("彯", "sfie");
            dic.Add("隸", "sfii");
            dic.Add("剽", "sfij");
            dic.Add("飄", "sfij");
            dic.Add("勡", "sfil");
            dic.Add("顠", "sfim");
            dic.Add("翲", "sfin");
            dic.Add("飘", "sfiq");
            dic.Add("票", "sfiu");
            dic.Add("歀", "sfiw");
            dic.Add("瓢", "sfiy");
            dic.Add("柡", "sfiy");
            dic.Add("梂", "sfiy");
            dic.Add("橶", "sfja");
            dic.Add("榸", "sfjf");
            dic.Add("構", "sfjf");
            dic.Add("檊", "sfjf");
            dic.Add("枾", "sfjg");
            dic.Add("桔", "sfk");
            dic.Add("榬", "sfke");
            dic.Add("樹", "sfkf");
            dic.Add("檯", "sfkf");
            dic.Add("橲", "sfkk");
            dic.Add("櫺", "sfkk");
            dic.Add("欞", "sfkw");
            dic.Add("檑", "sfl");
            dic.Add("櫝", "sflm");
            dic.Add("楠", "sfm");
            dic.Add("椟", "sfn");
            dic.Add("檮", "sfnf");
            dic.Add("杇", "sfnn");
            dic.Add("梽", "sfny");
            dic.Add("桲", "sfpb");
            dic.Add("杬", "sfqn");
            dic.Add("歅", "sfqw");
            dic.Add("材", "sft");
            dic.Add("楮", "sftj");
            dic.Add("榰", "sftj");
            dic.Add("栲", "sftn");
            dic.Add("栳", "sftx");
            dic.Add("樯", "sfu");
            dic.Add("橽", "sfup");
            dic.Add("樰", "sfvg");
            dic.Add("棱", "sfw");
            dic.Add("檣", "sfwk");
            dic.Add("櫕", "sfwm");
            dic.Add("槻", "sfwq");
            dic.Add("枎", "sfwy");
            dic.Add("槸", "sfwy");
            dic.Add("本", "sg");
            dic.Add("醋", "sga");
            dic.Add("醆", "sgaa");
            dic.Add("酣", "sgaf");
            dic.Add("醛", "sgag");
            dic.Add("枅", "sgah");
            dic.Add("梇", "sgah");
            dic.Add("醧", "sgak");
            dic.Add("橊", "sgal");
            dic.Add("桺", "sgan");
            dic.Add("醼", "sgao");
            dic.Add("酏", "sgb");
            dic.Add("杶", "sgbn");
            dic.Add("酸", "sgc");
            dic.Add("醊", "sgcc");
            dic.Add("醦", "sgce");
            dic.Add("桎", "sgcf");
            dic.Add("椡", "sgcj");
            dic.Add("酉", "sgd");
            dic.Add("醐", "sgde");
            dic.Add("酭", "sgde");
            dic.Add("酤", "sgdg");
            dic.Add("醢", "sgdl");
            dic.Add("醃", "sgdn");
            dic.Add("醎", "sgdt");
            dic.Add("酞", "sgdy");
            dic.Add("酹", "sge");
            dic.Add("酻", "sgeb");
            dic.Add("榑", "sgef");
            dic.Add("釂", "sgef");
            dic.Add("棈", "sgeg");
            dic.Add("酝", "sgf");
            dic.Add("酵", "sgfb");
            dic.Add("醻", "sgff");
            dic.Add("椏", "sgfg");
            dic.Add("酐", "sgfh");
            dic.Add("杅", "sgfh");
            dic.Add("醏", "sgfj");
            dic.Add("醹", "sgfj");
            dic.Add("醽", "sgfk");
            dic.Add("醘", "sgfl");
            dic.Add("酛", "sgfq");
            dic.Add("酜", "sgfw");
            dic.Add("酎", "sgfy");
            dic.Add("枉", "sgg");
            dic.Add("酽", "sggd");
            dic.Add("酑", "sggf");
            dic.Add("醩", "sggj");
            dic.Add("釃", "sggx");
            dic.Add("酾", "sggy");
            dic.Add("酺", "sggy");
            dic.Add("丁", "sgh");
            dic.Add("醵", "sghe");
            dic.Add("西", "sghg");
            dic.Add("柾", "sghg");
            dic.Add("覀", "sghg");
            dic.Add("酟", "sghk");
            dic.Add("朩", "sghy");
            dic.Add("杯", "sgi");
            dic.Add("柸", "sgig");
            dic.Add("桮", "sgik");
            dic.Add("醒", "sgj");
            dic.Add("桓", "sgj");
            dic.Add("槫", "sgjf");
            dic.Add("醍", "sgjh");
            dic.Add("棟", "sgji");
            dic.Add("醖", "sgjl");
            dic.Add("橞", "sgjn");
            dic.Add("樮", "sgjo");
            dic.Add("梗", "sgjq");
            dic.Add("醌", "sgjx");
            dic.Add("梧", "sgk");
            dic.Add("酲", "sgk");
            dic.Add("欜", "sgke");
            dic.Add("槅", "sgkh");
            dic.Add("梀", "sgki");
            dic.Add("楋", "sgkj");
            dic.Add("櫮", "sgkk");
            dic.Add("楅", "sgkl");
            dic.Add("櫴", "sgkm");
            dic.Add("釅", "sgkt");
            dic.Add("梪", "sgku");
            dic.Add("樕", "sgkw");
            dic.Add("楝", "sgl");
            dic.Add("醳", "sglf");
            dic.Add("橿", "sglg");
            dic.Add("醞", "sgll");
            dic.Add("柄", "sgm");
            dic.Add("酘", "sgmc");
            dic.Add("醲", "sgme");
            dic.Add("杮", "sgmh");
            dic.Add("栜", "sgmi");
            dic.Add("槽", "sgmj");
            dic.Add("酮", "sgmk");
            dic.Add("醠", "sgml");
            dic.Add("醴", "sgmu");
            dic.Add("欐", "sgmx");
            dic.Add("樍", "sgmy");
            dic.Add("配", "sgn");
            dic.Add("醑", "sgn");
            dic.Add("醪", "sgne");
            dic.Add("翉", "sgng");
            dic.Add("朽", "sgnn");
            dic.Add("酦", "sgny");
            dic.Add("醚", "sgo");
            dic.Add("桠", "sgog");
            dic.Add("榗", "sgoj");
            dic.Add("醈", "sgoo");
            dic.Add("醭", "sgoy");
            dic.Add("梾", "sgoy");
            dic.Add("酡", "sgp");
            dic.Add("逎", "sgpd");
            dic.Add("酧", "sgpf");
            dic.Add("醡", "sgpf");
            dic.Add("醓", "sgpl");
            dic.Add("酖", "sgpq");
            dic.Add("酌", "sgq");
            dic.Add("酗", "sgqb");
            dic.Add("栵", "sgqj");
            dic.Add("酩", "sgqk");
            dic.Add("醄", "sgqm");
            dic.Add("杌", "sgqn");
            dic.Add("醜", "sgrc");
            dic.Add("酊", "sgs");
            dic.Add("醥", "sgsi");
            dic.Add("醰", "sgsj");
            dic.Add("酠", "sgsk");
            dic.Add("醂", "sgss");
            dic.Add("枺", "sgsy");
            dic.Add("栈", "sgt");
            dic.Add("酪", "sgt");
            dic.Add("酢", "sgtf");
            dic.Add("酷", "sgtk");
            dic.Add("酕", "sgtn");
            dic.Add("醺", "sgto");
            dic.Add("酰", "sgtq");
            dic.Add("酶", "sgtu");
            dic.Add("酥", "sgty");
            dic.Add("枰", "sgu");
            dic.Add("醝", "sgua");
            dic.Add("醸", "sgue");
            dic.Add("酙", "sguf");
            dic.Add("醅", "sguk");
            dic.Add("醷", "sgun");
            dic.Add("桱", "sgva");
            dic.Add("醙", "sgvc");
            dic.Add("酔", "sgvf");
            dic.Add("醁", "sgvi");
            dic.Add("棲", "sgvv");
            dic.Add("酚", "sgw");
            dic.Add("醱", "sgwc");
            dic.Add("酫", "sgwg");
            dic.Add("醮", "sgwo");
            dic.Add("檷", "sgwq");
            dic.Add("醗", "sgwq");
            dic.Add("酴", "sgwt");
            dic.Add("醶", "sgww");
            dic.Add("醀", "sgwy");
            dic.Add("酯", "sgx");
            dic.Add("酳", "sgxe");
            dic.Add("枑", "sgxg");
            dic.Add("榡", "sgxi");
            dic.Add("桋", "sgxw");
            dic.Add("醉", "sgy");
            dic.Add("醇", "sgyb");
            dic.Add("醨", "sgyc");
            dic.Add("釄", "sgyd");
            dic.Add("酿", "sgye");
            dic.Add("釀", "sgye");
            dic.Add("酬", "sgyh");
            dic.Add("醿", "sgyi");
            dic.Add("醕", "sgyj");
            dic.Add("醣", "sgyk");
            dic.Add("醯", "sgyl");
            dic.Add("醾", "sgyo");
            dic.Add("酼", "sgyq");
            dic.Add("相", "sh");
            dic.Add("樝", "shag");
            dic.Add("櫨", "shal");
            dic.Add("椃", "sham");
            dic.Add("櫖", "shan");
            dic.Add("榩", "shay");
            dic.Add("櫇", "shcm");
            dic.Add("柀", "shcy");
            dic.Add("檅", "shdt");
            dic.Add("杫", "shg");
            dic.Add("桛", "shgh");
            dic.Add("欔", "shhc");
            dic.Add("欋", "shhy");
            dic.Add("椒", "shi");
            dic.Add("棹", "shj");
            dic.Add("槕", "shjs");
            dic.Add("枮", "shkg");
            dic.Add("樐", "shlo");
            dic.Add("桢", "shm");
            dic.Add("楨", "shmy");
            dic.Add("想", "shn");
            dic.Add("檙", "shnn");
            dic.Add("栌", "shnt");
            dic.Add("梘", "shqn");
            dic.Add("椇", "shwy");
            dic.Add("橴", "shxi");
            dic.Add("朴", "shy");
            dic.Add("档", "si");
            dic.Add("梢", "sie");
            dic.Add("桫", "sii");
            dic.Add("樘", "sip");
            dic.Add("檔", "sipl");
            dic.Add("欓", "sipo");
            dic.Add("橖", "sips");
            dic.Add("橕", "sipt");
            dic.Add("桃", "siq");
            dic.Add("桄", "siq");
            dic.Add("杪", "sit");
            dic.Add("桜", "sivg");
            dic.Add("樑", "sivs");
            dic.Add("榉", "siw");
            dic.Add("﨔", "siwr");
            dic.Add("查", "sj");
            dic.Add("樶", "sjbc");
            dic.Add("杳", "sjf");
            dic.Add("榯", "sjff");
            dic.Add("梩", "sjfg");
            dic.Add("桿", "sjfh");
            dic.Add("皶", "sjgc");
            dic.Add("棏", "sjgf");
            dic.Add("棩", "sjgg");
            dic.Add("柦", "sjgg");
            dic.Add("鸉", "sjgo");
            dic.Add("楊", "sjgr");
            dic.Add("柛", "sjhh");
            dic.Add("榥", "sjiq");
            dic.Add("覃", "sjj");
            dic.Add("椙", "sjjg");
            dic.Add("橸", "sjjj");
            dic.Add("螙", "sjju");
            dic.Add("槾", "sjlc");
            dic.Add("榅", "sjlg");
            dic.Add("榻", "sjn");
            dic.Add("楬", "sjqn");
            dic.Add("棵", "sjs");
            dic.Add("槛", "sjt");
            dic.Add("榄", "sjtq");
            dic.Add("鷣", "sjwo");
            dic.Add("棍", "sjx");
            dic.Add("栧", "sjxt");
            dic.Add("可", "sk");
            dic.Add("楫", "skb");
            dic.Add("檝", "skbt");
            dic.Add("梋", "skeg");
            dic.Add("杏", "skf");
            dic.Add("枵", "skg");
            dic.Add("桯", "skgg");
            dic.Add("櫢", "skgt");
            dic.Add("樓", "skgv");
            dic.Add("杊", "skh");
            dic.Add("樻", "skhm");
            dic.Add("榀", "skk");
            dic.Add("樿", "skkf");
            dic.Add("梠", "skkg");
            dic.Add("梙", "skkh");
            dic.Add("楍", "skkk");
            dic.Add("槵", "skkn");
            dic.Add("橾", "skks");
            dic.Add("欕", "skkt");
            dic.Add("柺", "skln");
            dic.Add("柷", "skqn");
            dic.Add("哥", "sks");
            dic.Add("戨", "sksa");
            dic.Add("歌", "sksw");
            dic.Add("枴", "skvn");
            dic.Add("枳", "skw");
            dic.Add("楞", "sl");
            dic.Add("槶", "slag");
            dic.Add("檌", "sldd");
            dic.Add("棝", "sldg");
            dic.Add("栶", "sldy");
            dic.Add("檡", "slff");
            dic.Add("柶", "slg");
            dic.Add("椳", "slge");
            dic.Add("檈", "slge");
            dic.Add("檲", "slgf");
            dic.Add("椢", "slgy");
            dic.Add("柙", "slh");
            dic.Add("枷", "slk");
            dic.Add("欙", "slli");
            dic.Add("栛", "slll");
            dic.Add("櫑", "slll");
            dic.Add("朸", "sln");
            dic.Add("楒", "slny");
            dic.Add("梿", "slpy");
            dic.Add("槤", "slpy");
            dic.Add("椤", "slq");
            dic.Add("梱", "slsy");
            dic.Add("棞", "slty");
            dic.Add("楐", "slwj");
            dic.Add("榲", "slwl");
            dic.Add("樏", "slxi");
            dic.Add("欏", "slxy");
            dic.Add("机", "sm");
            dic.Add("檂", "smae");
            dic.Add("柵", "smah");
            dic.Add("欁", "smas");
            dic.Add("椣", "smaw");
            dic.Add("杸", "smcy");
            dic.Add("椯", "smdj");
            dic.Add("柍", "smdy");
            dic.Add("榾", "smeg");
            dic.Add("枏", "smfg");
            dic.Add("柟", "smfg");
            dic.Add("椆", "smfk");
            dic.Add("柚", "smg");
            dic.Add("桐", "smgk");
            dic.Add("梬", "smgn");
            dic.Add("榿", "smgu");
            dic.Add("杣", "smh");
            dic.Add("栅", "smm");
            dic.Add("樱", "smmv");
            dic.Add("櫻", "smmv");
            dic.Add("楇", "smnk");
            dic.Add("桤", "smnn");
            dic.Add("檛", "smnp");
            dic.Add("枫", "smq");
            dic.Add("枧", "smqn");
            dic.Add("", "smqy");
            dic.Add("楓", "smtj");
            dic.Add("贾", "smu");
            dic.Add("賈", "smu");
            dic.Add("棡", "smum");
            dic.Add("棢", "smun");
            dic.Add("枘", "smw");
            dic.Add("欈", "smwk");
            dic.Add("梣", "smwn");
            dic.Add("梤", "smwv");
            dic.Add("槯", "smwy");
            dic.Add("梖", "smy");
            dic.Add("枬", "smyg");
            dic.Add("杋", "smyy");
            dic.Add("杨", "sn");
            dic.Add("榐", "snae");
            dic.Add("橄", "snb");
            dic.Add("朰", "snb");
            dic.Add("樼", "snbb");
            dic.Add("椐", "snd");
            dic.Add("橻", "snff");
            dic.Add("杻", "snfg");
            dic.Add("栩", "sng");
            dic.Add("楃", "sngf");
            dic.Add("柌", "sngk");
            dic.Add("楣", "snh");
            dic.Add("椵", "snhc");
            dic.Add("楈", "snhe");
            dic.Add("梉", "snhf");
            dic.Add("朻", "snhh");
            dic.Add("椲", "snhh");
            dic.Add("榍", "sni");
            dic.Add("樨", "snih");
            dic.Add("欘", "snij");
            dic.Add("蚻", "snju");
            dic.Add("檘", "snku");
            dic.Add("札", "snn");
            dic.Add("杞", "snn");
            dic.Add("梮", "snnk");
            dic.Add("梞", "snny");
            dic.Add("槢", "snrg");
            dic.Add("榓", "sntl");
            dic.Add("梶", "sntn");
            dic.Add("柲", "sntt");
            dic.Add("榌", "snuh");
            dic.Add("樛", "snwe");
            dic.Add("櫂", "snwy");
            dic.Add("紮", "snxi");
            dic.Add("柅", "snxn");
            dic.Add("杺", "sny");
            dic.Add("杰", "so");
            dic.Add("欉", "sogc");
            dic.Add("檏", "sogw");
            dic.Add("樸", "sogy");
            dic.Add("橩", "soof");
            dic.Add("檆", "sook");
            dic.Add("櫿", "sook");
            dic.Add("橯", "sool");
            dic.Add("棪", "sooy");
            dic.Add("橉", "soqh");
            dic.Add("粟", "sou");
            dic.Add("楼", "sov");
            dic.Add("棕", "sp");
            dic.Add("廼", "spd");
            dic.Add("迺", "spd");
            dic.Add("槣", "spdk");
            dic.Add("櫶", "spdn");
            dic.Add("椬", "speg");
            dic.Add("榢", "spey");
            dic.Add("梡", "spfq");
            dic.Add("楦", "spg");
            dic.Add("榁", "spgf");
            dic.Add("椗", "spgh");
            dic.Add("檳", "spgm");
            dic.Add("榠", "spju");
            dic.Add("楎", "splh");
            dic.Add("棺", "spn");
            dic.Add("橣", "spne");
            dic.Add("櫁", "spnj");
            dic.Add("樒", "spnm");
            dic.Add("檸", "spns");
            dic.Add("枕", "spq");
            dic.Add("椀", "spqb");
            dic.Add("槟", "spr");
            dic.Add("柠", "sps");
            dic.Add("楁", "sptk");
            dic.Add("榟", "spuh");
            dic.Add("桉", "spv");
            dic.Add("榨", "spw");
            dic.Add("椌", "spwa");
            dic.Add("檫", "spwi");
            dic.Add("樎", "spwj");
            dic.Add("榕", "spwk");
            dic.Add("棎", "spws");
            dic.Add("榷", "spwy");
            dic.Add("柼", "spwy");
            dic.Add("柁", "spx");
            dic.Add("榊", "spyh");
            dic.Add("构", "sq");
            dic.Add("柢", "sqa");
            dic.Add("桝", "sqah");
            dic.Add("棔", "sqaj");
            dic.Add("桰", "sqak");
            dic.Add("榤", "sqas");
            dic.Add("枊", "sqbh");
            dic.Add("栁", "sqbh");
            dic.Add("桞", "sqbh");
            dic.Add("椶", "sqbt");
            dic.Add("栬", "sqcn");
            dic.Add("桅", "sqd");
            dic.Add("桸", "sqdh");
            dic.Add("橪", "sqdo");
            dic.Add("檐", "sqdy");
            dic.Add("桷", "sqe");
            dic.Add("槲", "sqef");
            dic.Add("檞", "sqeh");
            dic.Add("橹", "sqg");
            dic.Add("栎", "sqi");
            dic.Add("橡", "sqj");
            dic.Add("栒", "sqjg");
            dic.Add("枸", "sqk");
            dic.Add("梚", "sqkq");
            dic.Add("欃", "sqky");
            dic.Add("枹", "sqnn");
            dic.Add("櫓", "sqoj");
            dic.Add("櫯", "sqot");
            dic.Add("椈", "sqoy");
            dic.Add("攀", "sqq");
            dic.Add("樊", "sqqd");
            dic.Add("礬", "sqqd");
            dic.Add("鬰", "sqqe");
            dic.Add("欎", "sqqf");
            dic.Add("欝", "sqqf");
            dic.Add("蠜", "sqqj");
            dic.Add("燓", "sqqo");
            dic.Add("鐢", "sqqq");
            dic.Add("棥", "sqqs");
            dic.Add("栘", "sqqy");
            dic.Add("楤", "sqrn");
            dic.Add("榝", "sqsc");
            dic.Add("樧", "sqsc");
            dic.Add("柳", "sqt");
            dic.Add("梑", "sqto");
            dic.Add("枃", "squg");
            dic.Add("檭", "sqve");
            dic.Add("棦", "sqvh");
            dic.Add("杴", "sqwy");
            dic.Add("榴", "sqy");
            dic.Add("橮", "sqym");
            dic.Add("杓", "sqyy");
            dic.Add("杦", "sqyy");
            dic.Add("析", "sr");
            dic.Add("梍", "sran");
            dic.Add("板", "src");
            dic.Add("柧", "srcy");
            dic.Add("槔", "srd");
            dic.Add("栃", "srdn");
            dic.Add("楯", "srfh");
            dic.Add("柏", "srg");
            dic.Add("栀", "srgb");
            dic.Add("梔", "srgc");
            dic.Add("楻", "srgg");
            dic.Add("梹", "srgw");
            dic.Add("杽", "srh");
            dic.Add("榹", "srhm");
            dic.Add("枛", "srhy");
            dic.Add("株", "sri");
            dic.Add("槹", "srif");
            dic.Add("檪", "sris");
            dic.Add("楾", "sriy");
            dic.Add("晳", "srjf");
            dic.Add("蜤", "srju");
            dic.Add("橅", "srlo");
            dic.Add("棉", "srm");
            dic.Add("鬱", "srme");
            dic.Add("惁", "srnu");
            dic.Add("槐", "srq");
            dic.Add("櫆", "srqf");
            dic.Add("皙", "srr");
            dic.Add("櫍", "srrm");
            dic.Add("椞", "srsu");
            dic.Add("椑", "srtf");
            dic.Add("柣", "srwy");
            dic.Add("権", "srwy");
            dic.Add("梎", "srxn");
            dic.Add("槪", "srxq");
            dic.Add("檄", "sry");
            dic.Add("覈", "sryt");
            dic.Add("柝", "sryy");
            dic.Add("林", "ss");
            dic.Add("郴", "ssb");
            dic.Add("樷", "ssbc");
            dic.Add("辳", "ssde");
            dic.Add("櫏", "ssdp");
            dic.Add("彬", "sse");
            dic.Add("禁", "ssf");
            dic.Add("埜", "ssff");
            dic.Add("標", "ssfi");
            dic.Add("檦", "ssfj");
            dic.Add("栖", "ssg");
            dic.Add("梄", "ssgg");
            dic.Add("梺", "ssgh");
            dic.Add("槱", "ssgo");
            dic.Add("朾", "ssh");
            dic.Add("楂", "ssj");
            dic.Add("橝", "ssjh");
            dic.Add("柯", "ssk");
            dic.Add("榃", "sslf");
            dic.Add("梵", "ssm");
            dic.Add("檒", "ssmj");
            dic.Add("槚", "ssmy");
            dic.Add("檟", "ssmy");
            dic.Add("楚", "ssn");
            dic.Add("焚", "sso");
            dic.Add("棾", "sspm");
            dic.Add("椘", "sspu");
            dic.Add("梦", "ssq");
            dic.Add("森", "sss");
            dic.Add("檚", "sssh");
            dic.Add("栗", "ssu");
            dic.Add("婪", "ssv");
            dic.Add("楆", "ssvg");
            dic.Add("棼", "ssw");
            dic.Add("棽", "sswn");
            dic.Add("鷅", "sswo");
            dic.Add("棶", "ssww");
            dic.Add("麓", "ssyx");
            dic.Add("格", "st");
            dic.Add("枨", "sta");
            dic.Add("枡", "stah");
            dic.Add("栙", "stah");
            dic.Add("杔", "stan");
            dic.Add("檱", "staw");
            dic.Add("柂", "stbn");
            dic.Add("桥", "std");
            dic.Add("栝", "stdg");
            dic.Add("桻", "stdh");
            dic.Add("椥", "stdk");
            dic.Add("橋", "stdk");
            dic.Add("槰", "stdp");
            dic.Add("枖", "stdy");
            dic.Add("橇", "stf");
            dic.Add("桁", "stf");
            dic.Add("杵", "stfh");
            dic.Add("杄", "stfh");
            dic.Add("櫡", "stfj");
            dic.Add("梏", "stfk");
            dic.Add("欑", "stfm");
            dic.Add("枆", "stfn");
            dic.Add("梃", "stfp");
            dic.Add("棰", "stg");
            dic.Add("栍", "stgg");
            dic.Add("棅", "stgi");
            dic.Add("櫄", "stgo");
            dic.Add("柞", "sth");
            dic.Add("橰", "sthf");
            dic.Add("梴", "sthp");
            dic.Add("櫋", "sthy");
            dic.Add("椼", "stih");
            dic.Add("楿", "stjg");
            dic.Add("梸", "stjh");
            dic.Add("椱", "stjt");
            dic.Add("楀", "stky");
            dic.Add("桖", "stlg");
            dic.Add("樬", "stln");
            dic.Add("榭", "stm");
            dic.Add("櫷", "stmg");
            dic.Add("栴", "stmy");
            dic.Add("杚", "stnn");
            dic.Add("柹", "stnt");
            dic.Add("楸", "sto");
            dic.Add("橎", "stol");
            dic.Add("覂", "stpu");
            dic.Add("柉", "stpy");
            dic.Add("橁", "stqj");
            dic.Add("覆", "stt");
            dic.Add("櫤", "stuj");
            dic.Add("柊", "stuy");
            dic.Add("櫛", "stvb");
            dic.Add("樅", "stwh");
            dic.Add("梅", "stx");
            dic.Add("枚", "sty");
            dic.Add("柇", "sty");
            dic.Add("樦", "styg");
            dic.Add("杁", "styy");
            dic.Add("样", "su");
            dic.Add("栟", "suah");
            dic.Add("樴", "suaj");
            dic.Add("槎", "suda");
            dic.Add("棬", "sudb");
            dic.Add("橏", "sudk");
            dic.Add("椦", "sudl");
            dic.Add("栚", "sudy");
            dic.Add("櫳", "sued");
            dic.Add("橌", "sueg");
            dic.Add("椾", "suej");
            dic.Add("檖", "suep");
            dic.Add("栏", "suf");
            dic.Add("枓", "sufh");
            dic.Add("柈", "sufh");
            dic.Add("柆", "sug");
            dic.Add("椚", "sug");
            dic.Add("橍", "sugg");
            dic.Add("様", "sugi");
            dic.Add("樣", "sugi");
            dic.Add("欄", "sugi");
            dic.Add("榚", "sugo");
            dic.Add("檥", "sugt");
            dic.Add("檨", "sugw");
            dic.Add("梓", "suh");
            dic.Add("栤", "suiy");
            dic.Add("樟", "suj");
            dic.Add("椫", "sujf");
            dic.Add("橦", "sujf");
            dic.Add("橺", "sujg");
            dic.Add("槞", "sujn");
            dic.Add("檍", "sujn");
            dic.Add("樈", "sujq");
            dic.Add("榈", "suk");
            dic.Add("棓", "sukg");
            dic.Add("櫚", "sukk");
            dic.Add("棁", "sukq");
            dic.Add("橧", "sulj");
            dic.Add("樀", "sumd");
            dic.Add("椪", "suog");
            dic.Add("榜", "sup");
            dic.Add("楴", "suph");
            dic.Add("校", "suq");
            dic.Add("櫩", "suqv");
            dic.Add("栨", "suqw");
            dic.Add("橷", "surq");
            dic.Add("榇", "sus");
            dic.Add("橂", "susd");
            dic.Add("樽", "susf");
            dic.Add("楢", "susg");
            dic.Add("櫬", "susq");
            dic.Add("槉", "sutd");
            dic.Add("楌", "sute");
            dic.Add("櫊", "sutk");
            dic.Add("檤", "sutp");
            dic.Add("椄", "suvg");
            dic.Add("槏", "suvo");
            dic.Add("榏", "suwl");
            dic.Add("梯", "sux");
            dic.Add("檓", "svac");
            dic.Add("樳", "svaf");
            dic.Add("概", "svc");
            dic.Add("楖", "svcb");
            dic.Add("櫭", "svcg");
            dic.Add("根", "sve");
            dic.Add("梛", "svfb");
            dic.Add("枠", "svfh");
            dic.Add("橚", "svfj");
            dic.Add("楗", "svfp");
            dic.Add("桪", "svfy");
            dic.Add("桕", "svg");
            dic.Add("櫸", "svgh");
            dic.Add("欅", "svgr");
            dic.Add("棣", "svi");
            dic.Add("椂", "sviy");
            dic.Add("樔", "svjs");
            dic.Add("柖", "svkg");
            dic.Add("椔", "svlg");
            dic.Add("朷", "svn");
            dic.Add("朹", "svn");
            dic.Add("棂", "svo");
            dic.Add("梫", "svpc");
            dic.Add("棿", "svqn");
            dic.Add("覅", "svqr");
            dic.Add("桚", "svqy");
            dic.Add("桾", "svtk");
            dic.Add("榋", "svvv");
            dic.Add("楰", "svwy");
            dic.Add("梕", "svyn");
            dic.Add("杒", "svyy");
            dic.Add("检", "sw");
            dic.Add("栰", "swat");
            dic.Add("枪", "swb");
            dic.Add("松", "swc");
            dic.Add("棇", "swcn");
            dic.Add("枩", "swcu");
            dic.Add("椴", "swd");
            dic.Add("覄", "swdu");
            dic.Add("栿", "swdy");
            dic.Add("桧", "swf");
            dic.Add("柎", "swfy");
            dic.Add("栓", "swg");
            dic.Add("棆", "swga");
            dic.Add("椧", "swgb");
            dic.Add("楡", "swgb");
            dic.Add("楑", "swgd");
            dic.Add("榆", "swgj");
            dic.Add("檜", "swgj");
            dic.Add("櫈", "swgm");
            dic.Add("枍", "swgn");
            dic.Add("楩", "swgq");
            dic.Add("橙", "swgu");
            dic.Add("検", "swgw");
            dic.Add("檢", "swgw");
            dic.Add("樇", "swhe");
            dic.Add("樤", "swhs");
            dic.Add("厀", "swib");
            dic.Add("桼", "swiu");
            dic.Add("柗", "swkg");
            dic.Add("梲", "swkq");
            dic.Add("椺", "swks");
            dic.Add("槌", "swn");
            dic.Add("桘", "swnn");
            dic.Add("栣", "swtf");
            dic.Add("梌", "swty");
            dic.Add("槝", "swvm");
            dic.Add("枌", "swvn");
            dic.Add("樢", "swvo");
            dic.Add("椕", "swvs");
            dic.Add("枞", "sww");
            dic.Add("麯", "swwa");
            dic.Add("郲", "swwb");
            dic.Add("麬", "swwc");
            dic.Add("麮", "swwc");
            dic.Add("麶", "swwc");
            dic.Add("猌", "swwd");
            dic.Add("麵", "swwd");
            dic.Add("桽", "swwf");
            dic.Add("櫼", "swwg");
            dic.Add("麰", "swwh");
            dic.Add("來", "swwi");
            dic.Add("勑", "swwl");
            dic.Add("賚", "swwm");
            dic.Add("顂", "swwm");
            dic.Add("愸", "swwn");
            dic.Add("憖", "swwn");
            dic.Add("憗", "swwn");
            dic.Add("麧", "swwn");
            dic.Add("麪", "swwn");
            dic.Add("麫", "swwn");
            dic.Add("麭", "swwn");
            dic.Add("鶆", "swwo");
            dic.Add("逨", "swwp");
            dic.Add("麲", "swwq");
            dic.Add("麥", "swwt");
            dic.Add("麨", "swwt");
            dic.Add("麷", "swwu");
            dic.Add("麩", "swww");
            dic.Add("麳", "swww");
            dic.Add("麱", "swwy");
            dic.Add("桦", "swx");
            dic.Add("橃", "swxc");
            dic.Add("梻", "swxj");
            dic.Add("杹", "swxn");
            dic.Add("椎", "swy");
            dic.Add("柃", "swy");
            dic.Add("朲", "swy");
            dic.Add("朳", "swy");
            dic.Add("檎", "swyc");
            dic.Add("欆", "swyc");
            dic.Add("槜", "swye");
            dic.Add("榫", "swyf");
            dic.Add("梒", "swyk");
            dic.Add("槍", "swyk");
            dic.Add("枔", "swyn");
            dic.Add("棯", "swyn");
            dic.Add("檇", "swyn");
            dic.Add("樵", "swyo");
            dic.Add("楷", "sx");
            dic.Add("椽", "sxe");
            dic.Add("欚", "sxej");
            dic.Add("樌", "sxfm");
            dic.Add("栂", "sxgu");
            dic.Add("槇", "sxhw");
            dic.Add("栺", "sxjg");
            dic.Add("柫", "sxjh");
            dic.Add("柪", "sxln");
            dic.Add("朼", "sxn");
            dic.Add("杛", "sxn");
            dic.Add("檰", "sxrh");
            dic.Add("櫟", "sxrs");
            dic.Add("榒", "sxuu");
            dic.Add("橼", "sxxe");
            dic.Add("櫞", "sxxe");
            dic.Add("梐", "sxxf");
            dic.Add("枇", "sxxn");
            dic.Add("檵", "sxxn");
            dic.Add("機", "sxxt");
            dic.Add("术", "sy");
            dic.Add("樜", "syao");
            dic.Add("櫎", "syaw");
            dic.Add("椁", "syb");
            dic.Add("槨", "sybb");
            dic.Add("樆", "sybc");
            dic.Add("梈", "sybh");
            dic.Add("橔", "sybt");
            dic.Add("梳", "syc");
            dic.Add("棛", "syce");
            dic.Add("橀", "sycl");
            dic.Add("桩", "syf");
            dic.Add("堏", "syff");
            dic.Add("櫥", "syff");
            dic.Add("槠", "syfj");
            dic.Add("櫧", "syfj");
            dic.Add("柱", "syg");
            dic.Add("椋", "syiy");
            dic.Add("櫅", "syjg");
            dic.Add("榱", "syk");
            dic.Add("欀", "syke");
            dic.Add("檀", "syl");
            dic.Add("櫰", "syle");
            dic.Add("檩", "syli");
            dic.Add("檁", "sylt");
            dic.Add("杭", "sym");
            dic.Add("柿", "symh");
            dic.Add("槁", "symk");
            dic.Add("枋", "syn");
            dic.Add("楄", "syna");
            dic.Add("槴", "sync");
            dic.Add("棙", "synd");
            dic.Add("栐", "syni");
            dic.Add("杧", "synn");
            dic.Add("枦", "synt");
            dic.Add("櫦", "synt");
            dic.Add("怸", "synu");
            dic.Add("核", "synw");
            dic.Add("樚", "synx");
            dic.Add("椖", "syny");
            dic.Add("述", "syp");
            dic.Add("檺", "sype");
            dic.Add("鶐", "sypo");
            dic.Add("楟", "syps");
            dic.Add("橠", "syqe");
            dic.Add("椸", "sytb");
            dic.Add("栦", "syth");
            dic.Add("檹", "sytk");
            dic.Add("榳", "sytp");
            dic.Add("榔", "syv");
            dic.Add("桹", "syve");
            dic.Add("樃", "syve");
            dic.Add("槦", "syvh");
            dic.Add("槺", "syvi");
            dic.Add("榶", "syvk");
            dic.Add("椩", "syvw");
            dic.Add("櫠", "sywc");
            dic.Add("椊", "sywf");
            dic.Add("椨", "sywf");
            dic.Add("棜", "sywu");
            dic.Add("棭", "sywy");
            dic.Add("槒", "syxl");
            dic.Add("和", "t");
            dic.Add("禾", "t");
            dic.Add("长", "ta");
            dic.Add("箋", "taar");
            dic.Add("筇", "tab");
            dic.Add("穁", "tabg");
            dic.Add("笻", "tabj");
            dic.Add("箕", "tad");
            dic.Add("簸", "tadc");
            dic.Add("篚", "tadd");
            dic.Add("簊", "tadf");
            dic.Add("箬", "tadk");
            dic.Add("簛", "tadr");
            dic.Add("稘", "tadw");
            dic.Add("篋", "tadw");
            dic.Add("笁", "taf");
            dic.Add("簕", "tafl");
            dic.Add("篏", "tafw");
            dic.Add("筐", "tag");
            dic.Add("箧", "tagw");
            dic.Add("筺", "tagy");
            dic.Add("逄", "tah");
            dic.Add("夅", "tahj");
            dic.Add("籃", "tahl");
            dic.Add("熈", "taho");
            dic.Add("笌", "taht");
            dic.Add("徣", "tajg");
            dic.Add("稓", "tajg");
            dic.Add("升", "tak");
            dic.Add("稶", "take");
            dic.Add("笸", "takf");
            dic.Add("稢", "takg");
            dic.Add("籄", "takm");
            dic.Add("筪", "talj");
            dic.Add("筑", "tam");
            dic.Add("篫", "tamr");
            dic.Add("築", "tams");
            dic.Add("篢", "tamu");
            dic.Add("簧", "tamw");
            dic.Add("穔", "tamw");
            dic.Add("笹", "tanb");
            dic.Add("秬", "tang");
            dic.Add("衐", "tanh");
            dic.Add("徔", "tapy");
            dic.Add("簪", "taq");
            dic.Add("乇", "tav");
            dic.Add("彻", "tavn");
            dic.Add("筮", "taw");
            dic.Add("穫", "tawc");
            dic.Add("籆", "tawc");
            dic.Add("衖", "tawh");
            dic.Add("簭", "tawk");
            dic.Add("遾", "tawp");
            dic.Add("季", "tb");
            dic.Add("竾", "tbb");
            dic.Add("箃", "tbcu");
            dic.Add("秄", "tbg");
            dic.Add("篜", "tbio");
            dic.Add("笜", "tbmj");
            dic.Add("彵", "tbn");
            dic.Add("迤", "tbp");
            dic.Add("箛", "tbry");
            dic.Add("篨", "tbwt");
            dic.Add("么", "tc");
            dic.Add("径", "tca");
            dic.Add("笲", "tcaj");
            dic.Add("笆", "tcb");
            dic.Add("穇", "tcce");
            dic.Add("篸", "tcce");
            dic.Add("", "tcde");
            dic.Add("筩", "tcej");
            dic.Add("笃", "tcf");
            dic.Add("笞", "tck");
            dic.Add("秮", "tckg");
            dic.Add("篤", "tcu");
            dic.Add("稄", "tcwt");
            dic.Add("私", "tcy");
            dic.Add("知", "td");
            dic.Add("矩", "tda");
            dic.Add("矱", "tdac");
            dic.Add("甜", "tdaf");
            dic.Add("憇", "tdan");
            dic.Add("榘", "tdas");
            dic.Add("叐", "tdcu");
            dic.Add("秡", "tdcy");
            dic.Add("舌", "tdd");
            dic.Add("頢", "tddm");
            dic.Add("箶", "tdef");
            dic.Add("衚", "tdeh");
            dic.Add("圱", "tdfg");
            dic.Add("短", "tdg");
            dic.Add("秙", "tdg");
            dic.Add("舔", "tdgn");
            dic.Add("箴", "tdgt");
            dic.Add("逢", "tdh");
            dic.Add("稧", "tdhd");
            dic.Add("夆", "tdhj");
            dic.Add("蠭", "tdhj");
            dic.Add("篲", "tdhv");
            dic.Add("夭", "tdi");
            dic.Add("籍", "tdij");
            dic.Add("筙", "tdiu");
            dic.Add("乔", "tdj");
            dic.Add("徘", "tdjd");
            dic.Add("昋", "tdjf");
            dic.Add("刮", "tdjh");
            dic.Add("刋", "tdjh");
            dic.Add("舓", "tdjr");
            dic.Add("聟", "tdkb");
            dic.Add("敽", "tdkc");
            dic.Add("呑", "tdkf");
            dic.Add("智", "tdkj");
            dic.Add("喬", "tdkk");
            dic.Add("勪", "tdkl");
            dic.Add("鷮", "tdko");
            dic.Add("敿", "tdkt");
            dic.Add("鼅", "tdkv");
            dic.Add("矲", "tdlx");
            dic.Add("岙", "tdm");
            dic.Add("稬", "tdmd");
            dic.Add("舑", "tdmf");
            dic.Add("乱", "tdn");
            dic.Add("舏", "tdnh");
            dic.Add("稽", "tdnj");
            dic.Add("嵇", "tdnm");
            dic.Add("嵆", "tdnm");
            dic.Add("筬", "tdnt");
            dic.Add("諬", "tdny");
            dic.Add("舕", "tdoo");
            dic.Add("适", "tdp");
            dic.Add("鸹", "tdq");
            dic.Add("舐", "tdqa");
            dic.Add("舚", "tdqy");
            dic.Add("徛", "tdsk");
            dic.Add("敌", "tdt");
            dic.Add("矨", "tdtd");
            dic.Add("舙", "tdtd");
            dic.Add("矪", "tdte");
            dic.Add("筹", "tdtf");
            dic.Add("矫", "tdtj");
            dic.Add("矯", "tdtk");
            dic.Add("憩", "tdtn");
            dic.Add("矮", "tdtv");
            dic.Add("矢", "tdu");
            dic.Add("辞", "tduh");
            dic.Add("簝", "tdui");
            dic.Add("矰", "tduj");
            dic.Add("矬", "tdw");
            dic.Add("箺", "tdwj");
            dic.Add("谸", "tdwk");
            dic.Add("鴁", "tdwo");
            dic.Add("鴙", "tdwo");
            dic.Add("鴰", "tdwo");
            dic.Add("筴", "tdww");
            dic.Add("雉", "tdwy");
            dic.Add("笼", "tdx");
            dic.Add("矧", "tdxh");
            dic.Add("秀", "te");
            dic.Add("舡", "tea");
            dic.Add("艧", "teac");
            dic.Add("艨", "teae");
            dic.Add("艜", "teah");
            dic.Add("艦", "teal");
            dic.Add("穩", "tean");
            dic.Add("艓", "teas");
            dic.Add("舼", "teaw");
            dic.Add("箙", "tebc");
            dic.Add("筟", "tebf");
            dic.Add("稃", "tebg");
            dic.Add("郍", "tebh");
            dic.Add("艋", "tebl");
            dic.Add("舥", "tecn");
            dic.Add("頺", "tedm");
            dic.Add("舿", "tedn");
            dic.Add("舦", "tedy");
            dic.Add("艀", "teeb");
            dic.Add("稝", "teeg");
            dic.Add("艢", "tefk");
            dic.Add("艝", "tefv");
            dic.Add("租", "teg");
            dic.Add("徂", "teg");
            dic.Add("笡", "tegf");
            dic.Add("艚", "tegj");
            dic.Add("筯", "tegl");
            dic.Add("舻", "teh");
            dic.Add("稲", "tehj");
            dic.Add("艣", "tehl");
            dic.Add("艫", "tehl");
            dic.Add("舟", "tei");
            dic.Add("艄", "teie");
            dic.Add("艡", "teil");
            dic.Add("艃", "tejf");
            dic.Add("艒", "tejh");
            dic.Add("舯", "tek");
            dic.Add("甪", "tek");
            dic.Add("艥", "tekt");
            dic.Add("艛", "tekv");
            dic.Add("盘", "tel");
            dic.Add("筋", "telb");
            dic.Add("穱", "telf");
            dic.Add("舺", "telh");
            dic.Add("般", "tem");
            dic.Add("磐", "temd");
            dic.Add("褩", "teme");
            dic.Add("稱", "temf");
            dic.Add("鞶", "temf");
            dic.Add("舳", "temg");
            dic.Add("舢", "temh");
            dic.Add("幋", "temh");
            dic.Add("縏", "temi");
            dic.Add("螌", "temj");
            dic.Add("船", "temk");
            dic.Add("盤", "teml");
            dic.Add("舰", "temq");
            dic.Add("鎜", "temq");
            dic.Add("搫", "temr");
            dic.Add("槃", "tems");
            dic.Add("媻", "temv");
            dic.Add("舤", "temy");
            dic.Add("艉", "ten");
            dic.Add("艍", "tend");
            dic.Add("透", "tep");
            dic.Add("篴", "tepu");
            dic.Add("舵", "tepx");
            dic.Add("鸼", "teqg");
            dic.Add("艪", "teqj");
            dic.Add("艐", "teqt");
            dic.Add("艬", "teqy");
            dic.Add("舶", "ter");
            dic.Add("舨", "terc");
            dic.Add("簲", "terf");
            dic.Add("艎", "terg");
            dic.Add("艊", "terh");
            dic.Add("徭", "term");
            dic.Add("舸", "tes");
            dic.Add("舾", "tesg");
            dic.Add("艇", "tet");
            dic.Add("舴", "tetf");
            dic.Add("舽", "teth");
            dic.Add("艂", "teth");
            dic.Add("艁", "tetk");
            dic.Add("艞", "tetq");
            dic.Add("舧", "tety");
            dic.Add("艏", "teu");
            dic.Add("艖", "teua");
            dic.Add("艟", "teuf");
            dic.Add("籐", "teui");
            dic.Add("籘", "teui");
            dic.Add("艗", "teul");
            dic.Add("艤", "teut");
            dic.Add("艕", "teuy");
            dic.Add("稻", "tev");
            dic.Add("艘", "tevc");
            dic.Add("箏", "tevh");
            dic.Add("穏", "tevn");
            dic.Add("舠", "tevn");
            dic.Add("舱", "tew");
            dic.Add("舩", "tewc");
            dic.Add("舲", "tewc");
            dic.Add("艭", "tewc");
            dic.Add("艙", "tewk");
            dic.Add("艌", "tewn");
            dic.Add("鵃", "tewo");
            dic.Add("艅", "tewt");
            dic.Add("艠", "tewu");
            dic.Add("舭", "tex");
            dic.Add("徯", "texd");
            dic.Add("航", "tey");
            dic.Add("艑", "teya");
            dic.Add("艔", "teyc");
            dic.Add("艆", "teye");
            dic.Add("艩", "teyf");
            dic.Add("舫", "teyn");
            dic.Add("舮", "teyn");
            dic.Add("舣", "teyq");
            dic.Add("艈", "teyq");
            dic.Add("笈", "teyu");
            dic.Add("舷", "teyx");
            dic.Add("彶", "teyy");
            dic.Add("行", "tf");
            dic.Add("籖", "tfag");
            dic.Add("丢", "tfc");
            dic.Add("篕", "tfcl");
            dic.Add("秐", "tfcy");
            dic.Add("秓", "tfcy");
            dic.Add("壬", "tfd");
            dic.Add("", "tfd");
            dic.Add("穤", "tfdj");
            dic.Add("竺", "tff");
            dic.Add("玍", "tff");
            dic.Add("筀", "tfff");
            dic.Add("篈", "tfff");
            dic.Add("徍", "tffg");
            dic.Add("街", "tffh");
            dic.Add("衎", "tffh");
            dic.Add("徺", "tffq");
            dic.Add("穘", "tffq");
            dic.Add("等", "tffu");
            dic.Add("待", "tffy");
            dic.Add("秲", "tffy");
            dic.Add("簙", "tfgf");
            dic.Add("啎", "tfgk");
            dic.Add("秆", "tfh");
            dic.Add("徝", "tfhg");
            dic.Add("稙", "tfhg");
            dic.Add("鸻", "tfhg");
            dic.Add("衠", "tfhh");
            dic.Add("憄", "tfhn");
            dic.Add("鴴", "tfho");
            dic.Add("稹", "tfhw");
            dic.Add("徒", "tfhy");
            dic.Add("午", "tfj");
            dic.Add("竿", "tfj");
            dic.Add("篝", "tfjf");
            dic.Add("簳", "tfjf");
            dic.Add("千", "tfk");
            dic.Add("鹄", "tfk");
            dic.Add("郜", "tfkb");
            dic.Add("靠", "tfkd");
            dic.Add("告", "tfkf");
            dic.Add("籉", "tfkf");
            dic.Add("秸", "tfkg");
            dic.Add("穯", "tfkk");
            dic.Add("勂", "tfkl");
            dic.Add("頶", "tfkm");
            dic.Add("鵠", "tfko");
            dic.Add("造", "tfkp");
            dic.Add("德", "tfl");
            dic.Add("徳", "tfln");
            dic.Add("毛", "tfn");
            dic.Add("氆", "tfn");
            dic.Add("毧", "tfnd");
            dic.Add("毴", "tfnd");
            dic.Add("氁", "tfnd");
            dic.Add("毝", "tfne");
            dic.Add("毶", "tfne");
            dic.Add("籌", "tfnf");
            dic.Add("氊", "tfng");
            dic.Add("毪", "tfnh");
            dic.Add("毜", "tfni");
            dic.Add("氇", "tfnj");
            dic.Add("毥", "tfnj");
            dic.Add("毺", "tfnj");
            dic.Add("氌", "tfnj");
            dic.Add("毡", "tfnk");
            dic.Add("毰", "tfnk");
            dic.Add("毳", "tfnn");
            dic.Add("毸", "tfnn");
            dic.Add("毯", "tfno");
            dic.Add("毩", "tfno");
            dic.Add("毱", "tfno");
            dic.Add("毽", "tfnp");
            dic.Add("毨", "tfnq");
            dic.Add("覒", "tfnq");
            dic.Add("毢", "tfns");
            dic.Add("忎", "tfnu");
            dic.Add("毬", "tfny");
            dic.Add("迁", "tfp");
            dic.Add("迕", "tfp");
            dic.Add("廷", "tfpd");
            dic.Add("頲", "tfpm");
            dic.Add("颋", "tfpm");
            dic.Add("先", "tfq");
            dic.Add("笎", "tfqb");
            dic.Add("酂", "tfqb");
            dic.Add("酇", "tfqb");
            dic.Add("衏", "tfqh");
            dic.Add("劗", "tfqj");
            dic.Add("赞", "tfqm");
            dic.Add("贊", "tfqm");
            dic.Add("选", "tfqp");
            dic.Add("兟", "tfqq");
            dic.Add("筠", "tfqu");
            dic.Add("箸", "tft");
            dic.Add("幷", "tftf");
            dic.Add("筓", "tftf");
            dic.Add("甁", "tftn");
            dic.Add("逬", "tftp");
            dic.Add("乖", "tfu");
            dic.Add("埀", "tfuf");
            dic.Add("穑", "tfuk");
            dic.Add("敮", "tfvc");
            dic.Add("臿", "tfvd");
            dic.Add("歃", "tfvw");
            dic.Add("稑", "tfwf");
            dic.Add("簮", "tfwj");
            dic.Add("穡", "tfwk");
            dic.Add("稜", "tfwt");
            dic.Add("籗", "tfwy");
            dic.Add("籱", "tfwy");
            dic.Add("生", "tg");
            dic.Add("垂", "tga");
            dic.Add("郵", "tgab");
            dic.Add("笄", "tgaj");
            dic.Add("剰", "tgaj");
            dic.Add("筭", "tgaj");
            dic.Add("甀", "tgan");
            dic.Add("乗", "tgas");
            dic.Add("秷", "tgcf");
            dic.Add("箌", "tgcj");
            dic.Add("箐", "tge");
            dic.Add("簠", "tgel");
            dic.Add("秿", "tgey");
            dic.Add("竽", "tgf");
            dic.Add("稏", "tgfg");
            dic.Add("彺", "tgg");
            dic.Add("征", "tgh");
            dic.Add("眚", "tghf");
            dic.Add("徰", "tghh");
            dic.Add("惩", "tghn");
            dic.Add("篶", "tgho");
            dic.Add("秠", "tgig");
            dic.Add("重", "tgj");
            dic.Add("篿", "tgjf");
            dic.Add("濌", "tgjj");
            dic.Add("動", "tgjl");
            dic.Add("穗", "tgjn");
            dic.Add("穂", "tgjn");
            dic.Add("憅", "tgjn");
            dic.Add("勲", "tgjo");
            dic.Add("筻", "tgjq");
            dic.Add("稉", "tgjq");
            dic.Add("衙", "tgk");
            dic.Add("稫", "tgkl");
            dic.Add("籁", "tgkm");
            dic.Add("籟", "tgkm");
            dic.Add("簌", "tgkw");
            dic.Add("熏", "tgl");
            dic.Add("徚", "tgli");
            dic.Add("甥", "tgll");
            dic.Add("勳", "tgll");
            dic.Add("策", "tgm");
            dic.Add("箣", "tgmj");
            dic.Add("箦", "tgmu");
            dic.Add("簀", "tgmu");
            dic.Add("穲", "tgmx");
            dic.Add("籭", "tgmx");
            dic.Add("積", "tgmy");
            dic.Add("徕", "tgo");
            dic.Add("笺", "tgr");
            dic.Add("秣", "tgs");
            dic.Add("甧", "tgte");
            dic.Add("甡", "tgtg");
            dic.Add("秤", "tgu");
            dic.Add("秉", "tgv");
            dic.Add("徑", "tgva");
            dic.Add("徢", "tgvh");
            dic.Add("箑", "tgvh");
            dic.Add("穪", "tgwq");
            dic.Add("籋", "tgwq");
            dic.Add("处", "th");
            dic.Add("算", "tha");
            dic.Add("籚", "thal");
            dic.Add("箎", "tham");
            dic.Add("籧", "thap");
            dic.Add("簴", "thaw");
            dic.Add("郋", "thbh");
            dic.Add("彼", "thc");
            dic.Add("秛", "thcy");
            dic.Add("自", "thd");
            dic.Add("篹", "thdb");
            dic.Add("鄓", "thdb");
            dic.Add("篡", "thdc");
            dic.Add("簒", "thdc");
            dic.Add("籑", "thde");
            dic.Add("纂", "thdi");
            dic.Add("穢", "thdt");
            dic.Add("臭", "thdu");
            dic.Add("乍", "thf");
            dic.Add("怎", "thfn");
            dic.Add("迮", "thfp");
            dic.Add("片", "thg");
            dic.Add("牋", "thga");
            dic.Add("牑", "thga");
            dic.Add("版", "thgc");
            dic.Add("牍", "thgd");
            dic.Add("牌", "thgf");
            dic.Add("牉", "thgf");
            dic.Add("牔", "thgf");
            dic.Add("牗", "thgh");
            dic.Add("牏", "thgj");
            dic.Add("牊", "thgk");
            dic.Add("牘", "thgm");
            dic.Add("牎", "thgn");
            dic.Add("牕", "thgn");
            dic.Add("覑", "thgq");
            dic.Add("牒", "thgs");
            dic.Add("牐", "thgv");
            dic.Add("臰", "thgx");
            dic.Add("牖", "thgy");
            dic.Add("牓", "thgy");
            dic.Add("徙", "thh");
            dic.Add("籰", "thhc");
            dic.Add("衢", "thhh");
            dic.Add("忂", "thhy");
            dic.Add("臯", "thif");
            dic.Add("翺", "thin");
            dic.Add("鷱", "thio");
            dic.Add("徏", "thit");
            dic.Add("篎", "thit");
            dic.Add("昝", "thj");
            dic.Add("咎", "thk");
            dic.Add("笘", "thkf");
            dic.Add("秥", "thkg");
            dic.Add("鼻", "thl");
            dic.Add("劓", "thl");
            dic.Add("齆", "thlc");
            dic.Add("齅", "thld");
            dic.Add("齈", "thle");
            dic.Add("齉", "thle");
            dic.Add("鼾", "thlf");
            dic.Add("齄", "thlg");
            dic.Add("齇", "thlg");
            dic.Add("鼼", "thlh");
            dic.Add("齂", "thli");
            dic.Add("齁", "thlk");
            dic.Add("齀", "thln");
            dic.Add("齃", "thln");
            dic.Add("鼿", "thlq");
            dic.Add("鼽", "thlv");
            dic.Add("息", "thn");
            dic.Add("鄎", "thnb");
            dic.Add("臫", "thnn");
            dic.Add("延", "thp");
            dic.Add("郔", "thpb");
            dic.Add("蜑", "thpj");
            dic.Add("邉", "thpp");
            dic.Add("邊", "thpp");
            dic.Add("臱", "thpy");
            dic.Add("筧", "thqb");
            dic.Add("臬", "ths");
            dic.Add("臲", "thsb");
            dic.Add("甈", "thsn");
            dic.Add("鷍", "thso");
            dic.Add("辠", "thuj");
            dic.Add("臮", "thwu");
            dic.Add("秒", "ti");
            dic.Add("篊", "tiaw");
            dic.Add("笵", "tibb");
            dic.Add("筂", "tibb");
            dic.Add("箈", "tick");
            dic.Add("稍", "tie");
            dic.Add("筲", "tief");
            dic.Add("箾", "tiej");
            dic.Add("衍", "tif");
            dic.Add("愆", "tifn");
            dic.Add("簿", "tig");
            dic.Add("箥", "tihc");
            dic.Add("乑", "tii");
            dic.Add("篞", "tijf");
            dic.Add("簜", "tijr");
            dic.Add("徜", "tim");
            dic.Add("簹", "tipl");
            dic.Add("筄", "tiqb");
            dic.Add("箔", "tir");
            dic.Add("箵", "tith");
            dic.Add("籓", "titl");
            dic.Add("箲", "titq");
            dic.Add("尓", "tiu");
            dic.Add("筜", "tivf");
            dic.Add("簗", "tivs");
            dic.Add("得", "tj");
            dic.Add("馢", "tjaa");
            dic.Add("篳", "tjaf");
            dic.Add("穝", "tjbc");
            dic.Add("忁", "tjbi");
            dic.Add("馛", "tjdc");
            dic.Add("馡", "tjdd");
            dic.Add("馣", "tjdn");
            dic.Add("馟", "tjeb");
            dic.Add("香", "tjf");
            dic.Add("馞", "tjfb");
            dic.Add("稈", "tjfh");
            dic.Add("筸", "tjfj");
            dic.Add("馩", "tjfm");
            dic.Add("笪", "tjg");
            dic.Add("筛", "tjgh");
            dic.Add("徥", "tjgh");
            dic.Add("利", "tjh");
            dic.Add("馧", "tjjl");
            dic.Add("馤", "tjjn");
            dic.Add("馝", "tjnt");
            dic.Add("悡", "tjnu");
            dic.Add("馜", "tjnx");
            dic.Add("馪", "tjpm");
            dic.Add("鋫", "tjqf");
            dic.Add("犁", "tjr");
            dic.Add("梨", "tjs");
            dic.Add("稞", "tjsy");
            dic.Add("复", "tjt");
            dic.Add("篂", "tjtg");
            dic.Add("馫", "tjtj");
            dic.Add("篮", "tjtl");
            dic.Add("馥", "tjtt");
            dic.Add("馦", "tjuo");
            dic.Add("馠", "tjwk");
            dic.Add("馚", "tjwv");
            dic.Add("箟", "tjxx");
            dic.Add("各", "tk");
            dic.Add("箿", "tkbf");
            dic.Add("頟", "tkdm");
            dic.Add("筽", "tkgd");
            dic.Add("程", "tkgg");
            dic.Add("徎", "tkgg");
            dic.Add("籔", "tkgt");
            dic.Add("簍", "tkgv");
            dic.Add("种", "tkh");
            dic.Add("簬", "tkhk");
            dic.Add("篑", "tkhm");
            dic.Add("簣", "tkhm");
            dic.Add("洜", "tkiu");
            dic.Add("稆", "tkk");
            dic.Add("筥", "tkkf");
            dic.Add("簞", "tkkf");
            dic.Add("禹", "tkm");
            dic.Add("鄅", "tkmb");
            dic.Add("筼", "tkmu");
            dic.Add("篔", "tkmu");
            dic.Add("惒", "tknu");
            dic.Add("兎", "tkqy");
            dic.Add("敋", "tkty");
            dic.Add("积", "tkw");
            dic.Add("雒", "tkw");
            dic.Add("鵅", "tkwo");
            dic.Add("务", "tl");
            dic.Add("簂", "tlag");
            dic.Add("簚", "tlah");
            dic.Add("衊", "tlat");
            dic.Add("穓", "tlaw");
            dic.Add("竻", "tlb");
            dic.Add("範", "tlbb");
            dic.Add("衈", "tlbg");
            dic.Add("卹", "tlbh");
            dic.Add("笝", "tlcu");
            dic.Add("血", "tld");
            dic.Add("甶", "tld");
            dic.Add("箇", "tldf");
            dic.Add("稒", "tldg");
            dic.Add("篾", "tldt");
            dic.Add("筃", "tldu");
            dic.Add("秵", "tldy");
            dic.Add("稩", "tleg");
            dic.Add("备", "tlf");
            dic.Add("盉", "tlf");
            dic.Add("笽", "tlf");
            dic.Add("睾", "tlff");
            dic.Add("箅", "tlg");
            dic.Add("衃", "tlgi");
            dic.Add("笚", "tlj");
            dic.Add("徊", "tlk");
            dic.Add("笳", "tlkf");
            dic.Add("簤", "tlmu");
            dic.Add("惫", "tln");
            dic.Add("衄", "tlnf");
            dic.Add("粤", "tlo");
            dic.Add("笾", "tlp");
            dic.Add("箩", "tlq");
            dic.Add("囟", "tlq");
            dic.Add("囱", "tlqi");
            dic.Add("顖", "tlqm");
            dic.Add("恖", "tlqn");
            dic.Add("悤", "tlqn");
            dic.Add("欰", "tlqw");
            dic.Add("簐", "tlqw");
            dic.Add("衇", "tlre");
            dic.Add("囪", "tlry");
            dic.Add("稇", "tlsy");
            dic.Add("衆", "tlti");
            dic.Add("簵", "tltk");
            dic.Add("衉", "tltk");
            dic.Add("箘", "tltu");
            dic.Add("稛", "tlty");
            dic.Add("衅", "tlu");
            dic.Add("邍", "tlvp");
            dic.Add("衂", "tlvy");
            dic.Add("稷", "tlw");
            dic.Add("籮", "tlxy");
            dic.Add("向", "tm");
            dic.Add("穠", "tmae");
            dic.Add("筁", "tmaf");
            dic.Add("秃", "tmb");
            dic.Add("役", "tmc");
            dic.Add("垼", "tmcf");
            dic.Add("身", "tmd");
            dic.Add("躻", "tmda");
            dic.Add("躾", "tmdd");
            dic.Add("躴", "tmde");
            dic.Add("躼", "tmde");
            dic.Add("射", "tmdf");
            dic.Add("軃", "tmdf");
            dic.Add("軇", "tmdf");
            dic.Add("躰", "tmdg");
            dic.Add("躿", "tmdi");
            dic.Add("篅", "tmdj");
            dic.Add("軄", "tmdj");
            dic.Add("躺", "tmdk");
            dic.Add("躳", "tmdk");
            dic.Add("躸", "tmdk");
            dic.Add("軀", "tmdk");
            dic.Add("軂", "tmdl");
            dic.Add("颓", "tmdm");
            dic.Add("軉", "tmdm");
            dic.Add("頽", "tmdm");
            dic.Add("躵", "tmdn");
            dic.Add("軈", "tmdn");
            dic.Add("躹", "tmdo");
            dic.Add("鵢", "tmdo");
            dic.Add("躯", "tmdq");
            dic.Add("躭", "tmdq");
            dic.Add("躲", "tmds");
            dic.Add("躱", "tmds");
            dic.Add("躶", "tmds");
            dic.Add("軆", "tmdu");
            dic.Add("躮", "tmdv");
            dic.Add("躷", "tmdv");
            dic.Add("躽", "tmdv");
            dic.Add("軁", "tmdv");
            dic.Add("躬", "tmdx");
            dic.Add("秧", "tmdy");
            dic.Add("軅", "tmdy");
            dic.Add("笛", "tmf");
            dic.Add("簓", "tmfe");
            dic.Add("稠", "tmfk");
            dic.Add("徟", "tmfk");
            dic.Add("微", "tmg");
            dic.Add("徵", "tmg");
            dic.Add("秞", "tmg");
            dic.Add("龜", "tmgg");
            dic.Add("衕", "tmgh");
            dic.Add("筒", "tmgk");
            dic.Add("秱", "tmgk");
            dic.Add("懲", "tmgn");
            dic.Add("徽", "tmgt");
            dic.Add("徴", "tmgt");
            dic.Add("黴", "tmgt");
            dic.Add("币", "tmh");
            dic.Add("秈", "tmh");
            dic.Add("屲", "tmj");
            dic.Add("穨", "tmkm");
            dic.Add("逈", "tmkp");
            dic.Add("笧", "tmmg");
            dic.Add("簻", "tmnp");
            dic.Add("奥", "tmo");
            dic.Add("嶴", "tmom");
            dic.Add("秽", "tmq");
            dic.Add("笕", "tmqb");
            dic.Add("奧", "tmtd");
            dic.Add("粵", "tmtn");
            dic.Add("幑", "tmtt");
            dic.Add("筫", "tmu");
            dic.Add("凢", "tmv");
            dic.Add("処", "tmv");
            dic.Add("鵚", "tmwo");
            dic.Add("笍", "tmwu");
            dic.Add("箆", "tmwx");
            dic.Add("徾", "tmyt");
            dic.Add("竼", "tmyu");
            dic.Add("秘", "tn");
            dic.Add("笢", "tnab");
            dic.Add("乞", "tnb");
            dic.Add("笥", "tng");
            dic.Add("箼", "tngf");
            dic.Add("徦", "tnhc");
            dic.Add("稰", "tnhe");
            dic.Add("篃", "tnhf");
            dic.Add("徫", "tnhh");
            dic.Add("稦", "tnhh");
            dic.Add("衛", "tnhh");
            dic.Add("衞", "tnhh");
            dic.Add("躗", "tnhh");
            dic.Add("躛", "tnhh");
            dic.Add("讆", "tnhy");
            dic.Add("讏", "tnhy");
            dic.Add("徲", "tnih");
            dic.Add("穉", "tnih");
            dic.Add("刉", "tnjh");
            dic.Add("筷", "tnn");
            dic.Add("簨", "tnnw");
            dic.Add("迄", "tnp");
            dic.Add("簈", "tntf");
            dic.Add("箳", "tnua");
            dic.Add("稺", "tnuh");
            dic.Add("穋", "tnwe");
            dic.Add("籊", "tnwy");
            dic.Add("秜", "tnxn");
            dic.Add("笖", "tnyw");
            dic.Add("秋", "to");
            dic.Add("释", "toc");
            dic.Add("甃", "togn");
            dic.Add("穙", "togy");
            dic.Add("釆", "toi");
            dic.Add("湬", "toiu");
            dic.Add("稥", "tojf");
            dic.Add("蝵", "toju");
            dic.Add("番", "tol");
            dic.Add("鄱", "tolb");
            dic.Add("釋", "tolf");
            dic.Add("飜", "tolh");
            dic.Add("勫", "toll");
            dic.Add("翻", "toln");
            dic.Add("鷭", "tolo");
            dic.Add("釉", "tom");
            dic.Add("悉", "ton");
            dic.Add("簖", "tonr");
            dic.Add("愁", "tonu");
            dic.Add("釈", "tony");
            dic.Add("簩", "tool");
            dic.Add("鍫", "toqf");
            dic.Add("鹙", "toqg");
            dic.Add("揫", "torj");
            dic.Add("醔", "tosg");
            dic.Add("夈", "tou");
            dic.Add("篓", "tov");
            dic.Add("媝", "tovf");
            dic.Add("鶖", "towo");
            dic.Add("管", "tp");
            dic.Add("稼", "tpe");
            dic.Add("秾", "tpey");
            dic.Add("簆", "tpfc");
            dic.Add("簺", "tpff");
            dic.Add("徖", "tpfi");
            dic.Add("筦", "tpfq");
            dic.Add("箮", "tpgg");
            dic.Add("穦", "tpgm");
            dic.Add("乏", "tpi");
            dic.Add("箢", "tpq");
            dic.Add("筞", "tpsu");
            dic.Add("秺", "tpta");
            dic.Add("箜", "tpw");
            dic.Add("穃", "tpwk");
            dic.Add("鴔", "tpwo");
            dic.Add("篧", "tpwy");
            dic.Add("簶", "tpyi");
            dic.Add("称", "tq");
            dic.Add("籛", "tqaa");
            dic.Add("秖", "tqan");
            dic.Add("彽", "tqay");
            dic.Add("秪", "tqay");
            dic.Add("禿", "tqb");
            dic.Add("稯", "tqbt");
            dic.Add("篘", "tqbt");
            dic.Add("稀", "tqd");
            dic.Add("衡", "tqdh");
            dic.Add("頹", "tqdm");
            dic.Add("簷", "tqdy");
            dic.Add("衔", "tqf");
            dic.Add("銜", "tqfh");
            dic.Add("穞", "tqgj");
            dic.Add("篯", "tqgr");
            dic.Add("徇", "tqj");
            dic.Add("箰", "tqjb");
            dic.Add("筍", "tqjf");
            dic.Add("穐", "tqjn");
            dic.Add("笱", "tqk");
            dic.Add("笣", "tqnb");
            dic.Add("穭", "tqoj");
            dic.Add("移", "tqq");
            dic.Add("笅", "tqqu");
            dic.Add("笏", "tqr");
            dic.Add("篼", "tqrq");
            dic.Add("黎", "tqt");
            dic.Add("笷", "tqtb");
            dic.Add("籦", "tqtf");
            dic.Add("犂", "tqth");
            dic.Add("睝", "tqth");
            dic.Add("黧", "tqto");
            dic.Add("鯬", "tqto");
            dic.Add("鵹", "tqto");
            dic.Add("邌", "tqtp");
            dic.Add("錅", "tqtq");
            dic.Add("棃", "tqts");
            dic.Add("剓", "tqtv");
            dic.Add("笉", "tquf");
            dic.Add("稳", "tqv");
            dic.Add("筝", "tqvh");
            dic.Add("籙", "tqvi");
            dic.Add("彴", "tqyy");
            dic.Add("物", "tr");
            dic.Add("箍", "tra");
            dic.Add("犕", "trae");
            dic.Add("箝", "traf");
            dic.Add("簎", "traj");
            dic.Add("牫", "trat");
            dic.Add("牠", "trbn");
            dic.Add("筢", "trc");
            dic.Add("犙", "trce");
            dic.Add("箨", "trch");
            dic.Add("笟", "trcy");
            dic.Add("犄", "trd");
            dic.Add("牜", "trd");
            dic.Add("牻", "trde");
            dic.Add("牯", "trdg");
            dic.Add("犡", "trdy");
            dic.Add("特", "trf");
            dic.Add("犊", "trfd");
            dic.Add("簼", "trff");
            dic.Add("牡", "trfg");
            dic.Add("循", "trfh");
            dic.Add("犆", "trfh");
            dic.Add("犢", "trfm");
            dic.Add("徨", "trg");
            dic.Add("牼", "trga");
            dic.Add("篁", "trgf");
            dic.Add("牾", "trgk");
            dic.Add("籒", "trgl");
            dic.Add("御", "trh");
            dic.Add("犑", "trhd");
            dic.Add("衘", "trhh");
            dic.Add("禦", "trhi");
            dic.Add("篪", "trhm");
            dic.Add("犋", "trhw");
            dic.Add("笊", "trhy");
            dic.Add("穆", "tri");
            dic.Add("秼", "triy");
            dic.Add("犦", "trji");
            dic.Add("筘", "trk");
            dic.Add("箉", "trkl");
            dic.Add("籜", "trlf");
            dic.Add("牭", "trlg");
            dic.Add("牞", "trln");
            dic.Add("犤", "trlx");
            dic.Add("牰", "trmg");
            dic.Add("犅", "trmm");
            dic.Add("犌", "trnc");
            dic.Add("鹅", "trng");
            dic.Add("鵝", "trno");
            dic.Add("鵞", "trno");
            dic.Add("牸", "trpb");
            dic.Add("犗", "trpk");
            dic.Add("觕", "trqe");
            dic.Add("籀", "trql");
            dic.Add("惣", "trqn");
            dic.Add("犓", "trqt");
            dic.Add("牴", "trqy");
            dic.Add("篺", "trrf");
            dic.Add("牪", "trrh");
            dic.Add("犔", "trro");
            dic.Add("牺", "trs");
            dic.Add("牱", "trsk");
            dic.Add("牧", "trt");
            dic.Add("稗", "trtf");
            dic.Add("犐", "trtf");
            dic.Add("箄", "trtf");
            dic.Add("牲", "trtg");
            dic.Add("牿", "trtk");
            dic.Add("犞", "trtk");
            dic.Add("牦", "trtn");
            dic.Add("牬", "trtt");
            dic.Add("犈", "trub");
            dic.Add("犝", "truf");
            dic.Add("犃", "truk");
            dic.Add("犠", "trut");
            dic.Add("犧", "trut");
            dic.Add("犪", "trut");
            dic.Add("犍", "trv");
            dic.Add("犣", "trvn");
            dic.Add("牣", "trvy");
            dic.Add("秩", "trw");
            dic.Add("牷", "trwg");
            dic.Add("籡", "trww");
            dic.Add("牝", "trx");
            dic.Add("牳", "trxu");
            dic.Add("徼", "try");
            dic.Add("犏", "trya");
            dic.Add("犉", "tryb");
            dic.Add("犒", "tryk");
            dic.Add("牨", "trym");
            dic.Add("牤", "tryn");
            dic.Add("牥", "tryn");
            dic.Add("犥", "tryo");
            dic.Add("犜", "tryt");
            dic.Add("条", "ts");
            dic.Add("篐", "tsah");
            dic.Add("簯", "tsaw");
            dic.Add("徱", "tsfi");
            dic.Add("篻", "tsfi");
            dic.Add("籈", "tsfn");
            dic.Add("笨", "tsg");
            dic.Add("徆", "tsg");
            dic.Add("箱", "tsh");
            dic.Add("簟", "tsj");
            dic.Add("笴", "tskf");
            dic.Add("籕", "tsql");
            dic.Add("篥", "tss");
            dic.Add("箖", "tssu");
            dic.Add("徠", "tsww");
            dic.Add("箂", "tsww");
            dic.Add("秫", "tsy");
            dic.Add("術", "tsyh");
            dic.Add("笔", "tt");
            dic.Add("秅", "ttan");
            dic.Add("笑", "ttd");
            dic.Add("筈", "ttdf");
            dic.Add("秳", "ttdg");
            dic.Add("穚", "ttdk");
            dic.Add("簥", "ttdk");
            dic.Add("篷", "ttdp");
            dic.Add("笶", "ttdu");
            dic.Add("秗", "ttdy");
            dic.Add("筕", "ttfh");
            dic.Add("秊", "ttfj");
            dic.Add("秊", "ttfj");
            dic.Add("筶", "ttfk");
            dic.Add("穳", "ttfm");
            dic.Add("籫", "ttfm");
            dic.Add("秏", "ttfn");
            dic.Add("筳", "ttfp");
            dic.Add("簉", "ttfp");
            dic.Add("筅", "ttfq");
            dic.Add("竹", "ttg");
            dic.Add("", "ttg");
            dic.Add("笙", "ttgf");
            dic.Add("種", "ttgf");
            dic.Add("箠", "ttgf");
            dic.Add("箽", "ttgf");
            dic.Add("徃", "ttgg");
            dic.Add("衝", "ttgh");
            dic.Add("攵", "ttgy");
            dic.Add("", "ttgy");
            dic.Add("笮", "tth");
            dic.Add("秨", "tthf");
            dic.Add("簰", "tthf");
            dic.Add("簁", "tthh");
            dic.Add("筵", "tthp");
            dic.Add("籩", "tthp");
            dic.Add("筣", "ttjj");
            dic.Add("復", "ttjt");
            dic.Add("稪", "ttjt");
            dic.Add("笿", "ttkf");
            dic.Add("丿", "ttl");
            dic.Add("篦", "ttlx");
            dic.Add("龝", "ttmg");
            dic.Add("夂", "ttn");
            dic.Add("笫", "ttn");
            dic.Add("秭", "ttnt");
            dic.Add("篍", "ttou");
            dic.Add("簃", "ttqq");
            dic.Add("篽", "ttrb");
            dic.Add("籞", "ttri");
            dic.Add("筿", "ttsu");
            dic.Add("彳", "ttth");
            dic.Add("笗", "ttuu");
            dic.Add("箻", "ttvh");
            dic.Add("篵", "ttwh");
            dic.Add("秝", "tty");
            dic.Add("科", "tu");
            dic.Add("徉", "tud");
            dic.Add("箞", "tudb");
            dic.Add("箭", "tue");
            dic.Add("徿", "tued");
            dic.Add("籠", "tued");
            dic.Add("穟", "tuep");
            dic.Add("笠", "tuf");
            dic.Add("穣", "tufe");
            dic.Add("秚", "tufh");
            dic.Add("籣", "tugi");
            dic.Add("乎", "tuh");
            dic.Add("乯", "tuhn");
            dic.Add("従", "tuhy");
            dic.Add("简", "tuj");
            dic.Add("箪", "tuj");
            dic.Add("徸", "tujf");
            dic.Add("穜", "tujf");
            dic.Add("簡", "tujf");
            dic.Add("螽", "tujj");
            dic.Add("篭", "tujn");
            dic.Add("税", "tuk");
            dic.Add("篰", "tukb");
            dic.Add("箁", "tukf");
            dic.Add("稖", "tukg");
            dic.Add("徶", "tumt");
            dic.Add("乥", "tunb");
            dic.Add("徬", "tupy");
            dic.Add("篣", "tupy");
            dic.Add("筊", "tuqu");
            dic.Add("乊", "tur");
            dic.Add("簅", "tutg");
            dic.Add("衜", "tuth");
            dic.Add("冬", "tuu");
            dic.Add("稴", "tuvo");
            dic.Add("鷑", "tuwo");
            dic.Add("乘", "tux");
            dic.Add("剩", "tuxj");
            dic.Add("稊", "tuxt");
            dic.Add("稵", "tuxx");
            dic.Add("簢", "tuyu");
            dic.Add("委", "tv");
            dic.Add("節", "tvcb");
            dic.Add("蠞", "tvcj");
            dic.Add("穊", "tvcq");
            dic.Add("笯", "tvcu");
            dic.Add("衟", "tvdh");
            dic.Add("很", "tve");
            dic.Add("簋", "tvel");
            dic.Add("律", "tvfh");
            dic.Add("筆", "tvfh");
            dic.Add("簫", "tvfj");
            dic.Add("徤", "tvfp");
            dic.Add("瓾", "tvgn");
            dic.Add("穥", "tvgw");
            dic.Add("籅", "tvgw");
            dic.Add("覣", "tvhq");
            dic.Add("箫", "tvij");
            dic.Add("箓", "tviu");
            dic.Add("笤", "tvk");
            dic.Add("筎", "tvkf");
            dic.Add("簘", "tvoj");
            dic.Add("逶", "tvp");
            dic.Add("箒", "tvph");
            dic.Add("魏", "tvr");
            dic.Add("犩", "tvrh");
            dic.Add("笋", "tvt");
            dic.Add("笂", "tvyu");
            dic.Add("秇", "tvyy");
            dic.Add("答", "tw");
            dic.Add("筏", "twa");
            dic.Add("笩", "twau");
            dic.Add("彸", "twcy");
            dic.Add("符", "twf");
            dic.Add("穄", "twfi");
            dic.Add("稐", "twga");
            dic.Add("籥", "twga");
            dic.Add("篟", "twge");
            dic.Add("筌", "twgf");
            dic.Add("签", "twgi");
            dic.Add("劄", "twgj");
            dic.Add("徻", "twgj");
            dic.Add("箚", "twgj");
            dic.Add("秴", "twgk");
            dic.Add("籲", "twgm");
            dic.Add("箯", "twgq");
            dic.Add("籢", "twgt");
            dic.Add("簦", "twgu");
            dic.Add("簽", "twgw");
            dic.Add("籨", "twgw");
            dic.Add("筱", "twh");
            dic.Add("篠", "twhs");
            dic.Add("黍", "twi");
            dic.Add("黐", "twic");
            dic.Add("黏", "twik");
            dic.Add("筗", "twkh");
            dic.Add("稅", "twkq");
            dic.Add("篌", "twn");
            dic.Add("篩", "twnh");
            dic.Add("籂", "twph");
            dic.Add("徐", "twt");
            dic.Add("秹", "twtf");
            dic.Add("筰", "twtf");
            dic.Add("筡", "twtu");
            dic.Add("稌", "twty");
            dic.Add("秂", "twu");
            dic.Add("鵆", "twvh");
            dic.Add("秎", "twvn");
            dic.Add("穒", "twvo");
            dic.Add("聳", "twwb");
            dic.Add("籤", "twwg");
            dic.Add("從", "twwh");
            dic.Add("慫", "twwn");
            dic.Add("熧", "twwo");
            dic.Add("稚", "twy");
            dic.Add("彾", "twyc");
            dic.Add("秢", "twyc");
            dic.Add("笭", "twyc");
            dic.Add("篗", "twyc");
            dic.Add("篒", "twye");
            dic.Add("衑", "twyh");
            dic.Add("筨", "twyk");
            dic.Add("篬", "twyk");
            dic.Add("稔", "twyn");
            dic.Add("笒", "twyn");
            dic.Add("穛", "twyo");
            dic.Add("穕", "twys");
            dic.Add("第", "tx");
            dic.Add("篆", "txe");
            dic.Add("胤", "txen");
            dic.Add("毎", "txfj");
            dic.Add("每", "txg");
            dic.Add("鳘", "txgg");
            dic.Add("繁", "txgi");
            dic.Add("瀪", "txgi");
            dic.Add("緐", "txgi");
            dic.Add("勄", "txgl");
            dic.Add("慜", "txgn");
            dic.Add("鰵", "txgo");
            dic.Add("毓", "txgq");
            dic.Add("敏", "txgt");
            dic.Add("系", "txi");
            dic.Add("彿", "txjh");
            dic.Add("笰", "txjj");
            dic.Add("箹", "txqy");
            dic.Add("後", "txt");
            dic.Add("籎", "txth");
            dic.Add("篛", "txuu");
            dic.Add("秕", "txx");
            dic.Add("笓", "txxb");
            dic.Add("筚", "txxf");
            dic.Add("稭", "txxr");
            dic.Add("籪", "txxr");
            dic.Add("穖", "txxt");
            dic.Add("入", "ty");
            dic.Add("穬", "tyaw");
            dic.Add("簱", "tyaw");
            dic.Add("篱", "tyb");
            dic.Add("稕", "tybg");
            dic.Add("籬", "tyby");
            dic.Add("勶", "tycl");
            dic.Add("徹", "tyct");
            dic.Add("往", "tyg");
            dic.Add("簔", "tyge");
            dic.Add("笇", "tyhu");
            dic.Add("汆", "tyiu");
            dic.Add("稤", "tyiy");
            dic.Add("穧", "tyjg");
            dic.Add("穰", "tyk");
            dic.Add("忀", "tyke");
            dic.Add("簑", "tyke");
            dic.Add("稿", "tym");
            dic.Add("篙", "tym");
            dic.Add("笐", "tymb");
            dic.Add("屳", "tymj");
            dic.Add("秔", "tymn");
            dic.Add("肏", "tymw");
            dic.Add("彷", "tyn");
            dic.Add("篇", "tyna");
            dic.Add("徧", "tyna");
            dic.Add("稨", "tyna");
            dic.Add("笀", "tynb");
            dic.Add("簄", "tync");
            dic.Add("穮", "tyno");
            dic.Add("兦", "tynv");
            dic.Add("簏", "tynx");
            dic.Add("籝", "tyny");
            dic.Add("籯", "tyny");
            dic.Add("籴", "tyo");
            dic.Add("糴", "tyoy");
            dic.Add("籇", "type");
            dic.Add("込", "typi");
            dic.Add("簇", "tyt");
            dic.Add("箷", "tytb");
            dic.Add("籏", "tytw");
            dic.Add("簾", "tyuo");
            dic.Add("稂", "tyv");
            dic.Add("筤", "tyve");
            dic.Add("穅", "tyvi");
            dic.Add("篖", "tyvk");
            dic.Add("稡", "tywf");
            dic.Add("箤", "tywf");
            dic.Add("鳰", "tywo");
            dic.Add("箊", "tywu");
            dic.Add("衒", "tyxh");
            dic.Add("稸", "tyxl");
            dic.Add("产", "u");
            dic.Add("立", "u");
            dic.Add("并", "ua");
            dic.Add("郱", "uabh");
            dic.Add("疘", "uad");
            dic.Add("瘔", "uadd");
            dic.Add("頩", "uadm");
            dic.Add("瘎", "uadn");
            dic.Add("凘", "uadr");
            dic.Add("疳", "uaf");
            dic.Add("瓶", "uag");
            dic.Add("冮", "uag");
            dic.Add("疟", "uagd");
            dic.Add("冴", "uaht");
            dic.Add("疨", "uaht");
            dic.Add("閕", "uaht");
            dic.Add("冻", "uai");
            dic.Add("竎", "uaj");
            dic.Add("瘼", "uajd");
            dic.Add("戠", "uajd");
            dic.Add("瘄", "uajd");
            dic.Add("癘", "uajy");
            dic.Add("阈", "uak");
            dic.Add("瘽", "uakg");
            dic.Add("閾", "uakg");
            dic.Add("癱", "uaky");
            dic.Add("癀", "uam");
            dic.Add("疶", "uanv");
            dic.Add("迸", "uap");
            dic.Add("痨", "uapl");
            dic.Add("艵", "uaqc");
            dic.Add("剙", "uavw");
            dic.Add("剏", "uavy");
            dic.Add("瘩", "uaw");
            dic.Add("閧", "uawi");
            dic.Add("闀", "uawn");
            dic.Add("鵧", "uawo");
            dic.Add("闻", "ub");
            dic.Add("聞", "ubd");
            dic.Add("癮", "uben");
            dic.Add("兯", "ubj");
            dic.Add("疗", "ubk");
            dic.Add("疖", "ubk");
            dic.Add("瘾", "ubq");
            dic.Add("痾", "ubsk");
            dic.Add("逆", "ubt");
            dic.Add("朔", "ubte");
            dic.Add("塑", "ubtf");
            dic.Add("癃", "ubtg");
            dic.Add("愬", "ubtn");
            dic.Add("遡", "ubtp");
            dic.Add("屰", "ubtr");
            dic.Add("槊", "ubts");
            dic.Add("欮", "ubtw");
            dic.Add("癊", "ubwc");
            dic.Add("冯", "uc");
            dic.Add("痉", "uca");
            dic.Add("閞", "ucak");
            dic.Add("瘮", "ucce");
            dic.Add("闯", "ucd");
            dic.Add("瘆", "ucde");
            dic.Add("痛", "uce");
            dic.Add("衮", "uceu");
            dic.Add("闖", "uci");
            dic.Add("冶", "uck");
            dic.Add("凴", "ucmb");
            dic.Add("憑", "ucnu");
            dic.Add("兖", "ucq");
            dic.Add("竢", "uctd");
            dic.Add("疤", "ucv");
            dic.Add("竣", "ucw");
            dic.Add("痠", "ucwt");
            dic.Add("瘫", "ucwy");
            dic.Add("瘙", "ucy");
            dic.Add("馮", "ucy");
            dic.Add("关", "ud");
            dic.Add("差", "uda");
            dic.Add("齹", "udab");
            dic.Add("羢", "udad");
            dic.Add("郑", "udb");
            dic.Add("卷", "udbb");
            dic.Add("勌", "udbl");
            dic.Add("闳", "udc");
            dic.Add("羟", "udca");
            dic.Add("閎", "udci");
            dic.Add("羓", "udcn");
            dic.Add("羧", "udct");
            dic.Add("駦", "udcu");
            dic.Add("冹", "udcy");
            dic.Add("竑", "udcy");
            dic.Add("闫", "udd");
            dic.Add("閆", "udd");
            dic.Add("羱", "uddi");
            dic.Add("頖", "uddm");
            dic.Add("羬", "uddt");
            dic.Add("豢", "ude");
            dic.Add("痏", "uded");
            dic.Add("痮", "udei");
            dic.Add("羏", "udet");
            dic.Add("羺", "udfj");
            dic.Add("羵", "udfm");
            dic.Add("减", "udg");
            dic.Add("羥", "udga");
            dic.Add("羠", "udgw");
            dic.Add("着", "udh");
            dic.Add("齤", "udhb");
            dic.Add("瘈", "udhd");
            dic.Add("眷", "udhf");
            dic.Add("瘛", "udhn");
            dic.Add("头", "udi");
            dic.Add("", "udi");
            dic.Add("羊", "udj");
            dic.Add("羯", "udj");
            dic.Add("痱", "udjd");
            dic.Add("竰", "udjf");
            dic.Add("竡", "udjg");
            dic.Add("判", "udjh");
            dic.Add("奍", "udjj");
            dic.Add("阉", "udjn");
            dic.Add("痷", "udjn");
            dic.Add("閹", "udjn");
            dic.Add("鵥", "udjo");
            dic.Add("疬", "udl");
            dic.Add("劵", "udlb");
            dic.Add("劷", "udln");
            dic.Add("羰", "udm");
            dic.Add("羖", "udmc");
            dic.Add("帣", "udmh");
            dic.Add("羞", "udn");
            dic.Add("疠", "udn");
            dic.Add("羌", "udnb");
            dic.Add("巻", "udnb");
            dic.Add("羗", "udnc");
            dic.Add("痝", "udne");
            dic.Add("翔", "udng");
            dic.Add("韏", "udnh");
            dic.Add("疣", "udnv");
            dic.Add("送", "udp");
            dic.Add("闼", "udp");
            dic.Add("羫", "udpa");
            dic.Add("羦", "udpq");
            dic.Add("羜", "udps");
            dic.Add("羝", "udq");
            dic.Add("觠", "udqe");
            dic.Add("鲞", "udqg");
            dic.Add("鲝", "udqg");
            dic.Add("鮝", "udqo");
            dic.Add("鮺", "udqo");
            dic.Add("拳", "udr");
            dic.Add("", "udr");
            dic.Add("叛", "udrc");
            dic.Add("牶", "udrh");
            dic.Add("桊", "uds");
            dic.Add("癧", "udth");
            dic.Add("羳", "udtl");
            dic.Add("鄯", "udub");
            dic.Add("羴", "udud");
            dic.Add("療", "udui");
            dic.Add("善", "uduk");
            dic.Add("敾", "udut");
            dic.Add("歚", "uduw");
            dic.Add("券", "udv");
            dic.Add("凑", "udw");
            dic.Add("羚", "udwc");
            dic.Add("餋", "udwe");
            dic.Add("瘞", "udwf");
            dic.Add("羭", "udwj");
            dic.Add("瘱", "udwn");
            dic.Add("鴹", "udwo");
            dic.Add("羒", "udwv");
            dic.Add("羷", "udww");
            dic.Add("弮", "udxb");
            dic.Add("絭", "udxi");
            dic.Add("勬", "udxl");
            dic.Add("状", "udy");
            dic.Add("羪", "udye");
            dic.Add("飬", "udye");
            dic.Add("養", "udye");
            dic.Add("誊", "udyf");
            dic.Add("羶", "udyg");
            dic.Add("养", "udyj");
            dic.Add("鯗", "udyo");
            dic.Add("羻", "udyt");
            dic.Add("譱", "udyy");
            dic.Add("前", "ue");
            dic.Add("閒", "ued");
            dic.Add("顡", "uedm");
            dic.Add("痭", "ueed");
            dic.Add("奨", "uefd");
            dic.Add("醤", "uefg");
            dic.Add("疽", "ueg");
            dic.Add("龏", "uega");
            dic.Add("聾", "uegb");
            dic.Add("驡", "uegc");
            dic.Add("礱", "uegd");
            dic.Add("龍", "uegd");
            dic.Add("龑", "uegd");
            dic.Add("龖", "uegd");
            dic.Add("龘", "uegd");
            dic.Add("襲", "uege");
            dic.Add("壟", "uegf");
            dic.Add("龒", "uegi");
            dic.Add("蠪", "uegj");
            dic.Add("鸗", "uego");
            dic.Add("龔", "uegw");
            dic.Add("讋", "uegy");
            dic.Add("覵", "uehq");
            dic.Add("翦", "uejn");
            dic.Add("煎", "uejo");
            dic.Add("剪", "uejv");
            dic.Add("痈", "uek");
            dic.Add("毅", "uem");
            dic.Add("遂", "uep");
            dic.Add("阌", "uepc");
            dic.Add("閿", "uepc");
            dic.Add("豙", "ueu");
            dic.Add("疓", "uev");
            dic.Add("凈", "uevh");
            dic.Add("鷳", "uewo");
            dic.Add("瘃", "uey");
            dic.Add("半", "uf");
            dic.Add("阖", "ufc");
            dic.Add("闔", "ufcl");
            dic.Add("攱", "ufcy");
            dic.Add("兰", "uff");
            dic.Add("闺", "uffd");
            dic.Add("閨", "uffd");
            dic.Add("痔", "uffi");
            dic.Add("壮", "ufg");
            dic.Add("阗", "ufh");
            dic.Add("竍", "ufh");
            dic.Add("癫", "ufhm");
            dic.Add("癲", "ufhm");
            dic.Add("瘨", "ufhw");
            dic.Add("闐", "ufhw");
            dic.Add("疛", "ufi");
            dic.Add("斗", "ufk");
            dic.Add("閈", "ufk");
            dic.Add("闬", "ufk");
            dic.Add("闧", "ufkp");
            dic.Add("癗", "ufld");
            dic.Add("凟", "uflm");
            dic.Add("闱", "ufn");
            dic.Add("乧", "ufnb");
            dic.Add("痣", "ufni");
            dic.Add("疞", "ufnv");
            dic.Add("闭", "uft");
            dic.Add("痚", "uftb");
            dic.Add("閉", "ufte");
            dic.Add("瘏", "uftj");
            dic.Add("闍", "uftj");
            dic.Add("阇", "uftj");
            dic.Add("闥", "ufup");
            dic.Add("凌", "ufw");
            dic.Add("闚", "ufwq");
            dic.Add("癨", "ufwy");
            dic.Add("装", "ufy");
            dic.Add("闰", "ug");
            dic.Add("開", "ugak");
            dic.Add("癅", "ugal");
            dic.Add("痓", "ugcf");
            dic.Add("闩", "ugd");
            dic.Add("閂", "ugd");
            dic.Add("閏", "ugd");
            dic.Add("美", "ugdu");
            dic.Add("靖", "uge");
            dic.Add("凊", "ugeg");
            dic.Add("痡", "ugey");
            dic.Add("", "ugf");
            dic.Add("瘂", "ugfg");
            dic.Add("閸", "ugfg");
            dic.Add("癋", "ugfn");
            dic.Add("症", "ugh");
            dic.Add("疜", "ughi");
            dic.Add("閇", "ughi");
            dic.Add("慿", "ughn");
            dic.Add("痞", "ugi");
            dic.Add("羨", "ugiw");
            dic.Add("竱", "ugjf");
            dic.Add("凍", "ugji");
            dic.Add("辣", "ugk");
            dic.Add("竦", "ugk");
            dic.Add("痦", "ugkd");
            dic.Add("闘", "ugkf");
            dic.Add("竵", "ugkh");
            dic.Add("凁", "ugki");
            dic.Add("瘌", "ugkj");
            dic.Add("癞", "ugkm");
            dic.Add("癩", "ugkm");
            dic.Add("瘷", "ugkt");
            dic.Add("痘", "ugku");
            dic.Add("瘶", "ugkw");
            dic.Add("盖", "ugl");
            dic.Add("阑", "ugli");
            dic.Add("闌", "ugli");
            dic.Add("病", "ugm");
            dic.Add("恙", "ugn");
            dic.Add("羔", "ugo");
            dic.Add("羹", "ugod");
            dic.Add("痖", "ugog");
            dic.Add("羙", "ugou");
            dic.Add("羮", "ugoy");
            dic.Add("冽", "ugq");
            dic.Add("羑", "ugqy");
            dic.Add("羲", "ugt");
            dic.Add("義", "ugtt");
            dic.Add("羡", "ugu");
            dic.Add("瘗", "uguf");
            dic.Add("閛", "uguh");
            dic.Add("姜", "ugv");
            dic.Add("痙", "ugva");
            dic.Add("凄", "ugvv");
            dic.Add("冱", "ugx");
            dic.Add("羛", "ugxj");
            dic.Add("痍", "ugxw");
            dic.Add("癍", "ugy");
            dic.Add("羕", "ugyi");
            dic.Add("閠", "ugyi");
            dic.Add("站", "uh");
            dic.Add("瘧", "uhag");
            dic.Add("疲", "uhc");
            dic.Add("阒", "uhd");
            dic.Add("闃", "uhdi");
            dic.Add("癯", "uhh");
            dic.Add("闅", "uhhc");
            dic.Add("竨", "uhjh");
            dic.Add("丫", "uhk");
            dic.Add("痁", "uhkd");
            dic.Add("門", "uhng");
            dic.Add("夔", "uht");
            dic.Add("疵", "uhx");
            dic.Add("冰", "ui");
            dic.Add("痟", "uied");
            dic.Add("痧", "uii");
            dic.Add("閖", "uii");
            dic.Add("閯", "uiit");
            dic.Add("闛", "uipf");
            dic.Add("闣", "uipl");
            dic.Add("阔", "uit");
            dic.Add("闊", "uitd");
            dic.Add("竗", "uitt");
            dic.Add("瘠", "uiw");
            dic.Add("间", "uj");
            dic.Add("頀", "ujac");
            dic.Add("韺", "ujad");
            dic.Add("贑", "ujam");
            dic.Add("戅", "ujan");
            dic.Add("鄣", "ujb");
            dic.Add("韷", "ujbm");
            dic.Add("間", "ujd");
            dic.Add("彰", "uje");
            dic.Add("音", "ujf");
            dic.Add("郸", "ujfb");
            dic.Add("冁", "ujfe");
            dic.Add("童", "ujff");
            dic.Add("单", "ujfj");
            dic.Add("勭", "ujfl");
            dic.Add("氃", "ujfn");
            dic.Add("疸", "ujg");
            dic.Add("韴", "ujgh");
            dic.Add("瘍", "ujgr");
            dic.Add("痩", "ujhc");
            dic.Add("覸", "ujhq");
            dic.Add("闽", "uji");
            dic.Add("痋", "uji");
            dic.Add("閩", "uji");
            dic.Add("章", "ujj");
            dic.Add("阊", "ujjd");
            dic.Add("閶", "ujjd");
            dic.Add("韻", "ujkm");
            dic.Add("瘟", "ujl");
            dic.Add("意", "ujn");
            dic.Add("竜", "ujnb");
            dic.Add("闒", "ujnd");
            dic.Add("阘", "ujnd");
            dic.Add("鷾", "ujno");
            dic.Add("遧", "ujpk");
            dic.Add("竟", "ujq");
            dic.Add("竭", "ujqn");
            dic.Add("竸", "ujqq");
            dic.Add("痬", "ujqr");
            dic.Add("韵", "ujqu");
            dic.Add("嬜", "ujqv");
            dic.Add("歆", "ujqw");
            dic.Add("韹", "ujrg");
            dic.Add("赣", "ujt");
            dic.Add("韸", "ujth");
            dic.Add("贛", "ujtm");
            dic.Add("戆", "ujtn");
            dic.Add("戇", "ujtn");
            dic.Add("韼", "ujtp");
            dic.Add("竷", "ujtt");
            dic.Add("韶", "ujv");
            dic.Add("鶕", "ujwo");
            dic.Add("鷼", "ujwo");
            dic.Add("閺", "ujyi");
            dic.Add("部", "uk");
            dic.Add("问", "ukd");
            dic.Add("問", "ukd");
            dic.Add("袞", "ukeu");
            dic.Add("咅", "ukf");
            dic.Add("瓿", "ukg");
            dic.Add("瘻", "ukgv");
            dic.Add("冲", "ukh");
            dic.Add("竒", "ukhj");
            dic.Add("闠", "ukhm");
            dic.Add("阓", "ukhm");
            dic.Add("剖", "ukj");
            dic.Add("癌", "ukk");
            dic.Add("郶", "ukkc");
            dic.Add("闾", "ukkd");
            dic.Add("閭", "ukkd");
            dic.Add("癉", "ukkf");
            dic.Add("闡", "ukkf");
            dic.Add("闆", "ukkk");
            dic.Add("勏", "ukln");
            dic.Add("总", "ukn");
            dic.Add("况", "ukq");
            dic.Add("竞", "ukq");
            dic.Add("兑", "ukqb");
            dic.Add("兗", "ukqb");
            dic.Add("競", "ukqq");
            dic.Add("敚", "ukqt");
            dic.Add("敨", "ukty");
            dic.Add("疻", "ukwi");
            dic.Add("曾", "ul");
            dic.Add("兾", "ulaw");
            dic.Add("痼", "uld");
            dic.Add("凅", "uldg");
            dic.Add("凙", "ulff");
            dic.Add("癦", "ulff");
            dic.Add("兽", "ulg");
            dic.Add("癏", "ulge");
            dic.Add("闤", "ulge");
            dic.Add("阛", "ulge");
            dic.Add("痹", "ulgj");
            dic.Add("瘝", "ulii");
            dic.Add("鄫", "uljb");
            dic.Add("曽", "uljf");
            dic.Add("甑", "uljn");
            dic.Add("朆", "uljr");
            dic.Add("闸", "ulk");
            dic.Add("閘", "ulk");
            dic.Add("閳", "ulk");
            dic.Add("痂", "ulkd");
            dic.Add("痐", "ulkd");
            dic.Add("瘸", "ulkw");
            dic.Add("癳", "ulli");
            dic.Add("阃", "uls");
            dic.Add("閫", "ulsi");
            dic.Add("辦", "uluh");
            dic.Add("瘰", "ulx");
            dic.Add("商", "um");
            dic.Add("癑", "umae");
            dic.Add("闦", "umau");
            dic.Add("痶", "umaw");
            dic.Add("疫", "umc");
            dic.Add("竐", "umcy");
            dic.Add("端", "umd");
            dic.Add("啇", "umdf");
            dic.Add("甋", "umdn");
            dic.Add("適", "umdp");
            dic.Add("敵", "umdt");
            dic.Add("歒", "umdw");
            dic.Add("凋", "umf");
            dic.Add("痌", "umgk");
            dic.Add("凒", "umgu");
            dic.Add("闓", "umgu");
            dic.Add("敝", "umi");
            dic.Add("蹩", "umi");
            dic.Add("閴", "umi");
            dic.Add("弊", "umia");
            dic.Add("鄨", "umic");
            dic.Add("獘", "umid");
            dic.Add("鳖", "umig");
            dic.Add("龞", "umig");
            dic.Add("瞥", "umih");
            dic.Add("幣", "umih");
            dic.Add("暼", "umij");
            dic.Add("蟞", "umij");
            dic.Add("憋", "umin");
            dic.Add("鱉", "umio");
            dic.Add("鷩", "umio");
            dic.Add("鐅", "umiq");
            dic.Add("撆", "umir");
            dic.Add("嫳", "umiv");
            dic.Add("鼈", "umiv");
            dic.Add("彆", "umix");
            dic.Add("斃", "umix");
            dic.Add("疝", "umk");
            dic.Add("閊", "umk");
            dic.Add("瘿", "umm");
            dic.Add("癭", "ummv");
            dic.Add("竌", "umn");
            dic.Add("瘑", "umnk");
            dic.Add("闿", "umnv");
            dic.Add("疯", "umq");
            dic.Add("飒", "umqy");
            dic.Add("闝", "umti");
            dic.Add("瘋", "umtj");
            dic.Add("闏", "umtj");
            dic.Add("颯", "umtj");
            dic.Add("凗", "umwy");
            dic.Add("决", "un");
            dic.Add("癜", "una");
            dic.Add("冺", "unan");
            dic.Add("阚", "unb");
            dic.Add("闞", "unbt");
            dic.Add("瘺", "unfi");
            dic.Add("翊", "ung");
            dic.Add("瘕", "unh");
            dic.Add("闈", "unhh");
            dic.Add("闷", "uni");
            dic.Add("悶", "uni");
            dic.Add("癖", "unk");
            dic.Add("闢", "unku");
            dic.Add("乵", "unn");
            dic.Add("疡", "unr");
            dic.Add("閟", "unte");
            dic.Add("竮", "unua");
            dic.Add("瘳", "unwe");
            dic.Add("疦", "unwi");
            dic.Add("痆", "unxv");
            dic.Add("普", "uo");
            dic.Add("並", "uogf");
            dic.Add("焛", "uoi");
            dic.Add("疢", "uoi");
            dic.Add("痰", "uoo");
            dic.Add("癆", "uool");
            dic.Add("瘘", "uov");
            dic.Add("帝", "up");
            dic.Add("竤", "updc");
            dic.Add("竩", "upeg");
            dic.Add("凕", "upju");
            dic.Add("瘒", "uplk");
            dic.Add("啻", "upmk");
            dic.Add("鶙", "upmo");
            dic.Add("遆", "upmp");
            dic.Add("痯", "upnn");
            dic.Add("竚", "upsh");
            dic.Add("旁", "upy");
            dic.Add("覫", "upyq");
            dic.Add("交", "uq");
            dic.Add("阍", "uqa");
            dic.Add("痻", "uqaj");
            dic.Add("閽", "uqaj");
            dic.Add("疧", "uqav");
            dic.Add("疷", "uqay");
            dic.Add("郊", "uqb");
            dic.Add("奖", "uqd");
            dic.Add("頝", "uqdm");
            dic.Add("癚", "uqdy");
            dic.Add("将", "uqf");
            dic.Add("螀", "uqfj");
            dic.Add("癣", "uqg");
            dic.Add("凎", "uqg");
            dic.Add("虠", "uqhm");
            dic.Add("浆", "uqi");
            dic.Add("阄", "uqj");
            dic.Add("痀", "uqkd");
            dic.Add("竘", "uqkg");
            dic.Add("凂", "uqkq");
            dic.Add("効", "uqln");
            dic.Add("痪", "uqm");
            dic.Add("瘓", "uqmd");
            dic.Add("疱", "uqn");
            dic.Add("癬", "uqod");
            dic.Add("", "uqqg");
            dic.Add("痑", "uqqi");
            dic.Add("瘹", "uqqy");
            dic.Add("桨", "uqs");
            dic.Add("酱", "uqsg");
            dic.Add("效", "uqt");
            dic.Add("净", "uqv");
            dic.Add("阎", "uqvd");
            dic.Add("閻", "uqvd");
            dic.Add("竫", "uqvh");
            dic.Add("", "uqvh");
            dic.Add("", "uqvh");
            dic.Add("次", "uqw");
            dic.Add("恣", "uqw");
            dic.Add("餈", "uqwe");
            dic.Add("垐", "uqwf");
            dic.Add("咨", "uqwk");
            dic.Add("盗", "uqwl");
            dic.Add("资", "uqwm");
            dic.Add("資", "uqwm");
            dic.Add("瓷", "uqwn");
            dic.Add("乲", "uqwn");
            dic.Add("粢", "uqwo");
            dic.Add("鵁", "uqwo");
            dic.Add("栥", "uqws");
            dic.Add("楶", "uqws");
            dic.Add("秶", "uqwt");
            dic.Add("姿", "uqwv");
            dic.Add("疚", "uqy");
            dic.Add("瘤", "uqyl");
            dic.Add("瓣", "ur");
            dic.Add("闎", "urii");
            dic.Add("痸", "urmj");
            dic.Add("瘣", "urqc");
            dic.Add("痺", "urtf");
            dic.Add("兿", "urvc");
            dic.Add("兠", "urxq");
            dic.Add("亲", "us");
            dic.Add("閪", "usd");
            dic.Add("瘭", "usf");
            dic.Add("闉", "usfd");
            dic.Add("凐", "usfg");
            dic.Add("痲", "usfq");
            dic.Add("尊", "usg");
            dic.Add("猷", "usg");
            dic.Add("遒", "usg");
            dic.Add("鄭", "usgb");
            dic.Add("奠", "usgd");
            dic.Add("酋", "usgf");
            dic.Add("蠤", "usgj");
            dic.Add("鷷", "usgo");
            dic.Add("遵", "usgp");
            dic.Add("親", "ushq");
            dic.Add("闲", "usi");
            dic.Add("閑", "usi");
            dic.Add("疔", "usk");
            dic.Add("閅", "usk");
            dic.Add("疴", "uskd");
            dic.Add("閜", "uskd");
            dic.Add("鹇", "usq");
            dic.Add("新", "usr");
            dic.Add("凚", "ussi");
            dic.Add("痳", "ussi");
            dic.Add("凓", "ussy");
            dic.Add("闄", "usvd");
            dic.Add("凇", "usw");
            dic.Add("鷴", "uswo");
            dic.Add("竔", "utah");
            dic.Add("凞", "utao");
            dic.Add("痵", "utbd");
            dic.Add("疾", "utd");
            dic.Add("痴", "utdk");
            dic.Add("閁", "ute");
            dic.Add("瘢", "utec");
            dic.Add("颜", "utem");
            dic.Add("顔", "utem");
            dic.Add("遃", "utep");
            dic.Add("彦", "uter");
            dic.Add("冼", "utf");
            dic.Add("竏", "utfh");
            dic.Add("竓", "utfn");
            dic.Add("閐", "utfn");
            dic.Add("閮", "utfp");
            dic.Add("瘇", "utgf");
            dic.Add("癪", "utgm");
            dic.Add("首", "uth");
            dic.Add("痄", "uth");
            dic.Add("癟", "utha");
            dic.Add("導", "uthf");
            dic.Add("馘", "uthg");
            dic.Add("噵", "uthk");
            dic.Add("瘜", "uthn");
            dic.Add("道", "uthp");
            dic.Add("闑", "uths");
            dic.Add("瘪", "uthx");
            dic.Add("痢", "utj");
            dic.Add("阁", "utk");
            dic.Add("閣", "utkd");
            dic.Add("竬", "utky");
            dic.Add("癓", "utmt");
            dic.Add("癥", "utmt");
            dic.Add("竧", "utmt");
            dic.Add("痜", "utmv");
            dic.Add("疙", "utn");
            dic.Add("疺", "utpi");
            dic.Add("産", "uttg");
            dic.Add("剷", "uttj");
            dic.Add("癁", "uttt");
            dic.Add("疼", "utu");
            dic.Add("痿", "utv");
            dic.Add("癤", "utvb");
            dic.Add("亷", "utvo");
            dic.Add("瘲", "utwh");
            dic.Add("痗", "utxu");
            dic.Add("阙", "uub");
            dic.Add("瘚", "uubw");
            dic.Add("闕", "uubw");
            dic.Add("痒", "uud");
            dic.Add("閚", "uud");
            dic.Add("闁", "uud");
            dic.Add("瘥", "uuda");
            dic.Add("闂", "uudb");
            dic.Add("癢", "uude");
            dic.Add("関", "uudi");
            dic.Add("癇", "uued");
            dic.Add("冸", "uufh");
            dic.Add("閗", "uufk");
            dic.Add("竝", "uug");
            dic.Add("辡", "uuh");
            dic.Add("阐", "uuj");
            dic.Add("瘅", "uuj");
            dic.Add("瘖", "uujd");
            dic.Add("癎", "uujd");
            dic.Add("闇", "uujd");
            dic.Add("暜", "uujf");
            dic.Add("瘴", "uujk");
            dic.Add("癔", "uujn");
            dic.Add("阅", "uuk");
            dic.Add("痥", "uukq");
            dic.Add("閲", "uukq");
            dic.Add("竲", "uulj");
            dic.Add("痫", "uus");
            dic.Add("竴", "uusf");
            dic.Add("妆", "uv");
            dic.Add("閰", "uvd");
            dic.Add("痕", "uve");
            dic.Add("妾", "uvf");
            dic.Add("冿", "uvfh");
            dic.Add("疩", "uvfk");
            dic.Add("瘦", "uvh");
            dic.Add("癰", "uvky");
            dic.Add("癙", "uvnn");
            dic.Add("兼", "uvo");
            dic.Add("鹣", "uvog");
            dic.Add("甉", "uvon");
            dic.Add("鶼", "uvoo");
            dic.Add("歉", "uvow");
            dic.Add("阋", "uvq");
            dic.Add("辧", "uvuh");
            dic.Add("瘐", "uvw");
            dic.Add("闪", "uw");
            dic.Add("阀", "uwa");
            dic.Add("閥", "uwae");
            dic.Add("疮", "uwb");
            dic.Add("疹", "uwe");
            dic.Add("瘵", "uwf");
            dic.Add("痊", "uwg");
            dic.Add("阕", "uwg");
            dic.Add("闋", "uwgd");
            dic.Add("瘉", "uwgj");
            dic.Add("癐", "uwgj");
            dic.Add("冾", "uwgk");
            dic.Add("閤", "uwgk");
            dic.Add("癒", "uwgn");
            dic.Add("闟", "uwgn");
            dic.Add("竳", "uwgu");
            dic.Add("閃", "uwi");
            dic.Add("疥", "uwj");
            dic.Add("閱", "uwkq");
            dic.Add("益", "uwl");
            dic.Add("鹢", "uwlg");
            dic.Add("蠲", "uwlj");
            dic.Add("鷁", "uwlo");
            dic.Add("瘊", "uwn");
            dic.Add("凃", "uwty");
            dic.Add("竕", "uwvn");
            dic.Add("鴗", "uwvo");
            dic.Add("痤", "uww");
            dic.Add("", "uwwf");
            dic.Add("", "uwwf");
            dic.Add("疭", "uwwi");
            dic.Add("閦", "uwww");
            dic.Add("癈", "uwxc");
            dic.Add("准", "uwy");
            dic.Add("閄", "uwy");
            dic.Add("冷", "uwyc");
            dic.Add("竛", "uwyc");
            dic.Add("閝", "uwyc");
            dic.Add("痽", "uwyd");
            dic.Add("閵", "uwyd");
            dic.Add("飡", "uwye");
            dic.Add("凖", "uwyf");
            dic.Add("凔", "uwyk");
            dic.Add("瘡", "uwyk");
            dic.Add("癄", "uwyo");
            dic.Add("北", "ux");
            dic.Add("邶", "uxb");
            dic.Add("瘬", "uxde");
            dic.Add("背", "uxe");
            dic.Add("鄁", "uxeb");
            dic.Add("丠", "uxgf");
            dic.Add("弟", "uxh");
            dic.Add("鹈", "uxhg");
            dic.Add("剃", "uxhj");
            dic.Add("弚", "uxhj");
            dic.Add("鵜", "uxho");
            dic.Add("递", "uxhp");
            dic.Add("辮", "uxiu");
            dic.Add("疿", "uxjk");
            dic.Add("冀", "uxl");
            dic.Add("軰", "uxlj");
            dic.Add("凝", "uxt");
            dic.Add("癡", "uxth");
            dic.Add("辫", "uxu");
            dic.Add("疕", "uxv");
            dic.Add("兹", "uxx");
            dic.Add("孳", "uxxb");
            dic.Add("鹚", "uxxg");
            dic.Add("關", "uxxg");
            dic.Add("慈", "uxxn");
            dic.Add("甆", "uxxn");
            dic.Add("闗", "uxxo");
            dic.Add("鶿", "uxxo");
            dic.Add("鷀", "uxxo");
            dic.Add("疪", "uxxv");
            dic.Add("癴", "uxyr");
            dic.Add("癵", "uxyw");
            dic.Add("六", "uy");
            dic.Add("訚", "uyd");
            dic.Add("誾", "uyd");
            dic.Add("冫", "uyg");
            dic.Add("丬", "uyg");
            dic.Add("疰", "uygd");
            dic.Add("疒", "uygg");
            dic.Add("辛", "uygh");
            dic.Add("门", "uyh");
            dic.Add("闵", "uyi");
            dic.Add("閔", "uyi");
            dic.Add("凉", "uyiy");
            dic.Add("凉", "uyiy");
            dic.Add("癠", "uyjd");
            dic.Add("凛", "uyl");
            dic.Add("癝", "uyli");
            dic.Add("凜", "uylt");
            dic.Add("癛", "uylt");
            dic.Add("闹", "uym");
            dic.Add("閙", "uymh");
            dic.Add("闶", "uymv");
            dic.Add("閌", "uymv");
            dic.Add("阂", "uyn");
            dic.Add("闙", "uynk");
            dic.Add("痎", "uynw");
            dic.Add("閡", "uynw");
            dic.Add("辨", "uyt");
            dic.Add("丷", "uyt");
            dic.Add("瘯", "uytd");
            dic.Add("辩", "uyu");
            dic.Add("辬", "uyuh");
            dic.Add("辯", "uyuh");
            dic.Add("阆", "uyv");
            dic.Add("閍", "uyv");
            dic.Add("閬", "uyve");
            dic.Add("瘁", "uyw");
            dic.Add("阏", "uyw");
            dic.Add("瘀", "uywu");
            dic.Add("閼", "uywu");
            dic.Add("痃", "uyx");
            dic.Add("癕", "uyxy");
            dic.Add("女", "v");
            dic.Add("毁", "va");
            dic.Add("嫟", "vaak");
            dic.Add("嬺", "vaan");
            dic.Add("媶", "vabg");
            dic.Add("婼", "vadk");
            dic.Add("媅", "vadn");
            dic.Add("娀", "vadt");
            dic.Add("娸", "vadw");
            dic.Add("媒", "vaf");
            dic.Add("姏", "vafg");
            dic.Add("妅", "vag");
            dic.Add("嬅", "vagf");
            dic.Add("姬", "vah");
            dic.Add("姫", "vahh");
            dic.Add("舁", "vaj");
            dic.Add("嫫", "vajd");
            dic.Add("鄩", "vakb");
            dic.Add("彠", "vakc");
            dic.Add("尋", "vakf");
            dic.Add("嫤", "vakg");
            dic.Add("嫗", "vakk");
            dic.Add("嫨", "vakw");
            dic.Add("孉", "vaky");
            dic.Add("媌", "valg");
            dic.Add("媖", "vamd");
            dic.Add("嫹", "vamw");
            dic.Add("姖", "vang");
            dic.Add("媟", "vans");
            dic.Add("妪", "vaq");
            dic.Add("娆", "vat");
            dic.Add("嬞", "vatf");
            dic.Add("嫕", "vatn");
            dic.Add("孏", "vaui");
            dic.Add("嬿", "vauo");
            dic.Add("嬳", "vawc");
            dic.Add("婲", "vawx");
            dic.Add("娂", "vawy");
            dic.Add("好", "vb");
            dic.Add("娵", "vbcy");
            dic.Add("嫷", "vbde");
            dic.Add("媸", "vbh");
            dic.Add("邚", "vbh");
            dic.Add("她", "vbn");
            dic.Add("恏", "vbnu");
            dic.Add("婀", "vbs");
            dic.Add("妈", "vc");
            dic.Add("既", "vca");
            dic.Add("塈", "vcaf");
            dic.Add("暨", "vcag");
            dic.Add("鱀", "vcao");
            dic.Add("即", "vcb");
            dic.Add("孥", "vcbf");
            dic.Add("堲", "vcbf");
            dic.Add("妤", "vcbh");
            dic.Add("媃", "vcbs");
            dic.Add("驽", "vcc");
            dic.Add("娺", "vccc");
            dic.Add("駑", "vccu");
            dic.Add("砮", "vcdf");
            dic.Add("姢", "vceg");
            dic.Add("始", "vck");
            dic.Add("努", "vcl");
            dic.Add("帑", "vcm");
            dic.Add("胬", "vcmw");
            dic.Add("怒", "vcn");
            dic.Add("妑", "vcn");
            dic.Add("拏", "vcrj");
            dic.Add("娭", "vctd");
            dic.Add("厹", "vcu");
            dic.Add("鴑", "vcwo");
            dic.Add("鵖", "vcwo");
            dic.Add("弩", "vcx");
            dic.Add("奴", "vcy");
            dic.Add("媽", "vcy");
            dic.Add("姑", "vd");
            dic.Add("媠", "vdae");
            dic.Add("妭", "vdcy");
            dic.Add("姷", "vdeg");
            dic.Add("媩", "vdeg");
            dic.Add("娠", "vdf");
            dic.Add("娾", "vdff");
            dic.Add("媷", "vdff");
            dic.Add("姱", "vdfn");
            dic.Add("妬", "vdg");
            dic.Add("媙", "vdgt");
            dic.Add("妦", "vdhh");
            dic.Add("夓", "vdht");
            dic.Add("婔", "vdjd");
            dic.Add("媆", "vdmd");
            dic.Add("媔", "vdmd");
            dic.Add("頄", "vdmy");
            dic.Add("娏", "vdne");
            dic.Add("娍", "vdnt");
            dic.Add("娔", "vdqn");
            dic.Add("嫄", "vdri");
            dic.Add("婍", "vdsk");
            dic.Add("嫴", "vduh");
            dic.Add("嫽", "vdui");
            dic.Add("媋", "vdwj");
            dic.Add("嫀", "vdwt");
            dic.Add("奶", "ve");
            dic.Add("娐", "vebg");
            dic.Add("垦", "vef");
            dic.Add("媛", "vefc");
            dic.Add("姐", "veg");
            dic.Add("艮", "vei");
            dic.Add("恳", "venu");
            dic.Add("退", "vep");
            dic.Add("嫒", "vepc");
            dic.Add("嬡", "vept");
            dic.Add("媱", "verm");
            dic.Add("婇", "vesy");
            dic.Add("婬", "vetf");
            dic.Add("嬀", "veto");
            dic.Add("娞", "vevg");
            dic.Add("嫍", "vevg");
            dic.Add("寻", "vf");
            dic.Add("彟", "vfac");
            dic.Add("那", "vfb");
            dic.Add("妓", "vfc");
            dic.Add("妘", "vfcy");
            dic.Add("嬬", "vfdj");
            dic.Add("娃", "vff");
            dic.Add("嫮", "vffn");
            dic.Add("嬈", "vffq");
            dic.Add("奸", "vfh");
            dic.Add("聿", "vfhk");
            dic.Add("衋", "vfhl");
            dic.Add("建", "vfhp");
            dic.Add("嫃", "vfhw");
            dic.Add("妹", "vfi");
            dic.Add("媾", "vfj");
            dic.Add("卆", "vfj");
            dic.Add("書", "vfjf");
            dic.Add("晝", "vfjg");
            dic.Add("妌", "vfjh");
            dic.Add("肅", "vfjk");
            dic.Add("鷫", "vfjo");
            dic.Add("歗", "vfjw");
            dic.Add("嬉", "vfk");
            dic.Add("媴", "vfke");
            dic.Add("嬯", "vfkf");
            dic.Add("姞", "vfkg");
            dic.Add("畵", "vflb");
            dic.Add("畫", "vflg");
            dic.Add("劃", "vflj");
            dic.Add("嬻", "vflm");
            dic.Add("毀", "vfmc");
            dic.Add("婻", "vfmf");
            dic.Add("嬦", "vfnf");
            dic.Add("娡", "vfny");
            dic.Add("嬄", "vfpu");
            dic.Add("妩", "vfq");
            dic.Add("妧", "vfqn");
            dic.Add("孀", "vfs");
            dic.Add("姥", "vft");
            dic.Add("姸", "vftf");
            dic.Add("媎", "vftj");
            dic.Add("婞", "vfuf");
            dic.Add("嫱", "vfuk");
            dic.Add("嬙", "vfwk");
            dic.Add("婈", "vfwt");
            dic.Add("妋", "vfwy");
            dic.Add("姨", "vg");
            dic.Add("妍", "vga");
            dic.Add("娬", "vgah");
            dic.Add("姪", "vgcf");
            dic.Add("婖", "vgdn");
            dic.Add("婧", "vge");
            dic.Add("婊", "vgey");
            dic.Add("婭", "vgfg");
            dic.Add("嫣", "vgh");
            dic.Add("姃", "vghg");
            dic.Add("娝", "vgik");
            dic.Add("妚", "vgiy");
            dic.Add("嫥", "vgjf");
            dic.Add("姮", "vgjg");
            dic.Add("娻", "vgji");
            dic.Add("嫩", "vgk");
            dic.Add("娪", "vgkg");
            dic.Add("娕", "vgki");
            dic.Add("嬾", "vgkm");
            dic.Add("嫰", "vgkw");
            dic.Add("婳", "vglb");
            dic.Add("媡", "vgli");
            dic.Add("姉", "vgmh");
            dic.Add("孋", "vgmx");
            dic.Add("嫧", "vgmy");
            dic.Add("礜", "vgnd");
            dic.Add("舉", "vgnh");
            dic.Add("轝", "vgnl");
            dic.Add("舃", "vgno");
            dic.Add("鸒", "vgno");
            dic.Add("擧", "vgnr");
            dic.Add("歟", "vgnw");
            dic.Add("與", "vgnw");
            dic.Add("譽", "vgny");
            dic.Add("娅", "vgo");
            dic.Add("煭", "vgqo");
            dic.Add("妺", "vgsy");
            dic.Add("婕", "vgv");
            dic.Add("娙", "vgva");
            dic.Add("嬭", "vgwq");
            dic.Add("嫊", "vgxi");
            dic.Add("叟", "vh");
            dic.Add("嫭", "vhah");
            dic.Add("婋", "vham");
            dic.Add("虓", "vham");
            dic.Add("鄋", "vhcb");
            dic.Add("遚", "vhcp");
            dic.Add("", "vhgd");
            dic.Add("盡", "vhgl");
            dic.Add("賮", "vhgm");
            dic.Add("婌", "vhic");
            dic.Add("婥", "vhjh");
            dic.Add("肀", "vhk");
            dic.Add("媜", "vhmy");
            dic.Add("娊", "vhqn");
            dic.Add("媫", "vhvh");
            dic.Add("录", "vi");
            dic.Add("娋", "vieg");
            dic.Add("隶", "vii");
            dic.Add("肃", "vij");
            dic.Add("鹔", "vijg");
            dic.Add("剥", "vijh");
            dic.Add("盝", "vilf");
            dic.Add("逮", "vip");
            dic.Add("逯", "vip");
            dic.Add("嫦", "viph");
            dic.Add("姚", "viq");
            dic.Add("姯", "viqn");
            dic.Add("妙", "vit");
            dic.Add("媣", "vivs");
            dic.Add("旭", "vj");
            dic.Add("旮", "vjf");
            dic.Add("娌", "vjfg");
            dic.Add("娨", "vjfh");
            dic.Add("妲", "vjg");
            dic.Add("婣", "vjgg");
            dic.Add("媞", "vjgh");
            dic.Add("婸", "vjgr");
            dic.Add("媢", "vjhg");
            dic.Add("妽", "vjhh");
            dic.Add("娼", "vjj");
            dic.Add("媪", "vjl");
            dic.Add("嫚", "vjlc");
            dic.Add("媀", "vjmy");
            dic.Add("巢", "vjs");
            dic.Add("鄛", "vjsb");
            dic.Add("剿", "vjsj");
            dic.Add("勦", "vjsl");
            dic.Add("婐", "vjsy");
            dic.Add("婫", "vjxx");
            dic.Add("如", "vk");
            dic.Add("邵", "vkb");
            dic.Add("卲", "vkbh");
            dic.Add("綤", "vkbi");
            dic.Add("邕", "vkc");
            dic.Add("雝", "vkcy");
            dic.Add("娟", "vke");
            dic.Add("召", "vkf");
            dic.Add("叴", "vkf");
            dic.Add("娱", "vkgd");
            dic.Add("妕", "vkhh");
            dic.Add("嬇", "vkhm");
            dic.Add("娖", "vkhy");
            dic.Add("刟", "vkjh");
            dic.Add("嬋", "vkkf");
            dic.Add("嬠", "vkks");
            dic.Add("孍", "vkkt");
            dic.Add("劭", "vkl");
            dic.Add("娲", "vkm");
            dic.Add("帤", "vkmh");
            dic.Add("恕", "vkn");
            dic.Add("娛", "vknd");
            dic.Add("巶", "vknn");
            dic.Add("娯", "vknw");
            dic.Add("迢", "vkp");
            dic.Add("欩", "vkqw");
            dic.Add("挐", "vkrj");
            dic.Add("桇", "vksu");
            dic.Add("鴽", "vkwo");
            dic.Add("絮", "vkx");
            dic.Add("舅", "vl");
            dic.Add("姻", "vld");
            dic.Add("婟", "vldg");
            dic.Add("媦", "vleg");
            dic.Add("甾", "vlf");
            dic.Add("嬕", "vlff");
            dic.Add("嫼", "vlfo");
            dic.Add("嬛", "vlge");
            dic.Add("疀", "vlgh");
            dic.Add("輿", "vlgw");
            dic.Add("嬽", "vlhd");
            dic.Add("娚", "vlln");
            dic.Add("嫐", "vllv");
            dic.Add("媤", "vlny");
            dic.Add("邋", "vlq");
            dic.Add("巤", "vlqn");
            dic.Add("媼", "vlwl");
            dic.Add("鶅", "vlwo");
            dic.Add("嫘", "vlx");
            dic.Add("妯", "vm");
            dic.Add("姍", "vmah");
            dic.Add("婰", "vmaw");
            dic.Add("婩", "vmdf");
            dic.Add("媏", "vmdj");
            dic.Add("姎", "vmdy");
            dic.Add("姌", "vmfg");
            dic.Add("婤", "vmfk");
            dic.Add("臖", "vmge");
            dic.Add("舋", "vmgg");
            dic.Add("姵", "vmgh");
            dic.Add("姛", "vmgk");
            dic.Add("娉", "vmgn");
            dic.Add("爂", "vmgo");
            dic.Add("媺", "vmgt");
            dic.Add("嬍", "vmgt");
            dic.Add("釁", "vmgv");
            dic.Add("興", "vmgw");
            dic.Add("奾", "vmh");
            dic.Add("帠", "vmhj");
            dic.Add("帇", "vmhk");
            dic.Add("姗", "vmm");
            dic.Add("孆", "vmmv");
            dic.Add("媧", "vmnk");
            dic.Add("孈", "vmwk");
            dic.Add("妠", "vmwy");
            dic.Add("刀", "vn");
            dic.Add("姄", "vnan");
            dic.Add("婮", "vndg");
            dic.Add("妞", "vnf");
            dic.Add("彐", "vng");
            dic.Add("媉", "vngf");
            dic.Add("媚", "vnh");
            dic.Add("婽", "vnhc");
            dic.Add("婿", "vnhe");
            dic.Add("媁", "vnhh");
            dic.Add("孎", "vnij");
            dic.Add("妃", "vnn");
            dic.Add("巛", "vnnn");
            dic.Add("娓", "vntn");
            dic.Add("妼", "vntt");
            dic.Add("鼠", "vnu");
            dic.Add("鼹", "vnu");
            dic.Add("鼥", "vnuc");
            dic.Add("鼷", "vnud");
            dic.Add("鼣", "vnud");
            dic.Add("鼫", "vnud");
            dic.Add("鼳", "vnud");
            dic.Add("鼵", "vnud");
            dic.Add("鼱", "vnue");
            dic.Add("鼭", "vnuf");
            dic.Add("鼪", "vnug");
            dic.Add("鼯", "vnuk");
            dic.Add("鼦", "vnuk");
            dic.Add("鼩", "vnuk");
            dic.Add("鼲", "vnul");
            dic.Add("鼺", "vnul");
            dic.Add("鼬", "vnum");
            dic.Add("鼰", "vnum");
            dic.Add("鼶", "vnum");
            dic.Add("鼸", "vnuo");
            dic.Add("鼮", "vnup");
            dic.Add("鼨", "vnuu");
            dic.Add("鼢", "vnuv");
            dic.Add("鼴", "vnuv");
            dic.Add("鼧", "vnux");
            dic.Add("鼤", "vnuy");
            dic.Add("嫪", "vnwe");
            dic.Add("妜", "vnwy");
            dic.Add("嬥", "vnwy");
            dic.Add("妮", "vnx");
            dic.Add("姒", "vny");
            dic.Add("灵", "vo");
            dic.Add("粛", "vojk");
            dic.Add("毇", "vomc");
            dic.Add("嬫", "voos");
            dic.Add("婒", "vooy");
            dic.Add("嫾", "voqh");
            dic.Add("災", "vou");
            dic.Add("彛", "vowa");
            dic.Add("彞", "voxa");
            dic.Add("巡", "vp");
            dic.Add("嫁", "vpe");
            dic.Add("婃", "vpfi");
            dic.Add("媗", "vpgg");
            dic.Add("婝", "vpgh");
            dic.Add("嬪", "vpgm");
            dic.Add("婶", "vpj");
            dic.Add("彚", "vpjs");
            dic.Add("嫇", "vpju");
            dic.Add("媈", "vplh");
            dic.Add("帚", "vpm");
            dic.Add("婠", "vpnn");
            dic.Add("嬣", "vpns");
            dic.Add("婉", "vpq");
            dic.Add("妉", "vpqn");
            dic.Add("嫔", "vpr");
            dic.Add("姹", "vpt");
            dic.Add("嬸", "vptl");
            dic.Add("廵", "vpv");
            dic.Add("辺", "vpv");
            dic.Add("姲", "vpvg");
            dic.Add("嫆", "vpwk");
            dic.Add("婚", "vq");
            dic.Add("兒", "vqb");
            dic.Add("郳", "vqbh");
            dic.Add("媰", "vqbt");
            dic.Add("姽", "vqdb");
            dic.Add("妳", "vqiy");
            dic.Add("姰", "vqjg");
            dic.Add("娩", "vqk");
            dic.Add("姁", "vqkg");
            dic.Add("姳", "vqkg");
            dic.Add("嬎", "vqkg");
            dic.Add("嬔", "vqkg");
            dic.Add("婏", "vqky");
            dic.Add("嫓", "vqmx");
            dic.Add("媍", "vqmy");
            dic.Add("舄", "vqo");
            dic.Add("婅", "vqoy");
            dic.Add("學", "vqqb");
            dic.Add("斅", "vqqc");
            dic.Add("礐", "vqqd");
            dic.Add("觷", "vqqe");
            dic.Add("壆", "vqqf");
            dic.Add("澩", "vqqi");
            dic.Add("嚳", "vqqk");
            dic.Add("嶨", "vqqm");
            dic.Add("燢", "vqqo");
            dic.Add("鱟", "vqqo");
            dic.Add("鷽", "vqqo");
            dic.Add("覺", "vqqq");
            dic.Add("斆", "vqqt");
            dic.Add("黌", "vqqw");
            dic.Add("雤", "vqqy");
            dic.Add("姼", "vqqy");
            dic.Add("夛", "vqu");
            dic.Add("婙", "vqvh");
            dic.Add("鶂", "vqwo");
            dic.Add("妁", "vqy");
            dic.Add("鸠", "vqyg");
            dic.Add("嬼", "vqyj");
            dic.Add("媹", "vqyl");
            dic.Add("奺", "vqyy");
            dic.Add("姝", "vr");
            dic.Add("媓", "vrgg");
            dic.Add("姤", "vrgk");
            dic.Add("娦", "vrgw");
            dic.Add("妡", "vrh");
            dic.Add("姩", "vrhf");
            dic.Add("嫵", "vrlo");
            dic.Add("婂", "vrmh");
            dic.Add("媿", "vrqc");
            dic.Add("婢", "vrt");
            dic.Add("妷", "vrwy");
            dic.Add("嬓", "vryt");
            dic.Add("杂", "vs");
            dic.Add("嫖", "vsf");
            dic.Add("奵", "vsh");
            dic.Add("妸", "vskg");
            dic.Add("婹", "vsvg");
            dic.Add("婡", "vsww");
            dic.Add("雑", "vswy");
            dic.Add("九", "vt");
            dic.Add("奼", "vtan");
            dic.Add("妖", "vtd");
            dic.Add("姡", "vtdg");
            dic.Add("娇", "vtdj");
            dic.Add("嬌", "vtdk");
            dic.Add("尹", "vte");
            dic.Add("妊", "vtf");
            dic.Add("奷", "vtfh");
            dic.Add("娗", "vtfp");
            dic.Add("姺", "vtfq");
            dic.Add("姓", "vtg");
            dic.Add("娷", "vtgf");
            dic.Add("媑", "vtgf");
            dic.Add("臼", "vth");
            dic.Add("妰", "vthf");
            dic.Add("嬶", "vthj");
            dic.Add("媳", "vthn");
            dic.Add("娫", "vthp");
            dic.Add("娳", "vtjh");
            dic.Add("群", "vtk");
            dic.Add("郡", "vtkb");
            dic.Add("君", "vtkd");
            dic.Add("羣", "vtkd");
            dic.Add("裠", "vtke");
            dic.Add("帬", "vtkh");
            dic.Add("頵", "vtkm");
            dic.Add("焄", "vtko");
            dic.Add("鵘", "vtko");
            dic.Add("覠", "vtkq");
            dic.Add("媲", "vtl");
            dic.Add("姠", "vtmk");
            dic.Add("姊", "vtnt");
            dic.Add("嬏", "vtol");
            dic.Add("姂", "vtpy");
            dic.Add("娥", "vtr");
            dic.Add("婑", "vtvg");
            dic.Add("孂", "vtvl");
            dic.Add("娒", "vtxu");
            dic.Add("姀", "vty");
            dic.Add("嫌", "vu");
            dic.Add("姘", "vua");
            dic.Add("嬂", "vuaj");
            dic.Add("嫅", "vuda");
            dic.Add("婘", "vudb");
            dic.Add("嫸", "vudk");
            dic.Add("嫺", "vueg");
            dic.Add("媊", "vuej");
            dic.Add("嬘", "vuep");
            dic.Add("嬢", "vufe");
            dic.Add("姅", "vufh");
            dic.Add("媄", "vugd");
            dic.Add("孄", "vugi");
            dic.Add("嬟", "vugt");
            dic.Add("婵", "vuj");
            dic.Add("嫜", "vujh");
            dic.Add("嬑", "vujn");
            dic.Add("婄", "vukg");
            dic.Add("娧", "vukq");
            dic.Add("嫡", "vum");
            dic.Add("媂", "vuph");
            dic.Add("嫎", "vupy");
            dic.Add("姣", "vuq");
            dic.Add("娴", "vus");
            dic.Add("媨", "vusg");
            dic.Add("媇", "vusy");
            dic.Add("嫻", "vusy");
            dic.Add("嫉", "vut");
            dic.Add("馗", "vuth");
            dic.Add("娣", "vux");
            dic.Add("嬨", "vuxn");
            dic.Add("妇", "vv");
            dic.Add("娜", "vvf");
            dic.Add("嫿", "vvfg");
            dic.Add("姧", "vvfh");
            dic.Add("奻", "vvg");
            dic.Add("嬩", "vvgw");
            dic.Add("嫂", "vvh");
            dic.Add("嬧", "vvhl");
            dic.Add("娽", "vviy");
            dic.Add("妱", "vvkg");
            dic.Add("嬹", "vvmw");
            dic.Add("婦", "vvph");
            dic.Add("婗", "vvqn");
            dic.Add("刕", "vvvb");
            dic.Add("脋", "vvve");
            dic.Add("姦", "vvvf");
            dic.Add("臾", "vw");
            dic.Add("妐", "vwcy");
            dic.Add("婨", "vwga");
            dic.Add("媕", "vwga");
            dic.Add("婾", "vwgb");
            dic.Add("姾", "vwgg");
            dic.Add("媮", "vwgj");
            dic.Add("嬒", "vwgj");
            dic.Add("姶", "vwgk");
            dic.Add("嬆", "vwgn");
            dic.Add("嬁", "vwgu");
            dic.Add("嬐", "vwgw");
            dic.Add("刅", "vwi");
            dic.Add("妎", "vwjh");
            dic.Add("媬", "vwks");
            dic.Add("惥", "vwnu");
            dic.Add("娰", "vwnw");
            dic.Add("姙", "vwtf");
            dic.Add("斞", "vwuf");
            dic.Add("嬝", "vwve");
            dic.Add("妢", "vwvn");
            dic.Add("鳩", "vwvo");
            dic.Add("鳭", "vwvo");
            dic.Add("孅", "vwwg");
            dic.Add("妗", "vwy");
            dic.Add("姈", "vwyc");
            dic.Add("孇", "vwyc");
            dic.Add("婎", "vwyg");
            dic.Add("娢", "vwyk");
            dic.Add("嫶", "vwyo");
            dic.Add("姆", "vx");
            dic.Add("嬵", "vxrh");
            dic.Add("嫋", "vxuu");
            dic.Add("妣", "vxx");
            dic.Add("蠿", "vxxj");
            dic.Add("媘", "vxxr");
            dic.Add("娹", "vxyx");
            dic.Add("妨", "vy");
            dic.Add("嫬", "vyao");
            dic.Add("訄", "vyd");
            dic.Add("娮", "vyg");
            dic.Add("丒", "vygf");
            dic.Add("妵", "vygg");
            dic.Add("刃", "vyi");
            dic.Add("丸", "vyi");
            dic.Add("刄", "vyi");
            dic.Add("婛", "vyiy");
            dic.Add("孃", "vyke");
            dic.Add("妫", "vyl");
            dic.Add("嬗", "vylg");
            dic.Add("妔", "vymn");
            dic.Add("媥", "vyna");
            dic.Add("妒", "vynt");
            dic.Add("忍", "vynu");
            dic.Add("姟", "vynw");
            dic.Add("婷", "vyp");
            dic.Add("嬷", "vys");
            dic.Add("孊", "vysd");
            dic.Add("嫲", "vyss");
            dic.Add("嬤", "vysx");
            dic.Add("嫙", "vyth");
            dic.Add("媯", "vyto");
            dic.Add("嬚", "vyuo");
            dic.Add("娘", "vyv");
            dic.Add("嫏", "vyvb");
            dic.Add("奿", "vyvd");
            dic.Add("嫞", "vyvh");
            dic.Add("歰", "vyvh");
            dic.Add("嫝", "vyvi");
            dic.Add("妶", "vyxy");
            dic.Add("妏", "vyy");
            dic.Add("人", "w");
            dic.Add("八", "w");
            dic.Add("代", "wa");
            dic.Add("侙", "waag");
            dic.Add("僷", "waas");
            dic.Add("俴", "waat");
            dic.Add("傇", "wabg");
            dic.Add("偌", "wad");
            dic.Add("偡", "wadn");
            dic.Add("倛", "wadw");
            dic.Add("僛", "wadw");
            dic.Add("儰", "waeo");
            dic.Add("仝", "waf");
            dic.Add("垡", "waff");
            dic.Add("垈", "waff");
            dic.Add("佄", "wafg");
            dic.Add("仜", "wag");
            dic.Add("仺", "wagf");
            dic.Add("伢", "wah");
            dic.Add("儖", "wahl");
            dic.Add("借", "waj");
            dic.Add("偃", "wajv");
            dic.Add("僅", "wakg");
            dic.Add("傴", "wakk");
            dic.Add("傼", "wakw");
            dic.Add("儺", "waky");
            dic.Add("黛", "wal");
            dic.Add("儚", "walq");
            dic.Add("贷", "wam");
            dic.Add("偀", "wamd");
            dic.Add("帒", "wamh");
            dic.Add("岱", "wamj");
            dic.Add("貸", "wamu");
            dic.Add("僙", "wamw");
            dic.Add("佢", "wang");
            dic.Add("伳", "wann");
            dic.Add("偞", "wans");
            dic.Add("僃", "waqe");
            dic.Add("僀", "waqh");
            dic.Add("僭", "waqj");
            dic.Add("儆", "waqt");
            dic.Add("伛", "waqy");
            dic.Add("牮", "war");
            dic.Add("柋", "wasu");
            dic.Add("伐", "wat");
            dic.Add("備", "wate");
            dic.Add("憊", "watn");
            dic.Add("侥", "watq");
            dic.Add("供", "waw");
            dic.Add("袋", "waye");
            dic.Add("他", "wb");
            dic.Add("戗", "wba");
            dic.Add("仓", "wbb");
            dic.Add("倻", "wbbh");
            dic.Add("仔", "wbg");
            dic.Add("佴", "wbg");
            dic.Add("创", "wbj");
            dic.Add("怹", "wbnu");
            dic.Add("鸧", "wbqg");
            dic.Add("公", "wc");
            dic.Add("伃", "wcbh");
            dic.Add("僪", "wcbk");
            dic.Add("傪", "wcce");
            dic.Add("颂", "wcd");
            dic.Add("頌", "wcdm");
            dic.Add("俑", "wce");
            dic.Add("瓮", "wcg");
            dic.Add("佁", "wckg");
            dic.Add("翁", "wcn");
            dic.Add("鹟", "wcng");
            dic.Add("勜", "wcnl");
            dic.Add("鶲", "wcno");
            dic.Add("忩", "wcnu");
            dic.Add("兊", "wcqb");
            dic.Add("毤", "wcqn");
            dic.Add("侔", "wcr");
            dic.Add("枀", "wcsu");
            dic.Add("俟", "wct");
            dic.Add("俊", "wcw");
            dic.Add("傩", "wcwy");
            dic.Add("仅", "wcy");
            dic.Add("仏", "wcy");
            dic.Add("傌", "wcy");
            dic.Add("估", "wd");
            dic.Add("佐", "wda");
            dic.Add("伌", "wdbn");
            dic.Add("伖", "wdcy");
            dic.Add("侑", "wde");
            dic.Add("優", "wdet");
            dic.Add("倀", "wdey");
            dic.Add("侉", "wdf");
            dic.Add("倴", "wdfa");
            dic.Add("侲", "wdfe");
            dic.Add("傉", "wdff");
            dic.Add("倷", "wdfi");
            dic.Add("仨", "wdg");
            dic.Add("佦", "wdg");
            dic.Add("侟", "wdhb");
            dic.Add("偰", "wdhd");
            dic.Add("仹", "wdhh");
            dic.Add("傶", "wdht");
            dic.Add("佰", "wdj");
            dic.Add("俳", "wdjd");
            dic.Add("俺", "wdjn");
            dic.Add("佑", "wdk");
            dic.Add("段", "wdm");
            dic.Add("偄", "wdmd");
            dic.Add("偭", "wdmd");
            dic.Add("佈", "wdmh");
            dic.Add("侕", "wdmj");
            dic.Add("优", "wdn");
            dic.Add("偧", "wdqq");
            dic.Add("傸", "wdqq");
            dic.Add("傆", "wdri");
            dic.Add("倚", "wds");
            dic.Add("做", "wdt");
            dic.Add("俦", "wdtf");
            dic.Add("儮", "wdth");
            dic.Add("僚", "wdu");
            dic.Add("傄", "wduh");
            dic.Add("傣", "wdw");
            dic.Add("俸", "wdwh");
            dic.Add("偆", "wdwj");
            dic.Add("俠", "wdww");
            dic.Add("伏", "wdy");
            dic.Add("仗", "wdyy");
            dic.Add("仍", "we");
            dic.Add("俘", "web");
            dic.Add("俷", "wecn");
            dic.Add("倗", "weeg");
            dic.Add("仴", "weg");
            dic.Add("伹", "wegg");
            dic.Add("佣", "weh");
            dic.Add("偁", "wemf");
            dic.Add("僢", "weph");
            dic.Add("僾", "wept");
            dic.Add("傜", "werm");
            dic.Add("倸", "wesy");
            dic.Add("僞", "weto");
            dic.Add("俀", "wevg");
            dic.Add("傒", "wexd");
            dic.Add("伋", "weyy");
            dic.Add("会", "wf");
            dic.Add("偾", "wfa");
            dic.Add("傤", "wfal");
            dic.Add("儎", "wfal");
            dic.Add("僨", "wfam");
            dic.Add("郐", "wfcb");
            dic.Add("刽", "wfcj");
            dic.Add("伎", "wfcy");
            dic.Add("伝", "wfcy");
            dic.Add("佉", "wfcy");
            dic.Add("儒", "wfd");
            dic.Add("侍", "wff");
            dic.Add("佳", "wffg");
            dic.Add("僥", "wffq");
            dic.Add("仁", "wfg");
            dic.Add("仕", "wfg");
            dic.Add("什", "wfh");
            dic.Add("仠", "wfh");
            dic.Add("佱", "wfhf");
            dic.Add("值", "wfhg");
            dic.Add("値", "wfhn");
            dic.Add("傎", "wfhw");
            dic.Add("祭", "wfi");
            dic.Add("畲", "wfil");
            dic.Add("佘", "wfiu");
            dic.Add("俅", "wfiy");
            dic.Add("佅", "wfiy");
            dic.Add("仐", "wfj");
            dic.Add("癷", "wfj");
            dic.Add("傋", "wfjf");
            dic.Add("舍", "wfk");
            dic.Add("舒", "wfkb");
            dic.Add("儓", "wfkf");
            dic.Add("舎", "wfkf");
            dic.Add("佶", "wfkg");
            dic.Add("僖", "wfkk");
            dic.Add("舘", "wfkn");
            dic.Add("鵨", "wfko");
            dic.Add("舖", "wfky");
            dic.Add("舗", "wfky");
            dic.Add("舆", "wfl");
            dic.Add("儥", "wflm");
            dic.Add("璺", "wfm");
            dic.Add("爨", "wfmo");
            dic.Add("伟", "wfn");
            dic.Add("儔", "wfnf");
            dic.Add("怤", "wfnu");
            dic.Add("传", "wfny");
            dic.Add("俧", "wfny");
            dic.Add("侼", "wfpb");
            dic.Add("発", "wfqb");
            dic.Add("佬", "wft");
            dic.Add("侾", "wftb");
            dic.Add("偖", "wftj");
            dic.Add("侤", "wftn");
            dic.Add("倖", "wfuf");
            dic.Add("佞", "wfv");
            dic.Add("姇", "wfvf");
            dic.Add("僣", "wfwj");
            dic.Add("儧", "wfwm");
            dic.Add("倰", "wfwt");
            dic.Add("伕", "wfwy");
            dic.Add("付", "wfy");
            dic.Add("全", "wg");
            dic.Add("倵", "wgah");
            dic.Add("侀", "wgaj");
            dic.Add("伅", "wgbn");
            dic.Add("倒", "wgc");
            dic.Add("侄", "wgcf");
            dic.Add("癸", "wgd");
            dic.Add("戣", "wgda");
            dic.Add("鄈", "wgdb");
            dic.Add("傅", "wge");
            dic.Add("毹", "wge");
            dic.Add("兪", "wgeb");
            dic.Add("鄃", "wgeb");
            dic.Add("倩", "wgeg");
            dic.Add("俞", "wgej");
            dic.Add("愈", "wgen");
            dic.Add("逾", "wgep");
            dic.Add("觎", "wgeq");
            dic.Add("儬", "wgeq");
            dic.Add("覦", "wgeq");
            dic.Add("歈", "wgew");
            dic.Add("俌", "wgey");
            dic.Add("俵", "wgey");
            dic.Add("亼", "wgf");
            dic.Add("俹", "wgfg");
            dic.Add("僫", "wgfn");
            dic.Add("伍", "wgg");
            dic.Add("仼", "wgg");
            dic.Add("佂", "wghg");
            dic.Add("傿", "wgho");
            dic.Add("剑", "wgi");
            dic.Add("佥", "wgif");
            dic.Add("伾", "wgig");
            dic.Add("俖", "wgik");
            dic.Add("敛", "wgit");
            dic.Add("伓", "wgiy");
            dic.Add("便", "wgj");
            dic.Add("傳", "wgjf");
            dic.Add("倲", "wgji");
            dic.Add("僡", "wgjn");
            dic.Add("合", "wgk");
            dic.Add("颌", "wgk");
            dic.Add("龠", "wgka");
            dic.Add("弇", "wgka");
            dic.Add("命", "wgkb");
            dic.Add("郃", "wgkb");
            dic.Add("鄧", "wgkb");
            dic.Add("敆", "wgkc");
            dic.Add("龕", "wgkd");
            dic.Add("儾", "wgke");
            dic.Add("鸽", "wgkg");
            dic.Add("俉", "wgkg");
            dic.Add("倳", "wgkh");
            dic.Add("龣", "wgki");
            dic.Add("剣", "wgkj");
            dic.Add("劍", "wgkj");
            dic.Add("樖", "wgkk");
            dic.Add("盒", "wgkl");
            dic.Add("偪", "wgkl");
            dic.Add("畣", "wgkl");
            dic.Add("盫", "wgkl");
            dic.Add("凳", "wgkm");
            dic.Add("頜", "wgkm");
            dic.Add("顩", "wgkm");
            dic.Add("龥", "wgkm");
            dic.Add("翕", "wgkn");
            dic.Add("翖", "wgkn");
            dic.Add("鴿", "wgko");
            dic.Add("鸙", "wgko");
            dic.Add("邆", "wgkp");
            dic.Add("使", "wgkq");
            dic.Add("覴", "wgkq");
            dic.Add("拿", "wgkr");
            dic.Add("搻", "wgkr");
            dic.Add("龤", "wgkr");
            dic.Add("斂", "wgkt");
            dic.Add("龢", "wgkt");
            dic.Add("登", "wgku");
            dic.Add("侸", "wgku");
            dic.Add("豋", "wgku");
            dic.Add("劎", "wgkv");
            dic.Add("歙", "wgkw");
            dic.Add("僉", "wgkw");
            dic.Add("欱", "wgkw");
            dic.Add("歛", "wgkw");
            dic.Add("龡", "wgkw");
            dic.Add("龛", "wgkx");
            dic.Add("剱", "wgky");
            dic.Add("劒", "wgky");
            dic.Add("劔", "wgky");
            dic.Add("僵", "wgl");
            dic.Add("鄶", "wglb");
            dic.Add("朇", "wglf");
            dic.Add("劊", "wglj");
            dic.Add("會", "wglj");
            dic.Add("俩", "wgm");
            dic.Add("俪", "wgm");
            dic.Add("侖", "wgma");
            dic.Add("侢", "wgmf");
            dic.Add("伂", "wgmh");
            dic.Add("傮", "wgmj");
            dic.Add("儷", "wgmx");
            dic.Add("债", "wgmy");
            dic.Add("倆", "wgmy");
            dic.Add("債", "wgmy");
            dic.Add("佤", "wgn");
            dic.Add("兮", "wgnb");
            dic.Add("侴", "wgnj");
            dic.Add("俨", "wgo");
            dic.Add("俫", "wgoy");
            dic.Add("例", "wgq");
            dic.Add("傲", "wgqt");
            dic.Add("侠", "wgu");
            dic.Add("伻", "wguh");
            dic.Add("俓", "wgva");
            dic.Add("倢", "wgvh");
            dic.Add("儞", "wgwq");
            dic.Add("仾", "wgxg");
            dic.Add("傃", "wgxi");
            dic.Add("侇", "wgxw");
            dic.Add("个", "wh");
            dic.Add("俿", "wham");
            dic.Add("儢", "whan");
            dic.Add("佊", "whcy");
            dic.Add("企", "whf");
            dic.Add("仩", "whg");
            dic.Add("倶", "whgw");
            dic.Add("佧", "whh");
            dic.Add("俶", "whic");
            dic.Add("倬", "whjh");
            dic.Add("佔", "whkg");
            dic.Add("侦", "whm");
            dic.Add("偵", "whmy");
            dic.Add("候", "whn");
            dic.Add("佀", "whnn");
            dic.Add("俔", "whqn");
            dic.Add("儏", "whqo");
            dic.Add("修", "wht");
            dic.Add("倏", "whtd");
            dic.Add("脩", "whte");
            dic.Add("鞗", "whtf");
            dic.Add("跾", "whth");
            dic.Add("絛", "whti");
            dic.Add("偹", "whtl");
            dic.Add("悠", "whtn");
            dic.Add("翛", "whtn");
            dic.Add("倐", "whto");
            dic.Add("儵", "whto");
            dic.Add("焂", "whto");
            dic.Add("鯈", "whto");
            dic.Add("鋚", "whtq");
            dic.Add("鎥", "whtq");
            dic.Add("條", "whts");
            dic.Add("攸", "whty");
            dic.Add("偼", "whvh");
            dic.Add("俱", "whw");
            dic.Add("佌", "whxn");
            dic.Add("偨", "whxs");
            dic.Add("仆", "why");
            dic.Add("偿", "wi");
            dic.Add("俏", "wie");
            dic.Add("倘", "wim");
            dic.Add("僘", "wimt");
            dic.Add("儅", "wipl");
            dic.Add("償", "wipm");
            dic.Add("儻", "wipo");
            dic.Add("傥", "wipq");
            dic.Add("佻", "wiq");
            dic.Add("侊", "wiqn");
            dic.Add("偗", "with");
            dic.Add("仯", "witt");
            dic.Add("氽", "wiu");
            dic.Add("尒", "wiu");
            dic.Add("仦", "wiy");
            dic.Add("介", "wj");
            dic.Add("儤", "wjai");
            dic.Add("俚", "wjf");
            dic.Add("但", "wjg");
            dic.Add("偍", "wjgh");
            dic.Add("偒", "wjgr");
            dic.Add("伸", "wjh");
            dic.Add("敒", "wjht");
            dic.Add("倡", "wjjg");
            dic.Add("僈", "wjlc");
            dic.Add("偶", "wjm");
            dic.Add("傝", "wjng");
            dic.Add("偈", "wjq");
            dic.Add("倮", "wjs");
            dic.Add("儑", "wjxo");
            dic.Add("倱", "wjxx");
            dic.Add("保", "wk");
            dic.Add("偮", "wkbg");
            dic.Add("俋", "wkcn");
            dic.Add("俣", "wkg");
            dic.Add("侱", "wkgg");
            dic.Add("促", "wkh");
            dic.Add("仲", "wkhh");
            dic.Add("僓", "wkhm");
            dic.Add("儙", "wkhp");
            dic.Add("侣", "wkk");
            dic.Add("僤", "wkkf");
            dic.Add("偘", "wkkk");
            dic.Add("偔", "wkkn");
            dic.Add("僺", "wkks");
            dic.Add("儼", "wkkt");
            dic.Add("傊", "wkmy");
            dic.Add("俁", "wknd");
            dic.Add("侃", "wkq");
            dic.Add("兌", "wkqb");
            dic.Add("敓", "wkqt");
            dic.Add("諐", "wkqy");
            dic.Add("堡", "wksf");
            dic.Add("賲", "wksm");
            dic.Add("煲", "wkso");
            dic.Add("侶", "wktk");
            dic.Add("伿", "wkwy");
            dic.Add("佃", "wl");
            dic.Add("個", "wldg");
            dic.Add("伵", "wlg");
            dic.Add("偎", "wlge");
            dic.Add("儇", "wlge");
            dic.Add("伡", "wlh");
            dic.Add("俥", "wlh");
            dic.Add("伽", "wlk");
            dic.Add("佪", "wlkg");
            dic.Add("儡", "wll");
            dic.Add("儽", "wlli");
            dic.Add("侽", "wlln");
            dic.Add("仂", "wln");
            dic.Add("偲", "wlny");
            dic.Add("僆", "wlpy");
            dic.Add("僌", "wlty");
            dic.Add("僂", "wlvg");
            dic.Add("傫", "wlxi");
            dic.Add("儸", "wlxy");
            dic.Add("仙", "wm");
            dic.Add("儂", "wmae");
            dic.Add("僼", "wmau");
            dic.Add("倎", "wmaw");
            dic.Add("癹", "wmcu");
            dic.Add("伇", "wmcy");
            dic.Add("偳", "wmdj");
            dic.Add("佒", "wmdy");
            dic.Add("傰", "wmee");
            dic.Add("傦", "wmeg");
            dic.Add("倜", "wmf");
            dic.Add("佩", "wmg");
            dic.Add("伷", "wmg");
            dic.Add("侗", "wmgk");
            dic.Add("俜", "wmgn");
            dic.Add("僶", "wmgv");
            dic.Add("侧", "wmj");
            dic.Add("仚", "wmj");
            dic.Add("側", "wmjh");
            dic.Add("儩", "wmjr");
            dic.Add("仉", "wmn");
            dic.Add("伣", "wmqn");
            dic.Add("偑", "wmtj");
            dic.Add("催", "wmw");
            dic.Add("儶", "wmwk");
            dic.Add("侺", "wmwn");
            dic.Add("亿", "wn");
            dic.Add("倔", "wnb");
            dic.Add("僝", "wnbb");
            dic.Add("倨", "wnd");
            dic.Add("伺", "wng");
            dic.Add("鄔", "wngb");
            dic.Add("偓", "wngf");
            dic.Add("烏", "wngo");
            dic.Add("歍", "wngw");
            dic.Add("假", "wnh");
            dic.Add("偦", "wnhe");
            dic.Add("偉", "wnhh");
            dic.Add("僻", "wnk");
            dic.Add("阜", "wnnf");
            dic.Add("帥", "wnnh");
            dic.Add("師", "wnnh");
            dic.Add("歸", "wnnh");
            dic.Add("蛗", "wnnj");
            dic.Add("侷", "wnnk");
            dic.Add("峊", "wnnm");
            dic.Add("頧", "wnnm");
            dic.Add("顊", "wnnm");
            dic.Add("鴭", "wnno");
            dic.Add("追", "wnnp");
            dic.Add("僎", "wnnw");
            dic.Add("侯", "wnt");
            dic.Add("鄇", "wntb");
            dic.Add("佖", "wntt");
            dic.Add("偋", "wnua");
            dic.Add("亾", "wnv");
            dic.Add("僇", "wnwe");
            dic.Add("伲", "wnx");
            dic.Add("似", "wny");
            dic.Add("伈", "wny");
            dic.Add("癶", "wnyt");
            dic.Add("侭", "wnyu");
            dic.Add("伬", "wnyy");
            dic.Add("伙", "wo");
            dic.Add("儍", "wobt");
            dic.Add("僕", "wogy");
            dic.Add("僗", "wool");
            dic.Add("儝", "woos");
            dic.Add("倓", "wooy");
            dic.Add("僯", "woqh");
            dic.Add("偻", "wov");
            dic.Add("侎", "woy");
            dic.Add("侬", "wp");
            dic.Add("餞", "wpaa");
            dic.Add("饃", "wpad");
            dic.Add("饛", "wpae");
            dic.Add("饉", "wpag");
            dic.Add("饇", "wpak");
            dic.Add("饚", "wpal");
            dic.Add("餀", "wpaq");
            dic.Add("饊", "wpat");
            dic.Add("餝", "wpay");
            dic.Add("餌", "wpbg");
            dic.Add("飿", "wpbm");
            dic.Add("餟", "wpcc");
            dic.Add("飴", "wpck");
            dic.Add("餕", "wpct");
            dic.Add("餴", "wpda");
            dic.Add("餪", "wpdd");
            dic.Add("餦", "wpde");
            dic.Add("餬", "wpde");
            dic.Add("餣", "wpdn");
            dic.Add("飷", "wpeg");
            dic.Add("餒", "wpev");
            dic.Add("饀", "wpev");
            dic.Add("傢", "wpey");
            dic.Add("餑", "wpfb");
            dic.Add("僿", "wpff");
            dic.Add("飦", "wpfh");
            dic.Add("倧", "wpfi");
            dic.Add("饎", "wpfk");
            dic.Add("饁", "wpfl");
            dic.Add("饙", "wpfm");
            dic.Add("俒", "wpfq");
            dic.Add("饒", "wpfq");
            dic.Add("饐", "wpfu");
            dic.Add("伫", "wpg");
            dic.Add("饢", "wpge");
            dic.Add("餺", "wpgf");
            dic.Add("餗", "wpgi");
            dic.Add("儐", "wpgm");
            dic.Add("飩", "wpgn");
            dic.Add("餖", "wpgu");
            dic.Add("餔", "wpgy");
            dic.Add("饖", "wpht");
            dic.Add("饄", "wpif");
            dic.Add("餆", "wpiq");
            dic.Add("饓", "wpis");
            dic.Add("饅", "wpjc");
            dic.Add("饆", "wpjf");
            dic.Add("饂", "wpjl");
            dic.Add("餲", "wpjn");
            dic.Add("餳", "wpjr");
            dic.Add("餜", "wpjs");
            dic.Add("餛", "wpjx");
            dic.Add("蝕", "wpjy");
            dic.Add("饋", "wpkm");
            dic.Add("餵", "wple");
            dic.Add("饠", "wply");
            dic.Add("餶", "wpme");
            dic.Add("餇", "wpmk");
            dic.Add("伔", "wpmn");
            dic.Add("飢", "wpmn");
            dic.Add("倌", "wpn");
            dic.Add("飼", "wpnk");
            dic.Add("儜", "wpns");
            dic.Add("飶", "wpnt");
            dic.Add("饌", "wpnw");
            dic.Add("餤", "wpoo");
            dic.Add("餫", "wppl");
            dic.Add("館", "wppn");
            dic.Add("倇", "wpqb");
            dic.Add("飹", "wpqb");
            dic.Add("餚", "wpqe");
            dic.Add("餙", "wpqh");
            dic.Add("餾", "wpql");
            dic.Add("飽", "wpqn");
            dic.Add("餡", "wpqv");
            dic.Add("飲", "wpqw");
            dic.Add("饞", "wpqy");
            dic.Add("傧", "wpr");
            dic.Add("飯", "wprc");
            dic.Add("餽", "wprc");
            dic.Add("餭", "wprg");
            dic.Add("餼", "wpro");
            dic.Add("餷", "wpsg");
            dic.Add("佇", "wpsh");
            dic.Add("飣", "wpsh");
            dic.Add("俕", "wpsy");
            dic.Add("侘", "wpta");
            dic.Add("飥", "wpta");
            dic.Add("飫", "wptd");
            dic.Add("餂", "wptd");
            dic.Add("飪", "wptf");
            dic.Add("飵", "wptf");
            dic.Add("餠", "wptf");
            dic.Add("飾", "wpth");
            dic.Add("餰", "wpth");
            dic.Add("餉", "wptk");
            dic.Add("餎", "wptk");
            dic.Add("飭", "wptl");
            dic.Add("饡", "wptm");
            dic.Add("餓", "wptt");
            dic.Add("餧", "wptv");
            dic.Add("飠", "wpu");
            dic.Add("餅", "wpua");
            dic.Add("饈", "wpuf");
            dic.Add("餢", "wpuk");
            dic.Add("饍", "wpuk");
            dic.Add("餻", "wpuo");
            dic.Add("餃", "wpuq");
            dic.Add("餿", "wpvc");
            dic.Add("侒", "wpvg");
            dic.Add("倥", "wpw");
            dic.Add("餱", "wpwd");
            dic.Add("飻", "wpwe");
            dic.Add("餁", "wpwf");
            dic.Add("傛", "wpwk");
            dic.Add("僒", "wpwk");
            dic.Add("餄", "wpwk");
            dic.Add("餘", "wpwt");
            dic.Add("餩", "wpww");
            dic.Add("傕", "wpwy");
            dic.Add("飤", "wpwy");
            dic.Add("佗", "wpx");
            dic.Add("餯", "wpxe");
            dic.Add("饑", "wpxt");
            dic.Add("饝", "wpyd");
            dic.Add("餏", "wpye");
            dic.Add("饟", "wpye");
            dic.Add("飳", "wpyg");
            dic.Add("饘", "wpyg");
            dic.Add("飰", "wpyh");
            dic.Add("餹", "wpyk");
            dic.Add("你", "wq");
            dic.Add("低", "wqa");
            dic.Add("傑", "wqas");
            dic.Add("爷", "wqb");
            dic.Add("尣", "wqb");
            dic.Add("爺", "wqbb");
            dic.Add("仰", "wqbh");
            dic.Add("", "wqbt");
            dic.Add("爸", "wqc");
            dic.Add("儋", "wqd");
            dic.Add("佹", "wqdb");
            dic.Add("倄", "wqde");
            dic.Add("俙", "wqdh");
            dic.Add("釜", "wqf");
            dic.Add("釡", "wqf");
            dic.Add("尩", "wqgd");
            dic.Add("您", "wqin");
            dic.Add("像", "wqj");
            dic.Add("侚", "wqjg");
            dic.Add("佝", "wqk");
            dic.Add("佲", "wqkg");
            dic.Add("俛", "wqkq");
            dic.Add("儳", "wqky");
            dic.Add("偩", "wqmy");
            dic.Add("佨", "wqnn");
            dic.Add("侈", "wqq");
            dic.Add("爹", "wqqq");
            dic.Add("尦", "wqqy");
            dic.Add("斧", "wqr");
            dic.Add("偬", "wqrn");
            dic.Add("伆", "wqrt");
            dic.Add("俇", "wqtg");
            dic.Add("父", "wqu");
            dic.Add("伨", "wqug");
            dic.Add("", "wqvg");
            dic.Add("仢", "wqyy");
            dic.Add("伯", "wr");
            dic.Add("仮", "wrcy");
            dic.Add("偱", "wrfh");
            dic.Add("偟", "wrgg");
            dic.Add("件", "wrh");
            dic.Add("伒", "wrh");
            dic.Add("傂", "wrhm");
            dic.Add("侏", "wri");
            dic.Add("儛", "wrlh");
            dic.Add("傀", "wrq");
            dic.Add("俽", "wrqw");
            dic.Add("儨", "wrrm");
            dic.Add("俾", "wrt");
            dic.Add("佚", "wrw");
            dic.Add("儌", "wryt");
            dic.Add("休", "ws");
            dic.Add("僊", "wsdn");
            dic.Add("僄", "wsfi");
            dic.Add("体", "wsg");
            dic.Add("価", "wsg");
            dic.Add("仃", "wsh");
            dic.Add("何", "wsk");
            dic.Add("價", "wsmy");
            dic.Add("恷", "wsnu");
            dic.Add("僳", "wso");
            dic.Add("烋", "wsou");
            dic.Add("鸺", "wsq");
            dic.Add("僲", "wsqh");
            dic.Add("傈", "wss");
            dic.Add("儊", "wssh");
            dic.Add("僸", "wssi");
            dic.Add("偠", "wsvg");
            dic.Add("倯", "wswc");
            dic.Add("鵂", "wswo");
            dic.Add("倈", "wsww");
            dic.Add("作", "wt");
            dic.Add("伥", "wta");
            dic.Add("佭", "wtah");
            dic.Add("仛", "wtan");
            dic.Add("叙", "wtc");
            dic.Add("仫", "wtc");
            dic.Add("俬", "wtcy");
            dic.Add("侨", "wtd");
            dic.Add("佸", "wtdg");
            dic.Add("倁", "wtdk");
            dic.Add("僑", "wtdk");
            dic.Add("仸", "wtdy");
            dic.Add("俢", "wtet");
            dic.Add("侜", "wtey");
            dic.Add("任", "wtf");
            dic.Add("赁", "wtf");
            dic.Add("仵", "wtf");
            dic.Add("倂", "wtff");
            dic.Add("偫", "wtff");
            dic.Add("仟", "wtfh");
            dic.Add("俈", "wtfk");
            dic.Add("凭", "wtfm");
            dic.Add("儹", "wtfm");
            dic.Add("賃", "wtfm");
            dic.Add("恁", "wtfn");
            dic.Add("鵀", "wtfo");
            dic.Add("侹", "wtfp");
            dic.Add("侁", "wtfq");
            dic.Add("栠", "wtfs");
            dic.Add("偛", "wtfv");
            dic.Add("倕", "wtgf");
            dic.Add("偅", "wtgf");
            dic.Add("働", "wtgl");
            dic.Add("亻", "wth");
            dic.Add("敍", "wthc");
            dic.Add("偺", "wthj");
            dic.Add("倃", "wthk");
            dic.Add("俐", "wtj");
            dic.Add("傷", "wtjr");
            dic.Add("佫", "wtkg");
            dic.Add("俰", "wtkg");
            dic.Add("偊", "wtky");
            dic.Add("伤", "wtl");
            dic.Add("畬", "wtlf");
            dic.Add("侐", "wtlg");
            dic.Add("俻", "wtlg");
            dic.Add("傯", "wtln");
            dic.Add("傻", "wtlt");
            dic.Add("峹", "wtmj");
            dic.Add("嵞", "wtmm");
            dic.Add("仡", "wtn");
            dic.Add("悆", "wtnu");
            dic.Add("僠", "wtol");
            dic.Add("僁", "wton");
            dic.Add("僽", "wton");
            dic.Add("偢", "wtoy");
            dic.Add("途", "wtp");
            dic.Add("俄", "wtr");
            dic.Add("敘", "wtty");
            dic.Add("余", "wtu");
            dic.Add("厁", "wtub");
            dic.Add("斜", "wtuf");
            dic.Add("佟", "wtuy");
            dic.Add("倭", "wtv");
            dic.Add("傱", "wtwh");
            dic.Add("雓", "wtwy");
            dic.Add("侮", "wtx");
            dic.Add("係", "wtxi");
            dic.Add("们", "wu");
            dic.Add("併", "wuah");
            dic.Add("倦", "wud");
            dic.Add("傞", "wuda");
            dic.Add("儯", "wudc");
            dic.Add("佯", "wudh");
            dic.Add("僐", "wudk");
            dic.Add("儱", "wued");
            dic.Add("僩", "wueg");
            dic.Add("偂", "wuej");
            dic.Add("伴", "wuf");
            dic.Add("位", "wug");
            dic.Add("們", "wug");
            dic.Add("儀", "wugt");
            dic.Add("伞", "wuh");
            dic.Add("僮", "wuj");
            dic.Add("偣", "wujg");
            dic.Add("僴", "wujg");
            dic.Add("傽", "wujh");
            dic.Add("億", "wujn");
            dic.Add("傹", "wujq");
            dic.Add("倍", "wuk");
            dic.Add("侻", "wukq");
            dic.Add("僧", "wul");
            dic.Add("傍", "wup");
            dic.Add("偙", "wuph");
            dic.Add("佼", "wuq");
            dic.Add("俲", "wuql");
            dic.Add("傚", "wuqt");
            dic.Add("佽", "wuqw");
            dic.Add("僔", "wusf");
            dic.Add("偤", "wusg");
            dic.Add("儭", "wusq");
            dic.Add("偐", "wute");
            dic.Add("仒", "wuu");
            dic.Add("傡", "wuug");
            dic.Add("倿", "wuvg");
            dic.Add("傔", "wuvo");
            dic.Add("偝", "wuxe");
            dic.Add("俤", "wuxt");
            dic.Add("分", "wv");
            dic.Add("弅", "wvaj");
            dic.Add("邠", "wvbh");
            dic.Add("伮", "wvcy");
            dic.Add("颁", "wvd");
            dic.Add("頒", "wvdm");
            dic.Add("佷", "wvey");
            dic.Add("健", "wvf");
            dic.Add("坌", "wvff");
            dic.Add("伜", "wvfh");
            dic.Add("侓", "wvfh");
            dic.Add("鴏", "wvga");
            dic.Add("鵿", "wvga");
            dic.Add("鄡", "wvgb");
            dic.Add("鄥", "wvgb");
            dic.Add("鷌", "wvgc");
            dic.Add("鸌", "wvgc");
            dic.Add("裊", "wvge");
            dic.Add("鶳", "wvgh");
            dic.Add("鵦", "wvgi");
            dic.Add("鸔", "wvgi");
            dic.Add("鴚", "wvgk");
            dic.Add("鴼", "wvgk");
            dic.Add("鳨", "wvgl");
            dic.Add("島", "wvgm");
            dic.Add("鳧", "wvgm");
            dic.Add("鳬", "wvgm");
            dic.Add("鷈", "wvgm");
            dic.Add("瓫", "wvgn");
            dic.Add("鳦", "wvgn");
            dic.Add("鳥", "wvgo");
            dic.Add("鶃", "wvgq");
            dic.Add("梟", "wvgs");
            dic.Add("鵌", "wvgt");
            dic.Add("鵔", "wvgt");
            dic.Add("鷻", "wvgt");
            dic.Add("鸃", "wvgt");
            dic.Add("鴤", "wvgu");
            dic.Add("鴃", "wvgw");
            dic.Add("鴥", "wvgw");
            dic.Add("鶀", "wvgw");
            dic.Add("鴕", "wvgx");
            dic.Add("鵻", "wvgy");
            dic.Add("傁", "wvhc");
            dic.Add("儘", "wvhl");
            dic.Add("蚠", "wvju");
            dic.Add("佋", "wvkg");
            dic.Add("侞", "wvkg");
            dic.Add("兺", "wvkx");
            dic.Add("盆", "wvl");
            dic.Add("儠", "wvln");
            dic.Add("贫", "wvm");
            dic.Add("岔", "wvmj");
            dic.Add("貧", "wvmu");
            dic.Add("仇", "wvn");
            dic.Add("忿", "wvnu");
            dic.Add("炃", "wvou");
            dic.Add("侵", "wvp");
            dic.Add("倪", "wvq");
            dic.Add("伊", "wvt");
            dic.Add("侰", "wvtk");
            dic.Add("攽", "wvty");
            dic.Add("鳻", "wvwo");
            dic.Add("仞", "wvy");
            dic.Add("麄", "wvyx");
            dic.Add("仭", "wvyy");
            dic.Add("从", "ww");
            dic.Add("韱", "wwag");
            dic.Add("耸", "wwb");
            dic.Add("伧", "wwbn");
            dic.Add("倊", "wwcn");
            dic.Add("傟", "wwcn");
            dic.Add("伀", "wwcy");
            dic.Add("佾", "wwe");
            dic.Add("俎", "wweg");
            dic.Add("坐", "wwf");
            dic.Add("侩", "wwfc");
            dic.Add("傺", "wwfi");
            dic.Add("剉", "wwfj");
            dic.Add("倽", "wwfk");
            dic.Add("夎", "wwft");
            dic.Add("丛", "wwg");
            dic.Add("倫", "wwga");
            dic.Add("偸", "wwgb");
            dic.Add("佺", "wwgg");
            dic.Add("俭", "wwgi");
            dic.Add("偷", "wwgj");
            dic.Add("儈", "wwgj");
            dic.Add("佮", "wwgk");
            dic.Add("僜", "wwgu");
            dic.Add("倹", "wwgw");
            dic.Add("儉", "wwgw");
            dic.Add("睂", "wwhh");
            dic.Add("伱", "wwiy");
            dic.Add("价", "wwj");
            dic.Add("谷", "wwk");
            dic.Add("谾", "wwka");
            dic.Add("卻", "wwkb");
            dic.Add("郤", "wwkb");
            dic.Add("谹", "wwkc");
            dic.Add("豀", "wwkd");
            dic.Add("豅", "wwkd");
            dic.Add("豂", "wwke");
            dic.Add("鹆", "wwkg");
            dic.Add("螸", "wwkj");
            dic.Add("谽", "wwkk");
            dic.Add("豄", "wwkm");
            dic.Add("慾", "wwkn");
            dic.Add("鵒", "wwko");
            dic.Add("逧", "wwkp");
            dic.Add("谺", "wwkt");
            dic.Add("谻", "wwkt");
            dic.Add("豃", "wwkt");
            dic.Add("欲", "wwkw");
            dic.Add("谼", "wwkw");
            dic.Add("佡", "wwmh");
            dic.Add("怂", "wwn");
            dic.Add("俆", "wwty");
            dic.Add("仌", "wwu");
            dic.Add("份", "wwv");
            dic.Add("众", "www");
            dic.Add("侳", "wwwf");
            dic.Add("傘", "wwwf");
            dic.Add("俗", "wwwk");
            dic.Add("伦", "wwx");
            dic.Add("仈", "wwy");
            dic.Add("伶", "wwyc");
            dic.Add("倠", "wwyg");
            dic.Add("傖", "wwyk");
            dic.Add("僋", "wwym");
            dic.Add("儁", "wwym");
            dic.Add("仱", "wwyn");
            dic.Add("僬", "wwyo");
            dic.Add("化", "wx");
            dic.Add("仑", "wxb");
            dic.Add("倾", "wxd");
            dic.Add("傾", "wxdm");
            dic.Add("华", "wxf");
            dic.Add("伄", "wxhh");
            dic.Add("佛", "wxj");
            dic.Add("货", "wxm");
            dic.Add("發", "wxmc");
            dic.Add("貨", "wxmu");
            dic.Add("儗", "wxth");
            dic.Add("仳", "wxx");
            dic.Add("偕", "wxxr");
            dic.Add("僟", "wxxt");
            dic.Add("信", "wy");
            dic.Add("儣", "wyaw");
            dic.Add("禽", "wyb");
            dic.Add("令", "wyc");
            dic.Add("翎", "wyc");
            dic.Add("邻", "wycb");
            dic.Add("俼", "wyce");
            dic.Add("鸰", "wycg");
            dic.Add("刢", "wycj");
            dic.Add("领", "wycm");
            dic.Add("領", "wycm");
            dic.Add("瓴", "wycn");
            dic.Add("鴒", "wyco");
            dic.Add("隻", "wycu");
            dic.Add("顀", "wydm");
            dic.Add("依", "wye");
            dic.Add("隽", "wyeb");
            dic.Add("偯", "wyey");
            dic.Add("储", "wyf");
            dic.Add("隼", "wyf");
            dic.Add("詧", "wyf");
            dic.Add("儲", "wyfj");
            dic.Add("鶽", "wyfo");
            dic.Add("傠", "wyfy");
            dic.Add("隹", "wyg");
            dic.Add("住", "wygg");
            dic.Add("僦", "wyi");
            dic.Add("倞", "wyiy");
            dic.Add("侪", "wyj");
            dic.Add("儕", "wyjg");
            dic.Add("售", "wyk");
            dic.Add("儴", "wyke");
            dic.Add("伪", "wyl");
            dic.Add("儃", "wylg");
            dic.Add("伉", "wym");
            dic.Add("傐", "wymk");
            dic.Add("雋", "wymm");
            dic.Add("仿", "wyn");
            dic.Add("颔", "wyn");
            dic.Add("偏", "wyna");
            dic.Add("今", "wynb");
            dic.Add("侌", "wync");
            dic.Add("衾", "wyne");
            dic.Add("酓", "wyng");
            dic.Add("韽", "wynj");
            dic.Add("含", "wynk");
            dic.Add("盦", "wynl");
            dic.Add("贪", "wynm");
            dic.Add("貪", "wynm");
            dic.Add("頷", "wynm");
            dic.Add("念", "wynn");
            dic.Add("傓", "wynn");
            dic.Add("儦", "wyno");
            dic.Add("鳹", "wyno");
            dic.Add("敜", "wynt");
            dic.Add("侫", "wynv");
            dic.Add("侅", "wynw");
            dic.Add("欦", "wynw");
            dic.Add("僱", "wyny");
            dic.Add("雂", "wyny");
            dic.Add("焦", "wyo");
            dic.Add("鹪", "wyog");
            dic.Add("劁", "wyoj");
            dic.Add("顦", "wyom");
            dic.Add("鷦", "wyoo");
            dic.Add("停", "wyp");
            dic.Add("進", "wypd");
            dic.Add("儫", "wype");
            dic.Add("仪", "wyq");
            dic.Add("燞", "wyqo");
            dic.Add("集", "wys");
            dic.Add("侂", "wyta");
            dic.Add("偽", "wyto");
            dic.Add("倣", "wyty");
            dic.Add("亽", "wyu");
            dic.Add("食", "wyv");
            dic.Add("戧", "wyva");
            dic.Add("餸", "wyvd");
            dic.Add("俍", "wyve");
            dic.Add("傭", "wyvh");
            dic.Add("創", "wyvj");
            dic.Add("倉", "wyvk");
            dic.Add("傏", "wyvk");
            dic.Add("鶬", "wyvo");
            dic.Add("飮", "wyvw");
            dic.Add("俯", "wyw");
            dic.Add("雙", "wywc");
            dic.Add("倅", "wywf");
            dic.Add("犨", "wywh");
            dic.Add("雧", "wyws");
            dic.Add("讐", "wywy");
            dic.Add("雔", "wywy");
            dic.Add("雥", "wywy");
            dic.Add("雦", "wywy");
            dic.Add("傗", "wyxl");
            dic.Add("伭", "wyxy");
            dic.Add("雠", "wyy");
            dic.Add("伩", "wyy");
            dic.Add("犫", "wyyh");
            dic.Add("讎", "wyyy");
            dic.Add("经", "x");
            dic.Add("弓", "x");
            dic.Add("红", "xa");
            dic.Add("綫", "xaat");
            dic.Add("縙", "xabg");
            dic.Add("绒", "xad");
            dic.Add("絨", "xadt");
            dic.Add("綨", "xadw");
            dic.Add("繖", "xaet");
            dic.Add("绀", "xaf");
            dic.Add("紺", "xafg");
            dic.Add("缂", "xafh");
            dic.Add("緙", "xafh");
            dic.Add("紅", "xag");
            dic.Add("弫", "xahh");
            dic.Add("弬", "xahh");
            dic.Add("繿", "xahl");
            dic.Add("纜", "xahq");
            dic.Add("縸", "xajd");
            dic.Add("緎", "xakg");
            dic.Add("彄", "xakk");
            dic.Add("緢", "xalg");
            dic.Add("緓", "xamd");
            dic.Add("绬", "xamd");
            dic.Add("彉", "xamw");
            dic.Add("练", "xan");
            dic.Add("弡", "xang");
            dic.Add("绁", "xann");
            dic.Add("紲", "xann");
            dic.Add("弽", "xans");
            dic.Add("緤", "xans");
            dic.Add("繱", "xaqn");
            dic.Add("绕", "xat");
            dic.Add("纄", "xatp");
            dic.Add("弛", "xb");
            dic.Add("緅", "xbcy");
            dic.Add("弭", "xbg");
            dic.Add("弢", "xbhc");
            dic.Add("绌", "xbm");
            dic.Add("絀", "xbmh");
            dic.Add("弪", "xcag");
            dic.Add("纾", "xcb");
            dic.Add("紓", "xcbh");
            dic.Add("繘", "xcbk");
            dic.Add("缀", "xcc");
            dic.Add("綴", "xccc");
            dic.Add("縿", "xcce");
            dic.Add("縔", "xccs");
            dic.Add("绎", "xcf");
            dic.Add("経", "xcfg");
            dic.Add("強", "xcjy");
            dic.Add("绐", "xck");
            dic.Add("紿", "xckg");
            dic.Add("緿", "xckn");
            dic.Add("弝", "xcn");
            dic.Add("紦", "xcn");
            dic.Add("弘", "xcy");
            dic.Add("紁", "xcyy");
            dic.Add("顷", "xd");
            dic.Add("绂", "xdc");
            dic.Add("紘", "xdcy");
            dic.Add("紱", "xdcy");
            dic.Add("纮", "xdcy");
            dic.Add("毋", "xde");
            dic.Add("絠", "xdeg");
            dic.Add("纋", "xdet");
            dic.Add("張", "xdey");
            dic.Add("绔", "xdf");
            dic.Add("缛", "xdff");
            dic.Add("縟", "xdff");
            dic.Add("絝", "xdfn");
            dic.Add("缄", "xdg");
            dic.Add("緘", "xdgt");
            dic.Add("縅", "xdgt");
            dic.Add("縬", "xdht");
            dic.Add("弼", "xdj");
            dic.Add("绯", "xdjd");
            dic.Add("緋", "xdjd");
            dic.Add("緾", "xdjf");
            dic.Add("絔", "xdjg");
            dic.Add("缅", "xdmd");
            dic.Add("緛", "xdmd");
            dic.Add("緬", "xdmd");
            dic.Add("頃", "xdmy");
            dic.Add("紌", "xdnn");
            dic.Add("絾", "xdnt");
            dic.Add("縓", "xdri");
            dic.Add("绮", "xds");
            dic.Add("綺", "xdsk");
            dic.Add("绑", "xdt");
            dic.Add("綁", "xdtb");
            dic.Add("缭", "xdu");
            dic.Add("繚", "xdui");
            dic.Add("縥", "xdwt");
            dic.Add("綊", "xdww");
            dic.Add("紎", "xdy");
            dic.Add("级", "xe");
            dic.Add("綒", "xebg");
            dic.Add("绷", "xee");
            dic.Add("弸", "xeeg");
            dic.Add("綳", "xeeg");
            dic.Add("絼", "xeet");
            dic.Add("缓", "xef");
            dic.Add("緩", "xefc");
            dic.Add("组", "xeg");
            dic.Add("組", "xegg");
            dic.Add("蠡", "xej");
            dic.Add("剶", "xejh");
            dic.Add("劙", "xejj");
            dic.Add("盠", "xelf");
            dic.Add("绶", "xep");
            dic.Add("綬", "xepc");
            dic.Add("綵", "xesy");
            dic.Add("彖", "xeu");
            dic.Add("绥", "xev");
            dic.Add("綏", "xevg");
            dic.Add("縚", "xevg");
            dic.Add("鶨", "xewo");
            dic.Add("縘", "xexd");
            dic.Add("級", "xeyy");
            dic.Add("结", "xf");
            dic.Add("繊", "xfag");
            dic.Add("纎", "xfag");
            dic.Add("纭", "xfc");
            dic.Add("紜", "xfcy");
            dic.Add("紶", "xfcy");
            dic.Add("駂", "xfcy");
            dic.Add("繻", "xfdj");
            dic.Add("繧", "xffc");
            dic.Add("絓", "xffg");
            dic.Add("繞", "xffq");
            dic.Add("疆", "xfg");
            dic.Add("缜", "xfh");
            dic.Add("縝", "xfhw");
            dic.Add("頴", "xfim");
            dic.Add("颕", "xfim");
            dic.Add("絿", "xfiy");
            dic.Add("毌", "xfk");
            dic.Add("結", "xfkg");
            dic.Add("繥", "xfkk");
            dic.Add("缬", "xfkm");
            dic.Add("纈", "xfkm");
            dic.Add("續", "xflm");
            dic.Add("贯", "xfm");
            dic.Add("遦", "xfmp");
            dic.Add("貫", "xfmu");
            dic.Add("续", "xfn");
            dic.Add("纬", "xfnh");
            dic.Add("綕", "xfny");
            dic.Add("綍", "xfpb");
            dic.Add("続", "xfpq");
            dic.Add("鸨", "xfq");
            dic.Add("绪", "xft");
            dic.Add("緒", "xftj");
            dic.Add("緖", "xftj");
            dic.Add("緈", "xfuf");
            dic.Add("盭", "xful");
            dic.Add("繨", "xfup");
            dic.Add("绫", "xfw");
            dic.Add("繬", "xfwk");
            dic.Add("纉", "xfwm");
            dic.Add("鴇", "xfwo");
            dic.Add("綾", "xfwt");
            dic.Add("纣", "xfy");
            dic.Add("紂", "xfy");
            dic.Add("线", "xg");
            dic.Add("纯", "xgb");
            dic.Add("純", "xgbn");
            dic.Add("絰", "xgcf");
            dic.Add("绖", "xgcf");
            dic.Add("緻", "xgct");
            dic.Add("彑", "xgd");
            dic.Add("缚", "xge");
            dic.Add("縛", "xgef");
            dic.Add("綪", "xgeg");
            dic.Add("纡", "xgf");
            dic.Add("弖", "xgf");
            dic.Add("弙", "xgfh");
            dic.Add("紆", "xgfh");
            dic.Add("絚", "xghg");
            dic.Add("剝", "xgij");
            dic.Add("彔", "xgiu");
            dic.Add("紑", "xgiy");
            dic.Add("绠", "xgj");
            dic.Add("縳", "xgjf");
            dic.Add("絙", "xgjg");
            dic.Add("繐", "xgjn");
            dic.Add("綆", "xgjq");
            dic.Add("綀", "xgki");
            dic.Add("缰", "xgl");
            dic.Add("彊", "xglg");
            dic.Add("繮", "xglg");
            dic.Add("練", "xgli");
            dic.Add("弻", "xglx");
            dic.Add("绩", "xgm");
            dic.Add("纚", "xgmx");
            dic.Add("緉", "xgmy");
            dic.Add("績", "xgmy");
            dic.Add("彝", "xgo");
            dic.Add("彜", "xgoa");
            dic.Add("缙", "xgoj");
            dic.Add("縉", "xgoj");
            dic.Add("彙", "xgps");
            dic.Add("母", "xgu");
            dic.Add("毑", "xgub");
            dic.Add("袰", "xgue");
            dic.Add("弳", "xgva");
            dic.Add("經", "xgva");
            dic.Add("緁", "xgvh");
            dic.Add("緀", "xgvv");
            dic.Add("彌", "xgwq");
            dic.Add("瓕", "xgwy");
            dic.Add("彘", "xgx");
            dic.Add("縤", "xgxi");
            dic.Add("引", "xh");
            dic.Add("纑", "xhal");
            dic.Add("紴", "xhcy");
            dic.Add("彏", "xhhc");
            dic.Add("缈", "xhi");
            dic.Add("繉", "xhiq");
            dic.Add("緲", "xhit");
            dic.Add("绰", "xhj");
            dic.Add("綽", "xhjh");
            dic.Add("弔", "xhk");
            dic.Add("盄", "xhlf");
            dic.Add("緽", "xhmy");
            dic.Add("顚", "xhnm");
            dic.Add("鷆", "xhno");
            dic.Add("眞", "xhnw");
            dic.Add("絸", "xhqn");
            dic.Add("紪", "xhxn");
            dic.Add("纱", "xi");
            dic.Add("颍", "xid");
            dic.Add("潁", "xidm");
            dic.Add("绡", "xie");
            dic.Add("弰", "xieg");
            dic.Add("綃", "xieg");
            dic.Add("弾", "xijf");
            dic.Add("绱", "xim");
            dic.Add("緔", "ximk");
            dic.Add("絖", "xiqn");
            dic.Add("絩", "xiqn");
            dic.Add("紗", "xitt");
            dic.Add("糸", "xiu");
            dic.Add("旨", "xj");
            dic.Add("彃", "xjaf");
            dic.Add("縪", "xjaf");
            dic.Add("繓", "xjbc");
            dic.Add("缇", "xjg");
            dic.Add("緹", "xjgh");
            dic.Add("绅", "xjh");
            dic.Add("紳", "xjhh");
            dic.Add("縨", "xjiq");
            dic.Add("刜", "xjjh");
            dic.Add("縄", "xjjn");
            dic.Add("弗", "xjk");
            dic.Add("缦", "xjl");
            dic.Add("縵", "xjlc");
            dic.Add("緼", "xjlg");
            dic.Add("缊", "xjlg");
            dic.Add("费", "xjm");
            dic.Add("鄪", "xjmb");
            dic.Add("費", "xjmu");
            dic.Add("絏", "xjnt");
            dic.Add("艴", "xjq");
            dic.Add("緆", "xjqr");
            dic.Add("綶", "xjsy");
            dic.Add("缆", "xjt");
            dic.Add("鴲", "xjwo");
            dic.Add("绲", "xjx");
            dic.Add("緄", "xjxx");
            dic.Add("强", "xk");
            dic.Add("缉", "xkb");
            dic.Add("緝", "xkbg");
            dic.Add("绢", "xke");
            dic.Add("弲", "xkeg");
            dic.Add("絹", "xkeg");
            dic.Add("縷", "xkgv");
            dic.Add("缋", "xkh");
            dic.Add("紃", "xkh");
            dic.Add("繢", "xkhm");
            dic.Add("缱", "xkhp");
            dic.Add("繾", "xkhp");
            dic.Add("犟", "xkjh");
            dic.Add("勥", "xkjl");
            dic.Add("绳", "xkjn");
            dic.Add("謽", "xkjy");
            dic.Add("缲", "xkk");
            dic.Add("彈", "xkkf");
            dic.Add("繟", "xkkf");
            dic.Add("絽", "xkkg");
            dic.Add("繰", "xkks");
            dic.Add("縜", "xkmy");
            dic.Add("织", "xkw");
            dic.Add("细", "xl");
            dic.Add("孧", "xlbf");
            dic.Add("絪", "xldy");
            dic.Add("緭", "xleg");
            dic.Add("繹", "xlff");
            dic.Add("纆", "xlff");
            dic.Add("細", "xlg");
            dic.Add("缳", "xlge");
            dic.Add("彋", "xlge");
            dic.Add("繯", "xlge");
            dic.Add("綥", "xlgj");
            dic.Add("絗", "xlkg");
            dic.Add("纝", "xlli");
            dic.Add("幼", "xln");
            dic.Add("糼", "xln");
            dic.Add("缌", "xlny");
            dic.Add("緦", "xlny");
            dic.Add("縺", "xlpy");
            dic.Add("綑", "xlsy");
            dic.Add("縕", "xlwl");
            dic.Add("鴢", "xlwo");
            dic.Add("辔", "xlx");
            dic.Add("缧", "xlxi");
            dic.Add("縲", "xlxi");
            dic.Add("轡", "xlxk");
            dic.Add("纙", "xlxy");
            dic.Add("纲", "xm");
            dic.Add("繷", "xmae");
            dic.Add("紻", "xmdy");
            dic.Add("繃", "xmee");
            dic.Add("縎", "xmeg");
            dic.Add("绸", "xmf");
            dic.Add("綢", "xmfk");
            dic.Add("紬", "xmg");
            dic.Add("", "xmg");
            dic.Add("絧", "xmgk");
            dic.Add("繩", "xmgv");
            dic.Add("絅", "xmkg");
            dic.Add("缨", "xmm");
            dic.Add("纓", "xmmv");
            dic.Add("緺", "xmnk");
            dic.Add("綱", "xmum");
            dic.Add("網", "xmun");
            dic.Add("纳", "xmw");
            dic.Add("綗", "xmwk");
            dic.Add("纗", "xmwk");
            dic.Add("納", "xmwy");
            dic.Add("繀", "xmwy");
            dic.Add("纪", "xn");
            dic.Add("缗", "xna");
            dic.Add("緡", "xnaj");
            dic.Add("纽", "xnf");
            dic.Add("紐", "xnfg");
            dic.Add("緪", "xngg");
            dic.Add("縆", "xngg");
            dic.Add("纠", "xnh");
            dic.Add("縀", "xnhc");
            dic.Add("縃", "xnhe");
            dic.Add("糾", "xnhh");
            dic.Add("緯", "xnhh");
            dic.Add("幻", "xnn");
            dic.Add("乣", "xnn");
            dic.Add("糺", "xnn");
            dic.Add("紀", "xnn");
            dic.Add("繏", "xnnw");
            dic.Add("幺", "xnny");
            dic.Add("糹", "xnny");
            dic.Add("缪", "xnw");
            dic.Add("繆", "xnwe");
            dic.Add("继", "xo");
            dic.Add("熲", "xodm");
            dic.Add("颎", "xodm");
            dic.Add("継", "xonn");
            dic.Add("緂", "xooy");
            dic.Add("繗", "xoqh");
            dic.Add("缕", "xov");
            dic.Add("粥", "xox");
            dic.Add("鬻", "xoxh");
            dic.Add("综", "xp");
            dic.Add("綋", "xpdc");
            dic.Add("縖", "xpdk");
            dic.Add("綜", "xpfi");
            dic.Add("綄", "xpfq");
            dic.Add("绽", "xpg");
            dic.Add("縇", "xpgg");
            dic.Add("纻", "xpgg");
            dic.Add("綻", "xpgh");
            dic.Add("繽", "xpgm");
            dic.Add("縯", "xpgw");
            dic.Add("緷", "xplh");
            dic.Add("绾", "xpn");
            dic.Add("綰", "xpnn");
            dic.Add("綩", "xpqb");
            dic.Add("紞", "xpqn");
            dic.Add("缤", "xpr");
            dic.Add("紵", "xpsh");
            dic.Add("縡", "xpuh");
            dic.Add("缩", "xpw");
            dic.Add("縮", "xpwj");
            dic.Add("紽", "xpxn");
            dic.Add("约", "xq");
            dic.Add("纸", "xqa");
            dic.Add("緍", "xqaj");
            dic.Add("紙", "xqan");
            dic.Add("弤", "xqay");
            dic.Add("緵", "xqbt");
            dic.Add("縐", "xqbt");
            dic.Add("绝", "xqc");
            dic.Add("絶", "xqcn");
            dic.Add("絺", "xqdh");
            dic.Add("繎", "xqdo");
            dic.Add("繲", "xqeh");
            dic.Add("弥", "xqi");
            dic.Add("绚", "xqj");
            dic.Add("絢", "xqjg");
            dic.Add("絇", "xqkg");
            dic.Add("絻", "xqkq");
            dic.Add("纔", "xqky");
            dic.Add("綯", "xqrm");
            dic.Add("绹", "xqrm");
            dic.Add("緫", "xqrn");
            dic.Add("绉", "xqv");
            dic.Add("繺", "xqvo");
            dic.Add("弞", "xqwy");
            dic.Add("約", "xqyy");
            dic.Add("绵", "xr");
            dic.Add("弧", "xrc");
            dic.Add("絈", "xrg");
            dic.Add("紤", "xrh");
            dic.Add("絑", "xriy");
            dic.Add("線", "xriy");
            dic.Add("缐", "xriy");
            dic.Add("綿", "xrmh");
            dic.Add("綼", "xrtf");
            dic.Add("紩", "xrwy");
            dic.Add("樂", "xrxs");
            dic.Add("缴", "xry");
            dic.Add("繳", "xryt");
            dic.Add("缥", "xs");
            dic.Add("緸", "xsfg");
            dic.Add("縹", "xsfi");
            dic.Add("絤", "xsg");
            dic.Add("絊", "xsgg");
            dic.Add("綇", "xsgg");
            dic.Add("缃", "xsh");
            dic.Add("糽", "xsh");
            dic.Add("緗", "xshg");
            dic.Add("彁", "xskk");
            dic.Add("綝", "xssy");
            dic.Add("絉", "xsyy");
            dic.Add("张", "xt");
            dic.Add("绛", "xtah");
            dic.Add("絳", "xtah");
            dic.Add("鄊", "xtbb");
            dic.Add("絁", "xtbn");
            dic.Add("颖", "xtd");
            dic.Add("肄", "xtd");
            dic.Add("觺", "xtde");
            dic.Add("絬", "xtdg");
            dic.Add("疑", "xtdh");
            dic.Add("綘", "xtdh");
            dic.Add("繑", "xtdk");
            dic.Add("穎", "xtdm");
            dic.Add("缝", "xtdp");
            dic.Add("縫", "xtdp");
            dic.Add("欵", "xtdw");
            dic.Add("矤", "xtdy");
            dic.Add("乡", "xte");
            dic.Add("绣", "xten");
            dic.Add("綉", "xten");
            dic.Add("纤", "xtf");
            dic.Add("绗", "xtf");
            dic.Add("紝", "xtfg");
            dic.Add("纴", "xtfg");
            dic.Add("絎", "xtfh");
            dic.Add("缵", "xtfm");
            dic.Add("纘", "xtfm");
            dic.Add("綎", "xtfp");
            dic.Add("缍", "xtg");
            dic.Add("綞", "xtgf");
            dic.Add("緟", "xtgf");
            dic.Add("纁", "xtgo");
            dic.Add("绺", "xth");
            dic.Add("縰", "xthh");
            dic.Add("綹", "xthk");
            dic.Add("綖", "xthp");
            dic.Add("緮", "xtjt");
            dic.Add("蚃", "xtju");
            dic.Add("络", "xtk");
            dic.Add("絡", "xtkg");
            dic.Add("總", "xtln");
            dic.Add("繌", "xtlt");
            dic.Add("匕", "xtn");
            dic.Add("纥", "xtnn");
            dic.Add("紇", "xtnn");
            dic.Add("繙", "xtol");
            dic.Add("鄕", "xtrb");
            dic.Add("绦", "xts");
            dic.Add("终", "xtu");
            dic.Add("縦", "xtuh");
            dic.Add("終", "xtuy");
            dic.Add("郷", "xtvb");
            dic.Add("緌", "xtvg");
            dic.Add("飨", "xtw");
            dic.Add("縱", "xtwh");
            dic.Add("鄉", "xtyb");
            dic.Add("饗", "xtye");
            dic.Add("蠁", "xtyj");
            dic.Add("響", "xtyj");
            dic.Add("嚮", "xtyk");
            dic.Add("弱", "xu");
            dic.Add("絣", "xuah");
            dic.Add("織", "xuaj");
            dic.Add("縌", "xubp");
            dic.Add("缮", "xud");
            dic.Add("縒", "xuda");
            dic.Add("绻", "xudb");
            dic.Add("綣", "xudb");
            dic.Add("絴", "xudh");
            dic.Add("繕", "xudk");
            dic.Add("繝", "xueg");
            dic.Add("繸", "xuep");
            dic.Add("彅", "xuev");
            dic.Add("绊", "xuf");
            dic.Add("紏", "xufh");
            dic.Add("絆", "xufh");
            dic.Add("弹", "xuj");
            dic.Add("繶", "xujn");
            dic.Add("縂", "xukn");
            dic.Add("綐", "xukq");
            dic.Add("缯", "xul");
            dic.Add("繒", "xulj");
            dic.Add("缔", "xup");
            dic.Add("締", "xuph");
            dic.Add("縍", "xupy");
            dic.Add("绞", "xuq");
            dic.Add("纐", "xuqm");
            dic.Add("絘", "xuqw");
            dic.Add("絞", "xuqy");
            dic.Add("繜", "xusf");
            dic.Add("緧", "xusg");
            dic.Add("缣", "xuv");
            dic.Add("縑", "xuvo");
            dic.Add("缢", "xuw");
            dic.Add("縊", "xuwl");
            dic.Add("鶸", "xuxo");
            dic.Add("绨", "xuxt");
            dic.Add("綈", "xuxt");
            dic.Add("绿", "xv");
            dic.Add("絕", "xvcn");
            dic.Add("縁", "xvey");
            dic.Add("繣", "xvfg");
            dic.Add("紣", "xvfh");
            dic.Add("彇", "xvfj");
            dic.Add("繡", "xvfj");
            dic.Add("緑", "xviy");
            dic.Add("缫", "xvj");
            dic.Add("繅", "xvjs");
            dic.Add("绍", "xvk");
            dic.Add("弨", "xvkg");
            dic.Add("紹", "xvkg");
            dic.Add("缁", "xvl");
            dic.Add("緇", "xvlg");
            dic.Add("糿", "xvn");
            dic.Add("繍", "xvoj");
            dic.Add("綅", "xvpc");
            dic.Add("匘", "xvtq");
            dic.Add("纫", "xvy");
            dic.Add("綛", "xvyn");
            dic.Add("纨", "xvyy");
            dic.Add("紈", "xvyy");
            dic.Add("紉", "xvyy");
            dic.Add("给", "xw");
            dic.Add("総", "xwcn");
            dic.Add("缎", "xwd");
            dic.Add("緞", "xwdc");
            dic.Add("絥", "xwdy");
            dic.Add("紾", "xwet");
            dic.Add("绘", "xwf");
            dic.Add("絵", "xwfc");
            dic.Add("縩", "xwfi");
            dic.Add("弣", "xwfy");
            dic.Add("紨", "xwfy");
            dic.Add("綸", "xwga");
            dic.Add("絟", "xwgg");
            dic.Add("緰", "xwgj");
            dic.Add("繪", "xwgj");
            dic.Add("給", "xwgk");
            dic.Add("缏", "xwgq");
            dic.Add("緶", "xwgq");
            dic.Add("縧", "xwhs");
            dic.Add("紒", "xwjh");
            dic.Add("緥", "xwks");
            dic.Add("缑", "xwn");
            dic.Add("緱", "xwnd");
            dic.Add("缒", "xwnp");
            dic.Add("縋", "xwnp");
            dic.Add("纀", "xwoy");
            dic.Add("絍", "xwtf");
            dic.Add("纷", "xwv");
            dic.Add("紛", "xwvn");
            dic.Add("纵", "xww");
            dic.Add("纖", "xwwg");
            dic.Add("緃", "xwwh");
            dic.Add("綌", "xwwk");
            dic.Add("绤", "xwwk");
            dic.Add("纶", "xwx");
            dic.Add("维", "xwy");
            dic.Add("紷", "xwyc");
            dic.Add("維", "xwyg");
            dic.Add("紟", "xwyn");
            dic.Add("比", "xx");
            dic.Add("畿", "xxa");
            dic.Add("繈", "xxcj");
            dic.Add("紭", "xxcy");
            dic.Add("幾", "xxdt");
            dic.Add("缘", "xxe");
            dic.Add("緣", "xxey");
            dic.Add("毕", "xxf");
            dic.Add("坒", "xxff");
            dic.Add("丝", "xxg");
            dic.Add("鸶", "xxgg");
            dic.Add("綠", "xxgi");
            dic.Add("斷", "xxgr");
            dic.Add("毙", "xxgx");
            dic.Add("紖", "xxhh");
            dic.Add("纼", "xxhh");
            dic.Add("顈", "xxim");
            dic.Add("鷥", "xxio");
            dic.Add("絲", "xxiy");
            dic.Add("绋", "xxj");
            dic.Add("紼", "xxjh");
            dic.Add("繦", "xxkj");
            dic.Add("幽", "xxm");
            dic.Add("弜", "xxn");
            dic.Add("毖", "xxnt");
            dic.Add("粊", "xxou");
            dic.Add("皆", "xxr");
            dic.Add("勓", "xxrl");
            dic.Add("鶛", "xxro");
            dic.Add("纅", "xxrs");
            dic.Add("枈", "xxsu");
            dic.Add("毞", "xxtn");
            dic.Add("纟", "xxx");
            dic.Add("纰", "xxxn");
            dic.Add("紕", "xxxn");
            dic.Add("繼", "xxxn");
            dic.Add("纞", "xxyn");
            dic.Add("纺", "xy");
            dic.Add("彍", "xyaw");
            dic.Add("纊", "xyaw");
            dic.Add("缡", "xyb");
            dic.Add("縭", "xybc");
            dic.Add("弴", "xybg");
            dic.Add("綧", "xybg");
            dic.Add("统", "xyc");
            dic.Add("統", "xycq");
            dic.Add("絋", "xycy");
            dic.Add("紸", "xygg");
            dic.Add("弶", "xyiy");
            dic.Add("綡", "xyiy");
            dic.Add("缠", "xyj");
            dic.Add("緕", "xyjf");
            dic.Add("纏", "xyjf");
            dic.Add("纒", "xyjf");
            dic.Add("纃", "xyjg");
            dic.Add("縗", "xyke");
            dic.Add("纕", "xyke");
            dic.Add("缞", "xyke");
            dic.Add("繵", "xylg");
            dic.Add("缟", "xym");
            dic.Add("縞", "xymk");
            dic.Add("紡", "xyn");
            dic.Add("编", "xyna");
            dic.Add("編", "xyna");
            dic.Add("綟", "xynd");
            dic.Add("絯", "xynw");
            dic.Add("綂", "xyqn");
            dic.Add("纩", "xyt");
            dic.Add("絒", "xyth");
            dic.Add("縼", "xyth");
            dic.Add("綷", "xywf");
            dic.Add("鶭", "xywo");
            dic.Add("弦", "xyx");
            dic.Add("孿", "xyxb");
            dic.Add("奱", "xyxd");
            dic.Add("卛", "xyxf");
            dic.Add("繂", "xyxf");
            dic.Add("矕", "xyxh");
            dic.Add("縴", "xyxh");
            dic.Add("灓", "xyxi");
            dic.Add("曫", "xyxj");
            dic.Add("蠻", "xyxj");
            dic.Add("巒", "xyxm");
            dic.Add("戀", "xyxn");
            dic.Add("鸞", "xyxo");
            dic.Add("鑾", "xyxq");
            dic.Add("攣", "xyxr");
            dic.Add("欒", "xyxs");
            dic.Add("變", "xyxt");
            dic.Add("婱", "xyxv");
            dic.Add("孌", "xyxv");
            dic.Add("臠", "xyxw");
            dic.Add("彎", "xyxx");
            dic.Add("絃", "xyxy");
            dic.Add("", "xyxy");
            dic.Add("纹", "xyy");
            dic.Add("紋", "xyy");
            dic.Add("主", "y");
            dic.Add("言", "y");
            dic.Add("度", "ya");
            dic.Add("试", "yaa");
            dic.Add("試", "yaag");
            dic.Add("诫", "yaah");
            dic.Add("誡", "yaah");
            dic.Add("諓", "yaat");
            dic.Add("剫", "yacj");
            dic.Add("诺", "yad");
            dic.Add("諾", "yadk");
            dic.Add("谌", "yadn");
            dic.Add("諶", "yadn");
            dic.Add("廝", "yadr");
            dic.Add("諆", "yadw");
            dic.Add("谋", "yaf");
            dic.Add("讛", "yafc");
            dic.Add("詌", "yafg");
            dic.Add("諽", "yafh");
            dic.Add("謀", "yafs");
            dic.Add("讧", "yag");
            dic.Add("訌", "yag");
            dic.Add("譁", "yagf");
            dic.Add("诓", "yagg");
            dic.Add("誆", "yagg");
            dic.Add("讶", "yah");
            dic.Add("衺", "yahe");
            dic.Add("庌", "yaht");
            dic.Add("訝", "yaht");
            dic.Add("谟", "yaj");
            dic.Add("庴", "yajd");
            dic.Add("謨", "yajd");
            dic.Add("諎", "yajg");
            dic.Add("譪", "yajn");
            dic.Add("谨", "yak");
            dic.Add("廑", "yak");
            dic.Add("謹", "yakg");
            dic.Add("謳", "yakk");
            dic.Add("讙", "yaky");
            dic.Add("庿", "yald");
            dic.Add("席", "yam");
            dic.Add("鄺", "yamb");
            dic.Add("懬", "yamn");
            dic.Add("廣", "yamw");
            dic.Add("谍", "yan");
            dic.Add("讵", "yang");
            dic.Add("詎", "yang");
            dic.Add("詍", "yann");
            dic.Add("諜", "yans");
            dic.Add("庹", "yany");
            dic.Add("庶", "yao");
            dic.Add("鹧", "yaog");
            dic.Add("鷓", "yaoo");
            dic.Add("遮", "yaop");
            dic.Add("讴", "yaq");
            dic.Add("廗", "yaqh");
            dic.Add("谮", "yaqj");
            dic.Add("譖", "yaqj");
            dic.Add("讌", "yauo");
            dic.Add("", "yauo");
            dic.Add("诬", "yaw");
            dic.Add("護", "yawc");
            dic.Add("庻", "yaww");
            dic.Add("誣", "yaww");
            dic.Add("誮", "yawx");
            dic.Add("谎", "yay");
            dic.Add("謊", "yayq");
            dic.Add("离", "yb");
            dic.Add("郭", "ybb");
            dic.Add("讘", "ybbb");
            dic.Add("诹", "ybc");
            dic.Add("諏", "ybcy");
            dic.Add("讔", "yben");
            dic.Add("享", "ybf");
            dic.Add("斈", "ybf");
            dic.Add("斊", "ybf");
            dic.Add("廰", "ybfn");
            dic.Add("誀", "ybg");
            dic.Add("廳", "ybgn");
            dic.Add("邝", "ybh");
            dic.Add("邡", "ybh");
            dic.Add("詜", "ybhc");
            dic.Add("亨", "ybj");
            dic.Add("嚲", "ybkf");
            dic.Add("诎", "ybmh");
            dic.Add("詘", "ybmh");
            dic.Add("離", "ybmy");
            dic.Add("訑", "ybn");
            dic.Add("烹", "ybo");
            dic.Add("鹑", "ybq");
            dic.Add("敦", "ybt");
            dic.Add("墪", "ybtf");
            dic.Add("憝", "ybtn");
            dic.Add("鐜", "ybtq");
            dic.Add("撉", "ybtr");
            dic.Add("亸", "ybuf");
            dic.Add("熟", "ybv");
            dic.Add("塾", "ybvf");
            dic.Add("孰", "ybvy");
            dic.Add("廕", "ybwc");
            dic.Add("鶉", "ybwo");
            dic.Add("充", "yc");
            dic.Add("弃", "yca");
            dic.Add("棄", "ycas");
            dic.Add("序", "ycb");
            dic.Add("袤", "ycbe");
            dic.Add("谲", "ycbk");
            dic.Add("譎", "ycbk");
            dic.Add("諁", "yccc");
            dic.Add("謲", "ycce");
            dic.Add("育", "yce");
            dic.Add("诵", "yceh");
            dic.Add("誦", "yceh");
            dic.Add("逳", "ycep");
            dic.Add("裛", "yceu");
            dic.Add("褭", "yceu");
            dic.Add("译", "ycf");
            dic.Add("広", "yci");
            dic.Add("旀", "yciy");
            dic.Add("诒", "yck");
            dic.Add("袬", "ycke");
            dic.Add("詒", "yckg");
            dic.Add("夣", "yclq");
            dic.Add("诶", "yct");
            dic.Add("誒", "yctd");
            dic.Add("誜", "ycwt");
            dic.Add("訍", "ycyy");
            dic.Add("庆", "yd");
            dic.Add("詙", "ydcy");
            dic.Add("詴", "ydeg");
            dic.Add("顏", "ydem");
            dic.Add("彥", "yder");
            dic.Add("誫", "ydfe");
            dic.Add("譇", "ydfj");
            dic.Add("誇", "ydfn");
            dic.Add("诂", "ydg");
            dic.Add("詁", "ydg");
            dic.Add("諴", "ydgt");
            dic.Add("緳", "ydhi");
            dic.Add("譿", "ydhn");
            dic.Add("廈", "ydht");
            dic.Add("诔", "ydiy");
            dic.Add("誄", "ydiy");
            dic.Add("诽", "ydj");
            dic.Add("誹", "ydjd");
            dic.Add("裵", "ydje");
            dic.Add("韲", "ydjg");
            dic.Add("齑", "ydjj");
            dic.Add("庵", "ydjn");
            dic.Add("斋", "ydm");
            dic.Add("诚", "ydn");
            dic.Add("庬", "ydne");
            dic.Add("訧", "ydnn");
            dic.Add("誠", "ydnt");
            dic.Add("诙", "ydo");
            dic.Add("詼", "ydoy");
            dic.Add("謜", "ydri");
            dic.Add("旑", "ydsk");
            dic.Add("诪", "ydtf");
            dic.Add("產", "ydtg");
            dic.Add("讈", "ydth");
            dic.Add("庞", "ydx");
            dic.Add("衣", "ye");
            dic.Add("彣", "yee");
            dic.Add("谖", "yef");
            dic.Add("諼", "yefc");
            dic.Add("诅", "yeg");
            dic.Add("詛", "yegg");
            dic.Add("裔", "yem");
            dic.Add("廫", "yene");
            dic.Add("谣", "yer");
            dic.Add("謡", "yerm");
            dic.Add("譌", "yeto");
            dic.Add("哀", "yeu");
            dic.Add("謟", "yevg");
            dic.Add("謑", "yexd");
            dic.Add("诼", "yey");
            dic.Add("訯", "yeyy");
            dic.Add("諑", "yeyy");
            dic.Add("计", "yf");
            dic.Add("庋", "yfc");
            dic.Add("廅", "yfcl");
            dic.Add("詓", "yfcy");
            dic.Add("庄", "yfd");
            dic.Add("譳", "yfdj");
            dic.Add("诗", "yff");
            dic.Add("诖", "yffg");
            dic.Add("詿", "yffg");
            dic.Add("庤", "yffi");
            dic.Add("謣", "yffn");
            dic.Add("譊", "yffq");
            dic.Add("詩", "yffy");
            dic.Add("讦", "yfh");
            dic.Add("計", "yfh");
            dic.Add("訐", "yfh");
            dic.Add("謓", "yfhw");
            dic.Add("讲", "yfj");
            dic.Add("廟", "yfje");
            dic.Add("謿", "yfje");
            dic.Add("講", "yfjf");
            dic.Add("诘", "yfk");
            dic.Add("廚", "yfkf");
            dic.Add("詰", "yfkg");
            dic.Add("譆", "yfkk");
            dic.Add("讀", "yflm");
            dic.Add("讟", "yfly");
            dic.Add("谳", "yfm");
            dic.Add("諵", "yfmf");
            dic.Add("读", "yfn");
            dic.Add("譸", "yfnf");
            dic.Add("讳", "yfnh");
            dic.Add("誌", "yfny");
            dic.Add("誖", "yfpb");
            dic.Add("読", "yfpq");
            dic.Add("庑", "yfq");
            dic.Add("诸", "yft");
            dic.Add("庨", "yftb");
            dic.Add("誟", "yftb");
            dic.Add("詽", "yftf");
            dic.Add("諸", "yftj");
            dic.Add("褻", "yfwe");
            dic.Add("譛", "yfwj");
            dic.Add("廧", "yfwk");
            dic.Add("讃", "yfwm");
            dic.Add("庱", "yfwt");
            dic.Add("讨", "yfy");
            dic.Add("対", "yfy");
            dic.Add("討", "yfy");
            dic.Add("庒", "yfyi");
            dic.Add("斌", "yga");
            dic.Add("訮", "ygah");
            dic.Add("贇", "ygam");
            dic.Add("赟", "ygam");
            dic.Add("庉", "ygbn");
            dic.Add("訰", "ygbn");
            dic.Add("庢", "ygcf");
            dic.Add("誈", "ygcf");
            dic.Add("请", "yge");
            dic.Add("請", "ygeg");
            dic.Add("庯", "ygey");
            dic.Add("誧", "ygey");
            dic.Add("諘", "ygey");
            dic.Add("訏", "ygfh");
            dic.Add("证", "ygh");
            dic.Add("証", "yghg");
            dic.Add("諌", "ygji");
            dic.Add("譓", "ygjn");
            dic.Add("语", "ygk");
            dic.Add("語", "ygkg");
            dic.Add("誎", "ygki");
            dic.Add("讍", "ygkk");
            dic.Add("諨", "ygkl");
            dic.Add("谏", "ygl");
            dic.Add("諫", "ygli");
            dic.Add("殶", "ygmc");
            dic.Add("廲", "ygmx");
            dic.Add("謮", "ygmy");
            dic.Add("瓬", "ygnn");
            dic.Add("迬", "ygpd");
            dic.Add("廒", "ygq");
            dic.Add("謸", "ygqt");
            dic.Add("评", "ygu");
            dic.Add("評", "yguh");
            dic.Add("誙", "ygva");
            dic.Add("誱", "ygvh");
            dic.Add("让", "yh");
            dic.Add("谑", "yha");
            dic.Add("讞", "yhad");
            dic.Add("謔", "yhag");
            dic.Add("謯", "yhag");
            dic.Add("譃", "yhag");
            dic.Add("謼", "yhah");
            dic.Add("廬", "yhal");
            dic.Add("諕", "yham");
            dic.Add("詖", "yhcy");
            dic.Add("诐", "yhcy");
            dic.Add("訨", "yhg");
            dic.Add("諔", "yhic");
            dic.Add("店", "yhk");
            dic.Add("詀", "yhkg");
            dic.Add("斍", "yhqb");
            dic.Add("誢", "yhqn");
            dic.Add("卞", "yhu");
            dic.Add("訿", "yhxn");
            dic.Add("庛", "yhxv");
            dic.Add("讣", "yhy");
            dic.Add("訃", "yhy");
            dic.Add("就", "yi");
            dic.Add("应", "yid");
            dic.Add("鹫", "yidg");
            dic.Add("蹵", "yidh");
            dic.Add("鷲", "yido");
            dic.Add("诮", "yie");
            dic.Add("誚", "yieg");
            dic.Add("氷", "yii");
            dic.Add("誻", "yijg");
            dic.Add("剠", "yijh");
            dic.Add("勍", "yiln");
            dic.Add("廠", "yimt");
            dic.Add("谠", "yip");
            dic.Add("譡", "yipl");
            dic.Add("讜", "yipo");
            dic.Add("誂", "yiqn");
            dic.Add("庣", "yiqv");
            dic.Add("訬", "yitt");
            dic.Add("京", "yiu");
            dic.Add("鶁", "yiwo");
            dic.Add("刘", "yj");
            dic.Add("齏", "yjdg");
            dic.Add("廛", "yjf");
            dic.Add("斉", "yjf");
            dic.Add("齊", "yjf");
            dic.Add("亯", "yjf");
            dic.Add("鄽", "yjfb");
            dic.Add("裏", "yjfe");
            dic.Add("裏", "yjfe");
            dic.Add("斎", "yjfi");
            dic.Add("剤", "yjfj");
            dic.Add("髙", "yjfk");
            dic.Add("詚", "yjgg");
            dic.Add("諟", "yjgh");
            dic.Add("諹", "yjgr");
            dic.Add("訷", "yjhh");
            dic.Add("齋", "yjiu");
            dic.Add("亰", "yjiu");
            dic.Add("齐", "yjj");
            dic.Add("亣", "yjj");
            dic.Add("誯", "yjjg");
            dic.Add("剂", "yjjh");
            dic.Add("劑", "yjjh");
            dic.Add("螡", "yjju");
            dic.Add("螤", "yjjw");
            dic.Add("谩", "yjl");
            dic.Add("謾", "yjlc");
            dic.Add("齍", "yjlf");
            dic.Add("齎", "yjmu");
            dic.Add("庽", "yjmy");
            dic.Add("恴", "yjnu");
            dic.Add("齌", "yjou");
            dic.Add("谒", "yjq");
            dic.Add("謁", "yjqn");
            dic.Add("课", "yjs");
            dic.Add("裹", "yjse");
            dic.Add("課", "yjsy");
            dic.Add("謃", "yjtg");
            dic.Add("蚉", "yju");
            dic.Add("斔", "yjvw");
            dic.Add("训", "yk");
            dic.Add("諿", "ykbg");
            dic.Add("吝", "ykf");
            dic.Add("误", "ykg");
            dic.Add("誤", "ykgd");
            dic.Add("衰", "ykge");
            dic.Add("廔", "ykgv");
            dic.Add("謱", "ykgv");
            dic.Add("訓", "ykh");
            dic.Add("衷", "ykhe");
            dic.Add("訲", "ykhh");
            dic.Add("谴", "ykhp");
            dic.Add("譴", "ykhp");
            dic.Add("讉", "ykhp");
            dic.Add("襄", "ykk");
            dic.Add("譂", "ykkf");
            dic.Add("勷", "ykkl");
            dic.Add("谔", "ykkn");
            dic.Add("諤", "ykkn");
            dic.Add("譟", "ykks");
            dic.Add("讝", "ykkt");
            dic.Add("瓤", "ykky");
            dic.Add("詋", "ykqn");
            dic.Add("识", "ykw");
            dic.Add("廙", "ylaw");
            dic.Add("畆", "ylcy");
            dic.Add("谓", "yle");
            dic.Add("謂", "yleg");
            dic.Add("亩", "ylf");
            dic.Add("畗", "ylf");
            dic.Add("譯", "ylff");
            dic.Add("訵", "ylg");
            dic.Add("譞", "ylge");
            dic.Add("褱", "ylie");
            dic.Add("库", "ylk");
            dic.Add("庘", "ylk");
            dic.Add("庫", "ylk");
            dic.Add("皽", "ylkc");
            dic.Add("亶", "ylkg");
            dic.Add("鹯", "ylkg");
            dic.Add("禀", "ylki");
            dic.Add("勯", "ylkl");
            dic.Add("颤", "ylkm");
            dic.Add("顫", "ylkm");
            dic.Add("氈", "ylkn");
            dic.Add("鸇", "ylko");
            dic.Add("邅", "ylkp");
            dic.Add("稟", "ylkt");
            dic.Add("廤", "ylkx");
            dic.Add("讄", "ylll");
            dic.Add("諰", "ylny");
            dic.Add("謰", "ylpy");
            dic.Add("畝", "ylqy");
            dic.Add("谡", "ylw");
            dic.Add("謖", "ylwt");
            dic.Add("畒", "ylwy");
            dic.Add("高", "ym");
            dic.Add("譨", "ymae");
            dic.Add("亢", "ymb");
            dic.Add("邟", "ymbh");
            dic.Add("设", "ymc");
            dic.Add("設", "ymcy");
            dic.Add("庙", "ymd");
            dic.Add("諯", "ymdj");
            dic.Add("颃", "ymdm");
            dic.Add("頏", "ymdm");
            dic.Add("詇", "ymdy");
            dic.Add("调", "ymf");
            dic.Add("調", "ymfk");
            dic.Add("詷", "ymgk");
            dic.Add("譝", "ymgv");
            dic.Add("讪", "ymh");
            dic.Add("訕", "ymh");
            dic.Add("市", "ymhj");
            dic.Add("廁", "ymjk");
            dic.Add("髜", "ymka");
            dic.Add("鄗", "ymkb");
            dic.Add("敲", "ymkc");
            dic.Add("毃", "ymkc");
            dic.Add("詗", "ymkg");
            dic.Add("诇", "ymkg");
            dic.Add("髝", "ymkl");
            dic.Add("髚", "ymkm");
            dic.Add("鶮", "ymko");
            dic.Add("槀", "ymks");
            dic.Add("髞", "ymks");
            dic.Add("稾", "ymkt");
            dic.Add("髛", "ymkv");
            dic.Add("歊", "ymkw");
            dic.Add("劥", "ymln");
            dic.Add("廮", "ymmv");
            dic.Add("讥", "ymn");
            dic.Add("諣", "ymnk");
            dic.Add("迒", "ympv");
            dic.Add("讽", "ymq");
            dic.Add("諷", "ymtj");
            dic.Add("誷", "ymun");
            dic.Add("讷", "ymw");
            dic.Add("讗", "ymwk");
            dic.Add("訥", "ymwy");
            dic.Add("訉", "ymyy");
            dic.Add("记", "yn");
            dic.Add("肈", "ynah");
            dic.Add("啔", "ynak");
            dic.Add("邙", "ynb");
            dic.Add("誳", "ynbm");
            dic.Add("譀", "ynbt");
            dic.Add("戾", "ynd");
            dic.Add("扉", "yndd");
            dic.Add("戻", "yndi");
            dic.Add("户", "yne");
            dic.Add("肩", "yned");
            dic.Add("肓", "ynef");
            dic.Add("望", "yneg");
            dic.Add("顅", "ynem");
            dic.Add("鵳", "yneo");
            dic.Add("讯", "ynf");
            dic.Add("訊", "ynfh");
            dic.Add("廜", "ynfj");
            dic.Add("诩", "yng");
            dic.Add("詡", "yng");
            dic.Add("词", "yngk");
            dic.Add("詞", "yngk");
            dic.Add("盲", "ynh");
            dic.Add("諝", "ynhe");
            dic.Add("谞", "ynhe");
            dic.Add("訆", "ynhh");
            dic.Add("諱", "ynhh");
            dic.Add("扂", "ynhk");
            dic.Add("永", "yni");
            dic.Add("応", "yni");
            dic.Add("昶", "ynij");
            dic.Add("鹿", "ynj");
            dic.Add("鄜", "ynjb");
            dic.Add("麛", "ynjb");
            dic.Add("麚", "ynjc");
            dic.Add("麌", "ynjd");
            dic.Add("朚", "ynje");
            dic.Add("麎", "ynje");
            dic.Add("麝", "ynjf");
            dic.Add("塵", "ynjf");
            dic.Add("麡", "ynjf");
            dic.Add("麈", "ynjg");
            dic.Add("麆", "ynjg");
            dic.Add("麠", "ynjg");
            dic.Add("麟", "ynjh");
            dic.Add("麖", "ynji");
            dic.Add("蝱", "ynjj");
            dic.Add("麘", "ynjj");
            dic.Add("麞", "ynjj");
            dic.Add("麏", "ynjk");
            dic.Add("麐", "ynjk");
            dic.Add("麔", "ynjk");
            dic.Add("麢", "ynjk");
            dic.Add("麂", "ynjm");
            dic.Add("麅", "ynjn");
            dic.Add("麋", "ynjo");
            dic.Add("廌", "ynjo");
            dic.Add("麃", "ynjo");
            dic.Add("鏖", "ynjq");
            dic.Add("麍", "ynjq");
            dic.Add("麑", "ynjq");
            dic.Add("麜", "ynjs");
            dic.Add("麇", "ynjt");
            dic.Add("慶", "ynjt");
            dic.Add("麕", "ynjt");
            dic.Add("麙", "ynjt");
            dic.Add("麣", "ynjt");
            dic.Add("麒", "ynjw");
            dic.Add("麀", "ynjx");
            dic.Add("麤", "ynjx");
            dic.Add("启", "ynk");
            dic.Add("羸", "ynk");
            dic.Add("嬴", "ynk");
            dic.Add("扈", "ynkc");
            dic.Add("吂", "ynkf");
            dic.Add("啟", "ynkt");
            dic.Add("廦", "ynku");
            dic.Add("赢", "ynky");
            dic.Add("蠃", "ynky");
            dic.Add("臝", "ynky");
            dic.Add("贏", "ynky");
            dic.Add("驘", "ynky");
            dic.Add("鸁", "ynky");
            dic.Add("遍", "ynm");
            dic.Add("扁", "ynma");
            dic.Add("騗", "ynmc");
            dic.Add("帍", "ynmh");
            dic.Add("扃", "ynmk");
            dic.Add("翩", "ynmn");
            dic.Add("甂", "ynmn");
            dic.Add("鶣", "ynmo");
            dic.Add("記", "ynn");
            dic.Add("氓", "ynna");
            dic.Add("扇", "ynnd");
            dic.Add("戺", "ynnn");
            dic.Add("焈", "ynno");
            dic.Add("忘", "ynnu");
            dic.Add("戹", "ynnv");
            dic.Add("譔", "ynnw");
            dic.Add("誋", "ynny");
            dic.Add("扊", "ynoo");
            dic.Add("巟", "ynqb");
            dic.Add("扅", "ynqq");
            dic.Add("謵", "ynrg");
            dic.Add("杗", "ynsu");
            dic.Add("刻", "ynt");
            dic.Add("谧", "ynt");
            dic.Add("郂", "yntb");
            dic.Add("肇", "ynth");
            dic.Add("綮", "ynti");
            dic.Add("晵", "yntj");
            dic.Add("啓", "yntk");
            dic.Add("扄", "yntk");
            dic.Add("劾", "yntl");
            dic.Add("衁", "yntl");
            dic.Add("謐", "yntl");
            dic.Add("颏", "yntm");
            dic.Add("賌", "yntm");
            dic.Add("頦", "yntm");
            dic.Add("棨", "ynts");
            dic.Add("亥", "yntw");
            dic.Add("欬", "yntw");
            dic.Add("废", "ynty");
            dic.Add("戽", "ynu");
            dic.Add("忞", "ynu");
            dic.Add("悥", "ynu");
            dic.Add("謘", "ynuh");
            dic.Add("亡", "ynv");
            dic.Add("妄", "ynvf");
            dic.Add("肁", "ynvh");
            dic.Add("廖", "ynw");
            dic.Add("诀", "ynw");
            dic.Add("谬", "ynwe");
            dic.Add("謬", "ynwe");
            dic.Add("顧", "ynwm");
            dic.Add("鳸", "ynwo");
            dic.Add("雇", "ynwy");
            dic.Add("訣", "ynwy");
            dic.Add("房", "yny");
            dic.Add("訫", "yny");
            dic.Add("扆", "ynye");
            dic.Add("訳", "ynyy");
            dic.Add("变", "yo");
            dic.Add("弈", "yoa");
            dic.Add("孪", "yob");
            dic.Add("奕", "yod");
            dic.Add("譵", "yogf");
            dic.Add("蛮", "yoj");
            dic.Add("峦", "yom");
            dic.Add("帟", "yomh");
            dic.Add("脔", "yomw");
            dic.Add("恋", "yon");
            dic.Add("谈", "yoo");
            dic.Add("談", "yooy");
            dic.Add("迹", "yop");
            dic.Add("谜", "yopy");
            dic.Add("謎", "yopy");
            dic.Add("鸾", "yoq");
            dic.Add("銮", "yoqf");
            dic.Add("挛", "yor");
            dic.Add("栾", "yos");
            dic.Add("変", "yotu");
            dic.Add("亦", "you");
            dic.Add("娈", "yov");
            dic.Add("鵉", "yowo");
            dic.Add("弯", "yox");
            dic.Add("詸", "yoy");
            dic.Add("亪", "yoyu");
            dic.Add("這", "ypd");
            dic.Add("谊", "ype");
            dic.Add("誼", "ypeg");
            dic.Add("豪", "ypeu");
            dic.Add("誴", "ypfi");
            dic.Add("亴", "ypfv");
            dic.Add("諠", "ypgg");
            dic.Add("諚", "ypgh");
            dic.Add("谉", "ypjh");
            dic.Add("膏", "ypk");
            dic.Add("诨", "ypl");
            dic.Add("諢", "yplh");
            dic.Add("亮", "ypm");
            dic.Add("廀", "ypoc");
            dic.Add("訦", "ypqn");
            dic.Add("亭", "yps");
            dic.Add("詝", "ypsh");
            dic.Add("毫", "ypt");
            dic.Add("亳", "ypt");
            dic.Add("诧", "ypta");
            dic.Add("詫", "ypta");
            dic.Add("讅", "yptl");
            dic.Add("稁", "yptu");
            dic.Add("詑", "ypxn");
            dic.Add("义", "yq");
            dic.Add("底", "yqa");
            dic.Add("诋", "yqa");
            dic.Add("諙", "yqaj");
            dic.Add("椉", "yqas");
            dic.Add("謋", "yqas");
            dic.Add("詆", "yqay");
            dic.Add("訩", "yqbh");
            dic.Add("讻", "yqbh");
            dic.Add("謅", "yqbt");
            dic.Add("诡", "yqd");
            dic.Add("詭", "yqdb");
            dic.Add("誵", "yqde");
            dic.Add("谵", "yqdy");
            dic.Add("譫", "yqdy");
            dic.Add("廨", "yqe");
            dic.Add("裦", "yqge");
            dic.Add("褎", "yqge");
            dic.Add("褏", "yqge");
            dic.Add("襃", "yqge");
            dic.Add("询", "yqj");
            dic.Add("詢", "yqjg");
            dic.Add("谗", "yqk");
            dic.Add("訽", "yqkg");
            dic.Add("詺", "yqkg");
            dic.Add("讒", "yqky");
            dic.Add("讂", "yqmt");
            dic.Add("庖", "yqn");
            dic.Add("袌", "yqne");
            dic.Add("廯", "yqod");
            dic.Add("諊", "yqoy");
            dic.Add("詾", "yqqb");
            dic.Add("袲", "yqqe");
            dic.Add("廞", "yqqw");
            dic.Add("訤", "yqqy");
            dic.Add("誃", "yqqy");
            dic.Add("謠", "yqrm");
            dic.Add("诳", "yqt");
            dic.Add("誑", "yqtg");
            dic.Add("谄", "yqv");
            dic.Add("诌", "yqvg");
            dic.Add("諂", "yqvg");
            dic.Add("诤", "yqvh");
            dic.Add("諍", "yqvh");
            dic.Add("廇", "yqyl");
            dic.Add("訋", "yqyy");
            dic.Add("诉", "yr");
            dic.Add("庪", "yrfc");
            dic.Add("诟", "yrg");
            dic.Add("諻", "yrgg");
            dic.Add("詬", "yrgk");
            dic.Add("訢", "yrh");
            dic.Add("", "yrh");
            dic.Add("謕", "yrhm");
            dic.Add("诛", "yri");
            dic.Add("誅", "yriy");
            dic.Add("庍", "yrk");
            dic.Add("廡", "yrlo");
            dic.Add("譕", "yrlo");
            dic.Add("廆", "yrqc");
            dic.Add("謉", "yrqc");
            dic.Add("褢", "yrqe");
            dic.Add("庳", "yrt");
            dic.Add("諀", "yrtf");
            dic.Add("螷", "yrtj");
            dic.Add("蠯", "yrtj");
            dic.Add("亵", "yrv");
            dic.Add("袠", "yrwe");
            dic.Add("詄", "yrwy");
            dic.Add("廏", "yrxc");
            dic.Add("廐", "yrxq");
            dic.Add("譤", "yryt");
            dic.Add("訴", "yryy");
            dic.Add("订", "ys");
            dic.Add("諲", "ysfg");
            dic.Add("謤", "ysfi");
            dic.Add("庮", "ysgd");
            dic.Add("訂", "ysh");
            dic.Add("廂", "yshd");
            dic.Add("床", "ysi");
            dic.Add("谭", "ysj");
            dic.Add("譚", "ysjh");
            dic.Add("诃", "ysk");
            dic.Add("庁", "ysk");
            dic.Add("訶", "yskg");
            dic.Add("謌", "yskk");
            dic.Add("麻", "yss");
            dic.Add("靡", "yss");
            dic.Add("麽", "yss");
            dic.Add("魔", "yssc");
            dic.Add("黀", "yssc");
            dic.Add("磨", "yssd");
            dic.Add("塺", "yssf");
            dic.Add("犘", "yssh");
            dic.Add("縻", "yssi");
            dic.Add("劘", "yssj");
            dic.Add("黁", "yssj");
            dic.Add("麿", "yssk");
            dic.Add("黂", "yssm");
            dic.Add("麾", "yssn");
            dic.Add("糜", "ysso");
            dic.Add("爢", "ysso");
            dic.Add("摩", "yssr");
            dic.Add("穈", "ysst");
            dic.Add("麼", "yssx");
            dic.Add("諃", "yssy");
            dic.Add("庲", "ysww");
            dic.Add("誺", "ysww");
            dic.Add("訹", "ysyy");
            dic.Add("放", "yt");
            dic.Add("旗", "yta");
            dic.Add("託", "ytan");
            dic.Add("讬", "ytan");
            dic.Add("施", "ytb");
            dic.Add("斿", "ytbg");
            dic.Add("遊", "ytbp");
            dic.Add("庅", "ytci");
            dic.Add("话", "ytd");
            dic.Add("話", "ytdg");
            dic.Add("旖", "ytdk");
            dic.Add("譑", "ytdk");
            dic.Add("訞", "ytdy");
            dic.Add("诱", "yte");
            dic.Add("膂", "ytee");
            dic.Add("誘", "yten");
            dic.Add("膐", "ytew");
            dic.Add("旅", "ytey");
            dic.Add("许", "ytf");
            dic.Add("許", "ytfh");
            dic.Add("诰", "ytfk");
            dic.Add("誥", "ytfk");
            dic.Add("讚", "ytfm");
            dic.Add("庭", "ytfp");
            dic.Add("誔", "ytfp");
            dic.Add("诜", "ytfq");
            dic.Add("詵", "ytfq");
            dic.Add("旆", "ytg");
            dic.Add("諈", "ytgf");
            dic.Add("諥", "ytgf");
            dic.Add("廭", "ytgm");
            dic.Add("旊", "ytgn");
            dic.Add("诈", "yth");
            dic.Add("旇", "ythc");
            dic.Add("詐", "ythf");
            dic.Add("詯", "ythg");
            dic.Add("诞", "ythp");
            dic.Add("誕", "ythp");
            dic.Add("旓", "ytie");
            dic.Add("旐", "ytiq");
            dic.Add("誗", "ytjh");
            dic.Add("詻", "ytkg");
            dic.Add("謥", "ytln");
            dic.Add("谢", "ytm");
            dic.Add("謝", "ytmf");
            dic.Add("斾", "ytmh");
            dic.Add("斻", "ytmn");
            dic.Add("旃", "ytmy");
            dic.Add("旋", "ytn");
            dic.Add("讫", "ytnn");
            dic.Add("訖", "ytnn");
            dic.Add("為", "ytno");
            dic.Add("旎", "ytnx");
            dic.Add("旙", "ytol");
            dic.Add("譒", "ytol");
            dic.Add("謻", "ytqq");
            dic.Add("旂", "ytrh");
            dic.Add("誐", "ytrt");
            dic.Add("旚", "ytsi");
            dic.Add("族", "ytt");
            dic.Add("旌", "yttg");
            dic.Add("旛", "yttl");
            dic.Add("旄", "yttn");
            dic.Add("鷟", "ytto");
            dic.Add("庝", "ytui");
            dic.Add("旞", "ytup");
            dic.Add("诿", "ytv");
            dic.Add("諉", "ytvg");
            dic.Add("帰", "ytvh");
            dic.Add("旟", "ytvw");
            dic.Add("旍", "ytwc");
            dic.Add("旝", "ytwj");
            dic.Add("譗", "ytwk");
            dic.Add("诲", "ytx");
            dic.Add("誨", "ytxu");
            dic.Add("訸", "yty");
            dic.Add("旜", "ytyg");
            dic.Add("州", "ytyh");
            dic.Add("旒", "ytyq");
            dic.Add("说", "yu");
            dic.Add("誁", "yuah");
            dic.Add("旘", "yuaj");
            dic.Add("識", "yuaj");
            dic.Add("庰", "yuak");
            dic.Add("详", "yud");
            dic.Add("詳", "yudh");
            dic.Add("庠", "yudk");
            dic.Add("谫", "yue");
            dic.Add("龐", "yued");
            dic.Add("譋", "yueg");
            dic.Add("譾", "yuen");
            dic.Add("譢", "yuep");
            dic.Add("謭", "yuev");
            dic.Add("譲", "yufe");
            dic.Add("詊", "yufh");
            dic.Add("谰", "yug");
            dic.Add("斓", "yugi");
            dic.Add("斕", "yugi");
            dic.Add("讕", "yugi");
            dic.Add("議", "yugt");
            dic.Add("谙", "yuj");
            dic.Add("諳", "yujg");
            dic.Add("譩", "yujn");
            dic.Add("廍", "yukb");
            dic.Add("説", "yukq");
            dic.Add("譄", "yulj");
            dic.Add("谪", "yum");
            dic.Add("謫", "yumd");
            dic.Add("謪", "yumk");
            dic.Add("讁", "yump");
            dic.Add("谱", "yuo");
            dic.Add("諩", "yuog");
            dic.Add("譜", "yuoj");
            dic.Add("谤", "yup");
            dic.Add("谛", "yuph");
            dic.Add("諦", "yuph");
            dic.Add("謗", "yupy");
            dic.Add("谘", "yuq");
            dic.Add("諮", "yuqk");
            dic.Add("讇", "yuqv");
            dic.Add("詨", "yuqy");
            dic.Add("譐", "yusf");
            dic.Add("谚", "yut");
            dic.Add("諺", "yute");
            dic.Add("谦", "yuv");
            dic.Add("劆", "yuvj");
            dic.Add("廉", "yuvo");
            dic.Add("謙", "yuvo");
            dic.Add("谥", "yuw");
            dic.Add("謚", "yuwl");
            dic.Add("良", "yv");
            dic.Add("譭", "yvac");
            dic.Add("朗", "yvc");
            dic.Add("郎", "yvcb");
            dic.Add("廄", "yvcc");
            dic.Add("郒", "yvcc");
            dic.Add("塱", "yvcf");
            dic.Add("剆", "yvcj");
            dic.Add("勆", "yvcl");
            dic.Add("欴", "yvcw");
            dic.Add("詉", "yvcy");
            dic.Add("郞", "yveb");
            dic.Add("鄘", "yveb");
            dic.Add("郎", "yveb");
            dic.Add("庸", "yveh");
            dic.Add("鷛", "yveo");
            dic.Add("裒", "yveu");
            dic.Add("詪", "yvey");
            dic.Add("旔", "yvfp");
            dic.Add("唐", "yvh");
            dic.Add("鄌", "yvhb");
            dic.Add("廋", "yvhc");
            dic.Add("謏", "yvhc");
            dic.Add("鶶", "yvho");
            dic.Add("康", "yvi");
            dic.Add("诏", "yvk");
            dic.Add("詔", "yvkg");
            dic.Add("廱", "yvky");
            dic.Add("亹", "yvmg");
            dic.Add("斖", "yvmg");
            dic.Add("訅", "yvn");
            dic.Add("誛", "yvpc");
            dic.Add("誽", "yvqn");
            dic.Add("庚", "yvw");
            dic.Add("鹒", "yvwg");
            dic.Add("庾", "yvwi");
            dic.Add("赓", "yvwm");
            dic.Add("賡", "yvwm");
            dic.Add("鶊", "yvwo");
            dic.Add("谀", "yvwy");
            dic.Add("諛", "yvwy");
            dic.Add("譅", "yvyh");
            dic.Add("認", "yvyn");
            dic.Add("訒", "yvyy");
            dic.Add("訙", "yvyy");
            dic.Add("讱", "yvyy");
            dic.Add("认", "yw");
            dic.Add("讼", "ywc");
            dic.Add("庺", "ywcs");
            dic.Add("訟", "ywcy");
            dic.Add("诊", "ywe");
            dic.Add("診", "ywet");
            dic.Add("府", "ywf");
            dic.Add("焤", "ywfo");
            dic.Add("廃", "ywfq");
            dic.Add("腐", "ywfw");
            dic.Add("詂", "ywfy");
            dic.Add("诠", "ywg");
            dic.Add("論", "ywga");
            dic.Add("讑", "ywga");
            dic.Add("詮", "ywgg");
            dic.Add("谕", "ywgj");
            dic.Add("廥", "ywgj");
            dic.Add("諭", "ywgj");
            dic.Add("譮", "ywgj");
            dic.Add("詥", "ywgk");
            dic.Add("諡", "ywgl");
            dic.Add("證", "ywgu");
            dic.Add("譣", "ywgw");
            dic.Add("庂", "ywi");
            dic.Add("亱", "ywjg");
            dic.Add("斺", "ywjh");
            dic.Add("庎", "ywjk");
            dic.Add("褒", "ywk");
            dic.Add("說", "ywkq");
            dic.Add("詤", "ywnq");
            dic.Add("庥", "yws");
            dic.Add("夜", "ywt");
            dic.Add("庩", "ywti");
            dic.Add("鵺", "ywto");
            dic.Add("於", "ywu");
            dic.Add("乻", "ywun");
            dic.Add("旕", "ywux");
            dic.Add("訜", "ywvn");
            dic.Add("鳼", "ywvo");
            dic.Add("鴋", "ywvo");
            dic.Add("鴍", "ywvo");
            dic.Add("座", "yww");
            dic.Add("谶", "yww");
            dic.Add("膺", "ywwe");
            dic.Add("卒", "ywwf");
            dic.Add("鹰", "ywwg");
            dic.Add("讖", "ywwg");
            dic.Add("噟", "ywwk");
            dic.Add("顇", "ywwm");
            dic.Add("應", "ywwn");
            dic.Add("鷹", "ywwo");
            dic.Add("譍", "ywwy");
            dic.Add("雜", "ywwy");
            dic.Add("论", "ywx");
            dic.Add("廢", "ywxc");
            dic.Add("讹", "ywxn");
            dic.Add("訛", "ywxn");
            dic.Add("詅", "ywyc");
            dic.Add("謢", "ywyc");
            dic.Add("﨎", "ywyc");
            dic.Add("谁", "ywyg");
            dic.Add("誰", "ywyg");
            dic.Add("誝", "ywyk");
            dic.Add("謒", "ywyk");
            dic.Add("谂", "ywyn");
            dic.Add("庈", "ywyn");
            dic.Add("訡", "ywyn");
            dic.Add("諗", "ywyn");
            dic.Add("谯", "ywyo");
            dic.Add("譙", "ywyo");
            dic.Add("率", "yx");
            dic.Add("庼", "yxdm");
            dic.Add("廎", "yxdm");
            dic.Add("謴", "yxfm");
            dic.Add("訠", "yxhh");
            dic.Add("玅", "yxit");
            dic.Add("紊", "yxiu");
            dic.Add("诣", "yxj");
            dic.Add("詣", "yxjg");
            dic.Add("畜", "yxl");
            dic.Add("鄐", "yxlb");
            dic.Add("詏", "yxln");
            dic.Add("牽", "yxph");
            dic.Add("雍", "yxt");
            dic.Add("饔", "yxte");
            dic.Add("玈", "yxte");
            dic.Add("壅", "yxtf");
            dic.Add("譺", "yxth");
            dic.Add("罋", "yxtm");
            dic.Add("甕", "yxtn");
            dic.Add("玄", "yxu");
            dic.Add("庀", "yxv");
            dic.Add("庇", "yxx");
            dic.Add("谐", "yxxr");
            dic.Add("諧", "yxxr");
            dic.Add("譏", "yxxt");
            dic.Add("孶", "yxyb");
            dic.Add("玆", "yxyx");
            dic.Add("誸", "yxyx");
            dic.Add("方", "yy");
            dic.Add("謶", "yyao");
            dic.Add("廓", "yyb");
            dic.Add("謧", "yybc");
            dic.Add("谆", "yybg");
            dic.Add("諄", "yybg");
            dic.Add("譈", "yybt");
            dic.Add("旈", "yycq");
            dic.Add("庡", "yyei");
            dic.Add("堃", "yyff");
            dic.Add("亠", "yyg");
            dic.Add("誩", "yyg");
            dic.Add("訁", "yygg");
            dic.Add("註", "yygg");
            dic.Add("广", "yygt");
            dic.Add("文", "yygy");
            dic.Add("谅", "yyi");
            dic.Add("諒", "yyiy");
            dic.Add("讓", "yyke");
            dic.Add("丶", "yyl");
            dic.Add("譠", "yylg");
            dic.Add("廪", "yyli");
            dic.Add("乀", "yyll");
            dic.Add("乁", "yyll");
            dic.Add("廩", "yylt");
            dic.Add("謞", "yymk");
            dic.Add("访", "yyn");
            dic.Add("讠", "yyn");
            dic.Add("訪", "yyn");
            dic.Add("谝", "yyna");
            dic.Add("斒", "yyna");
            dic.Add("諞", "yyna");
            dic.Add("庐", "yyne");
            dic.Add("詠", "yyni");
            dic.Add("謆", "yynn");
            dic.Add("该", "yynw");
            dic.Add("該", "yynw");
            dic.Add("廘", "yynx");
            dic.Add("譹", "yype");
            dic.Add("諪", "yyps");
            dic.Add("议", "yyq");
            dic.Add("詶", "yyth");
            dic.Add("譧", "yyuo");
            dic.Add("廊", "yyv");
            dic.Add("斏", "yyve");
            dic.Add("誏", "yyve");
            dic.Add("谇", "yyw");
            dic.Add("誶", "yywf");
            dic.Add("詃", "yyxy");
            dic.Add("譶", "yyyf");
            #endregion
            if (dic.ContainsKey(hz))
            {
                return dic[hz];
            }
            return hz;
        }
    }
}
