﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.International.Converters.PinYinConverter;

namespace CreatePinYinMa
{
    public class PublicMethod
    {
        //private static readonly string connStr = ConfigurationManager.ConnectionStrings["connStr"].ConnectionString;
        public static string ConnStr;
        /// <summary>
        /// 生成汉字声母，传入一个字符串，遍历，如果是汉字，调用PYM方法
        /// </summary>
        /// <param name="ZiFuChuan">传入的字符串</param>
        /// <returns>返回这个字符串的声母字符串</returns>
        public string PinYinMa(string ZiFuChuan)
        {
            string PinYinMa = null;
            string PinYinMa2 = null;
            bool zhuanHuanZT;
            foreach (char HZ in ZiFuChuan) //遍历传入的字符串
            {
                PinYinMa2 = PYM(HZ.ToString(), out zhuanHuanZT); //先使用自己的拼音包进行转换
                try
                {
                    if (zhuanHuanZT)
                    {
                        PinYinMa += PinYinMa2;
                    }
                    else //如果自己的拼音包转换失败，就使用微软的拼音开发包进行转换尝试
                    {
                        ChineseChar cc = new ChineseChar(HZ);
                        PinYinMa += cc.Pinyins[0].Substring(0, 1);
                    }
                }
                catch //不能转换的字体，保留原样
                {
                    PinYinMa += HZ.ToString();
                }
            }
            return PinYinMa;
        }

        /// <summary>
        /// 传入一个汉字，返回该汉字的声母
        /// </summary>
        /// <param name="ZiFu">传入的汉字</param>
        /// <returns>返回该汉字的声母</returns>
        private string PYM(string ZiFu,out bool _zhuanHuanZT)
        {
            bool zhuanHuanZT = true;
            byte[] ziFuArray = new byte[2];
            ziFuArray = System.Text.Encoding.Default.GetBytes(ZiFu); //获得汉字第一个字节和第二个字节的值
            int hanZiASCII;
            if (ziFuArray.Length == 2)
            {
                hanZiASCII = (int)(ziFuArray[0] - '\0') * 256 + ((int)(ziFuArray[1] - '\0')); //汉字占两个字节，第一个字节的值+第二个字节的值
            }
            else
            {
                hanZiASCII = (int)(ziFuArray[0] - '\0') * 256;
            }

            string PYM;
            if (hanZiASCII >= 45217 && hanZiASCII <= 45252)
            {
                PYM = "A";
            }
            else if (hanZiASCII >= 45253 && hanZiASCII <= 45760)
            {
                PYM = "B";
            }
            else if (hanZiASCII >= 45761 && hanZiASCII <= 46317)
            {
                PYM = "C";
            }
            else if (hanZiASCII >= 46318 && hanZiASCII <= 46825)
            {
                PYM = "D";
            }
            else if (hanZiASCII >= 46826 && hanZiASCII <= 47009)
            {
                PYM = "E";
            }
            else if (hanZiASCII >= 47010 && hanZiASCII <= 47296)
            {
                PYM = "F";
            }
            else if (hanZiASCII >= 47297 && hanZiASCII <= 47613)
            {
                PYM = "G";
            }
            else if (hanZiASCII >= 47614 && hanZiASCII <= 48118)
            {
                PYM = "H";
            }
            else if (hanZiASCII >= 48119 && hanZiASCII <= 49061)
            {
                PYM = "J";
            }
            else if (hanZiASCII >= 49062 && hanZiASCII <= 49323)
            {
                PYM = "K";
            }
            else if (hanZiASCII >= 49324 && hanZiASCII <= 49895)
            {
                PYM = "L";
            }
            else if (hanZiASCII >= 49896 && hanZiASCII <= 50370)
            {
                PYM = "M";
            }
            else if (hanZiASCII >= 50371 && hanZiASCII <= 50613)
            {
                PYM = "N";
            }
            else if (hanZiASCII >= 50614 && hanZiASCII <= 50621)
            {
                PYM = "O";
            }
            else if (hanZiASCII >= 50622 && hanZiASCII <= 50905)
            {
                PYM = "P";
            }
            else if (hanZiASCII >= 50906 && hanZiASCII <= 51386)
            {
                PYM = "Q";
            }
            else if (hanZiASCII >= 51387 && hanZiASCII <= 51445)
            {
                PYM = "R";
            }
            else if (hanZiASCII >= 51446 && hanZiASCII <= 52217)
            {
                PYM = "S";
            }
            else if (hanZiASCII >= 52218 && hanZiASCII <= 52697)
            {
                PYM = "T";
            }
            else if (hanZiASCII >= 52698 && hanZiASCII <= 52979)
            {
                PYM = "W";
            }
            else if (hanZiASCII >= 52980 && hanZiASCII <= 53640)
            {
                PYM = "X";
            }
            else if (hanZiASCII >= 53665 && hanZiASCII <= 53688)
            {
                PYM = "X";
            }
            else if (hanZiASCII >= 53689 && hanZiASCII <= 54480)
            {
                PYM = "Y";
            }
            else if ((hanZiASCII >= 54481 && hanZiASCII <= 54526) || (hanZiASCII >= 54689 && hanZiASCII <= 54782) || (hanZiASCII >= 54945 && hanZiASCII <= 55038) || (hanZiASCII >= 55193 && hanZiASCII <= 55289))
            {
                PYM = "Z";
            }
            else //如果不是中文，则不处理
            {
                string[] strArray = new string[22];
                strArray[0] = "A嫒铵噯桉";
                strArray[1] = "B玢汴薜璧忭飚傧镔蓓镖葆贲缤钣煲犇浜";
                strArray[2] = "C埕琤谌萃姹昶丞岑祠宸淙琛嫦婵钗铖棰璨琮偲";
                strArray[3] = "D棣娣钿聃铛黛岱趸埭炖昳咚窦鞑眈";
                strArray[4] = "E奀鳄锷";
                strArray[5] = "F昉霏沣孚畈斐妃翡芙馥梵";
                strArray[6] = "G杲罡淦亘艮蚣玕赓蝈擀簋诰桄莞桧";
                strArray[7] = "H骅浒铧灏蕙颢濠珲鹄菡荟桁彗浣泓桦晖珩晗皓瀚昊璜潢馄沆茴";
                strArray[8] = "J颉佼珺隽缙伽镓皎衿璟憬荩琎嶠妗瑾珏姣婕婧菁珈崛矶羯鍵桀琚钜蛟涓绛荠劼旌";
                strArray[9] = "K垲闿剀琨铿锴焜轲侃堃逵珂恺铠脍鲲凱";
                strArray[10] = "L鹭鹂砺嘹鎏泺苓藜栎翎樑浏雒麟郦岚璐靓雳笠噜泷瑯粼耒栾蔺泠俪";
                strArray[11] = "M珉湄旻淼茗魅闵咪焖懋慜沐姳";
                strArray[12] = "N楠囡廿旎蘖";
                strArray[13] = "P濮霈珮娉溥嫔珀";
                strArray[14] = "Q绮虔彊佺芩嗪荞麒裘茜圻芊瞿岐铨骐琪愆荃淇祺骞倩琦锵钤";
                strArray[15] = "R镕偌芮嵘睿洳苒榕";
                strArray[16] = "S钐嵩荪菽佘淞澍晟泗姗姝飒莳驷昇涮悚燧";
                strArray[17] = "T倜帑庹凃钛潼颋佟覃滕樘茼悌焘韬婷豚窕霆洮镗饨阗铤町畑";
                strArray[18] = "W婺菀葳邬仵玟炜汶玮雯薇蜈圩";
                strArray[19] = "X骁漩焬歆晞曉诩楦骧煦暄栩曦洵琇烜玺潇筱馨胥煊炫枭萱璇昕娴鑫藓逍庠禧哓奚遐箫兮";
                strArray[20] = "Y佚憶懿翕熠闫垠薏苡挹弈芫鋆炀泱曜诒荑镛沅晔馀萦翊雲霙娅昀毓轶玙莺贻筠滢奕聿煜焱妤垚瑛媛芸妍怡瑜窈嫣玥钰驿琰囿暚烨爻晏羿谕餘弋瑗胤崯昱赟楹崟彧鈺晳肴贇钺锳";
                strArray[21] = "Z祉倬筝徵吒锃瓒焯峥凖桢铮梓炤钊祚喆祯芷楂茱璋朕臧郅";

                Dictionary<string, string> dict = new Dictionary<string, string>(); //new一个字典
                for (int i1 = 0; i1 < strArray.Length; i1++) //遍历数组
                {
                    string str = strArray[i1];
                    for (int i2 = 1; i2 < str.Length; i2++) //遍历字符串，下标从1开始，跳过字母
                    {
                        //把上面的汉字挨个加到字典里
                        dict.Add(str[i2].ToString(), str[0].ToString()); //键为汉字，值为字母；str[0]：取字符串的第一个字，即字母
                    }
                }
                try
                {
                    PYM = dict[ZiFu]; //根据汉字找出拼音码
                }
                catch //如果字典里也没有这个汉字，就原样输出
                {
                    //PYM = "#";
                    PYM = ZiFu.ToString();
                    zhuanHuanZT = false;
                }
            }
            _zhuanHuanZT = zhuanHuanZT;
            return PYM;
        }
    }
}
