﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.DirectoryServices;
using System.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;

namespace ScanIP
{
    public partial class Form1 : Form
    {
        [DllImport("ws2_32.dll")]
        private static extern int inet_addr(string cp);
        [DllImport("IPHLPAPI.dll")]
        private static extern int SendARP(Int32 DestIP, Int32 SrcIP, ref Int64 pMacAddr, ref Int32 PhyAddrLen);
        private DbHelper dbHelper;
        delegate void SetValDelegate(string val); //1、定义为界面赋值的委托
        private SetValDelegate setValDelegate;
        delegate void SetDgv(DataTable dt); //1、定义为界面赋值的委托
        private SetDgv setDgv;
        private string network = string.Empty;//网段，如：192.168.0.
        private string startIp = string.Empty; //开始IP
        private string endIp = string.Empty; //结束IP
        private Thread t;
        private DataTable dtRecordIP;
        private bool bScan = false; //扫描状态
        public Form1()
        {
            InitializeComponent();
            dbHelper = new DbHelper();
            IPList();
        }

        #region ExecDelegate执行委托为界面赋值的委托方法
        /// <summary>
        /// 执行委托为界面赋值的委托方法
        /// </summary>
        /// <param name="notice"></param>
        private void ExecDelegate(string notice)
        {
            setValDelegate = (val) => { tboNotice.Text = val; }; //2、初始化为界面赋值的委托
            this.Invoke(setValDelegate, notice); //3、执行委托
        }
        /// <summary>
        /// 执行委托，为Dgv赋值
        /// </summary>
        /// <param name="dataTab"></param>
        private void ExecDelegate(DataTable dataTab)
        {
            setDgv = (dt) => { dgvIPList.DataSource = dt; };
            this.Invoke(setDgv, dataTab);
        }
        #endregion
        #region button1_Click扫描IP按钮
        /// <summary>
        /// 扫描IP按钮
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(ScanIp);
            t.IsBackground = true;
            t.Start();
        }
        /// <summary>
        /// 扫描已保存的IP
        /// </summary>
        private void ScanIp()
        {
            bScan = true;
            dtRecordIP = dbHelper.GetDataTable("select * from recordIP where [dateTime]=#" + DateTime.Today + "#");
            DataTable dt = dbHelper.GetDataTable("select * from tableIP");
            int i = 0;
            foreach (DataRow dr in dt.Rows)
            {
                string ip = dr["IP"].ToString();
                ExecDelegate("正在扫描：" + ip);
                Ping ping = new Ping();
                if (cboFast.Checked == true)
                {
                    ping.PingCompleted += new PingCompletedEventHandler(ScanIp);
                    ping.SendAsync(IPAddress.Parse(dr["IP"].ToString()), 10000, null);
                }
                else
                {
                    PingReply reply = ping.Send(ip);
                    if (reply.Options != null)
                    {
                        ScanIp(IPAddress.Parse(ip));
                    }
                }
                i++;
            }
            //MessageBox.Show("扫描" + i + "个IP");
            ExecDelegate("扫描" + i + "个IP");
            IPList();
            bScan = false;
        }

        private void ScanIp(object sender, PingCompletedEventArgs e)
        {
            if (e.Reply != null && e.Reply.Status == IPStatus.Success)
            {
                ScanIp(e.Reply.Address);
            }
        }
        private void ScanIp(IPAddress ip)
        {
            string pcName = string.Empty;
            string mac = GetMacAddress(ip.ToString());
            try
            {
                pcName = Dns.GetHostEntry(ip).HostName;

            }
            catch
            {
                pcName = "未获得";
            }
            finally
            {
                if ((from a in dtRecordIP.AsEnumerable() where a.Field<string>("IP") == ip.ToString() select a).Count() == 0)
                {
                    OleDbParameter[] paras = { new OleDbParameter("?", ip.ToString()), 
                                                 new OleDbParameter("?", DateTime.Today),
                                                 new OleDbParameter("?",mac),
                                                 new OleDbParameter("?",pcName)
                                         };
                    dbHelper.SqlNonQuery("insert into recordIP(IP,[dateTime],MAC,PCName)values(?,?,?,?)", paras);
                }
                OleDbParameter[] paras2 ={new OleDbParameter("?",DateTime.Today),
                                            new OleDbParameter("?",ip.ToString())};
                dbHelper.SqlNonQuery("update tableIP set LastDate = ? where IP = ?", paras2);
            }
        }
        #endregion
        #region btnSave_Click保存按钮点击事件
        /// <summary>
        /// 保存按钮点击事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSave_Click(object sender, EventArgs e)
        {
            this.startIp = tbo_StartIP.Text;
            this.endIp = tbo_EndIP.Text;
            if (string.IsNullOrWhiteSpace(this.startIp) && !string.IsNullOrWhiteSpace(this.endIp)) this.startIp = this.endIp;
            if (!string.IsNullOrWhiteSpace(this.startIp) && string.IsNullOrWhiteSpace(this.endIp)) this.endIp = this.startIp;
            if (string.IsNullOrWhiteSpace(this.startIp) && string.IsNullOrWhiteSpace(this.endIp)) return;
            this.network = this.startIp.Substring(0, this.startIp.LastIndexOf(".")); //网段
            if ((!string.IsNullOrWhiteSpace(this.startIp)) && (!Regex.IsMatch(this.startIp, @"^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)$")))
            {
                MessageBox.Show("开始IP地址错误");
                return;
            }
            if ((!string.IsNullOrWhiteSpace(this.endIp)) && (!Regex.IsMatch(this.endIp, @"^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)$")))
            {
                MessageBox.Show("结束IP地址错误");
                return;
            }

            if (this.network != this.endIp.Substring(0, this.endIp.LastIndexOf(".")))
            {
                MessageBox.Show("开始IP与结束IP不在同一网段");
                return;
            }
            this.t = new Thread(SaveIP);
            this.t.IsBackground = true;
            this.t.Start();
        }
        #endregion
        #region CutIP取ip未位数
        /// <summary>
        /// 取ip未位数
        /// </summary>
        /// <param name="startIp">开始ip</param>
        /// <param name="endIp">结束ip</param>
        private List<int> CutIP(string startIp, string endIp)
        {
            List<int> listIp = new List<int>();
            if (!string.IsNullOrWhiteSpace(startIp))
            {
                int length = startIp.Length;
                int cut = startIp.LastIndexOf(".");
                listIp.Add(int.Parse(startIp.Substring(cut + 1, length - (cut + 1))));
            }
            if (!string.IsNullOrWhiteSpace(endIp))
            {
                int length = endIp.Length;
                int cut = endIp.LastIndexOf(".");
                listIp.Add(int.Parse(endIp.Substring(cut + 1, length - (cut + 1))));
            }
            return listIp;
        }
        #endregion
        #region SaveIP保存IP
        /// <summary>
        /// 保存IP
        /// </summary>
        private void SaveIP()
        {
            List<int> listIp = CutIP(this.startIp, this.endIp);
            string sql = "insert into tableIP(Order,IP,LastDate)values(?,?,?)";
            string sql2 = "select * from tableIP";
            DataTable dt = dbHelper.GetDataTable(sql2);
            for (int i = listIp.Min(); i <= listIp.Max(); i++)
            {
                ExecDelegate("正在保存：" + this.network + "." + i);
                OleDbParameter[] paras = { new OleDbParameter("?", this.network + "." + i) };
                OleDbParameter[] paras2 = { new OleDbParameter("?",  i), 
                                              new OleDbParameter("?", this.network + "." + i), 
                                              new OleDbParameter("?", "1900-01-01")};
                var row = from a in dt.AsEnumerable() where a.Field<string>("IP") == (this.network + "." + i) select a;
                if (row.Count() == 0)
                {
                    dbHelper.SqlNonQuery(sql, paras2);
                }
            }
            MessageBox.Show("保存完成");
            IPList();
        }
        #endregion
        #region IPList
        /// <summary>
        /// IPList
        /// </summary>
        private void IPList()
        {
            this.t = new Thread(GetIPList);
            this.t.IsBackground = true;
            this.t.Start();
        }
        private void GetIPList()
        {
            string sql = "select Order as 排序,IP,LastDate as 末次使用 from tableIP order by LastDate desc";
            ExecDelegate(dbHelper.GetDataTable(sql));
        }
        #endregion
        /// <summary>
        /// 根据IP获得该IP的使用明细
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dgvIPList_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            GetIPHistory(e.RowIndex, e.ColumnIndex);
        }
        /// <summary>
        /// 方向键事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void dgvIPList_KeyUp(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == Keys.Down || e.KeyCode==Keys.Up) && this.dgvIPList.CurrentCellAddress.X == 0)
            {
                GetIPHistory(this.dgvIPList.CurrentRow.Index, 0);
            }
        }
        #region GetIPHistory根据IP获得历史使用记录
        /// <summary>
        /// 根据IP获得历史使用记录
        /// <para>哪几台电脑曾经使用过</para>
        /// </summary>
        /// <param name="rowIndex">行号</param>
        /// <param name="columnIndex">列号</param>
        private void GetIPHistory(int rowIndex, int columnIndex)
        {
            if (rowIndex == -1) return;
            if (columnIndex == 1)
            {
                string val = this.dgvIPList.Rows[rowIndex].Cells["IP"].Value.ToString();
                dgvDetail.DataSource = dbHelper.GetDataTable("select IP as IP地址,MAC as MAC地址,PCName as 计算机名,[dateTime] as 末次使用 from recordIP where IP = '" + val + "' order by dateTime desc");
            }
        } 
        #endregion
        #region GetMacAddress根据ip获得MAC地址
        /// <summary>
        /// 根据ip获得MAC地址
        /// </summary>
        /// <param name="hostip"></param>
        /// <returns></returns>
        private string GetMacAddress(string hostip)//获取远程IP（不能跨网段）的MAC地址
        {
            string Mac = "";
            try
            {
                Int32 ldest = inet_addr(hostip); //将IP地址从 点数格式转换成无符号长整型
                Int64 macinfo = new Int64();
                Int32 len = 6;
                SendARP(ldest, 0, ref macinfo, ref len);
                string TmpMac = Convert.ToString(macinfo, 16).PadLeft(12, '0');//转换成16进制　　注意有些没有十二位
                Mac = TmpMac.Substring(0, 2).ToUpper();//
                for (int i = 2; i < TmpMac.Length; i = i + 2)
                {
                    Mac = TmpMac.Substring(i, 2).ToUpper() + "-" + Mac;
                }
            }
            catch (Exception Mye)
            {
                Mac = "未获得";
            }
            return Mac;
        } 
        #endregion
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            timer1.Interval = 1000 * 60 * 60 * 24;
            //ExecDelegate("下次执行时间：" + DateTime.Now.AddMilliseconds(interval).ToString("yyyy年MM月dd日 HH:mm:ss"));
            if (bScan) //如果任务未处理结束，本次操作结束
            {
                timer1.Enabled = true;
                return;
            }
            btnScan.PerformClick();
            timer1.Enabled = true;
        }
          /// <summary>
        /// 方向键事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void dataGridView1_KeyUp(object sender, KeyEventArgs e) 
        //{ 
        //    if (e.KeyCode == Keys.Left || e.KeyCode == Keys.Right || e.KeyCode == Keys.Up || e.KeyCode == Keys.Down) 
        //    { 
        //        SendKeys.Send("{F2}"); 
        //    } 
        //}
    }
}