<?php
namespace Admin\Controller;
use Think\Controller;
class UserController extends CommonController {
    //入驻列表
    public function index() {
        $merchant=M('merchant');
        $member=M('member');
        $typ=I('get.typ');
        if($typ!=""){
          $where['audit']=$typ;
        }
        $count = $merchant->where($where)->count();
        $pConf = page($count,C('PAGE_SIZE'));
        $list=$merchant->where($where)->order('time desc')->limit($pConf['first'], $pConf['list'])->select();
        foreach ($list as $k => $v) {
            $list[$k]['account']=$member->where(array('uid' =>$v['uid']))->getField('account');
        }
        $this->list=$list;
        $this->page = $pConf['show'];
        $this->typ=$typ;
        $this->display();
    }
   //入驻金额
  public function set_pay(){
  if(IS_POST){
        $this->checkToken();
        $config = APP_PATH . "Common/Conf/Money.php";
        $config = file_exists($config) ? include "$config" : array();
        $config = is_array($config) ? $config : array();
        $data['Money'] = I('post.Money');
        if (set_config("Money", $data, APP_PATH . "Common/Conf/")) {
            delDirAndFile(WEB_CACHE_PATH . "Cache/Admin/");
            echojson(array('status' => 1, 'info' => '设置成功'));
        } else {
            echojson(array('status' => 0, 'info' => '设置失败，请检查'));
        }
    }else{
        $this->Money=C('Money');
        $this->display(); 
    }
 }
 //车鉴定检测费用
 public function set_money(){
   if(IS_POST){
        $this->checkToken();
        $config = APP_PATH . "Common/Conf/SetMoney.php";
        $config = file_exists($config) ? include "$config" : array();
        $config = is_array($config) ? $config : array();
        $data['Set_Money'] = I('post.Set_Money');
        if (set_config("SetMoney", $data, APP_PATH . "Common/Conf/")) {
            delDirAndFile(WEB_CACHE_PATH . "Cache/Admin/");
            echojson(array('status' => 1, 'info' => '设置成功'));
        } else {
            echojson(array('status' => 0, 'info' => '设置失败，请检查'));
        }
    }else{
        $this->Set_Money=C('Set_Money');
        $this->display(); 
    }
 }
 //审核入驻卖家信息
 public function edit(){
  if(IS_POST){
    $this->checkToken();
    $info=I('post.info');
    $merchant=M('merchant');
    $member=M('member');
    //判断是否重复提交
    $audit=$merchant->where(array('id' =>$info['id']))->getField('audit');
    if($audit!='0'){
       $this->error('请勿重复审核入驻卖家',U('User/index'),5);
    }
    $data['checktime']=time();
    $data['audit']=$info['audit'];
    $data['reason']=$info['reason'];
    if($merchant->where(array('id' =>$info['id']))->save($data)){
        //假如是不通过解冻卖家保证金
        if($data['audit']=='1'){
            $info=$merchant->where(array('id' =>$info['id']))->find();
          if($member->where(array('uid'=>$info['uid']))->setDec('wallet_pledge_freeze',$info['money'])){
             //写入冻结保证金记录
            $pledge_data = array(
                'order_no'=>createNo('SH'),
                'uid'=>$info['uid'],
                'changetype'=>'bid_sh',
                'time'=>$data['checktime'],
                'annotation'=>'审核未通过解冻保证金'.$info['money'].'元',
                'income'=>$info['money']
                );
            if(M('member_pledge_bill')->add($pledge_data)){
                // 给用户发消息
                sendSms($info['uid'],'卖家入驻失败解冻',$pledge_data['annotation']);
            } //写入用户账户记录
          } 
        }
        echojson(array('status' => 1, 'info' =>"审核成功",'url'=>U('User/index')));
    }else{
        echojson(array('status' => 0, 'info' =>"审核失败,请刷新页面重试！"));  
    }
  }else{
    $id=I('get.id');
    $merchant=M('merchant');
    $region=M('Region');
    $info=$merchant->where(array('id' =>$id))->find();
    $info['pictures'] = explode('|', $info['pictures']);
    $info['province']=$region->where(array('region_id' =>$info['province']))->getField('region_name');
    $info['city']=$region->where(array('region_id' =>$info['city']))->getField('region_name');
    $info['area']=$region->where(array('region_id' =>$info['area']))->getField('region_name');
    $this->info=$info;
    $this->display();  
  }
 }
 //搜索卖家入驻记录
 public function search(){
    $typ=I('get.typ');
    $M = M("merchant");
    $member=M('member');
    if($typ!=""){
        $where['audit']=$typ;
    }
    $keyW = I('get.');
    $encode = mb_detect_encoding($keyW['keyword'], array("ASCII","UTF-8","GB2312","GBK","BIG5"));
    $keyW['keyword'] = iconv($encode,"utf-8//IGNORE",$keyW['keyword']);
    if($keyW['keyword'] != ''){
        $uidarr = M('member')->where(array('account'=>array('LIKE', '%' . $keyW['keyword'] . '%')))->getField('uid',true);
        $where['uid'] = array('in',$uidarr);
    }
    $count = $M->where($where)->count();
    $pConf = page($count,C('PAGE_SIZE'));
    $list = $M->where($where)->limit($pConf['first'].','.$pConf['list'])->order('time desc')->select();
    foreach ($list as $k => $v) {
      $list[$k]['account']= $member->where(array('uid' =>$v['uid']))->getField('account');
    }
    $this->list=$list;
    $this->typ=$typ;
    $this->page = $pConf['show'];
    C('TOKEN_ON',false);
    $this->display('index');
 }
}