<?php
namespace Admin\Model;
use Think\Model\ViewModel;
class ShowcarModel extends ViewModel {
    Protected $viewFields = array(
        'Showcar' => array(
            'scid', 'gid','scname','aid','published','endstatus','mobile','note','sucprice','mmobile',
            '_type' => 'LEFT'
            ),
        'Goods' => array(
            'id','cid','markno',
            '_on' => 'Showcar.gid = Goods.id',
            '_type' => 'LEFT'
            )
    );
    /**
     * [listShowcar description]
     * @param  integer $firstRow [分页起始]
     * @param  integer $listRows [分页结束]
     * @param  [type]  $where    [筛选条件]
     * @return [type]            [拍品列表]
     */
    public function listShowcar($firstRow = 0, $listRows = 20, $where,$od) {
        $subscribe = M('showcar_subscribe');
        $huckster = M('showcar_huckster');
        $list = $this->limit($firstRow.','.$listRows)->where($where)->order($od)->select();
        $aidArr = M("Admin")->field("`aid`,`email`,`nickname`")->select();
        foreach ($aidArr as $k => $v) {
            $aids[$v['aid']] = $v;
        }
        unset($aidArr);
        foreach ($list as $k => $v) {
            $list[$k]['aidName'] =$aids[$v['aid']]['nickname'] == '' ? $aids[$v['aid']]['email'] : $aids[$v['aid']]['nickname'];
            // 买卖状态
            if($v['endstatus']==0) {
                $list[$k]['st'] = '已上架';
            }elseif ($v['endstatus']==1) {
                $list[$k]['st'] = '交易成功';
            }elseif ($v['endstatus']==2) {
                $list[$k]['st'] = '下架交易失败';
            }
              // 预约
            $list[$k]['subcount'] = $subscribe->where(array('scid'=>$v['scid']))->count();
            $list[$k]['subno'] = $subscribe->where(array('scid'=>$v['scid'],array('status'=>0)))->count();
            // 砍价
            $list[$k]['huckster'] = $huckster->where(array('scid'=>$v['scid']))->count();
            $list[$k]['hucno'] = $huckster->where(array('scid'=>$v['scid'],array('status'=>0)))->count();
        }
        return $list;
    }
}
?>
