<?php
namespace Home\Controller;
use Think\Controller;
use Com\WechatAuth;
use Com\JsSdk;
class CommonController extends Controller {
    public $loginMarked;
    public $touristMarked;
    public $cUid;
    public $subscribe;
    public $identity;
    public $ism;
    /**
      +----------------------------------------------------------
     * 初始化
     * 如果 继承本类的类自身也需要初始化那么需要在使用本继承类的类里使用parent::_initialize();
      +----------------------------------------------------------
     */
    public function _initialize() {
        error_reporting(0);
        ini_set("error_reporting","E_ALL & ~E_NOTICE"); 
        header('Access-Control-Allow-Origin:*');
        $systemConfig = include APP_PATH . '/Common/Conf/systemConfig.php';
        if (empty($systemConfig['TOKEN']['member_marked'])) {
            $systemConfig['TOKEN']['admin_marked'] = "admin.oncoo.net";
            $systemConfig['TOKEN']['admin_timeout'] = 3600;
            $systemConfig['TOKEN']['member_marked'] = "home.oncoo.net";
            $systemConfig['TOKEN']['member_timeout'] = 3600;
            set_config("systemConfig", $systemConfig, APP_PATH . "/Common/Conf/");
            if (is_dir(APP_PATH . "install/")) {
                //delDirAndFile(WEB_ROOT . "/install/", TRUE);
            }
        } 

        //禁止山东IP访问
         //$this->error('如需测试网站，请联系QQ2325087103，');
        /// exit();
        // checkKey();
        // 定义模板【
        // 1:电脑版 2手机版 0自动切换
        $who = defineView(1);
        $this->ism=$who['mobile'];
        C('DEFAULT_THEME',$who['view']);
        $this->webroot=C('WEB_ROOT');
        // 定义模板】

        $this->loginMarked = md5($systemConfig['TOKEN']['member_marked']);
        $this->touristMarked = md5($systemConfig['TOKEN']['member_marked'].'tourist');
        // 获取当前用户id
        // 登录信息分配到模板
        $login = $this->checkLogin(0);
        if ($login) {
            $markedArr = explode('_', $_COOKIE[$this->loginMarked]);
            $this->cUid=substr($markedArr[0],0,-32);
        }else{
            // 记录该访问者推广用户
            $source = I('get.m');
            $source = explode('_', $source);
            if ($source[1]) {
                if(M('member')->where(array('uid'=>$source[1]))->find()){
                    if (!isset($_COOKIE[$this->touristMarked])) {
                        setcookie($this->touristMarked, $source[1], 0, "/");
                    }
                }
            }
        }
        $this->login = $login;
        // 微信浏览器需要关注微信公众号，或者直接登陆【
        $iswei = 0;
        if(is_weixin()){
            $iswei = 1;
            $this->showcodemap = 1;
            if(!S('S_accessToken')){
                $WechatAuth = new WechatAuth(C('Weixin.appid'),C('Weixin.appsecret'));
                $S_accessToken=$WechatAuth->getAccessToken();
                if ($S_accessToken && is_array($S_accessToken)) {
                    S('S_accessToken',$S_accessToken['access_token'],7200);//2小时过期
                }
            }
            $jssdk = new JSSDK(C('Weixin.appid'),C('Weixin.appsecret'),S('S_accessToken'));
            $jssdk->debug = true;
            $signPackage = $jssdk->GetSignPackage();
            $this->sharelink = $signPackage['url'];
            $this->shareimg = C('WEB_ROOT'). str_replace('./', '', C('Weixin.shareimg'));
            $this->signPackage = $signPackage;
            // 未登录跳转到登陆绑定页面
            if(!$this->checkLogin(0)){
                // 如果get方式访问进入登录页面
                if (IS_GET && I('get.gol')!=1) {
                    $scope = C('Weixin.scope');
                    if(I('get.state')=='winlogin'){
                        $this->winlogin($scope);
                    }else{
                        $winoauth = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid='.C('Weixin.appid').'&redirect_uri='.urlencode($signPackage['url']).'&response_type=code&scope='.$scope.'&state=winlogin#wechat_redirect';
                        header("Location:".$winoauth);
                        exit();
                    }
                }
            }else{
                $member_weixin = M('member_weixin');
                $member = M('member');
                // 更新微信登陆时间和登陆方式
                $member_weixin->where(array('uid'=>$this->cUid))->setField('weitime',time()+172800);
                // 分配是否已经关注拍卖系统
                $this->subscribe = $member_weixin->where(array('uid'=>$this->cUid))->getField('subscribe');
                // 分配公众号二维码地址
                $this->codemapimg = C('WEB_ROOT'). str_replace('./', '', C('Weixin.codemapimg'));
            }
        }
        $this->iswei = $iswei;
        // 微信浏览器需要关注微信公众号，或者直接登陆】
        $this->uid = $this->cUid;
        // 手机模板
        $this->ismobile=$who['mobile'];
        // 关注提醒状态开启状态
        $this->mapstate = $this->subscribe;
        // 后台关注提醒状态
        $this->codemap =C('Weixin.codemap');
        // B2C模式运营
        if($this->checkLogin(0)){
            //当前用户用户名分配到模板 
            $this->nickname = M('Member')->where('uid ='.$this->cUid)->getField('nickname');
            // 获取未读信息
            $this->smsc = M('mysms')->where(array('uid'=>$this->cUid,'status'=>0,'delmark'=>0))->count();
            // 是否B2C运营【
            if (C('Auction.jurisdiction')==1) {
                $disposable = M('seller_pledge')->where(array('sellerid'=>$this->cUid,'type'=>'disposable','status'=>'1'))->count();
                if ($disposable) {
                    $this->identity = 1;
                }else{
                    $this->identity = 0;
                }
                $isbc = 1;
            }else{
                $this->identity = 1;
                $isbc = 0;
            }
            // 是否B2C运营】
        }
        $this->myidentity = $this->identity;
        $this->isbc =$isbc;
        // 为结束的生成订单
        $this->foreach_order();
        // 当前时间分配到模板
        $this->nowtime = time();
        // 图片上传路径
        $this->upWholeUrl = __ROOT__.trim(C('UPLOADS_PICPATH'),'.');
        // 频道导航
        $cate = M('Goods_category');
        $this->channelMenu=$cate->where(array('pid'=>0))->order('sort desc')->select();
        $this->assign("site", $systemConfig);
    }

    // 单品拍卖订单
    public function foreach_order() {
        $ncow = array(
            'endtime'=>array('lt',time()),
            'endstatus'=>0,
        );
        $nco = D('Auction')->where($ncow)->select();
        // 查找数组内相同值的保留一个
        if(is_array($nco)){
            // 生成订单进入开关
            foreach ($nco as $n => $nv) {
                create_order($nv);
            }
        }
    }
    // 微信浏览器打开公众号关注用户登陆提醒关注公众号
    public function winlogin($scope){
            // 微信登录【
            if(I('get.code')) {
                $systemConfig = include APP_PATH . '/Common/Conf/systemConfig.php';
                // 获取openid、access_token【
                $code = I('get.code');
                if(S('S_accessToken')){
                    $WechatAuth = new WechatAuth(C('Weixin.appid'),C('Weixin.appsecret'),S('S_accessToken'));
                }else{
                    $WechatAuth = new WechatAuth(C('Weixin.appid'),C('Weixin.appsecret'));
                    $S_accessToken=$WechatAuth->getAccessToken();
                    if ($S_accessToken && is_array($S_accessToken)) {
                        S('S_accessToken',$S_accessToken['access_token'],7200);//2小时过期
                    }
                }
                $codeReturn = $WechatAuth->getAccessToken('code',$code);
                // 获取openid、access_token】
                if ($codeReturn['access_token']) {
                     $userInfo = $WechatAuth->userInfo($codeReturn['openid']);
                    // 用户点开分享链接跳转到关注公众号引导页面
                    if($scope == 'snsapi_base' && !$userInfo['subscribe']){
                        // 提示关注公众号
                        header("Location:".C('Weixin.attention'));
                        exit();
                    }
                }else{
                    $this->error('获取openid、access_token失败！');
                    exit();
                }
                // 如果获取到openid【
                if($codeReturn['openid']){
                    // 获取微信用户信息【 
                    $member_weixin = M('member_weixin');
                    $member = M('member');
                    // 查询本地存在用户
                    $wuser_info = $member_weixin->where(array('openid'=>$codeReturn['openid']))->find();
                    // GET方式传递地址会出错所以写入缓存调用缓存名称【
                    $suname = time().substr(microtime(), 2,3);
                    $uarr = explode('?code=', get_url());
                    S($suname,$uarr[0],3600);
                    // GET方式传递地址会出错所以写入缓存调用缓存名称】
                    if($wuser_info){
                        $info = $member->where(array('uid'=>$wuser_info['uid']))->field('pwd,weiauto')->find();
                        // 如果设置了微信自动登陆，进行登陆操作
                        if($info['weiauto']){
                            // 更新用户数据
                                // 更新微信数据
                                $member_weixin->where(array('openid'=>$userInfo['openid']))->setField('weitime',time()+172800);
                                // 写入cookie
                                $shell = $wuser_info['uid'] . md5($info['pwd'] . C('AUTH_CODE'));
                                $_SESSION[$this->loginMarked] = $shell;
                                $shell.= "_" . time();
                                // 发送cookie
                                setcookie($this->loginMarked, $shell, time()+$systemConfig['TOKEN']['member_timeout'], "/");
                                redirect(S($suname),0,'登陆中...');
                                exit();
                        }else{
                            $this->redirect("Login/index",array('gol'=>1,'openid'=>$codeReturn['openid'],'access_token'=>$codeReturn['access_token'],'suname'=>$suname,'diversity'=>1),0,'跳转中...');
                        }
                    // 添加该用户到本站
                    }else{
                        // 是否微信绑定登录
                        if (C('Weixin.diversity')==1||C('Weixin.diversity')!=0) {
                            $this->redirect("Login/index",array('gol'=>1,'openid'=>$codeReturn['openid'],'access_token'=>$codeReturn['access_token'],'suname'=>$suname,'bound'=>'checked'),0,'跳转中...');
                        }else{
                            $gourl = U("Login/weioauth",array('gol'=>1,'openid'=>$codeReturn['openid'],'access_token'=>$codeReturn['access_token'],'suname'=>$suname,'create'=>'auto'),'html',true);
                            Header("Location: ".$gourl);
                        }
                    }
                }else{
                    $this->error('获取openid失败！');
                }
                // 如果获取到openid】
            }else{
                $this->error('获取code失败！');
            }
            // 微信登录】
    }
    // 判断登陆状态$type:1跳转，0返回登录状态
    public function checkLogin($type) {
        if (isset($_COOKIE[$this->loginMarked])) {
            $cookie = explode("_", $_COOKIE[$this->loginMarked]);
            $timeout = C("TOKEN");
            if (time() > (end($cookie) + $timeout['member_timeout'])) {
                setcookie($this->loginMarked, NULL, -$timeout['member_timeout'], "/");
                unset($_SESSION[$this->loginMarked], $_COOKIE[$this->loginMarked]);
                if($type){
                    $this->error("登录超时，请重新登录", U("Login/index"));
                }else{
                    return 0;
                }
            } else {
                if ($cookie[0] == $_SESSION[$this->loginMarked]) {
                    setcookie($this->loginMarked, $cookie[0] . "_" . time(), 0, "/");
                } else {
                    setcookie($this->loginMarked, NULL, -$timeout['member_timeout'], "/");
                    unset($_SESSION[$this->loginMarked], $_COOKIE[$this->loginMarked]);
                    if($type){
                        $this->error("帐号异常，请重新登录", U("Login/index"));
                    }else{
                        return 0;
                    } 
                }
            }
        } else {
            if($type){
                $this->redirect("Login/index");
            }else{
                return 0;
            } 
        }
        return 1;
    }

    /**
      +----------------------------------------------------------
     * 验证token信息
      +----------------------------------------------------------
     */
    protected function checkToken() {
        if (IS_POST) {
            if (!M("Admin")->autoCheckToken($_POST)) {
                die(echojson(array('status' => 0, 'info' => '重复提交数据，请刷新页面重试！','msg' => '重复提交数据！')));
            }
            unset($_POST[C("TOKEN_NAME")]);
        }
    }

}