<?php
namespace Home\Model;
use Think\Model;
class LoginModel extends Model {
    public function login(){
        $M = M('member');
        $mbcof=C('Member');
        if(preg_match('/^[a-zA-Z][\w]{3,16}$/', I('post.account'))&&$mbcof['register']['account']=='on'){
            $where=array('account'=>I('post.account'));
            $msg = '账号';
        }elseif(preg_match('/^([0-9A-Za-z\\-_\\.]+)@([0-9a-z]+\\.[a-z]{2,3}(\\.[a-z]{2})?)$/i', I('post.account'))&&$mbcof['register']['email']=='on'){
            $where=array('email'=>I('post.account'),array('verify_email'=>1));
            $msg = '邮箱';
        }elseif(preg_match('/^1[358]\d{9}$/', I('post.account'))&&$mbcof['register']['mobile']=='on'){
            $where=array('mobile'=>I('post.account'),array('verify_mobile'=>1));
            $msg = '手机号';
        }else{
            return array('status' => 0, 'info' => '账号格式不正确');
            exit;
        }
        $info = $M->field(array('uid','pwd','status'))->where($where)->find();
        if(empty($info)){
            return array('status' => 0, 'info' => I('post.account').$msg.'不存在，要不注册一个吧');
            exit;
        }elseif (!check_verify(I('post.verify_code'))) {
            return array('status' => 0, 'info' => '验证码错了,重新输入吧');
            exit;
        }elseif ($info['pwd']!=encrypt(I('post.pwd'))) {
            return array('status' => 0, 'info' => '密码错误，重新输一次吧');
            exit;
        }
        elseif ($info['status']==0) {
            return array('status' => 0, 'info' => '账号被禁用了，请和管理员联系');
            exit;
        }
        // 更新用户数据
        $data = array(
            'uid'=>$info['uid'],
            'login_time'=>time(),
            'login_type'=>0,
            'login_ip'=>get_client_ip()
            );
        $M->save($data);
        // 写入cookie
        $systemConfig = include APP_PATH . '/Common/Conf/systemConfig.php';
        $loginMarked = md5($systemConfig['TOKEN']['member_marked']);
        $shell = $info['uid'] . md5($info['pwd'] . C('AUTH_CODE'));
        $_SESSION[$loginMarked] = $shell;
        $shell.= "_" . time();
        // 发送cookie
        setcookie($loginMarked, $shell, time()+$systemConfig['TOKEN']['member_timeout'], "/");
        // 判断过来的url设置返回URL
        $url = I('post.referer');
        if(in_array($url, noback())){
            $url = U('Member/index');
        }
        // 返回注册成功信息
        return array('status' => 1, 'info' => '登录成功','url' => $url);
    }
    // 注册
    public function register(){
        if (I('post.pwd')!=I('post.pwded')) {
            return array('status' => 0, 'info' => '两次密码不一致，再输一遍吧');
            exit;
        }
        // 整合数据
        $data = array(
            'nickname' => I('post.nickname'),
            'truename' => I('post.truename'),
            'pwd' => encrypt(I('post.pwd')),
            'reg_date'=>time(),
            'reg_ip' => get_client_ip(),
            'login_time'=>time(),
            'login_ip'=>get_client_ip(),
            'login_type'=>0
            );
        $M = M('member');
        // 写入前验证一次
        switch (I('post.registerType')) {
            case 'account':
                if($M->where(array('account'=>I('post.account')))->count()!=0){
                    return array('status' => 0, 'info' => I('post.account').'账号已存在，换一个吧');
                    exit;
                }
                $data['account']=I('post.account');
                $data['mobile'] = I('post.mobile');
                break;
            case 'email':
                $ve = M('verify_email')->where(array('email'=>I('post.email')))->find();
                if($ve['losetime']<time()){
                    return array('status' => 0, 'info' => '验证码已过期，请重新注册');
                    exit;
                }
                if($ve['code']!=I('post.email_verify')){
                    return array('status' => 0, 'info' => '邮箱验证码错误，请确认');
                    exit;
                }
                $data['account']=substr('on'.'_'.strstr(I('post.email'), '@', TRUE),0,16);
                $data['email'] = I('post.email');
                $data['mobile'] = I('post.mobile');
                $data['verify_email'] = 1;
                $data['alerttype'] = 'email';
                break;
            case 'mobile':
                $vm = M('verify_mobile')->where(array('mobile'=>I('post.mobile')))->find();
                if($vm['losetime']<time()){
                    return array('status' => 0, 'info' => '验证码已过期，请重新注册');
                    exit;
                }
                if($vm['code']!=I('post.mobile_verify')){
                    return array('status' => 0, 'info' => '短信验证码错误，请确认');
                    exit;
                }
                $data['account']=substr('on'.'_'.I('post.mobile'),0,16);
                $data['email'] = I('post.email');
                $data['mobile'] = I('post.mobile');
                $data['verify_mobile'] = 1;
                $data['alerttype'] = 'mobile';
                break;
            default:
                return array('status' => 0, 'info' => '不存在的注册方式');
                break;
        }
        if($uid=$M->add($data)){
            // 推广统计
            if(I('post.feedback')!=''){
                M('feedback')->where(array('id'=>I('post.feedback')))->setInc('count');
            }
            // 写入cookie
            $systemConfig = include APP_PATH . '/Common/Conf/systemConfig.php';
            $loginMarked = md5($systemConfig['TOKEN']['member_marked']);
            $shell = $uid . md5($data['pwd'] . C('AUTH_CODE'));
            $_SESSION[$loginMarked] = $shell;
            $shell.= "_" . time();
            setcookie($loginMarked, $shell, time()+$systemConfig['TOKEN']['member_timeout'], "/");
            // 判断过来的url设置返回URL
            $url = I('post.referer');
            if(in_array($url, noback())){
                $url = U('Member/index');
            }
            // 返回注册成功信息
            return array('status' => 1, 'info' => '注册成功','url' => $url);
        }else{
            return array('status' => 1, 'info' => '注册失败，请与网站管理员联系');
        }
    }
}

?>
