SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


CREATE TABLE IF NOT EXISTS `simcms_ad` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `adtype` tinyint(2) DEFAULT '0',
  `pic` varchar(100) DEFAULT NULL,
  `picwidth` varchar(5) DEFAULT NULL,
  `picheight` varchar(5) DEFAULT NULL,
  `url` varchar(100) DEFAULT NULL,
  `url_note` varchar(100) DEFAULT NULL,
  `starttime` int(11) DEFAULT '0',
  `endtime` int(11) DEFAULT '0',
  `isshow` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=56 ;

INSERT INTO `simcms_ad` (`id`, `name`, `adtype`, `pic`, `picwidth`, `picheight`, `url`, `url_note`, `starttime`, `endtime`, `isshow`) VALUES
(54, '首页左侧广告', 1, '/upload/image/20140704/20140704140321_36372.jpg', '240', '130', 'http://www.simcms.net', '', 1406131200, 1469030400, 1),
(55, '首页右侧广告', 1, '/upload/image/20140810/20140810175740_74118.jpg', '240', '185', 'http://www.simcms.net', '', 1404403200, 1501084800, 1);

CREATE TABLE IF NOT EXISTS `simcms_admin` (
  `adminid` mediumint(9) NOT NULL AUTO_INCREMENT,
  `username` char(30) DEFAULT NULL,
  `password` char(32) DEFAULT NULL,
  `admingroup` int(11) DEFAULT '0',
  `admin_type` enum('administrator','admin') DEFAULT NULL,
  `last_login_time` int(11) DEFAULT NULL,
  `last_login_ip` char(15) DEFAULT NULL,
  `login_count` mediumint(9) DEFAULT '0',
  `status` tinyint(4) DEFAULT '0',
  `description` char(20) DEFAULT NULL,
  `permission` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`adminid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `simcms_admin` (`adminid`, `username`, `password`, `admingroup`, `admin_type`, `last_login_time`, `last_login_ip`, `login_count`, `status`, `description`, `permission`) VALUES
(1, 'admin', 'e10adc3949ba59abbe56e057f20f883e', 0, 'administrator', 1460278481, 'unknown', 402, 1, '', '');

CREATE TABLE IF NOT EXISTS `simcms_admingroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(32) DEFAULT NULL,
  `permission` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `simcms_admingroup` (`id`, `groupname`, `permission`) VALUES
(3, '租车管理员', '107,108'),
(2, '二手车管理员', '5,67,75,77,79,81,71,69');

CREATE TABLE IF NOT EXISTS `simcms_area` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `isrecom` tinyint(1) DEFAULT NULL,
  `orderid` int(11) DEFAULT NULL,
  `parentid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=12 ;

INSERT INTO `simcms_area` (`id`, `name`, `isrecom`, `orderid`, `parentid`) VALUES
(1, '山东省', 0, 0, -1),
(2, '济南', 1, 0, 1),
(3, '青岛', 0, 0, 1),
(4, '烟台', 0, 0, 1),
(5, '威海', 0, 0, 1),
(6, '上海市', 0, 0, -1),
(7, '上海市', 1, 0, 6),
(8, '河北', 0, 0, -1),
(9, '秦皇岛', 0, 0, 8),
(10, '石家庄', 0, 0, 8);

CREATE TABLE IF NOT EXISTS `simcms_assesscars` (
  `aid` int(11) DEFAULT '0',
  `cid` int(11) DEFAULT '0',
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_contact_name` varchar(64) DEFAULT NULL,
  `p_contact_tel` varchar(32) DEFAULT NULL,
  `p_brand` int(5) DEFAULT '0',
  `p_subbrand` smallint(11) DEFAULT '0',
  `p_subsubbrand` int(11) DEFAULT '0',
  `p_name` varchar(30) DEFAULT NULL,
  `p_allname` varchar(50) DEFAULT NULL,
  `p_keyword` varchar(200) DEFAULT NULL,
  `p_color` varchar(10) DEFAULT NULL,
  `p_country` varchar(30) DEFAULT NULL,
  `p_transmission` varchar(10) DEFAULT NULL,
  `p_year` int(4) DEFAULT '0',
  `p_details` varchar(512) DEFAULT NULL,
  `p_model` int(11) DEFAULT NULL,
  `p_addtime` int(11) DEFAULT '0',
  `p_pics` varchar(512) DEFAULT NULL,
  `p_mainpic` varchar(100) DEFAULT NULL,
  `p_month` int(4) DEFAULT '0',
  `p_gas` varchar(10) DEFAULT NULL,
  `p_price` decimal(8,2) DEFAULT NULL,
  `p_kilometre` decimal(8,2) DEFAULT NULL,
  `p_reply_times` int(11) DEFAULT '0',
  `p_reply_info` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`p_id`),
  KEY `p_allname` (`p_allname`),
  KEY `p_price` (`p_price`),
  KEY `p_sort` (`p_model`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `simcms_assesscars` (`aid`, `cid`, `p_id`, `p_contact_name`, `p_contact_tel`, `p_brand`, `p_subbrand`, `p_subsubbrand`, `p_name`, `p_allname`, `p_keyword`, `p_color`, `p_country`, `p_transmission`, `p_year`, `p_details`, `p_model`, `p_addtime`, `p_pics`, `p_mainpic`, `p_month`, `p_gas`, `p_price`, `p_kilometre`, `p_reply_times`, `p_reply_info`) VALUES
(0, 0, 4, '张先生', '13676765676', 29, 32, 0, '', '阿斯顿·马丁DB7', NULL, '白色', '国产', '自动', 2004, '', 1, 1398865097, NULL, NULL, 4, '2', NULL, 0.00, NULL, NULL),
(0, 0, 3, '张先生', '13676765676', 1, 9, 0, '', '奥迪A1', NULL, '白色', '国产', '自动', 2006, '', 2, 1398517204, NULL, NULL, 5, '1', NULL, 15.00, NULL, NULL);

CREATE TABLE IF NOT EXISTS `simcms_brand` (
  `b_id` int(11) NOT NULL AUTO_INCREMENT,
  `b_name` varchar(32) DEFAULT NULL,
  `b_keyword` varchar(32) DEFAULT NULL,
  `b_parent` int(11) DEFAULT NULL,
  `b_type` tinyint(1) DEFAULT '0',
  `pic` varchar(100) DEFAULT NULL,
  `mark` varchar(8) DEFAULT NULL,
  `orderid` int(11) DEFAULT '0',
  `classid` int(2) DEFAULT NULL,
  `carid` int(10) DEFAULT NULL,
  PRIMARY KEY (`b_id`),
  KEY `b_parent` (`b_parent`),
  KEY `classid` (`classid`),
  KEY `mark` (`mark`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=66890 ;

INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(1, '奥迪', '', -1, 1, 'http://www.w5257.com/upload/brand/m_9.png', 'A', 0, 1, 9),
(2, '奥克斯', NULL, -1, 0, NULL, 'A', 0, 1, 12),
(3, '阿尔法·罗密欧', NULL, -1, 0, NULL, 'A', 0, 1, 92),
(4, '阿斯顿·马丁', NULL, -1, 0, NULL, 'A', 0, 1, 97),
(5, 'AC Schnitzer', NULL, -1, 0, NULL, 'A', 0, 1, 180),
(6, '奔驰', NULL, -1, 0, 'm_2.png', 'B', 0, 1, 2),
(7, '宝马', NULL, -1, 0, 'm_3.png', 'B', 0, 1, 3),
(8, '标致', NULL, -1, 0, 'm_5.png', 'B', 0, 1, 5),
(9, '北汽制造', NULL, -1, 0, NULL, 'B', 0, 1, 14),
(10, '比亚迪', NULL, -1, 0, 'm_15.png', 'B', 0, 1, 15),
(11, '本田', NULL, -1, 0, 'm_26.png', 'B', 0, 1, 26),
(12, '奔腾', NULL, -1, 0, 'm_59.png', 'B', 0, 1, 59),
(13, '宝龙', NULL, -1, 0, NULL, 'B', 0, 1, 68),
(14, '保时捷', NULL, -1, 0, NULL, 'B', 0, 1, 82),
(15, '宾利', NULL, -1, 0, NULL, 'B', 0, 1, 85),
(16, '别克', NULL, -1, 0, 'm_127.png', 'B', 0, 1, 127),
(17, '布加迪', NULL, -1, 0, NULL, 'B', 0, 1, 135),
(18, '宝骏', NULL, -1, 0, NULL, 'B', 0, 1, 157),
(19, '北京汽车', NULL, -1, 0, 'm_163.png', 'B', 0, 1, 163),
(20, '北汽威旺', NULL, -1, 0, NULL, 'B', 0, 1, 168),
(21, '巴博斯', NULL, -1, 0, NULL, 'B', 0, 1, 172),
(22, '保斐利', NULL, -1, 0, NULL, 'B', 0, 1, 184),
(23, '北汽幻速', NULL, -1, 0, NULL, 'B', 0, 1, 211),
(24, '北汽新能源', NULL, -1, 0, NULL, 'B', 0, 1, 216),
(25, '长城', NULL, -1, 0, 'm_21.png', 'C', 0, 1, 21),
(26, '昌河', NULL, -1, 0, NULL, 'C', 0, 1, 129),
(27, '长安轿车', NULL, -1, 0, 'm_136.png', 'C', 0, 1, 136),
(28, '长安商用', NULL, -1, 0, 'm_159.png', 'C', 0, 1, 159),
(29, '大众', NULL, -1, 0, 'm_8.png', 'D', 0, 1, 8),
(30, '东风', NULL, -1, 0, NULL, 'D', 0, 1, 27),
(31, '东南', NULL, -1, 0, NULL, 'D', 0, 1, 29),
(32, '大迪', NULL, -1, 0, NULL, 'D', 0, 1, 66),
(33, '大宇', NULL, -1, 0, NULL, 'D', 0, 1, 106),
(34, '道奇', NULL, -1, 0, 'm_113.png', 'D', 0, 1, 113),
(35, '东风风行', NULL, -1, 0, NULL, 'D', 0, 1, 115),
(36, '东风风神', NULL, -1, 0, 'm_141.png', 'D', 0, 1, 141),
(37, 'DS', NULL, -1, 0, 'm_179.png', 'D', 0, 1, 179),
(38, '东风风度', NULL, -1, 0, 'm_197.png', 'D', 0, 1, 197),
(39, '东风小康', NULL, -1, 0, NULL, 'D', 0, 1, 205),
(40, '东风御风', NULL, -1, 0, NULL, 'D', 0, 1, 215),
(41, '丰田', NULL, -1, 0, 'm_7.png', 'F', 0, 1, 7),
(42, '福特', NULL, -1, 0, 'm_17.png', 'F', 0, 1, 17),
(43, '菲亚特', NULL, -1, 0, 'm_40.png', 'F', 0, 1, 40),
(44, '富奇', NULL, -1, 0, NULL, 'F', 0, 1, 61),
(45, '福迪', NULL, -1, 0, NULL, 'F', 0, 1, 67),
(46, '法拉利', NULL, -1, 0, NULL, 'F', 0, 1, 91),
(47, '福田', NULL, -1, 0, NULL, 'F', 0, 1, 128),
(48, '福达', NULL, -1, 0, NULL, 'F', 0, 1, 154),
(49, 'Faralli Mazzanti', NULL, -1, 0, NULL, 'F', 0, 1, 187),
(50, '飞驰商务车', NULL, -1, 0, NULL, 'F', 0, 1, 199),
(51, '福汽启腾', NULL, -1, 0, NULL, 'F', 0, 1, 208),
(52, '广汽吉奥', NULL, -1, 0, NULL, 'G', 0, 1, 63),
(53, 'GMC', NULL, -1, 0, NULL, 'G', 0, 1, 109),
(54, '光冈', NULL, -1, 0, NULL, 'G', 0, 1, 110),
(55, '广汽日野', NULL, -1, 0, NULL, 'G', 0, 1, 133),
(56, '广汽', NULL, -1, 0, 'm_147.png', 'G', 0, 1, 147),
(57, '观致汽车', NULL, -1, 0, NULL, 'G', 0, 1, 182),
(58, '哈飞', NULL, -1, 0, NULL, 'H', 0, 1, 31),
(59, '海马', NULL, -1, 0, 'm_32.png', 'H', 0, 1, 32),
(60, '华普', NULL, -1, 0, NULL, 'H', 0, 1, 44),
(61, '汇众', NULL, -1, 0, NULL, 'H', 0, 1, 45),
(62, '黄海', NULL, -1, 0, NULL, 'H', 0, 1, 52),
(63, '红旗', NULL, -1, 0, 'm_58.png', 'H', 0, 1, 58),
(64, '航天圆通', NULL, -1, 0, NULL, 'H', 0, 1, 70),
(65, '悍马', NULL, -1, 0, NULL, 'H', 0, 1, 108),
(66, '华泰', NULL, -1, 0, NULL, 'H', 0, 1, 112),
(67, '汉江', NULL, -1, 0, NULL, 'H', 0, 1, 119),
(68, '黑豹', NULL, -1, 0, NULL, 'H', 0, 1, 124),
(69, '华阳', NULL, -1, 0, NULL, 'H', 0, 1, 130),
(70, '海马商用车', NULL, -1, 0, NULL, 'H', 0, 1, 149),
(71, '海格', NULL, -1, 0, NULL, 'H', 0, 1, 170),
(72, '恒天汽车', NULL, -1, 0, NULL, 'H', 0, 1, 181),
(73, '哈弗', NULL, -1, 0, 'm_196.png', 'H', 0, 1, 196),
(74, 'Jeep', NULL, -1, 0, 'm_4.png', 'J', 0, 1, 4),
(75, '吉利汽车', NULL, -1, 0, 'm_34.png', 'J', 0, 1, 34),
(76, '江淮', NULL, -1, 0, 'm_35.png', 'J', 0, 1, 35),
(77, '江铃', NULL, -1, 0, 'm_37.png', 'J', 0, 1, 37),
(78, '江南', NULL, -1, 0, NULL, 'J', 0, 1, 38),
(79, '金杯', NULL, -1, 0, 'm_39.png', 'J', 0, 1, 39),
(80, '金龙联合', NULL, -1, 0, NULL, 'J', 0, 1, 57),
(81, '金程', NULL, -1, 0, NULL, 'J', 0, 1, 74),
(82, '捷豹', NULL, -1, 0, 'm_98.png', 'J', 0, 1, 98),
(83, '吉林江北', NULL, -1, 0, NULL, 'J', 0, 1, 121),
(84, '九龙', NULL, -1, 0, NULL, 'J', 0, 1, 152),
(85, '金旅客车', NULL, -1, 0, NULL, 'J', 0, 1, 161),
(86, '克莱斯勒', NULL, -1, 0, 'm_51.png', 'K', 0, 1, 51),
(87, '凯迪拉克', NULL, -1, 0, NULL, 'K', 0, 1, 107),
(88, '科尼塞克', NULL, -1, 0, NULL, 'K', 0, 1, 145),
(89, '开瑞', NULL, -1, 0, NULL, 'K', 0, 1, 150),
(90, '卡尔森', NULL, -1, 0, NULL, 'K', 0, 1, 188),
(91, 'KTM', NULL, -1, 0, NULL, 'K', 0, 1, 212),
(92, '卡威', NULL, -1, 0, NULL, 'K', 0, 1, 213),
(93, '铃木', NULL, -1, 0, 'm_16.png', 'L', 0, 1, 16),
(94, '陆风', NULL, -1, 0, NULL, 'L', 0, 1, 36),
(95, '力帆', NULL, -1, 0, 'm_76.png', 'L', 0, 1, 76),
(96, '劳斯莱斯', NULL, -1, 0, NULL, 'L', 0, 1, 80),
(97, '路特斯', NULL, -1, 0, NULL, 'L', 0, 1, 83),
(98, '兰博基尼', NULL, -1, 0, NULL, 'L', 0, 1, 86),
(99, '雷克萨斯', NULL, -1, 0, 'm_94.png', 'L', 0, 1, 94),
(100, '林肯', NULL, -1, 0, NULL, 'L', 0, 1, 95),
(101, '路虎', NULL, -1, 0, 'm_96.png', 'L', 0, 1, 96),
(102, '雷诺', NULL, -1, 0, NULL, 'L', 0, 1, 99),
(103, '罗孚', NULL, -1, 0, NULL, 'L', 0, 1, 101),
(104, '莲花', NULL, -1, 0, NULL, 'L', 0, 1, 146),
(105, '猎豹汽车', NULL, -1, 0, 'm_153.png', 'L', 0, 1, 153),
(106, '理念', NULL, -1, 0, 'm_166.png', 'L', 0, 1, 166),
(107, '蓝海房车', NULL, -1, 0, NULL, 'L', 0, 1, 200),
(108, '马自达', NULL, -1, 0, 'm_18.png', 'M', 0, 1, 18),
(109, '美亚', NULL, -1, 0, NULL, 'M', 0, 1, 55),
(110, 'MG', NULL, -1, 0, 'm_79.png', 'M', 0, 1, 79),
(111, 'MINI', NULL, -1, 0, 'm_81.png', 'M', 0, 1, 81),
(112, '迈巴赫', NULL, -1, 0, NULL, 'M', 0, 1, 88),
(113, '玛莎拉蒂', NULL, -1, 0, NULL, 'M', 0, 1, 93),
(114, '迈凯伦', NULL, -1, 0, NULL, 'M', 0, 1, 183),
(115, '摩根', NULL, -1, 0, NULL, 'M', 0, 1, 201),
(116, '纳智捷', NULL, -1, 0, 'm_155.png', 'N', 0, 1, 155),
(117, '讴歌', NULL, -1, 0, NULL, 'O', 0, 1, 84),
(118, '欧宝', NULL, -1, 0, NULL, 'O', 0, 1, 104),
(119, '欧朗', NULL, -1, 0, 'm_171.png', 'O', 0, 1, 171),
(120, '旁蒂克', NULL, -1, 0, NULL, 'P', 0, 1, 105),
(121, '帕加尼', NULL, -1, 0, NULL, 'P', 0, 1, 185),
(122, '皮特比尔特卡车', NULL, -1, 0, NULL, 'P', 0, 1, 210),
(123, '起亚', NULL, -1, 0, 'm_28.png', 'Q', 0, 1, 28),
(124, '奇瑞', NULL, -1, 0, 'm_42.png', 'Q', 0, 1, 42),
(125, '庆铃', NULL, -1, 0, NULL, 'Q', 0, 1, 43),
(126, '启辰', NULL, -1, 0, 'm_156.png', 'Q', 0, 1, 156),
(127, '日产', NULL, -1, 0, 'm_30.png', 'R', 0, 1, 30),
(128, '荣威', NULL, -1, 0, 'm_78.png', 'R', 0, 1, 78),
(129, '瑞麒', NULL, -1, 0, 'm_142.png', 'R', 0, 1, 142),
(130, '斯柯达', NULL, -1, 0, 'm_10.png', 'S', 0, 1, 10),
(131, '三菱', NULL, -1, 0, 'm_25.png', 'S', 0, 1, 25),
(132, '双环', NULL, -1, 0, NULL, 'S', 0, 1, 50),
(133, '顺旅', NULL, -1, 0, NULL, 'S', 0, 1, 73),
(134, ' ', NULL, -1, 0, NULL, 's', 0, 1, 89),
(135, '双龙', NULL, -1, 0, 'm_102.png', 'S', 0, 1, 102),
(136, '萨博', NULL, -1, 0, NULL, 'S', 0, 1, 103),
(137, '斯巴鲁', NULL, -1, 0, 'm_111.png', 'S', 0, 1, 111),
(138, '三星', NULL, -1, 0, NULL, 'S', 0, 1, 117),
(139, '世爵', NULL, -1, 0, NULL, 'S', 0, 1, 137),
(140, '上汽大通MAXUS', NULL, -1, 0, NULL, 'S', 0, 1, 165),
(141, '陕汽通家', NULL, -1, 0, NULL, 'S', 0, 1, 169),
(142, '绅宝', NULL, -1, 0, 'm_195.png', 'S', 0, 1, 195),
(143, '山姆', NULL, -1, 0, NULL, 'S', 0, 1, 209),
(144, '天马', NULL, -1, 0, NULL, 'T', 0, 1, 54),
(145, '通田', NULL, -1, 0, NULL, 'T', 0, 1, 56),
(146, '塔菲克', NULL, -1, 0, NULL, 'T', 0, 1, 139),
(147, '腾势', NULL, -1, 0, NULL, 'T', 0, 1, 175),
(148, '特斯拉', NULL, -1, 0, NULL, 'T', 0, 1, 189),
(149, '泰卡特', NULL, -1, 0, NULL, 'T', 0, 1, 202),
(150, '沃尔沃', NULL, -1, 0, 'm_19.png', 'W', 0, 1, 19),
(151, '万丰', NULL, -1, 0, NULL, 'W', 0, 1, 46),
(152, '五菱', NULL, -1, 0, 'm_48.png', 'W', 0, 1, 48),
(153, '五十铃', NULL, -1, 0, NULL, 'W', 0, 1, 132),
(154, '威麟', NULL, -1, 0, NULL, 'W', 0, 1, 140),
(155, '威兹曼', NULL, -1, 0, NULL, 'W', 0, 1, 186),
(156, '雪铁龙', NULL, -1, 0, 'm_6.png', 'X', 0, 1, 6),
(157, '现代', NULL, -1, 0, 'm_13.png', 'X', 0, 1, 13),
(158, '雪佛兰', NULL, -1, 0, 'm_49.png', 'X', 0, 1, 49),
(159, '新雅途', NULL, -1, 0, NULL, 'X', 0, 1, 62),
(160, '新大地', NULL, -1, 0, NULL, 'X', 0, 1, 65),
(161, '新凯', NULL, -1, 0, NULL, 'X', 0, 1, 71),
(162, '西雅特', NULL, -1, 0, NULL, 'X', 0, 1, 87),
(163, '星客特', NULL, -1, 0, NULL, 'X', 0, 1, 174),
(164, '依维柯', NULL, -1, 0, NULL, 'Y', 0, 1, 41),
(165, '仪征', NULL, -1, 0, NULL, 'Y', 0, 1, 47),
(166, '一汽', NULL, -1, 0, 'm_53.png', 'Y', 0, 1, 53),
(167, '永源', NULL, -1, 0, NULL, 'Y', 0, 1, 75),
(168, '英菲尼迪', NULL, -1, 0, 'm_100.png', 'Y', 0, 1, 100),
(169, '云豹', NULL, -1, 0, NULL, 'Y', 0, 1, 118),
(170, '云雀', NULL, -1, 0, NULL, 'Y', 0, 1, 126),
(171, '野马汽车', NULL, -1, 0, NULL, 'Y', 0, 1, 138),
(172, '友谊客车', NULL, -1, 0, NULL, 'Y', 0, 1, 176),
(173, '宇通', NULL, -1, 0, NULL, 'Y', 0, 1, 178),
(174, '扬州亚星客车', NULL, -1, 0, NULL, 'Y', 0, 1, 194),
(175, '中兴', NULL, -1, 0, NULL, 'Z', 0, 1, 33),
(176, '中华', NULL, -1, 0, 'm_60.png', 'Z', 0, 1, 60),
(177, '中客华北', NULL, -1, 0, NULL, 'Z', 0, 1, 64),
(178, '中顺', NULL, -1, 0, NULL, 'Z', 0, 1, 72),
(179, '众泰', NULL, -1, 0, NULL, 'Z', 0, 1, 77),
(180, '中欧', NULL, -1, 0, NULL, 'Z', 0, 1, 167),
(181, '中通客车', NULL, -1, 0, NULL, 'Z', 0, 1, 204),
(182, '浙江卡尔森', NULL, -1, 0, NULL, 'Z', 0, 1, 214),
(183, '一汽奥迪', '', 1, 0, '', 'Y', 0, 2, 0),
(184, '奥迪', NULL, 1, 0, NULL, 'A', 0, 2, 0),
(185, '奥迪RS', NULL, 1, 0, NULL, 'A', 0, 2, 0),
(186, '奥克斯', NULL, 2, 0, NULL, 'A', 0, 2, 0),
(187, '阿尔法·罗密欧', NULL, 3, 0, NULL, 'A', 0, 2, 0),
(188, '阿斯顿·马丁', NULL, 4, 0, NULL, 'A', 0, 2, 0),
(189, 'AC Schnitzer', NULL, 5, 0, NULL, 'A', 0, 2, 0),
(190, '北京奔驰', NULL, 6, 0, NULL, 'B', 0, 2, 0),
(191, '福建奔驰', NULL, 6, 0, NULL, 'B', 0, 2, 0),
(192, '奔驰', NULL, 6, 0, NULL, 'B', 0, 2, 0),
(193, '奔驰AMG', NULL, 6, 0, NULL, 'B', 0, 2, 0),
(194, '华晨宝马', NULL, 7, 0, NULL, 'B', 0, 2, 0),
(195, '宝马', NULL, 7, 0, NULL, 'B', 0, 2, 0),
(196, '宝马M系', NULL, 7, 0, NULL, 'B', 0, 2, 0),
(197, '东风标致', NULL, 8, 0, NULL, 'B', 0, 2, 0),
(198, '广州标致', NULL, 8, 0, NULL, 'B', 0, 2, 0),
(199, '标致', NULL, 8, 0, NULL, 'B', 0, 2, 0),
(200, '北汽', NULL, 9, 0, NULL, 'B', 0, 2, 0),
(201, '比亚迪', NULL, 10, 0, NULL, 'B', 0, 2, 0),
(202, '东风本田', NULL, 11, 0, NULL, 'B', 0, 2, 0),
(203, '广汽本田', NULL, 11, 0, NULL, 'B', 0, 2, 0),
(204, '本田', NULL, 11, 0, NULL, 'B', 0, 2, 0),
(205, '一汽奔腾', NULL, 12, 0, NULL, 'B', 0, 2, 0),
(206, '宝龙', NULL, 13, 0, NULL, 'B', 0, 2, 0),
(207, '保时捷', NULL, 14, 0, NULL, 'B', 0, 2, 0),
(208, '宾利', NULL, 15, 0, NULL, 'B', 0, 2, 0),
(209, '上海通用别克', NULL, 16, 0, NULL, 'B', 0, 2, 0),
(210, '别克', NULL, 16, 0, NULL, 'B', 0, 2, 0),
(211, '布加迪', NULL, 17, 0, NULL, 'B', 0, 2, 0),
(212, '宝骏', NULL, 18, 0, NULL, 'B', 0, 2, 0),
(213, '北京汽车', NULL, 19, 0, NULL, 'B', 0, 2, 0),
(214, '北汽威旺', NULL, 20, 0, NULL, 'B', 0, 2, 0),
(215, '巴博斯', NULL, 21, 0, NULL, 'B', 0, 2, 0),
(216, '保斐利', NULL, 22, 0, NULL, 'B', 0, 2, 0),
(217, '北汽幻速', NULL, 23, 0, NULL, 'B', 0, 2, 0),
(218, '北汽新能源', NULL, 24, 0, NULL, 'B', 0, 2, 0),
(219, '长城', NULL, 25, 0, NULL, 'C', 0, 2, 0),
(220, '昌河', NULL, 26, 0, NULL, 'C', 0, 2, 0),
(221, '长安轿车', NULL, 27, 0, NULL, 'C', 0, 2, 0),
(222, '长安商用', NULL, 28, 0, NULL, 'C', 0, 2, 0),
(223, '上海大众', NULL, 29, 0, NULL, 'D', 0, 2, 0),
(224, '一汽-大众', NULL, 29, 0, NULL, 'D', 0, 2, 0),
(225, '大众', NULL, 29, 0, NULL, 'D', 0, 2, 0),
(226, '东风', NULL, 30, 0, NULL, 'D', 0, 2, 0),
(227, '东风校车系列', NULL, 30, 0, NULL, 'D', 0, 2, 0),
(228, '东南', NULL, 31, 0, NULL, 'D', 0, 2, 0),
(229, '大迪', NULL, 32, 0, NULL, 'D', 0, 2, 0),
(230, '大宇', NULL, 33, 0, NULL, 'D', 0, 2, 0),
(231, '东南道奇', NULL, 34, 0, NULL, 'D', 0, 2, 0),
(232, '道奇', NULL, 34, 0, NULL, 'D', 0, 2, 0),
(233, '东风风行', NULL, 35, 0, NULL, 'D', 0, 2, 0),
(234, '东风风神', NULL, 36, 0, NULL, 'D', 0, 2, 0),
(235, '长安DS', NULL, 37, 0, NULL, 'D', 0, 2, 0),
(236, 'DS', NULL, 37, 0, NULL, 'D', 0, 2, 0),
(237, '东风风度', NULL, 38, 0, NULL, 'D', 0, 2, 0),
(238, '东风小康', NULL, 39, 0, NULL, 'D', 0, 2, 0),
(239, '东风御风', NULL, 40, 0, NULL, 'D', 0, 2, 0),
(240, '广汽丰田', NULL, 41, 0, NULL, 'F', 0, 2, 0),
(241, '一汽丰田', NULL, 41, 0, NULL, 'F', 0, 2, 0),
(242, '丰田', NULL, 41, 0, NULL, 'F', 0, 2, 0),
(243, '长安福特', NULL, 42, 0, NULL, 'F', 0, 2, 0),
(244, '福特', NULL, 42, 0, NULL, 'F', 0, 2, 0),
(245, '广汽菲亚特', NULL, 43, 0, NULL, 'F', 0, 2, 0),
(246, '南京菲亚特', NULL, 43, 0, NULL, 'F', 0, 2, 0),
(247, '菲亚特', NULL, 43, 0, NULL, 'F', 0, 2, 0),
(248, '海酷', NULL, 43, 0, NULL, 'F', 0, 2, 0),
(249, '华翔富奇', NULL, 44, 0, NULL, 'F', 0, 2, 0),
(250, '福迪', NULL, 45, 0, NULL, 'F', 0, 2, 0),
(251, '法拉利', NULL, 46, 0, NULL, 'F', 0, 2, 0),
(252, '福田', NULL, 47, 0, NULL, 'F', 0, 2, 0),
(253, '欧辉', NULL, 47, 0, NULL, 'F', 0, 2, 0),
(254, '福达', NULL, 48, 0, NULL, 'F', 0, 2, 0),
(255, 'Faralli Mazzanti', NULL, 49, 0, NULL, 'F', 0, 2, 0),
(256, '飞驰', NULL, 50, 0, NULL, 'F', 0, 2, 0),
(257, '福汽启腾', NULL, 51, 0, NULL, 'F', 0, 2, 0),
(258, '广汽吉奥', NULL, 52, 0, NULL, 'G', 0, 2, 0),
(259, 'GMC', NULL, 53, 0, NULL, 'G', 0, 2, 0),
(260, '光冈', NULL, 54, 0, NULL, 'G', 0, 2, 0),
(261, '广汽日野', NULL, 55, 0, NULL, 'G', 0, 2, 0),
(262, '广汽传祺', NULL, 56, 0, NULL, 'G', 0, 2, 0),
(263, '观致汽车', NULL, 57, 0, NULL, 'G', 0, 2, 0),
(264, '哈飞', NULL, 58, 0, NULL, 'H', 0, 2, 0),
(265, '海马', NULL, 59, 0, NULL, 'H', 0, 2, 0),
(266, '华普', NULL, 60, 0, NULL, 'H', 0, 2, 0),
(267, '上海汇众', NULL, 61, 0, NULL, 'H', 0, 2, 0),
(268, '黄海汽车', NULL, 62, 0, NULL, 'H', 0, 2, 0),
(269, '红旗', NULL, 63, 0, NULL, 'H', 0, 2, 0),
(270, '航天圆通', NULL, 64, 0, NULL, 'H', 0, 2, 0),
(271, '悍马', NULL, 65, 0, NULL, 'H', 0, 2, 0),
(272, '华泰', NULL, 66, 0, NULL, 'H', 0, 2, 0),
(273, '汉江', NULL, 67, 0, NULL, 'H', 0, 2, 0),
(274, '富桑黑豹', NULL, 68, 0, NULL, 'H', 0, 2, 0),
(275, '华阳', NULL, 69, 0, NULL, 'H', 0, 2, 0),
(276, '郑州海马', NULL, 70, 0, NULL, 'H', 0, 2, 0),
(277, '海格', NULL, 71, 0, NULL, 'H', 0, 2, 0),
(278, '恒天汽车', NULL, 72, 0, NULL, 'H', 0, 2, 0),
(279, '哈弗', NULL, 73, 0, NULL, 'H', 0, 2, 0),
(280, '北京吉普', NULL, 74, 0, NULL, 'J', 0, 2, 0),
(281, '北京吉普切诺基', NULL, 74, 0, NULL, 'J', 0, 2, 0),
(282, 'Jeep', NULL, 74, 0, NULL, 'J', 0, 2, 0),
(283, '吉利汽车', NULL, 75, 0, NULL, 'J', 0, 2, 0),
(284, '江淮', NULL, 76, 0, NULL, 'J', 0, 2, 0),
(285, '江淮安驰', NULL, 76, 0, NULL, 'J', 0, 2, 0),
(286, '江铃', NULL, 77, 0, NULL, 'J', 0, 2, 0),
(287, '江南', NULL, 78, 0, NULL, 'J', 0, 2, 0),
(288, '华晨金杯', NULL, 79, 0, NULL, 'J', 0, 2, 0),
(289, '大金龙', NULL, 80, 0, NULL, 'J', 0, 2, 0),
(290, '金程', NULL, 81, 0, NULL, 'J', 0, 2, 0),
(291, '捷豹', NULL, 82, 0, NULL, 'J', 0, 2, 0),
(292, '吉林江北', NULL, 83, 0, NULL, 'J', 0, 2, 0),
(293, '九龙', NULL, 84, 0, NULL, 'J', 0, 2, 0),
(294, '金旅客车', NULL, 85, 0, NULL, 'J', 0, 2, 0),
(295, '北奔克莱斯勒', NULL, 86, 0, NULL, 'K', 0, 2, 0),
(296, '东南克莱斯勒', NULL, 86, 0, NULL, 'K', 0, 2, 0),
(297, '克莱斯勒', NULL, 86, 0, NULL, 'K', 0, 2, 0),
(298, '上海通用凯迪拉克', NULL, 87, 0, NULL, 'K', 0, 2, 0),
(299, '凯迪拉克', NULL, 87, 0, NULL, 'K', 0, 2, 0),
(300, '科尼塞克', NULL, 88, 0, NULL, 'K', 0, 2, 0),
(301, '开瑞', NULL, 89, 0, NULL, 'K', 0, 2, 0),
(302, '卡尔森', NULL, 90, 0, NULL, 'K', 0, 2, 0),
(303, 'KTM', NULL, 91, 0, NULL, 'K', 0, 2, 0),
(304, '卡威', NULL, 92, 0, NULL, 'K', 0, 2, 0),
(305, '昌河铃木', NULL, 93, 0, NULL, 'L', 0, 2, 0),
(306, '长安铃木', NULL, 93, 0, NULL, 'L', 0, 2, 0),
(307, '西安奥拓', NULL, 93, 0, NULL, 'L', 0, 2, 0),
(308, '铃木', NULL, 93, 0, NULL, 'L', 0, 2, 0),
(309, '陆风', NULL, 94, 0, NULL, 'L', 0, 2, 0),
(310, '力帆', NULL, 95, 0, NULL, 'L', 0, 2, 0),
(311, '劳斯莱斯', NULL, 96, 0, NULL, 'L', 0, 2, 0),
(312, '路特斯', NULL, 97, 0, NULL, 'L', 0, 2, 0),
(313, '兰博基尼', NULL, 98, 0, NULL, 'L', 0, 2, 0),
(314, '雷克萨斯', NULL, 99, 0, NULL, 'L', 0, 2, 0),
(315, '林肯', NULL, 100, 0, NULL, 'L', 0, 2, 0),
(316, '路虎', NULL, 101, 0, NULL, 'L', 0, 2, 0),
(317, '雷诺', NULL, 102, 0, NULL, 'L', 0, 2, 0),
(318, '罗孚', NULL, 103, 0, NULL, 'L', 0, 2, 0),
(319, '莲花', NULL, 104, 0, NULL, 'L', 0, 2, 0),
(320, '莲花(进口)', NULL, 104, 0, NULL, 'L', 0, 2, 0),
(321, '猎豹SUV', NULL, 105, 0, NULL, 'L', 0, 2, 0),
(322, '猎豹皮卡', NULL, 105, 0, NULL, 'L', 0, 2, 0),
(323, '理念', NULL, 106, 0, NULL, 'L', 0, 2, 0),
(324, '蓝海房车', NULL, 107, 0, NULL, 'L', 0, 2, 0),
(325, '长安马自达', NULL, 108, 0, NULL, 'M', 0, 2, 0),
(326, '一汽马自达', NULL, 108, 0, NULL, 'M', 0, 2, 0),
(327, '马自达', NULL, 108, 0, NULL, 'M', 0, 2, 0),
(328, '美亚', NULL, 109, 0, NULL, 'M', 0, 2, 0),
(329, 'MG', NULL, 110, 0, NULL, 'M', 0, 2, 0),
(330, 'MINI', NULL, 111, 0, NULL, 'M', 0, 2, 0),
(331, 'MINI JCW', NULL, 111, 0, NULL, 'M', 0, 2, 0),
(332, '迈巴赫', NULL, 112, 0, NULL, 'M', 0, 2, 0),
(333, '玛莎拉蒂', NULL, 113, 0, NULL, 'M', 0, 2, 0),
(334, '迈凯伦', NULL, 114, 0, NULL, 'M', 0, 2, 0),
(335, '摩根', NULL, 115, 0, NULL, 'M', 0, 2, 0),
(336, '纳智捷', NULL, 116, 0, NULL, 'N', 0, 2, 0),
(337, '讴歌', NULL, 117, 0, NULL, 'O', 0, 2, 0),
(338, '欧宝', NULL, 118, 0, NULL, 'O', 0, 2, 0),
(339, '欧朗', NULL, 119, 0, NULL, 'O', 0, 2, 0),
(340, '旁蒂克', NULL, 120, 0, NULL, 'P', 0, 2, 0),
(341, '帕加尼', NULL, 121, 0, NULL, 'P', 0, 2, 0),
(342, '皮特比尔特', NULL, 122, 0, NULL, 'P', 0, 2, 0),
(343, '东风悦达起亚', NULL, 123, 0, NULL, 'Q', 0, 2, 0),
(344, '起亚', NULL, 123, 0, NULL, 'Q', 0, 2, 0),
(345, '奇瑞', NULL, 124, 0, NULL, 'Q', 0, 2, 0),
(346, '庆铃', NULL, 125, 0, NULL, 'Q', 0, 2, 0),
(347, '启辰', NULL, 126, 0, NULL, 'Q', 0, 2, 0),
(348, '东风日产', NULL, 127, 0, NULL, 'R', 0, 2, 0),
(349, '郑州日产', NULL, 127, 0, NULL, 'R', 0, 2, 0),
(350, '日产', NULL, 127, 0, NULL, 'R', 0, 2, 0),
(351, '上汽荣威', NULL, 128, 0, NULL, 'R', 0, 2, 0),
(352, '瑞麒', NULL, 129, 0, NULL, 'R', 0, 2, 0),
(353, '上海大众斯柯达', NULL, 130, 0, NULL, 'S', 0, 2, 0),
(354, '斯柯达', NULL, 130, 0, NULL, 'S', 0, 2, 0),
(355, '北奔三菱', NULL, 131, 0, NULL, 'S', 0, 2, 0),
(356, '东南三菱', NULL, 131, 0, NULL, 'S', 0, 2, 0),
(357, '广汽三菱', NULL, 131, 0, NULL, 'S', 0, 2, 0),
(358, '三菱', NULL, 131, 0, NULL, 'S', 0, 2, 0),
(359, '双环', NULL, 132, 0, NULL, 'S', 0, 2, 0),
(360, '顺旅汽车', NULL, 133, 0, NULL, 'S', 0, 2, 0),
(361, 'smart', NULL, 134, 0, NULL, 's', 0, 2, 0),
(362, '双龙', NULL, 135, 0, NULL, 'S', 0, 2, 0),
(363, '萨博', NULL, 136, 0, NULL, 'S', 0, 2, 0),
(364, '斯巴鲁', NULL, 137, 0, NULL, 'S', 0, 2, 0),
(365, '广东三星', NULL, 138, 0, NULL, 'S', 0, 2, 0),
(366, '世爵', NULL, 139, 0, NULL, 'S', 0, 2, 0),
(367, '上汽大通MAXUS', NULL, 140, 0, NULL, 'S', 0, 2, 0),
(368, '通家', NULL, 141, 0, NULL, 'S', 0, 2, 0),
(369, '绅宝', NULL, 142, 0, NULL, 'S', 0, 2, 0),
(370, '山姆', NULL, 143, 0, NULL, 'S', 0, 2, 0),
(371, '天马', NULL, 144, 0, NULL, 'T', 0, 2, 0),
(372, '通田', NULL, 145, 0, NULL, 'T', 0, 2, 0),
(373, '塔菲克', NULL, 146, 0, NULL, 'T', 0, 2, 0),
(374, '腾势', NULL, 147, 0, NULL, 'T', 0, 2, 0),
(375, '特斯拉', NULL, 148, 0, NULL, 'T', 0, 2, 0),
(376, '泰卡特', NULL, 149, 0, NULL, 'T', 0, 2, 0),
(377, '长安沃尔沃', NULL, 150, 0, NULL, 'W', 0, 2, 0),
(378, '沃尔沃亚太', NULL, 150, 0, NULL, 'W', 0, 2, 0),
(379, '沃尔沃', NULL, 150, 0, NULL, 'W', 0, 2, 0),
(380, '上海万丰', NULL, 151, 0, NULL, 'W', 0, 2, 0),
(381, '五菱', NULL, 152, 0, NULL, 'W', 0, 2, 0),
(382, '五十铃', NULL, 153, 0, NULL, 'W', 0, 2, 0),
(383, '威麟', NULL, 154, 0, NULL, 'W', 0, 2, 0),
(384, '威兹曼', NULL, 155, 0, NULL, 'W', 0, 2, 0),
(385, '东风雪铁龙', NULL, 156, 0, NULL, 'X', 0, 2, 0),
(386, '雪铁龙', NULL, 156, 0, NULL, 'X', 0, 2, 0),
(387, '北京现代', NULL, 157, 0, NULL, 'X', 0, 2, 0),
(388, '四川现代', NULL, 157, 0, NULL, 'X', 0, 2, 0),
(389, '现代', NULL, 157, 0, NULL, 'X', 0, 2, 0),
(390, '金杯通用雪佛兰', NULL, 158, 0, NULL, 'X', 0, 2, 0),
(391, '上海通用雪佛兰', NULL, 158, 0, NULL, 'X', 0, 2, 0),
(392, '上汽通用五菱雪佛兰', NULL, 158, 0, NULL, 'X', 0, 2, 0),
(393, '雪佛兰', NULL, 158, 0, NULL, 'X', 0, 2, 0),
(394, '南汽新雅途', NULL, 159, 0, NULL, 'X', 0, 2, 0),
(395, '大地', NULL, 160, 0, NULL, 'X', 0, 2, 0),
(396, '新凯', NULL, 161, 0, NULL, 'X', 0, 2, 0),
(397, '西雅特', NULL, 162, 0, NULL, 'X', 0, 2, 0),
(398, '星客特', NULL, 163, 0, NULL, 'X', 0, 2, 0),
(399, '南京依维柯', NULL, 164, 0, NULL, 'Y', 0, 2, 0),
(400, '上汽仪征', NULL, 165, 0, NULL, 'Y', 0, 2, 0),
(401, '天津一汽', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(402, '一汽华利', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(403, '一汽吉林', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(404, '一汽吉林大发', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(405, '一汽轻型汽车', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(406, '一汽通用', NULL, 166, 0, NULL, 'Y', 0, 2, 0),
(407, '永源汽车', NULL, 167, 0, NULL, 'Y', 0, 2, 0),
(408, '英菲尼迪', NULL, 168, 0, NULL, 'Y', 0, 2, 0),
(409, '广州云豹', NULL, 169, 0, NULL, 'Y', 0, 2, 0),
(410, '贵州云雀', NULL, 170, 0, NULL, 'Y', 0, 2, 0),
(411, '野马汽车', NULL, 171, 0, NULL, 'Y', 0, 2, 0),
(412, '友谊', NULL, 172, 0, NULL, 'Y', 0, 2, 0),
(413, '宇通', NULL, 173, 0, NULL, 'Y', 0, 2, 0),
(414, '扬州亚星客车', NULL, 174, 0, NULL, 'Y', 0, 2, 0),
(415, '中兴', NULL, 175, 0, NULL, 'Z', 0, 2, 0),
(416, '华晨中华', NULL, 176, 0, NULL, 'Z', 0, 2, 0),
(417, '中客华北', NULL, 177, 0, NULL, 'Z', 0, 2, 0),
(418, '中顺', NULL, 178, 0, NULL, 'Z', 0, 2, 0),
(419, '众泰', NULL, 179, 0, NULL, 'Z', 0, 2, 0),
(420, '中欧汽车', NULL, 180, 0, NULL, 'Z', 0, 2, 0),
(421, '中通客车', NULL, 181, 0, NULL, 'Z', 0, 2, 0),
(422, '浙江卡尔森', NULL, 182, 0, NULL, 'Z', 0, 2, 0),
(423, '奥迪100', NULL, 183, 0, NULL, 'A', 0, 3, 2555),
(424, '奥迪200', NULL, 183, 0, NULL, 'A', 0, 3, 2556),
(425, '奥迪A3', NULL, 183, 0, NULL, 'A', 0, 3, 3999),
(426, '奥迪A4', NULL, 183, 0, NULL, 'A', 0, 3, 1906),
(427, '奥迪A4L', NULL, 183, 0, NULL, 'A', 0, 3, 2593),
(428, '奥迪A6L', NULL, 183, 0, NULL, 'A', 0, 3, 2573),
(429, '奥迪Q3', NULL, 183, 0, NULL, 'A', 0, 3, 3395),
(430, '奥迪Q5', NULL, 183, 0, NULL, 'A', 0, 3, 2855),
(431, '奥迪A1(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2921),
(432, '奥迪A3(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2715),
(433, '奥迪A4(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2075),
(434, '奥迪A5(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2382),
(435, '奥迪A6(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2071),
(436, '奥迪A7(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2837),
(437, '奥迪A8L(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2070),
(438, '奥迪Allroad quattro(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2488),
(439, '奥迪Q3(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 3547),
(440, '奥迪Q5(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2632),
(441, '奥迪Q7(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 1994),
(442, '奥迪R8(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2347),
(443, '奥迪S4', NULL, 184, 0, NULL, 'A', 0, 3, 2582),
(444, '奥迪S5(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2623),
(445, '奥迪S6(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 3634),
(446, '奥迪S7(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 3633),
(447, '奥迪S8(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2591),
(448, '奥迪SQ5(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 3829),
(449, '奥迪TT(进口)', NULL, 184, 0, NULL, 'A', 0, 3, 2068),
(450, '奥迪RS5(进口)', NULL, 185, 0, NULL, 'A', 0, 3, 2847),
(451, '奥迪RS7(进口)', NULL, 185, 0, NULL, 'A', 0, 3, 3841),
(452, '朗杰', NULL, 186, 0, NULL, 'A', 0, 3, 1559),
(453, '瑞途', NULL, 186, 0, NULL, 'A', 0, 3, 2983),
(454, '原动力', NULL, 186, 0, NULL, 'A', 0, 3, 2554),
(455, '156', NULL, 187, 0, NULL, 'A', 0, 3, 2129),
(456, '166', NULL, 187, 0, NULL, 'A', 0, 3, 2128),
(457, '阿尔法罗密欧Gtv', NULL, 187, 0, NULL, 'A', 0, 3, 2127),
(458, 'V12 Vantage', NULL, 188, 0, NULL, 'A', 0, 3, 2720),
(459, 'V8 Vantage', NULL, 188, 0, NULL, 'A', 0, 3, 2140),
(460, '阿斯顿马丁DB7', NULL, 188, 0, NULL, 'A', 0, 3, 3538),
(461, '阿斯顿马丁DB9', NULL, 188, 0, NULL, 'A', 0, 3, 2621),
(462, '阿斯顿马丁DBS', NULL, 188, 0, NULL, 'A', 0, 3, 2620),
(463, '阿斯顿马丁ONE-77', NULL, 188, 0, NULL, 'A', 0, 3, 2736),
(464, '阿斯顿马丁Rapide', NULL, 188, 0, NULL, 'A', 0, 3, 2974),
(465, '阿斯顿马丁Vanquish', NULL, 188, 0, NULL, 'A', 0, 3, 3811),
(466, '阿斯顿马丁Virage', NULL, 188, 0, NULL, 'A', 0, 3, 3415),
(467, 'AC Schnitzer ACS5', NULL, 189, 0, NULL, 'A', 0, 3, 3135),
(468, 'AC Schnitzer ACS6', NULL, 189, 0, NULL, 'A', 0, 3, 3126),
(469, 'AC Schnitzer ACS7', NULL, 189, 0, NULL, 'A', 0, 3, 3125),
(470, '奔驰C级', NULL, 190, 0, NULL, 'B', 0, 3, 2364),
(471, '奔驰E级', NULL, 190, 0, NULL, 'B', 0, 3, 1987),
(472, '奔驰GLK级', NULL, 190, 0, NULL, 'B', 0, 3, 3528),
(473, '凌特', NULL, 191, 0, NULL, 'B', 0, 3, 3542),
(474, '威霆', NULL, 191, 0, NULL, 'B', 0, 3, 3038),
(475, '唯雅诺', NULL, 191, 0, NULL, 'B', 0, 3, 2970),
(476, 'E级双门轿跑车(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2737),
(477, 'SLR', NULL, 192, 0, NULL, 'B', 0, 3, 2939),
(478, '奔驰A级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2564),
(479, '奔驰B级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2616),
(480, '奔驰CLA级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 3673),
(481, '奔驰CLK(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2260),
(482, '奔驰CLS级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2261),
(483, '奔驰CL系列(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2517),
(484, '奔驰C级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2257),
(485, '奔驰E级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2765),
(486, '奔驰GLA级', NULL, 192, 0, NULL, 'B', 0, 3, 3891),
(487, '奔驰GLK级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2600),
(488, '奔驰GL级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 1995),
(489, '奔驰G级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2356),
(490, '奔驰M级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 1953),
(491, '奔驰R级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 1877),
(492, '奔驰SEL', NULL, 192, 0, NULL, 'B', 0, 3, 2626),
(493, '奔驰SLK级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2263),
(494, '奔驰SL级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2262),
(495, '奔驰S级(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2259),
(496, '奔驰VITO(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2489),
(497, '马可波罗', NULL, 192, 0, NULL, 'B', 0, 3, 3282),
(498, '斯宾特（进口）', NULL, 192, 0, NULL, 'B', 0, 3, 2101),
(499, '威霆(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2972),
(500, '唯雅诺(进口)', NULL, 192, 0, NULL, 'B', 0, 3, 2102),
(501, '奔驰A级AMG', NULL, 193, 0, NULL, 'B', 0, 3, 3984),
(502, '奔驰CLA级AMG', NULL, 193, 0, NULL, 'B', 0, 3, 3985),
(503, '奔驰CLS级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3974),
(504, '奔驰C级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3975),
(505, '奔驰E级AMG', NULL, 193, 0, NULL, 'B', 0, 3, 3983),
(506, '奔驰GL级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3982),
(507, '奔驰G级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3976),
(508, '奔驰M级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3977),
(509, '奔驰SLK级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3978),
(510, '奔驰SLS级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3979),
(511, '奔驰SL级AMG(进口)', NULL, 193, 0, NULL, 'B', 0, 3, 3980),
(512, '奔驰S级AMG', NULL, 193, 0, NULL, 'B', 0, 3, 3981),
(513, '宝马3系', NULL, 194, 0, NULL, 'B', 0, 3, 1729),
(514, '宝马5系', NULL, 194, 0, NULL, 'B', 0, 3, 2412),
(515, '宝马X1', NULL, 194, 0, NULL, 'B', 0, 3, 3544),
(516, 'Z3', NULL, 195, 0, NULL, 'B', 0, 3, 2804),
(517, 'Z8', NULL, 195, 0, NULL, 'B', 0, 3, 2805),
(518, '宝马1系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2348),
(519, '宝马2系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 3943),
(520, '宝马3系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2035),
(521, '宝马3系GT(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 3784),
(522, '宝马4系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 3486),
(523, '宝马5系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2034),
(524, '宝马5系GT(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2755),
(525, '宝马6系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2040),
(526, '宝马7系(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2033),
(527, '宝马X1(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2762),
(528, '宝马X3(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2037),
(529, '宝马X5(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2032),
(530, '宝马X6(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2390),
(531, '宝马Z4(进口)', NULL, 195, 0, NULL, 'B', 0, 3, 2751),
(532, '宝马1系M(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3996),
(533, '宝马M3(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3991),
(534, '宝马M5(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3992),
(535, '宝马M6(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3993),
(536, '宝马X5 M(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3994),
(537, '宝马X6 M(进口)', NULL, 196, 0, NULL, 'B', 0, 3, 3995),
(538, '标致2008', NULL, 197, 0, NULL, 'B', 0, 3, 4066),
(539, '标致206', NULL, 197, 0, NULL, 'B', 0, 3, 1663),
(540, '标致207两厢', NULL, 197, 0, NULL, 'B', 0, 3, 2676),
(541, '标致207三厢', NULL, 197, 0, NULL, 'B', 0, 3, 2589),
(542, '标致3008', NULL, 197, 0, NULL, 'B', 0, 3, 3805),
(543, '标致301', NULL, 197, 0, NULL, 'B', 0, 3, 3603),
(544, '标致307两厢', NULL, 197, 0, NULL, 'B', 0, 3, 2288),
(545, '标致307三厢', NULL, 197, 0, NULL, 'B', 0, 3, 2057),
(546, '标致308', NULL, 197, 0, NULL, 'B', 0, 3, 3495),
(547, '标致408', NULL, 197, 0, NULL, 'B', 0, 3, 2859),
(548, '标致508', NULL, 197, 0, NULL, 'B', 0, 3, 3269),
(549, '广州标致', NULL, 198, 0, NULL, 'B', 0, 3, 2427),
(550, '标致206', NULL, 199, 0, NULL, 'B', 0, 3, 2985),
(551, '标致206 CC(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2274),
(552, '标致206 SW', NULL, 199, 0, NULL, 'B', 0, 3, 2986),
(553, '标致207 CC(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2419),
(554, '标致3008(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2935),
(555, '标致307', NULL, 199, 0, NULL, 'B', 0, 3, 2987),
(556, '标致307 CC(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2275),
(557, '标致307 SW(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2276),
(558, '标致308 CC(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2757),
(559, '标致308 SW(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2781),
(560, '标致4008(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 3620),
(561, '标致406 Coupe', NULL, 199, 0, NULL, 'B', 0, 3, 2988),
(562, '标致406(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 1904),
(563, '标致407 Coupe(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2280),
(564, '标致407 SW(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2278),
(565, '标致407(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2053),
(566, '标致607(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2055),
(567, '标致807(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2054),
(568, '标致RCZ(进口)', NULL, 199, 0, NULL, 'B', 0, 3, 2936),
(569, '北汽212系列', NULL, 200, 0, NULL, 'B', 0, 3, 2383),
(570, '北汽骑士', NULL, 200, 0, NULL, 'B', 0, 3, 1580),
(571, '角斗士', NULL, 200, 0, NULL, 'B', 0, 3, 2200),
(572, '雷驰', NULL, 200, 0, NULL, 'B', 0, 3, 1578),
(573, '陆霸', NULL, 200, 0, NULL, 'B', 0, 3, 1582),
(574, '陆铃', NULL, 200, 0, NULL, 'B', 0, 3, 1581),
(575, '锐铃', NULL, 200, 0, NULL, 'B', 0, 3, 4172),
(576, '新城市猎人', NULL, 200, 0, NULL, 'B', 0, 3, 1566),
(577, '旋风', NULL, 200, 0, NULL, 'B', 0, 3, 1579),
(578, '勇士', NULL, 200, 0, NULL, 'B', 0, 3, 1564),
(579, '域胜007', NULL, 200, 0, NULL, 'B', 0, 3, 2948),
(580, '越铃', NULL, 200, 0, NULL, 'B', 0, 3, 4171),
(581, '战旗2023', NULL, 200, 0, NULL, 'B', 0, 3, 2199),
(582, '战旗2024', NULL, 200, 0, NULL, 'B', 0, 3, 1577),
(583, '比亚迪E6', NULL, 201, 0, NULL, 'B', 0, 3, 2907),
(584, '比亚迪F0', NULL, 201, 0, NULL, 'B', 0, 3, 2420),
(585, '比亚迪F3', NULL, 201, 0, NULL, 'B', 0, 3, 1594),
(586, '比亚迪F3DM', NULL, 201, 0, NULL, 'B', 0, 3, 2618),
(587, '比亚迪F3R', NULL, 201, 0, NULL, 'B', 0, 3, 1595),
(588, '比亚迪F6', NULL, 201, 0, NULL, 'B', 0, 3, 1596),
(589, '比亚迪G3', NULL, 201, 0, NULL, 'B', 0, 3, 2834),
(590, '比亚迪G3R', NULL, 201, 0, NULL, 'B', 0, 3, 3318),
(591, '比亚迪G6', NULL, 201, 0, NULL, 'B', 0, 3, 3278),
(592, '比亚迪L3', NULL, 201, 0, NULL, 'B', 0, 3, 2971),
(593, '比亚迪M6', NULL, 201, 0, NULL, 'B', 0, 3, 2836),
(594, '比亚迪S6', NULL, 201, 0, NULL, 'B', 0, 3, 2929),
(595, '比亚迪S8', NULL, 201, 0, NULL, 'B', 0, 3, 2335),
(596, '福莱尔', NULL, 201, 0, NULL, 'B', 0, 3, 1592),
(597, '秦', NULL, 201, 0, NULL, 'B', 0, 3, 3661),
(598, '思锐', NULL, 201, 0, NULL, 'B', 0, 3, 3806),
(599, '速锐', NULL, 201, 0, NULL, 'B', 0, 3, 3772),
(600, '艾力绅', NULL, 202, 0, NULL, 'B', 0, 3, 3701),
(601, '本田CR-V', NULL, 202, 0, NULL, 'B', 0, 3, 1660),
(602, '杰德', NULL, 202, 0, NULL, 'B', 0, 3, 3721),
(603, '思铂睿', NULL, 202, 0, NULL, 'B', 0, 3, 2780),
(604, '思铭', NULL, 202, 0, NULL, 'B', 0, 3, 3532),
(605, '思域', NULL, 202, 0, NULL, 'B', 0, 3, 1661),
(606, '奥德赛', NULL, 203, 0, NULL, 'B', 0, 3, 2750),
(607, '飞度', NULL, 203, 0, NULL, 'B', 0, 3, 2408),
(608, '锋范', NULL, 203, 0, NULL, 'B', 0, 3, 2606),
(609, '歌诗图', NULL, 203, 0, NULL, 'B', 0, 3, 2993),
(610, '凌派', NULL, 203, 0, NULL, 'B', 0, 3, 3720),
(611, '思迪', NULL, 203, 0, NULL, 'B', 0, 3, 1708),
(612, '雅阁', NULL, 203, 0, NULL, 'B', 0, 3, 2406),
(613, '本田CR-V(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 1997),
(614, '本田CR-Z(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2931),
(615, '本田阿柯德(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2519),
(616, '本田奥德赛(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2520),
(617, '本田时韵(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2049),
(618, '本田雅阁(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2521),
(619, '本田元素(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 1999),
(620, '里程(海外)', NULL, 204, 0, NULL, 'B', 0, 3, 2050),
(621, '思域(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2051),
(622, '音赛特(进口)', NULL, 204, 0, NULL, 'B', 0, 3, 2722),
(623, '奔腾B50', NULL, 205, 0, NULL, 'B', 0, 3, 2677),
(624, '奔腾B70', NULL, 205, 0, NULL, 'B', 0, 3, 1918),
(625, '奔腾B90', NULL, 205, 0, NULL, 'B', 0, 3, 3369),
(626, '奔腾X80', NULL, 205, 0, NULL, 'B', 0, 3, 3453),
(627, '霸道', NULL, 206, 0, NULL, 'B', 0, 3, 2984),
(628, '菱惠', NULL, 206, 0, NULL, 'B', 0, 3, 1960),
(629, '菱骏', NULL, 206, 0, NULL, 'B', 0, 3, 1958),
(630, '菱麒', NULL, 206, 0, NULL, 'B', 0, 3, 1959),
(631, '天马座', NULL, 206, 0, NULL, 'B', 0, 3, 1795),
(632, '保时捷911', NULL, 207, 0, NULL, 'B', 0, 3, 2045),
(633, '保时捷918', NULL, 207, 0, NULL, 'B', 0, 3, 3045),
(634, '保时捷Boxster', NULL, 207, 0, NULL, 'B', 0, 3, 2044),
(635, '保时捷Cayenne', NULL, 207, 0, NULL, 'B', 0, 3, 2046),
(636, '保时捷Cayman', NULL, 207, 0, NULL, 'B', 0, 3, 2267),
(637, '保时捷Macan', NULL, 207, 0, NULL, 'B', 0, 3, 3787),
(638, '保时捷Panamera', NULL, 207, 0, NULL, 'B', 0, 3, 2629),
(639, '宾利Arnage', NULL, 208, 0, NULL, 'B', 0, 3, 2079),
(640, '飞驰', NULL, 208, 0, NULL, 'B', 0, 3, 3859),
(641, '慕尚', NULL, 208, 0, NULL, 'B', 0, 3, 3044),
(642, '欧陆', NULL, 208, 0, NULL, 'B', 0, 3, 2078),
(643, '雅骏', NULL, 208, 0, NULL, 'B', 0, 3, 1829),
(644, '昂科拉', NULL, 209, 0, NULL, 'B', 0, 3, 3600),
(645, '别克', NULL, 209, 0, NULL, 'B', 0, 3, 2522),
(646, '别克GL8', NULL, 209, 0, NULL, 'B', 0, 3, 1825),
(647, '君威', NULL, 209, 0, NULL, 'B', 0, 3, 2614),
(648, '君越', NULL, 209, 0, NULL, 'B', 0, 3, 2731),
(649, '凯越', NULL, 209, 0, NULL, 'B', 0, 3, 2388),
(650, '凯越HRV', NULL, 209, 0, NULL, 'B', 0, 3, 2211),
(651, '凯越旅行车', NULL, 209, 0, NULL, 'B', 0, 3, 2212),
(652, '林荫大道', NULL, 209, 0, NULL, 'B', 0, 3, 1703),
(653, '荣御', NULL, 209, 0, NULL, 'B', 0, 3, 1826),
(654, '赛欧', NULL, 209, 0, NULL, 'B', 0, 3, 1823),
(655, '英朗GT', NULL, 209, 0, NULL, 'B', 0, 3, 2945),
(656, '英朗XT', NULL, 209, 0, NULL, 'B', 0, 3, 2862),
(657, '昂科雷(进口)', NULL, 210, 0, NULL, 'B', 0, 3, 2601),
(658, '林荫大道', NULL, 210, 0, NULL, 'B', 0, 3, 3267),
(659, '世纪', NULL, 210, 0, NULL, 'B', 0, 3, 2639),
(660, '威航', NULL, 211, 0, NULL, 'B', 0, 3, 2735),
(661, '宝骏610', NULL, 212, 0, NULL, 'B', 0, 3, 4164),
(662, '宝骏630', NULL, 212, 0, NULL, 'B', 0, 3, 3301),
(663, '乐驰', NULL, 212, 0, NULL, 'B', 0, 3, 1851),
(664, '北京汽车BJ40', NULL, 213, 0, NULL, 'B', 0, 3, 2947),
(665, '北汽E系列两厢', NULL, 213, 0, NULL, 'B', 0, 3, 3424),
(666, '北汽E系列三厢', NULL, 213, 0, NULL, 'B', 0, 3, 3650),
(667, '北汽威旺205', NULL, 214, 0, NULL, 'B', 0, 3, 3809),
(668, '北汽威旺306', NULL, 214, 0, NULL, 'B', 0, 3, 3443),
(669, '北汽威旺307', NULL, 214, 0, NULL, 'B', 0, 3, 4082),
(670, '北汽威旺M20', NULL, 214, 0, NULL, 'B', 0, 3, 4014),
(671, 'BRABUS巴博斯 CLS级', NULL, 215, 0, NULL, 'B', 0, 3, 3595),
(672, 'BRABUS巴博斯 C级', NULL, 215, 0, NULL, 'B', 0, 3, 3597),
(673, 'BRABUS巴博斯 G级', NULL, 215, 0, NULL, 'B', 0, 3, 3598),
(674, 'BRABUS巴博斯 M级', NULL, 215, 0, NULL, 'B', 0, 3, 3594),
(675, 'BRABUS巴博斯 SLK级', NULL, 215, 0, NULL, 'B', 0, 3, 3961),
(676, 'BRABUS巴博斯 S级', NULL, 215, 0, NULL, 'B', 0, 3, 3596),
(677, '保斐利LA JOYA', NULL, 216, 0, NULL, 'B', 0, 3, 3776),
(678, '北汽幻速S2', NULL, 217, 0, NULL, 'B', 0, 3, 3771),
(679, '北汽幻速S3', NULL, 217, 0, NULL, 'B', 0, 3, 4119),
(680, '北汽E150EV', NULL, 218, 0, NULL, 'B', 0, 3, 4249),
(681, '长城C20R', NULL, 219, 0, NULL, 'C', 0, 3, 3383),
(682, '长城C30', NULL, 219, 0, NULL, 'C', 0, 3, 3023),
(683, '长城C50', NULL, 219, 0, NULL, 'C', 0, 3, 3103),
(684, '长城M2', NULL, 219, 0, NULL, 'C', 0, 3, 2866),
(685, '长城M4', NULL, 219, 0, NULL, 'C', 0, 3, 3382),
(686, '长城V80', NULL, 219, 0, NULL, 'C', 0, 3, 1650),
(687, '长城精灵', NULL, 219, 0, NULL, 'C', 0, 3, 1636),
(688, '大脚兽', NULL, 219, 0, NULL, 'C', 0, 3, 1645),
(689, '迪尔', NULL, 219, 0, NULL, 'C', 0, 3, 1644),
(690, '风骏5', NULL, 219, 0, NULL, 'C', 0, 3, 3263),
(691, '风骏6', NULL, 219, 0, NULL, 'C', 0, 3, 4181),
(692, '风骏房车', NULL, 219, 0, NULL, 'C', 0, 3, 3331),
(693, '金迪尔', NULL, 219, 0, NULL, 'C', 0, 3, 1635),
(694, '酷熊', NULL, 219, 0, NULL, 'C', 0, 3, 2683),
(695, '凌傲', NULL, 219, 0, NULL, 'C', 0, 3, 2767),
(696, '赛弗SUV', NULL, 219, 0, NULL, 'C', 0, 3, 1647),
(697, '赛骏', NULL, 219, 0, NULL, 'C', 0, 3, 1641),
(698, '赛酷皮卡', NULL, 219, 0, NULL, 'C', 0, 3, 1646),
(699, '赛铃皮卡', NULL, 219, 0, NULL, 'C', 0, 3, 1643),
(700, '赛影RUV', NULL, 219, 0, NULL, 'C', 0, 3, 1642),
(701, '炫丽', NULL, 219, 0, NULL, 'C', 0, 3, 2587),
(702, '炫丽CROSS', NULL, 219, 0, NULL, 'C', 0, 3, 2857),
(703, '爱迪尔', NULL, 220, 0, NULL, 'C', 0, 3, 1597),
(704, '爱迪尔Ⅱ', NULL, 220, 0, NULL, 'C', 0, 3, 2595),
(705, '昌河骏马', NULL, 220, 0, NULL, 'C', 0, 3, 1589),
(706, '昌河微型货车', NULL, 220, 0, NULL, 'C', 0, 3, 1600),
(707, '昌河新单双排', NULL, 220, 0, NULL, 'C', 0, 3, 2206),
(708, '昌铃王', NULL, 220, 0, NULL, 'C', 0, 3, 1609),
(709, '福瑞达', NULL, 220, 0, NULL, 'C', 0, 3, 1608),
(710, '福运', NULL, 220, 0, NULL, 'C', 0, 3, 3500),
(711, '海豚', NULL, 220, 0, NULL, 'C', 0, 3, 1598),
(712, '奔奔', NULL, 221, 0, NULL, 'C', 0, 3, 1978),
(713, '奔奔Mini', NULL, 221, 0, NULL, 'C', 0, 3, 2906),
(714, '长安CS35', NULL, 221, 0, NULL, 'C', 0, 3, 3660),
(715, '长安CS75', NULL, 221, 0, NULL, 'C', 0, 3, 3987),
(716, '长安CX20', NULL, 221, 0, NULL, 'C', 0, 3, 3261),
(717, '长安CX30两厢', NULL, 221, 0, NULL, 'C', 0, 3, 3061),
(718, '长安CX30三厢', NULL, 221, 0, NULL, 'C', 0, 3, 3304),
(719, '杰勋', NULL, 221, 0, NULL, 'C', 0, 3, 1633),
(720, '睿骋', NULL, 221, 0, NULL, 'C', 0, 3, 3511),
(721, '逸动', NULL, 221, 0, NULL, 'C', 0, 3, 3062),
(722, '悦翔', NULL, 221, 0, NULL, 'C', 0, 3, 2633),
(723, '悦翔V3', NULL, 221, 0, NULL, 'C', 0, 3, 3554),
(724, '悦翔V5', NULL, 221, 0, NULL, 'C', 0, 3, 3664),
(725, '悦翔两厢', NULL, 221, 0, NULL, 'C', 0, 3, 2846),
(726, '志翔', NULL, 221, 0, NULL, 'C', 0, 3, 2336),
(727, '致尚XT', NULL, 221, 0, NULL, 'C', 0, 3, 3814),
(728, '长安CM8', NULL, 222, 0, NULL, 'C', 0, 3, 1628),
(729, '长安镭蒙', NULL, 222, 0, NULL, 'C', 0, 3, 1627),
(730, '长安欧诺', NULL, 222, 0, NULL, 'C', 0, 3, 3523),
(731, '长安睿行', NULL, 222, 0, NULL, 'C', 0, 3, 4054),
(732, '长安神骐', NULL, 222, 0, NULL, 'C', 0, 3, 3823),
(733, '长安小卡', NULL, 222, 0, NULL, 'C', 0, 3, 2491),
(734, '长安星光', NULL, 222, 0, NULL, 'C', 0, 3, 1632),
(735, '长安星光4500', NULL, 222, 0, NULL, 'C', 0, 3, 3178),
(736, '长安星卡', NULL, 222, 0, NULL, 'C', 0, 3, 2214),
(737, '长安雪虎', NULL, 222, 0, NULL, 'C', 0, 3, 1626),
(738, '长安运通', NULL, 222, 0, NULL, 'C', 0, 3, 1630),
(739, '长安之星', NULL, 222, 0, NULL, 'C', 0, 3, 1634),
(740, '长安之星2', NULL, 222, 0, NULL, 'C', 0, 3, 3223),
(741, '长安之星7', NULL, 222, 0, NULL, 'C', 0, 3, 3299),
(742, '长安尊行', NULL, 222, 0, NULL, 'C', 0, 3, 4055),
(743, '欧力威', NULL, 222, 0, NULL, 'C', 0, 3, 3807),
(744, '勋龙', NULL, 222, 0, NULL, 'C', 0, 3, 3363),
(745, 'POLO劲情', NULL, 223, 0, NULL, 'D', 0, 3, 1810),
(746, '大众CrossPOLO', NULL, 223, 0, NULL, 'D', 0, 3, 2256),
(747, '大众POLO', NULL, 223, 0, NULL, 'D', 0, 3, 1798),
(748, '大众POLO GTI', NULL, 223, 0, NULL, 'D', 0, 3, 3221),
(749, '大众POLO劲取', NULL, 223, 0, NULL, 'D', 0, 3, 1802),
(750, '高尔', NULL, 223, 0, NULL, 'D', 0, 3, 1797),
(751, '朗境', NULL, 223, 0, NULL, 'D', 0, 3, 4023),
(752, '朗行', NULL, 223, 0, NULL, 'D', 0, 3, 3879),
(753, '朗逸', NULL, 223, 0, NULL, 'D', 0, 3, 2370),
(754, '帕萨特', NULL, 223, 0, NULL, 'D', 0, 3, 1796),
(755, '帕萨特领驭', NULL, 223, 0, NULL, 'D', 0, 3, 2776),
(756, '桑塔纳', NULL, 223, 0, NULL, 'D', 0, 3, 1793),
(757, '桑塔纳2000', NULL, 223, 0, NULL, 'D', 0, 3, 1801),
(758, '桑塔纳3000', NULL, 223, 0, NULL, 'D', 0, 3, 1800),
(759, '桑塔纳志俊', NULL, 223, 0, NULL, 'D', 0, 3, 2285),
(760, '途安', NULL, 223, 0, NULL, 'D', 0, 3, 1799),
(761, '途观', NULL, 223, 0, NULL, 'D', 0, 3, 2871),
(762, '宝来', NULL, 224, 0, NULL, 'D', 0, 3, 2381),
(763, '宝来两厢', NULL, 224, 0, NULL, 'D', 0, 3, 1910),
(764, '高尔夫', NULL, 224, 0, NULL, 'D', 0, 3, 2714),
(765, '高尔夫GTI', NULL, 224, 0, NULL, 'D', 0, 3, 2875),
(766, '捷达', NULL, 224, 0, NULL, 'D', 0, 3, 1905),
(767, '开迪', NULL, 224, 0, NULL, 'D', 0, 3, 1908),
(768, '迈腾', NULL, 224, 0, NULL, 'D', 0, 3, 1909),
(769, '速腾', NULL, 224, 0, NULL, 'D', 0, 3, 1765),
(770, '一汽-大众CC', NULL, 224, 0, NULL, 'D', 0, 3, 2932),
(771, 'PASSAT(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 3608),
(772, 'Tiguan', NULL, 225, 0, NULL, 'D', 0, 3, 2373),
(773, '大众 R36(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2378),
(774, '大众CC(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2377),
(775, '大众Eos(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2380),
(776, '大众迈特威(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2379),
(777, '高尔夫(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 3509),
(778, '高尔夫GTI(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 1863),
(779, '高尔夫Plus', NULL, 225, 0, NULL, 'D', 0, 3, 4038),
(780, '辉腾(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2065),
(781, '甲壳虫(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2061),
(782, '凯路威', NULL, 225, 0, NULL, 'D', 0, 3, 4152),
(783, '迈腾（进口）', NULL, 225, 0, NULL, 'D', 0, 3, 2062),
(784, '尚酷(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2610),
(785, '途锐(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2064),
(786, '夏朗(进口)', NULL, 225, 0, NULL, 'D', 0, 3, 2063),
(787, '东风小王子', NULL, 226, 0, NULL, 'D', 0, 3, 1669),
(788, '猛士', NULL, 226, 0, NULL, 'D', 0, 3, 3046),
(789, '桑蒂雅', NULL, 226, 0, NULL, 'D', 0, 3, 1668),
(790, '东风EQ6580ST系列', NULL, 227, 0, NULL, 'D', 0, 3, 3951),
(791, 'V3菱悦', NULL, 228, 0, NULL, 'D', 0, 3, 2553),
(792, 'V5菱致', NULL, 228, 0, NULL, 'D', 0, 3, 3643),
(793, 'V6菱仕', NULL, 228, 0, NULL, 'D', 0, 3, 3659),
(794, '得利卡', NULL, 228, 0, NULL, 'D', 0, 3, 1687),
(795, '富利卡', NULL, 228, 0, NULL, 'D', 0, 3, 1637),
(796, '菱利', NULL, 228, 0, NULL, 'D', 0, 3, 1688),
(797, '菱帅', NULL, 228, 0, NULL, 'D', 0, 3, 1685),
(798, '希旺', NULL, 228, 0, NULL, 'D', 0, 3, 3024),
(799, '奥顺皮卡', NULL, 229, 0, NULL, 'D', 0, 3, 2224),
(800, '霸道SUV', NULL, 229, 0, NULL, 'D', 0, 3, 2220),
(801, '大迪皮卡', NULL, 229, 0, NULL, 'D', 0, 3, 2493),
(802, '都市骏马SUV', NULL, 229, 0, NULL, 'D', 0, 3, 1943),
(803, '都市威菱SUV', NULL, 229, 0, NULL, 'D', 0, 3, 1944),
(804, '福顺皮卡', NULL, 229, 0, NULL, 'D', 0, 3, 2222),
(805, '豪顺皮卡', NULL, 229, 0, NULL, 'D', 0, 3, 2223),
(806, '顺驰皮卡', NULL, 229, 0, NULL, 'D', 0, 3, 2221),
(807, '大宇典雅(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2524),
(808, '大宇贵族2000型(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2525),
(809, '大宇蓝龙(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2173),
(810, '大宇蓝天(爱斯皮罗)(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2526),
(811, '大宇旅行家(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2174),
(812, '大宇赛手(雷瑟)(进口)', NULL, 230, 0, NULL, 'D', 0, 3, 2527),
(813, '马蒂兹', NULL, 230, 0, NULL, 'D', 0, 3, 2815),
(814, '凯领', NULL, 231, 0, NULL, 'D', 0, 3, 2325),
(815, '锋哲(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 2353),
(816, '公羊(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 2116),
(817, '凯领(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 2398),
(818, '酷搏(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 2352),
(819, '酷威(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 2690),
(820, '拓荒者(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 1983),
(821, '翼龙(进口)', NULL, 232, 0, NULL, 'D', 0, 3, 1780),
(822, '风行CM7', NULL, 233, 0, NULL, 'D', 0, 3, 3945),
(823, '景逸', NULL, 233, 0, NULL, 'D', 0, 3, 2385),
(824, '景逸SUV', NULL, 233, 0, NULL, 'D', 0, 3, 3639),
(825, '景逸X3', NULL, 233, 0, NULL, 'D', 0, 3, 4150),
(826, '景逸X5', NULL, 233, 0, NULL, 'D', 0, 3, 4015),
(827, '菱智', NULL, 233, 0, NULL, 'D', 0, 3, 2384),
(828, 'H30 Cross', NULL, 234, 0, NULL, 'D', 0, 3, 3192),
(829, '风神A60', NULL, 234, 0, NULL, 'D', 0, 3, 3049),
(830, '风神H30', NULL, 234, 0, NULL, 'D', 0, 3, 2872),
(831, '风神S30', NULL, 234, 0, NULL, 'D', 0, 3, 2730),
(832, 'DS 5', NULL, 235, 0, NULL, 'D', 0, 3, 3386),
(833, 'DS 5LS', NULL, 235, 0, NULL, 'D', 0, 3, 4093),
(834, 'DS 5(进口)', NULL, 236, 0, NULL, 'D', 0, 3, 3755),
(835, 'DS3(进口)', NULL, 236, 0, NULL, 'D', 0, 3, 2975),
(836, 'DS4(进口)', NULL, 236, 0, NULL, 'D', 0, 3, 3227),
(837, '奥丁', NULL, 237, 0, NULL, 'D', 0, 3, 1861),
(838, '俊风', NULL, 237, 0, NULL, 'D', 0, 3, 4069),
(839, '锐骐皮卡', NULL, 237, 0, NULL, 'D', 0, 3, 2679),
(840, '锐骐厢式车', NULL, 237, 0, NULL, 'D', 0, 3, 2678),
(841, '帅客', NULL, 237, 0, NULL, 'D', 0, 3, 2856),
(842, '御轩', NULL, 237, 0, NULL, 'D', 0, 3, 1924),
(843, '东风小康C35', NULL, 238, 0, NULL, 'D', 0, 3, 3869),
(844, '东风小康C36', NULL, 238, 0, NULL, 'D', 0, 3, 4246),
(845, '东风小康C37', NULL, 238, 0, NULL, 'D', 0, 3, 3607),
(846, '东风小康K01', NULL, 238, 0, NULL, 'D', 0, 3, 1967),
(847, '东风小康K02', NULL, 238, 0, NULL, 'D', 0, 3, 3255),
(848, '东风小康K07', NULL, 238, 0, NULL, 'D', 0, 3, 3257),
(849, '东风小康K07Ⅱ', NULL, 238, 0, NULL, 'D', 0, 3, 3258),
(850, '东风小康K17', NULL, 238, 0, NULL, 'D', 0, 3, 3259),
(851, '东风小康V07s', NULL, 238, 0, NULL, 'D', 0, 3, 3536),
(852, '东风小康V21', NULL, 238, 0, NULL, 'D', 0, 3, 3535),
(853, '东风小康V22', NULL, 238, 0, NULL, 'D', 0, 3, 3533),
(854, '东风小康V26', NULL, 238, 0, NULL, 'D', 0, 3, 3808),
(855, '东风小康V27', NULL, 238, 0, NULL, 'D', 0, 3, 3260),
(856, '东风小康V29', NULL, 238, 0, NULL, 'D', 0, 3, 3734),
(857, '风光', NULL, 238, 0, NULL, 'D', 0, 3, 3909),
(858, '风光330', NULL, 238, 0, NULL, 'D', 0, 3, 4253),
(859, '风光350', NULL, 238, 0, NULL, 'D', 0, 3, 4255),
(860, '御风物流车', NULL, 239, 0, NULL, 'D', 0, 3, 4240),
(861, '御风载客车', NULL, 239, 0, NULL, 'D', 0, 3, 4241),
(862, 'YARiS L 致炫', NULL, 240, 0, NULL, 'F', 0, 3, 4016),
(863, '汉兰达', NULL, 240, 0, NULL, 'F', 0, 3, 2694),
(864, '凯美瑞', NULL, 240, 0, NULL, 'F', 0, 3, 1991),
(865, '凯美瑞Hybrid', NULL, 240, 0, NULL, 'F', 0, 3, 2980),
(866, '雷凌', NULL, 240, 0, NULL, 'F', 0, 3, 4190),
(867, '雅力士', NULL, 240, 0, NULL, 'F', 0, 3, 2289),
(868, '逸致', NULL, 240, 0, NULL, 'F', 0, 3, 3303),
(869, '花冠', NULL, 241, 0, NULL, 'F', 0, 3, 1871),
(870, '皇冠', NULL, 241, 0, NULL, 'F', 0, 3, 2848),
(871, '卡罗拉', NULL, 241, 0, NULL, 'F', 0, 3, 1879),
(872, '柯斯达', NULL, 241, 0, NULL, 'F', 0, 3, 1869),
(873, '兰德酷路泽', NULL, 241, 0, NULL, 'F', 0, 3, 1911),
(874, '陆地巡洋舰', NULL, 241, 0, NULL, 'F', 0, 3, 2502),
(875, '普拉多', NULL, 241, 0, NULL, 'F', 0, 3, 1868),
(876, '普锐斯', NULL, 241, 0, NULL, 'F', 0, 3, 1873),
(877, '锐志', NULL, 241, 0, NULL, 'F', 0, 3, 1977),
(878, '特锐', NULL, 241, 0, NULL, 'F', 0, 3, 1912),
(879, '威驰', NULL, 241, 0, NULL, 'F', 0, 3, 2407),
(880, '一汽丰田RAV4', NULL, 241, 0, NULL, 'F', 0, 3, 2701),
(881, '4Runner', NULL, 242, 0, NULL, 'F', 0, 3, 3265),
(882, 'FJ酷路泽(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2002),
(883, 'Sienna(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2494),
(884, '埃尔法(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 3088),
(885, '丰田86', NULL, 242, 0, NULL, 'F', 0, 3, 3840),
(886, '丰田MR2(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2135),
(887, '丰田RAV4(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2137),
(888, '丰田Wish', NULL, 242, 0, NULL, 'F', 0, 3, 3354),
(889, '丰田海狮(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 1738),
(890, '丰田汉兰达(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2004),
(891, '丰田皇冠(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2531),
(892, '丰田佳美(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2132),
(893, '丰田皮卡(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2532);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(894, '丰田赛利卡(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2495),
(895, '丰田亚洲龙(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2138),
(896, '富隆', NULL, 242, 0, NULL, 'F', 0, 3, 4254),
(897, '海拉克斯(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2813),
(898, '红杉(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 1830),
(899, '花冠(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2638),
(900, '杰路驰(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 3338),
(901, '考斯特(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2003),
(902, '陆地巡洋舰(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2395),
(903, '普拉多(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2131),
(904, '普瑞维亚(进口)', NULL, 242, 0, NULL, 'F', 0, 3, 2134),
(905, '威飒', NULL, 242, 0, NULL, 'F', 0, 3, 2775),
(906, '福克斯两厢', NULL, 243, 0, NULL, 'F', 0, 3, 2273),
(907, '福克斯三厢', NULL, 243, 0, NULL, 'F', 0, 3, 1611),
(908, '嘉年华两厢', NULL, 243, 0, NULL, 'F', 0, 3, 2609),
(909, '嘉年华三厢', NULL, 243, 0, NULL, 'F', 0, 3, 2627),
(910, '麦柯斯', NULL, 243, 0, NULL, 'F', 0, 3, 1603),
(911, '蒙迪欧-致胜', NULL, 243, 0, NULL, 'F', 0, 3, 1615),
(912, '新蒙迪欧', NULL, 243, 0, NULL, 'F', 0, 3, 1610),
(913, '翼搏', NULL, 243, 0, NULL, 'F', 0, 3, 3698),
(914, '翼虎', NULL, 243, 0, NULL, 'F', 0, 3, 3635),
(915, '致胜', NULL, 243, 0, NULL, 'F', 0, 3, 4052),
(916, 'Flex(海外)', NULL, 244, 0, NULL, 'F', 0, 3, 2584),
(917, 'F系列', NULL, 244, 0, NULL, 'F', 0, 3, 3249),
(918, '福克斯(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 2967),
(919, '福特E系列(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 2485),
(920, '福特探险者', NULL, 244, 0, NULL, 'F', 0, 3, 2497),
(921, '福特天霸(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 2533),
(922, '福特外交官(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 1831),
(923, '嘉年华（进口）', NULL, 244, 0, NULL, 'F', 0, 3, 3866),
(924, '金牛座', NULL, 244, 0, NULL, 'F', 0, 3, 2689),
(925, '蒙迪欧', NULL, 244, 0, NULL, 'F', 0, 3, 2991),
(926, '锐界(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 2596),
(927, '水星', NULL, 244, 0, NULL, 'F', 0, 3, 2819),
(928, '稳达', NULL, 244, 0, NULL, 'F', 0, 3, 2992),
(929, '野马', NULL, 244, 0, NULL, 'F', 0, 3, 2498),
(930, '翼虎(进口)', NULL, 244, 0, NULL, 'F', 0, 3, 2150),
(931, '征服者', NULL, 244, 0, NULL, 'F', 0, 3, 3828),
(932, '菲翔', NULL, 245, 0, NULL, 'F', 0, 3, 3589),
(933, '致悦', NULL, 245, 0, NULL, 'F', 0, 3, 4072),
(934, '派朗', NULL, 246, 0, NULL, 'F', 0, 3, 1774),
(935, '派力奥', NULL, 246, 0, NULL, 'F', 0, 3, 1771),
(936, '西耶那', NULL, 246, 0, NULL, 'F', 0, 3, 1772),
(937, '周末风', NULL, 246, 0, NULL, 'F', 0, 3, 1773),
(938, '博悦(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2421),
(939, '德特乐福斯(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2001),
(940, '多能', NULL, 247, 0, NULL, 'F', 0, 3, 2810),
(941, '菲亚特500(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2770),
(942, '菲亚特Doblo(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2118),
(943, '菲亚特Stilo(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2117),
(944, '菲亚特乌诺(Uno)(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2549),
(945, '菲跃(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 3546),
(946, '柯罗马(进口)', NULL, 247, 0, NULL, 'F', 0, 3, 2538),
(947, '领雅', NULL, 247, 0, NULL, 'F', 0, 3, 2422),
(948, '马力昂', NULL, 247, 0, NULL, 'F', 0, 3, 2989),
(949, '朋多', NULL, 247, 0, NULL, 'F', 0, 3, 2423),
(950, '海酷(进口)', NULL, 248, 0, NULL, 'F', 0, 3, 2535),
(951, '财富', NULL, 249, 0, NULL, 'F', 0, 3, 2997),
(952, '富奇', NULL, 249, 0, NULL, 'F', 0, 3, 2998),
(953, '海马柯', NULL, 249, 0, NULL, 'F', 0, 3, 2999),
(954, '驭虎', NULL, 249, 0, NULL, 'F', 0, 3, 1931),
(955, '飞越SRV', NULL, 250, 0, NULL, 'F', 0, 3, 1946),
(956, '福迪1021皮卡', NULL, 250, 0, NULL, 'F', 0, 3, 1951),
(957, '福迪四驱皮卡', NULL, 250, 0, NULL, 'F', 0, 3, 3480),
(958, '福迪小超人皮卡', NULL, 250, 0, NULL, 'F', 0, 3, 1950),
(959, '福迪雄狮皮卡', NULL, 250, 0, NULL, 'F', 0, 3, 1949),
(960, '探索者Ⅱ', NULL, 250, 0, NULL, 'F', 0, 3, 1948),
(961, '探索者Ⅲ', NULL, 250, 0, NULL, 'F', 0, 3, 1952),
(962, '探索者6', NULL, 250, 0, NULL, 'F', 0, 3, 3352),
(963, '探索者I', NULL, 250, 0, NULL, 'F', 0, 3, 1947),
(964, '雄狮F16皮卡', NULL, 250, 0, NULL, 'F', 0, 3, 3804),
(965, '360 Modena(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2123),
(966, '575M Maranello(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2124),
(967, '612 Scaglietti(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2121),
(968, 'F12 berlinetta(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 3640),
(969, '法拉利456M(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2125),
(970, '法拉利458(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2956),
(971, '法拉利599(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2248),
(972, '法拉利California', NULL, 251, 0, NULL, 'F', 0, 3, 2716),
(973, '法拉利F430(进口)', NULL, 251, 0, NULL, 'F', 0, 3, 2122),
(974, '法拉利FF', NULL, 251, 0, NULL, 'F', 0, 3, 3364),
(975, '奥铃CTX', NULL, 252, 0, NULL, 'F', 0, 3, 1586),
(976, '奥铃TX', NULL, 252, 0, NULL, 'F', 0, 3, 3757),
(977, '奥铃捷运', NULL, 252, 0, NULL, 'F', 0, 3, 3758),
(978, '传奇X', NULL, 252, 0, NULL, 'F', 0, 3, 1591),
(979, '风景冲浪', NULL, 252, 0, NULL, 'F', 0, 3, 1584),
(980, '风景快捷', NULL, 252, 0, NULL, 'F', 0, 3, 3353),
(981, '风景快客', NULL, 252, 0, NULL, 'F', 0, 3, 2326),
(982, '风景快运', NULL, 252, 0, NULL, 'F', 0, 3, 1587),
(983, '海狮', NULL, 252, 0, NULL, 'F', 0, 3, 1583),
(984, '蒙派克E', NULL, 252, 0, NULL, 'F', 0, 3, 2424),
(985, '蒙派克S', NULL, 252, 0, NULL, 'F', 0, 3, 3957),
(986, '迷迪', NULL, 252, 0, NULL, 'F', 0, 3, 2672),
(987, '欧马可', NULL, 252, 0, NULL, 'F', 0, 3, 3283),
(988, '欧曼', NULL, 252, 0, NULL, 'F', 0, 3, 3749),
(989, '轻型多用途车', NULL, 252, 0, NULL, 'F', 0, 3, 4251),
(990, '瑞沃工程用车', NULL, 252, 0, NULL, 'F', 0, 3, 4186),
(991, '萨普', NULL, 252, 0, NULL, 'F', 0, 3, 2802),
(992, '时代康瑞', NULL, 252, 0, NULL, 'F', 0, 3, 4260),
(993, '时代领航', NULL, 252, 0, NULL, 'F', 0, 3, 4261),
(994, '时代微卡', NULL, 252, 0, NULL, 'F', 0, 3, 4262),
(995, '时代骁运', NULL, 252, 0, NULL, 'F', 0, 3, 4252),
(996, '时代驭菱', NULL, 252, 0, NULL, 'F', 0, 3, 4263),
(997, '拓陆者', NULL, 252, 0, NULL, 'F', 0, 3, 3746),
(998, '小型多用途车', NULL, 252, 0, NULL, 'F', 0, 3, 4250),
(999, '新风景G7', NULL, 252, 0, NULL, 'F', 0, 3, 4239),
(1000, '公路客运', NULL, 253, 0, NULL, 'F', 0, 3, 3741),
(1001, '旅游客车', NULL, 253, 0, NULL, 'F', 0, 3, 3740),
(1002, '专用客车', NULL, 253, 0, NULL, 'F', 0, 3, 3742),
(1003, '陆陆威威', NULL, 254, 0, NULL, 'F', 0, 3, 3266),
(1004, 'Evantra', NULL, 255, 0, NULL, 'F', 0, 3, 3831),
(1005, '斯宾特', NULL, 256, 0, NULL, 'F', 0, 3, 3955),
(1006, '威霆', NULL, 256, 0, NULL, 'F', 0, 3, 3956),
(1007, '启腾 M70', NULL, 257, 0, NULL, 'F', 0, 3, 4107),
(1008, '奥轩G3', NULL, 258, 0, NULL, 'G', 0, 3, 3138),
(1009, '奥轩G5', NULL, 258, 0, NULL, 'G', 0, 3, 3298),
(1010, '奥轩GX5', NULL, 258, 0, NULL, 'G', 0, 3, 2653),
(1011, '财运100', NULL, 258, 0, NULL, 'G', 0, 3, 2228),
(1012, '财运300', NULL, 258, 0, NULL, 'G', 0, 3, 2225),
(1013, '财运500', NULL, 258, 0, NULL, 'G', 0, 3, 3747),
(1014, '柴神', NULL, 258, 0, NULL, 'G', 0, 3, 2919),
(1015, '吉奥E美', NULL, 258, 0, NULL, 'G', 0, 3, 4096),
(1016, '吉奥GS50', NULL, 258, 0, NULL, 'G', 0, 3, 2229),
(1017, '吉奥GX6', NULL, 258, 0, NULL, 'G', 0, 3, 1935),
(1018, '凯睿', NULL, 258, 0, NULL, 'G', 0, 3, 2226),
(1019, '猛将旅', NULL, 258, 0, NULL, 'G', 0, 3, 1936),
(1020, '帅豹', NULL, 258, 0, NULL, 'G', 0, 3, 2341),
(1021, '帅驰', NULL, 258, 0, NULL, 'G', 0, 3, 2801),
(1022, '帅舰', NULL, 258, 0, NULL, 'G', 0, 3, 2227),
(1023, '帅凌', NULL, 258, 0, NULL, 'G', 0, 3, 2344),
(1024, '帅威', NULL, 258, 0, NULL, 'G', 0, 3, 2343),
(1025, '星朗', NULL, 258, 0, NULL, 'G', 0, 3, 4010),
(1026, '星旺', NULL, 258, 0, NULL, 'G', 0, 3, 2917),
(1027, '星旺CL', NULL, 258, 0, NULL, 'G', 0, 3, 3968),
(1028, '星旺L', NULL, 258, 0, NULL, 'G', 0, 3, 3969),
(1029, '星旺M1', NULL, 258, 0, NULL, 'G', 0, 3, 3970),
(1030, '星旺M2', NULL, 258, 0, NULL, 'G', 0, 3, 3971),
(1031, '伊美', NULL, 258, 0, NULL, 'G', 0, 3, 3015),
(1032, 'GMC(进口)', NULL, 259, 0, NULL, 'G', 0, 3, 2331),
(1033, '大蛇(进口)', NULL, 260, 0, NULL, 'G', 0, 3, 3093),
(1034, '嘉路(进口)', NULL, 260, 0, NULL, 'G', 0, 3, 2188),
(1035, '女王(进口)', NULL, 260, 0, NULL, 'G', 0, 3, 3094),
(1036, '270Y系列', NULL, 261, 0, NULL, 'G', 0, 3, 2680),
(1037, '300J系列', NULL, 261, 0, NULL, 'G', 0, 3, 2682),
(1038, '320D系列', NULL, 261, 0, NULL, 'G', 0, 3, 2681),
(1039, '传祺GA3', NULL, 262, 0, NULL, 'G', 0, 3, 3880),
(1040, '传祺GA5', NULL, 262, 0, NULL, 'G', 0, 3, 3222),
(1041, '传祺GS5', NULL, 262, 0, NULL, 'G', 0, 3, 2876),
(1042, '观致3', NULL, 263, 0, NULL, 'G', 0, 3, 3834),
(1043, '观致3 五门版', NULL, 263, 0, NULL, 'G', 0, 3, 4113),
(1044, '百利', NULL, 264, 0, NULL, 'H', 0, 3, 2516),
(1045, '哈飞单双排', NULL, 264, 0, NULL, 'H', 0, 3, 2240),
(1046, '骏意', NULL, 264, 0, NULL, 'H', 0, 3, 3506),
(1047, '路宝', NULL, 264, 0, NULL, 'H', 0, 3, 2233),
(1048, '路尊大霸王', NULL, 264, 0, NULL, 'H', 0, 3, 2699),
(1049, '路尊小霸王', NULL, 264, 0, NULL, 'H', 0, 3, 2760),
(1050, '民意', NULL, 264, 0, NULL, 'H', 0, 3, 2235),
(1051, '民意M408', NULL, 264, 0, NULL, 'H', 0, 3, 2234),
(1052, '民意单双排', NULL, 264, 0, NULL, 'H', 0, 3, 3958),
(1053, '民意一排半', NULL, 264, 0, NULL, 'H', 0, 3, 2239),
(1054, '普面', NULL, 264, 0, NULL, 'H', 0, 3, 1702),
(1055, '锐意', NULL, 264, 0, NULL, 'H', 0, 3, 1723),
(1056, '赛豹Ⅲ', NULL, 264, 0, NULL, 'H', 0, 3, 2232),
(1057, '赛豹V系', NULL, 264, 0, NULL, 'H', 0, 3, 1715),
(1058, '赛马', NULL, 264, 0, NULL, 'H', 0, 3, 1709),
(1059, '松花江', NULL, 264, 0, NULL, 'H', 0, 3, 2510),
(1060, '新民意', NULL, 264, 0, NULL, 'H', 0, 3, 3754),
(1061, '中意', NULL, 264, 0, NULL, 'H', 0, 3, 2238),
(1062, '中意单双排', NULL, 264, 0, NULL, 'H', 0, 3, 3959),
(1063, '福美来', NULL, 265, 0, NULL, 'H', 0, 3, 1724),
(1064, '福美来M5', NULL, 265, 0, NULL, 'H', 0, 3, 4092),
(1065, '福美来VS', NULL, 265, 0, NULL, 'H', 0, 3, 3493),
(1066, '海福星', NULL, 265, 0, NULL, 'H', 0, 3, 1665),
(1067, '海马3', NULL, 265, 0, NULL, 'H', 0, 3, 1726),
(1068, '海马M3', NULL, 265, 0, NULL, 'H', 0, 3, 3438),
(1069, '海马M8', NULL, 265, 0, NULL, 'H', 0, 3, 3662),
(1070, '海马S5', NULL, 265, 0, NULL, 'H', 0, 3, 4068),
(1071, '海马S7', NULL, 265, 0, NULL, 'H', 0, 3, 3916),
(1072, '海马旅行轿', NULL, 265, 0, NULL, 'H', 0, 3, 2636),
(1073, '海南马自达323', NULL, 265, 0, NULL, 'H', 0, 3, 2557),
(1074, '欢动', NULL, 265, 0, NULL, 'H', 0, 3, 2607),
(1075, '普力马', NULL, 265, 0, NULL, 'H', 0, 3, 2850),
(1076, '骑士', NULL, 265, 0, NULL, 'H', 0, 3, 2740),
(1077, '丘比特', NULL, 265, 0, NULL, 'H', 0, 3, 2868),
(1078, 'M203', NULL, 266, 0, NULL, 'H', 0, 3, 2346),
(1079, '飚风', NULL, 266, 0, NULL, 'H', 0, 3, 2345),
(1080, '海锋', NULL, 266, 0, NULL, 'H', 0, 3, 1573),
(1081, '海景', NULL, 266, 0, NULL, 'H', 0, 3, 3654),
(1082, '海尚', NULL, 266, 0, NULL, 'H', 0, 3, 1816),
(1083, '海炫', NULL, 266, 0, NULL, 'H', 0, 3, 2652),
(1084, '海迅', NULL, 266, 0, NULL, 'H', 0, 3, 1815),
(1085, '海域', NULL, 266, 0, NULL, 'H', 0, 3, 1814),
(1086, '海悦', NULL, 266, 0, NULL, 'H', 0, 3, 2590),
(1087, '杰士达美鹿', NULL, 266, 0, NULL, 'H', 0, 3, 2537),
(1088, '朗风', NULL, 266, 0, NULL, 'H', 0, 3, 2545),
(1089, '德驰', NULL, 267, 0, NULL, 'H', 0, 3, 2241),
(1090, '伊思坦纳', NULL, 267, 0, NULL, 'H', 0, 3, 1821),
(1091, '翱龙', NULL, 268, 0, NULL, 'H', 0, 3, 1865),
(1092, '翱龙CUV', NULL, 268, 0, NULL, 'H', 0, 3, 1717),
(1093, '翱龙SUV', NULL, 268, 0, NULL, 'H', 0, 3, 1866),
(1094, '傲骏', NULL, 268, 0, NULL, 'H', 0, 3, 2973),
(1095, '傲羚', NULL, 268, 0, NULL, 'H', 0, 3, 1718),
(1096, '傲龙CUV', NULL, 268, 0, NULL, 'H', 0, 3, 1704),
(1097, '大柴神', NULL, 268, 0, NULL, 'H', 0, 3, 1804),
(1098, '领航者', NULL, 268, 0, NULL, 'H', 0, 3, 1864),
(1099, '旗胜CUV', NULL, 268, 0, NULL, 'H', 0, 3, 1867),
(1100, '旗胜F1', NULL, 268, 0, NULL, 'H', 0, 3, 3489),
(1101, '旗胜V3', NULL, 268, 0, NULL, 'H', 0, 3, 3470),
(1102, '曙光骄子', NULL, 268, 0, NULL, 'H', 0, 3, 1859),
(1103, '挑战者', NULL, 268, 0, NULL, 'H', 0, 3, 1858),
(1104, '小柴神', NULL, 268, 0, NULL, 'H', 0, 3, 2197),
(1105, '征服者', NULL, 268, 0, NULL, 'H', 0, 3, 1860),
(1106, '红旗', NULL, 269, 0, NULL, 'H', 0, 3, 2340),
(1107, '红旗H7', NULL, 269, 0, NULL, 'H', 0, 3, 3695),
(1108, '红旗L5', NULL, 269, 0, NULL, 'H', 0, 3, 3941),
(1109, '红旗旗舰', NULL, 269, 0, NULL, 'H', 0, 3, 2339),
(1110, '红旗盛世', NULL, 269, 0, NULL, 'H', 0, 3, 1921),
(1111, '明仕', NULL, 269, 0, NULL, 'H', 0, 3, 1919),
(1112, '世纪星', NULL, 269, 0, NULL, 'H', 0, 3, 1915),
(1113, '金刚海狮', NULL, 270, 0, NULL, 'H', 0, 3, 1962),
(1114, '悍马H2(进口)', NULL, 271, 0, NULL, 'H', 0, 3, 2171),
(1115, '悍马H200(进口)', NULL, 271, 0, NULL, 'H', 0, 3, 2404),
(1116, '悍马H3(进口)', NULL, 271, 0, NULL, 'H', 0, 3, 2172),
(1117, '悍马H600(进口)', NULL, 271, 0, NULL, 'H', 0, 3, 2619),
(1118, '悍马悍霸', NULL, 271, 0, NULL, 'H', 0, 3, 2732),
(1119, '悍马加长版(进口)', NULL, 271, 0, NULL, 'H', 0, 3, 1954),
(1120, '勇士悍马', NULL, 271, 0, NULL, 'H', 0, 3, 2704),
(1121, '宝利格', NULL, 272, 0, NULL, 'H', 0, 3, 3432),
(1122, '华泰B11', NULL, 272, 0, NULL, 'H', 0, 3, 2976),
(1123, '吉田', NULL, 272, 0, NULL, 'H', 0, 3, 1742),
(1124, '路盛E70', NULL, 272, 0, NULL, 'H', 0, 3, 3041),
(1125, '圣达菲', NULL, 272, 0, NULL, 'H', 0, 3, 1743),
(1126, '特拉卡', NULL, 272, 0, NULL, 'H', 0, 3, 2265),
(1127, '轻型客车', NULL, 273, 0, NULL, 'H', 0, 3, 2431),
(1128, '黑豹', NULL, 274, 0, NULL, 'H', 0, 3, 2436),
(1129, '黑豹轿卡', NULL, 274, 0, NULL, 'H', 0, 3, 3017),
(1130, '旅行家', NULL, 274, 0, NULL, 'H', 0, 3, 3018),
(1131, '华阳客车', NULL, 275, 0, NULL, 'H', 0, 3, 2568),
(1132, '福卡', NULL, 276, 0, NULL, 'H', 0, 3, 3967),
(1133, '福仕达鸿达', NULL, 276, 0, NULL, 'H', 0, 3, 2773),
(1134, '福仕达荣达', NULL, 276, 0, NULL, 'H', 0, 3, 3441),
(1135, '福仕达新鸿达', NULL, 276, 0, NULL, 'H', 0, 3, 3739),
(1136, '福仕达新腾达', NULL, 276, 0, NULL, 'H', 0, 3, 3966),
(1137, '海马爱尚', NULL, 276, 0, NULL, 'H', 0, 3, 3437),
(1138, '海马王子', NULL, 276, 0, NULL, 'H', 0, 3, 2867),
(1139, '腾达', NULL, 276, 0, NULL, 'H', 0, 3, 3210),
(1140, '海格H5C', NULL, 277, 0, NULL, 'H', 0, 3, 3508),
(1141, '海格H5V', NULL, 277, 0, NULL, 'H', 0, 3, 4083),
(1142, '客卡', NULL, 277, 0, NULL, 'H', 0, 3, 3540),
(1143, '途腾T1', NULL, 278, 0, NULL, 'H', 0, 3, 3759),
(1144, '途腾T2', NULL, 278, 0, NULL, 'H', 0, 3, 3760),
(1145, '途腾T3', NULL, 278, 0, NULL, 'H', 0, 3, 4001),
(1146, '哈弗H2', NULL, 279, 0, NULL, 'H', 0, 3, 3887),
(1147, '哈弗H3', NULL, 279, 0, NULL, 'H', 0, 3, 1648),
(1148, '哈弗H5', NULL, 279, 0, NULL, 'H', 0, 3, 2865),
(1149, '哈弗H6', NULL, 279, 0, NULL, 'H', 0, 3, 3152),
(1150, '哈弗H8', NULL, 279, 0, NULL, 'H', 0, 3, 3694),
(1151, '哈弗M1', NULL, 279, 0, NULL, 'H', 0, 3, 2833),
(1152, '哈弗派', NULL, 279, 0, NULL, 'H', 0, 3, 2675),
(1153, 'Jeep2500', NULL, 280, 0, NULL, 'J', 0, 3, 1563),
(1154, '大切诺基', NULL, 281, 0, NULL, 'J', 0, 3, 1560),
(1155, '切诺基', NULL, 281, 0, NULL, 'J', 0, 3, 1565),
(1156, '大切诺基', NULL, 282, 0, NULL, 'J', 0, 3, 2007),
(1157, '牧马人', NULL, 282, 0, NULL, 'J', 0, 3, 2115),
(1158, '切诺基', NULL, 282, 0, NULL, 'J', 0, 3, 3000),
(1159, '指挥官(进口)', NULL, 282, 0, NULL, 'J', 0, 3, 2006),
(1160, '指南者', NULL, 282, 0, NULL, 'J', 0, 3, 1832),
(1161, '自由光', NULL, 282, 0, NULL, 'J', 0, 3, 3876),
(1162, '自由客', NULL, 282, 0, NULL, 'J', 0, 3, 3133),
(1163, '自由人(进口)', NULL, 282, 0, NULL, 'J', 0, 3, 2114),
(1164, '豪情', NULL, 283, 0, NULL, 'J', 0, 3, 1745),
(1165, '吉利EC8', NULL, 283, 0, NULL, 'J', 0, 3, 3066),
(1166, '吉利GC7', NULL, 283, 0, NULL, 'J', 0, 3, 3187),
(1167, '吉利GX7', NULL, 283, 0, NULL, 'J', 0, 3, 2937),
(1168, '吉利SC3', NULL, 283, 0, NULL, 'J', 0, 3, 3537),
(1169, '吉利SX7', NULL, 283, 0, NULL, 'J', 0, 3, 3644),
(1170, '吉利帝豪EC7', NULL, 283, 0, NULL, 'J', 0, 3, 2784),
(1171, '吉利帝豪EC7两厢', NULL, 283, 0, NULL, 'J', 0, 3, 2785),
(1172, '吉利海景', NULL, 283, 0, NULL, 'J', 0, 3, 2766),
(1173, '吉利金刚', NULL, 283, 0, NULL, 'J', 0, 3, 3067),
(1174, '吉利金刚2代', NULL, 283, 0, NULL, 'J', 0, 3, 2703),
(1175, '吉利金刚CROSS', NULL, 283, 0, NULL, 'J', 0, 3, 2417),
(1176, '吉利金刚两厢', NULL, 283, 0, NULL, 'J', 0, 3, 3293),
(1177, '吉利熊猫', NULL, 283, 0, NULL, 'J', 0, 3, 2598),
(1178, '吉利熊猫CROSS', NULL, 283, 0, NULL, 'J', 0, 3, 3143),
(1179, '吉利英伦TX4', NULL, 283, 0, NULL, 'J', 0, 3, 2743),
(1180, '吉利远景', NULL, 283, 0, NULL, 'J', 0, 3, 1734),
(1181, '吉利自由舰', NULL, 283, 0, NULL, 'J', 0, 3, 1748),
(1182, '金刚', NULL, 283, 0, NULL, 'J', 0, 3, 1666),
(1183, '美人豹', NULL, 283, 0, NULL, 'J', 0, 3, 1746),
(1184, '美日之星', NULL, 283, 0, NULL, 'J', 0, 3, 1744),
(1185, '全球鹰GX2', NULL, 283, 0, NULL, 'J', 0, 3, 3189),
(1186, '优利欧', NULL, 283, 0, NULL, 'J', 0, 3, 2399),
(1187, '中国龙', NULL, 283, 0, NULL, 'J', 0, 3, 2761),
(1188, '宾悦', NULL, 284, 0, NULL, 'J', 0, 3, 1755),
(1189, '和悦', NULL, 284, 0, NULL, 'J', 0, 3, 2708),
(1190, '和悦A13', NULL, 284, 0, NULL, 'J', 0, 3, 2585),
(1191, '和悦A13RS', NULL, 284, 0, NULL, 'J', 0, 3, 2692),
(1192, '和悦A30', NULL, 284, 0, NULL, 'J', 0, 3, 3937),
(1193, '和悦iEV', NULL, 284, 0, NULL, 'J', 0, 3, 4076),
(1194, '和悦RS', NULL, 284, 0, NULL, 'J', 0, 3, 2749),
(1195, '瑞风', NULL, 284, 0, NULL, 'J', 0, 3, 2251),
(1196, '瑞风M5', NULL, 284, 0, NULL, 'J', 0, 3, 3990),
(1197, '瑞风S5', NULL, 284, 0, NULL, 'J', 0, 3, 3697),
(1198, '瑞风改装车', NULL, 284, 0, NULL, 'J', 0, 3, 3738),
(1199, '瑞铃', NULL, 284, 0, NULL, 'J', 0, 3, 3530),
(1200, '瑞鹰', NULL, 284, 0, NULL, 'J', 0, 3, 1654),
(1201, '星锐', NULL, 284, 0, NULL, 'J', 0, 3, 3313),
(1202, '悦悦', NULL, 284, 0, NULL, 'J', 0, 3, 2949),
(1203, '安驰', NULL, 285, 0, NULL, 'J', 0, 3, 2426),
(1204, '杰豹', NULL, 285, 0, NULL, 'J', 0, 3, 2823),
(1205, '金牛', NULL, 285, 0, NULL, 'J', 0, 3, 2821),
(1206, '凌铃', NULL, 285, 0, NULL, 'J', 0, 3, 3515),
(1207, '瑞驰', NULL, 285, 0, NULL, 'J', 0, 3, 3516),
(1208, '威豹', NULL, 285, 0, NULL, 'J', 0, 3, 2825),
(1209, '微轿', NULL, 285, 0, NULL, 'J', 0, 3, 2826),
(1210, '雪豹X50', NULL, 285, 0, NULL, 'J', 0, 3, 2824),
(1211, '雪豹X80', NULL, 285, 0, NULL, 'J', 0, 3, 3521),
(1212, '宝典', NULL, 286, 0, NULL, 'J', 0, 3, 1640),
(1213, '宝威', NULL, 286, 0, NULL, 'J', 0, 3, 1759),
(1214, '福特新世代全顺', NULL, 286, 0, NULL, 'J', 0, 3, 2375),
(1215, '经典全顺', NULL, 286, 0, NULL, 'J', 0, 3, 1690),
(1216, '凯锐', NULL, 286, 0, NULL, 'J', 0, 3, 2698),
(1217, '凯锐800', NULL, 286, 0, NULL, 'J', 0, 3, 4115),
(1218, '凯威', NULL, 286, 0, NULL, 'J', 0, 3, 3361),
(1219, '凯运', NULL, 286, 0, NULL, 'J', 0, 3, 1572),
(1220, '顺达', NULL, 286, 0, NULL, 'J', 0, 3, 2685),
(1221, '驭胜', NULL, 286, 0, NULL, 'J', 0, 3, 3288),
(1222, '域虎', NULL, 286, 0, NULL, 'J', 0, 3, 3767),
(1223, '奥拓经典', NULL, 287, 0, NULL, 'J', 0, 3, 2592),
(1224, '传奇', NULL, 287, 0, NULL, 'J', 0, 3, 1763),
(1225, '风光', NULL, 287, 0, NULL, 'J', 0, 3, 1761),
(1226, '江南精灵', NULL, 287, 0, NULL, 'J', 0, 3, 1762),
(1227, '霸道SUV', NULL, 288, 0, NULL, 'J', 0, 3, 2763),
(1228, '大海狮', NULL, 288, 0, NULL, 'J', 0, 3, 3737),
(1229, '阁瑞斯MPV', NULL, 288, 0, NULL, 'J', 0, 3, 1732),
(1230, '海狮', NULL, 288, 0, NULL, 'J', 0, 3, 1731),
(1231, '海狮第6代', NULL, 288, 0, NULL, 'J', 0, 3, 3194),
(1232, '海星', NULL, 288, 0, NULL, 'J', 0, 3, 2864),
(1233, '华晨金杯S50', NULL, 288, 0, NULL, 'J', 0, 3, 3520),
(1234, '金典', NULL, 288, 0, NULL, 'J', 0, 3, 1716),
(1235, '雷龙', NULL, 288, 0, NULL, 'J', 0, 3, 1639),
(1236, '西部大力神', NULL, 288, 0, NULL, 'J', 0, 3, 3525),
(1237, '小海狮', NULL, 288, 0, NULL, 'J', 0, 3, 3973),
(1238, '新海狮', NULL, 288, 0, NULL, 'J', 0, 3, 4081),
(1239, '智尚S30', NULL, 288, 0, NULL, 'J', 0, 3, 3388),
(1240, '金龙海狮', NULL, 289, 0, NULL, 'J', 0, 3, 1894),
(1241, '金龙金威', NULL, 289, 0, NULL, 'J', 0, 3, 4007),
(1242, '金龙凯歌', NULL, 289, 0, NULL, 'J', 0, 3, 4008),
(1243, '金程SUV', NULL, 290, 0, NULL, 'J', 0, 3, 1972),
(1244, '金程军警装备车', NULL, 290, 0, NULL, 'J', 0, 3, 1980),
(1245, '金程轻客', NULL, 290, 0, NULL, 'J', 0, 3, 1986),
(1246, '金程之星', NULL, 290, 0, NULL, 'J', 0, 3, 3001),
(1247, '赛风', NULL, 290, 0, NULL, 'J', 0, 3, 3002),
(1248, 'X', NULL, 291, 0, NULL, 'J', 0, 3, 3016),
(1249, '捷豹F-Type', NULL, 291, 0, NULL, 'J', 0, 3, 3786),
(1250, '捷豹S-TYPE(进口)', NULL, 291, 0, NULL, 'J', 0, 3, 2144),
(1251, '捷豹XF', NULL, 291, 0, NULL, 'J', 0, 3, 2354),
(1252, '捷豹XFR(进口)', NULL, 291, 0, NULL, 'J', 0, 3, 2729),
(1253, '捷豹XJ', NULL, 291, 0, NULL, 'J', 0, 3, 2758),
(1254, '捷豹XK(进口)', NULL, 291, 0, NULL, 'J', 0, 3, 2143),
(1255, '捷豹XKR(进口)', NULL, 291, 0, NULL, 'J', 0, 3, 2728),
(1256, '美鹿', NULL, 292, 0, NULL, 'J', 0, 3, 2433),
(1257, '九龙考斯特', NULL, 293, 0, NULL, 'J', 0, 3, 3233),
(1258, '九龙商务车', NULL, 293, 0, NULL, 'J', 0, 3, 3231),
(1259, '九龙专用车', NULL, 293, 0, NULL, 'J', 0, 3, 3232),
(1260, '金旅海狮', NULL, 294, 0, NULL, 'J', 0, 3, 3871),
(1261, '金旅客车系列', NULL, 294, 0, NULL, 'J', 0, 3, 4049),
(1262, '考斯特', NULL, 294, 0, NULL, 'J', 0, 3, 3271),
(1263, '铂锐', NULL, 295, 0, NULL, 'K', 0, 3, 2286),
(1264, '克莱斯勒300C', NULL, 295, 0, NULL, 'K', 0, 3, 1988),
(1265, '大捷龙', NULL, 296, 0, NULL, 'K', 0, 3, 1567),
(1266, '300M', NULL, 297, 0, NULL, 'K', 0, 3, 2090),
(1267, 'PT漫步者(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2088),
(1268, '城乡', NULL, 297, 0, NULL, 'K', 0, 3, 3021),
(1269, '大捷龙(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2355),
(1270, '辉煌(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 1843),
(1271, '克莱斯勒300C', NULL, 297, 0, NULL, 'K', 0, 3, 2089),
(1272, '克莱斯勒彩虹(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2540),
(1273, '克莱斯勒交叉火力(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2092),
(1274, '克莱斯勒君王(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2541),
(1275, '克莱斯勒太阳舞(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2542),
(1276, '赛百灵(进口)', NULL, 297, 0, NULL, 'K', 0, 3, 2397),
(1277, '凯迪拉克CTS', NULL, 298, 0, NULL, 'K', 0, 3, 2508),
(1278, '凯迪拉克SRX', NULL, 298, 0, NULL, 'K', 0, 3, 2509),
(1279, '凯迪拉克XTS', NULL, 298, 0, NULL, 'K', 0, 3, 3031),
(1280, '赛威', NULL, 298, 0, NULL, 'K', 0, 3, 1839),
(1281, '帝威', NULL, 299, 0, NULL, 'K', 0, 3, 2182),
(1282, '凯迪拉克ATS', NULL, 299, 0, NULL, 'K', 0, 3, 3593),
(1283, '凯迪拉克CTS COUPE', NULL, 299, 0, NULL, 'K', 0, 3, 3360),
(1284, '凯迪拉克CTS(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 1827),
(1285, '凯迪拉克CTS-V(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 2693),
(1286, '凯迪拉克DTS(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 2013),
(1287, '凯迪拉克SRX(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 1834),
(1288, '凯迪拉克XLR(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 1838),
(1289, '凯迪拉克加长版', NULL, 299, 0, NULL, 'K', 0, 3, 1969),
(1290, '凯雷德', NULL, 299, 0, NULL, 'K', 0, 3, 2012),
(1291, '凯雷德 Hybrid', NULL, 299, 0, NULL, 'K', 0, 3, 3186),
(1292, '凯雷德外交官(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 2391),
(1293, '赛威(进口)', NULL, 299, 0, NULL, 'K', 0, 3, 2994),
(1294, '伍德', NULL, 299, 0, NULL, 'K', 0, 3, 2635),
(1295, '科尼塞克Agera', NULL, 300, 0, NULL, 'K', 0, 3, 3341),
(1296, '科尼塞克CCR(进口)', NULL, 300, 0, NULL, 'K', 0, 3, 2841),
(1297, '爱卡', NULL, 301, 0, NULL, 'K', 0, 3, 3867),
(1298, '开瑞3', NULL, 301, 0, NULL, 'K', 0, 3, 1691),
(1299, '开瑞优劲', NULL, 301, 0, NULL, 'K', 0, 3, 2996),
(1300, '开瑞优派', NULL, 301, 0, NULL, 'K', 0, 3, 2777),
(1301, '开瑞优胜', NULL, 301, 0, NULL, 'K', 0, 3, 2908),
(1302, '开瑞优雅', NULL, 301, 0, NULL, 'K', 0, 3, 2782),
(1303, '开瑞优翼', NULL, 301, 0, NULL, 'K', 0, 3, 2778),
(1304, '开瑞优优', NULL, 301, 0, NULL, 'K', 0, 3, 2820),
(1305, '卡尔森C25', NULL, 302, 0, NULL, 'K', 0, 3, 3837),
(1306, '卡尔森GL级', NULL, 302, 0, NULL, 'K', 0, 3, 3839),
(1307, '卡尔森S级', NULL, 302, 0, NULL, 'K', 0, 3, 3838),
(1308, 'X-BOW', NULL, 303, 0, NULL, 'K', 0, 3, 4130),
(1309, '卡威SUV', NULL, 304, 0, NULL, 'K', 0, 3, 4156),
(1310, '卡威皮卡', NULL, 304, 0, NULL, 'K', 0, 3, 4155),
(1311, '北斗星', NULL, 305, 0, NULL, 'L', 0, 3, 1599),
(1312, '北斗星X5', NULL, 305, 0, NULL, 'L', 0, 3, 3948),
(1313, '浪迪', NULL, 305, 0, NULL, 'L', 0, 3, 1590),
(1314, '利亚纳A6两厢', NULL, 305, 0, NULL, 'L', 0, 3, 4060),
(1315, '利亚纳A6三厢', NULL, 305, 0, NULL, 'L', 0, 3, 4057),
(1316, '利亚纳两厢', NULL, 305, 0, NULL, 'L', 0, 3, 2266),
(1317, '利亚纳三厢', NULL, 305, 0, NULL, 'L', 0, 3, 1602),
(1318, '派喜', NULL, 305, 0, NULL, 'L', 0, 3, 2745),
(1319, '奥拓', NULL, 306, 0, NULL, 'L', 0, 3, 2713),
(1320, '锋驭', NULL, 306, 0, NULL, 'L', 0, 3, 3815),
(1321, '羚羊', NULL, 306, 0, NULL, 'L', 0, 3, 1618),
(1322, '天语SX4两厢', NULL, 306, 0, NULL, 'L', 0, 3, 1605),
(1323, '天语SX4锐骑', NULL, 306, 0, NULL, 'L', 0, 3, 3591),
(1324, '天语SX4三厢', NULL, 306, 0, NULL, 'L', 0, 3, 1619),
(1325, '天语SX4尚悦', NULL, 306, 0, NULL, 'L', 0, 3, 3348),
(1326, '雨燕', NULL, 306, 0, NULL, 'L', 0, 3, 1617),
(1327, '西安奥拓', NULL, 307, 0, NULL, 'L', 0, 3, 2551),
(1328, '超级维特拉(进口)', NULL, 308, 0, NULL, 'L', 0, 3, 2031),
(1329, '吉姆尼(进口)', NULL, 308, 0, NULL, 'L', 0, 3, 1955),
(1330, '凯泽西（进口）', NULL, 308, 0, NULL, 'L', 0, 3, 2794),
(1331, '速翼特（进口）', NULL, 308, 0, NULL, 'L', 0, 3, 4097),
(1332, '陆风X5', NULL, 309, 0, NULL, 'L', 0, 3, 3793),
(1333, '陆风X6', NULL, 309, 0, NULL, 'L', 0, 3, 2249),
(1334, '陆风X8', NULL, 309, 0, NULL, 'L', 0, 3, 2746),
(1335, '陆风X9', NULL, 309, 0, NULL, 'L', 0, 3, 2250),
(1336, '陆风风华', NULL, 309, 0, NULL, 'L', 0, 3, 1749),
(1337, '陆风风尚', NULL, 309, 0, NULL, 'L', 0, 3, 1758),
(1338, '陆风新饰界', NULL, 309, 0, NULL, 'L', 0, 3, 2503),
(1339, '丰顺', NULL, 310, 0, NULL, 'L', 0, 3, 3219),
(1340, '力帆320', NULL, 310, 0, NULL, 'L', 0, 3, 2709),
(1341, '力帆330', NULL, 310, 0, NULL, 'L', 0, 3, 3911),
(1342, '力帆520', NULL, 310, 0, NULL, 'L', 0, 3, 2366),
(1343, '力帆520i', NULL, 310, 0, NULL, 'L', 0, 3, 2403),
(1344, '力帆530', NULL, 310, 0, NULL, 'L', 0, 3, 3729),
(1345, '力帆620', NULL, 310, 0, NULL, 'L', 0, 3, 2425),
(1346, '力帆630', NULL, 310, 0, NULL, 'L', 0, 3, 3908),
(1347, '力帆720', NULL, 310, 0, NULL, 'L', 0, 3, 3270),
(1348, '力帆X60', NULL, 310, 0, NULL, 'L', 0, 3, 2741),
(1349, '兴顺', NULL, 310, 0, NULL, 'L', 0, 3, 3621),
(1350, '古思特', NULL, 311, 0, NULL, 'L', 0, 3, 2721),
(1351, '幻影', NULL, 311, 0, NULL, 'L', 0, 3, 2041),
(1352, '劳斯莱斯Silver spirit', NULL, 311, 0, NULL, 'L', 0, 3, 3592),
(1353, '劳斯莱斯银色天使(进口)', NULL, 311, 0, NULL, 'L', 0, 3, 2042),
(1354, '魅影', NULL, 311, 0, NULL, 'L', 0, 3, 3884),
(1355, 'Esprit', NULL, 312, 0, NULL, 'L', 0, 3, 2800),
(1356, '路特斯Elise', NULL, 312, 0, NULL, 'L', 0, 3, 2047),
(1357, '路特斯Evora', NULL, 312, 0, NULL, 'L', 0, 3, 2738),
(1358, '路特斯Exige', NULL, 312, 0, NULL, 'L', 0, 3, 3497),
(1359, 'Aventador', NULL, 313, 0, NULL, 'L', 0, 3, 3397),
(1360, 'Huracan', NULL, 313, 0, NULL, 'L', 0, 3, 4094),
(1361, '蝙蝠(进口)', NULL, 313, 0, NULL, 'L', 0, 3, 2067),
(1362, '盖拉多', NULL, 313, 0, NULL, 'L', 0, 3, 2066),
(1363, '雷克萨斯CT', NULL, 314, 0, NULL, 'L', 0, 3, 2977),
(1364, '雷克萨斯ES', NULL, 314, 0, NULL, 'L', 0, 3, 2109),
(1365, '雷克萨斯GS', NULL, 314, 0, NULL, 'L', 0, 3, 2072),
(1366, '雷克萨斯GX', NULL, 314, 0, NULL, 'L', 0, 3, 2501),
(1367, '雷克萨斯IS', NULL, 314, 0, NULL, 'L', 0, 3, 2110),
(1368, '雷克萨斯LF-A', NULL, 314, 0, NULL, 'L', 0, 3, 2602),
(1369, '雷克萨斯LS', NULL, 314, 0, NULL, 'L', 0, 3, 1996),
(1370, '雷克萨斯LX', NULL, 314, 0, NULL, 'L', 0, 3, 2073),
(1371, '雷克萨斯RX', NULL, 314, 0, NULL, 'L', 0, 3, 2130),
(1372, '雷克萨斯SC(进口)', NULL, 314, 0, NULL, 'L', 0, 3, 2252),
(1373, '城市(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2036),
(1374, '黑森林(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 1957),
(1375, '林肯LS(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2059),
(1376, '林肯MKS（进口）', NULL, 315, 0, NULL, 'L', 0, 3, 3366),
(1377, '林肯MKT(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2913),
(1378, '林肯MKX(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2008),
(1379, '林肯MKZ(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2392),
(1380, '林肯加长版(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 1845),
(1381, '领航员(进口)', NULL, 315, 0, NULL, 'L', 0, 3, 2086),
(1382, '发现', NULL, 316, 0, NULL, 'L', 0, 3, 2087),
(1383, '揽胜', NULL, 316, 0, NULL, 'L', 0, 3, 2149),
(1384, '揽胜极光', NULL, 316, 0, NULL, 'L', 0, 3, 3245),
(1385, '揽胜运动版', NULL, 316, 0, NULL, 'L', 0, 3, 2588),
(1386, '路虎卫士', NULL, 316, 0, NULL, 'L', 0, 3, 2293),
(1387, '神行者2代', NULL, 316, 0, NULL, 'L', 0, 3, 2060),
(1388, '自由人', NULL, 316, 0, NULL, 'L', 0, 3, 2918),
(1389, '风景', NULL, 317, 0, NULL, 'L', 0, 3, 2161),
(1390, '风朗', NULL, 317, 0, NULL, 'L', 0, 3, 3362),
(1391, '科雷傲', NULL, 317, 0, NULL, 'L', 0, 3, 2707),
(1392, '拉古那', NULL, 317, 0, NULL, 'L', 0, 3, 2882),
(1393, '雷诺威赛帝(进口)', NULL, 317, 0, NULL, 'L', 0, 3, 2163),
(1394, '梅甘娜', NULL, 317, 0, NULL, 'L', 0, 3, 2160),
(1395, '塔利斯曼', NULL, 317, 0, NULL, 'L', 0, 3, 3652),
(1396, '纬度', NULL, 317, 0, NULL, 'L', 0, 3, 3310),
(1397, 'TF', NULL, 318, 0, NULL, 'L', 0, 3, 3003),
(1398, '罗孚(进口)', NULL, 318, 0, NULL, 'L', 0, 3, 2561),
(1399, '竞悦', NULL, 319, 0, NULL, 'L', 0, 3, 2655),
(1400, '莲花L3 GT', NULL, 319, 0, NULL, 'L', 0, 3, 4062),
(1401, '莲花L3两厢', NULL, 319, 0, NULL, 'L', 0, 3, 2894),
(1402, '莲花L3三厢', NULL, 319, 0, NULL, 'L', 0, 3, 2415),
(1403, '莲花L5 GTS 跑车', NULL, 319, 0, NULL, 'L', 0, 3, 4063),
(1404, '莲花L5两厢', NULL, 319, 0, NULL, 'L', 0, 3, 3527),
(1405, '莲花L5三厢', NULL, 319, 0, NULL, 'L', 0, 3, 3013),
(1406, 'RCR竞悦', NULL, 320, 0, NULL, 'L', 0, 3, 2594),
(1407, '竞速', NULL, 320, 0, NULL, 'L', 0, 3, 2416),
(1408, '长丰猎豹CS7', NULL, 321, 0, NULL, 'L', 0, 3, 2706),
(1409, '飞腾C5', NULL, 321, 0, NULL, 'L', 0, 3, 4166),
(1410, '猎豹6481', NULL, 321, 0, NULL, 'L', 0, 3, 1659),
(1411, '猎豹CFA2030', NULL, 321, 0, NULL, 'L', 0, 3, 1651),
(1412, '猎豹CFA6473系列', NULL, 321, 0, NULL, 'L', 0, 3, 2207),
(1413, '猎豹CJY6470', NULL, 321, 0, NULL, 'L', 0, 3, 1658),
(1414, '猎豹CS6', NULL, 321, 0, NULL, 'L', 0, 3, 1656),
(1415, '猎豹Q6', NULL, 321, 0, NULL, 'L', 0, 3, 4167),
(1416, '猎豹飞腾', NULL, 321, 0, NULL, 'L', 0, 3, 1570),
(1417, '猎豹黑金刚', NULL, 321, 0, NULL, 'L', 0, 3, 1655),
(1418, '骐菱', NULL, 321, 0, NULL, 'L', 0, 3, 2284),
(1419, '长丰DUV', NULL, 322, 0, NULL, 'L', 0, 3, 2812),
(1420, '飞铃SUV', NULL, 322, 0, NULL, 'L', 0, 3, 2219),
(1421, '飞铃皮卡', NULL, 322, 0, NULL, 'L', 0, 3, 2218),
(1422, '飞扬SUV', NULL, 322, 0, NULL, 'L', 0, 3, 1899),
(1423, '福铃皮卡', NULL, 322, 0, NULL, 'L', 0, 3, 1896),
(1424, '金麒麟', NULL, 322, 0, NULL, 'L', 0, 3, 2499),
(1425, '猎豹CT5皮卡', NULL, 322, 0, NULL, 'L', 0, 3, 3204),
(1426, '猎豹飞扬皮卡', NULL, 322, 0, NULL, 'L', 0, 3, 1898),
(1427, '玉麒麟', NULL, 322, 0, NULL, 'L', 0, 3, 2506),
(1428, '理念S1', NULL, 323, 0, NULL, 'L', 0, 3, 2888),
(1429, '凌特', NULL, 324, 0, NULL, 'L', 0, 3, 4144),
(1430, '威霆', NULL, 324, 0, NULL, 'L', 0, 3, 3960),
(1431, 'Mazda3 Axela昂克赛拉两厢', NULL, 325, 0, NULL, 'M', 0, 3, 4238),
(1432, 'Mazda3 Axela昂克赛拉三厢', NULL, 325, 0, NULL, 'M', 0, 3, 4123),
(1433, '马自达2两厢', NULL, 325, 0, NULL, 'M', 0, 3, 1604),
(1434, '马自达2三厢', NULL, 325, 0, NULL, 'M', 0, 3, 2333),
(1435, '马自达3', NULL, 325, 0, NULL, 'M', 0, 3, 2296),
(1436, '马自达3星骋两厢', NULL, 325, 0, NULL, 'M', 0, 3, 3551),
(1437, '马自达3星骋三厢', NULL, 325, 0, NULL, 'M', 0, 3, 3503),
(1438, '马自达CX-5', NULL, 325, 0, NULL, 'M', 0, 3, 3883),
(1439, '马自达6', NULL, 326, 0, NULL, 'M', 0, 3, 1914),
(1440, '马自达6 ATENZA阿特兹', NULL, 326, 0, NULL, 'M', 0, 3, 4065),
(1441, '马自达6 Wagon', NULL, 326, 0, NULL, 'M', 0, 3, 1920),
(1442, '马自达6轿跑车', NULL, 326, 0, NULL, 'M', 0, 3, 1917),
(1443, '马自达8', NULL, 326, 0, NULL, 'M', 0, 3, 2938),
(1444, '睿翼', NULL, 326, 0, NULL, 'M', 0, 3, 2566),
(1445, '睿翼轿跑', NULL, 326, 0, NULL, 'M', 0, 3, 2944),
(1446, 'mazda RX-8(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2552),
(1447, 'Mazda6(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2563),
(1448, '马自达323(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2570),
(1449, '马自达3两厢(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2752),
(1450, '马自达5（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 2142),
(1451, '马自达626(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2571),
(1452, '马自达929(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 2572),
(1453, '马自达ATENZA（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 3963),
(1454, '马自达CX-5（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 3514),
(1455, '马自达CX-7（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 2844),
(1456, '马自达CX-9（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 2954),
(1457, '马自达MPV(进口)', NULL, 327, 0, NULL, 'M', 0, 3, 1928),
(1458, '马自达MX-5（进口）', NULL, 327, 0, NULL, 'M', 0, 3, 2724),
(1459, '富旺', NULL, 328, 0, NULL, 'M', 0, 3, 3011),
(1460, '陆程', NULL, 328, 0, NULL, 'M', 0, 3, 1889),
(1461, '美亚顺风', NULL, 328, 0, NULL, 'M', 0, 3, 2291),
(1462, '奇兵', NULL, 328, 0, NULL, 'M', 0, 3, 1892),
(1463, '奇骏', NULL, 328, 0, NULL, 'M', 0, 3, 2205),
(1464, 'MG 3', NULL, 329, 0, NULL, 'M', 0, 3, 3092),
(1465, 'MG 3SW', NULL, 329, 0, NULL, 'M', 0, 3, 2287),
(1466, 'MG 5', NULL, 329, 0, NULL, 'M', 0, 3, 3372),
(1467, 'MG 6两厢', NULL, 329, 0, NULL, 'M', 0, 3, 2723),
(1468, 'MG 6三厢', NULL, 329, 0, NULL, 'M', 0, 3, 3295),
(1469, 'MG 7', NULL, 329, 0, NULL, 'M', 0, 3, 1752),
(1470, 'MG TF', NULL, 329, 0, NULL, 'M', 0, 3, 2189),
(1471, 'MINI', NULL, 330, 0, NULL, 'M', 0, 3, 3297),
(1472, 'MINI CABRIO', NULL, 330, 0, NULL, 'M', 0, 3, 2817),
(1473, 'MINI CLUBMAN', NULL, 330, 0, NULL, 'M', 0, 3, 2043),
(1474, 'MINI COUNTRYMAN', NULL, 330, 0, NULL, 'M', 0, 3, 3095),
(1475, 'MINI COUPE', NULL, 330, 0, NULL, 'M', 0, 3, 3501),
(1476, 'MINI PACEMAN', NULL, 330, 0, NULL, 'M', 0, 3, 3778),
(1477, 'MINI ROADSTER', NULL, 330, 0, NULL, 'M', 0, 3, 3606),
(1478, 'MINI CLUBMAN JCW', NULL, 331, 0, NULL, 'M', 0, 3, 4021),
(1479, 'MINI COUNTRYMAN JCW', NULL, 331, 0, NULL, 'M', 0, 3, 4017),
(1480, 'MINI COUPE JCW', NULL, 331, 0, NULL, 'M', 0, 3, 4019),
(1481, 'MINI JCW', NULL, 331, 0, NULL, 'M', 0, 3, 4020),
(1482, 'MINI PACEMAN JCW', NULL, 331, 0, NULL, 'M', 0, 3, 4018),
(1483, '迈巴赫57', NULL, 332, 0, NULL, 'M', 0, 3, 2113),
(1484, '迈巴赫57S', NULL, 332, 0, NULL, 'M', 0, 3, 3285),
(1485, '迈巴赫62', NULL, 332, 0, NULL, 'M', 0, 3, 2112),
(1486, '迈巴赫62S', NULL, 332, 0, NULL, 'M', 0, 3, 2771),
(1487, 'GranSport(进口)', NULL, 333, 0, NULL, 'M', 0, 3, 2119),
(1488, '玛莎拉蒂Coupe(进口)', NULL, 333, 0, NULL, 'M', 0, 3, 2247),
(1489, '玛莎拉蒂GC', NULL, 333, 0, NULL, 'M', 0, 3, 2982),
(1490, '玛莎拉蒂Ghibli', NULL, 333, 0, NULL, 'M', 0, 3, 3874),
(1491, '玛莎拉蒂GT', NULL, 333, 0, NULL, 'M', 0, 3, 2246),
(1492, '玛莎拉蒂spyder(进口)', NULL, 333, 0, NULL, 'M', 0, 3, 2294),
(1493, '玛莎拉蒂总裁', NULL, 333, 0, NULL, 'M', 0, 3, 2120),
(1494, '迈凯伦650S', NULL, 334, 0, NULL, 'M', 0, 3, 4121),
(1495, '迈凯伦MP4-12C', NULL, 334, 0, NULL, 'M', 0, 3, 3775),
(1496, '摩根3-Wheeler  ', NULL, 335, 0, NULL, 'M', 0, 3, 4244),
(1497, '摩根4-4', NULL, 335, 0, NULL, 'M', 0, 3, 4110),
(1498, '摩根plus 8', NULL, 335, 0, NULL, 'M', 0, 3, 3964),
(1499, '摩根Roadster', NULL, 335, 0, NULL, 'M', 0, 3, 4003),
(1500, '纳智捷5 Sedan', NULL, 336, 0, NULL, 'N', 0, 3, 3770),
(1501, '纳智捷MASTER CEO', NULL, 336, 0, NULL, 'N', 0, 3, 3277),
(1502, '纳智捷大7 MPV', NULL, 336, 0, NULL, 'N', 0, 3, 3276),
(1503, '纳智捷大7 SUV', NULL, 336, 0, NULL, 'N', 0, 3, 3275),
(1504, '纳智捷优6 SUV', NULL, 336, 0, NULL, 'N', 0, 3, 4061),
(1505, '讴歌ILX', NULL, 337, 0, NULL, 'O', 0, 3, 3679),
(1506, '讴歌MDX', NULL, 337, 0, NULL, 'O', 0, 3, 2358),
(1507, '讴歌RDX', NULL, 337, 0, NULL, 'O', 0, 3, 2959),
(1508, '讴歌RL', NULL, 337, 0, NULL, 'O', 0, 3, 2359),
(1509, '讴歌RLX', NULL, 337, 0, NULL, 'O', 0, 3, 3812),
(1510, '讴歌TL', NULL, 337, 0, NULL, 'O', 0, 3, 2360),
(1511, '讴歌ZDX', NULL, 337, 0, NULL, 'O', 0, 3, 2754),
(1512, '安德拉', NULL, 338, 0, NULL, 'O', 0, 3, 2581),
(1513, '麦瑞纳', NULL, 338, 0, NULL, 'O', 0, 3, 4051),
(1514, '欧宝GT(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2615),
(1515, '欧捷利(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2180),
(1516, '欧美佳(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2547),
(1517, '赛飞利', NULL, 338, 0, NULL, 'O', 0, 3, 2179),
(1518, '威达(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2178),
(1519, '雅特', NULL, 338, 0, NULL, 'O', 0, 3, 2177),
(1520, '雅特A+', NULL, 338, 0, NULL, 'O', 0, 3, 2580),
(1521, '雅特GTC(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2268),
(1522, '雅特TwinTop(进口)', NULL, 338, 0, NULL, 'O', 0, 3, 2269),
(1523, '英速亚', NULL, 338, 0, NULL, 'O', 0, 3, 3670),
(1524, '欧朗', NULL, 339, 0, NULL, 'O', 0, 3, 3561),
(1525, '欧朗两厢', NULL, 339, 0, NULL, 'O', 0, 3, 3928),
(1526, '旁蒂克(进口)', NULL, 340, 0, NULL, 'P', 0, 3, 2098),
(1527, 'Zonda Cinque', NULL, 341, 0, NULL, 'P', 0, 3, 4000),
(1528, '皮特比尔特', NULL, 342, 0, NULL, 'P', 0, 3, 4102),
(1529, '宝驹', NULL, 343, 0, NULL, 'Q', 0, 3, 1680),
(1530, '福瑞迪三厢', NULL, 343, 0, NULL, 'Q', 0, 3, 2748),
(1531, '嘉华', NULL, 343, 0, NULL, 'Q', 0, 3, 1681),
(1532, '普莱特', NULL, 343, 0, NULL, 'Q', 0, 3, 1677),
(1533, '起亚K2两厢', NULL, 343, 0, NULL, 'Q', 0, 3, 3543),
(1534, '起亚K2三厢', NULL, 343, 0, NULL, 'Q', 0, 3, 3398),
(1535, '起亚K3', NULL, 343, 0, NULL, 'Q', 0, 3, 3510),
(1536, '起亚K3S', NULL, 343, 0, NULL, 'Q', 0, 3, 4153),
(1537, '起亚K5', NULL, 343, 0, NULL, 'Q', 0, 3, 3323),
(1538, '千里马', NULL, 343, 0, NULL, 'Q', 0, 3, 1676),
(1539, '锐欧', NULL, 343, 0, NULL, 'Q', 0, 3, 1684),
(1540, '赛拉图', NULL, 343, 0, NULL, 'Q', 0, 3, 1683),
(1541, '赛拉图欧风', NULL, 343, 0, NULL, 'Q', 0, 3, 2283),
(1542, '狮跑', NULL, 343, 0, NULL, 'Q', 0, 3, 1678),
(1543, '秀尔', NULL, 343, 0, NULL, 'Q', 0, 3, 2719),
(1544, '远舰', NULL, 343, 0, NULL, 'Q', 0, 3, 1682),
(1545, '智跑', NULL, 343, 0, NULL, 'Q', 0, 3, 3086),
(1546, 'K5（进口）', NULL, 344, 0, NULL, 'Q', 0, 3, 3949),
(1547, '霸锐', NULL, 344, 0, NULL, 'Q', 0, 3, 2414),
(1548, '凯尊', NULL, 344, 0, NULL, 'Q', 0, 3, 3063),
(1549, '丽欧', NULL, 344, 0, NULL, 'Q', 0, 3, 2799),
(1550, '欧迪玛(进口)', NULL, 344, 0, NULL, 'Q', 0, 3, 1984),
(1551, '欧菲莱斯(进口)', NULL, 344, 0, NULL, 'Q', 0, 3, 1985),
(1552, '普莱特', NULL, 344, 0, NULL, 'Q', 0, 3, 2797),
(1553, '起亚VQ', NULL, 344, 0, NULL, 'Q', 0, 3, 2014),
(1554, '起亚嘉华(进口)', NULL, 344, 0, NULL, 'Q', 0, 3, 2559),
(1555, '起亚康柯得(进口)', NULL, 344, 0, NULL, 'Q', 0, 3, 2562),
(1556, '狮跑(进口)', NULL, 344, 0, NULL, 'Q', 0, 3, 2024),
(1557, '苏玛', NULL, 344, 0, NULL, 'Q', 0, 3, 2798),
(1558, '速迈', NULL, 344, 0, NULL, 'Q', 0, 3, 2863),
(1559, '索兰托', NULL, 344, 0, NULL, 'Q', 0, 3, 1722),
(1560, '维斯特', NULL, 344, 0, NULL, 'Q', 0, 3, 2789),
(1561, '新佳乐', NULL, 344, 0, NULL, 'Q', 0, 3, 2185),
(1562, '艾瑞泽7', NULL, 345, 0, NULL, 'Q', 0, 3, 3524),
(1563, '东方之子', NULL, 345, 0, NULL, 'Q', 0, 3, 1607),
(1564, '东方之子CROSS', NULL, 345, 0, NULL, 'Q', 0, 3, 2194),
(1565, '风云', NULL, 345, 0, NULL, 'Q', 0, 3, 1750),
(1566, '风云2两厢', NULL, 345, 0, NULL, 'Q', 0, 3, 2950),
(1567, '风云2三厢', NULL, 345, 0, NULL, 'Q', 0, 3, 2711),
(1568, '奇瑞', NULL, 345, 0, NULL, 'Q', 0, 3, 2809),
(1569, '奇瑞A1', NULL, 345, 0, NULL, 'Q', 0, 3, 1622),
(1570, '奇瑞A3两厢', NULL, 345, 0, NULL, 'Q', 0, 3, 2625),
(1571, '奇瑞A3三厢', NULL, 345, 0, NULL, 'Q', 0, 3, 2369),
(1572, '奇瑞A5', NULL, 345, 0, NULL, 'Q', 0, 3, 1787),
(1573, '奇瑞E3', NULL, 345, 0, NULL, 'Q', 0, 3, 3813),
(1574, '奇瑞E5', NULL, 345, 0, NULL, 'Q', 0, 3, 3374),
(1575, '奇瑞QQ', NULL, 345, 0, NULL, 'Q', 0, 3, 1785),
(1576, '奇瑞QQ6', NULL, 345, 0, NULL, 'Q', 0, 3, 1789),
(1577, '奇瑞QQme', NULL, 345, 0, NULL, 'Q', 0, 3, 2747),
(1578, '旗云', NULL, 345, 0, NULL, 'Q', 0, 3, 1784),
(1579, '旗云1', NULL, 345, 0, NULL, 'Q', 0, 3, 3250),
(1580, '旗云2', NULL, 345, 0, NULL, 'Q', 0, 3, 3251),
(1581, '旗云3', NULL, 345, 0, NULL, 'Q', 0, 3, 3252),
(1582, '旗云5', NULL, 345, 0, NULL, 'Q', 0, 3, 3373),
(1583, '瑞虎', NULL, 345, 0, NULL, 'Q', 0, 3, 1667),
(1584, '瑞虎3', NULL, 345, 0, NULL, 'Q', 0, 3, 4189),
(1585, '瑞虎5', NULL, 345, 0, NULL, 'Q', 0, 3, 4053),
(1586, '仓栅式运输车', NULL, 346, 0, NULL, 'Q', 0, 3, 4124),
(1587, '庆铃多功能车', NULL, 346, 0, NULL, 'Q', 0, 3, 1792),
(1588, '庆铃皮卡', NULL, 346, 0, NULL, 'Q', 0, 3, 2328),
(1589, '庆铃轻型商用车', NULL, 346, 0, NULL, 'Q', 0, 3, 2330),
(1590, '庆铃中型商用车', NULL, 346, 0, NULL, 'Q', 0, 3, 3487),
(1591, '庆铃重型商用车', NULL, 346, 0, NULL, 'Q', 0, 3, 2329),
(1592, '启辰D50', NULL, 347, 0, NULL, 'Q', 0, 3, 3316),
(1593, '启辰R50', NULL, 347, 0, NULL, 'Q', 0, 3, 3753),
(1594, '启辰R50X', NULL, 347, 0, NULL, 'Q', 0, 3, 4056),
(1595, '骏逸', NULL, 348, 0, NULL, 'R', 0, 3, 1700),
(1596, '蓝鸟', NULL, 348, 0, NULL, 'R', 0, 3, 1694),
(1597, '骊威', NULL, 348, 0, NULL, 'R', 0, 3, 1679),
(1598, '楼兰', NULL, 348, 0, NULL, 'R', 0, 3, 3492),
(1599, '玛驰', NULL, 348, 0, NULL, 'R', 0, 3, 3243),
(1600, '奇骏', NULL, 348, 0, NULL, 'R', 0, 3, 2583),
(1601, '骐达', NULL, 348, 0, NULL, 'R', 0, 3, 1698),
(1602, '天籁', NULL, 348, 0, NULL, 'R', 0, 3, 2409),
(1603, '逍客', NULL, 348, 0, NULL, 'R', 0, 3, 2190),
(1604, '轩逸', NULL, 348, 0, NULL, 'R', 0, 3, 1699),
(1605, '阳光', NULL, 348, 0, NULL, 'R', 0, 3, 1695),
(1606, '颐达', NULL, 348, 0, NULL, 'R', 0, 3, 1697),
(1607, 'D22厢式车', NULL, 349, 0, NULL, 'R', 0, 3, 1766),
(1608, 'ZN6491系列', NULL, 349, 0, NULL, 'R', 0, 3, 2792),
(1609, '凯普斯达', NULL, 349, 0, NULL, 'R', 0, 3, 2916),
(1610, '帕拉丁', NULL, 349, 0, NULL, 'R', 0, 3, 1922),
(1611, '帕拉骐', NULL, 349, 0, NULL, 'R', 0, 3, 2696),
(1612, '郑州日产D22皮卡', NULL, 349, 0, NULL, 'R', 0, 3, 1923),
(1613, '郑州日产NV200', NULL, 349, 0, NULL, 'R', 0, 3, 3037),
(1614, '碧莲', NULL, 350, 0, NULL, 'R', 0, 3, 1846),
(1615, '公爵(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2534),
(1616, '贵士', NULL, 350, 0, NULL, 'R', 0, 3, 2158),
(1617, '蓝鸟', NULL, 350, 0, NULL, 'R', 0, 3, 2634),
(1618, '旗舰(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2644),
(1619, '日产350Z(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2159),
(1620, '日产370Z', NULL, 350, 0, NULL, 'R', 0, 3, 3244),
(1621, '日产GT-R', NULL, 350, 0, NULL, 'R', 0, 3, 2578),
(1622, '日产风度(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2155),
(1623, '日产风雅(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2157),
(1624, '日产美仑奴(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 1929),
(1625, '日产奇骏(进口)', NULL, 350, 0, NULL, 'R', 0, 3, 2153),
(1626, '途乐', NULL, 350, 0, NULL, 'R', 0, 3, 2154),
(1627, '无限Q45', NULL, 350, 0, NULL, 'R', 0, 3, 2697),
(1628, '阳光', NULL, 350, 0, NULL, 'R', 0, 3, 2637),
(1629, '荣威350', NULL, 351, 0, NULL, 'R', 0, 3, 2886),
(1630, '荣威550', NULL, 351, 0, NULL, 'R', 0, 3, 2371),
(1631, '荣威750', NULL, 351, 0, NULL, 'R', 0, 3, 1992),
(1632, '荣威950', NULL, 351, 0, NULL, 'R', 0, 3, 3647),
(1633, '荣威E50', NULL, 351, 0, NULL, 'R', 0, 3, 3089),
(1634, '荣威W5', NULL, 351, 0, NULL, 'R', 0, 3, 2958),
(1635, '瑞麒2', NULL, 352, 0, NULL, 'R', 0, 3, 2192),
(1636, '瑞麒G3', NULL, 352, 0, NULL, 'R', 0, 3, 3106),
(1637, '瑞麒G5', NULL, 352, 0, NULL, 'R', 0, 3, 2843),
(1638, '瑞麒G6', NULL, 352, 0, NULL, 'R', 0, 3, 2688),
(1639, '瑞麒M1', NULL, 352, 0, NULL, 'R', 0, 3, 2700),
(1640, '瑞麒M5', NULL, 352, 0, NULL, 'R', 0, 3, 3264),
(1641, '瑞麒X1', NULL, 352, 0, NULL, 'R', 0, 3, 2838),
(1642, '昊锐', NULL, 353, 0, NULL, 'S', 0, 3, 2674),
(1643, '晶锐', NULL, 353, 0, NULL, 'S', 0, 3, 2611),
(1644, '明锐', NULL, 353, 0, NULL, 'S', 0, 3, 1811),
(1645, '明锐RS', NULL, 353, 0, NULL, 'S', 0, 3, 3273),
(1646, '速派', NULL, 353, 0, NULL, 'S', 0, 3, 4002),
(1647, '昕动', NULL, 353, 0, NULL, 'S', 0, 3, 4108),
(1648, '昕锐', NULL, 353, 0, NULL, 'S', 0, 3, 3765),
(1649, '野帝', NULL, 353, 0, NULL, 'S', 0, 3, 2955),
(1650, 'Yeti(进口)', NULL, 354, 0, NULL, 'S', 0, 3, 3930),
(1651, '法比亚(进口)', NULL, 354, 0, NULL, 'S', 0, 3, 2077),
(1652, '昊锐(进口)', NULL, 354, 0, NULL, 'S', 0, 3, 3885),
(1653, '欧雅(进口)', NULL, 354, 0, NULL, 'S', 0, 3, 1971),
(1654, '速尊(进口)', NULL, 354, 0, NULL, 'S', 0, 3, 4078),
(1655, '欧蓝德', NULL, 355, 0, NULL, 'S', 0, 3, 1562),
(1656, '帕杰罗速跑', NULL, 355, 0, NULL, 'S', 0, 3, 1561),
(1657, '风迪思', NULL, 356, 0, NULL, 'S', 0, 3, 3910),
(1658, '戈蓝', NULL, 356, 0, NULL, 'S', 0, 3, 1693),
(1659, '君阁', NULL, 356, 0, NULL, 'S', 0, 3, 2597),
(1660, '蓝瑟', NULL, 356, 0, NULL, 'S', 0, 3, 1689),
(1661, '菱绅', NULL, 356, 0, NULL, 'S', 0, 3, 1686),
(1662, '翼神', NULL, 356, 0, NULL, 'S', 0, 3, 2783),
(1663, '帕杰罗', NULL, 357, 0, NULL, 'S', 0, 3, 1657),
(1664, '帕杰罗·劲畅', NULL, 357, 0, NULL, 'S', 0, 3, 3845),
(1665, '新劲炫ASX', NULL, 357, 0, NULL, 'S', 0, 3, 3686),
(1666, '戈蓝(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2084),
(1667, '格蓝迪(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2016),
(1668, '劲炫(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 3102),
(1669, '蓝瑟 EX(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2575),
(1670, '蓝瑟 翼豪陆神(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2083),
(1671, '蓝瑟(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2085),
(1672, '欧蓝德（进口）', NULL, 358, 0, NULL, 'S', 0, 3, 2015),
(1673, '帕杰罗(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2082),
(1674, '帕杰罗劲畅(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2995),
(1675, '伊柯丽斯(进口)', NULL, 358, 0, NULL, 'S', 0, 3, 2574),
(1676, '来宝S-RV', NULL, 359, 0, NULL, 'S', 0, 3, 1854),
(1677, '来旺', NULL, 359, 0, NULL, 'S', 0, 3, 1855),
(1678, '双环SCEO', NULL, 359, 0, NULL, 'S', 0, 3, 1856),
(1679, '小贵族', NULL, 359, 0, NULL, 'S', 0, 3, 1857),
(1680, '申驰旅居汽车', NULL, 360, 0, NULL, 'S', 0, 3, 1875),
(1681, 'Fortwo(进口)', NULL, 361, 0, NULL, 's', 0, 3, 2702),
(1682, '精灵纯洁(进口)', NULL, 361, 0, NULL, 's', 0, 3, 2081),
(1683, '精灵节奏(进口)', NULL, 361, 0, NULL, 's', 0, 3, 2500),
(1684, 'MB100', NULL, 362, 0, NULL, 'S', 0, 3, 2774),
(1685, '爱腾(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2018),
(1686, '柯兰多(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2514),
(1687, '雷斯特(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2164),
(1688, '雷斯特II(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2019),
(1689, '雷斯特W(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 3918),
(1690, '路帝(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2017),
(1691, '享御(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2020),
(1692, '主席(进口)', NULL, 362, 0, NULL, 'S', 0, 3, 2165),
(1693, '萨博9000CD(进口)', NULL, 363, 0, NULL, 'S', 0, 3, 2513),
(1694, '萨博9-3(进口)', NULL, 363, 0, NULL, 'S', 0, 3, 2176),
(1695, '萨博9-5(进口)', NULL, 363, 0, NULL, 'S', 0, 3, 2175),
(1696, '傲虎(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2168),
(1697, '驰鹏(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2021),
(1698, '力狮(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2818),
(1699, '森林人(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2167),
(1700, '斯巴鲁 WRX STI(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2374),
(1701, '斯巴鲁BRZ(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 3570),
(1702, '斯巴鲁XV(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 3464),
(1703, '翼豹(进口)', NULL, 364, 0, NULL, 'S', 0, 3, 2170),
(1704, '三星道奇(捷龙)', NULL, 365, 0, NULL, 'S', 0, 3, 2428),
(1705, '世爵C8((进口)', NULL, 366, 0, NULL, 'S', 0, 3, 2772),
(1706, '上汽MAXUS大通G10', NULL, 367, 0, NULL, 'S', 0, 3, 4071),
(1707, '上汽大通MAXUS V80', NULL, 367, 0, NULL, 'S', 0, 3, 3463),
(1708, '上汽大通MAXUS V80改装车', NULL, 367, 0, NULL, 'S', 0, 3, 3743),
(1709, '福家', NULL, 368, 0, NULL, 'S', 0, 3, 4158),
(1710, '龙锐 ', NULL, 368, 0, NULL, 'S', 0, 3, 4159),
(1711, '绅宝D50', NULL, 369, 0, NULL, 'S', 0, 3, 4143),
(1712, '绅宝D70', NULL, 369, 0, NULL, 'S', 0, 3, 3100),
(1713, 'GMC商务之星(进口)', NULL, 370, 0, NULL, 'S', 0, 3, 4099),
(1714, '凯迪拉克总统一号(进口)', NULL, 370, 0, NULL, 'S', 0, 3, 4100),
(1715, '林肯领袖一号(进口)', NULL, 370, 0, NULL, 'S', 0, 3, 4101),
(1716, '海拉克斯', NULL, 371, 0, NULL, 'T', 0, 3, 1876),
(1717, '天马乘龙', NULL, 371, 0, NULL, 'T', 0, 3, 1975),
(1718, '天马风骏', NULL, 371, 0, NULL, 'T', 0, 3, 2202),
(1719, '天马风锐', NULL, 371, 0, NULL, 'T', 0, 3, 1974),
(1720, '天马海狮', NULL, 371, 0, NULL, 'T', 0, 3, 1891),
(1721, '天马英雄', NULL, 371, 0, NULL, 'T', 0, 3, 2203),
(1722, '天马御虎', NULL, 371, 0, NULL, 'T', 0, 3, 1976),
(1723, '通田阁罗', NULL, 372, 0, NULL, 'T', 0, 3, 1893),
(1724, '塔菲克', NULL, 373, 0, NULL, 'T', 0, 3, 2831),
(1725, 'DENZA', NULL, 374, 0, NULL, 'T', 0, 3, 3714),
(1726, 'Model S(进口)', NULL, 375, 0, NULL, 'T', 0, 3, 3843),
(1727, '泰卡特T1(进口)', NULL, 376, 0, NULL, 'T', 0, 3, 4126),
(1728, '泰卡特T2(进口)', NULL, 376, 0, NULL, 'T', 0, 3, 4127),
(1729, '泰卡特T3(进口)', NULL, 376, 0, NULL, 'T', 0, 3, 4128),
(1730, '泰卡特T7(进口)', NULL, 376, 0, NULL, 'T', 0, 3, 4028),
(1731, '泰卡特T9(进口)', NULL, 376, 0, NULL, 'T', 0, 3, 4029),
(1732, '长安沃尔沃S40', NULL, 377, 0, NULL, 'W', 0, 3, 1614),
(1733, '沃尔沃S80L', NULL, 377, 0, NULL, 'W', 0, 3, 2684),
(1734, '沃尔沃S60L', NULL, 378, 0, NULL, 'W', 0, 3, 3768),
(1735, 'S40(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2418),
(1736, 'S70', NULL, 379, 0, NULL, 'W', 0, 3, 2628),
(1737, 'XC70', NULL, 379, 0, NULL, 'W', 0, 3, 2796),
(1738, '沃尔沃 C70(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2254),
(1739, '沃尔沃C30(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2363),
(1740, '沃尔沃S60(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2486),
(1741, '沃尔沃S80(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2148);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(1742, '沃尔沃V40 Cross Country', NULL, 379, 0, NULL, 'W', 0, 3, 4243),
(1743, '沃尔沃V40（进口） ', NULL, 379, 0, NULL, 'W', 0, 3, 3628),
(1744, '沃尔沃V60(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 3268),
(1745, '沃尔沃V70(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2487),
(1746, '沃尔沃XC60(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2695),
(1747, '沃尔沃XC90(进口)', NULL, 379, 0, NULL, 'W', 0, 3, 2145),
(1748, '速达', NULL, 380, 0, NULL, 'W', 0, 3, 1850),
(1749, '速威', NULL, 380, 0, NULL, 'W', 0, 3, 1840),
(1750, '泰威', NULL, 380, 0, NULL, 'W', 0, 3, 1841),
(1751, '万丰商务车', NULL, 380, 0, NULL, 'W', 0, 3, 1849),
(1752, '都市清风', NULL, 381, 0, NULL, 'W', 0, 3, 3012),
(1753, '柳州五菱', NULL, 381, 0, NULL, 'W', 0, 3, 2546),
(1754, '五菱PN系列货车', NULL, 381, 0, NULL, 'W', 0, 3, 4106),
(1755, '五菱宏光', NULL, 381, 0, NULL, 'W', 0, 3, 3026),
(1756, '五菱宏光S', NULL, 381, 0, NULL, 'W', 0, 3, 4147),
(1757, '五菱鸿途', NULL, 381, 0, NULL, 'W', 0, 3, 1751),
(1758, '五菱荣光', NULL, 381, 0, NULL, 'W', 0, 3, 2576),
(1759, '五菱小旋风', NULL, 381, 0, NULL, 'W', 0, 3, 2191),
(1760, '五菱兴旺', NULL, 381, 0, NULL, 'W', 0, 3, 1853),
(1761, '五菱扬光', NULL, 381, 0, NULL, 'W', 0, 3, 1852),
(1762, '五菱之光', NULL, 381, 0, NULL, 'W', 0, 3, 1692),
(1763, '铁金刚', NULL, 382, 0, NULL, 'W', 0, 3, 2641),
(1764, '突路霸', NULL, 382, 0, NULL, 'W', 0, 3, 2642),
(1765, '五十铃MU', NULL, 382, 0, NULL, 'W', 0, 3, 2643),
(1766, '威麟H3', NULL, 383, 0, NULL, 'W', 0, 3, 3296),
(1767, '威麟H5', NULL, 383, 0, NULL, 'W', 0, 3, 2829),
(1768, '威麟V5', NULL, 383, 0, NULL, 'W', 0, 3, 2687),
(1769, '威麟X5', NULL, 383, 0, NULL, 'W', 0, 3, 2828),
(1770, '威兹曼GT(进口)', NULL, 384, 0, NULL, 'W', 0, 3, 3827),
(1771, '威兹曼Roadster(进口)', NULL, 384, 0, NULL, 'W', 0, 3, 3826),
(1772, '富康', NULL, 385, 0, NULL, 'X', 0, 3, 1673),
(1773, '经典爱丽舍两厢', NULL, 385, 0, NULL, 'X', 0, 3, 2673),
(1774, '经典爱丽舍三厢', NULL, 385, 0, NULL, 'X', 0, 3, 2411),
(1775, '凯旋', NULL, 385, 0, NULL, 'X', 0, 3, 1674),
(1776, '全新爱丽舍', NULL, 385, 0, NULL, 'X', 0, 3, 4046),
(1777, '萨拉-毕加索', NULL, 385, 0, NULL, 'X', 0, 3, 1671),
(1778, '赛纳', NULL, 385, 0, NULL, 'X', 0, 3, 1670),
(1779, '世嘉两厢', NULL, 385, 0, NULL, 'X', 0, 3, 2413),
(1780, '世嘉三厢', NULL, 385, 0, NULL, 'X', 0, 3, 2710),
(1781, '雪铁龙C2', NULL, 385, 0, NULL, 'X', 0, 3, 1675),
(1782, '雪铁龙C4L', NULL, 385, 0, NULL, 'X', 0, 3, 3773),
(1783, '雪铁龙C5', NULL, 385, 0, NULL, 'X', 0, 3, 2753),
(1784, 'C4 AIRCROSS(进口)', NULL, 386, 0, NULL, 'X', 0, 3, 3642),
(1785, 'C4毕加索(进口)', NULL, 386, 0, NULL, 'X', 0, 3, 2617),
(1786, '雪铁龙C4', NULL, 386, 0, NULL, 'X', 0, 3, 2052),
(1787, '雪铁龙C5(进口)', NULL, 386, 0, NULL, 'X', 0, 3, 2027),
(1788, '雪铁龙C6', NULL, 386, 0, NULL, 'X', 0, 3, 2028),
(1789, 'MISTRA名图', NULL, 387, 0, NULL, 'X', 0, 3, 3913),
(1790, '北京现代i30', NULL, 387, 0, NULL, 'X', 0, 3, 2712),
(1791, '北京现代ix35', NULL, 387, 0, NULL, 'X', 0, 3, 2874),
(1792, '朗动', NULL, 387, 0, NULL, 'X', 0, 3, 3655),
(1793, '领翔', NULL, 387, 0, NULL, 'X', 0, 3, 2612),
(1794, '名驭 ', NULL, 387, 0, NULL, 'X', 0, 3, 2764),
(1795, '全新胜达', NULL, 387, 0, NULL, 'X', 0, 3, 3821),
(1796, '瑞纳两厢', NULL, 387, 0, NULL, 'X', 0, 3, 3308),
(1797, '瑞纳三厢', NULL, 387, 0, NULL, 'X', 0, 3, 3167),
(1798, '瑞奕', NULL, 387, 0, NULL, 'X', 0, 3, 4151),
(1799, '索纳塔', NULL, 387, 0, NULL, 'X', 0, 3, 1568),
(1800, '途胜', NULL, 387, 0, NULL, 'X', 0, 3, 1574),
(1801, '雅绅特', NULL, 387, 0, NULL, 'X', 0, 3, 1575),
(1802, '伊兰特', NULL, 387, 0, NULL, 'X', 0, 3, 1569),
(1803, '伊兰特两厢', NULL, 387, 0, NULL, 'X', 0, 3, 2272),
(1804, '御翔', NULL, 387, 0, NULL, 'X', 0, 3, 1973),
(1805, '悦动', NULL, 387, 0, NULL, 'X', 0, 3, 2334),
(1806, '创虎', NULL, 388, 0, NULL, 'X', 0, 3, 4207),
(1807, '康恩迪', NULL, 388, 0, NULL, 'X', 0, 3, 4006),
(1808, '得利', NULL, 389, 0, NULL, 'X', 0, 3, 3006),
(1809, '飞思(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2900),
(1810, '格锐(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 3972),
(1811, '辉翼(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 3139),
(1812, '君爵(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 1782),
(1813, '酷派(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2025),
(1814, '劳恩斯(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2569),
(1815, '劳恩斯coupe(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2603),
(1816, '全新胜达(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 1848),
(1817, '瑞风', NULL, 389, 0, NULL, 'X', 0, 3, 3007),
(1818, '世纪(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2186),
(1819, '索纳塔(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2504),
(1820, '特杰', NULL, 389, 0, NULL, 'X', 0, 3, 2808),
(1821, '维拉克斯(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2026),
(1822, '现代美佳(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2048),
(1823, '雅科仕(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2811),
(1824, '雅尊(进口)', NULL, 389, 0, NULL, 'X', 0, 3, 2009),
(1825, '雪佛兰开拓者', NULL, 390, 0, NULL, 'X', 0, 3, 1764),
(1826, 'S10', NULL, 391, 0, NULL, 'X', 0, 3, 3004),
(1827, '爱唯欧两厢', NULL, 391, 0, NULL, 'X', 0, 3, 2964),
(1828, '爱唯欧三厢', NULL, 391, 0, NULL, 'X', 0, 3, 3368),
(1829, '创酷', NULL, 391, 0, NULL, 'X', 0, 3, 3794),
(1830, '景程', NULL, 391, 0, NULL, 'X', 0, 3, 1835),
(1831, '科鲁兹三厢', NULL, 391, 0, NULL, 'X', 0, 3, 2608),
(1832, '科鲁兹掀背', NULL, 391, 0, NULL, 'X', 0, 3, 3355),
(1833, '科帕奇', NULL, 391, 0, NULL, 'X', 0, 3, 3357),
(1834, '乐骋', NULL, 391, 0, NULL, 'X', 0, 3, 2410),
(1835, '乐风', NULL, 391, 0, NULL, 'X', 0, 3, 1828),
(1836, '迈锐宝', NULL, 391, 0, NULL, 'X', 0, 3, 3381),
(1837, '赛欧SPRINGO', NULL, 391, 0, NULL, 'X', 0, 3, 3816),
(1838, '赛欧两厢', NULL, 391, 0, NULL, 'X', 0, 3, 2957),
(1839, '赛欧三厢', NULL, 391, 0, NULL, 'X', 0, 3, 1833),
(1840, '新赛欧SRV', NULL, 391, 0, NULL, 'X', 0, 3, 2213),
(1841, '乐驰', NULL, 392, 0, NULL, 'X', 0, 3, 3803),
(1842, '科迈罗(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 2759),
(1843, '科帕奇(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 1930),
(1844, '科西嘉(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 2539),
(1845, '斯帕可', NULL, 393, 0, NULL, 'X', 0, 3, 2963),
(1846, '沃蓝达(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 2925),
(1847, '雪佛兰(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 2166),
(1848, '雪佛兰EXPRESS(进口)', NULL, 393, 0, NULL, 'X', 0, 3, 1781),
(1849, '君达SUV', NULL, 394, 0, NULL, 'X', 0, 3, 2208),
(1850, '新雅途', NULL, 394, 0, NULL, 'X', 0, 3, 1932),
(1851, '新雅途·优尼柯', NULL, 394, 0, NULL, 'X', 0, 3, 1933),
(1852, '英格尔', NULL, 394, 0, NULL, 'X', 0, 3, 2558),
(1853, '魔兽', NULL, 395, 0, NULL, 'X', 0, 3, 1941),
(1854, '源动力', NULL, 395, 0, NULL, 'X', 0, 3, 1942),
(1855, '凌特324', NULL, 396, 0, NULL, 'X', 0, 3, 3953),
(1856, '凌特524', NULL, 396, 0, NULL, 'X', 0, 3, 3954),
(1857, '锐达', NULL, 396, 0, NULL, 'X', 0, 3, 3623),
(1858, '威霆119', NULL, 396, 0, NULL, 'X', 0, 3, 3952),
(1859, '威霆122', NULL, 396, 0, NULL, 'X', 0, 3, 4168),
(1860, '新凯CUV', NULL, 396, 0, NULL, 'X', 0, 3, 2210),
(1861, '新凯SRV', NULL, 396, 0, NULL, 'X', 0, 3, 1964),
(1862, '新凯SUV', NULL, 396, 0, NULL, 'X', 0, 3, 1963),
(1863, '新凯皮卡', NULL, 396, 0, NULL, 'X', 0, 3, 1965),
(1864, 'LEON(进口)', NULL, 397, 0, NULL, 'X', 0, 3, 3376),
(1865, '欧悦搏(进口)', NULL, 397, 0, NULL, 'X', 0, 3, 3556),
(1866, '伊比飒(进口)', NULL, 397, 0, NULL, 'X', 0, 3, 3377),
(1867, 'GMC皇家级', NULL, 398, 0, NULL, 'X', 0, 3, 3617),
(1868, '奔驰S级', NULL, 398, 0, NULL, 'X', 0, 3, 3616),
(1869, '丰田4Runner', NULL, 398, 0, NULL, 'X', 0, 3, 3615),
(1870, '丰田红杉', NULL, 398, 0, NULL, 'X', 0, 3, 3613),
(1871, '福特F系列', NULL, 398, 0, NULL, 'X', 0, 3, 3619),
(1872, '福特商务车', NULL, 398, 0, NULL, 'X', 0, 3, 3622),
(1873, '林肯MKT', NULL, 398, 0, NULL, 'X', 0, 3, 3614),
(1874, '林肯MKX', NULL, 398, 0, NULL, 'X', 0, 3, 3612),
(1875, '林肯领航员', NULL, 398, 0, NULL, 'X', 0, 3, 3618),
(1876, '斯宾特Sprinter', NULL, 398, 0, NULL, 'X', 0, 3, 3610),
(1877, 'Daily', NULL, 399, 0, NULL, 'Y', 0, 3, 1775),
(1878, 'Ouba', NULL, 399, 0, NULL, 'Y', 0, 3, 3627),
(1879, 'Power Daily', NULL, 399, 0, NULL, 'Y', 0, 3, 2389),
(1880, 'Turbo Daily', NULL, 399, 0, NULL, 'Y', 0, 3, 3624),
(1881, 'Venice', NULL, 399, 0, NULL, 'Y', 0, 3, 3625),
(1882, '超越', NULL, 399, 0, NULL, 'Y', 0, 3, 4160),
(1883, '都灵', NULL, 399, 0, NULL, 'Y', 0, 3, 1777),
(1884, '康果', NULL, 399, 0, NULL, 'Y', 0, 3, 1776),
(1885, '欧霸', NULL, 399, 0, NULL, 'Y', 0, 3, 2650),
(1886, '跃进', NULL, 399, 0, NULL, 'Y', 0, 3, 4247),
(1887, '赛宝', NULL, 400, 0, NULL, 'Y', 0, 3, 1803),
(1888, '威乐', NULL, 401, 0, NULL, 'Y', 0, 3, 1882),
(1889, '威志V2', NULL, 401, 0, NULL, 'Y', 0, 3, 2791),
(1890, '威志V5', NULL, 401, 0, NULL, 'Y', 0, 3, 3646),
(1891, '威志两厢', NULL, 401, 0, NULL, 'Y', 0, 3, 1887),
(1892, '威志三厢', NULL, 401, 0, NULL, 'Y', 0, 3, 2396),
(1893, '威姿', NULL, 401, 0, NULL, 'Y', 0, 3, 1883),
(1894, '夏利', NULL, 401, 0, NULL, 'Y', 0, 3, 1880),
(1895, '夏利2000', NULL, 401, 0, NULL, 'Y', 0, 3, 1884),
(1896, '夏利A+', NULL, 401, 0, NULL, 'Y', 0, 3, 1886),
(1897, '夏利N3', NULL, 401, 0, NULL, 'Y', 0, 3, 1885),
(1898, '夏利N3+两厢', NULL, 401, 0, NULL, 'Y', 0, 3, 3651),
(1899, '夏利N3+三厢', NULL, 401, 0, NULL, 'Y', 0, 3, 2365),
(1900, '夏利N5', NULL, 401, 0, NULL, 'Y', 0, 3, 2790),
(1901, '夏利N7', NULL, 401, 0, NULL, 'Y', 0, 3, 3705),
(1902, '一汽佳星幸福使者', NULL, 402, 0, NULL, 'Y', 0, 3, 1913),
(1903, '佳宝T50', NULL, 403, 0, NULL, 'Y', 0, 3, 4089),
(1904, '佳宝T51', NULL, 403, 0, NULL, 'Y', 0, 3, 4087),
(1905, '佳宝T57', NULL, 403, 0, NULL, 'Y', 0, 3, 4088),
(1906, '佳宝V52', NULL, 403, 0, NULL, 'Y', 0, 3, 4085),
(1907, '佳宝V55', NULL, 403, 0, NULL, 'Y', 0, 3, 4086),
(1908, '佳宝V70', NULL, 403, 0, NULL, 'Y', 0, 3, 4090),
(1909, '佳宝V70 Ⅱ', NULL, 403, 0, NULL, 'Y', 0, 3, 4084),
(1910, '佳宝V80', NULL, 403, 0, NULL, 'Y', 0, 3, 1961),
(1911, '森雅M80', NULL, 403, 0, NULL, 'Y', 0, 3, 2832),
(1912, '森雅S80', NULL, 403, 0, NULL, 'Y', 0, 3, 3104),
(1913, '一汽奥星', NULL, 403, 0, NULL, 'Y', 0, 3, 1874),
(1914, '森雅', NULL, 404, 0, NULL, 'Y', 0, 3, 1916),
(1915, '自由风', NULL, 405, 0, NULL, 'Y', 0, 3, 1808),
(1916, '坤程', NULL, 406, 0, NULL, 'Y', 0, 3, 3507),
(1917, '风景线', NULL, 407, 0, NULL, 'Y', 0, 3, 1981),
(1918, '猎鹰', NULL, 407, 0, NULL, 'Y', 0, 3, 3938),
(1919, '五星', NULL, 407, 0, NULL, 'Y', 0, 3, 3748),
(1920, '永源A380', NULL, 407, 0, NULL, 'Y', 0, 3, 2769),
(1921, '庄威', NULL, 407, 0, NULL, 'Y', 0, 3, 1979),
(1922, 'Q45', NULL, 408, 0, NULL, 'Y', 0, 3, 2793),
(1923, '英菲尼迪EX', NULL, 408, 0, NULL, 'Y', 0, 3, 2567),
(1924, '英菲尼迪FX', NULL, 408, 0, NULL, 'Y', 0, 3, 1769),
(1925, '英菲尼迪G', NULL, 408, 0, NULL, 'Y', 0, 3, 2022),
(1926, '英菲尼迪JX35(QX60)', NULL, 408, 0, NULL, 'Y', 0, 3, 3512),
(1927, '英菲尼迪M', NULL, 408, 0, NULL, 'Y', 0, 3, 2196),
(1928, '英菲尼迪Q50', NULL, 408, 0, NULL, 'Y', 0, 3, 3864),
(1929, '英菲尼迪Q60', NULL, 408, 0, NULL, 'Y', 0, 3, 4024),
(1930, '英菲尼迪Q60S', NULL, 408, 0, NULL, 'Y', 0, 3, 4032),
(1931, '英菲尼迪Q70L', NULL, 408, 0, NULL, 'Y', 0, 3, 4026),
(1932, '英菲尼迪QX', NULL, 408, 0, NULL, 'Y', 0, 3, 2029),
(1933, '英菲尼迪QX50', NULL, 408, 0, NULL, 'Y', 0, 3, 4025),
(1934, '英菲尼迪QX60', NULL, 408, 0, NULL, 'Y', 0, 3, 4027),
(1935, '英菲尼迪QX70', NULL, 408, 0, NULL, 'Y', 0, 3, 4030),
(1936, '英菲尼迪QX80', NULL, 408, 0, NULL, 'Y', 0, 3, 4031),
(1937, '云豹', NULL, 409, 0, NULL, 'Y', 0, 3, 2430),
(1938, '云雀WOW', NULL, 410, 0, NULL, 'Y', 0, 3, 2438),
(1939, '野马F10', NULL, 411, 0, NULL, 'Y', 0, 3, 3482),
(1940, '野马F12', NULL, 411, 0, NULL, 'Y', 0, 3, 3590),
(1941, '野马F99', NULL, 411, 0, NULL, 'Y', 0, 3, 2787),
(1942, '友谊中巴', NULL, 412, 0, NULL, 'Y', 0, 3, 3689),
(1943, '客运客车', NULL, 413, 0, NULL, 'Y', 0, 3, 3735),
(1944, '亚星客车', NULL, 414, 0, NULL, 'Y', 0, 3, 3946),
(1945, '长铃皮卡', NULL, 415, 0, NULL, 'Z', 0, 3, 2230),
(1946, '驰野', NULL, 415, 0, NULL, 'Z', 0, 3, 2231),
(1947, '福星皮卡', NULL, 415, 0, NULL, 'Z', 0, 3, 3008),
(1948, '金狮', NULL, 415, 0, NULL, 'Z', 0, 3, 2806),
(1949, '旗舰', NULL, 415, 0, NULL, 'Z', 0, 3, 1606),
(1950, '田野SUV', NULL, 415, 0, NULL, 'Z', 0, 3, 3009),
(1951, '田野皮卡', NULL, 415, 0, NULL, 'Z', 0, 3, 3010),
(1952, '万禧龙', NULL, 415, 0, NULL, 'Z', 0, 3, 2807),
(1953, '威虎G3', NULL, 415, 0, NULL, 'Z', 0, 3, 4050),
(1954, '威虎TUV', NULL, 415, 0, NULL, 'Z', 0, 3, 1728),
(1955, '无限', NULL, 415, 0, NULL, 'Z', 0, 3, 1571),
(1956, '中兴C3', NULL, 415, 0, NULL, 'Z', 0, 3, 3690),
(1957, '中兴福星SUV', NULL, 415, 0, NULL, 'Z', 0, 3, 2338),
(1958, '中兴老虎', NULL, 415, 0, NULL, 'Z', 0, 3, 2507),
(1959, '骏捷', NULL, 416, 0, NULL, 'Z', 0, 3, 1740),
(1960, '骏捷Cross', NULL, 416, 0, NULL, 'Z', 0, 3, 2733),
(1961, '骏捷FRV', NULL, 416, 0, NULL, 'Z', 0, 3, 1925),
(1962, '骏捷FSV', NULL, 416, 0, NULL, 'Z', 0, 3, 2742),
(1963, '骏捷Wagon', NULL, 416, 0, NULL, 'Z', 0, 3, 2604),
(1964, '酷宝', NULL, 416, 0, NULL, 'Z', 0, 3, 1736),
(1965, '中华', NULL, 416, 0, NULL, 'Z', 0, 3, 1806),
(1966, '中华H220', NULL, 416, 0, NULL, 'Z', 0, 3, 3756),
(1967, '中华H230', NULL, 416, 0, NULL, 'Z', 0, 3, 3604),
(1968, '中华H320', NULL, 416, 0, NULL, 'Z', 0, 3, 3766),
(1969, '中华H330', NULL, 416, 0, NULL, 'Z', 0, 3, 3873),
(1970, '中华H530', NULL, 416, 0, NULL, 'Z', 0, 3, 3370),
(1971, '中华V5', NULL, 416, 0, NULL, 'Z', 0, 3, 3534),
(1972, '尊驰', NULL, 416, 0, NULL, 'Z', 0, 3, 1733),
(1973, '超赛', NULL, 417, 0, NULL, 'Z', 0, 3, 1926),
(1974, '华北醒狮', NULL, 417, 0, NULL, 'Z', 0, 3, 1862),
(1975, '骏风', NULL, 417, 0, NULL, 'Z', 0, 3, 1939),
(1976, '腾狮', NULL, 417, 0, NULL, 'Z', 0, 3, 1940),
(1977, '中顺MPV', NULL, 418, 0, NULL, 'Z', 0, 3, 2215),
(1978, '中顺SUV', NULL, 418, 0, NULL, 'Z', 0, 3, 2216),
(1979, '中顺皮卡', NULL, 418, 0, NULL, 'Z', 0, 3, 2217),
(1980, '中顺世纪', NULL, 418, 0, NULL, 'Z', 0, 3, 1966),
(1981, '江南TT', NULL, 419, 0, NULL, 'Z', 0, 3, 1760),
(1982, '众泰2008', NULL, 419, 0, NULL, 'Z', 0, 3, 1990),
(1983, '众泰5008', NULL, 419, 0, NULL, 'Z', 0, 3, 2577),
(1984, '众泰M300', NULL, 419, 0, NULL, 'Z', 0, 3, 2624),
(1985, '众泰T200', NULL, 419, 0, NULL, 'Z', 0, 3, 3465),
(1986, '众泰T600', NULL, 419, 0, NULL, 'Z', 0, 3, 3466),
(1987, '众泰V10', NULL, 419, 0, NULL, 'Z', 0, 3, 3365),
(1988, '众泰Z100', NULL, 419, 0, NULL, 'Z', 0, 3, 3846),
(1989, '众泰Z200', NULL, 419, 0, NULL, 'Z', 0, 3, 3184),
(1990, '众泰Z200HB', NULL, 419, 0, NULL, 'Z', 0, 3, 3185),
(1991, '众泰Z300', NULL, 419, 0, NULL, 'Z', 0, 3, 3476),
(1992, '众泰知豆', NULL, 419, 0, NULL, 'Z', 0, 3, 4194),
(1993, '中欧房车', NULL, 420, 0, NULL, 'Z', 0, 3, 3496),
(1994, '领秀客车', NULL, 421, 0, NULL, 'Z', 0, 3, 4047),
(1995, '商务车', NULL, 422, 0, NULL, 'Z', 0, 3, 4157),
(1996, '1994 款', NULL, 423, 0, NULL, 'A', 0, 4, 0),
(1997, '1992 款', NULL, 423, 0, NULL, 'A', 0, 4, 0),
(1998, '1999 款', NULL, 424, 0, NULL, 'A', 0, 4, 0),
(1999, '1998 款', NULL, 424, 0, NULL, 'A', 0, 4, 0),
(2000, '1996 款', NULL, 424, 0, NULL, 'A', 0, 4, 0),
(2001, '2014 款', NULL, 425, 0, NULL, 'A', 0, 4, 0),
(2002, '2008 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2003, '2007 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2004, '2006 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2005, '2005 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2006, '2004 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2007, '2003 款', NULL, 426, 0, NULL, 'A', 0, 4, 0),
(2008, '2015 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2009, '2013 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2010, '2012 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2011, '2011 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2012, '2010 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2013, '2009 款', NULL, 427, 0, NULL, 'A', 0, 4, 0),
(2014, '2014 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2015, '2012 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2016, '2011 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2017, '2010 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2018, '2009 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2019, '2008 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2020, '2007 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2021, '2006 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2022, '2005 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2023, '2004 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2024, '2003 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2025, '2002 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2026, '2001 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2027, '2000 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2028, '1999 款', NULL, 428, 0, NULL, 'A', 0, 4, 0),
(2029, '2014 款', NULL, 429, 0, NULL, 'A', 0, 4, 0),
(2030, '2013 款', NULL, 429, 0, NULL, 'A', 0, 4, 0),
(2031, '2013 款', NULL, 430, 0, NULL, 'A', 0, 4, 0),
(2032, '2012 款', NULL, 430, 0, NULL, 'A', 0, 4, 0),
(2033, '2011 款', NULL, 430, 0, NULL, 'A', 0, 4, 0),
(2034, '2010 款', NULL, 430, 0, NULL, 'A', 0, 4, 0),
(2035, '2014 款', NULL, 431, 0, NULL, 'A', 0, 4, 0),
(2036, '2013 款', NULL, 431, 0, NULL, 'A', 0, 4, 0),
(2037, '2012 款', NULL, 431, 0, NULL, 'A', 0, 4, 0),
(2038, '2014 款', NULL, 432, 0, NULL, 'A', 0, 4, 0),
(2039, '2013 款', NULL, 432, 0, NULL, 'A', 0, 4, 0),
(2040, '2011 款', NULL, 432, 0, NULL, 'A', 0, 4, 0),
(2041, '2010 款', NULL, 432, 0, NULL, 'A', 0, 4, 0),
(2042, '2014 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2043, '2013 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2044, '2008 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2045, '2007 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2046, '2005 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2047, '2004 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2048, '2003 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2049, '2002 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2050, '2001 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2051, '2000 款', NULL, 433, 0, NULL, 'A', 0, 4, 0),
(2052, '2014 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2053, '2013 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2054, '2012 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2055, '2011 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2056, '2010 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2057, '2008 款', NULL, 434, 0, NULL, 'A', 0, 4, 0),
(2058, '2013 款', NULL, 435, 0, NULL, 'A', 0, 4, 0),
(2059, '2007 款', NULL, 435, 0, NULL, 'A', 0, 4, 0),
(2060, '2003 款', NULL, 435, 0, NULL, 'A', 0, 4, 0),
(2061, '2000 款', NULL, 435, 0, NULL, 'A', 0, 4, 0),
(2062, '2014 款', NULL, 436, 0, NULL, 'A', 0, 4, 0),
(2063, '2013 款', NULL, 436, 0, NULL, 'A', 0, 4, 0),
(2064, '2011 款', NULL, 436, 0, NULL, 'A', 0, 4, 0),
(2065, '2013 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2066, '2012 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2067, '2011 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2068, '2010 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2069, '2009 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2070, '2008 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2071, '2006 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2072, '2003 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2073, '2002 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2074, '2000 款', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2075, '其他', NULL, 437, 0, NULL, 'A', 0, 4, 0),
(2076, '2003 款', NULL, 438, 0, NULL, 'A', 0, 4, 0),
(2077, '2002 款', NULL, 438, 0, NULL, 'A', 0, 4, 0),
(2078, '2012 款', NULL, 439, 0, NULL, 'A', 0, 4, 0),
(2079, '2013 款', NULL, 440, 0, NULL, 'A', 0, 4, 0),
(2080, '2012 款', NULL, 440, 0, NULL, 'A', 0, 4, 0),
(2081, '2011 款', NULL, 440, 0, NULL, 'A', 0, 4, 0),
(2082, '2010 款', NULL, 440, 0, NULL, 'A', 0, 4, 0),
(2083, '2014 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2084, '2013 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2085, '2012 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2086, '2011 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2087, '2010 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2088, '2009 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2089, '2007 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2090, '2006 款', NULL, 441, 0, NULL, 'A', 0, 4, 0),
(2091, '2014 款', NULL, 442, 0, NULL, 'A', 0, 4, 0),
(2092, '2012 款', NULL, 442, 0, NULL, 'A', 0, 4, 0),
(2093, '2011 款', NULL, 442, 0, NULL, 'A', 0, 4, 0),
(2094, '2010 款', NULL, 442, 0, NULL, 'A', 0, 4, 0),
(2095, '2008 款', NULL, 442, 0, NULL, 'A', 0, 4, 0),
(2096, '2008 款', NULL, 443, 0, NULL, 'A', 0, 4, 0),
(2097, '2005 款', NULL, 443, 0, NULL, 'A', 0, 4, 0),
(2098, '2003 款', NULL, 443, 0, NULL, 'A', 0, 4, 0),
(2099, '2014 款', NULL, 444, 0, NULL, 'A', 0, 4, 0),
(2100, '2012 款', NULL, 444, 0, NULL, 'A', 0, 4, 0),
(2101, '2011 款', NULL, 444, 0, NULL, 'A', 0, 4, 0),
(2102, '2010 款', NULL, 444, 0, NULL, 'A', 0, 4, 0),
(2103, '2009 款', NULL, 444, 0, NULL, 'A', 0, 4, 0),
(2104, '2013 款', NULL, 445, 0, NULL, 'A', 0, 4, 0),
(2105, '2013 款', NULL, 446, 0, NULL, 'A', 0, 4, 0),
(2106, '2013 款', NULL, 447, 0, NULL, 'A', 0, 4, 0),
(2107, '2009 款', NULL, 447, 0, NULL, 'A', 0, 4, 0),
(2108, '2007 款', NULL, 447, 0, NULL, 'A', 0, 4, 0),
(2109, '2014 款', NULL, 448, 0, NULL, 'A', 0, 4, 0),
(2110, '2014 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2111, '2013 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2112, '2012 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2113, '2011 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2114, '2010 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2115, '2008 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2116, '2007 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2117, '2005 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2118, '2003 款', NULL, 449, 0, NULL, 'A', 0, 4, 0),
(2119, '2013 款', NULL, 450, 0, NULL, 'A', 0, 4, 0),
(2120, '2012 款', NULL, 450, 0, NULL, 'A', 0, 4, 0),
(2121, '2014 款', NULL, 451, 0, NULL, 'A', 0, 4, 0),
(2122, '2004 款', NULL, 452, 0, NULL, 'A', 0, 4, 0),
(2123, '2002 款', NULL, 453, 0, NULL, 'A', 0, 4, 0),
(2124, '2003 款', NULL, 454, 0, NULL, 'A', 0, 4, 0),
(2125, '2002 款', NULL, 454, 0, NULL, 'A', 0, 4, 0),
(2126, '2004 款', NULL, 455, 0, NULL, 'A', 0, 4, 0),
(2127, '2003 款', NULL, 456, 0, NULL, 'A', 0, 4, 0),
(2128, '2003 款', NULL, 457, 0, NULL, 'A', 0, 4, 0),
(2129, '2014 款', NULL, 458, 0, NULL, 'A', 0, 4, 0),
(2130, '2012 款', NULL, 458, 0, NULL, 'A', 0, 4, 0),
(2131, '2009 款', NULL, 458, 0, NULL, 'A', 0, 4, 0),
(2132, '2014 款', NULL, 459, 0, NULL, 'A', 0, 4, 0),
(2133, '2012 款', NULL, 459, 0, NULL, 'A', 0, 4, 0),
(2134, '2011 款', NULL, 459, 0, NULL, 'A', 0, 4, 0),
(2135, '2010 款', NULL, 459, 0, NULL, 'A', 0, 4, 0),
(2136, '2007 款', NULL, 459, 0, NULL, 'A', 0, 4, 0),
(2137, '2003 款', NULL, 460, 0, NULL, 'A', 0, 4, 0),
(2138, '2014 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2139, '2013 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2140, '2011 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2141, '2010 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2142, '2007 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2143, '2004 款', NULL, 461, 0, NULL, 'A', 0, 4, 0),
(2144, '2012 款', NULL, 462, 0, NULL, 'A', 0, 4, 0),
(2145, '2009 款', NULL, 462, 0, NULL, 'A', 0, 4, 0),
(2146, '2007 款', NULL, 462, 0, NULL, 'A', 0, 4, 0),
(2147, '2011 款', NULL, 463, 0, NULL, 'A', 0, 4, 0),
(2148, '2010 款', NULL, 463, 0, NULL, 'A', 0, 4, 0),
(2149, '2014 款', NULL, 464, 0, NULL, 'A', 0, 4, 0),
(2150, '2013 款', NULL, 464, 0, NULL, 'A', 0, 4, 0),
(2151, '2010 款', NULL, 464, 0, NULL, 'A', 0, 4, 0),
(2152, '2014 款', NULL, 465, 0, NULL, 'A', 0, 4, 0),
(2153, '2013 款', NULL, 465, 0, NULL, 'A', 0, 4, 0),
(2154, '2012 款', NULL, 466, 0, NULL, 'A', 0, 4, 0),
(2155, '2013 款', NULL, 467, 0, NULL, 'A', 0, 4, 0),
(2156, '2013 款', NULL, 468, 0, NULL, 'A', 0, 4, 0),
(2157, '2013 款', NULL, 469, 0, NULL, 'A', 0, 4, 0),
(2158, '2013 款', NULL, 470, 0, NULL, 'B', 0, 4, 0),
(2159, '2011 款', NULL, 470, 0, NULL, 'B', 0, 4, 0),
(2160, '2010 款', NULL, 470, 0, NULL, 'B', 0, 4, 0),
(2161, '2008 款', NULL, 470, 0, NULL, 'B', 0, 4, 0),
(2162, '2015 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2163, '2014 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2164, '2013 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2165, '2012 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2166, '2011 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2167, '2010 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2168, '2008 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2169, '2007 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2170, '2006 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2171, '2005 款', NULL, 471, 0, NULL, 'B', 0, 4, 0),
(2172, '2014 款', NULL, 472, 0, NULL, 'B', 0, 4, 0),
(2173, '2013 款', NULL, 472, 0, NULL, 'B', 0, 4, 0),
(2174, '2012 款', NULL, 472, 0, NULL, 'B', 0, 4, 0),
(2175, '2014 款', NULL, 473, 0, NULL, 'B', 0, 4, 0),
(2176, '2013 款', NULL, 473, 0, NULL, 'B', 0, 4, 0),
(2177, '2012 款', NULL, 473, 0, NULL, 'B', 0, 4, 0),
(2178, '2011 款', NULL, 473, 0, NULL, 'B', 0, 4, 0),
(2179, '2014 款', NULL, 474, 0, NULL, 'B', 0, 4, 0),
(2180, '2013 款', NULL, 474, 0, NULL, 'B', 0, 4, 0),
(2181, '2011 款', NULL, 474, 0, NULL, 'B', 0, 4, 0),
(2182, '2010 款', NULL, 474, 0, NULL, 'B', 0, 4, 0),
(2183, '2014 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2184, '2013 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2185, '2012 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2186, '2011 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2187, '2010 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2188, '2009 款', NULL, 475, 0, NULL, 'B', 0, 4, 0),
(2189, '2014 款', NULL, 476, 0, NULL, 'B', 0, 4, 0),
(2190, '2012 款', NULL, 476, 0, NULL, 'B', 0, 4, 0),
(2191, '2011 款', NULL, 476, 0, NULL, 'B', 0, 4, 0),
(2192, '2010 款', NULL, 476, 0, NULL, 'B', 0, 4, 0),
(2193, '2004 款', NULL, 477, 0, NULL, 'B', 0, 4, 0),
(2194, '2003 款', NULL, 477, 0, NULL, 'B', 0, 4, 0),
(2195, '2013 款', NULL, 478, 0, NULL, 'B', 0, 4, 0),
(2196, '2011 款', NULL, 478, 0, NULL, 'B', 0, 4, 0),
(2197, '2001 款', NULL, 478, 0, NULL, 'B', 0, 4, 0),
(2198, '1997 款', NULL, 478, 0, NULL, 'B', 0, 4, 0),
(2199, '2013 款', NULL, 479, 0, NULL, 'B', 0, 4, 0),
(2200, '2012 款', NULL, 479, 0, NULL, 'B', 0, 4, 0),
(2201, '2009 款', NULL, 479, 0, NULL, 'B', 0, 4, 0),
(2202, '2014 款', NULL, 480, 0, NULL, 'B', 0, 4, 0),
(2203, '2006 款', NULL, 481, 0, NULL, 'B', 0, 4, 0),
(2204, '2005 款', NULL, 481, 0, NULL, 'B', 0, 4, 0),
(2205, '2003 款', NULL, 481, 0, NULL, 'B', 0, 4, 0),
(2206, '2002 款', NULL, 481, 0, NULL, 'B', 0, 4, 0),
(2207, '2000 款', NULL, 481, 0, NULL, 'B', 0, 4, 0),
(2208, '2013 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2209, '2012 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2210, '2009 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2211, '2008 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2212, '2007 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2213, '2005 款', NULL, 482, 0, NULL, 'B', 0, 4, 0),
(2214, '2008 款', NULL, 483, 0, NULL, 'B', 0, 4, 0),
(2215, '2006 款', NULL, 483, 0, NULL, 'B', 0, 4, 0),
(2216, '2013 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2217, '2011 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2218, '2010 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2219, '2007 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2220, '2006 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2221, '2005 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2222, '2004 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2223, '2003 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2224, '2000 款', NULL, 484, 0, NULL, 'B', 0, 4, 0),
(2225, '2010 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2226, '2009 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2227, '2006 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2228, '2004 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2229, '2003 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2230, '2002 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2231, '1999 款', NULL, 485, 0, NULL, 'B', 0, 4, 0),
(2232, '2014 款', NULL, 486, 0, NULL, 'B', 0, 4, 0),
(2233, '2011 款', NULL, 487, 0, NULL, 'B', 0, 4, 0),
(2234, '2010 款', NULL, 487, 0, NULL, 'B', 0, 4, 0),
(2235, '2008 款', NULL, 487, 0, NULL, 'B', 0, 4, 0),
(2236, '2014 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2237, '2013 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2238, '2012 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2239, '2011 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2240, '2010 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2241, '2009 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2242, '2008 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2243, '2006 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2244, '2003 款', NULL, 488, 0, NULL, 'B', 0, 4, 0),
(2245, '2014 款', NULL, 489, 0, NULL, 'B', 0, 4, 0),
(2246, '2013 款', NULL, 489, 0, NULL, 'B', 0, 4, 0),
(2247, '2010 款', NULL, 489, 0, NULL, 'B', 0, 4, 0),
(2248, '2014 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2249, '2012 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2250, '2011 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2251, '2010 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2252, '2008 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2253, '2006 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2254, '2005 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2255, '2001 款', NULL, 490, 0, NULL, 'B', 0, 4, 0),
(2256, '2014 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2257, '2011 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2258, '2010 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2259, '2009 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2260, '2007 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2261, '2006 款', NULL, 491, 0, NULL, 'B', 0, 4, 0),
(2262, '1985 款', NULL, 492, 0, NULL, 'B', 0, 4, 0),
(2263, '2011 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2264, '2010 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2265, '2009 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2266, '2008 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2267, '2006 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2268, '2004 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2269, '2003 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2270, '2000 款', NULL, 493, 0, NULL, 'B', 0, 4, 0),
(2271, '2013 款', NULL, 494, 0, NULL, 'B', 0, 4, 0),
(2272, '2010 款', NULL, 494, 0, NULL, 'B', 0, 4, 0),
(2273, '2008 款', NULL, 494, 0, NULL, 'B', 0, 4, 0),
(2274, '2004 款', NULL, 494, 0, NULL, 'B', 0, 4, 0),
(2275, '2002 款', NULL, 494, 0, NULL, 'B', 0, 4, 0),
(2276, '2014 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2277, '2012 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2278, '2011 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2279, '2010 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2280, '2008 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2281, '2007 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2282, '2006 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2283, '2005 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2284, '2003 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2285, '2002 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2286, '2000 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2287, '1999 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2288, '1995 款', NULL, 495, 0, NULL, 'B', 0, 4, 0),
(2289, '2010 款', NULL, 496, 0, NULL, 'B', 0, 4, 0),
(2290, '2004 款', NULL, 496, 0, NULL, 'B', 0, 4, 0),
(2291, '2010 款', NULL, 497, 0, NULL, 'B', 0, 4, 0),
(2292, '2013 款', NULL, 498, 0, NULL, 'B', 0, 4, 0),
(2293, '2012 款', NULL, 498, 0, NULL, 'B', 0, 4, 0),
(2294, '2010 款', NULL, 498, 0, NULL, 'B', 0, 4, 0),
(2295, '2007 款', NULL, 498, 0, NULL, 'B', 0, 4, 0),
(2296, '2008 款', NULL, 499, 0, NULL, 'B', 0, 4, 0),
(2297, '2003 款', NULL, 499, 0, NULL, 'B', 0, 4, 0),
(2298, '2011 款', NULL, 500, 0, NULL, 'B', 0, 4, 0),
(2299, '2010 款', NULL, 500, 0, NULL, 'B', 0, 4, 0),
(2300, '2009 款', NULL, 500, 0, NULL, 'B', 0, 4, 0),
(2301, '2007 款', NULL, 500, 0, NULL, 'B', 0, 4, 0),
(2302, '2004 款', NULL, 500, 0, NULL, 'B', 0, 4, 0),
(2303, '2014 款', NULL, 501, 0, NULL, 'B', 0, 4, 0),
(2304, '2014 款', NULL, 502, 0, NULL, 'B', 0, 4, 0),
(2305, '2012 款', NULL, 503, 0, NULL, 'B', 0, 4, 0),
(2306, '2008 款', NULL, 503, 0, NULL, 'B', 0, 4, 0),
(2307, '2014 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2308, '2012 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2309, '2011 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2310, '2010 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2311, '2009 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2312, '2007 款', NULL, 504, 0, NULL, 'B', 0, 4, 0),
(2313, '2010 款', NULL, 505, 0, NULL, 'B', 0, 4, 0),
(2314, '2007 款', NULL, 505, 0, NULL, 'B', 0, 4, 0),
(2315, '2006 款', NULL, 505, 0, NULL, 'B', 0, 4, 0),
(2316, '2014 款', NULL, 506, 0, NULL, 'B', 0, 4, 0),
(2317, '2013 款', NULL, 506, 0, NULL, 'B', 0, 4, 0),
(2318, '2013 款', NULL, 507, 0, NULL, 'B', 0, 4, 0),
(2319, '2009 款', NULL, 507, 0, NULL, 'B', 0, 4, 0),
(2320, '2007 款', NULL, 507, 0, NULL, 'B', 0, 4, 0),
(2321, '2002 款', NULL, 507, 0, NULL, 'B', 0, 4, 0),
(2322, '2014 款', NULL, 508, 0, NULL, 'B', 0, 4, 0),
(2323, '2012 款', NULL, 508, 0, NULL, 'B', 0, 4, 0),
(2324, '2011 款', NULL, 508, 0, NULL, 'B', 0, 4, 0),
(2325, '2010 款', NULL, 508, 0, NULL, 'B', 0, 4, 0),
(2326, '2007 款', NULL, 508, 0, NULL, 'B', 0, 4, 0),
(2327, '2010 款', NULL, 509, 0, NULL, 'B', 0, 4, 0),
(2328, '2009 款', NULL, 509, 0, NULL, 'B', 0, 4, 0),
(2329, '2014 款', NULL, 510, 0, NULL, 'B', 0, 4, 0),
(2330, '2013 款', NULL, 510, 0, NULL, 'B', 0, 4, 0),
(2331, '2011 款', NULL, 510, 0, NULL, 'B', 0, 4, 0),
(2332, '2010 款', NULL, 510, 0, NULL, 'B', 0, 4, 0),
(2333, '2013 款', NULL, 511, 0, NULL, 'B', 0, 4, 0),
(2334, '2009 款', NULL, 511, 0, NULL, 'B', 0, 4, 0),
(2335, '2003 款', NULL, 511, 0, NULL, 'B', 0, 4, 0),
(2336, '2014 款', NULL, 512, 0, NULL, 'B', 0, 4, 0),
(2337, '2013 款', NULL, 512, 0, NULL, 'B', 0, 4, 0),
(2338, '2010 款', NULL, 512, 0, NULL, 'B', 0, 4, 0),
(2339, '2007 款', NULL, 512, 0, NULL, 'B', 0, 4, 0),
(2340, '2014 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2341, '2013 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2342, '2012 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2343, '2011 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2344, '2010 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2345, '2009 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2346, '2008 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2347, '2007 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2348, '2006 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2349, '2005 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2350, '2004 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2351, '2003 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2352, '2000 款', NULL, 513, 0, NULL, 'B', 0, 4, 0),
(2353, '2014 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2354, '2013 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2355, '2012 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2356, '2011 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2357, '2010 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2358, '2009 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2359, '2008 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2360, '2007 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2361, '2006 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2362, '2005 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2363, '2004 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2364, '2003 款', NULL, 514, 0, NULL, 'B', 0, 4, 0),
(2365, '2014 款', NULL, 515, 0, NULL, 'B', 0, 4, 0),
(2366, '2013 款', NULL, 515, 0, NULL, 'B', 0, 4, 0),
(2367, '2012 款', NULL, 515, 0, NULL, 'B', 0, 4, 0),
(2368, '1999 款', NULL, 516, 0, NULL, 'B', 0, 4, 0),
(2369, '1996 款', NULL, 516, 0, NULL, 'B', 0, 4, 0),
(2370, '2000 款', NULL, 517, 0, NULL, 'B', 0, 4, 0),
(2371, '2013 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2372, '2012 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2373, '2011 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2374, '2010 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2375, '2008 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2376, '2004 款', NULL, 518, 0, NULL, 'B', 0, 4, 0),
(2377, '2014 款', NULL, 519, 0, NULL, 'B', 0, 4, 0),
(2378, '2014 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2379, '2013 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2380, '2012 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2381, '2011 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2382, '2010 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2383, '2009 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2384, '2007 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2385, '2005 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2386, '2000 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2387, '1995 款', NULL, 520, 0, NULL, 'B', 0, 4, 0),
(2388, '2013 款', NULL, 521, 0, NULL, 'B', 0, 4, 0),
(2389, '2014 款', NULL, 522, 0, NULL, 'B', 0, 4, 0),
(2390, '2014 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2391, '2013 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2392, '2012 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2393, '2011 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2394, '2008 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2395, '2006 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2396, '2005 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2397, '2004 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2398, '2003 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2399, '2001 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2400, '2000 款', NULL, 523, 0, NULL, 'B', 0, 4, 0),
(2401, '2014 款', NULL, 524, 0, NULL, 'B', 0, 4, 0),
(2402, '2013 款', NULL, 524, 0, NULL, 'B', 0, 4, 0),
(2403, '2011 款', NULL, 524, 0, NULL, 'B', 0, 4, 0),
(2404, '2010 款', NULL, 524, 0, NULL, 'B', 0, 4, 0),
(2405, '2013 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2406, '2012 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2407, '2011 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2408, '2008 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2409, '2007 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2410, '2004 款', NULL, 525, 0, NULL, 'B', 0, 4, 0),
(2411, '2014 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2412, '2013 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2413, '2011 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2414, '2010 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2415, '2009 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2416, '2008 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2417, '2005 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2418, '2004 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2419, '2003 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2420, '2000 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2421, '1993 款', NULL, 526, 0, NULL, 'B', 0, 4, 0),
(2422, '2012 款', NULL, 527, 0, NULL, 'B', 0, 4, 0),
(2423, '2010 款', NULL, 527, 0, NULL, 'B', 0, 4, 0),
(2424, '2014 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2425, '2013 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2426, '2012 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2427, '2011 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2428, '2010 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2429, '2009 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2430, '2008 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2431, '2007 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2432, '2005 款', NULL, 528, 0, NULL, 'B', 0, 4, 0),
(2433, '2014 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2434, '2013 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2435, '2012 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2436, '2011 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2437, '2010 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2438, '2008 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2439, '2007 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2440, '2006 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2441, '2004 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2442, '2000 款', NULL, 529, 0, NULL, 'B', 0, 4, 0),
(2443, '2013 款', NULL, 530, 0, NULL, 'B', 0, 4, 0),
(2444, '2012 款', NULL, 530, 0, NULL, 'B', 0, 4, 0),
(2445, '2011 款', NULL, 530, 0, NULL, 'B', 0, 4, 0),
(2446, '2010 款', NULL, 530, 0, NULL, 'B', 0, 4, 0),
(2447, '2009 款', NULL, 530, 0, NULL, 'B', 0, 4, 0),
(2448, '2013 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2449, '2012 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2450, '2011 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2451, '2010 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2452, '2009 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2453, '2007 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2454, '2006 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2455, '2003 款', NULL, 531, 0, NULL, 'B', 0, 4, 0),
(2456, '2011 款', NULL, 532, 0, NULL, 'B', 0, 4, 0),
(2457, '2013 款', NULL, 533, 0, NULL, 'B', 0, 4, 0),
(2458, '2011 款', NULL, 533, 0, NULL, 'B', 0, 4, 0),
(2459, '2010 款', NULL, 533, 0, NULL, 'B', 0, 4, 0),
(2460, '2009 款', NULL, 533, 0, NULL, 'B', 0, 4, 0),
(2461, '2002 款', NULL, 533, 0, NULL, 'B', 0, 4, 0),
(2462, '2014 款', NULL, 534, 0, NULL, 'B', 0, 4, 0),
(2463, '2012 款', NULL, 534, 0, NULL, 'B', 0, 4, 0),
(2464, '2005 款', NULL, 534, 0, NULL, 'B', 0, 4, 0),
(2465, '2014 款', NULL, 535, 0, NULL, 'B', 0, 4, 0),
(2466, '2013 款', NULL, 535, 0, NULL, 'B', 0, 4, 0),
(2467, '2006 款', NULL, 535, 0, NULL, 'B', 0, 4, 0),
(2468, '2013 款', NULL, 536, 0, NULL, 'B', 0, 4, 0),
(2469, '2010 款', NULL, 536, 0, NULL, 'B', 0, 4, 0),
(2470, '2013 款', NULL, 537, 0, NULL, 'B', 0, 4, 0),
(2471, '2010 款', NULL, 537, 0, NULL, 'B', 0, 4, 0),
(2472, '2014 款', NULL, 538, 0, NULL, 'B', 0, 4, 0),
(2473, '2008 款', NULL, 539, 0, NULL, 'B', 0, 4, 0),
(2474, '2007 款', NULL, 539, 0, NULL, 'B', 0, 4, 0),
(2475, '2006 款', NULL, 539, 0, NULL, 'B', 0, 4, 0),
(2476, '2013 款', NULL, 540, 0, NULL, 'B', 0, 4, 0),
(2477, '2011 款', NULL, 540, 0, NULL, 'B', 0, 4, 0),
(2478, '2010 款', NULL, 540, 0, NULL, 'B', 0, 4, 0),
(2479, '2009 款', NULL, 540, 0, NULL, 'B', 0, 4, 0),
(2480, '2008 款', NULL, 540, 0, NULL, 'B', 0, 4, 0),
(2481, '2011 款', NULL, 541, 0, NULL, 'B', 0, 4, 0),
(2482, '2010 款', NULL, 541, 0, NULL, 'B', 0, 4, 0),
(2483, '2009 款', NULL, 541, 0, NULL, 'B', 0, 4, 0),
(2484, '2014 款', NULL, 542, 0, NULL, 'B', 0, 4, 0),
(2485, '2013 款', NULL, 542, 0, NULL, 'B', 0, 4, 0),
(2486, '2013 款', NULL, 543, 0, NULL, 'B', 0, 4, 0),
(2487, '2013 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2488, '2012 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2489, '2011 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2490, '2010 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2491, '2009 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2492, '2008 款', NULL, 544, 0, NULL, 'B', 0, 4, 0),
(2493, '2010 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2494, '2009 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2495, '2008 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2496, '2007 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2497, '2006 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2498, '2004 款', NULL, 545, 0, NULL, 'B', 0, 4, 0),
(2499, '2014 款', NULL, 546, 0, NULL, 'B', 0, 4, 0),
(2500, '2013 款', NULL, 546, 0, NULL, 'B', 0, 4, 0),
(2501, '2012 款', NULL, 546, 0, NULL, 'B', 0, 4, 0),
(2502, '2013 款', NULL, 547, 0, NULL, 'B', 0, 4, 0),
(2503, '2012 款', NULL, 547, 0, NULL, 'B', 0, 4, 0),
(2504, '2011 款', NULL, 547, 0, NULL, 'B', 0, 4, 0),
(2505, '2010 款', NULL, 547, 0, NULL, 'B', 0, 4, 0),
(2506, '2014 款', NULL, 548, 0, NULL, 'B', 0, 4, 0),
(2507, '2013 款', NULL, 548, 0, NULL, 'B', 0, 4, 0),
(2508, '2012 款', NULL, 548, 0, NULL, 'B', 0, 4, 0),
(2509, '2011 款', NULL, 548, 0, NULL, 'B', 0, 4, 0),
(2510, '1992 款', NULL, 549, 0, NULL, 'B', 0, 4, 0),
(2511, '2009 款', NULL, 550, 0, NULL, 'B', 0, 4, 0),
(2512, '2007 款', NULL, 550, 0, NULL, 'B', 0, 4, 0),
(2513, '2002 款', NULL, 551, 0, NULL, 'B', 0, 4, 0),
(2514, '2001 款', NULL, 551, 0, NULL, 'B', 0, 4, 0),
(2515, '2000 款', NULL, 551, 0, NULL, 'B', 0, 4, 0),
(2516, '2006 款', NULL, 552, 0, NULL, 'B', 0, 4, 0),
(2517, '2013 款', NULL, 553, 0, NULL, 'B', 0, 4, 0),
(2518, '2011 款', NULL, 553, 0, NULL, 'B', 0, 4, 0),
(2519, '2008 款', NULL, 553, 0, NULL, 'B', 0, 4, 0),
(2520, '2011 款', NULL, 554, 0, NULL, 'B', 0, 4, 0),
(2521, '2006 款', NULL, 555, 0, NULL, 'B', 0, 4, 0),
(2522, '2004 款', NULL, 556, 0, NULL, 'B', 0, 4, 0),
(2523, '2007 款', NULL, 557, 0, NULL, 'B', 0, 4, 0),
(2524, '2005 款', NULL, 557, 0, NULL, 'B', 0, 4, 0),
(2525, '2013 款', NULL, 558, 0, NULL, 'B', 0, 4, 0),
(2526, '2012 款', NULL, 558, 0, NULL, 'B', 0, 4, 0),
(2527, '2010 款', NULL, 558, 0, NULL, 'B', 0, 4, 0),
(2528, '2009 款', NULL, 558, 0, NULL, 'B', 0, 4, 0),
(2529, '2012 款', NULL, 559, 0, NULL, 'B', 0, 4, 0),
(2530, '2009 款', NULL, 559, 0, NULL, 'B', 0, 4, 0),
(2531, '2013 款', NULL, 560, 0, NULL, 'B', 0, 4, 0),
(2532, '2012 款', NULL, 560, 0, NULL, 'B', 0, 4, 0),
(2533, '2002 款', NULL, 561, 0, NULL, 'B', 0, 4, 0),
(2534, '2003 款', NULL, 562, 0, NULL, 'B', 0, 4, 0),
(2535, '2002 款', NULL, 562, 0, NULL, 'B', 0, 4, 0),
(2536, '2000 款', NULL, 562, 0, NULL, 'B', 0, 4, 0),
(2537, '2007 款', NULL, 563, 0, NULL, 'B', 0, 4, 0),
(2538, '2008 款', NULL, 564, 0, NULL, 'B', 0, 4, 0),
(2539, '2007 款', NULL, 564, 0, NULL, 'B', 0, 4, 0),
(2540, '2005 款', NULL, 564, 0, NULL, 'B', 0, 4, 0),
(2541, '2008 款', NULL, 565, 0, NULL, 'B', 0, 4, 0),
(2542, '2005 款', NULL, 565, 0, NULL, 'B', 0, 4, 0),
(2543, '2004 款', NULL, 565, 0, NULL, 'B', 0, 4, 0),
(2544, '2010 款', NULL, 566, 0, NULL, 'B', 0, 4, 0),
(2545, '2005 款', NULL, 566, 0, NULL, 'B', 0, 4, 0),
(2546, '2004 款', NULL, 566, 0, NULL, 'B', 0, 4, 0),
(2547, '2002 款', NULL, 566, 0, NULL, 'B', 0, 4, 0),
(2548, '2000 款', NULL, 566, 0, NULL, 'B', 0, 4, 0),
(2549, '2008 款', NULL, 567, 0, NULL, 'B', 0, 4, 0),
(2550, '2014 款', NULL, 568, 0, NULL, 'B', 0, 4, 0),
(2551, '2011 款', NULL, 568, 0, NULL, 'B', 0, 4, 0),
(2552, '2011 款', NULL, 569, 0, NULL, 'B', 0, 4, 0),
(2553, '2002 款', NULL, 569, 0, NULL, 'B', 0, 4, 0),
(2554, '2011 款', NULL, 570, 0, NULL, 'B', 0, 4, 0),
(2555, '2009 款', NULL, 570, 0, NULL, 'B', 0, 4, 0),
(2556, '2007 款', NULL, 570, 0, NULL, 'B', 0, 4, 0),
(2557, '2010 款', NULL, 571, 0, NULL, 'B', 0, 4, 0),
(2558, '2003 款', NULL, 571, 0, NULL, 'B', 0, 4, 0),
(2559, '2005 款', NULL, 572, 0, NULL, 'B', 0, 4, 0),
(2560, '2004 款', NULL, 572, 0, NULL, 'B', 0, 4, 0),
(2561, '2011 款', NULL, 573, 0, NULL, 'B', 0, 4, 0),
(2562, '2004 款', NULL, 573, 0, NULL, 'B', 0, 4, 0),
(2563, '2010 款', NULL, 574, 0, NULL, 'B', 0, 4, 0),
(2564, '2008 款', NULL, 574, 0, NULL, 'B', 0, 4, 0),
(2565, '其他', NULL, 574, 0, NULL, 'B', 0, 4, 0),
(2566, '2014 款', NULL, 575, 0, NULL, 'B', 0, 4, 0),
(2567, '2001 款', NULL, 576, 0, NULL, 'B', 0, 4, 0),
(2568, '2000 款', NULL, 576, 0, NULL, 'B', 0, 4, 0),
(2569, '2003 款', NULL, 577, 0, NULL, 'B', 0, 4, 0),
(2570, '2000 款', NULL, 577, 0, NULL, 'B', 0, 4, 0),
(2571, '2011 款', NULL, 578, 0, NULL, 'B', 0, 4, 0),
(2572, '2009 款', NULL, 578, 0, NULL, 'B', 0, 4, 0),
(2573, '2013 款', NULL, 579, 0, NULL, 'B', 0, 4, 0),
(2574, '2011 款', NULL, 579, 0, NULL, 'B', 0, 4, 0),
(2575, '2014 款', NULL, 580, 0, NULL, 'B', 0, 4, 0),
(2576, '2009 款', NULL, 581, 0, NULL, 'B', 0, 4, 0),
(2577, '2007 款', NULL, 581, 0, NULL, 'B', 0, 4, 0),
(2578, '2003 款', NULL, 581, 0, NULL, 'B', 0, 4, 0),
(2579, '2001 款', NULL, 581, 0, NULL, 'B', 0, 4, 0),
(2580, '2010 款', NULL, 582, 0, NULL, 'B', 0, 4, 0),
(2581, '2009 款', NULL, 582, 0, NULL, 'B', 0, 4, 0),
(2582, '2007 款', NULL, 582, 0, NULL, 'B', 0, 4, 0),
(2583, '2005 款', NULL, 582, 0, NULL, 'B', 0, 4, 0),
(2584, '2000 款', NULL, 582, 0, NULL, 'B', 0, 4, 0),
(2585, '2014 款', NULL, 583, 0, NULL, 'B', 0, 4, 0),
(2586, '2013 款', NULL, 583, 0, NULL, 'B', 0, 4, 0),
(2587, '2011 款', NULL, 583, 0, NULL, 'B', 0, 4, 0),
(2588, '2013 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2589, '2012 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2590, '2011 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2591, '2010 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2592, '2009 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2593, '2008 款', NULL, 584, 0, NULL, 'B', 0, 4, 0),
(2594, '2014 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2595, '2013 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2596, '2012 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2597, '2011 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2598, '2010 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2599, '2009 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2600, '2008 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2601, '2007 款', NULL, 585, 0, NULL, 'B', 0, 4, 0),
(2602, '2010 款', NULL, 586, 0, NULL, 'B', 0, 4, 0),
(2603, '2008 款', NULL, 586, 0, NULL, 'B', 0, 4, 0),
(2604, '2011 款', NULL, 587, 0, NULL, 'B', 0, 4, 0),
(2605, '2009 款', NULL, 587, 0, NULL, 'B', 0, 4, 0),
(2606, '2008 款', NULL, 587, 0, NULL, 'B', 0, 4, 0),
(2607, '2007 款', NULL, 587, 0, NULL, 'B', 0, 4, 0),
(2608, '2011 款', NULL, 588, 0, NULL, 'B', 0, 4, 0),
(2609, '2010 款', NULL, 588, 0, NULL, 'B', 0, 4, 0),
(2610, '2009 款', NULL, 588, 0, NULL, 'B', 0, 4, 0),
(2611, '2008 款', NULL, 588, 0, NULL, 'B', 0, 4, 0),
(2612, '2013 款', NULL, 589, 0, NULL, 'B', 0, 4, 0),
(2613, '2012 款', NULL, 589, 0, NULL, 'B', 0, 4, 0),
(2614, '2011 款', NULL, 589, 0, NULL, 'B', 0, 4, 0),
(2615, '2010 款', NULL, 589, 0, NULL, 'B', 0, 4, 0),
(2616, '2011 款', NULL, 590, 0, NULL, 'B', 0, 4, 0),
(2617, '2013 款', NULL, 591, 0, NULL, 'B', 0, 4, 0),
(2618, '2012 款', NULL, 591, 0, NULL, 'B', 0, 4, 0),
(2619, '2011 款', NULL, 591, 0, NULL, 'B', 0, 4, 0),
(2620, '2013 款', NULL, 592, 0, NULL, 'B', 0, 4, 0),
(2621, '2012 款', NULL, 592, 0, NULL, 'B', 0, 4, 0),
(2622, '2011 款', NULL, 592, 0, NULL, 'B', 0, 4, 0),
(2623, '2010 款', NULL, 592, 0, NULL, 'B', 0, 4, 0),
(2624, '2013 款', NULL, 593, 0, NULL, 'B', 0, 4, 0),
(2625, '2011 款', NULL, 593, 0, NULL, 'B', 0, 4, 0),
(2626, '2010 款', NULL, 593, 0, NULL, 'B', 0, 4, 0),
(2627, '2014 款', NULL, 594, 0, NULL, 'B', 0, 4, 0),
(2628, '2013 款', NULL, 594, 0, NULL, 'B', 0, 4, 0),
(2629, '2012 款', NULL, 594, 0, NULL, 'B', 0, 4, 0),
(2630, '2011 款', NULL, 594, 0, NULL, 'B', 0, 4, 0),
(2631, '2009 款', NULL, 595, 0, NULL, 'B', 0, 4, 0),
(2632, '2005 款', NULL, 596, 0, NULL, 'B', 0, 4, 0),
(2633, '2004 款', NULL, 596, 0, NULL, 'B', 0, 4, 0),
(2634, '2003 款', NULL, 596, 0, NULL, 'B', 0, 4, 0),
(2635, '2001 款', NULL, 596, 0, NULL, 'B', 0, 4, 0),
(2636, '2014 款', NULL, 597, 0, NULL, 'B', 0, 4, 0),
(2637, '2013 款', NULL, 598, 0, NULL, 'B', 0, 4, 0),
(2638, '2014 款', NULL, 599, 0, NULL, 'B', 0, 4, 0),
(2639, '2013 款', NULL, 599, 0, NULL, 'B', 0, 4, 0),
(2640, '2012 款', NULL, 599, 0, NULL, 'B', 0, 4, 0),
(2641, '2012 款', NULL, 600, 0, NULL, 'B', 0, 4, 0),
(2642, '2013 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2643, '2012 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2644, '2010 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2645, '2008 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2646, '2007 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2647, '2006 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2648, '2005 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2649, '2004 款', NULL, 601, 0, NULL, 'B', 0, 4, 0),
(2650, '2013 款', NULL, 602, 0, NULL, 'B', 0, 4, 0),
(2651, '2013 款', NULL, 603, 0, NULL, 'B', 0, 4, 0),
(2652, '2009 款', NULL, 603, 0, NULL, 'B', 0, 4, 0),
(2653, '2012 款', NULL, 604, 0, NULL, 'B', 0, 4, 0),
(2654, '2014 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2655, '2013 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2656, '2012 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2657, '2011 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2658, '2009 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2659, '2008 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2660, '2006 款', NULL, 605, 0, NULL, 'B', 0, 4, 0),
(2661, '2014 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2662, '2013 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2663, '2011 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2664, '2009 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2665, '2008 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2666, '2007 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2667, '2006 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2668, '2005 款', NULL, 606, 0, NULL, 'B', 0, 4, 0),
(2669, '2002 款', NULL, 606, 0, NULL, 'B', 0, 4, 0);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(2670, '2014 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2671, '2013 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2672, '2012 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2673, '2011 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2674, '2008 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2675, '2006 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2676, '2004 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2677, '2003 款', NULL, 607, 0, NULL, 'B', 0, 4, 0),
(2678, '2014 款', NULL, 608, 0, NULL, 'B', 0, 4, 0),
(2679, '2012 款', NULL, 608, 0, NULL, 'B', 0, 4, 0),
(2680, '2009 款', NULL, 608, 0, NULL, 'B', 0, 4, 0),
(2681, '2008 款', NULL, 608, 0, NULL, 'B', 0, 4, 0),
(2682, '2014 款', NULL, 609, 0, NULL, 'B', 0, 4, 0),
(2683, '2012 款', NULL, 609, 0, NULL, 'B', 0, 4, 0),
(2684, '2011 款', NULL, 609, 0, NULL, 'B', 0, 4, 0),
(2685, '2010 款', NULL, 609, 0, NULL, 'B', 0, 4, 0),
(2686, '2013 款', NULL, 610, 0, NULL, 'B', 0, 4, 0),
(2687, '2007 款', NULL, 611, 0, NULL, 'B', 0, 4, 0),
(2688, '2006 款', NULL, 611, 0, NULL, 'B', 0, 4, 0),
(2689, '2014 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2690, '2013 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2691, '2012 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2692, '2011 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2693, '2010 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2694, '2009 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2695, '2008 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2696, '2007 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2697, '2006 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2698, '2005 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2699, '2004 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2700, '2003 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2701, '2001 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2702, '2000 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2703, '1999 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2704, '1998 款', NULL, 612, 0, NULL, 'B', 0, 4, 0),
(2705, '2005 款', NULL, 613, 0, NULL, 'B', 0, 4, 0),
(2706, '2004 款', NULL, 613, 0, NULL, 'B', 0, 4, 0),
(2707, '2012 款', NULL, 614, 0, NULL, 'B', 0, 4, 0),
(2708, '1990 款', NULL, 615, 0, NULL, 'B', 0, 4, 0),
(2709, '2001 款', NULL, 616, 0, NULL, 'B', 0, 4, 0),
(2710, '1995 款', NULL, 616, 0, NULL, 'B', 0, 4, 0),
(2711, '2004 款', NULL, 617, 0, NULL, 'B', 0, 4, 0),
(2712, '2003 款', NULL, 617, 0, NULL, 'B', 0, 4, 0),
(2713, '2010 款', NULL, 618, 0, NULL, 'B', 0, 4, 0),
(2714, '2008 款', NULL, 618, 0, NULL, 'B', 0, 4, 0),
(2715, '2000 款', NULL, 618, 0, NULL, 'B', 0, 4, 0),
(2716, '1993 款', NULL, 618, 0, NULL, 'B', 0, 4, 0),
(2717, '2005 款', NULL, 619, 0, NULL, 'B', 0, 4, 0),
(2718, '2003 款', NULL, 620, 0, NULL, 'B', 0, 4, 0),
(2719, '1996 款', NULL, 620, 0, NULL, 'B', 0, 4, 0),
(2720, '2009 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2721, '2008 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2722, '2007 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2723, '2004 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2724, '2003 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2725, '1997 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2726, '1996 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2727, '1994 款', NULL, 621, 0, NULL, 'B', 0, 4, 0),
(2728, '2013 款', NULL, 622, 0, NULL, 'B', 0, 4, 0),
(2729, '2013 款', NULL, 623, 0, NULL, 'B', 0, 4, 0),
(2730, '2012 款', NULL, 623, 0, NULL, 'B', 0, 4, 0),
(2731, '2011 款', NULL, 623, 0, NULL, 'B', 0, 4, 0),
(2732, '2009 款', NULL, 623, 0, NULL, 'B', 0, 4, 0),
(2733, '2014 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2734, '2012 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2735, '2011 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2736, '2010 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2737, '2009 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2738, '2007 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2739, '2006 款', NULL, 624, 0, NULL, 'B', 0, 4, 0),
(2740, '2014 款', NULL, 625, 0, NULL, 'B', 0, 4, 0),
(2741, '2012 款', NULL, 625, 0, NULL, 'B', 0, 4, 0),
(2742, '2013 款', NULL, 626, 0, NULL, 'B', 0, 4, 0),
(2743, '2003 款', NULL, 627, 0, NULL, 'B', 0, 4, 0),
(2744, '2003 款', NULL, 628, 0, NULL, 'B', 0, 4, 0),
(2745, '2004 款', NULL, 629, 0, NULL, 'B', 0, 4, 0),
(2746, '2003 款', NULL, 630, 0, NULL, 'B', 0, 4, 0),
(2747, '其他', NULL, 630, 0, NULL, 'B', 0, 4, 0),
(2748, '2004 款', NULL, 631, 0, NULL, 'B', 0, 4, 0),
(2749, '2003 款', NULL, 631, 0, NULL, 'B', 0, 4, 0),
(2750, '2014 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2751, '2013 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2752, '2012 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2753, '2011 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2754, '2010 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2755, '2009 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2756, '2008 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2757, '2007 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2758, '2006 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2759, '2005 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2760, '2004 款', NULL, 632, 0, NULL, 'B', 0, 4, 0),
(2761, '2014 款', NULL, 633, 0, NULL, 'B', 0, 4, 0),
(2762, '2011 款', NULL, 633, 0, NULL, 'B', 0, 4, 0),
(2763, '2014 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2764, '2013 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2765, '2011 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2766, '2010 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2767, '2009 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2768, '2008 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2769, '2005 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2770, '2003 款', NULL, 634, 0, NULL, 'B', 0, 4, 0),
(2771, '2014 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2772, '2013 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2773, '2012 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2774, '2011 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2775, '2009 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2776, '2008 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2777, '2007 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2778, '2006 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2779, '2004 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2780, '2003 款', NULL, 635, 0, NULL, 'B', 0, 4, 0),
(2781, '2014 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2782, '2013 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2783, '2012 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2784, '2011 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2785, '2009 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2786, '2008 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2787, '2006 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2788, '2005 款', NULL, 636, 0, NULL, 'B', 0, 4, 0),
(2789, '2014 款', NULL, 637, 0, NULL, 'B', 0, 4, 0),
(2790, '2014 款', NULL, 638, 0, NULL, 'B', 0, 4, 0),
(2791, '2013 款', NULL, 638, 0, NULL, 'B', 0, 4, 0),
(2792, '2012 款', NULL, 638, 0, NULL, 'B', 0, 4, 0),
(2793, '2010 款', NULL, 638, 0, NULL, 'B', 0, 4, 0),
(2794, '2007 款', NULL, 639, 0, NULL, 'B', 0, 4, 0),
(2795, '2005 款', NULL, 639, 0, NULL, 'B', 0, 4, 0),
(2796, '2002 款', NULL, 639, 0, NULL, 'B', 0, 4, 0),
(2797, '2014 款', NULL, 640, 0, NULL, 'B', 0, 4, 0),
(2798, '2013 款', NULL, 640, 0, NULL, 'B', 0, 4, 0),
(2799, '2014 款', NULL, 641, 0, NULL, 'B', 0, 4, 0),
(2800, '2013 款', NULL, 641, 0, NULL, 'B', 0, 4, 0),
(2801, '2012 款', NULL, 641, 0, NULL, 'B', 0, 4, 0),
(2802, '2010 款', NULL, 641, 0, NULL, 'B', 0, 4, 0),
(2803, '2014 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2804, '2012 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2805, '2011 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2806, '2010 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2807, '2007 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2808, '2005 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2809, '2004 款', NULL, 642, 0, NULL, 'B', 0, 4, 0),
(2810, '2009 款', NULL, 643, 0, NULL, 'B', 0, 4, 0),
(2811, '2006 款', NULL, 643, 0, NULL, 'B', 0, 4, 0),
(2812, '2014 款', NULL, 644, 0, NULL, 'B', 0, 4, 0),
(2813, '2013 款', NULL, 644, 0, NULL, 'B', 0, 4, 0),
(2814, '2000 款', NULL, 645, 0, NULL, 'B', 0, 4, 0),
(2815, '1999 款', NULL, 645, 0, NULL, 'B', 0, 4, 0),
(2816, '2014 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2817, '2013 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2818, '2012 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2819, '2011 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2820, '2008 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2821, '2007 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2822, '2006 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2823, '2005 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2824, '2004 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2825, '2003 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2826, '2001 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2827, '2000 款', NULL, 646, 0, NULL, 'B', 0, 4, 0),
(2828, '2014 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2829, '2013 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2830, '2012 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2831, '2011 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2832, '2010 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2833, '2009 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2834, '2007 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2835, '2006 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2836, '2005 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2837, '2004 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2838, '2003 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2839, '2002 款', NULL, 647, 0, NULL, 'B', 0, 4, 0),
(2840, '2013 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2841, '2012 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2842, '2011 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2843, '2010 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2844, '2009 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2845, '2008 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2846, '2007 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2847, '2006 款', NULL, 648, 0, NULL, 'B', 0, 4, 0),
(2848, '2013 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2849, '2011 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2850, '2010 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2851, '2008 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2852, '2007 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2853, '2006 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2854, '2005 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2855, '2004 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2856, '2003 款', NULL, 649, 0, NULL, 'B', 0, 4, 0),
(2857, '2008 款', NULL, 650, 0, NULL, 'B', 0, 4, 0),
(2858, '2007 款', NULL, 650, 0, NULL, 'B', 0, 4, 0),
(2859, '2006 款', NULL, 650, 0, NULL, 'B', 0, 4, 0),
(2860, '2005 款', NULL, 650, 0, NULL, 'B', 0, 4, 0),
(2861, '2004 款', NULL, 650, 0, NULL, 'B', 0, 4, 0),
(2862, '2008 款', NULL, 651, 0, NULL, 'B', 0, 4, 0),
(2863, '2007 款', NULL, 651, 0, NULL, 'B', 0, 4, 0),
(2864, '2006 款', NULL, 651, 0, NULL, 'B', 0, 4, 0),
(2865, '2005 款', NULL, 651, 0, NULL, 'B', 0, 4, 0),
(2866, '2012 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2867, '2011 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2868, '2010 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2869, '2009 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2870, '2008 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2871, '2007 款', NULL, 652, 0, NULL, 'B', 0, 4, 0),
(2872, '2005 款', NULL, 653, 0, NULL, 'B', 0, 4, 0),
(2873, '2004 款', NULL, 654, 0, NULL, 'B', 0, 4, 0),
(2874, '2003 款', NULL, 654, 0, NULL, 'B', 0, 4, 0),
(2875, '2002 款', NULL, 654, 0, NULL, 'B', 0, 4, 0),
(2876, '2001 款', NULL, 654, 0, NULL, 'B', 0, 4, 0),
(2877, '2013 款', NULL, 655, 0, NULL, 'B', 0, 4, 0),
(2878, '2012 款', NULL, 655, 0, NULL, 'B', 0, 4, 0),
(2879, '2011 款', NULL, 655, 0, NULL, 'B', 0, 4, 0),
(2880, '2010 款', NULL, 655, 0, NULL, 'B', 0, 4, 0),
(2881, '2014 款', NULL, 656, 0, NULL, 'B', 0, 4, 0),
(2882, '2013 款', NULL, 656, 0, NULL, 'B', 0, 4, 0),
(2883, '2012 款', NULL, 656, 0, NULL, 'B', 0, 4, 0),
(2884, '2010 款', NULL, 656, 0, NULL, 'B', 0, 4, 0),
(2885, '2009 款', NULL, 656, 0, NULL, 'B', 0, 4, 0),
(2886, '2014 款', NULL, 657, 0, NULL, 'B', 0, 4, 0),
(2887, '2013 款', NULL, 657, 0, NULL, 'B', 0, 4, 0),
(2888, '2010 款', NULL, 657, 0, NULL, 'B', 0, 4, 0),
(2889, '2009 款', NULL, 657, 0, NULL, 'B', 0, 4, 0),
(2890, '1991 款', NULL, 658, 0, NULL, 'B', 0, 4, 0),
(2891, '1996 款', NULL, 659, 0, NULL, 'B', 0, 4, 0),
(2892, '1993 款', NULL, 659, 0, NULL, 'B', 0, 4, 0),
(2893, '2010 款', NULL, 660, 0, NULL, 'B', 0, 4, 0),
(2894, '2009 款', NULL, 660, 0, NULL, 'B', 0, 4, 0),
(2895, '2008 款', NULL, 660, 0, NULL, 'B', 0, 4, 0),
(2896, '2014 款', NULL, 661, 0, NULL, 'B', 0, 4, 0),
(2897, '2014 款', NULL, 662, 0, NULL, 'B', 0, 4, 0),
(2898, '2013 款', NULL, 662, 0, NULL, 'B', 0, 4, 0),
(2899, '2012 款', NULL, 662, 0, NULL, 'B', 0, 4, 0),
(2900, '2011 款', NULL, 662, 0, NULL, 'B', 0, 4, 0),
(2901, '2012 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2902, '2010 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2903, '2009 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2904, '2008 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2905, '2007 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2906, '2006 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2907, '2004 款', NULL, 663, 0, NULL, 'B', 0, 4, 0),
(2908, '2014 款', NULL, 664, 0, NULL, 'B', 0, 4, 0),
(2909, '2013 款', NULL, 665, 0, NULL, 'B', 0, 4, 0),
(2910, '2012 款', NULL, 665, 0, NULL, 'B', 0, 4, 0),
(2911, '2013 款', NULL, 666, 0, NULL, 'B', 0, 4, 0),
(2912, '2013 款', NULL, 667, 0, NULL, 'B', 0, 4, 0),
(2913, '2014 款', NULL, 668, 0, NULL, 'B', 0, 4, 0),
(2914, '2013 款', NULL, 668, 0, NULL, 'B', 0, 4, 0),
(2915, '2011 款', NULL, 668, 0, NULL, 'B', 0, 4, 0),
(2916, '2014 款', NULL, 669, 0, NULL, 'B', 0, 4, 0),
(2917, '2014 款', NULL, 670, 0, NULL, 'B', 0, 4, 0),
(2918, '2013 款', NULL, 670, 0, NULL, 'B', 0, 4, 0),
(2919, '2012 款', NULL, 671, 0, NULL, 'B', 0, 4, 0),
(2920, '2011 款', NULL, 671, 0, NULL, 'B', 0, 4, 0),
(2921, '2011 款', NULL, 672, 0, NULL, 'B', 0, 4, 0),
(2922, '2013 款', NULL, 673, 0, NULL, 'B', 0, 4, 0),
(2923, '2011 款', NULL, 673, 0, NULL, 'B', 0, 4, 0),
(2924, '2013 款', NULL, 674, 0, NULL, 'B', 0, 4, 0),
(2925, '2011 款', NULL, 674, 0, NULL, 'B', 0, 4, 0),
(2926, '2012 款', NULL, 675, 0, NULL, 'B', 0, 4, 0),
(2927, '2013 款', NULL, 676, 0, NULL, 'B', 0, 4, 0),
(2928, '2011 款', NULL, 676, 0, NULL, 'B', 0, 4, 0),
(2929, '2012 款', NULL, 677, 0, NULL, 'B', 0, 4, 0),
(2930, '2014 款', NULL, 678, 0, NULL, 'B', 0, 4, 0),
(2931, '2014 款', NULL, 679, 0, NULL, 'B', 0, 4, 0),
(2932, '2014 款', NULL, 680, 0, NULL, 'B', 0, 4, 0),
(2933, '2013 款', NULL, 681, 0, NULL, 'C', 0, 4, 0),
(2934, '2011 款', NULL, 681, 0, NULL, 'C', 0, 4, 0),
(2935, '2014 款', NULL, 682, 0, NULL, 'C', 0, 4, 0),
(2936, '2013 款', NULL, 682, 0, NULL, 'C', 0, 4, 0),
(2937, '2012 款', NULL, 682, 0, NULL, 'C', 0, 4, 0),
(2938, '2010 款', NULL, 682, 0, NULL, 'C', 0, 4, 0),
(2939, '2014 款', NULL, 683, 0, NULL, 'C', 0, 4, 0),
(2940, '2013 款', NULL, 683, 0, NULL, 'C', 0, 4, 0),
(2941, '2012 款', NULL, 683, 0, NULL, 'C', 0, 4, 0),
(2942, '2012 款', NULL, 684, 0, NULL, 'C', 0, 4, 0),
(2943, '2010 款', NULL, 684, 0, NULL, 'C', 0, 4, 0),
(2944, '2014 款', NULL, 685, 0, NULL, 'C', 0, 4, 0),
(2945, '2012 款', NULL, 685, 0, NULL, 'C', 0, 4, 0),
(2946, '2013 款', NULL, 686, 0, NULL, 'C', 0, 4, 0),
(2947, '2012 款', NULL, 686, 0, NULL, 'C', 0, 4, 0),
(2948, '2010 款', NULL, 686, 0, NULL, 'C', 0, 4, 0),
(2949, '2009 款', NULL, 686, 0, NULL, 'C', 0, 4, 0),
(2950, '2008 款', NULL, 686, 0, NULL, 'C', 0, 4, 0),
(2951, '2009 款', NULL, 687, 0, NULL, 'C', 0, 4, 0),
(2952, '2008 款', NULL, 687, 0, NULL, 'C', 0, 4, 0),
(2953, '2003 款', NULL, 688, 0, NULL, 'C', 0, 4, 0),
(2954, '2011 款', NULL, 689, 0, NULL, 'C', 0, 4, 0),
(2955, '2013 款', NULL, 690, 0, NULL, 'C', 0, 4, 0),
(2956, '2012 款', NULL, 690, 0, NULL, 'C', 0, 4, 0),
(2957, '2009 款', NULL, 690, 0, NULL, 'C', 0, 4, 0),
(2958, '2014 款', NULL, 691, 0, NULL, 'C', 0, 4, 0),
(2959, '2013 款', NULL, 692, 0, NULL, 'C', 0, 4, 0),
(2960, '2011 款', NULL, 692, 0, NULL, 'C', 0, 4, 0),
(2961, '2008 款', NULL, 693, 0, NULL, 'C', 0, 4, 0),
(2962, '2007 款', NULL, 693, 0, NULL, 'C', 0, 4, 0),
(2963, '2004 款', NULL, 693, 0, NULL, 'C', 0, 4, 0),
(2964, '2003 款', NULL, 693, 0, NULL, 'C', 0, 4, 0),
(2965, '2002 款', NULL, 693, 0, NULL, 'C', 0, 4, 0),
(2966, '2010 款', NULL, 694, 0, NULL, 'C', 0, 4, 0),
(2967, '2009 款', NULL, 694, 0, NULL, 'C', 0, 4, 0),
(2968, '2010 款', NULL, 695, 0, NULL, 'C', 0, 4, 0),
(2969, '2006 款', NULL, 696, 0, NULL, 'C', 0, 4, 0),
(2970, '2004 款', NULL, 696, 0, NULL, 'C', 0, 4, 0),
(2971, '2003 款', NULL, 696, 0, NULL, 'C', 0, 4, 0),
(2972, '2002 款', NULL, 696, 0, NULL, 'C', 0, 4, 0),
(2973, '2005 款', NULL, 697, 0, NULL, 'C', 0, 4, 0),
(2974, '2008 款', NULL, 698, 0, NULL, 'C', 0, 4, 0),
(2975, '2004 款', NULL, 698, 0, NULL, 'C', 0, 4, 0),
(2976, '2008 款', NULL, 699, 0, NULL, 'C', 0, 4, 0),
(2977, '2003 款', NULL, 699, 0, NULL, 'C', 0, 4, 0),
(2978, '2002 款', NULL, 699, 0, NULL, 'C', 0, 4, 0),
(2979, '2001 款', NULL, 699, 0, NULL, 'C', 0, 4, 0),
(2980, '2009 款', NULL, 700, 0, NULL, 'C', 0, 4, 0),
(2981, '2008 款', NULL, 700, 0, NULL, 'C', 0, 4, 0),
(2982, '2007 款', NULL, 700, 0, NULL, 'C', 0, 4, 0),
(2983, '2004 款', NULL, 700, 0, NULL, 'C', 0, 4, 0),
(2984, '2003 款', NULL, 700, 0, NULL, 'C', 0, 4, 0),
(2985, '2010 款', NULL, 701, 0, NULL, 'C', 0, 4, 0),
(2986, '2009 款', NULL, 701, 0, NULL, 'C', 0, 4, 0),
(2987, '2008 款', NULL, 701, 0, NULL, 'C', 0, 4, 0),
(2988, '2011 款', NULL, 702, 0, NULL, 'C', 0, 4, 0),
(2989, '2010 款', NULL, 702, 0, NULL, 'C', 0, 4, 0),
(2990, '2009 款', NULL, 702, 0, NULL, 'C', 0, 4, 0),
(2991, '2011 款', NULL, 703, 0, NULL, 'C', 0, 4, 0),
(2992, '2005 款', NULL, 703, 0, NULL, 'C', 0, 4, 0),
(2993, '2004 款', NULL, 703, 0, NULL, 'C', 0, 4, 0),
(2994, '2007 款', NULL, 704, 0, NULL, 'C', 0, 4, 0),
(2995, '2006 款', NULL, 704, 0, NULL, 'C', 0, 4, 0),
(2996, '1999 款', NULL, 705, 0, NULL, 'C', 0, 4, 0),
(2997, '1999 款', NULL, 706, 0, NULL, 'C', 0, 4, 0),
(2998, '1999 款', NULL, 707, 0, NULL, 'C', 0, 4, 0),
(2999, '1999 款', NULL, 708, 0, NULL, 'C', 0, 4, 0),
(3000, '2014 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3001, '2013 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3002, '2011 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3003, '2010 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3004, '2009 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3005, '2006 款', NULL, 709, 0, NULL, 'C', 0, 4, 0),
(3006, '2011 款', NULL, 710, 0, NULL, 'C', 0, 4, 0),
(3007, '2000 款', NULL, 711, 0, NULL, 'C', 0, 4, 0),
(3008, '2014 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3009, '2010 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3010, '2009 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3011, '2008 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3012, '2007 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3013, '2006 款', NULL, 712, 0, NULL, 'C', 0, 4, 0),
(3014, '2012 款', NULL, 713, 0, NULL, 'C', 0, 4, 0),
(3015, '2011 款', NULL, 713, 0, NULL, 'C', 0, 4, 0),
(3016, '2010 款', NULL, 713, 0, NULL, 'C', 0, 4, 0),
(3017, '2009 款', NULL, 713, 0, NULL, 'C', 0, 4, 0),
(3018, '2014 款', NULL, 714, 0, NULL, 'C', 0, 4, 0),
(3019, '2012 款', NULL, 714, 0, NULL, 'C', 0, 4, 0),
(3020, '2014 款', NULL, 715, 0, NULL, 'C', 0, 4, 0),
(3021, '2014 款', NULL, 716, 0, NULL, 'C', 0, 4, 0),
(3022, '2011 款', NULL, 716, 0, NULL, 'C', 0, 4, 0),
(3023, '2010 款', NULL, 717, 0, NULL, 'C', 0, 4, 0),
(3024, '2012 款', NULL, 718, 0, NULL, 'C', 0, 4, 0),
(3025, '2011 款', NULL, 718, 0, NULL, 'C', 0, 4, 0),
(3026, '2009 款', NULL, 719, 0, NULL, 'C', 0, 4, 0),
(3027, '2008 款', NULL, 719, 0, NULL, 'C', 0, 4, 0),
(3028, '2007 款', NULL, 719, 0, NULL, 'C', 0, 4, 0),
(3029, '2013 款', NULL, 720, 0, NULL, 'C', 0, 4, 0),
(3030, '2014 款', NULL, 721, 0, NULL, 'C', 0, 4, 0),
(3031, '2013 款', NULL, 721, 0, NULL, 'C', 0, 4, 0),
(3032, '2012 款', NULL, 721, 0, NULL, 'C', 0, 4, 0),
(3033, '2012 款', NULL, 722, 0, NULL, 'C', 0, 4, 0),
(3034, '2011 款', NULL, 722, 0, NULL, 'C', 0, 4, 0),
(3035, '2010 款', NULL, 722, 0, NULL, 'C', 0, 4, 0),
(3036, '2009 款', NULL, 722, 0, NULL, 'C', 0, 4, 0),
(3037, '2012 款', NULL, 723, 0, NULL, 'C', 0, 4, 0),
(3038, '2012 款', NULL, 724, 0, NULL, 'C', 0, 4, 0),
(3039, '2010 款', NULL, 725, 0, NULL, 'C', 0, 4, 0),
(3040, '2009 款', NULL, 725, 0, NULL, 'C', 0, 4, 0),
(3041, '2009 款', NULL, 726, 0, NULL, 'C', 0, 4, 0),
(3042, '2008 款', NULL, 726, 0, NULL, 'C', 0, 4, 0),
(3043, '2013 款', NULL, 727, 0, NULL, 'C', 0, 4, 0),
(3044, '2004 款', NULL, 728, 0, NULL, 'C', 0, 4, 0),
(3045, '其他', NULL, 728, 0, NULL, 'C', 0, 4, 0),
(3046, '2006 款', NULL, 729, 0, NULL, 'C', 0, 4, 0),
(3047, '2005 款', NULL, 729, 0, NULL, 'C', 0, 4, 0),
(3048, '2004 款', NULL, 729, 0, NULL, 'C', 0, 4, 0),
(3049, '2003 款', NULL, 729, 0, NULL, 'C', 0, 4, 0),
(3050, '2014 款', NULL, 730, 0, NULL, 'C', 0, 4, 0),
(3051, '2012 款', NULL, 730, 0, NULL, 'C', 0, 4, 0),
(3052, '2014 款', NULL, 731, 0, NULL, 'C', 0, 4, 0),
(3053, '2012 款', NULL, 732, 0, NULL, 'C', 0, 4, 0),
(3054, '2012 款', NULL, 733, 0, NULL, 'C', 0, 4, 0),
(3055, '2007 款', NULL, 733, 0, NULL, 'C', 0, 4, 0),
(3056, '2006 款', NULL, 733, 0, NULL, 'C', 0, 4, 0),
(3057, '1999 款', NULL, 733, 0, NULL, 'C', 0, 4, 0),
(3058, '2012 款', NULL, 734, 0, NULL, 'C', 0, 4, 0),
(3059, '2009 款', NULL, 734, 0, NULL, 'C', 0, 4, 0),
(3060, '2007 款', NULL, 734, 0, NULL, 'C', 0, 4, 0),
(3061, '2006 款', NULL, 734, 0, NULL, 'C', 0, 4, 0),
(3062, '2012 款', NULL, 735, 0, NULL, 'C', 0, 4, 0),
(3063, '2009 款', NULL, 735, 0, NULL, 'C', 0, 4, 0),
(3064, '2014 款', NULL, 736, 0, NULL, 'C', 0, 4, 0),
(3065, '2013 款', NULL, 736, 0, NULL, 'C', 0, 4, 0),
(3066, '2012 款', NULL, 736, 0, NULL, 'C', 0, 4, 0),
(3067, '2010 款', NULL, 736, 0, NULL, 'C', 0, 4, 0),
(3068, '2007 款', NULL, 736, 0, NULL, 'C', 0, 4, 0),
(3069, '2003 款', NULL, 737, 0, NULL, 'C', 0, 4, 0),
(3070, '2006 款', NULL, 738, 0, NULL, 'C', 0, 4, 0),
(3071, '2013 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3072, '2012 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3073, '2009 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3074, '2008 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3075, '2007 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3076, '2006 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3077, '2005 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3078, '2003 款', NULL, 739, 0, NULL, 'C', 0, 4, 0),
(3079, '2013 款', NULL, 740, 0, NULL, 'C', 0, 4, 0),
(3080, '2012 款', NULL, 740, 0, NULL, 'C', 0, 4, 0),
(3081, '2009 款', NULL, 740, 0, NULL, 'C', 0, 4, 0),
(3082, '其他', NULL, 740, 0, NULL, 'C', 0, 4, 0),
(3083, '2014 款', NULL, 741, 0, NULL, 'C', 0, 4, 0),
(3084, '2013 款', NULL, 741, 0, NULL, 'C', 0, 4, 0),
(3085, '2012 款', NULL, 741, 0, NULL, 'C', 0, 4, 0),
(3086, '2011 款', NULL, 741, 0, NULL, 'C', 0, 4, 0),
(3087, '2010 款', NULL, 741, 0, NULL, 'C', 0, 4, 0),
(3088, '2014 款', NULL, 742, 0, NULL, 'C', 0, 4, 0),
(3089, '2014 款', NULL, 743, 0, NULL, 'C', 0, 4, 0),
(3090, '2013 款', NULL, 743, 0, NULL, 'C', 0, 4, 0),
(3091, '2010 款', NULL, 744, 0, NULL, 'C', 0, 4, 0),
(3092, '2009 款', NULL, 745, 0, NULL, 'D', 0, 4, 0),
(3093, '2008 款', NULL, 745, 0, NULL, 'D', 0, 4, 0),
(3094, '2007 款', NULL, 745, 0, NULL, 'D', 0, 4, 0),
(3095, '2006 款', NULL, 745, 0, NULL, 'D', 0, 4, 0),
(3096, '2014 款', NULL, 746, 0, NULL, 'D', 0, 4, 0),
(3097, '2012 款', NULL, 746, 0, NULL, 'D', 0, 4, 0),
(3098, '2009 款', NULL, 746, 0, NULL, 'D', 0, 4, 0),
(3099, '2007 款', NULL, 746, 0, NULL, 'D', 0, 4, 0),
(3100, '2014 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3101, '2013 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3102, '2012 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3103, '2011 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3104, '2007 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3105, '2005 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3106, '2004 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3107, '2003 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3108, '2002 款', NULL, 747, 0, NULL, 'D', 0, 4, 0),
(3109, '2012 款', NULL, 748, 0, NULL, 'D', 0, 4, 0),
(3110, '2011 款', NULL, 749, 0, NULL, 'D', 0, 4, 0),
(3111, '2009 款', NULL, 749, 0, NULL, 'D', 0, 4, 0),
(3112, '2008 款', NULL, 749, 0, NULL, 'D', 0, 4, 0),
(3113, '2006 款', NULL, 749, 0, NULL, 'D', 0, 4, 0),
(3114, '2004 款', NULL, 750, 0, NULL, 'D', 0, 4, 0),
(3115, '2003 款', NULL, 750, 0, NULL, 'D', 0, 4, 0),
(3116, '2014 款', NULL, 751, 0, NULL, 'D', 0, 4, 0),
(3117, '2013 款', NULL, 751, 0, NULL, 'D', 0, 4, 0),
(3118, '2014 款', NULL, 752, 0, NULL, 'D', 0, 4, 0),
(3119, '2013 款', NULL, 752, 0, NULL, 'D', 0, 4, 0),
(3120, '2014 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3121, '2013 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3122, '2012 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3123, '2011 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3124, '2010 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3125, '2009 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3126, '2008 款', NULL, 753, 0, NULL, 'D', 0, 4, 0),
(3127, '2014 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3128, '2013 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3129, '2011 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3130, '2008 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3131, '2007 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3132, '2006 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3133, '2005 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3134, '2004 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3135, '2003 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3136, '2002 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3137, '2001 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3138, '2000 款', NULL, 754, 0, NULL, 'D', 0, 4, 0),
(3139, '2011 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3140, '2009 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3141, '2008 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3142, '2007 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3143, '2006 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3144, '2005 款', NULL, 755, 0, NULL, 'D', 0, 4, 0),
(3145, '2013 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3146, '2007 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3147, '2006 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3148, '2005 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3149, '2003 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3150, '2001 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3151, '2000 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3152, '1999 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3153, '1998 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3154, '1997 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3155, '1995 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3156, '1994 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3157, '1993 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3158, '1991 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3159, '1985 款', NULL, 756, 0, NULL, 'D', 0, 4, 0),
(3160, '2003 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3161, '2002 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3162, '2001 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3163, '2000 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3164, '1998 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3165, '1997 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3166, '1996 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3167, '1995 款', NULL, 757, 0, NULL, 'D', 0, 4, 0),
(3168, '2006 款', NULL, 758, 0, NULL, 'D', 0, 4, 0),
(3169, '2005 款', NULL, 758, 0, NULL, 'D', 0, 4, 0),
(3170, '2004 款', NULL, 758, 0, NULL, 'D', 0, 4, 0),
(3171, '2010 款', NULL, 759, 0, NULL, 'D', 0, 4, 0),
(3172, '2009 款', NULL, 759, 0, NULL, 'D', 0, 4, 0),
(3173, '2008 款', NULL, 759, 0, NULL, 'D', 0, 4, 0),
(3174, '2013 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3175, '2011 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3176, '2008 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3177, '2007 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3178, '2006 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3179, '2005 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3180, '2004 款', NULL, 760, 0, NULL, 'D', 0, 4, 0),
(3181, '2013 款', NULL, 761, 0, NULL, 'D', 0, 4, 0),
(3182, '2012 款', NULL, 761, 0, NULL, 'D', 0, 4, 0),
(3183, '2010 款', NULL, 761, 0, NULL, 'D', 0, 4, 0),
(3184, '2014 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3185, '2013 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3186, '2012 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3187, '2011 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3188, '2010 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3189, '2009 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3190, '2008 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3191, '2007 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3192, '2006 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3193, '2005 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3194, '2004 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3195, '2003 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3196, '2002 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3197, '2001 款', NULL, 762, 0, NULL, 'D', 0, 4, 0),
(3198, '2007 款', NULL, 763, 0, NULL, 'D', 0, 4, 0),
(3199, '2006 款', NULL, 763, 0, NULL, 'D', 0, 4, 0),
(3200, '2014 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3201, '2012 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3202, '2011 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3203, '2010 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3204, '2009 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3205, '2008 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3206, '2006 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3207, '2005 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3208, '2004 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3209, '2003 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3210, '1994 款', NULL, 764, 0, NULL, 'D', 0, 4, 0),
(3211, '2012 款', NULL, 765, 0, NULL, 'D', 0, 4, 0),
(3212, '2010 款', NULL, 765, 0, NULL, 'D', 0, 4, 0),
(3213, '2009 款', NULL, 765, 0, NULL, 'D', 0, 4, 0),
(3214, '2013 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3215, '2012 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3216, '2011 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3217, '2010 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3218, '2009 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3219, '2008 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3220, '2007 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3221, '2006 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3222, '2005 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3223, '2004 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3224, '2003 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3225, '2002 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3226, '2001 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3227, '2000 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3228, '1999 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3229, '1998 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3230, '1997 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3231, '1996 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3232, '1994 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3233, '1993 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3234, '1990 款', NULL, 766, 0, NULL, 'D', 0, 4, 0),
(3235, '2007 款', NULL, 767, 0, NULL, 'D', 0, 4, 0),
(3236, '2005 款', NULL, 767, 0, NULL, 'D', 0, 4, 0),
(3237, '2013 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3238, '2012 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3239, '2011 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3240, '2010 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3241, '2009 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3242, '2008 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3243, '2007 款', NULL, 768, 0, NULL, 'D', 0, 4, 0),
(3244, '2014 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3245, '2013 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3246, '2012 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3247, '2011 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3248, '2010 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3249, '2009 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3250, '2008 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3251, '2007 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3252, '2006 款', NULL, 769, 0, NULL, 'D', 0, 4, 0),
(3253, '2013 款', NULL, 770, 0, NULL, 'D', 0, 4, 0),
(3254, '2012 款', NULL, 770, 0, NULL, 'D', 0, 4, 0),
(3255, '2011 款', NULL, 770, 0, NULL, 'D', 0, 4, 0),
(3256, '2010 款', NULL, 770, 0, NULL, 'D', 0, 4, 0),
(3257, '2003 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3258, '2002 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3259, '2001 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3260, '2000 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3261, '1994 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3262, '1993 款', NULL, 771, 0, NULL, 'D', 0, 4, 0),
(3263, '2014 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3264, '2012 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3265, '2011 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3266, '2009 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3267, '2008 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3268, '2007 款', NULL, 772, 0, NULL, 'D', 0, 4, 0),
(3269, '2008 款', NULL, 773, 0, NULL, 'D', 0, 4, 0),
(3270, '2012 款', NULL, 774, 0, NULL, 'D', 0, 4, 0),
(3271, '2010 款', NULL, 774, 0, NULL, 'D', 0, 4, 0),
(3272, '2009 款', NULL, 774, 0, NULL, 'D', 0, 4, 0),
(3273, '2011 款', NULL, 775, 0, NULL, 'D', 0, 4, 0),
(3274, '2010 款', NULL, 775, 0, NULL, 'D', 0, 4, 0),
(3275, '2009 款', NULL, 775, 0, NULL, 'D', 0, 4, 0),
(3276, '2008 款', NULL, 775, 0, NULL, 'D', 0, 4, 0),
(3277, '2014 款', NULL, 776, 0, NULL, 'D', 0, 4, 0),
(3278, '2011 款', NULL, 776, 0, NULL, 'D', 0, 4, 0),
(3279, '2008 款', NULL, 776, 0, NULL, 'D', 0, 4, 0),
(3280, '1998 款', NULL, 776, 0, NULL, 'D', 0, 4, 0),
(3281, '1993 款', NULL, 776, 0, NULL, 'D', 0, 4, 0),
(3282, '2014 款', NULL, 777, 0, NULL, 'D', 0, 4, 0),
(3283, '2012 款', NULL, 777, 0, NULL, 'D', 0, 4, 0),
(3284, '2011 款', NULL, 777, 0, NULL, 'D', 0, 4, 0),
(3285, '2013 款', NULL, 778, 0, NULL, 'D', 0, 4, 0),
(3286, '2006 款', NULL, 778, 0, NULL, 'D', 0, 4, 0),
(3287, '2011 款', NULL, 779, 0, NULL, 'D', 0, 4, 0),
(3288, '2013 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3289, '2012 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3290, '2011 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3291, '2009 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3292, '2007 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3293, '2004 款', NULL, 780, 0, NULL, 'D', 0, 4, 0),
(3294, '2014 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3295, '2013 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3296, '2010 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3297, '2009 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3298, '2007 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3299, '2005 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3300, '2002 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3301, '2001 款', NULL, 781, 0, NULL, 'D', 0, 4, 0),
(3302, '2014 款', NULL, 782, 0, NULL, 'D', 0, 4, 0),
(3303, '2012 款', NULL, 783, 0, NULL, 'D', 0, 4, 0),
(3304, '2010 款', NULL, 783, 0, NULL, 'D', 0, 4, 0),
(3305, '2007 款', NULL, 783, 0, NULL, 'D', 0, 4, 0),
(3306, '2014 款', NULL, 784, 0, NULL, 'D', 0, 4, 0),
(3307, '2013 款', NULL, 784, 0, NULL, 'D', 0, 4, 0),
(3308, '2011 款', NULL, 784, 0, NULL, 'D', 0, 4, 0),
(3309, '2010 款', NULL, 784, 0, NULL, 'D', 0, 4, 0),
(3310, '2009 款', NULL, 784, 0, NULL, 'D', 0, 4, 0),
(3311, '2014 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3312, '2013 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3313, '2011 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3314, '2010 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3315, '2009 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3316, '2008 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3317, '2007 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3318, '2006 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3319, '2005 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3320, '2003 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3321, '2002 款', NULL, 785, 0, NULL, 'D', 0, 4, 0),
(3322, '2013 款', NULL, 786, 0, NULL, 'D', 0, 4, 0),
(3323, '2012 款', NULL, 786, 0, NULL, 'D', 0, 4, 0),
(3324, '2005 款', NULL, 786, 0, NULL, 'D', 0, 4, 0),
(3325, '2000 款', NULL, 786, 0, NULL, 'D', 0, 4, 0),
(3326, '2004 款', NULL, 787, 0, NULL, 'D', 0, 4, 0),
(3327, '其他', NULL, 788, 0, NULL, 'D', 0, 4, 0),
(3328, '1998 款', NULL, 789, 0, NULL, 'D', 0, 4, 0),
(3329, '2013 款', NULL, 790, 0, NULL, 'D', 0, 4, 0),
(3330, '2014 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3331, '2013 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3332, '2012 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3333, '2011 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3334, '2010 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3335, '2009 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3336, '2008 款', NULL, 791, 0, NULL, 'D', 0, 4, 0),
(3337, '2014 款', NULL, 792, 0, NULL, 'D', 0, 4, 0),
(3338, '2013 款', NULL, 792, 0, NULL, 'D', 0, 4, 0),
(3339, '2012 款', NULL, 792, 0, NULL, 'D', 0, 4, 0),
(3340, '2014 款', NULL, 793, 0, NULL, 'D', 0, 4, 0),
(3341, '2013 款', NULL, 793, 0, NULL, 'D', 0, 4, 0),
(3342, '2014 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3343, '2011 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3344, '2009 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3345, '2008 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3346, '2007 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3347, '2006 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3348, '2005 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3349, '2004 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3350, '2003 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3351, '2000 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3352, '1999 款', NULL, 794, 0, NULL, 'D', 0, 4, 0),
(3353, '2009 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3354, '2008 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3355, '2007 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3356, '2006 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3357, '2005 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3358, '2003 款', NULL, 795, 0, NULL, 'D', 0, 4, 0),
(3359, '2006 款', NULL, 796, 0, NULL, 'D', 0, 4, 0),
(3360, '2005 款', NULL, 796, 0, NULL, 'D', 0, 4, 0),
(3361, '2007 款', NULL, 797, 0, NULL, 'D', 0, 4, 0),
(3362, '2006 款', NULL, 797, 0, NULL, 'D', 0, 4, 0),
(3363, '2005 款', NULL, 797, 0, NULL, 'D', 0, 4, 0),
(3364, '2004 款', NULL, 797, 0, NULL, 'D', 0, 4, 0),
(3365, '2003 款', NULL, 797, 0, NULL, 'D', 0, 4, 0),
(3366, '2011 款', NULL, 798, 0, NULL, 'D', 0, 4, 0),
(3367, '2010 款', NULL, 798, 0, NULL, 'D', 0, 4, 0),
(3368, '2004 款', NULL, 799, 0, NULL, 'D', 0, 4, 0),
(3369, '2007 款', NULL, 800, 0, NULL, 'D', 0, 4, 0),
(3370, '2005 款', NULL, 800, 0, NULL, 'D', 0, 4, 0),
(3371, '2004 款', NULL, 800, 0, NULL, 'D', 0, 4, 0),
(3372, '2002 款', NULL, 800, 0, NULL, 'D', 0, 4, 0),
(3373, '2004 款', NULL, 801, 0, NULL, 'D', 0, 4, 0),
(3374, '2005 款', NULL, 802, 0, NULL, 'D', 0, 4, 0),
(3375, '2004 款', NULL, 802, 0, NULL, 'D', 0, 4, 0),
(3376, '2004 款', NULL, 803, 0, NULL, 'D', 0, 4, 0),
(3377, '2004 款', NULL, 804, 0, NULL, 'D', 0, 4, 0),
(3378, '2004 款', NULL, 805, 0, NULL, 'D', 0, 4, 0),
(3379, '2004 款', NULL, 806, 0, NULL, 'D', 0, 4, 0),
(3380, '1995 款', NULL, 807, 0, NULL, 'D', 0, 4, 0),
(3381, '1994 款', NULL, 808, 0, NULL, 'D', 0, 4, 0),
(3382, '2003 款', NULL, 809, 0, NULL, 'D', 0, 4, 0),
(3383, '1997 款', NULL, 809, 0, NULL, 'D', 0, 4, 0),
(3384, '2000 款', NULL, 810, 0, NULL, 'D', 0, 4, 0),
(3385, '1994 款', NULL, 810, 0, NULL, 'D', 0, 4, 0),
(3386, '1999 款', NULL, 811, 0, NULL, 'D', 0, 4, 0),
(3387, '1997 款', NULL, 811, 0, NULL, 'D', 0, 4, 0),
(3388, '1990 款', NULL, 812, 0, NULL, 'D', 0, 4, 0),
(3389, '1999 款', NULL, 813, 0, NULL, 'D', 0, 4, 0),
(3390, '2007 款', NULL, 814, 0, NULL, 'D', 0, 4, 0),
(3391, '2008 款', NULL, 815, 0, NULL, 'D', 0, 4, 0),
(3392, '2007 款', NULL, 815, 0, NULL, 'D', 0, 4, 0),
(3393, '2014 款', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3394, '2011 款', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3395, '2006 款', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3396, '2003 款', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3397, '2001 款', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3398, '其他', NULL, 816, 0, NULL, 'D', 0, 4, 0),
(3399, '2008 款', NULL, 817, 0, NULL, 'D', 0, 4, 0),
(3400, '2007 款', NULL, 817, 0, NULL, 'D', 0, 4, 0),
(3401, '2006 款', NULL, 817, 0, NULL, 'D', 0, 4, 0),
(3402, '2004 款', NULL, 817, 0, NULL, 'D', 0, 4, 0),
(3403, '1993 款', NULL, 817, 0, NULL, 'D', 0, 4, 0),
(3404, '2011 款', NULL, 818, 0, NULL, 'D', 0, 4, 0),
(3405, '2010 款', NULL, 818, 0, NULL, 'D', 0, 4, 0),
(3406, '2009 款', NULL, 818, 0, NULL, 'D', 0, 4, 0),
(3407, '2008 款', NULL, 818, 0, NULL, 'D', 0, 4, 0),
(3408, '2013 款', NULL, 819, 0, NULL, 'D', 0, 4, 0),
(3409, '2011 款', NULL, 819, 0, NULL, 'D', 0, 4, 0),
(3410, '2010 款', NULL, 819, 0, NULL, 'D', 0, 4, 0),
(3411, '2009 款', NULL, 819, 0, NULL, 'D', 0, 4, 0),
(3412, '2004 款', NULL, 820, 0, NULL, 'D', 0, 4, 0),
(3413, '2007 款', NULL, 821, 0, NULL, 'D', 0, 4, 0),
(3414, '2014 款', NULL, 822, 0, NULL, 'D', 0, 4, 0),
(3415, '2014 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3416, '2012 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3417, '2011 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3418, '2010 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3419, '2009 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3420, '2008 款', NULL, 823, 0, NULL, 'D', 0, 4, 0),
(3421, '2012 款', NULL, 824, 0, NULL, 'D', 0, 4, 0),
(3422, '2014 款', NULL, 825, 0, NULL, 'D', 0, 4, 0),
(3423, '2014 款', NULL, 826, 0, NULL, 'D', 0, 4, 0),
(3424, '2014 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3425, '2013 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3426, '2012 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3427, '2011 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3428, '2010 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3429, '2009 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3430, '2008 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3431, '2006 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3432, '2004 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3433, '2003 款', NULL, 827, 0, NULL, 'D', 0, 4, 0),
(3434, '2014 款', NULL, 828, 0, NULL, 'D', 0, 4, 0),
(3435, '2013 款', NULL, 828, 0, NULL, 'D', 0, 4, 0),
(3436, '2012 款', NULL, 828, 0, NULL, 'D', 0, 4, 0),
(3437, '2011 款', NULL, 828, 0, NULL, 'D', 0, 4, 0),
(3438, '2014 款', NULL, 829, 0, NULL, 'D', 0, 4, 0),
(3439, '2012 款', NULL, 829, 0, NULL, 'D', 0, 4, 0),
(3440, '2012 款', NULL, 830, 0, NULL, 'D', 0, 4, 0),
(3441, '2011 款', NULL, 830, 0, NULL, 'D', 0, 4, 0),
(3442, '2010 款', NULL, 830, 0, NULL, 'D', 0, 4, 0),
(3443, '2014 款', NULL, 831, 0, NULL, 'D', 0, 4, 0),
(3444, '2013 款', NULL, 831, 0, NULL, 'D', 0, 4, 0),
(3445, '2012 款', NULL, 831, 0, NULL, 'D', 0, 4, 0),
(3446, '2011 款', NULL, 831, 0, NULL, 'D', 0, 4, 0),
(3447, '2009 款', NULL, 831, 0, NULL, 'D', 0, 4, 0),
(3448, '2014 款', NULL, 832, 0, NULL, 'D', 0, 4, 0),
(3449, '2013 款', NULL, 832, 0, NULL, 'D', 0, 4, 0),
(3450, '2014 款', NULL, 833, 0, NULL, 'D', 0, 4, 0),
(3451, '2012 款', NULL, 834, 0, NULL, 'D', 0, 4, 0),
(3452, '2013 款', NULL, 835, 0, NULL, 'D', 0, 4, 0),
(3453, '2012 款', NULL, 835, 0, NULL, 'D', 0, 4, 0),
(3454, '2012 款', NULL, 836, 0, NULL, 'D', 0, 4, 0),
(3455, '2013 款', NULL, 837, 0, NULL, 'D', 0, 4, 0),
(3456, '2009 款', NULL, 837, 0, NULL, 'D', 0, 4, 0),
(3457, '2008 款', NULL, 837, 0, NULL, 'D', 0, 4, 0),
(3458, '2007 款', NULL, 837, 0, NULL, 'D', 0, 4, 0),
(3459, '2014 款', NULL, 838, 0, NULL, 'D', 0, 4, 0),
(3460, '2013 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3461, '2011 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3462, '2010 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3463, '2009 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3464, '2007 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3465, '2006 款', NULL, 839, 0, NULL, 'D', 0, 4, 0),
(3466, '2013 款', NULL, 840, 0, NULL, 'D', 0, 4, 0),
(3467, '2011 款', NULL, 840, 0, NULL, 'D', 0, 4, 0),
(3468, '2010 款', NULL, 840, 0, NULL, 'D', 0, 4, 0),
(3469, '2009 款', NULL, 840, 0, NULL, 'D', 0, 4, 0),
(3470, '2008 款', NULL, 840, 0, NULL, 'D', 0, 4, 0),
(3471, '2013 款', NULL, 841, 0, NULL, 'D', 0, 4, 0),
(3472, '2012 款', NULL, 841, 0, NULL, 'D', 0, 4, 0),
(3473, '2011 款', NULL, 841, 0, NULL, 'D', 0, 4, 0),
(3474, '2010 款', NULL, 841, 0, NULL, 'D', 0, 4, 0),
(3475, '2008 款', NULL, 841, 0, NULL, 'D', 0, 4, 0),
(3476, '2009 款', NULL, 842, 0, NULL, 'D', 0, 4, 0),
(3477, '2008 款', NULL, 842, 0, NULL, 'D', 0, 4, 0),
(3478, '2007 款', NULL, 842, 0, NULL, 'D', 0, 4, 0),
(3479, '2013 款', NULL, 843, 0, NULL, 'D', 0, 4, 0),
(3480, '2014 款', NULL, 844, 0, NULL, 'D', 0, 4, 0),
(3481, '2012 款', NULL, 845, 0, NULL, 'D', 0, 4, 0),
(3482, '2011 款', NULL, 846, 0, NULL, 'D', 0, 4, 0),
(3483, '2008 款', NULL, 846, 0, NULL, 'D', 0, 4, 0),
(3484, '2006 款', NULL, 846, 0, NULL, 'D', 0, 4, 0),
(3485, '2005 款', NULL, 846, 0, NULL, 'D', 0, 4, 0),
(3486, '2011 款', NULL, 847, 0, NULL, 'D', 0, 4, 0),
(3487, '2008 款', NULL, 847, 0, NULL, 'D', 0, 4, 0),
(3488, '2013 款', NULL, 848, 0, NULL, 'D', 0, 4, 0),
(3489, '2009 款', NULL, 848, 0, NULL, 'D', 0, 4, 0),
(3490, '2008 款', NULL, 848, 0, NULL, 'D', 0, 4, 0),
(3491, '2006 款', NULL, 848, 0, NULL, 'D', 0, 4, 0),
(3492, '2014 款', NULL, 849, 0, NULL, 'D', 0, 4, 0),
(3493, '2011 款', NULL, 849, 0, NULL, 'D', 0, 4, 0),
(3494, '2007 款', NULL, 849, 0, NULL, 'D', 0, 4, 0),
(3495, '2011 款', NULL, 850, 0, NULL, 'D', 0, 4, 0),
(3496, '2010 款', NULL, 850, 0, NULL, 'D', 0, 4, 0),
(3497, '2009 款', NULL, 850, 0, NULL, 'D', 0, 4, 0),
(3498, '2007 款', NULL, 850, 0, NULL, 'D', 0, 4, 0),
(3499, '2011 款', NULL, 851, 0, NULL, 'D', 0, 4, 0),
(3500, '2011 款', NULL, 852, 0, NULL, 'D', 0, 4, 0),
(3501, '2011 款', NULL, 853, 0, NULL, 'D', 0, 4, 0),
(3502, '2012 款', NULL, 854, 0, NULL, 'D', 0, 4, 0),
(3503, '2011 款', NULL, 855, 0, NULL, 'D', 0, 4, 0),
(3504, '2009 款', NULL, 855, 0, NULL, 'D', 0, 4, 0),
(3505, '2012 款', NULL, 856, 0, NULL, 'D', 0, 4, 0),
(3506, '2011 款', NULL, 856, 0, NULL, 'D', 0, 4, 0),
(3507, '2013 款', NULL, 857, 0, NULL, 'D', 0, 4, 0),
(3508, '2014 款', NULL, 858, 0, NULL, 'D', 0, 4, 0),
(3509, '2014 款', NULL, 859, 0, NULL, 'D', 0, 4, 0),
(3510, '2014 款', NULL, 860, 0, NULL, 'D', 0, 4, 0),
(3511, '2012 款', NULL, 860, 0, NULL, 'D', 0, 4, 0),
(3512, '2014 款', NULL, 861, 0, NULL, 'D', 0, 4, 0),
(3513, '2012 款', NULL, 861, 0, NULL, 'D', 0, 4, 0),
(3514, '2014 款', NULL, 862, 0, NULL, 'F', 0, 4, 0),
(3515, '2013 款', NULL, 863, 0, NULL, 'F', 0, 4, 0),
(3516, '2012 款', NULL, 863, 0, NULL, 'F', 0, 4, 0),
(3517, '2009 款', NULL, 863, 0, NULL, 'F', 0, 4, 0),
(3518, '2014 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3519, '2013 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3520, '2012 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3521, '2011 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3522, '2010 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3523, '2009 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3524, '2008 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3525, '2007 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3526, '2006 款', NULL, 864, 0, NULL, 'F', 0, 4, 0),
(3527, '2010 款', NULL, 865, 0, NULL, 'F', 0, 4, 0),
(3528, '2014 款', NULL, 866, 0, NULL, 'F', 0, 4, 0),
(3529, '2011 款', NULL, 867, 0, NULL, 'F', 0, 4, 0),
(3530, '2009 款', NULL, 867, 0, NULL, 'F', 0, 4, 0),
(3531, '2008 款', NULL, 867, 0, NULL, 'F', 0, 4, 0),
(3532, '2014 款', NULL, 868, 0, NULL, 'F', 0, 4, 0),
(3533, '2012 款', NULL, 868, 0, NULL, 'F', 0, 4, 0),
(3534, '2011 款', NULL, 868, 0, NULL, 'F', 0, 4, 0),
(3535, '2013 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3536, '2011 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3537, '2010 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3538, '2009 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3539, '2007 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3540, '2005 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3541, '2004 款', NULL, 869, 0, NULL, 'F', 0, 4, 0),
(3542, '2012 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3543, '2011 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3544, '2010 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3545, '2009 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3546, '2008 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3547, '2007 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3548, '2006 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3549, '2005 款', NULL, 870, 0, NULL, 'F', 0, 4, 0),
(3550, '2014 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3551, '2013 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3552, '2012 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3553, '2011 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3554, '2009 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3555, '2008 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3556, '2007 款', NULL, 871, 0, NULL, 'F', 0, 4, 0),
(3557, '2013 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3558, '2011 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3559, '2010 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3560, '2007 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3561, '2006 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3562, '2004 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3563, '2003 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3564, '2002 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3565, '2001 款', NULL, 872, 0, NULL, 'F', 0, 4, 0),
(3566, '2012 款', NULL, 873, 0, NULL, 'F', 0, 4, 0),
(3567, '2010 款', NULL, 873, 0, NULL, 'F', 0, 4, 0),
(3568, '2007 款', NULL, 873, 0, NULL, 'F', 0, 4, 0),
(3569, '2007 款', NULL, 874, 0, NULL, 'F', 0, 4, 0),
(3570, '2006 款', NULL, 874, 0, NULL, 'F', 0, 4, 0),
(3571, '2005 款', NULL, 874, 0, NULL, 'F', 0, 4, 0),
(3572, '2003 款', NULL, 874, 0, NULL, 'F', 0, 4, 0),
(3573, '2014 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3574, '2010 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3575, '2007 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3576, '2006 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3577, '2005 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3578, '2004 款', NULL, 875, 0, NULL, 'F', 0, 4, 0),
(3579, '2012 款', NULL, 876, 0, NULL, 'F', 0, 4, 0),
(3580, '2008 款', NULL, 876, 0, NULL, 'F', 0, 4, 0),
(3581, '2007 款', NULL, 876, 0, NULL, 'F', 0, 4, 0),
(3582, '2006 款', NULL, 876, 0, NULL, 'F', 0, 4, 0),
(3583, '2005 款', NULL, 876, 0, NULL, 'F', 0, 4, 0),
(3584, '2013 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3585, '2012 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3586, '2010 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3587, '2009 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3588, '2008 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3589, '2007 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3590, '2006 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3591, '2005 款', NULL, 877, 0, NULL, 'F', 0, 4, 0),
(3592, '2004 款', NULL, 878, 0, NULL, 'F', 0, 4, 0),
(3593, '2014 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3594, '2013 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3595, '2011 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3596, '2010 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3597, '2009 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3598, '2008 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3599, '2007 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3600, '2006 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3601, '2005 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3602, '2004 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3603, '2003 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3604, '2002 款', NULL, 879, 0, NULL, 'F', 0, 4, 0),
(3605, '2013 款', NULL, 880, 0, NULL, 'F', 0, 4, 0),
(3606, '2012 款', NULL, 880, 0, NULL, 'F', 0, 4, 0),
(3607, '2011 款', NULL, 880, 0, NULL, 'F', 0, 4, 0),
(3608, '2010 款', NULL, 880, 0, NULL, 'F', 0, 4, 0),
(3609, '2009 款', NULL, 880, 0, NULL, 'F', 0, 4, 0),
(3610, '2010 款', NULL, 881, 0, NULL, 'F', 0, 4, 0),
(3611, '2013 款', NULL, 882, 0, NULL, 'F', 0, 4, 0),
(3612, '2011 款', NULL, 882, 0, NULL, 'F', 0, 4, 0),
(3613, '2010 款', NULL, 882, 0, NULL, 'F', 0, 4, 0),
(3614, '2007 款', NULL, 882, 0, NULL, 'F', 0, 4, 0),
(3615, '2011 款', NULL, 883, 0, NULL, 'F', 0, 4, 0),
(3616, '2010 款', NULL, 883, 0, NULL, 'F', 0, 4, 0),
(3617, '2005 款', NULL, 883, 0, NULL, 'F', 0, 4, 0),
(3618, '2013 款', NULL, 884, 0, NULL, 'F', 0, 4, 0),
(3619, '2012 款', NULL, 884, 0, NULL, 'F', 0, 4, 0),
(3620, '2010 款', NULL, 884, 0, NULL, 'F', 0, 4, 0),
(3621, '2013 款', NULL, 885, 0, NULL, 'F', 0, 4, 0),
(3622, '2000 款', NULL, 886, 0, NULL, 'F', 0, 4, 0),
(3623, '2006 款', NULL, 887, 0, NULL, 'F', 0, 4, 0),
(3624, '2005 款', NULL, 887, 0, NULL, 'F', 0, 4, 0),
(3625, '2000 款', NULL, 887, 0, NULL, 'F', 0, 4, 0),
(3626, '2011 款', NULL, 888, 0, NULL, 'F', 0, 4, 0),
(3627, '2011 款', NULL, 889, 0, NULL, 'F', 0, 4, 0),
(3628, '2008 款', NULL, 889, 0, NULL, 'F', 0, 4, 0);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(3629, '2007 款', NULL, 889, 0, NULL, 'F', 0, 4, 0),
(3630, '2005 款', NULL, 889, 0, NULL, 'F', 0, 4, 0),
(3631, '2000 款', NULL, 889, 0, NULL, 'F', 0, 4, 0),
(3632, '2007 款', NULL, 890, 0, NULL, 'F', 0, 4, 0),
(3633, '1992 款', NULL, 891, 0, NULL, 'F', 0, 4, 0),
(3634, '1985 款', NULL, 891, 0, NULL, 'F', 0, 4, 0),
(3635, '2007 款', NULL, 892, 0, NULL, 'F', 0, 4, 0),
(3636, '2005 款', NULL, 892, 0, NULL, 'F', 0, 4, 0),
(3637, '2004 款', NULL, 892, 0, NULL, 'F', 0, 4, 0),
(3638, '1993 款', NULL, 892, 0, NULL, 'F', 0, 4, 0),
(3639, '2014 款', NULL, 893, 0, NULL, 'F', 0, 4, 0),
(3640, '2011 款', NULL, 893, 0, NULL, 'F', 0, 4, 0),
(3641, '2009 款', NULL, 893, 0, NULL, 'F', 0, 4, 0),
(3642, '2005 款', NULL, 894, 0, NULL, 'F', 0, 4, 0),
(3643, '2013 款', NULL, 895, 0, NULL, 'F', 0, 4, 0),
(3644, '1996 款', NULL, 895, 0, NULL, 'F', 0, 4, 0),
(3645, '2014 款', NULL, 896, 0, NULL, 'F', 0, 4, 0),
(3646, '2010 款', NULL, 897, 0, NULL, 'F', 0, 4, 0),
(3647, '其他', NULL, 897, 0, NULL, 'F', 0, 4, 0),
(3648, '2011 款', NULL, 898, 0, NULL, 'F', 0, 4, 0),
(3649, '2010 款', NULL, 898, 0, NULL, 'F', 0, 4, 0),
(3650, '2008 款', NULL, 898, 0, NULL, 'F', 0, 4, 0),
(3651, '2006 款', NULL, 898, 0, NULL, 'F', 0, 4, 0),
(3652, '1993 款', NULL, 899, 0, NULL, 'F', 0, 4, 0),
(3653, '2011 款', NULL, 900, 0, NULL, 'F', 0, 4, 0),
(3654, '2013 款', NULL, 901, 0, NULL, 'F', 0, 4, 0),
(3655, '2008 款', NULL, 901, 0, NULL, 'F', 0, 4, 0),
(3656, '2007 款', NULL, 901, 0, NULL, 'F', 0, 4, 0),
(3657, '2013 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3658, '2012 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3659, '2011 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3660, '2010 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3661, '2009 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3662, '2008 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3663, '2007 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3664, '2003 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3665, '2001 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3666, '2000 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3667, '1998 款', NULL, 902, 0, NULL, 'F', 0, 4, 0),
(3668, '2014 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3669, '2013 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3670, '2012 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3671, '2010 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3672, '2009 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3673, '2008 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3674, '2006 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3675, '2005 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3676, '2004 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3677, '2001 款', NULL, 903, 0, NULL, 'F', 0, 4, 0),
(3678, '2012 款', NULL, 904, 0, NULL, 'F', 0, 4, 0),
(3679, '2010 款', NULL, 904, 0, NULL, 'F', 0, 4, 0),
(3680, '2007 款', NULL, 904, 0, NULL, 'F', 0, 4, 0),
(3681, '2006 款', NULL, 904, 0, NULL, 'F', 0, 4, 0),
(3682, '2002 款', NULL, 904, 0, NULL, 'F', 0, 4, 0),
(3683, '2013 款', NULL, 905, 0, NULL, 'F', 0, 4, 0),
(3684, '2009 款', NULL, 905, 0, NULL, 'F', 0, 4, 0),
(3685, '2013 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3686, '2012 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3687, '2011 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3688, '2010 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3689, '2009 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3690, '2007 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3691, '2006 款', NULL, 906, 0, NULL, 'F', 0, 4, 0),
(3692, '2013 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3693, '2012 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3694, '2011 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3695, '2009 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3696, '2007 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3697, '2006 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3698, '2005 款', NULL, 907, 0, NULL, 'F', 0, 4, 0),
(3699, '2014 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3700, '2013 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3701, '2012 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3702, '2011 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3703, '2010 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3704, '2009 款', NULL, 908, 0, NULL, 'F', 0, 4, 0),
(3705, '2013 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3706, '2011 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3707, '2010 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3708, '2009 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3709, '2006 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3710, '2005 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3711, '2004 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3712, '2003 款', NULL, 909, 0, NULL, 'F', 0, 4, 0),
(3713, '2009 款', NULL, 910, 0, NULL, 'F', 0, 4, 0),
(3714, '2008 款', NULL, 910, 0, NULL, 'F', 0, 4, 0),
(3715, '2007 款', NULL, 910, 0, NULL, 'F', 0, 4, 0),
(3716, '2012 款', NULL, 911, 0, NULL, 'F', 0, 4, 0),
(3717, '2011 款', NULL, 911, 0, NULL, 'F', 0, 4, 0),
(3718, '2010 款', NULL, 911, 0, NULL, 'F', 0, 4, 0),
(3719, '2008 款', NULL, 911, 0, NULL, 'F', 0, 4, 0),
(3720, '2007 款', NULL, 911, 0, NULL, 'F', 0, 4, 0),
(3721, '2013 款', NULL, 912, 0, NULL, 'F', 0, 4, 0),
(3722, '2006 款', NULL, 912, 0, NULL, 'F', 0, 4, 0),
(3723, '2005 款', NULL, 912, 0, NULL, 'F', 0, 4, 0),
(3724, '2004 款', NULL, 912, 0, NULL, 'F', 0, 4, 0),
(3725, '2003 款', NULL, 912, 0, NULL, 'F', 0, 4, 0),
(3726, '2013 款', NULL, 913, 0, NULL, 'F', 0, 4, 0),
(3727, '2013 款', NULL, 914, 0, NULL, 'F', 0, 4, 0),
(3728, '2013 款', NULL, 915, 0, NULL, 'F', 0, 4, 0),
(3729, '2011 款', NULL, 915, 0, NULL, 'F', 0, 4, 0),
(3730, '2010 款', NULL, 915, 0, NULL, 'F', 0, 4, 0),
(3731, '2008 款', NULL, 915, 0, NULL, 'F', 0, 4, 0),
(3732, '2007 款', NULL, 915, 0, NULL, 'F', 0, 4, 0),
(3733, '2009 款', NULL, 916, 0, NULL, 'F', 0, 4, 0),
(3734, '2008 款', NULL, 916, 0, NULL, 'F', 0, 4, 0),
(3735, '2013 款', NULL, 917, 0, NULL, 'F', 0, 4, 0),
(3736, '2012 款', NULL, 917, 0, NULL, 'F', 0, 4, 0),
(3737, '2011 款', NULL, 917, 0, NULL, 'F', 0, 4, 0),
(3738, '2010 款', NULL, 917, 0, NULL, 'F', 0, 4, 0),
(3739, '2009 款', NULL, 917, 0, NULL, 'F', 0, 4, 0),
(3740, '2013 款', NULL, 918, 0, NULL, 'F', 0, 4, 0),
(3741, '2013 款', NULL, 919, 0, NULL, 'F', 0, 4, 0),
(3742, '2010 款', NULL, 919, 0, NULL, 'F', 0, 4, 0),
(3743, '2009 款', NULL, 919, 0, NULL, 'F', 0, 4, 0),
(3744, '2008 款', NULL, 919, 0, NULL, 'F', 0, 4, 0),
(3745, '2006 款', NULL, 919, 0, NULL, 'F', 0, 4, 0),
(3746, '2013 款', NULL, 920, 0, NULL, 'F', 0, 4, 0),
(3747, '2010 款', NULL, 920, 0, NULL, 'F', 0, 4, 0),
(3748, '2006 款', NULL, 920, 0, NULL, 'F', 0, 4, 0),
(3749, '2001 款', NULL, 920, 0, NULL, 'F', 0, 4, 0),
(3750, '1992 款', NULL, 921, 0, NULL, 'F', 0, 4, 0),
(3751, '2007 款', NULL, 922, 0, NULL, 'F', 0, 4, 0),
(3752, '1992 款', NULL, 922, 0, NULL, 'F', 0, 4, 0),
(3753, '2013 款', NULL, 923, 0, NULL, 'F', 0, 4, 0),
(3754, '1998 款', NULL, 924, 0, NULL, 'F', 0, 4, 0),
(3755, '2004 款', NULL, 925, 0, NULL, 'F', 0, 4, 0),
(3756, '2012 款', NULL, 926, 0, NULL, 'F', 0, 4, 0),
(3757, '2011 款', NULL, 926, 0, NULL, 'F', 0, 4, 0),
(3758, '2009 款', NULL, 926, 0, NULL, 'F', 0, 4, 0),
(3759, '1996 款', NULL, 927, 0, NULL, 'F', 0, 4, 0),
(3760, '1996 款', NULL, 928, 0, NULL, 'F', 0, 4, 0),
(3761, '2013 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3762, '2012 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3763, '2010 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3764, '2009 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3765, '2008 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3766, '2004 款', NULL, 929, 0, NULL, 'F', 0, 4, 0),
(3767, '2010 款', NULL, 930, 0, NULL, 'F', 0, 4, 0),
(3768, '2007 款', NULL, 930, 0, NULL, 'F', 0, 4, 0),
(3769, '2005 款', NULL, 930, 0, NULL, 'F', 0, 4, 0),
(3770, '2004 款', NULL, 930, 0, NULL, 'F', 0, 4, 0),
(3771, '2007 款', NULL, 931, 0, NULL, 'F', 0, 4, 0),
(3772, '2014 款', NULL, 932, 0, NULL, 'F', 0, 4, 0),
(3773, '2013 款', NULL, 932, 0, NULL, 'F', 0, 4, 0),
(3774, '2012 款', NULL, 932, 0, NULL, 'F', 0, 4, 0),
(3775, '2014 款', NULL, 933, 0, NULL, 'F', 0, 4, 0),
(3776, '2006 款', NULL, 934, 0, NULL, 'F', 0, 4, 0),
(3777, '2007 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3778, '2006 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3779, '2005 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3780, '2004 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3781, '2003 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3782, '2002 款', NULL, 935, 0, NULL, 'F', 0, 4, 0),
(3783, '2006 款', NULL, 936, 0, NULL, 'F', 0, 4, 0),
(3784, '2005 款', NULL, 936, 0, NULL, 'F', 0, 4, 0),
(3785, '2004 款', NULL, 936, 0, NULL, 'F', 0, 4, 0),
(3786, '2003 款', NULL, 936, 0, NULL, 'F', 0, 4, 0),
(3787, '2002 款', NULL, 936, 0, NULL, 'F', 0, 4, 0),
(3788, '2006 款', NULL, 937, 0, NULL, 'F', 0, 4, 0),
(3789, '2005 款', NULL, 937, 0, NULL, 'F', 0, 4, 0),
(3790, '2004 款', NULL, 937, 0, NULL, 'F', 0, 4, 0),
(3791, '2003 款', NULL, 937, 0, NULL, 'F', 0, 4, 0),
(3792, '2011 款', NULL, 938, 0, NULL, 'F', 0, 4, 0),
(3793, '2009 款', NULL, 938, 0, NULL, 'F', 0, 4, 0),
(3794, '2008 款', NULL, 938, 0, NULL, 'F', 0, 4, 0),
(3795, '2007 款', NULL, 939, 0, NULL, 'F', 0, 4, 0),
(3796, '1999 款', NULL, 940, 0, NULL, 'F', 0, 4, 0),
(3797, '2012 款', NULL, 941, 0, NULL, 'F', 0, 4, 0),
(3798, '2011 款', NULL, 941, 0, NULL, 'F', 0, 4, 0),
(3799, '2010 款', NULL, 942, 0, NULL, 'F', 0, 4, 0),
(3800, '2003 款', NULL, 942, 0, NULL, 'F', 0, 4, 0),
(3801, '2006 款', NULL, 943, 0, NULL, 'F', 0, 4, 0),
(3802, '2001 款', NULL, 943, 0, NULL, 'F', 0, 4, 0),
(3803, '1996 款', NULL, 944, 0, NULL, 'F', 0, 4, 0),
(3804, '2014 款', NULL, 945, 0, NULL, 'F', 0, 4, 0),
(3805, '2013 款', NULL, 945, 0, NULL, 'F', 0, 4, 0),
(3806, '2012 款', NULL, 945, 0, NULL, 'F', 0, 4, 0),
(3807, '1995 款', NULL, 946, 0, NULL, 'F', 0, 4, 0),
(3808, '2008 款', NULL, 947, 0, NULL, 'F', 0, 4, 0),
(3809, '2003 款', NULL, 948, 0, NULL, 'F', 0, 4, 0),
(3810, '2008 款', NULL, 949, 0, NULL, 'F', 0, 4, 0),
(3811, '2007 款', NULL, 950, 0, NULL, 'F', 0, 4, 0),
(3812, '其他', NULL, 951, 0, NULL, 'F', 0, 4, 0),
(3813, '2004 款', NULL, 952, 0, NULL, 'F', 0, 4, 0),
(3814, '2002 款', NULL, 952, 0, NULL, 'F', 0, 4, 0),
(3815, '其他', NULL, 953, 0, NULL, 'F', 0, 4, 0),
(3816, '2011 款', NULL, 954, 0, NULL, 'F', 0, 4, 0),
(3817, '2006 款', NULL, 954, 0, NULL, 'F', 0, 4, 0),
(3818, '2005 款', NULL, 954, 0, NULL, 'F', 0, 4, 0),
(3819, '2004 款', NULL, 954, 0, NULL, 'F', 0, 4, 0),
(3820, '2004 款', NULL, 955, 0, NULL, 'F', 0, 4, 0),
(3821, '2004 款', NULL, 956, 0, NULL, 'F', 0, 4, 0),
(3822, '2009 款', NULL, 957, 0, NULL, 'F', 0, 4, 0),
(3823, '其他', NULL, 957, 0, NULL, 'F', 0, 4, 0),
(3824, '2012 款', NULL, 958, 0, NULL, 'F', 0, 4, 0),
(3825, '2011 款', NULL, 958, 0, NULL, 'F', 0, 4, 0),
(3826, '2009 款', NULL, 958, 0, NULL, 'F', 0, 4, 0),
(3827, '2006 款', NULL, 958, 0, NULL, 'F', 0, 4, 0),
(3828, '2011 款', NULL, 959, 0, NULL, 'F', 0, 4, 0),
(3829, '2010 款', NULL, 959, 0, NULL, 'F', 0, 4, 0),
(3830, '2005 款', NULL, 959, 0, NULL, 'F', 0, 4, 0),
(3831, '2011 款', NULL, 960, 0, NULL, 'F', 0, 4, 0),
(3832, '2009 款', NULL, 960, 0, NULL, 'F', 0, 4, 0),
(3833, '2008 款', NULL, 960, 0, NULL, 'F', 0, 4, 0),
(3834, '2011 款', NULL, 961, 0, NULL, 'F', 0, 4, 0),
(3835, '2009 款', NULL, 961, 0, NULL, 'F', 0, 4, 0),
(3836, '2004 款', NULL, 961, 0, NULL, 'F', 0, 4, 0),
(3837, '2013 款', NULL, 962, 0, NULL, 'F', 0, 4, 0),
(3838, '2011 款', NULL, 962, 0, NULL, 'F', 0, 4, 0),
(3839, '2006 款', NULL, 963, 0, NULL, 'F', 0, 4, 0),
(3840, '2004 款', NULL, 963, 0, NULL, 'F', 0, 4, 0),
(3841, '2003 款', NULL, 963, 0, NULL, 'F', 0, 4, 0),
(3842, '2002 款', NULL, 963, 0, NULL, 'F', 0, 4, 0),
(3843, '2011 款', NULL, 964, 0, NULL, 'F', 0, 4, 0),
(3844, '2008 款', NULL, 965, 0, NULL, 'F', 0, 4, 0),
(3845, '2003 款', NULL, 965, 0, NULL, 'F', 0, 4, 0),
(3846, '2000 款', NULL, 965, 0, NULL, 'F', 0, 4, 0),
(3847, '2002 款', NULL, 966, 0, NULL, 'F', 0, 4, 0),
(3848, '2005 款', NULL, 967, 0, NULL, 'F', 0, 4, 0),
(3849, '2013 款', NULL, 968, 0, NULL, 'F', 0, 4, 0),
(3850, '1998 款', NULL, 969, 0, NULL, 'F', 0, 4, 0),
(3851, '2014 款', NULL, 970, 0, NULL, 'F', 0, 4, 0),
(3852, '2013 款', NULL, 970, 0, NULL, 'F', 0, 4, 0),
(3853, '2012 款', NULL, 970, 0, NULL, 'F', 0, 4, 0),
(3854, '2011 款', NULL, 970, 0, NULL, 'F', 0, 4, 0),
(3855, '2010 款', NULL, 970, 0, NULL, 'F', 0, 4, 0),
(3856, '2010 款', NULL, 971, 0, NULL, 'F', 0, 4, 0),
(3857, '2007 款', NULL, 971, 0, NULL, 'F', 0, 4, 0),
(3858, '2014 款', NULL, 972, 0, NULL, 'F', 0, 4, 0),
(3859, '2012 款', NULL, 972, 0, NULL, 'F', 0, 4, 0),
(3860, '2008 款', NULL, 972, 0, NULL, 'F', 0, 4, 0),
(3861, '2009 款', NULL, 973, 0, NULL, 'F', 0, 4, 0),
(3862, '2008 款', NULL, 973, 0, NULL, 'F', 0, 4, 0),
(3863, '2005 款', NULL, 973, 0, NULL, 'F', 0, 4, 0),
(3864, '2011 款', NULL, 974, 0, NULL, 'F', 0, 4, 0),
(3865, '2012 款', NULL, 975, 0, NULL, 'F', 0, 4, 0),
(3866, '2001 款', NULL, 975, 0, NULL, 'F', 0, 4, 0),
(3867, '其他', NULL, 975, 0, NULL, 'F', 0, 4, 0),
(3868, '2012 款', NULL, 976, 0, NULL, 'F', 0, 4, 0),
(3869, '2012 款', NULL, 977, 0, NULL, 'F', 0, 4, 0),
(3870, '2006 款', NULL, 978, 0, NULL, 'F', 0, 4, 0),
(3871, '2005 款', NULL, 978, 0, NULL, 'F', 0, 4, 0),
(3872, '2000 款', NULL, 978, 0, NULL, 'F', 0, 4, 0),
(3873, '2004 款', NULL, 979, 0, NULL, 'F', 0, 4, 0),
(3874, '2012 款', NULL, 980, 0, NULL, 'F', 0, 4, 0),
(3875, '2011 款', NULL, 980, 0, NULL, 'F', 0, 4, 0),
(3876, '2006 款', NULL, 981, 0, NULL, 'F', 0, 4, 0),
(3877, '2013 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3878, '2012 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3879, '2011 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3880, '2010 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3881, '2009 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3882, '2007 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3883, '2006 款', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3884, '其他', NULL, 982, 0, NULL, 'F', 0, 4, 0),
(3885, '其他', NULL, 983, 0, NULL, 'F', 0, 4, 0),
(3886, '2013 款', NULL, 984, 0, NULL, 'F', 0, 4, 0),
(3887, '2012 款', NULL, 984, 0, NULL, 'F', 0, 4, 0),
(3888, '2011 款', NULL, 984, 0, NULL, 'F', 0, 4, 0),
(3889, '2009 款', NULL, 984, 0, NULL, 'F', 0, 4, 0),
(3890, '2007 款', NULL, 984, 0, NULL, 'F', 0, 4, 0),
(3891, '2013 款', NULL, 985, 0, NULL, 'F', 0, 4, 0),
(3892, '2014 款', NULL, 986, 0, NULL, 'F', 0, 4, 0),
(3893, '2011 款', NULL, 986, 0, NULL, 'F', 0, 4, 0),
(3894, '2009 款', NULL, 986, 0, NULL, 'F', 0, 4, 0),
(3895, '2011 款', NULL, 987, 0, NULL, 'F', 0, 4, 0),
(3896, '2012 款', NULL, 988, 0, NULL, 'F', 0, 4, 0),
(3897, '2014 款', NULL, 989, 0, NULL, 'F', 0, 4, 0),
(3898, '其他', NULL, 990, 0, NULL, 'F', 0, 4, 0),
(3899, '2014 款', NULL, 991, 0, NULL, 'F', 0, 4, 0),
(3900, '2011 款', NULL, 991, 0, NULL, 'F', 0, 4, 0),
(3901, '2005 款', NULL, 991, 0, NULL, 'F', 0, 4, 0),
(3902, '2014 款', NULL, 992, 0, NULL, 'F', 0, 4, 0),
(3903, '2014 款', NULL, 993, 0, NULL, 'F', 0, 4, 0),
(3904, '2014 款', NULL, 994, 0, NULL, 'F', 0, 4, 0),
(3905, '2014 款', NULL, 995, 0, NULL, 'F', 0, 4, 0),
(3906, '2014 款', NULL, 996, 0, NULL, 'F', 0, 4, 0),
(3907, '2013 款', NULL, 997, 0, NULL, 'F', 0, 4, 0),
(3908, '2012 款', NULL, 997, 0, NULL, 'F', 0, 4, 0),
(3909, '2014 款', NULL, 998, 0, NULL, 'F', 0, 4, 0),
(3910, '2014 款', NULL, 999, 0, NULL, 'F', 0, 4, 0),
(3911, '2011 款', NULL, 1000, 0, NULL, 'F', 0, 4, 0),
(3912, '2011 款', NULL, 1001, 0, NULL, 'F', 0, 4, 0),
(3913, '2011 款', NULL, 1002, 0, NULL, 'F', 0, 4, 0),
(3914, '2002 款', NULL, 1003, 0, NULL, 'F', 0, 4, 0),
(3915, '2013 款', NULL, 1004, 0, NULL, 'F', 0, 4, 0),
(3916, '2013 款', NULL, 1005, 0, NULL, 'F', 0, 4, 0),
(3917, '2009 款', NULL, 1005, 0, NULL, 'F', 0, 4, 0),
(3918, '2007 款', NULL, 1005, 0, NULL, 'F', 0, 4, 0),
(3919, '2006 款', NULL, 1005, 0, NULL, 'F', 0, 4, 0),
(3920, '2013 款', NULL, 1006, 0, NULL, 'F', 0, 4, 0),
(3921, '2014 款', NULL, 1007, 0, NULL, 'F', 0, 4, 0),
(3922, '2011 款', NULL, 1008, 0, NULL, 'G', 0, 4, 0),
(3923, '2012 款', NULL, 1009, 0, NULL, 'G', 0, 4, 0),
(3924, '2011 款', NULL, 1009, 0, NULL, 'G', 0, 4, 0),
(3925, '2012 款', NULL, 1010, 0, NULL, 'G', 0, 4, 0),
(3926, '2010 款', NULL, 1011, 0, NULL, 'G', 0, 4, 0),
(3927, '2009 款', NULL, 1011, 0, NULL, 'G', 0, 4, 0),
(3928, '2002 款', NULL, 1011, 0, NULL, 'G', 0, 4, 0),
(3929, '2011 款', NULL, 1012, 0, NULL, 'G', 0, 4, 0),
(3930, '2010 款', NULL, 1012, 0, NULL, 'G', 0, 4, 0),
(3931, '2009 款', NULL, 1012, 0, NULL, 'G', 0, 4, 0),
(3932, '2011 款', NULL, 1013, 0, NULL, 'G', 0, 4, 0),
(3933, '2010 款', NULL, 1014, 0, NULL, 'G', 0, 4, 0),
(3934, '2009 款', NULL, 1014, 0, NULL, 'G', 0, 4, 0),
(3935, '2014 款', NULL, 1015, 0, NULL, 'G', 0, 4, 0),
(3936, '2011 款', NULL, 1016, 0, NULL, 'G', 0, 4, 0),
(3937, '2009 款', NULL, 1016, 0, NULL, 'G', 0, 4, 0),
(3938, '2006 款', NULL, 1016, 0, NULL, 'G', 0, 4, 0),
(3939, '2006 款', NULL, 1017, 0, NULL, 'G', 0, 4, 0),
(3940, '2009 款', NULL, 1018, 0, NULL, 'G', 0, 4, 0),
(3941, '2004 款', NULL, 1019, 0, NULL, 'G', 0, 4, 0),
(3942, '2010 款', NULL, 1020, 0, NULL, 'G', 0, 4, 0),
(3943, '2004 款', NULL, 1021, 0, NULL, 'G', 0, 4, 0),
(3944, '2002 款', NULL, 1021, 0, NULL, 'G', 0, 4, 0),
(3945, '2011 款', NULL, 1022, 0, NULL, 'G', 0, 4, 0),
(3946, '2010 款', NULL, 1022, 0, NULL, 'G', 0, 4, 0),
(3947, '2009 款', NULL, 1022, 0, NULL, 'G', 0, 4, 0),
(3948, '2004 款', NULL, 1023, 0, NULL, 'G', 0, 4, 0),
(3949, '2006 款', NULL, 1024, 0, NULL, 'G', 0, 4, 0),
(3950, '2014 款', NULL, 1025, 0, NULL, 'G', 0, 4, 0),
(3951, '2013 款', NULL, 1025, 0, NULL, 'G', 0, 4, 0),
(3952, '2012 款', NULL, 1026, 0, NULL, 'G', 0, 4, 0),
(3953, '2010 款', NULL, 1026, 0, NULL, 'G', 0, 4, 0),
(3954, '2009 款', NULL, 1026, 0, NULL, 'G', 0, 4, 0),
(3955, '2012 款', NULL, 1027, 0, NULL, 'G', 0, 4, 0),
(3956, '2013 款', NULL, 1028, 0, NULL, 'G', 0, 4, 0),
(3957, '2013 款', NULL, 1029, 0, NULL, 'G', 0, 4, 0),
(3958, '2013 款', NULL, 1030, 0, NULL, 'G', 0, 4, 0),
(3959, '2002 款', NULL, 1031, 0, NULL, 'G', 0, 4, 0),
(3960, '2014 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3961, '2013 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3962, '2012 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3963, '2011 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3964, '2010 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3965, '2008 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3966, '2007 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3967, '2006 款', NULL, 1032, 0, NULL, 'G', 0, 4, 0),
(3968, '2012 款', NULL, 1033, 0, NULL, 'G', 0, 4, 0),
(3969, '2010 款', NULL, 1033, 0, NULL, 'G', 0, 4, 0),
(3970, '2012 款', NULL, 1034, 0, NULL, 'G', 0, 4, 0),
(3971, '2005 款', NULL, 1034, 0, NULL, 'G', 0, 4, 0),
(3972, '2012 款', NULL, 1035, 0, NULL, 'G', 0, 4, 0),
(3973, '2009 款', NULL, 1036, 0, NULL, 'G', 0, 4, 0),
(3974, '2009 款', NULL, 1037, 0, NULL, 'G', 0, 4, 0),
(3975, '2009 款', NULL, 1038, 0, NULL, 'G', 0, 4, 0),
(3976, '2014 款', NULL, 1039, 0, NULL, 'G', 0, 4, 0),
(3977, '2013 款', NULL, 1039, 0, NULL, 'G', 0, 4, 0),
(3978, '2013 款', NULL, 1040, 0, NULL, 'G', 0, 4, 0),
(3979, '2012 款', NULL, 1040, 0, NULL, 'G', 0, 4, 0),
(3980, '2011 款', NULL, 1040, 0, NULL, 'G', 0, 4, 0),
(3981, '2014 款', NULL, 1041, 0, NULL, 'G', 0, 4, 0),
(3982, '2013 款', NULL, 1041, 0, NULL, 'G', 0, 4, 0),
(3983, '2012 款', NULL, 1041, 0, NULL, 'G', 0, 4, 0),
(3984, '2014 款', NULL, 1042, 0, NULL, 'G', 0, 4, 0),
(3985, '2014 款', NULL, 1043, 0, NULL, 'G', 0, 4, 0),
(3986, '2001 款', NULL, 1044, 0, NULL, 'H', 0, 4, 0),
(3987, '2010 款', NULL, 1045, 0, NULL, 'H', 0, 4, 0),
(3988, '其他', NULL, 1045, 0, NULL, 'H', 0, 4, 0),
(3989, '2012 款', NULL, 1046, 0, NULL, 'H', 0, 4, 0),
(3990, '2010 款', NULL, 1046, 0, NULL, 'H', 0, 4, 0),
(3991, '2012 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3992, '2010 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3993, '2009 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3994, '2008 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3995, '2007 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3996, '2006 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3997, '2005 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3998, '2003 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(3999, '2002 款', NULL, 1047, 0, NULL, 'H', 0, 4, 0),
(4000, '2011 款', NULL, 1048, 0, NULL, 'H', 0, 4, 0),
(4001, '2010 款', NULL, 1048, 0, NULL, 'H', 0, 4, 0),
(4002, '2008 款', NULL, 1048, 0, NULL, 'H', 0, 4, 0),
(4003, '其他', NULL, 1048, 0, NULL, 'H', 0, 4, 0),
(4004, '2010 款', NULL, 1049, 0, NULL, 'H', 0, 4, 0),
(4005, '2006 款', NULL, 1050, 0, NULL, 'H', 0, 4, 0),
(4006, '2005 款', NULL, 1050, 0, NULL, 'H', 0, 4, 0),
(4007, '2003 款', NULL, 1050, 0, NULL, 'H', 0, 4, 0),
(4008, '其他', NULL, 1050, 0, NULL, 'H', 0, 4, 0),
(4009, '其他', NULL, 1051, 0, NULL, 'H', 0, 4, 0),
(4010, '2010 款', NULL, 1052, 0, NULL, 'H', 0, 4, 0),
(4011, '2010 款', NULL, 1053, 0, NULL, 'H', 0, 4, 0),
(4012, '2007 款', NULL, 1054, 0, NULL, 'H', 0, 4, 0),
(4013, '2006 款', NULL, 1054, 0, NULL, 'H', 0, 4, 0),
(4014, '2001 款', NULL, 1054, 0, NULL, 'H', 0, 4, 0),
(4015, '1993 款', NULL, 1054, 0, NULL, 'H', 0, 4, 0),
(4016, '其他', NULL, 1055, 0, NULL, 'H', 0, 4, 0),
(4017, '2008 款', NULL, 1056, 0, NULL, 'H', 0, 4, 0),
(4018, '2006 款', NULL, 1056, 0, NULL, 'H', 0, 4, 0),
(4019, '2005 款', NULL, 1056, 0, NULL, 'H', 0, 4, 0),
(4020, '2007 款', NULL, 1057, 0, NULL, 'H', 0, 4, 0),
(4021, '2006 款', NULL, 1057, 0, NULL, 'H', 0, 4, 0),
(4022, '2009 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4023, '2007 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4024, '2006 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4025, '2005 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4026, '2004 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4027, '2002 款', NULL, 1058, 0, NULL, 'H', 0, 4, 0),
(4028, '2006 款', NULL, 1059, 0, NULL, 'H', 0, 4, 0),
(4029, '1998 款', NULL, 1059, 0, NULL, 'H', 0, 4, 0),
(4030, '2012 款', NULL, 1060, 0, NULL, 'H', 0, 4, 0),
(4031, '2011 款', NULL, 1060, 0, NULL, 'H', 0, 4, 0),
(4032, '2013 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4033, '2010 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4034, '2006 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4035, '2005 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4036, '2004 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4037, '2000 款', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4038, '其他', NULL, 1061, 0, NULL, 'H', 0, 4, 0),
(4039, '2010 款', NULL, 1062, 0, NULL, 'H', 0, 4, 0),
(4040, '2014 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4041, '2013 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4042, '2012 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4043, '2011 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4044, '2010 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4045, '2009 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4046, '2006 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4047, '2005 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4048, '2004 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4049, '2003 款', NULL, 1063, 0, NULL, 'H', 0, 4, 0),
(4050, '2014 款', NULL, 1064, 0, NULL, 'H', 0, 4, 0),
(4051, '2013 款', NULL, 1065, 0, NULL, 'H', 0, 4, 0),
(4052, '2012 款', NULL, 1065, 0, NULL, 'H', 0, 4, 0),
(4053, '2012 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4054, '2011 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4055, '2010 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4056, '2009 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4057, '2008 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4058, '2007 款', NULL, 1066, 0, NULL, 'H', 0, 4, 0),
(4059, '2010 款', NULL, 1067, 0, NULL, 'H', 0, 4, 0),
(4060, '2008 款', NULL, 1067, 0, NULL, 'H', 0, 4, 0),
(4061, '2007 款', NULL, 1067, 0, NULL, 'H', 0, 4, 0),
(4062, '2014 款', NULL, 1068, 0, NULL, 'H', 0, 4, 0),
(4063, '2013 款', NULL, 1068, 0, NULL, 'H', 0, 4, 0),
(4064, '2014 款', NULL, 1069, 0, NULL, 'H', 0, 4, 0),
(4065, '2014 款', NULL, 1070, 0, NULL, 'H', 0, 4, 0),
(4066, '2013 款', NULL, 1071, 0, NULL, 'H', 0, 4, 0),
(4067, '2000 款', NULL, 1072, 0, NULL, 'H', 0, 4, 0),
(4068, '2002 款', NULL, 1073, 0, NULL, 'H', 0, 4, 0),
(4069, '2000 款', NULL, 1073, 0, NULL, 'H', 0, 4, 0),
(4070, '2010 款', NULL, 1074, 0, NULL, 'H', 0, 4, 0),
(4071, '2009 款', NULL, 1074, 0, NULL, 'H', 0, 4, 0),
(4072, '2014 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4073, '2013 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4074, '2012 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4075, '2010 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4076, '2007 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4077, '2006 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4078, '2005 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4079, '2004 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4080, '2003 款', NULL, 1075, 0, NULL, 'H', 0, 4, 0),
(4081, '2013 款', NULL, 1076, 0, NULL, 'H', 0, 4, 0),
(4082, '2012 款', NULL, 1076, 0, NULL, 'H', 0, 4, 0),
(4083, '2011 款', NULL, 1076, 0, NULL, 'H', 0, 4, 0),
(4084, '2010 款', NULL, 1076, 0, NULL, 'H', 0, 4, 0),
(4085, '2013 款', NULL, 1077, 0, NULL, 'H', 0, 4, 0),
(4086, '2012 款', NULL, 1077, 0, NULL, 'H', 0, 4, 0),
(4087, '2011 款', NULL, 1077, 0, NULL, 'H', 0, 4, 0),
(4088, '2010 款', NULL, 1077, 0, NULL, 'H', 0, 4, 0),
(4089, '2004 款', NULL, 1078, 0, NULL, 'H', 0, 4, 0),
(4090, '2003 款', NULL, 1078, 0, NULL, 'H', 0, 4, 0),
(4091, '2005 款', NULL, 1079, 0, NULL, 'H', 0, 4, 0),
(4092, '2004 款', NULL, 1079, 0, NULL, 'H', 0, 4, 0),
(4093, '2003 款', NULL, 1079, 0, NULL, 'H', 0, 4, 0),
(4094, '2009 款', NULL, 1080, 0, NULL, 'H', 0, 4, 0),
(4095, '2008 款', NULL, 1080, 0, NULL, 'H', 0, 4, 0),
(4096, '2007 款', NULL, 1080, 0, NULL, 'H', 0, 4, 0),
(4097, '2009 款', NULL, 1081, 0, NULL, 'H', 0, 4, 0),
(4098, '2009 款', NULL, 1082, 0, NULL, 'H', 0, 4, 0),
(4099, '2008 款', NULL, 1082, 0, NULL, 'H', 0, 4, 0),
(4100, '2007 款', NULL, 1082, 0, NULL, 'H', 0, 4, 0),
(4101, '2006 款', NULL, 1082, 0, NULL, 'H', 0, 4, 0),
(4102, '2005 款', NULL, 1082, 0, NULL, 'H', 0, 4, 0),
(4103, '2006 款', NULL, 1083, 0, NULL, 'H', 0, 4, 0),
(4104, '2009 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4105, '2008 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4106, '2007 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4107, '2006 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4108, '2005 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4109, '2004 款', NULL, 1084, 0, NULL, 'H', 0, 4, 0),
(4110, '2009 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4111, '2008 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4112, '2007 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4113, '2006 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4114, '2005 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4115, '2004 款', NULL, 1085, 0, NULL, 'H', 0, 4, 0),
(4116, '2009 款', NULL, 1086, 0, NULL, 'H', 0, 4, 0),
(4117, '2008 款', NULL, 1086, 0, NULL, 'H', 0, 4, 0),
(4118, '2002 款', NULL, 1087, 0, NULL, 'H', 0, 4, 0),
(4119, '1999 款', NULL, 1087, 0, NULL, 'H', 0, 4, 0),
(4120, '2005 款', NULL, 1088, 0, NULL, 'H', 0, 4, 0),
(4121, '2003 款', NULL, 1088, 0, NULL, 'H', 0, 4, 0),
(4122, '2007 款', NULL, 1089, 0, NULL, 'H', 0, 4, 0),
(4123, '2004 款', NULL, 1089, 0, NULL, 'H', 0, 4, 0),
(4124, '2012 款', NULL, 1090, 0, NULL, 'H', 0, 4, 0),
(4125, '2009 款', NULL, 1090, 0, NULL, 'H', 0, 4, 0),
(4126, '2006 款', NULL, 1090, 0, NULL, 'H', 0, 4, 0),
(4127, '2005 款', NULL, 1090, 0, NULL, 'H', 0, 4, 0),
(4128, '2006 款', NULL, 1091, 0, NULL, 'H', 0, 4, 0),
(4129, '2009 款', NULL, 1092, 0, NULL, 'H', 0, 4, 0),
(4130, '2006 款', NULL, 1092, 0, NULL, 'H', 0, 4, 0),
(4131, '2007 款', NULL, 1093, 0, NULL, 'H', 0, 4, 0),
(4132, '2006 款', NULL, 1093, 0, NULL, 'H', 0, 4, 0),
(4133, '2001 款', NULL, 1093, 0, NULL, 'H', 0, 4, 0),
(4134, '2009 款', NULL, 1094, 0, NULL, 'H', 0, 4, 0),
(4135, '2006 款', NULL, 1095, 0, NULL, 'H', 0, 4, 0),
(4136, '2005 款', NULL, 1095, 0, NULL, 'H', 0, 4, 0),
(4137, '2004 款', NULL, 1095, 0, NULL, 'H', 0, 4, 0),
(4138, '2003 款', NULL, 1095, 0, NULL, 'H', 0, 4, 0),
(4139, '2007 款', NULL, 1096, 0, NULL, 'H', 0, 4, 0),
(4140, '2006 款', NULL, 1096, 0, NULL, 'H', 0, 4, 0),
(4141, '2005 款', NULL, 1096, 0, NULL, 'H', 0, 4, 0),
(4142, '2013 款', NULL, 1097, 0, NULL, 'H', 0, 4, 0),
(4143, '2012 款', NULL, 1097, 0, NULL, 'H', 0, 4, 0),
(4144, '2009 款', NULL, 1097, 0, NULL, 'H', 0, 4, 0),
(4145, '2006 款', NULL, 1097, 0, NULL, 'H', 0, 4, 0),
(4146, '2004 款', NULL, 1098, 0, NULL, 'H', 0, 4, 0),
(4147, '2010 款', NULL, 1099, 0, NULL, 'H', 0, 4, 0),
(4148, '2009 款', NULL, 1099, 0, NULL, 'H', 0, 4, 0),
(4149, '2008 款', NULL, 1099, 0, NULL, 'H', 0, 4, 0),
(4150, '2007 款', NULL, 1099, 0, NULL, 'H', 0, 4, 0),
(4151, '2011 款', NULL, 1100, 0, NULL, 'H', 0, 4, 0),
(4152, '2013 款', NULL, 1101, 0, NULL, 'H', 0, 4, 0),
(4153, '2011 款', NULL, 1101, 0, NULL, 'H', 0, 4, 0),
(4154, '2003 款', NULL, 1102, 0, NULL, 'H', 0, 4, 0),
(4155, '2011 款', NULL, 1103, 0, NULL, 'H', 0, 4, 0),
(4156, '2009 款', NULL, 1103, 0, NULL, 'H', 0, 4, 0),
(4157, '2006 款', NULL, 1103, 0, NULL, 'H', 0, 4, 0),
(4158, '2009 款', NULL, 1104, 0, NULL, 'H', 0, 4, 0),
(4159, '2006 款', NULL, 1104, 0, NULL, 'H', 0, 4, 0),
(4160, '2003 款', NULL, 1105, 0, NULL, 'H', 0, 4, 0),
(4161, '2008 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4162, '2007 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4163, '2006 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4164, '2002 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4165, '2001 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4166, '2000 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4167, '1999 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4168, '1998 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4169, '1997 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4170, '1996 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4171, '1995 款', NULL, 1106, 0, NULL, 'H', 0, 4, 0),
(4172, '2013 款', NULL, 1107, 0, NULL, 'H', 0, 4, 0),
(4173, '2014 款', NULL, 1108, 0, NULL, 'H', 0, 4, 0),
(4174, '2002 款', NULL, 1109, 0, NULL, 'H', 0, 4, 0),
(4175, '2001 款', NULL, 1109, 0, NULL, 'H', 0, 4, 0),
(4176, '1999 款', NULL, 1109, 0, NULL, 'H', 0, 4, 0),
(4177, '2009 款', NULL, 1110, 0, NULL, 'H', 0, 4, 0),
(4178, '2006 款', NULL, 1110, 0, NULL, 'H', 0, 4, 0),
(4179, '2007 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4180, '2006 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4181, '2005 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4182, '2004 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4183, '2003 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4184, '2002 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4185, '2001 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4186, '2000 款', NULL, 1111, 0, NULL, 'H', 0, 4, 0),
(4187, '2007 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4188, '2006 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4189, '2005 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4190, '2004 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4191, '2003 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4192, '2000 款', NULL, 1112, 0, NULL, 'H', 0, 4, 0),
(4193, '其他', NULL, 1113, 0, NULL, 'H', 0, 4, 0),
(4194, '2008 款', NULL, 1114, 0, NULL, 'H', 0, 4, 0),
(4195, '2002 款', NULL, 1114, 0, NULL, 'H', 0, 4, 0),
(4196, '2008 款', NULL, 1115, 0, NULL, 'H', 0, 4, 0),
(4197, '2006 款', NULL, 1115, 0, NULL, 'H', 0, 4, 0),
(4198, '2008 款', NULL, 1116, 0, NULL, 'H', 0, 4, 0),
(4199, '2005 款', NULL, 1116, 0, NULL, 'H', 0, 4, 0),
(4200, '2008 款', NULL, 1117, 0, NULL, 'H', 0, 4, 0),
(4201, '2008 款', NULL, 1118, 0, NULL, 'H', 0, 4, 0),
(4202, '2010 款', NULL, 1119, 0, NULL, 'H', 0, 4, 0),
(4203, '2007 款', NULL, 1119, 0, NULL, 'H', 0, 4, 0),
(4204, '2008 款', NULL, 1120, 0, NULL, 'H', 0, 4, 0),
(4205, '2014 款', NULL, 1121, 0, NULL, 'H', 0, 4, 0),
(4206, '2013 款', NULL, 1121, 0, NULL, 'H', 0, 4, 0),
(4207, '2012 款', NULL, 1121, 0, NULL, 'H', 0, 4, 0),
(4208, '2011 款', NULL, 1121, 0, NULL, 'H', 0, 4, 0),
(4209, '2011 款', NULL, 1122, 0, NULL, 'H', 0, 4, 0),
(4210, '2002 款', NULL, 1123, 0, NULL, 'H', 0, 4, 0),
(4211, '1999 款', NULL, 1123, 0, NULL, 'H', 0, 4, 0),
(4212, '2014 款', NULL, 1124, 0, NULL, 'H', 0, 4, 0),
(4213, '2013 款', NULL, 1124, 0, NULL, 'H', 0, 4, 0),
(4214, '2013 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4215, '2012 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4216, '2011 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4217, '2010 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4218, '2009 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4219, '2008 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4220, '2007 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4221, '2006 款', NULL, 1125, 0, NULL, 'H', 0, 4, 0),
(4222, '2012 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4223, '2010 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4224, '2009 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4225, '2008 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4226, '2005 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4227, '2004 款', NULL, 1126, 0, NULL, 'H', 0, 4, 0),
(4228, '2002 款', NULL, 1127, 0, NULL, 'H', 0, 4, 0),
(4229, '1999 款', NULL, 1128, 0, NULL, 'H', 0, 4, 0),
(4230, '2002 款', NULL, 1129, 0, NULL, 'H', 0, 4, 0),
(4231, '2000 款', NULL, 1130, 0, NULL, 'H', 0, 4, 0),
(4232, '2000 款', NULL, 1131, 0, NULL, 'H', 0, 4, 0),
(4233, '2012 款', NULL, 1132, 0, NULL, 'H', 0, 4, 0),
(4234, '2009 款', NULL, 1133, 0, NULL, 'H', 0, 4, 0),
(4235, '2014 款', NULL, 1134, 0, NULL, 'H', 0, 4, 0),
(4236, '2012 款', NULL, 1134, 0, NULL, 'H', 0, 4, 0),
(4237, '2012 款', NULL, 1135, 0, NULL, 'H', 0, 4, 0),
(4238, '2012 款', NULL, 1136, 0, NULL, 'H', 0, 4, 0),
(4239, '2012 款', NULL, 1137, 0, NULL, 'H', 0, 4, 0),
(4240, '2011 款', NULL, 1138, 0, NULL, 'H', 0, 4, 0),
(4241, '2010 款', NULL, 1138, 0, NULL, 'H', 0, 4, 0),
(4242, '2010 款', NULL, 1139, 0, NULL, 'H', 0, 4, 0),
(4243, '2013 款', NULL, 1140, 0, NULL, 'H', 0, 4, 0),
(4244, '2013 款', NULL, 1141, 0, NULL, 'H', 0, 4, 0),
(4245, '2013 款', NULL, 1142, 0, NULL, 'H', 0, 4, 0),
(4246, '2012 款', NULL, 1142, 0, NULL, 'H', 0, 4, 0),
(4247, '2011 款', NULL, 1142, 0, NULL, 'H', 0, 4, 0),
(4248, '2012 款', NULL, 1143, 0, NULL, 'H', 0, 4, 0),
(4249, '2012 款', NULL, 1144, 0, NULL, 'H', 0, 4, 0),
(4250, '2013 款', NULL, 1145, 0, NULL, 'H', 0, 4, 0),
(4251, '2014 款', NULL, 1146, 0, NULL, 'H', 0, 4, 0),
(4252, '2012 款', NULL, 1147, 0, NULL, 'H', 0, 4, 0),
(4253, '2010 款', NULL, 1147, 0, NULL, 'H', 0, 4, 0),
(4254, '2009 款', NULL, 1147, 0, NULL, 'H', 0, 4, 0),
(4255, '2005 款', NULL, 1147, 0, NULL, 'H', 0, 4, 0),
(4256, '2013 款', NULL, 1148, 0, NULL, 'H', 0, 4, 0),
(4257, '2012 款', NULL, 1148, 0, NULL, 'H', 0, 4, 0),
(4258, '2011 款', NULL, 1148, 0, NULL, 'H', 0, 4, 0),
(4259, '2010 款', NULL, 1148, 0, NULL, 'H', 0, 4, 0),
(4260, '2014 款', NULL, 1149, 0, NULL, 'H', 0, 4, 0),
(4261, '2013 款', NULL, 1149, 0, NULL, 'H', 0, 4, 0),
(4262, '2012 款', NULL, 1149, 0, NULL, 'H', 0, 4, 0),
(4263, '2011 款', NULL, 1149, 0, NULL, 'H', 0, 4, 0),
(4264, '2014 款', NULL, 1150, 0, NULL, 'H', 0, 4, 0),
(4265, '2010 款', NULL, 1151, 0, NULL, 'H', 0, 4, 0),
(4266, '2009 款', NULL, 1151, 0, NULL, 'H', 0, 4, 0),
(4267, '2012 款', NULL, 1152, 0, NULL, 'H', 0, 4, 0),
(4268, '2011 款', NULL, 1152, 0, NULL, 'H', 0, 4, 0),
(4269, '2008 款', NULL, 1152, 0, NULL, 'H', 0, 4, 0),
(4270, '2006 款', NULL, 1152, 0, NULL, 'H', 0, 4, 0),
(4271, '2005 款', NULL, 1153, 0, NULL, 'J', 0, 4, 0),
(4272, '2004 款', NULL, 1153, 0, NULL, 'J', 0, 4, 0),
(4273, '2003 款', NULL, 1153, 0, NULL, 'J', 0, 4, 0),
(4274, '2006 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4275, '2005 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4276, '2004 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4277, '2003 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4278, '2001 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4279, '1999 款', NULL, 1154, 0, NULL, 'J', 0, 4, 0),
(4280, '2001 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4281, '2000 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4282, '1998 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4283, '1997 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4284, '1996 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4285, '1995 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4286, '1994 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4287, '1993 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4288, '1992 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4289, '1990 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4290, '1989 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4291, '1987 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4292, '1985 款', NULL, 1155, 0, NULL, 'J', 0, 4, 0),
(4293, '2014 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4294, '2013 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4295, '2012 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4296, '2011 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4297, '2010 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4298, '2008 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4299, '2007 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4300, '2002 款', NULL, 1156, 0, NULL, 'J', 0, 4, 0),
(4301, '2014 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4302, '2013 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4303, '2012 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4304, '2011 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4305, '2010 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4306, '2009 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4307, '2008 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4308, '2007 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4309, '2004 款', NULL, 1157, 0, NULL, 'J', 0, 4, 0),
(4310, '1995 款', NULL, 1158, 0, NULL, 'J', 0, 4, 0),
(4311, '2010 款', NULL, 1159, 0, NULL, 'J', 0, 4, 0),
(4312, '2008 款', NULL, 1159, 0, NULL, 'J', 0, 4, 0),
(4313, '2007 款', NULL, 1159, 0, NULL, 'J', 0, 4, 0),
(4314, '2014 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4315, '2013 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4316, '2012 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4317, '2011 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4318, '2010 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4319, '2009 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4320, '2007 款', NULL, 1160, 0, NULL, 'J', 0, 4, 0),
(4321, '2014 款', NULL, 1161, 0, NULL, 'J', 0, 4, 0),
(4322, '2014 款', NULL, 1162, 0, NULL, 'J', 0, 4, 0),
(4323, '2013 款', NULL, 1162, 0, NULL, 'J', 0, 4, 0),
(4324, '2012 款', NULL, 1162, 0, NULL, 'J', 0, 4, 0),
(4325, '2011 款', NULL, 1162, 0, NULL, 'J', 0, 4, 0),
(4326, '2004 款', NULL, 1163, 0, NULL, 'J', 0, 4, 0),
(4327, '2007 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4328, '2006 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4329, '2005 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4330, '2004 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4331, '2002 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4332, '2001 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4333, '2000 款', NULL, 1164, 0, NULL, 'J', 0, 4, 0),
(4334, '2013 款', NULL, 1165, 0, NULL, 'J', 0, 4, 0),
(4335, '2012 款', NULL, 1165, 0, NULL, 'J', 0, 4, 0),
(4336, '2011 款', NULL, 1165, 0, NULL, 'J', 0, 4, 0),
(4337, '2013 款', NULL, 1166, 0, NULL, 'J', 0, 4, 0),
(4338, '2012 款', NULL, 1166, 0, NULL, 'J', 0, 4, 0),
(4339, '2014 款', NULL, 1167, 0, NULL, 'J', 0, 4, 0),
(4340, '2013 款', NULL, 1167, 0, NULL, 'J', 0, 4, 0),
(4341, '2012 款', NULL, 1167, 0, NULL, 'J', 0, 4, 0),
(4342, '2014 款', NULL, 1168, 0, NULL, 'J', 0, 4, 0),
(4343, '2012 款', NULL, 1168, 0, NULL, 'J', 0, 4, 0),
(4344, '2014 款', NULL, 1169, 0, NULL, 'J', 0, 4, 0),
(4345, '2013 款', NULL, 1169, 0, NULL, 'J', 0, 4, 0),
(4346, '2013 款', NULL, 1170, 0, NULL, 'J', 0, 4, 0),
(4347, '2012 款', NULL, 1170, 0, NULL, 'J', 0, 4, 0),
(4348, '2010 款', NULL, 1170, 0, NULL, 'J', 0, 4, 0),
(4349, '2009 款', NULL, 1170, 0, NULL, 'J', 0, 4, 0),
(4350, '2013 款', NULL, 1171, 0, NULL, 'J', 0, 4, 0),
(4351, '2012 款', NULL, 1171, 0, NULL, 'J', 0, 4, 0),
(4352, '2011 款', NULL, 1171, 0, NULL, 'J', 0, 4, 0),
(4353, '2010 款', NULL, 1171, 0, NULL, 'J', 0, 4, 0),
(4354, '2009 款', NULL, 1171, 0, NULL, 'J', 0, 4, 0),
(4355, '2014 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4356, '2013 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4357, '2012 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4358, '2011 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4359, '2010 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4360, '2009 款', NULL, 1172, 0, NULL, 'J', 0, 4, 0),
(4361, '2014 款', NULL, 1173, 0, NULL, 'J', 0, 4, 0),
(4362, '2012 款', NULL, 1173, 0, NULL, 'J', 0, 4, 0),
(4363, '2013 款', NULL, 1174, 0, NULL, 'J', 0, 4, 0),
(4364, '2010 款', NULL, 1174, 0, NULL, 'J', 0, 4, 0),
(4365, '2009 款', NULL, 1174, 0, NULL, 'J', 0, 4, 0),
(4366, '2014 款', NULL, 1175, 0, NULL, 'J', 0, 4, 0),
(4367, '2011 款', NULL, 1175, 0, NULL, 'J', 0, 4, 0),
(4368, '2010 款', NULL, 1175, 0, NULL, 'J', 0, 4, 0),
(4369, '2009 款', NULL, 1175, 0, NULL, 'J', 0, 4, 0),
(4370, '2008 款', NULL, 1175, 0, NULL, 'J', 0, 4, 0),
(4371, '2014 款', NULL, 1176, 0, NULL, 'J', 0, 4, 0),
(4372, '2011 款', NULL, 1176, 0, NULL, 'J', 0, 4, 0),
(4373, '2013 款', NULL, 1177, 0, NULL, 'J', 0, 4, 0),
(4374, '2011 款', NULL, 1177, 0, NULL, 'J', 0, 4, 0),
(4375, '2010 款', NULL, 1177, 0, NULL, 'J', 0, 4, 0),
(4376, '2009 款', NULL, 1177, 0, NULL, 'J', 0, 4, 0),
(4377, '2008 款', NULL, 1177, 0, NULL, 'J', 0, 4, 0),
(4378, '2014 款', NULL, 1178, 0, NULL, 'J', 0, 4, 0),
(4379, '2009 款', NULL, 1179, 0, NULL, 'J', 0, 4, 0),
(4380, '2014 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4381, '2013 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4382, '2012 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4383, '2011 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4384, '2010 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4385, '2009 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4386, '2008 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4387, '2006 款', NULL, 1180, 0, NULL, 'J', 0, 4, 0),
(4388, '2014 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4389, '2012 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4390, '2011 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4391, '2010 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4392, '2009 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4393, '2008 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4394, '2007 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4395, '2006 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4396, '2005 款', NULL, 1181, 0, NULL, 'J', 0, 4, 0),
(4397, '2010 款', NULL, 1182, 0, NULL, 'J', 0, 4, 0),
(4398, '2009 款', NULL, 1182, 0, NULL, 'J', 0, 4, 0),
(4399, '2008 款', NULL, 1182, 0, NULL, 'J', 0, 4, 0),
(4400, '2007 款', NULL, 1182, 0, NULL, 'J', 0, 4, 0),
(4401, '2006 款', NULL, 1182, 0, NULL, 'J', 0, 4, 0),
(4402, '2007 款', NULL, 1183, 0, NULL, 'J', 0, 4, 0),
(4403, '2006 款', NULL, 1183, 0, NULL, 'J', 0, 4, 0),
(4404, '2005 款', NULL, 1183, 0, NULL, 'J', 0, 4, 0),
(4405, '2004 款', NULL, 1183, 0, NULL, 'J', 0, 4, 0),
(4406, '2003 款', NULL, 1183, 0, NULL, 'J', 0, 4, 0),
(4407, '2007 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4408, '2006 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4409, '2005 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4410, '2004 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4411, '2002 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4412, '2001 款', NULL, 1184, 0, NULL, 'J', 0, 4, 0),
(4413, '2012 款', NULL, 1185, 0, NULL, 'J', 0, 4, 0),
(4414, '2011 款', NULL, 1185, 0, NULL, 'J', 0, 4, 0),
(4415, '2010 款', NULL, 1185, 0, NULL, 'J', 0, 4, 0),
(4416, '2007 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4417, '2006 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4418, '2005 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4419, '2004 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4420, '2003 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4421, '2002 款', NULL, 1186, 0, NULL, 'J', 0, 4, 0),
(4422, '2009 款', NULL, 1187, 0, NULL, 'J', 0, 4, 0),
(4423, '2012 款', NULL, 1188, 0, NULL, 'J', 0, 4, 0),
(4424, '2011 款', NULL, 1188, 0, NULL, 'J', 0, 4, 0),
(4425, '2009 款', NULL, 1188, 0, NULL, 'J', 0, 4, 0),
(4426, '2008 款', NULL, 1188, 0, NULL, 'J', 0, 4, 0),
(4427, '2014 款', NULL, 1189, 0, NULL, 'J', 0, 4, 0),
(4428, '2013 款', NULL, 1189, 0, NULL, 'J', 0, 4, 0),
(4429, '2012 款', NULL, 1189, 0, NULL, 'J', 0, 4, 0),
(4430, '2011 款', NULL, 1189, 0, NULL, 'J', 0, 4, 0),
(4431, '2010 款', NULL, 1189, 0, NULL, 'J', 0, 4, 0),
(4432, '2014 款', NULL, 1190, 0, NULL, 'J', 0, 4, 0),
(4433, '2012 款', NULL, 1190, 0, NULL, 'J', 0, 4, 0),
(4434, '2010 款', NULL, 1190, 0, NULL, 'J', 0, 4, 0),
(4435, '2009 款', NULL, 1190, 0, NULL, 'J', 0, 4, 0),
(4436, '2008 款', NULL, 1190, 0, NULL, 'J', 0, 4, 0),
(4437, '2014 款', NULL, 1191, 0, NULL, 'J', 0, 4, 0),
(4438, '2012 款', NULL, 1191, 0, NULL, 'J', 0, 4, 0),
(4439, '2010 款', NULL, 1191, 0, NULL, 'J', 0, 4, 0),
(4440, '2009 款', NULL, 1191, 0, NULL, 'J', 0, 4, 0),
(4441, '2014 款', NULL, 1192, 0, NULL, 'J', 0, 4, 0),
(4442, '2013 款', NULL, 1192, 0, NULL, 'J', 0, 4, 0),
(4443, '2014 款', NULL, 1193, 0, NULL, 'J', 0, 4, 0),
(4444, '2013 款', NULL, 1194, 0, NULL, 'J', 0, 4, 0),
(4445, '2012 款', NULL, 1194, 0, NULL, 'J', 0, 4, 0),
(4446, '2011 款', NULL, 1194, 0, NULL, 'J', 0, 4, 0),
(4447, '2010 款', NULL, 1194, 0, NULL, 'J', 0, 4, 0),
(4448, '2012 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4449, '2011 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4450, '2010 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4451, '2009 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4452, '2008 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4453, '2007 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4454, '2006 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4455, '2005 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4456, '2004 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4457, '2003 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4458, '2002 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4459, '2001 款', NULL, 1195, 0, NULL, 'J', 0, 4, 0),
(4460, '2013 款', NULL, 1196, 0, NULL, 'J', 0, 4, 0),
(4461, '2012 款', NULL, 1196, 0, NULL, 'J', 0, 4, 0),
(4462, '2011 款', NULL, 1196, 0, NULL, 'J', 0, 4, 0),
(4463, '2014 款', NULL, 1197, 0, NULL, 'J', 0, 4, 0),
(4464, '2013 款', NULL, 1197, 0, NULL, 'J', 0, 4, 0),
(4465, '2011 款', NULL, 1198, 0, NULL, 'J', 0, 4, 0),
(4466, '2013 款', NULL, 1199, 0, NULL, 'J', 0, 4, 0),
(4467, '2011 款', NULL, 1199, 0, NULL, 'J', 0, 4, 0),
(4468, '2012 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4469, '2011 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4470, '2010 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4471, '2009 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4472, '2008 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4473, '2007 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4474, '2006 款', NULL, 1200, 0, NULL, 'J', 0, 4, 0),
(4475, '2013 款', NULL, 1201, 0, NULL, 'J', 0, 4, 0),
(4476, '2012 款', NULL, 1201, 0, NULL, 'J', 0, 4, 0),
(4477, '2011 款', NULL, 1201, 0, NULL, 'J', 0, 4, 0),
(4478, '2014 款', NULL, 1202, 0, NULL, 'J', 0, 4, 0),
(4479, '2013 款', NULL, 1202, 0, NULL, 'J', 0, 4, 0),
(4480, '2012 款', NULL, 1202, 0, NULL, 'J', 0, 4, 0),
(4481, '2011 款', NULL, 1202, 0, NULL, 'J', 0, 4, 0),
(4482, '2010 款', NULL, 1202, 0, NULL, 'J', 0, 4, 0),
(4483, '1993 款', NULL, 1203, 0, NULL, 'J', 0, 4, 0),
(4484, '其他', NULL, 1203, 0, NULL, 'J', 0, 4, 0),
(4485, '2009 款', NULL, 1204, 0, NULL, 'J', 0, 4, 0),
(4486, '2009 款', NULL, 1205, 0, NULL, 'J', 0, 4, 0),
(4487, '2011 款', NULL, 1206, 0, NULL, 'J', 0, 4, 0),
(4488, '2014 款', NULL, 1207, 0, NULL, 'J', 0, 4, 0),
(4489, '2011 款', NULL, 1207, 0, NULL, 'J', 0, 4, 0),
(4490, '2009 款', NULL, 1208, 0, NULL, 'J', 0, 4, 0),
(4491, '2009 款', NULL, 1209, 0, NULL, 'J', 0, 4, 0),
(4492, '2011 款', NULL, 1210, 0, NULL, 'J', 0, 4, 0),
(4493, '2009 款', NULL, 1210, 0, NULL, 'J', 0, 4, 0),
(4494, '2011 款', NULL, 1211, 0, NULL, 'J', 0, 4, 0),
(4495, '2013 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4496, '2009 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4497, '2007 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4498, '2005 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4499, '2003 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4500, '2000 款', NULL, 1212, 0, NULL, 'J', 0, 4, 0),
(4501, '2009 款', NULL, 1213, 0, NULL, 'J', 0, 4, 0),
(4502, '2005 款', NULL, 1213, 0, NULL, 'J', 0, 4, 0),
(4503, '2014 款', NULL, 1214, 0, NULL, 'J', 0, 4, 0),
(4504, '2013 款', NULL, 1214, 0, NULL, 'J', 0, 4, 0),
(4505, '2010 款', NULL, 1214, 0, NULL, 'J', 0, 4, 0),
(4506, '2008 款', NULL, 1214, 0, NULL, 'J', 0, 4, 0),
(4507, '2014 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4508, '2013 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4509, '2011 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4510, '2010 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4511, '2006 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4512, '2003 款', NULL, 1215, 0, NULL, 'J', 0, 4, 0),
(4513, '2013 款', NULL, 1216, 0, NULL, 'J', 0, 4, 0),
(4514, '2010 款', NULL, 1216, 0, NULL, 'J', 0, 4, 0),
(4515, '2008 款', NULL, 1216, 0, NULL, 'J', 0, 4, 0),
(4516, '2013 款', NULL, 1217, 0, NULL, 'J', 0, 4, 0),
(4517, '2013 款', NULL, 1218, 0, NULL, 'J', 0, 4, 0),
(4518, '2011 款', NULL, 1218, 0, NULL, 'J', 0, 4, 0),
(4519, '2013 款', NULL, 1219, 0, NULL, 'J', 0, 4, 0),
(4520, '2010 款', NULL, 1219, 0, NULL, 'J', 0, 4, 0),
(4521, '2008 款', NULL, 1219, 0, NULL, 'J', 0, 4, 0),
(4522, '2013 款', NULL, 1220, 0, NULL, 'J', 0, 4, 0),
(4523, '2010 款', NULL, 1220, 0, NULL, 'J', 0, 4, 0),
(4524, '2008 款', NULL, 1220, 0, NULL, 'J', 0, 4, 0),
(4525, '其他', NULL, 1220, 0, NULL, 'J', 0, 4, 0),
(4526, '2013 款', NULL, 1221, 0, NULL, 'J', 0, 4, 0),
(4527, '2012 款', NULL, 1221, 0, NULL, 'J', 0, 4, 0),
(4528, '2011 款', NULL, 1221, 0, NULL, 'J', 0, 4, 0),
(4529, '2012 款', NULL, 1222, 0, NULL, 'J', 0, 4, 0),
(4530, '2009 款', NULL, 1223, 0, NULL, 'J', 0, 4, 0),
(4531, '2006 款', NULL, 1224, 0, NULL, 'J', 0, 4, 0),
(4532, '2005 款', NULL, 1224, 0, NULL, 'J', 0, 4, 0),
(4533, '2005 款', NULL, 1225, 0, NULL, 'J', 0, 4, 0),
(4534, '2004 款', NULL, 1225, 0, NULL, 'J', 0, 4, 0),
(4535, '2006 款', NULL, 1226, 0, NULL, 'J', 0, 4, 0),
(4536, '2005 款', NULL, 1226, 0, NULL, 'J', 0, 4, 0),
(4537, '2009 款', NULL, 1227, 0, NULL, 'J', 0, 4, 0),
(4538, '2008 款', NULL, 1227, 0, NULL, 'J', 0, 4, 0),
(4539, '2007 款', NULL, 1227, 0, NULL, 'J', 0, 4, 0),
(4540, '2013 款', NULL, 1228, 0, NULL, 'J', 0, 4, 0),
(4541, '2012 款', NULL, 1228, 0, NULL, 'J', 0, 4, 0),
(4542, '2011 款', NULL, 1228, 0, NULL, 'J', 0, 4, 0),
(4543, '2009 款', NULL, 1228, 0, NULL, 'J', 0, 4, 0),
(4544, '2013 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4545, '2011 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4546, '2010 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4547, '2009 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4548, '2008 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4549, '2007 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4550, '2005 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4551, '2004 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4552, '2001 款', NULL, 1229, 0, NULL, 'J', 0, 4, 0),
(4553, '2014 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4554, '2013 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4555, '2011 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4556, '2010 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4557, '2009 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4558, '2008 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4559, '2007 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4560, '2006 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4561, '2004 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4562, '2003 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4563, '2001 款', NULL, 1230, 0, NULL, 'J', 0, 4, 0),
(4564, '2013 款', NULL, 1231, 0, NULL, 'J', 0, 4, 0),
(4565, '2011 款', NULL, 1231, 0, NULL, 'J', 0, 4, 0),
(4566, '2009 款', NULL, 1231, 0, NULL, 'J', 0, 4, 0),
(4567, '2008 款', NULL, 1231, 0, NULL, 'J', 0, 4, 0),
(4568, '2012 款', NULL, 1232, 0, NULL, 'J', 0, 4, 0),
(4569, '2011 款', NULL, 1232, 0, NULL, 'J', 0, 4, 0),
(4570, '2009 款', NULL, 1232, 0, NULL, 'J', 0, 4, 0),
(4571, '2011 款', NULL, 1233, 0, NULL, 'J', 0, 4, 0),
(4572, '2014 款', NULL, 1234, 0, NULL, 'J', 0, 4, 0),
(4573, '2009 款', NULL, 1234, 0, NULL, 'J', 0, 4, 0),
(4574, '2007 款', NULL, 1234, 0, NULL, 'J', 0, 4, 0);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(4575, '2005 款', NULL, 1234, 0, NULL, 'J', 0, 4, 0),
(4576, '2014 款', NULL, 1235, 0, NULL, 'J', 0, 4, 0),
(4577, '2011 款', NULL, 1235, 0, NULL, 'J', 0, 4, 0),
(4578, '2005 款', NULL, 1235, 0, NULL, 'J', 0, 4, 0),
(4579, '2014 款', NULL, 1236, 0, NULL, 'J', 0, 4, 0),
(4580, '2013 款', NULL, 1236, 0, NULL, 'J', 0, 4, 0),
(4581, '2009 款', NULL, 1236, 0, NULL, 'J', 0, 4, 0),
(4582, '2013 款', NULL, 1237, 0, NULL, 'J', 0, 4, 0),
(4583, '2014 款', NULL, 1238, 0, NULL, 'J', 0, 4, 0),
(4584, '2013 款', NULL, 1238, 0, NULL, 'J', 0, 4, 0),
(4585, '2014 款', NULL, 1239, 0, NULL, 'J', 0, 4, 0),
(4586, '2012 款', NULL, 1239, 0, NULL, 'J', 0, 4, 0),
(4587, '2013 款', NULL, 1240, 0, NULL, 'J', 0, 4, 0),
(4588, '2010 款', NULL, 1240, 0, NULL, 'J', 0, 4, 0),
(4589, '其他', NULL, 1240, 0, NULL, 'J', 0, 4, 0),
(4590, '2013 款', NULL, 1241, 0, NULL, 'J', 0, 4, 0),
(4591, '2013 款', NULL, 1242, 0, NULL, 'J', 0, 4, 0),
(4592, '2004 款', NULL, 1243, 0, NULL, 'J', 0, 4, 0),
(4593, '2004 款', NULL, 1244, 0, NULL, 'J', 0, 4, 0),
(4594, '2004 款', NULL, 1245, 0, NULL, 'J', 0, 4, 0),
(4595, '2002 款', NULL, 1245, 0, NULL, 'J', 0, 4, 0),
(4596, '2005 款', NULL, 1246, 0, NULL, 'J', 0, 4, 0),
(4597, '2003 款', NULL, 1247, 0, NULL, 'J', 0, 4, 0),
(4598, '2001 款', NULL, 1248, 0, NULL, 'J', 0, 4, 0),
(4599, '2014 款', NULL, 1249, 0, NULL, 'J', 0, 4, 0),
(4600, '2013 款', NULL, 1249, 0, NULL, 'J', 0, 4, 0),
(4601, '2006 款', NULL, 1250, 0, NULL, 'J', 0, 4, 0),
(4602, '2004 款', NULL, 1250, 0, NULL, 'J', 0, 4, 0),
(4603, '2002 款', NULL, 1250, 0, NULL, 'J', 0, 4, 0),
(4604, '2000 款', NULL, 1250, 0, NULL, 'J', 0, 4, 0),
(4605, '2014 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4606, '2013 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4607, '2012 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4608, '2011 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4609, '2010 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4610, '2009 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4611, '2008 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4612, '2007 款', NULL, 1251, 0, NULL, 'J', 0, 4, 0),
(4613, '2011 款', NULL, 1252, 0, NULL, 'J', 0, 4, 0),
(4614, '2009 款', NULL, 1252, 0, NULL, 'J', 0, 4, 0),
(4615, '2014 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4616, '2013 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4617, '2012 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4618, '2011 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4619, '2010 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4620, '2007 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4621, '2005 款', NULL, 1253, 0, NULL, 'J', 0, 4, 0),
(4622, '2009 款', NULL, 1254, 0, NULL, 'J', 0, 4, 0),
(4623, '2012 款', NULL, 1255, 0, NULL, 'J', 0, 4, 0),
(4624, '2011 款', NULL, 1255, 0, NULL, 'J', 0, 4, 0),
(4625, '2009 款', NULL, 1255, 0, NULL, 'J', 0, 4, 0),
(4626, '2003 款', NULL, 1255, 0, NULL, 'J', 0, 4, 0),
(4627, '2002 款', NULL, 1255, 0, NULL, 'J', 0, 4, 0),
(4628, '1996 款', NULL, 1256, 0, NULL, 'J', 0, 4, 0),
(4629, '1993 款', NULL, 1256, 0, NULL, 'J', 0, 4, 0),
(4630, '2011 款', NULL, 1257, 0, NULL, 'J', 0, 4, 0),
(4631, '2011 款', NULL, 1258, 0, NULL, 'J', 0, 4, 0),
(4632, '2010 款', NULL, 1258, 0, NULL, 'J', 0, 4, 0),
(4633, '2011 款', NULL, 1259, 0, NULL, 'J', 0, 4, 0),
(4634, '2013 款', NULL, 1260, 0, NULL, 'J', 0, 4, 0),
(4635, '2013 款', NULL, 1261, 0, NULL, 'J', 0, 4, 0),
(4636, '2013 款', NULL, 1262, 0, NULL, 'J', 0, 4, 0),
(4637, '2010 款', NULL, 1262, 0, NULL, 'J', 0, 4, 0),
(4638, '2008 款', NULL, 1263, 0, NULL, 'K', 0, 4, 0),
(4639, '2007 款', NULL, 1263, 0, NULL, 'K', 0, 4, 0),
(4640, '2007 款', NULL, 1264, 0, NULL, 'K', 0, 4, 0),
(4641, '2006 款', NULL, 1264, 0, NULL, 'K', 0, 4, 0),
(4642, '2005 款', NULL, 1264, 0, NULL, 'K', 0, 4, 0),
(4643, '2012 款', NULL, 1265, 0, NULL, 'K', 0, 4, 0),
(4644, '2007 款', NULL, 1265, 0, NULL, 'K', 0, 4, 0),
(4645, '1998 款', NULL, 1266, 0, NULL, 'K', 0, 4, 0),
(4646, '2007 款', NULL, 1267, 0, NULL, 'K', 0, 4, 0),
(4647, '2006 款', NULL, 1267, 0, NULL, 'K', 0, 4, 0),
(4648, '2000 款', NULL, 1267, 0, NULL, 'K', 0, 4, 0),
(4649, '2010 款', NULL, 1268, 0, NULL, 'K', 0, 4, 0),
(4650, '2012 款', NULL, 1269, 0, NULL, 'K', 0, 4, 0),
(4651, '2004 款', NULL, 1269, 0, NULL, 'K', 0, 4, 0),
(4652, '1999 款', NULL, 1269, 0, NULL, 'K', 0, 4, 0),
(4653, '2007 款', NULL, 1270, 0, NULL, 'K', 0, 4, 0),
(4654, '2014 款', NULL, 1271, 0, NULL, 'K', 0, 4, 0),
(4655, '2013 款', NULL, 1271, 0, NULL, 'K', 0, 4, 0),
(4656, '2012 款', NULL, 1271, 0, NULL, 'K', 0, 4, 0),
(4657, '2007 款', NULL, 1271, 0, NULL, 'K', 0, 4, 0),
(4658, '2004 款', NULL, 1271, 0, NULL, 'K', 0, 4, 0),
(4659, '1995 款', NULL, 1272, 0, NULL, 'K', 0, 4, 0),
(4660, '1994 款', NULL, 1272, 0, NULL, 'K', 0, 4, 0),
(4661, '2004 款', NULL, 1273, 0, NULL, 'K', 0, 4, 0),
(4662, '2001 款', NULL, 1274, 0, NULL, 'K', 0, 4, 0),
(4663, '1995 款', NULL, 1274, 0, NULL, 'K', 0, 4, 0),
(4664, '1992 款', NULL, 1275, 0, NULL, 'K', 0, 4, 0),
(4665, '2007 款', NULL, 1276, 0, NULL, 'K', 0, 4, 0),
(4666, '2003 款', NULL, 1276, 0, NULL, 'K', 0, 4, 0),
(4667, '2014 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4668, '2008 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4669, '2007 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4670, '2006 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4671, '2005 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4672, '2004 款', NULL, 1277, 0, NULL, 'K', 0, 4, 0),
(4673, '2008 款', NULL, 1278, 0, NULL, 'K', 0, 4, 0),
(4674, '2006 款', NULL, 1278, 0, NULL, 'K', 0, 4, 0),
(4675, '2005 款', NULL, 1278, 0, NULL, 'K', 0, 4, 0),
(4676, '2014 款', NULL, 1279, 0, NULL, 'K', 0, 4, 0),
(4677, '2013 款', NULL, 1279, 0, NULL, 'K', 0, 4, 0),
(4678, '2012 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4679, '2011 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4680, '2010 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4681, '2008 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4682, '2007 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4683, '2006 款', NULL, 1280, 0, NULL, 'K', 0, 4, 0),
(4684, '2006 款', NULL, 1281, 0, NULL, 'K', 0, 4, 0),
(4685, '2014 款', NULL, 1282, 0, NULL, 'K', 0, 4, 0),
(4686, '2012 款', NULL, 1283, 0, NULL, 'K', 0, 4, 0),
(4687, '2011 款', NULL, 1283, 0, NULL, 'K', 0, 4, 0),
(4688, '2014 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4689, '2012 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4690, '2011 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4691, '2010 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4692, '2009 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4693, '2008 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4694, '2007 款', NULL, 1284, 0, NULL, 'K', 0, 4, 0),
(4695, '2012 款', NULL, 1285, 0, NULL, 'K', 0, 4, 0),
(4696, '2009 款', NULL, 1285, 0, NULL, 'K', 0, 4, 0),
(4697, '2006 款', NULL, 1286, 0, NULL, 'K', 0, 4, 0),
(4698, '2014 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4699, '2013 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4700, '2012 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4701, '2011 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4702, '2010 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4703, '2009 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4704, '2006 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4705, '2005 款', NULL, 1287, 0, NULL, 'K', 0, 4, 0),
(4706, '2008 款', NULL, 1288, 0, NULL, 'K', 0, 4, 0),
(4707, '2005 款', NULL, 1288, 0, NULL, 'K', 0, 4, 0),
(4708, '2007 款', NULL, 1289, 0, NULL, 'K', 0, 4, 0),
(4709, '2013 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4710, '2012 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4711, '2008 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4712, '2005 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4713, '2004 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4714, '1986 款', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4715, '其他', NULL, 1290, 0, NULL, 'K', 0, 4, 0),
(4716, '2011 款', NULL, 1291, 0, NULL, 'K', 0, 4, 0),
(4717, '2010 款', NULL, 1291, 0, NULL, 'K', 0, 4, 0),
(4718, '2009 款', NULL, 1291, 0, NULL, 'K', 0, 4, 0),
(4719, '2008 款', NULL, 1292, 0, NULL, 'K', 0, 4, 0),
(4720, '1995 款', NULL, 1293, 0, NULL, 'K', 0, 4, 0),
(4721, '1993 款', NULL, 1294, 0, NULL, 'K', 0, 4, 0),
(4722, '2013 款', NULL, 1295, 0, NULL, 'K', 0, 4, 0),
(4723, '2010 款', NULL, 1296, 0, NULL, 'K', 0, 4, 0),
(4724, '2008 款', NULL, 1296, 0, NULL, 'K', 0, 4, 0),
(4725, '2013 款', NULL, 1297, 0, NULL, 'K', 0, 4, 0),
(4726, '2007 款', NULL, 1298, 0, NULL, 'K', 0, 4, 0),
(4727, '2013 款', NULL, 1299, 0, NULL, 'K', 0, 4, 0),
(4728, '2011 款', NULL, 1299, 0, NULL, 'K', 0, 4, 0),
(4729, '2010 款', NULL, 1299, 0, NULL, 'K', 0, 4, 0),
(4730, '2011 款', NULL, 1300, 0, NULL, 'K', 0, 4, 0),
(4731, '2009 款', NULL, 1300, 0, NULL, 'K', 0, 4, 0),
(4732, '2012 款', NULL, 1301, 0, NULL, 'K', 0, 4, 0),
(4733, '2011 款', NULL, 1301, 0, NULL, 'K', 0, 4, 0),
(4734, '2010 款', NULL, 1301, 0, NULL, 'K', 0, 4, 0),
(4735, '2013 款', NULL, 1302, 0, NULL, 'K', 0, 4, 0),
(4736, '2011 款', NULL, 1302, 0, NULL, 'K', 0, 4, 0),
(4737, '2007 款', NULL, 1302, 0, NULL, 'K', 0, 4, 0),
(4738, '2009 款', NULL, 1303, 0, NULL, 'K', 0, 4, 0),
(4739, '2013 款', NULL, 1304, 0, NULL, 'K', 0, 4, 0),
(4740, '2012 款', NULL, 1304, 0, NULL, 'K', 0, 4, 0),
(4741, '2011 款', NULL, 1304, 0, NULL, 'K', 0, 4, 0),
(4742, '2009 款', NULL, 1304, 0, NULL, 'K', 0, 4, 0),
(4743, '2013 款', NULL, 1305, 0, NULL, 'K', 0, 4, 0),
(4744, '2013 款', NULL, 1306, 0, NULL, 'K', 0, 4, 0),
(4745, '2013 款', NULL, 1307, 0, NULL, 'K', 0, 4, 0),
(4746, '2014 款', NULL, 1308, 0, NULL, 'K', 0, 4, 0),
(4747, '2014 款', NULL, 1309, 0, NULL, 'K', 0, 4, 0),
(4748, '2014 款', NULL, 1310, 0, NULL, 'K', 0, 4, 0),
(4749, '2013 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4750, '2012 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4751, '2011 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4752, '2010 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4753, '2009 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4754, '2008 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4755, '2007 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4756, '2005 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4757, '2004 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4758, '2003 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4759, '2002 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4760, '2001 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4761, '2000 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4762, '1999 款', NULL, 1311, 0, NULL, 'L', 0, 4, 0),
(4763, '2013 款', NULL, 1312, 0, NULL, 'L', 0, 4, 0),
(4764, '2012 款', NULL, 1312, 0, NULL, 'L', 0, 4, 0),
(4765, '2011 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4766, '2010 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4767, '2009 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4768, '2008 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4769, '2007 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4770, '2006 款', NULL, 1313, 0, NULL, 'L', 0, 4, 0),
(4771, '2014 款', NULL, 1314, 0, NULL, 'L', 0, 4, 0),
(4772, '2014 款', NULL, 1315, 0, NULL, 'L', 0, 4, 0),
(4773, '2013 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4774, '2012 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4775, '2011 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4776, '2010 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4777, '2008 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4778, '2007 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4779, '2006 款', NULL, 1316, 0, NULL, 'L', 0, 4, 0),
(4780, '2012 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4781, '2011 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4782, '2010 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4783, '2008 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4784, '2007 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4785, '2006 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4786, '2005 款', NULL, 1317, 0, NULL, 'L', 0, 4, 0),
(4787, '2013 款', NULL, 1318, 0, NULL, 'L', 0, 4, 0),
(4788, '2012 款', NULL, 1318, 0, NULL, 'L', 0, 4, 0),
(4789, '2011 款', NULL, 1318, 0, NULL, 'L', 0, 4, 0),
(4790, '2013 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4791, '2012 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4792, '2011 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4793, '2010 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4794, '2009 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4795, '2007 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4796, '2002 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4797, '2000 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4798, '1999 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4799, '1997 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4800, '1993 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4801, '1992 款', NULL, 1319, 0, NULL, 'L', 0, 4, 0),
(4802, '2014 款', NULL, 1320, 0, NULL, 'L', 0, 4, 0),
(4803, '2013 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4804, '2012 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4805, '2011 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4806, '2009 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4807, '2007 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4808, '2006 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4809, '2005 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4810, '2003 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4811, '2002 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4812, '2001 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4813, '1999 款', NULL, 1321, 0, NULL, 'L', 0, 4, 0),
(4814, '2013 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4815, '2012 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4816, '2011 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4817, '2010 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4818, '2009 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4819, '2008 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4820, '2007 款', NULL, 1322, 0, NULL, 'L', 0, 4, 0),
(4821, '2013 款', NULL, 1323, 0, NULL, 'L', 0, 4, 0),
(4822, '2011 款', NULL, 1323, 0, NULL, 'L', 0, 4, 0),
(4823, '2010 款', NULL, 1324, 0, NULL, 'L', 0, 4, 0),
(4824, '2009 款', NULL, 1324, 0, NULL, 'L', 0, 4, 0),
(4825, '2008 款', NULL, 1324, 0, NULL, 'L', 0, 4, 0),
(4826, '2006 款', NULL, 1324, 0, NULL, 'L', 0, 4, 0),
(4827, '2005 款', NULL, 1324, 0, NULL, 'L', 0, 4, 0),
(4828, '2012 款', NULL, 1325, 0, NULL, 'L', 0, 4, 0),
(4829, '2011 款', NULL, 1325, 0, NULL, 'L', 0, 4, 0),
(4830, '2013 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4831, '2012 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4832, '2011 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4833, '2010 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4834, '2009 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4835, '2008 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4836, '2007 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4837, '2006 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4838, '2005 款', NULL, 1326, 0, NULL, 'L', 0, 4, 0),
(4839, '2000 款', NULL, 1327, 0, NULL, 'L', 0, 4, 0),
(4840, '2012 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4841, '2011 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4842, '2008 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4843, '2007 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4844, '2006 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4845, '2002 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4846, '1996 款', NULL, 1328, 0, NULL, 'L', 0, 4, 0),
(4847, '2012 款', NULL, 1329, 0, NULL, 'L', 0, 4, 0),
(4848, '2011 款', NULL, 1329, 0, NULL, 'L', 0, 4, 0),
(4849, '2009 款', NULL, 1329, 0, NULL, 'L', 0, 4, 0),
(4850, '2007 款', NULL, 1329, 0, NULL, 'L', 0, 4, 0),
(4851, '2014 款', NULL, 1330, 0, NULL, 'L', 0, 4, 0),
(4852, '2011 款', NULL, 1330, 0, NULL, 'L', 0, 4, 0),
(4853, '2010 款', NULL, 1330, 0, NULL, 'L', 0, 4, 0),
(4854, '2014 款', NULL, 1331, 0, NULL, 'L', 0, 4, 0),
(4855, '2013 款', NULL, 1332, 0, NULL, 'L', 0, 4, 0),
(4856, '2011 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4857, '2010 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4858, '2008 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4859, '2007 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4860, '2006 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4861, '2005 款', NULL, 1333, 0, NULL, 'L', 0, 4, 0),
(4862, '2014 款', NULL, 1334, 0, NULL, 'L', 0, 4, 0),
(4863, '2012 款', NULL, 1334, 0, NULL, 'L', 0, 4, 0),
(4864, '2011 款', NULL, 1334, 0, NULL, 'L', 0, 4, 0),
(4865, '2009 款', NULL, 1334, 0, NULL, 'L', 0, 4, 0),
(4866, '2013 款', NULL, 1335, 0, NULL, 'L', 0, 4, 0),
(4867, '2009 款', NULL, 1335, 0, NULL, 'L', 0, 4, 0),
(4868, '2006 款', NULL, 1335, 0, NULL, 'L', 0, 4, 0),
(4869, '2004 款', NULL, 1335, 0, NULL, 'L', 0, 4, 0),
(4870, '2003 款', NULL, 1335, 0, NULL, 'L', 0, 4, 0),
(4871, '2008 款', NULL, 1336, 0, NULL, 'L', 0, 4, 0),
(4872, '2011 款', NULL, 1337, 0, NULL, 'L', 0, 4, 0),
(4873, '2009 款', NULL, 1337, 0, NULL, 'L', 0, 4, 0),
(4874, '2008 款', NULL, 1337, 0, NULL, 'L', 0, 4, 0),
(4875, '2006 款', NULL, 1337, 0, NULL, 'L', 0, 4, 0),
(4876, '2004 款', NULL, 1338, 0, NULL, 'L', 0, 4, 0),
(4877, '2011 款', NULL, 1339, 0, NULL, 'L', 0, 4, 0),
(4878, '2010 款', NULL, 1339, 0, NULL, 'L', 0, 4, 0),
(4879, '2012 款', NULL, 1340, 0, NULL, 'L', 0, 4, 0),
(4880, '2011 款', NULL, 1340, 0, NULL, 'L', 0, 4, 0),
(4881, '2010 款', NULL, 1340, 0, NULL, 'L', 0, 4, 0),
(4882, '2009 款', NULL, 1340, 0, NULL, 'L', 0, 4, 0),
(4883, '2013 款', NULL, 1341, 0, NULL, 'L', 0, 4, 0),
(4884, '2011 款', NULL, 1342, 0, NULL, 'L', 0, 4, 0),
(4885, '2010 款', NULL, 1342, 0, NULL, 'L', 0, 4, 0),
(4886, '2007 款', NULL, 1342, 0, NULL, 'L', 0, 4, 0),
(4887, '2006 款', NULL, 1342, 0, NULL, 'L', 0, 4, 0),
(4888, '2011 款', NULL, 1343, 0, NULL, 'L', 0, 4, 0),
(4889, '2010 款', NULL, 1343, 0, NULL, 'L', 0, 4, 0),
(4890, '2009 款', NULL, 1343, 0, NULL, 'L', 0, 4, 0),
(4891, '2008 款', NULL, 1343, 0, NULL, 'L', 0, 4, 0),
(4892, '2013 款', NULL, 1344, 0, NULL, 'L', 0, 4, 0),
(4893, '2012 款', NULL, 1345, 0, NULL, 'L', 0, 4, 0),
(4894, '2011 款', NULL, 1345, 0, NULL, 'L', 0, 4, 0),
(4895, '2010 款', NULL, 1345, 0, NULL, 'L', 0, 4, 0),
(4896, '2009 款', NULL, 1345, 0, NULL, 'L', 0, 4, 0),
(4897, '2013 款', NULL, 1346, 0, NULL, 'L', 0, 4, 0),
(4898, '2014 款', NULL, 1347, 0, NULL, 'L', 0, 4, 0),
(4899, '2013 款', NULL, 1347, 0, NULL, 'L', 0, 4, 0),
(4900, '2012 款', NULL, 1347, 0, NULL, 'L', 0, 4, 0),
(4901, '2013 款', NULL, 1348, 0, NULL, 'L', 0, 4, 0),
(4902, '2012 款', NULL, 1348, 0, NULL, 'L', 0, 4, 0),
(4903, '2011 款', NULL, 1348, 0, NULL, 'L', 0, 4, 0),
(4904, '2012 款', NULL, 1349, 0, NULL, 'L', 0, 4, 0),
(4905, '2011 款', NULL, 1349, 0, NULL, 'L', 0, 4, 0),
(4906, '2014 款', NULL, 1350, 0, NULL, 'L', 0, 4, 0),
(4907, '2012 款', NULL, 1350, 0, NULL, 'L', 0, 4, 0),
(4908, '2010 款', NULL, 1350, 0, NULL, 'L', 0, 4, 0),
(4909, '2013 款', NULL, 1351, 0, NULL, 'L', 0, 4, 0),
(4910, '2007 款', NULL, 1351, 0, NULL, 'L', 0, 4, 0),
(4911, '2006 款', NULL, 1351, 0, NULL, 'L', 0, 4, 0),
(4912, '2004 款', NULL, 1351, 0, NULL, 'L', 0, 4, 0),
(4913, '1993 款', NULL, 1352, 0, NULL, 'L', 0, 4, 0),
(4914, '1989 款', NULL, 1352, 0, NULL, 'L', 0, 4, 0),
(4915, '1985 款', NULL, 1352, 0, NULL, 'L', 0, 4, 0),
(4916, '1980 款', NULL, 1352, 0, NULL, 'L', 0, 4, 0),
(4917, '2000 款', NULL, 1353, 0, NULL, 'L', 0, 4, 0),
(4918, '1998 款', NULL, 1353, 0, NULL, 'L', 0, 4, 0),
(4919, '1996 款', NULL, 1353, 0, NULL, 'L', 0, 4, 0),
(4920, '2014 款', NULL, 1354, 0, NULL, 'L', 0, 4, 0),
(4921, '2002 款', NULL, 1355, 0, NULL, 'L', 0, 4, 0),
(4922, '2011 款', NULL, 1356, 0, NULL, 'L', 0, 4, 0),
(4923, '2012 款', NULL, 1357, 0, NULL, 'L', 0, 4, 0),
(4924, '2012 款', NULL, 1358, 0, NULL, 'L', 0, 4, 0),
(4925, '2013 款', NULL, 1359, 0, NULL, 'L', 0, 4, 0),
(4926, '2011 款', NULL, 1359, 0, NULL, 'L', 0, 4, 0),
(4927, '2014 款', NULL, 1360, 0, NULL, 'L', 0, 4, 0),
(4928, '2010 款', NULL, 1361, 0, NULL, 'L', 0, 4, 0),
(4929, '2007 款', NULL, 1361, 0, NULL, 'L', 0, 4, 0),
(4930, '2006 款', NULL, 1361, 0, NULL, 'L', 0, 4, 0),
(4931, '2001 款', NULL, 1361, 0, NULL, 'L', 0, 4, 0),
(4932, '2013 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4933, '2012 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4934, '2011 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4935, '2010 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4936, '2009 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4937, '2008 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4938, '2007 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4939, '2004 款', NULL, 1362, 0, NULL, 'L', 0, 4, 0),
(4940, '2014 款', NULL, 1363, 0, NULL, 'L', 0, 4, 0),
(4941, '2013 款', NULL, 1363, 0, NULL, 'L', 0, 4, 0),
(4942, '2012 款', NULL, 1363, 0, NULL, 'L', 0, 4, 0),
(4943, '2011 款', NULL, 1363, 0, NULL, 'L', 0, 4, 0),
(4944, '2013 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4945, '2012 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4946, '2010 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4947, '2009 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4948, '2006 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4949, '2004 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4950, '1994 款', NULL, 1364, 0, NULL, 'L', 0, 4, 0),
(4951, '2014 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4952, '2012 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4953, '2011 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4954, '2010 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4955, '2009 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4956, '2008 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4957, '2005 款', NULL, 1365, 0, NULL, 'L', 0, 4, 0),
(4958, '2014 款', NULL, 1366, 0, NULL, 'L', 0, 4, 0),
(4959, '2012 款', NULL, 1366, 0, NULL, 'L', 0, 4, 0),
(4960, '2010 款', NULL, 1366, 0, NULL, 'L', 0, 4, 0),
(4961, '2003 款', NULL, 1366, 0, NULL, 'L', 0, 4, 0),
(4962, '2013 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4963, '2011 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4964, '2009 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4965, '2008 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4966, '2007 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4967, '2006 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4968, '2005 款', NULL, 1367, 0, NULL, 'L', 0, 4, 0),
(4969, '2010 款', NULL, 1368, 0, NULL, 'L', 0, 4, 0),
(4970, '2014 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4971, '2013 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4972, '2010 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4973, '2009 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4974, '2007 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4975, '2006 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4976, '2004 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4977, '1995 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4978, '1994 款', NULL, 1369, 0, NULL, 'L', 0, 4, 0),
(4979, '2013 款', NULL, 1370, 0, NULL, 'L', 0, 4, 0),
(4980, '2012 款', NULL, 1370, 0, NULL, 'L', 0, 4, 0),
(4981, '2009 款', NULL, 1370, 0, NULL, 'L', 0, 4, 0),
(4982, '2007 款', NULL, 1370, 0, NULL, 'L', 0, 4, 0),
(4983, '2005 款', NULL, 1370, 0, NULL, 'L', 0, 4, 0),
(4984, '2014 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4985, '2013 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4986, '2012 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4987, '2011 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4988, '2010 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4989, '2009 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4990, '2007 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4991, '2006 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4992, '2004 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4993, '2003 款', NULL, 1371, 0, NULL, 'L', 0, 4, 0),
(4994, '2005 款', NULL, 1372, 0, NULL, 'L', 0, 4, 0),
(4995, '2010 款', NULL, 1373, 0, NULL, 'L', 0, 4, 0),
(4996, '2004 款', NULL, 1373, 0, NULL, 'L', 0, 4, 0),
(4997, '2002 款', NULL, 1373, 0, NULL, 'L', 0, 4, 0),
(4998, '2000 款', NULL, 1373, 0, NULL, 'L', 0, 4, 0),
(4999, '2001 款', NULL, 1374, 0, NULL, 'L', 0, 4, 0),
(5000, '2000 款', NULL, 1375, 0, NULL, 'L', 0, 4, 0),
(5001, '2011 款', NULL, 1376, 0, NULL, 'L', 0, 4, 0),
(5002, '2013 款', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5003, '2012 款', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5004, '2011 款', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5005, '2010 款', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5006, '2009 款', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5007, '其他', NULL, 1377, 0, NULL, 'L', 0, 4, 0),
(5008, '2013 款', NULL, 1378, 0, NULL, 'L', 0, 4, 0),
(5009, '2012 款', NULL, 1378, 0, NULL, 'L', 0, 4, 0),
(5010, '2011 款', NULL, 1378, 0, NULL, 'L', 0, 4, 0),
(5011, '2010 款', NULL, 1378, 0, NULL, 'L', 0, 4, 0),
(5012, '2007 款', NULL, 1378, 0, NULL, 'L', 0, 4, 0),
(5013, '2010 款', NULL, 1379, 0, NULL, 'L', 0, 4, 0),
(5014, '2009 款', NULL, 1379, 0, NULL, 'L', 0, 4, 0),
(5015, '2008 款', NULL, 1379, 0, NULL, 'L', 0, 4, 0),
(5016, '2007 款', NULL, 1380, 0, NULL, 'L', 0, 4, 0),
(5017, '2012 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5018, '2011 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5019, '2010 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5020, '2007 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5021, '2005 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5022, '2000 款', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5023, '其他', NULL, 1381, 0, NULL, 'L', 0, 4, 0),
(5024, '2014 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5025, '2013 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5026, '2011 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5027, '2010 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5028, '2009 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5029, '2005 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5030, '2003 款', NULL, 1382, 0, NULL, 'L', 0, 4, 0),
(5031, '2014 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5032, '2013 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5033, '2012 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5034, '2011 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5035, '2010 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5036, '2009 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5037, '2007 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5038, '2006 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5039, '2005 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5040, '2002 款', NULL, 1383, 0, NULL, 'L', 0, 4, 0),
(5041, '2014 款', NULL, 1384, 0, NULL, 'L', 0, 4, 0),
(5042, '2013 款', NULL, 1384, 0, NULL, 'L', 0, 4, 0),
(5043, '2012 款', NULL, 1384, 0, NULL, 'L', 0, 4, 0),
(5044, '2011 款', NULL, 1384, 0, NULL, 'L', 0, 4, 0),
(5045, '2014 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5046, '2013 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5047, '2012 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5048, '2011 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5049, '2010 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5050, '2006 款', NULL, 1385, 0, NULL, 'L', 0, 4, 0),
(5051, '2010 款', NULL, 1386, 0, NULL, 'L', 0, 4, 0),
(5052, '2004 款', NULL, 1386, 0, NULL, 'L', 0, 4, 0),
(5053, '2014 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5054, '2013 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5055, '2011 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5056, '2010 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5057, '2009 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5058, '2003 款', NULL, 1387, 0, NULL, 'L', 0, 4, 0),
(5059, '2002 款', NULL, 1388, 0, NULL, 'L', 0, 4, 0),
(5060, '2012 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5061, '2011 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5062, '2007 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5063, '2005 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5064, '2004 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5065, '2003 款', NULL, 1389, 0, NULL, 'L', 0, 4, 0),
(5066, '2013 款', NULL, 1390, 0, NULL, 'L', 0, 4, 0),
(5067, '2011 款', NULL, 1390, 0, NULL, 'L', 0, 4, 0),
(5068, '2014 款', NULL, 1391, 0, NULL, 'L', 0, 4, 0),
(5069, '2013 款', NULL, 1391, 0, NULL, 'L', 0, 4, 0),
(5070, '2012 款', NULL, 1391, 0, NULL, 'L', 0, 4, 0),
(5071, '2010 款', NULL, 1391, 0, NULL, 'L', 0, 4, 0),
(5072, '2009 款', NULL, 1391, 0, NULL, 'L', 0, 4, 0),
(5073, '2012 款', NULL, 1392, 0, NULL, 'L', 0, 4, 0),
(5074, '2011 款', NULL, 1392, 0, NULL, 'L', 0, 4, 0),
(5075, '2009 款', NULL, 1392, 0, NULL, 'L', 0, 4, 0),
(5076, '2006 款', NULL, 1392, 0, NULL, 'L', 0, 4, 0),
(5077, '2003 款', NULL, 1392, 0, NULL, 'L', 0, 4, 0),
(5078, '2004 款', NULL, 1393, 0, NULL, 'L', 0, 4, 0),
(5079, '2011 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5080, '2007 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5081, '2006 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5082, '2005 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5083, '2002 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5084, '2001 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5085, '1996 款', NULL, 1394, 0, NULL, 'L', 0, 4, 0),
(5086, '2013 款', NULL, 1395, 0, NULL, 'L', 0, 4, 0),
(5087, '2012 款', NULL, 1395, 0, NULL, 'L', 0, 4, 0),
(5088, '2013 款', NULL, 1396, 0, NULL, 'L', 0, 4, 0),
(5089, '2011 款', NULL, 1396, 0, NULL, 'L', 0, 4, 0),
(5090, '2000 款', NULL, 1397, 0, NULL, 'L', 0, 4, 0),
(5091, '2004 款', NULL, 1398, 0, NULL, 'L', 0, 4, 0),
(5092, '2002 款', NULL, 1398, 0, NULL, 'L', 0, 4, 0),
(5093, '2009 款', NULL, 1399, 0, NULL, 'L', 0, 4, 0),
(5094, '2008 款', NULL, 1399, 0, NULL, 'L', 0, 4, 0),
(5095, '2013 款', NULL, 1400, 0, NULL, 'L', 0, 4, 0),
(5096, '2013 款', NULL, 1401, 0, NULL, 'L', 0, 4, 0),
(5097, '2011 款', NULL, 1401, 0, NULL, 'L', 0, 4, 0),
(5098, '2009 款', NULL, 1401, 0, NULL, 'L', 0, 4, 0),
(5099, '2013 款', NULL, 1402, 0, NULL, 'L', 0, 4, 0),
(5100, '2010 款', NULL, 1402, 0, NULL, 'L', 0, 4, 0),
(5101, '2009 款', NULL, 1402, 0, NULL, 'L', 0, 4, 0),
(5102, '2013 款', NULL, 1403, 0, NULL, 'L', 0, 4, 0),
(5103, '2013 款', NULL, 1404, 0, NULL, 'L', 0, 4, 0),
(5104, '2012 款', NULL, 1404, 0, NULL, 'L', 0, 4, 0),
(5105, '2011 款', NULL, 1404, 0, NULL, 'L', 0, 4, 0),
(5106, '2013 款', NULL, 1405, 0, NULL, 'L', 0, 4, 0),
(5107, '2012 款', NULL, 1405, 0, NULL, 'L', 0, 4, 0),
(5108, '2011 款', NULL, 1405, 0, NULL, 'L', 0, 4, 0),
(5109, '2009 款', NULL, 1406, 0, NULL, 'L', 0, 4, 0),
(5110, '2008 款', NULL, 1407, 0, NULL, 'L', 0, 4, 0),
(5111, '2009 款', NULL, 1408, 0, NULL, 'L', 0, 4, 0),
(5112, '2014 款', NULL, 1409, 0, NULL, 'L', 0, 4, 0),
(5113, '2010 款', NULL, 1410, 0, NULL, 'L', 0, 4, 0),
(5114, '2009 款', NULL, 1410, 0, NULL, 'L', 0, 4, 0),
(5115, '2008 款', NULL, 1410, 0, NULL, 'L', 0, 4, 0),
(5116, '2005 款', NULL, 1410, 0, NULL, 'L', 0, 4, 0),
(5117, '2005 款', NULL, 1411, 0, NULL, 'L', 0, 4, 0),
(5118, '2004 款', NULL, 1411, 0, NULL, 'L', 0, 4, 0),
(5119, '2003 款', NULL, 1411, 0, NULL, 'L', 0, 4, 0),
(5120, '2002 款', NULL, 1411, 0, NULL, 'L', 0, 4, 0),
(5121, '2005 款', NULL, 1412, 0, NULL, 'L', 0, 4, 0),
(5122, '2004 款', NULL, 1413, 0, NULL, 'L', 0, 4, 0),
(5123, '2002 款', NULL, 1413, 0, NULL, 'L', 0, 4, 0),
(5124, '2011 款', NULL, 1414, 0, NULL, 'L', 0, 4, 0),
(5125, '2010 款', NULL, 1414, 0, NULL, 'L', 0, 4, 0),
(5126, '2009 款', NULL, 1414, 0, NULL, 'L', 0, 4, 0),
(5127, '2008 款', NULL, 1414, 0, NULL, 'L', 0, 4, 0),
(5128, '2007 款', NULL, 1414, 0, NULL, 'L', 0, 4, 0),
(5129, '2014 款', NULL, 1415, 0, NULL, 'L', 0, 4, 0),
(5130, '2013 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5131, '2011 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5132, '2010 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5133, '2009 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5134, '2008 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5135, '2006 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5136, '2005 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5137, '2004 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5138, '2003 款', NULL, 1416, 0, NULL, 'L', 0, 4, 0),
(5139, '2013 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5140, '2010 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5141, '2009 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5142, '2008 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5143, '2007 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5144, '2006 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5145, '2005 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5146, '2004 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5147, '2003 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5148, '2002 款', NULL, 1417, 0, NULL, 'L', 0, 4, 0),
(5149, '2009 款', NULL, 1418, 0, NULL, 'L', 0, 4, 0),
(5150, '2008 款', NULL, 1418, 0, NULL, 'L', 0, 4, 0),
(5151, '2009 款', NULL, 1419, 0, NULL, 'L', 0, 4, 0),
(5152, '2008 款', NULL, 1420, 0, NULL, 'L', 0, 4, 0),
(5153, '2010 款', NULL, 1421, 0, NULL, 'L', 0, 4, 0),
(5154, '2009 款', NULL, 1421, 0, NULL, 'L', 0, 4, 0),
(5155, '2007 款', NULL, 1422, 0, NULL, 'L', 0, 4, 0),
(5156, '2006 款', NULL, 1422, 0, NULL, 'L', 0, 4, 0),
(5157, '2005 款', NULL, 1423, 0, NULL, 'L', 0, 4, 0),
(5158, '2003 款', NULL, 1423, 0, NULL, 'L', 0, 4, 0),
(5159, '2004 款', NULL, 1424, 0, NULL, 'L', 0, 4, 0),
(5160, '2003 款', NULL, 1424, 0, NULL, 'L', 0, 4, 0),
(5161, '2014 款', NULL, 1425, 0, NULL, 'L', 0, 4, 0),
(5162, '2011 款', NULL, 1425, 0, NULL, 'L', 0, 4, 0),
(5163, '2010 款', NULL, 1425, 0, NULL, 'L', 0, 4, 0),
(5164, '2010 款', NULL, 1426, 0, NULL, 'L', 0, 4, 0),
(5165, '2009 款', NULL, 1426, 0, NULL, 'L', 0, 4, 0),
(5166, '2005 款', NULL, 1426, 0, NULL, 'L', 0, 4, 0),
(5167, '2004 款', NULL, 1427, 0, NULL, 'L', 0, 4, 0),
(5168, '2014 款', NULL, 1428, 0, NULL, 'L', 0, 4, 0),
(5169, '2013 款', NULL, 1428, 0, NULL, 'L', 0, 4, 0),
(5170, '2012 款', NULL, 1428, 0, NULL, 'L', 0, 4, 0),
(5171, '2011 款', NULL, 1428, 0, NULL, 'L', 0, 4, 0),
(5172, '2013 款', NULL, 1429, 0, NULL, 'L', 0, 4, 0),
(5173, '2013 款', NULL, 1430, 0, NULL, 'L', 0, 4, 0),
(5174, '2014 款', NULL, 1431, 0, NULL, 'M', 0, 4, 0),
(5175, '2014 款', NULL, 1432, 0, NULL, 'M', 0, 4, 0),
(5176, '2012 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5177, '2011 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5178, '2010 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5179, '2009 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5180, '2008 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5181, '2007 款', NULL, 1433, 0, NULL, 'M', 0, 4, 0),
(5182, '2012 款', NULL, 1434, 0, NULL, 'M', 0, 4, 0),
(5183, '2011 款', NULL, 1434, 0, NULL, 'M', 0, 4, 0),
(5184, '2010 款', NULL, 1434, 0, NULL, 'M', 0, 4, 0),
(5185, '2008 款', NULL, 1434, 0, NULL, 'M', 0, 4, 0),
(5186, '2012 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5187, '2010 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5188, '2009 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5189, '2008 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5190, '2007 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5191, '2006 款', NULL, 1435, 0, NULL, 'M', 0, 4, 0),
(5192, '2013 款', NULL, 1436, 0, NULL, 'M', 0, 4, 0),
(5193, '2012 款', NULL, 1436, 0, NULL, 'M', 0, 4, 0),
(5194, '2013 款', NULL, 1437, 0, NULL, 'M', 0, 4, 0),
(5195, '2011 款', NULL, 1437, 0, NULL, 'M', 0, 4, 0),
(5196, '2014 款', NULL, 1438, 0, NULL, 'M', 0, 4, 0),
(5197, '2013 款', NULL, 1438, 0, NULL, 'M', 0, 4, 0),
(5198, '2014 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5199, '2013 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5200, '2012 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5201, '2011 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5202, '2010 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5203, '2009 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5204, '2008 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5205, '2007 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5206, '2006 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5207, '2005 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5208, '2004 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5209, '2003 款', NULL, 1439, 0, NULL, 'M', 0, 4, 0),
(5210, '2014 款', NULL, 1440, 0, NULL, 'M', 0, 4, 0),
(5211, '2007 款', NULL, 1441, 0, NULL, 'M', 0, 4, 0),
(5212, '2006 款', NULL, 1441, 0, NULL, 'M', 0, 4, 0),
(5213, '2008 款', NULL, 1442, 0, NULL, 'M', 0, 4, 0),
(5214, '2007 款', NULL, 1442, 0, NULL, 'M', 0, 4, 0),
(5215, '2006 款', NULL, 1442, 0, NULL, 'M', 0, 4, 0),
(5216, '2013 款', NULL, 1443, 0, NULL, 'M', 0, 4, 0),
(5217, '2011 款', NULL, 1443, 0, NULL, 'M', 0, 4, 0),
(5218, '2012 款', NULL, 1444, 0, NULL, 'M', 0, 4, 0),
(5219, '2011 款', NULL, 1444, 0, NULL, 'M', 0, 4, 0),
(5220, '2010 款', NULL, 1444, 0, NULL, 'M', 0, 4, 0),
(5221, '2009 款', NULL, 1444, 0, NULL, 'M', 0, 4, 0),
(5222, '2008 款', NULL, 1444, 0, NULL, 'M', 0, 4, 0),
(5223, '2012 款', NULL, 1445, 0, NULL, 'M', 0, 4, 0),
(5224, '2011 款', NULL, 1445, 0, NULL, 'M', 0, 4, 0),
(5225, '2010 款', NULL, 1445, 0, NULL, 'M', 0, 4, 0),
(5226, '2008 款', NULL, 1446, 0, NULL, 'M', 0, 4, 0),
(5227, '2004 款', NULL, 1446, 0, NULL, 'M', 0, 4, 0),
(5228, '2007 款', NULL, 1447, 0, NULL, 'M', 0, 4, 0),
(5229, '1992 款', NULL, 1448, 0, NULL, 'M', 0, 4, 0),
(5230, '2010 款', NULL, 1449, 0, NULL, 'M', 0, 4, 0),
(5231, '2007 款', NULL, 1449, 0, NULL, 'M', 0, 4, 0),
(5232, '2013 款', NULL, 1450, 0, NULL, 'M', 0, 4, 0),
(5233, '2011 款', NULL, 1450, 0, NULL, 'M', 0, 4, 0),
(5234, '2007 款', NULL, 1450, 0, NULL, 'M', 0, 4, 0),
(5235, '1992 款', NULL, 1451, 0, NULL, 'M', 0, 4, 0),
(5236, '1992 款', NULL, 1452, 0, NULL, 'M', 0, 4, 0),
(5237, '2013 款', NULL, 1453, 0, NULL, 'M', 0, 4, 0),
(5238, '2012 款', NULL, 1454, 0, NULL, 'M', 0, 4, 0),
(5239, '2011 款', NULL, 1455, 0, NULL, 'M', 0, 4, 0),
(5240, '2010 款', NULL, 1455, 0, NULL, 'M', 0, 4, 0),
(5241, '2013 款', NULL, 1456, 0, NULL, 'M', 0, 4, 0),
(5242, '2010 款', NULL, 1456, 0, NULL, 'M', 0, 4, 0),
(5243, '2001 款', NULL, 1457, 0, NULL, 'M', 0, 4, 0),
(5244, '2009 款', NULL, 1458, 0, NULL, 'M', 0, 4, 0),
(5245, '2002 款', NULL, 1459, 0, NULL, 'M', 0, 4, 0),
(5246, '2010 款', NULL, 1460, 0, NULL, 'M', 0, 4, 0),
(5247, '2007 款', NULL, 1460, 0, NULL, 'M', 0, 4, 0),
(5248, '其他', NULL, 1460, 0, NULL, 'M', 0, 4, 0),
(5249, '2004 款', NULL, 1461, 0, NULL, 'M', 0, 4, 0),
(5250, '其他', NULL, 1461, 0, NULL, 'M', 0, 4, 0),
(5251, '2010 款', NULL, 1462, 0, NULL, 'M', 0, 4, 0),
(5252, '2005 款', NULL, 1462, 0, NULL, 'M', 0, 4, 0),
(5253, '2004 款', NULL, 1462, 0, NULL, 'M', 0, 4, 0),
(5254, '2007 款', NULL, 1463, 0, NULL, 'M', 0, 4, 0),
(5255, '2014 款', NULL, 1464, 0, NULL, 'M', 0, 4, 0),
(5256, '2013 款', NULL, 1464, 0, NULL, 'M', 0, 4, 0),
(5257, '2012 款', NULL, 1464, 0, NULL, 'M', 0, 4, 0),
(5258, '2011 款', NULL, 1464, 0, NULL, 'M', 0, 4, 0),
(5259, '2009 款', NULL, 1465, 0, NULL, 'M', 0, 4, 0),
(5260, '2008 款', NULL, 1465, 0, NULL, 'M', 0, 4, 0),
(5261, '2014 款', NULL, 1466, 0, NULL, 'M', 0, 4, 0),
(5262, '2013 款', NULL, 1466, 0, NULL, 'M', 0, 4, 0),
(5263, '2012 款', NULL, 1466, 0, NULL, 'M', 0, 4, 0),
(5264, '2014 款', NULL, 1467, 0, NULL, 'M', 0, 4, 0),
(5265, '2013 款', NULL, 1467, 0, NULL, 'M', 0, 4, 0),
(5266, '2012 款', NULL, 1467, 0, NULL, 'M', 0, 4, 0),
(5267, '2010 款', NULL, 1467, 0, NULL, 'M', 0, 4, 0),
(5268, '2013 款', NULL, 1468, 0, NULL, 'M', 0, 4, 0),
(5269, '2012 款', NULL, 1468, 0, NULL, 'M', 0, 4, 0),
(5270, '2011 款', NULL, 1468, 0, NULL, 'M', 0, 4, 0),
(5271, '2010 款', NULL, 1469, 0, NULL, 'M', 0, 4, 0),
(5272, '2009 款', NULL, 1469, 0, NULL, 'M', 0, 4, 0),
(5273, '2008 款', NULL, 1469, 0, NULL, 'M', 0, 4, 0),
(5274, '2007 款', NULL, 1469, 0, NULL, 'M', 0, 4, 0),
(5275, '2006 款', NULL, 1469, 0, NULL, 'M', 0, 4, 0),
(5276, '2008 款', NULL, 1470, 0, NULL, 'M', 0, 4, 0),
(5277, '2007 款', NULL, 1470, 0, NULL, 'M', 0, 4, 0),
(5278, '2014 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5279, '2013 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5280, '2012 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5281, '2011 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5282, '2010 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5283, '2008 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5284, '2007 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5285, '2004 款', NULL, 1471, 0, NULL, 'M', 0, 4, 0),
(5286, '2011 款', NULL, 1472, 0, NULL, 'M', 0, 4, 0),
(5287, '2009 款', NULL, 1472, 0, NULL, 'M', 0, 4, 0),
(5288, '2004 款', NULL, 1472, 0, NULL, 'M', 0, 4, 0),
(5289, '2012 款', NULL, 1473, 0, NULL, 'M', 0, 4, 0),
(5290, '2011 款', NULL, 1473, 0, NULL, 'M', 0, 4, 0),
(5291, '2010 款', NULL, 1473, 0, NULL, 'M', 0, 4, 0),
(5292, '2008 款', NULL, 1473, 0, NULL, 'M', 0, 4, 0),
(5293, '2013 款', NULL, 1474, 0, NULL, 'M', 0, 4, 0),
(5294, '2012 款', NULL, 1474, 0, NULL, 'M', 0, 4, 0),
(5295, '2011 款', NULL, 1474, 0, NULL, 'M', 0, 4, 0),
(5296, '2012 款', NULL, 1475, 0, NULL, 'M', 0, 4, 0),
(5297, '2013 款', NULL, 1476, 0, NULL, 'M', 0, 4, 0),
(5298, '2012 款', NULL, 1477, 0, NULL, 'M', 0, 4, 0),
(5299, '2013 款', NULL, 1478, 0, NULL, 'M', 0, 4, 0),
(5300, '2013 款', NULL, 1479, 0, NULL, 'M', 0, 4, 0),
(5301, '2013 款', NULL, 1480, 0, NULL, 'M', 0, 4, 0),
(5302, '2013 款', NULL, 1481, 0, NULL, 'M', 0, 4, 0),
(5303, '2013 款', NULL, 1482, 0, NULL, 'M', 0, 4, 0),
(5304, '2005 款', NULL, 1483, 0, NULL, 'M', 0, 4, 0),
(5305, '2010 款', NULL, 1484, 0, NULL, 'M', 0, 4, 0),
(5306, '2010 款', NULL, 1485, 0, NULL, 'M', 0, 4, 0),
(5307, '2009 款', NULL, 1485, 0, NULL, 'M', 0, 4, 0),
(5308, '2005 款', NULL, 1485, 0, NULL, 'M', 0, 4, 0),
(5309, '2007 款', NULL, 1486, 0, NULL, 'M', 0, 4, 0),
(5310, '2003 款', NULL, 1487, 0, NULL, 'M', 0, 4, 0),
(5311, '2003 款', NULL, 1488, 0, NULL, 'M', 0, 4, 0),
(5312, '2012 款', NULL, 1489, 0, NULL, 'M', 0, 4, 0),
(5313, '2010 款', NULL, 1489, 0, NULL, 'M', 0, 4, 0),
(5314, '2014 款', NULL, 1490, 0, NULL, 'M', 0, 4, 0),
(5315, '2013 款', NULL, 1491, 0, NULL, 'M', 0, 4, 0),
(5316, '2012 款', NULL, 1491, 0, NULL, 'M', 0, 4, 0),
(5317, '2009 款', NULL, 1491, 0, NULL, 'M', 0, 4, 0),
(5318, '2003 款', NULL, 1492, 0, NULL, 'M', 0, 4, 0),
(5319, '2013 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5320, '2011 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5321, '2009 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5322, '2008 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5323, '2006 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5324, '2003 款', NULL, 1493, 0, NULL, 'M', 0, 4, 0),
(5325, '2014 款', NULL, 1494, 0, NULL, 'M', 0, 4, 0),
(5326, '2013 款', NULL, 1495, 0, NULL, 'M', 0, 4, 0),
(5327, '2012 款', NULL, 1495, 0, NULL, 'M', 0, 4, 0),
(5328, '2014 款', NULL, 1496, 0, NULL, 'M', 0, 4, 0),
(5329, '2013 款', NULL, 1497, 0, NULL, 'M', 0, 4, 0),
(5330, '2013 款', NULL, 1498, 0, NULL, 'M', 0, 4, 0),
(5331, '2013 款', NULL, 1499, 0, NULL, 'M', 0, 4, 0),
(5332, '2014 款', NULL, 1500, 0, NULL, 'N', 0, 4, 0),
(5333, '2013 款', NULL, 1500, 0, NULL, 'N', 0, 4, 0),
(5334, '2012 款', NULL, 1501, 0, NULL, 'N', 0, 4, 0),
(5335, '2013 款', NULL, 1502, 0, NULL, 'N', 0, 4, 0),
(5336, '2014 款', NULL, 1503, 0, NULL, 'N', 0, 4, 0),
(5337, '2013 款', NULL, 1503, 0, NULL, 'N', 0, 4, 0),
(5338, '2012 款', NULL, 1503, 0, NULL, 'N', 0, 4, 0),
(5339, '2011 款', NULL, 1503, 0, NULL, 'N', 0, 4, 0),
(5340, '2014 款', NULL, 1504, 0, NULL, 'N', 0, 4, 0),
(5341, '2013 款', NULL, 1505, 0, NULL, 'O', 0, 4, 0),
(5342, '2014 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5343, '2011 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5344, '2010 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5345, '2009 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5346, '2006 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5347, '2004 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5348, '2001 款', NULL, 1506, 0, NULL, 'O', 0, 4, 0),
(5349, '2013 款', NULL, 1507, 0, NULL, 'O', 0, 4, 0),
(5350, '2012 款', NULL, 1507, 0, NULL, 'O', 0, 4, 0),
(5351, '2009 款', NULL, 1508, 0, NULL, 'O', 0, 4, 0),
(5352, '2006 款', NULL, 1508, 0, NULL, 'O', 0, 4, 0),
(5353, '2013 款', NULL, 1509, 0, NULL, 'O', 0, 4, 0),
(5354, '2012 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5355, '2010 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5356, '2009 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5357, '2008 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5358, '2005 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5359, '2003 款', NULL, 1510, 0, NULL, 'O', 0, 4, 0),
(5360, '2011 款', NULL, 1511, 0, NULL, 'O', 0, 4, 0),
(5361, '2009 款', NULL, 1511, 0, NULL, 'O', 0, 4, 0),
(5362, '2013 款', NULL, 1512, 0, NULL, 'O', 0, 4, 0),
(5363, '2012 款', NULL, 1512, 0, NULL, 'O', 0, 4, 0),
(5364, '2011 款', NULL, 1512, 0, NULL, 'O', 0, 4, 0),
(5365, '2010 款', NULL, 1512, 0, NULL, 'O', 0, 4, 0),
(5366, '2008 款', NULL, 1512, 0, NULL, 'O', 0, 4, 0),
(5367, '2014 款', NULL, 1513, 0, NULL, 'O', 0, 4, 0),
(5368, '其他', NULL, 1514, 0, NULL, 'O', 0, 4, 0),
(5369, '2002 款', NULL, 1515, 0, NULL, 'O', 0, 4, 0),
(5370, '1994 款', NULL, 1516, 0, NULL, 'O', 0, 4, 0),
(5371, '2013 款', NULL, 1517, 0, NULL, 'O', 0, 4, 0),
(5372, '2010 款', NULL, 1517, 0, NULL, 'O', 0, 4, 0),
(5373, '2006 款', NULL, 1517, 0, NULL, 'O', 0, 4, 0),
(5374, '2005 款', NULL, 1517, 0, NULL, 'O', 0, 4, 0),
(5375, '2002 款', NULL, 1517, 0, NULL, 'O', 0, 4, 0),
(5376, '2007 款', NULL, 1518, 0, NULL, 'O', 0, 4, 0),
(5377, '2006 款', NULL, 1518, 0, NULL, 'O', 0, 4, 0),
(5378, '2005 款', NULL, 1518, 0, NULL, 'O', 0, 4, 0),
(5379, '2003 款', NULL, 1518, 0, NULL, 'O', 0, 4, 0),
(5380, '1998 款', NULL, 1518, 0, NULL, 'O', 0, 4, 0),
(5381, '2014 款', NULL, 1519, 0, NULL, 'O', 0, 4, 0),
(5382, '2010 款', NULL, 1519, 0, NULL, 'O', 0, 4, 0),
(5383, '2006 款', NULL, 1519, 0, NULL, 'O', 0, 4, 0),
(5384, '2005 款', NULL, 1519, 0, NULL, 'O', 0, 4, 0),
(5385, '2008 款', NULL, 1520, 0, NULL, 'O', 0, 4, 0),
(5386, '2013 款', NULL, 1521, 0, NULL, 'O', 0, 4, 0),
(5387, '2007 款', NULL, 1521, 0, NULL, 'O', 0, 4, 0),
(5388, '2005 款', NULL, 1521, 0, NULL, 'O', 0, 4, 0),
(5389, '2007 款', NULL, 1522, 0, NULL, 'O', 0, 4, 0),
(5390, '2013 款', NULL, 1523, 0, NULL, 'O', 0, 4, 0),
(5391, '2012 款', NULL, 1524, 0, NULL, 'O', 0, 4, 0),
(5392, '2014 款', NULL, 1525, 0, NULL, 'O', 0, 4, 0),
(5393, '2007 款', NULL, 1526, 0, NULL, 'P', 0, 4, 0),
(5394, '2002 款', NULL, 1526, 0, NULL, 'P', 0, 4, 0),
(5395, '2009 款', NULL, 1527, 0, NULL, 'P', 0, 4, 0),
(5396, '2012 款', NULL, 1528, 0, NULL, 'P', 0, 4, 0),
(5397, '2003 款', NULL, 1529, 0, NULL, 'Q', 0, 4, 0),
(5398, '2014 款', NULL, 1530, 0, NULL, 'Q', 0, 4, 0),
(5399, '2012 款', NULL, 1530, 0, NULL, 'Q', 0, 4, 0),
(5400, '2011 款', NULL, 1530, 0, NULL, 'Q', 0, 4, 0),
(5401, '2009 款', NULL, 1530, 0, NULL, 'Q', 0, 4, 0),
(5402, '2008 款', NULL, 1531, 0, NULL, 'Q', 0, 4, 0),
(5403, '2006 款', NULL, 1531, 0, NULL, 'Q', 0, 4, 0),
(5404, '2005 款', NULL, 1531, 0, NULL, 'Q', 0, 4, 0),
(5405, '2004 款', NULL, 1531, 0, NULL, 'Q', 0, 4, 0),
(5406, '2002 款', NULL, 1531, 0, NULL, 'Q', 0, 4, 0),
(5407, '2002 款', NULL, 1532, 0, NULL, 'Q', 0, 4, 0),
(5408, '2000 款', NULL, 1532, 0, NULL, 'Q', 0, 4, 0),
(5409, '2012 款', NULL, 1533, 0, NULL, 'Q', 0, 4, 0),
(5410, '2012 款', NULL, 1534, 0, NULL, 'Q', 0, 4, 0),
(5411, '2011 款', NULL, 1534, 0, NULL, 'Q', 0, 4, 0),
(5412, '2012 款', NULL, 1535, 0, NULL, 'Q', 0, 4, 0),
(5413, '2014 款', NULL, 1536, 0, NULL, 'Q', 0, 4, 0),
(5414, '2014 款', NULL, 1537, 0, NULL, 'Q', 0, 4, 0),
(5415, '2012 款', NULL, 1537, 0, NULL, 'Q', 0, 4, 0),
(5416, '2011 款', NULL, 1537, 0, NULL, 'Q', 0, 4, 0),
(5417, '2006 款', NULL, 1538, 0, NULL, 'Q', 0, 4, 0),
(5418, '2005 款', NULL, 1538, 0, NULL, 'Q', 0, 4, 0),
(5419, '2004 款', NULL, 1538, 0, NULL, 'Q', 0, 4, 0),
(5420, '2003 款', NULL, 1538, 0, NULL, 'Q', 0, 4, 0),
(5421, '2002 款', NULL, 1538, 0, NULL, 'Q', 0, 4, 0),
(5422, '2008 款', NULL, 1539, 0, NULL, 'Q', 0, 4, 0),
(5423, '2007 款', NULL, 1539, 0, NULL, 'Q', 0, 4, 0),
(5424, '2012 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5425, '2010 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5426, '2009 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5427, '2008 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5428, '2007 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5429, '2006 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5430, '2005 款', NULL, 1540, 0, NULL, 'Q', 0, 4, 0),
(5431, '2008 款', NULL, 1541, 0, NULL, 'Q', 0, 4, 0),
(5432, '2013 款', NULL, 1542, 0, NULL, 'Q', 0, 4, 0),
(5433, '2012 款', NULL, 1542, 0, NULL, 'Q', 0, 4, 0),
(5434, '2011 款', NULL, 1542, 0, NULL, 'Q', 0, 4, 0),
(5435, '2009 款', NULL, 1542, 0, NULL, 'Q', 0, 4, 0),
(5436, '2007 款', NULL, 1542, 0, NULL, 'Q', 0, 4, 0),
(5437, '2013 款', NULL, 1543, 0, NULL, 'Q', 0, 4, 0),
(5438, '2012 款', NULL, 1543, 0, NULL, 'Q', 0, 4, 0),
(5439, '2010 款', NULL, 1543, 0, NULL, 'Q', 0, 4, 0),
(5440, '2008 款', NULL, 1544, 0, NULL, 'Q', 0, 4, 0),
(5441, '2006 款', NULL, 1544, 0, NULL, 'Q', 0, 4, 0),
(5442, '2005 款', NULL, 1544, 0, NULL, 'Q', 0, 4, 0),
(5443, '2004 款', NULL, 1544, 0, NULL, 'Q', 0, 4, 0),
(5444, '2014 款', NULL, 1545, 0, NULL, 'Q', 0, 4, 0),
(5445, '2013 款', NULL, 1545, 0, NULL, 'Q', 0, 4, 0),
(5446, '2012 款', NULL, 1545, 0, NULL, 'Q', 0, 4, 0),
(5447, '2011 款', NULL, 1545, 0, NULL, 'Q', 0, 4, 0),
(5448, '2010 款', NULL, 1545, 0, NULL, 'Q', 0, 4, 0),
(5449, '2013 款', NULL, 1546, 0, NULL, 'Q', 0, 4, 0),
(5450, '2014 款', NULL, 1547, 0, NULL, 'Q', 0, 4, 0),
(5451, '2008 款', NULL, 1547, 0, NULL, 'Q', 0, 4, 0),
(5452, '2013 款', NULL, 1548, 0, NULL, 'Q', 0, 4, 0),
(5453, '2012 款', NULL, 1548, 0, NULL, 'Q', 0, 4, 0),
(5454, '2011 款', NULL, 1548, 0, NULL, 'Q', 0, 4, 0),
(5455, '2002 款', NULL, 1549, 0, NULL, 'Q', 0, 4, 0),
(5456, '1994 款', NULL, 1550, 0, NULL, 'Q', 0, 4, 0),
(5457, '2009 款', NULL, 1551, 0, NULL, 'Q', 0, 4, 0),
(5458, '2008 款', NULL, 1551, 0, NULL, 'Q', 0, 4, 0),
(5459, '2007 款', NULL, 1551, 0, NULL, 'Q', 0, 4, 0),
(5460, '2005 款', NULL, 1551, 0, NULL, 'Q', 0, 4, 0),
(5461, '2000 款', NULL, 1551, 0, NULL, 'Q', 0, 4, 0),
(5462, '2003 款', NULL, 1552, 0, NULL, 'Q', 0, 4, 0),
(5463, '2002 款', NULL, 1552, 0, NULL, 'Q', 0, 4, 0),
(5464, '2013 款', NULL, 1553, 0, NULL, 'Q', 0, 4, 0),
(5465, '2011 款', NULL, 1553, 0, NULL, 'Q', 0, 4, 0),
(5466, '2006 款', NULL, 1553, 0, NULL, 'Q', 0, 4, 0),
(5467, '2002 款', NULL, 1554, 0, NULL, 'Q', 0, 4, 0),
(5468, '2001 款', NULL, 1554, 0, NULL, 'Q', 0, 4, 0),
(5469, '1994 款', NULL, 1555, 0, NULL, 'Q', 0, 4, 0),
(5470, '2007 款', NULL, 1556, 0, NULL, 'Q', 0, 4, 0),
(5471, '2006 款', NULL, 1556, 0, NULL, 'Q', 0, 4, 0),
(5472, '2005 款', NULL, 1556, 0, NULL, 'Q', 0, 4, 0),
(5473, '2003 款', NULL, 1557, 0, NULL, 'Q', 0, 4, 0),
(5474, '2014 款', NULL, 1558, 0, NULL, 'Q', 0, 4, 0),
(5475, '2013 款', NULL, 1558, 0, NULL, 'Q', 0, 4, 0),
(5476, '2011 款', NULL, 1558, 0, NULL, 'Q', 0, 4, 0),
(5477, '2010 款', NULL, 1558, 0, NULL, 'Q', 0, 4, 0),
(5478, '2013 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5479, '2012 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5480, '2011 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5481, '2010 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5482, '2009 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5483, '2008 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5484, '2006 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5485, '2005 款', NULL, 1559, 0, NULL, 'Q', 0, 4, 0),
(5486, '2000 款', NULL, 1560, 0, NULL, 'Q', 0, 4, 0),
(5487, '2013 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5488, '2011 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5489, '2008 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5490, '2007 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5491, '2006 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5492, '2002 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5493, '2001 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5494, '2000 款', NULL, 1561, 0, NULL, 'Q', 0, 4, 0),
(5495, '2014 款', NULL, 1562, 0, NULL, 'Q', 0, 4, 0),
(5496, '2013 款', NULL, 1562, 0, NULL, 'Q', 0, 4, 0),
(5497, '2012 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5498, '2008 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5499, '2007 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5500, '2006 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5501, '2005 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5502, '2004 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5503, '2003 款', NULL, 1563, 0, NULL, 'Q', 0, 4, 0),
(5504, '2009 款', NULL, 1564, 0, NULL, 'Q', 0, 4, 0),
(5505, '2008 款', NULL, 1564, 0, NULL, 'Q', 0, 4, 0),
(5506, '2007 款', NULL, 1564, 0, NULL, 'Q', 0, 4, 0),
(5507, '2006 款', NULL, 1564, 0, NULL, 'Q', 0, 4, 0),
(5508, '2005 款', NULL, 1565, 0, NULL, 'Q', 0, 4, 0),
(5509, '2004 款', NULL, 1565, 0, NULL, 'Q', 0, 4, 0),
(5510, '2003 款', NULL, 1565, 0, NULL, 'Q', 0, 4, 0),
(5511, '2002 款', NULL, 1565, 0, NULL, 'Q', 0, 4, 0),
(5512, '2001 款', NULL, 1565, 0, NULL, 'Q', 0, 4, 0),
(5513, '2013 款', NULL, 1566, 0, NULL, 'Q', 0, 4, 0),
(5514, '2011 款', NULL, 1566, 0, NULL, 'Q', 0, 4, 0),
(5515, '2010 款', NULL, 1566, 0, NULL, 'Q', 0, 4, 0);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(5516, '2013 款', NULL, 1567, 0, NULL, 'Q', 0, 4, 0),
(5517, '2010 款', NULL, 1567, 0, NULL, 'Q', 0, 4, 0),
(5518, '2001 款', NULL, 1568, 0, NULL, 'Q', 0, 4, 0),
(5519, '2011 款', NULL, 1569, 0, NULL, 'Q', 0, 4, 0),
(5520, '2009 款', NULL, 1569, 0, NULL, 'Q', 0, 4, 0),
(5521, '2007 款', NULL, 1569, 0, NULL, 'Q', 0, 4, 0),
(5522, '2012 款', NULL, 1570, 0, NULL, 'Q', 0, 4, 0),
(5523, '2011 款', NULL, 1570, 0, NULL, 'Q', 0, 4, 0),
(5524, '2010 款', NULL, 1570, 0, NULL, 'Q', 0, 4, 0),
(5525, '2009 款', NULL, 1570, 0, NULL, 'Q', 0, 4, 0),
(5526, '2012 款', NULL, 1571, 0, NULL, 'Q', 0, 4, 0),
(5527, '2011 款', NULL, 1571, 0, NULL, 'Q', 0, 4, 0),
(5528, '2010 款', NULL, 1571, 0, NULL, 'Q', 0, 4, 0),
(5529, '2009 款', NULL, 1571, 0, NULL, 'Q', 0, 4, 0),
(5530, '2008 款', NULL, 1571, 0, NULL, 'Q', 0, 4, 0),
(5531, '2009 款', NULL, 1572, 0, NULL, 'Q', 0, 4, 0),
(5532, '2007 款', NULL, 1572, 0, NULL, 'Q', 0, 4, 0),
(5533, '2006 款', NULL, 1572, 0, NULL, 'Q', 0, 4, 0),
(5534, '2013 款', NULL, 1573, 0, NULL, 'Q', 0, 4, 0),
(5535, '2014 款', NULL, 1574, 0, NULL, 'Q', 0, 4, 0),
(5536, '2012 款', NULL, 1574, 0, NULL, 'Q', 0, 4, 0),
(5537, '2011 款', NULL, 1574, 0, NULL, 'Q', 0, 4, 0),
(5538, '2013 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5539, '2012 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5540, '2011 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5541, '2010 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5542, '2009 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5543, '2008 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5544, '2007 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5545, '2006 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5546, '2005 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5547, '2004 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5548, '2003 款', NULL, 1575, 0, NULL, 'Q', 0, 4, 0),
(5549, '2010 款', NULL, 1576, 0, NULL, 'Q', 0, 4, 0),
(5550, '2007 款', NULL, 1576, 0, NULL, 'Q', 0, 4, 0),
(5551, '2006 款', NULL, 1576, 0, NULL, 'Q', 0, 4, 0),
(5552, '2010 款', NULL, 1577, 0, NULL, 'Q', 0, 4, 0),
(5553, '2009 款', NULL, 1577, 0, NULL, 'Q', 0, 4, 0),
(5554, '2008 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5555, '2007 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5556, '2006 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5557, '2005 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5558, '2004 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5559, '2003 款', NULL, 1578, 0, NULL, 'Q', 0, 4, 0),
(5560, '2012 款', NULL, 1579, 0, NULL, 'Q', 0, 4, 0),
(5561, '2011 款', NULL, 1579, 0, NULL, 'Q', 0, 4, 0),
(5562, '2010 款', NULL, 1579, 0, NULL, 'Q', 0, 4, 0),
(5563, '2012 款', NULL, 1580, 0, NULL, 'Q', 0, 4, 0),
(5564, '2010 款', NULL, 1580, 0, NULL, 'Q', 0, 4, 0),
(5565, '2010 款', NULL, 1581, 0, NULL, 'Q', 0, 4, 0),
(5566, '2012 款', NULL, 1582, 0, NULL, 'Q', 0, 4, 0),
(5567, '2013 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5568, '2012 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5569, '2011 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5570, '2010 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5571, '2009 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5572, '2008 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5573, '2007 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5574, '2006 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5575, '2005 款', NULL, 1583, 0, NULL, 'Q', 0, 4, 0),
(5576, '2014 款', NULL, 1584, 0, NULL, 'Q', 0, 4, 0),
(5577, '2014 款', NULL, 1585, 0, NULL, 'Q', 0, 4, 0),
(5578, '2014 款', NULL, 1586, 0, NULL, 'Q', 0, 4, 0),
(5579, '2004 款', NULL, 1587, 0, NULL, 'Q', 0, 4, 0),
(5580, '2014 款', NULL, 1588, 0, NULL, 'Q', 0, 4, 0),
(5581, '2014 款', NULL, 1589, 0, NULL, 'Q', 0, 4, 0),
(5582, '2011 款', NULL, 1589, 0, NULL, 'Q', 0, 4, 0),
(5583, '2014 款', NULL, 1590, 0, NULL, 'Q', 0, 4, 0),
(5584, '2011 款', NULL, 1590, 0, NULL, 'Q', 0, 4, 0),
(5585, '其他', NULL, 1590, 0, NULL, 'Q', 0, 4, 0),
(5586, '2014 款', NULL, 1591, 0, NULL, 'Q', 0, 4, 0),
(5587, '2011 款', NULL, 1591, 0, NULL, 'Q', 0, 4, 0),
(5588, '其他', NULL, 1591, 0, NULL, 'Q', 0, 4, 0),
(5589, '2014 款', NULL, 1592, 0, NULL, 'Q', 0, 4, 0),
(5590, '2013 款', NULL, 1592, 0, NULL, 'Q', 0, 4, 0),
(5591, '2012 款', NULL, 1592, 0, NULL, 'Q', 0, 4, 0),
(5592, '2014 款', NULL, 1593, 0, NULL, 'Q', 0, 4, 0),
(5593, '2013 款', NULL, 1593, 0, NULL, 'Q', 0, 4, 0),
(5594, '2012 款', NULL, 1593, 0, NULL, 'Q', 0, 4, 0),
(5595, '2013 款', NULL, 1594, 0, NULL, 'Q', 0, 4, 0),
(5596, '2008 款', NULL, 1595, 0, NULL, 'R', 0, 4, 0),
(5597, '2007 款', NULL, 1595, 0, NULL, 'R', 0, 4, 0),
(5598, '2006 款', NULL, 1595, 0, NULL, 'R', 0, 4, 0),
(5599, '2005 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5600, '2004 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5601, '2003 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5602, '2002 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5603, '2001 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5604, '2000 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5605, '1999 款', NULL, 1596, 0, NULL, 'R', 0, 4, 0),
(5606, '2013 款', NULL, 1597, 0, NULL, 'R', 0, 4, 0),
(5607, '2010 款', NULL, 1597, 0, NULL, 'R', 0, 4, 0),
(5608, '2009 款', NULL, 1597, 0, NULL, 'R', 0, 4, 0),
(5609, '2008 款', NULL, 1597, 0, NULL, 'R', 0, 4, 0),
(5610, '2007 款', NULL, 1597, 0, NULL, 'R', 0, 4, 0),
(5611, '2013 款', NULL, 1598, 0, NULL, 'R', 0, 4, 0),
(5612, '2011 款', NULL, 1598, 0, NULL, 'R', 0, 4, 0),
(5613, '2011 款', NULL, 1599, 0, NULL, 'R', 0, 4, 0),
(5614, '2010 款', NULL, 1599, 0, NULL, 'R', 0, 4, 0),
(5615, '2014 款', NULL, 1600, 0, NULL, 'R', 0, 4, 0),
(5616, '2012 款', NULL, 1600, 0, NULL, 'R', 0, 4, 0),
(5617, '2010 款', NULL, 1600, 0, NULL, 'R', 0, 4, 0),
(5618, '2008 款', NULL, 1600, 0, NULL, 'R', 0, 4, 0),
(5619, '2012 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5620, '2011 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5621, '2009 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5622, '2008 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5623, '2007 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5624, '2006 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5625, '2005 款', NULL, 1601, 0, NULL, 'R', 0, 4, 0),
(5626, '2014 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5627, '2013 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5628, '2012 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5629, '2011 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5630, '2010 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5631, '2009 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5632, '2008 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5633, '2007 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5634, '2006 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5635, '2005 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5636, '2004 款', NULL, 1602, 0, NULL, 'R', 0, 4, 0),
(5637, '2012 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5638, '2011 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5639, '2010 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5640, '2009 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5641, '2008 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5642, '2007 款', NULL, 1603, 0, NULL, 'R', 0, 4, 0),
(5643, '2014 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5644, '2012 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5645, '2009 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5646, '2008 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5647, '2007 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5648, '2006 款', NULL, 1604, 0, NULL, 'R', 0, 4, 0),
(5649, '2014 款', NULL, 1605, 0, NULL, 'R', 0, 4, 0),
(5650, '2011 款', NULL, 1605, 0, NULL, 'R', 0, 4, 0),
(5651, '2005 款', NULL, 1605, 0, NULL, 'R', 0, 4, 0),
(5652, '2004 款', NULL, 1605, 0, NULL, 'R', 0, 4, 0),
(5653, '2002 款', NULL, 1605, 0, NULL, 'R', 0, 4, 0),
(5654, '2009 款', NULL, 1606, 0, NULL, 'R', 0, 4, 0),
(5655, '2008 款', NULL, 1606, 0, NULL, 'R', 0, 4, 0),
(5656, '2006 款', NULL, 1606, 0, NULL, 'R', 0, 4, 0),
(5657, '2005 款', NULL, 1606, 0, NULL, 'R', 0, 4, 0),
(5658, '2013 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5659, '2012 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5660, '2010 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5661, '2009 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5662, '2008 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5663, '2007 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5664, '2006 款', NULL, 1607, 0, NULL, 'R', 0, 4, 0),
(5665, '2008 款', NULL, 1608, 0, NULL, 'R', 0, 4, 0),
(5666, '2002 款', NULL, 1608, 0, NULL, 'R', 0, 4, 0),
(5667, '2013 款', NULL, 1609, 0, NULL, 'R', 0, 4, 0),
(5668, '2010 款', NULL, 1609, 0, NULL, 'R', 0, 4, 0),
(5669, '2009 款', NULL, 1609, 0, NULL, 'R', 0, 4, 0),
(5670, '2013 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5671, '2009 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5672, '2008 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5673, '2007 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5674, '2006 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5675, '2003 款', NULL, 1610, 0, NULL, 'R', 0, 4, 0),
(5676, '2009 款', NULL, 1611, 0, NULL, 'R', 0, 4, 0),
(5677, '2013 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5678, '2009 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5679, '2008 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5680, '2007 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5681, '2002 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5682, '2000 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5683, '1999 款', NULL, 1612, 0, NULL, 'R', 0, 4, 0),
(5684, '2014 款', NULL, 1613, 0, NULL, 'R', 0, 4, 0),
(5685, '2013 款', NULL, 1613, 0, NULL, 'R', 0, 4, 0),
(5686, '2012 款', NULL, 1613, 0, NULL, 'R', 0, 4, 0),
(5687, '2011 款', NULL, 1613, 0, NULL, 'R', 0, 4, 0),
(5688, '2010 款', NULL, 1613, 0, NULL, 'R', 0, 4, 0),
(5689, '2013 款', NULL, 1614, 0, NULL, 'R', 0, 4, 0),
(5690, '2011 款', NULL, 1614, 0, NULL, 'R', 0, 4, 0),
(5691, '2010 款', NULL, 1614, 0, NULL, 'R', 0, 4, 0),
(5692, '2007 款', NULL, 1614, 0, NULL, 'R', 0, 4, 0),
(5693, '1991 款', NULL, 1615, 0, NULL, 'R', 0, 4, 0),
(5694, '1986 款', NULL, 1615, 0, NULL, 'R', 0, 4, 0),
(5695, '2013 款', NULL, 1616, 0, NULL, 'R', 0, 4, 0),
(5696, '2012 款', NULL, 1616, 0, NULL, 'R', 0, 4, 0),
(5697, '2011 款', NULL, 1616, 0, NULL, 'R', 0, 4, 0),
(5698, '2005 款', NULL, 1616, 0, NULL, 'R', 0, 4, 0),
(5699, '2003 款', NULL, 1617, 0, NULL, 'R', 0, 4, 0),
(5700, '2002 款', NULL, 1617, 0, NULL, 'R', 0, 4, 0),
(5701, '1994 款', NULL, 1617, 0, NULL, 'R', 0, 4, 0),
(5702, '1986 款', NULL, 1617, 0, NULL, 'R', 0, 4, 0),
(5703, '其他', NULL, 1618, 0, NULL, 'R', 0, 4, 0),
(5704, '2006 款', NULL, 1619, 0, NULL, 'R', 0, 4, 0),
(5705, '2013 款', NULL, 1620, 0, NULL, 'R', 0, 4, 0),
(5706, '2015 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5707, '2014 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5708, '2013 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5709, '2012 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5710, '2011 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5711, '2010 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5712, '2008 款', NULL, 1621, 0, NULL, 'R', 0, 4, 0),
(5713, '2005 款', NULL, 1622, 0, NULL, 'R', 0, 4, 0),
(5714, '2004 款', NULL, 1622, 0, NULL, 'R', 0, 4, 0),
(5715, '2002 款', NULL, 1622, 0, NULL, 'R', 0, 4, 0),
(5716, '2005 款', NULL, 1623, 0, NULL, 'R', 0, 4, 0),
(5717, '2006 款', NULL, 1624, 0, NULL, 'R', 0, 4, 0),
(5718, '2006 款', NULL, 1625, 0, NULL, 'R', 0, 4, 0),
(5719, '2014 款', NULL, 1626, 0, NULL, 'R', 0, 4, 0),
(5720, '2011 款', NULL, 1626, 0, NULL, 'R', 0, 4, 0),
(5721, '2006 款', NULL, 1626, 0, NULL, 'R', 0, 4, 0),
(5722, '2000 款', NULL, 1626, 0, NULL, 'R', 0, 4, 0),
(5723, '1992 款', NULL, 1627, 0, NULL, 'R', 0, 4, 0),
(5724, '1997 款', NULL, 1628, 0, NULL, 'R', 0, 4, 0),
(5725, '2014 款', NULL, 1629, 0, NULL, 'R', 0, 4, 0),
(5726, '2013 款', NULL, 1629, 0, NULL, 'R', 0, 4, 0),
(5727, '2012 款', NULL, 1629, 0, NULL, 'R', 0, 4, 0),
(5728, '2011 款', NULL, 1629, 0, NULL, 'R', 0, 4, 0),
(5729, '2010 款', NULL, 1629, 0, NULL, 'R', 0, 4, 0),
(5730, '2014 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5731, '2013 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5732, '2012 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5733, '2010 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5734, '2009 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5735, '2008 款', NULL, 1630, 0, NULL, 'R', 0, 4, 0),
(5736, '2011 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5737, '2010 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5738, '2009 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5739, '2008 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5740, '2007 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5741, '2006 款', NULL, 1631, 0, NULL, 'R', 0, 4, 0),
(5742, '2012 款', NULL, 1632, 0, NULL, 'R', 0, 4, 0),
(5743, '2013 款', NULL, 1633, 0, NULL, 'R', 0, 4, 0),
(5744, '2014 款', NULL, 1634, 0, NULL, 'R', 0, 4, 0),
(5745, '2013 款', NULL, 1634, 0, NULL, 'R', 0, 4, 0),
(5746, '2011 款', NULL, 1634, 0, NULL, 'R', 0, 4, 0),
(5747, '2007 款', NULL, 1635, 0, NULL, 'R', 0, 4, 0),
(5748, '2012 款', NULL, 1636, 0, NULL, 'R', 0, 4, 0),
(5749, '2012 款', NULL, 1637, 0, NULL, 'R', 0, 4, 0),
(5750, '2011 款', NULL, 1637, 0, NULL, 'R', 0, 4, 0),
(5751, '2010 款', NULL, 1637, 0, NULL, 'R', 0, 4, 0),
(5752, '2011 款', NULL, 1638, 0, NULL, 'R', 0, 4, 0),
(5753, '2013 款', NULL, 1639, 0, NULL, 'R', 0, 4, 0),
(5754, '2011 款', NULL, 1639, 0, NULL, 'R', 0, 4, 0),
(5755, '2010 款', NULL, 1639, 0, NULL, 'R', 0, 4, 0),
(5756, '2009 款', NULL, 1639, 0, NULL, 'R', 0, 4, 0),
(5757, '2010 款', NULL, 1640, 0, NULL, 'R', 0, 4, 0),
(5758, '2012 款', NULL, 1641, 0, NULL, 'R', 0, 4, 0),
(5759, '2011 款', NULL, 1641, 0, NULL, 'R', 0, 4, 0),
(5760, '2010 款', NULL, 1641, 0, NULL, 'R', 0, 4, 0),
(5761, '2013 款', NULL, 1642, 0, NULL, 'S', 0, 4, 0),
(5762, '2012 款', NULL, 1642, 0, NULL, 'S', 0, 4, 0),
(5763, '2010 款', NULL, 1642, 0, NULL, 'S', 0, 4, 0),
(5764, '2009 款', NULL, 1642, 0, NULL, 'S', 0, 4, 0),
(5765, '2014 款', NULL, 1643, 0, NULL, 'S', 0, 4, 0),
(5766, '2012 款', NULL, 1643, 0, NULL, 'S', 0, 4, 0),
(5767, '2011 款', NULL, 1643, 0, NULL, 'S', 0, 4, 0),
(5768, '2009 款', NULL, 1643, 0, NULL, 'S', 0, 4, 0),
(5769, '2008 款', NULL, 1643, 0, NULL, 'S', 0, 4, 0),
(5770, '2015 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5771, '2014 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5772, '2013 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5773, '2012 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5774, '2010 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5775, '2009 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5776, '2008 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5777, '2007 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5778, '2006 款', NULL, 1644, 0, NULL, 'S', 0, 4, 0),
(5779, '2010 款', NULL, 1645, 0, NULL, 'S', 0, 4, 0),
(5780, '2013 款', NULL, 1646, 0, NULL, 'S', 0, 4, 0),
(5781, '2014 款', NULL, 1647, 0, NULL, 'S', 0, 4, 0),
(5782, '2013 款', NULL, 1648, 0, NULL, 'S', 0, 4, 0),
(5783, '2014 款', NULL, 1649, 0, NULL, 'S', 0, 4, 0),
(5784, '2013 款', NULL, 1650, 0, NULL, 'S', 0, 4, 0),
(5785, '2002 款', NULL, 1651, 0, NULL, 'S', 0, 4, 0),
(5786, '2001 款', NULL, 1651, 0, NULL, 'S', 0, 4, 0),
(5787, '2013 款', NULL, 1652, 0, NULL, 'S', 0, 4, 0),
(5788, '2004 款', NULL, 1653, 0, NULL, 'S', 0, 4, 0),
(5789, '2014 款', NULL, 1654, 0, NULL, 'S', 0, 4, 0),
(5790, '2006 款', NULL, 1655, 0, NULL, 'S', 0, 4, 0),
(5791, '2005 款', NULL, 1655, 0, NULL, 'S', 0, 4, 0),
(5792, '2004 款', NULL, 1655, 0, NULL, 'S', 0, 4, 0),
(5793, '2003 款', NULL, 1655, 0, NULL, 'S', 0, 4, 0),
(5794, '2003 款', NULL, 1656, 0, NULL, 'S', 0, 4, 0),
(5795, '2013 款', NULL, 1657, 0, NULL, 'S', 0, 4, 0),
(5796, '2012 款', NULL, 1658, 0, NULL, 'S', 0, 4, 0),
(5797, '2009 款', NULL, 1658, 0, NULL, 'S', 0, 4, 0),
(5798, '2007 款', NULL, 1658, 0, NULL, 'S', 0, 4, 0),
(5799, '2006 款', NULL, 1658, 0, NULL, 'S', 0, 4, 0),
(5800, '2011 款', NULL, 1659, 0, NULL, 'S', 0, 4, 0),
(5801, '2010 款', NULL, 1659, 0, NULL, 'S', 0, 4, 0),
(5802, '2009 款', NULL, 1659, 0, NULL, 'S', 0, 4, 0),
(5803, '2008 款', NULL, 1659, 0, NULL, 'S', 0, 4, 0),
(5804, '2014 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5805, '2012 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5806, '2010 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5807, '2008 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5808, '2007 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5809, '2006 款', NULL, 1660, 0, NULL, 'S', 0, 4, 0),
(5810, '2007 款', NULL, 1661, 0, NULL, 'S', 0, 4, 0),
(5811, '2006 款', NULL, 1661, 0, NULL, 'S', 0, 4, 0),
(5812, '2005 款', NULL, 1661, 0, NULL, 'S', 0, 4, 0),
(5813, '2004 款', NULL, 1661, 0, NULL, 'S', 0, 4, 0),
(5814, '2014 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5815, '2013 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5816, '2012 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5817, '2011 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5818, '2010 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5819, '2009 款', NULL, 1662, 0, NULL, 'S', 0, 4, 0),
(5820, '2011 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5821, '2008 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5822, '2007 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5823, '2006 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5824, '2005 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5825, '2004 款', NULL, 1663, 0, NULL, 'S', 0, 4, 0),
(5826, '2014 款', NULL, 1664, 0, NULL, 'S', 0, 4, 0),
(5827, '2013 款', NULL, 1664, 0, NULL, 'S', 0, 4, 0),
(5828, '2013 款', NULL, 1665, 0, NULL, 'S', 0, 4, 0),
(5829, '1997 款', NULL, 1666, 0, NULL, 'S', 0, 4, 0),
(5830, '2010 款', NULL, 1667, 0, NULL, 'S', 0, 4, 0),
(5831, '2007 款', NULL, 1667, 0, NULL, 'S', 0, 4, 0),
(5832, '2004 款', NULL, 1667, 0, NULL, 'S', 0, 4, 0),
(5833, '2012 款', NULL, 1668, 0, NULL, 'S', 0, 4, 0),
(5834, '2011 款', NULL, 1668, 0, NULL, 'S', 0, 4, 0),
(5835, '2008 款', NULL, 1669, 0, NULL, 'S', 0, 4, 0),
(5836, '2008 款', NULL, 1670, 0, NULL, 'S', 0, 4, 0),
(5837, '2006 款', NULL, 1670, 0, NULL, 'S', 0, 4, 0),
(5838, '2004 款', NULL, 1671, 0, NULL, 'S', 0, 4, 0),
(5839, '1996 款', NULL, 1671, 0, NULL, 'S', 0, 4, 0),
(5840, '2013 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5841, '2012 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5842, '2011 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5843, '2010 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5844, '2009 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5845, '2007 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5846, '2006 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5847, '2005 款', NULL, 1672, 0, NULL, 'S', 0, 4, 0),
(5848, '2014 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5849, '2012 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5850, '2011 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5851, '2010 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5852, '2009 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5853, '2006 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5854, '2005 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5855, '2004 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5856, '2003 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5857, '2001 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5858, '1993 款', NULL, 1673, 0, NULL, 'S', 0, 4, 0),
(5859, '2011 款', NULL, 1674, 0, NULL, 'S', 0, 4, 0),
(5860, '2003 款', NULL, 1674, 0, NULL, 'S', 0, 4, 0),
(5861, '2008 款', NULL, 1675, 0, NULL, 'S', 0, 4, 0),
(5862, '2006 款', NULL, 1675, 0, NULL, 'S', 0, 4, 0),
(5863, '1997 款', NULL, 1675, 0, NULL, 'S', 0, 4, 0),
(5864, '2005 款', NULL, 1676, 0, NULL, 'S', 0, 4, 0),
(5865, '2004 款', NULL, 1676, 0, NULL, 'S', 0, 4, 0),
(5866, '2003 款', NULL, 1676, 0, NULL, 'S', 0, 4, 0),
(5867, '2003 款', NULL, 1677, 0, NULL, 'S', 0, 4, 0),
(5868, '2011 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5869, '2010 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5870, '2009 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5871, '2007 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5872, '2005 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5873, '2004 款', NULL, 1678, 0, NULL, 'S', 0, 4, 0),
(5874, '2009 款', NULL, 1679, 0, NULL, 'S', 0, 4, 0),
(5875, '2008 款', NULL, 1679, 0, NULL, 'S', 0, 4, 0),
(5876, '2007 款', NULL, 1679, 0, NULL, 'S', 0, 4, 0),
(5877, '2005 款', NULL, 1680, 0, NULL, 'S', 0, 4, 0),
(5878, '2014 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5879, '2013 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5880, '2012 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5881, '2011 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5882, '2010 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5883, '2009 款', NULL, 1681, 0, NULL, 's', 0, 4, 0),
(5884, '2004 款', NULL, 1682, 0, NULL, 's', 0, 4, 0),
(5885, '1998 款', NULL, 1683, 0, NULL, 's', 0, 4, 0),
(5886, '2001 款', NULL, 1684, 0, NULL, 'S', 0, 4, 0),
(5887, '2014 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5888, '2013 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5889, '2011 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5890, '2010 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5891, '2009 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5892, '2008 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5893, '2006 款', NULL, 1685, 0, NULL, 'S', 0, 4, 0),
(5894, '2014 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5895, '2013 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5896, '2011 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5897, '2005 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5898, '2000 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5899, '1997 款', NULL, 1686, 0, NULL, 'S', 0, 4, 0),
(5900, '2007 款', NULL, 1687, 0, NULL, 'S', 0, 4, 0),
(5901, '2004 款', NULL, 1687, 0, NULL, 'S', 0, 4, 0),
(5902, '2002 款', NULL, 1687, 0, NULL, 'S', 0, 4, 0),
(5903, '2011 款', NULL, 1688, 0, NULL, 'S', 0, 4, 0),
(5904, '2010 款', NULL, 1688, 0, NULL, 'S', 0, 4, 0),
(5905, '2008 款', NULL, 1688, 0, NULL, 'S', 0, 4, 0),
(5906, '2007 款', NULL, 1688, 0, NULL, 'S', 0, 4, 0),
(5907, '2006 款', NULL, 1688, 0, NULL, 'S', 0, 4, 0),
(5908, '2014 款', NULL, 1689, 0, NULL, 'S', 0, 4, 0),
(5909, '2014 款', NULL, 1690, 0, NULL, 'S', 0, 4, 0),
(5910, '2008 款', NULL, 1690, 0, NULL, 'S', 0, 4, 0),
(5911, '2007 款', NULL, 1690, 0, NULL, 'S', 0, 4, 0),
(5912, '2005 款', NULL, 1690, 0, NULL, 'S', 0, 4, 0),
(5913, '2013 款', NULL, 1691, 0, NULL, 'S', 0, 4, 0),
(5914, '2011 款', NULL, 1691, 0, NULL, 'S', 0, 4, 0),
(5915, '2010 款', NULL, 1691, 0, NULL, 'S', 0, 4, 0),
(5916, '2007 款', NULL, 1691, 0, NULL, 'S', 0, 4, 0),
(5917, '2013 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5918, '2012 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5919, '2007 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5920, '2005 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5921, '2004 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5922, '2002 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5923, '1998 款', NULL, 1692, 0, NULL, 'S', 0, 4, 0),
(5924, '1996 款', NULL, 1693, 0, NULL, 'S', 0, 4, 0),
(5925, '1995 款', NULL, 1693, 0, NULL, 'S', 0, 4, 0),
(5926, '2007 款', NULL, 1694, 0, NULL, 'S', 0, 4, 0),
(5927, '2005 款', NULL, 1694, 0, NULL, 'S', 0, 4, 0),
(5928, '2006 款', NULL, 1695, 0, NULL, 'S', 0, 4, 0),
(5929, '2003 款', NULL, 1695, 0, NULL, 'S', 0, 4, 0),
(5930, '2000 款', NULL, 1695, 0, NULL, 'S', 0, 4, 0),
(5931, '2014 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5932, '2013 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5933, '2012 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5934, '2011 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5935, '2010 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5936, '2008 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5937, '2006 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5938, '2005 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5939, '2004 款', NULL, 1696, 0, NULL, 'S', 0, 4, 0),
(5940, '2011 款', NULL, 1697, 0, NULL, 'S', 0, 4, 0),
(5941, '2008 款', NULL, 1697, 0, NULL, 'S', 0, 4, 0),
(5942, '2006 款', NULL, 1697, 0, NULL, 'S', 0, 4, 0),
(5943, '2014 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5944, '2013 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5945, '2011 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5946, '2010 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5947, '2008 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5948, '2007 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5949, '2006 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5950, '2005 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5951, '2004 款', NULL, 1698, 0, NULL, 'S', 0, 4, 0),
(5952, '2014 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5953, '2013 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5954, '2012 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5955, '2011 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5956, '2010 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5957, '2009 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5958, '2008 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5959, '2007 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5960, '2006 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5961, '2004 款', NULL, 1699, 0, NULL, 'S', 0, 4, 0),
(5962, '2014 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5963, '2012 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5964, '2011 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5965, '2009 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5966, '2008 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5967, '2004 款', NULL, 1700, 0, NULL, 'S', 0, 4, 0),
(5968, '2013 款', NULL, 1701, 0, NULL, 'S', 0, 4, 0),
(5969, '2014 款', NULL, 1702, 0, NULL, 'S', 0, 4, 0),
(5970, '2012 款', NULL, 1702, 0, NULL, 'S', 0, 4, 0),
(5971, '2010 款', NULL, 1703, 0, NULL, 'S', 0, 4, 0),
(5972, '2008 款', NULL, 1703, 0, NULL, 'S', 0, 4, 0),
(5973, '2007 款', NULL, 1703, 0, NULL, 'S', 0, 4, 0),
(5974, '2006 款', NULL, 1703, 0, NULL, 'S', 0, 4, 0),
(5975, '2004 款', NULL, 1703, 0, NULL, 'S', 0, 4, 0),
(5976, '1994 款', NULL, 1704, 0, NULL, 'S', 0, 4, 0),
(5977, '2010 款', NULL, 1705, 0, NULL, 'S', 0, 4, 0),
(5978, '2009 款', NULL, 1705, 0, NULL, 'S', 0, 4, 0),
(5979, '2014 款', NULL, 1706, 0, NULL, 'S', 0, 4, 0),
(5980, '2014 款', NULL, 1707, 0, NULL, 'S', 0, 4, 0),
(5981, '2013 款', NULL, 1707, 0, NULL, 'S', 0, 4, 0),
(5982, '2012 款', NULL, 1707, 0, NULL, 'S', 0, 4, 0),
(5983, '2011 款', NULL, 1707, 0, NULL, 'S', 0, 4, 0),
(5984, '2013 款', NULL, 1708, 0, NULL, 'S', 0, 4, 0),
(5985, '2011 款', NULL, 1708, 0, NULL, 'S', 0, 4, 0),
(5986, '2014 款', NULL, 1709, 0, NULL, 'S', 0, 4, 0),
(5987, '2014 款', NULL, 1710, 0, NULL, 'S', 0, 4, 0),
(5988, '2014 款', NULL, 1711, 0, NULL, 'S', 0, 4, 0),
(5989, '2013 款', NULL, 1712, 0, NULL, 'S', 0, 4, 0),
(5990, '2014 款', NULL, 1713, 0, NULL, 'S', 0, 4, 0),
(5991, '2014 款', NULL, 1714, 0, NULL, 'S', 0, 4, 0),
(5992, '2014 款', NULL, 1715, 0, NULL, 'S', 0, 4, 0),
(5993, '2005 款', NULL, 1716, 0, NULL, 'T', 0, 4, 0),
(5994, '其他', NULL, 1717, 0, NULL, 'T', 0, 4, 0),
(5995, '2003 款', NULL, 1718, 0, NULL, 'T', 0, 4, 0),
(5996, '2005 款', NULL, 1719, 0, NULL, 'T', 0, 4, 0),
(5997, '2004 款', NULL, 1720, 0, NULL, 'T', 0, 4, 0),
(5998, '2009 款', NULL, 1721, 0, NULL, 'T', 0, 4, 0),
(5999, '2005 款', NULL, 1722, 0, NULL, 'T', 0, 4, 0),
(6000, '2003 款', NULL, 1723, 0, NULL, 'T', 0, 4, 0),
(6001, '2002 款', NULL, 1723, 0, NULL, 'T', 0, 4, 0),
(6002, '1999 款', NULL, 1724, 0, NULL, 'T', 0, 4, 0),
(6003, '1995 款', NULL, 1724, 0, NULL, 'T', 0, 4, 0),
(6004, '2014 款', NULL, 1725, 0, NULL, 'T', 0, 4, 0),
(6005, '2014 款', NULL, 1726, 0, NULL, 'T', 0, 4, 0),
(6006, '2014 款', NULL, 1727, 0, NULL, 'T', 0, 4, 0),
(6007, '2014 款', NULL, 1728, 0, NULL, 'T', 0, 4, 0),
(6008, '2014 款', NULL, 1729, 0, NULL, 'T', 0, 4, 0),
(6009, '2014 款', NULL, 1730, 0, NULL, 'T', 0, 4, 0),
(6010, '2013 款', NULL, 1730, 0, NULL, 'T', 0, 4, 0),
(6011, '2014 款', NULL, 1731, 0, NULL, 'T', 0, 4, 0),
(6012, '2013 款', NULL, 1731, 0, NULL, 'T', 0, 4, 0),
(6013, '2012 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6014, '2011 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6015, '2010 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6016, '2009 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6017, '2008 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6018, '2007 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6019, '2006 款', NULL, 1732, 0, NULL, 'W', 0, 4, 0),
(6020, '2014 款', NULL, 1733, 0, NULL, 'W', 0, 4, 0),
(6021, '2012 款', NULL, 1733, 0, NULL, 'W', 0, 4, 0),
(6022, '2011 款', NULL, 1733, 0, NULL, 'W', 0, 4, 0),
(6023, '2010 款', NULL, 1733, 0, NULL, 'W', 0, 4, 0),
(6024, '2009 款', NULL, 1733, 0, NULL, 'W', 0, 4, 0),
(6025, '2015 款', NULL, 1734, 0, NULL, 'W', 0, 4, 0),
(6026, '2014 款', NULL, 1734, 0, NULL, 'W', 0, 4, 0),
(6027, '2006 款', NULL, 1735, 0, NULL, 'W', 0, 4, 0),
(6028, '1998 款', NULL, 1736, 0, NULL, 'W', 0, 4, 0),
(6029, '2002 款', NULL, 1737, 0, NULL, 'W', 0, 4, 0),
(6030, '2012 款', NULL, 1738, 0, NULL, 'W', 0, 4, 0),
(6031, '2010 款', NULL, 1738, 0, NULL, 'W', 0, 4, 0),
(6032, '2008 款', NULL, 1738, 0, NULL, 'W', 0, 4, 0),
(6033, '2013 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6034, '2012 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6035, '2011 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6036, '2010 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6037, '2008 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6038, '2007 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6039, '2006 款', NULL, 1739, 0, NULL, 'W', 0, 4, 0),
(6040, '2014 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6041, '2013 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6042, '2012 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6043, '2011 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6044, '2003 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6045, '2000 款', NULL, 1740, 0, NULL, 'W', 0, 4, 0),
(6046, '2008 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6047, '2007 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6048, '2006 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6049, '2005 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6050, '2004 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6051, '2002 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6052, '1998 款', NULL, 1741, 0, NULL, 'W', 0, 4, 0),
(6053, '2014 款', NULL, 1742, 0, NULL, 'W', 0, 4, 0),
(6054, '2014 款', NULL, 1743, 0, NULL, 'W', 0, 4, 0),
(6055, '2013 款', NULL, 1743, 0, NULL, 'W', 0, 4, 0),
(6056, '2014 款', NULL, 1744, 0, NULL, 'W', 0, 4, 0),
(6057, '2013 款', NULL, 1744, 0, NULL, 'W', 0, 4, 0),
(6058, '2012 款', NULL, 1744, 0, NULL, 'W', 0, 4, 0),
(6059, '2002 款', NULL, 1745, 0, NULL, 'W', 0, 4, 0),
(6060, '2014 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6061, '2013 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6062, '2012 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6063, '2011 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6064, '2010 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6065, '2009 款', NULL, 1746, 0, NULL, 'W', 0, 4, 0),
(6066, '2013 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6067, '2012 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6068, '2011 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6069, '2010 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6070, '2008 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6071, '2006 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6072, '2005 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6073, '2004 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6074, '2003 款', NULL, 1747, 0, NULL, 'W', 0, 4, 0),
(6075, '2004 款', NULL, 1748, 0, NULL, 'W', 0, 4, 0),
(6076, '2003 款', NULL, 1748, 0, NULL, 'W', 0, 4, 0),
(6077, '2004 款', NULL, 1749, 0, NULL, 'W', 0, 4, 0),
(6078, '2003 款', NULL, 1749, 0, NULL, 'W', 0, 4, 0),
(6079, '2002 款', NULL, 1749, 0, NULL, 'W', 0, 4, 0),
(6080, '2002 款', NULL, 1750, 0, NULL, 'W', 0, 4, 0),
(6081, '2002 款', NULL, 1751, 0, NULL, 'W', 0, 4, 0),
(6082, '2005 款', NULL, 1752, 0, NULL, 'W', 0, 4, 0),
(6083, '2003 款', NULL, 1753, 0, NULL, 'W', 0, 4, 0),
(6084, '1997 款', NULL, 1753, 0, NULL, 'W', 0, 4, 0),
(6085, '1993 款', NULL, 1753, 0, NULL, 'W', 0, 4, 0),
(6086, '2010 款', NULL, 1754, 0, NULL, 'W', 0, 4, 0),
(6087, '2008 款', NULL, 1754, 0, NULL, 'W', 0, 4, 0),
(6088, '2013 款', NULL, 1755, 0, NULL, 'W', 0, 4, 0),
(6089, '2012 款', NULL, 1755, 0, NULL, 'W', 0, 4, 0),
(6090, '2010 款', NULL, 1755, 0, NULL, 'W', 0, 4, 0),
(6091, '2013 款', NULL, 1756, 0, NULL, 'W', 0, 4, 0),
(6092, '2009 款', NULL, 1757, 0, NULL, 'W', 0, 4, 0),
(6093, '2008 款', NULL, 1757, 0, NULL, 'W', 0, 4, 0),
(6094, '2007 款', NULL, 1757, 0, NULL, 'W', 0, 4, 0),
(6095, '2006 款', NULL, 1757, 0, NULL, 'W', 0, 4, 0),
(6096, '2014 款', NULL, 1758, 0, NULL, 'W', 0, 4, 0),
(6097, '2012 款', NULL, 1758, 0, NULL, 'W', 0, 4, 0),
(6098, '2011 款', NULL, 1758, 0, NULL, 'W', 0, 4, 0),
(6099, '2009 款', NULL, 1758, 0, NULL, 'W', 0, 4, 0),
(6100, '2008 款', NULL, 1758, 0, NULL, 'W', 0, 4, 0),
(6101, '2008 款', NULL, 1759, 0, NULL, 'W', 0, 4, 0),
(6102, '2006 款', NULL, 1759, 0, NULL, 'W', 0, 4, 0),
(6103, '2000 款', NULL, 1759, 0, NULL, 'W', 0, 4, 0),
(6104, '2009 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6105, '2008 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6106, '2007 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6107, '2006 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6108, '2005 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6109, '2003 款', NULL, 1760, 0, NULL, 'W', 0, 4, 0),
(6110, '2009 款', NULL, 1761, 0, NULL, 'W', 0, 4, 0),
(6111, '2008 款', NULL, 1761, 0, NULL, 'W', 0, 4, 0),
(6112, '2007 款', NULL, 1761, 0, NULL, 'W', 0, 4, 0),
(6113, '2006 款', NULL, 1761, 0, NULL, 'W', 0, 4, 0),
(6114, '2004 款', NULL, 1761, 0, NULL, 'W', 0, 4, 0),
(6115, '2014 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6116, '2013 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6117, '2010 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6118, '2009 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6119, '2008 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6120, '2007 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6121, '2006 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6122, '2005 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6123, '2004 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6124, '2003 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6125, '1999 款', NULL, 1762, 0, NULL, 'W', 0, 4, 0),
(6126, '2001 款', NULL, 1763, 0, NULL, 'W', 0, 4, 0),
(6127, '2001 款', NULL, 1763, 0, NULL, 'W', 0, 4, 0),
(6128, '2001 款', NULL, 1764, 0, NULL, 'W', 0, 4, 0),
(6129, '2000 款', NULL, 1764, 0, NULL, 'W', 0, 4, 0),
(6130, '1994 款', NULL, 1765, 0, NULL, 'W', 0, 4, 0),
(6131, '2011 款', NULL, 1766, 0, NULL, 'W', 0, 4, 0),
(6132, '2012 款', NULL, 1767, 0, NULL, 'W', 0, 4, 0),
(6133, '2010 款', NULL, 1767, 0, NULL, 'W', 0, 4, 0),
(6134, '其他', NULL, 1767, 0, NULL, 'W', 0, 4, 0),
(6135, '2012 款', NULL, 1768, 0, NULL, 'W', 0, 4, 0),
(6136, '2010 款', NULL, 1768, 0, NULL, 'W', 0, 4, 0),
(6137, '2009 款', NULL, 1768, 0, NULL, 'W', 0, 4, 0),
(6138, '2007 款', NULL, 1768, 0, NULL, 'W', 0, 4, 0),
(6139, '2006 款', NULL, 1768, 0, NULL, 'W', 0, 4, 0),
(6140, '2012 款', NULL, 1769, 0, NULL, 'W', 0, 4, 0),
(6141, '2010 款', NULL, 1769, 0, NULL, 'W', 0, 4, 0),
(6142, '2012 款', NULL, 1770, 0, NULL, 'W', 0, 4, 0),
(6143, '2012 款', NULL, 1771, 0, NULL, 'W', 0, 4, 0),
(6144, '2008 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6145, '2007 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6146, '2005 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6147, '2004 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6148, '2003 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6149, '2002 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6150, '2001 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6151, '2000 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6152, '1999 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6153, '1998 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6154, '1997 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6155, '1996 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6156, '1995 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6157, '1993 款', NULL, 1772, 0, NULL, 'X', 0, 4, 0),
(6158, '2011 款', NULL, 1773, 0, NULL, 'X', 0, 4, 0),
(6159, '2009 款', NULL, 1773, 0, NULL, 'X', 0, 4, 0),
(6160, '2013 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6161, '2012 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6162, '2011 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6163, '2010 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6164, '2009 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6165, '2008 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6166, '2007 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6167, '2006 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6168, '2005 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6169, '2004 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6170, '2003 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6171, '2002 款', NULL, 1774, 0, NULL, 'X', 0, 4, 0),
(6172, '2010 款', NULL, 1775, 0, NULL, 'X', 0, 4, 0),
(6173, '2008 款', NULL, 1775, 0, NULL, 'X', 0, 4, 0),
(6174, '2007 款', NULL, 1775, 0, NULL, 'X', 0, 4, 0),
(6175, '2006 款', NULL, 1775, 0, NULL, 'X', 0, 4, 0),
(6176, '2014 款', NULL, 1776, 0, NULL, 'X', 0, 4, 0),
(6177, '2007 款', NULL, 1777, 0, NULL, 'X', 0, 4, 0),
(6178, '2004 款', NULL, 1777, 0, NULL, 'X', 0, 4, 0),
(6179, '2003 款', NULL, 1777, 0, NULL, 'X', 0, 4, 0),
(6180, '2002 款', NULL, 1777, 0, NULL, 'X', 0, 4, 0),
(6181, '2001 款', NULL, 1777, 0, NULL, 'X', 0, 4, 0),
(6182, '2003 款', NULL, 1778, 0, NULL, 'X', 0, 4, 0),
(6183, '2013 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6184, '2012 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6185, '2011 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6186, '2010 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6187, '2009 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6188, '2008 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6189, '2007 款', NULL, 1779, 0, NULL, 'X', 0, 4, 0),
(6190, '2014 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6191, '2013 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6192, '2012 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6193, '2011 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6194, '2010 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6195, '2009 款', NULL, 1780, 0, NULL, 'X', 0, 4, 0),
(6196, '2013 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6197, '2012 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6198, '2010 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6199, '2009 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6200, '2008 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6201, '2007 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6202, '2006 款', NULL, 1781, 0, NULL, 'X', 0, 4, 0),
(6203, '2014 款', NULL, 1782, 0, NULL, 'X', 0, 4, 0),
(6204, '2013 款', NULL, 1782, 0, NULL, 'X', 0, 4, 0),
(6205, '2013 款', NULL, 1783, 0, NULL, 'X', 0, 4, 0),
(6206, '2012 款', NULL, 1783, 0, NULL, 'X', 0, 4, 0),
(6207, '2011 款', NULL, 1783, 0, NULL, 'X', 0, 4, 0),
(6208, '2010 款', NULL, 1783, 0, NULL, 'X', 0, 4, 0),
(6209, '2013 款', NULL, 1784, 0, NULL, 'X', 0, 4, 0),
(6210, '2012 款', NULL, 1784, 0, NULL, 'X', 0, 4, 0),
(6211, '2009 款', NULL, 1785, 0, NULL, 'X', 0, 4, 0),
(6212, '2009 款', NULL, 1786, 0, NULL, 'X', 0, 4, 0),
(6213, '2006 款', NULL, 1786, 0, NULL, 'X', 0, 4, 0),
(6214, '2014 款', NULL, 1787, 0, NULL, 'X', 0, 4, 0),
(6215, '2007 款', NULL, 1787, 0, NULL, 'X', 0, 4, 0),
(6216, '2005 款', NULL, 1787, 0, NULL, 'X', 0, 4, 0),
(6217, '2008 款', NULL, 1788, 0, NULL, 'X', 0, 4, 0),
(6218, '2007 款', NULL, 1788, 0, NULL, 'X', 0, 4, 0),
(6219, '2005 款', NULL, 1788, 0, NULL, 'X', 0, 4, 0),
(6220, '2014 款', NULL, 1789, 0, NULL, 'X', 0, 4, 0),
(6221, '2009 款', NULL, 1790, 0, NULL, 'X', 0, 4, 0),
(6222, '2013 款', NULL, 1791, 0, NULL, 'X', 0, 4, 0),
(6223, '2012 款', NULL, 1791, 0, NULL, 'X', 0, 4, 0),
(6224, '2010 款', NULL, 1791, 0, NULL, 'X', 0, 4, 0),
(6225, '2013 款', NULL, 1792, 0, NULL, 'X', 0, 4, 0),
(6226, '2012 款', NULL, 1792, 0, NULL, 'X', 0, 4, 0),
(6227, '2009 款', NULL, 1793, 0, NULL, 'X', 0, 4, 0),
(6228, '2009 款', NULL, 1794, 0, NULL, 'X', 0, 4, 0),
(6229, '2013 款', NULL, 1795, 0, NULL, 'X', 0, 4, 0),
(6230, '2011 款', NULL, 1796, 0, NULL, 'X', 0, 4, 0),
(6231, '2014 款', NULL, 1797, 0, NULL, 'X', 0, 4, 0),
(6232, '2013 款', NULL, 1797, 0, NULL, 'X', 0, 4, 0),
(6233, '2010 款', NULL, 1797, 0, NULL, 'X', 0, 4, 0),
(6234, '2014 款', NULL, 1798, 0, NULL, 'X', 0, 4, 0),
(6235, '2014 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6236, '2013 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6237, '2011 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6238, '2010 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6239, '2009 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6240, '2008 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6241, '2007 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6242, '2006 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6243, '2005 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6244, '2004 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6245, '2003 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6246, '2002 款', NULL, 1799, 0, NULL, 'X', 0, 4, 0),
(6247, '2013 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6248, '2009 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6249, '2008 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6250, '2007 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6251, '2006 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6252, '2005 款', NULL, 1800, 0, NULL, 'X', 0, 4, 0),
(6253, '2011 款', NULL, 1801, 0, NULL, 'X', 0, 4, 0),
(6254, '2009 款', NULL, 1801, 0, NULL, 'X', 0, 4, 0),
(6255, '2008 款', NULL, 1801, 0, NULL, 'X', 0, 4, 0),
(6256, '2007 款', NULL, 1801, 0, NULL, 'X', 0, 4, 0),
(6257, '2006 款', NULL, 1801, 0, NULL, 'X', 0, 4, 0),
(6258, '2011 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6259, '2008 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6260, '2007 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6261, '2006 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6262, '2005 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6263, '2004 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6264, '2003 款', NULL, 1802, 0, NULL, 'X', 0, 4, 0),
(6265, '2008 款', NULL, 1803, 0, NULL, 'X', 0, 4, 0),
(6266, '2007 款', NULL, 1803, 0, NULL, 'X', 0, 4, 0),
(6267, '2006 款', NULL, 1803, 0, NULL, 'X', 0, 4, 0),
(6268, '2009 款', NULL, 1804, 0, NULL, 'X', 0, 4, 0),
(6269, '2008 款', NULL, 1804, 0, NULL, 'X', 0, 4, 0),
(6270, '2007 款', NULL, 1804, 0, NULL, 'X', 0, 4, 0),
(6271, '2006 款', NULL, 1804, 0, NULL, 'X', 0, 4, 0),
(6272, '2005 款', NULL, 1804, 0, NULL, 'X', 0, 4, 0),
(6273, '2011 款', NULL, 1805, 0, NULL, 'X', 0, 4, 0),
(6274, '2010 款', NULL, 1805, 0, NULL, 'X', 0, 4, 0),
(6275, '2009 款', NULL, 1805, 0, NULL, 'X', 0, 4, 0),
(6276, '2008 款', NULL, 1805, 0, NULL, 'X', 0, 4, 0),
(6277, '2014 款', NULL, 1806, 0, NULL, 'X', 0, 4, 0),
(6278, '2013 款', NULL, 1807, 0, NULL, 'X', 0, 4, 0),
(6279, '2001 款', NULL, 1808, 0, NULL, 'X', 0, 4, 0),
(6280, '2000 款', NULL, 1808, 0, NULL, 'X', 0, 4, 0),
(6281, '2012 款', NULL, 1809, 0, NULL, 'X', 0, 4, 0),
(6282, '2011 款', NULL, 1809, 0, NULL, 'X', 0, 4, 0),
(6283, '2013 款', NULL, 1810, 0, NULL, 'X', 0, 4, 0),
(6284, '2011 款', NULL, 1811, 0, NULL, 'X', 0, 4, 0),
(6285, '2003 款', NULL, 1812, 0, NULL, 'X', 0, 4, 0),
(6286, '1999 款', NULL, 1812, 0, NULL, 'X', 0, 4, 0),
(6287, '2008 款', NULL, 1813, 0, NULL, 'X', 0, 4, 0),
(6288, '2006 款', NULL, 1813, 0, NULL, 'X', 0, 4, 0),
(6289, '2004 款', NULL, 1813, 0, NULL, 'X', 0, 4, 0),
(6290, '2012 款', NULL, 1814, 0, NULL, 'X', 0, 4, 0),
(6291, '2008 款', NULL, 1814, 0, NULL, 'X', 0, 4, 0),
(6292, '2012 款', NULL, 1815, 0, NULL, 'X', 0, 4, 0),
(6293, '2009 款', NULL, 1815, 0, NULL, 'X', 0, 4, 0),
(6294, '2013 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6295, '2012 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6296, '2011 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6297, '2010 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6298, '2009 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6299, '2007 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6300, '2006 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6301, '2005 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6302, '2000 款', NULL, 1816, 0, NULL, 'X', 0, 4, 0),
(6303, '2003 款', NULL, 1817, 0, NULL, 'X', 0, 4, 0),
(6304, '2000 款', NULL, 1818, 0, NULL, 'X', 0, 4, 0),
(6305, '2014 款', NULL, 1819, 0, NULL, 'X', 0, 4, 0),
(6306, '2012 款', NULL, 1819, 0, NULL, 'X', 0, 4, 0),
(6307, '2005 款', NULL, 1819, 0, NULL, 'X', 0, 4, 0),
(6308, '1993 款', NULL, 1819, 0, NULL, 'X', 0, 4, 0),
(6309, '2002 款', NULL, 1820, 0, NULL, 'X', 0, 4, 0),
(6310, '1998 款', NULL, 1820, 0, NULL, 'X', 0, 4, 0),
(6311, '2012 款', NULL, 1821, 0, NULL, 'X', 0, 4, 0),
(6312, '2010 款', NULL, 1821, 0, NULL, 'X', 0, 4, 0),
(6313, '2007 款', NULL, 1821, 0, NULL, 'X', 0, 4, 0),
(6314, '2006 款', NULL, 1821, 0, NULL, 'X', 0, 4, 0),
(6315, '2005 款', NULL, 1822, 0, NULL, 'X', 0, 4, 0),
(6316, '2013 款', NULL, 1823, 0, NULL, 'X', 0, 4, 0),
(6317, '2012 款', NULL, 1823, 0, NULL, 'X', 0, 4, 0),
(6318, '2011 款', NULL, 1823, 0, NULL, 'X', 0, 4, 0),
(6319, '2009 款', NULL, 1823, 0, NULL, 'X', 0, 4, 0),
(6320, '2006 款', NULL, 1823, 0, NULL, 'X', 0, 4, 0),
(6321, '2011 款', NULL, 1824, 0, NULL, 'X', 0, 4, 0),
(6322, '2010 款', NULL, 1824, 0, NULL, 'X', 0, 4, 0),
(6323, '2009 款', NULL, 1824, 0, NULL, 'X', 0, 4, 0),
(6324, '2006 款', NULL, 1824, 0, NULL, 'X', 0, 4, 0),
(6325, '2003 款', NULL, 1825, 0, NULL, 'X', 0, 4, 0),
(6326, '2002 款', NULL, 1825, 0, NULL, 'X', 0, 4, 0),
(6327, '2001 款', NULL, 1825, 0, NULL, 'X', 0, 4, 0),
(6328, '2002 款', NULL, 1826, 0, NULL, 'X', 0, 4, 0),
(6329, '2014 款', NULL, 1827, 0, NULL, 'X', 0, 4, 0),
(6330, '2013 款', NULL, 1827, 0, NULL, 'X', 0, 4, 0),
(6331, '2011 款', NULL, 1827, 0, NULL, 'X', 0, 4, 0),
(6332, '2014 款', NULL, 1828, 0, NULL, 'X', 0, 4, 0),
(6333, '2013 款', NULL, 1828, 0, NULL, 'X', 0, 4, 0),
(6334, '2011 款', NULL, 1828, 0, NULL, 'X', 0, 4, 0),
(6335, '2014 款', NULL, 1829, 0, NULL, 'X', 0, 4, 0),
(6336, '2013 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6337, '2012 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6338, '2011 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6339, '2010 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6340, '2008 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6341, '2007 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6342, '2006 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6343, '2005 款', NULL, 1830, 0, NULL, 'X', 0, 4, 0),
(6344, '2014 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6345, '2013 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6346, '2012 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6347, '2011 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6348, '2010 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6349, '2009 款', NULL, 1831, 0, NULL, 'X', 0, 4, 0),
(6350, '2013 款', NULL, 1832, 0, NULL, 'X', 0, 4, 0),
(6351, '2014 款', NULL, 1833, 0, NULL, 'X', 0, 4, 0),
(6352, '2013 款', NULL, 1833, 0, NULL, 'X', 0, 4, 0),
(6353, '2011 款', NULL, 1833, 0, NULL, 'X', 0, 4, 0),
(6354, '2010 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6355, '2009 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6356, '2008 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6357, '2007 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6358, '2006 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6359, '2005 款', NULL, 1834, 0, NULL, 'X', 0, 4, 0),
(6360, '2010 款', NULL, 1835, 0, NULL, 'X', 0, 4, 0),
(6361, '2009 款', NULL, 1835, 0, NULL, 'X', 0, 4, 0),
(6362, '2008 款', NULL, 1835, 0, NULL, 'X', 0, 4, 0),
(6363, '2007 款', NULL, 1835, 0, NULL, 'X', 0, 4, 0),
(6364, '2006 款', NULL, 1835, 0, NULL, 'X', 0, 4, 0),
(6365, '2014 款', NULL, 1836, 0, NULL, 'X', 0, 4, 0),
(6366, '2013 款', NULL, 1836, 0, NULL, 'X', 0, 4, 0),
(6367, '2012 款', NULL, 1836, 0, NULL, 'X', 0, 4, 0),
(6368, '2013 款', NULL, 1837, 0, NULL, 'X', 0, 4, 0),
(6369, '2011 款', NULL, 1838, 0, NULL, 'X', 0, 4, 0),
(6370, '2010 款', NULL, 1838, 0, NULL, 'X', 0, 4, 0),
(6371, '2013 款', NULL, 1839, 0, NULL, 'X', 0, 4, 0),
(6372, '2011 款', NULL, 1839, 0, NULL, 'X', 0, 4, 0),
(6373, '2010 款', NULL, 1839, 0, NULL, 'X', 0, 4, 0),
(6374, '2005 款', NULL, 1839, 0, NULL, 'X', 0, 4, 0),
(6375, '2005 款', NULL, 1840, 0, NULL, 'X', 0, 4, 0),
(6376, '2010 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6377, '2009 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6378, '2008 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6379, '2006 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6380, '2004 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6381, '2003 款', NULL, 1841, 0, NULL, 'X', 0, 4, 0),
(6382, '2012 款', NULL, 1842, 0, NULL, 'X', 0, 4, 0),
(6383, '2011 款', NULL, 1842, 0, NULL, 'X', 0, 4, 0),
(6384, '2010 款', NULL, 1842, 0, NULL, 'X', 0, 4, 0),
(6385, '2011 款', NULL, 1843, 0, NULL, 'X', 0, 4, 0),
(6386, '2010 款', NULL, 1843, 0, NULL, 'X', 0, 4, 0),
(6387, '2008 款', NULL, 1843, 0, NULL, 'X', 0, 4, 0),
(6388, '2007 款', NULL, 1843, 0, NULL, 'X', 0, 4, 0),
(6389, '1990 款', NULL, 1844, 0, NULL, 'X', 0, 4, 0),
(6390, '2011 款', NULL, 1845, 0, NULL, 'X', 0, 4, 0),
(6391, '2012 款', NULL, 1846, 0, NULL, 'X', 0, 4, 0),
(6392, '2004 款', NULL, 1847, 0, NULL, 'X', 0, 4, 0),
(6393, '其他', NULL, 1847, 0, NULL, 'X', 0, 4, 0),
(6394, '2008 款', NULL, 1848, 0, NULL, 'X', 0, 4, 0),
(6395, '2006 款', NULL, 1848, 0, NULL, 'X', 0, 4, 0),
(6396, '2004 款', NULL, 1848, 0, NULL, 'X', 0, 4, 0),
(6397, '2004 款', NULL, 1849, 0, NULL, 'X', 0, 4, 0),
(6398, '2005 款', NULL, 1850, 0, NULL, 'X', 0, 4, 0),
(6399, '2004 款', NULL, 1850, 0, NULL, 'X', 0, 4, 0),
(6400, '2000 款', NULL, 1850, 0, NULL, 'X', 0, 4, 0),
(6401, '2007 款', NULL, 1851, 0, NULL, 'X', 0, 4, 0),
(6402, '2005 款', NULL, 1851, 0, NULL, 'X', 0, 4, 0),
(6403, '2003 款', NULL, 1852, 0, NULL, 'X', 0, 4, 0),
(6404, '2002 款', NULL, 1852, 0, NULL, 'X', 0, 4, 0),
(6405, '2004 款', NULL, 1853, 0, NULL, 'X', 0, 4, 0),
(6406, '2004 款', NULL, 1854, 0, NULL, 'X', 0, 4, 0),
(6407, '2012 款', NULL, 1855, 0, NULL, 'X', 0, 4, 0),
(6408, '2012 款', NULL, 1856, 0, NULL, 'X', 0, 4, 0),
(6409, '2011 款', NULL, 1857, 0, NULL, 'X', 0, 4, 0),
(6410, '2012 款', NULL, 1858, 0, NULL, 'X', 0, 4, 0),
(6411, '2014 款', NULL, 1859, 0, NULL, 'X', 0, 4, 0),
(6412, '2003 款', NULL, 1860, 0, NULL, 'X', 0, 4, 0),
(6413, '2003 款', NULL, 1861, 0, NULL, 'X', 0, 4, 0),
(6414, '2003 款', NULL, 1862, 0, NULL, 'X', 0, 4, 0),
(6415, '2003 款', NULL, 1863, 0, NULL, 'X', 0, 4, 0),
(6416, '2012 款', NULL, 1864, 0, NULL, 'X', 0, 4, 0),
(6417, '2013 款', NULL, 1865, 0, NULL, 'X', 0, 4, 0),
(6418, '2013 款', NULL, 1866, 0, NULL, 'X', 0, 4, 0),
(6419, '2010 款', NULL, 1867, 0, NULL, 'X', 0, 4, 0),
(6420, '2010 款', NULL, 1868, 0, NULL, 'X', 0, 4, 0),
(6421, '2010 款', NULL, 1869, 0, NULL, 'X', 0, 4, 0),
(6422, '2010 款', NULL, 1870, 0, NULL, 'X', 0, 4, 0),
(6423, '2012 款', NULL, 1871, 0, NULL, 'X', 0, 4, 0),
(6424, '2011 款', NULL, 1871, 0, NULL, 'X', 0, 4, 0),
(6425, '2011 款', NULL, 1872, 0, NULL, 'X', 0, 4, 0),
(6426, '2010 款', NULL, 1873, 0, NULL, 'X', 0, 4, 0),
(6427, '2011 款', NULL, 1874, 0, NULL, 'X', 0, 4, 0),
(6428, '2010 款', NULL, 1874, 0, NULL, 'X', 0, 4, 0),
(6429, '2010 款', NULL, 1875, 0, NULL, 'X', 0, 4, 0),
(6430, '2010 款', NULL, 1876, 0, NULL, 'X', 0, 4, 0),
(6431, '2006 款', NULL, 1877, 0, NULL, 'Y', 0, 4, 0),
(6432, '2004 款', NULL, 1877, 0, NULL, 'Y', 0, 4, 0),
(6433, '2003 款', NULL, 1877, 0, NULL, 'Y', 0, 4, 0),
(6434, '2011 款', NULL, 1878, 0, NULL, 'Y', 0, 4, 0),
(6435, '2014 款', NULL, 1879, 0, NULL, 'Y', 0, 4, 0),
(6436, '2011 款', NULL, 1879, 0, NULL, 'Y', 0, 4, 0),
(6437, '2007 款', NULL, 1879, 0, NULL, 'Y', 0, 4, 0),
(6438, '其他', NULL, 1879, 0, NULL, 'Y', 0, 4, 0),
(6439, '2014 款', NULL, 1880, 0, NULL, 'Y', 0, 4, 0),
(6440, '2011 款', NULL, 1880, 0, NULL, 'Y', 0, 4, 0),
(6441, '2011 款', NULL, 1881, 0, NULL, 'Y', 0, 4, 0),
(6442, '2014 款', NULL, 1882, 0, NULL, 'Y', 0, 4, 0),
(6443, '2008 款', NULL, 1883, 0, NULL, 'Y', 0, 4, 0),
(6444, '2006 款', NULL, 1883, 0, NULL, 'Y', 0, 4, 0),
(6445, '2004 款', NULL, 1883, 0, NULL, 'Y', 0, 4, 0),
(6446, '2004 款', NULL, 1884, 0, NULL, 'Y', 0, 4, 0),
(6447, '2003 款', NULL, 1884, 0, NULL, 'Y', 0, 4, 0),
(6448, '2011 款', NULL, 1885, 0, NULL, 'Y', 0, 4, 0),
(6449, '2014 款', NULL, 1886, 0, NULL, 'Y', 0, 4, 0),
(6450, '2003 款', NULL, 1887, 0, NULL, 'Y', 0, 4, 0),
(6451, '2008 款', NULL, 1888, 0, NULL, 'Y', 0, 4, 0),
(6452, '2007 款', NULL, 1888, 0, NULL, 'Y', 0, 4, 0),
(6453, '2006 款', NULL, 1888, 0, NULL, 'Y', 0, 4, 0),
(6454, '2005 款', NULL, 1888, 0, NULL, 'Y', 0, 4, 0),
(6455, '2004 款', NULL, 1888, 0, NULL, 'Y', 0, 4, 0),
(6456, '2012 款', NULL, 1889, 0, NULL, 'Y', 0, 4, 0);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(6457, '2010 款', NULL, 1889, 0, NULL, 'Y', 0, 4, 0),
(6458, '2012 款', NULL, 1890, 0, NULL, 'Y', 0, 4, 0),
(6459, '2009 款', NULL, 1891, 0, NULL, 'Y', 0, 4, 0),
(6460, '2008 款', NULL, 1891, 0, NULL, 'Y', 0, 4, 0),
(6461, '2007 款', NULL, 1891, 0, NULL, 'Y', 0, 4, 0),
(6462, '2006 款', NULL, 1891, 0, NULL, 'Y', 0, 4, 0),
(6463, '2011 款', NULL, 1892, 0, NULL, 'Y', 0, 4, 0),
(6464, '2009 款', NULL, 1892, 0, NULL, 'Y', 0, 4, 0),
(6465, '2008 款', NULL, 1892, 0, NULL, 'Y', 0, 4, 0),
(6466, '2007 款', NULL, 1892, 0, NULL, 'Y', 0, 4, 0),
(6467, '2006 款', NULL, 1892, 0, NULL, 'Y', 0, 4, 0),
(6468, '2011 款', NULL, 1893, 0, NULL, 'Y', 0, 4, 0),
(6469, '2007 款', NULL, 1893, 0, NULL, 'Y', 0, 4, 0),
(6470, '2006 款', NULL, 1893, 0, NULL, 'Y', 0, 4, 0),
(6471, '2004 款', NULL, 1893, 0, NULL, 'Y', 0, 4, 0),
(6472, '2002 款', NULL, 1893, 0, NULL, 'Y', 0, 4, 0),
(6473, '2006 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6474, '2005 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6475, '2004 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6476, '2003 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6477, '2002 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6478, '2001 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6479, '1999 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6480, '1997 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6481, '1993 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6482, '1990 款', NULL, 1894, 0, NULL, 'Y', 0, 4, 0),
(6483, '2002 款', NULL, 1895, 0, NULL, 'Y', 0, 4, 0),
(6484, '2000 款', NULL, 1895, 0, NULL, 'Y', 0, 4, 0),
(6485, '2011 款', NULL, 1896, 0, NULL, 'Y', 0, 4, 0),
(6486, '2007 款', NULL, 1896, 0, NULL, 'Y', 0, 4, 0),
(6487, '2006 款', NULL, 1896, 0, NULL, 'Y', 0, 4, 0),
(6488, '2005 款', NULL, 1896, 0, NULL, 'Y', 0, 4, 0),
(6489, '2012 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6490, '2007 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6491, '2006 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6492, '2005 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6493, '2004 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6494, '2002 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6495, '2000 款', NULL, 1897, 0, NULL, 'Y', 0, 4, 0),
(6496, '2012 款', NULL, 1898, 0, NULL, 'Y', 0, 4, 0),
(6497, '2008 款', NULL, 1898, 0, NULL, 'Y', 0, 4, 0),
(6498, '2007 款', NULL, 1898, 0, NULL, 'Y', 0, 4, 0),
(6499, '2006 款', NULL, 1898, 0, NULL, 'Y', 0, 4, 0),
(6500, '2012 款', NULL, 1899, 0, NULL, 'Y', 0, 4, 0),
(6501, '2008 款', NULL, 1899, 0, NULL, 'Y', 0, 4, 0),
(6502, '2007 款', NULL, 1899, 0, NULL, 'Y', 0, 4, 0),
(6503, '2014 款', NULL, 1900, 0, NULL, 'Y', 0, 4, 0),
(6504, '2013 款', NULL, 1900, 0, NULL, 'Y', 0, 4, 0),
(6505, '2011 款', NULL, 1900, 0, NULL, 'Y', 0, 4, 0),
(6506, '2010 款', NULL, 1900, 0, NULL, 'Y', 0, 4, 0),
(6507, '2013 款', NULL, 1901, 0, NULL, 'Y', 0, 4, 0),
(6508, '2004 款', NULL, 1902, 0, NULL, 'Y', 0, 4, 0),
(6509, '2000 款', NULL, 1902, 0, NULL, 'Y', 0, 4, 0),
(6510, '2011 款', NULL, 1903, 0, NULL, 'Y', 0, 4, 0),
(6511, '2009 款', NULL, 1903, 0, NULL, 'Y', 0, 4, 0),
(6512, '2011 款', NULL, 1904, 0, NULL, 'Y', 0, 4, 0),
(6513, '2009 款', NULL, 1904, 0, NULL, 'Y', 0, 4, 0),
(6514, '2011 款', NULL, 1905, 0, NULL, 'Y', 0, 4, 0),
(6515, '2009 款', NULL, 1905, 0, NULL, 'Y', 0, 4, 0),
(6516, '2013 款', NULL, 1906, 0, NULL, 'Y', 0, 4, 0),
(6517, '2012 款', NULL, 1906, 0, NULL, 'Y', 0, 4, 0),
(6518, '2011 款', NULL, 1906, 0, NULL, 'Y', 0, 4, 0),
(6519, '2010 款', NULL, 1906, 0, NULL, 'Y', 0, 4, 0),
(6520, '2009 款', NULL, 1906, 0, NULL, 'Y', 0, 4, 0),
(6521, '2013 款', NULL, 1907, 0, NULL, 'Y', 0, 4, 0),
(6522, '2011 款', NULL, 1907, 0, NULL, 'Y', 0, 4, 0),
(6523, '2009 款', NULL, 1907, 0, NULL, 'Y', 0, 4, 0),
(6524, '2012 款', NULL, 1908, 0, NULL, 'Y', 0, 4, 0),
(6525, '2011 款', NULL, 1908, 0, NULL, 'Y', 0, 4, 0),
(6526, '2012 款', NULL, 1909, 0, NULL, 'Y', 0, 4, 0),
(6527, '2014 款', NULL, 1910, 0, NULL, 'Y', 0, 4, 0),
(6528, '2013 款', NULL, 1910, 0, NULL, 'Y', 0, 4, 0),
(6529, '2005 款', NULL, 1910, 0, NULL, 'Y', 0, 4, 0),
(6530, '2000 款', NULL, 1910, 0, NULL, 'Y', 0, 4, 0),
(6531, '其他', NULL, 1910, 0, NULL, 'Y', 0, 4, 0),
(6532, '2014 款', NULL, 1911, 0, NULL, 'Y', 0, 4, 0),
(6533, '2012 款', NULL, 1911, 0, NULL, 'Y', 0, 4, 0),
(6534, '2011 款', NULL, 1911, 0, NULL, 'Y', 0, 4, 0),
(6535, '2009 款', NULL, 1911, 0, NULL, 'Y', 0, 4, 0),
(6536, '2014 款', NULL, 1912, 0, NULL, 'Y', 0, 4, 0),
(6537, '2013 款', NULL, 1912, 0, NULL, 'Y', 0, 4, 0),
(6538, '2012 款', NULL, 1912, 0, NULL, 'Y', 0, 4, 0),
(6539, '2011 款', NULL, 1912, 0, NULL, 'Y', 0, 4, 0),
(6540, '2004 款', NULL, 1913, 0, NULL, 'Y', 0, 4, 0),
(6541, '2009 款', NULL, 1914, 0, NULL, 'Y', 0, 4, 0),
(6542, '2008 款', NULL, 1914, 0, NULL, 'Y', 0, 4, 0),
(6543, '2007 款', NULL, 1914, 0, NULL, 'Y', 0, 4, 0),
(6544, '2010 款', NULL, 1915, 0, NULL, 'Y', 0, 4, 0),
(6545, '2009 款', NULL, 1915, 0, NULL, 'Y', 0, 4, 0),
(6546, '2007 款', NULL, 1915, 0, NULL, 'Y', 0, 4, 0),
(6547, '2006 款', NULL, 1915, 0, NULL, 'Y', 0, 4, 0),
(6548, '2011 款', NULL, 1916, 0, NULL, 'Y', 0, 4, 0),
(6549, '2008 款', NULL, 1917, 0, NULL, 'Y', 0, 4, 0),
(6550, '2007 款', NULL, 1917, 0, NULL, 'Y', 0, 4, 0),
(6551, '2013 款', NULL, 1918, 0, NULL, 'Y', 0, 4, 0),
(6552, '2013 款', NULL, 1919, 0, NULL, 'Y', 0, 4, 0),
(6553, '2012 款', NULL, 1919, 0, NULL, 'Y', 0, 4, 0),
(6554, '2013 款', NULL, 1920, 0, NULL, 'Y', 0, 4, 0),
(6555, '2012 款', NULL, 1920, 0, NULL, 'Y', 0, 4, 0),
(6556, '2010 款', NULL, 1920, 0, NULL, 'Y', 0, 4, 0),
(6557, '2009 款', NULL, 1920, 0, NULL, 'Y', 0, 4, 0),
(6558, '2008 款', NULL, 1921, 0, NULL, 'Y', 0, 4, 0),
(6559, '2007 款', NULL, 1921, 0, NULL, 'Y', 0, 4, 0),
(6560, '2006 款', NULL, 1921, 0, NULL, 'Y', 0, 4, 0),
(6561, '2004 款', NULL, 1922, 0, NULL, 'Y', 0, 4, 0),
(6562, '2001 款', NULL, 1922, 0, NULL, 'Y', 0, 4, 0),
(6563, '2013 款', NULL, 1923, 0, NULL, 'Y', 0, 4, 0),
(6564, '2011 款', NULL, 1923, 0, NULL, 'Y', 0, 4, 0),
(6565, '2010 款', NULL, 1923, 0, NULL, 'Y', 0, 4, 0),
(6566, '2009 款', NULL, 1923, 0, NULL, 'Y', 0, 4, 0),
(6567, '2013 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6568, '2011 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6569, '2010 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6570, '2009 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6571, '2007 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6572, '2006 款', NULL, 1924, 0, NULL, 'Y', 0, 4, 0),
(6573, '2013 款', NULL, 1925, 0, NULL, 'Y', 0, 4, 0),
(6574, '2010 款', NULL, 1925, 0, NULL, 'Y', 0, 4, 0),
(6575, '2009 款', NULL, 1925, 0, NULL, 'Y', 0, 4, 0),
(6576, '2007 款', NULL, 1925, 0, NULL, 'Y', 0, 4, 0),
(6577, '2013 款', NULL, 1926, 0, NULL, 'Y', 0, 4, 0),
(6578, '2012 款', NULL, 1927, 0, NULL, 'Y', 0, 4, 0),
(6579, '2011 款', NULL, 1927, 0, NULL, 'Y', 0, 4, 0),
(6580, '2009 款', NULL, 1927, 0, NULL, 'Y', 0, 4, 0),
(6581, '2008 款', NULL, 1927, 0, NULL, 'Y', 0, 4, 0),
(6582, '2003 款', NULL, 1927, 0, NULL, 'Y', 0, 4, 0),
(6583, '2014 款', NULL, 1928, 0, NULL, 'Y', 0, 4, 0),
(6584, '2013 款', NULL, 1929, 0, NULL, 'Y', 0, 4, 0),
(6585, '2013 款', NULL, 1930, 0, NULL, 'Y', 0, 4, 0),
(6586, '2012 款', NULL, 1931, 0, NULL, 'Y', 0, 4, 0),
(6587, '2013 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6588, '2011 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6589, '2008 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6590, '2005 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6591, '2004 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6592, '2001 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6593, '1997 款', NULL, 1932, 0, NULL, 'Y', 0, 4, 0),
(6594, '2013 款', NULL, 1933, 0, NULL, 'Y', 0, 4, 0),
(6595, '2013 款', NULL, 1934, 0, NULL, 'Y', 0, 4, 0),
(6596, '2013 款', NULL, 1935, 0, NULL, 'Y', 0, 4, 0),
(6597, '2013 款', NULL, 1936, 0, NULL, 'Y', 0, 4, 0),
(6598, '1996 款', NULL, 1937, 0, NULL, 'Y', 0, 4, 0),
(6599, '1993 款', NULL, 1937, 0, NULL, 'Y', 0, 4, 0),
(6600, '2003 款', NULL, 1938, 0, NULL, 'Y', 0, 4, 0),
(6601, '2001 款', NULL, 1938, 0, NULL, 'Y', 0, 4, 0),
(6602, '1999 款', NULL, 1938, 0, NULL, 'Y', 0, 4, 0),
(6603, '1997 款', NULL, 1938, 0, NULL, 'Y', 0, 4, 0),
(6604, '2012 款', NULL, 1939, 0, NULL, 'Y', 0, 4, 0),
(6605, '2011 款', NULL, 1939, 0, NULL, 'Y', 0, 4, 0),
(6606, '2014 款', NULL, 1940, 0, NULL, 'Y', 0, 4, 0),
(6607, '2012 款', NULL, 1940, 0, NULL, 'Y', 0, 4, 0),
(6608, '2012 款', NULL, 1941, 0, NULL, 'Y', 0, 4, 0),
(6609, '2011 款', NULL, 1941, 0, NULL, 'Y', 0, 4, 0),
(6610, '2010 款', NULL, 1941, 0, NULL, 'Y', 0, 4, 0),
(6611, '2009 款', NULL, 1941, 0, NULL, 'Y', 0, 4, 0),
(6612, '2008 款', NULL, 1942, 0, NULL, 'Y', 0, 4, 0),
(6613, '2005 款', NULL, 1943, 0, NULL, 'Y', 0, 4, 0),
(6614, '2013 款', NULL, 1944, 0, NULL, 'Y', 0, 4, 0),
(6615, '2010 款', NULL, 1945, 0, NULL, 'Z', 0, 4, 0),
(6616, '2003 款', NULL, 1945, 0, NULL, 'Z', 0, 4, 0),
(6617, '2003 款', NULL, 1946, 0, NULL, 'Z', 0, 4, 0),
(6618, '2002 款', NULL, 1946, 0, NULL, 'Z', 0, 4, 0),
(6619, '2002 款', NULL, 1947, 0, NULL, 'Z', 0, 4, 0),
(6620, '2003 款', NULL, 1948, 0, NULL, 'Z', 0, 4, 0),
(6621, '2009 款', NULL, 1949, 0, NULL, 'Z', 0, 4, 0),
(6622, '2006 款', NULL, 1949, 0, NULL, 'Z', 0, 4, 0),
(6623, '2004 款', NULL, 1949, 0, NULL, 'Z', 0, 4, 0),
(6624, '2003 款', NULL, 1949, 0, NULL, 'Z', 0, 4, 0),
(6625, '2002 款', NULL, 1950, 0, NULL, 'Z', 0, 4, 0),
(6626, '2002 款', NULL, 1951, 0, NULL, 'Z', 0, 4, 0),
(6627, '2003 款', NULL, 1952, 0, NULL, 'Z', 0, 4, 0),
(6628, '2014 款', NULL, 1953, 0, NULL, 'Z', 0, 4, 0),
(6629, '2013 款', NULL, 1953, 0, NULL, 'Z', 0, 4, 0),
(6630, '2012 款', NULL, 1953, 0, NULL, 'Z', 0, 4, 0),
(6631, '2014 款', NULL, 1954, 0, NULL, 'Z', 0, 4, 0),
(6632, '2013 款', NULL, 1954, 0, NULL, 'Z', 0, 4, 0),
(6633, '2011 款', NULL, 1954, 0, NULL, 'Z', 0, 4, 0),
(6634, '2010 款', NULL, 1954, 0, NULL, 'Z', 0, 4, 0),
(6635, '2006 款', NULL, 1954, 0, NULL, 'Z', 0, 4, 0),
(6636, '2012 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6637, '2010 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6638, '2009 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6639, '2008 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6640, '2006 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6641, '2005 款', NULL, 1955, 0, NULL, 'Z', 0, 4, 0),
(6642, '2014 款', NULL, 1956, 0, NULL, 'Z', 0, 4, 0),
(6643, '2004 款', NULL, 1957, 0, NULL, 'Z', 0, 4, 0),
(6644, '2005 款', NULL, 1958, 0, NULL, 'Z', 0, 4, 0),
(6645, '2002 款', NULL, 1958, 0, NULL, 'Z', 0, 4, 0),
(6646, '2012 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6647, '2011 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6648, '2010 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6649, '2008 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6650, '2007 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6651, '2006 款', NULL, 1959, 0, NULL, 'Z', 0, 4, 0),
(6652, '2010 款', NULL, 1960, 0, NULL, 'Z', 0, 4, 0),
(6653, '2009 款', NULL, 1960, 0, NULL, 'Z', 0, 4, 0),
(6654, '2010 款', NULL, 1961, 0, NULL, 'Z', 0, 4, 0),
(6655, '2009 款', NULL, 1961, 0, NULL, 'Z', 0, 4, 0),
(6656, '2008 款', NULL, 1961, 0, NULL, 'Z', 0, 4, 0),
(6657, '2011 款', NULL, 1962, 0, NULL, 'Z', 0, 4, 0),
(6658, '2010 款', NULL, 1962, 0, NULL, 'Z', 0, 4, 0),
(6659, '2009 款', NULL, 1962, 0, NULL, 'Z', 0, 4, 0),
(6660, '2011 款', NULL, 1963, 0, NULL, 'Z', 0, 4, 0),
(6661, '2009 款', NULL, 1963, 0, NULL, 'Z', 0, 4, 0),
(6662, '2009 款', NULL, 1964, 0, NULL, 'Z', 0, 4, 0),
(6663, '2008 款', NULL, 1964, 0, NULL, 'Z', 0, 4, 0),
(6664, '2007 款', NULL, 1964, 0, NULL, 'Z', 0, 4, 0),
(6665, '2004 款', NULL, 1965, 0, NULL, 'Z', 0, 4, 0),
(6666, '2003 款', NULL, 1965, 0, NULL, 'Z', 0, 4, 0),
(6667, '2002 款', NULL, 1965, 0, NULL, 'Z', 0, 4, 0),
(6668, '2013 款', NULL, 1966, 0, NULL, 'Z', 0, 4, 0),
(6669, '2012 款', NULL, 1967, 0, NULL, 'Z', 0, 4, 0),
(6670, '2012 款', NULL, 1968, 0, NULL, 'Z', 0, 4, 0),
(6671, '2013 款', NULL, 1969, 0, NULL, 'Z', 0, 4, 0),
(6672, '2012 款', NULL, 1970, 0, NULL, 'Z', 0, 4, 0),
(6673, '2011 款', NULL, 1970, 0, NULL, 'Z', 0, 4, 0),
(6674, '2014 款', NULL, 1971, 0, NULL, 'Z', 0, 4, 0),
(6675, '2012 款', NULL, 1971, 0, NULL, 'Z', 0, 4, 0),
(6676, '2011 款', NULL, 1971, 0, NULL, 'Z', 0, 4, 0),
(6677, '2011 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6678, '2010 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6679, '2009 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6680, '2008 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6681, '2007 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6682, '2006 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6683, '2005 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6684, '2004 款', NULL, 1972, 0, NULL, 'Z', 0, 4, 0),
(6685, '2004 款', NULL, 1973, 0, NULL, 'Z', 0, 4, 0),
(6686, '2004 款', NULL, 1974, 0, NULL, 'Z', 0, 4, 0),
(6687, '其他', NULL, 1975, 0, NULL, 'Z', 0, 4, 0),
(6688, '2004 款', NULL, 1976, 0, NULL, 'Z', 0, 4, 0),
(6689, '2004 款', NULL, 1977, 0, NULL, 'Z', 0, 4, 0),
(6690, '2004 款', NULL, 1978, 0, NULL, 'Z', 0, 4, 0),
(6691, '2004 款', NULL, 1979, 0, NULL, 'Z', 0, 4, 0),
(6692, '2006 款', NULL, 1980, 0, NULL, 'Z', 0, 4, 0),
(6693, '2005 款', NULL, 1980, 0, NULL, 'Z', 0, 4, 0),
(6694, '2004 款', NULL, 1980, 0, NULL, 'Z', 0, 4, 0),
(6695, '2010 款', NULL, 1981, 0, NULL, 'Z', 0, 4, 0),
(6696, '2008 款', NULL, 1981, 0, NULL, 'Z', 0, 4, 0),
(6697, '2007 款', NULL, 1981, 0, NULL, 'Z', 0, 4, 0),
(6698, '2004 款', NULL, 1981, 0, NULL, 'Z', 0, 4, 0),
(6699, '2011 款', NULL, 1982, 0, NULL, 'Z', 0, 4, 0),
(6700, '2010 款', NULL, 1982, 0, NULL, 'Z', 0, 4, 0),
(6701, '2009 款', NULL, 1982, 0, NULL, 'Z', 0, 4, 0),
(6702, '2007 款', NULL, 1982, 0, NULL, 'Z', 0, 4, 0),
(6703, '2013 款', NULL, 1983, 0, NULL, 'Z', 0, 4, 0),
(6704, '2011 款', NULL, 1983, 0, NULL, 'Z', 0, 4, 0),
(6705, '2010 款', NULL, 1983, 0, NULL, 'Z', 0, 4, 0),
(6706, '2008 款', NULL, 1983, 0, NULL, 'Z', 0, 4, 0),
(6707, '2010 款', NULL, 1984, 0, NULL, 'Z', 0, 4, 0),
(6708, '2009 款', NULL, 1984, 0, NULL, 'Z', 0, 4, 0),
(6709, '2013 款', NULL, 1985, 0, NULL, 'Z', 0, 4, 0),
(6710, '2014 款', NULL, 1986, 0, NULL, 'Z', 0, 4, 0),
(6711, '2012 款', NULL, 1987, 0, NULL, 'Z', 0, 4, 0),
(6712, '2011 款', NULL, 1987, 0, NULL, 'Z', 0, 4, 0),
(6713, '2013 款', NULL, 1988, 0, NULL, 'Z', 0, 4, 0),
(6714, '2013 款', NULL, 1989, 0, NULL, 'Z', 0, 4, 0),
(6715, '2011 款', NULL, 1989, 0, NULL, 'Z', 0, 4, 0),
(6716, '2011 款', NULL, 1990, 0, NULL, 'Z', 0, 4, 0),
(6717, '2014 款', NULL, 1991, 0, NULL, 'Z', 0, 4, 0),
(6718, '2013 款', NULL, 1991, 0, NULL, 'Z', 0, 4, 0),
(6719, '2012 款', NULL, 1991, 0, NULL, 'Z', 0, 4, 0),
(6720, '2014 款', NULL, 1992, 0, NULL, 'Z', 0, 4, 0),
(6721, '2014 款', NULL, 1993, 0, NULL, 'Z', 0, 4, 0),
(6722, '2013 款', NULL, 1993, 0, NULL, 'Z', 0, 4, 0),
(6723, '2011 款', NULL, 1993, 0, NULL, 'Z', 0, 4, 0),
(6724, '2012 款', NULL, 1994, 0, NULL, 'Z', 0, 4, 0),
(6725, '2014 款', NULL, 1995, 0, NULL, 'Z', 0, 4, 0),
(59693, '1.6L GL MT', NULL, 5401, 0, NULL, 'Q', 0, 5, 8700),
(59692, '2.0L TOP AT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12188),
(59691, '1.6L Premium AT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12187),
(59690, '1.6L GLS AT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12186),
(59689, '1.6L GLS MT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12185),
(59688, '1.6L GL AT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12184),
(59687, '1.6L GL MT', NULL, 5400, 0, NULL, 'Q', 0, 5, 12183),
(59686, '1.6L Premium AT 纪念版', NULL, 5399, 0, NULL, 'Q', 0, 5, 101183),
(59685, '1.6L GLS AT 纪念版', NULL, 5399, 0, NULL, 'Q', 0, 5, 101182),
(59684, '1.6L GL AT 纪念版', NULL, 5399, 0, NULL, 'Q', 0, 5, 101181),
(59683, '1.6L GLS MT 纪念版', NULL, 5399, 0, NULL, 'Q', 0, 5, 101180),
(59682, '1.6L GL MT 纪念版', NULL, 5399, 0, NULL, 'Q', 0, 5, 101179),
(59681, '1.6L Premium Special AT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106091),
(59680, '1.6L Premium Special MT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106090),
(59679, '1.6L Premium AT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106089),
(59678, '1.6L GLS AT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106088),
(59677, '1.6L GLS MT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106087),
(59676, '1.6L GL AT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106086),
(59675, '1.6L GL MT', NULL, 5398, 0, NULL, 'Q', 0, 5, 106085),
(59674, '宝驹', NULL, 5397, 0, NULL, 'Q', 0, 5, 6875),
(59673, 'peterbilt 389', NULL, 5396, 0, NULL, 'P', 0, 5, 106565),
(59672, '6.0L', NULL, 5395, 0, NULL, 'P', 0, 5, 104804),
(59671, '火鸟', NULL, 5394, 0, NULL, 'P', 0, 5, 3795),
(59670, '旁蒂克', NULL, 5393, 0, NULL, 'P', 0, 5, 3824),
(59669, '1.5L 手动 舒适型', NULL, 5392, 0, NULL, 'O', 0, 5, 106465),
(59668, '1.5L 手动 豪华型', NULL, 5392, 0, NULL, 'O', 0, 5, 106464),
(59667, '1.5L 自动 舒适型', NULL, 5392, 0, NULL, 'O', 0, 5, 106463),
(59666, '1.5L 自动 豪华型', NULL, 5392, 0, NULL, 'O', 0, 5, 106462),
(59665, '1.5L 手动 基本型', NULL, 5391, 0, NULL, 'O', 0, 5, 100084),
(59664, '1.5L 手动 舒适型', NULL, 5391, 0, NULL, 'O', 0, 5, 16616),
(59663, '1.5L 自动 舒适型', NULL, 5391, 0, NULL, 'O', 0, 5, 16613),
(59662, '1.5L 自动 豪华型', NULL, 5391, 0, NULL, 'O', 0, 5, 16612),
(59661, '1.5L 自动 尊贵型', NULL, 5391, 0, NULL, 'O', 0, 5, 16404),
(59660, '1.5L 手动 豪华型', NULL, 5391, 0, NULL, 'O', 0, 5, 16403),
(59659, '2.0T 自动 两驱 豪华型 ', NULL, 5390, 0, NULL, 'O', 0, 5, 103514),
(59658, '2.0T 自动 四驱 运动型', NULL, 5390, 0, NULL, 'O', 0, 5, 103513),
(59657, '雅特（Astra）Twintop 敞篷版', NULL, 5389, 0, NULL, 'O', 0, 5, 3836),
(59656, 'GTC', NULL, 5388, 0, NULL, 'O', 0, 5, 3833),
(59655, 'GTC 全景风挡版', NULL, 5387, 0, NULL, 'O', 0, 5, 3835),
(59654, '1.8L 自动', NULL, 5386, 0, NULL, 'O', 0, 5, 103542),
(59653, '豪 华 版', NULL, 5385, 0, NULL, 'O', 0, 5, 7130),
(59652, '标 准 版', NULL, 5385, 0, NULL, 'O', 0, 5, 7129),
(59651, 'A+ 舒适型', NULL, 5384, 0, NULL, 'O', 0, 5, 109625),
(59650, 'GTC', NULL, 5384, 0, NULL, 'O', 0, 5, 109624),
(59649, 'ASTRA', NULL, 5384, 0, NULL, 'O', 0, 5, 109623),
(59648, '豪华型 5门', NULL, 5383, 0, NULL, 'O', 0, 5, 109622),
(59647, 'Twin Top硬顶敞篷跑车', NULL, 5382, 0, NULL, 'O', 0, 5, 10832),
(59646, 'GTC 全景风挡版', NULL, 5382, 0, NULL, 'O', 0, 5, 10831),
(59645, 'GTC', NULL, 5382, 0, NULL, 'O', 0, 5, 10830),
(59644, '5门版', NULL, 5382, 0, NULL, 'O', 0, 5, 10829),
(59643, 'A+ 豪华配置', NULL, 5382, 0, NULL, 'O', 0, 5, 10828),
(59642, 'A+ 标准配置', NULL, 5382, 0, NULL, 'O', 0, 5, 10827),
(59641, '1.4T GTC 运动型', NULL, 5381, 0, NULL, 'O', 0, 5, 106232),
(59640, '1.4T GTC 舒适型', NULL, 5381, 0, NULL, 'O', 0, 5, 106231),
(59639, '2.0L', NULL, 5380, 0, NULL, 'O', 0, 5, 6508),
(59638, '2.2L典雅版', NULL, 5379, 0, NULL, 'O', 0, 5, 10471),
(59637, '1.9 CDTi GTS Hatchback(100hp)柴油版', NULL, 5378, 0, NULL, 'O', 0, 5, 109802),
(59636, '威达(Vectra)2.2', NULL, 5378, 0, NULL, 'O', 0, 5, 3784),
(59635, '威达(Vectra)3.2V6', NULL, 5378, 0, NULL, 'O', 0, 5, 3782),
(59634, '2.2L豪华版', NULL, 5377, 0, NULL, 'O', 0, 5, 3841),
(59633, '2.2L舒适版', NULL, 5377, 0, NULL, 'O', 0, 5, 3840),
(59632, '2.2L导航舒适版', NULL, 5376, 0, NULL, 'O', 0, 5, 3845),
(59631, '2.2L豪华导航版', NULL, 5376, 0, NULL, 'O', 0, 5, 3844),
(59630, '豪华版', NULL, 5376, 0, NULL, 'O', 0, 5, 3843),
(59629, '舒适版', NULL, 5376, 0, NULL, 'O', 0, 5, 3842),
(59628, '1.8L AT', NULL, 5375, 0, NULL, 'O', 0, 5, 10470),
(59627, '2.2 Elegance', NULL, 5374, 0, NULL, 'O', 0, 5, 3837),
(59626, '2.2 Sport', NULL, 5374, 0, NULL, 'O', 0, 5, 3786),
(59625, '新欧宝赛飞利', NULL, 5373, 0, NULL, 'O', 0, 5, 3838),
(59624, '1.8L MTA', NULL, 5372, 0, NULL, 'O', 0, 5, 3839),
(59623, '1.8L MT', NULL, 5372, 0, NULL, 'O', 0, 5, 3785),
(59622, '1.4T 五座舒适型', NULL, 5371, 0, NULL, 'O', 0, 5, 104918),
(59621, '1.4T 七座豪华型', NULL, 5371, 0, NULL, 'O', 0, 5, 103541),
(59620, '2.2L', NULL, 5370, 0, NULL, 'O', 0, 5, 8902),
(59619, '2.0L', NULL, 5370, 0, NULL, 'O', 0, 5, 6845),
(59618, '欧捷利1.2MT', NULL, 5369, 0, NULL, 'O', 0, 5, 3783),
(59617, 'GT', NULL, 5368, 0, NULL, 'O', 0, 5, 7302),
(59616, '1.4T 舒适型', NULL, 5367, 0, NULL, 'O', 0, 5, 105740),
(59615, '1.4T 豪华型', NULL, 5367, 0, NULL, 'O', 0, 5, 105739),
(59614, '3.2L 手自一体', NULL, 5366, 0, NULL, 'O', 0, 5, 109801),
(59613, '2.4', NULL, 5366, 0, NULL, 'O', 0, 5, 7131),
(59612, '2.4L 手自一体版', NULL, 5365, 0, NULL, 'O', 0, 5, 11220),
(59611, '2.4  两驱 舒适版', NULL, 5364, 0, NULL, 'O', 0, 5, 13258),
(59610, '2.4 四驱 舒适版', NULL, 5364, 0, NULL, 'O', 0, 5, 13257),
(59609, '2.4 两驱 豪华版', NULL, 5364, 0, NULL, 'O', 0, 5, 13256),
(59608, '2.4 四驱 豪华版', NULL, 5364, 0, NULL, 'O', 0, 5, 13255),
(59607, '2.4L 手自一体 两驱 舒适版', NULL, 5363, 0, NULL, 'O', 0, 5, 101132),
(59606, '2.4L 手自一体 四驱 舒适版', NULL, 5363, 0, NULL, 'O', 0, 5, 101131),
(59605, '2.4L 手自一体 两驱 豪华版', NULL, 5363, 0, NULL, 'O', 0, 5, 101129),
(59604, '2.4L 手自一体 四驱 豪华版', NULL, 5363, 0, NULL, 'O', 0, 5, 101128),
(59603, '2.4L 手自一体 四驱 豪华版', NULL, 5362, 0, NULL, 'O', 0, 5, 104229),
(59602, '2.4L 手自一体 两驱 豪华版', NULL, 5362, 0, NULL, 'O', 0, 5, 104228),
(59601, '2.4L 手自一体 四驱 舒适版', NULL, 5362, 0, NULL, 'O', 0, 5, 104227),
(59600, '2.4L 手自一体 两驱 舒适版', NULL, 5362, 0, NULL, 'O', 0, 5, 104226),
(59599, '3.7 V6 VTEC', NULL, 5361, 0, NULL, 'O', 0, 5, 109800),
(59598, '3.7L 手自一体', NULL, 5360, 0, NULL, 'O', 0, 5, 15166),
(59597, '2.3 标准版', NULL, 5359, 0, NULL, 'O', 0, 5, 109621),
(59596, '炫航版', NULL, 5358, 0, NULL, 'O', 0, 5, 5733),
(59595, '标准版', NULL, 5358, 0, NULL, 'O', 0, 5, 5732),
(59594, '3.5标准版', NULL, 5357, 0, NULL, 'O', 0, 5, 7340),
(59593, '豪华运动版', NULL, 5356, 0, NULL, 'O', 0, 5, 8523),
(59592, '炫速版', NULL, 5355, 0, NULL, 'O', 0, 5, 10909),
(59591, '尊贵版', NULL, 5355, 0, NULL, 'O', 0, 5, 10908),
(59590, '3.5L 手自一体', NULL, 5354, 0, NULL, 'O', 0, 5, 14918),
(59589, '3.5L 自动', NULL, 5353, 0, NULL, 'O', 0, 5, 103169),
(59588, '3.5L 手自一体', NULL, 5352, 0, NULL, 'O', 0, 5, 5735),
(59587, '3.7L 手自一体', NULL, 5351, 0, NULL, 'O', 0, 5, 7041),
(59586, '3.5L V6', NULL, 5350, 0, NULL, 'O', 0, 5, 101670),
(59585, '3.5L V6', NULL, 5349, 0, NULL, 'O', 0, 5, 104790),
(59584, '3.0L 精英版', NULL, 5349, 0, NULL, 'O', 0, 5, 104398),
(59583, '3.5 自动', NULL, 5348, 0, NULL, 'O', 0, 5, 109799),
(59582, '3.5 自动', NULL, 5347, 0, NULL, 'O', 0, 5, 109798),
(59581, '3.7 自动', NULL, 5346, 0, NULL, 'O', 0, 5, 109797),
(59580, '3.7', NULL, 5345, 0, NULL, 'O', 0, 5, 7067),
(59579, '3.7 豪华运动版', NULL, 5345, 0, NULL, 'O', 0, 5, 5723),
(59578, '舒适豪华运动版', NULL, 5344, 0, NULL, 'O', 0, 5, 10907),
(59577, '标准豪华运动版', NULL, 5344, 0, NULL, 'O', 0, 5, 10906),
(59576, '舒适版', NULL, 5344, 0, NULL, 'O', 0, 5, 10002),
(59575, '标准版', NULL, 5344, 0, NULL, 'O', 0, 5, 10001),
(59574, '尊享运动版 舒适版', NULL, 5343, 0, NULL, 'O', 0, 5, 12928),
(59573, '尊享运动版 标准版', NULL, 5343, 0, NULL, 'O', 0, 5, 12927),
(59572, '3.5L 手自一体 豪华型', NULL, 5342, 0, NULL, 'O', 0, 5, 106020),
(59571, '3.5L 手自一体 精英版', NULL, 5342, 0, NULL, 'O', 0, 5, 104412),
(59570, '2.0L 精锐版', NULL, 5341, 0, NULL, 'O', 0, 5, 105167),
(59569, '1.5L CVT 混合动力', NULL, 5341, 0, NULL, 'O', 0, 5, 102302),
(59568, '1.8T 手自一体 新创型', NULL, 5340, 0, NULL, 'N', 0, 5, 110907),
(59567, '1.8T 手自一体 魅力型', NULL, 5340, 0, NULL, 'N', 0, 5, 110906),
(59566, '1.8T 手自一体 时尚型', NULL, 5340, 0, NULL, 'N', 0, 5, 110905),
(59565, '1.8T 手自一体 智尊型', NULL, 5340, 0, NULL, 'N', 0, 5, 110904),
(59564, '2.0T 手自一体 时尚型', NULL, 5340, 0, NULL, 'N', 0, 5, 110260),
(59563, '2.0T 手自一体 智尊型', NULL, 5340, 0, NULL, 'N', 0, 5, 110259),
(59562, '1.8T 手自一体 台湾版', NULL, 5340, 0, NULL, 'N', 0, 5, 110251),
(59561, '2.0T 手自一体 旗舰型', NULL, 5340, 0, NULL, 'N', 0, 5, 106113),
(59560, '2.2T 手自一体 两驱 旗舰型', NULL, 5339, 0, NULL, 'N', 0, 5, 100023),
(59559, '2.2T 手自一体 四驱 旗舰型', NULL, 5339, 0, NULL, 'N', 0, 5, 14606),
(59558, '2.2T 手自一体 四驱 智尊型', NULL, 5339, 0, NULL, 'N', 0, 5, 14605),
(59557, '2.2T 手自一体 两驱 智慧型', NULL, 5339, 0, NULL, 'N', 0, 5, 14604),
(59556, '2.0T 手自一体 两驱 新创型', NULL, 5339, 0, NULL, 'N', 0, 5, 14602),
(59555, '2.2T 手自一体 两驱 新创型', NULL, 5339, 0, NULL, 'N', 0, 5, 13253),
(59554, '锋芒限量版 2.2T 手自一体 四驱 旗舰型', NULL, 5338, 0, NULL, 'N', 0, 5, 102062),
(59553, '锋芒限量版 2.2T 手自一体 四驱 智尊型', NULL, 5338, 0, NULL, 'N', 0, 5, 102061),
(59552, '锋芒限量版 2.2T 手自一体 两驱 智慧型 ', NULL, 5338, 0, NULL, 'N', 0, 5, 102060),
(59551, '锋芒限量版 2.2T 手自一体 四驱 旗舰型', NULL, 5337, 0, NULL, 'N', 0, 5, 103928),
(59550, '锋芒限量版 2.2T 手自一体 四驱 智尊型', NULL, 5337, 0, NULL, 'N', 0, 5, 103927),
(59549, '锋芒限量版 2.2T 手自一体 两驱 智慧型 ', NULL, 5337, 0, NULL, 'N', 0, 5, 103925),
(59548, '2.2T 手自一体 两驱 智慧型', NULL, 5336, 0, NULL, 'N', 0, 5, 110721),
(59547, '2.2T 手自一体 四驱 旗舰型', NULL, 5336, 0, NULL, 'N', 0, 5, 110716),
(59546, '2.2T 手自一体 四驱 智尊型', NULL, 5336, 0, NULL, 'N', 0, 5, 110647),
(59545, '荣耀典藏版 2.2T 手自一体 两驱', NULL, 5336, 0, NULL, 'N', 0, 5, 110055),
(59544, '超级锋芒版 2.2T 手自一体', NULL, 5336, 0, NULL, 'N', 0, 5, 105868),
(59543, '2.0T 手自一体 旗舰型', NULL, 5335, 0, NULL, 'N', 0, 5, 104331),
(59542, '2.0T 手自一体 行政型', NULL, 5335, 0, NULL, 'N', 0, 5, 104330),
(59541, '2.0T 手自一体 豪华型', NULL, 5335, 0, NULL, 'N', 0, 5, 104329),
(59540, '2.0T 手自一体 商务型', NULL, 5335, 0, NULL, 'N', 0, 5, 104328),
(59539, '2.0T 手自一体 精英型', NULL, 5335, 0, NULL, 'N', 0, 5, 103567),
(59538, '2.2T 手自一体 旗舰版', NULL, 5334, 0, NULL, 'N', 0, 5, 102221),
(59537, '2.2T 手自一体 行政版', NULL, 5334, 0, NULL, 'N', 0, 5, 102151),
(59536, '2.0T 自动 旗舰型', NULL, 5333, 0, NULL, 'N', 0, 5, 104641),
(59535, '1.8T 自动 旗舰型', NULL, 5333, 0, NULL, 'N', 0, 5, 104640),
(59534, '1.8T 自动 尊贵型', NULL, 5333, 0, NULL, 'N', 0, 5, 104639),
(59533, '1.8T 自动 豪华型', NULL, 5333, 0, NULL, 'N', 0, 5, 104638),
(59532, '1.8T 手动 经典型', NULL, 5333, 0, NULL, 'N', 0, 5, 104637),
(59531, '1.8T 手动 精致型', NULL, 5333, 0, NULL, 'N', 0, 5, 104635),
(59530, '荣耀导航版 1.8T 自动 旗舰型', NULL, 5332, 0, NULL, 'N', 0, 5, 110099),
(59529, '荣耀导航版 1.8T 自动 尊贵型', NULL, 5332, 0, NULL, 'N', 0, 5, 110098),
(59528, '荣耀导航版 1.8T 自动 豪华型', NULL, 5332, 0, NULL, 'N', 0, 5, 110097),
(59527, '荣耀导航版 1.8T 手动 经典型', NULL, 5332, 0, NULL, 'N', 0, 5, 110096),
(59526, '荣耀导航版 1.8T 手动 精致型', NULL, 5332, 0, NULL, 'N', 0, 5, 110095),
(59525, '荣耀导航版 2.0T 自动 旗舰型', NULL, 5332, 0, NULL, 'N', 0, 5, 110092),
(59524, '1.8T 自动 精致型', NULL, 5332, 0, NULL, 'N', 0, 5, 106282),
(59523, '3.7L 4座', NULL, 5331, 0, NULL, 'M', 0, 5, 104892),
(59522, '3.7L 2座', NULL, 5331, 0, NULL, 'M', 0, 5, 104890),
(59521, '4.8L 自动 基本型', NULL, 5330, 0, NULL, 'M', 0, 5, 104502),
(59520, '1.6L 手动 Sport 2座', NULL, 5329, 0, NULL, 'M', 0, 5, 106658),
(59519, '超级干燥版', NULL, 5328, 0, NULL, 'M', 0, 5, 111114),
(59518, '布鲁克兰限量版', NULL, 5328, 0, NULL, 'M', 0, 5, 111113),
(59517, '标准版', NULL, 5328, 0, NULL, 'M', 0, 5, 111102),
(59516, 'MP4-12C', NULL, 5327, 0, NULL, 'M', 0, 5, 101911),
(59515, 'MP4-12C SPIDER 50周年纪念版', NULL, 5326, 0, NULL, 'M', 0, 5, 109927),
(59514, 'MP4-12C COUPE 50周年纪念版', NULL, 5326, 0, NULL, 'M', 0, 5, 109926),
(59513, 'MP4-12C SPIDER', NULL, 5326, 0, NULL, 'M', 0, 5, 105852),
(59512, 'MP4-12C COUPE', NULL, 5326, 0, NULL, 'M', 0, 5, 105851),
(59511, '3.8T Spider', NULL, 5325, 0, NULL, 'M', 0, 5, 110989),
(59510, '3.8T Coupe', NULL, 5325, 0, NULL, 'M', 0, 5, 110012),
(59509, 'collezione cento', NULL, 5324, 0, NULL, 'M', 0, 5, 4612),
(59508, 'GT', NULL, 5324, 0, NULL, 'M', 0, 5, 3641),
(59507, 'Quattroporte 4.2L 标准版', NULL, 5323, 0, NULL, 'M', 0, 5, 8957),
(59506, '行 政 版', NULL, 5323, 0, NULL, 'M', 0, 5, 3646),
(59505, '4.7 行政版', NULL, 5322, 0, NULL, 'M', 0, 5, 7079),
(59504, '4.2 精英版', NULL, 5322, 0, NULL, 'M', 0, 5, 7078),
(59503, '行政版', NULL, 5321, 0, NULL, 'M', 0, 5, 7245),
(59502, '精英版', NULL, 5321, 0, NULL, 'M', 0, 5, 7244),
(59501, '4.7 运动版', NULL, 5321, 0, NULL, 'M', 0, 5, 3642),
(59500, '全球荣誉版', NULL, 5320, 0, NULL, 'M', 0, 5, 104101),
(59499, '3.0T 标准型', NULL, 5319, 0, NULL, 'M', 0, 5, 104795),
(59498, '3.8T 标准型', NULL, 5319, 0, NULL, 'M', 0, 5, 103300),
(59497, 'spyder', NULL, 5318, 0, NULL, 'M', 0, 5, 6507),
(59496, 'S Automatic', NULL, 5317, 0, NULL, 'M', 0, 5, 9267),
(59495, 'S', NULL, 5317, 0, NULL, 'M', 0, 5, 9266),
(59494, '4.2', NULL, 5317, 0, NULL, 'M', 0, 5, 4269),
(59493, 'MC Stradale', NULL, 5316, 0, NULL, 'M', 0, 5, 105236),
(59492, 'Sport Automatic', NULL, 5315, 0, NULL, 'M', 0, 5, 102733),
(59491, 'Sport F1', NULL, 5315, 0, NULL, 'M', 0, 5, 102730),
(59490, '3.0T 手自一体 S Q4', NULL, 5314, 0, NULL, 'M', 0, 5, 106510),
(59489, '3.0T 手自一体 S', NULL, 5314, 0, NULL, 'M', 0, 5, 106509),
(59488, '3.0T 手自一体', NULL, 5314, 0, NULL, 'M', 0, 5, 106139),
(59487, '4.7 Automatic', NULL, 5313, 0, NULL, 'M', 0, 5, 10905),
(59486, '4.7 Sport', NULL, 5312, 0, NULL, 'M', 0, 5, 105364),
(59485, 'Coupe双门跑车', NULL, 5311, 0, NULL, 'M', 0, 5, 4270),
(59484, 'GranSport敞篷跑车', NULL, 5310, 0, NULL, 'M', 0, 5, 4268),
(59483, 'GranSport双门跑车', NULL, 5310, 0, NULL, 'M', 0, 5, 4267),
(59482, '62S', NULL, 5309, 0, NULL, 'M', 0, 5, 8709),
(59481, '5.5T', NULL, 5308, 0, NULL, 'M', 0, 5, 3524),
(59480, '6.0T 齐柏林', NULL, 5307, 0, NULL, 'M', 0, 5, 9233),
(59479, '5.5L', NULL, 5306, 0, NULL, 'M', 0, 5, 11438),
(59478, '57S', NULL, 5305, 0, NULL, 'M', 0, 5, 11969),
(59477, '5.5 T', NULL, 5304, 0, NULL, 'M', 0, 5, 3523),
(59476, '1.6T JCW ALL 4', NULL, 5303, 0, NULL, 'M', 0, 5, 104514),
(59475, '1.6T JCW', NULL, 5302, 0, NULL, 'M', 0, 5, 104515),
(59474, '1.6T JCW', NULL, 5301, 0, NULL, 'M', 0, 5, 104512),
(59473, '1.6T JCW All 4', NULL, 5300, 0, NULL, 'M', 0, 5, 104513),
(59472, '1.6T JCW', NULL, 5299, 0, NULL, 'M', 0, 5, 104511),
(59471, 'COOPER S 1.6L 自动', NULL, 5298, 0, NULL, 'M', 0, 5, 16074),
(59470, 'COOPER 1.6L 自动', NULL, 5298, 0, NULL, 'M', 0, 5, 15834),
(59469, '1.6L COOPER', NULL, 5297, 0, NULL, 'M', 0, 5, 103407),
(59468, '1.6T COOPER S ALL4', NULL, 5297, 0, NULL, 'M', 0, 5, 103308),
(59467, 'COOPER S', NULL, 5296, 0, NULL, 'M', 0, 5, 16075),
(59466, 'COOPER', NULL, 5296, 0, NULL, 'M', 0, 5, 16061),
(59465, 'COOPER Fun', NULL, 5295, 0, NULL, 'M', 0, 5, 13688),
(59464, 'ONE', NULL, 5295, 0, NULL, 'M', 0, 5, 13687),
(59463, 'COOPER S All 4', NULL, 5295, 0, NULL, 'M', 0, 5, 12976),
(59462, 'COOPER Excitement', NULL, 5295, 0, NULL, 'M', 0, 5, 12974),
(59461, 'COOPER S', NULL, 5294, 0, NULL, 'M', 0, 5, 101685),
(59460, 'COOPER All 4 Excitement', NULL, 5293, 0, NULL, 'M', 0, 5, 106100),
(59459, 'COOPER All 4 Fun', NULL, 5293, 0, NULL, 'M', 0, 5, 106099),
(59458, 'COOPER S All 4 滑雪版', NULL, 5293, 0, NULL, 'M', 0, 5, 102785),
(59457, 'Clubman Excitement', NULL, 5292, 0, NULL, 'M', 0, 5, 8646),
(59456, 'S Clubman', NULL, 5292, 0, NULL, 'M', 0, 5, 6870),
(59455, 'Clubman Fun', NULL, 5292, 0, NULL, 'M', 0, 5, 5537),
(59454, 'Cheer', NULL, 5291, 0, NULL, 'M', 0, 5, 9692),
(59453, '50周年纪念 COOPER Hampton版', NULL, 5290, 0, NULL, 'M', 0, 5, 14222),
(59452, '50周年纪念 COOPER S Hampton版', NULL, 5290, 0, NULL, 'M', 0, 5, 14221),
(59451, 'COOPER S', NULL, 5290, 0, NULL, 'M', 0, 5, 12385),
(59450, 'COOPER Excitement', NULL, 5290, 0, NULL, 'M', 0, 5, 12384),
(59449, 'COOPER Fun', NULL, 5290, 0, NULL, 'M', 0, 5, 12383),
(59448, 'ONE', NULL, 5290, 0, NULL, 'M', 0, 5, 12382),
(59447, '1.6T COOPER S 中国任务版', NULL, 5289, 0, NULL, 'M', 0, 5, 102762),
(59446, 'COOPER S Fun', NULL, 5289, 0, NULL, 'M', 0, 5, 101686),
(59445, '1.6 Cooper Cabrio', NULL, 5288, 0, NULL, 'M', 0, 5, 11095),
(59444, 'COOPER S CABRIO', NULL, 5287, 0, NULL, 'M', 0, 5, 100178),
(59443, 'S Cabrio', NULL, 5287, 0, NULL, 'M', 0, 5, 8645),
(59442, 'Cabrio', NULL, 5287, 0, NULL, 'M', 0, 5, 3361),
(59441, 'COOPER S CABRIO', NULL, 5286, 0, NULL, 'M', 0, 5, 12381),
(59440, 'COOPER CABRIO', NULL, 5286, 0, NULL, 'M', 0, 5, 12380),
(59439, '1.6 Cooper', NULL, 5285, 0, NULL, 'M', 0, 5, 11094),
(59438, 'Excitement', NULL, 5284, 0, NULL, 'M', 0, 5, 8643),
(59437, 'Fun', NULL, 5284, 0, NULL, 'M', 0, 5, 3360),
(59436, 'S', NULL, 5283, 0, NULL, 'M', 0, 5, 6869),
(59435, 'COOPER Fun', NULL, 5282, 0, NULL, 'M', 0, 5, 100088),
(59434, 'S Camden', NULL, 5282, 0, NULL, 'M', 0, 5, 10768),
(59433, 'Mayfair', NULL, 5282, 0, NULL, 'M', 0, 5, 10280),
(59432, 'Cheer', NULL, 5282, 0, NULL, 'M', 0, 5, 9691),
(59431, 'COOPER Excitement', NULL, 5281, 0, NULL, 'M', 0, 5, 12379),
(59430, 'COOPER Fun', NULL, 5281, 0, NULL, 'M', 0, 5, 12378),
(59429, 'COOPER S', NULL, 5281, 0, NULL, 'M', 0, 5, 12376),
(59428, 'ONE', NULL, 5281, 0, NULL, 'M', 0, 5, 12375),
(59427, 'COOPER S Fun', NULL, 5280, 0, NULL, 'M', 0, 5, 103261),
(59426, 'GOODWOOD', NULL, 5280, 0, NULL, 'M', 0, 5, 101679),
(59425, 'COOPER S 敞篷 Highgate', NULL, 5280, 0, NULL, 'M', 0, 5, 101678),
(59424, 'COOPER 敞篷 Highgate', NULL, 5280, 0, NULL, 'M', 0, 5, 101677),
(59423, 'COOPER S Bayswater', NULL, 5280, 0, NULL, 'M', 0, 5, 101676),
(59422, 'COOPER Bayswater', NULL, 5280, 0, NULL, 'M', 0, 5, 101675),
(59421, '1.6L 中国奥林匹克纪念版', NULL, 5280, 0, NULL, 'M', 0, 5, 101674),
(59420, 'COOPER Baker Street', NULL, 5280, 0, NULL, 'M', 0, 5, 101673),
(59419, 'ONE Baker Street', NULL, 5280, 0, NULL, 'M', 0, 5, 101672),
(59418, 'ONE 限量版第三款', NULL, 5279, 0, NULL, 'M', 0, 5, 104576),
(59417, 'ONE 限量版第二款', NULL, 5279, 0, NULL, 'M', 0, 5, 104575),
(59416, 'ONE 限量版第一款', NULL, 5279, 0, NULL, 'M', 0, 5, 104574),
(59415, '1.2T ONE', NULL, 5278, 0, NULL, 'M', 0, 5, 110948),
(59414, '1.2T ONE+', NULL, 5278, 0, NULL, 'M', 0, 5, 110947),
(59413, '1.5T COOPER Fun', NULL, 5278, 0, NULL, 'M', 0, 5, 110946),
(59412, '1.5T COOPER Excitement', NULL, 5278, 0, NULL, 'M', 0, 5, 110945),
(59411, '2.0T COOPER S Fun', NULL, 5278, 0, NULL, 'M', 0, 5, 110944),
(59410, '2.0T COOPER S Excitement', NULL, 5278, 0, NULL, 'M', 0, 5, 110943),
(59409, '1.8 MT', NULL, 5277, 0, NULL, 'M', 0, 5, 5661),
(59408, '1.8 手动 标准版', NULL, 5276, 0, NULL, 'M', 0, 5, 106873),
(59407, '1.8 CVT', NULL, 5276, 0, NULL, 'M', 0, 5, 5660),
(59406, '1.8T 手动', NULL, 5275, 0, NULL, 'M', 0, 5, 108615),
(59405, '2.5 自动 加长型', NULL, 5274, 0, NULL, 'M', 0, 5, 108616),
(59404, '1.8 手动 舒适版', NULL, 5274, 0, NULL, 'M', 0, 5, 108614),
(59403, '1.8 手动 豪华运动版', NULL, 5274, 0, NULL, 'M', 0, 5, 108613),
(59402, '1.8T 手动 舒适版', NULL, 5274, 0, NULL, 'M', 0, 5, 106872),
(59401, '1.8 手动 豪华版', NULL, 5274, 0, NULL, 'M', 0, 5, 106871),
(59400, '1.8T 手动 豪华运动版', NULL, 5274, 0, NULL, 'M', 0, 5, 106870),
(59399, '1.8T 手动 豪华版', NULL, 5274, 0, NULL, 'M', 0, 5, 106869),
(59398, '2.5 自动 旗舰型', NULL, 5274, 0, NULL, 'M', 0, 5, 106866),
(59397, '1.8T 自动 加长版', NULL, 5273, 0, NULL, 'M', 0, 5, 108619),
(59396, '2.5 自动 豪华型', NULL, 5273, 0, NULL, 'M', 0, 5, 108618),
(59395, '2.5 自动 加长型', NULL, 5273, 0, NULL, 'M', 0, 5, 108617),
(59394, '1.8 手动 精英版', NULL, 5273, 0, NULL, 'M', 0, 5, 106868),
(59393, '1.8T 手动 精英版', NULL, 5273, 0, NULL, 'M', 0, 5, 106867),
(59392, 'L 行政版', NULL, 5273, 0, NULL, 'M', 0, 5, 10608),
(59391, 'MG7L精英版', NULL, 5273, 0, NULL, 'M', 0, 5, 5039),
(59390, 'MG7豪华版', NULL, 5273, 0, NULL, 'M', 0, 5, 4704),
(59389, 'MG7豪华运动版', NULL, 5273, 0, NULL, 'M', 0, 5, 3194),
(59388, 'L 1.8T 豪华版', NULL, 5272, 0, NULL, 'M', 0, 5, 8783),
(59387, 'L 1.8T 舒适版', NULL, 5272, 0, NULL, 'M', 0, 5, 8782),
(59386, 'AT 超豪华版', NULL, 5272, 0, NULL, 'M', 0, 5, 6958),
(59385, 'AT 豪华版', NULL, 5272, 0, NULL, 'M', 0, 5, 6957),
(59384, 'AT 舒适版', NULL, 5272, 0, NULL, 'M', 0, 5, 6956),
(59383, 'L 2.5 豪华版', NULL, 5272, 0, NULL, 'M', 0, 5, 5040),
(59382, 'MT 精英版', NULL, 5272, 0, NULL, 'M', 0, 5, 4847),
(59381, 'MT 舒适版', NULL, 5272, 0, NULL, 'M', 0, 5, 3195),
(59380, 'L 2.5 旗舰版', NULL, 5272, 0, NULL, 'M', 0, 5, 3190),
(59379, 'L 2.5 旗舰版', NULL, 5271, 0, NULL, 'M', 0, 5, 11301),
(59378, 'L 2.5 豪华版', NULL, 5271, 0, NULL, 'M', 0, 5, 11300),
(59377, 'L 1.8T 豪华版', NULL, 5271, 0, NULL, 'M', 0, 5, 11299),
(59376, 'L 1.8T 舒适版', NULL, 5271, 0, NULL, 'M', 0, 5, 11298),
(59375, 'AT 豪华版', NULL, 5271, 0, NULL, 'M', 0, 5, 11297),
(59374, 'AT 精英版', NULL, 5271, 0, NULL, 'M', 0, 5, 11296),
(59373, 'AT 舒适版', NULL, 5271, 0, NULL, 'M', 0, 5, 11295),
(59372, 'MT 舒适版', NULL, 5271, 0, NULL, 'M', 0, 5, 11294),
(59371, 'Saloon 1.8T 自动 豪华版', NULL, 5270, 0, NULL, 'M', 0, 5, 12843),
(59370, 'Saloon 1.8T 自动 精英版', NULL, 5270, 0, NULL, 'M', 0, 5, 12842),
(59369, 'Saloon 1.8T 手动 精英版', NULL, 5270, 0, NULL, 'M', 0, 5, 12837),
(59368, 'Saloon 1.8 DVVT 自动 精英版', NULL, 5270, 0, NULL, 'M', 0, 5, 12836),
(59367, 'Saloon 1.8 DVVT 自动 舒适版', NULL, 5270, 0, NULL, 'M', 0, 5, 12835),
(59366, 'Saloon 1.8 DVVT 手动 舒适版', NULL, 5270, 0, NULL, 'M', 0, 5, 12834),
(59365, '1.8T 自动 性能版', NULL, 5269, 0, NULL, 'M', 0, 5, 102335),
(59364, '1.8T 手动 性能版', NULL, 5269, 0, NULL, 'M', 0, 5, 102331),
(59363, 'Magnette 1.8DVVT 自动 运动超值版', NULL, 5269, 0, NULL, 'M', 0, 5, 15386),
(59362, 'Magnette 1.8DVVT 手动 运动超值版', NULL, 5269, 0, NULL, 'M', 0, 5, 15385),
(59361, 'Magnette 1.8T 自动 豪华版', NULL, 5269, 0, NULL, 'M', 0, 5, 14667),
(59360, 'Magnette 1.8T 自动 精英版', NULL, 5269, 0, NULL, 'M', 0, 5, 14666),
(59359, 'Magnette 1.8T 手动 精英版', NULL, 5269, 0, NULL, 'M', 0, 5, 14665),
(59358, 'Magnette 1.8DVVT 自动 精英版', NULL, 5269, 0, NULL, 'M', 0, 5, 14664),
(59357, 'Magnette 1.8DVVT 自动 舒适版', NULL, 5269, 0, NULL, 'M', 0, 5, 14663),
(59356, 'Magnette 1.8DVVT 手动 舒适版', NULL, 5269, 0, NULL, 'M', 0, 5, 14662),
(59355, '1.8T 自动 豪华版', NULL, 5268, 0, NULL, 'M', 0, 5, 102337),
(59354, '1.8T 自动 精英版', NULL, 5268, 0, NULL, 'M', 0, 5, 102336),
(59353, '1.8T 手动 精英版', NULL, 5268, 0, NULL, 'M', 0, 5, 102333),
(59352, '1.8L 自动 精英版', NULL, 5268, 0, NULL, 'M', 0, 5, 102332),
(59351, '1.8L 自动 超值版', NULL, 5268, 0, NULL, 'M', 0, 5, 102330),
(59350, '1.8L 手动 超值版', NULL, 5268, 0, NULL, 'M', 0, 5, 102329),
(59349, '1.8L 自动 舒适版', NULL, 5268, 0, NULL, 'M', 0, 5, 102327),
(59348, '1.8L 手动 舒适版', NULL, 5268, 0, NULL, 'M', 0, 5, 102324),
(59347, '1.8DVVT 世博版 手自一体', NULL, 5267, 0, NULL, 'M', 0, 5, 11293),
(59346, '1.8DVVT 世博版 手动', NULL, 5267, 0, NULL, 'M', 0, 5, 11292),
(59345, '1.8T 豪华版', NULL, 5267, 0, NULL, 'M', 0, 5, 9904),
(59344, '1.8T 精英版', NULL, 5267, 0, NULL, 'M', 0, 5, 9903),
(59343, '1.8T 舒适版', NULL, 5267, 0, NULL, 'M', 0, 5, 9902),
(59342, '1.8DVVT 精英版', NULL, 5267, 0, NULL, 'M', 0, 5, 9901),
(59341, '1.8DVVT 舒适版', NULL, 5267, 0, NULL, 'M', 0, 5, 9900),
(59340, '1.8T 自动 豪华版', NULL, 5266, 0, NULL, 'M', 0, 5, 14652),
(59339, '1.8T 自动 精英版', NULL, 5266, 0, NULL, 'M', 0, 5, 14650),
(59338, '1.8T 手动 舒适版', NULL, 5266, 0, NULL, 'M', 0, 5, 14647),
(59337, '1.8DVVT 自动 精英版', NULL, 5266, 0, NULL, 'M', 0, 5, 14645),
(59336, '1.8DVVT 自动 驾值版', NULL, 5266, 0, NULL, 'M', 0, 5, 14643),
(59335, '1.8DVVT 手动 驾值版', NULL, 5266, 0, NULL, 'M', 0, 5, 14642),
(59334, '1.8DVVT 自动 舒适版', NULL, 5266, 0, NULL, 'M', 0, 5, 14641),
(59333, '1.8DVVT 手动 舒适版', NULL, 5266, 0, NULL, 'M', 0, 5, 14640),
(59332, '1.8T AT 豪华版', NULL, 5265, 0, NULL, 'M', 0, 5, 102323),
(59331, '1.8T AT 精英版', NULL, 5265, 0, NULL, 'M', 0, 5, 102322),
(59330, '1.8T AT GT超值版', NULL, 5265, 0, NULL, 'M', 0, 5, 102321),
(59329, '1.8T MT GT超值版', NULL, 5265, 0, NULL, 'M', 0, 5, 102319),
(59328, '1.8L AT 精英版', NULL, 5265, 0, NULL, 'M', 0, 5, 102318),
(59327, '1.8L AT 驾值版', NULL, 5265, 0, NULL, 'M', 0, 5, 102317),
(59326, '1.8L MT 驾值版', NULL, 5265, 0, NULL, 'M', 0, 5, 102316),
(59325, '1.8L MT舒适版', NULL, 5265, 0, NULL, 'M', 0, 5, 102313),
(59324, '1.8T TST 豪华版', NULL, 5264, 0, NULL, 'M', 0, 5, 105182),
(59323, '1.8T TST 精英版', NULL, 5264, 0, NULL, 'M', 0, 5, 105181),
(59322, '1.8T TST 性能版', NULL, 5264, 0, NULL, 'M', 0, 5, 105180),
(59321, '1.8L TST 驾值版', NULL, 5264, 0, NULL, 'M', 0, 5, 105179),
(59320, '1.8T MT 性能版', NULL, 5264, 0, NULL, 'M', 0, 5, 105178),
(59319, '1.8L MT 驾值版', NULL, 5264, 0, NULL, 'M', 0, 5, 105177),
(59318, '1.8L MT 舒适版', NULL, 5264, 0, NULL, 'M', 0, 5, 105176),
(59317, '1.5L 自动 精英版 inkaNet', NULL, 5263, 0, NULL, 'M', 0, 5, 100268),
(59316, '1.5L 手动 风尚版 inkaNet', NULL, 5263, 0, NULL, 'M', 0, 5, 100265),
(59315, '1.5L 手动 风尚版', NULL, 5263, 0, NULL, 'M', 0, 5, 16325),
(59314, '1.5L 自动 精英版', NULL, 5263, 0, NULL, 'M', 0, 5, 16323),
(59313, '1.5L 自动 领航版 inkaNet', NULL, 5262, 0, NULL, 'M', 0, 5, 100270),
(59312, '1.5L 自动 豪华版 inkaNet', NULL, 5262, 0, NULL, 'M', 0, 5, 100269),
(59311, '1.5L 手动 豪华版 inkaNet', NULL, 5262, 0, NULL, 'M', 0, 5, 100267),
(59310, '1.5L 手动 精英版 inkaNet', NULL, 5262, 0, NULL, 'M', 0, 5, 100266),
(59309, '1.5L 手动 精英版', NULL, 5262, 0, NULL, 'M', 0, 5, 16324),
(59308, '1.5L 手动 豪华版', NULL, 5262, 0, NULL, 'M', 0, 5, 16322),
(59307, '1.5L 自动 豪华版', NULL, 5262, 0, NULL, 'M', 0, 5, 16321),
(59306, '1.5L 自动 领航版', NULL, 5262, 0, NULL, 'M', 0, 5, 15769),
(59305, '1.5T 手动 豪华型', NULL, 5261, 0, NULL, 'M', 0, 5, 111162),
(59304, '1.5T 自动 旗舰型 inkaNet', NULL, 5261, 0, NULL, 'M', 0, 5, 110941),
(59303, '1.5T 自动 豪华型 inkaNet', NULL, 5261, 0, NULL, 'M', 0, 5, 110940),
(59302, '1.5T 自动 旗舰型', NULL, 5261, 0, NULL, 'M', 0, 5, 106280),
(59301, '1.5T 自动 豪华型', NULL, 5261, 0, NULL, 'M', 0, 5, 106278),
(59300, '1.8L CVT豪华', NULL, 5260, 0, NULL, 'M', 0, 5, 5783),
(59299, '1.8L CVT舒适', NULL, 5260, 0, NULL, 'M', 0, 5, 5782),
(59298, '1.4L MT豪华', NULL, 5260, 0, NULL, 'M', 0, 5, 5781),
(59297, '1.4L MT舒适', NULL, 5260, 0, NULL, 'M', 0, 5, 5780),
(59296, '1.4L CVT舒适', NULL, 5259, 0, NULL, 'M', 0, 5, 10796),
(59295, '1.4L CVT豪华', NULL, 5259, 0, NULL, 'M', 0, 5, 9506),
(59294, '野酷 1.8L CVT豪华', NULL, 5259, 0, NULL, 'M', 0, 5, 9497),
(59293, '野酷 1.8L CVT舒适', NULL, 5259, 0, NULL, 'M', 0, 5, 9496),
(59292, '野酷 1.4L MT豪华', NULL, 5259, 0, NULL, 'M', 0, 5, 9495),
(59291, '野酷 1.4L MT舒适', NULL, 5259, 0, NULL, 'M', 0, 5, 9494),
(59290, '1.5L 自动 Xross 豪华版', NULL, 5258, 0, NULL, 'M', 0, 5, 14308),
(59289, '1.5L 手动 Xross 精英版', NULL, 5258, 0, NULL, 'M', 0, 5, 14307),
(59288, '1.3L 手动 舒适版', NULL, 5258, 0, NULL, 'M', 0, 5, 13211),
(59287, '1.3L 自动 舒适版', NULL, 5258, 0, NULL, 'M', 0, 5, 13210),
(59286, '1.5L 自动 精英版', NULL, 5258, 0, NULL, 'M', 0, 5, 13209),
(59285, '1.5L 手动 精英版', NULL, 5258, 0, NULL, 'M', 0, 5, 12626),
(59284, '1.5L 手动 超值版', NULL, 5257, 0, NULL, 'M', 0, 5, 101590),
(59283, '1.5L 自动 豪华版', NULL, 5256, 0, NULL, 'M', 0, 5, 102569),
(59282, '1.5L 自动 精英版', NULL, 5256, 0, NULL, 'M', 0, 5, 102568),
(59281, '1.5L 手动 精英版', NULL, 5256, 0, NULL, 'M', 0, 5, 102567),
(59280, '1.5L 手动 超值版', NULL, 5256, 0, NULL, 'M', 0, 5, 102566),
(59279, '1.3L 自动 舒适版', NULL, 5256, 0, NULL, 'M', 0, 5, 102565),
(59278, '1.3L 手动 舒适版', NULL, 5256, 0, NULL, 'M', 0, 5, 102564),
(59277, '1.3L 手动 舒适版', NULL, 5255, 0, NULL, 'M', 0, 5, 106552),
(59276, '1.3L 自动 舒适版', NULL, 5255, 0, NULL, 'M', 0, 5, 106551),
(59275, '1.5L 手动 超值版', NULL, 5255, 0, NULL, 'M', 0, 5, 106550),
(59274, '1.5L 手动 精英版', NULL, 5255, 0, NULL, 'M', 0, 5, 106549),
(59273, '1.5L 自动 精英版', NULL, 5255, 0, NULL, 'M', 0, 5, 106548),
(59272, '1.5L 自动 豪华版', NULL, 5255, 0, NULL, 'M', 0, 5, 106544),
(59271, 'TM6501系列豪华型', NULL, 5254, 0, NULL, 'M', 0, 5, 4094),
(59270, 'TM6501系列标准型', NULL, 5254, 0, NULL, 'M', 0, 5, 4093),
(59269, 'TM6501系列经济型', NULL, 5254, 0, NULL, 'M', 0, 5, 4092),
(59268, 'TM6500Q 豪华一型', NULL, 5253, 0, NULL, 'M', 0, 5, 6226),
(59267, 'TM6500Q 豪华二型', NULL, 5253, 0, NULL, 'M', 0, 5, 6225),
(59266, 'TM6500Q 标准型', NULL, 5253, 0, NULL, 'M', 0, 5, 2504),
(59265, 'TM6500A选装型', NULL, 5253, 0, NULL, 'M', 0, 5, 2503),
(59264, 'TM6500A标准型', NULL, 5253, 0, NULL, 'M', 0, 5, 2502),
(59263, 'TM6500Q 标准型', NULL, 5252, 0, NULL, 'M', 0, 5, 6224),
(59262, 'TM6510Q 豪华版', NULL, 5251, 0, NULL, 'M', 0, 5, 12374),
(59261, 'TM6510Q 标准', NULL, 5251, 0, NULL, 'M', 0, 5, 12373),
(59260, 'TM6510Q 经济', NULL, 5251, 0, NULL, 'M', 0, 5, 12372),
(59259, 'TM6510Q1 豪华版', NULL, 5251, 0, NULL, 'M', 0, 5, 12371),
(59258, 'TM6510Q1 标准', NULL, 5251, 0, NULL, 'M', 0, 5, 12370),
(59257, 'TM6510Q1 经济', NULL, 5251, 0, NULL, 'M', 0, 5, 12369),
(59256, 'TM6510D 标准', NULL, 5251, 0, NULL, 'M', 0, 5, 12368),
(59255, 'TM6510D 经济', NULL, 5251, 0, NULL, 'M', 0, 5, 12367),
(59254, 'TM6500A 豪华版', NULL, 5251, 0, NULL, 'M', 0, 5, 12366),
(59253, 'TM6500A 标准', NULL, 5251, 0, NULL, 'M', 0, 5, 12365),
(59252, 'TM6500A 经济', NULL, 5251, 0, NULL, 'M', 0, 5, 12364),
(59251, 'TM6500A1 豪华版', NULL, 5251, 0, NULL, 'M', 0, 5, 12363),
(59250, 'TM6500A1 标准', NULL, 5251, 0, NULL, 'M', 0, 5, 12362),
(59249, 'TM6500A1 经济', NULL, 5251, 0, NULL, 'M', 0, 5, 12361),
(59248, '经济型', NULL, 5250, 0, NULL, 'M', 0, 5, 5203),
(59247, 'TM6480', NULL, 5249, 0, NULL, 'M', 0, 5, 4754),
(59246, 'TM1020A豪华型', NULL, 5248, 0, NULL, 'M', 0, 5, 2500),
(59245, 'TM1020A标准型', NULL, 5248, 0, NULL, 'M', 0, 5, 2499),
(59244, 'TM6490A 11座', NULL, 5247, 0, NULL, 'M', 0, 5, 2501),
(59243, 'TM1020AL2', NULL, 5246, 0, NULL, 'M', 0, 5, 12429),
(59242, 'TM1020A4', NULL, 5246, 0, NULL, 'M', 0, 5, 12427),
(59241, '2.2L 两驱(500公斤)', NULL, 5245, 0, NULL, 'M', 0, 5, 10607),
(59240, '2.0', NULL, 5244, 0, NULL, 'M', 0, 5, 8351),
(59239, 'MPV', NULL, 5243, 0, NULL, 'M', 0, 5, 6506),
(59238, '3.7L', NULL, 5242, 0, NULL, 'M', 0, 5, 9908),
(59237, '3.7L 自动基本型', NULL, 5241, 0, NULL, 'M', 0, 5, 102679),
(59236, '2.5L豪华型', NULL, 5240, 0, NULL, 'M', 0, 5, 9706),
(59235, '2.5L豪华型', NULL, 5239, 0, NULL, 'M', 0, 5, 13072),
(59234, '2.0L 手自一体 四驱 尊贵导航版', NULL, 5238, 0, NULL, 'M', 0, 5, 100316),
(59233, '2.0L 手自一体 四驱 尊贵版', NULL, 5238, 0, NULL, 'M', 0, 5, 100315),
(59232, '2.0L 手自一体 四驱 豪华导航版', NULL, 5238, 0, NULL, 'M', 0, 5, 100314),
(59231, '2.0L 手自一体 四驱 豪华版', NULL, 5238, 0, NULL, 'M', 0, 5, 100312),
(59230, '2.0L 手自一体 两驱 舒适版', NULL, 5238, 0, NULL, 'M', 0, 5, 100310),
(59229, '2.0L 自动 基本型', NULL, 5237, 0, NULL, 'M', 0, 5, 104157),
(59228, '929', NULL, 5236, 0, NULL, 'M', 0, 5, 6504),
(59227, '626', NULL, 5235, 0, NULL, 'M', 0, 5, 6503),
(59226, '2.0L 自动豪华型', NULL, 5234, 0, NULL, 'M', 0, 5, 3288),
(59225, '2.0L 自动舒适型', NULL, 5234, 0, NULL, 'M', 0, 5, 3287),
(59224, '2.0L 手动舒适型', NULL, 5234, 0, NULL, 'M', 0, 5, 3286),
(59223, '2.0L 自动 豪华型', NULL, 5233, 0, NULL, 'M', 0, 5, 12858),
(59222, '2.0L 自动 舒适型', NULL, 5233, 0, NULL, 'M', 0, 5, 12857),
(59221, '2.0L 手动 舒适型', NULL, 5233, 0, NULL, 'M', 0, 5, 12670),
(59220, '2.0L 自动 豪华型', NULL, 5232, 0, NULL, 'M', 0, 5, 104001),
(59219, '2.0L 自动 舒适型', NULL, 5232, 0, NULL, 'M', 0, 5, 104000),
(59218, '2.0L 手动 舒适型', NULL, 5232, 0, NULL, 'M', 0, 5, 103999),
(59217, '2.0L AT豪华型', NULL, 5231, 0, NULL, 'M', 0, 5, 4746),
(59216, '1.6L AT豪华型', NULL, 5231, 0, NULL, 'M', 0, 5, 4745),
(59215, '1.6L AT标准型', NULL, 5231, 0, NULL, 'M', 0, 5, 4744),
(59214, '2.0L 自动豪华型', NULL, 5230, 0, NULL, 'M', 0, 5, 9971),
(59213, '2.0L 手动豪华型', NULL, 5230, 0, NULL, 'M', 0, 5, 9970),
(59212, '1.6L 自动豪华型', NULL, 5230, 0, NULL, 'M', 0, 5, 9969),
(59211, '1.6L 手动舒适型', NULL, 5230, 0, NULL, 'M', 0, 5, 8528),
(59210, '323', NULL, 5229, 0, NULL, 'M', 0, 5, 6502),
(59209, '2.0L自动豪华型', NULL, 5228, 0, NULL, 'M', 0, 5, 7107),
(59208, '2.0L自动时尚型', NULL, 5228, 0, NULL, 'M', 0, 5, 7106),
(59207, '2.0L自动标准型', NULL, 5228, 0, NULL, 'M', 0, 5, 7105),
(59206, '2.0L手动标准型', NULL, 5228, 0, NULL, 'M', 0, 5, 7104),
(59205, '马自达（Mazda）6 2.3L自动豪华型', NULL, 5228, 0, NULL, 'M', 0, 5, 6505),
(59204, '1.3 自动', NULL, 5227, 0, NULL, 'M', 0, 5, 109796),
(59203, '6速自动型', NULL, 5226, 0, NULL, 'M', 0, 5, 5903),
(59202, '6速手动型', NULL, 5226, 0, NULL, 'M', 0, 5, 3727),
(59201, '2.5L 至尊版', NULL, 5225, 0, NULL, 'M', 0, 5, 10793),
(59200, '2.0L 豪华版', NULL, 5225, 0, NULL, 'M', 0, 5, 10792),
(59199, '2.0L 精英版', NULL, 5224, 0, NULL, 'M', 0, 5, 12865),
(59198, '2.0L 手自一体 精英版', NULL, 5223, 0, NULL, 'M', 0, 5, 100229),
(59197, '2.0L 手自一体 豪华版', NULL, 5223, 0, NULL, 'M', 0, 5, 100228),
(59196, '2.5L 手自一体 至尊版', NULL, 5223, 0, NULL, 'M', 0, 5, 100217),
(59195, '2.0L 手动', NULL, 5222, 0, NULL, 'M', 0, 5, 107249),
(59194, '2.5L 手自一体', NULL, 5221, 0, NULL, 'M', 0, 5, 108821),
(59193, '2.0L 手自一体', NULL, 5221, 0, NULL, 'M', 0, 5, 108820),
(59192, '2.5L 导航版', NULL, 5221, 0, NULL, 'M', 0, 5, 7520),
(59191, '2.5L 至尊版', NULL, 5221, 0, NULL, 'M', 0, 5, 7519),
(59190, '2.5L 尊贵版', NULL, 5221, 0, NULL, 'M', 0, 5, 6949),
(59189, '2.0L 豪华版', NULL, 5220, 0, NULL, 'M', 0, 5, 9541),
(59188, '2.0L 手动版', NULL, 5220, 0, NULL, 'M', 0, 5, 9540),
(59187, '2.0L 精英版', NULL, 5219, 0, NULL, 'M', 0, 5, 12866),
(59186, '2.5L 手自一体 至尊版', NULL, 5218, 0, NULL, 'M', 0, 5, 100227),
(59185, '2.5L 手自一体 尊贵版', NULL, 5218, 0, NULL, 'M', 0, 5, 100226),
(59184, '2.0L 手自一体 豪华版', NULL, 5218, 0, NULL, 'M', 0, 5, 100222),
(59183, '2.0L 手自一体 精英版', NULL, 5218, 0, NULL, 'M', 0, 5, 100201),
(59182, '至尊版', NULL, 5217, 0, NULL, 'M', 0, 5, 12600),
(59181, '尊贵版', NULL, 5217, 0, NULL, 'M', 0, 5, 12599),
(59180, '精英版', NULL, 5217, 0, NULL, 'M', 0, 5, 12149),
(59179, '2.5L 手自一体 至尊版', NULL, 5216, 0, NULL, 'M', 0, 5, 102553),
(59178, '2.5L 手自一体 尊贵版', NULL, 5216, 0, NULL, 'M', 0, 5, 102552),
(59177, '2.5L 手自一体 精英版', NULL, 5216, 0, NULL, 'M', 0, 5, 102541),
(59176, '2.3L 手自一体超豪华型', NULL, 5215, 0, NULL, 'M', 0, 5, 107247),
(59175, '2.3L 6MT', NULL, 5215, 0, NULL, 'M', 0, 5, 2774);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(59174, '2.3L 手自一体超豪华型', NULL, 5214, 0, NULL, 'M', 0, 5, 107248),
(59173, '2.0L 手自一体运动型', NULL, 5214, 0, NULL, 'M', 0, 5, 107246),
(59172, '2.0L 手自一体豪华型', NULL, 5214, 0, NULL, 'M', 0, 5, 107245),
(59171, '2.0L 运动型', NULL, 5213, 0, NULL, 'M', 0, 5, 5802),
(59170, '2.0L 豪华型', NULL, 5213, 0, NULL, 'M', 0, 5, 2775),
(59169, '2.3L 豪华型', NULL, 5213, 0, NULL, 'M', 0, 5, 2773),
(59168, '2.3L 手自一体多功能', NULL, 5212, 0, NULL, 'M', 0, 5, 107244),
(59167, '2.3L 自动豪华型', NULL, 5211, 0, NULL, 'M', 0, 5, 4005),
(59166, '2.0L 蓝天时尚版', NULL, 5210, 0, NULL, 'M', 0, 5, 111005),
(59165, '2.0L 蓝天豪华版', NULL, 5210, 0, NULL, 'M', 0, 5, 111004),
(59164, '2.0L 蓝天尊贵版', NULL, 5210, 0, NULL, 'M', 0, 5, 111003),
(59163, '2.5L 蓝天尊崇版', NULL, 5210, 0, NULL, 'M', 0, 5, 111002),
(59162, '2.5L 蓝天至尊版', NULL, 5210, 0, NULL, 'M', 0, 5, 110342),
(59161, '2.3L 手自一体标准型', NULL, 5209, 0, NULL, 'M', 0, 5, 108819),
(59160, '2.3L 手自一体技术型', NULL, 5209, 0, NULL, 'M', 0, 5, 107241),
(59159, '2.3L豪华型', NULL, 5209, 0, NULL, 'M', 0, 5, 2749),
(59158, '2.0L豪华型', NULL, 5208, 0, NULL, 'M', 0, 5, 2751),
(59157, '2.3L技术型', NULL, 5208, 0, NULL, 'M', 0, 5, 2750),
(59156, '2.0L 6速手动', NULL, 5207, 0, NULL, 'M', 0, 5, 2761),
(59155, '新款 2.0L 6MT', NULL, 5207, 0, NULL, 'M', 0, 5, 2757),
(59154, '新款 2.0L超豪华型', NULL, 5207, 0, NULL, 'M', 0, 5, 2756),
(59153, '新款 2.3L豪华型', NULL, 5207, 0, NULL, 'M', 0, 5, 2755),
(59152, '新款 2.3L旗舰型', NULL, 5207, 0, NULL, 'M', 0, 5, 2754),
(59151, '2.3L天窗版', NULL, 5207, 0, NULL, 'M', 0, 5, 2753),
(59150, '2.0L豪华天窗版', NULL, 5207, 0, NULL, 'M', 0, 5, 2752),
(59149, '2.0L 手动舒适型', NULL, 5206, 0, NULL, 'M', 0, 5, 108817),
(59148, '2.3L 手自一体旗舰型', NULL, 5206, 0, NULL, 'M', 0, 5, 107242),
(59147, '2.3L 手自一体豪华型', NULL, 5206, 0, NULL, 'M', 0, 5, 107240),
(59146, '2.0L 手自一体豪华型', NULL, 5206, 0, NULL, 'M', 0, 5, 107235),
(59145, '2.0L 手自一体超豪华型', NULL, 5206, 0, NULL, 'M', 0, 5, 107232),
(59144, '2.3L 手自一体旗舰型', NULL, 5205, 0, NULL, 'M', 0, 5, 107243),
(59143, '2.0L 手自一体时尚型', NULL, 5205, 0, NULL, 'M', 0, 5, 107238),
(59142, '2.0L 手自一体豪华型', NULL, 5205, 0, NULL, 'M', 0, 5, 107237),
(59141, '2.0L 手自一体超豪华型', NULL, 5205, 0, NULL, 'M', 0, 5, 107234),
(59140, '2.0L 手动标准型', NULL, 5205, 0, NULL, 'M', 0, 5, 4870),
(59139, '新款 2.0L 6速手动', NULL, 5205, 0, NULL, 'M', 0, 5, 4868),
(59138, '2.0L 标准型', NULL, 5205, 0, NULL, 'M', 0, 5, 4768),
(59137, '2.0L 手自一体时尚型', NULL, 5204, 0, NULL, 'M', 0, 5, 5801),
(59136, '2.0L 手动型', NULL, 5204, 0, NULL, 'M', 0, 5, 5379),
(59135, '2.0L 手自一体豪华型', NULL, 5204, 0, NULL, 'M', 0, 5, 2760),
(59134, '2.0L 手自一体超豪华型', NULL, 5204, 0, NULL, 'M', 0, 5, 2759),
(59133, '2.3L 手自一体旗舰型', NULL, 5204, 0, NULL, 'M', 0, 5, 2758),
(59132, '2.3L 手自一体', NULL, 5203, 0, NULL, 'M', 0, 5, 108818),
(59131, '2.0L 手自一体时尚型', NULL, 5202, 0, NULL, 'M', 0, 5, 107239),
(59130, '2.0L 手自一体豪华型', NULL, 5202, 0, NULL, 'M', 0, 5, 107236),
(59129, '2.0L 手自一体超豪华型', NULL, 5202, 0, NULL, 'M', 0, 5, 107233),
(59128, '2.0L超豪华', NULL, 5201, 0, NULL, 'M', 0, 5, 12632),
(59127, '2.0L豪华', NULL, 5201, 0, NULL, 'M', 0, 5, 12631),
(59126, '2.0L时尚', NULL, 5201, 0, NULL, 'M', 0, 5, 12630),
(59125, '2.0L手动', NULL, 5201, 0, NULL, 'M', 0, 5, 12629),
(59124, '2.0L 超豪华', NULL, 5200, 0, NULL, 'M', 0, 5, 101684),
(59123, '2.0L 时尚', NULL, 5200, 0, NULL, 'M', 0, 5, 101683),
(59122, '2.0L 手动', NULL, 5200, 0, NULL, 'M', 0, 5, 101682),
(59121, '2.0L 手动型', NULL, 5199, 0, NULL, 'M', 0, 5, 104621),
(59120, '2.0L 时尚型', NULL, 5199, 0, NULL, 'M', 0, 5, 104620),
(59119, '2.0L 超豪华型', NULL, 5199, 0, NULL, 'M', 0, 5, 104619),
(59118, '2.0L 经典型', NULL, 5198, 0, NULL, 'M', 0, 5, 110608),
(59117, '2.0L 自动 四驱 尊贵型', NULL, 5197, 0, NULL, 'M', 0, 5, 104710),
(59116, '2.5L 自动 四驱 旗舰型', NULL, 5197, 0, NULL, 'M', 0, 5, 104709),
(59115, '2.5L 自动 四驱 豪华型', NULL, 5197, 0, NULL, 'M', 0, 5, 104708),
(59114, '2.0L 自动 四驱 精英型', NULL, 5197, 0, NULL, 'M', 0, 5, 104707),
(59113, '2.0L 自动 两驱 舒适型', NULL, 5197, 0, NULL, 'M', 0, 5, 104706),
(59112, '2.0L 手动 两驱 舒适型', NULL, 5197, 0, NULL, 'M', 0, 5, 104705),
(59111, '2.0L 自动 两驱 都市型', NULL, 5196, 0, NULL, 'M', 0, 5, 110166),
(59110, '1.6L 自动 精英型', NULL, 5195, 0, NULL, 'M', 0, 5, 14757),
(59109, '1.6L 自动 舒适型', NULL, 5195, 0, NULL, 'M', 0, 5, 14755),
(59108, '1.6L 手动 舒适型', NULL, 5195, 0, NULL, 'M', 0, 5, 14753),
(59107, '2.0L 手动 运动型', NULL, 5195, 0, NULL, 'M', 0, 5, 14539),
(59106, '2.0L 自动 豪华型', NULL, 5195, 0, NULL, 'M', 0, 5, 14161),
(59105, '1.6L 手动 精英型', NULL, 5194, 0, NULL, 'M', 0, 5, 102312),
(59104, '1.6L 自动 精英型', NULL, 5194, 0, NULL, 'M', 0, 5, 102311),
(59103, '2.0L 自动 豪华运动型', NULL, 5193, 0, NULL, 'M', 0, 5, 15365),
(59102, '2.0L 手动 运动型', NULL, 5193, 0, NULL, 'M', 0, 5, 15364),
(59101, '1.6L 自动 精英型', NULL, 5193, 0, NULL, 'M', 0, 5, 15363),
(59100, '1.6L 手动 舒适型', NULL, 5193, 0, NULL, 'M', 0, 5, 15362),
(59099, '1.6L 自动 精英型', NULL, 5192, 0, NULL, 'M', 0, 5, 102306),
(59098, '2.0L AT 豪华型', NULL, 5191, 0, NULL, 'M', 0, 5, 4825),
(59097, '2.0L MT 豪华型', NULL, 5191, 0, NULL, 'M', 0, 5, 4824),
(59096, '2.0L AT 标准型', NULL, 5191, 0, NULL, 'M', 0, 5, 4823),
(59095, '2.0L MT 标准型', NULL, 5191, 0, NULL, 'M', 0, 5, 4822),
(59094, '2.0L 手自一体豪华型', NULL, 5190, 0, NULL, 'M', 0, 5, 108190),
(59093, '2.0L 手自一体标准型', NULL, 5190, 0, NULL, 'M', 0, 5, 108189),
(59092, '2.0L 手动豪华型', NULL, 5190, 0, NULL, 'M', 0, 5, 108188),
(59091, '2.0L 手动标准型', NULL, 5190, 0, NULL, 'M', 0, 5, 108187),
(59090, '1.6L 手自一体豪华型', NULL, 5190, 0, NULL, 'M', 0, 5, 108186),
(59089, '1.6L自动标准版', NULL, 5190, 0, NULL, 'M', 0, 5, 4820),
(59088, '1.6L手动标准版', NULL, 5190, 0, NULL, 'M', 0, 5, 4819),
(59087, '1.6L 手自一体标准型 ', NULL, 5189, 0, NULL, 'M', 0, 5, 108185),
(59086, '1.6L 手动标准型', NULL, 5189, 0, NULL, 'M', 0, 5, 108184),
(59085, '1.6L 自动豪华型', NULL, 5189, 0, NULL, 'M', 0, 5, 4821),
(59084, '1.6L自动天窗版', NULL, 5188, 0, NULL, 'M', 0, 5, 8176),
(59083, '经典款 2.0L 豪华型 R AT', NULL, 5187, 0, NULL, 'M', 0, 5, 11283),
(59082, '经典款 2.0L 运动型 V AT', NULL, 5187, 0, NULL, 'M', 0, 5, 11282),
(59081, '经典款 2.0L 运动型 V MT', NULL, 5187, 0, NULL, 'M', 0, 5, 11281),
(59080, '经典款 1.6L 精英型 V AT', NULL, 5187, 0, NULL, 'M', 0, 5, 11280),
(59079, '经典款 1.6L 时尚型 S AT', NULL, 5187, 0, NULL, 'M', 0, 5, 11279),
(59078, '经典款 1.6L 时尚型 S MT', NULL, 5187, 0, NULL, 'M', 0, 5, 11278),
(59077, '经典款 1.6L 自动 特惠型', NULL, 5186, 0, NULL, 'M', 0, 5, 15158),
(59076, '经典款 1.6L 手动 特惠型', NULL, 5186, 0, NULL, 'M', 0, 5, 15156),
(59075, '经典款 1.6L 自动 标准型', NULL, 5186, 0, NULL, 'M', 0, 5, 15155),
(59074, '经典款 1.6L 手动 标准型', NULL, 5186, 0, NULL, 'M', 0, 5, 15152),
(59073, '劲翔 尊贵版 1.5AT', NULL, 5185, 0, NULL, 'M', 0, 5, 5046),
(59072, '劲翔 豪华版 1.5AT', NULL, 5185, 0, NULL, 'M', 0, 5, 5045),
(59071, '劲翔 时尚版 1.5AT', NULL, 5185, 0, NULL, 'M', 0, 5, 5044),
(59070, '劲翔 时尚版 1.5MT', NULL, 5185, 0, NULL, 'M', 0, 5, 5043),
(59069, '劲翔 标准版 1.3MT', NULL, 5185, 0, NULL, 'M', 0, 5, 5042),
(59068, '劲翔 标准版 1.3AT', NULL, 5185, 0, NULL, 'M', 0, 5, 5041),
(59067, '劲翔炫动款 1.5L 自动豪华型', NULL, 5184, 0, NULL, 'M', 0, 5, 12469),
(59066, '劲翔炫动款 1.5L 自动时尚型', NULL, 5184, 0, NULL, 'M', 0, 5, 12468),
(59065, '劲翔炫动款 1.5L 手动时尚型', NULL, 5184, 0, NULL, 'M', 0, 5, 12467),
(59064, '劲翔炫动款 1.3L 自动标准型', NULL, 5184, 0, NULL, 'M', 0, 5, 12466),
(59063, '劲翔炫动款 1.3L 手动标准型', NULL, 5184, 0, NULL, 'M', 0, 5, 12465),
(59062, '炫动款 1.5L 自动时尚型', NULL, 5183, 0, NULL, 'M', 0, 5, 108200),
(59061, '炫动款 1.5L 自动豪华型', NULL, 5183, 0, NULL, 'M', 0, 5, 108199),
(59060, '炫动款 1.5L 手动时尚型', NULL, 5183, 0, NULL, 'M', 0, 5, 108198),
(59059, '炫动款 1.3L 自动标准型', NULL, 5183, 0, NULL, 'M', 0, 5, 108197),
(59058, '炫动款 1.3L 手动标准型', NULL, 5183, 0, NULL, 'M', 0, 5, 108196),
(59057, '1.5L 自动 豪华版', NULL, 5182, 0, NULL, 'M', 0, 5, 102111),
(59056, '1.3L 自动 标准版', NULL, 5182, 0, NULL, 'M', 0, 5, 102110),
(59055, '1.3L 手动 标准版', NULL, 5182, 0, NULL, 'M', 0, 5, 102109),
(59054, '1.5L 手动 时尚版', NULL, 5182, 0, NULL, 'M', 0, 5, 102108),
(59053, '1.5L 自动 时尚版', NULL, 5182, 0, NULL, 'M', 0, 5, 102107),
(59052, '1.3L 自动时尚型', NULL, 5181, 0, NULL, 'M', 0, 5, 108183),
(59051, '标准版 1.3AT', NULL, 5181, 0, NULL, 'M', 0, 5, 327),
(59050, '标准版 1.3MT', NULL, 5181, 0, NULL, 'M', 0, 5, 326),
(59049, '1.3L 自动标准型', NULL, 5180, 0, NULL, 'M', 0, 5, 108182),
(59048, '1.3L 手动标准型', NULL, 5180, 0, NULL, 'M', 0, 5, 108181),
(59047, '1.5MT 豪华型', NULL, 5180, 0, NULL, 'M', 0, 5, 5860),
(59046, '尊贵版 1.5AT', NULL, 5180, 0, NULL, 'M', 0, 5, 5859),
(59045, '1.5MT 时尚型', NULL, 5180, 0, NULL, 'M', 0, 5, 5488),
(59044, '1.5AT 时尚型', NULL, 5180, 0, NULL, 'M', 0, 5, 5487),
(59043, '豪华版 1.5AT', NULL, 5180, 0, NULL, 'M', 0, 5, 5485),
(59042, '1.3自动时尚型', NULL, 5180, 0, NULL, 'M', 0, 5, 4826),
(59041, '超值版 1.5AT', NULL, 5179, 0, NULL, 'M', 0, 5, 8223),
(59040, '超值版 1.5MT', NULL, 5179, 0, NULL, 'M', 0, 5, 8222),
(59039, '炫动款 1.5L 自动豪华型', NULL, 5178, 0, NULL, 'M', 0, 5, 12464),
(59038, '炫动款 1.5L 手动超值版', NULL, 5178, 0, NULL, 'M', 0, 5, 12460),
(59037, '炫动款 1.5L 自动超值版', NULL, 5178, 0, NULL, 'M', 0, 5, 12459),
(59036, '炫动款 1.3L 自动标准型', NULL, 5178, 0, NULL, 'M', 0, 5, 12458),
(59035, '炫动款 1.3L 手动标准型', NULL, 5178, 0, NULL, 'M', 0, 5, 12455),
(59034, '炫动款 1.5L 自动豪华型', NULL, 5177, 0, NULL, 'M', 0, 5, 108195),
(59033, '炫动款 1.5L 自动超值版', NULL, 5177, 0, NULL, 'M', 0, 5, 108194),
(59032, '炫动款 1.5L 手动超值版', NULL, 5177, 0, NULL, 'M', 0, 5, 108193),
(59031, '炫动款 1.3L 自动标准型', NULL, 5177, 0, NULL, 'M', 0, 5, 108192),
(59030, '炫动款 1.3L 手动标准型', NULL, 5177, 0, NULL, 'M', 0, 5, 108191),
(59029, '1.3L 手动 标准版', NULL, 5176, 0, NULL, 'M', 0, 5, 102117),
(59028, '1.3L 自动 标准版', NULL, 5176, 0, NULL, 'M', 0, 5, 102116),
(59027, '1.5L 手动 超值版', NULL, 5176, 0, NULL, 'M', 0, 5, 102114),
(59026, '1.5L 自动 超值版', NULL, 5176, 0, NULL, 'M', 0, 5, 102113),
(59025, '1.5L 自动 豪华版', NULL, 5176, 0, NULL, 'M', 0, 5, 101420),
(59024, '2.0L 自动 运动型', NULL, 5175, 0, NULL, 'M', 0, 5, 110928),
(59023, '1.5L 手动 舒适型', NULL, 5175, 0, NULL, 'M', 0, 5, 110927),
(59022, '1.5L 自动 舒适型', NULL, 5175, 0, NULL, 'M', 0, 5, 110926),
(59021, '1.5L 自动 豪华型', NULL, 5175, 0, NULL, 'M', 0, 5, 110923),
(59020, '2.0L 自动 旗舰型', NULL, 5175, 0, NULL, 'M', 0, 5, 110052),
(59019, '1.5L 自动 尊贵型', NULL, 5175, 0, NULL, 'M', 0, 5, 110041),
(59018, '1.5L 手动 舒适型', NULL, 5174, 0, NULL, 'M', 0, 5, 110937),
(59017, '1.5L 自动 豪华型', NULL, 5174, 0, NULL, 'M', 0, 5, 110932),
(59016, '1.5L 自动 尊贵型', NULL, 5174, 0, NULL, 'M', 0, 5, 110931),
(59015, '2.0L 自动 运动型', NULL, 5174, 0, NULL, 'M', 0, 5, 110930),
(59014, '2.0L 自动 旗舰型', NULL, 5174, 0, NULL, 'M', 0, 5, 110929),
(59013, 'VT3 3.0L 手自一体', NULL, 5173, 0, NULL, 'L', 0, 5, 110191),
(59012, 'VT3 2.5L 手自一体', NULL, 5173, 0, NULL, 'L', 0, 5, 110190),
(59011, 'VT2 3.0L 手自一体', NULL, 5173, 0, NULL, 'L', 0, 5, 110189),
(59010, ' VT2 2.5L 手自一体', NULL, 5173, 0, NULL, 'L', 0, 5, 110187),
(59009, '2.5L 手自一体 豪华型', NULL, 5173, 0, NULL, 'L', 0, 5, 104320),
(59008, '2.5L 手自一体 舒适型', NULL, 5173, 0, NULL, 'L', 0, 5, 104317),
(59007, '专用校车 2.1T 手动 柴油版', NULL, 5172, 0, NULL, 'L', 0, 5, 110200),
(59006, '监护型救护车 2.1L 手自一体 柴油版', NULL, 5172, 0, NULL, 'L', 0, 5, 110199),
(59005, '监护型救护车 2.5L 手自一体 汽油版', NULL, 5172, 0, NULL, 'L', 0, 5, 110198),
(59004, '3.5L 手动 高顶豪华型', NULL, 5172, 0, NULL, 'L', 0, 5, 110197),
(59003, '2.1T 手动 高顶舒适型', NULL, 5172, 0, NULL, 'L', 0, 5, 110196),
(59002, '2.1T 手动 高顶标准型', NULL, 5172, 0, NULL, 'L', 0, 5, 110195),
(59001, '1.5L 自动 豪华版', NULL, 5171, 0, NULL, 'L', 0, 5, 13224),
(59000, '1.3L 自动 舒适版', NULL, 5171, 0, NULL, 'L', 0, 5, 13223),
(58999, '1.3L 手动 舒适版', NULL, 5171, 0, NULL, 'L', 0, 5, 13222),
(58998, '1.5L 手动 运动型', NULL, 5170, 0, NULL, 'L', 0, 5, 103283),
(58997, '1.3L 自动 舒适型', NULL, 5170, 0, NULL, 'L', 0, 5, 101201),
(58996, '1.3L 手动 舒适型', NULL, 5170, 0, NULL, 'L', 0, 5, 101200),
(58995, '1.5L 自动 豪华型', NULL, 5170, 0, NULL, 'L', 0, 5, 101198),
(58994, '1.5L 手动 舒适型', NULL, 5170, 0, NULL, 'L', 0, 5, 100115),
(58993, '1.5L 手动 舒适版', NULL, 5169, 0, NULL, 'L', 0, 5, 103886),
(58992, '1.5L 自动 舒适版', NULL, 5169, 0, NULL, 'L', 0, 5, 103885),
(58991, '1.5L 手动 运动版', NULL, 5169, 0, NULL, 'L', 0, 5, 103884),
(58990, '1.5L 手动 豪华版', NULL, 5169, 0, NULL, 'L', 0, 5, 103883),
(58989, '1.5L 自动 豪华版', NULL, 5169, 0, NULL, 'L', 0, 5, 103879),
(58988, '1.3L 手动 舒适型', NULL, 5168, 0, NULL, 'L', 0, 5, 110185),
(58987, '1.3L 自动 舒适型', NULL, 5168, 0, NULL, 'L', 0, 5, 110184),
(58986, 'YZK6480E2A', NULL, 5167, 0, NULL, 'L', 0, 5, 6768),
(58985, 'YZK5022XXYA', NULL, 5167, 0, NULL, 'L', 0, 5, 6767),
(58984, 'YZK1026CT2A ', NULL, 5166, 0, NULL, 'L', 0, 5, 6114),
(58983, 'YZK1026E2A', NULL, 5166, 0, NULL, 'L', 0, 5, 6113),
(58982, '汽油皮卡', NULL, 5166, 0, NULL, 'L', 0, 5, 2531),
(58981, 'YZK1022C1S 柴油四驱', NULL, 5165, 0, NULL, 'L', 0, 5, 8373),
(58980, 'YZK1022EAS 汽油四驱', NULL, 5165, 0, NULL, 'L', 0, 5, 8372),
(58979, 'YZK1022C1 柴油两驱', NULL, 5165, 0, NULL, 'L', 0, 5, 8371),
(58978, 'YZK1022EA 汽油两驱', NULL, 5165, 0, NULL, 'L', 0, 5, 8370),
(58977, 'YZK1022C3S', NULL, 5164, 0, NULL, 'L', 0, 5, 14956),
(58976, 'YZK1022C3', NULL, 5164, 0, NULL, 'L', 0, 5, 14955),
(58975, 'YZK1022E1AY', NULL, 5164, 0, NULL, 'L', 0, 5, 14954),
(58974, 'YZK1022C2S', NULL, 5164, 0, NULL, 'L', 0, 5, 2535),
(58973, 'YZK1022EA', NULL, 5164, 0, NULL, 'L', 0, 5, 2534),
(58972, 'YZK1022EAS', NULL, 5164, 0, NULL, 'L', 0, 5, 2533),
(58971, 'YZK1022C2', NULL, 5164, 0, NULL, 'L', 0, 5, 2532),
(58970, 'YZK1030E1S', NULL, 5163, 0, NULL, 'L', 0, 5, 14938),
(58969, 'YZK1030E1', NULL, 5163, 0, NULL, 'L', 0, 5, 14937),
(58968, 'YZK1030E', NULL, 5163, 0, NULL, 'L', 0, 5, 14933),
(58967, 'YZK1030E1', NULL, 5162, 0, NULL, 'L', 0, 5, 16096),
(58966, '2.5T 手动 四驱 柴油版', NULL, 5162, 0, NULL, 'L', 0, 5, 14940),
(58965, '2.5T 手动 两驱 柴油版', NULL, 5162, 0, NULL, 'L', 0, 5, 14939),
(58964, '2.4L 手动 两驱 汽油版', NULL, 5161, 0, NULL, 'L', 0, 5, 110074),
(58963, '2.4L 手动 四驱 汽油版', NULL, 5161, 0, NULL, 'L', 0, 5, 110073),
(58962, '2.5T 手动 两驱 柴油版', NULL, 5161, 0, NULL, 'L', 0, 5, 110072),
(58961, '2.5T 手动 四驱 柴油版', NULL, 5161, 0, NULL, 'L', 0, 5, 110071),
(58960, 'YZK1026CT2', NULL, 5160, 0, NULL, 'L', 0, 5, 6747),
(58959, 'YZK1026C2', NULL, 5160, 0, NULL, 'L', 0, 5, 6746),
(58958, 'YZK1026E2', NULL, 5160, 0, NULL, 'L', 0, 5, 6745),
(58957, '鑫麒麟超豪华型', NULL, 5159, 0, NULL, 'L', 0, 5, 6749),
(58956, '鑫麒麟豪华型', NULL, 5159, 0, NULL, 'L', 0, 5, 6748),
(58955, '双排 四驱柴油增压', NULL, 5158, 0, NULL, 'L', 0, 5, 4164),
(58954, '双排 四驱汽油', NULL, 5158, 0, NULL, 'L', 0, 5, 4163),
(58953, '双排 柴油', NULL, 5158, 0, NULL, 'L', 0, 5, 4162),
(58952, '双排 汽油', NULL, 5158, 0, NULL, 'L', 0, 5, 4161),
(58951, '汽油标准型 YZK6480JME', NULL, 5157, 0, NULL, 'L', 0, 5, 6122),
(58950, '柴油标准型皮卡YZK1026SCB', NULL, 5157, 0, NULL, 'L', 0, 5, 2529),
(58949, '汽油标准型皮卡YZK1026JME', NULL, 5157, 0, NULL, 'L', 0, 5, 2528),
(58948, '皮卡教练车YZK1026JME', NULL, 5157, 0, NULL, 'L', 0, 5, 2527),
(58947, 'YZK6460CT1S', NULL, 5156, 0, NULL, 'L', 0, 5, 2539),
(58946, 'YZK6460CT1', NULL, 5156, 0, NULL, 'L', 0, 5, 2538),
(58945, 'YZK6460E1S', NULL, 5156, 0, NULL, 'L', 0, 5, 2537),
(58944, 'YZK6460E1', NULL, 5156, 0, NULL, 'L', 0, 5, 2536),
(58943, 'YZK6461C 飞扬短轴距', NULL, 5155, 0, NULL, 'L', 0, 5, 2541),
(58942, 'YZK6461E 飞扬短轴距', NULL, 5155, 0, NULL, 'L', 0, 5, 2540),
(58941, 'YZK1021C 柴油两驱', NULL, 5154, 0, NULL, 'L', 0, 5, 4173),
(58940, 'YZK1021E 汽油两驱', NULL, 5154, 0, NULL, 'L', 0, 5, 4171),
(58939, 'YZK1022C3Y 2.8', NULL, 5153, 0, NULL, 'L', 0, 5, 14951),
(58938, 'YZK1022C3Y', NULL, 5153, 0, NULL, 'L', 0, 5, 14950),
(58937, 'YZK1022C3 2.8', NULL, 5153, 0, NULL, 'L', 0, 5, 14949),
(58936, 'YZK1022E1L', NULL, 5153, 0, NULL, 'L', 0, 5, 14948),
(58935, 'YZK1022E1Y', NULL, 5153, 0, NULL, 'L', 0, 5, 14947),
(58934, 'YZK1022E1', NULL, 5153, 0, NULL, 'L', 0, 5, 14946),
(58933, 'YZK1022C3L', NULL, 5153, 0, NULL, 'L', 0, 5, 11198),
(58932, 'YZK1022E', NULL, 5153, 0, NULL, 'L', 0, 5, 10320),
(58931, 'YZK1022C3', NULL, 5153, 0, NULL, 'L', 0, 5, 10319),
(58930, 'YZK1022EL', NULL, 5153, 0, NULL, 'L', 0, 5, 4172),
(58929, 'YZK6510ES', NULL, 5152, 0, NULL, 'L', 0, 5, 9137),
(58928, 'YZK6510E', NULL, 5152, 0, NULL, 'L', 0, 5, 9136),
(58927, 'YZK6510C1S', NULL, 5152, 0, NULL, 'L', 0, 5, 9135),
(58926, 'YZK6510C1', NULL, 5152, 0, NULL, 'L', 0, 5, 9134),
(58925, 'YZK6482ES 4×4', NULL, 5151, 0, NULL, 'L', 0, 5, 9196),
(58924, 'YZK6482E 4×2', NULL, 5151, 0, NULL, 'L', 0, 5, 9195),
(58923, '1.6L 手动 舒适型', NULL, 5150, 0, NULL, 'L', 0, 5, 108535),
(58922, '1.6L 手动 标准版', NULL, 5150, 0, NULL, 'L', 0, 5, 108534),
(58921, '1.6L手动尊贵型', NULL, 5149, 0, NULL, 'L', 0, 5, 5358),
(58920, '1.6L手动舒适型', NULL, 5149, 0, NULL, 'L', 0, 5, 4688),
(58919, '1.6L手动标准型', NULL, 5149, 0, NULL, 'L', 0, 5, 4687),
(58918, 'E 2.4 手动 环保版 四驱', NULL, 5148, 0, NULL, 'L', 0, 5, 109474),
(58917, 'D 3.0 自动 豪华版 四驱', NULL, 5147, 0, NULL, 'L', 0, 5, 109476),
(58916, 'F 2.4 手动 平顶版 四驱', NULL, 5147, 0, NULL, 'L', 0, 5, 109475),
(58915, 'C 3.0 手动 豪华版 四驱', NULL, 5147, 0, NULL, 'L', 0, 5, 108533),
(58914, '2.4 手动 舒适版 两驱', NULL, 5146, 0, NULL, 'L', 0, 5, 109484),
(58913, 'G 2.4 手动 入门版 两驱', NULL, 5146, 0, NULL, 'L', 0, 5, 109479),
(58912, 'H 2.4 手动 平顶版 两驱', NULL, 5146, 0, NULL, 'L', 0, 5, 109478),
(58911, '2030C舒适型', NULL, 5146, 0, NULL, 'L', 0, 5, 4126),
(58910, 'L 2.4 手动 标准版 四驱', NULL, 5145, 0, NULL, 'L', 0, 5, 109477),
(58909, 'CFA6470LP', NULL, 5145, 0, NULL, 'L', 0, 5, 569),
(58908, '2.4 手动 舒适版 两驱', NULL, 5144, 0, NULL, 'L', 0, 5, 109485),
(58907, '6470MP 4*2', NULL, 5144, 0, NULL, 'L', 0, 5, 575),
(58906, '6470MP 4*4', NULL, 5144, 0, NULL, 'L', 0, 5, 574),
(58905, 'CFA6470L3经典型', NULL, 5144, 0, NULL, 'L', 0, 5, 567),
(58904, '2.4 手动 豪华版 两驱', NULL, 5143, 0, NULL, 'L', 0, 5, 109480),
(58903, '2030C豪华型', NULL, 5143, 0, NULL, 'L', 0, 5, 4127),
(58902, '2.4 手动 舒适版 四驱', NULL, 5142, 0, NULL, 'L', 0, 5, 109488),
(58901, '2.4 手动 舒适版 两驱', NULL, 5142, 0, NULL, 'L', 0, 5, 109486),
(58900, 'CFA6470LA 经典型', NULL, 5142, 0, NULL, 'L', 0, 5, 8253),
(58899, 'CFA6470L3 经典型', NULL, 5142, 0, NULL, 'L', 0, 5, 8252),
(58898, 'CFA6470MA 舒适型', NULL, 5142, 0, NULL, 'L', 0, 5, 8251),
(58897, 'CFA6470M3 舒适型', NULL, 5142, 0, NULL, 'L', 0, 5, 8250),
(58896, 'CFA2030C 豪华型', NULL, 5142, 0, NULL, 'L', 0, 5, 5264),
(58895, 'CFA2030C 舒适型', NULL, 5142, 0, NULL, 'L', 0, 5, 5263),
(58894, 'CFA6470L 经典型', NULL, 5142, 0, NULL, 'L', 0, 5, 5262),
(58893, 'CFA6473', NULL, 5142, 0, NULL, 'L', 0, 5, 5260),
(58892, 'CFA6470 经典型', NULL, 5142, 0, NULL, 'L', 0, 5, 5259),
(58891, 'CFA6470M 舒适型', NULL, 5142, 0, NULL, 'L', 0, 5, 5255),
(58890, 'CFA2030D', NULL, 5142, 0, NULL, 'L', 0, 5, 4128),
(58889, '2.5 手动 两驱', NULL, 5141, 0, NULL, 'L', 0, 5, 109489),
(58888, '2.4 手动 舒适版 两驱', NULL, 5141, 0, NULL, 'L', 0, 5, 109487),
(58887, 'CFA6480A(柴油) MT 2WD', NULL, 5140, 0, NULL, 'L', 0, 5, 11197),
(58886, 'CFA6470LA MT 4WD', NULL, 5140, 0, NULL, 'L', 0, 5, 11196),
(58885, 'CFA6470L3 MT 4WD', NULL, 5140, 0, NULL, 'L', 0, 5, 11195),
(58884, 'CFA6470MA MT 2WD', NULL, 5140, 0, NULL, 'L', 0, 5, 11194),
(58883, 'CFA6470M3 MT 2WD', NULL, 5140, 0, NULL, 'L', 0, 5, 11193),
(58882, '2.5T 手动 两驱 柴油 CFA6480A', NULL, 5139, 0, NULL, 'L', 0, 5, 103446),
(58881, '2.4L 手动  四驱 豪华型 汽油 CFA6470LA', NULL, 5139, 0, NULL, 'L', 0, 5, 103442),
(58880, '2.4L 手动 两驱 舒适型 汽油 CFA6470MA', NULL, 5139, 0, NULL, 'L', 0, 5, 103440),
(58879, '2.2L 手动 四驱 标准型 汽油 CFA6481L', NULL, 5139, 0, NULL, 'L', 0, 5, 103439),
(58878, '2.2L 手动 两驱 标准型 汽油 CFA6481M', NULL, 5139, 0, NULL, 'L', 0, 5, 103438),
(58877, '2.2L 手动 两驱 标准版', NULL, 5139, 0, NULL, 'L', 0, 5, 103157),
(58876, '2.2L 手动 四驱 标准版', NULL, 5139, 0, NULL, 'L', 0, 5, 103156),
(58875, 'CFA6400A标准手动', NULL, 5138, 0, NULL, 'L', 0, 5, 4118),
(58874, '2.0 手动 豪华版 四驱', NULL, 5137, 0, NULL, 'L', 0, 5, 108539),
(58873, '2.0 自动 豪华版 四驱D', NULL, 5137, 0, NULL, 'L', 0, 5, 108532),
(58872, '2.0 自动 标准版 四驱', NULL, 5137, 0, NULL, 'L', 0, 5, 108531),
(58871, 'CFA6400G3标准手动', NULL, 5137, 0, NULL, 'L', 0, 5, 5300),
(58870, 'CFA6400D豪华自动', NULL, 5137, 0, NULL, 'L', 0, 5, 5244),
(58869, 'CFA6400C豪华手动', NULL, 5137, 0, NULL, 'L', 0, 5, 5243),
(58868, 'CFA6400B标准自动', NULL, 5137, 0, NULL, 'L', 0, 5, 5242),
(58867, 'CFA6400A3标准手动', NULL, 5137, 0, NULL, 'L', 0, 5, 5240),
(58866, 'CFA6400D', NULL, 5137, 0, NULL, 'L', 0, 5, 563),
(58865, 'CFA6400C', NULL, 5137, 0, NULL, 'L', 0, 5, 562),
(58864, 'CFA6400B', NULL, 5137, 0, NULL, 'L', 0, 5, 561),
(58863, 'CFA6400A', NULL, 5137, 0, NULL, 'L', 0, 5, 560),
(58862, 'CFA6400G', NULL, 5136, 0, NULL, 'L', 0, 5, 564),
(58861, '2.0 手动 标准版 两驱', NULL, 5135, 0, NULL, 'L', 0, 5, 109482),
(58860, '2.0 手动 四驱', NULL, 5135, 0, NULL, 'L', 0, 5, 109473),
(58859, 'CFA6400G标准手动', NULL, 5135, 0, NULL, 'L', 0, 5, 4116),
(58858, '2.0 手动 标准版 四驱', NULL, 5134, 0, NULL, 'L', 0, 5, 108537),
(58857, 'CFA6400A3豪华手动', NULL, 5134, 0, NULL, 'L', 0, 5, 5295),
(58856, '2.0 手动 标准版 两驱', NULL, 5133, 0, NULL, 'L', 0, 5, 109483),
(58855, 'CFA6400AA手动豪华型 4WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8238),
(58854, 'CFA6400AA手动标准型 4WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8237),
(58853, 'CFA6400A3手动豪华型 4WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8236),
(58852, 'CFA6400A3手动标准型 4WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8235),
(58851, 'CFA6400GA手动标准型 2WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8234),
(58850, 'CFA6400G3手动标准型 2WD', NULL, 5133, 0, NULL, 'L', 0, 5, 8233),
(58849, '2.0 手动 标准版 四驱', NULL, 5132, 0, NULL, 'L', 0, 5, 108530),
(58848, '时尚版 CFA6420C 1.5L MT 2WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11687),
(58847, '时尚版 CFA6420B 2.0L MT 2WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11190),
(58846, '时尚版 CFA6420B 2.0L MT 2WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11189),
(58845, '时尚版 CFA6420A 2.0L MT 4WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11188),
(58844, '时尚版 CFA6420A 2.0L MT 4WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11187),
(58843, '经典版 CFA6400AA 2.0L MT 4WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11186),
(58842, '经典版 CFA6400AA 2.0L MT 4WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11185),
(58841, '经典版 CFA6400A3 2.0L MT 4WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11184),
(58840, '经典版 CFA6400A3 2.0L MT 4WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11183),
(58839, '经典版 CFA6400GA 2.0L MT 2WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11182),
(58838, '经典版 CFA6400G3 2.0L MT 2WD 舒适型', NULL, 5132, 0, NULL, 'L', 0, 5, 11181),
(58837, '时尚版 CFA6420C 1.5L MT 2WD 豪华型', NULL, 5132, 0, NULL, 'L', 0, 5, 11110),
(58836, '2.0 手动 标准版 四驱', NULL, 5131, 0, NULL, 'L', 0, 5, 108538),
(58835, '2.0L 手动 两驱 标准型 ', NULL, 5130, 0, NULL, 'L', 0, 5, 105744),
(58834, '2.0L 手动 四驱 标准型', NULL, 5130, 0, NULL, 'L', 0, 5, 105742),
(58833, '2.0L 手动 四驱 豪华型', NULL, 5130, 0, NULL, 'L', 0, 5, 105741),
(58832, '四驱版', NULL, 5129, 0, NULL, 'L', 0, 5, 111129),
(58831, '两驱版', NULL, 5129, 0, NULL, 'L', 0, 5, 111128),
(58830, '欧四汽油两驱版', NULL, 5128, 0, NULL, 'L', 0, 5, 5341),
(58829, '欧四汽油标准版', NULL, 5128, 0, NULL, 'L', 0, 5, 5340),
(58828, '欧四汽油豪华版', NULL, 5128, 0, NULL, 'L', 0, 5, 5339),
(58827, '欧三汽油两驱版', NULL, 5128, 0, NULL, 'L', 0, 5, 5322),
(58826, '欧三汽油标准版', NULL, 5128, 0, NULL, 'L', 0, 5, 5321),
(58825, '欧三汽油豪华版', NULL, 5128, 0, NULL, 'L', 0, 5, 5320),
(58824, '柴油两驱版', NULL, 5128, 0, NULL, 'L', 0, 5, 5319),
(58823, '柴油标准版', NULL, 5128, 0, NULL, 'L', 0, 5, 5318),
(58822, '柴油豪华版', NULL, 5128, 0, NULL, 'L', 0, 5, 5316),
(58821, 'CFA2032A舒适型', NULL, 5128, 0, NULL, 'L', 0, 5, 4130),
(58820, 'CFA2032A豪华型', NULL, 5128, 0, NULL, 'L', 0, 5, 4129),
(58819, 'CFA2032A 舒适型', NULL, 5127, 0, NULL, 'L', 0, 5, 8243),
(58818, 'CFA2032A 豪华型', NULL, 5127, 0, NULL, 'L', 0, 5, 8242),
(58817, 'CFA6501B 舒适型', NULL, 5127, 0, NULL, 'L', 0, 5, 8241),
(58816, 'CFA6501A 舒适型', NULL, 5127, 0, NULL, 'L', 0, 5, 8240),
(58815, 'CFA6501A 豪华型', NULL, 5127, 0, NULL, 'L', 0, 5, 8239),
(58814, 'CFA6501B舒适型', NULL, 5127, 0, NULL, 'L', 0, 5, 4133),
(58813, 'CFA6501A舒适型', NULL, 5127, 0, NULL, 'L', 0, 5, 4132),
(58812, 'CFA6501A豪华型', NULL, 5127, 0, NULL, 'L', 0, 5, 4131),
(58811, '2.5T 手动 舒适型 四驱', NULL, 5126, 0, NULL, 'L', 0, 5, 108529),
(58810, '柴油版 CFA2032A MT 4WD 豪华型', NULL, 5125, 0, NULL, 'L', 0, 5, 11203),
(58809, '柴油版 CFA2032A MT 4WD 舒适型', NULL, 5125, 0, NULL, 'L', 0, 5, 11202),
(58808, '汽油版 CFA6501A MT 4WD 豪华型', NULL, 5125, 0, NULL, 'L', 0, 5, 11201),
(58807, '汽油版 CFA6501A MT 4WD 舒适型', NULL, 5125, 0, NULL, 'L', 0, 5, 11200),
(58806, '汽油版 CFA6501B MT 2WD 舒适型', NULL, 5125, 0, NULL, 'L', 0, 5, 11199),
(58805, '2.5T 手动 舒适型 四驱', NULL, 5124, 0, NULL, 'L', 0, 5, 108536),
(58804, '6470Q', NULL, 5123, 0, NULL, 'L', 0, 5, 4140),
(58803, '6470L3', NULL, 5123, 0, NULL, 'L', 0, 5, 4139),
(58802, '6470M3豪华型', NULL, 5123, 0, NULL, 'L', 0, 5, 4138),
(58801, '6470M3舒适型', NULL, 5123, 0, NULL, 'L', 0, 5, 4137),
(58800, '6470M豪华型', NULL, 5123, 0, NULL, 'L', 0, 5, 4136),
(58799, '6470M舒适型', NULL, 5123, 0, NULL, 'L', 0, 5, 4135),
(58798, '6470R', NULL, 5123, 0, NULL, 'L', 0, 5, 4134),
(58797, '6470L', NULL, 5123, 0, NULL, 'L', 0, 5, 597),
(58796, 'CJY6470E', NULL, 5123, 0, NULL, 'L', 0, 5, 596),
(58795, 'CFA6470H', NULL, 5123, 0, NULL, 'L', 0, 5, 595),
(58794, 'CJY6470EP环保型', NULL, 5123, 0, NULL, 'L', 0, 5, 594),
(58793, 'CFA6470F环保型', NULL, 5123, 0, NULL, 'L', 0, 5, 593),
(58792, 'CFA6470MP', NULL, 5122, 0, NULL, 'L', 0, 5, 6182),
(58791, 'CFA6470M3', NULL, 5122, 0, NULL, 'L', 0, 5, 599),
(58790, '6470G', NULL, 5122, 0, NULL, 'L', 0, 5, 598),
(58789, 'CFA6473', NULL, 5121, 0, NULL, 'L', 0, 5, 5245),
(58788, 'CFA2030B豪华型', NULL, 5120, 0, NULL, 'L', 0, 5, 6184),
(58787, 'CFA2030A（6缸手动标准型）', NULL, 5120, 0, NULL, 'L', 0, 5, 6183),
(58786, 'CFA2030D', NULL, 5120, 0, NULL, 'L', 0, 5, 566),
(58785, 'CFA2030C', NULL, 5119, 0, NULL, 'L', 0, 5, 565),
(58784, 'CAF2030B AT', NULL, 5118, 0, NULL, 'L', 0, 5, 573),
(58783, 'CAF2030A MT', NULL, 5117, 0, NULL, 'L', 0, 5, 572),
(58782, 'CFA2031B 豪华版', NULL, 5117, 0, NULL, 'L', 0, 5, 571),
(58781, 'CFA2030CP', NULL, 5117, 0, NULL, 'L', 0, 5, 570),
(58780, '2.4 手动 两驱', NULL, 5116, 0, NULL, 'L', 0, 5, 109481),
(58779, 'CFA6473C', NULL, 5116, 0, NULL, 'L', 0, 5, 5249),
(58778, '6473B', NULL, 5116, 0, NULL, 'L', 0, 5, 4125),
(58777, '6473', NULL, 5116, 0, NULL, 'L', 0, 5, 4124),
(58776, 'CFA6472', NULL, 5116, 0, NULL, 'L', 0, 5, 601),
(58775, '2.2 手动 四驱', NULL, 5115, 0, NULL, 'L', 0, 5, 108541),
(58774, '2.2 手动 两驱', NULL, 5115, 0, NULL, 'L', 0, 5, 108540),
(58773, '2.2手动四驱', NULL, 5114, 0, NULL, 'L', 0, 5, 7523),
(58772, '2.2手动两驱', NULL, 5114, 0, NULL, 'L', 0, 5, 7522),
(58771, 'CFA6473B3 MT 4WD', NULL, 5113, 0, NULL, 'L', 0, 5, 11192),
(58770, 'CFA6473A3 MT 2WD', NULL, 5113, 0, NULL, 'L', 0, 5, 11191),
(58769, '1.5L 自动 舒适型', NULL, 5112, 0, NULL, 'L', 0, 5, 110833),
(58768, '1.5L 自动 豪华型', NULL, 5112, 0, NULL, 'L', 0, 5, 110722),
(58767, 'CFA6420A 四驱豪华型', NULL, 5111, 0, NULL, 'L', 0, 5, 8500),
(58766, 'CFA6420AP 四驱舒适型', NULL, 5111, 0, NULL, 'L', 0, 5, 8499),
(58765, 'CFA6420B 两驱豪华型', NULL, 5111, 0, NULL, 'L', 0, 5, 8498),
(58764, 'CFA6420BP 两驱舒适型', NULL, 5111, 0, NULL, 'L', 0, 5, 8497),
(58763, '1.6L AT(真皮座椅)', NULL, 5110, 0, NULL, 'L', 0, 5, 5937),
(58762, '1.6L AT', NULL, 5110, 0, NULL, 'L', 0, 5, 5936),
(58761, '1.6L MT(真皮座椅)', NULL, 5110, 0, NULL, 'L', 0, 5, 5935),
(58760, '1.6L MT', NULL, 5110, 0, NULL, 'L', 0, 5, 5934),
(58759, '自动挡 时尚型', NULL, 5109, 0, NULL, 'L', 0, 5, 7239),
(58758, '手动挡 时尚型', NULL, 5109, 0, NULL, 'L', 0, 5, 7238),
(58757, '1.6L 自动 风尚导航版', NULL, 5108, 0, NULL, 'L', 0, 5, 15196),
(58756, '1.6L 手动 风尚导航版', NULL, 5108, 0, NULL, 'L', 0, 5, 15195),
(58755, '1.6L 自动 精智导航版', NULL, 5108, 0, NULL, 'L', 0, 5, 13351),
(58754, '1.6L 自动 精智版', NULL, 5108, 0, NULL, 'L', 0, 5, 13350),
(58753, '1.6L 自动 风尚版', NULL, 5108, 0, NULL, 'L', 0, 5, 13349),
(58752, '1.6L 手动 精智版', NULL, 5108, 0, NULL, 'L', 0, 5, 13348),
(58751, '1.6L 手动 风尚版', NULL, 5108, 0, NULL, 'L', 0, 5, 13343),
(58750, '1.8L 自动 尊贵型', NULL, 5107, 0, NULL, 'L', 0, 5, 111275),
(58749, '1.8L 手动 尊贵型', NULL, 5107, 0, NULL, 'L', 0, 5, 111274),
(58748, '1.8L 自动 精智导航版', NULL, 5107, 0, NULL, 'L', 0, 5, 100168),
(58747, '1.8L 自动 精智版', NULL, 5107, 0, NULL, 'L', 0, 5, 100167),
(58746, '1.8L 自动 风尚版', NULL, 5107, 0, NULL, 'L', 0, 5, 100164),
(58745, '1.8L 手动 精智版', NULL, 5107, 0, NULL, 'L', 0, 5, 100159),
(58744, '1.8L 手动 风尚版', NULL, 5107, 0, NULL, 'L', 0, 5, 100158),
(58743, 'GT 1.6L 自动 精英型', NULL, 5106, 0, NULL, 'L', 0, 5, 102737),
(58742, 'Sportback 1.6L 自动 精智导航版', NULL, 5105, 0, NULL, 'L', 0, 5, 14866),
(58741, 'Sportback 1.6L 自动 精智版', NULL, 5105, 0, NULL, 'L', 0, 5, 14865),
(58740, 'Sportback 1.6L 自动 风尚导航版', NULL, 5105, 0, NULL, 'L', 0, 5, 14864),
(58739, 'Sportback 1.6L 自动 风尚版', NULL, 5105, 0, NULL, 'L', 0, 5, 14863),
(58738, 'Sportback 1.6L 手动 精智版', NULL, 5105, 0, NULL, 'L', 0, 5, 14862),
(58737, 'Sportback 1.6L 手动 风尚导航版', NULL, 5105, 0, NULL, 'L', 0, 5, 14861),
(58736, 'Sportback 1.6L 手动 风尚版', NULL, 5105, 0, NULL, 'L', 0, 5, 14860),
(58735, 'Sportback 1.8L 手动 尊贵型', NULL, 5104, 0, NULL, 'L', 0, 5, 111277),
(58734, 'Sportback 1.8L 自动 尊贵型', NULL, 5104, 0, NULL, 'L', 0, 5, 111276),
(58733, 'Sportback 1.8L 手动 风尚版', NULL, 5104, 0, NULL, 'L', 0, 5, 100163),
(58732, 'Sportback 1.8L 手动 精智版', NULL, 5104, 0, NULL, 'L', 0, 5, 100162),
(58731, 'Sportback 1.8L 自动 风尚版', NULL, 5104, 0, NULL, 'L', 0, 5, 100161),
(58730, 'Sportback 1.8L 自动 精智版', NULL, 5104, 0, NULL, 'L', 0, 5, 100160),
(58729, 'Sportback 1.8L 自动 精智导航版', NULL, 5104, 0, NULL, 'L', 0, 5, 100157),
(58728, 'GTS 1.6L 自动 豪华型', NULL, 5103, 0, NULL, 'L', 0, 5, 105217),
(58727, 'GTS 1.6L 手动 豪华型', NULL, 5103, 0, NULL, 'L', 0, 5, 105215),
(58726, 'GTS 1.6L 自动 劲取型', NULL, 5103, 0, NULL, 'L', 0, 5, 105214),
(58725, 'GTS 1.6L 手动 劲取型', NULL, 5103, 0, NULL, 'L', 0, 5, 105211),
(58724, '1.6L 自动 豪华型', NULL, 5102, 0, NULL, 'L', 0, 5, 106124),
(58723, '1.6L 自动 劲取型', NULL, 5102, 0, NULL, 'L', 0, 5, 106123),
(58722, '1.6L 手动 豪华型', NULL, 5102, 0, NULL, 'L', 0, 5, 106122),
(58721, '1.6L 手动 劲取型', NULL, 5102, 0, NULL, 'L', 0, 5, 106121),
(58720, '1.6L 手动 精英型', NULL, 5101, 0, NULL, 'L', 0, 5, 9754),
(58719, '1.6L 自动 精英型', NULL, 5101, 0, NULL, 'L', 0, 5, 9753),
(58718, '1.6L 自动 豪华型', NULL, 5101, 0, NULL, 'L', 0, 5, 9451),
(58717, '1.6L 手动 豪华型', NULL, 5101, 0, NULL, 'L', 0, 5, 9450),
(58716, '1.6 手动 精英型 ', NULL, 5100, 0, NULL, 'L', 0, 5, 108216),
(58715, '1.6 自动 精英型 ', NULL, 5100, 0, NULL, 'L', 0, 5, 108215),
(58714, '1.6 手动 豪华型 ', NULL, 5100, 0, NULL, 'L', 0, 5, 108214),
(58713, '1.6 自动 豪华型 ', NULL, 5100, 0, NULL, 'L', 0, 5, 108213),
(58712, '1.5L 自动 精致型', NULL, 5099, 0, NULL, 'L', 0, 5, 103717),
(58711, '1.5L 手动 精致型', NULL, 5099, 0, NULL, 'L', 0, 5, 103716),
(58710, '1.5L 手动 精英型', NULL, 5099, 0, NULL, 'L', 0, 5, 103715),
(58709, '1.5L 自动 精英型', NULL, 5099, 0, NULL, 'L', 0, 5, 103707),
(58708, '1.5L 手动 基本型', NULL, 5099, 0, NULL, 'L', 0, 5, 103700),
(58707, 'GT 1.6L 自动 精英型', NULL, 5099, 0, NULL, 'L', 0, 5, 103545),
(58706, 'GT 1.6L 自动 精致型', NULL, 5099, 0, NULL, 'L', 0, 5, 103544),
(58705, 'GT 1.6L 手动 精英型', NULL, 5099, 0, NULL, 'L', 0, 5, 103543),
(58704, 'GT 1.6L 手动 精致型', NULL, 5099, 0, NULL, 'L', 0, 5, 102735),
(58703, '1.6 手动 时尚型', NULL, 5098, 0, NULL, 'L', 0, 5, 108212),
(58702, '1.6 自动 时尚型', NULL, 5098, 0, NULL, 'L', 0, 5, 108211),
(58701, '1.6 手动 豪华型', NULL, 5098, 0, NULL, 'L', 0, 5, 108210),
(58700, '1.6 自动 豪华型', NULL, 5098, 0, NULL, 'L', 0, 5, 108209),
(58699, '豪华型 4AT', NULL, 5098, 0, NULL, 'L', 0, 5, 9756),
(58698, '豪华型 5MT', NULL, 5098, 0, NULL, 'L', 0, 5, 9755),
(58697, '运动型豪华版 4AT', NULL, 5098, 0, NULL, 'L', 0, 5, 9455),
(58696, '运动型豪华版 5MT', NULL, 5098, 0, NULL, 'L', 0, 5, 9454),
(58695, '运动型时尚版 4AT', NULL, 5098, 0, NULL, 'L', 0, 5, 9453),
(58694, '运动型时尚版 5MT', NULL, 5098, 0, NULL, 'L', 0, 5, 9452),
(58693, '时尚型 5MT', NULL, 5098, 0, NULL, 'L', 0, 5, 9449),
(58692, '标准型 5MT', NULL, 5098, 0, NULL, 'L', 0, 5, 9317),
(58691, '时尚型 4AT', NULL, 5098, 0, NULL, 'L', 0, 5, 9284),
(58690, '1.6L 自动 豪华型', NULL, 5097, 0, NULL, 'L', 0, 5, 15182),
(58689, '1.6L 手动 豪华型', NULL, 5097, 0, NULL, 'L', 0, 5, 15181),
(58688, '1.6L 自动 时尚型', NULL, 5097, 0, NULL, 'L', 0, 5, 15179),
(58687, '1.6L 手动 时尚型', NULL, 5097, 0, NULL, 'L', 0, 5, 15177),
(58686, '1.5L 自动 精致型', NULL, 5096, 0, NULL, 'L', 0, 5, 103706),
(58685, '1.5L 自动 精英型', NULL, 5096, 0, NULL, 'L', 0, 5, 103704),
(58684, '1.5L 手动 精致型', NULL, 5096, 0, NULL, 'L', 0, 5, 103703),
(58683, '1.5L 手动 精英型', NULL, 5096, 0, NULL, 'L', 0, 5, 103701),
(58682, '1.5L 手动 基本型', NULL, 5096, 0, NULL, 'L', 0, 5, 103699),
(58681, 'GT 1.6L 自动 精英型', NULL, 5096, 0, NULL, 'L', 0, 5, 103548),
(58680, 'GT 1.6L 自动 精致型', NULL, 5096, 0, NULL, 'L', 0, 5, 103547),
(58679, 'GT 1.6L 手动 精英型', NULL, 5096, 0, NULL, 'L', 0, 5, 103546),
(58678, 'GT 1.6L 手动 精致型', NULL, 5096, 0, NULL, 'L', 0, 5, 103326),
(58677, '莲花L3 GT 1.6L 自动 精致型', NULL, 5095, 0, NULL, 'L', 0, 5, 106120),
(58676, '莲花L3 GT 1.6L 手动 精致型', NULL, 5095, 0, NULL, 'L', 0, 5, 106118),
(58675, '1.6L 手动 运动版', NULL, 5094, 0, NULL, 'L', 0, 5, 108220),
(58674, '1.6L 手动 豪华版', NULL, 5094, 0, NULL, 'L', 0, 5, 108219),
(58673, '1.6L 自动 运动版', NULL, 5094, 0, NULL, 'L', 0, 5, 108218),
(58672, '1.6L 自动 豪华版', NULL, 5094, 0, NULL, 'L', 0, 5, 108217),
(58671, '1.6L 自动 时尚型', NULL, 5093, 0, NULL, 'L', 0, 5, 109171),
(58670, '1.6L MT 时尚型', NULL, 5093, 0, NULL, 'L', 0, 5, 13713),
(58669, '1.6L AT运动版', NULL, 5093, 0, NULL, 'L', 0, 5, 7837),
(58668, '1.6L MT运动版', NULL, 5093, 0, NULL, 'L', 0, 5, 7836),
(58667, '1.6L AT豪华版', NULL, 5093, 0, NULL, 'L', 0, 5, 7835),
(58666, '1.6L MT豪华版', NULL, 5093, 0, NULL, 'L', 0, 5, 7834),
(58665, '罗孚75 2.5L 自动豪华型', NULL, 5092, 0, NULL, 'L', 0, 5, 100036),
(58664, '75', NULL, 5091, 0, NULL, 'L', 0, 5, 6907),
(58663, 'coupe 1.8手动', NULL, 5090, 0, NULL, 'L', 0, 5, 10467),
(58662, '2.5L 自动 旗舰导航版', NULL, 5089, 0, NULL, 'L', 0, 5, 13538),
(58661, '2.0L 自动 时尚版', NULL, 5089, 0, NULL, 'L', 0, 5, 13537),
(58660, '2.5L 自动 豪华导航版', NULL, 5089, 0, NULL, 'L', 0, 5, 13373),
(58659, '2.0L 自动 豪华导航版', NULL, 5089, 0, NULL, 'L', 0, 5, 13363),
(58658, '2.0L 悦享版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104848),
(58657, '2.0L 舒适版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104847),
(58656, '2.0L 时尚版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104845),
(58655, '2.0L 豪华版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104844),
(58654, '2.5L 旗舰版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104842),
(58653, '2.5L 豪华版 改款', NULL, 5088, 0, NULL, 'L', 0, 5, 104698),
(58652, '2.0L 自动 时尚版', NULL, 5088, 0, NULL, 'L', 0, 5, 103631),
(58651, '2.0L 自动 豪华导航版', NULL, 5088, 0, NULL, 'L', 0, 5, 103630),
(58650, '2.5L 自动 豪华导航版', NULL, 5088, 0, NULL, 'L', 0, 5, 103629),
(58649, '2.5L 自动 旗舰导航版', NULL, 5088, 0, NULL, 'L', 0, 5, 103628),
(58648, '3.5L 手自一体 Nappa行政版', NULL, 5087, 0, NULL, 'L', 0, 5, 100111),
(58647, '3.5L 手自一体 行政版', NULL, 5087, 0, NULL, 'L', 0, 5, 100110),
(58646, '2.5L 手自一体 Nappa旗舰版', NULL, 5087, 0, NULL, 'L', 0, 5, 100109),
(58645, '2.5L 手自一体 尊贵版', NULL, 5087, 0, NULL, 'L', 0, 5, 100108),
(58644, '2.5L 手自一体 豪华版', NULL, 5087, 0, NULL, 'L', 0, 5, 100107),
(58643, '3.5L 手自一体 Nappa行政版', NULL, 5086, 0, NULL, 'L', 0, 5, 104583),
(58642, '2.5L 手自一体 Nappa旗舰版', NULL, 5086, 0, NULL, 'L', 0, 5, 104582),
(58641, '2.5L 手自一体 豪华版', NULL, 5086, 0, NULL, 'L', 0, 5, 104581),
(58640, '梅甘娜古贝1.6轿跑车', NULL, 5085, 0, NULL, 'L', 0, 5, 6498),
(58639, '两厢 2.0自动', NULL, 5084, 0, NULL, 'L', 0, 5, 10466),
(58638, '敞篷车 1.6', NULL, 5083, 0, NULL, 'L', 0, 5, 10465),
(58637, '梅甘娜经典（MeganeClassic）2.0', NULL, 5082, 0, NULL, 'L', 0, 5, 6499),
(58636, '梅甘娜CC', NULL, 5081, 0, NULL, 'L', 0, 5, 6497),
(58635, '硬顶敞篷车', NULL, 5081, 0, NULL, 'L', 0, 5, 3765),
(58634, '三厢轿车', NULL, 5081, 0, NULL, 'L', 0, 5, 3764),
(58633, '2.0豪华型', NULL, 5080, 0, NULL, 'L', 0, 5, 10464),
(58632, '2.0舒适型', NULL, 5080, 0, NULL, 'L', 0, 5, 10463),
(58631, '2.0标准型', NULL, 5080, 0, NULL, 'L', 0, 5, 10462),
(58630, 'CC 2.0L CVT 时尚导航版', NULL, 5079, 0, NULL, 'L', 0, 5, 15037),
(58629, '3.5 自动版', NULL, 5078, 0, NULL, 'L', 0, 5, 109608),
(58628, '威赛帝', NULL, 5078, 0, NULL, 'L', 0, 5, 3745),
(58627, '拉古那Ⅱ2.0豪华型', NULL, 5077, 0, NULL, 'L', 0, 5, 3746),
(58626, '2.0 16V VVT', NULL, 5076, 0, NULL, 'L', 0, 5, 3766),
(58625, '2.0T 170马力 6档手自一体', NULL, 5075, 0, NULL, 'L', 0, 5, 7365),
(58624, '2.0T 豪华导航版', NULL, 5074, 0, NULL, 'L', 0, 5, 13591),
(58623, '2.0T 舒适版', NULL, 5074, 0, NULL, 'L', 0, 5, 13590),
(58622, '2.0T 技术版', NULL, 5074, 0, NULL, 'L', 0, 5, 13589),
(58621, '拉古娜古贝 豪华导航版', NULL, 5073, 0, NULL, 'L', 0, 5, 15576),
(58620, '四驱豪华版', NULL, 5072, 0, NULL, 'L', 0, 5, 8318),
(58619, '四驱舒适版', NULL, 5072, 0, NULL, 'L', 0, 5, 8317),
(58618, '二驱豪华版', NULL, 5072, 0, NULL, 'L', 0, 5, 8316),
(58617, '二驱舒适版', NULL, 5072, 0, NULL, 'L', 0, 5, 8315),
(58616, '4X4 BOSE限量版', NULL, 5071, 0, NULL, 'L', 0, 5, 12047),
(58615, '4X2 时尚版', NULL, 5071, 0, NULL, 'L', 0, 5, 11019),
(58614, '4X2 豪华版', NULL, 5071, 0, NULL, 'L', 0, 5, 10741),
(58613, '4X2 舒适版', NULL, 5071, 0, NULL, 'L', 0, 5, 10740),
(58612, '4X4 豪华版', NULL, 5071, 0, NULL, 'L', 0, 5, 10616),
(58611, '4X4 舒适版', NULL, 5071, 0, NULL, 'L', 0, 5, 10615),
(58610, '2.5L 四驱 豪华导航版', NULL, 5070, 0, NULL, 'L', 0, 5, 15071),
(58609, '2.5L 两驱 豪华导航版', NULL, 5070, 0, NULL, 'L', 0, 5, 15070),
(58608, '2.5L 四驱 舒适导航版', NULL, 5070, 0, NULL, 'L', 0, 5, 15069),
(58607, '2.5L 两驱 舒适导航版', NULL, 5070, 0, NULL, 'L', 0, 5, 15068),
(58606, '2.5L 四驱 都市版', NULL, 5070, 0, NULL, 'L', 0, 5, 15067),
(58605, '2.5L 两驱 都市版', NULL, 5070, 0, NULL, 'L', 0, 5, 15066),
(58604, '2.5L 四驱 豪华导航版', NULL, 5069, 0, NULL, 'L', 0, 5, 104468),
(58603, '2.5L 两驱 豪华导航版', NULL, 5069, 0, NULL, 'L', 0, 5, 104467),
(58602, '2.5L 四驱 舒适导航版', NULL, 5069, 0, NULL, 'L', 0, 5, 104466),
(58601, '2.5L 两驱 舒适导航版', NULL, 5069, 0, NULL, 'L', 0, 5, 104464),
(58600, '2.5L 两驱 都市版', NULL, 5069, 0, NULL, 'L', 0, 5, 102238),
(58599, '2.5L 四驱 都市版', NULL, 5069, 0, NULL, 'L', 0, 5, 102237),
(58598, '2.5L 两驱 舒适版', NULL, 5069, 0, NULL, 'L', 0, 5, 102236),
(58597, '2.5L 四驱 舒适版', NULL, 5069, 0, NULL, 'L', 0, 5, 102235),
(58596, '2.5L 两驱 豪华版', NULL, 5069, 0, NULL, 'L', 0, 5, 102234),
(58595, '2.5L 四驱 豪华版', NULL, 5069, 0, NULL, 'L', 0, 5, 102232),
(58594, '2.5L 四驱 豪华版', NULL, 5068, 0, NULL, 'L', 0, 5, 105147),
(58593, '2.0L 两驱 智享版 ', NULL, 5068, 0, NULL, 'L', 0, 5, 105141),
(58592, '2.0L 两驱 标准版 ', NULL, 5068, 0, NULL, 'L', 0, 5, 105139),
(58591, '2.0L 两驱 时尚版 ', NULL, 5068, 0, NULL, 'L', 0, 5, 105138),
(58590, '2.5L 两驱 都市版 ', NULL, 5068, 0, NULL, 'L', 0, 5, 105137),
(58589, '2.5L 两驱 舒适版 ', NULL, 5068, 0, NULL, 'L', 0, 5, 105136),
(58588, '2.5L 四驱 舒适版', NULL, 5068, 0, NULL, 'L', 0, 5, 105135),
(58587, '2.0L 自动 豪华导航版', NULL, 5067, 0, NULL, 'L', 0, 5, 14068),
(58586, '2.0L 自动 时尚版', NULL, 5067, 0, NULL, 'L', 0, 5, 14067),
(58585, '2.0L 自动 标准版', NULL, 5067, 0, NULL, 'L', 0, 5, 14066),
(58584, '2.0L 自动 悦享版', NULL, 5066, 0, NULL, 'L', 0, 5, 103878),
(58583, '2.0L 自动 舒适版', NULL, 5066, 0, NULL, 'L', 0, 5, 103877),
(58582, '2.0L 自动 标准版', NULL, 5066, 0, NULL, 'L', 0, 5, 103489),
(58581, '2.0L 自动 豪华版', NULL, 5066, 0, NULL, 'L', 0, 5, 103488),
(58580, '2.0L 自动 时尚版', NULL, 5066, 0, NULL, 'L', 0, 5, 103487),
(58579, '1.6-MT-16V (2003)', NULL, 5065, 0, NULL, 'L', 0, 5, 102663),
(58578, '风景2.0AT', NULL, 5064, 0, NULL, 'L', 0, 5, 3748),
(58577, '风景四驱RX4', NULL, 5063, 0, NULL, 'L', 0, 5, 3749),
(58576, '风景1.6AT', NULL, 5063, 0, NULL, 'L', 0, 5, 3747),
(58575, '大风景', NULL, 5062, 0, NULL, 'L', 0, 5, 3751),
(58574, '风景', NULL, 5062, 0, NULL, 'L', 0, 5, 3750),
(58573, '7座风景 舒适版', NULL, 5061, 0, NULL, 'L', 0, 5, 12996),
(58572, '5座风景 舒适版', NULL, 5061, 0, NULL, 'L', 0, 5, 12995),
(58571, '5座风景 时尚版', NULL, 5061, 0, NULL, 'L', 0, 5, 12994),
(58570, '2.0L 自动 时尚版 5座', NULL, 5060, 0, NULL, 'L', 0, 5, 16413),
(58569, '2.0L 自动 舒适版 5座', NULL, 5060, 0, NULL, 'L', 0, 5, 16412),
(58568, '2.0L 自动 豪华导航版 5座', NULL, 5060, 0, NULL, 'L', 0, 5, 16411),
(58567, '2.0L 自动 舒适版 7座', NULL, 5060, 0, NULL, 'L', 0, 5, 16410),
(58566, '2.0L 自动 豪华导航版 7座', NULL, 5060, 0, NULL, 'L', 0, 5, 16408),
(58565, '自由人Freelander 2.5', NULL, 5059, 0, NULL, 'L', 0, 5, 9833),
(58564, '1.8 AT 5门', NULL, 5058, 0, NULL, 'L', 0, 5, 9042),
(58563, '3.2  HSE(高配)', NULL, 5057, 0, NULL, 'L', 0, 5, 9183),
(58562, '3.2L SE', NULL, 5057, 0, NULL, 'L', 0, 5, 9182),
(58561, 'L6 3.2L HSE', NULL, 5057, 0, NULL, 'L', 0, 5, 3738),
(58560, 'i6 SE', NULL, 5056, 0, NULL, 'L', 0, 5, 9378),
(58559, 'i6 HSE+ 汽油款(自动)', NULL, 5056, 0, NULL, 'L', 0, 5, 9003),
(58558, 'TD4 SE柴油款(手动STOP/START)', NULL, 5056, 0, NULL, 'L', 0, 5, 8948),
(58557, 'i6 HSE汽油款(自动)', NULL, 5056, 0, NULL, 'L', 0, 5, 3737),
(58556, 'TD4 HSE柴油款(自动)', NULL, 5056, 0, NULL, 'L', 0, 5, 3700),
(58555, 'TD4 SE柴油款(自动)', NULL, 5056, 0, NULL, 'L', 0, 5, 3699),
(58554, 'I6 Auto HSE', NULL, 5055, 0, NULL, 'L', 0, 5, 12612),
(58553, 'SD4 Auto HSE', NULL, 5055, 0, NULL, 'L', 0, 5, 12611),
(58552, 'I6 Auto SE', NULL, 5055, 0, NULL, 'L', 0, 5, 12610),
(58551, 'SD4 Auto SE', NULL, 5055, 0, NULL, 'L', 0, 5, 12608),
(58550, '2.2T SD4 越动限量版', NULL, 5054, 0, NULL, 'L', 0, 5, 104138),
(58549, '2.0T Si4 越动限量版', NULL, 5054, 0, NULL, 'L', 0, 5, 103568),
(58548, '2.2T SD4 HSE柴油款', NULL, 5054, 0, NULL, 'L', 0, 5, 101134),
(58547, '2.2T SD4 SE柴油款', NULL, 5054, 0, NULL, 'L', 0, 5, 101133),
(58546, '2.2T SD4 S柴油款', NULL, 5054, 0, NULL, 'L', 0, 5, 101130),
(58545, '2.0T Si4 SE 汽油版', NULL, 5054, 0, NULL, 'L', 0, 5, 16250),
(58544, '2.0T Si4 HSE 汽油版', NULL, 5054, 0, NULL, 'L', 0, 5, 16248),
(58543, '2.2T SD4 AUTO S版 柴油', NULL, 5053, 0, NULL, 'L', 0, 5, 109812),
(58542, '2.2T SD4 AUTO SE版 柴油', NULL, 5053, 0, NULL, 'L', 0, 5, 109810),
(58541, '2.0T Si4 AUTO S版', NULL, 5053, 0, NULL, 'L', 0, 5, 109809),
(58540, '2.0T Si4 AUTO SE版', NULL, 5053, 0, NULL, 'L', 0, 5, 109808),
(58539, '2.0T Si4 AUTO HSE版', NULL, 5053, 0, NULL, 'L', 0, 5, 109807),
(58538, '卫士90', NULL, 5052, 0, NULL, 'L', 0, 5, 6501),
(58537, '卫士110', NULL, 5052, 0, NULL, 'L', 0, 5, 6500),
(58536, '90', NULL, 5051, 0, NULL, 'L', 0, 5, 10713),
(58535, '90 冰·火限量版', NULL, 5051, 0, NULL, 'L', 0, 5, 10634),
(58534, '4.4L V8 自然进气', NULL, 5050, 0, NULL, 'L', 0, 5, 3740),
(58533, '4.2L运动版 机械增压', NULL, 5050, 0, NULL, 'L', 0, 5, 3694),
(58532, '5.0 V8 SC HSE', NULL, 5049, 0, NULL, 'L', 0, 5, 9190),
(58531, '5.0 V8 NA HSE', NULL, 5049, 0, NULL, 'L', 0, 5, 9189),
(58530, '3.6TD V8 HSE', NULL, 5049, 0, NULL, 'L', 0, 5, 9188),
(58529, '3.0TD V6 HSE', NULL, 5049, 0, NULL, 'L', 0, 5, 9187),
(58528, '5.0L V8 Autobiography', NULL, 5048, 0, NULL, 'L', 0, 5, 12613),
(58527, '3.0L TDV6 Sporty', NULL, 5048, 0, NULL, 'L', 0, 5, 12609),
(58526, '5.0L V8 SC HSE', NULL, 5048, 0, NULL, 'L', 0, 5, 12607),
(58525, '5.0L V8 NA HSE', NULL, 5048, 0, NULL, 'L', 0, 5, 12606),
(58524, '3.0L TDV6', NULL, 5048, 0, NULL, 'L', 0, 5, 12602),
(58523, '5.0 V8 SC锋尚创世版', NULL, 5047, 0, NULL, 'L', 0, 5, 15684),
(58522, '5.0L V8 SC HSE', NULL, 5047, 0, NULL, 'L', 0, 5, 15681),
(58521, '5.0L V8 NA HSE', NULL, 5047, 0, NULL, 'L', 0, 5, 15677),
(58520, '3.0 TDV6 HSE+ 柴油款', NULL, 5047, 0, NULL, 'L', 0, 5, 15675),
(58519, '3.0 TDV6 HSE 柴油款', NULL, 5047, 0, NULL, 'L', 0, 5, 15674),
(58518, '5.0L V8 NA 黑标限量版', NULL, 5046, 0, NULL, 'L', 0, 5, 104117),
(58517, '3.0 TDV6 HSE 黑标限量版', NULL, 5046, 0, NULL, 'L', 0, 5, 104115),
(58516, '5.0L V8 SC HSE', NULL, 5046, 0, NULL, 'L', 0, 5, 102723),
(58515, '3.0 TDV6 HSE 柴油极致运动版', NULL, 5046, 0, NULL, 'L', 0, 5, 102722),
(58514, '5.0L V8 NA HSE', NULL, 5046, 0, NULL, 'L', 0, 5, 102721),
(58513, '3.0 TDV6 HSE 柴油款', NULL, 5046, 0, NULL, 'L', 0, 5, 102720),
(58512, '5.0 V8 SC锋尚创世版', NULL, 5046, 0, NULL, 'L', 0, 5, 102718),
(58511, '5.0L V8 NA HSE 驭红限量版', NULL, 5046, 0, NULL, 'L', 0, 5, 102071),
(58510, '3.0 V6 SC 汽油版 智利红限量版', NULL, 5045, 0, NULL, 'L', 0, 5, 105183),
(58509, '5.0 V8 SC 汽油版 锋尚创世版Dynamic', NULL, 5045, 0, NULL, 'L', 0, 5, 104007),
(58508, '3.0 V6 SC 汽油版 锋尚创世版', NULL, 5045, 0, NULL, 'L', 0, 5, 104006),
(58507, '3.0 V6 SC 汽油版 HSE Dynamic', NULL, 5045, 0, NULL, 'L', 0, 5, 104005),
(58506, '3.0 V6 SC 汽油版 HSE', NULL, 5045, 0, NULL, 'L', 0, 5, 104004),
(58505, '2.0T 5门耀致版', NULL, 5044, 0, NULL, 'L', 0, 5, 13492),
(58504, '2.0T 3门耀致版', NULL, 5044, 0, NULL, 'L', 0, 5, 13491),
(58503, '2.0T 5门耀动版', NULL, 5044, 0, NULL, 'L', 0, 5, 13490),
(58502, '2.0T 3门耀动版', NULL, 5044, 0, NULL, 'L', 0, 5, 13489),
(58501, '2.0T 维多利亚限量版', NULL, 5043, 0, NULL, 'L', 0, 5, 102519),
(58500, '2.0T Coupe 3门耀动版', NULL, 5043, 0, NULL, 'L', 0, 5, 15827),
(58499, '2.0T Coupe 3门耀致版', NULL, 5043, 0, NULL, 'L', 0, 5, 15826),
(58498, '2.0T 5门耀动版', NULL, 5043, 0, NULL, 'L', 0, 5, 15822),
(58497, '2.0T 5门耀致版', NULL, 5043, 0, NULL, 'L', 0, 5, 15820),
(58496, '2.0T 5门熠动限量版', NULL, 5042, 0, NULL, 'L', 0, 5, 104701),
(58495, '2.2T 5门柴油版', NULL, 5042, 0, NULL, 'L', 0, 5, 104567),
(58494, '2.0T 3门维多利亚限量版', NULL, 5042, 0, NULL, 'L', 0, 5, 104566),
(58493, '2.0T 3门眩蓝限量版', NULL, 5042, 0, NULL, 'L', 0, 5, 104222),
(58492, '2.0T 5门耀真版', NULL, 5042, 0, NULL, 'L', 0, 5, 104118),
(58491, '2.0T 3门耀动版', NULL, 5042, 0, NULL, 'L', 0, 5, 102611),
(58490, '2.0T 3门耀致版', NULL, 5042, 0, NULL, 'L', 0, 5, 102610),
(58489, '2.0T 5门耀动版', NULL, 5042, 0, NULL, 'L', 0, 5, 102609),
(58488, '2.0T 5门耀致版', NULL, 5042, 0, NULL, 'L', 0, 5, 102606),
(58487, '2.0T 5门限量版', NULL, 5041, 0, NULL, 'L', 0, 5, 106514),
(58486, '2.0T 5门耀动版', NULL, 5041, 0, NULL, 'L', 0, 5, 106513),
(58485, '2.0T 5门耀享版', NULL, 5041, 0, NULL, 'L', 0, 5, 106512),
(58484, '2.0T 5门耀真版', NULL, 5041, 0, NULL, 'L', 0, 5, 106511),
(58483, '2.0T 5门圣诞限量版', NULL, 5041, 0, NULL, 'L', 0, 5, 106119),
(58482, '4.6HSE AT', NULL, 5040, 0, NULL, 'L', 0, 5, 9041),
(58481, '4.4 AT V8', NULL, 5039, 0, NULL, 'L', 0, 5, 15636),
(58480, '揽胜柴油版', NULL, 5039, 0, NULL, 'L', 0, 5, 8166),
(58479, '4.2L 个性版', NULL, 5038, 0, NULL, 'L', 0, 5, 8156),
(58478, '4.4L机械增压版', NULL, 5037, 0, NULL, 'L', 0, 5, 3744),
(58477, 'V8 4.2 机械增压', NULL, 5037, 0, NULL, 'L', 0, 5, 3743),
(58476, 'V8 4.4', NULL, 5037, 0, NULL, 'L', 0, 5, 3742),
(58475, 'V8 4.2 机械增压', NULL, 5036, 0, NULL, 'L', 0, 5, 3741),
(58474, 'V8 4.4', NULL, 5036, 0, NULL, 'L', 0, 5, 3739),
(58473, '5.0 V8 SC 尊崇创世版', NULL, 5035, 0, NULL, 'L', 0, 5, 9194);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(58472, '5.0 V8 SC HSE', NULL, 5035, 0, NULL, 'L', 0, 5, 9193),
(58471, '5.0 V8 NA HSE', NULL, 5035, 0, NULL, 'L', 0, 5, 9192),
(58470, '3.6 TDV8 HSE', NULL, 5035, 0, NULL, 'L', 0, 5, 9191),
(58469, '4.4L TDV8 柴油 自动', NULL, 5034, 0, NULL, 'L', 0, 5, 15540),
(58468, '加长 5.0L V8 涡轮增压版', NULL, 5034, 0, NULL, 'L', 0, 5, 15516),
(58467, '5.0 V8 SC 创世尊崇版', NULL, 5034, 0, NULL, 'L', 0, 5, 12605),
(58466, '5.0 V8 SC', NULL, 5034, 0, NULL, 'L', 0, 5, 12604),
(58465, '5.0 V8 NA', NULL, 5034, 0, NULL, 'L', 0, 5, 12603),
(58464, '3.6 TDV8', NULL, 5034, 0, NULL, 'L', 0, 5, 12601),
(58463, '巅峰创世典藏版', NULL, 5033, 0, NULL, 'L', 0, 5, 16278),
(58462, '5.0 V8 SC手自一体创世尊荣版', NULL, 5033, 0, NULL, 'L', 0, 5, 15825),
(58461, '5.0 V8 SC手自一体', NULL, 5033, 0, NULL, 'L', 0, 5, 15824),
(58460, '5.0 V8 NA 手自一体', NULL, 5033, 0, NULL, 'L', 0, 5, 15821),
(58459, '4.4 TDV8 手自一体', NULL, 5033, 0, NULL, 'L', 0, 5, 15819),
(58458, '3.6 TDV8 手自一体', NULL, 5033, 0, NULL, 'L', 0, 5, 15815),
(58457, '3.0 TDV6 Vogue ', NULL, 5032, 0, NULL, 'L', 0, 5, 103539),
(58456, '5.0L V8 VOGUE版', NULL, 5032, 0, NULL, 'L', 0, 5, 102605),
(58455, '5.0L V8 VOGUE SE版', NULL, 5032, 0, NULL, 'L', 0, 5, 102601),
(58454, '5.0T V8 VOGUE SE版', NULL, 5032, 0, NULL, 'L', 0, 5, 102598),
(58453, '5.0T V8 尊崇创世版', NULL, 5032, 0, NULL, 'L', 0, 5, 102595),
(58452, '5.0L V8 SC AB 巅峰创世加长版', NULL, 5031, 0, NULL, 'L', 0, 5, 111132),
(58451, '5.0L V8 SC AB 尊崇创世加长版', NULL, 5031, 0, NULL, 'L', 0, 5, 110601),
(58450, '3.0L V6 SC Vogue SE 创世加长版', NULL, 5031, 0, NULL, 'L', 0, 5, 110599),
(58449, '3.0L TDV6 Vogue SE 创世加长版', NULL, 5031, 0, NULL, 'L', 0, 5, 110598),
(58448, '改款 3.0L V6 SC Vogue', NULL, 5031, 0, NULL, 'L', 0, 5, 110597),
(58447, '3.0L TDV6 Vogue', NULL, 5031, 0, NULL, 'L', 0, 5, 110596),
(58446, '3.0 V6 SC Vogue', NULL, 5031, 0, NULL, 'L', 0, 5, 104859),
(58445, '3.0 V6 SC Vogue SE', NULL, 5031, 0, NULL, 'L', 0, 5, 104793),
(58444, '3.0 TDV6 Vogue SE', NULL, 5031, 0, NULL, 'L', 0, 5, 104792),
(58443, '发现2', NULL, 5030, 0, NULL, 'L', 0, 5, 3701),
(58442, '发现3 2.7L V6 柴油版', NULL, 5029, 0, NULL, 'L', 0, 5, 8766),
(58441, '3 4.0 V6 HSE', NULL, 5029, 0, NULL, 'L', 0, 5, 3736),
(58440, '3 4.4 V8 HSE', NULL, 5029, 0, NULL, 'L', 0, 5, 3735),
(58439, '发现3 4.4 V8', NULL, 5029, 0, NULL, 'L', 0, 5, 3702),
(58438, '新发现', NULL, 5029, 0, NULL, 'L', 0, 5, 3696),
(58437, '发现3 2.7L（高配）', NULL, 5028, 0, NULL, 'L', 0, 5, 8155),
(58436, '3 2.7 TDV6—S', NULL, 5028, 0, NULL, 'L', 0, 5, 8154),
(58435, '第四代 5.0 V8 HSE', NULL, 5027, 0, NULL, 'L', 0, 5, 9186),
(58434, '第四代 4.0 V6 HSE', NULL, 5027, 0, NULL, 'L', 0, 5, 9185),
(58433, '第四代 3.0 TDV6 HSE', NULL, 5027, 0, NULL, 'L', 0, 5, 9184),
(58432, '第四代 2.7 TDV6 S', NULL, 5027, 0, NULL, 'L', 0, 5, 3695),
(58431, '第四代 5.0 V8 HSE', NULL, 5026, 0, NULL, 'L', 0, 5, 12617),
(58430, '第四代 4.0 V6', NULL, 5026, 0, NULL, 'L', 0, 5, 12616),
(58429, '第四代 3.0 SDV6', NULL, 5026, 0, NULL, 'L', 0, 5, 12615),
(58428, '第四代 2.7 TDV6', NULL, 5026, 0, NULL, 'L', 0, 5, 12614),
(58427, '第四代 5.0 V8尊黑限量版', NULL, 5025, 0, NULL, 'L', 0, 5, 105134),
(58426, '第四代 3.0 SDV6 尊黑限量版', NULL, 5025, 0, NULL, 'L', 0, 5, 105100),
(58425, '第四代 5.0 V8 SE 汽油版', NULL, 5025, 0, NULL, 'L', 0, 5, 15818),
(58424, '第四代 5.0 V8 HSE 汽油版', NULL, 5025, 0, NULL, 'L', 0, 5, 15816),
(58423, '第四代 3.0 SDV6 HSE 柴油版', NULL, 5025, 0, NULL, 'L', 0, 5, 15814),
(58422, '第四代 3.0 SDV6 HSE 柴油版', NULL, 5024, 0, NULL, 'L', 0, 5, 110050),
(58421, '第四代 3.0 V6 SC SE 汽油版', NULL, 5024, 0, NULL, 'L', 0, 5, 110049),
(58420, '第四代 3.0 V6 SC HSE 汽油版', NULL, 5024, 0, NULL, 'L', 0, 5, 110048),
(58419, '第四代 3.0 V6 SC HSE Luxury 汽油版', NULL, 5024, 0, NULL, 'L', 0, 5, 106313),
(58418, 'V8 5.8L', NULL, 5023, 0, NULL, 'L', 0, 5, 11119),
(58417, '林肯陆军一号', NULL, 5022, 0, NULL, 'L', 0, 5, 7908),
(58416, '陆军一号', NULL, 5022, 0, NULL, 'L', 0, 5, 7907),
(58415, '5.4L', NULL, 5021, 0, NULL, 'L', 0, 5, 3721),
(58414, '商务舱加长版', NULL, 5020, 0, NULL, 'L', 0, 5, 5833),
(58413, '加长版', NULL, 5020, 0, NULL, 'L', 0, 5, 3726),
(58412, '外交官 NAVIGATOR DIPLOMAT', NULL, 5020, 0, NULL, 'L', 0, 5, 3285),
(58411, '外交官 V8 5.4L', NULL, 5020, 0, NULL, 'L', 0, 5, 3284),
(58410, '外交官(终极版)4驱', NULL, 5019, 0, NULL, 'L', 0, 5, 11162),
(58409, '领航员 140英寸加长', NULL, 5019, 0, NULL, 'L', 0, 5, 11161),
(58408, '领袖一号 5.4L V8', NULL, 5018, 0, NULL, 'L', 0, 5, 15514),
(58407, '5.4L V8', NULL, 5018, 0, NULL, 'L', 0, 5, 15513),
(58406, '领袖一号 5.4L V8', NULL, 5017, 0, NULL, 'L', 0, 5, 102427),
(58405, '外交官 5.4L 自动', NULL, 5017, 0, NULL, 'L', 0, 5, 16407),
(58404, '5.4L V8', NULL, 5017, 0, NULL, 'L', 0, 5, 16069),
(58403, '120加长车', NULL, 5016, 0, NULL, 'L', 0, 5, 3283),
(58402, '100加长车', NULL, 5016, 0, NULL, 'L', 0, 5, 3282),
(58401, '70加长车', NULL, 5016, 0, NULL, 'L', 0, 5, 3281),
(58400, '3.5L AWD', NULL, 5015, 0, NULL, 'L', 0, 5, 5453),
(58399, '3.5L FWD', NULL, 5015, 0, NULL, 'L', 0, 5, 5450),
(58398, '3.5L FWD', NULL, 5014, 0, NULL, 'L', 0, 5, 109503),
(58397, '3.5L AWD', NULL, 5013, 0, NULL, 'L', 0, 5, 109502),
(58396, '飞行员', NULL, 5012, 0, NULL, 'L', 0, 5, 3280),
(58395, '限量版', NULL, 5011, 0, NULL, 'L', 0, 5, 9962),
(58394, '3.7L V6', NULL, 5010, 0, NULL, 'L', 0, 5, 13188),
(58393, '3.7L 四驱', NULL, 5009, 0, NULL, 'L', 0, 5, 102515),
(58392, '3.7L 四驱 美规版', NULL, 5008, 0, NULL, 'L', 0, 5, 104411),
(58391, '3.7L', NULL, 5007, 0, NULL, 'L', 0, 5, 10279),
(58390, '3.5T', NULL, 5006, 0, NULL, 'L', 0, 5, 9797),
(58389, '3.5T EcoBoost AWD ', NULL, 5005, 0, NULL, 'L', 0, 5, 109501),
(58388, '3.5L 越野车', NULL, 5004, 0, NULL, 'L', 0, 5, 13187),
(58387, '3.5T Ecoboost', NULL, 5003, 0, NULL, 'L', 0, 5, 103398),
(58386, '3.5T 自动 加长版', NULL, 5002, 0, NULL, 'L', 0, 5, 103320),
(58385, '3.5T 自动', NULL, 5002, 0, NULL, 'L', 0, 5, 102512),
(58384, '3.5L 越野车', NULL, 5002, 0, NULL, 'L', 0, 5, 102422),
(58383, '3.5L V6', NULL, 5001, 0, NULL, 'L', 0, 5, 13189),
(58382, 'LS', NULL, 5000, 0, NULL, 'L', 0, 5, 3723),
(58381, '黑森林', NULL, 4999, 0, NULL, 'L', 0, 5, 3724),
(58380, '城市 Signature', NULL, 4998, 0, NULL, 'L', 0, 5, 9043),
(58379, 'Aviator', NULL, 4997, 0, NULL, 'L', 0, 5, 3279),
(58378, '城市town car', NULL, 4996, 0, NULL, 'L', 0, 5, 3722),
(58377, '城市 120英寸加长豪华礼宾车', NULL, 4995, 0, NULL, 'L', 0, 5, 11179),
(58376, '城市 70英寸加长车', NULL, 4995, 0, NULL, 'L', 0, 5, 11178),
(58375, '430', NULL, 4994, 0, NULL, 'L', 0, 5, 4390),
(58374, '330', NULL, 4993, 0, NULL, 'L', 0, 5, 6496),
(58373, '300', NULL, 4993, 0, NULL, 'L', 0, 5, 6495),
(58372, 'RX300', NULL, 4992, 0, NULL, 'L', 0, 5, 109513),
(58371, '350', NULL, 4991, 0, NULL, 'L', 0, 5, 3668),
(58370, '400h', NULL, 4990, 0, NULL, 'L', 0, 5, 3669),
(58369, '450h', NULL, 4989, 0, NULL, 'L', 0, 5, 8140),
(58368, '350 尊贵版', NULL, 4989, 0, NULL, 'L', 0, 5, 8139),
(58367, '350 豪华版', NULL, 4989, 0, NULL, 'L', 0, 5, 8138),
(58366, '350 典雅版', NULL, 4988, 0, NULL, 'L', 0, 5, 9885),
(58365, '270 精英版', NULL, 4987, 0, NULL, 'L', 0, 5, 13102),
(58364, '270 豪华版', NULL, 4987, 0, NULL, 'L', 0, 5, 11840),
(58363, '270 典雅版', NULL, 4987, 0, NULL, 'L', 0, 5, 11839),
(58362, '270 典雅版', NULL, 4986, 0, NULL, 'L', 0, 5, 16571),
(58361, '270 豪华版', NULL, 4986, 0, NULL, 'L', 0, 5, 16570),
(58360, '350 典雅版', NULL, 4986, 0, NULL, 'L', 0, 5, 16568),
(58359, '350 豪华版', NULL, 4986, 0, NULL, 'L', 0, 5, 16567),
(58358, '350 F SPORT', NULL, 4986, 0, NULL, 'L', 0, 5, 16565),
(58357, '350 尊贵版', NULL, 4986, 0, NULL, 'L', 0, 5, 16563),
(58356, '450h ', NULL, 4986, 0, NULL, 'L', 0, 5, 16562),
(58355, '350 尊贵版', NULL, 4985, 0, NULL, 'L', 0, 5, 106528),
(58354, '350 F SPORT', NULL, 4985, 0, NULL, 'L', 0, 5, 106527),
(58353, '350 豪华版', NULL, 4985, 0, NULL, 'L', 0, 5, 106526),
(58352, '350 典雅版', NULL, 4985, 0, NULL, 'L', 0, 5, 106525),
(58351, '450h 尊享版', NULL, 4985, 0, NULL, 'L', 0, 5, 106524),
(58350, '450h 尊贵版', NULL, 4985, 0, NULL, 'L', 0, 5, 106523),
(58349, '270 豪华版', NULL, 4985, 0, NULL, 'L', 0, 5, 106454),
(58348, '270  精英版', NULL, 4985, 0, NULL, 'L', 0, 5, 104735),
(58347, '270 典雅版', NULL, 4985, 0, NULL, 'L', 0, 5, 104732),
(58346, '270 Mark Levinson限量版', NULL, 4985, 0, NULL, 'L', 0, 5, 104327),
(58345, '270 暗夜爵士特别限量版', NULL, 4984, 0, NULL, 'L', 0, 5, 110796),
(58344, '470', NULL, 4983, 0, NULL, 'L', 0, 5, 6494),
(58343, '570', NULL, 4982, 0, NULL, 'L', 0, 5, 3660),
(58342, '570', NULL, 4981, 0, NULL, 'L', 0, 5, 4784),
(58341, '570', NULL, 4980, 0, NULL, 'L', 0, 5, 15850),
(58340, '570', NULL, 4979, 0, NULL, 'L', 0, 5, 103515),
(58339, '400', NULL, 4978, 0, NULL, 'L', 0, 5, 6493),
(58338, 'LS400', NULL, 4977, 0, NULL, 'L', 0, 5, 109512),
(58337, '430', NULL, 4976, 0, NULL, 'L', 0, 5, 3658),
(58336, '460L尊贵加长版', NULL, 4975, 0, NULL, 'L', 0, 5, 3672),
(58335, '460L 加长版', NULL, 4975, 0, NULL, 'L', 0, 5, 3671),
(58334, '460', NULL, 4975, 0, NULL, 'L', 0, 5, 3670),
(58333, '600hl', NULL, 4974, 0, NULL, 'L', 0, 5, 3673),
(58332, '460L', NULL, 4973, 0, NULL, 'L', 0, 5, 8845),
(58331, '460L 尊贵加长版', NULL, 4973, 0, NULL, 'L', 0, 5, 8844),
(58330, '460L 加长版', NULL, 4973, 0, NULL, 'L', 0, 5, 8843),
(58329, '600hL', NULL, 4972, 0, NULL, 'L', 0, 5, 9832),
(58328, '460L 尊贵加长版', NULL, 4972, 0, NULL, 'L', 0, 5, 9613),
(58327, '460L 豪华加长版', NULL, 4972, 0, NULL, 'L', 0, 5, 9612),
(58326, '460L 加长版', NULL, 4972, 0, NULL, 'L', 0, 5, 9611),
(58325, '600hL', NULL, 4971, 0, NULL, 'L', 0, 5, 102755),
(58324, '460L 尊贵加长全驱版', NULL, 4971, 0, NULL, 'L', 0, 5, 102240),
(58323, '460L 豪华加长版', NULL, 4971, 0, NULL, 'L', 0, 5, 102239),
(58322, '460L 加长版', NULL, 4971, 0, NULL, 'L', 0, 5, 102233),
(58321, '600hL', NULL, 4970, 0, NULL, 'L', 0, 5, 105454),
(58320, '460L 豪华加长全驱版', NULL, 4970, 0, NULL, 'L', 0, 5, 105453),
(58319, '460L 豪华加长版', NULL, 4970, 0, NULL, 'L', 0, 5, 105450),
(58318, '460L 加长版', NULL, 4970, 0, NULL, 'L', 0, 5, 105449),
(58317, '4.8L', NULL, 4969, 0, NULL, 'L', 0, 5, 10461),
(58316, '200', NULL, 4968, 0, NULL, 'L', 0, 5, 3655),
(58315, '300', NULL, 4967, 0, NULL, 'L', 0, 5, 10457),
(58314, '300 炫动版', NULL, 4967, 0, NULL, 'L', 0, 5, 3678),
(58313, '300 炫动特别版', NULL, 4966, 0, NULL, 'L', 0, 5, 3677),
(58312, '300 豪华版', NULL, 4965, 0, NULL, 'L', 0, 5, 4392),
(58311, '300 豪华版', NULL, 4964, 0, NULL, 'L', 0, 5, 11154),
(58310, '300 炫动版', NULL, 4964, 0, NULL, 'L', 0, 5, 11153),
(58309, '300', NULL, 4964, 0, NULL, 'L', 0, 5, 11152),
(58308, '300C', NULL, 4964, 0, NULL, 'L', 0, 5, 8632),
(58307, '250 F-SPORT特别限量版', NULL, 4963, 0, NULL, 'L', 0, 5, 103246),
(58306, '250 精英版', NULL, 4963, 0, NULL, 'L', 0, 5, 14438),
(58305, '250 风驰版', NULL, 4963, 0, NULL, 'L', 0, 5, 12935),
(58304, '250 豪华版', NULL, 4963, 0, NULL, 'L', 0, 5, 11838),
(58303, '250 炫动版', NULL, 4963, 0, NULL, 'L', 0, 5, 11837),
(58302, '250 运动版', NULL, 4963, 0, NULL, 'L', 0, 5, 11836),
(58301, '250C', NULL, 4963, 0, NULL, 'L', 0, 5, 11835),
(58300, '250 尊贵版', NULL, 4962, 0, NULL, 'L', 0, 5, 103818),
(58299, '250 豪华版', NULL, 4962, 0, NULL, 'L', 0, 5, 103816),
(58298, '250 F SPORT', NULL, 4962, 0, NULL, 'L', 0, 5, 103815),
(58297, '250 锋尚版', NULL, 4962, 0, NULL, 'L', 0, 5, 103812),
(58296, '250 领先版', NULL, 4962, 0, NULL, 'L', 0, 5, 103808),
(58295, '470', NULL, 4961, 0, NULL, 'L', 0, 5, 6751),
(58294, '460高配', NULL, 4960, 0, NULL, 'L', 0, 5, 10855),
(58293, '460', NULL, 4960, 0, NULL, 'L', 0, 5, 9761),
(58292, '400 4.0L 手自一体', NULL, 4959, 0, NULL, 'L', 0, 5, 100632),
(58291, '400尊享版', NULL, 4958, 0, NULL, 'L', 0, 5, 106596),
(58290, '400', NULL, 4958, 0, NULL, 'L', 0, 5, 105456),
(58289, '300', NULL, 4957, 0, NULL, 'L', 0, 5, 6492),
(58288, '300 豪华版', NULL, 4957, 0, NULL, 'L', 0, 5, 6491),
(58287, '430', NULL, 4957, 0, NULL, 'L', 0, 5, 4394),
(58286, '460', NULL, 4956, 0, NULL, 'L', 0, 5, 7303),
(58285, '300', NULL, 4956, 0, NULL, 'L', 0, 5, 4393),
(58284, '450h', NULL, 4955, 0, NULL, 'L', 0, 5, 7507),
(58283, '450h', NULL, 4954, 0, NULL, 'L', 0, 5, 9610),
(58282, '460', NULL, 4954, 0, NULL, 'L', 0, 5, 9609),
(58281, '300', NULL, 4954, 0, NULL, 'L', 0, 5, 9608),
(58280, '300 辉煌版', NULL, 4953, 0, NULL, 'L', 0, 5, 12934),
(58279, '450h', NULL, 4952, 0, NULL, 'L', 0, 5, 101245),
(58278, '250 F SPORT', NULL, 4952, 0, NULL, 'L', 0, 5, 16575),
(58277, '250 豪华版', NULL, 4952, 0, NULL, 'L', 0, 5, 16574),
(58276, '350 豪华全驱版', NULL, 4952, 0, NULL, 'L', 0, 5, 16573),
(58275, '350 F SPORT', NULL, 4952, 0, NULL, 'L', 0, 5, 16436),
(58274, '250 领先版', NULL, 4952, 0, NULL, 'L', 0, 5, 16435),
(58273, '300h 豪华版', NULL, 4951, 0, NULL, 'L', 0, 5, 106575),
(58272, '300h 领先版', NULL, 4951, 0, NULL, 'L', 0, 5, 106573),
(58271, '450h', NULL, 4951, 0, NULL, 'L', 0, 5, 105461),
(58270, '350 豪华全驱版', NULL, 4951, 0, NULL, 'L', 0, 5, 105460),
(58269, '350 F SPORT', NULL, 4951, 0, NULL, 'L', 0, 5, 105459),
(58268, '250 豪华版', NULL, 4951, 0, NULL, 'L', 0, 5, 105458),
(58267, '250 F SPORT', NULL, 4951, 0, NULL, 'L', 0, 5, 105457),
(58266, '250 领先版', NULL, 4951, 0, NULL, 'L', 0, 5, 105455),
(58265, '300', NULL, 4950, 0, NULL, 'L', 0, 5, 6490),
(58264, '330', NULL, 4949, 0, NULL, 'L', 0, 5, 3674),
(58263, '350 豪华版', NULL, 4948, 0, NULL, 'L', 0, 5, 3676),
(58262, '350', NULL, 4948, 0, NULL, 'L', 0, 5, 3675),
(58261, '350 尊贵版', NULL, 4947, 0, NULL, 'L', 0, 5, 9346),
(58260, '350 豪华版', NULL, 4947, 0, NULL, 'L', 0, 5, 9345),
(58259, '240 豪华版', NULL, 4947, 0, NULL, 'L', 0, 5, 9344),
(58258, '240 典雅版', NULL, 4947, 0, NULL, 'L', 0, 5, 3656),
(58257, 'ES350 尊贵版', NULL, 4946, 0, NULL, 'L', 0, 5, 109511),
(58256, 'ES350 豪华版', NULL, 4946, 0, NULL, 'L', 0, 5, 109510),
(58255, 'ES240 豪华版', NULL, 4946, 0, NULL, 'L', 0, 5, 109509),
(58254, 'ES240 典雅版', NULL, 4946, 0, NULL, 'L', 0, 5, 109508),
(58253, '350 典雅版', NULL, 4946, 0, NULL, 'L', 0, 5, 10945),
(58252, '240 特别限量版', NULL, 4945, 0, NULL, 'L', 0, 5, 100191),
(58251, '250 Mark Levinson 限量版', NULL, 4944, 0, NULL, 'L', 0, 5, 104323),
(58250, '300h 精英版', NULL, 4944, 0, NULL, 'L', 0, 5, 101529),
(58249, '350 尊贵型', NULL, 4944, 0, NULL, 'L', 0, 5, 101528),
(58248, '350 典雅型', NULL, 4944, 0, NULL, 'L', 0, 5, 101526),
(58247, '250 精英版', NULL, 4944, 0, NULL, 'L', 0, 5, 101525),
(58246, '250 典雅型', NULL, 4944, 0, NULL, 'L', 0, 5, 101523),
(58245, '300h 豪华版', NULL, 4944, 0, NULL, 'L', 0, 5, 100718),
(58244, '250 豪华版', NULL, 4944, 0, NULL, 'L', 0, 5, 100717),
(58243, '200h 1.8L 自动 豪华版', NULL, 4943, 0, NULL, 'L', 0, 5, 15161),
(58242, '200h 1.8L 自动 F SPORT', NULL, 4943, 0, NULL, 'L', 0, 5, 15160),
(58241, '200h 1.8L 自动 领先版', NULL, 4943, 0, NULL, 'L', 0, 5, 15159),
(58240, '200h 1.8L 自动 精英版', NULL, 4943, 0, NULL, 'L', 0, 5, 15157),
(58239, '200h 1.8L 自动 台湾版', NULL, 4943, 0, NULL, 'L', 0, 5, 14901),
(58238, 'CT200h 1.8L 自动 豪华版', NULL, 4942, 0, NULL, 'L', 0, 5, 109507),
(58237, 'CT200h 1.8L 自动 F SPORT', NULL, 4942, 0, NULL, 'L', 0, 5, 109506),
(58236, 'CT200h 1.8L 自动 领先版', NULL, 4942, 0, NULL, 'L', 0, 5, 109505),
(58235, 'CT200h 1.8L 自动 精英版', NULL, 4942, 0, NULL, 'L', 0, 5, 109504),
(58234, '200h 1.8L 自动 舒适版', NULL, 4941, 0, NULL, 'L', 0, 5, 104730),
(58233, '200h 1.8L 自动 都市版', NULL, 4941, 0, NULL, 'L', 0, 5, 104729),
(58232, '200h 1.8L 自动 暗夜骑士版', NULL, 4941, 0, NULL, 'L', 0, 5, 103364),
(58231, '200h 1.8L 自动 花语花忆版', NULL, 4941, 0, NULL, 'L', 0, 5, 103363),
(58230, '200h 1.8L 自动 豪华版', NULL, 4941, 0, NULL, 'L', 0, 5, 102900),
(58229, '200h 1.8L 自动 F SPORT', NULL, 4941, 0, NULL, 'L', 0, 5, 102899),
(58228, '200h 1.8L 自动 领先版', NULL, 4941, 0, NULL, 'L', 0, 5, 102898),
(58227, '200h 1.8L 自动 精英版', NULL, 4941, 0, NULL, 'L', 0, 5, 102897),
(58226, '200h 1.8L 自动 领先版（双色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106650),
(58225, '200h 1.8L 自动 领先版（单色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106649),
(58224, '200h 1.8L 自动 F SPORT版（双色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106648),
(58223, '200h 1.8L 自动 F SPORT版（单色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106647),
(58222, '200h 1.8L 自动 舒适版（双色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106644),
(58221, '200h 1.8L 自动 舒适版（单色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106642),
(58220, '200h 1.8L 自动 精英版（双色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106641),
(58219, '200h 1.8L 自动 精英版（单色）', NULL, 4940, 0, NULL, 'L', 0, 5, 106638),
(58218, '5.0 MT', NULL, 4939, 0, NULL, 'L', 0, 5, 3479),
(58217, 'SPYDER', NULL, 4938, 0, NULL, 'L', 0, 5, 3480),
(58216, 'LP560—4', NULL, 4937, 0, NULL, 'L', 0, 5, 8809),
(58215, 'LP560—4 Spyder', NULL, 4936, 0, NULL, 'L', 0, 5, 8810),
(58214, 'LP550-2 标准版', NULL, 4935, 0, NULL, 'L', 0, 5, 105012),
(58213, 'LP550—2', NULL, 4935, 0, NULL, 'L', 0, 5, 12634),
(58212, 'LP550—2 Valentino Balboni', NULL, 4935, 0, NULL, 'L', 0, 5, 9670),
(58211, 'LP560-4 NOCTIS限量版', NULL, 4934, 0, NULL, 'L', 0, 5, 101127),
(58210, 'LP570-4 Spyder Performante', NULL, 4934, 0, NULL, 'L', 0, 5, 101126),
(58209, 'LP560—4 Bicolore', NULL, 4934, 0, NULL, 'L', 0, 5, 101122),
(58208, 'LP550—2 Tricolore', NULL, 4934, 0, NULL, 'L', 0, 5, 101120),
(58207, 'LP570-4 Superleggera', NULL, 4934, 0, NULL, 'L', 0, 5, 12635),
(58206, 'LP570-4 Super Trofeo Stradale', NULL, 4933, 0, NULL, 'L', 0, 5, 101125),
(58205, 'LP560—4', NULL, 4932, 0, NULL, 'L', 0, 5, 104266),
(58204, '6.2 手动', NULL, 4931, 0, NULL, 'L', 0, 5, 109758),
(58203, 'E—Grar 6.5 AT', NULL, 4931, 0, NULL, 'L', 0, 5, 109604),
(58202, 'E—Grar 6.5 AT', NULL, 4930, 0, NULL, 'L', 0, 5, 9798),
(58201, '6.5 MT', NULL, 4930, 0, NULL, 'L', 0, 5, 3478),
(58200, 'LP 640', NULL, 4929, 0, NULL, 'L', 0, 5, 9799),
(58199, 'LP 670—4 SuperVeloce', NULL, 4928, 0, NULL, 'L', 0, 5, 10364),
(58198, 'LP610-4', NULL, 4927, 0, NULL, 'L', 0, 5, 106484),
(58197, 'LP700-4', NULL, 4926, 0, NULL, 'L', 0, 5, 15264),
(58196, 'LP 700-4 Roadster', NULL, 4925, 0, NULL, 'L', 0, 5, 103152),
(58195, 'Exige S260标准版', NULL, 4924, 0, NULL, 'L', 0, 5, 15233),
(58194, 'Exige S240标准版', NULL, 4924, 0, NULL, 'L', 0, 5, 15232),
(58193, '3.5 V6 2+2运动版', NULL, 4923, 0, NULL, 'L', 0, 5, 105307),
(58192, '3.5 V6 2+2IPS版', NULL, 4923, 0, NULL, 'L', 0, 5, 15231),
(58191, '3.5 V6 2+2标准版', NULL, 4923, 0, NULL, 'L', 0, 5, 15230),
(58190, '3.5 V6 2+0标准版', NULL, 4923, 0, NULL, 'L', 0, 5, 15229),
(58189, '3.5 V6 GTE', NULL, 4923, 0, NULL, 'L', 0, 5, 15228),
(58188, 'Evora3.5 V6 GTE', NULL, 4922, 0, NULL, 'L', 0, 5, 109795),
(58187, 'Evora3.5 V6 IPS', NULL, 4922, 0, NULL, 'L', 0, 5, 109794),
(58186, 'Evora3.5 V6四座运动版', NULL, 4922, 0, NULL, 'L', 0, 5, 109793),
(58185, 'Evora3.5 V6四座标准版', NULL, 4922, 0, NULL, 'L', 0, 5, 109792),
(58184, 'Evora3.5 V6双座标准版', NULL, 4922, 0, NULL, 'L', 0, 5, 109791),
(58183, 'Elise SC运动版', NULL, 4922, 0, NULL, 'L', 0, 5, 109790),
(58182, '1.8T  SC 标准版', NULL, 4922, 0, NULL, 'L', 0, 5, 15227),
(58181, '1.8T SC 运动版', NULL, 4922, 0, NULL, 'L', 0, 5, 14256),
(58180, '1.8L R 标准版', NULL, 4922, 0, NULL, 'L', 0, 5, 3434),
(58179, '精灵Esprit 3.5 手动', NULL, 4921, 0, NULL, 'L', 0, 5, 9044),
(58178, '6.6T V12', NULL, 4920, 0, NULL, 'L', 0, 5, 104452),
(58177, '银色天使 6.7', NULL, 4919, 0, NULL, 'L', 0, 5, 15632),
(58176, '5.4 银色天使', NULL, 4918, 0, NULL, 'L', 0, 5, 109520),
(58175, '银色天使', NULL, 4917, 0, NULL, 'L', 0, 5, 3362),
(58174, '银灵 6.7AT', NULL, 4916, 0, NULL, 'L', 0, 5, 109519),
(58173, '银灵 6.7AT', NULL, 4915, 0, NULL, 'L', 0, 5, 15633),
(58172, '银灵 6.7AT', NULL, 4914, 0, NULL, 'L', 0, 5, 109634),
(58171, '银灵 6.7AT', NULL, 4913, 0, NULL, 'L', 0, 5, 109635),
(58170, '标准版', NULL, 4912, 0, NULL, 'L', 0, 5, 3363),
(58169, '加长版(EWB)', NULL, 4911, 0, NULL, 'L', 0, 5, 9230),
(58168, '6.7 元首级', NULL, 4910, 0, NULL, 'L', 0, 5, 109633),
(58167, '双门轿跑车(101EX)', NULL, 4910, 0, NULL, 'L', 0, 5, 9232),
(58166, '软顶敞篷车', NULL, 4910, 0, NULL, 'L', 0, 5, 9231),
(58165, '幻影双门轿跑', NULL, 4909, 0, NULL, 'L', 0, 5, 102124),
(58164, '幻影软顶敞篷', NULL, 4909, 0, NULL, 'L', 0, 5, 102123),
(58163, '幻影加长版', NULL, 4909, 0, NULL, 'L', 0, 5, 102122),
(58162, '幻影', NULL, 4909, 0, NULL, 'L', 0, 5, 102121),
(58161, '古斯特加长版', NULL, 4908, 0, NULL, 'L', 0, 5, 13588),
(58160, '200EX', NULL, 4908, 0, NULL, 'L', 0, 5, 9570),
(58159, '古思特加长装饰派艺术典藏版', NULL, 4907, 0, NULL, 'L', 0, 5, 102979),
(58158, '古思特加长版', NULL, 4907, 0, NULL, 'L', 0, 5, 102120),
(58157, '古思特', NULL, 4907, 0, NULL, 'L', 0, 5, 102119),
(58156, '6.6T 英骥典藏版', NULL, 4906, 0, NULL, 'L', 0, 5, 110533),
(58155, '6.6T 阿尔卑斯挑战之旅世纪典藏版', NULL, 4906, 0, NULL, 'L', 0, 5, 106406),
(58154, '6.6T 加长版', NULL, 4906, 0, NULL, 'L', 0, 5, 106405),
(58153, '6.6T 标准版', NULL, 4906, 0, NULL, 'L', 0, 5, 106404),
(58152, '1.3L 手动 基本型', NULL, 4905, 0, NULL, 'L', 0, 5, 101265),
(58151, '1.3L 手动 标准型', NULL, 4905, 0, NULL, 'L', 0, 5, 101264),
(58150, '1.3L 手动 舒适型', NULL, 4905, 0, NULL, 'L', 0, 5, 101263),
(58149, '1.3L 手动 豪华型', NULL, 4905, 0, NULL, 'L', 0, 5, 101262),
(58148, '1.3L 手动 LF6420', NULL, 4904, 0, NULL, 'L', 0, 5, 16056),
(58147, '1.8L 手动 基本型', NULL, 4903, 0, NULL, 'L', 0, 5, 16622),
(58146, '1.8L 手动 豪华型', NULL, 4903, 0, NULL, 'L', 0, 5, 14876),
(58145, '1.8L 手动 舒适型', NULL, 4903, 0, NULL, 'L', 0, 5, 12956),
(58144, '1.8L 手动 发现版 豪华型', NULL, 4902, 0, NULL, 'L', 0, 5, 102089),
(58143, '1.8L 手动 发现版 舒适型', NULL, 4902, 0, NULL, 'L', 0, 5, 102088),
(58142, '1.8L 手动 冠军版', NULL, 4901, 0, NULL, 'L', 0, 5, 105899),
(58141, '1.8L 手动 基本 DX', NULL, 4900, 0, NULL, 'L', 0, 5, 100620),
(58140, '1.8L 手动 标准 LX', NULL, 4900, 0, NULL, 'L', 0, 5, 100619),
(58139, '1.8L 手动 舒雅标准型', NULL, 4899, 0, NULL, 'L', 0, 5, 105279),
(58138, '1.8L 手动 舒雅豪华型', NULL, 4899, 0, NULL, 'L', 0, 5, 105276),
(58137, '1.8L 手动 标准型', NULL, 4899, 0, NULL, 'L', 0, 5, 103389),
(58136, '1.8L 手动 豪华型', NULL, 4899, 0, NULL, 'L', 0, 5, 102731),
(58135, '1.5L 手动 越级版豪华型', NULL, 4898, 0, NULL, 'L', 0, 5, 106332),
(58134, '1.5L 手动 越级版标准型', NULL, 4898, 0, NULL, 'L', 0, 5, 106331),
(58133, '1.5L VVT 手动 旗舰型', NULL, 4897, 0, NULL, 'L', 0, 5, 105396),
(58132, '1.5L VVT 手动 标准型', NULL, 4897, 0, NULL, 'L', 0, 5, 105395),
(58131, '1.5L VVT 手动 舒适型B', NULL, 4897, 0, NULL, 'L', 0, 5, 105394),
(58130, '1.5L VVT 手动 舒适型A', NULL, 4897, 0, NULL, 'L', 0, 5, 105393),
(58129, '1.5L 手动 旗舰型', NULL, 4897, 0, NULL, 'L', 0, 5, 105392),
(58128, '1.5L 手动 标准型', NULL, 4897, 0, NULL, 'L', 0, 5, 105391),
(58127, '1.5L 手动 舒适型B', NULL, 4897, 0, NULL, 'L', 0, 5, 105388),
(58126, '1.5L 手动 舒适型A', NULL, 4897, 0, NULL, 'L', 0, 5, 105387),
(58125, 'CNG 精典版', NULL, 4896, 0, NULL, 'L', 0, 5, 11845),
(58124, 'CNG 精英版', NULL, 4896, 0, NULL, 'L', 0, 5, 11844),
(58123, 'CNG 精锐版', NULL, 4896, 0, NULL, 'L', 0, 5, 11843),
(58122, 'CNG 精钻版', NULL, 4896, 0, NULL, 'L', 0, 5, 11841),
(58121, '精锐版 舒适型', NULL, 4896, 0, NULL, 'L', 0, 5, 7422),
(58120, '精典版 舒适型', NULL, 4896, 0, NULL, 'L', 0, 5, 6885),
(58119, '精钻版 经济型', NULL, 4896, 0, NULL, 'L', 0, 5, 6884),
(58118, '1.6L MT 精钻版(EX)', NULL, 4895, 0, NULL, 'L', 0, 5, 12914),
(58117, '1.5L 精钻型 铂尊版', NULL, 4895, 0, NULL, 'L', 0, 5, 11823),
(58116, '1.5L 精锐型 铂尊版', NULL, 4895, 0, NULL, 'L', 0, 5, 11822),
(58115, '1.5L 精英型 铂尊版', NULL, 4895, 0, NULL, 'L', 0, 5, 11821),
(58114, '1.5L 精典型 铂尊版', NULL, 4895, 0, NULL, 'L', 0, 5, 11820),
(58113, '1.6L CVT 精锐版(LX)', NULL, 4895, 0, NULL, 'L', 0, 5, 10777),
(58112, '1.6L CVT 精钻版(EX)', NULL, 4895, 0, NULL, 'L', 0, 5, 10776),
(58111, '1.5L 贺岁版', NULL, 4895, 0, NULL, 'L', 0, 5, 9762),
(58110, '1.6L CVT 精英版', NULL, 4895, 0, NULL, 'L', 0, 5, 6886),
(58109, '1.5L 精锐型 雪地版', NULL, 4894, 0, NULL, 'L', 0, 5, 12333),
(58108, '1.5L 精英型 雪地版', NULL, 4894, 0, NULL, 'L', 0, 5, 12332),
(58107, '1.5L 手动 旗舰型 CNG', NULL, 4893, 0, NULL, 'L', 0, 5, 102576),
(58106, '1.5L 手动 豪华型 CNG', NULL, 4893, 0, NULL, 'L', 0, 5, 102575),
(58105, '1.5L 手动 舒适型B CNG', NULL, 4893, 0, NULL, 'L', 0, 5, 102574),
(58104, '1.5L 手动 舒适型A CNG', NULL, 4893, 0, NULL, 'L', 0, 5, 102573),
(58103, '1.6L CVT 旗舰型', NULL, 4893, 0, NULL, 'L', 0, 5, 102090),
(58102, '1.5L 手动 基本型', NULL, 4893, 0, NULL, 'L', 0, 5, 16621),
(58101, '1.5L 手动 舒适型A', NULL, 4893, 0, NULL, 'L', 0, 5, 16620),
(58100, '1.5L 手动 舒适型B', NULL, 4893, 0, NULL, 'L', 0, 5, 16619),
(58099, '1.5L 手动 舒适型C', NULL, 4893, 0, NULL, 'L', 0, 5, 16618),
(58098, '1.5L 手动 豪华型', NULL, 4893, 0, NULL, 'L', 0, 5, 16617),
(58097, '1.5L 手动 旗舰型', NULL, 4893, 0, NULL, 'L', 0, 5, 16614),
(58096, '1.5L 自动 旗舰型', NULL, 4892, 0, NULL, 'L', 0, 5, 105448),
(58095, '1.5L 自动 豪华型', NULL, 4892, 0, NULL, 'L', 0, 5, 105447),
(58094, '1.5L 自动 标准型', NULL, 4892, 0, NULL, 'L', 0, 5, 105445),
(58093, '1.5L 手动 旗舰型', NULL, 4892, 0, NULL, 'L', 0, 5, 105442),
(58092, '1.5L 手动 豪华型', NULL, 4892, 0, NULL, 'L', 0, 5, 105441),
(58091, '1.5L 手动 标准型', NULL, 4892, 0, NULL, 'L', 0, 5, 105440),
(58090, '1.3L 手动 旗舰型', NULL, 4892, 0, NULL, 'L', 0, 5, 105439),
(58089, '1.3L 手动 豪华型', NULL, 4892, 0, NULL, 'L', 0, 5, 105438),
(58088, '1.3L 手动 标准型', NULL, 4892, 0, NULL, 'L', 0, 5, 105389),
(58087, 'LF 7161A 顶配型 VIP', NULL, 4891, 0, NULL, 'L', 0, 5, 5628),
(58086, 'LF 7161A 豪华型', NULL, 4891, 0, NULL, 'L', 0, 5, 5627),
(58085, 'LF 7161A 舒适型', NULL, 4891, 0, NULL, 'L', 0, 5, 5626),
(58084, 'LF 7161 顶配型 VIP', NULL, 4891, 0, NULL, 'L', 0, 5, 5625),
(58083, 'LF 7161 豪华型', NULL, 4891, 0, NULL, 'L', 0, 5, 5624),
(58082, 'LF 7161A 经济型', NULL, 4891, 0, NULL, 'L', 0, 5, 5623),
(58081, 'LF 7161 经济型', NULL, 4891, 0, NULL, 'L', 0, 5, 5622),
(58080, 'LF7131A 豪华配置', NULL, 4891, 0, NULL, 'L', 0, 5, 5621),
(58079, '标准型LX1', NULL, 4891, 0, NULL, 'L', 0, 5, 5620),
(58078, 'LF 7161 舒适型', NULL, 4891, 0, NULL, 'L', 0, 5, 5219),
(58077, '舒适型LX', NULL, 4891, 0, NULL, 'L', 0, 5, 5217),
(58076, '实用型DX', NULL, 4890, 0, NULL, 'L', 0, 5, 11096),
(58075, '1.3L 手动 基本型', NULL, 4889, 0, NULL, 'L', 0, 5, 12508),
(58074, '1.3L 手动 标准型', NULL, 4889, 0, NULL, 'L', 0, 5, 12506),
(58073, 'Cross 实用型DX', NULL, 4889, 0, NULL, 'L', 0, 5, 11099),
(58072, 'Cross 标准型LX1', NULL, 4889, 0, NULL, 'L', 0, 5, 11098),
(58071, 'Cross 舒适型LX', NULL, 4889, 0, NULL, 'L', 0, 5, 11097),
(58070, '悦行版 1.3L 手动 实用型', NULL, 4888, 0, NULL, 'L', 0, 5, 103433),
(58069, '悦行版 1.3L 手动 舒适型', NULL, 4888, 0, NULL, 'L', 0, 5, 103432),
(58068, '1.3L 手动 舒适型', NULL, 4888, 0, NULL, 'L', 0, 5, 103431),
(58067, '1.3L 手动 实用型', NULL, 4888, 0, NULL, 'L', 0, 5, 103423),
(58066, 'LF7160L 顶级配置 VIP', NULL, 4887, 0, NULL, 'L', 0, 5, 5778),
(58065, 'LF7160L 豪华配置 EX', NULL, 4887, 0, NULL, 'L', 0, 5, 5777),
(58064, 'LF7160L 舒适配置 LX', NULL, 4887, 0, NULL, 'L', 0, 5, 5776),
(58063, 'LF7160L 经济配置 DX', NULL, 4887, 0, NULL, 'L', 0, 5, 5775),
(58062, 'LF7160 顶级配置 VIP', NULL, 4887, 0, NULL, 'L', 0, 5, 5745),
(58061, 'LF7160 豪华配置 EX', NULL, 4887, 0, NULL, 'L', 0, 5, 5744),
(58060, 'LF7160 舒适配置 LX', NULL, 4887, 0, NULL, 'L', 0, 5, 5743),
(58059, 'LF7160 经济配置 DX', NULL, 4887, 0, NULL, 'L', 0, 5, 5741),
(58058, '7130EX 豪华型', NULL, 4887, 0, NULL, 'L', 0, 5, 3141),
(58057, '7130DX 精英型', NULL, 4887, 0, NULL, 'L', 0, 5, 3140),
(58056, '7130LX 舒适型', NULL, 4887, 0, NULL, 'L', 0, 5, 3139),
(58055, '7160EX 豪华型', NULL, 4887, 0, NULL, 'L', 0, 5, 3138),
(58054, '7160LX 舒适型', NULL, 4887, 0, NULL, 'L', 0, 5, 3137),
(58053, '7160DX 精英型', NULL, 4887, 0, NULL, 'L', 0, 5, 3136),
(58052, 'LF7130A 豪华配置 EX', NULL, 4886, 0, NULL, 'L', 0, 5, 5748),
(58051, 'LF7130A 舒适配置 LX', NULL, 4886, 0, NULL, 'L', 0, 5, 5747),
(58050, 'LF7130A 经济配置 DX', NULL, 4886, 0, NULL, 'L', 0, 5, 5746),
(58049, 'LF7160A 顶配', NULL, 4886, 0, NULL, 'L', 0, 5, 5222),
(58048, 'LF7160A 舒适型', NULL, 4886, 0, NULL, 'L', 0, 5, 5221),
(58047, 'LF7161 顶配', NULL, 4886, 0, NULL, 'L', 0, 5, 5220),
(58046, 'LF7130A 豪华型', NULL, 4886, 0, NULL, 'L', 0, 5, 5218),
(58045, 'LF7132X', NULL, 4886, 0, NULL, 'L', 0, 5, 5123),
(58044, 'LF7160L 顶级配置VIP', NULL, 4886, 0, NULL, 'L', 0, 5, 4937),
(58043, 'LF7160L 舒适配置LX', NULL, 4886, 0, NULL, 'L', 0, 5, 4936),
(58042, '1.3 经济型', NULL, 4886, 0, NULL, 'L', 0, 5, 3148),
(58041, '1.3 舒适型', NULL, 4886, 0, NULL, 'L', 0, 5, 3147),
(58040, '1.3 豪华型', NULL, 4886, 0, NULL, 'L', 0, 5, 3146),
(58039, '7160DX 经济新内饰', NULL, 4886, 0, NULL, 'L', 0, 5, 3145),
(58038, '7160LX 舒适新内饰', NULL, 4886, 0, NULL, 'L', 0, 5, 3144),
(58037, '7160EX 豪华新内饰', NULL, 4886, 0, NULL, 'L', 0, 5, 3143),
(58036, '7160VIP 顶级新内饰', NULL, 4886, 0, NULL, 'L', 0, 5, 3142),
(58035, '1.3L CNG 实用型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 12509),
(58034, '1.3L CNG 舒适型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 12507),
(58033, '1.6L 豪华型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 11525),
(58032, '1.3L 舒适型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 11524),
(58031, '1.3L 实用型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 11523),
(58030, '1.3L 标准型 领航版', NULL, 4885, 0, NULL, 'L', 0, 5, 11521),
(58029, '1.5L 手动 领航版舒适型', NULL, 4884, 0, NULL, 'L', 0, 5, 15476),
(58028, '1.5L 手动 领航版豪华型', NULL, 4884, 0, NULL, 'L', 0, 5, 15475),
(58027, '1.3L VVT 手动 豪华型', NULL, 4883, 0, NULL, 'L', 0, 5, 105444),
(58026, '1.3L VVT 手动 舒适型', NULL, 4883, 0, NULL, 'L', 0, 5, 105443),
(58025, '1.3L VVT 手动 标准型', NULL, 4883, 0, NULL, 'L', 0, 5, 105402),
(58024, '灵逸版 LX', NULL, 4882, 0, NULL, 'L', 0, 5, 8331),
(58023, '灵动版 DX', NULL, 4882, 0, NULL, 'L', 0, 5, 8330),
(58022, '灵炫版 LX', NULL, 4882, 0, NULL, 'L', 0, 5, 8321),
(58021, '豪华型 LX1', NULL, 4881, 0, NULL, 'L', 0, 5, 10197),
(58020, '舒适型 LX2', NULL, 4881, 0, NULL, 'L', 0, 5, 10196),
(58019, '标准型 LX', NULL, 4881, 0, NULL, 'L', 0, 5, 10195),
(58018, 'CVT 尊贵型 EX', NULL, 4880, 0, NULL, 'L', 0, 5, 13205),
(58017, 'CVT 舒适型 LX', NULL, 4880, 0, NULL, 'L', 0, 5, 13204),
(58016, '雪地版 豪华型', NULL, 4880, 0, NULL, 'L', 0, 5, 12331),
(58015, '雪地版 舒适型', NULL, 4880, 0, NULL, 'L', 0, 5, 12330),
(58014, '雪地版 标准型', NULL, 4880, 0, NULL, 'L', 0, 5, 8332),
(58013, '1.3L 手动 酷行', NULL, 4879, 0, NULL, 'L', 0, 5, 102395),
(58012, '1.3L 手动 酷跃', NULL, 4879, 0, NULL, 'L', 0, 5, 102394),
(58011, '1.3L 手动 酷翔', NULL, 4879, 0, NULL, 'L', 0, 5, 102391),
(58010, '豪华配置(EX)', NULL, 4878, 0, NULL, 'L', 0, 5, 12585),
(58009, '舒适配置(LX)', NULL, 4878, 0, NULL, 'L', 0, 5, 12584),
(58008, '标准配置(DX)', NULL, 4878, 0, NULL, 'L', 0, 5, 12583),
(58007, 'CNG 1.3L 手动 LF6401CNG', NULL, 4877, 0, NULL, 'L', 0, 5, 16057),
(58006, '1.3L 舒适型', NULL, 4877, 0, NULL, 'L', 0, 5, 14722),
(58005, '1.3L 标准型', NULL, 4877, 0, NULL, 'L', 0, 5, 14721),
(58004, '1.0L 手动 舒适型', NULL, 4877, 0, NULL, 'L', 0, 5, 14717),
(58003, '1.0L 手动 标准型', NULL, 4877, 0, NULL, 'L', 0, 5, 14714),
(58002, '柴油 2.8T 2WD 欧I 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6764),
(58001, '柴油 2.8T 4WD 欧I 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6763),
(58000, '柴油 2.8L 2WD 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6762),
(57999, '柴油 2.8T 4WD 欧II 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6761),
(57998, '柴油 2.8T 2WD 欧II 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6760),
(57997, '汽油 2.4G 4WD 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6759),
(57996, '汽油 2.4G 2WD 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6758),
(57995, '汽油 2.0L 2WD 豪华型', NULL, 4876, 0, NULL, 'L', 0, 5, 6757),
(57994, '精质版 2.0L MT 7座 国Ⅳ', NULL, 4875, 0, NULL, 'L', 0, 5, 8839),
(57993, '精质版 1.6L MT 5座', NULL, 4875, 0, NULL, 'L', 0, 5, 8838),
(57992, '精质版 1.6L MT 7座', NULL, 4875, 0, NULL, 'L', 0, 5, 8837),
(57991, '精质版 2.0L MT 5座 国Ⅳ', NULL, 4875, 0, NULL, 'L', 0, 5, 8836),
(57990, '精质版 2.0L MT 7座 国III+OBD', NULL, 4875, 0, NULL, 'L', 0, 5, 8835),
(57989, '精质版 2.0L MT 5座 国III+OBD', NULL, 4875, 0, NULL, 'L', 0, 5, 8834),
(57988, '2.0L AT 7座', NULL, 4875, 0, NULL, 'L', 0, 5, 4297),
(57987, '2.0L AT 5座', NULL, 4875, 0, NULL, 'L', 0, 5, 4296),
(57986, '1.8L MT 7座', NULL, 4875, 0, NULL, 'L', 0, 5, 4289),
(57985, '1.8L MT 5座', NULL, 4875, 0, NULL, 'L', 0, 5, 4288),
(57984, '2.0L MT 7座', NULL, 4875, 0, NULL, 'L', 0, 5, 1596),
(57983, '2.0L MT 5座', NULL, 4875, 0, NULL, 'L', 0, 5, 1595),
(57982, '1.6L MT 7座', NULL, 4875, 0, NULL, 'L', 0, 5, 1594),
(57981, '1.6L MT 5座', NULL, 4875, 0, NULL, 'L', 0, 5, 1593),
(57980, '精质版 2.0L AT 7座 国Ⅳ', NULL, 4874, 0, NULL, 'L', 0, 5, 9859),
(57979, '精质版 2.0L AT 5座 国Ⅳ', NULL, 4874, 0, NULL, 'L', 0, 5, 8842),
(57978, '精质版 2.0L AT 7座 国III+OBD', NULL, 4874, 0, NULL, 'L', 0, 5, 8841),
(57977, '精质版 2.0L AT 5座 国III+OBD', NULL, 4874, 0, NULL, 'L', 0, 5, 8840),
(57976, '精致版 2.0L MT 五座 国四', NULL, 4873, 0, NULL, 'L', 0, 5, 12488),
(57975, '精致版 2.0L AT 七座 国四', NULL, 4873, 0, NULL, 'L', 0, 5, 12487),
(57974, '精致版 2.0L AT 七座 国三+OBD', NULL, 4873, 0, NULL, 'L', 0, 5, 12486),
(57973, '精致版 2.0L AT 五座 国四', NULL, 4873, 0, NULL, 'L', 0, 5, 12485),
(57972, '精致版 2.0L MT 七座 国四', NULL, 4873, 0, NULL, 'L', 0, 5, 12484),
(57971, '精致版 2.0L MT 七座 国三+OBD', NULL, 4873, 0, NULL, 'L', 0, 5, 12483),
(57970, '精致版 2.0L AT 五座 国三+OBD', NULL, 4873, 0, NULL, 'L', 0, 5, 12482),
(57969, '精致版 2.0L MT 五座 国三+OBD', NULL, 4873, 0, NULL, 'L', 0, 5, 12481),
(57968, '精质版 2.0L MT 7座(国Ⅳ)', NULL, 4873, 0, NULL, 'L', 0, 5, 11611),
(57967, '精质版 2.0L MT 5座(国III+OBD)', NULL, 4873, 0, NULL, 'L', 0, 5, 11610),
(57966, '精质版 2.0L MT 5座(国Ⅳ)', NULL, 4873, 0, NULL, 'L', 0, 5, 11609),
(57965, '精质版 2.0L MT 7座(国III+OBD)', NULL, 4873, 0, NULL, 'L', 0, 5, 11608),
(57964, '精质版 1.6L MT 7座', NULL, 4873, 0, NULL, 'L', 0, 5, 11607),
(57963, '精质版 1.6L MT 5座', NULL, 4873, 0, NULL, 'L', 0, 5, 11606),
(57962, '精质版 1.8L MT 7座', NULL, 4873, 0, NULL, 'L', 0, 5, 9858),
(57961, '精质版 1.8L MT 5座', NULL, 4873, 0, NULL, 'L', 0, 5, 9857),
(57960, '吉星 五座', NULL, 4873, 0, NULL, 'L', 0, 5, 8764),
(57959, '精质版 2.0L MT 7座', NULL, 4872, 0, NULL, 'L', 0, 5, 15170),
(57958, '精质版 2.0L MT 5座', NULL, 4872, 0, NULL, 'L', 0, 5, 15169),
(57957, '精质版 1.8L MT 7座', NULL, 4872, 0, NULL, 'L', 0, 5, 15168),
(57956, '精质版 1.8L MT 5座', NULL, 4872, 0, NULL, 'L', 0, 5, 15167),
(57955, '精质版 1.6L MT 7座', NULL, 4872, 0, NULL, 'L', 0, 5, 13098),
(57954, '精质版 1.6L MT 5座', NULL, 4872, 0, NULL, 'L', 0, 5, 13097),
(57953, '标准型', NULL, 4871, 0, NULL, 'L', 0, 5, 11137),
(57952, '运动版', NULL, 4871, 0, NULL, 'L', 0, 5, 5503),
(57951, '豪华型', NULL, 4871, 0, NULL, 'L', 0, 5, 1598),
(57950, '舒适型', NULL, 4871, 0, NULL, 'L', 0, 5, 1597),
(57949, '2.4 MT 汽油 2WD', NULL, 4870, 0, NULL, 'L', 0, 5, 15626),
(57948, '领先版 2.0两驱 汽油发动机', NULL, 4870, 0, NULL, 'L', 0, 5, 10436),
(57947, '双门 汽油 2.4L 4WD', NULL, 4870, 0, NULL, 'L', 0, 5, 6204),
(57946, '双门 汽油 2.4L 2WD', NULL, 4870, 0, NULL, 'L', 0, 5, 6203),
(57945, '双门 柴油 2.8T 4WD', NULL, 4870, 0, NULL, 'L', 0, 5, 6202),
(57944, '双门 柴油 2.8L 2WD', NULL, 4870, 0, NULL, 'L', 0, 5, 6201),
(57943, '双门 汽油 2.0L 4WD', NULL, 4869, 0, NULL, 'L', 0, 5, 10437),
(57942, '领先版 2.4两驱 汽油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 8131),
(57941, '精悍版 2.0L 4*2 汽油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 8130),
(57940, '领先版 2.8两驱 柴油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4338),
(57939, '领先版 2.4L 4*4 汽油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4336),
(57938, '领先版 2.8四驱 柴油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4335),
(57937, '精悍版 2.4两驱 汽油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4334),
(57936, '精悍版 2.8两驱 柴油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4333),
(57935, '精悍版 2.4L 4*4 汽油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4332),
(57934, '精悍版 2.8四驱 柴油发动机', NULL, 4868, 0, NULL, 'L', 0, 5, 4331),
(57933, '2.5L VM  豪华型  4*2', NULL, 4867, 0, NULL, 'L', 0, 5, 8833),
(57932, '2.5L VM  豪华型  4*4', NULL, 4867, 0, NULL, 'L', 0, 5, 8832),
(57931, '2.4L 4X4 JX6440LC', NULL, 4867, 0, NULL, 'L', 0, 5, 8310),
(57930, '2.0L 4X2 JX6440LB', NULL, 4867, 0, NULL, 'L', 0, 5, 8309),
(57929, '2.5L VM 4X4 JX6441KA', NULL, 4867, 0, NULL, 'L', 0, 5, 8137),
(57928, '2.5L VM 4X2 JX6441K', NULL, 4867, 0, NULL, 'L', 0, 5, 8136),
(57927, '2.0L 两驱汽油冠军限量版', NULL, 4867, 0, NULL, 'L', 0, 5, 8132),
(57926, '2.0T 四驱 柴油版', NULL, 4866, 0, NULL, 'L', 0, 5, 104617),
(57925, '2.0T 两驱 柴油版', NULL, 4866, 0, NULL, 'L', 0, 5, 104616),
(57924, '豪华型 4X2 柴油', NULL, 4865, 0, NULL, 'L', 0, 5, 8937),
(57923, '豪华型 4X4 柴油', NULL, 4865, 0, NULL, 'L', 0, 5, 8936),
(57922, '超豪华型 4X2 柴油', NULL, 4865, 0, NULL, 'L', 0, 5, 8935),
(57921, '超豪华型 4X4 柴油', NULL, 4865, 0, NULL, 'L', 0, 5, 8934),
(57920, '超豪华型 4X4 汽油', NULL, 4865, 0, NULL, 'L', 0, 5, 8818),
(57919, '超豪华型 4X2 汽油', NULL, 4865, 0, NULL, 'L', 0, 5, 8817),
(57918, '豪华型 4X4 汽油', NULL, 4865, 0, NULL, 'L', 0, 5, 8816),
(57917, '豪华型 4X2 汽油', NULL, 4865, 0, NULL, 'L', 0, 5, 8815),
(57916, '2.0L 手动 都市先锋版 4X2', NULL, 4864, 0, NULL, 'L', 0, 5, 14818),
(57915, '尊贵版 4X4 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 14214),
(57914, '尊贵版 4X2 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 14213),
(57913, '尊贵版 4X4 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 14212),
(57912, '尊贵版 4X2 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 14211),
(57911, '导航版 4X4 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13121),
(57910, '导航版 4X2 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13120),
(57909, '导航版 4X4 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13119),
(57908, '导航版 4X2 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13118),
(57907, '超豪华型 4X4 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13117),
(57906, '豪华型 4X4 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13116),
(57905, '超豪华型 4X2 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13115),
(57904, '豪华型 4X2 柴油', NULL, 4864, 0, NULL, 'L', 0, 5, 13114),
(57903, '超豪华型 4X4 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13113),
(57902, '豪华型 4X4 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13112),
(57901, '超豪华型 4X2 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13111),
(57900, '豪华型 4X2 汽油', NULL, 4864, 0, NULL, 'L', 0, 5, 13110),
(57899, '探索版 2.0T 手动 四驱 超豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 101581),
(57898, '探索版 2.0T 手动 两驱 超豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 101580),
(57897, '探索版 2.0T 手动 四驱 豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 101579),
(57896, '探索版 2.0T 手动 两驱 豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 101577),
(57895, '探索版 2.0L 手动 两驱 都市先锋版 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16338),
(57894, '2.4L 探索版 手动 四驱 导航版 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16337),
(57893, '探索版 2.4L 手动 两驱 导航版 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16336),
(57892, '2.4L 探索版 手动 四驱 超豪华型 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16335),
(57891, '探索版 2.4L 手动 两驱 超豪华型 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16334),
(57890, '2.4L 探索版 手动 四驱 豪华双气囊型 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16333),
(57889, '探索版 2.4L 手动 两驱 豪华双气囊型 汽油', NULL, 4863, 0, NULL, 'L', 0, 5, 16332),
(57888, '2.5T 探索版 手动 四驱 导航版 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16331),
(57887, '探索版 2.5T 手动 两驱 导航版 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16330),
(57886, '探索版 2.5T 手动 两驱 超豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16329),
(57885, '2.5T 探索版 手动 四驱 超豪华型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16328),
(57884, '2.5T 探索版 手动 四驱豪华双气囊型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16327),
(57883, '探索版 2.5T 手动 两驱 豪华双气囊型 柴油', NULL, 4863, 0, NULL, 'L', 0, 5, 16326),
(57882, '探索版 2.0T 手动 四驱 超豪华型 汽油版', NULL, 4862, 0, NULL, 'L', 0, 5, 110104),
(57881, '探索版 2.0T 手动 四驱 豪华型 汽油版', NULL, 4862, 0, NULL, 'L', 0, 5, 110103),
(57880, '探索版 2.0T 手动 两驱 超豪华型 汽油版', NULL, 4862, 0, NULL, 'L', 0, 5, 110102),
(57879, '探索版 2.0T 手动 两驱 豪华型 汽油版', NULL, 4862, 0, NULL, 'L', 0, 5, 110101),
(57878, '2.4L二驱汽油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6200),
(57877, '舒适版2.0L四驱汽油标准型', NULL, 4861, 0, NULL, 'L', 0, 5, 6199),
(57876, '2.8T两驱柴油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6195),
(57875, '2.8T四驱柴油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6194),
(57874, '舒适版2.8T两驱柴油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6193),
(57873, '2.8L四驱柴油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6192),
(57872, '2.8L二驱柴油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6191),
(57871, '2.4L四驱汽油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6190),
(57870, '2.0L四驱汽油豪华型', NULL, 4861, 0, NULL, 'L', 0, 5, 6189),
(57869, '新舒适版 2.8柴油 4X2', NULL, 4861, 0, NULL, 'L', 0, 5, 4313),
(57868, '新舒适版 2.8柴油 4X4', NULL, 4861, 0, NULL, 'L', 0, 5, 4311),
(57867, '超值版2.0两驱标准型(含气囊)', NULL, 4860, 0, NULL, 'L', 0, 5, 6198),
(57866, '超值版2.8T柴油标准型(含气囊)', NULL, 4860, 0, NULL, 'L', 0, 5, 6196),
(57865, '超值版 2.0汽油 4X2', NULL, 4860, 0, NULL, 'L', 0, 5, 4326),
(57864, '超值版 2.8柴油 4X2', NULL, 4860, 0, NULL, 'L', 0, 5, 4325),
(57863, '旗舰版 2.8柴油 4X2', NULL, 4860, 0, NULL, 'L', 0, 5, 4308),
(57862, '旗舰版 2.0汽油 4X4', NULL, 4860, 0, NULL, 'L', 0, 5, 4307),
(57861, '旗舰版 2.8柴油 4X4', NULL, 4860, 0, NULL, 'L', 0, 5, 4305),
(57860, '2.0L 超值版', NULL, 4859, 0, NULL, 'L', 0, 5, 6197),
(57859, '新饰力豪华 4*4', NULL, 4859, 0, NULL, 'L', 0, 5, 4330),
(57858, '新饰力豪华 4*2', NULL, 4859, 0, NULL, 'L', 0, 5, 4329),
(57857, '新饰力标准 4*2', NULL, 4859, 0, NULL, 'L', 0, 5, 4328),
(57856, '新饰力标准 4*4', NULL, 4859, 0, NULL, 'L', 0, 5, 4327),
(57855, '新舒适版 2.0 标准型 4X2', NULL, 4859, 0, NULL, 'L', 0, 5, 4319),
(57854, '新舒适版 2.4 标准型 4X2', NULL, 4859, 0, NULL, 'L', 0, 5, 4318),
(57853, '新舒适版 2.4 标准型 4X4', NULL, 4859, 0, NULL, 'L', 0, 5, 4312),
(57852, '旗舰版 2.0 豪华型 4X2', NULL, 4859, 0, NULL, 'L', 0, 5, 4310),
(57851, '旗舰版 2.4 豪华型 4X2', NULL, 4859, 0, NULL, 'L', 0, 5, 4309),
(57850, '旗舰版 2.4 标准型 4X4', NULL, 4859, 0, NULL, 'L', 0, 5, 4306),
(57849, '龙腾版 豪华型 4X4', NULL, 4858, 0, NULL, 'L', 0, 5, 8135),
(57848, '龙腾版 豪华型 4X2', NULL, 4858, 0, NULL, 'L', 0, 5, 8134),
(57847, '龙腾版 舒适型 4X4', NULL, 4858, 0, NULL, 'L', 0, 5, 5507),
(57846, '龙腾版 舒适型 4X2', NULL, 4858, 0, NULL, 'L', 0, 5, 5506),
(57845, '龙腾版 标准型 4X4', NULL, 4858, 0, NULL, 'L', 0, 5, 5505),
(57844, '龙腾版 标准型 4X2', NULL, 4858, 0, NULL, 'L', 0, 5, 5504),
(57843, '2.0L 两驱 超值版 国四OBD', NULL, 4857, 0, NULL, 'L', 0, 5, 11605),
(57842, '2.0L 两驱 超值版 国三OBD', NULL, 4857, 0, NULL, 'L', 0, 5, 11604),
(57841, '2.8 四驱超值版', NULL, 4857, 0, NULL, 'L', 0, 5, 11113),
(57840, '2.8 两驱 超值版', NULL, 4857, 0, NULL, 'L', 0, 5, 11112),
(57839, '2.0L 两驱 豪华版 汽油', NULL, 4856, 0, NULL, 'L', 0, 5, 14217),
(57838, '2.8L 四驱 豪华版 柴油', NULL, 4856, 0, NULL, 'L', 0, 5, 14216),
(57837, '2.8L 两驱 豪华版 柴油', NULL, 4856, 0, NULL, 'L', 0, 5, 14215),
(57836, '2.8L 四驱 超值版 柴油', NULL, 4856, 0, NULL, 'L', 0, 5, 13975),
(57835, '2.8L 两驱 超值版 柴油', NULL, 4856, 0, NULL, 'L', 0, 5, 13974),
(57834, '2.8L 两驱 超值版 汽油', NULL, 4856, 0, NULL, 'L', 0, 5, 13869),
(57833, '2.8L 四驱 超值版 汽油', NULL, 4856, 0, NULL, 'L', 0, 5, 13868),
(57832, '2.0L 两驱 超值版 汽油 国四', NULL, 4856, 0, NULL, 'L', 0, 5, 13866),
(57831, '2.0L 两驱 超值版 汽油 国三 OBD', NULL, 4856, 0, NULL, 'L', 0, 5, 13864),
(57830, '2.0T 手动 两驱 创领版', NULL, 4855, 0, NULL, 'L', 0, 5, 102879),
(57829, '2.0T 手动 两驱 创享版', NULL, 4855, 0, NULL, 'L', 0, 5, 102878),
(57828, '2.0T 手动 两驱 创行版', NULL, 4855, 0, NULL, 'L', 0, 5, 102877),
(57827, '1.6L 自动 两驱豪华版', NULL, 4854, 0, NULL, 'L', 0, 5, 106657),
(57826, '1.6L 手动 两驱豪华版', NULL, 4854, 0, NULL, 'L', 0, 5, 106520),
(57825, '2.4L四驱 豪华导航版', NULL, 4853, 0, NULL, 'L', 0, 5, 11418),
(57824, '2.4L 两驱 豪华导航版', NULL, 4853, 0, NULL, 'L', 0, 5, 11417),
(57823, '2.4L四驱运动导航版', NULL, 4853, 0, NULL, 'L', 0, 5, 11066),
(57822, '2.4L四驱豪华版', NULL, 4853, 0, NULL, 'L', 0, 5, 11065),
(57821, '2.4L 两驱 豪华版', NULL, 4853, 0, NULL, 'L', 0, 5, 11064),
(57820, '2.4L 两驱 标准版', NULL, 4853, 0, NULL, 'L', 0, 5, 11063),
(57819, '2.4L 自动 两驱 运动导航版', NULL, 4852, 0, NULL, 'L', 0, 5, 14762),
(57818, '2.4L 自动四驱 豪华导航版', NULL, 4852, 0, NULL, 'L', 0, 5, 14761),
(57817, '2.4L 自动 两驱 豪华导航版', NULL, 4852, 0, NULL, 'L', 0, 5, 14760),
(57816, '2.4L 自动 两驱 标准版', NULL, 4852, 0, NULL, 'L', 0, 5, 14759),
(57815, '2.4L 手动 两驱 标准版', NULL, 4852, 0, NULL, 'L', 0, 5, 14758),
(57814, '2.4L 自动 四驱 运动导航版', NULL, 4851, 0, NULL, 'L', 0, 5, 111172),
(57813, '1.3 AT', NULL, 4850, 0, NULL, 'L', 0, 5, 3353),
(57812, '1.3 MT', NULL, 4850, 0, NULL, 'L', 0, 5, 3352),
(57811, '1.3 AT 时尚型', NULL, 4849, 0, NULL, 'L', 0, 5, 8342),
(57810, '1.3 MT 时尚型', NULL, 4849, 0, NULL, 'L', 0, 5, 8341),
(57809, '1.3 自动 双色导航版GPS', NULL, 4848, 0, NULL, 'L', 0, 5, 12680),
(57808, '1.3  自动 双色版Mode3', NULL, 4848, 0, NULL, 'L', 0, 5, 12679),
(57807, '1.3 手动 双色导航版GPS', NULL, 4848, 0, NULL, 'L', 0, 5, 12678),
(57806, '1.3 手动 双色版Mode3', NULL, 4848, 0, NULL, 'L', 0, 5, 12677),
(57805, '1.3 自动 单色导航版GPS', NULL, 4848, 0, NULL, 'L', 0, 5, 12676),
(57804, '1.3 自动 单色版JLX', NULL, 4848, 0, NULL, 'L', 0, 5, 12675),
(57803, '1.3 手动 单色导航版GPS', NULL, 4848, 0, NULL, 'L', 0, 5, 12674),
(57802, '1.3 手动 单色版JLX', NULL, 4848, 0, NULL, 'L', 0, 5, 12673),
(57801, '1.3L 手动 JLX', NULL, 4847, 0, NULL, 'L', 0, 5, 101514),
(57800, '1.3L 自动 JLX', NULL, 4847, 0, NULL, 'L', 0, 5, 101513),
(57799, '1.3L 手动 JLX 导航版', NULL, 4847, 0, NULL, 'L', 0, 5, 101512),
(57798, '1.3L 自动 JLX 导航版', NULL, 4847, 0, NULL, 'L', 0, 5, 101511),
(57797, '1.3L 手动 Mode3', NULL, 4847, 0, NULL, 'L', 0, 5, 101510),
(57796, '1.3L 自动 Mode3', NULL, 4847, 0, NULL, 'L', 0, 5, 101509),
(57795, '1.3L 手动 Mode3 导航版', NULL, 4847, 0, NULL, 'L', 0, 5, 101508),
(57794, '1.3L 自动 Mode3 导航版', NULL, 4847, 0, NULL, 'L', 0, 5, 101507),
(57793, '1.6L3门手动版', NULL, 4846, 0, NULL, 'L', 0, 5, 11046),
(57792, '1.6 4门 自动', NULL, 4845, 0, NULL, 'L', 0, 5, 15614),
(57791, '2.0L 4门 自动', NULL, 4845, 0, NULL, 'L', 0, 5, 15612),
(57790, '5门豪华型手动', NULL, 4844, 0, NULL, 'L', 0, 5, 3359),
(57789, '5门豪华型 自动', NULL, 4844, 0, NULL, 'L', 0, 5, 3356),
(57788, '5门舒适型 自动', NULL, 4844, 0, NULL, 'L', 0, 5, 3355),
(57787, '1.6L3门手动版', NULL, 4844, 0, NULL, 'L', 0, 5, 3354),
(57786, '5门舒适型手动', NULL, 4843, 0, NULL, 'L', 0, 5, 3357),
(57785, '5门 3.2L 5AT JLX—EL', NULL, 4842, 0, NULL, 'L', 0, 5, 6970),
(57784, '5门 2.4L 4AT JLX—EL', NULL, 4842, 0, NULL, 'L', 0, 5, 6968),
(57783, '5门 2.4L 5MT JLX—EL', NULL, 4842, 0, NULL, 'L', 0, 5, 6967),
(57782, '5门 2.4L 4AT JLX', NULL, 4842, 0, NULL, 'L', 0, 5, 6966),
(57781, '3门 2.4L 4AT JX—EH', NULL, 4842, 0, NULL, 'L', 0, 5, 6965),
(57780, '3门 2.4L 5MT JX', NULL, 4842, 0, NULL, 'L', 0, 5, 6964),
(57779, '2.0L5门手动版', NULL, 4842, 0, NULL, 'L', 0, 5, 4023),
(57778, '2.0L5门自动版', NULL, 4842, 0, NULL, 'L', 0, 5, 4022),
(57777, '3.2L 自动 JLX—EL 5门', NULL, 4841, 0, NULL, 'L', 0, 5, 13965),
(57776, '2.4L 手动 JX 3门', NULL, 4841, 0, NULL, 'L', 0, 5, 13963),
(57775, '2.4L 自动 JX—EH 3门', NULL, 4841, 0, NULL, 'L', 0, 5, 13873),
(57774, '2.4L 自动 JLX—EL 5门', NULL, 4841, 0, NULL, 'L', 0, 5, 13523),
(57773, '2.4L 手动 JLX—EL 5门', NULL, 4841, 0, NULL, 'L', 0, 5, 13522),
(57772, '2.4L 手动 豪华导航版 5门', NULL, 4840, 0, NULL, 'L', 0, 5, 101946),
(57771, '2.4L 自动 豪华导航版 5门', NULL, 4840, 0, NULL, 'L', 0, 5, 101945),
(57770, '电喷型', NULL, 4839, 0, NULL, 'L', 0, 5, 6850),
(57769, '自动超豪华型', NULL, 4838, 0, NULL, 'L', 0, 5, 350),
(57768, '自动豪华型', NULL, 4838, 0, NULL, 'L', 0, 5, 349),
(57767, '手动超豪华型', NULL, 4838, 0, NULL, 'L', 0, 5, 348),
(57766, '手动豪华型', NULL, 4838, 0, NULL, 'L', 0, 5, 347),
(57765, '手动舒适型', NULL, 4838, 0, NULL, 'L', 0, 5, 346),
(57764, '1.3 自动超豪华型周年纪念版', NULL, 4837, 0, NULL, 'L', 0, 5, 108971),
(57763, '1.3 手动超豪华型周年纪念版', NULL, 4837, 0, NULL, 'L', 0, 5, 108970);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(57762, '1.3 自动超豪华型', NULL, 4837, 0, NULL, 'L', 0, 5, 107691),
(57761, '1.3 自动豪华型', NULL, 4837, 0, NULL, 'L', 0, 5, 107690),
(57760, '1.3 手动超豪华型', NULL, 4837, 0, NULL, 'L', 0, 5, 107689),
(57759, '1.3 手动豪华型', NULL, 4837, 0, NULL, 'L', 0, 5, 107688),
(57758, '1.3 手动舒适型', NULL, 4837, 0, NULL, 'L', 0, 5, 107687),
(57757, '1.5 自动超炫版炫酷款', NULL, 4836, 0, NULL, 'L', 0, 5, 107668),
(57756, '1.5 自动超炫版炫锐款', NULL, 4836, 0, NULL, 'L', 0, 5, 107667),
(57755, '1.5 手动超炫版炫锐款', NULL, 4836, 0, NULL, 'L', 0, 5, 107666),
(57754, '1.5L炫酷自动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4656),
(57753, '1.5L炫锐自动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4655),
(57752, '1.5L炫锐手动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4654),
(57751, '1.3L炫乐自动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4653),
(57750, '1.3L炫乐手动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4652),
(57749, '1.3L炫彩手动版', NULL, 4836, 0, NULL, 'L', 0, 5, 4651),
(57748, '1.5 手动冬恋炫锐限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 108974),
(57747, '1.3 自动冬恋炫乐限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 108973),
(57746, '1.3 手动冬恋炫乐限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 108972),
(57745, '1.5 自动冬恋炫锐限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 107699),
(57744, '1.5 自动冬恋炫酷限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 107698),
(57743, '1.5 自动劲乐炫锐版', NULL, 4835, 0, NULL, 'L', 0, 5, 107697),
(57742, '1.5 自动劲乐炫酷版', NULL, 4835, 0, NULL, 'L', 0, 5, 107696),
(57741, '1.5 手动劲乐炫锐版', NULL, 4835, 0, NULL, 'L', 0, 5, 107695),
(57740, '1.3 自动炫乐版', NULL, 4835, 0, NULL, 'L', 0, 5, 107694),
(57739, '1.3 手动冬恋炫彩限量版', NULL, 4835, 0, NULL, 'L', 0, 5, 107693),
(57738, '1.3 手动炫乐版', NULL, 4835, 0, NULL, 'L', 0, 5, 107692),
(57737, '1.5 自动炫锐版', NULL, 4835, 0, NULL, 'L', 0, 5, 107665),
(57736, '1.5L超炫版炫酷自动版', NULL, 4835, 0, NULL, 'L', 0, 5, 5761),
(57735, '1.5L超炫版炫锐手动版', NULL, 4835, 0, NULL, 'L', 0, 5, 5760),
(57734, '1.5L超炫版炫锐自动版', NULL, 4835, 0, NULL, 'L', 0, 5, 5759),
(57733, '1.5 自动双色炫酷版', NULL, 4834, 0, NULL, 'L', 0, 5, 108949),
(57732, '1.5 自动双色炫锐版', NULL, 4834, 0, NULL, 'L', 0, 5, 108948),
(57731, '1.5 手动双色炫锐版', NULL, 4834, 0, NULL, 'L', 0, 5, 108947),
(57730, '1.5L爱丽丝', NULL, 4834, 0, NULL, 'L', 0, 5, 9919),
(57729, '1.5L墨客 手动版', NULL, 4834, 0, NULL, 'L', 0, 5, 9918),
(57728, '1.5L墨客 自动版', NULL, 4834, 0, NULL, 'L', 0, 5, 9917),
(57727, '1.3L超值版 AT', NULL, 4834, 0, NULL, 'L', 0, 5, 9160),
(57726, '1.3L超值版 MT', NULL, 4834, 0, NULL, 'L', 0, 5, 8672),
(57725, '1.5 自动运动版', NULL, 4833, 0, NULL, 'L', 0, 5, 107703),
(57724, '1.5 手动运动版', NULL, 4833, 0, NULL, 'L', 0, 5, 107702),
(57723, '1.3 自动时尚型', NULL, 4833, 0, NULL, 'L', 0, 5, 107701),
(57722, '1.3 手动时尚型', NULL, 4833, 0, NULL, 'L', 0, 5, 107700),
(57721, '1.3 手动超值版', NULL, 4833, 0, NULL, 'L', 0, 5, 107669),
(57720, '1.3L 舒适版 手动', NULL, 4833, 0, NULL, 'L', 0, 5, 101436),
(57719, '1.3L 舒适版 自动', NULL, 4833, 0, NULL, 'L', 0, 5, 101250),
(57718, '1.5冠军限量版 AT', NULL, 4833, 0, NULL, 'L', 0, 5, 11239),
(57717, '1.5冠军限量版 MT', NULL, 4833, 0, NULL, 'L', 0, 5, 11238),
(57716, '1.3L 自动 超值版', NULL, 4832, 0, NULL, 'L', 0, 5, 13300),
(57715, '1.5L 自动 标准型', NULL, 4832, 0, NULL, 'L', 0, 5, 13299),
(57714, '1.5L 手动 标准型', NULL, 4832, 0, NULL, 'L', 0, 5, 13297),
(57713, '1.5L 手动 运动版', NULL, 4832, 0, NULL, 'L', 0, 5, 12329),
(57712, '1.3L 自动 时尚型', NULL, 4832, 0, NULL, 'L', 0, 5, 12328),
(57711, '1.3L 手动 时尚型', NULL, 4832, 0, NULL, 'L', 0, 5, 12327),
(57710, '1.3L 手动 超值版', NULL, 4832, 0, NULL, 'L', 0, 5, 12326),
(57709, '1.5L 自动 运动版', NULL, 4832, 0, NULL, 'L', 0, 5, 12325),
(57708, '1.3L 手动 超值版', NULL, 4831, 0, NULL, 'L', 0, 5, 15542),
(57707, '1.5L 自动 20周年限量版', NULL, 4830, 0, NULL, 'L', 0, 5, 104913),
(57706, '1.5L 手动 20周年限量版', NULL, 4830, 0, NULL, 'L', 0, 5, 104912),
(57705, '1.5L 手动 标准型', NULL, 4830, 0, NULL, 'L', 0, 5, 103412),
(57704, '1.5L 自动 标准型', NULL, 4830, 0, NULL, 'L', 0, 5, 103411),
(57703, '1.5L 手动 运动型', NULL, 4830, 0, NULL, 'L', 0, 5, 103410),
(57702, '1.5L 自动 运动型', NULL, 4830, 0, NULL, 'L', 0, 5, 103285),
(57701, '1.3L 手动 超值版', NULL, 4830, 0, NULL, 'L', 0, 5, 103284),
(57700, '1.8L 自动 豪华型', NULL, 4829, 0, NULL, 'L', 0, 5, 12754),
(57699, '1.8L 手动 豪华型', NULL, 4829, 0, NULL, 'L', 0, 5, 12753),
(57698, '1.6L 自动 豪华型', NULL, 4829, 0, NULL, 'L', 0, 5, 12752),
(57697, '1.6L 手动 豪华型', NULL, 4829, 0, NULL, 'L', 0, 5, 12751),
(57696, '1.6L 自动 舒适型', NULL, 4829, 0, NULL, 'L', 0, 5, 12750),
(57695, '1.6L 手动 舒适型', NULL, 4829, 0, NULL, 'L', 0, 5, 12749),
(57694, '1.8L 自动 豪华型', NULL, 4828, 0, NULL, 'L', 0, 5, 104787),
(57693, '1.8L 手动 豪华型', NULL, 4828, 0, NULL, 'L', 0, 5, 104786),
(57692, '1.6L 自动 豪华型', NULL, 4828, 0, NULL, 'L', 0, 5, 104785),
(57691, '1.6L 自动 舒适型', NULL, 4828, 0, NULL, 'L', 0, 5, 104784),
(57690, '1.6L 手动 豪华型', NULL, 4828, 0, NULL, 'L', 0, 5, 104783),
(57689, '1.6L 手动 舒适型', NULL, 4828, 0, NULL, 'L', 0, 5, 104782),
(57688, '1.6L 手动 实用型升级版', NULL, 4828, 0, NULL, 'L', 0, 5, 101460),
(57687, '1.6L 自动 实用型升级版', NULL, 4828, 0, NULL, 'L', 0, 5, 101459),
(57686, '1.6L 自动 实用型', NULL, 4828, 0, NULL, 'L', 0, 5, 100690),
(57685, '1.6L 手动 实用型', NULL, 4828, 0, NULL, 'L', 0, 5, 100689),
(57684, '1.6L手动标准型', NULL, 4827, 0, NULL, 'L', 0, 5, 10239),
(57683, '1.6 手动标准型M16A', NULL, 4826, 0, NULL, 'L', 0, 5, 108966),
(57682, '1.6 自动精英型', NULL, 4826, 0, NULL, 'L', 0, 5, 107684),
(57681, '1.6 手动精英型', NULL, 4826, 0, NULL, 'L', 0, 5, 107683),
(57680, '1.6 手动标准型', NULL, 4826, 0, NULL, 'L', 0, 5, 107664),
(57679, '1.6 自动豪华型', NULL, 4826, 0, NULL, 'L', 0, 5, 107663),
(57678, '1.6 手动豪华型', NULL, 4826, 0, NULL, 'L', 0, 5, 107662),
(57677, '自动豪华天窗型', NULL, 4826, 0, NULL, 'L', 0, 5, 5598),
(57676, '手动豪华天窗型', NULL, 4826, 0, NULL, 'L', 0, 5, 5597),
(57675, '自动精英型', NULL, 4826, 0, NULL, 'L', 0, 5, 355),
(57674, '自动豪华型', NULL, 4826, 0, NULL, 'L', 0, 5, 354),
(57673, '手动豪华型', NULL, 4826, 0, NULL, 'L', 0, 5, 353),
(57672, '手动精英型', NULL, 4826, 0, NULL, 'L', 0, 5, 352),
(57671, '1.6 手动双燃料CNG', NULL, 4825, 0, NULL, 'L', 0, 5, 108969),
(57670, '1.6 自动豪华经典型', NULL, 4825, 0, NULL, 'L', 0, 5, 108968),
(57669, '1.6 手动豪华经典型', NULL, 4825, 0, NULL, 'L', 0, 5, 108967),
(57668, '1.6 自动精英型', NULL, 4825, 0, NULL, 'L', 0, 5, 107686),
(57667, '1.6 手动精英型', NULL, 4825, 0, NULL, 'L', 0, 5, 107685),
(57666, '悦享版自动型', NULL, 4825, 0, NULL, 'L', 0, 5, 6959),
(57665, '悦享版手动型', NULL, 4825, 0, NULL, 'L', 0, 5, 6941),
(57664, '豪华型天窗版 AT', NULL, 4825, 0, NULL, 'L', 0, 5, 5174),
(57663, '豪华型天窗版 MT', NULL, 4825, 0, NULL, 'L', 0, 5, 5173),
(57662, '豪华型 AT', NULL, 4825, 0, NULL, 'L', 0, 5, 5172),
(57661, '豪华型 MT', NULL, 4825, 0, NULL, 'L', 0, 5, 5171),
(57660, '1.6L 公务版 MT', NULL, 4824, 0, NULL, 'L', 0, 5, 8627),
(57659, '1.8L 豪华型 AT', NULL, 4824, 0, NULL, 'L', 0, 5, 8047),
(57658, '1.8L 豪华型 MT', NULL, 4824, 0, NULL, 'L', 0, 5, 8046),
(57657, '1.6L 豪华型 AT', NULL, 4824, 0, NULL, 'L', 0, 5, 8045),
(57656, '1.6L 精英型 AT', NULL, 4824, 0, NULL, 'L', 0, 5, 8044),
(57655, '1.6L 精英型 MT', NULL, 4824, 0, NULL, 'L', 0, 5, 8043),
(57654, '1.6L超值型 AT', NULL, 4823, 0, NULL, 'L', 0, 5, 5170),
(57653, '1.6L超值版 MT', NULL, 4823, 0, NULL, 'L', 0, 5, 5169),
(57652, '1.6L 自动 运动型', NULL, 4822, 0, NULL, 'L', 0, 5, 15629),
(57651, '1.6L 手动 运动型', NULL, 4822, 0, NULL, 'L', 0, 5, 15628),
(57650, '1.8L 手动 运动型', NULL, 4822, 0, NULL, 'L', 0, 5, 15627),
(57649, '1.8L 自动 运动型', NULL, 4822, 0, NULL, 'L', 0, 5, 15589),
(57648, '锐骑 1.6L 自动基本型', NULL, 4821, 0, NULL, 'L', 0, 5, 104073),
(57647, '1.6 自动运动休旅款M16A1', NULL, 4820, 0, NULL, 'L', 0, 5, 108961),
(57646, '1.6 自动豪华型M16A1', NULL, 4820, 0, NULL, 'L', 0, 5, 108960),
(57645, '1.6 自动都市时尚型M16A1', NULL, 4820, 0, NULL, 'L', 0, 5, 108959),
(57644, '1.6 手动豪华型M16A', NULL, 4820, 0, NULL, 'L', 0, 5, 108958),
(57643, '1.6 手动标准型M16A', NULL, 4820, 0, NULL, 'L', 0, 5, 108957),
(57642, '1.6 自动运动休旅款', NULL, 4820, 0, NULL, 'L', 0, 5, 107679),
(57641, '1.6 自动都市时尚型', NULL, 4820, 0, NULL, 'L', 0, 5, 107678),
(57640, '1.6 手动运动休旅款', NULL, 4820, 0, NULL, 'L', 0, 5, 107677),
(57639, '1.6 手动都市时尚型', NULL, 4820, 0, NULL, 'L', 0, 5, 107676),
(57638, '1.6 自动豪华型', NULL, 4820, 0, NULL, 'L', 0, 5, 107675),
(57637, '1.6 手动标准型', NULL, 4820, 0, NULL, 'L', 0, 5, 107674),
(57636, '1.6L 精英型 MT', NULL, 4820, 0, NULL, 'L', 0, 5, 9083),
(57635, '1.6L 精英型 AT', NULL, 4820, 0, NULL, 'L', 0, 5, 9082),
(57634, '1.6L 标准型 AT', NULL, 4820, 0, NULL, 'L', 0, 5, 9081),
(57633, '时尚天骄自动档', NULL, 4820, 0, NULL, 'L', 0, 5, 362),
(57632, '时尚天骄手动挡', NULL, 4820, 0, NULL, 'L', 0, 5, 361),
(57631, '1.6L 豪华型 AT', NULL, 4819, 0, NULL, 'L', 0, 5, 10238),
(57630, '1.6L 豪华型 MT', NULL, 4819, 0, NULL, 'L', 0, 5, 10237),
(57629, '1.6L 标准型 MT', NULL, 4819, 0, NULL, 'L', 0, 5, 10236),
(57628, 'SX4锐骑自动豪华型', NULL, 4819, 0, NULL, 'L', 0, 5, 5929),
(57627, 'SX4锐骑版手动豪华型', NULL, 4819, 0, NULL, 'L', 0, 5, 5928),
(57626, '都市时尚款 AT', NULL, 4819, 0, NULL, 'L', 0, 5, 5916),
(57625, '天语SX4—Sport 限量版', NULL, 4819, 0, NULL, 'L', 0, 5, 5758),
(57624, '运动休旅款 AT', NULL, 4819, 0, NULL, 'L', 0, 5, 359),
(57623, '运动休旅款 MT', NULL, 4819, 0, NULL, 'L', 0, 5, 358),
(57622, '都市时尚款 MT', NULL, 4819, 0, NULL, 'L', 0, 5, 357),
(57621, '都市时尚款 自动', NULL, 4819, 0, NULL, 'L', 0, 5, 356),
(57620, '1.8L 运动型 AT', NULL, 4818, 0, NULL, 'L', 0, 5, 8052),
(57619, '1.8L 运动型 MT', NULL, 4818, 0, NULL, 'L', 0, 5, 8051),
(57618, '1.6L 运动型 AT', NULL, 4818, 0, NULL, 'L', 0, 5, 8050),
(57617, '1.6L 运动型 MT', NULL, 4818, 0, NULL, 'L', 0, 5, 8049),
(57616, '1.6L 时尚型 MT', NULL, 4818, 0, NULL, 'L', 0, 5, 8048),
(57615, '1.6 手动运动型增配版', NULL, 4817, 0, NULL, 'L', 0, 5, 108946),
(57614, '1.6 自动灵动型', NULL, 4817, 0, NULL, 'L', 0, 5, 107681),
(57613, '1.6 手动灵动型', NULL, 4817, 0, NULL, 'L', 0, 5, 107680),
(57612, '1.6L 冠军限量版 AT', NULL, 4817, 0, NULL, 'L', 0, 5, 11237),
(57611, '1.6L 冠军限量版 MT', NULL, 4817, 0, NULL, 'L', 0, 5, 11236),
(57610, '1.6 自动舒适型', NULL, 4816, 0, NULL, 'L', 0, 5, 107682),
(57609, '1.8L 运动型 MT', NULL, 4816, 0, NULL, 'L', 0, 5, 13393),
(57608, '1.8L 运动型 AT', NULL, 4816, 0, NULL, 'L', 0, 5, 13392),
(57607, '1.6L 舒适型 AT', NULL, 4816, 0, NULL, 'L', 0, 5, 12955),
(57606, '1.6L 舒适型 MT', NULL, 4816, 0, NULL, 'L', 0, 5, 12954),
(57605, '1.6L 运动型 AT', NULL, 4816, 0, NULL, 'L', 0, 5, 12395),
(57604, '1.6L 运动型 MT', NULL, 4816, 0, NULL, 'L', 0, 5, 12394),
(57603, '1.6L 灵动型 AT', NULL, 4816, 0, NULL, 'L', 0, 5, 12393),
(57602, '1.6L 灵动型 MT', NULL, 4816, 0, NULL, 'L', 0, 5, 12392),
(57601, '1.8 自动锐骑运动型', NULL, 4815, 0, NULL, 'L', 0, 5, 108965),
(57600, '1.8 手动锐骑运动型', NULL, 4815, 0, NULL, 'L', 0, 5, 108964),
(57599, '1.6 自动锐骑运动型', NULL, 4815, 0, NULL, 'L', 0, 5, 108963),
(57598, '1.6 手动锐骑运动型', NULL, 4815, 0, NULL, 'L', 0, 5, 108962),
(57597, '酷锐版 1.6L 自动20周年3G智能版', NULL, 4814, 0, NULL, 'L', 0, 5, 106026),
(57596, '酷锐版 1.6L 手动20周年3G智能版', NULL, 4814, 0, NULL, 'L', 0, 5, 106025),
(57595, '酷锐版 1.6L 自动 舒适型', NULL, 4814, 0, NULL, 'L', 0, 5, 104407),
(57594, '酷锐版 1.6L 手动 舒适型', NULL, 4814, 0, NULL, 'L', 0, 5, 104406),
(57593, '酷锐版 1.6L 手动 运动型', NULL, 4814, 0, NULL, 'L', 0, 5, 104405),
(57592, '酷锐版 1.6L 自动 运动型', NULL, 4814, 0, NULL, 'L', 0, 5, 104404),
(57591, '酷锐版 1.6L 自动 灵动型', NULL, 4814, 0, NULL, 'L', 0, 5, 104403),
(57590, '酷锐版 1.6L 手动 灵动型', NULL, 4814, 0, NULL, 'L', 0, 5, 104065),
(57589, '1.0基本型', NULL, 4813, 0, NULL, 'L', 0, 5, 6185),
(57588, '1.0 手动', NULL, 4812, 0, NULL, 'L', 0, 5, 108952),
(57587, '1.3ACRC 世纪星 手动', NULL, 4812, 0, NULL, 'L', 0, 5, 108951),
(57586, '1.3ACRC 世纪星 自动', NULL, 4812, 0, NULL, 'L', 0, 5, 107656),
(57585, '1.3ACRT 天窗豪华型 自动', NULL, 4812, 0, NULL, 'L', 0, 5, 107654),
(57584, 'SC7130CDE普通型', NULL, 4812, 0, NULL, 'L', 0, 5, 334),
(57583, 'SC7130CDA出租型', NULL, 4812, 0, NULL, 'L', 0, 5, 333),
(57582, 'SC7130A CRT AT 世纪星', NULL, 4811, 0, NULL, 'L', 0, 5, 10235),
(57581, '1.3ACRT 天窗豪华型 自动', NULL, 4810, 0, NULL, 'L', 0, 5, 107660),
(57580, '1.3CDC 豪华型 手动', NULL, 4810, 0, NULL, 'L', 0, 5, 107659),
(57579, '1.3CDT 天窗型 手动', NULL, 4810, 0, NULL, 'L', 0, 5, 107658),
(57578, '1.3CDH 实用型 手动', NULL, 4810, 0, NULL, 'L', 0, 5, 107657),
(57577, '1.3CDB 标准型 手动', NULL, 4810, 0, NULL, 'L', 0, 5, 107655),
(57576, 'SC7130A CRT AT ok款天窗版', NULL, 4810, 0, NULL, 'L', 0, 5, 340),
(57575, 'SC7130CDT ok款天窗版', NULL, 4810, 0, NULL, 'L', 0, 5, 339),
(57574, 'SC7130CDC ok款豪华型', NULL, 4810, 0, NULL, 'L', 0, 5, 338),
(57573, 'SC7130CDH ok款实用型', NULL, 4810, 0, NULL, 'L', 0, 5, 337),
(57572, 'SC7130 CDJ ok款舒适型', NULL, 4810, 0, NULL, 'L', 0, 5, 336),
(57571, 'SC7130CDB ok款标准型', NULL, 4810, 0, NULL, 'L', 0, 5, 335),
(57570, '1.3 手动 CNG双燃料', NULL, 4809, 0, NULL, 'L', 0, 5, 108956),
(57569, '1.3 手动', NULL, 4809, 0, NULL, 'L', 0, 5, 108953),
(57568, '1.3 手动', NULL, 4808, 0, NULL, 'L', 0, 5, 108955),
(57567, 'SC7130CDK ok款超值型', NULL, 4808, 0, NULL, 'L', 0, 5, 343),
(57566, 'SC7130CDB ok款标准型', NULL, 4808, 0, NULL, 'L', 0, 5, 342),
(57565, 'SC7130CDA出租型', NULL, 4808, 0, NULL, 'L', 0, 5, 341),
(57564, '1.3 手动', NULL, 4807, 0, NULL, 'L', 0, 5, 108954),
(57563, '白金版 MT', NULL, 4807, 0, NULL, 'L', 0, 5, 345),
(57562, '舒适型 MT', NULL, 4807, 0, NULL, 'L', 0, 5, 344),
(57561, '1.3 白金版 手动', NULL, 4806, 0, NULL, 'L', 0, 5, 107661),
(57560, '1.3基本型', NULL, 4805, 0, NULL, 'L', 0, 5, 13215),
(57559, '1.3舒适型', NULL, 4805, 0, NULL, 'L', 0, 5, 12320),
(57558, '1.3标准型', NULL, 4805, 0, NULL, 'L', 0, 5, 12319),
(57557, '1.3L 手动 舒适型 国III', NULL, 4804, 0, NULL, 'L', 0, 5, 15625),
(57556, '1.3L 手动 标准型 国III', NULL, 4804, 0, NULL, 'L', 0, 5, 15624),
(57555, '1.3L 手动 舒适型 国IV', NULL, 4804, 0, NULL, 'L', 0, 5, 15623),
(57554, '1.3L 手动 标准型 国IV', NULL, 4804, 0, NULL, 'L', 0, 5, 15622),
(57553, '1.3L 手动 基本型 国IV', NULL, 4804, 0, NULL, 'L', 0, 5, 15621),
(57552, '1.3L 手动 20周年限量版', NULL, 4803, 0, NULL, 'L', 0, 5, 104911),
(57551, '1.6L MT 精英型', NULL, 4802, 0, NULL, 'L', 0, 5, 105972),
(57550, '1.6L MT 进取型 ', NULL, 4802, 0, NULL, 'L', 0, 5, 105971),
(57549, '1.6L CVT 进取型 ', NULL, 4802, 0, NULL, 'L', 0, 5, 105970),
(57548, '1.6L CVT 精英型', NULL, 4802, 0, NULL, 'L', 0, 5, 105968),
(57547, '1.6L CVT 尊贵型', NULL, 4802, 0, NULL, 'L', 0, 5, 103900),
(57546, '0.8 SC 手动低于国1型', NULL, 4801, 0, NULL, 'L', 0, 5, 107670),
(57545, '化油器型', NULL, 4800, 0, NULL, 'L', 0, 5, 6083),
(57544, '0.8 SC 手动', NULL, 4799, 0, NULL, 'L', 0, 5, 107671),
(57543, 'SC7080A', NULL, 4798, 0, NULL, 'L', 0, 5, 6084),
(57542, '王子基本型', NULL, 4798, 0, NULL, 'L', 0, 5, 5851),
(57541, '标准型', NULL, 4798, 0, NULL, 'L', 0, 5, 5850),
(57540, '快乐王子', NULL, 4798, 0, NULL, 'L', 0, 5, 331),
(57539, '小王子SC7081B', NULL, 4798, 0, NULL, 'L', 0, 5, 330),
(57538, '都市贝贝SC7081A', NULL, 4798, 0, NULL, 'L', 0, 5, 329),
(57537, '0.8 快乐王子 手动', NULL, 4797, 0, NULL, 'L', 0, 5, 107672),
(57536, '0.8 小王子 手动', NULL, 4797, 0, NULL, 'L', 0, 5, 107649),
(57535, '0.8 都市贝贝 手动', NULL, 4797, 0, NULL, 'L', 0, 5, 107648),
(57534, '0.8 标准型 手动', NULL, 4797, 0, NULL, 'L', 0, 5, 107647),
(57533, '大王子SC7080F', NULL, 4797, 0, NULL, 'L', 0, 5, 6085),
(57532, '标准 型', NULL, 4797, 0, NULL, 'L', 0, 5, 328),
(57531, '0.8 标准型 手动', NULL, 4796, 0, NULL, 'L', 0, 5, 107673),
(57530, '0.8 快乐王子 手动', NULL, 4796, 0, NULL, 'L', 0, 5, 107653),
(57529, '0.8 小王子 手动', NULL, 4796, 0, NULL, 'L', 0, 5, 107652),
(57528, '0.8 都市贝贝 手动', NULL, 4796, 0, NULL, 'L', 0, 5, 107651),
(57527, '0.8 标准型 手动', NULL, 4795, 0, NULL, 'L', 0, 5, 107650),
(57526, '1.0 限量版 手动', NULL, 4794, 0, NULL, 'L', 0, 5, 108950),
(57525, '舒适型 MT', NULL, 4794, 0, NULL, 'L', 0, 5, 9181),
(57524, '豪华型 AT', NULL, 4794, 0, NULL, 'L', 0, 5, 8428),
(57523, '豪华型 MT', NULL, 4794, 0, NULL, 'L', 0, 5, 8427),
(57522, '炫酷版 AT', NULL, 4793, 0, NULL, 'L', 0, 5, 11556),
(57521, '炫酷版 MT', NULL, 4793, 0, NULL, 'L', 0, 5, 11555),
(57520, '炫酷版 AT', NULL, 4792, 0, NULL, 'L', 0, 5, 14082),
(57519, '炫酷版 MT', NULL, 4792, 0, NULL, 'L', 0, 5, 14080),
(57518, '1.0L 手动 实用型', NULL, 4791, 0, NULL, 'L', 0, 5, 101576),
(57517, '1.0L 手动 舒适型', NULL, 4791, 0, NULL, 'L', 0, 5, 100320),
(57516, '1.0L 手动 豪华型', NULL, 4791, 0, NULL, 'L', 0, 5, 100319),
(57515, '1.0L 自动 豪华型', NULL, 4791, 0, NULL, 'L', 0, 5, 100318),
(57514, '1.0L 自动 20周年限量版', NULL, 4790, 0, NULL, 'L', 0, 5, 104558),
(57513, '1.0L 手动 20周年限量版', NULL, 4790, 0, NULL, 'L', 0, 5, 104557),
(57512, '1.0L 自动 炫酷型', NULL, 4790, 0, NULL, 'L', 0, 5, 101943),
(57511, '1.0L 手动 炫酷型', NULL, 4790, 0, NULL, 'L', 0, 5, 101942),
(57510, '1.0L 自动 豪华型 影音版', NULL, 4790, 0, NULL, 'L', 0, 5, 101941),
(57509, '1.0L 手动 豪华型 影音版', NULL, 4790, 0, NULL, 'L', 0, 5, 101939),
(57508, '1.0L 自动 豪华型', NULL, 4790, 0, NULL, 'L', 0, 5, 101938),
(57507, '1.0L 手动 豪华型', NULL, 4790, 0, NULL, 'L', 0, 5, 101937),
(57506, '1.0L 手动 舒适型', NULL, 4790, 0, NULL, 'L', 0, 5, 101936),
(57505, '1.0L 手动 实用型', NULL, 4790, 0, NULL, 'L', 0, 5, 101933),
(57504, '1.4L 手动 ES精英型', NULL, 4789, 0, NULL, 'L', 0, 5, 15366),
(57503, '1.4L 手动 STD豪华型', NULL, 4789, 0, NULL, 'L', 0, 5, 15360),
(57502, '1.4L 手动 DLX尊贵型', NULL, 4789, 0, NULL, 'L', 0, 5, 14483),
(57501, '1.4 手动 精英型', NULL, 4788, 0, NULL, 'L', 0, 5, 106993),
(57500, '1.4L VVT 手动 豪华型', NULL, 4788, 0, NULL, 'L', 0, 5, 101864),
(57499, '1.4L VVT 手动 尊贵型', NULL, 4788, 0, NULL, 'L', 0, 5, 101863),
(57498, '1.4L VVT 手动 ES精英型', NULL, 4787, 0, NULL, 'L', 0, 5, 106458),
(57497, 'DLX 1.6 自动 特别型', NULL, 4786, 0, NULL, 'L', 0, 5, 108717),
(57496, 'DLX 1.6 手动 特别型', NULL, 4786, 0, NULL, 'L', 0, 5, 108645),
(57495, 'EC 手动经济型', NULL, 4786, 0, NULL, 'L', 0, 5, 9569),
(57494, 'DLX 自动豪华型', NULL, 4786, 0, NULL, 'L', 0, 5, 9429),
(57493, 'DLX 手动豪华型', NULL, 4786, 0, NULL, 'L', 0, 5, 9428),
(57492, 'STD 自动标准型', NULL, 4786, 0, NULL, 'L', 0, 5, 5334),
(57491, 'STD 手动标准型', NULL, 4786, 0, NULL, 'L', 0, 5, 5332),
(57490, 'EC 1.6 手动 实用型', NULL, 4785, 0, NULL, 'L', 0, 5, 108718),
(57489, 'DLX 1.6 自动 特别型', NULL, 4784, 0, NULL, 'L', 0, 5, 108646),
(57488, 'CH7160EC手动实用型', NULL, 4784, 0, NULL, 'L', 0, 5, 254),
(57487, '三厢豪华型自动', NULL, 4784, 0, NULL, 'L', 0, 5, 248),
(57486, '三厢标准型自动', NULL, 4784, 0, NULL, 'L', 0, 5, 247),
(57485, '三厢豪华型手动', NULL, 4784, 0, NULL, 'L', 0, 5, 246),
(57484, '三厢标准型手动', NULL, 4784, 0, NULL, 'L', 0, 5, 245),
(57483, 'EC 1.6 自动 实用型', NULL, 4783, 0, NULL, 'L', 0, 5, 106994),
(57482, 'VVT CH7161AC DLX自动豪华型', NULL, 4783, 0, NULL, 'L', 0, 5, 5330),
(57481, '自动档 豪华型', NULL, 4783, 0, NULL, 'L', 0, 5, 5187),
(57480, '自动档 标准型', NULL, 4783, 0, NULL, 'L', 0, 5, 5186),
(57479, '手动档 豪华型', NULL, 4783, 0, NULL, 'L', 0, 5, 5185),
(57478, '手动档 标准型', NULL, 4783, 0, NULL, 'L', 0, 5, 5184),
(57477, '手动档 实用型', NULL, 4783, 0, NULL, 'L', 0, 5, 5183),
(57476, 'a+ 1.4L 手动 豪华II型', NULL, 4782, 0, NULL, 'L', 0, 5, 13500),
(57475, 'a+ 1.4L 手动 豪华I型', NULL, 4782, 0, NULL, 'L', 0, 5, 12210),
(57474, 'a+ 1.4L 手动 标准型', NULL, 4782, 0, NULL, 'L', 0, 5, 12209),
(57473, 'a+ 1.4L 手动 三厢 豪华Ⅱ型', NULL, 4781, 0, NULL, 'L', 0, 5, 13922),
(57472, 'a+ 1.4L 手动 三厢 豪华Ⅰ型', NULL, 4781, 0, NULL, 'L', 0, 5, 13920),
(57471, 'a+ 1.4L 手动 三厢 标准型', NULL, 4781, 0, NULL, 'L', 0, 5, 13918),
(57470, '1.6L 自动 三厢 豪华型', NULL, 4781, 0, NULL, 'L', 0, 5, 13916),
(57469, '1.6L 自动 三厢 标准型', NULL, 4781, 0, NULL, 'L', 0, 5, 13915),
(57468, '1.6L 手动 三厢 豪华型', NULL, 4781, 0, NULL, 'L', 0, 5, 13914),
(57467, '1.6L 手动 三厢 标准型', NULL, 4781, 0, NULL, 'L', 0, 5, 13913),
(57466, '1.6L 手动 三厢 实用型', NULL, 4781, 0, NULL, 'L', 0, 5, 13912),
(57465, '1.4LVVT 手动 豪华III型', NULL, 4780, 0, NULL, 'L', 0, 5, 104573),
(57464, '1.4LVVT 手动 豪华I型', NULL, 4780, 0, NULL, 'L', 0, 5, 104572),
(57463, '1.4LVVT 手动 舒适I型', NULL, 4780, 0, NULL, 'L', 0, 5, 104571),
(57462, '1.4L 手动 豪华I型', NULL, 4780, 0, NULL, 'L', 0, 5, 104570),
(57461, '1.4L 手动 舒适I型', NULL, 4780, 0, NULL, 'L', 0, 5, 104569),
(57460, '1.4L 手动 经济型', NULL, 4780, 0, NULL, 'L', 0, 5, 104568),
(57459, '1.6L 自动 豪华型', NULL, 4780, 0, NULL, 'L', 0, 5, 101901),
(57458, '1.6L 自动 标准型', NULL, 4780, 0, NULL, 'L', 0, 5, 101900),
(57457, '1.6L 自动 特别版', NULL, 4780, 0, NULL, 'L', 0, 5, 101899),
(57456, '1.6L 手动 豪华型', NULL, 4780, 0, NULL, 'L', 0, 5, 101898),
(57455, '1.6L 手动 标准型', NULL, 4780, 0, NULL, 'L', 0, 5, 101895),
(57454, 'STD 1.6 自动 标准型', NULL, 4779, 0, NULL, 'L', 0, 5, 106991),
(57453, 'EC 1.6 手动 实用型', NULL, 4779, 0, NULL, 'L', 0, 5, 106990),
(57452, 'DLX 1.6 手动 豪华型', NULL, 4779, 0, NULL, 'L', 0, 5, 106989),
(57451, 'DLX 1.6 自动 豪华型', NULL, 4779, 0, NULL, 'L', 0, 5, 106988),
(57450, 'DLX 1.6 自动 豪华型', NULL, 4778, 0, NULL, 'L', 0, 5, 106992),
(57449, 'CH7161EC', NULL, 4778, 0, NULL, 'L', 0, 5, 253),
(57448, '两厢标准型手动', NULL, 4778, 0, NULL, 'L', 0, 5, 252),
(57447, '两厢豪华型手动', NULL, 4778, 0, NULL, 'L', 0, 5, 251),
(57446, '两厢标准型自动', NULL, 4778, 0, NULL, 'L', 0, 5, 250),
(57445, '两厢豪华型自动', NULL, 4778, 0, NULL, 'L', 0, 5, 249),
(57444, 'EC 1.6 自动 实用型', NULL, 4777, 0, NULL, 'L', 0, 5, 106880),
(57443, 'EC 自动档 实用型', NULL, 4777, 0, NULL, 'L', 0, 5, 10304),
(57442, 'VVT两厢自动豪华型', NULL, 4777, 0, NULL, 'L', 0, 5, 9565),
(57441, 'VVT两厢手动豪华型', NULL, 4777, 0, NULL, 'L', 0, 5, 9564),
(57440, 'STD 手动挡 舒适型', NULL, 4777, 0, NULL, 'L', 0, 5, 5345),
(57439, 'STD 自动挡 舒适型', NULL, 4777, 0, NULL, 'L', 0, 5, 5344),
(57438, 'DLX 自动挡 豪华型', NULL, 4777, 0, NULL, 'L', 0, 5, 5192),
(57437, 'VVT两厢自动标准型', NULL, 4777, 0, NULL, 'L', 0, 5, 5191),
(57436, 'DLX 手动挡 豪华型', NULL, 4777, 0, NULL, 'L', 0, 5, 5190),
(57435, 'VVT两厢手动标准型', NULL, 4777, 0, NULL, 'L', 0, 5, 5189),
(57434, 'EC 手动挡 实用型', NULL, 4777, 0, NULL, 'L', 0, 5, 5188),
(57433, 'a+ 1.4L 手动 豪华II型', NULL, 4776, 0, NULL, 'L', 0, 5, 12217),
(57432, 'a+ 1.4L 手动 豪华I型', NULL, 4776, 0, NULL, 'L', 0, 5, 12208),
(57431, 'a+ 1.4L 手动 标准型', NULL, 4776, 0, NULL, 'L', 0, 5, 12207),
(57430, 'a+ 1.4L 手动 两厢 豪华Ⅱ型', NULL, 4775, 0, NULL, 'L', 0, 5, 13921),
(57429, 'a+ 1.4L 手动 两厢 豪华Ⅰ型', NULL, 4775, 0, NULL, 'L', 0, 5, 13919),
(57428, 'a+ 1.4L 手动 两厢 标准型', NULL, 4775, 0, NULL, 'L', 0, 5, 13917),
(57427, '1.6L 自动 两厢 豪华型', NULL, 4775, 0, NULL, 'L', 0, 5, 13911),
(57426, '1.6L 自动 两厢 标准型', NULL, 4775, 0, NULL, 'L', 0, 5, 13910),
(57425, '1.6L 手动 两厢 豪华型', NULL, 4775, 0, NULL, 'L', 0, 5, 13909),
(57424, '1.6L 手动 两厢 标准型', NULL, 4775, 0, NULL, 'L', 0, 5, 13908),
(57423, '1.6L 手动 两厢 实用型', NULL, 4775, 0, NULL, 'L', 0, 5, 13907),
(57422, '1.4L 手动 经济型', NULL, 4774, 0, NULL, 'L', 0, 5, 104579),
(57421, '1.4L VVT 手动 豪华IV型', NULL, 4774, 0, NULL, 'L', 0, 5, 101862),
(57420, '1.4L VVT 手动 豪华II型', NULL, 4774, 0, NULL, 'L', 0, 5, 101861),
(57419, '1.4L VVT 手动 舒适II型', NULL, 4774, 0, NULL, 'L', 0, 5, 101860),
(57418, '1.4L a+ 手动 标准型2', NULL, 4773, 0, NULL, 'L', 0, 5, 106457),
(57417, '1.4L a+ 手动 标准型A', NULL, 4773, 0, NULL, 'L', 0, 5, 106456),
(57416, '1.4L a+ 手动 豪华型A', NULL, 4773, 0, NULL, 'L', 0, 5, 106453),
(57415, '1.4L 手动 幸福版', NULL, 4772, 0, NULL, 'L', 0, 5, 106372),
(57414, '1.5L 自动 理想型', NULL, 4772, 0, NULL, 'L', 0, 5, 106166),
(57413, '1.5L 自动 畅想型', NULL, 4772, 0, NULL, 'L', 0, 5, 106164),
(57412, '1.4L 手动 梦想型', NULL, 4772, 0, NULL, 'L', 0, 5, 106162),
(57411, '1.4L 手动 畅想型', NULL, 4772, 0, NULL, 'L', 0, 5, 106102),
(57410, '1.4L 手动 畅想型', NULL, 4771, 0, NULL, 'L', 0, 5, 110727),
(57409, '1.5L 自动 理想型', NULL, 4771, 0, NULL, 'L', 0, 5, 106160),
(57408, '1.5L 自动 畅想型', NULL, 4771, 0, NULL, 'L', 0, 5, 106159),
(57407, '1.4L 手动 理想型', NULL, 4771, 0, NULL, 'L', 0, 5, 106104),
(57406, '1.4 手动 四驱', NULL, 4770, 0, NULL, 'L', 0, 5, 108643),
(57405, '1.4 手动 两驱', NULL, 4770, 0, NULL, 'L', 0, 5, 108642),
(57404, '1.4 自动', NULL, 4770, 0, NULL, 'L', 0, 5, 108641),
(57403, '1.4 手动 四驱 标准II型', NULL, 4769, 0, NULL, 'L', 0, 5, 106983),
(57402, '1.4 手动 四驱 标准I型', NULL, 4769, 0, NULL, 'L', 0, 5, 106982),
(57401, '1.4 手动 两驱 经济型', NULL, 4769, 0, NULL, 'L', 0, 5, 106981),
(57400, '1.4 手动 两驱 豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 106980),
(57399, '1.4 手动 两驱 超豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 106979),
(57398, '1.4 手动 两驱 标准II型', NULL, 4769, 0, NULL, 'L', 0, 5, 106978),
(57397, '1.4 手动 两驱 标准I型', NULL, 4769, 0, NULL, 'L', 0, 5, 106977),
(57396, '1.4 自动 两驱 超豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 106976),
(57395, 'STD2 手动四驱 标准版2', NULL, 4769, 0, NULL, 'L', 0, 5, 5665),
(57394, 'STD2 手动两驱 标准型2', NULL, 4769, 0, NULL, 'L', 0, 5, 5664),
(57393, 'STD1 手动四驱 标准版1', NULL, 4769, 0, NULL, 'L', 0, 5, 265),
(57392, 'SDLX 自动两驱 超豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 264),
(57391, 'DLX 自动两驱 豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 263),
(57390, 'SDLX 手动两驱 超豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 262),
(57389, 'DLX 手动两驱 豪华型', NULL, 4769, 0, NULL, 'L', 0, 5, 261),
(57388, 'STD1 手动两驱 标准型1', NULL, 4769, 0, NULL, 'L', 0, 5, 260),
(57387, '1.4 手动经济型', NULL, 4769, 0, NULL, 'L', 0, 5, 259),
(57386, 'STD 手动四驱 标准型', NULL, 4768, 0, NULL, 'L', 0, 5, 10303),
(57385, 'STD 手动两驱 标准型', NULL, 4768, 0, NULL, 'L', 0, 5, 10302),
(57384, '1.4 手动 四驱', NULL, 4767, 0, NULL, 'L', 0, 5, 108644),
(57383, '1.4 手动 阳光版 舒适型', NULL, 4767, 0, NULL, 'L', 0, 5, 106985),
(57382, '1.4 手动 阳光版 标准型', NULL, 4767, 0, NULL, 'L', 0, 5, 106984),
(57381, '手动两驱 CH6391C2阳光版 舒适型', NULL, 4767, 0, NULL, 'L', 0, 5, 9539),
(57380, '手动两驱 CH6391C2阳光版 标准型', NULL, 4767, 0, NULL, 'L', 0, 5, 9538),
(57379, '手动两驱 CH6391C4阳光版 舒适型', NULL, 4767, 0, NULL, 'L', 0, 5, 8689),
(57378, '手动两驱 CH6391C4阳光版 标准型', NULL, 4767, 0, NULL, 'L', 0, 5, 5662),
(57377, '1.2 手动 阳光版 舒适型', NULL, 4766, 0, NULL, 'L', 0, 5, 106987),
(57376, '1.2 手动 阳光版 标准型', NULL, 4766, 0, NULL, 'L', 0, 5, 106986),
(57375, '阳光版 手动 两驱 舒适型(STD) 国Ⅳ CH6392C1 ', NULL, 4766, 0, NULL, 'L', 0, 5, 11615),
(57374, '阳光版 手动 两驱 舒适型(STD) 国Ⅲ CH6392C ', NULL, 4766, 0, NULL, 'L', 0, 5, 11614),
(57373, '阳光版 手动 两驱 标准型(ES) 国Ⅳ CH6392C1 ', NULL, 4766, 0, NULL, 'L', 0, 5, 11613),
(57372, '阳光版 手动 两驱 标准型(ES) 国Ⅲ CH6392C ', NULL, 4766, 0, NULL, 'L', 0, 5, 11612),
(57371, '1.2L 手动 阳光版 舒适型', NULL, 4765, 0, NULL, 'L', 0, 5, 13929),
(57370, '1.2L 手动 阳光版 标准型', NULL, 4765, 0, NULL, 'L', 0, 5, 13928),
(57369, '1.4L 手动 阳光版 舒适型', NULL, 4765, 0, NULL, 'L', 0, 5, 13927),
(57368, '1.4L 手动 阳光版 标准型', NULL, 4765, 0, NULL, 'L', 0, 5, 13926),
(57367, '1.4L 手动 巡航版', NULL, 4764, 0, NULL, 'L', 0, 5, 102739),
(57366, '1.4L 手动 尊贵型', NULL, 4764, 0, NULL, 'L', 0, 5, 102303),
(57365, '1.4L 手动 豪华型', NULL, 4764, 0, NULL, 'L', 0, 5, 102301),
(57364, '1.4L 手动 巡航版', NULL, 4763, 0, NULL, 'L', 0, 5, 106451),
(57363, '1.4L 手动 豪华版', NULL, 4763, 0, NULL, 'L', 0, 5, 106450),
(57362, 'CH6321', NULL, 4762, 0, NULL, 'L', 0, 5, 9099),
(57361, '5S 1.0 手动 豪华版', NULL, 4761, 0, NULL, 'L', 0, 5, 108709),
(57360, '4S 1.0 手动 舒适版', NULL, 4761, 0, NULL, 'L', 0, 5, 108708),
(57359, '3S 1.0 手动 标准版', NULL, 4761, 0, NULL, 'L', 0, 5, 108707),
(57358, '2S 1.0 手动 经济版', NULL, 4761, 0, NULL, 'L', 0, 5, 108706),
(57357, 'CH6350', NULL, 4761, 0, NULL, 'L', 0, 5, 6074),
(57356, '5S 1.2 手动 豪华版', NULL, 4760, 0, NULL, 'L', 0, 5, 108629),
(57355, '4S 1.2 手动 舒适版', NULL, 4760, 0, NULL, 'L', 0, 5, 108628),
(57354, '3S 1.2 手动 标准版', NULL, 4760, 0, NULL, 'L', 0, 5, 108627),
(57353, '2S 1.2 手动 经济版', NULL, 4760, 0, NULL, 'L', 0, 5, 108626),
(57352, '5S 1.0 手动 ', NULL, 4759, 0, NULL, 'L', 0, 5, 108633),
(57351, '4S 1.0 手动 ', NULL, 4759, 0, NULL, 'L', 0, 5, 108632),
(57350, '3S 1.0 手动 ', NULL, 4759, 0, NULL, 'L', 0, 5, 108631),
(57349, '2S 1.0 手动 ', NULL, 4759, 0, NULL, 'L', 0, 5, 108630),
(57348, '5S 1.0 手动 豪华版', NULL, 4759, 0, NULL, 'L', 0, 5, 108624),
(57347, '4S 1.0 手动 舒适版', NULL, 4759, 0, NULL, 'L', 0, 5, 108623),
(57346, '3S 1.0 手动 标准版', NULL, 4759, 0, NULL, 'L', 0, 5, 108622),
(57345, '2S 1.0 手动 经济版', NULL, 4759, 0, NULL, 'L', 0, 5, 106874),
(57344, 'CH7110STD标准型', NULL, 4759, 0, NULL, 'L', 0, 5, 195),
(57343, 'CH7100A经济型', NULL, 4759, 0, NULL, 'L', 0, 5, 194),
(57342, '假日风情 1.2 手动 标准版', NULL, 4758, 0, NULL, 'L', 0, 5, 108637),
(57341, '5S 1.1 手动 豪华版', NULL, 4758, 0, NULL, 'L', 0, 5, 108636),
(57340, '4S 1.1 手动 舒适版', NULL, 4758, 0, NULL, 'L', 0, 5, 108635),
(57339, '2S 1.1 手动 经济版', NULL, 4758, 0, NULL, 'L', 0, 5, 108634),
(57338, '3S 1.1 手动 标准版', NULL, 4758, 0, NULL, 'L', 0, 5, 106875),
(57337, '3S 1.0 手动 标准版', NULL, 4757, 0, NULL, 'L', 0, 5, 108710),
(57336, 'STD 1.2 手动 标准版', NULL, 4757, 0, NULL, 'L', 0, 5, 108638),
(57335, 'CH7120DLXII豪华型II', NULL, 4757, 0, NULL, 'L', 0, 5, 198),
(57334, 'CH7120DLX豪华型I', NULL, 4757, 0, NULL, 'L', 0, 5, 197),
(57333, 'CH7120STD标准型', NULL, 4757, 0, NULL, 'L', 0, 5, 196),
(57332, '5S 1.0 手动 豪华版', NULL, 4756, 0, NULL, 'L', 0, 5, 108714),
(57331, '4S 1.0 手动 实用版', NULL, 4756, 0, NULL, 'L', 0, 5, 108713),
(57330, '3S 1.0 手动 简约版', NULL, 4756, 0, NULL, 'L', 0, 5, 108712),
(57329, '2S 1.0 手动 经济版', NULL, 4756, 0, NULL, 'L', 0, 5, 108711),
(57328, 'DLX 1.4 手动 豪华版', NULL, 4756, 0, NULL, 'L', 0, 5, 106879),
(57327, 'EC 1.4 手动 经济版', NULL, 4756, 0, NULL, 'L', 0, 5, 106878),
(57326, 'ES 1.4 手动 实用版', NULL, 4756, 0, NULL, 'L', 0, 5, 106877),
(57325, 'STD 1.4 手动 标准版', NULL, 4756, 0, NULL, 'L', 0, 5, 106876),
(57324, '1.4L系列 CH7140 实用', NULL, 4756, 0, NULL, 'L', 0, 5, 205),
(57323, '1.4L系列 CH7140 经济', NULL, 4756, 0, NULL, 'L', 0, 5, 204),
(57322, '1.4L系列 CH7140 豪华', NULL, 4756, 0, NULL, 'L', 0, 5, 203),
(57321, '1.4L系列 CH7140 标准', NULL, 4756, 0, NULL, 'L', 0, 5, 202),
(57320, '1.0L系列 CH7100A1 ES', NULL, 4756, 0, NULL, 'L', 0, 5, 201),
(57319, '1.0L系列 CH7100A1 EC2', NULL, 4756, 0, NULL, 'L', 0, 5, 200),
(57318, 'K12A-EC', NULL, 4756, 0, NULL, 'L', 0, 5, 199),
(57317, '限量版 1.4L', NULL, 4755, 0, NULL, 'L', 0, 5, 9100),
(57316, '3S 1.0 手动 简约版', NULL, 4754, 0, NULL, 'L', 0, 5, 108640),
(57315, '4S 1.0 手动 实用版', NULL, 4754, 0, NULL, 'L', 0, 5, 108639),
(57314, '5S 1.0 手动 豪华版', NULL, 4754, 0, NULL, 'L', 0, 5, 108625),
(57313, '2S 1.0 手动 经济版', NULL, 4754, 0, NULL, 'L', 0, 5, 108621),
(57312, '1.0 手动 领航版', NULL, 4754, 0, NULL, 'L', 0, 5, 108620),
(57311, 'STD 1.4 手动 标准版', NULL, 4754, 0, NULL, 'L', 0, 5, 106972),
(57310, 'ES 1.4 手动 实用版', NULL, 4754, 0, NULL, 'L', 0, 5, 106971),
(57309, 'EC 1.4 手动 经济版', NULL, 4754, 0, NULL, 'L', 0, 5, 106970),
(57308, 'DLX 1.4 手动 豪华版', NULL, 4754, 0, NULL, 'L', 0, 5, 106969),
(57307, 'CH7100A2 实用型 国Ⅲ', NULL, 4754, 0, NULL, 'L', 0, 5, 8688),
(57306, 'CH7100A2 经济型 国Ⅲ', NULL, 4754, 0, NULL, 'L', 0, 5, 8687),
(57305, '1.4L系列 CH7140A1 标准', NULL, 4754, 0, NULL, 'L', 0, 5, 8686),
(57304, '竞驭 1.4 手自一体', NULL, 4753, 0, NULL, 'L', 0, 5, 108716),
(57303, '1.0 手动 领航版', NULL, 4753, 0, NULL, 'L', 0, 5, 108715),
(57302, '1.4L CH7140A1 STD2 超值版', NULL, 4753, 0, NULL, 'L', 0, 5, 9568),
(57301, '1.4L CH7140A1 STD1 舒逸版', NULL, 4753, 0, NULL, 'L', 0, 5, 9567),
(57300, '1.0L系列 CH7100A2 ES1 限量版', NULL, 4753, 0, NULL, 'L', 0, 5, 9566),
(57299, '1.4L CH7140A1 标准型', NULL, 4753, 0, NULL, 'L', 0, 5, 9563),
(57298, '1.0L系列 CH7100A2 EC2', NULL, 4753, 0, NULL, 'L', 0, 5, 9205),
(57297, '1.0L系列 CH7100A2 ES', NULL, 4753, 0, NULL, 'L', 0, 5, 9204),
(57296, '1.4L CH7140A1 经济型', NULL, 4753, 0, NULL, 'L', 0, 5, 9201),
(57295, '1.4L CH7140A1 实用型', NULL, 4753, 0, NULL, 'L', 0, 5, 9200),
(57294, '1.4L CH7140A1 豪华型', NULL, 4753, 0, NULL, 'L', 0, 5, 9199),
(57293, '1.4L系列 CH7140A 标准', NULL, 4753, 0, NULL, 'L', 0, 5, 8685),
(57292, '1.4L系列 CH7140A 实用', NULL, 4753, 0, NULL, 'L', 0, 5, 8675),
(57291, '1.4L系列 CH7140A 豪华', NULL, 4753, 0, NULL, 'L', 0, 5, 7195),
(57290, 'CH7140D1 手自一体(AMT) 标准型', NULL, 4753, 0, NULL, 'L', 0, 5, 4103),
(57289, 'CH7140D 手自一体(AMT) 标准型', NULL, 4753, 0, NULL, 'L', 0, 5, 4102),
(57288, '1.4L系列 CH7140A 经济', NULL, 4753, 0, NULL, 'L', 0, 5, 4101),
(57287, '1.4 手动 e+ ', NULL, 4752, 0, NULL, 'L', 0, 5, 106975),
(57286, '1.4 手自一体 e+ ', NULL, 4752, 0, NULL, 'L', 0, 5, 106974),
(57285, '1.0 手动 领航版', NULL, 4752, 0, NULL, 'L', 0, 5, 106973),
(57284, 'e+ CH7140C1', NULL, 4752, 0, NULL, 'L', 0, 5, 12424),
(57283, 'e+ CH7140C', NULL, 4752, 0, NULL, 'L', 0, 5, 12423),
(57282, 'e+ CH7140B1', NULL, 4752, 0, NULL, 'L', 0, 5, 12422),
(57281, 'e+ CH7140B', NULL, 4752, 0, NULL, 'L', 0, 5, 12421),
(57280, 'e+ 标准型', NULL, 4752, 0, NULL, 'L', 0, 5, 10942),
(57279, 'e+ 手自一体版', NULL, 4751, 0, NULL, 'L', 0, 5, 13906),
(57278, 'e+ 手动 豪华型', NULL, 4751, 0, NULL, 'L', 0, 5, 13905),
(57277, 'e+ 手动 标准2型', NULL, 4751, 0, NULL, 'L', 0, 5, 13904),
(57276, 'e+ 手动 标准1型', NULL, 4751, 0, NULL, 'L', 0, 5, 13903),
(57275, 'e+ 手动 实用型', NULL, 4751, 0, NULL, 'L', 0, 5, 13902),
(57274, '1.4L 自动 全能版', NULL, 4751, 0, NULL, 'L', 0, 5, 13901),
(57273, '1.4L 手动 标准2型', NULL, 4751, 0, NULL, 'L', 0, 5, 13900),
(57272, '1.4L 手动 标准1型', NULL, 4751, 0, NULL, 'L', 0, 5, 13899),
(57271, '1.0L 手动', NULL, 4751, 0, NULL, 'L', 0, 5, 13898),
(57270, '1.4L e+ VVT 手动 标准型', NULL, 4750, 0, NULL, 'L', 0, 5, 101858),
(57269, '1.0L 手动 创业版 实用型', NULL, 4750, 0, NULL, 'L', 0, 5, 100411),
(57268, '1.0L 手动 创业版 超越型', NULL, 4750, 0, NULL, 'L', 0, 5, 100410),
(57267, '1.4L 手动 全能版 进取型', NULL, 4750, 0, NULL, 'L', 0, 5, 100408),
(57266, '1.4L VVT 手动 全能版 适用型', NULL, 4750, 0, NULL, 'L', 0, 5, 100407),
(57265, '1.4L VVT 手动 全能版 标准型', NULL, 4750, 0, NULL, 'L', 0, 5, 100406),
(57264, '1.4L VVT 手动 全能版 豪华型', NULL, 4750, 0, NULL, 'L', 0, 5, 100405),
(57263, '1.4L 手动 冠军版 适用型', NULL, 4750, 0, NULL, 'L', 0, 5, 100404),
(57262, '1.4L 手自一体 全能版', NULL, 4750, 0, NULL, 'L', 0, 5, 100403),
(57261, '1.4L e+ 手动 标准型', NULL, 4750, 0, NULL, 'L', 0, 5, 100400),
(57260, '1.4L e+ 手动 进取型', NULL, 4750, 0, NULL, 'L', 0, 5, 100399),
(57259, '1.4L e+ 手动 尊享型', NULL, 4750, 0, NULL, 'L', 0, 5, 100398),
(57258, '1.4L e+ 手动 豪华型', NULL, 4750, 0, NULL, 'L', 0, 5, 100397),
(57257, '1.4L e+ VVT 手动 进取型', NULL, 4750, 0, NULL, 'L', 0, 5, 100396),
(57256, '1.4L e+ VVT 手动 豪华型', NULL, 4750, 0, NULL, 'L', 0, 5, 100395),
(57255, '1.4L 手动 全能升级版 标准型', NULL, 4749, 0, NULL, 'L', 0, 5, 106448),
(57254, '1.4L 手动 全能版 实用型', NULL, 4749, 0, NULL, 'L', 0, 5, 106447),
(57253, '1.0L 手动 创业板 舒适型', NULL, 4749, 0, NULL, 'L', 0, 5, 106446),
(57252, '1.0L 手动 创业板 实用3型', NULL, 4749, 0, NULL, 'L', 0, 5, 106445),
(57251, '1.0L 手动 创业板 经济型', NULL, 4749, 0, NULL, 'L', 0, 5, 106444),
(57250, '3.2L 手动 四驱 舒适型 柴油 LT1030MCC1', NULL, 4748, 0, NULL, 'K', 0, 5, 110412),
(57249, '3.2L 手动 两驱 舒适型 柴油 LT1030MCC0', NULL, 4748, 0, NULL, 'K', 0, 5, 110411),
(57248, '2.4L 手动 四驱 舒适型 汽油 LT1030MCQ1', NULL, 4748, 0, NULL, 'K', 0, 5, 110410),
(57247, '2.4L 手动 两驱 舒适型 汽油 LT1030MCQ0', NULL, 4748, 0, NULL, 'K', 0, 5, 110407),
(57246, '2.4L 手动 两驱 至尊型', NULL, 4747, 0, NULL, 'K', 0, 5, 110417),
(57245, '2.4L 手动 两驱 豪华型', NULL, 4747, 0, NULL, 'K', 0, 5, 110416),
(57244, '2.0L 手动 两驱 豪华型', NULL, 4747, 0, NULL, 'K', 0, 5, 110415),
(57243, '2.0L 手动 两驱 至尊型', NULL, 4747, 0, NULL, 'K', 0, 5, 110414),
(57242, 'GT版', NULL, 4746, 0, NULL, 'K', 0, 5, 110121),
(57241, 'CS60', NULL, 4745, 0, NULL, 'K', 0, 5, 103085),
(57240, 'CS60Royale', NULL, 4745, 0, NULL, 'K', 0, 5, 103082),
(57239, 'CGL45', NULL, 4744, 0, NULL, 'K', 0, 5, 103086),
(57238, 'CGL45Royale', NULL, 4744, 0, NULL, 'K', 0, 5, 103084),
(57237, 'C25LE', NULL, 4743, 0, NULL, 'K', 0, 5, 103080),
(57236, '1.1—MT 豪华型', NULL, 4742, 0, NULL, 'K', 0, 5, 9308),
(57235, '1.1—MT 舒适型', NULL, 4742, 0, NULL, 'K', 0, 5, 9307),
(57234, '1.1—MT 标准Ⅰ型', NULL, 4742, 0, NULL, 'K', 0, 5, 9306),
(57233, '1.1—MT 标准型', NULL, 4742, 0, NULL, 'K', 0, 5, 9305),
(57232, '1.1—MT 基本Ⅰ型', NULL, 4742, 0, NULL, 'K', 0, 5, 9304),
(57231, '1.1—MT 基本型', NULL, 4742, 0, NULL, 'K', 0, 5, 9303),
(57230, '1.0—MT 豪华型', NULL, 4742, 0, NULL, 'K', 0, 5, 9302),
(57229, '1.0—MT 舒适型', NULL, 4742, 0, NULL, 'K', 0, 5, 9301),
(57228, '1.0—MT 标准Ⅰ型', NULL, 4742, 0, NULL, 'K', 0, 5, 9300),
(57227, '1.0—MT 标准型', NULL, 4742, 0, NULL, 'K', 0, 5, 9299),
(57226, '1.0—MT 基本Ⅰ型', NULL, 4742, 0, NULL, 'K', 0, 5, 9298),
(57225, '1.0—MT 基本型', NULL, 4742, 0, NULL, 'K', 0, 5, 9297),
(57224, '1.0D MT 豪华型 柴油版', NULL, 4741, 0, NULL, 'K', 0, 5, 14016),
(57223, '1.0D MT 舒适型 柴油版', NULL, 4741, 0, NULL, 'K', 0, 5, 14015),
(57222, '1.0D MT 标准型 柴油版', NULL, 4741, 0, NULL, 'K', 0, 5, 14014),
(57221, '1.0D MT 基本型 柴油版', NULL, 4741, 0, NULL, 'K', 0, 5, 14013),
(57220, '开瑞翼展车 1.1L 手动 舒适型', NULL, 4740, 0, NULL, 'K', 0, 5, 102087),
(57219, '开瑞翼展车 1.1L 手动 标准型', NULL, 4740, 0, NULL, 'K', 0, 5, 102086),
(57218, '开瑞翼展车 1.1L 手动 基本型', NULL, 4740, 0, NULL, 'K', 0, 5, 102085),
(57217, '1.2L 手动 加长版 豪华型', NULL, 4740, 0, NULL, 'K', 0, 5, 100142),
(57216, '1.2L 手动 加长版 舒适型', NULL, 4740, 0, NULL, 'K', 0, 5, 100141),
(57215, '1.2L 手动 加长版 标准型', NULL, 4740, 0, NULL, 'K', 0, 5, 100140),
(57214, '2代 1.2L 手动 基本型', NULL, 4739, 0, NULL, 'K', 0, 5, 111220),
(57213, '2代 1.2L 手动 碟刹 标准型', NULL, 4739, 0, NULL, 'K', 0, 5, 111219),
(57212, '2代 1.2L 手动 舒适型', NULL, 4739, 0, NULL, 'K', 0, 5, 111218),
(57211, '2代 1.0L 手动  碟刹 标准型', NULL, 4739, 0, NULL, 'K', 0, 5, 111217),
(57210, '2代 1.0L 手动 基本型', NULL, 4739, 0, NULL, 'K', 0, 5, 111216),
(57209, '2代 1.2L 手动 豪华型', NULL, 4739, 0, NULL, 'K', 0, 5, 103316),
(57208, '2代 1.0L 手动 舒适型', NULL, 4739, 0, NULL, 'K', 0, 5, 103315),
(57207, '2代 1.0L 手动 标准型', NULL, 4739, 0, NULL, 'K', 0, 5, 103314),
(57206, '2代 1.0L 手动 特惠型', NULL, 4739, 0, NULL, 'K', 0, 5, 103311),
(57205, '1.5—MT 舒适型', NULL, 4738, 0, NULL, 'K', 0, 5, 9642),
(57204, '1.5—MT 标准型', NULL, 4738, 0, NULL, 'K', 0, 5, 9641),
(57203, '1.5—MT 基本型', NULL, 4738, 0, NULL, 'K', 0, 5, 9640),
(57202, '优翼 1.6—MT 舒适型', NULL, 4738, 0, NULL, 'K', 0, 5, 8463),
(57201, '优翼 1.6—MT 标准型', NULL, 4738, 0, NULL, 'K', 0, 5, 8462),
(57200, '优翼 1.6—MT 基本型', NULL, 4738, 0, NULL, 'K', 0, 5, 8461),
(57199, '1.2—MT 舒适型', NULL, 4737, 0, NULL, 'K', 0, 5, 9427),
(57198, '1.2—MT 标准型', NULL, 4737, 0, NULL, 'K', 0, 5, 9426),
(57197, '1.3—MT 豪华型', NULL, 4737, 0, NULL, 'K', 0, 5, 8901),
(57196, '1.3—MT 舒适型', NULL, 4737, 0, NULL, 'K', 0, 5, 8900),
(57195, '1.3—MT 标准型', NULL, 4737, 0, NULL, 'K', 0, 5, 8899),
(57194, '1.3L 手动 豪华型', NULL, 4736, 0, NULL, 'K', 0, 5, 101163),
(57193, '1.3L 手动 舒适型', NULL, 4736, 0, NULL, 'K', 0, 5, 101162),
(57192, '1.2L 手动 舒适型', NULL, 4736, 0, NULL, 'K', 0, 5, 101161),
(57191, '1.3L 手动 新标准型', NULL, 4736, 0, NULL, 'K', 0, 5, 14006),
(57190, '1.2L 手动 新标准型', NULL, 4736, 0, NULL, 'K', 0, 5, 14005),
(57189, '1.2L 手动 新实力型', NULL, 4736, 0, NULL, 'K', 0, 5, 14004),
(57188, '2代 1.5 手动 尊贵型', NULL, 4735, 0, NULL, 'K', 0, 5, 104615),
(57187, '2代 1.5 手动 豪华型', NULL, 4735, 0, NULL, 'K', 0, 5, 104614),
(57186, '2代 1.5 手动 舒适型', NULL, 4735, 0, NULL, 'K', 0, 5, 104613),
(57185, '2代 1.5 手动 标准型', NULL, 4735, 0, NULL, 'K', 0, 5, 104612),
(57184, '2代 1.5 手动 实力型', NULL, 4735, 0, NULL, 'K', 0, 5, 104610),
(57183, 'II代 1.1L MT 豪华型', NULL, 4734, 0, NULL, 'K', 0, 5, 12668),
(57182, 'II代 1.1L MT 标准型', NULL, 4734, 0, NULL, 'K', 0, 5, 12667),
(57181, 'II代 1.1L MT 舒适型', NULL, 4734, 0, NULL, 'K', 0, 5, 12666),
(57180, 'II代 1.1L MT 基本型', NULL, 4734, 0, NULL, 'K', 0, 5, 12665),
(57179, 'II代 1.0L MT 豪华型', NULL, 4734, 0, NULL, 'K', 0, 5, 12664),
(57178, 'II代 1.0L MT 舒适型', NULL, 4734, 0, NULL, 'K', 0, 5, 12663),
(57177, 'II代 1.0L MT 标准型', NULL, 4734, 0, NULL, 'K', 0, 5, 12662),
(57176, 'II代 1.0L MT 基本型', NULL, 4734, 0, NULL, 'K', 0, 5, 12661),
(57175, '1.1—MT 豪华型', NULL, 4734, 0, NULL, 'K', 0, 5, 10650),
(57174, '1.0—MT 豪华型', NULL, 4734, 0, NULL, 'K', 0, 5, 10649),
(57173, '1.1—MT 舒适型', NULL, 4734, 0, NULL, 'K', 0, 5, 10648),
(57172, '1.0—MT 舒适型', NULL, 4734, 0, NULL, 'K', 0, 5, 10647),
(57171, '1.1—MT 标准型', NULL, 4734, 0, NULL, 'K', 0, 5, 10646),
(57170, '1.0—MT 标准型', NULL, 4734, 0, NULL, 'K', 0, 5, 10645),
(57169, '1.1—MT 基本型', NULL, 4734, 0, NULL, 'K', 0, 5, 10644),
(57168, '1.0—MT 基本型', NULL, 4734, 0, NULL, 'K', 0, 5, 10643),
(57167, 'Ⅱ代 1.0L 手动 基本', NULL, 4733, 0, NULL, 'K', 0, 5, 101173),
(57166, 'Ⅱ代 1.0L 手动 标准', NULL, 4733, 0, NULL, 'K', 0, 5, 101172),
(57165, 'Ⅱ代 1.0L 手动 舒适', NULL, 4733, 0, NULL, 'K', 0, 5, 101171),
(57164, 'Ⅱ代 1.0L 手动 豪华', NULL, 4733, 0, NULL, 'K', 0, 5, 101169),
(57163, 'Ⅱ代 1.1L 手动 基本', NULL, 4733, 0, NULL, 'K', 0, 5, 101168),
(57162, 'Ⅱ代 1.1L 手动 标准', NULL, 4733, 0, NULL, 'K', 0, 5, 101167),
(57161, 'Ⅱ代 1.1L 手动 舒适', NULL, 4733, 0, NULL, 'K', 0, 5, 101166),
(57160, 'Ⅱ代 1.1L 手动 豪华', NULL, 4733, 0, NULL, 'K', 0, 5, 101165),
(57159, 'Ⅱ代 1.0L 手动 实力Ⅱ型', NULL, 4732, 0, NULL, 'K', 0, 5, 102126),
(57158, 'Ⅱ代 1.0L 手动 实力Ⅰ型', NULL, 4732, 0, NULL, 'K', 0, 5, 102125),
(57157, '1.1—MT 豪华型', NULL, 4731, 0, NULL, 'K', 0, 5, 8460),
(57156, '1.1—MT 舒适型', NULL, 4731, 0, NULL, 'K', 0, 5, 8459),
(57155, '1.1—MT 标准型', NULL, 4731, 0, NULL, 'K', 0, 5, 8458),
(57154, '1.0—MT 豪华型', NULL, 4731, 0, NULL, 'K', 0, 5, 8457),
(57153, '1.0—MT 舒适型', NULL, 4731, 0, NULL, 'K', 0, 5, 8456),
(57152, '1.0—MT 标准型', NULL, 4731, 0, NULL, 'K', 0, 5, 8455),
(57151, '1.1L MT 舒适Ⅱ型', NULL, 4730, 0, NULL, 'K', 0, 5, 14012),
(57150, '1.1L MT 舒适Ⅰ型', NULL, 4730, 0, NULL, 'K', 0, 5, 14011),
(57149, '1.1L MT 基本型', NULL, 4730, 0, NULL, 'K', 0, 5, 14010),
(57148, '1.0L MT 舒适Ⅱ型', NULL, 4730, 0, NULL, 'K', 0, 5, 14009),
(57147, '1.0L MT 舒适Ⅰ型', NULL, 4730, 0, NULL, 'K', 0, 5, 14008),
(57146, '1.0L MT 基本型', NULL, 4730, 0, NULL, 'K', 0, 5, 14007),
(57145, '1.1—MT 舒适型', NULL, 4729, 0, NULL, 'K', 0, 5, 10656),
(57144, '1.1—MT 标准型', NULL, 4729, 0, NULL, 'K', 0, 5, 10655),
(57143, '1.1—MT 基本型', NULL, 4729, 0, NULL, 'K', 0, 5, 10654),
(57142, '1.0—MT 舒适型', NULL, 4729, 0, NULL, 'K', 0, 5, 10653),
(57141, '1.0—MT 标准型', NULL, 4729, 0, NULL, 'K', 0, 5, 10652),
(57140, '1.0—MT 基本型', NULL, 4729, 0, NULL, 'K', 0, 5, 10651),
(57139, '双排 1.1L 手动 舒适型', NULL, 4728, 0, NULL, 'K', 0, 5, 101160),
(57138, '双排 1.1L 手动 标准型', NULL, 4728, 0, NULL, 'K', 0, 5, 101159),
(57137, '双排 1.1L 手动 基本型', NULL, 4728, 0, NULL, 'K', 0, 5, 101158),
(57136, '加长 1.2L 手动 舒适型', NULL, 4727, 0, NULL, 'K', 0, 5, 106542),
(57135, '加长 1.2L 手动 标准型', NULL, 4727, 0, NULL, 'K', 0, 5, 106541),
(57134, '加长 1.2L 手动 基本型', NULL, 4727, 0, NULL, 'K', 0, 5, 106540),
(57133, '加长 1.1L 手动 舒适型', NULL, 4727, 0, NULL, 'K', 0, 5, 106539),
(57132, '加长 1.1L 手动 标准型', NULL, 4727, 0, NULL, 'K', 0, 5, 106538),
(57131, '加长 1.1L 手动 基本型', NULL, 4727, 0, NULL, 'K', 0, 5, 106537),
(57130, '双排 1.2L 手动舒适型', NULL, 4727, 0, NULL, 'K', 0, 5, 105896),
(57129, '双排 1.2L 手动标准1型', NULL, 4727, 0, NULL, 'K', 0, 5, 105895),
(57128, '双排 1.2L 手动标准型', NULL, 4727, 0, NULL, 'K', 0, 5, 105894),
(57127, '双排 1.2L 手动 基本型', NULL, 4727, 0, NULL, 'K', 0, 5, 105893),
(57126, '双排 1.1L 手动舒适型', NULL, 4727, 0, NULL, 'K', 0, 5, 105892),
(57125, '双排 1.1L 手动标准1型', NULL, 4727, 0, NULL, 'K', 0, 5, 105890),
(57124, '双排 1.1L 手动标准型', NULL, 4727, 0, NULL, 'K', 0, 5, 105887),
(57123, '双排 1.1L 手动 基本型', NULL, 4727, 0, NULL, 'K', 0, 5, 105883),
(57122, '单排 1.1L 手动 舒适型', NULL, 4727, 0, NULL, 'K', 0, 5, 105881),
(57121, '单排 1.1L 手动 标准型', NULL, 4727, 0, NULL, 'K', 0, 5, 105880),
(57120, '单排 1.1L 手动 基本型', NULL, 4727, 0, NULL, 'K', 0, 5, 105879),
(57119, '1.6MT舒适型', NULL, 4726, 0, NULL, 'K', 0, 5, 1893),
(57118, '1.6MT标准型', NULL, 4726, 0, NULL, 'K', 0, 5, 1892),
(57117, '1.6MT基本型', NULL, 4726, 0, NULL, 'K', 0, 5, 1891),
(57116, '2.2L 手动 舒适型', NULL, 4725, 0, NULL, 'K', 0, 5, 103387),
(57115, '2.2L 手动 标准型', NULL, 4725, 0, NULL, 'K', 0, 5, 103384),
(57114, 'CCXR 4.7T Edition', NULL, 4724, 0, NULL, 'K', 0, 5, 109632),
(57113, 'Trevita', NULL, 4723, 0, NULL, 'K', 0, 5, 9482),
(57112, 'R 5.0T', NULL, 4722, 0, NULL, 'K', 0, 5, 104803),
(57111, '5.7L', NULL, 4721, 0, NULL, 'K', 0, 5, 7532),
(57110, '4.6L', NULL, 4720, 0, NULL, 'K', 0, 5, 10332),
(57109, '4驱', NULL, 4719, 0, NULL, 'K', 0, 5, 5366),
(57108, '2驱', NULL, 4719, 0, NULL, 'K', 0, 5, 5363),
(57107, 'HYBRID', NULL, 4718, 0, NULL, 'K', 0, 5, 8359),
(57106, 'Hybrid', NULL, 4717, 0, NULL, 'K', 0, 5, 10916),
(57105, '6.0L 自动 Hybrid', NULL, 4716, 0, NULL, 'K', 0, 5, 13954),
(57104, 'CEO V8 6.2L', NULL, 4715, 0, NULL, 'K', 0, 5, 11120),
(57103, '5.7L', NULL, 4714, 0, NULL, 'K', 0, 5, 6488),
(57102, 'EXT 皮卡', NULL, 4713, 0, NULL, 'K', 0, 5, 8898),
(57101, '总统一号', NULL, 4712, 0, NULL, 'K', 0, 5, 7860),
(57100, '6.2 AWD', NULL, 4711, 0, NULL, 'K', 0, 5, 7085),
(57099, '6.2AWD', NULL, 4711, 0, NULL, 'K', 0, 5, 3275),
(57098, '6.0L V8 Hybrid', NULL, 4710, 0, NULL, 'K', 0, 5, 16073),
(57097, '6.2 ESV铂金版', NULL, 4709, 0, NULL, 'K', 0, 5, 103822),
(57096, '加长凯迪拉克', NULL, 4708, 0, NULL, 'K', 0, 5, 3277),
(57095, '4.6L', NULL, 4707, 0, NULL, 'K', 0, 5, 10331),
(57094, '4.6L', NULL, 4706, 0, NULL, 'K', 0, 5, 3958),
(57093, '3.6L 精英型', NULL, 4705, 0, NULL, 'K', 0, 5, 5182),
(57092, '4.6L 旗舰型', NULL, 4705, 0, NULL, 'K', 0, 5, 4797),
(57091, '3.6L 高配版', NULL, 4705, 0, NULL, 'K', 0, 5, 4690),
(57090, '3.6L 豪华型', NULL, 4705, 0, NULL, 'K', 0, 5, 2191),
(57089, '3.6L V6 两驱', NULL, 4705, 0, NULL, 'K', 0, 5, 2170),
(57088, '3.6LRWD', NULL, 4705, 0, NULL, 'K', 0, 5, 2169),
(57087, '2.8L 豪华型', NULL, 4704, 0, NULL, 'K', 0, 5, 2193),
(57086, '2.8L 精英型', NULL, 4704, 0, NULL, 'K', 0, 5, 2190),
(57085, 'SRX 4.6L 旗舰型', NULL, 4703, 0, NULL, 'K', 0, 5, 8362),
(57084, 'SRX 3.6L 豪华型', NULL, 4703, 0, NULL, 'K', 0, 5, 8361),
(57083, 'SRX 3.6L 领先型', NULL, 4703, 0, NULL, 'K', 0, 5, 8360),
(57082, '3.0L 旗舰型', NULL, 4702, 0, NULL, 'K', 0, 5, 9490),
(57081, '3.0L 豪华型', NULL, 4702, 0, NULL, 'K', 0, 5, 9489),
(57080, '4.6L V8', NULL, 4702, 0, NULL, 'K', 0, 5, 2168),
(57079, '舒适型', NULL, 4701, 0, NULL, 'K', 0, 5, 14856),
(57078, '精英型', NULL, 4701, 0, NULL, 'K', 0, 5, 14855),
(57077, '领先型', NULL, 4701, 0, NULL, 'K', 0, 5, 14854),
(57076, '旗舰版', NULL, 4701, 0, NULL, 'K', 0, 5, 12166),
(57075, '豪华版', NULL, 4701, 0, NULL, 'K', 0, 5, 12163),
(57074, '3.0L 手自一体 旗舰版', NULL, 4700, 0, NULL, 'K', 0, 5, 14995),
(57073, '3.0L 手自一体 领先版', NULL, 4700, 0, NULL, 'K', 0, 5, 14994);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(57072, '3.0L 手自一体 豪华版', NULL, 4700, 0, NULL, 'K', 0, 5, 14993),
(57071, '3.0L 手自一体 精英版', NULL, 4700, 0, NULL, 'K', 0, 5, 14992),
(57070, '3.0L 手自一体 舒适版', NULL, 4700, 0, NULL, 'K', 0, 5, 14991),
(57069, '3.6L 手自一体 旗舰型', NULL, 4699, 0, NULL, 'K', 0, 5, 103059),
(57068, '3.0L 手自一体 旗舰型', NULL, 4699, 0, NULL, 'K', 0, 5, 103058),
(57067, '3.0L 手自一体 领先型', NULL, 4699, 0, NULL, 'K', 0, 5, 103057),
(57066, '3.0L 手自一体 豪华型', NULL, 4699, 0, NULL, 'K', 0, 5, 103056),
(57065, '3.0L 手自一体 精英型', NULL, 4699, 0, NULL, 'K', 0, 5, 103055),
(57064, '3.0L 手自一体 舒适型', NULL, 4699, 0, NULL, 'K', 0, 5, 103045),
(57063, '66号公路升级版 基本型', NULL, 4698, 0, NULL, 'K', 0, 5, 111586),
(57062, '3.6L 手自一体 旗舰型', NULL, 4698, 0, NULL, 'K', 0, 5, 106033),
(57061, '3.0L 手自一体 旗舰型', NULL, 4698, 0, NULL, 'K', 0, 5, 106032),
(57060, '3.0L 手自一体 领先型', NULL, 4698, 0, NULL, 'K', 0, 5, 106031),
(57059, '3.0L 手自一体 豪华型', NULL, 4698, 0, NULL, 'K', 0, 5, 106030),
(57058, '3.0L 手自一体 精英型', NULL, 4698, 0, NULL, 'K', 0, 5, 106029),
(57057, '3.0L 手自一体 舒适型', NULL, 4698, 0, NULL, 'K', 0, 5, 106028),
(57056, 'DTS 4.6L', NULL, 4697, 0, NULL, 'K', 0, 5, 3276),
(57055, '6.2L 手自一体', NULL, 4696, 0, NULL, 'K', 0, 5, 8148),
(57054, 'COUPE 6.2L 手自一体', NULL, 4695, 0, NULL, 'K', 0, 5, 101880),
(57053, '3.6L自动', NULL, 4694, 0, NULL, 'K', 0, 5, 10330),
(57052, '2.8 舒适版', NULL, 4694, 0, NULL, 'K', 0, 5, 10328),
(57051, '2.8 豪华版', NULL, 4694, 0, NULL, 'K', 0, 5, 10326),
(57050, '2.8 豪华运动版', NULL, 4693, 0, NULL, 'K', 0, 5, 100090),
(57049, '3.6 运动版', NULL, 4693, 0, NULL, 'K', 0, 5, 10329),
(57048, '3.6 旗舰版', NULL, 4693, 0, NULL, 'K', 0, 5, 10327),
(57047, '2.8 精英运动天窗版', NULL, 4692, 0, NULL, 'K', 0, 5, 7198),
(57046, '3.6 旗舰高性能版', NULL, 4692, 0, NULL, 'K', 0, 5, 5181),
(57045, '3.6 精英高性能版', NULL, 4692, 0, NULL, 'K', 0, 5, 4792),
(57044, '2.8 精英运动版', NULL, 4692, 0, NULL, 'K', 0, 5, 3957),
(57043, '2.8 豪华运动版', NULL, 4692, 0, NULL, 'K', 0, 5, 2153),
(57042, '3.6 旗舰高性能版', NULL, 4691, 0, NULL, 'K', 0, 5, 9826),
(57041, '3.6 精英高性能版', NULL, 4691, 0, NULL, 'K', 0, 5, 9825),
(57040, '3.0 豪华运动版', NULL, 4691, 0, NULL, 'K', 0, 5, 9824),
(57039, '3.0 风尚运动版', NULL, 4691, 0, NULL, 'K', 0, 5, 6487),
(57038, '3.0 精英运动版', NULL, 4691, 0, NULL, 'K', 0, 5, 2152),
(57037, '3.6L 自动 旗舰高性能版', NULL, 4690, 0, NULL, 'K', 0, 5, 14270),
(57036, '3.6L 自动 精英高性能版', NULL, 4690, 0, NULL, 'K', 0, 5, 14269),
(57035, '3.0L 自动 豪华运动版', NULL, 4690, 0, NULL, 'K', 0, 5, 14268),
(57034, '3.0L 自动 精英运动版', NULL, 4690, 0, NULL, 'K', 0, 5, 14267),
(57033, '3.0L 自动 风尚运动版', NULL, 4690, 0, NULL, 'K', 0, 5, 14266),
(57032, '3.0L Vday 精英纪念版', NULL, 4689, 0, NULL, 'K', 0, 5, 101524),
(57031, '3.0L 风尚运动型', NULL, 4689, 0, NULL, 'K', 0, 5, 15605),
(57030, '3.0L 精英运动型', NULL, 4689, 0, NULL, 'K', 0, 5, 15604),
(57029, '3.0L 豪华运动型', NULL, 4689, 0, NULL, 'K', 0, 5, 15598),
(57028, '28T 精英型', NULL, 4688, 0, NULL, 'K', 0, 5, 110891),
(57027, '28T 豪华型', NULL, 4688, 0, NULL, 'K', 0, 5, 110890),
(57026, '28T 领先型', NULL, 4688, 0, NULL, 'K', 0, 5, 110675),
(57025, '3.6L', NULL, 4687, 0, NULL, 'K', 0, 5, 9847),
(57024, '3.6L', NULL, 4686, 0, NULL, 'K', 0, 5, 15610),
(57023, '28T 领先型', NULL, 4685, 0, NULL, 'K', 0, 5, 106207),
(57022, '28T 豪华型', NULL, 4685, 0, NULL, 'K', 0, 5, 106206),
(57021, '28T 精英型', NULL, 4685, 0, NULL, 'K', 0, 5, 106205),
(57020, '28T 舒适型', NULL, 4685, 0, NULL, 'K', 0, 5, 106041),
(57019, '帝威 DHS4.6', NULL, 4684, 0, NULL, 'K', 0, 5, 3779),
(57018, '3.6豪华型', NULL, 4683, 0, NULL, 'K', 0, 5, 5977),
(57017, '3.6精英型', NULL, 4683, 0, NULL, 'K', 0, 5, 5976),
(57016, '4.6旗舰型', NULL, 4683, 0, NULL, 'K', 0, 5, 3962),
(57015, '2.8豪华型', NULL, 4683, 0, NULL, 'K', 0, 5, 3960),
(57014, '2.8精英型', NULL, 4683, 0, NULL, 'K', 0, 5, 3959),
(57013, '4.6L 旗舰型', NULL, 4683, 0, NULL, 'K', 0, 5, 2192),
(57012, '4.6L 手自一体 旗舰型', NULL, 4682, 0, NULL, 'K', 0, 5, 108230),
(57011, '3.6 手自一体 精英型', NULL, 4682, 0, NULL, 'K', 0, 5, 108227),
(57010, '3.6 手自一体 豪华型', NULL, 4682, 0, NULL, 'K', 0, 5, 108225),
(57009, '2.8 手自一体 精英型', NULL, 4682, 0, NULL, 'K', 0, 5, 108223),
(57008, '2.8 手自一体 豪华型', NULL, 4682, 0, NULL, 'K', 0, 5, 108221),
(57007, '4.6L 手自一体 旗舰型', NULL, 4681, 0, NULL, 'K', 0, 5, 108229),
(57006, '3.6 手自一体 精英型', NULL, 4681, 0, NULL, 'K', 0, 5, 108228),
(57005, '3.6 手自一体 豪华型', NULL, 4681, 0, NULL, 'K', 0, 5, 108226),
(57004, '2.8 手自一体 精英型', NULL, 4681, 0, NULL, 'K', 0, 5, 108224),
(57003, '2.8 手自一体 豪华型', NULL, 4681, 0, NULL, 'K', 0, 5, 108222),
(57002, '3.6L 旗舰型', NULL, 4680, 0, NULL, 'K', 0, 5, 9723),
(57001, '3.6L 运动型', NULL, 4680, 0, NULL, 'K', 0, 5, 9722),
(57000, '3.0L 豪华型', NULL, 4680, 0, NULL, 'K', 0, 5, 9721),
(56999, '3.0L 精英型', NULL, 4680, 0, NULL, 'K', 0, 5, 9717),
(56998, '2.0T 舒适型', NULL, 4679, 0, NULL, 'K', 0, 5, 15305),
(56997, '3.6L 旗舰版', NULL, 4679, 0, NULL, 'K', 0, 5, 12701),
(56996, '3.6L 运动型', NULL, 4679, 0, NULL, 'K', 0, 5, 12699),
(56995, '3.0L 豪华型', NULL, 4679, 0, NULL, 'K', 0, 5, 12696),
(56994, '3.0L 精英型', NULL, 4679, 0, NULL, 'K', 0, 5, 12695),
(56993, '2.0T 行政版', NULL, 4679, 0, NULL, 'K', 0, 5, 12694),
(56992, '2.0T 豪华型', NULL, 4679, 0, NULL, 'K', 0, 5, 12693),
(56991, '2.0T 精英型', NULL, 4679, 0, NULL, 'K', 0, 5, 12692),
(56990, '2.0T 手自一体 舒适型', NULL, 4678, 0, NULL, 'K', 0, 5, 101178),
(56989, '28T 科技型', NULL, 4677, 0, NULL, 'K', 0, 5, 104308),
(56988, '28T 典雅型', NULL, 4677, 0, NULL, 'K', 0, 5, 104306),
(56987, '28T 舒适型', NULL, 4677, 0, NULL, 'K', 0, 5, 103229),
(56986, '36S 铂金版', NULL, 4677, 0, NULL, 'K', 0, 5, 103094),
(56985, '28T 领先型', NULL, 4677, 0, NULL, 'K', 0, 5, 103093),
(56984, '28T 豪华型', NULL, 4677, 0, NULL, 'K', 0, 5, 103091),
(56983, '28T 精英型 ', NULL, 4677, 0, NULL, 'K', 0, 5, 103090),
(56982, '28T 博鳌行政版', NULL, 4676, 0, NULL, 'K', 0, 5, 110939),
(56981, '28T 舒适型', NULL, 4676, 0, NULL, 'K', 0, 5, 110459),
(56980, '28T 典雅型', NULL, 4676, 0, NULL, 'K', 0, 5, 110458),
(56979, '28T 精英型 ', NULL, 4676, 0, NULL, 'K', 0, 5, 110457),
(56978, '28T 科技型', NULL, 4676, 0, NULL, 'K', 0, 5, 110456),
(56977, '28T 豪华型', NULL, 4676, 0, NULL, 'K', 0, 5, 110455),
(56976, '28T 铂金型', NULL, 4676, 0, NULL, 'K', 0, 5, 110454),
(56975, '36S 铂金版', NULL, 4676, 0, NULL, 'K', 0, 5, 110453),
(56974, '3.6L V6 四驱', NULL, 4675, 0, NULL, 'K', 0, 5, 6790),
(56973, '3.6L V6 两驱', NULL, 4675, 0, NULL, 'K', 0, 5, 6775),
(56972, '4.6L V8', NULL, 4675, 0, NULL, 'K', 0, 5, 6774),
(56971, '4.6L 四驱豪华型', NULL, 4674, 0, NULL, 'K', 0, 5, 10527),
(56970, '3.6L 四驱豪华型', NULL, 4674, 0, NULL, 'K', 0, 5, 10526),
(56969, '3.6L V6 两驱豪华型', NULL, 4673, 0, NULL, 'K', 0, 5, 10531),
(56968, '3.6L 两驱豪华型', NULL, 4673, 0, NULL, 'K', 0, 5, 10530),
(56967, '4.6L 四驱豪华型', NULL, 4673, 0, NULL, 'K', 0, 5, 10529),
(56966, '3.6L 四驱豪华型', NULL, 4673, 0, NULL, 'K', 0, 5, 10528),
(56965, '3.6L', NULL, 4672, 0, NULL, 'K', 0, 5, 6771),
(56964, '2.8L 手自一体', NULL, 4671, 0, NULL, 'K', 0, 5, 104399),
(56963, '3.6L 高性能版', NULL, 4671, 0, NULL, 'K', 0, 5, 6773),
(56962, '3.6L高性能运动型', NULL, 4670, 0, NULL, 'K', 0, 5, 109172),
(56961, '2.8L', NULL, 4669, 0, NULL, 'K', 0, 5, 10525),
(56960, '2.8L精英型', NULL, 4669, 0, NULL, 'K', 0, 5, 10524),
(56959, '2.8L豪华运动版', NULL, 4668, 0, NULL, 'K', 0, 5, 6772),
(56958, '基本型', NULL, 4667, 0, NULL, 'K', 0, 5, 110630),
(56957, '赛百灵 2.5 敞篷', NULL, 4666, 0, NULL, 'K', 0, 5, 15631),
(56956, '赛百灵', NULL, 4665, 0, NULL, 'K', 0, 5, 5595),
(56955, '2.2L', NULL, 4664, 0, NULL, 'K', 0, 5, 6840),
(56954, '君王2.7L', NULL, 4663, 0, NULL, 'K', 0, 5, 6839),
(56953, '君王2.7L', NULL, 4662, 0, NULL, 'K', 0, 5, 11004),
(56952, '交叉火力', NULL, 4661, 0, NULL, 'K', 0, 5, 6489),
(56951, '1.6L', NULL, 4660, 0, NULL, 'K', 0, 5, 6838),
(56950, 'Neon Sport 2.0L', NULL, 4659, 0, NULL, 'K', 0, 5, 9104),
(56949, '3.0L 柴油CRD', NULL, 4658, 0, NULL, 'K', 0, 5, 109751),
(56948, '3.5L 手自一体', NULL, 4658, 0, NULL, 'K', 0, 5, 3575),
(56947, '5.7L V8', NULL, 4658, 0, NULL, 'K', 0, 5, 3555),
(56946, '3.5L V6', NULL, 4658, 0, NULL, 'K', 0, 5, 3554),
(56945, '2.7L V6', NULL, 4658, 0, NULL, 'K', 0, 5, 3553),
(56944, '2.7L V6 行政版', NULL, 4657, 0, NULL, 'K', 0, 5, 3135),
(56943, '3.6L 自动 豪华型', NULL, 4656, 0, NULL, 'K', 0, 5, 100005),
(56942, 'S 3.6L 手自一体 锋尚版', NULL, 4655, 0, NULL, 'K', 0, 5, 105965),
(56941, '3.6L 手自一体 尊适版', NULL, 4655, 0, NULL, 'K', 0, 5, 104257),
(56940, '3.6L 手自一体 尊享版', NULL, 4655, 0, NULL, 'K', 0, 5, 102661),
(56939, '3.6L 手自一体 尊崇版', NULL, 4655, 0, NULL, 'K', 0, 5, 102660),
(56938, '3.0L 手自一体 卓越版', NULL, 4654, 0, NULL, 'K', 0, 5, 110593),
(56937, '辉煌 V8 5.7L', NULL, 4653, 0, NULL, 'K', 0, 5, 3278),
(56936, '大捷龙 3.3L', NULL, 4652, 0, NULL, 'K', 0, 5, 15490),
(56935, '大捷龙 2.4L', NULL, 4651, 0, NULL, 'K', 0, 5, 9065),
(56934, '大捷龙 3.3L', NULL, 4651, 0, NULL, 'K', 0, 5, 9064),
(56933, '大捷龙 3.6L 手自一体 豪华版', NULL, 4650, 0, NULL, 'K', 0, 5, 102118),
(56932, 'Town ＆ Country', NULL, 4649, 0, NULL, 'K', 0, 5, 10748),
(56931, '2.4T 手动', NULL, 4648, 0, NULL, 'K', 0, 5, 109756),
(56930, '2.4 手动', NULL, 4648, 0, NULL, 'K', 0, 5, 109755),
(56929, '1.6 手动', NULL, 4648, 0, NULL, 'K', 0, 5, 109754),
(56928, '2.0 手动', NULL, 4648, 0, NULL, 'K', 0, 5, 109753),
(56927, '2.2 柴油CRD', NULL, 4648, 0, NULL, 'K', 0, 5, 109752),
(56926, '2.2 柴油CRD', NULL, 4647, 0, NULL, 'K', 0, 5, 109757),
(56925, '2.4', NULL, 4646, 0, NULL, 'K', 0, 5, 7885),
(56924, '限量版', NULL, 4646, 0, NULL, 'K', 0, 5, 3574),
(56923, 'PT漫步者敞篷版（PT Cruiser）', NULL, 4646, 0, NULL, 'K', 0, 5, 3557),
(56922, 'PT漫步者（PT Cruiser）', NULL, 4646, 0, NULL, 'K', 0, 5, 3556),
(56921, '300M', NULL, 4645, 0, NULL, 'K', 0, 5, 3552),
(56920, '3.3L豪华版', NULL, 4644, 0, NULL, 'K', 0, 5, 4762),
(56919, '3.3L行政版', NULL, 4644, 0, NULL, 'K', 0, 5, 4758),
(56918, '商务版(带STOW ‘N GO 功能)', NULL, 4644, 0, NULL, 'K', 0, 5, 3577),
(56917, '限量版(带STOW ‘N GO 功能)', NULL, 4644, 0, NULL, 'K', 0, 5, 3576),
(56916, '限量版(带Captain豪华座椅)', NULL, 4644, 0, NULL, 'K', 0, 5, 40),
(56915, '商务版(带Captain豪华座椅)', NULL, 4644, 0, NULL, 'K', 0, 5, 39),
(56914, '3.0L 自动 经典版', NULL, 4643, 0, NULL, 'K', 0, 5, 100386),
(56913, '3.0L 自动 豪华版', NULL, 4643, 0, NULL, 'K', 0, 5, 100385),
(56912, '3.0L 自动 至尊版', NULL, 4643, 0, NULL, 'K', 0, 5, 100383),
(56911, '5.7L 豪华版', NULL, 4642, 0, NULL, 'K', 0, 5, 10291),
(56910, '3.5L 豪华版', NULL, 4642, 0, NULL, 'K', 0, 5, 10290),
(56909, '2.7L 豪华型', NULL, 4641, 0, NULL, 'K', 0, 5, 106845),
(56908, '5.7L 豪华型', NULL, 4641, 0, NULL, 'K', 0, 5, 106844),
(56907, '3.5L 豪华型', NULL, 4641, 0, NULL, 'K', 0, 5, 106843),
(56906, '2.7L 豪华领航版', NULL, 4641, 0, NULL, 'K', 0, 5, 5675),
(56905, '2.7L 商务版', NULL, 4641, 0, NULL, 'K', 0, 5, 3134),
(56904, '5.7L 豪华领航版', NULL, 4641, 0, NULL, 'K', 0, 5, 3133),
(56903, '3.5L 豪华领航版', NULL, 4641, 0, NULL, 'K', 0, 5, 3132),
(56902, '2.7L 豪华版', NULL, 4641, 0, NULL, 'K', 0, 5, 3131),
(56901, '3.5L 豪华领航版', NULL, 4640, 0, NULL, 'K', 0, 5, 108612),
(56900, '2.7L 豪华型', NULL, 4640, 0, NULL, 'K', 0, 5, 106842),
(56899, '2.7L 商务型', NULL, 4640, 0, NULL, 'K', 0, 5, 106841),
(56898, '2.7L 豪华型', NULL, 4639, 0, NULL, 'K', 0, 5, 106849),
(56897, '2.4L 豪华型', NULL, 4639, 0, NULL, 'K', 0, 5, 106848),
(56896, '2.0L 豪华型', NULL, 4639, 0, NULL, 'K', 0, 5, 106847),
(56895, '2.0L 舒适型', NULL, 4639, 0, NULL, 'K', 0, 5, 106846),
(56894, '2.0L豪华型', NULL, 4638, 0, NULL, 'K', 0, 5, 5114),
(56893, '2.0L舒适型', NULL, 4638, 0, NULL, 'K', 0, 5, 4700),
(56892, '2.7L豪华型', NULL, 4638, 0, NULL, 'K', 0, 5, 4698),
(56891, '2.4L豪华型', NULL, 4638, 0, NULL, 'K', 0, 5, 4696),
(56890, 'XML6601 公交版', NULL, 4637, 0, NULL, 'J', 0, 5, 105597),
(56889, 'XML6700', NULL, 4636, 0, NULL, 'J', 0, 5, 105713),
(56888, 'XML6125改装特种车', NULL, 4635, 0, NULL, 'J', 0, 5, 105671),
(56887, 'XML6603J53', NULL, 4635, 0, NULL, 'J', 0, 5, 105669),
(56886, 'XML6723J53', NULL, 4635, 0, NULL, 'J', 0, 5, 105668),
(56885, 'XML6901雪狐版校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105667),
(56884, 'XML6821雪狐版校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105665),
(56883, 'XML6971雪狐版校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105664),
(56882, 'XML6901大金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105663),
(56881, 'XML6101大金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105662),
(56880, 'XML6111大金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105661),
(56879, 'XML6721小金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105660),
(56878, 'XML6791小金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105659),
(56877, 'XML6661小金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105658),
(56876, 'XML6601小金象校车', NULL, 4635, 0, NULL, 'J', 0, 5, 105657),
(56875, 'XML6140机场摆渡车', NULL, 4635, 0, NULL, 'J', 0, 5, 105656),
(56874, 'XML6180BRT', NULL, 4635, 0, NULL, 'J', 0, 5, 105655),
(56873, 'XML6185BRT', NULL, 4635, 0, NULL, 'J', 0, 5, 105654),
(56872, 'XML6146', NULL, 4635, 0, NULL, 'J', 0, 5, 105653),
(56871, 'XML6125JHEV混合动力', NULL, 4635, 0, NULL, 'J', 0, 5, 105652),
(56870, 'XML6115', NULL, 4635, 0, NULL, 'J', 0, 5, 105651),
(56869, 'XML6115混合动力', NULL, 4635, 0, NULL, 'J', 0, 5, 105646),
(56868, 'XML6116', NULL, 4635, 0, NULL, 'J', 0, 5, 105645),
(56867, 'XML6120', NULL, 4635, 0, NULL, 'J', 0, 5, 105644),
(56866, 'XML6125', NULL, 4635, 0, NULL, 'J', 0, 5, 105643),
(56865, 'XML6125天然气', NULL, 4635, 0, NULL, 'J', 0, 5, 105642),
(56864, 'XML6105公交车', NULL, 4635, 0, NULL, 'J', 0, 5, 105641),
(56863, 'XML6105JHEV混合动力系列', NULL, 4635, 0, NULL, 'J', 0, 5, 105640),
(56862, 'XML6845', NULL, 4635, 0, NULL, 'J', 0, 5, 105639),
(56861, 'XML6745', NULL, 4635, 0, NULL, 'J', 0, 5, 105638),
(56860, 'XML6795', NULL, 4635, 0, NULL, 'J', 0, 5, 105635),
(56859, 'XML6145', NULL, 4635, 0, NULL, 'J', 0, 5, 105634),
(56858, 'XML6126', NULL, 4635, 0, NULL, 'J', 0, 5, 105633),
(56857, 'XML6128座位车', NULL, 4635, 0, NULL, 'J', 0, 5, 105632),
(56856, 'XML6127-双玻', NULL, 4635, 0, NULL, 'J', 0, 5, 105631),
(56855, 'XML6127雪豹', NULL, 4635, 0, NULL, 'J', 0, 5, 105630),
(56854, 'XML6125天骄-单片玻璃', NULL, 4635, 0, NULL, 'J', 0, 5, 105629),
(56853, 'XML6127商旅', NULL, 4635, 0, NULL, 'J', 0, 5, 105628),
(56852, 'XML6127-单玻', NULL, 4635, 0, NULL, 'J', 0, 5, 105627),
(56851, 'XML6117', NULL, 4635, 0, NULL, 'J', 0, 5, 105626),
(56850, 'XML6116客车', NULL, 4635, 0, NULL, 'J', 0, 5, 105624),
(56849, 'XML6113雪豹', NULL, 4635, 0, NULL, 'J', 0, 5, 105623),
(56848, 'XML6117雪豹', NULL, 4635, 0, NULL, 'J', 0, 5, 105622),
(56847, 'XML6113', NULL, 4635, 0, NULL, 'J', 0, 5, 105621),
(56846, 'XML6103', NULL, 4635, 0, NULL, 'J', 0, 5, 105620),
(56845, 'XML6103雪豹', NULL, 4635, 0, NULL, 'J', 0, 5, 105619),
(56844, 'XML6957', NULL, 4635, 0, NULL, 'J', 0, 5, 105618),
(56843, 'XML6997雪狐', NULL, 4635, 0, NULL, 'J', 0, 5, 105617),
(56842, 'XML6897', NULL, 4635, 0, NULL, 'J', 0, 5, 105616),
(56841, 'XML6857', NULL, 4635, 0, NULL, 'J', 0, 5, 105615),
(56840, 'XML6807', NULL, 4635, 0, NULL, 'J', 0, 5, 105614),
(56839, 'XML6909', NULL, 4635, 0, NULL, 'J', 0, 5, 105612),
(56838, 'XML6807雪狐', NULL, 4635, 0, NULL, 'J', 0, 5, 105606),
(56837, 'XML6857雪狐', NULL, 4635, 0, NULL, 'J', 0, 5, 105605),
(56836, 'XML6757雪狐系列', NULL, 4635, 0, NULL, 'J', 0, 5, 105598),
(56835, 'XML6125天骄-双层玻璃', NULL, 4635, 0, NULL, 'J', 0, 5, 105594),
(56834, 'XML6897雪狐', NULL, 4635, 0, NULL, 'J', 0, 5, 105592),
(56833, '囚车', NULL, 4634, 0, NULL, 'J', 0, 5, 105679),
(56832, '救护车', NULL, 4634, 0, NULL, 'J', 0, 5, 105678),
(56831, '厢式运输车（物流用车）', NULL, 4634, 0, NULL, 'J', 0, 5, 105677),
(56830, '4.7米小海狮', NULL, 4634, 0, NULL, 'J', 0, 5, 105675),
(56829, '冷藏车', NULL, 4634, 0, NULL, 'J', 0, 5, 105674),
(56828, '校车', NULL, 4634, 0, NULL, 'J', 0, 5, 105673),
(56827, '邮政车', NULL, 4634, 0, NULL, 'J', 0, 5, 105672),
(56826, '2.0L 舒适型 V20', NULL, 4634, 0, NULL, 'J', 0, 5, 103589),
(56825, '2.0L 舒适型 V19', NULL, 4634, 0, NULL, 'J', 0, 5, 103588),
(56824, '2.4L 舒适型 4RB2', NULL, 4634, 0, NULL, 'J', 0, 5, 103587),
(56823, '2.2L 舒适型 JM491Q-ME', NULL, 4634, 0, NULL, 'J', 0, 5, 103586),
(56822, '2.5L 进取型 YC4FB90-36', NULL, 4634, 0, NULL, 'J', 0, 5, 103585),
(56821, '2.5L 进取型 YC4FB90-30', NULL, 4634, 0, NULL, 'J', 0, 5, 103584),
(56820, '2.8L 进取型 GW2.8TC-2', NULL, 4634, 0, NULL, 'J', 0, 5, 103583),
(56819, '2.0L 进取型 D20A', NULL, 4634, 0, NULL, 'J', 0, 5, 103582),
(56818, '2.0L 进取型 V20', NULL, 4634, 0, NULL, 'J', 0, 5, 103581),
(56817, '2.2L 进取型 JM491Q-ME', NULL, 4634, 0, NULL, 'J', 0, 5, 103580),
(56816, '2.0L 进取型 V19', NULL, 4634, 0, NULL, 'J', 0, 5, 103574),
(56815, '勘察车Ⅱ型HKL5030 XQCC', NULL, 4633, 0, NULL, 'J', 0, 5, 16476),
(56814, '勘察车Ⅱ型HKL5030 XQCE4-2', NULL, 4633, 0, NULL, 'J', 0, 5, 16475),
(56813, '勘察车Ⅱ型HKL5030 XQCE4-1', NULL, 4633, 0, NULL, 'J', 0, 5, 16474),
(56812, '警务车HKL5030 XQCC', NULL, 4633, 0, NULL, 'J', 0, 5, 16473),
(56811, '警务车HKL5030 XQCE4-2', NULL, 4633, 0, NULL, 'J', 0, 5, 16472),
(56810, '警务车HKL5030 XQCE4-1', NULL, 4633, 0, NULL, 'J', 0, 5, 16471),
(56809, '普通型救护车HKL5030 XJHC', NULL, 4633, 0, NULL, 'J', 0, 5, 16469),
(56808, '普通型救护车HKL5030 XJHE4-2', NULL, 4633, 0, NULL, 'J', 0, 5, 16468),
(56807, '普通型救护车HKL5030 XJHE4-1', NULL, 4633, 0, NULL, 'J', 0, 5, 16467),
(56806, '监护型救护车HKL5030 XJHC', NULL, 4633, 0, NULL, 'J', 0, 5, 16466),
(56805, '监护型救护车HKL5030 XJHE4-2', NULL, 4633, 0, NULL, 'J', 0, 5, 16465),
(56804, '监护型救护车HKL5030 XJHE4-1', NULL, 4633, 0, NULL, 'J', 0, 5, 16458),
(56803, '10人座豪华(自动)版', NULL, 4632, 0, NULL, 'J', 0, 5, 11436),
(56802, '13人座豪华(手动)版', NULL, 4632, 0, NULL, 'J', 0, 5, 11435),
(56801, '13人座精英(柴油)版', NULL, 4632, 0, NULL, 'J', 0, 5, 11434),
(56800, '13人座精英(国IV)版', NULL, 4632, 0, NULL, 'J', 0, 5, 11433),
(56799, '13人座精英版', NULL, 4632, 0, NULL, 'J', 0, 5, 11432),
(56798, '九龙VIP商务车', NULL, 4632, 0, NULL, 'J', 0, 5, 11431),
(56797, '快乐之旅 HKL6481E4-2', NULL, 4631, 0, NULL, 'J', 0, 5, 16501),
(56796, '快乐之旅 HKL6481E4-1', NULL, 4631, 0, NULL, 'J', 0, 5, 16499),
(56795, '大MVP HKL5031XSWE4-2', NULL, 4631, 0, NULL, 'J', 0, 5, 16498),
(56794, '大MVP HKL5031XSWE4-1', NULL, 4631, 0, NULL, 'J', 0, 5, 16497),
(56793, 'A6 HKL6600Q 汽油', NULL, 4631, 0, NULL, 'J', 0, 5, 16496),
(56792, 'A6 HKL6600CE4 柴油', NULL, 4631, 0, NULL, 'J', 0, 5, 16495),
(56791, 'A6 HKL6600C 柴油', NULL, 4631, 0, NULL, 'J', 0, 5, 16494),
(56790, 'VIP商务车 HKL5030 XSWC', NULL, 4631, 0, NULL, 'J', 0, 5, 16493),
(56789, 'VIP商务车 HKL5030 XSWE4-2', NULL, 4631, 0, NULL, 'J', 0, 5, 16492),
(56788, 'VIP商务车 HKL5030 XSWE4-1', NULL, 4631, 0, NULL, 'J', 0, 5, 16491),
(56787, 'VIP商务车 HKL5030 XSW', NULL, 4631, 0, NULL, 'J', 0, 5, 16490),
(56786, 'A5 HKL5030 XSWE4 汽油 精英型', NULL, 4631, 0, NULL, 'J', 0, 5, 16489),
(56785, 'A5 HKL5030 XSWE4 汽油 豪华型', NULL, 4631, 0, NULL, 'J', 0, 5, 16488),
(56784, 'A5 HKL6540C 柴油 精英型', NULL, 4631, 0, NULL, 'J', 0, 5, 16487),
(56783, 'A5 HKL6540C 柴油 豪华型', NULL, 4631, 0, NULL, 'J', 0, 5, 16486),
(56782, 'A5 HKL6541 汽油 精英型', NULL, 4631, 0, NULL, 'J', 0, 5, 16483),
(56781, 'A5 HKL6541 汽油 豪华型', NULL, 4631, 0, NULL, 'J', 0, 5, 16482),
(56780, 'A5 HKL6540E4 汽油 豪华型-2', NULL, 4631, 0, NULL, 'J', 0, 5, 16481),
(56779, 'A5 HKL6540E4 汽油 精英型-2', NULL, 4631, 0, NULL, 'J', 0, 5, 16480),
(56778, 'A5 HKL6540E4 汽油 精英型-1', NULL, 4631, 0, NULL, 'J', 0, 5, 16479),
(56777, 'A5 HKL6540E4 汽油 豪华型-1', NULL, 4631, 0, NULL, 'J', 0, 5, 16477),
(56776, 'HKL6700', NULL, 4630, 0, NULL, 'J', 0, 5, 16457),
(56775, 'HKL6700CA', NULL, 4630, 0, NULL, 'J', 0, 5, 16456),
(56774, 'JJ7150', NULL, 4629, 0, NULL, 'J', 0, 5, 6562),
(56773, '1.3手动', NULL, 4628, 0, NULL, 'J', 0, 5, 10345),
(56772, '4.2 AT SC 敞篷版', NULL, 4627, 0, NULL, 'J', 0, 5, 109518),
(56771, '敞篷版4.2-AT-SC', NULL, 4626, 0, NULL, 'J', 0, 5, 15537),
(56770, '5.0L V8机械增压敞篷跑车', NULL, 4625, 0, NULL, 'J', 0, 5, 8358),
(56769, '5.0L V8机械增压硬顶跑车', NULL, 4625, 0, NULL, 'J', 0, 5, 8354),
(56768, '5.0L V8 机械增压敞篷跑车', NULL, 4624, 0, NULL, 'J', 0, 5, 14120),
(56767, '5.0L V8 机械增压硬顶跑车', NULL, 4624, 0, NULL, 'J', 0, 5, 14119),
(56766, 'XKR-S 5.0L 手自一体 V8机械增压敞篷跑车', NULL, 4623, 0, NULL, 'J', 0, 5, 16339),
(56765, '5.0L 手自一体 V8机械增压敞篷跑车', NULL, 4623, 0, NULL, 'J', 0, 5, 14945),
(56764, '5.0L 手自一体 V8机械增压硬顶跑车', NULL, 4623, 0, NULL, 'J', 0, 5, 14944),
(56763, 'XKR-S 5.0L 手自一体 V8机械增压硬顶跑车', NULL, 4623, 0, NULL, 'J', 0, 5, 13586),
(56762, '4.2L V8 敞篷跑车', NULL, 4622, 0, NULL, 'J', 0, 5, 3266),
(56761, '4.2L V8 双门跑车', NULL, 4622, 0, NULL, 'J', 0, 5, 3265),
(56760, 'XJL 精英领袖版', NULL, 4621, 0, NULL, 'J', 0, 5, 3716),
(56759, 'XJ8L 新一代皇家加长版', NULL, 4620, 0, NULL, 'J', 0, 5, 3728),
(56758, 'XJ6L 新一代皇家加长版', NULL, 4620, 0, NULL, 'J', 0, 5, 3714),
(56757, '全景奢华版', NULL, 4619, 0, NULL, 'J', 0, 5, 9668),
(56756, '5.0L 全景奢华版', NULL, 4618, 0, NULL, 'J', 0, 5, 109517),
(56755, '旗舰商务版', NULL, 4618, 0, NULL, 'J', 0, 5, 14118),
(56754, '全景商务版', NULL, 4618, 0, NULL, 'J', 0, 5, 13402),
(56753, '旗舰尊崇版', NULL, 4618, 0, NULL, 'J', 0, 5, 8825),
(56752, '5.0L 手自一体 旗舰尊崇版', NULL, 4617, 0, NULL, 'J', 0, 5, 14943),
(56751, '5.0L 手自一体 全景奢华版', NULL, 4617, 0, NULL, 'J', 0, 5, 14942),
(56750, '3.0L 手自一体 旗舰商务版', NULL, 4617, 0, NULL, 'J', 0, 5, 14941),
(56749, '3.0L 手自一体 全景商务版', NULL, 4617, 0, NULL, 'J', 0, 5, 14936),
(56748, '3.0SC 剑桥限量版', NULL, 4616, 0, NULL, 'J', 0, 5, 104397),
(56747, '5.0SC 手自一体 创世巅峰版 4座', NULL, 4616, 0, NULL, 'J', 0, 5, 102014),
(56746, '5.0SC 手自一体 创世巅峰版 5座', NULL, 4616, 0, NULL, 'J', 0, 5, 102013),
(56745, '3.0SC 手自一体 四驱 旗舰商务版', NULL, 4616, 0, NULL, 'J', 0, 5, 102012),
(56744, '3.0SC 手自一体 旗舰商务版', NULL, 4616, 0, NULL, 'J', 0, 5, 102011),
(56743, '3.0SC 手自一体 全景商务版', NULL, 4616, 0, NULL, 'J', 0, 5, 102010),
(56742, '2.0T 手自一体 全景商务版', NULL, 4616, 0, NULL, 'J', 0, 5, 102009),
(56741, '2.0T 手自一体 典雅商务版', NULL, 4616, 0, NULL, 'J', 0, 5, 102007),
(56740, '2.0T 手自一体 两驱 尊享商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106224),
(56739, '2.0T 手自一体 两驱 全景商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106223),
(56738, '3.0SC 手自一体 四驱 旗舰商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106221),
(56737, '3.0SC 手自一体 两驱 旗舰商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106220),
(56736, '3.0SC 手自一体 四驱 尊享商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106219),
(56735, '3.0SC 手自一体 两驱 尊享商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106218),
(56734, '3.0SC 手自一体 两驱 全景商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106216),
(56733, '2.0T 手自一体 两驱 典雅商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 106093),
(56732, '3.0SC 手自一体 四驱 全景商务版', NULL, 4615, 0, NULL, 'J', 0, 5, 105993),
(56731, '5.0L V8机械增压版', NULL, 4614, 0, NULL, 'J', 0, 5, 109515),
(56730, 'XFR 5.0L V8机械增压版', NULL, 4614, 0, NULL, 'J', 0, 5, 8353),
(56729, 'XFR 5.0L V8 机械增压版', NULL, 4613, 0, NULL, 'J', 0, 5, 14123),
(56728, '2.7L 柴油豪华型', NULL, 4612, 0, NULL, 'J', 0, 5, 10448),
(56727, '5.0 奢华版', NULL, 4611, 0, NULL, 'J', 0, 5, 109516),
(56726, '4.2 SV8机械增压版', NULL, 4611, 0, NULL, 'J', 0, 5, 8349),
(56725, '3.0 V6优质豪华版', NULL, 4611, 0, NULL, 'J', 0, 5, 7235),
(56724, '5.0L V8奢华版', NULL, 4610, 0, NULL, 'J', 0, 5, 8350),
(56723, '3.0L V6豪华版', NULL, 4610, 0, NULL, 'J', 0, 5, 5154),
(56722, '5.0L V8奢华版', NULL, 4609, 0, NULL, 'J', 0, 5, 11384),
(56721, '3.0L V6豪华版', NULL, 4609, 0, NULL, 'J', 0, 5, 11382),
(56720, '奢华版', NULL, 4608, 0, NULL, 'J', 0, 5, 14122),
(56719, '豪华版', NULL, 4608, 0, NULL, 'J', 0, 5, 14121),
(56718, '3.0L V6 75周年限量版', NULL, 4608, 0, NULL, 'J', 0, 5, 14036),
(56717, '3.0L 手自一体 V6伦敦限量版', NULL, 4607, 0, NULL, 'J', 0, 5, 102015),
(56716, '3.0L 手自一体 V6豪华版', NULL, 4607, 0, NULL, 'J', 0, 5, 14935),
(56715, '3.0L 手自一体 V6风华版', NULL, 4607, 0, NULL, 'J', 0, 5, 14934),
(56714, '2.0T 剑桥限量版', NULL, 4606, 0, NULL, 'J', 0, 5, 104396),
(56713, '3.0SC 奢华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102006),
(56712, '2.0T 奢华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102005),
(56711, '3.0SC 豪华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102004),
(56710, '2.0T 豪华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102003),
(56709, '3.0SC 风华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102002),
(56708, '2.0T 风华版', NULL, 4606, 0, NULL, 'J', 0, 5, 102001),
(56707, '3.0SC Sport Club限量版', NULL, 4605, 0, NULL, 'J', 0, 5, 106612),
(56706, '2.0T Style Club限量版', NULL, 4605, 0, NULL, 'J', 0, 5, 106611),
(56705, '3.0SC 奢华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106363),
(56704, '3.0SC 豪华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106362),
(56703, '3.0SC 风华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106361),
(56702, '2.0T 奢华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106351),
(56701, '2.0T 风华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106350),
(56700, '2.0T 豪华版', NULL, 4605, 0, NULL, 'J', 0, 5, 106312),
(56699, 'S-TYPE4.2', NULL, 4604, 0, NULL, 'J', 0, 5, 6486),
(56698, 'S-TYPE3 R 4.2 ', NULL, 4603, 0, NULL, 'J', 0, 5, 6485),
(56697, '3.0', NULL, 4602, 0, NULL, 'J', 0, 5, 109514),
(56695, 'S—TYPE3.0', NULL, 4602, 0, NULL, 'J', 0, 5, 3715),
(56696, 'S-TYPE X 2.5', NULL, 4602, 0, NULL, 'J', 0, 5, 6484),
(56694, 'S—TYPE3.0(典藏版)', NULL, 4601, 0, NULL, 'J', 0, 5, 3729),
(56692, '3.0T V6', NULL, 4600, 0, NULL, 'J', 0, 5, 102594),
(56693, '5.0T V8 5.0T V8 S 中国限量版', NULL, 4600, 0, NULL, 'J', 0, 5, 103862),
(56691, '3.0T V6 S', NULL, 4600, 0, NULL, 'J', 0, 5, 102593),
(56690, '5.0T V8 S', NULL, 4600, 0, NULL, 'J', 0, 5, 102592),
(56689, '3.0T V6 Coupe', NULL, 4599, 0, NULL, 'J', 0, 5, 110719),
(56688, '3.0T V6 S Coupe', NULL, 4599, 0, NULL, 'J', 0, 5, 110718),
(56687, '5.0T V8 R Coupe', NULL, 4599, 0, NULL, 'J', 0, 5, 110717),
(56686, '3.0L 自动', NULL, 4598, 0, NULL, 'J', 0, 5, 10633),
(56685, '2.4L 豪华型 9座', NULL, 4597, 0, NULL, 'J', 0, 5, 10456),
(56684, '2.4L 标准型 9座', NULL, 4597, 0, NULL, 'J', 0, 5, 10455),
(56683, '2.0L 精品型 10座', NULL, 4596, 0, NULL, 'J', 0, 5, 10454),
(56682, '2.0L 豪华型 10座', NULL, 4596, 0, NULL, 'J', 0, 5, 10453),
(56681, '2.0L 标准型 10座', NULL, 4596, 0, NULL, 'J', 0, 5, 10452),
(56680, '海狮经济II型 12座', NULL, 4595, 0, NULL, 'J', 0, 5, 10451),
(56679, '海狮经济Ⅰ型 12座', NULL, 4595, 0, NULL, 'J', 0, 5, 10450),
(56678, '海狮豪华Ⅰ型 12座', NULL, 4595, 0, NULL, 'J', 0, 5, 10449),
(56677, '6400', NULL, 4594, 0, NULL, 'J', 0, 5, 3125),
(56676, '驭风GDQ6500', NULL, 4594, 0, NULL, 'J', 0, 5, 3124),
(56675, '海狮标准型6480', NULL, 4594, 0, NULL, 'J', 0, 5, 3123),
(56674, '海狮实惠Ⅵ型(短鼻)', NULL, 4594, 0, NULL, 'J', 0, 5, 3122),
(56673, '海狮实惠Ⅴ型（短鼻）', NULL, 4594, 0, NULL, 'J', 0, 5, 3121),
(56672, '海狮实惠Ⅳ型（短鼻）', NULL, 4594, 0, NULL, 'J', 0, 5, 3120),
(56671, '海狮实惠Ⅰ型（短鼻）', NULL, 4594, 0, NULL, 'J', 0, 5, 3119),
(56670, '先锋GDQ6470', NULL, 4593, 0, NULL, 'J', 0, 5, 3118),
(56669, '经济型反恐防暴车', NULL, 4593, 0, NULL, 'J', 0, 5, 3117),
(56668, '驭风GDQ6500', NULL, 4593, 0, NULL, 'J', 0, 5, 3116),
(56667, '军刀GDQ6470', NULL, 4593, 0, NULL, 'J', 0, 5, 3115),
(56666, '轻客GDQ6480', NULL, 4593, 0, NULL, 'J', 0, 5, 3114),
(56665, '先锋GDQ6470V33', NULL, 4592, 0, NULL, 'J', 0, 5, 3047),
(56664, '皮卡GDQ1020A1', NULL, 4592, 0, NULL, 'J', 0, 5, 3046),
(56663, '领跑GDQ6488M', NULL, 4592, 0, NULL, 'J', 0, 5, 3045),
(56662, '横行GDQ6488M', NULL, 4592, 0, NULL, 'J', 0, 5, 3044),
(56661, '先锋GDQ6470', NULL, 4592, 0, NULL, 'J', 0, 5, 3043),
(56660, '2.7L 手动 汽油版 旗舰型', NULL, 4591, 0, NULL, 'J', 0, 5, 110229),
(56659, '2.7L 手动 汽油版 经典型', NULL, 4591, 0, NULL, 'J', 0, 5, 110228),
(56658, '2.5L 手动 柴油版 畅享版', NULL, 4591, 0, NULL, 'J', 0, 5, 110225),
(56657, '2.5L 手动 柴油版 畅运版', NULL, 4591, 0, NULL, 'J', 0, 5, 110224),
(56656, '2.7L 手动 汽油版 豪华版', NULL, 4591, 0, NULL, 'J', 0, 5, 110220),
(56655, '2.7L 手动 汽油版 商务型', NULL, 4591, 0, NULL, 'J', 0, 5, 110219),
(56654, '2.4L 手动 汽油版 旗舰型', NULL, 4591, 0, NULL, 'J', 0, 5, 110210),
(56653, '2.4L 手动 汽油版 经典型', NULL, 4591, 0, NULL, 'J', 0, 5, 110209),
(56652, '2.4L 手动 汽油版 畅享型', NULL, 4591, 0, NULL, 'J', 0, 5, 110208),
(56651, '2.4L 手动 汽油版 畅运型', NULL, 4591, 0, NULL, 'J', 0, 5, 110207),
(56650, '2.5L 手动 柴油版 商务型', NULL, 4591, 0, NULL, 'J', 0, 5, 104963),
(56649, '2.5L 手动 柴油版 豪华版', NULL, 4591, 0, NULL, 'J', 0, 5, 104962),
(56648, '2.5L 手动 柴油版 标准型', NULL, 4591, 0, NULL, 'J', 0, 5, 104961),
(56647, '2.4L 手动 汽油版 商务型', NULL, 4591, 0, NULL, 'J', 0, 5, 104960),
(56646, '2.4L 手动 汽油版 豪华版', NULL, 4591, 0, NULL, 'J', 0, 5, 104959),
(56645, '2.4L 手动 汽油版 标准型', NULL, 4591, 0, NULL, 'J', 0, 5, 104958),
(56644, '2.5L 手动 柴油车型-短途客运/单位通勤', NULL, 4590, 0, NULL, 'J', 0, 5, 104955),
(56643, '2.5L 手动 柴油车型-客货两用', NULL, 4590, 0, NULL, 'J', 0, 5, 104954),
(56642, '2.4L 手动 汽油车型-商务接待/单位通勤', NULL, 4590, 0, NULL, 'J', 0, 5, 104953),
(56641, '2.4L 手动 汽油车型-商务接待', NULL, 4590, 0, NULL, 'J', 0, 5, 104952),
(56640, '2.2L 手动 CNG 汽油车型-客货两用', NULL, 4590, 0, NULL, 'J', 0, 5, 104951),
(56639, '2.2L 手动 CNG 汽油车型-短途客运/单位通勤', NULL, 4590, 0, NULL, 'J', 0, 5, 104950),
(56638, '2.2L 手动 汽油车型-客货两用', NULL, 4590, 0, NULL, 'J', 0, 5, 104949),
(56637, '2.0L 手动 VVT 汽油车型-短途客运/单位通勤', NULL, 4590, 0, NULL, 'J', 0, 5, 104948),
(56636, '2.0L 手动 VVT 汽油车型-客货两用', NULL, 4590, 0, NULL, 'J', 0, 5, 104947),
(56635, '2.0L 手动 汽油车型-短途客运/单位通勤', NULL, 4590, 0, NULL, 'J', 0, 5, 104946),
(56634, '2.0L 手动 汽油车型-客货两用', NULL, 4590, 0, NULL, 'J', 0, 5, 104945),
(56633, '柴油版 玉柴创意型 XMQ6530E53(长轴)', NULL, 4589, 0, NULL, 'J', 0, 5, 9549),
(56632, '柴油版 玉柴创意型 XMQ6500E53(短轴)', NULL, 4589, 0, NULL, 'J', 0, 5, 9548),
(56631, '救护车', NULL, 4589, 0, NULL, 'J', 0, 5, 8896),
(56630, '警车/囚车系列（标准型囚车）', NULL, 4589, 0, NULL, 'J', 0, 5, 8895),
(56629, '警车/囚车系列（舒适型警车）', NULL, 4589, 0, NULL, 'J', 0, 5, 8894),
(56628, '警车/囚车系列（标准型警车）', NULL, 4589, 0, NULL, 'J', 0, 5, 8893),
(56627, '厢式运输车系列(平地板厢货)', NULL, 4589, 0, NULL, 'J', 0, 5, 8892),
(56626, '厢式运输车系列(普通地板厢货)', NULL, 4589, 0, NULL, 'J', 0, 5, 8891),
(56625, '舒适型', NULL, 4589, 0, NULL, 'J', 0, 5, 8890),
(56624, '经济型', NULL, 4589, 0, NULL, 'J', 0, 5, 8889),
(56623, '创业型（新）', NULL, 4589, 0, NULL, 'J', 0, 5, 8888),
(56622, '标准型', NULL, 4589, 0, NULL, 'J', 0, 5, 8887),
(56621, 'Y系列 商务王', NULL, 4589, 0, NULL, 'J', 0, 5, 2519),
(56620, 'Y系列 拓展型', NULL, 4589, 0, NULL, 'J', 0, 5, 2518),
(56619, 'Y系列 标准型', NULL, 4589, 0, NULL, 'J', 0, 5, 2517),
(56618, 'Y系列 实力型', NULL, 4589, 0, NULL, 'J', 0, 5, 2516),
(56617, 'Y系列 经济型', NULL, 4589, 0, NULL, 'J', 0, 5, 2515),
(56616, 'Y系列 经典型', NULL, 4589, 0, NULL, 'J', 0, 5, 2514),
(56615, 'G系列 标准型G', NULL, 4589, 0, NULL, 'J', 0, 5, 2513),
(56614, 'G系列 实力型G', NULL, 4589, 0, NULL, 'J', 0, 5, 2512),
(56613, 'R系列 进口豪华型', NULL, 4589, 0, NULL, 'J', 0, 5, 2511),
(56612, 'R系列 进口标准型', NULL, 4589, 0, NULL, 'J', 0, 5, 2510),
(56611, 'GM系列 4G24实力型', NULL, 4589, 0, NULL, 'J', 0, 5, 2509),
(56610, 'GM系列 4G24标准型', NULL, 4589, 0, NULL, 'J', 0, 5, 2508),
(56609, '4RB2系列 豪华型', NULL, 4588, 0, NULL, 'J', 0, 5, 16548),
(56608, '4RB2系列 商务型', NULL, 4588, 0, NULL, 'J', 0, 5, 16547),
(56607, '标准版 豪华型  XMQ6520E3 (11座长轴中顶)', NULL, 4588, 0, NULL, 'J', 0, 5, 12904),
(56606, '标准版 经典型  XMQ6520E3 (11座长轴中顶)', NULL, 4588, 0, NULL, 'J', 0, 5, 12903),
(56605, '汽油版 创业型 XMQ6520E3 (长轴中顶)', NULL, 4588, 0, NULL, 'J', 0, 5, 12902),
(56604, '汽油版 创业型 XMQ6520E3 (短轴平顶)', NULL, 4588, 0, NULL, 'J', 0, 5, 12901),
(56603, '柴油版 玉柴创业型 XMQ6530E53(长轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9557),
(56602, '柴油版 玉柴创业型 XMQ6500E53(短轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9556),
(56601, '柴油版 长城创意型 XMQ6530E73(长轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9555),
(56600, '柴油版 长城创意型 XMQ6500E73(短轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9554),
(56599, '柴油版 长城创享型 XMQ6530E73', NULL, 4587, 0, NULL, 'J', 0, 5, 9553),
(56598, '柴油版 玉柴创享型 XMQ6530E53', NULL, 4587, 0, NULL, 'J', 0, 5, 9552),
(56597, '柴油版 长城创业型 XMQ6530E73(长轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9551),
(56596, '柴油版 长城创业型 XMQ6500E73(短轴)', NULL, 4587, 0, NULL, 'J', 0, 5, 9550),
(56595, '1.5L 手动 豪华型', NULL, 4586, 0, NULL, 'J', 0, 5, 102524),
(56594, '1.5L 手动 精英型', NULL, 4586, 0, NULL, 'J', 0, 5, 100012),
(56593, '1.5L 手动 舒适版', NULL, 4586, 0, NULL, 'J', 0, 5, 100011),
(56592, '1.5L 手动 时尚型', NULL, 4586, 0, NULL, 'J', 0, 5, 100010),
(56591, '1.5L 手自一体 精英型', NULL, 4585, 0, NULL, 'J', 0, 5, 111149),
(56590, '1.5L 手自一体 豪华型', NULL, 4585, 0, NULL, 'J', 0, 5, 111148),
(56589, '1.5L 手动 舒适版', NULL, 4585, 0, NULL, 'J', 0, 5, 106176),
(56588, '1.5L 手动 精英型', NULL, 4585, 0, NULL, 'J', 0, 5, 106175),
(56587, '1.5L 手动 豪华型', NULL, 4585, 0, NULL, 'J', 0, 5, 106174),
(56586, '2.2L 手动 V22汽油豪华型', NULL, 4584, 0, NULL, 'J', 0, 5, 106287),
(56585, '2.0L 手动 V19汽油舒适型', NULL, 4584, 0, NULL, 'J', 0, 5, 106286),
(56584, '2.0L 手动 V19汽油豪华型', NULL, 4584, 0, NULL, 'J', 0, 5, 106285),
(56583, '2.2L 手动 V22汽油豪华型', NULL, 4583, 0, NULL, 'J', 0, 5, 110478),
(56582, '2.0L 手动 V19汽油豪华型', NULL, 4583, 0, NULL, 'J', 0, 5, 110477),
(56581, '1.3L 手动 豪华型', NULL, 4582, 0, NULL, 'J', 0, 5, 104917),
(56580, '1.3L 手动 舒适型', NULL, 4582, 0, NULL, 'J', 0, 5, 104916),
(56579, '1.3L 手动 标准型', NULL, 4582, 0, NULL, 'J', 0, 5, 104596),
(56578, '汽油版 2.2L 手动 豪华型 短厢短轴 SY1028HQ42', NULL, 4581, 0, NULL, 'J', 0, 5, 16037),
(56577, '汽油版 2.2L 手动 简配型 短厢短轴 SY1028HQ42', NULL, 4581, 0, NULL, 'J', 0, 5, 16036),
(56576, '汽油版 2.2L 手动 豪华型 长厢长轴 SY1028HQ42C', NULL, 4581, 0, NULL, 'J', 0, 5, 16035),
(56575, '汽油版 2.2L 手动 简配型 长厢长轴 SY1028HQ42C', NULL, 4581, 0, NULL, 'J', 0, 5, 16034),
(56574, '柴油版 3.2L 手动 简配型 长厢长轴 SY1028HC31C', NULL, 4581, 0, NULL, 'J', 0, 5, 16033),
(56573, '柴油版 3.2L 手动 豪华型 长厢长轴 SY1028HC31C', NULL, 4581, 0, NULL, 'J', 0, 5, 16032),
(56572, '柴油版 3.2L 手动 简配型 短厢短轴 SY1028HC31', NULL, 4581, 0, NULL, 'J', 0, 5, 16031),
(56571, '柴油版 3.2L 手动 豪华型 短厢短轴 SY1028HC31', NULL, 4581, 0, NULL, 'J', 0, 5, 16030),
(56570, '劲酷版 2.2L 手动 长厢长轴 SY1028HC33C', NULL, 4581, 0, NULL, 'J', 0, 5, 16029),
(56569, '劲酷版 2.2L 手动 短厢短轴 SY1028HC33', NULL, 4581, 0, NULL, 'J', 0, 5, 16028),
(56568, '3.2L 手动 两驱 加长版 柴油', NULL, 4581, 0, NULL, 'J', 0, 5, 14796),
(56567, '3.2L 手动 两驱 普通版 柴油', NULL, 4581, 0, NULL, 'J', 0, 5, 14795),
(56566, '2.5T 柴油 D25 长轴', NULL, 4580, 0, NULL, 'J', 0, 5, 106498),
(56565, '2.5T 柴油 D25 短轴', NULL, 4580, 0, NULL, 'J', 0, 5, 106497),
(56564, 'JM491Q-ME CNG双燃料  两驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110381),
(56563, 'JM491Q-ME CNG双燃料  两驱 长轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110380),
(56562, 'JM491Q-ME  汽油 四驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110379),
(56561, 'JM491Q-ME  汽油 四驱 长轴 ', NULL, 4579, 0, NULL, 'J', 0, 5, 110378),
(56560, 'JM491Q-ME  汽油 两驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110377),
(56559, 'JM491Q-ME  汽油 两驱 长轴 ', NULL, 4579, 0, NULL, 'J', 0, 5, 110376),
(56558, 'D25 2.5T 柴油 两驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110375),
(56557, 'D25 2.5T 柴油 两驱 长轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110374),
(56556, 'D22 2.2T 柴油 四驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110373),
(56555, 'D22 2.2T 柴油 四驱 长轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110372),
(56554, 'D22 2.2T 柴油 两驱 短轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110371),
(56553, 'D22 2.2T 柴油 两驱 长轴', NULL, 4579, 0, NULL, 'J', 0, 5, 110370),
(56552, '2.8L 手动 柴油版 标准型', NULL, 4578, 0, NULL, 'J', 0, 5, 14794),
(56551, '2.8L 手动 柴油版 豪华型', NULL, 4578, 0, NULL, 'J', 0, 5, 14793),
(56550, '2.2L 手动 汽油版 豪华型', NULL, 4578, 0, NULL, 'J', 0, 5, 1401),
(56549, '2.2L 手动 汽油版 标准型', NULL, 4578, 0, NULL, 'J', 0, 5, 1400),
(56548, '2.2L 手动 豪华型 长厢长轴 SY1026LQ42C', NULL, 4577, 0, NULL, 'J', 0, 5, 16044),
(56547, '2.2L 手动 标准型 长厢长轴 SY1026LQ42C', NULL, 4577, 0, NULL, 'J', 0, 5, 16043),
(56546, '2.2L 手动 经济型 长厢长轴 SY1026LQ42C', NULL, 4577, 0, NULL, 'J', 0, 5, 16042),
(56545, '2.2L 手动 豪华型 短厢短轴 SY1026LQ42', NULL, 4577, 0, NULL, 'J', 0, 5, 16041),
(56544, '2.2L 手动 标准型 短厢短轴 SY1026LQ42', NULL, 4577, 0, NULL, 'J', 0, 5, 16040),
(56543, '2.2L 手动 经济型 短厢短轴 SY1026LQ42', NULL, 4577, 0, NULL, 'J', 0, 5, 16039),
(56542, '2.2L汽油 经济型 长轴', NULL, 4576, 0, NULL, 'J', 0, 5, 110394),
(56541, '2.2L汽油 经济型 短轴', NULL, 4576, 0, NULL, 'J', 0, 5, 110393),
(56540, '2.2L汽油 标准型 长轴', NULL, 4576, 0, NULL, 'J', 0, 5, 110392),
(56539, '2.2L汽油 标准型 短轴', NULL, 4576, 0, NULL, 'J', 0, 5, 110391),
(56538, '2.8L 手动 柴油版 豪华型', NULL, 4575, 0, NULL, 'J', 0, 5, 14801),
(56537, '2.8L 手动 柴油版 标准型', NULL, 4575, 0, NULL, 'J', 0, 5, 14800),
(56536, '2.1L 柴油 手动 舒适型 长厢长轴 SY1023EC36C', NULL, 4574, 0, NULL, 'J', 0, 5, 16006),
(56535, '2.1L 手动 舒适型 柴油 短厢长轴 SY1023EC36C', NULL, 4574, 0, NULL, 'J', 0, 5, 16005),
(56534, '2.1L 手动 舒适型 柴油 长厢短轴 SY1023EC36', NULL, 4574, 0, NULL, 'J', 0, 5, 16004),
(56533, '2.1L 手动 舒适型 柴油 短厢短轴 SY1023EC36', NULL, 4574, 0, NULL, 'J', 0, 5, 16003),
(56532, '手动汽油 标准型 SY1023SHN', NULL, 4574, 0, NULL, 'J', 0, 5, 14792),
(56531, '手动汽油 豪华型 SY1026', NULL, 4574, 0, NULL, 'J', 0, 5, 14791),
(56530, '2.1L 加长厢 豪华型', NULL, 4574, 0, NULL, 'J', 0, 5, 14784),
(56529, '2.1L 加长厢 标准型', NULL, 4574, 0, NULL, 'J', 0, 5, 14783),
(56528, '2.5L 加长厢 豪华型', NULL, 4574, 0, NULL, 'J', 0, 5, 14782),
(56527, '2.1L 标准厢 豪华型', NULL, 4574, 0, NULL, 'J', 0, 5, 14781),
(56526, '2.1L 标准厢 标准型', NULL, 4574, 0, NULL, 'J', 0, 5, 14780),
(56525, '2.5L 加长厢 标准型', NULL, 4574, 0, NULL, 'J', 0, 5, 14779),
(56524, '2.5L 标准厢 豪华型', NULL, 4574, 0, NULL, 'J', 0, 5, 14778),
(56523, '2.5L 标准厢 标准型', NULL, 4574, 0, NULL, 'J', 0, 5, 14777),
(56522, '2.2L 手动 舒适型 汽油 长厢长轴 SY1023KQ42CL', NULL, 4573, 0, NULL, 'J', 0, 5, 16027),
(56521, '2.2L 手动 舒适型 汽油 短厢长轴 SY1023KQ42CL', NULL, 4573, 0, NULL, 'J', 0, 5, 16026),
(56520, '2.2L 手动 豪华型 汽油 短厢长轴 SY1023KQ42CL', NULL, 4573, 0, NULL, 'J', 0, 5, 16025),
(56519, '2.2L 手动 豪华型 汽油 长厢长轴 SY1023KQ42CL', NULL, 4573, 0, NULL, 'J', 0, 5, 16024),
(56518, '2.2L 手动 豪华型 汽油 短厢短轴 SY1023KQ42L', NULL, 4573, 0, NULL, 'J', 0, 5, 16021),
(56517, '2.2L 手动 舒适型 汽油 长厢短轴 SY1023KQ42L', NULL, 4573, 0, NULL, 'J', 0, 5, 16020),
(56516, '2.2L 手动 豪华型 汽油 长厢短轴 SY1023KQ42L', NULL, 4573, 0, NULL, 'J', 0, 5, 16017),
(56515, '2.2L 手动 舒适型 汽油 短厢短轴 SY1023KQ42L', NULL, 4573, 0, NULL, 'J', 0, 5, 16016),
(56514, '2.2L 手动 豪华型 汽油 长厢长轴 SY1023KQ42C', NULL, 4573, 0, NULL, 'J', 0, 5, 16015),
(56513, '2.2L 手动 豪华型 汽油 短厢长轴 SY1023KQ42C', NULL, 4573, 0, NULL, 'J', 0, 5, 16014),
(56512, '2.2L 手动 舒适型 汽油 长厢长轴 SY1023KQ42C', NULL, 4573, 0, NULL, 'J', 0, 5, 16013),
(56511, '2.2L 手动 舒适型 汽油 短厢长轴 SY1023KQ42C', NULL, 4573, 0, NULL, 'J', 0, 5, 16011),
(56510, '2.2L 手动 豪华型 汽油 短厢短轴 SY1023KQ42', NULL, 4573, 0, NULL, 'J', 0, 5, 16010),
(56509, '2.2L 手动 豪华型 汽油 长厢短轴 SY1023KQ42', NULL, 4573, 0, NULL, 'J', 0, 5, 16009),
(56508, '2.2L 手动 舒适型 汽油 长厢短轴 SY1023KQ42', NULL, 4573, 0, NULL, 'J', 0, 5, 16008),
(56507, '2.2L 手动 舒适型 汽油 短厢短轴 SY1023KQ42', NULL, 4573, 0, NULL, 'J', 0, 5, 16007),
(56506, '2.0L 短轴短厢 SY1023KC35', NULL, 4573, 0, NULL, 'J', 0, 5, 14788),
(56505, '2.0L 短轴长厢 SY1023KC35', NULL, 4573, 0, NULL, 'J', 0, 5, 14787),
(56504, '2.5L 长轴长厢 SY1023KC35C', NULL, 4573, 0, NULL, 'J', 0, 5, 14786),
(56503, '2.5L 长轴短厢 SY1023KC35C', NULL, 4573, 0, NULL, 'J', 0, 5, 14785),
(56502, '2.0L 长轴长厢 SY1023KC35C', NULL, 4573, 0, NULL, 'J', 0, 5, 14776),
(56501, '2.0L 长轴短厢 SY1023KC35C', NULL, 4573, 0, NULL, 'J', 0, 5, 14775),
(56500, '2.5L 短轴长厢 SY1023KC35', NULL, 4573, 0, NULL, 'J', 0, 5, 14774),
(56499, '2.5L 短轴短厢 SY1023KC35', NULL, 4573, 0, NULL, 'J', 0, 5, 14773),
(56498, '009 2.2L豪华型  双燃料 短轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110390),
(56497, '009 2.2L豪华型  双燃料 长轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110389),
(56496, '009 2.2L舒适型 汽油 短轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110388),
(56495, '009 2.2L舒适型 汽油 长轴 ', NULL, 4572, 0, NULL, 'J', 0, 5, 110387),
(56494, '009 2.2T豪华型 柴油 短轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110386),
(56493, '009 2.2T豪华型 柴油 长轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110385),
(56492, '009 4D25U四达舒适型 短轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110384),
(56491, '009 4D25U四达舒适型 长轴', NULL, 4572, 0, NULL, 'J', 0, 5, 110382),
(56490, '2.4L 自动 四驱 舒适型', NULL, 4571, 0, NULL, 'J', 0, 5, 14613),
(56489, '2.4L 自动 舒适型', NULL, 4571, 0, NULL, 'J', 0, 5, 14612),
(56488, '2.4L 手动 四驱 舒适型', NULL, 4571, 0, NULL, 'J', 0, 5, 14611),
(56487, '2.4L 手动 舒适型', NULL, 4571, 0, NULL, 'J', 0, 5, 14610),
(56486, '2.4L 手动 标准型', NULL, 4571, 0, NULL, 'J', 0, 5, 14609),
(56485, '2.0L 手动 舒适型', NULL, 4571, 0, NULL, 'J', 0, 5, 14608),
(56484, '2.0L 手动 标准型', NULL, 4571, 0, NULL, 'J', 0, 5, 14607),
(56483, 'SY6390豪华型', NULL, 4570, 0, NULL, 'J', 0, 5, 9626),
(56482, 'SY6390标准型', NULL, 4570, 0, NULL, 'J', 0, 5, 9625),
(56481, 'SY6390基本型', NULL, 4570, 0, NULL, 'J', 0, 5, 9624),
(56480, 'T22 1.0L 手动 标准型', NULL, 4569, 0, NULL, 'J', 0, 5, 101157),
(56479, 'T20 XC4F18-T 标准型', NULL, 4569, 0, NULL, 'J', 0, 5, 14917),
(56478, 'A9 XC4F18-F 豪华型', NULL, 4569, 0, NULL, 'J', 0, 5, 14916),
(56477, 'A9 XC4F18-F 标准型', NULL, 4569, 0, NULL, 'J', 0, 5, 14915),
(56476, 'A9 XC4F18-F 限量版', NULL, 4569, 0, NULL, 'J', 0, 5, 14914),
(56475, 'A7 XC4F18-T 标准型', NULL, 4569, 0, NULL, 'J', 0, 5, 14913),
(56474, 'A7 DL465Q5 限量版', NULL, 4569, 0, NULL, 'J', 0, 5, 14912),
(56473, 'T22 1.0L 手动 标准型', NULL, 4568, 0, NULL, 'J', 0, 5, 102697),
(56472, 'T20 1.0L 手动 标准型Ⅱ', NULL, 4568, 0, NULL, 'J', 0, 5, 102696),
(56471, 'T20 1.0L 手动 标准型', NULL, 4568, 0, NULL, 'J', 0, 5, 102695),
(56470, 'A9 1.0L 豪华型', NULL, 4568, 0, NULL, 'J', 0, 5, 102694),
(56469, 'A9 1.0L 标准版Ⅱ', NULL, 4568, 0, NULL, 'J', 0, 5, 102693),
(56468, 'A9 1.0L 限量版Ⅱ', NULL, 4568, 0, NULL, 'J', 0, 5, 102692),
(56467, 'A9 1.0L 标准版', NULL, 4568, 0, NULL, 'J', 0, 5, 102691),
(56466, 'A9 1.0L 限量版', NULL, 4568, 0, NULL, 'J', 0, 5, 102689),
(56465, 'A7 1.0L 手动 轻劲版 柴油', NULL, 4568, 0, NULL, 'J', 0, 5, 102688),
(56464, 'A7 1.0L 手动 标准型Ⅱ 柴油', NULL, 4568, 0, NULL, 'J', 0, 5, 102687),
(56463, 'A7 1.0L 手动 限量版 柴油', NULL, 4568, 0, NULL, 'J', 0, 5, 102686),
(56462, 'A7 1.0L 手动 轻劲版', NULL, 4568, 0, NULL, 'J', 0, 5, 102685),
(56461, 'A7 1.0L 手动 标准型Ⅱ', NULL, 4568, 0, NULL, 'J', 0, 5, 102684),
(56460, 'A7 1.0L 手动 限量版', NULL, 4568, 0, NULL, 'J', 0, 5, 102683),
(56459, 'A7 1.0L 手动 标准型', NULL, 4568, 0, NULL, 'J', 0, 5, 102682),
(56458, 'A7 1.0L 手动 特惠型', NULL, 4568, 0, NULL, 'J', 0, 5, 102680),
(56457, '畅领系列尊贵型', NULL, 4567, 0, NULL, 'J', 0, 5, 10397),
(56456, '畅领系列豪华型', NULL, 4567, 0, NULL, 'J', 0, 5, 7186),
(56455, '畅领系列标准型', NULL, 4567, 0, NULL, 'J', 0, 5, 7185),
(56454, '大海狮翔龙 2.4 4RB2(国IV) 经典型', NULL, 4566, 0, NULL, 'J', 0, 5, 11955),
(56453, '商务 4G22D4(国III+EOBD) 豪华型', NULL, 4566, 0, NULL, 'J', 0, 5, 11948),
(56452, '商务 4G22D4(国III+EOBD) 标准型', NULL, 4566, 0, NULL, 'J', 0, 5, 11947),
(56451, '畅意2.0U经典型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9776),
(56450, '畅意2.0U标准型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9775),
(56449, '畅行2.0U经济型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9774),
(56448, '畅行2.0U经典型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9773),
(56447, '畅享2.0U经典型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9772),
(56446, '畅享2.0U标准型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9771),
(56445, '畅享2.0U豪华型(欧Ⅳ)', NULL, 4566, 0, NULL, 'J', 0, 5, 9770),
(56444, '畅行 2.0L 经典型 国四 半高顶 6座', NULL, 4565, 0, NULL, 'J', 0, 5, 101301),
(56443, '畅享 2.0L 经典型 国四 半高顶 11座', NULL, 4565, 0, NULL, 'J', 0, 5, 101300),
(56442, '畅领 2.4L 标准型 国四 半高顶 11座', NULL, 4565, 0, NULL, 'J', 0, 5, 101299),
(56441, '畅领 2.4L 豪华型 国四 半高顶 11座', NULL, 4565, 0, NULL, 'J', 0, 5, 101298),
(56440, '翔龙 2.0L 经典型 国四 半高顶 6座2', NULL, 4565, 0, NULL, 'J', 0, 5, 101297),
(56439, '翔龙 2.0L 经典型 国四 半高顶 6座', NULL, 4565, 0, NULL, 'J', 0, 5, 101296),
(56438, '翔龙 2.2L 经典型 国四 半高顶 14座', NULL, 4565, 0, NULL, 'J', 0, 5, 101295),
(56437, '翔龙 2.4L 标准型 国四 半高顶 14座', NULL, 4565, 0, NULL, 'J', 0, 5, 101294),
(56436, '2.0L 畅行系列经济型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14729),
(56435, '2.0L 畅意系列经典型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14728),
(56434, '2.0L 畅行系列经济型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14727),
(56433, '2.0L 畅意系列经典型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14726),
(56432, '2.0L 畅享系列豪华型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14725),
(56431, '2.0L 畅享系列标准型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14724),
(56430, '2.0L 畅享系列经典型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14723),
(56429, '2.0L 畅行系列经典型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14720),
(56428, '2.0L 畅意系列标准型 欧4', NULL, 4565, 0, NULL, 'J', 0, 5, 14719),
(56427, '2.4L 畅领系列尊贵型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14718),
(56426, '2.4L 畅领系列豪华型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14716),
(56425, '2.4L 畅领系列标准型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14715),
(56424, '2.2L 畅享系列豪华型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14713),
(56423, '2.2L 畅享系列标准型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14712),
(56422, '2.0L 畅享系列经典型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14711),
(56421, '2.0L 畅行系列经典型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14710),
(56420, '2.0L 畅意系列标准型 欧3', NULL, 4565, 0, NULL, 'J', 0, 5, 14709),
(56419, '翔龙 2.4L 标准型 国IV 半高顶 14座', NULL, 4564, 0, NULL, 'J', 0, 5, 105265),
(56418, '翔龙 2.2L 经典型 国IV 半高顶 14座', NULL, 4564, 0, NULL, 'J', 0, 5, 105264),
(56417, '翔龙 2.0L 经典型 国IV 半高顶 6座', NULL, 4564, 0, NULL, 'J', 0, 5, 105263),
(56416, '畅领 2.4L 豪华型 国IV 半高顶 11座', NULL, 4564, 0, NULL, 'J', 0, 5, 105262),
(56415, '畅领 2.4L 标准型 国IV 半高顶 11座', NULL, 4564, 0, NULL, 'J', 0, 5, 105261),
(56414, '畅享 2.0L 经典型 国IV 半高顶 11座', NULL, 4564, 0, NULL, 'J', 0, 5, 105260),
(56413, '畅行 2.0L 经典型 国IV 半高顶 6座', NULL, 4564, 0, NULL, 'J', 0, 5, 105259),
(56412, '翔龙 2.0L 经典型 国V 14座', NULL, 4564, 0, NULL, 'J', 0, 5, 105258),
(56411, '翔龙 2.0L 经典型 国V 6座', NULL, 4564, 0, NULL, 'J', 0, 5, 105257),
(56410, 'SY6480A1B—ME', NULL, 4563, 0, NULL, 'J', 0, 5, 11689),
(56409, '城市精英2.2 9座', NULL, 4563, 0, NULL, 'J', 0, 5, 10398),
(56408, 'SY6480A2F-E', NULL, 4563, 0, NULL, 'J', 0, 5, 6167),
(56407, '商务型', NULL, 4562, 0, NULL, 'J', 0, 5, 6020),
(56406, '豪华型', NULL, 4562, 0, NULL, 'J', 0, 5, 1307),
(56405, '标准型', NULL, 4562, 0, NULL, 'J', 0, 5, 1306);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(56404, '实用型Ⅱ', NULL, 4562, 0, NULL, 'J', 0, 5, 1305),
(56403, '实用型Ⅰ', NULL, 4562, 0, NULL, 'J', 0, 5, 1304),
(56402, '优越者SY5031XJH—BC（P）', NULL, 4562, 0, NULL, 'J', 0, 5, 1296),
(56401, '优越者SY5031XQC—BC（P）', NULL, 4562, 0, NULL, 'J', 0, 5, 1295),
(56400, '优越者SY6480BC（P）', NULL, 4562, 0, NULL, 'J', 0, 5, 1294),
(56399, '优越者SY6480BCH', NULL, 4562, 0, NULL, 'J', 0, 5, 1293),
(56398, '优越者SY6500BCM（H）', NULL, 4562, 0, NULL, 'J', 0, 5, 1292),
(56397, '领航者SY6480B3C', NULL, 4562, 0, NULL, 'J', 0, 5, 1291),
(56396, '领航者SY6480B3C（H）', NULL, 4562, 0, NULL, 'J', 0, 5, 1290),
(56395, '超级领航者SY5031XJH—B2C', NULL, 4561, 0, NULL, 'J', 0, 5, 1303),
(56394, '超级领航者SY5031XJH—B2C（P）', NULL, 4561, 0, NULL, 'J', 0, 5, 1302),
(56393, '超级领航者SY5031XQC—B2C', NULL, 4561, 0, NULL, 'J', 0, 5, 1301),
(56392, '超级领航者SY6480B2C', NULL, 4561, 0, NULL, 'J', 0, 5, 1300),
(56391, '超级领航者SY6480B2C（H）', NULL, 4561, 0, NULL, 'J', 0, 5, 1299),
(56390, '超级领航者SY6500B2C（H）', NULL, 4561, 0, NULL, 'J', 0, 5, 1298),
(56389, '超级领航者SY6500B2C（S）', NULL, 4561, 0, NULL, 'J', 0, 5, 1297),
(56388, '锐驰2.2新动力 商务型', NULL, 4560, 0, NULL, 'J', 0, 5, 5521),
(56387, '锐驰2.2系列 豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 5520),
(56386, '锐驰2.2系列 标准型', NULL, 4560, 0, NULL, 'J', 0, 5, 5443),
(56385, '锐驰2.2系列 经济型', NULL, 4560, 0, NULL, 'J', 0, 5, 5441),
(56384, '2.2 新经典型', NULL, 4560, 0, NULL, 'J', 0, 5, 1383),
(56383, '2.2 标准型', NULL, 4560, 0, NULL, 'J', 0, 5, 1382),
(56382, '2.2 商务型', NULL, 4560, 0, NULL, 'J', 0, 5, 1380),
(56381, '2.4 经典型', NULL, 4560, 0, NULL, 'J', 0, 5, 1379),
(56380, '2.4 商务型', NULL, 4560, 0, NULL, 'J', 0, 5, 1378),
(56379, '三菱动力版 经典型', NULL, 4560, 0, NULL, 'J', 0, 5, 1377),
(56378, '三菱动力版 商务型', NULL, 4560, 0, NULL, 'J', 0, 5, 1376),
(56377, '2.4三菱动力版 旗舰型', NULL, 4560, 0, NULL, 'J', 0, 5, 1372),
(56376, '2.4三菱动力版 超豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 1371),
(56375, '三菱动力 4G64(国Ⅲ) 豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 1370),
(56374, '2.4旗舰型', NULL, 4560, 0, NULL, 'J', 0, 5, 1369),
(56373, '2.4超豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 1368),
(56372, '2.4豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 1367),
(56371, '2.2旗舰型', NULL, 4560, 0, NULL, 'J', 0, 5, 1366),
(56370, '2.2超豪华型', NULL, 4560, 0, NULL, 'J', 0, 5, 1365),
(56369, '2.2 新动力商务型', NULL, 4559, 0, NULL, 'J', 0, 5, 1385),
(56368, '2.2 经济型', NULL, 4559, 0, NULL, 'J', 0, 5, 1384),
(56367, '城市快运2.2经典型(欧Ⅲ)', NULL, 4559, 0, NULL, 'J', 0, 5, 1308),
(56366, '城市快运2.2标准型(欧Ⅲ)', NULL, 4559, 0, NULL, 'J', 0, 5, 1281),
(56365, '城市快运2.2豪华型(欧Ⅲ)', NULL, 4559, 0, NULL, 'J', 0, 5, 1280),
(56364, '畅享系列豪华型', NULL, 4558, 0, NULL, 'J', 0, 5, 7184),
(56363, '畅享系列标准型', NULL, 4558, 0, NULL, 'J', 0, 5, 7183),
(56362, '畅享系列经典型', NULL, 4558, 0, NULL, 'J', 0, 5, 7182),
(56361, '畅行系列经典型', NULL, 4558, 0, NULL, 'J', 0, 5, 7181),
(56360, '畅意系列标准型', NULL, 4558, 0, NULL, 'J', 0, 5, 7180),
(56359, '丰田动力2.4旗舰型', NULL, 4558, 0, NULL, 'J', 0, 5, 6025),
(56358, '丰田动力2.4豪华型', NULL, 4558, 0, NULL, 'J', 0, 5, 6024),
(56357, '汽油系列三菱动力2.4(商务型)', NULL, 4558, 0, NULL, 'J', 0, 5, 6023),
(56356, 'OBD系列新动力2.4（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6022),
(56355, 'OBD系列新动力2.4（普通型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6021),
(56354, '动力王2.2豪华型', NULL, 4558, 0, NULL, 'J', 0, 5, 6019),
(56353, '欧Ⅳ系列动力王2.0（商务型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6018),
(56352, 'OBD系列动力王2.0（豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6017),
(56351, 'OBD系列动力王2.0（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6016),
(56350, 'OBD系列动力王2.0（经典型）', NULL, 4558, 0, NULL, 'J', 0, 5, 6015),
(56349, '柴油快运 超豪华型(欧II)', NULL, 4558, 0, NULL, 'J', 0, 5, 1314),
(56348, '柴油快运（豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1313),
(56347, '汽油系列快运2.0（豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1312),
(56346, '柴油快运（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1311),
(56345, '柴油快运（经典型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1310),
(56344, '汽油系列快运2.0（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1309),
(56343, '汽油系列动力王2.0（豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1289),
(56342, '汽油系列动力王2.0（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1288),
(56341, '汽油系列动力王2.0（经典型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1287),
(56340, '欧Ⅳ系列动力王2.0（超豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1286),
(56339, '欧Ⅳ系列动力王2.0（豪华型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1285),
(56338, '欧Ⅳ系列动力王2.0（舒适型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1284),
(56337, '欧Ⅳ系列动力王2.0（标准型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1283),
(56336, '欧Ⅳ系列动力王2.0（经典型）', NULL, 4558, 0, NULL, 'J', 0, 5, 1282),
(56335, '动力王2.2商务型', NULL, 4558, 0, NULL, 'J', 0, 5, 1279),
(56334, '快运 V20 (国IV) 豪华型', NULL, 4557, 0, NULL, 'J', 0, 5, 11940),
(56333, '快运 V20 (国IV) 标准型', NULL, 4557, 0, NULL, 'J', 0, 5, 11939),
(56332, '快运 V20 (国IV) 经典型', NULL, 4557, 0, NULL, 'J', 0, 5, 11938),
(56331, '快运 V20 (国IV) 经济型', NULL, 4557, 0, NULL, 'J', 0, 5, 11937),
(56330, '快运 V19 (国IV) 经济型', NULL, 4557, 0, NULL, 'J', 0, 5, 5434),
(56329, '快运 V19 (国IV) 豪华型', NULL, 4557, 0, NULL, 'J', 0, 5, 5433),
(56328, '快运 V19 (国IV) 标准型', NULL, 4557, 0, NULL, 'J', 0, 5, 5431),
(56327, '快运 V19 (国IV) 经典型', NULL, 4557, 0, NULL, 'J', 0, 5, 5430),
(56326, 'H2L 商务 旗舰型', NULL, 4556, 0, NULL, 'J', 0, 5, 12338),
(56325, 'H2L 商务 豪华型', NULL, 4556, 0, NULL, 'J', 0, 5, 12337),
(56324, 'H2L 快运 标准型', NULL, 4556, 0, NULL, 'J', 0, 5, 12336),
(56323, '动力王 2.4L 豪华型 国IV 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 105277),
(56322, '翔运 2.4L 旗舰型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 104402),
(56321, '2.4L 手动 厢式运输 动力王 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 102423),
(56320, '2.0L 手动 厢式运输 快运 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 102421),
(56319, '新快运 2.0L u-m 标准型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101351),
(56318, '新快运 2.0L u-m 标准型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101350),
(56317, '新快运 2.0L u-m 豪华型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101349),
(56316, '新快运 2.0L u-m 豪华型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101348),
(56315, '新快运 2.0L u-x 标准型 国四 高顶 11座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101347),
(56314, '新快运 2.0L u-x 标准型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101346),
(56313, '新快运 2.0L u-x 标准型 国四 标准顶 6座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101345),
(56312, '新快运 2.0L u-x 标准型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101344),
(56311, '新快运 2.0L u-x 豪华型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101343),
(56310, '新快运 2.0L u-x 豪华型 国四 高顶 11座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101342),
(56309, '新快运 2.0L u-x 豪华型 国四 标准顶 6座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101341),
(56308, '新快运 2.0L u-x 豪华型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101340),
(56307, '快运 2.0L u 经典型 国四 高顶 11座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101339),
(56306, '快运 2.0L u 经典型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101338),
(56305, '快运 2.0L u 经典型 国四 标准顶 6座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101337),
(56304, '快运 2.0L u 经典型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101336),
(56303, '快运 2.0L u 豪华型 国四 高顶 11座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101335),
(56302, '快运 2.0L u 豪华型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101334),
(56301, '快运 2.0L u 豪华型 国四 标准顶 6座2', NULL, 4555, 0, NULL, 'J', 0, 5, 101333),
(56300, '快运 2.0L u 豪华型 国四 标准顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101332),
(56299, '动力王 2.0L 经典型 国四 高顶 9座', NULL, 4555, 0, NULL, 'J', 0, 5, 101329),
(56298, '动力王 2.0L 舒适型 国四 高顶 9座', NULL, 4555, 0, NULL, 'J', 0, 5, 101326),
(56297, '动力王 2.0L 豪华型 国四 高顶 9座', NULL, 4555, 0, NULL, 'J', 0, 5, 101324),
(56296, '动力王 2.2L 豪华型 国四 高顶 9座', NULL, 4555, 0, NULL, 'J', 0, 5, 101322),
(56295, '动力王 2.4L 豪华型 国四 高顶 9座', NULL, 4555, 0, NULL, 'J', 0, 5, 101320),
(56294, '动力王 2.4L 豪华型 国四 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101319),
(56293, '柴油创业版 2.5L 经典型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101318),
(56292, '柴油创业版 2.5L 经典型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101317),
(56291, '柴油创业版 2.5L 标准型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101316),
(56290, '柴油创业版 2.5L 标准型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101315),
(56289, '柴油创业版 2.5L 豪华型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101314),
(56288, '柴油创业版 2.5L 豪华型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101313),
(56287, '柴油财富版 2.5L 经典型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101312),
(56286, '柴油财富版 2.5L 经典型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101311),
(56285, '柴油财富版 2.5L 标准型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101310),
(56284, '柴油财富版 2.5L 标准型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101309),
(56283, '柴油财富版 2.5L 豪华型 国三 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101308),
(56282, '柴油财富版 2.5L 豪华型 国三 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101307),
(56281, '翔运 2.0L 经典型 国四 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101306),
(56280, '翔运 2.0L 舒适型 国四 高顶 6座', NULL, 4555, 0, NULL, 'J', 0, 5, 101305),
(56279, '翔运 2.0L 豪华型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101304),
(56278, '翔运 2.4L 豪华型 国四 高顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 101303),
(56277, '动力王 2.2L 豪华型 国四 标准顶 11座', NULL, 4555, 0, NULL, 'J', 0, 5, 15358),
(56276, '2.0L 欧4系列动力王 商务型', NULL, 4555, 0, NULL, 'J', 0, 5, 14752),
(56275, '2.0L 欧4系列动力王 超豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14751),
(56274, '2.0L 欧4系列动力王 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14750),
(56273, '2.0L 欧4系列动力王 舒适型', NULL, 4555, 0, NULL, 'J', 0, 5, 14749),
(56272, '2.0L 欧4系列动力王 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14748),
(56271, '2.0L 欧4系列动力王 经典型', NULL, 4555, 0, NULL, 'J', 0, 5, 14747),
(56270, '2.4L 汽油系列三菱动力 商务型', NULL, 4555, 0, NULL, 'J', 0, 5, 14746),
(56269, '2.4L 汽油系列新动力 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14745),
(56268, '2.4L 汽油系列新动力 普通型', NULL, 4555, 0, NULL, 'J', 0, 5, 14744),
(56267, '2.0L 汽油系列动力王 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14743),
(56266, '2.0L 汽油系列动力王 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14742),
(56265, '2.0L 汽油系列动力王 经典型', NULL, 4555, 0, NULL, 'J', 0, 5, 14741),
(56264, '2.0L 汽油系列快运 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14740),
(56263, '2.0L 汽油系列快运 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14739),
(56262, '2.5L 海狮柴油快运 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14738),
(56261, '2.5L 海狮柴油快运 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14737),
(56260, '2.5L 海狮柴油快运 经典型', NULL, 4555, 0, NULL, 'J', 0, 5, 14736),
(56259, '2.4L OBD系列新动力 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14735),
(56258, '2.4L OBD系列新动力 普通型', NULL, 4555, 0, NULL, 'J', 0, 5, 14734),
(56257, '2.0L OBD系列动力王 豪华型', NULL, 4555, 0, NULL, 'J', 0, 5, 14733),
(56256, '2.0L OBD系列动力王 标准型', NULL, 4555, 0, NULL, 'J', 0, 5, 14732),
(56255, '2.0L OBD系列动力王 经典型', NULL, 4555, 0, NULL, 'J', 0, 5, 14731),
(56254, '动力王 2.0-M 舒适型 国V 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 110503),
(56253, '动力王 2.0-M 经典型 国V 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 110502),
(56252, '动力王 2.0-M 豪华型 国V 标准顶 9座', NULL, 4554, 0, NULL, 'J', 0, 5, 110501),
(56251, '动力王 2.0-M 乘用型 国V 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 110500),
(56250, '动力王 2.0-X 乘用型 国V 标准顶 11座', NULL, 4554, 0, NULL, 'J', 0, 5, 110499),
(56249, '动力王 2.0-X 经典型 国V 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 110498),
(56248, '动力王 2.0-X 舒适型 国V 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 110497),
(56247, '动力王 2.0-X 豪华型 国V 标准顶 11座', NULL, 4554, 0, NULL, 'J', 0, 5, 110496),
(56246, '动力王 2.2L 豪华型 国IV 高顶 11座', NULL, 4554, 0, NULL, 'J', 0, 5, 105275),
(56245, '动力王 2.0-M 舒适型 国IV 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 105274),
(56244, '动力王 2.0-M 经典型 国IV 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 105273),
(56243, '动力王 2.0-M 豪华型 国IV 标准顶 9座', NULL, 4554, 0, NULL, 'J', 0, 5, 105272),
(56242, '动力王 2.0-M 乘用型 国IV 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 105270),
(56241, '动力王 2.0-X 乘用型 国IV 标准顶 11座', NULL, 4554, 0, NULL, 'J', 0, 5, 105269),
(56240, '快运王 2.0-M 豪华型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105256),
(56239, '快运王 2.0-M 舒适K型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105255),
(56238, '快运王 2.0-M 舒适Z型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105254),
(56237, '快运王 2.0-M 标准型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105253),
(56236, '快运王 2.0-X  豪华型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105252),
(56235, '快运王 2.0-X  舒适K型  国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105251),
(56234, '快运王 2.0-X  舒适Z型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105250),
(56233, '快运王 2.0-X 标准型 国V', NULL, 4554, 0, NULL, 'J', 0, 5, 105249),
(56232, '快运王 2.0-X  豪华型4G21B', NULL, 4554, 0, NULL, 'J', 0, 5, 103371),
(56231, '快运王 2.0-X  舒适K型4G21B', NULL, 4554, 0, NULL, 'J', 0, 5, 103370),
(56230, '快运王 2.0-X  舒适Z型4G21B', NULL, 4554, 0, NULL, 'J', 0, 5, 103369),
(56229, '快运王 2.0-X 标准型4G21B', NULL, 4554, 0, NULL, 'J', 0, 5, 103368),
(56228, '快运王 2.0-X  豪华型', NULL, 4554, 0, NULL, 'J', 0, 5, 103119),
(56227, '快运王 2.0-X  舒适K型', NULL, 4554, 0, NULL, 'J', 0, 5, 103118),
(56226, '快运王 2.0-X  舒适Z型', NULL, 4554, 0, NULL, 'J', 0, 5, 103117),
(56225, '快运王 2.0-X 标准型', NULL, 4554, 0, NULL, 'J', 0, 5, 103116),
(56224, '快运王 2.0-M 豪华型', NULL, 4554, 0, NULL, 'J', 0, 5, 103115),
(56223, '快运王 2.0-M 舒适K型', NULL, 4554, 0, NULL, 'J', 0, 5, 103114),
(56222, '快运王 2.0-M 舒适Z型', NULL, 4554, 0, NULL, 'J', 0, 5, 103113),
(56221, '快运王 2.0-M 标准型', NULL, 4554, 0, NULL, 'J', 0, 5, 103111),
(56220, '动力王 2.0-X 经典型 国IV 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 101328),
(56219, '动力王 2.0-X 舒适型 国IV 标准顶 6座', NULL, 4554, 0, NULL, 'J', 0, 5, 101325),
(56218, '动力王 2.0-X 豪华型 国IV 标准顶 11座', NULL, 4554, 0, NULL, 'J', 0, 5, 101323),
(56217, '快运王 2.0-X  商务型 国V', NULL, 4553, 0, NULL, 'J', 0, 5, 110511),
(56216, '快运王 2.0-X  商务型', NULL, 4553, 0, NULL, 'J', 0, 5, 110510),
(56215, '快运王 2.0-X  豪华型', NULL, 4553, 0, NULL, 'J', 0, 5, 110509),
(56214, '快运王 2.0-X  豪华型 国V', NULL, 4553, 0, NULL, 'J', 0, 5, 110508),
(56213, '快运王 2.0-M 商务型 国V', NULL, 4553, 0, NULL, 'J', 0, 5, 110507),
(56212, '快运王 2.0-M 商务型', NULL, 4553, 0, NULL, 'J', 0, 5, 110506),
(56211, '快运王 2.0-M 豪华型 国V', NULL, 4553, 0, NULL, 'J', 0, 5, 110505),
(56210, '快运王 2.0-M 豪华型', NULL, 4553, 0, NULL, 'J', 0, 5, 110504),
(56209, 'S系列 超豪华型(长轴)', NULL, 4552, 0, NULL, 'J', 0, 5, 1315),
(56208, 'S系列 超豪华型(短轴)', NULL, 4551, 0, NULL, 'J', 0, 5, 1318),
(56207, 'G系列 超豪华型(短轴)', NULL, 4551, 0, NULL, 'J', 0, 5, 1317),
(56206, 'E系列 豪华型(短轴)', NULL, 4551, 0, NULL, 'J', 0, 5, 1316),
(56205, '尊领系列 豪华型短轴7座(柴油)', NULL, 4550, 0, NULL, 'J', 0, 5, 10396),
(56204, '尊领系列 标准型短轴7座(柴油)', NULL, 4550, 0, NULL, 'J', 0, 5, 10395),
(56203, '尊领系列 豪华型长轴9座(柴油)', NULL, 4550, 0, NULL, 'J', 0, 5, 10394),
(56202, '尊领系列 豪华型长轴11座(柴油)', NULL, 4550, 0, NULL, 'J', 0, 5, 10393),
(56201, '尊领系列 标准型长轴9座(柴油)', NULL, 4550, 0, NULL, 'J', 0, 5, 10392),
(56200, '金色之旅系列 SY6521DS2（标准型）长轴豪华座椅8座', NULL, 4550, 0, NULL, 'J', 0, 5, 5429),
(56199, '金色之旅系列 SY6521DS2（标准型）长轴特仕8座', NULL, 4550, 0, NULL, 'J', 0, 5, 5428),
(56198, '金色之旅系列 SY6521DS2（标准型）长轴特仕3型9座', NULL, 4550, 0, NULL, 'J', 0, 5, 5427),
(56197, '金色之旅系列 SY6521DS2（标准型）长轴特仕2型9座', NULL, 4550, 0, NULL, 'J', 0, 5, 5426),
(56196, '金色之旅系列 SY6521DS2（标准型）长轴9座', NULL, 4550, 0, NULL, 'J', 0, 5, 5425),
(56195, '金色之旅系列 SY6471DS（7座）（标准天窗版）特仕1型', NULL, 4550, 0, NULL, 'J', 0, 5, 5424),
(56194, '金色之旅系列 SY6471DS（7座）（标准天窗版）特仕', NULL, 4550, 0, NULL, 'J', 0, 5, 5423),
(56193, '金色之旅系列 SY6471DS（7座）（标准型）特仕', NULL, 4550, 0, NULL, 'J', 0, 5, 5422),
(56192, '金色之旅系列 SY6471DS（7座）（标准型）', NULL, 4550, 0, NULL, 'J', 0, 5, 5421),
(56191, '超豪华', NULL, 4550, 0, NULL, 'J', 0, 5, 1399),
(56190, '豪华型', NULL, 4550, 0, NULL, 'J', 0, 5, 1398),
(56189, '标准型', NULL, 4550, 0, NULL, 'J', 0, 5, 1397),
(56188, 'G系列 豪华型(短轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1325),
(56187, 'G系列 旗舰型(短轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1324),
(56186, 'G系列 豪华型(长轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1323),
(56185, '金色之旅 标准型(长轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1322),
(56184, '金色之旅 豪华型(短轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1321),
(56183, '金色之旅 标准型(短轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1320),
(56182, '经典型(长轴)', NULL, 4550, 0, NULL, 'J', 0, 5, 1319),
(56181, '尊领系列 标准型长轴11座(柴油)', NULL, 4549, 0, NULL, 'J', 0, 5, 10391),
(56180, '智领V2.0豪华型(长轴11座)', NULL, 4549, 0, NULL, 'J', 0, 5, 9782),
(56179, '智领V2.0豪华型(长轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 9781),
(56178, '智领V2.0豪华型(短轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 9780),
(56177, '智领V2.0标准型(长轴11座)', NULL, 4549, 0, NULL, 'J', 0, 5, 9779),
(56176, '智领V2.0标准型(长轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 9778),
(56175, '智领V2.0标准型(短轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 9777),
(56174, '头等舱 自动超豪华型7座', NULL, 4549, 0, NULL, 'J', 0, 5, 7016),
(56173, '智领系列 标准型短轴7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1354),
(56172, '智领系列 标准型长轴9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1353),
(56171, '智领系列 豪华型长轴9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1351),
(56170, '尊领系列 标准型短轴7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1349),
(56169, '尊领系列 标准型长轴9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1348),
(56168, '尊领系列 豪华型短轴7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1346),
(56167, '尊领系列 豪华型长轴9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1345),
(56166, '御领系列 豪华型短轴7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1343),
(56165, '御领系列 豪华型长轴9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1342),
(56164, '御领系列 豪华型长轴11座', NULL, 4549, 0, NULL, 'J', 0, 5, 1341),
(56163, '商务舱 标准天窗型自动版', NULL, 4549, 0, NULL, 'J', 0, 5, 1340),
(56162, '商务舱 标准天窗型手动版', NULL, 4549, 0, NULL, 'J', 0, 5, 1339),
(56161, '金色之旅新动力 豪华型(短轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 1338),
(56160, '金色之旅 标准型7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1337),
(56159, '金色之旅 标准型9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1336),
(56158, '金色之旅 豪华型9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1335),
(56157, '金色之旅 豪华型7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1334),
(56156, '商务舱 经典型(短轴)', NULL, 4549, 0, NULL, 'J', 0, 5, 1333),
(56155, '商务舱 经典型7座/9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1332),
(56154, '商务舱 豪华型7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1330),
(56153, '商务舱 标准型7座/9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1329),
(56152, '头等舱 豪华型7座/9座', NULL, 4549, 0, NULL, 'J', 0, 5, 1328),
(56151, '头等舱 旗舰型AT7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1327),
(56150, '头等舱 顶级版AT7座', NULL, 4549, 0, NULL, 'J', 0, 5, 1326),
(56149, '08升级版2.7御领豪华型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5420),
(56148, '08升级版2.7御领豪华型(长轴9座)', NULL, 4548, 0, NULL, 'J', 0, 5, 5419),
(56147, '08升级版2.7豪华型(长轴11座)', NULL, 4548, 0, NULL, 'J', 0, 5, 5418),
(56146, '08升级版2.7御领旗舰型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5417),
(56145, '御领系列 SY6521GS1B（豪华精品型）9座', NULL, 4548, 0, NULL, 'J', 0, 5, 5416),
(56144, '御领系列 SY6521GS3BG（豪华精品型）11座', NULL, 4548, 0, NULL, 'J', 0, 5, 5415),
(56143, '08升级版2.0智领标准型(长轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5414),
(56142, '08升级版2.0智领标准型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5413),
(56141, '2.0智领系列 SY6481HSBG（标准型短轴）豪华座椅7座', NULL, 4548, 0, NULL, 'J', 0, 5, 5412),
(56140, '08升级版2.0智领豪华型(长轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5411),
(56139, '08升级版2.0智领豪华型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5410),
(56138, '08升级版2.4尊领标准型(长轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5409),
(56137, '08升级版2.4尊领标准型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5408),
(56136, '08升级版2.4尊领豪华型(长轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5407),
(56135, '08升级版2.4尊领豪华型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5406),
(56134, '2.4尊领系列 SY6471KZ（豪华型AT）豪华座椅7座', NULL, 4548, 0, NULL, 'J', 0, 5, 5405),
(56133, '08升级版2.4尊领旗舰型(短轴)', NULL, 4548, 0, NULL, 'J', 0, 5, 5404),
(56132, '08升级版2.0智领标准型(长轴11座)', NULL, 4548, 0, NULL, 'J', 0, 5, 1352),
(56131, '08升级版2.0智领豪华型(长轴11座)', NULL, 4548, 0, NULL, 'J', 0, 5, 1350),
(56130, '08升级版2.4尊领标准型(长轴11座)', NULL, 4548, 0, NULL, 'J', 0, 5, 1347),
(56129, '08升级版2.4尊领豪华型(长轴11座)', NULL, 4548, 0, NULL, 'J', 0, 5, 1344),
(56128, '2.4尊领标准型(长轴11座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8720),
(56127, '2.4尊领标准型(长轴9座侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8719),
(56126, '2.4尊领豪华型(长轴11座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8718),
(56125, '2.4尊领豪华型(长轴9座侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8717),
(56124, '2.4尊领豪华型(短轴侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8716),
(56123, '2.4尊领豪华型AT(短轴侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8715),
(56122, '2.7御领豪华型(长轴11座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8714),
(56121, '2.7御领豪华型(长轴9座侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8713),
(56120, '2.7御领豪华型(长轴9座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8712),
(56119, '2.4尊领豪华型(长轴9座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8711),
(56118, '2.7御领豪华型(短轴侧翻座椅)', NULL, 4547, 0, NULL, 'J', 0, 5, 8710),
(56117, '2.7御领旗舰型AT(短轴)', NULL, 4547, 0, NULL, 'J', 0, 5, 8546),
(56116, '2.7御领豪华型(短轴)', NULL, 4547, 0, NULL, 'J', 0, 5, 8545),
(56115, '2.4尊领豪华型AT(短轴)', NULL, 4547, 0, NULL, 'J', 0, 5, 8544),
(56114, '2.4尊领豪华型(短轴)', NULL, 4547, 0, NULL, 'J', 0, 5, 8543),
(56113, '2.4尊领标准型(长轴9座)', NULL, 4547, 0, NULL, 'J', 0, 5, 8542),
(56112, '睿翔 2.0L 手动 舒适型 长轴11座', NULL, 4546, 0, NULL, 'J', 0, 5, 103260),
(56111, '睿翔 2.0L 手动 舒适型 长轴9座', NULL, 4546, 0, NULL, 'J', 0, 5, 100461),
(56110, '睿翔 2.0L 手动 舒适型 短轴7座', NULL, 4546, 0, NULL, 'J', 0, 5, 100460),
(56109, '睿翔 2.0L 手动 豪华型 长轴11座', NULL, 4546, 0, NULL, 'J', 0, 5, 13875),
(56108, '睿翔 2.0L 手动 豪华型 长轴9座', NULL, 4546, 0, NULL, 'J', 0, 5, 13874),
(56107, '睿翔 2.0L 手动 豪华型 短轴7座', NULL, 4546, 0, NULL, 'J', 0, 5, 9606),
(56106, '尊领 2.4L 旗舰型 手动 标准顶 长轴 11座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110489),
(56105, '尊领 2.4L 旗舰型 手动 标准顶 长轴 9座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110488),
(56104, '尊领 2.4L 旗舰型 手动 半高顶 短轴 7座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110487),
(56103, '尊领 2.4L 标准型 手动 标准顶 长轴 11座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110486),
(56102, '尊领 2.4L 标准型 手动 标准顶 长轴 9座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110485),
(56101, '尊领 2.4L 经典型 手动 标准顶 长轴 11座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110484),
(56100, '尊领 2.4L 经典型 手动 标准顶 长轴 9座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110483),
(56099, '尊领 2.4L 经典型 手动 半高顶 短轴 7座 国5', NULL, 4545, 0, NULL, 'J', 0, 5, 110482),
(56098, '御领 2.7L 标准型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 110481),
(56097, '御领 2.7L 标准型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 110480),
(56096, '智领 2.0L 标准型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101382),
(56095, '智领 2.0L 标准型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101381),
(56094, '智领 2.0L 标准型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101380),
(56093, '智领 2.0L 豪华型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101379),
(56092, '智领 2.0L 豪华型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101378),
(56091, '智领 2.0L 豪华型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101377),
(56090, '尊领 2.4L 经典型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101376),
(56089, '尊领 2.4L 经典型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101375),
(56088, '尊领 2.4L 经典型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101374),
(56087, '尊领 2.4L 标准型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101373),
(56086, '尊领 2.4L 标准型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101372),
(56085, '尊领 2.4L 旗舰型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101371),
(56084, '尊领 2.4L 旗舰型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101370),
(56083, '尊领 2.4L 旗舰型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101369),
(56082, '睿翔 2.0L 舒适型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101368),
(56081, '睿翔 2.0L 舒适型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101367),
(56080, '睿翔 2.0L 舒适型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101366),
(56079, '睿翔 2.0L 豪华型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101365),
(56078, '睿翔 2.0L 豪华型 手动 标准顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101364),
(56077, '睿翔 2.0L 豪华型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101363),
(56076, '御领 2.7L 豪华型 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101362),
(56075, '御领 2.7L 豪华型 手动 半高顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101361),
(56074, '御领 2.7L 豪华型 手动 标准顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101360),
(56073, '御领 2.7L 行政版 手动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101359),
(56072, '御领 2.7L 行政版 手动 半高顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101358),
(56071, '御领 2.7L 行政版 手动 半高顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101357),
(56070, '御领 2.7L 旗舰型 自动 半高顶 短轴 7座', NULL, 4545, 0, NULL, 'J', 0, 5, 101356),
(56069, '御领 2.7L 旗舰型 自动 半高顶 长轴 9座', NULL, 4545, 0, NULL, 'J', 0, 5, 101355),
(56068, '御领 2.7L 旗舰型 自动 半高顶 长轴 11座', NULL, 4545, 0, NULL, 'J', 0, 5, 101354),
(56067, '智领 2.5L 舒适型 手动 长轴 11座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13881),
(56066, '智领 2.5L 舒适型 手动 长轴 9座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13880),
(56065, '智领 2.5L 舒适型 手动 短轴 7座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13879),
(56064, '智领 2.5L 经典型 手动 长轴 11座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13878),
(56063, '智领 2.5L 经典型 手动 长轴 9座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13877),
(56062, '智领 2.5L 经典型 手动 短轴 7座 柴油', NULL, 4545, 0, NULL, 'J', 0, 5, 13876),
(56061, '智领 2.5L 经典型 手动 柴油 半高顶 短轴 7座', NULL, 4544, 0, NULL, 'J', 0, 5, 110495),
(56060, '智领 2.5L 经典型 柴油 手动 标准顶 长轴 9座', NULL, 4544, 0, NULL, 'J', 0, 5, 110494),
(56059, '智领 2.5L 经典型 柴油 手动 标准顶 长轴 11座', NULL, 4544, 0, NULL, 'J', 0, 5, 110493),
(56058, '智领 2.5L 舒适型 柴油 手动 半高顶 短轴 7座', NULL, 4544, 0, NULL, 'J', 0, 5, 110492),
(56057, '智领 2.5L 舒适型 柴油 手动 标准顶 长轴 9座', NULL, 4544, 0, NULL, 'J', 0, 5, 110491),
(56056, '智领 2.5L 舒适型 柴油 手动 标准顶 长轴 11座', NULL, 4544, 0, NULL, 'J', 0, 5, 110490),
(56055, '2.0L智领豪华型11座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105234),
(56054, '2.0L智领标准型11座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105233),
(56053, '2.0L智领标准型11座 全运纪念版 国IV 铝合金轮毂', NULL, 4544, 0, NULL, 'J', 0, 5, 105232),
(56052, '2.0L智领标准型11座 全运纪念版 国IV 钢轮毂', NULL, 4544, 0, NULL, 'J', 0, 5, 105231),
(56051, '2.0L智领豪华型9座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105230),
(56050, '2.0L智领豪华型7座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105229),
(56049, '2.0L智领豪华型9座 全运纪念版 国IV', NULL, 4544, 0, NULL, 'J', 0, 5, 105228),
(56048, '2.0L智领豪华型7座 全运纪念版 国IV', NULL, 4544, 0, NULL, 'J', 0, 5, 105226),
(56047, '2.0L智领标准型9座 全运纪念版 国IV', NULL, 4544, 0, NULL, 'J', 0, 5, 105201),
(56046, '2.0L智领标准型9座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105199),
(56045, '2.0L智领标准型7座 全运纪念版 国IV', NULL, 4544, 0, NULL, 'J', 0, 5, 105197),
(56044, '2.0L智领标准型7座 全运纪念版 国V', NULL, 4544, 0, NULL, 'J', 0, 5, 105188),
(56043, '第六代 大海狮翔龙 2.4 4RB2(国IV) 豪华型', NULL, 4543, 0, NULL, 'J', 0, 5, 11957),
(56042, '第六代 大海狮翔龙 2.4 4RB2(国IV) 标准型', NULL, 4543, 0, NULL, 'J', 0, 5, 11956),
(56041, '第六代 大海狮翔龙 2.0 V20(国IV) 经典型', NULL, 4543, 0, NULL, 'J', 0, 5, 11954),
(56040, '第六代 大海狮翔龙 2.0 V20(国IV) 标准型', NULL, 4543, 0, NULL, 'J', 0, 5, 11953),
(56039, '第六代 大海狮翔龙 2.0 V19(国IV) 标准型', NULL, 4543, 0, NULL, 'J', 0, 5, 11952),
(56038, '第六代 大海狮翔龙 2.0 V19(国IV) 经典型', NULL, 4543, 0, NULL, 'J', 0, 5, 11951),
(56037, '第六代 大海狮翔龙 快运 4G22D4(国III+EOBD) 经', NULL, 4543, 0, NULL, 'J', 0, 5, 11950),
(56036, '第六代 大海狮翔龙 商务 4G22D4(国III+EOBD) 标', NULL, 4543, 0, NULL, 'J', 0, 5, 11949),
(56035, '大海狮翔运 2.4 4RB2 (国IV) 商务型', NULL, 4543, 0, NULL, 'J', 0, 5, 11946),
(56034, '大海狮翔运 2.4 4RB2 (国IV) 豪华型', NULL, 4543, 0, NULL, 'J', 0, 5, 11945),
(56033, '大海狮翔运 2.0 4G20D4B (国IV) 豪华型', NULL, 4543, 0, NULL, 'J', 0, 5, 11944),
(56032, '大海狮翔运 2.0 4G20D4B (国IV) 舒适型', NULL, 4543, 0, NULL, 'J', 0, 5, 11943),
(56031, '大海狮翔运 2.0 4G20D4B (国IV) 标准型', NULL, 4543, 0, NULL, 'J', 0, 5, 11942),
(56030, '大海狮翔运 2.0 4G20D4B (国IV) 经典型', NULL, 4543, 0, NULL, 'J', 0, 5, 11941),
(56029, '大海狮L 2.5L 手动 豪华型 柴油', NULL, 4542, 0, NULL, 'J', 0, 5, 100291),
(56028, '大海狮L 2.5L 手动 标准型 柴油', NULL, 4542, 0, NULL, 'J', 0, 5, 100290),
(56027, '大海狮L 2.5L 手动 旗舰型 柴油', NULL, 4542, 0, NULL, 'J', 0, 5, 100289),
(56026, '大海狮L 2.4L 手动 标准型 汽油', NULL, 4542, 0, NULL, 'J', 0, 5, 100288),
(56025, '大海狮L 2.4L 手动 旗舰型 汽油', NULL, 4542, 0, NULL, 'J', 0, 5, 13872),
(56024, '大海狮L 2.4L 手动 豪华型 汽油', NULL, 4542, 0, NULL, 'J', 0, 5, 13865),
(56023, '大海狮W 2.5L 手动 标准型 柴油', NULL, 4541, 0, NULL, 'J', 0, 5, 16434),
(56022, '大海狮W 2.5L 手动 豪华型 柴油', NULL, 4541, 0, NULL, 'J', 0, 5, 16433),
(56021, '大海狮W 2.5L 手动 旗舰型 柴油', NULL, 4541, 0, NULL, 'J', 0, 5, 16432),
(56020, '大海狮W 2.4L 手动 标准型 汽油', NULL, 4541, 0, NULL, 'J', 0, 5, 16431),
(56019, '大海狮W 2.4L 手动 豪华型 汽油', NULL, 4541, 0, NULL, 'J', 0, 5, 16430),
(56018, '大海狮W 2.4L 手动 旗舰型 汽油', NULL, 4541, 0, NULL, 'J', 0, 5, 16429),
(56017, '大海狮L 2.7L 领航版 手动 豪华型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105243),
(56016, '大海狮L 2.4L 手动 旗舰型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105242),
(56015, '大海狮L 2.4L 手动 豪华型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105241),
(56014, '大海狮L 2.4L 手动 标准型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105240),
(56013, '大海狮W 2.4L 手动 豪华型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105239),
(56012, '大海狮W 2.4L 手动 标准型 汽油 国V', NULL, 4540, 0, NULL, 'J', 0, 5, 105238),
(56011, '大海狮W 2.5L 全运纪念版 手动 豪华型 柴油', NULL, 4540, 0, NULL, 'J', 0, 5, 105190),
(56010, '大海狮W 2.5L 全运纪念版 手动 标准型 柴油', NULL, 4540, 0, NULL, 'J', 0, 5, 105189),
(56009, '大海狮L 2.7L 领航版 手动 豪华型 汽油', NULL, 4540, 0, NULL, 'J', 0, 5, 104697),
(56008, '大海狮L 2.7L 手动 领航版 旗舰型 汽油', NULL, 4540, 0, NULL, 'J', 0, 5, 104696),
(56007, '2.2L 手动  SY6480', NULL, 4539, 0, NULL, 'J', 0, 5, 100093),
(56006, 'SY4G19—L4 四驱豪华型', NULL, 4538, 0, NULL, 'J', 0, 5, 8650),
(56005, '2.0L 手动 SY6481DAC37', NULL, 4537, 0, NULL, 'J', 0, 5, 100019),
(56004, '2.0L 手动 SY6481DAQ43', NULL, 4537, 0, NULL, 'J', 0, 5, 100018),
(56003, '2.2L 手动 新内饰 SY6481DAQ37', NULL, 4537, 0, NULL, 'J', 0, 5, 14799),
(56002, '2.2L 手动 新内饰 SY6481DAQ37-L4', NULL, 4537, 0, NULL, 'J', 0, 5, 14798),
(56001, '2.0L 手动 豪华型 SY6480DQ31-09H', NULL, 4537, 0, NULL, 'J', 0, 5, 14797),
(56000, '三厢 1.8L 手动基本型', NULL, 4536, 0, NULL, 'J', 0, 5, 10447),
(55999, '0.8L 自动档', NULL, 4536, 0, NULL, 'J', 0, 5, 10446),
(55998, '0.8L 天窗型', NULL, 4536, 0, NULL, 'J', 0, 5, 10445),
(55997, '0.8L 全景版', NULL, 4536, 0, NULL, 'J', 0, 5, 10444),
(55996, '0.8L 豪华型', NULL, 4536, 0, NULL, 'J', 0, 5, 10443),
(55995, '0.8L 舒适型', NULL, 4536, 0, NULL, 'J', 0, 5, 10441),
(55994, '0.8L 基本型', NULL, 4536, 0, NULL, 'J', 0, 5, 10440),
(55993, '0.8L 标准型', NULL, 4536, 0, NULL, 'J', 0, 5, 10438),
(55992, '1.1L JNJ7111', NULL, 4536, 0, NULL, 'J', 0, 5, 7942),
(55991, '0.8L JNJ7081', NULL, 4536, 0, NULL, 'J', 0, 5, 7941),
(55990, '1.1L 舒适型', NULL, 4535, 0, NULL, 'J', 0, 5, 10442),
(55989, '1.1L 标准型', NULL, 4535, 0, NULL, 'J', 0, 5, 10439),
(55988, '江南风光1.8L', NULL, 4534, 0, NULL, 'J', 0, 5, 1652),
(55987, 'JNJ7111 1.1L五档手动型', NULL, 4533, 0, NULL, 'J', 0, 5, 1655),
(55986, 'JNJ7081 0.8L四档手动全景版', NULL, 4533, 0, NULL, 'J', 0, 5, 1654),
(55985, 'JNJ7081 0.8L四档手动舒适型', NULL, 4533, 0, NULL, 'J', 0, 5, 1653),
(55984, '1.5L 经济型', NULL, 4532, 0, NULL, 'J', 0, 5, 1656),
(55983, '1.5L 豪华型', NULL, 4531, 0, NULL, 'J', 0, 5, 1658),
(55982, '1.5L 舒适型', NULL, 4531, 0, NULL, 'J', 0, 5, 1657),
(55981, '基本型', NULL, 4530, 0, NULL, 'J', 0, 5, 8464),
(55980, '导航版', NULL, 4530, 0, NULL, 'J', 0, 5, 8058),
(55979, '豪华型', NULL, 4530, 0, NULL, 'J', 0, 5, 7398),
(55978, '舒适型', NULL, 4530, 0, NULL, 'J', 0, 5, 7397),
(55977, '标准型', NULL, 4530, 0, NULL, 'J', 0, 5, 6993),
(55976, '2.4L 手动 四驱 超豪华版 SLX 柴油', NULL, 4529, 0, NULL, 'J', 0, 5, 103029),
(55975, '2.4L 手动 四驱 豪华版 LX 柴油', NULL, 4529, 0, NULL, 'J', 0, 5, 103028),
(55974, '2.4L 手动 四驱 普通版 GL 柴油', NULL, 4529, 0, NULL, 'J', 0, 5, 103027),
(55973, '2.4L 手动 两驱 普通版 GL 柴油 ', NULL, 4529, 0, NULL, 'J', 0, 5, 101574),
(55972, '2.4L 手动 两驱 豪华版 LX 柴油', NULL, 4529, 0, NULL, 'J', 0, 5, 101573),
(55971, '2.4L 手动 两驱 超豪华版 SLX 柴油', NULL, 4529, 0, NULL, 'J', 0, 5, 101572),
(55970, '4×2七座 柴油 手动 豪华型', NULL, 4528, 0, NULL, 'J', 0, 5, 13361),
(55969, '4×2七座 柴油 手动 超豪华型', NULL, 4528, 0, NULL, 'J', 0, 5, 13360),
(55968, '4×4七座 柴油 手动 超豪华型', NULL, 4528, 0, NULL, 'J', 0, 5, 13359),
(55967, '4×4五座 柴油 手动 超豪华型', NULL, 4528, 0, NULL, 'J', 0, 5, 13357),
(55966, '4×2五座 汽油 手动 超豪华型', NULL, 4528, 0, NULL, 'J', 0, 5, 13356),
(55965, '超豪华型 国四', NULL, 4528, 0, NULL, 'J', 0, 5, 12592),
(55964, '超豪华型 国三', NULL, 4528, 0, NULL, 'J', 0, 5, 12591),
(55963, '豪华型 国四', NULL, 4528, 0, NULL, 'J', 0, 5, 12590),
(55962, '豪华型 国三', NULL, 4528, 0, NULL, 'J', 0, 5, 12589),
(55961, '2.4L 手动 两驱 豪华型 汽油 五座', NULL, 4527, 0, NULL, 'J', 0, 5, 16638),
(55960, '2.4L 手动 两驱 超豪华型 汽油 五座 ', NULL, 4527, 0, NULL, 'J', 0, 5, 16637),
(55959, '2.4L 手动 两驱 豪华型 汽油 七座', NULL, 4527, 0, NULL, 'J', 0, 5, 16636),
(55958, '2.4L 手动 两驱 超豪华型 汽油 七座', NULL, 4527, 0, NULL, 'J', 0, 5, 16635),
(55957, '2.4T 手动 两驱 豪华型 柴油 七座', NULL, 4527, 0, NULL, 'J', 0, 5, 16634),
(55956, '2.4T 手动 两驱 超豪华型 柴油 七座', NULL, 4527, 0, NULL, 'J', 0, 5, 16633),
(55955, '2.4T 手动 四驱 超豪华型 柴油 七座', NULL, 4527, 0, NULL, 'J', 0, 5, 16632),
(55954, '新S350 2.0T 手动 四驱 超豪华版 汽油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 106410),
(55953, '新S350 2.0T 手动 四驱 豪华版 汽油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 106409),
(55952, '新S350 2.0T 手动 两驱 超豪华版 汽油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 106408),
(55951, '新S350 2.0T 手动 两驱 豪华版 汽油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 106407),
(55950, '新S350 2.4T 自动 四驱 超豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 106403),
(55949, '新S350 2.4T 手动 四驱 超豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105736),
(55948, '新S350 2.4T 手动 两驱 超豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105735),
(55947, '新S350 2.4T 手动 四驱 豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105734),
(55946, '新S350 2.4T 手动 两驱 豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105733),
(55945, '新S350 2.4T 自动 两驱 豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105732),
(55944, '新S350 2.4T 自动 两驱 超豪华版 柴油 七座版', NULL, 4526, 0, NULL, 'J', 0, 5, 105731),
(55943, '新S350 2.0T 手动 两驱 豪华版 汽油', NULL, 4526, 0, NULL, 'J', 0, 5, 105293),
(55942, '新S350 2.0T 手动 两驱 超豪华版 汽油', NULL, 4526, 0, NULL, 'J', 0, 5, 105292),
(55941, '新S350 2.0T 手动 四驱 豪华版 汽油', NULL, 4526, 0, NULL, 'J', 0, 5, 105291),
(55940, '新S350 2.0T 手动 四驱 超豪华版 汽油', NULL, 4526, 0, NULL, 'J', 0, 5, 105290),
(55939, '新S350 2.4T 手动 两驱 豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105289),
(55938, '新S350 2.4T 手动 两驱 超豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105288),
(55937, '新S350 2.4T 手动 四驱 豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105287),
(55936, '新S350 2.4T 手动 四驱 超豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105286),
(55935, '新S350 2.4T 自动 两驱 豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105285),
(55934, '新S350 2.4T 自动 两驱 超豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105284),
(55933, '新S350 2.4T 自动 四驱 超豪华版 柴油', NULL, 4526, 0, NULL, 'J', 0, 5, 105282),
(55932, 'S350 2.4T 自动 两驱 特装版 柴油 五座 ', NULL, 4526, 0, NULL, 'J', 0, 5, 104592),
(55931, 'S350 2.4L 手动 两驱 特装版 汽油 五座 ', NULL, 4526, 0, NULL, 'J', 0, 5, 104478),
(55930, 'S350 2.4L 手动 四驱 特装版 汽油 五座', NULL, 4526, 0, NULL, 'J', 0, 5, 104477),
(55929, 'S350 2.4T 手动 两驱 特装版', NULL, 4526, 0, NULL, 'J', 0, 5, 104475),
(55928, 'S350 2.4T 手动 四驱 特装版 柴油 五座', NULL, 4526, 0, NULL, 'J', 0, 5, 104471),
(55927, '短轴距双排 普通版', NULL, 4525, 0, NULL, 'J', 0, 5, 10105),
(55926, '短轴距 超值版', NULL, 4525, 0, NULL, 'J', 0, 5, 10104),
(55925, '短轴距单排 普通版', NULL, 4525, 0, NULL, 'J', 0, 5, 10103),
(55924, '单长坑板厢货', NULL, 4525, 0, NULL, 'J', 0, 5, 8078),
(55923, '长轴栏板', NULL, 4525, 0, NULL, 'J', 0, 5, 8077),
(55922, '长轴距双排 普通版', NULL, 4524, 0, NULL, 'J', 0, 5, 10106),
(55921, '顺达双长厢', NULL, 4524, 0, NULL, 'J', 0, 5, 7050),
(55920, '顺达单长厢', NULL, 4524, 0, NULL, 'J', 0, 5, 7049),
(55919, '长轴距单排 普通版', NULL, 4524, 0, NULL, 'J', 0, 5, 7048),
(55918, '长轴距 超值版', NULL, 4524, 0, NULL, 'J', 0, 5, 7047),
(55917, '超值版 单排 长轴 JX493ZLQ3A', NULL, 4523, 0, NULL, 'J', 0, 5, 14136),
(55916, '超值版 双排 短轴 JX493ZLQ3B', NULL, 4523, 0, NULL, 'J', 0, 5, 14135),
(55915, '超值版 单排 短轴 JX493ZLQ3B', NULL, 4523, 0, NULL, 'J', 0, 5, 14134),
(55914, '双排 长轴 JX493ZLQ3', NULL, 4523, 0, NULL, 'J', 0, 5, 14133),
(55913, '单排 长轴 JX493ZLQ3', NULL, 4523, 0, NULL, 'J', 0, 5, 14132),
(55912, '双排 短轴 JX493ZQ5B', NULL, 4523, 0, NULL, 'J', 0, 5, 14131),
(55911, '单排 短轴 JX493ZQ5B', NULL, 4523, 0, NULL, 'J', 0, 5, 14130),
(55910, '经济型共轨 3360轴距 双排', NULL, 4522, 0, NULL, 'J', 0, 5, 109865),
(55909, '经济型共轨 3360轴距 单排', NULL, 4522, 0, NULL, 'J', 0, 5, 109864),
(55908, '经济型共轨 2490轴距 单标后双胎', NULL, 4522, 0, NULL, 'J', 0, 5, 109863),
(55907, '经济型共轨 2490轴距 双标后单胎', NULL, 4522, 0, NULL, 'J', 0, 5, 109862),
(55906, '经济型共轨 2490轴距 单标后单胎', NULL, 4522, 0, NULL, 'J', 0, 5, 109861),
(55905, '凯运双长', NULL, 4521, 0, NULL, 'J', 0, 5, 7043),
(55904, '凯运双标', NULL, 4521, 0, NULL, 'J', 0, 5, 7042),
(55903, '双排 长轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101554),
(55902, '排半 长轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101553),
(55901, '单排 长轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101552),
(55900, '双排 长轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101551),
(55899, '排半 长轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101550),
(55898, '单排 长轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101549),
(55897, '双排 标轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101548),
(55896, '双排 标轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101547),
(55895, '排半 标轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101546),
(55894, '单排 标轴 JX493ZLQ3A 厢货车', NULL, 4520, 0, NULL, 'J', 0, 5, 101545),
(55893, '排半 标轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101544),
(55892, '单排 标轴 JX493ZLQ3A 栏板车', NULL, 4520, 0, NULL, 'J', 0, 5, 101543),
(55891, '双排 长轴 JX493ZLQ3', NULL, 4520, 0, NULL, 'J', 0, 5, 14141),
(55890, '单排 长轴 JX493ZLQ3', NULL, 4520, 0, NULL, 'J', 0, 5, 14140),
(55889, '双排 短轴 JX493ZQ5B', NULL, 4520, 0, NULL, 'J', 0, 5, 14139),
(55888, '排半 短轴 JX493ZQ5B', NULL, 4520, 0, NULL, 'J', 0, 5, 14138),
(55887, '单排 短轴 JX493ZQ5B', NULL, 4520, 0, NULL, 'J', 0, 5, 14137),
(55886, '经济型共轨 3360轴距 双排', NULL, 4519, 0, NULL, 'J', 0, 5, 109872),
(55885, '经济型共轨 3360轴距 排半', NULL, 4519, 0, NULL, 'J', 0, 5, 109871),
(55884, '经济型共轨 3360轴距 单排', NULL, 4519, 0, NULL, 'J', 0, 5, 109870),
(55883, '经济型共轨 2490轴距 双排后双胎', NULL, 4519, 0, NULL, 'J', 0, 5, 109869),
(55882, '经济型共轨 2490轴距 单排后双胎', NULL, 4519, 0, NULL, 'J', 0, 5, 109868),
(55881, '经济型共轨 2490轴距 双排后单胎', NULL, 4519, 0, NULL, 'J', 0, 5, 109867),
(55880, '经济型共轨 2490轴距 单排后单胎', NULL, 4519, 0, NULL, 'J', 0, 5, 109866),
(55879, '4.6L 朝柴 长轴 栏板式', NULL, 4518, 0, NULL, 'J', 0, 5, 14065),
(55878, '4.6L 朝柴 长轴 厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14064),
(55877, '4.6L 朝柴 长轴 加长厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14063),
(55876, '4.3L 玉柴 长轴 栏板式', NULL, 4518, 0, NULL, 'J', 0, 5, 14062),
(55875, '4.3L 玉柴 长轴 厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14061),
(55874, '4.3L 玉柴 短轴 厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14060),
(55873, '4.3L 玉柴 短轴 栏板式', NULL, 4518, 0, NULL, 'J', 0, 5, 14059),
(55872, '4.6L 朝柴 短轴 加长厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14058),
(55871, '4.6L 朝柴 短轴 厢货式', NULL, 4518, 0, NULL, 'J', 0, 5, 14057),
(55870, '4.6L 朝柴 短轴 栏板式', NULL, 4518, 0, NULL, 'J', 0, 5, 14056),
(55869, '4.3L 4500轴距 排半 豪华型', NULL, 4517, 0, NULL, 'J', 0, 5, 109876),
(55868, '4.3L 4500轴距 排半 普通型', NULL, 4517, 0, NULL, 'J', 0, 5, 109875),
(55867, '4.3L 4500轴距 单排 豪华型', NULL, 4517, 0, NULL, 'J', 0, 5, 109874),
(55866, '4.3L 4500轴距 单排 普通型', NULL, 4517, 0, NULL, 'J', 0, 5, 109873),
(55865, '3360轴距 双排', NULL, 4516, 0, NULL, 'J', 0, 5, 103194),
(55864, '3360轴距 排半', NULL, 4516, 0, NULL, 'J', 0, 5, 103185),
(55863, '3360轴距 单排', NULL, 4516, 0, NULL, 'J', 0, 5, 103183),
(55862, '2750轴距 双排', NULL, 4516, 0, NULL, 'J', 0, 5, 103180),
(55861, '2750轴距 排半', NULL, 4516, 0, NULL, 'J', 0, 5, 103178),
(55860, '2750轴距 单排', NULL, 4516, 0, NULL, 'J', 0, 5, 103176),
(55859, '凯锐窄体双长厢', NULL, 4515, 0, NULL, 'J', 0, 5, 7056),
(55858, '凯锐窄体单长厢', NULL, 4515, 0, NULL, 'J', 0, 5, 7055),
(55857, '凯锐窄体单长', NULL, 4515, 0, NULL, 'J', 0, 5, 7054),
(55856, '凯锐窄体双长', NULL, 4515, 0, NULL, 'J', 0, 5, 7053),
(55855, '凯锐窄体双标', NULL, 4515, 0, NULL, 'J', 0, 5, 7052),
(55854, '凯锐宽体豪华单长厢', NULL, 4515, 0, NULL, 'J', 0, 5, 7051),
(55853, '窄体 双排 长轴 JX493ZLQ3', NULL, 4514, 0, NULL, 'J', 0, 5, 14151),
(55852, '窄体 排半 长轴 JX493ZLQ3', NULL, 4514, 0, NULL, 'J', 0, 5, 14150),
(55851, '窄体 单排 长轴 JX493ZLQ3', NULL, 4514, 0, NULL, 'J', 0, 5, 14149),
(55850, '窄体 双排 短轴 JX493ZQ5B', NULL, 4514, 0, NULL, 'J', 0, 5, 14148),
(55849, '窄体 排半 短轴 JX493ZQ5B', NULL, 4514, 0, NULL, 'J', 0, 5, 14147),
(55848, '窄体 单排 短轴 JX493ZQ5B', NULL, 4514, 0, NULL, 'J', 0, 5, 14146),
(55847, '宽体 排半 豪华', NULL, 4514, 0, NULL, 'J', 0, 5, 14145),
(55846, '宽体 排半 普通', NULL, 4514, 0, NULL, 'J', 0, 5, 14144),
(55845, '宽体 单排 豪华', NULL, 4514, 0, NULL, 'J', 0, 5, 14143),
(55844, '宽体 单排 普通', NULL, 4514, 0, NULL, 'J', 0, 5, 14142),
(55843, '共轨 3360轴距 排半', NULL, 4513, 0, NULL, 'J', 0, 5, 109883),
(55842, '共轨 3360轴距 单排', NULL, 4513, 0, NULL, 'J', 0, 5, 109882),
(55841, '共轨 2490轴距 双排后双胎', NULL, 4513, 0, NULL, 'J', 0, 5, 109881),
(55840, '共轨 2490轴距 单排后双胎', NULL, 4513, 0, NULL, 'J', 0, 5, 109880),
(55839, '共轨 2490轴距 双排后单胎', NULL, 4513, 0, NULL, 'J', 0, 5, 109879),
(55838, '共轨 2490轴距 排半', NULL, 4513, 0, NULL, 'J', 0, 5, 109878),
(55837, '共轨 2490轴距 单排后单胎', NULL, 4513, 0, NULL, 'J', 0, 5, 109877),
(55836, '800 长轴 双排 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103195),
(55835, '800 长轴 排半 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103187),
(55834, '800 长轴 单排 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103184),
(55833, '800 短轴 双排 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103181),
(55832, '800 短轴 排半 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103179),
(55831, '800 短轴 单排 豪华款', NULL, 4513, 0, NULL, 'J', 0, 5, 103177),
(55830, '8座中顶普通型', NULL, 4512, 0, NULL, 'J', 0, 5, 8178),
(55829, '15座中顶普通型', NULL, 4512, 0, NULL, 'J', 0, 5, 6254),
(55828, '17座高顶后双胎普通型', NULL, 4512, 0, NULL, 'J', 0, 5, 6253),
(55827, '17座长轴中顶后单胎', NULL, 4512, 0, NULL, 'J', 0, 5, 6252),
(55826, '15座长轴高顶豪华型', NULL, 4512, 0, NULL, 'J', 0, 5, 6251),
(55825, '15座长轴中顶豪华型', NULL, 4512, 0, NULL, 'J', 0, 5, 6250),
(55824, '12座中顶普通型', NULL, 4512, 0, NULL, 'J', 0, 5, 1605),
(55823, '9座中顶超豪华型', NULL, 4512, 0, NULL, 'J', 0, 5, 1604);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(55822, '柴油 加长轴后双胎 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10134),
(55821, '柴油 加长轴后双胎 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10133),
(55820, '柴油 加长轴后单胎 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10132),
(55819, '柴油 加长轴后单胎 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10131),
(55818, '柴油 长轴豪华型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10130),
(55817, '柴油 长轴豪华型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10129),
(55816, '柴油 长轴标准型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10128),
(55815, '柴油 长轴标准型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10127),
(55814, '柴油 长轴多功能型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10126),
(55813, '柴油 长轴多功能型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10125),
(55812, '柴油 短轴豪华型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10124),
(55811, '柴油 短轴豪华型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10123),
(55810, '柴油 短轴标准型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10122),
(55809, '柴油 短轴标准型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10121),
(55808, '柴油 短轴多功能型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10120),
(55807, '柴油 短轴多功能型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10119),
(55806, '汽油 长轴豪华型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10118),
(55805, '汽油 长轴豪华型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10117),
(55804, '汽油 长轴标准型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10116),
(55803, '汽油 长轴标准型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10115),
(55802, '汽油 长轴多功能型 高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10114),
(55801, '汽油 长轴多功能型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10113),
(55800, '汽油 短轴豪华型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10112),
(55799, '汽油 短轴豪华型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10111),
(55798, '汽油 短轴标准型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10110),
(55797, '汽油 短轴标准型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10109),
(55796, '汽油 短轴多功能型 中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10108),
(55795, '汽油 短轴多功能型 低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 10107),
(55794, '12座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 8180),
(55793, '12座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 8179),
(55792, '柴油长轴豪华14座高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1632),
(55791, '柴油长轴豪华14座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1631),
(55790, '柴油短轴豪华11座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1630),
(55789, '柴油长轴豪华9座高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1629),
(55788, '柴油长轴豪华9座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1628),
(55787, '柴油短轴豪华7座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1627),
(55786, '柴油短轴豪华7座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1626),
(55785, '汽油长轴普通6座高顶物流车', NULL, 4511, 0, NULL, 'J', 0, 5, 1625),
(55784, '汽油长轴普通15座高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1624),
(55783, '汽油长轴普通6座中顶物流车', NULL, 4511, 0, NULL, 'J', 0, 5, 1623),
(55782, '汽油长轴普通15座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1622),
(55781, '汽油短轴普通6座中顶物流车', NULL, 4511, 0, NULL, 'J', 0, 5, 1621),
(55780, '汽油短轴普通12座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1620),
(55779, '汽油短轴普通6座低顶物流车', NULL, 4511, 0, NULL, 'J', 0, 5, 1619),
(55778, '汽油短轴普通12座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1618),
(55777, '汽油短轴普通8座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1617),
(55776, '汽油短轴普通7座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1616),
(55775, '汽油短轴普通8座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1615),
(55774, '汽油长轴豪华14座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1612),
(55773, '汽油短轴豪华11座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1611),
(55772, '汽油短轴豪华11座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1610),
(55771, '汽油长轴豪华9座高顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1609),
(55770, '汽油长轴豪华9座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1608),
(55769, '汽油短轴豪华7座中顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1607),
(55768, '汽油短轴豪华7座低顶', NULL, 4511, 0, NULL, 'J', 0, 5, 1606),
(55767, '柴油 长轴 多功能 高顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 15087),
(55766, '柴油 长轴 多功能 中顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 15086),
(55765, '柴油 长轴 标准型 高顶 17座(后双胎)', NULL, 4510, 0, NULL, 'J', 0, 5, 15084),
(55764, '柴油 长轴 标准型 高顶 17座(后单胎)', NULL, 4510, 0, NULL, 'J', 0, 5, 15083),
(55763, '柴油 长轴 标准型 中顶 17座', NULL, 4510, 0, NULL, 'J', 0, 5, 15082),
(55762, '柴油 短轴 标准型 低顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 15081),
(55761, '柴油 短轴 标准型 低顶 8座', NULL, 4510, 0, NULL, 'J', 0, 5, 15080),
(55760, '汽油 短轴 多功能 中顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 14414),
(55759, '汽油 短轴 多功能 低顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 14413),
(55758, '汽油 短轴 多功能 中顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14412),
(55757, '汽油 短轴 多功能 低顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14411),
(55756, '汽油 短轴 标准型 中顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 14410),
(55755, '汽油 短轴 标准型 低顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 14409),
(55754, '汽油 短轴 标准型 中顶 8座', NULL, 4510, 0, NULL, 'J', 0, 5, 14408),
(55753, '汽油 短轴 标准型 低顶 8座', NULL, 4510, 0, NULL, 'J', 0, 5, 14407),
(55752, '汽油 短轴 豪华型 中顶 11座', NULL, 4510, 0, NULL, 'J', 0, 5, 14406),
(55751, '汽油 短轴 豪华型 低顶 11座', NULL, 4510, 0, NULL, 'J', 0, 5, 14405),
(55750, '汽油 短轴 豪华型 中顶 7座', NULL, 4510, 0, NULL, 'J', 0, 5, 14404),
(55749, '汽油 短轴 豪华型 低顶 9座', NULL, 4510, 0, NULL, 'J', 0, 5, 14403),
(55748, '汽油 长轴 多功能 中顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 14402),
(55747, '汽油 长轴 多功能 高顶 10座', NULL, 4510, 0, NULL, 'J', 0, 5, 14401),
(55746, '汽油 长轴 标准型 中顶 15座', NULL, 4510, 0, NULL, 'J', 0, 5, 14400),
(55745, '汽油 长轴 标准型 高顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 14399),
(55744, '汽油 长轴 豪华型 高顶 14座', NULL, 4510, 0, NULL, 'J', 0, 5, 14398),
(55743, '汽油 长轴 豪华型 中顶 14座', NULL, 4510, 0, NULL, 'J', 0, 5, 14397),
(55742, '柴油 加长轴 后双胎 中顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14208),
(55741, '柴油 加长轴 后单胎 中顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14207),
(55740, '柴油 加长轴 后单胎 高顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14206),
(55739, '柴油 加长轴 后双胎 高顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14205),
(55738, '柴油 长轴 豪华型 中顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14204),
(55737, '柴油 长轴 豪华型 高顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14203),
(55736, '柴油 长轴 标准型 中顶 15座', NULL, 4510, 0, NULL, 'J', 0, 5, 14202),
(55735, '柴油 长轴 标准型 高顶 15座', NULL, 4510, 0, NULL, 'J', 0, 5, 14201),
(55734, '柴油 长轴 多功能 中顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14200),
(55733, '柴油 长轴 多功能 高顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14199),
(55732, '柴油 短轴 多功能 中顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14198),
(55731, '柴油 短轴 多功能 低顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14197),
(55730, '柴油 短轴 标准型 中顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 14196),
(55729, '柴油 短轴 标准型 低顶 7座', NULL, 4510, 0, NULL, 'J', 0, 5, 14195),
(55728, '柴油 短轴 豪华型 中顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14194),
(55727, '柴油 短轴 豪华型 低顶', NULL, 4510, 0, NULL, 'J', 0, 5, 14193),
(55726, '汽油 短轴 标准型 中顶 7座', NULL, 4510, 0, NULL, 'J', 0, 5, 14192),
(55725, '汽油 短轴 标准型 低顶 7座', NULL, 4510, 0, NULL, 'J', 0, 5, 14191),
(55724, '汽油 长轴 豪华型 中顶 9座', NULL, 4510, 0, NULL, 'J', 0, 5, 14190),
(55723, '汽油 短轴 豪华型 低顶 7座', NULL, 4510, 0, NULL, 'J', 0, 5, 14188),
(55722, '汽油 长轴 豪华型 高顶 9座', NULL, 4510, 0, NULL, 'J', 0, 5, 14187),
(55721, '汽油 短轴 豪华型 中顶 9座', NULL, 4510, 0, NULL, 'J', 0, 5, 14186),
(55720, '汽油 长轴 标准型 高顶 15座', NULL, 4510, 0, NULL, 'J', 0, 5, 14185),
(55719, '汽油 长轴 标准型 中顶 12座', NULL, 4510, 0, NULL, 'J', 0, 5, 14184),
(55718, '汽油 长轴 多功能 中顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14183),
(55717, '汽油 长轴 多功能 高顶 6座', NULL, 4510, 0, NULL, 'J', 0, 5, 14181),
(55716, '汽油 短轴 多功能 中顶 3座', NULL, 4510, 0, NULL, 'J', 0, 5, 14180),
(55715, '汽油 短轴 多功能 低顶 3座', NULL, 4510, 0, NULL, 'J', 0, 5, 14179),
(55714, '柴油 加长轴 后双胎 中顶 17座', NULL, 4509, 0, NULL, 'J', 0, 5, 15282),
(55713, '柴油 加长轴 后双胎 高顶 17座', NULL, 4509, 0, NULL, 'J', 0, 5, 15281),
(55712, '柴油 加长轴 后单胎 高顶 17座', NULL, 4509, 0, NULL, 'J', 0, 5, 15280),
(55711, '柴油 加长轴 后单胎 中顶 17座', NULL, 4509, 0, NULL, 'J', 0, 5, 15279),
(55710, '柴油 长轴 豪华型 高顶 14座', NULL, 4509, 0, NULL, 'J', 0, 5, 15278),
(55709, '柴油 长轴 豪华型 中顶 14座', NULL, 4509, 0, NULL, 'J', 0, 5, 15277),
(55708, '柴油 长轴 豪华型 高顶 9座', NULL, 4509, 0, NULL, 'J', 0, 5, 15276),
(55707, '柴油 长轴 豪华型 中顶 9座', NULL, 4509, 0, NULL, 'J', 0, 5, 15275),
(55706, '柴油 短轴 豪华型 低顶 11座', NULL, 4509, 0, NULL, 'J', 0, 5, 15274),
(55705, '柴油 短轴 豪华型 中顶 11座', NULL, 4509, 0, NULL, 'J', 0, 5, 15273),
(55704, '柴油 长轴 标准型 高顶 12座', NULL, 4509, 0, NULL, 'J', 0, 5, 15272),
(55703, '柴油 长轴 标准型 中顶 12座', NULL, 4509, 0, NULL, 'J', 0, 5, 15271),
(55702, '柴油 长轴 多功能 高顶 3座', NULL, 4509, 0, NULL, 'J', 0, 5, 15270),
(55701, '柴油 长轴 多功能 高顶 10座', NULL, 4509, 0, NULL, 'J', 0, 5, 15269),
(55700, '柴油 长轴 多功能 高顶 6座', NULL, 4509, 0, NULL, 'J', 0, 5, 15268),
(55699, '柴油 长轴 多功能 中顶 6座', NULL, 4509, 0, NULL, 'J', 0, 5, 15265),
(55698, '柴油 长轴 多功能 中顶 10座', NULL, 4509, 0, NULL, 'J', 0, 5, 15263),
(55697, '柴油 长轴 多功能 中顶 3座', NULL, 4509, 0, NULL, 'J', 0, 5, 15262),
(55696, '柴油 短轴 豪华型 中顶 7座', NULL, 4509, 0, NULL, 'J', 0, 5, 15261),
(55695, '柴油 短轴 豪华型 低顶 7座', NULL, 4509, 0, NULL, 'J', 0, 5, 15260),
(55694, '柴油 短轴 标准型 低顶 7座', NULL, 4509, 0, NULL, 'J', 0, 5, 15259),
(55693, '柴油 短轴 标准型 中顶 7座', NULL, 4509, 0, NULL, 'J', 0, 5, 15258),
(55692, '柴油 短轴 多功能 中顶 10座', NULL, 4509, 0, NULL, 'J', 0, 5, 15257),
(55691, '柴油 短轴 多功能 中顶 6座', NULL, 4509, 0, NULL, 'J', 0, 5, 15256),
(55690, '柴油 短轴 多功能 中顶 3座', NULL, 4509, 0, NULL, 'J', 0, 5, 15255),
(55689, '柴油 短轴 多功能 低顶 10座', NULL, 4509, 0, NULL, 'J', 0, 5, 15254),
(55688, '柴油 短轴 多功能 低顶 6座', NULL, 4509, 0, NULL, 'J', 0, 5, 15253),
(55687, '柴油 短轴 多功能 低顶 3座', NULL, 4509, 0, NULL, 'J', 0, 5, 15252),
(55686, '柴油 短轴 多功能 中顶 3座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15251),
(55685, '柴油 短轴 多功能 中顶 6座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15250),
(55684, '柴油 短轴 多功能 中顶 10座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15249),
(55683, '柴油 短轴 多功能 低顶 10座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15248),
(55682, '柴油 短轴 多功能 低顶 6座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15247),
(55681, '柴油 短轴 多功能 低顶 3座(75KW)', NULL, 4509, 0, NULL, 'J', 0, 5, 15246),
(55680, '柴油 长轴 物流型 中顶 10座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 106437),
(55679, '柴油 长轴 物流型 中顶 10座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 106436),
(55678, '柴油 长轴 普通型 中顶 12座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 106435),
(55677, '柴油 长轴 普通型 中顶 12座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 106434),
(55676, '柴油 短轴 物流型 中顶 5座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105846),
(55675, '柴油 短轴 物流型 中顶 5座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105845),
(55674, '汽油 长轴  中顶 物流车 7座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105590),
(55673, '汽油 长轴  高顶 物流车 7座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105589),
(55672, '汽油 短轴  中顶 物流车 7座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105588),
(55671, '汽油 短轴  低顶 物流车 7座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105587),
(55670, '汽油 短轴  低顶 物流车 6座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105586),
(55669, '汽油 短轴  中顶 物流车 6座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105585),
(55668, '汽油 短轴  中顶 物流车 10座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105584),
(55667, '汽油 短轴  低顶 物流车 10座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105583),
(55666, '汽油 短轴  低顶 12座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105582),
(55665, '汽油 短轴  中顶 12座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105581),
(55664, '汽油 短轴  中顶 7座 普通型 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105580),
(55663, '汽油 短轴  低顶 7座 普通型 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105579),
(55662, '汽油 短轴  低顶 11座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105578),
(55661, '汽油 短轴  中顶 11座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105577),
(55660, '汽油 长轴  高顶 物流车 6座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105575),
(55659, '汽油 长轴  中顶 物流车 6座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105574),
(55658, '汽油 长轴  中顶 物流车 10座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105573),
(55657, '汽油 长轴  高顶 物流车 10座  国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105572),
(55656, '汽油 长轴  中顶 12座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105571),
(55655, '汽油 长轴  高顶 12座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105570),
(55654, '汽油 长轴  高顶 15座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105569),
(55653, '汽油 长轴  中顶 15座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105567),
(55652, '汽油 长轴  中顶 14座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105566),
(55651, '汽油 长轴  高顶 14座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105560),
(55650, '柴油 加长轴 后单胎 中顶 17座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105425),
(55649, '柴油 加长轴 后单胎 中顶 17座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105424),
(55648, '柴油 加长轴 后双胎 高顶 17座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105423),
(55647, '柴油 加长轴 后双胎 高顶 17座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105419),
(55646, '柴油 短轴 厢式运输车 中顶 3座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105417),
(55645, '柴油 短轴 厢式运输车 中顶 3座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105416),
(55644, '柴油 长轴 冰白物流车 中顶 6座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105415),
(55643, '柴油 长轴 冰白物流车 中顶 6座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105414),
(55642, '柴油 短轴 普通型 中顶 7座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105413),
(55641, '柴油 短轴 普通型 中顶 7座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105412),
(55640, '柴油 短轴 物流型 中顶 6座 国3', NULL, 4508, 0, NULL, 'J', 0, 5, 105411),
(55639, '柴油 短轴 物流型 中顶 6座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105410),
(55638, '柴油 长轴 普通型 中顶 15座 国4', NULL, 4508, 0, NULL, 'J', 0, 5, 105409),
(55637, '柴油 长轴 普通型 中顶 15座 国3 ', NULL, 4508, 0, NULL, 'J', 0, 5, 105408),
(55636, '柴油 短轴 3座 中顶厢式运输车（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111373),
(55635, '柴油 短轴 3座 中顶厢式运输车（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111372),
(55634, '柴油 短轴 6座 中顶物流型（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111371),
(55633, '柴油 短轴 6座 中顶物流型（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111370),
(55632, '柴油 短轴 7座 中顶普通型（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111369),
(55631, '柴油 短轴 7座 中顶普通型（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111368),
(55630, '柴油 长轴 15座 中顶普通型（国3） ', NULL, 4507, 0, NULL, 'J', 0, 5, 111365),
(55629, '柴油 长轴 15座 中顶普通型（国4） ', NULL, 4507, 0, NULL, 'J', 0, 5, 111364),
(55628, '柴油 长轴 6座 中顶冰白物流车（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111362),
(55627, '柴油 长轴 6座 中顶冰白物流车（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111361),
(55626, '柴油 加长 17座 高顶 后双胎 冰白 ABS（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111358),
(55625, '柴油 加长 17座 高顶 后双胎 冰白 ABS（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111357),
(55624, '柴油 加长 17座 中顶 后单胎 冰白 ABS（国3）', NULL, 4507, 0, NULL, 'J', 0, 5, 111355),
(55623, '柴油 加长 17座 中顶 后单胎 冰白 ABS（国4）', NULL, 4507, 0, NULL, 'J', 0, 5, 111354),
(55622, '加长14座高顶普通型双胎ABS(带侧拉门)M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10090),
(55621, '加长13座高顶普通型单胎ABS(无侧拉门)M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10089),
(55620, '加长6座高顶双胎经济型 KOMBI带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10088),
(55619, '长3座中顶经济型VAN带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10087),
(55618, '短3座中顶经济型VAN带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10086),
(55617, '长15座中顶豪华型ABS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10085),
(55616, '长15座中顶普通型带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10084),
(55615, '长14座中顶普通型带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10083),
(55614, '长6座中顶经济型带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 10082),
(55613, '加长17座高顶普通型双胎ABS(无侧拉门)M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5886),
(55612, '加长15座高顶普通型单胎ABS(无侧拉门)M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5885),
(55611, '短7座低顶豪华型ABS KOMBI/M1BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5884),
(55610, '短7座低顶普通型 KOMBI/M1BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5883),
(55609, '短7座中顶豪华型ABS KOMBI/M1BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5882),
(55608, '短7座中顶普通型 KOMBI/M1BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5881),
(55607, '短轴6座中顶115PS KOMBI(带PEP)', NULL, 4506, 0, NULL, 'J', 0, 5, 5880),
(55606, '短轴6座低顶115PS KOMBI(带PEP)', NULL, 4506, 0, NULL, 'J', 0, 5, 5879),
(55605, '短12座低顶普通型 M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5878),
(55604, '短12座中顶普通型 M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5877),
(55603, '长10座中顶豪华型ABS带PEP(独立座椅)', NULL, 4506, 0, NULL, 'J', 0, 5, 5876),
(55602, '长10座中顶普通型带PEP(独立座椅)', NULL, 4506, 0, NULL, 'J', 0, 5, 5875),
(55601, '短10座低顶普通型 M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5874),
(55600, '短10座中顶普通型 M2BUS带PEP', NULL, 4506, 0, NULL, 'J', 0, 5, 5873),
(55599, '柴油 加长轴 标准型 高顶 17座 双胎(带侧拉门)', NULL, 4505, 0, NULL, 'J', 0, 5, 15097),
(55598, '柴油 加长轴 标准型 高顶 17座 双胎(无侧拉门)', NULL, 4505, 0, NULL, 'J', 0, 5, 15096),
(55597, '柴油 加长轴 标准型 中顶 17座 双胎 (无侧拉门)', NULL, 4505, 0, NULL, 'J', 0, 5, 15095),
(55596, '柴油 长轴 标准型 中顶 15座', NULL, 4505, 0, NULL, 'J', 0, 5, 15094),
(55595, '柴油 长轴 标准型 中顶 14座', NULL, 4505, 0, NULL, 'J', 0, 5, 15093),
(55594, '柴油 短轴 标准型 低顶 12座', NULL, 4505, 0, NULL, 'J', 0, 5, 15092),
(55593, '柴油 短轴 标准型 中顶 12座', NULL, 4505, 0, NULL, 'J', 0, 5, 15091),
(55592, '柴油 短轴 标准型 中顶 10座', NULL, 4505, 0, NULL, 'J', 0, 5, 15090),
(55591, '柴油 短轴 标准型 低顶 10座', NULL, 4505, 0, NULL, 'J', 0, 5, 15089),
(55590, '柴油 15座长轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14974),
(55589, '柴油 10座长轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14973),
(55588, '柴油 7座短轴 豪华型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14972),
(55587, '柴油 7座短轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14971),
(55586, '柴油 17座加长轴 普通型双胎 高顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14970),
(55585, '柴油 17座加长轴 普通型双胎 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14969),
(55584, '柴油 16座加长轴 普通型单胎 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14968),
(55583, '柴油 15座加长轴 普通型单胎 高顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14967),
(55582, '柴油 15座长轴 普通型 高顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14966),
(55581, '柴油 15座长轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14965),
(55580, '柴油 14座长轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14964),
(55579, '柴油 10座长轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14963),
(55578, '柴油 12座短轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14962),
(55577, '柴油 12座短轴 普通型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14961),
(55576, '柴油 10座短轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14960),
(55575, '柴油 10座短轴 普通型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14959),
(55574, '柴油 7座短轴 普通型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14958),
(55573, '柴油 7座短轴 普通型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14957),
(55572, '柴油 加长轴 标准型 高顶 15座 单胎(无侧拉门)', NULL, 4505, 0, NULL, 'J', 0, 5, 14178),
(55571, '柴油 加长轴 标准型 中顶 16座 单胎(带侧拉门)', NULL, 4505, 0, NULL, 'J', 0, 5, 14177),
(55570, '柴油 加长轴 多功能 高顶 6座', NULL, 4505, 0, NULL, 'J', 0, 5, 14176),
(55569, '柴油 加长轴 多功能 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14175),
(55568, '柴油 长轴 豪华型 高顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14174),
(55567, '柴油 长轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14173),
(55566, '柴油 长轴 标准型 高顶 15座', NULL, 4505, 0, NULL, 'J', 0, 5, 14172),
(55565, '柴油 长轴 标准型 中顶 10座', NULL, 4505, 0, NULL, 'J', 0, 5, 14171),
(55564, '柴油 长轴 多功能 高顶 6座', NULL, 4505, 0, NULL, 'J', 0, 5, 14170),
(55563, '柴油 短轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14169),
(55562, '柴油 长轴 多功能 中顶 6座', NULL, 4505, 0, NULL, 'J', 0, 5, 14168),
(55561, '柴油 短轴 豪华型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14160),
(55560, '柴油 短轴 标准型 中顶 7座', NULL, 4505, 0, NULL, 'J', 0, 5, 14159),
(55559, '柴油 短轴 多功能 中顶 6座', NULL, 4505, 0, NULL, 'J', 0, 5, 14158),
(55558, '柴油 短轴 标准型 低顶 7座', NULL, 4505, 0, NULL, 'J', 0, 5, 14157),
(55557, '柴油 短轴 多功能 低顶 6座', NULL, 4505, 0, NULL, 'J', 0, 5, 14156),
(55556, '汽油 长轴 豪华型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14155),
(55555, '汽油 长轴 标准型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14154),
(55554, '汽油 短轴 标准型 中顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14153),
(55553, '汽油 短轴 标准型 低顶', NULL, 4505, 0, NULL, 'J', 0, 5, 14152),
(55552, '柴油 7座长轴 高顶 经济型（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 111429),
(55551, '柴油 10座长轴 豪华型 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 106432),
(55550, '柴油 10座长轴 豪华型 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106431),
(55549, '柴油 10座长轴 标准型 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 106430),
(55548, '柴油 10座长轴 标准型 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106429),
(55547, '柴油 11座长轴 标准型 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 106428),
(55546, '柴油 11座长轴 标准型 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106427),
(55545, '柴油 6座长轴 多功能 中顶（国4） ', NULL, 4504, 0, NULL, 'J', 0, 5, 106426),
(55544, '柴油 6座长轴 多功能 高顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106425),
(55543, '柴油 6座加长轴 多功能 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106424),
(55542, '柴油 6座加长轴 多功能 高顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106423),
(55541, '柴油 6座短轴 多功能 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106422),
(55540, '柴油 6座短轴 多功能 中低顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106421),
(55539, '柴油 15座长轴 豪华型 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106420),
(55538, '柴油 15座长轴 标准型 中顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 106419),
(55537, '柴油 加长轴17座 标准型 高顶（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 105844),
(55536, '柴油 加长轴17座 标准型 高顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 105843),
(55535, '柴油 加长轴17座 中顶普通型 后双胎（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 105842),
(55534, '柴油 加长轴17座 中顶普通型 后双胎（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 105841),
(55533, '柴油 7座长轴 中顶 经济型（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 105840),
(55532, '柴油 7座长轴 中顶 经济型（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 105838),
(55531, '柴油 7座短轴 中低顶 标准型（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 105837),
(55530, '柴油 7座短轴 中低顶 豪华（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 105790),
(55529, '柴油 7座短轴 中低顶 豪华（国4）', NULL, 4504, 0, NULL, 'J', 0, 5, 105789),
(55528, '柴油 7座短轴 中低顶 豪华（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 105788),
(55527, '柴油 6座短轴 多功能 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104692),
(55526, '柴油 6座短轴 多功能 中低顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104691),
(55525, '柴油 6座长轴 多功能 高顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104688),
(55524, '柴油 15座长轴 标准型 高顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104687),
(55523, '柴油 15座长轴 豪华型 高顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104686),
(55522, '柴油 6座加长轴 多功能 高顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104685),
(55521, '柴油 17座加长轴 标准型 高顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104683),
(55520, '柴油 17座加长轴 标准型 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104682),
(55519, '柴油 6座加长轴 多功能 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104681),
(55518, '柴油 15座长轴 豪华型 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104680),
(55517, '柴油 15座长轴 标准型 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104676),
(55516, '柴油 6座长轴 多功能 中顶（国5）', NULL, 4504, 0, NULL, 'J', 0, 5, 104675),
(55515, '柴油 6座短轴 多功能 中低顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104669),
(55514, '柴油 6座短轴 多功能 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104667),
(55513, '柴油 6座加长轴 多功能 高顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104664),
(55512, '柴油 6座长轴 多功能 高顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104662),
(55511, '柴油 6座加长轴 多功能 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104660),
(55510, '柴油 15座长轴 豪华型 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104659),
(55509, '柴油 15座长轴 标准型 中顶（国3）', NULL, 4504, 0, NULL, 'J', 0, 5, 104658),
(55508, '柴油 6座长轴 多功能 中顶（国3） ', NULL, 4504, 0, NULL, 'J', 0, 5, 104636),
(55507, '柴油 短轴 6座 经济中顶物流车（国3）', NULL, 4503, 0, NULL, 'J', 0, 5, 111428),
(55506, '柴油 短轴 6座 经济中顶物流车（国4）', NULL, 4503, 0, NULL, 'J', 0, 5, 111427),
(55505, '柴油 短轴 7座 中低顶豪华（国3）', NULL, 4503, 0, NULL, 'J', 0, 5, 111425),
(55504, '柴油 短轴 7座 中低顶豪华（国4）', NULL, 4503, 0, NULL, 'J', 0, 5, 111424),
(55503, '柴油 长轴 7座 中顶经济型（国3）', NULL, 4503, 0, NULL, 'J', 0, 5, 111422),
(55502, '柴油 长轴 7座 中顶经济型（国4）', NULL, 4503, 0, NULL, 'J', 0, 5, 111421),
(55501, '柴油 加长轴 17座 中顶普通型 后双胎（国3）', NULL, 4503, 0, NULL, 'J', 0, 5, 111420),
(55500, '柴油 加长轴 17座 中顶普通型 后双胎（国4）', NULL, 4503, 0, NULL, 'J', 0, 5, 111419),
(55499, '柴油 加长轴 17座 高顶普通型（国3）', NULL, 4503, 0, NULL, 'J', 0, 5, 111418),
(55498, '柴油 加长轴 17座 高顶普通型（国4）', NULL, 4503, 0, NULL, 'J', 0, 5, 111415),
(55497, '4×2五座(LX)柴油 豪华型', NULL, 4502, 0, NULL, 'J', 0, 5, 13355),
(55496, 'JX493Q1', NULL, 4502, 0, NULL, 'J', 0, 5, 4285),
(55495, '4×2七座(LX)柴油 豪华型', NULL, 4502, 0, NULL, 'J', 0, 5, 1640),
(55494, '4×2五座(GL)汽油 豪华型', NULL, 4502, 0, NULL, 'J', 0, 5, 1639),
(55493, '汽油两驱七座豪华', NULL, 4502, 0, NULL, 'J', 0, 5, 1638),
(55492, '4×4五座(LX)柴油 豪华型', NULL, 4502, 0, NULL, 'J', 0, 5, 1637),
(55491, '4×2五座(LX)柴油 标准型', NULL, 4502, 0, NULL, 'J', 0, 5, 1636),
(55490, '汽油两驱七座标配', NULL, 4502, 0, NULL, 'J', 0, 5, 1635),
(55489, '柴油两驱七座豪华', NULL, 4502, 0, NULL, 'J', 0, 5, 1634),
(55488, '柴油四驱七座标配', NULL, 4502, 0, NULL, 'J', 0, 5, 1633),
(55487, '汽油 4×2 五座 GL', NULL, 4501, 0, NULL, 'J', 0, 5, 14375),
(55486, '柴油 4×4 五座 LX', NULL, 4501, 0, NULL, 'J', 0, 5, 14374),
(55485, '柴油 4×2 七座 LX', NULL, 4501, 0, NULL, 'J', 0, 5, 14373),
(55484, '柴油 4×2 五座 LX', NULL, 4501, 0, NULL, 'J', 0, 5, 14372),
(55483, 'JX1021SW 4*2', NULL, 4500, 0, NULL, 'J', 0, 5, 6778),
(55482, '宝典柴油匹卡JX1023DSE', NULL, 4499, 0, NULL, 'J', 0, 5, 7738),
(55481, '宝典柴油匹卡JX1021DSF', NULL, 4499, 0, NULL, 'J', 0, 5, 7737),
(55480, '柴油超值版 4×4 MT(LX)', NULL, 4498, 0, NULL, 'J', 0, 5, 10100),
(55479, '柴油超值版 4×2 MT(LX)', NULL, 4498, 0, NULL, 'J', 0, 5, 10099),
(55478, '宝典三菱动力版 汽油 4×4 超豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 14384),
(55477, '宝典三菱动力版 汽油 4×2 超豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 14383),
(55476, '宝典经典版 柴油 4×4 经济型', NULL, 4497, 0, NULL, 'J', 0, 5, 14382),
(55475, '宝典经典版 柴油 4×2 经济型', NULL, 4497, 0, NULL, 'J', 0, 5, 14381),
(55474, '宝典经典版 柴油 4×4 超豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 14380),
(55473, '宝典经典版 柴油 4×2 超豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 14379),
(55472, '宝典三菱动力版 TX1021PSD3(汽油4×4) 豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 12055),
(55471, '宝典三菱动力版 TX1020PSD3(汽油4×2) 豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 12054),
(55470, '宝典经典版 JX1021TS3(柴油4×4) 豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 12053),
(55469, '宝典经典版 JX1021TS3(柴油4×4) 标准型', NULL, 4497, 0, NULL, 'J', 0, 5, 12052),
(55468, '宝典经典版 JX1020TS3(柴油4×2) 豪华型', NULL, 4497, 0, NULL, 'J', 0, 5, 12051),
(55467, '宝典经典版 JX1020TS3(柴油4×2) 标准型', NULL, 4497, 0, NULL, 'J', 0, 5, 12048),
(55466, '宝典时尚版 4×2MT(LX)汽油 标准型', NULL, 4496, 0, NULL, 'J', 0, 5, 101540),
(55465, '2.8L 手动 四驱  超值版 柴油', NULL, 4496, 0, NULL, 'J', 0, 5, 101539),
(55464, '2.8L 手动 两驱 超值版 柴油', NULL, 4496, 0, NULL, 'J', 0, 5, 101538),
(55463, '宝典时尚版 4×2MT(LX)柴油 豪华型', NULL, 4496, 0, NULL, 'J', 0, 5, 12050),
(55462, '宝典时尚版 4×4MT(LX)柴油 豪华型', NULL, 4496, 0, NULL, 'J', 0, 5, 12049),
(55461, '宝典时尚版 4×4MT(LX)柴油 标准型', NULL, 4496, 0, NULL, 'J', 0, 5, 10102),
(55460, '宝典时尚版 4×2MT(LX)柴油 标准型', NULL, 4496, 0, NULL, 'J', 0, 5, 10101),
(55459, '宝典时尚版 4×2MT(GL)汽油 标准型', NULL, 4496, 0, NULL, 'J', 0, 5, 4284),
(55458, '新时尚版 2.8T 手动 四驱 豪华型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109844),
(55457, '新时尚版 2.8T 手动 四驱 舒适型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109843),
(55456, '新时尚版 2.8T 手动 两驱 豪华型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109842),
(55455, '新时尚版 2.8T 手动 两驱 舒适型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109841),
(55454, '新超值版 2.8T 手动 四驱 舒适型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109840),
(55453, '新超值版 2.8T 手动 两驱 舒适型 柴油 国III', NULL, 4495, 0, NULL, 'J', 0, 5, 109839),
(55452, '新时尚版 2.8T 手动 四驱 豪华型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109838),
(55451, '新时尚版 2.8T 手动 四驱 舒适型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109837),
(55450, '新时尚版 2.8T 手动 两驱 豪华型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109836),
(55449, '新时尚版 2.8T 手动 两驱 舒适型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109835),
(55448, '新超值版 2.8T 手动 四驱 舒适型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109834),
(55447, '新超值版 2.8T 手动 两驱 舒适型 柴油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109833),
(55446, '新超值版 2.4L 手动 四驱 舒适型 汽油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109832),
(55445, '新超值版 2.0L 手动 两驱 舒适型 汽油 国IV', NULL, 4495, 0, NULL, 'J', 0, 5, 109831),
(55444, '2.8L 手动 X80 MC6520C4R3', NULL, 4494, 0, NULL, 'J', 0, 5, 14461),
(55443, '2.2L 手动 X80 MC6480MQ', NULL, 4494, 0, NULL, 'J', 0, 5, 14460),
(55442, '绵阳JM491Q-ME 经济型', NULL, 4493, 0, NULL, 'J', 0, 5, 9386),
(55441, '长城GW2.8TC—2 标准型', NULL, 4493, 0, NULL, 'J', 0, 5, 9385),
(55440, '长城GW2.8TC—2 豪华型', NULL, 4493, 0, NULL, 'J', 0, 5, 9384),
(55439, '全柴4D20E 豪华型', NULL, 4493, 0, NULL, 'J', 0, 5, 9256),
(55438, '绵阳V19 标准型', NULL, 4493, 0, NULL, 'J', 0, 5, 9253),
(55437, '绵阳V19 豪华型', NULL, 4493, 0, NULL, 'J', 0, 5, 9252),
(55436, '2.8L 手动 X50 MC6500CDN3', NULL, 4492, 0, NULL, 'J', 0, 5, 14463),
(55435, '2.2L 手动 X50 MC6450MQ', NULL, 4492, 0, NULL, 'J', 0, 5, 14462),
(55434, 'MC6320A 3GV2汽油机', NULL, 4491, 0, NULL, 'J', 0, 5, 9488),
(55433, 'MC6320A SQR372 汽油机', NULL, 4491, 0, NULL, 'J', 0, 5, 9243),
(55432, '长城GW2.8TC—2 标准型', NULL, 4490, 0, NULL, 'J', 0, 5, 9391),
(55431, '长城GW2.8TC—2 豪华型', NULL, 4490, 0, NULL, 'J', 0, 5, 9390),
(55430, '长城GW2.8TC—2 标准型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9389),
(55429, '长城GW2.8TC—2 豪华型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9388),
(55428, '绵阳JM491Q—ME 经济型', NULL, 4490, 0, NULL, 'J', 0, 5, 9387),
(55427, '绵阳V19 豪华型', NULL, 4490, 0, NULL, 'J', 0, 5, 9255),
(55426, '绵阳V19 标准型', NULL, 4490, 0, NULL, 'J', 0, 5, 9254),
(55425, '绵阳V19 标准型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9251),
(55424, '绵阳V19 豪华型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9250),
(55423, '全柴4D20E 豪华型', NULL, 4490, 0, NULL, 'J', 0, 5, 9249),
(55422, '全柴4D20E 豪华型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9248),
(55421, '绵阳JM491Q—ME 豪华型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9247),
(55420, '绵阳JM491Q—ME 标准型(雪佛莱)', NULL, 4490, 0, NULL, 'J', 0, 5, 9246),
(55419, 'K3 2.2L 手动 精英版 汽油 MC1021MQ', NULL, 4489, 0, NULL, 'J', 0, 5, 110668),
(55418, 'K3 2.2L 手动 豪华版 汽油 MC1021MQ', NULL, 4489, 0, NULL, 'J', 0, 5, 110667),
(55417, 'K5 2.2L 手动 精英版 汽油 MC1021MQ', NULL, 4489, 0, NULL, 'J', 0, 5, 110666),
(55416, 'K5 2.2L 手动 豪华版 汽油 MC1021MQ', NULL, 4489, 0, NULL, 'J', 0, 5, 110665),
(55415, 'K3 2.8T 手动 精英版 柴油 MC1021CH4R4(T)', NULL, 4489, 0, NULL, 'J', 0, 5, 110664),
(55414, 'K3 2.8T 手动 豪华版 柴油 MC1021CH4R4(T)', NULL, 4489, 0, NULL, 'J', 0, 5, 110663),
(55413, 'K5 2.8T 手动 精英版 柴油 MC1021CH4R4(T)', NULL, 4489, 0, NULL, 'J', 0, 5, 110662),
(55412, 'K5 2.8T 手动 豪华版 柴油 MC1021CH4R4(T)', NULL, 4489, 0, NULL, 'J', 0, 5, 110661),
(55411, 'K3 2.5T 手动 精英版 柴油 MC1021CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110660),
(55410, 'K3 2.5T 手动 豪华版 柴油 MC1021CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110659),
(55409, 'K5 2.5T 手动 精英版 柴油 MC1021CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110658),
(55408, 'K5 2.5T 手动 豪华版 柴油 MC1021CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110657),
(55407, 'K3 2.8T 手动 精英版 柴油 MC1022CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110656),
(55406, 'K3 2.8T 手动 豪华版 柴油 MC1022CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110655),
(55405, 'K5 2.8T 手动 精英版 柴油 MC1022CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110654),
(55404, 'K5 2.8T 手动 豪华版 柴油 MC1022CJ4R4', NULL, 4489, 0, NULL, 'J', 0, 5, 110653),
(55403, '2.8L 手动 柴油款加长版 MC1021C5R3', NULL, 4489, 0, NULL, 'J', 0, 5, 14476),
(55402, '2.8L 手动 柴油款 MC1021C4R3', NULL, 4489, 0, NULL, 'J', 0, 5, 14475),
(55401, '2.2L 手动 汽油款加长版 MC1021MQL', NULL, 4489, 0, NULL, 'J', 0, 5, 14474),
(55400, '2.2L 手动 汽油款 MC1021MQ', NULL, 4489, 0, NULL, 'J', 0, 5, 14473),
(55399, 'K3 2.2L 手动 精英版 汽油/CNG MC1021TK4R', NULL, 4488, 0, NULL, 'J', 0, 5, 110646),
(55398, 'K3 2.2L 手动 豪华版 汽油/CNG MC1021TK4R', NULL, 4488, 0, NULL, 'J', 0, 5, 110645),
(55397, 'K5 2.2L 手动 精英版 汽油/CNG MC1021TK4R', NULL, 4488, 0, NULL, 'J', 0, 5, 110644),
(55396, 'K5 2.2L 手动 豪华版 汽油/CNG MC1021TK4R', NULL, 4488, 0, NULL, 'J', 0, 5, 110643),
(55395, 'K3 2.5T 手动 财运版 柴油 MC1021CJ4R4', NULL, 4488, 0, NULL, 'J', 0, 5, 110642),
(55394, 'K5 2.5T 手动 财运版 柴油 MC1021CJ4R4', NULL, 4488, 0, NULL, 'J', 0, 5, 110641),
(55393, '征途 2.4L 手动 汽油 MC1030QNFR4', NULL, 4488, 0, NULL, 'J', 0, 5, 110640),
(55392, '1.0L 手动 汽油 单排 HFC1021FA', NULL, 4487, 0, NULL, 'J', 0, 5, 110639),
(55391, '1.0L 手动 汽油 双排 HFC1021RFA', NULL, 4487, 0, NULL, 'J', 0, 5, 110638),
(55390, '1.8T 手动 柴油 单排 HFC1021KFA', NULL, 4487, 0, NULL, 'J', 0, 5, 110637),
(55389, '1.8T 手动 柴油 单排 HFC1030KFA', NULL, 4487, 0, NULL, 'J', 0, 5, 110636),
(55388, '1.8T 手动 柴油 双排 HFC1030K1RFA', NULL, 4487, 0, NULL, 'J', 0, 5, 110635),
(55387, '1.8T 手动 柴油 双排 HFC1030KRVA', NULL, 4487, 0, NULL, 'J', 0, 5, 110634),
(55386, '1.8L 手动 仓栅式运输车柴油款 HFC5024CCYKTA', NULL, 4487, 0, NULL, 'J', 0, 5, 14471),
(55385, '1.0L 手动 仓栅式运输车汽油款 HFC5024CCYFA', NULL, 4487, 0, NULL, 'J', 0, 5, 14470),
(55384, '1.8L 手动 厢式运输车柴油款 HFC5024XXYKTA', NULL, 4487, 0, NULL, 'J', 0, 5, 14469),
(55383, '1.0L 手动 厢式运输车汽油款 HFC5024XXYFA', NULL, 4487, 0, NULL, 'J', 0, 5, 14468),
(55382, '1.8L 手动 双排柴油款 HFC1021KRTA', NULL, 4487, 0, NULL, 'J', 0, 5, 14467),
(55381, '1.0L 手动 双排汽油款 HFC1021RFA', NULL, 4487, 0, NULL, 'J', 0, 5, 14466),
(55380, '1.8L 手动 单排柴油款 HFC1021KTA', NULL, 4487, 0, NULL, 'J', 0, 5, 14465),
(55379, '1.0L 手动 单排汽油款 HFC1021FA', NULL, 4487, 0, NULL, 'J', 0, 5, 14464),
(55378, 'Z7 长城GW2.8TC—2 标准型', NULL, 4486, 0, NULL, 'J', 0, 5, 9383),
(55377, 'Z7 长城GW2.8TC—2 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9382),
(55376, 'Z6 长城GW2.8TC—2 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9381),
(55375, 'Z6 长城GW2.8TC—2 标准型', NULL, 4486, 0, NULL, 'J', 0, 5, 9380),
(55374, 'Z6 全柴4D20E 经济型', NULL, 4486, 0, NULL, 'J', 0, 5, 9379),
(55373, 'Z7 全柴4D20E 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9265),
(55372, 'Z7 绵阳V19 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9264),
(55371, 'Z7 绵阳JM491Q-ME 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9263),
(55370, 'Z6 绵阳JM491Q—ME 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9262),
(55369, 'Z6 绵阳V19 豪华型', NULL, 4486, 0, NULL, 'J', 0, 5, 9261),
(55368, 'Z5 MC1021AC3C', NULL, 4486, 0, NULL, 'J', 0, 5, 9260),
(55367, 'Z5 MC1021AC2', NULL, 4486, 0, NULL, 'J', 0, 5, 9259),
(55365, 'S7', NULL, 4485, 0, NULL, 'J', 0, 5, 9245),
(55366, 'Z5 MC1021AG4', NULL, 4486, 0, NULL, 'J', 0, 5, 9258),
(55364, 'S5', NULL, 4485, 0, NULL, 'J', 0, 5, 9244),
(55363, '四驱 NHQ1028Q3Y', NULL, 4484, 0, NULL, 'J', 0, 5, 13344),
(55362, '0.8L', NULL, 4483, 0, NULL, 'J', 0, 5, 6553),
(55361, '1.3 手自一体 舒适型 ', NULL, 4482, 0, NULL, 'J', 0, 5, 108448),
(55360, '1.3 手自一体 豪华型 ', NULL, 4482, 0, NULL, 'J', 0, 5, 108447),
(55359, '豪华型 1.3L MT', NULL, 4482, 0, NULL, 'J', 0, 5, 12597),
(55358, '舒适型 1.3L MT', NULL, 4482, 0, NULL, 'J', 0, 5, 12596),
(55357, '豪华型 1.0L MT', NULL, 4482, 0, NULL, 'J', 0, 5, 12595),
(55356, '舒适型 1.0L MT', NULL, 4482, 0, NULL, 'J', 0, 5, 12594),
(55355, '1.0L 手动 豪华型', NULL, 4481, 0, NULL, 'J', 0, 5, 13502),
(55354, '豪华型 1.3L AMT', NULL, 4481, 0, NULL, 'J', 0, 5, 12868),
(55353, '舒适型 1.3L AMT', NULL, 4481, 0, NULL, 'J', 0, 5, 12867),
(55352, 'CROSS 1.0L 手动 豪华型', NULL, 4480, 0, NULL, 'J', 0, 5, 101949),
(55351, 'CROSS 1.0L 手动 舒适型', NULL, 4480, 0, NULL, 'J', 0, 5, 101947),
(55350, '1.0L 手动 豪华型', NULL, 4480, 0, NULL, 'J', 0, 5, 15941),
(55349, '1.0L 手动 舒适型', NULL, 4480, 0, NULL, 'J', 0, 5, 15938),
(55348, 'CROSS 1.3L 手动 豪华型', NULL, 4479, 0, NULL, 'J', 0, 5, 106323),
(55347, 'CROSS 1.0L 手动 舒适型', NULL, 4479, 0, NULL, 'J', 0, 5, 106322),
(55346, 'CROSS 1.0L 手动 豪华型', NULL, 4479, 0, NULL, 'J', 0, 5, 106321),
(55345, '1.0L 手动 舒适型', NULL, 4479, 0, NULL, 'J', 0, 5, 106320),
(55344, '1.0L 手动 豪华型', NULL, 4479, 0, NULL, 'J', 0, 5, 106319),
(55343, '1.0L 手动 国际版 舒适型', NULL, 4479, 0, NULL, 'J', 0, 5, 103654),
(55342, '1.0L 手动 国际版 豪华型', NULL, 4479, 0, NULL, 'J', 0, 5, 103653),
(55341, '1.0L 手动 国际版 导航版', NULL, 4479, 0, NULL, 'J', 0, 5, 103651),
(55340, 'J2 1.0L 手动 舒适型', NULL, 4478, 0, NULL, 'J', 0, 5, 111284),
(55339, 'J2 1.0L 手动 豪华型', NULL, 4478, 0, NULL, 'J', 0, 5, 111283),
(55338, '商务客车2.8 手动 旅行版', NULL, 4477, 0, NULL, 'J', 0, 5, 108446),
(55337, '商务客车2.8 手动 快运版', NULL, 4477, 0, NULL, 'J', 0, 5, 108445),
(55336, '商务客车2.8 手动 舒适版', NULL, 4477, 0, NULL, 'J', 0, 5, 108444),
(55335, '商务客车2.8 手动 商务版', NULL, 4477, 0, NULL, 'J', 0, 5, 108443),
(55334, '2.8L 国四 豪华版', NULL, 4477, 0, NULL, 'J', 0, 5, 15291),
(55333, '2.8L 国三 豪华版', NULL, 4477, 0, NULL, 'J', 0, 5, 15290),
(55332, '2.8L 国四 旅行版', NULL, 4477, 0, NULL, 'J', 0, 5, 13232),
(55331, '2.8L 国三 旅行版', NULL, 4477, 0, NULL, 'J', 0, 5, 13231),
(55330, '2.8L 国四 快运版', NULL, 4477, 0, NULL, 'J', 0, 5, 13230),
(55329, '2.8L 国三 快运版', NULL, 4477, 0, NULL, 'J', 0, 5, 13229),
(55328, '2.8L 国四 舒适版', NULL, 4477, 0, NULL, 'J', 0, 5, 13228),
(55327, '2.8L 国三 舒适版', NULL, 4477, 0, NULL, 'J', 0, 5, 13227),
(55326, '2.8L 国四 商务版', NULL, 4477, 0, NULL, 'J', 0, 5, 13226),
(55325, '2.8L 国三 商务版', NULL, 4477, 0, NULL, 'J', 0, 5, 13225),
(55324, '2.8L 手动 计划生育车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102287),
(55323, '2.8L 手动 计划生育车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102286),
(55322, '2.8L 手动 冷藏车 HFC4DA1-2B2 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102285),
(55321, '2.8L 手动 冷藏车 HFC4DA1-2B2 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102284),
(55320, '2.8L 手动 冷藏车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102283),
(55319, '2.8L 手动 冷藏车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102282),
(55318, '2.8L 手动 流动检测车 HFC4DA1-2B2 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102281),
(55317, '2.8L 手动 流动检测车 HFC4DA1-2B2 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102280),
(55316, '2.8L 手动 流动检测车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102279),
(55315, '2.8L 手动 流动检测车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102278),
(55314, '2.8L 手动 监护型救护车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102277),
(55313, '2.8L 手动 监护型救护车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102276),
(55312, '2.8L 手动 巡回医疗车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102275),
(55311, '2.8L 手动 巡回医疗车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102274),
(55310, '2.8L 手动 押解车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102273),
(55309, '2.8L 手动 押解车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102272),
(55308, '2.8L 手动 移动警务车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102271),
(55307, '2.8L 手动 移动警务车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102270),
(55306, '2.8L 手动 专用校车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102269),
(55305, '2.8L 手动 专用校车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102268),
(55304, '2.8L 手动 工程指挥车 HFC4DA1-2B2 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102266),
(55303, '2.8L 手动 工程指挥车 HFC4DA1-2B2 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102265),
(55302, '2.8L 手动 工程指挥车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102264),
(55301, '2.8L 手动 工程指挥车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102263),
(55300, '2.8L 手动 工程抢险车 HFC4DA1-2B2 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102262),
(55299, '2.8L 手动 工程抢险车 HFC4DA1-2B2 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102261),
(55298, '2.8L 手动 工程抢险车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102260),
(55297, '2.8L 手动 工程抢险车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102259),
(55296, '2.8L 手动 旅居车 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102258),
(55295, '2.8L 手动 旅居车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102257),
(55294, '2.8L 手动 超限检测车 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102256),
(55293, '2.8L 手动 宣传车 HFC4DA1-2B2 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102255),
(55292, '2.8L 手动 宣传车 HFC4DA1-2B2 中顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102254),
(55291, '2.8L 手动 宣传车 HFC4DA1-2B2 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102253),
(55290, '2.8L 手动 宣传车 HFC4DA1-2C 高顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102252),
(55289, '2.8L 手动 宣传车 HFC4DA1-2C 中顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102251),
(55288, '2.8L 手动 宣传车 HFC4DA1-2C 低顶', NULL, 4476, 0, NULL, 'J', 0, 5, 102250),
(55287, '2.8L 手动 厢货-物流版 HFC5049XXYKH2', NULL, 4476, 0, NULL, 'J', 0, 5, 102249),
(55286, '2.8L 手动 厢货-物流版 HFC5049XXYKRH2', NULL, 4476, 0, NULL, 'J', 0, 5, 102248),
(55285, '2.8L 手动 舒适版 HFC4DA1-2C 5系', NULL, 4476, 0, NULL, 'J', 0, 5, 102247),
(55284, '2.8L 手动 商务版 HFC4DA1-2B2', NULL, 4476, 0, NULL, 'J', 0, 5, 102246),
(55283, '2.8L 手动 商务版 HFC4DA1-2C', NULL, 4476, 0, NULL, 'J', 0, 5, 102245),
(55282, '2.8T 5系 星快运 6座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 106466),
(55281, '2.8T 4系 物流版 3座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104739),
(55280, '2.8T 6系 商务版 14座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104183),
(55279, '2.8T 6系 商务版 14座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104182),
(55278, '2.5T 6系 商务版 14座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104181),
(55277, '2.8T 6系 舒适版 17座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104180),
(55276, '2.8T 6系 舒适版 17座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104179),
(55275, '2.5T 6系 舒适版 17座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104178),
(55274, '2.8T 6系 旅行版 17座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104177),
(55273, '2.8T 6系 旅行版 17座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104176),
(55272, '2.5T 6系 旅行版 17座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104175),
(55271, '2.8T 6系 星快运 10座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104174),
(55270, '2.8T 6系 星快运 10座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104172),
(55269, '2.8T 5系 舒适版 15座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104170),
(55268, '2.8T 5系 舒适版 15座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104169),
(55267, '2.5T 5系 舒适版 15座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104168),
(55266, '2.8T 5系 旅行版 14座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104167),
(55265, '2.8T 5系 旅行版 14座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104166),
(55264, '2.5T 5系 旅行版 10座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104165),
(55263, '2.8T 5系 星快运 10座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104164),
(55262, '2.8T 5系 星快运 10座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104163),
(55261, '2.8T 4系 舒适版 12座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 104162),
(55260, '1.9T 4系 舒适版 12座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 104161),
(55259, '2.8T 4系 星快运 6座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 103647),
(55258, '2.8T 4系 星快运 6座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 103646),
(55257, '2.5T 6系 星快运 6座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 103607),
(55256, '2.5T 5系 星快运 6座 国三', NULL, 4475, 0, NULL, 'J', 0, 5, 103600),
(55255, '1.9T 4系 星快运 6座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 103592),
(55254, '2.8T 4系 舒适版 12座 国四', NULL, 4475, 0, NULL, 'J', 0, 5, 103579),
(55253, '2.4 手动 四驱', NULL, 4474, 0, NULL, 'J', 0, 5, 108403),
(55252, '2.4 手动 前驱', NULL, 4473, 0, NULL, 'J', 0, 5, 109373),
(55251, '2.4豪华运动型', NULL, 4473, 0, NULL, 'J', 0, 5, 4282),
(55250, '2.0豪华舒适型', NULL, 4473, 0, NULL, 'J', 0, 5, 4281),
(55249, '2.4L（四驱）SRV', NULL, 4473, 0, NULL, 'J', 0, 5, 1530),
(55248, '2.0L 手动 前驱', NULL, 4473, 0, NULL, 'J', 0, 5, 1529),
(55247, '2.4L 手动', NULL, 4473, 0, NULL, 'J', 0, 5, 1528);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(55246, '2.4 手动 前驱', NULL, 4472, 0, NULL, 'J', 0, 5, 109374),
(55245, '2.4 手动 四驱', NULL, 4472, 0, NULL, 'J', 0, 5, 108404),
(55244, '2.0 手动 前驱', NULL, 4472, 0, NULL, 'J', 0, 5, 108402),
(55243, '1.9TCI柴油版', NULL, 4472, 0, NULL, 'J', 0, 5, 7378),
(55242, '2.4豪华动力型', NULL, 4472, 0, NULL, 'J', 0, 5, 4283),
(55241, '2.0T 手自一体 前驱', NULL, 4471, 0, NULL, 'J', 0, 5, 109371),
(55240, '2.4 手动 豪华运动型 前驱', NULL, 4471, 0, NULL, 'J', 0, 5, 108436),
(55239, '2.4 手动 豪华运动型 四驱', NULL, 4471, 0, NULL, 'J', 0, 5, 108435),
(55238, '2.0 手动 豪华舒适型 前驱', NULL, 4471, 0, NULL, 'J', 0, 5, 108434),
(55237, '1.9T 手动 豪华型 前驱 柴油', NULL, 4471, 0, NULL, 'J', 0, 5, 108433),
(55236, '2.4 手动 四驱', NULL, 4471, 0, NULL, 'J', 0, 5, 108405),
(55235, '2.0L 两驱 都市 国Ⅲ版 铝轮', NULL, 4471, 0, NULL, 'J', 0, 5, 12491),
(55234, '2.0L 两驱 都市 国Ⅳ版 钢轮', NULL, 4471, 0, NULL, 'J', 0, 5, 12490),
(55233, '2.0L 两驱都市 国Ⅳ版 铝轮', NULL, 4471, 0, NULL, 'J', 0, 5, 9319),
(55232, '2.0L 两驱都市 国Ⅲ版 钢轮', NULL, 4471, 0, NULL, 'J', 0, 5, 9318),
(55231, '2.0 手动 精英型', NULL, 4470, 0, NULL, 'J', 0, 5, 109372),
(55230, '2.4L 两驱 豪华运动版', NULL, 4470, 0, NULL, 'J', 0, 5, 13550),
(55229, '2.4L 两驱 豪华动力版', NULL, 4470, 0, NULL, 'J', 0, 5, 13549),
(55228, '高原版 1.9T 两驱 豪华型', NULL, 4470, 0, NULL, 'J', 0, 5, 12294),
(55227, '高原版 1.9T 两驱 舒适型', NULL, 4470, 0, NULL, 'J', 0, 5, 12293),
(55226, '2.4L 两驱 都市版', NULL, 4470, 0, NULL, 'J', 0, 5, 12292),
(55225, '2.4 手动 公务版 四驱', NULL, 4469, 0, NULL, 'J', 0, 5, 109325),
(55224, '2.0L 手动 两驱 亚运版', NULL, 4469, 0, NULL, 'J', 0, 5, 15765),
(55223, '2.0T MT 四驱 T动商务版', NULL, 4469, 0, NULL, 'J', 0, 5, 13548),
(55222, '2.0T MT 四驱 T动越野版', NULL, 4469, 0, NULL, 'J', 0, 5, 13092),
(55221, '2.0T AMT 两驱 T动时尚版', NULL, 4469, 0, NULL, 'J', 0, 5, 13091),
(55220, '1.9T 手动 智能四驱 柴油', NULL, 4468, 0, NULL, 'J', 0, 5, 100294),
(55219, '2.4L 手动 四驱 公务型', NULL, 4468, 0, NULL, 'J', 0, 5, 15882),
(55218, '2.4L 手动 四驱 豪华型', NULL, 4468, 0, NULL, 'J', 0, 5, 15881),
(55217, '2.4L 手动 两驱 经典型', NULL, 4468, 0, NULL, 'J', 0, 5, 15880),
(55216, '2.4L 手动 两驱 豪华型', NULL, 4468, 0, NULL, 'J', 0, 5, 15879),
(55215, '1.9T 手动 两驱 柴油', NULL, 4468, 0, NULL, 'J', 0, 5, 15878),
(55214, '1.9T 手动 两驱 经典型 柴油', NULL, 4468, 0, NULL, 'J', 0, 5, 15877),
(55213, '2.0T 手动 四驱 公务型', NULL, 4468, 0, NULL, 'J', 0, 5, 15876),
(55212, '2.0T 手动 四驱 豪华型', NULL, 4468, 0, NULL, 'J', 0, 5, 15875),
(55211, '2.0T 自动 两驱 豪华型', NULL, 4468, 0, NULL, 'J', 0, 5, 15874),
(55210, '2.0L 手动 两驱 豪华型', NULL, 4468, 0, NULL, 'J', 0, 5, 15873),
(55209, '2.0L 手动 两驱 经典型', NULL, 4468, 0, NULL, 'J', 0, 5, 15872),
(55208, '2.0L 手动 两驱 进取型', NULL, 4468, 0, NULL, 'J', 0, 5, 15829),
(55207, 'HFC1027K1RTL 大双', NULL, 4467, 0, NULL, 'J', 0, 5, 15009),
(55206, 'HFC1027K1RT 标双', NULL, 4467, 0, NULL, 'J', 0, 5, 15008),
(55205, 'HFC1027K3RT 标双', NULL, 4467, 0, NULL, 'J', 0, 5, 15007),
(55204, 'HFC1027K3RTL 大双', NULL, 4467, 0, NULL, 'J', 0, 5, 15006),
(55203, 'HFC1027K2RT 标双', NULL, 4467, 0, NULL, 'J', 0, 5, 15005),
(55202, 'HFC1027K2RTL 大双', NULL, 4467, 0, NULL, 'J', 0, 5, 15004),
(55201, 'HFC1027K4RTL 大双', NULL, 4467, 0, NULL, 'J', 0, 5, 15003),
(55200, 'HFC1027K4RT 标双', NULL, 4467, 0, NULL, 'J', 0, 5, 15002),
(55199, '2.8L 柴油 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103145),
(55198, '2.8L 柴油 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103144),
(55197, '2.8L 柴油 标准型', NULL, 4466, 0, NULL, 'J', 0, 5, 103143),
(55196, '2.5L 柴油 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103142),
(55195, '2.4L 柴油 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103141),
(55194, '2.2L 汽油 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103140),
(55193, '2.5L 柴油 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103139),
(55192, '2.4L 柴油 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103138),
(55191, '2.2L 汽油 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103137),
(55190, '2.5L 柴油 标准型', NULL, 4466, 0, NULL, 'J', 0, 5, 103136),
(55189, '2.4L 柴油 标准型', NULL, 4466, 0, NULL, 'J', 0, 5, 103135),
(55188, '2.2L 汽油 标准型', NULL, 4466, 0, NULL, 'J', 0, 5, 103134),
(55187, 'V3柴油皮卡 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103133),
(55186, 'V3柴油皮卡 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103132),
(55185, 'V3汽油皮卡 豪华型', NULL, 4466, 0, NULL, 'J', 0, 5, 103131),
(55184, 'V3汽油皮卡 舒适型', NULL, 4466, 0, NULL, 'J', 0, 5, 103130),
(55183, '2.4L 重症监护救护车 C型', NULL, 4465, 0, NULL, 'J', 0, 5, 100199),
(55182, '2.4L 重症监护救护车 B型', NULL, 4465, 0, NULL, 'J', 0, 5, 100198),
(55181, '2.4L 重症监护救护车 A型', NULL, 4465, 0, NULL, 'J', 0, 5, 100197),
(55180, '2.4L 彩色之旅Ⅲ 高顶专业救护车 六座', NULL, 4465, 0, NULL, 'J', 0, 5, 100194),
(55179, '2.4L 彩色之旅Ⅱ 高顶专业救护车 五座', NULL, 4465, 0, NULL, 'J', 0, 5, 100192),
(55178, '2.4L 彩色之旅Ⅰ 高顶专业救护车 五座', NULL, 4465, 0, NULL, 'J', 0, 5, 100190),
(55177, '2.0L 穿梭 专业救护车 标配', NULL, 4465, 0, NULL, 'J', 0, 5, 100189),
(55176, '2.4L 彩色之旅 专业救护车 标准型', NULL, 4465, 0, NULL, 'J', 0, 5, 100188),
(55175, '2.4L 彩色之旅 专业救护车 舒适型', NULL, 4465, 0, NULL, 'J', 0, 5, 100186),
(55174, '2.4L 一家亲 简易救护车 标准型', NULL, 4465, 0, NULL, 'J', 0, 5, 100183),
(55173, '2.4L 一家亲 简易救护车 豪华型', NULL, 4465, 0, NULL, 'J', 0, 5, 100181),
(55172, '2.0L 穿梭 简易救护车 标配型', NULL, 4465, 0, NULL, 'J', 0, 5, 100175),
(55171, '2.0L 穿梭 简易救护车 简配型', NULL, 4465, 0, NULL, 'J', 0, 5, 100174),
(55170, '2.4L 彩色之旅 简易救护车 舒适型', NULL, 4465, 0, NULL, 'J', 0, 5, 100172),
(55169, '2.4L 彩色之旅 简易救护车 标准型', NULL, 4465, 0, NULL, 'J', 0, 5, 100171),
(55168, '2.0T 手动 领航版', NULL, 4464, 0, NULL, 'J', 0, 5, 103909),
(55167, '2.0T 手动 尊享版', NULL, 4464, 0, NULL, 'J', 0, 5, 103908),
(55166, '2.0T 手动 新锐版', NULL, 4464, 0, NULL, 'J', 0, 5, 103907),
(55165, '2.0L 手动 精英版', NULL, 4464, 0, NULL, 'J', 0, 5, 103436),
(55164, '2.0L 手动 尊贵版', NULL, 4464, 0, NULL, 'J', 0, 5, 103435),
(55163, '1.8T 手动 新锐版', NULL, 4464, 0, NULL, 'J', 0, 5, 103307),
(55162, '2.0T 手动 领航版', NULL, 4463, 0, NULL, 'J', 0, 5, 111530),
(55161, '2.0T 手动 尊享版', NULL, 4463, 0, NULL, 'J', 0, 5, 111529),
(55160, '2.0T 手动 新锐版', NULL, 4463, 0, NULL, 'J', 0, 5, 111528),
(55159, '2.0L 手动 尊贵版', NULL, 4463, 0, NULL, 'J', 0, 5, 111527),
(55158, '瑞风M5 2.0T 汽油 手动公务版', NULL, 4462, 0, NULL, 'J', 0, 5, 13354),
(55157, '瑞风M5 2.0T 汽油 手动商务版', NULL, 4462, 0, NULL, 'J', 0, 5, 13352),
(55156, '瑞风M5 汽油 2.0T 自动 公务版', NULL, 4461, 0, NULL, 'J', 0, 5, 101866),
(55155, '瑞风M5 汽油 2.0T 自动 商务版', NULL, 4461, 0, NULL, 'J', 0, 5, 101865),
(55154, '瑞风M5 柴油 1.9T 手动 商务版', NULL, 4461, 0, NULL, 'J', 0, 5, 100292),
(55153, '瑞风M5 柴油 1.9T 手动 公务版', NULL, 4461, 0, NULL, 'J', 0, 5, 16227),
(55152, '瑞风M5 汽油 2.0T 手动 公务版', NULL, 4460, 0, NULL, 'J', 0, 5, 106065),
(55151, '瑞风M5 汽油 2.0T 自动 商务版', NULL, 4460, 0, NULL, 'J', 0, 5, 106064),
(55150, '瑞风M5 汽油 2.0T 手动 商务版', NULL, 4460, 0, NULL, 'J', 0, 5, 103769),
(55149, '瑞风M5 汽油 2.0T 自动 公务版', NULL, 4460, 0, NULL, 'J', 0, 5, 103767),
(55148, '彩色之旅 11座 手动标准型', NULL, 4459, 0, NULL, 'J', 0, 5, 4347),
(55147, '2.5 手动 加长型 7座 柴油', NULL, 4458, 0, NULL, 'J', 0, 5, 108400),
(55146, '2.4 手动 豪华型 7座', NULL, 4458, 0, NULL, 'J', 0, 5, 108399),
(55145, '2.4 自动 豪华型 7座', NULL, 4458, 0, NULL, 'J', 0, 5, 108397),
(55144, '2.4 手动 标准型 7座', NULL, 4458, 0, NULL, 'J', 0, 5, 108395),
(55143, '彩色之旅11座柴油', NULL, 4458, 0, NULL, 'J', 0, 5, 6285),
(55142, '7座自动豪华型', NULL, 4458, 0, NULL, 'J', 0, 5, 6276),
(55141, '7座汽油手动豪华型', NULL, 4458, 0, NULL, 'J', 0, 5, 6275),
(55140, '7座汽油手动标准型', NULL, 4458, 0, NULL, 'J', 0, 5, 6274),
(55139, '12座汽油标准型', NULL, 4458, 0, NULL, 'J', 0, 5, 6271),
(55138, 'Ⅰ系列 柴油舒适型', NULL, 4458, 0, NULL, 'J', 0, 5, 4344),
(55137, 'Ⅰ系列 柴油标准型', NULL, 4458, 0, NULL, 'J', 0, 5, 4343),
(55136, 'Ⅰ系列 舒适型', NULL, 4458, 0, NULL, 'J', 0, 5, 4342),
(55135, '彩色之旅11座汽油', NULL, 4457, 0, NULL, 'J', 0, 5, 6286),
(55134, '9座汽油手动', NULL, 4457, 0, NULL, 'J', 0, 5, 6279),
(55133, '2.0 手动 7座', NULL, 4456, 0, NULL, 'J', 0, 5, 109364),
(55132, '2.5 手动 国际型 10-12座 柴油', NULL, 4456, 0, NULL, 'J', 0, 5, 109362),
(55131, '瑞风 游艇版', NULL, 4456, 0, NULL, 'J', 0, 5, 9045),
(55130, '九改七 手动', NULL, 4456, 0, NULL, 'J', 0, 5, 6291),
(55129, '彩色之旅8座汽油', NULL, 4456, 0, NULL, 'J', 0, 5, 6290),
(55128, 'II代 7座汽油自动', NULL, 4456, 0, NULL, 'J', 0, 5, 6283),
(55127, 'II代 7座汽油手动', NULL, 4456, 0, NULL, 'J', 0, 5, 6282),
(55126, 'II代 7座柴油手动', NULL, 4456, 0, NULL, 'J', 0, 5, 6281),
(55125, 'II代 7座标准型', NULL, 4456, 0, NULL, 'J', 0, 5, 6280),
(55124, '8座手动汽油', NULL, 4456, 0, NULL, 'J', 0, 5, 6278),
(55123, '7座柴油手动豪华型', NULL, 4456, 0, NULL, 'J', 0, 5, 6273),
(55122, '7座柴油手动标准型', NULL, 4456, 0, NULL, 'J', 0, 5, 6272),
(55121, '2.5 手动 标准型 6-8座 柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 109366),
(55120, '2.5 手动 专业型 6-8座 柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 109365),
(55119, '祥和2.5T 手动 天窗型 7座 柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 109356),
(55118, '彩色之旅2.5 手动 标准型 7-9座柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 109346),
(55117, '2.5 手动 加长型 7座 柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 108401),
(55116, '祥和2.4 自动 豪华型 7座', NULL, 4455, 0, NULL, 'J', 0, 5, 108391),
(55115, '彩色之旅2.5 手动 标准型 11座柴油', NULL, 4455, 0, NULL, 'J', 0, 5, 108383),
(55114, '彩色之旅2.4 手动 标准型 9-11座 ', NULL, 4455, 0, NULL, 'J', 0, 5, 108382),
(55113, '彩色之旅8座柴油型', NULL, 4455, 0, NULL, 'J', 0, 5, 6289),
(55112, '彩色之旅 简配', NULL, 4455, 0, NULL, 'J', 0, 5, 6284),
(55111, '9座柴油手动', NULL, 4455, 0, NULL, 'J', 0, 5, 6277),
(55110, '2.4 手动 标准型 8座', NULL, 4454, 0, NULL, 'J', 0, 5, 109368),
(55109, '2.4 手动 加长型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109367),
(55108, '穿梭2.0 手动 7-12座', NULL, 4454, 0, NULL, 'J', 0, 5, 109353),
(55107, '穿梭2.0 手动 5座', NULL, 4454, 0, NULL, 'J', 0, 5, 109351),
(55106, 'II 2.4 自动 豪华型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109343),
(55105, 'II 2.4 手动 豪华型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109342),
(55104, 'II 2.4 手动 专业型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109341),
(55103, 'II 2.5 手动 6-8座 柴油', NULL, 4454, 0, NULL, 'J', 0, 5, 109340),
(55102, 'II 2.4 手动 高配型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109339),
(55101, 'II 2.4 自动 高配型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109338),
(55100, 'I 2.4 自动 豪华公务型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109337),
(55099, 'I 2.4 手动 豪华公务型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109336),
(55098, 'I 2.4 手动 标准公务型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109335),
(55097, 'I 2.4 手动 标准型 5-8座', NULL, 4454, 0, NULL, 'J', 0, 5, 109332),
(55096, '彩色之旅2.4 手动 标准型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 109324),
(55095, '彩色之旅 2.4 手动 标准型 8座', NULL, 4454, 0, NULL, 'J', 0, 5, 108432),
(55094, '彩色之旅2.5 手动 标准型 11座柴油', NULL, 4454, 0, NULL, 'J', 0, 5, 108431),
(55093, '2.4 自动 豪华型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 108398),
(55092, '2.4 手动 标准型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 108396),
(55091, '穿梭2.0 手动 标准型 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 108388),
(55090, '2.0 手动 长轴距 7座', NULL, 4454, 0, NULL, 'J', 0, 5, 108387),
(55089, '彩色之旅2.4 手动 10-12座', NULL, 4454, 0, NULL, 'J', 0, 5, 108384),
(55088, '彩色之旅 11座 手动基本型', NULL, 4454, 0, NULL, 'J', 0, 5, 7280),
(55087, '彩色之旅7座长轴距柴油', NULL, 4454, 0, NULL, 'J', 0, 5, 6288),
(55086, '彩色之旅7座长轴距', NULL, 4454, 0, NULL, 'J', 0, 5, 6287),
(55085, '彩色之旅 8座 新动力型', NULL, 4454, 0, NULL, 'J', 0, 5, 5736),
(55084, '彩色之旅 7座 新动力型', NULL, 4454, 0, NULL, 'J', 0, 5, 5734),
(55083, '瑞风彩色之旅2.4 CBR', NULL, 4454, 0, NULL, 'J', 0, 5, 5011),
(55082, '穿梭系列 2.0 8座 手动标准型', NULL, 4454, 0, NULL, 'J', 0, 5, 4349),
(55081, '2.0 手动 5-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 109369),
(55080, '祥和2.4 手动 标准型 5-9座', NULL, 4453, 0, NULL, 'J', 0, 5, 109358),
(55079, '祥和2.5T 手动 天窗型 7座 柴油', NULL, 4453, 0, NULL, 'J', 0, 5, 109357),
(55078, '穿梭2.0 手动 5-9座', NULL, 4453, 0, NULL, 'J', 0, 5, 109354),
(55077, '彩色之旅 2.4 手动 标准加长型 5-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 109349),
(55076, '彩色之旅 2.4 手动 标准型', NULL, 4453, 0, NULL, 'J', 0, 5, 109348),
(55075, '彩色之旅 2.4 手动 豪华型 11座', NULL, 4453, 0, NULL, 'J', 0, 5, 109347),
(55074, 'I 2.0 手动 豪华型 6-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 109345),
(55073, 'I 2.4 自动 标准型 7座', NULL, 4453, 0, NULL, 'J', 0, 5, 109344),
(55072, 'I 2.4 手动 豪华型 5-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 109334),
(55071, 'I 2.4 手动 标准型 5-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 109333),
(55070, '祥和2.4 手动 标准型 7座', NULL, 4453, 0, NULL, 'J', 0, 5, 108394),
(55069, '祥和2.4 手动 豪华型 7座', NULL, 4453, 0, NULL, 'J', 0, 5, 108393),
(55068, '祥和2.4 自动 豪华型 7座', NULL, 4453, 0, NULL, 'J', 0, 5, 108392),
(55067, '穿梭2.8 手动 简配型 7-9座 柴油', NULL, 4453, 0, NULL, 'J', 0, 5, 108390),
(55066, '穿梭2.0 手动 简配型 8座', NULL, 4453, 0, NULL, 'J', 0, 5, 108389),
(55065, 'I 2.4 自动 豪华型 7座', NULL, 4453, 0, NULL, 'J', 0, 5, 108381),
(55064, 'I 2.4 手动 豪华型 6-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 108380),
(55063, 'I 2.4 手动 标准型 6-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 108379),
(55062, 'I 2.0 手动 标准型 6-8座', NULL, 4453, 0, NULL, 'J', 0, 5, 108378),
(55061, '彩色之旅 2.4CBR汽油 手动基本型', NULL, 4453, 0, NULL, 'J', 0, 5, 7279),
(55060, '祥和 2.0T汽油 手动豪华型', NULL, 4453, 0, NULL, 'J', 0, 5, 6292),
(55059, '瑞风 祥和 7座柴油', NULL, 4453, 0, NULL, 'J', 0, 5, 5357),
(55058, '祥和 2.4L汽油 手动豪华型', NULL, 4453, 0, NULL, 'J', 0, 5, 5356),
(55057, '祥和 2.0T汽油 手动标准型', NULL, 4453, 0, NULL, 'J', 0, 5, 5012),
(55056, '彩色之旅 2.4CBR汽油 手动标准型', NULL, 4453, 0, NULL, 'J', 0, 5, 4345),
(55055, '祥和 2.4L汽油 手动标准型', NULL, 4453, 0, NULL, 'J', 0, 5, 4340),
(55054, '祥和 2.0T汽油 自动豪华型', NULL, 4453, 0, NULL, 'J', 0, 5, 4339),
(55053, '2.0 手动 5-9座', NULL, 4452, 0, NULL, 'J', 0, 5, 109370),
(55052, '2.5 手动 国际型 10-12座 柴油', NULL, 4452, 0, NULL, 'J', 0, 5, 109363),
(55051, '祥和2.0 手动 7座', NULL, 4452, 0, NULL, 'J', 0, 5, 109359),
(55050, '穿梭2.8 手动  7-9座 柴油', NULL, 4452, 0, NULL, 'J', 0, 5, 109355),
(55049, '穿梭2.0 手动 5座', NULL, 4452, 0, NULL, 'J', 0, 5, 109352),
(55048, '彩色之旅 2.4 手动 5-9座', NULL, 4452, 0, NULL, 'J', 0, 5, 109350),
(55047, '彩色之旅 2.4 手动 简配型 5-8座', NULL, 4452, 0, NULL, 'J', 0, 5, 109323),
(55046, '彩色之旅 2.4 手动 标配型 5-8座', NULL, 4452, 0, NULL, 'J', 0, 5, 108449),
(55045, '祥和2.0 手动 豪华型', NULL, 4452, 0, NULL, 'J', 0, 5, 108428),
(55044, '祥和2.0 手动 标准型', NULL, 4452, 0, NULL, 'J', 0, 5, 108427),
(55043, '彩色之旅2.4 手动 10-12座', NULL, 4452, 0, NULL, 'J', 0, 5, 108385),
(55042, '穿梭系列 2.8L柴油 简配前后空调型 7座', NULL, 4452, 0, NULL, 'J', 0, 5, 7382),
(55041, '穿梭系列 2.8L柴油 简配单空调型 8座', NULL, 4452, 0, NULL, 'J', 0, 5, 7381),
(55040, '穿梭系列 2.8L柴油 简配前后空调型 11座', NULL, 4452, 0, NULL, 'J', 0, 5, 7380),
(55039, '穿梭系列 2.8L柴油 简配前后空调型 8座', NULL, 4452, 0, NULL, 'J', 0, 5, 7379),
(55038, 'Ⅰ 2.4L汽油 自动豪华型', NULL, 4452, 0, NULL, 'J', 0, 5, 7283),
(55037, 'Ⅰ 2.4L汽油 手动豪华型', NULL, 4452, 0, NULL, 'J', 0, 5, 7282),
(55036, 'Ⅰ 2.4L汽油 手动标准型', NULL, 4452, 0, NULL, 'J', 0, 5, 7281),
(55035, '彩色之旅 2.4L汽油 手动基本型', NULL, 4452, 0, NULL, 'J', 0, 5, 7278),
(55034, '穿梭系列 2.0L汽油 简配单空调型 8座', NULL, 4452, 0, NULL, 'J', 0, 5, 7277),
(55033, '穿梭系列 2.0L汽油 简配单空调型 5座', NULL, 4452, 0, NULL, 'J', 0, 5, 7276),
(55032, '穿梭系列 2.0L汽油 简配单空调型 7座', NULL, 4452, 0, NULL, 'J', 0, 5, 7275),
(55031, '穿梭系列 2.0L汽油 简配前后空调型 8座', NULL, 4452, 0, NULL, 'J', 0, 5, 7274),
(55030, '穿梭系列 2.0L汽油 简配前后空调型 7座', NULL, 4452, 0, NULL, 'J', 0, 5, 7273),
(55029, '彩色之旅 2.4L汽油 手动标准型', NULL, 4452, 0, NULL, 'J', 0, 5, 4346),
(55028, 'Ⅰ 2.0L汽油 手动标准型', NULL, 4452, 0, NULL, 'J', 0, 5, 4341),
(55027, '祥和2.0 手动 7座', NULL, 4451, 0, NULL, 'J', 0, 5, 109360),
(55026, 'I 2.0 手动  6-8座', NULL, 4451, 0, NULL, 'J', 0, 5, 109330),
(55025, '祥和2.0 手动 7座', NULL, 4450, 0, NULL, 'J', 0, 5, 109361),
(55024, 'I 2.0 手动  6-8座', NULL, 4450, 0, NULL, 'J', 0, 5, 109331),
(55023, '彩色之旅 2.4 手动 标配型 5-8座', NULL, 4450, 0, NULL, 'J', 0, 5, 108386),
(55022, '和畅2.0T 手动 公务版', NULL, 4449, 0, NULL, 'J', 0, 5, 108430),
(55021, '和畅2.0T  手动 商务版', NULL, 4449, 0, NULL, 'J', 0, 5, 108429),
(55020, '政采版 2.0L 汽油 手动 豪华 11座', NULL, 4449, 0, NULL, 'J', 0, 5, 16258),
(55019, '政采版 2.0L 汽油 手动 豪华 8座', NULL, 4449, 0, NULL, 'J', 0, 5, 16257),
(55018, '政采版 2.0L 汽油 手动 豪华 7座', NULL, 4449, 0, NULL, 'J', 0, 5, 16256),
(55017, '政采版 2.4L 汽油 手动 豪华 7座', NULL, 4449, 0, NULL, 'J', 0, 5, 16255),
(55016, '政采版 2.4L 汽油 手动 豪华 11座', NULL, 4449, 0, NULL, 'J', 0, 5, 16254),
(55015, '政采版 2.4L 汽油 手动 豪华 8座', NULL, 4449, 0, NULL, 'J', 0, 5, 16253),
(55014, '祥和 2.0T汽油 手动豪华版', NULL, 4449, 0, NULL, 'J', 0, 5, 12505),
(55013, '祥和 2.0T汽油 手动标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12504),
(55012, '祥和 2.4L汽油 手动豪华版', NULL, 4449, 0, NULL, 'J', 0, 5, 12503),
(55011, '祥和 2.4L汽油 手动标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12502),
(55010, '彩色之旅 2.4L汽油 手动舒适版', NULL, 4449, 0, NULL, 'J', 0, 5, 12501),
(55009, '彩色之旅 2.4L汽油 手动标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12500),
(55008, '一家亲 2.4L汽油 手动豪华版', NULL, 4449, 0, NULL, 'J', 0, 5, 12499),
(55007, '一家亲 2.4L汽油 手动标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12498),
(55006, '一家亲 2.0L汽油 手动豪华版', NULL, 4449, 0, NULL, 'J', 0, 5, 12497),
(55005, '一家亲 2.0L汽油 手动标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12496),
(55004, '穿梭系列 2.8L柴油 舒适版', NULL, 4449, 0, NULL, 'J', 0, 5, 12495),
(55003, '穿梭系列 2.8L柴油 标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12494),
(55002, '穿梭系列 2.0L汽油 舒适版', NULL, 4449, 0, NULL, 'J', 0, 5, 12493),
(55001, '穿梭系列 2.0L汽油 标准版', NULL, 4449, 0, NULL, 'J', 0, 5, 12492),
(55000, '穿梭 2.0L 手动 汽油 祥和长轴政采型', NULL, 4448, 0, NULL, 'J', 0, 5, 105011),
(54999, '穿梭 2.0L 手动 汽油 长轴标准型', NULL, 4448, 0, NULL, 'J', 0, 5, 105010),
(54998, '穿梭 1.8L 手动 汽油 短轴时光版', NULL, 4448, 0, NULL, 'J', 0, 5, 102526),
(54997, '穿梭 2.0L 手动 汽油 短轴时光版', NULL, 4448, 0, NULL, 'J', 0, 5, 102525),
(54996, '穿梭 柴油 1.9T 手动 舒适型', NULL, 4448, 0, NULL, 'J', 0, 5, 100697),
(54995, '穿梭 柴油 1.9T 手动 标准型', NULL, 4448, 0, NULL, 'J', 0, 5, 100696),
(54994, '柴油 1.9T 手动 祥和政采版', NULL, 4448, 0, NULL, 'J', 0, 5, 100695),
(54993, '1.8 手动 尊贵型 五座', NULL, 4447, 0, NULL, 'J', 0, 5, 109329),
(54992, '七座 豪华型', NULL, 4447, 0, NULL, 'J', 0, 5, 12343),
(54991, '七座 舒适增配型', NULL, 4447, 0, NULL, 'J', 0, 5, 12342),
(54990, '七座 优雅型', NULL, 4447, 0, NULL, 'J', 0, 5, 12341),
(54989, '五座 优雅型', NULL, 4447, 0, NULL, 'J', 0, 5, 11500),
(54988, '尊逸型', NULL, 4447, 0, NULL, 'J', 0, 5, 9493),
(54987, '五座 豪华型', NULL, 4447, 0, NULL, 'J', 0, 5, 9492),
(54986, '五座 舒适增配型', NULL, 4447, 0, NULL, 'J', 0, 5, 9491),
(54985, '标准型', NULL, 4447, 0, NULL, 'J', 0, 5, 8529),
(54984, '1.8 手动 尊逸型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 108421),
(54983, '1.8 手动 尊逸型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 108420),
(54982, '1.8 手动 舒适型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 108419),
(54981, '1.8 手动 舒适型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 108418),
(54980, '1.8 手动 豪华型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 108417),
(54979, '1.8 手动 豪华型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 108416),
(54978, '1.5 手动 宜家豪华版', NULL, 4446, 0, NULL, 'J', 0, 5, 108415),
(54977, '1.5 手动 宜家舒适版', NULL, 4446, 0, NULL, 'J', 0, 5, 108414),
(54976, '1.5 手动 宜家标准版', NULL, 4446, 0, NULL, 'J', 0, 5, 108413),
(54975, '1.8L 自动 豪华公务型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 14846),
(54974, '1.8L 自动 豪华公务型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 14845),
(54973, '1.5L 宜家 豪华版', NULL, 4446, 0, NULL, 'J', 0, 5, 13739),
(54972, '1.5L 宜家 舒适版', NULL, 4446, 0, NULL, 'J', 0, 5, 13738),
(54971, '1.5L 宜家 标准版', NULL, 4446, 0, NULL, 'J', 0, 5, 13737),
(54970, '1.5L VVT', NULL, 4446, 0, NULL, 'J', 0, 5, 13150),
(54969, '1.8L 七座 豪华型', NULL, 4446, 0, NULL, 'J', 0, 5, 13004),
(54968, '1.8L 五座 豪华型', NULL, 4446, 0, NULL, 'J', 0, 5, 13003),
(54967, '1.8L 七座 舒适增配型', NULL, 4446, 0, NULL, 'J', 0, 5, 13002),
(54966, '1.8L 五座 舒适增配型', NULL, 4446, 0, NULL, 'J', 0, 5, 13001),
(54965, '1.8L 五座 优雅型', NULL, 4446, 0, NULL, 'J', 0, 5, 13000),
(54964, '1.8L 运动天窗型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 12318),
(54963, '1.8L 尊逸型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 12064),
(54962, '1.8L 运动型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 12063),
(54961, '1.8L 运动型 七座', NULL, 4446, 0, NULL, 'J', 0, 5, 12062),
(54960, '1.8L 尊逸型 五座', NULL, 4446, 0, NULL, 'J', 0, 5, 12061),
(54959, '1.8L 自动 公务尊逸运动型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 103475),
(54958, '1.8L 自动 公务尊逸运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103474),
(54957, '1.8L 手动 尊逸运动型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 103472),
(54956, '1.8L 手动 尊逸运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103470),
(54955, '1.8L 手动 豪华运动型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 103469),
(54954, '1.8L 手动 豪华运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103468),
(54953, '1.8L 手动 精英运动型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 103465),
(54952, '1.8L 手动 精英运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103462),
(54951, '1.5L 手动 豪华运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103455),
(54950, '1.5L 手动 舒适运动型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 103454),
(54949, '1.5L 手动 舒适运动型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 103444),
(54948, '1.8L 自动 尊贵型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 102659),
(54947, '1.8L 自动 公务豪华型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 101542),
(54946, '1.5L 宜家系列 手动 经典舒适型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 101541),
(54945, '1.5L 宜家系列 手动 标准型', NULL, 4445, 0, NULL, 'J', 0, 5, 15905),
(54944, '1.5L 宜家系列 手动 舒适型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 15904),
(54943, '1.5L 宜家系列 手动 豪华型', NULL, 4445, 0, NULL, 'J', 0, 5, 15903),
(54942, '1.8L 宜商系列 手动 精英型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 15902),
(54941, '1.8L 宜商系列 手动 精英型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 15901),
(54940, '1.8L 宜商系列 手动 豪华型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 15900),
(54939, '1.8L 宜商系列 手动 豪华型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 15899),
(54938, '1.8L 宜商系列 手动 尊逸型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 15898),
(54937, '1.8L 宜商系列 手动 尊逸型 七座', NULL, 4445, 0, NULL, 'J', 0, 5, 15897),
(54936, '1.8L 自动 公务豪华型 五座', NULL, 4445, 0, NULL, 'J', 0, 5, 15896),
(54935, '1.8L 手动 经典豪华型', NULL, 4444, 0, NULL, 'J', 0, 5, 104198),
(54934, '1.8L 手动 经典型 ', NULL, 4444, 0, NULL, 'J', 0, 5, 104197),
(54933, '1.5L 手动 经典豪华型', NULL, 4444, 0, NULL, 'J', 0, 5, 104193),
(54932, '1.5L 手动 经典舒适型', NULL, 4444, 0, NULL, 'J', 0, 5, 104184),
(54931, '1.8L 自动 全能商务尊贵型', NULL, 4444, 0, NULL, 'J', 0, 5, 103695),
(54930, '1.8L 自动 全能商务豪华型', NULL, 4444, 0, NULL, 'J', 0, 5, 103694),
(54929, '1.5L 手动 全能商务豪华型', NULL, 4444, 0, NULL, 'J', 0, 5, 103693),
(54928, '1.5L 手动 全能商务舒适型', NULL, 4444, 0, NULL, 'J', 0, 5, 103692),
(54927, '1.8L 手动 全能商务尊贵型', NULL, 4444, 0, NULL, 'J', 0, 5, 103691),
(54926, '1.8L 手动 全能商务豪华型', NULL, 4444, 0, NULL, 'J', 0, 5, 103618),
(54925, 'iev4', NULL, 4443, 0, NULL, 'J', 0, 5, 109813),
(54924, '1.5L 手动 基本型', NULL, 4442, 0, NULL, 'J', 0, 5, 106015),
(54923, '1.5L 手动 尊贵型', NULL, 4442, 0, NULL, 'J', 0, 5, 105060),
(54922, '1.5L CVT 舒适型', NULL, 4442, 0, NULL, 'J', 0, 5, 105057),
(54921, '1.5L CVT 豪华型', NULL, 4442, 0, NULL, 'J', 0, 5, 105056),
(54920, '1.5L 手动 豪华型', NULL, 4442, 0, NULL, 'J', 0, 5, 105053),
(54919, '1.5L CVT 尊贵型', NULL, 4442, 0, NULL, 'J', 0, 5, 105052),
(54918, '1.5L 手动 舒适型', NULL, 4442, 0, NULL, 'J', 0, 5, 105002),
(54917, '1.5L 手动 尊享型', NULL, 4441, 0, NULL, 'J', 0, 5, 110687),
(54916, '1.3 手动 标准型', NULL, 4440, 0, NULL, 'J', 0, 5, 109375),
(54915, '1.3L AMT 舒适型', NULL, 4440, 0, NULL, 'J', 0, 5, 9465),
(54914, '1.5L MT 豪华型', NULL, 4440, 0, NULL, 'J', 0, 5, 8147),
(54913, '1.5L MT 舒适型', NULL, 4440, 0, NULL, 'J', 0, 5, 8146),
(54912, '1.3L MT 豪华型', NULL, 4440, 0, NULL, 'J', 0, 5, 8145),
(54911, '1.3L MT 舒适型', NULL, 4440, 0, NULL, 'J', 0, 5, 8144),
(54910, '1.3L AMT 豪华型', NULL, 4440, 0, NULL, 'J', 0, 5, 8143),
(54909, '1.3 手动 舒适型 VVT', NULL, 4439, 0, NULL, 'J', 0, 5, 108440),
(54908, '1.3 手动 豪华型 VVT', NULL, 4439, 0, NULL, 'J', 0, 5, 108439),
(54907, '1.3 手自一体 舒适型', NULL, 4439, 0, NULL, 'J', 0, 5, 108438),
(54906, '1.3 手自一体 豪华型', NULL, 4439, 0, NULL, 'J', 0, 5, 108437),
(54905, '1.3 手动 豪华型', NULL, 4439, 0, NULL, 'J', 0, 5, 108408),
(54904, '1.3L VVT 豪华型', NULL, 4439, 0, NULL, 'J', 0, 5, 10680),
(54903, '1.3L VVT 舒适型', NULL, 4439, 0, NULL, 'J', 0, 5, 10679),
(54902, 'CROSS 1.3L 自动 豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15932),
(54901, 'CROSS 1.3L 手动 尚动尊贵型', NULL, 4438, 0, NULL, 'J', 0, 5, 15931),
(54900, 'CROSS 1.3L 手动 尚动豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15929),
(54899, 'CROSS 1.3L 手动 豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15926),
(54898, '1.3L 自动 豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15920),
(54897, '1.3L 手动 尚动尊贵型', NULL, 4438, 0, NULL, 'J', 0, 5, 15919),
(54896, '1.3L 手动 尚动豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15918),
(54895, '1.3L 手动 豪华型', NULL, 4438, 0, NULL, 'J', 0, 5, 15917),
(54894, '1.3L 手动 舒适型', NULL, 4438, 0, NULL, 'J', 0, 5, 15916),
(54893, '1.3L 手动 标准型', NULL, 4438, 0, NULL, 'J', 0, 5, 15915),
(54892, 'CROSS 1.3L 手动 舒适型', NULL, 4438, 0, NULL, 'J', 0, 5, 15914),
(54891, '1.3L 手动 舒适型', NULL, 4437, 0, NULL, 'J', 0, 5, 110309),
(54890, 'CROSS 1.3L 手动 舒适型', NULL, 4437, 0, NULL, 'J', 0, 5, 110076),
(54889, 'CROSS 1.3L 手动 豪华型', NULL, 4437, 0, NULL, 'J', 0, 5, 110075),
(54888, 'CROSS 1.3L 手动 尊贵型', NULL, 4437, 0, NULL, 'J', 0, 5, 110068),
(54887, '1.5 手动 尊贵型 ', NULL, 4436, 0, NULL, 'J', 0, 5, 109378),
(54886, '1.5 手动 舒适型 CNG', NULL, 4436, 0, NULL, 'J', 0, 5, 109377),
(54885, '1.5 手动 豪华型 CNG', NULL, 4436, 0, NULL, 'J', 0, 5, 109376),
(54884, '1.3L MT 舒适型', NULL, 4436, 0, NULL, 'J', 0, 5, 7208),
(54883, '1.5L MT 豪华型', NULL, 4436, 0, NULL, 'J', 0, 5, 7172),
(54882, '1.5L MT 舒适型', NULL, 4436, 0, NULL, 'J', 0, 5, 7170),
(54881, '1.3L MT 豪华型', NULL, 4436, 0, NULL, 'J', 0, 5, 7169),
(54880, '1.3L MT 标准型', NULL, 4436, 0, NULL, 'J', 0, 5, 7167),
(54879, '1.3 手动 舒适型 VVT', NULL, 4435, 0, NULL, 'J', 0, 5, 108442),
(54878, '1.3 手动 豪华型 VVT', NULL, 4435, 0, NULL, 'J', 0, 5, 108441),
(54877, '1.3 手动 舒适型', NULL, 4435, 0, NULL, 'J', 0, 5, 108407),
(54876, '1.3 手动 豪华型', NULL, 4435, 0, NULL, 'J', 0, 5, 108406),
(54875, '1.3L AMT 豪华型', NULL, 4435, 0, NULL, 'J', 0, 5, 9476),
(54874, '1.3L AMT 舒适型', NULL, 4435, 0, NULL, 'J', 0, 5, 9475),
(54873, '1.5 手动 ', NULL, 4434, 0, NULL, 'J', 0, 5, 109379),
(54872, '1.3L 手动 VVT 豪华型', NULL, 4434, 0, NULL, 'J', 0, 5, 10678),
(54871, '1.3L 手动 VVT 舒适型', NULL, 4434, 0, NULL, 'J', 0, 5, 7171),
(54870, '1.3L AMT豪华型', NULL, 4433, 0, NULL, 'J', 0, 5, 102894),
(54869, '1.3L 自动 豪华型', NULL, 4433, 0, NULL, 'J', 0, 5, 102837),
(54868, '1.3L 自动 舒适型', NULL, 4433, 0, NULL, 'J', 0, 5, 15911),
(54867, '1.3L 手动 尚动尊贵型', NULL, 4433, 0, NULL, 'J', 0, 5, 15910),
(54866, '1.3L 手动 尚动豪华型', NULL, 4433, 0, NULL, 'J', 0, 5, 15909),
(54865, '1.3L 手动 豪华型', NULL, 4433, 0, NULL, 'J', 0, 5, 15908),
(54864, '1.3L 手动 舒适型', NULL, 4433, 0, NULL, 'J', 0, 5, 15907),
(54863, '1.3L 手动 标准型', NULL, 4433, 0, NULL, 'J', 0, 5, 15906),
(54862, '1.3L MT 尊贵型', NULL, 4432, 0, NULL, 'J', 0, 5, 106637),
(54861, '1.3L MT 豪华型', NULL, 4432, 0, NULL, 'J', 0, 5, 106636),
(54860, '1.3L MT 舒适型', NULL, 4432, 0, NULL, 'J', 0, 5, 106635),
(54859, '优雅型', NULL, 4431, 0, NULL, 'J', 0, 5, 11499),
(54858, '尊贵型', NULL, 4431, 0, NULL, 'J', 0, 5, 9517),
(54857, '舒适型', NULL, 4431, 0, NULL, 'J', 0, 5, 9516),
(54856, '豪华型', NULL, 4431, 0, NULL, 'J', 0, 5, 8944),
(54855, '标准型', NULL, 4431, 0, NULL, 'J', 0, 5, 8319),
(54854, '1.8 自动 ', NULL, 4430, 0, NULL, 'J', 0, 5, 109328),
(54853, '1.5 手动 智能尊雅型', NULL, 4430, 0, NULL, 'J', 0, 5, 109327),
(54852, '1.5 手动 运动天窗型', NULL, 4430, 0, NULL, 'J', 0, 5, 108426),
(54851, '1.5 手动 尊逸型', NULL, 4430, 0, NULL, 'J', 0, 5, 108425),
(54850, '1.5 手动 优雅型', NULL, 4430, 0, NULL, 'J', 0, 5, 108424),
(54849, '1.5 手动 豪华型', NULL, 4430, 0, NULL, 'J', 0, 5, 108423),
(54848, '1.5 手动 优雅型(钢轮)', NULL, 4430, 0, NULL, 'J', 0, 5, 108422),
(54847, '1.8L 自动 豪华公务型', NULL, 4430, 0, NULL, 'J', 0, 5, 14847),
(54846, '1.5L 手动 运动天窗型', NULL, 4430, 0, NULL, 'J', 0, 5, 12869),
(54845, '1.5L 手动 豪华型', NULL, 4430, 0, NULL, 'J', 0, 5, 12334),
(54844, '1.5L 手动 运动型', NULL, 4430, 0, NULL, 'J', 0, 5, 12060),
(54843, '1.5L 手动 舒适型', NULL, 4430, 0, NULL, 'J', 0, 5, 12059),
(54842, '1.5L 手动 尊逸型', NULL, 4430, 0, NULL, 'J', 0, 5, 12058),
(54841, '1.5L 手动 50周年限量版', NULL, 4429, 0, NULL, 'J', 0, 5, 110996),
(54840, '1.8L 自动 公务尊逸运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101466),
(54839, '1.8L 手动 商务尊逸运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101465),
(54838, '1.5L 手动 尊贵运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101464),
(54837, '1.5L 手动 尊逸运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101463),
(54836, '1.5L 手动 豪华运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101462),
(54835, '1.5L 手动 舒适运动型', NULL, 4429, 0, NULL, 'J', 0, 5, 101461),
(54834, '1.5L 手动 标准型', NULL, 4429, 0, NULL, 'J', 0, 5, 15860),
(54833, '1.5L 手动 舒适型', NULL, 4429, 0, NULL, 'J', 0, 5, 15859),
(54832, '1.5L 手动 豪华型', NULL, 4429, 0, NULL, 'J', 0, 5, 15858),
(54831, '1.5L 手动 尊逸型', NULL, 4429, 0, NULL, 'J', 0, 5, 15857),
(54830, '1.5L 手动 尊贵型', NULL, 4429, 0, NULL, 'J', 0, 5, 15856),
(54829, '1.8L 手动 商务豪华型', NULL, 4429, 0, NULL, 'J', 0, 5, 15855),
(54828, '1.8L 自动 公务豪华型', NULL, 4429, 0, NULL, 'J', 0, 5, 15853),
(54827, '1.3L 手动 基本型', NULL, 4428, 0, NULL, 'J', 0, 5, 105069),
(54826, '1.5L 手动 经典豪华型', NULL, 4428, 0, NULL, 'J', 0, 5, 104196),
(54825, '1.5L 手动 经典舒适型', NULL, 4428, 0, NULL, 'J', 0, 5, 104195),
(54824, '1.5L 手动 商务 豪华型', NULL, 4428, 0, NULL, 'J', 0, 5, 104194),
(54823, '1.5L 手动 商务 尊逸型', NULL, 4428, 0, NULL, 'J', 0, 5, 104192),
(54822, '1.8L 自动 经典舒适型', NULL, 4428, 0, NULL, 'J', 0, 5, 104191),
(54821, '1.5L 手动 豪华运动型', NULL, 4428, 0, NULL, 'J', 0, 5, 104190),
(54820, '1.5L 手动 尊逸运动型', NULL, 4428, 0, NULL, 'J', 0, 5, 104189),
(54819, '1.8L 自动 商务 尊贵型', NULL, 4428, 0, NULL, 'J', 0, 5, 104188),
(54818, '1.5L 手动 尊贵运动型', NULL, 4428, 0, NULL, 'J', 0, 5, 104187),
(54817, '1.8L 手动 尊逸运动型', NULL, 4428, 0, NULL, 'J', 0, 5, 104186),
(54816, '1.8L 自动 尊逸运动型', NULL, 4428, 0, NULL, 'J', 0, 5, 104185),
(54815, '1.5L 手动 豪华型', NULL, 4427, 0, NULL, 'J', 0, 5, 110553),
(54814, '1.5L 手动 尊逸型', NULL, 4427, 0, NULL, 'J', 0, 5, 110552),
(54813, '1.5L 手动 尊贵型', NULL, 4427, 0, NULL, 'J', 0, 5, 110551),
(54812, '1.8L 自动 尊逸型', NULL, 4427, 0, NULL, 'J', 0, 5, 110550),
(54811, '1.8L 自动 尊贵型', NULL, 4427, 0, NULL, 'J', 0, 5, 110547),
(54810, '1.8L 自动 商务尊贵型', NULL, 4427, 0, NULL, 'J', 0, 5, 105225),
(54809, '1.5L 手动 商务尊逸型', NULL, 4427, 0, NULL, 'J', 0, 5, 105224),
(54808, '1.5L 手动 商务豪华型', NULL, 4427, 0, NULL, 'J', 0, 5, 105223),
(54807, '2.0AT经济型', NULL, 4426, 0, NULL, 'J', 0, 5, 8177),
(54806, '2.0AT尊崇型', NULL, 4426, 0, NULL, 'J', 0, 5, 7149),
(54805, '2.0AT豪华型', NULL, 4426, 0, NULL, 'J', 0, 5, 7148),
(54804, '2.4MT 顶级型纪念版', NULL, 4426, 0, NULL, 'J', 0, 5, 5590),
(54803, '2.4MT豪华型纪念版', NULL, 4426, 0, NULL, 'J', 0, 5, 5589),
(54802, '2.0MT 豪华型纪念版', NULL, 4426, 0, NULL, 'J', 0, 5, 5588),
(54801, '2.4MT 顶级型', NULL, 4426, 0, NULL, 'J', 0, 5, 1536),
(54800, '2.4MT 豪华型', NULL, 4426, 0, NULL, 'J', 0, 5, 1535),
(54799, '2.0MT 顶级型', NULL, 4426, 0, NULL, 'J', 0, 5, 1534),
(54798, '2.0MT 豪华型', NULL, 4426, 0, NULL, 'J', 0, 5, 1533),
(54797, '2.0MT 舒适型', NULL, 4426, 0, NULL, 'J', 0, 5, 1532),
(54796, '2.4MT 舒适型', NULL, 4426, 0, NULL, 'J', 0, 5, 1531),
(54795, '2.0 手动 双燃料CNG', NULL, 4425, 0, NULL, 'J', 0, 5, 109326),
(54794, '2.4 手动 豪华型', NULL, 4425, 0, NULL, 'J', 0, 5, 108412),
(54793, '2.4 手动 顶级型', NULL, 4425, 0, NULL, 'J', 0, 5, 108411),
(54792, '2.0 手动 精英型', NULL, 4425, 0, NULL, 'J', 0, 5, 108410),
(54791, '2.0 自动 豪华型', NULL, 4425, 0, NULL, 'J', 0, 5, 108409),
(54790, '2.0MT 精英型', NULL, 4425, 0, NULL, 'J', 0, 5, 9860),
(54789, '2.4AT', NULL, 4425, 0, NULL, 'J', 0, 5, 8994),
(54788, '2.4MT舒适型', NULL, 4425, 0, NULL, 'J', 0, 5, 8664),
(54787, '2.4MT 顶级型', NULL, 4425, 0, NULL, 'J', 0, 5, 8661),
(54786, '2.4MT 豪华型', NULL, 4425, 0, NULL, 'J', 0, 5, 8660),
(54785, '2.0AT 尊崇型', NULL, 4425, 0, NULL, 'J', 0, 5, 8659),
(54784, '2.0AT 豪华型', NULL, 4425, 0, NULL, 'J', 0, 5, 8658),
(54783, '2.0MT顶级型', NULL, 4425, 0, NULL, 'J', 0, 5, 8657),
(54782, '2.0MT 豪华型', NULL, 4425, 0, NULL, 'J', 0, 5, 8656),
(54781, '2.0MT舒适型', NULL, 4425, 0, NULL, 'J', 0, 5, 8655),
(54780, '2.0L 自动 尊崇型', NULL, 4424, 0, NULL, 'J', 0, 5, 14559),
(54779, '2.0L 自动 豪华型', NULL, 4424, 0, NULL, 'J', 0, 5, 14558),
(54778, '2.0L 手动 尊贵型', NULL, 4424, 0, NULL, 'J', 0, 5, 14557),
(54777, '2.0L 手动 豪华型', NULL, 4424, 0, NULL, 'J', 0, 5, 14556),
(54776, '1.8L 手动 豪华型', NULL, 4424, 0, NULL, 'J', 0, 5, 14555),
(54775, '1.8L 手动 精英型', NULL, 4424, 0, NULL, 'J', 0, 5, 14554),
(54774, '1.8L 手动 精英型', NULL, 4423, 0, NULL, 'J', 0, 5, 100659),
(54773, '1.8L 手动 豪华型', NULL, 4423, 0, NULL, 'J', 0, 5, 100657),
(54772, '1.8L 手动 商务版', NULL, 4423, 0, NULL, 'J', 0, 5, 100656),
(54771, '1.8L 手动 公务版', NULL, 4423, 0, NULL, 'J', 0, 5, 100655),
(54770, '2.0L 手动 豪华型', NULL, 4423, 0, NULL, 'J', 0, 5, 100654),
(54769, '2.0L 手动 尊贵型', NULL, 4423, 0, NULL, 'J', 0, 5, 100653),
(54768, '2.0L 自动 尊崇型', NULL, 4423, 0, NULL, 'J', 0, 5, 100652),
(54767, '2.0L 自动 豪华型', NULL, 4423, 0, NULL, 'J', 0, 5, 16222),
(54766, '1.5标准型', NULL, 4422, 0, NULL, 'J', 0, 5, 8631),
(54765, '1.8标准型', NULL, 4422, 0, NULL, 'J', 0, 5, 8630),
(54764, '1.3 手动基本型', NULL, 4421, 0, NULL, 'J', 0, 5, 107939),
(54763, '1.3L MT 基本型', NULL, 4421, 0, NULL, 'J', 0, 5, 8785),
(54762, '亮景 1.3 手动', NULL, 4420, 0, NULL, 'J', 0, 5, 109069),
(54761, '1.5 手动舒适型', NULL, 4419, 0, NULL, 'J', 0, 5, 109071),
(54760, '1.5 手动基本型', NULL, 4419, 0, NULL, 'J', 0, 5, 109070),
(54759, '1.3 手动舒适型', NULL, 4419, 0, NULL, 'J', 0, 5, 107941),
(54758, '1.3 手动基本型', NULL, 4419, 0, NULL, 'J', 0, 5, 107940),
(54757, '1.05 手动幸福版舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 109091),
(54756, '1.05 手动幸福版基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 109090),
(54755, '1.0 手动温馨版舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 109079),
(54754, '1.0 手动温馨版标准型', NULL, 4418, 0, NULL, 'J', 0, 5, 109078),
(54753, '1.0 手动温馨版基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 109077),
(54752, '1.3 手动幸福版基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 109076),
(54751, '1.05 手动温馨版舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 109075),
(54750, '1.05 手动温馨版标准型', NULL, 4418, 0, NULL, 'J', 0, 5, 109074),
(54749, '1.05 手动温馨版基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 109073),
(54748, '1.0 手动基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 109072),
(54747, '1.3 手动舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 107946),
(54746, '1.3 手动基本型', NULL, 4418, 0, NULL, 'J', 0, 5, 107944),
(54745, '1.3 手动幸福版舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 107922),
(54744, '幸福版 1.3L MT舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 10433),
(54743, '1.3L MT 舒适型', NULL, 4418, 0, NULL, 'J', 0, 5, 10431),
(54742, '1.0 手动温馨版标准型', NULL, 4417, 0, NULL, 'J', 0, 5, 109093),
(54741, '1.0 手动温馨版基本型', NULL, 4417, 0, NULL, 'J', 0, 5, 109092),
(54740, '1.05 手动幸福版舒适型', NULL, 4417, 0, NULL, 'J', 0, 5, 109081),
(54739, '1.05 手动幸福版基本型', NULL, 4417, 0, NULL, 'J', 0, 5, 109080),
(54738, '1.3 手动舒适型', NULL, 4417, 0, NULL, 'J', 0, 5, 107943),
(54737, '1.3 手动基本型', NULL, 4417, 0, NULL, 'J', 0, 5, 107942),
(54736, '1.5L MT 舒适型', NULL, 4417, 0, NULL, 'J', 0, 5, 10432),
(54735, '1.5L MT 基本型', NULL, 4417, 0, NULL, 'J', 0, 5, 10430),
(54734, '1.0 手动温馨版基本型', NULL, 4416, 0, NULL, 'J', 0, 5, 109095),
(54733, '1.0 手动温馨版标准型', NULL, 4416, 0, NULL, 'J', 0, 5, 109094),
(54732, '1.3 手动舒适型', NULL, 4416, 0, NULL, 'J', 0, 5, 107947),
(54731, '1.3 手动基本型', NULL, 4416, 0, NULL, 'J', 0, 5, 107945),
(54730, '1.05L—MT舒适型', NULL, 4416, 0, NULL, 'J', 0, 5, 5640),
(54729, '1.05L—MT基本型', NULL, 4416, 0, NULL, 'J', 0, 5, 5639),
(54728, '1.0L—MT舒适型', NULL, 4416, 0, NULL, 'J', 0, 5, 5637),
(54727, '1.0L—MT基本型', NULL, 4416, 0, NULL, 'J', 0, 5, 5636),
(54726, '1.5L  手动 无敌型', NULL, 4415, 0, NULL, 'J', 0, 5, 12671),
(54725, '1.5 手动无敌型', NULL, 4414, 0, NULL, 'J', 0, 5, 107789),
(54724, '1.5 手动尊贵型', NULL, 4414, 0, NULL, 'J', 0, 5, 107788),
(54723, '1.3 手动舒适型', NULL, 4414, 0, NULL, 'J', 0, 5, 107787),
(54722, '1.5L 自动 舒适型', NULL, 4414, 0, NULL, 'J', 0, 5, 14884),
(54721, '1.3L 手动 豪华型', NULL, 4414, 0, NULL, 'J', 0, 5, 12262),
(54720, '1.3L 手动 舒适型', NULL, 4414, 0, NULL, 'J', 0, 5, 12261),
(54719, '1.5L 手动 尊贵型', NULL, 4414, 0, NULL, 'J', 0, 5, 12260),
(54718, '1.3L 手动 舒适型', NULL, 4413, 0, NULL, 'J', 0, 5, 102050),
(54717, '1.5L 自动 标准型Ⅱ', NULL, 4413, 0, NULL, 'J', 0, 5, 102046),
(54716, '1.3 手动时尚型', NULL, 4412, 0, NULL, 'J', 0, 5, 109088),
(54715, '1.3 手动家庭改进型增配版', NULL, 4412, 0, NULL, 'J', 0, 5, 109066),
(54714, '1.3 手动家庭改进型', NULL, 4412, 0, NULL, 'J', 0, 5, 109065),
(54713, '1.3 手动家庭型增配版', NULL, 4412, 0, NULL, 'J', 0, 5, 109064),
(54712, '1.3 手动家庭型', NULL, 4412, 0, NULL, 'J', 0, 5, 109063),
(54711, '1.3 手动基本型增配版', NULL, 4412, 0, NULL, 'J', 0, 5, 109062),
(54710, '1.3 手动改进型增配版', NULL, 4412, 0, NULL, 'J', 0, 5, 109061),
(54709, '1.3 手动改进型', NULL, 4412, 0, NULL, 'J', 0, 5, 109060),
(54708, '1.3 手动普通型增配版', NULL, 4412, 0, NULL, 'J', 0, 5, 109059),
(54707, '1.3 手动普通型', NULL, 4412, 0, NULL, 'J', 0, 5, 109058),
(54706, '1.3 手动基本型', NULL, 4412, 0, NULL, 'J', 0, 5, 107937),
(54705, '1.3 手动时尚型', NULL, 4411, 0, NULL, 'J', 0, 5, 109089),
(54704, 'MR7150X1舒适型', NULL, 4410, 0, NULL, 'J', 0, 5, 1422),
(54703, 'MR7150X1基本型', NULL, 4410, 0, NULL, 'J', 0, 5, 1421),
(54702, 'MR6370X1舒适型', NULL, 4410, 0, NULL, 'J', 0, 5, 1420),
(54701, 'MR6370X1基本型', NULL, 4410, 0, NULL, 'J', 0, 5, 1419),
(54700, '1.5 舒适型', NULL, 4409, 0, NULL, 'J', 0, 5, 109067),
(54699, '1.3 舒适型', NULL, 4409, 0, NULL, 'J', 0, 5, 107938),
(54698, '1.3L 舒适型', NULL, 4409, 0, NULL, 'J', 0, 5, 1424),
(54697, '1.3L 基本型', NULL, 4409, 0, NULL, 'J', 0, 5, 1423),
(54696, '1.3 基本型', NULL, 4408, 0, NULL, 'J', 0, 5, 109068),
(54695, '1.3 舒适型', NULL, 4408, 0, NULL, 'J', 0, 5, 107921),
(54694, '1.05 舒适型', NULL, 4408, 0, NULL, 'J', 0, 5, 107920),
(54693, '1.05 基本型', NULL, 4408, 0, NULL, 'J', 0, 5, 107919),
(54692, '1.0 舒适型', NULL, 4408, 0, NULL, 'J', 0, 5, 107918),
(54691, '1.0 基本型', NULL, 4408, 0, NULL, 'J', 0, 5, 107917),
(54690, '1.0L—MT 舒适型', NULL, 4407, 0, NULL, 'J', 0, 5, 5633),
(54689, '1.0L—MT 基本型', NULL, 4407, 0, NULL, 'J', 0, 5, 5632),
(54688, '1.05L—MT 舒适型', NULL, 4407, 0, NULL, 'J', 0, 5, 1426),
(54687, '1.05L—MT 基本型', NULL, 4407, 0, NULL, 'J', 0, 5, 1425),
(54686, '1.3 手动标准型', NULL, 4406, 0, NULL, 'J', 0, 5, 109050),
(54685, '1.5 手动标准型', NULL, 4406, 0, NULL, 'J', 0, 5, 107910),
(54684, '1.5L—MT基本型', NULL, 4406, 0, NULL, 'J', 0, 5, 1444),
(54683, '1.3 手动自助版', NULL, 4405, 0, NULL, 'J', 0, 5, 107933),
(54682, '1.3L MT 魅惑版', NULL, 4405, 0, NULL, 'J', 0, 5, 9046),
(54681, '都市黑豹1.5L', NULL, 4405, 0, NULL, 'J', 0, 5, 1446),
(54680, '1.5L—AT基本型', NULL, 4405, 0, NULL, 'J', 0, 5, 1445),
(54679, '豹风GT 1.3 手动舒适型', NULL, 4404, 0, NULL, 'J', 0, 5, 107909),
(54678, '1.5L 自动爱她版', NULL, 4404, 0, NULL, 'J', 0, 5, 1450),
(54677, '1.5L 手动风迷版', NULL, 4404, 0, NULL, 'J', 0, 5, 1449),
(54676, '1.3L自助版', NULL, 4404, 0, NULL, 'J', 0, 5, 1448),
(54675, '1.5L自助版', NULL, 4404, 0, NULL, 'J', 0, 5, 1447),
(54674, '1.5 自动爱她版豪华型', NULL, 4403, 0, NULL, 'J', 0, 5, 109085),
(54673, '1.5 手动自助版', NULL, 4403, 0, NULL, 'J', 0, 5, 107936),
(54672, '雳靓 1.8L MT', NULL, 4403, 0, NULL, 'J', 0, 5, 107935),
(54671, '1.5 自动爱她版标准型', NULL, 4403, 0, NULL, 'J', 0, 5, 107934),
(54670, '豹风 GT', NULL, 4403, 0, NULL, 'J', 0, 5, 1451),
(54669, '1.5 自动', NULL, 4402, 0, NULL, 'J', 0, 5, 109087),
(54668, '1.5 手动', NULL, 4402, 0, NULL, 'J', 0, 5, 109086),
(54667, '1.5 手动自助版', NULL, 4402, 0, NULL, 'J', 0, 5, 107911),
(54666, '1.8L MT（雳靓）', NULL, 4402, 0, NULL, 'J', 0, 5, 1456),
(54665, 'JL7155XHU 1.5爱她版豪配', NULL, 4402, 0, NULL, 'J', 0, 5, 1455),
(54664, 'JL7155XHU 1.5爱她版标配', NULL, 4402, 0, NULL, 'J', 0, 5, 1454),
(54663, 'JL7155X 1.5L风迷版标配', NULL, 4402, 0, NULL, 'J', 0, 5, 1453),
(54662, 'JL7135 1.3L纪念版标配', NULL, 4402, 0, NULL, 'J', 0, 5, 1452),
(54661, '1.5 MT STDX 标准型', NULL, 4401, 0, NULL, 'J', 0, 5, 107949),
(54660, '1.8L—MT标准型', NULL, 4401, 0, NULL, 'J', 0, 5, 5642),
(54659, '1.5L—MT天窗版', NULL, 4401, 0, NULL, 'J', 0, 5, 5216),
(54658, '1.5L—MT舒适型', NULL, 4401, 0, NULL, 'J', 0, 5, 1498),
(54657, '1.5L—MT豪华型', NULL, 4401, 0, NULL, 'J', 0, 5, 1497),
(54656, '豪华型GLX—AT 1.5L', NULL, 4401, 0, NULL, 'J', 0, 5, 1496),
(54655, '豪华型GLX 1.6L', NULL, 4401, 0, NULL, 'J', 0, 5, 1495),
(54654, '舒适型CX 1.6L', NULL, 4401, 0, NULL, 'J', 0, 5, 1494),
(54653, '标准型STDX 1.6L', NULL, 4401, 0, NULL, 'J', 0, 5, 1493),
(54652, '1.5 MT GLX 豪华型', NULL, 4400, 0, NULL, 'J', 0, 5, 107956),
(54651, '1.5 MT CX 舒适型', NULL, 4400, 0, NULL, 'J', 0, 5, 107955),
(54650, '经典版 1.5L—MT 基本型', NULL, 4400, 0, NULL, 'J', 0, 5, 5215),
(54649, '1.8L—MT豪华型', NULL, 4400, 0, NULL, 'J', 0, 5, 1502),
(54648, '1.8L—MT舒适型', NULL, 4400, 0, NULL, 'J', 0, 5, 1501),
(54647, '基本型STDX 1.5L', NULL, 4400, 0, NULL, 'J', 0, 5, 1500),
(54646, '经典版 1.5L—MT 标准型', NULL, 4400, 0, NULL, 'J', 0, 5, 1499),
(54645, '1.5 MT基本型', NULL, 4399, 0, NULL, 'J', 0, 5, 109099),
(54644, '1.5 MT双燃料', NULL, 4399, 0, NULL, 'J', 0, 5, 109098),
(54643, '1.5 MT天窗版', NULL, 4399, 0, NULL, 'J', 0, 5, 109097),
(54642, '1.5 AT GLX 豪华型', NULL, 4399, 0, NULL, 'J', 0, 5, 107948),
(54641, '1.5 MT双燃料天然气型', NULL, 4398, 0, NULL, 'J', 0, 5, 109102),
(54640, '1.5 MT基本型', NULL, 4398, 0, NULL, 'J', 0, 5, 109100),
(54639, '1.5 MT STDX 标准型', NULL, 4398, 0, NULL, 'J', 0, 5, 107950),
(54638, '1.5 MT 无敌增配版', NULL, 4397, 0, NULL, 'J', 0, 5, 109101),
(54637, 'CNG 1.5L—MT 经典版', NULL, 4397, 0, NULL, 'J', 0, 5, 11965),
(54636, '1.5L—MT 无敌版', NULL, 4397, 0, NULL, 'J', 0, 5, 10790),
(54635, '1.5L—MT 经典版', NULL, 4397, 0, NULL, 'J', 0, 5, 10789),
(54634, '1.6 手动基本型', NULL, 4396, 0, NULL, 'J', 0, 5, 108997),
(54633, '1.3 手动舒适型', NULL, 4396, 0, NULL, 'J', 0, 5, 107795),
(54632, '1.3 手动基本型', NULL, 4396, 0, NULL, 'J', 0, 5, 107794),
(54631, '1.6 手动舒适型', NULL, 4396, 0, NULL, 'J', 0, 5, 107782),
(54630, '1.5L 无极舰 自动', NULL, 4396, 0, NULL, 'J', 0, 5, 1477),
(54629, '1.3 手动舒适型精诚舰', NULL, 4395, 0, NULL, 'J', 0, 5, 108996),
(54628, '1.3 手动基本型精智舰', NULL, 4395, 0, NULL, 'J', 0, 5, 108995),
(54627, '1.3 手动标准型精慧舰', NULL, 4395, 0, NULL, 'J', 0, 5, 108994),
(54626, '1.5 手动基本型', NULL, 4395, 0, NULL, 'J', 0, 5, 107800),
(54625, '1.5 自动舒适型', NULL, 4395, 0, NULL, 'J', 0, 5, 107798),
(54624, '1.5 手动舒适型', NULL, 4395, 0, NULL, 'J', 0, 5, 107797),
(54623, '1.5 手动标准型', NULL, 4395, 0, NULL, 'J', 0, 5, 107796),
(54622, '1.3 手动标准型', NULL, 4395, 0, NULL, 'J', 0, 5, 107793),
(54621, '1.6 手动舒适型', NULL, 4395, 0, NULL, 'J', 0, 5, 107783),
(54620, '1.6 手动标准型', NULL, 4395, 0, NULL, 'J', 0, 5, 107781),
(54619, '1.6L 精英舰', NULL, 4395, 0, NULL, 'J', 0, 5, 1482),
(54618, '1.6L 精锐舰', NULL, 4395, 0, NULL, 'J', 0, 5, 1481),
(54617, '1.3L 舒适版', NULL, 4395, 0, NULL, 'J', 0, 5, 1479),
(54616, '1.3 手动舒适型', NULL, 4394, 0, NULL, 'J', 0, 5, 107802),
(54615, '1.3 手动标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 107801),
(54614, '1.3 手动基本型', NULL, 4394, 0, NULL, 'J', 0, 5, 107799),
(54613, '1.5 手动舒适型', NULL, 4394, 0, NULL, 'J', 0, 5, 107786),
(54612, '1.5 手动标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 107785),
(54611, '1.5 自动标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 107784),
(54610, '1.5L AT标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 1492),
(54609, '1.5L AT舒适型', NULL, 4394, 0, NULL, 'J', 0, 5, 1491),
(54608, '1.5L 舒适型', NULL, 4394, 0, NULL, 'J', 0, 5, 1490),
(54607, '1.5L 标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 1489),
(54606, '舒适型1.5L—4AT', NULL, 4394, 0, NULL, 'J', 0, 5, 1485),
(54605, '基本型1.5L—4AT', NULL, 4394, 0, NULL, 'J', 0, 5, 1484),
(54604, '1.5L 舒适版', NULL, 4394, 0, NULL, 'J', 0, 5, 1483),
(54603, '1.5L 标准版', NULL, 4394, 0, NULL, 'J', 0, 5, 1480),
(54602, '1.3L 标准版', NULL, 4394, 0, NULL, 'J', 0, 5, 1478),
(54601, '1.3L基本型', NULL, 4394, 0, NULL, 'J', 0, 5, 1476),
(54600, '1.6L 舒适型', NULL, 4394, 0, NULL, 'J', 0, 5, 1475),
(54599, '1.6L 标准型', NULL, 4394, 0, NULL, 'J', 0, 5, 1474),
(54598, '1.3 手动限量版CNG双燃料', NULL, 4393, 0, NULL, 'J', 0, 5, 108998),
(54597, '精致版 1.5L—4AT 标准型', NULL, 4393, 0, NULL, 'J', 0, 5, 7578),
(54596, '精致版 1.3L—MT 豪华型', NULL, 4393, 0, NULL, 'J', 0, 5, 7577),
(54595, '精致版 1.3L—MT 标准型', NULL, 4393, 0, NULL, 'J', 0, 5, 7576),
(54594, '精致版 1.3L—MT 舒适型', NULL, 4393, 0, NULL, 'J', 0, 5, 1488),
(54593, '经典版 1.3L—MT 标准型', NULL, 4393, 0, NULL, 'J', 0, 5, 1487),
(54592, '经典版 1.3L—MT 基本型', NULL, 4393, 0, NULL, 'J', 0, 5, 1486),
(54591, '1.3 手动限量版CNG双燃料', NULL, 4392, 0, NULL, 'J', 0, 5, 108999),
(54590, '精致版 1.3 手动舒适型', NULL, 4392, 0, NULL, 'J', 0, 5, 107810),
(54589, '精致版 1.3 手动豪华型', NULL, 4392, 0, NULL, 'J', 0, 5, 107809),
(54588, '精致版 1.3 手动标准型', NULL, 4392, 0, NULL, 'J', 0, 5, 107808),
(54587, '经典版 1.3 手动标准型', NULL, 4392, 0, NULL, 'J', 0, 5, 107807),
(54586, '经典版 1.3 手动基本型', NULL, 4392, 0, NULL, 'J', 0, 5, 107806);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(54585, '1.5 自动精致版', NULL, 4392, 0, NULL, 'J', 0, 5, 107805),
(54584, '1.3 手动限量版CNG双燃料', NULL, 4391, 0, NULL, 'J', 0, 5, 109000),
(54583, '1.3L MT 财富版', NULL, 4391, 0, NULL, 'J', 0, 5, 13757),
(54582, '1.5L AT 冠军版', NULL, 4391, 0, NULL, 'J', 0, 5, 11684),
(54581, '1.5L AT 金钻版', NULL, 4391, 0, NULL, 'J', 0, 5, 11683),
(54580, '1.5L MT 冠军版', NULL, 4391, 0, NULL, 'J', 0, 5, 11682),
(54579, '1.5L MT 金钻版', NULL, 4391, 0, NULL, 'J', 0, 5, 11681),
(54578, '1.3L MT 冠军版', NULL, 4391, 0, NULL, 'J', 0, 5, 11680),
(54577, '1.3L MT 精致版', NULL, 4391, 0, NULL, 'J', 0, 5, 11679),
(54576, '1.3L MT 经典版', NULL, 4391, 0, NULL, 'J', 0, 5, 11678),
(54575, '1.3L MT 金钻版', NULL, 4391, 0, NULL, 'J', 0, 5, 11677),
(54574, '1.5 手动运动型', NULL, 4390, 0, NULL, 'J', 0, 5, 107804),
(54573, '1.0 手动进取型', NULL, 4390, 0, NULL, 'J', 0, 5, 107803),
(54572, '1.3L MT 时尚型', NULL, 4390, 0, NULL, 'J', 0, 5, 15047),
(54571, '1.0L MT CVVT 精英型', NULL, 4390, 0, NULL, 'J', 0, 5, 14248),
(54570, '1.3L MT 时尚型III', NULL, 4389, 0, NULL, 'J', 0, 5, 16072),
(54569, '1.3L MT 时尚型II', NULL, 4389, 0, NULL, 'J', 0, 5, 16071),
(54568, '1.0L MT CVVT 精英型II', NULL, 4389, 0, NULL, 'J', 0, 5, 16070),
(54567, '1.0L MT CVVT 进取型II', NULL, 4389, 0, NULL, 'J', 0, 5, 16068),
(54566, '1.5L MT 运动型II', NULL, 4389, 0, NULL, 'J', 0, 5, 14249),
(54565, '1.0L MT CVVT 进取型', NULL, 4389, 0, NULL, 'J', 0, 5, 14247),
(54564, '1.0L MT CVVT 超越版', NULL, 4388, 0, NULL, 'J', 0, 5, 106318),
(54563, '1.8CVVT—MT天窗版', NULL, 4387, 0, NULL, 'J', 0, 5, 5960),
(54562, '1.8CVVT—MT基本型', NULL, 4387, 0, NULL, 'J', 0, 5, 1506),
(54561, '1.8CVVT—MT标准型', NULL, 4387, 0, NULL, 'J', 0, 5, 1505),
(54560, '1.8CVVT—MT舒适型', NULL, 4387, 0, NULL, 'J', 0, 5, 1504),
(54559, '1.8CVVT—MT商务型', NULL, 4387, 0, NULL, 'J', 0, 5, 1503),
(54558, '1.8CVVT—MT油汽双燃料基本型', NULL, 4386, 0, NULL, 'J', 0, 5, 6954),
(54557, '1.8 手动双燃料', NULL, 4385, 0, NULL, 'J', 0, 5, 108993),
(54556, '1.5CVVT—MT天窗版', NULL, 4385, 0, NULL, 'J', 0, 5, 9648),
(54555, '1.5CVVT—MT尊贵版', NULL, 4385, 0, NULL, 'J', 0, 5, 8441),
(54554, '1.5CVVT—MT铂金版', NULL, 4385, 0, NULL, 'J', 0, 5, 8440),
(54553, '1.5 MT 白金版', NULL, 4384, 0, NULL, 'J', 0, 5, 14025),
(54552, '1.5 智能豪华导航版', NULL, 4384, 0, NULL, 'J', 0, 5, 10833),
(54551, '1.5 手动天窗版DVVT', NULL, 4383, 0, NULL, 'J', 0, 5, 107792),
(54550, '1.5 手动舒适型DVVT', NULL, 4383, 0, NULL, 'J', 0, 5, 107791),
(54549, '1.5 手动标准型DVVT', NULL, 4383, 0, NULL, 'J', 0, 5, 107790),
(54548, '1.5CVVT 手动 尊贵版', NULL, 4383, 0, NULL, 'J', 0, 5, 14803),
(54547, '1.8CVVT 手动 舒适型', NULL, 4383, 0, NULL, 'J', 0, 5, 14099),
(54546, '1.8CVVT 手动 标准型', NULL, 4383, 0, NULL, 'J', 0, 5, 14098),
(54545, '1.5CVVT 手动 天窗导航版 (CNG车型)', NULL, 4383, 0, NULL, 'J', 0, 5, 14097),
(54544, '1.5CVVT 手动 铂金版 (CNG车型)', NULL, 4383, 0, NULL, 'J', 0, 5, 14096),
(54543, '1.5CVVT 手动 铂金版', NULL, 4383, 0, NULL, 'J', 0, 5, 14095),
(54542, '1.5CVVT 手动 白金版', NULL, 4383, 0, NULL, 'J', 0, 5, 14094),
(54541, '1.8 BMBS版 标准型', NULL, 4383, 0, NULL, 'J', 0, 5, 13319),
(54540, '1.8 BMBS版 舒适型', NULL, 4383, 0, NULL, 'J', 0, 5, 13238),
(54539, '1.5CVVT-MT天窗导航版', NULL, 4383, 0, NULL, 'J', 0, 5, 13208),
(54538, '1.8 DVVT 自动 标准型', NULL, 4382, 0, NULL, 'J', 0, 5, 102267),
(54537, '1.5CVVT 手动 豪华型', NULL, 4382, 0, NULL, 'J', 0, 5, 100446),
(54536, '1.5CVVT 手动 舒适型', NULL, 4382, 0, NULL, 'J', 0, 5, 100444),
(54535, '1.5CVVT 手动 标准型', NULL, 4382, 0, NULL, 'J', 0, 5, 100443),
(54534, '1.5DVVT 手动 豪华型', NULL, 4382, 0, NULL, 'J', 0, 5, 16167),
(54533, '1.5DVVT 手动 天窗版', NULL, 4382, 0, NULL, 'J', 0, 5, 14765),
(54532, '1.5DVVT 手动 舒适型', NULL, 4382, 0, NULL, 'J', 0, 5, 14764),
(54531, '1.5DVVT 手动 标准型', NULL, 4382, 0, NULL, 'J', 0, 5, 14763),
(54530, '1.5L 手动 舒适型', NULL, 4381, 0, NULL, 'J', 0, 5, 102787),
(54529, '1.8L 自动 舒适型', NULL, 4381, 0, NULL, 'J', 0, 5, 102786),
(54528, '1.5L 手动 限量超值版', NULL, 4380, 0, NULL, 'J', 0, 5, 111134),
(54527, '1.8L 手动 舒适型 CNG', NULL, 4380, 0, NULL, 'J', 0, 5, 111133),
(54526, '汽油 MT 豪华', NULL, 4379, 0, NULL, 'J', 0, 5, 9924),
(54525, '柴油 MT 豪华', NULL, 4379, 0, NULL, 'J', 0, 5, 9923),
(54524, '柴油 AT 豪华', NULL, 4379, 0, NULL, 'J', 0, 5, 9922),
(54523, '柴油 AT 标配', NULL, 4379, 0, NULL, 'J', 0, 5, 8642),
(54522, '柴油 MT 标配', NULL, 4379, 0, NULL, 'J', 0, 5, 8641),
(54521, '汽油 MT 标配', NULL, 4379, 0, NULL, 'J', 0, 5, 8640),
(54520, '1.3L 手动 进取型', NULL, 4378, 0, NULL, 'J', 0, 5, 110435),
(54519, '1.3L 手动 精英型', NULL, 4378, 0, NULL, 'J', 0, 5, 110434),
(54518, '1.5L 自动 进取型', NULL, 4378, 0, NULL, 'J', 0, 5, 110433),
(54517, '1.5L 自动 精英型', NULL, 4378, 0, NULL, 'J', 0, 5, 110432),
(54516, '1.3 MT 无敌版', NULL, 4377, 0, NULL, 'J', 0, 5, 107780),
(54515, '1.3 MT 乐动版', NULL, 4377, 0, NULL, 'J', 0, 5, 107779),
(54514, '1.3 MT 灵动版', NULL, 4377, 0, NULL, 'J', 0, 5, 107778),
(54513, '1.3 MT 功夫版', NULL, 4377, 0, NULL, 'J', 0, 5, 107777),
(54512, '1.3 MT 功夫升级版', NULL, 4376, 0, NULL, 'J', 0, 5, 109003),
(54511, '1.0L—5MT 活力版', NULL, 4376, 0, NULL, 'J', 0, 5, 11018),
(54510, '1.5L—4AT 爱她版 豪华型', NULL, 4376, 0, NULL, 'J', 0, 5, 11017),
(54509, '1.5L—4AT 爱她版 舒适型', NULL, 4376, 0, NULL, 'J', 0, 5, 11016),
(54508, '1.5L—4AT 爱她版 标准型', NULL, 4376, 0, NULL, 'J', 0, 5, 11015),
(54507, '1.0L—5MT 无敌版', NULL, 4376, 0, NULL, 'J', 0, 5, 9536),
(54506, '1.0L—5MT 乐动版', NULL, 4376, 0, NULL, 'J', 0, 5, 9535),
(54505, '1.0L—5MT 灵动版', NULL, 4376, 0, NULL, 'J', 0, 5, 9534),
(54504, '1.0L—5MT 功夫版', NULL, 4376, 0, NULL, 'J', 0, 5, 9533),
(54503, '1.3L—4AT 爱她版 豪华型', NULL, 4376, 0, NULL, 'J', 0, 5, 8395),
(54502, '1.3L—4AT 爱她版 舒适型', NULL, 4376, 0, NULL, 'J', 0, 5, 8393),
(54501, '1.3L—4AT 爱她版 标准型', NULL, 4376, 0, NULL, 'J', 0, 5, 8390),
(54500, '1.3L—5MT 无敌版', NULL, 4376, 0, NULL, 'J', 0, 5, 7223),
(54499, '1.3L—5MT 乐动版', NULL, 4376, 0, NULL, 'J', 0, 5, 7222),
(54498, '1.3L—5MT 灵动版', NULL, 4376, 0, NULL, 'J', 0, 5, 7221),
(54497, '1.3L—5MT 功夫版', NULL, 4376, 0, NULL, 'J', 0, 5, 7220),
(54496, '1.5L—4AT 爱她版 尊贵型', NULL, 4375, 0, NULL, 'J', 0, 5, 11704),
(54495, '1.3L—4AT 爱她版 无敌型', NULL, 4375, 0, NULL, 'J', 0, 5, 11703),
(54494, '1.3L—4AT 爱她版 尊贵型', NULL, 4375, 0, NULL, 'J', 0, 5, 11702),
(54493, '1.3L—5MT 领航版 尊贵型', NULL, 4375, 0, NULL, 'J', 0, 5, 11701),
(54492, '1.5L—4AT爱她版 豪华型', NULL, 4375, 0, NULL, 'J', 0, 5, 11659),
(54491, '1.5L—4AT爱她版 舒适型', NULL, 4375, 0, NULL, 'J', 0, 5, 11657),
(54490, '1.5L—4AT爱她版 标准型', NULL, 4375, 0, NULL, 'J', 0, 5, 11656),
(54489, '1.3L—4AT爱她版 豪华型', NULL, 4375, 0, NULL, 'J', 0, 5, 11655),
(54488, '1.3L—4AT爱她版 舒适型', NULL, 4375, 0, NULL, 'J', 0, 5, 11654),
(54487, '1.3L—4AT爱她版 标准型', NULL, 4375, 0, NULL, 'J', 0, 5, 11653),
(54486, '1.3L—5MT 无敌版', NULL, 4375, 0, NULL, 'J', 0, 5, 11652),
(54485, '1.3L—5MT 乐动版', NULL, 4375, 0, NULL, 'J', 0, 5, 11651),
(54484, '1.3L—5MT 灵动版', NULL, 4375, 0, NULL, 'J', 0, 5, 11650),
(54483, '1.3L—5MT 功夫版', NULL, 4375, 0, NULL, 'J', 0, 5, 11649),
(54482, '1.0L—5MT 豪华型', NULL, 4375, 0, NULL, 'J', 0, 5, 11648),
(54481, '1.0L—5MT 舒适型', NULL, 4375, 0, NULL, 'J', 0, 5, 11647),
(54480, '1.0L—5MT 标准型', NULL, 4375, 0, NULL, 'J', 0, 5, 11646),
(54479, '1.0L 手动 黑白双色 豪华型', NULL, 4374, 0, NULL, 'J', 0, 5, 102058),
(54478, '1.3L 自动 黑白双色 尊贵型', NULL, 4374, 0, NULL, 'J', 0, 5, 102057),
(54477, '1.0L 手动 标准型', NULL, 4374, 0, NULL, 'J', 0, 5, 102056),
(54476, '1.0L 手动 舒适型Ⅱ', NULL, 4374, 0, NULL, 'J', 0, 5, 102055),
(54475, '1.3L 手动 舒适型Ⅱ', NULL, 4374, 0, NULL, 'J', 0, 5, 102054),
(54474, '1.3L 自动 尊贵型', NULL, 4374, 0, NULL, 'J', 0, 5, 102053),
(54473, '1.3L 手动 尊贵型', NULL, 4374, 0, NULL, 'J', 0, 5, 14105),
(54472, '1.3L 手动 舒适型', NULL, 4374, 0, NULL, 'J', 0, 5, 14104),
(54471, '1.5L 4AT爱她版 无敌型', NULL, 4374, 0, NULL, 'J', 0, 5, 13279),
(54470, '1.3L 5MT 无敌型', NULL, 4374, 0, NULL, 'J', 0, 5, 13277),
(54469, '1.3L 自动 尊贵型', NULL, 4373, 0, NULL, 'J', 0, 5, 103622),
(54468, '1.3L 手动 舒适型II', NULL, 4373, 0, NULL, 'J', 0, 5, 103621),
(54467, '1.0L 手动 精英型', NULL, 4373, 0, NULL, 'J', 0, 5, 103620),
(54466, '1.0L 手动 进取型', NULL, 4373, 0, NULL, 'J', 0, 5, 103619),
(54465, '1.0L 手动 标准型', NULL, 4373, 0, NULL, 'J', 0, 5, 103616),
(54464, '1.5L—MT 豪华版', NULL, 4372, 0, NULL, 'J', 0, 5, 103434),
(54463, '1.5L—MT 炫酷版A型', NULL, 4372, 0, NULL, 'J', 0, 5, 12971),
(54462, '1.5L—MT 炫酷版B型', NULL, 4372, 0, NULL, 'J', 0, 5, 12206),
(54461, '1.5L—MT 尚酷版', NULL, 4372, 0, NULL, 'J', 0, 5, 12205),
(54460, '1.5L 手动 进取型', NULL, 4371, 0, NULL, 'J', 0, 5, 110707),
(54459, '1.5L 手动 精英型', NULL, 4371, 0, NULL, 'J', 0, 5, 110706),
(54458, '1.5L 手动 尊贵型', NULL, 4371, 0, NULL, 'J', 0, 5, 110705),
(54457, '1.5L 自动 精英型', NULL, 4371, 0, NULL, 'J', 0, 5, 110700),
(54456, '1.5L—MT 豪华型', NULL, 4370, 0, NULL, 'J', 0, 5, 6882),
(54455, '1.5L—MT 舒适型', NULL, 4370, 0, NULL, 'J', 0, 5, 6881),
(54454, '1.5L—MT 标准型', NULL, 4370, 0, NULL, 'J', 0, 5, 6880),
(54453, '1.5L—AT 豪华型', NULL, 4370, 0, NULL, 'J', 0, 5, 5959),
(54452, '1.5L—AT 舒适型', NULL, 4370, 0, NULL, 'J', 0, 5, 5958),
(54451, '1.5L—AT 标准型', NULL, 4370, 0, NULL, 'J', 0, 5, 5957),
(54450, '1.5 自动豪华型', NULL, 4369, 0, NULL, 'J', 0, 5, 107960),
(54449, '1.5 自动舒适型', NULL, 4369, 0, NULL, 'J', 0, 5, 107959),
(54448, '1.5 自动标准型', NULL, 4369, 0, NULL, 'J', 0, 5, 107958),
(54447, '1.5L AT 导航版', NULL, 4369, 0, NULL, 'J', 0, 5, 11059),
(54446, '1.5L AT 无敌版', NULL, 4369, 0, NULL, 'J', 0, 5, 11058),
(54445, '1.5 MT 导航版', NULL, 4369, 0, NULL, 'J', 0, 5, 11057),
(54444, '1.5 MT 无敌版', NULL, 4369, 0, NULL, 'J', 0, 5, 11056),
(54443, '1.5 自动导航版', NULL, 4368, 0, NULL, 'J', 0, 5, 11274),
(54442, '1.5 自动豪华型', NULL, 4368, 0, NULL, 'J', 0, 5, 11273),
(54441, '1.5 自动标准型', NULL, 4368, 0, NULL, 'J', 0, 5, 11272),
(54440, '1.5 自动无敌版', NULL, 4368, 0, NULL, 'J', 0, 5, 11271),
(54439, '1.5 自动基本型', NULL, 4368, 0, NULL, 'J', 0, 5, 11270),
(54438, '1.5 手动导航版', NULL, 4368, 0, NULL, 'J', 0, 5, 11269),
(54437, '1.5 手动豪华型', NULL, 4368, 0, NULL, 'J', 0, 5, 11268),
(54436, '1.5 手动标准型', NULL, 4368, 0, NULL, 'J', 0, 5, 11267),
(54435, '1.5 手动无敌版', NULL, 4368, 0, NULL, 'J', 0, 5, 11266),
(54434, '1.5 手动基本型', NULL, 4368, 0, NULL, 'J', 0, 5, 11265),
(54433, '1.5 手动 豪华型', NULL, 4368, 0, NULL, 'J', 0, 5, 11062),
(54432, '1.5 手动舒适型', NULL, 4368, 0, NULL, 'J', 0, 5, 11061),
(54431, '1.5 手动 标准型', NULL, 4368, 0, NULL, 'J', 0, 5, 11060),
(54430, '1.5 手动 标准型', NULL, 4367, 0, NULL, 'J', 0, 5, 101276),
(54429, '1.5 手动 豪华型', NULL, 4367, 0, NULL, 'J', 0, 5, 101275),
(54428, '1.5L 手动 进取型', NULL, 4366, 0, NULL, 'J', 0, 5, 110710),
(54427, '1.5L 手动 精英型', NULL, 4366, 0, NULL, 'J', 0, 5, 110709),
(54426, '1.5L 自动 精英型', NULL, 4366, 0, NULL, 'J', 0, 5, 110708),
(54425, '1.5L—MT 豪华型', NULL, 4365, 0, NULL, 'J', 0, 5, 8275),
(54424, '1.5L—MT 标准型', NULL, 4365, 0, NULL, 'J', 0, 5, 8274),
(54423, '1.5 MT 导航型', NULL, 4364, 0, NULL, 'J', 0, 5, 109103),
(54422, '1.5 MT 豪华型', NULL, 4364, 0, NULL, 'J', 0, 5, 107957),
(54421, '1.5L 手动 豪华型 CNG', NULL, 4364, 0, NULL, 'J', 0, 5, 11967),
(54420, '1.5L 手动 标准型 CNG', NULL, 4364, 0, NULL, 'J', 0, 5, 11966),
(54419, '1.5L 自动 标准型', NULL, 4364, 0, NULL, 'J', 0, 5, 11964),
(54418, '1.5L 手动 导航型', NULL, 4364, 0, NULL, 'J', 0, 5, 10788),
(54417, '1.5L 手动 豪华型', NULL, 4364, 0, NULL, 'J', 0, 5, 10787),
(54416, '1.5L 手动 标准型', NULL, 4364, 0, NULL, 'J', 0, 5, 10786),
(54415, '1.5L 手动 尊贵型', NULL, 4363, 0, NULL, 'J', 0, 5, 103536),
(54414, '1.5L 手动 精英型', NULL, 4363, 0, NULL, 'J', 0, 5, 103535),
(54413, '1.5L 手动 进取型', NULL, 4363, 0, NULL, 'J', 0, 5, 103534),
(54412, '1.5L 手动 进取型', NULL, 4362, 0, NULL, 'J', 0, 5, 101882),
(54411, '1.5L 手动 尊贵型', NULL, 4362, 0, NULL, 'J', 0, 5, 101881),
(54410, '1.5L 手动 精英型', NULL, 4362, 0, NULL, 'J', 0, 5, 101735),
(54409, '1.5L 手动 进取型', NULL, 4361, 0, NULL, 'J', 0, 5, 110694),
(54408, '1.5L 手动 精英型', NULL, 4361, 0, NULL, 'J', 0, 5, 110693),
(54407, '1.5L 手动 尊贵型', NULL, 4361, 0, NULL, 'J', 0, 5, 110692),
(54406, '1.5L 自动 精英型', NULL, 4361, 0, NULL, 'J', 0, 5, 110691),
(54405, '1.8L 豪华型', NULL, 4360, 0, NULL, 'J', 0, 5, 9988),
(54404, '1.8L 舒适型', NULL, 4360, 0, NULL, 'J', 0, 5, 9987),
(54403, '1.8L 标准型', NULL, 4360, 0, NULL, 'J', 0, 5, 9986),
(54402, '1.8L 基本型', NULL, 4360, 0, NULL, 'J', 0, 5, 8751),
(54401, '1.8L 豪华型', NULL, 4359, 0, NULL, 'J', 0, 5, 107954),
(54400, '1.8L 舒适型', NULL, 4359, 0, NULL, 'J', 0, 5, 107953),
(54399, '1.8L 标准型', NULL, 4359, 0, NULL, 'J', 0, 5, 107952),
(54398, '1.8L 基本型', NULL, 4359, 0, NULL, 'J', 0, 5, 107951),
(54397, '1.5L 尊贵型', NULL, 4359, 0, NULL, 'J', 0, 5, 12263),
(54396, '1.5L 舒适型', NULL, 4359, 0, NULL, 'J', 0, 5, 9991),
(54395, '1.5L 标准型', NULL, 4359, 0, NULL, 'J', 0, 5, 9990),
(54394, '1.5L 基本型', NULL, 4359, 0, NULL, 'J', 0, 5, 9989),
(54393, '1.5L 手动 新锐版 超值型', NULL, 4358, 0, NULL, 'J', 0, 5, 16554),
(54392, '1.5L 手动 节能版 尊贵版', NULL, 4358, 0, NULL, 'J', 0, 5, 15001),
(54391, '1.5L 手动 新锐版 尊贵版', NULL, 4358, 0, NULL, 'J', 0, 5, 15000),
(54390, '1.5L 手动 节能版 舒适型', NULL, 4358, 0, NULL, 'J', 0, 5, 13768),
(54389, '1.5L 手动 节能版 标准型', NULL, 4358, 0, NULL, 'J', 0, 5, 13765),
(54388, '1.5L 手动 节能版 基本型', NULL, 4358, 0, NULL, 'J', 0, 5, 13758),
(54387, '1.5L 手动 新锐版 舒适型', NULL, 4358, 0, NULL, 'J', 0, 5, 12348),
(54386, '1.5L 手动 新锐版 标准型', NULL, 4358, 0, NULL, 'J', 0, 5, 12347),
(54385, '1.5L 手动 新锐版 基本型', NULL, 4358, 0, NULL, 'J', 0, 5, 12345),
(54384, '1.8L 手动 新锐版 基本型', NULL, 4358, 0, NULL, 'J', 0, 5, 11494),
(54383, '1.8L 手动 新锐版 舒适型', NULL, 4358, 0, NULL, 'J', 0, 5, 11493),
(54382, '1.8L 手动 新锐版 标准型', NULL, 4358, 0, NULL, 'J', 0, 5, 11492),
(54381, '节能版 1.5L 手动 尊贵型', NULL, 4357, 0, NULL, 'J', 0, 5, 103259),
(54380, '节能版 1.5L 手动 精英型', NULL, 4357, 0, NULL, 'J', 0, 5, 103258),
(54379, '节能版 1.5L 手动 进取型', NULL, 4357, 0, NULL, 'J', 0, 5, 103257),
(54378, '节能版 1.5L 手动 超悦型', NULL, 4357, 0, NULL, 'J', 0, 5, 103256),
(54377, '1.8L 自动 精英型', NULL, 4357, 0, NULL, 'J', 0, 5, 101909),
(54376, '1.8L 自动 尊贵型', NULL, 4357, 0, NULL, 'J', 0, 5, 101908),
(54375, '1.8L 自动 尊贵型', NULL, 4356, 0, NULL, 'J', 0, 5, 102992),
(54374, '1.8L 自动 精英型', NULL, 4356, 0, NULL, 'J', 0, 5, 102991),
(54373, '1.5L 手动 尊贵型', NULL, 4356, 0, NULL, 'J', 0, 5, 102990),
(54372, '1.5L 手动 精英型', NULL, 4356, 0, NULL, 'J', 0, 5, 102989),
(54371, '1.5L 手动 进取型', NULL, 4356, 0, NULL, 'J', 0, 5, 102988),
(54370, '1.5L 手动 超悦型', NULL, 4356, 0, NULL, 'J', 0, 5, 102987),
(54369, '1.5L 手动 尊贵型', NULL, 4355, 0, NULL, 'J', 0, 5, 110311),
(54368, '1.5L 手动 精英型', NULL, 4355, 0, NULL, 'J', 0, 5, 110230),
(54367, '1.5L MT 尊贵型', NULL, 4354, 0, NULL, 'J', 0, 5, 9727),
(54366, '1.5L MT 豪华型', NULL, 4354, 0, NULL, 'J', 0, 5, 9726),
(54365, '1.5L MT 舒适型', NULL, 4354, 0, NULL, 'J', 0, 5, 9725),
(54364, '1.8L MT标准型', NULL, 4354, 0, NULL, 'J', 0, 5, 8912),
(54363, '1.5L MT 舒适型', NULL, 4353, 0, NULL, 'J', 0, 5, 106863),
(54362, '1.5L MT 豪华型', NULL, 4353, 0, NULL, 'J', 0, 5, 106862),
(54361, '1.5L MT 尊贵型', NULL, 4353, 0, NULL, 'J', 0, 5, 106850),
(54360, '1.8—CVT 天窗型', NULL, 4353, 0, NULL, 'J', 0, 5, 11923),
(54359, '1.8—CVT 豪华型', NULL, 4353, 0, NULL, 'J', 0, 5, 11922),
(54358, '1.8—CVT 尊贵型', NULL, 4353, 0, NULL, 'J', 0, 5, 11921),
(54357, '1.8—CVT 精英型', NULL, 4353, 0, NULL, 'J', 0, 5, 11919),
(54356, '1.8—MT 尊贵型', NULL, 4353, 0, NULL, 'J', 0, 5, 8915),
(54355, '1.8—MT 豪华型', NULL, 4353, 0, NULL, 'J', 0, 5, 8914),
(54354, '1.8—MT 舒适型', NULL, 4353, 0, NULL, 'J', 0, 5, 8913),
(54353, '1.5L MT 豪华型', NULL, 4352, 0, NULL, 'J', 0, 5, 14035),
(54352, '1.5L MT 天窗型', NULL, 4352, 0, NULL, 'J', 0, 5, 14034),
(54351, '1.5L MT 标准型', NULL, 4352, 0, NULL, 'J', 0, 5, 14033),
(54350, '1.5L MT 舒适型', NULL, 4352, 0, NULL, 'J', 0, 5, 14032),
(54349, '1.5L MT 豪华型', NULL, 4351, 0, NULL, 'J', 0, 5, 106861),
(54348, '1.5L MT 舒适型', NULL, 4351, 0, NULL, 'J', 0, 5, 106860),
(54347, '1.5L 手动超悦惠民型', NULL, 4351, 0, NULL, 'J', 0, 5, 102507),
(54346, '1.5L 手动 超悦版', NULL, 4351, 0, NULL, 'J', 0, 5, 100205),
(54345, '1.8L 自动 尊贵型', NULL, 4351, 0, NULL, 'J', 0, 5, 14841),
(54344, '1.8L 自动 豪华型', NULL, 4351, 0, NULL, 'J', 0, 5, 14840),
(54343, '1.8L 自动 舒适型', NULL, 4351, 0, NULL, 'J', 0, 5, 14839),
(54342, '1.8L 手动 ESC版', NULL, 4351, 0, NULL, 'J', 0, 5, 14838),
(54341, '1.8L 手动 尊贵型', NULL, 4351, 0, NULL, 'J', 0, 5, 14837),
(54340, '1.8L 手动 豪华型', NULL, 4351, 0, NULL, 'J', 0, 5, 14836),
(54339, '1.8L 手动 舒适型', NULL, 4351, 0, NULL, 'J', 0, 5, 14835),
(54338, '1.5L 手动 豪华型', NULL, 4351, 0, NULL, 'J', 0, 5, 14834),
(54337, '1.5L 手动 舒适型', NULL, 4351, 0, NULL, 'J', 0, 5, 14833),
(54336, '1.5L 手动 标准型', NULL, 4351, 0, NULL, 'J', 0, 5, 14832),
(54335, '1.5L 手动 进取型', NULL, 4350, 0, NULL, 'J', 0, 5, 103731),
(54334, '1.8L 自动 尊贵型', NULL, 4350, 0, NULL, 'J', 0, 5, 102885),
(54333, '1.8L 自动 精英型', NULL, 4350, 0, NULL, 'J', 0, 5, 102884),
(54332, '1.5L 手动 尊贵型', NULL, 4350, 0, NULL, 'J', 0, 5, 102883),
(54331, '1.5L 手动 精英型', NULL, 4350, 0, NULL, 'J', 0, 5, 102881),
(54330, '1.8L MT尊贵型', NULL, 4349, 0, NULL, 'J', 0, 5, 9729),
(54329, '1.8L MT标准型', NULL, 4349, 0, NULL, 'J', 0, 5, 9728),
(54328, '1.8L MT旗舰型', NULL, 4349, 0, NULL, 'J', 0, 5, 8911),
(54327, '1.8L MT豪华型', NULL, 4349, 0, NULL, 'J', 0, 5, 8910),
(54326, '1.8L MT舒适型', NULL, 4349, 0, NULL, 'J', 0, 5, 8909),
(54325, '1.8 CVT 尊贵型', NULL, 4348, 0, NULL, 'J', 0, 5, 106859),
(54324, '1.8 CVT 天窗型', NULL, 4348, 0, NULL, 'J', 0, 5, 106858),
(54323, '1.8 CVT 精英型', NULL, 4348, 0, NULL, 'J', 0, 5, 106857),
(54322, '1.8 CVT 豪华型', NULL, 4348, 0, NULL, 'J', 0, 5, 106856),
(54321, '1.8L MT尊贵型', NULL, 4348, 0, NULL, 'J', 0, 5, 14246),
(54320, '1.8L MT豪华型', NULL, 4348, 0, NULL, 'J', 0, 5, 14245),
(54319, '1.8L MT舒适型', NULL, 4348, 0, NULL, 'J', 0, 5, 14244),
(54318, '1.8L MT标准型', NULL, 4348, 0, NULL, 'J', 0, 5, 14243),
(54317, '1.8—CVT 尊贵型', NULL, 4348, 0, NULL, 'J', 0, 5, 11918),
(54316, '1.8—CVT 豪华型', NULL, 4348, 0, NULL, 'J', 0, 5, 11917),
(54315, '1.8—CVT 天窗型', NULL, 4348, 0, NULL, 'J', 0, 5, 11916),
(54314, '1.8—CVT 精英型', NULL, 4348, 0, NULL, 'J', 0, 5, 11915),
(54313, '1.8L MT尊贵型', NULL, 4347, 0, NULL, 'J', 0, 5, 106855),
(54312, '1.8L MT豪华型', NULL, 4347, 0, NULL, 'J', 0, 5, 106854),
(54311, '1.8L MT舒适型', NULL, 4347, 0, NULL, 'J', 0, 5, 106853),
(54310, '1.8 CVT 尊贵型', NULL, 4347, 0, NULL, 'J', 0, 5, 106852),
(54309, '1.8 CVT 豪华型', NULL, 4347, 0, NULL, 'J', 0, 5, 106851),
(54308, '1.5L 手动超悦惠民型', NULL, 4347, 0, NULL, 'J', 0, 5, 102506),
(54307, '1.5L 手动 超悦版', NULL, 4347, 0, NULL, 'J', 0, 5, 100202),
(54306, '1.8L 手动 GSG版', NULL, 4347, 0, NULL, 'J', 0, 5, 14831),
(54305, '1.8L 手动 ESC版', NULL, 4347, 0, NULL, 'J', 0, 5, 14830),
(54304, '1.8L 自动 尊贵型', NULL, 4347, 0, NULL, 'J', 0, 5, 14829),
(54303, '1.8L 自动 豪华型', NULL, 4347, 0, NULL, 'J', 0, 5, 14828),
(54302, '1.8L 自动 舒适型', NULL, 4347, 0, NULL, 'J', 0, 5, 14827),
(54301, '1.8L 手动 尊贵型', NULL, 4347, 0, NULL, 'J', 0, 5, 14826),
(54300, '1.8L 手动 豪华型', NULL, 4347, 0, NULL, 'J', 0, 5, 14825),
(54299, '1.8L 手动 舒适型', NULL, 4347, 0, NULL, 'J', 0, 5, 14824),
(54298, '1.5L 手动 舒适型', NULL, 4347, 0, NULL, 'J', 0, 5, 14823),
(54297, '1.5L 手动 标准型', NULL, 4347, 0, NULL, 'J', 0, 5, 14822),
(54296, '1.8L 手动 精英型CNG', NULL, 4346, 0, NULL, 'J', 0, 5, 111036),
(54295, '1.8L 手动 进取型CNG', NULL, 4346, 0, NULL, 'J', 0, 5, 111035),
(54294, '1.5L 手动 进取型', NULL, 4346, 0, NULL, 'J', 0, 5, 103146),
(54293, '1.8L 自动 旗舰型', NULL, 4346, 0, NULL, 'J', 0, 5, 102876),
(54292, '1.8L 自动 尊贵型', NULL, 4346, 0, NULL, 'J', 0, 5, 102875),
(54291, '1.8L 自动 精英型', NULL, 4346, 0, NULL, 'J', 0, 5, 102874),
(54290, '1.8L 手动 旗舰型', NULL, 4346, 0, NULL, 'J', 0, 5, 102873),
(54289, '1.8L 手动 尊贵型', NULL, 4346, 0, NULL, 'J', 0, 5, 102872),
(54288, '1.8L 手动 精英型', NULL, 4346, 0, NULL, 'J', 0, 5, 102871),
(54287, '1.5L 手动 精英型', NULL, 4346, 0, NULL, 'J', 0, 5, 102860),
(54286, '2.0L 手动 进取型', NULL, 4345, 0, NULL, 'J', 0, 5, 105038),
(54285, '2.0L 自动 进取型', NULL, 4345, 0, NULL, 'J', 0, 5, 105037),
(54284, '2.0L 自动 尊贵型', NULL, 4345, 0, NULL, 'J', 0, 5, 105036),
(54283, '1.8L 手动 进取型', NULL, 4345, 0, NULL, 'J', 0, 5, 102870),
(54282, '1.8L 手动 精英型', NULL, 4345, 0, NULL, 'J', 0, 5, 102869),
(54281, '2.0L 手动 精英型', NULL, 4345, 0, NULL, 'J', 0, 5, 102867),
(54280, '2.0L 手动 尊贵型', NULL, 4345, 0, NULL, 'J', 0, 5, 102866),
(54279, '1.8L 手动 尊贵型', NULL, 4345, 0, NULL, 'J', 0, 5, 102864),
(54278, '2.4L 自动 尊贵型', NULL, 4345, 0, NULL, 'J', 0, 5, 102861),
(54277, '2.4L 自动 尊贵型', NULL, 4344, 0, NULL, 'J', 0, 5, 110321),
(54276, '2.0L 自动 尊贵型', NULL, 4344, 0, NULL, 'J', 0, 5, 110320),
(54275, '2.0L 自动 豪华型', NULL, 4344, 0, NULL, 'J', 0, 5, 110319),
(54274, '2.0L 手动 尊贵型', NULL, 4344, 0, NULL, 'J', 0, 5, 110318),
(54273, '2.0L 手动 进取型', NULL, 4344, 0, NULL, 'J', 0, 5, 110317),
(54272, '1.8L 手动 尊贵型', NULL, 4344, 0, NULL, 'J', 0, 5, 110316),
(54271, '1.8L 手动 精英型', NULL, 4344, 0, NULL, 'J', 0, 5, 110315),
(54270, '1.8L 手动 进取型', NULL, 4344, 0, NULL, 'J', 0, 5, 110314),
(54269, '1.3L 手动 基本型', NULL, 4343, 0, NULL, 'J', 0, 5, 101453),
(54268, '1.3L 手动 标准型', NULL, 4343, 0, NULL, 'J', 0, 5, 101452),
(54267, '1.3L 手动 舒适型', NULL, 4343, 0, NULL, 'J', 0, 5, 101451),
(54266, '1.3L 手动 豪华型', NULL, 4343, 0, NULL, 'J', 0, 5, 101449),
(54265, '1.3L 手动 进取型', NULL, 4342, 0, NULL, 'J', 0, 5, 111151),
(54264, '1.3L 手动 尊贵型', NULL, 4342, 0, NULL, 'J', 0, 5, 111150),
(54263, '2.4L 自动 行政型', NULL, 4341, 0, NULL, 'J', 0, 5, 101925),
(54262, '2.4L 自动 舒适型', NULL, 4341, 0, NULL, 'J', 0, 5, 101924),
(54261, '2.0L 手动 行政型', NULL, 4341, 0, NULL, 'J', 0, 5, 101492),
(54260, '2.4L 手自一体 旗舰型', NULL, 4341, 0, NULL, 'J', 0, 5, 100390),
(54259, '2.0L 手动 舒适型', NULL, 4341, 0, NULL, 'J', 0, 5, 16172),
(54258, '1.8L 手动 行政版', NULL, 4341, 0, NULL, 'J', 0, 5, 15776),
(54257, '1.8L 手动 精英型', NULL, 4341, 0, NULL, 'J', 0, 5, 15774),
(54256, '1.8L 手动 舒适型', NULL, 4341, 0, NULL, 'J', 0, 5, 15773),
(54255, '2.0L 手动 进取型', NULL, 4340, 0, NULL, 'J', 0, 5, 104910),
(54254, '2.0L 自动 进取型', NULL, 4340, 0, NULL, 'J', 0, 5, 104900),
(54253, '1.8L 手动 进取型', NULL, 4340, 0, NULL, 'J', 0, 5, 103964),
(54252, '1.8L 手动 精英型', NULL, 4340, 0, NULL, 'J', 0, 5, 103963),
(54251, '1.8L 手动 尊贵型', NULL, 4340, 0, NULL, 'J', 0, 5, 103962),
(54250, '2.0L 手动 精英型', NULL, 4340, 0, NULL, 'J', 0, 5, 103961),
(54249, '2.0L 手动 尊贵型', NULL, 4340, 0, NULL, 'J', 0, 5, 103960),
(54248, '2.0L 自动 精英型', NULL, 4340, 0, NULL, 'J', 0, 5, 103959),
(54247, '2.0L 自动 尊贵型', NULL, 4340, 0, NULL, 'J', 0, 5, 103958),
(54246, '2.4L 自动 尊贵型', NULL, 4340, 0, NULL, 'J', 0, 5, 103957),
(54245, '2.0L 手动 进取型 京5', NULL, 4339, 0, NULL, 'J', 0, 5, 110476),
(54244, '2.0L 手动 尊贵型 京5', NULL, 4339, 0, NULL, 'J', 0, 5, 110475),
(54243, '2.0L 自动 豪华型 京5', NULL, 4339, 0, NULL, 'J', 0, 5, 110474),
(54242, '2.0L 自动 尊贵型 京5', NULL, 4339, 0, NULL, 'J', 0, 5, 110473),
(54241, '2.4L 自动 尊贵型 京5', NULL, 4339, 0, NULL, 'J', 0, 5, 110472),
(54240, '2.4L 自动 尊贵型', NULL, 4339, 0, NULL, 'J', 0, 5, 110149),
(54239, '2.0L 自动 尊贵型', NULL, 4339, 0, NULL, 'J', 0, 5, 110148),
(54238, '2.0L 自动 豪华型', NULL, 4339, 0, NULL, 'J', 0, 5, 110147),
(54237, '2.0L 手动 尊贵型', NULL, 4339, 0, NULL, 'J', 0, 5, 110146),
(54236, '2.0L 手动 进取型', NULL, 4339, 0, NULL, 'J', 0, 5, 110145),
(54235, '1.8L 手动 尊贵型', NULL, 4339, 0, NULL, 'J', 0, 5, 110144),
(54234, '1.8L 手动 精英型', NULL, 4339, 0, NULL, 'J', 0, 5, 110143),
(54233, '1.8L 手动 进取型', NULL, 4339, 0, NULL, 'J', 0, 5, 110077),
(54232, '1.8 自动豪华型', NULL, 4338, 0, NULL, 'J', 0, 5, 109002),
(54231, '1.8 手动豪华型', NULL, 4338, 0, NULL, 'J', 0, 5, 109001),
(54230, '1.5L 手动 CVVT 豪华型', NULL, 4338, 0, NULL, 'J', 0, 5, 16171),
(54229, '1.5L 手动 CVVT 精英型', NULL, 4338, 0, NULL, 'J', 0, 5, 16170),
(54228, '1.5L 手动 CVVT 舒适型', NULL, 4338, 0, NULL, 'J', 0, 5, 16169),
(54227, '1.5L 手动 CVVT 标准型', NULL, 4338, 0, NULL, 'J', 0, 5, 16168),
(54226, '1.8L 自动 DVVT 豪华型', NULL, 4338, 0, NULL, 'J', 0, 5, 15575),
(54225, '1.8L 自动 DVVT 精英型', NULL, 4338, 0, NULL, 'J', 0, 5, 15574),
(54224, '1.8L 自动 DVVT 舒适型', NULL, 4338, 0, NULL, 'J', 0, 5, 15573),
(54223, '1.8L 手动 CVVT 豪华型', NULL, 4338, 0, NULL, 'J', 0, 5, 15572),
(54222, '1.8L 手动 CVVT 精英型', NULL, 4338, 0, NULL, 'J', 0, 5, 15571),
(54221, '1.8L 手动 CVVT 舒适型', NULL, 4338, 0, NULL, 'J', 0, 5, 15294),
(54220, '1.5L 手动 尊贵型', NULL, 4337, 0, NULL, 'J', 0, 5, 102719),
(54219, '1.8L 自动 豪华型', NULL, 4337, 0, NULL, 'J', 0, 5, 102717),
(54218, '1.8L 自动 尊贵型', NULL, 4337, 0, NULL, 'J', 0, 5, 102711),
(54217, '1.5L 手动 舒适型', NULL, 4337, 0, NULL, 'J', 0, 5, 102707),
(54216, '2.0L 自动型 BMBS版', NULL, 4336, 0, NULL, 'J', 0, 5, 106865),
(54215, '2.4L 自动型 BMBS版', NULL, 4336, 0, NULL, 'J', 0, 5, 106864),
(54214, '2.0L 自动型 行政版', NULL, 4336, 0, NULL, 'J', 0, 5, 12358),
(54213, '2.0L 自动型 尊贵版', NULL, 4336, 0, NULL, 'J', 0, 5, 12357),
(54212, '2.0L 自动型 豪华版', NULL, 4336, 0, NULL, 'J', 0, 5, 12356),
(54211, '2.0L 自动型 舒适版', NULL, 4336, 0, NULL, 'J', 0, 5, 12355),
(54210, '2.0L 手动型 舒适版', NULL, 4336, 0, NULL, 'J', 0, 5, 12354),
(54209, '2.0L 手动型 标准版', NULL, 4336, 0, NULL, 'J', 0, 5, 12353),
(54208, '2.4L 自动型 行政版', NULL, 4336, 0, NULL, 'J', 0, 5, 12352),
(54207, '2.4L 自动型 尊贵版', NULL, 4336, 0, NULL, 'J', 0, 5, 12351),
(54206, '2.0L 自动型 标准版', NULL, 4336, 0, NULL, 'J', 0, 5, 12350),
(54205, '2.4L 自动型 豪华版', NULL, 4336, 0, NULL, 'J', 0, 5, 12349),
(54204, '2.0L 自动型 BMCS版', NULL, 4335, 0, NULL, 'J', 0, 5, 14694),
(54203, '2.4L 自动型 BMCS版', NULL, 4335, 0, NULL, 'J', 0, 5, 14693),
(54202, '2.4L 自动 至尊型', NULL, 4334, 0, NULL, 'J', 0, 5, 102799),
(54201, '2.4L 自动 行政型', NULL, 4334, 0, NULL, 'J', 0, 5, 102798),
(54200, '2.4L 自动 旗舰型', NULL, 4334, 0, NULL, 'J', 0, 5, 102797),
(54199, '2.4L 自动 尊贵型', NULL, 4334, 0, NULL, 'J', 0, 5, 102796),
(54198, '2.0L 自动 旗舰型', NULL, 4334, 0, NULL, 'J', 0, 5, 102795),
(54197, '2.0L 自动 尊贵型', NULL, 4334, 0, NULL, 'J', 0, 5, 102794),
(54196, '2.0L 自动 精英型', NULL, 4334, 0, NULL, 'J', 0, 5, 102793),
(54195, '2.0L 自动 进取型', NULL, 4334, 0, NULL, 'J', 0, 5, 102792),
(54194, '2.0L 手动 尊贵型', NULL, 4334, 0, NULL, 'J', 0, 5, 102791),
(54193, '2.0L 手动 精英型', NULL, 4334, 0, NULL, 'J', 0, 5, 102790),
(54192, '2.0L 手动 进取型', NULL, 4334, 0, NULL, 'J', 0, 5, 102788),
(54191, '1.3 手动基本型', NULL, 4333, 0, NULL, 'J', 0, 5, 109082),
(54190, '1.3 手动豪华型', NULL, 4333, 0, NULL, 'J', 0, 5, 109057),
(54189, '1.3 手动舒适型', NULL, 4333, 0, NULL, 'J', 0, 5, 109056),
(54188, '1.0 手动豪华型', NULL, 4333, 0, NULL, 'J', 0, 5, 109055),
(54187, '1.0 手动B1B', NULL, 4333, 0, NULL, 'J', 0, 5, 109054),
(54186, '1.0 手动B1P', NULL, 4333, 0, NULL, 'J', 0, 5, 109053),
(54185, '1.0 手动E1B', NULL, 4333, 0, NULL, 'J', 0, 5, 109052),
(54184, '1.0 手动基本型', NULL, 4333, 0, NULL, 'J', 0, 5, 107912),
(54183, '1.05L 基本型', NULL, 4333, 0, NULL, 'J', 0, 5, 4013),
(54182, '1.0L 基本型', NULL, 4333, 0, NULL, 'J', 0, 5, 4012),
(54181, '1.0 手动E1P', NULL, 4332, 0, NULL, 'J', 0, 5, 109051),
(54180, '亮星舒适型', NULL, 4331, 0, NULL, 'J', 0, 5, 1429),
(54179, '300JL7131', NULL, 4331, 0, NULL, 'J', 0, 5, 1427),
(54178, 'SRV 1.05 手动舒适型', NULL, 4330, 0, NULL, 'J', 0, 5, 109096),
(54177, '亮星1.0 基本型', NULL, 4330, 0, NULL, 'J', 0, 5, 107929),
(54176, '300A 1.05 手动技术领先型', NULL, 4330, 0, NULL, 'J', 0, 5, 107925),
(54175, '300A 1.05 手动舒适型', NULL, 4330, 0, NULL, 'J', 0, 5, 107924),
(54174, '300A 1.05 手动基本型', NULL, 4330, 0, NULL, 'J', 0, 5, 107923),
(54173, '203A 1.05 手动技术领先型', NULL, 4330, 0, NULL, 'J', 0, 5, 107915),
(54172, '203A 1.05 手动舒适型', NULL, 4330, 0, NULL, 'J', 0, 5, 107914),
(54171, '203A 1.05 手动基本型', NULL, 4330, 0, NULL, 'J', 0, 5, 107913),
(54170, '都市保姆 JL5010 x2 1.0L', NULL, 4330, 0, NULL, 'J', 0, 5, 9050),
(54169, '乡村保姆 JL1010N2 1.0L', NULL, 4330, 0, NULL, 'J', 0, 5, 9049),
(54168, '都市保姆 JL5010 x1 1.0L', NULL, 4330, 0, NULL, 'J', 0, 5, 9048),
(54167, '乡村保姆 JL1010N1 1.0L', NULL, 4330, 0, NULL, 'J', 0, 5, 9047),
(54166, '203A 1.0L基本型', NULL, 4330, 0, NULL, 'J', 0, 5, 1438),
(54165, '203A 1.0L舒适型', NULL, 4330, 0, NULL, 'J', 0, 5, 1437),
(54164, '豪情亮星2代1.0基本型', NULL, 4330, 0, NULL, 'J', 0, 5, 1436),
(54163, '豪情亮星2代1.0舒适型', NULL, 4330, 0, NULL, 'J', 0, 5, 1435),
(54162, '亮星经济型', NULL, 4330, 0, NULL, 'J', 0, 5, 1432),
(54161, '203A 1.0L技术领先型', NULL, 4330, 0, NULL, 'J', 0, 5, 1431),
(54160, 'HQ6360E2', NULL, 4330, 0, NULL, 'J', 0, 5, 1430),
(54159, '亮景JL6360E1', NULL, 4330, 0, NULL, 'J', 0, 5, 1428),
(54158, '1.3L 舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 10429),
(54157, '300A 1.05L舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 10428),
(54156, '300A 1.05L技术领先型', NULL, 4329, 0, NULL, 'J', 0, 5, 10427),
(54155, '300A 1.05L基本型', NULL, 4329, 0, NULL, 'J', 0, 5, 10426),
(54154, '203A 1.05L舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 10425),
(54153, '203A 1.05L技术领先型', NULL, 4329, 0, NULL, 'J', 0, 5, 10424),
(54152, '203A 1.05L基本型', NULL, 4329, 0, NULL, 'J', 0, 5, 10423),
(54151, '1.0L 舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 10422),
(54150, '1.05L 舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 10421),
(54149, 'SRV舒适型 1.5L AT', NULL, 4329, 0, NULL, 'J', 0, 5, 4561),
(54148, 'SRV舒适型 1.3L', NULL, 4329, 0, NULL, 'J', 0, 5, 4560),
(54147, 'SRV舒适型 1.0L', NULL, 4329, 0, NULL, 'J', 0, 5, 4559),
(54146, '303 1.3L舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 1443),
(54145, '303 1.3L基本型', NULL, 4329, 0, NULL, 'J', 0, 5, 1442),
(54144, '303A 1.05L技术领先型', NULL, 4329, 0, NULL, 'J', 0, 5, 1441),
(54143, '303A 1.05L舒适型', NULL, 4329, 0, NULL, 'J', 0, 5, 1440),
(54142, 'SRV 1.5L 自动', NULL, 4329, 0, NULL, 'J', 0, 5, 1439),
(54141, 'SRV 1.3L 手动', NULL, 4329, 0, NULL, 'J', 0, 5, 1434),
(54140, 'SRV 1.0L 手动', NULL, 4329, 0, NULL, 'J', 0, 5, 1433),
(54139, '1.05 手动基本型', NULL, 4328, 0, NULL, 'J', 0, 5, 109084),
(54138, '1.05 手动舒适型', NULL, 4328, 0, NULL, 'J', 0, 5, 107931),
(54137, '1.0 手动舒适型', NULL, 4328, 0, NULL, 'J', 0, 5, 107930),
(54136, 'SRV 1.0 手动舒适型', NULL, 4328, 0, NULL, 'J', 0, 5, 107926),
(54135, '1.0 手动基本型', NULL, 4328, 0, NULL, 'J', 0, 5, 107916),
(54134, 'SRV 1.05 手动舒适型', NULL, 4327, 0, NULL, 'J', 0, 5, 109083),
(54133, '亮星2代1.0基本型', NULL, 4327, 0, NULL, 'J', 0, 5, 107932),
(54132, 'SRV 1.3 手动舒适型', NULL, 4327, 0, NULL, 'J', 0, 5, 107928),
(54131, 'SRV 1.0 手动舒适型', NULL, 4327, 0, NULL, 'J', 0, 5, 107927),
(54130, '自由人3.7L', NULL, 4326, 0, NULL, 'J', 0, 5, 3522),
(54129, '2.4L CVT 70周年限量版', NULL, 4325, 0, NULL, 'J', 0, 5, 14419),
(54128, '2.4L CVT 豪华版', NULL, 4325, 0, NULL, 'J', 0, 5, 14418),
(54127, '2.4L CVT 运动升级版', NULL, 4325, 0, NULL, 'J', 0, 5, 14417),
(54126, '2.4L CVT 运动版', NULL, 4325, 0, NULL, 'J', 0, 5, 14416),
(54125, '2.4L CVT 经典升级版', NULL, 4325, 0, NULL, 'J', 0, 5, 14415),
(54124, '2.4L CVT 经典版', NULL, 4325, 0, NULL, 'J', 0, 5, 13945),
(54123, '2.4L CVT 豪华版', NULL, 4324, 0, NULL, 'J', 0, 5, 15732),
(54122, '2.4L CVT 运动版', NULL, 4324, 0, NULL, 'J', 0, 5, 15731),
(54121, '2.4L 自动 豪华型 导航版', NULL, 4323, 0, NULL, 'J', 0, 5, 102410),
(54120, '2.4L 自动 运动版', NULL, 4323, 0, NULL, 'J', 0, 5, 102408),
(54119, '2.4L 自动 炫黑运动版', NULL, 4323, 0, NULL, 'J', 0, 5, 102404),
(54118, '改款 2.4L 自动 运动版', NULL, 4322, 0, NULL, 'J', 0, 5, 109941),
(54117, '改款 2.4L 自动 豪华导航版', NULL, 4322, 0, NULL, 'J', 0, 5, 109940),
(54116, '改款 2.0L CVT 运动增强版', NULL, 4322, 0, NULL, 'J', 0, 5, 109939),
(54115, '2.0L 自动 运动版', NULL, 4322, 0, NULL, 'J', 0, 5, 104484),
(54114, '2.4L 自动 运动版', NULL, 4322, 0, NULL, 'J', 0, 5, 104483),
(54113, '2.4L 自动 蛇行珍藏版', NULL, 4322, 0, NULL, 'J', 0, 5, 104481),
(54112, '2.4L 自动 豪华导航版', NULL, 4322, 0, NULL, 'J', 0, 5, 104479),
(54111, '2.4L 自动 高性能版', NULL, 4321, 0, NULL, 'J', 0, 5, 111340),
(54110, '3.2L 自动 高性能版', NULL, 4321, 0, NULL, 'J', 0, 5, 106491),
(54109, '2.4L 自动 精锐版', NULL, 4321, 0, NULL, 'J', 0, 5, 106490),
(54108, '2.4L 自动 豪华版', NULL, 4321, 0, NULL, 'J', 0, 5, 106489),
(54107, '2.4L 自动 都市版', NULL, 4321, 0, NULL, 'J', 0, 5, 106244),
(54106, '2.4 手动一体运动版 四驱', NULL, 4320, 0, NULL, 'J', 0, 5, 3274),
(54105, '2.4 手动一体限量版型 四驱', NULL, 4320, 0, NULL, 'J', 0, 5, 3273),
(54104, '限量版', NULL, 4319, 0, NULL, 'J', 0, 5, 7442),
(54103, '运动版', NULL, 4319, 0, NULL, 'J', 0, 5, 7441),
(54102, '2.4 世界杯特别版', NULL, 4318, 0, NULL, 'J', 0, 5, 10769),
(54101, '2.4 限量版', NULL, 4318, 0, NULL, 'J', 0, 5, 10041),
(54100, '2.4 运动版', NULL, 4318, 0, NULL, 'J', 0, 5, 10040),
(54099, '2.0L 自动 运动版', NULL, 4317, 0, NULL, 'J', 0, 5, 14851),
(54098, '2.4L 自动 舒适升级版', NULL, 4317, 0, NULL, 'J', 0, 5, 14850),
(54097, '2.4L 自动 舒适版', NULL, 4317, 0, NULL, 'J', 0, 5, 14849),
(54096, '2.4L 自动 经典升级版', NULL, 4317, 0, NULL, 'J', 0, 5, 14848),
(54095, '2.4L 自动 70周年限量版', NULL, 4317, 0, NULL, 'J', 0, 5, 13949),
(54094, '2.4L 自动 豪华导航版', NULL, 4317, 0, NULL, 'J', 0, 5, 13948),
(54093, '2.4L 自动 豪华版', NULL, 4317, 0, NULL, 'J', 0, 5, 13947),
(54092, '2.4L 自动 运动版', NULL, 4317, 0, NULL, 'J', 0, 5, 13946),
(54091, '2.4L 自动 经典版', NULL, 4317, 0, NULL, 'J', 0, 5, 13944),
(54090, '2.4L 自动 豪华导航版', NULL, 4316, 0, NULL, 'J', 0, 5, 15718),
(54089, '2.4L 自动 豪华版', NULL, 4316, 0, NULL, 'J', 0, 5, 15717),
(54088, '2.4L 自动 都市版', NULL, 4316, 0, NULL, 'J', 0, 5, 15715),
(54087, '2.4L 自动 运动版', NULL, 4316, 0, NULL, 'J', 0, 5, 15713),
(54086, '2.0L 自动 豪华版', NULL, 4316, 0, NULL, 'J', 0, 5, 15711),
(54085, '2.0L 自动 运动版', NULL, 4316, 0, NULL, 'J', 0, 5, 15706),
(54084, '2.0L 自动 运动版', NULL, 4315, 0, NULL, 'J', 0, 5, 102412),
(54083, '2.0L 自动 豪华版', NULL, 4315, 0, NULL, 'J', 0, 5, 102411),
(54082, '2.0L 自动 炫黑豪华版', NULL, 4315, 0, NULL, 'J', 0, 5, 102409),
(54081, '2.4L 自动 运动版', NULL, 4315, 0, NULL, 'J', 0, 5, 102407),
(54080, '2.4L 自动 都市版', NULL, 4315, 0, NULL, 'J', 0, 5, 102406),
(54079, '2.4L 自动 豪华版', NULL, 4315, 0, NULL, 'J', 0, 5, 102405),
(54078, '2.4L 自动 炫黑导航版', NULL, 4315, 0, NULL, 'J', 0, 5, 102403),
(54077, '改款 2.0L CVT 进取版', NULL, 4314, 0, NULL, 'J', 0, 5, 109948),
(54076, '改款 2.0L CVT 精英版', NULL, 4314, 0, NULL, 'J', 0, 5, 109947),
(54075, '改款 2.4L 自动 舒适版', NULL, 4314, 0, NULL, 'J', 0, 5, 109946),
(54074, '改款 2.4L 自动 豪华版', NULL, 4314, 0, NULL, 'J', 0, 5, 109945),
(54073, '改款 2.4L 自动 豪华导航版', NULL, 4314, 0, NULL, 'J', 0, 5, 109944),
(54072, '2.0L 自动 运动版', NULL, 4314, 0, NULL, 'J', 0, 5, 104024),
(54071, '2.0L 自动 都市版', NULL, 4314, 0, NULL, 'J', 0, 5, 104023),
(54070, '2.0L 自动 豪华版', NULL, 4314, 0, NULL, 'J', 0, 5, 104022),
(54069, '2.4L 自动 运动版', NULL, 4314, 0, NULL, 'J', 0, 5, 104021),
(54068, '2.4L 自动 蛇形珍藏版', NULL, 4314, 0, NULL, 'J', 0, 5, 104020),
(54067, '2.4L 自动 豪华版', NULL, 4314, 0, NULL, 'J', 0, 5, 104019),
(54066, '2.4L 自动 豪华导航版', NULL, 4314, 0, NULL, 'J', 0, 5, 104018),
(54065, '5.7升限量版', NULL, 4313, 0, NULL, 'J', 0, 5, 5644),
(54064, '4.7升限量版', NULL, 4313, 0, NULL, 'J', 0, 5, 5643),
(54063, '5.7L HEMI', NULL, 4312, 0, NULL, 'J', 0, 5, 3270),
(54062, '4.7L', NULL, 4312, 0, NULL, 'J', 0, 5, 3269),
(54061, '5.7L HEMI', NULL, 4311, 0, NULL, 'J', 0, 5, 10764),
(54060, '4.7L', NULL, 4311, 0, NULL, 'J', 0, 5, 10763),
(54059, '4.0L 自动', NULL, 4310, 0, NULL, 'J', 0, 5, 10435),
(54058, '4.0L顶级版', NULL, 4309, 0, NULL, 'J', 0, 5, 3521),
(54057, '2.4L', NULL, 4309, 0, NULL, 'J', 0, 5, 3520),
(54056, '3.8L 五门', NULL, 4308, 0, NULL, 'J', 0, 5, 3630),
(54055, '3.8L 三门', NULL, 4308, 0, NULL, 'J', 0, 5, 3629),
(54054, '四门 Sahara', NULL, 4307, 0, NULL, 'J', 0, 5, 7594),
(54053, '两门 Sahara', NULL, 4307, 0, NULL, 'J', 0, 5, 7591),
(54052, '3.8L四门硬顶', NULL, 4307, 0, NULL, 'J', 0, 5, 4928),
(54051, '四门 Rubicon', NULL, 4306, 0, NULL, 'J', 0, 5, 7596),
(54050, '两门 Rubicon', NULL, 4306, 0, NULL, 'J', 0, 5, 7595),
(54049, 'Rubicon四门款', NULL, 4305, 0, NULL, 'J', 0, 5, 10045),
(54048, 'Rubicon两门款', NULL, 4305, 0, NULL, 'J', 0, 5, 10044),
(54047, 'Sahara四门款', NULL, 4305, 0, NULL, 'J', 0, 5, 10043),
(54046, 'Sahara两门款', NULL, 4305, 0, NULL, 'J', 0, 5, 10042),
(54045, 'Rubicon四门款', NULL, 4304, 0, NULL, 'J', 0, 5, 12522),
(54044, 'Sahara四门款', NULL, 4304, 0, NULL, 'J', 0, 5, 12520),
(54043, 'Rubicon两门款', NULL, 4304, 0, NULL, 'J', 0, 5, 12519),
(54042, 'Sahara两门款', NULL, 4304, 0, NULL, 'J', 0, 5, 12518),
(54041, '3.6L 自动 四门Sahara 梦十珍藏版', NULL, 4303, 0, NULL, 'J', 0, 5, 101665),
(54040, '3.6L 自动 两门Arctic 极地版', NULL, 4303, 0, NULL, 'J', 0, 5, 16470),
(54039, '3.6L 自动 四门Rubicon', NULL, 4303, 0, NULL, 'J', 0, 5, 15175),
(54038, '3.6L 自动 四门Sahara', NULL, 4303, 0, NULL, 'J', 0, 5, 15174),
(54037, '3.6L 自动 两门Rubicon', NULL, 4303, 0, NULL, 'J', 0, 5, 15172),
(54036, '3.6L 自动 两门Sahara', NULL, 4303, 0, NULL, 'J', 0, 5, 15171),
(54035, '3.6L 自动 四门Rubicon 十周年版', NULL, 4302, 0, NULL, 'J', 0, 5, 105306),
(54034, '3.6L 自动 两门Rubicon 十周年版', NULL, 4302, 0, NULL, 'J', 0, 5, 105305),
(54033, '3.6L 自动 四门Rubicon', NULL, 4302, 0, NULL, 'J', 0, 5, 102850),
(54032, '3.6L 自动 四门Sahara', NULL, 4302, 0, NULL, 'J', 0, 5, 102849),
(54031, '3.6L 自动 两门Rubicon', NULL, 4302, 0, NULL, 'J', 0, 5, 102848),
(54030, '3.6L 自动 两门Sahara', NULL, 4302, 0, NULL, 'J', 0, 5, 102847),
(54029, '2.8TD 自动 四门Sahara 柴油', NULL, 4301, 0, NULL, 'J', 0, 5, 111179),
(54028, '3.0L 自动 四门Sahara', NULL, 4301, 0, NULL, 'J', 0, 5, 106628),
(54027, '3.6L 龙腾典藏版', NULL, 4301, 0, NULL, 'J', 0, 5, 106627),
(54026, '大切诺基4.0L', NULL, 4300, 0, NULL, 'J', 0, 5, 10434),
(54025, '大切诺基5.7L HEMI', NULL, 4299, 0, NULL, 'J', 0, 5, 3272),
(54024, '大切诺基4.7L', NULL, 4299, 0, NULL, 'J', 0, 5, 3271),
(54023, '大切诺基3.7L', NULL, 4298, 0, NULL, 'J', 0, 5, 4929),
(54022, '5.7L HEMI', NULL, 4297, 0, NULL, 'J', 0, 5, 10762),
(54021, '3.7L', NULL, 4297, 0, NULL, 'J', 0, 5, 10761),
(54020, '70周年限量版', NULL, 4296, 0, NULL, 'J', 0, 5, 14091),
(54019, '3.6 旗舰导航版', NULL, 4296, 0, NULL, 'J', 0, 5, 12648),
(54018, '3.6 旗舰版', NULL, 4296, 0, NULL, 'J', 0, 5, 12647),
(54017, '3.6 豪华导航版', NULL, 4296, 0, NULL, 'J', 0, 5, 12646),
(54016, '3.6 豪华版', NULL, 4296, 0, NULL, 'J', 0, 5, 12645),
(54015, '3.6 舒适版', NULL, 4296, 0, NULL, 'J', 0, 5, 12644),
(54014, '3.6 经典版', NULL, 4296, 0, NULL, 'J', 0, 5, 12643),
(54013, '5.7 旗舰导航版', NULL, 4296, 0, NULL, 'J', 0, 5, 12521),
(54012, '3.6L 梦十珍藏版', NULL, 4295, 0, NULL, 'J', 0, 5, 101666),
(54011, '5.7L 旗舰尊崇版', NULL, 4295, 0, NULL, 'J', 0, 5, 101177),
(54010, '3.6L 旗舰尊崇版', NULL, 4295, 0, NULL, 'J', 0, 5, 101176),
(54009, '5.7L 旗舰尊荣版', NULL, 4295, 0, NULL, 'J', 0, 5, 100784),
(54008, '3.6L 旗舰尊荣版', NULL, 4295, 0, NULL, 'J', 0, 5, 16441),
(54007, '3.6L 周年导航版', NULL, 4295, 0, NULL, 'J', 0, 5, 15730),
(54006, '5.7L 旗舰导航版', NULL, 4295, 0, NULL, 'J', 0, 5, 15609),
(54005, '3.6L 旗舰导航版', NULL, 4295, 0, NULL, 'J', 0, 5, 15608),
(54004, '6.4L SRT8', NULL, 4295, 0, NULL, 'J', 0, 5, 15606),
(54003, '3.6L 豪华导航版', NULL, 4295, 0, NULL, 'J', 0, 5, 15603),
(54002, '3.6L 舒适导航版', NULL, 4295, 0, NULL, 'J', 0, 5, 15600),
(54001, '6.4L SRT8 炫黑版', NULL, 4294, 0, NULL, 'J', 0, 5, 102838),
(54000, '6.4L SRT8', NULL, 4294, 0, NULL, 'J', 0, 5, 102604),
(53999, '5.7L 旗舰尊崇版', NULL, 4294, 0, NULL, 'J', 0, 5, 102603),
(53998, '3.6L 旗舰尊崇版', NULL, 4294, 0, NULL, 'J', 0, 5, 102602),
(53997, '3.6L 豪华导航版', NULL, 4294, 0, NULL, 'J', 0, 5, 102600),
(53996, '3.6L 舒享导航版', NULL, 4294, 0, NULL, 'J', 0, 5, 102599),
(53995, '3.6L 舒适版', NULL, 4294, 0, NULL, 'J', 0, 5, 102597),
(53994, '3.0TD 柴油 舒享导航版', NULL, 4293, 0, NULL, 'J', 0, 5, 110678),
(53993, '3.0L 旗舰尊悦版', NULL, 4293, 0, NULL, 'J', 0, 5, 110677),
(53992, '3.0L 舒享导航版', NULL, 4293, 0, NULL, 'J', 0, 5, 105848),
(53991, '3.6L 舒适导航版', NULL, 4293, 0, NULL, 'J', 0, 5, 104303),
(53990, '5.7L 旗舰尊悦版', NULL, 4293, 0, NULL, 'J', 0, 5, 104064),
(53989, '3.6L 精英导航版', NULL, 4293, 0, NULL, 'J', 0, 5, 104063),
(53988, '6.4L SRT8', NULL, 4293, 0, NULL, 'J', 0, 5, 103425),
(53987, '3.6L 旗舰尊悦版', NULL, 4293, 0, NULL, 'J', 0, 5, 103424),
(53986, '213 2.5 四驱 手动(化)', NULL, 4292, 0, NULL, 'J', 0, 5, 108658),
(53985, '87型213 2.5 四驱 手动(化)', NULL, 4291, 0, NULL, 'J', 0, 5, 108659),
(53984, 'BJ2021 2.5 四驱 手动(化)', NULL, 4290, 0, NULL, 'J', 0, 5, 108660),
(53983, '213', NULL, 4289, 0, NULL, 'J', 0, 5, 6856),
(53982, '4.0 加长型 四驱 自动(化)', NULL, 4288, 0, NULL, 'J', 0, 5, 108662),
(53981, '4.0 加长型 四驱 手动(化)', NULL, 4288, 0, NULL, 'J', 0, 5, 108661),
(53980, '2021 4.0 四驱 手动', NULL, 4287, 0, NULL, 'J', 0, 5, 108663),
(53979, '213 2.5 手动(化)', NULL, 4286, 0, NULL, 'J', 0, 5, 108670),
(53978, '7250 2.5 两驱 手动(化)', NULL, 4286, 0, NULL, 'J', 0, 5, 106837),
(53977, '2021A6六缸4.0L', NULL, 4286, 0, NULL, 'J', 0, 5, 6855),
(53976, '7250两驱化油器', NULL, 4286, 0, NULL, 'J', 0, 5, 6853),
(53975, '2021四驱化油器', NULL, 4286, 0, NULL, 'J', 0, 5, 6852),
(53974, '7250E电喷四驱', NULL, 4285, 0, NULL, 'J', 0, 5, 6854),
(53973, '2.5 四驱 手动', NULL, 4284, 0, NULL, 'J', 0, 5, 108667),
(53972, '吉普之星2.5 四驱 手动', NULL, 4284, 0, NULL, 'J', 0, 5, 108666),
(53971, '2.5 加长型 两驱 手动(化)', NULL, 4284, 0, NULL, 'J', 0, 5, 108665),
(53970, '4.0 四驱 手动(化)', NULL, 4284, 0, NULL, 'J', 0, 5, 108664),
(53969, '顺途 2.5 两驱 手动BJ6420E', NULL, 4284, 0, NULL, 'J', 0, 5, 106835),
(53968, '超级切诺基7250 2.5 手动 两驱', NULL, 4283, 0, NULL, 'J', 0, 5, 108669),
(53967, '超级切诺基2021 2.5 手动 四驱', NULL, 4283, 0, NULL, 'J', 0, 5, 108668),
(53966, '超级切诺基2021 4.0 自动 四驱BJ2021A6L', NULL, 4282, 0, NULL, 'J', 0, 5, 106836),
(53965, '2020 2.5 四驱 手动', NULL, 4281, 0, NULL, 'J', 0, 5, 108611),
(53964, '超级切诺基2021 4.0 手动 四驱BJ2021E6L', NULL, 4280, 0, NULL, 'J', 0, 5, 106834),
(53963, '超级切诺基7250 2.5 手动 两驱BJ7250EL', NULL, 4280, 0, NULL, 'J', 0, 5, 106833),
(53962, '顺途BJ6420E', NULL, 4280, 0, NULL, 'J', 0, 5, 37),
(53961, '超级切诺基BJ7250EL', NULL, 4280, 0, NULL, 'J', 0, 5, 36),
(53960, '超级切诺基BJ2021A6L', NULL, 4280, 0, NULL, 'J', 0, 5, 35),
(53959, '超级切诺基BJ2021EL', NULL, 4280, 0, NULL, 'J', 0, 5, 34),
(53958, '超级切诺基BJ2021E6L', NULL, 4280, 0, NULL, 'J', 0, 5, 33),
(53957, '4000 豪华型', NULL, 4279, 0, NULL, 'J', 0, 5, 8),
(53956, '4000 舒适型', NULL, 4279, 0, NULL, 'J', 0, 5, 7),
(53955, '4700 4.7 自动 四驱', NULL, 4278, 0, NULL, 'J', 0, 5, 108604),
(53954, '4000 4.0 自动 四驱', NULL, 4277, 0, NULL, 'J', 0, 5, 108603),
(53953, '4000 4.0 自动 四驱', NULL, 4276, 0, NULL, 'J', 0, 5, 108607),
(53952, '4700 4.7 自动 四驱', NULL, 4276, 0, NULL, 'J', 0, 5, 108605),
(53951, '4000 征程', NULL, 4275, 0, NULL, 'J', 0, 5, 10),
(53950, '4700 征途', NULL, 4275, 0, NULL, 'J', 0, 5, 9),
(53949, '4700 4.7 自动 四驱', NULL, 4274, 0, NULL, 'J', 0, 5, 108606),
(53948, '4700 4.7 征途 自动 四驱', NULL, 4274, 0, NULL, 'J', 0, 5, 106832),
(53947, '4000 4.0 征程 自动 四驱', NULL, 4274, 0, NULL, 'J', 0, 5, 106831),
(53946, '4.0L四驱', NULL, 4273, 0, NULL, 'J', 0, 5, 108610),
(53945, '2.5L四驱', NULL, 4273, 0, NULL, 'J', 0, 5, 106829),
(53944, '2.5L两驱', NULL, 4273, 0, NULL, 'J', 0, 5, 106828),
(53943, '2500 2.5L四驱', NULL, 4272, 0, NULL, 'J', 0, 5, 26),
(53942, '2500 2.5L两驱', NULL, 4272, 0, NULL, 'J', 0, 5, 25),
(53941, '2.4L两驱', NULL, 4271, 0, NULL, 'J', 0, 5, 106830),
(53940, '2700 2.7L四驱', NULL, 4271, 0, NULL, 'J', 0, 5, 30),
(53939, '2500 2.4L两驱', NULL, 4271, 0, NULL, 'J', 0, 5, 29),
(53938, '2500 2.5L四驱', NULL, 4271, 0, NULL, 'J', 0, 5, 28),
(53937, '2500 2.5L两驱', NULL, 4271, 0, NULL, 'J', 0, 5, 27),
(53936, '哈弗派商务版四驱CC6590SW21', NULL, 4270, 0, NULL, 'H', 0, 5, 5774),
(53935, '哈弗派商务版两驱CC6590SW01', NULL, 4270, 0, NULL, 'H', 0, 5, 5773),
(53934, '哈弗·派时尚豪华型', NULL, 4270, 0, NULL, 'H', 0, 5, 545),
(53933, 'CC6672LB 豪华型', NULL, 4269, 0, NULL, 'H', 0, 5, 7943),
(53932, '两驱 智尊温馨版 CC6690KM09 ', NULL, 4268, 0, NULL, 'H', 0, 5, 100661),
(53931, '2.4L 手动 两驱 时尚豪华型 ', NULL, 4267, 0, NULL, 'H', 0, 5, 106516),
(53930, '4×2 精英型', NULL, 4266, 0, NULL, 'H', 0, 5, 9369),
(53929, '4×2 豪华型', NULL, 4266, 0, NULL, 'H', 0, 5, 9368),
(53928, '4×2 舒适型', NULL, 4266, 0, NULL, 'H', 0, 5, 9364),
(53927, '4×4 尊贵型', NULL, 4265, 0, NULL, 'H', 0, 5, 10181),
(53926, '4×2 尊贵型', NULL, 4265, 0, NULL, 'H', 0, 5, 10173),
(53925, '4×4 精英型', NULL, 4265, 0, NULL, 'H', 0, 5, 9371),
(53924, '4×4 豪华型', NULL, 4265, 0, NULL, 'H', 0, 5, 9370),
(53923, '4×4 舒适型', NULL, 4265, 0, NULL, 'H', 0, 5, 9367),
(53922, '2.0T 自动 四驱 豪华型', NULL, 4264, 0, NULL, 'H', 0, 5, 106199),
(53921, '2.0T 自动 四驱 标准型', NULL, 4264, 0, NULL, 'H', 0, 5, 106198),
(53920, '2.0T 自动 两驱 豪华型 ', NULL, 4264, 0, NULL, 'H', 0, 5, 106193),
(53919, '2.0T 自动 两驱 标准型 ', NULL, 4264, 0, NULL, 'H', 0, 5, 106184),
(53918, '2.0L 手动 两驱 精英型 ', NULL, 4263, 0, NULL, 'H', 0, 5, 105811),
(53917, '2.0L 手动 两驱 尊贵型 ', NULL, 4263, 0, NULL, 'H', 0, 5, 105810),
(53916, '绿静 2.0T 手动 两驱 尊贵型 柴油', NULL, 4263, 0, NULL, 'H', 0, 5, 14596),
(53915, '绿静 2.0T 手动 两驱 精英型 柴油', NULL, 4263, 0, NULL, 'H', 0, 5, 14595),
(53914, '2.0L 手动 两驱 尊贵型 汽油', NULL, 4263, 0, NULL, 'H', 0, 5, 14593),
(53913, '2.0L 手动 两驱 精英型 汽油', NULL, 4263, 0, NULL, 'H', 0, 5, 14592),
(53912, '2.0L 手动 两驱 都市型 汽油', NULL, 4263, 0, NULL, 'H', 0, 5, 14565),
(53911, '绿静 2.0T 手动 两驱 都市型 柴油 ', NULL, 4263, 0, NULL, 'H', 0, 5, 13701),
(53910, '1.5T 手动 两驱 尊贵型 ', NULL, 4262, 0, NULL, 'H', 0, 5, 102169),
(53909, '1.5T 手动 两驱 精英型 ', NULL, 4262, 0, NULL, 'H', 0, 5, 102168),
(53908, '1.5T 手动 两驱 都市型', NULL, 4262, 0, NULL, 'H', 0, 5, 102167),
(53907, '绿静 2.0T 手动 四驱 尊贵型', NULL, 4262, 0, NULL, 'H', 0, 5, 101819),
(53906, '绿静 2.0T 手动 四驱 精英型', NULL, 4262, 0, NULL, 'H', 0, 5, 101818),
(53905, '绿静 2.0T 手动 四驱 都市型', NULL, 4262, 0, NULL, 'H', 0, 5, 101817),
(53904, '2.4L 手动 两驱 都市型 汽油', NULL, 4262, 0, NULL, 'H', 0, 5, 101517),
(53903, '2.4L 手动 两驱 尊贵型 汽油', NULL, 4262, 0, NULL, 'H', 0, 5, 101516),
(53902, '2.4L 手动 两驱 精英型 汽油', NULL, 4262, 0, NULL, 'H', 0, 5, 101515),
(53901, '2.4L 自动 两驱 精英型 汽油', NULL, 4262, 0, NULL, 'H', 0, 5, 100311),
(53900, '2.4L 自动 两驱 尊贵型 汽油', NULL, 4262, 0, NULL, 'H', 0, 5, 100309),
(53899, '运动版 2.4L 自动 两驱 精英型', NULL, 4261, 0, NULL, 'H', 0, 5, 106487),
(53898, '运动版 2.4L 自动 两驱 尊贵型', NULL, 4261, 0, NULL, 'H', 0, 5, 106486),
(53897, '升级版 2.4L 自动 两驱 精英型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105826),
(53896, '升级版 2.4L 自动 两驱 尊贵型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105824),
(53895, '升级版 1.5T 手动 四驱 尊贵型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105822),
(53894, '升级版 1.5T 手动 四驱 精英型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105821),
(53893, '升级版 1.5T 手动 两驱 精英型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105820);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(53892, '绿静 2.0T 手动 四驱 尊贵型  柴油 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105819),
(53891, '绿静 2.0T 手动 四驱 精英型  柴油 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105818),
(53890, '绿静 2.0T 手动 四驱 都市型  柴油 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105817),
(53889, '绿静 2.0T 手动 两驱 尊贵型 柴油 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105816),
(53888, '绿静 2.0T 手动 两驱 精英型 柴油 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105815),
(53887, '绿静 2.0T 手动 两驱 都市型 柴油', NULL, 4261, 0, NULL, 'H', 0, 5, 105814),
(53886, '2.4L 自动 两驱 尊贵型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105813),
(53885, '2.4L 自动 两驱 精英型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105812),
(53884, '升级版 1.5T 手动 两驱 尊贵型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 105021),
(53883, '1.5T 手动 两驱 越级型', NULL, 4261, 0, NULL, 'H', 0, 5, 104458),
(53882, '1.5T 手动 四驱 尊贵型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 103386),
(53881, '1.5T 手动 四驱 精英型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 103385),
(53880, '1.5T 手动 四驱 都市型 ', NULL, 4261, 0, NULL, 'H', 0, 5, 103382),
(53879, '运动版 2.0T 手动 四驱 尊贵型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110258),
(53878, '运动版 2.0T 手动 四驱 精英型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110257),
(53877, '运动版 2.0T 手动 四驱 都市型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110256),
(53876, '运动版 2.0T 手动 两驱 尊贵型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110254),
(53875, '运动版 2.0T 手动 两驱 精英型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110253),
(53874, '运动版 2.0T 手动 两驱 都市型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 110252),
(53873, '升级版 2.0T 手动 四驱 尊贵型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 106496),
(53872, '升级版 2.0T 手动 四驱 精英型  柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 106495),
(53871, '升级版 2.0T 手动 四驱 都市型 柴油 ', NULL, 4260, 0, NULL, 'H', 0, 5, 106494),
(53870, '升级版 2.0T 手动  两驱 尊贵型 柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 106493),
(53869, '升级版 2.0T 手动 两驱 精英型 柴油 ', NULL, 4260, 0, NULL, 'H', 0, 5, 106492),
(53868, '升级版 2.0T 手动 两驱 都市型  柴油', NULL, 4260, 0, NULL, 'H', 0, 5, 106488),
(53867, '运动版 1.5T 手动 四驱 都市型', NULL, 4260, 0, NULL, 'H', 0, 5, 106461),
(53866, '运动版 1.5T 手动 四驱 精英型', NULL, 4260, 0, NULL, 'H', 0, 5, 106460),
(53865, '运动版 1.5T 手动 四驱 尊贵型', NULL, 4260, 0, NULL, 'H', 0, 5, 106459),
(53864, '运动版 1.5T 手动 两驱 尊贵型', NULL, 4260, 0, NULL, 'H', 0, 5, 105209),
(53863, '运动版 1.5T 手动 两驱 精英型', NULL, 4260, 0, NULL, 'H', 0, 5, 105208),
(53862, '运动版 1.5T 手动 两驱 都市型', NULL, 4260, 0, NULL, 'H', 0, 5, 105205),
(53861, '智尊版 2.5TCI 两驱 超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11931),
(53860, '智尊版 2.5TCI 两驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 11930),
(53859, '智尊版 2.5TCI 两驱 舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 11929),
(53858, '智尊版 2.4 四驱 超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11928),
(53857, '智尊版 2.4 四驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 11927),
(53856, '智尊版 2.4 四驱 舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 11926),
(53855, '欧风版 2.0 两驱 天窗型', NULL, 4259, 0, NULL, 'H', 0, 5, 11865),
(53854, '欧风版 2.0 两驱 精英型', NULL, 4259, 0, NULL, 'H', 0, 5, 11864),
(53853, '欧风版 2.0 两驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 11863),
(53852, '智尊版 2.5TCI四驱超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11829),
(53851, '智尊版 2.5TCI四驱豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 11828),
(53850, '智尊版 2.5TCI四驱舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 11827),
(53849, '智尊版 2.4 两驱 超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11826),
(53848, '智尊版 2.4 两驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 11825),
(53847, '智尊版 2.4 两驱 舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 11824),
(53846, '欧风版 2.5TCI四驱超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11207),
(53845, '欧风版 2.5TCI 两驱 超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11206),
(53844, '欧风版 2.4四驱超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11205),
(53843, '欧风版 2.4 两驱 超豪华', NULL, 4259, 0, NULL, 'H', 0, 5, 11204),
(53842, '欧风版 2.4四驱豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 10998),
(53841, '欧风版 2.4 两驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 10997),
(53840, '欧风版 2.5TCI四驱豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 10996),
(53839, '欧风版 2.5TCI 两驱 豪华型', NULL, 4259, 0, NULL, 'H', 0, 5, 10995),
(53838, '欧风版 2.4四驱舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 10994),
(53837, '欧风版 2.4 两驱 舒适型', NULL, 4259, 0, NULL, 'H', 0, 5, 10991),
(53836, '绿静 自动 四驱 2.0 超豪华型  柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12642),
(53835, '绿静 2.0 自动 四驱 豪华型 柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12641),
(53834, '绿静 2.0 自动 四驱 舒适型 柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12640),
(53833, '绿静 2.0 自动 两驱 超豪华型 柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12639),
(53832, '绿静 2.0 自动 两驱 豪华型 柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12638),
(53831, '绿静 2.0 自动 两驱 舒适型 柴油', NULL, 4258, 0, NULL, 'H', 0, 5, 12637),
(53830, '智尊版 2.4 四驱 超豪华差速版', NULL, 4258, 0, NULL, 'H', 0, 5, 12404),
(53829, '智尊版 2.4 两驱 超豪华差速版', NULL, 4258, 0, NULL, 'H', 0, 5, 12403),
(53828, '智尊版 2.4 四驱 豪华型差速版', NULL, 4258, 0, NULL, 'H', 0, 5, 12402),
(53827, '智尊版 2.4 两驱 豪华型差速版', NULL, 4258, 0, NULL, 'H', 0, 5, 12401),
(53826, '欧风版 绿静 2.0T 四驱 超豪华', NULL, 4258, 0, NULL, 'H', 0, 5, 12182),
(53825, '欧风版 绿静 2.0T 四驱 豪华型', NULL, 4258, 0, NULL, 'H', 0, 5, 12181),
(53824, '欧风版 绿静 2.0T 四驱 舒适型', NULL, 4258, 0, NULL, 'H', 0, 5, 12180),
(53823, '欧风版 绿静2.0T 两驱 超豪华', NULL, 4258, 0, NULL, 'H', 0, 5, 12178),
(53822, '欧风版 绿静 2.0T 两驱 豪华型', NULL, 4258, 0, NULL, 'H', 0, 5, 12177),
(53821, '欧风版 绿静 2.0T 两驱 舒适型', NULL, 4258, 0, NULL, 'H', 0, 5, 12176),
(53820, '智尊版 2.0 两驱 天窗版', NULL, 4258, 0, NULL, 'H', 0, 5, 12175),
(53819, '智尊版 2.0 两驱 精英型', NULL, 4258, 0, NULL, 'H', 0, 5, 12174),
(53818, '智尊版 2.0 两驱 豪华型', NULL, 4258, 0, NULL, 'H', 0, 5, 12173),
(53817, '智尊版 2.4L 手动 四驱 舒适型 汽油版', NULL, 4257, 0, NULL, 'H', 0, 5, 106069),
(53816, '智尊版 2.4L 四驱 领航版', NULL, 4257, 0, NULL, 'H', 0, 5, 104017),
(53815, '欧风版 2.0 两驱 导航版', NULL, 4257, 0, NULL, 'H', 0, 5, 102846),
(53814, '2.5TCI 两驱 冠军版', NULL, 4257, 0, NULL, 'H', 0, 5, 16393),
(53813, '智尊版 绿静 2.0T 自动 四驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 15588),
(53812, '智尊版 绿静 2.0T 自动 四驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 15587),
(53811, '智尊版 绿静 2.0T 自动 四驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 15586),
(53810, '智尊版 绿静 2.0T 自动 两驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 15585),
(53809, '智尊版 绿静 2.0T 自动 两驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 15584),
(53808, '智尊版 绿静 2.0T 自动 两驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 15583),
(53807, '智尊版 绿静 2.0T 手动 四驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 15582),
(53806, '智尊版 绿静 2.0T 手动 两驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 15581),
(53805, '欧风版 绿静 2.0T 自动 四驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14363),
(53804, '欧风版 绿静 2.0T 自动 四驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14362),
(53803, '欧风版 绿静 2.0T 自动 四驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14361),
(53802, '欧风版 绿静 2.0T 自动 两驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14360),
(53801, '欧风版 绿静 2.0T 自动 两驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14359),
(53800, '欧风版 绿静 2.0T 自动 两驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14358),
(53799, '欧风版 绿静 2.0T 手动 四驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14357),
(53798, '欧风版 绿静 2.0T 手动 两驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14356),
(53797, '欧风版 2.4 四驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14355),
(53796, '欧风版 2.4 四驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14354),
(53795, '欧风版 2.4 四驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14353),
(53794, '欧风版 2.4 两驱 超豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14352),
(53793, '欧风版 2.4 两驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14350),
(53792, '欧风版 2.4 两驱 舒适型', NULL, 4257, 0, NULL, 'H', 0, 5, 14349),
(53791, '欧风版 2.0 两驱 天窗型', NULL, 4257, 0, NULL, 'H', 0, 5, 14348),
(53790, '欧风版 2.0 两驱 精英型', NULL, 4257, 0, NULL, 'H', 0, 5, 14347),
(53789, '欧风版 2.0 两驱 豪华型', NULL, 4257, 0, NULL, 'H', 0, 5, 14346),
(53788, '欧风版 2.0 两驱 进取型', NULL, 4256, 0, NULL, 'H', 0, 5, 106518),
(53787, '智尊版 2.0T 手动 四驱 进取型 柴油版', NULL, 4256, 0, NULL, 'H', 0, 5, 105297),
(53786, '智尊版 2.0T 手动 两驱 进取型 柴油版', NULL, 4256, 0, NULL, 'H', 0, 5, 105296),
(53785, '智尊版 2.0L 手动 四驱 进取型 汽油版', NULL, 4256, 0, NULL, 'H', 0, 5, 105295),
(53784, '智尊版 2.0L 手动 两驱 进取型 汽油版', NULL, 4256, 0, NULL, 'H', 0, 5, 105294),
(53783, '智尊版 2.0T 手动 两驱 进取型', NULL, 4256, 0, NULL, 'H', 0, 5, 104446),
(53782, '智尊版 2.0T 手动 两驱 精英型', NULL, 4256, 0, NULL, 'H', 0, 5, 104445),
(53781, '智尊版 2.0T 手动 两驱 尊贵型', NULL, 4256, 0, NULL, 'H', 0, 5, 104444),
(53780, '智尊版 2.0T 手动 四驱 进取型', NULL, 4256, 0, NULL, 'H', 0, 5, 104443),
(53779, '智尊版 2.0T 手动 四驱 精英型', NULL, 4256, 0, NULL, 'H', 0, 5, 104442),
(53778, '智尊版 2.0T 手动 四驱 尊贵型', NULL, 4256, 0, NULL, 'H', 0, 5, 104434),
(53777, 'B3 四驱超豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 544),
(53776, 'B3 四驱豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 543),
(53775, 'B3 两驱超豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 542),
(53774, 'B3 两驱豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 541),
(53773, 'CUV 四驱精品型', NULL, 4255, 0, NULL, 'H', 0, 5, 540),
(53772, 'CUV 两驱精品型', NULL, 4255, 0, NULL, 'H', 0, 5, 539),
(53771, '汽油版两驱超豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 537),
(53770, '汽油版四驱豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 536),
(53769, '汽油版四驱超豪华型', NULL, 4255, 0, NULL, 'H', 0, 5, 535),
(53768, '领先版 柴油 两驱 舒适', NULL, 4254, 0, NULL, 'H', 0, 5, 9975),
(53767, '领先版 柴油 四驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 8489),
(53766, '领先版 柴油 四驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 8488),
(53765, '领先版 柴油 两驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 8487),
(53764, '领先版 柴油 两驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 8486),
(53763, '锐意版 天窗型', NULL, 4254, 0, NULL, 'H', 0, 5, 8256),
(53762, '锐意版 精英型', NULL, 4254, 0, NULL, 'H', 0, 5, 8255),
(53761, '锐意版 豪华型', NULL, 4254, 0, NULL, 'H', 0, 5, 8254),
(53760, '2.8TCI 柴油 四驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5648),
(53759, '2.8TCI 柴油 四驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5647),
(53758, '2.8TCI 柴油 两驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5646),
(53757, '2.8TCI 柴油 两驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5645),
(53756, '领先版 汽油 四驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5315),
(53755, '领先版 汽油 四驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5312),
(53754, '领先版 汽油 两驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5310),
(53753, '领先版 汽油 两驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5308),
(53752, '三菱4G64 汽油 四驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5306),
(53751, '三菱4G64 汽油 四驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5305),
(53750, '三菱4G64 汽油 两驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5304),
(53749, '三菱4G64 汽油 两驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 5303),
(53748, '2.8TC 柴油 四驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 549),
(53747, '2.8TC 柴油 四驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 548),
(53746, '2.8TC 柴油 两驱 超豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 547),
(53745, '2.8TC 柴油 两驱 豪华', NULL, 4254, 0, NULL, 'H', 0, 5, 546),
(53744, '领先版 柴油版 四驱 舒适', NULL, 4253, 0, NULL, 'H', 0, 5, 15580),
(53743, '锐意版 2.0L 手动 天窗版', NULL, 4253, 0, NULL, 'H', 0, 5, 11482),
(53742, '锐意版 2.0L 手动 精英型', NULL, 4253, 0, NULL, 'H', 0, 5, 11481),
(53741, '锐意版 2.0L 手动 豪华型', NULL, 4253, 0, NULL, 'H', 0, 5, 11480),
(53740, '领先版 四驱 超豪华 柴油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11479),
(53739, '领先版 四驱 豪华 柴油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11478),
(53738, '领先版 两驱 超豪华 柴油版 ', NULL, 4253, 0, NULL, 'H', 0, 5, 11477),
(53737, '领先版 两驱 豪华 柴油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11476),
(53736, '领先版 四驱 超豪华 汽油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11475),
(53735, '领先版 四驱 豪华 汽油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11474),
(53734, '领先版 两驱 超豪华 汽油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11473),
(53733, '领先版 两驱 豪华 汽油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11472),
(53732, '领先版 两驱 舒适 柴油版', NULL, 4253, 0, NULL, 'H', 0, 5, 11471),
(53731, '锐意版 2.0L 四驱版', NULL, 4252, 0, NULL, 'H', 0, 5, 101212),
(53730, '锐意版 2.0 两驱 导航版', NULL, 4252, 0, NULL, 'H', 0, 5, 101211),
(53729, '锐意版 2.0L 两驱 豪华型', NULL, 4252, 0, NULL, 'H', 0, 5, 101210),
(53728, '2.5TCI 两驱 冠军版', NULL, 4252, 0, NULL, 'H', 0, 5, 16390),
(53727, '1.5T 手动 两驱 尊贵型', NULL, 4251, 0, NULL, 'H', 0, 5, 106329),
(53726, '1.5T 手动 两驱 精英型', NULL, 4251, 0, NULL, 'H', 0, 5, 106328),
(53725, '1.5T 手动 两驱 都市型', NULL, 4251, 0, NULL, 'H', 0, 5, 106327),
(53724, '1.5T 手动 四驱 都市型', NULL, 4251, 0, NULL, 'H', 0, 5, 106326),
(53723, '1.5T 手动 四驱 精英型', NULL, 4251, 0, NULL, 'H', 0, 5, 106325),
(53722, '1.5T 手动 四驱 尊贵型', NULL, 4251, 0, NULL, 'H', 0, 5, 106324),
(53721, '2.2L 手动 两驱 商务版 国IV', NULL, 4250, 0, NULL, 'H', 0, 5, 104870),
(53720, '2.2L 手动 两驱 智尊版 国IV', NULL, 4250, 0, NULL, 'H', 0, 5, 104869),
(53719, '2.4L 手动 两驱 商务版 欧IV', NULL, 4250, 0, NULL, 'H', 0, 5, 104868),
(53718, '2.4L 手动 两驱 智尊版 欧IV', NULL, 4250, 0, NULL, 'H', 0, 5, 104867),
(53717, '2.8L 手动 两驱 商务版 国III', NULL, 4250, 0, NULL, 'H', 0, 5, 104866),
(53716, '2.8L 手动 两驱 智尊版 国III', NULL, 4250, 0, NULL, 'H', 0, 5, 104861),
(53715, '2.8L 手动 两驱 精英版 柴油版 国3', NULL, 4249, 0, NULL, 'H', 0, 5, 105035),
(53714, '2.8L 手动 两驱 商务版 柴油版 国3', NULL, 4249, 0, NULL, 'H', 0, 5, 105034),
(53713, '2.8L 手动 四驱 商务版 柴油版 国3', NULL, 4249, 0, NULL, 'H', 0, 5, 105033),
(53712, '2.4L 手动 两驱 商务版 汽油版 欧4', NULL, 4249, 0, NULL, 'H', 0, 5, 105032),
(53711, '2.4L 手动 四驱 商务版 汽油版 欧4', NULL, 4249, 0, NULL, 'H', 0, 5, 105031),
(53710, '2.2L 手动 两驱 商务版 汽油版 国4', NULL, 4249, 0, NULL, 'H', 0, 5, 101387),
(53709, '2.2L 手动 四驱 商务版 汽油版 国4', NULL, 4249, 0, NULL, 'H', 0, 5, 101386),
(53708, '手动 两驱 商务版 汽油版 大双 国四 ', NULL, 4248, 0, NULL, 'H', 0, 5, 101385),
(53707, '手动 两驱 商务版 柴油版 大双 国三 ', NULL, 4248, 0, NULL, 'H', 0, 5, 101384),
(53706, 'KLQ1020A3 单排', NULL, 4247, 0, NULL, 'H', 0, 5, 15224),
(53705, 'KLQ1030B4 大双', NULL, 4247, 0, NULL, 'H', 0, 5, 15223),
(53704, 'KLQ1020B0 标双', NULL, 4247, 0, NULL, 'H', 0, 5, 15220),
(53703, 'KLQ1020Q4 大双', NULL, 4247, 0, NULL, 'H', 0, 5, 15218),
(53702, 'KLQ1020Q0 标双', NULL, 4247, 0, NULL, 'H', 0, 5, 15216),
(53701, '2.4T 手动 单排4D25', NULL, 4246, 0, NULL, 'H', 0, 5, 105938),
(53700, '2.8T 手动 单排4JB1TI', NULL, 4246, 0, NULL, 'H', 0, 5, 105933),
(53699, '龙威 2.4L 手动 两驱 标准型  汽油 ', NULL, 4245, 0, NULL, 'H', 0, 5, 105955),
(53698, '2.4L 手动  四驱 标准型 龙威 汽油', NULL, 4245, 0, NULL, 'H', 0, 5, 105954),
(53697, '龙威 2.4L 手动 两驱 加长型 汽油 ', NULL, 4245, 0, NULL, 'H', 0, 5, 105953),
(53696, '2.4L 手动  四驱 加长型 龙威 汽油', NULL, 4245, 0, NULL, 'H', 0, 5, 105951),
(53695, '龙威 2.5T 手动 两驱 加长型 柴油 ', NULL, 4245, 0, NULL, 'H', 0, 5, 105950),
(53694, '龙威 2.5T 手动 两驱 标准型 柴油 ', NULL, 4245, 0, NULL, 'H', 0, 5, 105949),
(53693, '2.5T 手动  四驱 标准型 龙威 柴油', NULL, 4245, 0, NULL, 'H', 0, 5, 105948),
(53692, '2.5T 手动 四驱 加长型 龙威 柴油', NULL, 4245, 0, NULL, 'H', 0, 5, 105941),
(53691, 'H5V 多功能型 2.8L 手动 经典型', NULL, 4244, 0, NULL, 'H', 0, 5, 106148),
(53690, 'H5V 团体版 2.8L 手动 豪华型', NULL, 4244, 0, NULL, 'H', 0, 5, 106147),
(53689, 'H5V 团体版 2.8L 手动 经典型', NULL, 4244, 0, NULL, 'H', 0, 5, 106146),
(53688, 'H5V 营运版 2.8L 手动 豪华型', NULL, 4244, 0, NULL, 'H', 0, 5, 106145),
(53687, 'H5V  营运版 2.8L 手动 经典型', NULL, 4244, 0, NULL, 'H', 0, 5, 106144),
(53686, 'H5C 商务版 2.4L 手动 豪华型 4G69S4N', NULL, 4243, 0, NULL, 'H', 0, 5, 106384),
(53685, 'H5C 商务版 2.4L 手动 豪华型 4RB2 ', NULL, 4243, 0, NULL, 'H', 0, 5, 106383),
(53684, 'H5C 商务版 2.4L 手动 舒适型 4G69S4N', NULL, 4243, 0, NULL, 'H', 0, 5, 106382),
(53683, 'H5C 商务版 2.4L 手动 舒适型 4RB2 ', NULL, 4243, 0, NULL, 'H', 0, 5, 106381),
(53682, 'H5C 营运版 2.4L 手动 豪华型 4RB2 ', NULL, 4243, 0, NULL, 'H', 0, 5, 106168),
(53681, 'H5C 营运版 2.4L 手动 经典型 4G69S4N', NULL, 4243, 0, NULL, 'H', 0, 5, 106163),
(53680, 'H5C 团体版 2.4L 手动 豪华型', NULL, 4243, 0, NULL, 'H', 0, 5, 106157),
(53679, 'H5C 团体版 2.4L 手动 经典型', NULL, 4243, 0, NULL, 'H', 0, 5, 106155),
(53678, 'H5C 营运版 2.4L 手动 豪华型 4G69S4N', NULL, 4243, 0, NULL, 'H', 0, 5, 106154),
(53677, 'H5C 营运版 2.4L 手动 经典型 4RB2', NULL, 4243, 0, NULL, 'H', 0, 5, 106149),
(53676, '豪华型', NULL, 4242, 0, NULL, 'H', 0, 5, 11872),
(53675, '标准型', NULL, 4242, 0, NULL, 'H', 0, 5, 11871),
(53674, '实用型', NULL, 4242, 0, NULL, 'H', 0, 5, 11870),
(53673, '1.0L 精英型', NULL, 4241, 0, NULL, 'H', 0, 5, 10889),
(53672, '1.0L 进取型', NULL, 4241, 0, NULL, 'H', 0, 5, 10888),
(53671, '1.0L 标准型', NULL, 4241, 0, NULL, 'H', 0, 5, 10887),
(53670, '1.0L 实力型', NULL, 4241, 0, NULL, 'H', 0, 5, 10886),
(53669, '豪华型', NULL, 4240, 0, NULL, 'H', 0, 5, 12801),
(53668, '舒适型', NULL, 4240, 0, NULL, 'H', 0, 5, 12800),
(53667, '基本型', NULL, 4240, 0, NULL, 'H', 0, 5, 12799),
(53666, '经济型', NULL, 4240, 0, NULL, 'H', 0, 5, 12798),
(53665, '1.0L 手动 豪华型', NULL, 4239, 0, NULL, 'H', 0, 5, 16389),
(53664, '1.0L 手动 舒适型', NULL, 4239, 0, NULL, 'H', 0, 5, 16388),
(53663, '1.0L 手动 标准型', NULL, 4239, 0, NULL, 'H', 0, 5, 16387),
(53662, '1.0L 手动 基本型', NULL, 4239, 0, NULL, 'H', 0, 5, 16384),
(53661, '实用型', NULL, 4238, 0, NULL, 'H', 0, 5, 104524),
(53660, '1.0L 实用型 5座', NULL, 4237, 0, NULL, 'H', 0, 5, 100225),
(53659, '1.0L 实用型 7座', NULL, 4237, 0, NULL, 'H', 0, 5, 100224),
(53658, '1.0L 实用型 8座', NULL, 4237, 0, NULL, 'H', 0, 5, 100223),
(53657, '1.2L 标准型 8座', NULL, 4237, 0, NULL, 'H', 0, 5, 100221),
(53656, '1.2L 标准型 7座', NULL, 4237, 0, NULL, 'H', 0, 5, 100220),
(53655, '1.2L 豪华型 7座', NULL, 4237, 0, NULL, 'H', 0, 5, 100219),
(53654, '1.2L 豪华型 8座', NULL, 4237, 0, NULL, 'H', 0, 5, 100218),
(53653, '1.2L 手动 旗舰型', NULL, 4236, 0, NULL, 'H', 0, 5, 101653),
(53652, '1.2L 手动 豪华型', NULL, 4236, 0, NULL, 'H', 0, 5, 101652),
(53651, '1.2L 手动 舒适型', NULL, 4236, 0, NULL, 'H', 0, 5, 101651),
(53650, '1.2L 手动 标准型', NULL, 4236, 0, NULL, 'H', 0, 5, 101650),
(53649, '1.2L 手动 标准型', NULL, 4235, 0, NULL, 'H', 0, 5, 111125),
(53648, '1.2L 手动 豪华型', NULL, 4235, 0, NULL, 'H', 0, 5, 111124),
(53647, '超值版', NULL, 4234, 0, NULL, 'H', 0, 5, 14514),
(53646, '实用型', NULL, 4234, 0, NULL, 'H', 0, 5, 11643),
(53645, '豪华型', NULL, 4234, 0, NULL, 'H', 0, 5, 8741),
(53644, '舒适型(无空调)', NULL, 4234, 0, NULL, 'H', 0, 5, 8740),
(53643, '标准型(无空调)', NULL, 4234, 0, NULL, 'H', 0, 5, 8739),
(53642, '超值版', NULL, 4234, 0, NULL, 'H', 0, 5, 14514),
(53641, '实用型', NULL, 4234, 0, NULL, 'H', 0, 5, 11643),
(53640, '豪华型', NULL, 4234, 0, NULL, 'H', 0, 5, 8741),
(53639, '舒适型(无空调)', NULL, 4234, 0, NULL, 'H', 0, 5, 8740),
(53638, '标准型(无空调)', NULL, 4234, 0, NULL, 'H', 0, 5, 8739),
(53637, '单排 基本型', NULL, 4233, 0, NULL, 'H', 0, 5, 104528),
(53636, '单排 加长版', NULL, 4233, 0, NULL, 'H', 0, 5, 104527),
(53635, '双排 基本型', NULL, 4233, 0, NULL, 'H', 0, 5, 104526),
(53634, '双排 加长版', NULL, 4233, 0, NULL, 'H', 0, 5, 104525),
(53633, 'BHQ6376B', NULL, 4232, 0, NULL, 'H', 0, 5, 6974),
(53632, 'BHQ6361B', NULL, 4232, 0, NULL, 'H', 0, 5, 6973),
(53631, '1.6L 手动两驱', NULL, 4231, 0, NULL, 'H', 0, 5, 10642),
(53630, '1.6L 四门(500公斤)', NULL, 4230, 0, NULL, 'H', 0, 5, 10641),
(53629, '1.8L 四门(500公斤)', NULL, 4230, 0, NULL, 'H', 0, 5, 10640),
(53628, '2.0L 四门(500公斤)', NULL, 4230, 0, NULL, 'H', 0, 5, 10639),
(53627, '2.2L 四门(500公斤)', NULL, 4230, 0, NULL, 'H', 0, 5, 10638),
(53626, 'SM6491', NULL, 4229, 0, NULL, 'H', 0, 5, 6565),
(53625, 'SFJ 6370D', NULL, 4228, 0, NULL, 'H', 0, 5, 6560),
(53624, '3.5V6 自动', NULL, 4227, 0, NULL, 'H', 0, 5, 5526),
(53623, '2.5TCI 4x4 手动', NULL, 4227, 0, NULL, 'H', 0, 5, 5522),
(53622, '2.5TCI 4x2 手动', NULL, 4227, 0, NULL, 'H', 0, 5, 4570),
(53621, '2.9CRDi 自动', NULL, 4226, 0, NULL, 'H', 0, 5, 5524),
(53620, '2.5TCI 4x4 自动', NULL, 4226, 0, NULL, 'H', 0, 5, 5523),
(53619, '2.9CRDi 手动', NULL, 4226, 0, NULL, 'H', 0, 5, 4572),
(53618, '2.4MPI 四驱手动豪华型', NULL, 4225, 0, NULL, 'H', 0, 5, 8312),
(53617, '2.4MPI 两驱手动豪华型', NULL, 4225, 0, NULL, 'H', 0, 5, 5546),
(53616, '3.5V6 手动', NULL, 4225, 0, NULL, 'H', 0, 5, 5525),
(53615, '2.4L 两驱手动珍藏版', NULL, 4224, 0, NULL, 'H', 0, 5, 8926),
(53614, '2.4L四驱豪华型(欧四)', NULL, 4224, 0, NULL, 'H', 0, 5, 5547),
(53613, '2.4L两驱豪华型(欧四)', NULL, 4224, 0, NULL, 'H', 0, 5, 4568),
(53612, 'T9 2.4L汽油手动四驱豪华版', NULL, 4223, 0, NULL, 'H', 0, 5, 9734),
(53611, 'T9 2.4L汽油手动两驱豪华版', NULL, 4223, 0, NULL, 'H', 0, 5, 9733),
(53610, 'T9 2.4L 手动 四驱 豪华版 汽油', NULL, 4222, 0, NULL, 'H', 0, 5, 106594),
(53609, 'T9 2.4L 手动 两驱 豪华版 汽油', NULL, 4222, 0, NULL, 'H', 0, 5, 106592),
(53608, '2.0 L CRDi VGT 柴油四驱手动档 尊贵版', NULL, 4221, 0, NULL, 'H', 0, 5, 8920),
(53607, '2.0 L CRDi VGT 柴油四驱手动档 舒适版', NULL, 4221, 0, NULL, 'H', 0, 5, 8919),
(53606, '2.0 L CRDi VGT 柴油两驱手动档 舒适版', NULL, 4221, 0, NULL, 'H', 0, 5, 7517),
(53605, '2.0 L CRDi VGT 柴油两驱手动档 豪华版', NULL, 4221, 0, NULL, 'H', 0, 5, 7516),
(53604, '2.7LV6 汽油四驱自动档 豪华 国Ⅲ', NULL, 4221, 0, NULL, 'H', 0, 5, 7139),
(53603, '2.7LV6 汽油四驱自动档 标准 国Ⅲ', NULL, 4221, 0, NULL, 'H', 0, 5, 5532),
(53602, '2.7LV6 汽油四驱自动档 豪华 国Ⅳ', NULL, 4221, 0, NULL, 'H', 0, 5, 5530),
(53601, '2.0 L CRDi VGT 柴油四驱自动档 豪华', NULL, 4221, 0, NULL, 'H', 0, 5, 5528),
(53600, '2.0 L CRDi VGT 柴油四驱自动档 标准', NULL, 4221, 0, NULL, 'H', 0, 5, 4564),
(53599, '2.7L汽油四驱手自一体   金领型', NULL, 4220, 0, NULL, 'H', 0, 5, 8008),
(53598, '2.0T金钻型 柴油四驱手自一体', NULL, 4219, 0, NULL, 'H', 0, 5, 8925),
(53597, '2.0T商务型 柴油四驱手自一体', NULL, 4219, 0, NULL, 'H', 0, 5, 8924),
(53596, '2.0T金领型 柴油四驱手自一体', NULL, 4219, 0, NULL, 'H', 0, 5, 8923),
(53595, '2.0T公务型 柴油四驱手自一体', NULL, 4219, 0, NULL, 'H', 0, 5, 8922),
(53594, '2.0T舒适型 柴油四驱手自一体', NULL, 4219, 0, NULL, 'H', 0, 5, 8921),
(53593, '1.8T 汽油两驱手动挡 标准 国三', NULL, 4219, 0, NULL, 'H', 0, 5, 8775),
(53592, '1.8T 汽油两驱手动挡 豪华 国Ⅲ', NULL, 4219, 0, NULL, 'H', 0, 5, 8311),
(53591, '1.8T 汽油两驱手动挡 豪华 国Ⅳ', NULL, 4219, 0, NULL, 'H', 0, 5, 5442),
(53590, '2.7L 自动 四驱 豪华型 汽油', NULL, 4218, 0, NULL, 'H', 0, 5, 14893),
(53589, '2.7L 自动 四驱 标准型 汽油', NULL, 4218, 0, NULL, 'H', 0, 5, 14892),
(53588, '2.0L 手动挡 两驱 豪华版 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12096),
(53587, '2.0L 手动挡 两驱 舒适版2 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12095),
(53586, '2.0L 手动挡 两驱 舒适版1 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12094),
(53585, '2.0L 四驱 手动挡 豪华版 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12093),
(53584, '2.0L 手动挡 四驱 标准版 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12092),
(53583, '2.0L 自动档 四驱 豪华版 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12091),
(53582, '2.0L 自动档 四驱 标准版 柴油', NULL, 4218, 0, NULL, 'H', 0, 5, 12090),
(53581, 'C9 2.7L 自动 四驱 商务型  国三 汽油', NULL, 4218, 0, NULL, 'H', 0, 5, 11559),
(53580, 'C9 1.8L 手动 前驱 豪华版 汽油 国三', NULL, 4218, 0, NULL, 'H', 0, 5, 11558),
(53579, 'C9 1.8L 手动 前驱 舒适版 汽油 国三', NULL, 4218, 0, NULL, 'H', 0, 5, 11557),
(53578, 'C9 2.7L汽油自动四驱 商务型 国四', NULL, 4218, 0, NULL, 'H', 0, 5, 9311),
(53577, 'C9 1.8L 手动 前驱 豪华版 汽油 国四', NULL, 4218, 0, NULL, 'H', 0, 5, 9310),
(53576, 'C9 1.8L 手动 前驱 舒适版 汽油  国四', NULL, 4218, 0, NULL, 'H', 0, 5, 9309),
(53575, '1.8L 汽油两驱手动档 豪华版2', NULL, 4218, 0, NULL, 'H', 0, 5, 8917),
(53574, '1.8L 汽油两驱手动档 豪华版1', NULL, 4218, 0, NULL, 'H', 0, 5, 8916),
(53573, '2.0L 柴油四驱自动 标准版(天窗版)', NULL, 4218, 0, NULL, 'H', 0, 5, 8778),
(53572, '2.7L 汽油四驱自动档 标准型(天窗版)', NULL, 4218, 0, NULL, 'H', 0, 5, 8777),
(53571, '2.0L 柴油两驱手动档 标准版', NULL, 4218, 0, NULL, 'H', 0, 5, 8776),
(53570, '2.7L汽油四驱手自一体   金钻型', NULL, 4218, 0, NULL, 'H', 0, 5, 8010),
(53569, '2.7L汽油四驱手自一体   商务型', NULL, 4218, 0, NULL, 'H', 0, 5, 8009),
(53568, '2.7L汽油四驱手自一体  公务型', NULL, 4218, 0, NULL, 'H', 0, 5, 8007),
(53567, '2.7L 汽油四驱自动档  豪华版', NULL, 4218, 0, NULL, 'H', 0, 5, 8006),
(53566, '2.7L 汽油四驱自动档  标准版', NULL, 4218, 0, NULL, 'H', 0, 5, 8005),
(53565, '1.8L 汽油两驱手动档 标准版', NULL, 4218, 0, NULL, 'H', 0, 5, 5497),
(53564, 'C9 1.8T 汽油 AT 舒适版', NULL, 4217, 0, NULL, 'H', 0, 5, 15173),
(53563, 'C9 1.8T 汽油 AT 豪华版', NULL, 4217, 0, NULL, 'H', 0, 5, 12788),
(53562, '途悦 2.0 手动 尊贵型', NULL, 4217, 0, NULL, 'H', 0, 5, 12391),
(53561, '途悦 2.0 手动 豪华型', NULL, 4217, 0, NULL, 'H', 0, 5, 12390),
(53560, '途悦 2.0 手动 舒适型', NULL, 4217, 0, NULL, 'H', 0, 5, 12389),
(53559, 'C9 1.8T 手动 前驱 豪华版 汽油 国四', NULL, 4217, 0, NULL, 'H', 0, 5, 12102),
(53558, 'C9 1.8T 手动 前驱 舒适版 国四 汽油', NULL, 4217, 0, NULL, 'H', 0, 5, 12101),
(53557, 'C9 1.8T 手动 前驱 豪华版 汽油 国三', NULL, 4217, 0, NULL, 'H', 0, 5, 12098),
(53556, 'C9 1.8T 手动 前驱 舒适版 汽油 国三', NULL, 4217, 0, NULL, 'H', 0, 5, 12097),
(53555, 'C9 2.0L 手动 前驱 豪华版 柴油 国三', NULL, 4217, 0, NULL, 'H', 0, 5, 11564),
(53554, 'C9 2.0L 手动 前驱 舒适版 柴油 国三', NULL, 4217, 0, NULL, 'H', 0, 5, 11563),
(53553, '2.0L 手动 天窗版 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 102241),
(53552, '2.0T 手动 两驱 飓风版 柴油', NULL, 4216, 0, NULL, 'H', 0, 5, 100643),
(53551, '2.0D 手动 四驱 尊贵型 柴油', NULL, 4216, 0, NULL, 'H', 0, 5, 16443),
(53550, '2.7L 自动 四驱 旗舰型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15646),
(53549, '2.0L 自动 四驱 尊贵型 柴油', NULL, 4216, 0, NULL, 'H', 0, 5, 15645),
(53548, '2.0D 手动 四驱 豪华型 柴油', NULL, 4216, 0, NULL, 'H', 0, 5, 15643),
(53547, '2.0D 手动 两驱 豪华型 柴油', NULL, 4216, 0, NULL, 'H', 0, 5, 15642),
(53546, '1.8T 自动 尊贵型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15641),
(53545, '1.8T 手动 豪华型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15640),
(53544, '1.8T 手动 舒适型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15639),
(53543, '2.0L 手动 豪华型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15638),
(53542, '2.0L 手动 舒适型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 15635),
(53541, '2.0 手动 前驱 尊贵型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 13185),
(53540, '2.0 手动 前驱 豪华型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 13184),
(53539, '2.0 手动 前驱  舒适型 汽油', NULL, 4216, 0, NULL, 'H', 0, 5, 13183),
(53538, '2.0L 手动 两驱 舒适版', NULL, 4215, 0, NULL, 'H', 0, 5, 105855),
(53537, '2.7L 自动 四驱 旗舰型 汽油', NULL, 4215, 0, NULL, 'H', 0, 5, 102244),
(53536, '2.0T 自动 四驱 豪华型 柴油', NULL, 4215, 0, NULL, 'H', 0, 5, 102243),
(53535, '2.0L 手动 两驱 导航版', NULL, 4215, 0, NULL, 'H', 0, 5, 102242),
(53534, '1.8T 手动 导航版', NULL, 4215, 0, NULL, 'H', 0, 5, 102112),
(53533, '2.0T 手动 四驱 飓风版 柴油', NULL, 4215, 0, NULL, 'H', 0, 5, 101535),
(53532, '2.0T 手动 两驱 飓风版 柴油', NULL, 4215, 0, NULL, 'H', 0, 5, 101518),
(53531, '2.0L 手动 两驱 天窗版', NULL, 4215, 0, NULL, 'H', 0, 5, 100200),
(53530, '1.8T 自动 两驱 天窗版', NULL, 4214, 0, NULL, 'H', 0, 5, 105977),
(53529, '1.8T 手动 两驱 导航版', NULL, 4214, 0, NULL, 'H', 0, 5, 103652),
(53528, '2.0T 手动 两驱 天窗版 柴油', NULL, 4214, 0, NULL, 'H', 0, 5, 103650),
(53527, '2.0T 手动 四驱 天窗版 柴油', NULL, 4214, 0, NULL, 'H', 0, 5, 103648),
(53526, '2.0L 自动 汽油 尊贵型', NULL, 4213, 0, NULL, 'H', 0, 5, 103358),
(53525, '2.0L 自动 汽油 舒适型', NULL, 4213, 0, NULL, 'H', 0, 5, 103357),
(53524, '2.0L 手动 汽油 尊贵型', NULL, 4213, 0, NULL, 'H', 0, 5, 103355),
(53523, '2.0L 手动 汽油 舒适型', NULL, 4213, 0, NULL, 'H', 0, 5, 103353),
(53522, '基本型', NULL, 4212, 0, NULL, 'H', 0, 5, 110323),
(53521, 'SQ6470W', NULL, 4211, 0, NULL, 'H', 0, 5, 1413),
(53520, '7座自动', NULL, 4210, 0, NULL, 'H', 0, 5, 10409),
(53519, '2.0D 柴油 MT 舒适型', NULL, 4209, 0, NULL, 'H', 0, 5, 12847),
(53518, '2.0D 柴油 MT 豪华型', NULL, 4209, 0, NULL, 'H', 0, 5, 12846),
(53517, '2.0D 柴油 AT 舒适型', NULL, 4209, 0, NULL, 'H', 0, 5, 12845),
(53516, '2.0D 柴油 AT 豪华型', NULL, 4209, 0, NULL, 'H', 0, 5, 12844),
(53515, '1.8T 汽油 MT 舒适型', NULL, 4209, 0, NULL, 'H', 0, 5, 12841),
(53514, '1.8T 汽油 MT 豪华型', NULL, 4209, 0, NULL, 'H', 0, 5, 12840),
(53513, '1.8T 汽油 AT 舒适型', NULL, 4209, 0, NULL, 'H', 0, 5, 12839),
(53512, '1.8T 汽油 AT 豪华型', NULL, 4209, 0, NULL, 'H', 0, 5, 12838),
(53511, '1.8T 汽油 AT 尊贵型', NULL, 4209, 0, NULL, 'H', 0, 5, 12765),
(53510, '1.8T 汽油 MT 尊贵型', NULL, 4209, 0, NULL, 'H', 0, 5, 12764),
(53509, '2.0D 柴油 AT 尊贵型', NULL, 4209, 0, NULL, 'H', 0, 5, 12763),
(53508, '2.0T 柴油 MT 尊贵型', NULL, 4209, 0, NULL, 'H', 0, 5, 12762),
(53507, '2.0L 自动 智尊版', NULL, 4208, 0, NULL, 'H', 0, 5, 15339),
(53506, '2.0L 自动 行政版', NULL, 4208, 0, NULL, 'H', 0, 5, 15338),
(53505, '2.0L 手动 商务版', NULL, 4208, 0, NULL, 'H', 0, 5, 15337),
(53504, '1.8T 自动 旗舰型', NULL, 4208, 0, NULL, 'H', 0, 5, 15336),
(53503, '1.8T 自动 智尊版', NULL, 4208, 0, NULL, 'H', 0, 5, 15335),
(53502, '1.8T 自动 商务版', NULL, 4208, 0, NULL, 'H', 0, 5, 15334),
(53501, '1.8T 自动 行政版', NULL, 4208, 0, NULL, 'H', 0, 5, 15329),
(53500, '1.8T 手动 商务版', NULL, 4208, 0, NULL, 'H', 0, 5, 15328),
(53499, '1.8T 手动 两驱 爱国版', NULL, 4207, 0, NULL, 'H', 0, 5, 106580),
(53498, '2.0D 手动 两驱 爱国版', NULL, 4207, 0, NULL, 'H', 0, 5, 106579),
(53497, '2.0T 自动 智尊版', NULL, 4207, 0, NULL, 'H', 0, 5, 103689),
(53496, '1.8T 自动 智尊版', NULL, 4207, 0, NULL, 'H', 0, 5, 103688),
(53495, '2.0T 手动 智尊版', NULL, 4207, 0, NULL, 'H', 0, 5, 102571),
(53494, '1.8T 手动 智尊版', NULL, 4207, 0, NULL, 'H', 0, 5, 102570),
(53493, '2.0T 手动 智汇版', NULL, 4207, 0, NULL, 'H', 0, 5, 101537),
(53492, '1.8T 手动 智汇版', NULL, 4207, 0, NULL, 'H', 0, 5, 101536),
(53491, '2.0T 手动 两驱 商务版', NULL, 4207, 0, NULL, 'H', 0, 5, 100380),
(53490, '2.0T 自动 两驱 行政版', NULL, 4207, 0, NULL, 'H', 0, 5, 100379),
(53489, '2.0T 自动 四驱 智尊版', NULL, 4207, 0, NULL, 'H', 0, 5, 100378),
(53488, '1.8T 自动 四驱 旗舰版', NULL, 4206, 0, NULL, 'H', 0, 5, 104618),
(53487, '2.0D 自动 两驱 智尊版 OED', NULL, 4206, 0, NULL, 'H', 0, 5, 103820),
(53486, '2.0D 自动 两驱 智汇版 OED', NULL, 4206, 0, NULL, 'H', 0, 5, 103819),
(53485, '2.0D 手动 两驱 智尊版 OED', NULL, 4206, 0, NULL, 'H', 0, 5, 103817),
(53484, '2.0D 手动 两驱 智汇版 OED', NULL, 4206, 0, NULL, 'H', 0, 5, 103814),
(53483, '1.8T 自动 两驱 智尊版', NULL, 4206, 0, NULL, 'H', 0, 5, 103813),
(53482, '1.8T 手动 两驱 智尊版', NULL, 4206, 0, NULL, 'H', 0, 5, 103811),
(53481, '1.8T 自动 两驱 智汇版', NULL, 4206, 0, NULL, 'H', 0, 5, 103810),
(53480, '1.8T 手动 两驱 智汇版', NULL, 4206, 0, NULL, 'H', 0, 5, 103809),
(53479, '1.8T 手动 两驱 智享版', NULL, 4205, 0, NULL, 'H', 0, 5, 106178),
(53478, '勇士悍马', NULL, 4204, 0, NULL, 'H', 0, 5, 8314),
(53477, '165加长版', NULL, 4203, 0, NULL, 'H', 0, 5, 3268),
(53476, '200英寸加长豪华礼车', NULL, 4202, 0, NULL, 'H', 0, 5, 11177),
(53475, '165英寸加长豪华礼车', NULL, 4202, 0, NULL, 'H', 0, 5, 11176),
(53474, 'G50', NULL, 4201, 0, NULL, 'H', 0, 5, 8882),
(53473, 'H3 皮卡', NULL, 4201, 0, NULL, 'H', 0, 5, 8378),
(53472, 'H3', NULL, 4201, 0, NULL, 'H', 0, 5, 8368),
(53471, 'H2', NULL, 4201, 0, NULL, 'H', 0, 5, 8367),
(53470, '6.2L V8', NULL, 4200, 0, NULL, 'H', 0, 5, 15497),
(53469, 'H6', NULL, 4200, 0, NULL, 'H', 0, 5, 9130),
(53468, 'H600', NULL, 4200, 0, NULL, 'H', 0, 5, 7356),
(53467, '3.5', NULL, 4199, 0, NULL, 'H', 0, 5, 3822),
(53466, 'ALPHA 5.3', NULL, 4198, 0, NULL, 'H', 0, 5, 9697),
(53465, 'x 3.7', NULL, 4198, 0, NULL, 'H', 0, 5, 3823),
(53464, '悍马H200', NULL, 4197, 0, NULL, 'H', 0, 5, 5794),
(53463, '6.2L', NULL, 4196, 0, NULL, 'H', 0, 5, 15498),
(53462, '6.0 AT', NULL, 4195, 0, NULL, 'H', 0, 5, 15533),
(53461, '6.0 AT', NULL, 4194, 0, NULL, 'H', 0, 5, 15301),
(53460, '6.2 AT', NULL, 4194, 0, NULL, 'H', 0, 5, 3796),
(53459, '实用型', NULL, 4193, 0, NULL, 'H', 0, 5, 2998),
(53458, 'GHT6501 商务型', NULL, 4193, 0, NULL, 'H', 0, 5, 2997),
(53457, 'GHT6501 6/9座 标准型', NULL, 4193, 0, NULL, 'H', 0, 5, 2996),
(53456, 'GHT6500 11/14座 标准型', NULL, 4193, 0, NULL, 'H', 0, 5, 2995),
(53455, 'GHT6490 11/14座 经济型', NULL, 4193, 0, NULL, 'H', 0, 5, 2994),
(53454, 'GHT6491 6/9座 经济型', NULL, 4193, 0, NULL, 'H', 0, 5, 2993),
(53453, '2.0 手动 柴油', NULL, 4192, 0, NULL, 'H', 0, 5, 109457),
(53452, '2.0 手动 豪华加长版', NULL, 4192, 0, NULL, 'H', 0, 5, 109456),
(53451, '2.0 手动 豪华版', NULL, 4192, 0, NULL, 'H', 0, 5, 109455),
(53450, '2.0 手动 基本加长版', NULL, 4192, 0, NULL, 'H', 0, 5, 109454),
(53449, '2.0 手动 基本版', NULL, 4192, 0, NULL, 'H', 0, 5, 108521),
(53448, '世纪星 2.0 标准型', NULL, 4192, 0, NULL, 'H', 0, 5, 6146),
(53447, '2.4 手动 标准版', NULL, 4191, 0, NULL, 'H', 0, 5, 109459),
(53446, '2.4 手动 加长版', NULL, 4191, 0, NULL, 'H', 0, 5, 109458),
(53445, '世纪星CA7242E6零售型', NULL, 4191, 0, NULL, 'H', 0, 5, 2791),
(53444, '世纪星CA7202E3卓越者', NULL, 4191, 0, NULL, 'H', 0, 5, 2790),
(53443, '世纪星CA7202E3基本型', NULL, 4191, 0, NULL, 'H', 0, 5, 2789),
(53442, '卓越者 2.0 手动 舒适版', NULL, 4190, 0, NULL, 'H', 0, 5, 109461),
(53441, '卓越者 2.0 手动 尊享版', NULL, 4190, 0, NULL, 'H', 0, 5, 109460),
(53440, '新卓越者CA7182E7出租型', NULL, 4190, 0, NULL, 'H', 0, 5, 3992),
(53439, '新卓越者CA7182E7零售型', NULL, 4190, 0, NULL, 'H', 0, 5, 3991),
(53438, '2.0 手动 加长版', NULL, 4189, 0, NULL, 'H', 0, 5, 109464),
(53437, '2.0 手动', NULL, 4188, 0, NULL, 'H', 0, 5, 109463),
(53436, '卓越者1.8 手动 ', NULL, 4188, 0, NULL, 'H', 0, 5, 109453),
(53435, '卓越者 2.0 手动 舒适版', NULL, 4187, 0, NULL, 'H', 0, 5, 109462),
(53434, '新卓越者1.8L 双燃料车出租车', NULL, 4187, 0, NULL, 'H', 0, 5, 4771),
(53433, '新卓越者1.8L 单燃料车', NULL, 4187, 0, NULL, 'H', 0, 5, 4770),
(53432, 'CA7180A4E', NULL, 4186, 0, NULL, 'H', 0, 5, 6145),
(53431, 'CA7180A3E', NULL, 4186, 0, NULL, 'H', 0, 5, 6144),
(53430, 'CA7180A2E', NULL, 4186, 0, NULL, 'H', 0, 5, 6143),
(53429, 'CA7180A1E', NULL, 4186, 0, NULL, 'H', 0, 5, 6142),
(53428, '1.8 手动 I型', NULL, 4185, 0, NULL, 'H', 0, 5, 109447),
(53427, '1.8 手动 加长版', NULL, 4185, 0, NULL, 'H', 0, 5, 109446),
(53426, '1.8 手动 II型', NULL, 4184, 0, NULL, 'H', 0, 5, 109448),
(53425, '1.8 手动 商务版', NULL, 4184, 0, NULL, 'H', 0, 5, 108522),
(53424, '2.0加长型', NULL, 4183, 0, NULL, 'H', 0, 5, 2768),
(53423, '2.4加长型', NULL, 4183, 0, NULL, 'H', 0, 5, 2765),
(53422, '2.4标准型', NULL, 4183, 0, NULL, 'H', 0, 5, 2764),
(53421, '1.8 手动 商务版', NULL, 4182, 0, NULL, 'H', 0, 5, 108523),
(53420, '新明仕CA7180A4E出租型', NULL, 4182, 0, NULL, 'H', 0, 5, 2772),
(53419, '新明仕CA7180A4E舒适型', NULL, 4182, 0, NULL, 'H', 0, 5, 2771),
(53418, '新明仕CA7180A4E商务版', NULL, 4182, 0, NULL, 'H', 0, 5, 2770),
(53417, '新明仕CA7180G4双燃料出租车', NULL, 4182, 0, NULL, 'H', 0, 5, 2769),
(53416, '卓越者尊贵型', NULL, 4182, 0, NULL, 'H', 0, 5, 2767),
(53415, '卓越者舒适型', NULL, 4182, 0, NULL, 'H', 0, 5, 2766),
(53414, '1.8 手动 液化石油气LPG', NULL, 4181, 0, NULL, 'H', 0, 5, 109450),
(53413, '1.8 手动 压缩天然气CNG', NULL, 4181, 0, NULL, 'H', 0, 5, 109449),
(53412, '商务版', NULL, 4181, 0, NULL, 'H', 0, 5, 4774),
(53411, '舒适版', NULL, 4181, 0, NULL, 'H', 0, 5, 4773),
(53410, '1.8 手动', NULL, 4180, 0, NULL, 'H', 0, 5, 109452),
(53409, '1.8 手动 商务版', NULL, 4180, 0, NULL, 'H', 0, 5, 108524),
(53408, '1.8 手动 液化石油气LPG', NULL, 4179, 0, NULL, 'H', 0, 5, 109451),
(53407, '1.8 手动 商务版', NULL, 4179, 0, NULL, 'H', 0, 5, 108518),
(53406, '7180AE', NULL, 4179, 0, NULL, 'H', 0, 5, 6141),
(53405, '红旗CA7182E7零售型23', NULL, 4179, 0, NULL, 'H', 0, 5, 4844),
(53404, '红旗CA7182E7零售型22', NULL, 4179, 0, NULL, 'H', 0, 5, 4839),
(53403, '红旗CA7182E7零售型1', NULL, 4179, 0, NULL, 'H', 0, 5, 4838),
(53402, '红旗CA7182E7零售型yyy', NULL, 4179, 0, NULL, 'H', 0, 5, 4837),
(53401, '红旗CA7182E7零售型', NULL, 4179, 0, NULL, 'H', 0, 5, 4836),
(53400, '新明仕奥运之星', NULL, 4179, 0, NULL, 'H', 0, 5, 4775),
(53399, '3.0L 公务型', NULL, 4178, 0, NULL, 'H', 0, 5, 7474),
(53398, '3.0L 尊贵型', NULL, 4178, 0, NULL, 'H', 0, 5, 5256),
(53397, '3.0L 豪华型', NULL, 4178, 0, NULL, 'H', 0, 5, 3994),
(53396, '4.3L 精英型', NULL, 4178, 0, NULL, 'H', 0, 5, 3993),
(53395, '4.3 手自一体 精英型', NULL, 4177, 0, NULL, 'H', 0, 5, 108528),
(53394, '3.0 手自一体 尊贵型', NULL, 4177, 0, NULL, 'H', 0, 5, 108527),
(53393, '3.0 手自一体 豪华型', NULL, 4177, 0, NULL, 'H', 0, 5, 108526),
(53392, '4.6 CVT 基本型', NULL, 4176, 0, NULL, 'H', 0, 5, 108525),
(53391, '旗舰加长豪华型', NULL, 4175, 0, NULL, 'H', 0, 5, 2763),
(53390, '旗舰基本型', NULL, 4175, 0, NULL, 'H', 0, 5, 2762),
(53389, '4.6 CVT 加长豪华型', NULL, 4174, 0, NULL, 'H', 0, 5, 108520),
(53388, '4.6 CVT 基本型', NULL, 4174, 0, NULL, 'H', 0, 5, 108519),
(53387, '6.0L 手自一体 帜尊版', NULL, 4173, 0, NULL, 'H', 0, 5, 110995),
(53386, '2.0T 自动 技术型', NULL, 4172, 0, NULL, 'H', 0, 5, 104289),
(53385, '2.0T 自动 豪华型', NULL, 4172, 0, NULL, 'H', 0, 5, 104288),
(53384, '3.0L 自动 豪华型', NULL, 4172, 0, NULL, 'H', 0, 5, 104287),
(53383, '2.0T 自动 尊贵型', NULL, 4172, 0, NULL, 'H', 0, 5, 104173),
(53382, '2.5L 自动 尊贵型', NULL, 4172, 0, NULL, 'H', 0, 5, 104171),
(53381, '3.0L 自动 尊贵型', NULL, 4172, 0, NULL, 'H', 0, 5, 104160),
(53379, 'CA7180', NULL, 4171, 0, NULL, 'H', 0, 5, 6857),
(53380, 'CA7220', NULL, 4171, 0, NULL, 'H', 0, 5, 6858),
(53378, '2.2 手动 (化)', NULL, 4170, 0, NULL, 'H', 0, 5, 109445),
(53377, '2.0 手动 (化)', NULL, 4170, 0, NULL, 'H', 0, 5, 109432),
(53376, '1.8 手动 (化)', NULL, 4170, 0, NULL, 'H', 0, 5, 109431),
(53375, '2.2 手动 E', NULL, 4169, 0, NULL, 'H', 0, 5, 109434),
(53374, '2.0 手动 E', NULL, 4169, 0, NULL, 'H', 0, 5, 109433),
(53373, 'CA7200E', NULL, 4169, 0, NULL, 'H', 0, 5, 8984),
(53372, '1.8 手动 E', NULL, 4168, 0, NULL, 'H', 0, 5, 109439),
(53371, '2.2 手动 98新星', NULL, 4168, 0, NULL, 'H', 0, 5, 109438),
(53370, '2.2 手动 EL2', NULL, 4168, 0, NULL, 'H', 0, 5, 109437),
(53369, '2.4 手动 加长', NULL, 4168, 0, NULL, 'H', 0, 5, 109436),
(53368, '3.0 手动', NULL, 4168, 0, NULL, 'H', 0, 5, 109435),
(53367, 'CA7300', NULL, 4168, 0, NULL, 'H', 0, 5, 8993),
(53366, 'CA7247L', NULL, 4168, 0, NULL, 'H', 0, 5, 8992),
(53365, 'CA7200E3 基本型', NULL, 4168, 0, NULL, 'H', 0, 5, 8989),
(53364, 'CA7181AE 吉星基本型', NULL, 4168, 0, NULL, 'H', 0, 5, 8987),
(53363, 'CA7240L 手动', NULL, 4168, 0, NULL, 'H', 0, 5, 8983),
(53362, '2.0 手动 AE', NULL, 4167, 0, NULL, 'H', 0, 5, 109442),
(53361, '2.2 手动 A9E', NULL, 4167, 0, NULL, 'H', 0, 5, 109441),
(53360, '2.2 手动 A9E加长', NULL, 4167, 0, NULL, 'H', 0, 5, 109440),
(53359, '2.0 手动 E3 加长型', NULL, 4167, 0, NULL, 'H', 0, 5, 109430),
(53358, '2.0 手动 E3 基本型', NULL, 4167, 0, NULL, 'H', 0, 5, 108517),
(53357, '2.0 手动 E3 豪华型', NULL, 4167, 0, NULL, 'H', 0, 5, 108516),
(53356, '1.8 手动 AE吉星出租型', NULL, 4167, 0, NULL, 'H', 0, 5, 108515),
(53355, '1.8 手动 AE吉星公务型', NULL, 4167, 0, NULL, 'H', 0, 5, 108513),
(53354, 'CA7200E3L 基本型', NULL, 4167, 0, NULL, 'H', 0, 5, 8991),
(53353, 'CA7200E3L 豪华型', NULL, 4167, 0, NULL, 'H', 0, 5, 8990),
(53352, 'CA7200E3 豪华型', NULL, 4167, 0, NULL, 'H', 0, 5, 8988),
(53351, 'CA7181AE 吉星公务型', NULL, 4167, 0, NULL, 'H', 0, 5, 8986),
(53350, '1.8 手动 AE 吉星', NULL, 4166, 0, NULL, 'H', 0, 5, 108514),
(53349, '1.8 手动 A2E', NULL, 4165, 0, NULL, 'H', 0, 5, 109444),
(53348, '2.0 手动 AE', NULL, 4165, 0, NULL, 'H', 0, 5, 109443),
(53347, '1.8L 加长型', NULL, 4165, 0, NULL, 'H', 0, 5, 8985),
(53346, '1.8 手动 A2E加长版', NULL, 4164, 0, NULL, 'H', 0, 5, 108512),
(53345, 'HQ430 4.3 手自一体 精英版', NULL, 4163, 0, NULL, 'H', 0, 5, 109472),
(53344, 'HQ300 3.0 手自一体 商务版', NULL, 4163, 0, NULL, 'H', 0, 5, 109471),
(53343, 'HQ300 3.0 手自一体 豪华版', NULL, 4163, 0, NULL, 'H', 0, 5, 109470),
(53342, '红旗CA7182E7出租型', NULL, 4163, 0, NULL, 'H', 0, 5, 4772),
(53341, 'HQ300 3.0 手自一体 公务版', NULL, 4162, 0, NULL, 'H', 0, 5, 109469),
(53340, 'HQ430 4.3 手自一体 精英版', NULL, 4162, 0, NULL, 'H', 0, 5, 109467),
(53339, 'HQ300 3.0 手自一体 商务版', NULL, 4162, 0, NULL, 'H', 0, 5, 109466),
(53338, 'HQ300 3.0 手自一体 豪华版', NULL, 4162, 0, NULL, 'H', 0, 5, 109465),
(53337, 'HQ300 3.0 手自一体 周年纪念版', NULL, 4161, 0, NULL, 'H', 0, 5, 109468),
(53336, 'DG6472', NULL, 4160, 0, NULL, 'H', 0, 5, 2301),
(53335, 'DD1023C—9', NULL, 4159, 0, NULL, 'H', 0, 5, 4042),
(53334, 'DD1023C—9JD', NULL, 4159, 0, NULL, 'H', 0, 5, 4041),
(53333, 'DD1023—9', NULL, 4159, 0, NULL, 'H', 0, 5, 4040),
(53332, 'DD1023E 柴油版 豪华型(加长后货箱)', NULL, 4158, 0, NULL, 'H', 0, 5, 12229),
(53331, 'DD1023E 柴油版 标准型(加长后货箱)', NULL, 4158, 0, NULL, 'H', 0, 5, 12228),
(53330, 'DD1023E 汽油版 豪华型(加长后货箱)', NULL, 4158, 0, NULL, 'H', 0, 5, 12227),
(53329, 'DD6490L(柴油版)标准', NULL, 4157, 0, NULL, 'H', 0, 5, 10027),
(53328, 'DD6490D（柴油型）豪华', NULL, 4157, 0, NULL, 'H', 0, 5, 4033),
(53327, 'DD6490C（柴油型）豪华', NULL, 4157, 0, NULL, 'H', 0, 5, 2318),
(53326, 'DD6471B（汽油型）豪华', NULL, 4157, 0, NULL, 'H', 0, 5, 2317),
(53325, 'DD6490A(柴油版)标准 国三', NULL, 4156, 0, NULL, 'H', 0, 5, 12221),
(53324, 'DD6490L(柴油版)标准 国三', NULL, 4156, 0, NULL, 'H', 0, 5, 12220),
(53323, 'DD6490P(汽油版)标准 国四+OBD', NULL, 4156, 0, NULL, 'H', 0, 5, 12219),
(53322, 'DD6490A(汽油版)标准 国三', NULL, 4156, 0, NULL, 'H', 0, 5, 12218),
(53321, '2.4L 手动 豪华型 DD6491A(柴油版)', NULL, 4155, 0, NULL, 'H', 0, 5, 14932),
(53320, '2.0L 手动 豪华型 DD6490P(汽油版)', NULL, 4155, 0, NULL, 'H', 0, 5, 14931),
(53319, 'DG6400', NULL, 4154, 0, NULL, 'H', 0, 5, 2300),
(53318, 'DG6400B', NULL, 4154, 0, NULL, 'H', 0, 5, 2299),
(53317, '2.4L 手动 超豪华版 DD6472A', NULL, 4153, 0, NULL, 'H', 0, 5, 13692),
(53316, '2.4L 手动 豪华版 DD6472A', NULL, 4153, 0, NULL, 'H', 0, 5, 13691),
(53315, '2.0L 手动 超豪华版 DD6472B', NULL, 4153, 0, NULL, 'H', 0, 5, 13690),
(53314, '2.0L 手动 豪华版 DD6472B', NULL, 4153, 0, NULL, 'H', 0, 5, 13689),
(53313, '1.9T 手动 柴油版 DD6472C', NULL, 4152, 0, NULL, 'H', 0, 5, 106433),
(53312, '2.0L 两驱 超豪华型 柴油版', NULL, 4151, 0, NULL, 'H', 0, 5, 15214),
(53311, '2.0L 两驱 豪华型 柴油版', NULL, 4151, 0, NULL, 'H', 0, 5, 15213),
(53310, '2.4L AT 两驱 超豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 15212),
(53309, '2.0L 两驱 超豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 15211),
(53308, '2.5L 两驱 豪华型 柴油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13718),
(53307, '2.0L 四驱 超豪华型 柴油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13717),
(53306, '2.4L 四驱 超豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13715),
(53305, '2.4L 四驱 豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13714),
(53304, '2.4L MT 两驱 超豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13712),
(53303, '2.0L 两驱 豪华型 汽油版', NULL, 4151, 0, NULL, 'H', 0, 5, 13711),
(53302, '豪华型 （DD6470E）', NULL, 4150, 0, NULL, 'H', 0, 5, 7145),
(53301, '豪华型 （DD6470C）', NULL, 4150, 0, NULL, 'H', 0, 5, 7143),
(53300, '舒适型 （DD6470C）', NULL, 4150, 0, NULL, 'H', 0, 5, 7142),
(53299, '豪华型 （DD6470）', NULL, 4150, 0, NULL, 'H', 0, 5, 7141),
(53298, '舒适型 （DD6470）', NULL, 4150, 0, NULL, 'H', 0, 5, 4034),
(53297, '豪华型 柴油版', NULL, 4149, 0, NULL, 'H', 0, 5, 9314),
(53296, '舒适型 柴油版', NULL, 4149, 0, NULL, 'H', 0, 5, 9313),
(53295, 'DD6470 豪华型', NULL, 4149, 0, NULL, 'H', 0, 5, 9312),
(53294, 'DD6470 舒适型', NULL, 4149, 0, NULL, 'H', 0, 5, 8943),
(53293, '2.5L 四驱 标准型  柴油版 DD6470', NULL, 4148, 0, NULL, 'H', 0, 5, 12258),
(53292, '2.5L  两驱 标准型 柴油版 DD6470 ', NULL, 4148, 0, NULL, 'H', 0, 5, 12257),
(53291, '2.4 四驱 标准型L 汽油版  国四+OBD DD6470E', NULL, 4148, 0, NULL, 'H', 0, 5, 12256),
(53290, '2.4L 两驱 精英型 汽油版 国四+OBD DD6470E ', NULL, 4148, 0, NULL, 'H', 0, 5, 12255),
(53289, '2.4L 两驱 标准型 汽油版 国四+OBD DD6470E ', NULL, 4148, 0, NULL, 'H', 0, 5, 12254),
(53288, '2.0L 两驱 标准型 汽油版 国四+OBD DD6460D ', NULL, 4148, 0, NULL, 'H', 0, 5, 12253),
(53287, '2.4L 两驱 标准自动型 汽油版 DD6470 ', NULL, 4148, 0, NULL, 'H', 0, 5, 12252),
(53286, '2.0L 两驱 标准型 汽油版 DD6470 ', NULL, 4148, 0, NULL, 'H', 0, 5, 12251),
(53285, 'DD6470C(柴油版) 两驱 手动', NULL, 4148, 0, NULL, 'H', 0, 5, 9805),
(53284, 'DD6470E（汽油版） 四驱 手动', NULL, 4148, 0, NULL, 'H', 0, 5, 9804),
(53283, 'DD6470E（汽油版） 两驱 手动', NULL, 4148, 0, NULL, 'H', 0, 5, 9803),
(53282, 'DD6460D（汽油版） 两驱 手动', NULL, 4148, 0, NULL, 'H', 0, 5, 9802),
(53281, 'DD6470（汽油版） 两驱 自动', NULL, 4148, 0, NULL, 'H', 0, 5, 9801),
(53280, 'DD6470（汽油版） 两驱 手动', NULL, 4148, 0, NULL, 'H', 0, 5, 9800),
(53279, 'DD6470C(柴油版) 四驱 手动', NULL, 4147, 0, NULL, 'H', 0, 5, 10030),
(53278, 'DG6480B', NULL, 4146, 0, NULL, 'H', 0, 5, 2305),
(53277, 'DG6480A', NULL, 4146, 0, NULL, 'H', 0, 5, 2304),
(53276, 'DG6480 三菱发动机', NULL, 4146, 0, NULL, 'H', 0, 5, 2303),
(53275, 'DG6480  491发动机', NULL, 4146, 0, NULL, 'H', 0, 5, 2302),
(53274, 'DD1022D 4X2 CA4D32—10', NULL, 4145, 0, NULL, 'H', 0, 5, 4037),
(53273, 'DD1020L 4X2 JM491Q—ME', NULL, 4145, 0, NULL, 'H', 0, 5, 4036),
(53272, 'DD1022K 柴油版 标准型', NULL, 4144, 0, NULL, 'H', 0, 5, 12250),
(53271, '柴油版 四驱 豪华型 DD1022H', NULL, 4144, 0, NULL, 'H', 0, 5, 12249),
(53270, 'DD1022S 柴油版 豪华型', NULL, 4144, 0, NULL, 'H', 0, 5, 12248),
(53269, 'DD1022E 柴油版 豪华型', NULL, 4144, 0, NULL, 'H', 0, 5, 12247),
(53268, '四驱 豪华型 汽油版  DD1022G', NULL, 4144, 0, NULL, 'H', 0, 5, 12246),
(53267, '两驱 豪华型 汽油版 DD1022G ', NULL, 4144, 0, NULL, 'H', 0, 5, 12245),
(53266, 'DD1022F 汽油版 豪华型', NULL, 4144, 0, NULL, 'H', 0, 5, 12235),
(53265, '至尊版 2.8T 手动 两驱 标准型 柴油', NULL, 4143, 0, NULL, 'H', 0, 5, 111461),
(53264, '至尊版 2.4L 手动 两驱 标准型 汽油', NULL, 4143, 0, NULL, 'H', 0, 5, 100433),
(53263, '至尊版 2.4L 手动 两驱 豪华型 汽油', NULL, 4143, 0, NULL, 'H', 0, 5, 100431),
(53262, '至尊版 2.4L 手动 四驱 标准型 汽油', NULL, 4143, 0, NULL, 'H', 0, 5, 100430),
(53261, '至尊版 2.4L 手动 四驱 豪华型 汽油', NULL, 4143, 0, NULL, 'H', 0, 5, 100429),
(53260, '至尊版 3.2T 手动 两驱 标准型 柴油', NULL, 4143, 0, NULL, 'H', 0, 5, 100428),
(53259, '至尊版 3.2T 手动 两驱 豪华型 柴油', NULL, 4143, 0, NULL, 'H', 0, 5, 100427),
(53258, '至尊版 3.2T 手动 四驱 标准型 柴油 ', NULL, 4143, 0, NULL, 'H', 0, 5, 100426);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(53257, '至尊版 3.2T 手动 四驱 豪华型 柴油', NULL, 4143, 0, NULL, 'H', 0, 5, 100423),
(53256, '2.8L 手动 两驱 豪华型 柴油 DD1030K', NULL, 4142, 0, NULL, 'H', 0, 5, 110594),
(53255, '3.2L 手动 两驱 豪华型 柴油 DD1022E', NULL, 4142, 0, NULL, 'H', 0, 5, 103563),
(53254, '2.8L 手动 两驱 豪华型 柴油 DD1022T', NULL, 4142, 0, NULL, 'H', 0, 5, 103562),
(53253, '2.8L 手动 四驱 豪华型 柴油 DD1022T', NULL, 4142, 0, NULL, 'H', 0, 5, 103561),
(53252, '3.2L 手动 两驱 豪华型 柴油 DD1022S', NULL, 4142, 0, NULL, 'H', 0, 5, 103560),
(53251, '2.4L 手动 两驱 豪华型 柴油 DD1022K', NULL, 4142, 0, NULL, 'H', 0, 5, 103559),
(53250, '2.2L 手动 两驱 豪华型 汽油 DD1022V', NULL, 4142, 0, NULL, 'H', 0, 5, 103558),
(53249, '2.0L 手动 两驱 豪华型 汽油 DD1022L', NULL, 4142, 0, NULL, 'H', 0, 5, 103557),
(53248, '2.4L 手动 四驱 豪华型 汽油 DD1022M ', NULL, 4142, 0, NULL, 'H', 0, 5, 103556),
(53247, '2.4 手动 豪华型 后驱 DD6480', NULL, 4141, 0, NULL, 'H', 0, 5, 2332),
(53246, 'DG6480C超豪华型(柴油型)', NULL, 4141, 0, NULL, 'H', 0, 5, 2309),
(53245, 'DG6480A超豪华型(汽油型)', NULL, 4141, 0, NULL, 'H', 0, 5, 2308),
(53244, 'DG6480超豪华型(汽油型)', NULL, 4141, 0, NULL, 'H', 0, 5, 2307),
(53243, 'DD6480A 2.4手动豪华型 四驱', NULL, 4140, 0, NULL, 'H', 0, 5, 2331),
(53242, '翱龙 DG6480 两驱舒适型', NULL, 4140, 0, NULL, 'H', 0, 5, 2313),
(53241, '翱龙 DG6480C 两驱豪华型', NULL, 4140, 0, NULL, 'H', 0, 5, 2312),
(53240, '2.4 后驱 手动 舒适型 DD6480', NULL, 4139, 0, NULL, 'H', 0, 5, 2330),
(53239, '2.0DD6480', NULL, 4139, 0, NULL, 'H', 0, 5, 2311),
(53238, '2.4DD6480A', NULL, 4139, 0, NULL, 'H', 0, 5, 2310),
(53237, 'DG6480豪华型(汽油型)', NULL, 4139, 0, NULL, 'H', 0, 5, 2306),
(53236, 'DG6471B', NULL, 4138, 0, NULL, 'H', 0, 5, 2295),
(53235, 'DD6490C', NULL, 4137, 0, NULL, 'H', 0, 5, 2296),
(53234, 'DD6490D', NULL, 4136, 0, NULL, 'H', 0, 5, 2298),
(53233, 'DD1022DB', NULL, 4135, 0, NULL, 'H', 0, 5, 6060),
(53232, 'DD1020B', NULL, 4135, 0, NULL, 'H', 0, 5, 6059),
(53231, 'DD6471B', NULL, 4135, 0, NULL, 'H', 0, 5, 2297),
(53230, 'DD1020C(柴油版)豪华1型', NULL, 4134, 0, NULL, 'H', 0, 5, 12231),
(53229, 'DD1020H(汽油版)豪华1型', NULL, 4134, 0, NULL, 'H', 0, 5, 12230),
(53228, 'DD1020C(柴油版)豪华型', NULL, 4134, 0, NULL, 'H', 0, 5, 10029),
(53227, 'DD1020H(汽油版)豪华型', NULL, 4134, 0, NULL, 'H', 0, 5, 10028),
(53226, '2.8 手动 后驱 舒适型 柴油 DD6480', NULL, 4133, 0, NULL, 'H', 0, 5, 6975),
(53225, '2.8L DD6480D', NULL, 4132, 0, NULL, 'H', 0, 5, 2324),
(53223, '2.0L DD6480', NULL, 4132, 0, NULL, 'H', 0, 5, 2321),
(53224, '2.4L DD6480', NULL, 4132, 0, NULL, 'H', 0, 5, 2323),
(53221, 'DD1020L', NULL, 4132, 0, NULL, 'H', 0, 5, 2319),
(53222, 'DD1022D', NULL, 4132, 0, NULL, 'H', 0, 5, 2320),
(53220, '2.2 手动 舒适型 后驱 DD6480', NULL, 4131, 0, NULL, 'H', 0, 5, 2329),
(53219, '2.2L DD6480', NULL, 4131, 0, NULL, 'H', 0, 5, 2328),
(53218, 'DD6480 2.4手动豪华型 四驱', NULL, 4131, 0, NULL, 'H', 0, 5, 2327),
(53216, '2.4L DD6480A', NULL, 4131, 0, NULL, 'H', 0, 5, 2325),
(53217, '2.8 手动 后驱 豪华型 柴油 DD6480', NULL, 4131, 0, NULL, 'H', 0, 5, 2326),
(53215, '2.0 手动 豪华型 后驱 DD6480', NULL, 4131, 0, NULL, 'H', 0, 5, 2322),
(53214, 'DD6480 4×2 JX493ZQ3豪华型', NULL, 4130, 0, NULL, 'H', 0, 5, 5902),
(53213, 'DD6480A 4×4 4G64S4M豪华型', NULL, 4130, 0, NULL, 'H', 0, 5, 5900),
(53212, 'DG6480A', NULL, 4130, 0, NULL, 'H', 0, 5, 2316),
(53211, 'DG6480', NULL, 4130, 0, NULL, 'H', 0, 5, 2315),
(53210, 'DD6470H 柴油版 标准型', NULL, 4129, 0, NULL, 'H', 0, 5, 12226),
(53209, 'DD6470N 汽油版 标准型', NULL, 4129, 0, NULL, 'H', 0, 5, 12225),
(53208, 'DD6470 汽油版  四驱 豪华型', NULL, 4129, 0, NULL, 'H', 0, 5, 12224),
(53207, 'DD6470 汽油版 豪华型', NULL, 4129, 0, NULL, 'H', 0, 5, 12223),
(53206, 'DD6470 汽油版 舒适型', NULL, 4129, 0, NULL, 'H', 0, 5, 12222),
(53205, 'DD6480', NULL, 4128, 0, NULL, 'H', 0, 5, 2314),
(53204, '12座标准商务版', NULL, 4127, 0, NULL, 'H', 0, 5, 4806),
(53203, '12座舒适商务版', NULL, 4127, 0, NULL, 'H', 0, 5, 4805),
(53202, '12/10座舒适公务版', NULL, 4127, 0, NULL, 'H', 0, 5, 2084),
(53201, '10座豪华公务版', NULL, 4127, 0, NULL, 'H', 0, 5, 2082),
(53200, '10座超豪华公务版', NULL, 4127, 0, NULL, 'H', 0, 5, 2081),
(53199, '短轴 豪华型 10人座', NULL, 4126, 0, NULL, 'H', 0, 5, 11118),
(53198, '短轴 舒适型 12人座', NULL, 4126, 0, NULL, 'H', 0, 5, 11117),
(53197, '长轴 豪华型 12人座', NULL, 4126, 0, NULL, 'H', 0, 5, 6407),
(53196, '长轴 舒适型 15人座商务版', NULL, 4126, 0, NULL, 'H', 0, 5, 2088),
(53195, '长轴 舒适型 15人座旅游版', NULL, 4126, 0, NULL, 'H', 0, 5, 2087),
(53194, '长轴 舒适型 15人座公务版', NULL, 4126, 0, NULL, 'H', 0, 5, 2086),
(53193, '长轴 豪华型 15人座', NULL, 4126, 0, NULL, 'H', 0, 5, 2085),
(53192, '短轴 超豪华型 9/10人座', NULL, 4126, 0, NULL, 'H', 0, 5, 2080),
(53191, '长轴 超豪华型 12人座', NULL, 4126, 0, NULL, 'H', 0, 5, 2079),
(53190, '短轴 舒适型 9人座', NULL, 4126, 0, NULL, 'H', 0, 5, 2078),
(53189, '短轴 舒适型 12座', NULL, 4125, 0, NULL, 'H', 0, 5, 100058),
(53188, '短轴 舒适型 9座', NULL, 4125, 0, NULL, 'H', 0, 5, 100057),
(53187, '短轴 豪华型 12座', NULL, 4125, 0, NULL, 'H', 0, 5, 100056),
(53186, '短轴 豪华型 10座', NULL, 4125, 0, NULL, 'H', 0, 5, 100055),
(53185, '短轴 豪华型 9座', NULL, 4125, 0, NULL, 'H', 0, 5, 100054),
(53184, '短轴 超豪华型 10座', NULL, 4125, 0, NULL, 'H', 0, 5, 100053),
(53183, '短轴 超豪华型 9座', NULL, 4125, 0, NULL, 'H', 0, 5, 100052),
(53182, '长轴 舒适型 旅游版 15座', NULL, 4125, 0, NULL, 'H', 0, 5, 100051),
(53181, '长轴 舒适型 商务版 15座', NULL, 4125, 0, NULL, 'H', 0, 5, 100050),
(53180, '长轴 豪华型 公务版 15座', NULL, 4125, 0, NULL, 'H', 0, 5, 100049),
(53179, '长轴 豪华型 15座', NULL, 4125, 0, NULL, 'H', 0, 5, 100048),
(53178, '长轴 豪华型 12座', NULL, 4125, 0, NULL, 'H', 0, 5, 100047),
(53177, '长轴 超豪华型 12座', NULL, 4125, 0, NULL, 'H', 0, 5, 100046),
(53176, '2.3L 手动 超值版 短轴 12座', NULL, 4124, 0, NULL, 'H', 0, 5, 101412),
(53175, '2.3L 手动 超值版 短轴 11座', NULL, 4124, 0, NULL, 'H', 0, 5, 101411),
(53174, '2.3L 手动 超值版 短轴 10座', NULL, 4124, 0, NULL, 'H', 0, 5, 101410),
(53173, '2.3L 手动 尊享版 长轴 12座', NULL, 4124, 0, NULL, 'H', 0, 5, 101409),
(53172, '2.3L 手动 精英版 短轴 12座', NULL, 4124, 0, NULL, 'H', 0, 5, 101408),
(53171, '2.3L 手动 精英版 短轴 11座', NULL, 4124, 0, NULL, 'H', 0, 5, 101407),
(53170, '2.3L 手动 精英版 短轴 10座', NULL, 4124, 0, NULL, 'H', 0, 5, 101406),
(53169, '2.3L 手动 尊享版 短轴 12座', NULL, 4124, 0, NULL, 'H', 0, 5, 101404),
(53168, '2.3L 手动 尊享版 短轴 11座', NULL, 4124, 0, NULL, 'H', 0, 5, 101403),
(53167, '2.3L 手动 尊享版 短轴 10座', NULL, 4124, 0, NULL, 'H', 0, 5, 101402),
(53166, '2.3L 手动 君享版 短轴 10座', NULL, 4124, 0, NULL, 'H', 0, 5, 101401),
(53165, '2.3L 手动 超值版 短轴 9座', NULL, 4124, 0, NULL, 'H', 0, 5, 101397),
(53164, '2.3L 手动 精英版 短轴 9座', NULL, 4124, 0, NULL, 'H', 0, 5, 101396),
(53163, '2.3L 手动 尊享版 短轴 9座', NULL, 4124, 0, NULL, 'H', 0, 5, 101395),
(53162, '2.3L 手动 君享版 短轴 9座', NULL, 4124, 0, NULL, 'H', 0, 5, 101394),
(53161, '2.3L 手动 超值版 长轴 15座', NULL, 4124, 0, NULL, 'H', 0, 5, 101393),
(53160, '2.3L 手动 精英旅游版 长轴 15座', NULL, 4124, 0, NULL, 'H', 0, 5, 101392),
(53159, '2.3L 手动 精英版 长轴 15座', NULL, 4124, 0, NULL, 'H', 0, 5, 101391),
(53158, '2.3L 手动 尊享版 长轴 15座', NULL, 4124, 0, NULL, 'H', 0, 5, 101390),
(53157, '2.3L 手动 君享版 长轴 12座', NULL, 4124, 0, NULL, 'H', 0, 5, 101389),
(53156, '豪华型', NULL, 4123, 0, NULL, 'H', 0, 5, 4252),
(53155, '超豪华型', NULL, 4123, 0, NULL, 'H', 0, 5, 4251),
(53154, '精英—LX型 9座', NULL, 4122, 0, NULL, 'H', 0, 5, 7778),
(53153, '精英—LX型 7座', NULL, 4122, 0, NULL, 'H', 0, 5, 7777),
(53152, '精英—SLX型 9座', NULL, 4122, 0, NULL, 'H', 0, 5, 7776),
(53151, '精英—SLX型 7座', NULL, 4122, 0, NULL, 'H', 0, 5, 7775),
(53150, '精英—SLX型 6座', NULL, 4122, 0, NULL, 'H', 0, 5, 7774),
(53149, '1.6 手动', NULL, 4121, 0, NULL, 'H', 0, 5, 109006),
(53148, '1.5 手动', NULL, 4121, 0, NULL, 'H', 0, 5, 107822),
(53147, '1.5L', NULL, 4120, 0, NULL, 'H', 0, 5, 6843),
(53146, '1.3L', NULL, 4119, 0, NULL, 'H', 0, 5, 6834),
(53145, '两厢 1.3 手动', NULL, 4118, 0, NULL, 'H', 0, 5, 109017),
(53144, '两厢 1.3 普通型', NULL, 4118, 0, NULL, 'H', 0, 5, 109005),
(53143, '1.3L 舒适型', NULL, 4117, 0, NULL, 'H', 0, 5, 9645),
(53142, '1.5L 舒适型', NULL, 4117, 0, NULL, 'H', 0, 5, 7196),
(53141, '1.5L 舒适型 国四', NULL, 4116, 0, NULL, 'H', 0, 5, 12114),
(53140, '1.5L 舒适型 国三', NULL, 4116, 0, NULL, 'H', 0, 5, 12113),
(53139, '1.5L 实用型 国四', NULL, 4116, 0, NULL, 'H', 0, 5, 12112),
(53138, '1.5L 实用型 国三', NULL, 4116, 0, NULL, 'H', 0, 5, 12111),
(53137, '1.3L 舒适型 国四', NULL, 4116, 0, NULL, 'H', 0, 5, 12110),
(53136, '1.3L 舒适型 国三', NULL, 4116, 0, NULL, 'H', 0, 5, 12109),
(53135, '1.3L 实用型 国四', NULL, 4116, 0, NULL, 'H', 0, 5, 12108),
(53134, '1.3L 实用型 国三', NULL, 4116, 0, NULL, 'H', 0, 5, 12107),
(53133, 'MA 1.5 标准版', NULL, 4115, 0, NULL, 'H', 0, 5, 107817),
(53132, '海域MB 1.5L基本型', NULL, 4115, 0, NULL, 'H', 0, 5, 10407),
(53131, '海域305 两厢 1.8L', NULL, 4115, 0, NULL, 'H', 0, 5, 10406),
(53130, '海域MA 1.3L标准版', NULL, 4115, 0, NULL, 'H', 0, 5, 2051),
(53129, '305 1.8L 手动', NULL, 4114, 0, NULL, 'H', 0, 5, 107819),
(53128, 'MA 1.5L周年版', NULL, 4114, 0, NULL, 'H', 0, 5, 107818),
(53127, 'AA 1.3L豪华版', NULL, 4114, 0, NULL, 'H', 0, 5, 107816),
(53126, '海域AA 1.3L舒适版', NULL, 4114, 0, NULL, 'H', 0, 5, 2062),
(53125, '海域MA 1.5L舒适版', NULL, 4114, 0, NULL, 'H', 0, 5, 2061),
(53124, '海域AA 1.3L豪华版', NULL, 4114, 0, NULL, 'H', 0, 5, 2056),
(53123, '海域MA 1.5L标准版', NULL, 4114, 0, NULL, 'H', 0, 5, 2055),
(53122, '海域MA 1.8L豪华版', NULL, 4114, 0, NULL, 'H', 0, 5, 2054),
(53121, '海域MA（海域303） H', NULL, 4114, 0, NULL, 'H', 0, 5, 2052),
(53120, 'AA 1.3L经济型', NULL, 4113, 0, NULL, 'H', 0, 5, 109004),
(53119, '海域MA 1.5L周年版', NULL, 4113, 0, NULL, 'H', 0, 5, 2060),
(53118, '海域AB 1.8L', NULL, 4113, 0, NULL, 'H', 0, 5, 2057),
(53117, '三厢 1.5 手动舒适型', NULL, 4112, 0, NULL, 'H', 0, 5, 107838),
(53116, 'MB 1.5L基本型', NULL, 4112, 0, NULL, 'H', 0, 5, 107837),
(53115, '两厢 1.3L 经济型', NULL, 4112, 0, NULL, 'H', 0, 5, 8767),
(53114, '三厢 舒适型', NULL, 4112, 0, NULL, 'H', 0, 5, 4810),
(53113, '两厢 1.3L 舒适型', NULL, 4112, 0, NULL, 'H', 0, 5, 4809),
(53112, '海域三厢1.3L', NULL, 4112, 0, NULL, 'H', 0, 5, 2065),
(53111, '海域MB 1.8L豪华型', NULL, 4112, 0, NULL, 'H', 0, 5, 2064),
(53110, '海域MB 1.5L标准型', NULL, 4112, 0, NULL, 'H', 0, 5, 2063),
(53109, '海域MB 1.8L舒适型', NULL, 4112, 0, NULL, 'H', 0, 5, 2059),
(53108, '1.5L舒适型 三厢', NULL, 4112, 0, NULL, 'H', 0, 5, 2058),
(53107, '两厢 1.3 手动经济型', NULL, 4111, 0, NULL, 'H', 0, 5, 107830),
(53106, '两厢 1.3 手动舒适型', NULL, 4111, 0, NULL, 'H', 0, 5, 107821),
(53105, '三厢 1.5 手动舒适型', NULL, 4111, 0, NULL, 'H', 0, 5, 107820),
(53104, '1.5L 舒适型', NULL, 4110, 0, NULL, 'H', 0, 5, 12144),
(53103, '1.5L 舒适型 CNG', NULL, 4110, 0, NULL, 'H', 0, 5, 12143),
(53102, '1.5L 实用型 CNG', NULL, 4110, 0, NULL, 'H', 0, 5, 12142),
(53101, '1.5L 实用型', NULL, 4110, 0, NULL, 'H', 0, 5, 12140),
(53100, '1.3L 舒适型 国四', NULL, 4110, 0, NULL, 'H', 0, 5, 12118),
(53099, '1.3L 舒适型 国三', NULL, 4110, 0, NULL, 'H', 0, 5, 12117),
(53098, '1.3L 实用型 国四', NULL, 4110, 0, NULL, 'H', 0, 5, 12116),
(53096, 'AA 两厢 1.5L', NULL, 4109, 0, NULL, 'H', 0, 5, 10405),
(53097, '1.3L 实用型 国三', NULL, 4110, 0, NULL, 'H', 0, 5, 12115),
(53095, 'AA 1.5 手动', NULL, 4108, 0, NULL, 'H', 0, 5, 107815),
(53094, '两厢 1.8L舒适型', NULL, 4107, 0, NULL, 'H', 0, 5, 10402),
(53093, '两厢 1.5L舒适型', NULL, 4107, 0, NULL, 'H', 0, 5, 10401),
(53092, 'AB 两厢 1.5L 呵护型', NULL, 4107, 0, NULL, 'H', 0, 5, 9032),
(53091, 'AB 两厢 1.8L', NULL, 4107, 0, NULL, 'H', 0, 5, 2070),
(53090, 'AB 两厢 1.5L 激情型', NULL, 4107, 0, NULL, 'H', 0, 5, 2066),
(53089, '两厢 1.8 手动舒适型', NULL, 4106, 0, NULL, 'H', 0, 5, 107834),
(53088, '两厢 1.5 手动舒适型', NULL, 4106, 0, NULL, 'H', 0, 5, 107833),
(53087, '三厢 1.8L舒适型', NULL, 4106, 0, NULL, 'H', 0, 5, 10404),
(53086, '三厢 1.5L舒适型', NULL, 4106, 0, NULL, 'H', 0, 5, 10403),
(53085, 'MA 三厢 1.8L 迅威型', NULL, 4106, 0, NULL, 'H', 0, 5, 9031),
(53084, '三厢 1.3L 舒适型', NULL, 4106, 0, NULL, 'H', 0, 5, 2069),
(53083, 'MA 三厢 1.5L 迅捷型', NULL, 4106, 0, NULL, 'H', 0, 5, 2068),
(53082, '三厢 1.8 手动舒适型', NULL, 4105, 0, NULL, 'H', 0, 5, 107836),
(53081, '三厢 1.5 手动舒适型', NULL, 4105, 0, NULL, 'H', 0, 5, 107835),
(53080, '两厢 1.5 手动舒适型', NULL, 4105, 0, NULL, 'H', 0, 5, 107829),
(53079, '1.5L 舒适型 CNG', NULL, 4104, 0, NULL, 'H', 0, 5, 12148),
(53078, '1.5L 实用型 CNG', NULL, 4104, 0, NULL, 'H', 0, 5, 12147),
(53077, '1.5L 舒适型 国四', NULL, 4104, 0, NULL, 'H', 0, 5, 12134),
(53076, '1.5L 舒适型 国三', NULL, 4104, 0, NULL, 'H', 0, 5, 12133),
(53075, '1.5L 实用型 国四', NULL, 4104, 0, NULL, 'H', 0, 5, 12132),
(53074, '1.5L 实用型 国三', NULL, 4104, 0, NULL, 'H', 0, 5, 12131),
(53073, '1.3L 舒适型 国四', NULL, 4104, 0, NULL, 'H', 0, 5, 12130),
(53072, '1.3L 舒适型 国三', NULL, 4104, 0, NULL, 'H', 0, 5, 12129),
(53071, '1.3L 实用型 国四', NULL, 4104, 0, NULL, 'H', 0, 5, 12128),
(53070, '1.3L 实用型 国三', NULL, 4104, 0, NULL, 'H', 0, 5, 12127),
(53069, 'AA 1.5L 优雅型', NULL, 4103, 0, NULL, 'H', 0, 5, 9030),
(53068, 'MA 1.8 手动尊尚型', NULL, 4102, 0, NULL, 'H', 0, 5, 107814),
(53067, '1.8L 时尚型', NULL, 4102, 0, NULL, 'H', 0, 5, 10408),
(53066, '1.8L豪华型 三厢', NULL, 4102, 0, NULL, 'H', 0, 5, 4780),
(53065, '1.8L舒适型 三厢', NULL, 4102, 0, NULL, 'H', 0, 5, 4777),
(53064, '1.8L 尊尚型', NULL, 4102, 0, NULL, 'H', 0, 5, 2074),
(53063, '1.8L 高尚型', NULL, 4102, 0, NULL, 'H', 0, 5, 2073),
(53062, '1.5L 时尚型', NULL, 4102, 0, NULL, 'H', 0, 5, 2072),
(53061, '三厢1.5L舒适型', NULL, 4101, 0, NULL, 'H', 0, 5, 2077),
(53060, '1.8 手动双燃料LPG', NULL, 4100, 0, NULL, 'H', 0, 5, 109016),
(53059, '1.5 手动舒适型', NULL, 4100, 0, NULL, 'H', 0, 5, 107831),
(53058, '1.8 手动豪华型', NULL, 4100, 0, NULL, 'H', 0, 5, 107825),
(53057, '1.8 手动舒适型', NULL, 4100, 0, NULL, 'H', 0, 5, 107824),
(53056, '1.5 手动双燃料舒适型', NULL, 4099, 0, NULL, 'H', 0, 5, 107832),
(53055, '1.8 手动豪华型', NULL, 4099, 0, NULL, 'H', 0, 5, 107828),
(53054, '1.8 手动舒适型', NULL, 4099, 0, NULL, 'H', 0, 5, 107827),
(53053, '1.5 手动舒适型', NULL, 4099, 0, NULL, 'H', 0, 5, 107826),
(53052, '1.3L舒适版', NULL, 4099, 0, NULL, 'H', 0, 5, 5872),
(53051, '1.5L 舒适型 CNG', NULL, 4098, 0, NULL, 'H', 0, 5, 12146),
(53050, '1.5L 实用型 CNG', NULL, 4098, 0, NULL, 'H', 0, 5, 12145),
(53049, '1.5L 舒适型 国三', NULL, 4098, 0, NULL, 'H', 0, 5, 12126),
(53048, '1.5L 舒适型 国四', NULL, 4098, 0, NULL, 'H', 0, 5, 12125),
(53047, '1.5L 实用型 国四', NULL, 4098, 0, NULL, 'H', 0, 5, 12124),
(53046, '1.5L 实用型 国三', NULL, 4098, 0, NULL, 'H', 0, 5, 12123),
(53045, '1.3L 舒适型 国四', NULL, 4098, 0, NULL, 'H', 0, 5, 12122),
(53044, '1.3L 舒适型 国三', NULL, 4098, 0, NULL, 'H', 0, 5, 12121),
(53043, '1.3L 实用型 国四', NULL, 4098, 0, NULL, 'H', 0, 5, 12120),
(53042, '1.3L 实用型 国三', NULL, 4098, 0, NULL, 'H', 0, 5, 12119),
(53041, '1.8 手动豪华型', NULL, 4097, 0, NULL, 'H', 0, 5, 109014),
(53040, '1.8 手动舒适型', NULL, 4097, 0, NULL, 'H', 0, 5, 109013),
(53039, '1.8 手动标准型', NULL, 4097, 0, NULL, 'H', 0, 5, 109012),
(53038, '1.8 手动基本型', NULL, 4097, 0, NULL, 'H', 0, 5, 109011),
(53037, '1.5 手动舒适型', NULL, 4097, 0, NULL, 'H', 0, 5, 109010),
(53036, '1.5 手动标准型', NULL, 4097, 0, NULL, 'H', 0, 5, 109009),
(53035, '1.5 手动基本型', NULL, 4097, 0, NULL, 'H', 0, 5, 109008),
(53034, '1.5L舒适型 三厢', NULL, 4096, 0, NULL, 'H', 0, 5, 4781),
(53033, '1.8L舒适型 三厢', NULL, 4096, 0, NULL, 'H', 0, 5, 2076),
(53032, '1.8 手动舒适型', NULL, 4095, 0, NULL, 'H', 0, 5, 107823),
(53031, '1.5 手动舒适型', NULL, 4095, 0, NULL, 'H', 0, 5, 107813),
(53030, '1.5L 舒适型 CNG', NULL, 4094, 0, NULL, 'H', 0, 5, 12141),
(53029, '1.5L 实用型 CNG', NULL, 4094, 0, NULL, 'H', 0, 5, 12138),
(53028, '1.5L 舒适型 国四', NULL, 4094, 0, NULL, 'H', 0, 5, 12106),
(53027, '1.5L 舒适型 国三', NULL, 4094, 0, NULL, 'H', 0, 5, 12105),
(53026, '1.5L 实用型 国四', NULL, 4094, 0, NULL, 'H', 0, 5, 12104),
(53025, '1.5L 实用型 国三', NULL, 4094, 0, NULL, 'H', 0, 5, 12103),
(53024, '天窗版', NULL, 4093, 0, NULL, 'H', 0, 5, 6079),
(53023, '标准版', NULL, 4093, 0, NULL, 'H', 0, 5, 6078),
(53022, '1.3 二代标准型', NULL, 4092, 0, NULL, 'H', 0, 5, 107812),
(53021, '1.3 二代基本型', NULL, 4092, 0, NULL, 'H', 0, 5, 107811),
(53020, '二代基本型', NULL, 4092, 0, NULL, 'H', 0, 5, 6081),
(53019, '二代标准型', NULL, 4092, 0, NULL, 'H', 0, 5, 6080),
(53018, '1.3 手动标准型', NULL, 4091, 0, NULL, 'H', 0, 5, 109007),
(53017, '浅内饰版', NULL, 4091, 0, NULL, 'H', 0, 5, 6082),
(53016, '1.5 手动', NULL, 4090, 0, NULL, 'H', 0, 5, 109015),
(53015, '标准型', NULL, 4089, 0, NULL, 'H', 0, 5, 6043),
(53014, '基本型', NULL, 4089, 0, NULL, 'H', 0, 5, 6042),
(53013, '豪华型', NULL, 4089, 0, NULL, 'H', 0, 5, 6041),
(53012, '舒适型', NULL, 4089, 0, NULL, 'H', 0, 5, 6040),
(53011, 'C—sport 1.5 SDX', NULL, 4088, 0, NULL, 'H', 0, 5, 11545),
(53010, '1.5 自动实用 STD', NULL, 4088, 0, NULL, 'H', 0, 5, 11543),
(53009, 'C—sport 1.5 GLS', NULL, 4088, 0, NULL, 'H', 0, 5, 10684),
(53008, 'C—sport 1.3 GLS', NULL, 4088, 0, NULL, 'H', 0, 5, 10683),
(53007, '1.5 手动豪华 GLS', NULL, 4088, 0, NULL, 'H', 0, 5, 9856),
(53006, '1.3 手动豪华 GLS', NULL, 4088, 0, NULL, 'H', 0, 5, 9855),
(53005, '1.3 手动舒适 GLX', NULL, 4088, 0, NULL, 'H', 0, 5, 9854),
(53004, '1.3 手动实用 STD', NULL, 4088, 0, NULL, 'H', 0, 5, 9853),
(53003, '1.5 SDX C—sport', NULL, 4087, 0, NULL, 'H', 0, 5, 12985),
(53002, '1.5 自动实用 STD', NULL, 4087, 0, NULL, 'H', 0, 5, 12984),
(53001, '1.5 GLS C—sport', NULL, 4087, 0, NULL, 'H', 0, 5, 12983),
(53000, '1.3 GLS C-sport 手动豪华', NULL, 4087, 0, NULL, 'H', 0, 5, 12982),
(52999, '1.3 GLX 手动舒适', NULL, 4087, 0, NULL, 'H', 0, 5, 12981),
(52998, '1.3 GL 手动基本', NULL, 4087, 0, NULL, 'H', 0, 5, 12980),
(52997, '1.5 自动舒适 DX', NULL, 4087, 0, NULL, 'H', 0, 5, 11544),
(52996, '1.5L 自动 DX 灵动版', NULL, 4086, 0, NULL, 'H', 0, 5, 100434),
(52995, '1.3L 手动 GLX 灵悦版', NULL, 4086, 0, NULL, 'H', 0, 5, 100432),
(52994, '1.3L 手动 GLS Csport 劲酷版', NULL, 4086, 0, NULL, 'H', 0, 5, 100425),
(52993, '1.3L 手动 GL Csport 炫酷版', NULL, 4086, 0, NULL, 'H', 0, 5, 100424),
(52992, '1.3L 手动 GL Csport 炫酷版', NULL, 4085, 0, NULL, 'H', 0, 5, 104925),
(52991, '1.3L 手动 GLS Csport 劲酷版', NULL, 4085, 0, NULL, 'H', 0, 5, 104924),
(52990, '1.3L 手动 GLX 灵悦版', NULL, 4085, 0, NULL, 'H', 0, 5, 104922),
(52989, '1.5L 自动 DX 灵动版', NULL, 4085, 0, NULL, 'H', 0, 5, 104920),
(52988, '智能领航型', NULL, 4084, 0, NULL, 'H', 0, 5, 10687),
(52987, '丝路限量版', NULL, 4084, 0, NULL, 'H', 0, 5, 10686),
(52986, '都市精英版', NULL, 4084, 0, NULL, 'H', 0, 5, 10685),
(52985, '典雅风尚型', NULL, 4083, 0, NULL, 'H', 0, 5, 13636),
(52984, '智能领航型', NULL, 4083, 0, NULL, 'H', 0, 5, 13625),
(52983, '都市精英型', NULL, 4083, 0, NULL, 'H', 0, 5, 13621),
(52982, '丝路纪念版', NULL, 4083, 0, NULL, 'H', 0, 5, 12864),
(52981, '2.0L 手自一体 智能领航型', NULL, 4082, 0, NULL, 'H', 0, 5, 14871),
(52980, '2.0L 手动 智能领航型', NULL, 4082, 0, NULL, 'H', 0, 5, 14870),
(52979, '2.0L 手自一体 典雅风尚型', NULL, 4082, 0, NULL, 'H', 0, 5, 14869),
(52978, '2.0L 手动 典雅风尚型', NULL, 4082, 0, NULL, 'H', 0, 5, 14868),
(52977, '2.0L 手动 都市精英型', NULL, 4082, 0, NULL, 'H', 0, 5, 14867),
(52976, '2.0L 手动 经典版', NULL, 4081, 0, NULL, 'H', 0, 5, 102613),
(52975, '2.0L 手动 功勋版', NULL, 4081, 0, NULL, 'H', 0, 5, 102340),
(52974, '2.0L 手自一体 智能领航版', NULL, 4081, 0, NULL, 'H', 0, 5, 102044),
(52973, '2.0L 手动 智能领航版', NULL, 4081, 0, NULL, 'H', 0, 5, 102043),
(52972, '2.0L 手自一体 典雅风尚版', NULL, 4081, 0, NULL, 'H', 0, 5, 102042),
(52971, '2.0L 手动 典雅风尚版', NULL, 4081, 0, NULL, 'H', 0, 5, 102041),
(52970, '2.0L 手自一体 都市精英版', NULL, 4081, 0, NULL, 'H', 0, 5, 102040),
(52969, '2.0L 手动 都市精英版', NULL, 4081, 0, NULL, 'H', 0, 5, 102039),
(52968, '7座自动豪华型', NULL, 4080, 0, NULL, 'H', 0, 5, 10389),
(52967, '7座自动型', NULL, 4080, 0, NULL, 'H', 0, 5, 10388),
(52966, '7座手动型', NULL, 4080, 0, NULL, 'H', 0, 5, 10387),
(52965, '7座AT舒适型', NULL, 4080, 0, NULL, 'H', 0, 5, 10386),
(52964, '5座运动型', NULL, 4080, 0, NULL, 'H', 0, 5, 1218),
(52963, '5座时尚型', NULL, 4080, 0, NULL, 'H', 0, 5, 1217),
(52962, '7座AT豪华型', NULL, 4080, 0, NULL, 'H', 0, 5, 1216),
(52961, '5座AT豪华型', NULL, 4079, 0, NULL, 'H', 0, 5, 1215),
(52960, '7座AT旗舰型', NULL, 4079, 0, NULL, 'H', 0, 5, 1214),
(52959, '5座AT舒适型', NULL, 4079, 0, NULL, 'H', 0, 5, 1213),
(52958, '5座MT舒适型', NULL, 4079, 0, NULL, 'H', 0, 5, 1212),
(52957, '5座MT标准型', NULL, 4079, 0, NULL, 'H', 0, 5, 1211),
(52956, '7座自动豪华型', NULL, 4078, 0, NULL, 'H', 0, 5, 1222),
(52955, '7座手动舒适型', NULL, 4078, 0, NULL, 'H', 0, 5, 1221),
(52954, '5座自动舒适型', NULL, 4078, 0, NULL, 'H', 0, 5, 1220),
(52953, '5座手动标准型', NULL, 4078, 0, NULL, 'H', 0, 5, 1219),
(52952, '7座自动舒适型', NULL, 4077, 0, NULL, 'H', 0, 5, 1227),
(52951, '7座手动舒适型', NULL, 4077, 0, NULL, 'H', 0, 5, 1226),
(52950, '5座自动豪华型', NULL, 4077, 0, NULL, 'H', 0, 5, 1225),
(52949, '5座自动标准型', NULL, 4077, 0, NULL, 'H', 0, 5, 1224),
(52948, '5座手动标准型', NULL, 4077, 0, NULL, 'H', 0, 5, 1223),
(52947, '手动豪华型 GLS 7座', NULL, 4076, 0, NULL, 'H', 0, 5, 1232),
(52946, '自动豪华型 SDX 5座', NULL, 4076, 0, NULL, 'H', 0, 5, 1231),
(52945, '自动标准型 STD 5座', NULL, 4076, 0, NULL, 'H', 0, 5, 1230),
(52944, '手动舒适型 GLX 5座', NULL, 4076, 0, NULL, 'H', 0, 5, 1229),
(52943, '手动标准型 GL 5座', NULL, 4076, 0, NULL, 'H', 0, 5, 1228),
(52942, '新 1.6自动舒适5座(DX5)', NULL, 4075, 0, NULL, 'H', 0, 5, 11541),
(52941, '7座自动豪华', NULL, 4075, 0, NULL, 'H', 0, 5, 10691),
(52940, '5座自动舒适', NULL, 4075, 0, NULL, 'H', 0, 5, 10690),
(52939, '5座手动基本', NULL, 4075, 0, NULL, 'H', 0, 5, 10689),
(52938, '新 1.6手动豪华7座(GLS7)', NULL, 4075, 0, NULL, 'H', 0, 5, 10688),
(52937, '新 1.8自动豪华7座(SDX7)', NULL, 4075, 0, NULL, 'H', 0, 5, 9546),
(52936, '新 1.8自动舒适5座(DX5)', NULL, 4075, 0, NULL, 'H', 0, 5, 9545),
(52935, '5座手动豪华', NULL, 4075, 0, NULL, 'H', 0, 5, 9544),
(52934, '新 1.6手动舒适5座(GLX5)', NULL, 4075, 0, NULL, 'H', 0, 5, 9543),
(52933, '新 1.6手动标准5座(GL5)', NULL, 4075, 0, NULL, 'H', 0, 5, 9542),
(52932, '1.8L 手动 创想版 7座', NULL, 4074, 0, NULL, 'H', 0, 5, 101575),
(52931, '1.8L 自动 尊享版 7座', NULL, 4074, 0, NULL, 'H', 0, 5, 12979),
(52930, '1.6L 自动 炫酷版 5座', NULL, 4074, 0, NULL, 'H', 0, 5, 12978),
(52929, '1.6L 手动 开拓版 7座', NULL, 4074, 0, NULL, 'H', 0, 5, 12977),
(52928, '1.6L 手动 炫动版 5座', NULL, 4074, 0, NULL, 'H', 0, 5, 12975),
(52927, '1.6L 手动 创想版 7座', NULL, 4074, 0, NULL, 'H', 0, 5, 12973),
(52926, '1.6L 手动 舒适版 5座', NULL, 4074, 0, NULL, 'H', 0, 5, 12972),
(52925, '1.6L 手动 进取版 7座', NULL, 4073, 0, NULL, 'H', 0, 5, 102339),
(52924, '1.6L 手动 创想版 7座', NULL, 4073, 0, NULL, 'H', 0, 5, 102075),
(52923, '1.6L 自动 乐享版 7座', NULL, 4073, 0, NULL, 'H', 0, 5, 102074),
(52922, '1.6L 手动 开拓版 7座', NULL, 4073, 0, NULL, 'H', 0, 5, 102073),
(52921, '1.8L 自动 尊享版 7座', NULL, 4073, 0, NULL, 'H', 0, 5, 102072),
(52920, '1.6L 手动 开拓版 7座', NULL, 4072, 0, NULL, 'H', 0, 5, 106060),
(52919, '1.6L 手动 创想版 7座', NULL, 4072, 0, NULL, 'H', 0, 5, 106059),
(52918, '1.6L CVT 乐享版 7座', NULL, 4072, 0, NULL, 'H', 0, 5, 106058),
(52917, '1.8L CVT 尊享版 7座', NULL, 4072, 0, NULL, 'H', 0, 5, 106057),
(52916, '1.6CVT自动豪华型', NULL, 4071, 0, NULL, 'H', 0, 5, 9357),
(52915, '1.6CVT自动舒适型', NULL, 4071, 0, NULL, 'H', 0, 5, 9356),
(52914, '1.6L 手动豪华型', NULL, 4071, 0, NULL, 'H', 0, 5, 8340),
(52913, '1.6L 手动舒适型', NULL, 4071, 0, NULL, 'H', 0, 5, 8339),
(52912, '1.6L 手动标准型', NULL, 4071, 0, NULL, 'H', 0, 5, 8338),
(52911, '1.8L 自动豪华型', NULL, 4071, 0, NULL, 'H', 0, 5, 7321),
(52910, '1.8L 自动舒适型', NULL, 4071, 0, NULL, 'H', 0, 5, 7320),
(52909, '1.8L 手动豪华型', NULL, 4071, 0, NULL, 'H', 0, 5, 7319),
(52908, '1.8L 手动舒适型', NULL, 4071, 0, NULL, 'H', 0, 5, 7318),
(52907, '1.6自动运动(SDX)', NULL, 4070, 0, NULL, 'H', 0, 5, 10722),
(52906, '1.6自动舒适(DX)', NULL, 4070, 0, NULL, 'H', 0, 5, 10721),
(52905, '1.6手动运动(GLS)', NULL, 4070, 0, NULL, 'H', 0, 5, 10720),
(52904, '1.6手动舒适(GLX)', NULL, 4070, 0, NULL, 'H', 0, 5, 10719),
(52903, 'CA7130', NULL, 4069, 0, NULL, 'H', 0, 5, 6902),
(52902, '1.8 MT 舒适型', NULL, 4068, 0, NULL, 'H', 0, 5, 101821),
(52901, '1.8L SDX 自动', NULL, 4068, 0, NULL, 'H', 0, 5, 8971),
(52900, '1.8L DX 自动', NULL, 4068, 0, NULL, 'H', 0, 5, 8970),
(52899, '6470', NULL, 4067, 0, NULL, 'H', 0, 5, 7536),
(52898, '2.0L 手动 智尚版', NULL, 4066, 0, NULL, 'H', 0, 5, 104208),
(52897, '2.0L 手动 智享版', NULL, 4066, 0, NULL, 'H', 0, 5, 104207),
(52896, '2.0L 手动 智臻版', NULL, 4066, 0, NULL, 'H', 0, 5, 104206),
(52895, '2.0L 手自一体 智尚版', NULL, 4066, 0, NULL, 'H', 0, 5, 104205),
(52894, '2.0L 手自一体 智享版', NULL, 4066, 0, NULL, 'H', 0, 5, 104204),
(52893, '2.0L 手自一体 智臻版', NULL, 4066, 0, NULL, 'H', 0, 5, 104200),
(52892, '1.6L 手动 智尚型', NULL, 4065, 0, NULL, 'H', 0, 5, 110582),
(52891, '1.6L 手动 智乐型', NULL, 4065, 0, NULL, 'H', 0, 5, 110581),
(52890, '1.6L 手动 智炫型', NULL, 4065, 0, NULL, 'H', 0, 5, 110580),
(52889, '1.6L 手动 智骋型', NULL, 4065, 0, NULL, 'H', 0, 5, 110579),
(52888, '1.6L 手动 智尊型', NULL, 4065, 0, NULL, 'H', 0, 5, 110578),
(52887, '1.6L 手动 智臻型', NULL, 4065, 0, NULL, 'H', 0, 5, 106560),
(52886, '2.0L 自动 豪华型', NULL, 4064, 0, NULL, 'H', 0, 5, 106441),
(52885, '2.0L 自动 舒适型', NULL, 4064, 0, NULL, 'H', 0, 5, 106440),
(52884, '2.0L 手动 舒适型', NULL, 4064, 0, NULL, 'H', 0, 5, 106439),
(52883, '1.5L 手动 基本型', NULL, 4063, 0, NULL, 'H', 0, 5, 103833),
(52882, '1.5L 自动 旗舰型', NULL, 4063, 0, NULL, 'H', 0, 5, 103512),
(52881, '1.5L 自动 豪华型', NULL, 4063, 0, NULL, 'H', 0, 5, 103511),
(52880, '1.5L 自动 舒适型', NULL, 4063, 0, NULL, 'H', 0, 5, 103510),
(52879, '1.5L 自动 精英型', NULL, 4063, 0, NULL, 'H', 0, 5, 103509),
(52878, '1.5L 手动 旗舰型', NULL, 4063, 0, NULL, 'H', 0, 5, 103508),
(52877, '1.5L 手动 豪华型', NULL, 4063, 0, NULL, 'H', 0, 5, 103507),
(52876, '1.5L 手动 舒适型', NULL, 4063, 0, NULL, 'H', 0, 5, 103506),
(52875, '1.5L 手动 精英型', NULL, 4063, 0, NULL, 'H', 0, 5, 103504),
(52874, '1.5L 手动 标准型', NULL, 4063, 0, NULL, 'H', 0, 5, 103401),
(52873, '1.5L 自动 旗舰型', NULL, 4062, 0, NULL, 'H', 0, 5, 106082),
(52872, '1.5L 自动 舒适型', NULL, 4062, 0, NULL, 'H', 0, 5, 106081),
(52871, '1.5L 自动 精英型', NULL, 4062, 0, NULL, 'H', 0, 5, 106080),
(52870, '1.5L 手动 旗舰型', NULL, 4062, 0, NULL, 'H', 0, 5, 106079),
(52869, '1.5L 手动 豪华型', NULL, 4062, 0, NULL, 'H', 0, 5, 106078),
(52868, '1.5L 手动 舒适型', NULL, 4062, 0, NULL, 'H', 0, 5, 106077),
(52867, '1.5L 手动 精英型', NULL, 4062, 0, NULL, 'H', 0, 5, 106076),
(52866, '1.5L 手动 标准型', NULL, 4062, 0, NULL, 'H', 0, 5, 106075),
(52865, '标准型 GL1.8', NULL, 4061, 0, NULL, 'H', 0, 5, 1234),
(52864, '豪华型 GLS1.8', NULL, 4061, 0, NULL, 'H', 0, 5, 1233),
(52863, '运动版', NULL, 4060, 0, NULL, 'H', 0, 5, 5331),
(52862, '1.6自动豪华(SDX)', NULL, 4059, 0, NULL, 'H', 0, 5, 10309),
(52861, '1.6手动运动(GLX)', NULL, 4059, 0, NULL, 'H', 0, 5, 10306),
(52860, 'HMC7160 手动标准 (GL)', NULL, 4058, 0, NULL, 'H', 0, 5, 8872),
(52859, 'HMC7160 手动舒适 (GLX)', NULL, 4058, 0, NULL, 'H', 0, 5, 8871),
(52858, 'HMC7163 手动豪华 (GLS)', NULL, 4058, 0, NULL, 'H', 0, 5, 5844),
(52857, 'HMC7163 手动舒适 (GLX)', NULL, 4058, 0, NULL, 'H', 0, 5, 5843),
(52856, 'HMC7163 手动标准 (GL)', NULL, 4058, 0, NULL, 'H', 0, 5, 1206),
(52855, '1.6 MT', NULL, 4057, 0, NULL, 'H', 0, 5, 100293),
(52854, 'HMC7163 幸福版 (GX)', NULL, 4057, 0, NULL, 'H', 0, 5, 5908),
(52853, '手动舒适版(GLX)', NULL, 4056, 0, NULL, 'H', 0, 5, 10136),
(52852, '手动标准版(GL)', NULL, 4056, 0, NULL, 'H', 0, 5, 10135),
(52851, '1.6L 舒适天窗版', NULL, 4055, 0, NULL, 'H', 0, 5, 10179),
(52850, '1.6L 手动标准版', NULL, 4055, 0, NULL, 'H', 0, 5, 10178),
(52849, '1.3L 手动 标准型', NULL, 4054, 0, NULL, 'H', 0, 5, 100767),
(52848, '1.5L 手动  尊贵型', NULL, 4054, 0, NULL, 'H', 0, 5, 15445),
(52847, '1.5L 手动  精英型', NULL, 4054, 0, NULL, 'H', 0, 5, 15443),
(52846, '1.3L 手动 豪华型', NULL, 4054, 0, NULL, 'H', 0, 5, 14369),
(52845, '1.3L 手动 舒适型', NULL, 4054, 0, NULL, 'H', 0, 5, 14368),
(52844, '1.5L 手动 精英型', NULL, 4053, 0, NULL, 'H', 0, 5, 100699),
(52843, '1.5L 手动 尊贵型', NULL, 4053, 0, NULL, 'H', 0, 5, 100698),
(52842, '1.6L 手动 风尚版', NULL, 4052, 0, NULL, 'H', 0, 5, 16606),
(52841, '1.6L 手动 精英版', NULL, 4052, 0, NULL, 'H', 0, 5, 16602),
(52840, '1.6L 手动 旗舰版', NULL, 4052, 0, NULL, 'H', 0, 5, 16599),
(52839, '1.6L 自动 风尚版', NULL, 4052, 0, NULL, 'H', 0, 5, 16596),
(52838, '1.6L 自动 旗舰版', NULL, 4052, 0, NULL, 'H', 0, 5, 16595),
(52837, '1.6L 自动 精英版', NULL, 4052, 0, NULL, 'H', 0, 5, 16437),
(52836, '1.6L 手动 风尚版', NULL, 4051, 0, NULL, 'H', 0, 5, 104608),
(52835, '1.6L 手动 精英版', NULL, 4051, 0, NULL, 'H', 0, 5, 104607),
(52834, '1.6L 手动 旗舰版', NULL, 4051, 0, NULL, 'H', 0, 5, 104606),
(52833, '1.6L 自动 风尚版', NULL, 4051, 0, NULL, 'H', 0, 5, 104605),
(52832, '1.6L 自动 精英版', NULL, 4051, 0, NULL, 'H', 0, 5, 104604),
(52831, '1.6L 自动 旗舰版', NULL, 4051, 0, NULL, 'H', 0, 5, 104601),
(52830, '1.6L 手动 标准型', NULL, 4050, 0, NULL, 'H', 0, 5, 110546),
(52829, '1.6L 手动 精英型', NULL, 4050, 0, NULL, 'H', 0, 5, 110545),
(52828, '1.6L 手动 舒适型', NULL, 4050, 0, NULL, 'H', 0, 5, 110544),
(52827, '1.6L 手动 时尚型', NULL, 4050, 0, NULL, 'H', 0, 5, 110543),
(52826, '1.6L 手动 豪华型', NULL, 4050, 0, NULL, 'H', 0, 5, 110542),
(52825, '1.6L 手动 尊贵型', NULL, 4050, 0, NULL, 'H', 0, 5, 110541),
(52824, '1.6L 自动 精英型', NULL, 4050, 0, NULL, 'H', 0, 5, 110540),
(52823, '1.6L 自动 舒适型', NULL, 4050, 0, NULL, 'H', 0, 5, 110539),
(52822, '1.6L 自动 尊贵型', NULL, 4050, 0, NULL, 'H', 0, 5, 106470),
(52821, 'SDX 1.6自动豪华型', NULL, 4049, 0, NULL, 'H', 0, 5, 1205),
(52820, 'STD 1.6自动标准型', NULL, 4049, 0, NULL, 'H', 0, 5, 1203),
(52819, 'GLS 1.6手动豪华型', NULL, 4049, 0, NULL, 'H', 0, 5, 1202),
(52818, 'GX 1.6手动普通型', NULL, 4049, 0, NULL, 'H', 0, 5, 1201),
(52817, 'GL 1.6手动标准型', NULL, 4049, 0, NULL, 'H', 0, 5, 1199),
(52816, '1.6MT新锐级', NULL, 4049, 0, NULL, 'H', 0, 5, 1192),
(52815, '新尊贵级', NULL, 4049, 0, NULL, 'H', 0, 5, 1191),
(52814, '新精英级', NULL, 4049, 0, NULL, 'H', 0, 5, 1190),
(52813, '1.8L精英级天窗版', NULL, 4048, 0, NULL, 'H', 0, 5, 1193),
(52812, '1.8L尊荣级LS', NULL, 4048, 0, NULL, 'H', 0, 5, 1189),
(52811, '1.8L精英级DX', NULL, 4048, 0, NULL, 'H', 0, 5, 1188),
(52810, '1.6L新悦级GL', NULL, 4048, 0, NULL, 'H', 0, 5, 1187),
(52809, '1.6L新贵级GLS', NULL, 4048, 0, NULL, 'H', 0, 5, 1186),
(52808, '1.6L 手动豪华型', NULL, 4047, 0, NULL, 'H', 0, 5, 1197),
(52807, '1.6L 手动标准型', NULL, 4047, 0, NULL, 'H', 0, 5, 1196),
(52806, '1.6L 自动豪华型', NULL, 4047, 0, NULL, 'H', 0, 5, 1195),
(52805, '1.6L 自动舒适型', NULL, 4047, 0, NULL, 'H', 0, 5, 1194),
(52804, 'GLS—1 1.6手动豪华型', NULL, 4046, 0, NULL, 'H', 0, 5, 1210),
(52803, 'SDX—1 1.6自动豪华型', NULL, 4046, 0, NULL, 'H', 0, 5, 1209),
(52802, 'DX 1.6自动舒适型', NULL, 4046, 0, NULL, 'H', 0, 5, 1204),
(52801, 'GLX 1.6手动舒适型', NULL, 4046, 0, NULL, 'H', 0, 5, 1200),
(52800, '福美来SPORTS', NULL, 4046, 0, NULL, 'H', 0, 5, 1198),
(52799, '超值天窗版', NULL, 4045, 0, NULL, 'H', 0, 5, 9809),
(52798, '自动超值版', NULL, 4045, 0, NULL, 'H', 0, 5, 8802),
(52797, '手动超值版', NULL, 4045, 0, NULL, 'H', 0, 5, 8798),
(52796, '自动舒适(DX)', NULL, 4045, 0, NULL, 'H', 0, 5, 7064),
(52795, '手动舒适(GLX)', NULL, 4045, 0, NULL, 'H', 0, 5, 7063),
(52794, '手动豪华(GLS)', NULL, 4045, 0, NULL, 'H', 0, 5, 7062),
(52793, '自动豪华(SDX)', NULL, 4045, 0, NULL, 'H', 0, 5, 7061),
(52792, '自动纪念版', NULL, 4044, 0, NULL, 'H', 0, 5, 11540),
(52791, '手动纪念版', NULL, 4044, 0, NULL, 'H', 0, 5, 11539),
(52790, '自动舒适版(DX)', NULL, 4044, 0, NULL, 'H', 0, 5, 10325),
(52789, '手动豪华版(GLS)', NULL, 4044, 0, NULL, 'H', 0, 5, 10323),
(52788, '手动舒适版(GLX)', NULL, 4044, 0, NULL, 'H', 0, 5, 10315),
(52787, '1.6L 自动宜居版', NULL, 4043, 0, NULL, 'H', 0, 5, 13313),
(52786, '1.6L 手动宜居版', NULL, 4043, 0, NULL, 'H', 0, 5, 13312),
(52785, '自动舒适型', NULL, 4043, 0, NULL, 'H', 0, 5, 12312),
(52784, '自动豪华型', NULL, 4043, 0, NULL, 'H', 0, 5, 12311),
(52783, '手动豪华型', NULL, 4043, 0, NULL, 'H', 0, 5, 12310),
(52782, '手动舒适型', NULL, 4043, 0, NULL, 'H', 0, 5, 12309),
(52781, '1.6L 自动 精英版', NULL, 4042, 0, NULL, 'H', 0, 5, 16604),
(52780, '1.6L 自动 旗舰版', NULL, 4042, 0, NULL, 'H', 0, 5, 16603),
(52779, '1.6L 自动 风尚版', NULL, 4042, 0, NULL, 'H', 0, 5, 16601),
(52778, '1.6L 手动 旗舰版', NULL, 4042, 0, NULL, 'H', 0, 5, 16600),
(52777, '1.6L 手动 精英版', NULL, 4042, 0, NULL, 'H', 0, 5, 16598),
(52776, '1.6L 手动 风尚版', NULL, 4042, 0, NULL, 'H', 0, 5, 16594),
(52775, '1.6L 手动 风尚版', NULL, 4041, 0, NULL, 'H', 0, 5, 104603),
(52774, '1.6L 手动 旗舰版', NULL, 4041, 0, NULL, 'H', 0, 5, 104602),
(52773, '1.6L 手动 精英版', NULL, 4041, 0, NULL, 'H', 0, 5, 104598),
(52772, '1.6L 自动 风尚版', NULL, 4041, 0, NULL, 'H', 0, 5, 104595),
(52771, '1.6L 自动 精英版', NULL, 4041, 0, NULL, 'H', 0, 5, 104594),
(52770, '1.6L 自动 旗舰版', NULL, 4041, 0, NULL, 'H', 0, 5, 104593),
(52769, '1.6L 手动 冠军版', NULL, 4041, 0, NULL, 'H', 0, 5, 102831),
(52768, '1.6L 手动 冠军纪念版', NULL, 4040, 0, NULL, 'H', 0, 5, 106056),
(52767, '1.0L 手动 双排', NULL, 4039, 0, NULL, 'H', 0, 5, 101660),
(52766, '1.0L 手动Ⅱ 单排', NULL, 4039, 0, NULL, 'H', 0, 5, 101659),
(52765, '1.0L 手动 单排', NULL, 4039, 0, NULL, 'H', 0, 5, 101658),
(52764, '标准型(HFJ6376 GZ502)', NULL, 4038, 0, NULL, 'H', 0, 5, 5374),
(52763, '豪华型(HFJ6376 GZ501)', NULL, 4038, 0, NULL, 'H', 0, 5, 5373),
(52762, 'HFJ6351', NULL, 4037, 0, NULL, 'H', 0, 5, 6421),
(52761, 'HFJ6371CGZ003', NULL, 4036, 0, NULL, 'H', 0, 5, 6429),
(52760, 'HFJ6371CGZ001', NULL, 4036, 0, NULL, 'H', 0, 5, 6428),
(52759, 'HFJ6371B GZ223J', NULL, 4036, 0, NULL, 'H', 0, 5, 6426),
(52758, 'HFJ6376 1.1L', NULL, 4035, 0, NULL, 'H', 0, 5, 6431),
(52757, 'HFJ6376 1.0L ', NULL, 4035, 0, NULL, 'H', 0, 5, 6430),
(52756, 'HFJ6371B GZ005J', NULL, 4035, 0, NULL, 'H', 0, 5, 6425),
(52755, 'HFJ6371B GZ002J', NULL, 4035, 0, NULL, 'H', 0, 5, 6424),
(52754, 'HFJ6376-014', NULL, 4034, 0, NULL, 'H', 0, 5, 6432),
(52753, 'HFJ6371B-242', NULL, 4034, 0, NULL, 'H', 0, 5, 6427),
(52752, 'HFJ6371B', NULL, 4034, 0, NULL, 'H', 0, 5, 6423),
(52751, 'HFJ6371', NULL, 4034, 0, NULL, 'H', 0, 5, 6422),
(52750, '买断型(HFJ6376—GZ402T)', NULL, 4033, 0, NULL, 'H', 0, 5, 11627),
(52749, '基本型(HFJ6376D4)', NULL, 4033, 0, NULL, 'H', 0, 5, 11626),
(52748, '基本型(HFJ6376—GZ401T)', NULL, 4033, 0, NULL, 'H', 0, 5, 5852),
(52747, 'V5 1.0L 手动 舒适型', NULL, 4032, 0, NULL, 'H', 0, 5, 103430),
(52746, 'V5 1.0L 手动 豪华型', NULL, 4032, 0, NULL, 'H', 0, 5, 103429),
(52745, 'V5 1.3L 手动 舒适型', NULL, 4032, 0, NULL, 'H', 0, 5, 103428),
(52744, 'V5 1.3L 手动 豪华型', NULL, 4032, 0, NULL, 'H', 0, 5, 103422),
(52743, '1.0L 手动 空调型 M10R', NULL, 4031, 0, NULL, 'H', 0, 5, 101225),
(52742, '1.0L 手动 基本型 M10R', NULL, 4031, 0, NULL, 'H', 0, 5, 101224),
(52741, '1.0L 手动 空调型 DA465QA+STT', NULL, 4031, 0, NULL, 'H', 0, 5, 101223),
(52740, '1.0L 手动 基本型 DA465QA+STT', NULL, 4031, 0, NULL, 'H', 0, 5, 101222),
(52739, '1.0L 手动 空调型 DA465QA', NULL, 4031, 0, NULL, 'H', 0, 5, 101221),
(52738, '1.0L 手动 基本型 DA465QA', NULL, 4031, 0, NULL, 'H', 0, 5, 101220),
(52737, '1.0L 手动 基本型 DA465Q', NULL, 4031, 0, NULL, 'H', 0, 5, 101219),
(52736, '1.0L 手动 标准型 HFJ6372A4B-GZ000', NULL, 4030, 0, NULL, 'H', 0, 5, 104316),
(52735, '1.0L 手动 空调型 科技版', NULL, 4030, 0, NULL, 'H', 0, 5, 101993),
(52734, '1.0L 手动 基本型 科技版', NULL, 4030, 0, NULL, 'H', 0, 5, 101992),
(52733, 'HFJ6330A', NULL, 4029, 0, NULL, 'H', 0, 5, 9054),
(52732, 'HFJ6373B-012B1 ', NULL, 4028, 0, NULL, 'H', 0, 5, 6783),
(52731, 'HFJ6373B-009J', NULL, 4028, 0, NULL, 'H', 0, 5, 6782),
(52730, 'HFJ6373B-009B1', NULL, 4028, 0, NULL, 'H', 0, 5, 6781),
(52729, 'HFJ7130A(手动)', NULL, 4027, 0, NULL, 'H', 0, 5, 1076),
(52728, 'HFJ7130(手动)', NULL, 4027, 0, NULL, 'H', 0, 5, 1072),
(52727, 'HFJ7160E3—GZ201', NULL, 4026, 0, NULL, 'H', 0, 5, 5467),
(52726, 'HFJ7160(自动)', NULL, 4026, 0, NULL, 'H', 0, 5, 1074),
(52725, 'HFJ7160(手动)', NULL, 4026, 0, NULL, 'H', 0, 5, 1073),
(52724, 'HFJ7130E3 GZ202', NULL, 4025, 0, NULL, 'H', 0, 5, 5466),
(52723, 'HFJ7160BE28 GZ003', NULL, 4025, 0, NULL, 'H', 0, 5, 1075),
(52722, '7130E3—GZ201', NULL, 4024, 0, NULL, 'H', 0, 5, 5854),
(52721, '7130E—GZ201', NULL, 4024, 0, NULL, 'H', 0, 5, 5853),
(52720, 'HFJ7160GZ002', NULL, 4024, 0, NULL, 'H', 0, 5, 1082),
(52719, 'HFJ7130GZ201', NULL, 4024, 0, NULL, 'H', 0, 5, 1080),
(52718, 'HFJ7130GZ005', NULL, 4024, 0, NULL, 'H', 0, 5, 1079),
(52717, 'HFJ7130—005', NULL, 4024, 0, NULL, 'H', 0, 5, 1078),
(52716, 'HFJ7160—201', NULL, 4024, 0, NULL, 'H', 0, 5, 1077),
(52715, 'HFJ7130E GZ202', NULL, 4023, 0, NULL, 'H', 0, 5, 5377),
(52714, 'HFJ7160 GZ004', NULL, 4023, 0, NULL, 'H', 0, 5, 1087),
(52713, 'HFJ7160E—GZ202', NULL, 4023, 0, NULL, 'H', 0, 5, 1086),
(52712, 'HFJ7160E', NULL, 4023, 0, NULL, 'H', 0, 5, 1085),
(52711, 'HFJ7130 GZ001', NULL, 4023, 0, NULL, 'H', 0, 5, 1084),
(52710, 'HFJ7130E', NULL, 4023, 0, NULL, 'H', 0, 5, 1083),
(52709, 'HFJ7160E—GZ201', NULL, 4023, 0, NULL, 'H', 0, 5, 1081),
(52708, '1.5L 手动 舒适型 HFJ7152E4-GZ000', NULL, 4022, 0, NULL, 'H', 0, 5, 104311),
(52707, '新时代赛马 1.5L手动豪华型', NULL, 4022, 0, NULL, 'H', 0, 5, 8226),
(52706, '新时代赛马 1.5L手动舒适型', NULL, 4022, 0, NULL, 'H', 0, 5, 8225),
(52705, '新时代赛马 1.5L手动标准型', NULL, 4022, 0, NULL, 'H', 0, 5, 8224),
(52704, '1.5L HFJ7152E4—GZ002', NULL, 4022, 0, NULL, 'H', 0, 5, 8199),
(52703, '1.5L HFJ7152E4', NULL, 4022, 0, NULL, 'H', 0, 5, 8198),
(52702, '1.5L HFJ7152E4—GZ001', NULL, 4022, 0, NULL, 'H', 0, 5, 8193),
(52701, 'HFJ7182', NULL, 4021, 0, NULL, 'H', 0, 5, 4230),
(52700, 'HFJ7162', NULL, 4021, 0, NULL, 'H', 0, 5, 4229),
(52699, '1.8手动豪华型', NULL, 4020, 0, NULL, 'H', 0, 5, 10385),
(52698, '1.8手自一体 标准型', NULL, 4020, 0, NULL, 'H', 0, 5, 10384),
(52697, '1.6手自一体 标准型', NULL, 4020, 0, NULL, 'H', 0, 5, 10383),
(52696, '2.0L 手动', NULL, 4019, 0, NULL, 'H', 0, 5, 9116),
(52695, '标准型 国Ⅳ', NULL, 4019, 0, NULL, 'H', 0, 5, 8204),
(52694, '标准型 国Ⅲ', NULL, 4019, 0, NULL, 'H', 0, 5, 8200),
(52693, '7161E—GZ604', NULL, 4019, 0, NULL, 'H', 0, 5, 5864),
(52692, '7161E—GZ602', NULL, 4019, 0, NULL, 'H', 0, 5, 5461),
(52691, '7161E—GZ601', NULL, 4019, 0, NULL, 'H', 0, 5, 5459),
(52690, 'HFJ7161E—GZ405 手动豪华型', NULL, 4018, 0, NULL, 'H', 0, 5, 10382),
(52689, 'HFJ7161E—GZ403 自动超值实用', NULL, 4018, 0, NULL, 'H', 0, 5, 10381),
(52688, 'HFJ7161E—GZ401 自动标准型', NULL, 4018, 0, NULL, 'H', 0, 5, 10380),
(52687, 'HFJ7161E—GZ401 手动标准型', NULL, 4018, 0, NULL, 'H', 0, 5, 10379),
(52686, 'HFJ7161E—GZ103 自动豪华型', NULL, 4018, 0, NULL, 'H', 0, 5, 10378),
(52685, '豪华型 国Ⅳ', NULL, 4018, 0, NULL, 'H', 0, 5, 8207),
(52684, '豪华型 国Ⅲ', NULL, 4018, 0, NULL, 'H', 0, 5, 8203),
(52683, '1.6自动豪华型 国III', NULL, 4018, 0, NULL, 'H', 0, 5, 5462),
(52682, '1.6自动豪华型 国IV', NULL, 4018, 0, NULL, 'H', 0, 5, 4228),
(52681, '天窗版 国Ⅳ', NULL, 4017, 0, NULL, 'H', 0, 5, 8206),
(52680, '舒适型 国Ⅳ', NULL, 4017, 0, NULL, 'H', 0, 5, 8205),
(52679, '天窗版 国Ⅲ', NULL, 4017, 0, NULL, 'H', 0, 5, 8202),
(52678, '舒适型 国Ⅲ', NULL, 4017, 0, NULL, 'H', 0, 5, 8201),
(52677, 'HFJ1020GD4', NULL, 4016, 0, NULL, 'H', 0, 5, 5475),
(52676, 'HFJ1020GDE3', NULL, 4016, 0, NULL, 'H', 0, 5, 5474),
(52675, 'HFJ1011GDE3', NULL, 4016, 0, NULL, 'H', 0, 5, 5473),
(52674, 'HFJ1011GDE—GZ201J', NULL, 4016, 0, NULL, 'H', 0, 5, 5472),
(52673, 'HFJ1011GDE', NULL, 4016, 0, NULL, 'H', 0, 5, 5471),
(52672, 'HFJ1011GDAE', NULL, 4016, 0, NULL, 'H', 0, 5, 4247),
(52671, 'HFJ1011H', NULL, 4016, 0, NULL, 'H', 0, 5, 4246),
(52670, 'HFJ1011G', NULL, 4016, 0, NULL, 'H', 0, 5, 4245),
(52669, 'HFJ6351C（化油器）', NULL, 4015, 0, NULL, 'H', 0, 5, 6355),
(52668, 'HFJ6373B', NULL, 4014, 0, NULL, 'H', 0, 5, 4243),
(52667, 'HFJ6373B-012B1', NULL, 4013, 0, NULL, 'H', 0, 5, 6357),
(52666, 'HFJ6373B-009B1', NULL, 4013, 0, NULL, 'H', 0, 5, 6356),
(52665, 'HFJ1011GB 厢货', NULL, 4013, 0, NULL, 'H', 0, 5, 1179),
(52664, 'HFJ1011H 双排', NULL, 4013, 0, NULL, 'H', 0, 5, 1178),
(52663, 'HFJ1011GB', NULL, 4013, 0, NULL, 'H', 0, 5, 1177),
(52662, 'HFJ5012XXYB 厢货', NULL, 4012, 0, NULL, 'H', 0, 5, 1180),
(52661, 'HFJ1020AE', NULL, 4011, 0, NULL, 'H', 0, 5, 4244),
(52660, '1.0L 手动 标准型 双排 HFJ1021HBE4-GZ203', NULL, 4010, 0, NULL, 'H', 0, 5, 104319),
(52659, '1.0L 手动 标准型 单排 HFJ1021GBE4-GZ102', NULL, 4010, 0, NULL, 'H', 0, 5, 104318),
(52658, '双排 1.0L 手动 基本型', NULL, 4010, 0, NULL, 'H', 0, 5, 16307),
(52657, '双排 1.0L 手动 空调型', NULL, 4010, 0, NULL, 'H', 0, 5, 16306),
(52656, '单排 1.1L 手动 空调型', NULL, 4010, 0, NULL, 'H', 0, 5, 16305),
(52655, '单排 1.1L 手动 基本型', NULL, 4010, 0, NULL, 'H', 0, 5, 16304),
(52654, 'HFJ6391 DA465Q-1A', NULL, 4009, 0, NULL, 'H', 0, 5, 5378),
(52653, 'HFJ6391A', NULL, 4009, 0, NULL, 'H', 0, 5, 4235),
(52652, 'HFJ6391 DA465Q', NULL, 4009, 0, NULL, 'H', 0, 5, 4234),
(52651, '空调型 国IV', NULL, 4008, 0, NULL, 'H', 0, 5, 10924),
(52650, '基本型 国IV', NULL, 4008, 0, NULL, 'H', 0, 5, 10923),
(52649, '基本型 国III+OBD', NULL, 4008, 0, NULL, 'H', 0, 5, 10922),
(52648, '豪华型 国III', NULL, 4008, 0, NULL, 'H', 0, 5, 10921),
(52647, '标准型 国III', NULL, 4008, 0, NULL, 'H', 0, 5, 10920),
(52646, '基本型 国III', NULL, 4008, 0, NULL, 'H', 0, 5, 10919),
(52645, '清爽版 国III', NULL, 4008, 0, NULL, 'H', 0, 5, 10918),
(52644, '超值版 国III', NULL, 4008, 0, NULL, 'H', 0, 5, 10917),
(52643, '豪华型（HFJ6370E—GZ602）', NULL, 4008, 0, NULL, 'H', 0, 5, 5477),
(52642, '标准型（HFJ6370E—GZ601）', NULL, 4008, 0, NULL, 'H', 0, 5, 5476),
(52641, '基本型（HFJ6370E—GZ501）', NULL, 4008, 0, NULL, 'H', 0, 5, 4236),
(52640, 'HFJ6370H GZ105J', NULL, 4007, 0, NULL, 'H', 0, 5, 6233),
(52639, 'HFJ6379G', NULL, 4006, 0, NULL, 'H', 0, 5, 6244),
(52638, 'HFJ6373B GZ009', NULL, 4006, 0, NULL, 'H', 0, 5, 6243),
(52637, 'HFJ6370H-115J', NULL, 4006, 0, NULL, 'H', 0, 5, 6238),
(52636, 'HFJ6370H GZ117', NULL, 4006, 0, NULL, 'H', 0, 5, 6237),
(52635, 'HFJ6370H GZ116', NULL, 4006, 0, NULL, 'H', 0, 5, 6236),
(52634, 'HFJ6370H GZ107J', NULL, 4006, 0, NULL, 'H', 0, 5, 6235),
(52633, 'HFJ6370H GZ106J', NULL, 4006, 0, NULL, 'H', 0, 5, 6234),
(52632, 'HFJ6370H', NULL, 4006, 0, NULL, 'H', 0, 5, 6232),
(52631, 'HFJ6370G GZ108', NULL, 4006, 0, NULL, 'H', 0, 5, 6227),
(52630, 'HFJ6370-U105', NULL, 4005, 0, NULL, 'H', 0, 5, 6242),
(52629, 'HFJ6370-U102', NULL, 4005, 0, NULL, 'H', 0, 5, 6241),
(52628, 'HFJ6370-H145', NULL, 4005, 0, NULL, 'H', 0, 5, 6240),
(52627, 'HFJ6370-H142', NULL, 4005, 0, NULL, 'H', 0, 5, 6239),
(52626, 'HFJ6370-G127', NULL, 4005, 0, NULL, 'H', 0, 5, 6231),
(52625, 'HFJ6370-G126', NULL, 4005, 0, NULL, 'H', 0, 5, 6230),
(52624, 'HFJ6370-G003', NULL, 4005, 0, NULL, 'H', 0, 5, 6229),
(52623, 'HFJ6370-G001', NULL, 4005, 0, NULL, 'H', 0, 5, 6228),
(52622, '1.0L 手动 豪华型 HFJ6392BE4-GZ107', NULL, 4004, 0, NULL, 'H', 0, 5, 104313),
(52621, '1.0L 手动 标准型 HFJ6392BE4-GZ106', NULL, 4004, 0, NULL, 'H', 0, 5, 104312),
(52620, '1.0L 手动 基本型 国IV', NULL, 4004, 0, NULL, 'H', 0, 5, 101656),
(52619, '心动版 豪华型', NULL, 4004, 0, NULL, 'H', 0, 5, 10927),
(52618, '心动版 舒适型', NULL, 4004, 0, NULL, 'H', 0, 5, 10926),
(52617, '心动版 标准型', NULL, 4004, 0, NULL, 'H', 0, 5, 10925),
(52616, '小霸王 豪华型 HFJ6392BE4 国Ⅳ', NULL, 4004, 0, NULL, 'H', 0, 5, 8496),
(52615, '小霸王 标准型 HFJ6392BE4 国Ⅳ', NULL, 4004, 0, NULL, 'H', 0, 5, 8495),
(52614, '小霸王 基本型 HFJ6392BE4 国Ⅳ', NULL, 4004, 0, NULL, 'H', 0, 5, 8494),
(52613, '小霸王 豪华型 HFJ6392BE 国Ⅲ', NULL, 4004, 0, NULL, 'H', 0, 5, 8493),
(52612, '小霸王 标准型 HFJ6392BE 国Ⅲ', NULL, 4004, 0, NULL, 'H', 0, 5, 8492),
(52611, '小霸王 基本型 HFJ6392BE 国Ⅲ', NULL, 4004, 0, NULL, 'H', 0, 5, 8491),
(52610, '大霸王 尊荣型 HFJ6420AE—GZ102 国Ⅲ', NULL, 4003, 0, NULL, 'H', 0, 5, 8209),
(52609, '大霸王 尊荣型 HFJ6420AE4—GZ102 国IV', NULL, 4002, 0, NULL, 'H', 0, 5, 8211),
(52608, '大霸王 尊贵型 HFJ6420AE4 国IV', NULL, 4002, 0, NULL, 'H', 0, 5, 8210),
(52607, '1.5L 尊贵型 国四', NULL, 4001, 0, NULL, 'H', 0, 5, 12478),
(52606, '1.5L 尊享型 国四', NULL, 4001, 0, NULL, 'H', 0, 5, 12477),
(52605, '1.5L 尊贵型 国三', NULL, 4001, 0, NULL, 'H', 0, 5, 12476),
(52604, '1.3L 舒适型 国三', NULL, 4001, 0, NULL, 'H', 0, 5, 12475),
(52603, '1.3L 标准型 国三', NULL, 4001, 0, NULL, 'H', 0, 5, 12474),
(52602, '尊荣型 HFJ6420AE4-GZ003 国IV', NULL, 4001, 0, NULL, 'H', 0, 5, 10932),
(52601, '尊荣型 HFJ6420AE-GZ004 国Ⅲ', NULL, 4001, 0, NULL, 'H', 0, 5, 10931),
(52600, '尊贵型 HFJ6420AE4-GZ002 国IV', NULL, 4001, 0, NULL, 'H', 0, 5, 10930),
(52599, '尊贵型 HFJ6420AE-GZ002 国Ⅲ', NULL, 4001, 0, NULL, 'H', 0, 5, 10929),
(52598, '大霸王 尊贵型 HFJ6420AE 国Ⅲ', NULL, 4000, 0, NULL, 'H', 0, 5, 8208),
(52597, '1.1L舒适型7110E3—GZ202（带OBD）', NULL, 3999, 0, NULL, 'H', 0, 5, 5991),
(52596, '1.1L舒适型7110E—GZ202', NULL, 3999, 0, NULL, 'H', 0, 5, 5990),
(52595, 'HFJ7110 GZ201', NULL, 3998, 0, NULL, 'H', 0, 5, 10375),
(52594, 'HFJ7100 GZ058', NULL, 3998, 0, NULL, 'H', 0, 5, 10374),
(52593, 'HFJ7110 GZ012/014', NULL, 3998, 0, NULL, 'H', 0, 5, 10373),
(52592, 'HFJ7110 GZ010', NULL, 3998, 0, NULL, 'H', 0, 5, 10372),
(52591, 'HFJ7110 GZ006', NULL, 3998, 0, NULL, 'H', 0, 5, 10370),
(52590, 'HFJ7110 GZ005', NULL, 3998, 0, NULL, 'H', 0, 5, 10369),
(52589, 'HFJ7110 GZ002', NULL, 3998, 0, NULL, 'H', 0, 5, 10368),
(52588, 'HFJ7110 GZ001/002', NULL, 3998, 0, NULL, 'H', 0, 5, 10367),
(52587, 'HFJ7110 GZ001', NULL, 3998, 0, NULL, 'H', 0, 5, 10366),
(52586, 'HFJ7100 GZ006', NULL, 3998, 0, NULL, 'H', 0, 5, 6218),
(52585, 'HFJ7100 GZ005', NULL, 3998, 0, NULL, 'H', 0, 5, 6217),
(52584, 'HFJ7100 GZ002', NULL, 3998, 0, NULL, 'H', 0, 5, 6216),
(52583, 'HFJ7100 GZ001', NULL, 3998, 0, NULL, 'H', 0, 5, 6215),
(52582, 'HFJ7110 GZ039', NULL, 3998, 0, NULL, 'H', 0, 5, 6208),
(52581, 'HFJ7110 GZ030', NULL, 3998, 0, NULL, 'H', 0, 5, 6207),
(52580, 'HFJ7110 GZ022', NULL, 3998, 0, NULL, 'H', 0, 5, 6206),
(52579, 'HFJ7110 GZ020', NULL, 3998, 0, NULL, 'H', 0, 5, 6205),
(52578, '1.3标准型7133E—GZ008', NULL, 3997, 0, NULL, 'H', 0, 5, 10371),
(52577, 'HFJ7110 GZ057', NULL, 3997, 0, NULL, 'H', 0, 5, 6210),
(52576, 'HFJ7110 GZ044', NULL, 3997, 0, NULL, 'H', 0, 5, 6209),
(52575, '1.1 手动智能版', NULL, 3996, 0, NULL, 'H', 0, 5, 10377),
(52574, '1.1 手动运动版', NULL, 3996, 0, NULL, 'H', 0, 5, 10376),
(52573, 'HFJ7100-056', NULL, 3996, 0, NULL, 'H', 0, 5, 6221),
(52572, 'HFJ7100-029 ', NULL, 3996, 0, NULL, 'H', 0, 5, 6220),
(52571, 'HFJ7100 GZ033', NULL, 3996, 0, NULL, 'H', 0, 5, 6219),
(52570, 'HFJ7100', NULL, 3996, 0, NULL, 'H', 0, 5, 6214),
(52569, 'HFJ7110-GZ058', NULL, 3996, 0, NULL, 'H', 0, 5, 6213),
(52568, 'HFJ7110-058', NULL, 3996, 0, NULL, 'H', 0, 5, 6212),
(52567, 'HFJ7110-033', NULL, 3996, 0, NULL, 'H', 0, 5, 6211),
(52566, '1.0手动超值实用版', NULL, 3995, 0, NULL, 'H', 0, 5, 10365),
(52565, '1.3L豪华型7133E3—GZ201(带OBD)', NULL, 3995, 0, NULL, 'H', 0, 5, 5993),
(52564, '1.3L豪华型7133E—GZ201', NULL, 3995, 0, NULL, 'H', 0, 5, 5992),
(52563, '节油π升级版 舒适型', NULL, 3994, 0, NULL, 'H', 0, 5, 9211),
(52562, '节油π升级版 标准型', NULL, 3994, 0, NULL, 'H', 0, 5, 9210),
(52561, '节油π 1.3豪华型', NULL, 3994, 0, NULL, 'H', 0, 5, 8192),
(52560, '节油π 1.1手动标准型', NULL, 3994, 0, NULL, 'H', 0, 5, 8188),
(52559, '节油π 1.3手动豪华型', NULL, 3994, 0, NULL, 'H', 0, 5, 8187),
(52558, '节油π 1.1自动舒适型', NULL, 3994, 0, NULL, 'H', 0, 5, 8186),
(52557, '节油π 1.1手动舒适型', NULL, 3994, 0, NULL, 'H', 0, 5, 8185),
(52556, '节油π 1.1自动标准型', NULL, 3994, 0, NULL, 'H', 0, 5, 8184),
(52555, '节油π 1.1标准型', NULL, 3994, 0, NULL, 'H', 0, 5, 8183),
(52554, '节油π 1.1舒适型', NULL, 3994, 0, NULL, 'H', 0, 5, 7329),
(52553, '1.0 手动典藏版', NULL, 3994, 0, NULL, 'H', 0, 5, 7147);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(52552, '节油π  自动档舒适型 国IV', NULL, 3993, 0, NULL, 'H', 0, 5, 8191),
(52551, '节油π  舒适型 国IV', NULL, 3993, 0, NULL, 'H', 0, 5, 8190),
(52550, '节油π  自动档标准型 国IV', NULL, 3993, 0, NULL, 'H', 0, 5, 8189),
(52549, '1.0 东北特供版', NULL, 3993, 0, NULL, 'H', 0, 5, 8182),
(52548, '1.0 典藏版', NULL, 3993, 0, NULL, 'H', 0, 5, 8181),
(52547, '灵动1.3手动舒适型', NULL, 3992, 0, NULL, 'H', 0, 5, 10978),
(52546, '灵动1.1自动豪华型', NULL, 3992, 0, NULL, 'H', 0, 5, 10977),
(52545, '灵动1.1自动舒适型', NULL, 3992, 0, NULL, 'H', 0, 5, 10976),
(52544, '灵动1.1手动豪华型', NULL, 3992, 0, NULL, 'H', 0, 5, 10975),
(52543, '灵动1.1手动舒适型', NULL, 3992, 0, NULL, 'H', 0, 5, 10974),
(52542, '灵动1.0手动豪华型', NULL, 3992, 0, NULL, 'H', 0, 5, 10973),
(52541, '灵动1.0手动舒适型', NULL, 3992, 0, NULL, 'H', 0, 5, 10972),
(52540, '节油π 升级版 1.0手动豪华型', NULL, 3992, 0, NULL, 'H', 0, 5, 10928),
(52539, '节油π 升级版 1.0手动舒适型', NULL, 3992, 0, NULL, 'H', 0, 5, 5989),
(52538, '节油π 升级版 1.0手动标准型', NULL, 3992, 0, NULL, 'H', 0, 5, 4231),
(52537, '1.0L 手动 舒适型 HFJ7100C4C-GZ000', NULL, 3991, 0, NULL, 'H', 0, 5, 104309),
(52536, '1.0L 手动 超值版', NULL, 3991, 0, NULL, 'H', 0, 5, 101988),
(52535, '舒适型 国IV', NULL, 3991, 0, NULL, 'H', 0, 5, 101655),
(52534, '基本型 国IV', NULL, 3991, 0, NULL, 'H', 0, 5, 101654),
(52533, '灵动 1.1L 手动 豪华型', NULL, 3991, 0, NULL, 'H', 0, 5, 16609),
(52532, '灵动 1.1L 手动 舒适型', NULL, 3991, 0, NULL, 'H', 0, 5, 16608),
(52531, '1.3L 手动 超值版', NULL, 3990, 0, NULL, 'H', 0, 5, 101657),
(52530, 'HFJ6400A4C-GZ002 手动 豪华型', NULL, 3990, 0, NULL, 'H', 0, 5, 15059),
(52529, 'HFJ6400A4C-GZ001 手动 舒适型(铝轮)', NULL, 3990, 0, NULL, 'H', 0, 5, 15058),
(52528, 'HFJ6400A4C-GZ001 手动 空调型', NULL, 3990, 0, NULL, 'H', 0, 5, 15057),
(52527, 'HFJ6400A4C 手动 标准型(铝轮)', NULL, 3990, 0, NULL, 'H', 0, 5, 15056),
(52526, 'HFJ6400B4C', NULL, 3990, 0, NULL, 'H', 0, 5, 14279),
(52525, 'HFJ6400A4C 手动 基本型', NULL, 3990, 0, NULL, 'H', 0, 5, 14278),
(52524, '1.3L 手动 舒适型 HFJ6400A4Y-GZ001', NULL, 3989, 0, NULL, 'H', 0, 5, 104315),
(52523, '1.3L 手动 标准型 HFJ6400A4Y-GZ000', NULL, 3989, 0, NULL, 'H', 0, 5, 104314),
(52522, '1.0L 手动 空调型 科技版', NULL, 3989, 0, NULL, 'H', 0, 5, 101991),
(52521, '1.0L 手动 基本型 科技版', NULL, 3989, 0, NULL, 'H', 0, 5, 101990),
(52520, '1.3L 手动 超值版', NULL, 3989, 0, NULL, 'H', 0, 5, 101989),
(52519, 'HFJ1010HA/D', NULL, 3988, 0, NULL, 'H', 0, 5, 4249),
(52518, 'HFJ1010GA/D', NULL, 3988, 0, NULL, 'H', 0, 5, 4248),
(52517, 'HFJ1020GBD4 单排', NULL, 3987, 0, NULL, 'H', 0, 5, 11633),
(52516, 'HFJ1020GDBE 单排', NULL, 3987, 0, NULL, 'H', 0, 5, 11632),
(52515, 'HFJ1020GD4 单排', NULL, 3987, 0, NULL, 'H', 0, 5, 11631),
(52514, 'HFJ1011GDE 单排', NULL, 3987, 0, NULL, 'H', 0, 5, 11630),
(52513, 'HFJ1011HE  双排', NULL, 3987, 0, NULL, 'H', 0, 5, 11629),
(52512, 'HFJ1020HBE 双排', NULL, 3987, 0, NULL, 'H', 0, 5, 11628),
(52511, 'HFJ7090', NULL, 3986, 0, NULL, 'H', 0, 5, 6799),
(52510, '1.6L 手动 致享型', NULL, 3985, 0, NULL, 'G', 0, 5, 110825),
(52509, '1.6L 自动 致悦型	', NULL, 3985, 0, NULL, 'G', 0, 5, 110824),
(52508, '1.6L 自动 致悦增强型	', NULL, 3985, 0, NULL, 'G', 0, 5, 110823),
(52507, '1.6T 自动 致悦增强型	', NULL, 3985, 0, NULL, 'G', 0, 5, 110822),
(52506, '1.6T 自动 致臻型 ', NULL, 3985, 0, NULL, 'G', 0, 5, 109916),
(52505, '1.6L 手动 致享型', NULL, 3984, 0, NULL, 'G', 0, 5, 106074),
(52504, '1.6L 手动 致悦型', NULL, 3984, 0, NULL, 'G', 0, 5, 106073),
(52503, '1.6L 自动 致悦型', NULL, 3984, 0, NULL, 'G', 0, 5, 106072),
(52502, '1.6L 自动 致悦型增强版', NULL, 3984, 0, NULL, 'G', 0, 5, 106071),
(52501, '1.6T 自动 致悦型增强版', NULL, 3984, 0, NULL, 'G', 0, 5, 106070),
(52500, '1.6T 自动 致臻型', NULL, 3984, 0, NULL, 'G', 0, 5, 103576),
(52499, '2.0L 手动 周年限量版', NULL, 3983, 0, NULL, 'G', 0, 5, 103400),
(52498, '2.0L 手动 精英ESP版', NULL, 3983, 0, NULL, 'G', 0, 5, 102063),
(52497, '2.0L 自动 周年纪念版', NULL, 3983, 0, NULL, 'G', 0, 5, 101912),
(52496, '2.0L 自动 尊贵版', NULL, 3983, 0, NULL, 'G', 0, 5, 16241),
(52495, '2.0L 自动 豪华版', NULL, 3983, 0, NULL, 'G', 0, 5, 16240),
(52494, '2.0L 自动 精英版', NULL, 3983, 0, NULL, 'G', 0, 5, 16239),
(52493, '2.0L 手动 豪华版', NULL, 3983, 0, NULL, 'G', 0, 5, 16237),
(52492, '2.0L 手动 精英版', NULL, 3983, 0, NULL, 'G', 0, 5, 16234),
(52491, '2.0L 手动 舒适版', NULL, 3983, 0, NULL, 'G', 0, 5, 16231),
(52490, '1.8T 自动 四驱 5周年纪念版', NULL, 3982, 0, NULL, 'G', 0, 5, 105342),
(52489, '1.8T 自动 两驱 5周年纪念版', NULL, 3982, 0, NULL, 'G', 0, 5, 105341),
(52488, '1.8T 手动 两驱 精英版', NULL, 3982, 0, NULL, 'G', 0, 5, 102928),
(52487, '1.8T 自动 两驱 精英版', NULL, 3982, 0, NULL, 'G', 0, 5, 102927),
(52486, '1.8T 自动 两驱 豪华版', NULL, 3982, 0, NULL, 'G', 0, 5, 102926),
(52485, '1.8T 自动 四驱 豪华版', NULL, 3982, 0, NULL, 'G', 0, 5, 102925),
(52484, '1.8T 自动 四驱 尊贵版', NULL, 3982, 0, NULL, 'G', 0, 5, 102921),
(52483, '1.8T 自动 四驱 至尊版', NULL, 3982, 0, NULL, 'G', 0, 5, 16243),
(52482, '2.0L 手自一体  两驱 周年增值版', NULL, 3981, 0, NULL, 'G', 0, 5, 111500),
(52481, '2.0L 手动 两驱 周年增值版', NULL, 3981, 0, NULL, 'G', 0, 5, 111137),
(52480, '1.8T 自动 前驱 超享版', NULL, 3981, 0, NULL, 'G', 0, 5, 110134),
(52479, '2.0L 自动 前驱 超享版', NULL, 3981, 0, NULL, 'G', 0, 5, 110133),
(52478, '2.0L AT尊贵版', NULL, 3980, 0, NULL, 'G', 0, 5, 12719),
(52477, '2.0L RMT尊贵版', NULL, 3980, 0, NULL, 'G', 0, 5, 12718),
(52476, '2.0L AT豪华版', NULL, 3980, 0, NULL, 'G', 0, 5, 12717),
(52475, '2.0L AT精英版', NULL, 3980, 0, NULL, 'G', 0, 5, 12716),
(52474, '2.0L MT精英版', NULL, 3980, 0, NULL, 'G', 0, 5, 12715),
(52473, '2.0L MT舒适版', NULL, 3980, 0, NULL, 'G', 0, 5, 12704),
(52472, '2.0L 自动 尊贵版', NULL, 3979, 0, NULL, 'G', 0, 5, 15683),
(52471, '2.0L 手自一体 尊贵版', NULL, 3979, 0, NULL, 'G', 0, 5, 15682),
(52470, '2.0L 自动 豪华版', NULL, 3979, 0, NULL, 'G', 0, 5, 15680),
(52469, '2.0L 自动 精英版', NULL, 3979, 0, NULL, 'G', 0, 5, 15679),
(52468, '2.0L 手动 精英版', NULL, 3979, 0, NULL, 'G', 0, 5, 15678),
(52467, '2.0L 手动 舒适版', NULL, 3979, 0, NULL, 'G', 0, 5, 15676),
(52466, '1.8L 自动 尊贵版', NULL, 3979, 0, NULL, 'G', 0, 5, 14617),
(52465, '1.8L 自动 豪华版', NULL, 3979, 0, NULL, 'G', 0, 5, 14616),
(52464, '1.8L 手动 精英版', NULL, 3979, 0, NULL, 'G', 0, 5, 14615),
(52463, '1.8L 手动 舒适版', NULL, 3979, 0, NULL, 'G', 0, 5, 14614),
(52462, '1.8T 自动 5周年行政版', NULL, 3978, 0, NULL, 'G', 0, 5, 105200),
(52461, '1.8T 自动 5周年纪念版', NULL, 3978, 0, NULL, 'G', 0, 5, 105196),
(52460, '1.8T 自动 舒适版', NULL, 3978, 0, NULL, 'G', 0, 5, 103236),
(52459, '1.8T 自动 精英版', NULL, 3978, 0, NULL, 'G', 0, 5, 103235),
(52458, '1.8T 自动 豪华版', NULL, 3978, 0, NULL, 'G', 0, 5, 103234),
(52457, '1.8T 自动 尊贵版', NULL, 3978, 0, NULL, 'G', 0, 5, 103233),
(52456, '1.8T 自动 至尊版', NULL, 3978, 0, NULL, 'G', 0, 5, 103231),
(52455, '2.0L 自动 豪华版', NULL, 3978, 0, NULL, 'G', 0, 5, 102753),
(52454, '2.0L 自动 精英版', NULL, 3978, 0, NULL, 'G', 0, 5, 102750),
(52453, '1.8L 自动 豪华版', NULL, 3978, 0, NULL, 'G', 0, 5, 102749),
(52452, '1.8L 手动 精英版', NULL, 3978, 0, NULL, 'G', 0, 5, 102748),
(52451, '1.8L 手动 舒适版', NULL, 3978, 0, NULL, 'G', 0, 5, 102747),
(52450, '1.6L 自动 至尊ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104777),
(52449, '1.6L 自动 尊贵ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104776),
(52448, '1.6L 自动 精英ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104775),
(52447, '1.6L 自动 豪华ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104774),
(52446, '1.6L 手动 尊贵ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104773),
(52445, '1.6L 手动 豪华ESP版', NULL, 3977, 0, NULL, 'G', 0, 5, 104772),
(52444, '1.6L 手动 精英版', NULL, 3977, 0, NULL, 'G', 0, 5, 104771),
(52443, '1.6L 手动 豪华版', NULL, 3977, 0, NULL, 'G', 0, 5, 104565),
(52442, '1.6L 自动 精英智慧版', NULL, 3976, 0, NULL, 'G', 0, 5, 110676),
(52441, '1.6L 自动 智慧版', NULL, 3976, 0, NULL, 'G', 0, 5, 106245),
(52440, '厢式车 YC5045XXYC3H', NULL, 3975, 0, NULL, 'G', 0, 5, 9676),
(52439, '仓栅车 YC5045CCQC3H', NULL, 3975, 0, NULL, 'G', 0, 5, 9675),
(52438, '货车 YC1045C3H', NULL, 3975, 0, NULL, 'G', 0, 5, 9674),
(52437, '仓栅车 YC5045CCQC3S', NULL, 3975, 0, NULL, 'G', 0, 5, 7988),
(52436, '仓栅车 YC5045CCQC3D', NULL, 3975, 0, NULL, 'G', 0, 5, 7987),
(52435, '厢式车 YC5045XXYC3S', NULL, 3975, 0, NULL, 'G', 0, 5, 7986),
(52434, '厢式车 YC5045XXYC3D', NULL, 3975, 0, NULL, 'G', 0, 5, 7985),
(52433, '货车 YC1045C3S', NULL, 3975, 0, NULL, 'G', 0, 5, 7984),
(52432, '货车 YC1045C3D', NULL, 3975, 0, NULL, 'G', 0, 5, 7983),
(52431, '厢式车 YC5040 xXYC3H', NULL, 3974, 0, NULL, 'G', 0, 5, 9679),
(52430, '仓栅车 YC5040CCQC3H', NULL, 3974, 0, NULL, 'G', 0, 5, 9678),
(52429, '货车 YC1042C3H', NULL, 3974, 0, NULL, 'G', 0, 5, 9677),
(52428, '仓栅车 YC5040CCQC3S', NULL, 3974, 0, NULL, 'G', 0, 5, 7994),
(52427, '仓栅车 YC5040CCQC3D', NULL, 3974, 0, NULL, 'G', 0, 5, 7993),
(52426, '厢式车 YC5040 xXYC3S', NULL, 3974, 0, NULL, 'G', 0, 5, 7992),
(52425, '厢式车 YC5040 xXYC3D', NULL, 3974, 0, NULL, 'G', 0, 5, 7991),
(52424, '货车 YC1042C3S', NULL, 3974, 0, NULL, 'G', 0, 5, 7990),
(52423, '货车 YC1042C3D', NULL, 3974, 0, NULL, 'G', 0, 5, 7989),
(52422, '货车 YC1041C3H', NULL, 3973, 0, NULL, 'G', 0, 5, 9673),
(52421, '仓栅车 YC5041CCQC3H', NULL, 3973, 0, NULL, 'G', 0, 5, 9672),
(52420, '厢式车 YC5041XXYC3H', NULL, 3973, 0, NULL, 'G', 0, 5, 9671),
(52419, '仓栅车 YC5041CCQC3S', NULL, 3973, 0, NULL, 'G', 0, 5, 7982),
(52418, '仓栅车 YC5041CCQC3D', NULL, 3973, 0, NULL, 'G', 0, 5, 7981),
(52417, '厢式车 YC5041XXYC3S', NULL, 3973, 0, NULL, 'G', 0, 5, 7980),
(52416, '厢式车 YC5041XXYC3D', NULL, 3973, 0, NULL, 'G', 0, 5, 7979),
(52415, '货车 YC1041C3S', NULL, 3973, 0, NULL, 'G', 0, 5, 7978),
(52414, '货车 YC1041C3D', NULL, 3973, 0, NULL, 'G', 0, 5, 7977),
(52413, '2.0L 手自一体', NULL, 3972, 0, NULL, 'G', 0, 5, 101123),
(52412, '嘉路', NULL, 3971, 0, NULL, 'G', 0, 5, 3886),
(52411, '3.7L 自动', NULL, 3970, 0, NULL, 'G', 0, 5, 101121),
(52410, '自动豪华版', NULL, 3969, 0, NULL, 'G', 0, 5, 15512),
(52409, '3.5L 自动', NULL, 3968, 0, NULL, 'G', 0, 5, 101124),
(52408, '通用GMC四驱', NULL, 3967, 0, NULL, 'G', 0, 5, 5016),
(52407, '商务之星十二座豪华级', NULL, 3966, 0, NULL, 'G', 0, 5, 8094),
(52406, '商务之星十座领袖级', NULL, 3966, 0, NULL, 'G', 0, 5, 8093),
(52405, '商务之星十座皇家级', NULL, 3966, 0, NULL, 'G', 0, 5, 8092),
(52404, '商务之星七座领袖级(长轴)', NULL, 3966, 0, NULL, 'G', 0, 5, 8091),
(52403, '商务之星七座皇家级(长轴)', NULL, 3966, 0, NULL, 'G', 0, 5, 8090),
(52402, '商务之星七座皇家级', NULL, 3966, 0, NULL, 'G', 0, 5, 8089),
(52401, '商务之星七座领袖级', NULL, 3966, 0, NULL, 'G', 0, 5, 8088),
(52400, '通用GMC分隔屏', NULL, 3965, 0, NULL, 'G', 0, 5, 5015),
(52399, '通用GMC两驱', NULL, 3965, 0, NULL, 'G', 0, 5, 5014),
(52398, '商务之星总裁级', NULL, 3964, 0, NULL, 'G', 0, 5, 11388),
(52397, '商务之星七座领袖级', NULL, 3964, 0, NULL, 'G', 0, 5, 11386),
(52396, '商务之星十座至尊级', NULL, 3964, 0, NULL, 'G', 0, 5, 11385),
(52395, '领袖级(Flex fuel节能型)', NULL, 3964, 0, NULL, 'G', 0, 5, 8550),
(52394, '商务之星  5.3L 自动 四驱领袖级', NULL, 3963, 0, NULL, 'G', 0, 5, 14521),
(52393, '商务之星 5.3L 自动 四驱皇家级', NULL, 3963, 0, NULL, 'G', 0, 5, 14520),
(52392, '商务之星长轴皇家级 5.3L 自动', NULL, 3963, 0, NULL, 'G', 0, 5, 14519),
(52391, '商务之星皇家级 5.3L 自动', NULL, 3963, 0, NULL, 'G', 0, 5, 14518),
(52390, '商务之星长轴领袖级 6.0L 手自一体', NULL, 3963, 0, NULL, 'G', 0, 5, 14517),
(52389, '商务之星领袖级 5.3L 自动', NULL, 3963, 0, NULL, 'G', 0, 5, 14516),
(52388, 'GMC 7座1500型豪华商务车', NULL, 3963, 0, NULL, 'G', 0, 5, 14272),
(52387, 'GMC 7座2500型豪华商务车', NULL, 3963, 0, NULL, 'G', 0, 5, 14271),
(52386, '商务之星总裁级', NULL, 3963, 0, NULL, 'G', 0, 5, 12264),
(52385, '商务之星十座至尊级', NULL, 3963, 0, NULL, 'G', 0, 5, 8552),
(52384, '商务之星七座领袖级', NULL, 3963, 0, NULL, 'G', 0, 5, 8551),
(52383, '1500S型多功能乘用车', NULL, 3962, 0, NULL, 'G', 0, 5, 103575),
(52382, 'GMC 7座2500型豪华商务车', NULL, 3962, 0, NULL, 'G', 0, 5, 102430),
(52381, 'GMC 7座1500型豪华商务车', NULL, 3962, 0, NULL, 'G', 0, 5, 102428),
(52380, 'SAVANA 2500S(运动版)', NULL, 3962, 0, NULL, 'G', 0, 5, 100263),
(52379, '领袖级 6.0L 手自一体 经典版', NULL, 3962, 0, NULL, 'G', 0, 5, 16291),
(52378, '领袖级 6.0L 手自一体 至尊版', NULL, 3962, 0, NULL, 'G', 0, 5, 16290),
(52377, 'GMC 总统级防弹商务车', NULL, 3962, 0, NULL, 'G', 0, 5, 15510),
(52376, 'SAVANA 平顶 12座', NULL, 3962, 0, NULL, 'G', 0, 5, 14926),
(52375, 'SAVANA 领袖级', NULL, 3962, 0, NULL, 'G', 0, 5, 14925),
(52374, 'SAVANA 总裁级 7座', NULL, 3962, 0, NULL, 'G', 0, 5, 14924),
(52373, 'SAVANA 高顶 12座', NULL, 3962, 0, NULL, 'G', 0, 5, 14923),
(52372, '3500标准版', NULL, 3961, 0, NULL, 'G', 0, 5, 105187),
(52371, '3500舒适版', NULL, 3961, 0, NULL, 'G', 0, 5, 105186),
(52370, '2500S运动版（7座）', NULL, 3961, 0, NULL, 'G', 0, 5, 105185),
(52369, '萨瓦纳 2500新款 后驱 豪华商务车型 10座', NULL, 3961, 0, NULL, 'G', 0, 5, 104591),
(52368, '1500S 运动版', NULL, 3961, 0, NULL, 'G', 0, 5, 104590),
(52367, '萨瓦纳 四驱 豪华商务1500 7座', NULL, 3961, 0, NULL, 'G', 0, 5, 104589),
(52366, '2500S运动版（10座）', NULL, 3961, 0, NULL, 'G', 0, 5, 102766),
(52365, '1500 全时四驱 总裁级', NULL, 3961, 0, NULL, 'G', 0, 5, 102765),
(52364, '商务之星七座领袖级', NULL, 3961, 0, NULL, 'G', 0, 5, 102424),
(52363, 'Savana2500', NULL, 3960, 0, NULL, 'G', 0, 5, 111047),
(52362, '1500S 两驱版', NULL, 3960, 0, NULL, 'G', 0, 5, 111040),
(52361, '1500S 尊享版', NULL, 3960, 0, NULL, 'G', 0, 5, 110811),
(52360, '1500S 四驱版', NULL, 3960, 0, NULL, 'G', 0, 5, 105850),
(52359, '3500舒适版', NULL, 3960, 0, NULL, 'G', 0, 5, 105637),
(52358, '3500标准版', NULL, 3960, 0, NULL, 'G', 0, 5, 105636),
(52357, '2500S运动版 高顶', NULL, 3960, 0, NULL, 'G', 0, 5, 104914),
(52356, '舒适型', NULL, 3959, 0, NULL, 'G', 0, 5, 10632),
(52355, '经济型', NULL, 3959, 0, NULL, 'G', 0, 5, 10631),
(52354, '标准型', NULL, 3959, 0, NULL, 'G', 0, 5, 10630),
(52353, '1.0 手动 精英版', NULL, 3958, 0, NULL, 'G', 0, 5, 104553),
(52352, '1.0 手动 豪华型', NULL, 3958, 0, NULL, 'G', 0, 5, 104552),
(52351, 'GA1020DSE4 精英版', NULL, 3957, 0, NULL, 'G', 0, 5, 104551),
(52350, 'GA1020DSE4 豪华型', NULL, 3957, 0, NULL, 'G', 0, 5, 104550),
(52349, 'GA6401SE4 手动 精英版', NULL, 3956, 0, NULL, 'G', 0, 5, 103967),
(52348, 'GA6401SE4 手动 豪华型', NULL, 3956, 0, NULL, 'G', 0, 5, 103966),
(52347, '1.2L 手动 旗舰版', NULL, 3955, 0, NULL, 'G', 0, 5, 101958),
(52346, '1.2L 手动 豪华版', NULL, 3955, 0, NULL, 'G', 0, 5, 101955),
(52345, '1.2L 手动 精英版', NULL, 3955, 0, NULL, 'G', 0, 5, 101951),
(52344, '豪华型(不带OBD)', NULL, 3954, 0, NULL, 'G', 0, 5, 9831),
(52343, '标准型(不带OBD)', NULL, 3954, 0, NULL, 'G', 0, 5, 9830),
(52342, '豪华型(带OBD)', NULL, 3954, 0, NULL, 'G', 0, 5, 9829),
(52341, '标准型(带OBD)', NULL, 3954, 0, NULL, 'G', 0, 5, 9828),
(52340, 'GA6380E3 快运 基本型', NULL, 3953, 0, NULL, 'G', 0, 5, 11805),
(52339, 'GA6380E3 快运 标准型', NULL, 3953, 0, NULL, 'G', 0, 5, 11803),
(52338, 'GA6380E3 快运 舒适型', NULL, 3953, 0, NULL, 'G', 0, 5, 11801),
(52337, 'GA6380E3 快运 豪华型', NULL, 3953, 0, NULL, 'G', 0, 5, 11800),
(52336, 'GA6380E4 新动力 基本型', NULL, 3953, 0, NULL, 'G', 0, 5, 11798),
(52335, 'GA6380E4 新动力 标准型', NULL, 3953, 0, NULL, 'G', 0, 5, 11796),
(52334, 'GA6380E4 新动力 舒适型', NULL, 3953, 0, NULL, 'G', 0, 5, 11795),
(52333, 'GA6380E4 新动力 豪华型', NULL, 3953, 0, NULL, 'G', 0, 5, 11794),
(52332, '1.0L 手动 超值版', NULL, 3952, 0, NULL, 'G', 0, 5, 104549),
(52331, 'GA6380SE4 精英版', NULL, 3952, 0, NULL, 'G', 0, 5, 104548),
(52330, 'GA6380SE4 豪华版', NULL, 3952, 0, NULL, 'G', 0, 5, 104547),
(52329, '1.3L 手动 五座基本型', NULL, 3951, 0, NULL, 'G', 0, 5, 105019),
(52328, '1.3L 手动 五座标准型', NULL, 3951, 0, NULL, 'G', 0, 5, 105018),
(52327, '1.3L 手动 七座舒适型', NULL, 3951, 0, NULL, 'G', 0, 5, 105017),
(52326, '1.5L 手动 五座精英型', NULL, 3951, 0, NULL, 'G', 0, 5, 105016),
(52325, '1.5L 手动 七座豪华型', NULL, 3951, 0, NULL, 'G', 0, 5, 105014),
(52324, '1.5L 手动 七座至尊型', NULL, 3951, 0, NULL, 'G', 0, 5, 105006),
(52323, '1.3L 手动 舒适型 ', NULL, 3950, 0, NULL, 'G', 0, 5, 111011),
(52322, '1.3L 手动 豪华型 ', NULL, 3950, 0, NULL, 'G', 0, 5, 111010),
(52321, '1.5L 手动 舒适型', NULL, 3950, 0, NULL, 'G', 0, 5, 111009),
(52320, '1.5L 手动 豪华型', NULL, 3950, 0, NULL, 'G', 0, 5, 111008),
(52319, '1.5L 手动 至尊型', NULL, 3950, 0, NULL, 'G', 0, 5, 111007),
(52318, '豪华型', NULL, 3949, 0, NULL, 'G', 0, 5, 6893),
(52317, '标准型', NULL, 3949, 0, NULL, 'G', 0, 5, 6892),
(52316, 'GA6470', NULL, 3948, 0, NULL, 'G', 0, 5, 9053),
(52315, '柴油标准型', NULL, 3947, 0, NULL, 'G', 0, 5, 9839),
(52314, '汽油标准型', NULL, 3947, 0, NULL, 'G', 0, 5, 4205),
(52313, 'GA6510/B6B-18 标准型 国Ⅲ+OBD', NULL, 3946, 0, NULL, 'G', 0, 5, 11808),
(52312, 'GA6510E3A /B6B-32 标准型 国Ⅲ', NULL, 3946, 0, NULL, 'G', 0, 5, 11807),
(52311, '标准型 国Ⅲ GA6511CRE3A /B6B-37', NULL, 3946, 0, NULL, 'G', 0, 5, 11806),
(52310, 'GA6510CRE3A /B6B—16 标准型 国Ⅱ', NULL, 3946, 0, NULL, 'G', 0, 5, 11790),
(52309, '2.2L 标准型  汽油 国4', NULL, 3945, 0, NULL, 'G', 0, 5, 100660),
(52308, '2.0L 高压共轨柴油 标准型 国3', NULL, 3945, 0, NULL, 'G', 0, 5, 100658),
(52307, '2.0L 莱动柴油 标准型 国3', NULL, 3945, 0, NULL, 'G', 0, 5, 100651),
(52306, '2.2L 舒适型', NULL, 3944, 0, NULL, 'G', 0, 5, 10628),
(52305, '2.8L 柴油舒适型', NULL, 3943, 0, NULL, 'G', 0, 5, 10629),
(52304, '2.8L 柴油豪华型', NULL, 3943, 0, NULL, 'G', 0, 5, 10627),
(52303, '2.8L 柴油标准型', NULL, 3943, 0, NULL, 'G', 0, 5, 10626),
(52302, '2.2L 豪华型', NULL, 3943, 0, NULL, 'G', 0, 5, 9052),
(52301, '2.2L 标准型', NULL, 3943, 0, NULL, 'G', 0, 5, 9051),
(52300, 'GA6460ME3/B1A-34', NULL, 3942, 0, NULL, 'G', 0, 5, 11789),
(52299, '自动豪华型', NULL, 3942, 0, NULL, 'G', 0, 5, 9875),
(52298, '自动舒适型', NULL, 3942, 0, NULL, 'G', 0, 5, 9874),
(52297, '手动豪华型', NULL, 3942, 0, NULL, 'G', 0, 5, 9873),
(52296, '手动舒适型', NULL, 3942, 0, NULL, 'G', 0, 5, 9840),
(52295, 'GA1021C', NULL, 3941, 0, NULL, 'G', 0, 5, 4204),
(52294, 'GA1021', NULL, 3941, 0, NULL, 'G', 0, 5, 4203),
(52293, 'GA1020LH豪华型', NULL, 3941, 0, NULL, 'G', 0, 5, 2897),
(52292, 'GA1020LB标准型', NULL, 3941, 0, NULL, 'G', 0, 5, 2896),
(52291, 'GA1020H豪华型', NULL, 3941, 0, NULL, 'G', 0, 5, 2895),
(52290, 'GA1020B标准型', NULL, 3941, 0, NULL, 'G', 0, 5, 2894),
(52289, 'GA1020J经济型', NULL, 3941, 0, NULL, 'G', 0, 5, 2893),
(52288, 'GA6490WME3/H3B—34 豪华型', NULL, 3940, 0, NULL, 'G', 0, 5, 9838),
(52287, 'GA6493ME3/H3B—33 豪华型', NULL, 3940, 0, NULL, 'G', 0, 5, 9837),
(52286, 'GA6490E3A/H3BM—32 豪华型', NULL, 3940, 0, NULL, 'G', 0, 5, 4202),
(52285, 'GA6460CT', NULL, 3939, 0, NULL, 'G', 0, 5, 4212),
(52284, 'GA6460M', NULL, 3939, 0, NULL, 'G', 0, 5, 4211),
(52283, 'GA6461', NULL, 3939, 0, NULL, 'G', 0, 5, 4210),
(52282, 'GA6490', NULL, 3939, 0, NULL, 'G', 0, 5, 2892),
(52281, 'GA6490CTH4X 豪华型（柴油版）', NULL, 3939, 0, NULL, 'G', 0, 5, 2891),
(52280, 'GA6490CTB4Q 舒适型（柴油版）', NULL, 3939, 0, NULL, 'G', 0, 5, 2890),
(52279, 'GA6490H4X 豪华型', NULL, 3939, 0, NULL, 'G', 0, 5, 2889),
(52278, 'GA6490H4Q 豪华型', NULL, 3939, 0, NULL, 'G', 0, 5, 2888),
(52277, 'GA6490B4Q 舒适型', NULL, 3939, 0, NULL, 'G', 0, 5, 2887),
(52276, 'GA6460MG3Y 超豪华型', NULL, 3939, 0, NULL, 'G', 0, 5, 2886),
(52275, 'GA6460MH3Y 豪华型', NULL, 3939, 0, NULL, 'G', 0, 5, 2885),
(52274, 'GA6460H3Y 豪华型', NULL, 3939, 0, NULL, 'G', 0, 5, 2884),
(52273, 'GA6460B3Y 标准型', NULL, 3939, 0, NULL, 'G', 0, 5, 2883),
(52272, 'GA6490CT', NULL, 3938, 0, NULL, 'G', 0, 5, 4209),
(52271, 'GA6510E3A/B4B—32 标准型', NULL, 3937, 0, NULL, 'G', 0, 5, 4208),
(52270, '2.2L 手动 标准型 7座', NULL, 3936, 0, NULL, 'G', 0, 5, 100650),
(52269, '2.2L 手动 标准型 5座', NULL, 3936, 0, NULL, 'G', 0, 5, 100649),
(52268, '1.6L 手动 舒适版', NULL, 3935, 0, NULL, 'G', 0, 5, 110886),
(52267, '1.6L 手动 豪华版', NULL, 3935, 0, NULL, 'G', 0, 5, 110885),
(52266, '1.6L 自动 尊贵版', NULL, 3935, 0, NULL, 'G', 0, 5, 110884),
(52265, '1.6L 自动 至尊版', NULL, 3935, 0, NULL, 'G', 0, 5, 106519),
(52264, 'GA1023CT/H8D—16 豪华型', NULL, 3934, 0, NULL, 'G', 0, 5, 9845),
(52263, 'GA1020CRE3A/H8D—35 标准型', NULL, 3934, 0, NULL, 'G', 0, 5, 9844),
(52262, 'GA1020E3/H8D—31 标准型', NULL, 3934, 0, NULL, 'G', 0, 5, 9843),
(52261, 'GA1020E3/H8D—30 标准型', NULL, 3934, 0, NULL, 'G', 0, 5, 9842),
(52260, 'GA1020CRE3A/HAD-30 新柴神 豪华型', NULL, 3933, 0, NULL, 'G', 0, 5, 11814),
(52259, 'GA1020CRE3A/JAD-35 新柴神 致富版', NULL, 3933, 0, NULL, 'G', 0, 5, 11813),
(52258, 'GA1020CRE3A/JAD-37 新柴神 财富版', NULL, 3933, 0, NULL, 'G', 0, 5, 11812),
(52257, 'GA1020CRE3A/HAD-37 新柴神 豪华型', NULL, 3933, 0, NULL, 'G', 0, 5, 11811),
(52256, '2.2L 汽油 手动 标准型 加长版', NULL, 3932, 0, NULL, 'G', 0, 5, 100694),
(52255, '2.8L 高压共轨柴油 手动 豪华型', NULL, 3932, 0, NULL, 'G', 0, 5, 100692),
(52254, 'GA1021CT/H6B—4 豪华型', NULL, 3931, 0, NULL, 'G', 0, 5, 9836),
(52253, 'GA1021CT/H6B—16 豪华型', NULL, 3931, 0, NULL, 'G', 0, 5, 9835),
(52252, 'GA1020CREA/H6B—35 豪华型', NULL, 3931, 0, NULL, 'G', 0, 5, 9834),
(52251, 'GA1020E3A/H6B—31 豪华型', NULL, 3931, 0, NULL, 'G', 0, 5, 4201),
(52250, 'GA1020E3/H6B—30 豪华型', NULL, 3931, 0, NULL, 'G', 0, 5, 4200),
(52249, 'GA1020CRE3A/B6BZ—37 标准型', NULL, 3930, 0, NULL, 'G', 0, 5, 11793),
(52248, 'GA1020CRE3A/B6BZ—9 标准型', NULL, 3930, 0, NULL, 'G', 0, 5, 11792),
(52247, 'GA1020E3/H6BZ—30 豪华型', NULL, 3930, 0, NULL, 'G', 0, 5, 11791),
(52246, '2.2L 汽油 豪华型加长版 国4', NULL, 3929, 0, NULL, 'G', 0, 5, 100670),
(52245, '2.2L 莱动柴油 标准型加长版 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100669),
(52244, '2.8L VE泵柴油 标准型加长版 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100668),
(52243, '2.8L VE泵柴油 豪华型加长版 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100667),
(52242, '2.2L 汽油 豪华型 国4', NULL, 3929, 0, NULL, 'G', 0, 5, 100666),
(52241, '2.2L 莱动柴油 标准型 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100665),
(52240, '2.8L VE泵柴油 豪华型 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100663),
(52239, '2.8L VE泵柴油 标准型 国3', NULL, 3929, 0, NULL, 'G', 0, 5, 100662),
(52238, '四门舒适型 2.7L柴油(500公斤)', NULL, 3928, 0, NULL, 'G', 0, 5, 10625),
(52237, '四门舒适型 2.2L(500公斤)', NULL, 3928, 0, NULL, 'G', 0, 5, 10624),
(52236, 'GA1020CRE3A/B3XZ—35 标准型', NULL, 3927, 0, NULL, 'G', 0, 5, 9841),
(52235, 'GA1020E3A/B3XZ—31 标准型', NULL, 3927, 0, NULL, 'G', 0, 5, 4207),
(52234, 'GA1020E3/B3XZ—30 标准型', NULL, 3927, 0, NULL, 'G', 0, 5, 4206),
(52233, '2.2L 汽油 手动 标准型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100687),
(52232, '2.2L 汽油 手动 舒适型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100686),
(52231, '2.8L VE泵柴油 手动  豪华型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100685),
(52230, '2.2L 莱动柴油 手动  舒适型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100684),
(52229, '2.2L 莱动柴油 手动  标准型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100683),
(52228, '2.8L VE泵柴油 手动  舒适型 超长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100682),
(52227, '2.2L 汽油 手动 标准型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100681),
(52226, '2.2L 汽油 手动 舒适型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100680),
(52225, '2.8L VE泵柴油 手动  豪华型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100679),
(52224, '2.2L 莱动柴油 手动  舒适型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100678),
(52223, '2.2L 莱动柴油 手动  标准型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100677),
(52222, '2.8L VE泵柴油 手动  舒适型 加长版', NULL, 3926, 0, NULL, 'G', 0, 5, 100676),
(52221, '2.2L 汽油 手动 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 100675),
(52220, '2.2L 汽油 手动 舒适型', NULL, 3926, 0, NULL, 'G', 0, 5, 100674),
(52219, '2.2L 莱动柴油 手动  标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 100673),
(52218, '2.2L 莱动柴油 手动  舒适型', NULL, 3926, 0, NULL, 'G', 0, 5, 100672),
(52217, '2.8L VE泵柴油 手动  豪华型', NULL, 3926, 0, NULL, 'G', 0, 5, 100671),
(52216, '2.8L VE泵柴油 手动  舒适型', NULL, 3926, 0, NULL, 'G', 0, 5, 100664),
(52215, '大财运 GA1020LCRE3A/B3BZT—37 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11819),
(52214, '大财运 GA1020LCRE3A/S3BZT—9 经济型', NULL, 3926, 0, NULL, 'G', 0, 5, 11818),
(52213, '大财运 GA1020LCRE3A/B3BZT—9 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11817),
(52212, '大财运 GA1020LE3/S3BZT—30 经济型', NULL, 3926, 0, NULL, 'G', 0, 5, 11816),
(52211, '大财运 GA1020LE3/J3BZT—30 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11815),
(52210, 'GA1020CRE3A/B3BZ-37 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11788),
(52209, 'GA1020CRE3A/S3BZ-9 经济型', NULL, 3926, 0, NULL, 'G', 0, 5, 11787),
(52208, 'GA1020CRE3A/B3BZ-9 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11786),
(52207, 'GA1020E3/S3BZ-30 经济型', NULL, 3926, 0, NULL, 'G', 0, 5, 11785),
(52206, 'GA1020E3/J3BZ-30 标准型', NULL, 3926, 0, NULL, 'G', 0, 5, 11784),
(52205, '2.4L 自动 智能四驱 精英版', NULL, 3925, 0, NULL, 'G', 0, 5, 110606),
(52204, '2.4L 自动 智能四驱 至尊版', NULL, 3925, 0, NULL, 'G', 0, 5, 110605),
(52203, '2.5L 手动 分时四驱 天窗版 柴油', NULL, 3925, 0, NULL, 'G', 0, 5, 100618),
(52202, '2.5L 手动 分时四驱 时尚版 柴油', NULL, 3925, 0, NULL, 'G', 0, 5, 100617),
(52201, '2.5L 手动 两驱 天窗版 柴油', NULL, 3925, 0, NULL, 'G', 0, 5, 100616),
(52200, '2.5L 手动 两驱 时尚版 柴油', NULL, 3925, 0, NULL, 'G', 0, 5, 100615),
(52199, '2.4L 自动 四驱 汽油 天窗版', NULL, 3925, 0, NULL, 'G', 0, 5, 100614),
(52198, '2.4L 自动 四驱 时尚版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100613),
(52197, '2.4L 自动 两驱 天窗版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100612),
(52196, '2.4L 自动 两驱 时尚版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100611),
(52195, '2.4L 手动 四驱 天窗版 汽油 ', NULL, 3925, 0, NULL, 'G', 0, 5, 100610),
(52194, '2.4L 手动 四驱 时尚版 汽油 ', NULL, 3925, 0, NULL, 'G', 0, 5, 100609),
(52193, '2.4L 手动 两驱 天窗版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100608),
(52192, '2.4L 手动 两驱 时尚版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100607),
(52191, '2.0L 手动 两驱 天窗版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100606),
(52190, '2.0L 手动 两驱 时尚版 汽油', NULL, 3925, 0, NULL, 'G', 0, 5, 100605),
(52189, '2.0L 手动 至尊版', NULL, 3924, 0, NULL, 'G', 0, 5, 16283),
(52188, '2.0L 手动 豪华版', NULL, 3924, 0, NULL, 'G', 0, 5, 16282),
(52187, '2.0L 手动 精英版', NULL, 3924, 0, NULL, 'G', 0, 5, 16281),
(52186, '2.4L 手动 至尊版', NULL, 3924, 0, NULL, 'G', 0, 5, 14929),
(52185, '2.4L 手动 豪华版', NULL, 3924, 0, NULL, 'G', 0, 5, 14928),
(52184, '2.4L 手动 精英版', NULL, 3924, 0, NULL, 'G', 0, 5, 13318),
(52183, '2.0L 手动 两驱 智选版', NULL, 3923, 0, NULL, 'G', 0, 5, 110604),
(52182, '2.5T 手动 两驱 精英版', NULL, 3923, 0, NULL, 'G', 0, 5, 100602),
(52181, '2.5T 手动 两驱 豪华版', NULL, 3923, 0, NULL, 'G', 0, 5, 100601),
(52180, '2.5T 手动 两驱 至尊版', NULL, 3923, 0, NULL, 'G', 0, 5, 100600),
(52179, '2.4L 自动 两驱 至尊版', NULL, 3923, 0, NULL, 'G', 0, 5, 16539),
(52178, '2.4L 自动 两驱 豪华版', NULL, 3923, 0, NULL, 'G', 0, 5, 16538),
(52177, '2.4L 手动  四驱 至尊版', NULL, 3923, 0, NULL, 'G', 0, 5, 16537),
(52176, '2.4L 手动 四驱 豪华版', NULL, 3923, 0, NULL, 'G', 0, 5, 16536),
(52175, '2.4L 手动 四驱 精英版', NULL, 3923, 0, NULL, 'G', 0, 5, 16535),
(52174, '2.4L 手动 两驱 至尊版', NULL, 3923, 0, NULL, 'G', 0, 5, 16534),
(52173, '2.4L 手动 两驱 豪华版', NULL, 3923, 0, NULL, 'G', 0, 5, 16533),
(52172, '2.4L 手动 两驱 精英版', NULL, 3923, 0, NULL, 'G', 0, 5, 16532),
(52171, '2.0L 手动 两驱 精英版', NULL, 3923, 0, NULL, 'G', 0, 5, 16531),
(52170, '2.0L 手动 两驱 豪华版', NULL, 3923, 0, NULL, 'G', 0, 5, 16530),
(52169, '2.0L 手动 两驱 至尊版', NULL, 3923, 0, NULL, 'G', 0, 5, 16529),
(52168, 'G3 2.0', NULL, 3922, 0, NULL, 'G', 0, 5, 12377),
(52167, '1.2L 5MT 实用型', NULL, 3921, 0, NULL, 'F', 0, 5, 109860),
(52166, '1.2L 5MT 创业型', NULL, 3921, 0, NULL, 'F', 0, 5, 106590),
(52165, '1.2L 5MT 进取型 ', NULL, 3921, 0, NULL, 'F', 0, 5, 106589),
(52164, '1.2L 5MT 致富型', NULL, 3921, 0, NULL, 'F', 0, 5, 106587),
(52163, '2.5L 自动 V9头等舱', NULL, 3920, 0, NULL, 'F', 0, 5, 104247),
(52162, '2.5L 自动 V8行政版', NULL, 3920, 0, NULL, 'F', 0, 5, 104246),
(52161, '2.7T 自动 CDI柴油版', NULL, 3919, 0, NULL, 'F', 0, 5, 109704),
(52160, '524 3.5 V6 自动版', NULL, 3918, 0, NULL, 'F', 0, 5, 109709),
(52159, '324 3.5 V6 自动 豪华版', NULL, 3918, 0, NULL, 'F', 0, 5, 109708),
(52158, '324 3.5 V6 自动 行政版', NULL, 3918, 0, NULL, 'F', 0, 5, 109707),
(52157, '515 2.1 自动 CDI', NULL, 3918, 0, NULL, 'F', 0, 5, 109706),
(52156, '315 2.1 自动 CDI', NULL, 3918, 0, NULL, 'F', 0, 5, 109705),
(52155, '3.5 自动 增配版', NULL, 3917, 0, NULL, 'F', 0, 5, 109703),
(52154, '3.5L 自动 商旅车', NULL, 3916, 0, NULL, 'F', 0, 5, 104245),
(52153, '3.5L 自动 商务舱C', NULL, 3916, 0, NULL, 'F', 0, 5, 104244),
(52152, '3.5L 自动 商务舱B', NULL, 3916, 0, NULL, 'F', 0, 5, 104243),
(52151, '3.5L 自动 行政版', NULL, 3916, 0, NULL, 'F', 0, 5, 104239),
(52150, 'Evantra V8', NULL, 3915, 0, NULL, 'F', 0, 5, 102935),
(52149, 'FZ6510', NULL, 3914, 0, NULL, 'F', 0, 5, 11383),
(52148, 'BJ6103校车', NULL, 3913, 0, NULL, 'F', 0, 5, 100286),
(52147, 'BJ5171流动医疗车', NULL, 3913, 0, NULL, 'F', 0, 5, 100285),
(52146, 'BJ6831专用豪华校车', NULL, 3913, 0, NULL, 'F', 0, 5, 100284),
(52145, 'BJ6730长头校车', NULL, 3913, 0, NULL, 'F', 0, 5, 100283),
(52144, 'BJ6830天然气城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100261),
(52143, 'BJ6101城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100260),
(52142, 'BJ6102城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100259),
(52141, 'BJ6830城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100258),
(52140, 'BJ6880城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100257),
(52139, 'BJ6940城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100256),
(52138, 'BJ6900全承载城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100255),
(52137, 'BJ6103城间客车2', NULL, 3912, 0, NULL, 'F', 0, 5, 100254),
(52136, 'BJ6103城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100249),
(52135, 'BJ6110城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100248),
(52134, 'BJ6120团体版', NULL, 3912, 0, NULL, 'F', 0, 5, 100246),
(52133, 'BJ6120城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100242),
(52132, 'BJ6126天然气城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100241),
(52131, 'BJ6129城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100240),
(52130, 'BJ6110天然气城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100239),
(52129, 'BJ6126城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100237),
(52128, 'BJ6800全承载城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100234),
(52127, 'BJ6115城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100233),
(52126, 'BJ6125全承载城间客车', NULL, 3912, 0, NULL, 'F', 0, 5, 100232),
(52125, 'BJ6129', NULL, 3912, 0, NULL, 'F', 0, 5, 100231),
(52124, 'BJ6125一层半全承载城间客车', NULL, 3911, 0, NULL, 'F', 0, 5, 100287),
(52123, '2.0L商通版低顶486EQV4', NULL, 3910, 0, NULL, 'F', 0, 5, 111550),
(52122, '2.0L商通版高顶486EQV4', NULL, 3910, 0, NULL, 'F', 0, 5, 111549),
(52121, '2.8T商通版低顶4JB1T', NULL, 3910, 0, NULL, 'F', 0, 5, 111548),
(52120, '2.8T商通版高顶4JB1T', NULL, 3910, 0, NULL, 'F', 0, 5, 111547),
(52119, '2.0L商务版低顶486EQV4', NULL, 3910, 0, NULL, 'F', 0, 5, 111546),
(52118, ' 2.0L商务版高顶486EQV4', NULL, 3910, 0, NULL, 'F', 0, 5, 111545),
(52117, '2.8T商务版低顶4JB1T', NULL, 3910, 0, NULL, 'F', 0, 5, 111544),
(52116, '2.8T商务版高顶4JB1T', NULL, 3910, 0, NULL, 'F', 0, 5, 111543),
(52115, '3032PEB32110Q28-1', NULL, 3909, 0, NULL, 'F', 0, 5, 111236),
(52114, '3032PEB02110Q28-1', NULL, 3909, 0, NULL, 'F', 0, 5, 111235),
(52113, '3032AEB02110Q25-2', NULL, 3909, 0, NULL, 'F', 0, 5, 111234),
(52112, '3032AEB02110Q25-1', NULL, 3909, 0, NULL, 'F', 0, 5, 111233),
(52111, '3022AEB02105Q22-1', NULL, 3909, 0, NULL, 'F', 0, 5, 111232),
(52110, '2.8T 手动 两驱', NULL, 3908, 0, NULL, 'F', 0, 5, 100645),
(52109, '2.8T 手动 四驱', NULL, 3908, 0, NULL, 'F', 0, 5, 100644),
(52108, '2.4L 手动 两驱 精英版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105483),
(52107, '2.0L 手动 两驱 精英版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105482),
(52106, '2.4L 手动 四驱 精英版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105481),
(52105, '2.0L 手动  四驱 精英版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105480),
(52104, '2.4L 手动 两驱 至尊版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105479),
(52103, '2.0L 手动 两驱 至尊版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105478),
(52102, '2.4L 手动 四驱 至尊版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105477),
(52101, '2.0L 手动 四驱 至尊版 汽油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105476),
(52100, '2.8T 手动 两驱 进取版 柴油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105474),
(52099, '2.8T 手动 两驱 舒适版 柴油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105473),
(52098, '2.8T 手动 两驱 精英版 柴油  低功率版', NULL, 3907, 0, NULL, 'F', 0, 5, 105472),
(52097, '2.8T 手动 两驱 精英版 柴油  高功率版', NULL, 3907, 0, NULL, 'F', 0, 5, 105471),
(52096, '2.8T 手动  四驱 精英版 柴油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105470),
(52095, '2.8T 手动 两驱 越野版 柴油  低功率版', NULL, 3907, 0, NULL, 'F', 0, 5, 105469),
(52094, '2.8T 手动 两驱 越野版 柴油  高功率版', NULL, 3907, 0, NULL, 'F', 0, 5, 105468),
(52093, '2.8T 手动 四驱 至尊版 柴油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105466),
(52092, '2.8T 手动  四驱 越野版 柴油 ', NULL, 3907, 0, NULL, 'F', 0, 5, 105437),
(52091, '驭菱V1共轨国Ⅳ BJ1030V5AA4-X3', NULL, 3906, 0, NULL, 'F', 0, 5, 111484),
(52090, '驭菱VQ1独悬 BJ5020V2BV2-X', NULL, 3906, 0, NULL, 'F', 0, 5, 111483),
(52089, '驭菱VQ1非独悬 BJ1020V1JV1-E1', NULL, 3906, 0, NULL, 'F', 0, 5, 111482),
(52088, '驭菱VQ2两用燃料 BJ1032V5JV5-E1', NULL, 3906, 0, NULL, 'F', 0, 5, 111481),
(52087, '驭菱VQ2两用燃料 BJ1032V4AV5-E3', NULL, 3906, 0, NULL, 'F', 0, 5, 111480),
(52086, '驭菱VQ5非独悬 BJ5036XXY-F4', NULL, 3906, 0, NULL, 'F', 0, 5, 111479),
(52085, '驭菱VQ5非独悬 BJ1036V4AV5-F3', NULL, 3906, 0, NULL, 'F', 0, 5, 111478),
(52084, '5072PEH24108LJ36-1', NULL, 3905, 0, NULL, 'F', 0, 5, 111269),
(52083, '5032AEL14100Q32-2', NULL, 3905, 0, NULL, 'F', 0, 5, 111268),
(52082, '3062AEL34102LJ34-3', NULL, 3905, 0, NULL, 'F', 0, 5, 111267),
(52081, '3042AEL24100LJ34-1', NULL, 3905, 0, NULL, 'F', 0, 5, 111266),
(52080, '3032AEL24100Q34-4', NULL, 3905, 0, NULL, 'F', 0, 5, 111265),
(52079, '3022AEB3485Q23-2', NULL, 3905, 0, NULL, 'F', 0, 5, 111264),
(52078, '3062PEL34102LJ39-1', NULL, 3905, 0, NULL, 'F', 0, 5, 111263),
(52077, '1P69P490Q(FA)', NULL, 3905, 0, NULL, 'F', 0, 5, 111262),
(52076, '1P47J485Q(FA1)', NULL, 3905, 0, NULL, 'F', 0, 5, 111261),
(52075, '3012AEB1485Q23-1', NULL, 3905, 0, NULL, 'F', 0, 5, 111260),
(52074, '3022AEB0485Q23-2', NULL, 3905, 0, NULL, 'F', 0, 5, 111259),
(52073, '小卡3-3360-云内YN27CRD1', NULL, 3903, 0, NULL, 'F', 0, 5, 111469),
(52072, '领航1-3360-全柴4B2-95C40', NULL, 3903, 0, NULL, 'F', 0, 5, 111468),
(52071, '领航2-3360-大柴CA4DC2-10E4', NULL, 3903, 0, NULL, 'F', 0, 5, 111467),
(52070, '领航H1-3360-云内YN27CRD1', NULL, 3903, 0, NULL, 'F', 0, 5, 111466),
(52069, '领航H2-3360-大柴CA4DC2-10E4', NULL, 3903, 0, NULL, 'F', 0, 5, 111465),
(52068, '领航H3-3360-扬柴YZ4DA2-40', NULL, 3903, 0, NULL, 'F', 0, 5, 111464),
(52067, '领航H3-3800-云内YN38CRD1', NULL, 3903, 0, NULL, 'F', 0, 5, 111463),
(52066, '领航H3-4200-云内YN38CRD1', NULL, 3903, 0, NULL, 'F', 0, 5, 111462),
(52065, '康瑞KQ1-3000-BJ486EQV4两用燃料产品', NULL, 3902, 0, NULL, 'F', 0, 5, 111459),
(52064, '康瑞H2-3360-北京环保4J28TC', NULL, 3902, 0, NULL, 'F', 0, 5, 111458),
(52063, '康瑞H2-3360-康明斯2.8', NULL, 3902, 0, NULL, 'F', 0, 5, 111456),
(52062, '康瑞H3-3360-北京环保4J28TC', NULL, 3902, 0, NULL, 'F', 0, 5, 111455),
(52061, '康瑞H3-3360-康明斯3.8', NULL, 3902, 0, NULL, 'F', 0, 5, 111454),
(52060, '康瑞H3-4560-康明斯3.8', NULL, 3902, 0, NULL, 'F', 0, 5, 111451),
(52059, '康瑞H3-4850-康明斯3.8', NULL, 3902, 0, NULL, 'F', 0, 5, 111449),
(52058, '康瑞H5-5350-康明斯3.8', NULL, 3902, 0, NULL, 'F', 0, 5, 111441),
(52057, 'BJ1027V2MW5-3', NULL, 3901, 0, NULL, 'F', 0, 5, 9063),
(52056, 'BJ1027V2MD5-5', NULL, 3901, 0, NULL, 'F', 0, 5, 9062),
(52055, 'BJ1027V2MB5—4', NULL, 3901, 0, NULL, 'F', 0, 5, 9061),
(52054, 'T 2.8L 手动 柴油共轨', NULL, 3900, 0, NULL, 'F', 0, 5, 100511),
(52053, 'T 2.8L 手动 柴油VE泵', NULL, 3900, 0, NULL, 'F', 0, 5, 100510),
(52052, 'T 2.2L 手动 汽油4Y', NULL, 3900, 0, NULL, 'F', 0, 5, 100509),
(52051, 'T 2.0L 手动', NULL, 3900, 0, NULL, 'F', 0, 5, 100508),
(52050, 'V 2.2L 手动 汽油4Y', NULL, 3900, 0, NULL, 'F', 0, 5, 100503),
(52049, 'V 2.8L 手动 柴油VE泵', NULL, 3900, 0, NULL, 'F', 0, 5, 100499),
(52048, 'V 2.8L 手动 柴油共轨', NULL, 3900, 0, NULL, 'F', 0, 5, 100494),
(52047, 'Z 2.8L 手动 汽油4Y', NULL, 3900, 0, NULL, 'F', 0, 5, 100489),
(52046, 'Z 2.8L 手动 柴油VE泵', NULL, 3900, 0, NULL, 'F', 0, 5, 100486),
(52045, 'Z 2.8L 手动 柴油共轨', NULL, 3900, 0, NULL, 'F', 0, 5, 100476),
(52044, '征服者 2.2L 四驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15408),
(52043, '征服者 2.2L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15407),
(52042, '征服者 2.8L 四驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15405),
(52041, '征服者 2.8L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15404),
(52040, 'Z7 2.2L 四驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15327),
(52039, 'Z7 2.2L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15326),
(52038, 'Z7 2.8L 四驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15325),
(52037, 'Z7 2.8L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15324),
(52036, 'V3 2.2L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15319),
(52035, 'V3 2.0L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15318),
(52034, 'V5 2.8L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15317),
(52033, 'V7 2.8L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15316),
(52032, 'V7 2.2L 两驱', NULL, 3900, 0, NULL, 'F', 0, 5, 15315),
(52031, 'T 2.0 经典节油王', NULL, 3900, 0, NULL, 'F', 0, 5, 15313),
(52030, 'C 2.0 新节油王', NULL, 3900, 0, NULL, 'F', 0, 5, 15311),
(52029, 'V 2.8 智能节油王', NULL, 3900, 0, NULL, 'F', 0, 5, 15310),
(52028, 'V 2.3 BJ1027V2MW5-S', NULL, 3900, 0, NULL, 'F', 0, 5, 15307),
(52027, 'V 2.8 BJ1027V2MD5-S', NULL, 3900, 0, NULL, 'F', 0, 5, 15306),
(52026, 'T 2.2L 手动 两驱 汽油', NULL, 3899, 0, NULL, 'F', 0, 5, 111502),
(52025, 'T 2.8L 手动 两驱 柴油', NULL, 3899, 0, NULL, 'F', 0, 5, 111501),
(52024, '5102PEX56105LJ51-1 中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 111231),
(52023, '3P22P6105E(TE) 中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110781),
(52022, '3P21BP4110E(TE2) 中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110779),
(52021, '3P21BP4110E(TD) 中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110778),
(52020, '3P21BP4110E(TC2)中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110776),
(52019, '3P21BP4110E(TA)中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110772),
(52018, '3PS25AP4110E(TK) 中型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110771),
(52017, '3P24P6126E(BF)64 重型运输型工程车', NULL, 3898, 0, NULL, 'F', 0, 5, 110770),
(52016, '3P21BP4108E(TA3)', NULL, 3897, 0, NULL, 'F', 0, 5, 111258),
(52015, '3092PEJ24108LJ36-2', NULL, 3897, 0, NULL, 'F', 0, 5, 111257),
(52014, '3P21BP4108E(TD)', NULL, 3897, 0, NULL, 'F', 0, 5, 111256),
(52013, '3P21BP4108E(TB1)', NULL, 3897, 0, NULL, 'F', 0, 5, 111255),
(52012, '3P21BP4108E(TA)', NULL, 3897, 0, NULL, 'F', 0, 5, 111254),
(52011, '3092PEH24108Z34-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111253),
(52010, '3PS86P4105L(TA)', NULL, 3897, 0, NULL, 'F', 0, 5, 111252),
(52009, '3P86BP4102E(TA)', NULL, 3897, 0, NULL, 'F', 0, 5, 111251),
(52008, '3P86B4102DP(TA)', NULL, 3897, 0, NULL, 'F', 0, 5, 111250),
(52007, '3082PEH24102LJ34-2', NULL, 3897, 0, NULL, 'F', 0, 5, 111249),
(52006, '3072PEH24102LJ33-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111248),
(52005, '3062PEH24102Z33-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111247),
(52004, '3062PEH14102Q32-2', NULL, 3897, 0, NULL, 'F', 0, 5, 111246),
(52003, '3062PEH14102Q32-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111245),
(52002, '3042PEH14100Q31-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111244),
(52001, '3042PEH1490Q28-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111243),
(52000, '3042PEB3490Q28-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111242),
(51999, '3032AEB3490Q25-3', NULL, 3897, 0, NULL, 'F', 0, 5, 111241),
(51998, '3042AEB3490Q25-1', NULL, 3897, 0, NULL, 'F', 0, 5, 111240),
(51997, '3063ARF', NULL, 3897, 0, NULL, 'F', 0, 5, 111239),
(51996, '150T-2MB2', NULL, 3897, 0, NULL, 'F', 0, 5, 111238),
(51995, '150T-1AF', NULL, 3897, 0, NULL, 'F', 0, 5, 111237),
(51994, '矿用类 矿山金刚 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101112),
(51993, '保障类 清障车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101111),
(51992, '保障类 清障车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101110),
(51991, '保障类 消防车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101108),
(51990, '保障类 消防车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101107),
(51989, '保障类 消防车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101106),
(51988, '保障类 沥青洒布车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101105),
(51987, '保障类 沥青洒布车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101104),
(51986, '保障类 除雪车 6×6', NULL, 3896, 0, NULL, 'F', 0, 5, 101103),
(51985, '保障类 除雪车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101102),
(51984, '保障类 垃圾车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101101),
(51983, '保障类 垃圾车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101100),
(51982, '物流类 冷藏车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101099),
(51981, '物流类 冷藏车 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101098),
(51980, '保障类 洒水车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101097),
(51979, '保障类 洒水车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101096),
(51978, '保障类 洒水车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101095),
(51977, '物流类 冷藏车 4×2 3系', NULL, 3896, 0, NULL, 'F', 0, 5, 101094),
(51976, '物流类 随车起重运输车 8×4 6系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101092),
(51975, '物流类 随车起重运输车 8×4 6系', NULL, 3896, 0, NULL, 'F', 0, 5, 101091),
(51974, '物流类 随车起重运输车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101090),
(51973, '物流类 随车起重运输车 6×2 5系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101089),
(51972, '物流类 随车起重运输车 6×2 5系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101088),
(51971, '物流类 随车起重运输车 6×2 5系', NULL, 3896, 0, NULL, 'F', 0, 5, 101087),
(51970, '物流类 随车起重运输车 4×2 3系', NULL, 3896, 0, NULL, 'F', 0, 5, 101086),
(51969, '物流类 油罐车 牵引罐', NULL, 3896, 0, NULL, 'F', 0, 5, 101085),
(51968, '物流类 油罐车 8×4 6系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101084),
(51967, '物流类 油罐车 8×4 6系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101083),
(51966, '物流类 油罐车 8×4 6系', NULL, 3896, 0, NULL, 'F', 0, 5, 101082),
(51965, '物流类 油罐车 6×4 6系', NULL, 3896, 0, NULL, 'F', 0, 5, 101081),
(51964, '物流类 油罐车 6×2 5系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101080),
(51963, '物流类 油罐车 6×2 5系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101079),
(51962, '物流类 油罐车 6×2 5系', NULL, 3896, 0, NULL, 'F', 0, 5, 101078),
(51961, '物流类 油罐车 4×2 3系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101077),
(51960, '物流类 油罐车 4×2 轴距5000 3系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101076),
(51959, '物流类 油罐车 4×2 轴距5000 3系', NULL, 3896, 0, NULL, 'F', 0, 5, 101075),
(51958, '物流类 油罐车 4×2 3系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101074),
(51957, '物流类 油罐车 4×2 3系', NULL, 3896, 0, NULL, 'F', 0, 5, 101073),
(51956, '建设类 散装物料车 半挂罐 8×4 6系', NULL, 3896, 0, NULL, 'F', 0, 5, 101072),
(51955, '建设类 散装物料车 半挂罐 8×4 6系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101071),
(51954, '建设类 散装物料车 半挂罐 8×4 6系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101070),
(51953, '建设类 散装物料车 半挂罐 8×4 9系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101069),
(51952, '建设类 散装物料车 半挂罐 8×4 9系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101068),
(51951, '建设类 散装物料车 半挂罐 8×4 9系', NULL, 3896, 0, NULL, 'F', 0, 5, 101067),
(51950, '建设类 散装物料车 8×4 6系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101066),
(51949, '建设类 散装物料车 8×4 6系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101065),
(51948, '建设类 散装物料车 8×4 6系', NULL, 3896, 0, NULL, 'F', 0, 5, 101064),
(51947, '建设类 散装物料车 8×4 9系3', NULL, 3896, 0, NULL, 'F', 0, 5, 101063),
(51946, '建设类 散装物料车 8×4 9系2', NULL, 3896, 0, NULL, 'F', 0, 5, 101062),
(51945, '建设类 散装物料车 8×4 9系', NULL, 3896, 0, NULL, 'F', 0, 5, 101061),
(51944, '建设类 车载泵 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101060),
(51943, '建设类 搅拌车 8×4 15方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101059),
(51942, '建设类 搅拌车 8×4 15方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101058),
(51941, '建设类 搅拌车 8×4 15方', NULL, 3896, 0, NULL, 'F', 0, 5, 101057),
(51940, '建设类 搅拌车 8×4 12方4', NULL, 3896, 0, NULL, 'F', 0, 5, 101056),
(51939, '建设类 搅拌车 8×4 12方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101055),
(51938, '建设类 搅拌车 8×4 12方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101054),
(51937, '建设类 搅拌车 8×4 12方', NULL, 3896, 0, NULL, 'F', 0, 5, 101053),
(51936, '建设类 搅拌车 8×4 10方', NULL, 3896, 0, NULL, 'F', 0, 5, 101052),
(51935, '建设类 搅拌车 6×4 14方', NULL, 3896, 0, NULL, 'F', 0, 5, 101051),
(51934, '建设类 搅拌车 6×4 12方5', NULL, 3896, 0, NULL, 'F', 0, 5, 101050),
(51933, '建设类 搅拌车 6×4 12方4', NULL, 3896, 0, NULL, 'F', 0, 5, 101049),
(51932, '建设类 搅拌车 6×4 12方', NULL, 3896, 0, NULL, 'F', 0, 5, 101048),
(51931, '建设类 搅拌车 6×4 12方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101047),
(51930, '建设类 搅拌车 6×4 12方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101046),
(51929, '建设类 搅拌车 6×4 轴距4100 12方', NULL, 3896, 0, NULL, 'F', 0, 5, 101045),
(51928, '建设类 搅拌车 6×4 轴距3825 10方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101044),
(51927, '建设类 搅拌车 6×4 10方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101043),
(51926, '建设类 搅拌车 6×4 10方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101042),
(51925, '建设类 搅拌车 6×4 轴距3575 10方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101041),
(51924, '建设类 搅拌车 6×4 10方', NULL, 3896, 0, NULL, 'F', 0, 5, 101040),
(51923, '建设类 搅拌车 6×4 轴距3825 10方', NULL, 3896, 0, NULL, 'F', 0, 5, 101039),
(51922, '建设类 搅拌车 6×4 8/9方5', NULL, 3896, 0, NULL, 'F', 0, 5, 101038),
(51921, '建设类 搅拌车 6×4 8/9方4', NULL, 3896, 0, NULL, 'F', 0, 5, 101037),
(51920, '建设类 搅拌车 6×4 8/9方3', NULL, 3896, 0, NULL, 'F', 0, 5, 101036),
(51919, '建设类 搅拌车 6×4 8/9方2', NULL, 3896, 0, NULL, 'F', 0, 5, 101035),
(51918, '建设类 搅拌车 6×4 8/9方', NULL, 3896, 0, NULL, 'F', 0, 5, 101034),
(51917, '建设类 搅拌车 4×2 6方', NULL, 3896, 0, NULL, 'F', 0, 5, 101033),
(51916, '建设类 搅拌车 4×2 4方', NULL, 3896, 0, NULL, 'F', 0, 5, 101032),
(51915, 'VT-5系 载货车 6×2 2', NULL, 3896, 0, NULL, 'F', 0, 5, 101031),
(51914, 'VT-5系 载货车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101030),
(51913, 'VT-5系 载货车 8×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101029),
(51912, 'VT-5系 载货车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101028),
(51911, 'VT-5系 载货车 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101027),
(51910, 'VT-5系 自卸车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101026),
(51909, 'VT-5系 牵引车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101025),
(51908, 'VT-5系 牵引车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101024),
(51907, 'VT-6系 载货车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101023),
(51906, 'VT-6系 自卸车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101022),
(51905, 'VT-6系 自卸车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101021),
(51904, 'VT-6系 牵引车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101020),
(51903, 'VT-6系 牵引车 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101019),
(51902, 'VT-6系 牵引车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101018),
(51901, 'VT-9M 自卸车 9M 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101017),
(51900, 'VT-9系 自卸车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101016),
(51899, 'VT-9系 自卸车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101015),
(51898, 'VT-9系 牵引车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101014),
(51897, 'VT-9系 牵引车 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101013),
(51896, 'VT-9系 牵引车 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 101012);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(51895, 'CTX-1系 4×2 轴距3360 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101011),
(51894, 'CTX-1系 4×2 轴距3800 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101010),
(51893, 'CTX-1系 4×2 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101009),
(51892, 'CTX-1系 4×2 轴距5200 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101008),
(51891, 'CTX-3系 4×2 重载型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101007),
(51890, 'CTX-6系 载货车 8×4 4', NULL, 3896, 0, NULL, 'F', 0, 5, 101006),
(51889, 'CTX-6系 载货车 8×4 3', NULL, 3896, 0, NULL, 'F', 0, 5, 101005),
(51888, 'CTX-6系 载货车 8×4 2', NULL, 3896, 0, NULL, 'F', 0, 5, 101004),
(51887, 'CTX-6系 载货车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 101003),
(51886, 'CTX-6系 牵引车 6×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 101002),
(51885, 'CTX-6系 牵引车 6×4 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 101001),
(51884, 'CTX-6系 牵引车 6×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 101000),
(51883, 'CTX-6系 牵引车 6×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100999),
(51882, 'CTX-6系 牵引车 6×4 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100998),
(51881, 'CTX-6系 牵引车 6×4 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100997),
(51880, 'CTX-6系 牵引车 6×4 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100996),
(51879, 'CTX-6系 牵引车 6×4 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100995),
(51878, 'CTX-6系 牵引车 6×2 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100994),
(51877, 'CTX-6系 牵引车 6×2 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100993),
(51876, 'CTX-6系 牵引车 6×2 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100992),
(51875, 'CTX-6系 牵引车 6×2 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100991),
(51874, 'CTX-6系 牵引车 6×2 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100990),
(51873, 'CTX-6系 牵引车 6×2 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100989),
(51872, 'CTX-6系 牵引车 6×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100988),
(51871, 'CTX-6系 牵引车 6×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100987),
(51870, 'CTX-6系 牵引车 4×2 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100986),
(51869, 'CTX-6系 牵引车 4×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100985),
(51868, 'CTX-6系 牵引车 4×2 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100984),
(51867, 'CTX-6系 牵引车 4×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100983),
(51866, 'CTX-6系 牵引车 4×2 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100982),
(51865, 'CTX-6系 牵引车 4×2 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100981),
(51864, 'CTX-6系 牵引车 4×2 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100980),
(51863, 'CTX-6系 牵引车 4×2 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100979),
(51862, 'CTX-9系 载货车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100978),
(51861, 'CTX-9系 自卸车 8×4 后翻', NULL, 3896, 0, NULL, 'F', 0, 5, 100977),
(51860, 'CTX-9系 自卸车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100976),
(51859, 'CTX-9系 牵引车 6×4 重载型 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100975),
(51858, 'CTX-9系 牵引车 6×4 重载型 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100974),
(51857, 'CTX-9系 牵引车 6×4 重载型 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100973),
(51856, 'CTX-9系 牵引车 6×4 重载型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100972),
(51855, 'CTX-9系 牵引车 6×4 重载型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100971),
(51854, 'CTX-9系 牵引车 6×4 重载型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100970),
(51853, 'CTX-9系 牵引车 6×4 重载型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100969),
(51852, 'CTX-9系 牵引车 6×4 重载型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100968),
(51851, 'CTX-9系 牵引车 6×4 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100967),
(51850, 'CTX-9系 牵引车 6×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100966),
(51849, 'CTX-9系 牵引车 6×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100965),
(51848, 'CTX-9系 牵引车 6×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100964),
(51847, 'CTX-9系 牵引车 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100963),
(51846, 'CTX-9系 牵引车 4×2 重载型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100962),
(51845, 'CTX-9系 牵引车 4×2 重载型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100961),
(51844, 'CTX-9系 牵引车 4×2 重载型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100960),
(51843, 'CTX-9系 牵引车 4×2 重载型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100959),
(51842, 'CTX-9系 牵引车 4×2 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100958),
(51841, 'CTX-9系 牵引车 4×2 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100957),
(51840, 'CTX-9系 牵引车 4×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100956),
(51839, 'CTX-9系 牵引车 4×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100955),
(51838, 'ETX-3系 4×2 重载型 单体泵', NULL, 3896, 0, NULL, 'F', 0, 5, 100954),
(51837, 'ETX-3系 4×2 重载型 轴距5600 单体泵', NULL, 3896, 0, NULL, 'F', 0, 5, 100953),
(51836, 'ETX-3系 4×2 标准型 轴距5000 单体泵2', NULL, 3896, 0, NULL, 'F', 0, 5, 100952),
(51835, 'ETX-3系 4×2 标准型 轴距5000 单体泵', NULL, 3896, 0, NULL, 'F', 0, 5, 100951),
(51834, 'ETX-3系 4×2 标准型 单体泵2', NULL, 3896, 0, NULL, 'F', 0, 5, 100950),
(51833, 'ETX-3系 4×2 标准型 单体泵', NULL, 3896, 0, NULL, 'F', 0, 5, 100949),
(51832, 'ETX-6系 载货车 8×4 标准型 共轨14', NULL, 3896, 0, NULL, 'F', 0, 5, 100948),
(51831, 'ETX-6系 载货车 8×4 标准型 共轨13', NULL, 3896, 0, NULL, 'F', 0, 5, 100947),
(51830, 'ETX-6系 载货车 8×4 标准型 共轨12', NULL, 3896, 0, NULL, 'F', 0, 5, 100946),
(51829, 'ETX-6系 载货车 8×4 标准型 共轨11', NULL, 3896, 0, NULL, 'F', 0, 5, 100945),
(51828, 'ETX-6系 载货车 8×4 标准型 共轨10', NULL, 3896, 0, NULL, 'F', 0, 5, 100944),
(51827, 'ETX-6系 载货车 8×4 标准型 共轨9', NULL, 3896, 0, NULL, 'F', 0, 5, 100943),
(51826, 'ETX-6系 载货车 8×4 标准型 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100942),
(51825, 'ETX-6系 载货车 8×4 标准型 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100941),
(51824, 'ETX-6系 载货车 8×4 标准型 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100940),
(51823, 'ETX-6系 载货车 8×4 标准型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100939),
(51822, 'ETX-6系 载货车 8×4 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100938),
(51821, 'ETX-6系 载货车 8×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100937),
(51820, 'ETX-6系 载货车 8×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100936),
(51819, 'ETX-6系 载货车 8×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100935),
(51818, 'ETX-6系 载货车 8×4 重载型 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100934),
(51817, 'ETX-6系 载货车 8×4 重载型 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100933),
(51816, 'ETX-6系 载货车 8×4 重载型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100932),
(51815, 'ETX-6系 载货车 8×4 重载型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100931),
(51814, 'ETX-6系 载货车 8×4 重载型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100930),
(51813, 'ETX-6系 载货车 8×4 重载型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100929),
(51812, 'ETX-6系 载货车 8×4 重载型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100928),
(51811, 'ETX-6系 载货车 8×2F 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100927),
(51810, 'ETX-6系 载货车 8×2F 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100926),
(51809, 'ETX-6系 载货车 8×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100925),
(51808, 'ETX-6系 载货车 8×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100924),
(51807, 'ETX-6系 载货车 6×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100923),
(51806, 'ETX-6系 载货车 6×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100922),
(51805, 'ETX-6系 自卸车 8×4 标准型 共轨10', NULL, 3896, 0, NULL, 'F', 0, 5, 100921),
(51804, 'ETX-6系 自卸车 8×4 标准型 共轨9', NULL, 3896, 0, NULL, 'F', 0, 5, 100920),
(51803, 'ETX-6系 自卸车 8×4 标准型 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100919),
(51802, 'ETX-6系 自卸车 8×4 标准型 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100918),
(51801, 'ETX-6系 自卸车 8×4 标准型 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100917),
(51800, 'ETX-6系 自卸车 8×4 标准型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100916),
(51799, 'ETX-6系 自卸车 8×4 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100915),
(51798, 'ETX-6系 自卸车 8×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100914),
(51797, 'ETX-6系 自卸车 8×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100913),
(51796, 'ETX-6系 自卸车 8×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100912),
(51795, 'ETX-6系 自卸车 6×4 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100911),
(51794, 'ETX-6系 自卸车 6×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100910),
(51793, 'ETX-6系 自卸车 6×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100909),
(51792, 'ETX-6系 自卸车 6×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100908),
(51791, 'ETX-6系 牵引车 6×4 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100907),
(51790, 'ETX-6系 牵引车 6×4 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100906),
(51789, 'ETX-6系 牵引车 6×4 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100905),
(51788, 'ETX-6系 牵引车 6×4 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100904),
(51787, 'ETX-6系 牵引车 6×4 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100903),
(51786, 'ETX-6系 牵引车 6×4 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100902),
(51785, 'ETX-6系 牵引车 6×4 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100901),
(51784, 'ETX-6系 牵引车 6×2 高速型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100900),
(51783, 'ETX-6系 牵引车 6×2 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100899),
(51782, 'ETX-6系 牵引车 6×2 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100898),
(51781, 'ETX-6系 牵引车 6×2 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100897),
(51780, 'ETX-6系 牵引车 6×2 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100896),
(51779, 'ETX-6系 牵引车 6×2 标准型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100895),
(51778, 'ETX-6系 牵引车 6×2 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100894),
(51777, 'ETX-6系 牵引车 6×2 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100893),
(51776, 'ETX-6系 牵引车 6×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100892),
(51775, 'ETX-6系 牵引车 6×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100891),
(51774, 'ETX-6系 牵引车 4×2 高速型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100890),
(51773, 'ETX-6系 牵引车 4×2 高速型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100889),
(51772, 'ETX-6系 牵引车 4×2 高速型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100888),
(51771, 'ETX-6系 牵引车 4×2 高速型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100887),
(51770, 'ETX-6系 牵引车 4×2 高速型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100886),
(51769, 'ETX-6系 牵引车 4×2 标准型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100885),
(51768, 'ETX-6系 牵引车 4×2 标准型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100884),
(51767, 'ETX-6系 牵引车 4×2 标准型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100883),
(51766, 'ETX-6系 牵引车 4×2 标准型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100882),
(51765, 'ETX-9系 载货车 8×4 重载型 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100881),
(51764, 'ETX-9系 载货车 8×4 重载型 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100880),
(51763, 'ETX-9系 载货车 8×4 重载型 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100879),
(51762, 'ETX-9系 载货车 8×4 重载型 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100878),
(51761, 'ETX-9系 载货车 8×4 重载型 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100877),
(51760, 'ETX-9系 自卸车 绿动力 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100876),
(51759, 'ETX-9系 自卸车 重载型 8×4 侧翻 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100875),
(51758, 'ETX-9系 自卸车 标准型 8×4 侧翻 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100874),
(51757, 'ETX-9系 自卸车 标准型 8×4 侧翻 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100873),
(51756, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨 油浴空滤器', NULL, 3896, 0, NULL, 'F', 0, 5, 100872),
(51755, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨10', NULL, 3896, 0, NULL, 'F', 0, 5, 100871),
(51754, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨9', NULL, 3896, 0, NULL, 'F', 0, 5, 100870),
(51753, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100869),
(51752, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100868),
(51751, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100867),
(51750, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100866),
(51749, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100865),
(51748, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100864),
(51747, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100863),
(51746, 'ETX-9系 自卸车 重载型 8×4 后翻 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100862),
(51745, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨 油浴空滤器', NULL, 3896, 0, NULL, 'F', 0, 5, 100860),
(51744, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨10', NULL, 3896, 0, NULL, 'F', 0, 5, 100859),
(51743, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨9', NULL, 3896, 0, NULL, 'F', 0, 5, 100858),
(51742, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100857),
(51741, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100856),
(51740, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100855),
(51739, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100853),
(51738, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100852),
(51737, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100851),
(51736, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100850),
(51735, 'ETX-9系 自卸车 标准型 8×4 后翻 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100849),
(51734, 'ETX-9系 自卸车 重载型 6×4 轴距4100 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100848),
(51733, 'ETX-9系 自卸车 重载型 6×4 共轨 油浴空滤器3', NULL, 3896, 0, NULL, 'F', 0, 5, 100847),
(51732, 'ETX-9系 自卸车 重载型 6×4 共轨 油浴空滤器2', NULL, 3896, 0, NULL, 'F', 0, 5, 100846),
(51731, 'ETX-9系 自卸车 重载型 6×4 共轨 油浴空滤器', NULL, 3896, 0, NULL, 'F', 0, 5, 100845),
(51730, 'ETX-9系 自卸车 重载型 6×4 轴距3575 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100844),
(51729, 'ETX-9系 自卸车 重载型 6×4 轴距3575 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100843),
(51728, 'ETX-9系 自卸车 重载型 6×4 轴距4300 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100842),
(51727, 'ETX-9系 自卸车 重载型 6×4 轴距4100 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100841),
(51726, 'ETX-9系 自卸车 重载型 6×4 轴距4100 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100840),
(51725, 'ETX-9系 自卸车 重载型 6×4 轴距3825 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100839),
(51724, 'ETX-9系 自卸车 重载型 6×4 轴距3825 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100838),
(51723, 'ETX-9系 自卸车 重载型 6×4 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100837),
(51722, 'ETX-9系 自卸车 重载型 6×4 轴距3825 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100836),
(51721, 'ETX-9系 自卸车 重载型 6×4 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100835),
(51720, 'ETX-9系 自卸车 重载型 6×4 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100834),
(51719, 'ETX-9系 自卸车 重载型 6×4 轴距3575 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100833),
(51718, 'ETX-9系 自卸车 重载型 6×4 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100831),
(51717, 'ETX-9系 自卸车 重载型 6×4 轴距3200 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100830),
(51716, 'ETX-9系 自卸车 标准型 6×4 轴距4100 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100829),
(51715, 'ETX-9系 自卸车 标准型 6×4 共轨 油浴空滤器2', NULL, 3896, 0, NULL, 'F', 0, 5, 100828),
(51714, 'ETX-9系 自卸车 标准型 6×4 共轨 油浴空滤器', NULL, 3896, 0, NULL, 'F', 0, 5, 100827),
(51713, 'ETX-9系 自卸车 标准型 6×4 轴距3575 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100826),
(51712, 'ETX-9系 自卸车 标准型 6×4 轴距3575 共轨 油浴空', NULL, 3896, 0, NULL, 'F', 0, 5, 100825),
(51711, 'ETX-9系 自卸车 标准型 6×4 轴距4700 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100824),
(51710, 'ETX-9系 自卸车 标准型 6×4 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100823),
(51709, 'ETX-9系 自卸车 标准型 6×4 轴距4100 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100822),
(51708, 'ETX-9系 自卸车 标准型 6×4 轴距4100 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100821),
(51707, 'ETX-9系 自卸车 标准型 6×4 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100820),
(51706, 'ETX-9系 自卸车 标准型 6×4 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100819),
(51705, 'ETX-9系 自卸车 标准型 6×4 轴距3825 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100818),
(51704, 'ETX-9系 自卸车 标准型 6×4 轴距3825 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100817),
(51703, 'ETX-9系 自卸车 标准型 6×4 轴距3575 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100816),
(51702, 'ETX-9系 自卸车 标准型 6×4 轴距3575 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100815),
(51701, 'ETX-9系 自卸车 标准型 6×4 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100814),
(51700, 'ETX-9系 自卸车 标准型 6×4 轴距3575 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100813),
(51699, 'ETX-9系 自卸车 标准型 6×4 轴距3200 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100812),
(51698, 'ETX-9系 牵引车 绿动力 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100810),
(51697, 'ETX-9系 牵引车 标准型 6×4 共轨10', NULL, 3896, 0, NULL, 'F', 0, 5, 100809),
(51696, 'ETX-9系 牵引车 标准型 6×4 共轨9', NULL, 3896, 0, NULL, 'F', 0, 5, 100808),
(51695, 'ETX-9系 牵引车 标准型 6×4 共轨8', NULL, 3896, 0, NULL, 'F', 0, 5, 100807),
(51694, 'ETX-9系 牵引车 标准型 6×4 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100806),
(51693, 'ETX-9系 牵引车 标准型 6×4 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100805),
(51692, 'ETX-9系 牵引车 标准型 6×4 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100804),
(51691, 'ETX-9系 牵引车 标准型 6×4 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100803),
(51690, 'ETX-9系 牵引车 标准型 6×4 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100802),
(51689, 'ETX-9系 牵引车 标准型 6×4 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100801),
(51688, 'ETX-9系 牵引车 标准型 6×4 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100800),
(51687, 'ETX-9系 牵引车 重载型 6×4 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100799),
(51686, 'ETX-9系 牵引车 重载型 6×4 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100798),
(51685, 'ETX-9系 牵引车 重载型 6×4 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100797),
(51684, 'ETX-9系 牵引车 重载型 6×4 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100796),
(51683, 'ETX-9系 牵引车 重载型 6×4 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100795),
(51682, 'ETX-9系 牵引车 标准型 6×2 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100794),
(51681, 'ETX-9系 牵引车 标准型 6×2 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100793),
(51680, 'ETX-9系 牵引车 标准型 6×2 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100792),
(51679, 'ETX-9系 牵引车 标准型 6×2 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100791),
(51678, 'ETX-9系 牵引车 标准型 6×2 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100790),
(51677, 'ETX-9系 牵引车 标准型 6×2 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100789),
(51676, 'ETX-9系 牵引车 标准型 6×2 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100788),
(51675, 'ETX-9系 牵引车 重载型 6×2 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100787),
(51674, 'ETX-9系 牵引车 重载型 6×2 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100786),
(51673, 'ETX-9系 牵引车 重载型 6×2 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100785),
(51672, 'ETX-9系 牵引车 重载型 6×2 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100783),
(51671, 'ETX-9系 牵引车 重载型 6×2 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100782),
(51670, 'ETX-9系 牵引车 标准型 4×2 共轨7', NULL, 3896, 0, NULL, 'F', 0, 5, 100781),
(51669, 'ETX-9系 牵引车 标准型 4×2 共轨6', NULL, 3896, 0, NULL, 'F', 0, 5, 100780),
(51668, 'ETX-9系 牵引车 标准型 4×2 共轨5', NULL, 3896, 0, NULL, 'F', 0, 5, 100779),
(51667, 'ETX-9系 牵引车 标准型 4×2 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100778),
(51666, 'ETX-9系 牵引车 标准型 4×2 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100777),
(51665, 'ETX-9系 牵引车 标准型 4×2 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100776),
(51664, 'ETX-9系 牵引车 标准型 4×2 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100775),
(51663, 'ETX-9系 牵引车 重载型 4×2 共轨4', NULL, 3896, 0, NULL, 'F', 0, 5, 100774),
(51662, 'ETX-9系 牵引车 重载型 4×2 共轨3', NULL, 3896, 0, NULL, 'F', 0, 5, 100773),
(51661, 'ETX-9系 牵引车 重载型 4×2 共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100772),
(51660, 'ETX-9系 牵引车 重载型 4×2 共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100771),
(51659, 'GTL-6系 搅拌车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100770),
(51658, 'GTL-6系 平板车 标准型 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100769),
(51657, 'GTL-6系 平板车 重载型 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100768),
(51656, 'GTL-6系 牵引车 高速型 中短途 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100766),
(51655, 'GTL-6系 牵引车 高速型 长途 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100765),
(51654, 'GTL-6系 牵引车 标准型 中短途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100764),
(51653, 'GTL-6系 牵引车 标准型 中短途 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100763),
(51652, 'GTL-6系 牵引车 标准型 中短途 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100762),
(51651, 'GTL-6系 牵引车 标准型 长途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100761),
(51650, 'GTL-6系 牵引车 标准型 长途 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100760),
(51649, 'GTL-6系 牵引车 标准型 长途 4×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100759),
(51648, 'GTL-6系 牵引车 重载型 中短途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100758),
(51647, 'GTL-9系 泵车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100756),
(51646, 'GTL-9系 泵车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100755),
(51645, 'GTL-9系 搅拌车 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100754),
(51644, 'GTL-9系 搅拌车 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100753),
(51643, 'GTL-9系 自卸车 运输型 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100752),
(51642, 'GTL-9系 自卸车 运输型 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100751),
(51641, 'GTL-9系 自卸车 矿用工程型 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100750),
(51640, 'GTL-9系 平板车 重载型 8×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100749),
(51639, 'GTL-9系 牵引车 标准型 中短途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100748),
(51638, 'GTL-9系 牵引车 标准型 中短途 6×2', NULL, 3896, 0, NULL, 'F', 0, 5, 100747),
(51637, 'GTL-9系 牵引车 标准型 长途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100746),
(51636, 'GTL-9系 牵引车 重载型 中短途 6×4', NULL, 3896, 0, NULL, 'F', 0, 5, 100745),
(51635, 'GTL-6系 牵引车 超重载 中短途 6×4 标准型 高压共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100743),
(51634, 'GTL-6系 牵引车 超重载 中短途 6×4 标准型 电控喷油嘴', NULL, 3896, 0, NULL, 'F', 0, 5, 100742),
(51633, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 高压共轨2', NULL, 3896, 0, NULL, 'F', 0, 5, 100740),
(51632, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 电控喷油嘴', NULL, 3896, 0, NULL, 'F', 0, 5, 100738),
(51631, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 电控喷油嘴', NULL, 3896, 0, NULL, 'F', 0, 5, 100737),
(51630, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 轴距330', NULL, 3896, 0, NULL, 'F', 0, 5, 100736),
(51629, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 轴距360', NULL, 3896, 0, NULL, 'F', 0, 5, 100735),
(51628, 'GTL-9系 牵引车 超重载 中短途 6×4 标准型 高压共轨', NULL, 3896, 0, NULL, 'F', 0, 5, 100734),
(51627, 'C380 3.8L 超长轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15357),
(51626, 'C380 3.8L 长轴 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15356),
(51625, 'C380 3.8L 长轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15355),
(51624, 'C380 3.8L 中长轴 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15354),
(51623, 'C380 3.8L 中长轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15353),
(51622, 'C380 3.8L 中轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15352),
(51621, 'C380 3.8L 中轴 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15351),
(51620, 'C380 3.8L 中短轴 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15350),
(51619, 'C380 3.8L 中短轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15349),
(51618, 'C380 3.8L 短轴 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15348),
(51617, 'C380 3.8L 短轴 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15347),
(51616, 'C280 超短轴 2.8 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15346),
(51615, 'C280 长轴 2.8 双排(110Kw)', NULL, 3895, 0, NULL, 'F', 0, 5, 15345),
(51614, 'C280 长轴 2.8 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15344),
(51613, 'C280 长轴 2.8 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15343),
(51612, 'C280 中长轴 2.8 单排(110Kw)', NULL, 3895, 0, NULL, 'F', 0, 5, 15340),
(51611, 'C280 中轴 2.8 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15333),
(51610, 'C280 短轴 2.8 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15332),
(51609, 'C280 中长轴 2.8 双排(110Kw)', NULL, 3895, 0, NULL, 'F', 0, 5, 15331),
(51608, 'C280 中长轴 2.8 双排', NULL, 3895, 0, NULL, 'F', 0, 5, 15330),
(51607, 'C280 中长轴 2.8 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15322),
(51606, 'C280 中轴 2.8 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15321),
(51605, 'C280 短轴 2.8 单排', NULL, 3895, 0, NULL, 'F', 0, 5, 15320),
(51604, '宜家版 1.6L 豪华型', NULL, 3894, 0, NULL, 'F', 0, 5, 8220),
(51603, '宜家版 1.6L 运动型', NULL, 3894, 0, NULL, 'F', 0, 5, 8219),
(51602, '宜家版 1.6L 标准型', NULL, 3894, 0, NULL, 'F', 0, 5, 8218),
(51601, '宜家版 1.3L 豪华型', NULL, 3894, 0, NULL, 'F', 0, 5, 8217),
(51600, '宜家版 1.3L 标准型', NULL, 3894, 0, NULL, 'F', 0, 5, 8216),
(51599, '宜商版 1.6L 舒适型长车身', NULL, 3894, 0, NULL, 'F', 0, 5, 8215),
(51598, '宜商版 1.6L 标准型长车身', NULL, 3894, 0, NULL, 'F', 0, 5, 8214),
(51597, '宜商版 1.3L 舒适型长车身', NULL, 3894, 0, NULL, 'F', 0, 5, 8213),
(51596, '宜商版 1.3L 标准型长车身', NULL, 3894, 0, NULL, 'F', 0, 5, 7927),
(51595, '宜商版标准型 1.3L 国Ⅲ', NULL, 3893, 0, NULL, 'F', 0, 5, 14319),
(51594, '宜家版豪华版 1.6L 国IV(4G18S)', NULL, 3893, 0, NULL, 'F', 0, 5, 14318),
(51593, '宜家版豪华版 1.5L 国IV(4A91)', NULL, 3893, 0, NULL, 'F', 0, 5, 14309),
(51592, '1.6L 手动 宜商版 升级版 柴油', NULL, 3893, 0, NULL, 'F', 0, 5, 13421),
(51591, '1.6L 手动 宜商版 标准版 柴油', NULL, 3893, 0, NULL, 'F', 0, 5, 13420),
(51590, '宜商版标准升级型1.6L 国IV(4G18S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13419),
(51589, '宜商版标准型 1.6L 国IV(4G18S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13418),
(51588, '宜商版标准升级型 1.5L 国IV(4A91)', NULL, 3893, 0, NULL, 'F', 0, 5, 13417),
(51587, '宜商版标准型 1.5L 国IV(4A91)', NULL, 3893, 0, NULL, 'F', 0, 5, 13416),
(51586, '宜商版标准升级型 1.5L 国IV(4G15S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13415),
(51585, '宜商版标准型 1.5L 国IV(4G15S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13414),
(51584, '1.3L 手动 宜商版 升级版', NULL, 3893, 0, NULL, 'F', 0, 5, 13413),
(51583, '宜家版标准型 1.6L 国IV(4G18S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13412),
(51582, '宜家版标准升级型 1.6L 国IV(4G18S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13411),
(51581, '宜家版标准型 1.5L 国IV(4G15S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13410),
(51580, '宜家版标准升级型 1.5L 国IV(4G15S)', NULL, 3893, 0, NULL, 'F', 0, 5, 13409),
(51579, '宜家版标准型 1.5L 国IV(4A91)', NULL, 3893, 0, NULL, 'F', 0, 5, 13408),
(51578, '宜家版标准升级型 1.5L 国IV(4A91)', NULL, 3893, 0, NULL, 'F', 0, 5, 13407),
(51577, '1.3L 手动 宜家版 标准版', NULL, 3893, 0, NULL, 'F', 0, 5, 13406),
(51576, '1.3L 手动 宜家版 升级版', NULL, 3893, 0, NULL, 'F', 0, 5, 12899),
(51575, '1.3L 手动 宜商版 标准版', NULL, 3893, 0, NULL, 'F', 0, 5, 12896),
(51574, '1.5L 宜商版 基本型 国IV版 4G15', NULL, 3892, 0, NULL, 'F', 0, 5, 111399),
(51573, '1.3L 宜商版 标准型 国IV版 4G13', NULL, 3892, 0, NULL, 'F', 0, 5, 111398),
(51572, '1.3L 宜商版 标准型 国IV版 4A90', NULL, 3892, 0, NULL, 'F', 0, 5, 111397),
(51571, '1.5L 宜商版 标准型 国IV版 4G15', NULL, 3892, 0, NULL, 'F', 0, 5, 111396),
(51570, '1.5L 宜商版 标准型 国IV版 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111395),
(51569, '1.6L 宜商版 标准型 国IV版 4G18', NULL, 3892, 0, NULL, 'F', 0, 5, 111394),
(51568, '1.3L 宜商版 升级型 国IV版 4G13', NULL, 3892, 0, NULL, 'F', 0, 5, 111393),
(51567, '1.3L 宜商版 升级型 国IV版 4A90', NULL, 3892, 0, NULL, 'F', 0, 5, 111392),
(51566, ' 1.5L 宜商版 升级型 国IV版 4G15', NULL, 3892, 0, NULL, 'F', 0, 5, 111391),
(51565, ' 1.5L 宜商版 升级型 国IV版 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111390),
(51564, ' 1.6L 宜商版 升级型 国IV版 4G18', NULL, 3892, 0, NULL, 'F', 0, 5, 111389),
(51563, ' 1.3L 宜商版 豪华型 国IV版 4G13', NULL, 3892, 0, NULL, 'F', 0, 5, 111383),
(51562, ' 1.3L 宜商版 豪华型 国IV版 4A90', NULL, 3892, 0, NULL, 'F', 0, 5, 111382),
(51561, ' 1.5L 宜商版 豪华型 国IV版 4G15', NULL, 3892, 0, NULL, 'F', 0, 5, 111381),
(51560, ' 1.5L 宜商版 豪华型 国IV版 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111380),
(51559, ' 1.5L 宜商版 豪华型 国IV版', NULL, 3892, 0, NULL, 'F', 0, 5, 111379),
(51558, ' 1.6L 宜商版 豪华型 国V 4G18', NULL, 3892, 0, NULL, 'F', 0, 5, 111377),
(51557, ' 1.3L 宜商版 标准型 国V 4A90', NULL, 3892, 0, NULL, 'F', 0, 5, 111376),
(51556, ' 1.5L 宜商版 标准型 国V 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111375),
(51555, ' 1.3L 宜商版 升级型 国V 4A90  ', NULL, 3892, 0, NULL, 'F', 0, 5, 111374),
(51554, ' 1.5L 宜商版 升级型 国V 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111367),
(51553, ' 1.3L 宜商版 豪华型 国V 4A90', NULL, 3892, 0, NULL, 'F', 0, 5, 111366),
(51552, ' 1.5L 宜商版 豪华型 国V 4A91', NULL, 3892, 0, NULL, 'F', 0, 5, 111363),
(51551, '2.8L 手动 经典型 财富快车 柴油长轴', NULL, 3891, 0, NULL, 'F', 0, 5, 104273),
(51550, '2.8L 手动 豪华型 新干线 柴油长轴', NULL, 3891, 0, NULL, 'F', 0, 5, 104272),
(51549, '2.8L 手动 标准型 新干线 柴油长轴', NULL, 3891, 0, NULL, 'F', 0, 5, 104271),
(51548, '2.4L 手动 豪华型 新干线 汽油长轴', NULL, 3891, 0, NULL, 'F', 0, 5, 104270),
(51547, '2.4L 手动 标准型 新干线 汽油长轴', NULL, 3891, 0, NULL, 'F', 0, 5, 104262),
(51546, '商务舱舒适版 长轴X280DSL', NULL, 3890, 0, NULL, 'F', 0, 5, 6932),
(51545, '商务舱舒适版 长轴X240SL 国Ⅳ', NULL, 3890, 0, NULL, 'F', 0, 5, 6931),
(51544, '商务舱舒适版 长轴X240SL', NULL, 3890, 0, NULL, 'F', 0, 5, 6930),
(51543, '商务舱舒适版 短轴X280DS', NULL, 3890, 0, NULL, 'F', 0, 5, 6929),
(51542, '商务舱舒适版短轴 X240S 国IV', NULL, 3890, 0, NULL, 'F', 0, 5, 6928),
(51541, '商务舱舒适版短轴 X240S', NULL, 3890, 0, NULL, 'F', 0, 5, 6927),
(51540, '陆地公务机豪华版长轴 P280DGL', NULL, 3890, 0, NULL, 'F', 0, 5, 6926),
(51539, '陆地公务机豪华版短轴 P280DG', NULL, 3890, 0, NULL, 'F', 0, 5, 6925),
(51538, '陆地公务机豪华版长轴 P240GL', NULL, 3890, 0, NULL, 'F', 0, 5, 6923),
(51537, '陆地公务机豪华版短轴 P240G 国IV', NULL, 3890, 0, NULL, 'F', 0, 5, 6921),
(51536, '财富快车 标准版长轴 M280（DL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6548),
(51535, '财富快车 标准版长轴 M200（L）', NULL, 3890, 0, NULL, 'F', 0, 5, 6547),
(51534, '财富快车 舒适版长轴 M280（DSL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6546),
(51533, '财富快车 舒适版长轴 M200（SL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6545),
(51532, '商务舱 标准版长轴 X280（DL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6544),
(51531, '商务舱 标准版长轴 X240（L）', NULL, 3890, 0, NULL, 'F', 0, 5, 6543),
(51530, '商务舱 标准版长轴 X200（L）', NULL, 3890, 0, NULL, 'F', 0, 5, 6542),
(51529, '商务舱 标准版短轴 X280（D）', NULL, 3890, 0, NULL, 'F', 0, 5, 6541),
(51528, '商务舱 标准版短轴 X240', NULL, 3890, 0, NULL, 'F', 0, 5, 6540),
(51527, '商务舱 标准版短轴 X200', NULL, 3890, 0, NULL, 'F', 0, 5, 6539),
(51526, '商务舱 豪华版长轴 X280（DGL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6538),
(51525, '商务舱 豪华版长轴 X240（GL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6537),
(51524, '商务舱 豪华版长轴 X200（GL）', NULL, 3890, 0, NULL, 'F', 0, 5, 6536),
(51523, '商务舱 豪华版短轴 X280（DG）', NULL, 3890, 0, NULL, 'F', 0, 5, 6535),
(51522, '商务舱 豪华版短轴 X240（G）', NULL, 3890, 0, NULL, 'F', 0, 5, 6534),
(51521, '商务舱 豪华版短轴 X200（G）', NULL, 3890, 0, NULL, 'F', 0, 5, 6533),
(51520, '陆地公务机豪华版短轴 P240GL', NULL, 3890, 0, NULL, 'F', 0, 5, 6532),
(51519, '陆地公务机豪华版短轴 P240G', NULL, 3890, 0, NULL, 'F', 0, 5, 6531),
(51518, '商务舱超豪华型X250GL—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8612),
(51517, '商务舱超豪华型X250GL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8611),
(51516, '商务舱超豪华型X250GL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8610),
(51515, '商务舱超豪华型X250G—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8609),
(51514, '商务舱超豪华型X250G—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8608),
(51513, '商务舱超豪华型X240GL—11座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8607),
(51512, '商务舱超豪华型X240GL—9座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8606),
(51511, '商务舱超豪华型X240GL—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8605),
(51510, '商务舱超豪华型X240G—8座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8604),
(51509, '商务舱超豪华型X240G—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8603),
(51508, '商务舱超豪华型X240GL—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8602),
(51507, '商务舱超豪华型X240GL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8601),
(51506, '商务舱超豪华型X240GL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8600),
(51505, '商务舱超豪华型X240G—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8599),
(51504, '商务舱超豪华型X240G—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8598),
(51503, '财富快车舒适型M250S—8座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8597),
(51502, '财富快车舒适型M250S—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8596),
(51501, '财富快车标准型M250—8座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8595),
(51500, '财富快车标准型M250—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8594),
(51499, '财富快车舒适型M240SL—11座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8593),
(51498, '财富快车舒适型M240SL—9座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8592),
(51497, '财富快车舒适型M240SL—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8591),
(51496, '财富快车标准型M240L—11座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8590),
(51495, '财富快车标准型M240L—9座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8589),
(51494, '财富快车标准型M240L—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8588),
(51493, '财富快车舒适型M200S—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8587),
(51492, '财富快车舒适型M200S—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8586),
(51491, '财富快车标准型M200L—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8585),
(51490, '财富快车舒适型M280SL—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8584),
(51489, '财富快车舒适型M250SL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8583),
(51488, '财富快车舒适型M250SL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8582),
(51487, '财富快车标准型M280L—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8579),
(51486, '财富快车标准型M250L—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8578),
(51485, '财富快车标准型M250L—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8577),
(51484, '财富快车舒适型M200SL—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8576),
(51483, '财富快车舒适型M200SL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8575),
(51482, '财富快车舒适型M200SL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8574),
(51481, '财富快车标准型M200L—11座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8573),
(51480, '财富快车标准型M200L—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8572),
(51479, '财富快车标准型M200L—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8571),
(51478, '陆地公务机豪华型P250GL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8570),
(51477, '陆地公务机豪华型P250GL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8569),
(51476, '陆地公务机豪华型P250G—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8568),
(51475, '陆地公务机豪华型P250G—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8567),
(51474, '陆地公务机豪华型P250G—6座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8566),
(51473, '陆地公务机豪华型P240GL—9座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8565),
(51472, '陆地公务机豪华型P240GL—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8564),
(51471, '陆地公务机豪华型P240G—8座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8560),
(51470, '陆地公务机豪华型P240G—7座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8559),
(51469, '陆地公务机豪华型P240G—6座 国Ⅳ', NULL, 3889, 0, NULL, 'F', 0, 5, 8558),
(51468, '陆地公务机豪华型P240GL—9座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8557),
(51467, '陆地公务机豪华型P240GL—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8556),
(51466, '陆地公务机豪华型P240G—8座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8555),
(51465, '陆地公务机豪华型P240G—7座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8554),
(51464, '陆地公务机豪华型P240G—6座 国III', NULL, 3889, 0, NULL, 'F', 0, 5, 8553),
(51463, '2.8L 手动 商务舱 柴油 长轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 14323),
(51462, '2.4L 手动 商务舱 汽油 长轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 14322),
(51461, '2.8L 手动 商务舱 柴油 长轴 低配版', NULL, 3888, 0, NULL, 'F', 0, 5, 14321),
(51460, '2.4L 手动 商务舱 汽油 长轴', NULL, 3888, 0, NULL, 'F', 0, 5, 14320),
(51459, '2.8L 手动 财富快车 柴油 长轴', NULL, 3888, 0, NULL, 'F', 0, 5, 14317),
(51458, '2.8L 手动 财富快车 柴油 短轴', NULL, 3888, 0, NULL, 'F', 0, 5, 14316),
(51457, '2.4L 手动 财富快车 汽油 长轴', NULL, 3888, 0, NULL, 'F', 0, 5, 14315),
(51456, '2.4L 手动 财富快车 汽油 短轴', NULL, 3888, 0, NULL, 'F', 0, 5, 14314),
(51455, '2.8L 手动 财富快车 柴油', NULL, 3888, 0, NULL, 'F', 0, 5, 14313),
(51454, '2.4L 手动 财富快车 汽油', NULL, 3888, 0, NULL, 'F', 0, 5, 14312),
(51453, '2.0L 手动 财富快车 汽油', NULL, 3888, 0, NULL, 'F', 0, 5, 14311),
(51452, '陆地公务机 双天窗版车身 ISF2.8T', NULL, 3888, 0, NULL, 'F', 0, 5, 13293),
(51451, '陆地公务机 双天窗版车身 4JB1TDi', NULL, 3888, 0, NULL, 'F', 0, 5, 13292),
(51450, '陆地公务机 双天窗版车身 4Gi-VVT', NULL, 3888, 0, NULL, 'F', 0, 5, 13291),
(51449, '2.4L 手动 陆地公务机 汽油 长轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 13290),
(51448, '2.4L 手动 陆地公务机 汽油 短轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 13289),
(51447, '商务舱 双天窗版车身 ISF2.8T 豪华版', NULL, 3888, 0, NULL, 'F', 0, 5, 13288),
(51446, '2.8L 手动 商务舱 柴油 短轴 低配版', NULL, 3888, 0, NULL, 'F', 0, 5, 13287),
(51445, '2.8L 手动 商务舱 柴油 短轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 13286),
(51444, '商务舱 双天窗版车身 4JB1TDi 标准版', NULL, 3888, 0, NULL, 'F', 0, 5, 13285),
(51443, '商务舱 双天窗版车身 4Gi-VVT 豪华版', NULL, 3888, 0, NULL, 'F', 0, 5, 13284),
(51442, '商务舱 双天窗版车身 4Gi-VVT 标准版', NULL, 3888, 0, NULL, 'F', 0, 5, 13283),
(51441, '商务舱 双天窗版车身 4G64 豪华版(89.5kw)', NULL, 3888, 0, NULL, 'F', 0, 5, 13282),
(51440, '商务舱 双天窗版车身 4G64 标准版(89.5kw)', NULL, 3888, 0, NULL, 'F', 0, 5, 13281),
(51439, '商务舱 双天窗版车身 4G64 豪华版', NULL, 3888, 0, NULL, 'F', 0, 5, 13280),
(51438, '2.4L 手动 商务舱 汽油 短轴', NULL, 3888, 0, NULL, 'F', 0, 5, 13278),
(51437, '财富快车 双天窗版车身 ISF2.8T 经典版', NULL, 3888, 0, NULL, 'F', 0, 5, 13276),
(51436, '财富快车 双天窗版车身 ISF2.8T 舒适版', NULL, 3888, 0, NULL, 'F', 0, 5, 13275),
(51435, '财富快车 双天窗版车身 4JB1TDi 舒适版', NULL, 3888, 0, NULL, 'F', 0, 5, 13274),
(51434, '财富快车 双天窗版车身 4JB1TDi 经典版', NULL, 3888, 0, NULL, 'F', 0, 5, 13273),
(51433, '财富快车 双天窗版车身 4Gi-VVT 舒适版', NULL, 3888, 0, NULL, 'F', 0, 5, 13272),
(51432, '财富快车 双天窗版车身 4Gi-VVT 经典版', NULL, 3888, 0, NULL, 'F', 0, 5, 13271),
(51431, '财富快车 双天窗版车身 4G64 舒适版', NULL, 3888, 0, NULL, 'F', 0, 5, 13270),
(51430, '财富快车 双天窗版车身 4G64 经典版', NULL, 3888, 0, NULL, 'F', 0, 5, 13269),
(51429, '财富快车 双天窗版车身 4G63 舒适版', NULL, 3888, 0, NULL, 'F', 0, 5, 13268),
(51428, '财富快车 双天窗版车身 4G63 经典版', NULL, 3888, 0, NULL, 'F', 0, 5, 13267),
(51427, '财富快车经典版M200L 国四', NULL, 3888, 0, NULL, 'F', 0, 5, 12895),
(51426, '财富快车经典版M280L', NULL, 3888, 0, NULL, 'F', 0, 5, 12894),
(51425, '财富快车经典版M200L', NULL, 3888, 0, NULL, 'F', 0, 5, 12893),
(51424, '财富快车舒适版M280SL', NULL, 3888, 0, NULL, 'F', 0, 5, 12892),
(51423, '财富快车舒适版M240SL', NULL, 3888, 0, NULL, 'F', 0, 5, 12891),
(51422, '商务舱标准版X280DL', NULL, 3888, 0, NULL, 'F', 0, 5, 12885),
(51421, '商务舱豪华版X240GL', NULL, 3888, 0, NULL, 'F', 0, 5, 12884),
(51420, '2.4L 手动 商务舱 汽油 短轴 高配版', NULL, 3888, 0, NULL, 'F', 0, 5, 12883),
(51419, '2.8L 手动 财富快车经典版 柴油简配长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 104811),
(51418, '2.8L 手动 财富快车经典版 柴油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 104810),
(51417, '2.0L 手动 财富快车经典版 汽油 VVT 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102451),
(51416, '2.8L 手动 财富快车经典版 柴油 短轴 国4', NULL, 3887, 0, NULL, 'F', 0, 5, 102448),
(51415, '2.0L 手动 财富快车经典版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102447),
(51414, '2.0L 手动 财富快车经典版 汽油 VVT 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102445),
(51413, '2.8L 手动 财富快车经典版 柴油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102444),
(51412, '2.4L 手动 财富快车经典版 汽油 简配 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102443),
(51411, '2.8L 手动 财富快车经典版 柴油 简配 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102442),
(51410, '2.4L 手动 财富快车经典版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 102440),
(51409, '2.4L 手动 商务舱 标准版', NULL, 3887, 0, NULL, 'F', 0, 5, 102438),
(51408, '2.4L 手动 商务舱 豪华版', NULL, 3887, 0, NULL, 'F', 0, 5, 102437),
(51407, '2.4L 手动 陆地公务机旗舰版', NULL, 3887, 0, NULL, 'F', 0, 5, 102435),
(51406, '2.4L 手动 政务版 旗舰型', NULL, 3887, 0, NULL, 'F', 0, 5, 102165),
(51405, '公务版 2.4L 手动 天窗舒适版 汽油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 101915),
(51404, '财富快车 2.4L 手动 天窗舒适版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 101914),
(51403, '2.8L 手动 财富快车经典版 柴油 长轴 高顶', NULL, 3887, 0, NULL, 'F', 0, 5, 100457),
(51402, '商务舱 2.4L 手动 豪华版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100456),
(51401, '商务舱 2.8L 手动 豪华版 柴油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100455),
(51400, '商务舱 2.4L 手动 豪华版 汽油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100454),
(51399, '商务舱 2.8L 手动 标准版 柴油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100453),
(51398, '商务舱 2.4L 手动 标准版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100452),
(51397, '商务舱 2.8L 手动 标准版 柴油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100451),
(51396, '商务舱 2.4L 手动 标准版 汽油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100450),
(51395, '财富快车 2.8L 手动 舒适版 柴油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100449),
(51394, '财富快车 2.4L 手动 舒适版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100448),
(51393, '财富快车 2.0L 手动 舒适版 汽油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100447),
(51392, '财富快车 2.8L 手动 舒适版 柴油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100445),
(51391, '公务版 2.4L 手动 舒适版 汽油 短轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100442),
(51390, '财富快车 2.0L 手动 舒适版 汽油 长轴', NULL, 3887, 0, NULL, 'F', 0, 5, 100441),
(51389, '财富快车 2.8L 手动 经典版 柴油', NULL, 3887, 0, NULL, 'F', 0, 5, 100440),
(51388, '财富快车 2.4L 手动 经典版 汽油', NULL, 3887, 0, NULL, 'F', 0, 5, 100439),
(51387, '财富快车 2.0L 手动 经典版 汽油', NULL, 3887, 0, NULL, 'F', 0, 5, 100438),
(51386, '财富快车舒适版 手动', NULL, 3887, 0, NULL, 'F', 0, 5, 16288),
(51385, '2.0L 手动 经典版 长轴 9座 四门 汽油版', NULL, 3886, 0, NULL, 'F', 0, 5, 104269),
(51384, 'HGR', NULL, 3885, 0, NULL, 'F', 0, 5, 116),
(51383, 'HGG', NULL, 3885, 0, NULL, 'F', 0, 5, 115),
(51382, 'HGM', NULL, 3885, 0, NULL, 'F', 0, 5, 114),
(51381, '快运II厢车', NULL, 3884, 0, NULL, 'F', 0, 5, 149),
(51380, '快运I厢车', NULL, 3884, 0, NULL, 'F', 0, 5, 140),
(51379, 'KZE——CL', NULL, 3883, 0, NULL, 'F', 0, 5, 4992),
(51378, 'KPD—A', NULL, 3883, 0, NULL, 'F', 0, 5, 4991),
(51377, 'KPM——A', NULL, 3883, 0, NULL, 'F', 0, 5, 4990),
(51376, '快运III', NULL, 3883, 0, NULL, 'F', 0, 5, 156),
(51375, '快运II加长版', NULL, 3883, 0, NULL, 'F', 0, 5, 155),
(51374, '快运II—1L', NULL, 3883, 0, NULL, 'F', 0, 5, 154),
(51373, '快运IIL', NULL, 3883, 0, NULL, 'F', 0, 5, 153),
(51372, '快运II—1', NULL, 3883, 0, NULL, 'F', 0, 5, 151),
(51371, '快运II', NULL, 3883, 0, NULL, 'F', 0, 5, 150),
(51370, '快运I—5L +后空调、双侧风道', NULL, 3883, 0, NULL, 'F', 0, 5, 148),
(51369, '快运I—5L +助力转向', NULL, 3883, 0, NULL, 'F', 0, 5, 147),
(51368, '快运I—1L', NULL, 3883, 0, NULL, 'F', 0, 5, 146),
(51367, '快运IL', NULL, 3883, 0, NULL, 'F', 0, 5, 145),
(51366, '快运I—5 +后空调', NULL, 3883, 0, NULL, 'F', 0, 5, 144),
(51365, '快运I—5 +助力转向', NULL, 3883, 0, NULL, 'F', 0, 5, 143),
(51364, '快运II', NULL, 3882, 0, NULL, 'F', 0, 5, 152),
(51363, '柴油 长轴 舒适型', NULL, 3881, 0, NULL, 'F', 0, 5, 9013),
(51362, '柴油 长轴 标准型', NULL, 3881, 0, NULL, 'F', 0, 5, 9012),
(51361, '柴油 长轴 经典型', NULL, 3881, 0, NULL, 'F', 0, 5, 9011),
(51360, '柴油 短轴 舒适型', NULL, 3881, 0, NULL, 'F', 0, 5, 9010),
(51359, '柴油 短轴 标准型', NULL, 3881, 0, NULL, 'F', 0, 5, 9009),
(51358, '柴油 短轴 经典型', NULL, 3881, 0, NULL, 'F', 0, 5, 9008),
(51357, '汽油 长轴 舒适型', NULL, 3881, 0, NULL, 'F', 0, 5, 9007),
(51356, '汽油 长轴 标准型', NULL, 3881, 0, NULL, 'F', 0, 5, 9006),
(51355, '汽油 长轴 经典型', NULL, 3881, 0, NULL, 'F', 0, 5, 9005),
(51354, '汽油 短轴 舒适型', NULL, 3881, 0, NULL, 'F', 0, 5, 9004),
(51353, '汽油 短轴 标准型', NULL, 3881, 0, NULL, 'F', 0, 5, 142),
(51352, '汽油 短轴 经典型', NULL, 3881, 0, NULL, 'F', 0, 5, 141),
(51351, '2.8L 经典型 柴油4JB1T 长轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13460),
(51350, '2.0L 经典型 柴油4D20 长轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13459),
(51349, '2.0L 经典型 汽油486EQV4 长轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13457),
(51348, '2.2L 经典型 汽油491EQ4 长轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13455),
(51347, '2.0L 经典型 汽油486EQV4 短轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13451),
(51346, '2.0L 经典型 柴油4D20 短轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13436),
(51345, '2.2L 经典型 汽油491EQ4 短轴低顶', NULL, 3880, 0, NULL, 'F', 0, 5, 13431),
(51344, '2.5L 标准型 柴油493ZQ3B 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13470),
(51343, '2.8L 标准型 柴油4JB1T 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13469),
(51342, '2.0L 标准型 柴油4D20 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13468),
(51341, '2.0L 标准型 汽油4G63S4M 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13467),
(51340, '2.0L 标准型 汽油486EQV4 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13466),
(51339, '2.2L 标准型 汽油491EQ4A 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13465);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(51338, '2.2L 标准型 汽油491EQ4 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13464),
(51337, '2.2L 标准型 汽油491EQ3A 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13463),
(51336, '2.0L 经典型 汽油4G63S4M 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13462),
(51335, '2.5L 经典型 柴油493ZQ3B 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13461),
(51334, '2.2L 标准型 汽油491EQ3 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13458),
(51333, '2.2L 经典型 汽油491EQ4A 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13456),
(51332, '2.2L 经典型 汽油491EQ3A 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13454),
(51331, '2.2L 经典型 汽油491EQ3 长轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13453),
(51330, '2.0L 标准型 汽油4G63S4M 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13452),
(51329, '2.5L 标准型 柴油493ZQ3B 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13450),
(51328, '2.8L 标准型 柴油4JB1T 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13449),
(51327, '2.0L 标准型 柴油4D20 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13448),
(51326, '2.2L 标准型 汽油491EQ4A 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13447),
(51325, '2.2L 标准型 汽油491EQ4 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13446),
(51324, '2.2L 标准型 汽油491EQ3A 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13445),
(51323, '2.5L 经典型 柴油493ZQ3B 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13444),
(51322, '2.2L 标准型 汽油491EQ3 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13443),
(51321, '2.8L 经典型 柴油4JB1T 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13441),
(51320, '2.2L 经典型 汽油491EQ3 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13437),
(51319, '2.0L 标准型 汽油486EQV4 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13434),
(51318, '2.2L 经典型 汽油491EQ4A 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13433),
(51317, '2.2L 经典型 汽油491EQ3A 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13430),
(51316, '2.0L 经典型 汽油4G63S4M 短轴低顶', NULL, 3879, 0, NULL, 'F', 0, 5, 13425),
(51315, '舒适版TZV4-SL', NULL, 3879, 0, NULL, 'F', 0, 5, 12924),
(51314, '标准版KZQ4A-BL', NULL, 3879, 0, NULL, 'F', 0, 5, 12921),
(51313, '标准版KPQ4A-B', NULL, 3879, 0, NULL, 'F', 0, 5, 12920),
(51312, '经典版KZE3B-AL', NULL, 3879, 0, NULL, 'F', 0, 5, 12918),
(51311, '经典版KPK3-A', NULL, 3879, 0, NULL, 'F', 0, 5, 12917),
(51310, '经典版KPGA-A', NULL, 3879, 0, NULL, 'F', 0, 5, 12912),
(51309, '2.0L 手动 标准型 汽油 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 104703),
(51308, '2.0L 手动 标准型 柴油 4D20 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102472),
(51307, '2.8L 手动 标准型 柴油 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102471),
(51306, '2.0L 手动 标准型 汽油 VVT 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102470),
(51305, '2.0L 手动 标准型 汽油', NULL, 3878, 0, NULL, 'F', 0, 5, 102469),
(51304, '2.0L 手动 经典型 柴油 4D20 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102468),
(51303, '2.8L 手动 经典型 柴油 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102467),
(51302, '2.0L 手动 经典型 汽油 VVT 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102466),
(51301, '2.0L 手动 经典型 汽油 长轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102465),
(51300, '2.0L 手动 标准型 柴油 4D20短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102459),
(51299, '2.8L 手动 标准型 柴油 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102458),
(51298, '2.0L 手动 标准型 汽油 VVT 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102457),
(51297, '2.0L 手动 标准型 汽油 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102456),
(51296, '2.0L 手动 经典型 柴油 4D20短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102455),
(51295, '2.8L 手动 经典型 柴油 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102454),
(51294, '2.0L 手动 经典型 汽油 VVT 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102453),
(51293, '2.2L 手动 经典型 汽油 短轴', NULL, 3878, 0, NULL, 'F', 0, 5, 102452),
(51292, '2.0L 486EQV4 汽油 长轴中顶 11座 标准版', NULL, 3878, 0, NULL, 'F', 0, 5, 101566),
(51291, '2.2L 491EQ4 汽油 长轴高顶 14座 标准版', NULL, 3878, 0, NULL, 'F', 0, 5, 101565),
(51290, '2.0L 486EQV4 汽油 长轴高顶 6座 标准版', NULL, 3878, 0, NULL, 'F', 0, 5, 101563),
(51289, '2.0L 486EQV4 汽油 长轴高顶 2座 标准版', NULL, 3878, 0, NULL, 'F', 0, 5, 101561),
(51288, '2.2L 491EQ4 汽油 2座 标准版', NULL, 3878, 0, NULL, 'F', 0, 5, 101558),
(51287, '2.0L 手动 经典型 汽油 短轴', NULL, 3877, 0, NULL, 'F', 0, 5, 103394),
(51286, 'TPM——A', NULL, 3876, 0, NULL, 'F', 0, 5, 4996),
(51285, 'TZE——CL', NULL, 3876, 0, NULL, 'F', 0, 5, 4995),
(51284, 'TZD——CL', NULL, 3876, 0, NULL, 'F', 0, 5, 4994),
(51283, 'TPD——A', NULL, 3876, 0, NULL, 'F', 0, 5, 4993),
(51282, 'BJ5036XJH-2型救护车 7座', NULL, 3875, 0, NULL, 'F', 0, 5, 16287),
(51281, 'BJ5036XJH-2型救护车 2座', NULL, 3875, 0, NULL, 'F', 0, 5, 16286),
(51280, 'BJ5026A12WA-S型救护车 9座', NULL, 3875, 0, NULL, 'F', 0, 5, 16285),
(51279, 'BJ5026A12WA-S型救护车 5座', NULL, 3875, 0, NULL, 'F', 0, 5, 16284),
(51278, '2.8L 豪华型 4JB1T 11座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 14331),
(51277, '2.2L 豪华型 491EQ4 11座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 14330),
(51276, '2.0L 豪华型 486EQV4 11座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 14329),
(51275, '2.8L 豪华型 4JB1T 11座', NULL, 3875, 0, NULL, 'F', 0, 5, 14327),
(51274, '2.8L 舒适型 4JB1T 6座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 14325),
(51273, '2.0L 舒适型 4D20 6座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 14324),
(51272, '2.8L 舒适型 4JB1T 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13442),
(51271, '2.0L 豪华型 486EQV4 11座', NULL, 3875, 0, NULL, 'F', 0, 5, 13440),
(51270, '2.2L 豪华型 491EQ4 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13439),
(51269, '2.2L 豪华型 491EQ3 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13438),
(51268, '2.5L 舒适型 493ZQ3B 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13435),
(51267, '2.8L 舒适型 493ZQ3 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13432),
(51266, '2.0L 舒适型 4D20 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13429),
(51265, '2.0L 舒适型 486EQV4 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13428),
(51264, '2.2L 舒适型 491EQ4 6座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 13427),
(51263, '2.2L 舒适型 491EQ4 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13426),
(51262, '2.0L 舒适型 486EQV4 6座 长轴', NULL, 3875, 0, NULL, 'F', 0, 5, 13424),
(51261, '2.2L 舒适型 491EQ3 6座', NULL, 3875, 0, NULL, 'F', 0, 5, 13423),
(51260, '舒适版TPK3-S', NULL, 3875, 0, NULL, 'F', 0, 5, 12925),
(51259, '舒适版TPGA-S', NULL, 3875, 0, NULL, 'F', 0, 5, 12923),
(51258, '舒适版TZE3B-SL', NULL, 3875, 0, NULL, 'F', 0, 5, 12922),
(51257, '豪华版TPQ4-H', NULL, 3875, 0, NULL, 'F', 0, 5, 12919),
(51256, '豪华版TZQ4-HL', NULL, 3875, 0, NULL, 'F', 0, 5, 12916),
(51255, '经典版KZV4-AL', NULL, 3875, 0, NULL, 'F', 0, 5, 12915),
(51254, '2.0L 手动 豪华型 汽油 VVT 长轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102478),
(51253, '2.2L 手动 豪华型 汽油 长轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102476),
(51252, '2.8L 手动 舒适型 柴油 长轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102475),
(51251, '2.0L 手动 舒适型 汽油 VVT 长轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102474),
(51250, '2.2L 手动 舒适型 汽油 长轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102473),
(51249, '2.0L 手动 豪华型 汽油 VVT 短轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102464),
(51248, '2.2L 手动 豪华型 汽油 短轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102463),
(51247, '2.0L 手动 舒适型 柴油 短轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102462),
(51246, '2.0L 手动 舒适型 汽油 VVT 短轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102461),
(51245, '2.0L 手动 舒适型 汽油 短轴', NULL, 3874, 0, NULL, 'F', 0, 5, 102460),
(51244, 'CRV豪华型II', NULL, 3873, 0, NULL, 'F', 0, 5, 121),
(51243, 'CRV豪华型I', NULL, 3873, 0, NULL, 'F', 0, 5, 120),
(51242, '柴油标准型', NULL, 3873, 0, NULL, 'F', 0, 5, 119),
(51241, '汽油标准型', NULL, 3873, 0, NULL, 'F', 0, 5, 118),
(51240, '基本型', NULL, 3873, 0, NULL, 'F', 0, 5, 117),
(51239, 'BJ6468M16XA—S2', NULL, 3872, 0, NULL, 'F', 0, 5, 157),
(51238, 'BJ6468M16XA—2', NULL, 3871, 0, NULL, 'F', 0, 5, 158),
(51237, 'BJ6468M16DA—A2', NULL, 3870, 0, NULL, 'F', 0, 5, 160),
(51236, 'BJ6468M16VA—S2', NULL, 3870, 0, NULL, 'F', 0, 5, 159),
(51235, '捷运 4.7L 103kw(轴距5200)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 101274),
(51234, '捷运 4.7L 103kw(轴距4700)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 101273),
(51233, '捷运 3.7L 81kw(轴距3360)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100581),
(51232, '捷运 3.7L 81kw(轴距3360)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100580),
(51231, '捷运 3.9L 70kw(轴距3360)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100579),
(51230, '捷运 3.9L 70kw(轴距3360)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100577),
(51229, '捷运 3.2L 76kw(轴距3360)单排2', NULL, 3869, 0, NULL, 'F', 0, 5, 100576),
(51228, '捷运 3.2L 76kw(轴距3360)排半2', NULL, 3869, 0, NULL, 'F', 0, 5, 100575),
(51227, '捷运 3.2L 88kw(轴距3800)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100574),
(51226, '捷运 3.2L 88kw(轴距3800)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100573),
(51225, '捷运 3.2L 76kw(轴距3360)双排', NULL, 3869, 0, NULL, 'F', 0, 5, 100572),
(51224, '捷运 3.9L 88kw(轴距3800)排半2', NULL, 3869, 0, NULL, 'F', 0, 5, 100571),
(51223, '捷运 3.9L 88kw(轴距3800)单排2', NULL, 3869, 0, NULL, 'F', 0, 5, 100570),
(51222, '捷运 3.2L 76kw(轴距3360)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100569),
(51221, '捷运 4.0L 95kw(轴距3800)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100568),
(51220, '捷运 4.0L 95kw(轴距3800)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100567),
(51219, '捷运 3.2L 76kw(轴距3360)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100566),
(51218, '捷运 4.0L 95kw(轴距4200)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100565),
(51217, '捷运 4.0L 95kw(轴距4500)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100562),
(51216, '捷运 4.0L 95kw(轴距4500)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100561),
(51215, '捷运 3.9L 88kw(轴距4500)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100559),
(51214, '捷运 2.1L 52kw(轴距2800)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100556),
(51213, '捷运 2.1L 52kw(轴距2800)双排', NULL, 3869, 0, NULL, 'F', 0, 5, 100555),
(51212, '捷运 2.1L 52kw(轴距2800)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100554),
(51211, '捷运 3.9L 88kw(轴距4500)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100553),
(51210, '捷运 2.1L 52kw(轴距2600)双排', NULL, 3869, 0, NULL, 'F', 0, 5, 100552),
(51209, '捷运 2.1L 52kw(轴距2600)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100551),
(51208, '捷运 2.1L 52kw(轴距2600)单排', NULL, 3869, 0, NULL, 'F', 0, 5, 100549),
(51207, '捷运 4.3L 118kw(轴距5600)排半', NULL, 3869, 0, NULL, 'F', 0, 5, 100548),
(51206, 'TX 2.8L(85kw)(轴距3360)排半2', NULL, 3868, 0, NULL, 'F', 0, 5, 100595),
(51205, 'TX 2.8L(85kw)(轴距3360)单排2', NULL, 3868, 0, NULL, 'F', 0, 5, 100594),
(51204, 'TX 2.8L(70kw)(轴距3360)单排2', NULL, 3868, 0, NULL, 'F', 0, 5, 100593),
(51203, 'TX 2.8L(70kw)(轴距3360)排半2', NULL, 3868, 0, NULL, 'F', 0, 5, 100592),
(51202, 'TX 2.8L(76kw)(轴距3360)排半2', NULL, 3868, 0, NULL, 'F', 0, 5, 100591),
(51201, 'TX 2.8L(76kw)(轴距3360)单排2', NULL, 3868, 0, NULL, 'F', 0, 5, 100590),
(51200, 'TX 2.8L(76kw)(轴距3360)双排', NULL, 3868, 0, NULL, 'F', 0, 5, 100589),
(51199, 'TX 2.8L(76kw)(轴距3360)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100588),
(51198, 'TX 2.8L(76kw)(轴距3360)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100587),
(51197, 'TX 2.8L(85kw)(轴距3360)双排', NULL, 3868, 0, NULL, 'F', 0, 5, 100586),
(51196, 'TX 2.8L(85kw)(轴距3360)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100585),
(51195, 'TX 2.8L(85kw)(轴距3360)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100584),
(51194, 'TX 2.8L(70kw)(轴距3360)双排', NULL, 3868, 0, NULL, 'F', 0, 5, 100583),
(51193, 'TX 2.8L(70kw)(轴距3360)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100582),
(51192, 'TX 2.8L(70kw)(轴距3360)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100578),
(51191, 'TX 2.8L(76kw)(轴距2800)单排2', NULL, 3868, 0, NULL, 'F', 0, 5, 100558),
(51190, 'TX 2.8L(76kw)(轴距2800)双排2', NULL, 3868, 0, NULL, 'F', 0, 5, 100557),
(51189, 'TX 2.8L(76kw)(轴距2800)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100550),
(51188, 'TX 2.8L(76kw)(轴距2800)双排', NULL, 3868, 0, NULL, 'F', 0, 5, 100547),
(51187, 'TX 2.8L(76kw)(轴距2800)排半2', NULL, 3868, 0, NULL, 'F', 0, 5, 100546),
(51186, 'TX 2.8L(76kw)(轴距2800)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100545),
(51185, 'TX 2.8L(85kw)(轴距2800)双排', NULL, 3868, 0, NULL, 'F', 0, 5, 100533),
(51184, 'TX 2.8L(85kw)(轴距2800)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100529),
(51183, 'TX 2.8L(85kw)(轴距2800)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100527),
(51182, 'TX 4.0L(101kw)(轴距5200)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100522),
(51181, 'TX 4.0L(101kw)(轴距4700)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100520),
(51180, 'TX 4.0L(101kw)(轴距4500)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100518),
(51179, 'TX 4.0L(101kw)(轴距4500)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100515),
(51178, 'TX 4.0L(101kw)(轴距4200)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100514),
(51177, 'TX 4.0L(101kw)(轴距3800)排半', NULL, 3868, 0, NULL, 'F', 0, 5, 100512),
(51176, 'TX 4.0L(101kw)(轴距3800)单排', NULL, 3868, 0, NULL, 'F', 0, 5, 100504),
(51175, 'CTX 一排半(轴距5200)', NULL, 3867, 0, NULL, 'F', 0, 5, 10758),
(51174, 'CTX 一排半(轴距4700)', NULL, 3867, 0, NULL, 'F', 0, 5, 10757),
(51173, 'CTX 一排半(轴距4500)', NULL, 3867, 0, NULL, 'F', 0, 5, 10756),
(51172, 'CTX 单排(轴距4500)', NULL, 3867, 0, NULL, 'F', 0, 5, 10755),
(51171, 'CTX 单排(轴距3800)', NULL, 3867, 0, NULL, 'F', 0, 5, 10754),
(51170, 'CTX 一排半(轴距3800)', NULL, 3867, 0, NULL, 'F', 0, 5, 10753),
(51169, 'CTX 一排半(轴距3360)', NULL, 3867, 0, NULL, 'F', 0, 5, 10752),
(51168, 'CTX 单排(轴距3360)', NULL, 3867, 0, NULL, 'F', 0, 5, 10751),
(51167, 'BJ1069VCJEA—D', NULL, 3867, 0, NULL, 'F', 0, 5, 9627),
(51166, '节能型', NULL, 3867, 0, NULL, 'F', 0, 5, 139),
(51165, '精品II型', NULL, 3867, 0, NULL, 'F', 0, 5, 138),
(51164, '精品I型', NULL, 3867, 0, NULL, 'F', 0, 5, 137),
(51163, '豪华II型', NULL, 3867, 0, NULL, 'F', 0, 5, 136),
(51162, '豪华I型', NULL, 3867, 0, NULL, 'F', 0, 5, 135),
(51161, '标准II型', NULL, 3867, 0, NULL, 'F', 0, 5, 134),
(51160, '标准I型', NULL, 3867, 0, NULL, 'F', 0, 5, 133),
(51159, '柴油 2.8L (670公斤)', NULL, 3866, 0, NULL, 'F', 0, 5, 10354),
(51158, '柴油 2.8L (475公斤)', NULL, 3866, 0, NULL, 'F', 0, 5, 10353),
(51157, 'TX 2.2L(76kw)(轴距3360)双排', NULL, 3865, 0, NULL, 'F', 0, 5, 100564),
(51156, 'TX 2.2L(76kw)(轴距3360)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100563),
(51155, 'TX 2.2L(76kw)(轴距3360)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100560),
(51154, 'CTX 3.8L 115kw(轴距5200)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100544),
(51153, 'CTX 3.8L 125kw(轴距4700)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100543),
(51152, 'CTX 3.8L 115kw(轴距4700)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100542),
(51151, 'CTX 3.8L 115kw(轴距4500)单排 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100541),
(51150, 'CTX 3.8L 115kw(轴距4500)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100540),
(51149, 'CTX 3.8L 115kw(轴距3800)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100539),
(51148, 'CTX 3.8L 115kw(轴距3800)单排 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100538),
(51147, 'CTX 3.8L 105kw(轴距3360)单排 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100537),
(51146, 'CTX 3.8L 105kw(轴距3360)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100536),
(51145, 'CTX 3.8L 105kw(轴距3360)单排2 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100535),
(51144, 'CTX 3.8L 105kw(轴距3360)排半2 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100534),
(51143, 'CTX 3.8L 96kw(轴距3360)单排2 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100532),
(51142, 'CTX 3.8L 96kw(轴距3360)排半2 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100531),
(51141, 'CTX 3.8L 96kw(轴距3360)排半 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100530),
(51140, 'CTX 3.8L 96kw(轴距3360)单排 国4', NULL, 3865, 0, NULL, 'F', 0, 5, 100528),
(51139, 'CTX 3.8L 125kw(轴距5600)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100526),
(51138, 'CTX 3.8L 125kw(轴距5200)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100525),
(51137, 'CTX 3.8L 115kw(轴距5200)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100524),
(51136, 'CTX 3.8L 125kw(轴距4700)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100523),
(51135, 'CTX 3.8L 115kw(轴距4700)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100521),
(51134, 'CTX 3.8L 105kw(轴距4500)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100519),
(51133, 'CTX 3.8L 105kw(轴距4500)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100517),
(51132, 'CTX 3.8L 115kw(轴距4500)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100516),
(51131, 'CTX 3.8L 115kw(轴距4500)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100513),
(51130, 'CTX 3.8L 115kw(轴距4200)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100507),
(51129, 'CTX 3.8L 115kw(轴距3800)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100506),
(51128, 'CTX 3.8L 115kw(轴距3800)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100505),
(51127, 'CTX 3.8L 105kw(轴距3360)排半2', NULL, 3865, 0, NULL, 'F', 0, 5, 100502),
(51126, 'CTX 3.8L 105kw(轴距3360)单排2', NULL, 3865, 0, NULL, 'F', 0, 5, 100501),
(51125, 'CTX 3.8L 105kw(轴距3360)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100500),
(51124, 'CTX 3.8L 105kw(轴距3360)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100498),
(51123, 'CTX 3.8L 96kw(轴距3360)排半2', NULL, 3865, 0, NULL, 'F', 0, 5, 100497),
(51122, 'CTX 3.8L 96kw(轴距3360)单排2', NULL, 3865, 0, NULL, 'F', 0, 5, 100496),
(51121, 'CTX 3.8L 96kw(轴距3360)排半', NULL, 3865, 0, NULL, 'F', 0, 5, 100495),
(51120, '2012版 4.3L(118kw)(轴距5200)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100493),
(51119, 'CTX 3.8L 96kw(轴距3360)单排', NULL, 3865, 0, NULL, 'F', 0, 5, 100492),
(51118, '2012版 4.3L(118kw)(轴距5200)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100491),
(51117, '2012版 4.3L(105kw)(轴距5200)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100490),
(51116, '2012版 4.3L(105kw)(轴距5200)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100488),
(51115, '2012版 4.3L(105kw)(轴距4700)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100487),
(51114, '2012版 4.3L(105kw)(轴距4700)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100485),
(51113, '2012版 3.8L(125kw)(轴距5200)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100484),
(51112, '2012版 3.8L(125kw)(轴距5200)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100483),
(51111, '2012版 3.8L(115kw)(轴距5200)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100482),
(51110, '2012版 3.8L(115kw)(轴距5200)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100481),
(51109, '2012版 3.8L(115kw)(轴距4700)厢式车', NULL, 3865, 0, NULL, 'F', 0, 5, 100480),
(51108, '2012版 3.8L(115kw)(轴距4700)平板车', NULL, 3865, 0, NULL, 'F', 0, 5, 100477),
(51107, '6.3L', NULL, 3864, 0, NULL, 'F', 0, 5, 13976),
(51106, 'Spider', NULL, 3863, 0, NULL, 'F', 0, 5, 4272),
(51105, 'Coupe', NULL, 3863, 0, NULL, 'F', 0, 5, 3638),
(51104, '430 Scuderia Spider', NULL, 3862, 0, NULL, 'F', 0, 5, 8535),
(51103, 'Scuderia Coupe', NULL, 3861, 0, NULL, 'F', 0, 5, 8479),
(51102, '基本型', NULL, 3860, 0, NULL, 'F', 0, 5, 8534),
(51101, '30 4.3L 基本型', NULL, 3859, 0, NULL, 'F', 0, 5, 101253),
(51100, 'T 3.8T 基本型', NULL, 3858, 0, NULL, 'F', 0, 5, 110883),
(51099, '599 GTB Fiorano', NULL, 3857, 0, NULL, 'F', 0, 5, 4273),
(51098, '599 GTO', NULL, 3856, 0, NULL, 'F', 0, 5, 109735),
(51097, 'Italia 4.5L 标准型', NULL, 3855, 0, NULL, 'F', 0, 5, 12593),
(51096, 'Italia 4.5L 标准型', NULL, 3854, 0, NULL, 'F', 0, 5, 109593),
(51095, '458 Italia 中国限量版', NULL, 3853, 0, NULL, 'F', 0, 5, 100264),
(51094, '458 Spider', NULL, 3852, 0, NULL, 'F', 0, 5, 104883),
(51093, '458 Speciale', NULL, 3851, 0, NULL, 'F', 0, 5, 105877),
(51092, '456M GTA', NULL, 3850, 0, NULL, 'F', 0, 5, 3635),
(51091, '456M GT', NULL, 3850, 0, NULL, 'F', 0, 5, 3634),
(51090, '6.3L 标准型', NULL, 3849, 0, NULL, 'F', 0, 5, 103160),
(51089, '612 OTO', NULL, 3848, 0, NULL, 'F', 0, 5, 8478),
(51088, '612 Scaglietti', NULL, 3848, 0, NULL, 'F', 0, 5, 3639),
(51087, '575M Maranello', NULL, 3847, 0, NULL, 'F', 0, 5, 3636),
(51086, '360 Spider', NULL, 3846, 0, NULL, 'F', 0, 5, 8972),
(51085, '360 Modena', NULL, 3845, 0, NULL, 'F', 0, 5, 3637),
(51084, '360 Modena F1', NULL, 3844, 0, NULL, 'F', 0, 5, 10267),
(51083, '2.8L 手动 柴油 NHQ1029LD2', NULL, 3843, 0, NULL, 'F', 0, 5, 111491),
(51082, '2.8L 手动 柴油 NHQ1029L2Y', NULL, 3843, 0, NULL, 'F', 0, 5, 111490),
(51081, '2.4L 手动 汽油 NHQ1029LF9', NULL, 3843, 0, NULL, 'F', 0, 5, 102520),
(51080, '2.4L 手动 汽油 NHQ1029LF9Y', NULL, 3843, 0, NULL, 'F', 0, 5, 102518),
(51079, '豪华型', NULL, 3842, 0, NULL, 'F', 0, 5, 10272),
(51078, '超豪华型', NULL, 3841, 0, NULL, 'F', 0, 5, 10271),
(51077, 'NHQ6480E', NULL, 3840, 0, NULL, 'F', 0, 5, 2958),
(51076, '柴油版', NULL, 3839, 0, NULL, 'F', 0, 5, 2966),
(51075, '2.4L 手动 两驱 汽油 NHQ6492F9', NULL, 3838, 0, NULL, 'F', 0, 5, 102517),
(51074, '2.4L 手动 四驱 汽油 NHQ6492F9Y', NULL, 3838, 0, NULL, 'F', 0, 5, 102516),
(51073, '2.5L 两驱 柴油 NHQ6492D3', NULL, 3838, 0, NULL, 'F', 0, 5, 15201),
(51072, '四驱 柴油 NHQ6492M3 2.8L', NULL, 3838, 0, NULL, 'F', 0, 5, 12909),
(51071, '2.8L 两驱 柴油 NHQ6492M3 ', NULL, 3838, 0, NULL, 'F', 0, 5, 12908),
(51070, '2.0L 两驱 汽油 NHQ6492F4', NULL, 3838, 0, NULL, 'F', 0, 5, 12907),
(51069, '2.8L 两驱 柴油 NHQ6492Q3 ', NULL, 3838, 0, NULL, 'F', 0, 5, 12906),
(51068, '2.2L 两驱 柴油 NHQ6492A4 ', NULL, 3838, 0, NULL, 'F', 0, 5, 12905),
(51067, '2.8L 手动 两驱 柴油 NHQ6492D2', NULL, 3837, 0, NULL, 'F', 0, 5, 106402),
(51066, 'NHQ6470EG5柴油精英型', NULL, 3836, 0, NULL, 'F', 0, 5, 2957),
(51065, 'NHQ6470EG2Y精英型', NULL, 3836, 0, NULL, 'F', 0, 5, 2956),
(51064, 'NHQ6470EG4实用型', NULL, 3836, 0, NULL, 'F', 0, 5, 2955),
(51063, '汽油 NHQ6490A3/A3D', NULL, 3835, 0, NULL, 'F', 0, 5, 6940),
(51062, '柴油 NHQ6490Q3', NULL, 3835, 0, NULL, 'F', 0, 5, 6939),
(51061, '2.0L 手动 两驱 柴油 NHQ6490D1', NULL, 3834, 0, NULL, 'F', 0, 5, 102521),
(51060, '柴油 NHQ6490V3', NULL, 3834, 0, NULL, 'F', 0, 5, 15206),
(51059, '汽油NHQ6490A4', NULL, 3834, 0, NULL, 'F', 0, 5, 15205),
(51058, '汽油简配型', NULL, 3833, 0, NULL, 'F', 0, 5, 2961),
(51057, '柴油 NHQ6510Q3', NULL, 3832, 0, NULL, 'F', 0, 5, 6938),
(51056, '柴油 NHQ6510V3', NULL, 3832, 0, NULL, 'F', 0, 5, 2960),
(51055, '汽油 NHQ6510A3/A3D', NULL, 3832, 0, NULL, 'F', 0, 5, 2959),
(51054, '2.2L 两驱 汽油 NHQ6510A4', NULL, 3831, 0, NULL, 'F', 0, 5, 14296),
(51053, '2.8L NHQ6510V3 柴油', NULL, 3831, 0, NULL, 'F', 0, 5, 14295),
(51052, 'A3 豪华型', NULL, 3830, 0, NULL, 'F', 0, 5, 9954),
(51051, 'Q3 豪华型', NULL, 3830, 0, NULL, 'F', 0, 5, 9953),
(51050, 'Q3 标准型', NULL, 3830, 0, NULL, 'F', 0, 5, 6937),
(51049, 'A3 标准型', NULL, 3830, 0, NULL, 'F', 0, 5, 6936),
(51048, 'V3 豪华型', NULL, 3830, 0, NULL, 'F', 0, 5, 2963),
(51047, 'V3 标准型', NULL, 3830, 0, NULL, 'F', 0, 5, 2962),
(51046, 'NHQ1028V3 电控', NULL, 3829, 0, NULL, 'F', 0, 5, 12933),
(51045, 'NHQ1028V3', NULL, 3829, 0, NULL, 'F', 0, 5, 12932),
(51044, 'NHQ1028Q3', NULL, 3829, 0, NULL, 'F', 0, 5, 12931),
(51043, 'NHQ1027A3/A3D', NULL, 3829, 0, NULL, 'F', 0, 5, 12930),
(51042, '2.0L 手动 NHQ1028LD1加长版', NULL, 3828, 0, NULL, 'F', 0, 5, 16367),
(51041, '2.0L 手动 NHQ1028D1', NULL, 3828, 0, NULL, 'F', 0, 5, 16366),
(51040, '2.2L 手动 NHQ1027LA4加长版', NULL, 3828, 0, NULL, 'F', 0, 5, 16365),
(51039, '2.2L 手动 NHQ1027A4', NULL, 3828, 0, NULL, 'F', 0, 5, 16364),
(51038, '2.8L 四驱 柴油 1028Q3Y', NULL, 3828, 0, NULL, 'F', 0, 5, 14304),
(51037, '2.8L 1028LV3 加长箱 柴油', NULL, 3828, 0, NULL, 'F', 0, 5, 14303),
(51036, '2.8L NHQ1028D1 柴油', NULL, 3828, 0, NULL, 'F', 0, 5, 14302),
(51035, 'NHQ1028V3', NULL, 3828, 0, NULL, 'F', 0, 5, 14239),
(51034, 'NHQ1028V3 电控', NULL, 3828, 0, NULL, 'F', 0, 5, 14238),
(51033, 'NHQ1028Q3', NULL, 3828, 0, NULL, 'F', 0, 5, 14237),
(51032, 'NHQ1027A3/A3D', NULL, 3828, 0, NULL, 'F', 0, 5, 14236),
(51031, 'LV3 豪华型', NULL, 3827, 0, NULL, 'F', 0, 5, 9956),
(51030, '柴油 NHQ1021LV3', NULL, 3826, 0, NULL, 'F', 0, 5, 9955),
(51029, '汽油 NHQ1021A3/A3D', NULL, 3826, 0, NULL, 'F', 0, 5, 2964),
(51028, '2.2L 手动 NHQ1027LA4加长版', NULL, 3825, 0, NULL, 'F', 0, 5, 16369),
(51027, '2.2L 手动 NHQ1021A4', NULL, 3825, 0, NULL, 'F', 0, 5, 16368),
(51026, '2.8L NHQ1021LV3 加长货厢 柴油', NULL, 3825, 0, NULL, 'F', 0, 5, 14301),
(51025, '2.0L NHQ1021LV3 加长货厢 柴油', NULL, 3825, 0, NULL, 'F', 0, 5, 14300),
(51024, '2.8L NHQ1021D1 柴油', NULL, 3825, 0, NULL, 'F', 0, 5, 14299),
(51023, '2.0L NHQ1021D1 柴油', NULL, 3825, 0, NULL, 'F', 0, 5, 14298),
(51022, '2.2L NHQ1021A4 汽油', NULL, 3825, 0, NULL, 'F', 0, 5, 14297),
(51021, '2.2L 手动 NHQ1027LA4', NULL, 3824, 0, NULL, 'F', 0, 5, 111496),
(51020, '2.2L 手动 NHQ1027LA4 小超人加长版', NULL, 3824, 0, NULL, 'F', 0, 5, 111495),
(51019, '2.0L 手动 NHQ1021LD1', NULL, 3824, 0, NULL, 'F', 0, 5, 111494),
(51018, '2.0L 手动 NHQ1021LD1 加长版', NULL, 3824, 0, NULL, 'F', 0, 5, 111492),
(51017, '2.8L 四驱  NHQ1028Q3Y', NULL, 3823, 0, NULL, 'F', 0, 5, 13345),
(51016, '2.8L 四驱 NHQ1028Q3Y', NULL, 3822, 0, NULL, 'F', 0, 5, 14240),
(51015, '豪华型', NULL, 3821, 0, NULL, 'F', 0, 5, 2965),
(51014, '四驱 汽油 精英型 （NHQ6470EG2Y）', NULL, 3820, 0, NULL, 'F', 0, 5, 9058),
(51013, '两驱 汽油 实用型 （NHQ6470EG4）', NULL, 3820, 0, NULL, 'F', 0, 5, 9057),
(51012, '两驱 汽油 精英型 （NHQ6470EG2Y）', NULL, 3820, 0, NULL, 'F', 0, 5, 9056),
(51011, '两驱 柴油 精英型（ NHQ6470EG5）', NULL, 3820, 0, NULL, 'F', 0, 5, 9055),
(51010, '6500两驱型', NULL, 3819, 0, NULL, 'F', 0, 5, 2862),
(51009, '6500四驱型', NULL, 3818, 0, NULL, 'F', 0, 5, 2863),
(51008, 'FQ6510B2 柴油 四驱', NULL, 3817, 0, NULL, 'F', 0, 5, 2869),
(51007, 'FQ6510B1 汽油两驱自动档', NULL, 3817, 0, NULL, 'F', 0, 5, 2868),
(51006, 'FQ6510B1 汽油四驱自动档', NULL, 3817, 0, NULL, 'F', 0, 5, 2867),
(51005, 'FQ6510C 汽油 两驱', NULL, 3817, 0, NULL, 'F', 0, 5, 2866),
(51004, 'FQ6510B2 柴油 两驱', NULL, 3817, 0, NULL, 'F', 0, 5, 2865),
(51003, 'FQ6510B 汽油 四驱', NULL, 3817, 0, NULL, 'F', 0, 5, 2864),
(51002, '3.0L 手动两驱', NULL, 3816, 0, NULL, 'F', 0, 5, 10420),
(51001, '豪华2.2手动两驱 柴油(450公斤)', NULL, 3815, 0, NULL, 'F', 0, 5, 10419),
(51000, '超豪华2.2手动两驱 柴油(450公斤)', NULL, 3815, 0, NULL, 'F', 0, 5, 10418),
(50999, '2.4L 手动四驱', NULL, 3814, 0, NULL, 'F', 0, 5, 10416),
(50998, '3.0L 手动四驱', NULL, 3813, 0, NULL, 'F', 0, 5, 10417),
(50997, '豪华2.2手动 (500公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10415),
(50996, '豪华2.2手动 柴油(480公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10414),
(50995, '超豪华2.2手动 (500公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10413),
(50994, '超豪华2.2手动 柴油(480公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10412),
(50993, '豪华2.2手动 柴油 长轴(480公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10411),
(50992, '超豪华2.2手动 柴油 长轴(480公斤)', NULL, 3812, 0, NULL, 'F', 0, 5, 10410),
(50991, '2.8L 手动', NULL, 3811, 0, NULL, 'F', 0, 5, 6832),
(50990, 'Grande Punto朋多 活力版', NULL, 3810, 0, NULL, 'F', 0, 5, 6033),
(50989, 'Grande Punto朋多 时尚版', NULL, 3810, 0, NULL, 'F', 0, 5, 6032),
(50988, '1.6L ELX 自动', NULL, 3809, 0, NULL, 'F', 0, 5, 10268),
(50987, '精英版', NULL, 3808, 0, NULL, 'F', 0, 5, 6030),
(50986, '活力版', NULL, 3808, 0, NULL, 'F', 0, 5, 6029),
(50985, '2.0L ', NULL, 3807, 0, NULL, 'F', 0, 5, 6835),
(50984, '2.4L 豪华 7座', NULL, 3806, 0, NULL, 'F', 0, 5, 15742),
(50983, '2.4L 舒适 5座', NULL, 3806, 0, NULL, 'F', 0, 5, 15741),
(50982, '3.6L 智能全驱版 7座', NULL, 3805, 0, NULL, 'F', 0, 5, 103738),
(50981, '2.4L 豪华导航版 7座', NULL, 3805, 0, NULL, 'F', 0, 5, 103737),
(50980, '2.4L 限量炫酷版 7座', NULL, 3804, 0, NULL, 'F', 0, 5, 110874),
(50979, '1.4L', NULL, 3803, 0, NULL, 'F', 0, 5, 6848),
(50978, 'Stilo 1.6', NULL, 3802, 0, NULL, 'F', 0, 5, 3645),
(50977, 'Stilo 2.4', NULL, 3802, 0, NULL, 'F', 0, 5, 3644),
(50976, '2.8L 手动型', NULL, 3801, 0, NULL, 'F', 0, 5, 3250),
(50975, '1.6 手动版', NULL, 3800, 0, NULL, 'F', 0, 5, 109575),
(50974, 'Doblo 1.6', NULL, 3799, 0, NULL, 'F', 0, 5, 3643),
(50973, '1.4L 自动 Louge 尊享版', NULL, 3798, 0, NULL, 'F', 0, 5, 14328),
(50972, '1.4L 自动 Sport 运动版', NULL, 3798, 0, NULL, 'F', 0, 5, 14326),
(50971, '1.4L 自动 Pop 时尚版', NULL, 3798, 0, NULL, 'F', 0, 5, 13973),
(50970, '1.4L 自动 GUCCI版', NULL, 3797, 0, NULL, 'F', 0, 5, 100128),
(50969, 'C 1.4L 自动 Pop Cabrio 时尚敞篷版', NULL, 3797, 0, NULL, 'F', 0, 5, 16507),
(50968, 'C 1.4L 自动 Lounge Cabrio 尊享敞篷版', NULL, 3797, 0, NULL, 'F', 0, 5, 16420),
(50967, 'Multipla BIPOWER 1.6L', NULL, 3796, 0, NULL, 'F', 0, 5, 9117),
(50966, '2.8L 手动', NULL, 3795, 0, NULL, 'F', 0, 5, 3249),
(50965, '博悦Bravo', NULL, 3794, 0, NULL, 'F', 0, 5, 6873),
(50964, '1.4T 活力版', NULL, 3794, 0, NULL, 'F', 0, 5, 6028),
(50963, '1.4T 运动版', NULL, 3794, 0, NULL, 'F', 0, 5, 6027),
(50962, '1.4AMT 至尊版', NULL, 3793, 0, NULL, 'F', 0, 5, 9106),
(50961, '1.4AMT 豪华版', NULL, 3793, 0, NULL, 'F', 0, 5, 9105),
(50960, '1.4T—JET 150马力 手动 运动天窗版', NULL, 3792, 0, NULL, 'F', 0, 5, 12035),
(50959, '1.4T—JET 150马力 手动 运动版', NULL, 3792, 0, NULL, 'F', 0, 5, 12033),
(50958, '1.4T—JET 120马力 手自一体 至尊版', NULL, 3792, 0, NULL, 'F', 0, 5, 12031),
(50957, '1.4T—JET 120马力 手自一体 运动版', NULL, 3792, 0, NULL, 'F', 0, 5, 12030),
(50956, '1.4T—JET 120马力 手自一体 舒适版', NULL, 3792, 0, NULL, 'F', 0, 5, 12029),
(50955, '1.4T—JET 120马力 手自一体 时尚版', NULL, 3792, 0, NULL, 'F', 0, 5, 12028),
(50954, '1.3 手自一体 SG-ELX-16V-Speedgear', NULL, 3791, 0, NULL, 'F', 0, 5, 108654),
(50953, '1.5 手动 ELX', NULL, 3791, 0, NULL, 'F', 0, 5, 106968),
(50952, '1.5 手动 EL', NULL, 3791, 0, NULL, 'F', 0, 5, 106967),
(50951, '1.3 手自一体 SG-ELX-8V-Speedgear', NULL, 3791, 0, NULL, 'F', 0, 5, 106953),
(50950, 'EL', NULL, 3791, 0, NULL, 'F', 0, 5, 1715),
(50949, 'Speedgear', NULL, 3791, 0, NULL, 'F', 0, 5, 1714),
(50948, 'ELX', NULL, 3791, 0, NULL, 'F', 0, 5, 1713),
(50947, '1.3 手自一体 SG-HLX-16V-Speedgear', NULL, 3790, 0, NULL, 'F', 0, 5, 108655),
(50946, '1.5 手自一体 SG-HLX-16V-Speedgear', NULL, 3790, 0, NULL, 'F', 0, 5, 106966),
(50945, '1.5 手动 HLX天窗版', NULL, 3790, 0, NULL, 'F', 0, 5, 106965),
(50944, '1.5 自动 HL', NULL, 3790, 0, NULL, 'F', 0, 5, 106964),
(50943, '1.5 手动 HL', NULL, 3790, 0, NULL, 'F', 0, 5, 106963),
(50942, '1.3 手自一体 SG-HLX-8V-Speedgear', NULL, 3790, 0, NULL, 'F', 0, 5, 106952),
(50941, '1.5HL/AT', NULL, 3790, 0, NULL, 'F', 0, 5, 1716),
(50940, '1.5HLX—Speedgear', NULL, 3790, 0, NULL, 'F', 0, 5, 1712),
(50939, '1.5HLX', NULL, 3790, 0, NULL, 'F', 0, 5, 1711),
(50938, '1.5HL', NULL, 3790, 0, NULL, 'F', 0, 5, 1710),
(50937, '1.3HLX—Speedgear', NULL, 3790, 0, NULL, 'F', 0, 5, 1709),
(50936, '1.5 手动 FSX 十运吉祥版', NULL, 3789, 0, NULL, 'F', 0, 5, 106962),
(50935, '1.5 手动 FSX', NULL, 3789, 0, NULL, 'F', 0, 5, 106961),
(50934, '1.5 手动 FLX', NULL, 3789, 0, NULL, 'F', 0, 5, 106960),
(50933, '1.5 自动 FL', NULL, 3789, 0, NULL, 'F', 0, 5, 106959),
(50932, '1.5 手动 FL', NULL, 3789, 0, NULL, 'F', 0, 5, 106958),
(50931, '1.5FSX', NULL, 3789, 0, NULL, 'F', 0, 5, 1721),
(50930, '1.5FSX 十运吉祥版', NULL, 3789, 0, NULL, 'F', 0, 5, 1720),
(50929, '1.5FL', NULL, 3789, 0, NULL, 'F', 0, 5, 1719),
(50928, '1.5FLX', NULL, 3789, 0, NULL, 'F', 0, 5, 1718),
(50927, '1.5FL/AT', NULL, 3789, 0, NULL, 'F', 0, 5, 1717),
(50926, '1.5 手动 GSX靓彩版', NULL, 3788, 0, NULL, 'F', 0, 5, 106957),
(50925, '1.5 手动 GLX靓彩版', NULL, 3788, 0, NULL, 'F', 0, 5, 106956),
(50924, '1.5 自动 GL靓彩版', NULL, 3788, 0, NULL, 'F', 0, 5, 106955),
(50923, '1.5 手动 GL靓彩版', NULL, 3788, 0, NULL, 'F', 0, 5, 106954),
(50922, '1.5 GLX', NULL, 3788, 0, NULL, 'F', 0, 5, 1725),
(50921, '1.5 GL AT', NULL, 3788, 0, NULL, 'F', 0, 5, 1724),
(50920, '1.5 GL', NULL, 3788, 0, NULL, 'F', 0, 5, 1723),
(50919, '1.5 GSX', NULL, 3788, 0, NULL, 'F', 0, 5, 1722),
(50918, '1.5 手动 ELX', NULL, 3787, 0, NULL, 'F', 0, 5, 106943),
(50917, '1.5 手动 EL', NULL, 3787, 0, NULL, 'F', 0, 5, 106942),
(50916, '1.5 手动 EDX', NULL, 3787, 0, NULL, 'F', 0, 5, 106941),
(50915, '1.3 手动 EDX', NULL, 3787, 0, NULL, 'F', 0, 5, 106933),
(50914, '1.3 手自一体 SG-EL-Speedgear', NULL, 3786, 0, NULL, 'F', 0, 5, 106935),
(50913, '1.3 手自一体 SG-Speedgear', NULL, 3786, 0, NULL, 'F', 0, 5, 106934),
(50912, '1.3EDX', NULL, 3786, 0, NULL, 'F', 0, 5, 1700),
(50911, '1.3L16v Speedgear', NULL, 3786, 0, NULL, 'F', 0, 5, 1699),
(50910, '1.3L16vEL—Speedgear', NULL, 3786, 0, NULL, 'F', 0, 5, 1698),
(50909, '1.5ELX', NULL, 3786, 0, NULL, 'F', 0, 5, 1697),
(50908, '1.5EDX', NULL, 3786, 0, NULL, 'F', 0, 5, 1696),
(50907, '1.5EL', NULL, 3786, 0, NULL, 'F', 0, 5, 1695),
(50906, '1.5 手动 HLX', NULL, 3785, 0, NULL, 'F', 0, 5, 106951),
(50905, '1.5 自动 HL', NULL, 3785, 0, NULL, 'F', 0, 5, 106950),
(50904, '1.5 手动 HL', NULL, 3785, 0, NULL, 'F', 0, 5, 106949),
(50903, '1.5 手动 EX', NULL, 3785, 0, NULL, 'F', 0, 5, 106944),
(50902, '1.3L16vHL—Speedgear', NULL, 3785, 0, NULL, 'F', 0, 5, 1694),
(50901, '1.5HLX', NULL, 3785, 0, NULL, 'F', 0, 5, 1693),
(50900, '1.5HL自动版', NULL, 3785, 0, NULL, 'F', 0, 5, 1692),
(50899, '1.5HL', NULL, 3785, 0, NULL, 'F', 0, 5, 1691),
(50898, '1.5EX', NULL, 3785, 0, NULL, 'F', 0, 5, 1690),
(50897, '1.5 手动 FSX', NULL, 3784, 0, NULL, 'F', 0, 5, 106948),
(50896, '1.5 手动 FLX', NULL, 3784, 0, NULL, 'F', 0, 5, 106947),
(50895, '1.5 自动 FL', NULL, 3784, 0, NULL, 'F', 0, 5, 106946),
(50894, '1.5 手动 FL', NULL, 3784, 0, NULL, 'F', 0, 5, 106945),
(50893, '1.3 手自一体 SG-HL-Speedgear', NULL, 3784, 0, NULL, 'F', 0, 5, 106936),
(50892, '1.5FSX', NULL, 3784, 0, NULL, 'F', 0, 5, 1704),
(50891, '1.5FL', NULL, 3784, 0, NULL, 'F', 0, 5, 1703),
(50890, '1.5FLX', NULL, 3784, 0, NULL, 'F', 0, 5, 1702),
(50889, '1.5FL/AT', NULL, 3784, 0, NULL, 'F', 0, 5, 1701),
(50888, '1.5 手动 GSX靓彩版', NULL, 3783, 0, NULL, 'F', 0, 5, 106940),
(50887, '1.5 手动 GLX靓彩版 ', NULL, 3783, 0, NULL, 'F', 0, 5, 106939),
(50886, '1.5 自动 GL靓彩版 ', NULL, 3783, 0, NULL, 'F', 0, 5, 106938),
(50885, '1.5 手动 GL靓彩版', NULL, 3783, 0, NULL, 'F', 0, 5, 106937),
(50884, '1.5 GLX', NULL, 3783, 0, NULL, 'F', 0, 5, 3939),
(50883, '1.5 GL AT', NULL, 3783, 0, NULL, 'F', 0, 5, 3938),
(50881, '1.5 GSX', NULL, 3783, 0, NULL, 'F', 0, 5, 3936),
(50882, '1.5 GL', NULL, 3783, 0, NULL, 'F', 0, 5, 3937),
(50880, '1.5 GL自动靓彩版', NULL, 3783, 0, NULL, 'F', 0, 5, 1707),
(50879, '1.5 GL靓彩版', NULL, 3783, 0, NULL, 'F', 0, 5, 1706),
(50878, '1.5 手动 ELX ', NULL, 3782, 0, NULL, 'F', 0, 5, 106917),
(50877, '1.3 手动 EDX', NULL, 3782, 0, NULL, 'F', 0, 5, 106911),
(50876, '1.5 EXL手动版 ', NULL, 3782, 0, NULL, 'F', 0, 5, 6248),
(50875, '1.3 手自一体 SG Speedgear', NULL, 3781, 0, NULL, 'F', 0, 5, 106916),
(50874, '1.3 手自一体 SG-EL Speedgear', NULL, 3781, 0, NULL, 'F', 0, 5, 106915),
(50872, '1.5ELX', NULL, 3781, 0, NULL, 'F', 0, 5, 1675),
(50873, '1.5 EL手动版 ', NULL, 3781, 0, NULL, 'F', 0, 5, 6247),
(50871, '1.5EL', NULL, 3781, 0, NULL, 'F', 0, 5, 1674),
(50870, '1.3L16v Speedgear', NULL, 3781, 0, NULL, 'F', 0, 5, 1673),
(50868, '1.3EDX', NULL, 3781, 0, NULL, 'F', 0, 5, 1671),
(50869, '1.3EL Speedgear', NULL, 3781, 0, NULL, 'F', 0, 5, 1672),
(50867, '1.5 手动 HL 运动版', NULL, 3780, 0, NULL, 'F', 0, 5, 106932),
(50866, '1.5 手动 HL 天窗版', NULL, 3780, 0, NULL, 'F', 0, 5, 106931),
(50865, '1.5 自动 HL', NULL, 3780, 0, NULL, 'F', 0, 5, 106930),
(50864, '1.5 手动 HL', NULL, 3780, 0, NULL, 'F', 0, 5, 106929),
(50863, '1.5 手动 EX', NULL, 3780, 0, NULL, 'F', 0, 5, 106923),
(50862, '1.3 手自一体 SG-HL Speedgear', NULL, 3780, 0, NULL, 'F', 0, 5, 106914),
(50861, '1.3 手动 EX', NULL, 3780, 0, NULL, 'F', 0, 5, 106912),
(50860, '1.5 EL ', NULL, 3780, 0, NULL, 'F', 0, 5, 6246),
(50859, '运动版', NULL, 3780, 0, NULL, 'F', 0, 5, 1677),
(50858, '1.5EX', NULL, 3780, 0, NULL, 'F', 0, 5, 1676),
(50857, '1.3HL Speedgear', NULL, 3780, 0, NULL, 'F', 0, 5, 1670),
(50856, '1.3EX', NULL, 3780, 0, NULL, 'F', 0, 5, 1669),
(50855, '1.5HL', NULL, 3780, 0, NULL, 'F', 0, 5, 1668),
(50854, '1.5HLSUNROOF天窗版', NULL, 3780, 0, NULL, 'F', 0, 5, 1667),
(50853, '1.5HL自动版', NULL, 3780, 0, NULL, 'F', 0, 5, 1666),
(50852, '1.5 手动 FX(CD)', NULL, 3779, 0, NULL, 'F', 0, 5, 106928),
(50851, '1.5 手动 FX', NULL, 3779, 0, NULL, 'F', 0, 5, 106927),
(50850, '1.5 自动 FSX', NULL, 3779, 0, NULL, 'F', 0, 5, 106926),
(50849, '1.5 手动 FSX', NULL, 3779, 0, NULL, 'F', 0, 5, 106925),
(50848, '1.5 手动 FL', NULL, 3779, 0, NULL, 'F', 0, 5, 106924),
(50847, '1.3 手动 FX', NULL, 3779, 0, NULL, 'F', 0, 5, 106913),
(50846, '1.3FX', NULL, 3779, 0, NULL, 'F', 0, 5, 1683),
(50845, '1.5FX', NULL, 3779, 0, NULL, 'F', 0, 5, 1682),
(50844, '1.5FX(CD)', NULL, 3779, 0, NULL, 'F', 0, 5, 1681),
(50843, '1.5FSX', NULL, 3779, 0, NULL, 'F', 0, 5, 1680),
(50842, '1.5FL', NULL, 3779, 0, NULL, 'F', 0, 5, 1679),
(50841, '1.5FSX AT', NULL, 3779, 0, NULL, 'F', 0, 5, 1678),
(50840, '1.5 手动 GX（CD）靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106922),
(50839, '1.5 手动 GX 靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106921),
(50838, '1.5 自动 GSX 靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106920),
(50837, '1.5 手动 GSX 靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106919),
(50836, '1.5 手动 GL 靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106918),
(50835, '1.3 手动 GX 靓彩版', NULL, 3778, 0, NULL, 'F', 0, 5, 106910),
(50834, '1.3 GX（CD）', NULL, 3778, 0, NULL, 'F', 0, 5, 1689),
(50833, '1.5 GL', NULL, 3778, 0, NULL, 'F', 0, 5, 1688),
(50832, '1.5 GSX AT', NULL, 3778, 0, NULL, 'F', 0, 5, 1687),
(50831, '1.5 GSX', NULL, 3778, 0, NULL, 'F', 0, 5, 1686),
(50830, '1.5 GX', NULL, 3778, 0, NULL, 'F', 0, 5, 1685),
(50829, '1.5 GX（CD）', NULL, 3778, 0, NULL, 'F', 0, 5, 1684),
(50828, '1.5 手动 GX（CD）厚爱版', NULL, 3777, 0, NULL, 'F', 0, 5, 108653),
(50827, '1.5 手动 GSX 厚恩版', NULL, 3777, 0, NULL, 'F', 0, 5, 108652),
(50826, '1.5 手动 GL 厚道版', NULL, 3777, 0, NULL, 'F', 0, 5, 108651),
(50825, '1.7手动领航版', NULL, 3776, 0, NULL, 'F', 0, 5, 1727),
(50824, '1.7手动加速版', NULL, 3776, 0, NULL, 'F', 0, 5, 1726),
(50823, '1.4T 双离合 运动版', NULL, 3775, 0, NULL, 'F', 0, 5, 110878),
(50822, '1.4T 双离合 豪华运动版', NULL, 3775, 0, NULL, 'F', 0, 5, 110875),
(50821, '1.4T 双离合 豪华版', NULL, 3775, 0, NULL, 'F', 0, 5, 106666),
(50820, '1.4T 手动 舒适版', NULL, 3775, 0, NULL, 'F', 0, 5, 106665),
(50819, '1.4T 双离合 舒适版', NULL, 3775, 0, NULL, 'F', 0, 5, 106664),
(50818, '1.4T 手动 时尚版', NULL, 3775, 0, NULL, 'F', 0, 5, 106663),
(50817, '1.4T 双离合 时尚版', NULL, 3775, 0, NULL, 'F', 0, 5, 106660),
(50816, '1.4T 双离合 畅享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101778),
(50815, '1.4T 双离合 悦享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101777),
(50814, '1.4T 双离合 尊享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101730),
(50813, '1.4T 手动 悦享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101729),
(50812, '1.4T 手动 畅享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101728),
(50811, '1.4T 双离合 劲享版', NULL, 3774, 0, NULL, 'F', 0, 5, 101522),
(50810, '1.4T 双离合 周年纪念版', NULL, 3773, 0, NULL, 'F', 0, 5, 105128),
(50809, '1.4T 120THP 手动 劲享版', NULL, 3772, 0, NULL, 'F', 0, 5, 106211),
(50808, '5.4L XLT 四驱 自动', NULL, 3771, 0, NULL, 'F', 0, 5, 102907),
(50807, '3.0 自动 maverick基本型', NULL, 3770, 0, NULL, 'F', 0, 5, 109574),
(50806, '基本款', NULL, 3769, 0, NULL, 'F', 0, 5, 3690),
(50805, '都市探险版', NULL, 3768, 0, NULL, 'F', 0, 5, 3693),
(50804, '3.0L 美规版 顶配 四驱', NULL, 3767, 0, NULL, 'F', 0, 5, 15503),
(50803, '2.3L 2WD XLT', NULL, 3767, 0, NULL, 'F', 0, 5, 12449),
(50802, '2.3L 2WD XLS', NULL, 3767, 0, NULL, 'F', 0, 5, 12445),
(50801, '2.3L 4WD', NULL, 3767, 0, NULL, 'F', 0, 5, 11504),
(50800, '4.6 自动 敞篷版', NULL, 3766, 0, NULL, 'F', 0, 5, 109724),
(50799, '4.6 手动 敞篷版', NULL, 3766, 0, NULL, 'F', 0, 5, 109723),
(50798, '4.0 手动 敞篷版', NULL, 3766, 0, NULL, 'F', 0, 5, 109722),
(50797, 'V6 敞篷顶级版', NULL, 3765, 0, NULL, 'F', 0, 5, 9996),
(50796, '4.6 自动版', NULL, 3764, 0, NULL, 'F', 0, 5, 109573),
(50795, '4.0 自动 敞篷版', NULL, 3764, 0, NULL, 'F', 0, 5, 109572),
(50794, 'GT', NULL, 3763, 0, NULL, 'F', 0, 5, 6744),
(50793, 'V8 5.0L GT手动  Boss302', NULL, 3762, 0, NULL, 'F', 0, 5, 101681),
(50792, '3.7L V6 202A', NULL, 3762, 0, NULL, 'F', 0, 5, 15762),
(50791, 'Shelby V8 5.4L 手动 普通版', NULL, 3762, 0, NULL, 'F', 0, 5, 15440),
(50790, 'Shelby V8 5.4L 手动 豪华版 SVT改装', NULL, 3762, 0, NULL, 'F', 0, 5, 15439),
(50789, 'V6 3.7L 手动  豪华版 高配', NULL, 3762, 0, NULL, 'F', 0, 5, 15433),
(50788, 'V6 3.7L 手动  豪华版 顶配', NULL, 3762, 0, NULL, 'F', 0, 5, 15432),
(50787, 'V6 3.7L 手动  豪华版 标配', NULL, 3762, 0, NULL, 'F', 0, 5, 15431),
(50786, 'V6 3.7L 手动  普通版', NULL, 3762, 0, NULL, 'F', 0, 5, 15430),
(50785, 'V6 3.7L 自动  豪华版 标配', NULL, 3762, 0, NULL, 'F', 0, 5, 15429),
(50784, 'V6 3.7L 自动  豪华版 顶配', NULL, 3762, 0, NULL, 'F', 0, 5, 15428),
(50783, 'V6 3.7L 自动  豪华版 高配', NULL, 3762, 0, NULL, 'F', 0, 5, 15420),
(50782, 'V6 3.7L 自动  普通版', NULL, 3762, 0, NULL, 'F', 0, 5, 15419),
(50781, 'V8 5.0L GT自动  普通版', NULL, 3762, 0, NULL, 'F', 0, 5, 15418),
(50780, 'V8 5.0L GT自动  豪华版 标配', NULL, 3762, 0, NULL, 'F', 0, 5, 15417),
(50779, 'V8 5.0L GT自动  豪华版 顶配', NULL, 3762, 0, NULL, 'F', 0, 5, 15416),
(50778, 'V8 5.0L GT自动  豪华版 高配', NULL, 3762, 0, NULL, 'F', 0, 5, 15415),
(50777, 'V8 5.0L GT手动  豪华版 高配', NULL, 3762, 0, NULL, 'F', 0, 5, 15414),
(50776, 'V8 5.0L GT手动  豪华版 顶配', NULL, 3762, 0, NULL, 'F', 0, 5, 15412),
(50775, 'V8 5.0L GT手动  豪华版 标配', NULL, 3762, 0, NULL, 'F', 0, 5, 15409),
(50774, 'V8 5.0L GT手动  普通版', NULL, 3762, 0, NULL, 'F', 0, 5, 15406),
(50773, '3.7L 自动 俱乐部版 敞篷', NULL, 3762, 0, NULL, 'F', 0, 5, 15154),
(50772, '3.7L 自动 俱乐部版 硬顶', NULL, 3762, 0, NULL, 'F', 0, 5, 15153),
(50771, '3.7L 手动 俱乐部版 硬顶', NULL, 3762, 0, NULL, 'F', 0, 5, 15147),
(50770, '3.7L 手动 俱乐部版 敞篷', NULL, 3762, 0, NULL, 'F', 0, 5, 15146),
(50769, '5.4L 手动 SHELBY GT500 硬顶', NULL, 3762, 0, NULL, 'F', 0, 5, 14891),
(50768, '5.0L 手动 GT 硬顶', NULL, 3762, 0, NULL, 'F', 0, 5, 14890),
(50767, '3.7L 手动 硬顶', NULL, 3762, 0, NULL, 'F', 0, 5, 14889),
(50766, '5.4L 手动 SHELBY GT500 软顶敞篷', NULL, 3762, 0, NULL, 'F', 0, 5, 14888),
(50765, '5.0L 自动 GT 软顶敞篷', NULL, 3762, 0, NULL, 'F', 0, 5, 14886),
(50764, '3.7L 自动 软顶敞篷', NULL, 3762, 0, NULL, 'F', 0, 5, 14885),
(50763, '3.7L 手动 V6', NULL, 3761, 0, NULL, 'F', 0, 5, 103319),
(50762, '3.7L 自动 V6', NULL, 3761, 0, NULL, 'F', 0, 5, 103318),
(50761, '5.0L 手动 GT', NULL, 3761, 0, NULL, 'F', 0, 5, 103317),
(50760, '5.0L 自动 GT', NULL, 3761, 0, NULL, 'F', 0, 5, 103313),
(50759, '5.0L 手动 BOSS302', NULL, 3761, 0, NULL, 'F', 0, 5, 103312),
(50758, '5.8T 手动 GT500', NULL, 3761, 0, NULL, 'F', 0, 5, 103310),
(50757, '3.8L 7座自动旅行版', NULL, 3760, 0, NULL, 'F', 0, 5, 10275),
(50756, '水星 3.0L', NULL, 3759, 0, NULL, 'F', 0, 5, 9238),
(50755, '3.5 Edge SEL AWD', NULL, 3758, 0, NULL, 'F', 0, 5, 7215),
(50754, '3.5L 精锐型天窗版', NULL, 3757, 0, NULL, 'F', 0, 5, 12649),
(50753, '3.5L 精锐型', NULL, 3757, 0, NULL, 'F', 0, 5, 12598),
(50752, '3.5L 尊锐型', NULL, 3757, 0, NULL, 'F', 0, 5, 9961),
(50751, '2.0T 自动 尊锐型', NULL, 3756, 0, NULL, 'F', 0, 5, 101331),
(50750, '2.0T 自动 精锐型天窗版', NULL, 3756, 0, NULL, 'F', 0, 5, 101330),
(50749, '2.0T 自动 精锐型', NULL, 3756, 0, NULL, 'F', 0, 5, 101327),
(50748, '3.5L 手自一体 尊锐型', NULL, 3756, 0, NULL, 'F', 0, 5, 100061),
(50747, '3.5L 手自一体 精锐型天窗版', NULL, 3756, 0, NULL, 'F', 0, 5, 100060),
(50746, '3.5L 手自一体 精锐型', NULL, 3756, 0, NULL, 'F', 0, 5, 100059),
(50745, '2.0自动', NULL, 3755, 0, NULL, 'F', 0, 5, 10274),
(50744, 'Ghia-X 2.0自动', NULL, 3755, 0, NULL, 'F', 0, 5, 10273),
(50743, 'V6 3.0 AT', NULL, 3754, 0, NULL, 'F', 0, 5, 8127),
(50742, 'ST 1.6T 手动', NULL, 3753, 0, NULL, 'F', 0, 5, 104134),
(50741, '外交官 V8 5.4', NULL, 3752, 0, NULL, 'F', 0, 5, 11005),
(50740, '外交官 V8 5.4L', NULL, 3751, 0, NULL, 'F', 0, 5, 3267),
(50739, '2.0L ', NULL, 3750, 0, NULL, 'F', 0, 5, 6829),
(50738, '探险者', NULL, 3749, 0, NULL, 'F', 0, 5, 6743),
(50737, '4.6 自动版', NULL, 3748, 0, NULL, 'F', 0, 5, 109720),
(50736, '4.0 AT V6四驱版', NULL, 3748, 0, NULL, 'F', 0, 5, 109719),
(50735, '4.0 AT V6后驱版', NULL, 3748, 0, NULL, 'F', 0, 5, 109718),
(50734, '3.5 自动版', NULL, 3747, 0, NULL, 'F', 0, 5, 109721),
(50733, '3.5L 自动 尊尚型', NULL, 3746, 0, NULL, 'F', 0, 5, 103540),
(50732, '3.5L 自动 尊享型', NULL, 3746, 0, NULL, 'F', 0, 5, 103265),
(50731, 'E150 ConversionVan 4.6AT豪华型', NULL, 3745, 0, NULL, 'F', 0, 5, 6679),
(50730, 'E250 5.4L 商务 7座', NULL, 3744, 0, NULL, 'F', 0, 5, 111311),
(50729, '七座领袖游艇级', NULL, 3743, 0, NULL, 'F', 0, 5, 8629),
(50728, 'E450 豪华车', NULL, 3742, 0, NULL, 'F', 0, 5, 15501),
(50727, 'E450—沃伦贝格 远望 30c', NULL, 3742, 0, NULL, 'F', 0, 5, 12414),
(50726, 'E150', NULL, 3741, 0, NULL, 'F', 0, 5, 111039),
(50725, 'E350—皇御私驾', NULL, 3741, 0, NULL, 'F', 0, 5, 111038),
(50724, 'E350—标准版', NULL, 3741, 0, NULL, 'F', 0, 5, 111037),
(50723, 'E450—沃伦贝格 远望 30c', NULL, 3741, 0, NULL, 'F', 0, 5, 102426),
(50722, 'ST 2.0T 手动 橙色版', NULL, 3740, 0, NULL, 'F', 0, 5, 103309),
(50721, 'ST 2.0T 手动 标准版', NULL, 3740, 0, NULL, 'F', 0, 5, 103041),
(50720, 'F-150 猛禽 5.4L', NULL, 3739, 0, NULL, 'F', 0, 5, 100064),
(50719, 'F—150 猛禽 6.2L', NULL, 3738, 0, NULL, 'F', 0, 5, 12473),
(50718, 'F—550', NULL, 3738, 0, NULL, 'F', 0, 5, 12159),
(50717, 'F—150', NULL, 3738, 0, NULL, 'F', 0, 5, 12158),
(50716, 'F-150 福特哈雷戴维森版 6.2L', NULL, 3737, 0, NULL, 'F', 0, 5, 15267),
(50715, 'F-550', NULL, 3737, 0, NULL, 'F', 0, 5, 13587),
(50714, 'F450 6.7L', NULL, 3737, 0, NULL, 'F', 0, 5, 13095),
(50713, 'F-150 猛禽 6.2L', NULL, 3737, 0, NULL, 'F', 0, 5, 13094),
(50712, 'F-150 猛禽 5.4L', NULL, 3737, 0, NULL, 'F', 0, 5, 13093),
(50711, 'F650 V8 6.7L 改装超级皮卡', NULL, 3736, 0, NULL, 'F', 0, 5, 15517),
(50710, 'F-150 猛禽 6.2L', NULL, 3736, 0, NULL, 'F', 0, 5, 15500),
(50709, 'F-150 猛禽 5.4L', NULL, 3736, 0, NULL, 'F', 0, 5, 15499),
(50708, 'F-150 猛禽 6.2L', NULL, 3735, 0, NULL, 'F', 0, 5, 102425),
(50707, '3.5 自动 EcoBoost', NULL, 3734, 0, NULL, 'F', 0, 5, 109717),
(50706, '3.5 自动 Duratec', NULL, 3734, 0, NULL, 'F', 0, 5, 109716),
(50705, '福莱克斯 FLEX', NULL, 3733, 0, NULL, 'F', 0, 5, 7162),
(50704, '2.3L至尊型', NULL, 3732, 0, NULL, 'F', 0, 5, 7176),
(50703, '2.3L时尚型', NULL, 3732, 0, NULL, 'F', 0, 5, 285),
(50702, '2.3L豪华运动型', NULL, 3732, 0, NULL, 'F', 0, 5, 284),
(50701, '2.3L豪华型', NULL, 3732, 0, NULL, 'F', 0, 5, 283),
(50700, '2.3L豪华运动型导航版', NULL, 3731, 0, NULL, 'F', 0, 5, 7175),
(50699, '2.3L 时尚型', NULL, 3730, 0, NULL, 'F', 0, 5, 9739),
(50698, '2.3L 豪华型', NULL, 3730, 0, NULL, 'F', 0, 5, 9738),
(50697, '2.3L 豪华运动型', NULL, 3730, 0, NULL, 'F', 0, 5, 9737),
(50696, '2.3L 豪华运动型导航版', NULL, 3730, 0, NULL, 'F', 0, 5, 9736),
(50695, '2.3L 至尊型', NULL, 3730, 0, NULL, 'F', 0, 5, 9735),
(50694, '2.3L 自动 时尚型 国4', NULL, 3729, 0, NULL, 'F', 0, 5, 105746),
(50693, '2.3L 自动 豪华型 国4', NULL, 3729, 0, NULL, 'F', 0, 5, 105745),
(50692, '2.3L 自动 豪华型 国', NULL, 3729, 0, NULL, 'F', 0, 5, 12169),
(50691, '2.3L 自动 时尚型 国', NULL, 3729, 0, NULL, 'F', 0, 5, 12168),
(50690, '2.3L 自动 豪华型 国4', NULL, 3728, 0, NULL, 'F', 0, 5, 106240),
(50689, '2.3L 自动 时尚型 国4', NULL, 3728, 0, NULL, 'F', 0, 5, 106239),
(50688, '1.6 GTDi 自动 两驱 舒适型', NULL, 3727, 0, NULL, 'F', 0, 5, 102586),
(50687, '1.6 GTDi 自动 两驱 风尚型', NULL, 3727, 0, NULL, 'F', 0, 5, 102585),
(50686, '1.6 GTDi 自动 四驱 精英型', NULL, 3727, 0, NULL, 'F', 0, 5, 102584),
(50685, '2.0 GTDi 自动 四驱 精英型', NULL, 3727, 0, NULL, 'F', 0, 5, 102583),
(50684, '2.0 GTDi 自动 四驱 运动型', NULL, 3727, 0, NULL, 'F', 0, 5, 102582),
(50683, '2.0 GTDi 自动 四驱 尊贵型', NULL, 3727, 0, NULL, 'F', 0, 5, 102580),
(50682, '1.5L 手动 舒适型', NULL, 3726, 0, NULL, 'F', 0, 5, 102672),
(50681, '1.5L 手动 风尚型', NULL, 3726, 0, NULL, 'F', 0, 5, 102671),
(50680, '1.5L 自动 风尚型', NULL, 3726, 0, NULL, 'F', 0, 5, 102670),
(50679, '1.5L 手动 尊贵型', NULL, 3726, 0, NULL, 'F', 0, 5, 102669),
(50678, '1.0L GTDi 手动 尊贵型', NULL, 3726, 0, NULL, 'F', 0, 5, 102668),
(50677, '1.5L 自动 尊贵型', NULL, 3726, 0, NULL, 'F', 0, 5, 102666),
(50676, 'Ghia-X 2.0 自动尊享型', NULL, 3725, 0, NULL, 'F', 0, 5, 109143),
(50675, 'Ghia-Ltd 2.5 手自一体旗舰型', NULL, 3724, 0, NULL, 'F', 0, 5, 108128),
(50674, 'GLX 2.0 自动经典型', NULL, 3724, 0, NULL, 'F', 0, 5, 108115),
(50673, '2.5LV6旗舰型', NULL, 3724, 0, NULL, 'F', 0, 5, 268),
(50672, 'Ghia—x 尊贵型', NULL, 3724, 0, NULL, 'F', 0, 5, 267),
(50671, 'GLX经典型', NULL, 3724, 0, NULL, 'F', 0, 5, 266),
(50670, 'Ghia-X 2.0 自动尊享型', NULL, 3723, 0, NULL, 'F', 0, 5, 109144),
(50669, 'Ghia-X 2.0 自动精英型', NULL, 3723, 0, NULL, 'F', 0, 5, 108129),
(50668, 'Ghia-Ltd 2.5 手自一体旗舰型', NULL, 3723, 0, NULL, 'F', 0, 5, 108114),
(50667, 'Ghia-Ltd 2.0 自动尊贵型精装版', NULL, 3723, 0, NULL, 'F', 0, 5, 108113),
(50666, '2.0L自动挡精英版', NULL, 3723, 0, NULL, 'F', 0, 5, 272),
(50665, '经典型手动版 GLX 2.0 MT', NULL, 3723, 0, NULL, 'F', 0, 5, 271),
(50664, '尊贵型精装版 Ghia—X 2.0 AT', NULL, 3723, 0, NULL, 'F', 0, 5, 270);
INSERT INTO `simcms_brand` (`b_id`, `b_name`, `b_keyword`, `b_parent`, `b_type`, `pic`, `mark`, `orderid`, `classid`, `carid`) VALUES
(50663, '旗舰型浅内饰版 Ghia—Limited 2.5 V6', NULL, 3723, 0, NULL, 'F', 0, 5, 269),
(50662, 'GLX 2.0 自动经典型', NULL, 3722, 0, NULL, 'F', 0, 5, 108116),
(50661, '2.5L V6 Ghia-Ltd旗舰型', NULL, 3722, 0, NULL, 'F', 0, 5, 282),
(50660, '2.0L Ghia—Ltd尊贵型', NULL, 3722, 0, NULL, 'F', 0, 5, 281),
(50659, '2.0L Ghia精英型', NULL, 3722, 0, NULL, 'F', 0, 5, 280),
(50658, '2.0L GLX经典型手动版', NULL, 3722, 0, NULL, 'F', 0, 5, 279),
(50657, '2.5V6 旗舰型', NULL, 3722, 0, NULL, 'F', 0, 5, 278),
(50656, '2.5V6 精英型', NULL, 3722, 0, NULL, 'F', 0, 5, 277),
(50655, '2.5V6 经典型', NULL, 3722, 0, NULL, 'F', 0, 5, 276),
(50654, '2.0 自动尊贵型', NULL, 3722, 0, NULL, 'F', 0, 5, 275),
(50653, '2.0 自动精英型', NULL, 3722, 0, NULL, 'F', 0, 5, 274),
(50652, '2.0 手动经典型', NULL, 3722, 0, NULL, 'F', 0, 5, 273),
(50651, '2.0T 自动 GTDi240 旗舰型', NULL, 3721, 0, NULL, 'F', 0, 5, 104310),
(50650, '1.5T 自动 GTDi180 舒适型', NULL, 3721, 0, NULL, 'F', 0, 5, 103956),
(50649, '1.5T 自动 GTDi180 时尚型', NULL, 3721, 0, NULL, 'F', 0, 5, 103955),
(50648, '2.0T 自动 GTDi200 时尚型', NULL, 3721, 0, NULL, 'F', 0, 5, 103952),
(50647, '2.0T 自动 GTDi200 豪华型', NULL, 3721, 0, NULL, 'F', 0, 5, 103951),
(50646, '2.0T 自动 GTDi240 豪华运动型', NULL, 3721, 0, NULL, 'F', 0, 5, 103949),
(50645, '2.0T 自动 GTDi240 至尊型', NULL, 3721, 0, NULL, 'F', 0, 5, 103573),
(50644, '2.3L 手自一体时尚型', NULL, 3720, 0, NULL, 'F', 0, 5, 108120),
(50643, '2.3L 手自一体豪华运动型', NULL, 3720, 0, NULL, 'F', 0, 5, 108118),
(50642, '2.3L 手自一体豪华型', NULL, 3720, 0, NULL, 'F', 0, 5, 108117),
(50641, '2.0L舒适型', NULL, 3720, 0, NULL, 'F', 0, 5, 325),
(50640, '2.3L 手自一体至尊型', NULL, 3719, 0, NULL, 'F', 0, 5, 108121),
(50639, '2.3L 手自一体豪华运动型导航版', NULL, 3719, 0, NULL, 'F', 0, 5, 108119),
(50638, '2.3L 手自一体至尊型', NULL, 3718, 0, NULL, 'F', 0, 5, 108134),
(50637, '2.3L 手自一体时尚型', NULL, 3718, 0, NULL, 'F', 0, 5, 108133),
(50636, '2.3L 手自一体豪华运动型导航版', NULL, 3718, 0, NULL, 'F', 0, 5, 108132),
(50635, '2.3L 手自一体豪华运动型', NULL, 3718, 0, NULL, 'F', 0, 5, 108131),
(50634, '2.3L 手自一体豪华型', NULL, 3718, 0, NULL, 'F', 0, 5, 108130),
(50633, '2.0L 舒适型', NULL, 3718, 0, NULL, 'F', 0, 5, 9740),
(50632, '2.3L 手自一体豪华型', NULL, 3717, 0, NULL, 'F', 0, 5, 108136),
(50631, '2.3L 手自一体时尚型', NULL, 3717, 0, NULL, 'F', 0, 5, 108135),
(50630, '2.0L GTDi200 豪华型 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 13162),
(50629, '2.0L GTDi200 时尚型 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 13161),
(50628, '2.0L GTDi240 至尊型 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 12172),
(50627, '2.0L GTDi240 豪华运动型导航版 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 12171),
(50626, '2.0L GTDi240 豪华运动型 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 12170),
(50625, '2.0L 手动 舒适型 国4', NULL, 3717, 0, NULL, 'F', 0, 5, 12167),
(50624, '2.0L 自动 旗舰运动型 国4', NULL, 3716, 0, NULL, 'F', 0, 5, 100276),
(50623, '2.3L时尚型五座', NULL, 3715, 0, NULL, 'F', 0, 5, 5509),
(50622, '2.3L旗舰型七座', NULL, 3715, 0, NULL, 'F', 0, 5, 4664),
(50621, '2.3L豪华型七座', NULL, 3715, 0, NULL, 'F', 0, 5, 324),
(50619, '2.3L时尚型五座', NULL, 3714, 0, NULL, 'F', 0, 5, 7543),
(50620, '2.3L时尚型七座', NULL, 3715, 0, NULL, 'F', 0, 5, 323),
(50618, '2.3L时尚型七座', NULL, 3714, 0, NULL, 'F', 0, 5, 7542),
(50616, '2.3L旗舰型七座', NULL, 3714, 0, NULL, 'F', 0, 5, 7540),
(50617, '2.3L豪华型七座', NULL, 3714, 0, NULL, 'F', 0, 5, 7541),
(50615, '2.3L旗舰型导航版七座', NULL, 3714, 0, NULL, 'F', 0, 5, 7539),
(50614, '2.3L  旗舰型导航版七座', NULL, 3714, 0, NULL, 'F', 0, 5, 7177),
(50613, '2.3L旗舰型天窗版七座', NULL, 3713, 0, NULL, 'F', 0, 5, 109147),
(50612, '2.3L旗舰型导航天窗版七座', NULL, 3713, 0, NULL, 'F', 0, 5, 109146),
(50611, '2.3L豪华型天窗版七座', NULL, 3713, 0, NULL, 'F', 0, 5, 109145),
(50609, '1.3L手动舒适型', NULL, 3712, 0, NULL, 'F', 0, 5, 294),
(50610, '1.3L手动基本型', NULL, 3712, 0, NULL, 'F', 0, 5, 295),
(50608, '1.6L自动豪华型', NULL, 3712, 0, NULL, 'F', 0, 5, 290),
(50607, '1.6L手动豪华型', NULL, 3712, 0, NULL, 'F', 0, 5, 289),
(50606, '1.6L手动舒适型', NULL, 3712, 0, NULL, 'F', 0, 5, 287),
(50605, '1.6升 自动豪华型', NULL, 3711, 0, NULL, 'F', 0, 5, 299),
(50603, '1.6升 手动运动型', NULL, 3711, 0, NULL, 'F', 0, 5, 297),
(50604, '1.6升 自动运动型', NULL, 3711, 0, NULL, 'F', 0, 5, 298),
(50602, '1.6升 手动舒适型', NULL, 3711, 0, NULL, 'F', 0, 5, 296),
(50600, '1.6L手动基本型', NULL, 3711, 0, NULL, 'F', 0, 5, 286),
(50601, '1.6L自动舒适型', NULL, 3711, 0, NULL, 'F', 0, 5, 288),
(50599, '手动档舒适型 1.6 Mid MT', NULL, 3710, 0, NULL, 'F', 0, 5, 293),
(50598, '自动档豪华型 1.6 High AT', NULL, 3710, 0, NULL, 'F', 0, 5, 292),
(50597, '手动档运动款 1.6 Sport MT', NULL, 3710, 0, NULL, 'F', 0, 5, 291),
(50596, '1.6L自动运动型', NULL, 3709, 0, NULL, 'F', 0, 5, 109142),
(50595, '1.6L自动豪华型', NULL, 3709, 0, NULL, 'F', 0, 5, 108127),
(50594, '1.6L手动运动型', NULL, 3709, 0, NULL, 'F', 0, 5, 108126),
(50593, '1.6L手动舒适型', NULL, 3709, 0, NULL, 'F', 0, 5, 108125),
(50592, '1.5L自动豪华型', NULL, 3708, 0, NULL, 'F', 0, 5, 7478),
(50591, '1.5L手动运动型', NULL, 3708, 0, NULL, 'F', 0, 5, 7477),
(50589, '1.5L手动时尚型', NULL, 3708, 0, NULL, 'F', 0, 5, 7475),
(50590, '1.5L自动时尚型', NULL, 3708, 0, NULL, 'F', 0, 5, 7476),
(50588, '1.5L自动光芒限定版', NULL, 3707, 0, NULL, 'F', 0, 5, 11962),
(50587, '1.5L手动光芒限定版', NULL, 3707, 0, NULL, 'F', 0, 5, 11961),
(50586, '1.3L手动风尚型', NULL, 3707, 0, NULL, 'F', 0, 5, 10675),
(50585, '1.5L 自动豪华型', NULL, 3706, 0, NULL, 'F', 0, 5, 13698),
(50584, '1.5L 自动时尚型', NULL, 3706, 0, NULL, 'F', 0, 5, 13697),
(50583, '1.5L 手动时尚型', NULL, 3706, 0, NULL, 'F', 0, 5, 13696),
(50582, '1.3L 手动风尚型', NULL, 3706, 0, NULL, 'F', 0, 5, 13695),
(50581, '1.5L 手动 风尚型', NULL, 3705, 0, NULL, 'F', 0, 5, 103281),
(50580, '1.5L 手动 时尚型', NULL, 3705, 0, NULL, 'F', 0, 5, 103279),
(50579, '1.5L 自动 时尚型', NULL, 3705, 0, NULL, 'F', 0, 5, 103278),
(50578, '1.5L 自动 品尚型', NULL, 3705, 0, NULL, 'F', 0, 5, 103276),
(50577, '1.5L 自动 旗舰型', NULL, 3705, 0, NULL, 'F', 0, 5, 103268),
(50576, '1.3L手动经典型', NULL, 3704, 0, NULL, 'F', 0, 5, 8032),
(50575, '1.5L自动运动型', NULL, 3704, 0, NULL, 'F', 0, 5, 7471),
(50574, '1.5L手动运动型', NULL, 3704, 0, NULL, 'F', 0, 5, 7470),
(50573, '1.5L自动时尚型', NULL, 3704, 0, NULL, 'F', 0, 5, 7469),
(50572, '1.5L手动时尚型', NULL, 3704, 0, NULL, 'F', 0, 5, 7468),
(50571, '1.3L自动时尚型', NULL, 3704, 0, NULL, 'F', 0, 5, 7467),
(50570, '1.3L手动时尚型', NULL, 3704, 0, NULL, 'F', 0, 5, 7466),
(50569, '1.5L自动光芒限定版', NULL, 3703, 0, NULL, 'F', 0, 5, 11960),
(50568, '1.5L手动光芒限定版', NULL, 3703, 0, NULL, 'F', 0, 5, 11959),
(50567, '1.3L手动风尚型', NULL, 3703, 0, NULL, 'F', 0, 5, 10676),
(50566, '1.5L自动时尚型限量版', NULL, 3703, 0, NULL, 'F', 0, 5, 9811),
(50565, '1.5L手动时尚型限量版', NULL, 3703, 0, NULL, 'F', 0, 5, 9810),
(50564, '1.5L 手动时尚型', NULL, 3702, 0, NULL, 'F', 0, 5, 13736),
(50563, '1.5L 自动劲动型', NULL, 3702, 0, NULL, 'F', 0, 5, 13704),
(50562, '1.5L 自动运动型', NULL, 3702, 0, NULL, 'F', 0, 5, 13703),
(50561, '1.5L 手动运动型', NULL, 3702, 0, NULL, 'F', 0, 5, 13702),
(50560, '1.5L 自动时尚型', NULL, 3702, 0, NULL, 'F', 0, 5, 13700),
(50559, '1.3L 手动风尚型', NULL, 3702, 0, NULL, 'F', 0, 5, 13699),
(50558, '1.5L 自动 动感限量版', NULL, 3701, 0, NULL, 'F', 0, 5, 16251),
(50557, '1.5L 手动 动感限量版', NULL, 3701, 0, NULL, 'F', 0, 5, 16249),
(50556, '1.5L 自动 劲动型', NULL, 3700, 0, NULL, 'F', 0, 5, 103274),
(50555, '1.5L 自动 运动型', NULL, 3700, 0, NULL, 'F', 0, 5, 103272),
(50554, '1.5L 自动 品尚型', NULL, 3700, 0, NULL, 'F', 0, 5, 103271),
(50553, '1.5L 自动 时尚型', NULL, 3700, 0, NULL, 'F', 0, 5, 103270),
(50552, '1.5L 手动 时尚型', NULL, 3700, 0, NULL, 'F', 0, 5, 103267),
(50551, '1.5L 手动 风尚型', NULL, 3700, 0, NULL, 'F', 0, 5, 103266),
(50550, '1.0T GTDi 自动 劲动型', NULL, 3699, 0, NULL, 'F', 0, 5, 106230),
(50549, '1.8手自一体时尚型', NULL, 3698, 0, NULL, 'F', 0, 5, 108123),
(50548, '2.0 手动 运动版', NULL, 3698, 0, NULL, 'F', 0, 5, 302),
(50547, '2.0 手自一体 豪华型', NULL, 3698, 0, NULL, 'F', 0, 5, 301),
(50546, '1.8 手动 经典型', NULL, 3698, 0, NULL, 'F', 0, 5, 300),
(50545, '1.8AT时尚型精英型', NULL, 3697, 0, NULL, 'F', 0, 5, 5510),
(50544, '2.0AT豪华型', NULL, 3697, 0, NULL, 'F', 0, 5, 313),
(50543, '1.8AT时尚型', NULL, 3697, 0, NULL, 'F', 0, 5, 312),
(50542, '1.8MT舒适型', NULL, 3697, 0, NULL, 'F', 0, 5, 311),
(50541, '1.8 手自一体 时尚型', NULL, 3697, 0, NULL, 'F', 0, 5, 303),
(50540, '1.8手自一体时尚型', NULL, 3696, 0, NULL, 'F', 0, 5, 108124),
(50539, '2.0手自一体豪华型', NULL, 3696, 0, NULL, 'F', 0, 5, 108112),
(50538, '1.8MT 舒适型', NULL, 3696, 0, NULL, 'F', 0, 5, 11505),
(50537, '1.8AT 豪华型', NULL, 3695, 0, NULL, 'F', 0, 5, 7355),
(50536, '2.0AT 豪华型', NULL, 3695, 0, NULL, 'F', 0, 5, 7015),
(50535, '1.8AT 时尚型', NULL, 3695, 0, NULL, 'F', 0, 5, 7014),
(50533, '2.0自动豪华型', NULL, 3694, 0, NULL, 'F', 0, 5, 11329),
(50534, '1.8MT 舒适型', NULL, 3695, 0, NULL, 'F', 0, 5, 7013),
(50532, '1.8自动豪华型', NULL, 3694, 0, NULL, 'F', 0, 5, 11328),
(50531, '1.8自动时尚型', NULL, 3694, 0, NULL, 'F', 0, 5, 11327),
(50530, '1.8手动舒适型', NULL, 3694, 0, NULL, 'F', 0, 5, 11326),
(50529, '1.8手动经典型', NULL, 3694, 0, NULL, 'F', 0, 5, 11325),
(50528, '经典款 1.8L 自动 时尚型', NULL, 3693, 0, NULL, 'F', 0, 5, 100196),
(50527, '经典款 1.8L 手动 时尚型', NULL, 3693, 0, NULL, 'F', 0, 5, 100195),
(50526, '经典款 1.8L 自动 基本型', NULL, 3693, 0, NULL, 'F', 0, 5, 100193),
(50525, '经典款 1.8L 手动 基本型', NULL, 3693, 0, NULL, 'F', 0, 5, 100180),
(50524, '2.0L 自动 旗舰型', NULL, 3693, 0, NULL, 'F', 0, 5, 16274),
(50523, '1.6L 自动 尊贵型', NULL, 3693, 0, NULL, 'F', 0, 5, 16273),
(50522, '1.6L 自动 风尚型', NULL, 3693, 0, NULL, 'F', 0, 5, 16272),
(50521, '1.6L 手动 风尚型', NULL, 3693, 0, NULL, 'F', 0, 5, 16271),
(50520, '1.6L 自动 舒适型', NULL, 3693, 0, NULL, 'F', 0, 5, 16270),
(50519, '1.6L 手动 舒适型', NULL, 3693, 0, NULL, 'F', 0, 5, 16265),
(50518, '经典款 1.8L 自动 百万纪念款', NULL, 3692, 0, NULL, 'F', 0, 5, 104148),
(50517, '经典款 1.8L 手动 百万纪念款', NULL, 3692, 0, NULL, 'F', 0, 5, 104147),
(50516, '经典款 1.8L 自动 时尚型', NULL, 3692, 0, NULL, 'F', 0, 5, 103214),
(50515, '经典款 1.8L 手动 时尚型', NULL, 3692, 0, NULL, 'F', 0, 5, 103213),
(50514, '经典款 1.8L 自动 基本型', NULL, 3692, 0, NULL, 'F', 0, 5, 103212),
(50513, '经典款 1.8L 手动 基本型', NULL, 3692, 0, NULL, 'F', 0, 5, 103210),
(50512, '2.0AT运动型', NULL, 3691, 0, NULL, 'F', 0, 5, 310),
(50511, '2.0MT运动型', NULL, 3691, 0, NULL, 'F', 0, 5, 309),
(50510, '1.8AT时尚型', NULL, 3691, 0, NULL, 'F', 0, 5, 308),
(50509, '1.8MT舒适型', NULL, 3691, 0, NULL, 'F', 0, 5, 307),
(50508, '两厢2.0手动 运动型', NULL, 3691, 0, NULL, 'F', 0, 5, 306),
(50507, '两厢1.8手自一体 时尚型', NULL, 3691, 0, NULL, 'F', 0, 5, 305),
(50506, '两厢1.8手动 经典型', NULL, 3691, 0, NULL, 'F', 0, 5, 304),
(50505, '2.0手自一体运动型', NULL, 3690, 0, NULL, 'F', 0, 5, 108111),
(50504, '2.0手动运动型', NULL, 3690, 0, NULL, 'F', 0, 5, 108110),
(50503, '1.8手自一体时尚型', NULL, 3690, 0, NULL, 'F', 0, 5, 108109),
(50502, '1.8手动舒适型', NULL, 3690, 0, NULL, 'F', 0, 5, 108108),
(50501, '2.0AT 运动型', NULL, 3689, 0, NULL, 'F', 0, 5, 6992),
(50500, '2.0MT 运动型', NULL, 3689, 0, NULL, 'F', 0, 5, 6991),
(50499, '1.8AT 时尚型', NULL, 3689, 0, NULL, 'F', 0, 5, 6990),
(50498, '1.8MT 舒适型', NULL, 3689, 0, NULL, 'F', 0, 5, 6989),
(50497, '1.8手动经典型', NULL, 3688, 0, NULL, 'F', 0, 5, 108122),
(50496, '2.0MT运动限量版', NULL, 3688, 0, NULL, 'F', 0, 5, 9791),
(50495, '2.0自动运动型', NULL, 3687, 0, NULL, 'F', 0, 5, 11334),
(50494, '2.0手动运动型', NULL, 3687, 0, NULL, 'F', 0, 5, 11333),
(50493, '1.8自动时尚型', NULL, 3687, 0, NULL, 'F', 0, 5, 11332),
(50492, '1.8手动舒适型', NULL, 3687, 0, NULL, 'F', 0, 5, 11331),
(50491, '1.8手动经典型', NULL, 3687, 0, NULL, 'F', 0, 5, 11330),
(50490, '经典款 1.8L 自动 时尚型', NULL, 3686, 0, NULL, 'F', 0, 5, 100187),
(50489, '经典款 1.8L 自动 基本型', NULL, 3686, 0, NULL, 'F', 0, 5, 100185),
(50488, '经典款 1.8L 手动 时尚型', NULL, 3686, 0, NULL, 'F', 0, 5, 100184),
(50487, '经典款 1.8L 手动 基本型', NULL, 3686, 0, NULL, 'F', 0, 5, 100182),
(50486, '2.0L 自动 豪华运动型', NULL, 3686, 0, NULL, 'F', 0, 5, 16276),
(50484, '1.6L 自动 风尚型', NULL, 3686, 0, NULL, 'F', 0, 5, 16269),
(50485, '2.0L 手动 豪华运动型', NULL, 3686, 0, NULL, 'F', 0, 5, 16275),
(50483, '1.6L 手动 风尚型', NULL, 3686, 0, NULL, 'F', 0, 5, 16268),
(50482, '1.6L 自动 舒适型', NULL, 3686, 0, NULL, 'F', 0, 5, 16267),
(50481, '1.6L 手动 舒适型', NULL, 3686, 0, NULL, 'F', 0, 5, 16266),
(50480, '经典款 1.8L 自动 百万纪念款', NULL, 3685, 0, NULL, 'F', 0, 5, 104152),
(50479, '经典款 1.8L 手动 百万纪念款', NULL, 3685, 0, NULL, 'F', 0, 5, 104151),
(50478, '经典款 1.8L 自动 时尚型', NULL, 3685, 0, NULL, 'F', 0, 5, 103218),
(50477, '经典款 1.8L 手动 时尚型', NULL, 3685, 0, NULL, 'F', 0, 5, 103217),
(50476, '经典款 1.8L 自动 基本型', NULL, 3685, 0, NULL, 'F', 0, 5, 103216),
(50475, '经典款 1.8L 手动 基本型', NULL, 3685, 0, NULL, 'F', 0, 5, 103215),
(50474, '3.5 FWD 自动版', NULL, 3684, 0, NULL, 'F', 0, 5, 109565),
(50472, '3.5L AWD', NULL, 3684, 0, NULL, 'F', 0, 5, 8760),
(50473, '2.7 FWD 自动版', NULL, 3684, 0, NULL, 'F', 0, 5, 109564),
(50471, '3.5L FWD', NULL, 3684, 0, NULL, 'F', 0, 5, 8759),
(50470, '2.7L AWD', NULL, 3684, 0, NULL, 'F', 0, 5, 8758),
(50469, '2.7L FWD', NULL, 3684, 0, NULL, 'F', 0, 5, 8757),
(50468, '2.7L 自动 至尊版 四驱', NULL, 3683, 0, NULL, 'F', 0, 5, 104374),
(50467, '2.7L 自动 豪华版 四驱', NULL, 3683, 0, NULL, 'F', 0, 5, 104373),
(50466, '2.7L 自动 两驱 豪华版', NULL, 3683, 0, NULL, 'F', 0, 5, 104265),
(50465, '2.7L 自动 两驱 至尊版 ', NULL, 3683, 0, NULL, 'F', 0, 5, 104209),
(50464, 'DX 8人座', NULL, 3682, 0, NULL, 'F', 0, 5, 10270),
(50463, 'ACR50L—GFPGK 7人座豪华版', NULL, 3681, 0, NULL, 'F', 0, 5, 3685),
(50462, 'ACR50L—GFPGK 7人座标准版', NULL, 3681, 0, NULL, 'F', 0, 5, 3653),
(50461, 'GSR50L—GFTGK 7人座豪华版', NULL, 3680, 0, NULL, 'F', 0, 5, 5826),
(50460, '3.5L 自动 七座豪华版', NULL, 3679, 0, NULL, 'F', 0, 5, 10727),
(50459, '2.4L 自动 七座豪华版', NULL, 3679, 0, NULL, 'F', 0, 5, 10726),
(50458, '2.4L 自动 七座标准版', NULL, 3679, 0, NULL, 'F', 0, 5, 10725),
(50457, '2.4L 自动 七座标准版', NULL, 3678, 0, NULL, 'F', 0, 5, 104546),
(50456, '2.4L 自动 七座豪华版', NULL, 3678, 0, NULL, 'F', 0, 5, 104545),
(50455, '3.5L 自动 七座豪华版', NULL, 3678, 0, NULL, 'F', 0, 5, 104542),
(50454, '3400', NULL, 3677, 0, NULL, 'F', 0, 5, 7583),
(50453, '普拉多4000中东版', NULL, 3677, 0, NULL, 'F', 0, 5, 5918),
(50452, '丰田普拉多4000', NULL, 3677, 0, NULL, 'F', 0, 5, 5013),
(50451, 'GX 2.7自动车型', NULL, 3676, 0, NULL, 'F', 0, 5, 5348),
(50450, 'GX 2.7手动车型', NULL, 3676, 0, NULL, 'F', 0, 5, 5347),
(50449, '霸道（PRADO） VX4.0', NULL, 3675, 0, NULL, 'F', 0, 5, 6825),
(50448, 'GX级2700自动型TRJ120L—GKPEKV', NULL, 3674, 0, NULL, 'F', 0, 5, 5904),
(50447, '2.7 中东版', NULL, 3673, 0, NULL, 'F', 0, 5, 109571),
(50446, '3000 柴油版', NULL, 3673, 0, NULL, 'F', 0, 5, 8229),
(50445, '2700(中东版)', NULL, 3673, 0, NULL, 'F', 0, 5, 5350),
(50444, '4000', NULL, 3672, 0, NULL, 'F', 0, 5, 9765),
(50443, 'GX 3.0', NULL, 3672, 0, NULL, 'F', 0, 5, 3679),
(50442, 'VX 3.0', NULL, 3672, 0, NULL, 'F', 0, 5, 3650),
(50441, '2694 2.7 TX-L 7 SPL A/T低配', NULL, 3671, 0, NULL, 'F', 0, 5, 13565),
(50440, '2700 2.7 AT 中东版高配', NULL, 3671, 0, NULL, 'F', 0, 5, 10724),
(50439, '自动豪华版', NULL, 3671, 0, NULL, 'F', 0, 5, 9959),
(50438, '自动标准版', NULL, 3671, 0, NULL, 'F', 0, 5, 9958),
(50437, '手动版', NULL, 3671, 0, NULL, 'F', 0, 5, 9957),
(50436, '4000 中东版', NULL, 3671, 0, NULL, 'F', 0, 5, 9939),
(50434, '2700 2.7 AT 中东版', NULL, 3669, 0, NULL, 'F', 0, 5, 103147),
(50435, '2700 2.7 AT 中东版高配', NULL, 3670, 0, NULL, 'F', 0, 5, 102432),
(50433, '2.7L 手动版', NULL, 3668, 0, NULL, 'F', 0, 5, 106474),
(50432, '2.7L 自动标准版', NULL, 3668, 0, NULL, 'F', 0, 5, 106473),
(50431, '2.7L 自动豪华版', NULL, 3668, 0, NULL, 'F', 0, 5, 106472),
(50430, '4500 GX—R', NULL, 3667, 0, NULL, 'F', 0, 5, 6483),
(50429, '4500 GX', NULL, 3666, 0, NULL, 'F', 0, 5, 7550),
(50428, '中东版4500 顶配', NULL, 3665, 0, NULL, 'F', 0, 5, 7904),
(50427, '4700 标配', NULL, 3665, 0, NULL, 'F', 0, 5, 5858),
(50426, '4700 高配', NULL, 3665, 0, NULL, 'F', 0, 5, 5857),
(50425, '4000', NULL, 3665, 0, NULL, 'F', 0, 5, 4997),
(50424, '4000', NULL, 3664, 0, NULL, 'F', 0, 5, 5856),
(50423, '4700 （中东款顶配）', NULL, 3663, 0, NULL, 'F', 0, 5, 7604),
(50422, '5700', NULL, 3662, 0, NULL, 'F', 0, 5, 5327),
(50421, '5.7 自动版', NULL, 3661, 0, NULL, 'F', 0, 5, 109570),
(50420, '4000', NULL, 3661, 0, NULL, 'F', 0, 5, 9217),
(50419, '4700（中东版）', NULL, 3661, 0, NULL, 'F', 0, 5, 5328),
(50418, '4700(中东版)', NULL, 3660, 0, NULL, 'F', 0, 5, 12189),
(50417, '5700', NULL, 3660, 0, NULL, 'F', 0, 5, 10822),
(50416, '4.0L 四驱 LC76', NULL, 3659, 0, NULL, 'F', 0, 5, 15519),
(50415, '四驱 4.0L LC71', NULL, 3659, 0, NULL, 'F', 0, 5, 15518),
(50414, '4000 60周年纪念版', NULL, 3659, 0, NULL, 'F', 0, 5, 14041),
(50413, '5700(中东版)', NULL, 3659, 0, NULL, 'F', 0, 5, 12339),
(50412, '5700', NULL, 3659, 0, NULL, 'F', 0, 5, 11968),
(50411, '4000 60周年纪念版', NULL, 3658, 0, NULL, 'F', 0, 5, 102431),
(50410, '5700(中东版)', NULL, 3658, 0, NULL, 'F', 0, 5, 102429),
(50409, '5700(中东版)', NULL, 3657, 0, NULL, 'F', 0, 5, 102433),
(50408, '29座 柴油', NULL, 3656, 0, NULL, 'F', 0, 5, 3258),
(50407, '17座 汽油', NULL, 3656, 0, NULL, 'F', 0, 5, 3257),
(50406, '12座 中东版 VIP', NULL, 3655, 0, NULL, 'F', 0, 5, 7200),
(50405, '柴油型 30座(中东版标配)', NULL, 3654, 0, NULL, 'F', 0, 5, 9796),
(50404, '柴油型 30座(中东版高配)', NULL, 3654, 0, NULL, 'F', 0, 5, 7857),
(50403, '2.5 标准版', NULL, 3653, 0, NULL, 'F', 0, 5, 13172),
(50402, '2.5 豪华版', NULL, 3653, 0, NULL, 'F', 0, 5, 13163),
(50401, '花冠 1.6L', NULL, 3652, 0, NULL, 'F', 0, 5, 7545),
(50400, '5.7', NULL, 3651, 0, NULL, 'F', 0, 5, 9731),
(50399, '4.7L', NULL, 3651, 0, NULL, 'F', 0, 5, 3259),
(50396, '5.7', NULL, 3649, 0, NULL, 'F', 0, 5, 9732),
(50398, '5.7 自动版', NULL, 3650, 0, NULL, 'F', 0, 5, 109569),
(50397, '5.7L', NULL, 3650, 0, NULL, 'F', 0, 5, 5351),
(50394, '5.7', NULL, 3648, 0, NULL, 'F', 0, 5, 12340),
(50395, '4.7', NULL, 3649, 0, NULL, 'F', 0, 5, 9730),
(50393, '2.7L 自动挡', NULL, 3647, 0, NULL, 'F', 0, 5, 9209),
(50392, '2.7L 手动挡', NULL, 3647, 0, NULL, 'F', 0, 5, 9202),
(50391, '5座四驱', NULL, 3646, 0, NULL, 'F', 0, 5, 10823),
(50390, '2.7L 4AT 2700中东版', NULL, 3645, 0, NULL, 'F', 0, 5, 111285),
(50389, '亚洲龙(AVALON)3.0', NULL, 3644, 0, NULL, 'F', 0, 5, 3649),
(50388, '基本型', NULL, 3643, 0, NULL, 'F', 0, 5, 109853),
(50387, '1.8L', NULL, 3642, 0, NULL, 'F', 0, 5, 6727),
(50386, '坦途高配', NULL, 3641, 0, NULL, 'F', 0, 5, 7605),
(50385, '坦途标配', NULL, 3641, 0, NULL, 'F', 0, 5, 6828),
(50384, '坦途 5.7L 手自一体 标准版', NULL, 3640, 0, NULL, 'F', 0, 5, 16300),
(50383, '坦途 5.7L 手自一体 TRD岩石战士版', NULL, 3640, 0, NULL, 'F', 0, 5, 16299),
(50382, '坦途 5.7L 手自一体 TRD越野版', NULL, 3640, 0, NULL, 'F', 0, 5, 16298),
(50381, '坦途 5.7L 手自一体 限量版', NULL, 3640, 0, NULL, 'F', 0, 5, 16297),
(50380, '坦途 5.7L 手自一体 限量TRD越野版', NULL, 3640, 0, NULL, 'F', 0, 5, 16296),
(50379, '坦途 5.7L 手自一体 白金版', NULL, 3640, 0, NULL, 'F', 0, 5, 16295),
(50378, '5.7L 手自一体 双门', NULL, 3640, 0, NULL, 'F', 0, 5, 13090),
(50377, '5.7L 手自一体 一门半', NULL, 3640, 0, NULL, 'F', 0, 5, 13089),
(50376, '4.6L 手自一体 双门', NULL, 3640, 0, NULL, 'F', 0, 5, 13088),
(50375, '4.6L 手自一体 一门半', NULL, 3640, 0, NULL, 'F', 0, 5, 13087),
(50374, '坦途 5.7L 手自一体 白金版', NULL, 3639, 0, NULL, 'F', 0, 5, 106107),
(50373, '佳美2.2L', NULL, 3638, 0, NULL, 'F', 0, 5, 6480),
(50371, '佳美(CAMPY)2.4 豪华版', NULL, 3637, 0, NULL, 'F', 0, 5, 6479),
(50372, '2.4 自动版', NULL, 3637, 0, NULL, 'F', 0, 5, 109567),
(50370, '佳美(CAMPY)2.0 标准版', NULL, 3637, 0, NULL, 'F', 0, 5, 3647),
(50368, '2.4 自动版', NULL, 3635, 0, NULL, 'F', 0, 5, 109568),
(50369, '佳美(CAMRY)2.4', NULL, 3636, 0, NULL, 'F', 0, 5, 6478),
(50367, '2.8L', NULL, 3634, 0, NULL, 'F', 0, 5, 6826),
(50366, '3.0L', NULL, 3633, 0, NULL, 'F', 0, 5, 6827),
(50365, 'LIMITED（至尊版）', NULL, 3632, 0, NULL, 'F', 0, 5, 3263),
(50364, 'SPORT LUXURY（运动豪华型）', NULL, 3632, 0, NULL, 'F', 0, 5, 3262),
(50363, 'SPORT（运动版）', NULL, 3632, 0, NULL, 'F', 0, 5, 3261),
(50361, '2.4 MT', NULL, 3631, 0, NULL, 'F', 0, 5, 15613),
(50362, 'DELUX（精英版）', NULL, 3632, 0, NULL, 'F', 0, 5, 3260),
(50360, '13人座豪华小客车 TRH223L—LEPNK 标准版', NULL, 3630, 0, NULL, 'F', 0, 5, 7854),
(50359, '10人座豪华小客车 TRH213L—JDMNK 标准版', NULL, 3630, 0, NULL, 'F', 0, 5, 3253),
(50358, '13人座豪华小客车 TRH223L—LEPNK 豪华版', NULL, 3630, 0, NULL, 'F', 0, 5, 3252),
(50356, '4.0L V6', NULL, 3629, 0, NULL, 'F', 0, 5, 3255),
(50357, '13人座豪华小客车 TRH223L—LEMNK 标准版', NULL, 3630, 0, NULL, 'F', 0, 5, 3251),
(50355, '15座 中东版', NULL, 3628, 0, NULL, 'F', 0, 5, 7201),
(50354, '2.7L 自动 豪华版 超长轴距高顶式 13座', NULL, 3627, 0, NULL, 'F', 0, 5, 14581),
(50353, '2.7L 自动 标准版 超长轴距高顶式 13座', NULL, 3627, 0, NULL, 'F', 0, 5, 14580),
(50352, '2.7L 手动 标准版 超长轴距高顶式 13座', NULL, 3627, 0, NULL, 'F', 0, 5, 14578),
(50350, '2.0 豪华版', NULL, 3626, 0, NULL, 'F', 0, 5, 109715),
(50351, '2.7L 手动 标准版 长轴距半高顶式 10座', NULL, 3627, 0, NULL, 'F', 0, 5, 14572),
(50349, '2.0 科技版', NULL, 3626, 0, NULL, 'F', 0, 5, 109714),
(50348, '2.0L 自动版', NULL, 3626, 0, NULL, 'F', 0, 5, 13405),
(50347, '2.0 三门版', NULL, 3625, 0, NULL, 'F', 0, 5, 109566),
(50345, 'RAV4 五门', NULL, 3624, 0, NULL, 'F', 0, 5, 3687),
(50346, '丰田RAV4 2.0AT', NULL, 3625, 0, NULL, 'F', 0, 5, 15473),
(50344, 'RAV4 三门', NULL, 3624, 0, NULL, 'F', 0, 5, 3686),
(50343, '2.4 豪华型', NULL, 3623, 0, NULL, 'F', 0, 5, 3689),
(50341, 'MR2', NULL, 3622, 0, NULL, 'F', 0, 5, 3652),
(50342, '2.4 标准型', NULL, 3623, 0, NULL, 'F', 0, 5, 3688),
(50340, '2.0L 手动 豪华', NULL, 3621, 0, NULL, 'F', 0, 5, 103096),
(50339, '2.0L 自动 豪华', NULL, 3621, 0, NULL, 'F', 0, 5, 103095),
(50337, '2.4L 豪华版', NULL, 3620, 0, NULL, 'F', 0, 5, 11688),
(50338, '3.5L 豪华版', NULL, 3620, 0, NULL, 'F', 0, 5, 12179),
(50335, '3.5L 手自一体 豪华版', NULL, 3619, 0, NULL, 'F', 0, 5, 100646),
(50336, '2.4L 手自一体 豪华版', NULL, 3619, 0, NULL, 'F', 0, 5, 100648),
(50334, '2.4L CVT 豪华版', NULL, 3618, 0, NULL, 'F', 0, 5, 103408),
(50333, '3.5L 手自一体 尊贵版', NULL, 3618, 0, NULL, 'F', 0, 5, 103202),
(50331, '3.5 自动 两驱限量版', NULL, 3616, 0, NULL, 'F', 0, 5, 109563),
(50332, '3.3 XLE', NULL, 3617, 0, NULL, 'F', 0, 5, 6726),
(50330, '2.7 自动 两驱标准型', NULL, 3616, 0, NULL, 'F', 0, 5, 109562),
(50328, '3.5L 自动 两驱 限量版', NULL, 3615, 0, NULL, 'F', 0, 5, 16293),
(50329, '2.7L 自动 两驱 LE版', NULL, 3615, 0, NULL, 'F', 0, 5, 16294),
(50327, '3.5L 自动 四驱 限量版', NULL, 3615, 0, NULL, 'F', 0, 5, 16292),
(50326, '2.7L', NULL, 3615, 0, NULL, 'F', 0, 5, 12335),
(50324, '4.0', NULL, 3614, 0, NULL, 'F', 0, 5, 4399),
(50325, '3.5L 基本型', NULL, 3615, 0, NULL, 'F', 0, 5, 11350),
(50323, '4.0L', NULL, 3613, 0, NULL, 'F', 0, 5, 9659),
(50322, '4.0L', NULL, 3612, 0, NULL, 'F', 0, 5, 13159),
(50321, '4.0L 自动', NULL, 3611, 0, NULL, 'F', 0, 5, 103203),
(50320, '4Runner', NULL, 3610, 0, NULL, 'F', 0, 5, 11376),
(50319, '2.0L 经典版 AT', NULL, 3609, 0, NULL, 'F', 0, 5, 8287),
(50318, '2.4L 豪华导航版 AT', NULL, 3609, 0, NULL, 'F', 0, 5, 8286),
(50317, '2.4L 豪华版 AT', NULL, 3609, 0, NULL, 'F', 0, 5, 8285),
(50316, '2.0L 豪华导航版 AT', NULL, 3609, 0, NULL, 'F', 0, 5, 8284),
(50315, '2.0L 豪华版 AT', NULL, 3609, 0, NULL, 'F', 0, 5, 8283),
(50314, '2.4L 豪华导航版 MT', NULL, 3609, 0, NULL, 'F', 0, 5, 8281),
(50313, '2.4L 豪华版 MT', NULL, 3609, 0, NULL, 'F', 0, 5, 8280),
(50312, '2.0L 豪华导航版 MT', NULL, 3609, 0, NULL, 'F', 0, 5, 8279),
(50311, '2.0L 豪华版 MT', NULL, 3609, 0, NULL, 'F', 0, 5, 8278),
(50310, '2.0L 经典版 MT', NULL, 3609, 0, NULL, 'F', 0, 5, 8277),
(50309, '2.4L 自动豪华升级版', NULL, 3608, 0, NULL, 'F', 0, 5, 107349),
(50308, '2.4L 手动豪华升级版', NULL, 3608, 0, NULL, 'F', 0, 5, 107348),
(50307, '2.0L 豪华升级版 AT', NULL, 3608, 0, NULL, 'F', 0, 5, 11420),
(50306, '2.0L 豪华升级版 MT', NULL, 3608, 0, NULL, 'F', 0, 5, 11419),
(50305, '2.4L 自动至臻导航版', NULL, 3607, 0, NULL, 'F', 0, 5, 107374),
(50304, '2.4L 手动至臻导航版', NULL, 3607, 0, NULL, 'F', 0, 5, 107373),
(50303, '2.4L 自动至臻版', NULL, 3607, 0, NULL, 'F', 0, 5, 107372),
(50302, '2.4L 手动至臻版', NULL, 3607, 0, NULL, 'F', 0, 5, 107371),
(50301, '2.4L 自动豪华版', NULL, 3607, 0, NULL, 'F', 0, 5, 107370),
(50300, '2.4L 手动豪华版', NULL, 3607, 0, NULL, 'F', 0, 5, 107369),
(50299, '2.0L 自动豪华版', NULL, 3607, 0, NULL, 'F', 0, 5, 107368),
(50298, '2.0L 手动豪华版', NULL, 3607, 0, NULL, 'F', 0, 5, 107367),
(50297, '2.0L 自动四驱版', NULL, 3607, 0, NULL, 'F', 0, 5, 107366),
(50296, '2.0L 手动四驱版', NULL, 3607, 0, NULL, 'F', 0, 5, 107365),
(50295, '2.0L 自动经典版', NULL, 3607, 0, NULL, 'F', 0, 5, 107364),
(50294, '2.0L 手动经典版', NULL, 3607, 0, NULL, 'F', 0, 5, 107363),
(50293, '2.4L 豪华升级版 AT', NULL, 3607, 0, NULL, 'F', 0, 5, 12388),
(50292, '2.4L 豪华升级版 MT', NULL, 3607, 0, NULL, 'F', 0, 5, 12387),
(50291, '2.4L 自动 豪华炫装版', NULL, 3606, 0, NULL, 'F', 0, 5, 16348),
(50290, '2.4L 手动 豪华炫装版', NULL, 3606, 0, NULL, 'F', 0, 5, 16347),
(50289, '2.0L 自动 四驱 炫装版', NULL, 3606, 0, NULL, 'F', 0, 5, 16344),
(50288, '2.0L 手动 四驱 炫装版', NULL, 3606, 0, NULL, 'F', 0, 5, 16343),
(50287, '2.4L 自动 至臻导航版', NULL, 3606, 0, NULL, 'F', 0, 5, 14591),
(50286, '2.4L 手动 至臻导航版', NULL, 3606, 0, NULL, 'F', 0, 5, 14590),
(50285, '2.4L 自动 至臻版', NULL, 3606, 0, NULL, 'F', 0, 5, 14589),
(50284, '2.4L 手动 至臻版', NULL, 3606, 0, NULL, 'F', 0, 5, 14588),
(50283, '2.4L 自动 豪华版', NULL, 3606, 0, NULL, 'F', 0, 5, 14587),
(50282, '2.4L 手动 豪华版', NULL, 3606, 0, NULL, 'F', 0, 5, 14586),
(50281, '2.0L 自动 豪华版', NULL, 3606, 0, NULL, 'F', 0, 5, 14585),
(50280, '2.0L 手动 豪华版', NULL, 3606, 0, NULL, 'F', 0, 5, 14584),
(50279, '2.0L 自动 四驱版', NULL, 3606, 0, NULL, 'F', 0, 5, 14583),
(50278, '2.0L 手动 四驱版', NULL, 3606, 0, NULL, 'F', 0, 5, 14582),
(50277, '2.0L 自动 经典版', NULL, 3606, 0, NULL, 'F', 0, 5, 14579),
(50276, '2.0L 手动 经典版', NULL, 3606, 0, NULL, 'F', 0, 5, 14575),
(50275, '2.0L 手动 都市版', NULL, 3605, 0, NULL, 'F', 0, 5, 105051),
(50274, '2.0L CVT 都市版', NULL, 3605, 0, NULL, 'F', 0, 5, 105050),
(50273, '2.0L CVT 风尚版', NULL, 3605, 0, NULL, 'F', 0, 5, 105049),
(50272, '2.0L CVT 新锐版', NULL, 3605, 0, NULL, 'F', 0, 5, 105048),
(50271, '2.5L 手自一体 精英版', NULL, 3605, 0, NULL, 'F', 0, 5, 105047),
(50270, '2.5L 手自一体 豪华版', NULL, 3605, 0, NULL, 'F', 0, 5, 105046),
(50269, '2.5L 手自一体 尊贵版', NULL, 3605, 0, NULL, 'F', 0, 5, 105045),
(50268, '2.0L 手动 特享经典版', NULL, 3605, 0, NULL, 'F', 0, 5, 103379),
(50267, '2.0L 手动 特享精英版', NULL, 3605, 0, NULL, 'F', 0, 5, 103332),
(50266, '2.4L 手动 特享尊崇版', NULL, 3605, 0, NULL, 'F', 0, 5, 103331),
(50265, '2.4L 自动 特享尊崇版', NULL, 3605, 0, NULL, 'F', 0, 5, 103299),
(50264, '2.0L 自动 特享精英版', NULL, 3605, 0, NULL, 'F', 0, 5, 103297),
(50263, '2.0L 自动 特享经典版', NULL, 3605, 0, NULL, 'F', 0, 5, 103296),
(50262, '1.5 GLX-S 高级音响版自动', NULL, 3604, 0, NULL, 'F', 0, 5, 108863),
(50261, '1.5 GLX-i 高级音响版自动', NULL, 3604, 0, NULL, 'F', 0, 5, 107427),
(50260, '1.5 GLX-S 导航版自动', NULL, 3604, 0, NULL, 'F', 0, 5, 107426),
(50259, '1.5 GL-i自动', NULL, 3604, 0, NULL, 'F', 0, 5, 107425),
(50258, '1.5 GL-i手动', NULL, 3604, 0, NULL, 'F', 0, 5, 107424),
(50257, '1.3 DLX手动', NULL, 3604, 0, NULL, 'F', 0, 5, 107423),
(50256, '1.5 GLX-i 电子导航版自动', NULL, 3604, 0, NULL, 'F', 0, 5, 107362),
(50255, 'GLX—S1.5AT DVD语音电子导航版', NULL, 3603, 0, NULL, 'F', 0, 5, 2367),
(50254, 'GLX—i1.5AT高级音响版', NULL, 3603, 0, NULL, 'F', 0, 5, 2366),
(50253, 'Gl—i1.5MT', NULL, 3603, 0, NULL, 'F', 0, 5, 2365),
(50252, 'GL—i1.5AT', NULL, 3603, 0, NULL, 'F', 0, 5, 2364),
(50251, '1.3 DLX自动', NULL, 3602, 0, NULL, 'F', 0, 5, 108873),
(50250, '1.3 GL手动', NULL, 3602, 0, NULL, 'F', 0, 5, 107428),
(50249, '二周年纪念版 MT', NULL, 3602, 0, NULL, 'F', 0, 5, 2374),
(50248, '二周年纪念版 AT', NULL, 3602, 0, NULL, 'F', 0, 5, 2373),
(50247, 'GLX—S1.5AT NAVI', NULL, 3602, 0, NULL, 'F', 0, 5, 2372),
(50246, 'GLX—i1.5AT', NULL, 3602, 0, NULL, 'F', 0, 5, 2371),
(50245, 'GL—1.3AT', NULL, 3602, 0, NULL, 'F', 0, 5, 2370),
(50244, 'GL—1.3MT', NULL, 3602, 0, NULL, 'F', 0, 5, 2369),
(50243, 'DLX 1.3 MT', NULL, 3602, 0, NULL, 'F', 0, 5, 2368),
(50242, 'GL—i1.5MT', NULL, 3602, 0, NULL, 'F', 0, 5, 2363),
(50241, 'GL—i1.5AT', NULL, 3602, 0, NULL, 'F', 0, 5, 2362),
(50240, '1.5 GL-i自动', NULL, 3601, 0, NULL, 'F', 0, 5, 107439),
(50239, '1.5 GL-i手动', NULL, 3601, 0, NULL, 'F', 0, 5, 107437),
(50238, '1.5L GLX—i电子导航版 自动型', NULL, 3601, 0, NULL, 'F', 0, 5, 6349),
(50237, '1.5L GLX—i 高级音响版 自动型', NULL, 3601, 0, NULL, 'F', 0, 5, 6348),
(50236, '1.5L GL—i 自动型', NULL, 3601, 0, NULL, 'F', 0, 5, 6347),
(50235, '1.5L GL—i 手动型', NULL, 3601, 0, NULL, 'F', 0, 5, 6346),
(50234, 'GL 1.3AT ', NULL, 3601, 0, NULL, 'F', 0, 5, 6345),
(50233, 'GL 1.3MT', NULL, 3601, 0, NULL, 'F', 0, 5, 6344),
(50231, '三周年纪念版 AT', NULL, 3601, 0, NULL, 'F', 0, 5, 2376),
(50232, '1.5L GL-S运动版', NULL, 3601, 0, NULL, 'F', 0, 5, 2377),
(50230, '三周年纪念版 MT', NULL, 3601, 0, NULL, 'F', 0, 5, 2375),
(50229, '1.5 GLX-i VVT-i版自动', NULL, 3600, 0, NULL, 'F', 0, 5, 108876),
(50228, '1.5 GL-S VVT-i版自动', NULL, 3600, 0, NULL, 'F', 0, 5, 108875),
(50227, '1.5 GL-i自动', NULL, 3600, 0, NULL, 'F', 0, 5, 107440),
(50226, '1.5 GL-i手动', NULL, 3600, 0, NULL, 'F', 0, 5, 107438),
(50225, '1.3 GL 特别版自动', NULL, 3600, 0, NULL, 'F', 0, 5, 107436),
(50224, '1.3 GL 特别版手动', NULL, 3600, 0, NULL, 'F', 0, 5, 107435),
(50223, '1.5 GLX-i 电子导航版自动', NULL, 3600, 0, NULL, 'F', 0, 5, 107431),
(50222, '1.3L GL特别版 手动型', NULL, 3600, 0, NULL, 'F', 0, 5, 6351),
(50221, '1.3L GL特别版 自动型', NULL, 3600, 0, NULL, 'F', 0, 5, 6350),
(50220, '1.6 GLX-i自动', NULL, 3599, 0, NULL, 'F', 0, 5, 108874),
(50219, '1.6 GL-S 炫酷运动版自动', NULL, 3599, 0, NULL, 'F', 0, 5, 107434),
(50218, '1.6 GL-i自动', NULL, 3599, 0, NULL, 'F', 0, 5, 107433),
(50217, '1.6 GL-i手动', NULL, 3599, 0, NULL, 'F', 0, 5, 107432),
(50216, '1.3 GL-i自动', NULL, 3599, 0, NULL, 'F', 0, 5, 107430),
(50215, '1.3 GL-i手动', NULL, 3599, 0, NULL, 'F', 0, 5, 107429),
(50214, '1.6 GL-i 标准版自动', NULL, 3598, 0, NULL, 'F', 0, 5, 108879),
(50212, '1.3L GL—i 特别纪念版 AT', NULL, 3598, 0, NULL, 'F', 0, 5, 7159),
(50213, '1.6 GL-i 标准版手动', NULL, 3598, 0, NULL, 'F', 0, 5, 108878),
(50211, '1.3L GL—i 特别纪念版 MT', NULL, 3598, 0, NULL, 'F', 0, 5, 7158),
(50210, '1.6L GL—i 特别限量版 自动', NULL, 3598, 0, NULL, 'F', 0, 5, 5829),
(50209, '1.6L GL—i 特别限量版 手动', NULL, 3598, 0, NULL, 'F', 0, 5, 5828),
(50208, '1.6L GLX—i 天窗版 AT', NULL, 3598, 0, NULL, 'F', 0, 5, 2385),
(50207, '1.6L GL—S 运动版 AT', NULL, 3598, 0, NULL, 'F', 0, 5, 2384),
(50206, '1.6L GL—i 特别纪念版 AT', NULL, 3598, 0, NULL, 'F', 0, 5, 2383),
(50205, '1.6L GL—i 特别纪念版 MT', NULL, 3598, 0, NULL, 'F', 0, 5, 2382),
(50204, '1.3 GL—i 标准版 AT', NULL, 3598, 0, NULL, 'F', 0, 5, 2381),
(50203, '1.3 GL—i 标准版 MT', NULL, 3598, 0, NULL, 'F', 0, 5, 2380),
(50202, '1.6 GLX-i自动', NULL, 3597, 0, NULL, 'F', 0, 5, 108864),
(50201, '1.6 GLX-i自动', NULL, 3596, 0, NULL, 'F', 0, 5, 108877),
(50200, '1.6L GLX—i 天窗版 AT', NULL, 3596, 0, NULL, 'F', 0, 5, 11862),
(50199, '1.6L GL—S 运动版 AT', NULL, 3596, 0, NULL, 'F', 0, 5, 11861),
(50197, '1.6L GL—i MT', NULL, 3596, 0, NULL, 'F', 0, 5, 11859),
(50198, '1.6L GL—i AT', NULL, 3596, 0, NULL, 'F', 0, 5, 11860),
(50196, '1.3L GL—i AT', NULL, 3596, 0, NULL, 'F', 0, 5, 11858),
(50195, '1.3L GL—i MT', NULL, 3596, 0, NULL, 'F', 0, 5, 11857),
(50193, '1.3L GL—i 标准版 MT', NULL, 3596, 0, NULL, 'F', 0, 5, 11855),
(50194, '1.3L GL—i 标准版 AT', NULL, 3596, 0, NULL, 'F', 0, 5, 11856),
(50192, '1.6L GLX-i 天窗版 自动', NULL, 3595, 0, NULL, 'F', 0, 5, 13779),
(50191, '1.6L GL-S 运动版 自动', NULL, 3595, 0, NULL, 'F', 0, 5, 13778),
(50190, '1.6L GL-i 天窗版 自动', NULL, 3595, 0, NULL, 'F', 0, 5, 13777),
(50189, '1.6L GL-i 天窗版 手动', NULL, 3595, 0, NULL, 'F', 0, 5, 13776),
(50188, '1.3L GL-i 自动', NULL, 3595, 0, NULL, 'F', 0, 5, 13775),
(50187, '1.3L GL-i 手动', NULL, 3595, 0, NULL, 'F', 0, 5, 13774),
(50186, '1.3L GL-i 标准版 自动', NULL, 3595, 0, NULL, 'F', 0, 5, 13773),
(50184, '1.3L GL-i 手动 标准版', NULL, 3594, 0, NULL, 'F', 0, 5, 104080),
(50185, '1.3L GL-i 标准版 手动', NULL, 3595, 0, NULL, 'F', 0, 5, 13772),
(50183, '1.3L GL-i 自动 标准版', NULL, 3594, 0, NULL, 'F', 0, 5, 104079),
(50181, '1.3L GL-i 自动 型尚版', NULL, 3594, 0, NULL, 'F', 0, 5, 104077),
(50182, '1.3L GL-i 手动 型尚版', NULL, 3594, 0, NULL, 'F', 0, 5, 104078),
(50180, '1.6L GL-i 手动 型尚天窗版', NULL, 3594, 0, NULL, 'F', 0, 5, 104076),
(50179, '1.6L GL-i 自动 型尚天窗版', NULL, 3594, 0, NULL, 'F', 0, 5, 104075),
(50177, '1.5L 手动 智享版', NULL, 3593, 0, NULL, 'F', 0, 5, 111135),
(50178, '1.6L GLX-i 自动 型尚智领版', NULL, 3594, 0, NULL, 'F', 0, 5, 104074),
(50176, '1.5L 手动 智臻版', NULL, 3593, 0, NULL, 'F', 0, 5, 110130),
(50175, '1.5L 自动 智臻版', NULL, 3593, 0, NULL, 'F', 0, 5, 110129),
(50174, '1.3L 手动 超值版', NULL, 3593, 0, NULL, 'F', 0, 5, 105798),
(50173, '1.3L 手动 型尚版', NULL, 3593, 0, NULL, 'F', 0, 5, 105797),
(50172, '1.3L 自动 型尚版', NULL, 3593, 0, NULL, 'F', 0, 5, 105796),
(50171, '1.3L 自动 智尚版', NULL, 3593, 0, NULL, 'F', 0, 5, 105795),
(50170, '1.5L 手动 智尚版', NULL, 3593, 0, NULL, 'F', 0, 5, 105794),
(50169, '1.5L 自动 智尚版', NULL, 3593, 0, NULL, 'F', 0, 5, 105793),
(50168, '1.5L 自动 智享版', NULL, 3593, 0, NULL, 'F', 0, 5, 105792),
(50167, '1.5L 自动 智尊版', NULL, 3593, 0, NULL, 'F', 0, 5, 105791),
(50166, '激情1.3L 手动两驱型', NULL, 3592, 0, NULL, 'F', 0, 5, 2742),
(50165, '激情1.3L 自动两驱型', NULL, 3592, 0, NULL, 'F', 0, 5, 2741),
(50164, 'CX 四驱手动档', NULL, 3592, 0, NULL, 'F', 0, 5, 2740),
(50163, 'CX 两驱手动档', NULL, 3592, 0, NULL, 'F', 0, 5, 2739),
(50162, 'CX 四驱自动档', NULL, 3592, 0, NULL, 'F', 0, 5, 2738),
(50161, 'CX 两驱自动档', NULL, 3592, 0, NULL, 'F', 0, 5, 2737),
(50160, 'CL 两驱手动档', NULL, 3592, 0, NULL, 'F', 0, 5, 2736),
(50159, '2.5V 电子导航版', NULL, 3591, 0, NULL, 'F', 0, 5, 107421),
(50158, '3.0V Premium天窗导航版', NULL, 3591, 0, NULL, 'F', 0, 5, 107420),
(50157, '2.5V 天窗版', NULL, 3591, 0, NULL, 'F', 0, 5, 107418),
(50156, '2.5V 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 107417),
(50155, '2.5S豪华版', NULL, 3591, 0, NULL, 'F', 0, 5, 5209),
(50154, '3.0V 天窗导航版 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3076),
(50153, '3.0V 照明导航版 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3075),
(50152, '2.5V 天窗DVD语音导航选装', NULL, 3591, 0, NULL, 'F', 0, 5, 3074),
(50150, '2.5S 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3072),
(50151, '2.5V 天窗版 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3073),
(50149, '3.0V 照明版 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3071),
(50148, '2.5V 照明版 手自一体', NULL, 3591, 0, NULL, 'F', 0, 5, 3070),
(50147, '2.5V超级运动版', NULL, 3591, 0, NULL, 'F', 0, 5, 2413),
(50146, '2.5S真皮天窗版', NULL, 3591, 0, NULL, 'F', 0, 5, 2412),
(50145, '2.5V 电子导航版', NULL, 3590, 0, NULL, 'F', 0, 5, 107422),
(50144, '2.5V 天窗版', NULL, 3590, 0, NULL, 'F', 0, 5, 107419),
(50143, '2.5S 手自一体', NULL, 3590, 0, NULL, 'F', 0, 5, 107416),
(50142, '3.0V Premium天窗导航版', NULL, 3590, 0, NULL, 'F', 0, 5, 107360),
(50141, '2.5V 手自一体', NULL, 3590, 0, NULL, 'F', 0, 5, 107359),
(50140, '2.5S 特别版 手自一体', NULL, 3590, 0, NULL, 'F', 0, 5, 3077),
(50139, '2.5V天窗导航', NULL, 3589, 0, NULL, 'F', 0, 5, 5831),
(50138, '3.0V 超级运动版', NULL, 3589, 0, NULL, 'F', 0, 5, 3983),
(50137, '2.5V', NULL, 3589, 0, NULL, 'F', 0, 5, 3982),
(50135, '2.5S真皮天窗', NULL, 3589, 0, NULL, 'F', 0, 5, 3082),
(50136, '2.5V天窗', NULL, 3589, 0, NULL, 'F', 0, 5, 3083),
(50134, '2.5V 车顶照明版', NULL, 3589, 0, NULL, 'F', 0, 5, 3081),
(50133, '2.5V 超级运动版', NULL, 3589, 0, NULL, 'F', 0, 5, 3080),
(50132, '2.5S 特别天窗版', NULL, 3589, 0, NULL, 'F', 0, 5, 3078),
(50131, '2.5S', NULL, 3589, 0, NULL, 'F', 0, 5, 2414),
(50130, '2.5S特别纪念版', NULL, 3588, 0, NULL, 'F', 0, 5, 7155),
(50129, '2.5V 手自一体', NULL, 3587, 0, NULL, 'F', 0, 5, 107361),
(50128, '2.5SAVX版', NULL, 3587, 0, NULL, 'F', 0, 5, 8414),
(50127, '2.5S舒适版', NULL, 3587, 0, NULL, 'F', 0, 5, 8413),
(50126, '2.5V 风尚豪华导航版', NULL, 3586, 0, NULL, 'F', 0, 5, 11980),
(50125, '2.5V 风尚菁英版', NULL, 3586, 0, NULL, 'F', 0, 5, 11978),
(50123, '2.5S 风尚菁华版', NULL, 3586, 0, NULL, 'F', 0, 5, 11975),
(50124, '2.5V 风度菁英版', NULL, 3586, 0, NULL, 'F', 0, 5, 11977),
(50122, '3.0V 风尚旗舰导航版', NULL, 3586, 0, NULL, 'F', 0, 5, 11974),
(50121, '3.0V 风尚旗舰版', NULL, 3586, 0, NULL, 'F', 0, 5, 11973),
(50119, '2.5S特别导航版', NULL, 3586, 0, NULL, 'F', 0, 5, 11108),
(50120, '2.5S 风度菁华版', NULL, 3586, 0, NULL, 'F', 0, 5, 11972),
(50118, '2.5V 风度菁英版 炫装版', NULL, 3585, 0, NULL, 'F', 0, 5, 16345),
(50116, '2.5V 菁锐版', NULL, 3584, 0, NULL, 'F', 0, 5, 105339),
(50117, '2.5S 菁锐版', NULL, 3584, 0, NULL, 'F', 0, 5, 105340),
(50115, '2.5V 尚锐版', NULL, 3584, 0, NULL, 'F', 0, 5, 105338),
(50114, '2.5V 尊锐版', NULL, 3584, 0, NULL, 'F', 0, 5, 105337),
(50113, '2.5V 尊锐导航版', NULL, 3584, 0, NULL, 'F', 0, 5, 105336),
(50112, '2.5V 尚锐导航版', NULL, 3584, 0, NULL, 'F', 0, 5, 105335),
(50111, '3.0V 尊锐导航版', NULL, 3584, 0, NULL, 'F', 0, 5, 105331),
(50110, '1.5L NAVI版', NULL, 3583, 0, NULL, 'F', 0, 5, 4803),
(50109, '真皮版', NULL, 3583, 0, NULL, 'F', 0, 5, 3985),
(50108, '1.5 织物座椅版', NULL, 3582, 0, NULL, 'F', 0, 5, 107357),
(50107, '1.5 真皮座椅版', NULL, 3582, 0, NULL, 'F', 0, 5, 107356),
(50106, '真皮导航版', NULL, 3582, 0, NULL, 'F', 0, 5, 3986),
(50105, '标准版', NULL, 3582, 0, NULL, 'F', 0, 5, 3984),
(50104, '1.5 真皮导航版', NULL, 3581, 0, NULL, 'F', 0, 5, 107358),
(50103, '1.5AT织物座椅版', NULL, 3580, 0, NULL, 'F', 0, 5, 4802),
(50102, '1.8L CVT 豪华先进版', NULL, 3579, 0, NULL, 'F', 0, 5, 16002),
(50101, '1.8L CVT 豪华版', NULL, 3579, 0, NULL, 'F', 0, 5, 16001),
(50100, '1.8L CVT 标准版', NULL, 3579, 0, NULL, 'F', 0, 5, 16000),
(50099, '4.0L GX 自动', NULL, 3578, 0, NULL, 'F', 0, 5, 107345),
(50098, '4.0L GX', NULL, 3578, 0, NULL, 'F', 0, 5, 2333),
(50097, '4.0L GX 自动', NULL, 3577, 0, NULL, 'F', 0, 5, 107344),
(50096, '4.0L GX 运动DVD版', NULL, 3577, 0, NULL, 'F', 0, 5, 4879),
(50094, '4.0L GX 豪华版', NULL, 3577, 0, NULL, 'F', 0, 5, 4877),
(50095, '4.0L GX 豪华DVD版', NULL, 3577, 0, NULL, 'F', 0, 5, 4878),
(50093, '4.0L VX NAVI版', NULL, 3576, 0, NULL, 'F', 0, 5, 4876),
(50092, '4.0L VX', NULL, 3576, 0, NULL, 'F', 0, 5, 2337),
(50091, '4.0L VX 导航版', NULL, 3575, 0, NULL, 'F', 0, 5, 107347),
(50090, '4.0L VX 自动', NULL, 3575, 0, NULL, 'F', 0, 5, 107346),
(50089, '4.0L GX 运动DVD版', NULL, 3575, 0, NULL, 'F', 0, 5, 107324),
(50088, '4.0L GX 豪华DVD版', NULL, 3575, 0, NULL, 'F', 0, 5, 107323),
(50087, '4.0L GX 豪华版', NULL, 3575, 0, NULL, 'F', 0, 5, 107322),
(50086, '4.0L GX 自动', NULL, 3575, 0, NULL, 'F', 0, 5, 107321),
(50085, 'PRADO 2.7 GX手动型', NULL, 3575, 0, NULL, 'F', 0, 5, 2339),
(50084, 'PRADO 2.7 GX自动型', NULL, 3575, 0, NULL, 'F', 0, 5, 2338),
(50083, '4.0L V6 VX NAVI', NULL, 3574, 0, NULL, 'F', 0, 5, 11212),
(50082, '4.0L V6 VX', NULL, 3574, 0, NULL, 'F', 0, 5, 11211),
(50081, '4.0L V6 TX—L NAVI', NULL, 3574, 0, NULL, 'F', 0, 5, 11210),
(50080, '4.0L V6 TX—L', NULL, 3574, 0, NULL, 'F', 0, 5, 11209),
(50078, '4.0L V6 VX NAVI', NULL, 3573, 0, NULL, 'F', 0, 5, 106183),
(50079, '4.0L V6 TX', NULL, 3574, 0, NULL, 'F', 0, 5, 11208),
(50077, '4.0L V6 VX', NULL, 3573, 0, NULL, 'F', 0, 5, 106182),
(50076, '4.0L V6 TX-L NAVI', NULL, 3573, 0, NULL, 'F', 0, 5, 106181),
(50075, '4.0L V6 TX-L', NULL, 3573, 0, NULL, 'F', 0, 5, 106180),
(50074, '4.0L V6 TX', NULL, 3573, 0, NULL, 'F', 0, 5, 106177),
(50073, '4.5L GX 手动', NULL, 3572, 0, NULL, 'F', 0, 5, 107354),
(50072, '4.7L VX-R 自动', NULL, 3572, 0, NULL, 'F', 0, 5, 107353),
(50071, '4.5L GX-R 自动', NULL, 3572, 0, NULL, 'F', 0, 5, 107352),
(50070, '4.5L GX MT', NULL, 3572, 0, NULL, 'F', 0, 5, 6753),
(50069, '4.5L GX-R AT', NULL, 3572, 0, NULL, 'F', 0, 5, 6752),
(50068, '4.5L GX—R AT', NULL, 3572, 0, NULL, 'F', 0, 5, 2731),
(50067, '4.7L GX-R 自动 豪华DVD版', NULL, 3571, 0, NULL, 'F', 0, 5, 107355),
(50066, '4.7L VX-R 自动', NULL, 3571, 0, NULL, 'F', 0, 5, 6779),
(50065, '4.7L VX-R 豪华DVD版', NULL, 3571, 0, NULL, 'F', 0, 5, 6756),
(50064, '4.7L GX-R 自动', NULL, 3571, 0, NULL, 'F', 0, 5, 6754),
(50062, '4.7L GX—R 自动', NULL, 3571, 0, NULL, 'F', 0, 5, 2733),
(50063, '4.7L VX—R 豪华DVD版', NULL, 3571, 0, NULL, 'F', 0, 5, 2735),
(50061, '4.7L GX 自动', NULL, 3570, 0, NULL, 'F', 0, 5, 108862),
(50060, '4.7L GX 手动', NULL, 3570, 0, NULL, 'F', 0, 5, 6755),
(50059, '4700', NULL, 3569, 0, NULL, 'F', 0, 5, 3684),
(50058, '4.7L GX   5MT', NULL, 3569, 0, NULL, 'F', 0, 5, 3683),
(50057, '4.7L GX—R 5AT', NULL, 3569, 0, NULL, 'F', 0, 5, 3682),
(50056, '4.7L VX—R 5AT', NULL, 3569, 0, NULL, 'F', 0, 5, 3681),
(50055, '4.7L  VX—R', NULL, 3568, 0, NULL, 'F', 0, 5, 4724),
(50054, '4.7L GX—R', NULL, 3568, 0, NULL, 'F', 0, 5, 4723),
(50053, '4.0L GX—R(AT)', NULL, 3568, 0, NULL, 'F', 0, 5, 4722),
(50052, '4.0L GX—R(MT)', NULL, 3568, 0, NULL, 'F', 0, 5, 4395),
(50051, '4.7L VX—R', NULL, 3567, 0, NULL, 'F', 0, 5, 9622),
(50050, '4.7L VX', NULL, 3567, 0, NULL, 'F', 0, 5, 9621),
(50049, '4.0L VX', NULL, 3567, 0, NULL, 'F', 0, 5, 9620),
(50048, '4.0L GX—R', NULL, 3567, 0, NULL, 'F', 0, 5, 9619),
(50047, '4.0L 手自一体 GX-R', NULL, 3566, 0, NULL, 'F', 0, 5, 16544),
(50046, '4.0L 手自一体 VX', NULL, 3566, 0, NULL, 'F', 0, 5, 16543),
(50045, '4.6L 手自一体 VX', NULL, 3566, 0, NULL, 'F', 0, 5, 16542),
(50044, '4.6L 手自一体 VX-R', NULL, 3566, 0, NULL, 'F', 0, 5, 16373),
(50043, '4.1T 柴油28座', NULL, 3565, 0, NULL, 'F', 0, 5, 107326),
(50042, '2.7 汽油23座', NULL, 3565, 0, NULL, 'F', 0, 5, 107325),
(50041, '豪华型 23座 柴油', NULL, 3565, 0, NULL, 'F', 0, 5, 2349),
(50040, '豪华型 23座 汽油', NULL, 3565, 0, NULL, 'F', 0, 5, 2347),
(50039, '标准型 23座高地 柴油', NULL, 3565, 0, NULL, 'F', 0, 5, 2345),
(50038, '标准型 23座 柴油', NULL, 3565, 0, NULL, 'F', 0, 5, 2344),
(50037, '标准型 23座 汽油', NULL, 3565, 0, NULL, 'F', 0, 5, 2342),
(50036, '30座 柴油', NULL, 3564, 0, NULL, 'F', 0, 5, 10538),
(50035, '超VIP版 汽油', NULL, 3564, 0, NULL, 'F', 0, 5, 2351),
(50034, 'VIP版 汽油', NULL, 3564, 0, NULL, 'F', 0, 5, 2350),
(50033, '豪华型 20座 柴油', NULL, 3563, 0, NULL, 'F', 0, 5, 2348),
(50032, '豪华型 20座 汽油', NULL, 3563, 0, NULL, 'F', 0, 5, 2346),
(50031, '标准型 20座 柴油', NULL, 3563, 0, NULL, 'F', 0, 5, 2343),
(50030, '标准型 20座 汽油', NULL, 3563, 0, NULL, 'F', 0, 5, 2341),
(50029, '4.1T 豪华型30座柴油', NULL, 3562, 0, NULL, 'F', 0, 5, 108855),
(50028, '4.1T 标准型30座柴油', NULL, 3562, 0, NULL, 'F', 0, 5, 108854),
(50027, '2.7 标准型23座汽油', NULL, 3562, 0, NULL, 'F', 0, 5, 108853),
(50026, '2.7 豪华车23座汽油', NULL, 3562, 0, NULL, 'F', 0, 5, 107327),
(50025, '4.1T 标准型30座柴油', NULL, 3561, 0, NULL, 'F', 0, 5, 108857),
(50024, '2.7 标准型23座汽油', NULL, 3561, 0, NULL, 'F', 0, 5, 108856),
(50023, '4.1T 豪华车23座柴油', NULL, 3561, 0, NULL, 'F', 0