	var _tagFid = "SW_Tags_";
	var _tagIName = "TagSpan";
	var _tagSName = "TagValue";

	function TagInit(input, div, spans, ids, tags)
	{
		var inputObj = gid(input);

		if (inputObj)
		{
			inputObj.setAttribute(_tagIName, ids);
			inputObj.onkeydown = inputObj.onkeyup = TagsHandler;
		}

		var divObj = gid(div);		
		while(divObj.childNodes.length>0)
		{
			divObj.removeChild(divObj.childNodes[0]);
		}
		
		for (s in spans)
		{
			var tObj = document.createElement("p");
			tObj.style.margin = "0px";
			tObj.style.padding = "0px";
			var pObj = CreatTagSpan(spans[s], null, null);
			var sObj = CreatTagSpan(null, _tagFid + ids[s], tags[s]);
			for (t in tags[s])
			{
				sObj.appendChild(document.createTextNode(" "));
				sObj.appendChild(CreatTag(input, tags[s][t]));
			}
			tObj.appendChild(pObj);
			tObj.appendChild(sObj);
			if (divObj)
			{
				divObj.appendChild(tObj);
			}
		}
		
		var iTagSpanName = inputObj.getAttribute(_tagIName);
		var iTagText = " " + Trim(inputObj.value) + " ";
		UpdateSelectTag(iTagSpanName, iTagText)

	}

	function CreatTagSpan(spanname, spanid, tags)
	{
		var SPANobj = document.createElement("span");
		if (spanid) SPANobj.id = spanid;
		SPANobj.style.color = "#AAA";
		if (tags) SPANobj.setAttribute(_tagSName, tags);
		if (spanname) SPANobj.appendChild(document.createTextNode(spanname + ": "));
		return SPANobj;
	}

	function CreatTag(inputid, tag)
	{
		var Aobj = document.createElement("a");
		Aobj.className = "tagB";
		Aobj.setAttribute("href", "#");
		var stag = HtmlDecode(Trim(tag));
		Aobj.onclick = function () {this.blur();swapTag(inputid, stag);return false;};
		Aobj.appendChild(document.createTextNode(stag));
		return Aobj;
	}

	function TagsHandler(event)
	{
		var eObj = get_e_src(event);
		var e = (event||window.event);
		var iTagSpanName = eObj.getAttribute(_tagIName);
		var iTagText = " " + Trim(eObj.value) + " ";
		UpdateSelectTag(iTagSpanName, iTagText);
		if (e.keyCode == 13) return false;
	}

	function swapTag(inputid, tag)
	{
		var inputObj = gid(inputid);
		if (!inputObj) return;
		var iTagSpanName = inputObj.getAttribute(_tagIName);
		var TagIn = false;
		var iTagArray = Trim(inputObj.value).split(" ");
		if (Trim(iTagArray[0]) == "") iTagArray.splice(0,1);
		for (var t = 0; t < iTagArray.length;t++)
		{
			if (iTagArray[t].toLowerCase() == tag.toLowerCase())
			{
				iTagArray.splice(t,1);
				selectTag(iTagSpanName, tag, false);
				TagIn = true;
				t-=1;
			}
		}
		if (!TagIn)
		{
			iTagArray.push(tag);
			selectTag(iTagSpanName, tag, true);
		}
		var newTag = iTagArray.join(" ");
		inputObj.value = (newTag.length > 0)?newTag + " ":newTag;
	}

	function selectTag(spanids, tag, sel)
	{
		var spanid = spanids.toString().split(",");
		for(s in spanid)
		{
			var sObj = gid(_tagFid + spanid[s]);
			if (sObj)
			{
				var sTags = sObj.getAttribute(_tagSName).toString().split(",");
				var sTagObj = sObj.getElementsByTagName("a");
				for (t in sTags)
				{
					if (sTagObj[t])
					{
						if (sTagObj[t].className)
						{
							if (HtmlDecode(sTags[t].toLowerCase()) == tag.toLowerCase())
							{
								if (sel)
								{
									sTagObj[t].className = "tagBH";
								}
								else
								{
									sTagObj[t].className = "tagB";
								}
							}
						}
					}
				}
			}
		}
	}

	function UpdateSelectTag(spanids, tags)
	{
		var spanid = spanids.toString().split(",");
		for(s in spanid)
		{
			var sObj = gid(_tagFid + spanid[s]);
			if (sObj)
			{
				var sTags = sObj.getAttribute(_tagSName).toString().split(",");
				var sTagObj = sObj.getElementsByTagName("a");
				tags = tags.toLowerCase();
				for (t in sTags)
				{
					if (sTagObj[t])
					{
						if (sTagObj[t].className)
						{
							if (tags.indexOf(HtmlDecode(" " + sTags[t].toLowerCase() + " ")) >= 0)
							{
								sTagObj[t].className = "tagBH";
							}
							else
							{
								sTagObj[t].className = "tagB";
							}
						}
					}
				}
			}
		}
	}