﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="linkmanadd.aspx.cs" Inherits="YCHR.Web.newhr.linkmanadd" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title><%=page_actname %>-<%=config.sitename %></title>
<link rel="stylesheet" type="text/css" href="<%=config.templatetheme%>/css/member.css" />
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.js"></script>
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.validate.min.js"></script>
<script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.form.js"></script>
<script type="text/javascript">
         $(document).ready(function () {
             $("#form1").validate({
                 success: function (label) {
                     label.text(" ").addClass("success")
                 },
                 rules: {
                     linkname: { required: true }, address: { required: true },
                     mobile: { isMobile: true },             
                     email: { email: true },
                     telephone: { required: true }, 
                     QQ: { digits: true }
                 },
                 messages: {
                     linkname: { required: "请填写联系人" }, address: { required: "请填写联系地址" },
                     mobile: { isMobile: jQuery.format("请填写正确的手机号码") },
                     email: {  email: jQuery.format("请填写正确的电子邮件") },
                     telephone: { required: "请填写联系电话"},
                     QQ: {   digits: jQuery.format("请正确填写qq号码")}
                 }, errorElement: "span", 
                 errorPlacement: function (error, element) {
                     if (element.is(":radio")) error.appendTo(element.parent().next().next());
                     else if (element.is(":checkbox")) error.appendTo(element.next());
                     else error.appendTo(element.parent())
                 }
             })
         });
        // 电话号码验证
        $.validator.addMethod("phone", function (value, element) {
            var tel = /^(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$/;
            return this.optional(element) || (tel.test(value));
        }, "电话号码格式错误"); 
        // 手机号码验证 
        $.validator.addMethod("isMobile", function (value, element) {
            var length = value.length;
            var mobile = /^(((13[0-9]{1})|(15[0-9]{1}))+\d{8})$/;
            return this.optional(element) || (length == 11 && mobile.test(value));
        }, "请正确填写您的手机号码");
       
    </script>
</head>
<body>
<!-- #include file="include/head.html" -->
<!--nav-->
<div class="navbox">
  <div class="navtab">
    <ul>
      <li><a href="index.aspx">招聘中心</a></li>
      <li class="now"><a href="companyinfomodify.aspx">企业资料</a></li>
      <li><a href="account.aspx">我的账户</a></li>
      <li><a href="server_buy.aspx">增值服务</a></li>
      <li><a href="/resume" target="_blank">最新人才库</a></li>
      <li class="search"><a href="resumesearch.aspx">简历搜索</a></li>
      <li class="add"><a href="addjobs.aspx">发布职位</a></li>
    </ul>
  </div>
</div>
<div class="clear"> </div>
<!--content-->
<div class="box">
  <!--menu-->
  <div class="mb_menu">
    <dl>
      <dt class="m1"><a href="javascript:void(0);">我的资料</a></dt>
        <dd> <a href="companyinfomodify.aspx">基本资料</a></dd>
        <dd> <a href="CompanyLicence.aspx">营业执照</a></dd>
        <dd> <a href="Companylogo.aspx">企业标志</a></dd>
        <dd> <a href="Companyphoto.aspx">企业相册</a></dd>
        <dd> <a href="linkman.aspx" class="now">联系人管理</a></dd>
        <dd> <a href="baidumap.aspx">电子地图</a></dd>
        <dd> <a href="passwordmod.aspx">密码修改</a></dd>
    </dl>
    <div class="ad200"> <img src="<%=config.templatetheme%>/images/member/ad2.gif" width="198" height="70" alt="ad2" /></div>
  </div>
  <!--right-->
  <div class="navmbs"> 您的位置： <a href="/">网站首页</a> > <a href="/hr">招聘中心</a> > 联系人管理
    > </div>
  <div class="mbbox_r">
    <div class="tagT">
      <ul>
        <li><a href="companyinfomodify.aspx">基本资料</a></li>
        <li><a href="CompanyLicence.aspx">营业执照</a></li>
        <li><a href="Companylogo.aspx">企业标志</a></li>
        <li class="cu"><a href="linkman.aspx">联系人管理</a></li>
        <li><a href="baidumap.aspx">电子地图</a></li>
      </ul>
      <div class="tagTxt">
        <div class="left"> 资料完善度：</div>
        <div class="bar" style="margin-top: 16px;"> <span style="width: <%=getcomplete() %>%;"></span> </div>
        <%=getcomplete() %>%</div>
    </div>
    <div class="clear"> </div>
    <h3> <strong>添加部门联系人</strong></h3>
    <div class="h5px"> </div>
    <div class="h5px"> </div>
    <form id="form1" method="post" name="form1">
      <table width="100%" cellspacing="10" cellpadding="0" border="0">
        <tbody>
         <tr >
            <td width="15%" align="right" class="ft_13"> 部门名称 </td>
            <td width="85%"><input id="department" name="department" type="text" value="<%=f_department %>" class="input250"
                                onmouseover="this.className='input251'" onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13"><font color="#ff3300">*</font> 姓名 </td>
            <td width="85%"><input id="linkname" maxlength="10" name="linkname" tabindex="5" type="text" class="input250"
                                onmouseover="this.className='input251'" value='<%=f_linkname %>' onmouseout="this.className='input250'" />
              <input id="sexMale" class="radio" type="radio" value="1" name="radSex" checked="checked">
              <label for="sexMale">先生</label>
              <input id="sexFemale" class="radio" type="radio" value="2" name="radSex">
              <label for="sexFemale">女士</label></td>
          </tr>

          <tr >
            <td width="15%" align="right" class="ft_13"> 联系人职位 </td>
            <td width="85%"><input id="positionname" name="positionname" type="text" value="<%=f_positionname %>" class="input250"
                                onmouseover="this.className='input251'" onmouseout="this.className='input250'" /></td>
          </tr>
            <tr>
            <td width="15%" align="right" class="ft_13"> 毕业学校 </td>
            <td width="85%"><input id="school" name="school" type="text" value="<%=f_school %>" class="input250"
                                onmouseover="this.className='input251'" onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13"><font color="#ff3300">*</font> 联系地址 </td>
            <td width="85%"><input id="address" name="address" type="text" value="<%=f_address %>" class="input250" onmouseover="this.className='input251'"
                                onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13"><font color="#ff3300">*</font> 联系电话 </td>
            <td width="85%"><input id="telephone" name="telephone" type="text" value="<%=f_tele %>" class="input250" onmouseover="this.className='input251'"
                                onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13"> 传真 </td>
            <td width="85%"><input id="fax" name="fax" type="text" value="<%=f_fax %>" class="input250" onmouseover="this.className='input251'"
                                onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13">手机号码 </td>
            <td width="85%"><input id="mobile" name="mobile" type="text" value="<%=f_mobile %>" class="input250" onmouseover="this.className='input251'"
                                onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13">电子邮件 </td>
            <td width="85%"><input id="email" name="email" type="text" value="<%=f_email %>" class="input250"
                                onmouseover="this.className='input251'" onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%" align="right" class="ft_13"> 在线QQ </td>
            <td width="85%"><input id="QQ" name="QQ" type="text" value="<%=f_qq %>" class="input250" onmouseover="this.className='input251'"
                                onmouseout="this.className='input250'" /></td>
          </tr>
          <tr>
            <td width="15%">&nbsp;</td>
            <td width="85%"><input id="btnsave" class="btn_blue" name="btnsave" type="submit" value="保 存" /></td>
          </tr>
        </tbody>
      </table>
    </form>
    <h3> <strong>已有联系人</strong></h3>
    <table width="88%" border="0" align="center" cellpadding="0" cellspacing="0" class="tab_blue">
      <tr>
           <td width="18%" align="center"><strong>姓名 </strong></td>
          <td width="18%" align="center"><strong>部门</strong></td>
          <td width="23%" align="center"><strong>职位 </strong></td>
          <td width="20%" align="center"><strong>联系电话 </strong></td>
          <td width="21%" align="center"><strong>操作</strong></td>
      </tr>
      <asp:Repeater ID="replist" runat="server" >
        <ItemTemplate>
          <tr>
            <td align="center"><%#Eval("linkname") %> <%#Eval("isdefault").ToString().ToLower() == "true" ? "<span class=\"ft_red\">( 默认)</span>" : ""%></td>
              <td align="center"><%#Eval("department") %></td>
              <td align="center"><%#Eval("positionname") %></td>
              <td align="center"><%#Eval("tele") %></td>
            <td align="center"><a href="linkmanadd.aspx?id=<%#Eval("id")%>">修改</a>| <a href="linkmanadd.aspx?deleid=<%#Eval("id")%>">删除</a></td>
          </tr>
        </ItemTemplate>
      </asp:Repeater>
    </table>
    <br />
    <!--content-->
  </div>
  <div class="clear"> </div>
</div>
<!-- #include file="include/foot.html" -->
</body>
</html>
