﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ResumePersoninfo.aspx.cs"
    Inherits="YCHR.Web.person.ResumePersoninfo" %>

<%@ Register Src="ResumeMenue.ascx" TagName="ResumeMenue" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>简历管理＿个人求职中心_易辰人才招聘系统</title>
    <link rel="stylesheet" type="text/css" href="<%=config.templatetheme%>/css/member.css" />
    <script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.js"></script>
    <script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.validate.min.js"></script>
    <script language="JavaScript" src="<%=config.templatetheme%>/js/jquery.form.js"></script>
    <script type="text/javascript">        $(document).ready(function () {
            $("#form1").validate({
                success: function (label) {
                    label.text(" ").addClass("success")
                },
                rules: {
                    realname: { required: true },
                    birthday: { required: true },
                    registry: { required: true },
                    val_dropworkage: { required: true, isselect: true },
                    val_dropsalary: { required: true, isselect: true },
                    val_dropedu: { required: true, isselect: true },
                    val_dropsituation: { required: true, isselect: true },
                    live: { required: true },
                    graduatetschool: { required: true },
                    bodyheight: { digits: true },
                    mobile: { required: true, isMobile: true },
                    QQ: { digits: true },
                    tele: { phone: true },
                    EduSelect_select: { required: true, isEduSelect: true
                    },
                    situationSelect_select: { required: true, isSituationSelect: true }
                },
                messages: {
                    realname: { required: "请填写您的真实姓名" },
                    birthday: { required: "正确填写出生日期，系统将计算您的年龄" },
                    registry: { required: "户籍所在地不能为空" },
                    val_dropworkage: { required: "请选择工龄", isselect: "请选择工龄" },
                    val_dropsalary: { required: "请选择当年月薪", isselect: "请选择当年月薪" },
                    val_dropedu: { required: "请选择最高学历", isselect: "请选择最高学历" },
                    val_dropsituation: { required: "请选择求职状态", isselect: "请选择求职状态" },
                    live: { required: "请填写居住地" },
                    graduatetschool: { required: "请填写毕业学校" },
                    bodyheight: { required: "身高格式出错" },
                    mobile: { required: "请填写手机号码" },
                    situationSelect_select: { required: "请选择求职状态", isSituationSelect: "请选择求职状态" },
                    QQ: { digits: jQuery.format("请正确填写qq号码") },
                    tele: { phone: jQuery.format("请正确填写电话号码") },
                    EduSelect_select: { required: "请填选择学历" }

                },
                
                errorElement: "span",
                errorPlacement: function (error, element) {
                    if (element.is(":radio")) error.appendTo(element.parent().next().next());
                    else if (element.is(":checkbox")) error.appendTo(element.next());
                    else error.appendTo(element.parent())
                }
            })
        });
        // 电话号码验证
        $.validator.addMethod("phone", function (value, element) {
            var tel = /^(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$/;
            return this.optional(element) || (tel.test($.trim(value)));
        }, "电话号码格式错误");
        // 手机号码验证
        $.validator.addMethod("isMobile", function (value, element) {
            var length = $.trim(value).length;
            var mobile = /^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\d{8})$/;
            return this.optional(element) || (length == 11 && mobile.test($.trim(value)));
        }, "请正确填写您的手机号码");
        // 选择验证
        $.validator.addMethod("isselect", function (value, element) {
            if (value == "" || value == "0" || value == "-1")
                return false
            else
                return true;
        }, "");
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <!--head-->
    <!-- #include file="include/head.html" -->
    <!--nav-->
    <div class="navbox">
        <div class="navtab">
            <ul>
               <li class="now"><a href="index.aspx">求职中心</a></li>
                <li><a href="PersonInfoModify.aspx">个人资料</a></li>
                <li><a href="/news" target="_blank">职场资讯</a></li>
        <li><a href="/jinji" target="_blank">急招职位</a></li>
                <li class="search"><a href="/search/jobsearch.aspx">职位搜索</a></li>
                <li class="add"><a href="resumeList.aspx">发布简历</a></li>
            </ul>
        </div>
    </div>
    <div class="clear">
    </div>
    <!--content-->
    <div class="box">
        <!--menu-->
        <div class="mb_menu">
            <dl>
                <dt class="m1"><a href="javascript:void(0);">我的简历</a></dt>
                <dd>
                    <a class="now" href="resumeList.aspx">简历管理</a></dd>
                <dd>
                    <a href="myletter.aspx">我的求职信</a></dd>
                <dd>
                    <a href="sendresumelist.aspx">外发简历</a></dd>
                <dd>
                    <a href="privateset.aspx">隐私设置</a></dd>
                <dt style="margin-top: 8px" class="m2"><a href="javascript:void(0);">职位搜索</a></dt>
                <dd>
                    <a href="/search/jobsearch.aspx"  target="_blank">职位搜索</a></dd>
                <dt style="margin-top: 8px" class="m3"><a href="javascript:void(0);">我的工作</a></dt>
                <dd class="w98">
                    <a href="applylist.aspx">求职申请</a></dd>
                <dd class="w98">
                    <a href="JobInviteList.aspx">面试通知</a></dd>
                <dd>
                   <a href="attentioncompanylist.aspx">关注的企业</a></dd>
                <dd>
                    <a href="mycollectjob.aspx">搜藏的职位</a></dd>
              
                <dd class="w98">
                    <a href="whodownresume.aspx">谁下载了我的简历</a></dd>
            </dl>
        </div>
        <!--right-->
        <div class="navmbs">
            您的位置： <a href="/">首页</a> > <a href="Index.aspx">求职中心</a> > <a href="resumeList.aspx">
                我的简历</a> > 基本信息</div>
        <div class="mb_infoTip" id="infotip">
            <em><a href="javascript:;" onclick="document.getElementById ('infotip').className='none'">
                关闭</a></em>
            <p>
                ◇ 为确保招聘企业能及时联系到您，我们建议您填写多种联系方式，特别是手机号码!</p>
        </div>
        <div class="mb_box">
            <div class="jlxg_l">
                <h5>
                    <span class="ft_blue ft_14">基本信息</span>
                </h5>
                <table width="100%" cellspacing="1" cellpadding="4" border="0" class="padding3 pad12_blue">
                    <tbody>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>姓名：
                            </td>
                            <td width="85%">
                                <input id="realname" name="realname" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <font color="#ff3300">*</font>性别：
                            </td>
                            <td width="85%">
                                <asp:RadioButtonList ID="sex" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                     <asp:ListItem Selected="True" Value="1"> 男 </asp:ListItem>
                                     <asp:ListItem Value="0"> 女 </asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>出生年月：
                            </td>
                            <td width="85%">
                                <div>
                                    <input id="birthday" class="select_day" name="birthday" onclick="new Calendar().show(this);" tabindex="4" type="text"
                                        value="" runat="server" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                婚姻状况：
                            </td>
                            <td width="85%"><div style="position:relative;z-index:8">
                                <select id="dropmarriage" runat="server" class="select" name="dropmarriage">
                                    <option selected="" value="0">请选择</option>
                                    <option value="1">未婚</option>
                                    <option value="2">已婚</option>
                                    <option value="3">保密</option>
                                </select>
                                <input id="val_dropmarriage" runat="server" name="val_dropmarriage" type="hidden"
                                    value="" /></div>
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>现居地 ：
                            </td>
                            <td width="85%">
                                <input id="live" maxlength="10" name="live" type="text" class="input250" value=""
                                    runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>户籍地 ：
                            </td>
                            <td width="85%">
                                <input id="registry" name="registry" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>教育程度：
                            </td>
                            <td width="85%"><div style="position:relative;z-index:7">
                                <asp:DropDownList ID="dropedu" class="select_arr" runat="server">
                                </asp:DropDownList>
                                <input type="hidden" name="val_dropedu" id="val_dropedu" value="" runat="server" /></div>
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>毕业学校：
                            </td>
                            <td width="85%">
                                <input id="graduatetschool" name="graduatetschool" type="text" value="" class="input250"
                                    runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                身份证：
                            </td>
                            <td width="85%">
                                <input id="idcard" name="idcard" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                身高：
                            </td>
                            <td width="85%">
                                <input id="bodyheight" name="bodyheight" type="text" value="" class="input250" runat="server" style="width:194px"/> cm
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font> 工龄：
                            </td>
                            <td width="85%">
                            <div style="position:relative;z-index:6">
                                <asp:DropDownList ID="dropworkage" runat="server">
                                </asp:DropDownList>
                                <input type="hidden" name="val_dropworkage" id="val_dropworkage" value="" runat="server" />
                            </div></td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                目前月薪：
                            </td>
                            <td width="85%">
                            <div style="position:relative;z-index:5">
                                <asp:DropDownList ID="dropsalary" runat="server">
                                </asp:DropDownList>
                                <input type="hidden" name="val_dropsalary" id="val_dropsalary" value="" runat="server" />
                           </div> </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                <font color="#ff3300">*</font>求职状态：
                            </td>
                            <td width="85%"><div style="position:relative;z-index:4">
                                <select name="dropsituation" id="dropsituation" runat="server">
                                    <option value="" selected="selected">请选择</option>
                                    <option value="1">目前正在找工作</option>
                                    <option value="2">半年内无换工作的计划</option>
                                    <option value="3">一年内无换工作的计划</option>
                                    <option value="4">观望有好的机会再考虑</option>
                                    <option value="5">我暂时不想找工作</option>
                                </select>
                                <input type="hidden" name="val_dropsituation" id="val_dropsituation" value="" runat="server" />
                           </div> </td>
                        </tr>
                           <tr>
                            <td class="ft_13" width="15%" align="right">
                                个人标签：</td>
                            <td width="85%">
                                <asp:CheckBoxList ID="checkboxpersontag" runat="server" RepeatColumns="4" 
                    RepeatDirection="Horizontal"> </asp:CheckBoxList>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div class="h5px">
                </div>
                <h4>
                    <em>(<font color="#ff3300">*</font> 为必填项)</em><strong>联系方式 </strong>
                </h4>
                <div class="h5px">
                </div>
                <table width="100%" cellspacing="1" cellpadding="4" border="0" class="padding3">
                    <tbody>
                     <tr>
                            <td class="ft_13" width="15%" align="right">
                                <font color="#ff3300">*</font>电子邮件：
                            </td>
                            <td width="85%">
                                <input id="email" name="email" type="text" value="" class="input250" runat="server"
                                     /><a href="EmailValidate.aspx" class="a_btn_hui" id="modmail" runat="server">修改</a>
                            </td>
                        </tr>
                        <tr>
                            <td class="ft_13" width="15%" align="right">
                                <font color="#ff3300">*</font>手机号码：
                            </td>
                            <td width="85%">
                                <input id="mobile" name="mobile" type="text" value="" class="input250" runat="server"
                                   /><a href="MobileValidate.aspx" class="a_btn_hui"  id="modphone" runat="server">修改</a>
                                
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                通讯地址：
                            </td>
                            <td width="85%">
                                <input id="address" name="address" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                邮政编码：
                            </td>
                            <td width="85%">
                                <input id="postcode" name="postcode" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                固定电话：
                            </td>
                            <td width="85%">
                                <input id="tele" name="tele" type="text" value="" class="input250" runat="server" />
                                 <span>(请用<i class="ft_red">021-88888888</i>格式填写)</span>
                            </td>
                        </tr>
                       
                        <tr>
                            <td width="20%" align="right">
                                个人主页：
                            </td>
                            <td width="85%">
                                <input id="website" name="website" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">
                                QQ：
                            </td>
                            <td width="85%">
                                <input id="QQ" name="QQ" type="text" value="" class="input250" runat="server" />
                            </td>
                        </tr>
                        <tr>
                            <td width="20%" align="right">&nbsp;
                                
                            </td>
                            <td width="85%">
                                <asp:Button ID="Button1" runat="server" CssClass="btn_set" OnClick="Button1_Click"
                                    Text="保存，下一步" />
                            </td>
                        </tr>
                    </tbody>
                </table>
                <br />
                <div class="h5px">
                </div>
            </div>
            <div class="jlxg_r">
                <uc1:ResumeMenue ID="ResumeMenue1" runat="server" />
            </div>
        </div>
        <div class="clear">
        </div>
        <!--content-->
        <div class="clear">
        </div>
    </div>
    <script type="text/javascript" src="<%=config.templatetheme%>/js/jquery.scrollablecombo.js"></script>
    <script type="text/javascript">
        $(function () {
            $('#dropmarriage').scrollablecombo();
            $('#dropworkage').scrollablecombo();
            $('#dropedu').scrollablecombo();
            $('#dropmarriage').scrollablecombo();
            $('#dropsituation').scrollablecombo();
            $('#dropsalary').scrollablecombo();
        });
         
    </script>    <script language="JavaScript" src="<%=config.templatetheme%>/js/Birthday-Calendar.js"></script>
    <!-- #include file="include/foot.html" -->
    </form>
</body>
</html>
