﻿var BAIDUMAP = {
    map: new Object(),
    setmarker: new Object(),
    markers: new Array(),
    setload: function () {
        showloading(1);
        BAIDUMAP.loadScript("BAIDUMAP.setinit");
    },
    setinit: function () {
        closeloading();
        BAIDUMAP.map = new BMap.Map("map");
        BAIDUMAP.map.addControl(new BMap.NavigationControl());
        BAIDUMAP.map.enableScrollWheelZoom();
        var lat = $("#hiddenmapY").val(); //纬度
        var lng = $("#hiddenmapX").val(); //经度
        //初始化地理位置
        if (lat == 0 || lng == 0) {
            BAIDUMAP.reset();
        } else {
            BAIDUMAP.map.centerAndZoom(new BMap.Point(lng, lat), 16);
            BAIDUMAP.setmarker = new BMap.Marker(new BMap.Point(lng, lat));
            //BAIDUMAP.setmarker.enableDragging();
            BAIDUMAP.setmarker.setAnimation(BMAP_ANIMATION_BOUNCE);
            BAIDUMAP.map.addEventListener("click", function (e) {
                BAIDUMAP.map.removeOverlay(BAIDUMAP.setmarker);
                BAIDUMAP.setmarker.dispose();
                BAIDUMAP.setmarker = new BMap.Marker(new BMap.Point(e.point.lng, e.point.lat));
                BAIDUMAP.setmarker.setAnimation(BMAP_ANIMATION_BOUNCE);
                BAIDUMAP.map.addOverlay(BAIDUMAP.setmarker);
                $("#hiddenmapY").val(e.point.lng);
                $("#hiddenmapX").val(e.point.lat);
            });
            BAIDUMAP.map.addOverlay(BAIDUMAP.setmarker);
        }
    },
    loadScript: function (callback) {
        var script = document.createElement("script");
        script.src = "http://api.map.baidu.com/api?v=1.2&callback=" + callback;
        document.body.appendChild(script);
    },
    showmap: function () {
        BAIDUMAP.loadScript("BAIDUMAP.showmap_forcompany");
    },
    showmap_forcompany: function () {
        BAIDUMAP.map = new BMap.Map("mapshow");
        BAIDUMAP.map.addControl(new BMap.NavigationControl());
        BAIDUMAP.map.enableScrollWheelZoom();

        var lat = $("#hiddenmapX").val(); //纬度
        var lng = $("#hiddenmapY").val(); //经度
        var company_name = $("#companyname").val();
        BAIDUMAP.map.centerAndZoom(new BMap.Point(lng, lat), 16);
        BAIDUMAP.setmarker = new BMap.Marker(new BMap.Point(lng, lat));
        BAIDUMAP.setmarker.setAnimation(BMAP_ANIMATION_BOUNCE);
        BAIDUMAP.map.addOverlay(BAIDUMAP.setmarker);
        var opts = {
            width: 380,     // 信息窗口宽度
            height: 130,     // 信息窗口高度
            title: (company_name)  // 信息窗口标题
        }
        var infoWindow = new BMap.InfoWindow($("#companyinfo").html(), opts);  // 创建信息窗口对象
        BAIDUMAP.setmarker.addEventListener("click", function () {
            this.openInfoWindow(infoWindow);
        });
        BAIDUMAP.setmarker.openInfoWindow(infoWindow);
    },
    searchinit: function () {
        BAIDUMAP.loadScript("BAIDUMAP.searchok");
    },
    searchok: function () {
        BAIDUMAP.map = new BMap.Map("map");
        BAIDUMAP.map.addControl(new BMap.NavigationControl());
        BAIDUMAP.map.enableScrollWheelZoom();

        var lat = $("#hiddenmapX").val(); //纬度
        var lng = $("#hiddenmapY").val(); //经度

        //先要固定中心位置
        if (lat == 0 || lng == 0) {
            var citycode = parseInt($("#btn_selectcity").attr("_v"));
            if (citycode == 0) {
                citycode = 33030000;
                $("#btn_selectcity").attr("_v", citycode);
            }
            var cityname = areaData[citycode];
            $("#btn_selectcity").val(cityname);
            var myGeo = new BMap.Geocoder();
            myGeo.getPoint("", function (point) {
                if (point) {
                    BAIDUMAP.map.removeOverlay(BAIDUMAP.setmarker);
                    BAIDUMAP.map.centerAndZoom(point, 13);
                    BAIDUMAP.setmarker = new BMap.Marker(point);
                    $("#hiddenmapY").val(point.lng);
                    $("#hiddenmapX").val(point.lat);
                    //BAIDUMAP.map.addOverlay(BAIDUMAP.setmarker);
                }
            }, cityname);
        } else {
            BAIDUMAP.map.centerAndZoom(new BMap.Point(lng, lat), 13);
        }
        
    }
}