﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="caseedit_lsfz.aspx.cs" Inherits="LawOA.Web.lawoa.caseedit_lsfz" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
  <script src="validate/jquery.validate.min.js"></script>
 <script src="validate/messages_zh.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').endsWith("casecatsel.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small><%= paget == "add"?"新增":"修改" %>案件 - 专项法律服务</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">案件管理</li>
      </ol>
    </section>
<section class="content container-fluid"> 
<form name="caseForm" action="?action=save&t=<%= paget %>&cid=<%= pageid %>&catid=<%= pagecatid %>" method="post" enctype="multipart/form-data">
<div class="box box-body casepage">
<!-- 注意如下一个ul为一个段落 -->
<ul>
<li>事项：<span class="text-red"> * </span> <input type="text" name="brief" class="myinput" style="width:50%;" placeholder="" value="<%= pageInfo.brief %>" required></li>
<li>
主办律师：<span class="text-red"> * </span> <select name="lawyerid" class="myinput"<%= loginLawyer.userlevel < 10 ? " disabled='disabled'":"" %> required>
<option value="">请选择</option>
<%= OutputLawyerOptions(pageInfo.lawyerid) %>
</select> 
&nbsp;&nbsp;&nbsp;
协办律师：<select name="colawyerid" class="myinput">
<option value="">请选择</option>
<%= OutputLawyerOptions(pageInfo.colawyerid) %>
</select>
</li>

<li>委托客户：<span class="text-red"> * </span> 
<select name="clientid" class="myinput" style="width:50%">
 <option value="-1">请选择</option>
 <%= OutputClientOptions(pageInfo.clientid) %>
</select>或
<input type="text" class="myinput" placeholder="" value="<%= pageInfo.clientname %>" name="clientname">
</li>
<li>联系人：<input type="text" class="myinput" placeholder="" value="<%= extInfo.lianxiren %>" name="lianxiren"></li>
</ul>

<ul>
<li>
案件状态：<span class="text-red"> * </span><select name="stateid" class="myinput">
 <%= OutputStateOptions(pageInfo.stateid,pagecatid) %>
</select>
</li>
</ul>

<ul>
<li>收案日期：<select name="dateshouan_year" class="myinput"><%= EchoOptions("year",extInfo.dateshouan.Year)%></select>年 <select name="dateshouan_month" class="myinput"><%= EchoOptions("month",extInfo.dateshouan.Month)%></select>月 <select name="dateshouan_day" class="myinput"><%= EchoOptions("day",extInfo.dateshouan.Day)%></select>日</li>
</ul>

<ul>
<li>结案日期：<select name="datejiean_year" class="myinput"><%= EchoOptions("year",extInfo.datejiean.Year)%></select>年 <select name="datejiean_month" class="myinput"><%= EchoOptions("month",extInfo.datejiean.Month)%></select>月 <select name="datejiean_day" class="myinput"><%= EchoOptions("day",extInfo.datejiean.Day)%></select>日</li>
<li>归档日期：<select name="dateguidang_year" class="myinput"><%= EchoOptions("year",pageInfo.dateguidang.Year)%></select>年 <select name="dateguidang_month" class="myinput"><%= EchoOptions("month",pageInfo.dateguidang.Month)%></select>月 <select name="dateguidang_day" class="myinput"><%= EchoOptions("day",pageInfo.dateguidang.Day)%></select>日</li>
</ul>

<ul>
<li>服务内容：
<textarea class="myinput" style="width:50%;" name="summary"><%= pageInfo.summary %></textarea>
</li>
</ul>

<ul>
<li>律师费金额：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="0" value="<%= extInfo.lvshifei %>" size="10" name="lvshifei">元 &nbsp;&nbsp;&nbsp; 办案费金额：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="0" value="<%= extInfo.bananfei %>" size="10" name="bananfei">元</li>
<li>低于收费或不收费理由：<input type="text" class="myinput" placeholder="" value="<%= extInfo.unpaidreason %>" name="unpaidreason"></li>
</ul>

<ul>
<li>主办法官：<input type="text" class="myinput" placeholder="" value="<%= extInfo.zhubanfaguan %>" name="zhubanfaguan"></li>
<li>议庭成员：<input type="text" class="myinput" placeholder="" value="<%= extInfo.yitingchengyuan %>" name="yitingchengyuan"></li>
<li>书记员：<input type="text" class="myinput" placeholder="" value="<%= extInfo.shujiyuan %>" name="shujiyuan"></li>
</ul>

<ul>
<li>备注：<input type="file" name="remarkfile"> <%= extInfo.remarkfile == "" ? "" : "(已传文件，需修改请重新上传)" %></li>
</ul>

<p style="text-align:center">
<button type="submit" class="btn btn-danger"><i class="fa fa-save"></i> 保存案件</button>
</p>

</div>
</form>

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/bootstrap-datepicker.js"></script>
<script>  
 $(function () {
	$('.datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
    })
    function case_conflict_search(Flag) {
        window.open("caseconflictsearch.aspx?action=ctso&ctopposingpartyname=" + escape(Flag.value));
        return true;
    }

    $().ready(function () {
        $("#caseForm").validate();
    });
</script>
<script src="images/demo.js"></script>
</body>
</html>
