﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="caseedit_ms.aspx.cs" Inherits="LawOA.Web.lawoa.caseedit_ms" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
<script src="validate/jquery.validate.min.js"></script>
 <script src="validate/messages_zh.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').endsWith("casecatsel.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small><%= paget == "add"?"新增":"修改" %>案件 - 民事类</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">案件管理</li>
      </ol>
    </section>
<section class="content container-fluid"> 
<form name="caseForm" action="?action=save&t=<%= paget %>&cid=<%= pageid %>&catid=<%= pagecatid %>" method="post" enctype="multipart/form-data">
<div class="box box-body casepage">
<!-- 注意如下一个ul为一个段落 -->
<ul>
<li>案由：<span class="text-red"> * </span> <input type="text" name="brief" class="myinput" style="width:50%;" placeholder="" value="<%= pageInfo.brief %>" required></li>
<li>
主办律师：<span class="text-red"> * </span> <select name="lawyerid" class="myinput"<%= loginLawyer.userlevel < 10 ? " disabled='disabled'":"" %> required>
<option value="">请选择</option>
<%= OutputLawyerOptions(pageInfo.lawyerid) %>
</select> 
&nbsp;&nbsp;&nbsp;
协办律师：<select name="colawyerid" class="myinput">
<option value="">请选择</option>
<%= OutputLawyerOptions(pageInfo.colawyerid) %>
</select>
</li>

<li>委托客户：<span class="text-red"> * </span> 
<select name="clientid" class="myinput" style="width:50%">
 <option value="-1">请选择</option>
 <%= OutputClientOptions(pageInfo.clientid) %>
</select>或
<input type="text" class="myinput" placeholder="" value="<%= pageInfo.clientname %>" name="clientname">
</li>
<li>对方当事人：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="" value="<%= pageInfo.opposingpartyname %>" style="width:40%;" name="opposingpartyname"> <a href="javascript:void(0)" onclick="case_conflict_search(caseForm.opposingpartyname)">冲突检索</a></li>
<li>对方联系人：<input type="text" class="myinput" placeholder="" value="<%= extInfo.opposingpartylinkman %>" name="opposingpartylinkman"> 联系电话：<input type="text" class="myinput" placeholder="" value="<%= extInfo.opposingpartylinktel %>" name="opposingpartylinktel"></li>
</ul>

<ul> 
<li>法院案号：<input type="text" class="myinput" placeholder="" value="<%= extInfo.fayuancaseno %>" name="fayuancaseno"></li>
</ul>

<ul>
<li>
案件状态：<span class="text-red"> * </span><select name="stateid" class="myinput">
 <%= OutputStateOptions(pageInfo.stateid,pagecatid) %>
</select>
</li>

<li>
案件审级：<span class="text-red"> * </span>
<input type="text" class="myinput" placeholder="" value="<%= extInfo.stageyishensm %>" name="stageyishensm" style="width:80px">
<input type="checkbox" id="yishen" name="stagedesc" class="myradiobox" value="一审"<%= extInfo.stagedesc.IndexOf("一审")>=0 ? " checked='checked'" :"" %>  /> <label for="yishen"></label> 一审 &nbsp;

<input type="text" class="myinput" placeholder="" value="<%= extInfo.stageershensm %>" name="stageershensm" style="width:80px">
<input type="checkbox" id="ershen" name="stagedesc" class="myradiobox" value="二审"<%= extInfo.stagedesc.IndexOf("二审")>=0 ? " checked='checked'" :"" %>  /> <label for="ershen"></label> 二审 &nbsp;

<input type="text" class="myinput" placeholder="" value="<%= extInfo.stagezaishensm %>" name="stagezaishensm" style="width:80px">
<input type="checkbox" id="zaishen" name="stagedesc" class="myradiobox" value="再审"<%= extInfo.stagedesc.IndexOf("再审")>=0 ? " checked='checked'" :"" %>  /> <label for="zaishen"></label> 再审&nbsp;

<input type="text" class="myinput" placeholder="" value="<%= extInfo.stageldrszcsm %>" name="stageldrszcsm" style="width:80px">
<input type="checkbox" id="ldrszc" name="stagedesc" class="myradiobox" value="劳动人事仲裁"<%= extInfo.stagedesc.IndexOf("劳动人事仲裁")>=0 ? " checked='checked'" :"" %> /> <label for="ldrszc"></label>劳动人事仲裁 &nbsp;

<input type="text" class="myinput" placeholder="" value="<%= extInfo.stagesssm %>" name="stagesssm" style="width:80px">
<input type="checkbox" id="shangshizhongcai" name="stagedesc" class="myradiobox" value="商事仲裁"<%= extInfo.stagedesc.IndexOf("商事仲裁")>=0 ? " checked='checked'" :"" %> /> <label for="shangshizhongcai"></label>商事仲裁 &nbsp;

<input type="text" class="myinput" placeholder="" value="<%= extInfo.stagezxsm %>" name="stagezxsm" style="width:80px">
<input type="checkbox" id="zhixing" name="stagedesc" class="myradiobox" value="执行"<%= extInfo.stagedesc.IndexOf("执行")>=0 ? " checked='checked'" :"" %>  /> <label for="zhixing"></label> 执行
</li>
<li>案件审级备注：<input type="text" class="myinput" placeholder="" value="<%= extInfo.stageremark %>" name="stageremark" style="width:50%"></li>
<li>
委托人角色：<span class="text-red"> * </span><select name="clientroleid" class="myinput">
 <%= OutputRoleOptions(extInfo.clientrole,pagecatid) %>
</select>
</li>
</ul>

<ul>
<li>收案日期：<select name="dateshouan_year" class="myinput"><%= EchoOptions("year",extInfo.dateshouan.Year)%></select>年 <select name="dateshouan_month" class="myinput"><%= EchoOptions("month",extInfo.dateshouan.Month)%></select>月 <select name="dateshouan_day" class="myinput"><%= EchoOptions("day",extInfo.dateshouan.Day)%></select>日</li>
</ul>

<ul>
<li>立案日期：<select name="datelian_year" class="myinput"><%= EchoOptions("year",extInfo.datelian.Year)%></select>年 <select name="datelian_month" class="myinput"><%= EchoOptions("month",extInfo.datelian.Month)%></select>月 <select name="datelian_day" class="myinput"><%= EchoOptions("day",extInfo.datelian.Day)%></select>日</li>
<li>举证日期：<select name="datejuzheng_year" class="myinput"><%= EchoOptions("year",extInfo.datejuzheng.Year)%></select>年 <select name="datejuzheng_month" class="myinput"><%= EchoOptions("month",extInfo.datejuzheng.Month)%></select>月 <select name="datejuzheng_day" class="myinput"><%= EchoOptions("day",extInfo.datejuzheng.Day)%></select>日 <select name="datejuzheng_hour" class="myinput"><%= EchoOptions("hour",extInfo.datejuzheng.Hour)%></select>时 <select name="datejuzheng_minute" class="myinput"><%= EchoOptions("",extInfo.datejuzheng.Minute)%></select>分</li>
<li>开庭日期：<select name="datekaiting_year" class="myinput"><%= EchoOptions("year",extInfo.datekaiting.Year)%></select>年 <select name="datekaiting_month" class="myinput"><%= EchoOptions("month",extInfo.datekaiting.Month)%></select>月 <select name="datekaiting_day" class="myinput"><%= EchoOptions("day",extInfo.datekaiting.Day)%></select>日 <select name="datekaiting_hour" class="myinput"><%= EchoOptions("hour",extInfo.datekaiting.Hour)%></select>时 <select name="datekaiting_minute" class="myinput"><%= EchoOptions("",extInfo.datekaiting.Minute)%></select>分</li>
<li>裁判日期：<select name="datecaipan_year" class="myinput"><%= EchoOptions("year",extInfo.datecaipan.Year)%></select>年 <select name="datecaipan_month" class="myinput"><%= EchoOptions("month",extInfo.datecaipan.Month)%></select>月 <select name="datecaipan_day" class="myinput"><%= EchoOptions("day",extInfo.datecaipan.Day)%></select>日</li>

<li>领取判决日期：<select name="lingqupanjuedate_year" class="myinput"><%= EchoOptions("year",extInfo.lingqupanjuedate.Year)%></select>年 <select name="lingqupanjuedate_month" class="myinput"><%= EchoOptions("month",extInfo.lingqupanjuedate.Month)%></select>月 <select name="lingqupanjuedate_day" class="myinput"><%= EchoOptions("day",extInfo.lingqupanjuedate.Day)%></select>日</li>
<li>领取裁定日期：<select name="lingqucaidingdate_year" class="myinput"><%= EchoOptions("year",extInfo.lingqucaidingdate.Year)%></select>年 <select name="lingqucaidingdate_month" class="myinput"><%= EchoOptions("month",extInfo.lingqucaidingdate.Month)%></select>月 <select name="lingqucaidingdate_day" class="myinput"><%= EchoOptions("day",extInfo.lingqucaidingdate.Day)%></select>日</li>

<li>结案日期：<select name="datejiean_year" class="myinput"><%= EchoOptions("year",extInfo.datejiean.Year)%></select>年 <select name="datejiean_month" class="myinput"><%= EchoOptions("month",extInfo.datejiean.Month)%></select>月 <select name="datejiean_day" class="myinput"><%= EchoOptions("day",extInfo.datelian.Day)%></select>日</li>
<li>归档日期：<select name="dateguidang_year" class="myinput"><%= EchoOptions("year",pageInfo.dateguidang.Year)%></select>年 <select name="dateguidang_month" class="myinput"><%= EchoOptions("month",pageInfo.dateguidang.Month)%></select>月 <select name="dateguidang_day" class="myinput"><%= EchoOptions("day",pageInfo.dateguidang.Day)%></select>日</li>
</ul>

<ul>
<li>案件摘要：<span class="text-red"> * </span>
<textarea class="myinput" style="width:50%;" name="summary" required><%= pageInfo.summary %></textarea>
</li>
</ul>

<ul>
<li>冻结银行存款:<input type="text" class="myinput" placeholder="" value="<%= extInfo.blockdeposits %>" size="10" name="blockdeposits">&nbsp;&nbsp;
   起止日期：<select name="blockdepositsstartdate_year" class="myinput"><%= EchoOptions("year",extInfo.blockdepositsstartdate.Year) %></select>年<select name="blockdepositsstartdate_month" class="myinput"><%= EchoOptions("month",extInfo.blockdepositsstartdate.Month) %></select>月 <select name="blockdepositsstartdate_day" class="myinput"><%= EchoOptions("day",extInfo.blockdepositsstartdate.Day) %></select>日--<select name="blockdepositsenddate_year" class="myinput"><%= EchoOptions("year",extInfo.blockdepositsenddate.Year) %></select>年<select name="blockdepositsenddate_month" class="myinput"><%= EchoOptions("month",extInfo.blockdepositsenddate.Month) %></select>月 <select name="blockdepositsenddate_day" class="myinput"><%= EchoOptions("day",extInfo.blockdepositsenddate.Day) %></select>日
</li>
<li>查封扣押动产:<input type="text" class="myinput" placeholder="" value="<%= extInfo.detainmovable %>" size="10" name="detainmovable">&nbsp;&nbsp;
   起止日期：<select name="detainmovablestartdate_year" class="myinput"><%= EchoOptions("year",extInfo.detainmovablestartdate.Year) %></select>年<select name="detainmovablestartdate_month" class="myinput"><%= EchoOptions("month",extInfo.detainmovablestartdate.Month) %></select>月 <select name="detainmovablestartdate_day" class="myinput"><%= EchoOptions("day",extInfo.detainmovablestartdate.Day) %></select>日--<select name="detainmovableenddate_year" class="myinput"><%= EchoOptions("year",extInfo.detainmovableenddate.Year) %></select>年<select name="detainmovableenddate_month" class="myinput"><%= EchoOptions("month",extInfo.detainmovableenddate.Month) %></select>月 <select name="detainmovableenddate_day" class="myinput"><%= EchoOptions("day",extInfo.detainmovableenddate.Day) %></select>日
</li>
<li>查封不动产:<input type="text" class="myinput" placeholder="" value="<%= extInfo.detainrealty %>" size="10" name="detainrealty">&nbsp;&nbsp;
   起止日期：<select name="detainrealtystartdate_year" class="myinput"><%= EchoOptions("year",extInfo.detainrealtystartdate.Year) %></select>年<select name="detainrealtystartdate_month" class="myinput"><%= EchoOptions("month",extInfo.detainrealtystartdate.Month) %></select>月 <select name="detainrealtystartdate_day" class="myinput"><%= EchoOptions("day",extInfo.detainrealtystartdate.Day) %></select>日--<select name="detainrealtyenddate_year" class="myinput"><%= EchoOptions("year",extInfo.detainrealtyenddate.Year) %></select>年<select name="detainrealtyenddate_month" class="myinput"><%= EchoOptions("month",extInfo.detainrealtyenddate.Month) %></select>月 <select name="detainrealtyenddate_day" class="myinput"><%= EchoOptions("day",extInfo.detainrealtyenddate.Day) %></select>日
</li>
</ul>

<ul>
<li>一般代理/风险代理：<span class="text-red"> * </span><select name="modeofpayment" class="myinput">
<option>付款方式</option>
<option value="0"<%= extInfo.modeofpayment==0?" selected='selected'":"" %>>一般代理</option>
<option value="1"<%= extInfo.modeofpayment==1?" selected='selected'":"" %>>风险代理</option>
</select></li>

<li>案件标的额：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="0" value="<%= extInfo.biaodie %>" size="10" name="biaodie">元 &nbsp;&nbsp;&nbsp; 律师费金额：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="0" value="<%= extInfo.lvshifei %>" size="10" name="lvshifei">元 &nbsp;&nbsp;&nbsp; 办案费金额：<span class="text-red"> * </span> <input type="text" class="myinput" placeholder="0" value="<%= extInfo.bananfei %>" size="10" name="bananfei">元</li>
<li>低于收费或不收费理由：<input type="text" class="myinput" placeholder="" value="<%= extInfo.unpaidreason %>" name="unpaidreason"></li>
<li>风险代理律师费计付标准(250字内)：<textarea class="myinput" style="width:40%;" name="fxdllsfjfbz"><%= extInfo.fxdllsfjfbz %></textarea></li>
</ul>

<ul>
<li>主办法官：<input type="text" class="myinput" placeholder="" value="<%= extInfo.zhubanfaguan %>" name="zhubanfaguan"></li>
<li>议庭成员：<input type="text" class="myinput" placeholder="" value="<%= extInfo.yitingchengyuan %>" name="yitingchengyuan"></li>
<li>书记员：<input type="text" class="myinput" placeholder="" value="<%= extInfo.shujiyuan %>" name="shujiyuan"></li>
</ul>

<ul>
<li>代理词内容：<input type="file" name="dailicifile"> <%= extInfo.dailicifile == "" ? "" : "(已传文件，需修改请重新上传)" %></li>
<li>起诉书内容：<input type="file" name="qisushufile"> <%= extInfo.qisushufile == "" ? "" : "(已传文件，需修改请重新上传)" %></li>
<li>其他法律文书：<input type="file" name="otherlawfile"> <%= extInfo.otherlawfile == "" ? "" : "(已传文件，需修改请重新上传)" %></li>
</ul>

<p style="text-align:center">
<button type="submit" class="btn btn-danger"><i class="fa fa-save"></i> 保存案件</button>
</p>

</div>
</form>

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/bootstrap-datepicker.js"></script>
<script>  
 $(function () {
	$('.datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
    })
    function case_conflict_search(Flag) {
        window.open("caseconflictsearch.aspx?action=ctso&ctopposingpartyname=" + escape(Flag.value));
        return true;
    }
    $().ready(function () {
        $("#caseForm").validate();
    });
</script>
<script src="images/demo.js"></script>
</body>
</html>
