﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="caselist.aspx.cs" Inherits="LawOA.Web.lawoa.caselist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
         <%= OutputLeftMenu() %>
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         var ahref = $(this).attr('href');
         var apath = window.location.pathname.replace("/lawoa/","") + window.location.search;
         if(ahref == apath) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>案件管理</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">案件管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      
<div class="box box-body"<%= GetRH("vt") == "so" ? "":" style='display:none'" %>>
<table width="100%">
  <tbody>
    <tr>
      <td style="line-height:220%;">
<form action="caselist.aspx" method="get">
<input type="hidden" name="action" value="search" />
<input type="hidden" name="vt" value="so" />
案件编号：<input type="text" class="myinputso" name="serialnumber" value="" size="16">

<select class="myinputso" name="lawyerid">
  <option value="-1">律师</option>
  <%= OutputLawyerOptions(0) %>
</select>

<select class="myinputso" name="catid">
  <option value="-1">案件分类</option>
  <%= OutputCateOptions(-1) %>
</select>

<select class="myinputso" name="stateid">
  <option value="-1">案件状态</option>
  <%= OutputStateOptions(-1,-1) %>
</select>
<br />
<select class="myinputso" name="clientid" style="display:none">
  <option value="-1">委托客户</option>
  <%= OutputClientOptions(-1) %>
</select>
 当事人：<input type="text" class="myinputso" value="" size="25" name="clientname">
 对方当事人：<input type="text" class="myinputso" value="" size="25" name="opposingpartyname">
<br />
创建日期：从 <input type="text" class="myinputso datepicker" value="" size="16" name="dateshouanstart"> 至 <input type="text" class="myinputso datepicker" value="" size="16" name="dateshouanend"> 
<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> 查询</button>
</form>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="box box-body"<%= GetRH("vt") == "ct" ? "":" style='display:none'" %>>
<table width="100%">
  <tbody>
    <tr>
      <td style="line-height:220%;">
<form action="caselist.aspx" method="get">
<input type="hidden" name="action" value="ctso" />
<input type="hidden" name="vt" value="ct" />
 对方当事人：<input type="text" class="myinputso" value="" size="16" name="ctopposingpartyname"> 
<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> 查询</button>
</form>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="box box-body"<%= GetRH("vt") == "sp" ? "":" style='display:none'" %>>
<div class="chartclass">
<a href="caselist.aspx?action=viewsp&vt=sp&t=dsp" class="btn btn-default">待审批案件</a>
<a href="caselist.aspx?action=viewsp&vt=sp&t=brsp" class="btn btn-default">本人已审批案件</a>
<a href="caselist.aspx?action=viewsp&vt=sp&t=qtrsp" class="btn btn-default">其他人已审批案件</a>
<a href="caselist.aspx?action=viewsp&vt=sp&t=brfp" class="btn btn-default">本人已否批案件</a>
<a href="caselist.aspx?action=viewsp&vt=sp&t=qtrfp" class="btn btn-default">其他人已否批案件</a>
</div>
</div>　

<div class="box">
<div class="box-body" style="text-align:center;">
请点击表头项进行排序 
</div>
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                   <th style="text-align:center">操作</th>
                    <th><a href="<%= GetThUrl("cid") %>">ID号</a></th>
                    <th><a href="<%= GetThUrl("serialnumber") %>">案件编号</a></th>
                    <th><a href="<%= GetThUrl("brief") %>">案由</a></th>
                    <th><a href="<%= GetThUrl("lawyerid") %>">主办律师</a></th>
                    <th><a href="<%= GetThUrl("colawyerid") %>">协办律师</a></th>
                    <th><a href="<%= GetThUrl("clientid") %>">委托客户</a></th>
                    <th><a href="<%= GetThUrl("opposingpartylinkman") %>">对方当事人</a></th>
                    <th><a href="<%= GetThUrl("stateid") %>">案件状态</a></th>
                    <th><a href="<%= GetThUrl("catid") %>">案件分类</a></th>
                    <th><a href="<%= GetThUrl("createtime") %>">创建时间</a></th>
                  </tr>
                  </thead>
                  <tbody>
<% foreach (var info in lawCaseList)
    { %>
                  <tr>
                  <td align="left" valign="middle" class="tablenowrap" <%= GetRH("vt") == "sp" ? " style='display:none'":"" %>>
<a class="btn btn-primary btn-xs" href="caseview_<%= CaseCatFirstLetter(GetCateName(info.catid)) %>.aspx?cid=<%= info.cid %>"><i class="fa fa-hand-pointer-o"></i> 查看</a>
<a class="btn btn-primary btn-xs" href="casedoc.aspx?cid=<%= info.cid %>"><i class="fa fa-hand-pointer-o"></i> 附件</a>
<a class="btn btn-info btn-xs" href="caseedit_<%= CaseCatFirstLetter(GetCateName(info.catid)) %>.aspx?t=edit&catid=<%= info.catid %>&cid=<%= info.cid %>"><i class="fa fa-edit"></i> 编辑</a> 
<a class="btn btn-danger btn-xs"  href="caselist.aspx?action=del&cid=<%= info.cid %>" onclick="return confirm('确认删除？')"<%= loginLawyer.userlevel<10?" style='display:none'":"" %>><i class="fa fa-trash-o"></i> 删除</a>
                    </td>
                    <td align="left" valign="middle" class="tablenowrap" <%= GetRH("vt") == "sp" ? "":" style='display:none'" %>>
                        <% if (GetRH("t") == "dsp")
                            { %>
                       <a class="btn btn-success btn-xs" href="caseyesno.aspx?action=tgsp&cid=<%= info.cid %>" onclick="return confirm('确认通过审批？')"><i class="fa fa-check"></i> 通过审批</a>
                       <a class="btn btn-warning btn-xs" href="caseyesno.aspx?cid=<%= info.cid %>" data-toggle="modal"  data-target="#modal"><i class="fa fa-remove"></i> 否决审批</a>
                        <% } %>
                    </td>
                    <td><%= info.cid %></td>
                    <td><%= info.serialnumber %></td>
                    <td><%= info.brief %></td>
                    <td><%= GetLawyerName(info.lawyerid) %></td>
                    <td><%= GetLawyerName(info.colawyerid) %></td>
                    <td><%= GetClientName(info) %></td>
                    <td><%= info.opposingpartyname %></td>
                    <td><%= GetStateName(info.stateid) %></td>
                    <td><%= GetCateName(info.catid) %></td>
                    <td><%= info.createtime.ToString("yyyy-MM-dd") %></td>
                  </tr>
<% } %>                  
                  </tbody>
                </table>
              </div>
            </div>
            <div class="box-footer clearfix">
              <%= PagerHtml %>
            </div>
        </div>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
    <div class="modal" id="modal">
        <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
            <div class="modal-content"></div>
        </div>
    </div>

<script src="images/adminlte.min.js"></script>
<script src="images/daterangepicker.js"></script>
<script src="images/bootstrap-datepicker.js"></script>
<script>  
    $(function () {		
	$('.datepicker').datepicker({
        autoclose: true,
        format:'yyyy-mm-dd'
    })
  })
</script>
<script src="images/demo.js"></script>
</body>
</html>
