﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="caseview_flgw.aspx.cs" Inherits="LawOA.Web.lawoa.caseview_flgw" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
<header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
$(function(){
    $(".sidebar-menu li").click(function() {
        $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
        $(this).addClass('active');//添加当前元素的样式
    });
});

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         var ahref = $(this).attr('href');
         var apath = "caselist.aspx"; //window.location.pathname.replace("/lawoa/","") + window.location.search;
         if(ahref == apath) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>查看案件详细-法律顾问类</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">查看案件</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body casepage">
<!-- 注意如下一个ul为一个段落 -->
<ul>
<li><strong>案件ID：</strong><%= pageInfo.cid %> &nbsp;&nbsp;&nbsp; <strong>案件编号：</strong><%= pageInfo.serialnumber %></li>
<li><strong>案由：</strong><%= pageInfo.brief %></li>
<li><strong>分类：</strong><%= currentCate.catname %></li>
<li>
<strong>主办律师：</strong><%= GetLawyerName(pageInfo.lawyerid) %>
&nbsp;&nbsp;&nbsp;
<strong>协办律师：</strong><%= GetLawyerName(pageInfo.colawyerid) %>
&nbsp;&nbsp;&nbsp;
<strong>委托客户：</strong><%= pageInfo.clientid == -1 ? pageInfo.clientname : GetClientName(pageInfo.clientid) %>
</li>
</ul>

<ul>
<li>
<strong>审批状态 ：</strong><%= GetApprovedStatus(pageInfo.approved) %>
&nbsp;&nbsp;&nbsp;
<strong>审批人：</strong><%= GetLawyerName(pageInfo.approverid) %>
&nbsp;&nbsp;&nbsp;
<strong>审批时间 ：</strong><%= pageInfo.approved == 0 ? "" : pageInfo.approvedtime.ToString() %>
</li>

<li>
<strong>案件状态 ：</strong><%= GetStateName(pageInfo.stateid) %>
</li>
</ul>

<ul>
<li>
<strong>法律顾问开始时间：</strong><%= EchoDateTime(extInfo.starttime,"yyyy-MM-dd") %>
&nbsp;&nbsp;&nbsp;
<strong>法律顾问结束时间：</strong><%= EchoDateTime(extInfo.endtime,"yyyy-MM-dd") %>
</li>
<li>
<strong>创建时间：</strong><%= pageInfo.createtime.ToString() %>
&nbsp;&nbsp;&nbsp;
<strong>最近更新时间：</strong><%= pageInfo.lastmodifiedtime.ToString() %>
</li>
</ul>

<ul>
<li><strong>案件摘要：</strong><%= pageInfo.summary %>
</li>
</ul>

<ul>
<li>
<strong>律师费金额：</strong><%= extInfo.lvshifei %>元 &nbsp;&nbsp;&nbsp;<strong>办案费金额：</strong><%= extInfo.bananfei %>元
</li>
<li>
<strong>低于收费或不收费理由：</strong><%= extInfo.unpaidreason %>
</li>
</ul>

<ul>
<li>
<strong>备注：</strong> <%= extInfo.remark %>
</li>
</ul>

<p style="text-align:center">
<a href="caselist.aspx" class="btn btn-info"><i class="fa fa-arrow-left"></i> 返回案件管理列表</a>
</p>

</div>
      <!-- /.row (main row) -->

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
    <div class="modal" id="modal">
        <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
            <div class="modal-content"></div>
        </div>
    </div>

<script src="images/adminlte.min.js"></script><!-- AdminLTE App -->

<!-- AdminLTE for demo purposes -->
<script src="images/demo.js"></script>
</body>
</html>

