﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="clientlist.aspx.cs" Inherits="LawOA.Web.lawoa.clientlist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i> 退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
        <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').endsWith("clientlist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>客户管理</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">客户管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body">
<table width="100%">
  <tbody>
    <tr>
      <td style="line-height:220%;">
<form action="clientlist.aspx" method="get">      
<input type="hidden" name="t" value="search" />
关键词：<input type="text" name="searchkw" class="myinput" placeholder="" value="">
<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> 查询</button>
</form>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="box">

<div class="box-body" style="text-align:center;">
请点击表头项进行排序 
</div>
            <div class="box-body">
     
              <div class="table-responsive">
                <table class="table table-bordered no-margin table-hover">
                  <thead>
                  <tr> 
                    <th style="text-align:center">操作</th>
                    <th><a href="<%= GetThUrl("cid") %>">ID号</a></th>
                    <th><a href="<%= GetThUrl("clientname") %>">客户名称</a></th>
                    <th><a href="<%= GetThUrl("clientlinkman") %>">联系人</a></th>
                    <th><a href="<%= GetThUrl("legalrepresentative") %>">法定代表人</a></th>
                    <th><a href="<%= GetThUrl("starttime") %>">业务开始时间</a></th>
                    <th><a href="<%= GetThUrl("tel") %>">电话</a></th>
                    <th><a href="<%= GetThUrl("mobilelegalrepresentative") %>">法定代表人手机</a></th>
                    <th><a href="<%= GetThUrl("mobilelinkman") %>">联系人手机</a></th>			
                  </tr>
                  </thead>
                  <tbody>
                <% foreach (var info in clientList)
                     { %>
                  <tr>
                    <td align="left" valign="middle" class="tablenowrap">
<a class="btn btn-primary btn-xs" href="clientview.aspx?cid=<%= info.cid %>" data-toggle="modal" data-target="#modal" style="display:none"><i class="fa fa-hand-pointer-o"></i> 查看</a> 
<a class="btn btn-info btn-xs" href="clientedit.aspx?t=edit&cid=<%= info.cid %>"><i class="fa fa-edit"></i> 编辑</a> 
<% if (loginLawyer.userlevel > 3)
    { %>
<a class="btn btn-danger btn-xs"  href="clientlist.aspx?t=del&cid=<%= info.cid %>" onclick="return confirm('确认删除？')"><i class="fa fa-trash-o"></i> 删除</a>
<% } %>
                    </td>
                    <td><%= info.cid %></td>
                    <td><a href="clientview.aspx?cid=<%= info.cid %>" data-toggle="modal" data-target="#modal"><%= info.clientname %></a></td>
                    <td><%= info.clientlinkman %></td>
                    <td><%= info.legalrepresentative %></td>
                    <td><%= info.starttime.ToString("yyyy/MM/dd") %></td>
                    <td><%= info.tel %></td>
                    <td><%= info.mobilelegalrepresentative %></td>
                    <td><%= info.mobilelinkman %></td>
                  </tr>
                  <% } %>                 
                  </tbody>
                </table>
              </div>
            </div>
            <div class="box-footer clearfix">
                <%= PagerHtml %>
            </div>
        </div>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
    <div class="modal" id="modal">
        <div class="modal-dialog" style="width:600px; margin:1% auto 0 auto; max-width:1000px">
            <div class="modal-content"></div>
        </div>
    </div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
