﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="config.aspx.cs" Inherits="LawOA.Web.lawoa.config" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("config.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>系统参数设置</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">系统参数设置</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body casepage">
<form action="?action=save" method="post">
<table class="table">
                  <tbody>
<tr>
    <td style="width:150px;"><strong>登陆公共密钥</strong> ：</td>
    <td><input type="text" name="publickey" class="myinput" placeholder="请设置公共密钥" value="<%= configInfo.PublicLoginKey %>"></td>
</tr>
<tr>
    <td><strong>系统名称</strong> ：</td>
    <td><input type="text" name="SysTitle" class="myinput" placeholder="系统名称全称" value="<%= configInfo.SysTitle %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>系统简称</strong> ：</td>
    <td><input type="text" name="SysShortTitle" class="myinput" placeholder="系统名称简称" value="<%= configInfo.SysShortTitle %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>登陆页的系统名称</strong> ：</td>
    <td><input type="text" name="LoginTitle" class="myinput" placeholder="登陆页的系统名称" value="<%= configInfo.LoginTitle %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>案件编号前缀</strong> ：</td>
    <td><input type="text" name="CaseSNPrestr" class="myinput" placeholder="案件编号前缀，一旦确定请莫更改" value="<%= configInfo.CaseSNPrestr %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>可选的起止年份</strong> ：</td>
    <td><input type="text" name="StartSelectYear" class="myinput" placeholder="开始年份" value="<%= configInfo.StartSelectYear %>" style="width:50px;"> 至 <input type="text" name="EndSelectYear" class="myinput" placeholder="结束年份" value="<%= configInfo.EndSelectYear %>" style="width:50px;"></td>
</tr>
<tr style="display:none">
    <td><strong>API访问安全码</strong> ：</td>
    <td><input type="text" name="SendMsgSafeCode" class="myinput" placeholder="" value="<%= configInfo.SendMsgSafeCode %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>印章类型</strong> ：</td>
    <td><input type="text" name="SealCate" class="myinput" placeholder="" value="<%= configInfo.SealCate %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>请假类型</strong> ：</td>
    <td><input type="text" name="VacateCate" class="myinput" placeholder="" value="<%= configInfo.VacateCate %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>发票类型</strong> ：</td>
    <td><input type="text" name="InvoicCate" class="myinput" placeholder="" value="<%= configInfo.InvoicCate %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>收入类型</strong> ：</td>
    <td><input type="text" name="IncomeCate" class="myinput" placeholder="" value="<%= configInfo.IncomeCate %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>支出类型</strong> ：</td>
    <td><input type="text" name="ExpenseCate" class="myinput" placeholder="" value="<%= configInfo.ExpenseCate %>" style="width:50%;"></td>
</tr>
<tr>
    <td><strong>收支方式</strong> ：</td>
    <td><input type="text" name="IEModeCate" class="myinput" placeholder="" value="<%= configInfo.IEModeCate %>" style="width:50%;"></td>
</tr>

</tbody>
 </table>
<p style="text-align:center">
<button type="submit" class="btn btn-danger"><i class="fa fa-save"></i> 保 存</button>
</p>
</form>
</div>

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
