﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="employeecontactlist.aspx.cs" Inherits="LawOA.Web.lawoa.employeecontactlist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>
    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i> 退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("employeecontactlist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>共享通讯录</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">共享通讯录</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body">
<div class="chartclass">
<%= GetTopNavHtml() %>
</div>
</div>　 　 　 　 　 　　
     
<div class="box">
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                    <th>姓名</th>
                    <th>性别</th>
                    <th>所在部门</th>
                    <th>职务名称</th>
                    <th>手机号码</th>
                    <th>办公电话</th>
                    <th>QQ号码</th>
                    <th>微信号码</th>
                    <th>电子邮箱</th>
                  </tr>
                  </thead>
                  <tbody>
                  <% foreach (var info in ecList){ %>
                  <tr>
                    <td><%= GetLawyerName(info.lawyerid) %></td>
                    <td><%= info.sex %></td>
                    <td><%= info.department %></td>
                    <td><%= info.position %></td>
                    <td><%= info.mobilephone %></td>
                    <td><%= info.telphone %></td>
                    <td><%= info.qqnumber %></td>
                    <td><%= info.wxnumber %></td>
                    <td><%= info.email %></td>
                  </tr>
                  <% } %>                  
                  </tbody>
                </table>
              </div>
            </div>
            <div class="box-footer clearfix">
                <%= PagerHtml %>
            </div>
        </div>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:600px; margin:1% auto 0 auto; max-width:1000px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
