﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="incomeexpenselist.aspx.cs" Inherits="LawOA.Web.lawoa.incomeexpenselist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>
    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i> 退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         var ahref = $(this).attr('href');
         var aso = "ietype=1";
         if(window.location.search.indexOf("ietype=1")>0)
         {
             aso = "ietype=1";
         }
         else if (window.location.search.indexOf("ietype=2")>0)
         {
             aso = "ietype=2";
          }

         if(ahref.indexOf(aso)>0) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small><%= ietype == 1 ?"收入管理":"支出管理" %></small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active"><%= ietype == 1 ?"收入管理":"支出管理" %></li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body">
<div class="chartclass">
<%= GetTopNavHtml() %>
</div>
</div>　 　 　 　 　 　　
     
<div class="box">
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                   <th>操作</th>
                    <th>负责人</th>
                    <th>关联案件</th>
                    <th>关联客户</th>
                    <th><%= ietype == 1 ?"收入":"支出" %>类型</th>
                    <th><%= ietype == 1 ?"收入":"支出" %>方式</th>
                    <th><%= ietype == 1 ?"收入":"支出" %>金额</th>
                    <th>备注</th>
                    <th>录入时间</th>
                    <th>确认情况</th>
                  </tr>
                  </thead>
                  <tbody>
                  <% foreach (var info in ieList){ %>
                  <tr>
                  <td align="left" class="tablenowrap">
<% if (loginLawyer.userlevel >= 10)
    {
        var ietypestr = ietype == 1 ? "到账" : "支出";
        %>
     
<a class="btn btn-success btn-xs" href="incomeexpenselist.aspx?ieid=<%= info.ieid %>&t=qrok&ietype=<%= ietype %>" title="确认已<%=ietypestr %>" onclick="return confirm('确认已<%=ietypestr %>？')"><i class="fa fa-check"></i> 确认<%=ietypestr %></a>
<a class="btn btn-warning btn-xs" href="incomeexpenselist.aspx?ieid=<%= info.ieid %>&t=qrno&ietype=<%= ietype %>" title="确认未<%=ietypestr %>" onclick="return confirm('确认未<%=ietypestr %>？')"><i class="fa fa-remove"></i> 未<%=ietypestr %></a> <br />
<% } %>
 <% if(info.verify != 1) { %>
<a class="btn btn-info btn-xs" href="incomeexpenseedit.aspx?t=edit&ieid=<%= info.ieid %>&ietype=<%= ietype %>"<%= loginLawyer.lid == info.lawyerid ? "":" style='display:none'" %>><i class="fa fa-edit"></i> 编辑</a>
<a class="btn btn-danger btn-xs"  href="incomeexpenselist.aspx?t=del&ieid=<%= info.ieid %>&ietype=<%= ietype %>" onclick="return confirm('删除收支记录不能恢复，确认删除？')"<%= loginLawyer.lid == info.lawyerid ? "":" style='display:none'" %>><i class="fa fa-trash-o"></i> 删除</a> 
 <% } %>
                      </td>
                    <td><%= GetLawyerName(info.lawyerid) %></td>
                    <td><%= GetLawCaseBrief(info.caseid) %></td>
                    <td><%= GetClientName(info.clientid) %></td>
                    <td><%= info.iecate %></td>
                    <td><%= info.iemode %></td>
                    <td><%= info.moneycount %></td>
                    <td><%= info.remark %></td>
                    <td><%= info.pubdate.ToString("yyyy-MM-dd") %></td>
                    <td><%= GetVerifyInfo(info) %></td>
                  </tr>
                  <% } %>                  
                  </tbody>
                </table>
              </div>
            </div>
            <div class="box-footer clearfix">
                <%= PagerHtml %>
            </div>
        </div>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:600px; margin:1% auto 0 auto; max-width:1000px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>
