﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="index.aspx.cs" Inherits="LawOA.Web.lawoa.index" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
<header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
</header>

<aside class="main-sidebar">
    <section class="sidebar">
<script>
$(function(){
    $(".sidebar-menu li").click(function() {
        $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
        $(this).addClass('active');//添加当前元素的样式
    });
});
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>管理首页</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">管理首页</li>
      </ol>
    </section>
<section class="content container-fluid">

<section class="content">
      <!-- Small boxes (Stat box) -->
      <div class="row">
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-aqua">
            <div class="inner">
              <h3><%= pageInfo.NoApprovedCaseList.Count %></h3>
              <p>个案件待审批</p>
            </div>
            <div class="icon">
              <i class="fa fa-list-alt"></i>
            </div>
            <a href="caselist.aspx?action=viewsp&vt=sp&t=dsp" class="small-box-footer">进入案件审批 <i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-green">
            <div class="inner">
              <h3><%= pageInfo.NoApprovedSealList.Count %></h3>
              <p>个用章待审批</p>
            </div>
            <div class="icon">
              <i class="fa fa-bullseye"></i>
            </div>
            <a href="seallist.aspx?c=dsp" class="small-box-footer">进入用章审批 <i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-yellow">
            <div class="inner">
              <h3><%= pageInfo.NoApprovedVacateCount %></h3>
              <p>个请假待审批</p>
            </div>
            <div class="icon">
              <i class="fa fa-floppy-o"></i>
            </div>
            <a href="vacatelist.aspx" class="small-box-footer">进入请假审批 <i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
            <div class="inner">
              <h3><%= pageInfo.NoApprovedInvoiceCount %></h3>
              <p>个发票申请待处理</p>
            </div>
            <div class="icon">
              <i class="fa fa-calendar-minus-o"></i>
            </div>
            <a href="invoicelist.aspx" class="small-box-footer">进入发票管理 <i class="fa fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <!-- ./col -->
      </div>
      <!-- /.row -->
      <!-- Main row -->
          
          <div class="box" style="display:none">
             <% var flgwList = pageInfo.FlgwRemindList; %>
            <div class="box-header">
              <h3 class="box-title"><%= pageInfo.FlgwRemindCount %>个法律顾问合同即将到期</h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                    <th>操作</th>
                    <th>审批人</th>
                    <th>审批时间</th>
                    <th>到期日期</th>  
                    <th>ID</th>
                    <th>案件编号</th>
                    <th>案由</th>
                    <th>主办律师</th>
                    <th>协办律师</th>
                  </tr>
                  </thead>
                  <tbody>
               <% foreach (var info in flgwList) { %>
                  <tr>
                    <td>
<a class="btn btn-primary btn-xs" href="caseview_<%= CaseCatFirstLetter(GetCateName(info.catid)) %>.aspx?cid=<%= info.cid %>"><i class="fa fa-hand-pointer-o"></i> 查看</a> 
<a class="btn btn-info btn-xs" href="caseedit_<%= CaseCatFirstLetter(GetCateName(info.catid)) %>.aspx?t=edit&catid=<%= info.catid %>&cid=<%= info.cid %>"><i class="fa fa-edit"></i> 编辑</a> 
                    </td>
                    <td><%= GetLawyerName(info.approverid) %></td>
                    <td><%= info.approvedtime.ToString() %></td>
                    <td><%= pageInfo.GetFlgwEnddate(info) %></td>
                    <td><%= info.cid %></td>
                    <td><%= info.serialnumber %></td>
                    <td><%= info.brief %></td>
                    <td><%= GetLawyerName(info.lawyerid) %></td>
                    <td><%= GetLawyerName(info.colawyerid) %></td>
                  </tr> 
               <% } %>
                  </tbody>
                </table>
              </div>
              <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
              <a href="caselist.aspx" class="btn btn-sm btn-default btn-flat pull-right">查看更多</a>
            </div>
            <!-- /.box-footer -->
          </div>

         <% var remindList = pageInfo.RemindList; %>
         <div class="box">
            <div class="box-header">
              <h3 class="box-title">我的提醒 <a href="#" style="font-size:9pt;color:#708090;font-weight:normal;"><i class="fa fa-arrow-circle-o-right"></i> <%= remindList.Count %>个提醒</a></h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead style="display:none">
                  <tr>
                    <th>提醒信息</th>
                    <th>操作</th>
                  </tr>
                  </thead>
                  <tbody>
                  <% foreach (var remindMsg in remindList) { %>
                  <tr>
                    <td><%= remindMsg.RemindMsg %></td>
                    <td>
                        <% if (remindMsg.ViewUrl != "")
    { %>
<a class="btn btn-primary btn-xs" <%= remindMsg.IsModalView?"data-target=\"#modal\" data-toggle=\"modal\"":"" %> href="<%= remindMsg.ViewUrl %>"><i class="fa fa-hand-pointer-o"></i> 查看</a>
<% }
    else
    {%>
<a class="btn btn-primary btn-xs" href="caseview_<%= CaseCatFirstLetter(GetCateName(remindMsg.catid)) %>.aspx?cid=<%= remindMsg.cid %>"><i class="fa fa-hand-pointer-o"></i> 查看</a>  
<% } %>
                    </td>
                  </tr>
                  <% } %>
                  </tbody>
                </table>
              </div>
              <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix" style="display:none">
              <a href="caselist.aspx" class="btn btn-sm btn-default btn-flat pull-right">查看更多</a>
            </div>
            <!-- /.box-footer -->
          </div>

         <% var announcementList = pageInfo.LatestAnnouncementList; %>
         <div class="box"<%= announcementList.Count>0 ? "":" style=display:none" %>>
            <div class="box-header">
              <h3 class="box-title">通知公告 <a href="announcementlist.aspx" style="font-size:9pt;color:#708090;font-weight:normal;"><i class="fa fa-arrow-circle-o-right"></i>浏览更多</a></h3>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div class="table-responsive">
                <table class="table no-margin table-hover">
                  <thead>
                  <tr>
                    <th>标题</th>
                    <th>发布时间</th>
                    <th>发布人</th>
                  </tr>
                  </thead>
                  <tbody>
                  <% foreach (var info in announcementList) { %>
                  <tr>
                    <td><a href="announcementview.aspx?aid=<%= info.aid %>" data-target="#modal" data-toggle="modal"><i class="fa fa-feed"></i> <%= info.title %></a></td>
                    <td><%= info.pubdate.ToString() %></td>
                    <td><%= GetLawyerName(info.lawyerid) %></td>
                  </tr>
                  <% } %>
                  </tbody>
                </table>
              </div>
              <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix" style="display:none">
              <a href="caselist.aspx" class="btn btn-sm btn-default btn-flat pull-right">查看更多</a>
            </div>
            <!-- /.box-footer -->
          </div>
          
      <!-- /.row (main row) -->
    </section>
</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:80%; margin:2% auto 0 auto; max-width:1000px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
</body>
</html>
