﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="invoiceedit.aspx.cs" Inherits="LawOA.Web.lawoa.invoiceedit" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
  <script src="validate/jquery.validate.min.js"></script>
 <script src="validate/messages_zh.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });
    $().ready(function () {
        $("#clientForm").validate();
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("invoicelist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>发起/编辑发票申请</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">发票管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      
<div class="box box-body casepage">
<form name="clientForm" action="?action=save&t=<%= paget %>&iid=<%= pageid %>" method="post">
<table class="table">
                  <tbody>
                    <tr>
                      <td style="width:140px;"><strong>申请人</strong> ：</td>
                      <td><%= loginLawyer.username %></td>
                    </tr>
                    <tr>
                      <td><strong>发票用途</strong> ：</td>
                      <td><input type="text" name="purpose" class="myinput" placeholder="请输入发票用途" value="<%= pageInfo.purpose %>" style="width:250px;" required></td>
                    </tr>
                    <tr>
                      <td><strong>发票金额</strong> ：</td>
                      <td><input type="text" name="moneycount" class="myinput" placeholder="请输入发票金额" value="<%= pageInfo.moneycount %>" style="width:250px;" required></td>
                    </tr>
                    <tr>
                      <td><strong>发票类型</strong> ：</td>
                      <td>
                          <select name="icate" class="myinput">
                              <%= OutputInvoicCatOptions(pageInfo.icate) %>
                          </select>
                      </td>
                    </tr>
                    <tr>
                      <td><strong>发票名称</strong> ：</td>
                      <td><input type="text" name="title" class="myinput" placeholder="请输入发票名称" value="<%= pageInfo.title %>" style="width:250px;" required></td>
                    </tr>
                    <tr>
                      <td><strong>纳税人识别号</strong> ：</td>
                      <td><input type="text" name="taxpayernumber" class="myinput" placeholder="请输入纳税人识别号" value="<%= pageInfo.taxpayernumber %>" style="width:250px;" required></td>
                    </tr>
                    <tr>
                      <td><strong>开户银行</strong> ：</td>
                      <td><input type="text" name="bankofdeposit" class="myinput" placeholder="请输入开户银行" value="<%= pageInfo.bankofdeposit %>" style="width:250px;"></td>
                    </tr>
                    <tr>
                      <td><strong>银行账号</strong> ：</td>
                      <td><input type="text" name="bankaccount" class="myinput" placeholder="请输入银行账号" value="<%= pageInfo.bankaccount %>" style="width:250px;"></td>
                    </tr>
                    <tr>
                      <td><strong>地址</strong> ：</td>
                      <td><input type="text" name="address" class="myinput" placeholder="请输入地址" value="<%= pageInfo.address %>" style="width:250px;"></td>
                    </tr>
                    <tr>
                      <td><strong>电话</strong> ：</td>
                      <td><input type="text" name="tel" class="myinput" placeholder="请输入电话" value="<%= pageInfo.tel %>" style="width:250px;"></td>
                    </tr>
                    <tr>
                      <td><strong>备注</strong>：</td>
                      <td>
                          <textarea class="myinput" name="remark" placeholder="以上未尽事宜，请填写在此(如开票项目，单位，数量，单价等等)" style="width:75%;"><%= pageInfo.remark %></textarea>
                      </td>
                    </tr>
                  </tbody>
                </table>

<p style="text-align:center">
<button type="submit" class="btn btn-danger"><i class="fa fa-save"></i> 保 存</button>
</p>
</form>
</div>

</section>
</div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/bootstrap-datepicker.js"></script>
<script>  
    $(function () {
    //Date picker
    $('#datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
		
	$('.datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
  })
</script>
<script src="images/demo.js"></script>
</body>
</html>
