﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="lawyeredit.aspx.cs" Inherits="LawOA.Web.lawoa.layeredit" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i> 退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("lawyeredit.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>新增/编辑律师</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">律师管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body casepage">
<form action="?action=save&t=<%= paget %>&lid=<%= pageid %>" method="post">
<table class="table">
<tbody>
<tr>
    <td style="width:130px;"><strong>所中身份</strong> ：</td>
    <td><input type="radio" id="userlevel3" name="userlevel" class="myradiobox" value="3" <%= pageInfo.userlevel == 3 ? "checked":"" %> /> <label for="userlevel3"></label> 律师  &nbsp;
<input type="radio" id="userlevel10" name="userlevel" class="myradiobox" value="10" <%= pageInfo.userlevel == 10 ? "checked":"" %> /> <label for="userlevel10"></label> 合伙人 &nbsp;</td>
</tr>
<tr>
    <td><strong>律师姓名</strong> ：</td>
    <td><input type="text" id="username" name="username" class="myinput" placeholder="" value="<%= pageInfo.username %>"></td>
</tr>
<tr style='<%= paget=="add" ? "":"display:none" %>'>
    <td><strong>密码</strong> ：</td>
    <td><input type="text" name="userpassword" class="myinput" placeholder="" value=""></td>
</tr>
<tr style="display:none">
    <td><strong>企微账号</strong> ：</td>
    <td><input type="text" name="qywxid" class="myinput" placeholder="" value="<%= pageInfo.qywxid %>"></td>
</tr>
<tr>
    <td><strong>身份证号码</strong> ：</td>
    <td><input type="text" name="idcardno" class="myinput" placeholder="" value="<%= pageInfo.idcardno %>"></td>
</tr>
<tr>
    <td><strong>资格证号码</strong> ：</td>
    <td><input type="text" name="qualificationid" class="myinput" placeholder="" value="<%= pageInfo.qualificationid %>"></td>
</tr>
<tr>
    <td><strong>执业证号码</strong> ：</td>
    <td><input type="text" name="certifiedid" class="myinput" placeholder="" value="<%= pageInfo.certifiedid %>"></td>
</tr>
<tr>
    <td><strong>住址</strong> ：</td>
    <td><input type="text" name="address" class="myinput" placeholder="" value="<%= pageInfo.address %>"></td>
</tr>
<tr>
    <td><strong>电话</strong> ：</td>
    <td><input type="text" name="tel" class="myinput" placeholder="" value="<%= pageInfo.tel %>"></td>
</tr>
<tr>
    <td><strong>手机</strong> ：</td>
    <td><input type="text" name="mobile" class="myinput" placeholder="" value="<%= pageInfo.mobile %>"></td>
</tr>
<tr>
    <td><strong>Email</strong> ：</td>
    <td><input type="text" name="email" class="myinput" placeholder="" value="<%= pageInfo.email %>"></td>
</tr>
<tr>
    <td><strong>入职时间</strong> ：</td>
    <td><input type="text" name="starttime" class="myinput datepicker" id="" value="<%= pageInfo.starttime.ToString("yyyy-MM-dd") %>"></td>
</tr>
<tr style='<%= paget=="add" ? "display:none":"" %>'>
    <td><strong>是否离职</strong> ：</td>
    <td><input type="radio" id="leavepostyes" name="leavepost" value="true" class="myradiobox" <%= pageInfo.leavepost ? "checked":"" %> /> <label for="leavepostyes"></label> 已离职  &nbsp;
<input type="radio" id="leavepostno" name="leavepost" value="false" class="myradiobox" <%= pageInfo.leavepost ? "":"checked" %> /> <label for="leavepostno"></label> 未离职 &nbsp;</td>
</tr>
<tr style='<%= paget=="add" ? "display:none":"" %>'>
    <td><strong>离职时间</strong> ：</td>
    <td><input type="text" name="endtime" class="myinput datepicker" id="" value="<%= pageInfo.leavepost ? pageInfo.endtime.ToString("yyyy/MM/dd") : "" %>"> (未离职则不填)</td>
</tr>
<tr>
    <td><strong>简介</strong> ：</td>
    <td><textarea class="myinput" name="intro" style="width:50%;"><%= pageInfo.intro %></textarea></td>
</tr>
<tr>
    <td><strong>备注</strong> ：</td>
    <td><textarea class="myinput" name="remark" style="width:50%;"><%= pageInfo.remark %></textarea></td>
</tr>
</tbody>
</table>

<p style="text-align:center">
<button type="submit" class="btn btn-danger"><i class="fa fa-save"></i> 保 存</button>
</p>
</form>
</div>

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
    <div class="modal" id="modal">
        <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1600px">
            <div class="modal-content"></div>
        </div>
    </div>

<script src="images/adminlte.min.js"></script>
<script src="images/bootstrap-datepicker.js"></script>
<script>  
    $(function () {
    //Date picker
    $('#datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
		
	$('.datepicker').datepicker({
        autoclose: true,
        format: 'yyyy-mm-dd'
    })
  })
</script>

<script src="images/demo.js"></script>
</body>
</html>
