﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="lawyerlist.aspx.cs" Inherits="LawOA.Web.lawoa.layerlist" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });

$(document).ready(function(){
   $(".sidebar-menu").tree();
   $(".sidebar-menu").filter(".menu-open").removeClass("menu-open");
   $(".sidebar-menu").filter(".active").removeClass("active");
   var a;
   $(".sidebar-menu a").each(function(i){
         if($(this).attr('href').startsWith("lawyerlist.aspx")) {
              a=$(this);
          }
    });
    a.parent().addClass("active");
    a.parent().parent().parent().addClass("active");
    a.parent().parent().parent().addClass("menu-open");
})
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

<!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>律师管理</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">律师管理</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body">
<table width="100%">
  <tbody>
    <tr>
      <td style="line-height:220%;">
<form action="?t=search" method="get">      
律师姓名：<input type="text" name="searchkw" class="myinput" placeholder="" value="">
<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-search"></i> 查询</button>
</form>
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="box">

<div class="box-body" style="text-align:center;color:red">
提示：系统正式投入运行后，如账号不再使用，可设为离职状态，切莫删除。
</div>
            <!-- /.box-header -->
            <div class="box-body">
     
              <div class="table-responsive">
                <table class="table table-bordered  no-margin table-hover">
                  <thead>
                  <tr>
                    <th style="text-align:center">操作</th>
                    <th>姓名</th>
                    <th>所中身份</th>
                    <th>身份证号码</th>
                    <th>资格证号码</th>
                    <th>执业证号码</th>
                    <th>手机</th>
                    <th>入职时间</th>
                    <th>是否在职</th>
                  </tr>
                  </thead>
                  <tbody>
                 <% foreach (var info in lawyerList)
                     { %>
                  <tr>
                    <td align="right" valign="middle" class="tablenowrap">
<a class="btn btn-primary btn-xs" href="lawyerview.aspx?lid=<%= info.lid %>" data-toggle="modal" data-target="#modal" style="display:none"><i class="fa fa-hand-pointer-o"></i> 查看</a> 
<a class="btn btn-info btn-xs" href="lawyeredit.aspx?t=edit&lid=<%= info.lid %>"><i class="fa fa-edit"></i> 编辑</a> 
<a class="btn btn-info btn-xs" href="lawyerlist.aspx?t=resetpwd&lid=<%= info.lid %>" onclick="return confirm('确认把<%= info.username %>的登陆密码重置为888888？')"><i class="fa fa-history"></i> 重置密码</a>
<a class="btn btn-danger btn-xs"  href="lawyerlist.aspx?t=del&lid=<%= info.lid %>" onclick="return confirm('账号投入使用后不可删除，否则可能导致系统异常，如需停用账号可设为离职状态，确认删除？')"><i class="fa fa-trash-o"></i> 删除</a>
                    </td>
                    <td><a  href="lawyerview.aspx?lid=<%= info.lid %>" data-toggle="modal" data-target="#modal"><%= info.username %></a></td>
                    <td><%= info.userlevel == 10 ? "合伙人" : "律师" %></td>
                    <td><%= info.idcardno %></td>
                    <td><%= info.qualificationid %></td>
                    <td><%= info.certifiedid %></td>
                    <td><%= info.mobile %></td>	
                    <td><%= info.starttime.ToString("yyyy/MM/dd") %></td>
                    <td><%= info.leavepost ? "离职" : "在职" %></td>
                  </tr>
                 <% } %>             
                  </tbody>
                </table>
              </div>
              <!-- /.table-responsive -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
                <%= PagerHtml %>
            </div>
            <!-- /.box-footer -->
        </div>
      <!-- /.row (main row) -->

</section>
  </div>
<!-- 右侧内容e -->
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:650px; margin:1% auto 0 auto; max-width:1000px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
</body>
</html>