﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sealdoc.aspx.cs" Inherits="LawOA.Web.lawoa.sealdoc" %>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
  <title>律师事务所管理系统</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="images/bootstrap.min.css">
  <link rel="stylesheet" href="images/font-awesome.min.css">
  <link rel="stylesheet" href="images/ionicons.min.css">
  <link rel="stylesheet" href="images/AdminLTE.css">
  <link rel="stylesheet" href="images/skin-blue.min.css">
  <link rel="stylesheet" href="images/blue.css">
  <script src="images/jquery.min.js"></script>
  <script src="images/bootstrap.min.js"></script>
  <script src="fileinput/js/fileinput.min.js"></script>
  <script src="fileinput/js/locales/zh.js"></script>
  <link rel="stylesheet" href="fileinput/css/fileinput.min.css">
  <script src="fileinput/themes/explorer-fa/theme.min.js" type="text/javascript"></script>
  <link rel="stylesheet" href="fileinput/themes/explorer-fa/theme.min.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <header class="main-header">
    <a class="logo">
      <span class="logo-mini"><b><%= OAConfig.SysShortTitle %></b></span>
      <span class="logo-lg"><b><%= OAConfig.SysTitle %></b></span>
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">菜单</span>
      </a>
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <li class="dropdown user user-menu">
              <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user-circle"></i>欢迎您：<%= loginLawyer.username %>（<%= LawyerLevelView(loginLawyer.userlevel) %>）</a>
              <ul class="dropdown-menu">
              <li>
                <ul class="menu nav" style="background-color:#3c8dbc">
                    <li><a href="modifypwd.aspx" class="dropdown-toggle"><i class="fa fa-file-text-o"></i> 修改密码</a></li>
                </ul>
              </li>
            </ul>
          </li>
          <li class="dropdown user user-menu">
            <a href="logout.aspx" class="dropdown-toggle">
              <i class="fa fa-power-off"></i>退出系统
            </a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <aside class="main-sidebar">
    <section class="sidebar">
<script>
    $(function () {
        $(".sidebar-menu li").click(function () {
            $(this).siblings('li').removeClass('active');  //删除其他兄弟元素的样式
            $(this).addClass('active');//添加当前元素的样式
        });
    });
</script>
        <%= OutputLeftMenu() %>
    </section>
  </aside>

  <!-- 右侧内容s -->
  <div class="content-wrapper">
    <section class="content-header">
      <h1><small>上传印章附件</small></h1>
      <ol class="breadcrumb">
        <li><i class="fa fa-home"></i> <%= OAConfig.SysTitle %></li>
        <li class="active">印章附件</li>
      </ol>
    </section>
<section class="content container-fluid">
      <!-- Main row -->
      
<div class="box box-body casepage">
<ul>
<li><b>申请理由：</b><%= sealInfo.title %></li>
</ul>

<ul>
<h5><b>附件管理：</b></h5>
<form enctype="multipart/form-data">
        <div class="file-loading">
            <input id="sealfiles" name="sealfiles" type="file" multiple>
        </div>
</form>
</ul>
<p>
<a href="seallist.aspx" class="btn btn-default">上传完成后可点此返回印章管理</a>
</p>

</div>
</section>
</div>
</div>

<!-- 页面中的弹层代码 -->
<div class="modal" id="modal">
    <div class="modal-dialog" style="width:96%; margin:6% auto 0 auto; max-width:1200px">
        <div class="modal-content"></div>
    </div>
</div>

<script src="images/adminlte.min.js"></script>
<script src="images/demo.js"></script>
<script>
    $("#sealfiles").fileinput({
        language: 'zh',
        uploadUrl: "upload_ajax.ashx?action=upsealfile&sid=<%= sealInfo.sid %>",
        theme: 'explorer-fa',
        showUpload: true,
        showCaption: true,
        uploadAsync: true,
        overwriteInitial: false,
        preferIconicPreview: true,
        allowedPreviewTypes: null,
        allowedFileExtensions: ["doc", "docx", "ppt", "xlsx","xls","jpg","jpeg","png","rar","zip","pdf","txt"],
        initialPreview: [<%=initialPreview%>],
        initialPreviewConfig: [<%=initialPreviewConfig%>]
    });
</script>
</body>
</html>
